% // h1 example: L. Schubert's mansion murder puzzle.
%   Copyright (C) 2004 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
%   This file is part of h1.
%
%   h1 is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2, or (at your option)
%   any later version.
%
%   h1 is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with h1; see the file COPYING.  If not, write to
%   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

input_clause(agatha_in_mansion, axiom,
[++in_mansion(agatha)]).

input_clause(butler_in_mansion, axiom,
[++in_mansion(butler)]).

input_clause(charles_in_mansion, axiom,
[++in_mansion(charles)]).

input_clause(killer_hates_victim, axiom,
[--killed(X,Y), ++hates(X,Y)]).

input_clause(killer_no_richer, axiom,
[--killed(X,Y), ++not_richer(X,Y)]).

input_clause(charles_hates_noone_agatha_hates, axiom,
[--hates(agatha,X), --hates(charles,X)]).

input_clause(agatha_hates_herself, axiom,
[++hates(agatha,agatha)]).

input_clause(agatha_hates_charles, axiom,
[++hates(agatha, charles)]).

input_clause(butler_hates_everyone_not_richer_than_agatha, axiom,
[--not_richer(X,agatha), ++hates(butler,X)]).

input_clause(butler_hates_everybody_agatha_hates, axiom,
[--hates(agatha,X), ++hates(butler,X)]).

input_clause(noone_hates_everyone, axiom,
[--hates(X,agatha), --hates(X,butler), --hates(X,charles)]).

#define query1(x)  x ## _killed_agatha
#define query(x) query1(x)
input_clause(query(WHO), conjecture,
[++killed(WHO,agatha)]).
