% h1 example: the Needham-Schroeder public-key protocol.
%   Copyright (C) 2003 Fabrice Parrennes and LSV, CNRS UMR 8643 & ENS Cachan.
%
%   This file is part of h1.
%
%   h1 is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2, or (at your option)
%   any later version.
%
%   h1 is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with h1; see the file COPYING.  If not, write to
%   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.



%
% Ajout des clauses du prototole
%
%

input_clause(protocol_1, axiom,
          [
          ++knows( nil )
          ]).

input_clause(protocol_2, axiom,
          [
          --knows( cons( M1 , M2 ) ),
          ++knows( M1 )
          ]).

input_clause(protocol_3, axiom,
          [
          --knows( cons( M1 , M2 ) ),
          ++knows( M2 )
          ]).

input_clause(protocol_4, axiom,
          [
          --knows( M1 ) ,
          --knows( M2 ),
          ++knows( cons( M1 , M2 ) )
          ]).

input_clause(protocol_5, axiom,
          [
          --knows( M ) ,
          --knows( K ),
          ++knows( crypt( M , K ) )
          ]).

input_clause(protocol_6, axiom,
          [
          --knows( crypt( M , pub( K ) ) ) ,
          --knows( prv( K ) ),
          ++knows( M )
          ]).

input_clause(protocol_7, axiom,
          [
          --knows( crypt( M , prv( K ) ) ) ,
          --knows( pub( K ) ),
          ++knows( M )
          ]).

input_clause(protocol_8, axiom,
          [
          --knows( crypt( M , symkey( A , B ) ) ) ,
          --knows( symkey( A , B ) ),
          ++knows( M )
          ]).

input_clause(protocol_9, axiom,
          [
          ++number( o )
          ]).

input_clause(protocol_10, axiom,
          [
          --number( N ),
          ++number( s( N ) )
          ]).

input_clause(protocol_11, axiom,
          [
          --agent( A ) ,
          --agent( B ),
          ++knows( crypt( cons( A , cons( noncea( cons( A , cons( B , nil ) ) ) , nil ) ) , pub( B ) ) )
          ]).

input_clause(protocol_12, axiom,
          [
          --knows( crypt( cons( A , cons( Na , nil ) ) , pub( B ) ) ),
          ++knows( crypt( cons( Na , cons( nonceb( cons( B , cons( A , nil ) ) ) , nil ) ) , pub( A ) ) )
          ]).

input_clause(protocol_13, axiom,
          [
          --knows( crypt( cons( noncea( cons( A , cons( B , nil ) ) ) , cons( Nb , nil ) ) , pub( A ) ) ),
          ++knows( crypt( Nb , pub( B ) ) )
          ]).

input_clause(protocol_14, axiom,
          [
          ++knows( pub( bob ) )
          ]).

input_clause(protocol_15, axiom,
          [
          ++knows( pub( alice ) )
          ]).

input_clause(protocol_16, axiom,
          [
          ++knows( pub( intrus ) )
          ]).

input_clause(protocol_17, axiom,
          [
          ++knows( prv( intrus ) )
          ]).

input_clause(protocol_18, axiom,
          [
          ++agent( alice )
          ]).

input_clause(protocol_19, axiom,
          [
          ++agent( bob )
          ]).

input_clause(protocol_20, axiom,
          [
          ++agent( intrus )
          ]).


input_clause(clause_conj, conjecture, 
 [
   --knows( nonceb( cons( bob , cons( alice , nil ) ) ) )
  ]).

