

% h1 example: the Needham-Schroeder symmetric key protocol, amended by the authors (1987).
%   Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
%   This file is part of h1.
%
%   h1 is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2, or (at your option)
%   any later version.
%
%   h1 is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with h1; see the file COPYING.  If not, write to
%   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

% run 'cpp -P anspriv.p >ansp.p'

cnf(alice_agent,axiom,
    (agent(alice))).
cnf(bob_agent,axiom,
    (agent(bob))).
cnf(server_agent,axiom,
    (agent(server))).
cnf(intruder_agent,axiom,
    (agent(i))).

% h1 example: the Needham-Schroeder symmetric key protocol, amended by the authors (1987).
%   Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
%   This file is part of h1.
%
%   h1 is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2, or (at your option)
%   any later version.
%
%   h1 is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with h1; see the file COPYING.  If not, write to
%   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.


cnf(intruder_knows_nil ## _old,axiom,
  (knows ## _old(nil))).
cnf(intruder_can_take_first_components ## _old,axiom,
  (~knows ## _old(cons(M1,M2)) | knows ## _old(M1))).
cnf(intruder_can_take_second_components ## _old,axiom,
  (~knows ## _old(cons(M1,M2)) | knows ## _old(M2))).
cnf(intruder_can_build_pairs ## _old,axiom,
  (~knows ## _old(M2) | ~knows ## _old(M1) | knows ## _old(cons(M1,M2)))).
cnf(intruder_can_encrypt ## _old,axiom,
  (~knows ## _old(K) | ~knows ## _old(M) | knows ## _old(crypt(M,K)))).
cnf(intruder_can_decrypt_if_has_private_key ## _old,axiom,
  (~knows ## _old(key(prv,K)) | ~knows ## _old(crypt(M,key(pub,K))) | knows ## _old(M))).
cnf(intruder_can_decrypt_if_has_public_key ## _old,axiom,
  (~knows ## _old(key(pub,K)) | ~knows ## _old(crypt(M,key(prv,K))) | knows ## _old(M))).
cnf(intruder_can_decrypt_if_has_symmetric_key ## _old,axiom,
  (~knows ## _old(key(sym,X)) | ~knows ## _old(crypt(M,key(sym,X))) | knows ## _old(M))).
cnf(intruder_can_compute_successors ## _old,axiom,
  (~knows ## _old(M) | knows ## _old(s(M)))).
cnf(intruder_can_compute_predecessors ## _old,axiom,
  (~knows ## _old(s(M)) | knows ## _old(M))).

%
% Ajout des clauses du protocole
%
%
   % 1. A -> B : A
cnf(message1 ## _old,axiom,
    (~agent(A) | knows ## _old(A))).
   % 2. B -> A : {A,Nb}_Kbs
cnf(message2 ## _old,axiom,
    (~knows ## _old(A)
    | ~agent(B)
    | knows ## _old(crypt(cons(A,cons(nonceb ## _old(A,B),nil)),
            key(sym,cons(B,cons(server,nil))))))).
   % 3. A -> S : A,B,Na,{A,Nb}_Kbs
   % where {A,Nb}_Kbs is copied blindly from message 2.
cnf(message3 ## _old,axiom,
    (~knows ## _old(M)
    | ~agent(A) | ~agent(B)
    | knows ## _old(cons(A,cons(B,cons(noncea ## _old(A,B),cons(M,nil))))))).
   % 4. S -> A : {Na,B,Kab,{Kab,Nb,A}_Kbs}_Kas
cnf(message4 ## _old,axiom,
  (~knows ## _old(cons(A,cons(B,cons(Na,
          cons(crypt(cons(A,cons(Nb,nil)),
                     key(sym,cons(B,cons(server,nil)))),
               nil)))))
    | knows ## _old(crypt(cons(Na,cons(B,
                  cons(key(sym,session ## _old(A,B,Na)),
                  cons(crypt(cons(key(sym,session ## _old(A,B,Na)),
                             cons(Nb,cons(A,nil))),
                             key(sym,cons(B,cons(server,nil)))),
                  nil)))),
               key(sym,cons(A,cons(server,nil))))))).
   % 5. A -> B : {Kab,Nb,A}_Kbs
   % message is blindly copied from message 4
cnf(message5 ## _old,axiom,
    (~knows ## _old(crypt(cons(noncea ## _old(A,B),cons(B,cons(Kab,cons(M,nil)))),
                  key(sym,cons(A,cons(server,nil)))))
    | knows ## _old(M))).
   % 6. B -> A : {Nb}_Kab
cnf(message6 ## _old,axiom,
    (~knows ## _old(crypt(cons(Kab,cons(nonceb ## _old(A,B),cons(A,nil))),
                  key(sym,cons(B,cons(server,nil)))))
    | knows ## _old(crypt(nonceb ## _old(A,B),Kab)))).
cnf(define_alice_key ## _old,axiom,
    (~knows ## _old(crypt(cons(noncea ## _old(A,B),cons(B,cons(Kab,cons(M,nil)))),
                  key(sym,cons(A,cons(server,nil))))) % from message 4
    | ~knows ## _old(crypt(Nb,Kab)) % from message 6
    | alice_key ## _old(A,Kab))).
   % 7. A -> B : {Nb+1}_Kab
cnf(message7 ## _old,axiom,
    (~knows ## _old(crypt(Nb,Kab))
    | ~alice_key ## _old(A,Kab)
    | knows ## _old(crypt(s(Nb),Kab)))).
cnf(define_bob_key ## _old,axiom,
    (~knows ## _old(crypt(cons(Kab,cons(nonceb ## _old(A,B),cons(A,nil))),
                  key(sym,cons(B,cons(server,nil)))))
   | ~knows ## _old(crypt(s(nonceb ## _old(A,B)),Kab))
   | bob_key ## _old(B,Kab))).

cnf(intruder_knows_all_agents ## _old,axiom,
  (~agent(X) | knows ## _old(X))).
cnf(intruder_knows_every_public_key ## _old,axiom,
  (knows ## _old(key(pub,X)))).
cnf(intruder_knows_own_private_key ## _old,axiom,
  (knows ## _old(key(prv,i)))).


cnf(intruder_remembers,axiom,
   (~knows_old(M) | knows_current(M))).

cnf(intruder_knows_all_previous_session_keys,axiom,
  (knows_current(key(sym,session_old(A,B,Na))))).
cnf(intruder_knows_all_previous_noncea,axiom,
    (knows_current(noncea_old(A,B)))).
cnf(intruder_knows_all_previous_nonceb,axiom,
    (knows_current(nonceb_old(A,B)))).

% h1 example: the Needham-Schroeder symmetric key protocol, amended by the authors (1987).
%   Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
%   This file is part of h1.
%
%   h1 is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2, or (at your option)
%   any later version.
%
%   h1 is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with h1; see the file COPYING.  If not, write to
%   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.


cnf(intruder_knows_nil ## _current,axiom,
  (knows ## _current(nil))).
cnf(intruder_can_take_first_components ## _current,axiom,
  (~knows ## _current(cons(M1,M2)) | knows ## _current(M1))).
cnf(intruder_can_take_second_components ## _current,axiom,
  (~knows ## _current(cons(M1,M2)) | knows ## _current(M2))).
cnf(intruder_can_build_pairs ## _current,axiom,
  (~knows ## _current(M2) | ~knows ## _current(M1) | knows ## _current(cons(M1,M2)))).
cnf(intruder_can_encrypt ## _current,axiom,
  (~knows ## _current(K) | ~knows ## _current(M) | knows ## _current(crypt(M,K)))).
cnf(intruder_can_decrypt_if_has_private_key ## _current,axiom,
  (~knows ## _current(key(prv,K)) | ~knows ## _current(crypt(M,key(pub,K))) | knows ## _current(M))).
cnf(intruder_can_decrypt_if_has_public_key ## _current,axiom,
  (~knows ## _current(key(pub,K)) | ~knows ## _current(crypt(M,key(prv,K))) | knows ## _current(M))).
cnf(intruder_can_decrypt_if_has_symmetric_key ## _current,axiom,
  (~knows ## _current(key(sym,X)) | ~knows ## _current(crypt(M,key(sym,X))) | knows ## _current(M))).
cnf(intruder_can_compute_successors ## _current,axiom,
  (~knows ## _current(M) | knows ## _current(s(M)))).
cnf(intruder_can_compute_predecessors ## _current,axiom,
  (~knows ## _current(s(M)) | knows ## _current(M))).

%
% Ajout des clauses du protocole
%
%
   % 1. A -> B : A
cnf(message1 ## _current,axiom,
    (~agent(A) | knows ## _current(A))).
   % 2. B -> A : {A,Nb}_Kbs
cnf(message2 ## _current,axiom,
    (~knows ## _current(A)
    | ~agent(B)
    | knows ## _current(crypt(cons(A,cons(nonceb ## _current(A,B),nil)),
            key(sym,cons(B,cons(server,nil))))))).
   % 3. A -> S : A,B,Na,{A,Nb}_Kbs
   % where {A,Nb}_Kbs is copied blindly from message 2.
cnf(message3 ## _current,axiom,
    (~knows ## _current(M)
    | ~agent(A) | ~agent(B)
    | knows ## _current(cons(A,cons(B,cons(noncea ## _current(A,B),cons(M,nil))))))).
   % 4. S -> A : {Na,B,Kab,{Kab,Nb,A}_Kbs}_Kas
cnf(message4 ## _current,axiom,
  (~knows ## _current(cons(A,cons(B,cons(Na,
          cons(crypt(cons(A,cons(Nb,nil)),
                     key(sym,cons(B,cons(server,nil)))),
               nil)))))
    | knows ## _current(crypt(cons(Na,cons(B,
                  cons(key(sym,session ## _current(A,B,Na)),
                  cons(crypt(cons(key(sym,session ## _current(A,B,Na)),
                             cons(Nb,cons(A,nil))),
                             key(sym,cons(B,cons(server,nil)))),
                  nil)))),
               key(sym,cons(A,cons(server,nil))))))).
   % 5. A -> B : {Kab,Nb,A}_Kbs
   % message is blindly copied from message 4
cnf(message5 ## _current,axiom,
    (~knows ## _current(crypt(cons(noncea ## _current(A,B),cons(B,cons(Kab,cons(M,nil)))),
                  key(sym,cons(A,cons(server,nil)))))
    | knows ## _current(M))).
   % 6. B -> A : {Nb}_Kab
cnf(message6 ## _current,axiom,
    (~knows ## _current(crypt(cons(Kab,cons(nonceb ## _current(A,B),cons(A,nil))),
                  key(sym,cons(B,cons(server,nil)))))
    | knows ## _current(crypt(nonceb ## _current(A,B),Kab)))).
cnf(define_alice_key ## _current,axiom,
    (~knows ## _current(crypt(cons(noncea ## _current(A,B),cons(B,cons(Kab,cons(M,nil)))),
                  key(sym,cons(A,cons(server,nil))))) % from message 4
    | ~knows ## _current(crypt(Nb,Kab)) % from message 6
    | alice_key ## _current(A,Kab))).
   % 7. A -> B : {Nb+1}_Kab
cnf(message7 ## _current,axiom,
    (~knows ## _current(crypt(Nb,Kab))
    | ~alice_key ## _current(A,Kab)
    | knows ## _current(crypt(s(Nb),Kab)))).
cnf(define_bob_key ## _current,axiom,
    (~knows ## _current(crypt(cons(Kab,cons(nonceb ## _current(A,B),cons(A,nil))),
                  key(sym,cons(B,cons(server,nil)))))
   | ~knows ## _current(crypt(s(nonceb ## _current(A,B)),Kab))
   | bob_key ## _current(B,Kab))).

cnf(intruder_knows_all_agents ## _current,axiom,
  (~agent(X) | knows ## _current(X))).
cnf(intruder_knows_every_public_key ## _current,axiom,
  (knows ## _current(key(pub,X)))).
cnf(intruder_knows_own_private_key ## _current,axiom,
  (knows ## _current(key(prv,i)))).


cnf(intruder_knows_session_key_generated_by_server,axiom,
  (~knows_current(key(sym,session_current(alice,bob,Na))))).
cnf(intruder_knows_session_key_as_seen_by_alice,axiom,
  (~knows_current(Kab)
  | ~alice_key_current(alice,Kab))).
cnf(intruder_knows_session_key_as_seen_by_B,axiom,
  (~knows_current(Kab)
  | ~bob_key_current(bob,Kab))).
