% h1 example: the Needham-Schroeder symmetric key protocol, amended by the authors (1987).
%   Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
%   This file is part of h1.
%
%   h1 is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2, or (at your option)
%   any later version.
%
%   h1 is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with h1; see the file COPYING.  If not, write to
%   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

#define KNOWS PHASE(knows)
#define NONCEB PHASE(nonceb)
#define NONCEA PHASE(noncea)
#define SESSION PHASE(session)
#define ALICE_KEY PHASE(alice_key)
#define BOB_KEY PHASE(bob_key)

cnf(PHASE(intruder_knows_nil),axiom,
  (KNOWS(nil))).
cnf(PHASE(intruder_can_take_first_components),axiom,
  (~KNOWS(cons(M1,M2)) | KNOWS(M1))).
cnf(PHASE(intruder_can_take_second_components),axiom,
  (~KNOWS(cons(M1,M2)) | KNOWS(M2))).
cnf(PHASE(intruder_can_build_pairs),axiom,
  (~KNOWS(M2) | ~KNOWS(M1) | KNOWS(cons(M1,M2)))).
cnf(PHASE(intruder_can_encrypt),axiom,
  (~KNOWS(K) | ~KNOWS(M) | KNOWS(crypt(M,K)))).
cnf(PHASE(intruder_can_decrypt_if_has_private_key),axiom,
  (~KNOWS(key(prv,K)) | ~KNOWS(crypt(M,key(pub,K))) | KNOWS(M))).
cnf(PHASE(intruder_can_decrypt_if_has_public_key),axiom,
  (~KNOWS(key(pub,K)) | ~KNOWS(crypt(M,key(prv,K))) | KNOWS(M))).
cnf(PHASE(intruder_can_decrypt_if_has_symmetric_key),axiom,
  (~KNOWS(key(sym,X)) | ~KNOWS(crypt(M,key(sym,X))) | KNOWS(M))).
cnf(PHASE(intruder_can_compute_successors),axiom,
  (~KNOWS(M) | KNOWS(s(M)))).
cnf(PHASE(intruder_can_compute_predecessors),axiom,
  (~KNOWS(s(M)) | KNOWS(M))).

%
% Ajout des clauses du protocole
%
%
   % 1. A -> B : A
cnf(PHASE(message1),axiom,
    (~agent(A) | KNOWS(A))).
   % 2. B -> A : {A,Nb}_Kbs
cnf(PHASE(message2),axiom,
    (~KNOWS(A)
    | ~agent(B)
    | KNOWS(crypt(cons(A,cons(NONCEB(A,B),nil)),
            key(sym,cons(B,cons(server,nil))))))).
   % 3. A -> S : A,B,Na,{A,Nb}_Kbs
   % where {A,Nb}_Kbs is copied blindly from message 2.
cnf(PHASE(message3),axiom,
    (~KNOWS(M)
    | ~agent(A) | ~agent(B)
    | KNOWS(cons(A,cons(B,cons(NONCEA(A,B),cons(M,nil))))))).
   % 4. S -> A : {Na,B,Kab,{Kab,Nb,A}_Kbs}_Kas
cnf(PHASE(message4),axiom,
  (~KNOWS(cons(A,cons(B,cons(Na,
          cons(crypt(cons(A,cons(Nb,nil)),
                     key(sym,cons(B,cons(server,nil)))),
               nil)))))
    | KNOWS(crypt(cons(Na,cons(B,
                  cons(key(sym,SESSION(A,B,Na)),
                  cons(crypt(cons(key(sym,SESSION(A,B,Na)),
                             cons(Nb,cons(A,nil))),
                             key(sym,cons(B,cons(server,nil)))),
                  nil)))),
               key(sym,cons(A,cons(server,nil))))))).
   % 5. A -> B : {Kab,Nb,A}_Kbs
   % message is blindly copied from message 4
cnf(PHASE(message5),axiom,
    (~KNOWS(crypt(cons(NONCEA(A,B),cons(B,cons(Kab,cons(M,nil)))),
                  key(sym,cons(A,cons(server,nil)))))
    | KNOWS(M))).
   % 6. B -> A : {Nb}_Kab
cnf(PHASE(message6),axiom,
    (~KNOWS(crypt(cons(Kab,cons(NONCEB(A,B),cons(A,nil))),
                  key(sym,cons(B,cons(server,nil)))))
    | KNOWS(crypt(NONCEB(A,B),Kab)))).
cnf(PHASE(define_alice_key),axiom,
    (~KNOWS(crypt(cons(NONCEA(A,B),cons(B,cons(Kab,cons(M,nil)))),
                  key(sym,cons(A,cons(server,nil))))) % from message 4
    | ~KNOWS(crypt(Nb,Kab)) % from message 6
    | ALICE_KEY(A,Kab))).
   % 7. A -> B : {Nb+1}_Kab
cnf(PHASE(message7),axiom,
    (~KNOWS(crypt(Nb,Kab))
    | ~ALICE_KEY(A,Kab)
    | KNOWS(crypt(s(Nb),Kab)))).
cnf(PHASE(define_bob_key),axiom,
    (~KNOWS(crypt(cons(Kab,cons(NONCEB(A,B),cons(A,nil))),
                  key(sym,cons(B,cons(server,nil)))))
   | ~KNOWS(crypt(s(NONCEB(A,B)),Kab))
   | BOB_KEY(B,Kab))).

cnf(PHASE(intruder_knows_all_agents),axiom,
  (~agent(X) | KNOWS(X))).
cnf(PHASE(intruder_knows_every_public_key),axiom,
  (KNOWS(key(pub,X)))).
cnf(PHASE(intruder_knows_own_private_key),axiom,
  (KNOWS(key(prv,i)))).

#undef KNOWS
#undef NONCEB
#undef NONCEA
#undef SESSION
#undef ALICE_KEY
#undef BOB_KEY
