(* [sigd] Signature definition. *)

Inductive term : Set :=
    alice : term
  | bob : term
  | cons : term -> term -> term
  | crypt : term -> term -> term
  | f1 : term -> term -> term -> term
  | f2 : term -> term -> term
  | f3 : term -> term -> term
  | f4 : term -> term -> term
  | f5 : term -> term -> term
  | h : term -> term
  | i : term
  | key : term -> term -> term
  | nai : term -> term
  | nil : term
  | nonces_current : term -> term -> term -> term
  | nonces_old : term -> term -> term -> term
  | prv : term
  | pub : term
  | request_id : term
  | respond_id : term
  | s : term -> term
  | server : term
  | session_current : term -> term -> term -> term
  | session_old : term -> term -> term -> term
  | success : term
  | sym : term
.

(* [modd] Model definition. *)

Inductive auto_server_keys_old : term -> term -> term -> Prop :=
    trans_server_keys_old_1 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_server_keys_old X1 X2 X3
  | trans_server_keys_old_2 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_server_keys_old X1 X2 X3
  | trans_server_keys_old_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_server_keys_old X1 X2 X3
with auto_knows_old : term -> Prop :=
    trans_knows_old_session_current_1 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_old (session_current X1 X2 X3)
  | trans_knows_old_session_current_2 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_old (session_current X1 X2 X3)
  | trans_knows_old_session_current_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_old (session_current X1 X2 X3)
  | trans_knows_old_session_current_4 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_old (session_current X1 X2 X3)
  | trans_knows_old_session_current_5 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_old (session_current X1 X2 X3)
  | trans_knows_old_session_current_6 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_old (session_current X1 X2 X3)
  | trans_knows_old_session_current_7 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_old (session_current X1 X2 X3)
  | trans_knows_old_session_current_8 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_old (session_current X1 X2 X3)
  | trans_knows_old_sym_1 : auto_knows_old sym
  | trans_knows_old_s_1 : forall X1:term, auto__q1 X1 -> auto_knows_old (s X1)
  | trans_knows_old_nil_1 : auto_knows_old nil
  | trans_knows_old_request_id_1 : auto_knows_old request_id
  | trans_knows_old_h_1 : forall X1:term, auto__q1 X1 -> auto_knows_old (h X1)
  | trans_knows_old_nai_1 : forall X1:term, auto__q3 X1 -> auto_knows_old (nai X1)
  | trans_knows_old_nai_2 : forall X1:term, auto__q1 X1 -> auto_knows_old (nai X1)
  | trans_knows_old_success_1 : auto_knows_old success
  | trans_knows_old_nonces_current_1 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_old (nonces_current X1 X2 X3)
  | trans_knows_old_nonces_current_2 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_old (nonces_current X1 X2 X3)
  | trans_knows_old_nonces_current_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_old (nonces_current X1 X2 X3)
  | trans_knows_old_nonces_current_4 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_old (nonces_current X1 X2 X3)
  | trans_knows_old_respond_id_1 : auto_knows_old respond_id
  | trans_knows_old_f2_1 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto_knows_old (f2 X1 X2)
  | trans_knows_old_f2_2 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_knows_old (f2 X1 X2)
  | trans_knows_old_f2_3 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_knows_old (f2 X1 X2)
  | trans_knows_old_pub_1 : auto_knows_old pub
  | trans_knows_old_f3_1 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto_knows_old (f3 X1 X2)
  | trans_knows_old_f3_2 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_knows_old (f3 X1 X2)
  | trans_knows_old_f3_3 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto_knows_old (f3 X1 X2)
  | trans_knows_old_f3_4 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto_knows_old (f3 X1 X2)
  | trans_knows_old_f1_1 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_old (f1 X1 X2 X3)
  | trans_knows_old_f1_2 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_old (f1 X1 X2 X3)
  | trans_knows_old_f1_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_old (f1 X1 X2 X3)
  | trans_knows_old_f1_4 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_knows_old (f1 X1 X2 X3)
  | trans_knows_old_f1_5 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_old (f1 X1 X2 X3)
  | trans_knows_old_f1_6 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_old (f1 X1 X2 X3)
  | trans_knows_old_f1_7 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_old (f1 X1 X2 X3)
  | trans_knows_old_f1_8 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_old (f1 X1 X2 X3)
  | trans_knows_old_f1_9 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_old (f1 X1 X2 X3)
  | trans_knows_old_f4_1 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto_knows_old (f4 X1 X2)
  | trans_knows_old_f4_2 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_knows_old (f4 X1 X2)
  | trans_knows_old_cons_1 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_knows_old (cons X1 X2)
  | trans_knows_old_session_old_1 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_old (session_old X1 X2 X3)
  | trans_knows_old_session_old_2 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_old (session_old X1 X2 X3)
  | trans_knows_old_session_old_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_old (session_old X1 X2 X3)
  | trans_knows_old_session_old_4 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_knows_old (session_old X1 X2 X3)
  | trans_knows_old_crypt_1 : forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_crypt_2 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_crypt_3 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_crypt_4 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_crypt_5 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_nonces_old_1 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_old (nonces_old X1 X2 X3)
  | trans_knows_old_nonces_old_2 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_old (nonces_old X1 X2 X3)
  | trans_knows_old_nonces_old_3 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_old (nonces_old X1 X2 X3)
  | trans_knows_old_nonces_old_4 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_old (nonces_old X1 X2 X3)
  | trans_knows_old_nonces_old_5 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_old (nonces_old X1 X2 X3)
  | trans_knows_old_nonces_old_6 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_old (nonces_old X1 X2 X3)
  | trans_knows_old_nonces_old_7 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_knows_old (nonces_old X1 X2 X3)
  | trans_knows_old_nonces_old_8 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_knows_old (nonces_old X1 X2 X3)
  | trans_knows_old_nonces_old_9 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_old (nonces_old X1 X2 X3)
  | trans_knows_old_nonces_old_10 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_old (nonces_old X1 X2 X3)
  | trans_knows_old_nonces_old_11 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_knows_old (nonces_old X1 X2 X3)
  | trans_knows_old_nonces_old_12 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_old (nonces_old X1 X2 X3)
  | trans_knows_old_nonces_old_13 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_old (nonces_old X1 X2 X3)
with auto_peer_keys_current : term -> term -> term -> Prop :=
    trans_peer_keys_current_1 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_peer_keys_current X1 X2 X3
  | trans_peer_keys_current_2 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_peer_keys_current X1 X2 X3
  | trans_peer_keys_current_3 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_peer_keys_current X1 X2 X3
  | trans_peer_keys_current_4 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_peer_keys_current X1 X2 X3
  | trans_peer_keys_current_5 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_peer_keys_current X1 X2 X3
  | trans_peer_keys_current_6 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_peer_keys_current X1 X2 X3
  | trans_peer_keys_current_7 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_peer_keys_current X1 X2 X3
  | trans_peer_keys_current_8 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_peer_keys_current X1 X2 X3
  | trans_peer_keys_current_9 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_peer_keys_current X1 X2 X3
  | trans_peer_keys_current_10 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_peer_keys_current X1 X2 X3
  | trans_peer_keys_current_11 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_peer_keys_current X1 X2 X3
  | trans_peer_keys_current_12 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_peer_keys_current X1 X2 X3
  | trans_peer_keys_current_13 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_peer_keys_current X1 X2 X3
  | trans_peer_keys_current_14 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_peer_keys_current X1 X2 X3
  | trans_peer_keys_current_15 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_peer_keys_current X1 X2 X3
  | trans_peer_keys_current_16 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_peer_keys_current X1 X2 X3
  | trans_peer_keys_current_17 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_peer_keys_current X1 X2 X3
  | trans_peer_keys_current_18 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_peer_keys_current X1 X2 X3
  | trans_peer_keys_current_19 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_peer_keys_current X1 X2 X3
  | trans_peer_keys_current_20 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_peer_keys_current X1 X2 X3
  | trans_peer_keys_current_21 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_peer_keys_current X1 X2 X3
  | trans_peer_keys_current_22 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_peer_keys_current X1 X2 X3
  | trans_peer_keys_current_23 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_peer_keys_current X1 X2 X3
  | trans_peer_keys_current_24 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_peer_keys_current X1 X2 X3
  | trans_peer_keys_current_25 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_peer_keys_current X1 X2 X3
  | trans_peer_keys_current_26 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_peer_keys_current X1 X2 X3
  | trans_peer_keys_current_27 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_peer_keys_current X1 X2 X3
with auto_agent : term -> Prop :=
    trans_agent_session_current_1 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_agent (session_current X1 X2 X3)
  | trans_agent_session_current_2 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_agent (session_current X1 X2 X3)
  | trans_agent_session_current_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_agent (session_current X1 X2 X3)
  | trans_agent_session_current_4 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_agent (session_current X1 X2 X3)
  | trans_agent_session_current_5 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_agent (session_current X1 X2 X3)
  | trans_agent_session_current_6 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_agent (session_current X1 X2 X3)
  | trans_agent_session_current_7 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_agent (session_current X1 X2 X3)
  | trans_agent_session_current_8 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_agent (session_current X1 X2 X3)
  | trans_agent_session_current_9 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_agent (session_current X1 X2 X3)
  | trans_agent_s_1 : forall X1:term, auto__q3 X1 -> auto_agent (s X1)
  | trans_agent_i_1 : auto_agent i
  | trans_agent_h_1 : forall X1:term, auto__q3 X1 -> auto_agent (h X1)
  | trans_agent_h_2 : forall X1:term, auto__q2 X1 -> auto_agent (h X1)
  | trans_agent_nai_1 : forall X1:term, auto__q2 X1 -> auto_agent (nai X1)
  | trans_agent_key_1 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_agent (key X1 X2)
  | trans_agent_nonces_current_1 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_agent (nonces_current X1 X2 X3)
  | trans_agent_nonces_current_2 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_agent (nonces_current X1 X2 X3)
  | trans_agent_nonces_current_3 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_agent (nonces_current X1 X2 X3)
  | trans_agent_nonces_current_4 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_agent (nonces_current X1 X2 X3)
  | trans_agent_nonces_current_5 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_agent (nonces_current X1 X2 X3)
  | trans_agent_nonces_current_6 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_agent (nonces_current X1 X2 X3)
  | trans_agent_nonces_current_7 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_agent (nonces_current X1 X2 X3)
  | trans_agent_nonces_current_8 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_agent (nonces_current X1 X2 X3)
  | trans_agent_nonces_current_9 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_agent (nonces_current X1 X2 X3)
  | trans_agent_nonces_current_10 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_agent (nonces_current X1 X2 X3)
  | trans_agent_nonces_current_11 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_agent (nonces_current X1 X2 X3)
  | trans_agent_f2_1 : forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto_agent (f2 X1 X2)
  | trans_agent_f2_2 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto_agent (f2 X1 X2)
  | trans_agent_f2_3 : forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto_agent (f2 X1 X2)
  | trans_agent_f3_1 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto_agent (f3 X1 X2)
  | trans_agent_f3_2 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_agent (f3 X1 X2)
  | trans_agent_f1_1 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_agent (f1 X1 X2 X3)
  | trans_agent_f1_2 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_agent (f1 X1 X2 X3)
  | trans_agent_f1_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_agent (f1 X1 X2 X3)
  | trans_agent_f1_4 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_agent (f1 X1 X2 X3)
  | trans_agent_f1_5 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_agent (f1 X1 X2 X3)
  | trans_agent_f1_6 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_agent (f1 X1 X2 X3)
  | trans_agent_f4_1 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto_agent (f4 X1 X2)
  | trans_agent_f4_2 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto_agent (f4 X1 X2)
  | trans_agent_f4_3 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto_agent (f4 X1 X2)
  | trans_agent_f4_4 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_agent (f4 X1 X2)
  | trans_agent_server_1 : auto_agent server
  | trans_agent_cons_1 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto_agent (cons X1 X2)
  | trans_agent_cons_2 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_agent (cons X1 X2)
  | trans_agent_cons_3 : forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto_agent (cons X1 X2)
  | trans_agent_session_old_1 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_agent (session_old X1 X2 X3)
  | trans_agent_session_old_2 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_agent (session_old X1 X2 X3)
  | trans_agent_session_old_3 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_agent (session_old X1 X2 X3)
  | trans_agent_session_old_4 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_agent (session_old X1 X2 X3)
  | trans_agent_session_old_5 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_agent (session_old X1 X2 X3)
  | trans_agent_session_old_6 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_agent (session_old X1 X2 X3)
  | trans_agent_session_old_7 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_agent (session_old X1 X2 X3)
  | trans_agent_session_old_8 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_agent (session_old X1 X2 X3)
  | trans_agent_session_old_9 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_agent (session_old X1 X2 X3)
  | trans_agent_session_old_10 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_agent (session_old X1 X2 X3)
  | trans_agent_bob_1 : auto_agent bob
  | trans_agent_crypt_1 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto_agent (crypt X1 X2)
  | trans_agent_crypt_2 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_agent (crypt X1 X2)
  | trans_agent_crypt_3 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto_agent (crypt X1 X2)
  | trans_agent_crypt_4 : forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto_agent (crypt X1 X2)
  | trans_agent_nonces_old_1 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_agent (nonces_old X1 X2 X3)
  | trans_agent_nonces_old_2 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_agent (nonces_old X1 X2 X3)
  | trans_agent_nonces_old_3 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_agent (nonces_old X1 X2 X3)
  | trans_agent_nonces_old_4 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_agent (nonces_old X1 X2 X3)
  | trans_agent_nonces_old_5 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_agent (nonces_old X1 X2 X3)
  | trans_agent_nonces_old_6 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_agent (nonces_old X1 X2 X3)
  | trans_agent_nonces_old_7 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_agent (nonces_old X1 X2 X3)
  | trans_agent_nonces_old_8 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_agent (nonces_old X1 X2 X3)
  | trans_agent_nonces_old_9 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_agent (nonces_old X1 X2 X3)
  | trans_agent_nonces_old_10 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_agent (nonces_old X1 X2 X3)
  | trans_agent_nonces_old_11 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_agent (nonces_old X1 X2 X3)
  | trans_agent_alice_1 : auto_agent alice
  | trans_agent_f5_1 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto_agent (f5 X1 X2)
  | trans_agent_f5_2 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto_agent (f5 X1 X2)
  | trans_agent_f5_3 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_agent (f5 X1 X2)
  | trans_agent_f5_4 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto_agent (f5 X1 X2)
  | trans_agent_f5_5 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto_agent (f5 X1 X2)
  | trans_agent_f5_6 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_agent (f5 X1 X2)
  | trans_agent_f5_7 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto_agent (f5 X1 X2)
with auto__q3 : term -> Prop :=
    trans__q3_session_current_1 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_2 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_4 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_5 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_6 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_7 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_8 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_9 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_s_1 : forall X1:term, auto__q3 X1 -> auto__q3 (s X1)
  | trans__q3_i_1 : auto__q3 i
  | trans__q3_h_1 : forall X1:term, auto__q3 X1 -> auto__q3 (h X1)
  | trans__q3_h_2 : forall X1:term, auto__q2 X1 -> auto__q3 (h X1)
  | trans__q3_nai_1 : forall X1:term, auto__q2 X1 -> auto__q3 (nai X1)
  | trans__q3_key_1 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 (key X1 X2)
  | trans__q3_nonces_current_1 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 (nonces_current X1 X2 X3)
  | trans__q3_nonces_current_2 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 (nonces_current X1 X2 X3)
  | trans__q3_nonces_current_3 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q3 (nonces_current X1 X2 X3)
  | trans__q3_nonces_current_4 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q3 (nonces_current X1 X2 X3)
  | trans__q3_nonces_current_5 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 (nonces_current X1 X2 X3)
  | trans__q3_nonces_current_6 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q3 (nonces_current X1 X2 X3)
  | trans__q3_nonces_current_7 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q3 (nonces_current X1 X2 X3)
  | trans__q3_nonces_current_8 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q3 (nonces_current X1 X2 X3)
  | trans__q3_nonces_current_9 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q3 (nonces_current X1 X2 X3)
  | trans__q3_nonces_current_10 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 (nonces_current X1 X2 X3)
  | trans__q3_nonces_current_11 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 (nonces_current X1 X2 X3)
  | trans__q3_f2_1 : forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 (f2 X1 X2)
  | trans__q3_f2_2 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 (f2 X1 X2)
  | trans__q3_f2_3 : forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 (f2 X1 X2)
  | trans__q3_f3_1 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 (f3 X1 X2)
  | trans__q3_f3_2 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 (f3 X1 X2)
  | trans__q3_f1_1 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q3 (f1 X1 X2 X3)
  | trans__q3_f1_2 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q3 (f1 X1 X2 X3)
  | trans__q3_f1_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 (f1 X1 X2 X3)
  | trans__q3_f1_4 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q3 (f1 X1 X2 X3)
  | trans__q3_f1_5 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 (f1 X1 X2 X3)
  | trans__q3_f1_6 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 (f1 X1 X2 X3)
  | trans__q3_f4_1 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 (f4 X1 X2)
  | trans__q3_f4_2 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 (f4 X1 X2)
  | trans__q3_f4_3 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 (f4 X1 X2)
  | trans__q3_f4_4 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 (f4 X1 X2)
  | trans__q3_server_1 : auto__q3 server
  | trans__q3_cons_1 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 (cons X1 X2)
  | trans__q3_cons_2 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 (cons X1 X2)
  | trans__q3_cons_3 : forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 (cons X1 X2)
  | trans__q3_session_old_1 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_2 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_3 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_4 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_5 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_6 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_7 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_8 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_9 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_10 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_bob_1 : auto__q3 bob
  | trans__q3_crypt_1 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 (crypt X1 X2)
  | trans__q3_crypt_2 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 (crypt X1 X2)
  | trans__q3_crypt_3 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 (crypt X1 X2)
  | trans__q3_crypt_4 : forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 (crypt X1 X2)
  | trans__q3_nonces_old_1 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 (nonces_old X1 X2 X3)
  | trans__q3_nonces_old_2 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q3 (nonces_old X1 X2 X3)
  | trans__q3_nonces_old_3 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q3 (nonces_old X1 X2 X3)
  | trans__q3_nonces_old_4 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q3 (nonces_old X1 X2 X3)
  | trans__q3_nonces_old_5 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q3 (nonces_old X1 X2 X3)
  | trans__q3_nonces_old_6 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 (nonces_old X1 X2 X3)
  | trans__q3_nonces_old_7 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q3 (nonces_old X1 X2 X3)
  | trans__q3_nonces_old_8 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q3 (nonces_old X1 X2 X3)
  | trans__q3_nonces_old_9 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q3 (nonces_old X1 X2 X3)
  | trans__q3_nonces_old_10 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q3 (nonces_old X1 X2 X3)
  | trans__q3_nonces_old_11 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q3 (nonces_old X1 X2 X3)
  | trans__q3_alice_1 : auto__q3 alice
  | trans__q3_f5_1 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 (f5 X1 X2)
  | trans__q3_f5_2 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 (f5 X1 X2)
  | trans__q3_f5_3 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 (f5 X1 X2)
  | trans__q3_f5_4 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 (f5 X1 X2)
  | trans__q3_f5_5 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 (f5 X1 X2)
  | trans__q3_f5_6 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 (f5 X1 X2)
  | trans__q3_f5_7 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 (f5 X1 X2)
with auto__q1 : term -> Prop :=
    trans__q1_session_current_1 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q1 (session_current X1 X2 X3)
  | trans__q1_session_current_2 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q1 (session_current X1 X2 X3)
  | trans__q1_session_current_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q1 (session_current X1 X2 X3)
  | trans__q1_session_current_4 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 (session_current X1 X2 X3)
  | trans__q1_session_current_5 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q1 (session_current X1 X2 X3)
  | trans__q1_session_current_6 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 (session_current X1 X2 X3)
  | trans__q1_session_current_7 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q1 (session_current X1 X2 X3)
  | trans__q1_session_current_8 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 (session_current X1 X2 X3)
  | trans__q1_sym_1 : auto__q1 sym
  | trans__q1_s_1 : forall X1:term, auto__q1 X1 -> auto__q1 (s X1)
  | trans__q1_nil_1 : auto__q1 nil
  | trans__q1_request_id_1 : auto__q1 request_id
  | trans__q1_h_1 : forall X1:term, auto__q1 X1 -> auto__q1 (h X1)
  | trans__q1_nai_1 : forall X1:term, auto__q3 X1 -> auto__q1 (nai X1)
  | trans__q1_nai_2 : forall X1:term, auto__q1 X1 -> auto__q1 (nai X1)
  | trans__q1_success_1 : auto__q1 success
  | trans__q1_nonces_current_1 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q1 (nonces_current X1 X2 X3)
  | trans__q1_nonces_current_2 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q1 (nonces_current X1 X2 X3)
  | trans__q1_nonces_current_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 (nonces_current X1 X2 X3)
  | trans__q1_nonces_current_4 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 (nonces_current X1 X2 X3)
  | trans__q1_respond_id_1 : auto__q1 respond_id
  | trans__q1_f2_1 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 (f2 X1 X2)
  | trans__q1_f2_2 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 (f2 X1 X2)
  | trans__q1_f2_3 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 (f2 X1 X2)
  | trans__q1_pub_1 : auto__q1 pub
  | trans__q1_f3_1 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 (f3 X1 X2)
  | trans__q1_f3_2 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 (f3 X1 X2)
  | trans__q1_f3_3 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 (f3 X1 X2)
  | trans__q1_f3_4 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 (f3 X1 X2)
  | trans__q1_f1_1 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q1 (f1 X1 X2 X3)
  | trans__q1_f1_2 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q1 (f1 X1 X2 X3)
  | trans__q1_f1_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 (f1 X1 X2 X3)
  | trans__q1_f1_4 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q1 (f1 X1 X2 X3)
  | trans__q1_f1_5 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q1 (f1 X1 X2 X3)
  | trans__q1_f1_6 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 (f1 X1 X2 X3)
  | trans__q1_f1_7 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 (f1 X1 X2 X3)
  | trans__q1_f1_8 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 (f1 X1 X2 X3)
  | trans__q1_f1_9 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 (f1 X1 X2 X3)
  | trans__q1_f4_1 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 (f4 X1 X2)
  | trans__q1_f4_2 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 (f4 X1 X2)
  | trans__q1_cons_1 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 (cons X1 X2)
  | trans__q1_session_old_1 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q1 (session_old X1 X2 X3)
  | trans__q1_session_old_2 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 (session_old X1 X2 X3)
  | trans__q1_session_old_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q1 (session_old X1 X2 X3)
  | trans__q1_session_old_4 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q1 (session_old X1 X2 X3)
  | trans__q1_crypt_1 : forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 (crypt X1 X2)
  | trans__q1_crypt_2 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 (crypt X1 X2)
  | trans__q1_crypt_3 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 (crypt X1 X2)
  | trans__q1_crypt_4 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 (crypt X1 X2)
  | trans__q1_crypt_5 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 (crypt X1 X2)
  | trans__q1_nonces_old_1 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q1 (nonces_old X1 X2 X3)
  | trans__q1_nonces_old_2 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 (nonces_old X1 X2 X3)
  | trans__q1_nonces_old_3 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q1 (nonces_old X1 X2 X3)
  | trans__q1_nonces_old_4 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 (nonces_old X1 X2 X3)
  | trans__q1_nonces_old_5 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q1 (nonces_old X1 X2 X3)
  | trans__q1_nonces_old_6 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 (nonces_old X1 X2 X3)
  | trans__q1_nonces_old_7 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 (nonces_old X1 X2 X3)
  | trans__q1_nonces_old_8 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q1 (nonces_old X1 X2 X3)
  | trans__q1_nonces_old_9 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 (nonces_old X1 X2 X3)
  | trans__q1_nonces_old_10 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q1 (nonces_old X1 X2 X3)
  | trans__q1_nonces_old_11 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 (nonces_old X1 X2 X3)
  | trans__q1_nonces_old_12 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 (nonces_old X1 X2 X3)
  | trans__q1_nonces_old_13 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q1 (nonces_old X1 X2 X3)
with auto__q2 : term -> Prop :=
    trans__q2_session_current_1 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q2 (session_current X1 X2 X3)
  | trans__q2_session_current_2 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q2 (session_current X1 X2 X3)
  | trans__q2_session_current_3 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 (session_current X1 X2 X3)
  | trans__q2_session_current_4 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 (session_current X1 X2 X3)
  | trans__q2_session_current_5 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q2 (session_current X1 X2 X3)
  | trans__q2_session_current_6 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q2 (session_current X1 X2 X3)
  | trans__q2_session_current_7 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q2 (session_current X1 X2 X3)
  | trans__q2_session_current_8 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q2 (session_current X1 X2 X3)
  | trans__q2_session_current_9 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q2 (session_current X1 X2 X3)
  | trans__q2_session_current_10 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q2 (session_current X1 X2 X3)
  | trans__q2_s_1 : forall X1:term, auto__q2 X1 -> auto__q2 (s X1)
  | trans__q2_key_1 : forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 (key X1 X2)
  | trans__q2_key_2 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 (key X1 X2)
  | trans__q2_key_3 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 (key X1 X2)
  | trans__q2_key_4 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 (key X1 X2)
  | trans__q2_key_5 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 (key X1 X2)
  | trans__q2_key_6 : forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 (key X1 X2)
  | trans__q2_key_7 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 (key X1 X2)
  | trans__q2_key_8 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 (key X1 X2)
  | trans__q2_nonces_current_1 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q2 (nonces_current X1 X2 X3)
  | trans__q2_nonces_current_2 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q2 (nonces_current X1 X2 X3)
  | trans__q2_nonces_current_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 (nonces_current X1 X2 X3)
  | trans__q2_nonces_current_4 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q2 (nonces_current X1 X2 X3)
  | trans__q2_nonces_current_5 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 (nonces_current X1 X2 X3)
  | trans__q2_nonces_current_6 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q2 (nonces_current X1 X2 X3)
  | trans__q2_nonces_current_7 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q2 (nonces_current X1 X2 X3)
  | trans__q2_nonces_current_8 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 (nonces_current X1 X2 X3)
  | trans__q2_nonces_current_9 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q2 (nonces_current X1 X2 X3)
  | trans__q2_nonces_current_10 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q2 (nonces_current X1 X2 X3)
  | trans__q2_nonces_current_11 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q2 (nonces_current X1 X2 X3)
  | trans__q2_nonces_current_12 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q2 (nonces_current X1 X2 X3)
  | trans__q2_f2_1 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 (f2 X1 X2)
  | trans__q2_f2_2 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 (f2 X1 X2)
  | trans__q2_f2_3 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 (f2 X1 X2)
  | trans__q2_f3_1 : forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 (f3 X1 X2)
  | trans__q2_f3_2 : forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 (f3 X1 X2)
  | trans__q2_f3_3 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 (f3 X1 X2)
  | trans__q2_f1_1 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q2 (f1 X1 X2 X3)
  | trans__q2_f1_2 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q2 (f1 X1 X2 X3)
  | trans__q2_f1_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q2 (f1 X1 X2 X3)
  | trans__q2_f1_4 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 (f1 X1 X2 X3)
  | trans__q2_f1_5 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q2 (f1 X1 X2 X3)
  | trans__q2_f1_6 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 (f1 X1 X2 X3)
  | trans__q2_f1_7 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q2 (f1 X1 X2 X3)
  | trans__q2_f1_8 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q2 (f1 X1 X2 X3)
  | trans__q2_f1_9 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 (f1 X1 X2 X3)
  | trans__q2_f1_10 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q2 (f1 X1 X2 X3)
  | trans__q2_f1_11 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q2 (f1 X1 X2 X3)
  | trans__q2_f1_12 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q2 (f1 X1 X2 X3)
  | trans__q2_f4_1 : forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 (f4 X1 X2)
  | trans__q2_f4_2 : forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 (f4 X1 X2)
  | trans__q2_f4_3 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 (f4 X1 X2)
  | trans__q2_cons_1 : forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 (cons X1 X2)
  | trans__q2_cons_2 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 (cons X1 X2)
  | trans__q2_cons_3 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 (cons X1 X2)
  | trans__q2_cons_4 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 (cons X1 X2)
  | trans__q2_cons_5 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 (cons X1 X2)
  | trans__q2_session_old_1 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q2 (session_old X1 X2 X3)
  | trans__q2_session_old_2 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q2 (session_old X1 X2 X3)
  | trans__q2_session_old_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q2 (session_old X1 X2 X3)
  | trans__q2_session_old_4 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q2 (session_old X1 X2 X3)
  | trans__q2_session_old_5 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q2 (session_old X1 X2 X3)
  | trans__q2_session_old_6 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 (session_old X1 X2 X3)
  | trans__q2_session_old_7 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 (session_old X1 X2 X3)
  | trans__q2_session_old_8 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q2 (session_old X1 X2 X3)
  | trans__q2_session_old_9 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q2 (session_old X1 X2 X3)
  | trans__q2_session_old_10 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q2 (session_old X1 X2 X3)
  | trans__q2_session_old_11 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q2 (session_old X1 X2 X3)
  | trans__q2_session_old_12 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q2 (session_old X1 X2 X3)
  | trans__q2_session_old_13 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q2 (session_old X1 X2 X3)
  | trans__q2_nonces_old_1 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q2 (nonces_old X1 X2 X3)
  | trans__q2_nonces_old_2 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q2 (nonces_old X1 X2 X3)
  | trans__q2_nonces_old_3 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q2 (nonces_old X1 X2 X3)
  | trans__q2_f5_1 : forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 (f5 X1 X2)
  | trans__q2_f5_2 : forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 (f5 X1 X2)
  | trans__q2_prv_1 : auto__q2 prv
with auto_peer_keys_old : term -> term -> term -> Prop :=
    trans_peer_keys_old_1 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_peer_keys_old X1 X2 X3
  | trans_peer_keys_old_2 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_peer_keys_old X1 X2 X3
  | trans_peer_keys_old_3 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_peer_keys_old X1 X2 X3
  | trans_peer_keys_old_4 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_peer_keys_old X1 X2 X3
  | trans_peer_keys_old_5 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_peer_keys_old X1 X2 X3
  | trans_peer_keys_old_6 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_peer_keys_old X1 X2 X3
  | trans_peer_keys_old_7 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_peer_keys_old X1 X2 X3
  | trans_peer_keys_old_8 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_peer_keys_old X1 X2 X3
  | trans_peer_keys_old_9 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_peer_keys_old X1 X2 X3
with auto_knows_current : term -> Prop :=
    trans_knows_current_session_current_1 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (session_current X1 X2 X3)
  | trans_knows_current_session_current_2 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_current (session_current X1 X2 X3)
  | trans_knows_current_session_current_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (session_current X1 X2 X3)
  | trans_knows_current_session_current_4 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_current (session_current X1 X2 X3)
  | trans_knows_current_session_current_5 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_knows_current (session_current X1 X2 X3)
  | trans_knows_current_session_current_6 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_current (session_current X1 X2 X3)
  | trans_knows_current_session_current_7 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (session_current X1 X2 X3)
  | trans_knows_current_session_current_8 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (session_current X1 X2 X3)
  | trans_knows_current_session_current_9 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (session_current X1 X2 X3)
  | trans_knows_current_session_current_10 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_knows_current (session_current X1 X2 X3)
  | trans_knows_current_session_current_11 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_knows_current (session_current X1 X2 X3)
  | trans_knows_current_session_current_12 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (session_current X1 X2 X3)
  | trans_knows_current_session_current_13 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_knows_current (session_current X1 X2 X3)
  | trans_knows_current_session_current_14 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (session_current X1 X2 X3)
  | trans_knows_current_session_current_15 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_current (session_current X1 X2 X3)
  | trans_knows_current_session_current_16 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_knows_current (session_current X1 X2 X3)
  | trans_knows_current_session_current_17 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (session_current X1 X2 X3)
  | trans_knows_current_sym_1 : auto_knows_current sym
  | trans_knows_current_s_1 : forall X1:term, auto__q3 X1 -> auto_knows_current (s X1)
  | trans_knows_current_s_2 : forall X1:term, auto__q1 X1 -> auto_knows_current (s X1)
  | trans_knows_current_nil_1 : auto_knows_current nil
  | trans_knows_current_i_1 : auto_knows_current i
  | trans_knows_current_request_id_1 : auto_knows_current request_id
  | trans_knows_current_h_1 : forall X1:term, auto__q3 X1 -> auto_knows_current (h X1)
  | trans_knows_current_h_2 : forall X1:term, auto__q1 X1 -> auto_knows_current (h X1)
  | trans_knows_current_h_3 : forall X1:term, auto__q2 X1 -> auto_knows_current (h X1)
  | trans_knows_current_nai_1 : forall X1:term, auto__q3 X1 -> auto_knows_current (nai X1)
  | trans_knows_current_nai_2 : forall X1:term, auto__q1 X1 -> auto_knows_current (nai X1)
  | trans_knows_current_nai_3 : forall X1:term, auto__q2 X1 -> auto_knows_current (nai X1)
  | trans_knows_current_success_1 : auto_knows_current success
  | trans_knows_current_key_1 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_knows_current (key X1 X2)
  | trans_knows_current_nonces_current_1 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (nonces_current X1 X2 X3)
  | trans_knows_current_nonces_current_2 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_current (nonces_current X1 X2 X3)
  | trans_knows_current_nonces_current_3 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (nonces_current X1 X2 X3)
  | trans_knows_current_nonces_current_4 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (nonces_current X1 X2 X3)
  | trans_knows_current_nonces_current_5 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_current (nonces_current X1 X2 X3)
  | trans_knows_current_nonces_current_6 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_knows_current (nonces_current X1 X2 X3)
  | trans_knows_current_nonces_current_7 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (nonces_current X1 X2 X3)
  | trans_knows_current_nonces_current_8 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_knows_current (nonces_current X1 X2 X3)
  | trans_knows_current_nonces_current_9 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_current (nonces_current X1 X2 X3)
  | trans_knows_current_nonces_current_10 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (nonces_current X1 X2 X3)
  | trans_knows_current_nonces_current_11 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (nonces_current X1 X2 X3)
  | trans_knows_current_nonces_current_12 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (nonces_current X1 X2 X3)
  | trans_knows_current_nonces_current_13 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (nonces_current X1 X2 X3)
  | trans_knows_current_nonces_current_14 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (nonces_current X1 X2 X3)
  | trans_knows_current_nonces_current_15 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (nonces_current X1 X2 X3)
  | trans_knows_current_respond_id_1 : auto_knows_current respond_id
  | trans_knows_current_f2_1 : forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto_knows_current (f2 X1 X2)
  | trans_knows_current_f2_2 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto_knows_current (f2 X1 X2)
  | trans_knows_current_f2_3 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto_knows_current (f2 X1 X2)
  | trans_knows_current_f2_4 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_knows_current (f2 X1 X2)
  | trans_knows_current_f2_5 : forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto_knows_current (f2 X1 X2)
  | trans_knows_current_f2_6 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_knows_current (f2 X1 X2)
  | trans_knows_current_pub_1 : auto_knows_current pub
  | trans_knows_current_f3_1 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto_knows_current (f3 X1 X2)
  | trans_knows_current_f3_2 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto_knows_current (f3 X1 X2)
  | trans_knows_current_f3_3 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_knows_current (f3 X1 X2)
  | trans_knows_current_f3_4 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto_knows_current (f3 X1 X2)
  | trans_knows_current_f3_5 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto_knows_current (f3 X1 X2)
  | trans_knows_current_f3_6 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_knows_current (f3 X1 X2)
  | trans_knows_current_f1_1 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (f1 X1 X2 X3)
  | trans_knows_current_f1_2 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (f1 X1 X2 X3)
  | trans_knows_current_f1_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_current (f1 X1 X2 X3)
  | trans_knows_current_f1_4 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_knows_current (f1 X1 X2 X3)
  | trans_knows_current_f1_5 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (f1 X1 X2 X3)
  | trans_knows_current_f1_6 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_current (f1 X1 X2 X3)
  | trans_knows_current_f1_7 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (f1 X1 X2 X3)
  | trans_knows_current_f1_8 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (f1 X1 X2 X3)
  | trans_knows_current_f1_9 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (f1 X1 X2 X3)
  | trans_knows_current_f1_10 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (f1 X1 X2 X3)
  | trans_knows_current_f1_11 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_current (f1 X1 X2 X3)
  | trans_knows_current_f1_12 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (f1 X1 X2 X3)
  | trans_knows_current_f1_13 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (f1 X1 X2 X3)
  | trans_knows_current_f1_14 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (f1 X1 X2 X3)
  | trans_knows_current_f1_15 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (f1 X1 X2 X3)
  | trans_knows_current_f4_1 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto_knows_current (f4 X1 X2)
  | trans_knows_current_f4_2 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto_knows_current (f4 X1 X2)
  | trans_knows_current_f4_3 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_knows_current (f4 X1 X2)
  | trans_knows_current_f4_4 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto_knows_current (f4 X1 X2)
  | trans_knows_current_f4_5 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto_knows_current (f4 X1 X2)
  | trans_knows_current_f4_6 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_knows_current (f4 X1 X2)
  | trans_knows_current_server_1 : auto_knows_current server
  | trans_knows_current_cons_1 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto_knows_current (cons X1 X2)
  | trans_knows_current_cons_2 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_knows_current (cons X1 X2)
  | trans_knows_current_cons_3 : forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto_knows_current (cons X1 X2)
  | trans_knows_current_cons_4 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_knows_current (cons X1 X2)
  | trans_knows_current_session_old_1 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (session_old X1 X2 X3)
  | trans_knows_current_session_old_2 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (session_old X1 X2 X3)
  | trans_knows_current_session_old_3 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (session_old X1 X2 X3)
  | trans_knows_current_session_old_4 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_current (session_old X1 X2 X3)
  | trans_knows_current_session_old_5 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_current (session_old X1 X2 X3)
  | trans_knows_current_session_old_6 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (session_old X1 X2 X3)
  | trans_knows_current_session_old_7 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (session_old X1 X2 X3)
  | trans_knows_current_session_old_8 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (session_old X1 X2 X3)
  | trans_knows_current_session_old_9 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (session_old X1 X2 X3)
  | trans_knows_current_session_old_10 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_current (session_old X1 X2 X3)
  | trans_knows_current_session_old_11 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (session_old X1 X2 X3)
  | trans_knows_current_session_old_12 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_knows_current (session_old X1 X2 X3)
  | trans_knows_current_session_old_13 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_knows_current (session_old X1 X2 X3)
  | trans_knows_current_session_old_14 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_knows_current (session_old X1 X2 X3)
  | trans_knows_current_bob_1 : auto_knows_current bob
  | trans_knows_current_crypt_1 : forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_2 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_3 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_4 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_5 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_6 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_7 : forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_8 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_9 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_nonces_old_1 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_current (nonces_old X1 X2 X3)
  | trans_knows_current_nonces_old_2 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (nonces_old X1 X2 X3)
  | trans_knows_current_nonces_old_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (nonces_old X1 X2 X3)
  | trans_knows_current_nonces_old_4 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_current (nonces_old X1 X2 X3)
  | trans_knows_current_nonces_old_5 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_knows_current (nonces_old X1 X2 X3)
  | trans_knows_current_nonces_old_6 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (nonces_old X1 X2 X3)
  | trans_knows_current_nonces_old_7 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_knows_current (nonces_old X1 X2 X3)
  | trans_knows_current_nonces_old_8 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_knows_current (nonces_old X1 X2 X3)
  | trans_knows_current_nonces_old_9 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_current (nonces_old X1 X2 X3)
  | trans_knows_current_nonces_old_10 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_current (nonces_old X1 X2 X3)
  | trans_knows_current_nonces_old_11 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (nonces_old X1 X2 X3)
  | trans_knows_current_nonces_old_12 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (nonces_old X1 X2 X3)
  | trans_knows_current_nonces_old_13 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (nonces_old X1 X2 X3)
  | trans_knows_current_nonces_old_14 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_current (nonces_old X1 X2 X3)
  | trans_knows_current_nonces_old_15 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_knows_current (nonces_old X1 X2 X3)
  | trans_knows_current_nonces_old_16 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_knows_current (nonces_old X1 X2 X3)
  | trans_knows_current_nonces_old_17 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (nonces_old X1 X2 X3)
  | trans_knows_current_nonces_old_18 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_knows_current (nonces_old X1 X2 X3)
  | trans_knows_current_nonces_old_19 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (nonces_old X1 X2 X3)
  | trans_knows_current_nonces_old_20 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_knows_current (nonces_old X1 X2 X3)
  | trans_knows_current_nonces_old_21 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (nonces_old X1 X2 X3)
  | trans_knows_current_nonces_old_22 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_current (nonces_old X1 X2 X3)
  | trans_knows_current_nonces_old_23 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_knows_current (nonces_old X1 X2 X3)
  | trans_knows_current_nonces_old_24 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (nonces_old X1 X2 X3)
  | trans_knows_current_alice_1 : auto_knows_current alice
  | trans_knows_current_f5_1 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto_knows_current (f5 X1 X2)
  | trans_knows_current_f5_2 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto_knows_current (f5 X1 X2)
  | trans_knows_current_f5_3 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_knows_current (f5 X1 X2)
  | trans_knows_current_f5_4 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto_knows_current (f5 X1 X2)
  | trans_knows_current_f5_5 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto_knows_current (f5 X1 X2)
  | trans_knows_current_f5_6 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_knows_current (f5 X1 X2)
  | trans_knows_current_f5_7 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto_knows_current (f5 X1 X2)
with auto_server_keys_current : term -> term -> term -> Prop :=
    trans_server_keys_current_1 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_server_keys_current X1 X2 X3
  | trans_server_keys_current_2 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_server_keys_current X1 X2 X3
  | trans_server_keys_current_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_server_keys_current X1 X2 X3
with auto___query__intruder_knows_server_CK : Prop :=
with auto___query__intruder_knows_server_IK : Prop :=
.

(* [defp] Proofs that all definitions hold. *)


(* [appp] Proofs that all approximation clauses hold. *)


Remark rem_1 : True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
   tauto.
Qed.

Remark rem_2 : auto_agent server. (* Deduce positive atom. *)
Proof.
   case rem_1. intros. apply trans_agent_server_1;  tauto.
 tauto.
Qed.

Remark rem_3 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1:term, auto__q2 X1 -> auto__q2 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_4 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_3 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_5 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X2:term, auto__q3 X2 -> auto__q3 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_6 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_5 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_7 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X3:term, auto__q1 X3 -> auto__q1 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_8 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q1 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X3 -> auto__q1 X3). tauto. exact (rem_7 epsilon_m_q3_pknows_current X3).
Defined.

Remark rem_9 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> (auto__q2 X1 /\ auto__q3 X2 /\ auto__q1 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_4 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_6 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X3). 2:apply (rem_8 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_10 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_knows_current (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_9 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_current_5;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_11 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1:term, auto__q3 X1 -> auto__q3 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_12 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_11 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_13 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X2:term, auto__q2 X2 -> auto__q2 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_14 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_13 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_15 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X3 -> auto__q1 X3). tauto. exact (rem_7 epsilon_m_q3_pknows_current X3).
Defined.

Remark rem_16 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> (auto__q3 X1 /\ auto__q2 X2 /\ auto__q1 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_12 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_14 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X3). 2:apply (rem_15 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_17 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_current (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_16 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_current_6;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_18 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_3 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_19 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_13 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_20 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X3:term, auto__q2 X3 -> auto__q2 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_21 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_20 epsilon_m_q3_pknows_current X3).
Defined.

Remark rem_22 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> (auto__q2 X1 /\ auto__q2 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_18 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_19 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_21 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_23 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_22 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_current_9;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_24 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_11 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_25 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_5 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_26 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_20 epsilon_m_q3_pknows_current X3).
Defined.

Remark rem_27 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> (auto__q3 X1 /\ auto__q3 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_24 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_25 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_26 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_28 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_knows_current (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_27 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_current_10;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_29 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1:term, auto__q1 X1 -> auto__q1 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_30 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_29 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_31 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_5 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_32 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q1 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X3 -> auto__q1 X3). tauto. exact (rem_7 epsilon_m_q3_pknows_current X3).
Defined.

Remark rem_33 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> (auto__q1 X1 /\ auto__q3 X2 /\ auto__q1 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_30 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_31 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X3). 2:apply (rem_32 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_34 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_knows_current (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_33 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_current_11;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_35 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_29 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_36 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_5 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_37 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_20 epsilon_m_q3_pknows_current X3).
Defined.

Remark rem_38 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> (auto__q1 X1 /\ auto__q3 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_35 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_36 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_37 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_39 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_knows_current (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_38 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_current_13;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_40 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_29 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_41 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_13 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_42 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X3:term, auto__q3 X3 -> auto__q3 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_43 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_42 epsilon_m_q3_pknows_current X3).
Defined.

Remark rem_44 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> (auto__q1 X1 /\ auto__q2 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_40 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_41 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_43 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_45 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_current (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_44 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_current_15;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_46 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_3 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_47 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X2:term, auto__q1 X2 -> auto__q1 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_48 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_47 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_49 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q1 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X3 -> auto__q1 X3). tauto. exact (rem_7 epsilon_m_q3_pknows_current X3).
Defined.

Remark rem_50 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> (auto__q2 X1 /\ auto__q1 X2 /\ auto__q1 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_46 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_48 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X3). 2:apply (rem_49 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_51 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_knows_current (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_50 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_current_16;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_52 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_3 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_53 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_47 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_54 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_20 epsilon_m_q3_pknows_current X3).
Defined.

Remark rem_55 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> (auto__q2 X1 /\ auto__q1 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_52 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_53 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_54 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_56 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_55 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_current_17;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Inductive or_9(H1 H2 H3 H4 H5 H6 H7 H8 H9:Prop) : Prop :=
    or_9_intro_1 : H1 -> (or_9 H1 H2 H3 H4 H5 H6 H7 H8 H9)
  | or_9_intro_2 : H2 -> (or_9 H1 H2 H3 H4 H5 H6 H7 H8 H9)
  | or_9_intro_3 : H3 -> (or_9 H1 H2 H3 H4 H5 H6 H7 H8 H9)
  | or_9_intro_4 : H4 -> (or_9 H1 H2 H3 H4 H5 H6 H7 H8 H9)
  | or_9_intro_5 : H5 -> (or_9 H1 H2 H3 H4 H5 H6 H7 H8 H9)
  | or_9_intro_6 : H6 -> (or_9 H1 H2 H3 H4 H5 H6 H7 H8 H9)
  | or_9_intro_7 : H7 -> (or_9 H1 H2 H3 H4 H5 H6 H7 H8 H9)
  | or_9_intro_8 : H8 -> (or_9 H1 H2 H3 H4 H5 H6 H7 H8 H9)
  | or_9_intro_9 : H9 -> (or_9 H1 H2 H3 H4 H5 H6 H7 H8 H9)
.

Remark rem_57 : forall X1 X2 X3:term, auto__q3 (session_current X1 X2 X3) -> or_9
    (auto__q2 X1 /\ auto__q3 X2 /\ auto__q1 X3)
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q3 X1 /\ auto__q3 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q1 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q1 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q2 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_9_intro_1; tauto.
  intros. apply or_9_intro_2; tauto.
  intros. apply or_9_intro_3; tauto.
  intros. apply or_9_intro_4; tauto.
  intros. apply or_9_intro_5; tauto.
  intros. apply or_9_intro_6; tauto.
  intros. apply or_9_intro_7; tauto.
  intros. apply or_9_intro_8; tauto.
  intros. apply or_9_intro_9; tauto.
Qed.

Remark rem_58 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 (session_current X1 X2 X3) -> auto_knows_current (session_current X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intro H. intros.
  elim (rem_57 X1 X2 X3 H);  intros.
  apply (rem_10 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_17 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_23 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_28 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_34 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_39 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_45 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_51 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_56 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
Defined.

Remark rem_59 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1:term, auto__q3 X1 -> auto__q3 X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1. intros A1.
  cut (auto__q3 X1). 2:apply (rem_11 epsilon_m_q3_pknows_current X1);  assumption.
  tauto.
Defined.

Remark rem_60 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1:term, auto__q3 X1 -> auto_knows_current (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1. intros A1.
  case (rem_59 epsilon_m_q3_pknows_current X1 A1). clear  epsilon_m_q3_pknows_current A1. intros. apply trans_knows_current_s_1;  tauto.
 clear  epsilon_m_q3_pknows_current A1. tauto.
Defined.

Inductive or_1(H1:Prop) : Prop :=
    or_1_intro_1 : H1 -> (or_1 H1)
.

Remark rem_61 : forall X1:term, auto__q3 (s X1) -> or_1
    (auto__q3 X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_62 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1:term, auto__q3 (s X1) -> auto_knows_current (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1. intro H. intros.
  elim (rem_61 X1 H);  intros.
  apply (rem_60 epsilon_m_q3_pknows_current X1);  tauto.
Defined.

Remark rem_63 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current.  tauto.
Defined.

Remark rem_64 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> auto_knows_current i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current.  case (rem_63 epsilon_m_q3_pknows_current). clear  epsilon_m_q3_pknows_current. intros. apply trans_knows_current_i_1;  tauto.
 clear  epsilon_m_q3_pknows_current. tauto.
Defined.

Remark rem_65 : auto__q3 i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_66 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> auto__q3 i -> auto_knows_current i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intro H. intros.
  elim (rem_65 H);  intros.
  apply (rem_64 epsilon_m_q3_pknows_current);  tauto.
Defined.

Remark rem_67 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1:term, auto__q3 X1 -> auto_knows_current (h X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1. intros A1.
  case (rem_59 epsilon_m_q3_pknows_current X1 A1). clear  epsilon_m_q3_pknows_current A1. intros. apply trans_knows_current_h_1;  tauto.
 clear  epsilon_m_q3_pknows_current A1. tauto.
Defined.

Remark rem_68 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1:term, auto__q2 X1 -> auto__q2 X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1. intros A1.
  cut (auto__q2 X1). 2:apply (rem_3 epsilon_m_q3_pknows_current X1);  assumption.
  tauto.
Defined.

Remark rem_69 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1:term, auto__q2 X1 -> auto_knows_current (h X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1. intros A1.
  case (rem_68 epsilon_m_q3_pknows_current X1 A1). clear  epsilon_m_q3_pknows_current A1. intros. apply trans_knows_current_h_3;  tauto.
 clear  epsilon_m_q3_pknows_current A1. tauto.
Defined.

Inductive or_2(H1 H2:Prop) : Prop :=
    or_2_intro_1 : H1 -> (or_2 H1 H2)
  | or_2_intro_2 : H2 -> (or_2 H1 H2)
.

Remark rem_70 : forall X1:term, auto__q3 (h X1) -> or_2
    (auto__q3 X1)    (auto__q2 X1).
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_71 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1:term, auto__q3 (h X1) -> auto_knows_current (h X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1. intro H. intros.
  elim (rem_70 X1 H);  intros.
  apply (rem_67 epsilon_m_q3_pknows_current X1);  tauto.
  apply (rem_69 epsilon_m_q3_pknows_current X1);  tauto.
Defined.

Remark rem_72 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1:term, auto__q2 X1 -> auto_knows_current (nai X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1. intros A1.
  case (rem_68 epsilon_m_q3_pknows_current X1 A1). clear  epsilon_m_q3_pknows_current A1. intros. apply trans_knows_current_nai_3;  tauto.
 clear  epsilon_m_q3_pknows_current A1. tauto.
Defined.

Remark rem_73 : forall X1:term, auto__q3 (nai X1) -> or_1
    (auto__q2 X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_74 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1:term, auto__q3 (nai X1) -> auto_knows_current (nai X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1. intro H. intros.
  elim (rem_73 X1 H);  intros.
  apply (rem_72 epsilon_m_q3_pknows_current X1);  tauto.
Defined.

Remark rem_75 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_11 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_76 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_47 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_77 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> (auto__q3 X1 /\ auto__q1 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto__q3 X1). 2:apply (rem_75 epsilon_m_q3_pknows_current X1 X2);  assumption.
  cut (auto__q1 X2). 2:apply (rem_76 epsilon_m_q3_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_78 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_77 epsilon_m_q3_pknows_current X1 X2 A1 A2). clear  epsilon_m_q3_pknows_current A1 A2. intros. apply trans_knows_current_key_1;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2. tauto.
Defined.

Remark rem_79 : forall X1 X2:term, auto__q3 (key X1 X2) -> or_1
    (auto__q3 X1 /\ auto__q1 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_80 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 (key X1 X2) -> auto_knows_current (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_79 X1 X2 H);  intros.
  apply (rem_78 epsilon_m_q3_pknows_current X1 X2);  tauto.
Defined.

Remark rem_81 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_11 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_82 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_5 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_83 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_42 epsilon_m_q3_pknows_current X3).
Defined.

Remark rem_84 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> (auto__q3 X1 /\ auto__q3 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_81 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_82 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_83 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_85 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_84 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_current_1;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_86 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_11 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_87 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_47 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_88 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_42 epsilon_m_q3_pknows_current X3).
Defined.

Remark rem_89 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> (auto__q3 X1 /\ auto__q1 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_86 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_87 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_88 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_90 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_89 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_current_3;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_91 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_11 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_92 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_47 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_93 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q1 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X3 -> auto__q1 X3). tauto. exact (rem_7 epsilon_m_q3_pknows_current X3).
Defined.

Remark rem_94 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> (auto__q3 X1 /\ auto__q1 X2 /\ auto__q1 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_91 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_92 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X3). 2:apply (rem_93 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_95 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_knows_current (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_94 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_current_6;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_96 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_11 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_97 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_13 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_98 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_20 epsilon_m_q3_pknows_current X3).
Defined.

Remark rem_99 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> (auto__q3 X1 /\ auto__q2 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_96 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_97 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_98 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_100 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_99 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_current_7;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_101 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_3 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_102 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_5 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_103 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_20 epsilon_m_q3_pknows_current X3).
Defined.

Remark rem_104 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> (auto__q2 X1 /\ auto__q3 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_101 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_102 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_103 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_105 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_knows_current (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_104 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_current_8;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_106 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_11 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_107 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_13 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_108 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_42 epsilon_m_q3_pknows_current X3).
Defined.

Remark rem_109 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> (auto__q3 X1 /\ auto__q2 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_106 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_107 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_108 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_110 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_current (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_109 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_current_9;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_111 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_29 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_112 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_13 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_113 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_20 epsilon_m_q3_pknows_current X3).
Defined.

Remark rem_114 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> (auto__q1 X1 /\ auto__q2 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_111 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_112 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_113 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_115 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_114 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_current_10;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_116 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_11 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_117 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_47 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_118 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_20 epsilon_m_q3_pknows_current X3).
Defined.

Remark rem_119 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> (auto__q3 X1 /\ auto__q1 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_116 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_117 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_118 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_120 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_119 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_current_11;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_121 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_29 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_122 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_47 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_123 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_20 epsilon_m_q3_pknows_current X3).
Defined.

Remark rem_124 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> (auto__q1 X1 /\ auto__q1 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_121 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_122 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_123 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_125 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_124 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_current_13;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_126 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_29 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_127 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_5 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_128 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_42 epsilon_m_q3_pknows_current X3).
Defined.

Remark rem_129 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> (auto__q1 X1 /\ auto__q3 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_126 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_127 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_128 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_130 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_129 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_current_14;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_131 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_29 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_132 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_47 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_133 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_42 epsilon_m_q3_pknows_current X3).
Defined.

Remark rem_134 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> (auto__q1 X1 /\ auto__q1 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_131 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_132 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_133 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_135 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_134 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_current_15;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Inductive or_11(H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11:Prop) : Prop :=
    or_11_intro_1 : H1 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_2 : H2 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_3 : H3 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_4 : H4 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_5 : H5 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_6 : H6 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_7 : H7 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_8 : H8 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_9 : H9 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_10 : H10 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_11 : H11 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
.

Remark rem_136 : forall X1 X2 X3:term, auto__q3 (nonces_current X1 X2 X3) -> or_11
    (auto__q3 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q3 X1 /\ auto__q1 X2 /\ auto__q3 X3)
    (auto__q3 X1 /\ auto__q1 X2 /\ auto__q1 X3)
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q2 X1 /\ auto__q3 X2 /\ auto__q2 X3)
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q3 X1 /\ auto__q1 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q1 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q1 X2 /\ auto__q3 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_11_intro_1; tauto.
  intros. apply or_11_intro_2; tauto.
  intros. apply or_11_intro_3; tauto.
  intros. apply or_11_intro_4; tauto.
  intros. apply or_11_intro_5; tauto.
  intros. apply or_11_intro_6; tauto.
  intros. apply or_11_intro_7; tauto.
  intros. apply or_11_intro_8; tauto.
  intros. apply or_11_intro_9; tauto.
  intros. apply or_11_intro_10; tauto.
  intros. apply or_11_intro_11; tauto.
Qed.

Remark rem_137 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 (nonces_current X1 X2 X3) -> auto_knows_current (nonces_current X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intro H. intros.
  elim (rem_136 X1 X2 X3 H);  intros.
  apply (rem_85 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_90 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_95 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_100 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_105 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_110 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_115 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_120 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_125 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_130 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_135 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
Defined.

Remark rem_138 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_3 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_139 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_5 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_140 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> (auto__q2 X1 /\ auto__q3 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto__q2 X1). 2:apply (rem_138 epsilon_m_q3_pknows_current X1 X2);  assumption.
  cut (auto__q3 X2). 2:apply (rem_139 epsilon_m_q3_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_141 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto_knows_current (f2 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_140 epsilon_m_q3_pknows_current X1 X2 A1 A2). clear  epsilon_m_q3_pknows_current A1 A2. intros. apply trans_knows_current_f2_1;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2. tauto.
Defined.

Remark rem_142 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_29 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_143 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_5 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_144 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> (auto__q1 X1 /\ auto__q3 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto__q1 X1). 2:apply (rem_142 epsilon_m_q3_pknows_current X1 X2);  assumption.
  cut (auto__q3 X2). 2:apply (rem_143 epsilon_m_q3_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_145 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto_knows_current (f2 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_144 epsilon_m_q3_pknows_current X1 X2 A1 A2). clear  epsilon_m_q3_pknows_current A1 A2. intros. apply trans_knows_current_f2_3;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2. tauto.
Defined.

Remark rem_146 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_11 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_147 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_5 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_148 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> (auto__q3 X1 /\ auto__q3 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto__q3 X1). 2:apply (rem_146 epsilon_m_q3_pknows_current X1 X2);  assumption.
  cut (auto__q3 X2). 2:apply (rem_147 epsilon_m_q3_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_149 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto_knows_current (f2 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_148 epsilon_m_q3_pknows_current X1 X2 A1 A2). clear  epsilon_m_q3_pknows_current A1 A2. intros. apply trans_knows_current_f2_5;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2. tauto.
Defined.

Inductive or_3(H1 H2 H3:Prop) : Prop :=
    or_3_intro_1 : H1 -> (or_3 H1 H2 H3)
  | or_3_intro_2 : H2 -> (or_3 H1 H2 H3)
  | or_3_intro_3 : H3 -> (or_3 H1 H2 H3)
.

Remark rem_150 : forall X1 X2:term, auto__q3 (f2 X1 X2) -> or_3
    (auto__q2 X1 /\ auto__q3 X2)
    (auto__q1 X1 /\ auto__q3 X2)
    (auto__q3 X1 /\ auto__q3 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_151 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 (f2 X1 X2) -> auto_knows_current (f2 X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_150 X1 X2 H);  intros.
  apply (rem_141 epsilon_m_q3_pknows_current X1 X2);  tauto.
  apply (rem_145 epsilon_m_q3_pknows_current X1 X2);  tauto.
  apply (rem_149 epsilon_m_q3_pknows_current X1 X2);  tauto.
Defined.

Remark rem_152 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto_knows_current (f3 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_144 epsilon_m_q3_pknows_current X1 X2 A1 A2). clear  epsilon_m_q3_pknows_current A1 A2. intros. apply trans_knows_current_f3_2;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2. tauto.
Defined.

Remark rem_153 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_29 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_154 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_47 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_155 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> (auto__q1 X1 /\ auto__q1 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto__q1 X1). 2:apply (rem_153 epsilon_m_q3_pknows_current X1 X2);  assumption.
  cut (auto__q1 X2). 2:apply (rem_154 epsilon_m_q3_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_156 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_knows_current (f3 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_155 epsilon_m_q3_pknows_current X1 X2 A1 A2). clear  epsilon_m_q3_pknows_current A1 A2. intros. apply trans_knows_current_f3_6;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2. tauto.
Defined.

Remark rem_157 : forall X1 X2:term, auto__q3 (f3 X1 X2) -> or_2
    (auto__q1 X1 /\ auto__q3 X2)
    (auto__q1 X1 /\ auto__q1 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_158 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 (f3 X1 X2) -> auto_knows_current (f3 X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_157 X1 X2 H);  intros.
  apply (rem_152 epsilon_m_q3_pknows_current X1 X2);  tauto.
  apply (rem_156 epsilon_m_q3_pknows_current X1 X2);  tauto.
Defined.

Remark rem_159 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_current (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_16 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_f1_6;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_160 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_114 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_f1_7;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_161 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_3 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_162 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_47 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_163 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_42 epsilon_m_q3_pknows_current X3).
Defined.

Remark rem_164 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> (auto__q2 X1 /\ auto__q1 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_161 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_162 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_163 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_165 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_164 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_f1_9;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_166 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_22 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_f1_10;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_167 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_129 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_f1_13;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_168 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_134 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_f1_14;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Inductive or_6(H1 H2 H3 H4 H5 H6:Prop) : Prop :=
    or_6_intro_1 : H1 -> (or_6 H1 H2 H3 H4 H5 H6)
  | or_6_intro_2 : H2 -> (or_6 H1 H2 H3 H4 H5 H6)
  | or_6_intro_3 : H3 -> (or_6 H1 H2 H3 H4 H5 H6)
  | or_6_intro_4 : H4 -> (or_6 H1 H2 H3 H4 H5 H6)
  | or_6_intro_5 : H5 -> (or_6 H1 H2 H3 H4 H5 H6)
  | or_6_intro_6 : H6 -> (or_6 H1 H2 H3 H4 H5 H6)
.

Remark rem_169 : forall X1 X2 X3:term, auto__q3 (f1 X1 X2 X3) -> or_6
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q1 X2 /\ auto__q3 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_6_intro_1; tauto.
  intros. apply or_6_intro_2; tauto.
  intros. apply or_6_intro_3; tauto.
  intros. apply or_6_intro_4; tauto.
  intros. apply or_6_intro_5; tauto.
  intros. apply or_6_intro_6; tauto.
Qed.

Remark rem_170 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 (f1 X1 X2 X3) -> auto_knows_current (f1 X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intro H. intros.
  elim (rem_169 X1 X2 X3 H);  intros.
  apply (rem_159 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_160 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_165 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_166 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_167 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_168 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
Defined.

Remark rem_171 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto_knows_current (f4 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_144 epsilon_m_q3_pknows_current X1 X2 A1 A2). clear  epsilon_m_q3_pknows_current A1 A2. intros. apply trans_knows_current_f4_2;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2. tauto.
Defined.

Remark rem_172 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_3 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_173 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_13 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_174 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> (auto__q2 X1 /\ auto__q2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto__q2 X1). 2:apply (rem_172 epsilon_m_q3_pknows_current X1 X2);  assumption.
  cut (auto__q2 X2). 2:apply (rem_173 epsilon_m_q3_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_175 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto_knows_current (f4 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_174 epsilon_m_q3_pknows_current X1 X2 A1 A2). clear  epsilon_m_q3_pknows_current A1 A2. intros. apply trans_knows_current_f4_4;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2. tauto.
Defined.

Remark rem_176 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_11 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_177 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_13 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_178 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> (auto__q3 X1 /\ auto__q2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto__q3 X1). 2:apply (rem_176 epsilon_m_q3_pknows_current X1 X2);  assumption.
  cut (auto__q2 X2). 2:apply (rem_177 epsilon_m_q3_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_179 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto_knows_current (f4 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_178 epsilon_m_q3_pknows_current X1 X2 A1 A2). clear  epsilon_m_q3_pknows_current A1 A2. intros. apply trans_knows_current_f4_5;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2. tauto.
Defined.

Remark rem_180 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_knows_current (f4 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_155 epsilon_m_q3_pknows_current X1 X2 A1 A2). clear  epsilon_m_q3_pknows_current A1 A2. intros. apply trans_knows_current_f4_6;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2. tauto.
Defined.

Inductive or_4(H1 H2 H3 H4:Prop) : Prop :=
    or_4_intro_1 : H1 -> (or_4 H1 H2 H3 H4)
  | or_4_intro_2 : H2 -> (or_4 H1 H2 H3 H4)
  | or_4_intro_3 : H3 -> (or_4 H1 H2 H3 H4)
  | or_4_intro_4 : H4 -> (or_4 H1 H2 H3 H4)
.

Remark rem_181 : forall X1 X2:term, auto__q3 (f4 X1 X2) -> or_4
    (auto__q1 X1 /\ auto__q3 X2)
    (auto__q2 X1 /\ auto__q2 X2)
    (auto__q3 X1 /\ auto__q2 X2)
    (auto__q1 X1 /\ auto__q1 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_4_intro_1; tauto.
  intros. apply or_4_intro_2; tauto.
  intros. apply or_4_intro_3; tauto.
  intros. apply or_4_intro_4; tauto.
Qed.

Remark rem_182 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 (f4 X1 X2) -> auto_knows_current (f4 X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_181 X1 X2 H);  intros.
  apply (rem_171 epsilon_m_q3_pknows_current X1 X2);  tauto.
  apply (rem_175 epsilon_m_q3_pknows_current X1 X2);  tauto.
  apply (rem_179 epsilon_m_q3_pknows_current X1 X2);  tauto.
  apply (rem_180 epsilon_m_q3_pknows_current X1 X2);  tauto.
Defined.

Remark rem_183 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> auto_knows_current server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current.  case (rem_63 epsilon_m_q3_pknows_current). clear  epsilon_m_q3_pknows_current. intros. apply trans_knows_current_server_1;  tauto.
 clear  epsilon_m_q3_pknows_current. tauto.
Defined.

Remark rem_184 : auto__q3 server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_185 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> auto__q3 server -> auto_knows_current server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intro H. intros.
  elim (rem_184 H);  intros.
  apply (rem_183 epsilon_m_q3_pknows_current);  tauto.
Defined.

Remark rem_186 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_144 epsilon_m_q3_pknows_current X1 X2 A1 A2). clear  epsilon_m_q3_pknows_current A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2. tauto.
Defined.

Remark rem_187 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_77 epsilon_m_q3_pknows_current X1 X2 A1 A2). clear  epsilon_m_q3_pknows_current A1 A2. intros. apply trans_knows_current_cons_2;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2. tauto.
Defined.

Remark rem_188 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_148 epsilon_m_q3_pknows_current X1 X2 A1 A2). clear  epsilon_m_q3_pknows_current A1 A2. intros. apply trans_knows_current_cons_3;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2. tauto.
Defined.

Remark rem_189 : forall X1 X2:term, auto__q3 (cons X1 X2) -> or_3
    (auto__q1 X1 /\ auto__q3 X2)
    (auto__q3 X1 /\ auto__q1 X2)
    (auto__q3 X1 /\ auto__q3 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_190 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_189 X1 X2 H);  intros.
  apply (rem_186 epsilon_m_q3_pknows_current X1 X2);  tauto.
  apply (rem_187 epsilon_m_q3_pknows_current X1 X2);  tauto.
  apply (rem_188 epsilon_m_q3_pknows_current X1 X2);  tauto.
Defined.

Remark rem_191 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_84 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_old_1;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_192 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_3 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_193 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_5 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_194 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_42 epsilon_m_q3_pknows_current X3).
Defined.

Remark rem_195 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> (auto__q2 X1 /\ auto__q3 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_192 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_193 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_194 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_196 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_195 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_old_2;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_197 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_current (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_109 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_old_4;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_198 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_current (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_16 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_old_5;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_199 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_114 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_old_6;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_200 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_164 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_old_8;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_201 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_29 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_202 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_13 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_203 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X3 -> auto__q1 X3). tauto. exact (rem_7 epsilon_m_q3_pknows_current X3).
Defined.

Remark rem_204 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> (auto__q1 X1 /\ auto__q2 X2 /\ auto__q1 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_201 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_202 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X3). 2:apply (rem_203 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_205 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_current (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_204 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_old_10;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_206 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_124 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_old_11;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_207 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_knows_current (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_33 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_old_12;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_208 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_knows_current (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_38 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_old_13;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Inductive or_10(H1 H2 H3 H4 H5 H6 H7 H8 H9 H10:Prop) : Prop :=
    or_10_intro_1 : H1 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_2 : H2 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_3 : H3 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_4 : H4 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_5 : H5 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_6 : H6 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_7 : H7 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_8 : H8 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_9 : H9 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_10 : H10 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
.

Remark rem_209 : forall X1 X2 X3:term, auto__q3 (session_old X1 X2 X3) -> or_10
    (auto__q3 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q3 X3)
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q1 X1 /\ auto__q1 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q1 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q2 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_10_intro_1; tauto.
  intros. apply or_10_intro_2; tauto.
  intros. apply or_10_intro_3; tauto.
  intros. apply or_10_intro_4; tauto.
  intros. apply or_10_intro_5; tauto.
  intros. apply or_10_intro_6; tauto.
  intros. apply or_10_intro_7; tauto.
  intros. apply or_10_intro_8; tauto.
  intros. apply or_10_intro_9; tauto.
  intros. apply or_10_intro_10; tauto.
Qed.

Remark rem_210 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 (session_old X1 X2 X3) -> auto_knows_current (session_old X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intro H. intros.
  elim (rem_209 X1 X2 X3 H);  intros.
  apply (rem_191 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_196 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_197 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_198 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_199 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_200 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_205 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_206 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_207 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_208 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
Defined.

Remark rem_211 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> auto_knows_current bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current.  case (rem_63 epsilon_m_q3_pknows_current). clear  epsilon_m_q3_pknows_current. intros. apply trans_knows_current_bob_1;  tauto.
 clear  epsilon_m_q3_pknows_current. tauto.
Defined.

Remark rem_212 : auto__q3 bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_213 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> auto__q3 bob -> auto_knows_current bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intro H. intros.
  elim (rem_212 H);  intros.
  apply (rem_211 epsilon_m_q3_pknows_current);  tauto.
Defined.

Remark rem_214 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_3 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_215 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_47 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_216 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> (auto__q2 X1 /\ auto__q1 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto__q2 X1). 2:apply (rem_214 epsilon_m_q3_pknows_current X1 X2);  assumption.
  cut (auto__q1 X2). 2:apply (rem_215 epsilon_m_q3_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_217 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_216 epsilon_m_q3_pknows_current X1 X2 A1 A2). clear  epsilon_m_q3_pknows_current A1 A2. intros. apply trans_knows_current_crypt_2;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2. tauto.
Defined.

Remark rem_218 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_77 epsilon_m_q3_pknows_current X1 X2 A1 A2). clear  epsilon_m_q3_pknows_current A1 A2. intros. apply trans_knows_current_crypt_4;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2. tauto.
Defined.

Remark rem_219 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_174 epsilon_m_q3_pknows_current X1 X2 A1 A2). clear  epsilon_m_q3_pknows_current A1 A2. intros. apply trans_knows_current_crypt_5;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2. tauto.
Defined.

Remark rem_220 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_148 epsilon_m_q3_pknows_current X1 X2 A1 A2). clear  epsilon_m_q3_pknows_current A1 A2. intros. apply trans_knows_current_crypt_7;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2. tauto.
Defined.

Remark rem_221 : forall X1 X2:term, auto__q3 (crypt X1 X2) -> or_4
    (auto__q2 X1 /\ auto__q1 X2)
    (auto__q3 X1 /\ auto__q1 X2)
    (auto__q2 X1 /\ auto__q2 X2)
    (auto__q3 X1 /\ auto__q3 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_4_intro_1; tauto.
  intros. apply or_4_intro_2; tauto.
  intros. apply or_4_intro_3; tauto.
  intros. apply or_4_intro_4; tauto.
Qed.

Remark rem_222 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 (crypt X1 X2) -> auto_knows_current (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_221 X1 X2 H);  intros.
  apply (rem_217 epsilon_m_q3_pknows_current X1 X2);  tauto.
  apply (rem_218 epsilon_m_q3_pknows_current X1 X2);  tauto.
  apply (rem_219 epsilon_m_q3_pknows_current X1 X2);  tauto.
  apply (rem_220 epsilon_m_q3_pknows_current X1 X2);  tauto.
Defined.

Remark rem_223 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_195 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_old_3;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_224 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_3 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_225 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_13 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_226 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X3 -> auto__q1 X3). tauto. exact (rem_7 epsilon_m_q3_pknows_current X3).
Defined.

Remark rem_227 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> (auto__q2 X1 /\ auto__q2 X2 /\ auto__q1 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_224 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_225 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X3). 2:apply (rem_226 epsilon_m_q3_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_228 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_current (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_227 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_old_4;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_229 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_knows_current (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_94 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_old_5;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_230 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_99 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_old_6;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_231 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_knows_current (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_9 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_old_7;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_232 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_knows_current (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_104 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_old_8;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_233 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_current (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_16 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_old_10;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_234 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_114 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_old_11;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_235 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_knows_current (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_33 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_old_18;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_236 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_knows_current (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_50 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_old_23;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_237 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_55 epsilon_m_q3_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q3_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_old_24;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_238 : forall X1 X2 X3:term, auto__q3 (nonces_old X1 X2 X3) -> or_11
    (auto__q2 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q3 X1 /\ auto__q1 X2 /\ auto__q1 X3)
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q2 X1 /\ auto__q3 X2 /\ auto__q1 X3)
    (auto__q2 X1 /\ auto__q3 X2 /\ auto__q2 X3)
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q1 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q1 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q2 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_11_intro_1; tauto.
  intros. apply or_11_intro_2; tauto.
  intros. apply or_11_intro_3; tauto.
  intros. apply or_11_intro_4; tauto.
  intros. apply or_11_intro_5; tauto.
  intros. apply or_11_intro_6; tauto.
  intros. apply or_11_intro_7; tauto.
  intros. apply or_11_intro_8; tauto.
  intros. apply or_11_intro_9; tauto.
  intros. apply or_11_intro_10; tauto.
  intros. apply or_11_intro_11; tauto.
Qed.

Remark rem_239 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 (nonces_old X1 X2 X3) -> auto_knows_current (nonces_old X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2 X3. intro H. intros.
  elim (rem_238 X1 X2 X3 H);  intros.
  apply (rem_223 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_228 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_229 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_230 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_231 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_232 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_233 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_234 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_235 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_236 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
  apply (rem_237 epsilon_m_q3_pknows_current X1 X2 X3);  tauto.
Defined.

Remark rem_240 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> auto_knows_current alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current.  case (rem_63 epsilon_m_q3_pknows_current). clear  epsilon_m_q3_pknows_current. intros. apply trans_knows_current_alice_1;  tauto.
 clear  epsilon_m_q3_pknows_current. tauto.
Defined.

Remark rem_241 : auto__q3 alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_242 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> auto__q3 alice -> auto_knows_current alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intro H. intros.
  elim (rem_241 H);  intros.
  apply (rem_240 epsilon_m_q3_pknows_current);  tauto.
Defined.

Remark rem_243 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto_knows_current (f5 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_216 epsilon_m_q3_pknows_current X1 X2 A1 A2). clear  epsilon_m_q3_pknows_current A1 A2. intros. apply trans_knows_current_f5_1;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2. tauto.
Defined.

Remark rem_244 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto_knows_current (f5 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_144 epsilon_m_q3_pknows_current X1 X2 A1 A2). clear  epsilon_m_q3_pknows_current A1 A2. intros. apply trans_knows_current_f5_2;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2. tauto.
Defined.

Remark rem_245 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_knows_current (f5 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_77 epsilon_m_q3_pknows_current X1 X2 A1 A2). clear  epsilon_m_q3_pknows_current A1 A2. intros. apply trans_knows_current_f5_3;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2. tauto.
Defined.

Remark rem_246 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto_knows_current (f5 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_174 epsilon_m_q3_pknows_current X1 X2 A1 A2). clear  epsilon_m_q3_pknows_current A1 A2. intros. apply trans_knows_current_f5_4;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2. tauto.
Defined.

Remark rem_247 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto_knows_current (f5 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_178 epsilon_m_q3_pknows_current X1 X2 A1 A2). clear  epsilon_m_q3_pknows_current A1 A2. intros. apply trans_knows_current_f5_5;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2. tauto.
Defined.

Remark rem_248 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_knows_current (f5 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_155 epsilon_m_q3_pknows_current X1 X2 A1 A2). clear  epsilon_m_q3_pknows_current A1 A2. intros. apply trans_knows_current_f5_6;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2. tauto.
Defined.

Remark rem_249 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_29 epsilon_m_q3_pknows_current X1).
Defined.

Remark rem_250 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_13 epsilon_m_q3_pknows_current X2).
Defined.

Remark rem_251 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> (auto__q1 X1 /\ auto__q2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto__q1 X1). 2:apply (rem_249 epsilon_m_q3_pknows_current X1 X2);  assumption.
  cut (auto__q2 X2). 2:apply (rem_250 epsilon_m_q3_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_252 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto_knows_current (f5 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_251 epsilon_m_q3_pknows_current X1 X2 A1 A2). clear  epsilon_m_q3_pknows_current A1 A2. intros. apply trans_knows_current_f5_7;  tauto.
 clear  epsilon_m_q3_pknows_current A1 A2. tauto.
Defined.

Inductive or_7(H1 H2 H3 H4 H5 H6 H7:Prop) : Prop :=
    or_7_intro_1 : H1 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_2 : H2 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_3 : H3 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_4 : H4 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_5 : H5 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_6 : H6 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_7 : H7 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
.

Remark rem_253 : forall X1 X2:term, auto__q3 (f5 X1 X2) -> or_7
    (auto__q2 X1 /\ auto__q1 X2)
    (auto__q1 X1 /\ auto__q3 X2)
    (auto__q3 X1 /\ auto__q1 X2)
    (auto__q2 X1 /\ auto__q2 X2)
    (auto__q3 X1 /\ auto__q2 X2)
    (auto__q1 X1 /\ auto__q1 X2)
    (auto__q1 X1 /\ auto__q2 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_7_intro_1; tauto.
  intros. apply or_7_intro_2; tauto.
  intros. apply or_7_intro_3; tauto.
  intros. apply or_7_intro_4; tauto.
  intros. apply or_7_intro_5; tauto.
  intros. apply or_7_intro_6; tauto.
  intros. apply or_7_intro_7; tauto.
Qed.

Remark rem_254 : (forall X:term, auto__q3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 (f5 X1 X2) -> auto_knows_current (f5 X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q3_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_253 X1 X2 H);  intros.
  apply (rem_243 epsilon_m_q3_pknows_current X1 X2);  tauto.
  apply (rem_244 epsilon_m_q3_pknows_current X1 X2);  tauto.
  apply (rem_245 epsilon_m_q3_pknows_current X1 X2);  tauto.
  apply (rem_246 epsilon_m_q3_pknows_current X1 X2);  tauto.
  apply (rem_247 epsilon_m_q3_pknows_current X1 X2);  tauto.
  apply (rem_248 epsilon_m_q3_pknows_current X1 X2);  tauto.
  apply (rem_252 epsilon_m_q3_pknows_current X1 X2);  tauto.
Defined.

Inductive or_0 : Prop :=
.

Remark rem_255 : auto__q3 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_256 : auto__q3 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_257 : auto__q3 request_id -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_258 : auto__q3 success -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_259 : auto__q3 respond_id -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_260 : auto__q3 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_261 : auto__q3 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_262 : forall X1:term, auto__q3 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_m_q3_pknows_current 1.
  intro X. case X.
  exact (rem_242 epsilon_m_q3_pknows_current ).
  exact (rem_213 epsilon_m_q3_pknows_current ).
  intros X1 X2;  exact (rem_190 epsilon_m_q3_pknows_current X1 X2).
  intros X1 X2;  exact (rem_222 epsilon_m_q3_pknows_current X1 X2).
  intros X1 X2 X3;  exact (rem_170 epsilon_m_q3_pknows_current X1 X2 X3).
  intros X1 X2;  exact (rem_151 epsilon_m_q3_pknows_current X1 X2).
  intros X1 X2;  exact (rem_158 epsilon_m_q3_pknows_current X1 X2).
  intros X1 X2;  exact (rem_182 epsilon_m_q3_pknows_current X1 X2).
  intros X1 X2;  exact (rem_254 epsilon_m_q3_pknows_current X1 X2).
  intros X1;  exact (rem_71 epsilon_m_q3_pknows_current X1).
  exact (rem_66 epsilon_m_q3_pknows_current ).
  intros X1 X2;  exact (rem_80 epsilon_m_q3_pknows_current X1 X2).
  intros X1;  exact (rem_74 epsilon_m_q3_pknows_current X1).
   intro H. elim (rem_256  H).
  intros X1 X2 X3;  exact (rem_137 epsilon_m_q3_pknows_current X1 X2 X3).
  intros X1 X2 X3;  exact (rem_239 epsilon_m_q3_pknows_current X1 X2 X3).
   intro H. elim (rem_261  H).
   intro H. elim (rem_260  H).
   intro H. elim (rem_257  H).
   intro H. elim (rem_259  H).
  intros X1;  exact (rem_62 epsilon_m_q3_pknows_current X1).
  exact (rem_185 epsilon_m_q3_pknows_current ).
  intros X1 X2 X3;  exact (rem_58 epsilon_m_q3_pknows_current X1 X2 X3).
  intros X1 X2 X3;  exact (rem_210 epsilon_m_q3_pknows_current X1 X2 X3).
   intro H. elim (rem_258  H).
   intro H. elim (rem_255  H).
Qed.

Remark rem_263 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1:term, auto__q3 X1 -> auto__q3 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_264 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_263 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_265 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X2:term, auto__q3 X2 -> auto__q3 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_266 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_265 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_267 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X3:term, auto__q3 X3 -> auto__q3 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_268 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_267 epsilon_m_q1_pknows_current X3).
Defined.

Remark rem_269 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> (auto__q3 X1 /\ auto__q3 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_264 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_266 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_268 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_270 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_269 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_current_1;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_271 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1:term, auto__q2 X1 -> auto__q2 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_272 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_271 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_273 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X2:term, auto__q2 X2 -> auto__q2 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_274 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_273 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_275 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_267 epsilon_m_q1_pknows_current X3).
Defined.

Remark rem_276 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> (auto__q2 X1 /\ auto__q2 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_272 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_274 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_275 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_277 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_current (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_276 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_current_2;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_278 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_271 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_279 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_265 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_280 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_267 epsilon_m_q1_pknows_current X3).
Defined.

Remark rem_281 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> (auto__q2 X1 /\ auto__q3 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_278 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_279 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_280 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_282 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_281 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_current_3;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_283 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_271 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_284 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_273 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_285 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X3:term, auto__q1 X3 -> auto__q1 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_286 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X3 -> auto__q1 X3). tauto. exact (rem_285 epsilon_m_q1_pknows_current X3).
Defined.

Remark rem_287 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> (auto__q2 X1 /\ auto__q2 X2 /\ auto__q1 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_283 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_284 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X3). 2:apply (rem_286 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_288 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_current (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_287 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_current_4;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_289 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1:term, auto__q1 X1 -> auto__q1 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_290 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_289 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_291 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_273 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_292 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X3:term, auto__q2 X3 -> auto__q2 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_293 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_292 epsilon_m_q1_pknows_current X3).
Defined.

Remark rem_294 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> (auto__q1 X1 /\ auto__q2 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_290 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_291 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_293 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_295 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_294 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_current_7;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_296 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_271 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_297 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X2:term, auto__q1 X2 -> auto__q1 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_298 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_297 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_299 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_267 epsilon_m_q1_pknows_current X3).
Defined.

Remark rem_300 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> (auto__q2 X1 /\ auto__q1 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_296 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_298 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_299 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_301 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_300 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_current_8;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_302 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_289 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_303 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_265 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_304 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_267 epsilon_m_q1_pknows_current X3).
Defined.

Remark rem_305 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> (auto__q1 X1 /\ auto__q3 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_302 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_303 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_304 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_306 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_305 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_current_12;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_307 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_289 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_308 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_297 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_309 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_267 epsilon_m_q1_pknows_current X3).
Defined.

Remark rem_310 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> (auto__q1 X1 /\ auto__q1 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_307 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_308 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_309 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_311 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_310 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_current_14;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Inductive or_8(H1 H2 H3 H4 H5 H6 H7 H8:Prop) : Prop :=
    or_8_intro_1 : H1 -> (or_8 H1 H2 H3 H4 H5 H6 H7 H8)
  | or_8_intro_2 : H2 -> (or_8 H1 H2 H3 H4 H5 H6 H7 H8)
  | or_8_intro_3 : H3 -> (or_8 H1 H2 H3 H4 H5 H6 H7 H8)
  | or_8_intro_4 : H4 -> (or_8 H1 H2 H3 H4 H5 H6 H7 H8)
  | or_8_intro_5 : H5 -> (or_8 H1 H2 H3 H4 H5 H6 H7 H8)
  | or_8_intro_6 : H6 -> (or_8 H1 H2 H3 H4 H5 H6 H7 H8)
  | or_8_intro_7 : H7 -> (or_8 H1 H2 H3 H4 H5 H6 H7 H8)
  | or_8_intro_8 : H8 -> (or_8 H1 H2 H3 H4 H5 H6 H7 H8)
.

Remark rem_312 : forall X1 X2 X3:term, auto__q1 (session_current X1 X2 X3) -> or_8
    (auto__q3 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q1 X2 /\ auto__q3 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_8_intro_1; tauto.
  intros. apply or_8_intro_2; tauto.
  intros. apply or_8_intro_3; tauto.
  intros. apply or_8_intro_4; tauto.
  intros. apply or_8_intro_5; tauto.
  intros. apply or_8_intro_6; tauto.
  intros. apply or_8_intro_7; tauto.
  intros. apply or_8_intro_8; tauto.
Qed.

Remark rem_313 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 (session_current X1 X2 X3) -> auto_knows_current (session_current X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intro H. intros.
  elim (rem_312 X1 X2 X3 H);  intros.
  apply (rem_270 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_277 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_282 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_288 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_295 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_301 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_306 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_311 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
Defined.

Remark rem_314 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current.  tauto.
Defined.

Remark rem_315 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> auto_knows_current sym. (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current.  case (rem_314 epsilon_m_q1_pknows_current). clear  epsilon_m_q1_pknows_current. intros. apply trans_knows_current_sym_1;  tauto.
 clear  epsilon_m_q1_pknows_current. tauto.
Defined.

Remark rem_316 : auto__q1 sym -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_317 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> auto__q1 sym -> auto_knows_current sym. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intro H. intros.
  elim (rem_316 H);  intros.
  apply (rem_315 epsilon_m_q1_pknows_current);  tauto.
Defined.

Remark rem_318 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1:term, auto__q1 X1 -> auto__q1 X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1. intros A1.
  cut (auto__q1 X1). 2:apply (rem_289 epsilon_m_q1_pknows_current X1);  assumption.
  tauto.
Defined.

Remark rem_319 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1:term, auto__q1 X1 -> auto_knows_current (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1. intros A1.
  case (rem_318 epsilon_m_q1_pknows_current X1 A1). clear  epsilon_m_q1_pknows_current A1. intros. apply trans_knows_current_s_2;  tauto.
 clear  epsilon_m_q1_pknows_current A1. tauto.
Defined.

Remark rem_320 : forall X1:term, auto__q1 (s X1) -> or_1
    (auto__q1 X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_321 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1:term, auto__q1 (s X1) -> auto_knows_current (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1. intro H. intros.
  elim (rem_320 X1 H);  intros.
  apply (rem_319 epsilon_m_q1_pknows_current X1);  tauto.
Defined.

Remark rem_322 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> auto_knows_current nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current.  case (rem_314 epsilon_m_q1_pknows_current). clear  epsilon_m_q1_pknows_current. intros. apply trans_knows_current_nil_1;  tauto.
 clear  epsilon_m_q1_pknows_current. tauto.
Defined.

Remark rem_323 : auto__q1 nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_324 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> auto__q1 nil -> auto_knows_current nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intro H. intros.
  elim (rem_323 H);  intros.
  apply (rem_322 epsilon_m_q1_pknows_current);  tauto.
Defined.

Remark rem_325 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> auto_knows_current request_id. (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current.  case (rem_314 epsilon_m_q1_pknows_current). clear  epsilon_m_q1_pknows_current. intros. apply trans_knows_current_request_id_1;  tauto.
 clear  epsilon_m_q1_pknows_current. tauto.
Defined.

Remark rem_326 : auto__q1 request_id -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_327 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> auto__q1 request_id -> auto_knows_current request_id. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intro H. intros.
  elim (rem_326 H);  intros.
  apply (rem_325 epsilon_m_q1_pknows_current);  tauto.
Defined.

Remark rem_328 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1:term, auto__q1 X1 -> auto_knows_current (h X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1. intros A1.
  case (rem_318 epsilon_m_q1_pknows_current X1 A1). clear  epsilon_m_q1_pknows_current A1. intros. apply trans_knows_current_h_2;  tauto.
 clear  epsilon_m_q1_pknows_current A1. tauto.
Defined.

Remark rem_329 : forall X1:term, auto__q1 (h X1) -> or_1
    (auto__q1 X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_330 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1:term, auto__q1 (h X1) -> auto_knows_current (h X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1. intro H. intros.
  elim (rem_329 X1 H);  intros.
  apply (rem_328 epsilon_m_q1_pknows_current X1);  tauto.
Defined.

Remark rem_331 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1:term, auto__q3 X1 -> auto__q3 X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1. intros A1.
  cut (auto__q3 X1). 2:apply (rem_263 epsilon_m_q1_pknows_current X1);  assumption.
  tauto.
Defined.

Remark rem_332 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1:term, auto__q3 X1 -> auto_knows_current (nai X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1. intros A1.
  case (rem_331 epsilon_m_q1_pknows_current X1 A1). clear  epsilon_m_q1_pknows_current A1. intros. apply trans_knows_current_nai_1;  tauto.
 clear  epsilon_m_q1_pknows_current A1. tauto.
Defined.

Remark rem_333 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1:term, auto__q1 X1 -> auto_knows_current (nai X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1. intros A1.
  case (rem_318 epsilon_m_q1_pknows_current X1 A1). clear  epsilon_m_q1_pknows_current A1. intros. apply trans_knows_current_nai_2;  tauto.
 clear  epsilon_m_q1_pknows_current A1. tauto.
Defined.

Remark rem_334 : forall X1:term, auto__q1 (nai X1) -> or_2
    (auto__q3 X1)    (auto__q1 X1).
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_335 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1:term, auto__q1 (nai X1) -> auto_knows_current (nai X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1. intro H. intros.
  elim (rem_334 X1 H);  intros.
  apply (rem_332 epsilon_m_q1_pknows_current X1);  tauto.
  apply (rem_333 epsilon_m_q1_pknows_current X1);  tauto.
Defined.

Remark rem_336 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> auto_knows_current success. (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current.  case (rem_314 epsilon_m_q1_pknows_current). clear  epsilon_m_q1_pknows_current. intros. apply trans_knows_current_success_1;  tauto.
 clear  epsilon_m_q1_pknows_current. tauto.
Defined.

Remark rem_337 : auto__q1 success -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_338 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> auto__q1 success -> auto_knows_current success. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intro H. intros.
  elim (rem_337 H);  intros.
  apply (rem_336 epsilon_m_q1_pknows_current);  tauto.
Defined.

Remark rem_339 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_current (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_276 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_current_2;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_340 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_281 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_current_4;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_341 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_current (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_287 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_current_5;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_342 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_300 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_current_12;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_343 : forall X1 X2 X3:term, auto__q1 (nonces_current X1 X2 X3) -> or_4
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q3 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_4_intro_1; tauto.
  intros. apply or_4_intro_2; tauto.
  intros. apply or_4_intro_3; tauto.
  intros. apply or_4_intro_4; tauto.
Qed.

Remark rem_344 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 (nonces_current X1 X2 X3) -> auto_knows_current (nonces_current X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intro H. intros.
  elim (rem_343 X1 X2 X3 H);  intros.
  apply (rem_339 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_340 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_341 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_342 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
Defined.

Remark rem_345 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> auto_knows_current respond_id. (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current.  case (rem_314 epsilon_m_q1_pknows_current). clear  epsilon_m_q1_pknows_current. intros. apply trans_knows_current_respond_id_1;  tauto.
 clear  epsilon_m_q1_pknows_current. tauto.
Defined.

Remark rem_346 : auto__q1 respond_id -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_347 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> auto__q1 respond_id -> auto_knows_current respond_id. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intro H. intros.
  elim (rem_346 H);  intros.
  apply (rem_345 epsilon_m_q1_pknows_current);  tauto.
Defined.

Remark rem_348 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_271 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_349 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_297 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_350 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> (auto__q2 X1 /\ auto__q1 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto__q2 X1). 2:apply (rem_348 epsilon_m_q1_pknows_current X1 X2);  assumption.
  cut (auto__q1 X2). 2:apply (rem_349 epsilon_m_q1_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_351 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto_knows_current (f2 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_350 epsilon_m_q1_pknows_current X1 X2 A1 A2). clear  epsilon_m_q1_pknows_current A1 A2. intros. apply trans_knows_current_f2_2;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2. tauto.
Defined.

Remark rem_352 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_263 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_353 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_297 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_354 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> (auto__q3 X1 /\ auto__q1 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto__q3 X1). 2:apply (rem_352 epsilon_m_q1_pknows_current X1 X2);  assumption.
  cut (auto__q1 X2). 2:apply (rem_353 epsilon_m_q1_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_355 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_knows_current (f2 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_354 epsilon_m_q1_pknows_current X1 X2 A1 A2). clear  epsilon_m_q1_pknows_current A1 A2. intros. apply trans_knows_current_f2_4;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2. tauto.
Defined.

Remark rem_356 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_289 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_357 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_297 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_358 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> (auto__q1 X1 /\ auto__q1 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto__q1 X1). 2:apply (rem_356 epsilon_m_q1_pknows_current X1 X2);  assumption.
  cut (auto__q1 X2). 2:apply (rem_357 epsilon_m_q1_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_359 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_knows_current (f2 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_358 epsilon_m_q1_pknows_current X1 X2 A1 A2). clear  epsilon_m_q1_pknows_current A1 A2. intros. apply trans_knows_current_f2_6;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2. tauto.
Defined.

Remark rem_360 : forall X1 X2:term, auto__q1 (f2 X1 X2) -> or_3
    (auto__q2 X1 /\ auto__q1 X2)
    (auto__q3 X1 /\ auto__q1 X2)
    (auto__q1 X1 /\ auto__q1 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_361 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 (f2 X1 X2) -> auto_knows_current (f2 X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_360 X1 X2 H);  intros.
  apply (rem_351 epsilon_m_q1_pknows_current X1 X2);  tauto.
  apply (rem_355 epsilon_m_q1_pknows_current X1 X2);  tauto.
  apply (rem_359 epsilon_m_q1_pknows_current X1 X2);  tauto.
Defined.

Remark rem_362 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> auto_knows_current pub. (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current.  case (rem_314 epsilon_m_q1_pknows_current). clear  epsilon_m_q1_pknows_current. intros. apply trans_knows_current_pub_1;  tauto.
 clear  epsilon_m_q1_pknows_current. tauto.
Defined.

Remark rem_363 : auto__q1 pub -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_364 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> auto__q1 pub -> auto_knows_current pub. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intro H. intros.
  elim (rem_363 H);  intros.
  apply (rem_362 epsilon_m_q1_pknows_current);  tauto.
Defined.

Remark rem_365 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto_knows_current (f3 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_350 epsilon_m_q1_pknows_current X1 X2 A1 A2). clear  epsilon_m_q1_pknows_current A1 A2. intros. apply trans_knows_current_f3_1;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2. tauto.
Defined.

Remark rem_366 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_knows_current (f3 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_354 epsilon_m_q1_pknows_current X1 X2 A1 A2). clear  epsilon_m_q1_pknows_current A1 A2. intros. apply trans_knows_current_f3_3;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2. tauto.
Defined.

Remark rem_367 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_271 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_368 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_273 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_369 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> (auto__q2 X1 /\ auto__q2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto__q2 X1). 2:apply (rem_367 epsilon_m_q1_pknows_current X1 X2);  assumption.
  cut (auto__q2 X2). 2:apply (rem_368 epsilon_m_q1_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_370 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto_knows_current (f3 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_369 epsilon_m_q1_pknows_current X1 X2 A1 A2). clear  epsilon_m_q1_pknows_current A1 A2. intros. apply trans_knows_current_f3_4;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2. tauto.
Defined.

Remark rem_371 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_263 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_372 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_273 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_373 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> (auto__q3 X1 /\ auto__q2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto__q3 X1). 2:apply (rem_371 epsilon_m_q1_pknows_current X1 X2);  assumption.
  cut (auto__q2 X2). 2:apply (rem_372 epsilon_m_q1_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_374 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto_knows_current (f3 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_373 epsilon_m_q1_pknows_current X1 X2 A1 A2). clear  epsilon_m_q1_pknows_current A1 A2. intros. apply trans_knows_current_f3_5;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2. tauto.
Defined.

Remark rem_375 : forall X1 X2:term, auto__q1 (f3 X1 X2) -> or_4
    (auto__q2 X1 /\ auto__q1 X2)
    (auto__q3 X1 /\ auto__q1 X2)
    (auto__q2 X1 /\ auto__q2 X2)
    (auto__q3 X1 /\ auto__q2 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_4_intro_1; tauto.
  intros. apply or_4_intro_2; tauto.
  intros. apply or_4_intro_3; tauto.
  intros. apply or_4_intro_4; tauto.
Qed.

Remark rem_376 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 (f3 X1 X2) -> auto_knows_current (f3 X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_375 X1 X2 H);  intros.
  apply (rem_365 epsilon_m_q1_pknows_current X1 X2);  tauto.
  apply (rem_366 epsilon_m_q1_pknows_current X1 X2);  tauto.
  apply (rem_370 epsilon_m_q1_pknows_current X1 X2);  tauto.
  apply (rem_374 epsilon_m_q1_pknows_current X1 X2);  tauto.
Defined.

Remark rem_377 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_269 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_f1_1;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_378 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_281 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_f1_2;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_379 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_current (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_287 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_f1_3;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_380 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_263 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_381 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_297 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_382 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q1 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X3 -> auto__q1 X3). tauto. exact (rem_285 epsilon_m_q1_pknows_current X3).
Defined.

Remark rem_383 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> (auto__q3 X1 /\ auto__q1 X2 /\ auto__q1 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_380 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_381 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X3). 2:apply (rem_382 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_384 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_knows_current (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_383 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_f1_4;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_385 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_263 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_386 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_273 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_387 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_292 epsilon_m_q1_pknows_current X3).
Defined.

Remark rem_388 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> (auto__q3 X1 /\ auto__q2 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_385 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_386 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_387 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_389 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_388 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_f1_5;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_390 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_263 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_391 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_297 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_392 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_292 epsilon_m_q1_pknows_current X3).
Defined.

Remark rem_393 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> (auto__q3 X1 /\ auto__q1 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_390 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_391 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_392 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_394 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_393 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_f1_8;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_395 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_289 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_396 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_273 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_397 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X3 -> auto__q1 X3). tauto. exact (rem_285 epsilon_m_q1_pknows_current X3).
Defined.

Remark rem_398 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> (auto__q1 X1 /\ auto__q2 X2 /\ auto__q1 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_395 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_396 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X3). 2:apply (rem_397 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_399 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_current (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_398 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_f1_11;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_400 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_289 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_401 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_297 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_402 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_292 epsilon_m_q1_pknows_current X3).
Defined.

Remark rem_403 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> (auto__q1 X1 /\ auto__q1 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_400 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_401 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_402 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_404 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_403 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_f1_12;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_405 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_271 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_406 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_297 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_407 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_292 epsilon_m_q1_pknows_current X3).
Defined.

Remark rem_408 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> (auto__q2 X1 /\ auto__q1 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_405 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_406 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_407 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_409 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_408 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_f1_15;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_410 : forall X1 X2 X3:term, auto__q1 (f1 X1 X2 X3) -> or_9
    (auto__q3 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q3 X1 /\ auto__q1 X2 /\ auto__q1 X3)
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q3 X1 /\ auto__q1 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q1 X1 /\ auto__q1 X2 /\ auto__q2 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q2 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_9_intro_1; tauto.
  intros. apply or_9_intro_2; tauto.
  intros. apply or_9_intro_3; tauto.
  intros. apply or_9_intro_4; tauto.
  intros. apply or_9_intro_5; tauto.
  intros. apply or_9_intro_6; tauto.
  intros. apply or_9_intro_7; tauto.
  intros. apply or_9_intro_8; tauto.
  intros. apply or_9_intro_9; tauto.
Qed.

Remark rem_411 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 (f1 X1 X2 X3) -> auto_knows_current (f1 X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intro H. intros.
  elim (rem_410 X1 X2 X3 H);  intros.
  apply (rem_377 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_378 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_379 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_384 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_389 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_394 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_399 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_404 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_409 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
Defined.

Remark rem_412 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto_knows_current (f4 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_350 epsilon_m_q1_pknows_current X1 X2 A1 A2). clear  epsilon_m_q1_pknows_current A1 A2. intros. apply trans_knows_current_f4_1;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2. tauto.
Defined.

Remark rem_413 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_knows_current (f4 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_354 epsilon_m_q1_pknows_current X1 X2 A1 A2). clear  epsilon_m_q1_pknows_current A1 A2. intros. apply trans_knows_current_f4_3;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2. tauto.
Defined.

Remark rem_414 : forall X1 X2:term, auto__q1 (f4 X1 X2) -> or_2
    (auto__q2 X1 /\ auto__q1 X2)
    (auto__q3 X1 /\ auto__q1 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_415 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 (f4 X1 X2) -> auto_knows_current (f4 X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_414 X1 X2 H);  intros.
  apply (rem_412 epsilon_m_q1_pknows_current X1 X2);  tauto.
  apply (rem_413 epsilon_m_q1_pknows_current X1 X2);  tauto.
Defined.

Remark rem_416 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_358 epsilon_m_q1_pknows_current X1 X2 A1 A2). clear  epsilon_m_q1_pknows_current A1 A2. intros. apply trans_knows_current_cons_4;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2. tauto.
Defined.

Remark rem_417 : forall X1 X2:term, auto__q1 (cons X1 X2) -> or_1
    (auto__q1 X1 /\ auto__q1 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_418 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_417 X1 X2 H);  intros.
  apply (rem_416 epsilon_m_q1_pknows_current X1 X2);  tauto.
Defined.

Remark rem_419 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_388 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_old_3;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_420 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_393 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_old_7;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_421 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_271 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_422 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_273 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_423 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_292 epsilon_m_q1_pknows_current X3).
Defined.

Remark rem_424 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> (auto__q2 X1 /\ auto__q2 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_421 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_422 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_423 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_425 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_424 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_old_9;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_426 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_271 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_427 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_297 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_428 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q1 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X3 -> auto__q1 X3). tauto. exact (rem_285 epsilon_m_q1_pknows_current X3).
Defined.

Remark rem_429 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> (auto__q2 X1 /\ auto__q1 X2 /\ auto__q1 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_426 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_427 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X3). 2:apply (rem_428 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_430 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_knows_current (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_429 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_session_old_14;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_431 : forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> or_4
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q3 X1 /\ auto__q1 X2 /\ auto__q2 X3)
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q1 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_4_intro_1; tauto.
  intros. apply or_4_intro_2; tauto.
  intros. apply or_4_intro_3; tauto.
  intros. apply or_4_intro_4; tauto.
Qed.

Remark rem_432 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto_knows_current (session_old X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intro H. intros.
  elim (rem_431 X1 X2 X3 H);  intros.
  apply (rem_419 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_420 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_425 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_430 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
Defined.

Remark rem_433 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_271 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_434 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_265 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_435 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> (auto__q2 X1 /\ auto__q3 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto__q2 X1). 2:apply (rem_433 epsilon_m_q1_pknows_current X1 X2);  assumption.
  cut (auto__q3 X2). 2:apply (rem_434 epsilon_m_q1_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_436 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_435 epsilon_m_q1_pknows_current X1 X2 A1 A2). clear  epsilon_m_q1_pknows_current A1 A2. intros. apply trans_knows_current_crypt_1;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2. tauto.
Defined.

Remark rem_437 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_289 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_438 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_265 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_439 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> (auto__q1 X1 /\ auto__q3 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto__q1 X1). 2:apply (rem_437 epsilon_m_q1_pknows_current X1 X2);  assumption.
  cut (auto__q3 X2). 2:apply (rem_438 epsilon_m_q1_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_440 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_439 epsilon_m_q1_pknows_current X1 X2 A1 A2). clear  epsilon_m_q1_pknows_current A1 A2. intros. apply trans_knows_current_crypt_3;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2. tauto.
Defined.

Remark rem_441 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_373 epsilon_m_q1_pknows_current X1 X2 A1 A2). clear  epsilon_m_q1_pknows_current A1 A2. intros. apply trans_knows_current_crypt_6;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2. tauto.
Defined.

Remark rem_442 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_358 epsilon_m_q1_pknows_current X1 X2 A1 A2). clear  epsilon_m_q1_pknows_current A1 A2. intros. apply trans_knows_current_crypt_8;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2. tauto.
Defined.

Remark rem_443 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_289 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_444 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_273 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_445 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> (auto__q1 X1 /\ auto__q2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto__q1 X1). 2:apply (rem_443 epsilon_m_q1_pknows_current X1 X2);  assumption.
  cut (auto__q2 X2). 2:apply (rem_444 epsilon_m_q1_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_446 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_445 epsilon_m_q1_pknows_current X1 X2 A1 A2). clear  epsilon_m_q1_pknows_current A1 A2. intros. apply trans_knows_current_crypt_9;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2. tauto.
Defined.

Inductive or_5(H1 H2 H3 H4 H5:Prop) : Prop :=
    or_5_intro_1 : H1 -> (or_5 H1 H2 H3 H4 H5)
  | or_5_intro_2 : H2 -> (or_5 H1 H2 H3 H4 H5)
  | or_5_intro_3 : H3 -> (or_5 H1 H2 H3 H4 H5)
  | or_5_intro_4 : H4 -> (or_5 H1 H2 H3 H4 H5)
  | or_5_intro_5 : H5 -> (or_5 H1 H2 H3 H4 H5)
.

Remark rem_447 : forall X1 X2:term, auto__q1 (crypt X1 X2) -> or_5
    (auto__q2 X1 /\ auto__q3 X2)
    (auto__q1 X1 /\ auto__q3 X2)
    (auto__q3 X1 /\ auto__q2 X2)
    (auto__q1 X1 /\ auto__q1 X2)
    (auto__q1 X1 /\ auto__q2 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_5_intro_1; tauto.
  intros. apply or_5_intro_2; tauto.
  intros. apply or_5_intro_3; tauto.
  intros. apply or_5_intro_4; tauto.
  intros. apply or_5_intro_5; tauto.
Qed.

Remark rem_448 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2:term, auto__q1 (crypt X1 X2) -> auto_knows_current (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_447 X1 X2 H);  intros.
  apply (rem_436 epsilon_m_q1_pknows_current X1 X2);  tauto.
  apply (rem_440 epsilon_m_q1_pknows_current X1 X2);  tauto.
  apply (rem_441 epsilon_m_q1_pknows_current X1 X2);  tauto.
  apply (rem_442 epsilon_m_q1_pknows_current X1 X2);  tauto.
  apply (rem_446 epsilon_m_q1_pknows_current X1 X2);  tauto.
Defined.

Remark rem_449 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_current (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_276 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_old_1;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_450 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_263 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_451 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_297 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_452 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_267 epsilon_m_q1_pknows_current X3).
Defined.

Remark rem_453 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> (auto__q3 X1 /\ auto__q1 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_450 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_451 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_452 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_454 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_453 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_old_2;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_455 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_263 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_456 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_273 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_457 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_267 epsilon_m_q1_pknows_current X3).
Defined.

Remark rem_458 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> (auto__q3 X1 /\ auto__q2 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_455 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_456 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_457 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_459 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_current (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_458 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_old_9;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_460 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_393 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_old_12;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_461 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_424 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_old_13;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_462 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_current (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_398 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_old_14;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_463 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_263 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_464 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_265 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_465 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_292 epsilon_m_q1_pknows_current X3).
Defined.

Remark rem_466 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> (auto__q3 X1 /\ auto__q3 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_463 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_464 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_465 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_467 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_knows_current (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_466 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_old_15;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_468 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_263 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_469 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_265 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_470 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q1 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X3 -> auto__q1 X3). tauto. exact (rem_285 epsilon_m_q1_pknows_current X3).
Defined.

Remark rem_471 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q1 X3 -> (auto__q3 X1 /\ auto__q3 X2 /\ auto__q1 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_468 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_469 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q1 X3). 2:apply (rem_470 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_472 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_knows_current (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_471 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_old_16;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_473 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_403 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_old_17;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_474 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_305 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_old_19;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_475 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_289 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_476 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_265 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_477 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_292 epsilon_m_q1_pknows_current X3).
Defined.

Remark rem_478 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> (auto__q1 X1 /\ auto__q3 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_475 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_476 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_477 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_479 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_knows_current (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_478 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_old_20;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_480 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_310 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_old_21;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_481 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_289 epsilon_m_q1_pknows_current X1).
Defined.

Remark rem_482 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_273 epsilon_m_q1_pknows_current X2).
Defined.

Remark rem_483 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_267 epsilon_m_q1_pknows_current X3).
Defined.

Remark rem_484 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> (auto__q1 X1 /\ auto__q2 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_481 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_482 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_483 epsilon_m_q1_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_485 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_current (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_484 epsilon_m_q1_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m_q1_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonces_old_22;  tauto.
 clear  epsilon_m_q1_pknows_current A1 A2 A3. tauto.
Defined.

Inductive or_13(H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13:Prop) : Prop :=
    or_13_intro_1 : H1 -> (or_13 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13)
  | or_13_intro_2 : H2 -> (or_13 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13)
  | or_13_intro_3 : H3 -> (or_13 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13)
  | or_13_intro_4 : H4 -> (or_13 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13)
  | or_13_intro_5 : H5 -> (or_13 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13)
  | or_13_intro_6 : H6 -> (or_13 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13)
  | or_13_intro_7 : H7 -> (or_13 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13)
  | or_13_intro_8 : H8 -> (or_13 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13)
  | or_13_intro_9 : H9 -> (or_13 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13)
  | or_13_intro_10 : H10 -> (or_13 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13)
  | or_13_intro_11 : H11 -> (or_13 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13)
  | or_13_intro_12 : H12 -> (or_13 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13)
  | or_13_intro_13 : H13 -> (or_13 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13)
.

Remark rem_486 : forall X1 X2 X3:term, auto__q1 (nonces_old X1 X2 X3) -> or_13
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q3 X3)
    (auto__q3 X1 /\ auto__q1 X2 /\ auto__q3 X3)
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q3 X3)
    (auto__q3 X1 /\ auto__q1 X2 /\ auto__q2 X3)
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q3 X1 /\ auto__q3 X2 /\ auto__q2 X3)
    (auto__q3 X1 /\ auto__q3 X2 /\ auto__q1 X3)
    (auto__q1 X1 /\ auto__q1 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q1 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q3 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_13_intro_1; tauto.
  intros. apply or_13_intro_2; tauto.
  intros. apply or_13_intro_3; tauto.
  intros. apply or_13_intro_4; tauto.
  intros. apply or_13_intro_5; tauto.
  intros. apply or_13_intro_6; tauto.
  intros. apply or_13_intro_7; tauto.
  intros. apply or_13_intro_8; tauto.
  intros. apply or_13_intro_9; tauto.
  intros. apply or_13_intro_10; tauto.
  intros. apply or_13_intro_11; tauto.
  intros. apply or_13_intro_12; tauto.
  intros. apply or_13_intro_13; tauto.
Qed.

Remark rem_487 : (forall X:term, auto__q1 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto__q1 (nonces_old X1 X2 X3) -> auto_knows_current (nonces_old X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q1_pknows_current. intros X1 X2 X3. intro H. intros.
  elim (rem_486 X1 X2 X3 H);  intros.
  apply (rem_449 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_454 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_459 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_460 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_461 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_462 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_467 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_472 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_473 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_474 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_479 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_480 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
  apply (rem_485 epsilon_m_q1_pknows_current X1 X2 X3);  tauto.
Defined.

Remark rem_488 : auto__q1 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_489 : forall X1 X2:term, auto__q1 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_490 : auto__q1 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_491 : auto__q1 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_492 : auto__q1 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_493 : forall X1 X2:term, auto__q1 (f5 X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_494 : auto__q1 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_495 : forall X1:term, auto__q1 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_m_q1_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_492  H).
   intro H. elim (rem_491  H).
  intros X1 X2;  exact (rem_418 epsilon_m_q1_pknows_current X1 X2).
  intros X1 X2;  exact (rem_448 epsilon_m_q1_pknows_current X1 X2).
  intros X1 X2 X3;  exact (rem_411 epsilon_m_q1_pknows_current X1 X2 X3).
  intros X1 X2;  exact (rem_361 epsilon_m_q1_pknows_current X1 X2).
  intros X1 X2;  exact (rem_376 epsilon_m_q1_pknows_current X1 X2).
  intros X1 X2;  exact (rem_415 epsilon_m_q1_pknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_493 X1 X2 H).
  intros X1;  exact (rem_330 epsilon_m_q1_pknows_current X1).
   intro H. elim (rem_488  H).
  intros X1 X2. intro H. elim (rem_489 X1 X2 H).
  intros X1;  exact (rem_335 epsilon_m_q1_pknows_current X1).
  exact (rem_324 epsilon_m_q1_pknows_current ).
  intros X1 X2 X3;  exact (rem_344 epsilon_m_q1_pknows_current X1 X2 X3).
  intros X1 X2 X3;  exact (rem_487 epsilon_m_q1_pknows_current X1 X2 X3).
   intro H. elim (rem_494  H).
  exact (rem_364 epsilon_m_q1_pknows_current ).
  exact (rem_327 epsilon_m_q1_pknows_current ).
  exact (rem_347 epsilon_m_q1_pknows_current ).
  intros X1;  exact (rem_321 epsilon_m_q1_pknows_current X1).
   intro H. elim (rem_490  H).
  intros X1 X2 X3;  exact (rem_313 epsilon_m_q1_pknows_current X1 X2 X3).
  intros X1 X2 X3;  exact (rem_432 epsilon_m_q1_pknows_current X1 X2 X3).
  exact (rem_338 epsilon_m_q1_pknows_current ).
  exact (rem_317 epsilon_m_q1_pknows_current ).
Qed.

Remark rem_496 : forall X1:term, auto_knows_current (s X1) -> or_2
    (auto__q3 X1)    (auto__q1 X1).
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_497 : forall X1:term, auto_knows_current (s X1) -> auto_knows_current X1. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_496 X1 H);  intros.
  apply (rem_262 X1);  tauto.
  apply (rem_495 X1);  tauto.
Qed.

Remark rem_498 : forall _big_m:term, auto_knows_current (s _big_m) -> auto_knows_current _big_m. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1.
  cut (auto_knows_current (s X1) -> auto_knows_current X1). tauto. exact (rem_497 X1).
Qed.

Remark rem_499 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1:term, auto__q3 X1 -> auto__q3 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_500 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_499 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_501 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X2:term, auto__q3 X2 -> auto__q3 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_502 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_501 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_503 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X3:term, auto__q3 X3 -> auto__q3 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_504 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_503 epsilon_mknows_old_p_q1 X3).
Defined.

Remark rem_505 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> (auto__q3 X1 /\ auto__q3 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_500 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_502 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_504 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_506 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q1 (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_505 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_session_current_1;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_507 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1:term, auto__q2 X1 -> auto__q2 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_508 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_507 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_509 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X2:term, auto__q2 X2 -> auto__q2 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_510 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_509 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_511 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_503 epsilon_mknows_old_p_q1 X3).
Defined.

Remark rem_512 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> (auto__q2 X1 /\ auto__q2 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_508 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_510 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_511 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_513 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q1 (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_512 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_session_current_2;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_514 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_507 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_515 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_501 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_516 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_503 epsilon_mknows_old_p_q1 X3).
Defined.

Remark rem_517 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> (auto__q2 X1 /\ auto__q3 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_514 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_515 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_516 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_518 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q1 (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_517 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_session_current_3;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_519 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_507 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_520 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_509 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_521 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X3:term, auto__q1 X3 -> auto__q1 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_522 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q1 X3 -> auto__q1 X3). tauto. exact (rem_521 epsilon_mknows_old_p_q1 X3).
Defined.

Remark rem_523 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> (auto__q2 X1 /\ auto__q2 X2 /\ auto__q1 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_519 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_520 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q1 X3). 2:apply (rem_522 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_524 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_523 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_session_current_4;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_525 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1:term, auto__q1 X1 -> auto__q1 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_526 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_525 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_527 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_509 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_528 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X3:term, auto__q2 X3 -> auto__q2 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_529 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_528 epsilon_mknows_old_p_q1 X3).
Defined.

Remark rem_530 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> (auto__q1 X1 /\ auto__q2 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_526 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_527 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_529 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_531 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q1 (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_530 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_session_current_5;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_532 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_507 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_533 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X2:term, auto__q1 X2 -> auto__q1 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_534 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_533 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_535 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_503 epsilon_mknows_old_p_q1 X3).
Defined.

Remark rem_536 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> (auto__q2 X1 /\ auto__q1 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_532 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_534 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_535 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_537 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_536 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_session_current_6;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_538 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_525 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_539 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_501 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_540 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_503 epsilon_mknows_old_p_q1 X3).
Defined.

Remark rem_541 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> (auto__q1 X1 /\ auto__q3 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_538 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_539 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_540 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_542 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q1 (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_541 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_session_current_7;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_543 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_525 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_544 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_533 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_545 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_503 epsilon_mknows_old_p_q1 X3).
Defined.

Remark rem_546 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> (auto__q1 X1 /\ auto__q1 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_543 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_544 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_545 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_547 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_546 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_session_current_8;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_548 : forall X1 X2 X3:term, auto_knows_old (session_current X1 X2 X3) -> or_8
    (auto__q3 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q1 X2 /\ auto__q3 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_8_intro_1; tauto.
  intros. apply or_8_intro_2; tauto.
  intros. apply or_8_intro_3; tauto.
  intros. apply or_8_intro_4; tauto.
  intros. apply or_8_intro_5; tauto.
  intros. apply or_8_intro_6; tauto.
  intros. apply or_8_intro_7; tauto.
  intros. apply or_8_intro_8; tauto.
Qed.

Remark rem_549 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto_knows_old (session_current X1 X2 X3) -> auto__q1 (session_current X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intro H. intros.
  elim (rem_548 X1 X2 X3 H);  intros.
  apply (rem_506 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_513 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_518 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_524 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_531 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_537 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_542 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_547 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
Defined.

Remark rem_550 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1.  tauto.
Defined.

Remark rem_551 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> auto__q1 sym. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1.  case (rem_550 epsilon_mknows_old_p_q1). clear  epsilon_mknows_old_p_q1. intros. apply trans__q1_sym_1;  tauto.
 clear  epsilon_mknows_old_p_q1. tauto.
Defined.

Remark rem_552 : auto_knows_old sym -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_553 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> auto_knows_old sym -> auto__q1 sym. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intro H. intros.
  elim (rem_552 H);  intros.
  apply (rem_551 epsilon_mknows_old_p_q1);  tauto.
Defined.

Remark rem_554 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1:term, auto__q1 X1 -> auto__q1 X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1. intros A1.
  cut (auto__q1 X1). 2:apply (rem_525 epsilon_mknows_old_p_q1 X1);  assumption.
  tauto.
Defined.

Remark rem_555 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1:term, auto__q1 X1 -> auto__q1 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1. intros A1.
  case (rem_554 epsilon_mknows_old_p_q1 X1 A1). clear  epsilon_mknows_old_p_q1 A1. intros. apply trans__q1_s_1;  tauto.
 clear  epsilon_mknows_old_p_q1 A1. tauto.
Defined.

Remark rem_556 : forall X1:term, auto_knows_old (s X1) -> or_1
    (auto__q1 X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_557 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1:term, auto_knows_old (s X1) -> auto__q1 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1. intro H. intros.
  elim (rem_556 X1 H);  intros.
  apply (rem_555 epsilon_mknows_old_p_q1 X1);  tauto.
Defined.

Remark rem_558 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> auto__q1 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1.  case (rem_550 epsilon_mknows_old_p_q1). clear  epsilon_mknows_old_p_q1. intros. apply trans__q1_nil_1;  tauto.
 clear  epsilon_mknows_old_p_q1. tauto.
Defined.

Remark rem_559 : auto_knows_old nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_560 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> auto_knows_old nil -> auto__q1 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intro H. intros.
  elim (rem_559 H);  intros.
  apply (rem_558 epsilon_mknows_old_p_q1);  tauto.
Defined.

Remark rem_561 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> auto__q1 request_id. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1.  case (rem_550 epsilon_mknows_old_p_q1). clear  epsilon_mknows_old_p_q1. intros. apply trans__q1_request_id_1;  tauto.
 clear  epsilon_mknows_old_p_q1. tauto.
Defined.

Remark rem_562 : auto_knows_old request_id -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_563 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> auto_knows_old request_id -> auto__q1 request_id. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intro H. intros.
  elim (rem_562 H);  intros.
  apply (rem_561 epsilon_mknows_old_p_q1);  tauto.
Defined.

Remark rem_564 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1:term, auto__q1 X1 -> auto__q1 (h X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1. intros A1.
  case (rem_554 epsilon_mknows_old_p_q1 X1 A1). clear  epsilon_mknows_old_p_q1 A1. intros. apply trans__q1_h_1;  tauto.
 clear  epsilon_mknows_old_p_q1 A1. tauto.
Defined.

Remark rem_565 : forall X1:term, auto_knows_old (h X1) -> or_1
    (auto__q1 X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_566 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1:term, auto_knows_old (h X1) -> auto__q1 (h X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1. intro H. intros.
  elim (rem_565 X1 H);  intros.
  apply (rem_564 epsilon_mknows_old_p_q1 X1);  tauto.
Defined.

Remark rem_567 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1:term, auto__q3 X1 -> auto__q3 X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1. intros A1.
  cut (auto__q3 X1). 2:apply (rem_499 epsilon_mknows_old_p_q1 X1);  assumption.
  tauto.
Defined.

Remark rem_568 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1:term, auto__q3 X1 -> auto__q1 (nai X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1. intros A1.
  case (rem_567 epsilon_mknows_old_p_q1 X1 A1). clear  epsilon_mknows_old_p_q1 A1. intros. apply trans__q1_nai_1;  tauto.
 clear  epsilon_mknows_old_p_q1 A1. tauto.
Defined.

Remark rem_569 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1:term, auto__q1 X1 -> auto__q1 (nai X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1. intros A1.
  case (rem_554 epsilon_mknows_old_p_q1 X1 A1). clear  epsilon_mknows_old_p_q1 A1. intros. apply trans__q1_nai_2;  tauto.
 clear  epsilon_mknows_old_p_q1 A1. tauto.
Defined.

Remark rem_570 : forall X1:term, auto_knows_old (nai X1) -> or_2
    (auto__q3 X1)    (auto__q1 X1).
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_571 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1:term, auto_knows_old (nai X1) -> auto__q1 (nai X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1. intro H. intros.
  elim (rem_570 X1 H);  intros.
  apply (rem_568 epsilon_mknows_old_p_q1 X1);  tauto.
  apply (rem_569 epsilon_mknows_old_p_q1 X1);  tauto.
Defined.

Remark rem_572 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> auto__q1 success. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1.  case (rem_550 epsilon_mknows_old_p_q1). clear  epsilon_mknows_old_p_q1. intros. apply trans__q1_success_1;  tauto.
 clear  epsilon_mknows_old_p_q1. tauto.
Defined.

Remark rem_573 : auto_knows_old success -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_574 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> auto_knows_old success -> auto__q1 success. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intro H. intros.
  elim (rem_573 H);  intros.
  apply (rem_572 epsilon_mknows_old_p_q1);  tauto.
Defined.

Remark rem_575 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q1 (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_512 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_nonces_current_1;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_576 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q1 (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_517 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_nonces_current_2;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_577 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_523 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_nonces_current_3;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_578 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_536 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_nonces_current_4;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_579 : forall X1 X2 X3:term, auto_knows_old (nonces_current X1 X2 X3) -> or_4
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q3 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_4_intro_1; tauto.
  intros. apply or_4_intro_2; tauto.
  intros. apply or_4_intro_3; tauto.
  intros. apply or_4_intro_4; tauto.
Qed.

Remark rem_580 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto_knows_old (nonces_current X1 X2 X3) -> auto__q1 (nonces_current X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intro H. intros.
  elim (rem_579 X1 X2 X3 H);  intros.
  apply (rem_575 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_576 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_577 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_578 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
Defined.

Remark rem_581 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> auto__q1 respond_id. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1.  case (rem_550 epsilon_mknows_old_p_q1). clear  epsilon_mknows_old_p_q1. intros. apply trans__q1_respond_id_1;  tauto.
 clear  epsilon_mknows_old_p_q1. tauto.
Defined.

Remark rem_582 : auto_knows_old respond_id -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_583 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> auto_knows_old respond_id -> auto__q1 respond_id. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intro H. intros.
  elim (rem_582 H);  intros.
  apply (rem_581 epsilon_mknows_old_p_q1);  tauto.
Defined.

Remark rem_584 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_507 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_585 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_533 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_586 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> (auto__q2 X1 /\ auto__q1 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intros A1 A2.
  cut (auto__q2 X1). 2:apply (rem_584 epsilon_mknows_old_p_q1 X1 X2);  assumption.
  cut (auto__q1 X2). 2:apply (rem_585 epsilon_mknows_old_p_q1 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_587 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 (f2 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intros A1 A2.
  case (rem_586 epsilon_mknows_old_p_q1 X1 X2 A1 A2). clear  epsilon_mknows_old_p_q1 A1 A2. intros. apply trans__q1_f2_1;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2. tauto.
Defined.

Remark rem_588 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_499 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_589 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_533 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_590 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> (auto__q3 X1 /\ auto__q1 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intros A1 A2.
  cut (auto__q3 X1). 2:apply (rem_588 epsilon_mknows_old_p_q1 X1 X2);  assumption.
  cut (auto__q1 X2). 2:apply (rem_589 epsilon_mknows_old_p_q1 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_591 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 (f2 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intros A1 A2.
  case (rem_590 epsilon_mknows_old_p_q1 X1 X2 A1 A2). clear  epsilon_mknows_old_p_q1 A1 A2. intros. apply trans__q1_f2_2;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2. tauto.
Defined.

Remark rem_592 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_525 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_593 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_533 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_594 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> (auto__q1 X1 /\ auto__q1 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intros A1 A2.
  cut (auto__q1 X1). 2:apply (rem_592 epsilon_mknows_old_p_q1 X1 X2);  assumption.
  cut (auto__q1 X2). 2:apply (rem_593 epsilon_mknows_old_p_q1 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_595 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 (f2 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intros A1 A2.
  case (rem_594 epsilon_mknows_old_p_q1 X1 X2 A1 A2). clear  epsilon_mknows_old_p_q1 A1 A2. intros. apply trans__q1_f2_3;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2. tauto.
Defined.

Remark rem_596 : forall X1 X2:term, auto_knows_old (f2 X1 X2) -> or_3
    (auto__q2 X1 /\ auto__q1 X2)
    (auto__q3 X1 /\ auto__q1 X2)
    (auto__q1 X1 /\ auto__q1 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_597 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto_knows_old (f2 X1 X2) -> auto__q1 (f2 X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intro H. intros.
  elim (rem_596 X1 X2 H);  intros.
  apply (rem_587 epsilon_mknows_old_p_q1 X1 X2);  tauto.
  apply (rem_591 epsilon_mknows_old_p_q1 X1 X2);  tauto.
  apply (rem_595 epsilon_mknows_old_p_q1 X1 X2);  tauto.
Defined.

Remark rem_598 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> auto__q1 pub. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1.  case (rem_550 epsilon_mknows_old_p_q1). clear  epsilon_mknows_old_p_q1. intros. apply trans__q1_pub_1;  tauto.
 clear  epsilon_mknows_old_p_q1. tauto.
Defined.

Remark rem_599 : auto_knows_old pub -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_600 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> auto_knows_old pub -> auto__q1 pub. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intro H. intros.
  elim (rem_599 H);  intros.
  apply (rem_598 epsilon_mknows_old_p_q1);  tauto.
Defined.

Remark rem_601 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 (f3 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intros A1 A2.
  case (rem_586 epsilon_mknows_old_p_q1 X1 X2 A1 A2). clear  epsilon_mknows_old_p_q1 A1 A2. intros. apply trans__q1_f3_1;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2. tauto.
Defined.

Remark rem_602 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 (f3 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intros A1 A2.
  case (rem_590 epsilon_mknows_old_p_q1 X1 X2 A1 A2). clear  epsilon_mknows_old_p_q1 A1 A2. intros. apply trans__q1_f3_2;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2. tauto.
Defined.

Remark rem_603 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_507 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_604 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_509 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_605 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> (auto__q2 X1 /\ auto__q2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intros A1 A2.
  cut (auto__q2 X1). 2:apply (rem_603 epsilon_mknows_old_p_q1 X1 X2);  assumption.
  cut (auto__q2 X2). 2:apply (rem_604 epsilon_mknows_old_p_q1 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_606 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 (f3 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intros A1 A2.
  case (rem_605 epsilon_mknows_old_p_q1 X1 X2 A1 A2). clear  epsilon_mknows_old_p_q1 A1 A2. intros. apply trans__q1_f3_3;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2. tauto.
Defined.

Remark rem_607 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_499 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_608 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_509 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_609 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> (auto__q3 X1 /\ auto__q2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intros A1 A2.
  cut (auto__q3 X1). 2:apply (rem_607 epsilon_mknows_old_p_q1 X1 X2);  assumption.
  cut (auto__q2 X2). 2:apply (rem_608 epsilon_mknows_old_p_q1 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_610 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 (f3 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intros A1 A2.
  case (rem_609 epsilon_mknows_old_p_q1 X1 X2 A1 A2). clear  epsilon_mknows_old_p_q1 A1 A2. intros. apply trans__q1_f3_4;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2. tauto.
Defined.

Remark rem_611 : forall X1 X2:term, auto_knows_old (f3 X1 X2) -> or_4
    (auto__q2 X1 /\ auto__q1 X2)
    (auto__q3 X1 /\ auto__q1 X2)
    (auto__q2 X1 /\ auto__q2 X2)
    (auto__q3 X1 /\ auto__q2 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_4_intro_1; tauto.
  intros. apply or_4_intro_2; tauto.
  intros. apply or_4_intro_3; tauto.
  intros. apply or_4_intro_4; tauto.
Qed.

Remark rem_612 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto_knows_old (f3 X1 X2) -> auto__q1 (f3 X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intro H. intros.
  elim (rem_611 X1 X2 H);  intros.
  apply (rem_601 epsilon_mknows_old_p_q1 X1 X2);  tauto.
  apply (rem_602 epsilon_mknows_old_p_q1 X1 X2);  tauto.
  apply (rem_606 epsilon_mknows_old_p_q1 X1 X2);  tauto.
  apply (rem_610 epsilon_mknows_old_p_q1 X1 X2);  tauto.
Defined.

Remark rem_613 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q1 (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_505 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_f1_1;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_614 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q1 (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_517 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_f1_2;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_615 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_523 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_f1_3;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_616 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_499 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_617 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_533 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_618 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q1 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q1 X3 -> auto__q1 X3). tauto. exact (rem_521 epsilon_mknows_old_p_q1 X3).
Defined.

Remark rem_619 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> (auto__q3 X1 /\ auto__q1 X2 /\ auto__q1 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_616 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_617 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q1 X3). 2:apply (rem_618 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_620 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q1 (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_619 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_f1_4;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_621 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_499 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_622 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_509 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_623 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_528 epsilon_mknows_old_p_q1 X3).
Defined.

Remark rem_624 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> (auto__q3 X1 /\ auto__q2 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_621 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_622 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_623 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_625 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q1 (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_624 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_f1_5;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_626 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_499 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_627 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_533 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_628 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_528 epsilon_mknows_old_p_q1 X3).
Defined.

Remark rem_629 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> (auto__q3 X1 /\ auto__q1 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_626 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_627 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_628 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_630 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_629 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_f1_6;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_631 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_525 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_632 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_509 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_633 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q1 X3 -> auto__q1 X3). tauto. exact (rem_521 epsilon_mknows_old_p_q1 X3).
Defined.

Remark rem_634 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> (auto__q1 X1 /\ auto__q2 X2 /\ auto__q1 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_631 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_632 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q1 X3). 2:apply (rem_633 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_635 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_634 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_f1_7;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_636 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_525 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_637 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_533 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_638 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_528 epsilon_mknows_old_p_q1 X3).
Defined.

Remark rem_639 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> (auto__q1 X1 /\ auto__q1 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_636 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_637 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_638 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_640 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_639 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_f1_8;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_641 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_507 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_642 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_533 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_643 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_528 epsilon_mknows_old_p_q1 X3).
Defined.

Remark rem_644 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> (auto__q2 X1 /\ auto__q1 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_641 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_642 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_643 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_645 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_644 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_f1_9;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_646 : forall X1 X2 X3:term, auto_knows_old (f1 X1 X2 X3) -> or_9
    (auto__q3 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q3 X1 /\ auto__q1 X2 /\ auto__q1 X3)
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q3 X1 /\ auto__q1 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q1 X1 /\ auto__q1 X2 /\ auto__q2 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q2 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_9_intro_1; tauto.
  intros. apply or_9_intro_2; tauto.
  intros. apply or_9_intro_3; tauto.
  intros. apply or_9_intro_4; tauto.
  intros. apply or_9_intro_5; tauto.
  intros. apply or_9_intro_6; tauto.
  intros. apply or_9_intro_7; tauto.
  intros. apply or_9_intro_8; tauto.
  intros. apply or_9_intro_9; tauto.
Qed.

Remark rem_647 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto_knows_old (f1 X1 X2 X3) -> auto__q1 (f1 X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intro H. intros.
  elim (rem_646 X1 X2 X3 H);  intros.
  apply (rem_613 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_614 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_615 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_620 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_625 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_630 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_635 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_640 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_645 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
Defined.

Remark rem_648 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 (f4 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intros A1 A2.
  case (rem_586 epsilon_mknows_old_p_q1 X1 X2 A1 A2). clear  epsilon_mknows_old_p_q1 A1 A2. intros. apply trans__q1_f4_1;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2. tauto.
Defined.

Remark rem_649 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 (f4 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intros A1 A2.
  case (rem_590 epsilon_mknows_old_p_q1 X1 X2 A1 A2). clear  epsilon_mknows_old_p_q1 A1 A2. intros. apply trans__q1_f4_2;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2. tauto.
Defined.

Remark rem_650 : forall X1 X2:term, auto_knows_old (f4 X1 X2) -> or_2
    (auto__q2 X1 /\ auto__q1 X2)
    (auto__q3 X1 /\ auto__q1 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_651 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto_knows_old (f4 X1 X2) -> auto__q1 (f4 X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intro H. intros.
  elim (rem_650 X1 X2 H);  intros.
  apply (rem_648 epsilon_mknows_old_p_q1 X1 X2);  tauto.
  apply (rem_649 epsilon_mknows_old_p_q1 X1 X2);  tauto.
Defined.

Remark rem_652 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intros A1 A2.
  case (rem_594 epsilon_mknows_old_p_q1 X1 X2 A1 A2). clear  epsilon_mknows_old_p_q1 A1 A2. intros. apply trans__q1_cons_1;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2. tauto.
Defined.

Remark rem_653 : forall X1 X2:term, auto_knows_old (cons X1 X2) -> or_1
    (auto__q1 X1 /\ auto__q1 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_654 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto_knows_old (cons X1 X2) -> auto__q1 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intro H. intros.
  elim (rem_653 X1 X2 H);  intros.
  apply (rem_652 epsilon_mknows_old_p_q1 X1 X2);  tauto.
Defined.

Remark rem_655 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q1 (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_624 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_session_old_1;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_656 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_629 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_session_old_2;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_657 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_507 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_658 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_509 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_659 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_528 epsilon_mknows_old_p_q1 X3).
Defined.

Remark rem_660 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> (auto__q2 X1 /\ auto__q2 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_657 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_658 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_659 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_661 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q1 (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_660 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_session_old_3;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_662 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_507 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_663 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_533 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_664 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q1 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q1 X3 -> auto__q1 X3). tauto. exact (rem_521 epsilon_mknows_old_p_q1 X3).
Defined.

Remark rem_665 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> (auto__q2 X1 /\ auto__q1 X2 /\ auto__q1 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_662 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_663 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q1 X3). 2:apply (rem_664 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_666 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q1 (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_665 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_session_old_4;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_667 : forall X1 X2 X3:term, auto_knows_old (session_old X1 X2 X3) -> or_4
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q3 X1 /\ auto__q1 X2 /\ auto__q2 X3)
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q1 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_4_intro_1; tauto.
  intros. apply or_4_intro_2; tauto.
  intros. apply or_4_intro_3; tauto.
  intros. apply or_4_intro_4; tauto.
Qed.

Remark rem_668 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto_knows_old (session_old X1 X2 X3) -> auto__q1 (session_old X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intro H. intros.
  elim (rem_667 X1 X2 X3 H);  intros.
  apply (rem_655 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_656 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_661 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_666 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
Defined.

Remark rem_669 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_507 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_670 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_501 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_671 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> (auto__q2 X1 /\ auto__q3 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intros A1 A2.
  cut (auto__q2 X1). 2:apply (rem_669 epsilon_mknows_old_p_q1 X1 X2);  assumption.
  cut (auto__q3 X2). 2:apply (rem_670 epsilon_mknows_old_p_q1 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_672 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intros A1 A2.
  case (rem_671 epsilon_mknows_old_p_q1 X1 X2 A1 A2). clear  epsilon_mknows_old_p_q1 A1 A2. intros. apply trans__q1_crypt_1;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2. tauto.
Defined.

Remark rem_673 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_525 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_674 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_501 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_675 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> (auto__q1 X1 /\ auto__q3 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intros A1 A2.
  cut (auto__q1 X1). 2:apply (rem_673 epsilon_mknows_old_p_q1 X1 X2);  assumption.
  cut (auto__q3 X2). 2:apply (rem_674 epsilon_mknows_old_p_q1 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_676 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intros A1 A2.
  case (rem_675 epsilon_mknows_old_p_q1 X1 X2 A1 A2). clear  epsilon_mknows_old_p_q1 A1 A2. intros. apply trans__q1_crypt_2;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2. tauto.
Defined.

Remark rem_677 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intros A1 A2.
  case (rem_609 epsilon_mknows_old_p_q1 X1 X2 A1 A2). clear  epsilon_mknows_old_p_q1 A1 A2. intros. apply trans__q1_crypt_3;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2. tauto.
Defined.

Remark rem_678 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intros A1 A2.
  case (rem_594 epsilon_mknows_old_p_q1 X1 X2 A1 A2). clear  epsilon_mknows_old_p_q1 A1 A2. intros. apply trans__q1_crypt_4;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2. tauto.
Defined.

Remark rem_679 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_525 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_680 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_509 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_681 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> (auto__q1 X1 /\ auto__q2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intros A1 A2.
  cut (auto__q1 X1). 2:apply (rem_679 epsilon_mknows_old_p_q1 X1 X2);  assumption.
  cut (auto__q2 X2). 2:apply (rem_680 epsilon_mknows_old_p_q1 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_682 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intros A1 A2.
  case (rem_681 epsilon_mknows_old_p_q1 X1 X2 A1 A2). clear  epsilon_mknows_old_p_q1 A1 A2. intros. apply trans__q1_crypt_5;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2. tauto.
Defined.

Remark rem_683 : forall X1 X2:term, auto_knows_old (crypt X1 X2) -> or_5
    (auto__q2 X1 /\ auto__q3 X2)
    (auto__q1 X1 /\ auto__q3 X2)
    (auto__q3 X1 /\ auto__q2 X2)
    (auto__q1 X1 /\ auto__q1 X2)
    (auto__q1 X1 /\ auto__q2 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_5_intro_1; tauto.
  intros. apply or_5_intro_2; tauto.
  intros. apply or_5_intro_3; tauto.
  intros. apply or_5_intro_4; tauto.
  intros. apply or_5_intro_5; tauto.
Qed.

Remark rem_684 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2:term, auto_knows_old (crypt X1 X2) -> auto__q1 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2. intro H. intros.
  elim (rem_683 X1 X2 H);  intros.
  apply (rem_672 epsilon_mknows_old_p_q1 X1 X2);  tauto.
  apply (rem_676 epsilon_mknows_old_p_q1 X1 X2);  tauto.
  apply (rem_677 epsilon_mknows_old_p_q1 X1 X2);  tauto.
  apply (rem_678 epsilon_mknows_old_p_q1 X1 X2);  tauto.
  apply (rem_682 epsilon_mknows_old_p_q1 X1 X2);  tauto.
Defined.

Remark rem_685 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q1 (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_512 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_nonces_old_1;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_686 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_499 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_687 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_533 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_688 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_503 epsilon_mknows_old_p_q1 X3).
Defined.

Remark rem_689 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> (auto__q3 X1 /\ auto__q1 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_686 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_687 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_688 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_690 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_689 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_nonces_old_2;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_691 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_499 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_692 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_509 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_693 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_503 epsilon_mknows_old_p_q1 X3).
Defined.

Remark rem_694 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> (auto__q3 X1 /\ auto__q2 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_691 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_692 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_693 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_695 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q1 (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_694 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_nonces_old_3;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_696 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_629 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_nonces_old_4;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_697 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q1 (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_660 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_nonces_old_5;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_698 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_634 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_nonces_old_6;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_699 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_499 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_700 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_501 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_701 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_528 epsilon_mknows_old_p_q1 X3).
Defined.

Remark rem_702 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> (auto__q3 X1 /\ auto__q3 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_699 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_700 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_701 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_703 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_702 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_nonces_old_7;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_704 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_499 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_705 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_501 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_706 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q1 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q1 X3 -> auto__q1 X3). tauto. exact (rem_521 epsilon_mknows_old_p_q1 X3).
Defined.

Remark rem_707 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q1 X3 -> (auto__q3 X1 /\ auto__q3 X2 /\ auto__q1 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_704 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_705 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q1 X3). 2:apply (rem_706 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_708 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q1 (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_707 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_nonces_old_8;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_709 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_639 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_nonces_old_9;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_710 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q1 (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_541 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_nonces_old_10;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_711 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_525 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_712 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_501 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_713 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_528 epsilon_mknows_old_p_q1 X3).
Defined.

Remark rem_714 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> (auto__q1 X1 /\ auto__q3 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_711 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_712 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_713 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_715 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_714 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_nonces_old_11;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_716 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_546 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_nonces_old_12;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_717 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_525 epsilon_mknows_old_p_q1 X1).
Defined.

Remark rem_718 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_509 epsilon_mknows_old_p_q1 X2).
Defined.

Remark rem_719 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_503 epsilon_mknows_old_p_q1 X3).
Defined.

Remark rem_720 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> (auto__q1 X1 /\ auto__q2 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_717 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_718 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_719 epsilon_mknows_old_p_q1 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_721 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q1 (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_720 epsilon_mknows_old_p_q1 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_p_q1 A1 A2 A3. intros. apply trans__q1_nonces_old_13;  tauto.
 clear  epsilon_mknows_old_p_q1 A1 A2 A3. tauto.
Defined.

Remark rem_722 : forall X1 X2 X3:term, auto_knows_old (nonces_old X1 X2 X3) -> or_13
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q3 X3)
    (auto__q3 X1 /\ auto__q1 X2 /\ auto__q3 X3)
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q3 X3)
    (auto__q3 X1 /\ auto__q1 X2 /\ auto__q2 X3)
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q3 X1 /\ auto__q3 X2 /\ auto__q2 X3)
    (auto__q3 X1 /\ auto__q3 X2 /\ auto__q1 X3)
    (auto__q1 X1 /\ auto__q1 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q1 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q3 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_13_intro_1; tauto.
  intros. apply or_13_intro_2; tauto.
  intros. apply or_13_intro_3; tauto.
  intros. apply or_13_intro_4; tauto.
  intros. apply or_13_intro_5; tauto.
  intros. apply or_13_intro_6; tauto.
  intros. apply or_13_intro_7; tauto.
  intros. apply or_13_intro_8; tauto.
  intros. apply or_13_intro_9; tauto.
  intros. apply or_13_intro_10; tauto.
  intros. apply or_13_intro_11; tauto.
  intros. apply or_13_intro_12; tauto.
  intros. apply or_13_intro_13; tauto.
Qed.

Remark rem_723 : (forall X:term, auto_knows_old X -> auto__q1 X)
    -> forall X1 X2 X3:term, auto_knows_old (nonces_old X1 X2 X3) -> auto__q1 (nonces_old X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p_q1. intros X1 X2 X3. intro H. intros.
  elim (rem_722 X1 X2 X3 H);  intros.
  apply (rem_685 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_690 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_695 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_696 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_697 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_698 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_703 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_708 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_709 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_710 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_715 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_716 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
  apply (rem_721 epsilon_mknows_old_p_q1 X1 X2 X3);  tauto.
Defined.

Remark rem_724 : auto_knows_old i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_725 : forall X1 X2:term, auto_knows_old (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_726 : auto_knows_old server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_727 : auto_knows_old bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_728 : auto_knows_old alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_729 : forall X1 X2:term, auto_knows_old (f5 X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_730 : auto_knows_old prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_731 : forall X1:term, auto_knows_old X1 -> auto__q1 X1. (* Induct. *)
Proof.
  fix epsilon_mknows_old_p_q1 1.
  intro X. case X.
   intro H. elim (rem_728  H).
   intro H. elim (rem_727  H).
  intros X1 X2;  exact (rem_654 epsilon_mknows_old_p_q1 X1 X2).
  intros X1 X2;  exact (rem_684 epsilon_mknows_old_p_q1 X1 X2).
  intros X1 X2 X3;  exact (rem_647 epsilon_mknows_old_p_q1 X1 X2 X3).
  intros X1 X2;  exact (rem_597 epsilon_mknows_old_p_q1 X1 X2).
  intros X1 X2;  exact (rem_612 epsilon_mknows_old_p_q1 X1 X2).
  intros X1 X2;  exact (rem_651 epsilon_mknows_old_p_q1 X1 X2).
  intros X1 X2. intro H. elim (rem_729 X1 X2 H).
  intros X1;  exact (rem_566 epsilon_mknows_old_p_q1 X1).
   intro H. elim (rem_724  H).
  intros X1 X2. intro H. elim (rem_725 X1 X2 H).
  intros X1;  exact (rem_571 epsilon_mknows_old_p_q1 X1).
  exact (rem_560 epsilon_mknows_old_p_q1 ).
  intros X1 X2 X3;  exact (rem_580 epsilon_mknows_old_p_q1 X1 X2 X3).
  intros X1 X2 X3;  exact (rem_723 epsilon_mknows_old_p_q1 X1 X2 X3).
   intro H. elim (rem_730  H).
  exact (rem_600 epsilon_mknows_old_p_q1 ).
  exact (rem_563 epsilon_mknows_old_p_q1 ).
  exact (rem_583 epsilon_mknows_old_p_q1 ).
  intros X1;  exact (rem_557 epsilon_mknows_old_p_q1 X1).
   intro H. elim (rem_726  H).
  intros X1 X2 X3;  exact (rem_549 epsilon_mknows_old_p_q1 X1 X2 X3).
  intros X1 X2 X3;  exact (rem_668 epsilon_mknows_old_p_q1 X1 X2 X3).
  exact (rem_574 epsilon_mknows_old_p_q1 ).
  exact (rem_553 epsilon_mknows_old_p_q1 ).
Qed.

Remark rem_732 : forall X1:term, auto_knows_old X1 -> auto__q1 X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1. intros A1.
  cut (auto__q1 X1). 2:apply (rem_731 X1);  assumption.
  tauto.
Qed.

Remark rem_733 : forall X1:term, auto_knows_old X1 -> auto_knows_old (h X1). (* Deduce positive atom. *)
Proof.
  intros X1. intros A1.
  case (rem_732 X1 A1). clear  A1. intros. apply trans_knows_old_h_1;  tauto.
 clear  A1. tauto.
Qed.

Remark rem_734 : forall _big_m:term, auto_knows_old _big_m -> auto_knows_old (h _big_m). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1.
  cut (auto_knows_old X1 -> auto_knows_old (h X1)). tauto. exact (rem_733 X1).
Qed.

Remark rem_735 : forall X1:term, auto_agent X1 -> auto_knows_current request_id -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1. intros A1 A2.
  tauto.
Qed.

Remark rem_736 : forall X1:term, auto_agent X1 -> auto_knows_current request_id -> auto__q1 respond_id. (* Deduce positive atom. *)
Proof.
  intros X1. intros A1 A2.
  case (rem_735 X1 A1 A2). clear  A1 A2. intros. apply trans__q1_respond_id_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_737 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1:term, auto__q2 X1 -> auto__q2 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_738 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_737 epsilon_magent_p_q3 X1).
Defined.

Remark rem_739 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X2:term, auto__q3 X2 -> auto__q3 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_740 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_739 epsilon_magent_p_q3 X2).
Defined.

Remark rem_741 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X3:term, auto__q1 X3 -> auto__q1 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_742 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q1 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q1 X3 -> auto__q1 X3). tauto. exact (rem_741 epsilon_magent_p_q3 X3).
Defined.

Remark rem_743 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> (auto__q2 X1 /\ auto__q3 X2 /\ auto__q1 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_738 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_740 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q1 X3). 2:apply (rem_742 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_744 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q3 (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_743 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_session_current_1;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_745 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1:term, auto__q3 X1 -> auto__q3 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_746 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_745 epsilon_magent_p_q3 X1).
Defined.

Remark rem_747 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X2:term, auto__q2 X2 -> auto__q2 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_748 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_747 epsilon_magent_p_q3 X2).
Defined.

Remark rem_749 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q1 X3 -> auto__q1 X3). tauto. exact (rem_741 epsilon_magent_p_q3 X3).
Defined.

Remark rem_750 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> (auto__q3 X1 /\ auto__q2 X2 /\ auto__q1 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_746 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_748 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q1 X3). 2:apply (rem_749 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_751 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q3 (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_750 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_session_current_2;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_752 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_737 epsilon_magent_p_q3 X1).
Defined.

Remark rem_753 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_747 epsilon_magent_p_q3 X2).
Defined.

Remark rem_754 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X3:term, auto__q2 X3 -> auto__q2 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_755 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_754 epsilon_magent_p_q3 X3).
Defined.

Remark rem_756 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> (auto__q2 X1 /\ auto__q2 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_752 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_753 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_755 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_757 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q3 (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_756 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_session_current_3;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_758 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_745 epsilon_magent_p_q3 X1).
Defined.

Remark rem_759 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_739 epsilon_magent_p_q3 X2).
Defined.

Remark rem_760 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_754 epsilon_magent_p_q3 X3).
Defined.

Remark rem_761 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> (auto__q3 X1 /\ auto__q3 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_758 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_759 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_760 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_762 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_761 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_session_current_4;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_763 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1:term, auto__q1 X1 -> auto__q1 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_764 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_763 epsilon_magent_p_q3 X1).
Defined.

Remark rem_765 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_739 epsilon_magent_p_q3 X2).
Defined.

Remark rem_766 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q1 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q1 X3 -> auto__q1 X3). tauto. exact (rem_741 epsilon_magent_p_q3 X3).
Defined.

Remark rem_767 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> (auto__q1 X1 /\ auto__q3 X2 /\ auto__q1 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_764 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_765 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q1 X3). 2:apply (rem_766 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_768 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q3 (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_767 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_session_current_5;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_769 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_763 epsilon_magent_p_q3 X1).
Defined.

Remark rem_770 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_739 epsilon_magent_p_q3 X2).
Defined.

Remark rem_771 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_754 epsilon_magent_p_q3 X3).
Defined.

Remark rem_772 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> (auto__q1 X1 /\ auto__q3 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_769 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_770 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_771 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_773 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_772 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_session_current_6;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_774 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_763 epsilon_magent_p_q3 X1).
Defined.

Remark rem_775 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_747 epsilon_magent_p_q3 X2).
Defined.

Remark rem_776 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X3:term, auto__q3 X3 -> auto__q3 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_777 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_776 epsilon_magent_p_q3 X3).
Defined.

Remark rem_778 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> (auto__q1 X1 /\ auto__q2 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_774 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_775 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_777 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_779 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q3 (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_778 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_session_current_7;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_780 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_737 epsilon_magent_p_q3 X1).
Defined.

Remark rem_781 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X2:term, auto__q1 X2 -> auto__q1 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_782 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_781 epsilon_magent_p_q3 X2).
Defined.

Remark rem_783 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q1 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q1 X3 -> auto__q1 X3). tauto. exact (rem_741 epsilon_magent_p_q3 X3).
Defined.

Remark rem_784 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> (auto__q2 X1 /\ auto__q1 X2 /\ auto__q1 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_780 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_782 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q1 X3). 2:apply (rem_783 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_785 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q3 (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_784 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_session_current_8;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_786 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_737 epsilon_magent_p_q3 X1).
Defined.

Remark rem_787 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_781 epsilon_magent_p_q3 X2).
Defined.

Remark rem_788 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_754 epsilon_magent_p_q3 X3).
Defined.

Remark rem_789 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> (auto__q2 X1 /\ auto__q1 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_786 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_787 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_788 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_790 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q3 (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_789 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_session_current_9;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_791 : forall X1 X2 X3:term, auto_agent (session_current X1 X2 X3) -> or_9
    (auto__q2 X1 /\ auto__q3 X2 /\ auto__q1 X3)
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q3 X1 /\ auto__q3 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q1 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q1 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q2 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_9_intro_1; tauto.
  intros. apply or_9_intro_2; tauto.
  intros. apply or_9_intro_3; tauto.
  intros. apply or_9_intro_4; tauto.
  intros. apply or_9_intro_5; tauto.
  intros. apply or_9_intro_6; tauto.
  intros. apply or_9_intro_7; tauto.
  intros. apply or_9_intro_8; tauto.
  intros. apply or_9_intro_9; tauto.
Qed.

Remark rem_792 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto_agent (session_current X1 X2 X3) -> auto__q3 (session_current X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intro H. intros.
  elim (rem_791 X1 X2 X3 H);  intros.
  apply (rem_744 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_751 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_757 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_762 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_768 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_773 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_779 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_785 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_790 epsilon_magent_p_q3 X1 X2 X3);  tauto.
Defined.

Remark rem_793 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1:term, auto__q3 X1 -> auto__q3 X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1. intros A1.
  cut (auto__q3 X1). 2:apply (rem_745 epsilon_magent_p_q3 X1);  assumption.
  tauto.
Defined.

Remark rem_794 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1:term, auto__q3 X1 -> auto__q3 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1. intros A1.
  case (rem_793 epsilon_magent_p_q3 X1 A1). clear  epsilon_magent_p_q3 A1. intros. apply trans__q3_s_1;  tauto.
 clear  epsilon_magent_p_q3 A1. tauto.
Defined.

Remark rem_795 : forall X1:term, auto_agent (s X1) -> or_1
    (auto__q3 X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_796 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1:term, auto_agent (s X1) -> auto__q3 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1. intro H. intros.
  elim (rem_795 X1 H);  intros.
  apply (rem_794 epsilon_magent_p_q3 X1);  tauto.
Defined.

Remark rem_797 : (forall X:term, auto_agent X -> auto__q3 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3.  tauto.
Defined.

Remark rem_798 : (forall X:term, auto_agent X -> auto__q3 X)
    -> auto__q3 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3.  case (rem_797 epsilon_magent_p_q3). clear  epsilon_magent_p_q3. intros. apply trans__q3_i_1;  tauto.
 clear  epsilon_magent_p_q3. tauto.
Defined.

Remark rem_799 : auto_agent i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_800 : (forall X:term, auto_agent X -> auto__q3 X)
    -> auto_agent i -> auto__q3 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p_q3. intro H. intros.
  elim (rem_799 H);  intros.
  apply (rem_798 epsilon_magent_p_q3);  tauto.
Defined.

Remark rem_801 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1:term, auto__q3 X1 -> auto__q3 (h X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1. intros A1.
  case (rem_793 epsilon_magent_p_q3 X1 A1). clear  epsilon_magent_p_q3 A1. intros. apply trans__q3_h_1;  tauto.
 clear  epsilon_magent_p_q3 A1. tauto.
Defined.

Remark rem_802 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1:term, auto__q2 X1 -> auto__q2 X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1. intros A1.
  cut (auto__q2 X1). 2:apply (rem_737 epsilon_magent_p_q3 X1);  assumption.
  tauto.
Defined.

Remark rem_803 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1:term, auto__q2 X1 -> auto__q3 (h X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1. intros A1.
  case (rem_802 epsilon_magent_p_q3 X1 A1). clear  epsilon_magent_p_q3 A1. intros. apply trans__q3_h_2;  tauto.
 clear  epsilon_magent_p_q3 A1. tauto.
Defined.

Remark rem_804 : forall X1:term, auto_agent (h X1) -> or_2
    (auto__q3 X1)    (auto__q2 X1).
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_805 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1:term, auto_agent (h X1) -> auto__q3 (h X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1. intro H. intros.
  elim (rem_804 X1 H);  intros.
  apply (rem_801 epsilon_magent_p_q3 X1);  tauto.
  apply (rem_803 epsilon_magent_p_q3 X1);  tauto.
Defined.

Remark rem_806 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1:term, auto__q2 X1 -> auto__q3 (nai X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1. intros A1.
  case (rem_802 epsilon_magent_p_q3 X1 A1). clear  epsilon_magent_p_q3 A1. intros. apply trans__q3_nai_1;  tauto.
 clear  epsilon_magent_p_q3 A1. tauto.
Defined.

Remark rem_807 : forall X1:term, auto_agent (nai X1) -> or_1
    (auto__q2 X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_808 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1:term, auto_agent (nai X1) -> auto__q3 (nai X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1. intro H. intros.
  elim (rem_807 X1 H);  intros.
  apply (rem_806 epsilon_magent_p_q3 X1);  tauto.
Defined.

Remark rem_809 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_745 epsilon_magent_p_q3 X1).
Defined.

Remark rem_810 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_781 epsilon_magent_p_q3 X2).
Defined.

Remark rem_811 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> (auto__q3 X1 /\ auto__q1 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  cut (auto__q3 X1). 2:apply (rem_809 epsilon_magent_p_q3 X1 X2);  assumption.
  cut (auto__q1 X2). 2:apply (rem_810 epsilon_magent_p_q3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_812 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  case (rem_811 epsilon_magent_p_q3 X1 X2 A1 A2). clear  epsilon_magent_p_q3 A1 A2. intros. apply trans__q3_key_1;  tauto.
 clear  epsilon_magent_p_q3 A1 A2. tauto.
Defined.

Remark rem_813 : forall X1 X2:term, auto_agent (key X1 X2) -> or_1
    (auto__q3 X1 /\ auto__q1 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_814 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto_agent (key X1 X2) -> auto__q3 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intro H. intros.
  elim (rem_813 X1 X2 H);  intros.
  apply (rem_812 epsilon_magent_p_q3 X1 X2);  tauto.
Defined.

Remark rem_815 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_745 epsilon_magent_p_q3 X1).
Defined.

Remark rem_816 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_739 epsilon_magent_p_q3 X2).
Defined.

Remark rem_817 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_776 epsilon_magent_p_q3 X3).
Defined.

Remark rem_818 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> (auto__q3 X1 /\ auto__q3 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_815 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_816 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_817 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_819 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_818 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_nonces_current_1;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_820 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_745 epsilon_magent_p_q3 X1).
Defined.

Remark rem_821 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_781 epsilon_magent_p_q3 X2).
Defined.

Remark rem_822 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_776 epsilon_magent_p_q3 X3).
Defined.

Remark rem_823 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> (auto__q3 X1 /\ auto__q1 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_820 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_821 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_822 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_824 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_823 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_nonces_current_2;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_825 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_745 epsilon_magent_p_q3 X1).
Defined.

Remark rem_826 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_781 epsilon_magent_p_q3 X2).
Defined.

Remark rem_827 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q1 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q1 X3 -> auto__q1 X3). tauto. exact (rem_741 epsilon_magent_p_q3 X3).
Defined.

Remark rem_828 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> (auto__q3 X1 /\ auto__q1 X2 /\ auto__q1 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_825 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_826 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q1 X3). 2:apply (rem_827 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_829 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q3 (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_828 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_nonces_current_3;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_830 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_745 epsilon_magent_p_q3 X1).
Defined.

Remark rem_831 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_747 epsilon_magent_p_q3 X2).
Defined.

Remark rem_832 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_754 epsilon_magent_p_q3 X3).
Defined.

Remark rem_833 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> (auto__q3 X1 /\ auto__q2 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_830 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_831 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_832 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_834 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q3 (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_833 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_nonces_current_4;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_835 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_737 epsilon_magent_p_q3 X1).
Defined.

Remark rem_836 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_739 epsilon_magent_p_q3 X2).
Defined.

Remark rem_837 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_754 epsilon_magent_p_q3 X3).
Defined.

Remark rem_838 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> (auto__q2 X1 /\ auto__q3 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_835 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_836 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_837 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_839 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_838 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_nonces_current_5;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_840 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_745 epsilon_magent_p_q3 X1).
Defined.

Remark rem_841 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_747 epsilon_magent_p_q3 X2).
Defined.

Remark rem_842 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_776 epsilon_magent_p_q3 X3).
Defined.

Remark rem_843 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> (auto__q3 X1 /\ auto__q2 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_840 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_841 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_842 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_844 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q3 (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_843 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_nonces_current_6;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_845 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_763 epsilon_magent_p_q3 X1).
Defined.

Remark rem_846 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_747 epsilon_magent_p_q3 X2).
Defined.

Remark rem_847 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_754 epsilon_magent_p_q3 X3).
Defined.

Remark rem_848 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> (auto__q1 X1 /\ auto__q2 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_845 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_846 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_847 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_849 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q3 (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_848 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_nonces_current_7;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_850 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_745 epsilon_magent_p_q3 X1).
Defined.

Remark rem_851 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_781 epsilon_magent_p_q3 X2).
Defined.

Remark rem_852 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_754 epsilon_magent_p_q3 X3).
Defined.

Remark rem_853 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> (auto__q3 X1 /\ auto__q1 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q3 X1). 2:apply (rem_850 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_851 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_852 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_854 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q3 (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_853 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_nonces_current_8;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_855 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_763 epsilon_magent_p_q3 X1).
Defined.

Remark rem_856 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_781 epsilon_magent_p_q3 X2).
Defined.

Remark rem_857 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q2 X3). tauto. exact (rem_754 epsilon_magent_p_q3 X3).
Defined.

Remark rem_858 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> (auto__q1 X1 /\ auto__q1 X2 /\ auto__q2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_855 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_856 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q2 X3). 2:apply (rem_857 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_859 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q3 (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_858 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_nonces_current_9;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_860 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_763 epsilon_magent_p_q3 X1).
Defined.

Remark rem_861 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_739 epsilon_magent_p_q3 X2).
Defined.

Remark rem_862 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_776 epsilon_magent_p_q3 X3).
Defined.

Remark rem_863 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> (auto__q1 X1 /\ auto__q3 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_860 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_861 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_862 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_864 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_863 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_nonces_current_10;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_865 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_763 epsilon_magent_p_q3 X1).
Defined.

Remark rem_866 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_781 epsilon_magent_p_q3 X2).
Defined.

Remark rem_867 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_776 epsilon_magent_p_q3 X3).
Defined.

Remark rem_868 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> (auto__q1 X1 /\ auto__q1 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_865 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_866 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_867 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_869 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 (nonces_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_868 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_nonces_current_11;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_870 : forall X1 X2 X3:term, auto_agent (nonces_current X1 X2 X3) -> or_11
    (auto__q3 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q3 X1 /\ auto__q1 X2 /\ auto__q3 X3)
    (auto__q3 X1 /\ auto__q1 X2 /\ auto__q1 X3)
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q2 X1 /\ auto__q3 X2 /\ auto__q2 X3)
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q3 X1 /\ auto__q1 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q1 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q1 X2 /\ auto__q3 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_11_intro_1; tauto.
  intros. apply or_11_intro_2; tauto.
  intros. apply or_11_intro_3; tauto.
  intros. apply or_11_intro_4; tauto.
  intros. apply or_11_intro_5; tauto.
  intros. apply or_11_intro_6; tauto.
  intros. apply or_11_intro_7; tauto.
  intros. apply or_11_intro_8; tauto.
  intros. apply or_11_intro_9; tauto.
  intros. apply or_11_intro_10; tauto.
  intros. apply or_11_intro_11; tauto.
Qed.

Remark rem_871 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto_agent (nonces_current X1 X2 X3) -> auto__q3 (nonces_current X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intro H. intros.
  elim (rem_870 X1 X2 X3 H);  intros.
  apply (rem_819 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_824 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_829 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_834 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_839 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_844 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_849 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_854 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_859 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_864 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_869 epsilon_magent_p_q3 X1 X2 X3);  tauto.
Defined.

Remark rem_872 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_737 epsilon_magent_p_q3 X1).
Defined.

Remark rem_873 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_739 epsilon_magent_p_q3 X2).
Defined.

Remark rem_874 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> (auto__q2 X1 /\ auto__q3 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  cut (auto__q2 X1). 2:apply (rem_872 epsilon_magent_p_q3 X1 X2);  assumption.
  cut (auto__q3 X2). 2:apply (rem_873 epsilon_magent_p_q3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_875 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 (f2 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  case (rem_874 epsilon_magent_p_q3 X1 X2 A1 A2). clear  epsilon_magent_p_q3 A1 A2. intros. apply trans__q3_f2_1;  tauto.
 clear  epsilon_magent_p_q3 A1 A2. tauto.
Defined.

Remark rem_876 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_763 epsilon_magent_p_q3 X1).
Defined.

Remark rem_877 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_739 epsilon_magent_p_q3 X2).
Defined.

Remark rem_878 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> (auto__q1 X1 /\ auto__q3 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  cut (auto__q1 X1). 2:apply (rem_876 epsilon_magent_p_q3 X1 X2);  assumption.
  cut (auto__q3 X2). 2:apply (rem_877 epsilon_magent_p_q3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_879 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 (f2 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  case (rem_878 epsilon_magent_p_q3 X1 X2 A1 A2). clear  epsilon_magent_p_q3 A1 A2. intros. apply trans__q3_f2_2;  tauto.
 clear  epsilon_magent_p_q3 A1 A2. tauto.
Defined.

Remark rem_880 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_745 epsilon_magent_p_q3 X1).
Defined.

Remark rem_881 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_739 epsilon_magent_p_q3 X2).
Defined.

Remark rem_882 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> (auto__q3 X1 /\ auto__q3 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  cut (auto__q3 X1). 2:apply (rem_880 epsilon_magent_p_q3 X1 X2);  assumption.
  cut (auto__q3 X2). 2:apply (rem_881 epsilon_magent_p_q3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_883 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 (f2 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  case (rem_882 epsilon_magent_p_q3 X1 X2 A1 A2). clear  epsilon_magent_p_q3 A1 A2. intros. apply trans__q3_f2_3;  tauto.
 clear  epsilon_magent_p_q3 A1 A2. tauto.
Defined.

Remark rem_884 : forall X1 X2:term, auto_agent (f2 X1 X2) -> or_3
    (auto__q2 X1 /\ auto__q3 X2)
    (auto__q1 X1 /\ auto__q3 X2)
    (auto__q3 X1 /\ auto__q3 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_885 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto_agent (f2 X1 X2) -> auto__q3 (f2 X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intro H. intros.
  elim (rem_884 X1 X2 H);  intros.
  apply (rem_875 epsilon_magent_p_q3 X1 X2);  tauto.
  apply (rem_879 epsilon_magent_p_q3 X1 X2);  tauto.
  apply (rem_883 epsilon_magent_p_q3 X1 X2);  tauto.
Defined.

Remark rem_886 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 (f3 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  case (rem_878 epsilon_magent_p_q3 X1 X2 A1 A2). clear  epsilon_magent_p_q3 A1 A2. intros. apply trans__q3_f3_1;  tauto.
 clear  epsilon_magent_p_q3 A1 A2. tauto.
Defined.

Remark rem_887 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_763 epsilon_magent_p_q3 X1).
Defined.

Remark rem_888 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_781 epsilon_magent_p_q3 X2).
Defined.

Remark rem_889 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> (auto__q1 X1 /\ auto__q1 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  cut (auto__q1 X1). 2:apply (rem_887 epsilon_magent_p_q3 X1 X2);  assumption.
  cut (auto__q1 X2). 2:apply (rem_888 epsilon_magent_p_q3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_890 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 (f3 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  case (rem_889 epsilon_magent_p_q3 X1 X2 A1 A2). clear  epsilon_magent_p_q3 A1 A2. intros. apply trans__q3_f3_2;  tauto.
 clear  epsilon_magent_p_q3 A1 A2. tauto.
Defined.

Remark rem_891 : forall X1 X2:term, auto_agent (f3 X1 X2) -> or_2
    (auto__q1 X1 /\ auto__q3 X2)
    (auto__q1 X1 /\ auto__q1 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_892 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto_agent (f3 X1 X2) -> auto__q3 (f3 X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intro H. intros.
  elim (rem_891 X1 X2 H);  intros.
  apply (rem_886 epsilon_magent_p_q3 X1 X2);  tauto.
  apply (rem_890 epsilon_magent_p_q3 X1 X2);  tauto.
Defined.

Remark rem_893 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q3 (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_750 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_f1_1;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_894 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q3 (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_848 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_f1_2;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_895 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_737 epsilon_magent_p_q3 X1).
Defined.

Remark rem_896 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_781 epsilon_magent_p_q3 X2).
Defined.

Remark rem_897 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_776 epsilon_magent_p_q3 X3).
Defined.

Remark rem_898 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> (auto__q2 X1 /\ auto__q1 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_895 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q1 X2). 2:apply (rem_896 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_897 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_899 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_898 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_f1_3;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_900 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q3 (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_756 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_f1_4;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_901 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_863 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_f1_5;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_902 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 (f1 X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_868 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_f1_6;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_903 : forall X1 X2 X3:term, auto_agent (f1 X1 X2 X3) -> or_6
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q1 X2 /\ auto__q3 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_6_intro_1; tauto.
  intros. apply or_6_intro_2; tauto.
  intros. apply or_6_intro_3; tauto.
  intros. apply or_6_intro_4; tauto.
  intros. apply or_6_intro_5; tauto.
  intros. apply or_6_intro_6; tauto.
Qed.

Remark rem_904 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto_agent (f1 X1 X2 X3) -> auto__q3 (f1 X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intro H. intros.
  elim (rem_903 X1 X2 X3 H);  intros.
  apply (rem_893 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_894 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_899 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_900 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_901 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_902 epsilon_magent_p_q3 X1 X2 X3);  tauto.
Defined.

Remark rem_905 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 (f4 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  case (rem_878 epsilon_magent_p_q3 X1 X2 A1 A2). clear  epsilon_magent_p_q3 A1 A2. intros. apply trans__q3_f4_1;  tauto.
 clear  epsilon_magent_p_q3 A1 A2. tauto.
Defined.

Remark rem_906 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_737 epsilon_magent_p_q3 X1).
Defined.

Remark rem_907 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_747 epsilon_magent_p_q3 X2).
Defined.

Remark rem_908 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> (auto__q2 X1 /\ auto__q2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  cut (auto__q2 X1). 2:apply (rem_906 epsilon_magent_p_q3 X1 X2);  assumption.
  cut (auto__q2 X2). 2:apply (rem_907 epsilon_magent_p_q3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_909 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 (f4 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  case (rem_908 epsilon_magent_p_q3 X1 X2 A1 A2). clear  epsilon_magent_p_q3 A1 A2. intros. apply trans__q3_f4_2;  tauto.
 clear  epsilon_magent_p_q3 A1 A2. tauto.
Defined.

Remark rem_910 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2.
  cut (auto__q3 X1 -> auto__q3 X1). tauto. exact (rem_745 epsilon_magent_p_q3 X1).
Defined.

Remark rem_911 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_747 epsilon_magent_p_q3 X2).
Defined.

Remark rem_912 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> (auto__q3 X1 /\ auto__q2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  cut (auto__q3 X1). 2:apply (rem_910 epsilon_magent_p_q3 X1 X2);  assumption.
  cut (auto__q2 X2). 2:apply (rem_911 epsilon_magent_p_q3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_913 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 (f4 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  case (rem_912 epsilon_magent_p_q3 X1 X2 A1 A2). clear  epsilon_magent_p_q3 A1 A2. intros. apply trans__q3_f4_3;  tauto.
 clear  epsilon_magent_p_q3 A1 A2. tauto.
Defined.

Remark rem_914 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 (f4 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  case (rem_889 epsilon_magent_p_q3 X1 X2 A1 A2). clear  epsilon_magent_p_q3 A1 A2. intros. apply trans__q3_f4_4;  tauto.
 clear  epsilon_magent_p_q3 A1 A2. tauto.
Defined.

Remark rem_915 : forall X1 X2:term, auto_agent (f4 X1 X2) -> or_4
    (auto__q1 X1 /\ auto__q3 X2)
    (auto__q2 X1 /\ auto__q2 X2)
    (auto__q3 X1 /\ auto__q2 X2)
    (auto__q1 X1 /\ auto__q1 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_4_intro_1; tauto.
  intros. apply or_4_intro_2; tauto.
  intros. apply or_4_intro_3; tauto.
  intros. apply or_4_intro_4; tauto.
Qed.

Remark rem_916 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto_agent (f4 X1 X2) -> auto__q3 (f4 X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intro H. intros.
  elim (rem_915 X1 X2 H);  intros.
  apply (rem_905 epsilon_magent_p_q3 X1 X2);  tauto.
  apply (rem_909 epsilon_magent_p_q3 X1 X2);  tauto.
  apply (rem_913 epsilon_magent_p_q3 X1 X2);  tauto.
  apply (rem_914 epsilon_magent_p_q3 X1 X2);  tauto.
Defined.

Remark rem_917 : (forall X:term, auto_agent X -> auto__q3 X)
    -> auto__q3 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3.  case (rem_797 epsilon_magent_p_q3). clear  epsilon_magent_p_q3. intros. apply trans__q3_server_1;  tauto.
 clear  epsilon_magent_p_q3. tauto.
Defined.

Remark rem_918 : auto_agent server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_919 : (forall X:term, auto_agent X -> auto__q3 X)
    -> auto_agent server -> auto__q3 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p_q3. intro H. intros.
  elim (rem_918 H);  intros.
  apply (rem_917 epsilon_magent_p_q3);  tauto.
Defined.

Remark rem_920 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  case (rem_878 epsilon_magent_p_q3 X1 X2 A1 A2). clear  epsilon_magent_p_q3 A1 A2. intros. apply trans__q3_cons_1;  tauto.
 clear  epsilon_magent_p_q3 A1 A2. tauto.
Defined.

Remark rem_921 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  case (rem_811 epsilon_magent_p_q3 X1 X2 A1 A2). clear  epsilon_magent_p_q3 A1 A2. intros. apply trans__q3_cons_2;  tauto.
 clear  epsilon_magent_p_q3 A1 A2. tauto.
Defined.

Remark rem_922 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  case (rem_882 epsilon_magent_p_q3 X1 X2 A1 A2). clear  epsilon_magent_p_q3 A1 A2. intros. apply trans__q3_cons_3;  tauto.
 clear  epsilon_magent_p_q3 A1 A2. tauto.
Defined.

Remark rem_923 : forall X1 X2:term, auto_agent (cons X1 X2) -> or_3
    (auto__q1 X1 /\ auto__q3 X2)
    (auto__q3 X1 /\ auto__q1 X2)
    (auto__q3 X1 /\ auto__q3 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_924 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto_agent (cons X1 X2) -> auto__q3 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intro H. intros.
  elim (rem_923 X1 X2 H);  intros.
  apply (rem_920 epsilon_magent_p_q3 X1 X2);  tauto.
  apply (rem_921 epsilon_magent_p_q3 X1 X2);  tauto.
  apply (rem_922 epsilon_magent_p_q3 X1 X2);  tauto.
Defined.

Remark rem_925 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_818 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_session_old_1;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_926 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_737 epsilon_magent_p_q3 X1).
Defined.

Remark rem_927 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q3 X2). tauto. exact (rem_739 epsilon_magent_p_q3 X2).
Defined.

Remark rem_928 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q3 X3). tauto. exact (rem_776 epsilon_magent_p_q3 X3).
Defined.

Remark rem_929 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> (auto__q2 X1 /\ auto__q3 X2 /\ auto__q3 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_926 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q3 X2). 2:apply (rem_927 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q3 X3). 2:apply (rem_928 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_930 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_929 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_session_old_2;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_931 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q3 (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_843 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_session_old_3;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_932 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q3 (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_750 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_session_old_4;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_933 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q3 (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_848 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_session_old_5;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_934 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_898 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_session_old_6;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_935 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_763 epsilon_magent_p_q3 X1).
Defined.

Remark rem_936 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_747 epsilon_magent_p_q3 X2).
Defined.

Remark rem_937 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q1 X3 -> auto__q1 X3). tauto. exact (rem_741 epsilon_magent_p_q3 X3).
Defined.

Remark rem_938 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> (auto__q1 X1 /\ auto__q2 X2 /\ auto__q1 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q1 X1). 2:apply (rem_935 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_936 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q1 X3). 2:apply (rem_937 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_939 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q3 (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_938 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_session_old_7;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_940 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q3 (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_858 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_session_old_8;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_941 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q3 (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_767 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_session_old_9;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_942 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_772 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_session_old_10;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_943 : forall X1 X2 X3:term, auto_agent (session_old X1 X2 X3) -> or_10
    (auto__q3 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q3 X3)
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q1 X1 /\ auto__q1 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q1 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q2 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_10_intro_1; tauto.
  intros. apply or_10_intro_2; tauto.
  intros. apply or_10_intro_3; tauto.
  intros. apply or_10_intro_4; tauto.
  intros. apply or_10_intro_5; tauto.
  intros. apply or_10_intro_6; tauto.
  intros. apply or_10_intro_7; tauto.
  intros. apply or_10_intro_8; tauto.
  intros. apply or_10_intro_9; tauto.
  intros. apply or_10_intro_10; tauto.
Qed.

Remark rem_944 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto_agent (session_old X1 X2 X3) -> auto__q3 (session_old X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intro H. intros.
  elim (rem_943 X1 X2 X3 H);  intros.
  apply (rem_925 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_930 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_931 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_932 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_933 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_934 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_939 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_940 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_941 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_942 epsilon_magent_p_q3 X1 X2 X3);  tauto.
Defined.

Remark rem_945 : (forall X:term, auto_agent X -> auto__q3 X)
    -> auto__q3 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3.  case (rem_797 epsilon_magent_p_q3). clear  epsilon_magent_p_q3. intros. apply trans__q3_bob_1;  tauto.
 clear  epsilon_magent_p_q3. tauto.
Defined.

Remark rem_946 : auto_agent bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_947 : (forall X:term, auto_agent X -> auto__q3 X)
    -> auto_agent bob -> auto__q3 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p_q3. intro H. intros.
  elim (rem_946 H);  intros.
  apply (rem_945 epsilon_magent_p_q3);  tauto.
Defined.

Remark rem_948 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_737 epsilon_magent_p_q3 X1).
Defined.

Remark rem_949 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2.
  cut (auto__q1 X2 -> auto__q1 X2). tauto. exact (rem_781 epsilon_magent_p_q3 X2).
Defined.

Remark rem_950 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> (auto__q2 X1 /\ auto__q1 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  cut (auto__q2 X1). 2:apply (rem_948 epsilon_magent_p_q3 X1 X2);  assumption.
  cut (auto__q1 X2). 2:apply (rem_949 epsilon_magent_p_q3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_951 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  case (rem_950 epsilon_magent_p_q3 X1 X2 A1 A2). clear  epsilon_magent_p_q3 A1 A2. intros. apply trans__q3_crypt_1;  tauto.
 clear  epsilon_magent_p_q3 A1 A2. tauto.
Defined.

Remark rem_952 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  case (rem_811 epsilon_magent_p_q3 X1 X2 A1 A2). clear  epsilon_magent_p_q3 A1 A2. intros. apply trans__q3_crypt_2;  tauto.
 clear  epsilon_magent_p_q3 A1 A2. tauto.
Defined.

Remark rem_953 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  case (rem_908 epsilon_magent_p_q3 X1 X2 A1 A2). clear  epsilon_magent_p_q3 A1 A2. intros. apply trans__q3_crypt_3;  tauto.
 clear  epsilon_magent_p_q3 A1 A2. tauto.
Defined.

Remark rem_954 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  case (rem_882 epsilon_magent_p_q3 X1 X2 A1 A2). clear  epsilon_magent_p_q3 A1 A2. intros. apply trans__q3_crypt_4;  tauto.
 clear  epsilon_magent_p_q3 A1 A2. tauto.
Defined.

Remark rem_955 : forall X1 X2:term, auto_agent (crypt X1 X2) -> or_4
    (auto__q2 X1 /\ auto__q1 X2)
    (auto__q3 X1 /\ auto__q1 X2)
    (auto__q2 X1 /\ auto__q2 X2)
    (auto__q3 X1 /\ auto__q3 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_4_intro_1; tauto.
  intros. apply or_4_intro_2; tauto.
  intros. apply or_4_intro_3; tauto.
  intros. apply or_4_intro_4; tauto.
Qed.

Remark rem_956 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto_agent (crypt X1 X2) -> auto__q3 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intro H. intros.
  elim (rem_955 X1 X2 H);  intros.
  apply (rem_951 epsilon_magent_p_q3 X1 X2);  tauto.
  apply (rem_952 epsilon_magent_p_q3 X1 X2);  tauto.
  apply (rem_953 epsilon_magent_p_q3 X1 X2);  tauto.
  apply (rem_954 epsilon_magent_p_q3 X1 X2);  tauto.
Defined.

Remark rem_957 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_929 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_nonces_old_1;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_958 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q2 X1). tauto. exact (rem_737 epsilon_magent_p_q3 X1).
Defined.

Remark rem_959 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_747 epsilon_magent_p_q3 X2).
Defined.

Remark rem_960 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3.
  cut (auto__q1 X3 -> auto__q1 X3). tauto. exact (rem_741 epsilon_magent_p_q3 X3).
Defined.

Remark rem_961 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> (auto__q2 X1 /\ auto__q2 X2 /\ auto__q1 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto__q2 X1). 2:apply (rem_958 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q2 X2). 2:apply (rem_959 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  cut (auto__q1 X3). 2:apply (rem_960 epsilon_magent_p_q3 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_962 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q3 (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_961 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_nonces_old_2;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_963 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q3 (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_828 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_nonces_old_3;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_964 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q3 (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_833 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_nonces_old_4;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_965 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q3 (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_743 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_nonces_old_5;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_966 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_838 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_nonces_old_6;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_967 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q3 (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_750 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_nonces_old_7;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_968 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q3 (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_848 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_nonces_old_8;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_969 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q3 (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_767 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_nonces_old_9;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_970 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q3 (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_784 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_nonces_old_10;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_971 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q3 (nonces_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_789 epsilon_magent_p_q3 X1 X2 X3 A1 A2 A3). clear  epsilon_magent_p_q3 A1 A2 A3. intros. apply trans__q3_nonces_old_11;  tauto.
 clear  epsilon_magent_p_q3 A1 A2 A3. tauto.
Defined.

Remark rem_972 : forall X1 X2 X3:term, auto_agent (nonces_old X1 X2 X3) -> or_11
    (auto__q2 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q3 X1 /\ auto__q1 X2 /\ auto__q1 X3)
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q2 X1 /\ auto__q3 X2 /\ auto__q1 X3)
    (auto__q2 X1 /\ auto__q3 X2 /\ auto__q2 X3)
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q1 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q1 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q2 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_11_intro_1; tauto.
  intros. apply or_11_intro_2; tauto.
  intros. apply or_11_intro_3; tauto.
  intros. apply or_11_intro_4; tauto.
  intros. apply or_11_intro_5; tauto.
  intros. apply or_11_intro_6; tauto.
  intros. apply or_11_intro_7; tauto.
  intros. apply or_11_intro_8; tauto.
  intros. apply or_11_intro_9; tauto.
  intros. apply or_11_intro_10; tauto.
  intros. apply or_11_intro_11; tauto.
Qed.

Remark rem_973 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2 X3:term, auto_agent (nonces_old X1 X2 X3) -> auto__q3 (nonces_old X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2 X3. intro H. intros.
  elim (rem_972 X1 X2 X3 H);  intros.
  apply (rem_957 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_962 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_963 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_964 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_965 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_966 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_967 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_968 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_969 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_970 epsilon_magent_p_q3 X1 X2 X3);  tauto.
  apply (rem_971 epsilon_magent_p_q3 X1 X2 X3);  tauto.
Defined.

Remark rem_974 : (forall X:term, auto_agent X -> auto__q3 X)
    -> auto__q3 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3.  case (rem_797 epsilon_magent_p_q3). clear  epsilon_magent_p_q3. intros. apply trans__q3_alice_1;  tauto.
 clear  epsilon_magent_p_q3. tauto.
Defined.

Remark rem_975 : auto_agent alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_976 : (forall X:term, auto_agent X -> auto__q3 X)
    -> auto_agent alice -> auto__q3 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p_q3. intro H. intros.
  elim (rem_975 H);  intros.
  apply (rem_974 epsilon_magent_p_q3);  tauto.
Defined.

Remark rem_977 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 (f5 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  case (rem_950 epsilon_magent_p_q3 X1 X2 A1 A2). clear  epsilon_magent_p_q3 A1 A2. intros. apply trans__q3_f5_1;  tauto.
 clear  epsilon_magent_p_q3 A1 A2. tauto.
Defined.

Remark rem_978 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 (f5 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  case (rem_878 epsilon_magent_p_q3 X1 X2 A1 A2). clear  epsilon_magent_p_q3 A1 A2. intros. apply trans__q3_f5_2;  tauto.
 clear  epsilon_magent_p_q3 A1 A2. tauto.
Defined.

Remark rem_979 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 (f5 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  case (rem_811 epsilon_magent_p_q3 X1 X2 A1 A2). clear  epsilon_magent_p_q3 A1 A2. intros. apply trans__q3_f5_3;  tauto.
 clear  epsilon_magent_p_q3 A1 A2. tauto.
Defined.

Remark rem_980 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 (f5 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  case (rem_908 epsilon_magent_p_q3 X1 X2 A1 A2). clear  epsilon_magent_p_q3 A1 A2. intros. apply trans__q3_f5_4;  tauto.
 clear  epsilon_magent_p_q3 A1 A2. tauto.
Defined.

Remark rem_981 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 (f5 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  case (rem_912 epsilon_magent_p_q3 X1 X2 A1 A2). clear  epsilon_magent_p_q3 A1 A2. intros. apply trans__q3_f5_5;  tauto.
 clear  epsilon_magent_p_q3 A1 A2. tauto.
Defined.

Remark rem_982 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 (f5 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  case (rem_889 epsilon_magent_p_q3 X1 X2 A1 A2). clear  epsilon_magent_p_q3 A1 A2. intros. apply trans__q3_f5_6;  tauto.
 clear  epsilon_magent_p_q3 A1 A2. tauto.
Defined.

Remark rem_983 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2.
  cut (auto__q1 X1 -> auto__q1 X1). tauto. exact (rem_763 epsilon_magent_p_q3 X1).
Defined.

Remark rem_984 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2.
  cut (auto__q2 X2 -> auto__q2 X2). tauto. exact (rem_747 epsilon_magent_p_q3 X2).
Defined.

Remark rem_985 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> (auto__q1 X1 /\ auto__q2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  cut (auto__q1 X1). 2:apply (rem_983 epsilon_magent_p_q3 X1 X2);  assumption.
  cut (auto__q2 X2). 2:apply (rem_984 epsilon_magent_p_q3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_986 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 (f5 X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intros A1 A2.
  case (rem_985 epsilon_magent_p_q3 X1 X2 A1 A2). clear  epsilon_magent_p_q3 A1 A2. intros. apply trans__q3_f5_7;  tauto.
 clear  epsilon_magent_p_q3 A1 A2. tauto.
Defined.

Remark rem_987 : forall X1 X2:term, auto_agent (f5 X1 X2) -> or_7
    (auto__q2 X1 /\ auto__q1 X2)
    (auto__q1 X1 /\ auto__q3 X2)
    (auto__q3 X1 /\ auto__q1 X2)
    (auto__q2 X1 /\ auto__q2 X2)
    (auto__q3 X1 /\ auto__q2 X2)
    (auto__q1 X1 /\ auto__q1 X2)
    (auto__q1 X1 /\ auto__q2 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_7_intro_1; tauto.
  intros. apply or_7_intro_2; tauto.
  intros. apply or_7_intro_3; tauto.
  intros. apply or_7_intro_4; tauto.
  intros. apply or_7_intro_5; tauto.
  intros. apply or_7_intro_6; tauto.
  intros. apply or_7_intro_7; tauto.
Qed.

Remark rem_988 : (forall X:term, auto_agent X -> auto__q3 X)
    -> forall X1 X2:term, auto_agent (f5 X1 X2) -> auto__q3 (f5 X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p_q3. intros X1 X2. intro H. intros.
  elim (rem_987 X1 X2 H);  intros.
  apply (rem_977 epsilon_magent_p_q3 X1 X2);  tauto.
  apply (rem_978 epsilon_magent_p_q3 X1 X2);  tauto.
  apply (rem_979 epsilon_magent_p_q3 X1 X2);  tauto.
  apply (rem_980 epsilon_magent_p_q3 X1 X2);  tauto.
  apply (rem_981 epsilon_magent_p_q3 X1 X2);  tauto.
  apply (rem_982 epsilon_magent_p_q3 X1 X2);  tauto.
  apply (rem_986 epsilon_magent_p_q3 X1 X2);  tauto.
Defined.

Remark rem_989 : auto_agent sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_990 : auto_agent nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_991 : auto_agent request_id -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_992 : auto_agent success -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_993 : auto_agent respond_id -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_994 : auto_agent pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_995 : auto_agent prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_996 : forall X1:term, auto_agent X1 -> auto__q3 X1. (* Induct. *)
Proof.
  fix epsilon_magent_p_q3 1.
  intro X. case X.
  exact (rem_976 epsilon_magent_p_q3 ).
  exact (rem_947 epsilon_magent_p_q3 ).
  intros X1 X2;  exact (rem_924 epsilon_magent_p_q3 X1 X2).
  intros X1 X2;  exact (rem_956 epsilon_magent_p_q3 X1 X2).
  intros X1 X2 X3;  exact (rem_904 epsilon_magent_p_q3 X1 X2 X3).
  intros X1 X2;  exact (rem_885 epsilon_magent_p_q3 X1 X2).
  intros X1 X2;  exact (rem_892 epsilon_magent_p_q3 X1 X2).
  intros X1 X2;  exact (rem_916 epsilon_magent_p_q3 X1 X2).
  intros X1 X2;  exact (rem_988 epsilon_magent_p_q3 X1 X2).
  intros X1;  exact (rem_805 epsilon_magent_p_q3 X1).
  exact (rem_800 epsilon_magent_p_q3 ).
  intros X1 X2;  exact (rem_814 epsilon_magent_p_q3 X1 X2).
  intros X1;  exact (rem_808 epsilon_magent_p_q3 X1).
   intro H. elim (rem_990  H).
  intros X1 X2 X3;  exact (rem_871 epsilon_magent_p_q3 X1 X2 X3).
  intros X1 X2 X3;  exact (rem_973 epsilon_magent_p_q3 X1 X2 X3).
   intro H. elim (rem_995  H).
   intro H. elim (rem_994  H).
   intro H. elim (rem_991  H).
   intro H. elim (rem_993  H).
  intros X1;  exact (rem_796 epsilon_magent_p_q3 X1).
  exact (rem_919 epsilon_magent_p_q3 ).
  intros X1 X2 X3;  exact (rem_792 epsilon_magent_p_q3 X1 X2 X3).
  intros X1 X2 X3;  exact (rem_944 epsilon_magent_p_q3 X1 X2 X3).
   intro H. elim (rem_992  H).
   intro H. elim (rem_989  H).
Qed.

Remark rem_997 : forall X1:term, auto_agent X1 -> auto_knows_current request_id -> auto__q3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1.
  cut (auto_agent X1 -> auto__q3 X1). tauto. exact (rem_996 X1).
Qed.

Remark rem_998 : forall X1:term, auto_agent X1 -> auto_knows_current request_id -> auto__q3 X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1. intros A1 A2.
  cut (auto__q3 X1). 2:apply (rem_997 X1);  assumption.
  tauto.
Qed.

Remark rem_999 : forall X1:term, auto_agent X1 -> auto_knows_current request_id -> auto__q1 (nai X1). (* Deduce positive atom. *)
Proof.
  intros X1. intros A1 A2.
  case (rem_998 X1 A1 A2). clear  A1 A2. intros. apply trans__q1_nai_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1000 : forall X1:term, auto_agent X1 -> auto_knows_current request_id -> (auto__q1 respond_id /\ auto__q1 (nai X1)) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1. intros A1 A2.
  cut (auto__q1 respond_id). 2:apply (rem_736 X1);  assumption.
  cut (auto__q1 (nai X1)). 2:apply (rem_999 X1);  assumption.
  tauto.
Qed.

Remark rem_1001 : forall X1:term, auto_agent X1 -> auto_knows_current request_id -> auto_knows_current (cons respond_id (nai X1)). (* Deduce positive atom. *)
Proof.
  intros X1. intros A1 A2.
  case (rem_1000 X1 A1 A2). clear  A1 A2. intros. apply trans_knows_current_cons_4;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1002 : forall _big_p:term, auto_agent _big_p -> auto_knows_current request_id -> auto_knows_current (cons respond_id (nai _big_p)). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1.
  cut (auto_agent X1 -> auto_knows_current request_id -> auto_knows_current (cons respond_id (nai X1))). tauto. exact (rem_1001 X1).
Qed.

Inductive model_1 : Set := und_1:model_1 | val_1_1:model_1 | val_1_2:model_1 | val_1_3:model_1.

Fixpoint seval_1 (t : term) {struct t} : model_1 :=
  match t  with
    (session_current X1 X2 X3) => 
    match (seval_1 X1),(seval_1 X2),(seval_1 X3) with
      val_1_3,val_1_3,val_1_3 => val_1_1
    | val_1_3,val_1_2,val_1_1 => val_1_2
    | val_1_1,val_1_2,val_1_1 => val_1_1
    | val_1_1,val_1_3,val_1_2 => val_1_3
    | val_1_2,val_1_3,val_1_2 => val_1_1
    | val_1_1,val_1_2,val_1_2 => val_1_3
    | val_1_2,val_1_1,val_1_2 => val_1_1
    | val_1_3,val_1_1,val_1_2 => val_1_2
    | val_1_1,val_1_1,val_1_1 => val_1_2
    | val_1_1,val_1_3,val_1_3 => val_1_2
    | val_1_2,val_1_2,val_1_2 => val_1_3
    | val_1_3,val_1_3,val_1_2 => val_1_3
    | val_1_1,val_1_1,val_1_2 => val_1_3
    | val_1_1,val_1_2,val_1_3 => val_1_2
    | val_1_3,val_1_1,val_1_3 => val_1_1
    | val_1_2,val_1_1,val_1_3 => val_1_2
    | val_1_3,val_1_3,val_1_1 => val_1_1
    | val_1_1,val_1_1,val_1_3 => val_1_3
    | val_1_3,val_1_2,val_1_3 => val_1_2
    | val_1_2,val_1_1,val_1_1 => val_1_1
    | val_1_2,val_1_3,val_1_1 => val_1_1
    | val_1_2,val_1_2,val_1_1 => val_1_2
    | val_1_1,val_1_3,val_1_1 => val_1_2
    | val_1_2,val_1_3,val_1_3 => val_1_1
    | val_1_3,val_1_2,val_1_2 => val_1_3
    | val_1_2,val_1_2,val_1_3 => val_1_1
    | val_1_3,val_1_1,val_1_1 => val_1_3
    | _,_,_ => und_1
    end
  | sym => val_1_3
  | (s X1) => 
    match (seval_1 X1) with
      val_1_2 => val_1_2
    | val_1_3 => val_1_3
    | val_1_1 => val_1_1
    | _ => und_1
    end
  | nil => val_1_3
  | i => val_1_2
  | request_id => val_1_3
  | (h X1) => 
    match (seval_1 X1) with
      val_1_2 => val_1_2
    | val_1_3 => val_1_3
    | val_1_1 => val_1_2
    | _ => und_1
    end
  | (nai X1) => 
    match (seval_1 X1) with
      val_1_2 => val_1_3
    | val_1_3 => val_1_3
    | val_1_1 => val_1_2
    | _ => und_1
    end
  | success => val_1_3
  | (key X1 X2) => 
    match (seval_1 X1),(seval_1 X2) with
      val_1_1,val_1_3 => val_1_1
    | val_1_2,val_1_2 => val_1_1
    | val_1_1,val_1_2 => val_1_1
    | val_1_2,val_1_3 => val_1_2
    | val_1_2,val_1_1 => val_1_1
    | val_1_3,val_1_3 => val_1_1
    | val_1_3,val_1_1 => val_1_1
    | val_1_3,val_1_2 => val_1_1
    | val_1_1,val_1_1 => val_1_1
    | _,_ => und_1
    end
  | (nonces_current X1 X2 X3) => 
    match (seval_1 X1),(seval_1 X2),(seval_1 X3) with
      val_1_3,val_1_3,val_1_3 => val_1_1
    | val_1_3,val_1_2,val_1_1 => val_1_1
    | val_1_1,val_1_2,val_1_1 => val_1_2
    | val_1_1,val_1_3,val_1_2 => val_1_3
    | val_1_2,val_1_3,val_1_2 => val_1_2
    | val_1_1,val_1_2,val_1_2 => val_1_3
    | val_1_2,val_1_1,val_1_2 => val_1_2
    | val_1_3,val_1_1,val_1_2 => val_1_1
    | val_1_1,val_1_1,val_1_1 => val_1_1
    | val_1_1,val_1_3,val_1_3 => val_1_1
    | val_1_2,val_1_2,val_1_2 => val_1_2
    | val_1_3,val_1_3,val_1_2 => val_1_2
    | val_1_1,val_1_1,val_1_2 => val_1_3
    | val_1_1,val_1_2,val_1_3 => val_1_1
    | val_1_3,val_1_1,val_1_3 => val_1_1
    | val_1_2,val_1_1,val_1_3 => val_1_1
    | val_1_3,val_1_3,val_1_1 => val_1_2
    | val_1_1,val_1_1,val_1_3 => val_1_3
    | val_1_3,val_1_2,val_1_3 => val_1_1
    | val_1_2,val_1_1,val_1_1 => val_1_2
    | val_1_2,val_1_3,val_1_1 => val_1_2
    | val_1_2,val_1_2,val_1_1 => val_1_1
    | val_1_1,val_1_3,val_1_1 => val_1_1
    | val_1_2,val_1_3,val_1_3 => val_1_2
    | val_1_3,val_1_2,val_1_2 => val_1_2
    | val_1_2,val_1_2,val_1_3 => val_1_1
    | val_1_3,val_1_1,val_1_1 => val_1_2
    | _,_,_ => und_1
    end
  | respond_id => val_1_3
  | (f2 X1 X2) => 
    match (seval_1 X1),(seval_1 X2) with
      val_1_1,val_1_3 => val_1_3
    | val_1_2,val_1_2 => val_1_2
    | val_1_1,val_1_2 => val_1_2
    | val_1_2,val_1_3 => val_1_3
    | val_1_2,val_1_1 => val_1_1
    | val_1_3,val_1_3 => val_1_3
    | val_1_3,val_1_1 => val_1_1
    | val_1_3,val_1_2 => val_1_2
    | val_1_1,val_1_1 => val_1_1
    | _,_ => und_1
    end
  | pub => val_1_3
  | (f3 X1 X2) => 
    match (seval_1 X1),(seval_1 X2) with
      val_1_1,val_1_3 => val_1_3
    | val_1_2,val_1_2 => val_1_1
    | val_1_1,val_1_2 => val_1_1
    | val_1_2,val_1_3 => val_1_3
    | val_1_2,val_1_1 => val_1_3
    | val_1_3,val_1_3 => val_1_2
    | val_1_3,val_1_1 => val_1_1
    | val_1_3,val_1_2 => val_1_2
    | val_1_1,val_1_1 => val_1_3
    | _,_ => und_1
    end
  | (f1 X1 X2 X3) => 
    match (seval_1 X1),(seval_1 X2),(seval_1 X3) with
      val_1_3,val_1_3,val_1_3 => val_1_1
    | val_1_3,val_1_2,val_1_1 => val_1_1
    | val_1_1,val_1_2,val_1_1 => val_1_1
    | val_1_1,val_1_3,val_1_2 => val_1_2
    | val_1_2,val_1_3,val_1_2 => val_1_1
    | val_1_1,val_1_2,val_1_2 => val_1_3
    | val_1_2,val_1_1,val_1_2 => val_1_1
    | val_1_3,val_1_1,val_1_2 => val_1_1
    | val_1_1,val_1_1,val_1_1 => val_1_2
    | val_1_1,val_1_3,val_1_3 => val_1_1
    | val_1_2,val_1_2,val_1_2 => val_1_3
    | val_1_3,val_1_3,val_1_2 => val_1_2
    | val_1_1,val_1_1,val_1_2 => val_1_1
    | val_1_1,val_1_2,val_1_3 => val_1_1
    | val_1_3,val_1_1,val_1_3 => val_1_3
    | val_1_2,val_1_1,val_1_3 => val_1_2
    | val_1_3,val_1_3,val_1_1 => val_1_3
    | val_1_1,val_1_1,val_1_3 => val_1_3
    | val_1_3,val_1_2,val_1_3 => val_1_1
    | val_1_2,val_1_1,val_1_1 => val_1_3
    | val_1_2,val_1_3,val_1_1 => val_1_3
    | val_1_2,val_1_2,val_1_1 => val_1_1
    | val_1_1,val_1_3,val_1_1 => val_1_3
    | val_1_2,val_1_3,val_1_3 => val_1_3
    | val_1_3,val_1_2,val_1_2 => val_1_2
    | val_1_2,val_1_2,val_1_3 => val_1_1
    | val_1_3,val_1_1,val_1_1 => val_1_2
    | _,_,_ => und_1
    end
  | (f4 X1 X2) => 
    match (seval_1 X1),(seval_1 X2) with
      val_1_1,val_1_3 => val_1_3
    | val_1_2,val_1_2 => val_1_1
    | val_1_1,val_1_2 => val_1_1
    | val_1_2,val_1_3 => val_1_3
    | val_1_2,val_1_1 => val_1_2
    | val_1_3,val_1_3 => val_1_2
    | val_1_3,val_1_1 => val_1_1
    | val_1_3,val_1_2 => val_1_2
    | val_1_1,val_1_1 => val_1_2
    | _,_ => und_1
    end
  | server => val_1_2
  | (cons X1 X2) => 
    match (seval_1 X1),(seval_1 X2) with
      val_1_1,val_1_3 => val_1_1
    | val_1_2,val_1_2 => val_1_2
    | val_1_1,val_1_2 => val_1_1
    | val_1_2,val_1_3 => val_1_2
    | val_1_2,val_1_1 => val_1_1
    | val_1_3,val_1_3 => val_1_3
    | val_1_3,val_1_1 => val_1_1
    | val_1_3,val_1_2 => val_1_2
    | val_1_1,val_1_1 => val_1_1
    | _,_ => und_1
    end
  | (session_old X1 X2 X3) => 
    match (seval_1 X1),(seval_1 X2),(seval_1 X3) with
      val_1_3,val_1_3,val_1_3 => val_1_1
    | val_1_3,val_1_2,val_1_1 => val_1_2
    | val_1_1,val_1_2,val_1_1 => val_1_1
    | val_1_1,val_1_3,val_1_2 => val_1_2
    | val_1_2,val_1_3,val_1_2 => val_1_1
    | val_1_1,val_1_2,val_1_2 => val_1_2
    | val_1_2,val_1_1,val_1_2 => val_1_2
    | val_1_3,val_1_1,val_1_2 => val_1_1
    | val_1_1,val_1_1,val_1_1 => val_1_3
    | val_1_1,val_1_3,val_1_3 => val_1_3
    | val_1_2,val_1_2,val_1_2 => val_1_2
    | val_1_3,val_1_3,val_1_2 => val_1_1
    | val_1_1,val_1_1,val_1_2 => val_1_1
    | val_1_1,val_1_2,val_1_3 => val_1_1
    | val_1_3,val_1_1,val_1_3 => val_1_2
    | val_1_2,val_1_1,val_1_3 => val_1_2
    | val_1_3,val_1_3,val_1_1 => val_1_2
    | val_1_1,val_1_1,val_1_3 => val_1_1
    | val_1_3,val_1_2,val_1_3 => val_1_2
    | val_1_2,val_1_1,val_1_1 => val_1_3
    | val_1_2,val_1_3,val_1_1 => val_1_3
    | val_1_2,val_1_2,val_1_1 => val_1_1
    | val_1_1,val_1_3,val_1_1 => val_1_1
    | val_1_2,val_1_3,val_1_3 => val_1_1
    | val_1_3,val_1_2,val_1_2 => val_1_1
    | val_1_2,val_1_2,val_1_3 => val_1_1
    | val_1_3,val_1_1,val_1_1 => val_1_2
    | _,_,_ => und_1
    end
  | bob => val_1_2
  | (crypt X1 X2) => 
    match (seval_1 X1),(seval_1 X2) with
      val_1_1,val_1_3 => val_1_2
    | val_1_2,val_1_2 => val_1_2
    | val_1_1,val_1_2 => val_1_3
    | val_1_2,val_1_3 => val_1_2
    | val_1_2,val_1_1 => val_1_3
    | val_1_3,val_1_3 => val_1_3
    | val_1_3,val_1_1 => val_1_3
    | val_1_3,val_1_2 => val_1_3
    | val_1_1,val_1_1 => val_1_2
    | _,_ => und_1
    end
  | (nonces_old X1 X2 X3) => 
    match (seval_1 X1),(seval_1 X2),(seval_1 X3) with
      val_1_3,val_1_3,val_1_3 => val_1_1
    | val_1_3,val_1_2,val_1_1 => val_1_3
    | val_1_1,val_1_2,val_1_1 => val_1_2
    | val_1_1,val_1_3,val_1_2 => val_1_1
    | val_1_2,val_1_3,val_1_2 => val_1_3
    | val_1_1,val_1_2,val_1_2 => val_1_2
    | val_1_2,val_1_1,val_1_2 => val_1_3
    | val_1_3,val_1_1,val_1_2 => val_1_3
    | val_1_1,val_1_1,val_1_1 => val_1_3
    | val_1_1,val_1_3,val_1_3 => val_1_2
    | val_1_2,val_1_2,val_1_2 => val_1_1
    | val_1_3,val_1_3,val_1_2 => val_1_3
    | val_1_1,val_1_1,val_1_2 => val_1_3
    | val_1_1,val_1_2,val_1_3 => val_1_2
    | val_1_3,val_1_1,val_1_3 => val_1_3
    | val_1_2,val_1_1,val_1_3 => val_1_2
    | val_1_3,val_1_3,val_1_1 => val_1_3
    | val_1_1,val_1_1,val_1_3 => val_1_2
    | val_1_3,val_1_2,val_1_3 => val_1_2
    | val_1_2,val_1_1,val_1_1 => val_1_2
    | val_1_2,val_1_3,val_1_1 => val_1_3
    | val_1_2,val_1_2,val_1_1 => val_1_3
    | val_1_1,val_1_3,val_1_1 => val_1_2
    | val_1_2,val_1_3,val_1_3 => val_1_2
    | val_1_3,val_1_2,val_1_2 => val_1_3
    | val_1_2,val_1_2,val_1_3 => val_1_3
    | val_1_3,val_1_1,val_1_1 => val_1_2
    | _,_,_ => und_1
    end
  | alice => val_1_2
  | (f5 X1 X2) => 
    match (seval_1 X1),(seval_1 X2) with
      val_1_1,val_1_3 => val_1_2
    | val_1_2,val_1_2 => val_1_1
    | val_1_1,val_1_2 => val_1_1
    | val_1_2,val_1_3 => val_1_2
    | val_1_2,val_1_1 => val_1_2
    | val_1_3,val_1_3 => val_1_2
    | val_1_3,val_1_1 => val_1_2
    | val_1_3,val_1_2 => val_1_2
    | val_1_1,val_1_1 => val_1_2
    | _,_ => und_1
    end
  | prv => val_1_1  end.

Definition seval_1_session_current (v1 v2 v3 : model_1) : model_1 :=
  match v1,v2,v3 with
      val_1_3,val_1_3,val_1_3 => val_1_1
    | val_1_3,val_1_2,val_1_1 => val_1_2
    | val_1_1,val_1_2,val_1_1 => val_1_1
    | val_1_1,val_1_3,val_1_2 => val_1_3
    | val_1_2,val_1_3,val_1_2 => val_1_1
    | val_1_1,val_1_2,val_1_2 => val_1_3
    | val_1_2,val_1_1,val_1_2 => val_1_1
    | val_1_3,val_1_1,val_1_2 => val_1_2
    | val_1_1,val_1_1,val_1_1 => val_1_2
    | val_1_1,val_1_3,val_1_3 => val_1_2
    | val_1_2,val_1_2,val_1_2 => val_1_3
    | val_1_3,val_1_3,val_1_2 => val_1_3
    | val_1_1,val_1_1,val_1_2 => val_1_3
    | val_1_1,val_1_2,val_1_3 => val_1_2
    | val_1_3,val_1_1,val_1_3 => val_1_1
    | val_1_2,val_1_1,val_1_3 => val_1_2
    | val_1_3,val_1_3,val_1_1 => val_1_1
    | val_1_1,val_1_1,val_1_3 => val_1_3
    | val_1_3,val_1_2,val_1_3 => val_1_2
    | val_1_2,val_1_1,val_1_1 => val_1_1
    | val_1_2,val_1_3,val_1_1 => val_1_1
    | val_1_2,val_1_2,val_1_1 => val_1_2
    | val_1_1,val_1_3,val_1_1 => val_1_2
    | val_1_2,val_1_3,val_1_3 => val_1_1
    | val_1_3,val_1_2,val_1_2 => val_1_3
    | val_1_2,val_1_2,val_1_3 => val_1_1
    | val_1_3,val_1_1,val_1_1 => val_1_3
    | _,_,_ => und_1
    end.

Remark seval_1_rewrite_session_current :
       forall u1 u2 u3 : model_1,
       forall v1 v2 v3 : model_1,
       u1=v1 -> u2=v2 -> u3=v3 -> (seval_1_session_current u1 u2 u3)=(seval_1_session_current v1 v2 v3).
Proof.
intros u1 u2 u3 v1 v2 v3 H1 H2 H3.
rewrite H1.
rewrite H2.
rewrite H3.
reflexivity.
Qed.

(*
Remark seval_1_model : forall X:term, ((auto__q3 X) -> (seval_1 X)=val_1_2) /\
  ((auto__q1 X) -> (seval_1 X)=val_1_3) /\
  ((auto__q2 X) -> (seval_1 X)=val_1_1). (* Verify model. *)


Fixpoint seval_1_model_q3 (X:term, p : auto__q3 X) : (seval_1 X)=val_1_2 :=
  match p in auto_q3 X0 return (seval_1 X0)=val_1_2 with
    (trans__q3_session_current_1 X1 X2 X3 H1 H2 H3) =>
(*     trans__q3_session_current_1 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q3 (session_current X1 X2 X3)
*)
	let Y = (session_current X1 X2 X3) in
	let R0 = refl_equal model_1 : (seval_1 Y)=(seval_1_session_current (seval_1 X1) (seval_1 X2) (seval_1 X3)) in
	let R1 = (eq_ind (seval_1 X1) (fun Z => (seval_1 Y)=(seval_1_session_current Z (seval_1 X2) (seval_1 X3))) R0 val_1_1 (seval_1_model_q2 X1 H1)) in
	let R2 = (eq_ind (seval_1 X2) (fun Z => (seval_1 Y)=(seval_1_session_current val_1_1 Z (seval_1 X3))) R1 val_1_2 (seval_1_model_q3 X2 H2)) in
	let R3 = (eq_ind (seval_1 X3) (fun Z => (seval_1 Y)=(seval_1_session_current val_1_1 val_1_2 Z)) R2 val_1_3 (seval_1_model_q1 X3 H3)) in
	R3

    (* H1 : auto__q2 X1 *)
    (* (seval_1_model_q2 X1 H1) : (seval_1 X1)=val_1_1 *)
    (eq_ind (seval_1 X1) (fun Z => (seval_1 (session_current X1 X2 X3))=(seval_1_session_current Z (seval_1 X2) (seval_1 X3))) R0 val_1_1 (seval_1_model_q2 H1))

(*Functional Scheme seval_1_ind := Induction for seval_1.*)

Axiom seval_1_model_1 : forall X:term, forall p : auto__q1 X, (seval_1 X)=val_1_3.
Axiom seval_1_model_2 : forall X:term, forall p : auto__q2 X, (seval_1 X)=val_1_1.

Definition seval_1_model_3 : forall X:term, forall p : auto__q3 X, (seval_1 X)=val_1_2.

Remark seval_1_model : forall X:term, ((auto__q3 X) -> (seval_1 X)=val_1_2) /\
  ((auto__q1 X) -> (seval_1 X)=val_1_3) /\
  ((auto__q2 X) -> (seval_1 X)=val_1_1). (* Verify model. *)
Proof.
  induction X using seval_1_ind.

*)
				   (*
1.2.14  Recursive functions

The expression “fix ident1 binder1 : type1 := term1 with … with identn bindern : typen := termn for identi” denotes the ithcomponent of a block of functions defined by mutual well-founded recursion. It is the local counterpart of the Fixpoint command. See Section 1.3.4 for more details. When n=1, the “for identi” clause is omitted.
*)
