(* Coq printing functions for clauses, headers.
   Copyright (C) 2003, 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.

   This file is part of h1.

   h1 is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   h1 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with h1; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*)

open "clause_h";

extern val coq_clause_var_names : string -> clause -> (int -m> string);
	   (* return set of variables free in clause, together
	    with their names.  Name of variable i is prefix followed
	    by 'i', where prefix is first argument. *)

extern val coq_print_clause : (string * 'a outstream *
			       string * string * string * string) ->
	   clause -> unit;
(* coq_print_clause (coq_version, f, bot_prefix, prefix, term_type, xname) c
 prints clause c on file f; the type of terms is term_type,
 and all needed variables will be of name xname, possibly with
 a number suffix.
 prefix is a prefix added in front of each predicate name.
 bot_prefix is added in front of each botname.
 *)

extern val coq_print_clause_def : (string * 'a outstream *
				   string * string * string * string) ->
	   clause list -> unit;
(* same format; prints list of clauses as big mutually inductive
 inductive predicates.
 *)
