(* Coq printing functions for general clauses, headers.
   Copyright (C) 2003, 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.

   This file is part of h1.

   h1 is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   h1 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with h1; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*)

open "gclause_h";

extern val coq_print_gvars :
	   (string * 'a outstream * (''var -> string)
	    * (''var set -> ''var list) * string)
	   -> ''var set -> unit;
(*
 coq_print_gvars (coq_version, f, varname, varsort, term_type) vars
 prints the quantifications over the variables in vars.
 Uses varname x to get the real name of variable x;
 varsort sorts a set of variables.
 *)

extern val coq_print_gclause_vars :
	   (string * 'a outstream * (''var -> string)
	    * (''var set -> ''var list) * string)
	   -> ''var gclause -> unit;
(*
 coq_print_gclause_vars (coq_version, f, varname, varsort, term_type) c
 prints the quantifications over the free variables of c.
 Uses varname x to get the real name of variable x;
 varsort sorts a set of variables.
 *)

extern val coq_print_gclause_neg : (string * 'a outstream * string * string *
				    (''var -> string) * string)
	   -> ''var gclause -> unit;
(*
 coq_print_gclause_neg (coq_version, f,
                        fun_prefix, state_prefix, varname, term_type) c
 prints 'A1 -> ... -> An ->' where gclause c has A1, ..., An
 as negative atoms;
 each predicate is prefixed with state_prefix;
 each function is prefixed with fun_prefix;
 varname is used to give a printable name to each ''var;
 term_type is the type of terms.
 *)

extern val coq_print_gclause_pos : (string * 'a outstream * string * string *
				    (''var -> string) * string)
	   -> ''var gclause -> unit;
(*
 coq_print_gclause_pos (coq_version, f,
                        fun_prefix, state_prefix, varname, term_type) c
 prints the positive literals in c, separated by '\/';
 each predicate is prefixed with state_prefix;
 each function is prefixed with fun_prefix;
 varname is used to give a printable name to each ''var;
 term_type is the type of terms.
 *)

extern val coq_print_gclause_lits : (string * 'a outstream * string * string *
				     (''var -> string) * string)
	   -> ''var gclause -> unit;
(*
 coq_print_gclause_lits (coq_version, f,
                         fun_prefix, state_prefix, varname, term_type) c
 prints gclause c without the quantifications on variables on file f;
 each predicate is prefixed with state_prefix;
 each function is prefixed with fun_prefix;
 varname is used to give a printable name to each ''var;
 term_type is the type of terms.
 *)

extern val coq_print_gclause : (string * 'a outstream * string * string *
				(''var -> string) * (''var set -> ''var list)
				* string)
	   -> ''var gclause -> unit;
(*
 coq_print_gclause (coq_version, f,
                    fun_prefix, state_prefix, varname, varsort, term_type) c
 prints gclause c on file f;
 each predicate is prefixed with state_prefix;
 each function is prefixed with fun_prefix;
 varname is used to give a printable name to each ''var;
 varsort sorts variables in ascending order;
 term_type is the type of terms.
 *)
