/* A Bison parser, made by GNU Bison 2.3.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C

   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.3"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     identifier = 258,
     kw_open_paren = 259,
     kw_close_paren = 260,
     kw_provided = 261,
     kw_comma = 262,
     kw_semicolon = 263,
     kw_period = 264,
     kw_question_mark = 265,
     kw_subst = 266,
     kw_open_source = 267,
     kw_close_source = 268,
     kw_open_clause = 269,
     kw_close_clause = 270,
     kw_end_tag = 271,
     kw_open_definitions = 272,
     kw_close_definitions = 273,
     kw_open_approximation = 274,
     kw_close_approximation = 275,
     kw_open_justifications = 276,
     kw_close_justifications = 277,
     VAR = 278,
     kw_ne = 279,
     kw_false = 280,
     string_constant = 281,
     kw_axiom = 282,
     kw_open_rule = 283,
     kw_clause_def = 284,
     kw_clause_use = 285,
     kw_close_rule = 286
   };
#endif
/* Tokens.  */
#define identifier 258
#define kw_open_paren 259
#define kw_close_paren 260
#define kw_provided 261
#define kw_comma 262
#define kw_semicolon 263
#define kw_period 264
#define kw_question_mark 265
#define kw_subst 266
#define kw_open_source 267
#define kw_close_source 268
#define kw_open_clause 269
#define kw_close_clause 270
#define kw_end_tag 271
#define kw_open_definitions 272
#define kw_close_definitions 273
#define kw_open_approximation 274
#define kw_close_approximation 275
#define kw_open_justifications 276
#define kw_close_justifications 277
#define VAR 278
#define kw_ne 279
#define kw_false 280
#define string_constant 281
#define kw_axiom 282
#define kw_open_rule 283
#define kw_clause_def 284
#define kw_clause_use 285
#define kw_close_rule 286




/* Copy the first part of user declarations.  */
#line 21 "cproof.y"

#include <stdlib.h>
#include <stddef.h>
#include <stdio.h>
#include <string.h>
#ifdef HAVE_LIBZ
#include <zlib.h>
  typedef gzFile fp;
#else
  typedef FILE *fp;
#endif
#include "cproof.tab.h"
extern int yylex (void);

#ifdef HAVE_LIBZ
  extern fp yygzin;
#define YYIN yygzin
#else
  extern FILE *yyin;
#define YYIN yyin
#endif
  extern FILE *yyout;
  extern char *yytext;
  extern int yyleng;

  void *xmalloc (size_t n)
    {
      void *p = malloc (n);

      if (p==NULL)
	{
	  fprintf (stderr, "No more memory allocating %ld bytes.\n", n);
	  fflush (stderr);
	  exit (10);
	}
      return p;
    }

#define CHUNK_SIZE 8192
  char *endPtr = NULL;
  char *curPtr = NULL;

  void *small_alloc (size_t n)
    {
#define SMALL_CHUNK 4
      /* should be a multiple of 4, so that pointers to such blocks have
	 two free low bits. */
      size_t m = ((n+SMALL_CHUNK-1)/SMALL_CHUNK)*SMALL_CHUNK;
      char *p;

      if (curPtr==NULL || curPtr+m>endPtr)
	{
	  p = xmalloc (CHUNK_SIZE);
	  endPtr = p+CHUNK_SIZE;
	  if (((long int)p) & 1)
	    p++;
	  if (((long int)p) & 2)
	    p += 2;
	  /* round p to a multiple of 4 */
	  curPtr = p;
 	}
      p = curPtr;
      curPtr = p+m;
      return (void *)p;
    }

  char bsd_cursors[] = { '-', '\\', '|', '/' };

  struct bsd_cursor {
    int time;
  };

#define BSD_CURSOR(name) struct bsd_cursor name = { -1, }

  void bump_bsd_cursor (struct bsd_cursor *cur)
    {
      if (cur->time<0)
	;
      else fputc (8, stderr);
      if (++cur->time==4)
	cur->time = 0;
      fputc (bsd_cursors [cur->time], stderr);
      fflush (stderr);
    }

  int verbose = 0;
  long nClauses = 0;
#define CLAUSE_STEP 1000
  long nClausesMod = 0;

  long nDeds = 0;

#define yyerror(msg) yy_error (msg)

  void yy_error (/*int l1, int c1, int l2, int c2,*/
		 char *msg)
    {
      fputs (msg, stderr);
      if (yytext[0]!=0)
	{
	  fputs (" (at '", stderr);
	  fputs (yytext, stderr);
	  fputs ("')", stderr);
	}
      fputc ('\n', stderr);
      fflush (stderr);
    }

#define PHASE_SKIP_INTRO 0
#define PHASE_GET_DEPS 1
#define PHASE_COPY_INTRO 2
#define PHASE_OUT_REACHABLE 3

  int phase = PHASE_SKIP_INTRO;
  int out_prems = 0;

#define BUFFER_SIZE 256

  struct buffer {
    size_t size;
    size_t len;
    char s[BUFFER_SIZE];
  };

  struct buffer *new_buf (void)
    {
      struct buffer *b = xmalloc (sizeof(struct buffer));

      b->size = BUFFER_SIZE;
      b->len = 0;
      return b;
    }

  void bput (struct buffer **bp, char *s, int n)
    {
      switch (phase)
	{
	case PHASE_SKIP_INTRO: break;
	case PHASE_GET_DEPS: break;
	case PHASE_COPY_INTRO:
	  fputs (s, yyout);
	  break;
	default:
	  {
	    struct buffer *b = *bp;
	    int newlen = b->len + n;

	    if (newlen>=b->size)
	      {
		size_t newsize = newlen + BUFFER_SIZE;
		struct buffer *newb = xmalloc (offsetof(struct buffer, s[newsize]));
		
		newb->size = newsize;
		newb->len = newlen;
		memcpy (newb->s, b->s, b->len);
		strcpy (newb->s+b->len, s);
		*bp = newb;
		free (b);
	      }
	    else
	      {
		strcpy (b->s+b->len, s);
		b->len = newlen;
	      }
	    break;
	  }
	}
    }

  struct buffer **theBufp = NULL;

  struct header {
    unsigned long bits;
#define H_CONS 0
#define H_STRING 1
#define KIND(h) ((h).bits & 1)
#define SETKIND(h,k) { if (k) (h).bits |= 1; else (h).bits &= ~1; }
#define MARK(h) ((h).bits & 2)
#define SETMARK(h,k) { if (k) (h).bits |= 2; else (h).bits &= ~2; }
#define N(h) (((h).bits & ~3) >> 2)
#define SETN(h,i) (h).bits = ((i) << 2) | ((h).bits & 3)
  };

  struct cinfo {
    struct header h;
    struct cinfo *next;
    struct cons *conc;
    struct cons *prem[1];
  };

  struct cons {
    struct header h;
    struct cons *next;
    /*struct header *car;*/
#define CAR(c) (struct header *)((c)->h.bits & ~3)
#define SETCAR(c,hdr) (c)->h.bits = ((long int)hdr) | ((c)->h.bits & 3)
    struct cons *cdr;
  };

  struct cons *nil;

  struct string {
    struct header h;
    struct string *next;
    char s[1];
  };

  struct ilist {
    struct ilist *next;
    struct cons *i;
  };

  struct ilist *thePremList = NULL;
  struct ilist *theTargets = NULL;

  struct ilist *icons (struct cons *i, struct ilist *next)
    {
      struct ilist *il;

      if (thePremList==NULL)
	{
	  struct ilist* il = xmalloc (sizeof(struct ilist));

	  il->next = NULL;
	  thePremList = il;
	}
      il = thePremList;
      thePremList = il->next;
      il->next = next;
      il->i = i;
      return il;
    }

  unsigned int ilen (struct ilist *il)
    {
      unsigned int n;

      for (n=0; il!=NULL; n++, il=il->next);
      return n;
    }

  void ifree (struct ilist *il)
    {
      struct ilist *next, *il0=il;

      if (il==NULL)
	return;
      while ((next = il->next)!=NULL)
	il = next;
      il->next = thePremList;
      thePremList = il0;
    }

#define NLOWBITS 2

  unsigned long pgcd (unsigned long i, unsigned long j)
    {
      unsigned long k, r;

      if (i<j)
	{
	  k = i;
	  i = j;
	  j = k;
	}
      while (j!=0)
	{
	  r = i % j;
	  i = j;
	  j = r;
	}
      return i;
    }

  unsigned long nCons = 0L;
  unsigned long cons_hash_size = 42043;
#define cons_hashcode1(car,cdr,siz) \
	((((unsigned long)car) + ((unsigned long)cdr)) >> NLOWBITS) % (siz)
#define cons_hashcode(car,cdr) cons_hashcode1(car,cdr,cons_hash_size)
  struct cons **consTable = NULL;

  int expandConsTable (unsigned long size)
    {
      struct cons **newConsTable;
      struct cons **src_ap, **app, *ap;
      unsigned long h1, j, h2;
      unsigned long d, p2;
      struct cons ***epp;

      d = pgcd (size, cons_hash_size);
      p2 = size/d;
      epp = (struct cons ***)xmalloc (p2 * sizeof (struct cons **));
      newConsTable = (struct cons **)malloc (size*sizeof(struct cons *));
      if (newConsTable==NULL)
	{
	  free (epp);
	  return 0;
	}
      for (h1=0, src_ap = consTable; h1<cons_hash_size; h1++, src_ap++)
	{
	  for (j=0, h2=h1; j<p2; j++)
	    {
	      epp [j] = &newConsTable[h2];
	      h2 += d;
	      if (h2>size)
		h2 -= size;
	    }
	  for (ap = *src_ap; ap!=NULL; ap=ap->next)
	    {
	      h2 = cons_hashcode1(CAR(ap),ap->cdr,size);
	      if (h2<h1)
		j = (h2-h1)/d + p2;
	      else j = (h2-h1)/d;
	      *epp [j] = ap;
	      epp [j] = &ap->next;
	    }
	  for (j=0; j<p2; j++)
	    *epp[j] = NULL;
	}
      free (consTable);
      consTable = newConsTable;
      cons_hash_size = size;
      free (epp);
      return 1;
    }

#define CONS_N 1024

  struct conschunk {
    struct cons m[CONS_N];
  };

  struct cons *newcons (void)
    {
      return (struct cons *)small_alloc (sizeof(struct cons));
    }

  struct cons *kons (struct header *car, struct cons *cdr)
    {
      struct cons **epp0;

      if (nCons>2*cons_hash_size)
	expandConsTable (2*cons_hash_size);
      epp0 = &consTable[cons_hashcode(car,cdr)];
      {
	struct cons *ep;

	for (ep = *epp0; ep!=NULL; ep = ep->next)
	  {
	    if (cdr==ep->cdr && car==CAR(ep))
	      return ep;
	  }
      }
      nCons++;
      {
	struct cons *ep = newcons ();

	ep->h.bits = H_CONS;
	/*
	ep->h.kind = H_CONS;
	ep->h.mark = 0;
	ep->h.n = 0;
	*/
	ep->next = *epp0;
	SETCAR(ep, car);
	ep->cdr = cdr;
	*epp0 = ep;
	return ep;
      }
    }

  unsigned long nStrings = 0L;
  unsigned long string_hash_size = 883;

  unsigned long string_hashcode1(char *s, unsigned long siz)
    {
      unsigned long i = 0;
      unsigned long c;

      while ((c = (unsigned long)(unsigned char)*s++))
	{
	  i = 71 * i + c + 13;
	}
      return i % siz;
    }
#define string_hashcode(s) string_hashcode1(s,string_hash_size)
  struct string **stringTable = NULL;

  int expandStringTable (unsigned long size)
    {
      struct string **newStringTable;
      struct string **src_ap, **app, *ap;
      unsigned long h1, j, h2;
      unsigned long d, p2;
      struct string ***epp;

      d = pgcd (size, string_hash_size);
      p2 = size/d;
      epp = (struct string ***)xmalloc (p2 * sizeof (struct string **));
      newStringTable = (struct string **)malloc (size*sizeof(struct string *));
      if (newStringTable==NULL)
	{
	  free (epp);
	  return 0;
	}
      for (h1=0, src_ap = stringTable; h1<string_hash_size; h1++, src_ap++)
	{
	  for (j=0, h2=h1; j<p2; j++)
	    {
	      epp [j] = &newStringTable[h2];
	      h2 += d;
	      if (h2>size)
		h2 -= size;
	    }
	  for (ap = *src_ap; ap!=NULL; ap=ap->next)
	    {
	      h2 = string_hashcode1(ap->s,size);
	      if (h2<h1)
		j = (h2-h1)/d + p2;
	      else j = (h2-h1)/d;
	      *epp [j] = ap;
	      epp [j] = &ap->next;
	    }
	  for (j=0; j<p2; j++)
	    *epp[j] = NULL;
	}
      free (stringTable);
      stringTable = newStringTable;
      string_hash_size = size;
      free (epp);
      return 1;
    }

  struct string *kstring (char *s)
    {
      struct string **epp0;

      if (nStrings>string_hash_size)
	expandStringTable (2*string_hash_size);
      epp0 = &stringTable[string_hashcode(s)];
      {
	struct string *ep;

	for (ep = *epp0; ep!=NULL; ep = ep->next)
	  {
	    if (strcmp (s, ep->s)==0)
	      return ep;
	  }
      }
      nStrings++;
      {
	struct string *ep = xmalloc (offsetof (struct string, s[strlen(s)+1]));

	ep->h.bits = H_STRING;
	/*
	ep->h.kind = H_STRING;
	ep->h.mark = 0;
	ep->h.n = 0;
	*/
	ep->next = *epp0;
	strcpy (ep->s, s);
	*epp0 = ep;
	return ep;
      }
    }

  unsigned long nCinfos = 0L;
  unsigned long cinfo_hash_size = 15581;
#define cinfo_hashcode1(conc,siz) (((unsigned long)conc) >> NLOWBITS) % (siz)
#define cinfo_hashcode(conc) cinfo_hashcode1(conc,cinfo_hash_size)
  struct cinfo **cinfoTable = NULL;;

  int expandCinfoTable (unsigned long size)
    {
      struct cinfo **newCinfoTable;
      struct cinfo **src_ap, **app, *ap;
      unsigned long h1, j, h2;
      unsigned long d, p2;
      struct cinfo ***epp;

      d = pgcd (size, cinfo_hash_size);
      p2 = size/d;
      epp = (struct cinfo ***)xmalloc (p2 * sizeof (struct cinfo **));
      newCinfoTable = (struct cinfo **)malloc (size*sizeof(struct cinfo *));
      if (newCinfoTable==NULL)
	{
	  free (epp);
	  return 0;
	}
      for (h1=0, src_ap = cinfoTable; h1<cinfo_hash_size; h1++, src_ap++)
	{
	  for (j=0, h2=h1; j<p2; j++)
	    {
	      epp [j] = &newCinfoTable[h2];
	      h2 += d;
	      if (h2>size)
		h2 -= size;
	    }
	  for (ap = *src_ap; ap!=NULL; ap=ap->next)
	    {
	      h2 = cinfo_hashcode1(ap->conc,size);
	      if (h2<h1)
		j = (h2-h1)/d + p2;
	      else j = (h2-h1)/d;
	      *epp [j] = ap;
	      epp [j] = &ap->next;
	    }
	  for (j=0; j<p2; j++)
	    *epp[j] = NULL;
	}
      free (cinfoTable);
      cinfoTable = newCinfoTable;
      cinfo_hash_size = size;
      free (epp);
      return 1;
    }

  BSD_CURSOR(clauseCursor);

  void new_clause (void)
    {
      nClauses++;
      if (verbose>=2 && ++nClausesMod==CLAUSE_STEP)
	{
	  nClausesMod = 0;
	  bump_bsd_cursor (&clauseCursor);
	}
    }

  struct cinfo *getkinfo (struct cons *conc)
    {
      struct cinfo *ep = cinfoTable[cinfo_hashcode(conc)];

      for (; ep!=NULL; ep = ep->next)
	{
	  if (conc==ep->conc)
	    return ep;
	}
      return NULL;
    }

  struct cinfo *kinfo (struct cons *conc, struct ilist *il)
    {
      struct cinfo **epp0;

      if (nCinfos>32*cinfo_hash_size)
	expandCinfoTable (2*cinfo_hash_size);
      epp0 = &cinfoTable[cinfo_hashcode(conc)];
      {
	struct cinfo *ep;

	for (ep = *epp0; ep!=NULL; ep = ep->next)
	  {
	    if (conc==ep->conc)
	      return ep;
	  }
      }
      nCinfos++;
      new_clause ();
      {
	unsigned int n = ilen (il);
	struct cinfo *ep = small_alloc (offsetof (struct cinfo, prem[n]));
	struct cons **ip;

	ep->h.bits = 0;
	SETN(ep->h,n);
	/*
	ep->h.kind = 0;
	ep->h.mark = 0;
	ep->h.n = n;
	*/
	ep->next = *epp0;
	ep->conc = conc;
	for (ip=ep->prem; il!=NULL; il=il->next)
	  *ip++ = il->i;
	*epp0 = ep;
	return ep;
      }
    }

#define TARGET_FALSE (0x1)
#define TARGET_Q (0x2)
#define TARGET_AUTO (0x10)
  int target_flags = TARGET_FALSE;

  int target_p (struct cons *clause)
    {
      /* By default, target is "false".
	 That is, either a clause of the form '?.' or
	 one of the form '#false([^()]*).'. */
      struct cons *head = (struct cons *)CAR(clause);

      if (target_flags & TARGET_FALSE)
	{
	  if (head==nil)
	    return 1;
	  if (KIND(head->h)==H_STRING && memcmp (((struct string *)head)->s, "#false", 6)==0
	      && clause->cdr==nil)
	    return 1;
	}
      if (target_flags & TARGET_Q)
	{
	  if (head==nil)
	    ;
	  else if (KIND(head->h)==H_STRING && memcmp (((struct string *)head)->s, "#ne", 3)==0
		   && clause->cdr==nil)
	    return 1;
	}
      if (target_flags & TARGET_AUTO)
	{
	  if (head==nil)
	    ;
	  else if (KIND(head->h)==H_STRING)
	    {
	      if (clause->cdr==nil)
		return 1;
	    }
	  else if (KIND(head->h)==H_CONS && head->cdr!=nil)
	    { /* head is P (...) */
	      struct cons *xl = NULL;

	      if (head->cdr->cdr==nil)
		{ /* head is P (t) */
		  struct cons *t = (struct cons *)CAR(head->cdr);

		  if (KIND(t->h)==H_STRING) /* head is P (X) */
		    {
		      if (clause->cdr==nil)
			return 1; /* universal clauses P(X). are marked */
		    }
		  else if (KIND(*CAR(t))==H_STRING) /* head is P (f (t1, ..., tn)), t=f(t1,...,tn) */
		    xl = t->cdr;
		}
	      else xl = head->cdr; /* head is P (t1, ..., tn). */
	      if (xl!=NULL)
		{
		  struct cons *ll;

		  for (ll=xl; ll!=nil; ll=ll->cdr)
		    {
		      struct string *x = (struct string *)CAR(ll);

		      if (KIND(x->h)!=H_STRING || MARK(x->h))
			break; /* fail if some ti is not a variable, or is a duplicate variable. */
		      else SETMARK(x->h,1); /* mark the variables free in the head. */
		    }
		  if (ll==nil) /* every ti is a variable. */
		    {
		      struct cons *body;

		      for (body = clause->cdr; body!=nil; body=body->cdr)
			{
			  struct cons *a = (struct cons *)CAR(body);
			  struct header *arg;

			  if (KIND(a->h)!=H_CONS)
			    break;
			  a = a->cdr;
			  if (KIND(a->h)!=H_CONS)
			    break;
			  if (a->cdr!=nil)
			    break;
			  /* here a=Q(arg) */
			  arg = CAR(a);
			  if (KIND(*arg)!=H_STRING)
			    break;
			  /* here a=Q(arg), where arg is a variable X. */
			  if (!MARK(*arg))
			    break;
			  /* here a=Q(X) with X free in the head, so great. */
			}
		      for (ll=xl; ll!=nil; ll=ll->cdr)
			{
			  struct string *x = (struct string *)CAR(ll);

			  if (KIND(x->h)==H_STRING)
			    SETMARK(x->h, 0); /* unmark the variables free in the head. */
			}
		      if (body==nil)
			return 1; /* OK, this is an automaton clause. */
		    }
		  else for (ll=xl; ll!=nil; ll=ll->cdr)
		    {
		      struct string *x = (struct string *)CAR(ll);

		      if (KIND(x->h)==H_STRING)
			SETMARK(x->h, 0); /* unmark the variables free in the head. */
		    }
		}
	    }
	}
      return 0;
    }
  

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif

#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
#line 716 "cproof.y"
{
  struct cons *c;
  struct string *s;
  struct cinfo *ci;
  struct header *h;
  struct ilist *il;
}
/* Line 193 of yacc.c.  */
#line 861 "cproof.tab.c"
	YYSTYPE;
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 216 of yacc.c.  */
#line 874 "cproof.tab.c"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int i)
#else
static int
YYID (i)
    int i;
#endif
{
  return i;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  5
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   79

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  32
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  53
/* YYNRULES -- Number of rules.  */
#define YYNRULES  71
/* YYNRULES -- Number of states.  */
#define YYNSTATES  100

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   286

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint8 yyprhs[] =
{
       0,     0,     3,     9,    13,    17,    21,    25,    27,    28,
      31,    37,    38,    41,    44,    49,    51,    54,    57,    59,
      60,    62,    63,    66,    68,    72,    77,    80,    82,    86,
      88,    90,    91,    93,    95,    99,   104,   105,   109,   111,
     113,   115,   119,   121,   123,   128,   130,   132,   134,   136,
     138,   140,   142,   144,   146,   148,   150,   152,   154,   156,
     158,   160,   162,   164,   166,   168,   170,   172,   174,   176,
     178,   180
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int8 yyrhs[] =
{
      33,     0,    -1,    34,    35,    36,    37,    38,    -1,    77,
      39,    78,    -1,    79,    47,    80,    -1,    81,    47,    82,
      -1,    83,    41,    84,    -1,    41,    -1,    -1,    39,    40,
      -1,    73,    76,    75,    48,    74,    -1,    -1,    41,    42,
      -1,    45,    70,    -1,    45,    71,    43,    72,    -1,    44,
      -1,    43,    44,    -1,    45,    46,    -1,    48,    -1,    -1,
      11,    -1,    -1,    47,    48,    -1,    49,    -1,    69,    52,
      67,    -1,    50,    68,    52,    67,    -1,    50,    67,    -1,
      51,    -1,    50,    66,    51,    -1,    54,    -1,    62,    -1,
      -1,    53,    -1,    54,    -1,    53,    65,    54,    -1,    59,
      63,    56,    64,    -1,    -1,    59,    55,    57,    -1,    59,
      -1,    61,    -1,    57,    -1,    56,    65,    57,    -1,    60,
      -1,    58,    -1,    59,    63,    56,    64,    -1,    59,    -1,
       3,    -1,    23,    -1,    24,    -1,    25,    -1,     4,    -1,
       5,    -1,     7,    -1,     8,    -1,     9,    -1,     6,    -1,
      10,    -1,    27,    -1,    28,    -1,    31,    -1,    14,    -1,
      15,    -1,    16,    -1,    26,    -1,    12,    -1,    13,    -1,
      17,    -1,    18,    -1,    19,    -1,    20,    -1,    21,    -1,
      22,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   745,   745,   754,   757,   760,   763,   766,   769,   770,
     773,   776,   777,   780,   809,   843,   844,   847,   857,   871,
     872,   876,   877,   885,   892,   893,   894,   899,   900,   905,
     906,   911,   912,   917,   918,   921,   929,   929,   935,   936,
     941,   942,   945,   946,   949,   951,   954,   957,   960,   963,
     966,   969,   972,   976,   979,   982,   985,   988,   991,   997,
    1002,  1005,  1008,  1011,  1014,  1017,  1020,  1023,  1026,  1029,
    1032,  1035
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "identifier", "kw_open_paren",
  "kw_close_paren", "kw_provided", "kw_comma", "kw_semicolon", "kw_period",
  "kw_question_mark", "kw_subst", "kw_open_source", "kw_close_source",
  "kw_open_clause", "kw_close_clause", "kw_end_tag", "kw_open_definitions",
  "kw_close_definitions", "kw_open_approximation",
  "kw_close_approximation", "kw_open_justifications",
  "kw_close_justifications", "VAR", "kw_ne", "kw_false", "string_constant",
  "kw_axiom", "kw_open_rule", "kw_clause_def", "kw_clause_use",
  "kw_close_rule", "$accept", "problem", "source", "definitions",
  "approximation", "justifications", "deductions", "named_clause_list",
  "named_clause", "deduction_list", "deduction", "premise_list", "premise",
  "processed_clause", "substitution", "clause_list", "clause",
  "raw_clause", "head", "atomhead", "clause_body", "non_empty_clause_body",
  "atom", "@1", "term_list", "term", "application", "id", "var", "ne",
  "false", "open_paren", "close_paren", "comma", "semicolon", "period",
  "provided", "question_mark", "axiom", "open_rule", "close_rule",
  "open_clause", "close_clause", "end_tag", "string", "open_source",
  "close_source", "open_definitions", "close_definitions",
  "open_approximation", "close_approximation", "open_justifications",
  "close_justifications", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    32,    33,    34,    35,    36,    37,    38,    39,    39,
      40,    41,    41,    42,    42,    43,    43,    44,    45,    46,
      46,    47,    47,    48,    49,    49,    49,    50,    50,    51,
      51,    52,    52,    53,    53,    54,    55,    54,    54,    54,
      56,    56,    57,    57,    58,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     5,     3,     3,     3,     3,     1,     0,     2,
       5,     0,     2,     2,     4,     1,     2,     2,     1,     0,
       1,     0,     2,     1,     3,     4,     2,     1,     3,     1,
       1,     0,     1,     1,     3,     4,     0,     3,     1,     1,
       1,     3,     1,     1,     4,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       0,    64,     0,     0,     8,     1,    66,     0,    21,     0,
      68,     0,    21,     0,    65,    60,     9,     0,     3,    70,
      11,    11,     0,    46,    56,    67,    48,    49,    22,    23,
       0,    27,    29,    38,    39,    30,    31,     4,    63,     0,
       2,     7,     0,    69,     5,    55,    53,    54,     0,    26,
      31,    50,     0,     0,     0,    32,    33,    62,     0,    12,
       0,    18,    71,     6,    28,     0,    47,    37,    43,    45,
      42,     0,    40,    24,    52,     0,     0,    57,    58,    13,
       0,    25,     0,    51,    35,     0,    34,    61,    10,     0,
      15,    19,     0,    41,    59,    16,    14,    20,    17,    44
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int8 yydefgoto[] =
{
      -1,     2,     3,     7,    11,    20,    40,     9,    16,    41,
      59,    89,    90,    60,    98,    13,    61,    29,    30,    31,
      54,    55,    32,    52,    71,    72,    68,    33,    70,    34,
      35,    53,    84,    85,    48,    49,    50,    36,    79,    80,
      96,    17,    88,    58,    39,     4,    18,     8,    37,    12,
      44,    21,    63
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -70
static const yytype_int8 yypact[] =
{
      -6,   -70,    13,     6,   -70,   -70,   -70,    23,   -70,    47,
     -70,     0,   -70,     4,   -70,   -70,   -70,    26,   -70,   -70,
     -70,   -70,    14,   -70,   -70,   -70,   -70,   -70,   -70,   -70,
      45,   -70,   -70,    46,   -70,   -70,     7,   -70,   -70,    40,
     -70,    38,    33,   -70,   -70,   -70,   -70,   -70,    22,   -70,
       7,   -70,    41,    41,    21,    52,   -70,   -70,    38,   -70,
      39,   -70,   -70,   -70,   -70,    21,   -70,   -70,   -70,    61,
     -70,    11,   -70,   -70,   -70,     7,    53,   -70,   -70,   -70,
      38,   -70,    41,   -70,   -70,    41,   -70,   -70,   -70,     2,
     -70,    59,    11,   -70,   -70,   -70,   -70,   -70,   -70,   -70
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
     -70,   -70,   -70,   -70,   -70,   -70,   -70,   -70,   -70,    50,
     -70,   -70,   -17,   -69,   -70,    62,   -13,   -70,   -70,    25,
      27,   -70,   -35,   -70,    -7,   -48,   -70,   -50,   -70,   -70,
     -70,     9,   -16,    24,   -70,   -46,   -70,   -70,   -70,   -70,
     -70,   -70,   -70,   -70,   -70,   -70,   -70,   -70,   -70,   -70,
     -70,   -70,   -70
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -37
static const yytype_int8 yytable[] =
{
      28,    56,    69,    69,    67,    23,     1,    23,    73,    28,
      23,    91,    24,     5,    24,    56,    83,    23,    74,    81,
      91,    19,    25,     6,    24,    23,    26,    27,    26,    27,
      47,    26,    69,    94,    43,    69,    23,    93,    26,    27,
      86,    23,    10,    24,    23,    76,    26,    27,    24,   -36,
      51,    45,    38,    46,    47,    62,    57,    26,    27,    74,
      14,    15,    26,    27,    66,    51,    77,    78,    87,   -36,
      97,    42,    95,    64,    22,    92,    99,    65,    82,    75
};

static const yytype_uint8 yycheck[] =
{
      13,    36,    52,    53,    52,     3,    12,     3,    54,    22,
       3,    80,    10,     0,    10,    50,     5,     3,     7,    65,
      89,    21,    18,    17,    10,     3,    24,    25,    24,    25,
       9,    24,    82,    31,    20,    85,     3,    85,    24,    25,
      75,     3,    19,    10,     3,    58,    24,    25,    10,     3,
       4,     6,    26,     8,     9,    22,    16,    24,    25,     7,
      13,    14,    24,    25,    23,     4,    27,    28,    15,    23,
      11,    21,    89,    48,    12,    82,    92,    50,    69,    55
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,    12,    33,    34,    77,     0,    17,    35,    79,    39,
      19,    36,    81,    47,    13,    14,    40,    73,    78,    21,
      37,    83,    47,     3,    10,    18,    24,    25,    48,    49,
      50,    51,    54,    59,    61,    62,    69,    80,    26,    76,
      38,    41,    41,    20,    82,     6,     8,     9,    66,    67,
      68,     4,    55,    63,    52,    53,    54,    16,    75,    42,
      45,    48,    22,    84,    51,    52,    23,    57,    58,    59,
      60,    56,    57,    67,     7,    65,    48,    27,    28,    70,
      71,    67,    63,     5,    64,    65,    54,    15,    74,    43,
      44,    45,    56,    57,    31,    44,    72,    11,    46,    64
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *bottom, yytype_int16 *top)
#else
static void
yy_stack_print (bottom, top)
    yytype_int16 *bottom;
    yytype_int16 *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule)
#else
static void
yy_reduce_print (yyvsp, yyrule)
    YYSTYPE *yyvsp;
    int yyrule;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      fprintf (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       );
      fprintf (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  YYUSE (yyvaluep);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
	break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  int yystate;
  int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;
#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  yytype_int16 yyssa[YYINITDEPTH];
  yytype_int16 *yyss = yyssa;
  yytype_int16 *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  YYSTYPE *yyvsp;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     look-ahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to look-ahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 746 "cproof.y"
    { switch (phase)
  {
  case PHASE_GET_DEPS: phase = PHASE_COPY_INTRO; break;
  case PHASE_OUT_REACHABLE: phase = PHASE_SKIP_INTRO; break;
  }
;}
    break;

  case 13:
#line 780 "cproof.y"
    {
  switch (phase)
    {
    case PHASE_GET_DEPS:
      {
	(void) kinfo ((yyvsp[(1) - (2)].c), NULL);
	if (target_p ((yyvsp[(1) - (2)].c)))
	  {
	    theTargets = icons ((yyvsp[(1) - (2)].c), theTargets);
	  }
	nDeds++;
	break;
      }
    case PHASE_OUT_REACHABLE:
      {
	struct cinfo *ci = getkinfo ((yyvsp[(1) - (2)].c));

	if (ci!=NULL && MARK(ci->h))
	  {
	    fputs ((*theBufp)->s, yyout);
	    SETMARK(ci->h, 0); /* we are happy with the first deduction of the clause,
				  and won't output any other. */
	  }
	new_clause ();
      }
      break;
    }
  (*theBufp)->len = 0;
;}
    break;

  case 14:
#line 809 "cproof.y"
    {
  switch (phase)
    {
    case PHASE_GET_DEPS:
      {
	(void) kinfo ((yyvsp[(1) - (4)].c), (yyvsp[(3) - (4)].il));
	ifree ((yyvsp[(3) - (4)].il));
	if (target_p ((yyvsp[(1) - (4)].c)))
	  {
	    theTargets = icons ((yyvsp[(1) - (4)].c), theTargets);
	  }
	nDeds++;
	break;
      }
    case PHASE_OUT_REACHABLE:
      {
	struct cinfo *ci = getkinfo ((yyvsp[(1) - (4)].c));

	if (ci!=NULL && MARK(ci->h))
	  {
	    fputs ((*theBufp)->s, yyout);
	    SETMARK(ci->h, 0); /* we are happy with the first deduction of the clause,
				  and won't output any other. */
	  }
	new_clause ();
      }
      break;
    }
  (*theBufp)->len = 0;
;}
    break;

  case 15:
#line 843 "cproof.y"
    { if (phase==PHASE_GET_DEPS) (yyval.il) = icons ((yyvsp[(1) - (1)].c), NULL); else (yyval.il) = NULL; ;}
    break;

  case 16:
#line 844 "cproof.y"
    { if (phase==PHASE_GET_DEPS) (yyval.il) = icons ((yyvsp[(2) - (2)].c), (yyvsp[(1) - (2)].il)); else (yyval.il) = NULL; ;}
    break;

  case 17:
#line 847 "cproof.y"
    {
  if (phase==PHASE_GET_DEPS)
    {
      (*theBufp)->len = 0;
    }
  else bput (theBufp, "\n  ", 3);
  (yyval.c) = (yyvsp[(1) - (2)].c);
;}
    break;

  case 18:
#line 857 "cproof.y"
    {
  switch (phase)
    {
    case PHASE_GET_DEPS:
      (*theBufp)->len = 0;
      /*fallthrough*/
    case PHASE_OUT_REACHABLE:
      (yyval.c) = (yyvsp[(1) - (1)].c);
      break;
    default: (yyval.c) = NULL; break;
    } 
;}
    break;

  case 20:
#line 872 "cproof.y"
    { if (phase==PHASE_GET_DEPS) (*theBufp)->len = 0;
 else bput (theBufp, yytext, yyleng); ;}
    break;

  case 22:
#line 877 "cproof.y"
    { switch (phase)
  {
  case PHASE_COPY_INTRO: bput (theBufp, "\n", 1); break;
  case PHASE_GET_DEPS: break;
  }
;}
    break;

  case 23:
#line 885 "cproof.y"
    { (yyval.c) = (yyvsp[(1) - (1)].c); ;}
    break;

  case 24:
#line 892 "cproof.y"
    { (yyval.c) = out_prems?NULL:kons ((struct header *)nil, (yyvsp[(2) - (3)].c)); ;}
    break;

  case 25:
#line 893 "cproof.y"
    { (yyval.c) = out_prems?NULL:kons ((struct header *)(yyvsp[(1) - (4)].h), (yyvsp[(3) - (4)].c)); ;}
    break;

  case 26:
#line 894 "cproof.y"
    { (yyval.c) = out_prems?NULL:kons ((struct header *)(yyvsp[(1) - (2)].h), nil); ;}
    break;

  case 27:
#line 899 "cproof.y"
    { (yyval.h) = (yyvsp[(1) - (1)].h); ;}
    break;

  case 28:
#line 900 "cproof.y"
    { (yyval.h) = out_prems?NULL:((struct header *)
							  kons ((struct header *)kstring ("#or"),
								kons((yyvsp[(1) - (3)].h), kons((yyvsp[(3) - (3)].h), nil)))); ;}
    break;

  case 29:
#line 905 "cproof.y"
    { (yyval.h) = (yyvsp[(1) - (1)].h); ;}
    break;

  case 30:
#line 906 "cproof.y"
    { (yyval.h) = (struct header *)(yyvsp[(1) - (1)].s); /*out_prems?NULL:kons ((struct header *)$1, nil);*/ ;}
    break;

  case 31:
#line 911 "cproof.y"
    { (yyval.c) = nil; ;}
    break;

  case 32:
#line 912 "cproof.y"
    { (yyval.c) = (yyvsp[(1) - (1)].c); ;}
    break;

  case 33:
#line 917 "cproof.y"
    { (yyval.c) = out_prems?NULL:kons ((struct header *)(yyvsp[(1) - (1)].h), nil); ;}
    break;

  case 34:
#line 918 "cproof.y"
    { (yyval.c) = out_prems?NULL:kons ((struct header *)(yyvsp[(3) - (3)].h), (yyvsp[(1) - (3)].c)); ;}
    break;

  case 35:
#line 921 "cproof.y"
    {
  if (out_prems)
    (yyval.h) = NULL;
  else /*if ($3->cdr==nil)
    $$ = (struct header *)kons ((struct header *)$1, (struct cons *)CAR($3));
    else*/
    (yyval.h) = (struct header *)kons ((struct header *)(yyvsp[(1) - (4)].s), (yyvsp[(3) - (4)].c));
;}
    break;

  case 36:
#line 929 "cproof.y"
    { bput (theBufp, " ", 1); ;}
    break;

  case 37:
#line 929 "cproof.y"
    { (yyval.h) = out_prems?NULL:
  ((struct header *)
   kons ((struct header *)(yyvsp[(1) - (3)].s),
	 kons ((yyvsp[(3) - (3)].h), nil)
	 ));
;}
    break;

  case 38:
#line 935 "cproof.y"
    { (yyval.h) = (struct header *)(yyvsp[(1) - (1)].s); /*out_prems?NULL:kons ((struct header *)$1, nil);*/ ;}
    break;

  case 39:
#line 936 "cproof.y"
    { (yyval.h) = (struct header *)(yyvsp[(1) - (1)].s); /*out_prems?NULL:kons ((struct header *)$1, nil);*/ ;}
    break;

  case 40:
#line 941 "cproof.y"
    { (yyval.c) = out_prems?NULL:kons ((yyvsp[(1) - (1)].h), nil); ;}
    break;

  case 41:
#line 942 "cproof.y"
    { (yyval.c) = out_prems?NULL:kons ((yyvsp[(3) - (3)].h), (yyvsp[(1) - (3)].c)); ;}
    break;

  case 42:
#line 945 "cproof.y"
    { (yyval.h) = (struct header *)(yyvsp[(1) - (1)].s); ;}
    break;

  case 43:
#line 946 "cproof.y"
    { (yyval.h) = (struct header *)(yyvsp[(1) - (1)].c); ;}
    break;

  case 44:
#line 950 "cproof.y"
    { (yyval.c) = out_prems?NULL:kons ((struct header *)(yyvsp[(1) - (4)].s), (yyvsp[(3) - (4)].c)); ;}
    break;

  case 45:
#line 951 "cproof.y"
    { (yyval.c) = out_prems?NULL:kons ((struct header *)(yyvsp[(1) - (1)].s), nil); ;}
    break;

  case 46:
#line 954 "cproof.y"
    { bput (theBufp, yytext, yyleng); (yyval.s) = out_prems?NULL:kstring (yytext); ;}
    break;

  case 47:
#line 957 "cproof.y"
    { bput (theBufp, yytext, yyleng); (yyval.s) = out_prems?NULL:kstring (yytext); ;}
    break;

  case 48:
#line 960 "cproof.y"
    { bput (theBufp, yytext, yyleng); (yyval.s) = out_prems?NULL:kstring (yytext); ;}
    break;

  case 49:
#line 963 "cproof.y"
    { bput (theBufp, yytext, yyleng); (yyval.s) = out_prems?NULL:kstring (yytext); ;}
    break;

  case 50:
#line 966 "cproof.y"
    { bput (theBufp, yytext, yyleng); ;}
    break;

  case 51:
#line 969 "cproof.y"
    { bput (theBufp, yytext, yyleng); ;}
    break;

  case 52:
#line 972 "cproof.y"
    { bput (theBufp, yytext, yyleng);
 /* bput (theBufp, ", ", 2); */ ;}
    break;

  case 53:
#line 976 "cproof.y"
    { bput (theBufp, ";", 1); ;}
    break;

  case 54:
#line 979 "cproof.y"
    { bput (theBufp, yytext, yyleng); ;}
    break;

  case 55:
#line 982 "cproof.y"
    { bput (theBufp, " :- ", 4); ;}
    break;

  case 56:
#line 985 "cproof.y"
    { bput (theBufp, yytext, yyleng); ;}
    break;

  case 57:
#line 988 "cproof.y"
    { bput (theBufp, yytext, yyleng); bput (theBufp, "\n", 1); ;}
    break;

  case 58:
#line 991 "cproof.y"
    { bput (theBufp, yytext, yyleng); bput (theBufp, "\n  ", 3);
 if (phase==PHASE_OUT_REACHABLE) out_prems = 1;
 if (phase==PHASE_GET_DEPS) (*theBufp)->len = 0;
;}
    break;

  case 59:
#line 997 "cproof.y"
    { bput (theBufp, yytext, yyleng); bput (theBufp, "\n", 1);
 out_prems = 0;
;}
    break;

  case 60:
#line 1002 "cproof.y"
    { bput (theBufp, yytext, yyleng); ;}
    break;

  case 61:
#line 1005 "cproof.y"
    { bput (theBufp, yytext, yyleng); bput (theBufp, "\n", 1); ;}
    break;

  case 62:
#line 1008 "cproof.y"
    { bput (theBufp, yytext, yyleng); ;}
    break;

  case 63:
#line 1011 "cproof.y"
    { bput (theBufp, yytext, yyleng); ;}
    break;

  case 64:
#line 1014 "cproof.y"
    { bput (theBufp, yytext, yyleng); ;}
    break;

  case 65:
#line 1017 "cproof.y"
    { bput (theBufp, yytext, yyleng); bput (theBufp, "\n", 1); ;}
    break;

  case 66:
#line 1020 "cproof.y"
    { bput (theBufp, yytext, yyleng); bput (theBufp, "\n", 1); ;}
    break;

  case 67:
#line 1023 "cproof.y"
    { bput (theBufp, yytext, yyleng); bput (theBufp, "\n", 1); ;}
    break;

  case 68:
#line 1026 "cproof.y"
    { bput (theBufp, yytext, yyleng); bput (theBufp, "\n", 1); ;}
    break;

  case 69:
#line 1029 "cproof.y"
    { bput (theBufp, yytext, yyleng); bput (theBufp, "\n", 1); ;}
    break;

  case 70:
#line 1032 "cproof.y"
    { bput (theBufp, yytext, yyleng); bput (theBufp, "\n", 1); ;}
    break;

  case 71:
#line 1035 "cproof.y"
    { bput (theBufp, yytext, yyleng); bput (theBufp, "\n", 1);
 switch (phase)
  {
  case PHASE_SKIP_INTRO: phase = PHASE_GET_DEPS; break;
  case PHASE_COPY_INTRO: phase = PHASE_OUT_REACHABLE; break;
  }
;}
    break;


/* Line 1267 of yacc.c.  */
#line 2576 "cproof.tab.c"
      default: break;
    }
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
      {
	YYSIZE_T yysize = yysyntax_error (0, yystate, yychar);
	if (yymsg_alloc < yysize && yymsg_alloc < YYSTACK_ALLOC_MAXIMUM)
	  {
	    YYSIZE_T yyalloc = 2 * yysize;
	    if (! (yysize <= yyalloc && yyalloc <= YYSTACK_ALLOC_MAXIMUM))
	      yyalloc = YYSTACK_ALLOC_MAXIMUM;
	    if (yymsg != yymsgbuf)
	      YYSTACK_FREE (yymsg);
	    yymsg = (char *) YYSTACK_ALLOC (yyalloc);
	    if (yymsg)
	      yymsg_alloc = yyalloc;
	    else
	      {
		yymsg = yymsgbuf;
		yymsg_alloc = sizeof yymsgbuf;
	      }
	  }

	if (0 < yysize && yysize <= yymsg_alloc)
	  {
	    (void) yysyntax_error (yymsg, yystate, yychar);
	    yyerror (yymsg);
	  }
	else
	  {
	    yyerror (YY_("syntax error"));
	    if (yysize != 0)
	      goto yyexhaustedlab;
	  }
      }
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse look-ahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse look-ahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  *++yyvsp = yylval;


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEOF && yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval);
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}


#line 1044 "cproof.y"


long nMarks = 0;
#define MARKS_STEP 1000
long nMarksMod = 0;

BSD_CURSOR(marksCursor);

void mark (struct cons *i)
{
  struct cinfo *ci = getkinfo (i);
  unsigned int k, n;

  if (ci==NULL)
    return;
  if (MARK(ci->h)) /* already marked */
    return;
  SETMARK(ci->h, 1);
  nMarks++;
  if (verbose>=2 && ++nMarksMod==MARKS_STEP)
    {
      nMarksMod = 0;
      bump_bsd_cursor (&marksCursor);
    }
  n = N(ci->h);
  for (k=0; k<n; k++)
    mark (ci->prem[k]);
}

void stringify (char *to, char *from)
{
  char c;

  *to++ = '"';
  while ((c = *from++))
    {
      switch (c)
	{
	case '"': case '\\':
	  *to++ = '\\';
	  *to++ = c;
	  break;
	default:
	  *to++ = c;
	  break;
	}
    }
  *to++ = '"';
  *to = 0;
}

int gz (char *s)
{
  int len = strlen (s);

  return (len>=3 && strcmp (s+len-3, ".gz")==0);
}

fp hopen (char *name)
{
  char *cmd;
  fp f;

#ifdef HAVE_LIBZ
  f = gzopen (name, "r");
#else
  cmd = xmalloc (16 + 2*strlen (name));
  strcpy (cmd, "zcat ");
  stringify (cmd+strlen(cmd), name);
  if (gz (name))
    f = popen (cmd, "r");
  else f = fopen (name, "r");
  free (cmd);
#endif
  return f;
}

void hclose (char *name, fp f)
{
#ifdef HAVE_LIBZ
  gzclose (f);
#else
  if (gz (name))
    pclose (f);
  else fclose (f);
#endif
}

void usage (void)
{
  fputs ("Usage: h1logstrip <flags*> filename.\n"
	 "Version 1.0, Copyright (C) Jean Goubault-Larrecq;\n"
	 "     see file COPYRIGHT.\n"
	 "  h1logstrip comes with ABSOLUTELY NO WARRANTY; see file COPYING, sections 11, 12.\n"
	 "  This is free software, and you are welcome to redistribute it\n"
	 "  under certain conditions; see TERMS AND CONDITIONS in file COPYING.\n"
	 "  Filename is <name>.log or <name>.log.gz.\n"
	 "  Flags are:\n"
	 "    -h prints this help.\n"
	 "    -v0 runs silently, -v1 (aka., -v) and -v2 are more verbose\n"
	 "    -false outputs all contradictions and their proofs;\n"
	 "       -no-false disables this option.  Default: -false.\n"
	 "    -auto outputs all automaton clauses and their proofs;\n"
	 "       -no-auto disables this option.  Default: -no-auto.\n"
	 "    -ne outputs all non-emptiness clauses #ne(...) and their proofs;\n"
	 "       -no-ne disables this option.  Default: -no-ne.\n",
	 stderr
	 );
  fflush (stderr);
}

int main (int argc, char **argv)
{
  struct buffer *buf = new_buf ();
  char *name;
  fp f;
  int i;

  for (i=1; i<argc; i++)
    {
      if (strcmp (argv[i], "-h")==0)
	{
	  usage ();
	  if (i+1==argc)
	    exit (0);
	}
      else if (argv[i][0]=='-' && argv[i][1]=='v')
	{
	  if (argv[i][2]==0)
	    verbose = 1;
	  else if (sscanf (&argv[i][2], "%d", &verbose)!=1)
	    {
	      fprintf (stderr, "Expected verbosity level (integer) after -v.\n");
	      fflush (stderr);
	      exit (2);
	    }
	}
      else if (strcmp (argv[i], "-no-false")==0)
	target_flags &= ~TARGET_FALSE;
      else if (strcmp (argv[i], "-false")==0)
	target_flags |= TARGET_FALSE;
      else if (strcmp (argv[i], "-no-auto")==0)
	target_flags &= ~TARGET_AUTO;
      else if (strcmp (argv[i], "-auto")==0)
	target_flags |= TARGET_AUTO;
      else if (strcmp (argv[i], "-no-ne")==0)
	target_flags &= ~TARGET_Q;
      else if (strcmp (argv[i], "-ne")==0)
	target_flags |= TARGET_Q;
      else break;
    }
  if (i>=argc)
    {
      fprintf (stderr, "Missing filename.\n");
      usage ();
      exit (2);
    }
  /* Initialization */
  consTable = xmalloc (cons_hash_size * sizeof (struct cons *));
  stringTable = xmalloc (string_hash_size * sizeof (struct string *));
  cinfoTable = xmalloc (cinfo_hash_size * sizeof (struct cinfo *));
  nil = small_alloc (sizeof (struct cinfo));
  nil->h.bits = 0;
  /*
  nil->h.kind = 0;
  nil->h.mark = 0;
  nil->h.n = 0;
  */
  nil->next = NULL;
  SETCAR(nil, NULL);
  nil->cdr = NULL;
  /* Now open files: let's go. */
  name = argv[i];
  f = hopen (name);
  if (f==NULL)
    {
      perror (argv[0]);
      fprintf (stderr, " (file %s).\n", name);
      exit (10);
    }
  YYIN = f;
  theBufp = &buf;
  if (verbose>=1)
    {
      fprintf (stderr, "Scanning ... ");
      fflush (stderr);
    }
  yyparse ();
  hclose (name, f);
  if (verbose>=1)
    {
      fprintf (stderr, "%c done: %ld deduction steps, %ld clauses.\n", 8, nDeds, nClauses
	       /*, ((double) nTableRecords) / ((double) nHash)*/);
      fflush (stderr);
    }
  {
    struct ilist *il;

    if (verbose>=1)
      {
	fprintf (stderr, "Marking ... ");
	fflush (stderr);
      }
    for (il = theTargets; il!=NULL; il=il->next)
      mark (il->i);
    ifree (theTargets);
    theTargets = NULL;
  }
  if (verbose>=1)
    {
      fprintf (stderr, "%c done: %ld live clauses.\n", 8, nMarks);
      fflush (stderr);
    }
  f = hopen (name);
  if (f==NULL)
    {
      perror (argv[0]);
      fprintf (stderr, " (file %s).\n", name);
      exit (10);
    }
  YYIN = f;
  if (verbose>=1)
    {
      fprintf (stderr, "Outputting ... ");
      fflush (stderr);
      clauseCursor.time = -1;
    }
  yyparse ();
  hclose (name, f);
  if (verbose>=1)
    {
      fprintf (stderr, "%c done.\n", 8);
      fflush (stderr);
    }
  return 0;
}

