(* Automata determinization functions, headers.
   Copyright (C) 2003 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.

   This file is part of h1.

   h1 is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   h1 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with h1; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*)

open "auto_h";

type fmodel = block set * (string -m> block list -m> block)

extern val determinize : automaton * (block * block -> bool) -> fmodel;
(* determinize (auto, block_incl)
 return determinized complete automaton (ignoring univ part of automaton)
 of auto;
 states of the determinized automaton are just blocks.
 block set is set of states in the automaton (values in a finite model).
 second component returned is map from function symbols
 to their defining table, mapping lists of values to values.

 The automaton is determinized using the block_incl function,
 which should be an approximation of inclusions of languages
 of blocks, in the sense that if block_incl (blk1, blk2)
 then the language L(blk1) is a subset of L(blk2).
 Recally that if blk = {P1, ..., Pk} then
 L(blk) = L(P1) & ... & L(Pk).

 A predicate P is true at state blk (where blk is a block)
 if and only if block_incl (blk, {P}).
 *)

(*
extern val print_fmodel_dot : 'a outstream * fmodel -> unit;
	   (* prints fmodel on file, as a dot graph;
	    run dot or dotty on it to have a look at it.
	    *)
*)

extern val print_fmodel_table : 'a outstream * fmodel
	   * string set * (string -m> string * string)
	   * (block * block -> bool)
	   -> unit;
	   (*
	    print_fmodel_table (fd, model, preds, defs, block_incl)
	    prints XML description of model on fd,
	    also giving truth values for predicates in preds;
	    this rests on a block_incl function.
	    If fmodel was constructed with some block_incl
	    function, the same should be used here.
	    defs maps predicates to their definitions in ASCII form.
	    *)
