

% h1 example: the Denning-Sacco key distribution protocol, fixed.
% Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
% This file is part of h1.
%
% h1 is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2, or (at your option)
% any later version.
%
% h1 is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with h1; see the file COPYING. If not, write to
% the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

% run 'cpp -P dsfixed.timed.p >dsfixed.p'

cnf(alice_agent,axiom,
    (agent(alice))).
cnf(bob_agent,axiom,
    (agent(bob))).
cnf(server_agent,axiom,
    (agent(server))).
cnf(intruder_agent,axiom,
    (agent(i))).
% h1 example: the Denning-Sacco key distribution protocol, fixed.
% Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
% This file is part of h1.
%
% h1 is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2, or (at your option)
% any later version.
%
% h1 is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with h1; see the file COPYING. If not, write to
% the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
cnf(intruder_knows_nil_old,axiom,
  (knows_old(nil))).
cnf(intruder_can_take_first_components_old,axiom,
  (~knows_old(cons(M1,M2)) | knows_old(M1))).
cnf(intruder_can_take_second_components_old,axiom,
  (~knows_old(cons(M1,M2)) | knows_old(M2))).
cnf(intruder_can_build_pairs_old,axiom,
  (~knows_old(M2) | ~knows_old(M1) | knows_old(cons(M1,M2)))).
cnf(intruder_can_encrypt_old,axiom,
  (~knows_old(K) | ~knows_old(M) | knows_old(crypt(M,K)))).
cnf(intruder_can_decrypt_if_has_private_key_old,axiom,
  (~knows_old(key(prv,K)) | ~knows_old(crypt(M,key(pub,K))) | knows_old(M))).
cnf(intruder_can_decrypt_if_has_public_key_old,axiom,
  (~knows_old(key(pub,K)) | ~knows_old(crypt(M,key(prv,K))) | knows_old(M))).
cnf(intruder_can_decrypt_if_has_symmetric_key_old,axiom,
  (~knows_old(key(sym,X)) | ~knows_old(crypt(M,key(sym,X))) | knows_old(M))).
cnf(intruder_can_compute_successors_old,axiom,
  (~knows_old(M) | knows_old(s(M)))).
cnf(intruder_can_compute_predecessors_old,axiom,
  (~knows_old(s(M)) | knows_old(M))).
cnf(intruder_knows_timestamps_old,axiom,
  (knows_old(t_old))).
%
% Ajout des clauses du protocole
%
%
   % 1. A -> S : A, B
cnf(message1_old,axiom,
  (~agent(A) | ~agent (B)
    | knows_old(cons(A,cons(B,nil))))).
   % 2. S -> A : {A, Ka, t_old}_{Ks^-1}, {A, Kb, t_old}_{Ks^-1}
   % where t_old is timestamp.
cnf(message2_old,axiom,
  (~knows_old(cons(A,cons(B,nil)))
  | knows_old(cons(crypt(cons(A,cons(key(pub,A),cons(t_old,nil))),
                     key(prv,server)),
          cons(crypt(cons(A,cons(key(pub,B),cons(t_old,nil))),
              key(prv,server)),
          nil))))).
   % 3. A -> B : {A, Ka, t_old}_{Ks^-1}, {{A, B, Kab, t_old}_{Ka^-1}}_Kb
cnf(message3_old,axiom,
  (~knows_old(cons(crypt(cons(A,cons(key(pub,A),cons(t_old,nil))),
                     key(prv,server)),
          cons(crypt(cons(A,cons(key(pub,B),cons(t_old,nil))),
              key(prv,server)),
          nil))) % from conclusion of message2
  | knows_old(cons(crypt(cons(A,cons(key(pub,A),cons(t_old,nil))),
                     key(prv,server)),
          cons(crypt(crypt(cons(A,cons(B,cons(key(sym,session_old(A,B)),cons(t_old,nil)))),
                    key(prv,A)),
                     key(pub,B)),
          nil))))).
   % 4. B -> A : {A, B, data, t_old}_Kab
cnf(message4_old,axiom,
  (~knows_old(cons(crypt(cons(A,cons(key(pub,A),cons(t_old,nil))),
                     key(prv,server)),
   cons(crypt(crypt(cons(A,cons(B,cons(Kab,cons(t_old,nil)))),
                    key(prv,A)),
                     key(pub,B)),
   nil))) % from conclusion of message3
  | knows_old(crypt(cons(data_old(A,B),cons(t_old,nil)),
                Kab)))).
cnf(define_alice_data_old,axiom,
  (~knows_old(cons(crypt(cons(A,cons(key(pub,A),cons(t_old,nil))),
                     key(prv,server)),
          cons(crypt(cons(A,cons(key(pub,B),cons(t_old,nil))),
              key(prv,server)),
          nil))) % from conclusion of message2
  | ~knows_old(crypt(cons(Data,cons(t_old,nil)),
                 key(sym,session_old(A,B)))) % from conclusion of message4
  | alice_msg_old(A,Data))).
cnf(define_bob_data_old,axiom,
  (~knows_old(cons(crypt(cons(A,cons(key(pub,A),cons(t_old,nil))),
                     key(prv,server)),
   cons(crypt(crypt(cons(A,cons(B,cons(Kab,cons(t_old,nil)))),
                    key(prv,A)),
                     key(pub,B)),
   nil))) % from conclusion of message3
  | bob_msg_old(B,data_old(A,B)))).
cnf(intruder_knows_all_agents_old,axiom,
  (~agent(X) | knows_old(X))).
cnf(intruder_knows_every_public_key_old,axiom,
  (knows_old(key(pub,X)))).
cnf(intruder_knows_own_private_key_old,axiom,
  (knows_old(key(prv,i)))).
cnf(intruder_remembers,axiom,
   (~knows_old(M) | knows_current(M))).
cnf(intruder_knows_all_previous_session_keys,axiom,
  (knows_current(key(sym,session_old(A,B))))).
cnf(intruder_knows_all_previous_data,axiom,
  (knows_current(data_old(A,B)))).
% h1 example: the Denning-Sacco key distribution protocol, fixed.
% Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
% This file is part of h1.
%
% h1 is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2, or (at your option)
% any later version.
%
% h1 is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with h1; see the file COPYING. If not, write to
% the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
cnf(intruder_knows_nil_current,axiom,
  (knows_current(nil))).
cnf(intruder_can_take_first_components_current,axiom,
  (~knows_current(cons(M1,M2)) | knows_current(M1))).
cnf(intruder_can_take_second_components_current,axiom,
  (~knows_current(cons(M1,M2)) | knows_current(M2))).
cnf(intruder_can_build_pairs_current,axiom,
  (~knows_current(M2) | ~knows_current(M1) | knows_current(cons(M1,M2)))).
cnf(intruder_can_encrypt_current,axiom,
  (~knows_current(K) | ~knows_current(M) | knows_current(crypt(M,K)))).
cnf(intruder_can_decrypt_if_has_private_key_current,axiom,
  (~knows_current(key(prv,K)) | ~knows_current(crypt(M,key(pub,K))) | knows_current(M))).
cnf(intruder_can_decrypt_if_has_public_key_current,axiom,
  (~knows_current(key(pub,K)) | ~knows_current(crypt(M,key(prv,K))) | knows_current(M))).
cnf(intruder_can_decrypt_if_has_symmetric_key_current,axiom,
  (~knows_current(key(sym,X)) | ~knows_current(crypt(M,key(sym,X))) | knows_current(M))).
cnf(intruder_can_compute_successors_current,axiom,
  (~knows_current(M) | knows_current(s(M)))).
cnf(intruder_can_compute_predecessors_current,axiom,
  (~knows_current(s(M)) | knows_current(M))).
cnf(intruder_knows_timestamps_current,axiom,
  (knows_current(t_current))).
%
% Ajout des clauses du protocole
%
%
   % 1. A -> S : A, B
cnf(message1_current,axiom,
  (~agent(A) | ~agent (B)
    | knows_current(cons(A,cons(B,nil))))).
   % 2. S -> A : {A, Ka, t_current}_{Ks^-1}, {A, Kb, t_current}_{Ks^-1}
   % where t_current is timestamp.
cnf(message2_current,axiom,
  (~knows_current(cons(A,cons(B,nil)))
  | knows_current(cons(crypt(cons(A,cons(key(pub,A),cons(t_current,nil))),
                     key(prv,server)),
          cons(crypt(cons(A,cons(key(pub,B),cons(t_current,nil))),
              key(prv,server)),
          nil))))).
   % 3. A -> B : {A, Ka, t_current}_{Ks^-1}, {{A, B, Kab, t_current}_{Ka^-1}}_Kb
cnf(message3_current,axiom,
  (~knows_current(cons(crypt(cons(A,cons(key(pub,A),cons(t_current,nil))),
                     key(prv,server)),
          cons(crypt(cons(A,cons(key(pub,B),cons(t_current,nil))),
              key(prv,server)),
          nil))) % from conclusion of message2
  | knows_current(cons(crypt(cons(A,cons(key(pub,A),cons(t_current,nil))),
                     key(prv,server)),
          cons(crypt(crypt(cons(A,cons(B,cons(key(sym,session_current(A,B)),cons(t_current,nil)))),
                    key(prv,A)),
                     key(pub,B)),
          nil))))).
   % 4. B -> A : {A, B, data, t_current}_Kab
cnf(message4_current,axiom,
  (~knows_current(cons(crypt(cons(A,cons(key(pub,A),cons(t_current,nil))),
                     key(prv,server)),
   cons(crypt(crypt(cons(A,cons(B,cons(Kab,cons(t_current,nil)))),
                    key(prv,A)),
                     key(pub,B)),
   nil))) % from conclusion of message3
  | knows_current(crypt(cons(data_current(A,B),cons(t_current,nil)),
                Kab)))).
cnf(define_alice_data_current,axiom,
  (~knows_current(cons(crypt(cons(A,cons(key(pub,A),cons(t_current,nil))),
                     key(prv,server)),
          cons(crypt(cons(A,cons(key(pub,B),cons(t_current,nil))),
              key(prv,server)),
          nil))) % from conclusion of message2
  | ~knows_current(crypt(cons(Data,cons(t_current,nil)),
                 key(sym,session_current(A,B)))) % from conclusion of message4
  | alice_msg_current(A,Data))).
cnf(define_bob_data_current,axiom,
  (~knows_current(cons(crypt(cons(A,cons(key(pub,A),cons(t_current,nil))),
                     key(prv,server)),
   cons(crypt(crypt(cons(A,cons(B,cons(Kab,cons(t_current,nil)))),
                    key(prv,A)),
                     key(pub,B)),
   nil))) % from conclusion of message3
  | bob_msg_current(B,data_current(A,B)))).
cnf(intruder_knows_all_agents_current,axiom,
  (~agent(X) | knows_current(X))).
cnf(intruder_knows_every_public_key_current,axiom,
  (knows_current(key(pub,X)))).
cnf(intruder_knows_own_private_key_current,axiom,
  (knows_current(key(prv,i)))).
cnf(intruder_knows_data_generated_by_bob,axiom,
  (~knows_current(D) | ~bob_msg_current(bob,D))).
cnf(intruder_knows_data_as_seen_by_alice,axiom,
  (~knows_current(D) | ~alice_msg_current(alice,D))).
