% h1 example: the Denning-Sacco key distribution protocol, fixed.
%   Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
%   This file is part of h1.
%
%   h1 is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2, or (at your option)
%   any later version.
%
%   h1 is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with h1; see the file COPYING.  If not, write to
%   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

#define KNOWS PHASE(knows)
#define T PHASE(t)
#define DATA PHASE(data)
#define SESSION PHASE(session)
#define ALICE_DATA PHASE(alice_msg)
#define BOB_DATA PHASE(bob_msg)

cnf(PHASE(intruder_knows_nil),axiom,
  (KNOWS(nil))).
cnf(PHASE(intruder_can_take_first_components),axiom,
  (~KNOWS(cons(M1,M2)) | KNOWS(M1))).
cnf(PHASE(intruder_can_take_second_components),axiom,
  (~KNOWS(cons(M1,M2)) | KNOWS(M2))).
cnf(PHASE(intruder_can_build_pairs),axiom,
  (~KNOWS(M2) | ~KNOWS(M1) | KNOWS(cons(M1,M2)))).
cnf(PHASE(intruder_can_encrypt),axiom,
  (~KNOWS(K) | ~KNOWS(M) | KNOWS(crypt(M,K)))).
cnf(PHASE(intruder_can_decrypt_if_has_private_key),axiom,
  (~KNOWS(key(prv,K)) | ~KNOWS(crypt(M,key(pub,K))) | KNOWS(M))).
cnf(PHASE(intruder_can_decrypt_if_has_public_key),axiom,
  (~KNOWS(key(pub,K)) | ~KNOWS(crypt(M,key(prv,K))) | KNOWS(M))).
cnf(PHASE(intruder_can_decrypt_if_has_symmetric_key),axiom,
  (~KNOWS(key(sym,X)) | ~KNOWS(crypt(M,key(sym,X))) | KNOWS(M))).
cnf(PHASE(intruder_can_compute_successors),axiom,
  (~KNOWS(M) | KNOWS(s(M)))).
cnf(PHASE(intruder_can_compute_predecessors),axiom,
  (~KNOWS(s(M)) | KNOWS(M))).

cnf(PHASE(intruder_knows_timestamps),axiom,
  (KNOWS(T))).

%
% Ajout des clauses du protocole
%
%
   % 1. A -> S : A, B
cnf(PHASE(message1),axiom,
  (~agent(A) | ~agent (B)
    | KNOWS(cons(A,cons(B,nil))))).
   % 2. S -> A : {A, Ka, T}_{Ks^-1}, {A, Kb, T}_{Ks^-1}
   %    where T is timestamp.
cnf(PHASE(message2),axiom,
  (~KNOWS(cons(A,cons(B,nil)))
  | KNOWS(cons(crypt(cons(A,cons(key(pub,A),cons(T,nil))),
                     key(prv,server)),
          cons(crypt(cons(A,cons(key(pub,B),cons(T,nil))),
	             key(prv,server)),
          nil))))).
   % 3. A -> B : {A, Ka, T}_{Ks^-1}, {{A, B, Kab, T}_{Ka^-1}}_Kb
cnf(PHASE(message3),axiom,
  (~KNOWS(cons(crypt(cons(A,cons(key(pub,A),cons(T,nil))),
                     key(prv,server)),
          cons(crypt(cons(A,cons(key(pub,B),cons(T,nil))),
	             key(prv,server)),
          nil))) % from conclusion of message2
  | KNOWS(cons(crypt(cons(A,cons(key(pub,A),cons(T,nil))),
                     key(prv,server)),
          cons(crypt(crypt(cons(A,cons(B,cons(key(sym,SESSION(A,B)),cons(T,nil)))),
	                   key(prv,A)),
                     key(pub,B)),
          nil))))).
   % 4. B -> A : {A, B, data, T}_Kab
cnf(PHASE(message4),axiom,
  (~KNOWS(cons(crypt(cons(A,cons(key(pub,A),cons(T,nil))),
                     key(prv,server)),
	  cons(crypt(crypt(cons(A,cons(B,cons(Kab,cons(T,nil)))),
	                   key(prv,A)),
                     key(pub,B)),
	  nil))) % from conclusion of message3
  | KNOWS(crypt(cons(DATA(A,B),cons(T,nil)),
                Kab)))).

cnf(PHASE(define_alice_data),axiom,
  (~KNOWS(cons(crypt(cons(A,cons(key(pub,A),cons(T,nil))),
                     key(prv,server)),
          cons(crypt(cons(A,cons(key(pub,B),cons(T,nil))),
	             key(prv,server)),
          nil))) % from conclusion of message2
  | ~KNOWS(crypt(cons(Data,cons(T,nil)),
                 key(sym,SESSION(A,B)))) % from conclusion of message4
  | ALICE_DATA(A,Data))).

cnf(PHASE(define_bob_data),axiom,
  (~KNOWS(cons(crypt(cons(A,cons(key(pub,A),cons(T,nil))),
                     key(prv,server)),
	  cons(crypt(crypt(cons(A,cons(B,cons(Kab,cons(T,nil)))),
	                   key(prv,A)),
                     key(pub,B)),
	  nil))) % from conclusion of message3
  | BOB_DATA(B,DATA(A,B)))).

cnf(PHASE(intruder_knows_all_agents),axiom,
  (~agent(X) | KNOWS(X))).
cnf(PHASE(intruder_knows_every_public_key),axiom,
  (KNOWS(key(pub,X)))).
cnf(PHASE(intruder_knows_own_private_key),axiom,
  (KNOWS(key(prv,i)))).

#undef KNOWS
#undef T
#undef DATA
#undef SESSION
#undef ALICE_DATA
#undef BOB_DATA
