

% h1 example: the EAP-AKA protocol.
% Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
% This file is part of h1.
%
% h1 is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2, or (at your option)
% any later version.
%
% h1 is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with h1; see the file COPYING. If not, write to
% the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

% run 'cpp -P eap-aka.timed.p >eap-aka.p'

cnf(alice_agent,axiom,
    (agent(alice))).
cnf(bob_agent,axiom,
    (agent(bob))).
cnf(server_agent,axiom,
    (agent(server))).
cnf(intruder_agent,axiom,
    (agent(i))).
% h1 example: the EAP-AKA protocol.
% Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
% This file is part of h1.
%
% h1 is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2, or (at your option)
% any later version.
%
% h1 is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with h1; see the file COPYING. If not, write to
% the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
cnf(intruder_knows_nil_old,axiom,
  (knows_old(nil))).
cnf(intruder_can_take_first_components_old,axiom,
  (~knows_old(cons(M1,M2)) | knows_old(M1))).
cnf(intruder_can_take_second_components_old,axiom,
  (~knows_old(cons(M1,M2)) | knows_old(M2))).
cnf(intruder_can_build_pairs_old,axiom,
  (~knows_old(M2) | ~knows_old(M1) | knows_old(cons(M1,M2)))).
cnf(intruder_can_encrypt_old,axiom,
  (~knows_old(K) | ~knows_old(M) | knows_old(crypt(M,K)))).
cnf(intruder_can_decrypt_if_has_private_key_old,axiom,
  (~knows_old(key(prv,K)) | ~knows_old(crypt(M,key(pub,K))) | knows_old(M))).
cnf(intruder_can_decrypt_if_has_public_key_old,axiom,
  (~knows_old(key(pub,K)) | ~knows_old(crypt(M,key(prv,K))) | knows_old(M))).
cnf(intruder_can_decrypt_if_has_symmetric_key_old,axiom,
  (~knows_old(key(sym,X)) | ~knows_old(crypt(M,key(sym,X))) | knows_old(M))).
cnf(intruder_can_compute_successors_old,axiom,
  (~knows_old(M) | knows_old(s(M)))).
cnf(intruder_can_compute_predecessors_old,axiom,
  (~knows_old(s(M)) | knows_old(M))).
cnf(intruder_can_hash_old,axiom,
  (~knows_old(M) | knows_old(h(M)))).
%
% Ajout des clauses du protocole
%
%
% 1. S -> P : request_id
% where request_id is just a constant, carrying no extra information
cnf(message1_old,axiom,
   (knows_old(request_id))).
% 2. P -> S : respond_id, NAI
% where NAI is network address identifier
cnf(message2_old,axiom,
    (~knows_old(request_id)
    | ~agent(P)
    | knows_old(cons(respond_id, nai(P))))).
% 3. S -> P : Ns, AT_AUTN, h(h(NAI,IK,CK), Ns, AT_AUTN)
% where Ns is a fresh nonce,
% Sqn is a sequence number, unique to the session
% AK = f5(SK, Ns), f5 being a key generation function
% SK is a long-term secret between S and P.
% IK = f4(SK, Ns), f4 being a key generation function
% CK = f3(SK, Ns), f3 being a key generation function
% AT_AUTN = {Sqn}_AK, f1(SK, Sqn, Ns), f1 being an authentication function
cnf(message3_old,axiom,
   (~knows_old(cons(respond_id,cons(NAI,nil)))
   | ~agent(P)
   | ~agent(S)
   | knows_old(cons(nonces_old(NAI,S,P),
           cons(cons(crypt(session_old(NAI,S,P), f5(key(sym,cons(S,cons(P,nil))), nonces_old(NAI,S,P))), cons(f1(key(sym,cons(S,cons(P,nil))), session_old(NAI,S,P), nonces_old(NAI,S,P)), nil)),
    cons(h(cons(h(cons(NAI,
                         cons(f4(key(sym,cons(S,cons(P,nil))),
            nonces_old(NAI,S,P)),
                  cons(f3(key(sym,cons(S,cons(P,nil))),
            nonces_old(NAI,S,P)),
           nil)))),
    cons(nonces_old(NAI,S,P),
    cons(cons(crypt(session_old(NAI,S,P), f5(key(sym,cons(S,cons(P,nil))), nonces_old(NAI,S,P))), cons(f1(key(sym,cons(S,cons(P,nil))), session_old(NAI,S,P), nonces_old(NAI,S,P)), nil)),
    nil)))),
           nil)))))).
% 4. P -> S : AT_RES, h(h(NAI,IK,CK), AT_RES)
% AT_RES = f2(SK, Ns), f2 being an authentication function
cnf(message4_old,axiom,
   (~knows_old(request_id) % from premise of message2
   | ~knows_old(cons(Ns, % from conclusion of message3
            cons(cons(crypt(Sqn, f5(key(sym,cons(S,cons(P,nil))), Ns)), cons(f1(key(sym,cons(S,cons(P,nil))), Sqn, Ns), nil)),
     cons(h(cons(h(cons(NAI,
                   cons(f4(key(sym,cons(S,cons(P,nil))),
             Ns),
     cons(f3(key(sym,cons(S,cons(P,nil))),
             Ns),
     nil)))),
            cons(Ns,
     cons(cons(crypt(Sqn, f5(key(sym,cons(S,cons(P,nil))), Ns)), cons(f1(key(sym,cons(S,cons(P,nil))), Sqn, Ns), nil)),
     nil)))),
     nil))))
   | knows_old(cons(f2(key(sym,cons(S,cons(P,nil))), Ns),
           cons(h(cons(h(cons(NAI,
                  cons(f4(key(sym,cons(S,cons(P,nil))),
            Ns),
    cons(f3(key(sym,cons(S,cons(P,nil))),
            Ns),
    nil)))),
    cons(f2(key(sym,cons(S,cons(P,nil))), Ns),
    nil))),
    nil))))).
% 5. S -> P : success



cnf(message5_old,axiom,
   (~knows_old(cons(respond_id,cons(NAI,nil))) % from premise of message3
   | ~knows_old(cons(f2(key(sym,cons(S,cons(P,nil))), nonces_old(NAI,S,P)), % from conclusion of message4
     cons(h(cons(h(cons(NAI,
                          cons(f4(key(sym,cons(S,cons(P,nil))),
             nonces_old(NAI,S,P)),
                   cons(f3(key(sym,cons(S,cons(P,nil))),
      nonces_old(NAI,S,P)),
            nil)))),
     cons(f2(key(sym,cons(S,cons(P,nil))), nonces_old(NAI,S,P)),
     nil))),
     nil)))
   | knows_old(success))).


% session key for encryption is CK
% session key for integrity check is IK.
% both should be secret.

cnf(define_server_keys_old,axiom,
   (~knows_old(cons(respond_id,cons(NAI,nil))) % from premise of message3
   | ~knows_old(cons(f2(key(sym,cons(S,cons(P,nil))), nonces_old(NAI,S,P)), % from premise of message5
     cons(h(cons(h(cons(NAI,
                          cons(f4(key(sym,cons(S,cons(P,nil))),
             nonces_old(NAI,S,P)),
                   cons(f3(key(sym,cons(S,cons(P,nil))),
      nonces_old(NAI,S,P)),
            nil)))),
     cons(f2(key(sym,cons(S,cons(P,nil))), nonces_old(NAI,S,P)),
     nil))),
     nil)))
   | server_keys_old(S,
                 f4(key(sym,cons(S,cons(P,nil))), % IK
      nonces_old(NAI,S,P)),
   f3(key(sym,cons(S,cons(P,nil))), % CK
      nonces_old(NAI,S,P))))).

cnf(define_peer_keys_old,axiom,
    (~knows_old(request_id) % from premise of message2
   | ~knows_old(cons(Ns, % from premise of message4
            cons(cons(crypt(Sqn, f5(key(sym,cons(S,cons(P,nil))), Ns)), cons(f1(key(sym,cons(S,cons(P,nil))), Sqn, Ns), nil)),
     cons(h(cons(h(cons(NAI,
                   cons(f4(key(sym,cons(S,cons(P,nil))),
             Ns),
     cons(f3(key(sym,cons(S,cons(P,nil))),
             Ns),
     nil)))),
            cons(Ns,
     cons(cons(crypt(Sqn, f5(key(sym,cons(S,cons(P,nil))), Ns)), cons(f1(key(sym,cons(S,cons(P,nil))), Sqn, Ns), nil)),
     nil)))),
     nil))))
  | ~knows_old(success) % from conclusion of message5
  | peer_keys_old(P,
              f4(key(sym,cons(S,cons(P,nil))), % IK
          Ns),
       f3(key(sym,cons(S,cons(P,nil))), % CK
          Ns)))).
cnf(intruder_remembers,axiom,
   (~knows_old(M) | knows_current(M))).
cnf(intruder_knows_previous_server_IK,axiom,
    (~server_keys_old(S,IK,CK)
    | knows_current(IK))).
cnf(intruder_knows_previous_server_CK,axiom,
    (~server_keys_old(S,IK,CK)
    | knows_current(CK))).
cnf(intruder_knows_previous_peer_IK,axiom,
    (~peer_keys_old(P,IK,CK)
    | knows_current(IK))).
cnf(intruder_knows_previous_peer_CK,axiom,
    (~peer_keys_old(P,IK,CK)
    | knows_current(CK))).
% h1 example: the EAP-AKA protocol.
% Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
% This file is part of h1.
%
% h1 is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2, or (at your option)
% any later version.
%
% h1 is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with h1; see the file COPYING. If not, write to
% the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
cnf(intruder_knows_nil_current,axiom,
  (knows_current(nil))).
cnf(intruder_can_take_first_components_current,axiom,
  (~knows_current(cons(M1,M2)) | knows_current(M1))).
cnf(intruder_can_take_second_components_current,axiom,
  (~knows_current(cons(M1,M2)) | knows_current(M2))).
cnf(intruder_can_build_pairs_current,axiom,
  (~knows_current(M2) | ~knows_current(M1) | knows_current(cons(M1,M2)))).
cnf(intruder_can_encrypt_current,axiom,
  (~knows_current(K) | ~knows_current(M) | knows_current(crypt(M,K)))).
cnf(intruder_can_decrypt_if_has_private_key_current,axiom,
  (~knows_current(key(prv,K)) | ~knows_current(crypt(M,key(pub,K))) | knows_current(M))).
cnf(intruder_can_decrypt_if_has_public_key_current,axiom,
  (~knows_current(key(pub,K)) | ~knows_current(crypt(M,key(prv,K))) | knows_current(M))).
cnf(intruder_can_decrypt_if_has_symmetric_key_current,axiom,
  (~knows_current(key(sym,X)) | ~knows_current(crypt(M,key(sym,X))) | knows_current(M))).
cnf(intruder_can_compute_successors_current,axiom,
  (~knows_current(M) | knows_current(s(M)))).
cnf(intruder_can_compute_predecessors_current,axiom,
  (~knows_current(s(M)) | knows_current(M))).
cnf(intruder_can_hash_current,axiom,
  (~knows_current(M) | knows_current(h(M)))).
%
% Ajout des clauses du protocole
%
%
% 1. S -> P : request_id
% where request_id is just a constant, carrying no extra information
cnf(message1_current,axiom,
   (knows_current(request_id))).
% 2. P -> S : respond_id, NAI
% where NAI is network address identifier
cnf(message2_current,axiom,
    (~knows_current(request_id)
    | ~agent(P)
    | knows_current(cons(respond_id, nai(P))))).
% 3. S -> P : Ns, AT_AUTN, h(h(NAI,IK,CK), Ns, AT_AUTN)
% where Ns is a fresh nonce,
% Sqn is a sequence number, unique to the session
% AK = f5(SK, Ns), f5 being a key generation function
% SK is a long-term secret between S and P.
% IK = f4(SK, Ns), f4 being a key generation function
% CK = f3(SK, Ns), f3 being a key generation function
% AT_AUTN = {Sqn}_AK, f1(SK, Sqn, Ns), f1 being an authentication function
cnf(message3_current,axiom,
   (~knows_current(cons(respond_id,cons(NAI,nil)))
   | ~agent(P)
   | ~agent(S)
   | knows_current(cons(nonces_current(NAI,S,P),
           cons(cons(crypt(session_current(NAI,S,P), f5(key(sym,cons(S,cons(P,nil))), nonces_current(NAI,S,P))), cons(f1(key(sym,cons(S,cons(P,nil))), session_current(NAI,S,P), nonces_current(NAI,S,P)), nil)),
    cons(h(cons(h(cons(NAI,
                         cons(f4(key(sym,cons(S,cons(P,nil))),
            nonces_current(NAI,S,P)),
                  cons(f3(key(sym,cons(S,cons(P,nil))),
            nonces_current(NAI,S,P)),
           nil)))),
    cons(nonces_current(NAI,S,P),
    cons(cons(crypt(session_current(NAI,S,P), f5(key(sym,cons(S,cons(P,nil))), nonces_current(NAI,S,P))), cons(f1(key(sym,cons(S,cons(P,nil))), session_current(NAI,S,P), nonces_current(NAI,S,P)), nil)),
    nil)))),
           nil)))))).
% 4. P -> S : AT_RES, h(h(NAI,IK,CK), AT_RES)
% AT_RES = f2(SK, Ns), f2 being an authentication function
cnf(message4_current,axiom,
   (~knows_current(request_id) % from premise of message2
   | ~knows_current(cons(Ns, % from conclusion of message3
            cons(cons(crypt(Sqn, f5(key(sym,cons(S,cons(P,nil))), Ns)), cons(f1(key(sym,cons(S,cons(P,nil))), Sqn, Ns), nil)),
     cons(h(cons(h(cons(NAI,
                   cons(f4(key(sym,cons(S,cons(P,nil))),
             Ns),
     cons(f3(key(sym,cons(S,cons(P,nil))),
             Ns),
     nil)))),
            cons(Ns,
     cons(cons(crypt(Sqn, f5(key(sym,cons(S,cons(P,nil))), Ns)), cons(f1(key(sym,cons(S,cons(P,nil))), Sqn, Ns), nil)),
     nil)))),
     nil))))
   | knows_current(cons(f2(key(sym,cons(S,cons(P,nil))), Ns),
           cons(h(cons(h(cons(NAI,
                  cons(f4(key(sym,cons(S,cons(P,nil))),
            Ns),
    cons(f3(key(sym,cons(S,cons(P,nil))),
            Ns),
    nil)))),
    cons(f2(key(sym,cons(S,cons(P,nil))), Ns),
    nil))),
    nil))))).
% 5. S -> P : success
cnf(message5_current,axiom,
   (~knows_current(cons(respond_id,cons(NAI,nil))) % from premise of message3
   | ~knows_current(cons(f2(key(sym,cons(S,cons(P,nil))), nonces_current(NAI,S,P)), % from conclusion of message4
     cons(h(cons(h(cons(NAI,
                          cons(f4(key(sym,cons(S,cons(P,nil))),
             nonces_current(NAI,S,P)),
                   cons(f3(key(sym,cons(S,cons(P,nil))),
      nonces_current(NAI,S,P)),
            nil)))),
     cons(f2(key(sym,cons(S,cons(P,nil))), nonces_current(NAI,S,P)),
     nil))),
     nil)))
   | knows_current(success))).
% session key for encryption is CK
% session key for integrity check is IK.
% both should be secret.
cnf(define_server_keys_current,axiom,
   (~knows_current(cons(respond_id,cons(NAI,nil))) % from premise of message3
   | ~knows_current(cons(f2(key(sym,cons(S,cons(P,nil))), nonces_current(NAI,S,P)), % from premise of message5
     cons(h(cons(h(cons(NAI,
                          cons(f4(key(sym,cons(S,cons(P,nil))),
             nonces_current(NAI,S,P)),
                   cons(f3(key(sym,cons(S,cons(P,nil))),
      nonces_current(NAI,S,P)),
            nil)))),
     cons(f2(key(sym,cons(S,cons(P,nil))), nonces_current(NAI,S,P)),
     nil))),
     nil)))
   | server_keys_current(S,
                 f4(key(sym,cons(S,cons(P,nil))), % IK
      nonces_current(NAI,S,P)),
   f3(key(sym,cons(S,cons(P,nil))), % CK
      nonces_current(NAI,S,P))))).
cnf(define_peer_keys_current,axiom,
    (~knows_current(request_id) % from premise of message2
   | ~knows_current(cons(Ns, % from premise of message4
            cons(cons(crypt(Sqn, f5(key(sym,cons(S,cons(P,nil))), Ns)), cons(f1(key(sym,cons(S,cons(P,nil))), Sqn, Ns), nil)),
     cons(h(cons(h(cons(NAI,
                   cons(f4(key(sym,cons(S,cons(P,nil))),
             Ns),
     cons(f3(key(sym,cons(S,cons(P,nil))),
             Ns),
     nil)))),
            cons(Ns,
     cons(cons(crypt(Sqn, f5(key(sym,cons(S,cons(P,nil))), Ns)), cons(f1(key(sym,cons(S,cons(P,nil))), Sqn, Ns), nil)),
     nil)))),
     nil))))
  | ~knows_current(success) % from conclusion of message5
  | peer_keys_current(P,
              f4(key(sym,cons(S,cons(P,nil))), % IK
          Ns),
       f3(key(sym,cons(S,cons(P,nil))), % CK
          Ns)))).
cnf(intruder_knows_server_IK,axiom,
    (~server_keys_current(S,IK,CK)
    | ~knows_current(IK))).
cnf(intruder_knows_server_CK,axiom,
    (~server_keys_current(S,IK,CK)
    | ~knows_current(CK))).
cnf(intruder_knows_peer_IK,axiom,
    (~peer_keys_current(P,IK,CK)
    | ~knows_current(IK))).
cnf(intruder_knows_peer_CK,axiom,
    (~peer_keys_current(P,IK,CK)
    | ~knows_current(CK))).
