% h1 example: the EAP-AKA protocol.
%   Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
%   This file is part of h1.
%
%   h1 is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2, or (at your option)
%   any later version.
%
%   h1 is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with h1; see the file COPYING.  If not, write to
%   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

#define KNOWS PHASE(knows)
#define NONCES PHASE(nonces)
#define SESSION PHASE(session)
#define SERVER_KEYS PHASE(server_keys)
#define PEER_KEYS PHASE(peer_keys)

cnf(PHASE(intruder_knows_nil),axiom,
  (KNOWS(nil))).
cnf(PHASE(intruder_can_take_first_components),axiom,
  (~KNOWS(cons(M1,M2)) | KNOWS(M1))).
cnf(PHASE(intruder_can_take_second_components),axiom,
  (~KNOWS(cons(M1,M2)) | KNOWS(M2))).
cnf(PHASE(intruder_can_build_pairs),axiom,
  (~KNOWS(M2) | ~KNOWS(M1) | KNOWS(cons(M1,M2)))).
cnf(PHASE(intruder_can_encrypt),axiom,
  (~KNOWS(K) | ~KNOWS(M) | KNOWS(crypt(M,K)))).
cnf(PHASE(intruder_can_decrypt_if_has_private_key),axiom,
  (~KNOWS(key(prv,K)) | ~KNOWS(crypt(M,key(pub,K))) | KNOWS(M))).
cnf(PHASE(intruder_can_decrypt_if_has_public_key),axiom,
  (~KNOWS(key(pub,K)) | ~KNOWS(crypt(M,key(prv,K))) | KNOWS(M))).
cnf(PHASE(intruder_can_decrypt_if_has_symmetric_key),axiom,
  (~KNOWS(key(sym,X)) | ~KNOWS(crypt(M,key(sym,X))) | KNOWS(M))).
cnf(PHASE(intruder_can_compute_successors),axiom,
  (~KNOWS(M) | KNOWS(s(M)))).
cnf(PHASE(intruder_can_compute_predecessors),axiom,
  (~KNOWS(s(M)) | KNOWS(M))).

cnf(PHASE(intruder_can_hash),axiom,
  (~KNOWS(M) | KNOWS(h(M)))).

%
% Ajout des clauses du protocole
%
%
% 1. S -> P : request_id
%    where request_id is just a constant, carrying no extra information
cnf(PHASE(message1),axiom,
   (KNOWS(request_id))).
% 2. P -> S : respond_id, NAI
%    where NAI is network address identifier
cnf(PHASE(message2),axiom,
    (~KNOWS(request_id)
    | ~agent(P)
    | KNOWS(cons(respond_id, nai(P))))).
% 3. S -> P : Ns, AT_AUTN, h(h(NAI,IK,CK), Ns, AT_AUTN)
% where Ns is a fresh nonce,
%  Sqn is a sequence number, unique to the session
%  AK = f5(SK, Ns), f5 being a key generation function
%  SK is a long-term secret between S and P.
%  IK = f4(SK, Ns), f4 being a key generation function
%  CK = f3(SK, Ns), f3 being a key generation function
%  AT_AUTN = {Sqn}_AK, f1(SK, Sqn, Ns), f1 being an authentication function
#define AT_AUTN3 cons(crypt(SESSION(NAI,S,P),\
                           f5(key(sym,cons(S,cons(P,nil))),\
                              NONCES(NAI,S,P))),\
                cons(f1(key(sym,cons(S,cons(P,nil))),\
                        SESSION(NAI,S,P),\
			NONCES(NAI,S,P)),\
                nil))

cnf(PHASE(message3),axiom,
   (~KNOWS(cons(respond_id,cons(NAI,nil)))
   | ~agent(P)
   | ~agent(S)
   | KNOWS(cons(NONCES(NAI,S,P),
           cons(AT_AUTN3,
	   cons(h(cons(h(cons(NAI,
                         cons(f4(key(sym,cons(S,cons(P,nil))),
			         NONCES(NAI,S,P)),
	                 cons(f3(key(sym,cons(S,cons(P,nil))),
			         NONCES(NAI,S,P)),
		         nil)))),
		  cons(NONCES(NAI,S,P),
		  cons(AT_AUTN3,
		  nil)))),
           nil)))))).

% 4. P -> S : AT_RES, h(h(NAI,IK,CK), AT_RES)
%  AT_RES = f2(SK, Ns), f2 being an authentication function
#define AT_AUTN4 cons(crypt(Sqn,\
	                   f5(key(sym,cons(S,cons(P,nil))),\
			      Ns)),\
                cons(f1(key(sym,cons(S,cons(P,nil))),\
		        Sqn,\
			Ns),\
                nil))
#define AT_RES4 f2(key(sym,cons(S,cons(P,nil))),\
	          Ns)

cnf(PHASE(message4),axiom,
   (~KNOWS(request_id) % from premise of message2
   | ~KNOWS(cons(Ns, % from conclusion of message3
            cons(AT_AUTN4,
	    cons(h(cons(h(cons(NAI,
	                  cons(f4(key(sym,cons(S,cons(P,nil))),
			          Ns),
			  cons(f3(key(sym,cons(S,cons(P,nil))),
			          Ns),
			  nil)))),
	           cons(Ns,
		   cons(AT_AUTN4,
		   nil)))),
	    nil))))
   | KNOWS(cons(AT_RES4,
           cons(h(cons(h(cons(NAI,
	                 cons(f4(key(sym,cons(S,cons(P,nil))),
			         Ns),
			 cons(f3(key(sym,cons(S,cons(P,nil))),
			         Ns),
			 nil)))),
		  cons(AT_RES4,
		  nil))),
	   nil))))).

% 5. S -> P : success
#define AT_RES5 f2(key(sym,cons(S,cons(P,nil))),\
                  NONCES(NAI,S,P))

cnf(PHASE(message5),axiom,
   (~KNOWS(cons(respond_id,cons(NAI,nil))) % from premise of message3
   | ~KNOWS(cons(AT_RES5, % from conclusion of message4
	    cons(h(cons(h(cons(NAI,
                          cons(f4(key(sym,cons(S,cons(P,nil))),
			          NONCES(NAI,S,P)),
	                  cons(f3(key(sym,cons(S,cons(P,nil))),
				  NONCES(NAI,S,P)),
		          nil)))),
		   cons(AT_RES5,
		   nil))),
	    nil)))
   | KNOWS(success))).

   
% session key for encryption is CK
% session key for integrity check is IK.
% both should be secret.

cnf(PHASE(define_server_keys),axiom,
   (~KNOWS(cons(respond_id,cons(NAI,nil))) % from premise of message3
   | ~KNOWS(cons(AT_RES5, % from premise of message5
	    cons(h(cons(h(cons(NAI,
                          cons(f4(key(sym,cons(S,cons(P,nil))),
			          NONCES(NAI,S,P)),
	                  cons(f3(key(sym,cons(S,cons(P,nil))),
				  NONCES(NAI,S,P)),
		          nil)))),
		   cons(AT_RES5,
		   nil))),
	    nil)))
   | SERVER_KEYS(S,
                 f4(key(sym,cons(S,cons(P,nil))), % IK
		    NONCES(NAI,S,P)),
		 f3(key(sym,cons(S,cons(P,nil))), % CK
		    NONCES(NAI,S,P))))).

cnf(PHASE(define_peer_keys),axiom,
    (~KNOWS(request_id) % from premise of message2
   | ~KNOWS(cons(Ns, % from premise of message4
            cons(AT_AUTN4,
	    cons(h(cons(h(cons(NAI,
	                  cons(f4(key(sym,cons(S,cons(P,nil))),
			          Ns),
			  cons(f3(key(sym,cons(S,cons(P,nil))),
			          Ns),
			  nil)))),
	           cons(Ns,
		   cons(AT_AUTN4,
		   nil)))),
	    nil))))
  | ~KNOWS(success) % from conclusion of message5
  | PEER_KEYS(P,
              f4(key(sym,cons(S,cons(P,nil))), % IK
	         Ns),
	      f3(key(sym,cons(S,cons(P,nil))), % CK
	         Ns)))).

#undef AT_AUTN3
#undef AT_RES4
#undef AT_AUTN4
#undef AT_RES5

#undef NONCES
#undef KNOWS
#undef SESSION
#undef SERVER_KEYS
#undef PEER_KEYS

