% h1 example: the EAP-AKA protocol.
%   Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
%   This file is part of h1.
%
%   h1 is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2, or (at your option)
%   any later version.
%
%   h1 is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with h1; see the file COPYING.  If not, write to
%   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

% run 'cpp -P eap-aka.timed.p >eap-aka.p'

cnf(alice_agent,axiom,
    (agent(alice))).
cnf(bob_agent,axiom,
    (agent(bob))).
cnf(server_agent,axiom,
    (agent(server))).
cnf(intruder_agent,axiom,
    (agent(i))).

#define PHASE(s) s##_old
#include "eap-aka.phase.p"
#undef PHASE

cnf(intruder_remembers,axiom,
   (~knows_old(M) | knows_current(M))).

cnf(intruder_knows_previous_server_IK,axiom,
    (~server_keys_old(S,IK,CK)
    | knows_current(IK))).
cnf(intruder_knows_previous_server_CK,axiom,
    (~server_keys_old(S,IK,CK)
    | knows_current(CK))).
cnf(intruder_knows_previous_peer_IK,axiom,
    (~peer_keys_old(P,IK,CK)
    | knows_current(IK))).
cnf(intruder_knows_previous_peer_CK,axiom,
    (~peer_keys_old(P,IK,CK)
    | knows_current(CK))).

#define PHASE(s) s##_current
#include "eap-aka.phase.p"
#undef PHASE

cnf(intruder_knows_server_IK,axiom,
    (~server_keys_current(S,IK,CK)
    | ~knows_current(IK))).
cnf(intruder_knows_server_CK,axiom,
    (~server_keys_current(S,IK,CK)
    | ~knows_current(CK))).
cnf(intruder_knows_peer_IK,axiom,
    (~peer_keys_current(P,IK,CK)
    | ~knows_current(IK))).
cnf(intruder_knows_peer_CK,axiom,
    (~peer_keys_current(P,IK,CK)
    | ~knows_current(CK))).
