


% Bellovin and Merritt's 1992 EKE protocol (section 2.1).
% Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.

% run 'cpp -P eke.timed.p >eke.p'

% symmetric encryption as pseudorandom permutation ('cipher'):
%cnf(decenc,axiom,
% (dec(enc(X,Y),Y)=X)).
%cnf(encdec,axiom,
% (enc(dec(X,Y),Y)=X)).
% We don't use equational theories here (h1 cannot), but we
% can integrate the equations in the clauses themselves, using
% a trick already used by B. Blanchet. The trick consists in
% superposing the equations with atoms of clauses, getting
% new clauses.

% we reserve 'crypt' for asymmetric encryption and for symmetric encryption,
% but not a cipher.

%cnf(succ_pred,axiom,
% (s(p(X))=X)).
%cnf(pred_succ,axiom,
% (p(s(X))=X)).

cnf(alice_agent,axiom,
    (agent(alice))).
cnf(bob_agent,axiom,
    (agent(bob))).
cnf(server_agent,axiom,
    (agent(server))).
cnf(intruder_agent,axiom,
    (agent(i))).
% Bellovin and Merritt's 1992 EKE protocol (section 2.1).
% Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
cnf(intruder_knows_nil_old,axiom,
  (knows_old(nil))).
cnf(intruder_can_take_first_components_old,axiom,
  (~knows_old(cons(M1,M2)) | knows_old(M1))).
cnf(intruder_can_take_second_components_old,axiom,
  (~knows_old(cons(M1,M2)) | knows_old(M2))).
cnf(intruder_can_build_pairs_old,axiom,
  (~knows_old(M2) | ~knows_old(M1) | knows_old(cons(M1,M2)))).
cnf(intruder_can_encrypt_old,axiom,
  (~knows_old(K) | ~knows_old(M) | knows_old(crypt(M,K)))).
cnf(intruder_can_decrypt_if_has_private_key_old,axiom,
  (~knows_old(key(prv,K)) | ~knows_old(crypt(M,key(pub,K))) | knows_old(M))).
cnf(intruder_can_decrypt_if_has_public_key_old,axiom,
  (~knows_old(key(pub,K)) | ~knows_old(crypt(M,key(prv,K))) | knows_old(M))).
cnf(intruder_can_decrypt_if_has_symmetric_key_old,axiom,
  (~knows_old(key(sym,X)) | ~knows_old(crypt(M,key(sym,X))) | knows_old(M))).
cnf(intruder_can_compute_successors_old,axiom,
  (~knows_old(M) | knows_old(s(M)))).
% in case M=p(M'):
cnf(intruder_can_compute_successors_pred_old,axiom,
  (~knows_old(p(M)) | knows_old(M))).
cnf(intruder_can_compute_predecessors_old,axiom,
  (~knows_old(s(M)) | knows_old(M))).
% in case M=s(M)':
cnf(intruder_can_compute_predecessors_succ_old,axiom,
  (~knows_old(M) | knows_old(p(M)))).
cnf(intruder_can_enc_old,axiom,
  (~knows_old(M) | ~knows_old(K) | knows_old(enc(M,K)))).
% in case M=dec(M',K):
cnf(intruder_can_enc_dec_old,axiom,
  (~knows_old(dec(M,K)) | ~knows_old(K) | knows_old(M))).
cnf(intruder_can_dec_old,axiom,
  (~knows_old(M) | ~knows_old(K) | knows_old(dec(M,K)))).
% in case M=enc(M',K):
cnf(intruder_can_dec_enc_old,axiom,
  (~knows_old(enc(M,K)) | ~knows_old(K) | knows_old(M))).
%
% Ajout des clauses du protocole
%
%
% 1. A -> B : A, enc(Ka,Pab) % Ka, Ka^{-1} generated fresh, Pab password (=weak secret)
cnf(message1_old,axiom,
  (~agent(A) | ~agent(B)
  | knows_old(cons(A,cons(enc(key(pub,session_old(A,B)),passwd_old(A,B)),nil))))).
% 2. B -> A : enc({R}_Ka,Pab) % R is fresh, Pab shared between A and B
% final secret key is R.
cnf(message2_old,axiom,
  (~knows_old(cons(A,cons(enc(Ka,passwd_old(A,B)),nil)))
  | knows_old(enc(crypt(r_old(A,B),Ka),passwd_old(A,B))))).
% in case Ka is dec(M,passwd_old(A,B)):
cnf(message2_dec_old,axiom,
  (~knows_old(cons(A,cons(M,nil)))
  | knows_old(enc(crypt(r_old(A,B),dec(M,passwd_old(A,B))),passwd_old(A,B))))).
% 3. A -> B : {Na}_R % Na fresh
cnf(message3_old,axiom,
  (~knows_old(enc(crypt(R,key(pub,session_old(A,B))),passwd_old(A,B)))
  | knows_old(crypt(noncea_old(A,B),key(sym,R))))).
% 4. B -> A : {Na,Nb}_R % Nb fresh
cnf(message4_old,axiom,
  (~knows_old(cons(A,cons(enc(Ka,passwd_old(A,B)),nil))) % from premise of 2.
  | ~knows_old(crypt(Na,key(sym,r_old(A,B)))) % from conclusion of 3.
  | knows_old(crypt(cons(Na,cons(nonceb_old(A,B),nil)),
                key(sym,r_old(A,B)))))).
% in case Ka is dec(M,passwd_old(A,B)): [this in fact subsumes message4]
cnf(message4_dec_old,axiom,
  (~knows_old(cons(A,cons(M,nil))) % from premise of 2.
  | ~knows_old(crypt(Na,key(sym,r_old(A,B)))) % from conclusion of 3.
  | knows_old(crypt(cons(Na,cons(nonceb_old(A,B),nil)),
                key(sym,r_old(A,B)))))).
% 5. A -> B : {Nb}_R
cnf(message5_old,axiom,
  (~knows_old(enc(crypt(R,key(pub,session_old(A,B))),passwd_old(A,B))) % from premise of 3.
  | ~knows_old(crypt(cons(noncea_old(A,B),cons(Nb,nil)),
                 key(sym,R)))
  | knows_old(crypt(Nb,key(sym,R))))).
cnf(define_alice_key_old,axiom,
  (~knows_old(enc(crypt(R,key(pub,session_old(A,B))),passwd_old(A,B))) % from premise of 3.
  | ~knows_old(crypt(cons(noncea_old(A,B),cons(Nb,nil)),
                 key(sym,R)))
  | alice_key_old(A,R))).
cnf(define_bob_key_old,axiom,
  (~knows_old(cons(A,cons(enc(Ka,passwd_old(A,B)),nil))) % from premise of 2, aka 4.
  | ~knows_old(crypt(Na,key(sym,r_old(A,B)))) % from premise of 4.
  | ~knows_old(crypt(nonceb_old(A,B),key(sym,r_old(A,B)))) % from conclusion of 5.
  | bob_key_old(A,r_old(A,B)))).
% in case Ka is dec(M,passwd_old(A,B)): [this in fact subsumes define_bob_key]
cnf(define_bob_key_dec_old,axiom,
  (~knows_old(cons(A,cons(M,nil))) % from premise of 2, aka 4.
  | ~knows_old(crypt(Na,key(sym,r_old(A,B)))) % from premise of 4.
  | ~knows_old(crypt(nonceb_old(A,B),key(sym,r_old(A,B)))) % from conclusion of 5.
  | bob_key_old(A,r_old(A,B)))).
cnf(intruder_knows_all_agents_old,axiom,
  (~agent(X) | knows_old(X))).
%cnf(intruder_knows_every_public_key_old,axiom,
% (knows_old(key(pub,X)))).
cnf(intruder_knows_agents_public_key_old,axiom,
  (~agent(X) | knows_old(key(pub,X)))).
cnf(intruder_weak_secret_dec_old,axiom, % testing by decrypting with P; equivalently, by encrypting with P
  (~testable_old(M) | ~testable_old(enc(M,P)) | knows_old(P))).
% in case M=dec(M',P):
cnf(intruder_weak_secret_dec_dec_old,axiom,
  (~testable_old(dec(M,P)) | ~testable_old(M) | knows_old(P))).
cnf(known_implies_testable_old,axiom,
  (~knows_old(M) | testable_old(M))). % test by comparing M with known value
cnf(first_testable_old,axiom, % test by comparing first component, M
  (~testable_old(M) | testable_old(cons(M,L)))).
cnf(second_testable_old,axiom, % test by comparing second component, L
  (~testable_old(L) | testable_old(cons(M,L)))).
cnf(testable_pred_old,axiom, % test by computing predecessor
  (~testable_old(M) | testable_old(s(M)))).
% in case M=p(M'):
cnf(testable_pred_pred_old,axiom, % test by computing predecessor
  (~testable_old(p(M)) | testable_old(M))).
cnf(testable_succ_old,axiom, % test by computing successor
  (~testable_old(s(M)) | testable_old(M))).
% in case M=p(M'):
cnf(testable_succ_pred_old,axiom, % test by computing successor
  (~testable_old(M) | testable_old(p(M)))).
cnf(testable_decrypt_private_key_old,axiom, % test by decrypting with private key, then testing plaintext M
  (~testable_old(M) | ~knows_old(key(prv,K))
  | testable_old(crypt(M,key(pub,K))))).
cnf(testable_decrypt_public_key_old,axiom, % test by decrypting with public key, then testing plaintext M
  (~testable_old(M) | ~knows_old(key(pub,K))
  | testable_old(crypt(M,key(prv,K))))).
cnf(testable_decrypt_symmetric_key_old,axiom, % test by decrypting, then testing plaintext M
  (~testable_old(M) | ~knows_old(key(sym,X))
  | testable_old(crypt(M,key(sym,X))))).
cnf(testable_encrypt_old,axiom, % test M by encrypting with some known key K, then comparing against known message
  (~testable_old(crypt(M,K)) | ~knows_old(K)
  | testable_old(M))).
cnf(testable_decrypt_key_private_key_old,axiom, % test X=key(prv,K) by decrypting some known message crypt(M,key(pub,K)) using X, then testing resulting plaintext,
  (~testable_old(M) | ~knows_old(crypt(M,key(pub,K)))
  | testable_old(key(prv,K)))).
cnf(testable_decrypt_key_public_key_old,axiom, % test X=key(pub,K) by decrypting some known message crypt(M,key(prv,K)) using X, then testing resulting plaintext,
  (~testable_old(M) | ~knows_old(crypt(M,key(prv,K)))
  | testable_old(key(pub,K)))).
cnf(testable_decrypt_key_symmetric_key_old,axiom, % test X=key(sym,K) by decrypting some known message crypt(M,X) using X, then testing resulting plaintext,
  (~testable_old(M) | ~knows_old(crypt(M,key(sym,K)))
  | testable_old(key(sym,K)))).
cnf(testable_encrypt_key_old,axiom, % test X by encrypting some known message M using X, and testing the ciphertext
  (~testable_old(crypt(M,X)) | ~knows_old(M)
  | testable_old(X))).
cnf(testable_dec_old,axiom, % test by cipher decryption
  (~testable_old(M) | ~knows_old(K) | testable_old(enc(M,K)))).
% in case M=dec(M',K):
cnf(testable_dec_dec_old,axiom,
  (~testable_old(dec(M,K)) | ~knows_old(K) | testable_old(M))).
cnf(testable_enc_old,axiom, % test by cipher encryption
  (~testable_old(enc(M,K)) | ~knows_old(K) | testable_old(M))).
% in case M=dec(M',K):
cnf(testable_enc_dec_old,axiom,
  (~testable_old(M) | ~knows_old(K) | testable_old(dec(M,K)))).
cnf(testable_enc_key_old,axiom, % test X by encrypting some known message M using X, and testing the ciphertext
  (~testable_old(enc(M,X)) | ~knows_old(M)
  | testable_old(X))).
% in case M=dec(M',X):
cnf(testable_enc_key_dec_old,axiom, % test X by encrypting some known message M using X, and testing the ciphertext
  (~testable_old(M) | ~knows_old(dec(M,X))
  | testable_old(X))).
cnf(testable_dec_key_old,axiom, % test X by decrypting some known message M using X, and testing the ciphertext
  (~testable_old(dec(M,X)) | ~knows_old(M)
  | testable_old(X))).
% in case M=enc(M',X):
cnf(testable_dec_key_dec_old,axiom, % test X by decrypting some known message M using X, and testing the ciphertext
  (~testable_old(M) | ~knows_old(enc(M,X))
  | testable_old(X))).
cnf(intruder_knows_own_private_key_old,axiom,
  (knows_old(key(prv,i)))).
cnf(intruder_remembers,axiom,
   (~knows_old(M) | knows_current(M))).
cnf(intruder_knows_all_previous_passwords,axiom, % passwords are weak...
  (knows_current(passwd_old(A,B)))).
cnf(intruder_knows_all_previous_noncea,axiom,
    (knows_current(noncea_old(A,B)))).
cnf(intruder_knows_all_previous_nonceb,axiom,
    (knows_current(nonceb_old(A,B)))).
% Bellovin and Merritt's 1992 EKE protocol (section 2.1).
% Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
cnf(intruder_knows_nil_current,axiom,
  (knows_current(nil))).
cnf(intruder_can_take_first_components_current,axiom,
  (~knows_current(cons(M1,M2)) | knows_current(M1))).
cnf(intruder_can_take_second_components_current,axiom,
  (~knows_current(cons(M1,M2)) | knows_current(M2))).
cnf(intruder_can_build_pairs_current,axiom,
  (~knows_current(M2) | ~knows_current(M1) | knows_current(cons(M1,M2)))).
cnf(intruder_can_encrypt_current,axiom,
  (~knows_current(K) | ~knows_current(M) | knows_current(crypt(M,K)))).
cnf(intruder_can_decrypt_if_has_private_key_current,axiom,
  (~knows_current(key(prv,K)) | ~knows_current(crypt(M,key(pub,K))) | knows_current(M))).
cnf(intruder_can_decrypt_if_has_public_key_current,axiom,
  (~knows_current(key(pub,K)) | ~knows_current(crypt(M,key(prv,K))) | knows_current(M))).
cnf(intruder_can_decrypt_if_has_symmetric_key_current,axiom,
  (~knows_current(key(sym,X)) | ~knows_current(crypt(M,key(sym,X))) | knows_current(M))).
cnf(intruder_can_compute_successors_current,axiom,
  (~knows_current(M) | knows_current(s(M)))).
% in case M=p(M'):
cnf(intruder_can_compute_successors_pred_current,axiom,
  (~knows_current(p(M)) | knows_current(M))).
cnf(intruder_can_compute_predecessors_current,axiom,
  (~knows_current(s(M)) | knows_current(M))).
% in case M=s(M)':
cnf(intruder_can_compute_predecessors_succ_current,axiom,
  (~knows_current(M) | knows_current(p(M)))).
cnf(intruder_can_enc_current,axiom,
  (~knows_current(M) | ~knows_current(K) | knows_current(enc(M,K)))).
% in case M=dec(M',K):
cnf(intruder_can_enc_dec_current,axiom,
  (~knows_current(dec(M,K)) | ~knows_current(K) | knows_current(M))).
cnf(intruder_can_dec_current,axiom,
  (~knows_current(M) | ~knows_current(K) | knows_current(dec(M,K)))).
% in case M=enc(M',K):
cnf(intruder_can_dec_enc_current,axiom,
  (~knows_current(enc(M,K)) | ~knows_current(K) | knows_current(M))).
%
% Ajout des clauses du protocole
%
%
% 1. A -> B : A, enc(Ka,Pab) % Ka, Ka^{-1} generated fresh, Pab password (=weak secret)
cnf(message1_current,axiom,
  (~agent(A) | ~agent(B)
  | knows_current(cons(A,cons(enc(key(pub,session_current(A,B)),passwd_current(A,B)),nil))))).
% 2. B -> A : enc({R}_Ka,Pab) % R is fresh, Pab shared between A and B
% final secret key is R.
cnf(message2_current,axiom,
  (~knows_current(cons(A,cons(enc(Ka,passwd_current(A,B)),nil)))
  | knows_current(enc(crypt(r_current(A,B),Ka),passwd_current(A,B))))).
% in case Ka is dec(M,passwd_current(A,B)):
cnf(message2_dec_current,axiom,
  (~knows_current(cons(A,cons(M,nil)))
  | knows_current(enc(crypt(r_current(A,B),dec(M,passwd_current(A,B))),passwd_current(A,B))))).
% 3. A -> B : {Na}_R % Na fresh
cnf(message3_current,axiom,
  (~knows_current(enc(crypt(R,key(pub,session_current(A,B))),passwd_current(A,B)))
  | knows_current(crypt(noncea_current(A,B),key(sym,R))))).
% 4. B -> A : {Na,Nb}_R % Nb fresh
cnf(message4_current,axiom,
  (~knows_current(cons(A,cons(enc(Ka,passwd_current(A,B)),nil))) % from premise of 2.
  | ~knows_current(crypt(Na,key(sym,r_current(A,B)))) % from conclusion of 3.
  | knows_current(crypt(cons(Na,cons(nonceb_current(A,B),nil)),
                key(sym,r_current(A,B)))))).
% in case Ka is dec(M,passwd_current(A,B)): [this in fact subsumes message4]
cnf(message4_dec_current,axiom,
  (~knows_current(cons(A,cons(M,nil))) % from premise of 2.
  | ~knows_current(crypt(Na,key(sym,r_current(A,B)))) % from conclusion of 3.
  | knows_current(crypt(cons(Na,cons(nonceb_current(A,B),nil)),
                key(sym,r_current(A,B)))))).
% 5. A -> B : {Nb}_R
cnf(message5_current,axiom,
  (~knows_current(enc(crypt(R,key(pub,session_current(A,B))),passwd_current(A,B))) % from premise of 3.
  | ~knows_current(crypt(cons(noncea_current(A,B),cons(Nb,nil)),
                 key(sym,R)))
  | knows_current(crypt(Nb,key(sym,R))))).
cnf(define_alice_key_current,axiom,
  (~knows_current(enc(crypt(R,key(pub,session_current(A,B))),passwd_current(A,B))) % from premise of 3.
  | ~knows_current(crypt(cons(noncea_current(A,B),cons(Nb,nil)),
                 key(sym,R)))
  | alice_key_current(A,R))).
cnf(define_bob_key_current,axiom,
  (~knows_current(cons(A,cons(enc(Ka,passwd_current(A,B)),nil))) % from premise of 2, aka 4.
  | ~knows_current(crypt(Na,key(sym,r_current(A,B)))) % from premise of 4.
  | ~knows_current(crypt(nonceb_current(A,B),key(sym,r_current(A,B)))) % from conclusion of 5.
  | bob_key_current(A,r_current(A,B)))).
% in case Ka is dec(M,passwd_current(A,B)): [this in fact subsumes define_bob_key]
cnf(define_bob_key_dec_current,axiom,
  (~knows_current(cons(A,cons(M,nil))) % from premise of 2, aka 4.
  | ~knows_current(crypt(Na,key(sym,r_current(A,B)))) % from premise of 4.
  | ~knows_current(crypt(nonceb_current(A,B),key(sym,r_current(A,B)))) % from conclusion of 5.
  | bob_key_current(A,r_current(A,B)))).
cnf(intruder_knows_all_agents_current,axiom,
  (~agent(X) | knows_current(X))).
%cnf(intruder_knows_every_public_key_current,axiom,
% (knows_current(key(pub,X)))).
cnf(intruder_knows_agents_public_key_current,axiom,
  (~agent(X) | knows_current(key(pub,X)))).
cnf(intruder_weak_secret_dec_current,axiom, % testing by decrypting with P; equivalently, by encrypting with P
  (~testable_current(M) | ~testable_current(enc(M,P)) | knows_current(P))).
% in case M=dec(M',P):
cnf(intruder_weak_secret_dec_dec_current,axiom,
  (~testable_current(dec(M,P)) | ~testable_current(M) | knows_current(P))).
cnf(known_implies_testable_current,axiom,
  (~knows_current(M) | testable_current(M))). % test by comparing M with known value
cnf(first_testable_current,axiom, % test by comparing first component, M
  (~testable_current(M) | testable_current(cons(M,L)))).
cnf(second_testable_current,axiom, % test by comparing second component, L
  (~testable_current(L) | testable_current(cons(M,L)))).
cnf(testable_pred_current,axiom, % test by computing predecessor
  (~testable_current(M) | testable_current(s(M)))).
% in case M=p(M'):
cnf(testable_pred_pred_current,axiom, % test by computing predecessor
  (~testable_current(p(M)) | testable_current(M))).
cnf(testable_succ_current,axiom, % test by computing successor
  (~testable_current(s(M)) | testable_current(M))).
% in case M=p(M'):
cnf(testable_succ_pred_current,axiom, % test by computing successor
  (~testable_current(M) | testable_current(p(M)))).
cnf(testable_decrypt_private_key_current,axiom, % test by decrypting with private key, then testing plaintext M
  (~testable_current(M) | ~knows_current(key(prv,K))
  | testable_current(crypt(M,key(pub,K))))).
cnf(testable_decrypt_public_key_current,axiom, % test by decrypting with public key, then testing plaintext M
  (~testable_current(M) | ~knows_current(key(pub,K))
  | testable_current(crypt(M,key(prv,K))))).
cnf(testable_decrypt_symmetric_key_current,axiom, % test by decrypting, then testing plaintext M
  (~testable_current(M) | ~knows_current(key(sym,X))
  | testable_current(crypt(M,key(sym,X))))).
cnf(testable_encrypt_current,axiom, % test M by encrypting with some known key K, then comparing against known message
  (~testable_current(crypt(M,K)) | ~knows_current(K)
  | testable_current(M))).
cnf(testable_decrypt_key_private_key_current,axiom, % test X=key(prv,K) by decrypting some known message crypt(M,key(pub,K)) using X, then testing resulting plaintext,
  (~testable_current(M) | ~knows_current(crypt(M,key(pub,K)))
  | testable_current(key(prv,K)))).
cnf(testable_decrypt_key_public_key_current,axiom, % test X=key(pub,K) by decrypting some known message crypt(M,key(prv,K)) using X, then testing resulting plaintext,
  (~testable_current(M) | ~knows_current(crypt(M,key(prv,K)))
  | testable_current(key(pub,K)))).
cnf(testable_decrypt_key_symmetric_key_current,axiom, % test X=key(sym,K) by decrypting some known message crypt(M,X) using X, then testing resulting plaintext,
  (~testable_current(M) | ~knows_current(crypt(M,key(sym,K)))
  | testable_current(key(sym,K)))).
cnf(testable_encrypt_key_current,axiom, % test X by encrypting some known message M using X, and testing the ciphertext
  (~testable_current(crypt(M,X)) | ~knows_current(M)
  | testable_current(X))).
cnf(testable_dec_current,axiom, % test by cipher decryption
  (~testable_current(M) | ~knows_current(K) | testable_current(enc(M,K)))).
% in case M=dec(M',K):
cnf(testable_dec_dec_current,axiom,
  (~testable_current(dec(M,K)) | ~knows_current(K) | testable_current(M))).
cnf(testable_enc_current,axiom, % test by cipher encryption
  (~testable_current(enc(M,K)) | ~knows_current(K) | testable_current(M))).
% in case M=dec(M',K):
cnf(testable_enc_dec_current,axiom,
  (~testable_current(M) | ~knows_current(K) | testable_current(dec(M,K)))).
cnf(testable_enc_key_current,axiom, % test X by encrypting some known message M using X, and testing the ciphertext
  (~testable_current(enc(M,X)) | ~knows_current(M)
  | testable_current(X))).
% in case M=dec(M',X):
cnf(testable_enc_key_dec_current,axiom, % test X by encrypting some known message M using X, and testing the ciphertext
  (~testable_current(M) | ~knows_current(dec(M,X))
  | testable_current(X))).
cnf(testable_dec_key_current,axiom, % test X by decrypting some known message M using X, and testing the ciphertext
  (~testable_current(dec(M,X)) | ~knows_current(M)
  | testable_current(X))).
% in case M=enc(M',X):
cnf(testable_dec_key_dec_current,axiom, % test X by decrypting some known message M using X, and testing the ciphertext
  (~testable_current(M) | ~knows_current(enc(M,X))
  | testable_current(X))).
cnf(intruder_knows_own_private_key_current,axiom,
  (knows_current(key(prv,i)))).
cnf(intruder_knows_session_key_as_seen_by_alice,axiom,
  (~knows_current(K)
  | ~alice_key_current(alice,K))).
cnf(intruder_knows_session_key_as_seen_by_bob,axiom,
  (~knows_current(K)
  | ~bob_key_current(bob,K))).
