
% Bellovin and Merritt's 1992 EKE protocol (section 2.1).
% Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.

#define KNOWS PHASE(knows)
#define KNOWABLE PHASE(knowable)
#define TESTABLE PHASE(testable)
#define NONCEB PHASE(nonceb)
#define NONCEA PHASE(noncea)
#define SESSION PHASE(session)
#define ALICE_KEY PHASE(alice_key)
#define BOB_KEY PHASE(bob_key)
#define PASSWD PHASE(passwd)
#define RKEY PHASE(r)

cnf(PHASE(intruder_knows_nil),axiom,
  (KNOWS(nil))).
cnf(PHASE(intruder_can_take_first_components),axiom,
  (~KNOWS(cons(M1,M2)) | KNOWS(M1))).
cnf(PHASE(intruder_can_take_second_components),axiom,
  (~KNOWS(cons(M1,M2)) | KNOWS(M2))).
cnf(PHASE(intruder_can_build_pairs),axiom,
  (~KNOWS(M2) | ~KNOWS(M1) | KNOWS(cons(M1,M2)))).
cnf(PHASE(intruder_can_encrypt),axiom,
  (~KNOWS(K) | ~KNOWS(M) | KNOWS(crypt(M,K)))).
cnf(PHASE(intruder_can_decrypt_if_has_private_key),axiom,
  (~KNOWS(key(prv,K)) | ~KNOWS(crypt(M,key(pub,K))) | KNOWS(M))).
cnf(PHASE(intruder_can_decrypt_if_has_public_key),axiom,
  (~KNOWS(key(pub,K)) | ~KNOWS(crypt(M,key(prv,K))) | KNOWS(M))).
cnf(PHASE(intruder_can_decrypt_if_has_symmetric_key),axiom,
  (~KNOWS(key(sym,X)) | ~KNOWS(crypt(M,key(sym,X))) | KNOWS(M))).
cnf(PHASE(intruder_can_compute_successors),axiom,
  (~KNOWS(M) | KNOWS(s(M)))).
% in case M=p(M'):
cnf(PHASE(intruder_can_compute_successors_pred),axiom,
  (~KNOWS(p(M)) | KNOWS(M))).
cnf(PHASE(intruder_can_compute_predecessors),axiom,
  (~KNOWS(s(M)) | KNOWS(M))).
% in case M=s(M)':
cnf(PHASE(intruder_can_compute_predecessors_succ),axiom,
  (~KNOWS(M) | KNOWS(p(M)))).

cnf(PHASE(intruder_can_enc),axiom,
  (~KNOWS(M) | ~KNOWS(K) | KNOWS(enc(M,K)))).
% in case M=dec(M',K):
cnf(PHASE(intruder_can_enc_dec),axiom,
  (~KNOWS(dec(M,K)) | ~KNOWS(K) | KNOWS(M))).

cnf(PHASE(intruder_can_dec),axiom,
  (~KNOWS(M) | ~KNOWS(K) | KNOWS(dec(M,K)))).
% in case M=enc(M',K):
cnf(PHASE(intruder_can_dec_enc),axiom,
  (~KNOWS(enc(M,K)) | ~KNOWS(K) | KNOWS(M))).

%
% Ajout des clauses du protocole
%
%
% 1. A -> B : A, enc(Ka,Pab)  % Ka, Ka^{-1} generated fresh, Pab password (=weak secret)
cnf(PHASE(message1),axiom,
  (~agent(A) | ~agent(B)
  | KNOWS(cons(A,cons(enc(key(pub,SESSION(A,B)),PASSWD(A,B)),nil))))).

% 2. B -> A : enc({R}_Ka,Pab) % R is fresh, Pab shared between A and B
% final secret key is R.
cnf(PHASE(message2),axiom,
  (~KNOWS(cons(A,cons(enc(Ka,PASSWD(A,B)),nil)))
  | KNOWS(enc(crypt(RKEY(A,B),Ka),PASSWD(A,B))))).
% in case Ka is dec(M,PASSWD(A,B)):
cnf(PHASE(message2_dec),axiom,
  (~KNOWS(cons(A,cons(M,nil)))
  | KNOWS(enc(crypt(RKEY(A,B),dec(M,PASSWD(A,B))),PASSWD(A,B))))).

% 3. A -> B : {Na}_R % Na fresh
cnf(PHASE(message3),axiom,
  (~KNOWS(enc(crypt(R,key(pub,SESSION(A,B))),PASSWD(A,B)))
  | KNOWS(crypt(NONCEA(A,B),key(sym,R))))).

% 4. B -> A : {Na,Nb}_R % Nb fresh
cnf(PHASE(message4),axiom,
  (~KNOWS(cons(A,cons(enc(Ka,PASSWD(A,B)),nil))) % from premise of 2.
  | ~KNOWS(crypt(Na,key(sym,RKEY(A,B)))) % from conclusion of 3.
  | KNOWS(crypt(cons(Na,cons(NONCEB(A,B),nil)),
                key(sym,RKEY(A,B)))))).
% in case Ka is dec(M,PASSWD(A,B)): [this in fact subsumes message4]
cnf(PHASE(message4_dec),axiom,
  (~KNOWS(cons(A,cons(M,nil))) % from premise of 2.
  | ~KNOWS(crypt(Na,key(sym,RKEY(A,B)))) % from conclusion of 3.
  | KNOWS(crypt(cons(Na,cons(NONCEB(A,B),nil)),
                key(sym,RKEY(A,B)))))).

% 5. A -> B : {Nb}_R
cnf(PHASE(message5),axiom,
  (~KNOWS(enc(crypt(R,key(pub,SESSION(A,B))),PASSWD(A,B))) % from premise of 3.
  | ~KNOWS(crypt(cons(NONCEA(A,B),cons(Nb,nil)),
                 key(sym,R)))
  | KNOWS(crypt(Nb,key(sym,R))))).

cnf(PHASE(define_alice_key),axiom,
  (~KNOWS(enc(crypt(R,key(pub,SESSION(A,B))),PASSWD(A,B))) % from premise of 3.
  | ~KNOWS(crypt(cons(NONCEA(A,B),cons(Nb,nil)),
                 key(sym,R)))
  | ALICE_KEY(A,R))).

cnf(PHASE(define_bob_key),axiom,
  (~KNOWS(cons(A,cons(enc(Ka,PASSWD(A,B)),nil))) % from premise of 2, aka 4.
  | ~KNOWS(crypt(Na,key(sym,RKEY(A,B)))) % from premise of 4.
  | ~KNOWS(crypt(NONCEB(A,B),key(sym,RKEY(A,B)))) % from conclusion of 5.
  | BOB_KEY(A,RKEY(A,B)))).
% in case Ka is dec(M,PASSWD(A,B)): [this in fact subsumes define_bob_key]
cnf(PHASE(define_bob_key_dec),axiom,
  (~KNOWS(cons(A,cons(M,nil))) % from premise of 2, aka 4.
  | ~KNOWS(crypt(Na,key(sym,RKEY(A,B)))) % from premise of 4.
  | ~KNOWS(crypt(NONCEB(A,B),key(sym,RKEY(A,B)))) % from conclusion of 5.
  | BOB_KEY(A,RKEY(A,B)))).

cnf(PHASE(intruder_knows_all_agents),axiom,
  (~agent(X) | KNOWS(X))).
%cnf(PHASE(intruder_knows_every_public_key),axiom,
%  (KNOWS(key(pub,X)))).
cnf(PHASE(intruder_knows_agents_public_key),axiom,
  (~agent(X) | KNOWS(key(pub,X)))).

cnf(PHASE(intruder_weak_secret_dec),axiom, % testing by decrypting with P; equivalently, by encrypting with P
  (~TESTABLE(M) | ~TESTABLE(enc(M,P)) | KNOWS(P))).
% in case M=dec(M',P):
cnf(PHASE(intruder_weak_secret_dec_dec),axiom,
  (~TESTABLE(dec(M,P)) | ~TESTABLE(M) | KNOWS(P))).

cnf(PHASE(known_implies_testable),axiom,
  (~KNOWS(M) | TESTABLE(M))). % test by comparing M with known value
cnf(PHASE(first_testable),axiom, % test by comparing first component, M
  (~TESTABLE(M) | TESTABLE(cons(M,L)))).
cnf(PHASE(second_testable),axiom, % test by comparing second component, L
  (~TESTABLE(L) | TESTABLE(cons(M,L)))).
cnf(PHASE(testable_pred),axiom, % test by computing predecessor
  (~TESTABLE(M) | TESTABLE(s(M)))).
% in case M=p(M'):
cnf(PHASE(testable_pred_pred),axiom, % test by computing predecessor
  (~TESTABLE(p(M)) | TESTABLE(M))).
cnf(PHASE(testable_succ),axiom, % test by computing successor
  (~TESTABLE(s(M)) | TESTABLE(M))).
% in case M=p(M'):
cnf(PHASE(testable_succ_pred),axiom, % test by computing successor
  (~TESTABLE(M) | TESTABLE(p(M)))).
cnf(PHASE(testable_decrypt_private_key),axiom, % test by decrypting with private key, then testing plaintext M
  (~TESTABLE(M) | ~KNOWS(key(prv,K))
  | TESTABLE(crypt(M,key(pub,K))))).
cnf(PHASE(testable_decrypt_public_key),axiom, % test by decrypting with public key, then testing plaintext M
  (~TESTABLE(M) | ~KNOWS(key(pub,K))
  | TESTABLE(crypt(M,key(prv,K))))).
cnf(PHASE(testable_decrypt_symmetric_key),axiom, % test by decrypting, then testing plaintext M
  (~TESTABLE(M) | ~KNOWS(key(sym,X))
  | TESTABLE(crypt(M,key(sym,X))))).
cnf(PHASE(testable_encrypt),axiom, % test M by encrypting with some known key K, then comparing against known message
  (~TESTABLE(crypt(M,K)) | ~KNOWS(K)
  | TESTABLE(M))).
cnf(PHASE(testable_decrypt_key_private_key),axiom, % test X=key(prv,K) by decrypting some known message crypt(M,key(pub,K)) using X, then testing resulting plaintext,
  (~TESTABLE(M) | ~KNOWS(crypt(M,key(pub,K)))
  | TESTABLE(key(prv,K)))).
cnf(PHASE(testable_decrypt_key_public_key),axiom, % test X=key(pub,K) by decrypting some known message crypt(M,key(prv,K)) using X, then testing resulting plaintext,
  (~TESTABLE(M) | ~KNOWS(crypt(M,key(prv,K)))
  | TESTABLE(key(pub,K)))).
cnf(PHASE(testable_decrypt_key_symmetric_key),axiom, % test X=key(sym,K) by decrypting some known message crypt(M,X) using X, then testing resulting plaintext,
  (~TESTABLE(M) | ~KNOWS(crypt(M,key(sym,K)))
  | TESTABLE(key(sym,K)))).
cnf(PHASE(testable_encrypt_key),axiom, % test X by encrypting some known message M using X, and testing the ciphertext
  (~TESTABLE(crypt(M,X)) | ~KNOWS(M)
  | TESTABLE(X))).
cnf(PHASE(testable_dec),axiom, % test by cipher decryption
  (~TESTABLE(M) | ~KNOWS(K) | TESTABLE(enc(M,K)))).
% in case M=dec(M',K):
cnf(PHASE(testable_dec_dec),axiom,
  (~TESTABLE(dec(M,K)) | ~KNOWS(K) | TESTABLE(M))).
cnf(PHASE(testable_enc),axiom, % test by cipher encryption
  (~TESTABLE(enc(M,K)) | ~KNOWS(K) | TESTABLE(M))).
% in case M=dec(M',K):
cnf(PHASE(testable_enc_dec),axiom,
  (~TESTABLE(M) | ~KNOWS(K) | TESTABLE(dec(M,K)))).
cnf(PHASE(testable_enc_key),axiom, % test X by encrypting some known message M using X, and testing the ciphertext
  (~TESTABLE(enc(M,X)) | ~KNOWS(M)
  | TESTABLE(X))).
% in case M=dec(M',X):
cnf(PHASE(testable_enc_key_dec),axiom, % test X by encrypting some known message M using X, and testing the ciphertext
  (~TESTABLE(M) | ~KNOWS(dec(M,X))
  | TESTABLE(X))).
cnf(PHASE(testable_dec_key),axiom, % test X by decrypting some known message M using X, and testing the ciphertext
  (~TESTABLE(dec(M,X)) | ~KNOWS(M)
  | TESTABLE(X))).
% in case M=enc(M',X):
cnf(PHASE(testable_dec_key_dec),axiom, % test X by decrypting some known message M using X, and testing the ciphertext
  (~TESTABLE(M) | ~KNOWS(enc(M,X))
  | TESTABLE(X))).

cnf(PHASE(intruder_knows_own_private_key),axiom,
  (KNOWS(key(prv,i)))).

#undef RKEY
#undef PASSWD
#undef BOB_KEY
#undef ALICE_KEY
#undef SESSION
#undef NONCEA
#undef NONCEB
#undef TESTABLE
#undef KNOWABLE
#undef KNOWS
