
% Bellovin and Merritt's 1992 EKE protocol (section 2.1).
% Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.

% run 'cpp -P eke.timed.p >eke.p'

% symmetric encryption as pseudorandom permutation ('cipher'):
%cnf(decenc,axiom,
%    (dec(enc(X,Y),Y)=X)).
%cnf(encdec,axiom,
%    (enc(dec(X,Y),Y)=X)).
%  We don't use equational theories here (h1 cannot), but we
%  can integrate the equations in the clauses themselves, using
%  a trick already used by B. Blanchet.  The trick consists in
%  superposing the equations with atoms of clauses, getting
%  new clauses.

% we reserve 'crypt' for asymmetric encryption and for symmetric encryption,
% but not a cipher.

%cnf(succ_pred,axiom,
%    (s(p(X))=X)).
%cnf(pred_succ,axiom,
%    (p(s(X))=X)).

cnf(alice_agent,axiom,
    (agent(alice))).
cnf(bob_agent,axiom,
    (agent(bob))).
cnf(server_agent,axiom,
    (agent(server))).
cnf(intruder_agent,axiom,
    (agent(i))).

#define PHASE(s) s##_old
#include "eke.phase.p"
#undef PHASE

cnf(intruder_remembers,axiom,
   (~knows_old(M) | knows_current(M))).

cnf(intruder_knows_all_previous_passwords,axiom, % passwords are weak...
  (knows_current(passwd_old(A,B)))).
cnf(intruder_knows_all_previous_noncea,axiom,
    (knows_current(noncea_old(A,B)))).
cnf(intruder_knows_all_previous_nonceb,axiom,
    (knows_current(nonceb_old(A,B)))).

#define PHASE(s) s##_current
#include "eke.phase.p"
#undef PHASE

cnf(intruder_knows_session_key_as_seen_by_alice,axiom,
  (~knows_current(K)
  | ~alice_key_current(alice,K))).
cnf(intruder_knows_session_key_as_seen_by_bob,axiom,
  (~knows_current(K)
  | ~bob_key_current(bob,K))).
