(* [sigd] Signature definition. *)

Inductive term : Set :=
    alice : term
  | bob : term
  | cons : term -> term -> term
  | crypt : term -> term -> term
  | dec : term -> term -> term
  | enc : term -> term -> term
  | i : term
  | key : term -> term -> term
  | nil : term
  | noncea_current : term -> term -> term
  | noncea_old : term -> term -> term
  | nonceb_current : term -> term -> term
  | nonceb_old : term -> term -> term
  | p : term -> term
  | passwd_current : term -> term -> term
  | passwd_old : term -> term -> term
  | prv : term
  | pub : term
  | r_current : term -> term -> term
  | r_old : term -> term -> term
  | s : term -> term
  | server : term
  | session_current : term -> term -> term
  | session_old : term -> term -> term
  | sym : term
.

(* [modd] Model definition. *)

Inductive auto___type_9 : term -> Prop :=
    trans___type_9_1 : forall X:term, auto___type_9 X
with auto___type_10 : term -> Prop :=
    trans___type_10_1 : forall X:term, auto___type_10 X
with auto___def_9 : term -> Prop :=
    trans___def_9_nil_1 : auto___def_9 nil
with auto_alice_key_old : term -> term -> Prop :=
    trans_alice_key_old_1 : forall X1 X2:term, auto_alice_key_old X1 X2
with auto___type_12 : term -> Prop :=
    trans___type_12_crypt_1 : forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_12 (crypt X1 X2)
  | trans___type_12_crypt_2 : forall X1 X2:term, auto___type_12 X1 -> auto___def_54 X2 -> auto___type_12 (crypt X1 X2)
  | trans___type_12_crypt_3 : forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___type_12 (crypt X1 X2)
  | trans___type_12_crypt_4 : forall X1 X2:term, auto___type_11 X1 -> auto___def_52 X2 -> auto___type_12 (crypt X1 X2)
  | trans___type_12_crypt_5 : forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___type_12 (crypt X1 X2)
  | trans___type_12_crypt_6 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_12 (crypt X1 X2)
  | trans___type_12_bob_1 : auto___type_12 bob
  | trans___type_12_p_1 : forall X1:term, auto_testable_old X1 -> auto___type_12 (p X1)
  | trans___type_12_alice_1 : auto___type_12 alice
  | trans___type_12_dec_1 : forall X1 X2:term, auto_testable_old X1 -> auto_knows_old X2 -> auto___type_12 (dec X1 X2)
  | trans___type_12_enc_1 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___type_12 (enc X1 X2)
  | trans___type_12_enc_2 : forall X1 X2:term, auto___def_15 X1 -> auto___def_16 X2 -> auto___type_12 (enc X1 X2)
  | trans___type_12_enc_3 : forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto___type_12 (enc X1 X2)
  | trans___type_12_enc_4 : forall X1 X2:term, auto_testable_old X1 -> auto_knows_old X2 -> auto___type_12 (enc X1 X2)
  | trans___type_12_cons_1 : forall X1 X2:term, auto_testable_old X2 -> auto___type_12 (cons X1 X2)
  | trans___type_12_cons_2 : forall X1 X2:term, auto_testable_old X1 -> auto___type_12 (cons X1 X2)
  | trans___type_12_s_1 : forall X1:term, auto_testable_old X1 -> auto___type_12 (s X1)
  | trans___type_12_i_1 : auto___type_12 i
  | trans___type_12_nil_1 : auto___type_12 nil
  | trans___type_12_server_1 : auto___type_12 server
  | trans___type_12_key_1 : forall X1 X2:term, auto___def_60 X1 -> auto___type_16 X2 -> auto___type_12 (key X1 X2)
  | trans___type_12_key_2 : forall X1 X2:term, auto___def_55 X1 -> auto___def_4 X2 -> auto___type_12 (key X1 X2)
  | trans___type_12_key_3 : forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto___type_12 (key X1 X2)
with auto___def_25 : term -> Prop :=
    trans___def_25_key_1 : forall X1 X2:term, auto___def_26 X1 -> auto___type_4 X2 -> auto___def_25 (key X1 X2)
with auto___def_53 : term -> Prop :=
    trans___def_53_pub_1 : auto___def_53 pub
with auto___type_27 : term -> Prop :=
    trans___type_27_crypt_1 : forall X1 X2:term, auto___def_17 X1 -> auto___type_2 X2 -> auto___type_27 (crypt X1 X2)
  | trans___type_27_crypt_2 : forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_27 (crypt X1 X2)
  | trans___type_27_crypt_3 : forall X1 X2:term, auto___def_21 X1 -> auto___def_22 X2 -> auto___type_27 (crypt X1 X2)
  | trans___type_27_crypt_4 : forall X1 X2:term, auto___type_26 X1 -> auto___def_111 X2 -> auto___type_27 (crypt X1 X2)
  | trans___type_27_crypt_5 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_27 (crypt X1 X2)
  | trans___type_27_crypt_6 : forall X1 X2:term, auto___type_22 X1 -> auto___def_104 X2 -> auto___type_27 (crypt X1 X2)
  | trans___type_27_crypt_7 : forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> auto___type_27 (crypt X1 X2)
  | trans___type_27_crypt_8 : forall X1 X2:term, auto___type_27 X1 -> auto___def_113 X2 -> auto___type_27 (crypt X1 X2)
  | trans___type_27_crypt_9 : forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___type_27 (crypt X1 X2)
  | trans___type_27_crypt_10 : forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___type_27 (crypt X1 X2)
  | trans___type_27_crypt_11 : forall X1 X2:term, auto___def_84 X1 -> auto___def_85 X2 -> auto___type_27 (crypt X1 X2)
  | trans___type_27_bob_1 : auto___type_27 bob
  | trans___type_27_noncea_old_1 : forall X1 X2:term, auto___type_27 (noncea_old X1 X2)
  | trans___type_27_r_old_1 : forall X1 X2:term, auto_knows_old X1 -> auto___type_27 (r_old X1 X2)
  | trans___type_27_p_1 : forall X1:term, auto_testable_current X1 -> auto___type_27 (p X1)
  | trans___type_27_passwd_old_1 : forall X1 X2:term, auto___type_27 (passwd_old X1 X2)
  | trans___type_27_alice_1 : auto___type_27 alice
  | trans___type_27_nonceb_old_1 : forall X1 X2:term, auto___type_27 (nonceb_old X1 X2)
  | trans___type_27_dec_1 : forall X1 X2:term, auto_testable_current X1 -> auto_knows_current X2 -> auto___type_27 (dec X1 X2)
  | trans___type_27_enc_1 : forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto___type_27 (enc X1 X2)
  | trans___type_27_enc_2 : forall X1 X2:term, auto_testable_current X1 -> auto_knows_current X2 -> auto___type_27 (enc X1 X2)
  | trans___type_27_enc_3 : forall X1 X2:term, auto___def_79 X1 -> auto___def_80 X2 -> auto___type_27 (enc X1 X2)
  | trans___type_27_enc_4 : forall X1 X2:term, auto___def_75 X1 -> auto___def_76 X2 -> auto___type_27 (enc X1 X2)
  | trans___type_27_cons_1 : forall X1 X2:term, auto_testable_current X2 -> auto___type_27 (cons X1 X2)
  | trans___type_27_cons_2 : forall X1 X2:term, auto_testable_current X1 -> auto___type_27 (cons X1 X2)
  | trans___type_27_s_1 : forall X1:term, auto_testable_current X1 -> auto___type_27 (s X1)
  | trans___type_27_i_1 : auto___type_27 i
  | trans___type_27_nil_1 : auto___type_27 nil
  | trans___type_27_server_1 : auto___type_27 server
  | trans___type_27_key_1 : forall X1 X2:term, auto___def_119 X1 -> auto___type_31 X2 -> auto___type_27 (key X1 X2)
  | trans___type_27_key_2 : forall X1 X2:term, auto___def_114 X1 -> auto___def_66 X2 -> auto___type_27 (key X1 X2)
  | trans___type_27_key_3 : forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto___type_27 (key X1 X2)
  | trans___type_27_key_4 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___type_27 (key X1 X2)
with auto___def_114 : term -> Prop :=
    trans___def_114_prv_1 : auto___def_114 prv
with auto___type_20 : term -> Prop :=
    trans___type_20_nonceb_current_1 : forall X1 X2:term, auto_knows_current X1 -> auto___type_20 (nonceb_current X1 X2)
  | trans___type_20_cons_1 : forall X1 X2:term, auto___type_21 X1 -> auto___def_98 X2 -> auto___type_20 (cons X1 X2)
  | trans___type_20_noncea_current_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_20 (noncea_current X1 X2)
with auto___def_10 : term -> Prop :=
    trans___def_10_key_1 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_10 (key X1 X2)
with auto___def_87 : term -> term -> term -> Prop :=
    trans___def_87_1 : forall X1 X2 X3:term, auto___type_22 X2 -> auto_knows_current X3 -> auto___def_87 X1 X2 X3
  | trans___def_87_2 : forall X1 X2 X3:term, auto___def_96 X2 -> auto_knows_current X3 -> auto___def_87 X1 X2 X3
  | trans___def_87_3 : forall X1 X2 X3:term, auto___def_84 X2 -> auto_knows_current X3 -> auto___def_87 X1 X2 X3
with auto___def_57 : term -> Prop :=
    trans___def_57_sym_1 : auto___def_57 sym
with auto_alice_key_current : term -> term -> Prop :=
    trans_alice_key_current_1 : forall X1 X2:term, auto_agent X1 -> auto___def_94 X2 -> auto___def_77 X2 -> auto_alice_key_current X1 X2
with auto___def_90 : term -> Prop :=
    trans___def_90_cons_1 : forall X1 X2:term, auto___def_91 X1 -> auto___def_92 X2 -> auto___def_90 (cons X1 X2)
with auto___def_75 : term -> Prop :=
    trans___def_75_crypt_1 : forall X1 X2:term, auto___def_77 X1 -> auto___type_17 X2 -> auto___def_75 (crypt X1 X2)
with auto___def_58 : term -> Prop :=
    trans___def_58_prv_1 : auto___def_58 prv
with auto___def_105 : term -> Prop :=
    trans___def_105_sym_1 : auto___def_105 sym
with auto___def_93 : term -> Prop :=
    trans___def_93_sym_1 : auto___def_93 sym
with auto___def_28 : term -> Prop :=
    trans___def_28_cons_1 : forall X1 X2:term, auto___type_5 X1 -> auto___def_30 X2 -> auto___def_28 (cons X1 X2)
with auto___type_29 : term -> Prop :=
    trans___type_29_session_old_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_29 (session_old X1 X2)
  | trans___type_29_bob_1 : auto___type_29 bob
  | trans___type_29_alice_1 : auto___type_29 alice
  | trans___type_29_i_1 : auto___type_29 i
  | trans___type_29_server_1 : auto___type_29 server
with auto___def_27 : term -> term -> term -> Prop :=
    trans___def_27_1 : forall X1 X2 X3:term, auto___def_24 X2 -> auto_knows_old X3 -> auto___def_27 X1 X2 X3
  | trans___def_27_2 : forall X1 X2 X3:term, auto___def_28 X2 -> auto_knows_old X3 -> auto___def_27 X1 X2 X3
  | trans___def_27_3 : forall X1 X2 X3:term, auto___type_7 X2 -> auto_knows_old X3 -> auto___def_27 X1 X2 X3
with auto___def_31 : term -> Prop :=
    trans___def_31_nonceb_old_1 : forall X1 X2:term, auto_knows_old X1 -> auto___def_31 (nonceb_old X1 X2)
with auto___def_5 : term -> term -> Prop :=
    trans___def_5_1 : forall X1 X2:term, auto___def_42 X1 -> auto___def_36 X2 -> auto___def_5 X1 X2
  | trans___def_5_2 : forall X1 X2:term, auto___type_8 X1 -> auto___type_7 X2 -> auto___def_5 X1 X2
  | trans___def_5_3 : forall X1 X2:term, auto___type_4 X1 -> auto___def_24 X2 -> auto___def_5 X1 X2
with auto___def_4 : term -> Prop :=
    trans___def_4_bob_1 : auto___def_4 bob
  | trans___def_4_alice_1 : auto___def_4 alice
  | trans___def_4_i_1 : auto___def_4 i
  | trans___def_4_server_1 : auto___def_4 server
with auto___type_22 : term -> Prop :=
    trans___type_22_nonceb_current_1 : forall X1 X2:term, auto_knows_current X1 -> auto___type_22 (nonceb_current X1 X2)
with auto___def_34 : term -> Prop :=
    trans___def_34_r_old_1 : forall X1 X2:term, auto_knows_old X1 -> auto___def_34 (r_old X1 X2)
with auto___def_67 : term -> term -> Prop :=
    trans___def_67_1 : forall X1 X2:term, auto___type_19 X1 -> auto___def_84 X2 -> auto___def_67 X1 X2
  | trans___def_67_2 : forall X1 X2:term, auto___def_42 X1 -> auto___def_36 X2 -> auto___def_67 X1 X2
  | trans___def_67_3 : forall X1 X2:term, auto___type_23 X1 -> auto___type_22 X2 -> auto___def_67 X1 X2
  | trans___def_67_4 : forall X1 X2:term, auto___type_8 X1 -> auto___type_7 X2 -> auto___def_67 X1 X2
  | trans___def_67_5 : forall X1 X2:term, auto___def_102 X1 -> auto___def_96 X2 -> auto___def_67 X1 X2
  | trans___def_67_6 : forall X1 X2:term, auto___type_4 X1 -> auto___def_24 X2 -> auto___def_67 X1 X2
with auto___def_41 : term -> Prop :=
    trans___def_41_sym_1 : auto___def_41 sym
with auto___def_102 : term -> Prop :=
    trans___def_102_r_current_1 : forall X1 X2:term, auto_knows_current X1 -> auto___def_102 (r_current X1 X2)
with auto___type_2 : term -> Prop :=
    trans___type_2_crypt_1 : forall X1 X2:term, auto___def_17 X1 -> auto___type_2 X2 -> auto___type_2 (crypt X1 X2)
  | trans___type_2_crypt_2 : forall X1 X2:term, auto___def_21 X1 -> auto___def_22 X2 -> auto___type_2 (crypt X1 X2)
  | trans___type_2_key_1 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___type_2 (key X1 X2)
with auto_testable_old : term -> Prop :=
    trans_testable_old_crypt_1 : forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto_testable_old (crypt X1 X2)
  | trans_testable_old_crypt_2 : forall X1 X2:term, auto___type_12 X1 -> auto___def_54 X2 -> auto_testable_old (crypt X1 X2)
  | trans_testable_old_crypt_3 : forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto_testable_old (crypt X1 X2)
  | trans_testable_old_crypt_4 : forall X1 X2:term, auto___type_11 X1 -> auto___def_52 X2 -> auto_testable_old (crypt X1 X2)
  | trans_testable_old_crypt_5 : forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto_testable_old (crypt X1 X2)
  | trans_testable_old_crypt_6 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_testable_old (crypt X1 X2)
  | trans_testable_old_bob_1 : auto_testable_old bob
  | trans_testable_old_p_1 : forall X1:term, auto_testable_old X1 -> auto_testable_old (p X1)
  | trans_testable_old_alice_1 : auto_testable_old alice
  | trans_testable_old_dec_1 : forall X1 X2:term, auto_testable_old X1 -> auto_knows_old X2 -> auto_testable_old (dec X1 X2)
  | trans_testable_old_enc_1 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto_testable_old (enc X1 X2)
  | trans_testable_old_enc_2 : forall X1 X2:term, auto___def_15 X1 -> auto___def_16 X2 -> auto_testable_old (enc X1 X2)
  | trans_testable_old_enc_3 : forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto_testable_old (enc X1 X2)
  | trans_testable_old_enc_4 : forall X1 X2:term, auto_testable_old X1 -> auto_knows_old X2 -> auto_testable_old (enc X1 X2)
  | trans_testable_old_cons_1 : forall X1 X2:term, auto_testable_old X2 -> auto_testable_old (cons X1 X2)
  | trans_testable_old_cons_2 : forall X1 X2:term, auto_testable_old X1 -> auto_testable_old (cons X1 X2)
  | trans_testable_old_s_1 : forall X1:term, auto_testable_old X1 -> auto_testable_old (s X1)
  | trans_testable_old_i_1 : auto_testable_old i
  | trans_testable_old_nil_1 : auto_testable_old nil
  | trans_testable_old_server_1 : auto_testable_old server
  | trans_testable_old_key_1 : forall X1 X2:term, auto___def_60 X1 -> auto___type_16 X2 -> auto_testable_old (key X1 X2)
  | trans_testable_old_key_2 : forall X1 X2:term, auto___def_55 X1 -> auto___def_4 X2 -> auto_testable_old (key X1 X2)
  | trans_testable_old_key_3 : forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto_testable_old (key X1 X2)
with auto___def_14 : term -> term -> term -> Prop :=
    trans___def_14_1 : forall X1 X2 X3:term, auto___def_19 X2 -> auto_knows_old X3 -> auto___def_14 X1 X2 X3
  | trans___def_14_2 : forall X1 X2 X3:term, auto_agent X1 -> auto___def_10 X2 -> auto_agent X3 -> auto___def_14 X1 X2 X3
  | trans___def_14_3 : forall X1 X2 X3:term, auto___def_15 X2 -> auto_knows_old X3 -> auto___def_14 X1 X2 X3
with auto___def_99 : term -> Prop :=
    trans___def_99_nonceb_current_1 : forall X1 X2:term, auto_knows_current X1 -> auto___def_99 (nonceb_current X1 X2)
with auto___type_8 : term -> Prop :=
    trans___type_8_r_old_1 : forall X1 X2:term, auto_knows_old X1 -> auto___type_8 (r_old X1 X2)
with auto___type_6 : term -> Prop :=
    trans___type_6_noncea_old_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_6 (noncea_old X1 X2)
  | trans___type_6_nonceb_old_1 : forall X1 X2:term, auto_knows_old X1 -> auto___type_6 (nonceb_old X1 X2)
  | trans___type_6_cons_1 : forall X1 X2:term, auto___type_6 X1 -> auto___def_38 X2 -> auto___type_6 (cons X1 X2)
with auto___def_76 : term -> Prop :=
    trans___def_76_passwd_current_1 : forall X1 X2:term, auto_knows_current X1 -> auto___def_76 (passwd_current X1 X2)
with auto___def_2 : term -> Prop :=
    trans___def_2_i_1 : auto___def_2 i
with auto___def_51 : term -> Prop :=
    trans___def_51_pub_1 : auto___def_51 pub
with auto___def_92 : term -> Prop :=
    trans___def_92_nil_1 : auto___def_92 nil
with auto___def_111 : term -> Prop :=
    trans___def_111_key_1 : forall X1 X2:term, auto___def_112 X1 -> auto___def_64 X2 -> auto___def_111 (key X1 X2)
with auto___def_20 : term -> Prop :=
    trans___def_20_passwd_old_1 : forall X1 X2:term, auto_knows_old X1 -> auto___def_20 (passwd_old X1 X2)
with auto_testable_current : term -> Prop :=
    trans_testable_current_crypt_1 : forall X1 X2:term, auto___def_17 X1 -> auto___type_2 X2 -> auto_testable_current (crypt X1 X2)
  | trans_testable_current_crypt_2 : forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto_testable_current (crypt X1 X2)
  | trans_testable_current_crypt_3 : forall X1 X2:term, auto___def_21 X1 -> auto___def_22 X2 -> auto_testable_current (crypt X1 X2)
  | trans_testable_current_crypt_4 : forall X1 X2:term, auto___type_26 X1 -> auto___def_111 X2 -> auto_testable_current (crypt X1 X2)
  | trans_testable_current_crypt_5 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_testable_current (crypt X1 X2)
  | trans_testable_current_crypt_6 : forall X1 X2:term, auto___type_22 X1 -> auto___def_104 X2 -> auto_testable_current (crypt X1 X2)
  | trans_testable_current_crypt_7 : forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> auto_testable_current (crypt X1 X2)
  | trans_testable_current_crypt_8 : forall X1 X2:term, auto___type_27 X1 -> auto___def_113 X2 -> auto_testable_current (crypt X1 X2)
  | trans_testable_current_crypt_9 : forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto_testable_current (crypt X1 X2)
  | trans_testable_current_crypt_10 : forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto_testable_current (crypt X1 X2)
  | trans_testable_current_crypt_11 : forall X1 X2:term, auto___def_84 X1 -> auto___def_85 X2 -> auto_testable_current (crypt X1 X2)
  | trans_testable_current_bob_1 : auto_testable_current bob
  | trans_testable_current_noncea_old_1 : forall X1 X2:term, auto_testable_current (noncea_old X1 X2)
  | trans_testable_current_r_old_1 : forall X1 X2:term, auto_knows_old X1 -> auto_testable_current (r_old X1 X2)
  | trans_testable_current_p_1 : forall X1:term, auto_testable_current X1 -> auto_testable_current (p X1)
  | trans_testable_current_passwd_old_1 : forall X1 X2:term, auto_testable_current (passwd_old X1 X2)
  | trans_testable_current_alice_1 : auto_testable_current alice
  | trans_testable_current_nonceb_old_1 : forall X1 X2:term, auto_testable_current (nonceb_old X1 X2)
  | trans_testable_current_dec_1 : forall X1 X2:term, auto_testable_current X1 -> auto_knows_current X2 -> auto_testable_current (dec X1 X2)
  | trans_testable_current_enc_1 : forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto_testable_current (enc X1 X2)
  | trans_testable_current_enc_2 : forall X1 X2:term, auto_testable_current X1 -> auto_knows_current X2 -> auto_testable_current (enc X1 X2)
  | trans_testable_current_enc_3 : forall X1 X2:term, auto___def_79 X1 -> auto___def_80 X2 -> auto_testable_current (enc X1 X2)
  | trans_testable_current_enc_4 : forall X1 X2:term, auto___def_75 X1 -> auto___def_76 X2 -> auto_testable_current (enc X1 X2)
  | trans_testable_current_cons_1 : forall X1 X2:term, auto_testable_current X2 -> auto_testable_current (cons X1 X2)
  | trans_testable_current_cons_2 : forall X1 X2:term, auto_testable_current X1 -> auto_testable_current (cons X1 X2)
  | trans_testable_current_s_1 : forall X1:term, auto_testable_current X1 -> auto_testable_current (s X1)
  | trans_testable_current_i_1 : auto_testable_current i
  | trans_testable_current_nil_1 : auto_testable_current nil
  | trans_testable_current_server_1 : auto_testable_current server
  | trans_testable_current_key_1 : forall X1 X2:term, auto___def_119 X1 -> auto___type_31 X2 -> auto_testable_current (key X1 X2)
  | trans_testable_current_key_2 : forall X1 X2:term, auto___def_114 X1 -> auto___def_66 X2 -> auto_testable_current (key X1 X2)
  | trans_testable_current_key_3 : forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto_testable_current (key X1 X2)
  | trans_testable_current_key_4 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto_testable_current (key X1 X2)
with auto___def_23 : term -> term -> term -> Prop :=
    trans___def_23_1 : forall X1 X2 X3:term, auto___def_17 X1 -> auto_agent X2 -> auto_agent X3 -> auto___def_23 X1 X2 X3
with auto___def_72 : term -> Prop :=
    trans___def_72_passwd_current_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___def_72 (passwd_current X1 X2)
with auto___type_7 : term -> Prop :=
    trans___type_7_nonceb_old_1 : forall X1 X2:term, auto_knows_old X1 -> auto___type_7 (nonceb_old X1 X2)
with auto___type_15 : term -> Prop :=
    trans___type_15_i_1 : auto___type_15 i
with auto___def_66 : term -> Prop :=
    trans___def_66_session_old_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___def_66 (session_old X1 X2)
  | trans___def_66_bob_1 : auto___def_66 bob
  | trans___def_66_alice_1 : auto___def_66 alice
  | trans___def_66_i_1 : auto___def_66 i
  | trans___def_66_server_1 : auto___def_66 server
with auto___def_79 : term -> Prop :=
    trans___def_79_crypt_1 : forall X1 X2:term, auto___def_81 X1 -> auto___def_82 X2 -> auto___def_79 (crypt X1 X2)
with auto___def_35 : term -> term -> term -> Prop :=
    trans___def_35_1 : forall X1 X2 X3:term, auto___def_24 X2 -> auto_knows_old X3 -> auto___def_35 X1 X2 X3
  | trans___def_35_2 : forall X1 X2 X3:term, auto___def_28 X2 -> auto_knows_old X3 -> auto___def_35 X1 X2 X3
  | trans___def_35_3 : forall X1 X2 X3:term, auto___type_7 X2 -> auto_knows_old X3 -> auto___def_35 X1 X2 X3
with auto___def_103 : term -> term -> Prop :=
    trans___def_103_1 : forall X1 X2:term, auto___def_94 X1 -> auto___def_77 X1 -> auto___def_91 X2 -> auto___def_103 X1 X2
with auto___def_94 : term -> Prop :=
    trans___def_94_r_current_1 : forall X1 X2:term, auto_knows_current X1 -> auto___def_94 (r_current X1 X2)
with auto___def_96 : term -> Prop :=
    trans___def_96_cons_1 : forall X1 X2:term, auto___type_21 X1 -> auto___def_98 X2 -> auto___def_96 (cons X1 X2)
with auto___type_25 : term -> Prop :=
    trans___type_25_crypt_1 : forall X1 X2:term, auto___def_17 X1 -> auto___type_2 X2 -> auto___type_25 (crypt X1 X2)
  | trans___type_25_crypt_2 : forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_25 (crypt X1 X2)
  | trans___type_25_crypt_3 : forall X1 X2:term, auto___def_21 X1 -> auto___def_22 X2 -> auto___type_25 (crypt X1 X2)
  | trans___type_25_crypt_4 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_25 (crypt X1 X2)
  | trans___type_25_crypt_5 : forall X1 X2:term, auto___type_22 X1 -> auto___def_104 X2 -> auto___type_25 (crypt X1 X2)
  | trans___type_25_crypt_6 : forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> auto___type_25 (crypt X1 X2)
  | trans___type_25_crypt_7 : forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___type_25 (crypt X1 X2)
  | trans___type_25_crypt_8 : forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___type_25 (crypt X1 X2)
  | trans___type_25_crypt_9 : forall X1 X2:term, auto___def_84 X1 -> auto___def_85 X2 -> auto___type_25 (crypt X1 X2)
  | trans___type_25_bob_1 : auto___type_25 bob
  | trans___type_25_noncea_old_1 : forall X1 X2:term, auto___type_25 (noncea_old X1 X2)
  | trans___type_25_p_1 : forall X1:term, auto_knows_current X1 -> auto___type_25 (p X1)
  | trans___type_25_passwd_old_1 : forall X1 X2:term, auto___type_25 (passwd_old X1 X2)
  | trans___type_25_alice_1 : auto___type_25 alice
  | trans___type_25_nonceb_old_1 : forall X1 X2:term, auto___type_25 (nonceb_old X1 X2)
  | trans___type_25_dec_1 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_25 (dec X1 X2)
  | trans___type_25_enc_1 : forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto___type_25 (enc X1 X2)
  | trans___type_25_enc_2 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_25 (enc X1 X2)
  | trans___type_25_enc_3 : forall X1 X2:term, auto___def_79 X1 -> auto___def_80 X2 -> auto___type_25 (enc X1 X2)
  | trans___type_25_enc_4 : forall X1 X2:term, auto___def_75 X1 -> auto___def_76 X2 -> auto___type_25 (enc X1 X2)
  | trans___type_25_cons_1 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_25 (cons X1 X2)
  | trans___type_25_s_1 : forall X1:term, auto_knows_current X1 -> auto___type_25 (s X1)
  | trans___type_25_i_1 : auto___type_25 i
  | trans___type_25_nil_1 : auto___type_25 nil
  | trans___type_25_server_1 : auto___type_25 server
  | trans___type_25_key_1 : forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto___type_25 (key X1 X2)
  | trans___type_25_key_2 : forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto___type_25 (key X1 X2)
  | trans___type_25_key_3 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___type_25 (key X1 X2)
with auto___def_73 : term -> Prop :=
    trans___def_73_session_current_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___def_73 (session_current X1 X2)
with auto___def_44 : term -> Prop :=
    trans___def_44_key_1 : forall X1 X2:term, auto___def_45 X1 -> auto___type_8 X2 -> auto___def_44 (key X1 X2)
with auto___def_117 : term -> Prop :=
    trans___def_117_prv_1 : auto___def_117 prv
with auto___def_77 : term -> Prop :=
    trans___def_77_r_current_1 : forall X1 X2:term, auto_knows_current X1 -> auto___def_77 (r_current X1 X2)
with auto___def_109 : term -> term -> Prop :=
    trans___def_109_1 : forall X1 X2:term, auto_knows_current X2 -> auto___def_109 X1 X2
with auto___def_63 : term -> term -> Prop :=
    trans___def_63_1 : forall X1 X2:term, auto_agent X1 -> auto_knows_current X2 -> auto___def_63 X1 X2
  | trans___def_63_2 : forall X1 X2:term, auto___def_13 X1 -> auto_knows_current X2 -> auto___def_63 X1 X2
  | trans___def_63_3 : forall X1 X2:term, auto___def_13 X1 -> auto___def_17 X2 -> auto___def_63 X1 X2
with auto___def_22 : term -> Prop :=
    trans___def_22_dec_1 : forall X1 X2:term, auto___type_3 X1 -> auto___def_20 X2 -> auto___def_22 (dec X1 X2)
with auto___def_108 : term -> Prop :=
    trans___def_108_r_current_1 : forall X1 X2:term, auto_knows_current X1 -> auto___def_108 (r_current X1 X2)
with auto___def_106 : term -> term -> term -> term -> Prop :=
    trans___def_106_1 : forall X1 X2 X3 X4:term, auto___def_94 X1 -> auto_agent X2 -> auto___def_91 X3 -> auto_agent X4 -> auto___def_106 X1 X2 X3 X4
with auto___type_4 : term -> Prop :=
    trans___type_4_r_old_1 : forall X1 X2:term, auto_knows_old X1 -> auto___type_4 (r_old X1 X2)
with auto___def_84 : term -> Prop :=
    trans___def_84_noncea_current_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___def_84 (noncea_current X1 X2)
with auto___def_38 : term -> Prop :=
    trans___def_38_cons_1 : forall X1 X2:term, auto___def_39 X1 -> auto___def_40 X2 -> auto___def_38 (cons X1 X2)
with auto___def_61 : term -> Prop :=
    trans___def_61_prv_1 : auto___def_61 prv
with auto___type_11 : term -> Prop :=
    trans___type_11_crypt_1 : forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_11 (crypt X1 X2)
  | trans___type_11_crypt_2 : forall X1 X2:term, auto___type_12 X1 -> auto___def_54 X2 -> auto___type_11 (crypt X1 X2)
  | trans___type_11_crypt_3 : forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___type_11 (crypt X1 X2)
  | trans___type_11_crypt_4 : forall X1 X2:term, auto___type_11 X1 -> auto___def_52 X2 -> auto___type_11 (crypt X1 X2)
  | trans___type_11_crypt_5 : forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___type_11 (crypt X1 X2)
  | trans___type_11_crypt_6 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_11 (crypt X1 X2)
  | trans___type_11_bob_1 : auto___type_11 bob
  | trans___type_11_p_1 : forall X1:term, auto_testable_old X1 -> auto___type_11 (p X1)
  | trans___type_11_alice_1 : auto___type_11 alice
  | trans___type_11_dec_1 : forall X1 X2:term, auto_testable_old X1 -> auto_knows_old X2 -> auto___type_11 (dec X1 X2)
  | trans___type_11_enc_1 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___type_11 (enc X1 X2)
  | trans___type_11_enc_2 : forall X1 X2:term, auto___def_15 X1 -> auto___def_16 X2 -> auto___type_11 (enc X1 X2)
  | trans___type_11_enc_3 : forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto___type_11 (enc X1 X2)
  | trans___type_11_enc_4 : forall X1 X2:term, auto_testable_old X1 -> auto_knows_old X2 -> auto___type_11 (enc X1 X2)
  | trans___type_11_cons_1 : forall X1 X2:term, auto_testable_old X2 -> auto___type_11 (cons X1 X2)
  | trans___type_11_cons_2 : forall X1 X2:term, auto_testable_old X1 -> auto___type_11 (cons X1 X2)
  | trans___type_11_s_1 : forall X1:term, auto_testable_old X1 -> auto___type_11 (s X1)
  | trans___type_11_i_1 : auto___type_11 i
  | trans___type_11_nil_1 : auto___type_11 nil
  | trans___type_11_server_1 : auto___type_11 server
  | trans___type_11_key_1 : forall X1 X2:term, auto___def_60 X1 -> auto___type_16 X2 -> auto___type_11 (key X1 X2)
  | trans___type_11_key_2 : forall X1 X2:term, auto___def_55 X1 -> auto___def_4 X2 -> auto___type_11 (key X1 X2)
  | trans___type_11_key_3 : forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto___type_11 (key X1 X2)
with auto___def_81 : term -> Prop :=
    trans___def_81_r_current_1 : forall X1 X2:term, auto_knows_current X1 -> auto___def_81 (r_current X1 X2)
with auto_bob_key_current : term -> term -> Prop :=
    trans_bob_key_current_1 : forall X1 X2:term, auto___type_24 X1 -> auto___def_108 X2 -> auto_bob_key_current X1 X2
with auto___def_42 : term -> Prop :=
    trans___def_42_r_old_1 : forall X1 X2:term, auto_knows_old X1 -> auto___def_42 (r_old X1 X2)
with auto___def_85 : term -> Prop :=
    trans___def_85_key_1 : forall X1 X2:term, auto___def_86 X1 -> auto___type_19 X2 -> auto___def_85 (key X1 X2)
with auto___def_70 : term -> Prop :=
    trans___def_70_enc_1 : forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto___def_70 (enc X1 X2)
with auto___def_1 : term -> term -> Prop :=
    trans___def_1_1 : forall X1 X2:term, auto_agent X1 -> auto_knows_old X2 -> auto___def_1 X1 X2
with auto___def_110 : term -> Prop :=
    trans___def_110_r_current_1 : forall X1 X2:term, auto_knows_current X1 -> auto___def_110 (r_current X1 X2)
with auto___def_86 : term -> Prop :=
    trans___def_86_sym_1 : auto___def_86 sym
with auto_knows_current : term -> Prop :=
    trans_knows_current_crypt_1 : forall X1 X2:term, auto___def_17 X1 -> auto___type_2 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_2 : forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_3 : forall X1 X2:term, auto___def_21 X1 -> auto___def_22 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_4 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_5 : forall X1 X2:term, auto___type_22 X1 -> auto___def_104 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_6 : forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_7 : forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_8 : forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_9 : forall X1 X2:term, auto___def_84 X1 -> auto___def_85 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_bob_1 : auto_knows_current bob
  | trans_knows_current_noncea_old_1 : forall X1 X2:term, auto_knows_current (noncea_old X1 X2)
  | trans_knows_current_p_1 : forall X1:term, auto_knows_current X1 -> auto_knows_current (p X1)
  | trans_knows_current_passwd_old_1 : forall X1 X2:term, auto_knows_current (passwd_old X1 X2)
  | trans_knows_current_alice_1 : auto_knows_current alice
  | trans_knows_current_nonceb_old_1 : forall X1 X2:term, auto_knows_current (nonceb_old X1 X2)
  | trans_knows_current_dec_1 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current (dec X1 X2)
  | trans_knows_current_enc_1 : forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto_knows_current (enc X1 X2)
  | trans_knows_current_enc_2 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current (enc X1 X2)
  | trans_knows_current_enc_3 : forall X1 X2:term, auto___def_79 X1 -> auto___def_80 X2 -> auto_knows_current (enc X1 X2)
  | trans_knows_current_enc_4 : forall X1 X2:term, auto___def_75 X1 -> auto___def_76 X2 -> auto_knows_current (enc X1 X2)
  | trans_knows_current_cons_1 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current (cons X1 X2)
  | trans_knows_current_s_1 : forall X1:term, auto_knows_current X1 -> auto_knows_current (s X1)
  | trans_knows_current_i_1 : auto_knows_current i
  | trans_knows_current_nil_1 : auto_knows_current nil
  | trans_knows_current_server_1 : auto_knows_current server
  | trans_knows_current_key_1 : forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto_knows_current (key X1 X2)
  | trans_knows_current_key_2 : forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto_knows_current (key X1 X2)
  | trans_knows_current_key_3 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto_knows_current (key X1 X2)
with auto___def_19 : term -> Prop :=
    trans___def_19_crypt_1 : forall X1 X2:term, auto___def_21 X1 -> auto___def_22 X2 -> auto___def_19 (crypt X1 X2)
with auto___def_50 : term -> Prop :=
    trans___def_50_r_old_1 : forall X1 X2:term, auto___def_50 (r_old X1 X2)
with auto___def_30 : term -> Prop :=
    trans___def_30_cons_1 : forall X1 X2:term, auto___def_31 X1 -> auto___def_32 X2 -> auto___def_30 (cons X1 X2)
with auto___def_48 : term -> Prop :=
    trans___def_48_r_old_1 : forall X1 X2:term, auto___def_48 (r_old X1 X2)
with auto___def_39 : term -> Prop :=
    trans___def_39_nonceb_old_1 : forall X1 X2:term, auto_knows_old X1 -> auto___def_39 (nonceb_old X1 X2)
with auto_bob_key_old : term -> term -> Prop :=
    trans_bob_key_old_1 : forall X1 X2:term, auto_bob_key_old X1 X2
with auto___def_11 : term -> Prop :=
    trans___def_11_passwd_old_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___def_11 (passwd_old X1 X2)
with auto___def_78 : term -> term -> Prop :=
    trans___def_78_1 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___def_78 X1 X2
with auto___def_82 : term -> Prop :=
    trans___def_82_dec_1 : forall X1 X2:term, auto___type_18 X1 -> auto___def_80 X2 -> auto___def_82 (dec X1 X2)
with auto___type_5 : term -> Prop :=
    trans___type_5_noncea_old_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_5 (noncea_old X1 X2)
  | trans___type_5_nonceb_old_1 : forall X1 X2:term, auto_knows_old X1 -> auto___type_5 (nonceb_old X1 X2)
  | trans___type_5_cons_1 : forall X1 X2:term, auto___type_6 X1 -> auto___def_38 X2 -> auto___type_5 (cons X1 X2)
with auto___type_13 : term -> Prop :=
    trans___type_13_crypt_1 : forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_13 (crypt X1 X2)
  | trans___type_13_crypt_2 : forall X1 X2:term, auto___type_12 X1 -> auto___def_54 X2 -> auto___type_13 (crypt X1 X2)
  | trans___type_13_crypt_3 : forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___type_13 (crypt X1 X2)
  | trans___type_13_crypt_4 : forall X1 X2:term, auto___type_11 X1 -> auto___def_52 X2 -> auto___type_13 (crypt X1 X2)
  | trans___type_13_crypt_5 : forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___type_13 (crypt X1 X2)
  | trans___type_13_crypt_6 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_13 (crypt X1 X2)
  | trans___type_13_bob_1 : auto___type_13 bob
  | trans___type_13_p_1 : forall X1:term, auto_testable_old X1 -> auto___type_13 (p X1)
  | trans___type_13_alice_1 : auto___type_13 alice
  | trans___type_13_dec_1 : forall X1 X2:term, auto_testable_old X1 -> auto_knows_old X2 -> auto___type_13 (dec X1 X2)
  | trans___type_13_enc_1 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___type_13 (enc X1 X2)
  | trans___type_13_enc_2 : forall X1 X2:term, auto___def_15 X1 -> auto___def_16 X2 -> auto___type_13 (enc X1 X2)
  | trans___type_13_enc_3 : forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto___type_13 (enc X1 X2)
  | trans___type_13_enc_4 : forall X1 X2:term, auto_testable_old X1 -> auto_knows_old X2 -> auto___type_13 (enc X1 X2)
  | trans___type_13_cons_1 : forall X1 X2:term, auto_testable_old X2 -> auto___type_13 (cons X1 X2)
  | trans___type_13_cons_2 : forall X1 X2:term, auto_testable_old X1 -> auto___type_13 (cons X1 X2)
  | trans___type_13_s_1 : forall X1:term, auto_testable_old X1 -> auto___type_13 (s X1)
  | trans___type_13_i_1 : auto___type_13 i
  | trans___type_13_nil_1 : auto___type_13 nil
  | trans___type_13_server_1 : auto___type_13 server
  | trans___type_13_key_1 : forall X1 X2:term, auto___def_60 X1 -> auto___type_16 X2 -> auto___type_13 (key X1 X2)
  | trans___type_13_key_2 : forall X1 X2:term, auto___def_55 X1 -> auto___def_4 X2 -> auto___type_13 (key X1 X2)
  | trans___type_13_key_3 : forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto___type_13 (key X1 X2)
with auto___def_101 : term -> Prop :=
    trans___def_101_sym_1 : auto___def_101 sym
with auto___def_49 : term -> term -> Prop :=
    trans___def_49_1 : forall X1 X2:term, auto___def_49 X1 X2
with auto___def_7 : term -> Prop :=
    trans___def_7_cons_1 : forall X1 X2:term, auto___def_8 X1 -> auto___def_9 X2 -> auto___def_7 (cons X1 X2)
with auto___def_91 : term -> Prop :=
    trans___def_91_nonceb_current_1 : forall X1 X2:term, auto_knows_current X1 -> auto___def_91 (nonceb_current X1 X2)
with auto___def_46 : term -> term -> term -> term -> Prop :=
    trans___def_46_1 : forall X1 X2 X3 X4:term, auto___def_46 X1 X2 X3 X4
with auto___def_118 : term -> Prop :=
    trans___def_118_pub_1 : auto___def_118 pub
with auto___type_30 : term -> Prop :=
    trans___type_30_i_1 : auto___type_30 i
with auto___type_31 : term -> Prop :=
    trans___type_31_r_old_1 : forall X1 X2:term, auto_knows_old X1 -> auto___type_31 (r_old X1 X2)
  | trans___type_31_r_current_1 : forall X1 X2:term, auto_knows_current X1 -> auto___type_31 (r_current X1 X2)
with auto___def_24 : term -> Prop :=
    trans___def_24_noncea_old_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___def_24 (noncea_old X1 X2)
with auto___def_100 : term -> Prop :=
    trans___def_100_nil_1 : auto___def_100 nil
with auto___def_119 : term -> Prop :=
    trans___def_119_sym_1 : auto___def_119 sym
with auto___def_60 : term -> Prop :=
    trans___def_60_sym_1 : auto___def_60 sym
with auto___def_55 : term -> Prop :=
    trans___def_55_prv_1 : auto___def_55 prv
with auto___def_47 : term -> term -> Prop :=
    trans___def_47_1 : forall X1 X2:term, auto___def_47 X1 X2
with auto___def_45 : term -> Prop :=
    trans___def_45_sym_1 : auto___def_45 sym
with auto___def_54 : term -> Prop :=
    trans___def_54_key_1 : forall X1 X2:term, auto___def_55 X1 -> auto___def_4 X2 -> auto___def_54 (key X1 X2)
with auto___def_52 : term -> Prop :=
    trans___def_52_key_1 : forall X1 X2:term, auto___def_53 X1 -> auto___def_2 X2 -> auto___def_52 (key X1 X2)
with auto___type_24 : term -> Prop :=
    trans___type_24_crypt_1 : forall X1 X2:term, auto___def_17 X1 -> auto___type_2 X2 -> auto___type_24 (crypt X1 X2)
  | trans___type_24_crypt_2 : forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_24 (crypt X1 X2)
  | trans___type_24_crypt_3 : forall X1 X2:term, auto___def_21 X1 -> auto___def_22 X2 -> auto___type_24 (crypt X1 X2)
  | trans___type_24_crypt_4 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_24 (crypt X1 X2)
  | trans___type_24_crypt_5 : forall X1 X2:term, auto___type_22 X1 -> auto___def_104 X2 -> auto___type_24 (crypt X1 X2)
  | trans___type_24_crypt_6 : forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> auto___type_24 (crypt X1 X2)
  | trans___type_24_crypt_7 : forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___type_24 (crypt X1 X2)
  | trans___type_24_crypt_8 : forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___type_24 (crypt X1 X2)
  | trans___type_24_crypt_9 : forall X1 X2:term, auto___def_84 X1 -> auto___def_85 X2 -> auto___type_24 (crypt X1 X2)
  | trans___type_24_bob_1 : auto___type_24 bob
  | trans___type_24_noncea_old_1 : forall X1 X2:term, auto___type_24 (noncea_old X1 X2)
  | trans___type_24_p_1 : forall X1:term, auto_knows_current X1 -> auto___type_24 (p X1)
  | trans___type_24_passwd_old_1 : forall X1 X2:term, auto___type_24 (passwd_old X1 X2)
  | trans___type_24_alice_1 : auto___type_24 alice
  | trans___type_24_nonceb_old_1 : forall X1 X2:term, auto___type_24 (nonceb_old X1 X2)
  | trans___type_24_dec_1 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_24 (dec X1 X2)
  | trans___type_24_enc_1 : forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto___type_24 (enc X1 X2)
  | trans___type_24_enc_2 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_24 (enc X1 X2)
  | trans___type_24_enc_3 : forall X1 X2:term, auto___def_79 X1 -> auto___def_80 X2 -> auto___type_24 (enc X1 X2)
  | trans___type_24_enc_4 : forall X1 X2:term, auto___def_75 X1 -> auto___def_76 X2 -> auto___type_24 (enc X1 X2)
  | trans___type_24_cons_1 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_24 (cons X1 X2)
  | trans___type_24_s_1 : forall X1:term, auto_knows_current X1 -> auto___type_24 (s X1)
  | trans___type_24_i_1 : auto___type_24 i
  | trans___type_24_nil_1 : auto___type_24 nil
  | trans___type_24_server_1 : auto___type_24 server
  | trans___type_24_key_1 : forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto___type_24 (key X1 X2)
  | trans___type_24_key_2 : forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto___type_24 (key X1 X2)
  | trans___type_24_key_3 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___type_24 (key X1 X2)
with auto___def_26 : term -> Prop :=
    trans___def_26_sym_1 : auto___def_26 sym
with auto___def_116 : term -> Prop :=
    trans___def_116_sym_1 : auto___def_116 sym
with auto___def_80 : term -> Prop :=
    trans___def_80_passwd_current_1 : forall X1 X2:term, auto_knows_current X1 -> auto___def_80 (passwd_current X1 X2)
with auto___type_16 : term -> Prop :=
    trans___type_16_r_old_1 : forall X1 X2:term, auto_knows_old X1 -> auto___type_16 (r_old X1 X2)
with auto___def_12 : term -> Prop :=
    trans___def_12_pub_1 : auto___def_12 pub
with auto___def_65 : term -> term -> Prop :=
    trans___def_65_1 : forall X1 X2:term, auto___def_62 X1 -> auto_knows_current X2 -> auto___def_65 X1 X2
with auto___def_113 : term -> Prop :=
    trans___def_113_key_1 : forall X1 X2:term, auto___def_114 X1 -> auto___def_66 X2 -> auto___def_113 (key X1 X2)
with auto___def_3 : term -> term -> Prop :=
    trans___def_3_1 : forall X1 X2:term, auto___def_62 X1 -> auto_knows_old X2 -> auto___def_3 X1 X2
with auto___def_88 : term -> Prop :=
    trans___def_88_cons_1 : forall X1 X2:term, auto___type_20 X1 -> auto___def_90 X2 -> auto___def_88 (cons X1 X2)
with auto___def_89 : term -> Prop :=
    trans___def_89_key_1 : forall X1 X2:term, auto___def_93 X1 -> auto___def_94 X2 -> auto___def_89 (key X1 X2)
with auto___def_104 : term -> Prop :=
    trans___def_104_key_1 : forall X1 X2:term, auto___def_105 X1 -> auto___type_23 X2 -> auto___def_104 (key X1 X2)
with auto___def_32 : term -> Prop :=
    trans___def_32_nil_1 : auto___def_32 nil
with auto___def_62 : term -> Prop :=
    trans___def_62_i_1 : auto___def_62 i
with auto___type_28 : term -> Prop :=
    trans___type_28_crypt_1 : forall X1 X2:term, auto___def_17 X1 -> auto___type_2 X2 -> auto___type_28 (crypt X1 X2)
  | trans___type_28_crypt_2 : forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_28 (crypt X1 X2)
  | trans___type_28_crypt_3 : forall X1 X2:term, auto___def_21 X1 -> auto___def_22 X2 -> auto___type_28 (crypt X1 X2)
  | trans___type_28_crypt_4 : forall X1 X2:term, auto___type_26 X1 -> auto___def_111 X2 -> auto___type_28 (crypt X1 X2)
  | trans___type_28_crypt_5 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_28 (crypt X1 X2)
  | trans___type_28_crypt_6 : forall X1 X2:term, auto___type_22 X1 -> auto___def_104 X2 -> auto___type_28 (crypt X1 X2)
  | trans___type_28_crypt_7 : forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> auto___type_28 (crypt X1 X2)
  | trans___type_28_crypt_8 : forall X1 X2:term, auto___type_27 X1 -> auto___def_113 X2 -> auto___type_28 (crypt X1 X2)
  | trans___type_28_crypt_9 : forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___type_28 (crypt X1 X2)
  | trans___type_28_crypt_10 : forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___type_28 (crypt X1 X2)
  | trans___type_28_crypt_11 : forall X1 X2:term, auto___def_84 X1 -> auto___def_85 X2 -> auto___type_28 (crypt X1 X2)
  | trans___type_28_bob_1 : auto___type_28 bob
  | trans___type_28_noncea_old_1 : forall X1 X2:term, auto___type_28 (noncea_old X1 X2)
  | trans___type_28_r_old_1 : forall X1 X2:term, auto_knows_old X1 -> auto___type_28 (r_old X1 X2)
  | trans___type_28_p_1 : forall X1:term, auto_testable_current X1 -> auto___type_28 (p X1)
  | trans___type_28_passwd_old_1 : forall X1 X2:term, auto___type_28 (passwd_old X1 X2)
  | trans___type_28_alice_1 : auto___type_28 alice
  | trans___type_28_nonceb_old_1 : forall X1 X2:term, auto___type_28 (nonceb_old X1 X2)
  | trans___type_28_dec_1 : forall X1 X2:term, auto_testable_current X1 -> auto_knows_current X2 -> auto___type_28 (dec X1 X2)
  | trans___type_28_enc_1 : forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto___type_28 (enc X1 X2)
  | trans___type_28_enc_2 : forall X1 X2:term, auto_testable_current X1 -> auto_knows_current X2 -> auto___type_28 (enc X1 X2)
  | trans___type_28_enc_3 : forall X1 X2:term, auto___def_79 X1 -> auto___def_80 X2 -> auto___type_28 (enc X1 X2)
  | trans___type_28_enc_4 : forall X1 X2:term, auto___def_75 X1 -> auto___def_76 X2 -> auto___type_28 (enc X1 X2)
  | trans___type_28_cons_1 : forall X1 X2:term, auto_testable_current X2 -> auto___type_28 (cons X1 X2)
  | trans___type_28_cons_2 : forall X1 X2:term, auto_testable_current X1 -> auto___type_28 (cons X1 X2)
  | trans___type_28_s_1 : forall X1:term, auto_testable_current X1 -> auto___type_28 (s X1)
  | trans___type_28_i_1 : auto___type_28 i
  | trans___type_28_nil_1 : auto___type_28 nil
  | trans___type_28_server_1 : auto___type_28 server
  | trans___type_28_key_1 : forall X1 X2:term, auto___def_119 X1 -> auto___type_31 X2 -> auto___type_28 (key X1 X2)
  | trans___type_28_key_2 : forall X1 X2:term, auto___def_114 X1 -> auto___def_66 X2 -> auto___type_28 (key X1 X2)
  | trans___type_28_key_3 : forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto___type_28 (key X1 X2)
  | trans___type_28_key_4 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___type_28 (key X1 X2)
with auto___def_83 : term -> term -> term -> Prop :=
    trans___def_83_1 : forall X1 X2 X3:term, auto___def_77 X1 -> auto_agent X2 -> auto_agent X3 -> auto___def_83 X1 X2 X3
with auto___def_17 : term -> Prop :=
    trans___def_17_r_old_1 : forall X1 X2:term, auto_knows_old X1 -> auto___def_17 (r_old X1 X2)
with auto___def_59 : term -> Prop :=
    trans___def_59_pub_1 : auto___def_59 pub
with auto___def_97 : term -> Prop :=
    trans___def_97_key_1 : forall X1 X2:term, auto___def_101 X1 -> auto___def_102 X2 -> auto___def_97 (key X1 X2)
with auto___def_98 : term -> Prop :=
    trans___def_98_cons_1 : forall X1 X2:term, auto___def_99 X1 -> auto___def_100 X2 -> auto___def_98 (cons X1 X2)
with auto___def_71 : term -> Prop :=
    trans___def_71_key_1 : forall X1 X2:term, auto___def_12 X1 -> auto___def_73 X2 -> auto___def_71 (key X1 X2)
with auto_agent : term -> Prop :=
    trans_agent_bob_1 : auto_agent bob
  | trans_agent_alice_1 : auto_agent alice
  | trans_agent_i_1 : auto_agent i
  | trans_agent_server_1 : auto_agent server
with auto___def_69 : term -> Prop :=
    trans___def_69_cons_1 : forall X1 X2:term, auto___def_70 X1 -> auto___def_9 X2 -> auto___def_69 (cons X1 X2)
with auto___def_33 : term -> Prop :=
    trans___def_33_sym_1 : auto___def_33 sym
with auto___type_14 : term -> Prop :=
    trans___type_14_bob_1 : auto___type_14 bob
  | trans___type_14_alice_1 : auto___type_14 alice
  | trans___type_14_i_1 : auto___type_14 i
  | trans___type_14_server_1 : auto___type_14 server
with auto___type_19 : term -> Prop :=
    trans___type_19_r_current_1 : forall X1 X2:term, auto_knows_current X1 -> auto___type_19 (r_current X1 X2)
with auto_knows_old : term -> Prop :=
    trans_knows_old_crypt_1 : forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_crypt_2 : forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_crypt_3 : forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_crypt_4 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_bob_1 : auto_knows_old bob
  | trans_knows_old_p_1 : forall X1:term, auto_knows_old X1 -> auto_knows_old (p X1)
  | trans_knows_old_alice_1 : auto_knows_old alice
  | trans_knows_old_dec_1 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old (dec X1 X2)
  | trans_knows_old_enc_1 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto_knows_old (enc X1 X2)
  | trans_knows_old_enc_2 : forall X1 X2:term, auto___def_15 X1 -> auto___def_16 X2 -> auto_knows_old (enc X1 X2)
  | trans_knows_old_enc_3 : forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto_knows_old (enc X1 X2)
  | trans_knows_old_enc_4 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old (enc X1 X2)
  | trans_knows_old_cons_1 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old (cons X1 X2)
  | trans_knows_old_s_1 : forall X1:term, auto_knows_old X1 -> auto_knows_old (s X1)
  | trans_knows_old_i_1 : auto_knows_old i
  | trans_knows_old_nil_1 : auto_knows_old nil
  | trans_knows_old_server_1 : auto_knows_old server
  | trans_knows_old_key_1 : forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto_knows_old (key X1 X2)
  | trans_knows_old_key_2 : forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto_knows_old (key X1 X2)
with auto___def_37 : term -> Prop :=
    trans___def_37_key_1 : forall X1 X2:term, auto___def_41 X1 -> auto___def_42 X2 -> auto___def_37 (key X1 X2)
with auto___def_112 : term -> Prop :=
    trans___def_112_pub_1 : auto___def_112 pub
with auto___def_13 : term -> Prop :=
    trans___def_13_session_old_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___def_13 (session_old X1 X2)
with auto___def_40 : term -> Prop :=
    trans___def_40_nil_1 : auto___def_40 nil
with auto___def_64 : term -> Prop :=
    trans___def_64_i_1 : auto___def_64 i
with auto___def_8 : term -> Prop :=
    trans___def_8_enc_1 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_8 (enc X1 X2)
with auto___type_3 : term -> Prop :=
    trans___type_3_crypt_1 : forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_3 (crypt X1 X2)
  | trans___type_3_crypt_2 : forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___type_3 (crypt X1 X2)
  | trans___type_3_crypt_3 : forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___type_3 (crypt X1 X2)
  | trans___type_3_crypt_4 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_3 (crypt X1 X2)
  | trans___type_3_bob_1 : auto___type_3 bob
  | trans___type_3_p_1 : forall X1:term, auto_knows_old X1 -> auto___type_3 (p X1)
  | trans___type_3_alice_1 : auto___type_3 alice
  | trans___type_3_dec_1 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_3 (dec X1 X2)
  | trans___type_3_enc_1 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___type_3 (enc X1 X2)
  | trans___type_3_enc_2 : forall X1 X2:term, auto___def_15 X1 -> auto___def_16 X2 -> auto___type_3 (enc X1 X2)
  | trans___type_3_enc_3 : forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto___type_3 (enc X1 X2)
  | trans___type_3_enc_4 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_3 (enc X1 X2)
  | trans___type_3_cons_1 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_3 (cons X1 X2)
  | trans___type_3_s_1 : forall X1:term, auto_knows_old X1 -> auto___type_3 (s X1)
  | trans___type_3_i_1 : auto___type_3 i
  | trans___type_3_nil_1 : auto___type_3 nil
  | trans___type_3_server_1 : auto___type_3 server
  | trans___type_3_key_1 : forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto___type_3 (key X1 X2)
  | trans___type_3_key_2 : forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto___type_3 (key X1 X2)
with auto___def_36 : term -> Prop :=
    trans___def_36_cons_1 : forall X1 X2:term, auto___type_6 X1 -> auto___def_38 X2 -> auto___def_36 (cons X1 X2)
with auto___type_1 : term -> Prop :=
    trans___type_1_bob_1 : auto___type_1 bob
  | trans___type_1_alice_1 : auto___type_1 alice
  | trans___type_1_i_1 : auto___type_1 i
  | trans___type_1_server_1 : auto___type_1 server
with auto___def_29 : term -> Prop :=
    trans___def_29_key_1 : forall X1 X2:term, auto___def_33 X1 -> auto___def_34 X2 -> auto___def_29 (key X1 X2)
with auto___type_26 : term -> Prop :=
    trans___type_26_crypt_1 : forall X1 X2:term, auto___def_17 X1 -> auto___type_2 X2 -> auto___type_26 (crypt X1 X2)
  | trans___type_26_crypt_2 : forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_26 (crypt X1 X2)
  | trans___type_26_crypt_3 : forall X1 X2:term, auto___def_21 X1 -> auto___def_22 X2 -> auto___type_26 (crypt X1 X2)
  | trans___type_26_crypt_4 : forall X1 X2:term, auto___type_26 X1 -> auto___def_111 X2 -> auto___type_26 (crypt X1 X2)
  | trans___type_26_crypt_5 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_26 (crypt X1 X2)
  | trans___type_26_crypt_6 : forall X1 X2:term, auto___type_22 X1 -> auto___def_104 X2 -> auto___type_26 (crypt X1 X2)
  | trans___type_26_crypt_7 : forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> auto___type_26 (crypt X1 X2)
  | trans___type_26_crypt_8 : forall X1 X2:term, auto___type_27 X1 -> auto___def_113 X2 -> auto___type_26 (crypt X1 X2)
  | trans___type_26_crypt_9 : forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___type_26 (crypt X1 X2)
  | trans___type_26_crypt_10 : forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___type_26 (crypt X1 X2)
  | trans___type_26_crypt_11 : forall X1 X2:term, auto___def_84 X1 -> auto___def_85 X2 -> auto___type_26 (crypt X1 X2)
  | trans___type_26_bob_1 : auto___type_26 bob
  | trans___type_26_noncea_old_1 : forall X1 X2:term, auto___type_26 (noncea_old X1 X2)
  | trans___type_26_r_old_1 : forall X1 X2:term, auto_knows_old X1 -> auto___type_26 (r_old X1 X2)
  | trans___type_26_p_1 : forall X1:term, auto_testable_current X1 -> auto___type_26 (p X1)
  | trans___type_26_passwd_old_1 : forall X1 X2:term, auto___type_26 (passwd_old X1 X2)
  | trans___type_26_alice_1 : auto___type_26 alice
  | trans___type_26_nonceb_old_1 : forall X1 X2:term, auto___type_26 (nonceb_old X1 X2)
  | trans___type_26_dec_1 : forall X1 X2:term, auto_testable_current X1 -> auto_knows_current X2 -> auto___type_26 (dec X1 X2)
  | trans___type_26_enc_1 : forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto___type_26 (enc X1 X2)
  | trans___type_26_enc_2 : forall X1 X2:term, auto_testable_current X1 -> auto_knows_current X2 -> auto___type_26 (enc X1 X2)
  | trans___type_26_enc_3 : forall X1 X2:term, auto___def_79 X1 -> auto___def_80 X2 -> auto___type_26 (enc X1 X2)
  | trans___type_26_enc_4 : forall X1 X2:term, auto___def_75 X1 -> auto___def_76 X2 -> auto___type_26 (enc X1 X2)
  | trans___type_26_cons_1 : forall X1 X2:term, auto_testable_current X2 -> auto___type_26 (cons X1 X2)
  | trans___type_26_cons_2 : forall X1 X2:term, auto_testable_current X1 -> auto___type_26 (cons X1 X2)
  | trans___type_26_s_1 : forall X1:term, auto_testable_current X1 -> auto___type_26 (s X1)
  | trans___type_26_i_1 : auto___type_26 i
  | trans___type_26_nil_1 : auto___type_26 nil
  | trans___type_26_server_1 : auto___type_26 server
  | trans___type_26_key_1 : forall X1 X2:term, auto___def_119 X1 -> auto___type_31 X2 -> auto___type_26 (key X1 X2)
  | trans___type_26_key_2 : forall X1 X2:term, auto___def_114 X1 -> auto___def_66 X2 -> auto___type_26 (key X1 X2)
  | trans___type_26_key_3 : forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto___type_26 (key X1 X2)
  | trans___type_26_key_4 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___type_26 (key X1 X2)
with auto___type_17 : term -> Prop :=
    trans___type_17_crypt_1 : forall X1 X2:term, auto___def_77 X1 -> auto___type_17 X2 -> auto___type_17 (crypt X1 X2)
  | trans___type_17_crypt_2 : forall X1 X2:term, auto___def_81 X1 -> auto___def_82 X2 -> auto___type_17 (crypt X1 X2)
  | trans___type_17_key_1 : forall X1 X2:term, auto___def_12 X1 -> auto___def_73 X2 -> auto___type_17 (key X1 X2)
with auto___type_18 : term -> Prop :=
    trans___type_18_crypt_1 : forall X1 X2:term, auto___def_17 X1 -> auto___type_2 X2 -> auto___type_18 (crypt X1 X2)
  | trans___type_18_crypt_2 : forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_18 (crypt X1 X2)
  | trans___type_18_crypt_3 : forall X1 X2:term, auto___def_21 X1 -> auto___def_22 X2 -> auto___type_18 (crypt X1 X2)
  | trans___type_18_crypt_4 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_18 (crypt X1 X2)
  | trans___type_18_crypt_5 : forall X1 X2:term, auto___type_22 X1 -> auto___def_104 X2 -> auto___type_18 (crypt X1 X2)
  | trans___type_18_crypt_6 : forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> auto___type_18 (crypt X1 X2)
  | trans___type_18_crypt_7 : forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___type_18 (crypt X1 X2)
  | trans___type_18_crypt_8 : forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___type_18 (crypt X1 X2)
  | trans___type_18_crypt_9 : forall X1 X2:term, auto___def_84 X1 -> auto___def_85 X2 -> auto___type_18 (crypt X1 X2)
  | trans___type_18_bob_1 : auto___type_18 bob
  | trans___type_18_noncea_old_1 : forall X1 X2:term, auto___type_18 (noncea_old X1 X2)
  | trans___type_18_p_1 : forall X1:term, auto_knows_current X1 -> auto___type_18 (p X1)
  | trans___type_18_passwd_old_1 : forall X1 X2:term, auto___type_18 (passwd_old X1 X2)
  | trans___type_18_alice_1 : auto___type_18 alice
  | trans___type_18_nonceb_old_1 : forall X1 X2:term, auto___type_18 (nonceb_old X1 X2)
  | trans___type_18_dec_1 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_18 (dec X1 X2)
  | trans___type_18_enc_1 : forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto___type_18 (enc X1 X2)
  | trans___type_18_enc_2 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_18 (enc X1 X2)
  | trans___type_18_enc_3 : forall X1 X2:term, auto___def_79 X1 -> auto___def_80 X2 -> auto___type_18 (enc X1 X2)
  | trans___type_18_enc_4 : forall X1 X2:term, auto___def_75 X1 -> auto___def_76 X2 -> auto___type_18 (enc X1 X2)
  | trans___type_18_cons_1 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_18 (cons X1 X2)
  | trans___type_18_s_1 : forall X1:term, auto_knows_current X1 -> auto___type_18 (s X1)
  | trans___type_18_i_1 : auto___type_18 i
  | trans___type_18_nil_1 : auto___type_18 nil
  | trans___type_18_server_1 : auto___type_18 server
  | trans___type_18_key_1 : forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto___type_18 (key X1 X2)
  | trans___type_18_key_2 : forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto___type_18 (key X1 X2)
  | trans___type_18_key_3 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___type_18 (key X1 X2)
with auto___def_107 : term -> term -> Prop :=
    trans___def_107_1 : forall X1 X2:term, auto_knows_current X2 -> auto___def_107 X1 X2
with auto___def_74 : term -> term -> term -> Prop :=
    trans___def_74_1 : forall X1 X2 X3:term, auto___def_75 X2 -> auto_knows_current X3 -> auto___def_74 X1 X2 X3
  | trans___def_74_2 : forall X1 X2 X3:term, auto___def_79 X2 -> auto_knows_current X3 -> auto___def_74 X1 X2 X3
  | trans___def_74_3 : forall X1 X2 X3:term, auto_agent X1 -> auto___def_71 X2 -> auto_agent X3 -> auto___def_74 X1 X2 X3
with auto___def_15 : term -> Prop :=
    trans___def_15_crypt_1 : forall X1 X2:term, auto___def_17 X1 -> auto___type_2 X2 -> auto___def_15 (crypt X1 X2)
with auto___type_23 : term -> Prop :=
    trans___type_23_r_current_1 : forall X1 X2:term, auto_knows_current X1 -> auto___type_23 (r_current X1 X2)
with auto___def_18 : term -> term -> Prop :=
    trans___def_18_1 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___def_18 X1 X2
with auto___def_95 : term -> term -> term -> Prop :=
    trans___def_95_1 : forall X1 X2 X3:term, auto___type_22 X2 -> auto_knows_current X3 -> auto___def_95 X1 X2 X3
  | trans___def_95_2 : forall X1 X2 X3:term, auto___def_96 X2 -> auto_knows_current X3 -> auto___def_95 X1 X2 X3
  | trans___def_95_3 : forall X1 X2 X3:term, auto___def_84 X2 -> auto_knows_current X3 -> auto___def_95 X1 X2 X3
with auto___def_21 : term -> Prop :=
    trans___def_21_r_old_1 : forall X1 X2:term, auto_knows_old X1 -> auto___def_21 (r_old X1 X2)
with auto___def_16 : term -> Prop :=
    trans___def_16_passwd_old_1 : forall X1 X2:term, auto_knows_old X1 -> auto___def_16 (passwd_old X1 X2)
with auto___def_43 : term -> term -> Prop :=
    trans___def_43_1 : forall X1 X2:term, auto___def_42 X1 -> auto___def_17 X1 -> auto___def_39 X2 -> auto___def_43 X1 X2
with auto___type_21 : term -> Prop :=
    trans___type_21_nonceb_current_1 : forall X1 X2:term, auto_knows_current X1 -> auto___type_21 (nonceb_current X1 X2)
  | trans___type_21_cons_1 : forall X1 X2:term, auto___type_21 X1 -> auto___def_98 X2 -> auto___type_21 (cons X1 X2)
  | trans___type_21_noncea_current_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_21 (noncea_current X1 X2)
with auto___def_6 : term -> Prop :=
with auto___def_68 : term -> Prop :=
with auto___def_56 : term -> Prop :=
with auto___def_115 : term -> Prop :=
with auto___query__intruder_knows_session_key_as_seen_by_bob : Prop :=
with auto___query__intruder_knows_session_key_as_seen_by_alice : Prop :=
.

(* [defp] Proofs that all definitions hold. *)


Remark rem_1 : forall X1 X2:term, auto___def_47 X2 X1 -> auto___type_9 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Qed.

Remark rem_2 : forall X1:term, auto___def_26 X1 -> auto___def_26 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_3 : forall X1 X2:term, auto___def_26 X1 -> auto___type_4 X2 -> auto___def_26 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_26 X1 -> auto___def_26 X1). tauto. exact (rem_2 X1).
Qed.

Remark rem_4 : forall X2:term, auto___type_4 X2 -> auto___type_4 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_5 : forall X1 X2:term, auto___def_26 X1 -> auto___type_4 X2 -> auto___type_4 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_4 X2 -> auto___type_4 X2). tauto. exact (rem_4 X2).
Qed.

Remark rem_6 : forall X1 X2:term, auto___def_26 X1 -> auto___type_4 X2 -> (auto___def_26 X1 /\ auto___type_4 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_26 X1). 2:apply (rem_3 X1 X2);  assumption.
  cut (auto___type_4 X2). 2:apply (rem_5 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_7 : forall X1 X2:term, auto___def_26 X1 -> auto___type_4 X2 -> auto___def_25 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_6 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_25_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_8 : forall X1 X2:term, auto___type_4 X2 -> auto___def_26 X1 -> auto___def_25 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_26 X1 -> auto___type_4 X2 -> auto___def_25 (key X1 X2)). tauto. exact (rem_7 X1 X2).
Qed.

Remark rem_9 : (forall X:term, auto___def_77 X -> auto___type_23 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_10 : (forall X:term, auto___def_77 X -> auto___type_23 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_77_p__type_23. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_9 epsilon_m__def_77_p__type_23 X1);  assumption.
  tauto.
Defined.

Remark rem_11 : (forall X:term, auto___def_77 X -> auto___type_23 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto___type_23 (r_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_77_p__type_23. intros X1 X2. intros A1.
  case (rem_10 epsilon_m__def_77_p__type_23 X1 A1). clear  epsilon_m__def_77_p__type_23 A1. intros. apply trans___type_23_r_current_1;  tauto.
 clear  epsilon_m__def_77_p__type_23 A1. tauto.
Defined.

Inductive or_1(H1:Prop) : Prop :=
    or_1_intro_1 : H1 -> (or_1 H1)
.

Remark rem_12 : forall X1 X2:term, auto___def_77 (r_current X1 X2) -> or_1
    (auto_knows_current X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_13 : (forall X:term, auto___def_77 X -> auto___type_23 X)
    -> forall X1 X2:term, auto___def_77 (r_current X1 X2) -> auto___type_23 (r_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_77_p__type_23. intros X1 X2. intro H. intros.
  elim (rem_12 X1 X2 H);  intros.
  apply (rem_11 epsilon_m__def_77_p__type_23 X1 X2);  tauto.
Defined.

Inductive or_0 : Prop :=
.

Remark rem_14 : forall X1 X2:term, auto___def_77 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_15 : forall X1 X2:term, auto___def_77 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_16 : forall X1 X2:term, auto___def_77 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_17 : auto___def_77 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_18 : forall X1 X2:term, auto___def_77 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_19 : forall X1 X2:term, auto___def_77 (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_20 : forall X1:term, auto___def_77 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_21 : auto___def_77 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_22 : forall X1 X2:term, auto___def_77 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_23 : forall X1 X2:term, auto___def_77 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_24 : auto___def_77 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_25 : auto___def_77 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_26 : forall X1 X2:term, auto___def_77 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_27 : forall X1 X2:term, auto___def_77 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_28 : forall X1 X2:term, auto___def_77 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_29 : forall X1 X2:term, auto___def_77 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_30 : forall X1:term, auto___def_77 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_31 : auto___def_77 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_32 : forall X1 X2:term, auto___def_77 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_33 : auto___def_77 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_34 : auto___def_77 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_35 : auto___def_77 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_36 : forall X1 X2:term, auto___def_77 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_37 : forall X1 X2:term, auto___def_77 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_38 : forall X1:term, auto___def_77 X1 -> auto___type_23 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_77_p__type_23 1.
  intro X. case X.
   intro H. elim (rem_24  H).
   intro H. elim (rem_17  H).
  intros X1 X2. intro H. elim (rem_29 X1 X2 H).
  intros X1 X2. intro H. elim (rem_14 X1 X2 H).
  intros X1 X2. intro H. elim (rem_27 X1 X2 H).
  intros X1 X2. intro H. elim (rem_28 X1 X2 H).
   intro H. elim (rem_33  H).
  intros X1 X2. intro H. elim (rem_37 X1 X2 H).
   intro H. elim (rem_34  H).
  intros X1 X2. intro H. elim (rem_36 X1 X2 H).
  intros X1 X2. intro H. elim (rem_18 X1 X2 H).
  intros X1 X2. intro H. elim (rem_15 X1 X2 H).
  intros X1 X2. intro H. elim (rem_26 X1 X2 H).
  intros X1. intro H. elim (rem_20 X1 H).
  intros X1 X2. intro H. elim (rem_23 X1 X2 H).
  intros X1 X2. intro H. elim (rem_22 X1 X2 H).
   intro H. elim (rem_25  H).
   intro H. elim (rem_21  H).
  intros X1 X2;  exact (rem_13 epsilon_m__def_77_p__type_23 X1 X2).
  intros X1 X2. intro H. elim (rem_19 X1 X2 H).
  intros X1. intro H. elim (rem_30 X1 H).
   intro H. elim (rem_35  H).
  intros X1 X2. intro H. elim (rem_32 X1 X2 H).
  intros X1 X2. intro H. elim (rem_16 X1 X2 H).
   intro H. elim (rem_31  H).
Qed.

Remark rem_39 : forall X1 X2:term, auto___def_77 X1 -> auto___def_91 X2 -> auto___def_94 X1 -> auto___type_23 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_77 X1 -> auto___type_23 X1). tauto. exact (rem_38 X1).
Qed.

Remark rem_40 : forall X1 X2:term, auto___def_94 X1 -> auto___def_77 X1 -> auto___def_91 X2 -> auto___type_23 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_77 X1 -> auto___def_91 X2 -> auto___def_94 X1 -> auto___type_23 X1). tauto. exact (rem_39 X1 X2).
Qed.

Remark rem_41 : forall X1 X2:term, auto___def_103 X1 X2 -> or_1
    (auto___def_94 X1 /\ auto___def_77 X1 /\ auto___def_91 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_42 : forall X1 X2:term, auto___def_103 X1 X2 -> auto___type_23 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_41 X1 X2 H);  intros.
  apply (rem_40 X1 X2);  tauto.
Qed.

Remark rem_43 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1:term, auto___def_36 X1 -> auto___def_36 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_44 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_36 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2.
  cut (auto___def_36 X1 -> auto___def_36 X1). tauto. exact (rem_43 epsilon_mtestable_old_p__type_13 X1).
Defined.

Remark rem_45 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X2:term, auto___def_37 X2 -> auto___def_37 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_46 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_37 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2.
  cut (auto___def_37 X2 -> auto___def_37 X2). tauto. exact (rem_45 epsilon_mtestable_old_p__type_13 X2).
Defined.

Remark rem_47 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> (auto___def_36 X1 /\ auto___def_37 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto___def_36 X1). 2:apply (rem_44 epsilon_mtestable_old_p__type_13 X1 X2);  assumption.
  cut (auto___def_37 X2). 2:apply (rem_46 epsilon_mtestable_old_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_48 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_13 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_47 epsilon_mtestable_old_p__type_13 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_13 A1 A2. intros. apply trans___type_13_crypt_1;  tauto.
 clear  epsilon_mtestable_old_p__type_13 A1 A2. tauto.
Defined.

Remark rem_49 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1:term, auto___type_12 X1 -> auto___type_12 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_50 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___type_12 X1 -> auto___def_54 X2 -> auto___type_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2.
  cut (auto___type_12 X1 -> auto___type_12 X1). tauto. exact (rem_49 epsilon_mtestable_old_p__type_13 X1).
Defined.

Remark rem_51 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X2:term, auto___def_54 X2 -> auto___def_54 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_52 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___type_12 X1 -> auto___def_54 X2 -> auto___def_54 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2.
  cut (auto___def_54 X2 -> auto___def_54 X2). tauto. exact (rem_51 epsilon_mtestable_old_p__type_13 X2).
Defined.

Remark rem_53 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___type_12 X1 -> auto___def_54 X2 -> (auto___type_12 X1 /\ auto___def_54 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto___type_12 X1). 2:apply (rem_50 epsilon_mtestable_old_p__type_13 X1 X2);  assumption.
  cut (auto___def_54 X2). 2:apply (rem_52 epsilon_mtestable_old_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_54 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___type_12 X1 -> auto___def_54 X2 -> auto___type_13 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_53 epsilon_mtestable_old_p__type_13 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_13 A1 A2. intros. apply trans___type_13_crypt_2;  tauto.
 clear  epsilon_mtestable_old_p__type_13 A1 A2. tauto.
Defined.

Remark rem_55 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1:term, auto___def_24 X1 -> auto___def_24 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_56 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___def_24 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2.
  cut (auto___def_24 X1 -> auto___def_24 X1). tauto. exact (rem_55 epsilon_mtestable_old_p__type_13 X1).
Defined.

Remark rem_57 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X2:term, auto___def_25 X2 -> auto___def_25 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_58 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___def_25 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2.
  cut (auto___def_25 X2 -> auto___def_25 X2). tauto. exact (rem_57 epsilon_mtestable_old_p__type_13 X2).
Defined.

Remark rem_59 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> (auto___def_24 X1 /\ auto___def_25 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto___def_24 X1). 2:apply (rem_56 epsilon_mtestable_old_p__type_13 X1 X2);  assumption.
  cut (auto___def_25 X2). 2:apply (rem_58 epsilon_mtestable_old_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_60 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___type_13 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_59 epsilon_mtestable_old_p__type_13 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_13 A1 A2. intros. apply trans___type_13_crypt_3;  tauto.
 clear  epsilon_mtestable_old_p__type_13 A1 A2. tauto.
Defined.

Remark rem_61 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1:term, auto___type_11 X1 -> auto___type_11 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_62 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___type_11 X1 -> auto___def_52 X2 -> auto___type_11 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2.
  cut (auto___type_11 X1 -> auto___type_11 X1). tauto. exact (rem_61 epsilon_mtestable_old_p__type_13 X1).
Defined.

Remark rem_63 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X2:term, auto___def_52 X2 -> auto___def_52 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_64 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___type_11 X1 -> auto___def_52 X2 -> auto___def_52 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2.
  cut (auto___def_52 X2 -> auto___def_52 X2). tauto. exact (rem_63 epsilon_mtestable_old_p__type_13 X2).
Defined.

Remark rem_65 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___type_11 X1 -> auto___def_52 X2 -> (auto___type_11 X1 /\ auto___def_52 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto___type_11 X1). 2:apply (rem_62 epsilon_mtestable_old_p__type_13 X1 X2);  assumption.
  cut (auto___def_52 X2). 2:apply (rem_64 epsilon_mtestable_old_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_66 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___type_11 X1 -> auto___def_52 X2 -> auto___type_13 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_65 epsilon_mtestable_old_p__type_13 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_13 A1 A2. intros. apply trans___type_13_crypt_4;  tauto.
 clear  epsilon_mtestable_old_p__type_13 A1 A2. tauto.
Defined.

Remark rem_67 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1:term, auto___type_7 X1 -> auto___type_7 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_68 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2.
  cut (auto___type_7 X1 -> auto___type_7 X1). tauto. exact (rem_67 epsilon_mtestable_old_p__type_13 X1).
Defined.

Remark rem_69 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X2:term, auto___def_44 X2 -> auto___def_44 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_70 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___def_44 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2.
  cut (auto___def_44 X2 -> auto___def_44 X2). tauto. exact (rem_69 epsilon_mtestable_old_p__type_13 X2).
Defined.

Remark rem_71 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> (auto___type_7 X1 /\ auto___def_44 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto___type_7 X1). 2:apply (rem_68 epsilon_mtestable_old_p__type_13 X1 X2);  assumption.
  cut (auto___def_44 X2). 2:apply (rem_70 epsilon_mtestable_old_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_72 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___type_13 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_71 epsilon_mtestable_old_p__type_13 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_13 A1 A2. intros. apply trans___type_13_crypt_5;  tauto.
 clear  epsilon_mtestable_old_p__type_13 A1 A2. tauto.
Defined.

Remark rem_73 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_74 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2.
  cut (auto_knows_old X1 -> auto_knows_old X1). tauto. exact (rem_73 epsilon_mtestable_old_p__type_13 X1).
Defined.

Remark rem_75 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X2:term, auto_knows_old X2 -> auto_knows_old X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_76 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_75 epsilon_mtestable_old_p__type_13 X2).
Defined.

Remark rem_77 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> (auto_knows_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_74 epsilon_mtestable_old_p__type_13 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_76 epsilon_mtestable_old_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_78 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_13 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_77 epsilon_mtestable_old_p__type_13 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_13 A1 A2. intros. apply trans___type_13_crypt_6;  tauto.
 clear  epsilon_mtestable_old_p__type_13 A1 A2. tauto.
Defined.

Inductive or_6(H1 H2 H3 H4 H5 H6:Prop) : Prop :=
    or_6_intro_1 : H1 -> (or_6 H1 H2 H3 H4 H5 H6)
  | or_6_intro_2 : H2 -> (or_6 H1 H2 H3 H4 H5 H6)
  | or_6_intro_3 : H3 -> (or_6 H1 H2 H3 H4 H5 H6)
  | or_6_intro_4 : H4 -> (or_6 H1 H2 H3 H4 H5 H6)
  | or_6_intro_5 : H5 -> (or_6 H1 H2 H3 H4 H5 H6)
  | or_6_intro_6 : H6 -> (or_6 H1 H2 H3 H4 H5 H6)
.

Remark rem_79 : forall X1 X2:term, auto_testable_old (crypt X1 X2) -> or_6
    (auto___def_36 X1 /\ auto___def_37 X2)
    (auto___type_12 X1 /\ auto___def_54 X2)
    (auto___def_24 X1 /\ auto___def_25 X2)
    (auto___type_11 X1 /\ auto___def_52 X2)
    (auto___type_7 X1 /\ auto___def_44 X2)
    (auto_knows_old X1 /\ auto_knows_old X2)
.
Proof.
  intros. inversion H.
  intros. apply or_6_intro_1; tauto.
  intros. apply or_6_intro_2; tauto.
  intros. apply or_6_intro_3; tauto.
  intros. apply or_6_intro_4; tauto.
  intros. apply or_6_intro_5; tauto.
  intros. apply or_6_intro_6; tauto.
Qed.

Remark rem_80 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto_testable_old (crypt X1 X2) -> auto___type_13 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intro H. intros.
  elim (rem_79 X1 X2 H);  intros.
  apply (rem_48 epsilon_mtestable_old_p__type_13 X1 X2);  tauto.
  apply (rem_54 epsilon_mtestable_old_p__type_13 X1 X2);  tauto.
  apply (rem_60 epsilon_mtestable_old_p__type_13 X1 X2);  tauto.
  apply (rem_66 epsilon_mtestable_old_p__type_13 X1 X2);  tauto.
  apply (rem_72 epsilon_mtestable_old_p__type_13 X1 X2);  tauto.
  apply (rem_78 epsilon_mtestable_old_p__type_13 X1 X2);  tauto.
Defined.

Remark rem_81 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_13.  tauto.
Defined.

Remark rem_82 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> auto___type_13 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13.  case (rem_81 epsilon_mtestable_old_p__type_13). clear  epsilon_mtestable_old_p__type_13. intros. apply trans___type_13_bob_1;  tauto.
 clear  epsilon_mtestable_old_p__type_13. tauto.
Defined.

Remark rem_83 : auto_testable_old bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_84 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> auto_testable_old bob -> auto___type_13 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intro H. intros.
  elim (rem_83 H);  intros.
  apply (rem_82 epsilon_mtestable_old_p__type_13);  tauto.
Defined.

Remark rem_85 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1:term, auto_testable_old X1 -> auto_testable_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_86 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1:term, auto_testable_old X1 -> auto_testable_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1. intros A1.
  cut (auto_testable_old X1). 2:apply (rem_85 epsilon_mtestable_old_p__type_13 X1);  assumption.
  tauto.
Defined.

Remark rem_87 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1:term, auto_testable_old X1 -> auto___type_13 (p X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1. intros A1.
  case (rem_86 epsilon_mtestable_old_p__type_13 X1 A1). clear  epsilon_mtestable_old_p__type_13 A1. intros. apply trans___type_13_p_1;  tauto.
 clear  epsilon_mtestable_old_p__type_13 A1. tauto.
Defined.

Remark rem_88 : forall X1:term, auto_testable_old (p X1) -> or_1
    (auto_testable_old X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_89 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1:term, auto_testable_old (p X1) -> auto___type_13 (p X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1. intro H. intros.
  elim (rem_88 X1 H);  intros.
  apply (rem_87 epsilon_mtestable_old_p__type_13 X1);  tauto.
Defined.

Remark rem_90 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> auto___type_13 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13.  case (rem_81 epsilon_mtestable_old_p__type_13). clear  epsilon_mtestable_old_p__type_13. intros. apply trans___type_13_alice_1;  tauto.
 clear  epsilon_mtestable_old_p__type_13. tauto.
Defined.

Remark rem_91 : auto_testable_old alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_92 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> auto_testable_old alice -> auto___type_13 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intro H. intros.
  elim (rem_91 H);  intros.
  apply (rem_90 epsilon_mtestable_old_p__type_13);  tauto.
Defined.

Remark rem_93 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto_testable_old X1 -> auto_knows_old X2 -> auto_testable_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2.
  cut (auto_testable_old X1 -> auto_testable_old X1). tauto. exact (rem_85 epsilon_mtestable_old_p__type_13 X1).
Defined.

Remark rem_94 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto_testable_old X1 -> auto_knows_old X2 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_75 epsilon_mtestable_old_p__type_13 X2).
Defined.

Remark rem_95 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto_testable_old X1 -> auto_knows_old X2 -> (auto_testable_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto_testable_old X1). 2:apply (rem_93 epsilon_mtestable_old_p__type_13 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_94 epsilon_mtestable_old_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_96 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto_testable_old X1 -> auto_knows_old X2 -> auto___type_13 (dec X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_95 epsilon_mtestable_old_p__type_13 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_13 A1 A2. intros. apply trans___type_13_dec_1;  tauto.
 clear  epsilon_mtestable_old_p__type_13 A1 A2. tauto.
Defined.

Remark rem_97 : forall X1 X2:term, auto_testable_old (dec X1 X2) -> or_1
    (auto_testable_old X1 /\ auto_knows_old X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_98 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto_testable_old (dec X1 X2) -> auto___type_13 (dec X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intro H. intros.
  elim (rem_97 X1 X2 H);  intros.
  apply (rem_96 epsilon_mtestable_old_p__type_13 X1 X2);  tauto.
Defined.

Remark rem_99 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1:term, auto___def_10 X1 -> auto___def_10 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_100 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_10 X1). tauto. exact (rem_99 epsilon_mtestable_old_p__type_13 X1).
Defined.

Remark rem_101 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X2:term, auto___def_11 X2 -> auto___def_11 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_102 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2.
  cut (auto___def_11 X2 -> auto___def_11 X2). tauto. exact (rem_101 epsilon_mtestable_old_p__type_13 X2).
Defined.

Remark rem_103 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> (auto___def_10 X1 /\ auto___def_11 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto___def_10 X1). 2:apply (rem_100 epsilon_mtestable_old_p__type_13 X1 X2);  assumption.
  cut (auto___def_11 X2). 2:apply (rem_102 epsilon_mtestable_old_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_104 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___type_13 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_103 epsilon_mtestable_old_p__type_13 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_13 A1 A2. intros. apply trans___type_13_enc_1;  tauto.
 clear  epsilon_mtestable_old_p__type_13 A1 A2. tauto.
Defined.

Remark rem_105 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1:term, auto___def_15 X1 -> auto___def_15 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_106 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_15 X1 -> auto___def_16 X2 -> auto___def_15 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2.
  cut (auto___def_15 X1 -> auto___def_15 X1). tauto. exact (rem_105 epsilon_mtestable_old_p__type_13 X1).
Defined.

Remark rem_107 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X2:term, auto___def_16 X2 -> auto___def_16 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_108 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_15 X1 -> auto___def_16 X2 -> auto___def_16 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2.
  cut (auto___def_16 X2 -> auto___def_16 X2). tauto. exact (rem_107 epsilon_mtestable_old_p__type_13 X2).
Defined.

Remark rem_109 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_15 X1 -> auto___def_16 X2 -> (auto___def_15 X1 /\ auto___def_16 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto___def_15 X1). 2:apply (rem_106 epsilon_mtestable_old_p__type_13 X1 X2);  assumption.
  cut (auto___def_16 X2). 2:apply (rem_108 epsilon_mtestable_old_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_110 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_15 X1 -> auto___def_16 X2 -> auto___type_13 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_109 epsilon_mtestable_old_p__type_13 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_13 A1 A2. intros. apply trans___type_13_enc_2;  tauto.
 clear  epsilon_mtestable_old_p__type_13 A1 A2. tauto.
Defined.

Remark rem_111 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1:term, auto___def_19 X1 -> auto___def_19 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_112 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto___def_19 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2.
  cut (auto___def_19 X1 -> auto___def_19 X1). tauto. exact (rem_111 epsilon_mtestable_old_p__type_13 X1).
Defined.

Remark rem_113 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X2:term, auto___def_20 X2 -> auto___def_20 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_114 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto___def_20 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2.
  cut (auto___def_20 X2 -> auto___def_20 X2). tauto. exact (rem_113 epsilon_mtestable_old_p__type_13 X2).
Defined.

Remark rem_115 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> (auto___def_19 X1 /\ auto___def_20 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto___def_19 X1). 2:apply (rem_112 epsilon_mtestable_old_p__type_13 X1 X2);  assumption.
  cut (auto___def_20 X2). 2:apply (rem_114 epsilon_mtestable_old_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_116 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto___type_13 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_115 epsilon_mtestable_old_p__type_13 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_13 A1 A2. intros. apply trans___type_13_enc_3;  tauto.
 clear  epsilon_mtestable_old_p__type_13 A1 A2. tauto.
Defined.

Remark rem_117 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto_testable_old X1 -> auto_knows_old X2 -> auto___type_13 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_95 epsilon_mtestable_old_p__type_13 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_13 A1 A2. intros. apply trans___type_13_enc_4;  tauto.
 clear  epsilon_mtestable_old_p__type_13 A1 A2. tauto.
Defined.

Inductive or_4(H1 H2 H3 H4:Prop) : Prop :=
    or_4_intro_1 : H1 -> (or_4 H1 H2 H3 H4)
  | or_4_intro_2 : H2 -> (or_4 H1 H2 H3 H4)
  | or_4_intro_3 : H3 -> (or_4 H1 H2 H3 H4)
  | or_4_intro_4 : H4 -> (or_4 H1 H2 H3 H4)
.

Remark rem_118 : forall X1 X2:term, auto_testable_old (enc X1 X2) -> or_4
    (auto___def_10 X1 /\ auto___def_11 X2)
    (auto___def_15 X1 /\ auto___def_16 X2)
    (auto___def_19 X1 /\ auto___def_20 X2)
    (auto_testable_old X1 /\ auto_knows_old X2)
.
Proof.
  intros. inversion H.
  intros. apply or_4_intro_1; tauto.
  intros. apply or_4_intro_2; tauto.
  intros. apply or_4_intro_3; tauto.
  intros. apply or_4_intro_4; tauto.
Qed.

Remark rem_119 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto_testable_old (enc X1 X2) -> auto___type_13 (enc X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intro H. intros.
  elim (rem_118 X1 X2 H);  intros.
  apply (rem_104 epsilon_mtestable_old_p__type_13 X1 X2);  tauto.
  apply (rem_110 epsilon_mtestable_old_p__type_13 X1 X2);  tauto.
  apply (rem_116 epsilon_mtestable_old_p__type_13 X1 X2);  tauto.
  apply (rem_117 epsilon_mtestable_old_p__type_13 X1 X2);  tauto.
Defined.

Remark rem_120 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X2:term, auto_testable_old X2 -> auto_testable_old X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_121 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X2:term, auto_testable_old X2 -> auto_testable_old X2 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X2. intros A1.
  cut (auto_testable_old X2). 2:apply (rem_120 epsilon_mtestable_old_p__type_13 X2);  assumption.
  tauto.
Defined.

Remark rem_122 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto_testable_old X2 -> auto___type_13 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1.
  case (rem_121 epsilon_mtestable_old_p__type_13 X2 A1). clear  epsilon_mtestable_old_p__type_13 A1. intros. apply trans___type_13_cons_1;  tauto.
 clear  epsilon_mtestable_old_p__type_13 A1. tauto.
Defined.

Remark rem_123 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto_testable_old X1 -> auto___type_13 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1.
  case (rem_86 epsilon_mtestable_old_p__type_13 X1 A1). clear  epsilon_mtestable_old_p__type_13 A1. intros. apply trans___type_13_cons_2;  tauto.
 clear  epsilon_mtestable_old_p__type_13 A1. tauto.
Defined.

Inductive or_2(H1 H2:Prop) : Prop :=
    or_2_intro_1 : H1 -> (or_2 H1 H2)
  | or_2_intro_2 : H2 -> (or_2 H1 H2)
.

Remark rem_124 : forall X1 X2:term, auto_testable_old (cons X1 X2) -> or_2
    (auto_testable_old X2)    (auto_testable_old X1).
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_125 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto_testable_old (cons X1 X2) -> auto___type_13 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intro H. intros.
  elim (rem_124 X1 X2 H);  intros.
  apply (rem_122 epsilon_mtestable_old_p__type_13 X1 X2);  tauto.
  apply (rem_123 epsilon_mtestable_old_p__type_13 X1 X2);  tauto.
Defined.

Remark rem_126 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1:term, auto_testable_old X1 -> auto___type_13 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1. intros A1.
  case (rem_86 epsilon_mtestable_old_p__type_13 X1 A1). clear  epsilon_mtestable_old_p__type_13 A1. intros. apply trans___type_13_s_1;  tauto.
 clear  epsilon_mtestable_old_p__type_13 A1. tauto.
Defined.

Remark rem_127 : forall X1:term, auto_testable_old (s X1) -> or_1
    (auto_testable_old X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_128 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1:term, auto_testable_old (s X1) -> auto___type_13 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1. intro H. intros.
  elim (rem_127 X1 H);  intros.
  apply (rem_126 epsilon_mtestable_old_p__type_13 X1);  tauto.
Defined.

Remark rem_129 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> auto___type_13 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13.  case (rem_81 epsilon_mtestable_old_p__type_13). clear  epsilon_mtestable_old_p__type_13. intros. apply trans___type_13_i_1;  tauto.
 clear  epsilon_mtestable_old_p__type_13. tauto.
Defined.

Remark rem_130 : auto_testable_old i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_131 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> auto_testable_old i -> auto___type_13 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intro H. intros.
  elim (rem_130 H);  intros.
  apply (rem_129 epsilon_mtestable_old_p__type_13);  tauto.
Defined.

Remark rem_132 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> auto___type_13 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13.  case (rem_81 epsilon_mtestable_old_p__type_13). clear  epsilon_mtestable_old_p__type_13. intros. apply trans___type_13_nil_1;  tauto.
 clear  epsilon_mtestable_old_p__type_13. tauto.
Defined.

Remark rem_133 : auto_testable_old nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_134 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> auto_testable_old nil -> auto___type_13 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intro H. intros.
  elim (rem_133 H);  intros.
  apply (rem_132 epsilon_mtestable_old_p__type_13);  tauto.
Defined.

Remark rem_135 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> auto___type_13 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13.  case (rem_81 epsilon_mtestable_old_p__type_13). clear  epsilon_mtestable_old_p__type_13. intros. apply trans___type_13_server_1;  tauto.
 clear  epsilon_mtestable_old_p__type_13. tauto.
Defined.

Remark rem_136 : auto_testable_old server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_137 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> auto_testable_old server -> auto___type_13 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intro H. intros.
  elim (rem_136 H);  intros.
  apply (rem_135 epsilon_mtestable_old_p__type_13);  tauto.
Defined.

Remark rem_138 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1:term, auto___def_60 X1 -> auto___def_60 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_139 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_60 X1 -> auto___type_16 X2 -> auto___def_60 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2.
  cut (auto___def_60 X1 -> auto___def_60 X1). tauto. exact (rem_138 epsilon_mtestable_old_p__type_13 X1).
Defined.

Remark rem_140 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X2:term, auto___type_16 X2 -> auto___type_16 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_141 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_60 X1 -> auto___type_16 X2 -> auto___type_16 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2.
  cut (auto___type_16 X2 -> auto___type_16 X2). tauto. exact (rem_140 epsilon_mtestable_old_p__type_13 X2).
Defined.

Remark rem_142 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_60 X1 -> auto___type_16 X2 -> (auto___def_60 X1 /\ auto___type_16 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto___def_60 X1). 2:apply (rem_139 epsilon_mtestable_old_p__type_13 X1 X2);  assumption.
  cut (auto___type_16 X2). 2:apply (rem_141 epsilon_mtestable_old_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_143 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_60 X1 -> auto___type_16 X2 -> auto___type_13 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_142 epsilon_mtestable_old_p__type_13 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_13 A1 A2. intros. apply trans___type_13_key_1;  tauto.
 clear  epsilon_mtestable_old_p__type_13 A1 A2. tauto.
Defined.

Remark rem_144 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1:term, auto___def_55 X1 -> auto___def_55 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_145 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_4 X2 -> auto___def_55 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2.
  cut (auto___def_55 X1 -> auto___def_55 X1). tauto. exact (rem_144 epsilon_mtestable_old_p__type_13 X1).
Defined.

Remark rem_146 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X2:term, auto___def_4 X2 -> auto___def_4 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_147 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_4 X2 -> auto___def_4 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2.
  cut (auto___def_4 X2 -> auto___def_4 X2). tauto. exact (rem_146 epsilon_mtestable_old_p__type_13 X2).
Defined.

Remark rem_148 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_4 X2 -> (auto___def_55 X1 /\ auto___def_4 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto___def_55 X1). 2:apply (rem_145 epsilon_mtestable_old_p__type_13 X1 X2);  assumption.
  cut (auto___def_4 X2). 2:apply (rem_147 epsilon_mtestable_old_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_149 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_4 X2 -> auto___type_13 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_148 epsilon_mtestable_old_p__type_13 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_13 A1 A2. intros. apply trans___type_13_key_2;  tauto.
 clear  epsilon_mtestable_old_p__type_13 A1 A2. tauto.
Defined.

Remark rem_150 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1:term, auto___def_51 X1 -> auto___def_51 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_151 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto___def_51 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2.
  cut (auto___def_51 X1 -> auto___def_51 X1). tauto. exact (rem_150 epsilon_mtestable_old_p__type_13 X1).
Defined.

Remark rem_152 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_153 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_152 epsilon_mtestable_old_p__type_13 X2).
Defined.

Remark rem_154 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> (auto___def_51 X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto___def_51 X1). 2:apply (rem_151 epsilon_mtestable_old_p__type_13 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_153 epsilon_mtestable_old_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_155 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto___type_13 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_154 epsilon_mtestable_old_p__type_13 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_13 A1 A2. intros. apply trans___type_13_key_3;  tauto.
 clear  epsilon_mtestable_old_p__type_13 A1 A2. tauto.
Defined.

Inductive or_3(H1 H2 H3:Prop) : Prop :=
    or_3_intro_1 : H1 -> (or_3 H1 H2 H3)
  | or_3_intro_2 : H2 -> (or_3 H1 H2 H3)
  | or_3_intro_3 : H3 -> (or_3 H1 H2 H3)
.

Remark rem_156 : forall X1 X2:term, auto_testable_old (key X1 X2) -> or_3
    (auto___def_60 X1 /\ auto___type_16 X2)
    (auto___def_55 X1 /\ auto___def_4 X2)
    (auto___def_51 X1 /\ auto_agent X2)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_157 : (forall X:term, auto_testable_old X -> auto___type_13 X)
    -> forall X1 X2:term, auto_testable_old (key X1 X2) -> auto___type_13 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_13. intros X1 X2. intro H. intros.
  elim (rem_156 X1 X2 H);  intros.
  apply (rem_143 epsilon_mtestable_old_p__type_13 X1 X2);  tauto.
  apply (rem_149 epsilon_mtestable_old_p__type_13 X1 X2);  tauto.
  apply (rem_155 epsilon_mtestable_old_p__type_13 X1 X2);  tauto.
Defined.

Remark rem_158 : forall X1 X2:term, auto_testable_old (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_159 : forall X1 X2:term, auto_testable_old (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_160 : forall X1 X2:term, auto_testable_old (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_161 : forall X1 X2:term, auto_testable_old (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_162 : forall X1 X2:term, auto_testable_old (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_163 : auto_testable_old pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_164 : forall X1 X2:term, auto_testable_old (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_165 : forall X1 X2:term, auto_testable_old (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_166 : auto_testable_old prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_167 : forall X1 X2:term, auto_testable_old (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_168 : auto_testable_old sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_169 : forall X1 X2:term, auto_testable_old (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_170 : forall X1 X2:term, auto_testable_old (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_171 : forall X1:term, auto_testable_old X1 -> auto___type_13 X1. (* Induct. *)
Proof.
  fix epsilon_mtestable_old_p__type_13 1.
  intro X. case X.
  exact (rem_92 epsilon_mtestable_old_p__type_13 ).
  exact (rem_84 epsilon_mtestable_old_p__type_13 ).
  intros X1 X2;  exact (rem_125 epsilon_mtestable_old_p__type_13 X1 X2).
  intros X1 X2;  exact (rem_80 epsilon_mtestable_old_p__type_13 X1 X2).
  intros X1 X2;  exact (rem_98 epsilon_mtestable_old_p__type_13 X1 X2).
  intros X1 X2;  exact (rem_119 epsilon_mtestable_old_p__type_13 X1 X2).
  exact (rem_131 epsilon_mtestable_old_p__type_13 ).
  intros X1 X2;  exact (rem_157 epsilon_mtestable_old_p__type_13 X1 X2).
  exact (rem_134 epsilon_mtestable_old_p__type_13 ).
  intros X1 X2. intro H. elim (rem_170 X1 X2 H).
  intros X1 X2. intro H. elim (rem_160 X1 X2 H).
  intros X1 X2. intro H. elim (rem_158 X1 X2 H).
  intros X1 X2. intro H. elim (rem_167 X1 X2 H).
  intros X1;  exact (rem_89 epsilon_mtestable_old_p__type_13 X1).
  intros X1 X2. intro H. elim (rem_165 X1 X2 H).
  intros X1 X2. intro H. elim (rem_164 X1 X2 H).
   intro H. elim (rem_166  H).
   intro H. elim (rem_163  H).
  intros X1 X2. intro H. elim (rem_162 X1 X2 H).
  intros X1 X2. intro H. elim (rem_161 X1 X2 H).
  intros X1;  exact (rem_128 epsilon_mtestable_old_p__type_13 X1).
  exact (rem_137 epsilon_mtestable_old_p__type_13 ).
  intros X1 X2. intro H. elim (rem_169 X1 X2 H).
  intros X1 X2. intro H. elim (rem_159 X1 X2 H).
   intro H. elim (rem_168  H).
Qed.

Remark rem_172 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1:term, auto___def_36 X1 -> auto___def_36 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_173 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_36 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2.
  cut (auto___def_36 X1 -> auto___def_36 X1). tauto. exact (rem_172 epsilon_mtestable_old_p__type_12 X1).
Defined.

Remark rem_174 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X2:term, auto___def_37 X2 -> auto___def_37 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_175 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_37 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2.
  cut (auto___def_37 X2 -> auto___def_37 X2). tauto. exact (rem_174 epsilon_mtestable_old_p__type_12 X2).
Defined.

Remark rem_176 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> (auto___def_36 X1 /\ auto___def_37 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1 A2.
  cut (auto___def_36 X1). 2:apply (rem_173 epsilon_mtestable_old_p__type_12 X1 X2);  assumption.
  cut (auto___def_37 X2). 2:apply (rem_175 epsilon_mtestable_old_p__type_12 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_177 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_12 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1 A2.
  case (rem_176 epsilon_mtestable_old_p__type_12 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_12 A1 A2. intros. apply trans___type_12_crypt_1;  tauto.
 clear  epsilon_mtestable_old_p__type_12 A1 A2. tauto.
Defined.

Remark rem_178 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1:term, auto___type_12 X1 -> auto___type_12 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_179 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___type_12 X1 -> auto___def_54 X2 -> auto___type_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2.
  cut (auto___type_12 X1 -> auto___type_12 X1). tauto. exact (rem_178 epsilon_mtestable_old_p__type_12 X1).
Defined.

Remark rem_180 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X2:term, auto___def_54 X2 -> auto___def_54 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_181 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___type_12 X1 -> auto___def_54 X2 -> auto___def_54 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2.
  cut (auto___def_54 X2 -> auto___def_54 X2). tauto. exact (rem_180 epsilon_mtestable_old_p__type_12 X2).
Defined.

Remark rem_182 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___type_12 X1 -> auto___def_54 X2 -> (auto___type_12 X1 /\ auto___def_54 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1 A2.
  cut (auto___type_12 X1). 2:apply (rem_179 epsilon_mtestable_old_p__type_12 X1 X2);  assumption.
  cut (auto___def_54 X2). 2:apply (rem_181 epsilon_mtestable_old_p__type_12 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_183 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___type_12 X1 -> auto___def_54 X2 -> auto___type_12 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1 A2.
  case (rem_182 epsilon_mtestable_old_p__type_12 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_12 A1 A2. intros. apply trans___type_12_crypt_2;  tauto.
 clear  epsilon_mtestable_old_p__type_12 A1 A2. tauto.
Defined.

Remark rem_184 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1:term, auto___def_24 X1 -> auto___def_24 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_185 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___def_24 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2.
  cut (auto___def_24 X1 -> auto___def_24 X1). tauto. exact (rem_184 epsilon_mtestable_old_p__type_12 X1).
Defined.

Remark rem_186 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X2:term, auto___def_25 X2 -> auto___def_25 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_187 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___def_25 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2.
  cut (auto___def_25 X2 -> auto___def_25 X2). tauto. exact (rem_186 epsilon_mtestable_old_p__type_12 X2).
Defined.

Remark rem_188 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> (auto___def_24 X1 /\ auto___def_25 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1 A2.
  cut (auto___def_24 X1). 2:apply (rem_185 epsilon_mtestable_old_p__type_12 X1 X2);  assumption.
  cut (auto___def_25 X2). 2:apply (rem_187 epsilon_mtestable_old_p__type_12 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_189 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___type_12 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1 A2.
  case (rem_188 epsilon_mtestable_old_p__type_12 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_12 A1 A2. intros. apply trans___type_12_crypt_3;  tauto.
 clear  epsilon_mtestable_old_p__type_12 A1 A2. tauto.
Defined.

Remark rem_190 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1:term, auto___type_11 X1 -> auto___type_11 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_191 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___type_11 X1 -> auto___def_52 X2 -> auto___type_11 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2.
  cut (auto___type_11 X1 -> auto___type_11 X1). tauto. exact (rem_190 epsilon_mtestable_old_p__type_12 X1).
Defined.

Remark rem_192 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X2:term, auto___def_52 X2 -> auto___def_52 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_193 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___type_11 X1 -> auto___def_52 X2 -> auto___def_52 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2.
  cut (auto___def_52 X2 -> auto___def_52 X2). tauto. exact (rem_192 epsilon_mtestable_old_p__type_12 X2).
Defined.

Remark rem_194 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___type_11 X1 -> auto___def_52 X2 -> (auto___type_11 X1 /\ auto___def_52 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1 A2.
  cut (auto___type_11 X1). 2:apply (rem_191 epsilon_mtestable_old_p__type_12 X1 X2);  assumption.
  cut (auto___def_52 X2). 2:apply (rem_193 epsilon_mtestable_old_p__type_12 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_195 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___type_11 X1 -> auto___def_52 X2 -> auto___type_12 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1 A2.
  case (rem_194 epsilon_mtestable_old_p__type_12 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_12 A1 A2. intros. apply trans___type_12_crypt_4;  tauto.
 clear  epsilon_mtestable_old_p__type_12 A1 A2. tauto.
Defined.

Remark rem_196 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1:term, auto___type_7 X1 -> auto___type_7 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_197 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2.
  cut (auto___type_7 X1 -> auto___type_7 X1). tauto. exact (rem_196 epsilon_mtestable_old_p__type_12 X1).
Defined.

Remark rem_198 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X2:term, auto___def_44 X2 -> auto___def_44 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_199 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___def_44 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2.
  cut (auto___def_44 X2 -> auto___def_44 X2). tauto. exact (rem_198 epsilon_mtestable_old_p__type_12 X2).
Defined.

Remark rem_200 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> (auto___type_7 X1 /\ auto___def_44 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1 A2.
  cut (auto___type_7 X1). 2:apply (rem_197 epsilon_mtestable_old_p__type_12 X1 X2);  assumption.
  cut (auto___def_44 X2). 2:apply (rem_199 epsilon_mtestable_old_p__type_12 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_201 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___type_12 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1 A2.
  case (rem_200 epsilon_mtestable_old_p__type_12 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_12 A1 A2. intros. apply trans___type_12_crypt_5;  tauto.
 clear  epsilon_mtestable_old_p__type_12 A1 A2. tauto.
Defined.

Remark rem_202 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_203 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2.
  cut (auto_knows_old X1 -> auto_knows_old X1). tauto. exact (rem_202 epsilon_mtestable_old_p__type_12 X1).
Defined.

Remark rem_204 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X2:term, auto_knows_old X2 -> auto_knows_old X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_205 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_204 epsilon_mtestable_old_p__type_12 X2).
Defined.

Remark rem_206 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> (auto_knows_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_203 epsilon_mtestable_old_p__type_12 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_205 epsilon_mtestable_old_p__type_12 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_207 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_12 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1 A2.
  case (rem_206 epsilon_mtestable_old_p__type_12 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_12 A1 A2. intros. apply trans___type_12_crypt_6;  tauto.
 clear  epsilon_mtestable_old_p__type_12 A1 A2. tauto.
Defined.

Remark rem_208 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto_testable_old (crypt X1 X2) -> auto___type_12 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intro H. intros.
  elim (rem_79 X1 X2 H);  intros.
  apply (rem_177 epsilon_mtestable_old_p__type_12 X1 X2);  tauto.
  apply (rem_183 epsilon_mtestable_old_p__type_12 X1 X2);  tauto.
  apply (rem_189 epsilon_mtestable_old_p__type_12 X1 X2);  tauto.
  apply (rem_195 epsilon_mtestable_old_p__type_12 X1 X2);  tauto.
  apply (rem_201 epsilon_mtestable_old_p__type_12 X1 X2);  tauto.
  apply (rem_207 epsilon_mtestable_old_p__type_12 X1 X2);  tauto.
Defined.

Remark rem_209 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_12.  tauto.
Defined.

Remark rem_210 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> auto___type_12 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12.  case (rem_209 epsilon_mtestable_old_p__type_12). clear  epsilon_mtestable_old_p__type_12. intros. apply trans___type_12_bob_1;  tauto.
 clear  epsilon_mtestable_old_p__type_12. tauto.
Defined.

Remark rem_211 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> auto_testable_old bob -> auto___type_12 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intro H. intros.
  elim (rem_83 H);  intros.
  apply (rem_210 epsilon_mtestable_old_p__type_12);  tauto.
Defined.

Remark rem_212 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1:term, auto_testable_old X1 -> auto_testable_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_213 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1:term, auto_testable_old X1 -> auto_testable_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1. intros A1.
  cut (auto_testable_old X1). 2:apply (rem_212 epsilon_mtestable_old_p__type_12 X1);  assumption.
  tauto.
Defined.

Remark rem_214 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1:term, auto_testable_old X1 -> auto___type_12 (p X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1. intros A1.
  case (rem_213 epsilon_mtestable_old_p__type_12 X1 A1). clear  epsilon_mtestable_old_p__type_12 A1. intros. apply trans___type_12_p_1;  tauto.
 clear  epsilon_mtestable_old_p__type_12 A1. tauto.
Defined.

Remark rem_215 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1:term, auto_testable_old (p X1) -> auto___type_12 (p X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1. intro H. intros.
  elim (rem_88 X1 H);  intros.
  apply (rem_214 epsilon_mtestable_old_p__type_12 X1);  tauto.
Defined.

Remark rem_216 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> auto___type_12 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12.  case (rem_209 epsilon_mtestable_old_p__type_12). clear  epsilon_mtestable_old_p__type_12. intros. apply trans___type_12_alice_1;  tauto.
 clear  epsilon_mtestable_old_p__type_12. tauto.
Defined.

Remark rem_217 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> auto_testable_old alice -> auto___type_12 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intro H. intros.
  elim (rem_91 H);  intros.
  apply (rem_216 epsilon_mtestable_old_p__type_12);  tauto.
Defined.

Remark rem_218 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto_testable_old X1 -> auto_knows_old X2 -> auto_testable_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2.
  cut (auto_testable_old X1 -> auto_testable_old X1). tauto. exact (rem_212 epsilon_mtestable_old_p__type_12 X1).
Defined.

Remark rem_219 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto_testable_old X1 -> auto_knows_old X2 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_204 epsilon_mtestable_old_p__type_12 X2).
Defined.

Remark rem_220 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto_testable_old X1 -> auto_knows_old X2 -> (auto_testable_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1 A2.
  cut (auto_testable_old X1). 2:apply (rem_218 epsilon_mtestable_old_p__type_12 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_219 epsilon_mtestable_old_p__type_12 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_221 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto_testable_old X1 -> auto_knows_old X2 -> auto___type_12 (dec X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1 A2.
  case (rem_220 epsilon_mtestable_old_p__type_12 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_12 A1 A2. intros. apply trans___type_12_dec_1;  tauto.
 clear  epsilon_mtestable_old_p__type_12 A1 A2. tauto.
Defined.

Remark rem_222 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto_testable_old (dec X1 X2) -> auto___type_12 (dec X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intro H. intros.
  elim (rem_97 X1 X2 H);  intros.
  apply (rem_221 epsilon_mtestable_old_p__type_12 X1 X2);  tauto.
Defined.

Remark rem_223 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1:term, auto___def_10 X1 -> auto___def_10 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_224 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_10 X1). tauto. exact (rem_223 epsilon_mtestable_old_p__type_12 X1).
Defined.

Remark rem_225 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X2:term, auto___def_11 X2 -> auto___def_11 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_226 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2.
  cut (auto___def_11 X2 -> auto___def_11 X2). tauto. exact (rem_225 epsilon_mtestable_old_p__type_12 X2).
Defined.

Remark rem_227 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> (auto___def_10 X1 /\ auto___def_11 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1 A2.
  cut (auto___def_10 X1). 2:apply (rem_224 epsilon_mtestable_old_p__type_12 X1 X2);  assumption.
  cut (auto___def_11 X2). 2:apply (rem_226 epsilon_mtestable_old_p__type_12 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_228 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___type_12 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1 A2.
  case (rem_227 epsilon_mtestable_old_p__type_12 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_12 A1 A2. intros. apply trans___type_12_enc_1;  tauto.
 clear  epsilon_mtestable_old_p__type_12 A1 A2. tauto.
Defined.

Remark rem_229 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1:term, auto___def_15 X1 -> auto___def_15 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_230 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_15 X1 -> auto___def_16 X2 -> auto___def_15 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2.
  cut (auto___def_15 X1 -> auto___def_15 X1). tauto. exact (rem_229 epsilon_mtestable_old_p__type_12 X1).
Defined.

Remark rem_231 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X2:term, auto___def_16 X2 -> auto___def_16 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_232 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_15 X1 -> auto___def_16 X2 -> auto___def_16 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2.
  cut (auto___def_16 X2 -> auto___def_16 X2). tauto. exact (rem_231 epsilon_mtestable_old_p__type_12 X2).
Defined.

Remark rem_233 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_15 X1 -> auto___def_16 X2 -> (auto___def_15 X1 /\ auto___def_16 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1 A2.
  cut (auto___def_15 X1). 2:apply (rem_230 epsilon_mtestable_old_p__type_12 X1 X2);  assumption.
  cut (auto___def_16 X2). 2:apply (rem_232 epsilon_mtestable_old_p__type_12 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_234 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_15 X1 -> auto___def_16 X2 -> auto___type_12 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1 A2.
  case (rem_233 epsilon_mtestable_old_p__type_12 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_12 A1 A2. intros. apply trans___type_12_enc_2;  tauto.
 clear  epsilon_mtestable_old_p__type_12 A1 A2. tauto.
Defined.

Remark rem_235 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1:term, auto___def_19 X1 -> auto___def_19 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_236 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto___def_19 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2.
  cut (auto___def_19 X1 -> auto___def_19 X1). tauto. exact (rem_235 epsilon_mtestable_old_p__type_12 X1).
Defined.

Remark rem_237 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X2:term, auto___def_20 X2 -> auto___def_20 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_238 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto___def_20 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2.
  cut (auto___def_20 X2 -> auto___def_20 X2). tauto. exact (rem_237 epsilon_mtestable_old_p__type_12 X2).
Defined.

Remark rem_239 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> (auto___def_19 X1 /\ auto___def_20 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1 A2.
  cut (auto___def_19 X1). 2:apply (rem_236 epsilon_mtestable_old_p__type_12 X1 X2);  assumption.
  cut (auto___def_20 X2). 2:apply (rem_238 epsilon_mtestable_old_p__type_12 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_240 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto___type_12 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1 A2.
  case (rem_239 epsilon_mtestable_old_p__type_12 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_12 A1 A2. intros. apply trans___type_12_enc_3;  tauto.
 clear  epsilon_mtestable_old_p__type_12 A1 A2. tauto.
Defined.

Remark rem_241 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto_testable_old X1 -> auto_knows_old X2 -> auto___type_12 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1 A2.
  case (rem_220 epsilon_mtestable_old_p__type_12 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_12 A1 A2. intros. apply trans___type_12_enc_4;  tauto.
 clear  epsilon_mtestable_old_p__type_12 A1 A2. tauto.
Defined.

Remark rem_242 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto_testable_old (enc X1 X2) -> auto___type_12 (enc X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intro H. intros.
  elim (rem_118 X1 X2 H);  intros.
  apply (rem_228 epsilon_mtestable_old_p__type_12 X1 X2);  tauto.
  apply (rem_234 epsilon_mtestable_old_p__type_12 X1 X2);  tauto.
  apply (rem_240 epsilon_mtestable_old_p__type_12 X1 X2);  tauto.
  apply (rem_241 epsilon_mtestable_old_p__type_12 X1 X2);  tauto.
Defined.

Remark rem_243 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X2:term, auto_testable_old X2 -> auto_testable_old X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_244 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X2:term, auto_testable_old X2 -> auto_testable_old X2 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X2. intros A1.
  cut (auto_testable_old X2). 2:apply (rem_243 epsilon_mtestable_old_p__type_12 X2);  assumption.
  tauto.
Defined.

Remark rem_245 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto_testable_old X2 -> auto___type_12 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1.
  case (rem_244 epsilon_mtestable_old_p__type_12 X2 A1). clear  epsilon_mtestable_old_p__type_12 A1. intros. apply trans___type_12_cons_1;  tauto.
 clear  epsilon_mtestable_old_p__type_12 A1. tauto.
Defined.

Remark rem_246 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto_testable_old X1 -> auto___type_12 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1.
  case (rem_213 epsilon_mtestable_old_p__type_12 X1 A1). clear  epsilon_mtestable_old_p__type_12 A1. intros. apply trans___type_12_cons_2;  tauto.
 clear  epsilon_mtestable_old_p__type_12 A1. tauto.
Defined.

Remark rem_247 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto_testable_old (cons X1 X2) -> auto___type_12 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intro H. intros.
  elim (rem_124 X1 X2 H);  intros.
  apply (rem_245 epsilon_mtestable_old_p__type_12 X1 X2);  tauto.
  apply (rem_246 epsilon_mtestable_old_p__type_12 X1 X2);  tauto.
Defined.

Remark rem_248 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1:term, auto_testable_old X1 -> auto___type_12 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1. intros A1.
  case (rem_213 epsilon_mtestable_old_p__type_12 X1 A1). clear  epsilon_mtestable_old_p__type_12 A1. intros. apply trans___type_12_s_1;  tauto.
 clear  epsilon_mtestable_old_p__type_12 A1. tauto.
Defined.

Remark rem_249 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1:term, auto_testable_old (s X1) -> auto___type_12 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1. intro H. intros.
  elim (rem_127 X1 H);  intros.
  apply (rem_248 epsilon_mtestable_old_p__type_12 X1);  tauto.
Defined.

Remark rem_250 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> auto___type_12 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12.  case (rem_209 epsilon_mtestable_old_p__type_12). clear  epsilon_mtestable_old_p__type_12. intros. apply trans___type_12_i_1;  tauto.
 clear  epsilon_mtestable_old_p__type_12. tauto.
Defined.

Remark rem_251 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> auto_testable_old i -> auto___type_12 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intro H. intros.
  elim (rem_130 H);  intros.
  apply (rem_250 epsilon_mtestable_old_p__type_12);  tauto.
Defined.

Remark rem_252 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> auto___type_12 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12.  case (rem_209 epsilon_mtestable_old_p__type_12). clear  epsilon_mtestable_old_p__type_12. intros. apply trans___type_12_nil_1;  tauto.
 clear  epsilon_mtestable_old_p__type_12. tauto.
Defined.

Remark rem_253 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> auto_testable_old nil -> auto___type_12 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intro H. intros.
  elim (rem_133 H);  intros.
  apply (rem_252 epsilon_mtestable_old_p__type_12);  tauto.
Defined.

Remark rem_254 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> auto___type_12 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12.  case (rem_209 epsilon_mtestable_old_p__type_12). clear  epsilon_mtestable_old_p__type_12. intros. apply trans___type_12_server_1;  tauto.
 clear  epsilon_mtestable_old_p__type_12. tauto.
Defined.

Remark rem_255 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> auto_testable_old server -> auto___type_12 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intro H. intros.
  elim (rem_136 H);  intros.
  apply (rem_254 epsilon_mtestable_old_p__type_12);  tauto.
Defined.

Remark rem_256 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1:term, auto___def_60 X1 -> auto___def_60 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_257 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_60 X1 -> auto___type_16 X2 -> auto___def_60 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2.
  cut (auto___def_60 X1 -> auto___def_60 X1). tauto. exact (rem_256 epsilon_mtestable_old_p__type_12 X1).
Defined.

Remark rem_258 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X2:term, auto___type_16 X2 -> auto___type_16 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_259 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_60 X1 -> auto___type_16 X2 -> auto___type_16 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2.
  cut (auto___type_16 X2 -> auto___type_16 X2). tauto. exact (rem_258 epsilon_mtestable_old_p__type_12 X2).
Defined.

Remark rem_260 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_60 X1 -> auto___type_16 X2 -> (auto___def_60 X1 /\ auto___type_16 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1 A2.
  cut (auto___def_60 X1). 2:apply (rem_257 epsilon_mtestable_old_p__type_12 X1 X2);  assumption.
  cut (auto___type_16 X2). 2:apply (rem_259 epsilon_mtestable_old_p__type_12 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_261 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_60 X1 -> auto___type_16 X2 -> auto___type_12 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1 A2.
  case (rem_260 epsilon_mtestable_old_p__type_12 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_12 A1 A2. intros. apply trans___type_12_key_1;  tauto.
 clear  epsilon_mtestable_old_p__type_12 A1 A2. tauto.
Defined.

Remark rem_262 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1:term, auto___def_55 X1 -> auto___def_55 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_263 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_4 X2 -> auto___def_55 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2.
  cut (auto___def_55 X1 -> auto___def_55 X1). tauto. exact (rem_262 epsilon_mtestable_old_p__type_12 X1).
Defined.

Remark rem_264 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X2:term, auto___def_4 X2 -> auto___def_4 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_265 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_4 X2 -> auto___def_4 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2.
  cut (auto___def_4 X2 -> auto___def_4 X2). tauto. exact (rem_264 epsilon_mtestable_old_p__type_12 X2).
Defined.

Remark rem_266 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_4 X2 -> (auto___def_55 X1 /\ auto___def_4 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1 A2.
  cut (auto___def_55 X1). 2:apply (rem_263 epsilon_mtestable_old_p__type_12 X1 X2);  assumption.
  cut (auto___def_4 X2). 2:apply (rem_265 epsilon_mtestable_old_p__type_12 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_267 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_4 X2 -> auto___type_12 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1 A2.
  case (rem_266 epsilon_mtestable_old_p__type_12 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_12 A1 A2. intros. apply trans___type_12_key_2;  tauto.
 clear  epsilon_mtestable_old_p__type_12 A1 A2. tauto.
Defined.

Remark rem_268 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1:term, auto___def_51 X1 -> auto___def_51 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_269 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto___def_51 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2.
  cut (auto___def_51 X1 -> auto___def_51 X1). tauto. exact (rem_268 epsilon_mtestable_old_p__type_12 X1).
Defined.

Remark rem_270 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_271 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_270 epsilon_mtestable_old_p__type_12 X2).
Defined.

Remark rem_272 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> (auto___def_51 X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1 A2.
  cut (auto___def_51 X1). 2:apply (rem_269 epsilon_mtestable_old_p__type_12 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_271 epsilon_mtestable_old_p__type_12 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_273 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto___type_12 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intros A1 A2.
  case (rem_272 epsilon_mtestable_old_p__type_12 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_12 A1 A2. intros. apply trans___type_12_key_3;  tauto.
 clear  epsilon_mtestable_old_p__type_12 A1 A2. tauto.
Defined.

Remark rem_274 : (forall X:term, auto_testable_old X -> auto___type_12 X)
    -> forall X1 X2:term, auto_testable_old (key X1 X2) -> auto___type_12 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_12. intros X1 X2. intro H. intros.
  elim (rem_156 X1 X2 H);  intros.
  apply (rem_261 epsilon_mtestable_old_p__type_12 X1 X2);  tauto.
  apply (rem_267 epsilon_mtestable_old_p__type_12 X1 X2);  tauto.
  apply (rem_273 epsilon_mtestable_old_p__type_12 X1 X2);  tauto.
Defined.

Remark rem_275 : forall X1:term, auto_testable_old X1 -> auto___type_12 X1. (* Induct. *)
Proof.
  fix epsilon_mtestable_old_p__type_12 1.
  intro X. case X.
  exact (rem_217 epsilon_mtestable_old_p__type_12 ).
  exact (rem_211 epsilon_mtestable_old_p__type_12 ).
  intros X1 X2;  exact (rem_247 epsilon_mtestable_old_p__type_12 X1 X2).
  intros X1 X2;  exact (rem_208 epsilon_mtestable_old_p__type_12 X1 X2).
  intros X1 X2;  exact (rem_222 epsilon_mtestable_old_p__type_12 X1 X2).
  intros X1 X2;  exact (rem_242 epsilon_mtestable_old_p__type_12 X1 X2).
  exact (rem_251 epsilon_mtestable_old_p__type_12 ).
  intros X1 X2;  exact (rem_274 epsilon_mtestable_old_p__type_12 X1 X2).
  exact (rem_253 epsilon_mtestable_old_p__type_12 ).
  intros X1 X2. intro H. elim (rem_170 X1 X2 H).
  intros X1 X2. intro H. elim (rem_160 X1 X2 H).
  intros X1 X2. intro H. elim (rem_158 X1 X2 H).
  intros X1 X2. intro H. elim (rem_167 X1 X2 H).
  intros X1;  exact (rem_215 epsilon_mtestable_old_p__type_12 X1).
  intros X1 X2. intro H. elim (rem_165 X1 X2 H).
  intros X1 X2. intro H. elim (rem_164 X1 X2 H).
   intro H. elim (rem_166  H).
   intro H. elim (rem_163  H).
  intros X1 X2. intro H. elim (rem_162 X1 X2 H).
  intros X1 X2. intro H. elim (rem_161 X1 X2 H).
  intros X1;  exact (rem_249 epsilon_mtestable_old_p__type_12 X1).
  exact (rem_255 epsilon_mtestable_old_p__type_12 ).
  intros X1 X2. intro H. elim (rem_169 X1 X2 H).
  intros X1 X2. intro H. elim (rem_159 X1 X2 H).
   intro H. elim (rem_168  H).
Qed.

Remark rem_276 : forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_277 : forall X1 X3:term, auto___def_24 X3 -> auto_knows_old X1 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X3.
  cut (auto_knows_old X1 -> auto_knows_old X1). tauto. exact (rem_276 X1).
Qed.

Remark rem_278 : forall X1 X3:term, auto___def_24 X3 -> auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X3. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_277 X1 X3);  assumption.
  tauto.
Qed.

Remark rem_279 : forall X1 X2 X3:term, auto___def_24 X3 -> auto_knows_old X1 -> auto___def_34 (r_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2.
  case (rem_278 X1 X3 A1 A2). clear  A1 A2. intros. apply trans___def_34_r_old_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_280 : forall X1 X3:term, auto___def_28 X3 -> auto_knows_old X1 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X3.
  cut (auto_knows_old X1 -> auto_knows_old X1). tauto. exact (rem_276 X1).
Qed.

Remark rem_281 : forall X1 X3:term, auto___def_28 X3 -> auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X3. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_280 X1 X3);  assumption.
  tauto.
Qed.

Remark rem_282 : forall X1 X2 X3:term, auto___def_28 X3 -> auto_knows_old X1 -> auto___def_34 (r_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2.
  case (rem_281 X1 X3 A1 A2). clear  A1 A2. intros. apply trans___def_34_r_old_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_283 : forall X1 X3:term, auto___type_7 X3 -> auto_knows_old X1 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X3.
  cut (auto_knows_old X1 -> auto_knows_old X1). tauto. exact (rem_276 X1).
Qed.

Remark rem_284 : forall X1 X3:term, auto___type_7 X3 -> auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X3. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_283 X1 X3);  assumption.
  tauto.
Qed.

Remark rem_285 : forall X1 X2 X3:term, auto___type_7 X3 -> auto_knows_old X1 -> auto___def_34 (r_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2.
  case (rem_284 X1 X3 A1 A2). clear  A1 A2. intros. apply trans___def_34_r_old_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_286 : forall X1 X2 X3:term, auto___def_27 X1 X2 X3 -> or_3
    (auto___def_24 X2 /\ auto_knows_old X3)
    (auto___def_28 X2 /\ auto_knows_old X3)
    (auto___type_7 X2 /\ auto_knows_old X3)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_287 : forall X1 X2 X3:term, auto___def_27 X2 X3 X1 -> auto___def_34 (r_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_286 X2 X3 X1 H);  intros.
  apply (rem_279 X1 X2 X3);  tauto.
  apply (rem_282 X1 X2 X3);  tauto.
  apply (rem_285 X1 X2 X3);  tauto.
Qed.

Remark rem_288 : forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_289 : forall X1 X3:term, auto___type_22 X3 -> auto_knows_current X1 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X3.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_288 X1).
Qed.

Remark rem_290 : forall X1 X3:term, auto___type_22 X3 -> auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X3. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_289 X1 X3);  assumption.
  tauto.
Qed.

Remark rem_291 : forall X1 X2 X3:term, auto___type_22 X3 -> auto_knows_current X1 -> auto___def_102 (r_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2.
  case (rem_290 X1 X3 A1 A2). clear  A1 A2. intros. apply trans___def_102_r_current_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_292 : forall X1 X3:term, auto___def_96 X3 -> auto_knows_current X1 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X3.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_288 X1).
Qed.

Remark rem_293 : forall X1 X3:term, auto___def_96 X3 -> auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X3. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_292 X1 X3);  assumption.
  tauto.
Qed.

Remark rem_294 : forall X1 X2 X3:term, auto___def_96 X3 -> auto_knows_current X1 -> auto___def_102 (r_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2.
  case (rem_293 X1 X3 A1 A2). clear  A1 A2. intros. apply trans___def_102_r_current_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_295 : forall X1 X3:term, auto___def_84 X3 -> auto_knows_current X1 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X3.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_288 X1).
Qed.

Remark rem_296 : forall X1 X3:term, auto___def_84 X3 -> auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X3. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_295 X1 X3);  assumption.
  tauto.
Qed.

Remark rem_297 : forall X1 X2 X3:term, auto___def_84 X3 -> auto_knows_current X1 -> auto___def_102 (r_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2.
  case (rem_296 X1 X3 A1 A2). clear  A1 A2. intros. apply trans___def_102_r_current_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_298 : forall X1 X2 X3:term, auto___def_95 X1 X2 X3 -> or_3
    (auto___type_22 X2 /\ auto_knows_current X3)
    (auto___def_96 X2 /\ auto_knows_current X3)
    (auto___def_84 X2 /\ auto_knows_current X3)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_299 : forall X1 X2 X3:term, auto___def_95 X2 X3 X1 -> auto___def_102 (r_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_298 X2 X3 X1 H);  intros.
  apply (rem_291 X1 X2 X3);  tauto.
  apply (rem_294 X1 X2 X3);  tauto.
  apply (rem_297 X1 X2 X3);  tauto.
Qed.

Remark rem_300 : forall X1 X2 X3 X4:term, auto_knows_old (crypt (cons (noncea_old X4 X2) (cons X3 nil)) (key sym X1)) -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1.
  tauto.
Qed.

Remark rem_301 : forall X1 X2 X3 X4:term, auto_knows_old (crypt (cons (noncea_old X4 X2) (cons X3 nil)) (key sym X1)) -> auto___def_46 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1.
  case (rem_300 X1 X2 X3 X4 A1). clear  A1. intros. apply trans___def_46_1;  tauto.
 clear  A1. tauto.
Qed.

Remark rem_302 : (forall X:term, auto___def_77 X -> auto___type_19 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_303 : (forall X:term, auto___def_77 X -> auto___type_19 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_77_p__type_19. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_302 epsilon_m__def_77_p__type_19 X1);  assumption.
  tauto.
Defined.

Remark rem_304 : (forall X:term, auto___def_77 X -> auto___type_19 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto___type_19 (r_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_77_p__type_19. intros X1 X2. intros A1.
  case (rem_303 epsilon_m__def_77_p__type_19 X1 A1). clear  epsilon_m__def_77_p__type_19 A1. intros. apply trans___type_19_r_current_1;  tauto.
 clear  epsilon_m__def_77_p__type_19 A1. tauto.
Defined.

Remark rem_305 : (forall X:term, auto___def_77 X -> auto___type_19 X)
    -> forall X1 X2:term, auto___def_77 (r_current X1 X2) -> auto___type_19 (r_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_77_p__type_19. intros X1 X2. intro H. intros.
  elim (rem_12 X1 X2 H);  intros.
  apply (rem_304 epsilon_m__def_77_p__type_19 X1 X2);  tauto.
Defined.

Remark rem_306 : forall X1:term, auto___def_77 X1 -> auto___type_19 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_77_p__type_19 1.
  intro X. case X.
   intro H. elim (rem_24  H).
   intro H. elim (rem_17  H).
  intros X1 X2. intro H. elim (rem_29 X1 X2 H).
  intros X1 X2. intro H. elim (rem_14 X1 X2 H).
  intros X1 X2. intro H. elim (rem_27 X1 X2 H).
  intros X1 X2. intro H. elim (rem_28 X1 X2 H).
   intro H. elim (rem_33  H).
  intros X1 X2. intro H. elim (rem_37 X1 X2 H).
   intro H. elim (rem_34  H).
  intros X1 X2. intro H. elim (rem_36 X1 X2 H).
  intros X1 X2. intro H. elim (rem_18 X1 X2 H).
  intros X1 X2. intro H. elim (rem_15 X1 X2 H).
  intros X1 X2. intro H. elim (rem_26 X1 X2 H).
  intros X1. intro H. elim (rem_20 X1 H).
  intros X1 X2. intro H. elim (rem_23 X1 X2 H).
  intros X1 X2. intro H. elim (rem_22 X1 X2 H).
   intro H. elim (rem_25  H).
   intro H. elim (rem_21  H).
  intros X1 X2;  exact (rem_305 epsilon_m__def_77_p__type_19 X1 X2).
  intros X1 X2. intro H. elim (rem_19 X1 X2 H).
  intros X1. intro H. elim (rem_30 X1 H).
   intro H. elim (rem_35  H).
  intros X1 X2. intro H. elim (rem_32 X1 X2 H).
  intros X1 X2. intro H. elim (rem_16 X1 X2 H).
   intro H. elim (rem_31  H).
Qed.

Remark rem_307 : forall X1 X2 X3:term, auto___def_77 X1 -> auto_agent X2 -> auto_agent X3 -> auto___type_19 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_77 X1 -> auto___type_19 X1). tauto. exact (rem_306 X1).
Qed.

Remark rem_308 : forall X1 X2 X3:term, auto___def_83 X1 X2 X3 -> or_1
    (auto___def_77 X1 /\ auto_agent X2 /\ auto_agent X3)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_309 : forall X1 X2 X3:term, auto___def_83 X1 X2 X3 -> auto___type_19 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_308 X1 X2 X3 H);  intros.
  apply (rem_307 X1 X2 X3);  tauto.
Qed.

Remark rem_310 : (forall X:term, auto___def_62 X -> auto___type_30 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_62_p__type_30.  tauto.
Defined.

Remark rem_311 : (forall X:term, auto___def_62 X -> auto___type_30 X)
    -> auto___type_30 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_62_p__type_30.  case (rem_310 epsilon_m__def_62_p__type_30). clear  epsilon_m__def_62_p__type_30. intros. apply trans___type_30_i_1;  tauto.
 clear  epsilon_m__def_62_p__type_30. tauto.
Defined.

Remark rem_312 : auto___def_62 i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_313 : (forall X:term, auto___def_62 X -> auto___type_30 X)
    -> auto___def_62 i -> auto___type_30 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_62_p__type_30. intro H. intros.
  elim (rem_312 H);  intros.
  apply (rem_311 epsilon_m__def_62_p__type_30);  tauto.
Defined.

Remark rem_314 : forall X1 X2:term, auto___def_62 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_315 : forall X1 X2:term, auto___def_62 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_316 : forall X1 X2:term, auto___def_62 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_317 : auto___def_62 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_318 : forall X1 X2:term, auto___def_62 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_319 : forall X1 X2:term, auto___def_62 (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_320 : forall X1 X2:term, auto___def_62 (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_321 : forall X1:term, auto___def_62 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_322 : auto___def_62 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_323 : forall X1 X2:term, auto___def_62 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_324 : forall X1 X2:term, auto___def_62 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_325 : auto___def_62 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_326 : auto___def_62 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_327 : forall X1 X2:term, auto___def_62 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_328 : forall X1 X2:term, auto___def_62 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_329 : forall X1 X2:term, auto___def_62 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_330 : forall X1 X2:term, auto___def_62 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_331 : forall X1:term, auto___def_62 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_332 : auto___def_62 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_333 : forall X1 X2:term, auto___def_62 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_334 : auto___def_62 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_335 : auto___def_62 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_336 : forall X1 X2:term, auto___def_62 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_337 : forall X1 X2:term, auto___def_62 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_338 : forall X1:term, auto___def_62 X1 -> auto___type_30 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_62_p__type_30 1.
  intro X. case X.
   intro H. elim (rem_325  H).
   intro H. elim (rem_317  H).
  intros X1 X2. intro H. elim (rem_330 X1 X2 H).
  intros X1 X2. intro H. elim (rem_314 X1 X2 H).
  intros X1 X2. intro H. elim (rem_328 X1 X2 H).
  intros X1 X2. intro H. elim (rem_329 X1 X2 H).
  exact (rem_313 epsilon_m__def_62_p__type_30 ).
  intros X1 X2. intro H. elim (rem_337 X1 X2 H).
   intro H. elim (rem_334  H).
  intros X1 X2. intro H. elim (rem_336 X1 X2 H).
  intros X1 X2. intro H. elim (rem_318 X1 X2 H).
  intros X1 X2. intro H. elim (rem_315 X1 X2 H).
  intros X1 X2. intro H. elim (rem_327 X1 X2 H).
  intros X1. intro H. elim (rem_321 X1 H).
  intros X1 X2. intro H. elim (rem_324 X1 X2 H).
  intros X1 X2. intro H. elim (rem_323 X1 X2 H).
   intro H. elim (rem_326  H).
   intro H. elim (rem_322  H).
  intros X1 X2. intro H. elim (rem_320 X1 X2 H).
  intros X1 X2. intro H. elim (rem_319 X1 X2 H).
  intros X1. intro H. elim (rem_331 X1 H).
   intro H. elim (rem_335  H).
  intros X1 X2. intro H. elim (rem_333 X1 X2 H).
  intros X1 X2. intro H. elim (rem_316 X1 X2 H).
   intro H. elim (rem_332  H).
Qed.

Remark rem_339 : forall X1 X2:term, auto___def_62 X1 -> auto_knows_current X2 -> auto_testable_current X2 -> auto___type_30 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_62 X1 -> auto___type_30 X1). tauto. exact (rem_338 X1).
Qed.

Remark rem_340 : forall X1 X2:term, auto___def_65 X1 X2 -> or_1
    (auto___def_62 X1 /\ auto_knows_current X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_341 : forall X1 X2:term, auto___def_65 X1 X2 -> auto_testable_current X2 -> auto___type_30 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_340 X1 X2 H);  intros.
  apply (rem_339 X1 X2);  tauto.
Qed.

Remark rem_342 : forall X1:term, auto___def_71 X1 -> auto___def_71 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_343 : forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto___def_71 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_71 X1 -> auto___def_71 X1). tauto. exact (rem_342 X1).
Qed.

Remark rem_344 : forall X2:term, auto___def_72 X2 -> auto___def_72 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_345 : forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto___def_72 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_72 X2 -> auto___def_72 X2). tauto. exact (rem_344 X2).
Qed.

Remark rem_346 : forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> (auto___def_71 X1 /\ auto___def_72 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_71 X1). 2:apply (rem_343 X1 X2);  assumption.
  cut (auto___def_72 X2). 2:apply (rem_345 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_347 : forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto___def_70 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_346 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_70_enc_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_348 : forall X1 X2:term, auto___def_72 X2 -> auto___def_71 X1 -> auto___def_70 (enc X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_71 X1 -> auto___def_72 X2 -> auto___def_70 (enc X1 X2)). tauto. exact (rem_347 X1 X2).
Qed.

Remark rem_349 : forall X1 X2 X3:term, auto___type_22 X3 -> auto_knows_current X1 -> auto___def_99 (nonceb_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2.
  case (rem_290 X1 X3 A1 A2). clear  A1 A2. intros. apply trans___def_99_nonceb_current_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_350 : forall X1 X2 X3:term, auto___def_96 X3 -> auto_knows_current X1 -> auto___def_99 (nonceb_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2.
  case (rem_293 X1 X3 A1 A2). clear  A1 A2. intros. apply trans___def_99_nonceb_current_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_351 : forall X1 X2 X3:term, auto___def_84 X3 -> auto_knows_current X1 -> auto___def_99 (nonceb_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2.
  case (rem_296 X1 X3 A1 A2). clear  A1 A2. intros. apply trans___def_99_nonceb_current_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_352 : forall X1 X2 X3:term, auto___def_95 X2 X3 X1 -> auto___def_99 (nonceb_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_298 X2 X3 X1 H);  intros.
  apply (rem_349 X1 X2 X3);  tauto.
  apply (rem_350 X1 X2 X3);  tauto.
  apply (rem_351 X1 X2 X3);  tauto.
Qed.

Remark rem_353 : forall X1:term, auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_288 X1);  assumption.
  tauto.
Qed.

Remark rem_354 : forall X1 X2:term, auto_knows_current X1 -> auto___def_108 (r_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1.
  case (rem_353 X1 A1). clear  A1. intros. apply trans___def_108_r_current_1;  tauto.
 clear  A1. tauto.
Qed.

Remark rem_355 : forall X1 X2:term, auto___def_107 X1 X2 -> or_1
    (auto_knows_current X2).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_356 : forall X1 X2:term, auto___def_107 X2 X1 -> auto___def_108 (r_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_355 X2 X1 H);  intros.
  apply (rem_354 X1 X2);  tauto.
Qed.

Remark rem_357 : (forall X:term, auto___type_19 X -> auto___type_31 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_358 : (forall X:term, auto___type_19 X -> auto___type_31 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_19_p__type_31. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_357 epsilon_m__type_19_p__type_31 X1);  assumption.
  tauto.
Defined.

Remark rem_359 : (forall X:term, auto___type_19 X -> auto___type_31 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto___type_31 (r_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_19_p__type_31. intros X1 X2. intros A1.
  case (rem_358 epsilon_m__type_19_p__type_31 X1 A1). clear  epsilon_m__type_19_p__type_31 A1. intros. apply trans___type_31_r_current_1;  tauto.
 clear  epsilon_m__type_19_p__type_31 A1. tauto.
Defined.

Remark rem_360 : forall X1 X2:term, auto___type_19 (r_current X1 X2) -> or_1
    (auto_knows_current X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_361 : (forall X:term, auto___type_19 X -> auto___type_31 X)
    -> forall X1 X2:term, auto___type_19 (r_current X1 X2) -> auto___type_31 (r_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_19_p__type_31. intros X1 X2. intro H. intros.
  elim (rem_360 X1 X2 H);  intros.
  apply (rem_359 epsilon_m__type_19_p__type_31 X1 X2);  tauto.
Defined.

Remark rem_362 : forall X1 X2:term, auto___type_19 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_363 : forall X1 X2:term, auto___type_19 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_364 : forall X1 X2:term, auto___type_19 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_365 : auto___type_19 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_366 : forall X1 X2:term, auto___type_19 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_367 : forall X1 X2:term, auto___type_19 (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_368 : forall X1:term, auto___type_19 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_369 : auto___type_19 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_370 : forall X1 X2:term, auto___type_19 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_371 : forall X1 X2:term, auto___type_19 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_372 : auto___type_19 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_373 : auto___type_19 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_374 : forall X1 X2:term, auto___type_19 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_375 : forall X1 X2:term, auto___type_19 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_376 : forall X1 X2:term, auto___type_19 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_377 : forall X1 X2:term, auto___type_19 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_378 : forall X1:term, auto___type_19 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_379 : auto___type_19 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_380 : forall X1 X2:term, auto___type_19 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_381 : auto___type_19 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_382 : auto___type_19 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_383 : auto___type_19 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_384 : forall X1 X2:term, auto___type_19 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_385 : forall X1 X2:term, auto___type_19 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_386 : forall X1:term, auto___type_19 X1 -> auto___type_31 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_19_p__type_31 1.
  intro X. case X.
   intro H. elim (rem_372  H).
   intro H. elim (rem_365  H).
  intros X1 X2. intro H. elim (rem_377 X1 X2 H).
  intros X1 X2. intro H. elim (rem_362 X1 X2 H).
  intros X1 X2. intro H. elim (rem_375 X1 X2 H).
  intros X1 X2. intro H. elim (rem_376 X1 X2 H).
   intro H. elim (rem_381  H).
  intros X1 X2. intro H. elim (rem_385 X1 X2 H).
   intro H. elim (rem_382  H).
  intros X1 X2. intro H. elim (rem_384 X1 X2 H).
  intros X1 X2. intro H. elim (rem_366 X1 X2 H).
  intros X1 X2. intro H. elim (rem_363 X1 X2 H).
  intros X1 X2. intro H. elim (rem_374 X1 X2 H).
  intros X1. intro H. elim (rem_368 X1 H).
  intros X1 X2. intro H. elim (rem_371 X1 X2 H).
  intros X1 X2. intro H. elim (rem_370 X1 X2 H).
   intro H. elim (rem_373  H).
   intro H. elim (rem_369  H).
  intros X1 X2;  exact (rem_361 epsilon_m__type_19_p__type_31 X1 X2).
  intros X1 X2. intro H. elim (rem_367 X1 X2 H).
  intros X1. intro H. elim (rem_378 X1 H).
   intro H. elim (rem_383  H).
  intros X1 X2. intro H. elim (rem_380 X1 X2 H).
  intros X1 X2. intro H. elim (rem_364 X1 X2 H).
   intro H. elim (rem_379  H).
Qed.

Remark rem_387 : forall X1 X2:term, auto___def_84 X2 -> auto___type_19 X1 -> auto_testable_current X2 -> auto___type_31 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_19 X1 -> auto___type_31 X1). tauto. exact (rem_386 X1).
Qed.

Remark rem_388 : forall X1 X2:term, auto___type_19 X1 -> auto___def_84 X2 -> auto_testable_current X2 -> auto___type_31 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_84 X2 -> auto___type_19 X1 -> auto_testable_current X2 -> auto___type_31 X1). tauto. exact (rem_387 X1 X2).
Qed.

Remark rem_389 : (forall X:term, auto___def_42 X -> auto___type_31 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_390 : (forall X:term, auto___def_42 X -> auto___type_31 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_42_p__type_31. intros X1. intros A1.
  cut (auto_knows_old X1). 2:apply (rem_389 epsilon_m__def_42_p__type_31 X1);  assumption.
  tauto.
Defined.

Remark rem_391 : (forall X:term, auto___def_42 X -> auto___type_31 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto___type_31 (r_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_42_p__type_31. intros X1 X2. intros A1.
  case (rem_390 epsilon_m__def_42_p__type_31 X1 A1). clear  epsilon_m__def_42_p__type_31 A1. intros. apply trans___type_31_r_old_1;  tauto.
 clear  epsilon_m__def_42_p__type_31 A1. tauto.
Defined.

Remark rem_392 : forall X1 X2:term, auto___def_42 (r_old X1 X2) -> or_1
    (auto_knows_old X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_393 : (forall X:term, auto___def_42 X -> auto___type_31 X)
    -> forall X1 X2:term, auto___def_42 (r_old X1 X2) -> auto___type_31 (r_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_42_p__type_31. intros X1 X2. intro H. intros.
  elim (rem_392 X1 X2 H);  intros.
  apply (rem_391 epsilon_m__def_42_p__type_31 X1 X2);  tauto.
Defined.

Remark rem_394 : forall X1 X2:term, auto___def_42 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_395 : forall X1 X2:term, auto___def_42 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_396 : forall X1 X2:term, auto___def_42 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_397 : auto___def_42 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_398 : forall X1 X2:term, auto___def_42 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_399 : forall X1 X2:term, auto___def_42 (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_400 : forall X1:term, auto___def_42 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_401 : auto___def_42 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_402 : forall X1 X2:term, auto___def_42 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_403 : forall X1 X2:term, auto___def_42 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_404 : auto___def_42 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_405 : auto___def_42 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_406 : forall X1 X2:term, auto___def_42 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_407 : forall X1 X2:term, auto___def_42 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_408 : forall X1 X2:term, auto___def_42 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_409 : forall X1 X2:term, auto___def_42 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_410 : forall X1:term, auto___def_42 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_411 : auto___def_42 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_412 : forall X1 X2:term, auto___def_42 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_413 : auto___def_42 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_414 : auto___def_42 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_415 : auto___def_42 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_416 : forall X1 X2:term, auto___def_42 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_417 : forall X1 X2:term, auto___def_42 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_418 : forall X1:term, auto___def_42 X1 -> auto___type_31 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_42_p__type_31 1.
  intro X. case X.
   intro H. elim (rem_404  H).
   intro H. elim (rem_397  H).
  intros X1 X2. intro H. elim (rem_409 X1 X2 H).
  intros X1 X2. intro H. elim (rem_394 X1 X2 H).
  intros X1 X2. intro H. elim (rem_407 X1 X2 H).
  intros X1 X2. intro H. elim (rem_408 X1 X2 H).
   intro H. elim (rem_413  H).
  intros X1 X2. intro H. elim (rem_417 X1 X2 H).
   intro H. elim (rem_414  H).
  intros X1 X2. intro H. elim (rem_416 X1 X2 H).
  intros X1 X2. intro H. elim (rem_398 X1 X2 H).
  intros X1 X2. intro H. elim (rem_395 X1 X2 H).
  intros X1 X2. intro H. elim (rem_406 X1 X2 H).
  intros X1. intro H. elim (rem_400 X1 H).
  intros X1 X2. intro H. elim (rem_403 X1 X2 H).
  intros X1 X2. intro H. elim (rem_402 X1 X2 H).
   intro H. elim (rem_405  H).
   intro H. elim (rem_401  H).
  intros X1 X2. intro H. elim (rem_399 X1 X2 H).
  intros X1 X2;  exact (rem_393 epsilon_m__def_42_p__type_31 X1 X2).
  intros X1. intro H. elim (rem_410 X1 H).
   intro H. elim (rem_415  H).
  intros X1 X2. intro H. elim (rem_412 X1 X2 H).
  intros X1 X2. intro H. elim (rem_396 X1 X2 H).
   intro H. elim (rem_411  H).
Qed.

Remark rem_419 : forall X1 X2:term, auto___def_36 X2 -> auto___def_42 X1 -> auto_testable_current X2 -> auto___type_31 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_42 X1 -> auto___type_31 X1). tauto. exact (rem_418 X1).
Qed.

Remark rem_420 : forall X1 X2:term, auto___def_42 X1 -> auto___def_36 X2 -> auto_testable_current X2 -> auto___type_31 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_36 X2 -> auto___def_42 X1 -> auto_testable_current X2 -> auto___type_31 X1). tauto. exact (rem_419 X1 X2).
Qed.

Remark rem_421 : (forall X:term, auto___type_23 X -> auto___type_31 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_422 : (forall X:term, auto___type_23 X -> auto___type_31 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_23_p__type_31. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_421 epsilon_m__type_23_p__type_31 X1);  assumption.
  tauto.
Defined.

Remark rem_423 : (forall X:term, auto___type_23 X -> auto___type_31 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto___type_31 (r_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_23_p__type_31. intros X1 X2. intros A1.
  case (rem_422 epsilon_m__type_23_p__type_31 X1 A1). clear  epsilon_m__type_23_p__type_31 A1. intros. apply trans___type_31_r_current_1;  tauto.
 clear  epsilon_m__type_23_p__type_31 A1. tauto.
Defined.

Remark rem_424 : forall X1 X2:term, auto___type_23 (r_current X1 X2) -> or_1
    (auto_knows_current X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_425 : (forall X:term, auto___type_23 X -> auto___type_31 X)
    -> forall X1 X2:term, auto___type_23 (r_current X1 X2) -> auto___type_31 (r_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_23_p__type_31. intros X1 X2. intro H. intros.
  elim (rem_424 X1 X2 H);  intros.
  apply (rem_423 epsilon_m__type_23_p__type_31 X1 X2);  tauto.
Defined.

Remark rem_426 : forall X1 X2:term, auto___type_23 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_427 : forall X1 X2:term, auto___type_23 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_428 : forall X1 X2:term, auto___type_23 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_429 : auto___type_23 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_430 : forall X1 X2:term, auto___type_23 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_431 : forall X1 X2:term, auto___type_23 (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_432 : forall X1:term, auto___type_23 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_433 : auto___type_23 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_434 : forall X1 X2:term, auto___type_23 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_435 : forall X1 X2:term, auto___type_23 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_436 : auto___type_23 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_437 : auto___type_23 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_438 : forall X1 X2:term, auto___type_23 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_439 : forall X1 X2:term, auto___type_23 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_440 : forall X1 X2:term, auto___type_23 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_441 : forall X1 X2:term, auto___type_23 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_442 : forall X1:term, auto___type_23 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_443 : auto___type_23 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_444 : forall X1 X2:term, auto___type_23 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_445 : auto___type_23 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_446 : auto___type_23 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_447 : auto___type_23 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_448 : forall X1 X2:term, auto___type_23 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_449 : forall X1 X2:term, auto___type_23 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_450 : forall X1:term, auto___type_23 X1 -> auto___type_31 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_23_p__type_31 1.
  intro X. case X.
   intro H. elim (rem_436  H).
   intro H. elim (rem_429  H).
  intros X1 X2. intro H. elim (rem_441 X1 X2 H).
  intros X1 X2. intro H. elim (rem_426 X1 X2 H).
  intros X1 X2. intro H. elim (rem_439 X1 X2 H).
  intros X1 X2. intro H. elim (rem_440 X1 X2 H).
   intro H. elim (rem_445  H).
  intros X1 X2. intro H. elim (rem_449 X1 X2 H).
   intro H. elim (rem_446  H).
  intros X1 X2. intro H. elim (rem_448 X1 X2 H).
  intros X1 X2. intro H. elim (rem_430 X1 X2 H).
  intros X1 X2. intro H. elim (rem_427 X1 X2 H).
  intros X1 X2. intro H. elim (rem_438 X1 X2 H).
  intros X1. intro H. elim (rem_432 X1 H).
  intros X1 X2. intro H. elim (rem_435 X1 X2 H).
  intros X1 X2. intro H. elim (rem_434 X1 X2 H).
   intro H. elim (rem_437  H).
   intro H. elim (rem_433  H).
  intros X1 X2;  exact (rem_425 epsilon_m__type_23_p__type_31 X1 X2).
  intros X1 X2. intro H. elim (rem_431 X1 X2 H).
  intros X1. intro H. elim (rem_442 X1 H).
   intro H. elim (rem_447  H).
  intros X1 X2. intro H. elim (rem_444 X1 X2 H).
  intros X1 X2. intro H. elim (rem_428 X1 X2 H).
   intro H. elim (rem_443  H).
Qed.

Remark rem_451 : forall X1 X2:term, auto___type_22 X2 -> auto___type_23 X1 -> auto_testable_current X2 -> auto___type_31 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_23 X1 -> auto___type_31 X1). tauto. exact (rem_450 X1).
Qed.

Remark rem_452 : forall X1 X2:term, auto___type_23 X1 -> auto___type_22 X2 -> auto_testable_current X2 -> auto___type_31 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___type_22 X2 -> auto___type_23 X1 -> auto_testable_current X2 -> auto___type_31 X1). tauto. exact (rem_451 X1 X2).
Qed.

Remark rem_453 : (forall X:term, auto___type_8 X -> auto___type_31 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_454 : (forall X:term, auto___type_8 X -> auto___type_31 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_8_p__type_31. intros X1. intros A1.
  cut (auto_knows_old X1). 2:apply (rem_453 epsilon_m__type_8_p__type_31 X1);  assumption.
  tauto.
Defined.

Remark rem_455 : (forall X:term, auto___type_8 X -> auto___type_31 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto___type_31 (r_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_8_p__type_31. intros X1 X2. intros A1.
  case (rem_454 epsilon_m__type_8_p__type_31 X1 A1). clear  epsilon_m__type_8_p__type_31 A1. intros. apply trans___type_31_r_old_1;  tauto.
 clear  epsilon_m__type_8_p__type_31 A1. tauto.
Defined.

Remark rem_456 : forall X1 X2:term, auto___type_8 (r_old X1 X2) -> or_1
    (auto_knows_old X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_457 : (forall X:term, auto___type_8 X -> auto___type_31 X)
    -> forall X1 X2:term, auto___type_8 (r_old X1 X2) -> auto___type_31 (r_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_8_p__type_31. intros X1 X2. intro H. intros.
  elim (rem_456 X1 X2 H);  intros.
  apply (rem_455 epsilon_m__type_8_p__type_31 X1 X2);  tauto.
Defined.

Remark rem_458 : forall X1 X2:term, auto___type_8 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_459 : forall X1 X2:term, auto___type_8 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_460 : forall X1 X2:term, auto___type_8 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_461 : auto___type_8 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_462 : forall X1 X2:term, auto___type_8 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_463 : forall X1 X2:term, auto___type_8 (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_464 : forall X1:term, auto___type_8 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_465 : auto___type_8 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_466 : forall X1 X2:term, auto___type_8 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_467 : forall X1 X2:term, auto___type_8 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_468 : auto___type_8 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_469 : auto___type_8 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_470 : forall X1 X2:term, auto___type_8 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_471 : forall X1 X2:term, auto___type_8 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_472 : forall X1 X2:term, auto___type_8 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_473 : forall X1 X2:term, auto___type_8 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_474 : forall X1:term, auto___type_8 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_475 : auto___type_8 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_476 : forall X1 X2:term, auto___type_8 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_477 : auto___type_8 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_478 : auto___type_8 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_479 : auto___type_8 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_480 : forall X1 X2:term, auto___type_8 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_481 : forall X1 X2:term, auto___type_8 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_482 : forall X1:term, auto___type_8 X1 -> auto___type_31 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_8_p__type_31 1.
  intro X. case X.
   intro H. elim (rem_468  H).
   intro H. elim (rem_461  H).
  intros X1 X2. intro H. elim (rem_473 X1 X2 H).
  intros X1 X2. intro H. elim (rem_458 X1 X2 H).
  intros X1 X2. intro H. elim (rem_471 X1 X2 H).
  intros X1 X2. intro H. elim (rem_472 X1 X2 H).
   intro H. elim (rem_477  H).
  intros X1 X2. intro H. elim (rem_481 X1 X2 H).
   intro H. elim (rem_478  H).
  intros X1 X2. intro H. elim (rem_480 X1 X2 H).
  intros X1 X2. intro H. elim (rem_462 X1 X2 H).
  intros X1 X2. intro H. elim (rem_459 X1 X2 H).
  intros X1 X2. intro H. elim (rem_470 X1 X2 H).
  intros X1. intro H. elim (rem_464 X1 H).
  intros X1 X2. intro H. elim (rem_467 X1 X2 H).
  intros X1 X2. intro H. elim (rem_466 X1 X2 H).
   intro H. elim (rem_469  H).
   intro H. elim (rem_465  H).
  intros X1 X2. intro H. elim (rem_463 X1 X2 H).
  intros X1 X2;  exact (rem_457 epsilon_m__type_8_p__type_31 X1 X2).
  intros X1. intro H. elim (rem_474 X1 H).
   intro H. elim (rem_479  H).
  intros X1 X2. intro H. elim (rem_476 X1 X2 H).
  intros X1 X2. intro H. elim (rem_460 X1 X2 H).
   intro H. elim (rem_475  H).
Qed.

Remark rem_483 : forall X1 X2:term, auto___type_7 X2 -> auto___type_8 X1 -> auto_testable_current X2 -> auto___type_31 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_8 X1 -> auto___type_31 X1). tauto. exact (rem_482 X1).
Qed.

Remark rem_484 : forall X1 X2:term, auto___type_8 X1 -> auto___type_7 X2 -> auto_testable_current X2 -> auto___type_31 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___type_7 X2 -> auto___type_8 X1 -> auto_testable_current X2 -> auto___type_31 X1). tauto. exact (rem_483 X1 X2).
Qed.

Remark rem_485 : (forall X:term, auto___def_102 X -> auto___type_31 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_486 : (forall X:term, auto___def_102 X -> auto___type_31 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_102_p__type_31. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_485 epsilon_m__def_102_p__type_31 X1);  assumption.
  tauto.
Defined.

Remark rem_487 : (forall X:term, auto___def_102 X -> auto___type_31 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto___type_31 (r_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_102_p__type_31. intros X1 X2. intros A1.
  case (rem_486 epsilon_m__def_102_p__type_31 X1 A1). clear  epsilon_m__def_102_p__type_31 A1. intros. apply trans___type_31_r_current_1;  tauto.
 clear  epsilon_m__def_102_p__type_31 A1. tauto.
Defined.

Remark rem_488 : forall X1 X2:term, auto___def_102 (r_current X1 X2) -> or_1
    (auto_knows_current X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_489 : (forall X:term, auto___def_102 X -> auto___type_31 X)
    -> forall X1 X2:term, auto___def_102 (r_current X1 X2) -> auto___type_31 (r_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_102_p__type_31. intros X1 X2. intro H. intros.
  elim (rem_488 X1 X2 H);  intros.
  apply (rem_487 epsilon_m__def_102_p__type_31 X1 X2);  tauto.
Defined.

Remark rem_490 : forall X1 X2:term, auto___def_102 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_491 : forall X1 X2:term, auto___def_102 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_492 : forall X1 X2:term, auto___def_102 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_493 : auto___def_102 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_494 : forall X1 X2:term, auto___def_102 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_495 : forall X1 X2:term, auto___def_102 (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_496 : forall X1:term, auto___def_102 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_497 : auto___def_102 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_498 : forall X1 X2:term, auto___def_102 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_499 : forall X1 X2:term, auto___def_102 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_500 : auto___def_102 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_501 : auto___def_102 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_502 : forall X1 X2:term, auto___def_102 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_503 : forall X1 X2:term, auto___def_102 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_504 : forall X1 X2:term, auto___def_102 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_505 : forall X1 X2:term, auto___def_102 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_506 : forall X1:term, auto___def_102 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_507 : auto___def_102 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_508 : forall X1 X2:term, auto___def_102 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_509 : auto___def_102 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_510 : auto___def_102 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_511 : auto___def_102 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_512 : forall X1 X2:term, auto___def_102 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_513 : forall X1 X2:term, auto___def_102 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_514 : forall X1:term, auto___def_102 X1 -> auto___type_31 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_102_p__type_31 1.
  intro X. case X.
   intro H. elim (rem_500  H).
   intro H. elim (rem_493  H).
  intros X1 X2. intro H. elim (rem_505 X1 X2 H).
  intros X1 X2. intro H. elim (rem_490 X1 X2 H).
  intros X1 X2. intro H. elim (rem_503 X1 X2 H).
  intros X1 X2. intro H. elim (rem_504 X1 X2 H).
   intro H. elim (rem_509  H).
  intros X1 X2. intro H. elim (rem_513 X1 X2 H).
   intro H. elim (rem_510  H).
  intros X1 X2. intro H. elim (rem_512 X1 X2 H).
  intros X1 X2. intro H. elim (rem_494 X1 X2 H).
  intros X1 X2. intro H. elim (rem_491 X1 X2 H).
  intros X1 X2. intro H. elim (rem_502 X1 X2 H).
  intros X1. intro H. elim (rem_496 X1 H).
  intros X1 X2. intro H. elim (rem_499 X1 X2 H).
  intros X1 X2. intro H. elim (rem_498 X1 X2 H).
   intro H. elim (rem_501  H).
   intro H. elim (rem_497  H).
  intros X1 X2;  exact (rem_489 epsilon_m__def_102_p__type_31 X1 X2).
  intros X1 X2. intro H. elim (rem_495 X1 X2 H).
  intros X1. intro H. elim (rem_506 X1 H).
   intro H. elim (rem_511  H).
  intros X1 X2. intro H. elim (rem_508 X1 X2 H).
  intros X1 X2. intro H. elim (rem_492 X1 X2 H).
   intro H. elim (rem_507  H).
Qed.

Remark rem_515 : forall X1 X2:term, auto___def_102 X1 -> auto___def_96 X2 -> auto_testable_current X2 -> auto___type_31 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_102 X1 -> auto___type_31 X1). tauto. exact (rem_514 X1).
Qed.

Remark rem_516 : (forall X:term, auto___type_4 X -> auto___type_31 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_517 : (forall X:term, auto___type_4 X -> auto___type_31 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_p__type_31. intros X1. intros A1.
  cut (auto_knows_old X1). 2:apply (rem_516 epsilon_m__type_4_p__type_31 X1);  assumption.
  tauto.
Defined.

Remark rem_518 : (forall X:term, auto___type_4 X -> auto___type_31 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto___type_31 (r_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_p__type_31. intros X1 X2. intros A1.
  case (rem_517 epsilon_m__type_4_p__type_31 X1 A1). clear  epsilon_m__type_4_p__type_31 A1. intros. apply trans___type_31_r_old_1;  tauto.
 clear  epsilon_m__type_4_p__type_31 A1. tauto.
Defined.

Remark rem_519 : forall X1 X2:term, auto___type_4 (r_old X1 X2) -> or_1
    (auto_knows_old X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_520 : (forall X:term, auto___type_4 X -> auto___type_31 X)
    -> forall X1 X2:term, auto___type_4 (r_old X1 X2) -> auto___type_31 (r_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_p__type_31. intros X1 X2. intro H. intros.
  elim (rem_519 X1 X2 H);  intros.
  apply (rem_518 epsilon_m__type_4_p__type_31 X1 X2);  tauto.
Defined.

Remark rem_521 : forall X1 X2:term, auto___type_4 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_522 : forall X1 X2:term, auto___type_4 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_523 : forall X1 X2:term, auto___type_4 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_524 : auto___type_4 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_525 : forall X1 X2:term, auto___type_4 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_526 : forall X1 X2:term, auto___type_4 (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_527 : forall X1:term, auto___type_4 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_528 : auto___type_4 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_529 : forall X1 X2:term, auto___type_4 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_530 : forall X1 X2:term, auto___type_4 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_531 : auto___type_4 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_532 : auto___type_4 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_533 : forall X1 X2:term, auto___type_4 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_534 : forall X1 X2:term, auto___type_4 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_535 : forall X1 X2:term, auto___type_4 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_536 : forall X1 X2:term, auto___type_4 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_537 : forall X1:term, auto___type_4 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_538 : auto___type_4 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_539 : forall X1 X2:term, auto___type_4 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_540 : auto___type_4 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_541 : auto___type_4 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_542 : auto___type_4 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_543 : forall X1 X2:term, auto___type_4 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_544 : forall X1 X2:term, auto___type_4 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_545 : forall X1:term, auto___type_4 X1 -> auto___type_31 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_4_p__type_31 1.
  intro X. case X.
   intro H. elim (rem_531  H).
   intro H. elim (rem_524  H).
  intros X1 X2. intro H. elim (rem_536 X1 X2 H).
  intros X1 X2. intro H. elim (rem_521 X1 X2 H).
  intros X1 X2. intro H. elim (rem_534 X1 X2 H).
  intros X1 X2. intro H. elim (rem_535 X1 X2 H).
   intro H. elim (rem_540  H).
  intros X1 X2. intro H. elim (rem_544 X1 X2 H).
   intro H. elim (rem_541  H).
  intros X1 X2. intro H. elim (rem_543 X1 X2 H).
  intros X1 X2. intro H. elim (rem_525 X1 X2 H).
  intros X1 X2. intro H. elim (rem_522 X1 X2 H).
  intros X1 X2. intro H. elim (rem_533 X1 X2 H).
  intros X1. intro H. elim (rem_527 X1 H).
  intros X1 X2. intro H. elim (rem_530 X1 X2 H).
  intros X1 X2. intro H. elim (rem_529 X1 X2 H).
   intro H. elim (rem_532  H).
   intro H. elim (rem_528  H).
  intros X1 X2. intro H. elim (rem_526 X1 X2 H).
  intros X1 X2;  exact (rem_520 epsilon_m__type_4_p__type_31 X1 X2).
  intros X1. intro H. elim (rem_537 X1 H).
   intro H. elim (rem_542  H).
  intros X1 X2. intro H. elim (rem_539 X1 X2 H).
  intros X1 X2. intro H. elim (rem_523 X1 X2 H).
   intro H. elim (rem_538  H).
Qed.

Remark rem_546 : forall X1 X2:term, auto___def_24 X2 -> auto___type_4 X1 -> auto_testable_current X2 -> auto___type_31 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_4 X1 -> auto___type_31 X1). tauto. exact (rem_545 X1).
Qed.

Remark rem_547 : forall X1 X2:term, auto___type_4 X1 -> auto___def_24 X2 -> auto_testable_current X2 -> auto___type_31 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_24 X2 -> auto___type_4 X1 -> auto_testable_current X2 -> auto___type_31 X1). tauto. exact (rem_546 X1 X2).
Qed.

Remark rem_548 : forall X1 X2:term, auto___def_67 X1 X2 -> or_6
    (auto___type_19 X1 /\ auto___def_84 X2)
    (auto___def_42 X1 /\ auto___def_36 X2)
    (auto___type_23 X1 /\ auto___type_22 X2)
    (auto___type_8 X1 /\ auto___type_7 X2)
    (auto___def_102 X1 /\ auto___def_96 X2)
    (auto___type_4 X1 /\ auto___def_24 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_6_intro_1; tauto.
  intros. apply or_6_intro_2; tauto.
  intros. apply or_6_intro_3; tauto.
  intros. apply or_6_intro_4; tauto.
  intros. apply or_6_intro_5; tauto.
  intros. apply or_6_intro_6; tauto.
Qed.

Remark rem_549 : forall X1 X2:term, auto___def_67 X1 X2 -> auto_testable_current X2 -> auto___type_31 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_548 X1 X2 H);  intros.
  apply (rem_388 X1 X2);  tauto.
  apply (rem_420 X1 X2);  tauto.
  apply (rem_452 X1 X2);  tauto.
  apply (rem_484 X1 X2);  tauto.
  apply (rem_515 X1 X2);  tauto.
  apply (rem_547 X1 X2);  tauto.
Qed.

Remark rem_550 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1:term, auto___def_17 X1 -> auto___def_17 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_551 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_17 X1 -> auto___type_2 X2 -> auto___def_17 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___def_17 X1 -> auto___def_17 X1). tauto. exact (rem_550 epsilon_mtestable_current_p__type_27 X1).
Defined.

Remark rem_552 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X2:term, auto___type_2 X2 -> auto___type_2 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_553 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_17 X1 -> auto___type_2 X2 -> auto___type_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___type_2 X2 -> auto___type_2 X2). tauto. exact (rem_552 epsilon_mtestable_current_p__type_27 X2).
Defined.

Remark rem_554 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_17 X1 -> auto___type_2 X2 -> (auto___def_17 X1 /\ auto___type_2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  cut (auto___def_17 X1). 2:apply (rem_551 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  cut (auto___type_2 X2). 2:apply (rem_553 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_555 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_17 X1 -> auto___type_2 X2 -> auto___type_27 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  case (rem_554 epsilon_mtestable_current_p__type_27 X1 X2 A1 A2). clear  epsilon_mtestable_current_p__type_27 A1 A2. intros. apply trans___type_27_crypt_1;  tauto.
 clear  epsilon_mtestable_current_p__type_27 A1 A2. tauto.
Defined.

Remark rem_556 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1:term, auto___def_36 X1 -> auto___def_36 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_557 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_36 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___def_36 X1 -> auto___def_36 X1). tauto. exact (rem_556 epsilon_mtestable_current_p__type_27 X1).
Defined.

Remark rem_558 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X2:term, auto___def_37 X2 -> auto___def_37 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_559 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_37 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___def_37 X2 -> auto___def_37 X2). tauto. exact (rem_558 epsilon_mtestable_current_p__type_27 X2).
Defined.

Remark rem_560 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> (auto___def_36 X1 /\ auto___def_37 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  cut (auto___def_36 X1). 2:apply (rem_557 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  cut (auto___def_37 X2). 2:apply (rem_559 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_561 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_27 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  case (rem_560 epsilon_mtestable_current_p__type_27 X1 X2 A1 A2). clear  epsilon_mtestable_current_p__type_27 A1 A2. intros. apply trans___type_27_crypt_2;  tauto.
 clear  epsilon_mtestable_current_p__type_27 A1 A2. tauto.
Defined.

Remark rem_562 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1:term, auto___def_21 X1 -> auto___def_21 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_563 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_21 X1 -> auto___def_22 X2 -> auto___def_21 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___def_21 X1 -> auto___def_21 X1). tauto. exact (rem_562 epsilon_mtestable_current_p__type_27 X1).
Defined.

Remark rem_564 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X2:term, auto___def_22 X2 -> auto___def_22 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_565 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_21 X1 -> auto___def_22 X2 -> auto___def_22 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___def_22 X2 -> auto___def_22 X2). tauto. exact (rem_564 epsilon_mtestable_current_p__type_27 X2).
Defined.

Remark rem_566 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_21 X1 -> auto___def_22 X2 -> (auto___def_21 X1 /\ auto___def_22 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  cut (auto___def_21 X1). 2:apply (rem_563 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  cut (auto___def_22 X2). 2:apply (rem_565 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_567 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_21 X1 -> auto___def_22 X2 -> auto___type_27 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  case (rem_566 epsilon_mtestable_current_p__type_27 X1 X2 A1 A2). clear  epsilon_mtestable_current_p__type_27 A1 A2. intros. apply trans___type_27_crypt_3;  tauto.
 clear  epsilon_mtestable_current_p__type_27 A1 A2. tauto.
Defined.

Remark rem_568 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1:term, auto___type_26 X1 -> auto___type_26 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_569 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___type_26 X1 -> auto___def_111 X2 -> auto___type_26 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___type_26 X1 -> auto___type_26 X1). tauto. exact (rem_568 epsilon_mtestable_current_p__type_27 X1).
Defined.

Remark rem_570 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X2:term, auto___def_111 X2 -> auto___def_111 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_571 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___type_26 X1 -> auto___def_111 X2 -> auto___def_111 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___def_111 X2 -> auto___def_111 X2). tauto. exact (rem_570 epsilon_mtestable_current_p__type_27 X2).
Defined.

Remark rem_572 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___type_26 X1 -> auto___def_111 X2 -> (auto___type_26 X1 /\ auto___def_111 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  cut (auto___type_26 X1). 2:apply (rem_569 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  cut (auto___def_111 X2). 2:apply (rem_571 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_573 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___type_26 X1 -> auto___def_111 X2 -> auto___type_27 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  case (rem_572 epsilon_mtestable_current_p__type_27 X1 X2 A1 A2). clear  epsilon_mtestable_current_p__type_27 A1 A2. intros. apply trans___type_27_crypt_4;  tauto.
 clear  epsilon_mtestable_current_p__type_27 A1 A2. tauto.
Defined.

Remark rem_574 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_575 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_574 epsilon_mtestable_current_p__type_27 X1).
Defined.

Remark rem_576 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X2:term, auto_knows_current X2 -> auto_knows_current X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_577 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_576 epsilon_mtestable_current_p__type_27 X2).
Defined.

Remark rem_578 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_575 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_577 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_579 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_27 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  case (rem_578 epsilon_mtestable_current_p__type_27 X1 X2 A1 A2). clear  epsilon_mtestable_current_p__type_27 A1 A2. intros. apply trans___type_27_crypt_5;  tauto.
 clear  epsilon_mtestable_current_p__type_27 A1 A2. tauto.
Defined.

Remark rem_580 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1:term, auto___type_22 X1 -> auto___type_22 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_581 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___type_22 X1 -> auto___def_104 X2 -> auto___type_22 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___type_22 X1 -> auto___type_22 X1). tauto. exact (rem_580 epsilon_mtestable_current_p__type_27 X1).
Defined.

Remark rem_582 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X2:term, auto___def_104 X2 -> auto___def_104 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_583 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___type_22 X1 -> auto___def_104 X2 -> auto___def_104 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___def_104 X2 -> auto___def_104 X2). tauto. exact (rem_582 epsilon_mtestable_current_p__type_27 X2).
Defined.

Remark rem_584 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___type_22 X1 -> auto___def_104 X2 -> (auto___type_22 X1 /\ auto___def_104 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  cut (auto___type_22 X1). 2:apply (rem_581 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  cut (auto___def_104 X2). 2:apply (rem_583 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_585 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___type_22 X1 -> auto___def_104 X2 -> auto___type_27 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  case (rem_584 epsilon_mtestable_current_p__type_27 X1 X2 A1 A2). clear  epsilon_mtestable_current_p__type_27 A1 A2. intros. apply trans___type_27_crypt_6;  tauto.
 clear  epsilon_mtestable_current_p__type_27 A1 A2. tauto.
Defined.

Remark rem_586 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1:term, auto___def_88 X1 -> auto___def_88 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_587 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> auto___def_88 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___def_88 X1 -> auto___def_88 X1). tauto. exact (rem_586 epsilon_mtestable_current_p__type_27 X1).
Defined.

Remark rem_588 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X2:term, auto___def_89 X2 -> auto___def_89 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_589 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> auto___def_89 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___def_89 X2 -> auto___def_89 X2). tauto. exact (rem_588 epsilon_mtestable_current_p__type_27 X2).
Defined.

Remark rem_590 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> (auto___def_88 X1 /\ auto___def_89 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  cut (auto___def_88 X1). 2:apply (rem_587 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  cut (auto___def_89 X2). 2:apply (rem_589 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_591 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> auto___type_27 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  case (rem_590 epsilon_mtestable_current_p__type_27 X1 X2 A1 A2). clear  epsilon_mtestable_current_p__type_27 A1 A2. intros. apply trans___type_27_crypt_7;  tauto.
 clear  epsilon_mtestable_current_p__type_27 A1 A2. tauto.
Defined.

Remark rem_592 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1:term, auto___type_27 X1 -> auto___type_27 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_593 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___type_27 X1 -> auto___def_113 X2 -> auto___type_27 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___type_27 X1 -> auto___type_27 X1). tauto. exact (rem_592 epsilon_mtestable_current_p__type_27 X1).
Defined.

Remark rem_594 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X2:term, auto___def_113 X2 -> auto___def_113 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_595 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___type_27 X1 -> auto___def_113 X2 -> auto___def_113 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___def_113 X2 -> auto___def_113 X2). tauto. exact (rem_594 epsilon_mtestable_current_p__type_27 X2).
Defined.

Remark rem_596 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___type_27 X1 -> auto___def_113 X2 -> (auto___type_27 X1 /\ auto___def_113 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  cut (auto___type_27 X1). 2:apply (rem_593 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  cut (auto___def_113 X2). 2:apply (rem_595 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_597 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___type_27 X1 -> auto___def_113 X2 -> auto___type_27 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  case (rem_596 epsilon_mtestable_current_p__type_27 X1 X2 A1 A2). clear  epsilon_mtestable_current_p__type_27 A1 A2. intros. apply trans___type_27_crypt_8;  tauto.
 clear  epsilon_mtestable_current_p__type_27 A1 A2. tauto.
Defined.

Remark rem_598 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1:term, auto___def_24 X1 -> auto___def_24 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_599 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___def_24 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___def_24 X1 -> auto___def_24 X1). tauto. exact (rem_598 epsilon_mtestable_current_p__type_27 X1).
Defined.

Remark rem_600 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X2:term, auto___def_25 X2 -> auto___def_25 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_601 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___def_25 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___def_25 X2 -> auto___def_25 X2). tauto. exact (rem_600 epsilon_mtestable_current_p__type_27 X2).
Defined.

Remark rem_602 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> (auto___def_24 X1 /\ auto___def_25 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  cut (auto___def_24 X1). 2:apply (rem_599 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  cut (auto___def_25 X2). 2:apply (rem_601 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_603 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___type_27 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  case (rem_602 epsilon_mtestable_current_p__type_27 X1 X2 A1 A2). clear  epsilon_mtestable_current_p__type_27 A1 A2. intros. apply trans___type_27_crypt_9;  tauto.
 clear  epsilon_mtestable_current_p__type_27 A1 A2. tauto.
Defined.

Remark rem_604 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1:term, auto___type_7 X1 -> auto___type_7 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_605 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___type_7 X1 -> auto___type_7 X1). tauto. exact (rem_604 epsilon_mtestable_current_p__type_27 X1).
Defined.

Remark rem_606 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X2:term, auto___def_44 X2 -> auto___def_44 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_607 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___def_44 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___def_44 X2 -> auto___def_44 X2). tauto. exact (rem_606 epsilon_mtestable_current_p__type_27 X2).
Defined.

Remark rem_608 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> (auto___type_7 X1 /\ auto___def_44 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  cut (auto___type_7 X1). 2:apply (rem_605 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  cut (auto___def_44 X2). 2:apply (rem_607 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_609 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___type_27 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  case (rem_608 epsilon_mtestable_current_p__type_27 X1 X2 A1 A2). clear  epsilon_mtestable_current_p__type_27 A1 A2. intros. apply trans___type_27_crypt_10;  tauto.
 clear  epsilon_mtestable_current_p__type_27 A1 A2. tauto.
Defined.

Remark rem_610 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1:term, auto___def_84 X1 -> auto___def_84 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_611 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___def_85 X2 -> auto___def_84 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___def_84 X1 -> auto___def_84 X1). tauto. exact (rem_610 epsilon_mtestable_current_p__type_27 X1).
Defined.

Remark rem_612 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X2:term, auto___def_85 X2 -> auto___def_85 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_613 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___def_85 X2 -> auto___def_85 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___def_85 X2 -> auto___def_85 X2). tauto. exact (rem_612 epsilon_mtestable_current_p__type_27 X2).
Defined.

Remark rem_614 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___def_85 X2 -> (auto___def_84 X1 /\ auto___def_85 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  cut (auto___def_84 X1). 2:apply (rem_611 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  cut (auto___def_85 X2). 2:apply (rem_613 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_615 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___def_85 X2 -> auto___type_27 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  case (rem_614 epsilon_mtestable_current_p__type_27 X1 X2 A1 A2). clear  epsilon_mtestable_current_p__type_27 A1 A2. intros. apply trans___type_27_crypt_11;  tauto.
 clear  epsilon_mtestable_current_p__type_27 A1 A2. tauto.
Defined.

Inductive or_11(H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11:Prop) : Prop :=
    or_11_intro_1 : H1 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_2 : H2 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_3 : H3 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_4 : H4 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_5 : H5 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_6 : H6 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_7 : H7 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_8 : H8 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_9 : H9 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_10 : H10 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_11 : H11 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
.

Remark rem_616 : forall X1 X2:term, auto_testable_current (crypt X1 X2) -> or_11
    (auto___def_17 X1 /\ auto___type_2 X2)
    (auto___def_36 X1 /\ auto___def_37 X2)
    (auto___def_21 X1 /\ auto___def_22 X2)
    (auto___type_26 X1 /\ auto___def_111 X2)
    (auto_knows_current X1 /\ auto_knows_current X2)
    (auto___type_22 X1 /\ auto___def_104 X2)
    (auto___def_88 X1 /\ auto___def_89 X2)
    (auto___type_27 X1 /\ auto___def_113 X2)
    (auto___def_24 X1 /\ auto___def_25 X2)
    (auto___type_7 X1 /\ auto___def_44 X2)
    (auto___def_84 X1 /\ auto___def_85 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_11_intro_1; tauto.
  intros. apply or_11_intro_2; tauto.
  intros. apply or_11_intro_3; tauto.
  intros. apply or_11_intro_4; tauto.
  intros. apply or_11_intro_5; tauto.
  intros. apply or_11_intro_6; tauto.
  intros. apply or_11_intro_7; tauto.
  intros. apply or_11_intro_8; tauto.
  intros. apply or_11_intro_9; tauto.
  intros. apply or_11_intro_10; tauto.
  intros. apply or_11_intro_11; tauto.
Qed.

Remark rem_617 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto_testable_current (crypt X1 X2) -> auto___type_27 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intro H. intros.
  elim (rem_616 X1 X2 H);  intros.
  apply (rem_555 epsilon_mtestable_current_p__type_27 X1 X2);  tauto.
  apply (rem_561 epsilon_mtestable_current_p__type_27 X1 X2);  tauto.
  apply (rem_567 epsilon_mtestable_current_p__type_27 X1 X2);  tauto.
  apply (rem_573 epsilon_mtestable_current_p__type_27 X1 X2);  tauto.
  apply (rem_579 epsilon_mtestable_current_p__type_27 X1 X2);  tauto.
  apply (rem_585 epsilon_mtestable_current_p__type_27 X1 X2);  tauto.
  apply (rem_591 epsilon_mtestable_current_p__type_27 X1 X2);  tauto.
  apply (rem_597 epsilon_mtestable_current_p__type_27 X1 X2);  tauto.
  apply (rem_603 epsilon_mtestable_current_p__type_27 X1 X2);  tauto.
  apply (rem_609 epsilon_mtestable_current_p__type_27 X1 X2);  tauto.
  apply (rem_615 epsilon_mtestable_current_p__type_27 X1 X2);  tauto.
Defined.

Remark rem_618 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_current_p__type_27.  tauto.
Defined.

Remark rem_619 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> auto___type_27 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27.  case (rem_618 epsilon_mtestable_current_p__type_27). clear  epsilon_mtestable_current_p__type_27. intros. apply trans___type_27_bob_1;  tauto.
 clear  epsilon_mtestable_current_p__type_27. tauto.
Defined.

Remark rem_620 : auto_testable_current bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_621 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> auto_testable_current bob -> auto___type_27 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intro H. intros.
  elim (rem_620 H);  intros.
  apply (rem_619 epsilon_mtestable_current_p__type_27);  tauto.
Defined.

Remark rem_622 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___type_27 (noncea_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.  case (rem_618 epsilon_mtestable_current_p__type_27). clear  epsilon_mtestable_current_p__type_27. intros. apply trans___type_27_noncea_old_1;  tauto.
 clear  epsilon_mtestable_current_p__type_27. tauto.
Defined.

Remark rem_623 : forall X1 X2:term, auto_testable_current (noncea_old X1 X2) -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_624 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto_testable_current (noncea_old X1 X2) -> auto___type_27 (noncea_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intro H. intros.
  elim (rem_623 X1 X2 H);  intros.
  apply (rem_622 epsilon_mtestable_current_p__type_27 X1 X2);  tauto.
Defined.

Remark rem_625 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_626 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1. intros A1.
  cut (auto_knows_old X1). 2:apply (rem_625 epsilon_mtestable_current_p__type_27 X1);  assumption.
  tauto.
Defined.

Remark rem_627 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto___type_27 (r_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1.
  case (rem_626 epsilon_mtestable_current_p__type_27 X1 A1). clear  epsilon_mtestable_current_p__type_27 A1. intros. apply trans___type_27_r_old_1;  tauto.
 clear  epsilon_mtestable_current_p__type_27 A1. tauto.
Defined.

Remark rem_628 : forall X1 X2:term, auto_testable_current (r_old X1 X2) -> or_1
    (auto_knows_old X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_629 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto_testable_current (r_old X1 X2) -> auto___type_27 (r_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intro H. intros.
  elim (rem_628 X1 X2 H);  intros.
  apply (rem_627 epsilon_mtestable_current_p__type_27 X1 X2);  tauto.
Defined.

Remark rem_630 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1:term, auto_testable_current X1 -> auto_testable_current X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_631 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1:term, auto_testable_current X1 -> auto_testable_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1. intros A1.
  cut (auto_testable_current X1). 2:apply (rem_630 epsilon_mtestable_current_p__type_27 X1);  assumption.
  tauto.
Defined.

Remark rem_632 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1:term, auto_testable_current X1 -> auto___type_27 (p X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1. intros A1.
  case (rem_631 epsilon_mtestable_current_p__type_27 X1 A1). clear  epsilon_mtestable_current_p__type_27 A1. intros. apply trans___type_27_p_1;  tauto.
 clear  epsilon_mtestable_current_p__type_27 A1. tauto.
Defined.

Remark rem_633 : forall X1:term, auto_testable_current (p X1) -> or_1
    (auto_testable_current X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_634 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1:term, auto_testable_current (p X1) -> auto___type_27 (p X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1. intro H. intros.
  elim (rem_633 X1 H);  intros.
  apply (rem_632 epsilon_mtestable_current_p__type_27 X1);  tauto.
Defined.

Remark rem_635 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___type_27 (passwd_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.  case (rem_618 epsilon_mtestable_current_p__type_27). clear  epsilon_mtestable_current_p__type_27. intros. apply trans___type_27_passwd_old_1;  tauto.
 clear  epsilon_mtestable_current_p__type_27. tauto.
Defined.

Remark rem_636 : forall X1 X2:term, auto_testable_current (passwd_old X1 X2) -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_637 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto_testable_current (passwd_old X1 X2) -> auto___type_27 (passwd_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intro H. intros.
  elim (rem_636 X1 X2 H);  intros.
  apply (rem_635 epsilon_mtestable_current_p__type_27 X1 X2);  tauto.
Defined.

Remark rem_638 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> auto___type_27 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27.  case (rem_618 epsilon_mtestable_current_p__type_27). clear  epsilon_mtestable_current_p__type_27. intros. apply trans___type_27_alice_1;  tauto.
 clear  epsilon_mtestable_current_p__type_27. tauto.
Defined.

Remark rem_639 : auto_testable_current alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_640 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> auto_testable_current alice -> auto___type_27 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intro H. intros.
  elim (rem_639 H);  intros.
  apply (rem_638 epsilon_mtestable_current_p__type_27);  tauto.
Defined.

Remark rem_641 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___type_27 (nonceb_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.  case (rem_618 epsilon_mtestable_current_p__type_27). clear  epsilon_mtestable_current_p__type_27. intros. apply trans___type_27_nonceb_old_1;  tauto.
 clear  epsilon_mtestable_current_p__type_27. tauto.
Defined.

Remark rem_642 : forall X1 X2:term, auto_testable_current (nonceb_old X1 X2) -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_643 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto_testable_current (nonceb_old X1 X2) -> auto___type_27 (nonceb_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intro H. intros.
  elim (rem_642 X1 X2 H);  intros.
  apply (rem_641 epsilon_mtestable_current_p__type_27 X1 X2);  tauto.
Defined.

Remark rem_644 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto_testable_current X1 -> auto_knows_current X2 -> auto_testable_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto_testable_current X1 -> auto_testable_current X1). tauto. exact (rem_630 epsilon_mtestable_current_p__type_27 X1).
Defined.

Remark rem_645 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto_testable_current X1 -> auto_knows_current X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_576 epsilon_mtestable_current_p__type_27 X2).
Defined.

Remark rem_646 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto_testable_current X1 -> auto_knows_current X2 -> (auto_testable_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  cut (auto_testable_current X1). 2:apply (rem_644 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_645 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_647 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto_testable_current X1 -> auto_knows_current X2 -> auto___type_27 (dec X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  case (rem_646 epsilon_mtestable_current_p__type_27 X1 X2 A1 A2). clear  epsilon_mtestable_current_p__type_27 A1 A2. intros. apply trans___type_27_dec_1;  tauto.
 clear  epsilon_mtestable_current_p__type_27 A1 A2. tauto.
Defined.

Remark rem_648 : forall X1 X2:term, auto_testable_current (dec X1 X2) -> or_1
    (auto_testable_current X1 /\ auto_knows_current X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_649 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto_testable_current (dec X1 X2) -> auto___type_27 (dec X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intro H. intros.
  elim (rem_648 X1 X2 H);  intros.
  apply (rem_647 epsilon_mtestable_current_p__type_27 X1 X2);  tauto.
Defined.

Remark rem_650 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1:term, auto___def_71 X1 -> auto___def_71 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_651 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto___def_71 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___def_71 X1 -> auto___def_71 X1). tauto. exact (rem_650 epsilon_mtestable_current_p__type_27 X1).
Defined.

Remark rem_652 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X2:term, auto___def_72 X2 -> auto___def_72 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_653 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto___def_72 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___def_72 X2 -> auto___def_72 X2). tauto. exact (rem_652 epsilon_mtestable_current_p__type_27 X2).
Defined.

Remark rem_654 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> (auto___def_71 X1 /\ auto___def_72 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  cut (auto___def_71 X1). 2:apply (rem_651 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  cut (auto___def_72 X2). 2:apply (rem_653 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_655 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto___type_27 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  case (rem_654 epsilon_mtestable_current_p__type_27 X1 X2 A1 A2). clear  epsilon_mtestable_current_p__type_27 A1 A2. intros. apply trans___type_27_enc_1;  tauto.
 clear  epsilon_mtestable_current_p__type_27 A1 A2. tauto.
Defined.

Remark rem_656 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto_testable_current X1 -> auto_knows_current X2 -> auto___type_27 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  case (rem_646 epsilon_mtestable_current_p__type_27 X1 X2 A1 A2). clear  epsilon_mtestable_current_p__type_27 A1 A2. intros. apply trans___type_27_enc_2;  tauto.
 clear  epsilon_mtestable_current_p__type_27 A1 A2. tauto.
Defined.

Remark rem_657 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1:term, auto___def_79 X1 -> auto___def_79 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_658 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_79 X1 -> auto___def_80 X2 -> auto___def_79 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___def_79 X1 -> auto___def_79 X1). tauto. exact (rem_657 epsilon_mtestable_current_p__type_27 X1).
Defined.

Remark rem_659 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X2:term, auto___def_80 X2 -> auto___def_80 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_660 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_79 X1 -> auto___def_80 X2 -> auto___def_80 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___def_80 X2 -> auto___def_80 X2). tauto. exact (rem_659 epsilon_mtestable_current_p__type_27 X2).
Defined.

Remark rem_661 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_79 X1 -> auto___def_80 X2 -> (auto___def_79 X1 /\ auto___def_80 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  cut (auto___def_79 X1). 2:apply (rem_658 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  cut (auto___def_80 X2). 2:apply (rem_660 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_662 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_79 X1 -> auto___def_80 X2 -> auto___type_27 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  case (rem_661 epsilon_mtestable_current_p__type_27 X1 X2 A1 A2). clear  epsilon_mtestable_current_p__type_27 A1 A2. intros. apply trans___type_27_enc_3;  tauto.
 clear  epsilon_mtestable_current_p__type_27 A1 A2. tauto.
Defined.

Remark rem_663 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1:term, auto___def_75 X1 -> auto___def_75 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_664 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_75 X1 -> auto___def_76 X2 -> auto___def_75 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___def_75 X1 -> auto___def_75 X1). tauto. exact (rem_663 epsilon_mtestable_current_p__type_27 X1).
Defined.

Remark rem_665 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X2:term, auto___def_76 X2 -> auto___def_76 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_666 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_75 X1 -> auto___def_76 X2 -> auto___def_76 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___def_76 X2 -> auto___def_76 X2). tauto. exact (rem_665 epsilon_mtestable_current_p__type_27 X2).
Defined.

Remark rem_667 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_75 X1 -> auto___def_76 X2 -> (auto___def_75 X1 /\ auto___def_76 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  cut (auto___def_75 X1). 2:apply (rem_664 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  cut (auto___def_76 X2). 2:apply (rem_666 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_668 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_75 X1 -> auto___def_76 X2 -> auto___type_27 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  case (rem_667 epsilon_mtestable_current_p__type_27 X1 X2 A1 A2). clear  epsilon_mtestable_current_p__type_27 A1 A2. intros. apply trans___type_27_enc_4;  tauto.
 clear  epsilon_mtestable_current_p__type_27 A1 A2. tauto.
Defined.

Remark rem_669 : forall X1 X2:term, auto_testable_current (enc X1 X2) -> or_4
    (auto___def_71 X1 /\ auto___def_72 X2)
    (auto_testable_current X1 /\ auto_knows_current X2)
    (auto___def_79 X1 /\ auto___def_80 X2)
    (auto___def_75 X1 /\ auto___def_76 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_4_intro_1; tauto.
  intros. apply or_4_intro_2; tauto.
  intros. apply or_4_intro_3; tauto.
  intros. apply or_4_intro_4; tauto.
Qed.

Remark rem_670 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto_testable_current (enc X1 X2) -> auto___type_27 (enc X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intro H. intros.
  elim (rem_669 X1 X2 H);  intros.
  apply (rem_655 epsilon_mtestable_current_p__type_27 X1 X2);  tauto.
  apply (rem_656 epsilon_mtestable_current_p__type_27 X1 X2);  tauto.
  apply (rem_662 epsilon_mtestable_current_p__type_27 X1 X2);  tauto.
  apply (rem_668 epsilon_mtestable_current_p__type_27 X1 X2);  tauto.
Defined.

Remark rem_671 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X2:term, auto_testable_current X2 -> auto_testable_current X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_672 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X2:term, auto_testable_current X2 -> auto_testable_current X2 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X2. intros A1.
  cut (auto_testable_current X2). 2:apply (rem_671 epsilon_mtestable_current_p__type_27 X2);  assumption.
  tauto.
Defined.

Remark rem_673 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto_testable_current X2 -> auto___type_27 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1.
  case (rem_672 epsilon_mtestable_current_p__type_27 X2 A1). clear  epsilon_mtestable_current_p__type_27 A1. intros. apply trans___type_27_cons_1;  tauto.
 clear  epsilon_mtestable_current_p__type_27 A1. tauto.
Defined.

Remark rem_674 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto_testable_current X1 -> auto___type_27 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1.
  case (rem_631 epsilon_mtestable_current_p__type_27 X1 A1). clear  epsilon_mtestable_current_p__type_27 A1. intros. apply trans___type_27_cons_2;  tauto.
 clear  epsilon_mtestable_current_p__type_27 A1. tauto.
Defined.

Remark rem_675 : forall X1 X2:term, auto_testable_current (cons X1 X2) -> or_2
    (auto_testable_current X2)    (auto_testable_current X1).
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_676 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto_testable_current (cons X1 X2) -> auto___type_27 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intro H. intros.
  elim (rem_675 X1 X2 H);  intros.
  apply (rem_673 epsilon_mtestable_current_p__type_27 X1 X2);  tauto.
  apply (rem_674 epsilon_mtestable_current_p__type_27 X1 X2);  tauto.
Defined.

Remark rem_677 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1:term, auto_testable_current X1 -> auto___type_27 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1. intros A1.
  case (rem_631 epsilon_mtestable_current_p__type_27 X1 A1). clear  epsilon_mtestable_current_p__type_27 A1. intros. apply trans___type_27_s_1;  tauto.
 clear  epsilon_mtestable_current_p__type_27 A1. tauto.
Defined.

Remark rem_678 : forall X1:term, auto_testable_current (s X1) -> or_1
    (auto_testable_current X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_679 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1:term, auto_testable_current (s X1) -> auto___type_27 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1. intro H. intros.
  elim (rem_678 X1 H);  intros.
  apply (rem_677 epsilon_mtestable_current_p__type_27 X1);  tauto.
Defined.

Remark rem_680 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> auto___type_27 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27.  case (rem_618 epsilon_mtestable_current_p__type_27). clear  epsilon_mtestable_current_p__type_27. intros. apply trans___type_27_i_1;  tauto.
 clear  epsilon_mtestable_current_p__type_27. tauto.
Defined.

Remark rem_681 : auto_testable_current i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_682 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> auto_testable_current i -> auto___type_27 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intro H. intros.
  elim (rem_681 H);  intros.
  apply (rem_680 epsilon_mtestable_current_p__type_27);  tauto.
Defined.

Remark rem_683 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> auto___type_27 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27.  case (rem_618 epsilon_mtestable_current_p__type_27). clear  epsilon_mtestable_current_p__type_27. intros. apply trans___type_27_nil_1;  tauto.
 clear  epsilon_mtestable_current_p__type_27. tauto.
Defined.

Remark rem_684 : auto_testable_current nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_685 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> auto_testable_current nil -> auto___type_27 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intro H. intros.
  elim (rem_684 H);  intros.
  apply (rem_683 epsilon_mtestable_current_p__type_27);  tauto.
Defined.

Remark rem_686 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> auto___type_27 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27.  case (rem_618 epsilon_mtestable_current_p__type_27). clear  epsilon_mtestable_current_p__type_27. intros. apply trans___type_27_server_1;  tauto.
 clear  epsilon_mtestable_current_p__type_27. tauto.
Defined.

Remark rem_687 : auto_testable_current server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_688 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> auto_testable_current server -> auto___type_27 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intro H. intros.
  elim (rem_687 H);  intros.
  apply (rem_686 epsilon_mtestable_current_p__type_27);  tauto.
Defined.

Remark rem_689 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1:term, auto___def_119 X1 -> auto___def_119 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_690 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_119 X1 -> auto___type_31 X2 -> auto___def_119 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___def_119 X1 -> auto___def_119 X1). tauto. exact (rem_689 epsilon_mtestable_current_p__type_27 X1).
Defined.

Remark rem_691 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X2:term, auto___type_31 X2 -> auto___type_31 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_692 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_119 X1 -> auto___type_31 X2 -> auto___type_31 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___type_31 X2 -> auto___type_31 X2). tauto. exact (rem_691 epsilon_mtestable_current_p__type_27 X2).
Defined.

Remark rem_693 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_119 X1 -> auto___type_31 X2 -> (auto___def_119 X1 /\ auto___type_31 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  cut (auto___def_119 X1). 2:apply (rem_690 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  cut (auto___type_31 X2). 2:apply (rem_692 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_694 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_119 X1 -> auto___type_31 X2 -> auto___type_27 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  case (rem_693 epsilon_mtestable_current_p__type_27 X1 X2 A1 A2). clear  epsilon_mtestable_current_p__type_27 A1 A2. intros. apply trans___type_27_key_1;  tauto.
 clear  epsilon_mtestable_current_p__type_27 A1 A2. tauto.
Defined.

Remark rem_695 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1:term, auto___def_114 X1 -> auto___def_114 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_696 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_114 X1 -> auto___def_66 X2 -> auto___def_114 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___def_114 X1 -> auto___def_114 X1). tauto. exact (rem_695 epsilon_mtestable_current_p__type_27 X1).
Defined.

Remark rem_697 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X2:term, auto___def_66 X2 -> auto___def_66 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_698 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_114 X1 -> auto___def_66 X2 -> auto___def_66 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___def_66 X2 -> auto___def_66 X2). tauto. exact (rem_697 epsilon_mtestable_current_p__type_27 X2).
Defined.

Remark rem_699 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_114 X1 -> auto___def_66 X2 -> (auto___def_114 X1 /\ auto___def_66 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  cut (auto___def_114 X1). 2:apply (rem_696 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  cut (auto___def_66 X2). 2:apply (rem_698 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_700 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_114 X1 -> auto___def_66 X2 -> auto___type_27 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  case (rem_699 epsilon_mtestable_current_p__type_27 X1 X2 A1 A2). clear  epsilon_mtestable_current_p__type_27 A1 A2. intros. apply trans___type_27_key_2;  tauto.
 clear  epsilon_mtestable_current_p__type_27 A1 A2. tauto.
Defined.

Remark rem_701 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1:term, auto___def_51 X1 -> auto___def_51 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_702 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto___def_51 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___def_51 X1 -> auto___def_51 X1). tauto. exact (rem_701 epsilon_mtestable_current_p__type_27 X1).
Defined.

Remark rem_703 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_704 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_703 epsilon_mtestable_current_p__type_27 X2).
Defined.

Remark rem_705 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> (auto___def_51 X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  cut (auto___def_51 X1). 2:apply (rem_702 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_704 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_706 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto___type_27 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  case (rem_705 epsilon_mtestable_current_p__type_27 X1 X2 A1 A2). clear  epsilon_mtestable_current_p__type_27 A1 A2. intros. apply trans___type_27_key_3;  tauto.
 clear  epsilon_mtestable_current_p__type_27 A1 A2. tauto.
Defined.

Remark rem_707 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1:term, auto___def_12 X1 -> auto___def_12 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_708 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_12 X1). tauto. exact (rem_707 epsilon_mtestable_current_p__type_27 X1).
Defined.

Remark rem_709 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X2:term, auto___def_13 X2 -> auto___def_13 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_710 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_709 epsilon_mtestable_current_p__type_27 X2).
Defined.

Remark rem_711 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> (auto___def_12 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  cut (auto___def_12 X1). 2:apply (rem_708 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_710 epsilon_mtestable_current_p__type_27 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_712 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___type_27 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intros A1 A2.
  case (rem_711 epsilon_mtestable_current_p__type_27 X1 X2 A1 A2). clear  epsilon_mtestable_current_p__type_27 A1 A2. intros. apply trans___type_27_key_4;  tauto.
 clear  epsilon_mtestable_current_p__type_27 A1 A2. tauto.
Defined.

Remark rem_713 : forall X1 X2:term, auto_testable_current (key X1 X2) -> or_4
    (auto___def_119 X1 /\ auto___type_31 X2)
    (auto___def_114 X1 /\ auto___def_66 X2)
    (auto___def_51 X1 /\ auto_agent X2)
    (auto___def_12 X1 /\ auto___def_13 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_4_intro_1; tauto.
  intros. apply or_4_intro_2; tauto.
  intros. apply or_4_intro_3; tauto.
  intros. apply or_4_intro_4; tauto.
Qed.

Remark rem_714 : (forall X:term, auto_testable_current X -> auto___type_27 X)
    -> forall X1 X2:term, auto_testable_current (key X1 X2) -> auto___type_27 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_current_p__type_27. intros X1 X2. intro H. intros.
  elim (rem_713 X1 X2 H);  intros.
  apply (rem_694 epsilon_mtestable_current_p__type_27 X1 X2);  tauto.
  apply (rem_700 epsilon_mtestable_current_p__type_27 X1 X2);  tauto.
  apply (rem_706 epsilon_mtestable_current_p__type_27 X1 X2);  tauto.
  apply (rem_712 epsilon_mtestable_current_p__type_27 X1 X2);  tauto.
Defined.

Remark rem_715 : forall X1 X2:term, auto_testable_current (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_716 : forall X1 X2:term, auto_testable_current (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_717 : forall X1 X2:term, auto_testable_current (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_718 : auto_testable_current pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_719 : forall X1 X2:term, auto_testable_current (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_720 : auto_testable_current prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_721 : auto_testable_current sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_722 : forall X1 X2:term, auto_testable_current (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_723 : forall X1 X2:term, auto_testable_current (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_724 : forall X1:term, auto_testable_current X1 -> auto___type_27 X1. (* Induct. *)
Proof.
  fix epsilon_mtestable_current_p__type_27 1.
  intro X. case X.
  exact (rem_640 epsilon_mtestable_current_p__type_27 ).
  exact (rem_621 epsilon_mtestable_current_p__type_27 ).
  intros X1 X2;  exact (rem_676 epsilon_mtestable_current_p__type_27 X1 X2).
  intros X1 X2;  exact (rem_617 epsilon_mtestable_current_p__type_27 X1 X2).
  intros X1 X2;  exact (rem_649 epsilon_mtestable_current_p__type_27 X1 X2).
  intros X1 X2;  exact (rem_670 epsilon_mtestable_current_p__type_27 X1 X2).
  exact (rem_682 epsilon_mtestable_current_p__type_27 ).
  intros X1 X2;  exact (rem_714 epsilon_mtestable_current_p__type_27 X1 X2).
  exact (rem_685 epsilon_mtestable_current_p__type_27 ).
  intros X1 X2. intro H. elim (rem_723 X1 X2 H).
  intros X1 X2;  exact (rem_624 epsilon_mtestable_current_p__type_27 X1 X2).
  intros X1 X2. intro H. elim (rem_715 X1 X2 H).
  intros X1 X2;  exact (rem_643 epsilon_mtestable_current_p__type_27 X1 X2).
  intros X1;  exact (rem_634 epsilon_mtestable_current_p__type_27 X1).
  intros X1 X2. intro H. elim (rem_719 X1 X2 H).
  intros X1 X2;  exact (rem_637 epsilon_mtestable_current_p__type_27 X1 X2).
   intro H. elim (rem_720  H).
   intro H. elim (rem_718  H).
  intros X1 X2. intro H. elim (rem_717 X1 X2 H).
  intros X1 X2;  exact (rem_629 epsilon_mtestable_current_p__type_27 X1 X2).
  intros X1;  exact (rem_679 epsilon_mtestable_current_p__type_27 X1).
  exact (rem_688 epsilon_mtestable_current_p__type_27 ).
  intros X1 X2. intro H. elim (rem_722 X1 X2 H).
  intros X1 X2. intro H. elim (rem_716 X1 X2 H).
   intro H. elim (rem_721  H).
Qed.

Remark rem_725 : (forall X:term, auto___def_75 X -> auto___type_17 X)
    -> forall X1:term, auto___def_77 X1 -> auto___def_77 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_726 : (forall X:term, auto___def_75 X -> auto___type_17 X)
    -> forall X1 X2:term, auto___def_77 X1 -> auto___type_17 X2 -> auto___def_77 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_75_p__type_17. intros X1 X2.
  cut (auto___def_77 X1 -> auto___def_77 X1). tauto. exact (rem_725 epsilon_m__def_75_p__type_17 X1).
Defined.

Remark rem_727 : (forall X:term, auto___def_75 X -> auto___type_17 X)
    -> forall X2:term, auto___type_17 X2 -> auto___type_17 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_728 : (forall X:term, auto___def_75 X -> auto___type_17 X)
    -> forall X1 X2:term, auto___def_77 X1 -> auto___type_17 X2 -> auto___type_17 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_75_p__type_17. intros X1 X2.
  cut (auto___type_17 X2 -> auto___type_17 X2). tauto. exact (rem_727 epsilon_m__def_75_p__type_17 X2).
Defined.

Remark rem_729 : (forall X:term, auto___def_75 X -> auto___type_17 X)
    -> forall X1 X2:term, auto___def_77 X1 -> auto___type_17 X2 -> (auto___def_77 X1 /\ auto___type_17 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_75_p__type_17. intros X1 X2. intros A1 A2.
  cut (auto___def_77 X1). 2:apply (rem_726 epsilon_m__def_75_p__type_17 X1 X2);  assumption.
  cut (auto___type_17 X2). 2:apply (rem_728 epsilon_m__def_75_p__type_17 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_730 : (forall X:term, auto___def_75 X -> auto___type_17 X)
    -> forall X1 X2:term, auto___def_77 X1 -> auto___type_17 X2 -> auto___type_17 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_75_p__type_17. intros X1 X2. intros A1 A2.
  case (rem_729 epsilon_m__def_75_p__type_17 X1 X2 A1 A2). clear  epsilon_m__def_75_p__type_17 A1 A2. intros. apply trans___type_17_crypt_1;  tauto.
 clear  epsilon_m__def_75_p__type_17 A1 A2. tauto.
Defined.

Remark rem_731 : forall X1 X2:term, auto___def_75 (crypt X1 X2) -> or_1
    (auto___def_77 X1 /\ auto___type_17 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_732 : (forall X:term, auto___def_75 X -> auto___type_17 X)
    -> forall X1 X2:term, auto___def_75 (crypt X1 X2) -> auto___type_17 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_75_p__type_17. intros X1 X2. intro H. intros.
  elim (rem_731 X1 X2 H);  intros.
  apply (rem_730 epsilon_m__def_75_p__type_17 X1 X2);  tauto.
Defined.

Remark rem_733 : forall X1 X2:term, auto___def_75 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_734 : forall X1 X2:term, auto___def_75 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_735 : auto___def_75 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_736 : forall X1 X2:term, auto___def_75 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_737 : forall X1 X2:term, auto___def_75 (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_738 : forall X1 X2:term, auto___def_75 (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_739 : forall X1:term, auto___def_75 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_740 : auto___def_75 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_741 : forall X1 X2:term, auto___def_75 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_742 : forall X1 X2:term, auto___def_75 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_743 : auto___def_75 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_744 : auto___def_75 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_745 : forall X1 X2:term, auto___def_75 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_746 : forall X1 X2:term, auto___def_75 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_747 : forall X1 X2:term, auto___def_75 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_748 : forall X1 X2:term, auto___def_75 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_749 : forall X1:term, auto___def_75 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_750 : auto___def_75 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_751 : forall X1 X2:term, auto___def_75 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_752 : auto___def_75 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_753 : auto___def_75 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_754 : auto___def_75 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_755 : forall X1 X2:term, auto___def_75 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_756 : forall X1 X2:term, auto___def_75 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_757 : forall X1:term, auto___def_75 X1 -> auto___type_17 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_75_p__type_17 1.
  intro X. case X.
   intro H. elim (rem_743  H).
   intro H. elim (rem_735  H).
  intros X1 X2. intro H. elim (rem_748 X1 X2 H).
  intros X1 X2;  exact (rem_732 epsilon_m__def_75_p__type_17 X1 X2).
  intros X1 X2. intro H. elim (rem_746 X1 X2 H).
  intros X1 X2. intro H. elim (rem_747 X1 X2 H).
   intro H. elim (rem_752  H).
  intros X1 X2. intro H. elim (rem_756 X1 X2 H).
   intro H. elim (rem_753  H).
  intros X1 X2. intro H. elim (rem_755 X1 X2 H).
  intros X1 X2. intro H. elim (rem_736 X1 X2 H).
  intros X1 X2. intro H. elim (rem_733 X1 X2 H).
  intros X1 X2. intro H. elim (rem_745 X1 X2 H).
  intros X1. intro H. elim (rem_739 X1 H).
  intros X1 X2. intro H. elim (rem_742 X1 X2 H).
  intros X1 X2. intro H. elim (rem_741 X1 X2 H).
   intro H. elim (rem_744  H).
   intro H. elim (rem_740  H).
  intros X1 X2. intro H. elim (rem_738 X1 X2 H).
  intros X1 X2. intro H. elim (rem_737 X1 X2 H).
  intros X1. intro H. elim (rem_749 X1 H).
   intro H. elim (rem_754  H).
  intros X1 X2. intro H. elim (rem_751 X1 X2 H).
  intros X1 X2. intro H. elim (rem_734 X1 X2 H).
   intro H. elim (rem_750  H).
Qed.

Remark rem_758 : forall X1 X2:term, auto___def_75 X1 -> auto_knows_current X2 -> auto___type_17 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_75 X1 -> auto___type_17 X1). tauto. exact (rem_757 X1).
Qed.

Remark rem_759 : forall X1 X3:term, auto___def_75 X1 -> auto_knows_current X3 -> auto___type_17 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_75 X1 -> auto_knows_current X2 -> auto___type_17 X1). tauto. exact (rem_758 X1 X2).
Qed.

Remark rem_760 : (forall X:term, auto___def_79 X -> auto___type_17 X)
    -> forall X1:term, auto___def_81 X1 -> auto___def_81 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_761 : (forall X:term, auto___def_79 X -> auto___type_17 X)
    -> forall X1 X2:term, auto___def_81 X1 -> auto___def_82 X2 -> auto___def_81 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_79_p__type_17. intros X1 X2.
  cut (auto___def_81 X1 -> auto___def_81 X1). tauto. exact (rem_760 epsilon_m__def_79_p__type_17 X1).
Defined.

Remark rem_762 : (forall X:term, auto___def_79 X -> auto___type_17 X)
    -> forall X2:term, auto___def_82 X2 -> auto___def_82 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_763 : (forall X:term, auto___def_79 X -> auto___type_17 X)
    -> forall X1 X2:term, auto___def_81 X1 -> auto___def_82 X2 -> auto___def_82 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_79_p__type_17. intros X1 X2.
  cut (auto___def_82 X2 -> auto___def_82 X2). tauto. exact (rem_762 epsilon_m__def_79_p__type_17 X2).
Defined.

Remark rem_764 : (forall X:term, auto___def_79 X -> auto___type_17 X)
    -> forall X1 X2:term, auto___def_81 X1 -> auto___def_82 X2 -> (auto___def_81 X1 /\ auto___def_82 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_79_p__type_17. intros X1 X2. intros A1 A2.
  cut (auto___def_81 X1). 2:apply (rem_761 epsilon_m__def_79_p__type_17 X1 X2);  assumption.
  cut (auto___def_82 X2). 2:apply (rem_763 epsilon_m__def_79_p__type_17 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_765 : (forall X:term, auto___def_79 X -> auto___type_17 X)
    -> forall X1 X2:term, auto___def_81 X1 -> auto___def_82 X2 -> auto___type_17 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_79_p__type_17. intros X1 X2. intros A1 A2.
  case (rem_764 epsilon_m__def_79_p__type_17 X1 X2 A1 A2). clear  epsilon_m__def_79_p__type_17 A1 A2. intros. apply trans___type_17_crypt_2;  tauto.
 clear  epsilon_m__def_79_p__type_17 A1 A2. tauto.
Defined.

Remark rem_766 : forall X1 X2:term, auto___def_79 (crypt X1 X2) -> or_1
    (auto___def_81 X1 /\ auto___def_82 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_767 : (forall X:term, auto___def_79 X -> auto___type_17 X)
    -> forall X1 X2:term, auto___def_79 (crypt X1 X2) -> auto___type_17 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_79_p__type_17. intros X1 X2. intro H. intros.
  elim (rem_766 X1 X2 H);  intros.
  apply (rem_765 epsilon_m__def_79_p__type_17 X1 X2);  tauto.
Defined.

Remark rem_768 : forall X1 X2:term, auto___def_79 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_769 : forall X1 X2:term, auto___def_79 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_770 : auto___def_79 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_771 : forall X1 X2:term, auto___def_79 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_772 : forall X1 X2:term, auto___def_79 (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_773 : forall X1 X2:term, auto___def_79 (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_774 : forall X1:term, auto___def_79 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_775 : auto___def_79 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_776 : forall X1 X2:term, auto___def_79 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_777 : forall X1 X2:term, auto___def_79 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_778 : auto___def_79 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_779 : auto___def_79 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_780 : forall X1 X2:term, auto___def_79 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_781 : forall X1 X2:term, auto___def_79 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_782 : forall X1 X2:term, auto___def_79 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_783 : forall X1 X2:term, auto___def_79 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_784 : forall X1:term, auto___def_79 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_785 : auto___def_79 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_786 : forall X1 X2:term, auto___def_79 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_787 : auto___def_79 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_788 : auto___def_79 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_789 : auto___def_79 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_790 : forall X1 X2:term, auto___def_79 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_791 : forall X1 X2:term, auto___def_79 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_792 : forall X1:term, auto___def_79 X1 -> auto___type_17 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_79_p__type_17 1.
  intro X. case X.
   intro H. elim (rem_778  H).
   intro H. elim (rem_770  H).
  intros X1 X2. intro H. elim (rem_783 X1 X2 H).
  intros X1 X2;  exact (rem_767 epsilon_m__def_79_p__type_17 X1 X2).
  intros X1 X2. intro H. elim (rem_781 X1 X2 H).
  intros X1 X2. intro H. elim (rem_782 X1 X2 H).
   intro H. elim (rem_787  H).
  intros X1 X2. intro H. elim (rem_791 X1 X2 H).
   intro H. elim (rem_788  H).
  intros X1 X2. intro H. elim (rem_790 X1 X2 H).
  intros X1 X2. intro H. elim (rem_771 X1 X2 H).
  intros X1 X2. intro H. elim (rem_768 X1 X2 H).
  intros X1 X2. intro H. elim (rem_780 X1 X2 H).
  intros X1. intro H. elim (rem_774 X1 H).
  intros X1 X2. intro H. elim (rem_777 X1 X2 H).
  intros X1 X2. intro H. elim (rem_776 X1 X2 H).
   intro H. elim (rem_779  H).
   intro H. elim (rem_775  H).
  intros X1 X2. intro H. elim (rem_773 X1 X2 H).
  intros X1 X2. intro H. elim (rem_772 X1 X2 H).
  intros X1. intro H. elim (rem_784 X1 H).
   intro H. elim (rem_789  H).
  intros X1 X2. intro H. elim (rem_786 X1 X2 H).
  intros X1 X2. intro H. elim (rem_769 X1 X2 H).
   intro H. elim (rem_785  H).
Qed.

Remark rem_793 : forall X1 X2:term, auto___def_79 X1 -> auto_knows_current X2 -> auto___type_17 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_79 X1 -> auto___type_17 X1). tauto. exact (rem_792 X1).
Qed.

Remark rem_794 : forall X1 X3:term, auto___def_79 X1 -> auto_knows_current X3 -> auto___type_17 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_79 X1 -> auto_knows_current X2 -> auto___type_17 X1). tauto. exact (rem_793 X1 X2).
Qed.

Remark rem_795 : (forall X:term, auto___def_71 X -> auto___type_17 X)
    -> forall X1:term, auto___def_12 X1 -> auto___def_12 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_796 : (forall X:term, auto___def_71 X -> auto___type_17 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_73 X2 -> auto___def_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_71_p__type_17. intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_12 X1). tauto. exact (rem_795 epsilon_m__def_71_p__type_17 X1).
Defined.

Remark rem_797 : (forall X:term, auto___def_71 X -> auto___type_17 X)
    -> forall X2:term, auto___def_73 X2 -> auto___def_73 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_798 : (forall X:term, auto___def_71 X -> auto___type_17 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_73 X2 -> auto___def_73 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_71_p__type_17. intros X1 X2.
  cut (auto___def_73 X2 -> auto___def_73 X2). tauto. exact (rem_797 epsilon_m__def_71_p__type_17 X2).
Defined.

Remark rem_799 : (forall X:term, auto___def_71 X -> auto___type_17 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_73 X2 -> (auto___def_12 X1 /\ auto___def_73 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_71_p__type_17. intros X1 X2. intros A1 A2.
  cut (auto___def_12 X1). 2:apply (rem_796 epsilon_m__def_71_p__type_17 X1 X2);  assumption.
  cut (auto___def_73 X2). 2:apply (rem_798 epsilon_m__def_71_p__type_17 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_800 : (forall X:term, auto___def_71 X -> auto___type_17 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_73 X2 -> auto___type_17 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_71_p__type_17. intros X1 X2. intros A1 A2.
  case (rem_799 epsilon_m__def_71_p__type_17 X1 X2 A1 A2). clear  epsilon_m__def_71_p__type_17 A1 A2. intros. apply trans___type_17_key_1;  tauto.
 clear  epsilon_m__def_71_p__type_17 A1 A2. tauto.
Defined.

Remark rem_801 : forall X1 X2:term, auto___def_71 (key X1 X2) -> or_1
    (auto___def_12 X1 /\ auto___def_73 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_802 : (forall X:term, auto___def_71 X -> auto___type_17 X)
    -> forall X1 X2:term, auto___def_71 (key X1 X2) -> auto___type_17 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_71_p__type_17. intros X1 X2. intro H. intros.
  elim (rem_801 X1 X2 H);  intros.
  apply (rem_800 epsilon_m__def_71_p__type_17 X1 X2);  tauto.
Defined.

Remark rem_803 : forall X1 X2:term, auto___def_71 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_804 : forall X1 X2:term, auto___def_71 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_805 : forall X1 X2:term, auto___def_71 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_806 : auto___def_71 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_807 : forall X1 X2:term, auto___def_71 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_808 : forall X1 X2:term, auto___def_71 (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_809 : forall X1 X2:term, auto___def_71 (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_810 : forall X1:term, auto___def_71 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_811 : auto___def_71 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_812 : forall X1 X2:term, auto___def_71 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_813 : forall X1 X2:term, auto___def_71 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_814 : auto___def_71 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_815 : auto___def_71 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_816 : forall X1 X2:term, auto___def_71 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_817 : forall X1 X2:term, auto___def_71 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_818 : forall X1 X2:term, auto___def_71 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_819 : forall X1 X2:term, auto___def_71 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_820 : forall X1:term, auto___def_71 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_821 : auto___def_71 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_822 : forall X1 X2:term, auto___def_71 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_823 : auto___def_71 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_824 : auto___def_71 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_825 : auto___def_71 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_826 : forall X1 X2:term, auto___def_71 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_827 : forall X1:term, auto___def_71 X1 -> auto___type_17 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_71_p__type_17 1.
  intro X. case X.
   intro H. elim (rem_814  H).
   intro H. elim (rem_806  H).
  intros X1 X2. intro H. elim (rem_819 X1 X2 H).
  intros X1 X2. intro H. elim (rem_803 X1 X2 H).
  intros X1 X2. intro H. elim (rem_817 X1 X2 H).
  intros X1 X2. intro H. elim (rem_818 X1 X2 H).
   intro H. elim (rem_823  H).
  intros X1 X2;  exact (rem_802 epsilon_m__def_71_p__type_17 X1 X2).
   intro H. elim (rem_824  H).
  intros X1 X2. intro H. elim (rem_826 X1 X2 H).
  intros X1 X2. intro H. elim (rem_807 X1 X2 H).
  intros X1 X2. intro H. elim (rem_804 X1 X2 H).
  intros X1 X2. intro H. elim (rem_816 X1 X2 H).
  intros X1. intro H. elim (rem_810 X1 H).
  intros X1 X2. intro H. elim (rem_813 X1 X2 H).
  intros X1 X2. intro H. elim (rem_812 X1 X2 H).
   intro H. elim (rem_815  H).
   intro H. elim (rem_811  H).
  intros X1 X2. intro H. elim (rem_809 X1 X2 H).
  intros X1 X2. intro H. elim (rem_808 X1 X2 H).
  intros X1. intro H. elim (rem_820 X1 H).
   intro H. elim (rem_825  H).
  intros X1 X2. intro H. elim (rem_822 X1 X2 H).
  intros X1 X2. intro H. elim (rem_805 X1 X2 H).
   intro H. elim (rem_821  H).
Qed.

Remark rem_828 : forall X1 X2 X3:term, auto___def_71 X1 -> auto_agent X2 -> auto_agent X3 -> auto___type_17 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_71 X1 -> auto___type_17 X1). tauto. exact (rem_827 X1).
Qed.

Remark rem_829 : forall X1 X2 X3:term, auto_agent X2 -> auto___def_71 X1 -> auto_agent X3 -> auto___type_17 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_71 X1 -> auto_agent X2 -> auto_agent X3 -> auto___type_17 X1). tauto. exact (rem_828 X1 X2 X3).
Qed.

Remark rem_830 : forall X1 X2 X3:term, auto___def_74 X1 X2 X3 -> or_3
    (auto___def_75 X2 /\ auto_knows_current X3)
    (auto___def_79 X2 /\ auto_knows_current X3)
    (auto_agent X1 /\ auto___def_71 X2 /\ auto_agent X3)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_831 : forall X1 X2 X3:term, auto___def_74 X2 X1 X3 -> auto___type_17 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_830 X2 X1 X3 H);  intros.
  apply (rem_759 X1 X3);  tauto.
  apply (rem_794 X1 X3);  tauto.
  apply (rem_829 X1 X2 X3);  tauto.
Qed.

Remark rem_832 : (forall X:term, auto___def_42 X -> auto___type_16 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_833 : (forall X:term, auto___def_42 X -> auto___type_16 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_42_p__type_16. intros X1. intros A1.
  cut (auto_knows_old X1). 2:apply (rem_832 epsilon_m__def_42_p__type_16 X1);  assumption.
  tauto.
Defined.

Remark rem_834 : (forall X:term, auto___def_42 X -> auto___type_16 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto___type_16 (r_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_42_p__type_16. intros X1 X2. intros A1.
  case (rem_833 epsilon_m__def_42_p__type_16 X1 A1). clear  epsilon_m__def_42_p__type_16 A1. intros. apply trans___type_16_r_old_1;  tauto.
 clear  epsilon_m__def_42_p__type_16 A1. tauto.
Defined.

Remark rem_835 : (forall X:term, auto___def_42 X -> auto___type_16 X)
    -> forall X1 X2:term, auto___def_42 (r_old X1 X2) -> auto___type_16 (r_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_42_p__type_16. intros X1 X2. intro H. intros.
  elim (rem_392 X1 X2 H);  intros.
  apply (rem_834 epsilon_m__def_42_p__type_16 X1 X2);  tauto.
Defined.

Remark rem_836 : forall X1:term, auto___def_42 X1 -> auto___type_16 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_42_p__type_16 1.
  intro X. case X.
   intro H. elim (rem_404  H).
   intro H. elim (rem_397  H).
  intros X1 X2. intro H. elim (rem_409 X1 X2 H).
  intros X1 X2. intro H. elim (rem_394 X1 X2 H).
  intros X1 X2. intro H. elim (rem_407 X1 X2 H).
  intros X1 X2. intro H. elim (rem_408 X1 X2 H).
   intro H. elim (rem_413  H).
  intros X1 X2. intro H. elim (rem_417 X1 X2 H).
   intro H. elim (rem_414  H).
  intros X1 X2. intro H. elim (rem_416 X1 X2 H).
  intros X1 X2. intro H. elim (rem_398 X1 X2 H).
  intros X1 X2. intro H. elim (rem_395 X1 X2 H).
  intros X1 X2. intro H. elim (rem_406 X1 X2 H).
  intros X1. intro H. elim (rem_400 X1 H).
  intros X1 X2. intro H. elim (rem_403 X1 X2 H).
  intros X1 X2. intro H. elim (rem_402 X1 X2 H).
   intro H. elim (rem_405  H).
   intro H. elim (rem_401  H).
  intros X1 X2. intro H. elim (rem_399 X1 X2 H).
  intros X1 X2;  exact (rem_835 epsilon_m__def_42_p__type_16 X1 X2).
  intros X1. intro H. elim (rem_410 X1 H).
   intro H. elim (rem_415  H).
  intros X1 X2. intro H. elim (rem_412 X1 X2 H).
  intros X1 X2. intro H. elim (rem_396 X1 X2 H).
   intro H. elim (rem_411  H).
Qed.

Remark rem_837 : forall X1 X2:term, auto___def_36 X2 -> auto___def_42 X1 -> auto_testable_old X2 -> auto___type_16 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_42 X1 -> auto___type_16 X1). tauto. exact (rem_836 X1).
Qed.

Remark rem_838 : forall X1 X2:term, auto___def_42 X1 -> auto___def_36 X2 -> auto_testable_old X2 -> auto___type_16 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_36 X2 -> auto___def_42 X1 -> auto_testable_old X2 -> auto___type_16 X1). tauto. exact (rem_837 X1 X2).
Qed.

Remark rem_839 : (forall X:term, auto___type_8 X -> auto___type_16 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_840 : (forall X:term, auto___type_8 X -> auto___type_16 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_8_p__type_16. intros X1. intros A1.
  cut (auto_knows_old X1). 2:apply (rem_839 epsilon_m__type_8_p__type_16 X1);  assumption.
  tauto.
Defined.

Remark rem_841 : (forall X:term, auto___type_8 X -> auto___type_16 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto___type_16 (r_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_8_p__type_16. intros X1 X2. intros A1.
  case (rem_840 epsilon_m__type_8_p__type_16 X1 A1). clear  epsilon_m__type_8_p__type_16 A1. intros. apply trans___type_16_r_old_1;  tauto.
 clear  epsilon_m__type_8_p__type_16 A1. tauto.
Defined.

Remark rem_842 : (forall X:term, auto___type_8 X -> auto___type_16 X)
    -> forall X1 X2:term, auto___type_8 (r_old X1 X2) -> auto___type_16 (r_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_8_p__type_16. intros X1 X2. intro H. intros.
  elim (rem_456 X1 X2 H);  intros.
  apply (rem_841 epsilon_m__type_8_p__type_16 X1 X2);  tauto.
Defined.

Remark rem_843 : forall X1:term, auto___type_8 X1 -> auto___type_16 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_8_p__type_16 1.
  intro X. case X.
   intro H. elim (rem_468  H).
   intro H. elim (rem_461  H).
  intros X1 X2. intro H. elim (rem_473 X1 X2 H).
  intros X1 X2. intro H. elim (rem_458 X1 X2 H).
  intros X1 X2. intro H. elim (rem_471 X1 X2 H).
  intros X1 X2. intro H. elim (rem_472 X1 X2 H).
   intro H. elim (rem_477  H).
  intros X1 X2. intro H. elim (rem_481 X1 X2 H).
   intro H. elim (rem_478  H).
  intros X1 X2. intro H. elim (rem_480 X1 X2 H).
  intros X1 X2. intro H. elim (rem_462 X1 X2 H).
  intros X1 X2. intro H. elim (rem_459 X1 X2 H).
  intros X1 X2. intro H. elim (rem_470 X1 X2 H).
  intros X1. intro H. elim (rem_464 X1 H).
  intros X1 X2. intro H. elim (rem_467 X1 X2 H).
  intros X1 X2. intro H. elim (rem_466 X1 X2 H).
   intro H. elim (rem_469  H).
   intro H. elim (rem_465  H).
  intros X1 X2. intro H. elim (rem_463 X1 X2 H).
  intros X1 X2;  exact (rem_842 epsilon_m__type_8_p__type_16 X1 X2).
  intros X1. intro H. elim (rem_474 X1 H).
   intro H. elim (rem_479  H).
  intros X1 X2. intro H. elim (rem_476 X1 X2 H).
  intros X1 X2. intro H. elim (rem_460 X1 X2 H).
   intro H. elim (rem_475  H).
Qed.

Remark rem_844 : forall X1 X2:term, auto___type_7 X2 -> auto___type_8 X1 -> auto_testable_old X2 -> auto___type_16 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_8 X1 -> auto___type_16 X1). tauto. exact (rem_843 X1).
Qed.

Remark rem_845 : forall X1 X2:term, auto___type_8 X1 -> auto___type_7 X2 -> auto_testable_old X2 -> auto___type_16 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___type_7 X2 -> auto___type_8 X1 -> auto_testable_old X2 -> auto___type_16 X1). tauto. exact (rem_844 X1 X2).
Qed.

Remark rem_846 : (forall X:term, auto___type_4 X -> auto___type_16 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_847 : (forall X:term, auto___type_4 X -> auto___type_16 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_p__type_16. intros X1. intros A1.
  cut (auto_knows_old X1). 2:apply (rem_846 epsilon_m__type_4_p__type_16 X1);  assumption.
  tauto.
Defined.

Remark rem_848 : (forall X:term, auto___type_4 X -> auto___type_16 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto___type_16 (r_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_p__type_16. intros X1 X2. intros A1.
  case (rem_847 epsilon_m__type_4_p__type_16 X1 A1). clear  epsilon_m__type_4_p__type_16 A1. intros. apply trans___type_16_r_old_1;  tauto.
 clear  epsilon_m__type_4_p__type_16 A1. tauto.
Defined.

Remark rem_849 : (forall X:term, auto___type_4 X -> auto___type_16 X)
    -> forall X1 X2:term, auto___type_4 (r_old X1 X2) -> auto___type_16 (r_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_p__type_16. intros X1 X2. intro H. intros.
  elim (rem_519 X1 X2 H);  intros.
  apply (rem_848 epsilon_m__type_4_p__type_16 X1 X2);  tauto.
Defined.

Remark rem_850 : forall X1:term, auto___type_4 X1 -> auto___type_16 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_4_p__type_16 1.
  intro X. case X.
   intro H. elim (rem_531  H).
   intro H. elim (rem_524  H).
  intros X1 X2. intro H. elim (rem_536 X1 X2 H).
  intros X1 X2. intro H. elim (rem_521 X1 X2 H).
  intros X1 X2. intro H. elim (rem_534 X1 X2 H).
  intros X1 X2. intro H. elim (rem_535 X1 X2 H).
   intro H. elim (rem_540  H).
  intros X1 X2. intro H. elim (rem_544 X1 X2 H).
   intro H. elim (rem_541  H).
  intros X1 X2. intro H. elim (rem_543 X1 X2 H).
  intros X1 X2. intro H. elim (rem_525 X1 X2 H).
  intros X1 X2. intro H. elim (rem_522 X1 X2 H).
  intros X1 X2. intro H. elim (rem_533 X1 X2 H).
  intros X1. intro H. elim (rem_527 X1 H).
  intros X1 X2. intro H. elim (rem_530 X1 X2 H).
  intros X1 X2. intro H. elim (rem_529 X1 X2 H).
   intro H. elim (rem_532  H).
   intro H. elim (rem_528  H).
  intros X1 X2. intro H. elim (rem_526 X1 X2 H).
  intros X1 X2;  exact (rem_849 epsilon_m__type_4_p__type_16 X1 X2).
  intros X1. intro H. elim (rem_537 X1 H).
   intro H. elim (rem_542  H).
  intros X1 X2. intro H. elim (rem_539 X1 X2 H).
  intros X1 X2. intro H. elim (rem_523 X1 X2 H).
   intro H. elim (rem_538  H).
Qed.

Remark rem_851 : forall X1 X2:term, auto___def_24 X2 -> auto___type_4 X1 -> auto_testable_old X2 -> auto___type_16 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_4 X1 -> auto___type_16 X1). tauto. exact (rem_850 X1).
Qed.

Remark rem_852 : forall X1 X2:term, auto___type_4 X1 -> auto___def_24 X2 -> auto_testable_old X2 -> auto___type_16 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_24 X2 -> auto___type_4 X1 -> auto_testable_old X2 -> auto___type_16 X1). tauto. exact (rem_851 X1 X2).
Qed.

Remark rem_853 : forall X1 X2:term, auto___def_5 X1 X2 -> or_3
    (auto___def_42 X1 /\ auto___def_36 X2)
    (auto___type_8 X1 /\ auto___type_7 X2)
    (auto___type_4 X1 /\ auto___def_24 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_854 : forall X1 X2:term, auto___def_5 X1 X2 -> auto_testable_old X2 -> auto___type_16 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_853 X1 X2 H);  intros.
  apply (rem_838 X1 X2);  tauto.
  apply (rem_845 X1 X2);  tauto.
  apply (rem_852 X1 X2);  tauto.
Qed.

Remark rem_855 : True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
   tauto.
Qed.

Remark rem_856 : auto___def_59 pub. (* Deduce positive atom. *)
Proof.
   case rem_855. intros. apply trans___def_59_pub_1;  tauto.
 tauto.
Qed.

Remark rem_857 : forall X1:term, auto___def_31 X1 -> auto___def_31 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_858 : forall X1 X2:term, auto___def_31 X1 -> auto___def_32 X2 -> auto___def_31 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_31 X1 -> auto___def_31 X1). tauto. exact (rem_857 X1).
Qed.

Remark rem_859 : forall X2:term, auto___def_32 X2 -> auto___def_32 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_860 : forall X1 X2:term, auto___def_31 X1 -> auto___def_32 X2 -> auto___def_32 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_32 X2 -> auto___def_32 X2). tauto. exact (rem_859 X2).
Qed.

Remark rem_861 : forall X1 X2:term, auto___def_31 X1 -> auto___def_32 X2 -> (auto___def_31 X1 /\ auto___def_32 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_31 X1). 2:apply (rem_858 X1 X2);  assumption.
  cut (auto___def_32 X2). 2:apply (rem_860 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_862 : forall X1 X2:term, auto___def_31 X1 -> auto___def_32 X2 -> auto___def_30 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_861 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_30_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_863 : forall X1 X2:term, auto___def_32 X2 -> auto___def_31 X1 -> auto___def_30 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_31 X1 -> auto___def_32 X2 -> auto___def_30 (cons X1 X2)). tauto. exact (rem_862 X1 X2).
Qed.

Remark rem_864 : forall X1 X3:term, auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X3.
  cut (auto_knows_old X1 -> auto_knows_old X1). tauto. exact (rem_276 X1).
Qed.

Remark rem_865 : forall X1 X3:term, auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X3. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_864 X1 X3);  assumption.
  tauto.
Qed.

Remark rem_866 : forall X1 X2 X3:term, auto_knows_old X3 -> auto_knows_old X1 -> auto___def_20 (passwd_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2.
  case (rem_865 X1 X3 A1 A2). clear  A1 A2. intros. apply trans___def_20_passwd_old_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_867 : forall X1 X2 X3:term, auto_knows_old X1 -> auto_knows_old X3 -> auto___def_20 (passwd_old X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_knows_old X3 -> auto_knows_old X1 -> auto___def_20 (passwd_old X1 X2)). tauto. exact (rem_866 X1 X2 X3).
Qed.

Remark rem_868 : forall X1 X2:term, auto___def_18 X1 X2 -> or_1
    (auto_knows_old X1 /\ auto_knows_old X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_869 : forall X1 X2 X3:term, auto___def_18 X1 X3 -> auto___def_20 (passwd_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_868 X1 X3 H);  intros.
  apply (rem_867 X1 X2 X3);  tauto.
Qed.

Remark rem_870 : forall X1 X2:term, auto___def_6 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_871 : forall X1 X2:term, auto___def_6 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_872 : forall X1 X2:term, auto___def_6 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_873 : auto___def_6 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_874 : forall X1 X2:term, auto___def_6 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_875 : forall X1 X2:term, auto___def_6 (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_876 : forall X1 X2:term, auto___def_6 (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_877 : forall X1:term, auto___def_6 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_878 : auto___def_6 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_879 : forall X1 X2:term, auto___def_6 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_880 : forall X1 X2:term, auto___def_6 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_881 : auto___def_6 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_882 : auto___def_6 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_883 : forall X1 X2:term, auto___def_6 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_884 : forall X1 X2:term, auto___def_6 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_885 : forall X1 X2:term, auto___def_6 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_886 : forall X1 X2:term, auto___def_6 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_887 : forall X1:term, auto___def_6 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_888 : auto___def_6 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_889 : forall X1 X2:term, auto___def_6 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_890 : auto___def_6 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_891 : auto___def_6 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_892 : auto___def_6 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_893 : forall X1 X2:term, auto___def_6 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_894 : forall X1 X2:term, auto___def_6 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_895 : forall X1:term, auto___def_6 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_6 1.
  intro X. case X.
   intro H. elim (rem_881  H).
   intro H. elim (rem_873  H).
  intros X1 X2. intro H. elim (rem_886 X1 X2 H).
  intros X1 X2. intro H. elim (rem_870 X1 X2 H).
  intros X1 X2. intro H. elim (rem_884 X1 X2 H).
  intros X1 X2. intro H. elim (rem_885 X1 X2 H).
   intro H. elim (rem_890  H).
  intros X1 X2. intro H. elim (rem_894 X1 X2 H).
   intro H. elim (rem_891  H).
  intros X1 X2. intro H. elim (rem_893 X1 X2 H).
  intros X1 X2. intro H. elim (rem_874 X1 X2 H).
  intros X1 X2. intro H. elim (rem_871 X1 X2 H).
  intros X1 X2. intro H. elim (rem_883 X1 X2 H).
  intros X1. intro H. elim (rem_877 X1 H).
  intros X1 X2. intro H. elim (rem_880 X1 X2 H).
  intros X1 X2. intro H. elim (rem_879 X1 X2 H).
   intro H. elim (rem_882  H).
   intro H. elim (rem_878  H).
  intros X1 X2. intro H. elim (rem_876 X1 X2 H).
  intros X1 X2. intro H. elim (rem_875 X1 X2 H).
  intros X1. intro H. elim (rem_887 X1 H).
   intro H. elim (rem_892  H).
  intros X1 X2. intro H. elim (rem_889 X1 X2 H).
  intros X1 X2. intro H. elim (rem_872 X1 X2 H).
   intro H. elim (rem_888  H).
Qed.

Remark rem_896 : forall X1:term, auto___def_6 X1 -> False. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_6 X1 -> False). tauto.
  exact (rem_895 X1).
Qed.

Remark rem_897 : forall X2:term, auto___def_6 X2 -> False. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1.
  cut (auto___def_6 X1 -> False). tauto. exact (rem_896 X1).
Qed.

Remark rem_898 : forall X1 X2:term, auto___def_105 X1 -> auto___def_6 X2 -> False. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_6 X2 -> False). tauto.
  exact (rem_897 X2).
Qed.

Remark rem_899 : forall X1 X2:term, auto___def_105 X1 -> auto___def_6 X2 -> auto___def_56 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (False). tauto.
  exact (rem_898 X1 X2 A1 A2).
Qed.

Remark rem_900 : forall X1 X2:term, auto___def_6 X2 -> auto___def_93 X1 -> auto___def_56 (key X1 X2). (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_895 X2)). tauto.
Qed.

Remark rem_901 : forall X1 X2:term, auto___def_93 X1 -> auto___def_6 X2 -> auto___def_56 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_6 X2 -> auto___def_93 X1 -> auto___def_56 (key X1 X2)). tauto. exact (rem_900 X1 X2).
Qed.

Remark rem_902 : forall X1 X2:term, auto___def_41 X1 -> auto___def_6 X2 -> auto___def_56 (key X1 X2). (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_895 X2)). tauto.
Qed.

Remark rem_903 : forall X1 X2:term, auto___def_6 X2 -> auto___def_86 X1 -> auto___def_56 (key X1 X2). (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_895 X2)). tauto.
Qed.

Remark rem_904 : forall X1 X2:term, auto___def_86 X1 -> auto___def_6 X2 -> auto___def_56 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_6 X2 -> auto___def_86 X1 -> auto___def_56 (key X1 X2)). tauto. exact (rem_903 X1 X2).
Qed.

Remark rem_905 : forall X1 X2:term, auto___def_101 X1 -> auto___def_6 X2 -> auto___def_56 (key X1 X2). (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_895 X2)). tauto.
Qed.

Remark rem_906 : forall X1 X2:term, auto___def_119 X1 -> auto___def_6 X2 -> auto___def_56 (key X1 X2). (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_895 X2)). tauto.
Qed.

Remark rem_907 : forall X1 X2:term, auto___def_6 X2 -> auto___def_60 X1 -> auto___def_56 (key X1 X2). (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_895 X2)). tauto.
Qed.

Remark rem_908 : forall X1 X2:term, auto___def_60 X1 -> auto___def_6 X2 -> auto___def_56 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_6 X2 -> auto___def_60 X1 -> auto___def_56 (key X1 X2)). tauto. exact (rem_907 X1 X2).
Qed.

Remark rem_909 : forall X1 X2:term, auto___def_45 X1 -> auto___def_6 X2 -> auto___def_56 (key X1 X2). (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_895 X2)). tauto.
Qed.

Remark rem_910 : forall X1 X2:term, auto___def_26 X1 -> auto___def_6 X2 -> auto___def_56 (key X1 X2). (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_895 X2)). tauto.
Qed.

Remark rem_911 : forall X1 X2:term, auto___def_33 X1 -> auto___def_6 X2 -> auto___def_56 (key X1 X2). (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_895 X2)). tauto.
Qed.

Inductive or_10(H1 H2 H3 H4 H5 H6 H7 H8 H9 H10:Prop) : Prop :=
    or_10_intro_1 : H1 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_2 : H2 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_3 : H3 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_4 : H4 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_5 : H5 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_6 : H6 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_7 : H7 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_8 : H8 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_9 : H9 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_10 : H10 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
.
Hint Constructors auto___def_105 : h1mc_states_hint.
Hint Constructors auto___def_93 : h1mc_states_hint.
Hint Constructors auto___def_41 : h1mc_states_hint.
Hint Constructors auto___def_86 : h1mc_states_hint.
Hint Constructors auto___def_101 : h1mc_states_hint.
Hint Constructors auto___def_119 : h1mc_states_hint.
Hint Constructors auto___def_60 : h1mc_states_hint.
Hint Constructors auto___def_45 : h1mc_states_hint.
Hint Constructors auto___def_26 : h1mc_states_hint.
Hint Constructors auto___def_33 : h1mc_states_hint.

Remark epsilon_m__def_57_p__def_105_p__def_93_p__def_41_p__def_86_p__def_101_p__def_119_p__def_60_p__def_45_p__def_26_p__def_33_o : forall X:term, auto___def_57 X -> or_10 (auto___def_105 X) (auto___def_93 X) (auto___def_41 X) (auto___def_86 X) (auto___def_101 X) (auto___def_119 X) (auto___def_60 X) (auto___def_45 X) (auto___def_26 X) (auto___def_33 X). (* Justify inversion for epsilon clause. *)
Proof.
 cut (forall X:term, auto___def_57 X -> auto___def_105 X \/ auto___def_93 X \/ auto___def_41 X \/ auto___def_86 X \/ auto___def_101 X \/ auto___def_119 X \/ auto___def_60 X \/ auto___def_45 X \/ auto___def_26 X \/ auto___def_33 X).
  intros H0 X H. decompose sum (H0 X H).
  apply or_10_intro_1; assumption.
  apply or_10_intro_2; assumption.
  apply or_10_intro_3; assumption.
  apply or_10_intro_4; assumption.
  apply or_10_intro_5; assumption.
  apply or_10_intro_6; assumption.
  apply or_10_intro_7; assumption.
  apply or_10_intro_8; assumption.
  apply or_10_intro_9; assumption.
  apply or_10_intro_10; assumption.
  destruct X; intro H; inversion H; intuition auto with h1mc_states_hint.
Qed.

Remark rem_912 : forall X1 X2:term, auto___def_57 X1 -> auto___def_6 X2 -> auto___def_56 (key X1 X2). (* Invert negative atom through epsilon clauses. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (epsilon_m__def_57_p__def_105_p__def_93_p__def_41_p__def_86_p__def_101_p__def_119_p__def_60_p__def_45_p__def_26_p__def_33_o X1 H); intros.
  apply (rem_899 X1 X2);  tauto.
  apply (rem_901 X1 X2);  tauto.
  apply (rem_902 X1 X2);  tauto.
  apply (rem_904 X1 X2);  tauto.
  apply (rem_905 X1 X2);  tauto.
  apply (rem_906 X1 X2);  tauto.
  apply (rem_908 X1 X2);  tauto.
  apply (rem_909 X1 X2);  tauto.
  apply (rem_910 X1 X2);  tauto.
  apply (rem_911 X1 X2);  tauto.
Qed.

Remark rem_913 : forall X1 X2:term, auto___def_6 X2 -> auto___def_57 X1 -> auto___def_56 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_57 X1 -> auto___def_6 X2 -> auto___def_56 (key X1 X2)). tauto. exact (rem_912 X1 X2).
Qed.

Remark rem_914 : forall X1 X3:term, auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X3.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_288 X1).
Qed.

Remark rem_915 : forall X1 X3:term, auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X3. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_914 X1 X3);  assumption.
  tauto.
Qed.

Remark rem_916 : forall X1 X2 X3:term, auto_knows_current X3 -> auto_knows_current X1 -> auto___def_80 (passwd_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2.
  case (rem_915 X1 X3 A1 A2). clear  A1 A2. intros. apply trans___def_80_passwd_current_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_917 : forall X1 X2 X3:term, auto_knows_current X1 -> auto_knows_current X3 -> auto___def_80 (passwd_current X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_knows_current X3 -> auto_knows_current X1 -> auto___def_80 (passwd_current X1 X2)). tauto. exact (rem_916 X1 X2 X3).
Qed.

Remark rem_918 : forall X1 X2:term, auto___def_78 X1 X2 -> or_1
    (auto_knows_current X1 /\ auto_knows_current X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_919 : forall X1 X2 X3:term, auto___def_78 X1 X3 -> auto___def_80 (passwd_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_918 X1 X3 H);  intros.
  apply (rem_917 X1 X2 X3);  tauto.
Qed.

Remark rem_920 : auto___def_101 sym. (* Deduce positive atom. *)
Proof.
   case rem_855. intros. apply trans___def_101_sym_1;  tauto.
 tauto.
Qed.

Remark rem_921 : auto___def_58 prv. (* Deduce positive atom. *)
Proof.
   case rem_855. intros. apply trans___def_58_prv_1;  tauto.
 tauto.
Qed.

Remark rem_922 : auto___def_33 sym. (* Deduce positive atom. *)
Proof.
   case rem_855. intros. apply trans___def_33_sym_1;  tauto.
 tauto.
Qed.

Remark rem_923 : forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_924 : forall X1 X2 X3:term, auto___def_77 X3 -> auto_agent X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_923 X1).
Qed.

Remark rem_925 : forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_926 : forall X1 X2 X3:term, auto___def_77 X3 -> auto_agent X2 -> auto_agent X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_925 X2).
Qed.

Remark rem_927 : forall X1 X2 X3:term, auto___def_77 X3 -> auto_agent X2 -> auto_agent X1 -> (auto_agent X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  cut (auto_agent X1). 2:apply (rem_924 X1 X2 X3);  assumption.
  cut (auto_agent X2). 2:apply (rem_926 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_928 : forall X1 X2 X3:term, auto___def_77 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_84 (noncea_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  case (rem_927 X1 X2 X3 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_84_noncea_current_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_929 : forall X1 X2 X3:term, auto___def_83 X3 X2 X1 -> auto___def_84 (noncea_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_308 X3 X2 X1 H);  intros.
  apply (rem_928 X1 X2 X3);  tauto.
Qed.

Remark rem_930 : forall X1 X2 X3 X4:term, auto_knows_old (cons X2 (cons X3 nil)) -> auto_knows_old (crypt X4 (key sym (r_old X2 X1))) -> auto_knows_old (crypt (nonceb_old X2 X1) (key sym (r_old X2 X1))) -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3.
  tauto.
Qed.

Remark rem_931 : forall X1 X2 X3 X4:term, auto_knows_old (cons X2 (cons X3 nil)) -> auto_knows_old (crypt X4 (key sym (r_old X2 X1))) -> auto_knows_old (crypt (nonceb_old X2 X1) (key sym (r_old X2 X1))) -> auto___def_49 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3.
  case (rem_930 X1 X2 X3 X4 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_49_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_932 : forall X1 X2 X3 X4:term, auto_knows_old (crypt (nonceb_old X2 X1) (key sym (r_old X2 X1))) -> auto_knows_old (crypt X3 (key sym (r_old X2 X1))) -> auto_knows_old (cons X2 (cons X4 nil)) -> auto___def_49 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X4 X3.
  cut (auto_knows_old (cons X2 (cons X3 nil)) -> auto_knows_old (crypt X4 (key sym (r_old X2 X1))) -> auto_knows_old (crypt (nonceb_old X2 X1) (key sym (r_old X2 X1))) -> auto___def_49 X1 X2). tauto. exact (rem_931 X1 X2 X3 X4).
Qed.

Remark rem_933 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1:term, auto___def_17 X1 -> auto___def_17 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_934 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_17 X1 -> auto___type_2 X2 -> auto___def_17 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto___def_17 X1 -> auto___def_17 X1). tauto. exact (rem_933 epsilon_mknows_current_p__type_24 X1).
Defined.

Remark rem_935 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X2:term, auto___type_2 X2 -> auto___type_2 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_936 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_17 X1 -> auto___type_2 X2 -> auto___type_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto___type_2 X2 -> auto___type_2 X2). tauto. exact (rem_935 epsilon_mknows_current_p__type_24 X2).
Defined.

Remark rem_937 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_17 X1 -> auto___type_2 X2 -> (auto___def_17 X1 /\ auto___type_2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  cut (auto___def_17 X1). 2:apply (rem_934 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  cut (auto___type_2 X2). 2:apply (rem_936 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_938 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_17 X1 -> auto___type_2 X2 -> auto___type_24 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  case (rem_937 epsilon_mknows_current_p__type_24 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_24 A1 A2. intros. apply trans___type_24_crypt_1;  tauto.
 clear  epsilon_mknows_current_p__type_24 A1 A2. tauto.
Defined.

Remark rem_939 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1:term, auto___def_36 X1 -> auto___def_36 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_940 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_36 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto___def_36 X1 -> auto___def_36 X1). tauto. exact (rem_939 epsilon_mknows_current_p__type_24 X1).
Defined.

Remark rem_941 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X2:term, auto___def_37 X2 -> auto___def_37 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_942 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_37 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto___def_37 X2 -> auto___def_37 X2). tauto. exact (rem_941 epsilon_mknows_current_p__type_24 X2).
Defined.

Remark rem_943 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> (auto___def_36 X1 /\ auto___def_37 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  cut (auto___def_36 X1). 2:apply (rem_940 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  cut (auto___def_37 X2). 2:apply (rem_942 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_944 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_24 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  case (rem_943 epsilon_mknows_current_p__type_24 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_24 A1 A2. intros. apply trans___type_24_crypt_2;  tauto.
 clear  epsilon_mknows_current_p__type_24 A1 A2. tauto.
Defined.

Remark rem_945 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1:term, auto___def_21 X1 -> auto___def_21 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_946 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_21 X1 -> auto___def_22 X2 -> auto___def_21 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto___def_21 X1 -> auto___def_21 X1). tauto. exact (rem_945 epsilon_mknows_current_p__type_24 X1).
Defined.

Remark rem_947 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X2:term, auto___def_22 X2 -> auto___def_22 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_948 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_21 X1 -> auto___def_22 X2 -> auto___def_22 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto___def_22 X2 -> auto___def_22 X2). tauto. exact (rem_947 epsilon_mknows_current_p__type_24 X2).
Defined.

Remark rem_949 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_21 X1 -> auto___def_22 X2 -> (auto___def_21 X1 /\ auto___def_22 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  cut (auto___def_21 X1). 2:apply (rem_946 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  cut (auto___def_22 X2). 2:apply (rem_948 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_950 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_21 X1 -> auto___def_22 X2 -> auto___type_24 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  case (rem_949 epsilon_mknows_current_p__type_24 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_24 A1 A2. intros. apply trans___type_24_crypt_3;  tauto.
 clear  epsilon_mknows_current_p__type_24 A1 A2. tauto.
Defined.

Remark rem_951 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_952 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_951 epsilon_mknows_current_p__type_24 X1).
Defined.

Remark rem_953 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X2:term, auto_knows_current X2 -> auto_knows_current X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_954 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_953 epsilon_mknows_current_p__type_24 X2).
Defined.

Remark rem_955 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_952 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_954 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_956 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_24 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  case (rem_955 epsilon_mknows_current_p__type_24 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_24 A1 A2. intros. apply trans___type_24_crypt_4;  tauto.
 clear  epsilon_mknows_current_p__type_24 A1 A2. tauto.
Defined.

Remark rem_957 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1:term, auto___type_22 X1 -> auto___type_22 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_958 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___type_22 X1 -> auto___def_104 X2 -> auto___type_22 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto___type_22 X1 -> auto___type_22 X1). tauto. exact (rem_957 epsilon_mknows_current_p__type_24 X1).
Defined.

Remark rem_959 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X2:term, auto___def_104 X2 -> auto___def_104 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_960 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___type_22 X1 -> auto___def_104 X2 -> auto___def_104 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto___def_104 X2 -> auto___def_104 X2). tauto. exact (rem_959 epsilon_mknows_current_p__type_24 X2).
Defined.

Remark rem_961 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___type_22 X1 -> auto___def_104 X2 -> (auto___type_22 X1 /\ auto___def_104 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  cut (auto___type_22 X1). 2:apply (rem_958 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  cut (auto___def_104 X2). 2:apply (rem_960 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_962 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___type_22 X1 -> auto___def_104 X2 -> auto___type_24 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  case (rem_961 epsilon_mknows_current_p__type_24 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_24 A1 A2. intros. apply trans___type_24_crypt_5;  tauto.
 clear  epsilon_mknows_current_p__type_24 A1 A2. tauto.
Defined.

Remark rem_963 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1:term, auto___def_88 X1 -> auto___def_88 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_964 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> auto___def_88 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto___def_88 X1 -> auto___def_88 X1). tauto. exact (rem_963 epsilon_mknows_current_p__type_24 X1).
Defined.

Remark rem_965 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X2:term, auto___def_89 X2 -> auto___def_89 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_966 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> auto___def_89 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto___def_89 X2 -> auto___def_89 X2). tauto. exact (rem_965 epsilon_mknows_current_p__type_24 X2).
Defined.

Remark rem_967 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> (auto___def_88 X1 /\ auto___def_89 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  cut (auto___def_88 X1). 2:apply (rem_964 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  cut (auto___def_89 X2). 2:apply (rem_966 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_968 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> auto___type_24 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  case (rem_967 epsilon_mknows_current_p__type_24 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_24 A1 A2. intros. apply trans___type_24_crypt_6;  tauto.
 clear  epsilon_mknows_current_p__type_24 A1 A2. tauto.
Defined.

Remark rem_969 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1:term, auto___def_24 X1 -> auto___def_24 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_970 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___def_24 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto___def_24 X1 -> auto___def_24 X1). tauto. exact (rem_969 epsilon_mknows_current_p__type_24 X1).
Defined.

Remark rem_971 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X2:term, auto___def_25 X2 -> auto___def_25 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_972 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___def_25 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto___def_25 X2 -> auto___def_25 X2). tauto. exact (rem_971 epsilon_mknows_current_p__type_24 X2).
Defined.

Remark rem_973 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> (auto___def_24 X1 /\ auto___def_25 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  cut (auto___def_24 X1). 2:apply (rem_970 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  cut (auto___def_25 X2). 2:apply (rem_972 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_974 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___type_24 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  case (rem_973 epsilon_mknows_current_p__type_24 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_24 A1 A2. intros. apply trans___type_24_crypt_7;  tauto.
 clear  epsilon_mknows_current_p__type_24 A1 A2. tauto.
Defined.

Remark rem_975 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1:term, auto___type_7 X1 -> auto___type_7 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_976 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto___type_7 X1 -> auto___type_7 X1). tauto. exact (rem_975 epsilon_mknows_current_p__type_24 X1).
Defined.

Remark rem_977 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X2:term, auto___def_44 X2 -> auto___def_44 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_978 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___def_44 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto___def_44 X2 -> auto___def_44 X2). tauto. exact (rem_977 epsilon_mknows_current_p__type_24 X2).
Defined.

Remark rem_979 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> (auto___type_7 X1 /\ auto___def_44 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  cut (auto___type_7 X1). 2:apply (rem_976 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  cut (auto___def_44 X2). 2:apply (rem_978 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_980 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___type_24 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  case (rem_979 epsilon_mknows_current_p__type_24 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_24 A1 A2. intros. apply trans___type_24_crypt_8;  tauto.
 clear  epsilon_mknows_current_p__type_24 A1 A2. tauto.
Defined.

Remark rem_981 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1:term, auto___def_84 X1 -> auto___def_84 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_982 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___def_85 X2 -> auto___def_84 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto___def_84 X1 -> auto___def_84 X1). tauto. exact (rem_981 epsilon_mknows_current_p__type_24 X1).
Defined.

Remark rem_983 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X2:term, auto___def_85 X2 -> auto___def_85 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_984 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___def_85 X2 -> auto___def_85 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto___def_85 X2 -> auto___def_85 X2). tauto. exact (rem_983 epsilon_mknows_current_p__type_24 X2).
Defined.

Remark rem_985 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___def_85 X2 -> (auto___def_84 X1 /\ auto___def_85 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  cut (auto___def_84 X1). 2:apply (rem_982 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  cut (auto___def_85 X2). 2:apply (rem_984 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_986 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___def_85 X2 -> auto___type_24 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  case (rem_985 epsilon_mknows_current_p__type_24 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_24 A1 A2. intros. apply trans___type_24_crypt_9;  tauto.
 clear  epsilon_mknows_current_p__type_24 A1 A2. tauto.
Defined.

Inductive or_9(H1 H2 H3 H4 H5 H6 H7 H8 H9:Prop) : Prop :=
    or_9_intro_1 : H1 -> (or_9 H1 H2 H3 H4 H5 H6 H7 H8 H9)
  | or_9_intro_2 : H2 -> (or_9 H1 H2 H3 H4 H5 H6 H7 H8 H9)
  | or_9_intro_3 : H3 -> (or_9 H1 H2 H3 H4 H5 H6 H7 H8 H9)
  | or_9_intro_4 : H4 -> (or_9 H1 H2 H3 H4 H5 H6 H7 H8 H9)
  | or_9_intro_5 : H5 -> (or_9 H1 H2 H3 H4 H5 H6 H7 H8 H9)
  | or_9_intro_6 : H6 -> (or_9 H1 H2 H3 H4 H5 H6 H7 H8 H9)
  | or_9_intro_7 : H7 -> (or_9 H1 H2 H3 H4 H5 H6 H7 H8 H9)
  | or_9_intro_8 : H8 -> (or_9 H1 H2 H3 H4 H5 H6 H7 H8 H9)
  | or_9_intro_9 : H9 -> (or_9 H1 H2 H3 H4 H5 H6 H7 H8 H9)
.

Remark rem_987 : forall X1 X2:term, auto_knows_current (crypt X1 X2) -> or_9
    (auto___def_17 X1 /\ auto___type_2 X2)
    (auto___def_36 X1 /\ auto___def_37 X2)
    (auto___def_21 X1 /\ auto___def_22 X2)
    (auto_knows_current X1 /\ auto_knows_current X2)
    (auto___type_22 X1 /\ auto___def_104 X2)
    (auto___def_88 X1 /\ auto___def_89 X2)
    (auto___def_24 X1 /\ auto___def_25 X2)
    (auto___type_7 X1 /\ auto___def_44 X2)
    (auto___def_84 X1 /\ auto___def_85 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_9_intro_1; tauto.
  intros. apply or_9_intro_2; tauto.
  intros. apply or_9_intro_3; tauto.
  intros. apply or_9_intro_4; tauto.
  intros. apply or_9_intro_5; tauto.
  intros. apply or_9_intro_6; tauto.
  intros. apply or_9_intro_7; tauto.
  intros. apply or_9_intro_8; tauto.
  intros. apply or_9_intro_9; tauto.
Qed.

Remark rem_988 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto_knows_current (crypt X1 X2) -> auto___type_24 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intro H. intros.
  elim (rem_987 X1 X2 H);  intros.
  apply (rem_938 epsilon_mknows_current_p__type_24 X1 X2);  tauto.
  apply (rem_944 epsilon_mknows_current_p__type_24 X1 X2);  tauto.
  apply (rem_950 epsilon_mknows_current_p__type_24 X1 X2);  tauto.
  apply (rem_956 epsilon_mknows_current_p__type_24 X1 X2);  tauto.
  apply (rem_962 epsilon_mknows_current_p__type_24 X1 X2);  tauto.
  apply (rem_968 epsilon_mknows_current_p__type_24 X1 X2);  tauto.
  apply (rem_974 epsilon_mknows_current_p__type_24 X1 X2);  tauto.
  apply (rem_980 epsilon_mknows_current_p__type_24 X1 X2);  tauto.
  apply (rem_986 epsilon_mknows_current_p__type_24 X1 X2);  tauto.
Defined.

Remark rem_989 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_24.  tauto.
Defined.

Remark rem_990 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> auto___type_24 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24.  case (rem_989 epsilon_mknows_current_p__type_24). clear  epsilon_mknows_current_p__type_24. intros. apply trans___type_24_bob_1;  tauto.
 clear  epsilon_mknows_current_p__type_24. tauto.
Defined.

Remark rem_991 : auto_knows_current bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_992 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> auto_knows_current bob -> auto___type_24 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intro H. intros.
  elim (rem_991 H);  intros.
  apply (rem_990 epsilon_mknows_current_p__type_24);  tauto.
Defined.

Remark rem_993 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___type_24 (noncea_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.  case (rem_989 epsilon_mknows_current_p__type_24). clear  epsilon_mknows_current_p__type_24. intros. apply trans___type_24_noncea_old_1;  tauto.
 clear  epsilon_mknows_current_p__type_24. tauto.
Defined.

Remark rem_994 : forall X1 X2:term, auto_knows_current (noncea_old X1 X2) -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_995 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto_knows_current (noncea_old X1 X2) -> auto___type_24 (noncea_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intro H. intros.
  elim (rem_994 X1 X2 H);  intros.
  apply (rem_993 epsilon_mknows_current_p__type_24 X1 X2);  tauto.
Defined.

Remark rem_996 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_951 epsilon_mknows_current_p__type_24 X1);  assumption.
  tauto.
Defined.

Remark rem_997 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1:term, auto_knows_current X1 -> auto___type_24 (p X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1. intros A1.
  case (rem_996 epsilon_mknows_current_p__type_24 X1 A1). clear  epsilon_mknows_current_p__type_24 A1. intros. apply trans___type_24_p_1;  tauto.
 clear  epsilon_mknows_current_p__type_24 A1. tauto.
Defined.

Remark rem_998 : forall X1:term, auto_knows_current (p X1) -> or_1
    (auto_knows_current X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_999 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1:term, auto_knows_current (p X1) -> auto___type_24 (p X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1. intro H. intros.
  elim (rem_998 X1 H);  intros.
  apply (rem_997 epsilon_mknows_current_p__type_24 X1);  tauto.
Defined.

Remark rem_1000 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___type_24 (passwd_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.  case (rem_989 epsilon_mknows_current_p__type_24). clear  epsilon_mknows_current_p__type_24. intros. apply trans___type_24_passwd_old_1;  tauto.
 clear  epsilon_mknows_current_p__type_24. tauto.
Defined.

Remark rem_1001 : forall X1 X2:term, auto_knows_current (passwd_old X1 X2) -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1002 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto_knows_current (passwd_old X1 X2) -> auto___type_24 (passwd_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intro H. intros.
  elim (rem_1001 X1 X2 H);  intros.
  apply (rem_1000 epsilon_mknows_current_p__type_24 X1 X2);  tauto.
Defined.

Remark rem_1003 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> auto___type_24 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24.  case (rem_989 epsilon_mknows_current_p__type_24). clear  epsilon_mknows_current_p__type_24. intros. apply trans___type_24_alice_1;  tauto.
 clear  epsilon_mknows_current_p__type_24. tauto.
Defined.

Remark rem_1004 : auto_knows_current alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1005 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> auto_knows_current alice -> auto___type_24 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intro H. intros.
  elim (rem_1004 H);  intros.
  apply (rem_1003 epsilon_mknows_current_p__type_24);  tauto.
Defined.

Remark rem_1006 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___type_24 (nonceb_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.  case (rem_989 epsilon_mknows_current_p__type_24). clear  epsilon_mknows_current_p__type_24. intros. apply trans___type_24_nonceb_old_1;  tauto.
 clear  epsilon_mknows_current_p__type_24. tauto.
Defined.

Remark rem_1007 : forall X1 X2:term, auto_knows_current (nonceb_old X1 X2) -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1008 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto_knows_current (nonceb_old X1 X2) -> auto___type_24 (nonceb_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intro H. intros.
  elim (rem_1007 X1 X2 H);  intros.
  apply (rem_1006 epsilon_mknows_current_p__type_24 X1 X2);  tauto.
Defined.

Remark rem_1009 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_24 (dec X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  case (rem_955 epsilon_mknows_current_p__type_24 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_24 A1 A2. intros. apply trans___type_24_dec_1;  tauto.
 clear  epsilon_mknows_current_p__type_24 A1 A2. tauto.
Defined.

Remark rem_1010 : forall X1 X2:term, auto_knows_current (dec X1 X2) -> or_1
    (auto_knows_current X1 /\ auto_knows_current X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1011 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto_knows_current (dec X1 X2) -> auto___type_24 (dec X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intro H. intros.
  elim (rem_1010 X1 X2 H);  intros.
  apply (rem_1009 epsilon_mknows_current_p__type_24 X1 X2);  tauto.
Defined.

Remark rem_1012 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1:term, auto___def_71 X1 -> auto___def_71 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1013 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto___def_71 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto___def_71 X1 -> auto___def_71 X1). tauto. exact (rem_1012 epsilon_mknows_current_p__type_24 X1).
Defined.

Remark rem_1014 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X2:term, auto___def_72 X2 -> auto___def_72 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1015 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto___def_72 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto___def_72 X2 -> auto___def_72 X2). tauto. exact (rem_1014 epsilon_mknows_current_p__type_24 X2).
Defined.

Remark rem_1016 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> (auto___def_71 X1 /\ auto___def_72 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  cut (auto___def_71 X1). 2:apply (rem_1013 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  cut (auto___def_72 X2). 2:apply (rem_1015 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1017 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto___type_24 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  case (rem_1016 epsilon_mknows_current_p__type_24 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_24 A1 A2. intros. apply trans___type_24_enc_1;  tauto.
 clear  epsilon_mknows_current_p__type_24 A1 A2. tauto.
Defined.

Remark rem_1018 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_24 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  case (rem_955 epsilon_mknows_current_p__type_24 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_24 A1 A2. intros. apply trans___type_24_enc_2;  tauto.
 clear  epsilon_mknows_current_p__type_24 A1 A2. tauto.
Defined.

Remark rem_1019 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1:term, auto___def_79 X1 -> auto___def_79 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1020 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_79 X1 -> auto___def_80 X2 -> auto___def_79 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto___def_79 X1 -> auto___def_79 X1). tauto. exact (rem_1019 epsilon_mknows_current_p__type_24 X1).
Defined.

Remark rem_1021 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X2:term, auto___def_80 X2 -> auto___def_80 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1022 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_79 X1 -> auto___def_80 X2 -> auto___def_80 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto___def_80 X2 -> auto___def_80 X2). tauto. exact (rem_1021 epsilon_mknows_current_p__type_24 X2).
Defined.

Remark rem_1023 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_79 X1 -> auto___def_80 X2 -> (auto___def_79 X1 /\ auto___def_80 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  cut (auto___def_79 X1). 2:apply (rem_1020 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  cut (auto___def_80 X2). 2:apply (rem_1022 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1024 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_79 X1 -> auto___def_80 X2 -> auto___type_24 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  case (rem_1023 epsilon_mknows_current_p__type_24 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_24 A1 A2. intros. apply trans___type_24_enc_3;  tauto.
 clear  epsilon_mknows_current_p__type_24 A1 A2. tauto.
Defined.

Remark rem_1025 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1:term, auto___def_75 X1 -> auto___def_75 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1026 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_75 X1 -> auto___def_76 X2 -> auto___def_75 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto___def_75 X1 -> auto___def_75 X1). tauto. exact (rem_1025 epsilon_mknows_current_p__type_24 X1).
Defined.

Remark rem_1027 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X2:term, auto___def_76 X2 -> auto___def_76 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1028 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_75 X1 -> auto___def_76 X2 -> auto___def_76 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto___def_76 X2 -> auto___def_76 X2). tauto. exact (rem_1027 epsilon_mknows_current_p__type_24 X2).
Defined.

Remark rem_1029 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_75 X1 -> auto___def_76 X2 -> (auto___def_75 X1 /\ auto___def_76 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  cut (auto___def_75 X1). 2:apply (rem_1026 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  cut (auto___def_76 X2). 2:apply (rem_1028 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1030 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_75 X1 -> auto___def_76 X2 -> auto___type_24 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  case (rem_1029 epsilon_mknows_current_p__type_24 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_24 A1 A2. intros. apply trans___type_24_enc_4;  tauto.
 clear  epsilon_mknows_current_p__type_24 A1 A2. tauto.
Defined.

Remark rem_1031 : forall X1 X2:term, auto_knows_current (enc X1 X2) -> or_4
    (auto___def_71 X1 /\ auto___def_72 X2)
    (auto_knows_current X1 /\ auto_knows_current X2)
    (auto___def_79 X1 /\ auto___def_80 X2)
    (auto___def_75 X1 /\ auto___def_76 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_4_intro_1; tauto.
  intros. apply or_4_intro_2; tauto.
  intros. apply or_4_intro_3; tauto.
  intros. apply or_4_intro_4; tauto.
Qed.

Remark rem_1032 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto_knows_current (enc X1 X2) -> auto___type_24 (enc X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intro H. intros.
  elim (rem_1031 X1 X2 H);  intros.
  apply (rem_1017 epsilon_mknows_current_p__type_24 X1 X2);  tauto.
  apply (rem_1018 epsilon_mknows_current_p__type_24 X1 X2);  tauto.
  apply (rem_1024 epsilon_mknows_current_p__type_24 X1 X2);  tauto.
  apply (rem_1030 epsilon_mknows_current_p__type_24 X1 X2);  tauto.
Defined.

Remark rem_1033 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_24 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  case (rem_955 epsilon_mknows_current_p__type_24 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_24 A1 A2. intros. apply trans___type_24_cons_1;  tauto.
 clear  epsilon_mknows_current_p__type_24 A1 A2. tauto.
Defined.

Remark rem_1034 : forall X1 X2:term, auto_knows_current (cons X1 X2) -> or_1
    (auto_knows_current X1 /\ auto_knows_current X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1035 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto_knows_current (cons X1 X2) -> auto___type_24 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intro H. intros.
  elim (rem_1034 X1 X2 H);  intros.
  apply (rem_1033 epsilon_mknows_current_p__type_24 X1 X2);  tauto.
Defined.

Remark rem_1036 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1:term, auto_knows_current X1 -> auto___type_24 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1. intros A1.
  case (rem_996 epsilon_mknows_current_p__type_24 X1 A1). clear  epsilon_mknows_current_p__type_24 A1. intros. apply trans___type_24_s_1;  tauto.
 clear  epsilon_mknows_current_p__type_24 A1. tauto.
Defined.

Remark rem_1037 : forall X1:term, auto_knows_current (s X1) -> or_1
    (auto_knows_current X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1038 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1:term, auto_knows_current (s X1) -> auto___type_24 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1. intro H. intros.
  elim (rem_1037 X1 H);  intros.
  apply (rem_1036 epsilon_mknows_current_p__type_24 X1);  tauto.
Defined.

Remark rem_1039 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> auto___type_24 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24.  case (rem_989 epsilon_mknows_current_p__type_24). clear  epsilon_mknows_current_p__type_24. intros. apply trans___type_24_i_1;  tauto.
 clear  epsilon_mknows_current_p__type_24. tauto.
Defined.

Remark rem_1040 : auto_knows_current i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1041 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> auto_knows_current i -> auto___type_24 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intro H. intros.
  elim (rem_1040 H);  intros.
  apply (rem_1039 epsilon_mknows_current_p__type_24);  tauto.
Defined.

Remark rem_1042 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> auto___type_24 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24.  case (rem_989 epsilon_mknows_current_p__type_24). clear  epsilon_mknows_current_p__type_24. intros. apply trans___type_24_nil_1;  tauto.
 clear  epsilon_mknows_current_p__type_24. tauto.
Defined.

Remark rem_1043 : auto_knows_current nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1044 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> auto_knows_current nil -> auto___type_24 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intro H. intros.
  elim (rem_1043 H);  intros.
  apply (rem_1042 epsilon_mknows_current_p__type_24);  tauto.
Defined.

Remark rem_1045 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> auto___type_24 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24.  case (rem_989 epsilon_mknows_current_p__type_24). clear  epsilon_mknows_current_p__type_24. intros. apply trans___type_24_server_1;  tauto.
 clear  epsilon_mknows_current_p__type_24. tauto.
Defined.

Remark rem_1046 : auto_knows_current server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1047 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> auto_knows_current server -> auto___type_24 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intro H. intros.
  elim (rem_1046 H);  intros.
  apply (rem_1045 epsilon_mknows_current_p__type_24);  tauto.
Defined.

Remark rem_1048 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1:term, auto___def_61 X1 -> auto___def_61 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1049 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto___def_61 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto___def_61 X1 -> auto___def_61 X1). tauto. exact (rem_1048 epsilon_mknows_current_p__type_24 X1).
Defined.

Remark rem_1050 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X2:term, auto___def_62 X2 -> auto___def_62 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1051 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto___def_62 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto___def_62 X2 -> auto___def_62 X2). tauto. exact (rem_1050 epsilon_mknows_current_p__type_24 X2).
Defined.

Remark rem_1052 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> (auto___def_61 X1 /\ auto___def_62 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  cut (auto___def_61 X1). 2:apply (rem_1049 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  cut (auto___def_62 X2). 2:apply (rem_1051 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1053 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto___type_24 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  case (rem_1052 epsilon_mknows_current_p__type_24 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_24 A1 A2. intros. apply trans___type_24_key_1;  tauto.
 clear  epsilon_mknows_current_p__type_24 A1 A2. tauto.
Defined.

Remark rem_1054 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1:term, auto___def_51 X1 -> auto___def_51 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1055 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto___def_51 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto___def_51 X1 -> auto___def_51 X1). tauto. exact (rem_1054 epsilon_mknows_current_p__type_24 X1).
Defined.

Remark rem_1056 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1057 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_1056 epsilon_mknows_current_p__type_24 X2).
Defined.

Remark rem_1058 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> (auto___def_51 X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  cut (auto___def_51 X1). 2:apply (rem_1055 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_1057 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1059 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto___type_24 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  case (rem_1058 epsilon_mknows_current_p__type_24 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_24 A1 A2. intros. apply trans___type_24_key_2;  tauto.
 clear  epsilon_mknows_current_p__type_24 A1 A2. tauto.
Defined.

Remark rem_1060 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1:term, auto___def_12 X1 -> auto___def_12 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1061 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_12 X1). tauto. exact (rem_1060 epsilon_mknows_current_p__type_24 X1).
Defined.

Remark rem_1062 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X2:term, auto___def_13 X2 -> auto___def_13 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1063 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_1062 epsilon_mknows_current_p__type_24 X2).
Defined.

Remark rem_1064 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> (auto___def_12 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  cut (auto___def_12 X1). 2:apply (rem_1061 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_1063 epsilon_mknows_current_p__type_24 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1065 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___type_24 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intros A1 A2.
  case (rem_1064 epsilon_mknows_current_p__type_24 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_24 A1 A2. intros. apply trans___type_24_key_3;  tauto.
 clear  epsilon_mknows_current_p__type_24 A1 A2. tauto.
Defined.

Remark rem_1066 : forall X1 X2:term, auto_knows_current (key X1 X2) -> or_3
    (auto___def_61 X1 /\ auto___def_62 X2)
    (auto___def_51 X1 /\ auto_agent X2)
    (auto___def_12 X1 /\ auto___def_13 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_1067 : (forall X:term, auto_knows_current X -> auto___type_24 X)
    -> forall X1 X2:term, auto_knows_current (key X1 X2) -> auto___type_24 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_24. intros X1 X2. intro H. intros.
  elim (rem_1066 X1 X2 H);  intros.
  apply (rem_1053 epsilon_mknows_current_p__type_24 X1 X2);  tauto.
  apply (rem_1059 epsilon_mknows_current_p__type_24 X1 X2);  tauto.
  apply (rem_1065 epsilon_mknows_current_p__type_24 X1 X2);  tauto.
Defined.

Remark rem_1068 : forall X1 X2:term, auto_knows_current (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1069 : forall X1 X2:term, auto_knows_current (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1070 : forall X1 X2:term, auto_knows_current (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1071 : forall X1 X2:term, auto_knows_current (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1072 : auto_knows_current pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1073 : forall X1 X2:term, auto_knows_current (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1074 : auto_knows_current prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1075 : auto_knows_current sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1076 : forall X1 X2:term, auto_knows_current (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1077 : forall X1 X2:term, auto_knows_current (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1078 : forall X1:term, auto_knows_current X1 -> auto___type_24 X1. (* Induct. *)
Proof.
  fix epsilon_mknows_current_p__type_24 1.
  intro X. case X.
  exact (rem_1005 epsilon_mknows_current_p__type_24 ).
  exact (rem_992 epsilon_mknows_current_p__type_24 ).
  intros X1 X2;  exact (rem_1035 epsilon_mknows_current_p__type_24 X1 X2).
  intros X1 X2;  exact (rem_988 epsilon_mknows_current_p__type_24 X1 X2).
  intros X1 X2;  exact (rem_1011 epsilon_mknows_current_p__type_24 X1 X2).
  intros X1 X2;  exact (rem_1032 epsilon_mknows_current_p__type_24 X1 X2).
  exact (rem_1041 epsilon_mknows_current_p__type_24 ).
  intros X1 X2;  exact (rem_1067 epsilon_mknows_current_p__type_24 X1 X2).
  exact (rem_1044 epsilon_mknows_current_p__type_24 ).
  intros X1 X2. intro H. elim (rem_1077 X1 X2 H).
  intros X1 X2;  exact (rem_995 epsilon_mknows_current_p__type_24 X1 X2).
  intros X1 X2. intro H. elim (rem_1068 X1 X2 H).
  intros X1 X2;  exact (rem_1008 epsilon_mknows_current_p__type_24 X1 X2).
  intros X1;  exact (rem_999 epsilon_mknows_current_p__type_24 X1).
  intros X1 X2. intro H. elim (rem_1073 X1 X2 H).
  intros X1 X2;  exact (rem_1002 epsilon_mknows_current_p__type_24 X1 X2).
   intro H. elim (rem_1074  H).
   intro H. elim (rem_1072  H).
  intros X1 X2. intro H. elim (rem_1071 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1070 X1 X2 H).
  intros X1;  exact (rem_1038 epsilon_mknows_current_p__type_24 X1).
  exact (rem_1047 epsilon_mknows_current_p__type_24 ).
  intros X1 X2. intro H. elim (rem_1076 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1069 X1 X2 H).
   intro H. elim (rem_1075  H).
Qed.

Remark rem_1079 : forall X1 X2:term, auto___def_107 X2 X1 -> auto___type_24 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_355 X2 X1 H);  intros.
  apply (rem_1078 X1);  tauto.
Qed.

Remark rem_1080 : auto___def_119 sym. (* Deduce positive atom. *)
Proof.
   case rem_855. intros. apply trans___def_119_sym_1;  tauto.
 tauto.
Qed.

Remark rem_1081 : (forall X:term, auto_agent X -> auto___type_14 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p__type_14.  tauto.
Defined.

Remark rem_1082 : (forall X:term, auto_agent X -> auto___type_14 X)
    -> auto___type_14 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_14.  case (rem_1081 epsilon_magent_p__type_14). clear  epsilon_magent_p__type_14. intros. apply trans___type_14_bob_1;  tauto.
 clear  epsilon_magent_p__type_14. tauto.
Defined.

Remark rem_1083 : auto_agent bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1084 : (forall X:term, auto_agent X -> auto___type_14 X)
    -> auto_agent bob -> auto___type_14 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_14. intro H. intros.
  elim (rem_1083 H);  intros.
  apply (rem_1082 epsilon_magent_p__type_14);  tauto.
Defined.

Remark rem_1085 : (forall X:term, auto_agent X -> auto___type_14 X)
    -> auto___type_14 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_14.  case (rem_1081 epsilon_magent_p__type_14). clear  epsilon_magent_p__type_14. intros. apply trans___type_14_alice_1;  tauto.
 clear  epsilon_magent_p__type_14. tauto.
Defined.

Remark rem_1086 : auto_agent alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1087 : (forall X:term, auto_agent X -> auto___type_14 X)
    -> auto_agent alice -> auto___type_14 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_14. intro H. intros.
  elim (rem_1086 H);  intros.
  apply (rem_1085 epsilon_magent_p__type_14);  tauto.
Defined.

Remark rem_1088 : (forall X:term, auto_agent X -> auto___type_14 X)
    -> auto___type_14 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_14.  case (rem_1081 epsilon_magent_p__type_14). clear  epsilon_magent_p__type_14. intros. apply trans___type_14_i_1;  tauto.
 clear  epsilon_magent_p__type_14. tauto.
Defined.

Remark rem_1089 : auto_agent i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1090 : (forall X:term, auto_agent X -> auto___type_14 X)
    -> auto_agent i -> auto___type_14 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_14. intro H. intros.
  elim (rem_1089 H);  intros.
  apply (rem_1088 epsilon_magent_p__type_14);  tauto.
Defined.

Remark rem_1091 : (forall X:term, auto_agent X -> auto___type_14 X)
    -> auto___type_14 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_14.  case (rem_1081 epsilon_magent_p__type_14). clear  epsilon_magent_p__type_14. intros. apply trans___type_14_server_1;  tauto.
 clear  epsilon_magent_p__type_14. tauto.
Defined.

Remark rem_1092 : auto_agent server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1093 : (forall X:term, auto_agent X -> auto___type_14 X)
    -> auto_agent server -> auto___type_14 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_14. intro H. intros.
  elim (rem_1092 H);  intros.
  apply (rem_1091 epsilon_magent_p__type_14);  tauto.
Defined.

Remark rem_1094 : forall X1 X2:term, auto_agent (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1095 : forall X1 X2:term, auto_agent (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1096 : forall X1 X2:term, auto_agent (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1097 : forall X1 X2:term, auto_agent (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1098 : forall X1 X2:term, auto_agent (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1099 : forall X1 X2:term, auto_agent (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1100 : forall X1:term, auto_agent (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1101 : auto_agent pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1102 : forall X1 X2:term, auto_agent (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1103 : forall X1 X2:term, auto_agent (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1104 : auto_agent prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1105 : forall X1 X2:term, auto_agent (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1106 : forall X1 X2:term, auto_agent (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1107 : forall X1 X2:term, auto_agent (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1108 : forall X1 X2:term, auto_agent (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1109 : forall X1:term, auto_agent (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1110 : auto_agent sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1111 : forall X1 X2:term, auto_agent (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1112 : auto_agent nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1113 : forall X1 X2:term, auto_agent (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1114 : forall X1 X2:term, auto_agent (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1115 : forall X1:term, auto_agent X1 -> auto___type_14 X1. (* Induct. *)
Proof.
  fix epsilon_magent_p__type_14 1.
  intro X. case X.
  exact (rem_1087 epsilon_magent_p__type_14 ).
  exact (rem_1084 epsilon_magent_p__type_14 ).
  intros X1 X2. intro H. elim (rem_1108 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1094 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1106 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1107 X1 X2 H).
  exact (rem_1090 epsilon_magent_p__type_14 ).
  intros X1 X2. intro H. elim (rem_1114 X1 X2 H).
   intro H. elim (rem_1112  H).
  intros X1 X2. intro H. elim (rem_1113 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1097 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1095 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1105 X1 X2 H).
  intros X1. intro H. elim (rem_1100 X1 H).
  intros X1 X2. intro H. elim (rem_1103 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1102 X1 X2 H).
   intro H. elim (rem_1104  H).
   intro H. elim (rem_1101  H).
  intros X1 X2. intro H. elim (rem_1099 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1098 X1 X2 H).
  intros X1. intro H. elim (rem_1109 X1 H).
  exact (rem_1093 epsilon_magent_p__type_14 ).
  intros X1 X2. intro H. elim (rem_1111 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1096 X1 X2 H).
   intro H. elim (rem_1110  H).
Qed.

Remark rem_1116 : forall X1 X2:term, auto_agent X1 -> auto_knows_old X2 -> auto_testable_old X2 -> auto___type_14 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_agent X1 -> auto___type_14 X1). tauto. exact (rem_1115 X1).
Qed.

Remark rem_1117 : forall X1 X2:term, auto___def_1 X1 X2 -> or_1
    (auto_agent X1 /\ auto_knows_old X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1118 : forall X1 X2:term, auto___def_1 X1 X2 -> auto_testable_old X2 -> auto___type_14 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_1117 X1 X2 H);  intros.
  apply (rem_1116 X1 X2);  tauto.
Qed.

Remark rem_1119 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1:term, auto___def_17 X1 -> auto___def_17 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1120 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_17 X1 -> auto___type_2 X2 -> auto___def_17 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto___def_17 X1 -> auto___def_17 X1). tauto. exact (rem_1119 epsilon_mknows_current_p__type_18 X1).
Defined.

Remark rem_1121 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X2:term, auto___type_2 X2 -> auto___type_2 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1122 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_17 X1 -> auto___type_2 X2 -> auto___type_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto___type_2 X2 -> auto___type_2 X2). tauto. exact (rem_1121 epsilon_mknows_current_p__type_18 X2).
Defined.

Remark rem_1123 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_17 X1 -> auto___type_2 X2 -> (auto___def_17 X1 /\ auto___type_2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  cut (auto___def_17 X1). 2:apply (rem_1120 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  cut (auto___type_2 X2). 2:apply (rem_1122 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1124 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_17 X1 -> auto___type_2 X2 -> auto___type_18 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  case (rem_1123 epsilon_mknows_current_p__type_18 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_18 A1 A2. intros. apply trans___type_18_crypt_1;  tauto.
 clear  epsilon_mknows_current_p__type_18 A1 A2. tauto.
Defined.

Remark rem_1125 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1:term, auto___def_36 X1 -> auto___def_36 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1126 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_36 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto___def_36 X1 -> auto___def_36 X1). tauto. exact (rem_1125 epsilon_mknows_current_p__type_18 X1).
Defined.

Remark rem_1127 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X2:term, auto___def_37 X2 -> auto___def_37 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1128 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_37 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto___def_37 X2 -> auto___def_37 X2). tauto. exact (rem_1127 epsilon_mknows_current_p__type_18 X2).
Defined.

Remark rem_1129 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> (auto___def_36 X1 /\ auto___def_37 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  cut (auto___def_36 X1). 2:apply (rem_1126 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  cut (auto___def_37 X2). 2:apply (rem_1128 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1130 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_18 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  case (rem_1129 epsilon_mknows_current_p__type_18 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_18 A1 A2. intros. apply trans___type_18_crypt_2;  tauto.
 clear  epsilon_mknows_current_p__type_18 A1 A2. tauto.
Defined.

Remark rem_1131 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1:term, auto___def_21 X1 -> auto___def_21 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1132 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_21 X1 -> auto___def_22 X2 -> auto___def_21 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto___def_21 X1 -> auto___def_21 X1). tauto. exact (rem_1131 epsilon_mknows_current_p__type_18 X1).
Defined.

Remark rem_1133 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X2:term, auto___def_22 X2 -> auto___def_22 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1134 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_21 X1 -> auto___def_22 X2 -> auto___def_22 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto___def_22 X2 -> auto___def_22 X2). tauto. exact (rem_1133 epsilon_mknows_current_p__type_18 X2).
Defined.

Remark rem_1135 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_21 X1 -> auto___def_22 X2 -> (auto___def_21 X1 /\ auto___def_22 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  cut (auto___def_21 X1). 2:apply (rem_1132 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  cut (auto___def_22 X2). 2:apply (rem_1134 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1136 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_21 X1 -> auto___def_22 X2 -> auto___type_18 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  case (rem_1135 epsilon_mknows_current_p__type_18 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_18 A1 A2. intros. apply trans___type_18_crypt_3;  tauto.
 clear  epsilon_mknows_current_p__type_18 A1 A2. tauto.
Defined.

Remark rem_1137 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1138 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_1137 epsilon_mknows_current_p__type_18 X1).
Defined.

Remark rem_1139 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X2:term, auto_knows_current X2 -> auto_knows_current X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1140 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_1139 epsilon_mknows_current_p__type_18 X2).
Defined.

Remark rem_1141 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_1138 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1140 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1142 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_18 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  case (rem_1141 epsilon_mknows_current_p__type_18 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_18 A1 A2. intros. apply trans___type_18_crypt_4;  tauto.
 clear  epsilon_mknows_current_p__type_18 A1 A2. tauto.
Defined.

Remark rem_1143 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1:term, auto___type_22 X1 -> auto___type_22 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1144 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___type_22 X1 -> auto___def_104 X2 -> auto___type_22 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto___type_22 X1 -> auto___type_22 X1). tauto. exact (rem_1143 epsilon_mknows_current_p__type_18 X1).
Defined.

Remark rem_1145 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X2:term, auto___def_104 X2 -> auto___def_104 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1146 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___type_22 X1 -> auto___def_104 X2 -> auto___def_104 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto___def_104 X2 -> auto___def_104 X2). tauto. exact (rem_1145 epsilon_mknows_current_p__type_18 X2).
Defined.

Remark rem_1147 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___type_22 X1 -> auto___def_104 X2 -> (auto___type_22 X1 /\ auto___def_104 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  cut (auto___type_22 X1). 2:apply (rem_1144 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  cut (auto___def_104 X2). 2:apply (rem_1146 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1148 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___type_22 X1 -> auto___def_104 X2 -> auto___type_18 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  case (rem_1147 epsilon_mknows_current_p__type_18 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_18 A1 A2. intros. apply trans___type_18_crypt_5;  tauto.
 clear  epsilon_mknows_current_p__type_18 A1 A2. tauto.
Defined.

Remark rem_1149 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1:term, auto___def_88 X1 -> auto___def_88 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1150 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> auto___def_88 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto___def_88 X1 -> auto___def_88 X1). tauto. exact (rem_1149 epsilon_mknows_current_p__type_18 X1).
Defined.

Remark rem_1151 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X2:term, auto___def_89 X2 -> auto___def_89 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1152 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> auto___def_89 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto___def_89 X2 -> auto___def_89 X2). tauto. exact (rem_1151 epsilon_mknows_current_p__type_18 X2).
Defined.

Remark rem_1153 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> (auto___def_88 X1 /\ auto___def_89 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  cut (auto___def_88 X1). 2:apply (rem_1150 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  cut (auto___def_89 X2). 2:apply (rem_1152 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1154 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> auto___type_18 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  case (rem_1153 epsilon_mknows_current_p__type_18 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_18 A1 A2. intros. apply trans___type_18_crypt_6;  tauto.
 clear  epsilon_mknows_current_p__type_18 A1 A2. tauto.
Defined.

Remark rem_1155 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1:term, auto___def_24 X1 -> auto___def_24 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1156 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___def_24 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto___def_24 X1 -> auto___def_24 X1). tauto. exact (rem_1155 epsilon_mknows_current_p__type_18 X1).
Defined.

Remark rem_1157 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X2:term, auto___def_25 X2 -> auto___def_25 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1158 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___def_25 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto___def_25 X2 -> auto___def_25 X2). tauto. exact (rem_1157 epsilon_mknows_current_p__type_18 X2).
Defined.

Remark rem_1159 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> (auto___def_24 X1 /\ auto___def_25 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  cut (auto___def_24 X1). 2:apply (rem_1156 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  cut (auto___def_25 X2). 2:apply (rem_1158 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1160 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___type_18 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  case (rem_1159 epsilon_mknows_current_p__type_18 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_18 A1 A2. intros. apply trans___type_18_crypt_7;  tauto.
 clear  epsilon_mknows_current_p__type_18 A1 A2. tauto.
Defined.

Remark rem_1161 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1:term, auto___type_7 X1 -> auto___type_7 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1162 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto___type_7 X1 -> auto___type_7 X1). tauto. exact (rem_1161 epsilon_mknows_current_p__type_18 X1).
Defined.

Remark rem_1163 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X2:term, auto___def_44 X2 -> auto___def_44 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1164 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___def_44 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto___def_44 X2 -> auto___def_44 X2). tauto. exact (rem_1163 epsilon_mknows_current_p__type_18 X2).
Defined.

Remark rem_1165 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> (auto___type_7 X1 /\ auto___def_44 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  cut (auto___type_7 X1). 2:apply (rem_1162 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  cut (auto___def_44 X2). 2:apply (rem_1164 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1166 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___type_18 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  case (rem_1165 epsilon_mknows_current_p__type_18 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_18 A1 A2. intros. apply trans___type_18_crypt_8;  tauto.
 clear  epsilon_mknows_current_p__type_18 A1 A2. tauto.
Defined.

Remark rem_1167 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1:term, auto___def_84 X1 -> auto___def_84 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1168 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___def_85 X2 -> auto___def_84 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto___def_84 X1 -> auto___def_84 X1). tauto. exact (rem_1167 epsilon_mknows_current_p__type_18 X1).
Defined.

Remark rem_1169 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X2:term, auto___def_85 X2 -> auto___def_85 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1170 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___def_85 X2 -> auto___def_85 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto___def_85 X2 -> auto___def_85 X2). tauto. exact (rem_1169 epsilon_mknows_current_p__type_18 X2).
Defined.

Remark rem_1171 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___def_85 X2 -> (auto___def_84 X1 /\ auto___def_85 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  cut (auto___def_84 X1). 2:apply (rem_1168 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  cut (auto___def_85 X2). 2:apply (rem_1170 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1172 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___def_85 X2 -> auto___type_18 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  case (rem_1171 epsilon_mknows_current_p__type_18 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_18 A1 A2. intros. apply trans___type_18_crypt_9;  tauto.
 clear  epsilon_mknows_current_p__type_18 A1 A2. tauto.
Defined.

Remark rem_1173 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto_knows_current (crypt X1 X2) -> auto___type_18 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intro H. intros.
  elim (rem_987 X1 X2 H);  intros.
  apply (rem_1124 epsilon_mknows_current_p__type_18 X1 X2);  tauto.
  apply (rem_1130 epsilon_mknows_current_p__type_18 X1 X2);  tauto.
  apply (rem_1136 epsilon_mknows_current_p__type_18 X1 X2);  tauto.
  apply (rem_1142 epsilon_mknows_current_p__type_18 X1 X2);  tauto.
  apply (rem_1148 epsilon_mknows_current_p__type_18 X1 X2);  tauto.
  apply (rem_1154 epsilon_mknows_current_p__type_18 X1 X2);  tauto.
  apply (rem_1160 epsilon_mknows_current_p__type_18 X1 X2);  tauto.
  apply (rem_1166 epsilon_mknows_current_p__type_18 X1 X2);  tauto.
  apply (rem_1172 epsilon_mknows_current_p__type_18 X1 X2);  tauto.
Defined.

Remark rem_1174 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_18.  tauto.
Defined.

Remark rem_1175 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> auto___type_18 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18.  case (rem_1174 epsilon_mknows_current_p__type_18). clear  epsilon_mknows_current_p__type_18. intros. apply trans___type_18_bob_1;  tauto.
 clear  epsilon_mknows_current_p__type_18. tauto.
Defined.

Remark rem_1176 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> auto_knows_current bob -> auto___type_18 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intro H. intros.
  elim (rem_991 H);  intros.
  apply (rem_1175 epsilon_mknows_current_p__type_18);  tauto.
Defined.

Remark rem_1177 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___type_18 (noncea_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.  case (rem_1174 epsilon_mknows_current_p__type_18). clear  epsilon_mknows_current_p__type_18. intros. apply trans___type_18_noncea_old_1;  tauto.
 clear  epsilon_mknows_current_p__type_18. tauto.
Defined.

Remark rem_1178 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto_knows_current (noncea_old X1 X2) -> auto___type_18 (noncea_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intro H. intros.
  elim (rem_994 X1 X2 H);  intros.
  apply (rem_1177 epsilon_mknows_current_p__type_18 X1 X2);  tauto.
Defined.

Remark rem_1179 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_1137 epsilon_mknows_current_p__type_18 X1);  assumption.
  tauto.
Defined.

Remark rem_1180 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1:term, auto_knows_current X1 -> auto___type_18 (p X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1. intros A1.
  case (rem_1179 epsilon_mknows_current_p__type_18 X1 A1). clear  epsilon_mknows_current_p__type_18 A1. intros. apply trans___type_18_p_1;  tauto.
 clear  epsilon_mknows_current_p__type_18 A1. tauto.
Defined.

Remark rem_1181 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1:term, auto_knows_current (p X1) -> auto___type_18 (p X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1. intro H. intros.
  elim (rem_998 X1 H);  intros.
  apply (rem_1180 epsilon_mknows_current_p__type_18 X1);  tauto.
Defined.

Remark rem_1182 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___type_18 (passwd_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.  case (rem_1174 epsilon_mknows_current_p__type_18). clear  epsilon_mknows_current_p__type_18. intros. apply trans___type_18_passwd_old_1;  tauto.
 clear  epsilon_mknows_current_p__type_18. tauto.
Defined.

Remark rem_1183 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto_knows_current (passwd_old X1 X2) -> auto___type_18 (passwd_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intro H. intros.
  elim (rem_1001 X1 X2 H);  intros.
  apply (rem_1182 epsilon_mknows_current_p__type_18 X1 X2);  tauto.
Defined.

Remark rem_1184 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> auto___type_18 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18.  case (rem_1174 epsilon_mknows_current_p__type_18). clear  epsilon_mknows_current_p__type_18. intros. apply trans___type_18_alice_1;  tauto.
 clear  epsilon_mknows_current_p__type_18. tauto.
Defined.

Remark rem_1185 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> auto_knows_current alice -> auto___type_18 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intro H. intros.
  elim (rem_1004 H);  intros.
  apply (rem_1184 epsilon_mknows_current_p__type_18);  tauto.
Defined.

Remark rem_1186 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___type_18 (nonceb_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.  case (rem_1174 epsilon_mknows_current_p__type_18). clear  epsilon_mknows_current_p__type_18. intros. apply trans___type_18_nonceb_old_1;  tauto.
 clear  epsilon_mknows_current_p__type_18. tauto.
Defined.

Remark rem_1187 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto_knows_current (nonceb_old X1 X2) -> auto___type_18 (nonceb_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intro H. intros.
  elim (rem_1007 X1 X2 H);  intros.
  apply (rem_1186 epsilon_mknows_current_p__type_18 X1 X2);  tauto.
Defined.

Remark rem_1188 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_18 (dec X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  case (rem_1141 epsilon_mknows_current_p__type_18 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_18 A1 A2. intros. apply trans___type_18_dec_1;  tauto.
 clear  epsilon_mknows_current_p__type_18 A1 A2. tauto.
Defined.

Remark rem_1189 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto_knows_current (dec X1 X2) -> auto___type_18 (dec X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intro H. intros.
  elim (rem_1010 X1 X2 H);  intros.
  apply (rem_1188 epsilon_mknows_current_p__type_18 X1 X2);  tauto.
Defined.

Remark rem_1190 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1:term, auto___def_71 X1 -> auto___def_71 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1191 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto___def_71 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto___def_71 X1 -> auto___def_71 X1). tauto. exact (rem_1190 epsilon_mknows_current_p__type_18 X1).
Defined.

Remark rem_1192 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X2:term, auto___def_72 X2 -> auto___def_72 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1193 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto___def_72 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto___def_72 X2 -> auto___def_72 X2). tauto. exact (rem_1192 epsilon_mknows_current_p__type_18 X2).
Defined.

Remark rem_1194 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> (auto___def_71 X1 /\ auto___def_72 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  cut (auto___def_71 X1). 2:apply (rem_1191 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  cut (auto___def_72 X2). 2:apply (rem_1193 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1195 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto___type_18 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  case (rem_1194 epsilon_mknows_current_p__type_18 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_18 A1 A2. intros. apply trans___type_18_enc_1;  tauto.
 clear  epsilon_mknows_current_p__type_18 A1 A2. tauto.
Defined.

Remark rem_1196 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_18 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  case (rem_1141 epsilon_mknows_current_p__type_18 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_18 A1 A2. intros. apply trans___type_18_enc_2;  tauto.
 clear  epsilon_mknows_current_p__type_18 A1 A2. tauto.
Defined.

Remark rem_1197 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1:term, auto___def_79 X1 -> auto___def_79 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1198 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_79 X1 -> auto___def_80 X2 -> auto___def_79 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto___def_79 X1 -> auto___def_79 X1). tauto. exact (rem_1197 epsilon_mknows_current_p__type_18 X1).
Defined.

Remark rem_1199 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X2:term, auto___def_80 X2 -> auto___def_80 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1200 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_79 X1 -> auto___def_80 X2 -> auto___def_80 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto___def_80 X2 -> auto___def_80 X2). tauto. exact (rem_1199 epsilon_mknows_current_p__type_18 X2).
Defined.

Remark rem_1201 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_79 X1 -> auto___def_80 X2 -> (auto___def_79 X1 /\ auto___def_80 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  cut (auto___def_79 X1). 2:apply (rem_1198 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  cut (auto___def_80 X2). 2:apply (rem_1200 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1202 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_79 X1 -> auto___def_80 X2 -> auto___type_18 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  case (rem_1201 epsilon_mknows_current_p__type_18 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_18 A1 A2. intros. apply trans___type_18_enc_3;  tauto.
 clear  epsilon_mknows_current_p__type_18 A1 A2. tauto.
Defined.

Remark rem_1203 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1:term, auto___def_75 X1 -> auto___def_75 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1204 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_75 X1 -> auto___def_76 X2 -> auto___def_75 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto___def_75 X1 -> auto___def_75 X1). tauto. exact (rem_1203 epsilon_mknows_current_p__type_18 X1).
Defined.

Remark rem_1205 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X2:term, auto___def_76 X2 -> auto___def_76 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1206 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_75 X1 -> auto___def_76 X2 -> auto___def_76 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto___def_76 X2 -> auto___def_76 X2). tauto. exact (rem_1205 epsilon_mknows_current_p__type_18 X2).
Defined.

Remark rem_1207 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_75 X1 -> auto___def_76 X2 -> (auto___def_75 X1 /\ auto___def_76 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  cut (auto___def_75 X1). 2:apply (rem_1204 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  cut (auto___def_76 X2). 2:apply (rem_1206 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1208 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_75 X1 -> auto___def_76 X2 -> auto___type_18 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  case (rem_1207 epsilon_mknows_current_p__type_18 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_18 A1 A2. intros. apply trans___type_18_enc_4;  tauto.
 clear  epsilon_mknows_current_p__type_18 A1 A2. tauto.
Defined.

Remark rem_1209 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto_knows_current (enc X1 X2) -> auto___type_18 (enc X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intro H. intros.
  elim (rem_1031 X1 X2 H);  intros.
  apply (rem_1195 epsilon_mknows_current_p__type_18 X1 X2);  tauto.
  apply (rem_1196 epsilon_mknows_current_p__type_18 X1 X2);  tauto.
  apply (rem_1202 epsilon_mknows_current_p__type_18 X1 X2);  tauto.
  apply (rem_1208 epsilon_mknows_current_p__type_18 X1 X2);  tauto.
Defined.

Remark rem_1210 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_18 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  case (rem_1141 epsilon_mknows_current_p__type_18 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_18 A1 A2. intros. apply trans___type_18_cons_1;  tauto.
 clear  epsilon_mknows_current_p__type_18 A1 A2. tauto.
Defined.

Remark rem_1211 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto_knows_current (cons X1 X2) -> auto___type_18 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intro H. intros.
  elim (rem_1034 X1 X2 H);  intros.
  apply (rem_1210 epsilon_mknows_current_p__type_18 X1 X2);  tauto.
Defined.

Remark rem_1212 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1:term, auto_knows_current X1 -> auto___type_18 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1. intros A1.
  case (rem_1179 epsilon_mknows_current_p__type_18 X1 A1). clear  epsilon_mknows_current_p__type_18 A1. intros. apply trans___type_18_s_1;  tauto.
 clear  epsilon_mknows_current_p__type_18 A1. tauto.
Defined.

Remark rem_1213 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1:term, auto_knows_current (s X1) -> auto___type_18 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1. intro H. intros.
  elim (rem_1037 X1 H);  intros.
  apply (rem_1212 epsilon_mknows_current_p__type_18 X1);  tauto.
Defined.

Remark rem_1214 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> auto___type_18 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18.  case (rem_1174 epsilon_mknows_current_p__type_18). clear  epsilon_mknows_current_p__type_18. intros. apply trans___type_18_i_1;  tauto.
 clear  epsilon_mknows_current_p__type_18. tauto.
Defined.

Remark rem_1215 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> auto_knows_current i -> auto___type_18 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intro H. intros.
  elim (rem_1040 H);  intros.
  apply (rem_1214 epsilon_mknows_current_p__type_18);  tauto.
Defined.

Remark rem_1216 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> auto___type_18 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18.  case (rem_1174 epsilon_mknows_current_p__type_18). clear  epsilon_mknows_current_p__type_18. intros. apply trans___type_18_nil_1;  tauto.
 clear  epsilon_mknows_current_p__type_18. tauto.
Defined.

Remark rem_1217 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> auto_knows_current nil -> auto___type_18 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intro H. intros.
  elim (rem_1043 H);  intros.
  apply (rem_1216 epsilon_mknows_current_p__type_18);  tauto.
Defined.

Remark rem_1218 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> auto___type_18 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18.  case (rem_1174 epsilon_mknows_current_p__type_18). clear  epsilon_mknows_current_p__type_18. intros. apply trans___type_18_server_1;  tauto.
 clear  epsilon_mknows_current_p__type_18. tauto.
Defined.

Remark rem_1219 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> auto_knows_current server -> auto___type_18 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intro H. intros.
  elim (rem_1046 H);  intros.
  apply (rem_1218 epsilon_mknows_current_p__type_18);  tauto.
Defined.

Remark rem_1220 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1:term, auto___def_61 X1 -> auto___def_61 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1221 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto___def_61 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto___def_61 X1 -> auto___def_61 X1). tauto. exact (rem_1220 epsilon_mknows_current_p__type_18 X1).
Defined.

Remark rem_1222 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X2:term, auto___def_62 X2 -> auto___def_62 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1223 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto___def_62 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto___def_62 X2 -> auto___def_62 X2). tauto. exact (rem_1222 epsilon_mknows_current_p__type_18 X2).
Defined.

Remark rem_1224 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> (auto___def_61 X1 /\ auto___def_62 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  cut (auto___def_61 X1). 2:apply (rem_1221 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  cut (auto___def_62 X2). 2:apply (rem_1223 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1225 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto___type_18 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  case (rem_1224 epsilon_mknows_current_p__type_18 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_18 A1 A2. intros. apply trans___type_18_key_1;  tauto.
 clear  epsilon_mknows_current_p__type_18 A1 A2. tauto.
Defined.

Remark rem_1226 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1:term, auto___def_51 X1 -> auto___def_51 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1227 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto___def_51 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto___def_51 X1 -> auto___def_51 X1). tauto. exact (rem_1226 epsilon_mknows_current_p__type_18 X1).
Defined.

Remark rem_1228 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1229 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_1228 epsilon_mknows_current_p__type_18 X2).
Defined.

Remark rem_1230 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> (auto___def_51 X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  cut (auto___def_51 X1). 2:apply (rem_1227 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_1229 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1231 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto___type_18 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  case (rem_1230 epsilon_mknows_current_p__type_18 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_18 A1 A2. intros. apply trans___type_18_key_2;  tauto.
 clear  epsilon_mknows_current_p__type_18 A1 A2. tauto.
Defined.

Remark rem_1232 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1:term, auto___def_12 X1 -> auto___def_12 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1233 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_12 X1). tauto. exact (rem_1232 epsilon_mknows_current_p__type_18 X1).
Defined.

Remark rem_1234 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X2:term, auto___def_13 X2 -> auto___def_13 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1235 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_1234 epsilon_mknows_current_p__type_18 X2).
Defined.

Remark rem_1236 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> (auto___def_12 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  cut (auto___def_12 X1). 2:apply (rem_1233 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_1235 epsilon_mknows_current_p__type_18 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1237 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___type_18 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intros A1 A2.
  case (rem_1236 epsilon_mknows_current_p__type_18 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_18 A1 A2. intros. apply trans___type_18_key_3;  tauto.
 clear  epsilon_mknows_current_p__type_18 A1 A2. tauto.
Defined.

Remark rem_1238 : (forall X:term, auto_knows_current X -> auto___type_18 X)
    -> forall X1 X2:term, auto_knows_current (key X1 X2) -> auto___type_18 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_18. intros X1 X2. intro H. intros.
  elim (rem_1066 X1 X2 H);  intros.
  apply (rem_1225 epsilon_mknows_current_p__type_18 X1 X2);  tauto.
  apply (rem_1231 epsilon_mknows_current_p__type_18 X1 X2);  tauto.
  apply (rem_1237 epsilon_mknows_current_p__type_18 X1 X2);  tauto.
Defined.

Remark rem_1239 : forall X1:term, auto_knows_current X1 -> auto___type_18 X1. (* Induct. *)
Proof.
  fix epsilon_mknows_current_p__type_18 1.
  intro X. case X.
  exact (rem_1185 epsilon_mknows_current_p__type_18 ).
  exact (rem_1176 epsilon_mknows_current_p__type_18 ).
  intros X1 X2;  exact (rem_1211 epsilon_mknows_current_p__type_18 X1 X2).
  intros X1 X2;  exact (rem_1173 epsilon_mknows_current_p__type_18 X1 X2).
  intros X1 X2;  exact (rem_1189 epsilon_mknows_current_p__type_18 X1 X2).
  intros X1 X2;  exact (rem_1209 epsilon_mknows_current_p__type_18 X1 X2).
  exact (rem_1215 epsilon_mknows_current_p__type_18 ).
  intros X1 X2;  exact (rem_1238 epsilon_mknows_current_p__type_18 X1 X2).
  exact (rem_1217 epsilon_mknows_current_p__type_18 ).
  intros X1 X2. intro H. elim (rem_1077 X1 X2 H).
  intros X1 X2;  exact (rem_1178 epsilon_mknows_current_p__type_18 X1 X2).
  intros X1 X2. intro H. elim (rem_1068 X1 X2 H).
  intros X1 X2;  exact (rem_1187 epsilon_mknows_current_p__type_18 X1 X2).
  intros X1;  exact (rem_1181 epsilon_mknows_current_p__type_18 X1).
  intros X1 X2. intro H. elim (rem_1073 X1 X2 H).
  intros X1 X2;  exact (rem_1183 epsilon_mknows_current_p__type_18 X1 X2).
   intro H. elim (rem_1074  H).
   intro H. elim (rem_1072  H).
  intros X1 X2. intro H. elim (rem_1071 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1070 X1 X2 H).
  intros X1;  exact (rem_1213 epsilon_mknows_current_p__type_18 X1).
  exact (rem_1219 epsilon_mknows_current_p__type_18 ).
  intros X1 X2. intro H. elim (rem_1076 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1069 X1 X2 H).
   intro H. elim (rem_1075  H).
Qed.

Remark rem_1240 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current X1 -> auto___type_18 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_current X1 -> auto___type_18 X1). tauto. exact (rem_1239 X1).
Qed.

Remark rem_1241 : forall X1 X2:term, auto___def_78 X2 X1 -> auto___type_18 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_918 X2 X1 H);  intros.
  apply (rem_1240 X1 X2);  tauto.
Qed.

Remark rem_1242 : forall X1:term, auto___def_105 X1 -> auto___def_105 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1243 : forall X1 X2:term, auto___def_105 X1 -> auto___type_23 X2 -> auto___def_105 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_105 X1 -> auto___def_105 X1). tauto. exact (rem_1242 X1).
Qed.

Remark rem_1244 : forall X2:term, auto___type_23 X2 -> auto___type_23 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1245 : forall X1 X2:term, auto___def_105 X1 -> auto___type_23 X2 -> auto___type_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_23 X2 -> auto___type_23 X2). tauto. exact (rem_1244 X2).
Qed.

Remark rem_1246 : forall X1 X2:term, auto___def_105 X1 -> auto___type_23 X2 -> (auto___def_105 X1 /\ auto___type_23 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_105 X1). 2:apply (rem_1243 X1 X2);  assumption.
  cut (auto___type_23 X2). 2:apply (rem_1245 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1247 : forall X1 X2:term, auto___def_105 X1 -> auto___type_23 X2 -> auto___def_104 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1246 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_104_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1248 : forall X1 X2:term, auto___type_23 X2 -> auto___def_105 X1 -> auto___def_104 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_105 X1 -> auto___type_23 X2 -> auto___def_104 (key X1 X2)). tauto. exact (rem_1247 X1 X2).
Qed.

Remark rem_1249 : auto___def_118 pub. (* Deduce positive atom. *)
Proof.
   case rem_855. intros. apply trans___def_118_pub_1;  tauto.
 tauto.
Qed.

Remark rem_1250 : auto___def_60 sym. (* Deduce positive atom. *)
Proof.
   case rem_855. intros. apply trans___def_60_sym_1;  tauto.
 tauto.
Qed.

Remark rem_1251 : forall X1:term, auto___type_3 X1 -> auto___type_3 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1252 : forall X1 X2:term, auto___def_20 X2 -> auto___type_3 X1 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_3 X1 -> auto___type_3 X1). tauto. exact (rem_1251 X1).
Qed.

Remark rem_1253 : forall X2:term, auto___def_20 X2 -> auto___def_20 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1254 : forall X1 X2:term, auto___def_20 X2 -> auto___type_3 X1 -> auto___def_20 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_20 X2 -> auto___def_20 X2). tauto. exact (rem_1253 X2).
Qed.

Remark rem_1255 : forall X1 X2:term, auto___def_20 X2 -> auto___type_3 X1 -> (auto___type_3 X1 /\ auto___def_20 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_3 X1). 2:apply (rem_1252 X1 X2);  assumption.
  cut (auto___def_20 X2). 2:apply (rem_1254 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1256 : forall X1 X2:term, auto___def_20 X2 -> auto___type_3 X1 -> auto___def_22 (dec X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1255 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_22_dec_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1257 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old nil -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_old X1 -> auto_knows_old X1). tauto. exact (rem_276 X1).
Qed.

Remark rem_1258 : forall X2:term, auto_knows_old X2 -> auto_knows_old X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1259 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old nil -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_1258 X2).
Qed.

Remark rem_1260 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old nil -> (auto_knows_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto_knows_old X1). 2:apply (rem_1257 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_1259 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1261 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old nil -> auto___def_18 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1260 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_18_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1262 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old nil -> auto_knows_old X1 -> auto___def_18 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old nil -> auto___def_18 X1 X2). tauto. exact (rem_1261 X1 X2).
Qed.

Remark rem_1263 : forall X1 X2:term, auto_knows_old (cons X1 X2) -> or_1
    (auto_knows_old X1 /\ auto_knows_old X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1264 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old (cons X2 nil) -> auto___def_18 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_1263 X2 nil H);  intros.
  apply (rem_1262 X1 X2);  tauto.
Qed.

Remark rem_1265 : forall X1 X2:term, auto_knows_old (cons X1 (cons X2 nil)) -> auto___def_18 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_1263 X1 (cons X2 nil) H);  intros.
  apply (rem_1264 X1 X2);  tauto.
Qed.

Remark rem_1266 : forall X1 X2 X3:term, auto___def_10 X2 -> auto_agent X3 -> auto_agent X1 -> auto_knows_old X3 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_923 X1).
Qed.

Remark rem_1267 : forall X2:term, auto___def_10 X2 -> auto___def_10 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1268 : forall X1 X2 X3:term, auto___def_10 X2 -> auto_agent X3 -> auto_agent X1 -> auto_knows_old X3 -> auto___def_10 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_10 X2 -> auto___def_10 X2). tauto. exact (rem_1267 X2).
Qed.

Remark rem_1269 : forall X3:term, auto_agent X3 -> auto_agent X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1270 : forall X1 X2 X3:term, auto___def_10 X2 -> auto_agent X3 -> auto_agent X1 -> auto_knows_old X3 -> auto_agent X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_agent X3 -> auto_agent X3). tauto. exact (rem_1269 X3).
Qed.

Remark rem_1271 : forall X1 X2 X3:term, auto___def_10 X2 -> auto_agent X3 -> auto_agent X1 -> auto_knows_old X3 -> (auto_agent X1 /\ auto___def_10 X2 /\ auto_agent X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  cut (auto_agent X1). 2:apply (rem_1266 X1 X2 X3);  assumption.
  cut (auto___def_10 X2). 2:apply (rem_1268 X1 X2 X3);  assumption.
  cut (auto_agent X3). 2:apply (rem_1270 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_1272 : forall X1 X2 X3:term, auto___def_10 X2 -> auto_agent X3 -> auto_agent X1 -> auto_knows_old X3 -> auto___def_14 X1 X2 X3. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  case (rem_1271 X1 X2 X3 A1 A2 A3 A4). clear  A1 A2 A3 A4. intros. apply trans___def_14_2;  tauto.
 clear  A1 A2 A3 A4. tauto.
Qed.

Remark rem_1273 : forall X1 X2 X3:term, auto_agent X3 -> auto_agent X1 -> auto___def_10 X2 -> auto_knows_old X3 -> auto___def_14 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_10 X2 -> auto_agent X3 -> auto_agent X1 -> auto_knows_old X3 -> auto___def_14 X1 X2 X3). tauto. exact (rem_1272 X1 X2 X3).
Qed.

Remark rem_1274 : forall X1 X2:term, auto___def_11 (passwd_old X1 X2) -> or_1
    (auto_agent X1 /\ auto_agent X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1275 : forall X1 X2 X3:term, auto___def_10 X2 -> auto___def_11 (passwd_old X3 X1) -> auto_knows_old X3 -> auto___def_14 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_1274 X3 X1 H);  intros.
  apply (rem_1273 X1 X2 X3);  tauto.
Qed.

Remark rem_1276 : forall X2:term, auto___def_15 X2 -> auto___def_15 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1277 : forall X1 X2 X3:term, auto___def_15 X2 -> auto___def_16 (passwd_old X3 X1) -> auto_knows_old X3 -> auto___def_15 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_15 X2 -> auto___def_15 X2). tauto. exact (rem_1276 X2).
Qed.

Remark rem_1278 : forall X3:term, auto_knows_old X3 -> auto_knows_old X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1279 : forall X1 X2 X3:term, auto___def_15 X2 -> auto___def_16 (passwd_old X3 X1) -> auto_knows_old X3 -> auto_knows_old X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_old X3 -> auto_knows_old X3). tauto. exact (rem_1278 X3).
Qed.

Remark rem_1280 : forall X1 X2 X3:term, auto___def_15 X2 -> auto___def_16 (passwd_old X3 X1) -> auto_knows_old X3 -> (auto___def_15 X2 /\ auto_knows_old X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_15 X2). 2:apply (rem_1277 X1 X2 X3);  assumption.
  cut (auto_knows_old X3). 2:apply (rem_1279 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_1281 : forall X1 X2 X3:term, auto___def_15 X2 -> auto___def_16 (passwd_old X3 X1) -> auto_knows_old X3 -> auto___def_14 X1 X2 X3. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  case (rem_1280 X1 X2 X3 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_14_3;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1282 : forall X2:term, auto___def_19 X2 -> auto___def_19 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1283 : forall X1 X2 X3:term, auto___def_19 X2 -> auto___def_20 (passwd_old X3 X1) -> auto_knows_old X3 -> auto___def_19 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_19 X2 -> auto___def_19 X2). tauto. exact (rem_1282 X2).
Qed.

Remark rem_1284 : forall X1 X2 X3:term, auto___def_19 X2 -> auto___def_20 (passwd_old X3 X1) -> auto_knows_old X3 -> auto_knows_old X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_old X3 -> auto_knows_old X3). tauto. exact (rem_1278 X3).
Qed.

Remark rem_1285 : forall X1 X2 X3:term, auto___def_19 X2 -> auto___def_20 (passwd_old X3 X1) -> auto_knows_old X3 -> (auto___def_19 X2 /\ auto_knows_old X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_19 X2). 2:apply (rem_1283 X1 X2 X3);  assumption.
  cut (auto_knows_old X3). 2:apply (rem_1284 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_1286 : forall X1 X2 X3:term, auto___def_19 X2 -> auto___def_20 (passwd_old X3 X1) -> auto_knows_old X3 -> auto___def_14 X1 X2 X3. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  case (rem_1285 X1 X2 X3 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_14_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1287 : forall X1 X2:term, auto_knows_old (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1288 : forall X1 X2 X3:term, auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old (passwd_old X3 X1) -> auto___def_14 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1 H2. intro H. intros.
  elim (rem_1287 X3 X1 H);  intros.
Qed.

Remark rem_1289 : forall X1 X2 X3:term, auto_knows_old X2 -> auto_knows_old (passwd_old X3 X1) -> auto_knows_old X3 -> auto___def_14 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old (passwd_old X3 X1) -> auto___def_14 X1 X2 X3). tauto. exact (rem_1288 X1 X2 X3).
Qed.

Remark rem_1290 : forall X1 X2:term, auto_knows_old (enc X1 X2) -> or_4
    (auto___def_10 X1 /\ auto___def_11 X2)
    (auto___def_15 X1 /\ auto___def_16 X2)
    (auto___def_19 X1 /\ auto___def_20 X2)
    (auto_knows_old X1 /\ auto_knows_old X2)
.
Proof.
  intros. inversion H.
  intros. apply or_4_intro_1; tauto.
  intros. apply or_4_intro_2; tauto.
  intros. apply or_4_intro_3; tauto.
  intros. apply or_4_intro_4; tauto.
Qed.

Remark rem_1291 : forall X1 X2 X3:term, auto_knows_old X3 -> auto_knows_old (enc X2 (passwd_old X3 X1)) -> auto___def_14 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_1290 X2 (passwd_old X3 X1) H);  intros.
  apply (rem_1275 X1 X2 X3);  tauto.
  apply (rem_1281 X1 X2 X3);  tauto.
  apply (rem_1286 X1 X2 X3);  tauto.
  apply (rem_1289 X1 X2 X3);  tauto.
Qed.

Remark rem_1292 : forall X1 X2 X3:term, auto_knows_old X3 -> auto_knows_old (enc X2 (passwd_old X3 X1)) -> auto_knows_old nil -> auto___def_14 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_old X3 -> auto_knows_old (enc X2 (passwd_old X3 X1)) -> auto___def_14 X1 X2 X3). tauto.
  exact (rem_1291 X1 X2 X3).
Qed.

Remark rem_1293 : forall X1 X2 X3:term, auto_knows_old (enc X2 (passwd_old X3 X1)) -> auto_knows_old nil -> auto_knows_old X3 -> auto___def_14 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_knows_old X3 -> auto_knows_old (enc X2 (passwd_old X3 X1)) -> auto_knows_old nil -> auto___def_14 X1 X2 X3). tauto. exact (rem_1292 X1 X2 X3).
Qed.

Remark rem_1294 : forall X1 X2 X3:term, auto_knows_old X3 -> auto_knows_old (cons (enc X2 (passwd_old X3 X1)) nil) -> auto___def_14 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_1263 (enc X2 (passwd_old X3 X1)) nil H);  intros.
  apply (rem_1293 X1 X2 X3);  tauto.
Qed.

Remark rem_1295 : forall X1 X2 X3:term, auto_knows_old (cons X3 (cons (enc X2 (passwd_old X3 X1)) nil)) -> auto___def_14 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1263 X3 (cons (enc X2 (passwd_old X3 X1)) nil) H);  intros.
  apply (rem_1294 X1 X2 X3);  tauto.
Qed.

Remark rem_1296 : forall X1 X2 X3:term, auto___def_17 X3 -> auto_agent X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_923 X1).
Qed.

Remark rem_1297 : forall X1 X2 X3:term, auto___def_17 X3 -> auto_agent X2 -> auto_agent X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_925 X2).
Qed.

Remark rem_1298 : forall X1 X2 X3:term, auto___def_17 X3 -> auto_agent X2 -> auto_agent X1 -> (auto_agent X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  cut (auto_agent X1). 2:apply (rem_1296 X1 X2 X3);  assumption.
  cut (auto_agent X2). 2:apply (rem_1297 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_1299 : forall X1 X2 X3:term, auto___def_17 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_24 (noncea_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  case (rem_1298 X1 X2 X3 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_24_noncea_old_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1300 : forall X1 X2 X3:term, auto___def_23 X1 X2 X3 -> or_1
    (auto___def_17 X1 /\ auto_agent X2 /\ auto_agent X3)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1301 : forall X1 X2 X3:term, auto___def_23 X3 X2 X1 -> auto___def_24 (noncea_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1300 X3 X2 X1 H);  intros.
  apply (rem_1299 X1 X2 X3);  tauto.
Qed.

Remark rem_1302 : forall X1:term, auto___def_17 X1 -> auto___def_17 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1303 : forall X1 X2:term, auto___def_17 X1 -> auto___type_2 X2 -> auto___def_17 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_17 X1 -> auto___def_17 X1). tauto. exact (rem_1302 X1).
Qed.

Remark rem_1304 : forall X2:term, auto___type_2 X2 -> auto___type_2 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1305 : forall X1 X2:term, auto___def_17 X1 -> auto___type_2 X2 -> auto___type_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_2 X2 -> auto___type_2 X2). tauto. exact (rem_1304 X2).
Qed.

Remark rem_1306 : forall X1 X2:term, auto___def_17 X1 -> auto___type_2 X2 -> (auto___def_17 X1 /\ auto___type_2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_17 X1). 2:apply (rem_1303 X1 X2);  assumption.
  cut (auto___type_2 X2). 2:apply (rem_1305 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1307 : forall X1 X2:term, auto___def_17 X1 -> auto___type_2 X2 -> auto___def_15 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1306 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_15_crypt_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1308 : forall X1 X2:term, auto___type_2 X2 -> auto___def_17 X1 -> auto___def_15 (crypt X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_17 X1 -> auto___type_2 X2 -> auto___def_15 (crypt X1 X2)). tauto. exact (rem_1307 X1 X2).
Qed.

Remark rem_1309 : auto___def_61 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1310 : auto___def_61 sym -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_1309 H);  intros.
Qed.

Remark rem_1311 : forall X1:term, auto___def_61 sym -> auto___def_62 X1 -> auto___def_68 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_61 sym -> False). tauto.
  exact (rem_1310).
Qed.

Remark rem_1312 : auto___def_51 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1313 : auto___def_51 sym -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_1312 H);  intros.
Qed.

Remark rem_1314 : forall X1:term, auto___def_51 sym -> auto_agent X1 -> auto___def_68 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_51 sym -> False). tauto.
  exact (rem_1313).
Qed.

Remark rem_1315 : auto___def_12 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1316 : auto___def_12 sym -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_1315 H);  intros.
Qed.

Remark rem_1317 : forall X1:term, auto___def_12 sym -> auto___def_13 X1 -> auto___def_68 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_12 sym -> False). tauto.
  exact (rem_1316).
Qed.

Remark rem_1318 : forall X1:term, auto_knows_current (key sym X1) -> auto___def_68 X1. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_1066 sym X1 H);  intros.
  apply (rem_1311 X1);  tauto.
  apply (rem_1314 X1);  tauto.
  apply (rem_1317 X1);  tauto.
Qed.

Remark rem_1319 : (forall X:term, auto___def_17 X -> auto___type_8 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1320 : (forall X:term, auto___def_17 X -> auto___type_8 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_17_p__type_8. intros X1. intros A1.
  cut (auto_knows_old X1). 2:apply (rem_1319 epsilon_m__def_17_p__type_8 X1);  assumption.
  tauto.
Defined.

Remark rem_1321 : (forall X:term, auto___def_17 X -> auto___type_8 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto___type_8 (r_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_17_p__type_8. intros X1 X2. intros A1.
  case (rem_1320 epsilon_m__def_17_p__type_8 X1 A1). clear  epsilon_m__def_17_p__type_8 A1. intros. apply trans___type_8_r_old_1;  tauto.
 clear  epsilon_m__def_17_p__type_8 A1. tauto.
Defined.

Remark rem_1322 : forall X1 X2:term, auto___def_17 (r_old X1 X2) -> or_1
    (auto_knows_old X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1323 : (forall X:term, auto___def_17 X -> auto___type_8 X)
    -> forall X1 X2:term, auto___def_17 (r_old X1 X2) -> auto___type_8 (r_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_17_p__type_8. intros X1 X2. intro H. intros.
  elim (rem_1322 X1 X2 H);  intros.
  apply (rem_1321 epsilon_m__def_17_p__type_8 X1 X2);  tauto.
Defined.

Remark rem_1324 : forall X1 X2:term, auto___def_17 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1325 : forall X1 X2:term, auto___def_17 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1326 : forall X1 X2:term, auto___def_17 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1327 : auto___def_17 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1328 : forall X1 X2:term, auto___def_17 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1329 : forall X1 X2:term, auto___def_17 (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1330 : forall X1:term, auto___def_17 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1331 : auto___def_17 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1332 : forall X1 X2:term, auto___def_17 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1333 : forall X1 X2:term, auto___def_17 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1334 : auto___def_17 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1335 : auto___def_17 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1336 : forall X1 X2:term, auto___def_17 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1337 : forall X1 X2:term, auto___def_17 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1338 : forall X1 X2:term, auto___def_17 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1339 : forall X1 X2:term, auto___def_17 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1340 : forall X1:term, auto___def_17 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1341 : auto___def_17 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1342 : forall X1 X2:term, auto___def_17 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1343 : auto___def_17 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1344 : auto___def_17 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1345 : auto___def_17 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1346 : forall X1 X2:term, auto___def_17 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1347 : forall X1 X2:term, auto___def_17 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1348 : forall X1:term, auto___def_17 X1 -> auto___type_8 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_17_p__type_8 1.
  intro X. case X.
   intro H. elim (rem_1334  H).
   intro H. elim (rem_1327  H).
  intros X1 X2. intro H. elim (rem_1339 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1324 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1337 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1338 X1 X2 H).
   intro H. elim (rem_1343  H).
  intros X1 X2. intro H. elim (rem_1347 X1 X2 H).
   intro H. elim (rem_1344  H).
  intros X1 X2. intro H. elim (rem_1346 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1328 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1325 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1336 X1 X2 H).
  intros X1. intro H. elim (rem_1330 X1 H).
  intros X1 X2. intro H. elim (rem_1333 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1332 X1 X2 H).
   intro H. elim (rem_1335  H).
   intro H. elim (rem_1331  H).
  intros X1 X2. intro H. elim (rem_1329 X1 X2 H).
  intros X1 X2;  exact (rem_1323 epsilon_m__def_17_p__type_8 X1 X2).
  intros X1. intro H. elim (rem_1340 X1 H).
   intro H. elim (rem_1345  H).
  intros X1 X2. intro H. elim (rem_1342 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1326 X1 X2 H).
   intro H. elim (rem_1341  H).
Qed.

Remark rem_1349 : forall X1 X2:term, auto___def_17 X1 -> auto___def_39 X2 -> auto___def_42 X1 -> auto___type_8 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_17 X1 -> auto___type_8 X1). tauto. exact (rem_1348 X1).
Qed.

Remark rem_1350 : forall X1 X2:term, auto___def_42 X1 -> auto___def_17 X1 -> auto___def_39 X2 -> auto___type_8 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_17 X1 -> auto___def_39 X2 -> auto___def_42 X1 -> auto___type_8 X1). tauto. exact (rem_1349 X1 X2).
Qed.

Remark rem_1351 : forall X1 X2:term, auto___def_43 X1 X2 -> or_1
    (auto___def_42 X1 /\ auto___def_17 X1 /\ auto___def_39 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1352 : forall X1 X2:term, auto___def_43 X1 X2 -> auto___type_8 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_1351 X1 X2 H);  intros.
  apply (rem_1350 X1 X2);  tauto.
Qed.

Remark rem_1353 : (forall X:term, auto___def_62 X -> auto___def_2 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_62_p__def_2.  tauto.
Defined.

Remark rem_1354 : (forall X:term, auto___def_62 X -> auto___def_2 X)
    -> auto___def_2 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_62_p__def_2.  case (rem_1353 epsilon_m__def_62_p__def_2). clear  epsilon_m__def_62_p__def_2. intros. apply trans___def_2_i_1;  tauto.
 clear  epsilon_m__def_62_p__def_2. tauto.
Defined.

Remark rem_1355 : (forall X:term, auto___def_62 X -> auto___def_2 X)
    -> auto___def_62 i -> auto___def_2 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_62_p__def_2. intro H. intros.
  elim (rem_312 H);  intros.
  apply (rem_1354 epsilon_m__def_62_p__def_2);  tauto.
Defined.

Remark rem_1356 : forall X1:term, auto___def_62 X1 -> auto___def_2 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_62_p__def_2 1.
  intro X. case X.
   intro H. elim (rem_325  H).
   intro H. elim (rem_317  H).
  intros X1 X2. intro H. elim (rem_330 X1 X2 H).
  intros X1 X2. intro H. elim (rem_314 X1 X2 H).
  intros X1 X2. intro H. elim (rem_328 X1 X2 H).
  intros X1 X2. intro H. elim (rem_329 X1 X2 H).
  exact (rem_1355 epsilon_m__def_62_p__def_2 ).
  intros X1 X2. intro H. elim (rem_337 X1 X2 H).
   intro H. elim (rem_334  H).
  intros X1 X2. intro H. elim (rem_336 X1 X2 H).
  intros X1 X2. intro H. elim (rem_318 X1 X2 H).
  intros X1 X2. intro H. elim (rem_315 X1 X2 H).
  intros X1 X2. intro H. elim (rem_327 X1 X2 H).
  intros X1. intro H. elim (rem_321 X1 H).
  intros X1 X2. intro H. elim (rem_324 X1 X2 H).
  intros X1 X2. intro H. elim (rem_323 X1 X2 H).
   intro H. elim (rem_326  H).
   intro H. elim (rem_322  H).
  intros X1 X2. intro H. elim (rem_320 X1 X2 H).
  intros X1 X2. intro H. elim (rem_319 X1 X2 H).
  intros X1. intro H. elim (rem_331 X1 H).
   intro H. elim (rem_335  H).
  intros X1 X2. intro H. elim (rem_333 X1 X2 H).
  intros X1 X2. intro H. elim (rem_316 X1 X2 H).
   intro H. elim (rem_332  H).
Qed.

Remark rem_1357 : forall X1:term, auto___def_61 prv -> auto___def_62 X1 -> auto___def_2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1.
  cut (auto___def_62 X1 -> auto___def_2 X1). tauto. exact (rem_1356 X1).
Qed.

Remark rem_1358 : auto___def_51 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1359 : auto___def_51 prv -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_1358 H);  intros.
Qed.

Remark rem_1360 : forall X1:term, auto___def_51 prv -> auto_agent X1 -> auto___def_2 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_51 prv -> False). tauto.
  exact (rem_1359).
Qed.

Remark rem_1361 : forall X1 X2:term, auto_knows_old (key X1 X2) -> or_2
    (auto___def_61 X1 /\ auto___def_62 X2)
    (auto___def_51 X1 /\ auto_agent X2)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_1362 : forall X1:term, auto_knows_old (key prv X1) -> auto___def_2 X1. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_1361 prv X1 H);  intros.
  apply (rem_1357 X1);  tauto.
  apply (rem_1360 X1);  tauto.
Qed.

Remark rem_1363 : forall X1:term, auto___def_70 X1 -> auto___def_70 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1364 : forall X1 X2:term, auto___def_70 X1 -> auto___def_9 X2 -> auto___def_70 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_70 X1 -> auto___def_70 X1). tauto. exact (rem_1363 X1).
Qed.

Remark rem_1365 : forall X2:term, auto___def_9 X2 -> auto___def_9 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1366 : forall X1 X2:term, auto___def_70 X1 -> auto___def_9 X2 -> auto___def_9 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_9 X2 -> auto___def_9 X2). tauto. exact (rem_1365 X2).
Qed.

Remark rem_1367 : forall X1 X2:term, auto___def_70 X1 -> auto___def_9 X2 -> (auto___def_70 X1 /\ auto___def_9 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_70 X1). 2:apply (rem_1364 X1 X2);  assumption.
  cut (auto___def_9 X2). 2:apply (rem_1366 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1368 : forall X1 X2:term, auto___def_70 X1 -> auto___def_9 X2 -> auto___def_69 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1367 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_69_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1369 : forall X1 X2:term, auto___def_9 X2 -> auto___def_70 X1 -> auto___def_69 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_70 X1 -> auto___def_9 X2 -> auto___def_69 (cons X1 X2)). tauto. exact (rem_1368 X1 X2).
Qed.

Remark rem_1370 : forall X1 X2:term, auto___def_49 X2 X1 -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1.
  tauto.
Qed.

Remark rem_1371 : forall X1 X2:term, auto___def_49 X2 X1 -> auto___def_50 (r_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1.
  case (rem_1370 X1 X2 A1). clear  A1. intros. apply trans___def_50_r_old_1;  tauto.
 clear  A1. tauto.
Qed.

Remark rem_1372 : forall X1:term, auto___def_21 X1 -> auto___def_21 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1373 : forall X1 X2:term, auto___def_21 X1 -> auto___def_22 X2 -> auto___def_21 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_21 X1 -> auto___def_21 X1). tauto. exact (rem_1372 X1).
Qed.

Remark rem_1374 : forall X2:term, auto___def_22 X2 -> auto___def_22 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1375 : forall X1 X2:term, auto___def_21 X1 -> auto___def_22 X2 -> auto___def_22 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_22 X2 -> auto___def_22 X2). tauto. exact (rem_1374 X2).
Qed.

Remark rem_1376 : forall X1 X2:term, auto___def_21 X1 -> auto___def_22 X2 -> (auto___def_21 X1 /\ auto___def_22 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_21 X1). 2:apply (rem_1373 X1 X2);  assumption.
  cut (auto___def_22 X2). 2:apply (rem_1375 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1377 : forall X1 X2:term, auto___def_21 X1 -> auto___def_22 X2 -> auto___def_19 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1376 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_19_crypt_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1378 : forall X1 X2:term, auto___def_22 X2 -> auto___def_21 X1 -> auto___def_19 (crypt X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_21 X1 -> auto___def_22 X2 -> auto___def_19 (crypt X1 X2)). tauto. exact (rem_1377 X1 X2).
Qed.

Remark rem_1379 : auto___def_32 nil. (* Deduce positive atom. *)
Proof.
   case rem_855. intros. apply trans___def_32_nil_1;  tauto.
 tauto.
Qed.

Remark rem_1380 : forall X1:term, auto___type_18 X1 -> auto___type_18 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1381 : forall X1 X2:term, auto___def_80 X2 -> auto___type_18 X1 -> auto___type_18 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_18 X1 -> auto___type_18 X1). tauto. exact (rem_1380 X1).
Qed.

Remark rem_1382 : forall X2:term, auto___def_80 X2 -> auto___def_80 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1383 : forall X1 X2:term, auto___def_80 X2 -> auto___type_18 X1 -> auto___def_80 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_80 X2 -> auto___def_80 X2). tauto. exact (rem_1382 X2).
Qed.

Remark rem_1384 : forall X1 X2:term, auto___def_80 X2 -> auto___type_18 X1 -> (auto___type_18 X1 /\ auto___def_80 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_18 X1). 2:apply (rem_1381 X1 X2);  assumption.
  cut (auto___def_80 X2). 2:apply (rem_1383 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1385 : forall X1 X2:term, auto___def_80 X2 -> auto___type_18 X1 -> auto___def_82 (dec X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1384 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_82_dec_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1386 : (forall X:term, auto___def_17 X -> auto___type_4 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1387 : (forall X:term, auto___def_17 X -> auto___type_4 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_17_p__type_4. intros X1. intros A1.
  cut (auto_knows_old X1). 2:apply (rem_1386 epsilon_m__def_17_p__type_4 X1);  assumption.
  tauto.
Defined.

Remark rem_1388 : (forall X:term, auto___def_17 X -> auto___type_4 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto___type_4 (r_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_17_p__type_4. intros X1 X2. intros A1.
  case (rem_1387 epsilon_m__def_17_p__type_4 X1 A1). clear  epsilon_m__def_17_p__type_4 A1. intros. apply trans___type_4_r_old_1;  tauto.
 clear  epsilon_m__def_17_p__type_4 A1. tauto.
Defined.

Remark rem_1389 : (forall X:term, auto___def_17 X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_17 (r_old X1 X2) -> auto___type_4 (r_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_17_p__type_4. intros X1 X2. intro H. intros.
  elim (rem_1322 X1 X2 H);  intros.
  apply (rem_1388 epsilon_m__def_17_p__type_4 X1 X2);  tauto.
Defined.

Remark rem_1390 : forall X1:term, auto___def_17 X1 -> auto___type_4 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_17_p__type_4 1.
  intro X. case X.
   intro H. elim (rem_1334  H).
   intro H. elim (rem_1327  H).
  intros X1 X2. intro H. elim (rem_1339 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1324 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1337 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1338 X1 X2 H).
   intro H. elim (rem_1343  H).
  intros X1 X2. intro H. elim (rem_1347 X1 X2 H).
   intro H. elim (rem_1344  H).
  intros X1 X2. intro H. elim (rem_1346 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1328 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1325 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1336 X1 X2 H).
  intros X1. intro H. elim (rem_1330 X1 H).
  intros X1 X2. intro H. elim (rem_1333 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1332 X1 X2 H).
   intro H. elim (rem_1335  H).
   intro H. elim (rem_1331  H).
  intros X1 X2. intro H. elim (rem_1329 X1 X2 H).
  intros X1 X2;  exact (rem_1389 epsilon_m__def_17_p__type_4 X1 X2).
  intros X1. intro H. elim (rem_1340 X1 H).
   intro H. elim (rem_1345  H).
  intros X1 X2. intro H. elim (rem_1342 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1326 X1 X2 H).
   intro H. elim (rem_1341  H).
Qed.

Remark rem_1391 : forall X1 X2 X3:term, auto___def_17 X1 -> auto_agent X2 -> auto_agent X3 -> auto___type_4 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_17 X1 -> auto___type_4 X1). tauto. exact (rem_1390 X1).
Qed.

Remark rem_1392 : forall X1 X2 X3:term, auto___def_23 X1 X2 X3 -> auto___type_4 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1300 X1 X2 X3 H);  intros.
  apply (rem_1391 X1 X2 X3);  tauto.
Qed.

Remark rem_1393 : forall X1:term, auto___def_13 X1 -> auto___def_13 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1394 : forall X1 X2:term, auto___def_12 pub -> auto___def_13 X1 -> auto___def_17 X2 -> auto___def_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_13 X1 -> auto___def_13 X1). tauto. exact (rem_1393 X1).
Qed.

Remark rem_1395 : forall X2:term, auto___def_17 X2 -> auto___def_17 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1396 : forall X1 X2:term, auto___def_12 pub -> auto___def_13 X1 -> auto___def_17 X2 -> auto___def_17 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_17 X2 -> auto___def_17 X2). tauto. exact (rem_1395 X2).
Qed.

Remark rem_1397 : forall X1 X2:term, auto___def_12 pub -> auto___def_13 X1 -> auto___def_17 X2 -> (auto___def_13 X1 /\ auto___def_17 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_13 X1). 2:apply (rem_1394 X1 X2);  assumption.
  cut (auto___def_17 X2). 2:apply (rem_1396 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1398 : forall X1 X2:term, auto___def_12 pub -> auto___def_13 X1 -> auto___def_17 X2 -> auto___def_63 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1397 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_63_3;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1399 : forall X1 X2:term, auto___type_2 (key X1 X2) -> or_1
    (auto___def_12 X1 /\ auto___def_13 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1400 : forall X1 X2:term, auto___def_17 X2 -> auto___type_2 (key pub X1) -> auto___def_63 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_1399 pub X1 H);  intros.
  apply (rem_1398 X1 X2);  tauto.
Qed.

Remark rem_1401 : auto___def_41 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1402 : auto___def_41 pub -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_1401 H);  intros.
Qed.

Remark rem_1403 : forall X1 X2:term, auto___def_36 X2 -> auto___def_41 pub -> auto___def_42 X1 -> auto___def_63 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_41 pub -> False). tauto.
  exact (rem_1402).
Qed.

Remark rem_1404 : forall X1 X2:term, auto___def_41 pub -> auto___def_42 X1 -> auto___def_36 X2 -> auto___def_63 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_36 X2 -> auto___def_41 pub -> auto___def_42 X1 -> auto___def_63 X1 X2). tauto. exact (rem_1403 X1 X2).
Qed.

Remark rem_1405 : forall X1 X2:term, auto___def_37 (key X1 X2) -> or_1
    (auto___def_41 X1 /\ auto___def_42 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1406 : forall X1 X2:term, auto___def_36 X2 -> auto___def_37 (key pub X1) -> auto___def_63 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_1405 pub X1 H);  intros.
  apply (rem_1404 X1 X2);  tauto.
Qed.

Remark rem_1407 : forall X1 X2:term, auto___def_22 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1408 : forall X1 X2:term, auto___def_21 X2 -> auto___def_22 (key pub X1) -> auto___def_63 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_1407 pub X1 H);  intros.
Qed.

Remark rem_1409 : (forall X:term, auto___def_62 X -> auto_agent X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_62_pagent.  tauto.
Defined.

Remark rem_1410 : (forall X:term, auto___def_62 X -> auto_agent X)
    -> auto_agent i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_62_pagent.  case (rem_1409 epsilon_m__def_62_pagent). clear  epsilon_m__def_62_pagent. intros. apply trans_agent_i_1;  tauto.
 clear  epsilon_m__def_62_pagent. tauto.
Defined.

Remark rem_1411 : (forall X:term, auto___def_62 X -> auto_agent X)
    -> auto___def_62 i -> auto_agent i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_62_pagent. intro H. intros.
  elim (rem_312 H);  intros.
  apply (rem_1410 epsilon_m__def_62_pagent);  tauto.
Defined.

Remark rem_1412 : forall X1:term, auto___def_62 X1 -> auto_agent X1. (* Induct. *)
Proof.
  fix epsilon_m__def_62_pagent 1.
  intro X. case X.
   intro H. elim (rem_325  H).
   intro H. elim (rem_317  H).
  intros X1 X2. intro H. elim (rem_330 X1 X2 H).
  intros X1 X2. intro H. elim (rem_314 X1 X2 H).
  intros X1 X2. intro H. elim (rem_328 X1 X2 H).
  intros X1 X2. intro H. elim (rem_329 X1 X2 H).
  exact (rem_1411 epsilon_m__def_62_pagent ).
  intros X1 X2. intro H. elim (rem_337 X1 X2 H).
   intro H. elim (rem_334  H).
  intros X1 X2. intro H. elim (rem_336 X1 X2 H).
  intros X1 X2. intro H. elim (rem_318 X1 X2 H).
  intros X1 X2. intro H. elim (rem_315 X1 X2 H).
  intros X1 X2. intro H. elim (rem_327 X1 X2 H).
  intros X1. intro H. elim (rem_321 X1 H).
  intros X1 X2. intro H. elim (rem_324 X1 X2 H).
  intros X1 X2. intro H. elim (rem_323 X1 X2 H).
   intro H. elim (rem_326  H).
   intro H. elim (rem_322  H).
  intros X1 X2. intro H. elim (rem_320 X1 X2 H).
  intros X1 X2. intro H. elim (rem_319 X1 X2 H).
  intros X1. intro H. elim (rem_331 X1 H).
   intro H. elim (rem_335  H).
  intros X1 X2. intro H. elim (rem_333 X1 X2 H).
  intros X1 X2. intro H. elim (rem_316 X1 X2 H).
   intro H. elim (rem_332  H).
Qed.

Remark rem_1413 : forall X1 X2:term, auto___def_61 pub -> auto___def_62 X1 -> auto_knows_current X2 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_62 X1 -> auto_agent X1). tauto. exact (rem_1412 X1).
Qed.

Remark rem_1414 : forall X2:term, auto_knows_current X2 -> auto_knows_current X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1415 : forall X1 X2:term, auto___def_61 pub -> auto___def_62 X1 -> auto_knows_current X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_1414 X2).
Qed.

Remark rem_1416 : forall X1 X2:term, auto___def_61 pub -> auto___def_62 X1 -> auto_knows_current X2 -> (auto_agent X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto_agent X1). 2:apply (rem_1413 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1415 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1417 : forall X1 X2:term, auto___def_61 pub -> auto___def_62 X1 -> auto_knows_current X2 -> auto___def_63 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1416 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_63_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1418 : forall X1 X2:term, auto___def_51 pub -> auto_agent X1 -> auto_knows_current X2 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_923 X1).
Qed.

Remark rem_1419 : forall X1 X2:term, auto___def_51 pub -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_1414 X2).
Qed.

Remark rem_1420 : forall X1 X2:term, auto___def_51 pub -> auto_agent X1 -> auto_knows_current X2 -> (auto_agent X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto_agent X1). 2:apply (rem_1418 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1419 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1421 : forall X1 X2:term, auto___def_51 pub -> auto_agent X1 -> auto_knows_current X2 -> auto___def_63 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1420 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_63_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1422 : forall X1 X2:term, auto___def_12 pub -> auto___def_13 X1 -> auto_knows_current X2 -> auto___def_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_13 X1 -> auto___def_13 X1). tauto. exact (rem_1393 X1).
Qed.

Remark rem_1423 : forall X1 X2:term, auto___def_12 pub -> auto___def_13 X1 -> auto_knows_current X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_1414 X2).
Qed.

Remark rem_1424 : forall X1 X2:term, auto___def_12 pub -> auto___def_13 X1 -> auto_knows_current X2 -> (auto___def_13 X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_13 X1). 2:apply (rem_1422 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1423 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1425 : forall X1 X2:term, auto___def_12 pub -> auto___def_13 X1 -> auto_knows_current X2 -> auto___def_63 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1424 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_63_2;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1426 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current (key pub X1) -> auto___def_63 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_1066 pub X1 H);  intros.
  apply (rem_1417 X1 X2);  tauto.
  apply (rem_1421 X1 X2);  tauto.
  apply (rem_1425 X1 X2);  tauto.
Qed.

Remark rem_1427 : auto___def_105 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1428 : auto___def_105 pub -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_1427 H);  intros.
Qed.

Remark rem_1429 : forall X1 X2:term, auto___def_105 pub -> auto___type_22 X2 -> auto___type_23 X1 -> auto___def_63 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_105 pub -> False). tauto.
  exact (rem_1428).
Qed.

Remark rem_1430 : forall X1 X2:term, auto___def_105 pub -> auto___type_23 X1 -> auto___type_22 X2 -> auto___def_63 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_105 pub -> auto___type_22 X2 -> auto___type_23 X1 -> auto___def_63 X1 X2). tauto. exact (rem_1429 X1 X2).
Qed.

Remark rem_1431 : forall X1 X2:term, auto___def_104 (key X1 X2) -> or_1
    (auto___def_105 X1 /\ auto___type_23 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1432 : forall X1 X2:term, auto___def_104 (key pub X1) -> auto___type_22 X2 -> auto___def_63 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_1431 pub X1 H);  intros.
  apply (rem_1430 X1 X2);  tauto.
Qed.

Remark rem_1433 : forall X1 X2:term, auto___type_22 X2 -> auto___def_104 (key pub X1) -> auto___def_63 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_104 (key pub X1) -> auto___type_22 X2 -> auto___def_63 X1 X2). tauto. exact (rem_1432 X1 X2).
Qed.

Remark rem_1434 : auto___def_93 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1435 : auto___def_93 pub -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_1434 H);  intros.
Qed.

Remark rem_1436 : forall X1 X2:term, auto___def_88 X2 -> auto___def_93 pub -> auto___def_94 X1 -> auto___def_63 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_93 pub -> False). tauto.
  exact (rem_1435).
Qed.

Remark rem_1437 : forall X1 X2:term, auto___def_93 pub -> auto___def_94 X1 -> auto___def_88 X2 -> auto___def_63 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_88 X2 -> auto___def_93 pub -> auto___def_94 X1 -> auto___def_63 X1 X2). tauto. exact (rem_1436 X1 X2).
Qed.

Remark rem_1438 : forall X1 X2:term, auto___def_89 (key X1 X2) -> or_1
    (auto___def_93 X1 /\ auto___def_94 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1439 : forall X1 X2:term, auto___def_88 X2 -> auto___def_89 (key pub X1) -> auto___def_63 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_1438 pub X1 H);  intros.
  apply (rem_1437 X1 X2);  tauto.
Qed.

Remark rem_1440 : auto___def_26 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1441 : auto___def_26 pub -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_1440 H);  intros.
Qed.

Remark rem_1442 : forall X1 X2:term, auto___def_24 X2 -> auto___def_26 pub -> auto___type_4 X1 -> auto___def_63 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_26 pub -> False). tauto.
  exact (rem_1441).
Qed.

Remark rem_1443 : forall X1 X2:term, auto___def_26 pub -> auto___type_4 X1 -> auto___def_24 X2 -> auto___def_63 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_24 X2 -> auto___def_26 pub -> auto___type_4 X1 -> auto___def_63 X1 X2). tauto. exact (rem_1442 X1 X2).
Qed.

Remark rem_1444 : forall X1 X2:term, auto___def_25 (key X1 X2) -> or_1
    (auto___def_26 X1 /\ auto___type_4 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1445 : forall X1 X2:term, auto___def_24 X2 -> auto___def_25 (key pub X1) -> auto___def_63 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_1444 pub X1 H);  intros.
  apply (rem_1443 X1 X2);  tauto.
Qed.

Remark rem_1446 : auto___def_45 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1447 : auto___def_45 pub -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_1446 H);  intros.
Qed.

Remark rem_1448 : forall X1 X2:term, auto___def_45 pub -> auto___type_7 X2 -> auto___type_8 X1 -> auto___def_63 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_45 pub -> False). tauto.
  exact (rem_1447).
Qed.

Remark rem_1449 : forall X1 X2:term, auto___def_45 pub -> auto___type_8 X1 -> auto___type_7 X2 -> auto___def_63 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_45 pub -> auto___type_7 X2 -> auto___type_8 X1 -> auto___def_63 X1 X2). tauto. exact (rem_1448 X1 X2).
Qed.

Remark rem_1450 : forall X1 X2:term, auto___def_44 (key X1 X2) -> or_1
    (auto___def_45 X1 /\ auto___type_8 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1451 : forall X1 X2:term, auto___def_44 (key pub X1) -> auto___type_7 X2 -> auto___def_63 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_1450 pub X1 H);  intros.
  apply (rem_1449 X1 X2);  tauto.
Qed.

Remark rem_1452 : forall X1 X2:term, auto___type_7 X2 -> auto___def_44 (key pub X1) -> auto___def_63 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_44 (key pub X1) -> auto___type_7 X2 -> auto___def_63 X1 X2). tauto. exact (rem_1451 X1 X2).
Qed.

Remark rem_1453 : auto___def_86 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1454 : auto___def_86 pub -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_1453 H);  intros.
Qed.

Remark rem_1455 : forall X1 X2:term, auto___def_84 X2 -> auto___def_86 pub -> auto___type_19 X1 -> auto___def_63 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_86 pub -> False). tauto.
  exact (rem_1454).
Qed.

Remark rem_1456 : forall X1 X2:term, auto___def_86 pub -> auto___type_19 X1 -> auto___def_84 X2 -> auto___def_63 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_84 X2 -> auto___def_86 pub -> auto___type_19 X1 -> auto___def_63 X1 X2). tauto. exact (rem_1455 X1 X2).
Qed.

Remark rem_1457 : forall X1 X2:term, auto___def_85 (key X1 X2) -> or_1
    (auto___def_86 X1 /\ auto___type_19 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1458 : forall X1 X2:term, auto___def_84 X2 -> auto___def_85 (key pub X1) -> auto___def_63 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_1457 pub X1 H);  intros.
  apply (rem_1456 X1 X2);  tauto.
Qed.

Remark rem_1459 : forall X1 X2:term, auto_knows_current (crypt X2 (key pub X1)) -> auto___def_63 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_987 X2 (key pub X1) H);  intros.
  apply (rem_1400 X1 X2);  tauto.
  apply (rem_1406 X1 X2);  tauto.
  apply (rem_1408 X1 X2);  tauto.
  apply (rem_1426 X1 X2);  tauto.
  apply (rem_1433 X1 X2);  tauto.
  apply (rem_1439 X1 X2);  tauto.
  apply (rem_1445 X1 X2);  tauto.
  apply (rem_1452 X1 X2);  tauto.
  apply (rem_1458 X1 X2);  tauto.
Qed.

Remark rem_1460 : auto___def_41 sym. (* Deduce positive atom. *)
Proof.
   case rem_855. intros. apply trans___def_41_sym_1;  tauto.
 tauto.
Qed.

Remark rem_1461 : auto___def_12 pub. (* Deduce positive atom. *)
Proof.
   case rem_855. intros. apply trans___def_12_pub_1;  tauto.
 tauto.
Qed.

Remark rem_1462 : forall X1:term, auto___def_77 X1 -> auto___def_77 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1463 : forall X1 X2:term, auto___def_77 X1 -> auto___type_17 X2 -> auto___def_77 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_77 X1 -> auto___def_77 X1). tauto. exact (rem_1462 X1).
Qed.

Remark rem_1464 : forall X2:term, auto___type_17 X2 -> auto___type_17 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1465 : forall X1 X2:term, auto___def_77 X1 -> auto___type_17 X2 -> auto___type_17 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_17 X2 -> auto___type_17 X2). tauto. exact (rem_1464 X2).
Qed.

Remark rem_1466 : forall X1 X2:term, auto___def_77 X1 -> auto___type_17 X2 -> (auto___def_77 X1 /\ auto___type_17 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_77 X1). 2:apply (rem_1463 X1 X2);  assumption.
  cut (auto___type_17 X2). 2:apply (rem_1465 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1467 : forall X1 X2:term, auto___def_77 X1 -> auto___type_17 X2 -> auto___def_75 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1466 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_75_crypt_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1468 : forall X1 X2:term, auto___type_17 X2 -> auto___def_77 X1 -> auto___def_75 (crypt X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_77 X1 -> auto___type_17 X2 -> auto___def_75 (crypt X1 X2)). tauto. exact (rem_1467 X1 X2).
Qed.

Remark rem_1469 : auto___def_40 nil. (* Deduce positive atom. *)
Proof.
   case rem_855. intros. apply trans___def_40_nil_1;  tauto.
 tauto.
Qed.

Remark rem_1470 : (forall X:term, auto___def_39 X -> auto___type_7 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1471 : (forall X:term, auto___def_39 X -> auto___type_7 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_39_p__type_7. intros X1. intros A1.
  cut (auto_knows_old X1). 2:apply (rem_1470 epsilon_m__def_39_p__type_7 X1);  assumption.
  tauto.
Defined.

Remark rem_1472 : (forall X:term, auto___def_39 X -> auto___type_7 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto___type_7 (nonceb_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_39_p__type_7. intros X1 X2. intros A1.
  case (rem_1471 epsilon_m__def_39_p__type_7 X1 A1). clear  epsilon_m__def_39_p__type_7 A1. intros. apply trans___type_7_nonceb_old_1;  tauto.
 clear  epsilon_m__def_39_p__type_7 A1. tauto.
Defined.

Remark rem_1473 : forall X1 X2:term, auto___def_39 (nonceb_old X1 X2) -> or_1
    (auto_knows_old X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1474 : (forall X:term, auto___def_39 X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_39 (nonceb_old X1 X2) -> auto___type_7 (nonceb_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_39_p__type_7. intros X1 X2. intro H. intros.
  elim (rem_1473 X1 X2 H);  intros.
  apply (rem_1472 epsilon_m__def_39_p__type_7 X1 X2);  tauto.
Defined.

Remark rem_1475 : forall X1 X2:term, auto___def_39 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1476 : forall X1 X2:term, auto___def_39 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1477 : forall X1 X2:term, auto___def_39 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1478 : auto___def_39 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1479 : forall X1 X2:term, auto___def_39 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1480 : forall X1 X2:term, auto___def_39 (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1481 : forall X1 X2:term, auto___def_39 (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1482 : forall X1:term, auto___def_39 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1483 : auto___def_39 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1484 : forall X1 X2:term, auto___def_39 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1485 : forall X1 X2:term, auto___def_39 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1486 : auto___def_39 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1487 : auto___def_39 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1488 : forall X1 X2:term, auto___def_39 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1489 : forall X1 X2:term, auto___def_39 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1490 : forall X1 X2:term, auto___def_39 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1491 : forall X1:term, auto___def_39 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1492 : auto___def_39 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1493 : forall X1 X2:term, auto___def_39 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1494 : auto___def_39 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1495 : auto___def_39 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1496 : auto___def_39 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1497 : forall X1 X2:term, auto___def_39 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1498 : forall X1 X2:term, auto___def_39 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1499 : forall X1:term, auto___def_39 X1 -> auto___type_7 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_39_p__type_7 1.
  intro X. case X.
   intro H. elim (rem_1486  H).
   intro H. elim (rem_1478  H).
  intros X1 X2. intro H. elim (rem_1490 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1475 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1488 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1489 X1 X2 H).
   intro H. elim (rem_1494  H).
  intros X1 X2. intro H. elim (rem_1498 X1 X2 H).
   intro H. elim (rem_1495  H).
  intros X1 X2. intro H. elim (rem_1497 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1479 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1476 X1 X2 H).
  intros X1 X2;  exact (rem_1474 epsilon_m__def_39_p__type_7 X1 X2).
  intros X1. intro H. elim (rem_1482 X1 H).
  intros X1 X2. intro H. elim (rem_1485 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1484 X1 X2 H).
   intro H. elim (rem_1487  H).
   intro H. elim (rem_1483  H).
  intros X1 X2. intro H. elim (rem_1481 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1480 X1 X2 H).
  intros X1. intro H. elim (rem_1491 X1 H).
   intro H. elim (rem_1496  H).
  intros X1 X2. intro H. elim (rem_1493 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1477 X1 X2 H).
   intro H. elim (rem_1492  H).
Qed.

Remark rem_1500 : forall X1 X2:term, auto___def_17 X2 -> auto___def_39 X1 -> auto___def_42 X2 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_39 X1 -> auto___type_7 X1). tauto. exact (rem_1499 X1).
Qed.

Remark rem_1501 : forall X1 X2:term, auto___def_42 X2 -> auto___def_17 X2 -> auto___def_39 X1 -> auto___type_7 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_17 X2 -> auto___def_39 X1 -> auto___def_42 X2 -> auto___type_7 X1). tauto. exact (rem_1500 X1 X2).
Qed.

Remark rem_1502 : forall X1 X2:term, auto___def_43 X2 X1 -> auto___type_7 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_1351 X2 X1 H);  intros.
  apply (rem_1501 X1 X2);  tauto.
Qed.

Remark rem_1503 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1:term, auto___def_36 X1 -> auto___def_36 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1504 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_36 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2.
  cut (auto___def_36 X1 -> auto___def_36 X1). tauto. exact (rem_1503 epsilon_mtestable_old_p__type_11 X1).
Defined.

Remark rem_1505 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X2:term, auto___def_37 X2 -> auto___def_37 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1506 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_37 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2.
  cut (auto___def_37 X2 -> auto___def_37 X2). tauto. exact (rem_1505 epsilon_mtestable_old_p__type_11 X2).
Defined.

Remark rem_1507 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> (auto___def_36 X1 /\ auto___def_37 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1 A2.
  cut (auto___def_36 X1). 2:apply (rem_1504 epsilon_mtestable_old_p__type_11 X1 X2);  assumption.
  cut (auto___def_37 X2). 2:apply (rem_1506 epsilon_mtestable_old_p__type_11 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1508 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_11 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1 A2.
  case (rem_1507 epsilon_mtestable_old_p__type_11 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_11 A1 A2. intros. apply trans___type_11_crypt_1;  tauto.
 clear  epsilon_mtestable_old_p__type_11 A1 A2. tauto.
Defined.

Remark rem_1509 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1:term, auto___type_12 X1 -> auto___type_12 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1510 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___type_12 X1 -> auto___def_54 X2 -> auto___type_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2.
  cut (auto___type_12 X1 -> auto___type_12 X1). tauto. exact (rem_1509 epsilon_mtestable_old_p__type_11 X1).
Defined.

Remark rem_1511 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X2:term, auto___def_54 X2 -> auto___def_54 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1512 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___type_12 X1 -> auto___def_54 X2 -> auto___def_54 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2.
  cut (auto___def_54 X2 -> auto___def_54 X2). tauto. exact (rem_1511 epsilon_mtestable_old_p__type_11 X2).
Defined.

Remark rem_1513 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___type_12 X1 -> auto___def_54 X2 -> (auto___type_12 X1 /\ auto___def_54 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1 A2.
  cut (auto___type_12 X1). 2:apply (rem_1510 epsilon_mtestable_old_p__type_11 X1 X2);  assumption.
  cut (auto___def_54 X2). 2:apply (rem_1512 epsilon_mtestable_old_p__type_11 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1514 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___type_12 X1 -> auto___def_54 X2 -> auto___type_11 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1 A2.
  case (rem_1513 epsilon_mtestable_old_p__type_11 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_11 A1 A2. intros. apply trans___type_11_crypt_2;  tauto.
 clear  epsilon_mtestable_old_p__type_11 A1 A2. tauto.
Defined.

Remark rem_1515 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1:term, auto___def_24 X1 -> auto___def_24 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1516 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___def_24 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2.
  cut (auto___def_24 X1 -> auto___def_24 X1). tauto. exact (rem_1515 epsilon_mtestable_old_p__type_11 X1).
Defined.

Remark rem_1517 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X2:term, auto___def_25 X2 -> auto___def_25 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1518 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___def_25 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2.
  cut (auto___def_25 X2 -> auto___def_25 X2). tauto. exact (rem_1517 epsilon_mtestable_old_p__type_11 X2).
Defined.

Remark rem_1519 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> (auto___def_24 X1 /\ auto___def_25 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1 A2.
  cut (auto___def_24 X1). 2:apply (rem_1516 epsilon_mtestable_old_p__type_11 X1 X2);  assumption.
  cut (auto___def_25 X2). 2:apply (rem_1518 epsilon_mtestable_old_p__type_11 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1520 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___type_11 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1 A2.
  case (rem_1519 epsilon_mtestable_old_p__type_11 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_11 A1 A2. intros. apply trans___type_11_crypt_3;  tauto.
 clear  epsilon_mtestable_old_p__type_11 A1 A2. tauto.
Defined.

Remark rem_1521 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1:term, auto___type_11 X1 -> auto___type_11 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1522 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___type_11 X1 -> auto___def_52 X2 -> auto___type_11 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2.
  cut (auto___type_11 X1 -> auto___type_11 X1). tauto. exact (rem_1521 epsilon_mtestable_old_p__type_11 X1).
Defined.

Remark rem_1523 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X2:term, auto___def_52 X2 -> auto___def_52 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1524 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___type_11 X1 -> auto___def_52 X2 -> auto___def_52 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2.
  cut (auto___def_52 X2 -> auto___def_52 X2). tauto. exact (rem_1523 epsilon_mtestable_old_p__type_11 X2).
Defined.

Remark rem_1525 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___type_11 X1 -> auto___def_52 X2 -> (auto___type_11 X1 /\ auto___def_52 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1 A2.
  cut (auto___type_11 X1). 2:apply (rem_1522 epsilon_mtestable_old_p__type_11 X1 X2);  assumption.
  cut (auto___def_52 X2). 2:apply (rem_1524 epsilon_mtestable_old_p__type_11 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1526 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___type_11 X1 -> auto___def_52 X2 -> auto___type_11 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1 A2.
  case (rem_1525 epsilon_mtestable_old_p__type_11 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_11 A1 A2. intros. apply trans___type_11_crypt_4;  tauto.
 clear  epsilon_mtestable_old_p__type_11 A1 A2. tauto.
Defined.

Remark rem_1527 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1:term, auto___type_7 X1 -> auto___type_7 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1528 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2.
  cut (auto___type_7 X1 -> auto___type_7 X1). tauto. exact (rem_1527 epsilon_mtestable_old_p__type_11 X1).
Defined.

Remark rem_1529 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X2:term, auto___def_44 X2 -> auto___def_44 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1530 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___def_44 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2.
  cut (auto___def_44 X2 -> auto___def_44 X2). tauto. exact (rem_1529 epsilon_mtestable_old_p__type_11 X2).
Defined.

Remark rem_1531 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> (auto___type_7 X1 /\ auto___def_44 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1 A2.
  cut (auto___type_7 X1). 2:apply (rem_1528 epsilon_mtestable_old_p__type_11 X1 X2);  assumption.
  cut (auto___def_44 X2). 2:apply (rem_1530 epsilon_mtestable_old_p__type_11 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1532 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___type_11 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1 A2.
  case (rem_1531 epsilon_mtestable_old_p__type_11 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_11 A1 A2. intros. apply trans___type_11_crypt_5;  tauto.
 clear  epsilon_mtestable_old_p__type_11 A1 A2. tauto.
Defined.

Remark rem_1533 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1534 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2.
  cut (auto_knows_old X1 -> auto_knows_old X1). tauto. exact (rem_1533 epsilon_mtestable_old_p__type_11 X1).
Defined.

Remark rem_1535 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X2:term, auto_knows_old X2 -> auto_knows_old X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1536 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_1535 epsilon_mtestable_old_p__type_11 X2).
Defined.

Remark rem_1537 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> (auto_knows_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_1534 epsilon_mtestable_old_p__type_11 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_1536 epsilon_mtestable_old_p__type_11 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1538 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_11 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1 A2.
  case (rem_1537 epsilon_mtestable_old_p__type_11 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_11 A1 A2. intros. apply trans___type_11_crypt_6;  tauto.
 clear  epsilon_mtestable_old_p__type_11 A1 A2. tauto.
Defined.

Remark rem_1539 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto_testable_old (crypt X1 X2) -> auto___type_11 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intro H. intros.
  elim (rem_79 X1 X2 H);  intros.
  apply (rem_1508 epsilon_mtestable_old_p__type_11 X1 X2);  tauto.
  apply (rem_1514 epsilon_mtestable_old_p__type_11 X1 X2);  tauto.
  apply (rem_1520 epsilon_mtestable_old_p__type_11 X1 X2);  tauto.
  apply (rem_1526 epsilon_mtestable_old_p__type_11 X1 X2);  tauto.
  apply (rem_1532 epsilon_mtestable_old_p__type_11 X1 X2);  tauto.
  apply (rem_1538 epsilon_mtestable_old_p__type_11 X1 X2);  tauto.
Defined.

Remark rem_1540 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_11.  tauto.
Defined.

Remark rem_1541 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> auto___type_11 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11.  case (rem_1540 epsilon_mtestable_old_p__type_11). clear  epsilon_mtestable_old_p__type_11. intros. apply trans___type_11_bob_1;  tauto.
 clear  epsilon_mtestable_old_p__type_11. tauto.
Defined.

Remark rem_1542 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> auto_testable_old bob -> auto___type_11 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intro H. intros.
  elim (rem_83 H);  intros.
  apply (rem_1541 epsilon_mtestable_old_p__type_11);  tauto.
Defined.

Remark rem_1543 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1:term, auto_testable_old X1 -> auto_testable_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1544 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1:term, auto_testable_old X1 -> auto_testable_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1. intros A1.
  cut (auto_testable_old X1). 2:apply (rem_1543 epsilon_mtestable_old_p__type_11 X1);  assumption.
  tauto.
Defined.

Remark rem_1545 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1:term, auto_testable_old X1 -> auto___type_11 (p X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1. intros A1.
  case (rem_1544 epsilon_mtestable_old_p__type_11 X1 A1). clear  epsilon_mtestable_old_p__type_11 A1. intros. apply trans___type_11_p_1;  tauto.
 clear  epsilon_mtestable_old_p__type_11 A1. tauto.
Defined.

Remark rem_1546 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1:term, auto_testable_old (p X1) -> auto___type_11 (p X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1. intro H. intros.
  elim (rem_88 X1 H);  intros.
  apply (rem_1545 epsilon_mtestable_old_p__type_11 X1);  tauto.
Defined.

Remark rem_1547 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> auto___type_11 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11.  case (rem_1540 epsilon_mtestable_old_p__type_11). clear  epsilon_mtestable_old_p__type_11. intros. apply trans___type_11_alice_1;  tauto.
 clear  epsilon_mtestable_old_p__type_11. tauto.
Defined.

Remark rem_1548 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> auto_testable_old alice -> auto___type_11 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intro H. intros.
  elim (rem_91 H);  intros.
  apply (rem_1547 epsilon_mtestable_old_p__type_11);  tauto.
Defined.

Remark rem_1549 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto_testable_old X1 -> auto_knows_old X2 -> auto_testable_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2.
  cut (auto_testable_old X1 -> auto_testable_old X1). tauto. exact (rem_1543 epsilon_mtestable_old_p__type_11 X1).
Defined.

Remark rem_1550 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto_testable_old X1 -> auto_knows_old X2 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_1535 epsilon_mtestable_old_p__type_11 X2).
Defined.

Remark rem_1551 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto_testable_old X1 -> auto_knows_old X2 -> (auto_testable_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1 A2.
  cut (auto_testable_old X1). 2:apply (rem_1549 epsilon_mtestable_old_p__type_11 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_1550 epsilon_mtestable_old_p__type_11 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1552 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto_testable_old X1 -> auto_knows_old X2 -> auto___type_11 (dec X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1 A2.
  case (rem_1551 epsilon_mtestable_old_p__type_11 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_11 A1 A2. intros. apply trans___type_11_dec_1;  tauto.
 clear  epsilon_mtestable_old_p__type_11 A1 A2. tauto.
Defined.

Remark rem_1553 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto_testable_old (dec X1 X2) -> auto___type_11 (dec X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intro H. intros.
  elim (rem_97 X1 X2 H);  intros.
  apply (rem_1552 epsilon_mtestable_old_p__type_11 X1 X2);  tauto.
Defined.

Remark rem_1554 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1:term, auto___def_10 X1 -> auto___def_10 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1555 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_10 X1). tauto. exact (rem_1554 epsilon_mtestable_old_p__type_11 X1).
Defined.

Remark rem_1556 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X2:term, auto___def_11 X2 -> auto___def_11 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1557 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2.
  cut (auto___def_11 X2 -> auto___def_11 X2). tauto. exact (rem_1556 epsilon_mtestable_old_p__type_11 X2).
Defined.

Remark rem_1558 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> (auto___def_10 X1 /\ auto___def_11 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1 A2.
  cut (auto___def_10 X1). 2:apply (rem_1555 epsilon_mtestable_old_p__type_11 X1 X2);  assumption.
  cut (auto___def_11 X2). 2:apply (rem_1557 epsilon_mtestable_old_p__type_11 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1559 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___type_11 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1 A2.
  case (rem_1558 epsilon_mtestable_old_p__type_11 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_11 A1 A2. intros. apply trans___type_11_enc_1;  tauto.
 clear  epsilon_mtestable_old_p__type_11 A1 A2. tauto.
Defined.

Remark rem_1560 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1:term, auto___def_15 X1 -> auto___def_15 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1561 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_15 X1 -> auto___def_16 X2 -> auto___def_15 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2.
  cut (auto___def_15 X1 -> auto___def_15 X1). tauto. exact (rem_1560 epsilon_mtestable_old_p__type_11 X1).
Defined.

Remark rem_1562 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X2:term, auto___def_16 X2 -> auto___def_16 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1563 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_15 X1 -> auto___def_16 X2 -> auto___def_16 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2.
  cut (auto___def_16 X2 -> auto___def_16 X2). tauto. exact (rem_1562 epsilon_mtestable_old_p__type_11 X2).
Defined.

Remark rem_1564 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_15 X1 -> auto___def_16 X2 -> (auto___def_15 X1 /\ auto___def_16 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1 A2.
  cut (auto___def_15 X1). 2:apply (rem_1561 epsilon_mtestable_old_p__type_11 X1 X2);  assumption.
  cut (auto___def_16 X2). 2:apply (rem_1563 epsilon_mtestable_old_p__type_11 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1565 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_15 X1 -> auto___def_16 X2 -> auto___type_11 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1 A2.
  case (rem_1564 epsilon_mtestable_old_p__type_11 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_11 A1 A2. intros. apply trans___type_11_enc_2;  tauto.
 clear  epsilon_mtestable_old_p__type_11 A1 A2. tauto.
Defined.

Remark rem_1566 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1:term, auto___def_19 X1 -> auto___def_19 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1567 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto___def_19 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2.
  cut (auto___def_19 X1 -> auto___def_19 X1). tauto. exact (rem_1566 epsilon_mtestable_old_p__type_11 X1).
Defined.

Remark rem_1568 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X2:term, auto___def_20 X2 -> auto___def_20 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1569 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto___def_20 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2.
  cut (auto___def_20 X2 -> auto___def_20 X2). tauto. exact (rem_1568 epsilon_mtestable_old_p__type_11 X2).
Defined.

Remark rem_1570 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> (auto___def_19 X1 /\ auto___def_20 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1 A2.
  cut (auto___def_19 X1). 2:apply (rem_1567 epsilon_mtestable_old_p__type_11 X1 X2);  assumption.
  cut (auto___def_20 X2). 2:apply (rem_1569 epsilon_mtestable_old_p__type_11 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1571 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto___type_11 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1 A2.
  case (rem_1570 epsilon_mtestable_old_p__type_11 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_11 A1 A2. intros. apply trans___type_11_enc_3;  tauto.
 clear  epsilon_mtestable_old_p__type_11 A1 A2. tauto.
Defined.

Remark rem_1572 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto_testable_old X1 -> auto_knows_old X2 -> auto___type_11 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1 A2.
  case (rem_1551 epsilon_mtestable_old_p__type_11 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_11 A1 A2. intros. apply trans___type_11_enc_4;  tauto.
 clear  epsilon_mtestable_old_p__type_11 A1 A2. tauto.
Defined.

Remark rem_1573 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto_testable_old (enc X1 X2) -> auto___type_11 (enc X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intro H. intros.
  elim (rem_118 X1 X2 H);  intros.
  apply (rem_1559 epsilon_mtestable_old_p__type_11 X1 X2);  tauto.
  apply (rem_1565 epsilon_mtestable_old_p__type_11 X1 X2);  tauto.
  apply (rem_1571 epsilon_mtestable_old_p__type_11 X1 X2);  tauto.
  apply (rem_1572 epsilon_mtestable_old_p__type_11 X1 X2);  tauto.
Defined.

Remark rem_1574 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X2:term, auto_testable_old X2 -> auto_testable_old X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1575 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X2:term, auto_testable_old X2 -> auto_testable_old X2 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X2. intros A1.
  cut (auto_testable_old X2). 2:apply (rem_1574 epsilon_mtestable_old_p__type_11 X2);  assumption.
  tauto.
Defined.

Remark rem_1576 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto_testable_old X2 -> auto___type_11 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1.
  case (rem_1575 epsilon_mtestable_old_p__type_11 X2 A1). clear  epsilon_mtestable_old_p__type_11 A1. intros. apply trans___type_11_cons_1;  tauto.
 clear  epsilon_mtestable_old_p__type_11 A1. tauto.
Defined.

Remark rem_1577 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto_testable_old X1 -> auto___type_11 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1.
  case (rem_1544 epsilon_mtestable_old_p__type_11 X1 A1). clear  epsilon_mtestable_old_p__type_11 A1. intros. apply trans___type_11_cons_2;  tauto.
 clear  epsilon_mtestable_old_p__type_11 A1. tauto.
Defined.

Remark rem_1578 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto_testable_old (cons X1 X2) -> auto___type_11 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intro H. intros.
  elim (rem_124 X1 X2 H);  intros.
  apply (rem_1576 epsilon_mtestable_old_p__type_11 X1 X2);  tauto.
  apply (rem_1577 epsilon_mtestable_old_p__type_11 X1 X2);  tauto.
Defined.

Remark rem_1579 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1:term, auto_testable_old X1 -> auto___type_11 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1. intros A1.
  case (rem_1544 epsilon_mtestable_old_p__type_11 X1 A1). clear  epsilon_mtestable_old_p__type_11 A1. intros. apply trans___type_11_s_1;  tauto.
 clear  epsilon_mtestable_old_p__type_11 A1. tauto.
Defined.

Remark rem_1580 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1:term, auto_testable_old (s X1) -> auto___type_11 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1. intro H. intros.
  elim (rem_127 X1 H);  intros.
  apply (rem_1579 epsilon_mtestable_old_p__type_11 X1);  tauto.
Defined.

Remark rem_1581 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> auto___type_11 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11.  case (rem_1540 epsilon_mtestable_old_p__type_11). clear  epsilon_mtestable_old_p__type_11. intros. apply trans___type_11_i_1;  tauto.
 clear  epsilon_mtestable_old_p__type_11. tauto.
Defined.

Remark rem_1582 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> auto_testable_old i -> auto___type_11 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intro H. intros.
  elim (rem_130 H);  intros.
  apply (rem_1581 epsilon_mtestable_old_p__type_11);  tauto.
Defined.

Remark rem_1583 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> auto___type_11 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11.  case (rem_1540 epsilon_mtestable_old_p__type_11). clear  epsilon_mtestable_old_p__type_11. intros. apply trans___type_11_nil_1;  tauto.
 clear  epsilon_mtestable_old_p__type_11. tauto.
Defined.

Remark rem_1584 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> auto_testable_old nil -> auto___type_11 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intro H. intros.
  elim (rem_133 H);  intros.
  apply (rem_1583 epsilon_mtestable_old_p__type_11);  tauto.
Defined.

Remark rem_1585 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> auto___type_11 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11.  case (rem_1540 epsilon_mtestable_old_p__type_11). clear  epsilon_mtestable_old_p__type_11. intros. apply trans___type_11_server_1;  tauto.
 clear  epsilon_mtestable_old_p__type_11. tauto.
Defined.

Remark rem_1586 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> auto_testable_old server -> auto___type_11 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intro H. intros.
  elim (rem_136 H);  intros.
  apply (rem_1585 epsilon_mtestable_old_p__type_11);  tauto.
Defined.

Remark rem_1587 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1:term, auto___def_60 X1 -> auto___def_60 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1588 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_60 X1 -> auto___type_16 X2 -> auto___def_60 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2.
  cut (auto___def_60 X1 -> auto___def_60 X1). tauto. exact (rem_1587 epsilon_mtestable_old_p__type_11 X1).
Defined.

Remark rem_1589 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X2:term, auto___type_16 X2 -> auto___type_16 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1590 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_60 X1 -> auto___type_16 X2 -> auto___type_16 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2.
  cut (auto___type_16 X2 -> auto___type_16 X2). tauto. exact (rem_1589 epsilon_mtestable_old_p__type_11 X2).
Defined.

Remark rem_1591 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_60 X1 -> auto___type_16 X2 -> (auto___def_60 X1 /\ auto___type_16 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1 A2.
  cut (auto___def_60 X1). 2:apply (rem_1588 epsilon_mtestable_old_p__type_11 X1 X2);  assumption.
  cut (auto___type_16 X2). 2:apply (rem_1590 epsilon_mtestable_old_p__type_11 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1592 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_60 X1 -> auto___type_16 X2 -> auto___type_11 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1 A2.
  case (rem_1591 epsilon_mtestable_old_p__type_11 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_11 A1 A2. intros. apply trans___type_11_key_1;  tauto.
 clear  epsilon_mtestable_old_p__type_11 A1 A2. tauto.
Defined.

Remark rem_1593 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1:term, auto___def_55 X1 -> auto___def_55 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1594 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_4 X2 -> auto___def_55 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2.
  cut (auto___def_55 X1 -> auto___def_55 X1). tauto. exact (rem_1593 epsilon_mtestable_old_p__type_11 X1).
Defined.

Remark rem_1595 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X2:term, auto___def_4 X2 -> auto___def_4 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1596 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_4 X2 -> auto___def_4 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2.
  cut (auto___def_4 X2 -> auto___def_4 X2). tauto. exact (rem_1595 epsilon_mtestable_old_p__type_11 X2).
Defined.

Remark rem_1597 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_4 X2 -> (auto___def_55 X1 /\ auto___def_4 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1 A2.
  cut (auto___def_55 X1). 2:apply (rem_1594 epsilon_mtestable_old_p__type_11 X1 X2);  assumption.
  cut (auto___def_4 X2). 2:apply (rem_1596 epsilon_mtestable_old_p__type_11 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1598 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_4 X2 -> auto___type_11 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1 A2.
  case (rem_1597 epsilon_mtestable_old_p__type_11 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_11 A1 A2. intros. apply trans___type_11_key_2;  tauto.
 clear  epsilon_mtestable_old_p__type_11 A1 A2. tauto.
Defined.

Remark rem_1599 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1:term, auto___def_51 X1 -> auto___def_51 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1600 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto___def_51 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2.
  cut (auto___def_51 X1 -> auto___def_51 X1). tauto. exact (rem_1599 epsilon_mtestable_old_p__type_11 X1).
Defined.

Remark rem_1601 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1602 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_1601 epsilon_mtestable_old_p__type_11 X2).
Defined.

Remark rem_1603 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> (auto___def_51 X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1 A2.
  cut (auto___def_51 X1). 2:apply (rem_1600 epsilon_mtestable_old_p__type_11 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_1602 epsilon_mtestable_old_p__type_11 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1604 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto___type_11 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intros A1 A2.
  case (rem_1603 epsilon_mtestable_old_p__type_11 X1 X2 A1 A2). clear  epsilon_mtestable_old_p__type_11 A1 A2. intros. apply trans___type_11_key_3;  tauto.
 clear  epsilon_mtestable_old_p__type_11 A1 A2. tauto.
Defined.

Remark rem_1605 : (forall X:term, auto_testable_old X -> auto___type_11 X)
    -> forall X1 X2:term, auto_testable_old (key X1 X2) -> auto___type_11 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mtestable_old_p__type_11. intros X1 X2. intro H. intros.
  elim (rem_156 X1 X2 H);  intros.
  apply (rem_1592 epsilon_mtestable_old_p__type_11 X1 X2);  tauto.
  apply (rem_1598 epsilon_mtestable_old_p__type_11 X1 X2);  tauto.
  apply (rem_1604 epsilon_mtestable_old_p__type_11 X1 X2);  tauto.
Defined.

Remark rem_1606 : forall X1:term, auto_testable_old X1 -> auto___type_11 X1. (* Induct. *)
Proof.
  fix epsilon_mtestable_old_p__type_11 1.
  intro X. case X.
  exact (rem_1548 epsilon_mtestable_old_p__type_11 ).
  exact (rem_1542 epsilon_mtestable_old_p__type_11 ).
  intros X1 X2;  exact (rem_1578 epsilon_mtestable_old_p__type_11 X1 X2).
  intros X1 X2;  exact (rem_1539 epsilon_mtestable_old_p__type_11 X1 X2).
  intros X1 X2;  exact (rem_1553 epsilon_mtestable_old_p__type_11 X1 X2).
  intros X1 X2;  exact (rem_1573 epsilon_mtestable_old_p__type_11 X1 X2).
  exact (rem_1582 epsilon_mtestable_old_p__type_11 ).
  intros X1 X2;  exact (rem_1605 epsilon_mtestable_old_p__type_11 X1 X2).
  exact (rem_1584 epsilon_mtestable_old_p__type_11 ).
  intros X1 X2. intro H. elim (rem_170 X1 X2 H).
  intros X1 X2. intro H. elim (rem_160 X1 X2 H).
  intros X1 X2. intro H. elim (rem_158 X1 X2 H).
  intros X1 X2. intro H. elim (rem_167 X1 X2 H).
  intros X1;  exact (rem_1546 epsilon_mtestable_old_p__type_11 X1).
  intros X1 X2. intro H. elim (rem_165 X1 X2 H).
  intros X1 X2. intro H. elim (rem_164 X1 X2 H).
   intro H. elim (rem_166  H).
   intro H. elim (rem_163  H).
  intros X1 X2. intro H. elim (rem_162 X1 X2 H).
  intros X1 X2. intro H. elim (rem_161 X1 X2 H).
  intros X1;  exact (rem_1580 epsilon_mtestable_old_p__type_11 X1).
  exact (rem_1586 epsilon_mtestable_old_p__type_11 ).
  intros X1 X2. intro H. elim (rem_169 X1 X2 H).
  intros X1 X2. intro H. elim (rem_159 X1 X2 H).
   intro H. elim (rem_168  H).
Qed.

Remark rem_1607 : (forall X:term, auto___type_22 X -> auto___type_20 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1608 : (forall X:term, auto___type_22 X -> auto___type_20 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_22_p__type_20. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_1607 epsilon_m__type_22_p__type_20 X1);  assumption.
  tauto.
Defined.

Remark rem_1609 : (forall X:term, auto___type_22 X -> auto___type_20 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto___type_20 (nonceb_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_22_p__type_20. intros X1 X2. intros A1.
  case (rem_1608 epsilon_m__type_22_p__type_20 X1 A1). clear  epsilon_m__type_22_p__type_20 A1. intros. apply trans___type_20_nonceb_current_1;  tauto.
 clear  epsilon_m__type_22_p__type_20 A1. tauto.
Defined.

Remark rem_1610 : forall X1 X2:term, auto___type_22 (nonceb_current X1 X2) -> or_1
    (auto_knows_current X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1611 : (forall X:term, auto___type_22 X -> auto___type_20 X)
    -> forall X1 X2:term, auto___type_22 (nonceb_current X1 X2) -> auto___type_20 (nonceb_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_22_p__type_20. intros X1 X2. intro H. intros.
  elim (rem_1610 X1 X2 H);  intros.
  apply (rem_1609 epsilon_m__type_22_p__type_20 X1 X2);  tauto.
Defined.

Remark rem_1612 : forall X1 X2:term, auto___type_22 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1613 : forall X1 X2:term, auto___type_22 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1614 : auto___type_22 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1615 : forall X1 X2:term, auto___type_22 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1616 : forall X1 X2:term, auto___type_22 (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1617 : forall X1 X2:term, auto___type_22 (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1618 : forall X1:term, auto___type_22 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1619 : auto___type_22 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1620 : forall X1 X2:term, auto___type_22 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1621 : forall X1 X2:term, auto___type_22 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1622 : auto___type_22 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1623 : auto___type_22 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1624 : forall X1 X2:term, auto___type_22 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1625 : forall X1 X2:term, auto___type_22 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1626 : forall X1 X2:term, auto___type_22 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1627 : forall X1 X2:term, auto___type_22 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1628 : forall X1:term, auto___type_22 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1629 : auto___type_22 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1630 : forall X1 X2:term, auto___type_22 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1631 : auto___type_22 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1632 : auto___type_22 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1633 : auto___type_22 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1634 : forall X1 X2:term, auto___type_22 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1635 : forall X1 X2:term, auto___type_22 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1636 : forall X1:term, auto___type_22 X1 -> auto___type_20 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_22_p__type_20 1.
  intro X. case X.
   intro H. elim (rem_1622  H).
   intro H. elim (rem_1614  H).
  intros X1 X2. intro H. elim (rem_1627 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1612 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1625 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1626 X1 X2 H).
   intro H. elim (rem_1631  H).
  intros X1 X2. intro H. elim (rem_1635 X1 X2 H).
   intro H. elim (rem_1632  H).
  intros X1 X2. intro H. elim (rem_1634 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1615 X1 X2 H).
  intros X1 X2;  exact (rem_1611 epsilon_m__type_22_p__type_20 X1 X2).
  intros X1 X2. intro H. elim (rem_1624 X1 X2 H).
  intros X1. intro H. elim (rem_1618 X1 H).
  intros X1 X2. intro H. elim (rem_1621 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1620 X1 X2 H).
   intro H. elim (rem_1623  H).
   intro H. elim (rem_1619  H).
  intros X1 X2. intro H. elim (rem_1617 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1616 X1 X2 H).
  intros X1. intro H. elim (rem_1628 X1 H).
   intro H. elim (rem_1633  H).
  intros X1 X2. intro H. elim (rem_1630 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1613 X1 X2 H).
   intro H. elim (rem_1629  H).
Qed.

Remark rem_1637 : forall X1 X2:term, auto___type_22 X1 -> auto_knows_current X2 -> auto___type_20 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_22 X1 -> auto___type_20 X1). tauto. exact (rem_1636 X1).
Qed.

Remark rem_1638 : forall X1 X3:term, auto___type_22 X1 -> auto_knows_current X3 -> auto___type_20 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___type_22 X1 -> auto_knows_current X2 -> auto___type_20 X1). tauto. exact (rem_1637 X1 X2).
Qed.

Remark rem_1639 : (forall X:term, auto___def_96 X -> auto___type_20 X)
    -> forall X1:term, auto___type_21 X1 -> auto___type_21 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1640 : (forall X:term, auto___def_96 X -> auto___type_20 X)
    -> forall X1 X2:term, auto___type_21 X1 -> auto___def_98 X2 -> auto___type_21 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_96_p__type_20. intros X1 X2.
  cut (auto___type_21 X1 -> auto___type_21 X1). tauto. exact (rem_1639 epsilon_m__def_96_p__type_20 X1).
Defined.

Remark rem_1641 : (forall X:term, auto___def_96 X -> auto___type_20 X)
    -> forall X2:term, auto___def_98 X2 -> auto___def_98 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1642 : (forall X:term, auto___def_96 X -> auto___type_20 X)
    -> forall X1 X2:term, auto___type_21 X1 -> auto___def_98 X2 -> auto___def_98 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_96_p__type_20. intros X1 X2.
  cut (auto___def_98 X2 -> auto___def_98 X2). tauto. exact (rem_1641 epsilon_m__def_96_p__type_20 X2).
Defined.

Remark rem_1643 : (forall X:term, auto___def_96 X -> auto___type_20 X)
    -> forall X1 X2:term, auto___type_21 X1 -> auto___def_98 X2 -> (auto___type_21 X1 /\ auto___def_98 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_96_p__type_20. intros X1 X2. intros A1 A2.
  cut (auto___type_21 X1). 2:apply (rem_1640 epsilon_m__def_96_p__type_20 X1 X2);  assumption.
  cut (auto___def_98 X2). 2:apply (rem_1642 epsilon_m__def_96_p__type_20 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1644 : (forall X:term, auto___def_96 X -> auto___type_20 X)
    -> forall X1 X2:term, auto___type_21 X1 -> auto___def_98 X2 -> auto___type_20 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_96_p__type_20. intros X1 X2. intros A1 A2.
  case (rem_1643 epsilon_m__def_96_p__type_20 X1 X2 A1 A2). clear  epsilon_m__def_96_p__type_20 A1 A2. intros. apply trans___type_20_cons_1;  tauto.
 clear  epsilon_m__def_96_p__type_20 A1 A2. tauto.
Defined.

Remark rem_1645 : forall X1 X2:term, auto___def_96 (cons X1 X2) -> or_1
    (auto___type_21 X1 /\ auto___def_98 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1646 : (forall X:term, auto___def_96 X -> auto___type_20 X)
    -> forall X1 X2:term, auto___def_96 (cons X1 X2) -> auto___type_20 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_96_p__type_20. intros X1 X2. intro H. intros.
  elim (rem_1645 X1 X2 H);  intros.
  apply (rem_1644 epsilon_m__def_96_p__type_20 X1 X2);  tauto.
Defined.

Remark rem_1647 : forall X1 X2:term, auto___def_96 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1648 : forall X1 X2:term, auto___def_96 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1649 : forall X1 X2:term, auto___def_96 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1650 : auto___def_96 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1651 : forall X1 X2:term, auto___def_96 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1652 : forall X1 X2:term, auto___def_96 (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1653 : forall X1 X2:term, auto___def_96 (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1654 : forall X1:term, auto___def_96 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1655 : auto___def_96 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1656 : forall X1 X2:term, auto___def_96 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1657 : forall X1 X2:term, auto___def_96 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1658 : auto___def_96 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1659 : auto___def_96 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1660 : forall X1 X2:term, auto___def_96 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1661 : forall X1 X2:term, auto___def_96 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1662 : forall X1 X2:term, auto___def_96 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1663 : forall X1:term, auto___def_96 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1664 : auto___def_96 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1665 : forall X1 X2:term, auto___def_96 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1666 : auto___def_96 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1667 : auto___def_96 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1668 : auto___def_96 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1669 : forall X1 X2:term, auto___def_96 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1670 : forall X1 X2:term, auto___def_96 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1671 : forall X1:term, auto___def_96 X1 -> auto___type_20 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_96_p__type_20 1.
  intro X. case X.
   intro H. elim (rem_1658  H).
   intro H. elim (rem_1650  H).
  intros X1 X2;  exact (rem_1646 epsilon_m__def_96_p__type_20 X1 X2).
  intros X1 X2. intro H. elim (rem_1647 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1661 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1662 X1 X2 H).
   intro H. elim (rem_1666  H).
  intros X1 X2. intro H. elim (rem_1670 X1 X2 H).
   intro H. elim (rem_1667  H).
  intros X1 X2. intro H. elim (rem_1669 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1651 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1648 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1660 X1 X2 H).
  intros X1. intro H. elim (rem_1654 X1 H).
  intros X1 X2. intro H. elim (rem_1657 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1656 X1 X2 H).
   intro H. elim (rem_1659  H).
   intro H. elim (rem_1655  H).
  intros X1 X2. intro H. elim (rem_1653 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1652 X1 X2 H).
  intros X1. intro H. elim (rem_1663 X1 H).
   intro H. elim (rem_1668  H).
  intros X1 X2. intro H. elim (rem_1665 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1649 X1 X2 H).
   intro H. elim (rem_1664  H).
Qed.

Remark rem_1672 : forall X1 X2:term, auto___def_96 X1 -> auto_knows_current X2 -> auto___type_20 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_96 X1 -> auto___type_20 X1). tauto. exact (rem_1671 X1).
Qed.

Remark rem_1673 : forall X1 X3:term, auto___def_96 X1 -> auto_knows_current X3 -> auto___type_20 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_96 X1 -> auto_knows_current X2 -> auto___type_20 X1). tauto. exact (rem_1672 X1 X2).
Qed.

Remark rem_1674 : (forall X:term, auto___def_84 X -> auto___type_20 X)
    -> forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1675 : (forall X:term, auto___def_84 X -> auto___type_20 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_84_p__type_20. intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_1674 epsilon_m__def_84_p__type_20 X1).
Defined.

Remark rem_1676 : (forall X:term, auto___def_84 X -> auto___type_20 X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1677 : (forall X:term, auto___def_84 X -> auto___type_20 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_84_p__type_20. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_1676 epsilon_m__def_84_p__type_20 X2).
Defined.

Remark rem_1678 : (forall X:term, auto___def_84 X -> auto___type_20 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> (auto_agent X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_84_p__type_20. intros X1 X2. intros A1 A2.
  cut (auto_agent X1). 2:apply (rem_1675 epsilon_m__def_84_p__type_20 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_1677 epsilon_m__def_84_p__type_20 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1679 : (forall X:term, auto___def_84 X -> auto___type_20 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_20 (noncea_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_84_p__type_20. intros X1 X2. intros A1 A2.
  case (rem_1678 epsilon_m__def_84_p__type_20 X1 X2 A1 A2). clear  epsilon_m__def_84_p__type_20 A1 A2. intros. apply trans___type_20_noncea_current_1;  tauto.
 clear  epsilon_m__def_84_p__type_20 A1 A2. tauto.
Defined.

Remark rem_1680 : forall X1 X2:term, auto___def_84 (noncea_current X1 X2) -> or_1
    (auto_agent X1 /\ auto_agent X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1681 : (forall X:term, auto___def_84 X -> auto___type_20 X)
    -> forall X1 X2:term, auto___def_84 (noncea_current X1 X2) -> auto___type_20 (noncea_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_84_p__type_20. intros X1 X2. intro H. intros.
  elim (rem_1680 X1 X2 H);  intros.
  apply (rem_1679 epsilon_m__def_84_p__type_20 X1 X2);  tauto.
Defined.

Remark rem_1682 : forall X1 X2:term, auto___def_84 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1683 : forall X1 X2:term, auto___def_84 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1684 : forall X1 X2:term, auto___def_84 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1685 : auto___def_84 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1686 : forall X1 X2:term, auto___def_84 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1687 : forall X1 X2:term, auto___def_84 (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1688 : forall X1 X2:term, auto___def_84 (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1689 : forall X1:term, auto___def_84 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1690 : auto___def_84 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1691 : forall X1 X2:term, auto___def_84 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1692 : forall X1 X2:term, auto___def_84 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1693 : auto___def_84 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1694 : auto___def_84 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1695 : forall X1 X2:term, auto___def_84 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1696 : forall X1 X2:term, auto___def_84 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1697 : forall X1 X2:term, auto___def_84 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1698 : forall X1 X2:term, auto___def_84 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1699 : forall X1:term, auto___def_84 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1700 : auto___def_84 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1701 : forall X1 X2:term, auto___def_84 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1702 : auto___def_84 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1703 : auto___def_84 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1704 : auto___def_84 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1705 : forall X1 X2:term, auto___def_84 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1706 : forall X1:term, auto___def_84 X1 -> auto___type_20 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_84_p__type_20 1.
  intro X. case X.
   intro H. elim (rem_1693  H).
   intro H. elim (rem_1685  H).
  intros X1 X2. intro H. elim (rem_1698 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1682 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1696 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1697 X1 X2 H).
   intro H. elim (rem_1702  H).
  intros X1 X2. intro H. elim (rem_1705 X1 X2 H).
   intro H. elim (rem_1703  H).
  intros X1 X2;  exact (rem_1681 epsilon_m__def_84_p__type_20 X1 X2).
  intros X1 X2. intro H. elim (rem_1686 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1683 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1695 X1 X2 H).
  intros X1. intro H. elim (rem_1689 X1 H).
  intros X1 X2. intro H. elim (rem_1692 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1691 X1 X2 H).
   intro H. elim (rem_1694  H).
   intro H. elim (rem_1690  H).
  intros X1 X2. intro H. elim (rem_1688 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1687 X1 X2 H).
  intros X1. intro H. elim (rem_1699 X1 H).
   intro H. elim (rem_1704  H).
  intros X1 X2. intro H. elim (rem_1701 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1684 X1 X2 H).
   intro H. elim (rem_1700  H).
Qed.

Remark rem_1707 : forall X1 X2:term, auto___def_84 X1 -> auto_knows_current X2 -> auto___type_20 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_84 X1 -> auto___type_20 X1). tauto. exact (rem_1706 X1).
Qed.

Remark rem_1708 : forall X1 X3:term, auto___def_84 X1 -> auto_knows_current X3 -> auto___type_20 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_84 X1 -> auto_knows_current X2 -> auto___type_20 X1). tauto. exact (rem_1707 X1 X2).
Qed.

Remark rem_1709 : forall X1 X2 X3:term, auto___def_87 X1 X2 X3 -> or_3
    (auto___type_22 X2 /\ auto_knows_current X3)
    (auto___def_96 X2 /\ auto_knows_current X3)
    (auto___def_84 X2 /\ auto_knows_current X3)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_1710 : forall X1 X2 X3:term, auto___def_87 X2 X1 X3 -> auto___type_20 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1709 X2 X1 X3 H);  intros.
  apply (rem_1638 X1 X3);  tauto.
  apply (rem_1673 X1 X3);  tauto.
  apply (rem_1708 X1 X3);  tauto.
Qed.

Remark rem_1711 : auto___def_55 prv. (* Deduce positive atom. *)
Proof.
   case rem_855. intros. apply trans___def_55_prv_1;  tauto.
 tauto.
Qed.

Remark rem_1712 : forall X1 X2:term, auto___def_49 X2 X1 -> auto___type_10 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_10_1. Qed.

Remark rem_1713 : forall X1 X3:term, auto___def_75 X3 -> auto_knows_current X1 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X3.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_288 X1).
Qed.

Remark rem_1714 : forall X1 X3:term, auto___def_75 X3 -> auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X3. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_1713 X1 X3);  assumption.
  tauto.
Qed.

Remark rem_1715 : forall X1 X2 X3:term, auto___def_75 X3 -> auto_knows_current X1 -> auto___def_77 (r_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2.
  case (rem_1714 X1 X3 A1 A2). clear  A1 A2. intros. apply trans___def_77_r_current_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1716 : forall X1 X3:term, auto___def_79 X3 -> auto_knows_current X1 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X3.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_288 X1).
Qed.

Remark rem_1717 : forall X1 X3:term, auto___def_79 X3 -> auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X3. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_1716 X1 X3);  assumption.
  tauto.
Qed.

Remark rem_1718 : forall X1 X2 X3:term, auto___def_79 X3 -> auto_knows_current X1 -> auto___def_77 (r_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2.
  case (rem_1717 X1 X3 A1 A2). clear  A1 A2. intros. apply trans___def_77_r_current_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1719 : (forall X:term, auto_agent X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_pknows_current.  tauto.
Defined.

Remark rem_1720 : (forall X:term, auto_agent X -> auto_knows_current X)
    -> auto_knows_current bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_pknows_current.  case (rem_1719 epsilon_magent_pknows_current). clear  epsilon_magent_pknows_current. intros. apply trans_knows_current_bob_1;  tauto.
 clear  epsilon_magent_pknows_current. tauto.
Defined.

Remark rem_1721 : (forall X:term, auto_agent X -> auto_knows_current X)
    -> auto_agent bob -> auto_knows_current bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_pknows_current. intro H. intros.
  elim (rem_1083 H);  intros.
  apply (rem_1720 epsilon_magent_pknows_current);  tauto.
Defined.

Remark rem_1722 : (forall X:term, auto_agent X -> auto_knows_current X)
    -> auto_knows_current alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_pknows_current.  case (rem_1719 epsilon_magent_pknows_current). clear  epsilon_magent_pknows_current. intros. apply trans_knows_current_alice_1;  tauto.
 clear  epsilon_magent_pknows_current. tauto.
Defined.

Remark rem_1723 : (forall X:term, auto_agent X -> auto_knows_current X)
    -> auto_agent alice -> auto_knows_current alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_pknows_current. intro H. intros.
  elim (rem_1086 H);  intros.
  apply (rem_1722 epsilon_magent_pknows_current);  tauto.
Defined.

Remark rem_1724 : (forall X:term, auto_agent X -> auto_knows_current X)
    -> auto_knows_current i. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_pknows_current.  case (rem_1719 epsilon_magent_pknows_current). clear  epsilon_magent_pknows_current. intros. apply trans_knows_current_i_1;  tauto.
 clear  epsilon_magent_pknows_current. tauto.
Defined.

Remark rem_1725 : (forall X:term, auto_agent X -> auto_knows_current X)
    -> auto_agent i -> auto_knows_current i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_pknows_current. intro H. intros.
  elim (rem_1089 H);  intros.
  apply (rem_1724 epsilon_magent_pknows_current);  tauto.
Defined.

Remark rem_1726 : (forall X:term, auto_agent X -> auto_knows_current X)
    -> auto_knows_current server. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_pknows_current.  case (rem_1719 epsilon_magent_pknows_current). clear  epsilon_magent_pknows_current. intros. apply trans_knows_current_server_1;  tauto.
 clear  epsilon_magent_pknows_current. tauto.
Defined.

Remark rem_1727 : (forall X:term, auto_agent X -> auto_knows_current X)
    -> auto_agent server -> auto_knows_current server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_pknows_current. intro H. intros.
  elim (rem_1092 H);  intros.
  apply (rem_1726 epsilon_magent_pknows_current);  tauto.
Defined.

Remark rem_1728 : forall X1:term, auto_agent X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_magent_pknows_current 1.
  intro X. case X.
  exact (rem_1723 epsilon_magent_pknows_current ).
  exact (rem_1721 epsilon_magent_pknows_current ).
  intros X1 X2. intro H. elim (rem_1108 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1094 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1106 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1107 X1 X2 H).
  exact (rem_1725 epsilon_magent_pknows_current ).
  intros X1 X2. intro H. elim (rem_1114 X1 X2 H).
   intro H. elim (rem_1112  H).
  intros X1 X2. intro H. elim (rem_1113 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1097 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1095 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1105 X1 X2 H).
  intros X1. intro H. elim (rem_1100 X1 H).
  intros X1 X2. intro H. elim (rem_1103 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1102 X1 X2 H).
   intro H. elim (rem_1104  H).
   intro H. elim (rem_1101  H).
  intros X1 X2. intro H. elim (rem_1099 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1098 X1 X2 H).
  intros X1. intro H. elim (rem_1109 X1 H).
  exact (rem_1727 epsilon_magent_pknows_current ).
  intros X1 X2. intro H. elim (rem_1111 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1096 X1 X2 H).
   intro H. elim (rem_1110  H).
Qed.

Remark rem_1729 : forall X1 X2 X3:term, auto___def_71 X3 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_agent X1 -> auto_knows_current X1). tauto. exact (rem_1728 X1).
Qed.

Remark rem_1730 : forall X1 X2 X3:term, auto___def_71 X3 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  cut (auto_knows_current X1). 2:apply (rem_1729 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_1731 : forall X1 X2 X3:term, auto___def_71 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_77 (r_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  case (rem_1730 X1 X2 X3 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_77_r_current_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1732 : forall X1 X2 X3:term, auto_agent X2 -> auto___def_71 X3 -> auto_agent X1 -> auto___def_77 (r_current X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_71 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_77 (r_current X1 X2)). tauto. exact (rem_1731 X1 X2 X3).
Qed.

Remark rem_1733 : forall X1 X2 X3:term, auto___def_74 X2 X3 X1 -> auto___def_77 (r_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_830 X2 X3 X1 H);  intros.
  apply (rem_1715 X1 X2 X3);  tauto.
  apply (rem_1718 X1 X2 X3);  tauto.
  apply (rem_1732 X1 X2 X3);  tauto.
Qed.

Remark rem_1734 : forall X1 X2:term, auto___def_47 X2 X1 -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1.
  tauto.
Qed.

Remark rem_1735 : forall X1 X2:term, auto___def_47 X2 X1 -> auto___def_48 (r_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1.
  case (rem_1734 X1 X2 A1). clear  A1. intros. apply trans___def_48_r_old_1;  tauto.
 clear  A1. tauto.
Qed.

Remark rem_1736 : auto___def_9 nil. (* Deduce positive atom. *)
Proof.
   case rem_855. intros. apply trans___def_9_nil_1;  tauto.
 tauto.
Qed.

Remark rem_1737 : auto___def_114 prv. (* Deduce positive atom. *)
Proof.
   case rem_855. intros. apply trans___def_114_prv_1;  tauto.
 tauto.
Qed.

Remark rem_1738 : auto___def_112 pub. (* Deduce positive atom. *)
Proof.
   case rem_855. intros. apply trans___def_112_pub_1;  tauto.
 tauto.
Qed.

Remark rem_1739 : (forall X:term, auto___def_62 X -> auto___def_66 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_62_p__def_66.  tauto.
Defined.

Remark rem_1740 : (forall X:term, auto___def_62 X -> auto___def_66 X)
    -> auto___def_66 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_62_p__def_66.  case (rem_1739 epsilon_m__def_62_p__def_66). clear  epsilon_m__def_62_p__def_66. intros. apply trans___def_66_i_1;  tauto.
 clear  epsilon_m__def_62_p__def_66. tauto.
Defined.

Remark rem_1741 : (forall X:term, auto___def_62 X -> auto___def_66 X)
    -> auto___def_62 i -> auto___def_66 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_62_p__def_66. intro H. intros.
  elim (rem_312 H);  intros.
  apply (rem_1740 epsilon_m__def_62_p__def_66);  tauto.
Defined.

Remark rem_1742 : forall X1:term, auto___def_62 X1 -> auto___def_66 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_62_p__def_66 1.
  intro X. case X.
   intro H. elim (rem_325  H).
   intro H. elim (rem_317  H).
  intros X1 X2. intro H. elim (rem_330 X1 X2 H).
  intros X1 X2. intro H. elim (rem_314 X1 X2 H).
  intros X1 X2. intro H. elim (rem_328 X1 X2 H).
  intros X1 X2. intro H. elim (rem_329 X1 X2 H).
  exact (rem_1741 epsilon_m__def_62_p__def_66 ).
  intros X1 X2. intro H. elim (rem_337 X1 X2 H).
   intro H. elim (rem_334  H).
  intros X1 X2. intro H. elim (rem_336 X1 X2 H).
  intros X1 X2. intro H. elim (rem_318 X1 X2 H).
  intros X1 X2. intro H. elim (rem_315 X1 X2 H).
  intros X1 X2. intro H. elim (rem_327 X1 X2 H).
  intros X1. intro H. elim (rem_321 X1 H).
  intros X1 X2. intro H. elim (rem_324 X1 X2 H).
  intros X1 X2. intro H. elim (rem_323 X1 X2 H).
   intro H. elim (rem_326  H).
   intro H. elim (rem_322  H).
  intros X1 X2. intro H. elim (rem_320 X1 X2 H).
  intros X1 X2. intro H. elim (rem_319 X1 X2 H).
  intros X1. intro H. elim (rem_331 X1 H).
   intro H. elim (rem_335  H).
  intros X1 X2. intro H. elim (rem_333 X1 X2 H).
  intros X1 X2. intro H. elim (rem_316 X1 X2 H).
   intro H. elim (rem_332  H).
Qed.

Remark rem_1743 : forall X1:term, auto___def_61 pub -> auto___def_62 X1 -> auto___def_66 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1.
  cut (auto___def_62 X1 -> auto___def_66 X1). tauto. exact (rem_1742 X1).
Qed.

Remark rem_1744 : (forall X:term, auto_agent X -> auto___def_66 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p__def_66.  tauto.
Defined.

Remark rem_1745 : (forall X:term, auto_agent X -> auto___def_66 X)
    -> auto___def_66 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__def_66.  case (rem_1744 epsilon_magent_p__def_66). clear  epsilon_magent_p__def_66. intros. apply trans___def_66_bob_1;  tauto.
 clear  epsilon_magent_p__def_66. tauto.
Defined.

Remark rem_1746 : (forall X:term, auto_agent X -> auto___def_66 X)
    -> auto_agent bob -> auto___def_66 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__def_66. intro H. intros.
  elim (rem_1083 H);  intros.
  apply (rem_1745 epsilon_magent_p__def_66);  tauto.
Defined.

Remark rem_1747 : (forall X:term, auto_agent X -> auto___def_66 X)
    -> auto___def_66 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__def_66.  case (rem_1744 epsilon_magent_p__def_66). clear  epsilon_magent_p__def_66. intros. apply trans___def_66_alice_1;  tauto.
 clear  epsilon_magent_p__def_66. tauto.
Defined.

Remark rem_1748 : (forall X:term, auto_agent X -> auto___def_66 X)
    -> auto_agent alice -> auto___def_66 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__def_66. intro H. intros.
  elim (rem_1086 H);  intros.
  apply (rem_1747 epsilon_magent_p__def_66);  tauto.
Defined.

Remark rem_1749 : (forall X:term, auto_agent X -> auto___def_66 X)
    -> auto___def_66 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__def_66.  case (rem_1744 epsilon_magent_p__def_66). clear  epsilon_magent_p__def_66. intros. apply trans___def_66_i_1;  tauto.
 clear  epsilon_magent_p__def_66. tauto.
Defined.

Remark rem_1750 : (forall X:term, auto_agent X -> auto___def_66 X)
    -> auto_agent i -> auto___def_66 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__def_66. intro H. intros.
  elim (rem_1089 H);  intros.
  apply (rem_1749 epsilon_magent_p__def_66);  tauto.
Defined.

Remark rem_1751 : (forall X:term, auto_agent X -> auto___def_66 X)
    -> auto___def_66 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__def_66.  case (rem_1744 epsilon_magent_p__def_66). clear  epsilon_magent_p__def_66. intros. apply trans___def_66_server_1;  tauto.
 clear  epsilon_magent_p__def_66. tauto.
Defined.

Remark rem_1752 : (forall X:term, auto_agent X -> auto___def_66 X)
    -> auto_agent server -> auto___def_66 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__def_66. intro H. intros.
  elim (rem_1092 H);  intros.
  apply (rem_1751 epsilon_magent_p__def_66);  tauto.
Defined.

Remark rem_1753 : forall X1:term, auto_agent X1 -> auto___def_66 X1. (* Induct. *)
Proof.
  fix epsilon_magent_p__def_66 1.
  intro X. case X.
  exact (rem_1748 epsilon_magent_p__def_66 ).
  exact (rem_1746 epsilon_magent_p__def_66 ).
  intros X1 X2. intro H. elim (rem_1108 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1094 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1106 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1107 X1 X2 H).
  exact (rem_1750 epsilon_magent_p__def_66 ).
  intros X1 X2. intro H. elim (rem_1114 X1 X2 H).
   intro H. elim (rem_1112  H).
  intros X1 X2. intro H. elim (rem_1113 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1097 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1095 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1105 X1 X2 H).
  intros X1. intro H. elim (rem_1100 X1 H).
  intros X1 X2. intro H. elim (rem_1103 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1102 X1 X2 H).
   intro H. elim (rem_1104  H).
   intro H. elim (rem_1101  H).
  intros X1 X2. intro H. elim (rem_1099 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1098 X1 X2 H).
  intros X1. intro H. elim (rem_1109 X1 H).
  exact (rem_1752 epsilon_magent_p__def_66 ).
  intros X1 X2. intro H. elim (rem_1111 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1096 X1 X2 H).
   intro H. elim (rem_1110  H).
Qed.

Remark rem_1754 : forall X1:term, auto___def_51 pub -> auto_agent X1 -> auto___def_66 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1.
  cut (auto_agent X1 -> auto___def_66 X1). tauto. exact (rem_1753 X1).
Qed.

Remark rem_1755 : (forall X:term, auto___def_13 X -> auto___def_66 X)
    -> forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1756 : (forall X:term, auto___def_13 X -> auto___def_66 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_13_p__def_66. intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_1755 epsilon_m__def_13_p__def_66 X1).
Defined.

Remark rem_1757 : (forall X:term, auto___def_13 X -> auto___def_66 X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1758 : (forall X:term, auto___def_13 X -> auto___def_66 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_13_p__def_66. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_1757 epsilon_m__def_13_p__def_66 X2).
Defined.

Remark rem_1759 : (forall X:term, auto___def_13 X -> auto___def_66 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> (auto_agent X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_13_p__def_66. intros X1 X2. intros A1 A2.
  cut (auto_agent X1). 2:apply (rem_1756 epsilon_m__def_13_p__def_66 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_1758 epsilon_m__def_13_p__def_66 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1760 : (forall X:term, auto___def_13 X -> auto___def_66 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___def_66 (session_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_13_p__def_66. intros X1 X2. intros A1 A2.
  case (rem_1759 epsilon_m__def_13_p__def_66 X1 X2 A1 A2). clear  epsilon_m__def_13_p__def_66 A1 A2. intros. apply trans___def_66_session_old_1;  tauto.
 clear  epsilon_m__def_13_p__def_66 A1 A2. tauto.
Defined.

Remark rem_1761 : forall X1 X2:term, auto___def_13 (session_old X1 X2) -> or_1
    (auto_agent X1 /\ auto_agent X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1762 : (forall X:term, auto___def_13 X -> auto___def_66 X)
    -> forall X1 X2:term, auto___def_13 (session_old X1 X2) -> auto___def_66 (session_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_13_p__def_66. intros X1 X2. intro H. intros.
  elim (rem_1761 X1 X2 H);  intros.
  apply (rem_1760 epsilon_m__def_13_p__def_66 X1 X2);  tauto.
Defined.

Remark rem_1763 : forall X1 X2:term, auto___def_13 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1764 : forall X1 X2:term, auto___def_13 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1765 : auto___def_13 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1766 : forall X1 X2:term, auto___def_13 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1767 : forall X1 X2:term, auto___def_13 (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1768 : forall X1 X2:term, auto___def_13 (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1769 : forall X1:term, auto___def_13 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1770 : auto___def_13 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1771 : forall X1 X2:term, auto___def_13 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1772 : forall X1 X2:term, auto___def_13 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1773 : auto___def_13 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1774 : auto___def_13 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1775 : forall X1 X2:term, auto___def_13 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1776 : forall X1 X2:term, auto___def_13 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1777 : forall X1 X2:term, auto___def_13 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1778 : forall X1 X2:term, auto___def_13 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1779 : forall X1:term, auto___def_13 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1780 : auto___def_13 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1781 : forall X1 X2:term, auto___def_13 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1782 : auto___def_13 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1783 : auto___def_13 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1784 : auto___def_13 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1785 : forall X1 X2:term, auto___def_13 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1786 : forall X1 X2:term, auto___def_13 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1787 : forall X1:term, auto___def_13 X1 -> auto___def_66 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_13_p__def_66 1.
  intro X. case X.
   intro H. elim (rem_1773  H).
   intro H. elim (rem_1765  H).
  intros X1 X2. intro H. elim (rem_1778 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1763 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1776 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1777 X1 X2 H).
   intro H. elim (rem_1782  H).
  intros X1 X2. intro H. elim (rem_1786 X1 X2 H).
   intro H. elim (rem_1783  H).
  intros X1 X2. intro H. elim (rem_1785 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1766 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1764 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1775 X1 X2 H).
  intros X1. intro H. elim (rem_1769 X1 H).
  intros X1 X2. intro H. elim (rem_1772 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1771 X1 X2 H).
   intro H. elim (rem_1774  H).
   intro H. elim (rem_1770  H).
  intros X1 X2. intro H. elim (rem_1768 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1767 X1 X2 H).
  intros X1. intro H. elim (rem_1779 X1 H).
   intro H. elim (rem_1784  H).
  intros X1 X2. intro H. elim (rem_1781 X1 X2 H).
  intros X1 X2;  exact (rem_1762 epsilon_m__def_13_p__def_66 X1 X2).
   intro H. elim (rem_1780  H).
Qed.

Remark rem_1788 : forall X1:term, auto___def_12 pub -> auto___def_13 X1 -> auto___def_66 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1.
  cut (auto___def_13 X1 -> auto___def_66 X1). tauto. exact (rem_1787 X1).
Qed.

Remark rem_1789 : forall X1:term, auto_knows_current (key pub X1) -> auto___def_66 X1. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_1066 pub X1 H);  intros.
  apply (rem_1743 X1);  tauto.
  apply (rem_1754 X1);  tauto.
  apply (rem_1788 X1);  tauto.
Qed.

Remark rem_1790 : forall X1 X2:term, auto_agent X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_923 X1).
Qed.

Remark rem_1791 : forall X1 X2:term, auto_agent X2 -> auto_agent X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_925 X2).
Qed.

Remark rem_1792 : forall X1 X2:term, auto_agent X2 -> auto_agent X1 -> (auto_agent X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto_agent X1). 2:apply (rem_1790 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_1791 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1793 : forall X1 X2:term, auto_agent X2 -> auto_agent X1 -> auto___def_13 (session_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1792 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_13_session_old_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1794 : forall X1 X3:term, auto___def_19 X3 -> auto_knows_old X1 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X3.
  cut (auto_knows_old X1 -> auto_knows_old X1). tauto. exact (rem_276 X1).
Qed.

Remark rem_1795 : forall X1 X3:term, auto___def_19 X3 -> auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X3. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_1794 X1 X3);  assumption.
  tauto.
Qed.

Remark rem_1796 : forall X1 X2 X3:term, auto___def_19 X3 -> auto_knows_old X1 -> auto___def_17 (r_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2.
  case (rem_1795 X1 X3 A1 A2). clear  A1 A2. intros. apply trans___def_17_r_old_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1797 : (forall X:term, auto_agent X -> auto_knows_old X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_pknows_old.  tauto.
Defined.

Remark rem_1798 : (forall X:term, auto_agent X -> auto_knows_old X)
    -> auto_knows_old bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_pknows_old.  case (rem_1797 epsilon_magent_pknows_old). clear  epsilon_magent_pknows_old. intros. apply trans_knows_old_bob_1;  tauto.
 clear  epsilon_magent_pknows_old. tauto.
Defined.

Remark rem_1799 : (forall X:term, auto_agent X -> auto_knows_old X)
    -> auto_agent bob -> auto_knows_old bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_pknows_old. intro H. intros.
  elim (rem_1083 H);  intros.
  apply (rem_1798 epsilon_magent_pknows_old);  tauto.
Defined.

Remark rem_1800 : (forall X:term, auto_agent X -> auto_knows_old X)
    -> auto_knows_old alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_pknows_old.  case (rem_1797 epsilon_magent_pknows_old). clear  epsilon_magent_pknows_old. intros. apply trans_knows_old_alice_1;  tauto.
 clear  epsilon_magent_pknows_old. tauto.
Defined.

Remark rem_1801 : (forall X:term, auto_agent X -> auto_knows_old X)
    -> auto_agent alice -> auto_knows_old alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_pknows_old. intro H. intros.
  elim (rem_1086 H);  intros.
  apply (rem_1800 epsilon_magent_pknows_old);  tauto.
Defined.

Remark rem_1802 : (forall X:term, auto_agent X -> auto_knows_old X)
    -> auto_knows_old i. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_pknows_old.  case (rem_1797 epsilon_magent_pknows_old). clear  epsilon_magent_pknows_old. intros. apply trans_knows_old_i_1;  tauto.
 clear  epsilon_magent_pknows_old. tauto.
Defined.

Remark rem_1803 : (forall X:term, auto_agent X -> auto_knows_old X)
    -> auto_agent i -> auto_knows_old i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_pknows_old. intro H. intros.
  elim (rem_1089 H);  intros.
  apply (rem_1802 epsilon_magent_pknows_old);  tauto.
Defined.

Remark rem_1804 : (forall X:term, auto_agent X -> auto_knows_old X)
    -> auto_knows_old server. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_pknows_old.  case (rem_1797 epsilon_magent_pknows_old). clear  epsilon_magent_pknows_old. intros. apply trans_knows_old_server_1;  tauto.
 clear  epsilon_magent_pknows_old. tauto.
Defined.

Remark rem_1805 : (forall X:term, auto_agent X -> auto_knows_old X)
    -> auto_agent server -> auto_knows_old server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_pknows_old. intro H. intros.
  elim (rem_1092 H);  intros.
  apply (rem_1804 epsilon_magent_pknows_old);  tauto.
Defined.

Remark rem_1806 : forall X1:term, auto_agent X1 -> auto_knows_old X1. (* Induct. *)
Proof.
  fix epsilon_magent_pknows_old 1.
  intro X. case X.
  exact (rem_1801 epsilon_magent_pknows_old ).
  exact (rem_1799 epsilon_magent_pknows_old ).
  intros X1 X2. intro H. elim (rem_1108 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1094 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1106 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1107 X1 X2 H).
  exact (rem_1803 epsilon_magent_pknows_old ).
  intros X1 X2. intro H. elim (rem_1114 X1 X2 H).
   intro H. elim (rem_1112  H).
  intros X1 X2. intro H. elim (rem_1113 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1097 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1095 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1105 X1 X2 H).
  intros X1. intro H. elim (rem_1100 X1 H).
  intros X1 X2. intro H. elim (rem_1103 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1102 X1 X2 H).
   intro H. elim (rem_1104  H).
   intro H. elim (rem_1101  H).
  intros X1 X2. intro H. elim (rem_1099 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1098 X1 X2 H).
  intros X1. intro H. elim (rem_1109 X1 H).
  exact (rem_1805 epsilon_magent_pknows_old ).
  intros X1 X2. intro H. elim (rem_1111 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1096 X1 X2 H).
   intro H. elim (rem_1110  H).
Qed.

Remark rem_1807 : forall X1 X2 X3:term, auto___def_10 X3 -> auto_agent X2 -> auto_agent X1 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_agent X1 -> auto_knows_old X1). tauto. exact (rem_1806 X1).
Qed.

Remark rem_1808 : forall X1 X2 X3:term, auto___def_10 X3 -> auto_agent X2 -> auto_agent X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  cut (auto_knows_old X1). 2:apply (rem_1807 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_1809 : forall X1 X2 X3:term, auto___def_10 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_17 (r_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  case (rem_1808 X1 X2 X3 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_17_r_old_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1810 : forall X1 X2 X3:term, auto_agent X2 -> auto___def_10 X3 -> auto_agent X1 -> auto___def_17 (r_old X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_10 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_17 (r_old X1 X2)). tauto. exact (rem_1809 X1 X2 X3).
Qed.

Remark rem_1811 : forall X1 X3:term, auto___def_15 X3 -> auto_knows_old X1 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X3.
  cut (auto_knows_old X1 -> auto_knows_old X1). tauto. exact (rem_276 X1).
Qed.

Remark rem_1812 : forall X1 X3:term, auto___def_15 X3 -> auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X3. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_1811 X1 X3);  assumption.
  tauto.
Qed.

Remark rem_1813 : forall X1 X2 X3:term, auto___def_15 X3 -> auto_knows_old X1 -> auto___def_17 (r_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2.
  case (rem_1812 X1 X3 A1 A2). clear  A1 A2. intros. apply trans___def_17_r_old_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1814 : forall X1 X2 X3:term, auto___def_14 X1 X2 X3 -> or_3
    (auto___def_19 X2 /\ auto_knows_old X3)
    (auto_agent X1 /\ auto___def_10 X2 /\ auto_agent X3)
    (auto___def_15 X2 /\ auto_knows_old X3)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_1815 : forall X1 X2 X3:term, auto___def_14 X2 X3 X1 -> auto___def_17 (r_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1814 X2 X3 X1 H);  intros.
  apply (rem_1796 X1 X2 X3);  tauto.
  apply (rem_1810 X1 X2 X3);  tauto.
  apply (rem_1813 X1 X2 X3);  tauto.
Qed.

Remark rem_1816 : auto___def_45 sym. (* Deduce positive atom. *)
Proof.
   case rem_855. intros. apply trans___def_45_sym_1;  tauto.
 tauto.
Qed.

Remark rem_1817 : forall X1 X2:term, auto_agent X2 -> auto_agent X1 -> auto___def_72 (passwd_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1792 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_72_passwd_current_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1818 : forall X1 X2:term, auto___def_10 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1819 : forall X1 X2 X3:term, auto___def_10 (crypt X1 (key pub (session_old X3 X2))) -> auto___def_11 (passwd_old X3 X2) -> auto___def_23 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1818 X1 (key pub (session_old X3 X2)) H);  intros.
Qed.

Remark rem_1820 : forall X1 X2 X3:term, auto___def_17 X1 -> auto_agent X2 -> auto_agent X3 -> auto_knows_old X3 -> auto___def_17 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_17 X1 -> auto___def_17 X1). tauto. exact (rem_1302 X1).
Qed.

Remark rem_1821 : forall X1 X2 X3:term, auto___def_17 X1 -> auto_agent X2 -> auto_agent X3 -> auto_knows_old X3 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_925 X2).
Qed.

Remark rem_1822 : forall X1 X2 X3:term, auto___def_17 X1 -> auto_agent X2 -> auto_agent X3 -> auto_knows_old X3 -> auto_agent X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_agent X3 -> auto_agent X3). tauto. exact (rem_1269 X3).
Qed.

Remark rem_1823 : forall X1 X2 X3:term, auto___def_17 X1 -> auto_agent X2 -> auto_agent X3 -> auto_knows_old X3 -> (auto___def_17 X1 /\ auto_agent X2 /\ auto_agent X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  cut (auto___def_17 X1). 2:apply (rem_1820 X1 X2 X3);  assumption.
  cut (auto_agent X2). 2:apply (rem_1821 X1 X2 X3);  assumption.
  cut (auto_agent X3). 2:apply (rem_1822 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_1824 : forall X1 X2 X3:term, auto___def_17 X1 -> auto_agent X2 -> auto_agent X3 -> auto_knows_old X3 -> auto___def_23 X1 X2 X3. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  case (rem_1823 X1 X2 X3 A1 A2 A3 A4). clear  A1 A2 A3 A4. intros. apply trans___def_23_1;  tauto.
 clear  A1 A2 A3 A4. tauto.
Qed.

Remark rem_1825 : forall X1 X2 X3:term, auto_agent X3 -> auto_agent X2 -> auto___def_17 X1 -> auto_knows_old X3 -> auto___def_23 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_17 X1 -> auto_agent X2 -> auto_agent X3 -> auto_knows_old X3 -> auto___def_23 X1 X2 X3). tauto. exact (rem_1824 X1 X2 X3).
Qed.

Remark rem_1826 : forall X1 X2 X3:term, auto___def_13 (session_old X3 X2) -> auto___def_17 X1 -> auto_knows_old X3 -> auto___def_23 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1761 X3 X2 H);  intros.
  apply (rem_1825 X1 X2 X3);  tauto.
Qed.

Remark rem_1827 : forall X1 X2 X3:term, auto___def_12 pub -> auto___def_13 (session_old X3 X2) -> auto___def_17 X1 -> auto_knows_old X3 -> auto___def_23 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_13 (session_old X3 X2) -> auto___def_17 X1 -> auto_knows_old X3 -> auto___def_23 X1 X2 X3). tauto.
  exact (rem_1826 X1 X2 X3).
Qed.

Remark rem_1828 : forall X1 X2 X3:term, auto___def_17 X1 -> auto___type_2 (key pub (session_old X3 X2)) -> auto_knows_old X3 -> auto___def_23 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_1399 pub (session_old X3 X2) H);  intros.
  apply (rem_1827 X1 X2 X3);  tauto.
Qed.

Remark rem_1829 : forall X1 X2 X3:term, auto_knows_old X3 -> auto___def_17 X1 -> auto___type_2 (key pub (session_old X3 X2)) -> auto___def_23 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_17 X1 -> auto___type_2 (key pub (session_old X3 X2)) -> auto_knows_old X3 -> auto___def_23 X1 X2 X3). tauto. exact (rem_1828 X1 X2 X3).
Qed.

Remark rem_1830 : forall X1 X2:term, auto___def_16 (passwd_old X1 X2) -> or_1
    (auto_knows_old X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1831 : forall X1 X2 X3:term, auto___def_16 (passwd_old X3 X2) -> auto___def_17 X1 -> auto___type_2 (key pub (session_old X3 X2)) -> auto___def_23 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1830 X3 X2 H);  intros.
  apply (rem_1829 X1 X2 X3);  tauto.
Qed.

Remark rem_1832 : forall X1 X2 X3:term, auto___def_17 X1 -> auto___type_2 (key pub (session_old X3 X2)) -> auto___def_16 (passwd_old X3 X2) -> auto___def_23 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_16 (passwd_old X3 X2) -> auto___def_17 X1 -> auto___type_2 (key pub (session_old X3 X2)) -> auto___def_23 X1 X2 X3). tauto. exact (rem_1831 X1 X2 X3).
Qed.

Remark rem_1833 : forall X1 X2:term, auto___def_15 (crypt X1 X2) -> or_1
    (auto___def_17 X1 /\ auto___type_2 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1834 : forall X1 X2 X3:term, auto___def_15 (crypt X1 (key pub (session_old X3 X2))) -> auto___def_16 (passwd_old X3 X2) -> auto___def_23 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1833 X1 (key pub (session_old X3 X2)) H);  intros.
  apply (rem_1832 X1 X2 X3);  tauto.
Qed.

Remark rem_1835 : forall X1 X2 X3:term, auto___def_21 X1 -> auto___def_22 (key pub (session_old X3 X2)) -> auto_knows_old X3 -> auto___def_23 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_1407 pub (session_old X3 X2) H);  intros.
Qed.

Remark rem_1836 : forall X1 X2 X3:term, auto_knows_old X3 -> auto___def_21 X1 -> auto___def_22 (key pub (session_old X3 X2)) -> auto___def_23 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_21 X1 -> auto___def_22 (key pub (session_old X3 X2)) -> auto_knows_old X3 -> auto___def_23 X1 X2 X3). tauto. exact (rem_1835 X1 X2 X3).
Qed.

Remark rem_1837 : forall X1 X2:term, auto___def_20 (passwd_old X1 X2) -> or_1
    (auto_knows_old X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1838 : forall X1 X2 X3:term, auto___def_20 (passwd_old X3 X2) -> auto___def_21 X1 -> auto___def_22 (key pub (session_old X3 X2)) -> auto___def_23 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1837 X3 X2 H);  intros.
  apply (rem_1836 X1 X2 X3);  tauto.
Qed.

Remark rem_1839 : forall X1 X2 X3:term, auto___def_21 X1 -> auto___def_22 (key pub (session_old X3 X2)) -> auto___def_20 (passwd_old X3 X2) -> auto___def_23 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_20 (passwd_old X3 X2) -> auto___def_21 X1 -> auto___def_22 (key pub (session_old X3 X2)) -> auto___def_23 X1 X2 X3). tauto. exact (rem_1838 X1 X2 X3).
Qed.

Remark rem_1840 : forall X1 X2:term, auto___def_19 (crypt X1 X2) -> or_1
    (auto___def_21 X1 /\ auto___def_22 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1841 : forall X1 X2 X3:term, auto___def_19 (crypt X1 (key pub (session_old X3 X2))) -> auto___def_20 (passwd_old X3 X2) -> auto___def_23 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1840 X1 (key pub (session_old X3 X2)) H);  intros.
  apply (rem_1839 X1 X2 X3);  tauto.
Qed.

Remark rem_1842 : forall X1 X2 X3:term, auto___def_36 X1 -> auto___def_42 (session_old X3 X2) -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_396 X3 X2 H);  intros.
Qed.

Remark rem_1843 : forall X1 X2 X3:term, auto___def_36 X1 -> auto___def_41 pub -> auto___def_42 (session_old X3 X2) -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_36 X1 -> auto___def_42 (session_old X3 X2) -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3). tauto.
  exact (rem_1842 X1 X2 X3).
Qed.

Remark rem_1844 : forall X1 X2 X3:term, auto___def_41 pub -> auto___def_42 (session_old X3 X2) -> auto___def_36 X1 -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_36 X1 -> auto___def_41 pub -> auto___def_42 (session_old X3 X2) -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3). tauto. exact (rem_1843 X1 X2 X3).
Qed.

Remark rem_1845 : forall X1 X2 X3:term, auto___def_36 X1 -> auto___def_37 (key pub (session_old X3 X2)) -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_1405 pub (session_old X3 X2) H);  intros.
  apply (rem_1844 X1 X2 X3);  tauto.
Qed.

Remark rem_1846 : forall X1 X2 X3:term, auto___def_24 X1 -> auto___type_4 (session_old X3 X2) -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_523 X3 X2 H);  intros.
Qed.

Remark rem_1847 : forall X1 X2 X3:term, auto___def_24 X1 -> auto___def_26 pub -> auto___type_4 (session_old X3 X2) -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_24 X1 -> auto___type_4 (session_old X3 X2) -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3). tauto.
  exact (rem_1846 X1 X2 X3).
Qed.

Remark rem_1848 : forall X1 X2 X3:term, auto___def_26 pub -> auto___type_4 (session_old X3 X2) -> auto___def_24 X1 -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_24 X1 -> auto___def_26 pub -> auto___type_4 (session_old X3 X2) -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3). tauto. exact (rem_1847 X1 X2 X3).
Qed.

Remark rem_1849 : forall X1 X2 X3:term, auto___def_24 X1 -> auto___def_25 (key pub (session_old X3 X2)) -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_1444 pub (session_old X3 X2) H);  intros.
  apply (rem_1848 X1 X2 X3);  tauto.
Qed.

Remark rem_1850 : forall X1 X2 X3:term, auto___type_7 X1 -> auto___type_8 (session_old X3 X2) -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_460 X3 X2 H);  intros.
Qed.

Remark rem_1851 : forall X1 X2 X3:term, auto___def_45 pub -> auto___type_7 X1 -> auto___type_8 (session_old X3 X2) -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___type_7 X1 -> auto___type_8 (session_old X3 X2) -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3). tauto.
  exact (rem_1850 X1 X2 X3).
Qed.

Remark rem_1852 : forall X1 X2 X3:term, auto___def_45 pub -> auto___type_8 (session_old X3 X2) -> auto___type_7 X1 -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_45 pub -> auto___type_7 X1 -> auto___type_8 (session_old X3 X2) -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3). tauto. exact (rem_1851 X1 X2 X3).
Qed.

Remark rem_1853 : forall X1 X2 X3:term, auto___def_44 (key pub (session_old X3 X2)) -> auto___type_7 X1 -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1450 pub (session_old X3 X2) H);  intros.
  apply (rem_1852 X1 X2 X3);  tauto.
Qed.

Remark rem_1854 : forall X1 X2 X3:term, auto___type_7 X1 -> auto___def_44 (key pub (session_old X3 X2)) -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_44 (key pub (session_old X3 X2)) -> auto___type_7 X1 -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3). tauto. exact (rem_1853 X1 X2 X3).
Qed.

Remark rem_1855 : forall X1 X2 X3:term, auto___def_62 (session_old X3 X2) -> auto_knows_old X1 -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_316 X3 X2 H);  intros.
Qed.

Remark rem_1856 : forall X1 X2 X3:term, auto___def_61 pub -> auto___def_62 (session_old X3 X2) -> auto_knows_old X1 -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_62 (session_old X3 X2) -> auto_knows_old X1 -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3). tauto.
  exact (rem_1855 X1 X2 X3).
Qed.

Remark rem_1857 : forall X1 X2 X3:term, auto_agent (session_old X3 X2) -> auto_knows_old X1 -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1096 X3 X2 H);  intros.
Qed.

Remark rem_1858 : forall X1 X2 X3:term, auto___def_51 pub -> auto_agent (session_old X3 X2) -> auto_knows_old X1 -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto_agent (session_old X3 X2) -> auto_knows_old X1 -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3). tauto.
  exact (rem_1857 X1 X2 X3).
Qed.

Remark rem_1859 : forall X1 X2 X3:term, auto_knows_old X1 -> auto_knows_old (key pub (session_old X3 X2)) -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_1361 pub (session_old X3 X2) H);  intros.
  apply (rem_1856 X1 X2 X3);  tauto.
  apply (rem_1858 X1 X2 X3);  tauto.
Qed.

Remark rem_1860 : forall X1 X2:term, auto_knows_old (crypt X1 X2) -> or_4
    (auto___def_36 X1 /\ auto___def_37 X2)
    (auto___def_24 X1 /\ auto___def_25 X2)
    (auto___type_7 X1 /\ auto___def_44 X2)
    (auto_knows_old X1 /\ auto_knows_old X2)
.
Proof.
  intros. inversion H.
  intros. apply or_4_intro_1; tauto.
  intros. apply or_4_intro_2; tauto.
  intros. apply or_4_intro_3; tauto.
  intros. apply or_4_intro_4; tauto.
Qed.

Remark rem_1861 : forall X1 X2 X3:term, auto_knows_old (crypt X1 (key pub (session_old X3 X2))) -> auto_knows_old (passwd_old X3 X2) -> auto___def_23 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1860 X1 (key pub (session_old X3 X2)) H);  intros.
  apply (rem_1845 X1 X2 X3);  tauto.
  apply (rem_1849 X1 X2 X3);  tauto.
  apply (rem_1854 X1 X2 X3);  tauto.
  apply (rem_1859 X1 X2 X3);  tauto.
Qed.

Remark rem_1862 : forall X1 X2 X3:term, auto_knows_old (enc (crypt X1 (key pub (session_old X3 X2))) (passwd_old X3 X2)) -> auto___def_23 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1290 (crypt X1 (key pub (session_old X3 X2))) (passwd_old X3 X2) H);  intros.
  apply (rem_1819 X1 X2 X3);  tauto.
  apply (rem_1834 X1 X2 X3);  tauto.
  apply (rem_1841 X1 X2 X3);  tauto.
  apply (rem_1861 X1 X2 X3);  tauto.
Qed.

Remark rem_1863 : forall X1 X2 X3:term, auto___type_22 X3 -> auto_knows_current X1 -> auto___def_91 (nonceb_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2.
  case (rem_290 X1 X3 A1 A2). clear  A1 A2. intros. apply trans___def_91_nonceb_current_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1864 : forall X1 X2 X3:term, auto___def_96 X3 -> auto_knows_current X1 -> auto___def_91 (nonceb_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2.
  case (rem_293 X1 X3 A1 A2). clear  A1 A2. intros. apply trans___def_91_nonceb_current_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1865 : forall X1 X2 X3:term, auto___def_84 X3 -> auto_knows_current X1 -> auto___def_91 (nonceb_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2.
  case (rem_296 X1 X3 A1 A2). clear  A1 A2. intros. apply trans___def_91_nonceb_current_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1866 : forall X1 X2 X3:term, auto___def_87 X2 X3 X1 -> auto___def_91 (nonceb_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1709 X2 X3 X1 H);  intros.
  apply (rem_1863 X1 X2 X3);  tauto.
  apply (rem_1864 X1 X2 X3);  tauto.
  apply (rem_1865 X1 X2 X3);  tauto.
Qed.

Remark rem_1867 : forall X1:term, auto___def_86 X1 -> auto___def_86 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1868 : forall X1 X2:term, auto___def_86 X1 -> auto___type_19 X2 -> auto___def_86 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_86 X1 -> auto___def_86 X1). tauto. exact (rem_1867 X1).
Qed.

Remark rem_1869 : forall X2:term, auto___type_19 X2 -> auto___type_19 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1870 : forall X1 X2:term, auto___def_86 X1 -> auto___type_19 X2 -> auto___type_19 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_19 X2 -> auto___type_19 X2). tauto. exact (rem_1869 X2).
Qed.

Remark rem_1871 : forall X1 X2:term, auto___def_86 X1 -> auto___type_19 X2 -> (auto___def_86 X1 /\ auto___type_19 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_86 X1). 2:apply (rem_1868 X1 X2);  assumption.
  cut (auto___type_19 X2). 2:apply (rem_1870 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1872 : forall X1 X2:term, auto___def_86 X1 -> auto___type_19 X2 -> auto___def_85 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1871 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_85_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1873 : forall X1 X2:term, auto___type_19 X2 -> auto___def_86 X1 -> auto___def_85 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_86 X1 -> auto___type_19 X2 -> auto___def_85 (key X1 X2)). tauto. exact (rem_1872 X1 X2).
Qed.

Remark rem_1874 : forall X1:term, auto___def_41 X1 -> auto___def_41 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1875 : forall X1 X2:term, auto___def_41 X1 -> auto___def_42 X2 -> auto___def_41 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_41 X1 -> auto___def_41 X1). tauto. exact (rem_1874 X1).
Qed.

Remark rem_1876 : forall X2:term, auto___def_42 X2 -> auto___def_42 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1877 : forall X1 X2:term, auto___def_41 X1 -> auto___def_42 X2 -> auto___def_42 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_42 X2 -> auto___def_42 X2). tauto. exact (rem_1876 X2).
Qed.

Remark rem_1878 : forall X1 X2:term, auto___def_41 X1 -> auto___def_42 X2 -> (auto___def_41 X1 /\ auto___def_42 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_41 X1). 2:apply (rem_1875 X1 X2);  assumption.
  cut (auto___def_42 X2). 2:apply (rem_1877 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1879 : forall X1 X2:term, auto___def_41 X1 -> auto___def_42 X2 -> auto___def_37 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1878 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_37_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1880 : forall X1 X2:term, auto___def_42 X2 -> auto___def_41 X1 -> auto___def_37 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_41 X1 -> auto___def_42 X2 -> auto___def_37 (key X1 X2)). tauto. exact (rem_1879 X1 X2).
Qed.

Remark rem_1881 : auto___def_105 sym. (* Deduce positive atom. *)
Proof.
   case rem_855. intros. apply trans___def_105_sym_1;  tauto.
 tauto.
Qed.

Remark rem_1882 : forall X1:term, auto___def_42 X1 -> auto___def_42 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1883 : forall X1 X2:term, auto___def_36 X2 -> auto___def_41 sym -> auto___def_42 X1 -> auto___def_42 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_42 X1 -> auto___def_42 X1). tauto. exact (rem_1882 X1).
Qed.

Remark rem_1884 : forall X2:term, auto___def_36 X2 -> auto___def_36 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1885 : forall X1 X2:term, auto___def_36 X2 -> auto___def_41 sym -> auto___def_42 X1 -> auto___def_36 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_36 X2 -> auto___def_36 X2). tauto. exact (rem_1884 X2).
Qed.

Remark rem_1886 : forall X1 X2:term, auto___def_36 X2 -> auto___def_41 sym -> auto___def_42 X1 -> (auto___def_42 X1 /\ auto___def_36 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_42 X1). 2:apply (rem_1883 X1 X2);  assumption.
  cut (auto___def_36 X2). 2:apply (rem_1885 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1887 : forall X1 X2:term, auto___def_36 X2 -> auto___def_41 sym -> auto___def_42 X1 -> auto___def_5 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1886 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_5_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1888 : forall X1 X2:term, auto___def_41 sym -> auto___def_42 X1 -> auto___def_36 X2 -> auto___def_5 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_36 X2 -> auto___def_41 sym -> auto___def_42 X1 -> auto___def_5 X1 X2). tauto. exact (rem_1887 X1 X2).
Qed.

Remark rem_1889 : forall X1 X2:term, auto___def_36 X2 -> auto___def_37 (key sym X1) -> auto___def_5 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_1405 sym X1 H);  intros.
  apply (rem_1888 X1 X2);  tauto.
Qed.

Remark rem_1890 : forall X1:term, auto___type_4 X1 -> auto___type_4 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1891 : forall X1 X2:term, auto___def_24 X2 -> auto___def_26 sym -> auto___type_4 X1 -> auto___type_4 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_4 X1 -> auto___type_4 X1). tauto. exact (rem_1890 X1).
Qed.

Remark rem_1892 : forall X2:term, auto___def_24 X2 -> auto___def_24 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1893 : forall X1 X2:term, auto___def_24 X2 -> auto___def_26 sym -> auto___type_4 X1 -> auto___def_24 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_24 X2 -> auto___def_24 X2). tauto. exact (rem_1892 X2).
Qed.

Remark rem_1894 : forall X1 X2:term, auto___def_24 X2 -> auto___def_26 sym -> auto___type_4 X1 -> (auto___type_4 X1 /\ auto___def_24 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___type_4 X1). 2:apply (rem_1891 X1 X2);  assumption.
  cut (auto___def_24 X2). 2:apply (rem_1893 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1895 : forall X1 X2:term, auto___def_24 X2 -> auto___def_26 sym -> auto___type_4 X1 -> auto___def_5 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1894 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_5_3;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1896 : forall X1 X2:term, auto___def_26 sym -> auto___type_4 X1 -> auto___def_24 X2 -> auto___def_5 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_24 X2 -> auto___def_26 sym -> auto___type_4 X1 -> auto___def_5 X1 X2). tauto. exact (rem_1895 X1 X2).
Qed.

Remark rem_1897 : forall X1 X2:term, auto___def_24 X2 -> auto___def_25 (key sym X1) -> auto___def_5 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_1444 sym X1 H);  intros.
  apply (rem_1896 X1 X2);  tauto.
Qed.

Remark rem_1898 : forall X1:term, auto___type_8 X1 -> auto___type_8 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1899 : forall X1 X2:term, auto___def_45 sym -> auto___type_7 X2 -> auto___type_8 X1 -> auto___type_8 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_8 X1 -> auto___type_8 X1). tauto. exact (rem_1898 X1).
Qed.

Remark rem_1900 : forall X2:term, auto___type_7 X2 -> auto___type_7 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1901 : forall X1 X2:term, auto___def_45 sym -> auto___type_7 X2 -> auto___type_8 X1 -> auto___type_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_7 X2 -> auto___type_7 X2). tauto. exact (rem_1900 X2).
Qed.

Remark rem_1902 : forall X1 X2:term, auto___def_45 sym -> auto___type_7 X2 -> auto___type_8 X1 -> (auto___type_8 X1 /\ auto___type_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___type_8 X1). 2:apply (rem_1899 X1 X2);  assumption.
  cut (auto___type_7 X2). 2:apply (rem_1901 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1903 : forall X1 X2:term, auto___def_45 sym -> auto___type_7 X2 -> auto___type_8 X1 -> auto___def_5 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1902 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_5_2;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1904 : forall X1 X2:term, auto___def_45 sym -> auto___type_8 X1 -> auto___type_7 X2 -> auto___def_5 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_45 sym -> auto___type_7 X2 -> auto___type_8 X1 -> auto___def_5 X1 X2). tauto. exact (rem_1903 X1 X2).
Qed.

Remark rem_1905 : forall X1 X2:term, auto___def_44 (key sym X1) -> auto___type_7 X2 -> auto___def_5 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_1450 sym X1 H);  intros.
  apply (rem_1904 X1 X2);  tauto.
Qed.

Remark rem_1906 : forall X1 X2:term, auto___type_7 X2 -> auto___def_44 (key sym X1) -> auto___def_5 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_44 (key sym X1) -> auto___type_7 X2 -> auto___def_5 X1 X2). tauto. exact (rem_1905 X1 X2).
Qed.

Remark rem_1907 : forall X1 X2:term, auto___def_61 sym -> auto___def_62 X1 -> auto_knows_old X2 -> auto___def_5 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_61 sym -> False). tauto.
  exact (rem_1310).
Qed.

Remark rem_1908 : forall X1 X2:term, auto___def_51 sym -> auto_agent X1 -> auto_knows_old X2 -> auto___def_5 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_51 sym -> False). tauto.
  exact (rem_1313).
Qed.

Remark rem_1909 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old (key sym X1) -> auto___def_5 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_1361 sym X1 H);  intros.
  apply (rem_1907 X1 X2);  tauto.
  apply (rem_1908 X1 X2);  tauto.
Qed.

Remark rem_1910 : forall X1 X2:term, auto_knows_old (crypt X2 (key sym X1)) -> auto___def_5 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_1860 X2 (key sym X1) H);  intros.
  apply (rem_1889 X1 X2);  tauto.
  apply (rem_1897 X1 X2);  tauto.
  apply (rem_1906 X1 X2);  tauto.
  apply (rem_1909 X1 X2);  tauto.
Qed.

Remark rem_1911 : forall X1:term, auto___def_112 X1 -> auto___def_112 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1912 : forall X1 X2:term, auto___def_112 X1 -> auto___def_64 X2 -> auto___def_112 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_112 X1 -> auto___def_112 X1). tauto. exact (rem_1911 X1).
Qed.

Remark rem_1913 : forall X2:term, auto___def_64 X2 -> auto___def_64 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1914 : forall X1 X2:term, auto___def_112 X1 -> auto___def_64 X2 -> auto___def_64 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_64 X2 -> auto___def_64 X2). tauto. exact (rem_1913 X2).
Qed.

Remark rem_1915 : forall X1 X2:term, auto___def_112 X1 -> auto___def_64 X2 -> (auto___def_112 X1 /\ auto___def_64 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_112 X1). 2:apply (rem_1912 X1 X2);  assumption.
  cut (auto___def_64 X2). 2:apply (rem_1914 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1916 : forall X1 X2:term, auto___def_112 X1 -> auto___def_64 X2 -> auto___def_111 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1915 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_111_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1917 : forall X1 X2:term, auto___def_64 X2 -> auto___def_112 X1 -> auto___def_111 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_112 X1 -> auto___def_64 X2 -> auto___def_111 (key X1 X2)). tauto. exact (rem_1916 X1 X2).
Qed.

Remark rem_1918 : forall X1 X2 X3 X4:term, auto___def_39 X2 -> auto___def_40 nil -> auto___def_42 X1 -> auto___type_6 (noncea_old X3 X4) -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto___def_42 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_42 X1 -> auto___def_42 X1). tauto. exact (rem_1882 X1).
Qed.

Remark rem_1919 : (forall X:term, auto___def_42 X -> auto___def_17 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1920 : (forall X:term, auto___def_42 X -> auto___def_17 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_42_p__def_17. intros X1. intros A1.
  cut (auto_knows_old X1). 2:apply (rem_1919 epsilon_m__def_42_p__def_17 X1);  assumption.
  tauto.
Defined.

Remark rem_1921 : (forall X:term, auto___def_42 X -> auto___def_17 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto___def_17 (r_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_42_p__def_17. intros X1 X2. intros A1.
  case (rem_1920 epsilon_m__def_42_p__def_17 X1 A1). clear  epsilon_m__def_42_p__def_17 A1. intros. apply trans___def_17_r_old_1;  tauto.
 clear  epsilon_m__def_42_p__def_17 A1. tauto.
Defined.

Remark rem_1922 : (forall X:term, auto___def_42 X -> auto___def_17 X)
    -> forall X1 X2:term, auto___def_42 (r_old X1 X2) -> auto___def_17 (r_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_42_p__def_17. intros X1 X2. intro H. intros.
  elim (rem_392 X1 X2 H);  intros.
  apply (rem_1921 epsilon_m__def_42_p__def_17 X1 X2);  tauto.
Defined.

Remark rem_1923 : forall X1:term, auto___def_42 X1 -> auto___def_17 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_42_p__def_17 1.
  intro X. case X.
   intro H. elim (rem_404  H).
   intro H. elim (rem_397  H).
  intros X1 X2. intro H. elim (rem_409 X1 X2 H).
  intros X1 X2. intro H. elim (rem_394 X1 X2 H).
  intros X1 X2. intro H. elim (rem_407 X1 X2 H).
  intros X1 X2. intro H. elim (rem_408 X1 X2 H).
   intro H. elim (rem_413  H).
  intros X1 X2. intro H. elim (rem_417 X1 X2 H).
   intro H. elim (rem_414  H).
  intros X1 X2. intro H. elim (rem_416 X1 X2 H).
  intros X1 X2. intro H. elim (rem_398 X1 X2 H).
  intros X1 X2. intro H. elim (rem_395 X1 X2 H).
  intros X1 X2. intro H. elim (rem_406 X1 X2 H).
  intros X1. intro H. elim (rem_400 X1 H).
  intros X1 X2. intro H. elim (rem_403 X1 X2 H).
  intros X1 X2. intro H. elim (rem_402 X1 X2 H).
   intro H. elim (rem_405  H).
   intro H. elim (rem_401  H).
  intros X1 X2. intro H. elim (rem_399 X1 X2 H).
  intros X1 X2;  exact (rem_1922 epsilon_m__def_42_p__def_17 X1 X2).
  intros X1. intro H. elim (rem_410 X1 H).
   intro H. elim (rem_415  H).
  intros X1 X2. intro H. elim (rem_412 X1 X2 H).
  intros X1 X2. intro H. elim (rem_396 X1 X2 H).
   intro H. elim (rem_411  H).
Qed.

Remark rem_1924 : forall X1 X2 X3 X4:term, auto___def_39 X2 -> auto___def_40 nil -> auto___def_42 X1 -> auto___type_6 (noncea_old X3 X4) -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto___def_17 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_42 X1 -> auto___def_17 X1). tauto. exact (rem_1923 X1).
Qed.

Remark rem_1925 : forall X2:term, auto___def_39 X2 -> auto___def_39 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1926 : forall X1 X2 X3 X4:term, auto___def_39 X2 -> auto___def_40 nil -> auto___def_42 X1 -> auto___type_6 (noncea_old X3 X4) -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto___def_39 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_39 X2 -> auto___def_39 X2). tauto. exact (rem_1925 X2).
Qed.

Remark rem_1927 : forall X1 X2 X3 X4:term, auto___def_39 X2 -> auto___def_40 nil -> auto___def_42 X1 -> auto___type_6 (noncea_old X3 X4) -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> (auto___def_42 X1 /\ auto___def_17 X1 /\ auto___def_39 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5.
  cut (auto___def_42 X1). 2:apply (rem_1918 X1 X2 X3 X4);  assumption.
  cut (auto___def_17 X1). 2:apply (rem_1924 X1 X2 X3 X4);  assumption.
  cut (auto___def_39 X2). 2:apply (rem_1926 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_1928 : forall X1 X2 X3 X4:term, auto___def_39 X2 -> auto___def_40 nil -> auto___def_42 X1 -> auto___type_6 (noncea_old X3 X4) -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto___def_43 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5.
  case (rem_1927 X1 X2 X3 X4 A1 A2 A3 A4 A5). clear  A1 A2 A3 A4 A5. intros. apply trans___def_43_1;  tauto.
 clear  A1 A2 A3 A4 A5. tauto.
Qed.

Remark rem_1929 : forall X1 X2:term, auto___def_38 (cons X1 X2) -> or_1
    (auto___def_39 X1 /\ auto___def_40 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1930 : forall X1 X2 X3 X4:term, auto___def_38 (cons X2 nil) -> auto___def_42 X1 -> auto___type_6 (noncea_old X3 X4) -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1929 X2 nil H);  intros.
  apply (rem_1928 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1931 : forall X1 X2 X3 X4:term, auto___def_38 (cons X2 nil) -> auto___def_41 sym -> auto___def_42 X1 -> auto___type_6 (noncea_old X3 X4) -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_38 (cons X2 nil) -> auto___def_42 X1 -> auto___type_6 (noncea_old X3 X4) -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto___def_43 X1 X2). tauto.
  exact (rem_1930 X1 X2 X3 X4).
Qed.

Remark rem_1932 : forall X1 X2 X3 X4:term, auto___def_41 sym -> auto___def_42 X1 -> auto___def_38 (cons X2 nil) -> auto___type_6 (noncea_old X3 X4) -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_38 (cons X2 nil) -> auto___def_41 sym -> auto___def_42 X1 -> auto___type_6 (noncea_old X3 X4) -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto___def_43 X1 X2). tauto. exact (rem_1931 X1 X2 X3 X4).
Qed.

Remark rem_1933 : forall X1 X2 X3 X4:term, auto___def_37 (key sym X1) -> auto___def_38 (cons X2 nil) -> auto___type_6 (noncea_old X3 X4) -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1405 sym X1 H);  intros.
  apply (rem_1932 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1934 : forall X1 X2 X3 X4:term, auto___type_6 (noncea_old X3 X4) -> auto___def_38 (cons X2 nil) -> auto___def_37 (key sym X1) -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_37 (key sym X1) -> auto___def_38 (cons X2 nil) -> auto___type_6 (noncea_old X3 X4) -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto___def_43 X1 X2). tauto. exact (rem_1933 X1 X2 X3 X4).
Qed.

Remark rem_1935 : forall X1 X2:term, auto___def_36 (cons X1 X2) -> or_1
    (auto___type_6 X1 /\ auto___def_38 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1936 : forall X1 X2 X3 X4:term, auto___def_36 (cons (noncea_old X3 X4) (cons X2 nil)) -> auto___def_37 (key sym X1) -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1935 (noncea_old X3 X4) (cons X2 nil) H);  intros.
  apply (rem_1934 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1937 : forall X1 X2:term, auto___def_24 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1938 : forall X1 X2 X3 X4:term, auto___def_24 (cons (noncea_old X3 X4) (cons X2 nil)) -> auto___def_25 (key sym X1) -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1937 (noncea_old X3 X4) (cons X2 nil) H);  intros.
Qed.

Remark rem_1939 : forall X1 X2:term, auto___type_7 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1940 : forall X1 X2 X3 X4:term, auto___type_7 (cons (noncea_old X3 X4) (cons X2 nil)) -> auto___type_8 X1 -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1939 (noncea_old X3 X4) (cons X2 nil) H);  intros.
Qed.

Remark rem_1941 : forall X1 X2 X3 X4:term, auto___def_45 sym -> auto___type_7 (cons (noncea_old X3 X4) (cons X2 nil)) -> auto___type_8 X1 -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_7 (cons (noncea_old X3 X4) (cons X2 nil)) -> auto___type_8 X1 -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto___def_43 X1 X2). tauto.
  exact (rem_1940 X1 X2 X3 X4).
Qed.

Remark rem_1942 : forall X1 X2 X3 X4:term, auto___def_45 sym -> auto___type_8 X1 -> auto___type_7 (cons (noncea_old X3 X4) (cons X2 nil)) -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_45 sym -> auto___type_7 (cons (noncea_old X3 X4) (cons X2 nil)) -> auto___type_8 X1 -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto___def_43 X1 X2). tauto. exact (rem_1941 X1 X2 X3 X4).
Qed.

Remark rem_1943 : forall X1 X2 X3 X4:term, auto___def_44 (key sym X1) -> auto___type_7 (cons (noncea_old X3 X4) (cons X2 nil)) -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1450 sym X1 H);  intros.
  apply (rem_1942 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1944 : forall X1 X2 X3 X4:term, auto___type_7 (cons (noncea_old X3 X4) (cons X2 nil)) -> auto___def_44 (key sym X1) -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_44 (key sym X1) -> auto___type_7 (cons (noncea_old X3 X4) (cons X2 nil)) -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto___def_43 X1 X2). tauto. exact (rem_1943 X1 X2 X3 X4).
Qed.

Remark rem_1945 : forall X1 X2 X3 X4:term, auto___def_10 (crypt X1 (key pub (session_old X3 X4))) -> auto___def_11 (passwd_old X3 X4) -> auto_knows_old X2 -> auto_knows_old (key sym X1) -> auto_knows_old (noncea_old X3 X4) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1818 X1 (key pub (session_old X3 X4)) H);  intros.
Qed.

Remark rem_1946 : (forall X:term, auto___def_62 X -> auto___def_17 X -> False)
    -> auto___def_17 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_62_m__def_17. intro H. intros.
  elim (rem_1343 H);  intros.
Defined.

Remark rem_1947 : (forall X:term, auto___def_62 X -> auto___def_17 X -> False)
    -> auto___def_62 i -> auto___def_17 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_62_m__def_17. intro H. intros.
  elim (rem_312 H);  intros.
  apply (rem_1946 epsilon_m__def_62_m__def_17);  tauto.
Defined.

Remark rem_1948 : forall X1:term, auto___def_62 X1 -> auto___def_17 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_62_m__def_17 1.
  intro X. case X.
   intro H. elim (rem_325  H).
   intro H. elim (rem_317  H).
  intros X1 X2. intro H. elim (rem_330 X1 X2 H).
  intros X1 X2. intro H. elim (rem_314 X1 X2 H).
  intros X1 X2. intro H. elim (rem_328 X1 X2 H).
  intros X1 X2. intro H. elim (rem_329 X1 X2 H).
  exact (rem_1947 epsilon_m__def_62_m__def_17 ).
  intros X1 X2. intro H. elim (rem_337 X1 X2 H).
   intro H. elim (rem_334  H).
  intros X1 X2. intro H. elim (rem_336 X1 X2 H).
  intros X1 X2. intro H. elim (rem_318 X1 X2 H).
  intros X1 X2. intro H. elim (rem_315 X1 X2 H).
  intros X1 X2. intro H. elim (rem_327 X1 X2 H).
  intros X1. intro H. elim (rem_321 X1 H).
  intros X1 X2. intro H. elim (rem_324 X1 X2 H).
  intros X1 X2. intro H. elim (rem_323 X1 X2 H).
   intro H. elim (rem_326  H).
   intro H. elim (rem_322  H).
  intros X1 X2. intro H. elim (rem_320 X1 X2 H).
  intros X1 X2. intro H. elim (rem_319 X1 X2 H).
  intros X1. intro H. elim (rem_331 X1 H).
   intro H. elim (rem_335  H).
  intros X1 X2. intro H. elim (rem_333 X1 X2 H).
  intros X1 X2. intro H. elim (rem_316 X1 X2 H).
   intro H. elim (rem_332  H).
Qed.

Remark rem_1949 : forall X1 X2:term, auto___def_17 X1 -> auto___def_61 sym -> auto___def_62 X1 -> auto_knows_old X2 -> auto___def_43 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_1948 X1)). tauto.
Qed.

Remark rem_1950 : forall X1 X2:term, auto___def_61 sym -> auto___def_62 X1 -> auto___def_17 X1 -> auto_knows_old X2 -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_17 X1 -> auto___def_61 sym -> auto___def_62 X1 -> auto_knows_old X2 -> auto___def_43 X1 X2). tauto. exact (rem_1949 X1 X2).
Qed.

Remark rem_1951 : (forall X:term, auto___def_17 X -> auto_agent X -> False)
    -> forall X1 X2:term, auto_agent (r_old X1 X2) -> auto_knows_old X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_17_magent. intros X1 X2. intro H. intros.
  elim (rem_1098 X1 X2 H);  intros.
Defined.

Remark rem_1952 : (forall X:term, auto___def_17 X -> auto_agent X -> False)
    -> forall X1 X2:term, auto___def_17 (r_old X1 X2) -> auto_agent (r_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_17_magent. intros X1 X2. intro H. intros.
  elim (rem_1322 X1 X2 H);  intros.
  apply (rem_1951 epsilon_m__def_17_magent X1 X2);  tauto.
Defined.

Remark rem_1953 : forall X1:term, auto___def_17 X1 -> auto_agent X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_17_magent 1.
  intro X. case X.
   intro H. elim (rem_1334  H).
   intro H. elim (rem_1327  H).
  intros X1 X2. intro H. elim (rem_1339 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1324 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1337 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1338 X1 X2 H).
   intro H. elim (rem_1343  H).
  intros X1 X2. intro H. elim (rem_1347 X1 X2 H).
   intro H. elim (rem_1344  H).
  intros X1 X2. intro H. elim (rem_1346 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1328 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1325 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1336 X1 X2 H).
  intros X1. intro H. elim (rem_1330 X1 H).
  intros X1 X2. intro H. elim (rem_1333 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1332 X1 X2 H).
   intro H. elim (rem_1335  H).
   intro H. elim (rem_1331  H).
  intros X1 X2. intro H. elim (rem_1329 X1 X2 H).
  intros X1 X2;  exact (rem_1952 epsilon_m__def_17_magent X1 X2).
  intros X1. intro H. elim (rem_1340 X1 H).
   intro H. elim (rem_1345  H).
  intros X1 X2. intro H. elim (rem_1342 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1326 X1 X2 H).
   intro H. elim (rem_1341  H).
Qed.

Remark rem_1954 : forall X1 X2:term, auto___def_17 X1 -> auto___def_51 sym -> auto_agent X1 -> auto_knows_old X2 -> auto___def_43 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_1953 X1)). tauto.
Qed.

Remark rem_1955 : forall X1 X2:term, auto___def_51 sym -> auto_agent X1 -> auto___def_17 X1 -> auto_knows_old X2 -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_17 X1 -> auto___def_51 sym -> auto_agent X1 -> auto_knows_old X2 -> auto___def_43 X1 X2). tauto. exact (rem_1954 X1 X2).
Qed.

Remark rem_1956 : forall X1 X2:term, auto___def_17 X1 -> auto_knows_old X2 -> auto_knows_old (key sym X1) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1 H2. intro H. intros.
  elim (rem_1361 sym X1 H);  intros.
  apply (rem_1950 X1 X2);  tauto.
  apply (rem_1955 X1 X2);  tauto.
Qed.

Remark rem_1957 : forall X1 X2 X3 X4:term, auto___def_16 (passwd_old X3 X4) -> auto___def_17 X1 -> auto___type_2 (key pub (session_old X3 X4)) -> auto_knows_old X2 -> auto_knows_old (key sym X1) -> auto_knows_old (noncea_old X3 X4) -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_17 X1 -> auto_knows_old X2 -> auto_knows_old (key sym X1) -> auto___def_43 X1 X2). tauto.
  exact (rem_1956 X1 X2).
Qed.

Remark rem_1958 : forall X1 X2 X3 X4:term, auto___def_17 X1 -> auto___type_2 (key pub (session_old X3 X4)) -> auto___def_16 (passwd_old X3 X4) -> auto_knows_old X2 -> auto_knows_old (key sym X1) -> auto_knows_old (noncea_old X3 X4) -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_16 (passwd_old X3 X4) -> auto___def_17 X1 -> auto___type_2 (key pub (session_old X3 X4)) -> auto_knows_old X2 -> auto_knows_old (key sym X1) -> auto_knows_old (noncea_old X3 X4) -> auto___def_43 X1 X2). tauto. exact (rem_1957 X1 X2 X3 X4).
Qed.

Remark rem_1959 : forall X1 X2 X3 X4:term, auto___def_15 (crypt X1 (key pub (session_old X3 X4))) -> auto___def_16 (passwd_old X3 X4) -> auto_knows_old X2 -> auto_knows_old (key sym X1) -> auto_knows_old (noncea_old X3 X4) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1833 X1 (key pub (session_old X3 X4)) H);  intros.
  apply (rem_1958 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1960 : auto___def_21 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1961 : (forall X:term, auto___def_62 X -> auto___def_21 X -> False)
    -> auto___def_21 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_62_m__def_21. intro H. intros.
  elim (rem_1960 H);  intros.
Defined.

Remark rem_1962 : (forall X:term, auto___def_62 X -> auto___def_21 X -> False)
    -> auto___def_62 i -> auto___def_21 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_62_m__def_21. intro H. intros.
  elim (rem_312 H);  intros.
  apply (rem_1961 epsilon_m__def_62_m__def_21);  tauto.
Defined.

Remark rem_1963 : forall X1:term, auto___def_62 X1 -> auto___def_21 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_62_m__def_21 1.
  intro X. case X.
   intro H. elim (rem_325  H).
   intro H. elim (rem_317  H).
  intros X1 X2. intro H. elim (rem_330 X1 X2 H).
  intros X1 X2. intro H. elim (rem_314 X1 X2 H).
  intros X1 X2. intro H. elim (rem_328 X1 X2 H).
  intros X1 X2. intro H. elim (rem_329 X1 X2 H).
  exact (rem_1962 epsilon_m__def_62_m__def_21 ).
  intros X1 X2. intro H. elim (rem_337 X1 X2 H).
   intro H. elim (rem_334  H).
  intros X1 X2. intro H. elim (rem_336 X1 X2 H).
  intros X1 X2. intro H. elim (rem_318 X1 X2 H).
  intros X1 X2. intro H. elim (rem_315 X1 X2 H).
  intros X1 X2. intro H. elim (rem_327 X1 X2 H).
  intros X1. intro H. elim (rem_321 X1 H).
  intros X1 X2. intro H. elim (rem_324 X1 X2 H).
  intros X1 X2. intro H. elim (rem_323 X1 X2 H).
   intro H. elim (rem_326  H).
   intro H. elim (rem_322  H).
  intros X1 X2. intro H. elim (rem_320 X1 X2 H).
  intros X1 X2. intro H. elim (rem_319 X1 X2 H).
  intros X1. intro H. elim (rem_331 X1 H).
   intro H. elim (rem_335  H).
  intros X1 X2. intro H. elim (rem_333 X1 X2 H).
  intros X1 X2. intro H. elim (rem_316 X1 X2 H).
   intro H. elim (rem_332  H).
Qed.

Remark rem_1964 : forall X1 X2:term, auto___def_21 X1 -> auto___def_61 sym -> auto___def_62 X1 -> auto_knows_old X2 -> auto___def_43 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_1963 X1)). tauto.
Qed.

Remark rem_1965 : forall X1 X2:term, auto___def_61 sym -> auto___def_62 X1 -> auto___def_21 X1 -> auto_knows_old X2 -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_21 X1 -> auto___def_61 sym -> auto___def_62 X1 -> auto_knows_old X2 -> auto___def_43 X1 X2). tauto. exact (rem_1964 X1 X2).
Qed.

Remark rem_1966 : auto___def_21 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1967 : (forall X:term, auto_agent X -> auto___def_21 X -> False)
    -> auto___def_21 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_21. intro H. intros.
  elim (rem_1966 H);  intros.
Defined.

Remark rem_1968 : (forall X:term, auto_agent X -> auto___def_21 X -> False)
    -> auto_agent bob -> auto___def_21 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_21. intro H. intros.
  elim (rem_1083 H);  intros.
  apply (rem_1967 epsilon_magent_m__def_21);  tauto.
Defined.

Remark rem_1969 : auto___def_21 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1970 : (forall X:term, auto_agent X -> auto___def_21 X -> False)
    -> auto___def_21 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_21. intro H. intros.
  elim (rem_1969 H);  intros.
Defined.

Remark rem_1971 : (forall X:term, auto_agent X -> auto___def_21 X -> False)
    -> auto_agent alice -> auto___def_21 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_21. intro H. intros.
  elim (rem_1086 H);  intros.
  apply (rem_1970 epsilon_magent_m__def_21);  tauto.
Defined.

Remark rem_1972 : (forall X:term, auto_agent X -> auto___def_21 X -> False)
    -> auto___def_21 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_21. intro H. intros.
  elim (rem_1960 H);  intros.
Defined.

Remark rem_1973 : (forall X:term, auto_agent X -> auto___def_21 X -> False)
    -> auto_agent i -> auto___def_21 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_21. intro H. intros.
  elim (rem_1089 H);  intros.
  apply (rem_1972 epsilon_magent_m__def_21);  tauto.
Defined.

Remark rem_1974 : auto___def_21 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1975 : (forall X:term, auto_agent X -> auto___def_21 X -> False)
    -> auto___def_21 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_21. intro H. intros.
  elim (rem_1974 H);  intros.
Defined.

Remark rem_1976 : (forall X:term, auto_agent X -> auto___def_21 X -> False)
    -> auto_agent server -> auto___def_21 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_21. intro H. intros.
  elim (rem_1092 H);  intros.
  apply (rem_1975 epsilon_magent_m__def_21);  tauto.
Defined.

Remark rem_1977 : forall X1:term, auto_agent X1 -> auto___def_21 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_magent_m__def_21 1.
  intro X. case X.
  exact (rem_1971 epsilon_magent_m__def_21 ).
  exact (rem_1968 epsilon_magent_m__def_21 ).
  intros X1 X2. intro H. elim (rem_1108 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1094 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1106 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1107 X1 X2 H).
  exact (rem_1973 epsilon_magent_m__def_21 ).
  intros X1 X2. intro H. elim (rem_1114 X1 X2 H).
   intro H. elim (rem_1112  H).
  intros X1 X2. intro H. elim (rem_1113 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1097 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1095 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1105 X1 X2 H).
  intros X1. intro H. elim (rem_1100 X1 H).
  intros X1 X2. intro H. elim (rem_1103 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1102 X1 X2 H).
   intro H. elim (rem_1104  H).
   intro H. elim (rem_1101  H).
  intros X1 X2. intro H. elim (rem_1099 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1098 X1 X2 H).
  intros X1. intro H. elim (rem_1109 X1 H).
  exact (rem_1976 epsilon_magent_m__def_21 ).
  intros X1 X2. intro H. elim (rem_1111 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1096 X1 X2 H).
   intro H. elim (rem_1110  H).
Qed.

Remark rem_1978 : forall X1 X2:term, auto___def_21 X1 -> auto___def_51 sym -> auto_agent X1 -> auto_knows_old X2 -> auto___def_43 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_1977 X1)). tauto.
Qed.

Remark rem_1979 : forall X1 X2:term, auto___def_51 sym -> auto_agent X1 -> auto___def_21 X1 -> auto_knows_old X2 -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_21 X1 -> auto___def_51 sym -> auto_agent X1 -> auto_knows_old X2 -> auto___def_43 X1 X2). tauto. exact (rem_1978 X1 X2).
Qed.

Remark rem_1980 : forall X1 X2:term, auto___def_21 X1 -> auto_knows_old X2 -> auto_knows_old (key sym X1) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1 H2. intro H. intros.
  elim (rem_1361 sym X1 H);  intros.
  apply (rem_1965 X1 X2);  tauto.
  apply (rem_1979 X1 X2);  tauto.
Qed.

Remark rem_1981 : forall X1 X2 X3 X4:term, auto___def_20 (passwd_old X3 X4) -> auto___def_21 X1 -> auto___def_22 (key pub (session_old X3 X4)) -> auto_knows_old X2 -> auto_knows_old (key sym X1) -> auto_knows_old (noncea_old X3 X4) -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_21 X1 -> auto_knows_old X2 -> auto_knows_old (key sym X1) -> auto___def_43 X1 X2). tauto.
  exact (rem_1980 X1 X2).
Qed.

Remark rem_1982 : forall X1 X2 X3 X4:term, auto___def_21 X1 -> auto___def_22 (key pub (session_old X3 X4)) -> auto___def_20 (passwd_old X3 X4) -> auto_knows_old X2 -> auto_knows_old (key sym X1) -> auto_knows_old (noncea_old X3 X4) -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_20 (passwd_old X3 X4) -> auto___def_21 X1 -> auto___def_22 (key pub (session_old X3 X4)) -> auto_knows_old X2 -> auto_knows_old (key sym X1) -> auto_knows_old (noncea_old X3 X4) -> auto___def_43 X1 X2). tauto. exact (rem_1981 X1 X2 X3 X4).
Qed.

Remark rem_1983 : forall X1 X2 X3 X4:term, auto___def_19 (crypt X1 (key pub (session_old X3 X4))) -> auto___def_20 (passwd_old X3 X4) -> auto_knows_old X2 -> auto_knows_old (key sym X1) -> auto_knows_old (noncea_old X3 X4) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1840 X1 (key pub (session_old X3 X4)) H);  intros.
  apply (rem_1982 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1984 : auto___def_36 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1985 : (forall X:term, auto___def_62 X -> auto___def_36 X -> False)
    -> auto___def_36 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_62_m__def_36. intro H. intros.
  elim (rem_1984 H);  intros.
Defined.

Remark rem_1986 : (forall X:term, auto___def_62 X -> auto___def_36 X -> False)
    -> auto___def_62 i -> auto___def_36 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_62_m__def_36. intro H. intros.
  elim (rem_312 H);  intros.
  apply (rem_1985 epsilon_m__def_62_m__def_36);  tauto.
Defined.

Remark rem_1987 : forall X1:term, auto___def_62 X1 -> auto___def_36 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_62_m__def_36 1.
  intro X. case X.
   intro H. elim (rem_325  H).
   intro H. elim (rem_317  H).
  intros X1 X2. intro H. elim (rem_330 X1 X2 H).
  intros X1 X2. intro H. elim (rem_314 X1 X2 H).
  intros X1 X2. intro H. elim (rem_328 X1 X2 H).
  intros X1 X2. intro H. elim (rem_329 X1 X2 H).
  exact (rem_1986 epsilon_m__def_62_m__def_36 ).
  intros X1 X2. intro H. elim (rem_337 X1 X2 H).
   intro H. elim (rem_334  H).
  intros X1 X2. intro H. elim (rem_336 X1 X2 H).
  intros X1 X2. intro H. elim (rem_318 X1 X2 H).
  intros X1 X2. intro H. elim (rem_315 X1 X2 H).
  intros X1 X2. intro H. elim (rem_327 X1 X2 H).
  intros X1. intro H. elim (rem_321 X1 H).
  intros X1 X2. intro H. elim (rem_324 X1 X2 H).
  intros X1 X2. intro H. elim (rem_323 X1 X2 H).
   intro H. elim (rem_326  H).
   intro H. elim (rem_322  H).
  intros X1 X2. intro H. elim (rem_320 X1 X2 H).
  intros X1 X2. intro H. elim (rem_319 X1 X2 H).
  intros X1. intro H. elim (rem_331 X1 H).
   intro H. elim (rem_335  H).
  intros X1 X2. intro H. elim (rem_333 X1 X2 H).
  intros X1 X2. intro H. elim (rem_316 X1 X2 H).
   intro H. elim (rem_332  H).
Qed.

Remark rem_1988 : forall X1 X2:term, auto___def_36 X1 -> auto___def_61 sym -> auto___def_62 X1 -> auto_knows_old X2 -> auto___def_43 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_1987 X1)). tauto.
Qed.

Remark rem_1989 : forall X1 X2:term, auto___def_61 sym -> auto___def_62 X1 -> auto___def_36 X1 -> auto_knows_old X2 -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_36 X1 -> auto___def_61 sym -> auto___def_62 X1 -> auto_knows_old X2 -> auto___def_43 X1 X2). tauto. exact (rem_1988 X1 X2).
Qed.

Remark rem_1990 : auto___def_36 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1991 : (forall X:term, auto_agent X -> auto___def_36 X -> False)
    -> auto___def_36 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_36. intro H. intros.
  elim (rem_1990 H);  intros.
Defined.

Remark rem_1992 : (forall X:term, auto_agent X -> auto___def_36 X -> False)
    -> auto_agent bob -> auto___def_36 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_36. intro H. intros.
  elim (rem_1083 H);  intros.
  apply (rem_1991 epsilon_magent_m__def_36);  tauto.
Defined.

Remark rem_1993 : auto___def_36 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1994 : (forall X:term, auto_agent X -> auto___def_36 X -> False)
    -> auto___def_36 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_36. intro H. intros.
  elim (rem_1993 H);  intros.
Defined.

Remark rem_1995 : (forall X:term, auto_agent X -> auto___def_36 X -> False)
    -> auto_agent alice -> auto___def_36 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_36. intro H. intros.
  elim (rem_1086 H);  intros.
  apply (rem_1994 epsilon_magent_m__def_36);  tauto.
Defined.

Remark rem_1996 : (forall X:term, auto_agent X -> auto___def_36 X -> False)
    -> auto___def_36 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_36. intro H. intros.
  elim (rem_1984 H);  intros.
Defined.

Remark rem_1997 : (forall X:term, auto_agent X -> auto___def_36 X -> False)
    -> auto_agent i -> auto___def_36 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_36. intro H. intros.
  elim (rem_1089 H);  intros.
  apply (rem_1996 epsilon_magent_m__def_36);  tauto.
Defined.

Remark rem_1998 : auto___def_36 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1999 : (forall X:term, auto_agent X -> auto___def_36 X -> False)
    -> auto___def_36 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_36. intro H. intros.
  elim (rem_1998 H);  intros.
Defined.

Remark rem_2000 : (forall X:term, auto_agent X -> auto___def_36 X -> False)
    -> auto_agent server -> auto___def_36 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_36. intro H. intros.
  elim (rem_1092 H);  intros.
  apply (rem_1999 epsilon_magent_m__def_36);  tauto.
Defined.

Remark rem_2001 : forall X1:term, auto_agent X1 -> auto___def_36 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_magent_m__def_36 1.
  intro X. case X.
  exact (rem_1995 epsilon_magent_m__def_36 ).
  exact (rem_1992 epsilon_magent_m__def_36 ).
  intros X1 X2. intro H. elim (rem_1108 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1094 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1106 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1107 X1 X2 H).
  exact (rem_1997 epsilon_magent_m__def_36 ).
  intros X1 X2. intro H. elim (rem_1114 X1 X2 H).
   intro H. elim (rem_1112  H).
  intros X1 X2. intro H. elim (rem_1113 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1097 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1095 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1105 X1 X2 H).
  intros X1. intro H. elim (rem_1100 X1 H).
  intros X1 X2. intro H. elim (rem_1103 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1102 X1 X2 H).
   intro H. elim (rem_1104  H).
   intro H. elim (rem_1101  H).
  intros X1 X2. intro H. elim (rem_1099 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1098 X1 X2 H).
  intros X1. intro H. elim (rem_1109 X1 H).
  exact (rem_2000 epsilon_magent_m__def_36 ).
  intros X1 X2. intro H. elim (rem_1111 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1096 X1 X2 H).
   intro H. elim (rem_1110  H).
Qed.

Remark rem_2002 : forall X1 X2:term, auto___def_36 X1 -> auto___def_51 sym -> auto_agent X1 -> auto_knows_old X2 -> auto___def_43 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2001 X1)). tauto.
Qed.

Remark rem_2003 : forall X1 X2:term, auto___def_51 sym -> auto_agent X1 -> auto___def_36 X1 -> auto_knows_old X2 -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_36 X1 -> auto___def_51 sym -> auto_agent X1 -> auto_knows_old X2 -> auto___def_43 X1 X2). tauto. exact (rem_2002 X1 X2).
Qed.

Remark rem_2004 : forall X1 X2:term, auto___def_36 X1 -> auto_knows_old X2 -> auto_knows_old (key sym X1) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1 H2. intro H. intros.
  elim (rem_1361 sym X1 H);  intros.
  apply (rem_1989 X1 X2);  tauto.
  apply (rem_2003 X1 X2);  tauto.
Qed.

Remark rem_2005 : forall X1 X2 X3 X4:term, auto___def_36 X1 -> auto___def_37 (key pub (session_old X3 X4)) -> auto_knows_old X2 -> auto_knows_old (key sym X1) -> auto_knows_old (noncea_old X3 X4) -> auto_knows_old (passwd_old X3 X4) -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_36 X1 -> auto_knows_old X2 -> auto_knows_old (key sym X1) -> auto___def_43 X1 X2). tauto.
  exact (rem_2004 X1 X2).
Qed.

Remark rem_2006 : (forall X:term, auto___def_24 X -> auto___def_62 X -> False)
    -> forall X1 X2:term, auto___def_62 (noncea_old X1 X2) -> auto_agent X1 -> auto_agent X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_24_m__def_62. intros X1 X2. intro H. intros.
  elim (rem_318 X1 X2 H);  intros.
Defined.

Remark rem_2007 : forall X1 X2:term, auto___def_24 (noncea_old X1 X2) -> or_1
    (auto_agent X1 /\ auto_agent X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2008 : (forall X:term, auto___def_24 X -> auto___def_62 X -> False)
    -> forall X1 X2:term, auto___def_24 (noncea_old X1 X2) -> auto___def_62 (noncea_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_24_m__def_62. intros X1 X2. intro H. intros.
  elim (rem_2007 X1 X2 H);  intros.
  apply (rem_2006 epsilon_m__def_24_m__def_62 X1 X2);  tauto.
Defined.

Remark rem_2009 : forall X1 X2:term, auto___def_24 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2010 : forall X1 X2:term, auto___def_24 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2011 : forall X1 X2:term, auto___def_24 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2012 : auto___def_24 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2013 : forall X1 X2:term, auto___def_24 (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2014 : forall X1 X2:term, auto___def_24 (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2015 : forall X1:term, auto___def_24 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2016 : auto___def_24 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2017 : forall X1 X2:term, auto___def_24 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2018 : forall X1 X2:term, auto___def_24 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2019 : auto___def_24 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2020 : auto___def_24 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2021 : forall X1 X2:term, auto___def_24 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2022 : forall X1 X2:term, auto___def_24 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2023 : forall X1 X2:term, auto___def_24 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2024 : forall X1:term, auto___def_24 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2025 : auto___def_24 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2026 : forall X1 X2:term, auto___def_24 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2027 : auto___def_24 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2028 : auto___def_24 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2029 : auto___def_24 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2030 : forall X1 X2:term, auto___def_24 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2031 : forall X1 X2:term, auto___def_24 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2032 : forall X1:term, auto___def_24 X1 -> auto___def_62 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_24_m__def_62 1.
  intro X. case X.
   intro H. elim (rem_2019  H).
   intro H. elim (rem_2012  H).
  intros X1 X2. intro H. elim (rem_1937 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2009 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2022 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2023 X1 X2 H).
   intro H. elim (rem_2027  H).
  intros X1 X2. intro H. elim (rem_2031 X1 X2 H).
   intro H. elim (rem_2028  H).
  intros X1 X2. intro H. elim (rem_2030 X1 X2 H).
  intros X1 X2;  exact (rem_2008 epsilon_m__def_24_m__def_62 X1 X2).
  intros X1 X2. intro H. elim (rem_2010 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2021 X1 X2 H).
  intros X1. intro H. elim (rem_2015 X1 H).
  intros X1 X2. intro H. elim (rem_2018 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2017 X1 X2 H).
   intro H. elim (rem_2020  H).
   intro H. elim (rem_2016  H).
  intros X1 X2. intro H. elim (rem_2014 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2013 X1 X2 H).
  intros X1. intro H. elim (rem_2024 X1 H).
   intro H. elim (rem_2029  H).
  intros X1 X2. intro H. elim (rem_2026 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2011 X1 X2 H).
   intro H. elim (rem_2025  H).
Qed.

Remark rem_2033 : forall X1 X2:term, auto___def_24 X1 -> auto___def_61 sym -> auto___def_62 X1 -> auto_knows_old X2 -> auto___def_43 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2032 X1)). tauto.
Qed.

Remark rem_2034 : forall X1 X2:term, auto___def_61 sym -> auto___def_62 X1 -> auto___def_24 X1 -> auto_knows_old X2 -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_24 X1 -> auto___def_61 sym -> auto___def_62 X1 -> auto_knows_old X2 -> auto___def_43 X1 X2). tauto. exact (rem_2033 X1 X2).
Qed.

Remark rem_2035 : (forall X:term, auto___def_24 X -> auto_agent X -> False)
    -> forall X1 X2:term, auto_agent (noncea_old X1 X2) -> auto_agent X1 -> auto_agent X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_24_magent. intros X1 X2. intro H. intros.
  elim (rem_1097 X1 X2 H);  intros.
Defined.

Remark rem_2036 : (forall X:term, auto___def_24 X -> auto_agent X -> False)
    -> forall X1 X2:term, auto___def_24 (noncea_old X1 X2) -> auto_agent (noncea_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_24_magent. intros X1 X2. intro H. intros.
  elim (rem_2007 X1 X2 H);  intros.
  apply (rem_2035 epsilon_m__def_24_magent X1 X2);  tauto.
Defined.

Remark rem_2037 : forall X1:term, auto___def_24 X1 -> auto_agent X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_24_magent 1.
  intro X. case X.
   intro H. elim (rem_2019  H).
   intro H. elim (rem_2012  H).
  intros X1 X2. intro H. elim (rem_1937 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2009 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2022 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2023 X1 X2 H).
   intro H. elim (rem_2027  H).
  intros X1 X2. intro H. elim (rem_2031 X1 X2 H).
   intro H. elim (rem_2028  H).
  intros X1 X2. intro H. elim (rem_2030 X1 X2 H).
  intros X1 X2;  exact (rem_2036 epsilon_m__def_24_magent X1 X2).
  intros X1 X2. intro H. elim (rem_2010 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2021 X1 X2 H).
  intros X1. intro H. elim (rem_2015 X1 H).
  intros X1 X2. intro H. elim (rem_2018 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2017 X1 X2 H).
   intro H. elim (rem_2020  H).
   intro H. elim (rem_2016  H).
  intros X1 X2. intro H. elim (rem_2014 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2013 X1 X2 H).
  intros X1. intro H. elim (rem_2024 X1 H).
   intro H. elim (rem_2029  H).
  intros X1 X2. intro H. elim (rem_2026 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2011 X1 X2 H).
   intro H. elim (rem_2025  H).
Qed.

Remark rem_2038 : forall X1 X2:term, auto___def_24 X1 -> auto___def_51 sym -> auto_agent X1 -> auto_knows_old X2 -> auto___def_43 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2037 X1)). tauto.
Qed.

Remark rem_2039 : forall X1 X2:term, auto___def_51 sym -> auto_agent X1 -> auto___def_24 X1 -> auto_knows_old X2 -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_24 X1 -> auto___def_51 sym -> auto_agent X1 -> auto_knows_old X2 -> auto___def_43 X1 X2). tauto. exact (rem_2038 X1 X2).
Qed.

Remark rem_2040 : forall X1 X2:term, auto___def_24 X1 -> auto_knows_old X2 -> auto_knows_old (key sym X1) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1 H2. intro H. intros.
  elim (rem_1361 sym X1 H);  intros.
  apply (rem_2034 X1 X2);  tauto.
  apply (rem_2039 X1 X2);  tauto.
Qed.

Remark rem_2041 : forall X1 X2 X3 X4:term, auto___def_24 X1 -> auto___def_25 (key pub (session_old X3 X4)) -> auto_knows_old X2 -> auto_knows_old (key sym X1) -> auto_knows_old (noncea_old X3 X4) -> auto_knows_old (passwd_old X3 X4) -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_24 X1 -> auto_knows_old X2 -> auto_knows_old (key sym X1) -> auto___def_43 X1 X2). tauto.
  exact (rem_2040 X1 X2).
Qed.

Remark rem_2042 : (forall X:term, auto___type_7 X -> auto___def_62 X -> False)
    -> forall X1 X2:term, auto___def_62 (nonceb_old X1 X2) -> auto_knows_old X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_7_m__def_62. intros X1 X2. intro H. intros.
  elim (rem_327 X1 X2 H);  intros.
Defined.

Remark rem_2043 : forall X1 X2:term, auto___type_7 (nonceb_old X1 X2) -> or_1
    (auto_knows_old X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2044 : (forall X:term, auto___type_7 X -> auto___def_62 X -> False)
    -> forall X1 X2:term, auto___type_7 (nonceb_old X1 X2) -> auto___def_62 (nonceb_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_7_m__def_62. intros X1 X2. intro H. intros.
  elim (rem_2043 X1 X2 H);  intros.
  apply (rem_2042 epsilon_m__type_7_m__def_62 X1 X2);  tauto.
Defined.

Remark rem_2045 : forall X1 X2:term, auto___type_7 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2046 : forall X1 X2:term, auto___type_7 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2047 : forall X1 X2:term, auto___type_7 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2048 : auto___type_7 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2049 : forall X1 X2:term, auto___type_7 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2050 : forall X1 X2:term, auto___type_7 (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2051 : forall X1 X2:term, auto___type_7 (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2052 : forall X1:term, auto___type_7 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2053 : auto___type_7 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2054 : forall X1 X2:term, auto___type_7 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2055 : forall X1 X2:term, auto___type_7 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2056 : auto___type_7 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2057 : auto___type_7 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2058 : forall X1 X2:term, auto___type_7 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2059 : forall X1 X2:term, auto___type_7 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2060 : forall X1:term, auto___type_7 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2061 : auto___type_7 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2062 : forall X1 X2:term, auto___type_7 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2063 : auto___type_7 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2064 : auto___type_7 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2065 : auto___type_7 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2066 : forall X1 X2:term, auto___type_7 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2067 : forall X1 X2:term, auto___type_7 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2068 : forall X1:term, auto___type_7 X1 -> auto___def_62 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__type_7_m__def_62 1.
  intro X. case X.
   intro H. elim (rem_2056  H).
   intro H. elim (rem_2048  H).
  intros X1 X2. intro H. elim (rem_1939 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2045 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2058 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2059 X1 X2 H).
   intro H. elim (rem_2063  H).
  intros X1 X2. intro H. elim (rem_2067 X1 X2 H).
   intro H. elim (rem_2064  H).
  intros X1 X2. intro H. elim (rem_2066 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2049 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2046 X1 X2 H).
  intros X1 X2;  exact (rem_2044 epsilon_m__type_7_m__def_62 X1 X2).
  intros X1. intro H. elim (rem_2052 X1 H).
  intros X1 X2. intro H. elim (rem_2055 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2054 X1 X2 H).
   intro H. elim (rem_2057  H).
   intro H. elim (rem_2053  H).
  intros X1 X2. intro H. elim (rem_2051 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2050 X1 X2 H).
  intros X1. intro H. elim (rem_2060 X1 H).
   intro H. elim (rem_2065  H).
  intros X1 X2. intro H. elim (rem_2062 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2047 X1 X2 H).
   intro H. elim (rem_2061  H).
Qed.

Remark rem_2069 : forall X1 X2:term, auto___def_61 sym -> auto___def_62 X1 -> auto___type_7 X1 -> auto_knows_old X2 -> auto___def_43 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2068 X1)). tauto.
Qed.

Remark rem_2070 : (forall X:term, auto___type_7 X -> auto_agent X -> False)
    -> forall X1 X2:term, auto_agent (nonceb_old X1 X2) -> auto_knows_old X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_7_magent. intros X1 X2. intro H. intros.
  elim (rem_1105 X1 X2 H);  intros.
Defined.

Remark rem_2071 : (forall X:term, auto___type_7 X -> auto_agent X -> False)
    -> forall X1 X2:term, auto___type_7 (nonceb_old X1 X2) -> auto_agent (nonceb_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_7_magent. intros X1 X2. intro H. intros.
  elim (rem_2043 X1 X2 H);  intros.
  apply (rem_2070 epsilon_m__type_7_magent X1 X2);  tauto.
Defined.

Remark rem_2072 : forall X1:term, auto___type_7 X1 -> auto_agent X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__type_7_magent 1.
  intro X. case X.
   intro H. elim (rem_2056  H).
   intro H. elim (rem_2048  H).
  intros X1 X2. intro H. elim (rem_1939 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2045 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2058 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2059 X1 X2 H).
   intro H. elim (rem_2063  H).
  intros X1 X2. intro H. elim (rem_2067 X1 X2 H).
   intro H. elim (rem_2064  H).
  intros X1 X2. intro H. elim (rem_2066 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2049 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2046 X1 X2 H).
  intros X1 X2;  exact (rem_2071 epsilon_m__type_7_magent X1 X2).
  intros X1. intro H. elim (rem_2052 X1 H).
  intros X1 X2. intro H. elim (rem_2055 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2054 X1 X2 H).
   intro H. elim (rem_2057  H).
   intro H. elim (rem_2053  H).
  intros X1 X2. intro H. elim (rem_2051 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2050 X1 X2 H).
  intros X1. intro H. elim (rem_2060 X1 H).
   intro H. elim (rem_2065  H).
  intros X1 X2. intro H. elim (rem_2062 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2047 X1 X2 H).
   intro H. elim (rem_2061  H).
Qed.

Remark rem_2073 : forall X1 X2:term, auto___def_51 sym -> auto___type_7 X1 -> auto_agent X1 -> auto_knows_old X2 -> auto___def_43 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2072 X1)). tauto.
Qed.

Remark rem_2074 : forall X1 X2:term, auto___def_51 sym -> auto_agent X1 -> auto___type_7 X1 -> auto_knows_old X2 -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_51 sym -> auto___type_7 X1 -> auto_agent X1 -> auto_knows_old X2 -> auto___def_43 X1 X2). tauto. exact (rem_2073 X1 X2).
Qed.

Remark rem_2075 : forall X1 X2:term, auto___type_7 X1 -> auto_knows_old X2 -> auto_knows_old (key sym X1) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1 H2. intro H. intros.
  elim (rem_1361 sym X1 H);  intros.
  apply (rem_2069 X1 X2);  tauto.
  apply (rem_2074 X1 X2);  tauto.
Qed.

Remark rem_2076 : forall X1 X2 X3 X4:term, auto___def_44 (key pub (session_old X3 X4)) -> auto___type_7 X1 -> auto_knows_old X2 -> auto_knows_old (key sym X1) -> auto_knows_old (noncea_old X3 X4) -> auto_knows_old (passwd_old X3 X4) -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_7 X1 -> auto_knows_old X2 -> auto_knows_old (key sym X1) -> auto___def_43 X1 X2). tauto.
  exact (rem_2075 X1 X2).
Qed.

Remark rem_2077 : forall X1 X2 X3 X4:term, auto___type_7 X1 -> auto___def_44 (key pub (session_old X3 X4)) -> auto_knows_old X2 -> auto_knows_old (key sym X1) -> auto_knows_old (noncea_old X3 X4) -> auto_knows_old (passwd_old X3 X4) -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_44 (key pub (session_old X3 X4)) -> auto___type_7 X1 -> auto_knows_old X2 -> auto_knows_old (key sym X1) -> auto_knows_old (noncea_old X3 X4) -> auto_knows_old (passwd_old X3 X4) -> auto___def_43 X1 X2). tauto. exact (rem_2076 X1 X2 X3 X4).
Qed.

Remark rem_2078 : forall X1 X2:term, auto___def_61 sym -> auto___def_62 X1 -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_61 sym -> False). tauto.
  exact (rem_1310).
Qed.

Remark rem_2079 : forall X1 X2:term, auto___def_51 sym -> auto_agent X1 -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_51 sym -> False). tauto.
  exact (rem_1313).
Qed.

Remark rem_2080 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old (key sym X1) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1 H2. intro H. intros.
  elim (rem_1361 sym X1 H);  intros.
  apply (rem_2078 X1 X2);  tauto.
  apply (rem_2079 X1 X2);  tauto.
Qed.

Remark rem_2081 : forall X1 X2 X3 X4:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old (key pub (session_old X3 X4)) -> auto_knows_old (key sym X1) -> auto_knows_old (noncea_old X3 X4) -> auto_knows_old (passwd_old X3 X4) -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old (key sym X1) -> auto___def_43 X1 X2). tauto.
  exact (rem_2080 X1 X2).
Qed.

Remark rem_2082 : forall X1 X2 X3 X4:term, auto_knows_old X1 -> auto_knows_old (key pub (session_old X3 X4)) -> auto_knows_old X2 -> auto_knows_old (key sym X1) -> auto_knows_old (noncea_old X3 X4) -> auto_knows_old (passwd_old X3 X4) -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old (key pub (session_old X3 X4)) -> auto_knows_old (key sym X1) -> auto_knows_old (noncea_old X3 X4) -> auto_knows_old (passwd_old X3 X4) -> auto___def_43 X1 X2). tauto. exact (rem_2081 X1 X2 X3 X4).
Qed.

Remark rem_2083 : forall X1 X2 X3 X4:term, auto_knows_old X2 -> auto_knows_old (crypt X1 (key pub (session_old X3 X4))) -> auto_knows_old (key sym X1) -> auto_knows_old (noncea_old X3 X4) -> auto_knows_old (passwd_old X3 X4) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_1860 X1 (key pub (session_old X3 X4)) H);  intros.
  apply (rem_2005 X1 X2 X3 X4);  tauto.
  apply (rem_2041 X1 X2 X3 X4);  tauto.
  apply (rem_2077 X1 X2 X3 X4);  tauto.
  apply (rem_2082 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2084 : forall X1 X2 X3 X4:term, auto_knows_old (crypt X1 (key pub (session_old X3 X4))) -> auto_knows_old (passwd_old X3 X4) -> auto_knows_old X2 -> auto_knows_old (key sym X1) -> auto_knows_old (noncea_old X3 X4) -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_old X2 -> auto_knows_old (crypt X1 (key pub (session_old X3 X4))) -> auto_knows_old (key sym X1) -> auto_knows_old (noncea_old X3 X4) -> auto_knows_old (passwd_old X3 X4) -> auto___def_43 X1 X2). tauto. exact (rem_2083 X1 X2 X3 X4).
Qed.

Remark rem_2085 : forall X1 X2 X3 X4:term, auto_knows_old X2 -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto_knows_old (key sym X1) -> auto_knows_old (noncea_old X3 X4) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_1290 (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4) H);  intros.
  apply (rem_1945 X1 X2 X3 X4);  tauto.
  apply (rem_1959 X1 X2 X3 X4);  tauto.
  apply (rem_1983 X1 X2 X3 X4);  tauto.
  apply (rem_2084 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2086 : forall X1 X2 X3 X4:term, auto_knows_old X2 -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto_knows_old (key sym X1) -> auto_knows_old nil -> auto_knows_old (noncea_old X3 X4) -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old X2 -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto_knows_old (key sym X1) -> auto_knows_old (noncea_old X3 X4) -> auto___def_43 X1 X2). tauto.
  exact (rem_2085 X1 X2 X3 X4).
Qed.

Remark rem_2087 : forall X1 X2 X3 X4:term, auto_knows_old X2 -> auto_knows_old nil -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto_knows_old (key sym X1) -> auto_knows_old (noncea_old X3 X4) -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_old X2 -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto_knows_old (key sym X1) -> auto_knows_old nil -> auto_knows_old (noncea_old X3 X4) -> auto___def_43 X1 X2). tauto. exact (rem_2086 X1 X2 X3 X4).
Qed.

Remark rem_2088 : forall X1 X2 X3 X4:term, auto_knows_old (cons X2 nil) -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto_knows_old (key sym X1) -> auto_knows_old (noncea_old X3 X4) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1263 X2 nil H);  intros.
  apply (rem_2087 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2089 : forall X1 X2 X3 X4:term, auto_knows_old (noncea_old X3 X4) -> auto_knows_old (cons X2 nil) -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto_knows_old (key sym X1) -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_old (cons X2 nil) -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto_knows_old (key sym X1) -> auto_knows_old (noncea_old X3 X4) -> auto___def_43 X1 X2). tauto. exact (rem_2088 X1 X2 X3 X4).
Qed.

Remark rem_2090 : forall X1 X2 X3 X4:term, auto_knows_old (cons (noncea_old X3 X4) (cons X2 nil)) -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto_knows_old (key sym X1) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1263 (noncea_old X3 X4) (cons X2 nil) H);  intros.
  apply (rem_2089 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2091 : forall X1 X2 X3 X4:term, auto_knows_old (cons (noncea_old X3 X4) (cons X2 nil)) -> auto_knows_old (key sym X1) -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_old (cons (noncea_old X3 X4) (cons X2 nil)) -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto_knows_old (key sym X1) -> auto___def_43 X1 X2). tauto. exact (rem_2090 X1 X2 X3 X4).
Qed.

Remark rem_2092 : forall X1 X2 X3 X4:term, auto_knows_old (crypt (cons (noncea_old X3 X4) (cons X2 nil)) (key sym X1)) -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1860 (cons (noncea_old X3 X4) (cons X2 nil)) (key sym X1) H);  intros.
  apply (rem_1936 X1 X2 X3 X4);  tauto.
  apply (rem_1938 X1 X2 X3 X4);  tauto.
  apply (rem_1944 X1 X2 X3 X4);  tauto.
  apply (rem_2091 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2093 : forall X1 X2 X3 X4:term, auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto_knows_old (crypt (cons (noncea_old X3 X4) (cons X2 nil)) (key sym X1)) -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_old (crypt (cons (noncea_old X3 X4) (cons X2 nil)) (key sym X1)) -> auto_knows_old (enc (crypt X1 (key pub (session_old X3 X4))) (passwd_old X3 X4)) -> auto___def_43 X1 X2). tauto. exact (rem_2092 X1 X2 X3 X4).
Qed.

Remark rem_2094 : auto___def_100 nil. (* Deduce positive atom. *)
Proof.
   case rem_855. intros. apply trans___def_100_nil_1;  tauto.
 tauto.
Qed.

Remark rem_2095 : auto___def_62 i. (* Deduce positive atom. *)
Proof.
   case rem_855. intros. apply trans___def_62_i_1;  tauto.
 tauto.
Qed.

Remark rem_2096 : forall X1:term, auto___type_20 X1 -> auto___type_20 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2097 : forall X1 X2:term, auto___def_90 X2 -> auto___type_20 X1 -> auto___type_20 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_20 X1 -> auto___type_20 X1). tauto. exact (rem_2096 X1).
Qed.

Remark rem_2098 : forall X2:term, auto___def_90 X2 -> auto___def_90 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2099 : forall X1 X2:term, auto___def_90 X2 -> auto___type_20 X1 -> auto___def_90 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_90 X2 -> auto___def_90 X2). tauto. exact (rem_2098 X2).
Qed.

Remark rem_2100 : forall X1 X2:term, auto___def_90 X2 -> auto___type_20 X1 -> (auto___type_20 X1 /\ auto___def_90 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_20 X1). 2:apply (rem_2097 X1 X2);  assumption.
  cut (auto___def_90 X2). 2:apply (rem_2099 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2101 : forall X1 X2:term, auto___def_90 X2 -> auto___type_20 X1 -> auto___def_88 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2100 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_88_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2102 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current nil -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_288 X1).
Qed.

Remark rem_2103 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current nil -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_1414 X2).
Qed.

Remark rem_2104 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current nil -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto_knows_current X1). 2:apply (rem_2102 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2103 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2105 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current nil -> auto___def_78 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_2104 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_78_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2106 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current nil -> auto_knows_current X1 -> auto___def_78 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current nil -> auto___def_78 X1 X2). tauto. exact (rem_2105 X1 X2).
Qed.

Remark rem_2107 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current (cons X2 nil) -> auto___def_78 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_1034 X2 nil H);  intros.
  apply (rem_2106 X1 X2);  tauto.
Qed.

Remark rem_2108 : forall X1 X2:term, auto_knows_current (cons X1 (cons X2 nil)) -> auto___def_78 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_1034 X1 (cons X2 nil) H);  intros.
  apply (rem_2107 X1 X2);  tauto.
Qed.

Remark rem_2109 : forall X1:term, auto___def_39 X1 -> auto___def_39 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2110 : forall X1 X2:term, auto___def_39 X1 -> auto___def_40 X2 -> auto___def_39 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_39 X1 -> auto___def_39 X1). tauto. exact (rem_2109 X1).
Qed.

Remark rem_2111 : forall X2:term, auto___def_40 X2 -> auto___def_40 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2112 : forall X1 X2:term, auto___def_39 X1 -> auto___def_40 X2 -> auto___def_40 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_40 X2 -> auto___def_40 X2). tauto. exact (rem_2111 X2).
Qed.

Remark rem_2113 : forall X1 X2:term, auto___def_39 X1 -> auto___def_40 X2 -> (auto___def_39 X1 /\ auto___def_40 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_39 X1). 2:apply (rem_2110 X1 X2);  assumption.
  cut (auto___def_40 X2). 2:apply (rem_2112 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2114 : forall X1 X2:term, auto___def_39 X1 -> auto___def_40 X2 -> auto___def_38 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2113 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_38_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2115 : forall X1 X2:term, auto___def_40 X2 -> auto___def_39 X1 -> auto___def_38 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_39 X1 -> auto___def_40 X2 -> auto___def_38 (cons X1 X2)). tauto. exact (rem_2114 X1 X2).
Qed.

Remark rem_2116 : auto___def_92 nil. (* Deduce positive atom. *)
Proof.
   case rem_855. intros. apply trans___def_92_nil_1;  tauto.
 tauto.
Qed.

Remark rem_2117 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p__type_1.  tauto.
Defined.

Remark rem_2118 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto___type_1 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_1.  case (rem_2117 epsilon_magent_p__type_1). clear  epsilon_magent_p__type_1. intros. apply trans___type_1_bob_1;  tauto.
 clear  epsilon_magent_p__type_1. tauto.
Defined.

Remark rem_2119 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto_agent bob -> auto___type_1 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_1. intro H. intros.
  elim (rem_1083 H);  intros.
  apply (rem_2118 epsilon_magent_p__type_1);  tauto.
Defined.

Remark rem_2120 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto___type_1 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_1.  case (rem_2117 epsilon_magent_p__type_1). clear  epsilon_magent_p__type_1. intros. apply trans___type_1_alice_1;  tauto.
 clear  epsilon_magent_p__type_1. tauto.
Defined.

Remark rem_2121 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto_agent alice -> auto___type_1 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_1. intro H. intros.
  elim (rem_1086 H);  intros.
  apply (rem_2120 epsilon_magent_p__type_1);  tauto.
Defined.

Remark rem_2122 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto___type_1 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_1.  case (rem_2117 epsilon_magent_p__type_1). clear  epsilon_magent_p__type_1. intros. apply trans___type_1_i_1;  tauto.
 clear  epsilon_magent_p__type_1. tauto.
Defined.

Remark rem_2123 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto_agent i -> auto___type_1 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_1. intro H. intros.
  elim (rem_1089 H);  intros.
  apply (rem_2122 epsilon_magent_p__type_1);  tauto.
Defined.

Remark rem_2124 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto___type_1 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_1.  case (rem_2117 epsilon_magent_p__type_1). clear  epsilon_magent_p__type_1. intros. apply trans___type_1_server_1;  tauto.
 clear  epsilon_magent_p__type_1. tauto.
Defined.

Remark rem_2125 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto_agent server -> auto___type_1 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_1. intro H. intros.
  elim (rem_1092 H);  intros.
  apply (rem_2124 epsilon_magent_p__type_1);  tauto.
Defined.

Remark rem_2126 : forall X1:term, auto_agent X1 -> auto___type_1 X1. (* Induct. *)
Proof.
  fix epsilon_magent_p__type_1 1.
  intro X. case X.
  exact (rem_2121 epsilon_magent_p__type_1 ).
  exact (rem_2119 epsilon_magent_p__type_1 ).
  intros X1 X2. intro H. elim (rem_1108 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1094 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1106 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1107 X1 X2 H).
  exact (rem_2123 epsilon_magent_p__type_1 ).
  intros X1 X2. intro H. elim (rem_1114 X1 X2 H).
   intro H. elim (rem_1112  H).
  intros X1 X2. intro H. elim (rem_1113 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1097 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1095 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1105 X1 X2 H).
  intros X1. intro H. elim (rem_1100 X1 H).
  intros X1 X2. intro H. elim (rem_1103 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1102 X1 X2 H).
   intro H. elim (rem_1104  H).
   intro H. elim (rem_1101  H).
  intros X1 X2. intro H. elim (rem_1099 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1098 X1 X2 H).
  intros X1. intro H. elim (rem_1109 X1 H).
  exact (rem_2125 epsilon_magent_p__type_1 ).
  intros X1 X2. intro H. elim (rem_1111 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1096 X1 X2 H).
   intro H. elim (rem_1110  H).
Qed.

Remark rem_2127 : forall X1 X2 X3:term, auto___type_22 X3 -> auto_knows_current X1 -> auto___def_94 (r_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2.
  case (rem_290 X1 X3 A1 A2). clear  A1 A2. intros. apply trans___def_94_r_current_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2128 : forall X1 X2 X3:term, auto___def_96 X3 -> auto_knows_current X1 -> auto___def_94 (r_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2.
  case (rem_293 X1 X3 A1 A2). clear  A1 A2. intros. apply trans___def_94_r_current_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2129 : forall X1 X2 X3:term, auto___def_84 X3 -> auto_knows_current X1 -> auto___def_94 (r_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2.
  case (rem_296 X1 X3 A1 A2). clear  A1 A2. intros. apply trans___def_94_r_current_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2130 : forall X1 X2 X3:term, auto___def_87 X2 X3 X1 -> auto___def_94 (r_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1709 X2 X3 X1 H);  intros.
  apply (rem_2127 X1 X2 X3);  tauto.
  apply (rem_2128 X1 X2 X3);  tauto.
  apply (rem_2129 X1 X2 X3);  tauto.
Qed.

Remark rem_2131 : auto___def_53 pub. (* Deduce positive atom. *)
Proof.
   case rem_855. intros. apply trans___def_53_pub_1;  tauto.
 tauto.
Qed.

Remark rem_2132 : forall X1 X2 X3:term, auto_knows_current X3 -> auto_knows_current X1 -> auto___def_81 (r_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2.
  case (rem_915 X1 X3 A1 A2). clear  A1 A2. intros. apply trans___def_81_r_current_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2133 : forall X1 X2 X3:term, auto_knows_current X1 -> auto_knows_current X3 -> auto___def_81 (r_current X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_knows_current X3 -> auto_knows_current X1 -> auto___def_81 (r_current X1 X2)). tauto. exact (rem_2132 X1 X2 X3).
Qed.

Remark rem_2134 : forall X1 X2 X3:term, auto___def_78 X1 X3 -> auto___def_81 (r_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_918 X1 X3 H);  intros.
  apply (rem_2133 X1 X2 X3);  tauto.
Qed.

Remark rem_2135 : forall X1:term, auto___type_6 X1 -> auto___type_6 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2136 : forall X1 X2:term, auto___def_38 X2 -> auto___type_6 X1 -> auto___type_6 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_6 X1 -> auto___type_6 X1). tauto. exact (rem_2135 X1).
Qed.

Remark rem_2137 : forall X2:term, auto___def_38 X2 -> auto___def_38 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2138 : forall X1 X2:term, auto___def_38 X2 -> auto___type_6 X1 -> auto___def_38 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_38 X2 -> auto___def_38 X2). tauto. exact (rem_2137 X2).
Qed.

Remark rem_2139 : forall X1 X2:term, auto___def_38 X2 -> auto___type_6 X1 -> (auto___type_6 X1 /\ auto___def_38 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_6 X1). 2:apply (rem_2136 X1 X2);  assumption.
  cut (auto___def_38 X2). 2:apply (rem_2138 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2140 : forall X1 X2:term, auto___def_38 X2 -> auto___type_6 X1 -> auto___def_36 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2139 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_36_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2141 : forall X1 X2:term, auto_agent X2 -> auto_agent X1 -> auto___def_11 (passwd_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1792 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_11_passwd_old_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2142 : forall X1:term, auto___def_10 X1 -> auto___def_10 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2143 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_10 X1). tauto. exact (rem_2142 X1).
Qed.

Remark rem_2144 : forall X2:term, auto___def_11 X2 -> auto___def_11 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2145 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_11 X2 -> auto___def_11 X2). tauto. exact (rem_2144 X2).
Qed.

Remark rem_2146 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> (auto___def_10 X1 /\ auto___def_11 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_10 X1). 2:apply (rem_2143 X1 X2);  assumption.
  cut (auto___def_11 X2). 2:apply (rem_2145 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2147 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_8 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2146 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_8_enc_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2148 : forall X1 X2:term, auto___def_11 X2 -> auto___def_10 X1 -> auto___def_8 (enc X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_11 X2 -> auto___def_8 (enc X1 X2)). tauto. exact (rem_2147 X1 X2).
Qed.

Remark rem_2149 : auto___def_12 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2150 : auto___def_12 prv -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_2149 H);  intros.
Qed.

Remark rem_2151 : forall X1 X2:term, auto___def_12 prv -> auto___def_13 X1 -> auto___def_17 X2 -> auto___def_65 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_12 prv -> False). tauto.
  exact (rem_2150).
Qed.

Remark rem_2152 : forall X1 X2:term, auto___def_17 X2 -> auto___type_2 (key prv X1) -> auto___def_65 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_1399 prv X1 H);  intros.
  apply (rem_2151 X1 X2);  tauto.
Qed.

Remark rem_2153 : auto___def_41 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2154 : auto___def_41 prv -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_2153 H);  intros.
Qed.

Remark rem_2155 : forall X1 X2:term, auto___def_36 X2 -> auto___def_41 prv -> auto___def_42 X1 -> auto___def_65 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_41 prv -> False). tauto.
  exact (rem_2154).
Qed.

Remark rem_2156 : forall X1 X2:term, auto___def_41 prv -> auto___def_42 X1 -> auto___def_36 X2 -> auto___def_65 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_36 X2 -> auto___def_41 prv -> auto___def_42 X1 -> auto___def_65 X1 X2). tauto. exact (rem_2155 X1 X2).
Qed.

Remark rem_2157 : forall X1 X2:term, auto___def_36 X2 -> auto___def_37 (key prv X1) -> auto___def_65 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_1405 prv X1 H);  intros.
  apply (rem_2156 X1 X2);  tauto.
Qed.

Remark rem_2158 : forall X1 X2:term, auto___def_21 X2 -> auto___def_22 (key prv X1) -> auto___def_65 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_1407 prv X1 H);  intros.
Qed.

Remark rem_2159 : forall X1:term, auto___def_62 X1 -> auto___def_62 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2160 : forall X1 X2:term, auto___def_61 prv -> auto___def_62 X1 -> auto_knows_current X2 -> auto___def_62 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_62 X1 -> auto___def_62 X1). tauto. exact (rem_2159 X1).
Qed.

Remark rem_2161 : forall X1 X2:term, auto___def_61 prv -> auto___def_62 X1 -> auto_knows_current X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_1414 X2).
Qed.

Remark rem_2162 : forall X1 X2:term, auto___def_61 prv -> auto___def_62 X1 -> auto_knows_current X2 -> (auto___def_62 X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_62 X1). 2:apply (rem_2160 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2161 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2163 : forall X1 X2:term, auto___def_61 prv -> auto___def_62 X1 -> auto_knows_current X2 -> auto___def_65 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_2162 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_65_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2164 : forall X1 X2:term, auto___def_51 prv -> auto_agent X1 -> auto_knows_current X2 -> auto___def_65 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_51 prv -> False). tauto.
  exact (rem_1359).
Qed.

Remark rem_2165 : forall X1 X2:term, auto___def_12 prv -> auto___def_13 X1 -> auto_knows_current X2 -> auto___def_65 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_12 prv -> False). tauto.
  exact (rem_2150).
Qed.

Remark rem_2166 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current (key prv X1) -> auto___def_65 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_1066 prv X1 H);  intros.
  apply (rem_2163 X1 X2);  tauto.
  apply (rem_2164 X1 X2);  tauto.
  apply (rem_2165 X1 X2);  tauto.
Qed.

Remark rem_2167 : auto___def_105 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2168 : auto___def_105 prv -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_2167 H);  intros.
Qed.

Remark rem_2169 : forall X1 X2:term, auto___def_105 prv -> auto___type_22 X2 -> auto___type_23 X1 -> auto___def_65 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_105 prv -> False). tauto.
  exact (rem_2168).
Qed.

Remark rem_2170 : forall X1 X2:term, auto___def_105 prv -> auto___type_23 X1 -> auto___type_22 X2 -> auto___def_65 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_105 prv -> auto___type_22 X2 -> auto___type_23 X1 -> auto___def_65 X1 X2). tauto. exact (rem_2169 X1 X2).
Qed.

Remark rem_2171 : forall X1 X2:term, auto___def_104 (key prv X1) -> auto___type_22 X2 -> auto___def_65 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_1431 prv X1 H);  intros.
  apply (rem_2170 X1 X2);  tauto.
Qed.

Remark rem_2172 : forall X1 X2:term, auto___type_22 X2 -> auto___def_104 (key prv X1) -> auto___def_65 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_104 (key prv X1) -> auto___type_22 X2 -> auto___def_65 X1 X2). tauto. exact (rem_2171 X1 X2).
Qed.

Remark rem_2173 : auto___def_93 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2174 : auto___def_93 prv -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_2173 H);  intros.
Qed.

Remark rem_2175 : forall X1 X2:term, auto___def_88 X2 -> auto___def_93 prv -> auto___def_94 X1 -> auto___def_65 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_93 prv -> False). tauto.
  exact (rem_2174).
Qed.

Remark rem_2176 : forall X1 X2:term, auto___def_93 prv -> auto___def_94 X1 -> auto___def_88 X2 -> auto___def_65 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_88 X2 -> auto___def_93 prv -> auto___def_94 X1 -> auto___def_65 X1 X2). tauto. exact (rem_2175 X1 X2).
Qed.

Remark rem_2177 : forall X1 X2:term, auto___def_88 X2 -> auto___def_89 (key prv X1) -> auto___def_65 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_1438 prv X1 H);  intros.
  apply (rem_2176 X1 X2);  tauto.
Qed.

Remark rem_2178 : auto___def_26 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2179 : auto___def_26 prv -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_2178 H);  intros.
Qed.

Remark rem_2180 : forall X1 X2:term, auto___def_24 X2 -> auto___def_26 prv -> auto___type_4 X1 -> auto___def_65 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_26 prv -> False). tauto.
  exact (rem_2179).
Qed.

Remark rem_2181 : forall X1 X2:term, auto___def_26 prv -> auto___type_4 X1 -> auto___def_24 X2 -> auto___def_65 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_24 X2 -> auto___def_26 prv -> auto___type_4 X1 -> auto___def_65 X1 X2). tauto. exact (rem_2180 X1 X2).
Qed.

Remark rem_2182 : forall X1 X2:term, auto___def_24 X2 -> auto___def_25 (key prv X1) -> auto___def_65 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_1444 prv X1 H);  intros.
  apply (rem_2181 X1 X2);  tauto.
Qed.

Remark rem_2183 : auto___def_45 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2184 : auto___def_45 prv -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_2183 H);  intros.
Qed.

Remark rem_2185 : forall X1 X2:term, auto___def_45 prv -> auto___type_7 X2 -> auto___type_8 X1 -> auto___def_65 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_45 prv -> False). tauto.
  exact (rem_2184).
Qed.

Remark rem_2186 : forall X1 X2:term, auto___def_45 prv -> auto___type_8 X1 -> auto___type_7 X2 -> auto___def_65 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_45 prv -> auto___type_7 X2 -> auto___type_8 X1 -> auto___def_65 X1 X2). tauto. exact (rem_2185 X1 X2).
Qed.

Remark rem_2187 : forall X1 X2:term, auto___def_44 (key prv X1) -> auto___type_7 X2 -> auto___def_65 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_1450 prv X1 H);  intros.
  apply (rem_2186 X1 X2);  tauto.
Qed.

Remark rem_2188 : forall X1 X2:term, auto___type_7 X2 -> auto___def_44 (key prv X1) -> auto___def_65 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_44 (key prv X1) -> auto___type_7 X2 -> auto___def_65 X1 X2). tauto. exact (rem_2187 X1 X2).
Qed.

Remark rem_2189 : auto___def_86 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2190 : auto___def_86 prv -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_2189 H);  intros.
Qed.

Remark rem_2191 : forall X1 X2:term, auto___def_84 X2 -> auto___def_86 prv -> auto___type_19 X1 -> auto___def_65 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_86 prv -> False). tauto.
  exact (rem_2190).
Qed.

Remark rem_2192 : forall X1 X2:term, auto___def_86 prv -> auto___type_19 X1 -> auto___def_84 X2 -> auto___def_65 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_84 X2 -> auto___def_86 prv -> auto___type_19 X1 -> auto___def_65 X1 X2). tauto. exact (rem_2191 X1 X2).
Qed.

Remark rem_2193 : forall X1 X2:term, auto___def_84 X2 -> auto___def_85 (key prv X1) -> auto___def_65 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_1457 prv X1 H);  intros.
  apply (rem_2192 X1 X2);  tauto.
Qed.

Remark rem_2194 : forall X1 X2:term, auto_knows_current (crypt X2 (key prv X1)) -> auto___def_65 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_987 X2 (key prv X1) H);  intros.
  apply (rem_2152 X1 X2);  tauto.
  apply (rem_2157 X1 X2);  tauto.
  apply (rem_2158 X1 X2);  tauto.
  apply (rem_2166 X1 X2);  tauto.
  apply (rem_2172 X1 X2);  tauto.
  apply (rem_2177 X1 X2);  tauto.
  apply (rem_2182 X1 X2);  tauto.
  apply (rem_2188 X1 X2);  tauto.
  apply (rem_2193 X1 X2);  tauto.
Qed.

Remark rem_2195 : (forall X:term, auto___type_6 X -> auto___type_5 X)
    -> forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2196 : (forall X:term, auto___type_6 X -> auto___type_5 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_p__type_5. intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_2195 epsilon_m__type_6_p__type_5 X1).
Defined.

Remark rem_2197 : (forall X:term, auto___type_6 X -> auto___type_5 X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2198 : (forall X:term, auto___type_6 X -> auto___type_5 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_p__type_5. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_2197 epsilon_m__type_6_p__type_5 X2).
Defined.

Remark rem_2199 : (forall X:term, auto___type_6 X -> auto___type_5 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> (auto_agent X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_6_p__type_5. intros X1 X2. intros A1 A2.
  cut (auto_agent X1). 2:apply (rem_2196 epsilon_m__type_6_p__type_5 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_2198 epsilon_m__type_6_p__type_5 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2200 : (forall X:term, auto___type_6 X -> auto___type_5 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_5 (noncea_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_p__type_5. intros X1 X2. intros A1 A2.
  case (rem_2199 epsilon_m__type_6_p__type_5 X1 X2 A1 A2). clear  epsilon_m__type_6_p__type_5 A1 A2. intros. apply trans___type_5_noncea_old_1;  tauto.
 clear  epsilon_m__type_6_p__type_5 A1 A2. tauto.
Defined.

Remark rem_2201 : forall X1 X2:term, auto___type_6 (noncea_old X1 X2) -> or_1
    (auto_agent X1 /\ auto_agent X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2202 : (forall X:term, auto___type_6 X -> auto___type_5 X)
    -> forall X1 X2:term, auto___type_6 (noncea_old X1 X2) -> auto___type_5 (noncea_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_p__type_5. intros X1 X2. intro H. intros.
  elim (rem_2201 X1 X2 H);  intros.
  apply (rem_2200 epsilon_m__type_6_p__type_5 X1 X2);  tauto.
Defined.

Remark rem_2203 : (forall X:term, auto___type_6 X -> auto___type_5 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2204 : (forall X:term, auto___type_6 X -> auto___type_5 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_6_p__type_5. intros X1. intros A1.
  cut (auto_knows_old X1). 2:apply (rem_2203 epsilon_m__type_6_p__type_5 X1);  assumption.
  tauto.
Defined.

Remark rem_2205 : (forall X:term, auto___type_6 X -> auto___type_5 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto___type_5 (nonceb_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_p__type_5. intros X1 X2. intros A1.
  case (rem_2204 epsilon_m__type_6_p__type_5 X1 A1). clear  epsilon_m__type_6_p__type_5 A1. intros. apply trans___type_5_nonceb_old_1;  tauto.
 clear  epsilon_m__type_6_p__type_5 A1. tauto.
Defined.

Remark rem_2206 : forall X1 X2:term, auto___type_6 (nonceb_old X1 X2) -> or_1
    (auto_knows_old X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2207 : (forall X:term, auto___type_6 X -> auto___type_5 X)
    -> forall X1 X2:term, auto___type_6 (nonceb_old X1 X2) -> auto___type_5 (nonceb_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_p__type_5. intros X1 X2. intro H. intros.
  elim (rem_2206 X1 X2 H);  intros.
  apply (rem_2205 epsilon_m__type_6_p__type_5 X1 X2);  tauto.
Defined.

Remark rem_2208 : (forall X:term, auto___type_6 X -> auto___type_5 X)
    -> forall X1:term, auto___type_6 X1 -> auto___type_6 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2209 : (forall X:term, auto___type_6 X -> auto___type_5 X)
    -> forall X1 X2:term, auto___type_6 X1 -> auto___def_38 X2 -> auto___type_6 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_p__type_5. intros X1 X2.
  cut (auto___type_6 X1 -> auto___type_6 X1). tauto. exact (rem_2208 epsilon_m__type_6_p__type_5 X1).
Defined.

Remark rem_2210 : (forall X:term, auto___type_6 X -> auto___type_5 X)
    -> forall X2:term, auto___def_38 X2 -> auto___def_38 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2211 : (forall X:term, auto___type_6 X -> auto___type_5 X)
    -> forall X1 X2:term, auto___type_6 X1 -> auto___def_38 X2 -> auto___def_38 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_p__type_5. intros X1 X2.
  cut (auto___def_38 X2 -> auto___def_38 X2). tauto. exact (rem_2210 epsilon_m__type_6_p__type_5 X2).
Defined.

Remark rem_2212 : (forall X:term, auto___type_6 X -> auto___type_5 X)
    -> forall X1 X2:term, auto___type_6 X1 -> auto___def_38 X2 -> (auto___type_6 X1 /\ auto___def_38 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_6_p__type_5. intros X1 X2. intros A1 A2.
  cut (auto___type_6 X1). 2:apply (rem_2209 epsilon_m__type_6_p__type_5 X1 X2);  assumption.
  cut (auto___def_38 X2). 2:apply (rem_2211 epsilon_m__type_6_p__type_5 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2213 : (forall X:term, auto___type_6 X -> auto___type_5 X)
    -> forall X1 X2:term, auto___type_6 X1 -> auto___def_38 X2 -> auto___type_5 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_p__type_5. intros X1 X2. intros A1 A2.
  case (rem_2212 epsilon_m__type_6_p__type_5 X1 X2 A1 A2). clear  epsilon_m__type_6_p__type_5 A1 A2. intros. apply trans___type_5_cons_1;  tauto.
 clear  epsilon_m__type_6_p__type_5 A1 A2. tauto.
Defined.

Remark rem_2214 : forall X1 X2:term, auto___type_6 (cons X1 X2) -> or_1
    (auto___type_6 X1 /\ auto___def_38 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2215 : (forall X:term, auto___type_6 X -> auto___type_5 X)
    -> forall X1 X2:term, auto___type_6 (cons X1 X2) -> auto___type_5 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_p__type_5. intros X1 X2. intro H. intros.
  elim (rem_2214 X1 X2 H);  intros.
  apply (rem_2213 epsilon_m__type_6_p__type_5 X1 X2);  tauto.
Defined.

Remark rem_2216 : forall X1 X2:term, auto___type_6 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2217 : forall X1 X2:term, auto___type_6 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2218 : forall X1 X2:term, auto___type_6 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2219 : auto___type_6 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2220 : forall X1 X2:term, auto___type_6 (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2221 : forall X1 X2:term, auto___type_6 (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2222 : forall X1:term, auto___type_6 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2223 : auto___type_6 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2224 : forall X1 X2:term, auto___type_6 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2225 : forall X1 X2:term, auto___type_6 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2226 : auto___type_6 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2227 : auto___type_6 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2228 : forall X1 X2:term, auto___type_6 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2229 : forall X1 X2:term, auto___type_6 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2230 : forall X1:term, auto___type_6 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2231 : auto___type_6 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2232 : forall X1 X2:term, auto___type_6 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2233 : auto___type_6 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2234 : auto___type_6 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2235 : auto___type_6 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2236 : forall X1 X2:term, auto___type_6 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2237 : forall X1 X2:term, auto___type_6 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2238 : forall X1:term, auto___type_6 X1 -> auto___type_5 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_6_p__type_5 1.
  intro X. case X.
   intro H. elim (rem_2226  H).
   intro H. elim (rem_2219  H).
  intros X1 X2;  exact (rem_2215 epsilon_m__type_6_p__type_5 X1 X2).
  intros X1 X2. intro H. elim (rem_2216 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2228 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2229 X1 X2 H).
   intro H. elim (rem_2233  H).
  intros X1 X2. intro H. elim (rem_2237 X1 X2 H).
   intro H. elim (rem_2234  H).
  intros X1 X2. intro H. elim (rem_2236 X1 X2 H).
  intros X1 X2;  exact (rem_2202 epsilon_m__type_6_p__type_5 X1 X2).
  intros X1 X2. intro H. elim (rem_2217 X1 X2 H).
  intros X1 X2;  exact (rem_2207 epsilon_m__type_6_p__type_5 X1 X2).
  intros X1. intro H. elim (rem_2222 X1 H).
  intros X1 X2. intro H. elim (rem_2225 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2224 X1 X2 H).
   intro H. elim (rem_2227  H).
   intro H. elim (rem_2223  H).
  intros X1 X2. intro H. elim (rem_2221 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2220 X1 X2 H).
  intros X1. intro H. elim (rem_2230 X1 H).
   intro H. elim (rem_2235  H).
  intros X1 X2. intro H. elim (rem_2232 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2218 X1 X2 H).
   intro H. elim (rem_2231  H).
Qed.

Remark rem_2239 : (forall X:term, auto___def_36 X -> auto___def_28 X)
    -> forall X1:term, auto___type_6 X1 -> auto___type_5 X1. (* Cut history. *)
Proof.  intros epsilon_m__def_36_p__def_28. exact (rem_2238).
Defined.

Remark rem_2240 : (forall X:term, auto___def_36 X -> auto___def_28 X)
    -> forall X1 X2:term, auto___type_6 X1 -> auto___def_38 X2 -> auto___type_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_36_p__def_28. intros X1 X2.
  cut (auto___type_6 X1 -> auto___type_5 X1). tauto. exact (rem_2239 epsilon_m__def_36_p__def_28 X1).
Defined.

Remark rem_2241 : (forall X:term, auto___def_39 X -> auto___def_31 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2242 : (forall X:term, auto___def_39 X -> auto___def_31 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_39_p__def_31. intros X1. intros A1.
  cut (auto_knows_old X1). 2:apply (rem_2241 epsilon_m__def_39_p__def_31 X1);  assumption.
  tauto.
Defined.

Remark rem_2243 : (forall X:term, auto___def_39 X -> auto___def_31 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto___def_31 (nonceb_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_39_p__def_31. intros X1 X2. intros A1.
  case (rem_2242 epsilon_m__def_39_p__def_31 X1 A1). clear  epsilon_m__def_39_p__def_31 A1. intros. apply trans___def_31_nonceb_old_1;  tauto.
 clear  epsilon_m__def_39_p__def_31 A1. tauto.
Defined.

Remark rem_2244 : (forall X:term, auto___def_39 X -> auto___def_31 X)
    -> forall X1 X2:term, auto___def_39 (nonceb_old X1 X2) -> auto___def_31 (nonceb_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_39_p__def_31. intros X1 X2. intro H. intros.
  elim (rem_1473 X1 X2 H);  intros.
  apply (rem_2243 epsilon_m__def_39_p__def_31 X1 X2);  tauto.
Defined.

Remark rem_2245 : forall X1:term, auto___def_39 X1 -> auto___def_31 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_39_p__def_31 1.
  intro X. case X.
   intro H. elim (rem_1486  H).
   intro H. elim (rem_1478  H).
  intros X1 X2. intro H. elim (rem_1490 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1475 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1488 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1489 X1 X2 H).
   intro H. elim (rem_1494  H).
  intros X1 X2. intro H. elim (rem_1498 X1 X2 H).
   intro H. elim (rem_1495  H).
  intros X1 X2. intro H. elim (rem_1497 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1479 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1476 X1 X2 H).
  intros X1 X2;  exact (rem_2244 epsilon_m__def_39_p__def_31 X1 X2).
  intros X1. intro H. elim (rem_1482 X1 H).
  intros X1 X2. intro H. elim (rem_1485 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1484 X1 X2 H).
   intro H. elim (rem_1487  H).
   intro H. elim (rem_1483  H).
  intros X1 X2. intro H. elim (rem_1481 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1480 X1 X2 H).
  intros X1. intro H. elim (rem_1491 X1 H).
   intro H. elim (rem_1496  H).
  intros X1 X2. intro H. elim (rem_1493 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1477 X1 X2 H).
   intro H. elim (rem_1492  H).
Qed.

Remark rem_2246 : (forall X:term, auto___def_38 X -> auto___def_30 X)
    -> forall X1:term, auto___def_39 X1 -> auto___def_31 X1. (* Cut history. *)
Proof.  intros epsilon_m__def_38_p__def_30. exact (rem_2245).
Defined.

Remark rem_2247 : (forall X:term, auto___def_38 X -> auto___def_30 X)
    -> forall X1 X2:term, auto___def_39 X1 -> auto___def_40 X2 -> auto___def_31 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_38_p__def_30. intros X1 X2.
  cut (auto___def_39 X1 -> auto___def_31 X1). tauto. exact (rem_2246 epsilon_m__def_38_p__def_30 X1).
Defined.

Remark rem_2248 : (forall X:term, auto___def_40 X -> auto___def_32 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_40_p__def_32.  tauto.
Defined.

Remark rem_2249 : (forall X:term, auto___def_40 X -> auto___def_32 X)
    -> auto___def_32 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_40_p__def_32.  case (rem_2248 epsilon_m__def_40_p__def_32). clear  epsilon_m__def_40_p__def_32. intros. apply trans___def_32_nil_1;  tauto.
 clear  epsilon_m__def_40_p__def_32. tauto.
Defined.

Remark rem_2250 : auto___def_40 nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2251 : (forall X:term, auto___def_40 X -> auto___def_32 X)
    -> auto___def_40 nil -> auto___def_32 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_40_p__def_32. intro H. intros.
  elim (rem_2250 H);  intros.
  apply (rem_2249 epsilon_m__def_40_p__def_32);  tauto.
Defined.

Remark rem_2252 : forall X1 X2:term, auto___def_40 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2253 : forall X1 X2:term, auto___def_40 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2254 : forall X1 X2:term, auto___def_40 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2255 : auto___def_40 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2256 : forall X1 X2:term, auto___def_40 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2257 : forall X1 X2:term, auto___def_40 (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2258 : forall X1 X2:term, auto___def_40 (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2259 : forall X1:term, auto___def_40 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2260 : auto___def_40 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2261 : forall X1 X2:term, auto___def_40 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2262 : forall X1 X2:term, auto___def_40 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2263 : auto___def_40 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2264 : auto___def_40 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2265 : forall X1 X2:term, auto___def_40 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2266 : forall X1 X2:term, auto___def_40 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2267 : forall X1 X2:term, auto___def_40 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2268 : forall X1 X2:term, auto___def_40 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2269 : forall X1:term, auto___def_40 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2270 : auto___def_40 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2271 : forall X1 X2:term, auto___def_40 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2272 : auto___def_40 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2273 : auto___def_40 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2274 : forall X1 X2:term, auto___def_40 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2275 : forall X1 X2:term, auto___def_40 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2276 : forall X2:term, auto___def_40 X2 -> auto___def_32 X2. (* Induct. *)
Proof.
  fix epsilon_m__def_40_p__def_32 1.
  intro X. case X.
   intro H. elim (rem_2263  H).
   intro H. elim (rem_2255  H).
  intros X1 X2. intro H. elim (rem_2268 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2252 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2266 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2267 X1 X2 H).
   intro H. elim (rem_2272  H).
  intros X1 X2. intro H. elim (rem_2275 X1 X2 H).
  exact (rem_2251 epsilon_m__def_40_p__def_32 ).
  intros X1 X2. intro H. elim (rem_2274 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2256 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2253 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2265 X1 X2 H).
  intros X1. intro H. elim (rem_2259 X1 H).
  intros X1 X2. intro H. elim (rem_2262 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2261 X1 X2 H).
   intro H. elim (rem_2264  H).
   intro H. elim (rem_2260  H).
  intros X1 X2. intro H. elim (rem_2258 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2257 X1 X2 H).
  intros X1. intro H. elim (rem_2269 X1 H).
   intro H. elim (rem_2273  H).
  intros X1 X2. intro H. elim (rem_2271 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2254 X1 X2 H).
   intro H. elim (rem_2270  H).
Qed.

Remark rem_2277 : (forall X:term, auto___def_38 X -> auto___def_30 X)
    -> forall X2:term, auto___def_40 X2 -> auto___def_32 X2. (* Cut history. *)
Proof.  intros epsilon_m__def_38_p__def_30. exact (rem_2276).
Defined.

Remark rem_2278 : (forall X:term, auto___def_38 X -> auto___def_30 X)
    -> forall X1 X2:term, auto___def_39 X1 -> auto___def_40 X2 -> auto___def_32 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_38_p__def_30. intros X1 X2.
  cut (auto___def_40 X2 -> auto___def_32 X2). tauto. exact (rem_2277 epsilon_m__def_38_p__def_30 X2).
Defined.

Remark rem_2279 : (forall X:term, auto___def_38 X -> auto___def_30 X)
    -> forall X1 X2:term, auto___def_39 X1 -> auto___def_40 X2 -> (auto___def_31 X1 /\ auto___def_32 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_38_p__def_30. intros X1 X2. intros A1 A2.
  cut (auto___def_31 X1). 2:apply (rem_2247 epsilon_m__def_38_p__def_30 X1 X2);  assumption.
  cut (auto___def_32 X2). 2:apply (rem_2278 epsilon_m__def_38_p__def_30 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2280 : (forall X:term, auto___def_38 X -> auto___def_30 X)
    -> forall X1 X2:term, auto___def_39 X1 -> auto___def_40 X2 -> auto___def_30 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_38_p__def_30. intros X1 X2. intros A1 A2.
  case (rem_2279 epsilon_m__def_38_p__def_30 X1 X2 A1 A2). clear  epsilon_m__def_38_p__def_30 A1 A2. intros. apply trans___def_30_cons_1;  tauto.
 clear  epsilon_m__def_38_p__def_30 A1 A2. tauto.
Defined.

Remark rem_2281 : (forall X:term, auto___def_38 X -> auto___def_30 X)
    -> forall X1 X2:term, auto___def_38 (cons X1 X2) -> auto___def_30 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_38_p__def_30. intros X1 X2. intro H. intros.
  elim (rem_1929 X1 X2 H);  intros.
  apply (rem_2280 epsilon_m__def_38_p__def_30 X1 X2);  tauto.
Defined.

Remark rem_2282 : forall X1 X2:term, auto___def_38 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2283 : forall X1 X2:term, auto___def_38 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2284 : forall X1 X2:term, auto___def_38 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2285 : auto___def_38 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2286 : forall X1 X2:term, auto___def_38 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2287 : forall X1 X2:term, auto___def_38 (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2288 : forall X1 X2:term, auto___def_38 (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2289 : forall X1:term, auto___def_38 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2290 : auto___def_38 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2291 : forall X1 X2:term, auto___def_38 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2292 : forall X1 X2:term, auto___def_38 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2293 : auto___def_38 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2294 : auto___def_38 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2295 : forall X1 X2:term, auto___def_38 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2296 : forall X1 X2:term, auto___def_38 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2297 : forall X1 X2:term, auto___def_38 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2298 : forall X1:term, auto___def_38 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2299 : auto___def_38 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2300 : forall X1 X2:term, auto___def_38 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2301 : auto___def_38 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2302 : auto___def_38 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2303 : auto___def_38 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2304 : forall X1 X2:term, auto___def_38 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2305 : forall X1 X2:term, auto___def_38 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2306 : forall X2:term, auto___def_38 X2 -> auto___def_30 X2. (* Induct. *)
Proof.
  fix epsilon_m__def_38_p__def_30 1.
  intro X. case X.
   intro H. elim (rem_2293  H).
   intro H. elim (rem_2285  H).
  intros X1 X2;  exact (rem_2281 epsilon_m__def_38_p__def_30 X1 X2).
  intros X1 X2. intro H. elim (rem_2282 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2296 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2297 X1 X2 H).
   intro H. elim (rem_2301  H).
  intros X1 X2. intro H. elim (rem_2305 X1 X2 H).
   intro H. elim (rem_2302  H).
  intros X1 X2. intro H. elim (rem_2304 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2286 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2283 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2295 X1 X2 H).
  intros X1. intro H. elim (rem_2289 X1 H).
  intros X1 X2. intro H. elim (rem_2292 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2291 X1 X2 H).
   intro H. elim (rem_2294  H).
   intro H. elim (rem_2290  H).
  intros X1 X2. intro H. elim (rem_2288 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2287 X1 X2 H).
  intros X1. intro H. elim (rem_2298 X1 H).
   intro H. elim (rem_2303  H).
  intros X1 X2. intro H. elim (rem_2300 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2284 X1 X2 H).
   intro H. elim (rem_2299  H).
Qed.

Remark rem_2307 : (forall X:term, auto___def_36 X -> auto___def_28 X)
    -> forall X2:term, auto___def_38 X2 -> auto___def_30 X2. (* Cut history. *)
Proof.  intros epsilon_m__def_36_p__def_28. exact (rem_2306).
Defined.

Remark rem_2308 : (forall X:term, auto___def_36 X -> auto___def_28 X)
    -> forall X1 X2:term, auto___type_6 X1 -> auto___def_38 X2 -> auto___def_30 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_36_p__def_28. intros X1 X2.
  cut (auto___def_38 X2 -> auto___def_30 X2). tauto. exact (rem_2307 epsilon_m__def_36_p__def_28 X2).
Defined.

Remark rem_2309 : (forall X:term, auto___def_36 X -> auto___def_28 X)
    -> forall X1 X2:term, auto___type_6 X1 -> auto___def_38 X2 -> (auto___type_5 X1 /\ auto___def_30 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_36_p__def_28. intros X1 X2. intros A1 A2.
  cut (auto___type_5 X1). 2:apply (rem_2240 epsilon_m__def_36_p__def_28 X1 X2);  assumption.
  cut (auto___def_30 X2). 2:apply (rem_2308 epsilon_m__def_36_p__def_28 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2310 : (forall X:term, auto___def_36 X -> auto___def_28 X)
    -> forall X1 X2:term, auto___type_6 X1 -> auto___def_38 X2 -> auto___def_28 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_36_p__def_28. intros X1 X2. intros A1 A2.
  case (rem_2309 epsilon_m__def_36_p__def_28 X1 X2 A1 A2). clear  epsilon_m__def_36_p__def_28 A1 A2. intros. apply trans___def_28_cons_1;  tauto.
 clear  epsilon_m__def_36_p__def_28 A1 A2. tauto.
Defined.

Remark rem_2311 : (forall X:term, auto___def_36 X -> auto___def_28 X)
    -> forall X1 X2:term, auto___def_36 (cons X1 X2) -> auto___def_28 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_36_p__def_28. intros X1 X2. intro H. intros.
  elim (rem_1935 X1 X2 H);  intros.
  apply (rem_2310 epsilon_m__def_36_p__def_28 X1 X2);  tauto.
Defined.

Remark rem_2312 : forall X1 X2:term, auto___def_36 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2313 : forall X1 X2:term, auto___def_36 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2314 : forall X1 X2:term, auto___def_36 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2315 : forall X1 X2:term, auto___def_36 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2316 : forall X1 X2:term, auto___def_36 (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2317 : forall X1 X2:term, auto___def_36 (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2318 : forall X1:term, auto___def_36 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2319 : auto___def_36 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2320 : forall X1 X2:term, auto___def_36 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2321 : forall X1 X2:term, auto___def_36 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2322 : auto___def_36 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2323 : forall X1 X2:term, auto___def_36 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2324 : forall X1 X2:term, auto___def_36 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2325 : forall X1 X2:term, auto___def_36 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2326 : forall X1:term, auto___def_36 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2327 : auto___def_36 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2328 : forall X1 X2:term, auto___def_36 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2329 : auto___def_36 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2330 : forall X1 X2:term, auto___def_36 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2331 : forall X1 X2:term, auto___def_36 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2332 : forall X2:term, auto___def_36 X2 -> auto___def_28 X2. (* Induct. *)
Proof.
  fix epsilon_m__def_36_p__def_28 1.
  intro X. case X.
   intro H. elim (rem_1993  H).
   intro H. elim (rem_1990  H).
  intros X1 X2;  exact (rem_2311 epsilon_m__def_36_p__def_28 X1 X2).
  intros X1 X2. intro H. elim (rem_2312 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2324 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2325 X1 X2 H).
   intro H. elim (rem_1984  H).
  intros X1 X2. intro H. elim (rem_2331 X1 X2 H).
   intro H. elim (rem_2329  H).
  intros X1 X2. intro H. elim (rem_2330 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2315 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2313 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2323 X1 X2 H).
  intros X1. intro H. elim (rem_2318 X1 H).
  intros X1 X2. intro H. elim (rem_2321 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2320 X1 X2 H).
   intro H. elim (rem_2322  H).
   intro H. elim (rem_2319  H).
  intros X1 X2. intro H. elim (rem_2317 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2316 X1 X2 H).
  intros X1. intro H. elim (rem_2326 X1 H).
   intro H. elim (rem_1998  H).
  intros X1 X2. intro H. elim (rem_2328 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2314 X1 X2 H).
   intro H. elim (rem_2327  H).
Qed.

Remark rem_2333 : forall X1 X2 X3:term, auto___def_36 X2 -> auto___def_37 (key sym (r_old X3 X1)) -> auto_knows_old X3 -> auto___def_28 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_36 X2 -> auto___def_28 X2). tauto. exact (rem_2332 X2).
Qed.

Remark rem_2334 : forall X1 X2 X3:term, auto___def_36 X2 -> auto___def_37 (key sym (r_old X3 X1)) -> auto_knows_old X3 -> auto_knows_old X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_old X3 -> auto_knows_old X3). tauto. exact (rem_1278 X3).
Qed.

Remark rem_2335 : forall X1 X2 X3:term, auto___def_36 X2 -> auto___def_37 (key sym (r_old X3 X1)) -> auto_knows_old X3 -> (auto___def_28 X2 /\ auto_knows_old X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_28 X2). 2:apply (rem_2333 X1 X2 X3);  assumption.
  cut (auto_knows_old X3). 2:apply (rem_2334 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_2336 : forall X1 X2 X3:term, auto___def_36 X2 -> auto___def_37 (key sym (r_old X3 X1)) -> auto_knows_old X3 -> auto___def_35 X1 X2 X3. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  case (rem_2335 X1 X2 X3 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_35_2;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2337 : forall X1 X2 X3:term, auto___def_24 X2 -> auto___def_25 (key sym (r_old X3 X1)) -> auto_knows_old X3 -> auto___def_24 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_24 X2 -> auto___def_24 X2). tauto. exact (rem_1892 X2).
Qed.

Remark rem_2338 : forall X1 X2 X3:term, auto___def_24 X2 -> auto___def_25 (key sym (r_old X3 X1)) -> auto_knows_old X3 -> auto_knows_old X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_old X3 -> auto_knows_old X3). tauto. exact (rem_1278 X3).
Qed.

Remark rem_2339 : forall X1 X2 X3:term, auto___def_24 X2 -> auto___def_25 (key sym (r_old X3 X1)) -> auto_knows_old X3 -> (auto___def_24 X2 /\ auto_knows_old X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_24 X2). 2:apply (rem_2337 X1 X2 X3);  assumption.
  cut (auto_knows_old X3). 2:apply (rem_2338 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_2340 : forall X1 X2 X3:term, auto___def_24 X2 -> auto___def_25 (key sym (r_old X3 X1)) -> auto_knows_old X3 -> auto___def_35 X1 X2 X3. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  case (rem_2339 X1 X2 X3 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_35_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2341 : forall X1 X2 X3:term, auto___def_44 (key sym (r_old X3 X1)) -> auto___type_7 X2 -> auto_knows_old X3 -> auto___type_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___type_7 X2 -> auto___type_7 X2). tauto. exact (rem_1900 X2).
Qed.

Remark rem_2342 : forall X1 X2 X3:term, auto___def_44 (key sym (r_old X3 X1)) -> auto___type_7 X2 -> auto_knows_old X3 -> auto_knows_old X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_old X3 -> auto_knows_old X3). tauto. exact (rem_1278 X3).
Qed.

Remark rem_2343 : forall X1 X2 X3:term, auto___def_44 (key sym (r_old X3 X1)) -> auto___type_7 X2 -> auto_knows_old X3 -> (auto___type_7 X2 /\ auto_knows_old X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___type_7 X2). 2:apply (rem_2341 X1 X2 X3);  assumption.
  cut (auto_knows_old X3). 2:apply (rem_2342 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_2344 : forall X1 X2 X3:term, auto___def_44 (key sym (r_old X3 X1)) -> auto___type_7 X2 -> auto_knows_old X3 -> auto___def_35 X1 X2 X3. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  case (rem_2343 X1 X2 X3 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_35_3;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2345 : forall X1 X2 X3:term, auto___type_7 X2 -> auto___def_44 (key sym (r_old X3 X1)) -> auto_knows_old X3 -> auto___def_35 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_44 (key sym (r_old X3 X1)) -> auto___type_7 X2 -> auto_knows_old X3 -> auto___def_35 X1 X2 X3). tauto. exact (rem_2344 X1 X2 X3).
Qed.

Remark rem_2346 : forall X1 X2 X3:term, auto___def_62 (r_old X3 X1) -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_35 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_319 X3 X1 H);  intros.
Qed.

Remark rem_2347 : forall X1 X2 X3:term, auto___def_61 sym -> auto___def_62 (r_old X3 X1) -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_35 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_62 (r_old X3 X1) -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_35 X1 X2 X3). tauto.
  exact (rem_2346 X1 X2 X3).
Qed.

Remark rem_2348 : forall X1 X2 X3:term, auto_agent (r_old X3 X1) -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_35 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1098 X3 X1 H);  intros.
Qed.

Remark rem_2349 : forall X1 X2 X3:term, auto___def_51 sym -> auto_agent (r_old X3 X1) -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_35 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto_agent (r_old X3 X1) -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_35 X1 X2 X3). tauto.
  exact (rem_2348 X1 X2 X3).
Qed.

Remark rem_2350 : forall X1 X2 X3:term, auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old (key sym (r_old X3 X1)) -> auto___def_35 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1 H2. intro H. intros.
  elim (rem_1361 sym (r_old X3 X1) H);  intros.
  apply (rem_2347 X1 X2 X3);  tauto.
  apply (rem_2349 X1 X2 X3);  tauto.
Qed.

Remark rem_2351 : forall X1 X2 X3:term, auto_knows_old X2 -> auto_knows_old (key sym (r_old X3 X1)) -> auto_knows_old X3 -> auto___def_35 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old (key sym (r_old X3 X1)) -> auto___def_35 X1 X2 X3). tauto. exact (rem_2350 X1 X2 X3).
Qed.

Remark rem_2352 : forall X1 X2 X3:term, auto_knows_old X3 -> auto_knows_old (crypt X2 (key sym (r_old X3 X1))) -> auto___def_35 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_1860 X2 (key sym (r_old X3 X1)) H);  intros.
  apply (rem_2336 X1 X2 X3);  tauto.
  apply (rem_2340 X1 X2 X3);  tauto.
  apply (rem_2345 X1 X2 X3);  tauto.
  apply (rem_2351 X1 X2 X3);  tauto.
Qed.

Remark rem_2353 : forall X1 X2 X3 X4:term, auto_knows_old X3 -> auto_knows_old (cons X4 nil) -> auto_knows_old (crypt X2 (key sym (r_old X3 X1))) -> auto___def_35 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old X3 -> auto_knows_old (crypt X2 (key sym (r_old X3 X1))) -> auto___def_35 X1 X2 X3). tauto.
  exact (rem_2352 X1 X2 X3).
Qed.

Remark rem_2354 : forall X1 X2 X3 X4:term, auto_knows_old (cons X3 (cons X4 nil)) -> auto_knows_old (crypt X2 (key sym (r_old X3 X1))) -> auto___def_35 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1263 X3 (cons X4 nil) H);  intros.
  apply (rem_2353 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2355 : forall X1 X2 X3 X4:term, auto_knows_old (crypt X2 (key sym (r_old X3 X1))) -> auto_knows_old (cons X3 (cons X4 nil)) -> auto___def_35 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_old (cons X3 (cons X4 nil)) -> auto_knows_old (crypt X2 (key sym (r_old X3 X1))) -> auto___def_35 X1 X2 X3). tauto. exact (rem_2354 X1 X2 X3 X4).
Qed.

Remark rem_2356 : auto___def_117 prv. (* Deduce positive atom. *)
Proof.
   case rem_855. intros. apply trans___def_117_prv_1;  tauto.
 tauto.
Qed.

Remark rem_2357 : (forall X:term, auto___type_22 X -> auto___type_21 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2358 : (forall X:term, auto___type_22 X -> auto___type_21 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_22_p__type_21. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_2357 epsilon_m__type_22_p__type_21 X1);  assumption.
  tauto.
Defined.

Remark rem_2359 : (forall X:term, auto___type_22 X -> auto___type_21 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto___type_21 (nonceb_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_22_p__type_21. intros X1 X2. intros A1.
  case (rem_2358 epsilon_m__type_22_p__type_21 X1 A1). clear  epsilon_m__type_22_p__type_21 A1. intros. apply trans___type_21_nonceb_current_1;  tauto.
 clear  epsilon_m__type_22_p__type_21 A1. tauto.
Defined.

Remark rem_2360 : (forall X:term, auto___type_22 X -> auto___type_21 X)
    -> forall X1 X2:term, auto___type_22 (nonceb_current X1 X2) -> auto___type_21 (nonceb_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_22_p__type_21. intros X1 X2. intro H. intros.
  elim (rem_1610 X1 X2 H);  intros.
  apply (rem_2359 epsilon_m__type_22_p__type_21 X1 X2);  tauto.
Defined.

Remark rem_2361 : forall X1:term, auto___type_22 X1 -> auto___type_21 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_22_p__type_21 1.
  intro X. case X.
   intro H. elim (rem_1622  H).
   intro H. elim (rem_1614  H).
  intros X1 X2. intro H. elim (rem_1627 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1612 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1625 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1626 X1 X2 H).
   intro H. elim (rem_1631  H).
  intros X1 X2. intro H. elim (rem_1635 X1 X2 H).
   intro H. elim (rem_1632  H).
  intros X1 X2. intro H. elim (rem_1634 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1615 X1 X2 H).
  intros X1 X2;  exact (rem_2360 epsilon_m__type_22_p__type_21 X1 X2).
  intros X1 X2. intro H. elim (rem_1624 X1 X2 H).
  intros X1. intro H. elim (rem_1618 X1 H).
  intros X1 X2. intro H. elim (rem_1621 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1620 X1 X2 H).
   intro H. elim (rem_1623  H).
   intro H. elim (rem_1619  H).
  intros X1 X2. intro H. elim (rem_1617 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1616 X1 X2 H).
  intros X1. intro H. elim (rem_1628 X1 H).
   intro H. elim (rem_1633  H).
  intros X1 X2. intro H. elim (rem_1630 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1613 X1 X2 H).
   intro H. elim (rem_1629  H).
Qed.

Remark rem_2362 : forall X1 X2:term, auto___type_22 X1 -> auto_knows_current X2 -> auto___type_21 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_22 X1 -> auto___type_21 X1). tauto. exact (rem_2361 X1).
Qed.

Remark rem_2363 : forall X1 X3:term, auto___type_22 X1 -> auto_knows_current X3 -> auto___type_21 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___type_22 X1 -> auto_knows_current X2 -> auto___type_21 X1). tauto. exact (rem_2362 X1 X2).
Qed.

Remark rem_2364 : (forall X:term, auto___def_96 X -> auto___type_21 X)
    -> forall X1:term, auto___type_21 X1 -> auto___type_21 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2365 : (forall X:term, auto___def_96 X -> auto___type_21 X)
    -> forall X1 X2:term, auto___type_21 X1 -> auto___def_98 X2 -> auto___type_21 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_96_p__type_21. intros X1 X2.
  cut (auto___type_21 X1 -> auto___type_21 X1). tauto. exact (rem_2364 epsilon_m__def_96_p__type_21 X1).
Defined.

Remark rem_2366 : (forall X:term, auto___def_96 X -> auto___type_21 X)
    -> forall X2:term, auto___def_98 X2 -> auto___def_98 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2367 : (forall X:term, auto___def_96 X -> auto___type_21 X)
    -> forall X1 X2:term, auto___type_21 X1 -> auto___def_98 X2 -> auto___def_98 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_96_p__type_21. intros X1 X2.
  cut (auto___def_98 X2 -> auto___def_98 X2). tauto. exact (rem_2366 epsilon_m__def_96_p__type_21 X2).
Defined.

Remark rem_2368 : (forall X:term, auto___def_96 X -> auto___type_21 X)
    -> forall X1 X2:term, auto___type_21 X1 -> auto___def_98 X2 -> (auto___type_21 X1 /\ auto___def_98 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_96_p__type_21. intros X1 X2. intros A1 A2.
  cut (auto___type_21 X1). 2:apply (rem_2365 epsilon_m__def_96_p__type_21 X1 X2);  assumption.
  cut (auto___def_98 X2). 2:apply (rem_2367 epsilon_m__def_96_p__type_21 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2369 : (forall X:term, auto___def_96 X -> auto___type_21 X)
    -> forall X1 X2:term, auto___type_21 X1 -> auto___def_98 X2 -> auto___type_21 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_96_p__type_21. intros X1 X2. intros A1 A2.
  case (rem_2368 epsilon_m__def_96_p__type_21 X1 X2 A1 A2). clear  epsilon_m__def_96_p__type_21 A1 A2. intros. apply trans___type_21_cons_1;  tauto.
 clear  epsilon_m__def_96_p__type_21 A1 A2. tauto.
Defined.

Remark rem_2370 : (forall X:term, auto___def_96 X -> auto___type_21 X)
    -> forall X1 X2:term, auto___def_96 (cons X1 X2) -> auto___type_21 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_96_p__type_21. intros X1 X2. intro H. intros.
  elim (rem_1645 X1 X2 H);  intros.
  apply (rem_2369 epsilon_m__def_96_p__type_21 X1 X2);  tauto.
Defined.

Remark rem_2371 : forall X1:term, auto___def_96 X1 -> auto___type_21 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_96_p__type_21 1.
  intro X. case X.
   intro H. elim (rem_1658  H).
   intro H. elim (rem_1650  H).
  intros X1 X2;  exact (rem_2370 epsilon_m__def_96_p__type_21 X1 X2).
  intros X1 X2. intro H. elim (rem_1647 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1661 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1662 X1 X2 H).
   intro H. elim (rem_1666  H).
  intros X1 X2. intro H. elim (rem_1670 X1 X2 H).
   intro H. elim (rem_1667  H).
  intros X1 X2. intro H. elim (rem_1669 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1651 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1648 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1660 X1 X2 H).
  intros X1. intro H. elim (rem_1654 X1 H).
  intros X1 X2. intro H. elim (rem_1657 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1656 X1 X2 H).
   intro H. elim (rem_1659  H).
   intro H. elim (rem_1655  H).
  intros X1 X2. intro H. elim (rem_1653 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1652 X1 X2 H).
  intros X1. intro H. elim (rem_1663 X1 H).
   intro H. elim (rem_1668  H).
  intros X1 X2. intro H. elim (rem_1665 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1649 X1 X2 H).
   intro H. elim (rem_1664  H).
Qed.

Remark rem_2372 : forall X1 X2:term, auto___def_96 X1 -> auto_knows_current X2 -> auto___type_21 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_96 X1 -> auto___type_21 X1). tauto. exact (rem_2371 X1).
Qed.

Remark rem_2373 : forall X1 X3:term, auto___def_96 X1 -> auto_knows_current X3 -> auto___type_21 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_96 X1 -> auto_knows_current X2 -> auto___type_21 X1). tauto. exact (rem_2372 X1 X2).
Qed.

Remark rem_2374 : (forall X:term, auto___def_84 X -> auto___type_21 X)
    -> forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2375 : (forall X:term, auto___def_84 X -> auto___type_21 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_84_p__type_21. intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_2374 epsilon_m__def_84_p__type_21 X1).
Defined.

Remark rem_2376 : (forall X:term, auto___def_84 X -> auto___type_21 X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2377 : (forall X:term, auto___def_84 X -> auto___type_21 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_84_p__type_21. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_2376 epsilon_m__def_84_p__type_21 X2).
Defined.

Remark rem_2378 : (forall X:term, auto___def_84 X -> auto___type_21 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> (auto_agent X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_84_p__type_21. intros X1 X2. intros A1 A2.
  cut (auto_agent X1). 2:apply (rem_2375 epsilon_m__def_84_p__type_21 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_2377 epsilon_m__def_84_p__type_21 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2379 : (forall X:term, auto___def_84 X -> auto___type_21 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_21 (noncea_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_84_p__type_21. intros X1 X2. intros A1 A2.
  case (rem_2378 epsilon_m__def_84_p__type_21 X1 X2 A1 A2). clear  epsilon_m__def_84_p__type_21 A1 A2. intros. apply trans___type_21_noncea_current_1;  tauto.
 clear  epsilon_m__def_84_p__type_21 A1 A2. tauto.
Defined.

Remark rem_2380 : (forall X:term, auto___def_84 X -> auto___type_21 X)
    -> forall X1 X2:term, auto___def_84 (noncea_current X1 X2) -> auto___type_21 (noncea_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_84_p__type_21. intros X1 X2. intro H. intros.
  elim (rem_1680 X1 X2 H);  intros.
  apply (rem_2379 epsilon_m__def_84_p__type_21 X1 X2);  tauto.
Defined.

Remark rem_2381 : forall X1:term, auto___def_84 X1 -> auto___type_21 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_84_p__type_21 1.
  intro X. case X.
   intro H. elim (rem_1693  H).
   intro H. elim (rem_1685  H).
  intros X1 X2. intro H. elim (rem_1698 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1682 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1696 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1697 X1 X2 H).
   intro H. elim (rem_1702  H).
  intros X1 X2. intro H. elim (rem_1705 X1 X2 H).
   intro H. elim (rem_1703  H).
  intros X1 X2;  exact (rem_2380 epsilon_m__def_84_p__type_21 X1 X2).
  intros X1 X2. intro H. elim (rem_1686 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1683 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1695 X1 X2 H).
  intros X1. intro H. elim (rem_1689 X1 H).
  intros X1 X2. intro H. elim (rem_1692 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1691 X1 X2 H).
   intro H. elim (rem_1694  H).
   intro H. elim (rem_1690  H).
  intros X1 X2. intro H. elim (rem_1688 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1687 X1 X2 H).
  intros X1. intro H. elim (rem_1699 X1 H).
   intro H. elim (rem_1704  H).
  intros X1 X2. intro H. elim (rem_1701 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1684 X1 X2 H).
   intro H. elim (rem_1700  H).
Qed.

Remark rem_2382 : forall X1 X2:term, auto___def_84 X1 -> auto_knows_current X2 -> auto___type_21 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_84 X1 -> auto___type_21 X1). tauto. exact (rem_2381 X1).
Qed.

Remark rem_2383 : forall X1 X3:term, auto___def_84 X1 -> auto_knows_current X3 -> auto___type_21 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_84 X1 -> auto_knows_current X2 -> auto___type_21 X1). tauto. exact (rem_2382 X1 X2).
Qed.

Remark rem_2384 : forall X1 X2 X3:term, auto___def_95 X2 X1 X3 -> auto___type_21 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_298 X2 X1 X3 H);  intros.
  apply (rem_2363 X1 X3);  tauto.
  apply (rem_2373 X1 X3);  tauto.
  apply (rem_2383 X1 X3);  tauto.
Qed.

Remark rem_2385 : forall X1:term, auto___def_12 X1 -> auto___def_12 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2386 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_12 X1). tauto. exact (rem_2385 X1).
Qed.

Remark rem_2387 : forall X2:term, auto___def_13 X2 -> auto___def_13 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2388 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_2387 X2).
Qed.

Remark rem_2389 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> (auto___def_12 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_12 X1). 2:apply (rem_2386 X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_2388 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2390 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_10 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2389 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_10_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2391 : forall X1 X2:term, auto___def_13 X2 -> auto___def_12 X1 -> auto___def_10 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_13 X2 -> auto___def_10 (key X1 X2)). tauto. exact (rem_2390 X1 X2).
Qed.

Remark rem_2392 : forall X1:term, auto___type_21 X1 -> auto___type_21 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2393 : forall X1 X2:term, auto___def_98 X2 -> auto___type_21 X1 -> auto___type_21 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_21 X1 -> auto___type_21 X1). tauto. exact (rem_2392 X1).
Qed.

Remark rem_2394 : forall X2:term, auto___def_98 X2 -> auto___def_98 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2395 : forall X1 X2:term, auto___def_98 X2 -> auto___type_21 X1 -> auto___def_98 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_98 X2 -> auto___def_98 X2). tauto. exact (rem_2394 X2).
Qed.

Remark rem_2396 : forall X1 X2:term, auto___def_98 X2 -> auto___type_21 X1 -> (auto___type_21 X1 /\ auto___def_98 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_21 X1). 2:apply (rem_2393 X1 X2);  assumption.
  cut (auto___def_98 X2). 2:apply (rem_2395 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2397 : forall X1 X2:term, auto___def_98 X2 -> auto___type_21 X1 -> auto___def_96 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2396 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_96_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2398 : forall X1:term, auto___def_91 X1 -> auto___def_91 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2399 : forall X1 X2:term, auto___def_91 X1 -> auto___def_92 X2 -> auto___def_91 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_91 X1 -> auto___def_91 X1). tauto. exact (rem_2398 X1).
Qed.

Remark rem_2400 : forall X2:term, auto___def_92 X2 -> auto___def_92 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2401 : forall X1 X2:term, auto___def_91 X1 -> auto___def_92 X2 -> auto___def_92 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_92 X2 -> auto___def_92 X2). tauto. exact (rem_2400 X2).
Qed.

Remark rem_2402 : forall X1 X2:term, auto___def_91 X1 -> auto___def_92 X2 -> (auto___def_91 X1 /\ auto___def_92 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_91 X1). 2:apply (rem_2399 X1 X2);  assumption.
  cut (auto___def_92 X2). 2:apply (rem_2401 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2403 : forall X1 X2:term, auto___def_91 X1 -> auto___def_92 X2 -> auto___def_90 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2402 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_90_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2404 : forall X1 X2:term, auto___def_92 X2 -> auto___def_91 X1 -> auto___def_90 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_91 X1 -> auto___def_92 X2 -> auto___def_90 (cons X1 X2)). tauto. exact (rem_2403 X1 X2).
Qed.

Remark rem_2405 : forall X1:term, auto___type_5 X1 -> auto___type_5 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2406 : forall X1 X2:term, auto___def_30 X2 -> auto___type_5 X1 -> auto___type_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_5 X1 -> auto___type_5 X1). tauto. exact (rem_2405 X1).
Qed.

Remark rem_2407 : forall X2:term, auto___def_30 X2 -> auto___def_30 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2408 : forall X1 X2:term, auto___def_30 X2 -> auto___type_5 X1 -> auto___def_30 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_30 X2 -> auto___def_30 X2). tauto. exact (rem_2407 X2).
Qed.

Remark rem_2409 : forall X1 X2:term, auto___def_30 X2 -> auto___type_5 X1 -> (auto___type_5 X1 /\ auto___def_30 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_5 X1). 2:apply (rem_2406 X1 X2);  assumption.
  cut (auto___def_30 X2). 2:apply (rem_2408 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2410 : forall X1 X2:term, auto___def_30 X2 -> auto___type_5 X1 -> auto___def_28 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2409 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_28_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2411 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto___def_36 X1 -> auto___def_36 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2412 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_36 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_36 X1 -> auto___def_36 X1). tauto. exact (rem_2411 epsilon_mknows_old_p__type_3 X1).
Defined.

Remark rem_2413 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X2:term, auto___def_37 X2 -> auto___def_37 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2414 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_37 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_37 X2 -> auto___def_37 X2). tauto. exact (rem_2413 epsilon_mknows_old_p__type_3 X2).
Defined.

Remark rem_2415 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> (auto___def_36 X1 /\ auto___def_37 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_36 X1). 2:apply (rem_2412 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  cut (auto___def_37 X2). 2:apply (rem_2414 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2416 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2415 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_crypt_1;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2417 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto___def_24 X1 -> auto___def_24 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2418 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___def_24 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_24 X1 -> auto___def_24 X1). tauto. exact (rem_2417 epsilon_mknows_old_p__type_3 X1).
Defined.

Remark rem_2419 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X2:term, auto___def_25 X2 -> auto___def_25 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2420 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___def_25 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_25 X2 -> auto___def_25 X2). tauto. exact (rem_2419 epsilon_mknows_old_p__type_3 X2).
Defined.

Remark rem_2421 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> (auto___def_24 X1 /\ auto___def_25 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_24 X1). 2:apply (rem_2418 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  cut (auto___def_25 X2). 2:apply (rem_2420 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2422 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___type_3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2421 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_crypt_2;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2423 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto___type_7 X1 -> auto___type_7 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2424 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___type_7 X1 -> auto___type_7 X1). tauto. exact (rem_2423 epsilon_mknows_old_p__type_3 X1).
Defined.

Remark rem_2425 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X2:term, auto___def_44 X2 -> auto___def_44 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2426 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___def_44 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_44 X2 -> auto___def_44 X2). tauto. exact (rem_2425 epsilon_mknows_old_p__type_3 X2).
Defined.

Remark rem_2427 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> (auto___type_7 X1 /\ auto___def_44 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___type_7 X1). 2:apply (rem_2424 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  cut (auto___def_44 X2). 2:apply (rem_2426 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2428 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_44 X2 -> auto___type_3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2427 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_crypt_3;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2429 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2430 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto_knows_old X1 -> auto_knows_old X1). tauto. exact (rem_2429 epsilon_mknows_old_p__type_3 X1).
Defined.

Remark rem_2431 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X2:term, auto_knows_old X2 -> auto_knows_old X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2432 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_2431 epsilon_mknows_old_p__type_3 X2).
Defined.

Remark rem_2433 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> (auto_knows_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_2430 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_2432 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2434 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2433 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_crypt_4;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2435 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old (crypt X1 X2) -> auto___type_3 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intro H. intros.
  elim (rem_1860 X1 X2 H);  intros.
  apply (rem_2416 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
  apply (rem_2422 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
  apply (rem_2428 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
  apply (rem_2434 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
Defined.

Remark rem_2436 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3.  tauto.
Defined.

Remark rem_2437 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto___type_3 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3.  case (rem_2436 epsilon_mknows_old_p__type_3). clear  epsilon_mknows_old_p__type_3. intros. apply trans___type_3_bob_1;  tauto.
 clear  epsilon_mknows_old_p__type_3. tauto.
Defined.

Remark rem_2438 : auto_knows_old bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2439 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto_knows_old bob -> auto___type_3 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intro H. intros.
  elim (rem_2438 H);  intros.
  apply (rem_2437 epsilon_mknows_old_p__type_3);  tauto.
Defined.

Remark rem_2440 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1. intros A1.
  cut (auto_knows_old X1). 2:apply (rem_2429 epsilon_mknows_old_p__type_3 X1);  assumption.
  tauto.
Defined.

Remark rem_2441 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto_knows_old X1 -> auto___type_3 (p X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1. intros A1.
  case (rem_2440 epsilon_mknows_old_p__type_3 X1 A1). clear  epsilon_mknows_old_p__type_3 A1. intros. apply trans___type_3_p_1;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1. tauto.
Defined.

Remark rem_2442 : forall X1:term, auto_knows_old (p X1) -> or_1
    (auto_knows_old X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2443 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto_knows_old (p X1) -> auto___type_3 (p X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1. intro H. intros.
  elim (rem_2442 X1 H);  intros.
  apply (rem_2441 epsilon_mknows_old_p__type_3 X1);  tauto.
Defined.

Remark rem_2444 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto___type_3 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3.  case (rem_2436 epsilon_mknows_old_p__type_3). clear  epsilon_mknows_old_p__type_3. intros. apply trans___type_3_alice_1;  tauto.
 clear  epsilon_mknows_old_p__type_3. tauto.
Defined.

Remark rem_2445 : auto_knows_old alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2446 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto_knows_old alice -> auto___type_3 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intro H. intros.
  elim (rem_2445 H);  intros.
  apply (rem_2444 epsilon_mknows_old_p__type_3);  tauto.
Defined.

Remark rem_2447 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_3 (dec X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2433 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_dec_1;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2448 : forall X1 X2:term, auto_knows_old (dec X1 X2) -> or_1
    (auto_knows_old X1 /\ auto_knows_old X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2449 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old (dec X1 X2) -> auto___type_3 (dec X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intro H. intros.
  elim (rem_2448 X1 X2 H);  intros.
  apply (rem_2447 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
Defined.

Remark rem_2450 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto___def_10 X1 -> auto___def_10 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2451 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_10 X1). tauto. exact (rem_2450 epsilon_mknows_old_p__type_3 X1).
Defined.

Remark rem_2452 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X2:term, auto___def_11 X2 -> auto___def_11 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2453 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_11 X2 -> auto___def_11 X2). tauto. exact (rem_2452 epsilon_mknows_old_p__type_3 X2).
Defined.

Remark rem_2454 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> (auto___def_10 X1 /\ auto___def_11 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_10 X1). 2:apply (rem_2451 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  cut (auto___def_11 X2). 2:apply (rem_2453 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2455 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___type_3 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2454 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_enc_1;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2456 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto___def_15 X1 -> auto___def_15 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2457 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_15 X1 -> auto___def_16 X2 -> auto___def_15 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_15 X1 -> auto___def_15 X1). tauto. exact (rem_2456 epsilon_mknows_old_p__type_3 X1).
Defined.

Remark rem_2458 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X2:term, auto___def_16 X2 -> auto___def_16 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2459 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_15 X1 -> auto___def_16 X2 -> auto___def_16 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_16 X2 -> auto___def_16 X2). tauto. exact (rem_2458 epsilon_mknows_old_p__type_3 X2).
Defined.

Remark rem_2460 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_15 X1 -> auto___def_16 X2 -> (auto___def_15 X1 /\ auto___def_16 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_15 X1). 2:apply (rem_2457 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  cut (auto___def_16 X2). 2:apply (rem_2459 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2461 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_15 X1 -> auto___def_16 X2 -> auto___type_3 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2460 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_enc_2;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2462 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto___def_19 X1 -> auto___def_19 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2463 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto___def_19 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_19 X1 -> auto___def_19 X1). tauto. exact (rem_2462 epsilon_mknows_old_p__type_3 X1).
Defined.

Remark rem_2464 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X2:term, auto___def_20 X2 -> auto___def_20 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2465 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto___def_20 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_20 X2 -> auto___def_20 X2). tauto. exact (rem_2464 epsilon_mknows_old_p__type_3 X2).
Defined.

Remark rem_2466 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> (auto___def_19 X1 /\ auto___def_20 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_19 X1). 2:apply (rem_2463 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  cut (auto___def_20 X2). 2:apply (rem_2465 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2467 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto___type_3 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2466 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_enc_3;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2468 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_3 (enc X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2433 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_enc_4;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2469 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old (enc X1 X2) -> auto___type_3 (enc X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intro H. intros.
  elim (rem_1290 X1 X2 H);  intros.
  apply (rem_2455 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
  apply (rem_2461 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
  apply (rem_2467 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
  apply (rem_2468 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
Defined.

Remark rem_2470 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_3 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2433 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_cons_1;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2471 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old (cons X1 X2) -> auto___type_3 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intro H. intros.
  elim (rem_1263 X1 X2 H);  intros.
  apply (rem_2470 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
Defined.

Remark rem_2472 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto_knows_old X1 -> auto___type_3 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1. intros A1.
  case (rem_2440 epsilon_mknows_old_p__type_3 X1 A1). clear  epsilon_mknows_old_p__type_3 A1. intros. apply trans___type_3_s_1;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1. tauto.
Defined.

Remark rem_2473 : forall X1:term, auto_knows_old (s X1) -> or_1
    (auto_knows_old X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2474 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto_knows_old (s X1) -> auto___type_3 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1. intro H. intros.
  elim (rem_2473 X1 H);  intros.
  apply (rem_2472 epsilon_mknows_old_p__type_3 X1);  tauto.
Defined.

Remark rem_2475 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto___type_3 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3.  case (rem_2436 epsilon_mknows_old_p__type_3). clear  epsilon_mknows_old_p__type_3. intros. apply trans___type_3_i_1;  tauto.
 clear  epsilon_mknows_old_p__type_3. tauto.
Defined.

Remark rem_2476 : auto_knows_old i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2477 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto_knows_old i -> auto___type_3 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intro H. intros.
  elim (rem_2476 H);  intros.
  apply (rem_2475 epsilon_mknows_old_p__type_3);  tauto.
Defined.

Remark rem_2478 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto___type_3 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3.  case (rem_2436 epsilon_mknows_old_p__type_3). clear  epsilon_mknows_old_p__type_3. intros. apply trans___type_3_nil_1;  tauto.
 clear  epsilon_mknows_old_p__type_3. tauto.
Defined.

Remark rem_2479 : auto_knows_old nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2480 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto_knows_old nil -> auto___type_3 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intro H. intros.
  elim (rem_2479 H);  intros.
  apply (rem_2478 epsilon_mknows_old_p__type_3);  tauto.
Defined.

Remark rem_2481 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto___type_3 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3.  case (rem_2436 epsilon_mknows_old_p__type_3). clear  epsilon_mknows_old_p__type_3. intros. apply trans___type_3_server_1;  tauto.
 clear  epsilon_mknows_old_p__type_3. tauto.
Defined.

Remark rem_2482 : auto_knows_old server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2483 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto_knows_old server -> auto___type_3 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intro H. intros.
  elim (rem_2482 H);  intros.
  apply (rem_2481 epsilon_mknows_old_p__type_3);  tauto.
Defined.

Remark rem_2484 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto___def_61 X1 -> auto___def_61 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2485 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto___def_61 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_61 X1 -> auto___def_61 X1). tauto. exact (rem_2484 epsilon_mknows_old_p__type_3 X1).
Defined.

Remark rem_2486 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X2:term, auto___def_62 X2 -> auto___def_62 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2487 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto___def_62 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_62 X2 -> auto___def_62 X2). tauto. exact (rem_2486 epsilon_mknows_old_p__type_3 X2).
Defined.

Remark rem_2488 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> (auto___def_61 X1 /\ auto___def_62 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_61 X1). 2:apply (rem_2485 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  cut (auto___def_62 X2). 2:apply (rem_2487 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2489 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto___type_3 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2488 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_key_1;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2490 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto___def_51 X1 -> auto___def_51 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2491 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto___def_51 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_51 X1 -> auto___def_51 X1). tauto. exact (rem_2490 epsilon_mknows_old_p__type_3 X1).
Defined.

Remark rem_2492 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2493 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_2492 epsilon_mknows_old_p__type_3 X2).
Defined.

Remark rem_2494 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> (auto___def_51 X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_51 X1). 2:apply (rem_2491 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_2493 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2495 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto_agent X2 -> auto___type_3 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2494 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_key_2;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2496 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old (key X1 X2) -> auto___type_3 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intro H. intros.
  elim (rem_1361 X1 X2 H);  intros.
  apply (rem_2489 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
  apply (rem_2495 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
Defined.

Remark rem_2497 : forall X1 X2:term, auto_knows_old (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2498 : forall X1 X2:term, auto_knows_old (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2499 : forall X1 X2:term, auto_knows_old (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2500 : forall X1 X2:term, auto_knows_old (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2501 : forall X1 X2:term, auto_knows_old (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2502 : auto_knows_old pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2503 : forall X1 X2:term, auto_knows_old (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2504 : auto_knows_old prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2505 : forall X1 X2:term, auto_knows_old (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2506 : auto_knows_old sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2507 : forall X1 X2:term, auto_knows_old (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2508 : forall X1 X2:term, auto_knows_old (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2509 : forall X1:term, auto_knows_old X1 -> auto___type_3 X1. (* Induct. *)
Proof.
  fix epsilon_mknows_old_p__type_3 1.
  intro X. case X.
  exact (rem_2446 epsilon_mknows_old_p__type_3 ).
  exact (rem_2439 epsilon_mknows_old_p__type_3 ).
  intros X1 X2;  exact (rem_2471 epsilon_mknows_old_p__type_3 X1 X2).
  intros X1 X2;  exact (rem_2435 epsilon_mknows_old_p__type_3 X1 X2).
  intros X1 X2;  exact (rem_2449 epsilon_mknows_old_p__type_3 X1 X2).
  intros X1 X2;  exact (rem_2469 epsilon_mknows_old_p__type_3 X1 X2).
  exact (rem_2477 epsilon_mknows_old_p__type_3 ).
  intros X1 X2;  exact (rem_2496 epsilon_mknows_old_p__type_3 X1 X2).
  exact (rem_2480 epsilon_mknows_old_p__type_3 ).
  intros X1 X2. intro H. elim (rem_2508 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2499 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2497 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2505 X1 X2 H).
  intros X1;  exact (rem_2443 epsilon_mknows_old_p__type_3 X1).
  intros X1 X2. intro H. elim (rem_2503 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1287 X1 X2 H).
   intro H. elim (rem_2504  H).
   intro H. elim (rem_2502  H).
  intros X1 X2. intro H. elim (rem_2501 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2500 X1 X2 H).
  intros X1;  exact (rem_2474 epsilon_mknows_old_p__type_3 X1).
  exact (rem_2483 epsilon_mknows_old_p__type_3 ).
  intros X1 X2. intro H. elim (rem_2507 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2498 X1 X2 H).
   intro H. elim (rem_2506  H).
Qed.

Remark rem_2510 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old X1 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_old X1 -> auto___type_3 X1). tauto. exact (rem_2509 X1).
Qed.

Remark rem_2511 : forall X1 X2:term, auto___def_18 X2 X1 -> auto___type_3 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_868 X2 X1 H);  intros.
  apply (rem_2510 X1 X2);  tauto.
Qed.

Remark rem_2512 : forall X1:term, auto___def_114 X1 -> auto___def_114 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2513 : forall X1 X2:term, auto___def_114 X1 -> auto___def_66 X2 -> auto___def_114 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_114 X1 -> auto___def_114 X1). tauto. exact (rem_2512 X1).
Qed.

Remark rem_2514 : forall X2:term, auto___def_66 X2 -> auto___def_66 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2515 : forall X1 X2:term, auto___def_114 X1 -> auto___def_66 X2 -> auto___def_66 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_66 X2 -> auto___def_66 X2). tauto. exact (rem_2514 X2).
Qed.

Remark rem_2516 : forall X1 X2:term, auto___def_114 X1 -> auto___def_66 X2 -> (auto___def_114 X1 /\ auto___def_66 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_114 X1). 2:apply (rem_2513 X1 X2);  assumption.
  cut (auto___def_66 X2). 2:apply (rem_2515 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2517 : forall X1 X2:term, auto___def_114 X1 -> auto___def_66 X2 -> auto___def_113 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2516 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_113_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2518 : forall X1 X2:term, auto___def_66 X2 -> auto___def_114 X1 -> auto___def_113 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_114 X1 -> auto___def_66 X2 -> auto___def_113 (key X1 X2)). tauto. exact (rem_2517 X1 X2).
Qed.

Remark rem_2519 : forall X1 X2 X3:term, auto___def_24 X3 -> auto_knows_old X1 -> auto___def_42 (r_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2.
  case (rem_278 X1 X3 A1 A2). clear  A1 A2. intros. apply trans___def_42_r_old_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2520 : forall X1 X2 X3:term, auto___def_28 X3 -> auto_knows_old X1 -> auto___def_42 (r_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2.
  case (rem_281 X1 X3 A1 A2). clear  A1 A2. intros. apply trans___def_42_r_old_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2521 : forall X1 X2 X3:term, auto___type_7 X3 -> auto_knows_old X1 -> auto___def_42 (r_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2.
  case (rem_284 X1 X3 A1 A2). clear  A1 A2. intros. apply trans___def_42_r_old_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2522 : forall X1 X2 X3:term, auto___def_35 X1 X2 X3 -> or_3
    (auto___def_24 X2 /\ auto_knows_old X3)
    (auto___def_28 X2 /\ auto_knows_old X3)
    (auto___type_7 X2 /\ auto_knows_old X3)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_2523 : forall X1 X2 X3:term, auto___def_35 X2 X3 X1 -> auto___def_42 (r_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_2522 X2 X3 X1 H);  intros.
  apply (rem_2519 X1 X2 X3);  tauto.
  apply (rem_2520 X1 X2 X3);  tauto.
  apply (rem_2521 X1 X2 X3);  tauto.
Qed.

Remark rem_2524 : forall X1:term, auto___def_99 X1 -> auto___def_99 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2525 : forall X1 X2:term, auto___def_100 X2 -> auto___def_99 X1 -> auto___def_99 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_99 X1 -> auto___def_99 X1). tauto. exact (rem_2524 X1).
Qed.

Remark rem_2526 : forall X2:term, auto___def_100 X2 -> auto___def_100 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2527 : forall X1 X2:term, auto___def_100 X2 -> auto___def_99 X1 -> auto___def_100 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_100 X2 -> auto___def_100 X2). tauto. exact (rem_2526 X2).
Qed.

Remark rem_2528 : forall X1 X2:term, auto___def_100 X2 -> auto___def_99 X1 -> (auto___def_99 X1 /\ auto___def_100 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_99 X1). 2:apply (rem_2525 X1 X2);  assumption.
  cut (auto___def_100 X2). 2:apply (rem_2527 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2529 : forall X1 X2:term, auto___def_100 X2 -> auto___def_99 X1 -> auto___def_98 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2528 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_98_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2530 : auto___def_86 sym. (* Deduce positive atom. *)
Proof.
   case rem_855. intros. apply trans___def_86_sym_1;  tauto.
 tauto.
Qed.

Remark rem_2531 : forall X1 X2 X3 X4:term, auto___def_17 (cons (noncea_current X3 X4) (cons X2 nil)) -> auto___type_2 (key sym X1) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1339 (noncea_current X3 X4) (cons X2 nil) H);  intros.
Qed.

Remark rem_2532 : forall X1 X2 X3 X4:term, auto___def_39 X2 -> auto___def_42 X1 -> auto___type_6 (noncea_current X3 X4) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_2236 X3 X4 H);  intros.
Qed.

Remark rem_2533 : forall X1 X2 X3 X4:term, auto___def_39 X2 -> auto___def_40 nil -> auto___def_42 X1 -> auto___type_6 (noncea_current X3 X4) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_39 X2 -> auto___def_42 X1 -> auto___type_6 (noncea_current X3 X4) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2). tauto.
  exact (rem_2532 X1 X2 X3 X4).
Qed.

Remark rem_2534 : forall X1 X2 X3 X4:term, auto___def_38 (cons X2 nil) -> auto___def_42 X1 -> auto___type_6 (noncea_current X3 X4) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1929 X2 nil H);  intros.
  apply (rem_2533 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2535 : forall X1 X2 X3 X4:term, auto___def_38 (cons X2 nil) -> auto___def_41 sym -> auto___def_42 X1 -> auto___type_6 (noncea_current X3 X4) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_38 (cons X2 nil) -> auto___def_42 X1 -> auto___type_6 (noncea_current X3 X4) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2). tauto.
  exact (rem_2534 X1 X2 X3 X4).
Qed.

Remark rem_2536 : forall X1 X2 X3 X4:term, auto___def_41 sym -> auto___def_42 X1 -> auto___def_38 (cons X2 nil) -> auto___type_6 (noncea_current X3 X4) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_38 (cons X2 nil) -> auto___def_41 sym -> auto___def_42 X1 -> auto___type_6 (noncea_current X3 X4) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2). tauto. exact (rem_2535 X1 X2 X3 X4).
Qed.

Remark rem_2537 : forall X1 X2 X3 X4:term, auto___def_37 (key sym X1) -> auto___def_38 (cons X2 nil) -> auto___type_6 (noncea_current X3 X4) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1405 sym X1 H);  intros.
  apply (rem_2536 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2538 : forall X1 X2 X3 X4:term, auto___type_6 (noncea_current X3 X4) -> auto___def_38 (cons X2 nil) -> auto___def_37 (key sym X1) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_37 (key sym X1) -> auto___def_38 (cons X2 nil) -> auto___type_6 (noncea_current X3 X4) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2). tauto. exact (rem_2537 X1 X2 X3 X4).
Qed.

Remark rem_2539 : forall X1 X2 X3 X4:term, auto___def_36 (cons (noncea_current X3 X4) (cons X2 nil)) -> auto___def_37 (key sym X1) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1935 (noncea_current X3 X4) (cons X2 nil) H);  intros.
  apply (rem_2538 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2540 : forall X1 X2:term, auto___def_21 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2541 : forall X1 X2 X3 X4:term, auto___def_21 (cons (noncea_current X3 X4) (cons X2 nil)) -> auto___def_22 (key sym X1) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_2540 (noncea_current X3 X4) (cons X2 nil) H);  intros.
Qed.

Remark rem_2542 : forall X1 X2 X3 X4:term, auto___def_71 (crypt X1 (key pub (session_current X3 X4))) -> auto___def_72 (passwd_current X3 X4) -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_803 X1 (key pub (session_current X3 X4)) H);  intros.
Qed.

Remark rem_2543 : forall X1 X2:term, auto___def_17 X1 -> auto___def_61 sym -> auto___def_62 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_1948 X1)). tauto.
Qed.

Remark rem_2544 : forall X1 X2:term, auto___def_61 sym -> auto___def_62 X1 -> auto___def_17 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_17 X1 -> auto___def_61 sym -> auto___def_62 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2). tauto. exact (rem_2543 X1 X2).
Qed.

Remark rem_2545 : forall X1 X2:term, auto___def_17 X1 -> auto___def_51 sym -> auto_agent X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_1953 X1)). tauto.
Qed.

Remark rem_2546 : forall X1 X2:term, auto___def_51 sym -> auto_agent X1 -> auto___def_17 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_17 X1 -> auto___def_51 sym -> auto_agent X1 -> auto_knows_current X2 -> auto___def_103 X1 X2). tauto. exact (rem_2545 X1 X2).
Qed.

Remark rem_2547 : (forall X:term, auto___def_17 X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (r_old X1 X2) -> auto_knows_old X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_17_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1767 X1 X2 H);  intros.
Defined.

Remark rem_2548 : (forall X:term, auto___def_17 X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_17 (r_old X1 X2) -> auto___def_13 (r_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_17_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1322 X1 X2 H);  intros.
  apply (rem_2547 epsilon_m__def_17_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_2549 : forall X1:term, auto___def_17 X1 -> auto___def_13 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_17_m__def_13 1.
  intro X. case X.
   intro H. elim (rem_1334  H).
   intro H. elim (rem_1327  H).
  intros X1 X2. intro H. elim (rem_1339 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1324 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1337 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1338 X1 X2 H).
   intro H. elim (rem_1343  H).
  intros X1 X2. intro H. elim (rem_1347 X1 X2 H).
   intro H. elim (rem_1344  H).
  intros X1 X2. intro H. elim (rem_1346 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1328 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1325 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1336 X1 X2 H).
  intros X1. intro H. elim (rem_1330 X1 H).
  intros X1 X2. intro H. elim (rem_1333 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1332 X1 X2 H).
   intro H. elim (rem_1335  H).
   intro H. elim (rem_1331  H).
  intros X1 X2. intro H. elim (rem_1329 X1 X2 H).
  intros X1 X2;  exact (rem_2548 epsilon_m__def_17_m__def_13 X1 X2).
  intros X1. intro H. elim (rem_1340 X1 H).
   intro H. elim (rem_1345  H).
  intros X1 X2. intro H. elim (rem_1342 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1326 X1 X2 H).
   intro H. elim (rem_1341  H).
Qed.

Remark rem_2550 : forall X1 X2:term, auto___def_12 sym -> auto___def_13 X1 -> auto___def_17 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2549 X1)). tauto.
Qed.

Remark rem_2551 : forall X1 X2:term, auto___def_17 X1 -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1 H2. intro H. intros.
  elim (rem_1066 sym X1 H);  intros.
  apply (rem_2544 X1 X2);  tauto.
  apply (rem_2546 X1 X2);  tauto.
  apply (rem_2550 X1 X2);  tauto.
Qed.

Remark rem_2552 : forall X1 X2 X3 X4:term, auto___def_17 X1 -> auto___type_2 (key pub (session_current X3 X4)) -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto_knows_current (passwd_current X3 X4) -> auto___def_103 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_17 X1 -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto___def_103 X1 X2). tauto.
  exact (rem_2551 X1 X2).
Qed.

Remark rem_2553 : forall X1 X2:term, auto___def_36 X1 -> auto___def_61 sym -> auto___def_62 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_1987 X1)). tauto.
Qed.

Remark rem_2554 : forall X1 X2:term, auto___def_61 sym -> auto___def_62 X1 -> auto___def_36 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_36 X1 -> auto___def_61 sym -> auto___def_62 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2). tauto. exact (rem_2553 X1 X2).
Qed.

Remark rem_2555 : forall X1 X2:term, auto___def_36 X1 -> auto___def_51 sym -> auto_agent X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2001 X1)). tauto.
Qed.

Remark rem_2556 : forall X1 X2:term, auto___def_51 sym -> auto_agent X1 -> auto___def_36 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_36 X1 -> auto___def_51 sym -> auto_agent X1 -> auto_knows_current X2 -> auto___def_103 X1 X2). tauto. exact (rem_2555 X1 X2).
Qed.

Remark rem_2557 : (forall X:term, auto___def_13 X -> auto___def_36 X -> False)
    -> forall X1 X2:term, auto___def_36 (session_old X1 X2) -> auto_agent X1 -> auto_agent X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_13_m__def_36. intros X1 X2. intro H. intros.
  elim (rem_2314 X1 X2 H);  intros.
Defined.

Remark rem_2558 : (forall X:term, auto___def_13 X -> auto___def_36 X -> False)
    -> forall X1 X2:term, auto___def_13 (session_old X1 X2) -> auto___def_36 (session_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_13_m__def_36. intros X1 X2. intro H. intros.
  elim (rem_1761 X1 X2 H);  intros.
  apply (rem_2557 epsilon_m__def_13_m__def_36 X1 X2);  tauto.
Defined.

Remark rem_2559 : forall X1:term, auto___def_13 X1 -> auto___def_36 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_13_m__def_36 1.
  intro X. case X.
   intro H. elim (rem_1773  H).
   intro H. elim (rem_1765  H).
  intros X1 X2. intro H. elim (rem_1778 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1763 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1776 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1777 X1 X2 H).
   intro H. elim (rem_1782  H).
  intros X1 X2. intro H. elim (rem_1786 X1 X2 H).
   intro H. elim (rem_1783  H).
  intros X1 X2. intro H. elim (rem_1785 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1766 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1764 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1775 X1 X2 H).
  intros X1. intro H. elim (rem_1769 X1 H).
  intros X1 X2. intro H. elim (rem_1772 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1771 X1 X2 H).
   intro H. elim (rem_1774  H).
   intro H. elim (rem_1770  H).
  intros X1 X2. intro H. elim (rem_1768 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1767 X1 X2 H).
  intros X1. intro H. elim (rem_1779 X1 H).
   intro H. elim (rem_1784  H).
  intros X1 X2. intro H. elim (rem_1781 X1 X2 H).
  intros X1 X2;  exact (rem_2558 epsilon_m__def_13_m__def_36 X1 X2).
   intro H. elim (rem_1780  H).
Qed.

Remark rem_2560 : forall X1 X2:term, auto___def_12 sym -> auto___def_13 X1 -> auto___def_36 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2559 X1)). tauto.
Qed.

Remark rem_2561 : forall X1 X2:term, auto___def_36 X1 -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1 H2. intro H. intros.
  elim (rem_1066 sym X1 H);  intros.
  apply (rem_2554 X1 X2);  tauto.
  apply (rem_2556 X1 X2);  tauto.
  apply (rem_2560 X1 X2);  tauto.
Qed.

Remark rem_2562 : forall X1 X2 X3 X4:term, auto___def_36 X1 -> auto___def_37 (key pub (session_current X3 X4)) -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto_knows_current (passwd_current X3 X4) -> auto___def_103 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_36 X1 -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto___def_103 X1 X2). tauto.
  exact (rem_2561 X1 X2).
Qed.

Remark rem_2563 : forall X1 X2:term, auto___def_21 X1 -> auto___def_61 sym -> auto___def_62 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_1963 X1)). tauto.
Qed.

Remark rem_2564 : forall X1 X2:term, auto___def_61 sym -> auto___def_62 X1 -> auto___def_21 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_21 X1 -> auto___def_61 sym -> auto___def_62 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2). tauto. exact (rem_2563 X1 X2).
Qed.

Remark rem_2565 : forall X1 X2:term, auto___def_21 X1 -> auto___def_51 sym -> auto_agent X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_1977 X1)). tauto.
Qed.

Remark rem_2566 : forall X1 X2:term, auto___def_51 sym -> auto_agent X1 -> auto___def_21 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_21 X1 -> auto___def_51 sym -> auto_agent X1 -> auto_knows_current X2 -> auto___def_103 X1 X2). tauto. exact (rem_2565 X1 X2).
Qed.

Remark rem_2567 : forall X1 X2:term, auto___def_21 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2568 : (forall X:term, auto___def_13 X -> auto___def_21 X -> False)
    -> forall X1 X2:term, auto___def_21 (session_old X1 X2) -> auto_agent X1 -> auto_agent X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_13_m__def_21. intros X1 X2. intro H. intros.
  elim (rem_2567 X1 X2 H);  intros.
Defined.

Remark rem_2569 : (forall X:term, auto___def_13 X -> auto___def_21 X -> False)
    -> forall X1 X2:term, auto___def_13 (session_old X1 X2) -> auto___def_21 (session_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_13_m__def_21. intros X1 X2. intro H. intros.
  elim (rem_1761 X1 X2 H);  intros.
  apply (rem_2568 epsilon_m__def_13_m__def_21 X1 X2);  tauto.
Defined.

Remark rem_2570 : forall X1:term, auto___def_13 X1 -> auto___def_21 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_13_m__def_21 1.
  intro X. case X.
   intro H. elim (rem_1773  H).
   intro H. elim (rem_1765  H).
  intros X1 X2. intro H. elim (rem_1778 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1763 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1776 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1777 X1 X2 H).
   intro H. elim (rem_1782  H).
  intros X1 X2. intro H. elim (rem_1786 X1 X2 H).
   intro H. elim (rem_1783  H).
  intros X1 X2. intro H. elim (rem_1785 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1766 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1764 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1775 X1 X2 H).
  intros X1. intro H. elim (rem_1769 X1 H).
  intros X1 X2. intro H. elim (rem_1772 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1771 X1 X2 H).
   intro H. elim (rem_1774  H).
   intro H. elim (rem_1770  H).
  intros X1 X2. intro H. elim (rem_1768 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1767 X1 X2 H).
  intros X1. intro H. elim (rem_1779 X1 H).
   intro H. elim (rem_1784  H).
  intros X1 X2. intro H. elim (rem_1781 X1 X2 H).
  intros X1 X2;  exact (rem_2569 epsilon_m__def_13_m__def_21 X1 X2).
   intro H. elim (rem_1780  H).
Qed.

Remark rem_2571 : forall X1 X2:term, auto___def_12 sym -> auto___def_13 X1 -> auto___def_21 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2570 X1)). tauto.
Qed.

Remark rem_2572 : forall X1 X2:term, auto___def_21 X1 -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1 H2. intro H. intros.
  elim (rem_1066 sym X1 H);  intros.
  apply (rem_2564 X1 X2);  tauto.
  apply (rem_2566 X1 X2);  tauto.
  apply (rem_2571 X1 X2);  tauto.
Qed.

Remark rem_2573 : forall X1 X2 X3 X4:term, auto___def_21 X1 -> auto___def_22 (key pub (session_current X3 X4)) -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto_knows_current (passwd_current X3 X4) -> auto___def_103 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_21 X1 -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto___def_103 X1 X2). tauto.
  exact (rem_2572 X1 X2).
Qed.

Remark rem_2574 : forall X1 X2:term, auto___def_61 sym -> auto___def_62 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_103 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_61 sym -> False). tauto.
  exact (rem_1310).
Qed.

Remark rem_2575 : forall X1 X2:term, auto___def_51 sym -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_103 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_51 sym -> False). tauto.
  exact (rem_1313).
Qed.

Remark rem_2576 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (crypt X1 X2) -> auto___def_17 X1 -> auto___type_2 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1763 X1 X2 H);  intros.
Defined.

Remark rem_2577 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (crypt X1 X2) -> auto___def_36 X1 -> auto___def_37 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1763 X1 X2 H);  intros.
Defined.

Remark rem_2578 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (crypt X1 X2) -> auto___def_21 X1 -> auto___def_22 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1763 X1 X2 H);  intros.
Defined.

Remark rem_2579 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (crypt X1 X2) -> auto_knows_current X1 -> auto_knows_current X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1763 X1 X2 H);  intros.
Defined.

Remark rem_2580 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (crypt X1 X2) -> auto___type_22 X1 -> auto___def_104 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1763 X1 X2 H);  intros.
Defined.

Remark rem_2581 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (crypt X1 X2) -> auto___def_88 X1 -> auto___def_89 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1763 X1 X2 H);  intros.
Defined.

Remark rem_2582 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (crypt X1 X2) -> auto___def_24 X1 -> auto___def_25 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1763 X1 X2 H);  intros.
Defined.

Remark rem_2583 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (crypt X1 X2) -> auto___type_7 X1 -> auto___def_44 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1763 X1 X2 H);  intros.
Defined.

Remark rem_2584 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (crypt X1 X2) -> auto___def_84 X1 -> auto___def_85 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1763 X1 X2 H);  intros.
Defined.

Remark rem_2585 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto_knows_current (crypt X1 X2) -> auto___def_13 (crypt X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_987 X1 X2 H);  intros.
  apply (rem_2576 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
  apply (rem_2577 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
  apply (rem_2578 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
  apply (rem_2579 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
  apply (rem_2580 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
  apply (rem_2581 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
  apply (rem_2582 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
  apply (rem_2583 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
  apply (rem_2584 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_2586 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> auto___def_13 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intro H. intros.
  elim (rem_1765 H);  intros.
Defined.

Remark rem_2587 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> auto_knows_current bob -> auto___def_13 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intro H. intros.
  elim (rem_991 H);  intros.
  apply (rem_2586 epsilon_mknows_current_m__def_13);  tauto.
Defined.

Remark rem_2588 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (noncea_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1766 X1 X2 H);  intros.
Defined.

Remark rem_2589 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto_knows_current (noncea_old X1 X2) -> auto___def_13 (noncea_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_994 X1 X2 H);  intros.
  apply (rem_2588 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_2590 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1:term, auto___def_13 (p X1) -> auto_knows_current X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1. intro H. intros.
  elim (rem_1769 X1 H);  intros.
Defined.

Remark rem_2591 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1:term, auto_knows_current (p X1) -> auto___def_13 (p X1) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1. intro H. intros.
  elim (rem_998 X1 H);  intros.
  apply (rem_2590 epsilon_mknows_current_m__def_13 X1);  tauto.
Defined.

Remark rem_2592 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (passwd_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1771 X1 X2 H);  intros.
Defined.

Remark rem_2593 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto_knows_current (passwd_old X1 X2) -> auto___def_13 (passwd_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1001 X1 X2 H);  intros.
  apply (rem_2592 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_2594 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> auto___def_13 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intro H. intros.
  elim (rem_1773 H);  intros.
Defined.

Remark rem_2595 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> auto_knows_current alice -> auto___def_13 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intro H. intros.
  elim (rem_1004 H);  intros.
  apply (rem_2594 epsilon_mknows_current_m__def_13);  tauto.
Defined.

Remark rem_2596 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (nonceb_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1775 X1 X2 H);  intros.
Defined.

Remark rem_2597 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto_knows_current (nonceb_old X1 X2) -> auto___def_13 (nonceb_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1007 X1 X2 H);  intros.
  apply (rem_2596 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_2598 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (dec X1 X2) -> auto_knows_current X1 -> auto_knows_current X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1776 X1 X2 H);  intros.
Defined.

Remark rem_2599 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto_knows_current (dec X1 X2) -> auto___def_13 (dec X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1010 X1 X2 H);  intros.
  apply (rem_2598 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_2600 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (enc X1 X2) -> auto___def_71 X1 -> auto___def_72 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1777 X1 X2 H);  intros.
Defined.

Remark rem_2601 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (enc X1 X2) -> auto_knows_current X1 -> auto_knows_current X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1777 X1 X2 H);  intros.
Defined.

Remark rem_2602 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (enc X1 X2) -> auto___def_79 X1 -> auto___def_80 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1777 X1 X2 H);  intros.
Defined.

Remark rem_2603 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (enc X1 X2) -> auto___def_75 X1 -> auto___def_76 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1777 X1 X2 H);  intros.
Defined.

Remark rem_2604 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto_knows_current (enc X1 X2) -> auto___def_13 (enc X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1031 X1 X2 H);  intros.
  apply (rem_2600 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
  apply (rem_2601 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
  apply (rem_2602 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
  apply (rem_2603 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_2605 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (cons X1 X2) -> auto_knows_current X1 -> auto_knows_current X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1778 X1 X2 H);  intros.
Defined.

Remark rem_2606 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto_knows_current (cons X1 X2) -> auto___def_13 (cons X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1034 X1 X2 H);  intros.
  apply (rem_2605 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_2607 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1:term, auto___def_13 (s X1) -> auto_knows_current X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1. intro H. intros.
  elim (rem_1779 X1 H);  intros.
Defined.

Remark rem_2608 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1:term, auto_knows_current (s X1) -> auto___def_13 (s X1) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1. intro H. intros.
  elim (rem_1037 X1 H);  intros.
  apply (rem_2607 epsilon_mknows_current_m__def_13 X1);  tauto.
Defined.

Remark rem_2609 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> auto___def_13 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intro H. intros.
  elim (rem_1782 H);  intros.
Defined.

Remark rem_2610 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> auto_knows_current i -> auto___def_13 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intro H. intros.
  elim (rem_1040 H);  intros.
  apply (rem_2609 epsilon_mknows_current_m__def_13);  tauto.
Defined.

Remark rem_2611 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> auto___def_13 nil -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intro H. intros.
  elim (rem_1783 H);  intros.
Defined.

Remark rem_2612 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> auto_knows_current nil -> auto___def_13 nil -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intro H. intros.
  elim (rem_1043 H);  intros.
  apply (rem_2611 epsilon_mknows_current_m__def_13);  tauto.
Defined.

Remark rem_2613 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> auto___def_13 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intro H. intros.
  elim (rem_1784 H);  intros.
Defined.

Remark rem_2614 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> auto_knows_current server -> auto___def_13 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intro H. intros.
  elim (rem_1046 H);  intros.
  apply (rem_2613 epsilon_mknows_current_m__def_13);  tauto.
Defined.

Remark rem_2615 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (key X1 X2) -> auto___def_61 X1 -> auto___def_62 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1786 X1 X2 H);  intros.
Defined.

Remark rem_2616 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (key X1 X2) -> auto___def_51 X1 -> auto_agent X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1786 X1 X2 H);  intros.
Defined.

Remark rem_2617 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (key X1 X2) -> auto___def_12 X1 -> auto___def_13 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1786 X1 X2 H);  intros.
Defined.

Remark rem_2618 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto_knows_current (key X1 X2) -> auto___def_13 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1066 X1 X2 H);  intros.
  apply (rem_2615 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
  apply (rem_2616 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
  apply (rem_2617 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_2619 : forall X1:term, auto_knows_current X1 -> auto___def_13 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_mknows_current_m__def_13 1.
  intro X. case X.
  exact (rem_2595 epsilon_mknows_current_m__def_13 ).
  exact (rem_2587 epsilon_mknows_current_m__def_13 ).
  intros X1 X2;  exact (rem_2606 epsilon_mknows_current_m__def_13 X1 X2).
  intros X1 X2;  exact (rem_2585 epsilon_mknows_current_m__def_13 X1 X2).
  intros X1 X2;  exact (rem_2599 epsilon_mknows_current_m__def_13 X1 X2).
  intros X1 X2;  exact (rem_2604 epsilon_mknows_current_m__def_13 X1 X2).
  exact (rem_2610 epsilon_mknows_current_m__def_13 ).
  intros X1 X2;  exact (rem_2618 epsilon_mknows_current_m__def_13 X1 X2).
  exact (rem_2612 epsilon_mknows_current_m__def_13 ).
  intros X1 X2. intro H. elim (rem_1077 X1 X2 H).
  intros X1 X2;  exact (rem_2589 epsilon_mknows_current_m__def_13 X1 X2).
  intros X1 X2. intro H. elim (rem_1068 X1 X2 H).
  intros X1 X2;  exact (rem_2597 epsilon_mknows_current_m__def_13 X1 X2).
  intros X1;  exact (rem_2591 epsilon_mknows_current_m__def_13 X1).
  intros X1 X2. intro H. elim (rem_1073 X1 X2 H).
  intros X1 X2;  exact (rem_2593 epsilon_mknows_current_m__def_13 X1 X2).
   intro H. elim (rem_1074  H).
   intro H. elim (rem_1072  H).
  intros X1 X2. intro H. elim (rem_1071 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1070 X1 X2 H).
  intros X1;  exact (rem_2608 epsilon_mknows_current_m__def_13 X1).
  exact (rem_2614 epsilon_mknows_current_m__def_13 ).
  intros X1 X2. intro H. elim (rem_1076 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1069 X1 X2 H).
   intro H. elim (rem_1075  H).
Qed.

Remark rem_2620 : forall X1 X2:term, auto___def_12 sym -> auto___def_13 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2619 X1)). tauto.
Qed.

Remark rem_2621 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key sym X1) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1 H2. intro H. intros.
  elim (rem_1066 sym X1 H);  intros.
  apply (rem_2574 X1 X2);  tauto.
  apply (rem_2575 X1 X2);  tauto.
  apply (rem_2620 X1 X2);  tauto.
Qed.

Remark rem_2622 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key pub (session_current X3 X4)) -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto_knows_current (passwd_current X3 X4) -> auto___def_103 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key sym X1) -> auto___def_103 X1 X2). tauto.
  exact (rem_2621 X1 X2).
Qed.

Remark rem_2623 : forall X1 X2 X3 X4:term, auto_knows_current X1 -> auto_knows_current (key pub (session_current X3 X4)) -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto_knows_current (passwd_current X3 X4) -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key pub (session_current X3 X4)) -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto_knows_current (passwd_current X3 X4) -> auto___def_103 X1 X2). tauto. exact (rem_2622 X1 X2 X3 X4).
Qed.

Remark rem_2624 : (forall X:term, auto___type_22 X -> auto___def_62 X -> False)
    -> forall X1 X2:term, auto___def_62 (nonceb_current X1 X2) -> auto_knows_current X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_22_m__def_62. intros X1 X2. intro H. intros.
  elim (rem_315 X1 X2 H);  intros.
Defined.

Remark rem_2625 : (forall X:term, auto___type_22 X -> auto___def_62 X -> False)
    -> forall X1 X2:term, auto___type_22 (nonceb_current X1 X2) -> auto___def_62 (nonceb_current X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_22_m__def_62. intros X1 X2. intro H. intros.
  elim (rem_1610 X1 X2 H);  intros.
  apply (rem_2624 epsilon_m__type_22_m__def_62 X1 X2);  tauto.
Defined.

Remark rem_2626 : forall X1:term, auto___type_22 X1 -> auto___def_62 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__type_22_m__def_62 1.
  intro X. case X.
   intro H. elim (rem_1622  H).
   intro H. elim (rem_1614  H).
  intros X1 X2. intro H. elim (rem_1627 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1612 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1625 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1626 X1 X2 H).
   intro H. elim (rem_1631  H).
  intros X1 X2. intro H. elim (rem_1635 X1 X2 H).
   intro H. elim (rem_1632  H).
  intros X1 X2. intro H. elim (rem_1634 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1615 X1 X2 H).
  intros X1 X2;  exact (rem_2625 epsilon_m__type_22_m__def_62 X1 X2).
  intros X1 X2. intro H. elim (rem_1624 X1 X2 H).
  intros X1. intro H. elim (rem_1618 X1 H).
  intros X1 X2. intro H. elim (rem_1621 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1620 X1 X2 H).
   intro H. elim (rem_1623  H).
   intro H. elim (rem_1619  H).
  intros X1 X2. intro H. elim (rem_1617 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1616 X1 X2 H).
  intros X1. intro H. elim (rem_1628 X1 H).
   intro H. elim (rem_1633  H).
  intros X1 X2. intro H. elim (rem_1630 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1613 X1 X2 H).
   intro H. elim (rem_1629  H).
Qed.

Remark rem_2627 : forall X1 X2:term, auto___def_61 sym -> auto___def_62 X1 -> auto___type_22 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2626 X1)). tauto.
Qed.

Remark rem_2628 : (forall X:term, auto___type_22 X -> auto_agent X -> False)
    -> forall X1 X2:term, auto_agent (nonceb_current X1 X2) -> auto_knows_current X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_22_magent. intros X1 X2. intro H. intros.
  elim (rem_1095 X1 X2 H);  intros.
Defined.

Remark rem_2629 : (forall X:term, auto___type_22 X -> auto_agent X -> False)
    -> forall X1 X2:term, auto___type_22 (nonceb_current X1 X2) -> auto_agent (nonceb_current X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_22_magent. intros X1 X2. intro H. intros.
  elim (rem_1610 X1 X2 H);  intros.
  apply (rem_2628 epsilon_m__type_22_magent X1 X2);  tauto.
Defined.

Remark rem_2630 : forall X1:term, auto___type_22 X1 -> auto_agent X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__type_22_magent 1.
  intro X. case X.
   intro H. elim (rem_1622  H).
   intro H. elim (rem_1614  H).
  intros X1 X2. intro H. elim (rem_1627 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1612 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1625 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1626 X1 X2 H).
   intro H. elim (rem_1631  H).
  intros X1 X2. intro H. elim (rem_1635 X1 X2 H).
   intro H. elim (rem_1632  H).
  intros X1 X2. intro H. elim (rem_1634 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1615 X1 X2 H).
  intros X1 X2;  exact (rem_2629 epsilon_m__type_22_magent X1 X2).
  intros X1 X2. intro H. elim (rem_1624 X1 X2 H).
  intros X1. intro H. elim (rem_1618 X1 H).
  intros X1 X2. intro H. elim (rem_1621 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1620 X1 X2 H).
   intro H. elim (rem_1623  H).
   intro H. elim (rem_1619  H).
  intros X1 X2. intro H. elim (rem_1617 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1616 X1 X2 H).
  intros X1. intro H. elim (rem_1628 X1 H).
   intro H. elim (rem_1633  H).
  intros X1 X2. intro H. elim (rem_1630 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1613 X1 X2 H).
   intro H. elim (rem_1629  H).
Qed.

Remark rem_2631 : forall X1 X2:term, auto___def_51 sym -> auto___type_22 X1 -> auto_agent X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2630 X1)). tauto.
Qed.

Remark rem_2632 : forall X1 X2:term, auto___def_51 sym -> auto_agent X1 -> auto___type_22 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_51 sym -> auto___type_22 X1 -> auto_agent X1 -> auto_knows_current X2 -> auto___def_103 X1 X2). tauto. exact (rem_2631 X1 X2).
Qed.

Remark rem_2633 : (forall X:term, auto___type_22 X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (nonceb_current X1 X2) -> auto_knows_current X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_22_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1764 X1 X2 H);  intros.
Defined.

Remark rem_2634 : (forall X:term, auto___type_22 X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___type_22 (nonceb_current X1 X2) -> auto___def_13 (nonceb_current X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_22_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1610 X1 X2 H);  intros.
  apply (rem_2633 epsilon_m__type_22_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_2635 : forall X1:term, auto___type_22 X1 -> auto___def_13 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__type_22_m__def_13 1.
  intro X. case X.
   intro H. elim (rem_1622  H).
   intro H. elim (rem_1614  H).
  intros X1 X2. intro H. elim (rem_1627 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1612 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1625 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1626 X1 X2 H).
   intro H. elim (rem_1631  H).
  intros X1 X2. intro H. elim (rem_1635 X1 X2 H).
   intro H. elim (rem_1632  H).
  intros X1 X2. intro H. elim (rem_1634 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1615 X1 X2 H).
  intros X1 X2;  exact (rem_2634 epsilon_m__type_22_m__def_13 X1 X2).
  intros X1 X2. intro H. elim (rem_1624 X1 X2 H).
  intros X1. intro H. elim (rem_1618 X1 H).
  intros X1 X2. intro H. elim (rem_1621 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1620 X1 X2 H).
   intro H. elim (rem_1623  H).
   intro H. elim (rem_1619  H).
  intros X1 X2. intro H. elim (rem_1617 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1616 X1 X2 H).
  intros X1. intro H. elim (rem_1628 X1 H).
   intro H. elim (rem_1633  H).
  intros X1 X2. intro H. elim (rem_1630 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1613 X1 X2 H).
   intro H. elim (rem_1629  H).
Qed.

Remark rem_2636 : forall X1 X2:term, auto___def_12 sym -> auto___def_13 X1 -> auto___type_22 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2635 X1)). tauto.
Qed.

Remark rem_2637 : forall X1 X2:term, auto___type_22 X1 -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1 H2. intro H. intros.
  elim (rem_1066 sym X1 H);  intros.
  apply (rem_2627 X1 X2);  tauto.
  apply (rem_2632 X1 X2);  tauto.
  apply (rem_2636 X1 X2);  tauto.
Qed.

Remark rem_2638 : forall X1 X2 X3 X4:term, auto___def_104 (key pub (session_current X3 X4)) -> auto___type_22 X1 -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto_knows_current (passwd_current X3 X4) -> auto___def_103 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_22 X1 -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto___def_103 X1 X2). tauto.
  exact (rem_2637 X1 X2).
Qed.

Remark rem_2639 : forall X1 X2 X3 X4:term, auto___type_22 X1 -> auto___def_104 (key pub (session_current X3 X4)) -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto_knows_current (passwd_current X3 X4) -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_104 (key pub (session_current X3 X4)) -> auto___type_22 X1 -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto_knows_current (passwd_current X3 X4) -> auto___def_103 X1 X2). tauto. exact (rem_2638 X1 X2 X3 X4).
Qed.

Remark rem_2640 : (forall X:term, auto___def_88 X -> auto___def_62 X -> False)
    -> forall X1 X2:term, auto___def_62 (cons X1 X2) -> auto___type_20 X1 -> auto___def_90 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_88_m__def_62. intros X1 X2. intro H. intros.
  elim (rem_330 X1 X2 H);  intros.
Defined.

Remark rem_2641 : forall X1 X2:term, auto___def_88 (cons X1 X2) -> or_1
    (auto___type_20 X1 /\ auto___def_90 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2642 : (forall X:term, auto___def_88 X -> auto___def_62 X -> False)
    -> forall X1 X2:term, auto___def_88 (cons X1 X2) -> auto___def_62 (cons X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_88_m__def_62. intros X1 X2. intro H. intros.
  elim (rem_2641 X1 X2 H);  intros.
  apply (rem_2640 epsilon_m__def_88_m__def_62 X1 X2);  tauto.
Defined.

Remark rem_2643 : forall X1 X2:term, auto___def_88 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2644 : forall X1 X2:term, auto___def_88 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2645 : forall X1 X2:term, auto___def_88 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2646 : auto___def_88 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2647 : forall X1 X2:term, auto___def_88 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2648 : forall X1 X2:term, auto___def_88 (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2649 : forall X1 X2:term, auto___def_88 (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2650 : forall X1:term, auto___def_88 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2651 : auto___def_88 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2652 : forall X1 X2:term, auto___def_88 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2653 : forall X1 X2:term, auto___def_88 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2654 : auto___def_88 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2655 : auto___def_88 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2656 : forall X1 X2:term, auto___def_88 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2657 : forall X1 X2:term, auto___def_88 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2658 : forall X1 X2:term, auto___def_88 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2659 : forall X1:term, auto___def_88 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2660 : auto___def_88 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2661 : forall X1 X2:term, auto___def_88 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2662 : auto___def_88 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2663 : auto___def_88 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2664 : auto___def_88 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2665 : forall X1 X2:term, auto___def_88 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2666 : forall X1 X2:term, auto___def_88 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2667 : forall X1:term, auto___def_88 X1 -> auto___def_62 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_88_m__def_62 1.
  intro X. case X.
   intro H. elim (rem_2654  H).
   intro H. elim (rem_2646  H).
  intros X1 X2;  exact (rem_2642 epsilon_m__def_88_m__def_62 X1 X2).
  intros X1 X2. intro H. elim (rem_2643 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2657 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2658 X1 X2 H).
   intro H. elim (rem_2662  H).
  intros X1 X2. intro H. elim (rem_2666 X1 X2 H).
   intro H. elim (rem_2663  H).
  intros X1 X2. intro H. elim (rem_2665 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2647 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2644 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2656 X1 X2 H).
  intros X1. intro H. elim (rem_2650 X1 H).
  intros X1 X2. intro H. elim (rem_2653 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2652 X1 X2 H).
   intro H. elim (rem_2655  H).
   intro H. elim (rem_2651  H).
  intros X1 X2. intro H. elim (rem_2649 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2648 X1 X2 H).
  intros X1. intro H. elim (rem_2659 X1 H).
   intro H. elim (rem_2664  H).
  intros X1 X2. intro H. elim (rem_2661 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2645 X1 X2 H).
   intro H. elim (rem_2660  H).
Qed.

Remark rem_2668 : forall X1 X2:term, auto___def_61 sym -> auto___def_62 X1 -> auto___def_88 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2667 X1)). tauto.
Qed.

Remark rem_2669 : (forall X:term, auto___def_88 X -> auto_agent X -> False)
    -> forall X1 X2:term, auto_agent (cons X1 X2) -> auto___type_20 X1 -> auto___def_90 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_88_magent. intros X1 X2. intro H. intros.
  elim (rem_1108 X1 X2 H);  intros.
Defined.

Remark rem_2670 : (forall X:term, auto___def_88 X -> auto_agent X -> False)
    -> forall X1 X2:term, auto___def_88 (cons X1 X2) -> auto_agent (cons X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_88_magent. intros X1 X2. intro H. intros.
  elim (rem_2641 X1 X2 H);  intros.
  apply (rem_2669 epsilon_m__def_88_magent X1 X2);  tauto.
Defined.

Remark rem_2671 : forall X1:term, auto___def_88 X1 -> auto_agent X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_88_magent 1.
  intro X. case X.
   intro H. elim (rem_2654  H).
   intro H. elim (rem_2646  H).
  intros X1 X2;  exact (rem_2670 epsilon_m__def_88_magent X1 X2).
  intros X1 X2. intro H. elim (rem_2643 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2657 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2658 X1 X2 H).
   intro H. elim (rem_2662  H).
  intros X1 X2. intro H. elim (rem_2666 X1 X2 H).
   intro H. elim (rem_2663  H).
  intros X1 X2. intro H. elim (rem_2665 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2647 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2644 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2656 X1 X2 H).
  intros X1. intro H. elim (rem_2650 X1 H).
  intros X1 X2. intro H. elim (rem_2653 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2652 X1 X2 H).
   intro H. elim (rem_2655  H).
   intro H. elim (rem_2651  H).
  intros X1 X2. intro H. elim (rem_2649 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2648 X1 X2 H).
  intros X1. intro H. elim (rem_2659 X1 H).
   intro H. elim (rem_2664  H).
  intros X1 X2. intro H. elim (rem_2661 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2645 X1 X2 H).
   intro H. elim (rem_2660  H).
Qed.

Remark rem_2672 : forall X1 X2:term, auto___def_51 sym -> auto___def_88 X1 -> auto_agent X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2671 X1)). tauto.
Qed.

Remark rem_2673 : forall X1 X2:term, auto___def_51 sym -> auto_agent X1 -> auto___def_88 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_51 sym -> auto___def_88 X1 -> auto_agent X1 -> auto_knows_current X2 -> auto___def_103 X1 X2). tauto. exact (rem_2672 X1 X2).
Qed.

Remark rem_2674 : (forall X:term, auto___def_88 X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (cons X1 X2) -> auto___type_20 X1 -> auto___def_90 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_88_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1778 X1 X2 H);  intros.
Defined.

Remark rem_2675 : (forall X:term, auto___def_88 X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_88 (cons X1 X2) -> auto___def_13 (cons X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_88_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_2641 X1 X2 H);  intros.
  apply (rem_2674 epsilon_m__def_88_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_2676 : forall X1:term, auto___def_88 X1 -> auto___def_13 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_88_m__def_13 1.
  intro X. case X.
   intro H. elim (rem_2654  H).
   intro H. elim (rem_2646  H).
  intros X1 X2;  exact (rem_2675 epsilon_m__def_88_m__def_13 X1 X2).
  intros X1 X2. intro H. elim (rem_2643 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2657 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2658 X1 X2 H).
   intro H. elim (rem_2662  H).
  intros X1 X2. intro H. elim (rem_2666 X1 X2 H).
   intro H. elim (rem_2663  H).
  intros X1 X2. intro H. elim (rem_2665 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2647 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2644 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2656 X1 X2 H).
  intros X1. intro H. elim (rem_2650 X1 H).
  intros X1 X2. intro H. elim (rem_2653 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2652 X1 X2 H).
   intro H. elim (rem_2655  H).
   intro H. elim (rem_2651  H).
  intros X1 X2. intro H. elim (rem_2649 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2648 X1 X2 H).
  intros X1. intro H. elim (rem_2659 X1 H).
   intro H. elim (rem_2664  H).
  intros X1 X2. intro H. elim (rem_2661 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2645 X1 X2 H).
   intro H. elim (rem_2660  H).
Qed.

Remark rem_2677 : forall X1 X2:term, auto___def_12 sym -> auto___def_13 X1 -> auto___def_88 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2676 X1)). tauto.
Qed.

Remark rem_2678 : forall X1 X2:term, auto___def_88 X1 -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1 H2. intro H. intros.
  elim (rem_1066 sym X1 H);  intros.
  apply (rem_2668 X1 X2);  tauto.
  apply (rem_2673 X1 X2);  tauto.
  apply (rem_2677 X1 X2);  tauto.
Qed.

Remark rem_2679 : forall X1 X2 X3 X4:term, auto___def_88 X1 -> auto___def_89 (key pub (session_current X3 X4)) -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto_knows_current (passwd_current X3 X4) -> auto___def_103 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_88 X1 -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto___def_103 X1 X2). tauto.
  exact (rem_2678 X1 X2).
Qed.

Remark rem_2680 : forall X1 X2:term, auto___def_24 X1 -> auto___def_61 sym -> auto___def_62 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2032 X1)). tauto.
Qed.

Remark rem_2681 : forall X1 X2:term, auto___def_61 sym -> auto___def_62 X1 -> auto___def_24 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_24 X1 -> auto___def_61 sym -> auto___def_62 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2). tauto. exact (rem_2680 X1 X2).
Qed.

Remark rem_2682 : forall X1 X2:term, auto___def_24 X1 -> auto___def_51 sym -> auto_agent X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2037 X1)). tauto.
Qed.

Remark rem_2683 : forall X1 X2:term, auto___def_51 sym -> auto_agent X1 -> auto___def_24 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_24 X1 -> auto___def_51 sym -> auto_agent X1 -> auto_knows_current X2 -> auto___def_103 X1 X2). tauto. exact (rem_2682 X1 X2).
Qed.

Remark rem_2684 : (forall X:term, auto___def_24 X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (noncea_old X1 X2) -> auto_agent X1 -> auto_agent X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_24_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1766 X1 X2 H);  intros.
Defined.

Remark rem_2685 : (forall X:term, auto___def_24 X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_24 (noncea_old X1 X2) -> auto___def_13 (noncea_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_24_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_2007 X1 X2 H);  intros.
  apply (rem_2684 epsilon_m__def_24_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_2686 : forall X1:term, auto___def_24 X1 -> auto___def_13 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_24_m__def_13 1.
  intro X. case X.
   intro H. elim (rem_2019  H).
   intro H. elim (rem_2012  H).
  intros X1 X2. intro H. elim (rem_1937 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2009 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2022 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2023 X1 X2 H).
   intro H. elim (rem_2027  H).
  intros X1 X2. intro H. elim (rem_2031 X1 X2 H).
   intro H. elim (rem_2028  H).
  intros X1 X2. intro H. elim (rem_2030 X1 X2 H).
  intros X1 X2;  exact (rem_2685 epsilon_m__def_24_m__def_13 X1 X2).
  intros X1 X2. intro H. elim (rem_2010 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2021 X1 X2 H).
  intros X1. intro H. elim (rem_2015 X1 H).
  intros X1 X2. intro H. elim (rem_2018 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2017 X1 X2 H).
   intro H. elim (rem_2020  H).
   intro H. elim (rem_2016  H).
  intros X1 X2. intro H. elim (rem_2014 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2013 X1 X2 H).
  intros X1. intro H. elim (rem_2024 X1 H).
   intro H. elim (rem_2029  H).
  intros X1 X2. intro H. elim (rem_2026 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2011 X1 X2 H).
   intro H. elim (rem_2025  H).
Qed.

Remark rem_2687 : forall X1 X2:term, auto___def_12 sym -> auto___def_13 X1 -> auto___def_24 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2686 X1)). tauto.
Qed.

Remark rem_2688 : forall X1 X2:term, auto___def_24 X1 -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1 H2. intro H. intros.
  elim (rem_1066 sym X1 H);  intros.
  apply (rem_2681 X1 X2);  tauto.
  apply (rem_2683 X1 X2);  tauto.
  apply (rem_2687 X1 X2);  tauto.
Qed.

Remark rem_2689 : forall X1 X2 X3 X4:term, auto___def_24 X1 -> auto___def_25 (key pub (session_current X3 X4)) -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto_knows_current (passwd_current X3 X4) -> auto___def_103 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_24 X1 -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto___def_103 X1 X2). tauto.
  exact (rem_2688 X1 X2).
Qed.

Remark rem_2690 : forall X1 X2:term, auto___def_61 sym -> auto___def_62 X1 -> auto___type_7 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2068 X1)). tauto.
Qed.

Remark rem_2691 : forall X1 X2:term, auto___def_51 sym -> auto___type_7 X1 -> auto_agent X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2072 X1)). tauto.
Qed.

Remark rem_2692 : forall X1 X2:term, auto___def_51 sym -> auto_agent X1 -> auto___type_7 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_51 sym -> auto___type_7 X1 -> auto_agent X1 -> auto_knows_current X2 -> auto___def_103 X1 X2). tauto. exact (rem_2691 X1 X2).
Qed.

Remark rem_2693 : (forall X:term, auto___type_7 X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (nonceb_old X1 X2) -> auto_knows_old X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_7_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1775 X1 X2 H);  intros.
Defined.

Remark rem_2694 : (forall X:term, auto___type_7 X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___type_7 (nonceb_old X1 X2) -> auto___def_13 (nonceb_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_7_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_2043 X1 X2 H);  intros.
  apply (rem_2693 epsilon_m__type_7_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_2695 : forall X1:term, auto___type_7 X1 -> auto___def_13 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__type_7_m__def_13 1.
  intro X. case X.
   intro H. elim (rem_2056  H).
   intro H. elim (rem_2048  H).
  intros X1 X2. intro H. elim (rem_1939 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2045 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2058 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2059 X1 X2 H).
   intro H. elim (rem_2063  H).
  intros X1 X2. intro H. elim (rem_2067 X1 X2 H).
   intro H. elim (rem_2064  H).
  intros X1 X2. intro H. elim (rem_2066 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2049 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2046 X1 X2 H).
  intros X1 X2;  exact (rem_2694 epsilon_m__type_7_m__def_13 X1 X2).
  intros X1. intro H. elim (rem_2052 X1 H).
  intros X1 X2. intro H. elim (rem_2055 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2054 X1 X2 H).
   intro H. elim (rem_2057  H).
   intro H. elim (rem_2053  H).
  intros X1 X2. intro H. elim (rem_2051 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2050 X1 X2 H).
  intros X1. intro H. elim (rem_2060 X1 H).
   intro H. elim (rem_2065  H).
  intros X1 X2. intro H. elim (rem_2062 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2047 X1 X2 H).
   intro H. elim (rem_2061  H).
Qed.

Remark rem_2696 : forall X1 X2:term, auto___def_12 sym -> auto___def_13 X1 -> auto___type_7 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2695 X1)). tauto.
Qed.

Remark rem_2697 : forall X1 X2:term, auto___type_7 X1 -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1 H2. intro H. intros.
  elim (rem_1066 sym X1 H);  intros.
  apply (rem_2690 X1 X2);  tauto.
  apply (rem_2692 X1 X2);  tauto.
  apply (rem_2696 X1 X2);  tauto.
Qed.

Remark rem_2698 : forall X1 X2 X3 X4:term, auto___def_44 (key pub (session_current X3 X4)) -> auto___type_7 X1 -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto_knows_current (passwd_current X3 X4) -> auto___def_103 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_7 X1 -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto___def_103 X1 X2). tauto.
  exact (rem_2697 X1 X2).
Qed.

Remark rem_2699 : forall X1 X2 X3 X4:term, auto___type_7 X1 -> auto___def_44 (key pub (session_current X3 X4)) -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto_knows_current (passwd_current X3 X4) -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_44 (key pub (session_current X3 X4)) -> auto___type_7 X1 -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto_knows_current (passwd_current X3 X4) -> auto___def_103 X1 X2). tauto. exact (rem_2698 X1 X2 X3 X4).
Qed.

Remark rem_2700 : (forall X:term, auto___def_84 X -> auto___def_62 X -> False)
    -> forall X1 X2:term, auto___def_62 (noncea_current X1 X2) -> auto_agent X1 -> auto_agent X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_84_m__def_62. intros X1 X2. intro H. intros.
  elim (rem_336 X1 X2 H);  intros.
Defined.

Remark rem_2701 : (forall X:term, auto___def_84 X -> auto___def_62 X -> False)
    -> forall X1 X2:term, auto___def_84 (noncea_current X1 X2) -> auto___def_62 (noncea_current X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_84_m__def_62. intros X1 X2. intro H. intros.
  elim (rem_1680 X1 X2 H);  intros.
  apply (rem_2700 epsilon_m__def_84_m__def_62 X1 X2);  tauto.
Defined.

Remark rem_2702 : forall X1:term, auto___def_84 X1 -> auto___def_62 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_84_m__def_62 1.
  intro X. case X.
   intro H. elim (rem_1693  H).
   intro H. elim (rem_1685  H).
  intros X1 X2. intro H. elim (rem_1698 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1682 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1696 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1697 X1 X2 H).
   intro H. elim (rem_1702  H).
  intros X1 X2. intro H. elim (rem_1705 X1 X2 H).
   intro H. elim (rem_1703  H).
  intros X1 X2;  exact (rem_2701 epsilon_m__def_84_m__def_62 X1 X2).
  intros X1 X2. intro H. elim (rem_1686 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1683 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1695 X1 X2 H).
  intros X1. intro H. elim (rem_1689 X1 H).
  intros X1 X2. intro H. elim (rem_1692 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1691 X1 X2 H).
   intro H. elim (rem_1694  H).
   intro H. elim (rem_1690  H).
  intros X1 X2. intro H. elim (rem_1688 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1687 X1 X2 H).
  intros X1. intro H. elim (rem_1699 X1 H).
   intro H. elim (rem_1704  H).
  intros X1 X2. intro H. elim (rem_1701 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1684 X1 X2 H).
   intro H. elim (rem_1700  H).
Qed.

Remark rem_2703 : forall X1 X2:term, auto___def_61 sym -> auto___def_62 X1 -> auto___def_84 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2702 X1)). tauto.
Qed.

Remark rem_2704 : (forall X:term, auto___def_84 X -> auto_agent X -> False)
    -> forall X1 X2:term, auto_agent (noncea_current X1 X2) -> auto_agent X1 -> auto_agent X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_84_magent. intros X1 X2. intro H. intros.
  elim (rem_1113 X1 X2 H);  intros.
Defined.

Remark rem_2705 : (forall X:term, auto___def_84 X -> auto_agent X -> False)
    -> forall X1 X2:term, auto___def_84 (noncea_current X1 X2) -> auto_agent (noncea_current X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_84_magent. intros X1 X2. intro H. intros.
  elim (rem_1680 X1 X2 H);  intros.
  apply (rem_2704 epsilon_m__def_84_magent X1 X2);  tauto.
Defined.

Remark rem_2706 : forall X1:term, auto___def_84 X1 -> auto_agent X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_84_magent 1.
  intro X. case X.
   intro H. elim (rem_1693  H).
   intro H. elim (rem_1685  H).
  intros X1 X2. intro H. elim (rem_1698 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1682 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1696 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1697 X1 X2 H).
   intro H. elim (rem_1702  H).
  intros X1 X2. intro H. elim (rem_1705 X1 X2 H).
   intro H. elim (rem_1703  H).
  intros X1 X2;  exact (rem_2705 epsilon_m__def_84_magent X1 X2).
  intros X1 X2. intro H. elim (rem_1686 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1683 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1695 X1 X2 H).
  intros X1. intro H. elim (rem_1689 X1 H).
  intros X1 X2. intro H. elim (rem_1692 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1691 X1 X2 H).
   intro H. elim (rem_1694  H).
   intro H. elim (rem_1690  H).
  intros X1 X2. intro H. elim (rem_1688 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1687 X1 X2 H).
  intros X1. intro H. elim (rem_1699 X1 H).
   intro H. elim (rem_1704  H).
  intros X1 X2. intro H. elim (rem_1701 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1684 X1 X2 H).
   intro H. elim (rem_1700  H).
Qed.

Remark rem_2707 : forall X1 X2:term, auto___def_51 sym -> auto___def_84 X1 -> auto_agent X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2706 X1)). tauto.
Qed.

Remark rem_2708 : forall X1 X2:term, auto___def_51 sym -> auto_agent X1 -> auto___def_84 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_51 sym -> auto___def_84 X1 -> auto_agent X1 -> auto_knows_current X2 -> auto___def_103 X1 X2). tauto. exact (rem_2707 X1 X2).
Qed.

Remark rem_2709 : (forall X:term, auto___def_84 X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (noncea_current X1 X2) -> auto_agent X1 -> auto_agent X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_84_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1785 X1 X2 H);  intros.
Defined.

Remark rem_2710 : (forall X:term, auto___def_84 X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_84 (noncea_current X1 X2) -> auto___def_13 (noncea_current X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_84_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1680 X1 X2 H);  intros.
  apply (rem_2709 epsilon_m__def_84_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_2711 : forall X1:term, auto___def_84 X1 -> auto___def_13 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_84_m__def_13 1.
  intro X. case X.
   intro H. elim (rem_1693  H).
   intro H. elim (rem_1685  H).
  intros X1 X2. intro H. elim (rem_1698 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1682 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1696 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1697 X1 X2 H).
   intro H. elim (rem_1702  H).
  intros X1 X2. intro H. elim (rem_1705 X1 X2 H).
   intro H. elim (rem_1703  H).
  intros X1 X2;  exact (rem_2710 epsilon_m__def_84_m__def_13 X1 X2).
  intros X1 X2. intro H. elim (rem_1686 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1683 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1695 X1 X2 H).
  intros X1. intro H. elim (rem_1689 X1 H).
  intros X1 X2. intro H. elim (rem_1692 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1691 X1 X2 H).
   intro H. elim (rem_1694  H).
   intro H. elim (rem_1690  H).
  intros X1 X2. intro H. elim (rem_1688 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1687 X1 X2 H).
  intros X1. intro H. elim (rem_1699 X1 H).
   intro H. elim (rem_1704  H).
  intros X1 X2. intro H. elim (rem_1701 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1684 X1 X2 H).
   intro H. elim (rem_1700  H).
Qed.

Remark rem_2712 : forall X1 X2:term, auto___def_12 sym -> auto___def_13 X1 -> auto___def_84 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2711 X1)). tauto.
Qed.

Remark rem_2713 : forall X1 X2:term, auto___def_84 X1 -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1 H2. intro H. intros.
  elim (rem_1066 sym X1 H);  intros.
  apply (rem_2703 X1 X2);  tauto.
  apply (rem_2708 X1 X2);  tauto.
  apply (rem_2712 X1 X2);  tauto.
Qed.

Remark rem_2714 : forall X1 X2 X3 X4:term, auto___def_84 X1 -> auto___def_85 (key pub (session_current X3 X4)) -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto_knows_current (passwd_current X3 X4) -> auto___def_103 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_84 X1 -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto___def_103 X1 X2). tauto.
  exact (rem_2713 X1 X2).
Qed.

Remark rem_2715 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current (crypt X1 (key pub (session_current X3 X4))) -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto_knows_current (passwd_current X3 X4) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_987 X1 (key pub (session_current X3 X4)) H);  intros.
  apply (rem_2552 X1 X2 X3 X4);  tauto.
  apply (rem_2562 X1 X2 X3 X4);  tauto.
  apply (rem_2573 X1 X2 X3 X4);  tauto.
  apply (rem_2623 X1 X2 X3 X4);  tauto.
  apply (rem_2639 X1 X2 X3 X4);  tauto.
  apply (rem_2679 X1 X2 X3 X4);  tauto.
  apply (rem_2689 X1 X2 X3 X4);  tauto.
  apply (rem_2699 X1 X2 X3 X4);  tauto.
  apply (rem_2714 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2716 : forall X1 X2 X3 X4:term, auto_knows_current (crypt X1 (key pub (session_current X3 X4))) -> auto_knows_current (passwd_current X3 X4) -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current (crypt X1 (key pub (session_current X3 X4))) -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto_knows_current (passwd_current X3 X4) -> auto___def_103 X1 X2). tauto. exact (rem_2715 X1 X2 X3 X4).
Qed.

Remark rem_2717 : (forall X:term, auto___def_81 X -> auto___def_62 X -> False)
    -> forall X1 X2:term, auto___def_62 (r_current X1 X2) -> auto_knows_current X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_81_m__def_62. intros X1 X2. intro H. intros.
  elim (rem_320 X1 X2 H);  intros.
Defined.

Remark rem_2718 : forall X1 X2:term, auto___def_81 (r_current X1 X2) -> or_1
    (auto_knows_current X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2719 : (forall X:term, auto___def_81 X -> auto___def_62 X -> False)
    -> forall X1 X2:term, auto___def_81 (r_current X1 X2) -> auto___def_62 (r_current X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_81_m__def_62. intros X1 X2. intro H. intros.
  elim (rem_2718 X1 X2 H);  intros.
  apply (rem_2717 epsilon_m__def_81_m__def_62 X1 X2);  tauto.
Defined.

Remark rem_2720 : forall X1 X2:term, auto___def_81 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2721 : forall X1 X2:term, auto___def_81 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2722 : forall X1 X2:term, auto___def_81 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2723 : auto___def_81 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2724 : forall X1 X2:term, auto___def_81 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2725 : forall X1 X2:term, auto___def_81 (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2726 : forall X1:term, auto___def_81 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2727 : auto___def_81 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2728 : forall X1 X2:term, auto___def_81 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2729 : forall X1 X2:term, auto___def_81 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2730 : auto___def_81 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2731 : auto___def_81 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2732 : forall X1 X2:term, auto___def_81 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2733 : forall X1 X2:term, auto___def_81 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2734 : forall X1 X2:term, auto___def_81 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2735 : forall X1 X2:term, auto___def_81 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2736 : forall X1:term, auto___def_81 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2737 : auto___def_81 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2738 : forall X1 X2:term, auto___def_81 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2739 : auto___def_81 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2740 : auto___def_81 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2741 : auto___def_81 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2742 : forall X1 X2:term, auto___def_81 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2743 : forall X1 X2:term, auto___def_81 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2744 : forall X1:term, auto___def_81 X1 -> auto___def_62 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_81_m__def_62 1.
  intro X. case X.
   intro H. elim (rem_2730  H).
   intro H. elim (rem_2723  H).
  intros X1 X2. intro H. elim (rem_2735 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2720 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2733 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2734 X1 X2 H).
   intro H. elim (rem_2739  H).
  intros X1 X2. intro H. elim (rem_2743 X1 X2 H).
   intro H. elim (rem_2740  H).
  intros X1 X2. intro H. elim (rem_2742 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2724 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2721 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2732 X1 X2 H).
  intros X1. intro H. elim (rem_2726 X1 H).
  intros X1 X2. intro H. elim (rem_2729 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2728 X1 X2 H).
   intro H. elim (rem_2731  H).
   intro H. elim (rem_2727  H).
  intros X1 X2;  exact (rem_2719 epsilon_m__def_81_m__def_62 X1 X2).
  intros X1 X2. intro H. elim (rem_2725 X1 X2 H).
  intros X1. intro H. elim (rem_2736 X1 H).
   intro H. elim (rem_2741  H).
  intros X1 X2. intro H. elim (rem_2738 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2722 X1 X2 H).
   intro H. elim (rem_2737  H).
Qed.

Remark rem_2745 : forall X1 X2:term, auto___def_61 sym -> auto___def_62 X1 -> auto___def_81 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2744 X1)). tauto.
Qed.

Remark rem_2746 : (forall X:term, auto___def_81 X -> auto_agent X -> False)
    -> forall X1 X2:term, auto_agent (r_current X1 X2) -> auto_knows_current X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_81_magent. intros X1 X2. intro H. intros.
  elim (rem_1099 X1 X2 H);  intros.
Defined.

Remark rem_2747 : (forall X:term, auto___def_81 X -> auto_agent X -> False)
    -> forall X1 X2:term, auto___def_81 (r_current X1 X2) -> auto_agent (r_current X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_81_magent. intros X1 X2. intro H. intros.
  elim (rem_2718 X1 X2 H);  intros.
  apply (rem_2746 epsilon_m__def_81_magent X1 X2);  tauto.
Defined.

Remark rem_2748 : forall X1:term, auto___def_81 X1 -> auto_agent X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_81_magent 1.
  intro X. case X.
   intro H. elim (rem_2730  H).
   intro H. elim (rem_2723  H).
  intros X1 X2. intro H. elim (rem_2735 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2720 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2733 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2734 X1 X2 H).
   intro H. elim (rem_2739  H).
  intros X1 X2. intro H. elim (rem_2743 X1 X2 H).
   intro H. elim (rem_2740  H).
  intros X1 X2. intro H. elim (rem_2742 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2724 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2721 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2732 X1 X2 H).
  intros X1. intro H. elim (rem_2726 X1 H).
  intros X1 X2. intro H. elim (rem_2729 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2728 X1 X2 H).
   intro H. elim (rem_2731  H).
   intro H. elim (rem_2727  H).
  intros X1 X2;  exact (rem_2747 epsilon_m__def_81_magent X1 X2).
  intros X1 X2. intro H. elim (rem_2725 X1 X2 H).
  intros X1. intro H. elim (rem_2736 X1 H).
   intro H. elim (rem_2741  H).
  intros X1 X2. intro H. elim (rem_2738 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2722 X1 X2 H).
   intro H. elim (rem_2737  H).
Qed.

Remark rem_2749 : forall X1 X2:term, auto___def_51 sym -> auto___def_81 X1 -> auto_agent X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2748 X1)). tauto.
Qed.

Remark rem_2750 : forall X1 X2:term, auto___def_51 sym -> auto_agent X1 -> auto___def_81 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_51 sym -> auto___def_81 X1 -> auto_agent X1 -> auto_knows_current X2 -> auto___def_103 X1 X2). tauto. exact (rem_2749 X1 X2).
Qed.

Remark rem_2751 : (forall X:term, auto___def_81 X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (r_current X1 X2) -> auto_knows_current X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_81_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1768 X1 X2 H);  intros.
Defined.

Remark rem_2752 : (forall X:term, auto___def_81 X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_81 (r_current X1 X2) -> auto___def_13 (r_current X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_81_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_2718 X1 X2 H);  intros.
  apply (rem_2751 epsilon_m__def_81_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_2753 : forall X1:term, auto___def_81 X1 -> auto___def_13 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_81_m__def_13 1.
  intro X. case X.
   intro H. elim (rem_2730  H).
   intro H. elim (rem_2723  H).
  intros X1 X2. intro H. elim (rem_2735 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2720 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2733 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2734 X1 X2 H).
   intro H. elim (rem_2739  H).
  intros X1 X2. intro H. elim (rem_2743 X1 X2 H).
   intro H. elim (rem_2740  H).
  intros X1 X2. intro H. elim (rem_2742 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2724 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2721 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2732 X1 X2 H).
  intros X1. intro H. elim (rem_2726 X1 H).
  intros X1 X2. intro H. elim (rem_2729 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2728 X1 X2 H).
   intro H. elim (rem_2731  H).
   intro H. elim (rem_2727  H).
  intros X1 X2;  exact (rem_2752 epsilon_m__def_81_m__def_13 X1 X2).
  intros X1 X2. intro H. elim (rem_2725 X1 X2 H).
  intros X1. intro H. elim (rem_2736 X1 H).
   intro H. elim (rem_2741  H).
  intros X1 X2. intro H. elim (rem_2738 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2722 X1 X2 H).
   intro H. elim (rem_2737  H).
Qed.

Remark rem_2754 : forall X1 X2:term, auto___def_12 sym -> auto___def_13 X1 -> auto___def_81 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2753 X1)). tauto.
Qed.

Remark rem_2755 : forall X1 X2:term, auto___def_81 X1 -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1 H2. intro H. intros.
  elim (rem_1066 sym X1 H);  intros.
  apply (rem_2745 X1 X2);  tauto.
  apply (rem_2750 X1 X2);  tauto.
  apply (rem_2754 X1 X2);  tauto.
Qed.

Remark rem_2756 : forall X1 X2 X3 X4:term, auto___def_80 (passwd_current X3 X4) -> auto___def_81 X1 -> auto___def_82 (key pub (session_current X3 X4)) -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto___def_103 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_81 X1 -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto___def_103 X1 X2). tauto.
  exact (rem_2755 X1 X2).
Qed.

Remark rem_2757 : forall X1 X2 X3 X4:term, auto___def_81 X1 -> auto___def_82 (key pub (session_current X3 X4)) -> auto___def_80 (passwd_current X3 X4) -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_80 (passwd_current X3 X4) -> auto___def_81 X1 -> auto___def_82 (key pub (session_current X3 X4)) -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto___def_103 X1 X2). tauto. exact (rem_2756 X1 X2 X3 X4).
Qed.

Remark rem_2758 : forall X1 X2 X3 X4:term, auto___def_79 (crypt X1 (key pub (session_current X3 X4))) -> auto___def_80 (passwd_current X3 X4) -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_766 X1 (key pub (session_current X3 X4)) H);  intros.
  apply (rem_2757 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2759 : (forall X:term, auto___def_77 X -> auto___def_62 X -> False)
    -> forall X1 X2:term, auto___def_62 (r_current X1 X2) -> auto_knows_current X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_77_m__def_62. intros X1 X2. intro H. intros.
  elim (rem_320 X1 X2 H);  intros.
Defined.

Remark rem_2760 : (forall X:term, auto___def_77 X -> auto___def_62 X -> False)
    -> forall X1 X2:term, auto___def_77 (r_current X1 X2) -> auto___def_62 (r_current X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_77_m__def_62. intros X1 X2. intro H. intros.
  elim (rem_12 X1 X2 H);  intros.
  apply (rem_2759 epsilon_m__def_77_m__def_62 X1 X2);  tauto.
Defined.

Remark rem_2761 : forall X1:term, auto___def_77 X1 -> auto___def_62 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_77_m__def_62 1.
  intro X. case X.
   intro H. elim (rem_24  H).
   intro H. elim (rem_17  H).
  intros X1 X2. intro H. elim (rem_29 X1 X2 H).
  intros X1 X2. intro H. elim (rem_14 X1 X2 H).
  intros X1 X2. intro H. elim (rem_27 X1 X2 H).
  intros X1 X2. intro H. elim (rem_28 X1 X2 H).
   intro H. elim (rem_33  H).
  intros X1 X2. intro H. elim (rem_37 X1 X2 H).
   intro H. elim (rem_34  H).
  intros X1 X2. intro H. elim (rem_36 X1 X2 H).
  intros X1 X2. intro H. elim (rem_18 X1 X2 H).
  intros X1 X2. intro H. elim (rem_15 X1 X2 H).
  intros X1 X2. intro H. elim (rem_26 X1 X2 H).
  intros X1. intro H. elim (rem_20 X1 H).
  intros X1 X2. intro H. elim (rem_23 X1 X2 H).
  intros X1 X2. intro H. elim (rem_22 X1 X2 H).
   intro H. elim (rem_25  H).
   intro H. elim (rem_21  H).
  intros X1 X2;  exact (rem_2760 epsilon_m__def_77_m__def_62 X1 X2).
  intros X1 X2. intro H. elim (rem_19 X1 X2 H).
  intros X1. intro H. elim (rem_30 X1 H).
   intro H. elim (rem_35  H).
  intros X1 X2. intro H. elim (rem_32 X1 X2 H).
  intros X1 X2. intro H. elim (rem_16 X1 X2 H).
   intro H. elim (rem_31  H).
Qed.

Remark rem_2762 : forall X1 X2:term, auto___def_61 sym -> auto___def_62 X1 -> auto___def_77 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2761 X1)). tauto.
Qed.

Remark rem_2763 : (forall X:term, auto___def_77 X -> auto_agent X -> False)
    -> forall X1 X2:term, auto_agent (r_current X1 X2) -> auto_knows_current X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_77_magent. intros X1 X2. intro H. intros.
  elim (rem_1099 X1 X2 H);  intros.
Defined.

Remark rem_2764 : (forall X:term, auto___def_77 X -> auto_agent X -> False)
    -> forall X1 X2:term, auto___def_77 (r_current X1 X2) -> auto_agent (r_current X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_77_magent. intros X1 X2. intro H. intros.
  elim (rem_12 X1 X2 H);  intros.
  apply (rem_2763 epsilon_m__def_77_magent X1 X2);  tauto.
Defined.

Remark rem_2765 : forall X1:term, auto___def_77 X1 -> auto_agent X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_77_magent 1.
  intro X. case X.
   intro H. elim (rem_24  H).
   intro H. elim (rem_17  H).
  intros X1 X2. intro H. elim (rem_29 X1 X2 H).
  intros X1 X2. intro H. elim (rem_14 X1 X2 H).
  intros X1 X2. intro H. elim (rem_27 X1 X2 H).
  intros X1 X2. intro H. elim (rem_28 X1 X2 H).
   intro H. elim (rem_33  H).
  intros X1 X2. intro H. elim (rem_37 X1 X2 H).
   intro H. elim (rem_34  H).
  intros X1 X2. intro H. elim (rem_36 X1 X2 H).
  intros X1 X2. intro H. elim (rem_18 X1 X2 H).
  intros X1 X2. intro H. elim (rem_15 X1 X2 H).
  intros X1 X2. intro H. elim (rem_26 X1 X2 H).
  intros X1. intro H. elim (rem_20 X1 H).
  intros X1 X2. intro H. elim (rem_23 X1 X2 H).
  intros X1 X2. intro H. elim (rem_22 X1 X2 H).
   intro H. elim (rem_25  H).
   intro H. elim (rem_21  H).
  intros X1 X2;  exact (rem_2764 epsilon_m__def_77_magent X1 X2).
  intros X1 X2. intro H. elim (rem_19 X1 X2 H).
  intros X1. intro H. elim (rem_30 X1 H).
   intro H. elim (rem_35  H).
  intros X1 X2. intro H. elim (rem_32 X1 X2 H).
  intros X1 X2. intro H. elim (rem_16 X1 X2 H).
   intro H. elim (rem_31  H).
Qed.

Remark rem_2766 : forall X1 X2:term, auto___def_51 sym -> auto___def_77 X1 -> auto_agent X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2765 X1)). tauto.
Qed.

Remark rem_2767 : forall X1 X2:term, auto___def_51 sym -> auto_agent X1 -> auto___def_77 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_51 sym -> auto___def_77 X1 -> auto_agent X1 -> auto_knows_current X2 -> auto___def_103 X1 X2). tauto. exact (rem_2766 X1 X2).
Qed.

Remark rem_2768 : (forall X:term, auto___def_77 X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (r_current X1 X2) -> auto_knows_current X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_77_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_1768 X1 X2 H);  intros.
Defined.

Remark rem_2769 : (forall X:term, auto___def_77 X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_77 (r_current X1 X2) -> auto___def_13 (r_current X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_77_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_12 X1 X2 H);  intros.
  apply (rem_2768 epsilon_m__def_77_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_2770 : forall X1:term, auto___def_77 X1 -> auto___def_13 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_77_m__def_13 1.
  intro X. case X.
   intro H. elim (rem_24  H).
   intro H. elim (rem_17  H).
  intros X1 X2. intro H. elim (rem_29 X1 X2 H).
  intros X1 X2. intro H. elim (rem_14 X1 X2 H).
  intros X1 X2. intro H. elim (rem_27 X1 X2 H).
  intros X1 X2. intro H. elim (rem_28 X1 X2 H).
   intro H. elim (rem_33  H).
  intros X1 X2. intro H. elim (rem_37 X1 X2 H).
   intro H. elim (rem_34  H).
  intros X1 X2. intro H. elim (rem_36 X1 X2 H).
  intros X1 X2. intro H. elim (rem_18 X1 X2 H).
  intros X1 X2. intro H. elim (rem_15 X1 X2 H).
  intros X1 X2. intro H. elim (rem_26 X1 X2 H).
  intros X1. intro H. elim (rem_20 X1 H).
  intros X1 X2. intro H. elim (rem_23 X1 X2 H).
  intros X1 X2. intro H. elim (rem_22 X1 X2 H).
   intro H. elim (rem_25  H).
   intro H. elim (rem_21  H).
  intros X1 X2;  exact (rem_2769 epsilon_m__def_77_m__def_13 X1 X2).
  intros X1 X2. intro H. elim (rem_19 X1 X2 H).
  intros X1. intro H. elim (rem_30 X1 H).
   intro H. elim (rem_35  H).
  intros X1 X2. intro H. elim (rem_32 X1 X2 H).
  intros X1 X2. intro H. elim (rem_16 X1 X2 H).
   intro H. elim (rem_31  H).
Qed.

Remark rem_2771 : forall X1 X2:term, auto___def_12 sym -> auto___def_13 X1 -> auto___def_77 X1 -> auto_knows_current X2 -> auto___def_103 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2770 X1)). tauto.
Qed.

Remark rem_2772 : forall X1 X2:term, auto___def_77 X1 -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1 H2. intro H. intros.
  elim (rem_1066 sym X1 H);  intros.
  apply (rem_2762 X1 X2);  tauto.
  apply (rem_2767 X1 X2);  tauto.
  apply (rem_2771 X1 X2);  tauto.
Qed.

Remark rem_2773 : forall X1 X2 X3 X4:term, auto___def_76 (passwd_current X3 X4) -> auto___def_77 X1 -> auto___type_17 (key pub (session_current X3 X4)) -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto___def_103 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_77 X1 -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto___def_103 X1 X2). tauto.
  exact (rem_2772 X1 X2).
Qed.

Remark rem_2774 : forall X1 X2 X3 X4:term, auto___def_77 X1 -> auto___type_17 (key pub (session_current X3 X4)) -> auto___def_76 (passwd_current X3 X4) -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_76 (passwd_current X3 X4) -> auto___def_77 X1 -> auto___type_17 (key pub (session_current X3 X4)) -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto___def_103 X1 X2). tauto. exact (rem_2773 X1 X2 X3 X4).
Qed.

Remark rem_2775 : forall X1 X2 X3 X4:term, auto___def_75 (crypt X1 (key pub (session_current X3 X4))) -> auto___def_76 (passwd_current X3 X4) -> auto_knows_current X2 -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_731 X1 (key pub (session_current X3 X4)) H);  intros.
  apply (rem_2774 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2776 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_1031 (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4) H);  intros.
  apply (rem_2542 X1 X2 X3 X4);  tauto.
  apply (rem_2716 X1 X2 X3 X4);  tauto.
  apply (rem_2758 X1 X2 X3 X4);  tauto.
  apply (rem_2775 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2777 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto_knows_current (key sym X1) -> auto_knows_current nil -> auto_knows_current (noncea_current X3 X4) -> auto___def_103 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto___def_103 X1 X2). tauto.
  exact (rem_2776 X1 X2 X3 X4).
Qed.

Remark rem_2778 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current nil -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto_knows_current (key sym X1) -> auto_knows_current nil -> auto_knows_current (noncea_current X3 X4) -> auto___def_103 X1 X2). tauto. exact (rem_2777 X1 X2 X3 X4).
Qed.

Remark rem_2779 : forall X1 X2 X3 X4:term, auto_knows_current (cons X2 nil) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1034 X2 nil H);  intros.
  apply (rem_2778 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2780 : forall X1 X2 X3 X4:term, auto_knows_current (noncea_current X3 X4) -> auto_knows_current (cons X2 nil) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto_knows_current (key sym X1) -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current (cons X2 nil) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X3 X4) -> auto___def_103 X1 X2). tauto. exact (rem_2779 X1 X2 X3 X4).
Qed.

Remark rem_2781 : forall X1 X2 X3 X4:term, auto_knows_current (cons (noncea_current X3 X4) (cons X2 nil)) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto_knows_current (key sym X1) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1034 (noncea_current X3 X4) (cons X2 nil) H);  intros.
  apply (rem_2780 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2782 : forall X1 X2 X3 X4:term, auto_knows_current (cons (noncea_current X3 X4) (cons X2 nil)) -> auto_knows_current (key sym X1) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current (cons (noncea_current X3 X4) (cons X2 nil)) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto_knows_current (key sym X1) -> auto___def_103 X1 X2). tauto. exact (rem_2781 X1 X2 X3 X4).
Qed.

Remark rem_2783 : forall X1 X2 X3 X4:term, auto___type_22 (cons (noncea_current X3 X4) (cons X2 nil)) -> auto___type_23 X1 -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1627 (noncea_current X3 X4) (cons X2 nil) H);  intros.
Qed.

Remark rem_2784 : forall X1 X2 X3 X4:term, auto___def_105 sym -> auto___type_22 (cons (noncea_current X3 X4) (cons X2 nil)) -> auto___type_23 X1 -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_22 (cons (noncea_current X3 X4) (cons X2 nil)) -> auto___type_23 X1 -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2). tauto.
  exact (rem_2783 X1 X2 X3 X4).
Qed.

Remark rem_2785 : forall X1 X2 X3 X4:term, auto___def_105 sym -> auto___type_23 X1 -> auto___type_22 (cons (noncea_current X3 X4) (cons X2 nil)) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_105 sym -> auto___type_22 (cons (noncea_current X3 X4) (cons X2 nil)) -> auto___type_23 X1 -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2). tauto. exact (rem_2784 X1 X2 X3 X4).
Qed.

Remark rem_2786 : forall X1 X2 X3 X4:term, auto___def_104 (key sym X1) -> auto___type_22 (cons (noncea_current X3 X4) (cons X2 nil)) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1431 sym X1 H);  intros.
  apply (rem_2785 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2787 : forall X1 X2 X3 X4:term, auto___type_22 (cons (noncea_current X3 X4) (cons X2 nil)) -> auto___def_104 (key sym X1) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_104 (key sym X1) -> auto___type_22 (cons (noncea_current X3 X4) (cons X2 nil)) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2). tauto. exact (rem_2786 X1 X2 X3 X4).
Qed.

Remark rem_2788 : forall X1:term, auto___def_94 X1 -> auto___def_94 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2789 : forall X1 X2 X3 X4:term, auto___def_91 X2 -> auto___def_92 nil -> auto___def_94 X1 -> auto___type_20 (noncea_current X3 X4) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_94 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_94 X1 -> auto___def_94 X1). tauto. exact (rem_2788 X1).
Qed.

Remark rem_2790 : (forall X:term, auto___def_94 X -> auto___def_77 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2791 : (forall X:term, auto___def_94 X -> auto___def_77 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_94_p__def_77. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_2790 epsilon_m__def_94_p__def_77 X1);  assumption.
  tauto.
Defined.

Remark rem_2792 : (forall X:term, auto___def_94 X -> auto___def_77 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto___def_77 (r_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_94_p__def_77. intros X1 X2. intros A1.
  case (rem_2791 epsilon_m__def_94_p__def_77 X1 A1). clear  epsilon_m__def_94_p__def_77 A1. intros. apply trans___def_77_r_current_1;  tauto.
 clear  epsilon_m__def_94_p__def_77 A1. tauto.
Defined.

Remark rem_2793 : forall X1 X2:term, auto___def_94 (r_current X1 X2) -> or_1
    (auto_knows_current X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2794 : (forall X:term, auto___def_94 X -> auto___def_77 X)
    -> forall X1 X2:term, auto___def_94 (r_current X1 X2) -> auto___def_77 (r_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_94_p__def_77. intros X1 X2. intro H. intros.
  elim (rem_2793 X1 X2 H);  intros.
  apply (rem_2792 epsilon_m__def_94_p__def_77 X1 X2);  tauto.
Defined.

Remark rem_2795 : forall X1 X2:term, auto___def_94 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2796 : forall X1 X2:term, auto___def_94 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2797 : forall X1 X2:term, auto___def_94 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2798 : auto___def_94 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2799 : forall X1 X2:term, auto___def_94 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2800 : forall X1 X2:term, auto___def_94 (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2801 : forall X1:term, auto___def_94 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2802 : auto___def_94 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2803 : forall X1 X2:term, auto___def_94 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2804 : forall X1 X2:term, auto___def_94 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2805 : auto___def_94 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2806 : auto___def_94 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2807 : forall X1 X2:term, auto___def_94 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2808 : forall X1 X2:term, auto___def_94 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2809 : forall X1 X2:term, auto___def_94 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2810 : forall X1 X2:term, auto___def_94 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2811 : forall X1:term, auto___def_94 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2812 : auto___def_94 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2813 : forall X1 X2:term, auto___def_94 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2814 : auto___def_94 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2815 : auto___def_94 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2816 : auto___def_94 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2817 : forall X1 X2:term, auto___def_94 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2818 : forall X1 X2:term, auto___def_94 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2819 : forall X1:term, auto___def_94 X1 -> auto___def_77 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_94_p__def_77 1.
  intro X. case X.
   intro H. elim (rem_2805  H).
   intro H. elim (rem_2798  H).
  intros X1 X2. intro H. elim (rem_2810 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2795 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2808 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2809 X1 X2 H).
   intro H. elim (rem_2814  H).
  intros X1 X2. intro H. elim (rem_2818 X1 X2 H).
   intro H. elim (rem_2815  H).
  intros X1 X2. intro H. elim (rem_2817 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2799 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2796 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2807 X1 X2 H).
  intros X1. intro H. elim (rem_2801 X1 H).
  intros X1 X2. intro H. elim (rem_2804 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2803 X1 X2 H).
   intro H. elim (rem_2806  H).
   intro H. elim (rem_2802  H).
  intros X1 X2;  exact (rem_2794 epsilon_m__def_94_p__def_77 X1 X2).
  intros X1 X2. intro H. elim (rem_2800 X1 X2 H).
  intros X1. intro H. elim (rem_2811 X1 H).
   intro H. elim (rem_2816  H).
  intros X1 X2. intro H. elim (rem_2813 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2797 X1 X2 H).
   intro H. elim (rem_2812  H).
Qed.

Remark rem_2820 : forall X1 X2 X3 X4:term, auto___def_91 X2 -> auto___def_92 nil -> auto___def_94 X1 -> auto___type_20 (noncea_current X3 X4) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_77 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_94 X1 -> auto___def_77 X1). tauto. exact (rem_2819 X1).
Qed.

Remark rem_2821 : forall X2:term, auto___def_91 X2 -> auto___def_91 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2822 : forall X1 X2 X3 X4:term, auto___def_91 X2 -> auto___def_92 nil -> auto___def_94 X1 -> auto___type_20 (noncea_current X3 X4) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_91 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_91 X2 -> auto___def_91 X2). tauto. exact (rem_2821 X2).
Qed.

Remark rem_2823 : forall X1 X2 X3 X4:term, auto___def_91 X2 -> auto___def_92 nil -> auto___def_94 X1 -> auto___type_20 (noncea_current X3 X4) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> (auto___def_94 X1 /\ auto___def_77 X1 /\ auto___def_91 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5.
  cut (auto___def_94 X1). 2:apply (rem_2789 X1 X2 X3 X4);  assumption.
  cut (auto___def_77 X1). 2:apply (rem_2820 X1 X2 X3 X4);  assumption.
  cut (auto___def_91 X2). 2:apply (rem_2822 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_2824 : forall X1 X2 X3 X4:term, auto___def_91 X2 -> auto___def_92 nil -> auto___def_94 X1 -> auto___type_20 (noncea_current X3 X4) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5.
  case (rem_2823 X1 X2 X3 X4 A1 A2 A3 A4 A5). clear  A1 A2 A3 A4 A5. intros. apply trans___def_103_1;  tauto.
 clear  A1 A2 A3 A4 A5. tauto.
Qed.

Remark rem_2825 : forall X1 X2:term, auto___def_90 (cons X1 X2) -> or_1
    (auto___def_91 X1 /\ auto___def_92 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2826 : forall X1 X2 X3 X4:term, auto___def_90 (cons X2 nil) -> auto___def_94 X1 -> auto___type_20 (noncea_current X3 X4) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_2825 X2 nil H);  intros.
  apply (rem_2824 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2827 : forall X1 X2 X3 X4:term, auto___def_90 (cons X2 nil) -> auto___def_93 sym -> auto___def_94 X1 -> auto___type_20 (noncea_current X3 X4) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_90 (cons X2 nil) -> auto___def_94 X1 -> auto___type_20 (noncea_current X3 X4) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2). tauto.
  exact (rem_2826 X1 X2 X3 X4).
Qed.

Remark rem_2828 : forall X1 X2 X3 X4:term, auto___def_93 sym -> auto___def_94 X1 -> auto___def_90 (cons X2 nil) -> auto___type_20 (noncea_current X3 X4) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_90 (cons X2 nil) -> auto___def_93 sym -> auto___def_94 X1 -> auto___type_20 (noncea_current X3 X4) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2). tauto. exact (rem_2827 X1 X2 X3 X4).
Qed.

Remark rem_2829 : forall X1 X2 X3 X4:term, auto___def_89 (key sym X1) -> auto___def_90 (cons X2 nil) -> auto___type_20 (noncea_current X3 X4) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1438 sym X1 H);  intros.
  apply (rem_2828 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2830 : forall X1 X2 X3 X4:term, auto___type_20 (noncea_current X3 X4) -> auto___def_90 (cons X2 nil) -> auto___def_89 (key sym X1) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_89 (key sym X1) -> auto___def_90 (cons X2 nil) -> auto___type_20 (noncea_current X3 X4) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2). tauto. exact (rem_2829 X1 X2 X3 X4).
Qed.

Remark rem_2831 : forall X1 X2 X3 X4:term, auto___def_88 (cons (noncea_current X3 X4) (cons X2 nil)) -> auto___def_89 (key sym X1) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_2641 (noncea_current X3 X4) (cons X2 nil) H);  intros.
  apply (rem_2830 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2832 : forall X1 X2 X3 X4:term, auto___def_24 (cons (noncea_current X3 X4) (cons X2 nil)) -> auto___def_25 (key sym X1) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1937 (noncea_current X3 X4) (cons X2 nil) H);  intros.
Qed.

Remark rem_2833 : forall X1 X2 X3 X4:term, auto___type_7 (cons (noncea_current X3 X4) (cons X2 nil)) -> auto___type_8 X1 -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1939 (noncea_current X3 X4) (cons X2 nil) H);  intros.
Qed.

Remark rem_2834 : forall X1 X2 X3 X4:term, auto___def_45 sym -> auto___type_7 (cons (noncea_current X3 X4) (cons X2 nil)) -> auto___type_8 X1 -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_7 (cons (noncea_current X3 X4) (cons X2 nil)) -> auto___type_8 X1 -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2). tauto.
  exact (rem_2833 X1 X2 X3 X4).
Qed.

Remark rem_2835 : forall X1 X2 X3 X4:term, auto___def_45 sym -> auto___type_8 X1 -> auto___type_7 (cons (noncea_current X3 X4) (cons X2 nil)) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_45 sym -> auto___type_7 (cons (noncea_current X3 X4) (cons X2 nil)) -> auto___type_8 X1 -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2). tauto. exact (rem_2834 X1 X2 X3 X4).
Qed.

Remark rem_2836 : forall X1 X2 X3 X4:term, auto___def_44 (key sym X1) -> auto___type_7 (cons (noncea_current X3 X4) (cons X2 nil)) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1450 sym X1 H);  intros.
  apply (rem_2835 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2837 : forall X1 X2 X3 X4:term, auto___type_7 (cons (noncea_current X3 X4) (cons X2 nil)) -> auto___def_44 (key sym X1) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_44 (key sym X1) -> auto___type_7 (cons (noncea_current X3 X4) (cons X2 nil)) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2). tauto. exact (rem_2836 X1 X2 X3 X4).
Qed.

Remark rem_2838 : forall X1 X2 X3 X4:term, auto___def_84 (cons (noncea_current X3 X4) (cons X2 nil)) -> auto___def_85 (key sym X1) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1698 (noncea_current X3 X4) (cons X2 nil) H);  intros.
Qed.

Remark rem_2839 : forall X1 X2 X3 X4:term, auto_knows_current (crypt (cons (noncea_current X3 X4) (cons X2 nil)) (key sym X1)) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_987 (cons (noncea_current X3 X4) (cons X2 nil)) (key sym X1) H);  intros.
  apply (rem_2531 X1 X2 X3 X4);  tauto.
  apply (rem_2539 X1 X2 X3 X4);  tauto.
  apply (rem_2541 X1 X2 X3 X4);  tauto.
  apply (rem_2782 X1 X2 X3 X4);  tauto.
  apply (rem_2787 X1 X2 X3 X4);  tauto.
  apply (rem_2831 X1 X2 X3 X4);  tauto.
  apply (rem_2832 X1 X2 X3 X4);  tauto.
  apply (rem_2837 X1 X2 X3 X4);  tauto.
  apply (rem_2838 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2840 : forall X1 X2 X3 X4:term, auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto_knows_current (crypt (cons (noncea_current X3 X4) (cons X2 nil)) (key sym X1)) -> auto___def_103 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current (crypt (cons (noncea_current X3 X4) (cons X2 nil)) (key sym X1)) -> auto_knows_current (enc (crypt X1 (key pub (session_current X3 X4))) (passwd_current X3 X4)) -> auto___def_103 X1 X2). tauto. exact (rem_2839 X1 X2 X3 X4).
Qed.

Remark rem_2841 : forall X1 X2 X3 X4:term, auto___def_17 (cons (noncea_current X4 X2) (cons X3 nil)) -> auto___type_2 (key sym X1) -> auto___def_106 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1339 (noncea_current X4 X2) (cons X3 nil) H);  intros.
Qed.

Remark rem_2842 : forall X1 X2 X3 X4:term, auto___def_39 X3 -> auto___def_42 X1 -> auto___type_6 (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_2236 X4 X2 H);  intros.
Qed.

Remark rem_2843 : forall X1 X2 X3 X4:term, auto___def_39 X3 -> auto___def_40 nil -> auto___def_42 X1 -> auto___type_6 (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_39 X3 -> auto___def_42 X1 -> auto___type_6 (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4). tauto.
  exact (rem_2842 X1 X2 X3 X4).
Qed.

Remark rem_2844 : forall X1 X2 X3 X4:term, auto___def_38 (cons X3 nil) -> auto___def_42 X1 -> auto___type_6 (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1929 X3 nil H);  intros.
  apply (rem_2843 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2845 : forall X1 X2 X3 X4:term, auto___def_38 (cons X3 nil) -> auto___def_41 sym -> auto___def_42 X1 -> auto___type_6 (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_38 (cons X3 nil) -> auto___def_42 X1 -> auto___type_6 (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4). tauto.
  exact (rem_2844 X1 X2 X3 X4).
Qed.

Remark rem_2846 : forall X1 X2 X3 X4:term, auto___def_41 sym -> auto___def_42 X1 -> auto___def_38 (cons X3 nil) -> auto___type_6 (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_38 (cons X3 nil) -> auto___def_41 sym -> auto___def_42 X1 -> auto___type_6 (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4). tauto. exact (rem_2845 X1 X2 X3 X4).
Qed.

Remark rem_2847 : forall X1 X2 X3 X4:term, auto___def_37 (key sym X1) -> auto___def_38 (cons X3 nil) -> auto___type_6 (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1405 sym X1 H);  intros.
  apply (rem_2846 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2848 : forall X1 X2 X3 X4:term, auto___type_6 (noncea_current X4 X2) -> auto___def_38 (cons X3 nil) -> auto___def_37 (key sym X1) -> auto___def_106 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_37 (key sym X1) -> auto___def_38 (cons X3 nil) -> auto___type_6 (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4). tauto. exact (rem_2847 X1 X2 X3 X4).
Qed.

Remark rem_2849 : forall X1 X2 X3 X4:term, auto___def_36 (cons (noncea_current X4 X2) (cons X3 nil)) -> auto___def_37 (key sym X1) -> auto___def_106 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1935 (noncea_current X4 X2) (cons X3 nil) H);  intros.
  apply (rem_2848 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2850 : forall X1 X2 X3 X4:term, auto___def_21 (cons (noncea_current X4 X2) (cons X3 nil)) -> auto___def_22 (key sym X1) -> auto___def_106 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_2540 (noncea_current X4 X2) (cons X3 nil) H);  intros.
Qed.

Remark rem_2851 : forall X1 X2 X3 X4:term, auto___def_62 X1 -> auto_knows_current X3 -> auto_knows_current (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_1077 X4 X2 H);  intros.
Qed.

Remark rem_2852 : forall X1 X2 X3 X4:term, auto___def_61 sym -> auto___def_62 X1 -> auto_knows_current X3 -> auto_knows_current (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_62 X1 -> auto_knows_current X3 -> auto_knows_current (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4). tauto.
  exact (rem_2851 X1 X2 X3 X4).
Qed.

Remark rem_2853 : forall X1 X2 X3 X4:term, auto_agent X1 -> auto_knows_current X3 -> auto_knows_current (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_1077 X4 X2 H);  intros.
Qed.

Remark rem_2854 : forall X1 X2 X3 X4:term, auto___def_51 sym -> auto_agent X1 -> auto_knows_current X3 -> auto_knows_current (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_agent X1 -> auto_knows_current X3 -> auto_knows_current (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4). tauto.
  exact (rem_2853 X1 X2 X3 X4).
Qed.

Remark rem_2855 : forall X1 X2 X3 X4:term, auto___def_13 X1 -> auto_knows_current X3 -> auto_knows_current (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_1077 X4 X2 H);  intros.
Qed.

Remark rem_2856 : forall X1 X2 X3 X4:term, auto___def_12 sym -> auto___def_13 X1 -> auto_knows_current X3 -> auto_knows_current (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_13 X1 -> auto_knows_current X3 -> auto_knows_current (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4). tauto.
  exact (rem_2855 X1 X2 X3 X4).
Qed.

Remark rem_2857 : forall X1 X2 X3 X4:term, auto_knows_current X3 -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_1066 sym X1 H);  intros.
  apply (rem_2852 X1 X2 X3 X4);  tauto.
  apply (rem_2854 X1 X2 X3 X4);  tauto.
  apply (rem_2856 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2858 : forall X1 X2 X3 X4:term, auto_knows_current X3 -> auto_knows_current (key sym X1) -> auto_knows_current nil -> auto_knows_current (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X3 -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4). tauto.
  exact (rem_2857 X1 X2 X3 X4).
Qed.

Remark rem_2859 : forall X1 X2 X3 X4:term, auto_knows_current X3 -> auto_knows_current nil -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current X3 -> auto_knows_current (key sym X1) -> auto_knows_current nil -> auto_knows_current (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4). tauto. exact (rem_2858 X1 X2 X3 X4).
Qed.

Remark rem_2860 : forall X1 X2 X3 X4:term, auto_knows_current (cons X3 nil) -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1034 X3 nil H);  intros.
  apply (rem_2859 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2861 : forall X1 X2 X3 X4:term, auto_knows_current (noncea_current X4 X2) -> auto_knows_current (cons X3 nil) -> auto_knows_current (key sym X1) -> auto___def_106 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current (cons X3 nil) -> auto_knows_current (key sym X1) -> auto_knows_current (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4). tauto. exact (rem_2860 X1 X2 X3 X4).
Qed.

Remark rem_2862 : forall X1 X2 X3 X4:term, auto_knows_current (cons (noncea_current X4 X2) (cons X3 nil)) -> auto_knows_current (key sym X1) -> auto___def_106 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1034 (noncea_current X4 X2) (cons X3 nil) H);  intros.
  apply (rem_2861 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2863 : forall X1 X2 X3 X4:term, auto___type_22 (cons (noncea_current X4 X2) (cons X3 nil)) -> auto___type_23 X1 -> auto___def_106 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1627 (noncea_current X4 X2) (cons X3 nil) H);  intros.
Qed.

Remark rem_2864 : forall X1 X2 X3 X4:term, auto___def_105 sym -> auto___type_22 (cons (noncea_current X4 X2) (cons X3 nil)) -> auto___type_23 X1 -> auto___def_106 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_22 (cons (noncea_current X4 X2) (cons X3 nil)) -> auto___type_23 X1 -> auto___def_106 X1 X2 X3 X4). tauto.
  exact (rem_2863 X1 X2 X3 X4).
Qed.

Remark rem_2865 : forall X1 X2 X3 X4:term, auto___def_105 sym -> auto___type_23 X1 -> auto___type_22 (cons (noncea_current X4 X2) (cons X3 nil)) -> auto___def_106 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_105 sym -> auto___type_22 (cons (noncea_current X4 X2) (cons X3 nil)) -> auto___type_23 X1 -> auto___def_106 X1 X2 X3 X4). tauto. exact (rem_2864 X1 X2 X3 X4).
Qed.

Remark rem_2866 : forall X1 X2 X3 X4:term, auto___def_104 (key sym X1) -> auto___type_22 (cons (noncea_current X4 X2) (cons X3 nil)) -> auto___def_106 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1431 sym X1 H);  intros.
  apply (rem_2865 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2867 : forall X1 X2 X3 X4:term, auto___type_22 (cons (noncea_current X4 X2) (cons X3 nil)) -> auto___def_104 (key sym X1) -> auto___def_106 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_104 (key sym X1) -> auto___type_22 (cons (noncea_current X4 X2) (cons X3 nil)) -> auto___def_106 X1 X2 X3 X4). tauto. exact (rem_2866 X1 X2 X3 X4).
Qed.

Remark rem_2868 : forall X1 X2 X3 X4:term, auto___def_91 X3 -> auto___def_94 X1 -> auto_agent X4 -> auto_agent X2 -> auto___def_94 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_94 X1 -> auto___def_94 X1). tauto. exact (rem_2788 X1).
Qed.

Remark rem_2869 : forall X1 X2 X3 X4:term, auto___def_91 X3 -> auto___def_94 X1 -> auto_agent X4 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_925 X2).
Qed.

Remark rem_2870 : forall X3:term, auto___def_91 X3 -> auto___def_91 X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2871 : forall X1 X2 X3 X4:term, auto___def_91 X3 -> auto___def_94 X1 -> auto_agent X4 -> auto_agent X2 -> auto___def_91 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_91 X3 -> auto___def_91 X3). tauto. exact (rem_2870 X3).
Qed.

Remark rem_2872 : forall X4:term, auto_agent X4 -> auto_agent X4. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2873 : forall X1 X2 X3 X4:term, auto___def_91 X3 -> auto___def_94 X1 -> auto_agent X4 -> auto_agent X2 -> auto_agent X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_agent X4 -> auto_agent X4). tauto. exact (rem_2872 X4).
Qed.

Remark rem_2874 : forall X1 X2 X3 X4:term, auto___def_91 X3 -> auto___def_94 X1 -> auto_agent X4 -> auto_agent X2 -> (auto___def_94 X1 /\ auto_agent X2 /\ auto___def_91 X3 /\ auto_agent X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4.
  cut (auto___def_94 X1). 2:apply (rem_2868 X1 X2 X3 X4);  assumption.
  cut (auto_agent X2). 2:apply (rem_2869 X1 X2 X3 X4);  assumption.
  cut (auto___def_91 X3). 2:apply (rem_2871 X1 X2 X3 X4);  assumption.
  cut (auto_agent X4). 2:apply (rem_2873 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_2875 : forall X1 X2 X3 X4:term, auto___def_91 X3 -> auto___def_94 X1 -> auto_agent X4 -> auto_agent X2 -> auto___def_106 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4.
  case (rem_2874 X1 X2 X3 X4 A1 A2 A3 A4). clear  A1 A2 A3 A4. intros. apply trans___def_106_1;  tauto.
 clear  A1 A2 A3 A4. tauto.
Qed.

Remark rem_2876 : forall X1 X2 X3 X4:term, auto_agent X4 -> auto_agent X2 -> auto___def_91 X3 -> auto___def_94 X1 -> auto___def_106 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_91 X3 -> auto___def_94 X1 -> auto_agent X4 -> auto_agent X2 -> auto___def_106 X1 X2 X3 X4). tauto. exact (rem_2875 X1 X2 X3 X4).
Qed.

Remark rem_2877 : forall X1 X2:term, auto___type_20 (noncea_current X1 X2) -> or_1
    (auto_agent X1 /\ auto_agent X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2878 : forall X1 X2 X3 X4:term, auto___def_91 X3 -> auto___def_94 X1 -> auto___type_20 (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_2877 X4 X2 H);  intros.
  apply (rem_2876 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2879 : forall X1 X2 X3 X4:term, auto___def_91 X3 -> auto___def_92 nil -> auto___def_94 X1 -> auto___type_20 (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_91 X3 -> auto___def_94 X1 -> auto___type_20 (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4). tauto.
  exact (rem_2878 X1 X2 X3 X4).
Qed.

Remark rem_2880 : forall X1 X2 X3 X4:term, auto___def_90 (cons X3 nil) -> auto___def_94 X1 -> auto___type_20 (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_2825 X3 nil H);  intros.
  apply (rem_2879 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2881 : forall X1 X2 X3 X4:term, auto___def_90 (cons X3 nil) -> auto___def_93 sym -> auto___def_94 X1 -> auto___type_20 (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_90 (cons X3 nil) -> auto___def_94 X1 -> auto___type_20 (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4). tauto.
  exact (rem_2880 X1 X2 X3 X4).
Qed.

Remark rem_2882 : forall X1 X2 X3 X4:term, auto___def_93 sym -> auto___def_94 X1 -> auto___def_90 (cons X3 nil) -> auto___type_20 (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_90 (cons X3 nil) -> auto___def_93 sym -> auto___def_94 X1 -> auto___type_20 (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4). tauto. exact (rem_2881 X1 X2 X3 X4).
Qed.

Remark rem_2883 : forall X1 X2 X3 X4:term, auto___def_89 (key sym X1) -> auto___def_90 (cons X3 nil) -> auto___type_20 (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1438 sym X1 H);  intros.
  apply (rem_2882 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2884 : forall X1 X2 X3 X4:term, auto___type_20 (noncea_current X4 X2) -> auto___def_90 (cons X3 nil) -> auto___def_89 (key sym X1) -> auto___def_106 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_89 (key sym X1) -> auto___def_90 (cons X3 nil) -> auto___type_20 (noncea_current X4 X2) -> auto___def_106 X1 X2 X3 X4). tauto. exact (rem_2883 X1 X2 X3 X4).
Qed.

Remark rem_2885 : forall X1 X2 X3 X4:term, auto___def_88 (cons (noncea_current X4 X2) (cons X3 nil)) -> auto___def_89 (key sym X1) -> auto___def_106 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_2641 (noncea_current X4 X2) (cons X3 nil) H);  intros.
  apply (rem_2884 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2886 : forall X1 X2 X3 X4:term, auto___def_24 (cons (noncea_current X4 X2) (cons X3 nil)) -> auto___def_25 (key sym X1) -> auto___def_106 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1937 (noncea_current X4 X2) (cons X3 nil) H);  intros.
Qed.

Remark rem_2887 : forall X1 X2 X3 X4:term, auto___type_7 (cons (noncea_current X4 X2) (cons X3 nil)) -> auto___type_8 X1 -> auto___def_106 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1939 (noncea_current X4 X2) (cons X3 nil) H);  intros.
Qed.

Remark rem_2888 : forall X1 X2 X3 X4:term, auto___def_45 sym -> auto___type_7 (cons (noncea_current X4 X2) (cons X3 nil)) -> auto___type_8 X1 -> auto___def_106 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_7 (cons (noncea_current X4 X2) (cons X3 nil)) -> auto___type_8 X1 -> auto___def_106 X1 X2 X3 X4). tauto.
  exact (rem_2887 X1 X2 X3 X4).
Qed.

Remark rem_2889 : forall X1 X2 X3 X4:term, auto___def_45 sym -> auto___type_8 X1 -> auto___type_7 (cons (noncea_current X4 X2) (cons X3 nil)) -> auto___def_106 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_45 sym -> auto___type_7 (cons (noncea_current X4 X2) (cons X3 nil)) -> auto___type_8 X1 -> auto___def_106 X1 X2 X3 X4). tauto. exact (rem_2888 X1 X2 X3 X4).
Qed.

Remark rem_2890 : forall X1 X2 X3 X4:term, auto___def_44 (key sym X1) -> auto___type_7 (cons (noncea_current X4 X2) (cons X3 nil)) -> auto___def_106 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1450 sym X1 H);  intros.
  apply (rem_2889 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2891 : forall X1 X2 X3 X4:term, auto___type_7 (cons (noncea_current X4 X2) (cons X3 nil)) -> auto___def_44 (key sym X1) -> auto___def_106 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_44 (key sym X1) -> auto___type_7 (cons (noncea_current X4 X2) (cons X3 nil)) -> auto___def_106 X1 X2 X3 X4). tauto. exact (rem_2890 X1 X2 X3 X4).
Qed.

Remark rem_2892 : forall X1 X2 X3 X4:term, auto___def_84 (cons (noncea_current X4 X2) (cons X3 nil)) -> auto___def_85 (key sym X1) -> auto___def_106 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1698 (noncea_current X4 X2) (cons X3 nil) H);  intros.
Qed.

Remark rem_2893 : forall X1 X2 X3 X4:term, auto_knows_current (crypt (cons (noncea_current X4 X2) (cons X3 nil)) (key sym X1)) -> auto___def_106 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_987 (cons (noncea_current X4 X2) (cons X3 nil)) (key sym X1) H);  intros.
  apply (rem_2841 X1 X2 X3 X4);  tauto.
  apply (rem_2849 X1 X2 X3 X4);  tauto.
  apply (rem_2850 X1 X2 X3 X4);  tauto.
  apply (rem_2862 X1 X2 X3 X4);  tauto.
  apply (rem_2867 X1 X2 X3 X4);  tauto.
  apply (rem_2885 X1 X2 X3 X4);  tauto.
  apply (rem_2886 X1 X2 X3 X4);  tauto.
  apply (rem_2891 X1 X2 X3 X4);  tauto.
  apply (rem_2892 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2894 : (forall X:term, auto___def_62 X -> auto___type_15 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_62_p__type_15.  tauto.
Defined.

Remark rem_2895 : (forall X:term, auto___def_62 X -> auto___type_15 X)
    -> auto___type_15 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_62_p__type_15.  case (rem_2894 epsilon_m__def_62_p__type_15). clear  epsilon_m__def_62_p__type_15. intros. apply trans___type_15_i_1;  tauto.
 clear  epsilon_m__def_62_p__type_15. tauto.
Defined.

Remark rem_2896 : (forall X:term, auto___def_62 X -> auto___type_15 X)
    -> auto___def_62 i -> auto___type_15 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_62_p__type_15. intro H. intros.
  elim (rem_312 H);  intros.
  apply (rem_2895 epsilon_m__def_62_p__type_15);  tauto.
Defined.

Remark rem_2897 : forall X1:term, auto___def_62 X1 -> auto___type_15 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_62_p__type_15 1.
  intro X. case X.
   intro H. elim (rem_325  H).
   intro H. elim (rem_317  H).
  intros X1 X2. intro H. elim (rem_330 X1 X2 H).
  intros X1 X2. intro H. elim (rem_314 X1 X2 H).
  intros X1 X2. intro H. elim (rem_328 X1 X2 H).
  intros X1 X2. intro H. elim (rem_329 X1 X2 H).
  exact (rem_2896 epsilon_m__def_62_p__type_15 ).
  intros X1 X2. intro H. elim (rem_337 X1 X2 H).
   intro H. elim (rem_334  H).
  intros X1 X2. intro H. elim (rem_336 X1 X2 H).
  intros X1 X2. intro H. elim (rem_318 X1 X2 H).
  intros X1 X2. intro H. elim (rem_315 X1 X2 H).
  intros X1 X2. intro H. elim (rem_327 X1 X2 H).
  intros X1. intro H. elim (rem_321 X1 H).
  intros X1 X2. intro H. elim (rem_324 X1 X2 H).
  intros X1 X2. intro H. elim (rem_323 X1 X2 H).
   intro H. elim (rem_326  H).
   intro H. elim (rem_322  H).
  intros X1 X2. intro H. elim (rem_320 X1 X2 H).
  intros X1 X2. intro H. elim (rem_319 X1 X2 H).
  intros X1. intro H. elim (rem_331 X1 H).
   intro H. elim (rem_335  H).
  intros X1 X2. intro H. elim (rem_333 X1 X2 H).
  intros X1 X2. intro H. elim (rem_316 X1 X2 H).
   intro H. elim (rem_332  H).
Qed.

Remark rem_2898 : forall X1 X2:term, auto___def_62 X1 -> auto_knows_old X2 -> auto_testable_old X2 -> auto___type_15 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_62 X1 -> auto___type_15 X1). tauto. exact (rem_2897 X1).
Qed.

Remark rem_2899 : forall X1 X2:term, auto___def_3 X1 X2 -> or_1
    (auto___def_62 X1 /\ auto_knows_old X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2900 : forall X1 X2:term, auto___def_3 X1 X2 -> auto_testable_old X2 -> auto___type_15 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_2899 X1 X2 H);  intros.
  apply (rem_2898 X1 X2);  tauto.
Qed.

Remark rem_2901 : forall X1 X2 X3 X4:term, auto___def_13 (r_current X3 X1) -> auto___def_17 X2 -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1768 X3 X1 H);  intros.
Qed.

Remark rem_2902 : forall X1 X2 X3 X4:term, auto___def_12 sym -> auto___def_13 (r_current X3 X1) -> auto___def_17 X2 -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_13 (r_current X3 X1) -> auto___def_17 X2 -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3). tauto.
  exact (rem_2901 X1 X2 X3 X4).
Qed.

Remark rem_2903 : forall X1 X2 X3 X4:term, auto___def_17 X2 -> auto___type_2 (key sym (r_current X3 X1)) -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_1399 sym (r_current X3 X1) H);  intros.
  apply (rem_2902 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2904 : forall X1 X2 X3 X4:term, auto___def_36 X2 -> auto___def_42 (r_current X3 X1) -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_399 X3 X1 H);  intros.
Qed.

Remark rem_2905 : forall X1 X2 X3 X4:term, auto___def_36 X2 -> auto___def_41 sym -> auto___def_42 (r_current X3 X1) -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_36 X2 -> auto___def_42 (r_current X3 X1) -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3). tauto.
  exact (rem_2904 X1 X2 X3 X4).
Qed.

Remark rem_2906 : forall X1 X2 X3 X4:term, auto___def_41 sym -> auto___def_42 (r_current X3 X1) -> auto___def_36 X2 -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_36 X2 -> auto___def_41 sym -> auto___def_42 (r_current X3 X1) -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3). tauto. exact (rem_2905 X1 X2 X3 X4).
Qed.

Remark rem_2907 : forall X1 X2 X3 X4:term, auto___def_36 X2 -> auto___def_37 (key sym (r_current X3 X1)) -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_1405 sym (r_current X3 X1) H);  intros.
  apply (rem_2906 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2908 : forall X1 X2 X3 X4:term, auto___def_21 X2 -> auto___def_22 (key sym (r_current X3 X1)) -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_1407 sym (r_current X3 X1) H);  intros.
Qed.

Remark rem_2909 : forall X1 X2 X3:term, auto___def_62 (r_current X3 X1) -> auto_agent X3 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_320 X3 X1 H);  intros.
Qed.

Remark rem_2910 : forall X1 X2 X3:term, auto___def_61 sym -> auto___def_62 (r_current X3 X1) -> auto_agent X3 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_87 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_62 (r_current X3 X1) -> auto_agent X3 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_87 X1 X2 X3). tauto.
  exact (rem_2909 X1 X2 X3).
Qed.

Remark rem_2911 : forall X1 X2 X3:term, auto_agent X3 -> auto_agent X1 -> auto_agent (r_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1 H2. intro H. intros.
  elim (rem_1099 X3 X1 H);  intros.
Qed.

Remark rem_2912 : forall X1 X2 X3:term, auto___def_51 sym -> auto_agent X3 -> auto_agent X1 -> auto_agent (r_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_87 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto_agent X3 -> auto_agent X1 -> auto_agent (r_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_87 X1 X2 X3). tauto.
  exact (rem_2911 X1 X2 X3).
Qed.

Remark rem_2913 : forall X1 X2 X3:term, auto___def_51 sym -> auto_agent (r_current X3 X1) -> auto_agent X3 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_87 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_51 sym -> auto_agent X3 -> auto_agent X1 -> auto_agent (r_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_87 X1 X2 X3). tauto. exact (rem_2912 X1 X2 X3).
Qed.

Remark rem_2914 : forall X1 X2 X3:term, auto___def_13 (r_current X3 X1) -> auto_agent X3 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1768 X3 X1 H);  intros.
Qed.

Remark rem_2915 : forall X1 X2 X3:term, auto___def_12 sym -> auto___def_13 (r_current X3 X1) -> auto_agent X3 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_87 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_13 (r_current X3 X1) -> auto_agent X3 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_87 X1 X2 X3). tauto.
  exact (rem_2914 X1 X2 X3).
Qed.

Remark rem_2916 : forall X1 X2 X3:term, auto_agent X3 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (key sym (r_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_1066 sym (r_current X3 X1) H);  intros.
  apply (rem_2910 X1 X2 X3);  tauto.
  apply (rem_2913 X1 X2 X3);  tauto.
  apply (rem_2915 X1 X2 X3);  tauto.
Qed.

Remark rem_2917 : forall X1 X2:term, auto___def_72 (passwd_current X1 X2) -> or_1
    (auto_agent X1 /\ auto_agent X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2918 : forall X1 X2 X3:term, auto___def_72 (passwd_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (key sym (r_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_2917 X3 X1 H);  intros.
  apply (rem_2916 X1 X2 X3);  tauto.
Qed.

Remark rem_2919 : forall X1 X2 X3 X4:term, auto___def_71 X4 -> auto___def_72 (passwd_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (key sym (r_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_72 (passwd_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (key sym (r_current X3 X1)) -> auto___def_87 X1 X2 X3). tauto.
  exact (rem_2918 X1 X2 X3).
Qed.

Remark rem_2920 : forall X1 X2 X3:term, auto___def_62 (r_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (passwd_current X3 X1) -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_320 X3 X1 H);  intros.
Qed.

Remark rem_2921 : forall X1 X2 X3:term, auto___def_61 sym -> auto___def_62 (r_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (passwd_current X3 X1) -> auto___def_87 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_62 (r_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (passwd_current X3 X1) -> auto___def_87 X1 X2 X3). tauto.
  exact (rem_2920 X1 X2 X3).
Qed.

Remark rem_2922 : forall X1 X2 X3:term, auto_agent (r_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (passwd_current X3 X1) -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1099 X3 X1 H);  intros.
Qed.

Remark rem_2923 : forall X1 X2 X3:term, auto___def_51 sym -> auto_agent (r_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (passwd_current X3 X1) -> auto___def_87 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto_agent (r_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (passwd_current X3 X1) -> auto___def_87 X1 X2 X3). tauto.
  exact (rem_2922 X1 X2 X3).
Qed.

Remark rem_2924 : forall X1 X2 X3:term, auto___def_13 (r_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (passwd_current X3 X1) -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1768 X3 X1 H);  intros.
Qed.

Remark rem_2925 : forall X1 X2 X3:term, auto___def_12 sym -> auto___def_13 (r_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (passwd_current X3 X1) -> auto___def_87 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_13 (r_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (passwd_current X3 X1) -> auto___def_87 X1 X2 X3). tauto.
  exact (rem_2924 X1 X2 X3).
Qed.

Remark rem_2926 : forall X1 X2 X3:term, auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (key sym (r_current X3 X1)) -> auto_knows_current (passwd_current X3 X1) -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1 H2. intro H. intros.
  elim (rem_1066 sym (r_current X3 X1) H);  intros.
  apply (rem_2921 X1 X2 X3);  tauto.
  apply (rem_2923 X1 X2 X3);  tauto.
  apply (rem_2925 X1 X2 X3);  tauto.
Qed.

Remark rem_2927 : forall X1 X2 X3 X4:term, auto_knows_current X4 -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (key sym (r_current X3 X1)) -> auto_knows_current (passwd_current X3 X1) -> auto___def_87 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (key sym (r_current X3 X1)) -> auto_knows_current (passwd_current X3 X1) -> auto___def_87 X1 X2 X3). tauto.
  exact (rem_2926 X1 X2 X3).
Qed.

Remark rem_2928 : forall X1 X2 X3 X4:term, auto_knows_current X4 -> auto_knows_current (passwd_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (key sym (r_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current X4 -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (key sym (r_current X3 X1)) -> auto_knows_current (passwd_current X3 X1) -> auto___def_87 X1 X2 X3). tauto. exact (rem_2927 X1 X2 X3 X4).
Qed.

Remark rem_2929 : forall X1 X2 X3:term, auto___def_62 (r_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_320 X3 X1 H);  intros.
Qed.

Remark rem_2930 : forall X1 X2 X3:term, auto___def_61 sym -> auto___def_62 (r_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_87 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_62 (r_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_87 X1 X2 X3). tauto.
  exact (rem_2929 X1 X2 X3).
Qed.

Remark rem_2931 : forall X1 X2 X3:term, auto_agent (r_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1099 X3 X1 H);  intros.
Qed.

Remark rem_2932 : forall X1 X2 X3:term, auto___def_51 sym -> auto_agent (r_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_87 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto_agent (r_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_87 X1 X2 X3). tauto.
  exact (rem_2931 X1 X2 X3).
Qed.

Remark rem_2933 : forall X1 X2 X3:term, auto___def_13 (r_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1768 X3 X1 H);  intros.
Qed.

Remark rem_2934 : forall X1 X2 X3:term, auto___def_12 sym -> auto___def_13 (r_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_87 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_13 (r_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_87 X1 X2 X3). tauto.
  exact (rem_2933 X1 X2 X3).
Qed.

Remark rem_2935 : forall X1 X2 X3:term, auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (key sym (r_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1 H2. intro H. intros.
  elim (rem_1066 sym (r_current X3 X1) H);  intros.
  apply (rem_2930 X1 X2 X3);  tauto.
  apply (rem_2932 X1 X2 X3);  tauto.
  apply (rem_2934 X1 X2 X3);  tauto.
Qed.

Remark rem_2936 : forall X1 X2 X3:term, auto_knows_current X3 -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (key sym (r_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (key sym (r_current X3 X1)) -> auto___def_87 X1 X2 X3). tauto. exact (rem_2935 X1 X2 X3).
Qed.

Remark rem_2937 : forall X1 X2:term, auto___def_80 (passwd_current X1 X2) -> or_1
    (auto_knows_current X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2938 : forall X1 X2 X3:term, auto___def_80 (passwd_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (key sym (r_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_2937 X3 X1 H);  intros.
  apply (rem_2936 X1 X2 X3);  tauto.
Qed.

Remark rem_2939 : forall X1 X2 X3 X4:term, auto___def_79 X4 -> auto___def_80 (passwd_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (key sym (r_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_80 (passwd_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (key sym (r_current X3 X1)) -> auto___def_87 X1 X2 X3). tauto.
  exact (rem_2938 X1 X2 X3).
Qed.

Remark rem_2940 : forall X1 X2:term, auto___def_76 (passwd_current X1 X2) -> or_1
    (auto_knows_current X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2941 : forall X1 X2 X3:term, auto___def_76 (passwd_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (key sym (r_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_2940 X3 X1 H);  intros.
  apply (rem_2936 X1 X2 X3);  tauto.
Qed.

Remark rem_2942 : forall X1 X2 X3 X4:term, auto___def_75 X4 -> auto___def_76 (passwd_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (key sym (r_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_76 (passwd_current X3 X1) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (key sym (r_current X3 X1)) -> auto___def_87 X1 X2 X3). tauto.
  exact (rem_2941 X1 X2 X3).
Qed.

Remark rem_2943 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto_knows_current (key sym (r_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_1031 X4 (passwd_current X3 X1) H);  intros.
  apply (rem_2919 X1 X2 X3 X4);  tauto.
  apply (rem_2928 X1 X2 X3 X4);  tauto.
  apply (rem_2939 X1 X2 X3 X4);  tauto.
  apply (rem_2942 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2944 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current (key sym (r_current X3 X1)) -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto_knows_current (key sym (r_current X3 X1)) -> auto___def_87 X1 X2 X3). tauto. exact (rem_2943 X1 X2 X3 X4).
Qed.

Remark rem_2945 : forall X2:term, auto___type_22 X2 -> auto___type_22 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2946 : forall X1 X2 X3 X4:term, auto___def_104 (key sym (r_current X3 X1)) -> auto___type_22 X2 -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___type_22 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_22 X2 -> auto___type_22 X2). tauto. exact (rem_2945 X2).
Qed.

Remark rem_2947 : forall X3:term, auto_knows_current X3 -> auto_knows_current X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2948 : forall X1 X2 X3 X4:term, auto___def_104 (key sym (r_current X3 X1)) -> auto___type_22 X2 -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto_knows_current X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X3 -> auto_knows_current X3). tauto. exact (rem_2947 X3).
Qed.

Remark rem_2949 : forall X1 X2 X3 X4:term, auto___def_104 (key sym (r_current X3 X1)) -> auto___type_22 X2 -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> (auto___type_22 X2 /\ auto_knows_current X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4.
  cut (auto___type_22 X2). 2:apply (rem_2946 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X3). 2:apply (rem_2948 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_2950 : forall X1 X2 X3 X4:term, auto___def_104 (key sym (r_current X3 X1)) -> auto___type_22 X2 -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4.
  case (rem_2949 X1 X2 X3 X4 A1 A2 A3 A4). clear  A1 A2 A3 A4. intros. apply trans___def_87_1;  tauto.
 clear  A1 A2 A3 A4. tauto.
Qed.

Remark rem_2951 : forall X1 X2 X3 X4:term, auto___type_22 X2 -> auto___def_104 (key sym (r_current X3 X1)) -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_104 (key sym (r_current X3 X1)) -> auto___type_22 X2 -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3). tauto. exact (rem_2950 X1 X2 X3 X4).
Qed.

Remark rem_2952 : (forall X:term, auto___type_20 X -> auto___type_21 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2953 : (forall X:term, auto___type_20 X -> auto___type_21 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_20_p__type_21. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_2952 epsilon_m__type_20_p__type_21 X1);  assumption.
  tauto.
Defined.

Remark rem_2954 : (forall X:term, auto___type_20 X -> auto___type_21 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto___type_21 (nonceb_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_20_p__type_21. intros X1 X2. intros A1.
  case (rem_2953 epsilon_m__type_20_p__type_21 X1 A1). clear  epsilon_m__type_20_p__type_21 A1. intros. apply trans___type_21_nonceb_current_1;  tauto.
 clear  epsilon_m__type_20_p__type_21 A1. tauto.
Defined.

Remark rem_2955 : forall X1 X2:term, auto___type_20 (nonceb_current X1 X2) -> or_1
    (auto_knows_current X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2956 : (forall X:term, auto___type_20 X -> auto___type_21 X)
    -> forall X1 X2:term, auto___type_20 (nonceb_current X1 X2) -> auto___type_21 (nonceb_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_20_p__type_21. intros X1 X2. intro H. intros.
  elim (rem_2955 X1 X2 H);  intros.
  apply (rem_2954 epsilon_m__type_20_p__type_21 X1 X2);  tauto.
Defined.

Remark rem_2957 : (forall X:term, auto___type_20 X -> auto___type_21 X)
    -> forall X1:term, auto___type_21 X1 -> auto___type_21 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2958 : (forall X:term, auto___type_20 X -> auto___type_21 X)
    -> forall X1 X2:term, auto___type_21 X1 -> auto___def_98 X2 -> auto___type_21 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_20_p__type_21. intros X1 X2.
  cut (auto___type_21 X1 -> auto___type_21 X1). tauto. exact (rem_2957 epsilon_m__type_20_p__type_21 X1).
Defined.

Remark rem_2959 : (forall X:term, auto___type_20 X -> auto___type_21 X)
    -> forall X2:term, auto___def_98 X2 -> auto___def_98 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2960 : (forall X:term, auto___type_20 X -> auto___type_21 X)
    -> forall X1 X2:term, auto___type_21 X1 -> auto___def_98 X2 -> auto___def_98 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_20_p__type_21. intros X1 X2.
  cut (auto___def_98 X2 -> auto___def_98 X2). tauto. exact (rem_2959 epsilon_m__type_20_p__type_21 X2).
Defined.

Remark rem_2961 : (forall X:term, auto___type_20 X -> auto___type_21 X)
    -> forall X1 X2:term, auto___type_21 X1 -> auto___def_98 X2 -> (auto___type_21 X1 /\ auto___def_98 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_20_p__type_21. intros X1 X2. intros A1 A2.
  cut (auto___type_21 X1). 2:apply (rem_2958 epsilon_m__type_20_p__type_21 X1 X2);  assumption.
  cut (auto___def_98 X2). 2:apply (rem_2960 epsilon_m__type_20_p__type_21 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2962 : (forall X:term, auto___type_20 X -> auto___type_21 X)
    -> forall X1 X2:term, auto___type_21 X1 -> auto___def_98 X2 -> auto___type_21 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_20_p__type_21. intros X1 X2. intros A1 A2.
  case (rem_2961 epsilon_m__type_20_p__type_21 X1 X2 A1 A2). clear  epsilon_m__type_20_p__type_21 A1 A2. intros. apply trans___type_21_cons_1;  tauto.
 clear  epsilon_m__type_20_p__type_21 A1 A2. tauto.
Defined.

Remark rem_2963 : forall X1 X2:term, auto___type_20 (cons X1 X2) -> or_1
    (auto___type_21 X1 /\ auto___def_98 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2964 : (forall X:term, auto___type_20 X -> auto___type_21 X)
    -> forall X1 X2:term, auto___type_20 (cons X1 X2) -> auto___type_21 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_20_p__type_21. intros X1 X2. intro H. intros.
  elim (rem_2963 X1 X2 H);  intros.
  apply (rem_2962 epsilon_m__type_20_p__type_21 X1 X2);  tauto.
Defined.

Remark rem_2965 : (forall X:term, auto___type_20 X -> auto___type_21 X)
    -> forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2966 : (forall X:term, auto___type_20 X -> auto___type_21 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_20_p__type_21. intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_2965 epsilon_m__type_20_p__type_21 X1).
Defined.

Remark rem_2967 : (forall X:term, auto___type_20 X -> auto___type_21 X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2968 : (forall X:term, auto___type_20 X -> auto___type_21 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_20_p__type_21. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_2967 epsilon_m__type_20_p__type_21 X2).
Defined.

Remark rem_2969 : (forall X:term, auto___type_20 X -> auto___type_21 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> (auto_agent X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_20_p__type_21. intros X1 X2. intros A1 A2.
  cut (auto_agent X1). 2:apply (rem_2966 epsilon_m__type_20_p__type_21 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_2968 epsilon_m__type_20_p__type_21 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2970 : (forall X:term, auto___type_20 X -> auto___type_21 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_21 (noncea_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_20_p__type_21. intros X1 X2. intros A1 A2.
  case (rem_2969 epsilon_m__type_20_p__type_21 X1 X2 A1 A2). clear  epsilon_m__type_20_p__type_21 A1 A2. intros. apply trans___type_21_noncea_current_1;  tauto.
 clear  epsilon_m__type_20_p__type_21 A1 A2. tauto.
Defined.

Remark rem_2971 : (forall X:term, auto___type_20 X -> auto___type_21 X)
    -> forall X1 X2:term, auto___type_20 (noncea_current X1 X2) -> auto___type_21 (noncea_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_20_p__type_21. intros X1 X2. intro H. intros.
  elim (rem_2877 X1 X2 H);  intros.
  apply (rem_2970 epsilon_m__type_20_p__type_21 X1 X2);  tauto.
Defined.

Remark rem_2972 : forall X1 X2:term, auto___type_20 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2973 : forall X1 X2:term, auto___type_20 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2974 : auto___type_20 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2975 : forall X1 X2:term, auto___type_20 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2976 : forall X1 X2:term, auto___type_20 (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2977 : forall X1 X2:term, auto___type_20 (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2978 : forall X1:term, auto___type_20 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2979 : auto___type_20 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2980 : forall X1 X2:term, auto___type_20 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2981 : forall X1 X2:term, auto___type_20 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2982 : auto___type_20 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2983 : auto___type_20 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2984 : forall X1 X2:term, auto___type_20 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2985 : forall X1 X2:term, auto___type_20 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2986 : forall X1 X2:term, auto___type_20 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2987 : forall X1:term, auto___type_20 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2988 : auto___type_20 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2989 : forall X1 X2:term, auto___type_20 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2990 : auto___type_20 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2991 : auto___type_20 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2992 : auto___type_20 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2993 : forall X1 X2:term, auto___type_20 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2994 : forall X1:term, auto___type_20 X1 -> auto___type_21 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_20_p__type_21 1.
  intro X. case X.
   intro H. elim (rem_2982  H).
   intro H. elim (rem_2974  H).
  intros X1 X2;  exact (rem_2964 epsilon_m__type_20_p__type_21 X1 X2).
  intros X1 X2. intro H. elim (rem_2972 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2985 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2986 X1 X2 H).
   intro H. elim (rem_2990  H).
  intros X1 X2. intro H. elim (rem_2993 X1 X2 H).
   intro H. elim (rem_2991  H).
  intros X1 X2;  exact (rem_2971 epsilon_m__type_20_p__type_21 X1 X2).
  intros X1 X2. intro H. elim (rem_2975 X1 X2 H).
  intros X1 X2;  exact (rem_2956 epsilon_m__type_20_p__type_21 X1 X2).
  intros X1 X2. intro H. elim (rem_2984 X1 X2 H).
  intros X1. intro H. elim (rem_2978 X1 H).
  intros X1 X2. intro H. elim (rem_2981 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2980 X1 X2 H).
   intro H. elim (rem_2983  H).
   intro H. elim (rem_2979  H).
  intros X1 X2. intro H. elim (rem_2977 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2976 X1 X2 H).
  intros X1. intro H. elim (rem_2987 X1 H).
   intro H. elim (rem_2992  H).
  intros X1 X2. intro H. elim (rem_2989 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2973 X1 X2 H).
   intro H. elim (rem_2988  H).
Qed.

Remark rem_2995 : (forall X:term, auto___def_88 X -> auto___def_96 X)
    -> forall X1:term, auto___type_20 X1 -> auto___type_21 X1. (* Cut history. *)
Proof.  intros epsilon_m__def_88_p__def_96. exact (rem_2994).
Defined.

Remark rem_2996 : (forall X:term, auto___def_88 X -> auto___def_96 X)
    -> forall X1 X2:term, auto___type_20 X1 -> auto___def_90 X2 -> auto___type_21 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_88_p__def_96. intros X1 X2.
  cut (auto___type_20 X1 -> auto___type_21 X1). tauto. exact (rem_2995 epsilon_m__def_88_p__def_96 X1).
Defined.

Remark rem_2997 : (forall X:term, auto___def_91 X -> auto___def_99 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2998 : (forall X:term, auto___def_91 X -> auto___def_99 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_91_p__def_99. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_2997 epsilon_m__def_91_p__def_99 X1);  assumption.
  tauto.
Defined.

Remark rem_2999 : (forall X:term, auto___def_91 X -> auto___def_99 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto___def_99 (nonceb_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_91_p__def_99. intros X1 X2. intros A1.
  case (rem_2998 epsilon_m__def_91_p__def_99 X1 A1). clear  epsilon_m__def_91_p__def_99 A1. intros. apply trans___def_99_nonceb_current_1;  tauto.
 clear  epsilon_m__def_91_p__def_99 A1. tauto.
Defined.

Remark rem_3000 : forall X1 X2:term, auto___def_91 (nonceb_current X1 X2) -> or_1
    (auto_knows_current X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_3001 : (forall X:term, auto___def_91 X -> auto___def_99 X)
    -> forall X1 X2:term, auto___def_91 (nonceb_current X1 X2) -> auto___def_99 (nonceb_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_91_p__def_99. intros X1 X2. intro H. intros.
  elim (rem_3000 X1 X2 H);  intros.
  apply (rem_2999 epsilon_m__def_91_p__def_99 X1 X2);  tauto.
Defined.

Remark rem_3002 : forall X1 X2:term, auto___def_91 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3003 : forall X1 X2:term, auto___def_91 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3004 : auto___def_91 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3005 : forall X1 X2:term, auto___def_91 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3006 : forall X1 X2:term, auto___def_91 (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3007 : forall X1 X2:term, auto___def_91 (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3008 : forall X1:term, auto___def_91 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3009 : auto___def_91 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3010 : forall X1 X2:term, auto___def_91 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3011 : forall X1 X2:term, auto___def_91 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3012 : auto___def_91 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3013 : auto___def_91 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3014 : forall X1 X2:term, auto___def_91 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3015 : forall X1 X2:term, auto___def_91 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3016 : forall X1 X2:term, auto___def_91 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3017 : forall X1 X2:term, auto___def_91 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3018 : forall X1:term, auto___def_91 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3019 : auto___def_91 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3020 : forall X1 X2:term, auto___def_91 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3021 : auto___def_91 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3022 : auto___def_91 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3023 : auto___def_91 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3024 : forall X1 X2:term, auto___def_91 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3025 : forall X1 X2:term, auto___def_91 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3026 : forall X1:term, auto___def_91 X1 -> auto___def_99 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_91_p__def_99 1.
  intro X. case X.
   intro H. elim (rem_3012  H).
   intro H. elim (rem_3004  H).
  intros X1 X2. intro H. elim (rem_3017 X1 X2 H).
  intros X1 X2. intro H. elim (rem_3002 X1 X2 H).
  intros X1 X2. intro H. elim (rem_3015 X1 X2 H).
  intros X1 X2. intro H. elim (rem_3016 X1 X2 H).
   intro H. elim (rem_3021  H).
  intros X1 X2. intro H. elim (rem_3025 X1 X2 H).
   intro H. elim (rem_3022  H).
  intros X1 X2. intro H. elim (rem_3024 X1 X2 H).
  intros X1 X2. intro H. elim (rem_3005 X1 X2 H).
  intros X1 X2;  exact (rem_3001 epsilon_m__def_91_p__def_99 X1 X2).
  intros X1 X2. intro H. elim (rem_3014 X1 X2 H).
  intros X1. intro H. elim (rem_3008 X1 H).
  intros X1 X2. intro H. elim (rem_3011 X1 X2 H).
  intros X1 X2. intro H. elim (rem_3010 X1 X2 H).
   intro H. elim (rem_3013  H).
   intro H. elim (rem_3009  H).
  intros X1 X2. intro H. elim (rem_3007 X1 X2 H).
  intros X1 X2. intro H. elim (rem_3006 X1 X2 H).
  intros X1. intro H. elim (rem_3018 X1 H).
   intro H. elim (rem_3023  H).
  intros X1 X2. intro H. elim (rem_3020 X1 X2 H).
  intros X1 X2. intro H. elim (rem_3003 X1 X2 H).
   intro H. elim (rem_3019  H).
Qed.

Remark rem_3027 : (forall X:term, auto___def_90 X -> auto___def_98 X)
    -> forall X1:term, auto___def_91 X1 -> auto___def_99 X1. (* Cut history. *)
Proof.  intros epsilon_m__def_90_p__def_98. exact (rem_3026).
Defined.

Remark rem_3028 : (forall X:term, auto___def_90 X -> auto___def_98 X)
    -> forall X1 X2:term, auto___def_91 X1 -> auto___def_92 X2 -> auto___def_99 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_90_p__def_98. intros X1 X2.
  cut (auto___def_91 X1 -> auto___def_99 X1). tauto. exact (rem_3027 epsilon_m__def_90_p__def_98 X1).
Defined.

Remark rem_3029 : (forall X:term, auto___def_92 X -> auto___def_100 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_92_p__def_100.  tauto.
Defined.

Remark rem_3030 : (forall X:term, auto___def_92 X -> auto___def_100 X)
    -> auto___def_100 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_92_p__def_100.  case (rem_3029 epsilon_m__def_92_p__def_100). clear  epsilon_m__def_92_p__def_100. intros. apply trans___def_100_nil_1;  tauto.
 clear  epsilon_m__def_92_p__def_100. tauto.
Defined.

Remark rem_3031 : auto___def_92 nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_3032 : (forall X:term, auto___def_92 X -> auto___def_100 X)
    -> auto___def_92 nil -> auto___def_100 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_92_p__def_100. intro H. intros.
  elim (rem_3031 H);  intros.
  apply (rem_3030 epsilon_m__def_92_p__def_100);  tauto.
Defined.

Remark rem_3033 : forall X1 X2:term, auto___def_92 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3034 : forall X1 X2:term, auto___def_92 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3035 : forall X1 X2:term, auto___def_92 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3036 : auto___def_92 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3037 : forall X1 X2:term, auto___def_92 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3038 : forall X1 X2:term, auto___def_92 (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3039 : forall X1 X2:term, auto___def_92 (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3040 : forall X1:term, auto___def_92 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3041 : auto___def_92 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3042 : forall X1 X2:term, auto___def_92 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3043 : forall X1 X2:term, auto___def_92 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3044 : auto___def_92 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3045 : auto___def_92 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3046 : forall X1 X2:term, auto___def_92 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3047 : forall X1 X2:term, auto___def_92 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3048 : forall X1 X2:term, auto___def_92 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3049 : forall X1 X2:term, auto___def_92 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3050 : forall X1:term, auto___def_92 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3051 : auto___def_92 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3052 : forall X1 X2:term, auto___def_92 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3053 : auto___def_92 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3054 : auto___def_92 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3055 : forall X1 X2:term, auto___def_92 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3056 : forall X1 X2:term, auto___def_92 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3057 : forall X2:term, auto___def_92 X2 -> auto___def_100 X2. (* Induct. *)
Proof.
  fix epsilon_m__def_92_p__def_100 1.
  intro X. case X.
   intro H. elim (rem_3044  H).
   intro H. elim (rem_3036  H).
  intros X1 X2. intro H. elim (rem_3049 X1 X2 H).
  intros X1 X2. intro H. elim (rem_3033 X1 X2 H).
  intros X1 X2. intro H. elim (rem_3047 X1 X2 H).
  intros X1 X2. intro H. elim (rem_3048 X1 X2 H).
   intro H. elim (rem_3053  H).
  intros X1 X2. intro H. elim (rem_3056 X1 X2 H).
  exact (rem_3032 epsilon_m__def_92_p__def_100 ).
  intros X1 X2. intro H. elim (rem_3055 X1 X2 H).
  intros X1 X2. intro H. elim (rem_3037 X1 X2 H).
  intros X1 X2. intro H. elim (rem_3034 X1 X2 H).
  intros X1 X2. intro H. elim (rem_3046 X1 X2 H).
  intros X1. intro H. elim (rem_3040 X1 H).
  intros X1 X2. intro H. elim (rem_3043 X1 X2 H).
  intros X1 X2. intro H. elim (rem_3042 X1 X2 H).
   intro H. elim (rem_3045  H).
   intro H. elim (rem_3041  H).
  intros X1 X2. intro H. elim (rem_3039 X1 X2 H).
  intros X1 X2. intro H. elim (rem_3038 X1 X2 H).
  intros X1. intro H. elim (rem_3050 X1 H).
   intro H. elim (rem_3054  H).
  intros X1 X2. intro H. elim (rem_3052 X1 X2 H).
  intros X1 X2. intro H. elim (rem_3035 X1 X2 H).
   intro H. elim (rem_3051  H).
Qed.

Remark rem_3058 : (forall X:term, auto___def_90 X -> auto___def_98 X)
    -> forall X2:term, auto___def_92 X2 -> auto___def_100 X2. (* Cut history. *)
Proof.  intros epsilon_m__def_90_p__def_98. exact (rem_3057).
Defined.

Remark rem_3059 : (forall X:term, auto___def_90 X -> auto___def_98 X)
    -> forall X1 X2:term, auto___def_91 X1 -> auto___def_92 X2 -> auto___def_100 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_90_p__def_98. intros X1 X2.
  cut (auto___def_92 X2 -> auto___def_100 X2). tauto. exact (rem_3058 epsilon_m__def_90_p__def_98 X2).
Defined.

Remark rem_3060 : (forall X:term, auto___def_90 X -> auto___def_98 X)
    -> forall X1 X2:term, auto___def_91 X1 -> auto___def_92 X2 -> (auto___def_99 X1 /\ auto___def_100 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_90_p__def_98. intros X1 X2. intros A1 A2.
  cut (auto___def_99 X1). 2:apply (rem_3028 epsilon_m__def_90_p__def_98 X1 X2);  assumption.
  cut (auto___def_100 X2). 2:apply (rem_3059 epsilon_m__def_90_p__def_98 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_3061 : (forall X:term, auto___def_90 X -> auto___def_98 X)
    -> forall X1 X2:term, auto___def_91 X1 -> auto___def_92 X2 -> auto___def_98 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_90_p__def_98. intros X1 X2. intros A1 A2.
  case (rem_3060 epsilon_m__def_90_p__def_98 X1 X2 A1 A2). clear  epsilon_m__def_90_p__def_98 A1 A2. intros. apply trans___def_98_cons_1;  tauto.
 clear  epsilon_m__def_90_p__def_98 A1 A2. tauto.
Defined.

Remark rem_3062 : (forall X:term, auto___def_90 X -> auto___def_98 X)
    -> forall X1 X2:term, auto___def_90 (cons X1 X2) -> auto___def_98 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_90_p__def_98. intros X1 X2. intro H. intros.
  elim (rem_2825 X1 X2 H);  intros.
  apply (rem_3061 epsilon_m__def_90_p__def_98 X1 X2);  tauto.
Defined.

Remark rem_3063 : forall X1 X2:term, auto___def_90 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3064 : forall X1 X2:term, auto___def_90 (nonceb_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3065 : forall X1 X2:term, auto___def_90 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3066 : auto___def_90 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3067 : forall X1 X2:term, auto___def_90 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3068 : forall X1 X2:term, auto___def_90 (r_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3069 : forall X1 X2:term, auto___def_90 (r_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3070 : forall X1:term, auto___def_90 (p X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3071 : auto___def_90 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3072 : forall X1 X2:term, auto___def_90 (passwd_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3073 : forall X1 X2:term, auto___def_90 (passwd_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3074 : auto___def_90 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3075 : auto___def_90 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3076 : forall X1 X2:term, auto___def_90 (nonceb_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3077 : forall X1 X2:term, auto___def_90 (dec X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3078 : forall X1 X2:term, auto___def_90 (enc X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3079 : forall X1:term, auto___def_90 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3080 : auto___def_90 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3081 : forall X1 X2:term, auto___def_90 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3082 : auto___def_90 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3083 : auto___def_90 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3084 : auto___def_90 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3085 : forall X1 X2:term, auto___def_90 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3086 : forall X1 X2:term, auto___def_90 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_3087 : forall X2:term, auto___def_90 X2 -> auto___def_98 X2. (* Induct. *)
Proof.
  fix epsilon_m__def_90_p__def_98 1.
  intro X. case X.
   intro H. elim (rem_3074  H).
   intro H. elim (rem_3066  H).
  intros X1 X2;  exact (rem_3062 epsilon_m__def_90_p__def_98 X1 X2).
  intros X1 X2. intro H. elim (rem_3063 X1 X2 H).
  intros X1 X2. intro H. elim (rem_3077 X1 X2 H).
  intros X1 X2. intro H. elim (rem_3078 X1 X2 H).
   intro H. elim (rem_3082  H).
  intros X1 X2. intro H. elim (rem_3086 X1 X2 H).
   intro H. elim (rem_3083  H).
  intros X1 X2. intro H. elim (rem_3085 X1 X2 H).
  intros X1 X2. intro H. elim (rem_3067 X1 X2 H).
  intros X1 X2. intro H. elim (rem_3064 X1 X2 H).
  intros X1 X2. intro H. elim (rem_3076 X1 X2 H).
  intros X1. intro H. elim (rem_3070 X1 H).
  intros X1 X2. intro H. elim (rem_3073 X1 X2 H).
  intros X1 X2. intro H. elim (rem_3072 X1 X2 H).
   intro H. elim (rem_3075  H).
   intro H. elim (rem_3071  H).
  intros X1 X2. intro H. elim (rem_3069 X1 X2 H).
  intros X1 X2. intro H. elim (rem_3068 X1 X2 H).
  intros X1. intro H. elim (rem_3079 X1 H).
   intro H. elim (rem_3084  H).
  intros X1 X2. intro H. elim (rem_3081 X1 X2 H).
  intros X1 X2. intro H. elim (rem_3065 X1 X2 H).
   intro H. elim (rem_3080  H).
Qed.

Remark rem_3088 : (forall X:term, auto___def_88 X -> auto___def_96 X)
    -> forall X2:term, auto___def_90 X2 -> auto___def_98 X2. (* Cut history. *)
Proof.  intros epsilon_m__def_88_p__def_96. exact (rem_3087).
Defined.

Remark rem_3089 : (forall X:term, auto___def_88 X -> auto___def_96 X)
    -> forall X1 X2:term, auto___type_20 X1 -> auto___def_90 X2 -> auto___def_98 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_88_p__def_96. intros X1 X2.
  cut (auto___def_90 X2 -> auto___def_98 X2). tauto. exact (rem_3088 epsilon_m__def_88_p__def_96 X2).
Defined.

Remark rem_3090 : (forall X:term, auto___def_88 X -> auto___def_96 X)
    -> forall X1 X2:term, auto___type_20 X1 -> auto___def_90 X2 -> (auto___type_21 X1 /\ auto___def_98 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_88_p__def_96. intros X1 X2. intros A1 A2.
  cut (auto___type_21 X1). 2:apply (rem_2996 epsilon_m__def_88_p__def_96 X1 X2);  assumption.
  cut (auto___def_98 X2). 2:apply (rem_3089 epsilon_m__def_88_p__def_96 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_3091 : (forall X:term, auto___def_88 X -> auto___def_96 X)
    -> forall X1 X2:term, auto___type_20 X1 -> auto___def_90 X2 -> auto___def_96 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_88_p__def_96. intros X1 X2. intros A1 A2.
  case (rem_3090 epsilon_m__def_88_p__def_96 X1 X2 A1 A2). clear  epsilon_m__def_88_p__def_96 A1 A2. intros. apply trans___def_96_cons_1;  tauto.
 clear  epsilon_m__def_88_p__def_96 A1 A2. tauto.
Defined.

Remark rem_3092 : (forall X:term, auto___def_88 X -> auto___def_96 X)
    -> forall X1 X2:term, auto___def_88 (cons X1 X2) -> auto___def_96 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_88_p__def_96. intros X1 X2. intro H. intros.
  elim (rem_2641 X1 X2 H);  intros.
  apply (rem_3091 epsilon_m__def_88_p__def_96 X1 X2);  tauto.
Defined.

Remark rem_3093 : forall X2:term, auto___def_88 X2 -> auto___def_96 X2. (* Induct. *)
Proof.
  fix epsilon_m__def_88_p__def_96 1.
  intro X. case X.
   intro H. elim (rem_2654  H).
   intro H. elim (rem_2646  H).
  intros X1 X2;  exact (rem_3092 epsilon_m__def_88_p__def_96 X1 X2).
  intros X1 X2. intro H. elim (rem_2643 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2657 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2658 X1 X2 H).
   intro H. elim (rem_2662  H).
  intros X1 X2. intro H. elim (rem_2666 X1 X2 H).
   intro H. elim (rem_2663  H).
  intros X1 X2. intro H. elim (rem_2665 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2647 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2644 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2656 X1 X2 H).
  intros X1. intro H. elim (rem_2650 X1 H).
  intros X1 X2. intro H. elim (rem_2653 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2652 X1 X2 H).
   intro H. elim (rem_2655  H).
   intro H. elim (rem_2651  H).
  intros X1 X2. intro H. elim (rem_2649 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2648 X1 X2 H).
  intros X1. intro H. elim (rem_2659 X1 H).
   intro H. elim (rem_2664  H).
  intros X1 X2. intro H. elim (rem_2661 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2645 X1 X2 H).
   intro H. elim (rem_2660  H).
Qed.

Remark rem_3094 : forall X1 X2 X3 X4:term, auto___def_88 X2 -> auto___def_89 (key sym (r_current X3 X1)) -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_96 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_88 X2 -> auto___def_96 X2). tauto. exact (rem_3093 X2).
Qed.

Remark rem_3095 : forall X1 X2 X3 X4:term, auto___def_88 X2 -> auto___def_89 (key sym (r_current X3 X1)) -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto_knows_current X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X3 -> auto_knows_current X3). tauto. exact (rem_2947 X3).
Qed.

Remark rem_3096 : forall X1 X2 X3 X4:term, auto___def_88 X2 -> auto___def_89 (key sym (r_current X3 X1)) -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> (auto___def_96 X2 /\ auto_knows_current X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4.
  cut (auto___def_96 X2). 2:apply (rem_3094 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X3). 2:apply (rem_3095 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_3097 : forall X1 X2 X3 X4:term, auto___def_88 X2 -> auto___def_89 (key sym (r_current X3 X1)) -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4.
  case (rem_3096 X1 X2 X3 X4 A1 A2 A3 A4). clear  A1 A2 A3 A4. intros. apply trans___def_87_2;  tauto.
 clear  A1 A2 A3 A4. tauto.
Qed.

Remark rem_3098 : forall X1 X2 X3 X4:term, auto___def_24 X2 -> auto___type_4 (r_current X3 X1) -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_526 X3 X1 H);  intros.
Qed.

Remark rem_3099 : forall X1 X2 X3 X4:term, auto___def_24 X2 -> auto___def_26 sym -> auto___type_4 (r_current X3 X1) -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_24 X2 -> auto___type_4 (r_current X3 X1) -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3). tauto.
  exact (rem_3098 X1 X2 X3 X4).
Qed.

Remark rem_3100 : forall X1 X2 X3 X4:term, auto___def_26 sym -> auto___type_4 (r_current X3 X1) -> auto___def_24 X2 -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_24 X2 -> auto___def_26 sym -> auto___type_4 (r_current X3 X1) -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3). tauto. exact (rem_3099 X1 X2 X3 X4).
Qed.

Remark rem_3101 : forall X1 X2 X3 X4:term, auto___def_24 X2 -> auto___def_25 (key sym (r_current X3 X1)) -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_1444 sym (r_current X3 X1) H);  intros.
  apply (rem_3100 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_3102 : forall X1 X2 X3 X4:term, auto___type_7 X2 -> auto___type_8 (r_current X3 X1) -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_463 X3 X1 H);  intros.
Qed.

Remark rem_3103 : forall X1 X2 X3 X4:term, auto___def_45 sym -> auto___type_7 X2 -> auto___type_8 (r_current X3 X1) -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_7 X2 -> auto___type_8 (r_current X3 X1) -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3). tauto.
  exact (rem_3102 X1 X2 X3 X4).
Qed.

Remark rem_3104 : forall X1 X2 X3 X4:term, auto___def_45 sym -> auto___type_8 (r_current X3 X1) -> auto___type_7 X2 -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_45 sym -> auto___type_7 X2 -> auto___type_8 (r_current X3 X1) -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3). tauto. exact (rem_3103 X1 X2 X3 X4).
Qed.

Remark rem_3105 : forall X1 X2 X3 X4:term, auto___def_44 (key sym (r_current X3 X1)) -> auto___type_7 X2 -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1450 sym (r_current X3 X1) H);  intros.
  apply (rem_3104 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_3106 : forall X1 X2 X3 X4:term, auto___type_7 X2 -> auto___def_44 (key sym (r_current X3 X1)) -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_44 (key sym (r_current X3 X1)) -> auto___type_7 X2 -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3). tauto. exact (rem_3105 X1 X2 X3 X4).
Qed.

Remark rem_3107 : forall X2:term, auto___def_84 X2 -> auto___def_84 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_3108 : forall X1 X2 X3 X4:term, auto___def_84 X2 -> auto___def_85 (key sym (r_current X3 X1)) -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_84 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_84 X2 -> auto___def_84 X2). tauto. exact (rem_3107 X2).
Qed.

Remark rem_3109 : forall X1 X2 X3 X4:term, auto___def_84 X2 -> auto___def_85 (key sym (r_current X3 X1)) -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto_knows_current X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X3 -> auto_knows_current X3). tauto. exact (rem_2947 X3).
Qed.

Remark rem_3110 : forall X1 X2 X3 X4:term, auto___def_84 X2 -> auto___def_85 (key sym (r_current X3 X1)) -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> (auto___def_84 X2 /\ auto_knows_current X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4.
  cut (auto___def_84 X2). 2:apply (rem_3108 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X3). 2:apply (rem_3109 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_3111 : forall X1 X2 X3 X4:term, auto___def_84 X2 -> auto___def_85 (key sym (r_current X3 X1)) -> auto_knows_current X3 -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4.
  case (rem_3110 X1 X2 X3 X4 A1 A2 A3 A4). clear  A1 A2 A3 A4. intros. apply trans___def_87_3;  tauto.
 clear  A1 A2 A3 A4. tauto.
Qed.

Remark rem_3112 : forall X1 X2 X3 X4:term, auto_knows_current X3 -> auto_knows_current (crypt X2 (key sym (r_current X3 X1))) -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_987 X2 (key sym (r_current X3 X1)) H);  intros.
  apply (rem_2903 X1 X2 X3 X4);  tauto.
  apply (rem_2907 X1 X2 X3 X4);  tauto.
  apply (rem_2908 X1 X2 X3 X4);  tauto.
  apply (rem_2944 X1 X2 X3 X4);  tauto.
  apply (rem_2951 X1 X2 X3 X4);  tauto.
  apply (rem_3097 X1 X2 X3 X4);  tauto.
  apply (rem_3101 X1 X2 X3 X4);  tauto.
  apply (rem_3106 X1 X2 X3 X4);  tauto.
  apply (rem_3111 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_3113 : forall X1 X2 X3 X4:term, auto_knows_current X3 -> auto_knows_current (crypt X2 (key sym (r_current X3 X1))) -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto_knows_current nil -> auto___def_87 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X3 -> auto_knows_current (crypt X2 (key sym (r_current X3 X1))) -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto___def_87 X1 X2 X3). tauto.
  exact (rem_3112 X1 X2 X3 X4).
Qed.

Remark rem_3114 : forall X1 X2 X3 X4:term, auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto_knows_current nil -> auto_knows_current X3 -> auto_knows_current (crypt X2 (key sym (r_current X3 X1))) -> auto___def_87 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current X3 -> auto_knows_current (crypt X2 (key sym (r_current X3 X1))) -> auto_knows_current (enc X4 (passwd_current X3 X1)) -> auto_knows_current nil -> auto___def_87 X1 X2 X3). tauto. exact (rem_3113 X1 X2 X3 X4).
Qed.

Remark rem_3115 : forall X1 X2 X3 X4:term, auto_knows_current X3 -> auto_knows_current (cons (enc X4 (passwd_current X3 X1)) nil) -> auto_knows_current (crypt X2 (key sym (r_current X3 X1))) -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_1034 (enc X4 (passwd_current X3 X1)) nil H);  intros.
  apply (rem_3114 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_3116 : forall X1 X2 X3 X4:term, auto_knows_current (cons X3 (cons (enc X4 (passwd_current X3 X1)) nil)) -> auto_knows_current (crypt X2 (key sym (r_current X3 X1))) -> auto___def_87 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1034 X3 (cons (enc X4 (passwd_current X3 X1)) nil) H);  intros.
  apply (rem_3115 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_3117 : forall X1 X2 X3 X4:term, auto_knows_current (crypt X2 (key sym (r_current X3 X1))) -> auto_knows_current (cons X3 (cons (enc X4 (passwd_current X3 X1)) nil)) -> auto___def_87 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current (cons X3 (cons (enc X4 (passwd_current X3 X1)) nil)) -> auto_knows_current (crypt X2 (key sym (r_current X3 X1))) -> auto___def_87 X1 X2 X3). tauto. exact (rem_3116 X1 X2 X3 X4).
Qed.

Remark rem_3118 : (forall X:term, auto___def_62 X -> auto___def_4 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_62_p__def_4.  tauto.
Defined.

Remark rem_3119 : (forall X:term, auto___def_62 X -> auto___def_4 X)
    -> auto___def_4 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_62_p__def_4.  case (rem_3118 epsilon_m__def_62_p__def_4). clear  epsilon_m__def_62_p__def_4. intros. apply trans___def_4_i_1;  tauto.
 clear  epsilon_m__def_62_p__def_4. tauto.
Defined.

Remark rem_3120 : (forall X:term, auto___def_62 X -> auto___def_4 X)
    -> auto___def_62 i -> auto___def_4 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_62_p__def_4. intro H. intros.
  elim (rem_312 H);  intros.
  apply (rem_3119 epsilon_m__def_62_p__def_4);  tauto.
Defined.

Remark rem_3121 : forall X1:term, auto___def_62 X1 -> auto___def_4 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_62_p__def_4 1.
  intro X. case X.
   intro H. elim (rem_325  H).
   intro H. elim (rem_317  H).
  intros X1 X2. intro H. elim (rem_330 X1 X2 H).
  intros X1 X2. intro H. elim (rem_314 X1 X2 H).
  intros X1 X2. intro H. elim (rem_328 X1 X2 H).
  intros X1 X2. intro H. elim (rem_329 X1 X2 H).
  exact (rem_3120 epsilon_m__def_62_p__def_4 ).
  intros X1 X2. intro H. elim (rem_337 X1 X2 H).
   intro H. elim (rem_334  H).
  intros X1 X2. intro H. elim (rem_336 X1 X2 H).
  intros X1 X2. intro H. elim (rem_318 X1 X2 H).
  intros X1 X2. intro H. elim (rem_315 X1 X2 H).
  intros X1 X2. intro H. elim (rem_327 X1 X2 H).
  intros X1. intro H. elim (rem_321 X1 H).
  intros X1 X2. intro H. elim (rem_324 X1 X2 H).
  intros X1 X2. intro H. elim (rem_323 X1 X2 H).
   intro H. elim (rem_326  H).
   intro H. elim (rem_322  H).
  intros X1 X2. intro H. elim (rem_320 X1 X2 H).
  intros X1 X2. intro H. elim (rem_319 X1 X2 H).
  intros X1. intro H. elim (rem_331 X1 H).
   intro H. elim (rem_335  H).
  intros X1 X2. intro H. elim (rem_333 X1 X2 H).
  intros X1 X2. intro H. elim (rem_316 X1 X2 H).
   intro H. elim (rem_332  H).
Qed.

Remark rem_3122 : forall X1:term, auto___def_61 pub -> auto___def_62 X1 -> auto___def_4 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1.
  cut (auto___def_62 X1 -> auto___def_4 X1). tauto. exact (rem_3121 X1).
Qed.

Remark rem_3123 : (forall X:term, auto_agent X -> auto___def_4 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p__def_4.  tauto.
Defined.

Remark rem_3124 : (forall X:term, auto_agent X -> auto___def_4 X)
    -> auto___def_4 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__def_4.  case (rem_3123 epsilon_magent_p__def_4). clear  epsilon_magent_p__def_4. intros. apply trans___def_4_bob_1;  tauto.
 clear  epsilon_magent_p__def_4. tauto.
Defined.

Remark rem_3125 : (forall X:term, auto_agent X -> auto___def_4 X)
    -> auto_agent bob -> auto___def_4 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__def_4. intro H. intros.
  elim (rem_1083 H);  intros.
  apply (rem_3124 epsilon_magent_p__def_4);  tauto.
Defined.

Remark rem_3126 : (forall X:term, auto_agent X -> auto___def_4 X)
    -> auto___def_4 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__def_4.  case (rem_3123 epsilon_magent_p__def_4). clear  epsilon_magent_p__def_4. intros. apply trans___def_4_alice_1;  tauto.
 clear  epsilon_magent_p__def_4. tauto.
Defined.

Re