(* [sigd] Signature definition. *)

Inductive term : Set :=
    alice : term
  | bob : term
  | cons : term -> term -> term
  | crypt : term -> term -> term
  | i : term
  | key : term -> term -> term
  | nil : term
  | noncea_current : term -> term -> term
  | noncea_old : term -> term -> term
  | nonceb_current : term -> term -> term -> term
  | nonceb_old : term -> term -> term -> term
  | prv : term
  | pub : term
  | s : term -> term
  | server : term
  | session_current : term -> term -> term -> term
  | session_old : term -> term -> term -> term
  | sym : term
.

(* [modd] Model definition. *)

Inductive auto_alice_key_current : term -> term -> Prop :=
    trans_alice_key_current_1 : forall X1 X2:term, auto__q2 X1 -> auto__q4 X2 -> auto_alice_key_current X1 X2
  | trans_alice_key_current_2 : forall X1 X2:term, auto__q4 X1 -> auto__q3 X2 -> auto_alice_key_current X1 X2
  | trans_alice_key_current_3 : forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto_alice_key_current X1 X2
  | trans_alice_key_current_4 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_alice_key_current X1 X2
  | trans_alice_key_current_5 : forall X1 X2:term, auto__q1 X1 -> auto__q4 X2 -> auto_alice_key_current X1 X2
  | trans_alice_key_current_6 : forall X1 X2:term, auto__q3 X1 -> auto__q4 X2 -> auto_alice_key_current X1 X2
  | trans_alice_key_current_7 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto_alice_key_current X1 X2
  | trans_alice_key_current_8 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto_alice_key_current X1 X2
  | trans_alice_key_current_9 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto_alice_key_current X1 X2
  | trans_alice_key_current_10 : forall X1 X2:term, auto__q4 X1 -> auto__q4 X2 -> auto_alice_key_current X1 X2
  | trans_alice_key_current_11 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto_alice_key_current X1 X2
  | trans_alice_key_current_12 : forall X1 X2:term, auto__q4 X1 -> auto__q1 X2 -> auto_alice_key_current X1 X2
  | trans_alice_key_current_13 : forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto_alice_key_current X1 X2
  | trans_alice_key_current_14 : forall X1 X2:term, auto__q4 X1 -> auto__q2 X2 -> auto_alice_key_current X1 X2
with auto__q4 : term -> Prop :=
    trans__q4_key_1 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto__q4 (key X1 X2)
  | trans__q4_key_2 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto__q4 (key X1 X2)
  | trans__q4_s_1 : forall X1:term, auto__q4 X1 -> auto__q4 (s X1)
  | trans__q4_s_2 : forall X1:term, auto__q3 X1 -> auto__q4 (s X1)
  | trans__q4_nonceb_current_1 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q4 (nonceb_current X1 X2 X3)
  | trans__q4_nonceb_current_2 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto__q4 (nonceb_current X1 X2 X3)
  | trans__q4_nonceb_current_3 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q4 (nonceb_current X1 X2 X3)
  | trans__q4_nonceb_current_4 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto__q4 (nonceb_current X1 X2 X3)
  | trans__q4_nonceb_current_5 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto__q4 (nonceb_current X1 X2 X3)
  | trans__q4_nonceb_current_6 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q4 (nonceb_current X1 X2 X3)
  | trans__q4_nonceb_current_7 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 (nonceb_current X1 X2 X3)
  | trans__q4_nonceb_current_8 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q4 (nonceb_current X1 X2 X3)
  | trans__q4_nonceb_current_9 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto__q4 (nonceb_current X1 X2 X3)
  | trans__q4_nonceb_current_10 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q4 (nonceb_current X1 X2 X3)
  | trans__q4_nonceb_current_11 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q4 (nonceb_current X1 X2 X3)
  | trans__q4_nonceb_current_12 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto__q4 (nonceb_current X1 X2 X3)
  | trans__q4_nonceb_current_13 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto__q4 (nonceb_current X1 X2 X3)
  | trans__q4_nonceb_current_14 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q4 (nonceb_current X1 X2 X3)
  | trans__q4_nonceb_current_15 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q4 (nonceb_current X1 X2 X3)
  | trans__q4_nonceb_current_16 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q4 (nonceb_current X1 X2 X3)
  | trans__q4_nonceb_current_17 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q4 (nonceb_current X1 X2 X3)
  | trans__q4_nonceb_current_18 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 (nonceb_current X1 X2 X3)
  | trans__q4_crypt_1 : forall X1 X2:term, auto__q2 X1 -> auto__q4 X2 -> auto__q4 (crypt X1 X2)
  | trans__q4_crypt_2 : forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto__q4 (crypt X1 X2)
  | trans__q4_crypt_3 : forall X1 X2:term, auto__q3 X1 -> auto__q4 X2 -> auto__q4 (crypt X1 X2)
  | trans__q4_crypt_4 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto__q4 (crypt X1 X2)
  | trans__q4_crypt_5 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q4 (crypt X1 X2)
  | trans__q4_crypt_6 : forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto__q4 (crypt X1 X2)
  | trans__q4_cons_1 : forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto__q4 (cons X1 X2)
  | trans__q4_cons_2 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q4 (cons X1 X2)
  | trans__q4_cons_3 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto__q4 (cons X1 X2)
  | trans__q4_cons_4 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q4 (cons X1 X2)
  | trans__q4_cons_5 : forall X1 X2:term, auto__q4 X1 -> auto__q1 X2 -> auto__q4 (cons X1 X2)
  | trans__q4_cons_6 : forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto__q4 (cons X1 X2)
  | trans__q4_noncea_current_1 : forall X1 X2:term, auto__q2 X1 -> auto__q4 X2 -> auto__q4 (noncea_current X1 X2)
  | trans__q4_noncea_current_2 : forall X1 X2:term, auto__q4 X1 -> auto__q3 X2 -> auto__q4 (noncea_current X1 X2)
  | trans__q4_noncea_current_3 : forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto__q4 (noncea_current X1 X2)
  | trans__q4_noncea_current_4 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q4 (noncea_current X1 X2)
  | trans__q4_noncea_current_5 : forall X1 X2:term, auto__q1 X1 -> auto__q4 X2 -> auto__q4 (noncea_current X1 X2)
  | trans__q4_noncea_current_6 : forall X1 X2:term, auto__q3 X1 -> auto__q4 X2 -> auto__q4 (noncea_current X1 X2)
  | trans__q4_noncea_current_7 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto__q4 (noncea_current X1 X2)
  | trans__q4_noncea_current_8 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto__q4 (noncea_current X1 X2)
  | trans__q4_noncea_current_9 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q4 (noncea_current X1 X2)
  | trans__q4_noncea_current_10 : forall X1 X2:term, auto__q4 X1 -> auto__q4 X2 -> auto__q4 (noncea_current X1 X2)
  | trans__q4_noncea_current_11 : forall X1 X2:term, auto__q4 X1 -> auto__q1 X2 -> auto__q4 (noncea_current X1 X2)
  | trans__q4_noncea_current_12 : forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto__q4 (noncea_current X1 X2)
  | trans__q4_noncea_current_13 : forall X1 X2:term, auto__q4 X1 -> auto__q2 X2 -> auto__q4 (noncea_current X1 X2)
  | trans__q4_session_current_1 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_2 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_4 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_5 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_6 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_7 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_8 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_9 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_10 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_11 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_12 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_13 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_14 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_15 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_16 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_17 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_18 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_19 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_20 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_21 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_22 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_23 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_24 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_25 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_26 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_27 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_28 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_29 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_30 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q4 (session_current X1 X2 X3)
  | trans__q4_session_current_31 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto__q4 (session_current X1 X2 X3)
with auto__q2 : term -> Prop :=
    trans__q2_key_1 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 (key X1 X2)
  | trans__q2_key_2 : forall X1 X2:term, auto__q4 X1 -> auto__q1 X2 -> auto__q2 (key X1 X2)
  | trans__q2_s_1 : forall X1:term, auto__q2 X1 -> auto__q2 (s X1)
  | trans__q2_nonceb_current_1 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q2 (nonceb_current X1 X2 X3)
  | trans__q2_nonceb_current_2 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 (nonceb_current X1 X2 X3)
  | trans__q2_nonceb_current_3 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q2 (nonceb_current X1 X2 X3)
  | trans__q2_nonceb_current_4 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto__q2 (nonceb_current X1 X2 X3)
  | trans__q2_crypt_1 : forall X1 X2:term, auto__q4 X1 -> auto__q3 X2 -> auto__q2 (crypt X1 X2)
  | trans__q2_crypt_2 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 (crypt X1 X2)
  | trans__q2_crypt_3 : forall X1 X2:term, auto__q4 X1 -> auto__q4 X2 -> auto__q2 (crypt X1 X2)
  | trans__q2_crypt_4 : forall X1 X2:term, auto__q4 X1 -> auto__q2 X2 -> auto__q2 (crypt X1 X2)
  | trans__q2_noncea_old_1 : forall X1 X2:term, auto__q2 X1 -> auto__q4 X2 -> auto__q2 (noncea_old X1 X2)
  | trans__q2_noncea_old_2 : forall X1 X2:term, auto__q4 X1 -> auto__q3 X2 -> auto__q2 (noncea_old X1 X2)
  | trans__q2_noncea_old_3 : forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 (noncea_old X1 X2)
  | trans__q2_noncea_old_4 : forall X1 X2:term, auto__q1 X1 -> auto__q4 X2 -> auto__q2 (noncea_old X1 X2)
  | trans__q2_noncea_old_5 : forall X1 X2:term, auto__q3 X1 -> auto__q4 X2 -> auto__q2 (noncea_old X1 X2)
  | trans__q2_noncea_old_6 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 (noncea_old X1 X2)
  | trans__q2_noncea_old_7 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 (noncea_old X1 X2)
  | trans__q2_noncea_old_8 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 (noncea_old X1 X2)
  | trans__q2_nonceb_old_1 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q2 (nonceb_old X1 X2 X3)
  | trans__q2_nonceb_old_2 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto__q2 (nonceb_old X1 X2 X3)
  | trans__q2_nonceb_old_3 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto__q2 (nonceb_old X1 X2 X3)
  | trans__q2_nonceb_old_4 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q2 (nonceb_old X1 X2 X3)
  | trans__q2_nonceb_old_5 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 (nonceb_old X1 X2 X3)
  | trans__q2_nonceb_old_6 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q2 (nonceb_old X1 X2 X3)
  | trans__q2_nonceb_old_7 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto__q2 (nonceb_old X1 X2 X3)
  | trans__q2_nonceb_old_8 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto__q2 (nonceb_old X1 X2 X3)
  | trans__q2_nonceb_old_9 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q2 (nonceb_old X1 X2 X3)
  | trans__q2_nonceb_old_10 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto__q2 (nonceb_old X1 X2 X3)
  | trans__q2_nonceb_old_11 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q2 (nonceb_old X1 X2 X3)
  | trans__q2_nonceb_old_12 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q2 (nonceb_old X1 X2 X3)
  | trans__q2_nonceb_old_13 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q2 (nonceb_old X1 X2 X3)
  | trans__q2_nonceb_old_14 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 (nonceb_old X1 X2 X3)
  | trans__q2_nonceb_old_15 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto__q2 (nonceb_old X1 X2 X3)
  | trans__q2_nonceb_old_16 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto__q2 (nonceb_old X1 X2 X3)
  | trans__q2_nonceb_old_17 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto__q2 (nonceb_old X1 X2 X3)
  | trans__q2_nonceb_old_18 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q2 (nonceb_old X1 X2 X3)
  | trans__q2_nonceb_old_19 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q2 (nonceb_old X1 X2 X3)
  | trans__q2_cons_1 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 (cons X1 X2)
  | trans__q2_cons_2 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 (cons X1 X2)
  | trans__q2_cons_3 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 (cons X1 X2)
  | trans__q2_sym_1 : auto__q2 sym
  | trans__q2_noncea_current_1 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 (noncea_current X1 X2)
  | trans__q2_noncea_current_2 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 (noncea_current X1 X2)
  | trans__q2_noncea_current_3 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 (noncea_current X1 X2)
with auto_knows_old : term -> Prop :=
    trans_knows_old_key_1 : forall X1 X2:term, auto__q4 X1 -> auto__q3 X2 -> auto_knows_old (key X1 X2)
  | trans_knows_old_key_2 : forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto_knows_old (key X1 X2)
  | trans_knows_old_key_3 : forall X1 X2:term, auto__q1 X1 -> auto__q4 X2 -> auto_knows_old (key X1 X2)
  | trans_knows_old_key_4 : forall X1 X2:term, auto__q3 X1 -> auto__q4 X2 -> auto_knows_old (key X1 X2)
  | trans_knows_old_key_5 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto_knows_old (key X1 X2)
  | trans_knows_old_key_6 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto_knows_old (key X1 X2)
  | trans_knows_old_key_7 : forall X1 X2:term, auto__q4 X1 -> auto__q4 X2 -> auto_knows_old (key X1 X2)
  | trans_knows_old_key_8 : forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto_knows_old (key X1 X2)
  | trans_knows_old_key_9 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_knows_old (key X1 X2)
  | trans_knows_old_key_10 : forall X1 X2:term, auto__q4 X1 -> auto__q2 X2 -> auto_knows_old (key X1 X2)
  | trans_knows_old_key_11 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto_knows_old (key X1 X2)
  | trans_knows_old_s_1 : forall X1:term, auto__q1 X1 -> auto_knows_old (s X1)
  | trans_knows_old_nil_1 : auto_knows_old nil
  | trans_knows_old_i_1 : auto_knows_old i
  | trans_knows_old_nonceb_current_1 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_2 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_3 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_4 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_5 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_6 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_7 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_8 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_9 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_10 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_11 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_12 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_13 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_14 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_15 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_16 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_17 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_18 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_19 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_20 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_21 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_22 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_23 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_24 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_25 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_26 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_27 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_28 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_29 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_30 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_31 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_32 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_33 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_34 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_35 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_nonceb_current_36 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_old (nonceb_current X1 X2 X3)
  | trans_knows_old_crypt_1 : forall X1 X2:term, auto__q1 X1 -> auto__q4 X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_crypt_2 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_crypt_3 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_crypt_4 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_server_1 : auto_knows_old server
  | trans_knows_old_noncea_old_1 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_knows_old (noncea_old X1 X2)
  | trans_knows_old_noncea_old_2 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto_knows_old (noncea_old X1 X2)
  | trans_knows_old_noncea_old_3 : forall X1 X2:term, auto__q4 X1 -> auto__q4 X2 -> auto_knows_old (noncea_old X1 X2)
  | trans_knows_old_noncea_old_4 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto_knows_old (noncea_old X1 X2)
  | trans_knows_old_noncea_old_5 : forall X1 X2:term, auto__q4 X1 -> auto__q1 X2 -> auto_knows_old (noncea_old X1 X2)
  | trans_knows_old_noncea_old_6 : forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto_knows_old (noncea_old X1 X2)
  | trans_knows_old_noncea_old_7 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_knows_old (noncea_old X1 X2)
  | trans_knows_old_noncea_old_8 : forall X1 X2:term, auto__q4 X1 -> auto__q2 X2 -> auto_knows_old (noncea_old X1 X2)
  | trans_knows_old_nonceb_old_1 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_2 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_4 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_5 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_6 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_7 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_8 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_9 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_10 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_11 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_12 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_13 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_14 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_15 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_16 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_17 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_18 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_19 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_20 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_21 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_22 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_23 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_24 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_25 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_26 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_27 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_28 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_29 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_30 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_31 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_32 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_33 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_34 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_35 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_36 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_37 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_38 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_39 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_40 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_41 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_42 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_43 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_44 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_nonceb_old_45 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_knows_old (nonceb_old X1 X2 X3)
  | trans_knows_old_cons_1 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_knows_old (cons X1 X2)
  | trans_knows_old_prv_1 : auto_knows_old prv
  | trans_knows_old_pub_1 : auto_knows_old pub
  | trans_knows_old_bob_1 : auto_knows_old bob
  | trans_knows_old_alice_1 : auto_knows_old alice
  | trans_knows_old_session_current_1 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto_knows_old (session_current X1 X2 X3)
  | trans_knows_old_session_current_2 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_old (session_current X1 X2 X3)
  | trans_knows_old_session_current_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto_knows_old (session_current X1 X2 X3)
  | trans_knows_old_session_current_4 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto_knows_old (session_current X1 X2 X3)
  | trans_knows_old_session_current_5 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto_knows_old (session_current X1 X2 X3)
  | trans_knows_old_session_current_6 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto_knows_old (session_current X1 X2 X3)
  | trans_knows_old_session_current_7 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_knows_old (session_current X1 X2 X3)
  | trans_knows_old_session_current_8 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto_knows_old (session_current X1 X2 X3)
  | trans_knows_old_session_current_9 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_old (session_current X1 X2 X3)
  | trans_knows_old_session_current_10 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto_knows_old (session_current X1 X2 X3)
with auto_knows_current : term -> Prop :=
    trans_knows_current_key_1 : forall X1 X2:term, auto__q4 X1 -> auto__q3 X2 -> auto_knows_current (key X1 X2)
  | trans_knows_current_key_2 : forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto_knows_current (key X1 X2)
  | trans_knows_current_key_3 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_knows_current (key X1 X2)
  | trans_knows_current_key_4 : forall X1 X2:term, auto__q1 X1 -> auto__q4 X2 -> auto_knows_current (key X1 X2)
  | trans_knows_current_key_5 : forall X1 X2:term, auto__q3 X1 -> auto__q4 X2 -> auto_knows_current (key X1 X2)
  | trans_knows_current_key_6 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto_knows_current (key X1 X2)
  | trans_knows_current_key_7 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto_knows_current (key X1 X2)
  | trans_knows_current_key_8 : forall X1 X2:term, auto__q4 X1 -> auto__q4 X2 -> auto_knows_current (key X1 X2)
  | trans_knows_current_key_9 : forall X1 X2:term, auto__q4 X1 -> auto__q1 X2 -> auto_knows_current (key X1 X2)
  | trans_knows_current_key_10 : forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto_knows_current (key X1 X2)
  | trans_knows_current_key_11 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_knows_current (key X1 X2)
  | trans_knows_current_key_12 : forall X1 X2:term, auto__q4 X1 -> auto__q2 X2 -> auto_knows_current (key X1 X2)
  | trans_knows_current_key_13 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto_knows_current (key X1 X2)
  | trans_knows_current_s_1 : forall X1:term, auto__q2 X1 -> auto_knows_current (s X1)
  | trans_knows_current_s_2 : forall X1:term, auto__q1 X1 -> auto_knows_current (s X1)
  | trans_knows_current_nil_1 : auto_knows_current nil
  | trans_knows_current_i_1 : auto_knows_current i
  | trans_knows_current_nonceb_current_1 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_2 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_3 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_4 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_5 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_6 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_7 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_8 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_9 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_10 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_11 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_12 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_13 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_14 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_15 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_16 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_17 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_18 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_19 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_20 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_21 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_22 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_23 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_24 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_25 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_26 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_27 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_28 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_29 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_30 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_31 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_32 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_33 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_34 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_35 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_36 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_37 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_38 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_39 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_40 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_crypt_1 : forall X1 X2:term, auto__q4 X1 -> auto__q3 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_2 : forall X1 X2:term, auto__q1 X1 -> auto__q4 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_3 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_4 : forall X1 X2:term, auto__q4 X1 -> auto__q4 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_5 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_6 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_7 : forall X1 X2:term, auto__q4 X1 -> auto__q2 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_8 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_server_1 : auto_knows_current server
  | trans_knows_current_noncea_old_1 : forall X1 X2:term, auto__q2 X1 -> auto__q4 X2 -> auto_knows_current (noncea_old X1 X2)
  | trans_knows_current_noncea_old_2 : forall X1 X2:term, auto__q4 X1 -> auto__q3 X2 -> auto_knows_current (noncea_old X1 X2)
  | trans_knows_current_noncea_old_3 : forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto_knows_current (noncea_old X1 X2)
  | trans_knows_current_noncea_old_4 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_knows_current (noncea_old X1 X2)
  | trans_knows_current_noncea_old_5 : forall X1 X2:term, auto__q1 X1 -> auto__q4 X2 -> auto_knows_current (noncea_old X1 X2)
  | trans_knows_current_noncea_old_6 : forall X1 X2:term, auto__q3 X1 -> auto__q4 X2 -> auto_knows_current (noncea_old X1 X2)
  | trans_knows_current_noncea_old_7 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto_knows_current (noncea_old X1 X2)
  | trans_knows_current_noncea_old_8 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto_knows_current (noncea_old X1 X2)
  | trans_knows_current_noncea_old_9 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto_knows_current (noncea_old X1 X2)
  | trans_knows_current_noncea_old_10 : forall X1 X2:term, auto__q4 X1 -> auto__q4 X2 -> auto_knows_current (noncea_old X1 X2)
  | trans_knows_current_noncea_old_11 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto_knows_current (noncea_old X1 X2)
  | trans_knows_current_noncea_old_12 : forall X1 X2:term, auto__q4 X1 -> auto__q1 X2 -> auto_knows_current (noncea_old X1 X2)
  | trans_knows_current_noncea_old_13 : forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto_knows_current (noncea_old X1 X2)
  | trans_knows_current_noncea_old_14 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_knows_current (noncea_old X1 X2)
  | trans_knows_current_noncea_old_15 : forall X1 X2:term, auto__q4 X1 -> auto__q2 X2 -> auto_knows_current (noncea_old X1 X2)
  | trans_knows_current_noncea_old_16 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto_knows_current (noncea_old X1 X2)
  | trans_knows_current_nonceb_old_1 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_2 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_3 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_4 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_5 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_6 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_7 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_8 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_9 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_10 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_11 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_12 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_13 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_14 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_15 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_16 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_17 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_18 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_19 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_20 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_21 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_22 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_23 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_24 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_25 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_26 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_27 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_28 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_29 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_30 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_31 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_32 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_33 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_34 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_35 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_36 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_37 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_38 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_39 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_40 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_41 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_42 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_43 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_44 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_45 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_46 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_47 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_48 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_49 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_50 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_51 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_52 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_53 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_54 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_55 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_56 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_57 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_58 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_59 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_60 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_61 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_62 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_63 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_nonceb_old_64 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_cons_1 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto_knows_current (cons X1 X2)
  | trans_knows_current_cons_2 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto_knows_current (cons X1 X2)
  | trans_knows_current_cons_3 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_knows_current (cons X1 X2)
  | trans_knows_current_cons_4 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto_knows_current (cons X1 X2)
  | trans_knows_current_prv_1 : auto_knows_current prv
  | trans_knows_current_pub_1 : auto_knows_current pub
  | trans_knows_current_bob_1 : auto_knows_current bob
  | trans_knows_current_sym_1 : auto_knows_current sym
  | trans_knows_current_noncea_current_1 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto_knows_current (noncea_current X1 X2)
  | trans_knows_current_noncea_current_2 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_knows_current (noncea_current X1 X2)
  | trans_knows_current_noncea_current_3 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto_knows_current (noncea_current X1 X2)
  | trans_knows_current_alice_1 : auto_knows_current alice
  | trans_knows_current_session_current_1 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto_knows_current (session_current X1 X2 X3)
  | trans_knows_current_session_current_2 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_knows_current (session_current X1 X2 X3)
  | trans_knows_current_session_current_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto_knows_current (session_current X1 X2 X3)
  | trans_knows_current_session_current_4 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto_knows_current (session_current X1 X2 X3)
  | trans_knows_current_session_current_5 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto_knows_current (session_current X1 X2 X3)
  | trans_knows_current_session_current_6 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto_knows_current (session_current X1 X2 X3)
  | trans_knows_current_session_current_7 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_knows_current (session_current X1 X2 X3)
  | trans_knows_current_session_current_8 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto_knows_current (session_current X1 X2 X3)
  | trans_knows_current_session_current_9 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_knows_current (session_current X1 X2 X3)
  | trans_knows_current_session_current_10 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto_knows_current (session_current X1 X2 X3)
with auto_alice_key_old : term -> term -> Prop :=
    trans_alice_key_old_1 : forall X1 X2:term, auto__q2 X1 -> auto__q4 X2 -> auto_alice_key_old X1 X2
  | trans_alice_key_old_2 : forall X1 X2:term, auto__q4 X1 -> auto__q3 X2 -> auto_alice_key_old X1 X2
  | trans_alice_key_old_3 : forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto_alice_key_old X1 X2
  | trans_alice_key_old_4 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_alice_key_old X1 X2
  | trans_alice_key_old_5 : forall X1 X2:term, auto__q1 X1 -> auto__q4 X2 -> auto_alice_key_old X1 X2
  | trans_alice_key_old_6 : forall X1 X2:term, auto__q3 X1 -> auto__q4 X2 -> auto_alice_key_old X1 X2
  | trans_alice_key_old_7 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto_alice_key_old X1 X2
  | trans_alice_key_old_8 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto_alice_key_old X1 X2
  | trans_alice_key_old_9 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto_alice_key_old X1 X2
  | trans_alice_key_old_10 : forall X1 X2:term, auto__q4 X1 -> auto__q4 X2 -> auto_alice_key_old X1 X2
  | trans_alice_key_old_11 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto_alice_key_old X1 X2
  | trans_alice_key_old_12 : forall X1 X2:term, auto__q4 X1 -> auto__q1 X2 -> auto_alice_key_old X1 X2
  | trans_alice_key_old_13 : forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto_alice_key_old X1 X2
  | trans_alice_key_old_14 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_alice_key_old X1 X2
  | trans_alice_key_old_15 : forall X1 X2:term, auto__q4 X1 -> auto__q2 X2 -> auto_alice_key_old X1 X2
  | trans_alice_key_old_16 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto_alice_key_old X1 X2
with auto__q3 : term -> Prop :=
    trans__q3_key_1 : forall X1 X2:term, auto__q2 X1 -> auto__q4 X2 -> auto__q3 (key X1 X2)
  | trans__q3_nonceb_current_1 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto__q3 (nonceb_current X1 X2 X3)
  | trans__q3_nonceb_current_2 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto__q3 (nonceb_current X1 X2 X3)
  | trans__q3_nonceb_current_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q3 (nonceb_current X1 X2 X3)
  | trans__q3_nonceb_current_4 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto__q3 (nonceb_current X1 X2 X3)
  | trans__q3_nonceb_current_5 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto__q3 (nonceb_current X1 X2 X3)
  | trans__q3_nonceb_current_6 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q3 (nonceb_current X1 X2 X3)
  | trans__q3_session_old_1 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_2 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_3 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_4 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_5 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_6 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_7 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_8 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_9 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_10 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_11 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_12 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_13 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_14 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_15 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_16 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_17 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_18 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_19 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_20 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_21 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_22 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_23 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_24 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_25 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_26 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_27 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_28 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_29 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_30 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_31 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_32 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_33 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_34 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_35 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_36 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_37 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_38 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_39 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_40 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_41 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_42 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_43 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_44 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_45 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_46 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_47 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_48 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_49 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_50 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_51 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_52 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_53 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_54 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_55 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_56 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_57 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_58 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_59 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_60 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_61 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_62 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_63 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_session_old_64 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 (session_old X1 X2 X3)
  | trans__q3_crypt_1 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q3 (crypt X1 X2)
  | trans__q3_crypt_2 : forall X1 X2:term, auto__q4 X1 -> auto__q1 X2 -> auto__q3 (crypt X1 X2)
  | trans__q3_cons_1 : forall X1 X2:term, auto__q2 X1 -> auto__q4 X2 -> auto__q3 (cons X1 X2)
  | trans__q3_cons_2 : forall X1 X2:term, auto__q4 X1 -> auto__q3 X2 -> auto__q3 (cons X1 X2)
  | trans__q3_cons_3 : forall X1 X2:term, auto__q1 X1 -> auto__q4 X2 -> auto__q3 (cons X1 X2)
  | trans__q3_cons_4 : forall X1 X2:term, auto__q3 X1 -> auto__q4 X2 -> auto__q3 (cons X1 X2)
  | trans__q3_cons_5 : forall X1 X2:term, auto__q4 X1 -> auto__q4 X2 -> auto__q3 (cons X1 X2)
  | trans__q3_cons_6 : forall X1 X2:term, auto__q4 X1 -> auto__q2 X2 -> auto__q3 (cons X1 X2)
  | trans__q3_session_current_1 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_2 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_3 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_4 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_5 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_6 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_7 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_8 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_9 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_10 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_11 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_12 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_13 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_14 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_15 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_16 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_17 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_18 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_19 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_20 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_21 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_22 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q3 (session_current X1 X2 X3)
  | trans__q3_session_current_23 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q3 (session_current X1 X2 X3)
with auto_agent : term -> Prop :=
    trans_agent_key_1 : forall X1 X2:term, auto__q4 X1 -> auto__q3 X2 -> auto_agent (key X1 X2)
  | trans_agent_key_2 : forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto_agent (key X1 X2)
  | trans_agent_key_3 : forall X1 X2:term, auto__q1 X1 -> auto__q4 X2 -> auto_agent (key X1 X2)
  | trans_agent_key_4 : forall X1 X2:term, auto__q3 X1 -> auto__q4 X2 -> auto_agent (key X1 X2)
  | trans_agent_key_5 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto_agent (key X1 X2)
  | trans_agent_key_6 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto_agent (key X1 X2)
  | trans_agent_key_7 : forall X1 X2:term, auto__q4 X1 -> auto__q4 X2 -> auto_agent (key X1 X2)
  | trans_agent_key_8 : forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto_agent (key X1 X2)
  | trans_agent_key_9 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_agent (key X1 X2)
  | trans_agent_key_10 : forall X1 X2:term, auto__q4 X1 -> auto__q2 X2 -> auto_agent (key X1 X2)
  | trans_agent_key_11 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto_agent (key X1 X2)
  | trans_agent_s_1 : forall X1:term, auto__q1 X1 -> auto_agent (s X1)
  | trans_agent_nil_1 : auto_agent nil
  | trans_agent_i_1 : auto_agent i
  | trans_agent_nonceb_current_1 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_2 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_3 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_4 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_5 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_6 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_7 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_8 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_9 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_10 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_11 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_12 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_13 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_14 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_15 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_16 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_17 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_18 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_19 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_20 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_21 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_22 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_23 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_24 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_25 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_26 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_27 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_28 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_29 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_30 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_31 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_32 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_33 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_34 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_35 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_nonceb_current_36 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_agent (nonceb_current X1 X2 X3)
  | trans_agent_crypt_1 : forall X1 X2:term, auto__q1 X1 -> auto__q4 X2 -> auto_agent (crypt X1 X2)
  | trans_agent_crypt_2 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto_agent (crypt X1 X2)
  | trans_agent_crypt_3 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_agent (crypt X1 X2)
  | trans_agent_crypt_4 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto_agent (crypt X1 X2)
  | trans_agent_server_1 : auto_agent server
  | trans_agent_noncea_old_1 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_agent (noncea_old X1 X2)
  | trans_agent_noncea_old_2 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto_agent (noncea_old X1 X2)
  | trans_agent_noncea_old_3 : forall X1 X2:term, auto__q4 X1 -> auto__q4 X2 -> auto_agent (noncea_old X1 X2)
  | trans_agent_noncea_old_4 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto_agent (noncea_old X1 X2)
  | trans_agent_noncea_old_5 : forall X1 X2:term, auto__q4 X1 -> auto__q1 X2 -> auto_agent (noncea_old X1 X2)
  | trans_agent_noncea_old_6 : forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto_agent (noncea_old X1 X2)
  | trans_agent_noncea_old_7 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_agent (noncea_old X1 X2)
  | trans_agent_noncea_old_8 : forall X1 X2:term, auto__q4 X1 -> auto__q2 X2 -> auto_agent (noncea_old X1 X2)
  | trans_agent_nonceb_old_1 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_2 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_4 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_5 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_6 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_7 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_8 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_9 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_10 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_11 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_12 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_13 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_14 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_15 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_16 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_17 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_18 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_19 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_20 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_21 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_22 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_23 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_24 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_25 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_26 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_27 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_28 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_29 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_30 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_31 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_32 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_33 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_34 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_35 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_36 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_37 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_38 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_39 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_40 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_41 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_42 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_43 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_44 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_nonceb_old_45 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto_agent (nonceb_old X1 X2 X3)
  | trans_agent_cons_1 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_agent (cons X1 X2)
  | trans_agent_prv_1 : auto_agent prv
  | trans_agent_pub_1 : auto_agent pub
  | trans_agent_bob_1 : auto_agent bob
  | trans_agent_alice_1 : auto_agent alice
  | trans_agent_session_current_1 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto_agent (session_current X1 X2 X3)
  | trans_agent_session_current_2 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto_agent (session_current X1 X2 X3)
  | trans_agent_session_current_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto_agent (session_current X1 X2 X3)
  | trans_agent_session_current_4 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto_agent (session_current X1 X2 X3)
  | trans_agent_session_current_5 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto_agent (session_current X1 X2 X3)
  | trans_agent_session_current_6 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto_agent (session_current X1 X2 X3)
  | trans_agent_session_current_7 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto_agent (session_current X1 X2 X3)
  | trans_agent_session_current_8 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto_agent (session_current X1 X2 X3)
  | trans_agent_session_current_9 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto_agent (session_current X1 X2 X3)
  | trans_agent_session_current_10 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto_agent (session_current X1 X2 X3)
with auto_bob_key_old : term -> term -> Prop :=
    trans_bob_key_old_1 : forall X1 X2:term, auto__q2 X1 -> auto__q4 X2 -> auto_bob_key_old X1 X2
  | trans_bob_key_old_2 : forall X1 X2:term, auto__q4 X1 -> auto__q3 X2 -> auto_bob_key_old X1 X2
  | trans_bob_key_old_3 : forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto_bob_key_old X1 X2
  | trans_bob_key_old_4 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_bob_key_old X1 X2
  | trans_bob_key_old_5 : forall X1 X2:term, auto__q1 X1 -> auto__q4 X2 -> auto_bob_key_old X1 X2
  | trans_bob_key_old_6 : forall X1 X2:term, auto__q3 X1 -> auto__q4 X2 -> auto_bob_key_old X1 X2
  | trans_bob_key_old_7 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto_bob_key_old X1 X2
  | trans_bob_key_old_8 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto_bob_key_old X1 X2
  | trans_bob_key_old_9 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto_bob_key_old X1 X2
  | trans_bob_key_old_10 : forall X1 X2:term, auto__q4 X1 -> auto__q4 X2 -> auto_bob_key_old X1 X2
  | trans_bob_key_old_11 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto_bob_key_old X1 X2
  | trans_bob_key_old_12 : forall X1 X2:term, auto__q4 X1 -> auto__q1 X2 -> auto_bob_key_old X1 X2
  | trans_bob_key_old_13 : forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto_bob_key_old X1 X2
  | trans_bob_key_old_14 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_bob_key_old X1 X2
  | trans_bob_key_old_15 : forall X1 X2:term, auto__q4 X1 -> auto__q2 X2 -> auto_bob_key_old X1 X2
  | trans_bob_key_old_16 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto_bob_key_old X1 X2
with auto_bob_key_current : term -> term -> Prop :=
    trans_bob_key_current_1 : forall X1 X2:term, auto__q2 X1 -> auto__q4 X2 -> auto_bob_key_current X1 X2
  | trans_bob_key_current_2 : forall X1 X2:term, auto__q4 X1 -> auto__q3 X2 -> auto_bob_key_current X1 X2
  | trans_bob_key_current_3 : forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto_bob_key_current X1 X2
  | trans_bob_key_current_4 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto_bob_key_current X1 X2
  | trans_bob_key_current_5 : forall X1 X2:term, auto__q1 X1 -> auto__q4 X2 -> auto_bob_key_current X1 X2
  | trans_bob_key_current_6 : forall X1 X2:term, auto__q3 X1 -> auto__q4 X2 -> auto_bob_key_current X1 X2
  | trans_bob_key_current_7 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto_bob_key_current X1 X2
  | trans_bob_key_current_8 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto_bob_key_current X1 X2
  | trans_bob_key_current_9 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto_bob_key_current X1 X2
  | trans_bob_key_current_10 : forall X1 X2:term, auto__q4 X1 -> auto__q4 X2 -> auto_bob_key_current X1 X2
  | trans_bob_key_current_11 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto_bob_key_current X1 X2
  | trans_bob_key_current_12 : forall X1 X2:term, auto__q4 X1 -> auto__q1 X2 -> auto_bob_key_current X1 X2
  | trans_bob_key_current_13 : forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto_bob_key_current X1 X2
  | trans_bob_key_current_14 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto_bob_key_current X1 X2
  | trans_bob_key_current_15 : forall X1 X2:term, auto__q4 X1 -> auto__q2 X2 -> auto_bob_key_current X1 X2
  | trans_bob_key_current_16 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto_bob_key_current X1 X2
with auto__q1 : term -> Prop :=
    trans__q1_key_1 : forall X1 X2:term, auto__q4 X1 -> auto__q3 X2 -> auto__q1 (key X1 X2)
  | trans__q1_key_2 : forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto__q1 (key X1 X2)
  | trans__q1_key_3 : forall X1 X2:term, auto__q1 X1 -> auto__q4 X2 -> auto__q1 (key X1 X2)
  | trans__q1_key_4 : forall X1 X2:term, auto__q3 X1 -> auto__q4 X2 -> auto__q1 (key X1 X2)
  | trans__q1_key_5 : forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 (key X1 X2)
  | trans__q1_key_6 : forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 (key X1 X2)
  | trans__q1_key_7 : forall X1 X2:term, auto__q4 X1 -> auto__q4 X2 -> auto__q1 (key X1 X2)
  | trans__q1_key_8 : forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 (key X1 X2)
  | trans__q1_key_9 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 (key X1 X2)
  | trans__q1_key_10 : forall X1 X2:term, auto__q4 X1 -> auto__q2 X2 -> auto__q1 (key X1 X2)
  | trans__q1_key_11 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 (key X1 X2)
  | trans__q1_s_1 : forall X1:term, auto__q1 X1 -> auto__q1 (s X1)
  | trans__q1_nil_1 : auto__q1 nil
  | trans__q1_i_1 : auto__q1 i
  | trans__q1_nonceb_current_1 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_2 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_3 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_4 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_5 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_6 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_7 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_8 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_9 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_10 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_11 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_12 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_13 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_14 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_15 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_16 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_17 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_18 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_19 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_20 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_21 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_22 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_23 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_24 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_25 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_26 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_27 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_28 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_29 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_30 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_31 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_32 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_33 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_34 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_35 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_nonceb_current_36 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 (nonceb_current X1 X2 X3)
  | trans__q1_crypt_1 : forall X1 X2:term, auto__q1 X1 -> auto__q4 X2 -> auto__q1 (crypt X1 X2)
  | trans__q1_crypt_2 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 (crypt X1 X2)
  | trans__q1_crypt_3 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 (crypt X1 X2)
  | trans__q1_crypt_4 : forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 (crypt X1 X2)
  | trans__q1_server_1 : auto__q1 server
  | trans__q1_noncea_old_1 : forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q1 (noncea_old X1 X2)
  | trans__q1_noncea_old_2 : forall X1 X2:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 (noncea_old X1 X2)
  | trans__q1_noncea_old_3 : forall X1 X2:term, auto__q4 X1 -> auto__q4 X2 -> auto__q1 (noncea_old X1 X2)
  | trans__q1_noncea_old_4 : forall X1 X2:term, auto__q2 X1 -> auto__q2 X2 -> auto__q1 (noncea_old X1 X2)
  | trans__q1_noncea_old_5 : forall X1 X2:term, auto__q4 X1 -> auto__q1 X2 -> auto__q1 (noncea_old X1 X2)
  | trans__q1_noncea_old_6 : forall X1 X2:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 (noncea_old X1 X2)
  | trans__q1_noncea_old_7 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 (noncea_old X1 X2)
  | trans__q1_noncea_old_8 : forall X1 X2:term, auto__q4 X1 -> auto__q2 X2 -> auto__q1 (noncea_old X1 X2)
  | trans__q1_nonceb_old_1 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_2 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_4 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_5 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_6 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_7 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_8 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_9 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_10 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_11 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_12 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_13 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_14 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_15 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_16 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_17 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_18 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_19 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_20 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_21 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_22 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_23 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_24 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_25 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q3 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_26 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_27 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_28 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_29 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_30 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_31 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_32 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_33 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_34 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_35 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_36 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_37 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q4 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_38 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_39 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_40 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_41 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_42 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_43 : forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_44 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q1 X2 -> auto__q2 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_nonceb_old_45 : forall X1 X2 X3:term, auto__q4 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 (nonceb_old X1 X2 X3)
  | trans__q1_cons_1 : forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q1 (cons X1 X2)
  | trans__q1_prv_1 : auto__q1 prv
  | trans__q1_pub_1 : auto__q1 pub
  | trans__q1_bob_1 : auto__q1 bob
  | trans__q1_alice_1 : auto__q1 alice
  | trans__q1_session_current_1 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q4 X3 -> auto__q1 (session_current X1 X2 X3)
  | trans__q1_session_current_2 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> auto__q1 (session_current X1 X2 X3)
  | trans__q1_session_current_3 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto__q1 (session_current X1 X2 X3)
  | trans__q1_session_current_4 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q4 X3 -> auto__q1 (session_current X1 X2 X3)
  | trans__q1_session_current_5 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q4 X3 -> auto__q1 (session_current X1 X2 X3)
  | trans__q1_session_current_6 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q3 X3 -> auto__q1 (session_current X1 X2 X3)
  | trans__q1_session_current_7 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> auto__q1 (session_current X1 X2 X3)
  | trans__q1_session_current_8 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q2 X3 -> auto__q1 (session_current X1 X2 X3)
  | trans__q1_session_current_9 : forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> auto__q1 (session_current X1 X2 X3)
  | trans__q1_session_current_10 : forall X1 X2 X3:term, auto__q2 X1 -> auto__q4 X2 -> auto__q1 X3 -> auto__q1 (session_current X1 X2 X3)
with auto___query__intruder_knows_session_key_as_seen_by_alice : Prop :=
with auto___query__intruder_knows_session_key_generated_by_server : Prop :=
.

(* [defp] Proofs that all definitions hold. *)


(* [appp] Proofs that all approximation clauses hold. *)


Inductive or_0 : Prop :=
.

Remark rem_1 : auto__q2 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2 : forall X1:term, auto__q2 alice -> auto__q4 X1 -> auto_knows_current X1 -> auto___query__intruder_knows_session_key_as_seen_by_alice. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_1 H);  intros.
Qed.

Remark rem_3 : auto__q4 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_4 : forall X1:term, auto__q3 X1 -> auto__q4 alice -> auto_knows_current X1 -> auto___query__intruder_knows_session_key_as_seen_by_alice. (* Eliminate negative atom. *)
Proof.
  intros X1. intros H1. intro H. intros.
  elim (rem_3 H);  intros.
Qed.

Remark rem_5 : forall X1:term, auto__q4 alice -> auto__q3 X1 -> auto_knows_current X1 -> auto___query__intruder_knows_session_key_as_seen_by_alice. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1.
  cut (auto__q3 X1 -> auto__q4 alice -> auto_knows_current X1 -> auto___query__intruder_knows_session_key_as_seen_by_alice). tauto. exact (rem_4 X1).
Qed.

Remark rem_6 : auto__q3 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_7 : forall X1:term, auto__q3 X1 -> auto__q3 alice -> auto_knows_current X1 -> auto___query__intruder_knows_session_key_as_seen_by_alice. (* Eliminate negative atom. *)
Proof.
  intros X1. intros H1. intro H. intros.
  elim (rem_6 H);  intros.
Qed.

Remark rem_8 : forall X1:term, auto__q3 alice -> auto__q3 X1 -> auto_knows_current X1 -> auto___query__intruder_knows_session_key_as_seen_by_alice. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1.
  cut (auto__q3 X1 -> auto__q3 alice -> auto_knows_current X1 -> auto___query__intruder_knows_session_key_as_seen_by_alice). tauto. exact (rem_7 X1).
Qed.

Remark rem_9 : forall X1:term, auto__q1 X1 -> auto__q3 alice -> auto_knows_current X1 -> auto___query__intruder_knows_session_key_as_seen_by_alice. (* Eliminate negative atom. *)
Proof.
  intros X1. intros H1. intro H. intros.
  elim (rem_6 H);  intros.
Qed.

Remark rem_10 : forall X1:term, auto__q3 alice -> auto__q1 X1 -> auto_knows_current X1 -> auto___query__intruder_knows_session_key_as_seen_by_alice. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1.
  cut (auto__q1 X1 -> auto__q3 alice -> auto_knows_current X1 -> auto___query__intruder_knows_session_key_as_seen_by_alice). tauto. exact (rem_9 X1).
Qed.

Remark rem_11 : (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1:term, auto__q2 X1 -> auto__q3 X1 -> False. (* Use induction hypothesis. *)
Proof.
   intro Hrec. intro H. clear H. intros X1.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). tauto. exact (Hrec X1).
Defined.

Remark rem_12 : (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q3 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q3 epsilon_m_q4_m_q2. tauto.
  exact (rem_11 epsilon_m_q2_m_q3 epsilon_m_q4_m_q2 X1).
Defined.

Inductive or_1(H1:Prop) : Prop :=
    or_1_intro_1 : H1 -> (or_1 H1)
.

Remark rem_13 : forall X1 X2:term, auto__q3 (key X1 X2) -> or_1
    (auto__q2 X1 /\ auto__q4 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_14 : (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q3 (key X1 X2) -> auto__q3 X1 -> auto__q1 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q3 epsilon_m_q4_m_q2. intros X1 X2. intro H. intros.
  elim (rem_13 X1 X2 H);  intros.
  apply (rem_12 epsilon_m_q2_m_q3 epsilon_m_q4_m_q2 X1 X2);  tauto.
Defined.

Remark rem_15 : (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1:term, auto__q4 X1 -> auto__q2 X1 -> False. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro Hrec. intros X1.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). tauto. exact (Hrec X1).
Defined.

Remark rem_16 : (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q3 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q3 epsilon_m_q4_m_q2. tauto.
  exact (rem_15 epsilon_m_q2_m_q3 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_17 : (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q3 (key X1 X2) -> auto__q4 X1 -> auto__q1 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q3 epsilon_m_q4_m_q2. intros X1 X2. intro H. intros.
  elim (rem_13 X1 X2 H);  intros.
  apply (rem_16 epsilon_m_q2_m_q3 epsilon_m_q4_m_q2 X1 X2);  tauto.
Defined.

Inductive or_2(H1 H2:Prop) : Prop :=
    or_2_intro_1 : H1 -> (or_2 H1 H2)
  | or_2_intro_2 : H2 -> (or_2 H1 H2)
.

Remark rem_18 : forall X1 X2:term, auto__q2 (key X1 X2) -> or_2
    (auto__q3 X1 /\ auto__q1 X2)
    (auto__q4 X1 /\ auto__q1 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_19 : (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q2 (key X1 X2) -> auto__q3 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q3 epsilon_m_q4_m_q2. intros X1 X2. intro H. intros.
  elim (rem_18 X1 X2 H);  intros.
  apply (rem_14 epsilon_m_q2_m_q3 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_17 epsilon_m_q2_m_q3 epsilon_m_q4_m_q2 X1 X2);  tauto.
Defined.

Remark rem_20 : forall X1:term, auto__q3 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_21 : (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1:term, auto__q3 (s X1) -> auto__q2 X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q3 epsilon_m_q4_m_q2. intros X1. intro H. intros.
  elim (rem_20 X1 H);  intros.
Defined.

Remark rem_22 : forall X1:term, auto__q2 (s X1) -> or_1
    (auto__q2 X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_23 : (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1:term, auto__q2 (s X1) -> auto__q3 (s X1) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q3 epsilon_m_q4_m_q2. intros X1. intro H. intros.
  elim (rem_22 X1 H);  intros.
  apply (rem_21 epsilon_m_q2_m_q3 epsilon_m_q4_m_q2 X1);  tauto.
Defined.

Remark rem_24 : (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q3 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q3 epsilon_m_q4_m_q2. tauto.
  exact (rem_11 epsilon_m_q2_m_q3 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_25 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1:term, auto__q4 X1 -> auto__q2 X1 -> False. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro H. clear H. intro H. clear H. intro H. clear H. intro Hrec. intros X1.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). tauto. exact (Hrec X1).
Defined.

Remark rem_26 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q3 X2 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_27 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1:term, auto__q2 X1 -> auto__q3 X1 -> False. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro H. clear H. intro Hrec. intro H. clear H. intro H. clear H. intros X1.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). tauto. exact (Hrec X1).
Defined.

Remark rem_28 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_29 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1:term, auto__q2 X1 -> auto__q1 X1 -> False. (* Use induction hypothesis. *)
Proof.
   intro Hrec. intro H. clear H. intro H. clear H. intro H. clear H. intro H. clear H. intros X1.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). tauto. exact (Hrec X1).
Defined.

Remark rem_30 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_31 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_32 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_33 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_34 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_35 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1:term, auto__q4 X1 -> auto__q2 X1 -> False. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro H. clear H. intro H. clear H. intro H. clear H. intro H. clear H. intro Hrec. intros X1.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). tauto. exact (Hrec X1).
Defined.

Remark rem_36 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q3 X2 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_37 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1:term, auto__q2 X1 -> auto__q3 X1 -> False. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro H. clear H. intro Hrec. intro H. clear H. intro H. clear H. intro H. clear H. intros X1.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). tauto. exact (Hrec X1).
Defined.

Remark rem_38 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_39 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1:term, auto__q2 X1 -> auto__q1 X1 -> False. (* Use induction hypothesis. *)
Proof.
   intro Hrec. intro H. clear H. intro H. clear H. intro H. clear H. intro H. clear H. intro H. clear H. intros X1.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). tauto. exact (Hrec X1).
Defined.

Remark rem_40 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_41 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_42 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_43 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_44 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q4 X1 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_45 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X2:term, auto__q4 X2 -> auto__q3 X2 -> False. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro Hrec. intro H. clear H. intro H. clear H. intro H. clear H. intro H. clear H. intros X2.
  cut (auto__q4 X2 -> auto__q3 X2 -> False). tauto. exact (Hrec X2).
Defined.

Remark rem_46 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q3 X2 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q4 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_45 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_47 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_48 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q4 X1 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_49 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Inductive or_11(H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11:Prop) : Prop :=
    or_11_intro_1 : H1 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_2 : H2 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_3 : H3 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_4 : H4 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_5 : H5 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_6 : H6 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_7 : H7 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_8 : H8 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_9 : H9 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_10 : H10 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
  | or_11_intro_11 : H11 -> (or_11 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11)
.

Remark rem_50 : forall X1 X2:term, auto__q1 (key X1 X2) -> or_11
    (auto__q4 X1 /\ auto__q3 X2)
    (auto__q3 X1 /\ auto__q3 X2)
    (auto__q1 X1 /\ auto__q4 X2)
    (auto__q3 X1 /\ auto__q4 X2)
    (auto__q3 X1 /\ auto__q2 X2)
    (auto__q1 X1 /\ auto__q3 X2)
    (auto__q4 X1 /\ auto__q4 X2)
    (auto__q2 X1 /\ auto__q3 X2)
    (auto__q1 X1 /\ auto__q1 X2)
    (auto__q4 X1 /\ auto__q2 X2)
    (auto__q1 X1 /\ auto__q2 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_11_intro_1; tauto.
  intros. apply or_11_intro_2; tauto.
  intros. apply or_11_intro_3; tauto.
  intros. apply or_11_intro_4; tauto.
  intros. apply or_11_intro_5; tauto.
  intros. apply or_11_intro_6; tauto.
  intros. apply or_11_intro_7; tauto.
  intros. apply or_11_intro_8; tauto.
  intros. apply or_11_intro_9; tauto.
  intros. apply or_11_intro_10; tauto.
  intros. apply or_11_intro_11; tauto.
Qed.

Remark rem_51 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 (key X1 X2) -> auto__q2 X1 -> auto__q4 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2. intro H. intros.
  elim (rem_50 X1 X2 H);  intros.
  apply (rem_36 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_38 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_40 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_41 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_42 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_43 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_44 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_46 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_47 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_48 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_49 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
Defined.

Remark rem_52 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q3 (key X1 X2) -> auto__q1 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2. intro H. intros.
  elim (rem_13 X1 X2 H);  intros.
  apply (rem_51 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
Defined.

Remark rem_53 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_54 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_55 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1:term, auto__q3 X1 -> auto__q1 X1 -> False. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro H. clear H. intro H. clear H. intro H. clear H. intro Hrec. intro H. clear H. intros X1.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). tauto. exact (Hrec X1).
Defined.

Remark rem_56 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_57 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_58 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1:term, auto__q4 X1 -> auto__q3 X1 -> False. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro Hrec. intro H. clear H. intro H. clear H. intro H. clear H. intro H. clear H. intros X1.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). tauto. exact (Hrec X1).
Defined.

Remark rem_59 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_58 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_60 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_45 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_61 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_62 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_63 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_64 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_65 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_66 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_58 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_67 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_58 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_68 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_58 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_69 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_70 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_71 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_72 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_73 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_74 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_58 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_75 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_58 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_76 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q2 X3 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_77 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_78 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_79 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_80 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_81 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_82 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_83 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_58 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_84 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_58 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_85 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_58 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_86 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_58 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_87 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_58 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_88 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_58 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_89 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_58 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_90 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_58 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Inductive or_36(H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36:Prop) : Prop :=
    or_36_intro_1 : H1 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_2 : H2 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_3 : H3 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_4 : H4 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_5 : H5 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_6 : H6 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_7 : H7 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_8 : H8 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_9 : H9 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_10 : H10 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_11 : H11 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_12 : H12 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_13 : H13 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_14 : H14 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_15 : H15 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_16 : H16 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_17 : H17 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_18 : H18 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_19 : H19 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_20 : H20 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_21 : H21 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_22 : H22 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_23 : H23 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_24 : H24 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_25 : H25 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_26 : H26 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_27 : H27 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_28 : H28 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_29 : H29 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_30 : H30 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_31 : H31 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_32 : H32 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_33 : H33 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_34 : H34 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_35 : H35 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
  | or_36_intro_36 : H36 -> (or_36 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36)
.

Remark rem_91 : forall X1 X2 X3:term, auto__q1 (nonceb_current X1 X2 X3) -> or_36
    (auto__q2 X1 /\ auto__q4 X2 /\ auto__q4 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q1 X3)
    (auto__q1 X1 /\ auto__q1 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q3 X2 /\ auto__q4 X3)
    (auto__q4 X1 /\ auto__q3 X2 /\ auto__q4 X3)
    (auto__q3 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q4 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q2 X1 /\ auto__q4 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q4 X2 /\ auto__q1 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q1 X3)
    (auto__q4 X1 /\ auto__q4 X2 /\ auto__q3 X3)
    (auto__q4 X1 /\ auto__q1 X2 /\ auto__q3 X3)
    (auto__q4 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q3 X2 /\ auto__q1 X3)
    (auto__q2 X1 /\ auto__q4 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q3 X3)
    (auto__q4 X1 /\ auto__q1 X2 /\ auto__q1 X3)
    (auto__q4 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q4 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q4 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q1 X2 /\ auto__q4 X3)
    (auto__q1 X1 /\ auto__q1 X2 /\ auto__q1 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q2 X3)
    (auto__q2 X1 /\ auto__q4 X2 /\ auto__q1 X3)
    (auto__q4 X1 /\ auto__q4 X2 /\ auto__q1 X3)
    (auto__q4 X1 /\ auto__q4 X2 /\ auto__q4 X3)
    (auto__q4 X1 /\ auto__q2 X2 /\ auto__q3 X3)
    (auto__q4 X1 /\ auto__q1 X2 /\ auto__q4 X3)
    (auto__q4 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q4 X1 /\ auto__q2 X2 /\ auto__q4 X3)
    (auto__q4 X1 /\ auto__q4 X2 /\ auto__q2 X3)
    (auto__q4 X1 /\ auto__q1 X2 /\ auto__q2 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_36_intro_1; tauto.
  intros. apply or_36_intro_2; tauto.
  intros. apply or_36_intro_3; tauto.
  intros. apply or_36_intro_4; tauto.
  intros. apply or_36_intro_5; tauto.
  intros. apply or_36_intro_6; tauto.
  intros. apply or_36_intro_7; tauto.
  intros. apply or_36_intro_8; tauto.
  intros. apply or_36_intro_9; tauto.
  intros. apply or_36_intro_10; tauto.
  intros. apply or_36_intro_11; tauto.
  intros. apply or_36_intro_12; tauto.
  intros. apply or_36_intro_13; tauto.
  intros. apply or_36_intro_14; tauto.
  intros. apply or_36_intro_15; tauto.
  intros. apply or_36_intro_16; tauto.
  intros. apply or_36_intro_17; tauto.
  intros. apply or_36_intro_18; tauto.
  intros. apply or_36_intro_19; tauto.
  intros. apply or_36_intro_20; tauto.
  intros. apply or_36_intro_21; tauto.
  intros. apply or_36_intro_22; tauto.
  intros. apply or_36_intro_23; tauto.
  intros. apply or_36_intro_24; tauto.
  intros. apply or_36_intro_25; tauto.
  intros. apply or_36_intro_26; tauto.
  intros. apply or_36_intro_27; tauto.
  intros. apply or_36_intro_28; tauto.
  intros. apply or_36_intro_29; tauto.
  intros. apply or_36_intro_30; tauto.
  intros. apply or_36_intro_31; tauto.
  intros. apply or_36_intro_32; tauto.
  intros. apply or_36_intro_33; tauto.
  intros. apply or_36_intro_34; tauto.
  intros. apply or_36_intro_35; tauto.
  intros. apply or_36_intro_36; tauto.
Qed.

Remark rem_92 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (nonceb_current X1 X2 X3) -> auto__q3 X1 -> auto__q4 X2 -> auto__q1 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_91 X1 X2 X3 H);  intros.
  apply (rem_53 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_54 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_56 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_57 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_59 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_60 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_61 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_62 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_63 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_64 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_65 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_66 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_67 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_68 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_69 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_70 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_71 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_72 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_73 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_74 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_75 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_76 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_77 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_78 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_79 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_80 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_81 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_82 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_83 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_84 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_85 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_86 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_87 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_88 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_89 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_90 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_93 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_94 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_95 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X2:term, auto__q2 X2 -> auto__q1 X2 -> False. (* Use induction hypothesis. *)
Proof.
   intro Hrec. intro H. clear H. intro H. clear H. intro H. clear H. intro H. clear H. intro H. clear H. intros X2.
  cut (auto__q2 X2 -> auto__q1 X2 -> False). tauto. exact (Hrec X2).
Defined.

Remark rem_96 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_95 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_97 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_98 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1:term, auto__q4 X1 -> auto__q1 X1 -> False. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro H. clear H. intro H. clear H. intro Hrec. intro H. clear H. intro H. clear H. intros X1.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). tauto. exact (Hrec X1).
Defined.

Remark rem_99 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_100 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_101 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X2:term, auto__q2 X2 -> auto__q3 X2 -> False. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro H. clear H. intro Hrec. intro H. clear H. intro H. clear H. intro H. clear H. intros X2.
  cut (auto__q2 X2 -> auto__q3 X2 -> False). tauto. exact (Hrec X2).
Defined.

Remark rem_102 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_101 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_103 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X3:term, auto__q4 X3 -> auto__q2 X3 -> False. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro H. clear H. intro H. clear H. intro H. clear H. intro H. clear H. intro Hrec. intros X3.
  cut (auto__q4 X3 -> auto__q2 X3 -> False). tauto. exact (Hrec X3).
Defined.

Remark rem_104 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q2 X3 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X3 -> auto__q2 X3 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_103 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X3).
Defined.

Remark rem_105 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_106 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X2:term, auto__q4 X2 -> auto__q2 X2 -> False. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro H. clear H. intro H. clear H. intro H. clear H. intro H. clear H. intro Hrec. intros X2.
  cut (auto__q4 X2 -> auto__q2 X2 -> False). tauto. exact (Hrec X2).
Defined.

Remark rem_107 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q2 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_106 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_108 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_101 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_109 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_110 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_111 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_112 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_101 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_113 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_114 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_115 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X3:term, auto__q4 X3 -> auto__q3 X3 -> False. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro Hrec. intro H. clear H. intro H. clear H. intro H. clear H. intro H. clear H. intros X3.
  cut (auto__q4 X3 -> auto__q3 X3 -> False). tauto. exact (Hrec X3).
Defined.

Remark rem_116 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X3 -> auto__q3 X3 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_115 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X3).
Defined.

Remark rem_117 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_118 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_119 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_120 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q2 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_106 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_121 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q2 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_106 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_122 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_95 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_123 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_95 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_124 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_125 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_101 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_126 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_127 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_128 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_129 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_130 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_131 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_132 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_133 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_134 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_135 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (nonceb_current X1 X2 X3) -> auto__q1 X1 -> auto__q2 X2 -> auto__q4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_91 X1 X2 X3 H);  intros.
  apply (rem_93 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_94 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_96 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_97 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_99 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_100 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_102 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_104 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_105 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_107 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_108 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_109 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_110 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_111 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_112 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_113 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_114 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_116 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_117 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_118 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_119 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_120 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_121 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_122 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_123 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_124 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_125 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_126 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_127 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_128 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_129 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_130 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_131 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_132 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_133 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_134 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_136 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q2 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_106 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_137 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X3 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_95 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_138 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_139 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_101 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_140 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_141 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_142 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_143 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X3 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_144 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q2 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_106 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_145 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_146 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_147 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_148 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_149 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q2 X3 -> auto__q4 X1 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_150 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_151 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_101 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_152 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q2 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q2 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_106 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_153 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q2 X3 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_154 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X3:term, auto__q2 X3 -> auto__q3 X3 -> False. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro H. clear H. intro Hrec. intro H. clear H. intro H. clear H. intro H. clear H. intros X3.
  cut (auto__q2 X3 -> auto__q3 X3 -> False). tauto. exact (Hrec X3).
Defined.

Remark rem_155 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q2 X3 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q3 X3 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_154 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X3).
Defined.

Remark rem_156 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_157 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_158 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_159 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_160 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_161 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_162 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_95 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_163 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_164 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X3 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q2 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_106 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_165 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_166 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_167 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_168 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_169 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_170 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_171 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_172 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_173 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (nonceb_current X1 X2 X3) -> auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_91 X1 X2 X3 H);  intros.
  apply (rem_136 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_137 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_138 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_139 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_140 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_141 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_142 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_143 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_144 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_145 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_146 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_147 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_148 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_149 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_150 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_151 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_152 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_153 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_155 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_156 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_157 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_158 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_159 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_160 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_161 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_162 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_163 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_164 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_165 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_166 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_167 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_168 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_169 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_170 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_171 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_172 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_174 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_175 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_176 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X2:term, auto__q4 X2 -> auto__q1 X2 -> False. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro H. clear H. intro H. clear H. intro Hrec. intro H. clear H. intro H. clear H. intros X2.
  cut (auto__q4 X2 -> auto__q1 X2 -> False). tauto. exact (Hrec X2).
Defined.

Remark rem_177 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_176 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_178 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_179 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_180 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_181 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_45 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_182 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_183 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X3:term, auto__q4 X3 -> auto__q1 X3 -> False. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro H. clear H. intro H. clear H. intro Hrec. intro H. clear H. intro H. clear H. intros X3.
  cut (auto__q4 X3 -> auto__q1 X3 -> False). tauto. exact (Hrec X3).
Defined.

Remark rem_184 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X3 -> auto__q1 X3 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_183 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X3).
Defined.

Remark rem_185 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_45 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_186 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_187 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_188 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_45 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_189 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_190 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_191 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_192 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_193 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q2 X3 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X3 -> auto__q2 X3 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_103 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X3).
Defined.

Remark rem_194 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X3 -> auto__q3 X3 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_115 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X3).
Defined.

Remark rem_195 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_176 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_196 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_176 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_197 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_198 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_45 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_199 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_200 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_201 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_202 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_203 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_204 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_205 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (nonceb_current X1 X2 X3) -> auto__q1 X1 -> auto__q4 X2 -> auto__q4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_91 X1 X2 X3 H);  intros.
  apply (rem_174 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_175 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_177 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_178 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_179 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_180 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_181 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_120 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_182 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_184 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_185 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_186 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_187 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_133 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_188 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_189 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_190 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_121 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_105 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_191 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_192 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_193 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_194 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_195 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_196 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_197 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_198 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_199 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_200 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_201 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_109 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_202 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_127 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_128 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_203 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_204 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_206 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q2 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_106 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_207 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q1 X3 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_95 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_208 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_101 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_209 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_210 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_211 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q2 X3 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_212 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q2 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_106 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_213 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_214 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_215 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_216 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_101 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_217 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X3 -> auto__q3 X3 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_115 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X3).
Defined.

Remark rem_218 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q1 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_219 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_220 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_221 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_95 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_222 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q1 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q2 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_106 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_223 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_224 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_225 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q4 X1 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_226 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_227 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q1 X3 -> auto__q4 X1 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_228 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q4 X1 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_229 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (nonceb_current X1 X2 X3) -> auto__q2 X1 -> auto__q2 X2 -> auto__q4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_91 X1 X2 X3 H);  intros.
  apply (rem_206 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_207 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_124 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_208 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_209 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_210 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_97 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_211 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_212 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_126 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_113 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_213 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_214 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_170 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_215 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_216 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_136 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_117 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_217 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_218 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_219 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_114 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_105 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_220 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_94 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_221 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_142 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_222 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_223 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_224 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_225 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_226 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_227 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_228 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_166 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_168 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_230 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q2 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_176 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_231 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X3:term, auto__q2 X3 -> auto__q1 X3 -> False. (* Use induction hypothesis. *)
Proof.
   intro Hrec. intro H. clear H. intro H. clear H. intro H. clear H. intro H. clear H. intro H. clear H. intros X3.
  cut (auto__q2 X3 -> auto__q1 X3 -> False). tauto. exact (Hrec X3).
Defined.

Remark rem_232 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X3 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q1 X3 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_231 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X3).
Defined.

Remark rem_233 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_234 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X2:term, auto__q3 X2 -> auto__q1 X2 -> False. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro H. clear H. intro H. clear H. intro H. clear H. intro Hrec. intro H. clear H. intros X2.
  cut (auto__q3 X2 -> auto__q1 X2 -> False). tauto. exact (Hrec X2).
Defined.

Remark rem_235 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_234 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_236 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_237 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_238 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_239 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_240 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q2 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_176 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_241 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q2 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_242 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_243 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_244 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_245 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_246 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_234 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_247 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q2 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_176 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_248 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_249 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_250 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_251 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_252 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_253 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_254 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q3 X3 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_154 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X3).
Defined.

Remark rem_255 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_256 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X3 -> auto__q2 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_176 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_257 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_258 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_259 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_260 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_261 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_262 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (nonceb_current X1 X2 X3) -> auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_91 X1 X2 X3 H);  intros.
  apply (rem_230 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_232 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_233 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_235 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_236 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_237 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_238 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_239 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_240 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_241 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_242 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_243 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_244 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_172 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_245 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_246 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_247 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_138 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_162 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_248 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_249 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_250 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_251 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_252 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_253 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_254 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_255 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_256 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_257 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_258 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_148 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_259 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_156 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_168 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_260 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_261 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Inductive or_6(H1 H2 H3 H4 H5 H6:Prop) : Prop :=
    or_6_intro_1 : H1 -> (or_6 H1 H2 H3 H4 H5 H6)
  | or_6_intro_2 : H2 -> (or_6 H1 H2 H3 H4 H5 H6)
  | or_6_intro_3 : H3 -> (or_6 H1 H2 H3 H4 H5 H6)
  | or_6_intro_4 : H4 -> (or_6 H1 H2 H3 H4 H5 H6)
  | or_6_intro_5 : H5 -> (or_6 H1 H2 H3 H4 H5 H6)
  | or_6_intro_6 : H6 -> (or_6 H1 H2 H3 H4 H5 H6)
.

Remark rem_263 : forall X1 X2 X3:term, auto__q3 (nonceb_current X1 X2 X3) -> or_6
    (auto__q3 X1 /\ auto__q4 X2 /\ auto__q1 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q4 X3)
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q4 X2 /\ auto__q4 X3)
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q4 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q2 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_6_intro_1; tauto.
  intros. apply or_6_intro_2; tauto.
  intros. apply or_6_intro_3; tauto.
  intros. apply or_6_intro_4; tauto.
  intros. apply or_6_intro_5; tauto.
  intros. apply or_6_intro_6; tauto.
Qed.

Remark rem_264 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 (nonceb_current X1 X2 X3) -> auto__q1 (nonceb_current X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_263 X1 X2 X3 H);  intros.
  apply (rem_92 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_135 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_173 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_205 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_229 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_262 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_265 : forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_266 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q2 X1 -> auto__q4 X2 -> auto__q4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_267 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_268 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q3 X1 -> auto__q4 X2 -> auto__q4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_269 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q2 X1 -> auto__q1 X2 -> auto__q1 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_270 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q1 X1 -> auto__q1 X2 -> auto__q3 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_271 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_272 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q3 X1 -> auto__q4 X2 -> auto__q1 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_273 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q2 X1 -> auto__q3 X2 -> auto__q4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_274 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q4 X1 -> auto__q3 X2 -> auto__q4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_275 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_276 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q1 X1 -> auto__q3 X2 -> auto__q4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_277 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q3 X1 -> auto__q1 X2 -> auto__q4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_278 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q1 X1 -> auto__q2 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_279 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q3 X1 -> auto__q2 X2 -> auto__q4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_280 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_281 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q1 X1 -> auto__q2 X2 -> auto__q4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_282 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q2 X1 -> auto__q2 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_283 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q2 X1 -> auto__q4 X2 -> auto__q3 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_284 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_285 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q1 X1 -> auto__q4 X2 -> auto__q1 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_286 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_287 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q4 X1 -> auto__q4 X2 -> auto__q3 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_288 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q4 X1 -> auto__q3 X2 -> auto__q1 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_289 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q4 X1 -> auto__q1 X2 -> auto__q3 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_290 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q1 X1 -> auto__q4 X2 -> auto__q4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_291 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q4 X1 -> auto__q2 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_292 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q1 X1 -> auto__q3 X2 -> auto__q3 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_293 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q2 X1 -> auto__q3 X2 -> auto__q1 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_294 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q2 X1 -> auto__q2 X2 -> auto__q4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_295 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q2 X1 -> auto__q4 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_296 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q1 X1 -> auto__q2 X2 -> auto__q3 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_297 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q2 X1 -> auto__q2 X2 -> auto__q3 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_298 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q4 X1 -> auto__q1 X2 -> auto__q1 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_299 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q4 X1 -> auto__q3 X2 -> auto__q3 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_300 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q1 X1 -> auto__q4 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_301 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q1 X1 -> auto__q4 X2 -> auto__q3 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_302 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q1 X1 -> auto__q1 X2 -> auto__q4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_303 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q1 X1 -> auto__q1 X2 -> auto__q1 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_304 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q2 X1 -> auto__q3 X2 -> auto__q3 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_305 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_306 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q2 X1 -> auto__q1 X2 -> auto__q4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_307 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_308 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q2 X1 -> auto__q3 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_309 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_310 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q2 X1 -> auto__q4 X2 -> auto__q1 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_311 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q3 X1 -> auto__q2 X2 -> auto__q3 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_312 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_313 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q1 X1 -> auto__q1 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_314 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q4 X1 -> auto__q4 X2 -> auto__q4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_315 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q4 X1 -> auto__q2 X2 -> auto__q3 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_316 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q3 X1 -> auto__q4 X2 -> auto__q3 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_317 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q3 X1 -> auto__q4 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_318 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q2 X1 -> auto__q1 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_319 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q4 X1 -> auto__q1 X2 -> auto__q4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_320 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q3 X1 -> auto__q3 X2 -> auto__q4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_321 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q3 X1 -> auto__q3 X2 -> auto__q1 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_322 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q4 X1 -> auto__q2 X2 -> auto__q1 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_323 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q2 X1 -> auto__q2 X2 -> auto__q1 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_324 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q4 X1 -> auto__q2 X2 -> auto__q4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_325 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_326 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_327 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_328 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Remark rem_329 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_old X1 X2 X3) -> auto__q4 X1 -> auto__q3 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_265 X1 X2 X3 H);  intros.
Defined.

Inductive or_64(H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64:Prop) : Prop :=
    or_64_intro_1 : H1 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_2 : H2 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_3 : H3 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_4 : H4 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_5 : H5 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_6 : H6 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_7 : H7 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_8 : H8 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_9 : H9 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_10 : H10 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_11 : H11 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_12 : H12 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_13 : H13 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_14 : H14 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_15 : H15 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_16 : H16 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_17 : H17 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_18 : H18 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_19 : H19 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_20 : H20 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_21 : H21 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_22 : H22 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_23 : H23 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_24 : H24 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_25 : H25 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_26 : H26 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_27 : H27 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_28 : H28 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_29 : H29 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_30 : H30 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_31 : H31 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_32 : H32 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_33 : H33 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_34 : H34 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_35 : H35 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_36 : H36 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_37 : H37 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_38 : H38 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_39 : H39 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_40 : H40 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_41 : H41 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_42 : H42 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_43 : H43 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_44 : H44 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_45 : H45 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_46 : H46 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_47 : H47 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_48 : H48 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_49 : H49 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_50 : H50 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_51 : H51 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_52 : H52 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_53 : H53 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_54 : H54 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_55 : H55 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_56 : H56 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_57 : H57 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_58 : H58 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_59 : H59 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_60 : H60 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_61 : H61 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_62 : H62 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_63 : H63 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
  | or_64_intro_64 : H64 -> (or_64 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23 H24 H25 H26 H27 H28 H29 H30 H31 H32 H33 H34 H35 H36 H37 H38 H39 H40 H41 H42 H43 H44 H45 H46 H47 H48 H49 H50 H51 H52 H53 H54 H55 H56 H57 H58 H59 H60 H61 H62 H63 H64)
.

Remark rem_330 : forall X1 X2 X3:term, auto__q3 (session_old X1 X2 X3) -> or_64
    (auto__q2 X1 /\ auto__q4 X2 /\ auto__q4 X3)
    (auto__q3 X1 /\ auto__q1 X2 /\ auto__q1 X3)
    (auto__q3 X1 /\ auto__q4 X2 /\ auto__q4 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q1 X3)
    (auto__q1 X1 /\ auto__q1 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q3 X1 /\ auto__q4 X2 /\ auto__q1 X3)
    (auto__q2 X1 /\ auto__q3 X2 /\ auto__q4 X3)
    (auto__q4 X1 /\ auto__q3 X2 /\ auto__q4 X3)
    (auto__q3 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q4 X3)
    (auto__q3 X1 /\ auto__q1 X2 /\ auto__q4 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q4 X3)
    (auto__q3 X1 /\ auto__q1 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q4 X3)
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q2 X1 /\ auto__q4 X2 /\ auto__q3 X3)
    (auto__q3 X1 /\ auto__q3 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q4 X2 /\ auto__q1 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q1 X3)
    (auto__q4 X1 /\ auto__q4 X2 /\ auto__q3 X3)
    (auto__q4 X1 /\ auto__q3 X2 /\ auto__q1 X3)
    (auto__q4 X1 /\ auto__q1 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q4 X2 /\ auto__q4 X3)
    (auto__q4 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q3 X2 /\ auto__q1 X3)
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q4 X3)
    (auto__q2 X1 /\ auto__q4 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q3 X3)
    (auto__q4 X1 /\ auto__q1 X2 /\ auto__q1 X3)
    (auto__q4 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q4 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q4 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q1 X2 /\ auto__q4 X3)
    (auto__q1 X1 /\ auto__q1 X2 /\ auto__q1 X3)
    (auto__q2 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q4 X3)
    (auto__q3 X1 /\ auto__q1 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q3 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q2 X3)
    (auto__q2 X1 /\ auto__q4 X2 /\ auto__q1 X3)
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q3 X3)
    (auto__q4 X1 /\ auto__q4 X2 /\ auto__q1 X3)
    (auto__q1 X1 /\ auto__q1 X2 /\ auto__q2 X3)
    (auto__q4 X1 /\ auto__q4 X2 /\ auto__q4 X3)
    (auto__q4 X1 /\ auto__q2 X2 /\ auto__q3 X3)
    (auto__q3 X1 /\ auto__q4 X2 /\ auto__q3 X3)
    (auto__q3 X1 /\ auto__q4 X2 /\ auto__q2 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q2 X3)
    (auto__q4 X1 /\ auto__q1 X2 /\ auto__q4 X3)
    (auto__q3 X1 /\ auto__q3 X2 /\ auto__q4 X3)
    (auto__q3 X1 /\ auto__q3 X2 /\ auto__q1 X3)
    (auto__q4 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q2 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q4 X1 /\ auto__q2 X2 /\ auto__q4 X3)
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q4 X1 /\ auto__q4 X2 /\ auto__q2 X3)
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q4 X1 /\ auto__q1 X2 /\ auto__q2 X3)
    (auto__q4 X1 /\ auto__q3 X2 /\ auto__q2 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_64_intro_1; tauto.
  intros. apply or_64_intro_2; tauto.
  intros. apply or_64_intro_3; tauto.
  intros. apply or_64_intro_4; tauto.
  intros. apply or_64_intro_5; tauto.
  intros. apply or_64_intro_6; tauto.
  intros. apply or_64_intro_7; tauto.
  intros. apply or_64_intro_8; tauto.
  intros. apply or_64_intro_9; tauto.
  intros. apply or_64_intro_10; tauto.
  intros. apply or_64_intro_11; tauto.
  intros. apply or_64_intro_12; tauto.
  intros. apply or_64_intro_13; tauto.
  intros. apply or_64_intro_14; tauto.
  intros. apply or_64_intro_15; tauto.
  intros. apply or_64_intro_16; tauto.
  intros. apply or_64_intro_17; tauto.
  intros. apply or_64_intro_18; tauto.
  intros. apply or_64_intro_19; tauto.
  intros. apply or_64_intro_20; tauto.
  intros. apply or_64_intro_21; tauto.
  intros. apply or_64_intro_22; tauto.
  intros. apply or_64_intro_23; tauto.
  intros. apply or_64_intro_24; tauto.
  intros. apply or_64_intro_25; tauto.
  intros. apply or_64_intro_26; tauto.
  intros. apply or_64_intro_27; tauto.
  intros. apply or_64_intro_28; tauto.
  intros. apply or_64_intro_29; tauto.
  intros. apply or_64_intro_30; tauto.
  intros. apply or_64_intro_31; tauto.
  intros. apply or_64_intro_32; tauto.
  intros. apply or_64_intro_33; tauto.
  intros. apply or_64_intro_34; tauto.
  intros. apply or_64_intro_35; tauto.
  intros. apply or_64_intro_36; tauto.
  intros. apply or_64_intro_37; tauto.
  intros. apply or_64_intro_38; tauto.
  intros. apply or_64_intro_39; tauto.
  intros. apply or_64_intro_40; tauto.
  intros. apply or_64_intro_41; tauto.
  intros. apply or_64_intro_42; tauto.
  intros. apply or_64_intro_43; tauto.
  intros. apply or_64_intro_44; tauto.
  intros. apply or_64_intro_45; tauto.
  intros. apply or_64_intro_46; tauto.
  intros. apply or_64_intro_47; tauto.
  intros. apply or_64_intro_48; tauto.
  intros. apply or_64_intro_49; tauto.
  intros. apply or_64_intro_50; tauto.
  intros. apply or_64_intro_51; tauto.
  intros. apply or_64_intro_52; tauto.
  intros. apply or_64_intro_53; tauto.
  intros. apply or_64_intro_54; tauto.
  intros. apply or_64_intro_55; tauto.
  intros. apply or_64_intro_56; tauto.
  intros. apply or_64_intro_57; tauto.
  intros. apply or_64_intro_58; tauto.
  intros. apply or_64_intro_59; tauto.
  intros. apply or_64_intro_60; tauto.
  intros. apply or_64_intro_61; tauto.
  intros. apply or_64_intro_62; tauto.
  intros. apply or_64_intro_63; tauto.
  intros. apply or_64_intro_64; tauto.
Qed.

Remark rem_331 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 (session_old X1 X2 X3) -> auto__q1 (session_old X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_330 X1 X2 X3 H);  intros.
  apply (rem_266 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_267 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_268 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_269 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_270 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_271 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_272 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_273 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_274 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_275 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_276 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_277 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_278 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_279 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_280 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_281 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_282 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_283 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_284 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_285 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_286 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_287 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_288 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_289 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_290 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_291 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_292 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_293 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_294 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_295 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_296 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_297 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_298 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_299 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_300 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_301 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_302 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_303 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_304 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_305 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_306 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_307 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_308 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_309 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_310 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_311 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_312 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_313 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_314 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_315 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_316 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_317 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_318 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_319 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_320 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_321 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_322 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_323 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_324 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_325 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_326 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_327 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_328 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_329 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_332 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X1 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_333 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_334 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_335 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X1 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Inductive or_4(H1 H2 H3 H4:Prop) : Prop :=
    or_4_intro_1 : H1 -> (or_4 H1 H2 H3 H4)
  | or_4_intro_2 : H2 -> (or_4 H1 H2 H3 H4)
  | or_4_intro_3 : H3 -> (or_4 H1 H2 H3 H4)
  | or_4_intro_4 : H4 -> (or_4 H1 H2 H3 H4)
.

Remark rem_336 : forall X1 X2:term, auto__q1 (crypt X1 X2) -> or_4
    (auto__q1 X1 /\ auto__q4 X2)
    (auto__q2 X1 /\ auto__q2 X2)
    (auto__q1 X1 /\ auto__q1 X2)
    (auto__q1 X1 /\ auto__q2 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_4_intro_1; tauto.
  intros. apply or_4_intro_2; tauto.
  intros. apply or_4_intro_3; tauto.
  intros. apply or_4_intro_4; tauto.
Qed.

Remark rem_337 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 (crypt X1 X2) -> auto__q3 X1 -> auto__q1 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2. intro H. intros.
  elim (rem_336 X1 X2 H);  intros.
  apply (rem_332 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_333 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_334 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_335 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
Defined.

Remark rem_338 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_339 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_340 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_341 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_342 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 (crypt X1 X2) -> auto__q4 X1 -> auto__q1 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2. intro H. intros.
  elim (rem_336 X1 X2 H);  intros.
  apply (rem_338 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_339 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_340 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_341 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
Defined.

Remark rem_343 : forall X1 X2:term, auto__q3 (crypt X1 X2) -> or_2
    (auto__q3 X1 /\ auto__q1 X2)
    (auto__q4 X1 /\ auto__q1 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_344 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q3 (crypt X1 X2) -> auto__q1 (crypt X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2. intro H. intros.
  elim (rem_343 X1 X2 H);  intros.
  apply (rem_337 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_342 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
Defined.

Remark rem_345 : forall X1 X2:term, auto__q1 (cons X1 X2) -> or_1
    (auto__q1 X1 /\ auto__q1 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_346 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 (cons X1 X2) -> auto__q2 X1 -> auto__q4 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2. intro H. intros.
  elim (rem_345 X1 X2 H);  intros.
  apply (rem_47 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
Defined.

Remark rem_347 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_348 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 (cons X1 X2) -> auto__q4 X1 -> auto__q3 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2. intro H. intros.
  elim (rem_345 X1 X2 H);  intros.
  apply (rem_347 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
Defined.

Remark rem_349 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q4 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_176 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_350 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 (cons X1 X2) -> auto__q1 X1 -> auto__q4 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2. intro H. intros.
  elim (rem_345 X1 X2 H);  intros.
  apply (rem_349 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
Defined.

Remark rem_351 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 (cons X1 X2) -> auto__q3 X1 -> auto__q4 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2. intro H. intros.
  elim (rem_345 X1 X2 H);  intros.
  apply (rem_332 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
Defined.

Remark rem_352 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 (cons X1 X2) -> auto__q4 X1 -> auto__q4 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2. intro H. intros.
  elim (rem_345 X1 X2 H);  intros.
  apply (rem_338 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
Defined.

Remark rem_353 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 (cons X1 X2) -> auto__q4 X1 -> auto__q2 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2. intro H. intros.
  elim (rem_345 X1 X2 H);  intros.
  apply (rem_341 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
Defined.

Remark rem_354 : forall X1 X2:term, auto__q3 (cons X1 X2) -> or_6
    (auto__q2 X1 /\ auto__q4 X2)
    (auto__q4 X1 /\ auto__q3 X2)
    (auto__q1 X1 /\ auto__q4 X2)
    (auto__q3 X1 /\ auto__q4 X2)
    (auto__q4 X1 /\ auto__q4 X2)
    (auto__q4 X1 /\ auto__q2 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_6_intro_1; tauto.
  intros. apply or_6_intro_2; tauto.
  intros. apply or_6_intro_3; tauto.
  intros. apply or_6_intro_4; tauto.
  intros. apply or_6_intro_5; tauto.
  intros. apply or_6_intro_6; tauto.
Qed.

Remark rem_355 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q3 (cons X1 X2) -> auto__q1 (cons X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2. intro H. intros.
  elim (rem_354 X1 X2 H);  intros.
  apply (rem_346 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_348 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_350 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_351 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_352 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_353 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
Defined.

Remark rem_356 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Inductive or_10(H1 H2 H3 H4 H5 H6 H7 H8 H9 H10:Prop) : Prop :=
    or_10_intro_1 : H1 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_2 : H2 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_3 : H3 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_4 : H4 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_5 : H5 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_6 : H6 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_7 : H7 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_8 : H8 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_9 : H9 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_10 : H10 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
.

Remark rem_357 : forall X1 X2 X3:term, auto__q1 (session_current X1 X2 X3) -> or_10
    (auto__q2 X1 /\ auto__q4 X2 /\ auto__q4 X3)
    (auto__q1 X1 /\ auto__q1 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q3 X2 /\ auto__q4 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q4 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q4 X3)
    (auto__q2 X1 /\ auto__q4 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q3 X2 /\ auto__q1 X3)
    (auto__q2 X1 /\ auto__q4 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q2 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q4 X2 /\ auto__q1 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_10_intro_1; tauto.
  intros. apply or_10_intro_2; tauto.
  intros. apply or_10_intro_3; tauto.
  intros. apply or_10_intro_4; tauto.
  intros. apply or_10_intro_5; tauto.
  intros. apply or_10_intro_6; tauto.
  intros. apply or_10_intro_7; tauto.
  intros. apply or_10_intro_8; tauto.
  intros. apply or_10_intro_9; tauto.
  intros. apply or_10_intro_10; tauto.
Qed.

Remark rem_358 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_current X1 X2 X3) -> auto__q3 X1 -> auto__q4 X2 -> auto__q1 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_357 X1 X2 X3 H);  intros.
  apply (rem_53 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_56 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_57 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_61 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_356 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_63 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_70 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_71 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_72 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_82 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_359 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_360 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_361 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_362 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q4 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_363 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_364 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_365 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_366 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_367 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_current X1 X2 X3) -> auto__q4 X1 -> auto__q3 X2 -> auto__q4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_357 X1 X2 X3 H);  intros.
  apply (rem_359 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_360 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_361 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_362 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_99 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_363 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_364 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_365 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_119 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_366 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_368 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_369 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q3 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_370 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_371 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_372 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_373 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_374 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_375 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_376 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_377 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_current X1 X2 X3) -> auto__q3 X1 -> auto__q3 X2 -> auto__q3 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_357 X1 X2 X3 H);  intros.
  apply (rem_368 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_369 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_370 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_371 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_100 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_372 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_373 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_374 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_375 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_376 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_378 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_379 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q2 X3 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_380 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_381 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_382 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_383 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_384 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_385 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_386 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_387 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q2 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_388 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_current X1 X2 X3) -> auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_357 X1 X2 X3 H);  intros.
  apply (rem_378 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_379 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_380 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_381 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_382 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_383 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_384 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_385 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_386 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_387 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_389 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_390 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_391 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_392 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_393 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_394 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_395 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_396 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_397 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_398 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_current X1 X2 X3) -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_357 X1 X2 X3 H);  intros.
  apply (rem_389 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_390 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_391 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_392 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_393 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_374 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_394 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_395 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_396 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_397 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_399 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_176 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_400 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_401 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_402 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_403 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q2 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_106 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_404 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_405 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_current X1 X2 X3) -> auto__q1 X1 -> auto__q4 X2 -> auto__q1 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_357 X1 X2 X3 H);  intros.
  apply (rem_199 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_399 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_189 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_185 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_107 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_400 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_401 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_402 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_403 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_404 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_406 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_234 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_407 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_408 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q3 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X3 -> auto__q1 X3 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_183 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X3).
Defined.

Remark rem_409 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_410 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_411 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_412 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_101 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_413 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_current X1 X2 X3) -> auto__q1 X1 -> auto__q3 X2 -> auto__q1 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_357 X1 X2 X3 H);  intros.
  apply (rem_189 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_406 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_407 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_408 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_108 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_409 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_410 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_411 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_412 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_401 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_414 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_415 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_416 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_417 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_418 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_419 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_420 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_421 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_current X1 X2 X3) -> auto__q4 X1 -> auto__q1 X2 -> auto__q3 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_357 X1 X2 X3 H);  intros.
  apply (rem_414 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_415 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_416 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_360 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_110 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_417 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_418 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_243 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_419 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_420 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_422 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q2 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_106 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_423 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_current X1 X2 X3) -> auto__q1 X1 -> auto__q4 X2 -> auto__q4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_357 X1 X2 X3 H);  intros.
  apply (rem_174 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_177 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_178 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_181 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_422 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_182 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_189 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_190 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_121 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_199 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_424 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_176 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_425 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_426 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_427 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_428 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q2 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_106 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_429 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_current X1 X2 X3) -> auto__q1 X1 -> auto__q4 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_357 X1 X2 X3 H);  intros.
  apply (rem_190 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_424 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_425 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_198 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_120 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_426 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_411 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_427 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_428 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_402 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_430 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_176 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_431 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_432 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_433 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q2 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_106 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_434 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_current X1 X2 X3) -> auto__q1 X1 -> auto__q4 X2 -> auto__q3 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_357 X1 X2 X3 H);  intros.
  apply (rem_182 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_430 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_431 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_188 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_121 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_432 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_409 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_426 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_433 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_400 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_435 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_176 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_436 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_437 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_234 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_438 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_439 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_176 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_440 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_234 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_441 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_442 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_176 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_443 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_current X1 X2 X3) -> auto__q2 X1 -> auto__q1 X2 -> auto__q3 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_357 X1 X2 X3 H);  intros.
  apply (rem_435 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_436 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_437 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_438 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_124 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_439 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_440 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_240 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_441 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_442 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_444 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_234 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_445 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_446 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q2 X3 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X3 -> auto__q2 X3 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_103 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X3).
Defined.

Remark rem_447 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_448 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_449 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_39 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_450 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_101 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_451 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_current X1 X2 X3) -> auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_357 X1 X2 X3 H);  intros.
  apply (rem_425 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_444 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_445 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_446 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_125 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_447 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_448 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_449 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_450 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_411 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_452 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_453 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_454 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_455 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_456 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_457 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_458 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_459 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_460 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_current X1 X2 X3) -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_357 X1 X2 X3 H);  intros.
  apply (rem_452 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_453 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_366 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_454 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_127 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_455 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_456 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_457 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_458 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_459 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_461 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X1 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_462 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_463 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_464 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_465 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_466 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_467 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_current X1 X2 X3) -> auto__q3 X1 -> auto__q4 X2 -> auto__q3 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_357 X1 X2 X3 H);  intros.
  apply (rem_461 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_462 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_368 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_180 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_463 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_464 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_376 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_465 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_466 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_63 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_468 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_469 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_470 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_471 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_472 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_473 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_474 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_current X1 X2 X3) -> auto__q3 X1 -> auto__q4 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_357 X1 X2 X3 H);  intros.
  apply (rem_468 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_469 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_389 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_470 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_471 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_465 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_397 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_472 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_473 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_71 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_475 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_476 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_477 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_478 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_479 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_480 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_481 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_current X1 X2 X3) -> auto__q3 X1 -> auto__q3 X2 -> auto__q4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_357 X1 X2 X3 H);  intros.
  apply (rem_475 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_476 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_477 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_478 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_479 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_368 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_480 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_389 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_100 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_57 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_482 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_483 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_484 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_485 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_486 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_487 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_current X1 X2 X3) -> auto__q3 X1 -> auto__q3 X2 -> auto__q1 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_357 X1 X2 X3 H);  intros.
  apply (rem_57 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_482 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_480 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_483 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_484 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_376 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_485 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_397 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_486 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_70 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_488 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_489 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_current X1 X2 X3) -> auto__q4 X1 -> auto__q2 X2 -> auto__q4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_357 X1 X2 X3 H);  intros.
  apply (rem_224 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_110 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_209 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_99 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_132 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_213 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_488 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_166 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_129 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_223 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_490 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_491 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_492 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_493 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_494 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_495 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_496 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_497 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_498 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_current X1 X2 X3) -> auto__q3 X1 -> auto__q2 X2 -> auto__q1 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_357 X1 X2 X3 H);  intros.
  apply (rem_490 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_491 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_492 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_484 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_493 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_73 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_494 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_495 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_496 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_497 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_499 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_500 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_501 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_502 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_503 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_504 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_37 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_505 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q2 X3 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_55 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_506 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_current X1 X2 X3) -> auto__q3 X1 -> auto__q2 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_357 X1 X2 X3 H);  intros.
  apply (rem_499 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_386 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_500 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_393 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_501 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_502 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_503 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_504 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_505 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_495 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_507 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_508 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_509 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_510 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_511 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_current X1 X2 X3) -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_357 X1 X2 X3 H);  intros.
  apply (rem_258 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_507 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_236 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_508 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_134 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_243 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_509 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_260 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_510 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_257 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_512 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_513 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_514 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_515 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_516 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_517 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_518 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_519 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_98 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_520 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_35 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_521 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (session_current X1 X2 X3) -> auto__q4 X1 -> auto__q3 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_357 X1 X2 X3 H);  intros.
  apply (rem_365 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_512 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_513 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_514 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_515 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_516 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_517 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_518 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_519 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_520 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Inductive or_23(H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23:Prop) : Prop :=
    or_23_intro_1 : H1 -> (or_23 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23)
  | or_23_intro_2 : H2 -> (or_23 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23)
  | or_23_intro_3 : H3 -> (or_23 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23)
  | or_23_intro_4 : H4 -> (or_23 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23)
  | or_23_intro_5 : H5 -> (or_23 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23)
  | or_23_intro_6 : H6 -> (or_23 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23)
  | or_23_intro_7 : H7 -> (or_23 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23)
  | or_23_intro_8 : H8 -> (or_23 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23)
  | or_23_intro_9 : H9 -> (or_23 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23)
  | or_23_intro_10 : H10 -> (or_23 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23)
  | or_23_intro_11 : H11 -> (or_23 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23)
  | or_23_intro_12 : H12 -> (or_23 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23)
  | or_23_intro_13 : H13 -> (or_23 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23)
  | or_23_intro_14 : H14 -> (or_23 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23)
  | or_23_intro_15 : H15 -> (or_23 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23)
  | or_23_intro_16 : H16 -> (or_23 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23)
  | or_23_intro_17 : H17 -> (or_23 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23)
  | or_23_intro_18 : H18 -> (or_23 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23)
  | or_23_intro_19 : H19 -> (or_23 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23)
  | or_23_intro_20 : H20 -> (or_23 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23)
  | or_23_intro_21 : H21 -> (or_23 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23)
  | or_23_intro_22 : H22 -> (or_23 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23)
  | or_23_intro_23 : H23 -> (or_23 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16 H17 H18 H19 H20 H21 H22 H23)
.

Remark rem_522 : forall X1 X2 X3:term, auto__q3 (session_current X1 X2 X3) -> or_23
    (auto__q3 X1 /\ auto__q4 X2 /\ auto__q1 X3)
    (auto__q4 X1 /\ auto__q3 X2 /\ auto__q4 X3)
    (auto__q3 X1 /\ auto__q3 X2 /\ auto__q3 X3)
    (auto__q3 X1 /\ auto__q1 X2 /\ auto__q2 X3)
    (auto__q3 X1 /\ auto__q3 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q4 X2 /\ auto__q1 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q1 X3)
    (auto__q4 X1 /\ auto__q1 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q4 X2 /\ auto__q4 X3)
    (auto__q1 X1 /\ auto__q4 X2 /\ auto__q2 X3)
    (auto__q1 X1 /\ auto__q4 X2 /\ auto__q3 X3)
    (auto__q2 X1 /\ auto__q1 X2 /\ auto__q3 X3)
    (auto__q1 X1 /\ auto__q3 X2 /\ auto__q2 X3)
    (auto__q4 X1 /\ auto__q4 X2 /\ auto__q1 X3)
    (auto__q3 X1 /\ auto__q4 X2 /\ auto__q3 X3)
    (auto__q3 X1 /\ auto__q4 X2 /\ auto__q2 X3)
    (auto__q3 X1 /\ auto__q3 X2 /\ auto__q4 X3)
    (auto__q3 X1 /\ auto__q3 X2 /\ auto__q1 X3)
    (auto__q4 X1 /\ auto__q2 X2 /\ auto__q4 X3)
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q1 X3)
    (auto__q3 X1 /\ auto__q2 X2 /\ auto__q2 X3)
    (auto__q4 X1 /\ auto__q1 X2 /\ auto__q2 X3)
    (auto__q4 X1 /\ auto__q3 X2 /\ auto__q2 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_23_intro_1; tauto.
  intros. apply or_23_intro_2; tauto.
  intros. apply or_23_intro_3; tauto.
  intros. apply or_23_intro_4; tauto.
  intros. apply or_23_intro_5; tauto.
  intros. apply or_23_intro_6; tauto.
  intros. apply or_23_intro_7; tauto.
  intros. apply or_23_intro_8; tauto.
  intros. apply or_23_intro_9; tauto.
  intros. apply or_23_intro_10; tauto.
  intros. apply or_23_intro_11; tauto.
  intros. apply or_23_intro_12; tauto.
  intros. apply or_23_intro_13; tauto.
  intros. apply or_23_intro_14; tauto.
  intros. apply or_23_intro_15; tauto.
  intros. apply or_23_intro_16; tauto.
  intros. apply or_23_intro_17; tauto.
  intros. apply or_23_intro_18; tauto.
  intros. apply or_23_intro_19; tauto.
  intros. apply or_23_intro_20; tauto.
  intros. apply or_23_intro_21; tauto.
  intros. apply or_23_intro_22; tauto.
  intros. apply or_23_intro_23; tauto.
Qed.

Remark rem_523 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q3 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 (session_current X1 X2 X3) -> auto__q1 (session_current X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_522 X1 X2 X3 H);  intros.
  apply (rem_358 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_367 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_377 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_388 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_398 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_405 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_413 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_421 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_423 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_429 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_434 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_443 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_451 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_460 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_467 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_474 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_481 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_487 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_489 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_498 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_506 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_511 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_521 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_524 : auto__q3 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_525 : auto__q3 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_526 : auto__q3 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_527 : forall X1 X2:term, auto__q3 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_528 : forall X1 X2 X3:term, auto__q3 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_529 : auto__q3 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_530 : auto__q3 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_531 : auto__q3 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_532 : auto__q3 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_533 : forall X1 X2:term, auto__q3 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_534 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X2:term, auto__q3 X2 -> auto__q1 X2 -> False. (* Induct. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. fix epsilon_m_q3_m_q1 1.
  intro X. case X.
   intro H. elim (rem_6  H).
   intro H. elim (rem_531  H).
  intros X1 X2;  exact (rem_355 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2).
  intros X1 X2;  exact (rem_344 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2).
   intro H. elim (rem_525  H).
  intros X1 X2;  exact (rem_52 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2).
   intro H. elim (rem_524  H).
  intros X1 X2. intro H. elim (rem_533 X1 X2 H).
  intros X1 X2. intro H. elim (rem_527 X1 X2 H).
  intros X1 X2 X3;  exact (rem_264 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3).
  intros X1 X2 X3. intro H. elim (rem_528 X1 X2 X3 H).
   intro H. elim (rem_529  H).
   intro H. elim (rem_530  H).
  intros X1. intro H. elim (rem_20 X1 H).
   intro H. elim (rem_526  H).
  intros X1 X2 X3;  exact (rem_523 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3).
  intros X1 X2 X3;  exact (rem_331 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3).
   intro H. elim (rem_532  H).
Defined.

Remark rem_535 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q3 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q3 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_534 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_536 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_537 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_538 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_539 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 (key X1 X2) -> auto__q2 X1 -> auto__q1 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2. intro H. intros.
  elim (rem_50 X1 X2 H);  intros.
  apply (rem_26 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_28 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_30 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_31 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_32 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_33 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_34 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_535 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_536 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_537 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_538 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
Defined.

Remark rem_540 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q3 X2 -> auto__q4 X1 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_541 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_542 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_543 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_544 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q3 X1 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_545 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q3 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_546 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q4 X1 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_547 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X2:term, auto__q2 X2 -> auto__q3 X2 -> False. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro H. clear H. intro Hrec. intro H. clear H. intro H. clear H. intros X2.
  cut (auto__q2 X2 -> auto__q3 X2 -> False). tauto. exact (Hrec X2).
Defined.

Remark rem_548 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q3 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q2 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_547 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_549 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q4 X1 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_550 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 X1 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_551 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q1 (key X1 X2) -> auto__q2 X1 -> auto__q2 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2. intro H. intros.
  elim (rem_50 X1 X2 H);  intros.
  apply (rem_540 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_541 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_542 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_543 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_544 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_545 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_546 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_548 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_538 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_549 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_550 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
Defined.

Remark rem_552 : forall X1 X2:term, auto__q4 (key X1 X2) -> or_2
    (auto__q2 X1 /\ auto__q1 X2)
    (auto__q2 X1 /\ auto__q2 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_553 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2:term, auto__q4 (key X1 X2) -> auto__q1 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2. intro H. intros.
  elim (rem_552 X1 X2 H);  intros.
  apply (rem_539 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
  apply (rem_551 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2);  tauto.
Defined.

Remark rem_554 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1:term, auto__q4 X1 -> auto__q1 X1 -> False. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro H. clear H. intro H. clear H. intro Hrec. intro H. clear H. intros X1.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). tauto. exact (Hrec X1).
Defined.

Remark rem_555 : forall X1:term, auto__q1 (s X1) -> or_1
    (auto__q1 X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_556 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1:term, auto__q1 (s X1) -> auto__q4 X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1. intro H. intros.
  elim (rem_555 X1 H);  intros.
  apply (rem_554 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1);  tauto.
Defined.

Remark rem_557 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1:term, auto__q3 X1 -> auto__q1 X1 -> False. (* Induct. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. fix epsilon_m_q3_m_q1 1.
  intro X. case X.
   intro H. elim (rem_6  H).
   intro H. elim (rem_531  H).
  intros X1 X2;  exact (rem_355 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2).
  intros X1 X2;  exact (rem_344 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2).
   intro H. elim (rem_525  H).
  intros X1 X2;  exact (rem_52 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2).
   intro H. elim (rem_524  H).
  intros X1 X2. intro H. elim (rem_533 X1 X2 H).
  intros X1 X2. intro H. elim (rem_527 X1 X2 H).
  intros X1 X2 X3;  exact (rem_264 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3).
  intros X1 X2 X3. intro H. elim (rem_528 X1 X2 X3 H).
   intro H. elim (rem_529  H).
   intro H. elim (rem_530  H).
  intros X1. intro H. elim (rem_20 X1 H).
   intro H. elim (rem_526  H).
  intros X1 X2 X3;  exact (rem_523 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3).
  intros X1 X2 X3;  exact (rem_331 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3).
   intro H. elim (rem_532  H).
Defined.

Remark rem_558 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1:term, auto__q1 (s X1) -> auto__q3 X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1. intro H. intros.
  elim (rem_555 X1 H);  intros.
  apply (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1);  tauto.
Defined.

Remark rem_559 : forall X1:term, auto__q4 (s X1) -> or_2
    (auto__q4 X1)    (auto__q3 X1).
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_560 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1:term, auto__q4 (s X1) -> auto__q1 (s X1) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1. intro H. intros.
  elim (rem_559 X1 H);  intros.
  apply (rem_556 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1);  tauto.
  apply (rem_558 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1);  tauto.
Defined.

Remark rem_561 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_562 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_563 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_564 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_565 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1:term, auto__q4 X1 -> auto__q3 X1 -> False. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro Hrec. intro H. clear H. intro H. clear H. intro H. clear H. intros X1.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). tauto. exact (Hrec X1).
Defined.

Remark rem_566 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_567 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_534 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_568 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_569 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_570 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_571 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_572 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_573 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_574 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_575 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_576 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_577 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_578 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q2 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_579 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_580 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_581 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_582 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_583 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q2 X3 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_584 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_585 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_586 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_587 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_588 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_589 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_590 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_591 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_592 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_593 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_594 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_595 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_596 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_597 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_598 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (nonceb_current X1 X2 X3) -> auto__q3 X1 -> auto__q1 X2 -> auto__q1 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_91 X1 X2 X3 H);  intros.
  apply (rem_561 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_562 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_563 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_564 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_566 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_567 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_568 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_569 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_570 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_571 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_572 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_573 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_574 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_575 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_576 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_577 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_578 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_579 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_580 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_581 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_582 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_583 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_584 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_585 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_586 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_587 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_588 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_589 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_590 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_591 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_592 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_593 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_594 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_595 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_596 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_597 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_599 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_600 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_601 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_602 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_603 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X2:term, auto__q4 X2 -> auto__q3 X2 -> False. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro Hrec. intro H. clear H. intro H. clear H. intro H. clear H. intros X2.
  cut (auto__q4 X2 -> auto__q3 X2 -> False). tauto. exact (Hrec X2).
Defined.

Remark rem_604 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_603 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_605 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_606 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_607 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X1 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_608 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_609 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_610 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X1 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_611 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X1 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_612 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_613 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_614 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_615 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_616 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_617 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X1 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_618 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_619 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_620 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_621 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_622 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_623 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X1 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_624 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_625 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_626 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_627 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_628 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X1 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_629 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_630 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_631 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_632 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_633 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_634 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (nonceb_current X1 X2 X3) -> auto__q3 X1 -> auto__q4 X2 -> auto__q4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_91 X1 X2 X3 H);  intros.
  apply (rem_599 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_561 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_600 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_601 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_602 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_604 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_605 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_606 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_607 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_608 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_609 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_610 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_611 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_612 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_613 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_614 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_615 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_616 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_617 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_591 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_618 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_619 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_620 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_621 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_622 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_623 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_624 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_625 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_626 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_627 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_628 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_629 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_630 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_631 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_632 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_633 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_635 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_636 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_637 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X2:term, auto__q2 X2 -> auto__q1 X2 -> False. (* Use induction hypothesis. *)
Proof.
   intro Hrec. intro H. clear H. intro H. clear H. intro H. clear H. intro H. clear H. intros X2.
  cut (auto__q2 X2 -> auto__q1 X2 -> False). tauto. exact (Hrec X2).
Defined.

Remark rem_638 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q1 X3 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_637 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_639 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_640 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_554 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_641 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_642 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_547 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_643 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X3:term, auto__q2 X3 -> auto__q1 X3 -> False. (* Use induction hypothesis. *)
Proof.
   intro Hrec. intro H. clear H. intro H. clear H. intro H. clear H. intro H. clear H. intros X3.
  cut (auto__q2 X3 -> auto__q1 X3 -> False). tauto. exact (Hrec X3).
Defined.

Remark rem_644 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q2 X3 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q1 X3 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_643 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X3).
Defined.

Remark rem_645 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_646 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X2:term, auto__q4 X2 -> auto__q2 X2 -> False. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro H. clear H. intro H. clear H. intro H. clear H. intro Hrec. intros X2.
  cut (auto__q4 X2 -> auto__q2 X2 -> False). tauto. exact (Hrec X2).
Defined.

Remark rem_647 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q2 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_646 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_648 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_547 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_649 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_554 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_650 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_554 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_651 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_554 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_652 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_547 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_653 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_654 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_655 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X3:term, auto__q3 X3 -> auto__q1 X3 -> False. (* Induct. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. fix epsilon_m_q3_m_q1 1.
  intro X. case X.
   intro H. elim (rem_6  H).
   intro H. elim (rem_531  H).
  intros X1 X2;  exact (rem_355 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2).
  intros X1 X2;  exact (rem_344 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2).
   intro H. elim (rem_525  H).
  intros X1 X2;  exact (rem_52 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2).
   intro H. elim (rem_524  H).
  intros X1 X2. intro H. elim (rem_533 X1 X2 H).
  intros X1 X2. intro H. elim (rem_527 X1 X2 H).
  intros X1 X2 X3;  exact (rem_264 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3).
  intros X1 X2 X3. intro H. elim (rem_528 X1 X2 X3 H).
   intro H. elim (rem_529  H).
   intro H. elim (rem_530  H).
  intros X1. intro H. elim (rem_20 X1 H).
   intro H. elim (rem_526  H).
  intros X1 X2 X3;  exact (rem_523 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3).
  intros X1 X2 X3;  exact (rem_331 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q3_m_q1 epsilon_m_q4_m_q2 X1 X2 X3).
   intro H. elim (rem_532  H).
Defined.

Remark rem_656 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q1 X3 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q1 X3 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_655 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X3).
Defined.

Remark rem_657 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q1 X3 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_658 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_554 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_659 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_554 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_660 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q2 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_646 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_661 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q2 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_646 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_662 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_637 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_663 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_637 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_664 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q1 X3 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_665 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_547 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_666 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_667 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_554 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_668 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_554 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_669 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_554 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_670 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_554 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_671 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_554 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_672 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_554 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_673 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_554 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_674 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_554 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_675 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (nonceb_current X1 X2 X3) -> auto__q1 X1 -> auto__q2 X2 -> auto__q1 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_91 X1 X2 X3 H);  intros.
  apply (rem_635 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_636 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_638 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_639 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_640 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_641 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_642 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_644 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_645 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_647 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_648 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_649 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_650 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_651 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_652 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_653 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_654 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_656 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_657 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_658 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_659 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_660 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_661 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_662 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_663 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_664 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_665 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_666 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_667 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_668 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_669 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_670 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_671 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_672 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_673 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_674 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_676 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_677 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_678 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_679 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_680 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_681 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_534 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_682 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_683 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_684 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X1 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_685 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_686 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_687 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_688 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_689 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X1 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_690 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_691 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_692 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_693 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X1 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_694 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_695 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X1 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_696 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_697 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_698 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_699 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (nonceb_current X1 X2 X3) -> auto__q3 X1 -> auto__q1 X2 -> auto__q4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_91 X1 X2 X3 H);  intros.
  apply (rem_676 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_677 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_678 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_679 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_680 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_681 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_682 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_683 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_623 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_622 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_568 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_611 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_684 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_685 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_686 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_564 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_687 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_688 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_689 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_593 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_690 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_691 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_600 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_692 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_585 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_693 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_694 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_561 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_591 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_629 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_695 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_696 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_595 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_697 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_633 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_698 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_700 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_701 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_702 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_703 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_704 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_547 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_705 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_706 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_707 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_708 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_709 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_710 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_711 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_712 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_713 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_714 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X1 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_715 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_716 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_717 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_718 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_719 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_720 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X1 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_721 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_722 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_723 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (nonceb_current X1 X2 X3) -> auto__q3 X1 -> auto__q2 X2 -> auto__q4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_91 X1 X2 X3 H);  intros.
  apply (rem_700 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_701 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_688 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_702 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_703 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_704 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_705 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_706 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_617 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_707 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_708 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_628 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_695 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_709 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_710 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_711 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_712 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_713 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_714 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_595 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_715 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_606 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_616 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_716 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_717 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_689 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_718 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_719 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_630 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_631 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_720 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_697 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_721 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_722 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_612 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_685 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_724 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_725 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q2 X3 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_726 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_727 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_728 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_534 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_729 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X1 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_730 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_731 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_732 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_733 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_734 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_735 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_736 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_737 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_738 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_739 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_740 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_741 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_742 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_743 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q2 X3 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_744 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_745 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_746 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_747 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_748 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_749 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (nonceb_current X1 X2 X3) -> auto__q3 X1 -> auto__q1 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_91 X1 X2 X3 H);  intros.
  apply (rem_687 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_724 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_725 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_726 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_727 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_728 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_694 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_729 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_730 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_583 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_588 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_731 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_732 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_733 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_734 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_735 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_736 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_737 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_738 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_597 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_739 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_740 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_741 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_742 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_743 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_744 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_745 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_578 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_596 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_633 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_746 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_698 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_575 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_685 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_747 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_748 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_750 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_751 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_752 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_753 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X3:term, auto__q2 X3 -> auto__q3 X3 -> False. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro H. clear H. intro Hrec. intro H. clear H. intro H. clear H. intros X3.
  cut (auto__q2 X3 -> auto__q3 X3 -> False). tauto. exact (Hrec X3).
Defined.

Remark rem_754 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X3 -> auto__q3 X3 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_753 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X3).
Defined.

Remark rem_755 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_756 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_757 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_758 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_759 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_760 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_761 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_762 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_763 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_764 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_765 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_766 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_767 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_768 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_769 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_770 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_771 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_772 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_773 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_774 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_775 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_776 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_777 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_778 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_779 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_780 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_781 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (nonceb_current X1 X2 X3) -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_91 X1 X2 X3 H);  intros.
  apply (rem_750 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_735 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_734 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_751 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_752 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_754 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_755 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_756 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_757 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_758 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_759 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_760 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_739 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_761 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_762 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_763 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_764 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_765 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_766 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_767 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_768 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_769 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_770 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_694 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_588 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_771 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_772 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_773 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_774 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_775 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_776 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_727 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_777 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_778 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_779 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_780 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_782 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_783 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_784 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_554 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_785 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_786 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X3:term, auto__q4 X3 -> auto__q1 X3 -> False. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro H. clear H. intro H. clear H. intro Hrec. intro H. clear H. intros X3.
  cut (auto__q4 X3 -> auto__q1 X3 -> False). tauto. exact (Hrec X3).
Defined.

Remark rem_787 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X3 -> auto__q1 X3 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_786 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X3).
Defined.

Remark rem_788 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_789 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_554 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_790 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_554 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_791 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_792 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_554 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_793 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_554 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_794 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_603 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_795 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_534 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_796 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_547 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_797 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_554 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_798 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_799 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_800 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_801 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_534 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_802 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X3 -> auto__q1 X3 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_655 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X3).
Defined.

Remark rem_803 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_554 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_804 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_554 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_805 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_554 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_806 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_554 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_807 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_808 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_554 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_809 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_810 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_603 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_811 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_603 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_812 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_547 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_813 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_534 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_814 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_547 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_815 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_547 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_816 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_603 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_817 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_534 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_818 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (nonceb_current X1 X2 X3) -> auto__q4 X1 -> auto__q3 X2 -> auto__q1 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_91 X1 X2 X3 H);  intros.
  apply (rem_782 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_783 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_784 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_785 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_787 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_788 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_789 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_790 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_791 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_792 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_793 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_794 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_795 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_796 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_797 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_798 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_799 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_659 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_800 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_801 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_802 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_803 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_804 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_805 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_806 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_807 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_808 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_809 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_810 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_811 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_812 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_813 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_814 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_815 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_816 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_817 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_819 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X2:term, auto__q4 X2 -> auto__q1 X2 -> False. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro H. clear H. intro H. clear H. intro Hrec. intro H. clear H. intros X2.
  cut (auto__q4 X2 -> auto__q1 X2 -> False). tauto. exact (Hrec X2).
Defined.

Remark rem_820 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_819 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_821 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q1 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X3 -> auto__q1 X3 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_786 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X3).
Defined.

Remark rem_822 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_823 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_534 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_824 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_825 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_826 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_827 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_828 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_819 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_829 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_830 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_831 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_832 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_833 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_834 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_835 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q1 X3 -> auto__q3 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_534 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_836 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q2 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_819 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_837 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_838 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_637 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_839 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q1 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_840 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X2 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_841 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q2 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_842 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q4 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_843 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_844 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q1 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_845 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X3:term, auto__q4 X3 -> auto__q3 X3 -> False. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro Hrec. intro H. clear H. intro H. clear H. intro H. clear H. intros X3.
  cut (auto__q4 X3 -> auto__q3 X3 -> False). tauto. exact (Hrec X3).
Defined.

Remark rem_846 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X3 -> auto__q3 X3 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_845 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X3).
Defined.

Remark rem_847 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 X1 -> auto__q4 X3 -> auto__q3 X2 -> auto__q2 X3 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_29 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_848 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q1 X3 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_819 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_849 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q1 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_850 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_851 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_852 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_853 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q1 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_854 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_855 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_856 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q4 X3 -> auto__q2 X3 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q2 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_25 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_857 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (nonceb_current X1 X2 X3) -> auto__q2 X1 -> auto__q1 X2 -> auto__q4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_91 X1 X2 X3 H);  intros.
  apply (rem_820 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_821 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_822 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_823 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_824 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_825 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_826 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_827 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_828 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_829 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_830 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_831 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_832 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_833 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_834 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_835 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_836 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_837 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_838 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_839 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_840 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_841 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_842 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_843 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_844 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_846 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_847 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_848 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_849 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_850 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_851 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_852 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_853 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_854 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_855 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_856 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_858 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_859 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X2 -> auto__q1 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_534 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_860 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q4 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_861 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q4 X1 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_862 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_863 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q3 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_864 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_865 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_866 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q1 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_867 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q4 X1 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_868 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q4 X2 -> auto__q1 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_869 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q1 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_870 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q4 X1 -> auto__q1 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_871 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q1 (nonceb_current X1 X2 X3) -> auto__q3 X1 -> auto__q1 X2 -> auto__q3 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3. intro H. intros.
  elim (rem_91 X1 X2 X3 H);  intros.
  apply (rem_623 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_587 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_858 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_825 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_690 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_859 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_686 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_737 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_860 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_584 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_576 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_861 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_862 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_746 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_863 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_864 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_730 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_865 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_866 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_574 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_867 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_741 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_868 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_678 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_563 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_869 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_734 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_570 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_573 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_611 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_870 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_684 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_592 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_695 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_731 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
  apply (rem_732 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1 X2 X3);  tauto.
Defined.

Remark rem_872 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q4 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_873 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X2 -> auto__q3 X2 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_547 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X2).
Defined.

Remark rem_874 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q2 X3 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_875 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_876 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_877 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q4 X1 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_878 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_879 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q3 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_880 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q3 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_881 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_882 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_883 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_884 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q3 X2 -> auto__q4 X1 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q4 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_565 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_885 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q2 X3 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_886 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q1 X1 -> auto__q3 X1 -> auto__q4 X2 -> auto__q2 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q3 X1 -> auto__q1 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_557 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_887 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q2 X -> False)
    -> forall X1 X2 X3:term, auto__q3 X3 -> auto__q3 X1 -> auto__q1 X3 -> auto__q4 X2 -> auto__q2 X2 -> auto__q2 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. intros X1 X2 X3.
  cut (auto__q2 X1 -> auto__q3 X1 -> False). clear  epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2. tauto.
  exact (rem_27 epsilon_m_q2_m_q1 epsilon_m_q4_m_q3 epsilon_m_q2_m_q3 epsilon_m_q4_m_q1 epsilon_m_q4_m_q2 X1).
Defined.

Remark rem_888 : (forall X:term, auto__q2 X -> auto__q1 X -> False)
    -> (forall X:term, auto__q4 X -> auto__q3 X -> False)
    -> (forall X:term, auto__q2 X -> auto__q3 X -> False)
    -> (