(* Generation of fresh symbols.
   Copyright (C) 2003 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.

   This file is part of h1.

   h1 is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   h1 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with h1; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*)

open "gensym_h";

(*
val gencnt = ref 0
fun gensym prefix =
    let val f as |[put, convert, ...]| = outstring prefix
    in
	inc gencnt;
	print f (pack (!gencnt));
	convert ()
    end;
*)

val gencnt = ref ({} : string -m> int ref)
fun gensym prefix =
    let val cnt = if prefix inset !gencnt
		      then ?(!gencnt) prefix
		  else let val r = ref 0
		       in
			   gencnt := !gencnt ++ {prefix => r};
			   r
		       end
	val f as |[put, convert, ...]| = outstring prefix
    in
	inc cnt;
	print f (pack (!cnt));
	convert ()
    end;

