% h1 example: the Gong protocol.
%   Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
%   This file is part of h1.
%
%   h1 is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2, or (at your option)
%   any later version.
%
%   h1 is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with h1; see the file COPYING.  If not, write to
%   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.



cnf(intruder_knows_nil,axiom,
  (knows(nil))).
cnf(intruder_can_take_first_components,axiom,
  (~knows(cons(M1,M2)) | knows(M1))).
cnf(intruder_can_take_second_components,axiom,
  (~knows(cons(M1,M2)) | knows(M2))).
cnf(intruder_can_build_pairs,axiom,
  (~knows(M2) | ~knows(M1) | knows(cons(M1,M2)))).
cnf(intruder_can_encrypt,axiom,
  (~knows(K) | ~knows(M) | knows(crypt(M,K)))).
cnf(intruder_can_decrypt_if_has_private_key,axiom,
  (~knows(key(prv,K)) | ~knows(crypt(M,key(pub,K))) | knows(M))).
cnf(intruder_can_decrypt_if_has_public_key,axiom,
  (~knows(key(pub,K)) | ~knows(crypt(M,key(prv,K))) | knows(M))).
cnf(intruder_can_decrypt_if_has_symmetric_key,axiom,
  (~knows(key(sym,X)) | ~knows(crypt(M,key(sym,X))) | knows(M))).
cnf(intruder_can_compute_successors,axiom,
  (~knows(M) | knows(s(M)))).
cnf(intruder_can_compute_predecessors,axiom,
  (~knows(s(M)) | knows(M))).
cnf(alice_agent,axiom,
    (agent(alice))).
cnf(bob_agent,axiom,
    (agent(bob))).
cnf(server_agent,axiom,
    (agent(server))).
cnf(intruder_agent,axiom,
    (agent(i))).

%
% Ajout des clauses du protocole
%
%

   % A -> S : A, Na
cnf(alice_sends_message_1_to_bob,axiom,
    (~agent(A) | knows (cons(A,cons(noncea(A),nil))))).
   % B -> S : Na,A,Nb,B
cnf(bob_sends_message_2_to_server,axiom,
    (~agent(B) | ~knows(cons(A,cons(Na,nil)))
    | knows(cons(Na,cons(A,cons(nonceb(A,B,Na),cons(B,nil))))))).
   % S -> B : {Nb,A,Kab}_Kbs, {Na,B,Kab}_Kas
cnf(servers_sends_message_3_to_bob,axiom,
    (~knows(cons(Na,cons(A,cons(Nb,cons(B,nil)))))
    | knows(cons(crypt(cons(Nb,cons(A,
                       cons(key(sym,current_session(A,B,Na,Nb)),
                            nil))),
                       key(sym,cons(B,cons(server,nil)))),
            cons(crypt(cons(Na,cons(B,
                       cons(key(sym,current_session(A,B,Na,Nb)),
                            nil))),
                       key(sym,cons(A,cons(server,nil)))),
                  nil))))).
cnf(intruder_knows_previous_server_messages,axiom,
    (~knows(cons(Na,cons(A,cons(Nb,cons(B,nil)))))
    | knows(cons(crypt(cons(Nb,cons(A,
                       cons(key(sym,old_session(A,B,Na,Nb)),
                            nil))),
                       key(sym,cons(B,cons(server,nil)))),
            cons(crypt(cons(Na,cons(B,
                       cons(key(sym,old_session(A,B,Na,Nb)),
                            nil))),
                       key(sym,cons(A,cons(server,nil)))),
                  nil))))).
   % B -> A : {Na,B,Kab}_Kas, {Na}_Kab, Nb2
cnf(bob_sends_message_4_to_alice,axiom,
    (~knows(cons(crypt(cons(nonceb(A,B,Na),
                       cons(A,cons(Kab,nil))),
                       key(sym,cons(B,cons(server,nil)))),
                 M)) % from message 3
    | knows(cons(M,cons(crypt(Na,Kab),
            cons(nonceb2(A,B,Na,Kab),nil)))))).
   % A -> B : {Nb2}_Kab
cnf(alice_sends_message_5_to_bob,axiom,
    (~knows(cons(crypt(cons(Na,cons(B,cons(Kab,nil))),
                       key(sym,cons(A,cons(server,nil)))),
            cons(crypt(Na,Kab),
            cons(Nb2,nil))))
    | knows(crypt(Nb2,Kab)))).

cnf(intruder_knows_all_agents,axiom,
  (~agent(X) | knows(X))).
cnf(intruder_knows_every_public_key,axiom,
  (knows(key(pub,X)))).
cnf(intruder_knows_own_private_key,axiom,
  (knows(key(prv,i)))).
cnf(intruder_knows_all_previous_session_keys,axiom,
  (knows(key(sym,old_session(A,B,Na,Nb))))).

cnf(intruder_knows_session_key_generated_by_server,axiom,
  (~knows(key(sym,current_session(alice,bob,Na,Nb))))).
cnf(intruder_knows_session_key_as_seen_by_alice,axiom,
  (~knows(cons(crypt(cons(Na,cons(B,cons(Kab,nil))),
                       key(sym,cons(A,cons(server,nil)))),
            cons(crypt(Na,Kab),
            cons(Nb2,nil)))) % from message 4
    | ~knows(Kab))).
cnf(intruder_knows_session_key_as_seen_by_B,axiom,
  (~knows(crypt(nonceb2(A,B,Na,Kab),Kab)) % from message 5
   | ~knows(cons(crypt(cons(nonceb(A,B,Na),
                       cons(A,cons(Kab,nil))),
                       key(sym,cons(B,cons(server,nil)))),
                 M)) % from message 3
    | ~knows(Kab))).
