(* Parse intersection predicates.
   Copyright (C) 2005 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.

   This file is part of h1.

   h1 is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   h1 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with h1; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*)

%{
open "intersymlex_h";

val f as |[ put, convert, seek, truncate, tell, ... ]| = outstring ""
%}

%x INTER

%%
<INITIAL>{
__inter_ { glex_begin (yyd, INTER); continue }
\n { return ISL_ERR }
. { return ISL_ERR }
<<EOF>> { return ISL_ERR }
}

<INTER>{
__ { put "_"; continue }
_sharp_ { put "#"; continue }
_and_ { if tell ()=0
           then return ISL_ERR
        else return (ISL_P (convert ()) before (seek 0; truncate ())) }
_ { return ISL_ERR }
[^_]+ { put (glex_text yyd); continue }
<<EOF>> { if tell ()=0
           then return ISL_ERR
        else return (ISL_END (convert ()) before (seek 0; truncate ()))  }
}

%%

