% h1 example: the Kao Chow authentication protocol v.3, with tickets (1995)
%   Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
%   This file is part of h1.
%
%   h1 is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2, or (at your option)
%   any later version.
%
%   h1 is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with h1; see the file COPYING.  If not, write to
%   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

% run 'cpp -P kaochow.p >kc.p'

cnf(alice_agent,axiom,
    (agent(alice))).
cnf(bob_agent,axiom,
    (agent(bob))).
cnf(server_agent,axiom,
    (agent(server))).
cnf(intruder_agent,axiom,
    (agent(i))).

#define PHASE(s) s##_old
#include "kaochow.phase.p"
#undef PHASE

cnf(intruder_remembers,axiom,
   (~knows_old(M) | knows_current(M))).

cnf(intruder_knows_all_previous_session_keys,axiom,
  (knows_current(key(sym,session_old(A,B,Na))))).
cnf(intruder_knows_all_previous_t_session_keys,axiom,
  (knows_current(key(sym,t_session_old(A,B,Na))))).

#define PHASE(s) s##_current
#include "kaochow.phase.p"
#undef PHASE

cnf(intruder_knows_session_key_generated_by_server,axiom,
  (~knows_current(key(sym,session_current(alice,bob,Na))))).
cnf(intruder_knows_session_key_as_seen_by_alice,axiom,
  (~knows_current(Kab)
  | ~alice_keys_current(alice,Kab,Kt))).
cnf(intruder_knows_session_key_as_seen_by_B,axiom,
  (~knows_current(Kab)
  | ~bob_keys_current(bob,Kab,Kt))).
