% h1 example: the Kao Chow authentication protocol v.3, with tickets (1995)
%   Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
%   This file is part of h1.
%
%   h1 is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2, or (at your option)
%   any later version.
%
%   h1 is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with h1; see the file COPYING.  If not, write to
%   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

#define KNOWS PHASE(knows)
#define NONCEA PHASE(noncea)
#define SESSION PHASE(session)
#define TSESSION PHASE(t_session)
#define NONCEB PHASE(nonceb)
#define TIME PHASE(time)
#define BOB_KEYS PHASE(bob_keys)
#define ALICE_KEYS PHASE(alice_keys)

cnf(PHASE(intruder_knows_nil),axiom,
  (KNOWS(nil))).
cnf(PHASE(intruder_can_take_first_components),axiom,
  (~KNOWS(cons(M1,M2)) | KNOWS(M1))).
cnf(PHASE(intruder_can_take_second_components),axiom,
  (~KNOWS(cons(M1,M2)) | KNOWS(M2))).
cnf(PHASE(intruder_can_build_pairs),axiom,
  (~KNOWS(M2) | ~KNOWS(M1) | KNOWS(cons(M1,M2)))).
cnf(PHASE(intruder_can_encrypt),axiom,
  (~KNOWS(K) | ~KNOWS(M) | KNOWS(crypt(M,K)))).
cnf(PHASE(intruder_can_decrypt_if_has_private_key),axiom,
  (~KNOWS(key(prv,K)) | ~KNOWS(crypt(M,key(pub,K))) | KNOWS(M))).
cnf(PHASE(intruder_can_decrypt_if_has_public_key),axiom,
  (~KNOWS(key(pub,K)) | ~KNOWS(crypt(M,key(prv,K))) | KNOWS(M))).
cnf(PHASE(intruder_can_decrypt_if_has_symmetric_key),axiom,
  (~KNOWS(key(sym,X)) | ~KNOWS(crypt(M,key(sym,X))) | KNOWS(M))).
cnf(PHASE(intruder_can_compute_successors),axiom,
  (~KNOWS(M) | KNOWS(s(M)))).
cnf(PHASE(intruder_can_compute_predecessors),axiom,
  (~KNOWS(s(M)) | KNOWS(M))).

%
% Ajout des clauses du protocole
%
%
   % 1. A -> S : A,B,Na
cnf(PHASE(message1),axiom,
    (~agent(A) | ~agent(B)
    | KNOWS(cons(A,cons(B,cons(NONCEA(A,B),nil)))))).
   % 2. S -> B : {A,B,Na,Kab,Kt}_Kas, {A,B,Na,Kab,Kt}_Kbs
cnf(PHASE(message2),axiom,
    (~KNOWS(cons(A,cons(B,cons(Na,nil))))
    | KNOWS(cons(crypt(cons(A,cons(B,cons(Na,
                       cons(key(sym,SESSION(A,B,Na)),
                       cons(key(sym,TSESSION(A,B,Na)),nil))))),
                       key(sym,cons(A,cons(server,nil)))),
                 crypt(cons(A,cons(B,cons(Na,
                       cons(key(sym,SESSION(A,B,Na)),
                       cons(key(sym,TSESSION(A,B,Na)),nil))))),
                       key(sym,cons(B,cons(server,nil)))))))).
   % 3. B -> A : {A,B,Na,Kab,Kt}_Kas, {Na,Kab}_Kt, Nb,
   %             {A,B,Ta,Kab}_Kbs
   % First message is a blind copy from message 2, Ta is a timestamp.
cnf(PHASE(message3),axiom,
    (~KNOWS(cons(M,
            cons(crypt(cons(A,cons(B,cons(Na,
                       cons(Kab,cons(Kt,nil))))),
                       key(sym,cons(B,cons(server,nil)))),
                 nil)))
    | KNOWS(cons(M,
            cons(crypt(cons(Na,cons(Kab,nil)),Kt),
            cons(NONCEB(M,A,B,Na,Kab,Kt),
            cons(crypt(cons(A,cons(B,cons(TIME(M,A,B,Na,Kab,Kt),
                       cons(Kab,nil)))),
                       key(sym,cons(B,cons(server,nil)))),
                 nil))))))).
   % 4. A -> B : {Nb,Kab}_Kt, {A,B,Ta,Kab}_Kbs
   % Second message is copied blindly from message 3.
cnf(PHASE(message4),axiom,
    (~KNOWS(cons(crypt(cons(A,cons(B,cons(NONCEA(A,B),
                       cons(Kab,cons(Kt,nil))))),
                       key(sym,cons(A,cons(server,nil)))),
            cons(crypt(cons(NONCEA(A,B),cons(Kab,nil)),
                       Kt),
            cons(Nb,
            cons(M,nil)))))
    | KNOWS(cons(crypt(cons(Nb,cons(Kab,nil)),Kt),
            cons(M,nil))))).
   % isolate key from Bob provided Ta is fresh enough;
   % This is checked by testing TIME(...).
cnf(PHASE(define_bob_key),axiom,
    (~KNOWS(cons(M,
            cons(crypt(cons(A,cons(B,cons(Na,
                       cons(Kab,cons(Kt,nil))))),
                       key(sym,cons(B,cons(server,nil)))),
                 nil))) % from message 2
    | ~KNOWS(cons(crypt(cons(NONCEB(M,A,B,Na,Kab,Kt),
                        cons(Kab,nil)),
                        Kt),
             cons(crypt(cons(A,cons(B,cons(TIME(M,A,B,Na,Kab,Kt),
                        cons(Kab,nil)))),
                        key(sym,cons(B,cons(server,nil)))),
                  nil))) % from message 4
    | BOB_KEYS(B,Kab,Kt))).
cnf(PHASE(define_alice_key),axiom,
    (~KNOWS(cons(crypt(cons(A,cons(B,cons(NONCEA(A,B),
                       cons(Kab,cons(Kt,nil))))),
                       key(sym,cons(A,cons(server,nil)))),
            cons(crypt(cons(NONCEA(A,B),cons(Kab,nil)),
                       Kt),
            cons(Nb,
            cons(M,nil)))))
    | ALICE_KEYS(A,Kab,Kt))).

cnf(PHASE(intruder_knows_all_agents),axiom,
  (~agent(X) | KNOWS(X))).
cnf(PHASE(intruder_knows_every_public_key),axiom,
  (KNOWS(key(pub,X)))).
cnf(PHASE(intruder_knows_own_private_key),axiom,
  (KNOWS(key(prv,i)))).
cnf(intruder_knows_all_timestamps,axiom,
    (KNOWS(TIME(M,A,B,Na,Kab,Kt)))).

#undef KNOWS
#undef NONCEA
#undef SESSION
#undef TSESSION
#undef NONCEB
#undef TIME
#undef BOB_KEYS
#undef ALICE_KEYS
