

% h1 example: the Kao Chow authentication protocol v.3, with tickets (1995)
% Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
% This file is part of h1.
%
% h1 is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2, or (at your option)
% any later version.
%
% h1 is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with h1; see the file COPYING. If not, write to
% the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

% run 'cpp -P kaochow.p >kc.p'

cnf(alice_agent,axiom,
    (agent(alice))).
cnf(bob_agent,axiom,
    (agent(bob))).
cnf(server_agent,axiom,
    (agent(server))).
cnf(intruder_agent,axiom,
    (agent(i))).
% h1 example: the Kao Chow authentication protocol v.3, with tickets (1995)
% Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
% This file is part of h1.
%
% h1 is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2, or (at your option)
% any later version.
%
% h1 is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with h1; see the file COPYING. If not, write to
% the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
cnf(intruder_knows_nil_old,axiom,
  (knows_old(nil))).
cnf(intruder_can_take_first_components_old,axiom,
  (~knows_old(cons(M1,M2)) | knows_old(M1))).
cnf(intruder_can_take_second_components_old,axiom,
  (~knows_old(cons(M1,M2)) | knows_old(M2))).
cnf(intruder_can_build_pairs_old,axiom,
  (~knows_old(M2) | ~knows_old(M1) | knows_old(cons(M1,M2)))).
cnf(intruder_can_encrypt_old,axiom,
  (~knows_old(K) | ~knows_old(M) | knows_old(crypt(M,K)))).
cnf(intruder_can_decrypt_if_has_private_key_old,axiom,
  (~knows_old(key(prv,K)) | ~knows_old(crypt(M,key(pub,K))) | knows_old(M))).
cnf(intruder_can_decrypt_if_has_public_key_old,axiom,
  (~knows_old(key(pub,K)) | ~knows_old(crypt(M,key(prv,K))) | knows_old(M))).
cnf(intruder_can_decrypt_if_has_symmetric_key_old,axiom,
  (~knows_old(key(sym,X)) | ~knows_old(crypt(M,key(sym,X))) | knows_old(M))).
cnf(intruder_can_compute_successors_old,axiom,
  (~knows_old(M) | knows_old(s(M)))).
cnf(intruder_can_compute_predecessors_old,axiom,
  (~knows_old(s(M)) | knows_old(M))).
%
% Ajout des clauses du protocole
%
%
   % 1. A -> S : A,B,Na
cnf(message1_old,axiom,
    (~agent(A) | ~agent(B)
    | knows_old(cons(A,cons(B,cons(noncea_old(A,B),nil)))))).
   % 2. S -> B : {A,B,Na,Kab,Kt}_Kas, {A,B,Na,Kab,Kt}_Kbs
cnf(message2_old,axiom,
    (~knows_old(cons(A,cons(B,cons(Na,nil))))
    | knows_old(cons(crypt(cons(A,cons(B,cons(Na,
                       cons(key(sym,session_old(A,B,Na)),
                       cons(key(sym,t_session_old(A,B,Na)),nil))))),
                       key(sym,cons(A,cons(server,nil)))),
                 crypt(cons(A,cons(B,cons(Na,
                       cons(key(sym,session_old(A,B,Na)),
                       cons(key(sym,t_session_old(A,B,Na)),nil))))),
                       key(sym,cons(B,cons(server,nil)))))))).
   % 3. B -> A : {A,B,Na,Kab,Kt}_Kas, {Na,Kab}_Kt, Nb,
   % {A,B,Ta,Kab}_Kbs
   % First message is a blind copy from message 2, Ta is a timestamp.
cnf(message3_old,axiom,
    (~knows_old(cons(M,
            cons(crypt(cons(A,cons(B,cons(Na,
                       cons(Kab,cons(Kt,nil))))),
                       key(sym,cons(B,cons(server,nil)))),
                 nil)))
    | knows_old(cons(M,
            cons(crypt(cons(Na,cons(Kab,nil)),Kt),
            cons(nonceb_old(M,A,B,Na,Kab,Kt),
            cons(crypt(cons(A,cons(B,cons(time_old(M,A,B,Na,Kab,Kt),
                       cons(Kab,nil)))),
                       key(sym,cons(B,cons(server,nil)))),
                 nil))))))).
   % 4. A -> B : {Nb,Kab}_Kt, {A,B,Ta,Kab}_Kbs
   % Second message is copied blindly from message 3.
cnf(message4_old,axiom,
    (~knows_old(cons(crypt(cons(A,cons(B,cons(noncea_old(A,B),
                       cons(Kab,cons(Kt,nil))))),
                       key(sym,cons(A,cons(server,nil)))),
            cons(crypt(cons(noncea_old(A,B),cons(Kab,nil)),
                       Kt),
            cons(Nb,
            cons(M,nil)))))
    | knows_old(cons(crypt(cons(Nb,cons(Kab,nil)),Kt),
            cons(M,nil))))).
   % isolate key from Bob provided Ta is fresh enough;
   % This is checked by testing time_old(...).
cnf(define_bob_key_old,axiom,
    (~knows_old(cons(M,
            cons(crypt(cons(A,cons(B,cons(Na,
                       cons(Kab,cons(Kt,nil))))),
                       key(sym,cons(B,cons(server,nil)))),
                 nil))) % from message 2
    | ~knows_old(cons(crypt(cons(nonceb_old(M,A,B,Na,Kab,Kt),
                        cons(Kab,nil)),
                        Kt),
             cons(crypt(cons(A,cons(B,cons(time_old(M,A,B,Na,Kab,Kt),
                        cons(Kab,nil)))),
                        key(sym,cons(B,cons(server,nil)))),
                  nil))) % from message 4
    | bob_keys_old(B,Kab,Kt))).
cnf(define_alice_key_old,axiom,
    (~knows_old(cons(crypt(cons(A,cons(B,cons(noncea_old(A,B),
                       cons(Kab,cons(Kt,nil))))),
                       key(sym,cons(A,cons(server,nil)))),
            cons(crypt(cons(noncea_old(A,B),cons(Kab,nil)),
                       Kt),
            cons(Nb,
            cons(M,nil)))))
    | alice_keys_old(A,Kab,Kt))).
cnf(intruder_knows_all_agents_old,axiom,
  (~agent(X) | knows_old(X))).
cnf(intruder_knows_every_public_key_old,axiom,
  (knows_old(key(pub,X)))).
cnf(intruder_knows_own_private_key_old,axiom,
  (knows_old(key(prv,i)))).
cnf(intruder_knows_all_timestamps,axiom,
    (knows_old(time_old(M,A,B,Na,Kab,Kt)))).
cnf(intruder_remembers,axiom,
   (~knows_old(M) | knows_current(M))).
cnf(intruder_knows_all_previous_session_keys,axiom,
  (knows_current(key(sym,session_old(A,B,Na))))).
cnf(intruder_knows_all_previous_t_session_keys,axiom,
  (knows_current(key(sym,t_session_old(A,B,Na))))).
% h1 example: the Kao Chow authentication protocol v.3, with tickets (1995)
% Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
% This file is part of h1.
%
% h1 is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2, or (at your option)
% any later version.
%
% h1 is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with h1; see the file COPYING. If not, write to
% the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
cnf(intruder_knows_nil_current,axiom,
  (knows_current(nil))).
cnf(intruder_can_take_first_components_current,axiom,
  (~knows_current(cons(M1,M2)) | knows_current(M1))).
cnf(intruder_can_take_second_components_current,axiom,
  (~knows_current(cons(M1,M2)) | knows_current(M2))).
cnf(intruder_can_build_pairs_current,axiom,
  (~knows_current(M2) | ~knows_current(M1) | knows_current(cons(M1,M2)))).
cnf(intruder_can_encrypt_current,axiom,
  (~knows_current(K) | ~knows_current(M) | knows_current(crypt(M,K)))).
cnf(intruder_can_decrypt_if_has_private_key_current,axiom,
  (~knows_current(key(prv,K)) | ~knows_current(crypt(M,key(pub,K))) | knows_current(M))).
cnf(intruder_can_decrypt_if_has_public_key_current,axiom,
  (~knows_current(key(pub,K)) | ~knows_current(crypt(M,key(prv,K))) | knows_current(M))).
cnf(intruder_can_decrypt_if_has_symmetric_key_current,axiom,
  (~knows_current(key(sym,X)) | ~knows_current(crypt(M,key(sym,X))) | knows_current(M))).
cnf(intruder_can_compute_successors_current,axiom,
  (~knows_current(M) | knows_current(s(M)))).
cnf(intruder_can_compute_predecessors_current,axiom,
  (~knows_current(s(M)) | knows_current(M))).
%
% Ajout des clauses du protocole
%
%
   % 1. A -> S : A,B,Na
cnf(message1_current,axiom,
    (~agent(A) | ~agent(B)
    | knows_current(cons(A,cons(B,cons(noncea_current(A,B),nil)))))).
   % 2. S -> B : {A,B,Na,Kab,Kt}_Kas, {A,B,Na,Kab,Kt}_Kbs
cnf(message2_current,axiom,
    (~knows_current(cons(A,cons(B,cons(Na,nil))))
    | knows_current(cons(crypt(cons(A,cons(B,cons(Na,
                       cons(key(sym,session_current(A,B,Na)),
                       cons(key(sym,t_session_current(A,B,Na)),nil))))),
                       key(sym,cons(A,cons(server,nil)))),
                 crypt(cons(A,cons(B,cons(Na,
                       cons(key(sym,session_current(A,B,Na)),
                       cons(key(sym,t_session_current(A,B,Na)),nil))))),
                       key(sym,cons(B,cons(server,nil)))))))).
   % 3. B -> A : {A,B,Na,Kab,Kt}_Kas, {Na,Kab}_Kt, Nb,
   % {A,B,Ta,Kab}_Kbs
   % First message is a blind copy from message 2, Ta is a timestamp.
cnf(message3_current,axiom,
    (~knows_current(cons(M,
            cons(crypt(cons(A,cons(B,cons(Na,
                       cons(Kab,cons(Kt,nil))))),
                       key(sym,cons(B,cons(server,nil)))),
                 nil)))
    | knows_current(cons(M,
            cons(crypt(cons(Na,cons(Kab,nil)),Kt),
            cons(nonceb_current(M,A,B,Na,Kab,Kt),
            cons(crypt(cons(A,cons(B,cons(time_current(M,A,B,Na,Kab,Kt),
                       cons(Kab,nil)))),
                       key(sym,cons(B,cons(server,nil)))),
                 nil))))))).
   % 4. A -> B : {Nb,Kab}_Kt, {A,B,Ta,Kab}_Kbs
   % Second message is copied blindly from message 3.
cnf(message4_current,axiom,
    (~knows_current(cons(crypt(cons(A,cons(B,cons(noncea_current(A,B),
                       cons(Kab,cons(Kt,nil))))),
                       key(sym,cons(A,cons(server,nil)))),
            cons(crypt(cons(noncea_current(A,B),cons(Kab,nil)),
                       Kt),
            cons(Nb,
            cons(M,nil)))))
    | knows_current(cons(crypt(cons(Nb,cons(Kab,nil)),Kt),
            cons(M,nil))))).
   % isolate key from Bob provided Ta is fresh enough;
   % This is checked by testing time_current(...).
cnf(define_bob_key_current,axiom,
    (~knows_current(cons(M,
            cons(crypt(cons(A,cons(B,cons(Na,
                       cons(Kab,cons(Kt,nil))))),
                       key(sym,cons(B,cons(server,nil)))),
                 nil))) % from message 2
    | ~knows_current(cons(crypt(cons(nonceb_current(M,A,B,Na,Kab,Kt),
                        cons(Kab,nil)),
                        Kt),
             cons(crypt(cons(A,cons(B,cons(time_current(M,A,B,Na,Kab,Kt),
                        cons(Kab,nil)))),
                        key(sym,cons(B,cons(server,nil)))),
                  nil))) % from message 4
    | bob_keys_current(B,Kab,Kt))).
cnf(define_alice_key_current,axiom,
    (~knows_current(cons(crypt(cons(A,cons(B,cons(noncea_current(A,B),
                       cons(Kab,cons(Kt,nil))))),
                       key(sym,cons(A,cons(server,nil)))),
            cons(crypt(cons(noncea_current(A,B),cons(Kab,nil)),
                       Kt),
            cons(Nb,
            cons(M,nil)))))
    | alice_keys_current(A,Kab,Kt))).
cnf(intruder_knows_all_agents_current,axiom,
  (~agent(X) | knows_current(X))).
cnf(intruder_knows_every_public_key_current,axiom,
  (knows_current(key(pub,X)))).
cnf(intruder_knows_own_private_key_current,axiom,
  (knows_current(key(prv,i)))).
cnf(intruder_knows_all_timestamps,axiom,
    (knows_current(time_current(M,A,B,Na,Kab,Kt)))).
cnf(intruder_knows_session_key_generated_by_server,axiom,
  (~knows_current(key(sym,session_current(alice,bob,Na))))).
cnf(intruder_knows_session_key_as_seen_by_alice,axiom,
  (~knows_current(Kab)
  | ~alice_keys_current(alice,Kab,Kt))).
cnf(intruder_knows_session_key_as_seen_by_B,axiom,
  (~knows_current(Kab)
  | ~bob_keys_current(bob,Kab,Kt))).
