(* [sigd] Signature definition. *)

Inductive term : Set :=
    alice : term
  | bob : term
  | cons : term -> term -> term
  | crypt : term -> term -> term
  | i : term
  | key : term -> term -> term
  | l : term -> term -> term
  | nil : term
  | prv : term
  | pub : term
  | s : term -> term
  | server : term
  | session_current : term -> term -> term
  | session_old : term -> term -> term
  | sym : term
  | t_current : term
  | t_old : term
.

(* [modd] Model definition. *)

Inductive auto___def_45 : term -> Prop :=
    trans___def_45_1 : forall X:term, auto___def_45 X
with auto___def_51 : term -> Prop :=
    trans___def_51_1 : forall X:term, auto___def_51 X
with auto___def_4 : term -> Prop :=
    trans___def_4_1 : forall X:term, auto___def_4 X
with auto___type_8 : term -> Prop :=
    trans___type_8_1 : forall X:term, auto___type_8 X
with auto___type_13 : term -> Prop :=
    trans___type_13_s_1 : forall X1:term, auto_knows_current X1 -> auto___type_13 (s X1)
  | trans___type_13_nil_1 : auto___type_13 nil
  | trans___type_13_i_1 : auto___type_13 i
  | trans___type_13_cons_1 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_13 (cons X1 X2)
  | trans___type_13_crypt_1 : forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> auto___type_13 (crypt X1 X2)
  | trans___type_13_crypt_2 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_13 (crypt X1 X2)
  | trans___type_13_crypt_3 : forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> auto___type_13 (crypt X1 X2)
  | trans___type_13_crypt_4 : forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___type_13 (crypt X1 X2)
  | trans___type_13_crypt_5 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___type_13 (crypt X1 X2)
  | trans___type_13_crypt_6 : forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> auto___type_13 (crypt X1 X2)
  | trans___type_13_crypt_7 : forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> auto___type_13 (crypt X1 X2)
  | trans___type_13_bob_1 : auto___type_13 bob
  | trans___type_13_key_1 : forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___type_13 (key X1 X2)
  | trans___type_13_key_2 : forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___type_13 (key X1 X2)
  | trans___type_13_key_3 : forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___type_13 (key X1 X2)
  | trans___type_13_t_old_1 : auto___type_13 t_old
  | trans___type_13_alice_1 : auto___type_13 alice
  | trans___type_13_server_1 : auto___type_13 server
  | trans___type_13_t_current_1 : auto___type_13 t_current
with auto_agent : term -> Prop :=
    trans_agent_i_1 : auto_agent i
  | trans_agent_bob_1 : auto_agent bob
  | trans_agent_alice_1 : auto_agent alice
  | trans_agent_server_1 : auto_agent server
with auto___type_9 : term -> Prop :=
    trans___type_9_s_1 : forall X1:term, auto_knows_current X1 -> auto___type_9 (s X1)
  | trans___type_9_nil_1 : auto___type_9 nil
  | trans___type_9_i_1 : auto___type_9 i
  | trans___type_9_cons_1 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_9 (cons X1 X2)
  | trans___type_9_crypt_1 : forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> auto___type_9 (crypt X1 X2)
  | trans___type_9_crypt_2 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_9 (crypt X1 X2)
  | trans___type_9_crypt_3 : forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> auto___type_9 (crypt X1 X2)
  | trans___type_9_crypt_4 : forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___type_9 (crypt X1 X2)
  | trans___type_9_crypt_5 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___type_9 (crypt X1 X2)
  | trans___type_9_crypt_6 : forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> auto___type_9 (crypt X1 X2)
  | trans___type_9_crypt_7 : forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> auto___type_9 (crypt X1 X2)
  | trans___type_9_bob_1 : auto___type_9 bob
  | trans___type_9_key_1 : forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___type_9 (key X1 X2)
  | trans___type_9_key_2 : forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___type_9 (key X1 X2)
  | trans___type_9_key_3 : forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___type_9 (key X1 X2)
  | trans___type_9_t_old_1 : auto___type_9 t_old
  | trans___type_9_alice_1 : auto___type_9 alice
  | trans___type_9_server_1 : auto___type_9 server
  | trans___type_9_t_current_1 : auto___type_9 t_current
with auto___def_63 : term -> Prop :=
    trans___def_63_sym_1 : auto___def_63 sym
with auto___def_25 : term -> Prop :=
    trans___def_25_cons_1 : forall X1 X2:term, auto___def_14 X1 -> auto___def_26 X2 -> auto___def_25 (cons X1 X2)
with auto___type_2 : term -> Prop :=
    trans___type_2_s_1 : forall X1:term, auto_knows_old X1 -> auto___type_2 (s X1)
  | trans___type_2_nil_1 : auto___type_2 nil
  | trans___type_2_i_1 : auto___type_2 i
  | trans___type_2_cons_1 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_2 (cons X1 X2)
  | trans___type_2_crypt_1 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_2 (crypt X1 X2)
  | trans___type_2_crypt_2 : forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> auto___type_2 (crypt X1 X2)
  | trans___type_2_crypt_3 : forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___type_2 (crypt X1 X2)
  | trans___type_2_crypt_4 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___type_2 (crypt X1 X2)
  | trans___type_2_crypt_5 : forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> auto___type_2 (crypt X1 X2)
  | trans___type_2_bob_1 : auto___type_2 bob
  | trans___type_2_key_1 : forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___type_2 (key X1 X2)
  | trans___type_2_key_2 : forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___type_2 (key X1 X2)
  | trans___type_2_t_old_1 : auto___type_2 t_old
  | trans___type_2_alice_1 : auto___type_2 alice
  | trans___type_2_server_1 : auto___type_2 server
with auto___def_50 : term -> term -> Prop :=
    trans___def_50_1 : forall X1 X2:term, auto___def_44 X1 -> auto_knows_current X2 -> auto___def_50 X1 X2
with auto___def_60 : term -> Prop :=
    trans___def_60_cons_1 : forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto___def_60 (cons X1 X2)
with auto___def_9 : term -> term -> Prop :=
    trans___def_9_1 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___def_9 X1 X2
with auto___def_28 : term -> Prop :=
    trans___def_28_cons_1 : forall X1 X2:term, auto___type_2 X1 -> auto___def_29 X2 -> auto___def_28 (cons X1 X2)
with auto___def_72 : term -> Prop :=
    trans___def_72_cons_1 : forall X1 X2:term, auto___type_10 X1 -> auto___def_67 X2 -> auto___def_72 (cons X1 X2)
with auto_alice_key_old : term -> term -> Prop :=
    trans_alice_key_old_1 : forall X1 X2:term, auto_alice_key_old X1 X2
with auto___def_67 : term -> Prop :=
    trans___def_67_nil_1 : auto___def_67 nil
with auto___def_46 : term -> Prop :=
    trans___def_46_sym_1 : auto___def_46 sym
with auto___def_27 : term -> Prop :=
    trans___def_27_cons_1 : forall X1 X2:term, auto___type_3 X1 -> auto___def_22 X2 -> auto___def_27 (cons X1 X2)
with auto___def_58 : term -> Prop :=
    trans___def_58_cons_1 : forall X1 X2:term, auto___def_59 X1 -> auto___def_60 X2 -> auto___def_58 (cons X1 X2)
with auto___def_38 : term -> Prop :=
    trans___def_38_cons_1 : forall X1 X2:term, auto___def_39 X1 -> auto___def_31 X2 -> auto___def_38 (cons X1 X2)
with auto___def_11 : term -> Prop :=
    trans___def_11_key_1 : forall X1 X2:term, auto___def_18 X1 -> auto___def_32 X2 -> auto___def_11 (key X1 X2)
with auto___type_1 : term -> Prop :=
    trans___type_1_i_1 : auto___type_1 i
  | trans___type_1_bob_1 : auto___type_1 bob
  | trans___type_1_alice_1 : auto___type_1 alice
  | trans___type_1_server_1 : auto___type_1 server
with auto___def_64 : term -> Prop :=
    trans___def_64_session_current_1 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___def_64 (session_current X1 X2)
with auto___def_17 : term -> Prop :=
    trans___def_17_cons_1 : forall X1 X2:term, auto___type_2 X1 -> auto___def_20 X2 -> auto___def_17 (cons X1 X2)
with auto___def_37 : term -> Prop :=
    trans___def_37_cons_1 : forall X1 X2:term, auto___type_6 X1 -> auto___def_38 X2 -> auto___def_37 (cons X1 X2)
with auto___def_14 : term -> Prop :=
    trans___def_14_l_1 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___def_14 (l X1 X2)
with auto___def_53 : term -> Prop :=
    trans___def_53_session_old_1 : forall X1 X2:term, auto___def_53 (session_old X1 X2)
with auto___def_5 : term -> term -> Prop :=
    trans___def_5_1 : forall X1 X2:term, auto___def_41 X1 -> auto___def_19 X2 -> auto___def_5 X1 X2
  | trans___def_5_2 : forall X1 X2:term, auto___def_23 X1 -> auto___def_28 X2 -> auto___def_5 X1 X2
  | trans___def_5_3 : forall X1 X2:term, auto___def_37 X1 -> auto___def_19 X2 -> auto___def_5 X1 X2
  | trans___def_5_4 : forall X1 X2:term, auto___def_10 X1 -> auto___def_32 X2 -> auto___def_5 X1 X2
with auto___def_57 : term -> Prop :=
    trans___def_57_t_current_1 : auto___def_57 t_current
with auto___def_26 : term -> Prop :=
    trans___def_26_cons_1 : forall X1 X2:term, auto___def_16 X1 -> auto___def_27 X2 -> auto___def_26 (cons X1 X2)
with auto___def_69 : term -> Prop :=
    trans___def_69_key_1 : forall X1 X2:term, auto___def_63 X1 -> auto___def_73 X2 -> auto___def_69 (key X1 X2)
with auto___def_61 : term -> Prop :=
    trans___def_61_key_1 : forall X1 X2:term, auto___def_63 X1 -> auto___def_64 X2 -> auto___def_61 (key X1 X2)
with auto___def_13 : term -> Prop :=
    trans___def_13_cons_1 : forall X1 X2:term, auto___def_14 X1 -> auto___def_15 X2 -> auto___def_13 (cons X1 X2)
with auto___type_12 : term -> Prop :=
    trans___type_12_key_1 : forall X1 X2:term, auto___def_63 X1 -> auto___def_64 X2 -> auto___type_12 (key X1 X2)
with auto___def_49 : term -> Prop :=
    trans___def_49_i_1 : auto___def_49 i
with auto___def_47 : term -> Prop :=
    trans___def_47_session_old_1 : forall X1 X2:term, auto___def_47 (session_old X1 X2)
with auto___def_22 : term -> Prop :=
    trans___def_22_nil_1 : auto___def_22 nil
with auto___def_24 : term -> Prop :=
    trans___def_24_key_1 : forall X1 X2:term, auto___def_18 X1 -> auto___def_28 X2 -> auto___def_24 (key X1 X2)
with auto___def_2 : term -> Prop :=
    trans___def_2_i_1 : auto___def_2 i
with auto___def_19 : term -> Prop :=
    trans___def_19_session_old_1 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___def_19 (session_old X1 X2)
with auto___def_20 : term -> Prop :=
    trans___def_20_cons_1 : forall X1 X2:term, auto___def_21 X1 -> auto___def_22 X2 -> auto___def_20 (cons X1 X2)
with auto___def_15 : term -> Prop :=
    trans___def_15_cons_1 : forall X1 X2:term, auto___def_16 X1 -> auto___def_17 X2 -> auto___def_15 (cons X1 X2)
with auto_knows_old : term -> Prop :=
    trans_knows_old_s_1 : forall X1:term, auto_knows_old X1 -> auto_knows_old (s X1)
  | trans_knows_old_nil_1 : auto_knows_old nil
  | trans_knows_old_i_1 : auto_knows_old i
  | trans_knows_old_cons_1 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old (cons X1 X2)
  | trans_knows_old_crypt_1 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_crypt_2 : forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_crypt_3 : forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_crypt_4 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_crypt_5 : forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_bob_1 : auto_knows_old bob
  | trans_knows_old_key_1 : forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto_knows_old (key X1 X2)
  | trans_knows_old_key_2 : forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto_knows_old (key X1 X2)
  | trans_knows_old_t_old_1 : auto_knows_old t_old
  | trans_knows_old_alice_1 : auto_knows_old alice
  | trans_knows_old_server_1 : auto_knows_old server
with auto___def_80 : term -> Prop :=
    trans___def_80_cons_1 : forall X1 X2:term, auto___type_13 X1 -> auto___def_81 X2 -> auto___def_80 (cons X1 X2)
with auto___def_52 : term -> term -> Prop :=
    trans___def_52_1 : forall X1 X2:term, auto___def_55 X1 -> auto___def_75 X2 -> auto___def_52 X1 X2
  | trans___def_52_2 : forall X1 X2:term, auto_knows_current X1 -> auto___def_47 X2 -> auto___def_52 X1 X2
  | trans___def_52_3 : forall X1 X2:term, auto___def_23 X1 -> auto___def_28 X2 -> auto___def_52 X1 X2
  | trans___def_52_4 : forall X1 X2:term, auto___def_10 X1 -> auto___def_32 X2 -> auto___def_52 X1 X2
  | trans___def_52_5 : forall X1 X2:term, auto___def_68 X1 -> auto___def_73 X2 -> auto___def_52 X1 X2
  | trans___def_52_6 : forall X1 X2:term, auto___def_84 X1 -> auto___def_64 X2 -> auto___def_52 X1 X2
  | trans___def_52_7 : forall X1 X2:term, auto___def_80 X1 -> auto___def_64 X2 -> auto___def_52 X1 X2
with auto___def_21 : term -> Prop :=
    trans___def_21_crypt_1 : forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_21 (crypt X1 X2)
with auto_knows_current : term -> Prop :=
    trans_knows_current_s_1 : forall X1:term, auto_knows_current X1 -> auto_knows_current (s X1)
  | trans_knows_current_nil_1 : auto_knows_current nil
  | trans_knows_current_i_1 : auto_knows_current i
  | trans_knows_current_cons_1 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current (cons X1 X2)
  | trans_knows_current_crypt_1 : forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_2 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_3 : forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_4 : forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_5 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_6 : forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_7 : forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_bob_1 : auto_knows_current bob
  | trans_knows_current_key_1 : forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto_knows_current (key X1 X2)
  | trans_knows_current_key_2 : forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto_knows_current (key X1 X2)
  | trans_knows_current_key_3 : forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto_knows_current (key X1 X2)
  | trans_knows_current_t_old_1 : auto_knows_current t_old
  | trans_knows_current_alice_1 : auto_knows_current alice
  | trans_knows_current_server_1 : auto_knows_current server
  | trans_knows_current_t_current_1 : auto_knows_current t_current
with auto___def_59 : term -> Prop :=
    trans___def_59_l_1 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___def_59 (l X1 X2)
with auto___type_14 : term -> Prop :=
    trans___type_14_key_1 : forall X1 X2:term, auto___def_63 X1 -> auto___def_64 X2 -> auto___type_14 (key X1 X2)
with auto___def_43 : term -> Prop :=
    trans___def_43_prv_1 : auto___def_43 prv
with auto___def_8 : term -> Prop :=
    trans___def_8_nil_1 : auto___def_8 nil
with auto___def_85 : term -> Prop :=
    trans___def_85_s_1 : forall X1:term, auto_knows_current X1 -> auto___def_85 (s X1)
  | trans___def_85_nil_1 : auto___def_85 nil
  | trans___def_85_i_1 : auto___def_85 i
  | trans___def_85_cons_1 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___def_85 (cons X1 X2)
  | trans___def_85_crypt_1 : forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> auto___def_85 (crypt X1 X2)
  | trans___def_85_crypt_2 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___def_85 (crypt X1 X2)
  | trans___def_85_crypt_3 : forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> auto___def_85 (crypt X1 X2)
  | trans___def_85_crypt_4 : forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_85 (crypt X1 X2)
  | trans___def_85_crypt_5 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_85 (crypt X1 X2)
  | trans___def_85_crypt_6 : forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> auto___def_85 (crypt X1 X2)
  | trans___def_85_crypt_7 : forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> auto___def_85 (crypt X1 X2)
  | trans___def_85_bob_1 : auto___def_85 bob
  | trans___def_85_key_1 : forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___def_85 (key X1 X2)
  | trans___def_85_key_2 : forall X1 X2:term, auto___def_63 X1 -> auto___def_64 X2 -> auto___def_85 (key X1 X2)
  | trans___def_85_key_3 : forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_85 (key X1 X2)
  | trans___def_85_key_4 : forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_85 (key X1 X2)
  | trans___def_85_t_old_1 : auto___def_85 t_old
  | trans___def_85_alice_1 : auto___def_85 alice
  | trans___def_85_server_1 : auto___def_85 server
  | trans___def_85_t_current_1 : auto___def_85 t_current
with auto___def_23 : term -> Prop :=
    trans___def_23_cons_1 : forall X1 X2:term, auto___def_12 X1 -> auto___def_25 X2 -> auto___def_23 (cons X1 X2)
with auto___def_48 : term -> term -> Prop :=
    trans___def_48_1 : forall X1 X2:term, auto___type_8 X1 -> auto_knows_current X2 -> auto___def_48 X1 X2
with auto___def_66 : term -> Prop :=
    trans___def_66_crypt_1 : forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> auto___def_66 (crypt X1 X2)
with auto___def_54 : term -> term -> Prop :=
    trans___def_54_1 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___def_54 X1 X2
with auto___def_55 : term -> Prop :=
    trans___def_55_cons_1 : forall X1 X2:term, auto___def_57 X1 -> auto___def_58 X2 -> auto___def_55 (cons X1 X2)
with auto___def_44 : term -> Prop :=
    trans___def_44_i_1 : auto___def_44 i
with auto___def_29 : term -> Prop :=
    trans___def_29_cons_1 : forall X1 X2:term, auto___def_30 X1 -> auto___def_31 X2 -> auto___def_29 (cons X1 X2)
with auto___def_65 : term -> Prop :=
    trans___def_65_cons_1 : forall X1 X2:term, auto___def_66 X1 -> auto___def_67 X2 -> auto___def_65 (cons X1 X2)
with auto___type_3 : term -> Prop :=
    trans___type_3_s_1 : forall X1:term, auto_knows_old X1 -> auto___type_3 (s X1)
  | trans___type_3_nil_1 : auto___type_3 nil
  | trans___type_3_i_1 : auto___type_3 i
  | trans___type_3_cons_1 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_3 (cons X1 X2)
  | trans___type_3_crypt_1 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_3 (crypt X1 X2)
  | trans___type_3_crypt_2 : forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> auto___type_3 (crypt X1 X2)
  | trans___type_3_crypt_3 : forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___type_3 (crypt X1 X2)
  | trans___type_3_crypt_4 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___type_3 (crypt X1 X2)
  | trans___type_3_crypt_5 : forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> auto___type_3 (crypt X1 X2)
  | trans___type_3_bob_1 : auto___type_3 bob
  | trans___type_3_key_1 : forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___type_3 (key X1 X2)
  | trans___type_3_key_2 : forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___type_3 (key X1 X2)
  | trans___type_3_t_old_1 : auto___type_3 t_old
  | trans___type_3_alice_1 : auto___type_3 alice
  | trans___type_3_server_1 : auto___type_3 server
with auto___def_56 : term -> Prop :=
    trans___def_56_key_1 : forall X1 X2:term, auto___def_63 X1 -> auto___def_75 X2 -> auto___def_56 (key X1 X2)
with auto___def_18 : term -> Prop :=
    trans___def_18_sym_1 : auto___def_18 sym
with auto___def_10 : term -> Prop :=
    trans___def_10_cons_1 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_10 (cons X1 X2)
with auto___def_68 : term -> Prop :=
    trans___def_68_cons_1 : forall X1 X2:term, auto___def_57 X1 -> auto___def_70 X2 -> auto___def_68 (cons X1 X2)
with auto___def_16 : term -> Prop :=
    trans___def_16_key_1 : forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_16 (key X1 X2)
with auto___def_62 : term -> Prop :=
    trans___def_62_cons_1 : forall X1 X2:term, auto___type_9 X1 -> auto___def_65 X2 -> auto___def_62 (cons X1 X2)
with auto___def_12 : term -> Prop :=
    trans___def_12_t_old_1 : auto___def_12 t_old
with auto___type_4 : term -> Prop :=
    trans___type_4_crypt_1 : forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___type_4 (crypt X1 X2)
with auto___def_32 : term -> Prop :=
    trans___def_32_cons_1 : forall X1 X2:term, auto___type_3 X1 -> auto___def_29 X2 -> auto___def_32 (cons X1 X2)
with auto___def_70 : term -> Prop :=
    trans___def_70_cons_1 : forall X1 X2:term, auto___def_59 X1 -> auto___def_71 X2 -> auto___def_70 (cons X1 X2)
with auto___def_83 : term -> term -> term -> term -> Prop :=
    trans___def_83_1 : forall X1 X2 X3 X4:term, auto___type_13 X1 -> auto___type_10 X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_61 X4 -> auto___type_12 X4 -> auto___def_83 X1 X2 X3 X4
with auto___def_77 : term -> Prop :=
    trans___def_77_cons_1 : forall X1 X2:term, auto___def_78 X1 -> auto___def_79 X2 -> auto___def_77 (cons X1 X2)
with auto___def_7 : term -> Prop :=
    trans___def_7_cons_1 : forall X1 X2:term, auto_agent X1 -> auto___def_8 X2 -> auto___def_7 (cons X1 X2)
with auto___def_1 : term -> term -> Prop :=
    trans___def_1_1 : forall X1 X2:term, auto___type_8 X1 -> auto_knows_old X2 -> auto___def_1 X1 X2
with auto___def_3 : term -> term -> Prop :=
    trans___def_3_1 : forall X1 X2:term, auto___def_44 X1 -> auto_knows_old X2 -> auto___def_3 X1 X2
with auto___type_7 : term -> Prop :=
    trans___type_7_key_1 : forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___type_7 (key X1 X2)
with auto___def_41 : term -> Prop :=
    trans___def_41_s_1 : forall X1:term, auto___def_39 X1 -> auto___def_41 (s X1)
with auto___def_33 : term -> term -> term -> term -> Prop :=
    trans___def_33_1 : forall X1 X2 X3 X4:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___def_16 X3 -> auto___def_21 X4 -> auto___def_33 X1 X2 X3 X4
with auto___def_42 : term -> Prop :=
    trans___def_42_pub_1 : auto___def_42 pub
with auto___def_36 : term -> Prop :=
    trans___def_36_nil_1 : auto___def_36 nil
with auto___def_84 : term -> Prop :=
    trans___def_84_s_1 : forall X1:term, auto___def_82 X1 -> auto___def_84 (s X1)
with auto___type_10 : term -> Prop :=
    trans___type_10_s_1 : forall X1:term, auto_knows_current X1 -> auto___type_10 (s X1)
  | trans___type_10_nil_1 : auto___type_10 nil
  | trans___type_10_i_1 : auto___type_10 i
  | trans___type_10_cons_1 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_10 (cons X1 X2)
  | trans___type_10_crypt_1 : forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> auto___type_10 (crypt X1 X2)
  | trans___type_10_crypt_2 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_10 (crypt X1 X2)
  | trans___type_10_crypt_3 : forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> auto___type_10 (crypt X1 X2)
  | trans___type_10_crypt_4 : forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___type_10 (crypt X1 X2)
  | trans___type_10_crypt_5 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___type_10 (crypt X1 X2)
  | trans___type_10_crypt_6 : forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> auto___type_10 (crypt X1 X2)
  | trans___type_10_crypt_7 : forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> auto___type_10 (crypt X1 X2)
  | trans___type_10_bob_1 : auto___type_10 bob
  | trans___type_10_key_1 : forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___type_10 (key X1 X2)
  | trans___type_10_key_2 : forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___type_10 (key X1 X2)
  | trans___type_10_key_3 : forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___type_10 (key X1 X2)
  | trans___type_10_t_old_1 : auto___type_10 t_old
  | trans___type_10_alice_1 : auto___type_10 alice
  | trans___type_10_server_1 : auto___type_10 server
  | trans___type_10_t_current_1 : auto___type_10 t_current
with auto___def_35 : term -> Prop :=
    trans___def_35_crypt_1 : forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> auto___def_35 (crypt X1 X2)
with auto___type_11 : term -> Prop :=
    trans___type_11_crypt_1 : forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> auto___type_11 (crypt X1 X2)
with auto_alice_key_current : term -> term -> Prop :=
    trans_alice_key_current_1 : forall X1 X2:term, auto_knows_current X1 -> auto___def_61 X2 -> auto___def_85 X2 -> auto_alice_key_current X1 X2
with auto___def_34 : term -> Prop :=
    trans___def_34_cons_1 : forall X1 X2:term, auto___def_35 X1 -> auto___def_36 X2 -> auto___def_34 (cons X1 X2)
with auto_bob_key_old : term -> term -> Prop :=
    trans_bob_key_old_1 : forall X1 X2:term, auto_bob_key_old X1 X2
with auto___def_74 : term -> Prop :=
    trans___def_74_cons_1 : forall X1 X2:term, auto___def_30 X1 -> auto___def_31 X2 -> auto___def_74 (cons X1 X2)
with auto___def_75 : term -> Prop :=
    trans___def_75_cons_1 : forall X1 X2:term, auto___type_10 X1 -> auto___def_74 X2 -> auto___def_75 (cons X1 X2)
with auto___def_71 : term -> Prop :=
    trans___def_71_cons_1 : forall X1 X2:term, auto___def_61 X1 -> auto___def_72 X2 -> auto___def_71 (cons X1 X2)
with auto___def_79 : term -> Prop :=
    trans___def_79_nil_1 : auto___def_79 nil
with auto___def_30 : term -> Prop :=
    trans___def_30_server_1 : auto___def_30 server
with auto___def_31 : term -> Prop :=
    trans___def_31_nil_1 : auto___def_31 nil
with auto___def_40 : term -> term -> term -> term -> Prop :=
    trans___def_40_1 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto___type_6 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_16 X4 -> auto___type_5 X4 -> auto___def_40 X1 X2 X3 X4
with auto___def_76 : term -> term -> term -> term -> Prop :=
    trans___def_76_1 : forall X1 X2 X3 X4:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___def_61 X3 -> auto___def_66 X4 -> auto___def_76 X1 X2 X3 X4
with auto___def_82 : term -> Prop :=
    trans___def_82_t_current_1 : auto___def_82 t_current
with auto_bob_key_current : term -> term -> Prop :=
    trans_bob_key_current_1 : forall X1 X2:term, auto_knows_current X1 -> auto___def_61 X2 -> auto___type_12 X2 -> auto_bob_key_current X1 X2
with auto___def_78 : term -> Prop :=
    trans___def_78_crypt_1 : forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> auto___def_78 (crypt X1 X2)
with auto___def_39 : term -> Prop :=
    trans___def_39_t_old_1 : auto___def_39 t_old
with auto___type_5 : term -> Prop :=
    trans___type_5_key_1 : forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___type_5 (key X1 X2)
with auto___type_6 : term -> Prop :=
    trans___type_6_s_1 : forall X1:term, auto_knows_old X1 -> auto___type_6 (s X1)
  | trans___type_6_nil_1 : auto___type_6 nil
  | trans___type_6_i_1 : auto___type_6 i
  | trans___type_6_cons_1 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_6 (cons X1 X2)
  | trans___type_6_crypt_1 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_6 (crypt X1 X2)
  | trans___type_6_crypt_2 : forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> auto___type_6 (crypt X1 X2)
  | trans___type_6_crypt_3 : forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___type_6 (crypt X1 X2)
  | trans___type_6_crypt_4 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___type_6 (crypt X1 X2)
  | trans___type_6_crypt_5 : forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> auto___type_6 (crypt X1 X2)
  | trans___type_6_bob_1 : auto___type_6 bob
  | trans___type_6_key_1 : forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___type_6 (key X1 X2)
  | trans___type_6_key_2 : forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___type_6 (key X1 X2)
  | trans___type_6_t_old_1 : auto___type_6 t_old
  | trans___type_6_alice_1 : auto___type_6 alice
  | trans___type_6_server_1 : auto___type_6 server
with auto___def_73 : term -> Prop :=
    trans___def_73_cons_1 : forall X1 X2:term, auto___type_9 X1 -> auto___def_74 X2 -> auto___def_73 (cons X1 X2)
with auto___def_81 : term -> Prop :=
    trans___def_81_cons_1 : forall X1 X2:term, auto___def_82 X1 -> auto___def_31 X2 -> auto___def_81 (cons X1 X2)
with auto___query__intruder_knows_session_key_as_seen_by_alice : Prop :=
with auto___query__intruder_knows_session_key_generated_by_server : Prop :=
with auto___query__intruder_knows_session_key_as_seen_by_B : Prop :=
with auto___def_6 : term -> Prop :=
.

(* [defp] Proofs that all definitions hold. *)


Remark rem_1 : (forall X:term, auto___def_21 X -> auto___type_4 X)
    -> forall X1:term, auto___def_23 X1 -> auto___def_23 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2 : (forall X:term, auto___def_21 X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_23 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_21_p__type_4. intros X1 X2.
  cut (auto___def_23 X1 -> auto___def_23 X1). tauto. exact (rem_1 epsilon_m__def_21_p__type_4 X1).
Defined.

Remark rem_3 : (forall X:term, auto___def_21 X -> auto___type_4 X)
    -> forall X2:term, auto___def_24 X2 -> auto___def_24 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_4 : (forall X:term, auto___def_21 X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_24 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_21_p__type_4. intros X1 X2.
  cut (auto___def_24 X2 -> auto___def_24 X2). tauto. exact (rem_3 epsilon_m__def_21_p__type_4 X2).
Defined.

Remark rem_5 : (forall X:term, auto___def_21 X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> (auto___def_23 X1 /\ auto___def_24 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_21_p__type_4. intros X1 X2. intros A1 A2.
  cut (auto___def_23 X1). 2:apply (rem_2 epsilon_m__def_21_p__type_4 X1 X2);  assumption.
  cut (auto___def_24 X2). 2:apply (rem_4 epsilon_m__def_21_p__type_4 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_6 : (forall X:term, auto___def_21 X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___type_4 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_21_p__type_4. intros X1 X2. intros A1 A2.
  case (rem_5 epsilon_m__def_21_p__type_4 X1 X2 A1 A2). clear  epsilon_m__def_21_p__type_4 A1 A2. intros. apply trans___type_4_crypt_1;  tauto.
 clear  epsilon_m__def_21_p__type_4 A1 A2. tauto.
Defined.

Inductive or_1(H1:Prop) : Prop :=
    or_1_intro_1 : H1 -> (or_1 H1)
.

Remark rem_7 : forall X1 X2:term, auto___def_21 (crypt X1 X2) -> or_1
    (auto___def_23 X1 /\ auto___def_24 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_8 : (forall X:term, auto___def_21 X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_21 (crypt X1 X2) -> auto___type_4 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_21_p__type_4. intros X1 X2. intro H. intros.
  elim (rem_7 X1 X2 H);  intros.
  apply (rem_6 epsilon_m__def_21_p__type_4 X1 X2);  tauto.
Defined.

Inductive or_0 : Prop :=
.

Remark rem_9 : forall X1 X2:term, auto___def_21 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_10 : forall X1:term, auto___def_21 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_11 : auto___def_21 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_12 : auto___def_21 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_13 : forall X1 X2:term, auto___def_21 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_14 : forall X1 X2:term, auto___def_21 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_15 : auto___def_21 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_16 : auto___def_21 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_17 : forall X1 X2:term, auto___def_21 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_18 : auto___def_21 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_19 : forall X1 X2:term, auto___def_21 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_20 : auto___def_21 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_21 : auto___def_21 t_old -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_22 : auto___def_21 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_23 : auto___def_21 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_24 : auto___def_21 t_current -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_25 : forall X1:term, auto___def_21 X1 -> auto___type_4 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_21_p__type_4 1.
  intro X. case X.
   intro H. elim (rem_22  H).
   intro H. elim (rem_18  H).
  intros X1 X2. intro H. elim (rem_14 X1 X2 H).
  intros X1 X2;  exact (rem_8 epsilon_m__def_21_p__type_4 X1 X2).
   intro H. elim (rem_12  H).
  intros X1 X2. intro H. elim (rem_19 X1 X2 H).
  intros X1 X2. intro H. elim (rem_17 X1 X2 H).
   intro H. elim (rem_11  H).
   intro H. elim (rem_16  H).
   intro H. elim (rem_20  H).
  intros X1. intro H. elim (rem_10 X1 H).
   intro H. elim (rem_23  H).
  intros X1 X2. intro H. elim (rem_9 X1 X2 H).
  intros X1 X2. intro H. elim (rem_13 X1 X2 H).
   intro H. elim (rem_15  H).
   intro H. elim (rem_24  H).
   intro H. elim (rem_21  H).
Qed.

Remark rem_26 : forall X1 X2 X3 X4:term, auto___def_16 X2 -> auto___def_21 X1 -> auto_knows_old X3 -> auto_knows_old X4 -> auto___type_4 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_21 X1 -> auto___type_4 X1). tauto. exact (rem_25 X1).
Qed.

Remark rem_27 : forall X1 X2 X3 X4:term, auto_knows_old X2 -> auto_knows_old X3 -> auto___def_16 X4 -> auto___def_21 X1 -> auto___type_4 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X3 X4 X2.
  cut (auto___def_16 X2 -> auto___def_21 X1 -> auto_knows_old X3 -> auto_knows_old X4 -> auto___type_4 X1). tauto. exact (rem_26 X1 X2 X3 X4).
Qed.

Remark rem_28 : forall X1 X2 X3 X4:term, auto___def_33 X1 X2 X3 X4 -> or_1
    (auto_knows_old X1 /\ auto_knows_old X2 /\ auto___def_16 X3 /\ auto___def_21 X4)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_29 : forall X1 X2 X3 X4:term, auto___def_33 X2 X3 X4 X1 -> auto___type_4 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_28 X2 X3 X4 X1 H);  intros.
  apply (rem_27 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_30 : forall X1:term, auto___def_12 X1 -> auto___def_12 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_31 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_12 X1). tauto. exact (rem_30 X1).
Qed.

Remark rem_32 : forall X2:term, auto___def_13 X2 -> auto___def_13 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_33 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_32 X2).
Qed.

Remark rem_34 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> (auto___def_12 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_12 X1). 2:apply (rem_31 X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_33 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_35 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_10 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_34 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_10_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_36 : forall X1 X2:term, auto___def_13 X2 -> auto___def_12 X1 -> auto___def_10 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_13 X2 -> auto___def_10 (cons X1 X2)). tauto. exact (rem_35 X1 X2).
Qed.

Remark rem_37 : True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
   tauto.
Qed.

Remark rem_38 : auto___def_30 server. (* Deduce positive atom. *)
Proof.
   case rem_37. intros. apply trans___def_30_server_1;  tauto.
 tauto.
Qed.

Remark rem_39 : forall X1 X2:term, auto___def_31 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_40 : forall X1 X2 X3 X4:term, auto___def_31 (cons X4 (cons X1 nil)) -> auto___def_82 (l X2 X3) -> auto___type_12 X4 -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_39 X4 (cons X1 nil) H);  intros.
Qed.

Remark rem_41 : forall X1 X2 X3 X4:term, auto___def_82 (l X2 X3) -> auto___def_31 (cons X4 (cons X1 nil)) -> auto___type_12 X4 -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_31 (cons X4 (cons X1 nil)) -> auto___def_82 (l X2 X3) -> auto___type_12 X4 -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_40 X1 X2 X3 X4).
Qed.

Remark rem_42 : forall X1 X2:term, auto___def_81 (cons X1 X2) -> or_1
    (auto___def_82 X1 /\ auto___def_31 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_43 : forall X1 X2 X3 X4:term, auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 X4 -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_42 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_41 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_44 : forall X1 X2 X3 X4:term, auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 X4 -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___type_13 X1 -> auto___type_13 t_current -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 X4 -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_43 X1 X2 X3 X4).
Qed.

Remark rem_45 : forall X1 X2 X3 X4:term, auto___type_13 t_current -> auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 X4 -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 X4 -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___type_13 X1 -> auto___type_13 t_current -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_44 X1 X2 X3 X4).
Qed.

Remark rem_46 : forall X1 X2:term, auto___def_80 (cons X1 X2) -> or_1
    (auto___type_13 X1 /\ auto___def_81 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_47 : forall X1 X2 X3 X4:term, auto___def_80 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_12 X4 -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_46 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_45 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_48 : forall X1 X2 X3 X4:term, auto___def_80 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_80 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_12 X4 -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_47 X1 X2 X3 X4).
Qed.

Remark rem_49 : auto___def_42 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_50 : (forall X:term, auto___def_63 X -> auto___def_42 X -> False)
    -> auto___def_42 sym -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_63_m__def_42. intro H. intros.
  elim (rem_49 H);  intros.
Defined.

Remark rem_51 : auto___def_63 sym -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_52 : (forall X:term, auto___def_63 X -> auto___def_42 X -> False)
    -> auto___def_63 sym -> auto___def_42 sym -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_63_m__def_42. intro H. intros.
  elim (rem_51 H);  intros.
  apply (rem_50 epsilon_m__def_63_m__def_42);  tauto.
Defined.

Remark rem_53 : forall X1 X2:term, auto___def_63 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_54 : forall X1:term, auto___def_63 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_55 : auto___def_63 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_56 : auto___def_63 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_57 : forall X1 X2:term, auto___def_63 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_58 : forall X1 X2:term, auto___def_63 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_59 : auto___def_63 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_60 : forall X1 X2:term, auto___def_63 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_61 : forall X1 X2:term, auto___def_63 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_62 : auto___def_63 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_63 : forall X1 X2:term, auto___def_63 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_64 : auto___def_63 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_65 : auto___def_63 t_old -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_66 : auto___def_63 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_67 : auto___def_63 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_68 : auto___def_63 t_current -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_69 : forall X1:term, auto___def_63 X1 -> auto___def_42 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_63_m__def_42 1.
  intro X. case X.
   intro H. elim (rem_66  H).
   intro H. elim (rem_62  H).
  intros X1 X2. intro H. elim (rem_58 X1 X2 H).
  intros X1 X2. intro H. elim (rem_61 X1 X2 H).
   intro H. elim (rem_56  H).
  intros X1 X2. intro H. elim (rem_63 X1 X2 H).
  intros X1 X2. intro H. elim (rem_60 X1 X2 H).
   intro H. elim (rem_55  H).
   intro H. elim (rem_59  H).
   intro H. elim (rem_64  H).
  intros X1. intro H. elim (rem_54 X1 H).
   intro H. elim (rem_67  H).
  intros X1 X2. intro H. elim (rem_53 X1 X2 H).
  intros X1 X2. intro H. elim (rem_57 X1 X2 H).
  exact (rem_52 epsilon_m__def_63_m__def_42 ).
   intro H. elim (rem_68  H).
   intro H. elim (rem_65  H).
Qed.

Remark rem_70 : (forall X:term, auto___type_12 X -> auto_knows_current X -> False)
    -> forall X1:term, auto___def_63 X1 -> auto___def_42 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_m__type_12_mknows_current. exact (rem_69).
Defined.

Remark rem_71 : (forall X:term, auto___type_12 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto___def_64 X2 -> auto___def_63 X1 -> auto___def_42 X1 -> auto___type_8 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m__type_12_mknows_current. intros X1 X2.
  cut (auto___def_63 X1 -> auto___def_42 X1 -> False). clear  epsilon_m__type_12_mknows_current. tauto.
  exact (rem_70 epsilon_m__type_12_mknows_current X1).
Defined.

Remark rem_72 : forall X1 X2:term, auto___def_47 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_73 : (forall X:term, auto___def_64 X -> auto___def_47 X -> False)
    -> forall X1 X2:term, auto___def_47 (session_current X1 X2) -> auto_knows_current X1 -> auto_knows_current X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_64_m__def_47. intros X1 X2. intro H. intros.
  elim (rem_72 X1 X2 H);  intros.
Defined.

Remark rem_74 : forall X1 X2:term, auto___def_64 (session_current X1 X2) -> or_1
    (auto_knows_current X1 /\ auto_knows_current X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_75 : (forall X:term, auto___def_64 X -> auto___def_47 X -> False)
    -> forall X1 X2:term, auto___def_64 (session_current X1 X2) -> auto___def_47 (session_current X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_64_m__def_47. intros X1 X2. intro H. intros.
  elim (rem_74 X1 X2 H);  intros.
  apply (rem_73 epsilon_m__def_64_m__def_47 X1 X2);  tauto.
Defined.

Remark rem_76 : forall X1:term, auto___def_64 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_77 : auto___def_64 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_78 : auto___def_64 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_79 : forall X1 X2:term, auto___def_64 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_80 : forall X1 X2:term, auto___def_64 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_81 : auto___def_64 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_82 : auto___def_64 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_83 : forall X1 X2:term, auto___def_64 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_84 : forall X1 X2:term, auto___def_64 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_85 : auto___def_64 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_86 : forall X1 X2:term, auto___def_64 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_87 : auto___def_64 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_88 : auto___def_64 t_old -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_89 : auto___def_64 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_90 : auto___def_64 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_91 : auto___def_64 t_current -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_92 : forall X2:term, auto___def_64 X2 -> auto___def_47 X2 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_64_m__def_47 1.
  intro X. case X.
   intro H. elim (rem_89  H).
   intro H. elim (rem_85  H).
  intros X1 X2. intro H. elim (rem_80 X1 X2 H).
  intros X1 X2. intro H. elim (rem_84 X1 X2 H).
   intro H. elim (rem_78  H).
  intros X1 X2. intro H. elim (rem_86 X1 X2 H).
  intros X1 X2. intro H. elim (rem_83 X1 X2 H).
   intro H. elim (rem_77  H).
   intro H. elim (rem_82  H).
   intro H. elim (rem_87  H).
  intros X1. intro H. elim (rem_76 X1 H).
   intro H. elim (rem_90  H).
  intros X1 X2;  exact (rem_75 epsilon_m__def_64_m__def_47 X1 X2).
  intros X1 X2. intro H. elim (rem_79 X1 X2 H).
   intro H. elim (rem_81  H).
   intro H. elim (rem_91  H).
   intro H. elim (rem_88  H).
Qed.

Remark rem_93 : (forall X:term, auto___type_12 X -> auto_knows_current X -> False)
    -> forall X2:term, auto___def_64 X2 -> auto___def_47 X2 -> False. (* Cut history. *)
Proof.  intros epsilon_m__type_12_mknows_current. exact (rem_92).
Defined.

Remark rem_94 : (forall X:term, auto___type_12 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto___def_64 X2 -> auto___def_47 X2 -> auto___def_46 X1 -> auto___def_63 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m__type_12_mknows_current. intros X1 X2.
  cut (auto___def_64 X2 -> auto___def_47 X2 -> False). clear  epsilon_m__type_12_mknows_current. tauto.
  exact (rem_93 epsilon_m__type_12_mknows_current X2).
Defined.

Remark rem_95 : auto___def_43 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_96 : (forall X:term, auto___def_63 X -> auto___def_43 X -> False)
    -> auto___def_43 sym -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_63_m__def_43. intro H. intros.
  elim (rem_95 H);  intros.
Defined.

Remark rem_97 : (forall X:term, auto___def_63 X -> auto___def_43 X -> False)
    -> auto___def_63 sym -> auto___def_43 sym -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_63_m__def_43. intro H. intros.
  elim (rem_51 H);  intros.
  apply (rem_96 epsilon_m__def_63_m__def_43);  tauto.
Defined.

Remark rem_98 : forall X1:term, auto___def_63 X1 -> auto___def_43 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_63_m__def_43 1.
  intro X. case X.
   intro H. elim (rem_66  H).
   intro H. elim (rem_62  H).
  intros X1 X2. intro H. elim (rem_58 X1 X2 H).
  intros X1 X2. intro H. elim (rem_61 X1 X2 H).
   intro H. elim (rem_56  H).
  intros X1 X2. intro H. elim (rem_63 X1 X2 H).
  intros X1 X2. intro H. elim (rem_60 X1 X2 H).
   intro H. elim (rem_55  H).
   intro H. elim (rem_59  H).
   intro H. elim (rem_64  H).
  intros X1. intro H. elim (rem_54 X1 H).
   intro H. elim (rem_67  H).
  intros X1 X2. intro H. elim (rem_53 X1 X2 H).
  intros X1 X2. intro H. elim (rem_57 X1 X2 H).
  exact (rem_97 epsilon_m__def_63_m__def_43 ).
   intro H. elim (rem_68  H).
   intro H. elim (rem_65  H).
Qed.

Remark rem_99 : (forall X:term, auto___type_12 X -> auto_knows_current X -> False)
    -> forall X1:term, auto___def_63 X1 -> auto___def_43 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_m__type_12_mknows_current. exact (rem_98).
Defined.

Remark rem_100 : (forall X:term, auto___type_12 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_64 X2 -> auto___def_44 X2 -> auto___def_63 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m__type_12_mknows_current. intros X1 X2.
  cut (auto___def_63 X1 -> auto___def_43 X1 -> False). clear  epsilon_m__type_12_mknows_current. tauto.
  exact (rem_99 epsilon_m__type_12_mknows_current X1).
Defined.

Inductive or_3(H1 H2 H3:Prop) : Prop :=
    or_3_intro_1 : H1 -> (or_3 H1 H2 H3)
  | or_3_intro_2 : H2 -> (or_3 H1 H2 H3)
  | or_3_intro_3 : H3 -> (or_3 H1 H2 H3)
.

Remark rem_101 : forall X1 X2:term, auto_knows_current (key X1 X2) -> or_3
    (auto___def_42 X1 /\ auto___type_8 X2)
    (auto___def_46 X1 /\ auto___def_47 X2)
    (auto___def_43 X1 /\ auto___def_44 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_102 : (forall X:term, auto___type_12 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto_knows_current (key X1 X2) -> auto___def_63 X1 -> auto___def_64 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_12_mknows_current. intros X1 X2. intro H. intros.
  elim (rem_101 X1 X2 H);  intros.
  apply (rem_71 epsilon_m__type_12_mknows_current X1 X2);  tauto.
  apply (rem_94 epsilon_m__type_12_mknows_current X1 X2);  tauto.
  apply (rem_100 epsilon_m__type_12_mknows_current X1 X2);  tauto.
Defined.

Remark rem_103 : forall X1 X2:term, auto___type_12 (key X1 X2) -> or_1
    (auto___def_63 X1 /\ auto___def_64 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_104 : (forall X:term, auto___type_12 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto___type_12 (key X1 X2) -> auto_knows_current (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_12_mknows_current. intros X1 X2. intro H. intros.
  elim (rem_103 X1 X2 H);  intros.
  apply (rem_102 epsilon_m__type_12_mknows_current X1 X2);  tauto.
Defined.

Remark rem_105 : forall X1 X2:term, auto___type_12 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_106 : forall X1:term, auto___type_12 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_107 : auto___type_12 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_108 : auto___type_12 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_109 : forall X1 X2:term, auto___type_12 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_110 : forall X1 X2:term, auto___type_12 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_111 : auto___type_12 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_112 : auto___type_12 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_113 : forall X1 X2:term, auto___type_12 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_114 : forall X1 X2:term, auto___type_12 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_115 : auto___type_12 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_116 : auto___type_12 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_117 : auto___type_12 t_old -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_118 : auto___type_12 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_119 : auto___type_12 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_120 : auto___type_12 t_current -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_121 : forall X1:term, auto___type_12 X1 -> auto_knows_current X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__type_12_mknows_current 1.
  intro X. case X.
   intro H. elim (rem_118  H).
   intro H. elim (rem_115  H).
  intros X1 X2. intro H. elim (rem_110 X1 X2 H).
  intros X1 X2. intro H. elim (rem_114 X1 X2 H).
   intro H. elim (rem_108  H).
  intros X1 X2;  exact (rem_104 epsilon_m__type_12_mknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_113 X1 X2 H).
   intro H. elim (rem_107  H).
   intro H. elim (rem_112  H).
   intro H. elim (rem_116  H).
  intros X1. intro H. elim (rem_106 X1 H).
   intro H. elim (rem_119  H).
  intros X1 X2. intro H. elim (rem_105 X1 X2 H).
  intros X1 X2. intro H. elim (rem_109 X1 X2 H).
   intro H. elim (rem_111  H).
   intro H. elim (rem_120  H).
   intro H. elim (rem_117  H).
Qed.

Remark rem_122 : forall X1 X2 X3 X4:term, auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current X4 -> auto_knows_current (cons X1 nil) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_121 X4)). tauto.
Qed.

Remark rem_123 : forall X1 X2 X3 X4:term, auto_knows_current X4 -> auto_knows_current (cons X1 nil) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current X4 -> auto_knows_current (cons X1 nil) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_122 X1 X2 X3 X4).
Qed.

Remark rem_124 : forall X1 X2:term, auto_knows_current (cons X1 X2) -> or_1
    (auto_knows_current X1 /\ auto_knows_current X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_125 : forall X1 X2 X3 X4:term, auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_124 X4 (cons X1 nil) H);  intros.
  apply (rem_123 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_126 : forall X1 X2 X3 X4:term, auto_knows_current (l X2 X3) -> auto_knows_current (cons X4 (cons X1 nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_125 X1 X2 X3 X4).
Qed.

Remark rem_127 : forall X1 X2 X3 X4:term, auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_124 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_126 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_128 : forall X1 X2 X3 X4:term, auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current t_current -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_127 X1 X2 X3 X4).
Qed.

Remark rem_129 : forall X1 X2 X3 X4:term, auto_knows_current t_current -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current t_current -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_128 X1 X2 X3 X4).
Qed.

Remark rem_130 : forall X1 X2 X3 X4:term, auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_124 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_129 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_131 : forall X1 X2 X3 X4:term, auto_knows_current (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_130 X1 X2 X3 X4).
Qed.

Remark rem_132 : forall X1 X2:term, auto___def_84 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_133 : forall X1 X2 X3 X4:term, auto___def_84 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___type_14 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_132 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
Qed.

Remark rem_134 : forall X1 X2 X3 X4:term, auto___def_84 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_14 (key sym (cons X3 (cons server nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_84 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___type_14 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_133 X1 X2 X3 X4).
Qed.

Remark rem_135 : forall X1:term, auto___type_13 X1 -> auto___type_13 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_136 : forall X1 X2 X3 X4:term, auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___type_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_13 X1 -> auto___type_13 X1). tauto. exact (rem_135 X1).
Qed.

Remark rem_137 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_138 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_137 epsilon_m__type_13_p__type_10 X1);  assumption.
  tauto.
Defined.

Remark rem_139 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1:term, auto_knows_current X1 -> auto___type_10 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1. intros A1.
  case (rem_138 epsilon_m__type_13_p__type_10 X1 A1). clear  epsilon_m__type_13_p__type_10 A1. intros. apply trans___type_10_s_1;  tauto.
 clear  epsilon_m__type_13_p__type_10 A1. tauto.
Defined.

Remark rem_140 : forall X1:term, auto___type_13 (s X1) -> or_1
    (auto_knows_current X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_141 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1:term, auto___type_13 (s X1) -> auto___type_10 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1. intro H. intros.
  elim (rem_140 X1 H);  intros.
  apply (rem_139 epsilon_m__type_13_p__type_10 X1);  tauto.
Defined.

Remark rem_142 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_13_p__type_10.  tauto.
Defined.

Remark rem_143 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> auto___type_10 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10.  case (rem_142 epsilon_m__type_13_p__type_10). clear  epsilon_m__type_13_p__type_10. intros. apply trans___type_10_nil_1;  tauto.
 clear  epsilon_m__type_13_p__type_10. tauto.
Defined.

Remark rem_144 : auto___type_13 nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_145 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> auto___type_13 nil -> auto___type_10 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intro H. intros.
  elim (rem_144 H);  intros.
  apply (rem_143 epsilon_m__type_13_p__type_10);  tauto.
Defined.

Remark rem_146 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> auto___type_10 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10.  case (rem_142 epsilon_m__type_13_p__type_10). clear  epsilon_m__type_13_p__type_10. intros. apply trans___type_10_i_1;  tauto.
 clear  epsilon_m__type_13_p__type_10. tauto.
Defined.

Remark rem_147 : auto___type_13 i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_148 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> auto___type_13 i -> auto___type_10 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intro H. intros.
  elim (rem_147 H);  intros.
  apply (rem_146 epsilon_m__type_13_p__type_10);  tauto.
Defined.

Remark rem_149 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_137 epsilon_m__type_13_p__type_10 X1).
Defined.

Remark rem_150 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X2:term, auto_knows_current X2 -> auto_knows_current X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_151 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_150 epsilon_m__type_13_p__type_10 X2).
Defined.

Remark rem_152 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_149 epsilon_m__type_13_p__type_10 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_151 epsilon_m__type_13_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_153 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_10 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_152 epsilon_m__type_13_p__type_10 X1 X2 A1 A2). clear  epsilon_m__type_13_p__type_10 A1 A2. intros. apply trans___type_10_cons_1;  tauto.
 clear  epsilon_m__type_13_p__type_10 A1 A2. tauto.
Defined.

Remark rem_154 : forall X1 X2:term, auto___type_13 (cons X1 X2) -> or_1
    (auto_knows_current X1 /\ auto_knows_current X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_155 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___type_13 (cons X1 X2) -> auto___type_10 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2. intro H. intros.
  elim (rem_154 X1 X2 H);  intros.
  apply (rem_153 epsilon_m__type_13_p__type_10 X1 X2);  tauto.
Defined.

Remark rem_156 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1:term, auto___def_80 X1 -> auto___def_80 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_157 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> auto___def_80 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2.
  cut (auto___def_80 X1 -> auto___def_80 X1). tauto. exact (rem_156 epsilon_m__type_13_p__type_10 X1).
Defined.

Remark rem_158 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X2:term, auto___type_12 X2 -> auto___type_12 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_159 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> auto___type_12 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2.
  cut (auto___type_12 X2 -> auto___type_12 X2). tauto. exact (rem_158 epsilon_m__type_13_p__type_10 X2).
Defined.

Remark rem_160 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> (auto___def_80 X1 /\ auto___type_12 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_80 X1). 2:apply (rem_157 epsilon_m__type_13_p__type_10 X1 X2);  assumption.
  cut (auto___type_12 X2). 2:apply (rem_159 epsilon_m__type_13_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_161 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> auto___type_10 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_160 epsilon_m__type_13_p__type_10 X1 X2 A1 A2). clear  epsilon_m__type_13_p__type_10 A1 A2. intros. apply trans___type_10_crypt_1;  tauto.
 clear  epsilon_m__type_13_p__type_10 A1 A2. tauto.
Defined.

Remark rem_162 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_10 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_152 epsilon_m__type_13_p__type_10 X1 X2 A1 A2). clear  epsilon_m__type_13_p__type_10 A1 A2. intros. apply trans___type_10_crypt_2;  tauto.
 clear  epsilon_m__type_13_p__type_10 A1 A2. tauto.
Defined.

Remark rem_163 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1:term, auto___def_84 X1 -> auto___def_84 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_164 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> auto___def_84 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2.
  cut (auto___def_84 X1 -> auto___def_84 X1). tauto. exact (rem_163 epsilon_m__type_13_p__type_10 X1).
Defined.

Remark rem_165 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X2:term, auto___type_14 X2 -> auto___type_14 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_166 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> auto___type_14 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2.
  cut (auto___type_14 X2 -> auto___type_14 X2). tauto. exact (rem_165 epsilon_m__type_13_p__type_10 X2).
Defined.

Remark rem_167 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> (auto___def_84 X1 /\ auto___type_14 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_84 X1). 2:apply (rem_164 epsilon_m__type_13_p__type_10 X1 X2);  assumption.
  cut (auto___type_14 X2). 2:apply (rem_166 epsilon_m__type_13_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_168 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> auto___type_10 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_167 epsilon_m__type_13_p__type_10 X1 X2 A1 A2). clear  epsilon_m__type_13_p__type_10 A1 A2. intros. apply trans___type_10_crypt_3;  tauto.
 clear  epsilon_m__type_13_p__type_10 A1 A2. tauto.
Defined.

Remark rem_169 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1:term, auto___def_23 X1 -> auto___def_23 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_170 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_23 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2.
  cut (auto___def_23 X1 -> auto___def_23 X1). tauto. exact (rem_169 epsilon_m__type_13_p__type_10 X1).
Defined.

Remark rem_171 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X2:term, auto___def_24 X2 -> auto___def_24 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_172 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_24 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2.
  cut (auto___def_24 X2 -> auto___def_24 X2). tauto. exact (rem_171 epsilon_m__type_13_p__type_10 X2).
Defined.

Remark rem_173 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> (auto___def_23 X1 /\ auto___def_24 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_23 X1). 2:apply (rem_170 epsilon_m__type_13_p__type_10 X1 X2);  assumption.
  cut (auto___def_24 X2). 2:apply (rem_172 epsilon_m__type_13_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_174 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___type_10 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_173 epsilon_m__type_13_p__type_10 X1 X2 A1 A2). clear  epsilon_m__type_13_p__type_10 A1 A2. intros. apply trans___type_10_crypt_4;  tauto.
 clear  epsilon_m__type_13_p__type_10 A1 A2. tauto.
Defined.

Remark rem_175 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1:term, auto___def_10 X1 -> auto___def_10 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_176 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_10 X1). tauto. exact (rem_175 epsilon_m__type_13_p__type_10 X1).
Defined.

Remark rem_177 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X2:term, auto___def_11 X2 -> auto___def_11 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_178 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2.
  cut (auto___def_11 X2 -> auto___def_11 X2). tauto. exact (rem_177 epsilon_m__type_13_p__type_10 X2).
Defined.

Remark rem_179 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> (auto___def_10 X1 /\ auto___def_11 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_10 X1). 2:apply (rem_176 epsilon_m__type_13_p__type_10 X1 X2);  assumption.
  cut (auto___def_11 X2). 2:apply (rem_178 epsilon_m__type_13_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_180 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___type_10 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_179 epsilon_m__type_13_p__type_10 X1 X2 A1 A2). clear  epsilon_m__type_13_p__type_10 A1 A2. intros. apply trans___type_10_crypt_5;  tauto.
 clear  epsilon_m__type_13_p__type_10 A1 A2. tauto.
Defined.

Remark rem_181 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1:term, auto___def_55 X1 -> auto___def_55 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_182 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> auto___def_55 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2.
  cut (auto___def_55 X1 -> auto___def_55 X1). tauto. exact (rem_181 epsilon_m__type_13_p__type_10 X1).
Defined.

Remark rem_183 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X2:term, auto___def_56 X2 -> auto___def_56 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_184 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> auto___def_56 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2.
  cut (auto___def_56 X2 -> auto___def_56 X2). tauto. exact (rem_183 epsilon_m__type_13_p__type_10 X2).
Defined.

Remark rem_185 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> (auto___def_55 X1 /\ auto___def_56 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_55 X1). 2:apply (rem_182 epsilon_m__type_13_p__type_10 X1 X2);  assumption.
  cut (auto___def_56 X2). 2:apply (rem_184 epsilon_m__type_13_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_186 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> auto___type_10 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_185 epsilon_m__type_13_p__type_10 X1 X2 A1 A2). clear  epsilon_m__type_13_p__type_10 A1 A2. intros. apply trans___type_10_crypt_6;  tauto.
 clear  epsilon_m__type_13_p__type_10 A1 A2. tauto.
Defined.

Remark rem_187 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1:term, auto___def_68 X1 -> auto___def_68 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_188 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> auto___def_68 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2.
  cut (auto___def_68 X1 -> auto___def_68 X1). tauto. exact (rem_187 epsilon_m__type_13_p__type_10 X1).
Defined.

Remark rem_189 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X2:term, auto___def_69 X2 -> auto___def_69 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_190 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> auto___def_69 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2.
  cut (auto___def_69 X2 -> auto___def_69 X2). tauto. exact (rem_189 epsilon_m__type_13_p__type_10 X2).
Defined.

Remark rem_191 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> (auto___def_68 X1 /\ auto___def_69 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_68 X1). 2:apply (rem_188 epsilon_m__type_13_p__type_10 X1 X2);  assumption.
  cut (auto___def_69 X2). 2:apply (rem_190 epsilon_m__type_13_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_192 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> auto___type_10 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_191 epsilon_m__type_13_p__type_10 X1 X2 A1 A2). clear  epsilon_m__type_13_p__type_10 A1 A2. intros. apply trans___type_10_crypt_7;  tauto.
 clear  epsilon_m__type_13_p__type_10 A1 A2. tauto.
Defined.

Inductive or_7(H1 H2 H3 H4 H5 H6 H7:Prop) : Prop :=
    or_7_intro_1 : H1 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_2 : H2 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_3 : H3 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_4 : H4 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_5 : H5 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_6 : H6 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_7 : H7 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
.

Remark rem_193 : forall X1 X2:term, auto___type_13 (crypt X1 X2) -> or_7
    (auto___def_80 X1 /\ auto___type_12 X2)
    (auto_knows_current X1 /\ auto_knows_current X2)
    (auto___def_84 X1 /\ auto___type_14 X2)
    (auto___def_23 X1 /\ auto___def_24 X2)
    (auto___def_10 X1 /\ auto___def_11 X2)
    (auto___def_55 X1 /\ auto___def_56 X2)
    (auto___def_68 X1 /\ auto___def_69 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_7_intro_1; tauto.
  intros. apply or_7_intro_2; tauto.
  intros. apply or_7_intro_3; tauto.
  intros. apply or_7_intro_4; tauto.
  intros. apply or_7_intro_5; tauto.
  intros. apply or_7_intro_6; tauto.
  intros. apply or_7_intro_7; tauto.
Qed.

Remark rem_194 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___type_13 (crypt X1 X2) -> auto___type_10 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2. intro H. intros.
  elim (rem_193 X1 X2 H);  intros.
  apply (rem_161 epsilon_m__type_13_p__type_10 X1 X2);  tauto.
  apply (rem_162 epsilon_m__type_13_p__type_10 X1 X2);  tauto.
  apply (rem_168 epsilon_m__type_13_p__type_10 X1 X2);  tauto.
  apply (rem_174 epsilon_m__type_13_p__type_10 X1 X2);  tauto.
  apply (rem_180 epsilon_m__type_13_p__type_10 X1 X2);  tauto.
  apply (rem_186 epsilon_m__type_13_p__type_10 X1 X2);  tauto.
  apply (rem_192 epsilon_m__type_13_p__type_10 X1 X2);  tauto.
Defined.

Remark rem_195 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> auto___type_10 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10.  case (rem_142 epsilon_m__type_13_p__type_10). clear  epsilon_m__type_13_p__type_10. intros. apply trans___type_10_bob_1;  tauto.
 clear  epsilon_m__type_13_p__type_10. tauto.
Defined.

Remark rem_196 : auto___type_13 bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_197 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> auto___type_13 bob -> auto___type_10 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intro H. intros.
  elim (rem_196 H);  intros.
  apply (rem_195 epsilon_m__type_13_p__type_10);  tauto.
Defined.

Remark rem_198 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1:term, auto___def_42 X1 -> auto___def_42 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_199 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___def_42 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2.
  cut (auto___def_42 X1 -> auto___def_42 X1). tauto. exact (rem_198 epsilon_m__type_13_p__type_10 X1).
Defined.

Remark rem_200 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_201 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_200 epsilon_m__type_13_p__type_10 X2).
Defined.

Remark rem_202 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> (auto___def_42 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_42 X1). 2:apply (rem_199 epsilon_m__type_13_p__type_10 X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_201 epsilon_m__type_13_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_203 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___type_10 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_202 epsilon_m__type_13_p__type_10 X1 X2 A1 A2). clear  epsilon_m__type_13_p__type_10 A1 A2. intros. apply trans___type_10_key_1;  tauto.
 clear  epsilon_m__type_13_p__type_10 A1 A2. tauto.
Defined.

Remark rem_204 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1:term, auto___def_46 X1 -> auto___def_46 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_205 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_46 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2.
  cut (auto___def_46 X1 -> auto___def_46 X1). tauto. exact (rem_204 epsilon_m__type_13_p__type_10 X1).
Defined.

Remark rem_206 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X2:term, auto___def_47 X2 -> auto___def_47 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_207 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_47 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2.
  cut (auto___def_47 X2 -> auto___def_47 X2). tauto. exact (rem_206 epsilon_m__type_13_p__type_10 X2).
Defined.

Remark rem_208 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> (auto___def_46 X1 /\ auto___def_47 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_46 X1). 2:apply (rem_205 epsilon_m__type_13_p__type_10 X1 X2);  assumption.
  cut (auto___def_47 X2). 2:apply (rem_207 epsilon_m__type_13_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_209 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___type_10 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_208 epsilon_m__type_13_p__type_10 X1 X2 A1 A2). clear  epsilon_m__type_13_p__type_10 A1 A2. intros. apply trans___type_10_key_2;  tauto.
 clear  epsilon_m__type_13_p__type_10 A1 A2. tauto.
Defined.

Remark rem_210 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1:term, auto___def_43 X1 -> auto___def_43 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_211 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_43 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_43 X1). tauto. exact (rem_210 epsilon_m__type_13_p__type_10 X1).
Defined.

Remark rem_212 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X2:term, auto___def_44 X2 -> auto___def_44 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_213 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_44 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2.
  cut (auto___def_44 X2 -> auto___def_44 X2). tauto. exact (rem_212 epsilon_m__type_13_p__type_10 X2).
Defined.

Remark rem_214 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> (auto___def_43 X1 /\ auto___def_44 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_43 X1). 2:apply (rem_211 epsilon_m__type_13_p__type_10 X1 X2);  assumption.
  cut (auto___def_44 X2). 2:apply (rem_213 epsilon_m__type_13_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_215 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___type_10 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_214 epsilon_m__type_13_p__type_10 X1 X2 A1 A2). clear  epsilon_m__type_13_p__type_10 A1 A2. intros. apply trans___type_10_key_3;  tauto.
 clear  epsilon_m__type_13_p__type_10 A1 A2. tauto.
Defined.

Remark rem_216 : forall X1 X2:term, auto___type_13 (key X1 X2) -> or_3
    (auto___def_42 X1 /\ auto___type_8 X2)
    (auto___def_46 X1 /\ auto___def_47 X2)
    (auto___def_43 X1 /\ auto___def_44 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_217 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___type_13 (key X1 X2) -> auto___type_10 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intros X1 X2. intro H. intros.
  elim (rem_216 X1 X2 H);  intros.
  apply (rem_203 epsilon_m__type_13_p__type_10 X1 X2);  tauto.
  apply (rem_209 epsilon_m__type_13_p__type_10 X1 X2);  tauto.
  apply (rem_215 epsilon_m__type_13_p__type_10 X1 X2);  tauto.
Defined.

Remark rem_218 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> auto___type_10 t_old. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10.  case (rem_142 epsilon_m__type_13_p__type_10). clear  epsilon_m__type_13_p__type_10. intros. apply trans___type_10_t_old_1;  tauto.
 clear  epsilon_m__type_13_p__type_10. tauto.
Defined.

Remark rem_219 : auto___type_13 t_old -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_220 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> auto___type_13 t_old -> auto___type_10 t_old. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intro H. intros.
  elim (rem_219 H);  intros.
  apply (rem_218 epsilon_m__type_13_p__type_10);  tauto.
Defined.

Remark rem_221 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> auto___type_10 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10.  case (rem_142 epsilon_m__type_13_p__type_10). clear  epsilon_m__type_13_p__type_10. intros. apply trans___type_10_alice_1;  tauto.
 clear  epsilon_m__type_13_p__type_10. tauto.
Defined.

Remark rem_222 : auto___type_13 alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_223 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> auto___type_13 alice -> auto___type_10 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intro H. intros.
  elim (rem_222 H);  intros.
  apply (rem_221 epsilon_m__type_13_p__type_10);  tauto.
Defined.

Remark rem_224 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> auto___type_10 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10.  case (rem_142 epsilon_m__type_13_p__type_10). clear  epsilon_m__type_13_p__type_10. intros. apply trans___type_10_server_1;  tauto.
 clear  epsilon_m__type_13_p__type_10. tauto.
Defined.

Remark rem_225 : auto___type_13 server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_226 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> auto___type_13 server -> auto___type_10 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intro H. intros.
  elim (rem_225 H);  intros.
  apply (rem_224 epsilon_m__type_13_p__type_10);  tauto.
Defined.

Remark rem_227 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> auto___type_10 t_current. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10.  case (rem_142 epsilon_m__type_13_p__type_10). clear  epsilon_m__type_13_p__type_10. intros. apply trans___type_10_t_current_1;  tauto.
 clear  epsilon_m__type_13_p__type_10. tauto.
Defined.

Remark rem_228 : auto___type_13 t_current -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_229 : (forall X:term, auto___type_13 X -> auto___type_10 X)
    -> auto___type_13 t_current -> auto___type_10 t_current. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_13_p__type_10. intro H. intros.
  elim (rem_228 H);  intros.
  apply (rem_227 epsilon_m__type_13_p__type_10);  tauto.
Defined.

Remark rem_230 : forall X1 X2:term, auto___type_13 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_231 : forall X1 X2:term, auto___type_13 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_232 : auto___type_13 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_233 : auto___type_13 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_234 : forall X1 X2:term, auto___type_13 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_235 : auto___type_13 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_236 : forall X1:term, auto___type_13 X1 -> auto___type_10 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_13_p__type_10 1.
  intro X. case X.
  exact (rem_223 epsilon_m__type_13_p__type_10 ).
  exact (rem_197 epsilon_m__type_13_p__type_10 ).
  intros X1 X2;  exact (rem_155 epsilon_m__type_13_p__type_10 X1 X2).
  intros X1 X2;  exact (rem_194 epsilon_m__type_13_p__type_10 X1 X2).
  exact (rem_148 epsilon_m__type_13_p__type_10 ).
  intros X1 X2;  exact (rem_217 epsilon_m__type_13_p__type_10 X1 X2).
  intros X1 X2. intro H. elim (rem_234 X1 X2 H).
  exact (rem_145 epsilon_m__type_13_p__type_10 ).
   intro H. elim (rem_233  H).
   intro H. elim (rem_235  H).
  intros X1;  exact (rem_141 epsilon_m__type_13_p__type_10 X1).
  exact (rem_226 epsilon_m__type_13_p__type_10 ).
  intros X1 X2. intro H. elim (rem_230 X1 X2 H).
  intros X1 X2. intro H. elim (rem_231 X1 X2 H).
   intro H. elim (rem_232  H).
  exact (rem_229 epsilon_m__type_13_p__type_10 ).
  exact (rem_220 epsilon_m__type_13_p__type_10 ).
Qed.

Remark rem_237 : forall X1 X2 X3 X4:term, auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___type_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_13 X1 -> auto___type_10 X1). tauto. exact (rem_236 X1).
Qed.

Remark rem_238 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_current X1. (* Use induction hypothesis. *)
Proof.
   intro Hrec. intros X1.
  cut (auto_knows_old X1 -> auto_knows_current X1). tauto. exact (Hrec X1).
Defined.

Remark rem_239 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_238 epsilon_mknows_old_pknows_current X1);  assumption.
  tauto.
Defined.

Remark rem_240 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_current (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1. intros A1.
  case (rem_239 epsilon_mknows_old_pknows_current X1 A1). clear  epsilon_mknows_old_pknows_current A1. intros. apply trans_knows_current_s_1;  tauto.
 clear  epsilon_mknows_old_pknows_current A1. tauto.
Defined.

Remark rem_241 : forall X1:term, auto_knows_old (s X1) -> or_1
    (auto_knows_old X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_242 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old (s X1) -> auto_knows_current (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1. intro H. intros.
  elim (rem_241 X1 H);  intros.
  apply (rem_240 epsilon_mknows_old_pknows_current X1);  tauto.
Defined.

Remark rem_243 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current.  tauto.
Defined.

Remark rem_244 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_current nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current.  case (rem_243 epsilon_mknows_old_pknows_current). clear  epsilon_mknows_old_pknows_current. intros. apply trans_knows_current_nil_1;  tauto.
 clear  epsilon_mknows_old_pknows_current. tauto.
Defined.

Remark rem_245 : auto_knows_old nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_246 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_old nil -> auto_knows_current nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intro H. intros.
  elim (rem_245 H);  intros.
  apply (rem_244 epsilon_mknows_old_pknows_current);  tauto.
Defined.

Remark rem_247 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_current i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current.  case (rem_243 epsilon_mknows_old_pknows_current). clear  epsilon_mknows_old_pknows_current. intros. apply trans_knows_current_i_1;  tauto.
 clear  epsilon_mknows_old_pknows_current. tauto.
Defined.

Remark rem_248 : auto_knows_old i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_249 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_old i -> auto_knows_current i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intro H. intros.
  elim (rem_248 H);  intros.
  apply (rem_247 epsilon_mknows_old_pknows_current);  tauto.
Defined.

Remark rem_250 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto_knows_old X1 -> auto_knows_current X1). tauto. exact (rem_238 epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_251 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto_knows_old X2 -> auto_knows_current X2. (* Use induction hypothesis. *)
Proof.
   intro Hrec. intros X2.
  cut (auto_knows_old X2 -> auto_knows_current X2). tauto. exact (Hrec X2).
Defined.

Remark rem_252 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_current X2). tauto. exact (rem_251 epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_253 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_250 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_252 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_254 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_253 epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_255 : forall X1 X2:term, auto_knows_old (cons X1 X2) -> or_1
    (auto_knows_old X1 /\ auto_knows_old X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_256 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_255 X1 X2 H);  intros.
  apply (rem_254 epsilon_mknows_old_pknows_current X1 X2);  tauto.
Defined.

Remark rem_257 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_253 epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_crypt_2;  tauto.
 clear  epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_258 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_current X1. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro H. clear H. intro Hrec. intros X1.
  cut (auto_knows_old X1 -> auto_knows_current X1). tauto. exact (Hrec X1).
Defined.

Remark rem_259 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_258 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1);  assumption.
  tauto.
Defined.

Remark rem_260 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_current (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1. intros A1.
  case (rem_259 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 A1). clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current A1. intros. apply trans_knows_current_s_1;  tauto.
 clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current A1. tauto.
Defined.

Remark rem_261 : forall X1:term, auto___type_6 (s X1) -> or_1
    (auto_knows_old X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_262 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto___type_6 (s X1) -> auto_knows_current (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1. intro H. intros.
  elim (rem_261 X1 H);  intros.
  apply (rem_260 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1);  tauto.
Defined.

Remark rem_263 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current.  tauto.
Defined.

Remark rem_264 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_current nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current.  case (rem_263 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current). clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros. apply trans_knows_current_nil_1;  tauto.
 clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. tauto.
Defined.

Remark rem_265 : auto___type_6 nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_266 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto___type_6 nil -> auto_knows_current nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intro H. intros.
  elim (rem_265 H);  intros.
  apply (rem_264 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current);  tauto.
Defined.

Remark rem_267 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_current i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current.  case (rem_263 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current). clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros. apply trans_knows_current_i_1;  tauto.
 clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. tauto.
Defined.

Remark rem_268 : auto___type_6 i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_269 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto___type_6 i -> auto_knows_current i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intro H. intros.
  elim (rem_268 H);  intros.
  apply (rem_267 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current);  tauto.
Defined.

Remark rem_270 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto_knows_old X1 -> auto_knows_current X1). tauto. exact (rem_258 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_271 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto_knows_old X2 -> auto_knows_current X2. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro H. clear H. intro Hrec. intros X2.
  cut (auto_knows_old X2 -> auto_knows_current X2). tauto. exact (Hrec X2).
Defined.

Remark rem_272 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_current X2). tauto. exact (rem_271 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_273 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_270 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_272 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_274 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_273 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_275 : forall X1 X2:term, auto___type_6 (cons X1 X2) -> or_1
    (auto_knows_old X1 /\ auto_knows_old X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_276 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_6 (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_275 X1 X2 H);  intros.
  apply (rem_274 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2);  tauto.
Defined.

Remark rem_277 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_273 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_crypt_2;  tauto.
 clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_278 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto___def_37 X1 -> auto_knows_current X1. (* Use induction hypothesis. *)
Proof.
   intro Hrec. intro H. clear H. intro H. clear H. intros X1.
  cut (auto___def_37 X1 -> auto_knows_current X1). tauto. exact (Hrec X1).
Defined.

Remark rem_279 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_37 X1 -> auto_knows_current X1). tauto. exact (rem_278 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_280 : (forall X:term, auto___def_18 X -> auto___def_46 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_18_p__def_46.  tauto.
Defined.

Remark rem_281 : (forall X:term, auto___def_18 X -> auto___def_46 X)
    -> auto___def_46 sym. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_18_p__def_46.  case (rem_280 epsilon_m__def_18_p__def_46). clear  epsilon_m__def_18_p__def_46. intros. apply trans___def_46_sym_1;  tauto.
 clear  epsilon_m__def_18_p__def_46. tauto.
Defined.

Remark rem_282 : auto___def_18 sym -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_283 : (forall X:term, auto___def_18 X -> auto___def_46 X)
    -> auto___def_18 sym -> auto___def_46 sym. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_18_p__def_46. intro H. intros.
  elim (rem_282 H);  intros.
  apply (rem_281 epsilon_m__def_18_p__def_46);  tauto.
Defined.

Remark rem_284 : forall X1 X2:term, auto___def_18 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_285 : forall X1:term, auto___def_18 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_286 : auto___def_18 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_287 : auto___def_18 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_288 : forall X1 X2:term, auto___def_18 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_289 : forall X1 X2:term, auto___def_18 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_290 : auto___def_18 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_291 : forall X1 X2:term, auto___def_18 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_292 : forall X1 X2:term, auto___def_18 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_293 : auto___def_18 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_294 : forall X1 X2:term, auto___def_18 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_295 : auto___def_18 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_296 : auto___def_18 t_old -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_297 : auto___def_18 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_298 : auto___def_18 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_299 : auto___def_18 t_current -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_300 : forall X1:term, auto___def_18 X1 -> auto___def_46 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_18_p__def_46 1.
  intro X. case X.
   intro H. elim (rem_297  H).
   intro H. elim (rem_293  H).
  intros X1 X2. intro H. elim (rem_289 X1 X2 H).
  intros X1 X2. intro H. elim (rem_292 X1 X2 H).
   intro H. elim (rem_287  H).
  intros X1 X2. intro H. elim (rem_294 X1 X2 H).
  intros X1 X2. intro H. elim (rem_291 X1 X2 H).
   intro H. elim (rem_286  H).
   intro H. elim (rem_290  H).
   intro H. elim (rem_295  H).
  intros X1. intro H. elim (rem_285 X1 H).
   intro H. elim (rem_298  H).
  intros X1 X2. intro H. elim (rem_284 X1 X2 H).
  intros X1 X2. intro H. elim (rem_288 X1 X2 H).
  exact (rem_283 epsilon_m__def_18_p__def_46 ).
   intro H. elim (rem_299  H).
   intro H. elim (rem_296  H).
Qed.

Remark rem_301 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1:term, auto___def_18 X1 -> auto___def_46 X1. (* Cut history. *)
Proof.  intros epsilon_m__type_5_pknows_current. exact (rem_300).
Defined.

Remark rem_302 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_46 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_46 X1). tauto. exact (rem_301 epsilon_m__type_5_pknows_current X1).
Defined.

Remark rem_303 : (forall X:term, auto___def_19 X -> auto___def_47 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_19_p__def_47. intros X1 X2. intros A1 A2.
  tauto.
Defined.

Remark rem_304 : (forall X:term, auto___def_19 X -> auto___def_47 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___def_47 (session_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_19_p__def_47. intros X1 X2. intros A1 A2.
  case (rem_303 epsilon_m__def_19_p__def_47 X1 X2 A1 A2). clear  epsilon_m__def_19_p__def_47 A1 A2. intros. apply trans___def_47_session_old_1;  tauto.
 clear  epsilon_m__def_19_p__def_47 A1 A2. tauto.
Defined.

Remark rem_305 : forall X1 X2:term, auto___def_19 (session_old X1 X2) -> or_1
    (auto_knows_old X1 /\ auto_knows_old X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_306 : (forall X:term, auto___def_19 X -> auto___def_47 X)
    -> forall X1 X2:term, auto___def_19 (session_old X1 X2) -> auto___def_47 (session_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_19_p__def_47. intros X1 X2. intro H. intros.
  elim (rem_305 X1 X2 H);  intros.
  apply (rem_304 epsilon_m__def_19_p__def_47 X1 X2);  tauto.
Defined.

Remark rem_307 : forall X1 X2:term, auto___def_19 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_308 : forall X1:term, auto___def_19 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_309 : auto___def_19 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_310 : auto___def_19 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_311 : forall X1 X2:term, auto___def_19 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_312 : auto___def_19 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_313 : auto___def_19 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_314 : forall X1 X2:term, auto___def_19 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_315 : forall X1 X2:term, auto___def_19 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_316 : auto___def_19 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_317 : forall X1 X2:term, auto___def_19 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_318 : auto___def_19 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_319 : auto___def_19 t_old -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_320 : auto___def_19 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_321 : auto___def_19 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_322 : auto___def_19 t_current -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_323 : forall X2:term, auto___def_19 X2 -> auto___def_47 X2. (* Induct. *)
Proof.
  fix epsilon_m__def_19_p__def_47 1.
  intro X. case X.
   intro H. elim (rem_320  H).
   intro H. elim (rem_316  H).
  intros X1 X2. intro H. elim (rem_311 X1 X2 H).
  intros X1 X2. intro H. elim (rem_315 X1 X2 H).
   intro H. elim (rem_310  H).
  intros X1 X2. intro H. elim (rem_317 X1 X2 H).
  intros X1 X2. intro H. elim (rem_314 X1 X2 H).
   intro H. elim (rem_309  H).
   intro H. elim (rem_313  H).
   intro H. elim (rem_318  H).
  intros X1. intro H. elim (rem_308 X1 H).
   intro H. elim (rem_321  H).
  intros X1 X2. intro H. elim (rem_307 X1 X2 H).
  intros X1 X2;  exact (rem_306 epsilon_m__def_19_p__def_47 X1 X2).
   intro H. elim (rem_312  H).
   intro H. elim (rem_322  H).
   intro H. elim (rem_319  H).
Qed.

Remark rem_324 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X2:term, auto___def_19 X2 -> auto___def_47 X2. (* Cut history. *)
Proof.  intros epsilon_m__type_5_pknows_current. exact (rem_323).
Defined.

Remark rem_325 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_47 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_47 X2). tauto. exact (rem_324 epsilon_m__type_5_pknows_current X2).
Defined.

Remark rem_326 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> (auto___def_46 X1 /\ auto___def_47 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_46 X1). 2:apply (rem_302 epsilon_m__type_5_pknows_current X1 X2);  assumption.
  cut (auto___def_47 X2). 2:apply (rem_325 epsilon_m__type_5_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_327 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_326 epsilon_m__type_5_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_5_pknows_current A1 A2. intros. apply trans_knows_current_key_2;  tauto.
 clear  epsilon_m__type_5_pknows_current A1 A2. tauto.
Defined.

Remark rem_328 : forall X1 X2:term, auto___type_5 (key X1 X2) -> or_1
    (auto___def_18 X1 /\ auto___def_19 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_329 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_5 (key X1 X2) -> auto_knows_current (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_328 X1 X2 H);  intros.
  apply (rem_327 epsilon_m__type_5_pknows_current X1 X2);  tauto.
Defined.

Remark rem_330 : forall X1 X2:term, auto___type_5 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_331 : forall X1:term, auto___type_5 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_332 : auto___type_5 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_333 : auto___type_5 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_334 : forall X1 X2:term, auto___type_5 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_335 : forall X1 X2:term, auto___type_5 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_336 : auto___type_5 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_337 : auto___type_5 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_338 : forall X1 X2:term, auto___type_5 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_339 : forall X1 X2:term, auto___type_5 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_340 : auto___type_5 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_341 : auto___type_5 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_342 : auto___type_5 t_old -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_343 : auto___type_5 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_344 : auto___type_5 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_345 : auto___type_5 t_current -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_346 : forall X2:term, auto___type_5 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__type_5_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_343  H).
   intro H. elim (rem_340  H).
  intros X1 X2. intro H. elim (rem_335 X1 X2 H).
  intros X1 X2. intro H. elim (rem_339 X1 X2 H).
   intro H. elim (rem_333  H).
  intros X1 X2;  exact (rem_329 epsilon_m__type_5_pknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_338 X1 X2 H).
   intro H. elim (rem_332  H).
   intro H. elim (rem_337  H).
   intro H. elim (rem_341  H).
  intros X1. intro H. elim (rem_331 X1 H).
   intro H. elim (rem_344  H).
  intros X1 X2. intro H. elim (rem_330 X1 X2 H).
  intros X1 X2. intro H. elim (rem_334 X1 X2 H).
   intro H. elim (rem_336  H).
   intro H. elim (rem_345  H).
   intro H. elim (rem_342  H).
Qed.

Remark rem_347 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto___type_5 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. exact (rem_346).
Defined.

Remark rem_348 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___type_5 X2 -> auto_knows_current X2). tauto. exact (rem_347 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_349 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_279 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_348 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_350 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_349 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_crypt_2;  tauto.
 clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_351 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto___def_23 X1 -> auto___def_23 X1. (* Tautology. *)
Proof. intro H. clear H. intro H. clear H. intro H. clear H. tauto. Defined.

Remark rem_352 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_23 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_23 X1 -> auto___def_23 X1). tauto. exact (rem_351 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_353 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto___def_24 X2 -> auto___def_24 X2. (* Tautology. *)
Proof. intro H. clear H. intro H. clear H. intro H. clear H. tauto. Defined.

Remark rem_354 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_24 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_24 X2 -> auto___def_24 X2). tauto. exact (rem_353 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_355 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> (auto___def_23 X1 /\ auto___def_24 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_23 X1). 2:apply (rem_352 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto___def_24 X2). 2:apply (rem_354 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_356 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_355 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_crypt_4;  tauto.
 clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_357 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto___def_10 X1 -> auto___def_10 X1. (* Tautology. *)
Proof. intro H. clear H. intro H. clear H. intro H. clear H. tauto. Defined.

Remark rem_358 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_10 X1). tauto. exact (rem_357 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_359 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto___def_11 X2 -> auto___def_11 X2. (* Tautology. *)
Proof. intro H. clear H. intro H. clear H. intro H. clear H. tauto. Defined.

Remark rem_360 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_11 X2 -> auto___def_11 X2). tauto. exact (rem_359 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_361 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> (auto___def_10 X1 /\ auto___def_11 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_10 X1). 2:apply (rem_358 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto___def_11 X2). 2:apply (rem_360 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_362 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_361 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_crypt_5;  tauto.
 clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_363 : (forall X:term, auto___def_39 X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_39_pknows_current.  tauto.
Defined.

Remark rem_364 : (forall X:term, auto___def_39 X -> auto_knows_current X)
    -> auto_knows_current t_old. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_39_pknows_current.  case (rem_363 epsilon_m__def_39_pknows_current). clear  epsilon_m__def_39_pknows_current. intros. apply trans_knows_current_t_old_1;  tauto.
 clear  epsilon_m__def_39_pknows_current. tauto.
Defined.

Remark rem_365 : auto___def_39 t_old -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_366 : (forall X:term, auto___def_39 X -> auto_knows_current X)
    -> auto___def_39 t_old -> auto_knows_current t_old. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_39_pknows_current. intro H. intros.
  elim (rem_365 H);  intros.
  apply (rem_364 epsilon_m__def_39_pknows_current);  tauto.
Defined.

Remark rem_367 : forall X1 X2:term, auto___def_39 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_368 : forall X1:term, auto___def_39 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_369 : auto___def_39 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_370 : auto___def_39 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_371 : forall X1 X2:term, auto___def_39 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_372 : forall X1 X2:term, auto___def_39 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_373 : auto___def_39 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_374 : auto___def_39 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_375 : forall X1 X2:term, auto___def_39 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_376 : forall X1 X2:term, auto___def_39 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_377 : auto___def_39 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_378 : forall X1 X2:term, auto___def_39 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_379 : auto___def_39 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_380 : auto___def_39 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_381 : auto___def_39 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_382 : auto___def_39 t_current -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_383 : forall X1:term, auto___def_39 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_m__def_39_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_380  H).
   intro H. elim (rem_377  H).
  intros X1 X2. intro H. elim (rem_372 X1 X2 H).
  intros X1 X2. intro H. elim (rem_376 X1 X2 H).
   intro H. elim (rem_370  H).
  intros X1 X2. intro H. elim (rem_378 X1 X2 H).
  intros X1 X2. intro H. elim (rem_375 X1 X2 H).
   intro H. elim (rem_369  H).
   intro H. elim (rem_374  H).
   intro H. elim (rem_379  H).
  intros X1. intro H. elim (rem_368 X1 H).
   intro H. elim (rem_381  H).
  intros X1 X2. intro H. elim (rem_367 X1 X2 H).
  intros X1 X2. intro H. elim (rem_371 X1 X2 H).
   intro H. elim (rem_373  H).
   intro H. elim (rem_382  H).
  exact (rem_366 epsilon_m__def_39_pknows_current ).
Qed.

Remark rem_384 : (forall X:term, auto___def_41 X -> auto_knows_current X)
    -> forall X1:term, auto___def_39 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__def_41_pknows_current. exact (rem_383).
Defined.

Remark rem_385 : (forall X:term, auto___def_41 X -> auto_knows_current X)
    -> forall X1:term, auto___def_39 X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_41_pknows_current. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_384 epsilon_m__def_41_pknows_current X1);  assumption.
  tauto.
Defined.

Remark rem_386 : (forall X:term, auto___def_41 X -> auto_knows_current X)
    -> forall X1:term, auto___def_39 X1 -> auto_knows_current (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_41_pknows_current. intros X1. intros A1.
  case (rem_385 epsilon_m__def_41_pknows_current X1 A1). clear  epsilon_m__def_41_pknows_current A1. intros. apply trans_knows_current_s_1;  tauto.
 clear  epsilon_m__def_41_pknows_current A1. tauto.
Defined.

Remark rem_387 : forall X1:term, auto___def_41 (s X1) -> or_1
    (auto___def_39 X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_388 : (forall X:term, auto___def_41 X -> auto_knows_current X)
    -> forall X1:term, auto___def_41 (s X1) -> auto_knows_current (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_41_pknows_current. intros X1. intro H. intros.
  elim (rem_387 X1 H);  intros.
  apply (rem_386 epsilon_m__def_41_pknows_current X1);  tauto.
Defined.

Remark rem_389 : forall X1 X2:term, auto___def_41 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_390 : auto___def_41 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_391 : auto___def_41 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_392 : forall X1 X2:term, auto___def_41 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_393 : forall X1 X2:term, auto___def_41 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_394 : auto___def_41 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_395 : auto___def_41 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_396 : forall X1 X2:term, auto___def_41 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_397 : forall X1 X2:term, auto___def_41 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_398 : auto___def_41 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_399 : forall X1 X2:term, auto___def_41 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_400 : auto___def_41 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_401 : auto___def_41 t_old -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_402 : auto___def_41 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_403 : auto___def_41 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_404 : auto___def_41 t_current -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_405 : forall X1:term, auto___def_41 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_m__def_41_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_402  H).
   intro H. elim (rem_398  H).
  intros X1 X2. intro H. elim (rem_393 X1 X2 H).
  intros X1 X2. intro H. elim (rem_397 X1 X2 H).
   intro H. elim (rem_391  H).
  intros X1 X2. intro H. elim (rem_399 X1 X2 H).
  intros X1 X2. intro H. elim (rem_396 X1 X2 H).
   intro H. elim (rem_390  H).
   intro H. elim (rem_395  H).
   intro H. elim (rem_400  H).
  intros X1;  exact (rem_388 epsilon_m__def_41_pknows_current X1).
   intro H. elim (rem_403  H).
  intros X1 X2. intro H. elim (rem_389 X1 X2 H).
  intros X1 X2. intro H. elim (rem_392 X1 X2 H).
   intro H. elim (rem_394  H).
   intro H. elim (rem_404  H).
   intro H. elim (rem_401  H).
Qed.

Remark rem_406 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto___def_41 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. exact (rem_405).
Defined.

Remark rem_407 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_41 X1 -> auto_knows_current X1). tauto. exact (rem_406 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_408 : (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> forall X1:term, auto___def_18 X1 -> auto___def_46 X1. (* Cut history. *)
Proof.  intros epsilon_m__type_7_pknows_current. exact (rem_300).
Defined.

Remark rem_409 : (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_46 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_7_pknows_current. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_46 X1). tauto. exact (rem_408 epsilon_m__type_7_pknows_current X1).
Defined.

Remark rem_410 : (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> forall X2:term, auto___def_19 X2 -> auto___def_47 X2. (* Cut history. *)
Proof.  intros epsilon_m__type_7_pknows_current. exact (rem_323).
Defined.

Remark rem_411 : (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_47 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_7_pknows_current. intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_47 X2). tauto. exact (rem_410 epsilon_m__type_7_pknows_current X2).
Defined.

Remark rem_412 : (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> (auto___def_46 X1 /\ auto___def_47 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_7_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_46 X1). 2:apply (rem_409 epsilon_m__type_7_pknows_current X1 X2);  assumption.
  cut (auto___def_47 X2). 2:apply (rem_411 epsilon_m__type_7_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_413 : (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_7_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_412 epsilon_m__type_7_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_7_pknows_current A1 A2. intros. apply trans_knows_current_key_2;  tauto.
 clear  epsilon_m__type_7_pknows_current A1 A2. tauto.
Defined.

Remark rem_414 : forall X1 X2:term, auto___type_7 (key X1 X2) -> or_1
    (auto___def_18 X1 /\ auto___def_19 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_415 : (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_7 (key X1 X2) -> auto_knows_current (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_7_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_414 X1 X2 H);  intros.
  apply (rem_413 epsilon_m__type_7_pknows_current X1 X2);  tauto.
Defined.

Remark rem_416 : forall X1 X2:term, auto___type_7 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_417 : forall X1:term, auto___type_7 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_418 : auto___type_7 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_419 : auto___type_7 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_420 : forall X1 X2:term, auto___type_7 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_421 : forall X1 X2:term, auto___type_7 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_422 : auto___type_7 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_423 : auto___type_7 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_424 : forall X1 X2:term, auto___type_7 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_425 : forall X1 X2:term, auto___type_7 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_426 : auto___type_7 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_427 : auto___type_7 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_428 : auto___type_7 t_old -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_429 : auto___type_7 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_430 : auto___type_7 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_431 : auto___type_7 t_current -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_432 : forall X2:term, auto___type_7 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__type_7_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_429  H).
   intro H. elim (rem_426  H).
  intros X1 X2. intro H. elim (rem_421 X1 X2 H).
  intros X1 X2. intro H. elim (rem_425 X1 X2 H).
   intro H. elim (rem_419  H).
  intros X1 X2;  exact (rem_415 epsilon_m__type_7_pknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_424 X1 X2 H).
   intro H. elim (rem_418  H).
   intro H. elim (rem_423  H).
   intro H. elim (rem_427  H).
  intros X1. intro H. elim (rem_417 X1 H).
   intro H. elim (rem_430  H).
  intros X1 X2. intro H. elim (rem_416 X1 X2 H).
  intros X1 X2. intro H. elim (rem_420 X1 X2 H).
   intro H. elim (rem_422  H).
   intro H. elim (rem_431  H).
   intro H. elim (rem_428  H).
Qed.

Remark rem_433 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto___type_7 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. exact (rem_432).
Defined.

Remark rem_434 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___type_7 X2 -> auto_knows_current X2). tauto. exact (rem_433 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_435 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_407 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_434 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_436 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_435 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_crypt_2;  tauto.
 clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Inductive or_5(H1 H2 H3 H4 H5:Prop) : Prop :=
    or_5_intro_1 : H1 -> (or_5 H1 H2 H3 H4 H5)
  | or_5_intro_2 : H2 -> (or_5 H1 H2 H3 H4 H5)
  | or_5_intro_3 : H3 -> (or_5 H1 H2 H3 H4 H5)
  | or_5_intro_4 : H4 -> (or_5 H1 H2 H3 H4 H5)
  | or_5_intro_5 : H5 -> (or_5 H1 H2 H3 H4 H5)
.

Remark rem_437 : forall X1 X2:term, auto___type_6 (crypt X1 X2) -> or_5
    (auto_knows_old X1 /\ auto_knows_old X2)
    (auto___def_37 X1 /\ auto___type_5 X2)
    (auto___def_23 X1 /\ auto___def_24 X2)
    (auto___def_10 X1 /\ auto___def_11 X2)
    (auto___def_41 X1 /\ auto___type_7 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_5_intro_1; tauto.
  intros. apply or_5_intro_2; tauto.
  intros. apply or_5_intro_3; tauto.
  intros. apply or_5_intro_4; tauto.
  intros. apply or_5_intro_5; tauto.
Qed.

Remark rem_438 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_6 (crypt X1 X2) -> auto_knows_current (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_437 X1 X2 H);  intros.
  apply (rem_277 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2);  tauto.
  apply (rem_350 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2);  tauto.
  apply (rem_356 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2);  tauto.
  apply (rem_362 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2);  tauto.
  apply (rem_436 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2);  tauto.
Defined.

Remark rem_439 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_current bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current.  case (rem_263 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current). clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros. apply trans_knows_current_bob_1;  tauto.
 clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. tauto.
Defined.

Remark rem_440 : auto___type_6 bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_441 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto___type_6 bob -> auto_knows_current bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intro H. intros.
  elim (rem_440 H);  intros.
  apply (rem_439 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current);  tauto.
Defined.

Remark rem_442 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto___def_42 X1 -> auto___def_42 X1. (* Tautology. *)
Proof. intro H. clear H. intro H. clear H. intro H. clear H. tauto. Defined.

Remark rem_443 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___def_42 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_42 X1 -> auto___def_42 X1). tauto. exact (rem_442 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_444 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. intro H. clear H. intro H. clear H. tauto. Defined.

Remark rem_445 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_444 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_446 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> (auto___def_42 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_42 X1). 2:apply (rem_443 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_445 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_447 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_446 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_key_1;  tauto.
 clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_448 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto___def_43 X1 -> auto___def_43 X1. (* Tautology. *)
Proof. intro H. clear H. intro H. clear H. intro H. clear H. tauto. Defined.

Remark rem_449 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_43 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_43 X1). tauto. exact (rem_448 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_450 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto___def_44 X2 -> auto___def_44 X2. (* Tautology. *)
Proof. intro H. clear H. intro H. clear H. intro H. clear H. tauto. Defined.

Remark rem_451 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_44 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_44 X2 -> auto___def_44 X2). tauto. exact (rem_450 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_452 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> (auto___def_43 X1 /\ auto___def_44 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_43 X1). 2:apply (rem_449 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto___def_44 X2). 2:apply (rem_451 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_453 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_452 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_key_3;  tauto.
 clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Inductive or_2(H1 H2:Prop) : Prop :=
    or_2_intro_1 : H1 -> (or_2 H1 H2)
  | or_2_intro_2 : H2 -> (or_2 H1 H2)
.

Remark rem_454 : forall X1 X2:term, auto___type_6 (key X1 X2) -> or_2
    (auto___def_42 X1 /\ auto___type_8 X2)
    (auto___def_43 X1 /\ auto___def_44 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_455 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_6 (key X1 X2) -> auto_knows_current (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_454 X1 X2 H);  intros.
  apply (rem_447 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2);  tauto.
  apply (rem_453 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2);  tauto.
Defined.

Remark rem_456 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_current t_old. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current.  case (rem_263 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current). clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros. apply trans_knows_current_t_old_1;  tauto.
 clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. tauto.
Defined.

Remark rem_457 : auto___type_6 t_old -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_458 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto___type_6 t_old -> auto_knows_current t_old. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intro H. intros.
  elim (rem_457 H);  intros.
  apply (rem_456 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current);  tauto.
Defined.

Remark rem_459 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_current alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current.  case (rem_263 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current). clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros. apply trans_knows_current_alice_1;  tauto.
 clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. tauto.
Defined.

Remark rem_460 : auto___type_6 alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_461 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto___type_6 alice -> auto_knows_current alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intro H. intros.
  elim (rem_460 H);  intros.
  apply (rem_459 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current);  tauto.
Defined.

Remark rem_462 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_current server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current.  case (rem_263 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current). clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intros. apply trans_knows_current_server_1;  tauto.
 clear  epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. tauto.
Defined.

Remark rem_463 : auto___type_6 server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_464 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto___type_6 server -> auto_knows_current server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current. intro H. intros.
  elim (rem_463 H);  intros.
  apply (rem_462 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current);  tauto.
Defined.

Remark rem_465 : forall X1 X2:term, auto___type_6 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_466 : forall X1 X2:term, auto___type_6 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_467 : auto___type_6 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_468 : auto___type_6 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_469 : forall X1 X2:term, auto___type_6 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_470 : auto___type_6 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_471 : auto___type_6 t_current -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_472 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto___type_6 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_mknows_old_pknows_current. fix epsilon_m__type_6_pknows_current 1.
  intro X. case X.
  exact (rem_461 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current ).
  exact (rem_441 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current ).
  intros X1 X2;  exact (rem_276 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2).
  intros X1 X2;  exact (rem_438 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2).
  exact (rem_269 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current ).
  intros X1 X2;  exact (rem_455 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_469 X1 X2 H).
  exact (rem_266 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current ).
   intro H. elim (rem_468  H).
   intro H. elim (rem_470  H).
  intros X1;  exact (rem_262 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current X1).
  exact (rem_464 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current ).
  intros X1 X2. intro H. elim (rem_465 X1 X2 H).
  intros X1 X2. intro H. elim (rem_466 X1 X2 H).
   intro H. elim (rem_467  H).
   intro H. elim (rem_471  H).
  exact (rem_458 epsilon_m__def_37_pknows_current epsilon_m__type_6_pknows_current epsilon_mknows_old_pknows_current ).
Defined.

Remark rem_473 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_6 X1 -> auto___def_38 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___type_6 X1 -> auto_knows_current X1). tauto. exact (rem_472 epsilon_m__def_37_pknows_current epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_474 : (forall X:term, auto___def_38 X -> auto_knows_current X)
    -> forall X1:term, auto___def_39 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__def_38_pknows_current. exact (rem_383).
Defined.

Remark rem_475 : (forall X:term, auto___def_38 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_39 X1 -> auto___def_31 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_38_pknows_current. intros X1 X2.
  cut (auto___def_39 X1 -> auto_knows_current X1). tauto. exact (rem_474 epsilon_m__def_38_pknows_current X1).
Defined.

Remark rem_476 : (forall X:term, auto___def_31 X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_31_pknows_current.  tauto.
Defined.

Remark rem_477 : (forall X:term, auto___def_31 X -> auto_knows_current X)
    -> auto_knows_current nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_31_pknows_current.  case (rem_476 epsilon_m__def_31_pknows_current). clear  epsilon_m__def_31_pknows_current. intros. apply trans_knows_current_nil_1;  tauto.
 clear  epsilon_m__def_31_pknows_current. tauto.
Defined.

Remark rem_478 : auto___def_31 nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_479 : (forall X:term, auto___def_31 X -> auto_knows_current X)
    -> auto___def_31 nil -> auto_knows_current nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_31_pknows_current. intro H. intros.
  elim (rem_478 H);  intros.
  apply (rem_477 epsilon_m__def_31_pknows_current);  tauto.
Defined.

Remark rem_480 : forall X1 X2:term, auto___def_31 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_481 : forall X1:term, auto___def_31 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_482 : auto___def_31 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_483 : forall X1 X2:term, auto___def_31 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_484 : auto___def_31 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_485 : auto___def_31 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_486 : forall X1 X2:term, auto___def_31 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_487 : forall X1 X2:term, auto___def_31 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_488 : auto___def_31 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_489 : forall X1 X2:term, auto___def_31 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_490 : auto___def_31 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_491 : auto___def_31 t_old -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_492 : auto___def_31 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_493 : auto___def_31 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_494 : auto___def_31 t_current -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_495 : forall X2:term, auto___def_31 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__def_31_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_492  H).
   intro H. elim (rem_488  H).
  intros X1 X2. intro H. elim (rem_39 X1 X2 H).
  intros X1 X2. intro H. elim (rem_487 X1 X2 H).
   intro H. elim (rem_482  H).
  intros X1 X2. intro H. elim (rem_489 X1 X2 H).
  intros X1 X2. intro H. elim (rem_486 X1 X2 H).
  exact (rem_479 epsilon_m__def_31_pknows_current ).
   intro H. elim (rem_485  H).
   intro H. elim (rem_490  H).
  intros X1. intro H. elim (rem_481 X1 H).
   intro H. elim (rem_493  H).
  intros X1 X2. intro H. elim (rem_480 X1 X2 H).
  intros X1 X2. intro H. elim (rem_483 X1 X2 H).
   intro H. elim (rem_484  H).
   intro H. elim (rem_494  H).
   intro H. elim (rem_491  H).
Qed.

Remark rem_496 : (forall X:term, auto___def_38 X -> auto_knows_current X)
    -> forall X2:term, auto___def_31 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_m__def_38_pknows_current. exact (rem_495).
Defined.

Remark rem_497 : (forall X:term, auto___def_38 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_39 X1 -> auto___def_31 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_38_pknows_current. intros X1 X2.
  cut (auto___def_31 X2 -> auto_knows_current X2). tauto. exact (rem_496 epsilon_m__def_38_pknows_current X2).
Defined.

Remark rem_498 : (forall X:term, auto___def_38 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_39 X1 -> auto___def_31 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_38_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_475 epsilon_m__def_38_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_497 epsilon_m__def_38_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_499 : (forall X:term, auto___def_38 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_39 X1 -> auto___def_31 X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_38_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_498 epsilon_m__def_38_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_38_pknows_current A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  epsilon_m__def_38_pknows_current A1 A2. tauto.
Defined.

Remark rem_500 : forall X1 X2:term, auto___def_38 (cons X1 X2) -> or_1
    (auto___def_39 X1 /\ auto___def_31 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_501 : (forall X:term, auto___def_38 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_38 (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_38_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_500 X1 X2 H);  intros.
  apply (rem_499 epsilon_m__def_38_pknows_current X1 X2);  tauto.
Defined.

Remark rem_502 : forall X1 X2:term, auto___def_38 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_503 : forall X1:term, auto___def_38 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_504 : auto___def_38 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_505 : auto___def_38 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_506 : forall X1 X2:term, auto___def_38 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_507 : auto___def_38 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_508 : auto___def_38 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_509 : forall X1 X2:term, auto___def_38 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_510 : forall X1 X2:term, auto___def_38 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_511 : auto___def_38 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_512 : forall X1 X2:term, auto___def_38 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_513 : auto___def_38 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_514 : auto___def_38 t_old -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_515 : auto___def_38 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_516 : auto___def_38 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_517 : auto___def_38 t_current -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_518 : forall X2:term, auto___def_38 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__def_38_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_515  H).
   intro H. elim (rem_511  H).
  intros X1 X2;  exact (rem_501 epsilon_m__def_38_pknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_510 X1 X2 H).
   intro H. elim (rem_505  H).
  intros X1 X2. intro H. elim (rem_512 X1 X2 H).
  intros X1 X2. intro H. elim (rem_509 X1 X2 H).
   intro H. elim (rem_504  H).
   intro H. elim (rem_508  H).
   intro H. elim (rem_513  H).
  intros X1. intro H. elim (rem_503 X1 H).
   intro H. elim (rem_516  H).
  intros X1 X2. intro H. elim (rem_502 X1 X2 H).
  intros X1 X2. intro H. elim (rem_506 X1 X2 H).
   intro H. elim (rem_507  H).
   intro H. elim (rem_517  H).
   intro H. elim (rem_514  H).
Qed.

Remark rem_519 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto___def_38 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_m__def_37_pknows_current epsilon_mknows_old_pknows_current. exact (rem_518).
Defined.

Remark rem_520 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_6 X1 -> auto___def_38 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_38 X2 -> auto_knows_current X2). tauto. exact (rem_519 epsilon_m__def_37_pknows_current epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_521 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_6 X1 -> auto___def_38 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_473 epsilon_m__def_37_pknows_current epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_520 epsilon_m__def_37_pknows_current epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_522 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_6 X1 -> auto___def_38 X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_521 epsilon_m__def_37_pknows_current epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_37_pknows_current epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  epsilon_m__def_37_pknows_current epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_523 : forall X1 X2:term, auto___def_37 (cons X1 X2) -> or_1
    (auto___type_6 X1 /\ auto___def_38 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_524 : (forall X:term, auto___def_37 X -> auto_knows_current X)
    -> (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_37 (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_37_pknows_current epsilon_mknows_old_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_523 X1 X2 H);  intros.
  apply (rem_522 epsilon_m__def_37_pknows_current epsilon_mknows_old_pknows_current X1 X2);  tauto.
Defined.

Remark rem_525 : forall X1 X2:term, auto___def_37 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_526 : forall X1:term, auto___def_37 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_527 : auto___def_37 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_528 : auto___def_37 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_529 : forall X1 X2:term, auto___def_37 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_530 : auto___def_37 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_531 : auto___def_37 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_532 : forall X1 X2:term, auto___def_37 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_533 : forall X1 X2:term, auto___def_37 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_534 : auto___def_37 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_535 : forall X1 X2:term, auto___def_37 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_536 : auto___def_37 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_537 : auto___def_37 t_old -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_538 : auto___def_37 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_539 : auto___def_37 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_540 : auto___def_37 t_current -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_541 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto___def_37 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  intros epsilon_mknows_old_pknows_current. fix epsilon_m__def_37_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_538  H).
   intro H. elim (rem_534  H).
  intros X1 X2;  exact (rem_524 epsilon_m__def_37_pknows_current epsilon_mknows_old_pknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_533 X1 X2 H).
   intro H. elim (rem_528  H).
  intros X1 X2. intro H. elim (rem_535 X1 X2 H).
  intros X1 X2. intro H. elim (rem_532 X1 X2 H).
   intro H. elim (rem_527  H).
   intro H. elim (rem_531  H).
   intro H. elim (rem_536  H).
  intros X1. intro H. elim (rem_526 X1 H).
   intro H. elim (rem_539  H).
  intros X1 X2. intro H. elim (rem_525 X1 X2 H).
  intros X1 X2. intro H. elim (rem_529 X1 X2 H).
   intro H. elim (rem_530  H).
   intro H. elim (rem_540  H).
   intro H. elim (rem_537  H).
Defined.

Remark rem_542 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_37 X1 -> auto_knows_current X1). tauto. exact (rem_541 epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_543 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto___type_5 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_mknows_old_pknows_current. exact (rem_346).
Defined.

Remark rem_544 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___type_5 X2 -> auto_knows_current X2). tauto. exact (rem_543 epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_545 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_542 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_544 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_546 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_545 epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_crypt_2;  tauto.
 clear  epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_547 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto___def_23 X1 -> auto___def_23 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_548 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_23 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_23 X1 -> auto___def_23 X1). tauto. exact (rem_547 epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_549 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto___def_24 X2 -> auto___def_24 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_550 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_24 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_24 X2 -> auto___def_24 X2). tauto. exact (rem_549 epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_551 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> (auto___def_23 X1 /\ auto___def_24 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_23 X1). 2:apply (rem_548 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto___def_24 X2). 2:apply (rem_550 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_552 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_551 epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_crypt_4;  tauto.
 clear  epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_553 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto___def_10 X1 -> auto___def_10 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_554 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_10 X1). tauto. exact (rem_553 epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_555 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto___def_11 X2 -> auto___def_11 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_556 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_11 X2 -> auto___def_11 X2). tauto. exact (rem_555 epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_557 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> (auto___def_10 X1 /\ auto___def_11 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_10 X1). 2:apply (rem_554 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto___def_11 X2). 2:apply (rem_556 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_558 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_557 epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_crypt_5;  tauto.
 clear  epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_559 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto___def_41 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_mknows_old_pknows_current. exact (rem_405).
Defined.

Remark rem_560 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_41 X1 -> auto_knows_current X1). tauto. exact (rem_559 epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_561 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto___type_7 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_mknows_old_pknows_current. exact (rem_432).
Defined.

Remark rem_562 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___type_7 X2 -> auto_knows_current X2). tauto. exact (rem_561 epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_563 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_560 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_562 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_564 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_563 epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_crypt_2;  tauto.
 clear  epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_565 : forall X1 X2:term, auto_knows_old (crypt X1 X2) -> or_5
    (auto_knows_old X1 /\ auto_knows_old X2)
    (auto___def_37 X1 /\ auto___type_5 X2)
    (auto___def_23 X1 /\ auto___def_24 X2)
    (auto___def_10 X1 /\ auto___def_11 X2)
    (auto___def_41 X1 /\ auto___type_7 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_5_intro_1; tauto.
  intros. apply or_5_intro_2; tauto.
  intros. apply or_5_intro_3; tauto.
  intros. apply or_5_intro_4; tauto.
  intros. apply or_5_intro_5; tauto.
Qed.

Remark rem_566 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old (crypt X1 X2) -> auto_knows_current (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_565 X1 X2 H);  intros.
  apply (rem_257 epsilon_mknows_old_pknows_current X1 X2);  tauto.
  apply (rem_546 epsilon_mknows_old_pknows_current X1 X2);  tauto.
  apply (rem_552 epsilon_mknows_old_pknows_current X1 X2);  tauto.
  apply (rem_558 epsilon_mknows_old_pknows_current X1 X2);  tauto.
  apply (rem_564 epsilon_mknows_old_pknows_current X1 X2);  tauto.
Defined.

Remark rem_567 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_current bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current.  case (rem_243 epsilon_mknows_old_pknows_current). clear  epsilon_mknows_old_pknows_current. intros. apply trans_knows_current_bob_1;  tauto.
 clear  epsilon_mknows_old_pknows_current. tauto.
Defined.

Remark rem_568 : auto_knows_old bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_569 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_old bob -> auto_knows_current bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intro H. intros.
  elim (rem_568 H);  intros.
  apply (rem_567 epsilon_mknows_old_pknows_current);  tauto.
Defined.

Remark rem_570 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto___def_42 X1 -> auto___def_42 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_571 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___def_42 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_42 X1 -> auto___def_42 X1). tauto. exact (rem_570 epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_572 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_573 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_572 epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_574 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> (auto___def_42 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_42 X1). 2:apply (rem_571 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_573 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_575 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_574 epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_key_1;  tauto.
 clear  epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_576 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto___def_43 X1 -> auto___def_43 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_577 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_43 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_43 X1). tauto. exact (rem_576 epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_578 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto___def_44 X2 -> auto___def_44 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_579 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_44 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_44 X2 -> auto___def_44 X2). tauto. exact (rem_578 epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_580 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> (auto___def_43 X1 /\ auto___def_44 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_43 X1). 2:apply (rem_577 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto___def_44 X2). 2:apply (rem_579 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_581 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_580 epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_key_3;  tauto.
 clear  epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_582 : forall X1 X2:term, auto_knows_old (key X1 X2) -> or_2
    (auto___def_42 X1 /\ auto___type_8 X2)
    (auto___def_43 X1 /\ auto___def_44 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_583 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old (key X1 X2) -> auto_knows_current (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_582 X1 X2 H);  intros.
  apply (rem_575 epsilon_mknows_old_pknows_current X1 X2);  tauto.
  apply (rem_581 epsilon_mknows_old_pknows_current X1 X2);  tauto.
Defined.

Remark rem_584 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_current t_old. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current.  case (rem_243 epsilon_mknows_old_pknows_current). clear  epsilon_mknows_old_pknows_current. intros. apply trans_knows_current_t_old_1;  tauto.
 clear  epsilon_mknows_old_pknows_current. tauto.
Defined.

Remark rem_585 : auto_knows_old t_old -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_586 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_old t_old -> auto_knows_current t_old. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intro H. intros.
  elim (rem_585 H);  intros.
  apply (rem_584 epsilon_mknows_old_pknows_current);  tauto.
Defined.

Remark rem_587 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_current alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current.  case (rem_243 epsilon_mknows_old_pknows_current). clear  epsilon_mknows_old_pknows_current. intros. apply trans_knows_current_alice_1;  tauto.
 clear  epsilon_mknows_old_pknows_current. tauto.
Defined.

Remark rem_588 : auto_knows_old alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_589 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_old alice -> auto_knows_current alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intro H. intros.
  elim (rem_588 H);  intros.
  apply (rem_587 epsilon_mknows_old_pknows_current);  tauto.
Defined.

Remark rem_590 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_current server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current.  case (rem_243 epsilon_mknows_old_pknows_current). clear  epsilon_mknows_old_pknows_current. intros. apply trans_knows_current_server_1;  tauto.
 clear  epsilon_mknows_old_pknows_current. tauto.
Defined.

Remark rem_591 : auto_knows_old server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_592 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_old server -> auto_knows_current server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intro H. intros.
  elim (rem_591 H);  intros.
  apply (rem_590 epsilon_mknows_old_pknows_current);  tauto.
Defined.

Remark rem_593 : forall X1 X2:term, auto_knows_old (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_594 : forall X1 X2:term, auto_knows_old (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_595 : auto_knows_old sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_596 : auto_knows_old prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_597 : forall X1 X2:term, auto_knows_old (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_598 : auto_knows_old pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_599 : auto_knows_old t_current -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_600 : forall X2:term, auto_knows_old X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_mknows_old_pknows_current 1.
  intro X. case X.
  exact (rem_589 epsilon_mknows_old_pknows_current ).
  exact (rem_569 epsilon_mknows_old_pknows_current ).
  intros X1 X2;  exact (rem_256 epsilon_mknows_old_pknows_current X1 X2).
  intros X1 X2;  exact (rem_566 epsilon_mknows_old_pknows_current X1 X2).
  exact (rem_249 epsilon_mknows_old_pknows_current ).
  intros X1 X2;  exact (rem_583 epsilon_mknows_old_pknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_597 X1 X2 H).
  exact (rem_246 epsilon_mknows_old_pknows_current ).
   intro H. elim (rem_596  H).
   intro H. elim (rem_598  H).
  intros X1;  exact (rem_242 epsilon_mknows_old_pknows_current X1).
  exact (rem_592 epsilon_mknows_old_pknows_current ).
  intros X1 X2. intro H. elim (rem_593 X1 X2 H).
  intros X1 X2. intro H. elim (rem_594 X1 X2 H).
   intro H. elim (rem_595  H).
   intro H. elim (rem_599  H).
  exact (rem_586 epsilon_mknows_old_pknows_current ).
Qed.

Remark rem_601 : forall X1 X2 X3 X4:term, auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old X2 -> auto_knows_current X2). tauto. exact (rem_600 X2).
Qed.

Remark rem_602 : forall X3:term, auto_knows_old X3 -> auto_knows_current X3. (* Induct. *)
Proof.
  fix epsilon_mknows_old_pknows_current 1.
  intro X. case X.
  exact (rem_589 epsilon_mknows_old_pknows_current ).
  exact (rem_569 epsilon_mknows_old_pknows_current ).
  intros X1 X2;  exact (rem_256 epsilon_mknows_old_pknows_current X1 X2).
  intros X1 X2;  exact (rem_566 epsilon_mknows_old_pknows_current X1 X2).
  exact (rem_249 epsilon_mknows_old_pknows_current ).
  intros X1 X2;  exact (rem_583 epsilon_mknows_old_pknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_597 X1 X2 H).
  exact (rem_246 epsilon_mknows_old_pknows_current ).
   intro H. elim (rem_596  H).
   intro H. elim (rem_598  H).
  intros X1;  exact (rem_242 epsilon_mknows_old_pknows_current X1).
  exact (rem_592 epsilon_mknows_old_pknows_current ).
  intros X1 X2. intro H. elim (rem_593 X1 X2 H).
  intros X1 X2. intro H. elim (rem_594 X1 X2 H).
   intro H. elim (rem_595  H).
   intro H. elim (rem_599  H).
  exact (rem_586 epsilon_mknows_old_pknows_current ).
Qed.

Remark rem_603 : forall X1 X2 X3 X4:term, auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_current X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old X3 -> auto_knows_current X3). tauto. exact (rem_602 X3).
Qed.

Remark rem_604 : (forall X:term, auto___type_12 X -> auto___def_61 X)
    -> forall X1:term, auto___def_63 X1 -> auto___def_63 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_605 : (forall X:term, auto___type_12 X -> auto___def_61 X)
    -> forall X1 X2:term, auto___def_63 X1 -> auto___def_64 X2 -> auto___def_63 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_12_p__def_61. intros X1 X2.
  cut (auto___def_63 X1 -> auto___def_63 X1). tauto. exact (rem_604 epsilon_m__type_12_p__def_61 X1).
Defined.

Remark rem_606 : (forall X:term, auto___type_12 X -> auto___def_61 X)
    -> forall X2:term, auto___def_64 X2 -> auto___def_64 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_607 : (forall X:term, auto___type_12 X -> auto___def_61 X)
    -> forall X1 X2:term, auto___def_63 X1 -> auto___def_64 X2 -> auto___def_64 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_12_p__def_61. intros X1 X2.
  cut (auto___def_64 X2 -> auto___def_64 X2). tauto. exact (rem_606 epsilon_m__type_12_p__def_61 X2).
Defined.

Remark rem_608 : (forall X:term, auto___type_12 X -> auto___def_61 X)
    -> forall X1 X2:term, auto___def_63 X1 -> auto___def_64 X2 -> (auto___def_63 X1 /\ auto___def_64 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_12_p__def_61. intros X1 X2. intros A1 A2.
  cut (auto___def_63 X1). 2:apply (rem_605 epsilon_m__type_12_p__def_61 X1 X2);  assumption.
  cut (auto___def_64 X2). 2:apply (rem_607 epsilon_m__type_12_p__def_61 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_609 : (forall X:term, auto___type_12 X -> auto___def_61 X)
    -> forall X1 X2:term, auto___def_63 X1 -> auto___def_64 X2 -> auto___def_61 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_12_p__def_61. intros X1 X2. intros A1 A2.
  case (rem_608 epsilon_m__type_12_p__def_61 X1 X2 A1 A2). clear  epsilon_m__type_12_p__def_61 A1 A2. intros. apply trans___def_61_key_1;  tauto.
 clear  epsilon_m__type_12_p__def_61 A1 A2. tauto.
Defined.

Remark rem_610 : (forall X:term, auto___type_12 X -> auto___def_61 X)
    -> forall X1 X2:term, auto___type_12 (key X1 X2) -> auto___def_61 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_12_p__def_61. intros X1 X2. intro H. intros.
  elim (rem_103 X1 X2 H);  intros.
  apply (rem_609 epsilon_m__type_12_p__def_61 X1 X2);  tauto.
Defined.

Remark rem_611 : forall X4:term, auto___type_12 X4 -> auto___def_61 X4. (* Induct. *)
Proof.
  fix epsilon_m__type_12_p__def_61 1.
  intro X. case X.
   intro H. elim (rem_118  H).
   intro H. elim (rem_115  H).
  intros X1 X2. intro H. elim (rem_110 X1 X2 H).
  intros X1 X2. intro H. elim (rem_114 X1 X2 H).
   intro H. elim (rem_108  H).
  intros X1 X2;  exact (rem_610 epsilon_m__type_12_p__def_61 X1 X2).
  intros X1 X2. intro H. elim (rem_113 X1 X2 H).
   intro H. elim (rem_107  H).
   intro H. elim (rem_112  H).
   intro H. elim (rem_116  H).
  intros X1. intro H. elim (rem_106 X1 H).
   intro H. elim (rem_119  H).
  intros X1 X2. intro H. elim (rem_105 X1 X2 H).
  intros X1 X2. intro H. elim (rem_109 X1 X2 H).
   intro H. elim (rem_111  H).
   intro H. elim (rem_120  H).
   intro H. elim (rem_117  H).
Qed.

Remark rem_612 : forall X1 X2 X3 X4:term, auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_61 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_12 X4 -> auto___def_61 X4). tauto. exact (rem_611 X4).
Qed.

Remark rem_613 : forall X4:term, auto___type_12 X4 -> auto___type_12 X4. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_614 : forall X1 X2 X3 X4:term, auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___type_12 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_12 X4 -> auto___type_12 X4). tauto. exact (rem_613 X4).
Qed.

Remark rem_615 : forall X1 X2 X3 X4:term, auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> (auto___type_13 X1 /\ auto___type_10 X1 /\ auto_knows_current X2 /\ auto_knows_current X3 /\ auto___def_61 X4 /\ auto___type_12 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  cut (auto___type_13 X1). 2:apply (rem_136 X1 X2 X3 X4);  assumption.
  cut (auto___type_10 X1). 2:apply (rem_237 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_601 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X3). 2:apply (rem_603 X1 X2 X3 X4);  assumption.
  cut (auto___def_61 X4). 2:apply (rem_612 X1 X2 X3 X4);  assumption.
  cut (auto___type_12 X4). 2:apply (rem_614 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_616 : forall X1 X2 X3 X4:term, auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  case (rem_615 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6). clear  A1 A2 A3 A4 A5 A6. intros. apply trans___def_83_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6. tauto.
Qed.

Remark rem_617 : forall X1 X2 X3 X4:term, auto_knows_old X2 -> auto_knows_old X3 -> auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_616 X1 X2 X3 X4).
Qed.

Remark rem_618 : forall X1 X2:term, auto___def_14 (l X1 X2) -> or_1
    (auto_knows_old X1 /\ auto_knows_old X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_619 : forall X1 X2 X3 X4:term, auto___def_14 (l X2 X3) -> auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_618 X2 X3 H);  intros.
  apply (rem_617 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_620 : forall X1 X2:term, auto___def_25 (cons X1 X2) -> or_1
    (auto___def_14 X1 /\ auto___def_26 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_621 : forall X1 X2 X3 X4:term, auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_28 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_620 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_619 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_622 : forall X1 X2 X3 X4:term, auto___def_18 sym -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_28 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_28 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_621 X1 X2 X3 X4).
Qed.

Remark rem_623 : forall X1 X2 X3 X4:term, auto___def_18 sym -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_18 sym -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_28 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_622 X1 X2 X3 X4).
Qed.

Remark rem_624 : forall X1 X2:term, auto___def_24 (key X1 X2) -> or_1
    (auto___def_18 X1 /\ auto___def_28 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_625 : forall X1 X2 X3 X4:term, auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_624 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_623 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_626 : forall X1 X2 X3 X4:term, auto___def_12 t_current -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_625 X1 X2 X3 X4).
Qed.

Remark rem_627 : forall X1 X2 X3 X4:term, auto___def_12 t_current -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 t_current -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_626 X1 X2 X3 X4).
Qed.

Remark rem_628 : forall X1 X2:term, auto___def_23 (cons X1 X2) -> or_1
    (auto___def_12 X1 /\ auto___def_25 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_629 : forall X1 X2 X3 X4:term, auto___def_23 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_628 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_627 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_630 : forall X1 X2 X3 X4:term, auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___type_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_13 X1 -> auto___type_13 X1). tauto. exact (rem_135 X1).
Qed.

Remark rem_631 : forall X1 X2 X3 X4:term, auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___type_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_13 X1 -> auto___type_10 X1). tauto. exact (rem_236 X1).
Qed.

Remark rem_632 : forall X1 X2 X3 X4:term, auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old X2 -> auto_knows_current X2). tauto. exact (rem_600 X2).
Qed.

Remark rem_633 : forall X1 X2 X3 X4:term, auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_current X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old X3 -> auto_knows_current X3). tauto. exact (rem_602 X3).
Qed.

Remark rem_634 : forall X1 X2 X3 X4:term, auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_61 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_12 X4 -> auto___def_61 X4). tauto. exact (rem_611 X4).
Qed.

Remark rem_635 : forall X1 X2 X3 X4:term, auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___type_12 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_12 X4 -> auto___type_12 X4). tauto. exact (rem_613 X4).
Qed.

Remark rem_636 : forall X1 X2 X3 X4:term, auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> (auto___type_13 X1 /\ auto___type_10 X1 /\ auto_knows_current X2 /\ auto_knows_current X3 /\ auto___def_61 X4 /\ auto___type_12 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  cut (auto___type_13 X1). 2:apply (rem_630 X1 X2 X3 X4);  assumption.
  cut (auto___type_10 X1). 2:apply (rem_631 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_632 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X3). 2:apply (rem_633 X1 X2 X3 X4);  assumption.
  cut (auto___def_61 X4). 2:apply (rem_634 X1 X2 X3 X4);  assumption.
  cut (auto___type_12 X4). 2:apply (rem_635 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_637 : forall X1 X2 X3 X4:term, auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  case (rem_636 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6). clear  A1 A2 A3 A4 A5 A6. intros. apply trans___def_83_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6. tauto.
Qed.

Remark rem_638 : forall X1 X2 X3 X4:term, auto_knows_old X2 -> auto_knows_old X3 -> auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_637 X1 X2 X3 X4).
Qed.

Remark rem_639 : forall X1 X2 X3 X4:term, auto___def_14 (l X2 X3) -> auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_618 X2 X3 H);  intros.
  apply (rem_638 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_640 : forall X1 X2:term, auto___def_13 (cons X1 X2) -> or_1
    (auto___def_14 X1 /\ auto___def_15 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_641 : forall X1 X2 X3 X4:term, auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_32 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_640 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_639 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_642 : forall X1 X2 X3 X4:term, auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_18 sym -> auto___def_32 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_32 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_641 X1 X2 X3 X4).
Qed.

Remark rem_643 : forall X1 X2 X3 X4:term, auto___def_18 sym -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_18 sym -> auto___def_32 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_642 X1 X2 X3 X4).
Qed.

Remark rem_644 : forall X1 X2:term, auto___def_11 (key X1 X2) -> or_1
    (auto___def_18 X1 /\ auto___def_32 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_645 : forall X1 X2 X3 X4:term, auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_644 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_643 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_646 : forall X1 X2 X3 X4:term, auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_12 t_current -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_645 X1 X2 X3 X4).
Qed.

Remark rem_647 : forall X1 X2 X3 X4:term, auto___def_12 t_current -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_12 t_current -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_646 X1 X2 X3 X4).
Qed.

Remark rem_648 : forall X1 X2:term, auto___def_10 (cons X1 X2) -> or_1
    (auto___def_12 X1 /\ auto___def_13 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_649 : forall X1 X2 X3 X4:term, auto___def_10 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_648 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_647 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_650 : forall X1 X2 X3 X4:term, auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_13 X1 -> auto___type_13 X1). tauto. exact (rem_135 X1).
Qed.

Remark rem_651 : forall X1 X2 X3 X4:term, auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_13 X1 -> auto___type_10 X1). tauto. exact (rem_236 X1).
Qed.

Remark rem_652 : forall X2:term, auto_knows_current X2 -> auto_knows_current X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_653 : forall X1 X2 X3 X4:term, auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_652 X2).
Qed.

Remark rem_654 : forall X3:term, auto_knows_current X3 -> auto_knows_current X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_655 : forall X1 X2 X3 X4:term, auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X3 -> auto_knows_current X3). tauto. exact (rem_654 X3).
Qed.

Remark rem_656 : forall X1 X2 X3 X4:term, auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_61 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_12 X4 -> auto___def_61 X4). tauto. exact (rem_611 X4).
Qed.

Remark rem_657 : forall X1 X2 X3 X4:term, auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_12 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_12 X4 -> auto___type_12 X4). tauto. exact (rem_613 X4).
Qed.

Remark rem_658 : forall X1 X2 X3 X4:term, auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current X2 -> auto_knows_current X3 -> (auto___type_13 X1 /\ auto___type_10 X1 /\ auto_knows_current X2 /\ auto_knows_current X3 /\ auto___def_61 X4 /\ auto___type_12 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  cut (auto___type_13 X1). 2:apply (rem_650 X1 X2 X3 X4);  assumption.
  cut (auto___type_10 X1). 2:apply (rem_651 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_653 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X3). 2:apply (rem_655 X1 X2 X3 X4);  assumption.
  cut (auto___def_61 X4). 2:apply (rem_656 X1 X2 X3 X4);  assumption.
  cut (auto___type_12 X4). 2:apply (rem_657 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_659 : forall X1 X2 X3 X4:term, auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  case (rem_658 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6). clear  A1 A2 A3 A4 A5 A6. intros. apply trans___def_83_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6. tauto.
Qed.

Remark rem_660 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current X3 -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_659 X1 X2 X3 X4).
Qed.

Remark rem_661 : forall X1 X2:term, auto___def_59 (l X1 X2) -> or_1
    (auto_knows_current X1 /\ auto_knows_current X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_662 : forall X1 X2 X3 X4:term, auto___def_59 (l X2 X3) -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_661 X2 X3 H);  intros.
  apply (rem_660 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_663 : forall X1 X2:term, auto___def_58 (cons X1 X2) -> or_1
    (auto___def_59 X1 /\ auto___def_60 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_664 : forall X1 X2 X3 X4:term, auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_75 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_663 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_662 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_665 : forall X1 X2 X3 X4:term, auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_63 sym -> auto___def_75 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_75 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_664 X1 X2 X3 X4).
Qed.

Remark rem_666 : forall X1 X2 X3 X4:term, auto___def_63 sym -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_63 sym -> auto___def_75 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_665 X1 X2 X3 X4).
Qed.

Remark rem_667 : forall X1 X2:term, auto___def_56 (key X1 X2) -> or_1
    (auto___def_63 X1 /\ auto___def_75 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_668 : forall X1 X2 X3 X4:term, auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_667 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_666 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_669 : forall X1 X2 X3 X4:term, auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_57 t_current -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_668 X1 X2 X3 X4).
Qed.

Remark rem_670 : forall X1 X2 X3 X4:term, auto___def_57 t_current -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_57 t_current -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_669 X1 X2 X3 X4).
Qed.

Remark rem_671 : forall X1 X2:term, auto___def_55 (cons X1 X2) -> or_1
    (auto___def_57 X1 /\ auto___def_58 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_672 : forall X1 X2 X3 X4:term, auto___def_55 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_671 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_670 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_673 : forall X1 X2 X3 X4:term, auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_13 X1 -> auto___type_13 X1). tauto. exact (rem_135 X1).
Qed.

Remark rem_674 : forall X1 X2 X3 X4:term, auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_13 X1 -> auto___type_10 X1). tauto. exact (rem_236 X1).
Qed.

Remark rem_675 : forall X1 X2 X3 X4:term, auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_652 X2).
Qed.

Remark rem_676 : forall X1 X2 X3 X4:term, auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X3 -> auto_knows_current X3). tauto. exact (rem_654 X3).
Qed.

Remark rem_677 : forall X1 X2 X3 X4:term, auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_61 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_12 X4 -> auto___def_61 X4). tauto. exact (rem_611 X4).
Qed.

Remark rem_678 : forall X1 X2 X3 X4:term, auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_12 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_12 X4 -> auto___type_12 X4). tauto. exact (rem_613 X4).
Qed.

Remark rem_679 : forall X1 X2 X3 X4:term, auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current X2 -> auto_knows_current X3 -> (auto___type_13 X1 /\ auto___type_10 X1 /\ auto_knows_current X2 /\ auto_knows_current X3 /\ auto___def_61 X4 /\ auto___type_12 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  cut (auto___type_13 X1). 2:apply (rem_673 X1 X2 X3 X4);  assumption.
  cut (auto___type_10 X1). 2:apply (rem_674 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_675 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X3). 2:apply (rem_676 X1 X2 X3 X4);  assumption.
  cut (auto___def_61 X4). 2:apply (rem_677 X1 X2 X3 X4);  assumption.
  cut (auto___type_12 X4). 2:apply (rem_678 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_680 : forall X1 X2 X3 X4:term, auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  case (rem_679 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6). clear  A1 A2 A3 A4 A5 A6. intros. apply trans___def_83_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6. tauto.
Qed.

Remark rem_681 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current X3 -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_680 X1 X2 X3 X4).
Qed.

Remark rem_682 : forall X1 X2 X3 X4:term, auto___def_59 (l X2 X3) -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_661 X2 X3 H);  intros.
  apply (rem_681 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_683 : forall X1 X2:term, auto___def_70 (cons X1 X2) -> or_1
    (auto___def_59 X1 /\ auto___def_71 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_684 : forall X1 X2 X3 X4:term, auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_73 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_683 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_682 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_685 : forall X1 X2 X3 X4:term, auto___def_63 sym -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_73 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_73 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_684 X1 X2 X3 X4).
Qed.

Remark rem_686 : forall X1 X2 X3 X4:term, auto___def_63 sym -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_63 sym -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_73 (cons X3 (cons server nil)) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_685 X1 X2 X3 X4).
Qed.

Remark rem_687 : forall X1 X2:term, auto___def_69 (key X1 X2) -> or_1
    (auto___def_63 X1 /\ auto___def_73 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_688 : forall X1 X2 X3 X4:term, auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_687 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_686 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_689 : forall X1 X2 X3 X4:term, auto___def_57 t_current -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_688 X1 X2 X3 X4).
Qed.

Remark rem_690 : forall X1 X2 X3 X4:term, auto___def_57 t_current -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 t_current -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_689 X1 X2 X3 X4).
Qed.

Remark rem_691 : forall X1 X2:term, auto___def_68 (cons X1 X2) -> or_1
    (auto___def_57 X1 /\ auto___def_70 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_692 : forall X1 X2 X3 X4:term, auto___def_68 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___type_12 X4 -> auto___type_13 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_691 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_690 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_693 : forall X1 X2:term, auto_knows_current (crypt X1 X2) -> or_7
    (auto___def_80 X1 /\ auto___type_12 X2)
    (auto_knows_current X1 /\ auto_knows_current X2)
    (auto___def_84 X1 /\ auto___type_14 X2)
    (auto___def_23 X1 /\ auto___def_24 X2)
    (auto___def_10 X1 /\ auto___def_11 X2)
    (auto___def_55 X1 /\ auto___def_56 X2)
    (auto___def_68 X1 /\ auto___def_69 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_7_intro_1; tauto.
  intros. apply or_7_intro_2; tauto.
  intros. apply or_7_intro_3; tauto.
  intros. apply or_7_intro_4; tauto.
  intros. apply or_7_intro_5; tauto.
  intros. apply or_7_intro_6; tauto.
  intros. apply or_7_intro_7; tauto.
Qed.

Remark rem_694 : forall X1 X2 X3 X4:term, auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_693 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil))) H);  intros.
  apply (rem_48 X1 X2 X3 X4);  tauto.
  apply (rem_131 X1 X2 X3 X4);  tauto.
  apply (rem_134 X1 X2 X3 X4);  tauto.
  apply (rem_629 X1 X2 X3 X4);  tauto.
  apply (rem_649 X1 X2 X3 X4);  tauto.
  apply (rem_672 X1 X2 X3 X4);  tauto.
  apply (rem_692 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_695 : forall X1 X2 X3 X4:term, auto___def_81 (cons t_current nil) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_694 X1 X2 X3 X4).
Qed.

Remark rem_696 : forall X1 X2 X3 X4:term, auto___type_13 X1 -> auto___def_81 (cons t_current nil) -> auto___type_12 X4 -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_81 (cons t_current nil) -> auto___type_12 X4 -> auto___type_13 X1 -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_695 X1 X2 X3 X4).
Qed.

Remark rem_697 : forall X1 X2 X3 X4:term, auto___def_80 (cons X1 (cons t_current nil)) -> auto___type_12 X4 -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_46 X1 (cons t_current nil) H);  intros.
  apply (rem_696 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_698 : forall X1 X2 X3 X4:term, auto___def_31 (cons X4 (cons X1 nil)) -> auto___def_82 (l X2 X3) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_39 X4 (cons X1 nil) H);  intros.
Qed.

Remark rem_699 : forall X1 X2 X3 X4:term, auto___def_82 (l X2 X3) -> auto___def_31 (cons X4 (cons X1 nil)) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_31 (cons X4 (cons X1 nil)) -> auto___def_82 (l X2 X3) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_698 X1 X2 X3 X4).
Qed.

Remark rem_700 : forall X1 X2 X3 X4:term, auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_42 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_699 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_701 : forall X1 X2 X3 X4:term, auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___type_13 t_current -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_700 X1 X2 X3 X4).
Qed.

Remark rem_702 : forall X1 X2 X3 X4:term, auto___type_13 t_current -> auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___type_13 t_current -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_701 X1 X2 X3 X4).
Qed.

Remark rem_703 : forall X1 X2 X3 X4:term, auto___def_80 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_46 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_702 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_704 : forall X1 X2:term, auto_knows_current (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_705 : forall X1 X2 X3 X4:term, auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_704 X2 X3 H);  intros.
Qed.

Remark rem_706 : forall X1 X2 X3 X4:term, auto___def_42 sym -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_705 X1 X2 X3 X4).
Qed.

Remark rem_707 : forall X1 X2 X3 X4:term, auto___def_42 sym -> auto___type_8 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2 X3 X4. intros. apply (rem_706 X1 X2 X3 X4);  assumption.
Qed.

Remark rem_708 : forall X1 X2:term, auto___def_47 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_709 : forall X1 X2 X3 X4:term, auto___def_47 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_708 X3 (cons server nil) H);  intros.
Qed.

Remark rem_710 : forall X1 X2 X3 X4:term, auto___def_46 sym -> auto___def_47 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_47 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_709 X1 X2 X3 X4).
Qed.

Remark rem_711 : forall X1 X2:term, auto___def_44 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_712 : forall X1 X2 X3 X4:term, auto___def_44 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_711 X3 (cons server nil) H);  intros.
Qed.

Remark rem_713 : forall X1 X2 X3 X4:term, auto___def_43 sym -> auto___def_44 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_44 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_712 X1 X2 X3 X4).
Qed.

Remark rem_714 : forall X1 X2 X3 X4:term, auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_101 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_707 X1 X2 X3 X4);  tauto.
  apply (rem_710 X1 X2 X3 X4);  tauto.
  apply (rem_713 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_715 : forall X1 X2 X3 X4:term, auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto_knows_current nil -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_714 X1 X2 X3 X4).
Qed.

Remark rem_716 : forall X1 X2 X3 X4:term, auto_knows_current X1 -> auto_knows_current nil -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto_knows_current nil -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_715 X1 X2 X3 X4).
Qed.

Remark rem_717 : forall X1 X2 X3 X4:term, auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (cons X1 nil) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_124 X1 nil H);  intros.
  apply (rem_716 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_718 : forall X1 X2 X3 X4:term, auto_knows_current X4 -> auto_knows_current (cons X1 nil) -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (cons X1 nil) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_717 X1 X2 X3 X4).
Qed.

Remark rem_719 : forall X1 X2 X3 X4:term, auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_124 X4 (cons X1 nil) H);  intros.
  apply (rem_718 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_720 : forall X1 X2 X3 X4:term, auto_knows_current (l X2 X3) -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_719 X1 X2 X3 X4).
Qed.

Remark rem_721 : forall X1 X2 X3 X4:term, auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_124 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_720 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_722 : forall X1 X2 X3 X4:term, auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current t_current -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_721 X1 X2 X3 X4).
Qed.

Remark rem_723 : forall X1 X2 X3 X4:term, auto_knows_current t_current -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current t_current -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_722 X1 X2 X3 X4).
Qed.

Remark rem_724 : forall X1 X2 X3 X4:term, auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_124 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_723 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_725 : forall X1 X2 X3 X4:term, auto_knows_current (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_724 X1 X2 X3 X4).
Qed.

Remark rem_726 : forall X1 X2 X3 X4:term, auto___def_84 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_14 (key sym (cons X3 (cons server nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_132 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
Qed.

Remark rem_727 : auto___def_12 t_current -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_728 : auto___def_12 t_current -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_727 H);  intros.
Qed.

Remark rem_729 : forall X1 X2 X3 X4:term, auto___def_12 t_current -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_12 t_current -> False). tauto.
  exact (rem_728).
Qed.

Remark rem_730 : forall X1 X2 X3 X4:term, auto___def_12 t_current -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 t_current -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_729 X1 X2 X3 X4).
Qed.

Remark rem_731 : forall X1 X2 X3 X4:term, auto___def_23 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_628 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_730 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_732 : auto___def_20 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_733 : auto___def_20 nil -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_732 H);  intros.
Qed.

Remark rem_734 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_20 nil -> auto___def_32 (cons X3 (cons server nil)) -> auto___type_2 X1 -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_20 nil -> False). tauto.
  exact (rem_733).
Qed.

Remark rem_735 : forall X1 X2 X3 X4:term, auto___type_2 X1 -> auto___def_20 nil -> auto___def_16 X4 -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_16 X4 -> auto___def_20 nil -> auto___def_32 (cons X3 (cons server nil)) -> auto___type_2 X1 -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_734 X1 X2 X3 X4).
Qed.

Remark rem_736 : forall X1 X2:term, auto___def_17 (cons X1 X2) -> or_1
    (auto___type_2 X1 /\ auto___def_20 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_737 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_17 (cons X1 nil) -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_736 X1 nil H);  intros.
  apply (rem_735 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_738 : forall X1 X2:term, auto___def_15 (cons X1 X2) -> or_1
    (auto___def_16 X1 /\ auto___def_17 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_739 : forall X1 X2 X3 X4:term, auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_738 X4 (cons X1 nil) H);  intros.
  apply (rem_737 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_740 : forall X1 X2 X3 X4:term, auto_knows_old X2 -> auto_knows_old X3 -> auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_739 X1 X2 X3 X4).
Qed.

Remark rem_741 : forall X1 X2 X3 X4:term, auto___def_14 (l X2 X3) -> auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_618 X2 X3 H);  intros.
  apply (rem_740 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_742 : forall X1 X2 X3 X4:term, auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_640 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_741 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_743 : forall X1 X2 X3 X4:term, auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_18 sym -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_742 X1 X2 X3 X4).
Qed.

Remark rem_744 : forall X1 X2 X3 X4:term, auto___def_18 sym -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_18 sym -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_743 X1 X2 X3 X4).
Qed.

Remark rem_745 : forall X1 X2 X3 X4:term, auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_644 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_744 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_746 : forall X1 X2 X3 X4:term, auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_12 t_current -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_745 X1 X2 X3 X4).
Qed.

Remark rem_747 : forall X1 X2 X3 X4:term, auto___def_12 t_current -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_11 (key sym (cons X3 (cons server nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_12 t_current -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_746 X1 X2 X3 X4).
Qed.

Remark rem_748 : forall X1 X2 X3 X4:term, auto___def_10 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_11 (key sym (cons X3 (cons server nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_648 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_747 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_749 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_750 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_749 epsilon_mknows_current_p__type_13 X1);  assumption.
  tauto.
Defined.

Remark rem_751 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1:term, auto_knows_current X1 -> auto___type_13 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1. intros A1.
  case (rem_750 epsilon_mknows_current_p__type_13 X1 A1). clear  epsilon_mknows_current_p__type_13 A1. intros. apply trans___type_13_s_1;  tauto.
 clear  epsilon_mknows_current_p__type_13 A1. tauto.
Defined.

Remark rem_752 : forall X1:term, auto_knows_current (s X1) -> or_1
    (auto_knows_current X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_753 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1:term, auto_knows_current (s X1) -> auto___type_13 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1. intro H. intros.
  elim (rem_752 X1 H);  intros.
  apply (rem_751 epsilon_mknows_current_p__type_13 X1);  tauto.
Defined.

Remark rem_754 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_13.  tauto.
Defined.

Remark rem_755 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> auto___type_13 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13.  case (rem_754 epsilon_mknows_current_p__type_13). clear  epsilon_mknows_current_p__type_13. intros. apply trans___type_13_nil_1;  tauto.
 clear  epsilon_mknows_current_p__type_13. tauto.
Defined.

Remark rem_756 : auto_knows_current nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_757 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> auto_knows_current nil -> auto___type_13 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intro H. intros.
  elim (rem_756 H);  intros.
  apply (rem_755 epsilon_mknows_current_p__type_13);  tauto.
Defined.

Remark rem_758 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> auto___type_13 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13.  case (rem_754 epsilon_mknows_current_p__type_13). clear  epsilon_mknows_current_p__type_13. intros. apply trans___type_13_i_1;  tauto.
 clear  epsilon_mknows_current_p__type_13. tauto.
Defined.

Remark rem_759 : auto_knows_current i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_760 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> auto_knows_current i -> auto___type_13 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intro H. intros.
  elim (rem_759 H);  intros.
  apply (rem_758 epsilon_mknows_current_p__type_13);  tauto.
Defined.

Remark rem_761 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_749 epsilon_mknows_current_p__type_13 X1).
Defined.

Remark rem_762 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X2:term, auto_knows_current X2 -> auto_knows_current X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_763 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_762 epsilon_mknows_current_p__type_13 X2).
Defined.

Remark rem_764 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_761 epsilon_mknows_current_p__type_13 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_763 epsilon_mknows_current_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_765 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_13 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_764 epsilon_mknows_current_p__type_13 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_13 A1 A2. intros. apply trans___type_13_cons_1;  tauto.
 clear  epsilon_mknows_current_p__type_13 A1 A2. tauto.
Defined.

Remark rem_766 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto_knows_current (cons X1 X2) -> auto___type_13 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2. intro H. intros.
  elim (rem_124 X1 X2 H);  intros.
  apply (rem_765 epsilon_mknows_current_p__type_13 X1 X2);  tauto.
Defined.

Remark rem_767 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1:term, auto___def_80 X1 -> auto___def_80 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_768 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> auto___def_80 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2.
  cut (auto___def_80 X1 -> auto___def_80 X1). tauto. exact (rem_767 epsilon_mknows_current_p__type_13 X1).
Defined.

Remark rem_769 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X2:term, auto___type_12 X2 -> auto___type_12 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_770 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> auto___type_12 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2.
  cut (auto___type_12 X2 -> auto___type_12 X2). tauto. exact (rem_769 epsilon_mknows_current_p__type_13 X2).
Defined.

Remark rem_771 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> (auto___def_80 X1 /\ auto___type_12 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto___def_80 X1). 2:apply (rem_768 epsilon_mknows_current_p__type_13 X1 X2);  assumption.
  cut (auto___type_12 X2). 2:apply (rem_770 epsilon_mknows_current_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_772 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> auto___type_13 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_771 epsilon_mknows_current_p__type_13 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_13 A1 A2. intros. apply trans___type_13_crypt_1;  tauto.
 clear  epsilon_mknows_current_p__type_13 A1 A2. tauto.
Defined.

Remark rem_773 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_13 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_764 epsilon_mknows_current_p__type_13 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_13 A1 A2. intros. apply trans___type_13_crypt_2;  tauto.
 clear  epsilon_mknows_current_p__type_13 A1 A2. tauto.
Defined.

Remark rem_774 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1:term, auto___def_84 X1 -> auto___def_84 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_775 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> auto___def_84 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2.
  cut (auto___def_84 X1 -> auto___def_84 X1). tauto. exact (rem_774 epsilon_mknows_current_p__type_13 X1).
Defined.

Remark rem_776 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X2:term, auto___type_14 X2 -> auto___type_14 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_777 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> auto___type_14 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2.
  cut (auto___type_14 X2 -> auto___type_14 X2). tauto. exact (rem_776 epsilon_mknows_current_p__type_13 X2).
Defined.

Remark rem_778 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> (auto___def_84 X1 /\ auto___type_14 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto___def_84 X1). 2:apply (rem_775 epsilon_mknows_current_p__type_13 X1 X2);  assumption.
  cut (auto___type_14 X2). 2:apply (rem_777 epsilon_mknows_current_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_779 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> auto___type_13 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_778 epsilon_mknows_current_p__type_13 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_13 A1 A2. intros. apply trans___type_13_crypt_3;  tauto.
 clear  epsilon_mknows_current_p__type_13 A1 A2. tauto.
Defined.

Remark rem_780 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1:term, auto___def_23 X1 -> auto___def_23 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_781 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_23 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2.
  cut (auto___def_23 X1 -> auto___def_23 X1). tauto. exact (rem_780 epsilon_mknows_current_p__type_13 X1).
Defined.

Remark rem_782 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X2:term, auto___def_24 X2 -> auto___def_24 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_783 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_24 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2.
  cut (auto___def_24 X2 -> auto___def_24 X2). tauto. exact (rem_782 epsilon_mknows_current_p__type_13 X2).
Defined.

Remark rem_784 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> (auto___def_23 X1 /\ auto___def_24 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto___def_23 X1). 2:apply (rem_781 epsilon_mknows_current_p__type_13 X1 X2);  assumption.
  cut (auto___def_24 X2). 2:apply (rem_783 epsilon_mknows_current_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_785 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___type_13 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_784 epsilon_mknows_current_p__type_13 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_13 A1 A2. intros. apply trans___type_13_crypt_4;  tauto.
 clear  epsilon_mknows_current_p__type_13 A1 A2. tauto.
Defined.

Remark rem_786 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1:term, auto___def_10 X1 -> auto___def_10 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_787 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_10 X1). tauto. exact (rem_786 epsilon_mknows_current_p__type_13 X1).
Defined.

Remark rem_788 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X2:term, auto___def_11 X2 -> auto___def_11 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_789 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2.
  cut (auto___def_11 X2 -> auto___def_11 X2). tauto. exact (rem_788 epsilon_mknows_current_p__type_13 X2).
Defined.

Remark rem_790 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> (auto___def_10 X1 /\ auto___def_11 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto___def_10 X1). 2:apply (rem_787 epsilon_mknows_current_p__type_13 X1 X2);  assumption.
  cut (auto___def_11 X2). 2:apply (rem_789 epsilon_mknows_current_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_791 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___type_13 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_790 epsilon_mknows_current_p__type_13 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_13 A1 A2. intros. apply trans___type_13_crypt_5;  tauto.
 clear  epsilon_mknows_current_p__type_13 A1 A2. tauto.
Defined.

Remark rem_792 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1:term, auto___def_55 X1 -> auto___def_55 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_793 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> auto___def_55 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2.
  cut (auto___def_55 X1 -> auto___def_55 X1). tauto. exact (rem_792 epsilon_mknows_current_p__type_13 X1).
Defined.

Remark rem_794 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X2:term, auto___def_56 X2 -> auto___def_56 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_795 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> auto___def_56 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2.
  cut (auto___def_56 X2 -> auto___def_56 X2). tauto. exact (rem_794 epsilon_mknows_current_p__type_13 X2).
Defined.

Remark rem_796 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> (auto___def_55 X1 /\ auto___def_56 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto___def_55 X1). 2:apply (rem_793 epsilon_mknows_current_p__type_13 X1 X2);  assumption.
  cut (auto___def_56 X2). 2:apply (rem_795 epsilon_mknows_current_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_797 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> auto___type_13 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_796 epsilon_mknows_current_p__type_13 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_13 A1 A2. intros. apply trans___type_13_crypt_6;  tauto.
 clear  epsilon_mknows_current_p__type_13 A1 A2. tauto.
Defined.

Remark rem_798 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1:term, auto___def_68 X1 -> auto___def_68 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_799 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> auto___def_68 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2.
  cut (auto___def_68 X1 -> auto___def_68 X1). tauto. exact (rem_798 epsilon_mknows_current_p__type_13 X1).
Defined.

Remark rem_800 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X2:term, auto___def_69 X2 -> auto___def_69 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_801 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> auto___def_69 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2.
  cut (auto___def_69 X2 -> auto___def_69 X2). tauto. exact (rem_800 epsilon_mknows_current_p__type_13 X2).
Defined.

Remark rem_802 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> (auto___def_68 X1 /\ auto___def_69 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto___def_68 X1). 2:apply (rem_799 epsilon_mknows_current_p__type_13 X1 X2);  assumption.
  cut (auto___def_69 X2). 2:apply (rem_801 epsilon_mknows_current_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_803 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> auto___type_13 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_802 epsilon_mknows_current_p__type_13 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_13 A1 A2. intros. apply trans___type_13_crypt_7;  tauto.
 clear  epsilon_mknows_current_p__type_13 A1 A2. tauto.
Defined.

Remark rem_804 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto_knows_current (crypt X1 X2) -> auto___type_13 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2. intro H. intros.
  elim (rem_693 X1 X2 H);  intros.
  apply (rem_772 epsilon_mknows_current_p__type_13 X1 X2);  tauto.
  apply (rem_773 epsilon_mknows_current_p__type_13 X1 X2);  tauto.
  apply (rem_779 epsilon_mknows_current_p__type_13 X1 X2);  tauto.
  apply (rem_785 epsilon_mknows_current_p__type_13 X1 X2);  tauto.
  apply (rem_791 epsilon_mknows_current_p__type_13 X1 X2);  tauto.
  apply (rem_797 epsilon_mknows_current_p__type_13 X1 X2);  tauto.
  apply (rem_803 epsilon_mknows_current_p__type_13 X1 X2);  tauto.
Defined.

Remark rem_805 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> auto___type_13 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13.  case (rem_754 epsilon_mknows_current_p__type_13). clear  epsilon_mknows_current_p__type_13. intros. apply trans___type_13_bob_1;  tauto.
 clear  epsilon_mknows_current_p__type_13. tauto.
Defined.

Remark rem_806 : auto_knows_current bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_807 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> auto_knows_current bob -> auto___type_13 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intro H. intros.
  elim (rem_806 H);  intros.
  apply (rem_805 epsilon_mknows_current_p__type_13);  tauto.
Defined.

Remark rem_808 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1:term, auto___def_42 X1 -> auto___def_42 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_809 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___def_42 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2.
  cut (auto___def_42 X1 -> auto___def_42 X1). tauto. exact (rem_808 epsilon_mknows_current_p__type_13 X1).
Defined.

Remark rem_810 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_811 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_810 epsilon_mknows_current_p__type_13 X2).
Defined.

Remark rem_812 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> (auto___def_42 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto___def_42 X1). 2:apply (rem_809 epsilon_mknows_current_p__type_13 X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_811 epsilon_mknows_current_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_813 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___type_13 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_812 epsilon_mknows_current_p__type_13 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_13 A1 A2. intros. apply trans___type_13_key_1;  tauto.
 clear  epsilon_mknows_current_p__type_13 A1 A2. tauto.
Defined.

Remark rem_814 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1:term, auto___def_46 X1 -> auto___def_46 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_815 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_46 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2.
  cut (auto___def_46 X1 -> auto___def_46 X1). tauto. exact (rem_814 epsilon_mknows_current_p__type_13 X1).
Defined.

Remark rem_816 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X2:term, auto___def_47 X2 -> auto___def_47 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_817 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_47 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2.
  cut (auto___def_47 X2 -> auto___def_47 X2). tauto. exact (rem_816 epsilon_mknows_current_p__type_13 X2).
Defined.

Remark rem_818 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> (auto___def_46 X1 /\ auto___def_47 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto___def_46 X1). 2:apply (rem_815 epsilon_mknows_current_p__type_13 X1 X2);  assumption.
  cut (auto___def_47 X2). 2:apply (rem_817 epsilon_mknows_current_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_819 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___type_13 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_818 epsilon_mknows_current_p__type_13 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_13 A1 A2. intros. apply trans___type_13_key_2;  tauto.
 clear  epsilon_mknows_current_p__type_13 A1 A2. tauto.
Defined.

Remark rem_820 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1:term, auto___def_43 X1 -> auto___def_43 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_821 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_43 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_43 X1). tauto. exact (rem_820 epsilon_mknows_current_p__type_13 X1).
Defined.

Remark rem_822 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X2:term, auto___def_44 X2 -> auto___def_44 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_823 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_44 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2.
  cut (auto___def_44 X2 -> auto___def_44 X2). tauto. exact (rem_822 epsilon_mknows_current_p__type_13 X2).
Defined.

Remark rem_824 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> (auto___def_43 X1 /\ auto___def_44 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto___def_43 X1). 2:apply (rem_821 epsilon_mknows_current_p__type_13 X1 X2);  assumption.
  cut (auto___def_44 X2). 2:apply (rem_823 epsilon_mknows_current_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_825 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___type_13 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_824 epsilon_mknows_current_p__type_13 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_13 A1 A2. intros. apply trans___type_13_key_3;  tauto.
 clear  epsilon_mknows_current_p__type_13 A1 A2. tauto.
Defined.

Remark rem_826 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> forall X1 X2:term, auto_knows_current (key X1 X2) -> auto___type_13 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intros X1 X2. intro H. intros.
  elim (rem_101 X1 X2 H);  intros.
  apply (rem_813 epsilon_mknows_current_p__type_13 X1 X2);  tauto.
  apply (rem_819 epsilon_mknows_current_p__type_13 X1 X2);  tauto.
  apply (rem_825 epsilon_mknows_current_p__type_13 X1 X2);  tauto.
Defined.

Remark rem_827 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> auto___type_13 t_old. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13.  case (rem_754 epsilon_mknows_current_p__type_13). clear  epsilon_mknows_current_p__type_13. intros. apply trans___type_13_t_old_1;  tauto.
 clear  epsilon_mknows_current_p__type_13. tauto.
Defined.

Remark rem_828 : auto_knows_current t_old -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_829 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> auto_knows_current t_old -> auto___type_13 t_old. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intro H. intros.
  elim (rem_828 H);  intros.
  apply (rem_827 epsilon_mknows_current_p__type_13);  tauto.
Defined.

Remark rem_830 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> auto___type_13 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13.  case (rem_754 epsilon_mknows_current_p__type_13). clear  epsilon_mknows_current_p__type_13. intros. apply trans___type_13_alice_1;  tauto.
 clear  epsilon_mknows_current_p__type_13. tauto.
Defined.

Remark rem_831 : auto_knows_current alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_832 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> auto_knows_current alice -> auto___type_13 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intro H. intros.
  elim (rem_831 H);  intros.
  apply (rem_830 epsilon_mknows_current_p__type_13);  tauto.
Defined.

Remark rem_833 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> auto___type_13 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13.  case (rem_754 epsilon_mknows_current_p__type_13). clear  epsilon_mknows_current_p__type_13. intros. apply trans___type_13_server_1;  tauto.
 clear  epsilon_mknows_current_p__type_13. tauto.
Defined.

Remark rem_834 : auto_knows_current server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_835 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> auto_knows_current server -> auto___type_13 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intro H. intros.
  elim (rem_834 H);  intros.
  apply (rem_833 epsilon_mknows_current_p__type_13);  tauto.
Defined.

Remark rem_836 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> auto___type_13 t_current. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13.  case (rem_754 epsilon_mknows_current_p__type_13). clear  epsilon_mknows_current_p__type_13. intros. apply trans___type_13_t_current_1;  tauto.
 clear  epsilon_mknows_current_p__type_13. tauto.
Defined.

Remark rem_837 : auto_knows_current t_current -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_838 : (forall X:term, auto_knows_current X -> auto___type_13 X)
    -> auto_knows_current t_current -> auto___type_13 t_current. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_13. intro H. intros.
  elim (rem_837 H);  intros.
  apply (rem_836 epsilon_mknows_current_p__type_13);  tauto.
Defined.

Remark rem_839 : forall X1 X2:term, auto_knows_current (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_840 : forall X1 X2:term, auto_knows_current (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_841 : auto_knows_current sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_842 : auto_knows_current prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_843 : auto_knows_current pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_844 : forall X1:term, auto_knows_current X1 -> auto___type_13 X1. (* Induct. *)
Proof.
  fix epsilon_mknows_current_p__type_13 1.
  intro X. case X.
  exact (rem_832 epsilon_mknows_current_p__type_13 ).
  exact (rem_807 epsilon_mknows_current_p__type_13 ).
  intros X1 X2;  exact (rem_766 epsilon_mknows_current_p__type_13 X1 X2).
  intros X1 X2;  exact (rem_804 epsilon_mknows_current_p__type_13 X1 X2).
  exact (rem_760 epsilon_mknows_current_p__type_13 ).
  intros X1 X2;  exact (rem_826 epsilon_mknows_current_p__type_13 X1 X2).
  intros X1 X2. intro H. elim (rem_704 X1 X2 H).
  exact (rem_757 epsilon_mknows_current_p__type_13 ).
   intro H. elim (rem_842  H).
   intro H. elim (rem_843  H).
  intros X1;  exact (rem_753 epsilon_mknows_current_p__type_13 X1).
  exact (rem_835 epsilon_mknows_current_p__type_13 ).
  intros X1 X2. intro H. elim (rem_839 X1 X2 H).
  intros X1 X2. intro H. elim (rem_840 X1 X2 H).
   intro H. elim (rem_841  H).
  exact (rem_838 epsilon_mknows_current_p__type_13 ).
  exact (rem_829 epsilon_mknows_current_p__type_13 ).
Qed.

Remark rem_845 : forall X1 X2 X3 X4:term, auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X1 -> auto___type_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X1 -> auto___type_13 X1). tauto. exact (rem_844 X1).
Qed.

Remark rem_846 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_847 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_846 epsilon_mknows_current_p__type_10 X1);  assumption.
  tauto.
Defined.

Remark rem_848 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto_knows_current X1 -> auto___type_10 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1. intros A1.
  case (rem_847 epsilon_mknows_current_p__type_10 X1 A1). clear  epsilon_mknows_current_p__type_10 A1. intros. apply trans___type_10_s_1;  tauto.
 clear  epsilon_mknows_current_p__type_10 A1. tauto.
Defined.

Remark rem_849 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto_knows_current (s X1) -> auto___type_10 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1. intro H. intros.
  elim (rem_752 X1 H);  intros.
  apply (rem_848 epsilon_mknows_current_p__type_10 X1);  tauto.
Defined.

Remark rem_850 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_10.  tauto.
Defined.

Remark rem_851 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> auto___type_10 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10.  case (rem_850 epsilon_mknows_current_p__type_10). clear  epsilon_mknows_current_p__type_10. intros. apply trans___type_10_nil_1;  tauto.
 clear  epsilon_mknows_current_p__type_10. tauto.
Defined.

Remark rem_852 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> auto_knows_current nil -> auto___type_10 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intro H. intros.
  elim (rem_756 H);  intros.
  apply (rem_851 epsilon_mknows_current_p__type_10);  tauto.
Defined.

Remark rem_853 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> auto___type_10 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10.  case (rem_850 epsilon_mknows_current_p__type_10). clear  epsilon_mknows_current_p__type_10. intros. apply trans___type_10_i_1;  tauto.
 clear  epsilon_mknows_current_p__type_10. tauto.
Defined.

Remark rem_854 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> auto_knows_current i -> auto___type_10 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intro H. intros.
  elim (rem_759 H);  intros.
  apply (rem_853 epsilon_mknows_current_p__type_10);  tauto.
Defined.

Remark rem_855 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_846 epsilon_mknows_current_p__type_10 X1).
Defined.

Remark rem_856 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X2:term, auto_knows_current X2 -> auto_knows_current X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_857 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_856 epsilon_mknows_current_p__type_10 X2).
Defined.

Remark rem_858 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_855 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_857 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_859 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_10 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_858 epsilon_mknows_current_p__type_10 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_10 A1 A2. intros. apply trans___type_10_cons_1;  tauto.
 clear  epsilon_mknows_current_p__type_10 A1 A2. tauto.
Defined.

Remark rem_860 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto_knows_current (cons X1 X2) -> auto___type_10 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intro H. intros.
  elim (rem_124 X1 X2 H);  intros.
  apply (rem_859 epsilon_mknows_current_p__type_10 X1 X2);  tauto.
Defined.

Remark rem_861 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto___def_80 X1 -> auto___def_80 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_862 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> auto___def_80 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_80 X1 -> auto___def_80 X1). tauto. exact (rem_861 epsilon_mknows_current_p__type_10 X1).
Defined.

Remark rem_863 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X2:term, auto___type_12 X2 -> auto___type_12 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_864 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> auto___type_12 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___type_12 X2 -> auto___type_12 X2). tauto. exact (rem_863 epsilon_mknows_current_p__type_10 X2).
Defined.

Remark rem_865 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> (auto___def_80 X1 /\ auto___type_12 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_80 X1). 2:apply (rem_862 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  cut (auto___type_12 X2). 2:apply (rem_864 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_866 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> auto___type_10 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_865 epsilon_mknows_current_p__type_10 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_10 A1 A2. intros. apply trans___type_10_crypt_1;  tauto.
 clear  epsilon_mknows_current_p__type_10 A1 A2. tauto.
Defined.

Remark rem_867 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_10 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_858 epsilon_mknows_current_p__type_10 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_10 A1 A2. intros. apply trans___type_10_crypt_2;  tauto.
 clear  epsilon_mknows_current_p__type_10 A1 A2. tauto.
Defined.

Remark rem_868 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto___def_84 X1 -> auto___def_84 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_869 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> auto___def_84 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_84 X1 -> auto___def_84 X1). tauto. exact (rem_868 epsilon_mknows_current_p__type_10 X1).
Defined.

Remark rem_870 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X2:term, auto___type_14 X2 -> auto___type_14 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_871 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> auto___type_14 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___type_14 X2 -> auto___type_14 X2). tauto. exact (rem_870 epsilon_mknows_current_p__type_10 X2).
Defined.

Remark rem_872 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> (auto___def_84 X1 /\ auto___type_14 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_84 X1). 2:apply (rem_869 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  cut (auto___type_14 X2). 2:apply (rem_871 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_873 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> auto___type_10 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_872 epsilon_mknows_current_p__type_10 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_10 A1 A2. intros. apply trans___type_10_crypt_3;  tauto.
 clear  epsilon_mknows_current_p__type_10 A1 A2. tauto.
Defined.

Remark rem_874 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto___def_23 X1 -> auto___def_23 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_875 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_23 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_23 X1 -> auto___def_23 X1). tauto. exact (rem_874 epsilon_mknows_current_p__type_10 X1).
Defined.

Remark rem_876 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X2:term, auto___def_24 X2 -> auto___def_24 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_877 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_24 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_24 X2 -> auto___def_24 X2). tauto. exact (rem_876 epsilon_mknows_current_p__type_10 X2).
Defined.

Remark rem_878 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> (auto___def_23 X1 /\ auto___def_24 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_23 X1). 2:apply (rem_875 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  cut (auto___def_24 X2). 2:apply (rem_877 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_879 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___type_10 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_878 epsilon_mknows_current_p__type_10 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_10 A1 A2. intros. apply trans___type_10_crypt_4;  tauto.
 clear  epsilon_mknows_current_p__type_10 A1 A2. tauto.
Defined.

Remark rem_880 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto___def_10 X1 -> auto___def_10 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_881 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_10 X1). tauto. exact (rem_880 epsilon_mknows_current_p__type_10 X1).
Defined.

Remark rem_882 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X2:term, auto___def_11 X2 -> auto___def_11 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_883 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_11 X2 -> auto___def_11 X2). tauto. exact (rem_882 epsilon_mknows_current_p__type_10 X2).
Defined.

Remark rem_884 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> (auto___def_10 X1 /\ auto___def_11 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_10 X1). 2:apply (rem_881 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  cut (auto___def_11 X2). 2:apply (rem_883 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_885 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___type_10 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_884 epsilon_mknows_current_p__type_10 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_10 A1 A2. intros. apply trans___type_10_crypt_5;  tauto.
 clear  epsilon_mknows_current_p__type_10 A1 A2. tauto.
Defined.

Remark rem_886 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto___def_55 X1 -> auto___def_55 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_887 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> auto___def_55 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_55 X1 -> auto___def_55 X1). tauto. exact (rem_886 epsilon_mknows_current_p__type_10 X1).
Defined.

Remark rem_888 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X2:term, auto___def_56 X2 -> auto___def_56 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_889 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> auto___def_56 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_56 X2 -> auto___def_56 X2). tauto. exact (rem_888 epsilon_mknows_current_p__type_10 X2).
Defined.

Remark rem_890 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> (auto___def_55 X1 /\ auto___def_56 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_55 X1). 2:apply (rem_887 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  cut (auto___def_56 X2). 2:apply (rem_889 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_891 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> auto___type_10 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_890 epsilon_mknows_current_p__type_10 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_10 A1 A2. intros. apply trans___type_10_crypt_6;  tauto.
 clear  epsilon_mknows_current_p__type_10 A1 A2. tauto.
Defined.

Remark rem_892 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto___def_68 X1 -> auto___def_68 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_893 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> auto___def_68 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_68 X1 -> auto___def_68 X1). tauto. exact (rem_892 epsilon_mknows_current_p__type_10 X1).
Defined.

Remark rem_894 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X2:term, auto___def_69 X2 -> auto___def_69 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_895 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> auto___def_69 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_69 X2 -> auto___def_69 X2). tauto. exact (rem_894 epsilon_mknows_current_p__type_10 X2).
Defined.

Remark rem_896 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> (auto___def_68 X1 /\ auto___def_69 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_68 X1). 2:apply (rem_893 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  cut (auto___def_69 X2). 2:apply (rem_895 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_897 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> auto___type_10 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_896 epsilon_mknows_current_p__type_10 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_10 A1 A2. intros. apply trans___type_10_crypt_7;  tauto.
 clear  epsilon_mknows_current_p__type_10 A1 A2. tauto.
Defined.

Remark rem_898 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto_knows_current (crypt X1 X2) -> auto___type_10 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intro H. intros.
  elim (rem_693 X1 X2 H);  intros.
  apply (rem_866 epsilon_mknows_current_p__type_10 X1 X2);  tauto.
  apply (rem_867 epsilon_mknows_current_p__type_10 X1 X2);  tauto.
  apply (rem_873 epsilon_mknows_current_p__type_10 X1 X2);  tauto.
  apply (rem_879 epsilon_mknows_current_p__type_10 X1 X2);  tauto.
  apply (rem_885 epsilon_mknows_current_p__type_10 X1 X2);  tauto.
  apply (rem_891 epsilon_mknows_current_p__type_10 X1 X2);  tauto.
  apply (rem_897 epsilon_mknows_current_p__type_10 X1 X2);  tauto.
Defined.

Remark rem_899 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> auto___type_10 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10.  case (rem_850 epsilon_mknows_current_p__type_10). clear  epsilon_mknows_current_p__type_10. intros. apply trans___type_10_bob_1;  tauto.
 clear  epsilon_mknows_current_p__type_10. tauto.
Defined.

Remark rem_900 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> auto_knows_current bob -> auto___type_10 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intro H. intros.
  elim (rem_806 H);  intros.
  apply (rem_899 epsilon_mknows_current_p__type_10);  tauto.
Defined.

Remark rem_901 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto___def_42 X1 -> auto___def_42 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_902 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___def_42 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_42 X1 -> auto___def_42 X1). tauto. exact (rem_901 epsilon_mknows_current_p__type_10 X1).
Defined.

Remark rem_903 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_904 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_903 epsilon_mknows_current_p__type_10 X2).
Defined.

Remark rem_905 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> (auto___def_42 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_42 X1). 2:apply (rem_902 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_904 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_906 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___type_10 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_905 epsilon_mknows_current_p__type_10 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_10 A1 A2. intros. apply trans___type_10_key_1;  tauto.
 clear  epsilon_mknows_current_p__type_10 A1 A2. tauto.
Defined.

Remark rem_907 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto___def_46 X1 -> auto___def_46 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_908 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_46 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_46 X1 -> auto___def_46 X1). tauto. exact (rem_907 epsilon_mknows_current_p__type_10 X1).
Defined.

Remark rem_909 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X2:term, auto___def_47 X2 -> auto___def_47 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_910 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_47 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_47 X2 -> auto___def_47 X2). tauto. exact (rem_909 epsilon_mknows_current_p__type_10 X2).
Defined.

Remark rem_911 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> (auto___def_46 X1 /\ auto___def_47 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_46 X1). 2:apply (rem_908 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  cut (auto___def_47 X2). 2:apply (rem_910 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_912 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___type_10 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_911 epsilon_mknows_current_p__type_10 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_10 A1 A2. intros. apply trans___type_10_key_2;  tauto.
 clear  epsilon_mknows_current_p__type_10 A1 A2. tauto.
Defined.

Remark rem_913 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto___def_43 X1 -> auto___def_43 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_914 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_43 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_43 X1). tauto. exact (rem_913 epsilon_mknows_current_p__type_10 X1).
Defined.

Remark rem_915 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X2:term, auto___def_44 X2 -> auto___def_44 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_916 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_44 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_44 X2 -> auto___def_44 X2). tauto. exact (rem_915 epsilon_mknows_current_p__type_10 X2).
Defined.

Remark rem_917 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> (auto___def_43 X1 /\ auto___def_44 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_43 X1). 2:apply (rem_914 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  cut (auto___def_44 X2). 2:apply (rem_916 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_918 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___type_10 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_917 epsilon_mknows_current_p__type_10 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_10 A1 A2. intros. apply trans___type_10_key_3;  tauto.
 clear  epsilon_mknows_current_p__type_10 A1 A2. tauto.
Defined.

Remark rem_919 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto_knows_current (key X1 X2) -> auto___type_10 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intro H. intros.
  elim (rem_101 X1 X2 H);  intros.
  apply (rem_906 epsilon_mknows_current_p__type_10 X1 X2);  tauto.
  apply (rem_912 epsilon_mknows_current_p__type_10 X1 X2);  tauto.
  apply (rem_918 epsilon_mknows_current_p__type_10 X1 X2);  tauto.
Defined.

Remark rem_920 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> auto___type_10 t_old. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10.  case (rem_850 epsilon_mknows_current_p__type_10). clear  epsilon_mknows_current_p__type_10. intros. apply trans___type_10_t_old_1;  tauto.
 clear  epsilon_mknows_current_p__type_10. tauto.
Defined.

Remark rem_921 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> auto_knows_current t_old -> auto___type_10 t_old. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intro H. intros.
  elim (rem_828 H);  intros.
  apply (rem_920 epsilon_mknows_current_p__type_10);  tauto.
Defined.

Remark rem_922 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> auto___type_10 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10.  case (rem_850 epsilon_mknows_current_p__type_10). clear  epsilon_mknows_current_p__type_10. intros. apply trans___type_10_alice_1;  tauto.
 clear  epsilon_mknows_current_p__type_10. tauto.
Defined.

Remark rem_923 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> auto_knows_current alice -> auto___type_10 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intro H. intros.
  elim (rem_831 H);  intros.
  apply (rem_922 epsilon_mknows_current_p__type_10);  tauto.
Defined.

Remark rem_924 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> auto___type_10 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10.  case (rem_850 epsilon_mknows_current_p__type_10). clear  epsilon_mknows_current_p__type_10. intros. apply trans___type_10_server_1;  tauto.
 clear  epsilon_mknows_current_p__type_10. tauto.
Defined.

Remark rem_925 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> auto_knows_current server -> auto___type_10 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intro H. intros.
  elim (rem_834 H);  intros.
  apply (rem_924 epsilon_mknows_current_p__type_10);  tauto.
Defined.

Remark rem_926 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> auto___type_10 t_current. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10.  case (rem_850 epsilon_mknows_current_p__type_10). clear  epsilon_mknows_current_p__type_10. intros. apply trans___type_10_t_current_1;  tauto.
 clear  epsilon_mknows_current_p__type_10. tauto.
Defined.

Remark rem_927 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> auto_knows_current t_current -> auto___type_10 t_current. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intro H. intros.
  elim (rem_837 H);  intros.
  apply (rem_926 epsilon_mknows_current_p__type_10);  tauto.
Defined.

Remark rem_928 : forall X1:term, auto_knows_current X1 -> auto___type_10 X1. (* Induct. *)
Proof.
  fix epsilon_mknows_current_p__type_10 1.
  intro X. case X.
  exact (rem_923 epsilon_mknows_current_p__type_10 ).
  exact (rem_900 epsilon_mknows_current_p__type_10 ).
  intros X1 X2;  exact (rem_860 epsilon_mknows_current_p__type_10 X1 X2).
  intros X1 X2;  exact (rem_898 epsilon_mknows_current_p__type_10 X1 X2).
  exact (rem_854 epsilon_mknows_current_p__type_10 ).
  intros X1 X2;  exact (rem_919 epsilon_mknows_current_p__type_10 X1 X2).
  intros X1 X2. intro H. elim (rem_704 X1 X2 H).
  exact (rem_852 epsilon_mknows_current_p__type_10 ).
   intro H. elim (rem_842  H).
   intro H. elim (rem_843  H).
  intros X1;  exact (rem_849 epsilon_mknows_current_p__type_10 X1).
  exact (rem_925 epsilon_mknows_current_p__type_10 ).
  intros X1 X2. intro H. elim (rem_839 X1 X2 H).
  intros X1 X2. intro H. elim (rem_840 X1 X2 H).
   intro H. elim (rem_841  H).
  exact (rem_927 epsilon_mknows_current_p__type_10 ).
  exact (rem_921 epsilon_mknows_current_p__type_10 ).
Qed.

Remark rem_929 : forall X1 X2 X3 X4:term, auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X1 -> auto___type_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X1 -> auto___type_10 X1). tauto. exact (rem_928 X1).
Qed.

Remark rem_930 : forall X1 X2 X3 X4:term, auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_652 X2).
Qed.

Remark rem_931 : forall X1 X2 X3 X4:term, auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X3 -> auto_knows_current X3). tauto. exact (rem_654 X3).
Qed.

Remark rem_932 : forall X4:term, auto___def_61 X4 -> auto___def_61 X4. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_933 : forall X1 X2 X3 X4:term, auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_61 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_61 X4 -> auto___def_61 X4). tauto. exact (rem_932 X4).
Qed.

Remark rem_934 : (forall X:term, auto___def_61 X -> auto___type_12 X)
    -> forall X1:term, auto___def_63 X1 -> auto___def_63 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_935 : (forall X:term, auto___def_61 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_63 X1 -> auto___def_64 X2 -> auto___def_63 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_61_p__type_12. intros X1 X2.
  cut (auto___def_63 X1 -> auto___def_63 X1). tauto. exact (rem_934 epsilon_m__def_61_p__type_12 X1).
Defined.

Remark rem_936 : (forall X:term, auto___def_61 X -> auto___type_12 X)
    -> forall X2:term, auto___def_64 X2 -> auto___def_64 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_937 : (forall X:term, auto___def_61 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_63 X1 -> auto___def_64 X2 -> auto___def_64 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_61_p__type_12. intros X1 X2.
  cut (auto___def_64 X2 -> auto___def_64 X2). tauto. exact (rem_936 epsilon_m__def_61_p__type_12 X2).
Defined.

Remark rem_938 : (forall X:term, auto___def_61 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_63 X1 -> auto___def_64 X2 -> (auto___def_63 X1 /\ auto___def_64 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_61_p__type_12. intros X1 X2. intros A1 A2.
  cut (auto___def_63 X1). 2:apply (rem_935 epsilon_m__def_61_p__type_12 X1 X2);  assumption.
  cut (auto___def_64 X2). 2:apply (rem_937 epsilon_m__def_61_p__type_12 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_939 : (forall X:term, auto___def_61 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_63 X1 -> auto___def_64 X2 -> auto___type_12 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_61_p__type_12. intros X1 X2. intros A1 A2.
  case (rem_938 epsilon_m__def_61_p__type_12 X1 X2 A1 A2). clear  epsilon_m__def_61_p__type_12 A1 A2. intros. apply trans___type_12_key_1;  tauto.
 clear  epsilon_m__def_61_p__type_12 A1 A2. tauto.
Defined.

Remark rem_940 : forall X1 X2:term, auto___def_61 (key X1 X2) -> or_1
    (auto___def_63 X1 /\ auto___def_64 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_941 : (forall X:term, auto___def_61 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_61 (key X1 X2) -> auto___type_12 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_61_p__type_12. intros X1 X2. intro H. intros.
  elim (rem_940 X1 X2 H);  intros.
  apply (rem_939 epsilon_m__def_61_p__type_12 X1 X2);  tauto.
Defined.

Remark rem_942 : forall X1 X2:term, auto___def_61 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_943 : forall X1:term, auto___def_61 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_944 : auto___def_61 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_945 : auto___def_61 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_946 : forall X1 X2:term, auto___def_61 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_947 : forall X1 X2:term, auto___def_61 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_948 : auto___def_61 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_949 : auto___def_61 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_950 : forall X1 X2:term, auto___def_61 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_951 : forall X1 X2:term, auto___def_61 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_952 : auto___def_61 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_953 : auto___def_61 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_954 : auto___def_61 t_old -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_955 : auto___def_61 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_956 : auto___def_61 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_957 : auto___def_61 t_current -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_958 : forall X4:term, auto___def_61 X4 -> auto___type_12 X4. (* Induct. *)
Proof.
  fix epsilon_m__def_61_p__type_12 1.
  intro X. case X.
   intro H. elim (rem_955  H).
   intro H. elim (rem_952  H).
  intros X1 X2. intro H. elim (rem_947 X1 X2 H).
  intros X1 X2. intro H. elim (rem_951 X1 X2 H).
   intro H. elim (rem_945  H).
  intros X1 X2;  exact (rem_941 epsilon_m__def_61_p__type_12 X1 X2).
  intros X1 X2. intro H. elim (rem_950 X1 X2 H).
   intro H. elim (rem_944  H).
   intro H. elim (rem_949  H).
   intro H. elim (rem_953  H).
  intros X1. intro H. elim (rem_943 X1 H).
   intro H. elim (rem_956  H).
  intros X1 X2. intro H. elim (rem_942 X1 X2 H).
  intros X1 X2. intro H. elim (rem_946 X1 X2 H).
   intro H. elim (rem_948  H).
   intro H. elim (rem_957  H).
   intro H. elim (rem_954  H).
Qed.

Remark rem_959 : forall X1 X2 X3 X4:term, auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X1 -> auto___type_12 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_61 X4 -> auto___type_12 X4). tauto. exact (rem_958 X4).
Qed.

Remark rem_960 : forall X1 X2 X3 X4:term, auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X1 -> (auto___type_13 X1 /\ auto___type_10 X1 /\ auto_knows_current X2 /\ auto_knows_current X3 /\ auto___def_61 X4 /\ auto___type_12 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto___type_13 X1). 2:apply (rem_845 X1 X2 X3 X4);  assumption.
  cut (auto___type_10 X1). 2:apply (rem_929 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_930 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X3). 2:apply (rem_931 X1 X2 X3 X4);  assumption.
  cut (auto___def_61 X4). 2:apply (rem_933 X1 X2 X3 X4);  assumption.
  cut (auto___type_12 X4). 2:apply (rem_959 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_961 : forall X1 X2 X3 X4:term, auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_960 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_83_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_962 : forall X1 X2:term, auto___def_60 (cons X1 X2) -> or_1
    (auto___def_61 X1 /\ auto___def_62 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_963 : forall X1 X2 X3 X4:term, auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_962 X4 (cons X1 nil) H);  intros.
  apply (rem_961 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_964 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current X3 -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_963 X1 X2 X3 X4).
Qed.

Remark rem_965 : forall X1 X2 X3 X4:term, auto___def_59 (l X2 X3) -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_661 X2 X3 H);  intros.
  apply (rem_964 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_966 : forall X1 X2 X3 X4:term, auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_663 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_965 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_967 : forall X1 X2 X3 X4:term, auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_63 sym -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_966 X1 X2 X3 X4).
Qed.

Remark rem_968 : forall X1 X2 X3 X4:term, auto___def_63 sym -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_63 sym -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_967 X1 X2 X3 X4).
Qed.

Remark rem_969 : forall X1 X2 X3 X4:term, auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_667 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_968 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_970 : forall X1 X2 X3 X4:term, auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_57 t_current -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_969 X1 X2 X3 X4).
Qed.

Remark rem_971 : forall X1 X2 X3 X4:term, auto___def_57 t_current -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_57 t_current -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_970 X1 X2 X3 X4).
Qed.

Remark rem_972 : forall X1 X2 X3 X4:term, auto___def_55 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_671 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_971 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_973 : forall X1 X2 X3 X4:term, auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X1 -> auto___type_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X1 -> auto___type_13 X1). tauto. exact (rem_844 X1).
Qed.

Remark rem_974 : forall X1 X2 X3 X4:term, auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X1 -> auto___type_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X1 -> auto___type_10 X1). tauto. exact (rem_928 X1).
Qed.

Remark rem_975 : forall X1 X2 X3 X4:term, auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_652 X2).
Qed.

Remark rem_976 : forall X1 X2 X3 X4:term, auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X3 -> auto_knows_current X3). tauto. exact (rem_654 X3).
Qed.

Remark rem_977 : forall X1 X2 X3 X4:term, auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_61 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_61 X4 -> auto___def_61 X4). tauto. exact (rem_932 X4).
Qed.

Remark rem_978 : forall X1 X2 X3 X4:term, auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X1 -> auto___type_12 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_61 X4 -> auto___type_12 X4). tauto. exact (rem_958 X4).
Qed.

Remark rem_979 : forall X1 X2 X3 X4:term, auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X1 -> (auto___type_13 X1 /\ auto___type_10 X1 /\ auto_knows_current X2 /\ auto_knows_current X3 /\ auto___def_61 X4 /\ auto___type_12 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto___type_13 X1). 2:apply (rem_973 X1 X2 X3 X4);  assumption.
  cut (auto___type_10 X1). 2:apply (rem_974 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_975 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X3). 2:apply (rem_976 X1 X2 X3 X4);  assumption.
  cut (auto___def_61 X4). 2:apply (rem_977 X1 X2 X3 X4);  assumption.
  cut (auto___type_12 X4). 2:apply (rem_978 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_980 : forall X1 X2 X3 X4:term, auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_979 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_83_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_981 : forall X1 X2:term, auto___def_71 (cons X1 X2) -> or_1
    (auto___def_61 X1 /\ auto___def_72 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_982 : forall X1 X2 X3 X4:term, auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_981 X4 (cons X1 nil) H);  intros.
  apply (rem_980 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_983 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current X3 -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_982 X1 X2 X3 X4).
Qed.

Remark rem_984 : forall X1 X2 X3 X4:term, auto___def_59 (l X2 X3) -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_661 X2 X3 H);  intros.
  apply (rem_983 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_985 : forall X1 X2 X3 X4:term, auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_683 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_984 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_986 : forall X1 X2 X3 X4:term, auto___def_63 sym -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_985 X1 X2 X3 X4).
Qed.

Remark rem_987 : forall X1 X2 X3 X4:term, auto___def_63 sym -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_63 sym -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_986 X1 X2 X3 X4).
Qed.

Remark rem_988 : forall X1 X2 X3 X4:term, auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_687 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_987 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_989 : forall X1 X2 X3 X4:term, auto___def_57 t_current -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_988 X1 X2 X3 X4).
Qed.

Remark rem_990 : forall X1 X2 X3 X4:term, auto___def_57 t_current -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 t_current -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_989 X1 X2 X3 X4).
Qed.

Remark rem_991 : forall X1 X2 X3 X4:term, auto___def_68 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto_knows_current X4 -> auto_knows_current X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_691 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_990 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_992 : forall X1 X2 X3 X4:term, auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_693 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil))) H);  intros.
  apply (rem_703 X1 X2 X3 X4);  tauto.
  apply (rem_725 X1 X2 X3 X4);  tauto.
  apply (rem_726 X1 X2 X3 X4);  tauto.
  apply (rem_731 X1 X2 X3 X4);  tauto.
  apply (rem_748 X1 X2 X3 X4);  tauto.
  apply (rem_972 X1 X2 X3 X4);  tauto.
  apply (rem_991 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_993 : forall X1 X2 X3 X4:term, auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (cons t_current nil) -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_992 X1 X2 X3 X4).
Qed.

Remark rem_994 : forall X1 X2 X3 X4:term, auto_knows_current X1 -> auto_knows_current (cons t_current nil) -> auto_knows_current X4 -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current (cons t_current nil) -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_993 X1 X2 X3 X4).
Qed.

Remark rem_995 : forall X1 X2 X3 X4:term, auto_knows_current X4 -> auto_knows_current (cons X1 (cons t_current nil)) -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_124 X1 (cons t_current nil) H);  intros.
  apply (rem_994 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_996 : forall X1 X2 X3 X4:term, auto_knows_current (cons X1 (cons t_current nil)) -> auto_knows_current X4 -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current X4 -> auto_knows_current (cons X1 (cons t_current nil)) -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_995 X1 X2 X3 X4).
Qed.

Remark rem_997 : forall X1 X2 X3 X4:term, auto___def_84 (cons X1 (cons t_current nil)) -> auto___type_14 X4 -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_132 X1 (cons t_current nil) H);  intros.
Qed.

Remark rem_998 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_31 (cons X4 (cons X1 nil)) -> auto___def_82 (l X2 X3) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_39 X4 (cons X1 nil) H);  intros.
Qed.

Remark rem_999 : forall X1 X2 X3 X4:term, auto___def_82 (l X2 X3) -> auto___def_31 (cons X4 (cons X1 nil)) -> auto___def_12 X1 -> auto___def_24 X4 -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto___def_31 (cons X4 (cons X1 nil)) -> auto___def_82 (l X2 X3) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_998 X1 X2 X3 X4).
Qed.

Remark rem_1000 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_42 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_999 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1001 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___type_13 t_current -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1000 X1 X2 X3 X4).
Qed.

Remark rem_1002 : forall X1 X2 X3 X4:term, auto___type_13 t_current -> auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_12 X1 -> auto___def_24 X4 -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___type_13 t_current -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1001 X1 X2 X3 X4).
Qed.

Remark rem_1003 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_80 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_46 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_1002 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1004 : forall X1 X2 X3 X4:term, auto___def_80 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_12 X1 -> auto___def_24 X4 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto___def_80 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1003 X1 X2 X3 X4).
Qed.

Remark rem_1005 : (forall X:term, auto___def_18 X -> auto___def_42 X -> False)
    -> auto___def_42 sym -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_18_m__def_42. intro H. intros.
  elim (rem_49 H);  intros.
Defined.

Remark rem_1006 : (forall X:term, auto___def_18 X -> auto___def_42 X -> False)
    -> auto___def_18 sym -> auto___def_42 sym -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_18_m__def_42. intro H. intros.
  elim (rem_282 H);  intros.
  apply (rem_1005 epsilon_m__def_18_m__def_42);  tauto.
Defined.

Remark rem_1007 : forall X1:term, auto___def_18 X1 -> auto___def_42 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_18_m__def_42 1.
  intro X. case X.
   intro H. elim (rem_297  H).
   intro H. elim (rem_293  H).
  intros X1 X2. intro H. elim (rem_289 X1 X2 H).
  intros X1 X2. intro H. elim (rem_292 X1 X2 H).
   intro H. elim (rem_287  H).
  intros X1 X2. intro H. elim (rem_294 X1 X2 H).
  intros X1 X2. intro H. elim (rem_291 X1 X2 H).
   intro H. elim (rem_286  H).
   intro H. elim (rem_290  H).
   intro H. elim (rem_295  H).
  intros X1. intro H. elim (rem_285 X1 H).
   intro H. elim (rem_298  H).
  intros X1 X2. intro H. elim (rem_284 X1 X2 H).
  intros X1 X2. intro H. elim (rem_288 X1 X2 H).
  exact (rem_1006 epsilon_m__def_18_m__def_42 ).
   intro H. elim (rem_299  H).
   intro H. elim (rem_296  H).
Qed.

Remark rem_1008 : (forall X:term, auto___def_24 X -> auto_knows_current X -> False)
    -> forall X1:term, auto___def_18 X1 -> auto___def_42 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_24_mknows_current. exact (rem_1007).
Defined.

Remark rem_1009 : (forall X:term, auto___def_24 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_28 X2 -> auto___def_42 X1 -> auto___type_8 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_24_mknows_current. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_42 X1 -> False). clear  epsilon_m__def_24_mknows_current. tauto.
  exact (rem_1008 epsilon_m__def_24_mknows_current X1).
Defined.

Remark rem_1010 : (forall X:term, auto___def_28 X -> auto___def_47 X -> False)
    -> forall X1 X2:term, auto___def_47 (cons X1 X2) -> auto___type_2 X1 -> auto___def_29 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_28_m__def_47. intros X1 X2. intro H. intros.
  elim (rem_708 X1 X2 H);  intros.
Defined.

Remark rem_1011 : forall X1 X2:term, auto___def_28 (cons X1 X2) -> or_1
    (auto___type_2 X1 /\ auto___def_29 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1012 : (forall X:term, auto___def_28 X -> auto___def_47 X -> False)
    -> forall X1 X2:term, auto___def_28 (cons X1 X2) -> auto___def_47 (cons X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_28_m__def_47. intros X1 X2. intro H. intros.
  elim (rem_1011 X1 X2 H);  intros.
  apply (rem_1010 epsilon_m__def_28_m__def_47 X1 X2);  tauto.
Defined.

Remark rem_1013 : forall X1 X2:term, auto___def_28 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1014 : forall X1:term, auto___def_28 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1015 : auto___def_28 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1016 : auto___def_28 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1017 : forall X1 X2:term, auto___def_28 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1018 : auto___def_28 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1019 : auto___def_28 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1020 : forall X1 X2:term, auto___def_28 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1021 : forall X1 X2:term, auto___def_28 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1022 : auto___def_28 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1023 : forall X1 X2:term, auto___def_28 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1024 : auto___def_28 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1025 : auto___def_28 t_old -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1026 : auto___def_28 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1027 : auto___def_28 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1028 : auto___def_28 t_current -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1029 : forall X2:term, auto___def_28 X2 -> auto___def_47 X2 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_28_m__def_47 1.
  intro X. case X.
   intro H. elim (rem_1026  H).
   intro H. elim (rem_1022  H).
  intros X1 X2;  exact (rem_1012 epsilon_m__def_28_m__def_47 X1 X2).
  intros X1 X2. intro H. elim (rem_1021 X1 X2 H).
   intro H. elim (rem_1016  H).
  intros X1 X2. intro H. elim (rem_1023 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1020 X1 X2 H).
   intro H. elim (rem_1015  H).
   intro H. elim (rem_1019  H).
   intro H. elim (rem_1024  H).
  intros X1. intro H. elim (rem_1014 X1 H).
   intro H. elim (rem_1027  H).
  intros X1 X2. intro H. elim (rem_1013 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1017 X1 X2 H).
   intro H. elim (rem_1018  H).
   intro H. elim (rem_1028  H).
   intro H. elim (rem_1025  H).
Qed.

Remark rem_1030 : (forall X:term, auto___def_24 X -> auto_knows_current X -> False)
    -> forall X2:term, auto___def_28 X2 -> auto___def_47 X2 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_24_mknows_current. exact (rem_1029).
Defined.

Remark rem_1031 : (forall X:term, auto___def_24 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_47 X2 -> auto___def_46 X1 -> auto___def_28 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_24_mknows_current. intros X1 X2.
  cut (auto___def_28 X2 -> auto___def_47 X2 -> False). clear  epsilon_m__def_24_mknows_current. tauto.
  exact (rem_1030 epsilon_m__def_24_mknows_current X2).
Defined.

Remark rem_1032 : (forall X:term, auto___def_43 X -> auto___def_18 X -> False)
    -> auto___def_18 prv -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_43_m__def_18. intro H. intros.
  elim (rem_290 H);  intros.
Defined.

Remark rem_1033 : auto___def_43 prv -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1034 : (forall X:term, auto___def_43 X -> auto___def_18 X -> False)
    -> auto___def_43 prv -> auto___def_18 prv -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_43_m__def_18. intro H. intros.
  elim (rem_1033 H);  intros.
  apply (rem_1032 epsilon_m__def_43_m__def_18);  tauto.
Defined.

Remark rem_1035 : forall X1 X2:term, auto___def_43 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1036 : forall X1:term, auto___def_43 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1037 : auto___def_43 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1038 : auto___def_43 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1039 : forall X1 X2:term, auto___def_43 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1040 : forall X1 X2:term, auto___def_43 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1041 : forall X1 X2:term, auto___def_43 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1042 : forall X1 X2:term, auto___def_43 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1043 : auto___def_43 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1044 : forall X1 X2:term, auto___def_43 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1045 : auto___def_43 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1046 : auto___def_43 t_old -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1047 : auto___def_43 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1048 : auto___def_43 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1049 : auto___def_43 t_current -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1050 : forall X1:term, auto___def_43 X1 -> auto___def_18 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_43_m__def_18 1.
  intro X. case X.
   intro H. elim (rem_1047  H).
   intro H. elim (rem_1043  H).
  intros X1 X2. intro H. elim (rem_1040 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1042 X1 X2 H).
   intro H. elim (rem_1038  H).
  intros X1 X2. intro H. elim (rem_1044 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1041 X1 X2 H).
   intro H. elim (rem_1037  H).
  exact (rem_1034 epsilon_m__def_43_m__def_18 ).
   intro H. elim (rem_1045  H).
  intros X1. intro H. elim (rem_1036 X1 H).
   intro H. elim (rem_1048  H).
  intros X1 X2. intro H. elim (rem_1035 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1039 X1 X2 H).
   intro H. elim (rem_95  H).
   intro H. elim (rem_1049  H).
   intro H. elim (rem_1046  H).
Qed.

Remark rem_1051 : (forall X:term, auto___def_24 X -> auto_knows_current X -> False)
    -> forall X1:term, auto___def_43 X1 -> auto___def_18 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_24_mknows_current. exact (rem_1050).
Defined.

Remark rem_1052 : (forall X:term, auto___def_24 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_43 X1 -> auto___def_44 X2 -> auto___def_28 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_24_mknows_current. intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_18 X1 -> False). clear  epsilon_m__def_24_mknows_current. tauto.
  exact (rem_1051 epsilon_m__def_24_mknows_current X1).
Defined.

Remark rem_1053 : (forall X:term, auto___def_24 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto_knows_current (key X1 X2) -> auto___def_18 X1 -> auto___def_28 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_24_mknows_current. intros X1 X2. intro H. intros.
  elim (rem_101 X1 X2 H);  intros.
  apply (rem_1009 epsilon_m__def_24_mknows_current X1 X2);  tauto.
  apply (rem_1031 epsilon_m__def_24_mknows_current X1 X2);  tauto.
  apply (rem_1052 epsilon_m__def_24_mknows_current X1 X2);  tauto.
Defined.

Remark rem_1054 : (forall X:term, auto___def_24 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto___def_24 (key X1 X2) -> auto_knows_current (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_24_mknows_current. intros X1 X2. intro H. intros.
  elim (rem_624 X1 X2 H);  intros.
  apply (rem_1053 epsilon_m__def_24_mknows_current X1 X2);  tauto.
Defined.

Remark rem_1055 : forall X1 X2:term, auto___def_24 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1056 : forall X1:term, auto___def_24 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1057 : auto___def_24 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1058 : auto___def_24 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1059 : forall X1 X2:term, auto___def_24 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1060 : forall X1 X2:term, auto___def_24 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1061 : auto___def_24 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1062 : auto___def_24 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1063 : forall X1 X2:term, auto___def_24 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1064 : forall X1 X2:term, auto___def_24 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1065 : auto___def_24 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1066 : auto___def_24 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1067 : auto___def_24 t_old -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1068 : auto___def_24 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1069 : auto___def_24 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1070 : auto___def_24 t_current -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1071 : forall X1:term, auto___def_24 X1 -> auto_knows_current X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_24_mknows_current 1.
  intro X. case X.
   intro H. elim (rem_1068  H).
   intro H. elim (rem_1065  H).
  intros X1 X2. intro H. elim (rem_1060 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1064 X1 X2 H).
   intro H. elim (rem_1058  H).
  intros X1 X2;  exact (rem_1054 epsilon_m__def_24_mknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_1063 X1 X2 H).
   intro H. elim (rem_1057  H).
   intro H. elim (rem_1062  H).
   intro H. elim (rem_1066  H).
  intros X1. intro H. elim (rem_1056 X1 H).
   intro H. elim (rem_1069  H).
  intros X1 X2. intro H. elim (rem_1055 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1059 X1 X2 H).
   intro H. elim (rem_1061  H).
   intro H. elim (rem_1070  H).
   intro H. elim (rem_1067  H).
Qed.

Remark rem_1072 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto_knows_current X4 -> auto_knows_current (cons X1 nil) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_1071 X4)). tauto.
Qed.

Remark rem_1073 : forall X1 X2 X3 X4:term, auto_knows_current X4 -> auto_knows_current (cons X1 nil) -> auto___def_12 X1 -> auto___def_24 X4 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto_knows_current X4 -> auto_knows_current (cons X1 nil) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1072 X1 X2 X3 X4).
Qed.

Remark rem_1074 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_124 X4 (cons X1 nil) H);  intros.
  apply (rem_1073 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1075 : forall X1 X2 X3 X4:term, auto_knows_current (l X2 X3) -> auto_knows_current (cons X4 (cons X1 nil)) -> auto___def_12 X1 -> auto___def_24 X4 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1074 X1 X2 X3 X4).
Qed.

Remark rem_1076 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_124 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_1075 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1077 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current t_current -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1076 X1 X2 X3 X4).
Qed.

Remark rem_1078 : forall X1 X2 X3 X4:term, auto_knows_current t_current -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_12 X1 -> auto___def_24 X4 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current t_current -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1077 X1 X2 X3 X4).
Qed.

Remark rem_1079 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto_knows_current (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_124 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_1078 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1080 : forall X1 X2 X3 X4:term, auto_knows_current (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_12 X1 -> auto___def_24 X4 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto_knows_current (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1079 X1 X2 X3 X4).
Qed.

Remark rem_1081 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_84 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_14 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_132 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
Qed.

Remark rem_1082 : forall X1 X2 X3 X4:term, auto___def_84 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_14 (key sym (cons X3 (cons server nil))) -> auto___def_12 X1 -> auto___def_24 X4 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto___def_84 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_14 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1081 X1 X2 X3 X4).
Qed.

Remark rem_1083 : (forall X:term, auto___def_28 X -> auto___def_19 X -> False)
    -> forall X1 X2:term, auto___def_19 (cons X1 X2) -> auto___type_2 X1 -> auto___def_29 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_28_m__def_19. intros X1 X2. intro H. intros.
  elim (rem_311 X1 X2 H);  intros.
Defined.

Remark rem_1084 : (forall X:term, auto___def_28 X -> auto___def_19 X -> False)
    -> forall X1 X2:term, auto___def_28 (cons X1 X2) -> auto___def_19 (cons X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_28_m__def_19. intros X1 X2. intro H. intros.
  elim (rem_1011 X1 X2 H);  intros.
  apply (rem_1083 epsilon_m__def_28_m__def_19 X1 X2);  tauto.
Defined.

Remark rem_1085 : forall X2:term, auto___def_28 X2 -> auto___def_19 X2 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_28_m__def_19 1.
  intro X. case X.
   intro H. elim (rem_1026  H).
   intro H. elim (rem_1022  H).
  intros X1 X2;  exact (rem_1084 epsilon_m__def_28_m__def_19 X1 X2).
  intros X1 X2. intro H. elim (rem_1021 X1 X2 H).
   intro H. elim (rem_1016  H).
  intros X1 X2. intro H. elim (rem_1023 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1020 X1 X2 H).
   intro H. elim (rem_1015  H).
   intro H. elim (rem_1019  H).
   intro H. elim (rem_1024  H).
  intros X1. intro H. elim (rem_1014 X1 H).
   intro H. elim (rem_1027  H).
  intros X1 X2. intro H. elim (rem_1013 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1017 X1 X2 H).
   intro H. elim (rem_1018  H).
   intro H. elim (rem_1028  H).
   intro H. elim (rem_1025  H).
Qed.

Remark rem_1086 : (forall X:term, auto___def_24 X -> auto___def_16 X -> False)
    -> forall X2:term, auto___def_28 X2 -> auto___def_19 X2 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_24_m__def_16. exact (rem_1085).
Defined.

Remark rem_1087 : (forall X:term, auto___def_24 X -> auto___def_16 X -> False)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_28 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_24_m__def_16. intros X1 X2.
  cut (auto___def_28 X2 -> auto___def_19 X2 -> False). clear  epsilon_m__def_24_m__def_16. tauto.
  exact (rem_1086 epsilon_m__def_24_m__def_16 X2).
Defined.

Remark rem_1088 : forall X1 X2:term, auto___def_16 (key X1 X2) -> or_1
    (auto___def_18 X1 /\ auto___def_19 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1089 : (forall X:term, auto___def_24 X -> auto___def_16 X -> False)
    -> forall X1 X2:term, auto___def_16 (key X1 X2) -> auto___def_18 X1 -> auto___def_28 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_24_m__def_16. intros X1 X2. intro H. intros.
  elim (rem_1088 X1 X2 H);  intros.
  apply (rem_1087 epsilon_m__def_24_m__def_16 X1 X2);  tauto.
Defined.

Remark rem_1090 : (forall X:term, auto___def_24 X -> auto___def_16 X -> False)
    -> forall X1 X2:term, auto___def_24 (key X1 X2) -> auto___def_16 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_24_m__def_16. intros X1 X2. intro H. intros.
  elim (rem_624 X1 X2 H);  intros.
  apply (rem_1089 epsilon_m__def_24_m__def_16 X1 X2);  tauto.
Defined.

Remark rem_1091 : forall X1:term, auto___def_24 X1 -> auto___def_16 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_24_m__def_16 1.
  intro X. case X.
   intro H. elim (rem_1068  H).
   intro H. elim (rem_1065  H).
  intros X1 X2. intro H. elim (rem_1060 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1064 X1 X2 H).
   intro H. elim (rem_1058  H).
  intros X1 X2;  exact (rem_1090 epsilon_m__def_24_m__def_16 X1 X2).
  intros X1 X2. intro H. elim (rem_1063 X1 X2 H).
   intro H. elim (rem_1057  H).
   intro H. elim (rem_1062  H).
   intro H. elim (rem_1066  H).
  intros X1. intro H. elim (rem_1056 X1 H).
   intro H. elim (rem_1069  H).
  intros X1 X2. intro H. elim (rem_1055 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1059 X1 X2 H).
   intro H. elim (rem_1061  H).
   intro H. elim (rem_1070  H).
   intro H. elim (rem_1067  H).
Qed.

Remark rem_1092 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_16 X4 -> auto___def_24 X4 -> auto___def_27 (cons X1 nil) -> auto___def_28 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_1091 X4)). tauto.
Qed.

Remark rem_1093 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_27 (cons X1 nil) -> auto___def_12 X1 -> auto___def_24 X4 -> auto___def_28 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_16 X4 -> auto___def_24 X4 -> auto___def_27 (cons X1 nil) -> auto___def_28 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1092 X1 X2 X3 X4).
Qed.

Remark rem_1094 : forall X1 X2:term, auto___def_26 (cons X1 X2) -> or_1
    (auto___def_16 X1 /\ auto___def_27 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1095 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_1094 X4 (cons X1 nil) H);  intros.
  apply (rem_1093 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1096 : forall X1 X2 X3 X4:term, auto_knows_old X2 -> auto_knows_old X3 -> auto___def_12 X1 -> auto___def_24 X4 -> auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1095 X1 X2 X3 X4).
Qed.

Remark rem_1097 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_14 (l X2 X3) -> auto___def_24 X4 -> auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_618 X2 X3 H);  intros.
  apply (rem_1096 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1098 : forall X1 X2 X3 X4:term, auto___def_14 (l X2 X3) -> auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_12 X1 -> auto___def_24 X4 -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_14 (l X2 X3) -> auto___def_24 X4 -> auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1097 X1 X2 X3 X4).
Qed.

Remark rem_1099 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_620 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_1098 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1100 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_18 sym -> auto___def_24 X4 -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1099 X1 X2 X3 X4).
Qed.

Remark rem_1101 : forall X1 X2 X3 X4:term, auto___def_18 sym -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_12 X1 -> auto___def_24 X4 -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_18 sym -> auto___def_24 X4 -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1100 X1 X2 X3 X4).
Qed.

Remark rem_1102 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_624 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1101 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1103 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_12 t_current -> auto___def_24 X4 -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1102 X1 X2 X3 X4).
Qed.

Remark rem_1104 : forall X1 X2 X3 X4:term, auto___def_12 t_current -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_12 X1 -> auto___def_24 X4 -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_12 t_current -> auto___def_24 X4 -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1103 X1 X2 X3 X4).
Qed.

Remark rem_1105 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_23 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_24 X4 -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_628 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_1104 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1106 : forall X1 X2 X3 X4:term, auto___def_23 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_12 X1 -> auto___def_24 X4 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_23 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_24 X4 -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1105 X1 X2 X3 X4).
Qed.

Remark rem_1107 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_16 X4 -> auto___def_17 (cons X1 nil) -> auto___def_24 X4 -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_1091 X4)). tauto.
Qed.

Remark rem_1108 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_17 (cons X1 nil) -> auto___def_12 X1 -> auto___def_24 X4 -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_16 X4 -> auto___def_17 (cons X1 nil) -> auto___def_24 X4 -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1107 X1 X2 X3 X4).
Qed.

Remark rem_1109 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_24 X4 -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_738 X4 (cons X1 nil) H);  intros.
  apply (rem_1108 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1110 : forall X1 X2 X3 X4:term, auto_knows_old X2 -> auto_knows_old X3 -> auto___def_12 X1 -> auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_24 X4 -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_24 X4 -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1109 X1 X2 X3 X4).
Qed.

Remark rem_1111 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_14 (l X2 X3) -> auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_24 X4 -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_618 X2 X3 H);  intros.
  apply (rem_1110 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1112 : forall X1 X2 X3 X4:term, auto___def_14 (l X2 X3) -> auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_12 X1 -> auto___def_24 X4 -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_14 (l X2 X3) -> auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_24 X4 -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1111 X1 X2 X3 X4).
Qed.

Remark rem_1113 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_24 X4 -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_640 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_1112 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1114 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_18 sym -> auto___def_24 X4 -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_24 X4 -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1113 X1 X2 X3 X4).
Qed.

Remark rem_1115 : forall X1 X2 X3 X4:term, auto___def_18 sym -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_12 X1 -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_24 X4 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_18 sym -> auto___def_24 X4 -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1114 X1 X2 X3 X4).
Qed.

Remark rem_1116 : forall X1 X2 X3 X4:term, auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_12 X1 -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_24 X4 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_644 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1115 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1117 : forall X1 X2 X3 X4:term, auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_12 X1 -> auto___def_12 t_current -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_24 X4 -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_12 X1 -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_24 X4 -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1116 X1 X2 X3 X4).
Qed.

Remark rem_1118 : forall X1 X2 X3 X4:term, auto___def_12 t_current -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_12 X1 -> auto___def_24 X4 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_12 X1 -> auto___def_12 t_current -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_24 X4 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1117 X1 X2 X3 X4).
Qed.

Remark rem_1119 : forall X1 X2 X3 X4:term, auto___def_10 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_12 X1 -> auto___def_24 X4 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_648 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_1118 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1120 : (forall X:term, auto___def_12 X -> auto___type_13 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_12_p__type_13.  tauto.
Defined.

Remark rem_1121 : (forall X:term, auto___def_12 X -> auto___type_13 X)
    -> auto___type_13 t_old. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_12_p__type_13.  case (rem_1120 epsilon_m__def_12_p__type_13). clear  epsilon_m__def_12_p__type_13. intros. apply trans___type_13_t_old_1;  tauto.
 clear  epsilon_m__def_12_p__type_13. tauto.
Defined.

Remark rem_1122 : auto___def_12 t_old -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1123 : (forall X:term, auto___def_12 X -> auto___type_13 X)
    -> auto___def_12 t_old -> auto___type_13 t_old. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_12_p__type_13. intro H. intros.
  elim (rem_1122 H);  intros.
  apply (rem_1121 epsilon_m__def_12_p__type_13);  tauto.
Defined.

Remark rem_1124 : forall X1 X2:term, auto___def_12 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1125 : forall X1:term, auto___def_12 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1126 : auto___def_12 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1127 : auto___def_12 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1128 : forall X1 X2:term, auto___def_12 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1129 : forall X1 X2:term, auto___def_12 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1130 : auto___def_12 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1131 : auto___def_12 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1132 : forall X1 X2:term, auto___def_12 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1133 : forall X1 X2:term, auto___def_12 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1134 : auto___def_12 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1135 : forall X1 X2:term, auto___def_12 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1136 : auto___def_12 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1137 : auto___def_12 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1138 : auto___def_12 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1139 : forall X1:term, auto___def_12 X1 -> auto___type_13 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_12_p__type_13 1.
  intro X. case X.
   intro H. elim (rem_1137  H).
   intro H. elim (rem_1134  H).
  intros X1 X2. intro H. elim (rem_1129 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1133 X1 X2 H).
   intro H. elim (rem_1127  H).
  intros X1 X2. intro H. elim (rem_1135 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1132 X1 X2 H).
   intro H. elim (rem_1126  H).
   intro H. elim (rem_1131  H).
   intro H. elim (rem_1136  H).
  intros X1. intro H. elim (rem_1125 X1 H).
   intro H. elim (rem_1138  H).
  intros X1 X2. intro H. elim (rem_1124 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1128 X1 X2 H).
   intro H. elim (rem_1130  H).
   intro H. elim (rem_727  H).
  exact (rem_1123 epsilon_m__def_12_p__type_13 ).
Qed.

Remark rem_1140 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___type_13 X1). tauto. exact (rem_1139 X1).
Qed.

Remark rem_1141 : (forall X:term, auto___def_12 X -> auto___type_10 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_12_p__type_10.  tauto.
Defined.

Remark rem_1142 : (forall X:term, auto___def_12 X -> auto___type_10 X)
    -> auto___type_10 t_old. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_12_p__type_10.  case (rem_1141 epsilon_m__def_12_p__type_10). clear  epsilon_m__def_12_p__type_10. intros. apply trans___type_10_t_old_1;  tauto.
 clear  epsilon_m__def_12_p__type_10. tauto.
Defined.

Remark rem_1143 : (forall X:term, auto___def_12 X -> auto___type_10 X)
    -> auto___def_12 t_old -> auto___type_10 t_old. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_12_p__type_10. intro H. intros.
  elim (rem_1122 H);  intros.
  apply (rem_1142 epsilon_m__def_12_p__type_10);  tauto.
Defined.

Remark rem_1144 : forall X1:term, auto___def_12 X1 -> auto___type_10 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_12_p__type_10 1.
  intro X. case X.
   intro H. elim (rem_1137  H).
   intro H. elim (rem_1134  H).
  intros X1 X2. intro H. elim (rem_1129 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1133 X1 X2 H).
   intro H. elim (rem_1127  H).
  intros X1 X2. intro H. elim (rem_1135 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1132 X1 X2 H).
   intro H. elim (rem_1126  H).
   intro H. elim (rem_1131  H).
   intro H. elim (rem_1136  H).
  intros X1. intro H. elim (rem_1125 X1 H).
   intro H. elim (rem_1138  H).
  intros X1 X2. intro H. elim (rem_1124 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1128 X1 X2 H).
   intro H. elim (rem_1130  H).
   intro H. elim (rem_727  H).
  exact (rem_1143 epsilon_m__def_12_p__type_10 ).
Qed.

Remark rem_1145 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___type_10 X1). tauto. exact (rem_1144 X1).
Qed.

Remark rem_1146 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_652 X2).
Qed.

Remark rem_1147 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X3 -> auto_knows_current X3). tauto. exact (rem_654 X3).
Qed.

Remark rem_1148 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_61 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_61 X4 -> auto___def_61 X4). tauto. exact (rem_932 X4).
Qed.

Remark rem_1149 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_12 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_61 X4 -> auto___type_12 X4). tauto. exact (rem_958 X4).
Qed.

Remark rem_1150 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> (auto___type_13 X1 /\ auto___type_10 X1 /\ auto_knows_current X2 /\ auto_knows_current X3 /\ auto___def_61 X4 /\ auto___type_12 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto___type_13 X1). 2:apply (rem_1140 X1 X2 X3 X4);  assumption.
  cut (auto___type_10 X1). 2:apply (rem_1145 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1146 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X3). 2:apply (rem_1147 X1 X2 X3 X4);  assumption.
  cut (auto___def_61 X4). 2:apply (rem_1148 X1 X2 X3 X4);  assumption.
  cut (auto___type_12 X4). 2:apply (rem_1149 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_1151 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_1150 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_83_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_1152 : forall X1 X2 X3 X4:term, auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_12 X1 -> auto___def_24 X4 -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1151 X1 X2 X3 X4).
Qed.

Remark rem_1153 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_962 X4 (cons X1 nil) H);  intros.
  apply (rem_1152 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1154 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current X3 -> auto___def_12 X1 -> auto___def_24 X4 -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1153 X1 X2 X3 X4).
Qed.

Remark rem_1155 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_59 (l X2 X3) -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_661 X2 X3 H);  intros.
  apply (rem_1154 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1156 : forall X1 X2 X3 X4:term, auto___def_59 (l X2 X3) -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_12 X1 -> auto___def_24 X4 -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto___def_59 (l X2 X3) -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1155 X1 X2 X3 X4).
Qed.

Remark rem_1157 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_663 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_1156 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1158 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_63 sym -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1157 X1 X2 X3 X4).
Qed.

Remark rem_1159 : forall X1 X2 X3 X4:term, auto___def_63 sym -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_12 X1 -> auto___def_24 X4 -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_63 sym -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1158 X1 X2 X3 X4).
Qed.

Remark rem_1160 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_667 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1159 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1161 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_57 t_current -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1160 X1 X2 X3 X4).
Qed.

Remark rem_1162 : forall X1 X2 X3 X4:term, auto___def_57 t_current -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_12 X1 -> auto___def_24 X4 -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_57 t_current -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1161 X1 X2 X3 X4).
Qed.

Remark rem_1163 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_55 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_671 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_1162 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1164 : forall X1 X2 X3 X4:term, auto___def_55 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_12 X1 -> auto___def_24 X4 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto___def_55 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1163 X1 X2 X3 X4).
Qed.

Remark rem_1165 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___type_13 X1). tauto. exact (rem_1139 X1).
Qed.

Remark rem_1166 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___type_10 X1). tauto. exact (rem_1144 X1).
Qed.

Remark rem_1167 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_652 X2).
Qed.

Remark rem_1168 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X3 -> auto_knows_current X3). tauto. exact (rem_654 X3).
Qed.

Remark rem_1169 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_61 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_61 X4 -> auto___def_61 X4). tauto. exact (rem_932 X4).
Qed.

Remark rem_1170 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_12 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_61 X4 -> auto___type_12 X4). tauto. exact (rem_958 X4).
Qed.

Remark rem_1171 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> (auto___type_13 X1 /\ auto___type_10 X1 /\ auto_knows_current X2 /\ auto_knows_current X3 /\ auto___def_61 X4 /\ auto___type_12 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto___type_13 X1). 2:apply (rem_1165 X1 X2 X3 X4);  assumption.
  cut (auto___type_10 X1). 2:apply (rem_1166 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1167 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X3). 2:apply (rem_1168 X1 X2 X3 X4);  assumption.
  cut (auto___def_61 X4). 2:apply (rem_1169 X1 X2 X3 X4);  assumption.
  cut (auto___type_12 X4). 2:apply (rem_1170 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_1172 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_1171 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_83_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_1173 : forall X1 X2 X3 X4:term, auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_12 X1 -> auto___def_24 X4 -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1172 X1 X2 X3 X4).
Qed.

Remark rem_1174 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_981 X4 (cons X1 nil) H);  intros.
  apply (rem_1173 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1175 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current X3 -> auto___def_12 X1 -> auto___def_24 X4 -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1174 X1 X2 X3 X4).
Qed.

Remark rem_1176 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_59 (l X2 X3) -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_661 X2 X3 H);  intros.
  apply (rem_1175 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1177 : forall X1 X2 X3 X4:term, auto___def_59 (l X2 X3) -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_12 X1 -> auto___def_24 X4 -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto___def_59 (l X2 X3) -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1176 X1 X2 X3 X4).
Qed.

Remark rem_1178 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_683 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_1177 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1179 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_63 sym -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1178 X1 X2 X3 X4).
Qed.

Remark rem_1180 : forall X1 X2 X3 X4:term, auto___def_63 sym -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_12 X1 -> auto___def_24 X4 -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto___def_63 sym -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1179 X1 X2 X3 X4).
Qed.

Remark rem_1181 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_687 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1180 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1182 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_57 t_current -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1181 X1 X2 X3 X4).
Qed.

Remark rem_1183 : forall X1 X2 X3 X4:term, auto___def_57 t_current -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_12 X1 -> auto___def_24 X4 -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto___def_57 t_current -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1182 X1 X2 X3 X4).
Qed.

Remark rem_1184 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_68 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_691 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_1183 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1185 : forall X1 X2 X3 X4:term, auto___def_68 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_12 X1 -> auto___def_24 X4 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto___def_68 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1184 X1 X2 X3 X4).
Qed.

Remark rem_1186 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_693 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil))) H);  intros.
  apply (rem_1004 X1 X2 X3 X4);  tauto.
  apply (rem_1080 X1 X2 X3 X4);  tauto.
  apply (rem_1082 X1 X2 X3 X4);  tauto.
  apply (rem_1106 X1 X2 X3 X4);  tauto.
  apply (rem_1119 X1 X2 X3 X4);  tauto.
  apply (rem_1164 X1 X2 X3 X4);  tauto.
  apply (rem_1185 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1187 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_24 X4 -> auto___def_25 (cons t_current nil) -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1186 X1 X2 X3 X4).
Qed.

Remark rem_1188 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_25 (cons t_current nil) -> auto___def_24 X4 -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___def_24 X4 -> auto___def_25 (cons t_current nil) -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1187 X1 X2 X3 X4).
Qed.

Remark rem_1189 : forall X1 X2 X3 X4:term, auto___def_23 (cons X1 (cons t_current nil)) -> auto___def_24 X4 -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_628 X1 (cons t_current nil) H);  intros.
  apply (rem_1188 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1190 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_31 (cons X4 (cons X1 nil)) -> auto___def_82 (l X2 X3) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_39 X4 (cons X1 nil) H);  intros.
Qed.

Remark rem_1191 : forall X1 X2 X3 X4:term, auto___def_82 (l X2 X3) -> auto___def_31 (cons X4 (cons X1 nil)) -> auto___def_11 X4 -> auto___def_12 X1 -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_31 (cons X4 (cons X1 nil)) -> auto___def_82 (l X2 X3) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1190 X1 X2 X3 X4).
Qed.

Remark rem_1192 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_42 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_1191 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1193 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___type_13 t_current -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1192 X1 X2 X3 X4).
Qed.

Remark rem_1194 : forall X1 X2 X3 X4:term, auto___type_13 t_current -> auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_11 X4 -> auto___def_12 X1 -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___type_13 t_current -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1193 X1 X2 X3 X4).
Qed.

Remark rem_1195 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_80 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_46 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_1194 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1196 : forall X1 X2 X3 X4:term, auto___def_80 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_11 X4 -> auto___def_12 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_80 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1195 X1 X2 X3 X4).
Qed.

Remark rem_1197 : (forall X:term, auto___def_11 X -> auto_knows_current X -> False)
    -> forall X1:term, auto___def_18 X1 -> auto___def_42 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_11_mknows_current. exact (rem_1007).
Defined.

Remark rem_1198 : (forall X:term, auto___def_11 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto___def_32 X2 -> auto___def_18 X1 -> auto___def_42 X1 -> auto___type_8 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_11_mknows_current. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_42 X1 -> False). clear  epsilon_m__def_11_mknows_current. tauto.
  exact (rem_1197 epsilon_m__def_11_mknows_current X1).
Defined.

Remark rem_1199 : forall X1 X2:term, auto___def_32 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1200 : (forall X:term, auto___def_47 X -> auto___def_32 X -> False)
    -> forall X1 X2:term, auto___def_32 (session_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_47_m__def_32. intros X1 X2. intro H. intros.
  elim (rem_1199 X1 X2 H);  intros.
Defined.

Remark rem_1201 : forall X1 X2:term, auto___def_47 (session_old X1 X2) -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1202 : (forall X:term, auto___def_47 X -> auto___def_32 X -> False)
    -> forall X1 X2:term, auto___def_47 (session_old X1 X2) -> auto___def_32 (session_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_47_m__def_32. intros X1 X2. intro H. intros.
  elim (rem_1201 X1 X2 H);  intros.
  apply (rem_1200 epsilon_m__def_47_m__def_32 X1 X2);  tauto.
Defined.

Remark rem_1203 : forall X1:term, auto___def_47 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1204 : auto___def_47 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1205 : auto___def_47 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1206 : auto___def_47 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1207 : auto___def_47 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1208 : forall X1 X2:term, auto___def_47 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1209 : forall X1 X2:term, auto___def_47 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1210 : auto___def_47 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1211 : forall X1 X2:term, auto___def_47 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1212 : auto___def_47 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1213 : auto___def_47 t_old -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1214 : auto___def_47 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1215 : auto___def_47 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1216 : auto___def_47 t_current -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1217 : forall X2:term, auto___def_47 X2 -> auto___def_32 X2 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_47_m__def_32 1.
  intro X. case X.
   intro H. elim (rem_1214  H).
   intro H. elim (rem_1210  H).
  intros X1 X2. intro H. elim (rem_708 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1209 X1 X2 H).
   intro H. elim (rem_1205  H).
  intros X1 X2. intro H. elim (rem_1211 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1208 X1 X2 H).
   intro H. elim (rem_1204  H).
   intro H. elim (rem_1207  H).
   intro H. elim (rem_1212  H).
  intros X1. intro H. elim (rem_1203 X1 H).
   intro H. elim (rem_1215  H).
  intros X1 X2. intro H. elim (rem_72 X1 X2 H).
  intros X1 X2;  exact (rem_1202 epsilon_m__def_47_m__def_32 X1 X2).
   intro H. elim (rem_1206  H).
   intro H. elim (rem_1216  H).
   intro H. elim (rem_1213  H).
Qed.

Remark rem_1218 : (forall X:term, auto___def_11 X -> auto_knows_current X -> False)
    -> forall X2:term, auto___def_47 X2 -> auto___def_32 X2 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_11_mknows_current. exact (rem_1217).
Defined.

Remark rem_1219 : (forall X:term, auto___def_11 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto___def_32 X2 -> auto___def_18 X1 -> auto___def_47 X2 -> auto___def_46 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_11_mknows_current. intros X1 X2.
  cut (auto___def_47 X2 -> auto___def_32 X2 -> False). clear  epsilon_m__def_11_mknows_current. tauto.
  exact (rem_1218 epsilon_m__def_11_mknows_current X2).
Defined.

Remark rem_1220 : (forall X:term, auto___def_11 X -> auto_knows_current X -> False)
    -> forall X1:term, auto___def_43 X1 -> auto___def_18 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_11_mknows_current. exact (rem_1050).
Defined.

Remark rem_1221 : (forall X:term, auto___def_11 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto___def_32 X2 -> auto___def_18 X1 -> auto___def_43 X1 -> auto___def_44 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_11_mknows_current. intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_18 X1 -> False). clear  epsilon_m__def_11_mknows_current. tauto.
  exact (rem_1220 epsilon_m__def_11_mknows_current X1).
Defined.

Remark rem_1222 : (forall X:term, auto___def_11 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto_knows_current (key X1 X2) -> auto___def_18 X1 -> auto___def_32 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_11_mknows_current. intros X1 X2. intro H. intros.
  elim (rem_101 X1 X2 H);  intros.
  apply (rem_1198 epsilon_m__def_11_mknows_current X1 X2);  tauto.
  apply (rem_1219 epsilon_m__def_11_mknows_current X1 X2);  tauto.
  apply (rem_1221 epsilon_m__def_11_mknows_current X1 X2);  tauto.
Defined.

Remark rem_1223 : (forall X:term, auto___def_11 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto___def_11 (key X1 X2) -> auto_knows_current (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_11_mknows_current. intros X1 X2. intro H. intros.
  elim (rem_644 X1 X2 H);  intros.
  apply (rem_1222 epsilon_m__def_11_mknows_current X1 X2);  tauto.
Defined.

Remark rem_1224 : forall X1 X2:term, auto___def_11 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1225 : forall X1:term, auto___def_11 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1226 : auto___def_11 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1227 : auto___def_11 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1228 : forall X1 X2:term, auto___def_11 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1229 : forall X1 X2:term, auto___def_11 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1230 : auto___def_11 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1231 : auto___def_11 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1232 : forall X1 X2:term, auto___def_11 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1233 : forall X1 X2:term, auto___def_11 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1234 : auto___def_11 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1235 : auto___def_11 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1236 : auto___def_11 t_old -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1237 : auto___def_11 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1238 : auto___def_11 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1239 : auto___def_11 t_current -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1240 : forall X1:term, auto___def_11 X1 -> auto_knows_current X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_11_mknows_current 1.
  intro X. case X.
   intro H. elim (rem_1237  H).
   intro H. elim (rem_1234  H).
  intros X1 X2. intro H. elim (rem_1229 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1233 X1 X2 H).
   intro H. elim (rem_1227  H).
  intros X1 X2;  exact (rem_1223 epsilon_m__def_11_mknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_1232 X1 X2 H).
   intro H. elim (rem_1226  H).
   intro H. elim (rem_1231  H).
   intro H. elim (rem_1235  H).
  intros X1. intro H. elim (rem_1225 X1 H).
   intro H. elim (rem_1238  H).
  intros X1 X2. intro H. elim (rem_1224 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1228 X1 X2 H).
   intro H. elim (rem_1230  H).
   intro H. elim (rem_1239  H).
   intro H. elim (rem_1236  H).
Qed.

Remark rem_1241 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto_knows_current X4 -> auto_knows_current (cons X1 nil) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_1240 X4)). tauto.
Qed.

Remark rem_1242 : forall X1 X2 X3 X4:term, auto_knows_current X4 -> auto_knows_current (cons X1 nil) -> auto___def_11 X4 -> auto___def_12 X1 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto_knows_current X4 -> auto_knows_current (cons X1 nil) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1241 X1 X2 X3 X4).
Qed.

Remark rem_1243 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_124 X4 (cons X1 nil) H);  intros.
  apply (rem_1242 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1244 : forall X1 X2 X3 X4:term, auto_knows_current (l X2 X3) -> auto_knows_current (cons X4 (cons X1 nil)) -> auto___def_11 X4 -> auto___def_12 X1 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1243 X1 X2 X3 X4).
Qed.

Remark rem_1245 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_124 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_1244 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1246 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current t_current -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1245 X1 X2 X3 X4).
Qed.

Remark rem_1247 : forall X1 X2 X3 X4:term, auto_knows_current t_current -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_11 X4 -> auto___def_12 X1 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current t_current -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1246 X1 X2 X3 X4).
Qed.

Remark rem_1248 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto_knows_current (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_124 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_1247 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1249 : forall X1 X2 X3 X4:term, auto_knows_current (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_11 X4 -> auto___def_12 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto_knows_current (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1248 X1 X2 X3 X4).
Qed.

Remark rem_1250 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_84 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_14 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_132 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
Qed.

Remark rem_1251 : forall X1 X2 X3 X4:term, auto___def_84 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_14 (key sym (cons X3 (cons server nil))) -> auto___def_11 X4 -> auto___def_12 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_84 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_14 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1250 X1 X2 X3 X4).
Qed.

Remark rem_1252 : (forall X:term, auto___def_19 X -> auto___def_32 X -> False)
    -> forall X1 X2:term, auto___def_32 (session_old X1 X2) -> auto_knows_old X1 -> auto_knows_old X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_19_m__def_32. intros X1 X2. intro H. intros.
  elim (rem_1199 X1 X2 H);  intros.
Defined.

Remark rem_1253 : (forall X:term, auto___def_19 X -> auto___def_32 X -> False)
    -> forall X1 X2:term, auto___def_19 (session_old X1 X2) -> auto___def_32 (session_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_19_m__def_32. intros X1 X2. intro H. intros.
  elim (rem_305 X1 X2 H);  intros.
  apply (rem_1252 epsilon_m__def_19_m__def_32 X1 X2);  tauto.
Defined.

Remark rem_1254 : forall X2:term, auto___def_19 X2 -> auto___def_32 X2 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_19_m__def_32 1.
  intro X. case X.
   intro H. elim (rem_320  H).
   intro H. elim (rem_316  H).
  intros X1 X2. intro H. elim (rem_311 X1 X2 H).
  intros X1 X2. intro H. elim (rem_315 X1 X2 H).
   intro H. elim (rem_310  H).
  intros X1 X2. intro H. elim (rem_317 X1 X2 H).
  intros X1 X2. intro H. elim (rem_314 X1 X2 H).
   intro H. elim (rem_309  H).
   intro H. elim (rem_313  H).
   intro H. elim (rem_318  H).
  intros X1. intro H. elim (rem_308 X1 H).
   intro H. elim (rem_321  H).
  intros X1 X2. intro H. elim (rem_307 X1 X2 H).
  intros X1 X2;  exact (rem_1253 epsilon_m__def_19_m__def_32 X1 X2).
   intro H. elim (rem_312  H).
   intro H. elim (rem_322  H).
   intro H. elim (rem_319  H).
Qed.

Remark rem_1255 : (forall X:term, auto___def_11 X -> auto___def_16 X -> False)
    -> forall X2:term, auto___def_19 X2 -> auto___def_32 X2 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_11_m__def_16. exact (rem_1254).
Defined.

Remark rem_1256 : (forall X:term, auto___def_11 X -> auto___def_16 X -> False)
    -> forall X1 X2:term, auto___def_32 X2 -> auto___def_18 X1 -> auto___def_19 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_11_m__def_16. intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_32 X2 -> False). clear  epsilon_m__def_11_m__def_16. tauto.
  exact (rem_1255 epsilon_m__def_11_m__def_16 X2).
Defined.

Remark rem_1257 : (forall X:term, auto___def_11 X -> auto___def_16 X -> False)
    -> forall X1 X2:term, auto___def_16 (key X1 X2) -> auto___def_18 X1 -> auto___def_32 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_11_m__def_16. intros X1 X2. intro H. intros.
  elim (rem_1088 X1 X2 H);  intros.
  apply (rem_1256 epsilon_m__def_11_m__def_16 X1 X2);  tauto.
Defined.

Remark rem_1258 : (forall X:term, auto___def_11 X -> auto___def_16 X -> False)
    -> forall X1 X2:term, auto___def_11 (key X1 X2) -> auto___def_16 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_11_m__def_16. intros X1 X2. intro H. intros.
  elim (rem_644 X1 X2 H);  intros.
  apply (rem_1257 epsilon_m__def_11_m__def_16 X1 X2);  tauto.
Defined.

Remark rem_1259 : forall X1:term, auto___def_11 X1 -> auto___def_16 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_11_m__def_16 1.
  intro X. case X.
   intro H. elim (rem_1237  H).
   intro H. elim (rem_1234  H).
  intros X1 X2. intro H. elim (rem_1229 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1233 X1 X2 H).
   intro H. elim (rem_1227  H).
  intros X1 X2;  exact (rem_1258 epsilon_m__def_11_m__def_16 X1 X2).
  intros X1 X2. intro H. elim (rem_1232 X1 X2 H).
   intro H. elim (rem_1226  H).
   intro H. elim (rem_1231  H).
   intro H. elim (rem_1235  H).
  intros X1. intro H. elim (rem_1225 X1 H).
   intro H. elim (rem_1238  H).
  intros X1 X2. intro H. elim (rem_1224 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1228 X1 X2 H).
   intro H. elim (rem_1230  H).
   intro H. elim (rem_1239  H).
   intro H. elim (rem_1236  H).
Qed.

Remark rem_1260 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_16 X4 -> auto___def_27 (cons X1 nil) -> auto___def_28 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_1259 X4)). tauto.
Qed.

Remark rem_1261 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_27 (cons X1 nil) -> auto___def_11 X4 -> auto___def_12 X1 -> auto___def_28 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_16 X4 -> auto___def_27 (cons X1 nil) -> auto___def_28 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1260 X1 X2 X3 X4).
Qed.

Remark rem_1262 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_1094 X4 (cons X1 nil) H);  intros.
  apply (rem_1261 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1263 : forall X1 X2 X3 X4:term, auto_knows_old X2 -> auto_knows_old X3 -> auto___def_11 X4 -> auto___def_12 X1 -> auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1262 X1 X2 X3 X4).
Qed.

Remark rem_1264 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_14 (l X2 X3) -> auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_618 X2 X3 H);  intros.
  apply (rem_1263 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1265 : forall X1 X2 X3 X4:term, auto___def_14 (l X2 X3) -> auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_11 X4 -> auto___def_12 X1 -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_14 (l X2 X3) -> auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1264 X1 X2 X3 X4).
Qed.

Remark rem_1266 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_620 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_1265 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1267 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_18 sym -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1266 X1 X2 X3 X4).
Qed.

Remark rem_1268 : forall X1 X2 X3 X4:term, auto___def_18 sym -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_11 X4 -> auto___def_12 X1 -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_18 sym -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1267 X1 X2 X3 X4).
Qed.

Remark rem_1269 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_624 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1268 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1270 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_12 t_current -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1269 X1 X2 X3 X4).
Qed.

Remark rem_1271 : forall X1 X2 X3 X4:term, auto___def_12 t_current -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_11 X4 -> auto___def_12 X1 -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_12 t_current -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1270 X1 X2 X3 X4).
Qed.

Remark rem_1272 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_23 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_628 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_1271 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1273 : forall X1 X2 X3 X4:term, auto___def_23 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_11 X4 -> auto___def_12 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_23 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1272 X1 X2 X3 X4).
Qed.

Remark rem_1274 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_16 X4 -> auto___def_17 (cons X1 nil) -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_1259 X4)). tauto.
Qed.

Remark rem_1275 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_17 (cons X1 nil) -> auto___def_11 X4 -> auto___def_12 X1 -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_16 X4 -> auto___def_17 (cons X1 nil) -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1274 X1 X2 X3 X4).
Qed.

Remark rem_1276 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_738 X4 (cons X1 nil) H);  intros.
  apply (rem_1275 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1277 : forall X1 X2 X3 X4:term, auto_knows_old X2 -> auto_knows_old X3 -> auto___def_11 X4 -> auto___def_12 X1 -> auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1276 X1 X2 X3 X4).
Qed.

Remark rem_1278 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_14 (l X2 X3) -> auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_618 X2 X3 H);  intros.
  apply (rem_1277 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1279 : forall X1 X2 X3 X4:term, auto___def_14 (l X2 X3) -> auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_11 X4 -> auto___def_12 X1 -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_14 (l X2 X3) -> auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1278 X1 X2 X3 X4).
Qed.

Remark rem_1280 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_640 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_1279 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1281 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_18 sym -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1280 X1 X2 X3 X4).
Qed.

Remark rem_1282 : forall X1 X2 X3 X4:term, auto___def_18 sym -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_11 X4 -> auto___def_12 X1 -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_18 sym -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1281 X1 X2 X3 X4).
Qed.

Remark rem_1283 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_12 X1 -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_644 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1282 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1284 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_12 X1 -> auto___def_12 t_current -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_12 X1 -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1283 X1 X2 X3 X4).
Qed.

Remark rem_1285 : forall X1 X2 X3 X4:term, auto___def_12 t_current -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_11 X4 -> auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_12 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_12 X1 -> auto___def_12 t_current -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1284 X1 X2 X3 X4).
Qed.

Remark rem_1286 : forall X1 X2 X3 X4:term, auto___def_10 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_11 X4 -> auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_12 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_648 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_1285 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1287 : forall X1 X2 X3 X4:term, auto___def_10 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_11 X4 -> auto___def_12 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_10 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_11 X4 -> auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_12 X1 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1286 X1 X2 X3 X4).
Qed.

Remark rem_1288 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___type_13 X1). tauto. exact (rem_1139 X1).
Qed.

Remark rem_1289 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___type_10 X1). tauto. exact (rem_1144 X1).
Qed.

Remark rem_1290 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_652 X2).
Qed.

Remark rem_1291 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X3 -> auto_knows_current X3). tauto. exact (rem_654 X3).
Qed.

Remark rem_1292 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_61 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_61 X4 -> auto___def_61 X4). tauto. exact (rem_932 X4).
Qed.

Remark rem_1293 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_12 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_61 X4 -> auto___type_12 X4). tauto. exact (rem_958 X4).
Qed.

Remark rem_1294 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> (auto___type_13 X1 /\ auto___type_10 X1 /\ auto_knows_current X2 /\ auto_knows_current X3 /\ auto___def_61 X4 /\ auto___type_12 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto___type_13 X1). 2:apply (rem_1288 X1 X2 X3 X4);  assumption.
  cut (auto___type_10 X1). 2:apply (rem_1289 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1290 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X3). 2:apply (rem_1291 X1 X2 X3 X4);  assumption.
  cut (auto___def_61 X4). 2:apply (rem_1292 X1 X2 X3 X4);  assumption.
  cut (auto___type_12 X4). 2:apply (rem_1293 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_1295 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_1294 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_83_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_1296 : forall X1 X2 X3 X4:term, auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_11 X4 -> auto___def_12 X1 -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1295 X1 X2 X3 X4).
Qed.

Remark rem_1297 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_962 X4 (cons X1 nil) H);  intros.
  apply (rem_1296 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1298 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current X3 -> auto___def_11 X4 -> auto___def_12 X1 -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1297 X1 X2 X3 X4).
Qed.

Remark rem_1299 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_59 (l X2 X3) -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_661 X2 X3 H);  intros.
  apply (rem_1298 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1300 : forall X1 X2 X3 X4:term, auto___def_59 (l X2 X3) -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_11 X4 -> auto___def_12 X1 -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_59 (l X2 X3) -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1299 X1 X2 X3 X4).
Qed.

Remark rem_1301 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_663 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_1300 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1302 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_63 sym -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1301 X1 X2 X3 X4).
Qed.

Remark rem_1303 : forall X1 X2 X3 X4:term, auto___def_63 sym -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_11 X4 -> auto___def_12 X1 -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_63 sym -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1302 X1 X2 X3 X4).
Qed.

Remark rem_1304 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_667 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1303 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1305 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_57 t_current -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1304 X1 X2 X3 X4).
Qed.

Remark rem_1306 : forall X1 X2 X3 X4:term, auto___def_57 t_current -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_11 X4 -> auto___def_12 X1 -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_57 t_current -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1305 X1 X2 X3 X4).
Qed.

Remark rem_1307 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_55 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_671 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_1306 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1308 : forall X1 X2 X3 X4:term, auto___def_55 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_11 X4 -> auto___def_12 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_55 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1307 X1 X2 X3 X4).
Qed.

Remark rem_1309 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___type_13 X1). tauto. exact (rem_1139 X1).
Qed.

Remark rem_1310 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_12 X1 -> auto___type_10 X1). tauto. exact (rem_1144 X1).
Qed.

Remark rem_1311 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_652 X2).
Qed.

Remark rem_1312 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X3 -> auto_knows_current X3). tauto. exact (rem_654 X3).
Qed.

Remark rem_1313 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_61 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_61 X4 -> auto___def_61 X4). tauto. exact (rem_932 X4).
Qed.

Remark rem_1314 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_12 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_61 X4 -> auto___type_12 X4). tauto. exact (rem_958 X4).
Qed.

Remark rem_1315 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> (auto___type_13 X1 /\ auto___type_10 X1 /\ auto_knows_current X2 /\ auto_knows_current X3 /\ auto___def_61 X4 /\ auto___type_12 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto___type_13 X1). 2:apply (rem_1309 X1 X2 X3 X4);  assumption.
  cut (auto___type_10 X1). 2:apply (rem_1310 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1311 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X3). 2:apply (rem_1312 X1 X2 X3 X4);  assumption.
  cut (auto___def_61 X4). 2:apply (rem_1313 X1 X2 X3 X4);  assumption.
  cut (auto___type_12 X4). 2:apply (rem_1314 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_1316 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_1315 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_83_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_1317 : forall X1 X2 X3 X4:term, auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_11 X4 -> auto___def_12 X1 -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1316 X1 X2 X3 X4).
Qed.

Remark rem_1318 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_981 X4 (cons X1 nil) H);  intros.
  apply (rem_1317 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1319 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current X3 -> auto___def_11 X4 -> auto___def_12 X1 -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1318 X1 X2 X3 X4).
Qed.

Remark rem_1320 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_59 (l X2 X3) -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_661 X2 X3 H);  intros.
  apply (rem_1319 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1321 : forall X1 X2 X3 X4:term, auto___def_59 (l X2 X3) -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_11 X4 -> auto___def_12 X1 -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_59 (l X2 X3) -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1320 X1 X2 X3 X4).
Qed.

Remark rem_1322 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_683 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_1321 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1323 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_63 sym -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1322 X1 X2 X3 X4).
Qed.

Remark rem_1324 : forall X1 X2 X3 X4:term, auto___def_63 sym -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_11 X4 -> auto___def_12 X1 -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_63 sym -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1323 X1 X2 X3 X4).
Qed.

Remark rem_1325 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_687 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1324 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1326 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_57 t_current -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1325 X1 X2 X3 X4).
Qed.

Remark rem_1327 : forall X1 X2 X3 X4:term, auto___def_57 t_current -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_11 X4 -> auto___def_12 X1 -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_57 t_current -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1326 X1 X2 X3 X4).
Qed.

Remark rem_1328 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_68 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_691 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_1327 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1329 : forall X1 X2 X3 X4:term, auto___def_68 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_11 X4 -> auto___def_12 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_68 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1328 X1 X2 X3 X4).
Qed.

Remark rem_1330 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_693 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil))) H);  intros.
  apply (rem_1196 X1 X2 X3 X4);  tauto.
  apply (rem_1249 X1 X2 X3 X4);  tauto.
  apply (rem_1251 X1 X2 X3 X4);  tauto.
  apply (rem_1273 X1 X2 X3 X4);  tauto.
  apply (rem_1287 X1 X2 X3 X4);  tauto.
  apply (rem_1308 X1 X2 X3 X4);  tauto.
  apply (rem_1329 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1331 : forall X1 X2 X3 X4:term, auto___def_11 X4 -> auto___def_12 X1 -> auto___def_13 (cons t_current nil) -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1330 X1 X2 X3 X4).
Qed.

Remark rem_1332 : forall X1 X2 X3 X4:term, auto___def_12 X1 -> auto___def_13 (cons t_current nil) -> auto___def_11 X4 -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 X4 -> auto___def_12 X1 -> auto___def_13 (cons t_current nil) -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1331 X1 X2 X3 X4).
Qed.

Remark rem_1333 : forall X1 X2 X3 X4:term, auto___def_10 (cons X1 (cons t_current nil)) -> auto___def_11 X4 -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_648 X1 (cons t_current nil) H);  intros.
  apply (rem_1332 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1334 : forall X1 X2 X3 X4:term, auto___def_31 (cons X4 (cons X1 nil)) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_82 (l X2 X3) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_39 X4 (cons X1 nil) H);  intros.
Qed.

Remark rem_1335 : forall X1 X2 X3 X4:term, auto___def_82 (l X2 X3) -> auto___def_31 (cons X4 (cons X1 nil)) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_31 (cons X4 (cons X1 nil)) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_82 (l X2 X3) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1334 X1 X2 X3 X4).
Qed.

Remark rem_1336 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_42 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_1335 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1337 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___type_13 t_current -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_56 X4 -> auto___def_57 X1 -> auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1336 X1 X2 X3 X4).
Qed.

Remark rem_1338 : forall X1 X2 X3 X4:term, auto___type_13 t_current -> auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 X4 -> auto___def_57 X1 -> auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___type_13 t_current -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1337 X1 X2 X3 X4).
Qed.

Remark rem_1339 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_80 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_46 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_1338 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1340 : forall X1 X2 X3 X4:term, auto___def_80 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 X4 -> auto___def_57 X1 -> auto___def_80 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1339 X1 X2 X3 X4).
Qed.

Remark rem_1341 : forall X1:term, auto___def_56 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1342 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> forall X1:term, auto___def_56 (s X1) -> auto_knows_current X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intros X1. intro H. intros.
  elim (rem_1341 X1 H);  intros.
Defined.

Remark rem_1343 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> forall X1:term, auto_knows_current (s X1) -> auto___def_56 (s X1) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intros X1. intro H. intros.
  elim (rem_752 X1 H);  intros.
  apply (rem_1342 epsilon_mknows_current_m__def_56 X1);  tauto.
Defined.

Remark rem_1344 : auto___def_56 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1345 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> auto___def_56 nil -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intro H. intros.
  elim (rem_1344 H);  intros.
Defined.

Remark rem_1346 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> auto_knows_current nil -> auto___def_56 nil -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intro H. intros.
  elim (rem_756 H);  intros.
  apply (rem_1345 epsilon_mknows_current_m__def_56);  tauto.
Defined.

Remark rem_1347 : auto___def_56 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1348 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> auto___def_56 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intro H. intros.
  elim (rem_1347 H);  intros.
Defined.

Remark rem_1349 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> auto_knows_current i -> auto___def_56 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intro H. intros.
  elim (rem_759 H);  intros.
  apply (rem_1348 epsilon_mknows_current_m__def_56);  tauto.
Defined.

Remark rem_1350 : forall X1 X2:term, auto___def_56 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1351 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> forall X1 X2:term, auto___def_56 (cons X1 X2) -> auto_knows_current X1 -> auto_knows_current X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intros X1 X2. intro H. intros.
  elim (rem_1350 X1 X2 H);  intros.
Defined.

Remark rem_1352 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> forall X1 X2:term, auto_knows_current (cons X1 X2) -> auto___def_56 (cons X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intros X1 X2. intro H. intros.
  elim (rem_124 X1 X2 H);  intros.
  apply (rem_1351 epsilon_mknows_current_m__def_56 X1 X2);  tauto.
Defined.

Remark rem_1353 : forall X1 X2:term, auto___def_56 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1354 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> forall X1 X2:term, auto___def_56 (crypt X1 X2) -> auto___def_80 X1 -> auto___type_12 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intros X1 X2. intro H. intros.
  elim (rem_1353 X1 X2 H);  intros.
Defined.

Remark rem_1355 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> forall X1 X2:term, auto___def_56 (crypt X1 X2) -> auto_knows_current X1 -> auto_knows_current X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intros X1 X2. intro H. intros.
  elim (rem_1353 X1 X2 H);  intros.
Defined.

Remark rem_1356 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> forall X1 X2:term, auto___def_56 (crypt X1 X2) -> auto___def_84 X1 -> auto___type_14 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intros X1 X2. intro H. intros.
  elim (rem_1353 X1 X2 H);  intros.
Defined.

Remark rem_1357 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> forall X1 X2:term, auto___def_56 (crypt X1 X2) -> auto___def_23 X1 -> auto___def_24 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intros X1 X2. intro H. intros.
  elim (rem_1353 X1 X2 H);  intros.
Defined.

Remark rem_1358 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> forall X1 X2:term, auto___def_56 (crypt X1 X2) -> auto___def_10 X1 -> auto___def_11 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intros X1 X2. intro H. intros.
  elim (rem_1353 X1 X2 H);  intros.
Defined.

Remark rem_1359 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> forall X1 X2:term, auto___def_56 (crypt X1 X2) -> auto___def_55 X1 -> auto___def_56 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intros X1 X2. intro H. intros.
  elim (rem_1353 X1 X2 H);  intros.
Defined.

Remark rem_1360 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> forall X1 X2:term, auto___def_56 (crypt X1 X2) -> auto___def_68 X1 -> auto___def_69 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intros X1 X2. intro H. intros.
  elim (rem_1353 X1 X2 H);  intros.
Defined.

Remark rem_1361 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> forall X1 X2:term, auto_knows_current (crypt X1 X2) -> auto___def_56 (crypt X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intros X1 X2. intro H. intros.
  elim (rem_693 X1 X2 H);  intros.
  apply (rem_1354 epsilon_mknows_current_m__def_56 X1 X2);  tauto.
  apply (rem_1355 epsilon_mknows_current_m__def_56 X1 X2);  tauto.
  apply (rem_1356 epsilon_mknows_current_m__def_56 X1 X2);  tauto.
  apply (rem_1357 epsilon_mknows_current_m__def_56 X1 X2);  tauto.
  apply (rem_1358 epsilon_mknows_current_m__def_56 X1 X2);  tauto.
  apply (rem_1359 epsilon_mknows_current_m__def_56 X1 X2);  tauto.
  apply (rem_1360 epsilon_mknows_current_m__def_56 X1 X2);  tauto.
Defined.

Remark rem_1362 : auto___def_56 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1363 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> auto___def_56 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intro H. intros.
  elim (rem_1362 H);  intros.
Defined.

Remark rem_1364 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> auto_knows_current bob -> auto___def_56 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intro H. intros.
  elim (rem_806 H);  intros.
  apply (rem_1363 epsilon_mknows_current_m__def_56);  tauto.
Defined.

Remark rem_1365 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> forall X1:term, auto___def_63 X1 -> auto___def_42 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_mknows_current_m__def_56. exact (rem_69).
Defined.

Remark rem_1366 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> forall X1 X2:term, auto___def_63 X1 -> auto___def_75 X2 -> auto___def_42 X1 -> auto___type_8 X2 -> False. (* Split. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intros X1 X2.
  cut (auto___def_63 X1 -> auto___def_42 X1 -> False). clear  epsilon_mknows_current_m__def_56. tauto.
  exact (rem_1365 epsilon_mknows_current_m__def_56 X1).
Defined.

Remark rem_1367 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> forall X1 X2:term, auto___def_56 (key X1 X2) -> auto___def_42 X1 -> auto___type_8 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intros X1 X2. intro H. intros.
  elim (rem_667 X1 X2 H);  intros.
  apply (rem_1366 epsilon_mknows_current_m__def_56 X1 X2);  tauto.
Defined.

Remark rem_1368 : forall X1 X2:term, auto___def_75 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1369 : (forall X:term, auto___def_47 X -> auto___def_75 X -> False)
    -> forall X1 X2:term, auto___def_75 (session_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_47_m__def_75. intros X1 X2. intro H. intros.
  elim (rem_1368 X1 X2 H);  intros.
Defined.

Remark rem_1370 : (forall X:term, auto___def_47 X -> auto___def_75 X -> False)
    -> forall X1 X2:term, auto___def_47 (session_old X1 X2) -> auto___def_75 (session_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_47_m__def_75. intros X1 X2. intro H. intros.
  elim (rem_1201 X1 X2 H);  intros.
  apply (rem_1369 epsilon_m__def_47_m__def_75 X1 X2);  tauto.
Defined.

Remark rem_1371 : forall X2:term, auto___def_47 X2 -> auto___def_75 X2 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_47_m__def_75 1.
  intro X. case X.
   intro H. elim (rem_1214  H).
   intro H. elim (rem_1210  H).
  intros X1 X2. intro H. elim (rem_708 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1209 X1 X2 H).
   intro H. elim (rem_1205  H).
  intros X1 X2. intro H. elim (rem_1211 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1208 X1 X2 H).
   intro H. elim (rem_1204  H).
   intro H. elim (rem_1207  H).
   intro H. elim (rem_1212  H).
  intros X1. intro H. elim (rem_1203 X1 H).
   intro H. elim (rem_1215  H).
  intros X1 X2. intro H. elim (rem_72 X1 X2 H).
  intros X1 X2;  exact (rem_1370 epsilon_m__def_47_m__def_75 X1 X2).
   intro H. elim (rem_1206  H).
   intro H. elim (rem_1216  H).
   intro H. elim (rem_1213  H).
Qed.

Remark rem_1372 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> forall X2:term, auto___def_47 X2 -> auto___def_75 X2 -> False. (* Cut history. *)
Proof.  intros epsilon_mknows_current_m__def_56. exact (rem_1371).
Defined.

Remark rem_1373 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> forall X1 X2:term, auto___def_47 X2 -> auto___def_46 X1 -> auto___def_63 X1 -> auto___def_75 X2 -> False. (* Split. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intros X1 X2.
  cut (auto___def_47 X2 -> auto___def_75 X2 -> False). clear  epsilon_mknows_current_m__def_56. tauto.
  exact (rem_1372 epsilon_mknows_current_m__def_56 X2).
Defined.

Remark rem_1374 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> forall X1 X2:term, auto___def_56 (key X1 X2) -> auto___def_46 X1 -> auto___def_47 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intros X1 X2. intro H. intros.
  elim (rem_667 X1 X2 H);  intros.
  apply (rem_1373 epsilon_mknows_current_m__def_56 X1 X2);  tauto.
Defined.

Remark rem_1375 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> forall X1:term, auto___def_63 X1 -> auto___def_43 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_mknows_current_m__def_56. exact (rem_98).
Defined.

Remark rem_1376 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_63 X1 -> auto___def_75 X2 -> False. (* Split. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intros X1 X2.
  cut (auto___def_63 X1 -> auto___def_43 X1 -> False). clear  epsilon_mknows_current_m__def_56. tauto.
  exact (rem_1375 epsilon_mknows_current_m__def_56 X1).
Defined.

Remark rem_1377 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> forall X1 X2:term, auto___def_56 (key X1 X2) -> auto___def_43 X1 -> auto___def_44 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intros X1 X2. intro H. intros.
  elim (rem_667 X1 X2 H);  intros.
  apply (rem_1376 epsilon_mknows_current_m__def_56 X1 X2);  tauto.
Defined.

Remark rem_1378 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> forall X1 X2:term, auto_knows_current (key X1 X2) -> auto___def_56 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intros X1 X2. intro H. intros.
  elim (rem_101 X1 X2 H);  intros.
  apply (rem_1367 epsilon_mknows_current_m__def_56 X1 X2);  tauto.
  apply (rem_1374 epsilon_mknows_current_m__def_56 X1 X2);  tauto.
  apply (rem_1377 epsilon_mknows_current_m__def_56 X1 X2);  tauto.
Defined.

Remark rem_1379 : auto___def_56 t_old -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1380 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> auto___def_56 t_old -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intro H. intros.
  elim (rem_1379 H);  intros.
Defined.

Remark rem_1381 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> auto_knows_current t_old -> auto___def_56 t_old -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intro H. intros.
  elim (rem_828 H);  intros.
  apply (rem_1380 epsilon_mknows_current_m__def_56);  tauto.
Defined.

Remark rem_1382 : auto___def_56 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1383 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> auto___def_56 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intro H. intros.
  elim (rem_1382 H);  intros.
Defined.

Remark rem_1384 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> auto_knows_current alice -> auto___def_56 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intro H. intros.
  elim (rem_831 H);  intros.
  apply (rem_1383 epsilon_mknows_current_m__def_56);  tauto.
Defined.

Remark rem_1385 : auto___def_56 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1386 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> auto___def_56 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intro H. intros.
  elim (rem_1385 H);  intros.
Defined.

Remark rem_1387 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> auto_knows_current server -> auto___def_56 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intro H. intros.
  elim (rem_834 H);  intros.
  apply (rem_1386 epsilon_mknows_current_m__def_56);  tauto.
Defined.

Remark rem_1388 : auto___def_56 t_current -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1389 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> auto___def_56 t_current -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intro H. intros.
  elim (rem_1388 H);  intros.
Defined.

Remark rem_1390 : (forall X:term, auto_knows_current X -> auto___def_56 X -> False)
    -> auto_knows_current t_current -> auto___def_56 t_current -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_56. intro H. intros.
  elim (rem_837 H);  intros.
  apply (rem_1389 epsilon_mknows_current_m__def_56);  tauto.
Defined.

Remark rem_1391 : forall X1:term, auto_knows_current X1 -> auto___def_56 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_mknows_current_m__def_56 1.
  intro X. case X.
  exact (rem_1384 epsilon_mknows_current_m__def_56 ).
  exact (rem_1364 epsilon_mknows_current_m__def_56 ).
  intros X1 X2;  exact (rem_1352 epsilon_mknows_current_m__def_56 X1 X2).
  intros X1 X2;  exact (rem_1361 epsilon_mknows_current_m__def_56 X1 X2).
  exact (rem_1349 epsilon_mknows_current_m__def_56 ).
  intros X1 X2;  exact (rem_1378 epsilon_mknows_current_m__def_56 X1 X2).
  intros X1 X2. intro H. elim (rem_704 X1 X2 H).
  exact (rem_1346 epsilon_mknows_current_m__def_56 ).
   intro H. elim (rem_842  H).
   intro H. elim (rem_843  H).
  intros X1;  exact (rem_1343 epsilon_mknows_current_m__def_56 X1).
  exact (rem_1387 epsilon_mknows_current_m__def_56 ).
  intros X1 X2. intro H. elim (rem_839 X1 X2 H).
  intros X1 X2. intro H. elim (rem_840 X1 X2 H).
   intro H. elim (rem_841  H).
  exact (rem_1390 epsilon_mknows_current_m__def_56 ).
  exact (rem_1381 epsilon_mknows_current_m__def_56 ).
Qed.

Remark rem_1392 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto_knows_current X4 -> auto_knows_current (cons X1 nil) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_1391 X4)). tauto.
Qed.

Remark rem_1393 : forall X1 X2 X3 X4:term, auto_knows_current X4 -> auto_knows_current (cons X1 nil) -> auto___def_56 X4 -> auto___def_57 X1 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 X4 -> auto___def_57 X1 -> auto_knows_current X4 -> auto_knows_current (cons X1 nil) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1392 X1 X2 X3 X4).
Qed.

Remark rem_1394 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_124 X4 (cons X1 nil) H);  intros.
  apply (rem_1393 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1395 : forall X1 X2 X3 X4:term, auto_knows_current (l X2 X3) -> auto_knows_current (cons X4 (cons X1 nil)) -> auto___def_56 X4 -> auto___def_57 X1 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 X4 -> auto___def_57 X1 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1394 X1 X2 X3 X4).
Qed.

Remark rem_1396 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_124 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_1395 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1397 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current t_current -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_56 X4 -> auto___def_57 X1 -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1396 X1 X2 X3 X4).
Qed.

Remark rem_1398 : forall X1 X2 X3 X4:term, auto_knows_current t_current -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_56 X4 -> auto___def_57 X1 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 X4 -> auto___def_57 X1 -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current t_current -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1397 X1 X2 X3 X4).
Qed.

Remark rem_1399 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto_knows_current (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_124 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_1398 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1400 : forall X1 X2 X3 X4:term, auto_knows_current (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 X4 -> auto___def_57 X1 -> auto_knows_current (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1399 X1 X2 X3 X4).
Qed.

Remark rem_1401 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_84 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_14 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_132 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
Qed.

Remark rem_1402 : forall X1 X2 X3 X4:term, auto___def_84 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_14 (key sym (cons X3 (cons server nil))) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 X4 -> auto___def_57 X1 -> auto___def_84 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_14 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1401 X1 X2 X3 X4).
Qed.

Remark rem_1403 : (forall X:term, auto___def_19 X -> auto___def_75 X -> False)
    -> forall X1 X2:term, auto___def_75 (session_old X1 X2) -> auto_knows_old X1 -> auto_knows_old X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_19_m__def_75. intros X1 X2. intro H. intros.
  elim (rem_1368 X1 X2 H);  intros.
Defined.

Remark rem_1404 : (forall X:term, auto___def_19 X -> auto___def_75 X -> False)
    -> forall X1 X2:term, auto___def_19 (session_old X1 X2) -> auto___def_75 (session_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_19_m__def_75. intros X1 X2. intro H. intros.
  elim (rem_305 X1 X2 H);  intros.
  apply (rem_1403 epsilon_m__def_19_m__def_75 X1 X2);  tauto.
Defined.

Remark rem_1405 : forall X2:term, auto___def_19 X2 -> auto___def_75 X2 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_19_m__def_75 1.
  intro X. case X.
   intro H. elim (rem_320  H).
   intro H. elim (rem_316  H).
  intros X1 X2. intro H. elim (rem_311 X1 X2 H).
  intros X1 X2. intro H. elim (rem_315 X1 X2 H).
   intro H. elim (rem_310  H).
  intros X1 X2. intro H. elim (rem_317 X1 X2 H).
  intros X1 X2. intro H. elim (rem_314 X1 X2 H).
   intro H. elim (rem_309  H).
   intro H. elim (rem_313  H).
   intro H. elim (rem_318  H).
  intros X1. intro H. elim (rem_308 X1 H).
   intro H. elim (rem_321  H).
  intros X1 X2. intro H. elim (rem_307 X1 X2 H).
  intros X1 X2;  exact (rem_1404 epsilon_m__def_19_m__def_75 X1 X2).
   intro H. elim (rem_312  H).
   intro H. elim (rem_322  H).
   intro H. elim (rem_319  H).
Qed.

Remark rem_1406 : (forall X:term, auto___def_56 X -> auto___def_16 X -> False)
    -> forall X2:term, auto___def_19 X2 -> auto___def_75 X2 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_56_m__def_16. exact (rem_1405).
Defined.

Remark rem_1407 : (forall X:term, auto___def_56 X -> auto___def_16 X -> False)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_63 X1 -> auto___def_75 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_56_m__def_16. intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_75 X2 -> False). clear  epsilon_m__def_56_m__def_16. tauto.
  exact (rem_1406 epsilon_m__def_56_m__def_16 X2).
Defined.

Remark rem_1408 : (forall X:term, auto___def_56 X -> auto___def_16 X -> False)
    -> forall X1 X2:term, auto___def_16 (key X1 X2) -> auto___def_63 X1 -> auto___def_75 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_56_m__def_16. intros X1 X2. intro H. intros.
  elim (rem_1088 X1 X2 H);  intros.
  apply (rem_1407 epsilon_m__def_56_m__def_16 X1 X2);  tauto.
Defined.

Remark rem_1409 : (forall X:term, auto___def_56 X -> auto___def_16 X -> False)
    -> forall X1 X2:term, auto___def_56 (key X1 X2) -> auto___def_16 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_56_m__def_16. intros X1 X2. intro H. intros.
  elim (rem_667 X1 X2 H);  intros.
  apply (rem_1408 epsilon_m__def_56_m__def_16 X1 X2);  tauto.
Defined.

Remark rem_1410 : forall X1 X2:term, auto___def_56 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1411 : forall X1 X2:term, auto___def_56 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1412 : auto___def_56 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1413 : auto___def_56 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1414 : forall X1 X2:term, auto___def_56 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1415 : auto___def_56 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1416 : forall X1:term, auto___def_56 X1 -> auto___def_16 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_56_m__def_16 1.
  intro X. case X.
   intro H. elim (rem_1382  H).
   intro H. elim (rem_1362  H).
  intros X1 X2. intro H. elim (rem_1350 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1353 X1 X2 H).
   intro H. elim (rem_1347  H).
  intros X1 X2;  exact (rem_1409 epsilon_m__def_56_m__def_16 X1 X2).
  intros X1 X2. intro H. elim (rem_1414 X1 X2 H).
   intro H. elim (rem_1344  H).
   intro H. elim (rem_1413  H).
   intro H. elim (rem_1415  H).
  intros X1. intro H. elim (rem_1341 X1 H).
   intro H. elim (rem_1385  H).
  intros X1 X2. intro H. elim (rem_1410 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1411 X1 X2 H).
   intro H. elim (rem_1412  H).
   intro H. elim (rem_1388  H).
   intro H. elim (rem_1379  H).
Qed.

Remark rem_1417 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_27 (cons X1 nil) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_56 X4 -> auto___def_57 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_1416 X4)). tauto.
Qed.

Remark rem_1418 : forall X1 X2 X3 X4:term, auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_56 X4 -> auto___def_57 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1094 X4 (cons X1 nil) H);  intros.
  apply (rem_1417 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1419 : forall X1 X2 X3 X4:term, auto_knows_old X2 -> auto_knows_old X3 -> auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_56 X4 -> auto___def_57 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1418 X1 X2 X3 X4).
Qed.

Remark rem_1420 : forall X1 X2 X3 X4:term, auto___def_14 (l X2 X3) -> auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_618 X2 X3 H);  intros.
  apply (rem_1419 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1421 : forall X1 X2 X3 X4:term, auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_620 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_1420 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1422 : forall X1 X2 X3 X4:term, auto___def_18 sym -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1421 X1 X2 X3 X4).
Qed.

Remark rem_1423 : forall X1 X2 X3 X4:term, auto___def_18 sym -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_18 sym -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1422 X1 X2 X3 X4).
Qed.

Remark rem_1424 : forall X1 X2 X3 X4:term, auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_624 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1423 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1425 : forall X1 X2 X3 X4:term, auto___def_12 t_current -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1424 X1 X2 X3 X4).
Qed.

Remark rem_1426 : forall X1 X2 X3 X4:term, auto___def_12 t_current -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 t_current -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1425 X1 X2 X3 X4).
Qed.

Remark rem_1427 : forall X1 X2 X3 X4:term, auto___def_23 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_628 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_1426 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1428 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_17 (cons X1 nil) -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_56 X4 -> auto___def_57 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_1416 X4)). tauto.
Qed.

Remark rem_1429 : forall X1 X2 X3 X4:term, auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_56 X4 -> auto___def_57 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_738 X4 (cons X1 nil) H);  intros.
  apply (rem_1428 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1430 : forall X1 X2 X3 X4:term, auto_knows_old X2 -> auto_knows_old X3 -> auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_56 X4 -> auto___def_57 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1429 X1 X2 X3 X4).
Qed.

Remark rem_1431 : forall X1 X2 X3 X4:term, auto___def_14 (l X2 X3) -> auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_618 X2 X3 H);  intros.
  apply (rem_1430 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1432 : forall X1 X2 X3 X4:term, auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_640 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_1431 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1433 : forall X1 X2 X3 X4:term, auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_18 sym -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1432 X1 X2 X3 X4).
Qed.

Remark rem_1434 : forall X1 X2 X3 X4:term, auto___def_18 sym -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_18 sym -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1433 X1 X2 X3 X4).
Qed.

Remark rem_1435 : forall X1 X2 X3 X4:term, auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_644 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1434 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1436 : forall X1 X2 X3 X4:term, auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_12 t_current -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1435 X1 X2 X3 X4).
Qed.

Remark rem_1437 : forall X1 X2 X3 X4:term, auto___def_12 t_current -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_12 t_current -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1436 X1 X2 X3 X4).
Qed.

Remark rem_1438 : forall X1 X2 X3 X4:term, auto___def_10 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_648 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_1437 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1439 : (forall X:term, auto___def_57 X -> auto___type_13 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_57_p__type_13.  tauto.
Defined.

Remark rem_1440 : (forall X:term, auto___def_57 X -> auto___type_13 X)
    -> auto___type_13 t_current. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_57_p__type_13.  case (rem_1439 epsilon_m__def_57_p__type_13). clear  epsilon_m__def_57_p__type_13. intros. apply trans___type_13_t_current_1;  tauto.
 clear  epsilon_m__def_57_p__type_13. tauto.
Defined.

Remark rem_1441 : auto___def_57 t_current -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1442 : (forall X:term, auto___def_57 X -> auto___type_13 X)
    -> auto___def_57 t_current -> auto___type_13 t_current. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_57_p__type_13. intro H. intros.
  elim (rem_1441 H);  intros.
  apply (rem_1440 epsilon_m__def_57_p__type_13);  tauto.
Defined.

Remark rem_1443 : forall X1 X2:term, auto___def_57 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1444 : forall X1:term, auto___def_57 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1445 : auto___def_57 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1446 : auto___def_57 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1447 : forall X1 X2:term, auto___def_57 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1448 : forall X1 X2:term, auto___def_57 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1449 : auto___def_57 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1450 : auto___def_57 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1451 : forall X1 X2:term, auto___def_57 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1452 : forall X1 X2:term, auto___def_57 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1453 : auto___def_57 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1454 : forall X1 X2:term, auto___def_57 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1455 : auto___def_57 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1456 : auto___def_57 t_old -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1457 : auto___def_57 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1458 : auto___def_57 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1459 : forall X1:term, auto___def_57 X1 -> auto___type_13 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_57_p__type_13 1.
  intro X. case X.
   intro H. elim (rem_1457  H).
   intro H. elim (rem_1453  H).
  intros X1 X2. intro H. elim (rem_1448 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1452 X1 X2 H).
   intro H. elim (rem_1446  H).
  intros X1 X2. intro H. elim (rem_1454 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1451 X1 X2 H).
   intro H. elim (rem_1445  H).
   intro H. elim (rem_1450  H).
   intro H. elim (rem_1455  H).
  intros X1. intro H. elim (rem_1444 X1 H).
   intro H. elim (rem_1458  H).
  intros X1 X2. intro H. elim (rem_1443 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1447 X1 X2 H).
   intro H. elim (rem_1449  H).
  exact (rem_1442 epsilon_m__def_57_p__type_13 ).
   intro H. elim (rem_1456  H).
Qed.

Remark rem_1460 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___type_13 X1). tauto. exact (rem_1459 X1).
Qed.

Remark rem_1461 : (forall X:term, auto___def_57 X -> auto___type_10 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_57_p__type_10.  tauto.
Defined.

Remark rem_1462 : (forall X:term, auto___def_57 X -> auto___type_10 X)
    -> auto___type_10 t_current. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_57_p__type_10.  case (rem_1461 epsilon_m__def_57_p__type_10). clear  epsilon_m__def_57_p__type_10. intros. apply trans___type_10_t_current_1;  tauto.
 clear  epsilon_m__def_57_p__type_10. tauto.
Defined.

Remark rem_1463 : (forall X:term, auto___def_57 X -> auto___type_10 X)
    -> auto___def_57 t_current -> auto___type_10 t_current. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_57_p__type_10. intro H. intros.
  elim (rem_1441 H);  intros.
  apply (rem_1462 epsilon_m__def_57_p__type_10);  tauto.
Defined.

Remark rem_1464 : forall X1:term, auto___def_57 X1 -> auto___type_10 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_57_p__type_10 1.
  intro X. case X.
   intro H. elim (rem_1457  H).
   intro H. elim (rem_1453  H).
  intros X1 X2. intro H. elim (rem_1448 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1452 X1 X2 H).
   intro H. elim (rem_1446  H).
  intros X1 X2. intro H. elim (rem_1454 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1451 X1 X2 H).
   intro H. elim (rem_1445  H).
   intro H. elim (rem_1450  H).
   intro H. elim (rem_1455  H).
  intros X1. intro H. elim (rem_1444 X1 H).
   intro H. elim (rem_1458  H).
  intros X1 X2. intro H. elim (rem_1443 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1447 X1 X2 H).
   intro H. elim (rem_1449  H).
  exact (rem_1463 epsilon_m__def_57_p__type_10 ).
   intro H. elim (rem_1456  H).
Qed.

Remark rem_1465 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___type_10 X1). tauto. exact (rem_1464 X1).
Qed.

Remark rem_1466 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_652 X2).
Qed.

Remark rem_1467 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X3 -> auto_knows_current X3). tauto. exact (rem_654 X3).
Qed.

Remark rem_1468 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_61 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_61 X4 -> auto___def_61 X4). tauto. exact (rem_932 X4).
Qed.

Remark rem_1469 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_12 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_61 X4 -> auto___type_12 X4). tauto. exact (rem_958 X4).
Qed.

Remark rem_1470 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> (auto___type_13 X1 /\ auto___type_10 X1 /\ auto_knows_current X2 /\ auto_knows_current X3 /\ auto___def_61 X4 /\ auto___type_12 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto___type_13 X1). 2:apply (rem_1460 X1 X2 X3 X4);  assumption.
  cut (auto___type_10 X1). 2:apply (rem_1465 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1466 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X3). 2:apply (rem_1467 X1 X2 X3 X4);  assumption.
  cut (auto___def_61 X4). 2:apply (rem_1468 X1 X2 X3 X4);  assumption.
  cut (auto___type_12 X4). 2:apply (rem_1469 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_1471 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_1470 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_83_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_1472 : forall X1 X2 X3 X4:term, auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 X4 -> auto___def_57 X1 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1471 X1 X2 X3 X4).
Qed.

Remark rem_1473 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_962 X4 (cons X1 nil) H);  intros.
  apply (rem_1472 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1474 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current X3 -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 X4 -> auto___def_57 X1 -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1473 X1 X2 X3 X4).
Qed.

Remark rem_1475 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_59 (l X2 X3) -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_661 X2 X3 H);  intros.
  apply (rem_1474 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1476 : forall X1 X2 X3 X4:term, auto___def_59 (l X2 X3) -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 X4 -> auto___def_57 X1 -> auto___def_59 (l X2 X3) -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1475 X1 X2 X3 X4).
Qed.

Remark rem_1477 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_663 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_1476 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1478 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_63 sym -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_56 X4 -> auto___def_57 X1 -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1477 X1 X2 X3 X4).
Qed.

Remark rem_1479 : forall X1 X2 X3 X4:term, auto___def_63 sym -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 X4 -> auto___def_57 X1 -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_63 sym -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1478 X1 X2 X3 X4).
Qed.

Remark rem_1480 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_57 X1 -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_667 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1479 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1481 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_57 X1 -> auto___def_57 t_current -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_56 X4 -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_57 X1 -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1480 X1 X2 X3 X4).
Qed.

Remark rem_1482 : forall X1 X2 X3 X4:term, auto___def_57 t_current -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_56 X4 -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 X4 -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_57 X1 -> auto___def_57 t_current -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1481 X1 X2 X3 X4).
Qed.

Remark rem_1483 : forall X1 X2 X3 X4:term, auto___def_55 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_56 X4 -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_671 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_1482 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1484 : forall X1 X2 X3 X4:term, auto___def_55 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_55 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_56 X4 -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1483 X1 X2 X3 X4).
Qed.

Remark rem_1485 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___type_13 X1). tauto. exact (rem_1459 X1).
Qed.

Remark rem_1486 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___type_10 X1). tauto. exact (rem_1464 X1).
Qed.

Remark rem_1487 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_652 X2).
Qed.

Remark rem_1488 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X3 -> auto_knows_current X3). tauto. exact (rem_654 X3).
Qed.

Remark rem_1489 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_61 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_61 X4 -> auto___def_61 X4). tauto. exact (rem_932 X4).
Qed.

Remark rem_1490 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_12 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_61 X4 -> auto___type_12 X4). tauto. exact (rem_958 X4).
Qed.

Remark rem_1491 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> (auto___type_13 X1 /\ auto___type_10 X1 /\ auto_knows_current X2 /\ auto_knows_current X3 /\ auto___def_61 X4 /\ auto___type_12 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto___type_13 X1). 2:apply (rem_1485 X1 X2 X3 X4);  assumption.
  cut (auto___type_10 X1). 2:apply (rem_1486 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1487 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X3). 2:apply (rem_1488 X1 X2 X3 X4);  assumption.
  cut (auto___def_61 X4). 2:apply (rem_1489 X1 X2 X3 X4);  assumption.
  cut (auto___type_12 X4). 2:apply (rem_1490 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_1492 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_1491 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_83_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_1493 : forall X1 X2 X3 X4:term, auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 X4 -> auto___def_57 X1 -> auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1492 X1 X2 X3 X4).
Qed.

Remark rem_1494 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_981 X4 (cons X1 nil) H);  intros.
  apply (rem_1493 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1495 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current X3 -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 X4 -> auto___def_57 X1 -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1494 X1 X2 X3 X4).
Qed.

Remark rem_1496 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_59 (l X2 X3) -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_661 X2 X3 H);  intros.
  apply (rem_1495 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1497 : forall X1 X2 X3 X4:term, auto___def_59 (l X2 X3) -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 X4 -> auto___def_57 X1 -> auto___def_59 (l X2 X3) -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1496 X1 X2 X3 X4).
Qed.

Remark rem_1498 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_683 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_1497 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1499 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_63 sym -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_56 X4 -> auto___def_57 X1 -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1498 X1 X2 X3 X4).
Qed.

Remark rem_1500 : forall X1 X2 X3 X4:term, auto___def_63 sym -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 X4 -> auto___def_57 X1 -> auto___def_63 sym -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1499 X1 X2 X3 X4).
Qed.

Remark rem_1501 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_687 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1500 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1502 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_57 t_current -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_56 X4 -> auto___def_57 X1 -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1501 X1 X2 X3 X4).
Qed.

Remark rem_1503 : forall X1 X2 X3 X4:term, auto___def_57 t_current -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 X4 -> auto___def_57 X1 -> auto___def_57 t_current -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1502 X1 X2 X3 X4).
Qed.

Remark rem_1504 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_68 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_691 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_1503 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1505 : forall X1 X2 X3 X4:term, auto___def_68 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_56 X4 -> auto___def_57 X1 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 X4 -> auto___def_57 X1 -> auto___def_68 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1504 X1 X2 X3 X4).
Qed.

Remark rem_1506 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_693 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil))) H);  intros.
  apply (rem_1340 X1 X2 X3 X4);  tauto.
  apply (rem_1400 X1 X2 X3 X4);  tauto.
  apply (rem_1402 X1 X2 X3 X4);  tauto.
  apply (rem_1427 X1 X2 X3 X4);  tauto.
  apply (rem_1438 X1 X2 X3 X4);  tauto.
  apply (rem_1484 X1 X2 X3 X4);  tauto.
  apply (rem_1505 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1507 : forall X1 X2 X3 X4:term, auto___def_56 X4 -> auto___def_57 X1 -> auto___def_58 (cons t_current nil) -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_56 X4 -> auto___def_57 X1 -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1506 X1 X2 X3 X4).
Qed.

Remark rem_1508 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_58 (cons t_current nil) -> auto___def_56 X4 -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 X4 -> auto___def_57 X1 -> auto___def_58 (cons t_current nil) -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1507 X1 X2 X3 X4).
Qed.

Remark rem_1509 : forall X1 X2 X3 X4:term, auto___def_55 (cons X1 (cons t_current nil)) -> auto___def_56 X4 -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_671 X1 (cons t_current nil) H);  intros.
  apply (rem_1508 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1510 : forall X1 X2 X3 X4:term, auto___def_31 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_82 (l X2 X3) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_39 X4 (cons X1 nil) H);  intros.
Qed.

Remark rem_1511 : forall X1 X2 X3 X4:term, auto___def_82 (l X2 X3) -> auto___def_31 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_31 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_82 (l X2 X3) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1510 X1 X2 X3 X4).
Qed.

Remark rem_1512 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_69 X4 -> auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_42 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_1511 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1513 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_69 X4 -> auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___type_13 t_current -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_69 X4 -> auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1512 X1 X2 X3 X4).
Qed.

Remark rem_1514 : forall X1 X2 X3 X4:term, auto___type_13 t_current -> auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_69 X4 -> auto___def_81 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___type_13 t_current -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1513 X1 X2 X3 X4).
Qed.

Remark rem_1515 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_69 X4 -> auto___def_80 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_46 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_1514 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1516 : forall X1 X2 X3 X4:term, auto___def_80 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_69 X4 -> auto___def_80 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1515 X1 X2 X3 X4).
Qed.

Remark rem_1517 : (forall X:term, auto___def_69 X -> auto_knows_current X -> False)
    -> forall X1:term, auto___def_63 X1 -> auto___def_42 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_69_mknows_current. exact (rem_69).
Defined.

Remark rem_1518 : (forall X:term, auto___def_69 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto___def_63 X1 -> auto___def_73 X2 -> auto___def_42 X1 -> auto___type_8 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_69_mknows_current. intros X1 X2.
  cut (auto___def_63 X1 -> auto___def_42 X1 -> False). clear  epsilon_m__def_69_mknows_current. tauto.
  exact (rem_1517 epsilon_m__def_69_mknows_current X1).
Defined.

Remark rem_1519 : forall X1 X2:term, auto___def_73 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1520 : (forall X:term, auto___def_47 X -> auto___def_73 X -> False)
    -> forall X1 X2:term, auto___def_73 (session_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_47_m__def_73. intros X1 X2. intro H. intros.
  elim (rem_1519 X1 X2 H);  intros.
Defined.

Remark rem_1521 : (forall X:term, auto___def_47 X -> auto___def_73 X -> False)
    -> forall X1 X2:term, auto___def_47 (session_old X1 X2) -> auto___def_73 (session_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_47_m__def_73. intros X1 X2. intro H. intros.
  elim (rem_1201 X1 X2 H);  intros.
  apply (rem_1520 epsilon_m__def_47_m__def_73 X1 X2);  tauto.
Defined.

Remark rem_1522 : forall X2:term, auto___def_47 X2 -> auto___def_73 X2 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_47_m__def_73 1.
  intro X. case X.
   intro H. elim (rem_1214  H).
   intro H. elim (rem_1210  H).
  intros X1 X2. intro H. elim (rem_708 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1209 X1 X2 H).
   intro H. elim (rem_1205  H).
  intros X1 X2. intro H. elim (rem_1211 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1208 X1 X2 H).
   intro H. elim (rem_1204  H).
   intro H. elim (rem_1207  H).
   intro H. elim (rem_1212  H).
  intros X1. intro H. elim (rem_1203 X1 H).
   intro H. elim (rem_1215  H).
  intros X1 X2. intro H. elim (rem_72 X1 X2 H).
  intros X1 X2;  exact (rem_1521 epsilon_m__def_47_m__def_73 X1 X2).
   intro H. elim (rem_1206  H).
   intro H. elim (rem_1216  H).
   intro H. elim (rem_1213  H).
Qed.

Remark rem_1523 : (forall X:term, auto___def_69 X -> auto_knows_current X -> False)
    -> forall X2:term, auto___def_47 X2 -> auto___def_73 X2 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_69_mknows_current. exact (rem_1522).
Defined.

Remark rem_1524 : (forall X:term, auto___def_69 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto___def_47 X2 -> auto___def_46 X1 -> auto___def_63 X1 -> auto___def_73 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_69_mknows_current. intros X1 X2.
  cut (auto___def_47 X2 -> auto___def_73 X2 -> False). clear  epsilon_m__def_69_mknows_current. tauto.
  exact (rem_1523 epsilon_m__def_69_mknows_current X2).
Defined.

Remark rem_1525 : (forall X:term, auto___def_69 X -> auto_knows_current X -> False)
    -> forall X1:term, auto___def_63 X1 -> auto___def_43 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_69_mknows_current. exact (rem_98).
Defined.

Remark rem_1526 : (forall X:term, auto___def_69 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_63 X1 -> auto___def_73 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_69_mknows_current. intros X1 X2.
  cut (auto___def_63 X1 -> auto___def_43 X1 -> False). clear  epsilon_m__def_69_mknows_current. tauto.
  exact (rem_1525 epsilon_m__def_69_mknows_current X1).
Defined.

Remark rem_1527 : (forall X:term, auto___def_69 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto_knows_current (key X1 X2) -> auto___def_63 X1 -> auto___def_73 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_69_mknows_current. intros X1 X2. intro H. intros.
  elim (rem_101 X1 X2 H);  intros.
  apply (rem_1518 epsilon_m__def_69_mknows_current X1 X2);  tauto.
  apply (rem_1524 epsilon_m__def_69_mknows_current X1 X2);  tauto.
  apply (rem_1526 epsilon_m__def_69_mknows_current X1 X2);  tauto.
Defined.

Remark rem_1528 : (forall X:term, auto___def_69 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto___def_69 (key X1 X2) -> auto_knows_current (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_69_mknows_current. intros X1 X2. intro H. intros.
  elim (rem_687 X1 X2 H);  intros.
  apply (rem_1527 epsilon_m__def_69_mknows_current X1 X2);  tauto.
Defined.

Remark rem_1529 : forall X1 X2:term, auto___def_69 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1530 : forall X1:term, auto___def_69 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1531 : auto___def_69 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1532 : auto___def_69 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1533 : forall X1 X2:term, auto___def_69 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1534 : forall X1 X2:term, auto___def_69 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1535 : auto___def_69 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1536 : auto___def_69 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1537 : forall X1 X2:term, auto___def_69 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1538 : forall X1 X2:term, auto___def_69 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1539 : auto___def_69 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1540 : auto___def_69 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1541 : auto___def_69 t_old -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1542 : auto___def_69 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1543 : auto___def_69 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1544 : auto___def_69 t_current -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1545 : forall X1:term, auto___def_69 X1 -> auto_knows_current X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_69_mknows_current 1.
  intro X. case X.
   intro H. elim (rem_1542  H).
   intro H. elim (rem_1539  H).
  intros X1 X2. intro H. elim (rem_1534 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1538 X1 X2 H).
   intro H. elim (rem_1532  H).
  intros X1 X2;  exact (rem_1528 epsilon_m__def_69_mknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_1537 X1 X2 H).
   intro H. elim (rem_1531  H).
   intro H. elim (rem_1536  H).
   intro H. elim (rem_1540  H).
  intros X1. intro H. elim (rem_1530 X1 H).
   intro H. elim (rem_1543  H).
  intros X1 X2. intro H. elim (rem_1529 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1533 X1 X2 H).
   intro H. elim (rem_1535  H).
   intro H. elim (rem_1544  H).
   intro H. elim (rem_1541  H).
Qed.

Remark rem_1546 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_69 X4 -> auto_knows_current X4 -> auto_knows_current (cons X1 nil) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_1545 X4)). tauto.
Qed.

Remark rem_1547 : forall X1 X2 X3 X4:term, auto_knows_current X4 -> auto_knows_current (cons X1 nil) -> auto___def_57 X1 -> auto___def_69 X4 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_69 X4 -> auto_knows_current X4 -> auto_knows_current (cons X1 nil) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1546 X1 X2 X3 X4).
Qed.

Remark rem_1548 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_69 X4 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_124 X4 (cons X1 nil) H);  intros.
  apply (rem_1547 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1549 : forall X1 X2 X3 X4:term, auto_knows_current (l X2 X3) -> auto_knows_current (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___def_69 X4 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_69 X4 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current (l X2 X3) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1548 X1 X2 X3 X4).
Qed.

Remark rem_1550 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_69 X4 -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_124 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_1549 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1551 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_69 X4 -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current t_current -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_69 X4 -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1550 X1 X2 X3 X4).
Qed.

Remark rem_1552 : forall X1 X2 X3 X4:term, auto_knows_current t_current -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_57 X1 -> auto___def_69 X4 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_69 X4 -> auto_knows_current (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current t_current -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1551 X1 X2 X3 X4).
Qed.

Remark rem_1553 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_69 X4 -> auto_knows_current (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_124 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_1552 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1554 : forall X1 X2 X3 X4:term, auto_knows_current (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_69 X4 -> auto_knows_current (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1553 X1 X2 X3 X4).
Qed.

Remark rem_1555 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_69 X4 -> auto___def_84 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_14 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_132 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
Qed.

Remark rem_1556 : forall X1 X2 X3 X4:term, auto___def_84 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_14 (key sym (cons X3 (cons server nil))) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_69 X4 -> auto___def_84 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_14 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1555 X1 X2 X3 X4).
Qed.

Remark rem_1557 : (forall X:term, auto___def_19 X -> auto___def_73 X -> False)
    -> forall X1 X2:term, auto___def_73 (session_old X1 X2) -> auto_knows_old X1 -> auto_knows_old X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_19_m__def_73. intros X1 X2. intro H. intros.
  elim (rem_1519 X1 X2 H);  intros.
Defined.

Remark rem_1558 : (forall X:term, auto___def_19 X -> auto___def_73 X -> False)
    -> forall X1 X2:term, auto___def_19 (session_old X1 X2) -> auto___def_73 (session_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_19_m__def_73. intros X1 X2. intro H. intros.
  elim (rem_305 X1 X2 H);  intros.
  apply (rem_1557 epsilon_m__def_19_m__def_73 X1 X2);  tauto.
Defined.

Remark rem_1559 : forall X2:term, auto___def_19 X2 -> auto___def_73 X2 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_19_m__def_73 1.
  intro X. case X.
   intro H. elim (rem_320  H).
   intro H. elim (rem_316  H).
  intros X1 X2. intro H. elim (rem_311 X1 X2 H).
  intros X1 X2. intro H. elim (rem_315 X1 X2 H).
   intro H. elim (rem_310  H).
  intros X1 X2. intro H. elim (rem_317 X1 X2 H).
  intros X1 X2. intro H. elim (rem_314 X1 X2 H).
   intro H. elim (rem_309  H).
   intro H. elim (rem_313  H).
   intro H. elim (rem_318  H).
  intros X1. intro H. elim (rem_308 X1 H).
   intro H. elim (rem_321  H).
  intros X1 X2. intro H. elim (rem_307 X1 X2 H).
  intros X1 X2;  exact (rem_1558 epsilon_m__def_19_m__def_73 X1 X2).
   intro H. elim (rem_312  H).
   intro H. elim (rem_322  H).
   intro H. elim (rem_319  H).
Qed.

Remark rem_1560 : (forall X:term, auto___def_69 X -> auto___def_16 X -> False)
    -> forall X2:term, auto___def_19 X2 -> auto___def_73 X2 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_69_m__def_16. exact (rem_1559).
Defined.

Remark rem_1561 : (forall X:term, auto___def_69 X -> auto___def_16 X -> False)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_63 X1 -> auto___def_73 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_69_m__def_16. intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_73 X2 -> False). clear  epsilon_m__def_69_m__def_16. tauto.
  exact (rem_1560 epsilon_m__def_69_m__def_16 X2).
Defined.

Remark rem_1562 : (forall X:term, auto___def_69 X -> auto___def_16 X -> False)
    -> forall X1 X2:term, auto___def_16 (key X1 X2) -> auto___def_63 X1 -> auto___def_73 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_69_m__def_16. intros X1 X2. intro H. intros.
  elim (rem_1088 X1 X2 H);  intros.
  apply (rem_1561 epsilon_m__def_69_m__def_16 X1 X2);  tauto.
Defined.

Remark rem_1563 : (forall X:term, auto___def_69 X -> auto___def_16 X -> False)
    -> forall X1 X2:term, auto___def_69 (key X1 X2) -> auto___def_16 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_69_m__def_16. intros X1 X2. intro H. intros.
  elim (rem_687 X1 X2 H);  intros.
  apply (rem_1562 epsilon_m__def_69_m__def_16 X1 X2);  tauto.
Defined.

Remark rem_1564 : forall X1:term, auto___def_69 X1 -> auto___def_16 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_69_m__def_16 1.
  intro X. case X.
   intro H. elim (rem_1542  H).
   intro H. elim (rem_1539  H).
  intros X1 X2. intro H. elim (rem_1534 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1538 X1 X2 H).
   intro H. elim (rem_1532  H).
  intros X1 X2;  exact (rem_1563 epsilon_m__def_69_m__def_16 X1 X2).
  intros X1 X2. intro H. elim (rem_1537 X1 X2 H).
   intro H. elim (rem_1531  H).
   intro H. elim (rem_1536  H).
   intro H. elim (rem_1540  H).
  intros X1. intro H. elim (rem_1530 X1 H).
   intro H. elim (rem_1543  H).
  intros X1 X2. intro H. elim (rem_1529 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1533 X1 X2 H).
   intro H. elim (rem_1535  H).
   intro H. elim (rem_1544  H).
   intro H. elim (rem_1541  H).
Qed.

Remark rem_1565 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_27 (cons X1 nil) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_57 X1 -> auto___def_69 X4 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_1564 X4)). tauto.
Qed.

Remark rem_1566 : forall X1 X2 X3 X4:term, auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_57 X1 -> auto___def_69 X4 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1094 X4 (cons X1 nil) H);  intros.
  apply (rem_1565 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1567 : forall X1 X2 X3 X4:term, auto_knows_old X2 -> auto_knows_old X3 -> auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_57 X1 -> auto___def_69 X4 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1566 X1 X2 X3 X4).
Qed.

Remark rem_1568 : forall X1 X2 X3 X4:term, auto___def_14 (l X2 X3) -> auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_618 X2 X3 H);  intros.
  apply (rem_1567 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1569 : forall X1 X2 X3 X4:term, auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_620 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_1568 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1570 : forall X1 X2 X3 X4:term, auto___def_18 sym -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1569 X1 X2 X3 X4).
Qed.

Remark rem_1571 : forall X1 X2 X3 X4:term, auto___def_18 sym -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_18 sym -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1570 X1 X2 X3 X4).
Qed.

Remark rem_1572 : forall X1 X2 X3 X4:term, auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_624 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1571 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1573 : forall X1 X2 X3 X4:term, auto___def_12 t_current -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1572 X1 X2 X3 X4).
Qed.

Remark rem_1574 : forall X1 X2 X3 X4:term, auto___def_12 t_current -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 t_current -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1573 X1 X2 X3 X4).
Qed.

Remark rem_1575 : forall X1 X2 X3 X4:term, auto___def_23 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_628 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_1574 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1576 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_17 (cons X1 nil) -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_57 X1 -> auto___def_69 X4 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_1564 X4)). tauto.
Qed.

Remark rem_1577 : forall X1 X2 X3 X4:term, auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_57 X1 -> auto___def_69 X4 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_738 X4 (cons X1 nil) H);  intros.
  apply (rem_1576 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1578 : forall X1 X2 X3 X4:term, auto_knows_old X2 -> auto_knows_old X3 -> auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_57 X1 -> auto___def_69 X4 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1577 X1 X2 X3 X4).
Qed.

Remark rem_1579 : forall X1 X2 X3 X4:term, auto___def_14 (l X2 X3) -> auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_618 X2 X3 H);  intros.
  apply (rem_1578 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1580 : forall X1 X2 X3 X4:term, auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_640 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_1579 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1581 : forall X1 X2 X3 X4:term, auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_18 sym -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1580 X1 X2 X3 X4).
Qed.

Remark rem_1582 : forall X1 X2 X3 X4:term, auto___def_18 sym -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_18 sym -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1581 X1 X2 X3 X4).
Qed.

Remark rem_1583 : forall X1 X2 X3 X4:term, auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_644 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1582 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1584 : forall X1 X2 X3 X4:term, auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_12 t_current -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1583 X1 X2 X3 X4).
Qed.

Remark rem_1585 : forall X1 X2 X3 X4:term, auto___def_12 t_current -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_12 t_current -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1584 X1 X2 X3 X4).
Qed.

Remark rem_1586 : forall X1 X2 X3 X4:term, auto___def_10 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_648 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_1585 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1587 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_69 X4 -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___type_13 X1). tauto. exact (rem_1459 X1).
Qed.

Remark rem_1588 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_69 X4 -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___type_10 X1). tauto. exact (rem_1464 X1).
Qed.

Remark rem_1589 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_69 X4 -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_652 X2).
Qed.

Remark rem_1590 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_69 X4 -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X3 -> auto_knows_current X3). tauto. exact (rem_654 X3).
Qed.

Remark rem_1591 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_69 X4 -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_61 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_61 X4 -> auto___def_61 X4). tauto. exact (rem_932 X4).
Qed.

Remark rem_1592 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_69 X4 -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_12 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_61 X4 -> auto___type_12 X4). tauto. exact (rem_958 X4).
Qed.

Remark rem_1593 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_69 X4 -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> (auto___type_13 X1 /\ auto___type_10 X1 /\ auto_knows_current X2 /\ auto_knows_current X3 /\ auto___def_61 X4 /\ auto___type_12 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto___type_13 X1). 2:apply (rem_1587 X1 X2 X3 X4);  assumption.
  cut (auto___type_10 X1). 2:apply (rem_1588 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1589 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X3). 2:apply (rem_1590 X1 X2 X3 X4);  assumption.
  cut (auto___def_61 X4). 2:apply (rem_1591 X1 X2 X3 X4);  assumption.
  cut (auto___type_12 X4). 2:apply (rem_1592 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_1594 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_69 X4 -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_1593 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_83_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_1595 : forall X1 X2 X3 X4:term, auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_61 X4 -> auto___def_62 (cons X1 nil) -> auto___def_69 X4 -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1594 X1 X2 X3 X4).
Qed.

Remark rem_1596 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_69 X4 -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_962 X4 (cons X1 nil) H);  intros.
  apply (rem_1595 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1597 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current X3 -> auto___def_57 X1 -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_69 X4 -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_69 X4 -> auto___def_75 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1596 X1 X2 X3 X4).
Qed.

Remark rem_1598 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_59 (l X2 X3) -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_69 X4 -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_661 X2 X3 H);  intros.
  apply (rem_1597 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1599 : forall X1 X2 X3 X4:term, auto___def_59 (l X2 X3) -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_59 (l X2 X3) -> auto___def_60 (cons X4 (cons X1 nil)) -> auto___def_69 X4 -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1598 X1 X2 X3 X4).
Qed.

Remark rem_1600 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_69 X4 -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_663 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_1599 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1601 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_63 sym -> auto___def_69 X4 -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_69 X4 -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1600 X1 X2 X3 X4).
Qed.

Remark rem_1602 : forall X1 X2 X3 X4:term, auto___def_63 sym -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_57 X1 -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_63 sym -> auto___def_69 X4 -> auto___def_75 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1601 X1 X2 X3 X4).
Qed.

Remark rem_1603 : forall X1 X2 X3 X4:term, auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_57 X1 -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_667 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1602 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1604 : forall X1 X2 X3 X4:term, auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_57 X1 -> auto___def_57 t_current -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_57 X1 -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1603 X1 X2 X3 X4).
Qed.

Remark rem_1605 : forall X1 X2 X3 X4:term, auto___def_57 t_current -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_57 X1 -> auto___def_57 t_current -> auto___def_58 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1604 X1 X2 X3 X4).
Qed.

Remark rem_1606 : forall X1 X2 X3 X4:term, auto___def_55 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_56 (key sym (cons X3 (cons server nil))) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_671 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_1605 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1607 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_61 X4 -> auto___def_69 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___type_13 X1). tauto. exact (rem_1459 X1).
Qed.

Remark rem_1608 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_61 X4 -> auto___def_69 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___type_10 X1). tauto. exact (rem_1464 X1).
Qed.

Remark rem_1609 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_61 X4 -> auto___def_69 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_652 X2).
Qed.

Remark rem_1610 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_61 X4 -> auto___def_69 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X3 -> auto_knows_current X3). tauto. exact (rem_654 X3).
Qed.

Remark rem_1611 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_61 X4 -> auto___def_69 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_61 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_61 X4 -> auto___def_61 X4). tauto. exact (rem_932 X4).
Qed.

Remark rem_1612 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_61 X4 -> auto___def_69 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___type_12 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_61 X4 -> auto___type_12 X4). tauto. exact (rem_958 X4).
Qed.

Remark rem_1613 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_61 X4 -> auto___def_69 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> (auto___type_13 X1 /\ auto___type_10 X1 /\ auto_knows_current X2 /\ auto_knows_current X3 /\ auto___def_61 X4 /\ auto___type_12 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto___type_13 X1). 2:apply (rem_1607 X1 X2 X3 X4);  assumption.
  cut (auto___type_10 X1). 2:apply (rem_1608 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1609 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X3). 2:apply (rem_1610 X1 X2 X3 X4);  assumption.
  cut (auto___def_61 X4). 2:apply (rem_1611 X1 X2 X3 X4);  assumption.
  cut (auto___type_12 X4). 2:apply (rem_1612 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_1614 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_61 X4 -> auto___def_69 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_1613 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_83_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_1615 : forall X1 X2 X3 X4:term, auto___def_61 X4 -> auto___def_72 (cons X1 nil) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_61 X4 -> auto___def_69 X4 -> auto___def_72 (cons X1 nil) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1614 X1 X2 X3 X4).
Qed.

Remark rem_1616 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_69 X4 -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_981 X4 (cons X1 nil) H);  intros.
  apply (rem_1615 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1617 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current X3 -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_69 X4 -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1616 X1 X2 X3 X4).
Qed.

Remark rem_1618 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_59 (l X2 X3) -> auto___def_69 X4 -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_661 X2 X3 H);  intros.
  apply (rem_1617 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1619 : forall X1 X2 X3 X4:term, auto___def_59 (l X2 X3) -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_59 (l X2 X3) -> auto___def_69 X4 -> auto___def_71 (cons X4 (cons X1 nil)) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1618 X1 X2 X3 X4).
Qed.

Remark rem_1620 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_69 X4 -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_683 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_1619 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1621 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_63 sym -> auto___def_69 X4 -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_69 X4 -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1620 X1 X2 X3 X4).
Qed.

Remark rem_1622 : forall X1 X2 X3 X4:term, auto___def_63 sym -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_63 sym -> auto___def_69 X4 -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_73 (cons X3 (cons server nil)) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1621 X1 X2 X3 X4).
Qed.

Remark rem_1623 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_69 X4 -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_687 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1622 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1624 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_57 t_current -> auto___def_69 X4 -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_69 X4 -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1623 X1 X2 X3 X4).
Qed.

Remark rem_1625 : forall X1 X2 X3 X4:term, auto___def_57 t_current -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_57 t_current -> auto___def_69 X4 -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_70 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1624 X1 X2 X3 X4).
Qed.

Remark rem_1626 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_68 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_69 X4 -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_691 t_current (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_1625 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1627 : forall X1 X2 X3 X4:term, auto___def_68 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_57 X1 -> auto___def_69 X4 -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_68 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_69 X4 -> auto___def_69 (key sym (cons X3 (cons server nil))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1626 X1 X2 X3 X4).
Qed.

Remark rem_1628 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_69 X4 -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_693 (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil))) H);  intros.
  apply (rem_1516 X1 X2 X3 X4);  tauto.
  apply (rem_1554 X1 X2 X3 X4);  tauto.
  apply (rem_1556 X1 X2 X3 X4);  tauto.
  apply (rem_1575 X1 X2 X3 X4);  tauto.
  apply (rem_1586 X1 X2 X3 X4);  tauto.
  apply (rem_1606 X1 X2 X3 X4);  tauto.
  apply (rem_1627 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1629 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_69 X4 -> auto___def_70 (cons t_current nil) -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_69 X4 -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1628 X1 X2 X3 X4).
Qed.

Remark rem_1630 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_70 (cons t_current nil) -> auto___def_69 X4 -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_69 X4 -> auto___def_70 (cons t_current nil) -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1629 X1 X2 X3 X4).
Qed.

Remark rem_1631 : forall X1 X2 X3 X4:term, auto___def_68 (cons X1 (cons t_current nil)) -> auto___def_69 X4 -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_691 X1 (cons t_current nil) H);  intros.
  apply (rem_1630 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1632 : forall X1 X2 X3 X4:term, auto_knows_current (crypt (cons X1 (cons t_current nil)) X4) -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_693 (cons X1 (cons t_current nil)) X4 H);  intros.
  apply (rem_697 X1 X2 X3 X4);  tauto.
  apply (rem_996 X1 X2 X3 X4);  tauto.
  apply (rem_997 X1 X2 X3 X4);  tauto.
  apply (rem_1189 X1 X2 X3 X4);  tauto.
  apply (rem_1333 X1 X2 X3 X4);  tauto.
  apply (rem_1509 X1 X2 X3 X4);  tauto.
  apply (rem_1631 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1633 : forall X1 X2 X3 X4:term, auto_knows_current (crypt (cons X1 (cons t_current nil)) X4) -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto_knows_current nil -> auto___def_83 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current (crypt (cons X1 (cons t_current nil)) X4) -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4). tauto.
  exact (rem_1632 X1 X2 X3 X4).
Qed.

Remark rem_1634 : forall X1 X2 X3 X4:term, auto_knows_current (crypt (cons X1 (cons t_current nil)) X4) -> auto_knows_current nil -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current (crypt (cons X1 (cons t_current nil)) X4) -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto_knows_current nil -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1633 X1 X2 X3 X4).
Qed.

Remark rem_1635 : forall X1 X2 X3 X4:term, auto_knows_current (cons (crypt (cons X1 (cons t_current nil)) X4) nil) -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_124 (crypt (cons X1 (cons t_current nil)) X4) nil H);  intros.
  apply (rem_1634 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1636 : forall X1 X2 X3 X4:term, auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto_knows_current (cons (crypt (cons X1 (cons t_current nil)) X4) nil) -> auto___def_83 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current (cons (crypt (cons X1 (cons t_current nil)) X4) nil) -> auto_knows_current (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_83 X1 X2 X3 X4). tauto. exact (rem_1635 X1 X2 X3 X4).
Qed.

Remark rem_1637 : forall X1 X2 X3 X4:term, auto_knows_current (cons (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) (cons (crypt (cons X1 (cons t_current nil)) X4) nil)) -> auto___def_83 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_124 (crypt (cons t_current (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) (cons (crypt (cons X1 (cons t_current nil)) X4) nil) H);  intros.
  apply (rem_1636 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1638 : forall X1:term, auto___def_78 X1 -> auto___def_78 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1639 : forall X1 X2:term, auto___def_78 X1 -> auto___def_79 X2 -> auto___def_78 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_78 X1 -> auto___def_78 X1). tauto. exact (rem_1638 X1).
Qed.

Remark rem_1640 : forall X2:term, auto___def_79 X2 -> auto___def_79 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1641 : forall X1 X2:term, auto___def_78 X1 -> auto___def_79 X2 -> auto___def_79 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_79 X2 -> auto___def_79 X2). tauto. exact (rem_1640 X2).
Qed.

Remark rem_1642 : forall X1 X2:term, auto___def_78 X1 -> auto___def_79 X2 -> (auto___def_78 X1 /\ auto___def_79 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_78 X1). 2:apply (rem_1639 X1 X2);  assumption.
  cut (auto___def_79 X2). 2:apply (rem_1641 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1643 : forall X1 X2:term, auto___def_78 X1 -> auto___def_79 X2 -> auto___def_77 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1642 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_77_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1644 : forall X1 X2:term, auto___def_79 X2 -> auto___def_78 X1 -> auto___def_77 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_78 X1 -> auto___def_79 X2 -> auto___def_77 (cons X1 X2)). tauto. exact (rem_1643 X1 X2).
Qed.

Remark rem_1645 : forall X1:term, auto___def_80 X1 -> auto___def_80 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1646 : forall X1 X2:term, auto___def_63 sym -> auto___def_64 X2 -> auto___def_80 X1 -> auto___def_80 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_80 X1 -> auto___def_80 X1). tauto. exact (rem_1645 X1).
Qed.

Remark rem_1647 : forall X2:term, auto___def_64 X2 -> auto___def_64 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1648 : forall X1 X2:term, auto___def_63 sym -> auto___def_64 X2 -> auto___def_80 X1 -> auto___def_64 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_64 X2 -> auto___def_64 X2). tauto. exact (rem_1647 X2).
Qed.

Remark rem_1649 : forall X1 X2:term, auto___def_63 sym -> auto___def_64 X2 -> auto___def_80 X1 -> (auto___def_80 X1 /\ auto___def_64 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_80 X1). 2:apply (rem_1646 X1 X2);  assumption.
  cut (auto___def_64 X2). 2:apply (rem_1648 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1650 : forall X1 X2:term, auto___def_63 sym -> auto___def_64 X2 -> auto___def_80 X1 -> auto___def_52 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1649 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_52_7;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1651 : forall X1 X2:term, auto___def_80 X1 -> auto___type_12 (key sym X2) -> auto___def_52 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_103 sym X2 H);  intros.
  apply (rem_1650 X1 X2);  tauto.
Qed.

Remark rem_1652 : auto___def_42 sym -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_49 H);  intros.
Qed.

Remark rem_1653 : forall X1 X2:term, auto___def_42 sym -> auto_knows_current X1 -> auto___def_52 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_42 sym -> False). tauto.
  exact (rem_1652).
Qed.

Remark rem_1654 : forall X1 X2:term, auto___def_42 sym -> auto___type_8 X2 -> auto_knows_current X1 -> auto___def_52 X1 X2. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2. intros. apply (rem_1653 X1 X2);  assumption.
Qed.

Remark rem_1655 : forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1656 : forall X1 X2:term, auto___def_46 sym -> auto___def_47 X2 -> auto_knows_current X1 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_1655 X1).
Qed.

Remark rem_1657 : forall X2:term, auto___def_47 X2 -> auto___def_47 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1658 : forall X1 X2:term, auto___def_46 sym -> auto___def_47 X2 -> auto_knows_current X1 -> auto___def_47 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_47 X2 -> auto___def_47 X2). tauto. exact (rem_1657 X2).
Qed.

Remark rem_1659 : forall X1 X2:term, auto___def_46 sym -> auto___def_47 X2 -> auto_knows_current X1 -> (auto_knows_current X1 /\ auto___def_47 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto_knows_current X1). 2:apply (rem_1656 X1 X2);  assumption.
  cut (auto___def_47 X2). 2:apply (rem_1658 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1660 : forall X1 X2:term, auto___def_46 sym -> auto___def_47 X2 -> auto_knows_current X1 -> auto___def_52 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1659 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_52_2;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1661 : auto___def_43 sym -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_95 H);  intros.
Qed.

Remark rem_1662 : forall X1 X2:term, auto___def_43 sym -> auto___def_44 X2 -> auto_knows_current X1 -> auto___def_52 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_43 sym -> False). tauto.
  exact (rem_1661).
Qed.

Remark rem_1663 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current (key sym X2) -> auto___def_52 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_101 sym X2 H);  intros.
  apply (rem_1654 X1 X2);  tauto.
  apply (rem_1660 X1 X2);  tauto.
  apply (rem_1662 X1 X2);  tauto.
Qed.

Remark rem_1664 : forall X1:term, auto___def_84 X1 -> auto___def_84 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1665 : forall X1 X2:term, auto___def_63 sym -> auto___def_64 X2 -> auto___def_84 X1 -> auto___def_84 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_84 X1 -> auto___def_84 X1). tauto. exact (rem_1664 X1).
Qed.

Remark rem_1666 : forall X1 X2:term, auto___def_63 sym -> auto___def_64 X2 -> auto___def_84 X1 -> auto___def_64 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_64 X2 -> auto___def_64 X2). tauto. exact (rem_1647 X2).
Qed.

Remark rem_1667 : forall X1 X2:term, auto___def_63 sym -> auto___def_64 X2 -> auto___def_84 X1 -> (auto___def_84 X1 /\ auto___def_64 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_84 X1). 2:apply (rem_1665 X1 X2);  assumption.
  cut (auto___def_64 X2). 2:apply (rem_1666 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1668 : forall X1 X2:term, auto___def_63 sym -> auto___def_64 X2 -> auto___def_84 X1 -> auto___def_52 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1667 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_52_6;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1669 : forall X1 X2:term, auto___type_14 (key X1 X2) -> or_1
    (auto___def_63 X1 /\ auto___def_64 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1670 : forall X1 X2:term, auto___def_84 X1 -> auto___type_14 (key sym X2) -> auto___def_52 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_1669 sym X2 H);  intros.
  apply (rem_1668 X1 X2);  tauto.
Qed.

Remark rem_1671 : forall X1:term, auto___def_23 X1 -> auto___def_23 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1672 : forall X1 X2:term, auto___def_18 sym -> auto___def_23 X1 -> auto___def_28 X2 -> auto___def_23 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_23 X1 -> auto___def_23 X1). tauto. exact (rem_1671 X1).
Qed.

Remark rem_1673 : forall X2:term, auto___def_28 X2 -> auto___def_28 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1674 : forall X1 X2:term, auto___def_18 sym -> auto___def_23 X1 -> auto___def_28 X2 -> auto___def_28 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_28 X2 -> auto___def_28 X2). tauto. exact (rem_1673 X2).
Qed.

Remark rem_1675 : forall X1 X2:term, auto___def_18 sym -> auto___def_23 X1 -> auto___def_28 X2 -> (auto___def_23 X1 /\ auto___def_28 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_23 X1). 2:apply (rem_1672 X1 X2);  assumption.
  cut (auto___def_28 X2). 2:apply (rem_1674 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1676 : forall X1 X2:term, auto___def_18 sym -> auto___def_23 X1 -> auto___def_28 X2 -> auto___def_52 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1675 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_52_3;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1677 : forall X1 X2:term, auto___def_18 sym -> auto___def_28 X2 -> auto___def_23 X1 -> auto___def_52 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_18 sym -> auto___def_23 X1 -> auto___def_28 X2 -> auto___def_52 X1 X2). tauto. exact (rem_1676 X1 X2).
Qed.

Remark rem_1678 : forall X1 X2:term, auto___def_23 X1 -> auto___def_24 (key sym X2) -> auto___def_52 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_624 sym X2 H);  intros.
  apply (rem_1677 X1 X2);  tauto.
Qed.

Remark rem_1679 : forall X1:term, auto___def_10 X1 -> auto___def_10 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1680 : forall X1 X2:term, auto___def_10 X1 -> auto___def_18 sym -> auto___def_32 X2 -> auto___def_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_10 X1). tauto. exact (rem_1679 X1).
Qed.

Remark rem_1681 : forall X2:term, auto___def_32 X2 -> auto___def_32 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1682 : forall X1 X2:term, auto___def_10 X1 -> auto___def_18 sym -> auto___def_32 X2 -> auto___def_32 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_32 X2 -> auto___def_32 X2). tauto. exact (rem_1681 X2).
Qed.

Remark rem_1683 : forall X1 X2:term, auto___def_10 X1 -> auto___def_18 sym -> auto___def_32 X2 -> (auto___def_10 X1 /\ auto___def_32 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_10 X1). 2:apply (rem_1680 X1 X2);  assumption.
  cut (auto___def_32 X2). 2:apply (rem_1682 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1684 : forall X1 X2:term, auto___def_10 X1 -> auto___def_18 sym -> auto___def_32 X2 -> auto___def_52 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1683 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_52_4;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1685 : forall X1 X2:term, auto___def_18 sym -> auto___def_32 X2 -> auto___def_10 X1 -> auto___def_52 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_18 sym -> auto___def_32 X2 -> auto___def_52 X1 X2). tauto. exact (rem_1684 X1 X2).
Qed.

Remark rem_1686 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 (key sym X2) -> auto___def_52 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_644 sym X2 H);  intros.
  apply (rem_1685 X1 X2);  tauto.
Qed.

Remark rem_1687 : forall X1:term, auto___def_55 X1 -> auto___def_55 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1688 : forall X1 X2:term, auto___def_55 X1 -> auto___def_63 sym -> auto___def_75 X2 -> auto___def_55 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_55 X1 -> auto___def_55 X1). tauto. exact (rem_1687 X1).
Qed.

Remark rem_1689 : forall X2:term, auto___def_75 X2 -> auto___def_75 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1690 : forall X1 X2:term, auto___def_55 X1 -> auto___def_63 sym -> auto___def_75 X2 -> auto___def_75 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_75 X2 -> auto___def_75 X2). tauto. exact (rem_1689 X2).
Qed.

Remark rem_1691 : forall X1 X2:term, auto___def_55 X1 -> auto___def_63 sym -> auto___def_75 X2 -> (auto___def_55 X1 /\ auto___def_75 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_55 X1). 2:apply (rem_1688 X1 X2);  assumption.
  cut (auto___def_75 X2). 2:apply (rem_1690 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1692 : forall X1 X2:term, auto___def_55 X1 -> auto___def_63 sym -> auto___def_75 X2 -> auto___def_52 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1691 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_52_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1693 : forall X1 X2:term, auto___def_63 sym -> auto___def_75 X2 -> auto___def_55 X1 -> auto___def_52 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_55 X1 -> auto___def_63 sym -> auto___def_75 X2 -> auto___def_52 X1 X2). tauto. exact (rem_1692 X1 X2).
Qed.

Remark rem_1694 : forall X1 X2:term, auto___def_55 X1 -> auto___def_56 (key sym X2) -> auto___def_52 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_667 sym X2 H);  intros.
  apply (rem_1693 X1 X2);  tauto.
Qed.

Remark rem_1695 : forall X1:term, auto___def_68 X1 -> auto___def_68 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1696 : forall X1 X2:term, auto___def_63 sym -> auto___def_68 X1 -> auto___def_73 X2 -> auto___def_68 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_68 X1 -> auto___def_68 X1). tauto. exact (rem_1695 X1).
Qed.

Remark rem_1697 : forall X2:term, auto___def_73 X2 -> auto___def_73 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1698 : forall X1 X2:term, auto___def_63 sym -> auto___def_68 X1 -> auto___def_73 X2 -> auto___def_73 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_73 X2 -> auto___def_73 X2). tauto. exact (rem_1697 X2).
Qed.

Remark rem_1699 : forall X1 X2:term, auto___def_63 sym -> auto___def_68 X1 -> auto___def_73 X2 -> (auto___def_68 X1 /\ auto___def_73 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_68 X1). 2:apply (rem_1696 X1 X2);  assumption.
  cut (auto___def_73 X2). 2:apply (rem_1698 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1700 : forall X1 X2:term, auto___def_63 sym -> auto___def_68 X1 -> auto___def_73 X2 -> auto___def_52 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1699 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_52_5;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1701 : forall X1 X2:term, auto___def_63 sym -> auto___def_73 X2 -> auto___def_68 X1 -> auto___def_52 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_63 sym -> auto___def_68 X1 -> auto___def_73 X2 -> auto___def_52 X1 X2). tauto. exact (rem_1700 X1 X2).
Qed.

Remark rem_1702 : forall X1 X2:term, auto___def_68 X1 -> auto___def_69 (key sym X2) -> auto___def_52 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_687 sym X2 H);  intros.
  apply (rem_1701 X1 X2);  tauto.
Qed.

Remark rem_1703 : forall X1 X2:term, auto_knows_current (crypt X1 (key sym X2)) -> auto___def_52 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_693 X1 (key sym X2) H);  intros.
  apply (rem_1651 X1 X2);  tauto.
  apply (rem_1663 X1 X2);  tauto.
  apply (rem_1670 X1 X2);  tauto.
  apply (rem_1678 X1 X2);  tauto.
  apply (rem_1686 X1 X2);  tauto.
  apply (rem_1694 X1 X2);  tauto.
  apply (rem_1702 X1 X2);  tauto.
Qed.

Remark rem_1704 : forall X1:term, auto___def_18 X1 -> auto___def_18 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1705 : forall X1 X2:term, auto___def_18 X1 -> auto___def_28 X2 -> auto___def_18 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_18 X1). tauto. exact (rem_1704 X1).
Qed.

Remark rem_1706 : forall X1 X2:term, auto___def_18 X1 -> auto___def_28 X2 -> auto___def_28 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_28 X2 -> auto___def_28 X2). tauto. exact (rem_1673 X2).
Qed.

Remark rem_1707 : forall X1 X2:term, auto___def_18 X1 -> auto___def_28 X2 -> (auto___def_18 X1 /\ auto___def_28 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_18 X1). 2:apply (rem_1705 X1 X2);  assumption.
  cut (auto___def_28 X2). 2:apply (rem_1706 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1708 : forall X1 X2:term, auto___def_18 X1 -> auto___def_28 X2 -> auto___def_24 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1707 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_24_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1709 : forall X1 X2:term, auto___def_28 X2 -> auto___def_18 X1 -> auto___def_24 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_28 X2 -> auto___def_24 (key X1 X2)). tauto. exact (rem_1708 X1 X2).
Qed.

Remark rem_1710 : forall X1:term, auto___def_39 X1 -> auto___def_39 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1711 : forall X1 X2:term, auto___def_31 X2 -> auto___def_39 X1 -> auto___def_39 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_39 X1 -> auto___def_39 X1). tauto. exact (rem_1710 X1).
Qed.

Remark rem_1712 : forall X2:term, auto___def_31 X2 -> auto___def_31 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1713 : forall X1 X2:term, auto___def_31 X2 -> auto___def_39 X1 -> auto___def_31 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_31 X2 -> auto___def_31 X2). tauto. exact (rem_1712 X2).
Qed.

Remark rem_1714 : forall X1 X2:term, auto___def_31 X2 -> auto___def_39 X1 -> (auto___def_39 X1 /\ auto___def_31 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_39 X1). 2:apply (rem_1711 X1 X2);  assumption.
  cut (auto___def_31 X2). 2:apply (rem_1713 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1715 : forall X1 X2:term, auto___def_31 X2 -> auto___def_39 X1 -> auto___def_38 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1714 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_38_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1716 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1717 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1. intros A1.
  cut (auto_knows_old X1). 2:apply (rem_1716 epsilon_mknows_old_p__type_6 X1);  assumption.
  tauto.
Defined.

Remark rem_1718 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1:term, auto_knows_old X1 -> auto___type_6 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1. intros A1.
  case (rem_1717 epsilon_mknows_old_p__type_6 X1 A1). clear  epsilon_mknows_old_p__type_6 A1. intros. apply trans___type_6_s_1;  tauto.
 clear  epsilon_mknows_old_p__type_6 A1. tauto.
Defined.

Remark rem_1719 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1:term, auto_knows_old (s X1) -> auto___type_6 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1. intro H. intros.
  elim (rem_241 X1 H);  intros.
  apply (rem_1718 epsilon_mknows_old_p__type_6 X1);  tauto.
Defined.

Remark rem_1720 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_6.  tauto.
Defined.

Remark rem_1721 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> auto___type_6 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_6.  case (rem_1720 epsilon_mknows_old_p__type_6). clear  epsilon_mknows_old_p__type_6. intros. apply trans___type_6_nil_1;  tauto.
 clear  epsilon_mknows_old_p__type_6. tauto.
Defined.

Remark rem_1722 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> auto_knows_old nil -> auto___type_6 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intro H. intros.
  elim (rem_245 H);  intros.
  apply (rem_1721 epsilon_mknows_old_p__type_6);  tauto.
Defined.

Remark rem_1723 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> auto___type_6 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_6.  case (rem_1720 epsilon_mknows_old_p__type_6). clear  epsilon_mknows_old_p__type_6. intros. apply trans___type_6_i_1;  tauto.
 clear  epsilon_mknows_old_p__type_6. tauto.
Defined.

Remark rem_1724 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> auto_knows_old i -> auto___type_6 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intro H. intros.
  elim (rem_248 H);  intros.
  apply (rem_1723 epsilon_mknows_old_p__type_6);  tauto.
Defined.

Remark rem_1725 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2.
  cut (auto_knows_old X1 -> auto_knows_old X1). tauto. exact (rem_1716 epsilon_mknows_old_p__type_6 X1).
Defined.

Remark rem_1726 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X2:term, auto_knows_old X2 -> auto_knows_old X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1727 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_1726 epsilon_mknows_old_p__type_6 X2).
Defined.

Remark rem_1728 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> (auto_knows_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_1725 epsilon_mknows_old_p__type_6 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_1727 epsilon_mknows_old_p__type_6 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1729 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_6 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2. intros A1 A2.
  case (rem_1728 epsilon_mknows_old_p__type_6 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_6 A1 A2. intros. apply trans___type_6_cons_1;  tauto.
 clear  epsilon_mknows_old_p__type_6 A1 A2. tauto.
Defined.

Remark rem_1730 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto_knows_old (cons X1 X2) -> auto___type_6 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2. intro H. intros.
  elim (rem_255 X1 X2 H);  intros.
  apply (rem_1729 epsilon_mknows_old_p__type_6 X1 X2);  tauto.
Defined.

Remark rem_1731 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_6 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2. intros A1 A2.
  case (rem_1728 epsilon_mknows_old_p__type_6 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_6 A1 A2. intros. apply trans___type_6_crypt_1;  tauto.
 clear  epsilon_mknows_old_p__type_6 A1 A2. tauto.
Defined.

Remark rem_1732 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1:term, auto___def_37 X1 -> auto___def_37 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1733 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> auto___def_37 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2.
  cut (auto___def_37 X1 -> auto___def_37 X1). tauto. exact (rem_1732 epsilon_mknows_old_p__type_6 X1).
Defined.

Remark rem_1734 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X2:term, auto___type_5 X2 -> auto___type_5 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1735 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> auto___type_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2.
  cut (auto___type_5 X2 -> auto___type_5 X2). tauto. exact (rem_1734 epsilon_mknows_old_p__type_6 X2).
Defined.

Remark rem_1736 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> (auto___def_37 X1 /\ auto___type_5 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2. intros A1 A2.
  cut (auto___def_37 X1). 2:apply (rem_1733 epsilon_mknows_old_p__type_6 X1 X2);  assumption.
  cut (auto___type_5 X2). 2:apply (rem_1735 epsilon_mknows_old_p__type_6 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1737 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> auto___type_6 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2. intros A1 A2.
  case (rem_1736 epsilon_mknows_old_p__type_6 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_6 A1 A2. intros. apply trans___type_6_crypt_2;  tauto.
 clear  epsilon_mknows_old_p__type_6 A1 A2. tauto.
Defined.

Remark rem_1738 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1:term, auto___def_23 X1 -> auto___def_23 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1739 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_23 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2.
  cut (auto___def_23 X1 -> auto___def_23 X1). tauto. exact (rem_1738 epsilon_mknows_old_p__type_6 X1).
Defined.

Remark rem_1740 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X2:term, auto___def_24 X2 -> auto___def_24 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1741 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_24 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2.
  cut (auto___def_24 X2 -> auto___def_24 X2). tauto. exact (rem_1740 epsilon_mknows_old_p__type_6 X2).
Defined.

Remark rem_1742 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> (auto___def_23 X1 /\ auto___def_24 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2. intros A1 A2.
  cut (auto___def_23 X1). 2:apply (rem_1739 epsilon_mknows_old_p__type_6 X1 X2);  assumption.
  cut (auto___def_24 X2). 2:apply (rem_1741 epsilon_mknows_old_p__type_6 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1743 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___type_6 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2. intros A1 A2.
  case (rem_1742 epsilon_mknows_old_p__type_6 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_6 A1 A2. intros. apply trans___type_6_crypt_3;  tauto.
 clear  epsilon_mknows_old_p__type_6 A1 A2. tauto.
Defined.

Remark rem_1744 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1:term, auto___def_10 X1 -> auto___def_10 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1745 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_10 X1). tauto. exact (rem_1744 epsilon_mknows_old_p__type_6 X1).
Defined.

Remark rem_1746 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X2:term, auto___def_11 X2 -> auto___def_11 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1747 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2.
  cut (auto___def_11 X2 -> auto___def_11 X2). tauto. exact (rem_1746 epsilon_mknows_old_p__type_6 X2).
Defined.

Remark rem_1748 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> (auto___def_10 X1 /\ auto___def_11 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2. intros A1 A2.
  cut (auto___def_10 X1). 2:apply (rem_1745 epsilon_mknows_old_p__type_6 X1 X2);  assumption.
  cut (auto___def_11 X2). 2:apply (rem_1747 epsilon_mknows_old_p__type_6 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1749 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___type_6 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2. intros A1 A2.
  case (rem_1748 epsilon_mknows_old_p__type_6 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_6 A1 A2. intros. apply trans___type_6_crypt_4;  tauto.
 clear  epsilon_mknows_old_p__type_6 A1 A2. tauto.
Defined.

Remark rem_1750 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1:term, auto___def_41 X1 -> auto___def_41 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1751 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> auto___def_41 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2.
  cut (auto___def_41 X1 -> auto___def_41 X1). tauto. exact (rem_1750 epsilon_mknows_old_p__type_6 X1).
Defined.

Remark rem_1752 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X2:term, auto___type_7 X2 -> auto___type_7 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1753 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> auto___type_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2.
  cut (auto___type_7 X2 -> auto___type_7 X2). tauto. exact (rem_1752 epsilon_mknows_old_p__type_6 X2).
Defined.

Remark rem_1754 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> (auto___def_41 X1 /\ auto___type_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2. intros A1 A2.
  cut (auto___def_41 X1). 2:apply (rem_1751 epsilon_mknows_old_p__type_6 X1 X2);  assumption.
  cut (auto___type_7 X2). 2:apply (rem_1753 epsilon_mknows_old_p__type_6 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1755 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> auto___type_6 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2. intros A1 A2.
  case (rem_1754 epsilon_mknows_old_p__type_6 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_6 A1 A2. intros. apply trans___type_6_crypt_5;  tauto.
 clear  epsilon_mknows_old_p__type_6 A1 A2. tauto.
Defined.

Remark rem_1756 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto_knows_old (crypt X1 X2) -> auto___type_6 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2. intro H. intros.
  elim (rem_565 X1 X2 H);  intros.
  apply (rem_1731 epsilon_mknows_old_p__type_6 X1 X2);  tauto.
  apply (rem_1737 epsilon_mknows_old_p__type_6 X1 X2);  tauto.
  apply (rem_1743 epsilon_mknows_old_p__type_6 X1 X2);  tauto.
  apply (rem_1749 epsilon_mknows_old_p__type_6 X1 X2);  tauto.
  apply (rem_1755 epsilon_mknows_old_p__type_6 X1 X2);  tauto.
Defined.

Remark rem_1757 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> auto___type_6 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_6.  case (rem_1720 epsilon_mknows_old_p__type_6). clear  epsilon_mknows_old_p__type_6. intros. apply trans___type_6_bob_1;  tauto.
 clear  epsilon_mknows_old_p__type_6. tauto.
Defined.

Remark rem_1758 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> auto_knows_old bob -> auto___type_6 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intro H. intros.
  elim (rem_568 H);  intros.
  apply (rem_1757 epsilon_mknows_old_p__type_6);  tauto.
Defined.

Remark rem_1759 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1:term, auto___def_42 X1 -> auto___def_42 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1760 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___def_42 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2.
  cut (auto___def_42 X1 -> auto___def_42 X1). tauto. exact (rem_1759 epsilon_mknows_old_p__type_6 X1).
Defined.

Remark rem_1761 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1762 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_1761 epsilon_mknows_old_p__type_6 X2).
Defined.

Remark rem_1763 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> (auto___def_42 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2. intros A1 A2.
  cut (auto___def_42 X1). 2:apply (rem_1760 epsilon_mknows_old_p__type_6 X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_1762 epsilon_mknows_old_p__type_6 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1764 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___type_6 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2. intros A1 A2.
  case (rem_1763 epsilon_mknows_old_p__type_6 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_6 A1 A2. intros. apply trans___type_6_key_1;  tauto.
 clear  epsilon_mknows_old_p__type_6 A1 A2. tauto.
Defined.

Remark rem_1765 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1:term, auto___def_43 X1 -> auto___def_43 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1766 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_43 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_43 X1). tauto. exact (rem_1765 epsilon_mknows_old_p__type_6 X1).
Defined.

Remark rem_1767 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X2:term, auto___def_44 X2 -> auto___def_44 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1768 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_44 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2.
  cut (auto___def_44 X2 -> auto___def_44 X2). tauto. exact (rem_1767 epsilon_mknows_old_p__type_6 X2).
Defined.

Remark rem_1769 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> (auto___def_43 X1 /\ auto___def_44 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2. intros A1 A2.
  cut (auto___def_43 X1). 2:apply (rem_1766 epsilon_mknows_old_p__type_6 X1 X2);  assumption.
  cut (auto___def_44 X2). 2:apply (rem_1768 epsilon_mknows_old_p__type_6 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1770 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___type_6 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2. intros A1 A2.
  case (rem_1769 epsilon_mknows_old_p__type_6 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_6 A1 A2. intros. apply trans___type_6_key_2;  tauto.
 clear  epsilon_mknows_old_p__type_6 A1 A2. tauto.
Defined.

Remark rem_1771 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> forall X1 X2:term, auto_knows_old (key X1 X2) -> auto___type_6 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intros X1 X2. intro H. intros.
  elim (rem_582 X1 X2 H);  intros.
  apply (rem_1764 epsilon_mknows_old_p__type_6 X1 X2);  tauto.
  apply (rem_1770 epsilon_mknows_old_p__type_6 X1 X2);  tauto.
Defined.

Remark rem_1772 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> auto___type_6 t_old. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_6.  case (rem_1720 epsilon_mknows_old_p__type_6). clear  epsilon_mknows_old_p__type_6. intros. apply trans___type_6_t_old_1;  tauto.
 clear  epsilon_mknows_old_p__type_6. tauto.
Defined.

Remark rem_1773 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> auto_knows_old t_old -> auto___type_6 t_old. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intro H. intros.
  elim (rem_585 H);  intros.
  apply (rem_1772 epsilon_mknows_old_p__type_6);  tauto.
Defined.

Remark rem_1774 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> auto___type_6 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_6.  case (rem_1720 epsilon_mknows_old_p__type_6). clear  epsilon_mknows_old_p__type_6. intros. apply trans___type_6_alice_1;  tauto.
 clear  epsilon_mknows_old_p__type_6. tauto.
Defined.

Remark rem_1775 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> auto_knows_old alice -> auto___type_6 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intro H. intros.
  elim (rem_588 H);  intros.
  apply (rem_1774 epsilon_mknows_old_p__type_6);  tauto.
Defined.

Remark rem_1776 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> auto___type_6 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_6.  case (rem_1720 epsilon_mknows_old_p__type_6). clear  epsilon_mknows_old_p__type_6. intros. apply trans___type_6_server_1;  tauto.
 clear  epsilon_mknows_old_p__type_6. tauto.
Defined.

Remark rem_1777 : (forall X:term, auto_knows_old X -> auto___type_6 X)
    -> auto_knows_old server -> auto___type_6 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_6. intro H. intros.
  elim (rem_591 H);  intros.
  apply (rem_1776 epsilon_mknows_old_p__type_6);  tauto.
Defined.

Remark rem_1778 : forall X1:term, auto_knows_old X1 -> auto___type_6 X1. (* Induct. *)
Proof.
  fix epsilon_mknows_old_p__type_6 1.
  intro X. case X.
  exact (rem_1775 epsilon_mknows_old_p__type_6 ).
  exact (rem_1758 epsilon_mknows_old_p__type_6 ).
  intros X1 X2;  exact (rem_1730 epsilon_mknows_old_p__type_6 X1 X2).
  intros X1 X2;  exact (rem_1756 epsilon_mknows_old_p__type_6 X1 X2).
  exact (rem_1724 epsilon_mknows_old_p__type_6 ).
  intros X1 X2;  exact (rem_1771 epsilon_mknows_old_p__type_6 X1 X2).
  intros X1 X2. intro H. elim (rem_597 X1 X2 H).
  exact (rem_1722 epsilon_mknows_old_p__type_6 ).
   intro H. elim (rem_596  H).
   intro H. elim (rem_598  H).
  intros X1;  exact (rem_1719 epsilon_mknows_old_p__type_6 X1).
  exact (rem_1777 epsilon_mknows_old_p__type_6 ).
  intros X1 X2. intro H. elim (rem_593 X1 X2 H).
  intros X1 X2. intro H. elim (rem_594 X1 X2 H).
   intro H. elim (rem_595  H).
   intro H. elim (rem_599  H).
  exact (rem_1773 epsilon_mknows_old_p__type_6 ).
Qed.

Remark rem_1779 : forall X1 X2 X3 X4:term, auto___def_16 X2 -> auto___def_21 X3 -> auto_knows_old X4 -> auto_knows_old X1 -> auto___type_6 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old X1 -> auto___type_6 X1). tauto. exact (rem_1778 X1).
Qed.

Remark rem_1780 : forall X1 X2 X3 X4:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___def_16 X3 -> auto___def_21 X4 -> auto___type_6 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X4 X2 X3.
  cut (auto___def_16 X2 -> auto___def_21 X3 -> auto_knows_old X4 -> auto_knows_old X1 -> auto___type_6 X1). tauto. exact (rem_1779 X1 X2 X3 X4).
Qed.

Remark rem_1781 : forall X1 X2 X3 X4:term, auto___def_33 X1 X2 X3 X4 -> auto___type_6 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_28 X1 X2 X3 X4 H);  intros.
  apply (rem_1780 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1782 : forall X1 X2 X3 X4:term, auto___def_31 (cons X3 (cons X2 (cons X4 nil))) -> auto___def_82 (l X1 X2) -> auto___type_12 (key sym (cons X1 (cons server nil))) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_39 X3 (cons X2 (cons X4 nil)) H);  intros.
Qed.

Remark rem_1783 : forall X1 X2 X3 X4:term, auto___def_82 (l X1 X2) -> auto___def_31 (cons X3 (cons X2 (cons X4 nil))) -> auto___type_12 (key sym (cons X1 (cons server nil))) -> auto___def_76 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_31 (cons X3 (cons X2 (cons X4 nil))) -> auto___def_82 (l X1 X2) -> auto___type_12 (key sym (cons X1 (cons server nil))) -> auto___def_76 X1 X2 X3 X4). tauto. exact (rem_1782 X1 X2 X3 X4).
Qed.

Remark rem_1784 : forall X1 X2 X3 X4:term, auto___def_81 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___type_12 (key sym (cons X1 (cons server nil))) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_42 (l X1 X2) (cons X3 (cons X2 (cons X4 nil))) H);  intros.
  apply (rem_1783 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1785 : forall X1 X2 X3 X4:term, auto___def_81 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___type_12 (key sym (cons X1 (cons server nil))) -> auto___type_13 t_current -> auto___def_76 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_81 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___type_12 (key sym (cons X1 (cons server nil))) -> auto___def_76 X1 X2 X3 X4). tauto.
  exact (rem_1784 X1 X2 X3 X4).
Qed.

Remark rem_1786 : forall X1 X2 X3 X4:term, auto___type_13 t_current -> auto___def_81 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___type_12 (key sym (cons X1 (cons server nil))) -> auto___def_76 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_81 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___type_12 (key sym (cons X1 (cons server nil))) -> auto___type_13 t_current -> auto___def_76 X1 X2 X3 X4). tauto. exact (rem_1785 X1 X2 X3 X4).
Qed.

Remark rem_1787 : forall X1 X2 X3 X4:term, auto___def_80 (cons t_current (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil))))) -> auto___type_12 (key sym (cons X1 (cons server nil))) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_46 t_current (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) H);  intros.
  apply (rem_1786 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1788 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current (l X1 X2) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3. intro H. intros.
  elim (rem_704 X1 X2 H);  intros.
Qed.

Remark rem_1789 : forall X1 X2 X3 X4:term, auto___def_42 sym -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current (l X1 X2) -> auto___def_76 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current (l X1 X2) -> auto___def_76 X1 X2 X3 X4). tauto.
  exact (rem_1788 X1 X2 X3 X4).
Qed.

Remark rem_1790 : forall X1 X2 X3 X4:term, auto___def_42 sym -> auto___type_8 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current (l X1 X2) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2 X3 X4. intros. apply (rem_1789 X1 X2 X3 X4);  assumption.
Qed.

Remark rem_1791 : forall X1 X2 X3 X4:term, auto___def_47 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current (l X1 X2) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_708 X1 (cons server nil) H);  intros.
Qed.

Remark rem_1792 : forall X1 X2 X3 X4:term, auto___def_46 sym -> auto___def_47 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current (l X1 X2) -> auto___def_76 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_47 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current (l X1 X2) -> auto___def_76 X1 X2 X3 X4). tauto.
  exact (rem_1791 X1 X2 X3 X4).
Qed.

Remark rem_1793 : forall X1 X2 X3 X4:term, auto___def_44 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current (l X1 X2) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_711 X1 (cons server nil) H);  intros.
Qed.

Remark rem_1794 : forall X1 X2 X3 X4:term, auto___def_43 sym -> auto___def_44 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current (l X1 X2) -> auto___def_76 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_44 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current (l X1 X2) -> auto___def_76 X1 X2 X3 X4). tauto.
  exact (rem_1793 X1 X2 X3 X4).
Qed.

Remark rem_1795 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto_knows_current (l X1 X2) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3. intro H. intros.
  elim (rem_101 sym (cons X1 (cons server nil)) H);  intros.
  apply (rem_1790 X1 X2 X3 X4);  tauto.
  apply (rem_1792 X1 X2 X3 X4);  tauto.
  apply (rem_1794 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1796 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto_knows_current (l X1 X2) -> auto_knows_current nil -> auto___def_76 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto_knows_current (l X1 X2) -> auto___def_76 X1 X2 X3 X4). tauto.
  exact (rem_1795 X1 X2 X3 X4).
Qed.

Remark rem_1797 : forall X1 X2 X3 X4:term, auto_knows_current X4 -> auto_knows_current nil -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto_knows_current (l X1 X2) -> auto___def_76 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto_knows_current (l X1 X2) -> auto_knows_current nil -> auto___def_76 X1 X2 X3 X4). tauto. exact (rem_1796 X1 X2 X3 X4).
Qed.

Remark rem_1798 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (cons X4 nil) -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto_knows_current (l X1 X2) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_124 X4 nil H);  intros.
  apply (rem_1797 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1799 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current (cons X4 nil) -> auto_knows_current X3 -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto_knows_current (l X1 X2) -> auto___def_76 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (cons X4 nil) -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto_knows_current (l X1 X2) -> auto___def_76 X1 X2 X3 X4). tauto. exact (rem_1798 X1 X2 X3 X4).
Qed.

Remark rem_1800 : forall X1 X2 X3 X4:term, auto_knows_current X3 -> auto_knows_current (cons X2 (cons X4 nil)) -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto_knows_current (l X1 X2) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_124 X2 (cons X4 nil) H);  intros.
  apply (rem_1799 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1801 : forall X1 X2 X3 X4:term, auto_knows_current (cons X3 (cons X2 (cons X4 nil))) -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto_knows_current (l X1 X2) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_124 X3 (cons X2 (cons X4 nil)) H);  intros.
  apply (rem_1800 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1802 : forall X1 X2 X3 X4:term, auto_knows_current (l X1 X2) -> auto_knows_current (cons X3 (cons X2 (cons X4 nil))) -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto___def_76 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current (cons X3 (cons X2 (cons X4 nil))) -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto_knows_current (l X1 X2) -> auto___def_76 X1 X2 X3 X4). tauto. exact (rem_1801 X1 X2 X3 X4).
Qed.

Remark rem_1803 : forall X1 X2 X3 X4:term, auto_knows_current (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_124 (l X1 X2) (cons X3 (cons X2 (cons X4 nil))) H);  intros.
  apply (rem_1802 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1804 : forall X1 X2 X3 X4:term, auto_knows_current (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto_knows_current t_current -> auto___def_76 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto___def_76 X1 X2 X3 X4). tauto.
  exact (rem_1803 X1 X2 X3 X4).
Qed.

Remark rem_1805 : forall X1 X2 X3 X4:term, auto_knows_current t_current -> auto_knows_current (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto___def_76 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto_knows_current t_current -> auto___def_76 X1 X2 X3 X4). tauto. exact (rem_1804 X1 X2 X3 X4).
Qed.

Remark rem_1806 : forall X1 X2 X3 X4:term, auto_knows_current (cons t_current (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil))))) -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_124 t_current (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) H);  intros.
  apply (rem_1805 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1807 : forall X1 X2 X3 X4:term, auto___def_84 (cons t_current (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil))))) -> auto___type_14 (key sym (cons X1 (cons server nil))) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_132 t_current (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) H);  intros.
Qed.

Remark rem_1808 : forall X1 X2:term, auto___def_22 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1809 : forall X1 X2 X3 X4:term, auto___def_16 X3 -> auto___def_22 (cons X4 nil) -> auto___def_28 (cons X1 (cons server nil)) -> auto___type_3 X2 -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_1808 X4 nil H);  intros.
Qed.

Remark rem_1810 : forall X1 X2 X3 X4:term, auto___type_3 X2 -> auto___def_22 (cons X4 nil) -> auto___def_16 X3 -> auto___def_28 (cons X1 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_76 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_16 X3 -> auto___def_22 (cons X4 nil) -> auto___def_28 (cons X1 (cons server nil)) -> auto___type_3 X2 -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_76 X1 X2 X3 X4). tauto. exact (rem_1809 X1 X2 X3 X4).
Qed.

Remark rem_1811 : forall X1 X2:term, auto___def_27 (cons X1 X2) -> or_1
    (auto___type_3 X1 /\ auto___def_22 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1812 : forall X1 X2 X3 X4:term, auto___def_16 X3 -> auto___def_27 (cons X2 (cons X4 nil)) -> auto___def_28 (cons X1 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_1811 X2 (cons X4 nil) H);  intros.
  apply (rem_1810 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1813 : forall X1 X2 X3 X4:term, auto___def_26 (cons X3 (cons X2 (cons X4 nil))) -> auto___def_28 (cons X1 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1094 X3 (cons X2 (cons X4 nil)) H);  intros.
  apply (rem_1812 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1814 : forall X1 X2 X3 X4:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___def_26 (cons X3 (cons X2 (cons X4 nil))) -> auto___def_28 (cons X1 (cons server nil)) -> auto___def_76 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_26 (cons X3 (cons X2 (cons X4 nil))) -> auto___def_28 (cons X1 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_76 X1 X2 X3 X4). tauto. exact (rem_1813 X1 X2 X3 X4).
Qed.

Remark rem_1815 : forall X1 X2 X3 X4:term, auto___def_14 (l X1 X2) -> auto___def_26 (cons X3 (cons X2 (cons X4 nil))) -> auto___def_28 (cons X1 (cons server nil)) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_618 X1 X2 H);  intros.
  apply (rem_1814 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1816 : forall X1 X2 X3 X4:term, auto___def_25 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_28 (cons X1 (cons server nil)) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_620 (l X1 X2) (cons X3 (cons X2 (cons X4 nil))) H);  intros.
  apply (rem_1815 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1817 : forall X1 X2 X3 X4:term, auto___def_18 sym -> auto___def_25 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_28 (cons X1 (cons server nil)) -> auto___def_76 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_25 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_28 (cons X1 (cons server nil)) -> auto___def_76 X1 X2 X3 X4). tauto.
  exact (rem_1816 X1 X2 X3 X4).
Qed.

Remark rem_1818 : forall X1 X2 X3 X4:term, auto___def_18 sym -> auto___def_28 (cons X1 (cons server nil)) -> auto___def_25 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_76 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_18 sym -> auto___def_25 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_28 (cons X1 (cons server nil)) -> auto___def_76 X1 X2 X3 X4). tauto. exact (rem_1817 X1 X2 X3 X4).
Qed.

Remark rem_1819 : forall X1 X2 X3 X4:term, auto___def_24 (key sym (cons X1 (cons server nil))) -> auto___def_25 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_624 sym (cons X1 (cons server nil)) H);  intros.
  apply (rem_1818 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1820 : forall X1 X2 X3 X4:term, auto___def_12 t_current -> auto___def_24 (key sym (cons X1 (cons server nil))) -> auto___def_25 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_76 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_24 (key sym (cons X1 (cons server nil))) -> auto___def_25 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_76 X1 X2 X3 X4). tauto.
  exact (rem_1819 X1 X2 X3 X4).
Qed.

Remark rem_1821 : forall X1 X2 X3 X4:term, auto___def_12 t_current -> auto___def_25 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_24 (key sym (cons X1 (cons server nil))) -> auto___def_76 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 t_current -> auto___def_24 (key sym (cons X1 (cons server nil))) -> auto___def_25 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_76 X1 X2 X3 X4). tauto. exact (rem_1820 X1 X2 X3 X4).
Qed.

Remark rem_1822 : forall X1 X2 X3 X4:term, auto___def_23 (cons t_current (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil))))) -> auto___def_24 (key sym (cons X1 (cons server nil))) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_628 t_current (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) H);  intros.
  apply (rem_1821 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1823 : forall X1 X2 X3 X4:term, auto___def_11 (key sym (cons X1 (cons server nil))) -> auto___def_12 t_current -> auto___def_13 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_76 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_12 t_current -> False). tauto.
  exact (rem_728).
Qed.

Remark rem_1824 : forall X1 X2 X3 X4:term, auto___def_12 t_current -> auto___def_13 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_11 (key sym (cons X1 (cons server nil))) -> auto___def_76 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 (key sym (cons X1 (cons server nil))) -> auto___def_12 t_current -> auto___def_13 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_76 X1 X2 X3 X4). tauto. exact (rem_1823 X1 X2 X3 X4).
Qed.

Remark rem_1825 : forall X1 X2 X3 X4:term, auto___def_10 (cons t_current (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil))))) -> auto___def_11 (key sym (cons X1 (cons server nil))) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_648 t_current (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) H);  intros.
  apply (rem_1824 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1826 : forall X1 X2 X3 X4:term, auto___def_61 X3 -> auto___def_66 X4 -> auto___def_67 nil -> auto___def_75 (cons X1 (cons server nil)) -> auto___type_9 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_1655 X1).
Qed.

Remark rem_1827 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1828 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_1827 epsilon_m__type_9_pknows_current X1);  assumption.
  tauto.
Defined.

Remark rem_1829 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1. intros A1.
  case (rem_1828 epsilon_m__type_9_pknows_current X1 A1). clear  epsilon_m__type_9_pknows_current A1. intros. apply trans_knows_current_s_1;  tauto.
 clear  epsilon_m__type_9_pknows_current A1. tauto.
Defined.

Remark rem_1830 : forall X1:term, auto___type_9 (s X1) -> or_1
    (auto_knows_current X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1831 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1:term, auto___type_9 (s X1) -> auto_knows_current (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1. intro H. intros.
  elim (rem_1830 X1 H);  intros.
  apply (rem_1829 epsilon_m__type_9_pknows_current X1);  tauto.
Defined.

Remark rem_1832 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_9_pknows_current.  tauto.
Defined.

Remark rem_1833 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> auto_knows_current nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current.  case (rem_1832 epsilon_m__type_9_pknows_current). clear  epsilon_m__type_9_pknows_current. intros. apply trans_knows_current_nil_1;  tauto.
 clear  epsilon_m__type_9_pknows_current. tauto.
Defined.

Remark rem_1834 : auto___type_9 nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1835 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> auto___type_9 nil -> auto_knows_current nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intro H. intros.
  elim (rem_1834 H);  intros.
  apply (rem_1833 epsilon_m__type_9_pknows_current);  tauto.
Defined.

Remark rem_1836 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> auto_knows_current i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current.  case (rem_1832 epsilon_m__type_9_pknows_current). clear  epsilon_m__type_9_pknows_current. intros. apply trans_knows_current_i_1;  tauto.
 clear  epsilon_m__type_9_pknows_current. tauto.
Defined.

Remark rem_1837 : auto___type_9 i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1838 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> auto___type_9 i -> auto_knows_current i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intro H. intros.
  elim (rem_1837 H);  intros.
  apply (rem_1836 epsilon_m__type_9_pknows_current);  tauto.
Defined.

Remark rem_1839 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_1827 epsilon_m__type_9_pknows_current X1).
Defined.

Remark rem_1840 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X2:term, auto_knows_current X2 -> auto_knows_current X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1841 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_1840 epsilon_m__type_9_pknows_current X2).
Defined.

Remark rem_1842 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_1839 epsilon_m__type_9_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1841 epsilon_m__type_9_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1843 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1842 epsilon_m__type_9_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_9_pknows_current A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  epsilon_m__type_9_pknows_current A1 A2. tauto.
Defined.

Remark rem_1844 : forall X1 X2:term, auto___type_9 (cons X1 X2) -> or_1
    (auto_knows_current X1 /\ auto_knows_current X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1845 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_9 (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_1844 X1 X2 H);  intros.
  apply (rem_1843 epsilon_m__type_9_pknows_current X1 X2);  tauto.
Defined.

Remark rem_1846 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1:term, auto___def_80 X1 -> auto___def_80 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1847 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> auto___def_80 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2.
  cut (auto___def_80 X1 -> auto___def_80 X1). tauto. exact (rem_1846 epsilon_m__type_9_pknows_current X1).
Defined.

Remark rem_1848 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X2:term, auto___type_12 X2 -> auto___type_12 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1849 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> auto___type_12 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2.
  cut (auto___type_12 X2 -> auto___type_12 X2). tauto. exact (rem_1848 epsilon_m__type_9_pknows_current X2).
Defined.

Remark rem_1850 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> (auto___def_80 X1 /\ auto___type_12 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_80 X1). 2:apply (rem_1847 epsilon_m__type_9_pknows_current X1 X2);  assumption.
  cut (auto___type_12 X2). 2:apply (rem_1849 epsilon_m__type_9_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1851 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1850 epsilon_m__type_9_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_9_pknows_current A1 A2. intros. apply trans_knows_current_crypt_1;  tauto.
 clear  epsilon_m__type_9_pknows_current A1 A2. tauto.
Defined.

Remark rem_1852 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1842 epsilon_m__type_9_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_9_pknows_current A1 A2. intros. apply trans_knows_current_crypt_2;  tauto.
 clear  epsilon_m__type_9_pknows_current A1 A2. tauto.
Defined.

Remark rem_1853 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1:term, auto___def_84 X1 -> auto___def_84 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1854 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> auto___def_84 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2.
  cut (auto___def_84 X1 -> auto___def_84 X1). tauto. exact (rem_1853 epsilon_m__type_9_pknows_current X1).
Defined.

Remark rem_1855 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X2:term, auto___type_14 X2 -> auto___type_14 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1856 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> auto___type_14 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2.
  cut (auto___type_14 X2 -> auto___type_14 X2). tauto. exact (rem_1855 epsilon_m__type_9_pknows_current X2).
Defined.

Remark rem_1857 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> (auto___def_84 X1 /\ auto___type_14 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_84 X1). 2:apply (rem_1854 epsilon_m__type_9_pknows_current X1 X2);  assumption.
  cut (auto___type_14 X2). 2:apply (rem_1856 epsilon_m__type_9_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1858 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1857 epsilon_m__type_9_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_9_pknows_current A1 A2. intros. apply trans_knows_current_crypt_3;  tauto.
 clear  epsilon_m__type_9_pknows_current A1 A2. tauto.
Defined.

Remark rem_1859 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1:term, auto___def_23 X1 -> auto___def_23 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1860 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_23 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2.
  cut (auto___def_23 X1 -> auto___def_23 X1). tauto. exact (rem_1859 epsilon_m__type_9_pknows_current X1).
Defined.

Remark rem_1861 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X2:term, auto___def_24 X2 -> auto___def_24 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1862 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_24 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2.
  cut (auto___def_24 X2 -> auto___def_24 X2). tauto. exact (rem_1861 epsilon_m__type_9_pknows_current X2).
Defined.

Remark rem_1863 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> (auto___def_23 X1 /\ auto___def_24 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_23 X1). 2:apply (rem_1860 epsilon_m__type_9_pknows_current X1 X2);  assumption.
  cut (auto___def_24 X2). 2:apply (rem_1862 epsilon_m__type_9_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1864 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1863 epsilon_m__type_9_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_9_pknows_current A1 A2. intros. apply trans_knows_current_crypt_4;  tauto.
 clear  epsilon_m__type_9_pknows_current A1 A2. tauto.
Defined.

Remark rem_1865 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1:term, auto___def_10 X1 -> auto___def_10 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1866 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_10 X1). tauto. exact (rem_1865 epsilon_m__type_9_pknows_current X1).
Defined.

Remark rem_1867 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X2:term, auto___def_11 X2 -> auto___def_11 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1868 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2.
  cut (auto___def_11 X2 -> auto___def_11 X2). tauto. exact (rem_1867 epsilon_m__type_9_pknows_current X2).
Defined.

Remark rem_1869 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> (auto___def_10 X1 /\ auto___def_11 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_10 X1). 2:apply (rem_1866 epsilon_m__type_9_pknows_current X1 X2);  assumption.
  cut (auto___def_11 X2). 2:apply (rem_1868 epsilon_m__type_9_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1870 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1869 epsilon_m__type_9_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_9_pknows_current A1 A2. intros. apply trans_knows_current_crypt_5;  tauto.
 clear  epsilon_m__type_9_pknows_current A1 A2. tauto.
Defined.

Remark rem_1871 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1:term, auto___def_55 X1 -> auto___def_55 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1872 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> auto___def_55 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2.
  cut (auto___def_55 X1 -> auto___def_55 X1). tauto. exact (rem_1871 epsilon_m__type_9_pknows_current X1).
Defined.

Remark rem_1873 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X2:term, auto___def_56 X2 -> auto___def_56 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1874 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> auto___def_56 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2.
  cut (auto___def_56 X2 -> auto___def_56 X2). tauto. exact (rem_1873 epsilon_m__type_9_pknows_current X2).
Defined.

Remark rem_1875 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> (auto___def_55 X1 /\ auto___def_56 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_55 X1). 2:apply (rem_1872 epsilon_m__type_9_pknows_current X1 X2);  assumption.
  cut (auto___def_56 X2). 2:apply (rem_1874 epsilon_m__type_9_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1876 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1875 epsilon_m__type_9_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_9_pknows_current A1 A2. intros. apply trans_knows_current_crypt_6;  tauto.
 clear  epsilon_m__type_9_pknows_current A1 A2. tauto.
Defined.

Remark rem_1877 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1:term, auto___def_68 X1 -> auto___def_68 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1878 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> auto___def_68 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2.
  cut (auto___def_68 X1 -> auto___def_68 X1). tauto. exact (rem_1877 epsilon_m__type_9_pknows_current X1).
Defined.

Remark rem_1879 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X2:term, auto___def_69 X2 -> auto___def_69 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1880 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> auto___def_69 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2.
  cut (auto___def_69 X2 -> auto___def_69 X2). tauto. exact (rem_1879 epsilon_m__type_9_pknows_current X2).
Defined.

Remark rem_1881 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> (auto___def_68 X1 /\ auto___def_69 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_68 X1). 2:apply (rem_1878 epsilon_m__type_9_pknows_current X1 X2);  assumption.
  cut (auto___def_69 X2). 2:apply (rem_1880 epsilon_m__type_9_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1882 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1881 epsilon_m__type_9_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_9_pknows_current A1 A2. intros. apply trans_knows_current_crypt_7;  tauto.
 clear  epsilon_m__type_9_pknows_current A1 A2. tauto.
Defined.

Remark rem_1883 : forall X1 X2:term, auto___type_9 (crypt X1 X2) -> or_7
    (auto___def_80 X1 /\ auto___type_12 X2)
    (auto_knows_current X1 /\ auto_knows_current X2)
    (auto___def_84 X1 /\ auto___type_14 X2)
    (auto___def_23 X1 /\ auto___def_24 X2)
    (auto___def_10 X1 /\ auto___def_11 X2)
    (auto___def_55 X1 /\ auto___def_56 X2)
    (auto___def_68 X1 /\ auto___def_69 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_7_intro_1; tauto.
  intros. apply or_7_intro_2; tauto.
  intros. apply or_7_intro_3; tauto.
  intros. apply or_7_intro_4; tauto.
  intros. apply or_7_intro_5; tauto.
  intros. apply or_7_intro_6; tauto.
  intros. apply or_7_intro_7; tauto.
Qed.

Remark rem_1884 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_9 (crypt X1 X2) -> auto_knows_current (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_1883 X1 X2 H);  intros.
  apply (rem_1851 epsilon_m__type_9_pknows_current X1 X2);  tauto.
  apply (rem_1852 epsilon_m__type_9_pknows_current X1 X2);  tauto.
  apply (rem_1858 epsilon_m__type_9_pknows_current X1 X2);  tauto.
  apply (rem_1864 epsilon_m__type_9_pknows_current X1 X2);  tauto.
  apply (rem_1870 epsilon_m__type_9_pknows_current X1 X2);  tauto.
  apply (rem_1876 epsilon_m__type_9_pknows_current X1 X2);  tauto.
  apply (rem_1882 epsilon_m__type_9_pknows_current X1 X2);  tauto.
Defined.

Remark rem_1885 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> auto_knows_current bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current.  case (rem_1832 epsilon_m__type_9_pknows_current). clear  epsilon_m__type_9_pknows_current. intros. apply trans_knows_current_bob_1;  tauto.
 clear  epsilon_m__type_9_pknows_current. tauto.
Defined.

Remark rem_1886 : auto___type_9 bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1887 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> auto___type_9 bob -> auto_knows_current bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intro H. intros.
  elim (rem_1886 H);  intros.
  apply (rem_1885 epsilon_m__type_9_pknows_current);  tauto.
Defined.

Remark rem_1888 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1:term, auto___def_42 X1 -> auto___def_42 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1889 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___def_42 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2.
  cut (auto___def_42 X1 -> auto___def_42 X1). tauto. exact (rem_1888 epsilon_m__type_9_pknows_current X1).
Defined.

Remark rem_1890 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1891 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_1890 epsilon_m__type_9_pknows_current X2).
Defined.

Remark rem_1892 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> (auto___def_42 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_42 X1). 2:apply (rem_1889 epsilon_m__type_9_pknows_current X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_1891 epsilon_m__type_9_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1893 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1892 epsilon_m__type_9_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_9_pknows_current A1 A2. intros. apply trans_knows_current_key_1;  tauto.
 clear  epsilon_m__type_9_pknows_current A1 A2. tauto.
Defined.

Remark rem_1894 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1:term, auto___def_46 X1 -> auto___def_46 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1895 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_46 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2.
  cut (auto___def_46 X1 -> auto___def_46 X1). tauto. exact (rem_1894 epsilon_m__type_9_pknows_current X1).
Defined.

Remark rem_1896 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X2:term, auto___def_47 X2 -> auto___def_47 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1897 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_47 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2.
  cut (auto___def_47 X2 -> auto___def_47 X2). tauto. exact (rem_1896 epsilon_m__type_9_pknows_current X2).
Defined.

Remark rem_1898 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> (auto___def_46 X1 /\ auto___def_47 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_46 X1). 2:apply (rem_1895 epsilon_m__type_9_pknows_current X1 X2);  assumption.
  cut (auto___def_47 X2). 2:apply (rem_1897 epsilon_m__type_9_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1899 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1898 epsilon_m__type_9_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_9_pknows_current A1 A2. intros. apply trans_knows_current_key_2;  tauto.
 clear  epsilon_m__type_9_pknows_current A1 A2. tauto.
Defined.

Remark rem_1900 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1:term, auto___def_43 X1 -> auto___def_43 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1901 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_43 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_43 X1). tauto. exact (rem_1900 epsilon_m__type_9_pknows_current X1).
Defined.

Remark rem_1902 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X2:term, auto___def_44 X2 -> auto___def_44 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1903 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_44 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2.
  cut (auto___def_44 X2 -> auto___def_44 X2). tauto. exact (rem_1902 epsilon_m__type_9_pknows_current X2).
Defined.

Remark rem_1904 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> (auto___def_43 X1 /\ auto___def_44 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_43 X1). 2:apply (rem_1901 epsilon_m__type_9_pknows_current X1 X2);  assumption.
  cut (auto___def_44 X2). 2:apply (rem_1903 epsilon_m__type_9_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1905 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1904 epsilon_m__type_9_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_9_pknows_current A1 A2. intros. apply trans_knows_current_key_3;  tauto.
 clear  epsilon_m__type_9_pknows_current A1 A2. tauto.
Defined.

Remark rem_1906 : forall X1 X2:term, auto___type_9 (key X1 X2) -> or_3
    (auto___def_42 X1 /\ auto___type_8 X2)
    (auto___def_46 X1 /\ auto___def_47 X2)
    (auto___def_43 X1 /\ auto___def_44 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_1907 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_9 (key X1 X2) -> auto_knows_current (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_1906 X1 X2 H);  intros.
  apply (rem_1893 epsilon_m__type_9_pknows_current X1 X2);  tauto.
  apply (rem_1899 epsilon_m__type_9_pknows_current X1 X2);  tauto.
  apply (rem_1905 epsilon_m__type_9_pknows_current X1 X2);  tauto.
Defined.

Remark rem_1908 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> auto_knows_current t_old. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current.  case (rem_1832 epsilon_m__type_9_pknows_current). clear  epsilon_m__type_9_pknows_current. intros. apply trans_knows_current_t_old_1;  tauto.
 clear  epsilon_m__type_9_pknows_current. tauto.
Defined.

Remark rem_1909 : auto___type_9 t_old -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1910 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> auto___type_9 t_old -> auto_knows_current t_old. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intro H. intros.
  elim (rem_1909 H);  intros.
  apply (rem_1908 epsilon_m__type_9_pknows_current);  tauto.
Defined.

Remark rem_1911 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> auto_knows_current alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current.  case (rem_1832 epsilon_m__type_9_pknows_current). clear  epsilon_m__type_9_pknows_current. intros. apply trans_knows_current_alice_1;  tauto.
 clear  epsilon_m__type_9_pknows_current. tauto.
Defined.

Remark rem_1912 : auto___type_9 alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1913 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> auto___type_9 alice -> auto_knows_current alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intro H. intros.
  elim (rem_1912 H);  intros.
  apply (rem_1911 epsilon_m__type_9_pknows_current);  tauto.
Defined.

Remark rem_1914 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> auto_knows_current server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current.  case (rem_1832 epsilon_m__type_9_pknows_current). clear  epsilon_m__type_9_pknows_current. intros. apply trans_knows_current_server_1;  tauto.
 clear  epsilon_m__type_9_pknows_current. tauto.
Defined.

Remark rem_1915 : auto___type_9 server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1916 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> auto___type_9 server -> auto_knows_current server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intro H. intros.
  elim (rem_1915 H);  intros.
  apply (rem_1914 epsilon_m__type_9_pknows_current);  tauto.
Defined.

Remark rem_1917 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> auto_knows_current t_current. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current.  case (rem_1832 epsilon_m__type_9_pknows_current). clear  epsilon_m__type_9_pknows_current. intros. apply trans_knows_current_t_current_1;  tauto.
 clear  epsilon_m__type_9_pknows_current. tauto.
Defined.

Remark rem_1918 : auto___type_9 t_current -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1919 : (forall X:term, auto___type_9 X -> auto_knows_current X)
    -> auto___type_9 t_current -> auto_knows_current t_current. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_9_pknows_current. intro H. intros.
  elim (rem_1918 H);  intros.
  apply (rem_1917 epsilon_m__type_9_pknows_current);  tauto.
Defined.

Remark rem_1920 : forall X1 X2:term, auto___type_9 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1921 : forall X1 X2:term, auto___type_9 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1922 : auto___type_9 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1923 : auto___type_9 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1924 : forall X1 X2:term, auto___type_9 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1925 : auto___type_9 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1926 : forall X2:term, auto___type_9 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__type_9_pknows_current 1.
  intro X. case X.
  exact (rem_1913 epsilon_m__type_9_pknows_current ).
  exact (rem_1887 epsilon_m__type_9_pknows_current ).
  intros X1 X2;  exact (rem_1845 epsilon_m__type_9_pknows_current X1 X2).
  intros X1 X2;  exact (rem_1884 epsilon_m__type_9_pknows_current X1 X2).
  exact (rem_1838 epsilon_m__type_9_pknows_current ).
  intros X1 X2;  exact (rem_1907 epsilon_m__type_9_pknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_1924 X1 X2 H).
  exact (rem_1835 epsilon_m__type_9_pknows_current ).
   intro H. elim (rem_1923  H).
   intro H. elim (rem_1925  H).
  intros X1;  exact (rem_1831 epsilon_m__type_9_pknows_current X1).
  exact (rem_1916 epsilon_m__type_9_pknows_current ).
  intros X1 X2. intro H. elim (rem_1920 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1921 X1 X2 H).
   intro H. elim (rem_1922  H).
  exact (rem_1919 epsilon_m__type_9_pknows_current ).
  exact (rem_1910 epsilon_m__type_9_pknows_current ).
Qed.

Remark rem_1927 : forall X1 X2 X3 X4:term, auto___def_61 X3 -> auto___def_66 X4 -> auto___def_67 nil -> auto___def_75 (cons X1 (cons server nil)) -> auto___type_9 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_9 X2 -> auto_knows_current X2). tauto. exact (rem_1926 X2).
Qed.

Remark rem_1928 : forall X3:term, auto___def_61 X3 -> auto___def_61 X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1929 : forall X1 X2 X3 X4:term, auto___def_61 X3 -> auto___def_66 X4 -> auto___def_67 nil -> auto___def_75 (cons X1 (cons server nil)) -> auto___type_9 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_61 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_61 X3 -> auto___def_61 X3). tauto. exact (rem_1928 X3).
Qed.

Remark rem_1930 : forall X4:term, auto___def_66 X4 -> auto___def_66 X4. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1931 : forall X1 X2 X3 X4:term, auto___def_61 X3 -> auto___def_66 X4 -> auto___def_67 nil -> auto___def_75 (cons X1 (cons server nil)) -> auto___type_9 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_66 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_66 X4 -> auto___def_66 X4). tauto. exact (rem_1930 X4).
Qed.

Remark rem_1932 : forall X1 X2 X3 X4:term, auto___def_61 X3 -> auto___def_66 X4 -> auto___def_67 nil -> auto___def_75 (cons X1 (cons server nil)) -> auto___type_9 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> (auto_knows_current X1 /\ auto_knows_current X2 /\ auto___def_61 X3 /\ auto___def_66 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto_knows_current X1). 2:apply (rem_1826 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1927 X1 X2 X3 X4);  assumption.
  cut (auto___def_61 X3). 2:apply (rem_1929 X1 X2 X3 X4);  assumption.
  cut (auto___def_66 X4). 2:apply (rem_1931 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_1933 : forall X1 X2 X3 X4:term, auto___def_61 X3 -> auto___def_66 X4 -> auto___def_67 nil -> auto___def_75 (cons X1 (cons server nil)) -> auto___type_9 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_76 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_1932 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_76_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_1934 : forall X1 X2 X3 X4:term, auto___def_66 X4 -> auto___def_67 nil -> auto___def_61 X3 -> auto___def_75 (cons X1 (cons server nil)) -> auto___type_9 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_76 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_61 X3 -> auto___def_66 X4 -> auto___def_67 nil -> auto___def_75 (cons X1 (cons server nil)) -> auto___type_9 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_76 X1 X2 X3 X4). tauto. exact (rem_1933 X1 X2 X3 X4).
Qed.

Remark rem_1935 : forall X1 X2:term, auto___def_65 (cons X1 X2) -> or_1
    (auto___def_66 X1 /\ auto___def_67 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1936 : forall X1 X2 X3 X4:term, auto___def_61 X3 -> auto___def_65 (cons X4 nil) -> auto___def_75 (cons X1 (cons server nil)) -> auto___type_9 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_1935 X4 nil H);  intros.
  apply (rem_1934 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1937 : forall X1 X2 X3 X4:term, auto___type_9 X2 -> auto___def_65 (cons X4 nil) -> auto___def_61 X3 -> auto___def_75 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_76 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_61 X3 -> auto___def_65 (cons X4 nil) -> auto___def_75 (cons X1 (cons server nil)) -> auto___type_9 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_76 X1 X2 X3 X4). tauto. exact (rem_1936 X1 X2 X3 X4).
Qed.

Remark rem_1938 : forall X1 X2:term, auto___def_62 (cons X1 X2) -> or_1
    (auto___type_9 X1 /\ auto___def_65 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1939 : forall X1 X2 X3 X4:term, auto___def_61 X3 -> auto___def_62 (cons X2 (cons X4 nil)) -> auto___def_75 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_1938 X2 (cons X4 nil) H);  intros.
  apply (rem_1937 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1940 : forall X1 X2 X3 X4:term, auto___def_60 (cons X3 (cons X2 (cons X4 nil))) -> auto___def_75 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_962 X3 (cons X2 (cons X4 nil)) H);  intros.
  apply (rem_1939 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1941 : forall X1 X2 X3 X4:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___def_60 (cons X3 (cons X2 (cons X4 nil))) -> auto___def_75 (cons X1 (cons server nil)) -> auto___def_76 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_60 (cons X3 (cons X2 (cons X4 nil))) -> auto___def_75 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_76 X1 X2 X3 X4). tauto. exact (rem_1940 X1 X2 X3 X4).
Qed.

Remark rem_1942 : forall X1 X2 X3 X4:term, auto___def_59 (l X1 X2) -> auto___def_60 (cons X3 (cons X2 (cons X4 nil))) -> auto___def_75 (cons X1 (cons server nil)) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_661 X1 X2 H);  intros.
  apply (rem_1941 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1943 : forall X1 X2 X3 X4:term, auto___def_58 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_75 (cons X1 (cons server nil)) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_663 (l X1 X2) (cons X3 (cons X2 (cons X4 nil))) H);  intros.
  apply (rem_1942 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1944 : forall X1 X2 X3 X4:term, auto___def_58 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_63 sym -> auto___def_75 (cons X1 (cons server nil)) -> auto___def_76 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_58 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_75 (cons X1 (cons server nil)) -> auto___def_76 X1 X2 X3 X4). tauto.
  exact (rem_1943 X1 X2 X3 X4).
Qed.

Remark rem_1945 : forall X1 X2 X3 X4:term, auto___def_63 sym -> auto___def_75 (cons X1 (cons server nil)) -> auto___def_58 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_76 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_58 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_63 sym -> auto___def_75 (cons X1 (cons server nil)) -> auto___def_76 X1 X2 X3 X4). tauto. exact (rem_1944 X1 X2 X3 X4).
Qed.

Remark rem_1946 : forall X1 X2 X3 X4:term, auto___def_56 (key sym (cons X1 (cons server nil))) -> auto___def_58 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_667 sym (cons X1 (cons server nil)) H);  intros.
  apply (rem_1945 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1947 : forall X1 X2 X3 X4:term, auto___def_56 (key sym (cons X1 (cons server nil))) -> auto___def_57 t_current -> auto___def_58 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_76 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_56 (key sym (cons X1 (cons server nil))) -> auto___def_58 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_76 X1 X2 X3 X4). tauto.
  exact (rem_1946 X1 X2 X3 X4).
Qed.

Remark rem_1948 : forall X1 X2 X3 X4:term, auto___def_57 t_current -> auto___def_58 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_56 (key sym (cons X1 (cons server nil))) -> auto___def_76 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 (key sym (cons X1 (cons server nil))) -> auto___def_57 t_current -> auto___def_58 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_76 X1 X2 X3 X4). tauto. exact (rem_1947 X1 X2 X3 X4).
Qed.

Remark rem_1949 : forall X1 X2 X3 X4:term, auto___def_55 (cons t_current (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil))))) -> auto___def_56 (key sym (cons X1 (cons server nil))) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_671 t_current (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) H);  intros.
  apply (rem_1948 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1950 : forall X1 X2:term, auto___def_67 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1951 : forall X1 X2 X3 X4:term, auto___def_61 X3 -> auto___def_67 (cons X4 nil) -> auto___def_73 (cons X1 (cons server nil)) -> auto___type_10 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_1950 X4 nil H);  intros.
Qed.

Remark rem_1952 : forall X1 X2 X3 X4:term, auto___type_10 X2 -> auto___def_67 (cons X4 nil) -> auto___def_61 X3 -> auto___def_73 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_76 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_61 X3 -> auto___def_67 (cons X4 nil) -> auto___def_73 (cons X1 (cons server nil)) -> auto___type_10 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_76 X1 X2 X3 X4). tauto. exact (rem_1951 X1 X2 X3 X4).
Qed.

Remark rem_1953 : forall X1 X2:term, auto___def_72 (cons X1 X2) -> or_1
    (auto___type_10 X1 /\ auto___def_67 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1954 : forall X1 X2 X3 X4:term, auto___def_61 X3 -> auto___def_72 (cons X2 (cons X4 nil)) -> auto___def_73 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_1953 X2 (cons X4 nil) H);  intros.
  apply (rem_1952 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1955 : forall X1 X2 X3 X4:term, auto___def_71 (cons X3 (cons X2 (cons X4 nil))) -> auto___def_73 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_981 X3 (cons X2 (cons X4 nil)) H);  intros.
  apply (rem_1954 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1956 : forall X1 X2 X3 X4:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___def_71 (cons X3 (cons X2 (cons X4 nil))) -> auto___def_73 (cons X1 (cons server nil)) -> auto___def_76 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_71 (cons X3 (cons X2 (cons X4 nil))) -> auto___def_73 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_76 X1 X2 X3 X4). tauto. exact (rem_1955 X1 X2 X3 X4).
Qed.

Remark rem_1957 : forall X1 X2 X3 X4:term, auto___def_59 (l X1 X2) -> auto___def_71 (cons X3 (cons X2 (cons X4 nil))) -> auto___def_73 (cons X1 (cons server nil)) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_661 X1 X2 H);  intros.
  apply (rem_1956 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1958 : forall X1 X2 X3 X4:term, auto___def_70 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_73 (cons X1 (cons server nil)) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_683 (l X1 X2) (cons X3 (cons X2 (cons X4 nil))) H);  intros.
  apply (rem_1957 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1959 : forall X1 X2 X3 X4:term, auto___def_63 sym -> auto___def_70 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_73 (cons X1 (cons server nil)) -> auto___def_76 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_70 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_73 (cons X1 (cons server nil)) -> auto___def_76 X1 X2 X3 X4). tauto.
  exact (rem_1958 X1 X2 X3 X4).
Qed.

Remark rem_1960 : forall X1 X2 X3 X4:term, auto___def_63 sym -> auto___def_73 (cons X1 (cons server nil)) -> auto___def_70 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_76 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_63 sym -> auto___def_70 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_73 (cons X1 (cons server nil)) -> auto___def_76 X1 X2 X3 X4). tauto. exact (rem_1959 X1 X2 X3 X4).
Qed.

Remark rem_1961 : forall X1 X2 X3 X4:term, auto___def_69 (key sym (cons X1 (cons server nil))) -> auto___def_70 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_687 sym (cons X1 (cons server nil)) H);  intros.
  apply (rem_1960 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1962 : forall X1 X2 X3 X4:term, auto___def_57 t_current -> auto___def_69 (key sym (cons X1 (cons server nil))) -> auto___def_70 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_76 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_69 (key sym (cons X1 (cons server nil))) -> auto___def_70 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_76 X1 X2 X3 X4). tauto.
  exact (rem_1961 X1 X2 X3 X4).
Qed.

Remark rem_1963 : forall X1 X2 X3 X4:term, auto___def_57 t_current -> auto___def_70 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_69 (key sym (cons X1 (cons server nil))) -> auto___def_76 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 t_current -> auto___def_69 (key sym (cons X1 (cons server nil))) -> auto___def_70 (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) -> auto___def_76 X1 X2 X3 X4). tauto. exact (rem_1962 X1 X2 X3 X4).
Qed.

Remark rem_1964 : forall X1 X2 X3 X4:term, auto___def_68 (cons t_current (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil))))) -> auto___def_69 (key sym (cons X1 (cons server nil))) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_691 t_current (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil)))) H);  intros.
  apply (rem_1963 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1965 : forall X1 X2 X3 X4:term, auto_knows_current (crypt (cons t_current (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil))))) (key sym (cons X1 (cons server nil)))) -> auto___def_76 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_693 (cons t_current (cons (l X1 X2) (cons X3 (cons X2 (cons X4 nil))))) (key sym (cons X1 (cons server nil))) H);  intros.
  apply (rem_1787 X1 X2 X3 X4);  tauto.
  apply (rem_1806 X1 X2 X3 X4);  tauto.
  apply (rem_1807 X1 X2 X3 X4);  tauto.
  apply (rem_1822 X1 X2 X3 X4);  tauto.
  apply (rem_1825 X1 X2 X3 X4);  tauto.
  apply (rem_1949 X1 X2 X3 X4);  tauto.
  apply (rem_1964 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1966 : forall X1:term, auto___type_2 X1 -> auto___type_2 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1967 : forall X1 X2:term, auto___def_29 X2 -> auto___type_2 X1 -> auto___type_2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_2 X1 -> auto___type_2 X1). tauto. exact (rem_1966 X1).
Qed.

Remark rem_1968 : forall X2:term, auto___def_29 X2 -> auto___def_29 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1969 : forall X1 X2:term, auto___def_29 X2 -> auto___type_2 X1 -> auto___def_29 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_29 X2 -> auto___def_29 X2). tauto. exact (rem_1968 X2).
Qed.

Remark rem_1970 : forall X1 X2:term, auto___def_29 X2 -> auto___type_2 X1 -> (auto___type_2 X1 /\ auto___def_29 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_2 X1). 2:apply (rem_1967 X1 X2);  assumption.
  cut (auto___def_29 X2). 2:apply (rem_1969 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1971 : forall X1 X2:term, auto___def_29 X2 -> auto___type_2 X1 -> auto___def_28 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1970 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_28_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1972 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1973 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1. intros A1.
  cut (auto_knows_old X1). 2:apply (rem_1972 epsilon_mknows_old_p__type_2 X1);  assumption.
  tauto.
Defined.

Remark rem_1974 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1:term, auto_knows_old X1 -> auto___type_2 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1. intros A1.
  case (rem_1973 epsilon_mknows_old_p__type_2 X1 A1). clear  epsilon_mknows_old_p__type_2 A1. intros. apply trans___type_2_s_1;  tauto.
 clear  epsilon_mknows_old_p__type_2 A1. tauto.
Defined.

Remark rem_1975 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1:term, auto_knows_old (s X1) -> auto___type_2 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1. intro H. intros.
  elim (rem_241 X1 H);  intros.
  apply (rem_1974 epsilon_mknows_old_p__type_2 X1);  tauto.
Defined.

Remark rem_1976 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_2.  tauto.
Defined.

Remark rem_1977 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> auto___type_2 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_2.  case (rem_1976 epsilon_mknows_old_p__type_2). clear  epsilon_mknows_old_p__type_2. intros. apply trans___type_2_nil_1;  tauto.
 clear  epsilon_mknows_old_p__type_2. tauto.
Defined.

Remark rem_1978 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> auto_knows_old nil -> auto___type_2 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intro H. intros.
  elim (rem_245 H);  intros.
  apply (rem_1977 epsilon_mknows_old_p__type_2);  tauto.
Defined.

Remark rem_1979 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> auto___type_2 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_2.  case (rem_1976 epsilon_mknows_old_p__type_2). clear  epsilon_mknows_old_p__type_2. intros. apply trans___type_2_i_1;  tauto.
 clear  epsilon_mknows_old_p__type_2. tauto.
Defined.

Remark rem_1980 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> auto_knows_old i -> auto___type_2 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intro H. intros.
  elim (rem_248 H);  intros.
  apply (rem_1979 epsilon_mknows_old_p__type_2);  tauto.
Defined.

Remark rem_1981 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2.
  cut (auto_knows_old X1 -> auto_knows_old X1). tauto. exact (rem_1972 epsilon_mknows_old_p__type_2 X1).
Defined.

Remark rem_1982 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X2:term, auto_knows_old X2 -> auto_knows_old X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1983 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_1982 epsilon_mknows_old_p__type_2 X2).
Defined.

Remark rem_1984 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> (auto_knows_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_1981 epsilon_mknows_old_p__type_2 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_1983 epsilon_mknows_old_p__type_2 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1985 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_2 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2. intros A1 A2.
  case (rem_1984 epsilon_mknows_old_p__type_2 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_2 A1 A2. intros. apply trans___type_2_cons_1;  tauto.
 clear  epsilon_mknows_old_p__type_2 A1 A2. tauto.
Defined.

Remark rem_1986 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto_knows_old (cons X1 X2) -> auto___type_2 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2. intro H. intros.
  elim (rem_255 X1 X2 H);  intros.
  apply (rem_1985 epsilon_mknows_old_p__type_2 X1 X2);  tauto.
Defined.

Remark rem_1987 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_2 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2. intros A1 A2.
  case (rem_1984 epsilon_mknows_old_p__type_2 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_2 A1 A2. intros. apply trans___type_2_crypt_1;  tauto.
 clear  epsilon_mknows_old_p__type_2 A1 A2. tauto.
Defined.

Remark rem_1988 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1:term, auto___def_37 X1 -> auto___def_37 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1989 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> auto___def_37 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2.
  cut (auto___def_37 X1 -> auto___def_37 X1). tauto. exact (rem_1988 epsilon_mknows_old_p__type_2 X1).
Defined.

Remark rem_1990 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X2:term, auto___type_5 X2 -> auto___type_5 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1991 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> auto___type_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2.
  cut (auto___type_5 X2 -> auto___type_5 X2). tauto. exact (rem_1990 epsilon_mknows_old_p__type_2 X2).
Defined.

Remark rem_1992 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> (auto___def_37 X1 /\ auto___type_5 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2. intros A1 A2.
  cut (auto___def_37 X1). 2:apply (rem_1989 epsilon_mknows_old_p__type_2 X1 X2);  assumption.
  cut (auto___type_5 X2). 2:apply (rem_1991 epsilon_mknows_old_p__type_2 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1993 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> auto___type_2 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2. intros A1 A2.
  case (rem_1992 epsilon_mknows_old_p__type_2 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_2 A1 A2. intros. apply trans___type_2_crypt_2;  tauto.
 clear  epsilon_mknows_old_p__type_2 A1 A2. tauto.
Defined.

Remark rem_1994 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1:term, auto___def_23 X1 -> auto___def_23 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1995 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_23 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2.
  cut (auto___def_23 X1 -> auto___def_23 X1). tauto. exact (rem_1994 epsilon_mknows_old_p__type_2 X1).
Defined.

Remark rem_1996 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X2:term, auto___def_24 X2 -> auto___def_24 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1997 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_24 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2.
  cut (auto___def_24 X2 -> auto___def_24 X2). tauto. exact (rem_1996 epsilon_mknows_old_p__type_2 X2).
Defined.

Remark rem_1998 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> (auto___def_23 X1 /\ auto___def_24 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2. intros A1 A2.
  cut (auto___def_23 X1). 2:apply (rem_1995 epsilon_mknows_old_p__type_2 X1 X2);  assumption.
  cut (auto___def_24 X2). 2:apply (rem_1997 epsilon_mknows_old_p__type_2 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1999 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___type_2 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2. intros A1 A2.
  case (rem_1998 epsilon_mknows_old_p__type_2 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_2 A1 A2. intros. apply trans___type_2_crypt_3;  tauto.
 clear  epsilon_mknows_old_p__type_2 A1 A2. tauto.
Defined.

Remark rem_2000 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1:term, auto___def_10 X1 -> auto___def_10 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2001 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_10 X1). tauto. exact (rem_2000 epsilon_mknows_old_p__type_2 X1).
Defined.

Remark rem_2002 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X2:term, auto___def_11 X2 -> auto___def_11 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2003 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2.
  cut (auto___def_11 X2 -> auto___def_11 X2). tauto. exact (rem_2002 epsilon_mknows_old_p__type_2 X2).
Defined.

Remark rem_2004 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> (auto___def_10 X1 /\ auto___def_11 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2. intros A1 A2.
  cut (auto___def_10 X1). 2:apply (rem_2001 epsilon_mknows_old_p__type_2 X1 X2);  assumption.
  cut (auto___def_11 X2). 2:apply (rem_2003 epsilon_mknows_old_p__type_2 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2005 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___type_2 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2. intros A1 A2.
  case (rem_2004 epsilon_mknows_old_p__type_2 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_2 A1 A2. intros. apply trans___type_2_crypt_4;  tauto.
 clear  epsilon_mknows_old_p__type_2 A1 A2. tauto.
Defined.

Remark rem_2006 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1:term, auto___def_41 X1 -> auto___def_41 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2007 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> auto___def_41 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2.
  cut (auto___def_41 X1 -> auto___def_41 X1). tauto. exact (rem_2006 epsilon_mknows_old_p__type_2 X1).
Defined.

Remark rem_2008 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X2:term, auto___type_7 X2 -> auto___type_7 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2009 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> auto___type_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2.
  cut (auto___type_7 X2 -> auto___type_7 X2). tauto. exact (rem_2008 epsilon_mknows_old_p__type_2 X2).
Defined.

Remark rem_2010 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> (auto___def_41 X1 /\ auto___type_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2. intros A1 A2.
  cut (auto___def_41 X1). 2:apply (rem_2007 epsilon_mknows_old_p__type_2 X1 X2);  assumption.
  cut (auto___type_7 X2). 2:apply (rem_2009 epsilon_mknows_old_p__type_2 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2011 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> auto___type_2 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2. intros A1 A2.
  case (rem_2010 epsilon_mknows_old_p__type_2 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_2 A1 A2. intros. apply trans___type_2_crypt_5;  tauto.
 clear  epsilon_mknows_old_p__type_2 A1 A2. tauto.
Defined.

Remark rem_2012 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto_knows_old (crypt X1 X2) -> auto___type_2 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2. intro H. intros.
  elim (rem_565 X1 X2 H);  intros.
  apply (rem_1987 epsilon_mknows_old_p__type_2 X1 X2);  tauto.
  apply (rem_1993 epsilon_mknows_old_p__type_2 X1 X2);  tauto.
  apply (rem_1999 epsilon_mknows_old_p__type_2 X1 X2);  tauto.
  apply (rem_2005 epsilon_mknows_old_p__type_2 X1 X2);  tauto.
  apply (rem_2011 epsilon_mknows_old_p__type_2 X1 X2);  tauto.
Defined.

Remark rem_2013 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> auto___type_2 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_2.  case (rem_1976 epsilon_mknows_old_p__type_2). clear  epsilon_mknows_old_p__type_2. intros. apply trans___type_2_bob_1;  tauto.
 clear  epsilon_mknows_old_p__type_2. tauto.
Defined.

Remark rem_2014 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> auto_knows_old bob -> auto___type_2 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intro H. intros.
  elim (rem_568 H);  intros.
  apply (rem_2013 epsilon_mknows_old_p__type_2);  tauto.
Defined.

Remark rem_2015 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1:term, auto___def_42 X1 -> auto___def_42 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2016 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___def_42 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2.
  cut (auto___def_42 X1 -> auto___def_42 X1). tauto. exact (rem_2015 epsilon_mknows_old_p__type_2 X1).
Defined.

Remark rem_2017 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2018 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_2017 epsilon_mknows_old_p__type_2 X2).
Defined.

Remark rem_2019 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> (auto___def_42 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2. intros A1 A2.
  cut (auto___def_42 X1). 2:apply (rem_2016 epsilon_mknows_old_p__type_2 X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_2018 epsilon_mknows_old_p__type_2 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2020 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___type_2 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2. intros A1 A2.
  case (rem_2019 epsilon_mknows_old_p__type_2 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_2 A1 A2. intros. apply trans___type_2_key_1;  tauto.
 clear  epsilon_mknows_old_p__type_2 A1 A2. tauto.
Defined.

Remark rem_2021 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1:term, auto___def_43 X1 -> auto___def_43 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2022 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_43 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_43 X1). tauto. exact (rem_2021 epsilon_mknows_old_p__type_2 X1).
Defined.

Remark rem_2023 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X2:term, auto___def_44 X2 -> auto___def_44 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2024 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_44 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2.
  cut (auto___def_44 X2 -> auto___def_44 X2). tauto. exact (rem_2023 epsilon_mknows_old_p__type_2 X2).
Defined.

Remark rem_2025 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> (auto___def_43 X1 /\ auto___def_44 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2. intros A1 A2.
  cut (auto___def_43 X1). 2:apply (rem_2022 epsilon_mknows_old_p__type_2 X1 X2);  assumption.
  cut (auto___def_44 X2). 2:apply (rem_2024 epsilon_mknows_old_p__type_2 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2026 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___type_2 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2. intros A1 A2.
  case (rem_2025 epsilon_mknows_old_p__type_2 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_2 A1 A2. intros. apply trans___type_2_key_2;  tauto.
 clear  epsilon_mknows_old_p__type_2 A1 A2. tauto.
Defined.

Remark rem_2027 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> forall X1 X2:term, auto_knows_old (key X1 X2) -> auto___type_2 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intros X1 X2. intro H. intros.
  elim (rem_582 X1 X2 H);  intros.
  apply (rem_2020 epsilon_mknows_old_p__type_2 X1 X2);  tauto.
  apply (rem_2026 epsilon_mknows_old_p__type_2 X1 X2);  tauto.
Defined.

Remark rem_2028 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> auto___type_2 t_old. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_2.  case (rem_1976 epsilon_mknows_old_p__type_2). clear  epsilon_mknows_old_p__type_2. intros. apply trans___type_2_t_old_1;  tauto.
 clear  epsilon_mknows_old_p__type_2. tauto.
Defined.

Remark rem_2029 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> auto_knows_old t_old -> auto___type_2 t_old. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intro H. intros.
  elim (rem_585 H);  intros.
  apply (rem_2028 epsilon_mknows_old_p__type_2);  tauto.
Defined.

Remark rem_2030 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> auto___type_2 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_2.  case (rem_1976 epsilon_mknows_old_p__type_2). clear  epsilon_mknows_old_p__type_2. intros. apply trans___type_2_alice_1;  tauto.
 clear  epsilon_mknows_old_p__type_2. tauto.
Defined.

Remark rem_2031 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> auto_knows_old alice -> auto___type_2 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intro H. intros.
  elim (rem_588 H);  intros.
  apply (rem_2030 epsilon_mknows_old_p__type_2);  tauto.
Defined.

Remark rem_2032 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> auto___type_2 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_2.  case (rem_1976 epsilon_mknows_old_p__type_2). clear  epsilon_mknows_old_p__type_2. intros. apply trans___type_2_server_1;  tauto.
 clear  epsilon_mknows_old_p__type_2. tauto.
Defined.

Remark rem_2033 : (forall X:term, auto_knows_old X -> auto___type_2 X)
    -> auto_knows_old server -> auto___type_2 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_2. intro H. intros.
  elim (rem_591 H);  intros.
  apply (rem_2032 epsilon_mknows_old_p__type_2);  tauto.
Defined.

Remark rem_2034 : forall X1:term, auto_knows_old X1 -> auto___type_2 X1. (* Induct. *)
Proof.
  fix epsilon_mknows_old_p__type_2 1.
  intro X. case X.
  exact (rem_2031 epsilon_mknows_old_p__type_2 ).
  exact (rem_2014 epsilon_mknows_old_p__type_2 ).
  intros X1 X2;  exact (rem_1986 epsilon_mknows_old_p__type_2 X1 X2).
  intros X1 X2;  exact (rem_2012 epsilon_mknows_old_p__type_2 X1 X2).
  exact (rem_1980 epsilon_mknows_old_p__type_2 ).
  intros X1 X2;  exact (rem_2027 epsilon_mknows_old_p__type_2 X1 X2).
  intros X1 X2. intro H. elim (rem_597 X1 X2 H).
  exact (rem_1978 epsilon_mknows_old_p__type_2 ).
   intro H. elim (rem_596  H).
   intro H. elim (rem_598  H).
  intros X1;  exact (rem_1975 epsilon_mknows_old_p__type_2 X1).
  exact (rem_2033 epsilon_mknows_old_p__type_2 ).
  intros X1 X2. intro H. elim (rem_593 X1 X2 H).
  intros X1 X2. intro H. elim (rem_594 X1 X2 H).
   intro H. elim (rem_595  H).
   intro H. elim (rem_599  H).
  exact (rem_2029 epsilon_mknows_old_p__type_2 ).
Qed.

Remark rem_2035 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old X1 -> auto___type_2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_old X1 -> auto___type_2 X1). tauto. exact (rem_2034 X1).
Qed.

Remark rem_2036 : forall X1 X2:term, auto___def_9 X1 X2 -> or_1
    (auto_knows_old X1 /\ auto_knows_old X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2037 : forall X1 X2:term, auto___def_9 X2 X1 -> auto___type_2 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_2036 X2 X1 H);  intros.
  apply (rem_2035 X1 X2);  tauto.
Qed.

Remark rem_2038 : forall X1:term, auto___def_14 X1 -> auto___def_14 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2039 : forall X1 X2:term, auto___def_14 X1 -> auto___def_26 X2 -> auto___def_14 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_14 X1 -> auto___def_14 X1). tauto. exact (rem_2038 X1).
Qed.

Remark rem_2040 : forall X2:term, auto___def_26 X2 -> auto___def_26 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2041 : forall X1 X2:term, auto___def_14 X1 -> auto___def_26 X2 -> auto___def_26 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_26 X2 -> auto___def_26 X2). tauto. exact (rem_2040 X2).
Qed.

Remark rem_2042 : forall X1 X2:term, auto___def_14 X1 -> auto___def_26 X2 -> (auto___def_14 X1 /\ auto___def_26 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_14 X1). 2:apply (rem_2039 X1 X2);  assumption.
  cut (auto___def_26 X2). 2:apply (rem_2041 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2043 : forall X1 X2:term, auto___def_14 X1 -> auto___def_26 X2 -> auto___def_25 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2042 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_25_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2044 : forall X1 X2:term, auto___def_26 X2 -> auto___def_14 X1 -> auto___def_25 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_14 X1 -> auto___def_26 X2 -> auto___def_25 (cons X1 X2)). tauto. exact (rem_2043 X1 X2).
Qed.

Remark rem_2045 : forall X1:term, auto___type_3 X1 -> auto___type_3 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2046 : forall X1 X2:term, auto___def_29 X2 -> auto___type_3 X1 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_3 X1 -> auto___type_3 X1). tauto. exact (rem_2045 X1).
Qed.

Remark rem_2047 : forall X1 X2:term, auto___def_29 X2 -> auto___type_3 X1 -> auto___def_29 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_29 X2 -> auto___def_29 X2). tauto. exact (rem_1968 X2).
Qed.

Remark rem_2048 : forall X1 X2:term, auto___def_29 X2 -> auto___type_3 X1 -> (auto___type_3 X1 /\ auto___def_29 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_3 X1). 2:apply (rem_2046 X1 X2);  assumption.
  cut (auto___def_29 X2). 2:apply (rem_2047 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2049 : forall X1 X2:term, auto___def_29 X2 -> auto___type_3 X1 -> auto___def_32 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2048 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_32_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2050 : forall X1:term, auto___type_9 X1 -> auto___type_9 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2051 : forall X1 X2:term, auto___def_65 X2 -> auto___type_9 X1 -> auto___type_9 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_9 X1 -> auto___type_9 X1). tauto. exact (rem_2050 X1).
Qed.

Remark rem_2052 : forall X2:term, auto___def_65 X2 -> auto___def_65 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2053 : forall X1 X2:term, auto___def_65 X2 -> auto___type_9 X1 -> auto___def_65 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_65 X2 -> auto___def_65 X2). tauto. exact (rem_2052 X2).
Qed.

Remark rem_2054 : forall X1 X2:term, auto___def_65 X2 -> auto___type_9 X1 -> (auto___type_9 X1 /\ auto___def_65 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_9 X1). 2:apply (rem_2051 X1 X2);  assumption.
  cut (auto___def_65 X2). 2:apply (rem_2053 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2055 : forall X1 X2:term, auto___def_65 X2 -> auto___type_9 X1 -> auto___def_62 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2054 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_62_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2056 : forall X1:term, auto___def_66 X1 -> auto___def_66 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2057 : forall X1 X2:term, auto___def_66 X1 -> auto___def_67 X2 -> auto___def_66 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_66 X1 -> auto___def_66 X1). tauto. exact (rem_2056 X1).
Qed.

Remark rem_2058 : forall X2:term, auto___def_67 X2 -> auto___def_67 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2059 : forall X1 X2:term, auto___def_66 X1 -> auto___def_67 X2 -> auto___def_67 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_67 X2 -> auto___def_67 X2). tauto. exact (rem_2058 X2).
Qed.

Remark rem_2060 : forall X1 X2:term, auto___def_66 X1 -> auto___def_67 X2 -> (auto___def_66 X1 /\ auto___def_67 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_66 X1). 2:apply (rem_2057 X1 X2);  assumption.
  cut (auto___def_67 X2). 2:apply (rem_2059 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2061 : forall X1 X2:term, auto___def_66 X1 -> auto___def_67 X2 -> auto___def_65 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2060 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_65_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2062 : forall X1 X2:term, auto___def_67 X2 -> auto___def_66 X1 -> auto___def_65 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_66 X1 -> auto___def_67 X2 -> auto___def_65 (cons X1 X2)). tauto. exact (rem_2061 X1 X2).
Qed.

Remark rem_2063 : forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2064 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_old X1 -> auto_knows_old X1). tauto. exact (rem_2063 X1).
Qed.

Remark rem_2065 : forall X2:term, auto_knows_old X2 -> auto_knows_old X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2066 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_2065 X2).
Qed.

Remark rem_2067 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old X1 -> (auto_knows_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_2064 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_2066 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2068 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old X1 -> auto___def_14 (l X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2067 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_14_l_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2069 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___def_14 (l X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_old X1 -> auto___def_14 (l X1 X2)). tauto. exact (rem_2068 X1 X2).
Qed.

Remark rem_2070 : forall X1 X2:term, auto___def_9 X1 X2 -> auto___def_14 (l X1 X2). (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_2036 X1 X2 H);  intros.
  apply (rem_2069 X1 X2);  tauto.
Qed.

Remark rem_2071 : auto___def_63 prv -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_59 H);  intros.
Qed.

Remark rem_2072 : forall X1 X2:term, auto___def_63 prv -> auto___def_64 X1 -> auto___def_80 X2 -> auto___def_50 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_63 prv -> False). tauto.
  exact (rem_2071).
Qed.

Remark rem_2073 : forall X1 X2:term, auto___def_80 X2 -> auto___type_12 (key prv X1) -> auto___def_50 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_103 prv X1 H);  intros.
  apply (rem_2072 X1 X2);  tauto.
Qed.

Remark rem_2074 : auto___def_42 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2075 : auto___def_42 prv -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_2074 H);  intros.
Qed.

Remark rem_2076 : forall X1 X2:term, auto___def_42 prv -> auto_knows_current X2 -> auto___def_50 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_42 prv -> False). tauto.
  exact (rem_2075).
Qed.

Remark rem_2077 : forall X1 X2:term, auto___def_42 prv -> auto___type_8 X1 -> auto_knows_current X2 -> auto___def_50 X1 X2. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2. intros. apply (rem_2076 X1 X2);  assumption.
Qed.

Remark rem_2078 : auto___def_46 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2079 : auto___def_46 prv -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_2078 H);  intros.
Qed.

Remark rem_2080 : forall X1 X2:term, auto___def_46 prv -> auto___def_47 X1 -> auto_knows_current X2 -> auto___def_50 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_46 prv -> False). tauto.
  exact (rem_2079).
Qed.

Remark rem_2081 : forall X1:term, auto___def_44 X1 -> auto___def_44 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2082 : forall X1 X2:term, auto___def_43 prv -> auto___def_44 X1 -> auto_knows_current X2 -> auto___def_44 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_44 X1 -> auto___def_44 X1). tauto. exact (rem_2081 X1).
Qed.

Remark rem_2083 : forall X1 X2:term, auto___def_43 prv -> auto___def_44 X1 -> auto_knows_current X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_652 X2).
Qed.

Remark rem_2084 : forall X1 X2:term, auto___def_43 prv -> auto___def_44 X1 -> auto_knows_current X2 -> (auto___def_44 X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_44 X1). 2:apply (rem_2082 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2083 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2085 : forall X1 X2:term, auto___def_43 prv -> auto___def_44 X1 -> auto_knows_current X2 -> auto___def_50 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_2084 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_50_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2086 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current (key prv X1) -> auto___def_50 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_101 prv X1 H);  intros.
  apply (rem_2077 X1 X2);  tauto.
  apply (rem_2080 X1 X2);  tauto.
  apply (rem_2085 X1 X2);  tauto.
Qed.

Remark rem_2087 : forall X1 X2:term, auto___def_63 prv -> auto___def_64 X1 -> auto___def_84 X2 -> auto___def_50 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_63 prv -> False). tauto.
  exact (rem_2071).
Qed.

Remark rem_2088 : forall X1 X2:term, auto___def_84 X2 -> auto___type_14 (key prv X1) -> auto___def_50 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_1669 prv X1 H);  intros.
  apply (rem_2087 X1 X2);  tauto.
Qed.

Remark rem_2089 : auto___def_18 prv -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_290 H);  intros.
Qed.

Remark rem_2090 : forall X1 X2:term, auto___def_18 prv -> auto___def_23 X2 -> auto___def_28 X1 -> auto___def_50 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 prv -> False). tauto.
  exact (rem_2089).
Qed.

Remark rem_2091 : forall X1 X2:term, auto___def_18 prv -> auto___def_28 X1 -> auto___def_23 X2 -> auto___def_50 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_18 prv -> auto___def_23 X2 -> auto___def_28 X1 -> auto___def_50 X1 X2). tauto. exact (rem_2090 X1 X2).
Qed.

Remark rem_2092 : forall X1 X2:term, auto___def_23 X2 -> auto___def_24 (key prv X1) -> auto___def_50 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_624 prv X1 H);  intros.
  apply (rem_2091 X1 X2);  tauto.
Qed.

Remark rem_2093 : forall X1 X2:term, auto___def_10 X2 -> auto___def_18 prv -> auto___def_32 X1 -> auto___def_50 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 prv -> False). tauto.
  exact (rem_2089).
Qed.

Remark rem_2094 : forall X1 X2:term, auto___def_18 prv -> auto___def_32 X1 -> auto___def_10 X2 -> auto___def_50 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_10 X2 -> auto___def_18 prv -> auto___def_32 X1 -> auto___def_50 X1 X2). tauto. exact (rem_2093 X1 X2).
Qed.

Remark rem_2095 : forall X1 X2:term, auto___def_10 X2 -> auto___def_11 (key prv X1) -> auto___def_50 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_644 prv X1 H);  intros.
  apply (rem_2094 X1 X2);  tauto.
Qed.

Remark rem_2096 : forall X1 X2:term, auto___def_55 X2 -> auto___def_63 prv -> auto___def_75 X1 -> auto___def_50 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_63 prv -> False). tauto.
  exact (rem_2071).
Qed.

Remark rem_2097 : forall X1 X2:term, auto___def_63 prv -> auto___def_75 X1 -> auto___def_55 X2 -> auto___def_50 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_55 X2 -> auto___def_63 prv -> auto___def_75 X1 -> auto___def_50 X1 X2). tauto. exact (rem_2096 X1 X2).
Qed.

Remark rem_2098 : forall X1 X2:term, auto___def_55 X2 -> auto___def_56 (key prv X1) -> auto___def_50 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_667 prv X1 H);  intros.
  apply (rem_2097 X1 X2);  tauto.
Qed.

Remark rem_2099 : forall X1 X2:term, auto___def_63 prv -> auto___def_68 X2 -> auto___def_73 X1 -> auto___def_50 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_63 prv -> False). tauto.
  exact (rem_2071).
Qed.

Remark rem_2100 : forall X1 X2:term, auto___def_63 prv -> auto___def_73 X1 -> auto___def_68 X2 -> auto___def_50 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_63 prv -> auto___def_68 X2 -> auto___def_73 X1 -> auto___def_50 X1 X2). tauto. exact (rem_2099 X1 X2).
Qed.

Remark rem_2101 : forall X1 X2:term, auto___def_68 X2 -> auto___def_69 (key prv X1) -> auto___def_50 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_687 prv X1 H);  intros.
  apply (rem_2100 X1 X2);  tauto.
Qed.

Remark rem_2102 : forall X1 X2:term, auto_knows_current (crypt X2 (key prv X1)) -> auto___def_50 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_693 X2 (key prv X1) H);  intros.
  apply (rem_2073 X1 X2);  tauto.
  apply (rem_2086 X1 X2);  tauto.
  apply (rem_2088 X1 X2);  tauto.
  apply (rem_2092 X1 X2);  tauto.
  apply (rem_2095 X1 X2);  tauto.
  apply (rem_2098 X1 X2);  tauto.
  apply (rem_2101 X1 X2);  tauto.
Qed.

Remark rem_2103 : (forall X:term, auto___type_12 X -> auto___def_85 X)
    -> forall X1:term, auto___def_63 X1 -> auto___def_63 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2104 : (forall X:term, auto___type_12 X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_63 X1 -> auto___def_64 X2 -> auto___def_63 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_12_p__def_85. intros X1 X2.
  cut (auto___def_63 X1 -> auto___def_63 X1). tauto. exact (rem_2103 epsilon_m__type_12_p__def_85 X1).
Defined.

Remark rem_2105 : (forall X:term, auto___type_12 X -> auto___def_85 X)
    -> forall X2:term, auto___def_64 X2 -> auto___def_64 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2106 : (forall X:term, auto___type_12 X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_63 X1 -> auto___def_64 X2 -> auto___def_64 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_12_p__def_85. intros X1 X2.
  cut (auto___def_64 X2 -> auto___def_64 X2). tauto. exact (rem_2105 epsilon_m__type_12_p__def_85 X2).
Defined.

Remark rem_2107 : (forall X:term, auto___type_12 X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_63 X1 -> auto___def_64 X2 -> (auto___def_63 X1 /\ auto___def_64 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_12_p__def_85. intros X1 X2. intros A1 A2.
  cut (auto___def_63 X1). 2:apply (rem_2104 epsilon_m__type_12_p__def_85 X1 X2);  assumption.
  cut (auto___def_64 X2). 2:apply (rem_2106 epsilon_m__type_12_p__def_85 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2108 : (forall X:term, auto___type_12 X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_63 X1 -> auto___def_64 X2 -> auto___def_85 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_12_p__def_85. intros X1 X2. intros A1 A2.
  case (rem_2107 epsilon_m__type_12_p__def_85 X1 X2 A1 A2). clear  epsilon_m__type_12_p__def_85 A1 A2. intros. apply trans___def_85_key_2;  tauto.
 clear  epsilon_m__type_12_p__def_85 A1 A2. tauto.
Defined.

Remark rem_2109 : (forall X:term, auto___type_12 X -> auto___def_85 X)
    -> forall X1 X2:term, auto___type_12 (key X1 X2) -> auto___def_85 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_12_p__def_85. intros X1 X2. intro H. intros.
  elim (rem_103 X1 X2 H);  intros.
  apply (rem_2108 epsilon_m__type_12_p__def_85 X1 X2);  tauto.
Defined.

Remark rem_2110 : forall X1:term, auto___type_12 X1 -> auto___def_85 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_12_p__def_85 1.
  intro X. case X.
   intro H. elim (rem_118  H).
   intro H. elim (rem_115  H).
  intros X1 X2. intro H. elim (rem_110 X1 X2 H).
  intros X1 X2. intro H. elim (rem_114 X1 X2 H).
   intro H. elim (rem_108  H).
  intros X1 X2;  exact (rem_2109 epsilon_m__type_12_p__def_85 X1 X2).
  intros X1 X2. intro H. elim (rem_113 X1 X2 H).
   intro H. elim (rem_107  H).
   intro H. elim (rem_112  H).
   intro H. elim (rem_116  H).
  intros X1. intro H. elim (rem_106 X1 H).
   intro H. elim (rem_119  H).
  intros X1 X2. intro H. elim (rem_105 X1 X2 H).
  intros X1 X2. intro H. elim (rem_109 X1 X2 H).
   intro H. elim (rem_111  H).
   intro H. elim (rem_120  H).
   intro H. elim (rem_117  H).
Qed.

Remark rem_2111 : forall X1:term, auto___def_80 (s t_current) -> auto___type_12 X1 -> auto___def_85 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1.
  cut (auto___type_12 X1 -> auto___def_85 X1). tauto. exact (rem_2110 X1).
Qed.

Remark rem_2112 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2113 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_2112 epsilon_mknows_current_p__def_85 X1);  assumption.
  tauto.
Defined.

Remark rem_2114 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1:term, auto_knows_current X1 -> auto___def_85 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1. intros A1.
  case (rem_2113 epsilon_mknows_current_p__def_85 X1 A1). clear  epsilon_mknows_current_p__def_85 A1. intros. apply trans___def_85_s_1;  tauto.
 clear  epsilon_mknows_current_p__def_85 A1. tauto.
Defined.

Remark rem_2115 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1:term, auto_knows_current (s X1) -> auto___def_85 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1. intro H. intros.
  elim (rem_752 X1 H);  intros.
  apply (rem_2114 epsilon_mknows_current_p__def_85 X1);  tauto.
Defined.

Remark rem_2116 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__def_85.  tauto.
Defined.

Remark rem_2117 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> auto___def_85 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85.  case (rem_2116 epsilon_mknows_current_p__def_85). clear  epsilon_mknows_current_p__def_85. intros. apply trans___def_85_nil_1;  tauto.
 clear  epsilon_mknows_current_p__def_85. tauto.
Defined.

Remark rem_2118 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> auto_knows_current nil -> auto___def_85 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intro H. intros.
  elim (rem_756 H);  intros.
  apply (rem_2117 epsilon_mknows_current_p__def_85);  tauto.
Defined.

Remark rem_2119 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> auto___def_85 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85.  case (rem_2116 epsilon_mknows_current_p__def_85). clear  epsilon_mknows_current_p__def_85. intros. apply trans___def_85_i_1;  tauto.
 clear  epsilon_mknows_current_p__def_85. tauto.
Defined.

Remark rem_2120 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> auto_knows_current i -> auto___def_85 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intro H. intros.
  elim (rem_759 H);  intros.
  apply (rem_2119 epsilon_mknows_current_p__def_85);  tauto.
Defined.

Remark rem_2121 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_2112 epsilon_mknows_current_p__def_85 X1).
Defined.

Remark rem_2122 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X2:term, auto_knows_current X2 -> auto_knows_current X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2123 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_2122 epsilon_mknows_current_p__def_85 X2).
Defined.

Remark rem_2124 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2121 epsilon_mknows_current_p__def_85 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2123 epsilon_mknows_current_p__def_85 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2125 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___def_85 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2. intros A1 A2.
  case (rem_2124 epsilon_mknows_current_p__def_85 X1 X2 A1 A2). clear  epsilon_mknows_current_p__def_85 A1 A2. intros. apply trans___def_85_cons_1;  tauto.
 clear  epsilon_mknows_current_p__def_85 A1 A2. tauto.
Defined.

Remark rem_2126 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto_knows_current (cons X1 X2) -> auto___def_85 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2. intro H. intros.
  elim (rem_124 X1 X2 H);  intros.
  apply (rem_2125 epsilon_mknows_current_p__def_85 X1 X2);  tauto.
Defined.

Remark rem_2127 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1:term, auto___def_80 X1 -> auto___def_80 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2128 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> auto___def_80 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2.
  cut (auto___def_80 X1 -> auto___def_80 X1). tauto. exact (rem_2127 epsilon_mknows_current_p__def_85 X1).
Defined.

Remark rem_2129 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X2:term, auto___type_12 X2 -> auto___type_12 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2130 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> auto___type_12 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2.
  cut (auto___type_12 X2 -> auto___type_12 X2). tauto. exact (rem_2129 epsilon_mknows_current_p__def_85 X2).
Defined.

Remark rem_2131 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> (auto___def_80 X1 /\ auto___type_12 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2. intros A1 A2.
  cut (auto___def_80 X1). 2:apply (rem_2128 epsilon_mknows_current_p__def_85 X1 X2);  assumption.
  cut (auto___type_12 X2). 2:apply (rem_2130 epsilon_mknows_current_p__def_85 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2132 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> auto___def_85 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2. intros A1 A2.
  case (rem_2131 epsilon_mknows_current_p__def_85 X1 X2 A1 A2). clear  epsilon_mknows_current_p__def_85 A1 A2. intros. apply trans___def_85_crypt_1;  tauto.
 clear  epsilon_mknows_current_p__def_85 A1 A2. tauto.
Defined.

Remark rem_2133 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___def_85 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2. intros A1 A2.
  case (rem_2124 epsilon_mknows_current_p__def_85 X1 X2 A1 A2). clear  epsilon_mknows_current_p__def_85 A1 A2. intros. apply trans___def_85_crypt_2;  tauto.
 clear  epsilon_mknows_current_p__def_85 A1 A2. tauto.
Defined.

Remark rem_2134 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1:term, auto___def_84 X1 -> auto___def_84 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2135 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> auto___def_84 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2.
  cut (auto___def_84 X1 -> auto___def_84 X1). tauto. exact (rem_2134 epsilon_mknows_current_p__def_85 X1).
Defined.

Remark rem_2136 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X2:term, auto___type_14 X2 -> auto___type_14 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2137 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> auto___type_14 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2.
  cut (auto___type_14 X2 -> auto___type_14 X2). tauto. exact (rem_2136 epsilon_mknows_current_p__def_85 X2).
Defined.

Remark rem_2138 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> (auto___def_84 X1 /\ auto___type_14 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2. intros A1 A2.
  cut (auto___def_84 X1). 2:apply (rem_2135 epsilon_mknows_current_p__def_85 X1 X2);  assumption.
  cut (auto___type_14 X2). 2:apply (rem_2137 epsilon_mknows_current_p__def_85 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2139 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> auto___def_85 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2. intros A1 A2.
  case (rem_2138 epsilon_mknows_current_p__def_85 X1 X2 A1 A2). clear  epsilon_mknows_current_p__def_85 A1 A2. intros. apply trans___def_85_crypt_3;  tauto.
 clear  epsilon_mknows_current_p__def_85 A1 A2. tauto.
Defined.

Remark rem_2140 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1:term, auto___def_23 X1 -> auto___def_23 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2141 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_23 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2.
  cut (auto___def_23 X1 -> auto___def_23 X1). tauto. exact (rem_2140 epsilon_mknows_current_p__def_85 X1).
Defined.

Remark rem_2142 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X2:term, auto___def_24 X2 -> auto___def_24 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2143 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_24 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2.
  cut (auto___def_24 X2 -> auto___def_24 X2). tauto. exact (rem_2142 epsilon_mknows_current_p__def_85 X2).
Defined.

Remark rem_2144 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> (auto___def_23 X1 /\ auto___def_24 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2. intros A1 A2.
  cut (auto___def_23 X1). 2:apply (rem_2141 epsilon_mknows_current_p__def_85 X1 X2);  assumption.
  cut (auto___def_24 X2). 2:apply (rem_2143 epsilon_mknows_current_p__def_85 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2145 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_85 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2. intros A1 A2.
  case (rem_2144 epsilon_mknows_current_p__def_85 X1 X2 A1 A2). clear  epsilon_mknows_current_p__def_85 A1 A2. intros. apply trans___def_85_crypt_4;  tauto.
 clear  epsilon_mknows_current_p__def_85 A1 A2. tauto.
Defined.

Remark rem_2146 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1:term, auto___def_10 X1 -> auto___def_10 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2147 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_10 X1). tauto. exact (rem_2146 epsilon_mknows_current_p__def_85 X1).
Defined.

Remark rem_2148 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X2:term, auto___def_11 X2 -> auto___def_11 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2149 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2.
  cut (auto___def_11 X2 -> auto___def_11 X2). tauto. exact (rem_2148 epsilon_mknows_current_p__def_85 X2).
Defined.

Remark rem_2150 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> (auto___def_10 X1 /\ auto___def_11 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2. intros A1 A2.
  cut (auto___def_10 X1). 2:apply (rem_2147 epsilon_mknows_current_p__def_85 X1 X2);  assumption.
  cut (auto___def_11 X2). 2:apply (rem_2149 epsilon_mknows_current_p__def_85 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2151 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_85 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2. intros A1 A2.
  case (rem_2150 epsilon_mknows_current_p__def_85 X1 X2 A1 A2). clear  epsilon_mknows_current_p__def_85 A1 A2. intros. apply trans___def_85_crypt_5;  tauto.
 clear  epsilon_mknows_current_p__def_85 A1 A2. tauto.
Defined.

Remark rem_2152 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1:term, auto___def_55 X1 -> auto___def_55 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2153 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> auto___def_55 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2.
  cut (auto___def_55 X1 -> auto___def_55 X1). tauto. exact (rem_2152 epsilon_mknows_current_p__def_85 X1).
Defined.

Remark rem_2154 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X2:term, auto___def_56 X2 -> auto___def_56 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2155 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> auto___def_56 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2.
  cut (auto___def_56 X2 -> auto___def_56 X2). tauto. exact (rem_2154 epsilon_mknows_current_p__def_85 X2).
Defined.

Remark rem_2156 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> (auto___def_55 X1 /\ auto___def_56 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2. intros A1 A2.
  cut (auto___def_55 X1). 2:apply (rem_2153 epsilon_mknows_current_p__def_85 X1 X2);  assumption.
  cut (auto___def_56 X2). 2:apply (rem_2155 epsilon_mknows_current_p__def_85 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2157 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> auto___def_85 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2. intros A1 A2.
  case (rem_2156 epsilon_mknows_current_p__def_85 X1 X2 A1 A2). clear  epsilon_mknows_current_p__def_85 A1 A2. intros. apply trans___def_85_crypt_6;  tauto.
 clear  epsilon_mknows_current_p__def_85 A1 A2. tauto.
Defined.

Remark rem_2158 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1:term, auto___def_68 X1 -> auto___def_68 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2159 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> auto___def_68 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2.
  cut (auto___def_68 X1 -> auto___def_68 X1). tauto. exact (rem_2158 epsilon_mknows_current_p__def_85 X1).
Defined.

Remark rem_2160 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X2:term, auto___def_69 X2 -> auto___def_69 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2161 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> auto___def_69 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2.
  cut (auto___def_69 X2 -> auto___def_69 X2). tauto. exact (rem_2160 epsilon_mknows_current_p__def_85 X2).
Defined.

Remark rem_2162 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> (auto___def_68 X1 /\ auto___def_69 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2. intros A1 A2.
  cut (auto___def_68 X1). 2:apply (rem_2159 epsilon_mknows_current_p__def_85 X1 X2);  assumption.
  cut (auto___def_69 X2). 2:apply (rem_2161 epsilon_mknows_current_p__def_85 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2163 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> auto___def_85 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2. intros A1 A2.
  case (rem_2162 epsilon_mknows_current_p__def_85 X1 X2 A1 A2). clear  epsilon_mknows_current_p__def_85 A1 A2. intros. apply trans___def_85_crypt_7;  tauto.
 clear  epsilon_mknows_current_p__def_85 A1 A2. tauto.
Defined.

Remark rem_2164 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto_knows_current (crypt X1 X2) -> auto___def_85 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2. intro H. intros.
  elim (rem_693 X1 X2 H);  intros.
  apply (rem_2132 epsilon_mknows_current_p__def_85 X1 X2);  tauto.
  apply (rem_2133 epsilon_mknows_current_p__def_85 X1 X2);  tauto.
  apply (rem_2139 epsilon_mknows_current_p__def_85 X1 X2);  tauto.
  apply (rem_2145 epsilon_mknows_current_p__def_85 X1 X2);  tauto.
  apply (rem_2151 epsilon_mknows_current_p__def_85 X1 X2);  tauto.
  apply (rem_2157 epsilon_mknows_current_p__def_85 X1 X2);  tauto.
  apply (rem_2163 epsilon_mknows_current_p__def_85 X1 X2);  tauto.
Defined.

Remark rem_2165 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> auto___def_85 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85.  case (rem_2116 epsilon_mknows_current_p__def_85). clear  epsilon_mknows_current_p__def_85. intros. apply trans___def_85_bob_1;  tauto.
 clear  epsilon_mknows_current_p__def_85. tauto.
Defined.

Remark rem_2166 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> auto_knows_current bob -> auto___def_85 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intro H. intros.
  elim (rem_806 H);  intros.
  apply (rem_2165 epsilon_mknows_current_p__def_85);  tauto.
Defined.

Remark rem_2167 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1:term, auto___def_42 X1 -> auto___def_42 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2168 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___def_42 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2.
  cut (auto___def_42 X1 -> auto___def_42 X1). tauto. exact (rem_2167 epsilon_mknows_current_p__def_85 X1).
Defined.

Remark rem_2169 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2170 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_2169 epsilon_mknows_current_p__def_85 X2).
Defined.

Remark rem_2171 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> (auto___def_42 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2. intros A1 A2.
  cut (auto___def_42 X1). 2:apply (rem_2168 epsilon_mknows_current_p__def_85 X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_2170 epsilon_mknows_current_p__def_85 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2172 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___def_85 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2. intros A1 A2.
  case (rem_2171 epsilon_mknows_current_p__def_85 X1 X2 A1 A2). clear  epsilon_mknows_current_p__def_85 A1 A2. intros. apply trans___def_85_key_1;  tauto.
 clear  epsilon_mknows_current_p__def_85 A1 A2. tauto.
Defined.

Remark rem_2173 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1:term, auto___def_46 X1 -> auto___def_46 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2174 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_46 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2.
  cut (auto___def_46 X1 -> auto___def_46 X1). tauto. exact (rem_2173 epsilon_mknows_current_p__def_85 X1).
Defined.

Remark rem_2175 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X2:term, auto___def_47 X2 -> auto___def_47 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2176 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_47 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2.
  cut (auto___def_47 X2 -> auto___def_47 X2). tauto. exact (rem_2175 epsilon_mknows_current_p__def_85 X2).
Defined.

Remark rem_2177 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> (auto___def_46 X1 /\ auto___def_47 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2. intros A1 A2.
  cut (auto___def_46 X1). 2:apply (rem_2174 epsilon_mknows_current_p__def_85 X1 X2);  assumption.
  cut (auto___def_47 X2). 2:apply (rem_2176 epsilon_mknows_current_p__def_85 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2178 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_85 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2. intros A1 A2.
  case (rem_2177 epsilon_mknows_current_p__def_85 X1 X2 A1 A2). clear  epsilon_mknows_current_p__def_85 A1 A2. intros. apply trans___def_85_key_3;  tauto.
 clear  epsilon_mknows_current_p__def_85 A1 A2. tauto.
Defined.

Remark rem_2179 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1:term, auto___def_43 X1 -> auto___def_43 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2180 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_43 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_43 X1). tauto. exact (rem_2179 epsilon_mknows_current_p__def_85 X1).
Defined.

Remark rem_2181 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X2:term, auto___def_44 X2 -> auto___def_44 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2182 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_44 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2.
  cut (auto___def_44 X2 -> auto___def_44 X2). tauto. exact (rem_2181 epsilon_mknows_current_p__def_85 X2).
Defined.

Remark rem_2183 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> (auto___def_43 X1 /\ auto___def_44 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2. intros A1 A2.
  cut (auto___def_43 X1). 2:apply (rem_2180 epsilon_mknows_current_p__def_85 X1 X2);  assumption.
  cut (auto___def_44 X2). 2:apply (rem_2182 epsilon_mknows_current_p__def_85 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2184 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_85 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2. intros A1 A2.
  case (rem_2183 epsilon_mknows_current_p__def_85 X1 X2 A1 A2). clear  epsilon_mknows_current_p__def_85 A1 A2. intros. apply trans___def_85_key_4;  tauto.
 clear  epsilon_mknows_current_p__def_85 A1 A2. tauto.
Defined.

Remark rem_2185 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> forall X1 X2:term, auto_knows_current (key X1 X2) -> auto___def_85 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intros X1 X2. intro H. intros.
  elim (rem_101 X1 X2 H);  intros.
  apply (rem_2172 epsilon_mknows_current_p__def_85 X1 X2);  tauto.
  apply (rem_2178 epsilon_mknows_current_p__def_85 X1 X2);  tauto.
  apply (rem_2184 epsilon_mknows_current_p__def_85 X1 X2);  tauto.
Defined.

Remark rem_2186 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> auto___def_85 t_old. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85.  case (rem_2116 epsilon_mknows_current_p__def_85). clear  epsilon_mknows_current_p__def_85. intros. apply trans___def_85_t_old_1;  tauto.
 clear  epsilon_mknows_current_p__def_85. tauto.
Defined.

Remark rem_2187 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> auto_knows_current t_old -> auto___def_85 t_old. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intro H. intros.
  elim (rem_828 H);  intros.
  apply (rem_2186 epsilon_mknows_current_p__def_85);  tauto.
Defined.

Remark rem_2188 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> auto___def_85 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85.  case (rem_2116 epsilon_mknows_current_p__def_85). clear  epsilon_mknows_current_p__def_85. intros. apply trans___def_85_alice_1;  tauto.
 clear  epsilon_mknows_current_p__def_85. tauto.
Defined.

Remark rem_2189 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> auto_knows_current alice -> auto___def_85 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intro H. intros.
  elim (rem_831 H);  intros.
  apply (rem_2188 epsilon_mknows_current_p__def_85);  tauto.
Defined.

Remark rem_2190 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> auto___def_85 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85.  case (rem_2116 epsilon_mknows_current_p__def_85). clear  epsilon_mknows_current_p__def_85. intros. apply trans___def_85_server_1;  tauto.
 clear  epsilon_mknows_current_p__def_85. tauto.
Defined.

Remark rem_2191 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> auto_knows_current server -> auto___def_85 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intro H. intros.
  elim (rem_834 H);  intros.
  apply (rem_2190 epsilon_mknows_current_p__def_85);  tauto.
Defined.

Remark rem_2192 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> auto___def_85 t_current. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85.  case (rem_2116 epsilon_mknows_current_p__def_85). clear  epsilon_mknows_current_p__def_85. intros. apply trans___def_85_t_current_1;  tauto.
 clear  epsilon_mknows_current_p__def_85. tauto.
Defined.

Remark rem_2193 : (forall X:term, auto_knows_current X -> auto___def_85 X)
    -> auto_knows_current t_current -> auto___def_85 t_current. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__def_85. intro H. intros.
  elim (rem_837 H);  intros.
  apply (rem_2192 epsilon_mknows_current_p__def_85);  tauto.
Defined.

Remark rem_2194 : forall X1:term, auto_knows_current X1 -> auto___def_85 X1. (* Induct. *)
Proof.
  fix epsilon_mknows_current_p__def_85 1.
  intro X. case X.
  exact (rem_2189 epsilon_mknows_current_p__def_85 ).
  exact (rem_2166 epsilon_mknows_current_p__def_85 ).
  intros X1 X2;  exact (rem_2126 epsilon_mknows_current_p__def_85 X1 X2).
  intros X1 X2;  exact (rem_2164 epsilon_mknows_current_p__def_85 X1 X2).
  exact (rem_2120 epsilon_mknows_current_p__def_85 ).
  intros X1 X2;  exact (rem_2185 epsilon_mknows_current_p__def_85 X1 X2).
  intros X1 X2. intro H. elim (rem_704 X1 X2 H).
  exact (rem_2118 epsilon_mknows_current_p__def_85 ).
   intro H. elim (rem_842  H).
   intro H. elim (rem_843  H).
  intros X1;  exact (rem_2115 epsilon_mknows_current_p__def_85 X1).
  exact (rem_2191 epsilon_mknows_current_p__def_85 ).
  intros X1 X2. intro H. elim (rem_839 X1 X2 H).
  intros X1 X2. intro H. elim (rem_840 X1 X2 H).
   intro H. elim (rem_841  H).
  exact (rem_2193 epsilon_mknows_current_p__def_85 ).
  exact (rem_2187 epsilon_mknows_current_p__def_85 ).
Qed.

Remark rem_2195 : forall X1:term, auto_knows_current X1 -> auto_knows_current (s t_current) -> auto___def_85 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1.
  cut (auto_knows_current X1 -> auto___def_85 X1). tauto. exact (rem_2194 X1).
Qed.

Remark rem_2196 : forall X1:term, auto_knows_current (s t_current) -> auto_knows_current X1 -> auto___def_85 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1.
  cut (auto_knows_current X1 -> auto_knows_current (s t_current) -> auto___def_85 X1). tauto. exact (rem_2195 X1).
Qed.

Remark rem_2197 : (forall X:term, auto___type_14 X -> auto___def_85 X)
    -> forall X1:term, auto___def_63 X1 -> auto___def_63 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2198 : (forall X:term, auto___type_14 X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_63 X1 -> auto___def_64 X2 -> auto___def_63 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_14_p__def_85. intros X1 X2.
  cut (auto___def_63 X1 -> auto___def_63 X1). tauto. exact (rem_2197 epsilon_m__type_14_p__def_85 X1).
Defined.

Remark rem_2199 : (forall X:term, auto___type_14 X -> auto___def_85 X)
    -> forall X2:term, auto___def_64 X2 -> auto___def_64 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2200 : (forall X:term, auto___type_14 X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_63 X1 -> auto___def_64 X2 -> auto___def_64 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_14_p__def_85. intros X1 X2.
  cut (auto___def_64 X2 -> auto___def_64 X2). tauto. exact (rem_2199 epsilon_m__type_14_p__def_85 X2).
Defined.

Remark rem_2201 : (forall X:term, auto___type_14 X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_63 X1 -> auto___def_64 X2 -> (auto___def_63 X1 /\ auto___def_64 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_14_p__def_85. intros X1 X2. intros A1 A2.
  cut (auto___def_63 X1). 2:apply (rem_2198 epsilon_m__type_14_p__def_85 X1 X2);  assumption.
  cut (auto___def_64 X2). 2:apply (rem_2200 epsilon_m__type_14_p__def_85 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2202 : (forall X:term, auto___type_14 X -> auto___def_85 X)
    -> forall X1 X2:term, auto___def_63 X1 -> auto___def_64 X2 -> auto___def_85 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_14_p__def_85. intros X1 X2. intros A1 A2.
  case (rem_2201 epsilon_m__type_14_p__def_85 X1 X2 A1 A2). clear  epsilon_m__type_14_p__def_85 A1 A2. intros. apply trans___def_85_key_2;  tauto.
 clear  epsilon_m__type_14_p__def_85 A1 A2. tauto.
Defined.

Remark rem_2203 : (forall X:term, auto___type_14 X -> auto___def_85 X)
    -> forall X1 X2:term, auto___type_14 (key X1 X2) -> auto___def_85 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_14_p__def_85. intros X1 X2. intro H. intros.
  elim (rem_1669 X1 X2 H);  intros.
  apply (rem_2202 epsilon_m__type_14_p__def_85 X1 X2);  tauto.
Defined.

Remark rem_2204 : forall X1 X2:term, auto___type_14 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2205 : forall X1:term, auto___type_14 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2206 : auto___type_14 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2207 : auto___type_14 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2208 : forall X1 X2:term, auto___type_14 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2209 : forall X1 X2:term, auto___type_14 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2210 : auto___type_14 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2211 : auto___type_14 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2212 : forall X1 X2:term, auto___type_14 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2213 : forall X1 X2:term, auto___type_14 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2214 : auto___type_14 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2215 : auto___type_14 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2216 : auto___type_14 t_old -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2217 : auto___type_14 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2218 : auto___type_14 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2219 : auto___type_14 t_current -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2220 : forall X1:term, auto___type_14 X1 -> auto___def_85 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_14_p__def_85 1.
  intro X. case X.
   intro H. elim (rem_2217  H).
   intro H. elim (rem_2214  H).
  intros X1 X2. intro H. elim (rem_2209 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2213 X1 X2 H).
   intro H. elim (rem_2207  H).
  intros X1 X2;  exact (rem_2203 epsilon_m__type_14_p__def_85 X1 X2).
  intros X1 X2. intro H. elim (rem_2212 X1 X2 H).
   intro H. elim (rem_2206  H).
   intro H. elim (rem_2211  H).
   intro H. elim (rem_2215  H).
  intros X1. intro H. elim (rem_2205 X1 H).
   intro H. elim (rem_2218  H).
  intros X1 X2. intro H. elim (rem_2204 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2208 X1 X2 H).
   intro H. elim (rem_2210  H).
   intro H. elim (rem_2219  H).
   intro H. elim (rem_2216  H).
Qed.

Remark rem_2221 : forall X1:term, auto___def_84 (s t_current) -> auto___type_14 X1 -> auto___def_85 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1.
  cut (auto___type_14 X1 -> auto___def_85 X1). tauto. exact (rem_2220 X1).
Qed.

Remark rem_2222 : forall X1:term, auto___def_23 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2223 : auto___def_23 (s t_current) -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_2222 t_current H);  intros.
Qed.

Remark rem_2224 : forall X1:term, auto___def_23 (s t_current) -> auto___def_24 X1 -> auto___def_85 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_23 (s t_current) -> False). tauto.
  exact (rem_2223).
Qed.

Remark rem_2225 : forall X1:term, auto___def_10 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2226 : auto___def_10 (s t_current) -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_2225 t_current H);  intros.
Qed.

Remark rem_2227 : forall X1:term, auto___def_10 (s t_current) -> auto___def_11 X1 -> auto___def_85 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_10 (s t_current) -> False). tauto.
  exact (rem_2226).
Qed.

Remark rem_2228 : forall X1:term, auto___def_55 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2229 : auto___def_55 (s t_current) -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_2228 t_current H);  intros.
Qed.

Remark rem_2230 : forall X1:term, auto___def_55 (s t_current) -> auto___def_56 X1 -> auto___def_85 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_55 (s t_current) -> False). tauto.
  exact (rem_2229).
Qed.

Remark rem_2231 : forall X1:term, auto___def_68 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2232 : auto___def_68 (s t_current) -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_2231 t_current H);  intros.
Qed.

Remark rem_2233 : forall X1:term, auto___def_68 (s t_current) -> auto___def_69 X1 -> auto___def_85 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_68 (s t_current) -> False). tauto.
  exact (rem_2232).
Qed.

Remark rem_2234 : forall X1:term, auto_knows_current (crypt (s t_current) X1) -> auto___def_85 X1. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_693 (s t_current) X1 H);  intros.
  apply (rem_2111 X1);  tauto.
  apply (rem_2196 X1);  tauto.
  apply (rem_2221 X1);  tauto.
  apply (rem_2224 X1);  tauto.
  apply (rem_2227 X1);  tauto.
  apply (rem_2230 X1);  tauto.
  apply (rem_2233 X1);  tauto.
Qed.

Remark rem_2235 : forall X1 X2:term, auto___def_22 X2 -> auto___type_3 X1 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_3 X1 -> auto___type_3 X1). tauto. exact (rem_2045 X1).
Qed.

Remark rem_2236 : forall X2:term, auto___def_22 X2 -> auto___def_22 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2237 : forall X1 X2:term, auto___def_22 X2 -> auto___type_3 X1 -> auto___def_22 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_22 X2 -> auto___def_22 X2). tauto. exact (rem_2236 X2).
Qed.

Remark rem_2238 : forall X1 X2:term, auto___def_22 X2 -> auto___type_3 X1 -> (auto___type_3 X1 /\ auto___def_22 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_3 X1). 2:apply (rem_2235 X1 X2);  assumption.
  cut (auto___def_22 X2). 2:apply (rem_2237 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2239 : forall X1 X2:term, auto___def_22 X2 -> auto___type_3 X1 -> auto___def_27 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2238 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_27_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2240 : forall X1 X2:term, auto___def_74 X2 -> auto___type_9 X1 -> auto___type_9 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_9 X1 -> auto___type_9 X1). tauto. exact (rem_2050 X1).
Qed.

Remark rem_2241 : forall X2:term, auto___def_74 X2 -> auto___def_74 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2242 : forall X1 X2:term, auto___def_74 X2 -> auto___type_9 X1 -> auto___def_74 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_74 X2 -> auto___def_74 X2). tauto. exact (rem_2241 X2).
Qed.

Remark rem_2243 : forall X1 X2:term, auto___def_74 X2 -> auto___type_9 X1 -> (auto___type_9 X1 /\ auto___def_74 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_9 X1). 2:apply (rem_2240 X1 X2);  assumption.
  cut (auto___def_74 X2). 2:apply (rem_2242 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2244 : forall X1 X2:term, auto___def_74 X2 -> auto___type_9 X1 -> auto___def_73 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2243 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_73_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2245 : forall X1:term, auto___type_6 X1 -> auto___type_6 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2246 : forall X1 X2:term, auto___def_38 X2 -> auto___type_6 X1 -> auto___type_6 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_6 X1 -> auto___type_6 X1). tauto. exact (rem_2245 X1).
Qed.

Remark rem_2247 : forall X2:term, auto___def_38 X2 -> auto___def_38 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2248 : forall X1 X2:term, auto___def_38 X2 -> auto___type_6 X1 -> auto___def_38 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_38 X2 -> auto___def_38 X2). tauto. exact (rem_2247 X2).
Qed.

Remark rem_2249 : forall X1 X2:term, auto___def_38 X2 -> auto___type_6 X1 -> (auto___type_6 X1 /\ auto___def_38 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_6 X1). 2:apply (rem_2246 X1 X2);  assumption.
  cut (auto___def_38 X2). 2:apply (rem_2248 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2250 : forall X1 X2:term, auto___def_38 X2 -> auto___type_6 X1 -> auto___def_37 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2249 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_37_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2251 : forall X1:term, auto___def_82 X1 -> auto___def_82 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2252 : forall X1:term, auto___def_82 X1 -> auto___def_82 X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1. intros A1.
  cut (auto___def_82 X1). 2:apply (rem_2251 X1);  assumption.
  tauto.
Qed.

Remark rem_2253 : forall X1:term, auto___def_82 X1 -> auto___def_84 (s X1). (* Deduce positive atom. *)
Proof.
  intros X1. intros A1.
  case (rem_2252 X1 A1). clear  A1. intros. apply trans___def_84_s_1;  tauto.
 clear  A1. tauto.
Qed.

Remark rem_2254 : forall X1 X2 X3 X4:term, auto___def_61 X2 -> auto___def_66 X3 -> auto_knows_current X4 -> auto_knows_current X1 -> auto___type_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X1 -> auto___type_13 X1). tauto. exact (rem_844 X1).
Qed.

Remark rem_2255 : forall X1 X2 X3 X4:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___def_61 X3 -> auto___def_66 X4 -> auto___type_13 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X4 X2 X3.
  cut (auto___def_61 X2 -> auto___def_66 X3 -> auto_knows_current X4 -> auto_knows_current X1 -> auto___type_13 X1). tauto. exact (rem_2254 X1 X2 X3 X4).
Qed.

Remark rem_2256 : forall X1 X2 X3 X4:term, auto___def_76 X1 X2 X3 X4 -> or_1
    (auto_knows_current X1 /\ auto_knows_current X2 /\ auto___def_61 X3 /\ auto___def_66 X4)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2257 : forall X1 X2 X3 X4:term, auto___def_76 X1 X2 X3 X4 -> auto___type_13 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_2256 X1 X2 X3 X4 H);  intros.
  apply (rem_2255 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2258 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old (key pub X1) -> auto___type_8 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_8_1. Qed.

Remark rem_2259 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old (key pub X1) -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_2065 X2).
Qed.

Remark rem_2260 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old (key pub X1) -> (auto___type_8 X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_8 X1). 2:apply (rem_2258 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_2259 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2261 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old (key pub X1) -> auto___def_1 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2260 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_1_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2262 : forall X1 X2:term, auto___def_37 X2 -> auto___type_5 (key pub X1) -> auto___type_8 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_8_1. Qed.

Remark rem_2263 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2264 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1. intros A1.
  cut (auto_knows_old X1). 2:apply (rem_2263 epsilon_m__type_6_pknows_old X1);  assumption.
  tauto.
Defined.

Remark rem_2265 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1. intros A1.
  case (rem_2264 epsilon_m__type_6_pknows_old X1 A1). clear  epsilon_m__type_6_pknows_old A1. intros. apply trans_knows_old_s_1;  tauto.
 clear  epsilon_m__type_6_pknows_old A1. tauto.
Defined.

Remark rem_2266 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1:term, auto___type_6 (s X1) -> auto_knows_old (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1. intro H. intros.
  elim (rem_261 X1 H);  intros.
  apply (rem_2265 epsilon_m__type_6_pknows_old X1);  tauto.
Defined.

Remark rem_2267 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_6_pknows_old.  tauto.
Defined.

Remark rem_2268 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> auto_knows_old nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old.  case (rem_2267 epsilon_m__type_6_pknows_old). clear  epsilon_m__type_6_pknows_old. intros. apply trans_knows_old_nil_1;  tauto.
 clear  epsilon_m__type_6_pknows_old. tauto.
Defined.

Remark rem_2269 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> auto___type_6 nil -> auto_knows_old nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intro H. intros.
  elim (rem_265 H);  intros.
  apply (rem_2268 epsilon_m__type_6_pknows_old);  tauto.
Defined.

Remark rem_2270 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> auto_knows_old i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old.  case (rem_2267 epsilon_m__type_6_pknows_old). clear  epsilon_m__type_6_pknows_old. intros. apply trans_knows_old_i_1;  tauto.
 clear  epsilon_m__type_6_pknows_old. tauto.
Defined.

Remark rem_2271 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> auto___type_6 i -> auto_knows_old i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intro H. intros.
  elim (rem_268 H);  intros.
  apply (rem_2270 epsilon_m__type_6_pknows_old);  tauto.
Defined.

Remark rem_2272 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2.
  cut (auto_knows_old X1 -> auto_knows_old X1). tauto. exact (rem_2263 epsilon_m__type_6_pknows_old X1).
Defined.

Remark rem_2273 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X2:term, auto_knows_old X2 -> auto_knows_old X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2274 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_2273 epsilon_m__type_6_pknows_old X2).
Defined.

Remark rem_2275 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> (auto_knows_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_2272 epsilon_m__type_6_pknows_old X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_2274 epsilon_m__type_6_pknows_old X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2276 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2. intros A1 A2.
  case (rem_2275 epsilon_m__type_6_pknows_old X1 X2 A1 A2). clear  epsilon_m__type_6_pknows_old A1 A2. intros. apply trans_knows_old_cons_1;  tauto.
 clear  epsilon_m__type_6_pknows_old A1 A2. tauto.
Defined.

Remark rem_2277 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___type_6 (cons X1 X2) -> auto_knows_old (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2. intro H. intros.
  elim (rem_275 X1 X2 H);  intros.
  apply (rem_2276 epsilon_m__type_6_pknows_old X1 X2);  tauto.
Defined.

Remark rem_2278 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2. intros A1 A2.
  case (rem_2275 epsilon_m__type_6_pknows_old X1 X2 A1 A2). clear  epsilon_m__type_6_pknows_old A1 A2. intros. apply trans_knows_old_crypt_1;  tauto.
 clear  epsilon_m__type_6_pknows_old A1 A2. tauto.
Defined.

Remark rem_2279 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1:term, auto___def_37 X1 -> auto___def_37 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2280 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> auto___def_37 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2.
  cut (auto___def_37 X1 -> auto___def_37 X1). tauto. exact (rem_2279 epsilon_m__type_6_pknows_old X1).
Defined.

Remark rem_2281 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X2:term, auto___type_5 X2 -> auto___type_5 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2282 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> auto___type_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2.
  cut (auto___type_5 X2 -> auto___type_5 X2). tauto. exact (rem_2281 epsilon_m__type_6_pknows_old X2).
Defined.

Remark rem_2283 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> (auto___def_37 X1 /\ auto___type_5 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2. intros A1 A2.
  cut (auto___def_37 X1). 2:apply (rem_2280 epsilon_m__type_6_pknows_old X1 X2);  assumption.
  cut (auto___type_5 X2). 2:apply (rem_2282 epsilon_m__type_6_pknows_old X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2284 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> auto_knows_old (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2. intros A1 A2.
  case (rem_2283 epsilon_m__type_6_pknows_old X1 X2 A1 A2). clear  epsilon_m__type_6_pknows_old A1 A2. intros. apply trans_knows_old_crypt_2;  tauto.
 clear  epsilon_m__type_6_pknows_old A1 A2. tauto.
Defined.

Remark rem_2285 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1:term, auto___def_23 X1 -> auto___def_23 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2286 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_23 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2.
  cut (auto___def_23 X1 -> auto___def_23 X1). tauto. exact (rem_2285 epsilon_m__type_6_pknows_old X1).
Defined.

Remark rem_2287 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X2:term, auto___def_24 X2 -> auto___def_24 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2288 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_24 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2.
  cut (auto___def_24 X2 -> auto___def_24 X2). tauto. exact (rem_2287 epsilon_m__type_6_pknows_old X2).
Defined.

Remark rem_2289 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> (auto___def_23 X1 /\ auto___def_24 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2. intros A1 A2.
  cut (auto___def_23 X1). 2:apply (rem_2286 epsilon_m__type_6_pknows_old X1 X2);  assumption.
  cut (auto___def_24 X2). 2:apply (rem_2288 epsilon_m__type_6_pknows_old X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2290 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto_knows_old (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2. intros A1 A2.
  case (rem_2289 epsilon_m__type_6_pknows_old X1 X2 A1 A2). clear  epsilon_m__type_6_pknows_old A1 A2. intros. apply trans_knows_old_crypt_3;  tauto.
 clear  epsilon_m__type_6_pknows_old A1 A2. tauto.
Defined.

Remark rem_2291 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1:term, auto___def_10 X1 -> auto___def_10 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2292 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_10 X1). tauto. exact (rem_2291 epsilon_m__type_6_pknows_old X1).
Defined.

Remark rem_2293 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X2:term, auto___def_11 X2 -> auto___def_11 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2294 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2.
  cut (auto___def_11 X2 -> auto___def_11 X2). tauto. exact (rem_2293 epsilon_m__type_6_pknows_old X2).
Defined.

Remark rem_2295 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> (auto___def_10 X1 /\ auto___def_11 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2. intros A1 A2.
  cut (auto___def_10 X1). 2:apply (rem_2292 epsilon_m__type_6_pknows_old X1 X2);  assumption.
  cut (auto___def_11 X2). 2:apply (rem_2294 epsilon_m__type_6_pknows_old X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2296 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto_knows_old (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2. intros A1 A2.
  case (rem_2295 epsilon_m__type_6_pknows_old X1 X2 A1 A2). clear  epsilon_m__type_6_pknows_old A1 A2. intros. apply trans_knows_old_crypt_4;  tauto.
 clear  epsilon_m__type_6_pknows_old A1 A2. tauto.
Defined.

Remark rem_2297 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1:term, auto___def_41 X1 -> auto___def_41 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2298 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> auto___def_41 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2.
  cut (auto___def_41 X1 -> auto___def_41 X1). tauto. exact (rem_2297 epsilon_m__type_6_pknows_old X1).
Defined.

Remark rem_2299 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X2:term, auto___type_7 X2 -> auto___type_7 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2300 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> auto___type_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2.
  cut (auto___type_7 X2 -> auto___type_7 X2). tauto. exact (rem_2299 epsilon_m__type_6_pknows_old X2).
Defined.

Remark rem_2301 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> (auto___def_41 X1 /\ auto___type_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2. intros A1 A2.
  cut (auto___def_41 X1). 2:apply (rem_2298 epsilon_m__type_6_pknows_old X1 X2);  assumption.
  cut (auto___type_7 X2). 2:apply (rem_2300 epsilon_m__type_6_pknows_old X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2302 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> auto_knows_old (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2. intros A1 A2.
  case (rem_2301 epsilon_m__type_6_pknows_old X1 X2 A1 A2). clear  epsilon_m__type_6_pknows_old A1 A2. intros. apply trans_knows_old_crypt_5;  tauto.
 clear  epsilon_m__type_6_pknows_old A1 A2. tauto.
Defined.

Remark rem_2303 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___type_6 (crypt X1 X2) -> auto_knows_old (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2. intro H. intros.
  elim (rem_437 X1 X2 H);  intros.
  apply (rem_2278 epsilon_m__type_6_pknows_old X1 X2);  tauto.
  apply (rem_2284 epsilon_m__type_6_pknows_old X1 X2);  tauto.
  apply (rem_2290 epsilon_m__type_6_pknows_old X1 X2);  tauto.
  apply (rem_2296 epsilon_m__type_6_pknows_old X1 X2);  tauto.
  apply (rem_2302 epsilon_m__type_6_pknows_old X1 X2);  tauto.
Defined.

Remark rem_2304 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> auto_knows_old bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old.  case (rem_2267 epsilon_m__type_6_pknows_old). clear  epsilon_m__type_6_pknows_old. intros. apply trans_knows_old_bob_1;  tauto.
 clear  epsilon_m__type_6_pknows_old. tauto.
Defined.

Remark rem_2305 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> auto___type_6 bob -> auto_knows_old bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intro H. intros.
  elim (rem_440 H);  intros.
  apply (rem_2304 epsilon_m__type_6_pknows_old);  tauto.
Defined.

Remark rem_2306 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1:term, auto___def_42 X1 -> auto___def_42 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2307 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___def_42 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2.
  cut (auto___def_42 X1 -> auto___def_42 X1). tauto. exact (rem_2306 epsilon_m__type_6_pknows_old X1).
Defined.

Remark rem_2308 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2309 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_2308 epsilon_m__type_6_pknows_old X2).
Defined.

Remark rem_2310 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> (auto___def_42 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2. intros A1 A2.
  cut (auto___def_42 X1). 2:apply (rem_2307 epsilon_m__type_6_pknows_old X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_2309 epsilon_m__type_6_pknows_old X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2311 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto_knows_old (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2. intros A1 A2.
  case (rem_2310 epsilon_m__type_6_pknows_old X1 X2 A1 A2). clear  epsilon_m__type_6_pknows_old A1 A2. intros. apply trans_knows_old_key_1;  tauto.
 clear  epsilon_m__type_6_pknows_old A1 A2. tauto.
Defined.

Remark rem_2312 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1:term, auto___def_43 X1 -> auto___def_43 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2313 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_43 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_43 X1). tauto. exact (rem_2312 epsilon_m__type_6_pknows_old X1).
Defined.

Remark rem_2314 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X2:term, auto___def_44 X2 -> auto___def_44 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2315 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_44 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2.
  cut (auto___def_44 X2 -> auto___def_44 X2). tauto. exact (rem_2314 epsilon_m__type_6_pknows_old X2).
Defined.

Remark rem_2316 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> (auto___def_43 X1 /\ auto___def_44 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2. intros A1 A2.
  cut (auto___def_43 X1). 2:apply (rem_2313 epsilon_m__type_6_pknows_old X1 X2);  assumption.
  cut (auto___def_44 X2). 2:apply (rem_2315 epsilon_m__type_6_pknows_old X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2317 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto_knows_old (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2. intros A1 A2.
  case (rem_2316 epsilon_m__type_6_pknows_old X1 X2 A1 A2). clear  epsilon_m__type_6_pknows_old A1 A2. intros. apply trans_knows_old_key_2;  tauto.
 clear  epsilon_m__type_6_pknows_old A1 A2. tauto.
Defined.

Remark rem_2318 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___type_6 (key X1 X2) -> auto_knows_old (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intros X1 X2. intro H. intros.
  elim (rem_454 X1 X2 H);  intros.
  apply (rem_2311 epsilon_m__type_6_pknows_old X1 X2);  tauto.
  apply (rem_2317 epsilon_m__type_6_pknows_old X1 X2);  tauto.
Defined.

Remark rem_2319 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> auto_knows_old t_old. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old.  case (rem_2267 epsilon_m__type_6_pknows_old). clear  epsilon_m__type_6_pknows_old. intros. apply trans_knows_old_t_old_1;  tauto.
 clear  epsilon_m__type_6_pknows_old. tauto.
Defined.

Remark rem_2320 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> auto___type_6 t_old -> auto_knows_old t_old. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intro H. intros.
  elim (rem_457 H);  intros.
  apply (rem_2319 epsilon_m__type_6_pknows_old);  tauto.
Defined.

Remark rem_2321 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> auto_knows_old alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old.  case (rem_2267 epsilon_m__type_6_pknows_old). clear  epsilon_m__type_6_pknows_old. intros. apply trans_knows_old_alice_1;  tauto.
 clear  epsilon_m__type_6_pknows_old. tauto.
Defined.

Remark rem_2322 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> auto___type_6 alice -> auto_knows_old alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intro H. intros.
  elim (rem_460 H);  intros.
  apply (rem_2321 epsilon_m__type_6_pknows_old);  tauto.
Defined.

Remark rem_2323 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> auto_knows_old server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old.  case (rem_2267 epsilon_m__type_6_pknows_old). clear  epsilon_m__type_6_pknows_old. intros. apply trans_knows_old_server_1;  tauto.
 clear  epsilon_m__type_6_pknows_old. tauto.
Defined.

Remark rem_2324 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> auto___type_6 server -> auto_knows_old server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intro H. intros.
  elim (rem_463 H);  intros.
  apply (rem_2323 epsilon_m__type_6_pknows_old);  tauto.
Defined.

Remark rem_2325 : forall X1:term, auto___type_6 X1 -> auto_knows_old X1. (* Induct. *)
Proof.
  fix epsilon_m__type_6_pknows_old 1.
  intro X. case X.
  exact (rem_2322 epsilon_m__type_6_pknows_old ).
  exact (rem_2305 epsilon_m__type_6_pknows_old ).
  intros X1 X2;  exact (rem_2277 epsilon_m__type_6_pknows_old X1 X2).
  intros X1 X2;  exact (rem_2303 epsilon_m__type_6_pknows_old X1 X2).
  exact (rem_2271 epsilon_m__type_6_pknows_old ).
  intros X1 X2;  exact (rem_2318 epsilon_m__type_6_pknows_old X1 X2).
  intros X1 X2. intro H. elim (rem_469 X1 X2 H).
  exact (rem_2269 epsilon_m__type_6_pknows_old ).
   intro H. elim (rem_468  H).
   intro H. elim (rem_470  H).
  intros X1;  exact (rem_2266 epsilon_m__type_6_pknows_old X1).
  exact (rem_2324 epsilon_m__type_6_pknows_old ).
  intros X1 X2. intro H. elim (rem_465 X1 X2 H).
  intros X1 X2. intro H. elim (rem_466 X1 X2 H).
   intro H. elim (rem_467  H).
   intro H. elim (rem_471  H).
  exact (rem_2320 epsilon_m__type_6_pknows_old ).
Qed.

Remark rem_2326 : (forall X:term, auto___def_37 X -> auto_knows_old X)
    -> forall X1:term, auto___type_6 X1 -> auto_knows_old X1. (* Cut history. *)
Proof.  intros epsilon_m__def_37_pknows_old. exact (rem_2325).
Defined.

Remark rem_2327 : (forall X:term, auto___def_37 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___type_6 X1 -> auto___def_38 X2 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_37_pknows_old. intros X1 X2.
  cut (auto___type_6 X1 -> auto_knows_old X1). tauto. exact (rem_2326 epsilon_m__def_37_pknows_old X1).
Defined.

Remark rem_2328 : (forall X:term, auto___def_39 X -> auto_knows_old X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_39_pknows_old.  tauto.
Defined.

Remark rem_2329 : (forall X:term, auto___def_39 X -> auto_knows_old X)
    -> auto_knows_old t_old. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_39_pknows_old.  case (rem_2328 epsilon_m__def_39_pknows_old). clear  epsilon_m__def_39_pknows_old. intros. apply trans_knows_old_t_old_1;  tauto.
 clear  epsilon_m__def_39_pknows_old. tauto.
Defined.

Remark rem_2330 : (forall X:term, auto___def_39 X -> auto_knows_old X)
    -> auto___def_39 t_old -> auto_knows_old t_old. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_39_pknows_old. intro H. intros.
  elim (rem_365 H);  intros.
  apply (rem_2329 epsilon_m__def_39_pknows_old);  tauto.
Defined.

Remark rem_2331 : forall X1:term, auto___def_39 X1 -> auto_knows_old X1. (* Induct. *)
Proof.
  fix epsilon_m__def_39_pknows_old 1.
  intro X. case X.
   intro H. elim (rem_380  H).
   intro H. elim (rem_377  H).
  intros X1 X2. intro H. elim (rem_372 X1 X2 H).
  intros X1 X2. intro H. elim (rem_376 X1 X2 H).
   intro H. elim (rem_370  H).
  intros X1 X2. intro H. elim (rem_378 X1 X2 H).
  intros X1 X2. intro H. elim (rem_375 X1 X2 H).
   intro H. elim (rem_369  H).
   intro H. elim (rem_374  H).
   intro H. elim (rem_379  H).
  intros X1. intro H. elim (rem_368 X1 H).
   intro H. elim (rem_381  H).
  intros X1 X2. intro H. elim (rem_367 X1 X2 H).
  intros X1 X2. intro H. elim (rem_371 X1 X2 H).
   intro H. elim (rem_373  H).
   intro H. elim (rem_382  H).
  exact (rem_2330 epsilon_m__def_39_pknows_old ).
Qed.

Remark rem_2332 : (forall X:term, auto___def_38 X -> auto_knows_old X)
    -> forall X1:term, auto___def_39 X1 -> auto_knows_old X1. (* Cut history. *)
Proof.  intros epsilon_m__def_38_pknows_old. exact (rem_2331).
Defined.

Remark rem_2333 : (forall X:term, auto___def_38 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_39 X1 -> auto___def_31 X2 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_38_pknows_old. intros X1 X2.
  cut (auto___def_39 X1 -> auto_knows_old X1). tauto. exact (rem_2332 epsilon_m__def_38_pknows_old X1).
Defined.

Remark rem_2334 : (forall X:term, auto___def_31 X -> auto_knows_old X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_31_pknows_old.  tauto.
Defined.

Remark rem_2335 : (forall X:term, auto___def_31 X -> auto_knows_old X)
    -> auto_knows_old nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_31_pknows_old.  case (rem_2334 epsilon_m__def_31_pknows_old). clear  epsilon_m__def_31_pknows_old. intros. apply trans_knows_old_nil_1;  tauto.
 clear  epsilon_m__def_31_pknows_old. tauto.
Defined.

Remark rem_2336 : (forall X:term, auto___def_31 X -> auto_knows_old X)
    -> auto___def_31 nil -> auto_knows_old nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_31_pknows_old. intro H. intros.
  elim (rem_478 H);  intros.
  apply (rem_2335 epsilon_m__def_31_pknows_old);  tauto.
Defined.

Remark rem_2337 : forall X2:term, auto___def_31 X2 -> auto_knows_old X2. (* Induct. *)
Proof.
  fix epsilon_m__def_31_pknows_old 1.
  intro X. case X.
   intro H. elim (rem_492  H).
   intro H. elim (rem_488  H).
  intros X1 X2. intro H. elim (rem_39 X1 X2 H).
  intros X1 X2. intro H. elim (rem_487 X1 X2 H).
   intro H. elim (rem_482  H).
  intros X1 X2. intro H. elim (rem_489 X1 X2 H).
  intros X1 X2. intro H. elim (rem_486 X1 X2 H).
  exact (rem_2336 epsilon_m__def_31_pknows_old ).
   intro H. elim (rem_485  H).
   intro H. elim (rem_490  H).
  intros X1. intro H. elim (rem_481 X1 H).
   intro H. elim (rem_493  H).
  intros X1 X2. intro H. elim (rem_480 X1 X2 H).
  intros X1 X2. intro H. elim (rem_483 X1 X2 H).
   intro H. elim (rem_484  H).
   intro H. elim (rem_494  H).
   intro H. elim (rem_491  H).
Qed.

Remark rem_2338 : (forall X:term, auto___def_38 X -> auto_knows_old X)
    -> forall X2:term, auto___def_31 X2 -> auto_knows_old X2. (* Cut history. *)
Proof.  intros epsilon_m__def_38_pknows_old. exact (rem_2337).
Defined.

Remark rem_2339 : (forall X:term, auto___def_38 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_39 X1 -> auto___def_31 X2 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_38_pknows_old. intros X1 X2.
  cut (auto___def_31 X2 -> auto_knows_old X2). tauto. exact (rem_2338 epsilon_m__def_38_pknows_old X2).
Defined.

Remark rem_2340 : (forall X:term, auto___def_38 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_39 X1 -> auto___def_31 X2 -> (auto_knows_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_38_pknows_old. intros X1 X2. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_2333 epsilon_m__def_38_pknows_old X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_2339 epsilon_m__def_38_pknows_old X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2341 : (forall X:term, auto___def_38 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_39 X1 -> auto___def_31 X2 -> auto_knows_old (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_38_pknows_old. intros X1 X2. intros A1 A2.
  case (rem_2340 epsilon_m__def_38_pknows_old X1 X2 A1 A2). clear  epsilon_m__def_38_pknows_old A1 A2. intros. apply trans_knows_old_cons_1;  tauto.
 clear  epsilon_m__def_38_pknows_old A1 A2. tauto.
Defined.

Remark rem_2342 : (forall X:term, auto___def_38 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_38 (cons X1 X2) -> auto_knows_old (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_38_pknows_old. intros X1 X2. intro H. intros.
  elim (rem_500 X1 X2 H);  intros.
  apply (rem_2341 epsilon_m__def_38_pknows_old X1 X2);  tauto.
Defined.

Remark rem_2343 : forall X2:term, auto___def_38 X2 -> auto_knows_old X2. (* Induct. *)
Proof.
  fix epsilon_m__def_38_pknows_old 1.
  intro X. case X.
   intro H. elim (rem_515  H).
   intro H. elim (rem_511  H).
  intros X1 X2;  exact (rem_2342 epsilon_m__def_38_pknows_old X1 X2).
  intros X1 X2. intro H. elim (rem_510 X1 X2 H).
   intro H. elim (rem_505  H).
  intros X1 X2. intro H. elim (rem_512 X1 X2 H).
  intros X1 X2. intro H. elim (rem_509 X1 X2 H).
   intro H. elim (rem_504  H).
   intro H. elim (rem_508  H).
   intro H. elim (rem_513  H).
  intros X1. intro H. elim (rem_503 X1 H).
   intro H. elim (rem_516  H).
  intros X1 X2. intro H. elim (rem_502 X1 X2 H).
  intros X1 X2. intro H. elim (rem_506 X1 X2 H).
   intro H. elim (rem_507  H).
   intro H. elim (rem_517  H).
   intro H. elim (rem_514  H).
Qed.

Remark rem_2344 : (forall X:term, auto___def_37 X -> auto_knows_old X)
    -> forall X2:term, auto___def_38 X2 -> auto_knows_old X2. (* Cut history. *)
Proof.  intros epsilon_m__def_37_pknows_old. exact (rem_2343).
Defined.

Remark rem_2345 : (forall X:term, auto___def_37 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___type_6 X1 -> auto___def_38 X2 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_37_pknows_old. intros X1 X2.
  cut (auto___def_38 X2 -> auto_knows_old X2). tauto. exact (rem_2344 epsilon_m__def_37_pknows_old X2).
Defined.

Remark rem_2346 : (forall X:term, auto___def_37 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___type_6 X1 -> auto___def_38 X2 -> (auto_knows_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_37_pknows_old. intros X1 X2. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_2327 epsilon_m__def_37_pknows_old X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_2345 epsilon_m__def_37_pknows_old X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2347 : (forall X:term, auto___def_37 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___type_6 X1 -> auto___def_38 X2 -> auto_knows_old (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_37_pknows_old. intros X1 X2. intros A1 A2.
  case (rem_2346 epsilon_m__def_37_pknows_old X1 X2 A1 A2). clear  epsilon_m__def_37_pknows_old A1 A2. intros. apply trans_knows_old_cons_1;  tauto.
 clear  epsilon_m__def_37_pknows_old A1 A2. tauto.
Defined.

Remark rem_2348 : (forall X:term, auto___def_37 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_37 (cons X1 X2) -> auto_knows_old (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_37_pknows_old. intros X1 X2. intro H. intros.
  elim (rem_523 X1 X2 H);  intros.
  apply (rem_2347 epsilon_m__def_37_pknows_old X1 X2);  tauto.
Defined.

Remark rem_2349 : forall X2:term, auto___def_37 X2 -> auto_knows_old X2. (* Induct. *)
Proof.
  fix epsilon_m__def_37_pknows_old 1.
  intro X. case X.
   intro H. elim (rem_538  H).
   intro H. elim (rem_534  H).
  intros X1 X2;  exact (rem_2348 epsilon_m__def_37_pknows_old X1 X2).
  intros X1 X2. intro H. elim (rem_533 X1 X2 H).
   intro H. elim (rem_528  H).
  intros X1 X2. intro H. elim (rem_535 X1 X2 H).
  intros X1 X2. intro H. elim (rem_532 X1 X2 H).
   intro H. elim (rem_527  H).
   intro H. elim (rem_531  H).
   intro H. elim (rem_536  H).
  intros X1. intro H. elim (rem_526 X1 H).
   intro H. elim (rem_539  H).
  intros X1 X2. intro H. elim (rem_525 X1 X2 H).
  intros X1 X2. intro H. elim (rem_529 X1 X2 H).
   intro H. elim (rem_530  H).
   intro H. elim (rem_540  H).
   intro H. elim (rem_537  H).
Qed.

Remark rem_2350 : forall X1 X2:term, auto___def_37 X2 -> auto___type_5 (key pub X1) -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_37 X2 -> auto_knows_old X2). tauto. exact (rem_2349 X2).
Qed.

Remark rem_2351 : forall X1 X2:term, auto___def_37 X2 -> auto___type_5 (key pub X1) -> (auto___type_8 X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_8 X1). 2:apply (rem_2262 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_2350 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2352 : forall X1 X2:term, auto___def_37 X2 -> auto___type_5 (key pub X1) -> auto___def_1 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2351 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_1_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2353 : auto___def_18 pub -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_295 H);  intros.
Qed.

Remark rem_2354 : forall X1 X2:term, auto___def_18 pub -> auto___def_23 X2 -> auto___def_28 X1 -> auto___def_1 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 pub -> False). tauto.
  exact (rem_2353).
Qed.

Remark rem_2355 : forall X1 X2:term, auto___def_18 pub -> auto___def_28 X1 -> auto___def_23 X2 -> auto___def_1 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_18 pub -> auto___def_23 X2 -> auto___def_28 X1 -> auto___def_1 X1 X2). tauto. exact (rem_2354 X1 X2).
Qed.

Remark rem_2356 : forall X1 X2:term, auto___def_23 X2 -> auto___def_24 (key pub X1) -> auto___def_1 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_624 pub X1 H);  intros.
  apply (rem_2355 X1 X2);  tauto.
Qed.

Remark rem_2357 : forall X1 X2:term, auto___def_10 X2 -> auto___def_18 pub -> auto___def_32 X1 -> auto___def_1 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 pub -> False). tauto.
  exact (rem_2353).
Qed.

Remark rem_2358 : forall X1 X2:term, auto___def_18 pub -> auto___def_32 X1 -> auto___def_10 X2 -> auto___def_1 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_10 X2 -> auto___def_18 pub -> auto___def_32 X1 -> auto___def_1 X1 X2). tauto. exact (rem_2357 X1 X2).
Qed.

Remark rem_2359 : forall X1 X2:term, auto___def_10 X2 -> auto___def_11 (key pub X1) -> auto___def_1 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_644 pub X1 H);  intros.
  apply (rem_2358 X1 X2);  tauto.
Qed.

Remark rem_2360 : forall X1 X2:term, auto___def_41 X2 -> auto___type_7 (key pub X1) -> auto___type_8 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_8_1. Qed.

Remark rem_2361 : (forall X:term, auto___def_41 X -> auto_knows_old X)
    -> forall X1:term, auto___def_39 X1 -> auto_knows_old X1. (* Cut history. *)
Proof.  intros epsilon_m__def_41_pknows_old. exact (rem_2331).
Defined.

Remark rem_2362 : (forall X:term, auto___def_41 X -> auto_knows_old X)
    -> forall X1:term, auto___def_39 X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_41_pknows_old. intros X1. intros A1.
  cut (auto_knows_old X1). 2:apply (rem_2361 epsilon_m__def_41_pknows_old X1);  assumption.
  tauto.
Defined.

Remark rem_2363 : (forall X:term, auto___def_41 X -> auto_knows_old X)
    -> forall X1:term, auto___def_39 X1 -> auto_knows_old (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_41_pknows_old. intros X1. intros A1.
  case (rem_2362 epsilon_m__def_41_pknows_old X1 A1). clear  epsilon_m__def_41_pknows_old A1. intros. apply trans_knows_old_s_1;  tauto.
 clear  epsilon_m__def_41_pknows_old A1. tauto.
Defined.

Remark rem_2364 : (forall X:term, auto___def_41 X -> auto_knows_old X)
    -> forall X1:term, auto___def_41 (s X1) -> auto_knows_old (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_41_pknows_old. intros X1. intro H. intros.
  elim (rem_387 X1 H);  intros.
  apply (rem_2363 epsilon_m__def_41_pknows_old X1);  tauto.
Defined.

Remark rem_2365 : forall X2:term, auto___def_41 X2 -> auto_knows_old X2. (* Induct. *)
Proof.
  fix epsilon_m__def_41_pknows_old 1.
  intro X. case X.
   intro H. elim (rem_402  H).
   intro H. elim (rem_398  H).
  intros X1 X2. intro H. elim (rem_393 X1 X2 H).
  intros X1 X2. intro H. elim (rem_397 X1 X2 H).
   intro H. elim (rem_391  H).
  intros X1 X2. intro H. elim (rem_399 X1 X2 H).
  intros X1 X2. intro H. elim (rem_396 X1 X2 H).
   intro H. elim (rem_390  H).
   intro H. elim (rem_395  H).
   intro H. elim (rem_400  H).
  intros X1;  exact (rem_2364 epsilon_m__def_41_pknows_old X1).
   intro H. elim (rem_403  H).
  intros X1 X2. intro H. elim (rem_389 X1 X2 H).
  intros X1 X2. intro H. elim (rem_392 X1 X2 H).
   intro H. elim (rem_394  H).
   intro H. elim (rem_404  H).
   intro H. elim (rem_401  H).
Qed.

Remark rem_2366 : forall X1 X2:term, auto___def_41 X2 -> auto___type_7 (key pub X1) -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_41 X2 -> auto_knows_old X2). tauto. exact (rem_2365 X2).
Qed.

Remark rem_2367 : forall X1 X2:term, auto___def_41 X2 -> auto___type_7 (key pub X1) -> (auto___type_8 X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_8 X1). 2:apply (rem_2360 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_2366 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2368 : forall X1 X2:term, auto___def_41 X2 -> auto___type_7 (key pub X1) -> auto___def_1 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2367 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_1_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2369 : forall X1 X2:term, auto_knows_old (crypt X2 (key pub X1)) -> auto___def_1 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_565 X2 (key pub X1) H);  intros.
  apply (rem_2261 X1 X2);  tauto.
  apply (rem_2352 X1 X2);  tauto.
  apply (rem_2356 X1 X2);  tauto.
  apply (rem_2359 X1 X2);  tauto.
  apply (rem_2368 X1 X2);  tauto.
Qed.

Remark rem_2370 : forall X1:term, auto___def_63 X1 -> auto___def_63 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2371 : forall X1 X2:term, auto___def_63 X1 -> auto___def_64 X2 -> auto___def_63 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_63 X1 -> auto___def_63 X1). tauto. exact (rem_2370 X1).
Qed.

Remark rem_2372 : forall X1 X2:term, auto___def_63 X1 -> auto___def_64 X2 -> auto___def_64 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_64 X2 -> auto___def_64 X2). tauto. exact (rem_1647 X2).
Qed.

Remark rem_2373 : forall X1 X2:term, auto___def_63 X1 -> auto___def_64 X2 -> (auto___def_63 X1 /\ auto___def_64 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_63 X1). 2:apply (rem_2371 X1 X2);  assumption.
  cut (auto___def_64 X2). 2:apply (rem_2372 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2374 : forall X1 X2:term, auto___def_63 X1 -> auto___def_64 X2 -> auto___def_61 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2373 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_61_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2375 : forall X1 X2:term, auto___def_64 X2 -> auto___def_63 X1 -> auto___def_61 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_63 X1 -> auto___def_64 X2 -> auto___def_61 (key X1 X2)). tauto. exact (rem_2374 X1 X2).
Qed.

Remark rem_2376 : forall X1:term, auto___def_30 X1 -> auto___def_30 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2377 : forall X1 X2:term, auto___def_30 X1 -> auto___def_31 X2 -> auto___def_30 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_30 X1 -> auto___def_30 X1). tauto. exact (rem_2376 X1).
Qed.

Remark rem_2378 : forall X1 X2:term, auto___def_30 X1 -> auto___def_31 X2 -> auto___def_31 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_31 X2 -> auto___def_31 X2). tauto. exact (rem_1712 X2).
Qed.

Remark rem_2379 : forall X1 X2:term, auto___def_30 X1 -> auto___def_31 X2 -> (auto___def_30 X1 /\ auto___def_31 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_30 X1). 2:apply (rem_2377 X1 X2);  assumption.
  cut (auto___def_31 X2). 2:apply (rem_2378 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2380 : forall X1 X2:term, auto___def_30 X1 -> auto___def_31 X2 -> auto___def_29 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2379 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_29_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2381 : forall X1 X2:term, auto___def_31 X2 -> auto___def_30 X1 -> auto___def_29 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_30 X1 -> auto___def_31 X2 -> auto___def_29 (cons X1 X2)). tauto. exact (rem_2380 X1 X2).
Qed.

Remark rem_2382 : auto___def_31 nil. (* Deduce positive atom. *)
Proof.
   case rem_37. intros. apply trans___def_31_nil_1;  tauto.
 tauto.
Qed.

Remark rem_2383 : forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_18 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_18 X1). tauto. exact (rem_1704 X1).
Qed.

Remark rem_2384 : forall X2:term, auto___def_19 X2 -> auto___def_19 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2385 : forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_19 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_19 X2). tauto. exact (rem_2384 X2).
Qed.

Remark rem_2386 : forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> (auto___def_18 X1 /\ auto___def_19 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_18 X1). 2:apply (rem_2383 X1 X2);  assumption.
  cut (auto___def_19 X2). 2:apply (rem_2385 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2387 : forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_16 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2386 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_16_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2388 : forall X1 X2:term, auto___def_19 X2 -> auto___def_18 X1 -> auto___def_16 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_19 X2 -> auto___def_16 (key X1 X2)). tauto. exact (rem_2387 X1 X2).
Qed.

Remark rem_2389 : forall X1 X2:term, auto___def_42 prv -> auto_knows_old X2 -> auto___def_3 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_42 prv -> False). tauto.
  exact (rem_2075).
Qed.

Remark rem_2390 : forall X1 X2:term, auto___def_42 prv -> auto___type_8 X1 -> auto_knows_old X2 -> auto___def_3 X1 X2. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2. intros. apply (rem_2389 X1 X2);  assumption.
Qed.

Remark rem_2391 : forall X1 X2:term, auto___def_43 prv -> auto___def_44 X1 -> auto_knows_old X2 -> auto___def_44 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_44 X1 -> auto___def_44 X1). tauto. exact (rem_2081 X1).
Qed.

Remark rem_2392 : forall X1 X2:term, auto___def_43 prv -> auto___def_44 X1 -> auto_knows_old X2 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_2065 X2).
Qed.

Remark rem_2393 : forall X1 X2:term, auto___def_43 prv -> auto___def_44 X1 -> auto_knows_old X2 -> (auto___def_44 X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_44 X1). 2:apply (rem_2391 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_2392 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2394 : forall X1 X2:term, auto___def_43 prv -> auto___def_44 X1 -> auto_knows_old X2 -> auto___def_3 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_2393 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_3_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2395 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old (key prv X1) -> auto___def_3 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_582 prv X1 H);  intros.
  apply (rem_2390 X1 X2);  tauto.
  apply (rem_2394 X1 X2);  tauto.
Qed.

Remark rem_2396 : forall X1 X2:term, auto___def_18 prv -> auto___def_19 X1 -> auto___def_37 X2 -> auto___def_3 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 prv -> False). tauto.
  exact (rem_2089).
Qed.

Remark rem_2397 : forall X1 X2:term, auto___def_37 X2 -> auto___type_5 (key prv X1) -> auto___def_3 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_328 prv X1 H);  intros.
  apply (rem_2396 X1 X2);  tauto.
Qed.

Remark rem_2398 : forall X1 X2:term, auto___def_18 prv -> auto___def_23 X2 -> auto___def_28 X1 -> auto___def_3 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 prv -> False). tauto.
  exact (rem_2089).
Qed.

Remark rem_2399 : forall X1 X2:term, auto___def_18 prv -> auto___def_28 X1 -> auto___def_23 X2 -> auto___def_3 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_18 prv -> auto___def_23 X2 -> auto___def_28 X1 -> auto___def_3 X1 X2). tauto. exact (rem_2398 X1 X2).
Qed.

Remark rem_2400 : forall X1 X2:term, auto___def_23 X2 -> auto___def_24 (key prv X1) -> auto___def_3 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_624 prv X1 H);  intros.
  apply (rem_2399 X1 X2);  tauto.
Qed.

Remark rem_2401 : forall X1 X2:term, auto___def_10 X2 -> auto___def_18 prv -> auto___def_32 X1 -> auto___def_3 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 prv -> False). tauto.
  exact (rem_2089).
Qed.

Remark rem_2402 : forall X1 X2:term, auto___def_18 prv -> auto___def_32 X1 -> auto___def_10 X2 -> auto___def_3 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_10 X2 -> auto___def_18 prv -> auto___def_32 X1 -> auto___def_3 X1 X2). tauto. exact (rem_2401 X1 X2).
Qed.

Remark rem_2403 : forall X1 X2:term, auto___def_10 X2 -> auto___def_11 (key prv X1) -> auto___def_3 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_644 prv X1 H);  intros.
  apply (rem_2402 X1 X2);  tauto.
Qed.

Remark rem_2404 : forall X1 X2:term, auto___def_18 prv -> auto___def_19 X1 -> auto___def_41 X2 -> auto___def_3 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 prv -> False). tauto.
  exact (rem_2089).
Qed.

Remark rem_2405 : forall X1 X2:term, auto___def_41 X2 -> auto___type_7 (key prv X1) -> auto___def_3 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_414 prv X1 H);  intros.
  apply (rem_2404 X1 X2);  tauto.
Qed.

Remark rem_2406 : forall X1 X2:term, auto_knows_old (crypt X2 (key prv X1)) -> auto___def_3 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_565 X2 (key prv X1) H);  intros.
  apply (rem_2395 X1 X2);  tauto.
  apply (rem_2397 X1 X2);  tauto.
  apply (rem_2400 X1 X2);  tauto.
  apply (rem_2403 X1 X2);  tauto.
  apply (rem_2405 X1 X2);  tauto.
Qed.

Remark rem_2407 : auto___def_67 nil. (* Deduce positive atom. *)
Proof.
   case rem_37. intros. apply trans___def_67_nil_1;  tauto.
 tauto.
Qed.

Remark rem_2408 : forall X1:term, auto_knows_current (key pub X1) -> auto___def_51 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___def_51_1. Qed.

Remark rem_2409 : forall X1:term, auto___type_8 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_8_1. Qed.

Remark rem_2410 : forall X1:term, auto___def_42 sym -> auto___def_53 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_42 sym -> False). tauto.
  exact (rem_1652).
Qed.

Remark rem_2411 : forall X1:term, auto___def_42 sym -> auto___type_8 X1 -> auto___def_53 X1. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1. intros. apply (rem_2410 X1);  assumption.
Qed.

Remark rem_2412 : (forall X:term, auto___def_47 X -> auto___def_53 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_47_p__def_53.  tauto.
Defined.

Remark rem_2413 : (forall X:term, auto___def_47 X -> auto___def_53 X)
    -> forall X1 X2:term, auto___def_53 (session_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_47_p__def_53. intros X1 X2.  case (rem_2412 epsilon_m__def_47_p__def_53). clear  epsilon_m__def_47_p__def_53. intros. apply trans___def_53_session_old_1;  tauto.
 clear  epsilon_m__def_47_p__def_53. tauto.
Defined.

Remark rem_2414 : (forall X:term, auto___def_47 X -> auto___def_53 X)
    -> forall X1 X2:term, auto___def_47 (session_old X1 X2) -> auto___def_53 (session_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_47_p__def_53. intros X1 X2. intro H. intros.
  elim (rem_1201 X1 X2 H);  intros.
  apply (rem_2413 epsilon_m__def_47_p__def_53 X1 X2);  tauto.
Defined.

Remark rem_2415 : forall X1:term, auto___def_47 X1 -> auto___def_53 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_47_p__def_53 1.
  intro X. case X.
   intro H. elim (rem_1214  H).
   intro H. elim (rem_1210  H).
  intros X1 X2. intro H. elim (rem_708 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1209 X1 X2 H).
   intro H. elim (rem_1205  H).
  intros X1 X2. intro H. elim (rem_1211 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1208 X1 X2 H).
   intro H. elim (rem_1204  H).
   intro H. elim (rem_1207  H).
   intro H. elim (rem_1212  H).
  intros X1. intro H. elim (rem_1203 X1 H).
   intro H. elim (rem_1215  H).
  intros X1 X2. intro H. elim (rem_72 X1 X2 H).
  intros X1 X2;  exact (rem_2414 epsilon_m__def_47_p__def_53 X1 X2).
   intro H. elim (rem_1206  H).
   intro H. elim (rem_1216  H).
   intro H. elim (rem_1213  H).
Qed.

Remark rem_2416 : forall X1:term, auto___def_46 sym -> auto___def_47 X1 -> auto___def_53 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1.
  cut (auto___def_47 X1 -> auto___def_53 X1). tauto. exact (rem_2415 X1).
Qed.

Remark rem_2417 : forall X1:term, auto___def_43 sym -> auto___def_44 X1 -> auto___def_53 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_43 sym -> False). tauto.
  exact (rem_1661).
Qed.

Remark rem_2418 : forall X1:term, auto_knows_current (key sym X1) -> auto___def_53 X1. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_101 sym X1 H);  intros.
  apply (rem_2411 X1);  tauto.
  apply (rem_2416 X1);  tauto.
  apply (rem_2417 X1);  tauto.
Qed.

Remark rem_2419 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2420 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_2419 epsilon_mknows_current_p__type_9 X1);  assumption.
  tauto.
Defined.

Remark rem_2421 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto_knows_current X1 -> auto___type_9 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1. intros A1.
  case (rem_2420 epsilon_mknows_current_p__type_9 X1 A1). clear  epsilon_mknows_current_p__type_9 A1. intros. apply trans___type_9_s_1;  tauto.
 clear  epsilon_mknows_current_p__type_9 A1. tauto.
Defined.

Remark rem_2422 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto_knows_current (s X1) -> auto___type_9 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1. intro H. intros.
  elim (rem_752 X1 H);  intros.
  apply (rem_2421 epsilon_mknows_current_p__type_9 X1);  tauto.
Defined.

Remark rem_2423 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_9.  tauto.
Defined.

Remark rem_2424 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> auto___type_9 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9.  case (rem_2423 epsilon_mknows_current_p__type_9). clear  epsilon_mknows_current_p__type_9. intros. apply trans___type_9_nil_1;  tauto.
 clear  epsilon_mknows_current_p__type_9. tauto.
Defined.

Remark rem_2425 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> auto_knows_current nil -> auto___type_9 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intro H. intros.
  elim (rem_756 H);  intros.
  apply (rem_2424 epsilon_mknows_current_p__type_9);  tauto.
Defined.

Remark rem_2426 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> auto___type_9 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9.  case (rem_2423 epsilon_mknows_current_p__type_9). clear  epsilon_mknows_current_p__type_9. intros. apply trans___type_9_i_1;  tauto.
 clear  epsilon_mknows_current_p__type_9. tauto.
Defined.

Remark rem_2427 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> auto_knows_current i -> auto___type_9 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intro H. intros.
  elim (rem_759 H);  intros.
  apply (rem_2426 epsilon_mknows_current_p__type_9);  tauto.
Defined.

Remark rem_2428 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_2419 epsilon_mknows_current_p__type_9 X1).
Defined.

Remark rem_2429 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X2:term, auto_knows_current X2 -> auto_knows_current X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2430 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_2429 epsilon_mknows_current_p__type_9 X2).
Defined.

Remark rem_2431 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2428 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2430 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2432 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_9 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  case (rem_2431 epsilon_mknows_current_p__type_9 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_9 A1 A2. intros. apply trans___type_9_cons_1;  tauto.
 clear  epsilon_mknows_current_p__type_9 A1 A2. tauto.
Defined.

Remark rem_2433 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto_knows_current (cons X1 X2) -> auto___type_9 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intro H. intros.
  elim (rem_124 X1 X2 H);  intros.
  apply (rem_2432 epsilon_mknows_current_p__type_9 X1 X2);  tauto.
Defined.

Remark rem_2434 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto___def_80 X1 -> auto___def_80 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2435 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> auto___def_80 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_80 X1 -> auto___def_80 X1). tauto. exact (rem_2434 epsilon_mknows_current_p__type_9 X1).
Defined.

Remark rem_2436 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X2:term, auto___type_12 X2 -> auto___type_12 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2437 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> auto___type_12 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___type_12 X2 -> auto___type_12 X2). tauto. exact (rem_2436 epsilon_mknows_current_p__type_9 X2).
Defined.

Remark rem_2438 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> (auto___def_80 X1 /\ auto___type_12 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  cut (auto___def_80 X1). 2:apply (rem_2435 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  cut (auto___type_12 X2). 2:apply (rem_2437 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2439 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_80 X1 -> auto___type_12 X2 -> auto___type_9 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  case (rem_2438 epsilon_mknows_current_p__type_9 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_9 A1 A2. intros. apply trans___type_9_crypt_1;  tauto.
 clear  epsilon_mknows_current_p__type_9 A1 A2. tauto.
Defined.

Remark rem_2440 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_9 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  case (rem_2431 epsilon_mknows_current_p__type_9 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_9 A1 A2. intros. apply trans___type_9_crypt_2;  tauto.
 clear  epsilon_mknows_current_p__type_9 A1 A2. tauto.
Defined.

Remark rem_2441 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto___def_84 X1 -> auto___def_84 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2442 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> auto___def_84 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_84 X1 -> auto___def_84 X1). tauto. exact (rem_2441 epsilon_mknows_current_p__type_9 X1).
Defined.

Remark rem_2443 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X2:term, auto___type_14 X2 -> auto___type_14 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2444 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> auto___type_14 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___type_14 X2 -> auto___type_14 X2). tauto. exact (rem_2443 epsilon_mknows_current_p__type_9 X2).
Defined.

Remark rem_2445 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> (auto___def_84 X1 /\ auto___type_14 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  cut (auto___def_84 X1). 2:apply (rem_2442 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  cut (auto___type_14 X2). 2:apply (rem_2444 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2446 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_84 X1 -> auto___type_14 X2 -> auto___type_9 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  case (rem_2445 epsilon_mknows_current_p__type_9 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_9 A1 A2. intros. apply trans___type_9_crypt_3;  tauto.
 clear  epsilon_mknows_current_p__type_9 A1 A2. tauto.
Defined.

Remark rem_2447 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto___def_23 X1 -> auto___def_23 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2448 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_23 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_23 X1 -> auto___def_23 X1). tauto. exact (rem_2447 epsilon_mknows_current_p__type_9 X1).
Defined.

Remark rem_2449 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X2:term, auto___def_24 X2 -> auto___def_24 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2450 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_24 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_24 X2 -> auto___def_24 X2). tauto. exact (rem_2449 epsilon_mknows_current_p__type_9 X2).
Defined.

Remark rem_2451 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> (auto___def_23 X1 /\ auto___def_24 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  cut (auto___def_23 X1). 2:apply (rem_2448 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  cut (auto___def_24 X2). 2:apply (rem_2450 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2452 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___type_9 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  case (rem_2451 epsilon_mknows_current_p__type_9 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_9 A1 A2. intros. apply trans___type_9_crypt_4;  tauto.
 clear  epsilon_mknows_current_p__type_9 A1 A2. tauto.
Defined.

Remark rem_2453 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto___def_10 X1 -> auto___def_10 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2454 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_10 X1). tauto. exact (rem_2453 epsilon_mknows_current_p__type_9 X1).
Defined.

Remark rem_2455 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X2:term, auto___def_11 X2 -> auto___def_11 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2456 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_11 X2 -> auto___def_11 X2). tauto. exact (rem_2455 epsilon_mknows_current_p__type_9 X2).
Defined.

Remark rem_2457 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> (auto___def_10 X1 /\ auto___def_11 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  cut (auto___def_10 X1). 2:apply (rem_2454 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  cut (auto___def_11 X2). 2:apply (rem_2456 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2458 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___type_9 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  case (rem_2457 epsilon_mknows_current_p__type_9 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_9 A1 A2. intros. apply trans___type_9_crypt_5;  tauto.
 clear  epsilon_mknows_current_p__type_9 A1 A2. tauto.
Defined.

Remark rem_2459 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto___def_55 X1 -> auto___def_55 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2460 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> auto___def_55 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_55 X1 -> auto___def_55 X1). tauto. exact (rem_2459 epsilon_mknows_current_p__type_9 X1).
Defined.

Remark rem_2461 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X2:term, auto___def_56 X2 -> auto___def_56 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2462 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> auto___def_56 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_56 X2 -> auto___def_56 X2). tauto. exact (rem_2461 epsilon_mknows_current_p__type_9 X2).
Defined.

Remark rem_2463 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> (auto___def_55 X1 /\ auto___def_56 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  cut (auto___def_55 X1). 2:apply (rem_2460 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  cut (auto___def_56 X2). 2:apply (rem_2462 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2464 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> auto___type_9 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  case (rem_2463 epsilon_mknows_current_p__type_9 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_9 A1 A2. intros. apply trans___type_9_crypt_6;  tauto.
 clear  epsilon_mknows_current_p__type_9 A1 A2. tauto.
Defined.

Remark rem_2465 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto___def_68 X1 -> auto___def_68 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2466 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> auto___def_68 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_68 X1 -> auto___def_68 X1). tauto. exact (rem_2465 epsilon_mknows_current_p__type_9 X1).
Defined.

Remark rem_2467 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X2:term, auto___def_69 X2 -> auto___def_69 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2468 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> auto___def_69 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_69 X2 -> auto___def_69 X2). tauto. exact (rem_2467 epsilon_mknows_current_p__type_9 X2).
Defined.

Remark rem_2469 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> (auto___def_68 X1 /\ auto___def_69 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  cut (auto___def_68 X1). 2:apply (rem_2466 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  cut (auto___def_69 X2). 2:apply (rem_2468 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2470 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_68 X1 -> auto___def_69 X2 -> auto___type_9 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  case (rem_2469 epsilon_mknows_current_p__type_9 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_9 A1 A2. intros. apply trans___type_9_crypt_7;  tauto.
 clear  epsilon_mknows_current_p__type_9 A1 A2. tauto.
Defined.

Remark rem_2471 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto_knows_current (crypt X1 X2) -> auto___type_9 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intro H. intros.
  elim (rem_693 X1 X2 H);  intros.
  apply (rem_2439 epsilon_mknows_current_p__type_9 X1 X2);  tauto.
  apply (rem_2440 epsilon_mknows_current_p__type_9 X1 X2);  tauto.
  apply (rem_2446 epsilon_mknows_current_p__type_9 X1 X2);  tauto.
  apply (rem_2452 epsilon_mknows_current_p__type_9 X1 X2);  tauto.
  apply (rem_2458 epsilon_mknows_current_p__type_9 X1 X2);  tauto.
  apply (rem_2464 epsilon_mknows_current_p__type_9 X1 X2);  tauto.
  apply (rem_2470 epsilon_mknows_current_p__type_9 X1 X2);  tauto.
Defined.

Remark rem_2472 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> auto___type_9 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9.  case (rem_2423 epsilon_mknows_current_p__type_9). clear  epsilon_mknows_current_p__type_9. intros. apply trans___type_9_bob_1;  tauto.
 clear  epsilon_mknows_current_p__type_9. tauto.
Defined.

Remark rem_2473 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> auto_knows_current bob -> auto___type_9 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intro H. intros.
  elim (rem_806 H);  intros.
  apply (rem_2472 epsilon_mknows_current_p__type_9);  tauto.
Defined.

Remark rem_2474 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto___def_42 X1 -> auto___def_42 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2475 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___def_42 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_42 X1 -> auto___def_42 X1). tauto. exact (rem_2474 epsilon_mknows_current_p__type_9 X1).
Defined.

Remark rem_2476 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2477 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_2476 epsilon_mknows_current_p__type_9 X2).
Defined.

Remark rem_2478 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> (auto___def_42 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  cut (auto___def_42 X1). 2:apply (rem_2475 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_2477 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2479 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___type_9 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  case (rem_2478 epsilon_mknows_current_p__type_9 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_9 A1 A2. intros. apply trans___type_9_key_1;  tauto.
 clear  epsilon_mknows_current_p__type_9 A1 A2. tauto.
Defined.

Remark rem_2480 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto___def_46 X1 -> auto___def_46 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2481 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_46 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_46 X1 -> auto___def_46 X1). tauto. exact (rem_2480 epsilon_mknows_current_p__type_9 X1).
Defined.

Remark rem_2482 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X2:term, auto___def_47 X2 -> auto___def_47 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2483 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_47 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_47 X2 -> auto___def_47 X2). tauto. exact (rem_2482 epsilon_mknows_current_p__type_9 X2).
Defined.

Remark rem_2484 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> (auto___def_46 X1 /\ auto___def_47 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  cut (auto___def_46 X1). 2:apply (rem_2481 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  cut (auto___def_47 X2). 2:apply (rem_2483 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2485 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___type_9 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  case (rem_2484 epsilon_mknows_current_p__type_9 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_9 A1 A2. intros. apply trans___type_9_key_2;  tauto.
 clear  epsilon_mknows_current_p__type_9 A1 A2. tauto.
Defined.

Remark rem_2486 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto___def_43 X1 -> auto___def_43 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2487 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_43 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_43 X1). tauto. exact (rem_2486 epsilon_mknows_current_p__type_9 X1).
Defined.

Remark rem_2488 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X2:term, auto___def_44 X2 -> auto___def_44 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2489 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_44 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_44 X2 -> auto___def_44 X2). tauto. exact (rem_2488 epsilon_mknows_current_p__type_9 X2).
Defined.

Remark rem_2490 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> (auto___def_43 X1 /\ auto___def_44 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  cut (auto___def_43 X1). 2:apply (rem_2487 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  cut (auto___def_44 X2). 2:apply (rem_2489 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2491 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___type_9 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  case (rem_2490 epsilon_mknows_current_p__type_9 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_9 A1 A2. intros. apply trans___type_9_key_3;  tauto.
 clear  epsilon_mknows_current_p__type_9 A1 A2. tauto.
Defined.

Remark rem_2492 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto_knows_current (key X1 X2) -> auto___type_9 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intro H. intros.
  elim (rem_101 X1 X2 H);  intros.
  apply (rem_2479 epsilon_mknows_current_p__type_9 X1 X2);  tauto.
  apply (rem_2485 epsilon_mknows_current_p__type_9 X1 X2);  tauto.
  apply (rem_2491 epsilon_mknows_current_p__type_9 X1 X2);  tauto.
Defined.

Remark rem_2493 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> auto___type_9 t_old. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9.  case (rem_2423 epsilon_mknows_current_p__type_9). clear  epsilon_mknows_current_p__type_9. intros. apply trans___type_9_t_old_1;  tauto.
 clear  epsilon_mknows_current_p__type_9. tauto.
Defined.

Remark rem_2494 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> auto_knows_current t_old -> auto___type_9 t_old. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intro H. intros.
  elim (rem_828 H);  intros.
  apply (rem_2493 epsilon_mknows_current_p__type_9);  tauto.
Defined.

Remark rem_2495 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> auto___type_9 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9.  case (rem_2423 epsilon_mknows_current_p__type_9). clear  epsilon_mknows_current_p__type_9. intros. apply trans___type_9_alice_1;  tauto.
 clear  epsilon_mknows_current_p__type_9. tauto.
Defined.

Remark rem_2496 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> auto_knows_current alice -> auto___type_9 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intro H. intros.
  elim (rem_831 H);  intros.
  apply (rem_2495 epsilon_mknows_current_p__type_9);  tauto.
Defined.

Remark rem_2497 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> auto___type_9 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9.  case (rem_2423 epsilon_mknows_current_p__type_9). clear  epsilon_mknows_current_p__type_9. intros. apply trans___type_9_server_1;  tauto.
 clear  epsilon_mknows_current_p__type_9. tauto.
Defined.

Remark rem_2498 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> auto_knows_current server -> auto___type_9 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intro H. intros.
  elim (rem_834 H);  intros.
  apply (rem_2497 epsilon_mknows_current_p__type_9);  tauto.
Defined.

Remark rem_2499 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> auto___type_9 t_current. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9.  case (rem_2423 epsilon_mknows_current_p__type_9). clear  epsilon_mknows_current_p__type_9. intros. apply trans___type_9_t_current_1;  tauto.
 clear  epsilon_mknows_current_p__type_9. tauto.
Defined.

Remark rem_2500 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> auto_knows_current t_current -> auto___type_9 t_current. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intro H. intros.
  elim (rem_837 H);  intros.
  apply (rem_2499 epsilon_mknows_current_p__type_9);  tauto.
Defined.

Remark rem_2501 : forall X1:term, auto_knows_current X1 -> auto___type_9 X1. (* Induct. *)
Proof.
  fix epsilon_mknows_current_p__type_9 1.
  intro X. case X.
  exact (rem_2496 epsilon_mknows_current_p__type_9 ).
  exact (rem_2473 epsilon_mknows_current_p__type_9 ).
  intros X1 X2;  exact (rem_2433 epsilon_mknows_current_p__type_9 X1 X2).
  intros X1 X2;  exact (rem_2471 epsilon_mknows_current_p__type_9 X1 X2).
  exact (rem_2427 epsilon_mknows_current_p__type_9 ).
  intros X1 X2;  exact (rem_2492 epsilon_mknows_current_p__type_9 X1 X2).
  intros X1 X2. intro H. elim (rem_704 X1 X2 H).
  exact (rem_2425 epsilon_mknows_current_p__type_9 ).
   intro H. elim (rem_842  H).
   intro H. elim (rem_843  H).
  intros X1;  exact (rem_2422 epsilon_mknows_current_p__type_9 X1).
  exact (rem_2498 epsilon_mknows_current_p__type_9 ).
  intros X1 X2. intro H. elim (rem_839 X1 X2 H).
  intros X1 X2. intro H. elim (rem_840 X1 X2 H).
   intro H. elim (rem_841  H).
  exact (rem_2500 epsilon_mknows_current_p__type_9 ).
  exact (rem_2494 epsilon_mknows_current_p__type_9 ).
Qed.

Remark rem_2502 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current X1 -> auto___type_9 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_current X1 -> auto___type_9 X1). tauto. exact (rem_2501 X1).
Qed.

Remark rem_2503 : forall X1 X2:term, auto___def_54 X1 X2 -> or_1
    (auto_knows_current X1 /\ auto_knows_current X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2504 : forall X1 X2:term, auto___def_54 X2 X1 -> auto___type_9 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_2503 X2 X1 H);  intros.
  apply (rem_2502 X1 X2);  tauto.
Qed.

Remark rem_2505 : auto___def_39 t_old. (* Deduce positive atom. *)
Proof.
   case rem_37. intros. apply trans___def_39_t_old_1;  tauto.
 tauto.
Qed.

Remark rem_2506 : forall X1 X2 X3 X4:term, auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (l X2 X3) -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_597 X2 X3 H);  intros.
Qed.

Remark rem_2507 : forall X1 X2 X3 X4:term, auto___def_42 sym -> auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (l X2 X3) -> auto___def_40 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (l X2 X3) -> auto___def_40 X1 X2 X3 X4). tauto.
  exact (rem_2506 X1 X2 X3 X4).
Qed.

Remark rem_2508 : forall X1 X2 X3 X4:term, auto___def_42 sym -> auto___type_8 (cons X3 (cons server nil)) -> auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (l X2 X3) -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2 X3 X4. intros. apply (rem_2507 X1 X2 X3 X4);  assumption.
Qed.

Remark rem_2509 : forall X1 X2 X3 X4:term, auto___def_44 (cons X3 (cons server nil)) -> auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (l X2 X3) -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_711 X3 (cons server nil) H);  intros.
Qed.

Remark rem_2510 : forall X1 X2 X3 X4:term, auto___def_43 sym -> auto___def_44 (cons X3 (cons server nil)) -> auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (l X2 X3) -> auto___def_40 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_44 (cons X3 (cons server nil)) -> auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (l X2 X3) -> auto___def_40 X1 X2 X3 X4). tauto.
  exact (rem_2509 X1 X2 X3 X4).
Qed.

Remark rem_2511 : forall X1 X2 X3 X4:term, auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto_knows_old (l X2 X3) -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_582 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_2508 X1 X2 X3 X4);  tauto.
  apply (rem_2510 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2512 : forall X1 X2 X3 X4:term, auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto_knows_old (l X2 X3) -> auto_knows_old nil -> auto___def_40 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto_knows_old (l X2 X3) -> auto___def_40 X1 X2 X3 X4). tauto.
  exact (rem_2511 X1 X2 X3 X4).
Qed.

Remark rem_2513 : forall X1 X2 X3 X4:term, auto_knows_old X1 -> auto_knows_old nil -> auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto_knows_old (l X2 X3) -> auto___def_40 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto_knows_old (l X2 X3) -> auto_knows_old nil -> auto___def_40 X1 X2 X3 X4). tauto. exact (rem_2512 X1 X2 X3 X4).
Qed.

Remark rem_2514 : forall X1 X2 X3 X4:term, auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (cons X1 nil) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto_knows_old (l X2 X3) -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_255 X1 nil H);  intros.
  apply (rem_2513 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2515 : forall X1 X2 X3 X4:term, auto_knows_old X4 -> auto_knows_old (cons X1 nil) -> auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto_knows_old (l X2 X3) -> auto___def_40 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (cons X1 nil) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto_knows_old (l X2 X3) -> auto___def_40 X1 X2 X3 X4). tauto. exact (rem_2514 X1 X2 X3 X4).
Qed.

Remark rem_2516 : forall X1 X2 X3 X4:term, auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto_knows_old (l X2 X3) -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_255 X4 (cons X1 nil) H);  intros.
  apply (rem_2515 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2517 : forall X1 X2 X3 X4:term, auto_knows_old (l X2 X3) -> auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto___def_40 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto_knows_old (l X2 X3) -> auto___def_40 X1 X2 X3 X4). tauto. exact (rem_2516 X1 X2 X3 X4).
Qed.

Remark rem_2518 : forall X1 X2 X3 X4:term, auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_255 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_2517 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2519 : forall X1 X2 X3 X4:term, auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto_knows_old t_old -> auto___def_40 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto___def_40 X1 X2 X3 X4). tauto.
  exact (rem_2518 X1 X2 X3 X4).
Qed.

Remark rem_2520 : forall X1 X2 X3 X4:term, auto_knows_old t_old -> auto_knows_old (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto___def_40 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto_knows_old t_old -> auto___def_40 X1 X2 X3 X4). tauto. exact (rem_2519 X1 X2 X3 X4).
Qed.

Remark rem_2521 : forall X1 X2 X3 X4:term, auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (cons t_old (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_255 t_old (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_2520 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2522 : forall X1 X2 X3 X4:term, auto_knows_old (cons t_old (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (cons t_old (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto___def_40 X1 X2 X3 X4). tauto. exact (rem_2521 X1 X2 X3 X4).
Qed.

Remark rem_2523 : forall X1 X2 X3 X4:term, auto___def_31 (cons X4 (cons X1 nil)) -> auto___def_39 (l X2 X3) -> auto___type_5 (key sym (cons X3 (cons server nil))) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_39 X4 (cons X1 nil) H);  intros.
Qed.

Remark rem_2524 : forall X1 X2 X3 X4:term, auto___def_39 (l X2 X3) -> auto___def_31 (cons X4 (cons X1 nil)) -> auto___type_5 (key sym (cons X3 (cons server nil))) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_31 (cons X4 (cons X1 nil)) -> auto___def_39 (l X2 X3) -> auto___type_5 (key sym (cons X3 (cons server nil))) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4). tauto. exact (rem_2523 X1 X2 X3 X4).
Qed.

Remark rem_2525 : forall X1 X2 X3 X4:term, auto___def_38 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_5 (key sym (cons X3 (cons server nil))) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_500 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_2524 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2526 : forall X1 X2 X3 X4:term, auto___def_38 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_5 (key sym (cons X3 (cons server nil))) -> auto___type_6 t_old -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_38 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_5 (key sym (cons X3 (cons server nil))) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4). tauto.
  exact (rem_2525 X1 X2 X3 X4).
Qed.

Remark rem_2527 : forall X1 X2 X3 X4:term, auto___type_6 t_old -> auto___def_38 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_5 (key sym (cons X3 (cons server nil))) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_38 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_5 (key sym (cons X3 (cons server nil))) -> auto___type_6 t_old -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4). tauto. exact (rem_2526 X1 X2 X3 X4).
Qed.

Remark rem_2528 : forall X1 X2 X3 X4:term, auto___def_37 (cons t_old (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_5 (key sym (cons X3 (cons server nil))) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_523 t_old (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_2527 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2529 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2530 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1. intros A1.
  cut (auto_knows_old X1). 2:apply (rem_2529 epsilon_mknows_old_p__type_3 X1);  assumption.
  tauto.
Defined.

Remark rem_2531 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto_knows_old X1 -> auto___type_3 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1. intros A1.
  case (rem_2530 epsilon_mknows_old_p__type_3 X1 A1). clear  epsilon_mknows_old_p__type_3 A1. intros. apply trans___type_3_s_1;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1. tauto.
Defined.

Remark rem_2532 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto_knows_old (s X1) -> auto___type_3 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1. intro H. intros.
  elim (rem_241 X1 H);  intros.
  apply (rem_2531 epsilon_mknows_old_p__type_3 X1);  tauto.
Defined.

Remark rem_2533 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3.  tauto.
Defined.

Remark rem_2534 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto___type_3 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3.  case (rem_2533 epsilon_mknows_old_p__type_3). clear  epsilon_mknows_old_p__type_3. intros. apply trans___type_3_nil_1;  tauto.
 clear  epsilon_mknows_old_p__type_3. tauto.
Defined.

Remark rem_2535 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto_knows_old nil -> auto___type_3 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intro H. intros.
  elim (rem_245 H);  intros.
  apply (rem_2534 epsilon_mknows_old_p__type_3);  tauto.
Defined.

Remark rem_2536 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto___type_3 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3.  case (rem_2533 epsilon_mknows_old_p__type_3). clear  epsilon_mknows_old_p__type_3. intros. apply trans___type_3_i_1;  tauto.
 clear  epsilon_mknows_old_p__type_3. tauto.
Defined.

Remark rem_2537 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto_knows_old i -> auto___type_3 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intro H. intros.
  elim (rem_248 H);  intros.
  apply (rem_2536 epsilon_mknows_old_p__type_3);  tauto.
Defined.

Remark rem_2538 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto_knows_old X1 -> auto_knows_old X1). tauto. exact (rem_2529 epsilon_mknows_old_p__type_3 X1).
Defined.

Remark rem_2539 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X2:term, auto_knows_old X2 -> auto_knows_old X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2540 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_2539 epsilon_mknows_old_p__type_3 X2).
Defined.

Remark rem_2541 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> (auto_knows_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_2538 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_2540 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2542 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_3 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2541 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_cons_1;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2543 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old (cons X1 X2) -> auto___type_3 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intro H. intros.
  elim (rem_255 X1 X2 H);  intros.
  apply (rem_2542 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
Defined.

Remark rem_2544 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2541 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_crypt_1;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2545 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto___def_37 X1 -> auto___def_37 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2546 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> auto___def_37 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_37 X1 -> auto___def_37 X1). tauto. exact (rem_2545 epsilon_mknows_old_p__type_3 X1).
Defined.

Remark rem_2547 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X2:term, auto___type_5 X2 -> auto___type_5 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2548 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> auto___type_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___type_5 X2 -> auto___type_5 X2). tauto. exact (rem_2547 epsilon_mknows_old_p__type_3 X2).
Defined.

Remark rem_2549 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> (auto___def_37 X1 /\ auto___type_5 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_37 X1). 2:apply (rem_2546 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  cut (auto___type_5 X2). 2:apply (rem_2548 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2550 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> auto___type_3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2549 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_crypt_2;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2551 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto___def_23 X1 -> auto___def_23 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2552 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_23 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_23 X1 -> auto___def_23 X1). tauto. exact (rem_2551 epsilon_mknows_old_p__type_3 X1).
Defined.

Remark rem_2553 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X2:term, auto___def_24 X2 -> auto___def_24 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2554 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_24 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_24 X2 -> auto___def_24 X2). tauto. exact (rem_2553 epsilon_mknows_old_p__type_3 X2).
Defined.

Remark rem_2555 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> (auto___def_23 X1 /\ auto___def_24 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_23 X1). 2:apply (rem_2552 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  cut (auto___def_24 X2). 2:apply (rem_2554 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2556 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___type_3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2555 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_crypt_3;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2557 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto___def_10 X1 -> auto___def_10 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2558 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_10 X1). tauto. exact (rem_2557 epsilon_mknows_old_p__type_3 X1).
Defined.

Remark rem_2559 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X2:term, auto___def_11 X2 -> auto___def_11 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2560 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_11 X2 -> auto___def_11 X2). tauto. exact (rem_2559 epsilon_mknows_old_p__type_3 X2).
Defined.

Remark rem_2561 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> (auto___def_10 X1 /\ auto___def_11 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_10 X1). 2:apply (rem_2558 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  cut (auto___def_11 X2). 2:apply (rem_2560 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2562 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___type_3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2561 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_crypt_4;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2563 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto___def_41 X1 -> auto___def_41 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2564 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> auto___def_41 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_41 X1 -> auto___def_41 X1). tauto. exact (rem_2563 epsilon_mknows_old_p__type_3 X1).
Defined.

Remark rem_2565 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X2:term, auto___type_7 X2 -> auto___type_7 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2566 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> auto___type_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___type_7 X2 -> auto___type_7 X2). tauto. exact (rem_2565 epsilon_mknows_old_p__type_3 X2).
Defined.

Remark rem_2567 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> (auto___def_41 X1 /\ auto___type_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_41 X1). 2:apply (rem_2564 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  cut (auto___type_7 X2). 2:apply (rem_2566 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2568 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> auto___type_3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2567 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_crypt_5;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2569 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old (crypt X1 X2) -> auto___type_3 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intro H. intros.
  elim (rem_565 X1 X2 H);  intros.
  apply (rem_2544 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
  apply (rem_2550 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
  apply (rem_2556 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
  apply (rem_2562 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
  apply (rem_2568 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
Defined.

Remark rem_2570 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto___type_3 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3.  case (rem_2533 epsilon_mknows_old_p__type_3). clear  epsilon_mknows_old_p__type_3. intros. apply trans___type_3_bob_1;  tauto.
 clear  epsilon_mknows_old_p__type_3. tauto.
Defined.

Remark rem_2571 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto_knows_old bob -> auto___type_3 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intro H. intros.
  elim (rem_568 H);  intros.
  apply (rem_2570 epsilon_mknows_old_p__type_3);  tauto.
Defined.

Remark rem_2572 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto___def_42 X1 -> auto___def_42 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2573 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___def_42 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_42 X1 -> auto___def_42 X1). tauto. exact (rem_2572 epsilon_mknows_old_p__type_3 X1).
Defined.

Remark rem_2574 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2575 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_2574 epsilon_mknows_old_p__type_3 X2).
Defined.

Remark rem_2576 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> (auto___def_42 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_42 X1). 2:apply (rem_2573 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_2575 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2577 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___type_3 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2576 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_key_1;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2578 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto___def_43 X1 -> auto___def_43 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2579 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_43 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_43 X1). tauto. exact (rem_2578 epsilon_mknows_old_p__type_3 X1).
Defined.

Remark rem_2580 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X2:term, auto___def_44 X2 -> auto___def_44 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2581 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_44 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_44 X2 -> auto___def_44 X2). tauto. exact (rem_2580 epsilon_mknows_old_p__type_3 X2).
Defined.

Remark rem_2582 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> (auto___def_43 X1 /\ auto___def_44 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_43 X1). 2:apply (rem_2579 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  cut (auto___def_44 X2). 2:apply (rem_2581 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2583 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___type_3 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2582 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_key_2;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2584 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old (key X1 X2) -> auto___type_3 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intro H. intros.
  elim (rem_582 X1 X2 H);  intros.
  apply (rem_2577 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
  apply (rem_2583 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
Defined.

Remark rem_2585 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto___type_3 t_old. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3.  case (rem_2533 epsilon_mknows_old_p__type_3). clear  epsilon_mknows_old_p__type_3. intros. apply trans___type_3_t_old_1;  tauto.
 clear  epsilon_mknows_old_p__type_3. tauto.
Defined.

Remark rem_2586 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto_knows_old t_old -> auto___type_3 t_old. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intro H. intros.
  elim (rem_585 H);  intros.
  apply (rem_2585 epsilon_mknows_old_p__type_3);  tauto.
Defined.

Remark rem_2587 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto___type_3 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3.  case (rem_2533 epsilon_mknows_old_p__type_3). clear  epsilon_mknows_old_p__type_3. intros. apply trans___type_3_alice_1;  tauto.
 clear  epsilon_mknows_old_p__type_3. tauto.
Defined.

Remark rem_2588 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto_knows_old alice -> auto___type_3 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intro H. intros.
  elim (rem_588 H);  intros.
  apply (rem_2587 epsilon_mknows_old_p__type_3);  tauto.
Defined.

Remark rem_2589 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto___type_3 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3.  case (rem_2533 epsilon_mknows_old_p__type_3). clear  epsilon_mknows_old_p__type_3. intros. apply trans___type_3_server_1;  tauto.
 clear  epsilon_mknows_old_p__type_3. tauto.
Defined.

Remark rem_2590 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto_knows_old server -> auto___type_3 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intro H. intros.
  elim (rem_591 H);  intros.
  apply (rem_2589 epsilon_mknows_old_p__type_3);  tauto.
Defined.

Remark rem_2591 : forall X1:term, auto_knows_old X1 -> auto___type_3 X1. (* Induct. *)
Proof.
  fix epsilon_mknows_old_p__type_3 1.
  intro X. case X.
  exact (rem_2588 epsilon_mknows_old_p__type_3 ).
  exact (rem_2571 epsilon_mknows_old_p__type_3 ).
  intros X1 X2;  exact (rem_2543 epsilon_mknows_old_p__type_3 X1 X2).
  intros X1 X2;  exact (rem_2569 epsilon_mknows_old_p__type_3 X1 X2).
  exact (rem_2537 epsilon_mknows_old_p__type_3 ).
  intros X1 X2;  exact (rem_2584 epsilon_mknows_old_p__type_3 X1 X2).
  intros X1 X2. intro H. elim (rem_597 X1 X2 H).
  exact (rem_2535 epsilon_mknows_old_p__type_3 ).
   intro H. elim (rem_596  H).
   intro H. elim (rem_598  H).
  intros X1;  exact (rem_2532 epsilon_mknows_old_p__type_3 X1).
  exact (rem_2590 epsilon_mknows_old_p__type_3 ).
  intros X1 X2. intro H. elim (rem_593 X1 X2 H).
  intros X1 X2. intro H. elim (rem_594 X1 X2 H).
   intro H. elim (rem_595  H).
   intro H. elim (rem_599  H).
  exact (rem_2586 epsilon_mknows_old_p__type_3 ).
Qed.

Remark rem_2592 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_27 (cons X1 nil) -> auto___def_28 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old X1 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old X1 -> auto___type_3 X1). tauto. exact (rem_2591 X1).
Qed.

Remark rem_2593 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_27 (cons X1 nil) -> auto___def_28 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old X1 -> auto___type_6 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old X1 -> auto___type_6 X1). tauto. exact (rem_1778 X1).
Qed.

Remark rem_2594 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_27 (cons X1 nil) -> auto___def_28 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_2065 X2).
Qed.

Remark rem_2595 : forall X3:term, auto_knows_old X3 -> auto_knows_old X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2596 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_27 (cons X1 nil) -> auto___def_28 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old X3 -> auto_knows_old X3). tauto. exact (rem_2595 X3).
Qed.

Remark rem_2597 : forall X4:term, auto___def_16 X4 -> auto___def_16 X4. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2598 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_27 (cons X1 nil) -> auto___def_28 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_16 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_16 X4 -> auto___def_16 X4). tauto. exact (rem_2597 X4).
Qed.

Remark rem_2599 : (forall X:term, auto___def_16 X -> auto___type_5 X)
    -> forall X1:term, auto___def_18 X1 -> auto___def_18 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2600 : (forall X:term, auto___def_16 X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_18 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_16_p__type_5. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_18 X1). tauto. exact (rem_2599 epsilon_m__def_16_p__type_5 X1).
Defined.

Remark rem_2601 : (forall X:term, auto___def_16 X -> auto___type_5 X)
    -> forall X2:term, auto___def_19 X2 -> auto___def_19 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2602 : (forall X:term, auto___def_16 X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_19 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_16_p__type_5. intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_19 X2). tauto. exact (rem_2601 epsilon_m__def_16_p__type_5 X2).
Defined.

Remark rem_2603 : (forall X:term, auto___def_16 X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> (auto___def_18 X1 /\ auto___def_19 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_16_p__type_5. intros X1 X2. intros A1 A2.
  cut (auto___def_18 X1). 2:apply (rem_2600 epsilon_m__def_16_p__type_5 X1 X2);  assumption.
  cut (auto___def_19 X2). 2:apply (rem_2602 epsilon_m__def_16_p__type_5 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2604 : (forall X:term, auto___def_16 X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___type_5 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_16_p__type_5. intros X1 X2. intros A1 A2.
  case (rem_2603 epsilon_m__def_16_p__type_5 X1 X2 A1 A2). clear  epsilon_m__def_16_p__type_5 A1 A2. intros. apply trans___type_5_key_1;  tauto.
 clear  epsilon_m__def_16_p__type_5 A1 A2. tauto.
Defined.

Remark rem_2605 : (forall X:term, auto___def_16 X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_16 (key X1 X2) -> auto___type_5 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_16_p__type_5. intros X1 X2. intro H. intros.
  elim (rem_1088 X1 X2 H);  intros.
  apply (rem_2604 epsilon_m__def_16_p__type_5 X1 X2);  tauto.
Defined.

Remark rem_2606 : forall X1 X2:term, auto___def_16 (session_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2607 : forall X1:term, auto___def_16 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2608 : auto___def_16 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2609 : auto___def_16 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2610 : forall X1 X2:term, auto___def_16 (session_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2611 : forall X1 X2:term, auto___def_16 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2612 : auto___def_16 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2613 : auto___def_16 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2614 : forall X1 X2:term, auto___def_16 (l X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2615 : forall X1 X2:term, auto___def_16 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2616 : auto___def_16 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2617 : auto___def_16 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2618 : auto___def_16 t_old -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2619 : auto___def_16 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2620 : auto___def_16 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2621 : auto___def_16 t_current -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2622 : forall X4:term, auto___def_16 X4 -> auto___type_5 X4. (* Induct. *)
Proof.
  fix epsilon_m__def_16_p__type_5 1.
  intro X. case X.
   intro H. elim (rem_2619  H).
   intro H. elim (rem_2616  H).
  intros X1 X2. intro H. elim (rem_2611 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2615 X1 X2 H).
   intro H. elim (rem_2609  H).
  intros X1 X2;  exact (rem_2605 epsilon_m__def_16_p__type_5 X1 X2).
  intros X1 X2. intro H. elim (rem_2614 X1 X2 H).
   intro H. elim (rem_2608  H).
   intro H. elim (rem_2613  H).
   intro H. elim (rem_2617  H).
  intros X1. intro H. elim (rem_2607 X1 H).
   intro H. elim (rem_2620  H).
  intros X1 X2. intro H. elim (rem_2606 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2610 X1 X2 H).
   intro H. elim (rem_2612  H).
   intro H. elim (rem_2621  H).
   intro H. elim (rem_2618  H).
Qed.

Remark rem_2623 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_27 (cons X1 nil) -> auto___def_28 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old X1 -> auto___type_5 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_16 X4 -> auto___type_5 X4). tauto. exact (rem_2622 X4).
Qed.

Remark rem_2624 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_27 (cons X1 nil) -> auto___def_28 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old X1 -> (auto___type_3 X1 /\ auto___type_6 X1 /\ auto_knows_old X2 /\ auto_knows_old X3 /\ auto___def_16 X4 /\ auto___type_5 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto___type_3 X1). 2:apply (rem_2592 X1 X2 X3 X4);  assumption.
  cut (auto___type_6 X1). 2:apply (rem_2593 X1 X2 X3 X4);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_2594 X1 X2 X3 X4);  assumption.
  cut (auto_knows_old X3). 2:apply (rem_2596 X1 X2 X3 X4);  assumption.
  cut (auto___def_16 X4). 2:apply (rem_2598 X1 X2 X3 X4);  assumption.
  cut (auto___type_5 X4). 2:apply (rem_2623 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_2625 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_27 (cons X1 nil) -> auto___def_28 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_2624 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_40_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_2626 : forall X1 X2 X3 X4:term, auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1094 X4 (cons X1 nil) H);  intros.
  apply (rem_2625 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2627 : forall X1 X2 X3 X4:term, auto_knows_old X2 -> auto_knows_old X3 -> auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4). tauto. exact (rem_2626 X1 X2 X3 X4).
Qed.

Remark rem_2628 : forall X1 X2 X3 X4:term, auto___def_14 (l X2 X3) -> auto___def_26 (cons X4 (cons X1 nil)) -> auto___def_28 (cons X3 (cons server nil)) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_618 X2 X3 H);  intros.
  apply (rem_2627 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2629 : forall X1 X2 X3 X4:term, auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_28 (cons X3 (cons server nil)) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_620 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_2628 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2630 : forall X1 X2 X3 X4:term, auto___def_18 sym -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_28 (cons X3 (cons server nil)) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_28 (cons X3 (cons server nil)) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4). tauto.
  exact (rem_2629 X1 X2 X3 X4).
Qed.

Remark rem_2631 : forall X1 X2 X3 X4:term, auto___def_18 sym -> auto___def_28 (cons X3 (cons server nil)) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_18 sym -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_28 (cons X3 (cons server nil)) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4). tauto. exact (rem_2630 X1 X2 X3 X4).
Qed.

Remark rem_2632 : forall X1 X2 X3 X4:term, auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_624 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_2631 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2633 : forall X1 X2 X3 X4:term, auto___def_12 t_old -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4). tauto.
  exact (rem_2632 X1 X2 X3 X4).
Qed.

Remark rem_2634 : forall X1 X2 X3 X4:term, auto___def_12 t_old -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_12 t_old -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto___def_25 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4). tauto. exact (rem_2633 X1 X2 X3 X4).
Qed.

Remark rem_2635 : forall X1 X2 X3 X4:term, auto___def_23 (cons t_old (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_24 (key sym (cons X3 (cons server nil))) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_628 t_old (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_2634 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2636 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_17 (cons X1 nil) -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old X1 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old X1 -> auto___type_3 X1). tauto. exact (rem_2591 X1).
Qed.

Remark rem_2637 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_17 (cons X1 nil) -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old X1 -> auto___type_6 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old X1 -> auto___type_6 X1). tauto. exact (rem_1778 X1).
Qed.

Remark rem_2638 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_17 (cons X1 nil) -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_2065 X2).
Qed.

Remark rem_2639 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_17 (cons X1 nil) -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old X3 -> auto_knows_old X3). tauto. exact (rem_2595 X3).
Qed.

Remark rem_2640 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_17 (cons X1 nil) -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_16 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_16 X4 -> auto___def_16 X4). tauto. exact (rem_2597 X4).
Qed.

Remark rem_2641 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_17 (cons X1 nil) -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old X1 -> auto___type_5 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_16 X4 -> auto___type_5 X4). tauto. exact (rem_2622 X4).
Qed.

Remark rem_2642 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_17 (cons X1 nil) -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old X1 -> (auto___type_3 X1 /\ auto___type_6 X1 /\ auto_knows_old X2 /\ auto_knows_old X3 /\ auto___def_16 X4 /\ auto___type_5 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto___type_3 X1). 2:apply (rem_2636 X1 X2 X3 X4);  assumption.
  cut (auto___type_6 X1). 2:apply (rem_2637 X1 X2 X3 X4);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_2638 X1 X2 X3 X4);  assumption.
  cut (auto_knows_old X3). 2:apply (rem_2639 X1 X2 X3 X4);  assumption.
  cut (auto___def_16 X4). 2:apply (rem_2640 X1 X2 X3 X4);  assumption.
  cut (auto___type_5 X4). 2:apply (rem_2641 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_2643 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_17 (cons X1 nil) -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_2642 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_40_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_2644 : forall X1 X2 X3 X4:term, auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_738 X4 (cons X1 nil) H);  intros.
  apply (rem_2643 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2645 : forall X1 X2 X3 X4:term, auto_knows_old X2 -> auto_knows_old X3 -> auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4). tauto. exact (rem_2644 X1 X2 X3 X4).
Qed.

Remark rem_2646 : forall X1 X2 X3 X4:term, auto___def_14 (l X2 X3) -> auto___def_15 (cons X4 (cons X1 nil)) -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_618 X2 X3 H);  intros.
  apply (rem_2645 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2647 : forall X1 X2 X3 X4:term, auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_640 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_2646 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2648 : forall X1 X2 X3 X4:term, auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_18 sym -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4). tauto.
  exact (rem_2647 X1 X2 X3 X4).
Qed.

Remark rem_2649 : forall X1 X2 X3 X4:term, auto___def_18 sym -> auto___def_32 (cons X3 (cons server nil)) -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_18 sym -> auto___def_32 (cons X3 (cons server nil)) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4). tauto. exact (rem_2648 X1 X2 X3 X4).
Qed.

Remark rem_2650 : forall X1 X2 X3 X4:term, auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_644 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_2649 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2651 : forall X1 X2 X3 X4:term, auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_12 t_old -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4). tauto.
  exact (rem_2650 X1 X2 X3 X4).
Qed.

Remark rem_2652 : forall X1 X2 X3 X4:term, auto___def_12 t_old -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___def_11 (key sym (cons X3 (cons server nil))) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_11 (key sym (cons X3 (cons server nil))) -> auto___def_12 t_old -> auto___def_13 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4). tauto. exact (rem_2651 X1 X2 X3 X4).
Qed.

Remark rem_2653 : forall X1 X2 X3 X4:term, auto___def_10 (cons t_old (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___def_11 (key sym (cons X3 (cons server nil))) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_648 t_old (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_2652 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2654 : forall X1 X2 X3 X4:term, auto___def_41 (cons t_old (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_7 (key sym (cons X3 (cons server nil))) -> auto_knows_old X4 -> auto_knows_old X1 -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_393 t_old (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
Qed.

Remark rem_2655 : forall X1 X2 X3 X4:term, auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (crypt (cons t_old (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_565 (cons t_old (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil))) H);  intros.
  apply (rem_2522 X1 X2 X3 X4);  tauto.
  apply (rem_2528 X1 X2 X3 X4);  tauto.
  apply (rem_2635 X1 X2 X3 X4);  tauto.
  apply (rem_2653 X1 X2 X3 X4);  tauto.
  apply (rem_2654 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2656 : forall X1 X2 X3 X4:term, auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (cons t_old nil) -> auto_knows_old (crypt (cons t_old (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_40 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (crypt (cons t_old (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_40 X1 X2 X3 X4). tauto.
  exact (rem_2655 X1 X2 X3 X4).
Qed.

Remark rem_2657 : forall X1 X2 X3 X4:term, auto_knows_old X1 -> auto_knows_old (cons t_old nil) -> auto_knows_old X4 -> auto_knows_old (crypt (cons t_old (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_40 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old (cons t_old nil) -> auto_knows_old (crypt (cons t_old (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_40 X1 X2 X3 X4). tauto. exact (rem_2656 X1 X2 X3 X4).
Qed.

Remark rem_2658 : forall X1 X2 X3 X4:term, auto_knows_old X4 -> auto_knows_old (cons X1 (cons t_old nil)) -> auto_knows_old (crypt (cons t_old (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_255 X1 (cons t_old nil) H);  intros.
  apply (rem_2657 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2659 : forall X1 X2 X3 X4:term, auto_knows_old (cons X1 (cons t_old nil)) -> auto_knows_old X4 -> auto_knows_old (crypt (cons t_old (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_40 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_old X4 -> auto_knows_old (cons X1 (cons t_old nil)) -> auto_knows_old (crypt (cons t_old (cons (l X2 X3) (cons X4 (cons X1 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_40 X1 X2 X3 X4). tauto. exact (rem_2658 X1 X2 X3 X4).
Qed.

Remark rem_2660 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> forall X1:term, auto___type_5 (s X1) -> auto_knows_old X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__type_5. intros X1. intro H. intros.
  elim (rem_331 X1 H);  intros.
Defined.

Remark rem_2661 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> forall X1:term, auto_knows_old (s X1) -> auto___type_5 (s X1) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__type_5. intros X1. intro H. intros.
  elim (rem_241 X1 H);  intros.
  apply (rem_2660 epsilon_mknows_old_m__type_5 X1);  tauto.
Defined.

Remark rem_2662 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> auto___type_5 nil -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__type_5. intro H. intros.
  elim (rem_332 H);  intros.
Defined.

Remark rem_2663 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> auto_knows_old nil -> auto___type_5 nil -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__type_5. intro H. intros.
  elim (rem_245 H);  intros.
  apply (rem_2662 epsilon_mknows_old_m__type_5);  tauto.
Defined.

Remark rem_2664 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> auto___type_5 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__type_5. intro H. intros.
  elim (rem_333 H);  intros.
Defined.

Remark rem_2665 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> auto_knows_old i -> auto___type_5 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__type_5. intro H. intros.
  elim (rem_248 H);  intros.
  apply (rem_2664 epsilon_mknows_old_m__type_5);  tauto.
Defined.

Remark rem_2666 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> forall X1 X2:term, auto___type_5 (cons X1 X2) -> auto_knows_old X1 -> auto_knows_old X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__type_5. intros X1 X2. intro H. intros.
  elim (rem_335 X1 X2 H);  intros.
Defined.

Remark rem_2667 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> forall X1 X2:term, auto_knows_old (cons X1 X2) -> auto___type_5 (cons X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__type_5. intros X1 X2. intro H. intros.
  elim (rem_255 X1 X2 H);  intros.
  apply (rem_2666 epsilon_mknows_old_m__type_5 X1 X2);  tauto.
Defined.

Remark rem_2668 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> forall X1 X2:term, auto___type_5 (crypt X1 X2) -> auto_knows_old X1 -> auto_knows_old X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__type_5. intros X1 X2. intro H. intros.
  elim (rem_339 X1 X2 H);  intros.
Defined.

Remark rem_2669 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> forall X1 X2:term, auto___type_5 (crypt X1 X2) -> auto___def_37 X1 -> auto___type_5 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__type_5. intros X1 X2. intro H. intros.
  elim (rem_339 X1 X2 H);  intros.
Defined.

Remark rem_2670 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> forall X1 X2:term, auto___type_5 (crypt X1 X2) -> auto___def_23 X1 -> auto___def_24 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__type_5. intros X1 X2. intro H. intros.
  elim (rem_339 X1 X2 H);  intros.
Defined.

Remark rem_2671 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> forall X1 X2:term, auto___type_5 (crypt X1 X2) -> auto___def_10 X1 -> auto___def_11 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__type_5. intros X1 X2. intro H. intros.
  elim (rem_339 X1 X2 H);  intros.
Defined.

Remark rem_2672 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> forall X1 X2:term, auto___type_5 (crypt X1 X2) -> auto___def_41 X1 -> auto___type_7 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__type_5. intros X1 X2. intro H. intros.
  elim (rem_339 X1 X2 H);  intros.
Defined.

Remark rem_2673 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> forall X1 X2:term, auto_knows_old (crypt X1 X2) -> auto___type_5 (crypt X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__type_5. intros X1 X2. intro H. intros.
  elim (rem_565 X1 X2 H);  intros.
  apply (rem_2668 epsilon_mknows_old_m__type_5 X1 X2);  tauto.
  apply (rem_2669 epsilon_mknows_old_m__type_5 X1 X2);  tauto.
  apply (rem_2670 epsilon_mknows_old_m__type_5 X1 X2);  tauto.
  apply (rem_2671 epsilon_mknows_old_m__type_5 X1 X2);  tauto.
  apply (rem_2672 epsilon_mknows_old_m__type_5 X1 X2);  tauto.
Defined.

Remark rem_2674 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> auto___type_5 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__type_5. intro H. intros.
  elim (rem_340 H);  intros.
Defined.

Remark rem_2675 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> auto_knows_old bob -> auto___type_5 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__type_5. intro H. intros.
  elim (rem_568 H);  intros.
  apply (rem_2674 epsilon_mknows_old_m__type_5);  tauto.
Defined.

Remark rem_2676 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> forall X1:term, auto___def_18 X1 -> auto___def_42 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_mknows_old_m__type_5. exact (rem_1007).
Defined.

Remark rem_2677 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_42 X1 -> auto___type_8 X2 -> False. (* Split. *)
Proof.
  intros epsilon_mknows_old_m__type_5. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_42 X1 -> False). clear  epsilon_mknows_old_m__type_5. tauto.
  exact (rem_2676 epsilon_mknows_old_m__type_5 X1).
Defined.

Remark rem_2678 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> forall X1 X2:term, auto___type_5 (key X1 X2) -> auto___def_42 X1 -> auto___type_8 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__type_5. intros X1 X2. intro H. intros.
  elim (rem_328 X1 X2 H);  intros.
  apply (rem_2677 epsilon_mknows_old_m__type_5 X1 X2);  tauto.
Defined.

Remark rem_2679 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> forall X1:term, auto___def_43 X1 -> auto___def_18 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_mknows_old_m__type_5. exact (rem_1050).
Defined.

Remark rem_2680 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_43 X1 -> auto___def_44 X2 -> False. (* Split. *)
Proof.
  intros epsilon_mknows_old_m__type_5. intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_18 X1 -> False). clear  epsilon_mknows_old_m__type_5. tauto.
  exact (rem_2679 epsilon_mknows_old_m__type_5 X1).
Defined.

Remark rem_2681 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> forall X1 X2:term, auto___type_5 (key X1 X2) -> auto___def_43 X1 -> auto___def_44 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__type_5. intros X1 X2. intro H. intros.
  elim (rem_328 X1 X2 H);  intros.
  apply (rem_2680 epsilon_mknows_old_m__type_5 X1 X2);  tauto.
Defined.

Remark rem_2682 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> forall X1 X2:term, auto_knows_old (key X1 X2) -> auto___type_5 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__type_5. intros X1 X2. intro H. intros.
  elim (rem_582 X1 X2 H);  intros.
  apply (rem_2678 epsilon_mknows_old_m__type_5 X1 X2);  tauto.
  apply (rem_2681 epsilon_mknows_old_m__type_5 X1 X2);  tauto.
Defined.

Remark rem_2683 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> auto___type_5 t_old -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__type_5. intro H. intros.
  elim (rem_342 H);  intros.
Defined.

Remark rem_2684 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> auto_knows_old t_old -> auto___type_5 t_old -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__type_5. intro H. intros.
  elim (rem_585 H);  intros.
  apply (rem_2683 epsilon_mknows_old_m__type_5);  tauto.
Defined.

Remark rem_2685 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> auto___type_5 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__type_5. intro H. intros.
  elim (rem_343 H);  intros.
Defined.

Remark rem_2686 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> auto_knows_old alice -> auto___type_5 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__type_5. intro H. intros.
  elim (rem_588 H);  intros.
  apply (rem_2685 epsilon_mknows_old_m__type_5);  tauto.
Defined.

Remark rem_2687 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> auto___type_5 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__type_5. intro H. intros.
  elim (rem_344 H);  intros.
Defined.

Remark rem_2688 : (forall X:term, auto_knows_old X -> auto___type_5 X -> False)
    -> auto_knows_old server -> auto___type_5 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__type_5. intro H. intros.
  elim (rem_591 H);  intros.
  apply (rem_2687 epsilon_mknows_old_m__type_5);  tauto.
Defined.

Remark rem_2689 : forall X1:term, auto_knows_old X1 -> auto___type_5 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_mknows_old_m__type_5 1.
  intro X. case X.
  exact (rem_2686 epsilon_mknows_old_m__type_5 ).
  exact (rem_2675 epsilon_mknows_old_m__type_5 ).
  intros X1 X2;  exact (rem_2667 epsilon_mknows_old_m__type_5 X1 X2).
  intros X1 X2;  exact (rem_2673 epsilon_mknows_old_m__type_5 X1 X2).
  exact (rem_2665 epsilon_mknows_old_m__type_5 ).
  intros X1 X2;  exact (rem_2682 epsilon_mknows_old_m__type_5 X1 X2).
  intros X1 X2. intro H. elim (rem_597 X1 X2 H).
  exact (rem_2663 epsilon_mknows_old_m__type_5 ).
   intro H. elim (rem_596  H).
   intro H. elim (rem_598  H).
  intros X1;  exact (rem_2661 epsilon_mknows_old_m__type_5 X1).
  exact (rem_2688 epsilon_mknows_old_m__type_5 ).
  intros X1 X2. intro H. elim (rem_593 X1 X2 H).
  intros X1 X2. intro H. elim (rem_594 X1 X2 H).
   intro H. elim (rem_595  H).
   intro H. elim (rem_599  H).
  exact (rem_2684 epsilon_mknows_old_m__type_5 ).
Qed.

Remark rem_2690 : forall X1 X2 X3 X4:term, auto___type_5 X4 -> auto___type_6 X1 -> auto_knows_old X4 -> auto_knows_old (cons X1 nil) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto_knows_old (l X2 X3) -> auto___def_40 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_2689 X4)). tauto.
Qed.

Remark rem_2691 : forall X1 X2 X3 X4:term, auto_knows_old X4 -> auto_knows_old (cons X1 nil) -> auto___type_5 X4 -> auto___type_6 X1 -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto_knows_old (l X2 X3) -> auto___def_40 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___type_5 X4 -> auto___type_6 X1 -> auto_knows_old X4 -> auto_knows_old (cons X1 nil) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto_knows_old (l X2 X3) -> auto___def_40 X1 X2 X3 X4). tauto. exact (rem_2690 X1 X2 X3 X4).
Qed.

Remark rem_2692 : forall X1 X2 X3 X4:term, auto___type_5 X4 -> auto___type_6 X1 -> auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto_knows_old (l X2 X3) -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_255 X4 (cons X1 nil) H);  intros.
  apply (rem_2691 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2693 : forall X1 X2 X3 X4:term, auto_knows_old (l X2 X3) -> auto_knows_old (cons X4 (cons X1 nil)) -> auto___type_5 X4 -> auto___type_6 X1 -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto___def_40 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___type_5 X4 -> auto___type_6 X1 -> auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto_knows_old (l X2 X3) -> auto___def_40 X1 X2 X3 X4). tauto. exact (rem_2692 X1 X2 X3 X4).
Qed.

Remark rem_2694 : forall X1 X2 X3 X4:term, auto___type_5 X4 -> auto___type_6 X1 -> auto_knows_old (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_255 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_2693 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2695 : forall X1 X2 X3 X4:term, auto___type_5 X4 -> auto___type_6 X1 -> auto_knows_old (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto_knows_old t_old -> auto___def_40 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_5 X4 -> auto___type_6 X1 -> auto_knows_old (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto___def_40 X1 X2 X3 X4). tauto.
  exact (rem_2694 X1 X2 X3 X4).
Qed.

Remark rem_2696 : forall X1 X2 X3 X4:term, auto_knows_old t_old -> auto_knows_old (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_5 X4 -> auto___type_6 X1 -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto___def_40 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___type_5 X4 -> auto___type_6 X1 -> auto_knows_old (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto_knows_old t_old -> auto___def_40 X1 X2 X3 X4). tauto. exact (rem_2695 X1 X2 X3 X4).
Qed.

Remark rem_2697 : forall X1 X2 X3 X4:term, auto___type_5 X4 -> auto___type_6 X1 -> auto_knows_old (cons t_old (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_255 t_old (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_2696 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2698 : forall X1 X2 X3 X4:term, auto_knows_old (cons t_old (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto___type_5 X4 -> auto___type_6 X1 -> auto___def_40 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___type_5 X4 -> auto___type_6 X1 -> auto_knows_old (cons t_old (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto___def_40 X1 X2 X3 X4). tauto. exact (rem_2697 X1 X2 X3 X4).
Qed.

Remark rem_2699 : forall X1 X2 X3 X4:term, auto___def_31 (cons X4 (cons X1 nil)) -> auto___def_39 (l X2 X3) -> auto___type_5 X4 -> auto___type_5 (key sym (cons X3 (cons server nil))) -> auto___type_6 X1 -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_39 X4 (cons X1 nil) H);  intros.
Qed.

Remark rem_2700 : forall X1 X2 X3 X4:term, auto___def_39 (l X2 X3) -> auto___def_31 (cons X4 (cons X1 nil)) -> auto___type_5 X4 -> auto___type_5 (key sym (cons X3 (cons server nil))) -> auto___type_6 X1 -> auto___def_40 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_31 (cons X4 (cons X1 nil)) -> auto___def_39 (l X2 X3) -> auto___type_5 X4 -> auto___type_5 (key sym (cons X3 (cons server nil))) -> auto___type_6 X1 -> auto___def_40 X1 X2 X3 X4). tauto. exact (rem_2699 X1 X2 X3 X4).
Qed.

Remark rem_2701 : forall X1 X2 X3 X4:term, auto___def_38 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_5 X4 -> auto___type_5 (key sym (cons X3 (cons server nil))) -> auto___type_6 X1 -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_500 (l X2 X3) (cons X4 (cons X1 nil)) H);  intros.
  apply (rem_2700 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2702 : forall X1 X2 X3 X4:term, auto___def_38 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_5 X4 -> auto___type_5 (key sym (cons X3 (cons server nil))) -> auto___type_6 X1 -> auto___type_6 t_old -> auto___def_40 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_38 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_5 X4 -> auto___type_5 (key sym (cons X3 (cons server nil))) -> auto___type_6 X1 -> auto___def_40 X1 X2 X3 X4). tauto.
  exact (rem_2701 X1 X2 X3 X4).
Qed.

Remark rem_2703 : forall X1 X2 X3 X4:term, auto___type_6 t_old -> auto___def_38 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_5 X4 -> auto___type_5 (key sym (cons X3 (cons server nil))) -> auto___type_6 X1 -> auto___def_40 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_38 (cons (l X2 X3) (cons X4 (cons X1 nil))) -> auto___type_5 X4 -> auto___type_5 (key sym (cons X3 (cons server nil))) -> auto___type_6 X1 -> auto___type_6 t_old -> auto___def_40 X1 X2 X3 X4). tauto. exact (rem_2702 X1 X2 X3 X4).
Qed.

Remark rem_2704 : forall X1 X2 X3 X4:term, auto___def_37 (cons t_old (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_5 X4 -> auto___type_5 (key sym (cons X3 (cons server nil))) -> auto___type_6 X1 -> auto___def_40 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_523 t_old (cons (l X2 X3) (cons X4 (cons X1 nil))) H);  intros.
  apply (rem_2703 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2705 : forall X1 X2 X3 X4:term, auto___def_37 (cons t_old (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_5 (key sym (cons X3 (cons server nil))) -> auto___type_5 X4 -> auto___type_6 X1 -> auto___def_40 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_37 (cons t_old (cons (l X2 X3) (cons X4 (cons X1 nil)))) -> auto___type_5 X4 -> auto___type_5 (key sym (cons X3 (cons server nil))) -> auto___type_6 X1 -> auto___def_40 X1 X2 X3 X4). tauto. exact (rem_2704 X1 X2 X3 X4).
Qed.

Remark rem_2706 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2707 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1. intros A1.
  cut (auto_knows_old X1). 2:apply (rem_2706 epsilon_m__type_6_p__type_3 X1);  assumption.
  tauto.
Defined.

Remark rem_2708 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1:term, auto_knows_old X1 -> auto___type_3 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1. intros A1.
  case (rem_2707 epsilon_m__type_6_p__type_3 X1 A1). clear  epsilon_m__type_6_p__type_3 A1. intros. apply trans___type_3_s_1;  tauto.
 clear  epsilon_m__type_6_p__type_3 A1. tauto.
Defined.

Remark rem_2709 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1:term, auto___type_6 (s X1) -> auto___type_3 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1. intro H. intros.
  elim (rem_261 X1 H);  intros.
  apply (rem_2708 epsilon_m__type_6_p__type_3 X1);  tauto.
Defined.

Remark rem_2710 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_6_p__type_3.  tauto.
Defined.

Remark rem_2711 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> auto___type_3 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_p__type_3.  case (rem_2710 epsilon_m__type_6_p__type_3). clear  epsilon_m__type_6_p__type_3. intros. apply trans___type_3_nil_1;  tauto.
 clear  epsilon_m__type_6_p__type_3. tauto.
Defined.

Remark rem_2712 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> auto___type_6 nil -> auto___type_3 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intro H. intros.
  elim (rem_265 H);  intros.
  apply (rem_2711 epsilon_m__type_6_p__type_3);  tauto.
Defined.

Remark rem_2713 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> auto___type_3 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_p__type_3.  case (rem_2710 epsilon_m__type_6_p__type_3). clear  epsilon_m__type_6_p__type_3. intros. apply trans___type_3_i_1;  tauto.
 clear  epsilon_m__type_6_p__type_3. tauto.
Defined.

Remark rem_2714 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> auto___type_6 i -> auto___type_3 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intro H. intros.
  elim (rem_268 H);  intros.
  apply (rem_2713 epsilon_m__type_6_p__type_3);  tauto.
Defined.

Remark rem_2715 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2.
  cut (auto_knows_old X1 -> auto_knows_old X1). tauto. exact (rem_2706 epsilon_m__type_6_p__type_3 X1).
Defined.

Remark rem_2716 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X2:term, auto_knows_old X2 -> auto_knows_old X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2717 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_2716 epsilon_m__type_6_p__type_3 X2).
Defined.

Remark rem_2718 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> (auto_knows_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_2715 epsilon_m__type_6_p__type_3 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_2717 epsilon_m__type_6_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2719 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_3 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2718 epsilon_m__type_6_p__type_3 X1 X2 A1 A2). clear  epsilon_m__type_6_p__type_3 A1 A2. intros. apply trans___type_3_cons_1;  tauto.
 clear  epsilon_m__type_6_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2720 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto___type_6 (cons X1 X2) -> auto___type_3 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2. intro H. intros.
  elim (rem_275 X1 X2 H);  intros.
  apply (rem_2719 epsilon_m__type_6_p__type_3 X1 X2);  tauto.
Defined.

Remark rem_2721 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2718 epsilon_m__type_6_p__type_3 X1 X2 A1 A2). clear  epsilon_m__type_6_p__type_3 A1 A2. intros. apply trans___type_3_crypt_1;  tauto.
 clear  epsilon_m__type_6_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2722 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1:term, auto___def_37 X1 -> auto___def_37 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2723 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> auto___def_37 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2.
  cut (auto___def_37 X1 -> auto___def_37 X1). tauto. exact (rem_2722 epsilon_m__type_6_p__type_3 X1).
Defined.

Remark rem_2724 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X2:term, auto___type_5 X2 -> auto___type_5 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2725 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> auto___type_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2.
  cut (auto___type_5 X2 -> auto___type_5 X2). tauto. exact (rem_2724 epsilon_m__type_6_p__type_3 X2).
Defined.

Remark rem_2726 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> (auto___def_37 X1 /\ auto___type_5 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_37 X1). 2:apply (rem_2723 epsilon_m__type_6_p__type_3 X1 X2);  assumption.
  cut (auto___type_5 X2). 2:apply (rem_2725 epsilon_m__type_6_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2727 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___type_5 X2 -> auto___type_3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2726 epsilon_m__type_6_p__type_3 X1 X2 A1 A2). clear  epsilon_m__type_6_p__type_3 A1 A2. intros. apply trans___type_3_crypt_2;  tauto.
 clear  epsilon_m__type_6_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2728 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1:term, auto___def_23 X1 -> auto___def_23 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2729 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_23 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2.
  cut (auto___def_23 X1 -> auto___def_23 X1). tauto. exact (rem_2728 epsilon_m__type_6_p__type_3 X1).
Defined.

Remark rem_2730 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X2:term, auto___def_24 X2 -> auto___def_24 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2731 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___def_24 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2.
  cut (auto___def_24 X2 -> auto___def_24 X2). tauto. exact (rem_2730 epsilon_m__type_6_p__type_3 X2).
Defined.

Remark rem_2732 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> (auto___def_23 X1 /\ auto___def_24 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_23 X1). 2:apply (rem_2729 epsilon_m__type_6_p__type_3 X1 X2);  assumption.
  cut (auto___def_24 X2). 2:apply (rem_2731 epsilon_m__type_6_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2733 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_24 X2 -> auto___type_3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2732 epsilon_m__type_6_p__type_3 X1 X2 A1 A2). clear  epsilon_m__type_6_p__type_3 A1 A2. intros. apply trans___type_3_crypt_3;  tauto.
 clear  epsilon_m__type_6_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2734 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1:term, auto___def_10 X1 -> auto___def_10 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2735 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_10 X1). tauto. exact (rem_2734 epsilon_m__type_6_p__type_3 X1).
Defined.

Remark rem_2736 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X2:term, auto___def_11 X2 -> auto___def_11 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2737 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2.
  cut (auto___def_11 X2 -> auto___def_11 X2). tauto. exact (rem_2736 epsilon_m__type_6_p__type_3 X2).
Defined.

Remark rem_2738 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> (auto___def_10 X1 /\ auto___def_11 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_10 X1). 2:apply (rem_2735 epsilon_m__type_6_p__type_3 X1 X2);  assumption.
  cut (auto___def_11 X2). 2:apply (rem_2737 epsilon_m__type_6_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2739 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___type_3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2738 epsilon_m__type_6_p__type_3 X1 X2 A1 A2). clear  epsilon_m__type_6_p__type_3 A1 A2. intros. apply trans___type_3_crypt_4;  tauto.
 clear  epsilon_m__type_6_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2740 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1:term, auto___def_41 X1 -> auto___def_41 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2741 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> auto___def_41 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2.
  cut (auto___def_41 X1 -> auto___def_41 X1). tauto. exact (rem_2740 epsilon_m__type_6_p__type_3 X1).
Defined.

Remark rem_2742 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X2:term, auto___type_7 X2 -> auto___type_7 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2743 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> auto___type_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2.
  cut (auto___type_7 X2 -> auto___type_7 X2). tauto. exact (rem_2742 epsilon_m__type_6_p__type_3 X2).
Defined.

Remark rem_2744 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> (auto___def_41 X1 /\ auto___type_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_41 X1). 2:apply (rem_2741 epsilon_m__type_6_p__type_3 X1 X2);  assumption.
  cut (auto___type_7 X2). 2:apply (rem_2743 epsilon_m__type_6_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2745 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___type_7 X2 -> auto___type_3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2744 epsilon_m__type_6_p__type_3 X1 X2 A1 A2). clear  epsilon_m__type_6_p__type_3 A1 A2. intros. apply trans___type_3_crypt_5;  tauto.
 clear  epsilon_m__type_6_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2746 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto___type_6 (crypt X1 X2) -> auto___type_3 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2. intro H. intros.
  elim (rem_437 X1 X2 H);  intros.
  apply (rem_2721 epsilon_m__type_6_p__type_3 X1 X2);  tauto.
  apply (rem_2727 epsilon_m__type_6_p__type_3 X1 X2);  tauto.
  apply (rem_2733 epsilon_m__type_6_p__type_3 X1 X2);  tauto.
  apply (rem_2739 epsilon_m__type_6_p__type_3 X1 X2);  tauto.
  apply (rem_2745 epsilon_m__type_6_p__type_3 X1 X2);  tauto.
Defined.

Remark rem_2747 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> auto___type_3 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_p__type_3.  case (rem_2710 epsilon_m__type_6_p__type_3). clear  epsilon_m__type_6_p__type_3. intros. apply trans___type_3_bob_1;  tauto.
 clear  epsilon_m__type_6_p__type_3. tauto.
Defined.

Remark rem_2748 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> auto___type_6 bob -> auto___type_3 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intro H. intros.
  elim (rem_440 H);  intros.
  apply (rem_2747 epsilon_m__type_6_p__type_3);  tauto.
Defined.

Remark rem_2749 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1:term, auto___def_42 X1 -> auto___def_42 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2750 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___def_42 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2.
  cut (auto___def_42 X1 -> auto___def_42 X1). tauto. exact (rem_2749 epsilon_m__type_6_p__type_3 X1).
Defined.

Remark rem_2751 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2752 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_2751 epsilon_m__type_6_p__type_3 X2).
Defined.

Remark rem_2753 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> (auto___def_42 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_42 X1). 2:apply (rem_2750 epsilon_m__type_6_p__type_3 X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_2752 epsilon_m__type_6_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2754 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_8 X2 -> auto___type_3 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2753 epsilon_m__type_6_p__type_3 X1 X2 A1 A2). clear  epsilon_m__type_6_p__type_3 A1 A2. intros. apply trans___type_3_key_1;  tauto.
 clear  epsilon_m__type_6_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2755 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1:term, auto___def_43 X1 -> auto___def_43 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2756 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_43 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_43 X1). tauto. exact (rem_2755 epsilon_m__type_6_p__type_3 X1).
Defined.

Remark rem_2757 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X2:term, auto___def_44 X2 -> auto___def_44 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2758 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_44 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2.
  cut (auto___def_44 X2 -> auto___def_44 X2). tauto. exact (rem_2757 epsilon_m__type_6_p__type_3 X2).
Defined.

Remark rem_2759 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> (auto___def_43 X1 /\ auto___def_44 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_43 X1). 2:apply (rem_2756 epsilon_m__type_6_p__type_3 X1 X2);  assumption.
  cut (auto___def_44 X2). 2:apply (rem_2758 epsilon_m__type_6_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2760 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___type_3 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_2759 epsilon_m__type_6_p__type_3 X1 X2 A1 A2). clear  epsilon_m__type_6_p__type_3 A1 A2. intros. apply trans___type_3_key_2;  tauto.
 clear  epsilon_m__type_6_p__type_3 A1 A2. tauto.
Defined.

Remark rem_2761 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> forall X1 X2:term, auto___type_6 (key X1 X2) -> auto___type_3 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intros X1 X2. intro H. intros.
  elim (rem_454 X1 X2 H);  intros.
  apply (rem_2754 epsilon_m__type_6_p__type_3 X1 X2);  tauto.
  apply (rem_2760 epsilon_m__type_6_p__type_3 X1 X2);  tauto.
Defined.

Remark rem_2762 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> auto___type_3 t_old. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_p__type_3.  case (rem_2710 epsilon_m__type_6_p__type_3). clear  epsilon_m__type_6_p__type_3. intros. apply trans___type_3_t_old_1;  tauto.
 clear  epsilon_m__type_6_p__type_3. tauto.
Defined.

Remark rem_2763 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> auto___type_6 t_old -> auto___type_3 t_old. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intro H. intros.
  elim (rem_457 H);  intros.
  apply (rem_2762 epsilon_m__type_6_p__type_3);  tauto.
Defined.

Remark rem_2764 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> auto___type_3 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_p__type_3.  case (rem_2710 epsilon_m__type_6_p__type_3). clear  epsilon_m__type_6_p__type_3. intros. apply trans___type_3_alice_1;  tauto.
 clear  epsilon_m__type_6_p__type_3. tauto.
Defined.

Remark rem_2765 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> auto___type_6 alice -> auto___type_3 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intro H. intros.
  elim (rem_460 H);  intros.
  apply (rem_2764 epsilon_m__type_6_p__type_3);  tauto.
Defined.

Remark rem_2766 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> auto___type_3 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_p__type_3.  case (rem_2710 epsilon_m__type_6_p__type_3). clear  epsilon_m__type_6_p__type_3. intros. apply trans___type_3_server_1;  tauto.
 clear  epsilon_m__type_6_p__type_3. tauto.
Defined.

Remark rem_2767 : (forall X:term, auto___type_6 X -> auto___type_3 X)
    -> auto___type_6 server -> auto___type_3 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_p__type_3. intro H. intros.
  elim (rem_463 H);  intros.
  apply (rem_2766 epsilon_m__type_6_p__type_3);  tauto.
Defined.

Remark rem_2768 : forall X1:term, auto___type_6 X1 -> auto___type_3 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_6_p__type_3 1.
  intro X. case X.
  exact (rem_2765 epsilon_m__type_6_p__type_3 ).
  exact (rem_2748 epsilon_m__type_6_p__type_3 ).
  intros X1 X2;  exact (rem_2720 epsilon_m__type_6_p__type_3 X1 X2).
  intros X1 X2;  exact (rem_2746 epsilon_m__type_6_p__type_3 X1 X2).
  exact (rem_2714 epsilon_m__type_6_p__type_3 ).
  intros X1 X2;  exact (rem_2761 epsilon_m__type_6_p__type_3 X1 X2).
  intros X1 X2. intro H