% h1 example: the simplified Kerberos protocol.
%   Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
%   This file is part of h1.
%
%   h1 is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2, or (at your option)
%   any later version.
%
%   h1 is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with h1; see the file COPYING.  If not, write to
%   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

#define KNOWS PHASE(knows)
#define T PHASE(t)
#define SESSION PHASE(session)
#define ALICE_KEY PHASE(alice_key)
#define BOB_KEY PHASE(bob_key)

cnf(PHASE(intruder_knows_nil),axiom,
  (KNOWS(nil))).
cnf(PHASE(intruder_can_take_first_components),axiom,
  (~KNOWS(cons(M1,M2)) | KNOWS(M1))).
cnf(PHASE(intruder_can_take_second_components),axiom,
  (~KNOWS(cons(M1,M2)) | KNOWS(M2))).
cnf(PHASE(intruder_can_build_pairs),axiom,
  (~KNOWS(M2) | ~KNOWS(M1) | KNOWS(cons(M1,M2)))).
cnf(PHASE(intruder_can_encrypt),axiom,
  (~KNOWS(K) | ~KNOWS(M) | KNOWS(crypt(M,K)))).
cnf(PHASE(intruder_can_decrypt_if_has_private_key),axiom,
  (~KNOWS(key(prv,K)) | ~KNOWS(crypt(M,key(pub,K))) | KNOWS(M))).
cnf(PHASE(intruder_can_decrypt_if_has_public_key),axiom,
  (~KNOWS(key(pub,K)) | ~KNOWS(crypt(M,key(prv,K))) | KNOWS(M))).
cnf(PHASE(intruder_can_decrypt_if_has_symmetric_key),axiom,
  (~KNOWS(key(sym,X)) | ~KNOWS(crypt(M,key(sym,X))) | KNOWS(M))).
cnf(PHASE(intruder_can_compute_successors),axiom,
  (~KNOWS(M) | KNOWS(s(M)))).
cnf(PHASE(intruder_can_compute_predecessors),axiom,
  (~KNOWS(s(M)) | KNOWS(M))).

cnf(PHASE(intruder_knows_old_timestamp),axiom,
  (KNOWS(t_old))).
cnf(PHASE(intruder_knows_current_timestamp),axiom,
  (KNOWS(t_current))).

%
% Ajout des clauses du protocole
%
%
% 1. A -> S : A,B
cnf(PHASE(alice_sends_message_1_to_server),axiom,
  (~agent(A) | ~agent (B)
  | KNOWS(cons(A,cons(B,nil))))).
% 2. S -> A : {Ts, L, Kab, B, {Ts, L, Kab, A}_Kbs}_Kas
%   Ts is S's timestamp; this is encoded as T(A,B);
%   we assume there is one timestamp per phase.
%   For security, we do not assume that Ts is different from Ta, A's timestamp.
%   We use the length l to hold A and B's identity for further checking by A.
cnf(PHASE(server_answers_A_with_encrypted_packet),axiom,
  (~KNOWS(cons(A,cons(B,nil)))
    | KNOWS(crypt(cons(T,
                  cons(l(A,B),
                  cons(key(sym,SESSION(A,B)),
		  cons(B,
                  cons(crypt(cons(T,
		             cons(l(A,B),
		             cons(key(sym,SESSION(A,B)),
			     cons(A,nil)))),
                             key(sym,cons(B,cons(server,nil)))),
                  nil))))),
               key(sym,cons(A,cons(server,nil))))))).
% 3. A -> B : {Ts, L, Kab, A}_Kbs, {A, Ta}_Kab
cnf(PHASE(alice_gets_server_message_and_forwards_submessage_to_bob),axiom,
  (~KNOWS(crypt(cons(T,
                cons(l(A,B),
		cons(Kab,
		cons(B,
		cons(Msg,nil))))),
		key(sym,cons(A,cons(server,nil)))))
  | KNOWS(cons(Msg,cons(crypt(cons(A,cons(T,nil)),
                        Kab),
			nil))))).
% 4. B -> A : {Ta+1}_Kab
cnf(PHASE(agent_B_gets_forwarded_submessage_and_sends_confirmation_challenge),axiom,
  (~KNOWS(cons(crypt(cons(T,
                     cons(l(X,B), % cannot use identity X to check that it's really A
		     cons(Kab,
		     cons(A,nil)))),
		     key(sym,cons(B,cons(server,nil)))),
          cons(crypt(cons(A,cons(T,nil)),
	             Kab),
	  nil)))
   | KNOWS(crypt(s(T),Kab)))).

cnf(PHASE(intruder_knows_all_agents),axiom,
  (~agent(X) | KNOWS(X))).
cnf(PHASE(intruder_knows_every_public_key),axiom,
  (KNOWS(key(pub,X)))).
cnf(PHASE(intruder_knows_own_private_key),axiom,
  (KNOWS(key(prv,i)))).
cnf(PHASE(intruder_knows_timestamp),axiom,
  (KNOWS(T))).

   
cnf(PHASE(define_alice_key),axiom,
  (~KNOWS(crypt(cons(T,
                cons(l(A,B),
		cons(Kab,
		cons(B,
		cons(Msg,nil))))),
		key(sym,cons(A,cons(server,nil))))) % from input to 3.
  | ~KNOWS(crypt(s(T),Kab)) % from output of 4.
  | ALICE_KEY(A,Kab))).
cnf(PHASE(define_bob_key),axiom,
   (~KNOWS(cons(crypt(cons(T,
                     cons(l(X,B), % cannot use identity X to check that it's really A
		     cons(Kab,
		     cons(A,nil)))),
		     key(sym,cons(B,cons(server,nil)))),
          cons(crypt(cons(A,cons(T,nil)),
	             Kab),
	  nil))) % from input to 4.
   | BOB_KEY(B,Kab))).

#undef KNOWS
#undef T
#undef SESSION
#undef ALICE_KEY
#undef BOB_KEY
