(* Lexer for systems of linear equations and inequations.
   Copyright (C) 2003 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.

   This file is part of h1.

   h1 is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   h1 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with h1; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*)
%{
open "linear_h";

val linear_value = ref (linearnone ());

%}

SPACE [\ \t\f\n\r]+
DIG [0-9]+
CAPITAL [A-Z]
SMALL [a-z]
LETTER ({CAPITAL}|{SMALL})
ALPHA [A-Za-z0-9\'\_]
SYMB [\!\%\&\$\#\+\-\/\:\<\=\>\?\@\\\~\'\^\|\*\`]

%x COMMENT

%%

{SPACE}	continue
"%".*\n	continue
"/*"	{ glex_begin(yyd, COMMENT); continue }
<COMMENT>{
  [^*]*	{ continue (* eat anything that's not a '*' *) }
  "*"+[^*/]*  { continue (* eat up '*'s not followed by '/'s *) }
  "*"+"/"       { glex_begin (yyd, INITIAL); continue }
  <<EOF>>	{ glex_begin (yyd, 0); glex_flush (yyd, glex_current_buffer yyd);
                  raise LinearUnterminatedCommentEvt }
}

\(	return kw_open_paren
\)	return kw_close_paren
\+	return kw_plus
-	return kw_minus
\*	return kw_times
\,	return kw_comma
"="	return kw_equal
"<="	return kw_le
"<"	return kw_lt
">="	return kw_ge
">"	return kw_gt
"!="	return kw_ne

{DIG}	{ linear_value := linearint (zsbastoz (10, [ord c - 48 | c in list explode (glex_text (yyd))]));
          return integer_constant }

\_*{SMALL}{ALPHA}*	{ linear_value := linearstring (glex_text yyd); return VAR }
\_*{CAPITAL}{ALPHA}*	{ linear_value := linearstring (glex_text yyd); return VAR }
.	{ #put stderr "Unrecognized character: ";
          #put stderr (glex_text yyd);
          #put stderr "\n"; continue }

%%
