(* Lexer for rewrites as given to tptpmorph.
   Copyright (C) 2003 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.

   This file is part of h1.

   h1 is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   h1 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with h1; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*)
%{
open "morph_h";

val morph_value = ref (morphnone ());

%}

SPACE [\ \t\f\n\r]+
DIG [0-9]+
CAPITAL [A-Z]
SMALL [a-z]
LETTER ({CAPITAL}|{SMALL})
ALPHA [A-Za-z0-9\'\_]
SYMB [\!\%\&\$\#\+\-\/\:\<\=\>\?\@\\\~\'\^\|\*\`]

%%

{SPACE}	continue
\(	return kw_open_paren
\)	return kw_close_paren
\,	return kw_comma
=	return kw_equal
\_*{SMALL}{ALPHA}*	{ morph_value := morphstring (glex_text yyd); return identifier }
\_*{DIG}		{ morph_value := morphstring (glex_text yyd); return identifier }
\_*{CAPITAL}{ALPHA}*	{ morph_value := morphstring (glex_text yyd); return VAR }
\#q{DIG}*		{ morph_value := morphstring (glex_text yyd); return identifier }
.	{ #put stderr "Unrecognized character: ";
          #put stderr (glex_text yyd);
          #put stderr "\n"; continue }

%%
