(* Parser for rewrites as given to tptpmorph.
   Copyright (C) 2003 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.

   This file is part of h1.

   h1 is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   h1 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with h1; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*)

%{
  %}

%header {
open "morphdef_h";
  %}

%union {
  morphnone of unit
| morphrewrite of morph_rewrite
| morphpattern of morph_pattern
| morphterm of string term
| morphtermlist of string term list
| morphstring of string
| morphstringlist of string list
}

%start rewrite

%type <morphrewrite> rewrite
%type <morphpattern> pattern
%type <morphstringlist> var_list non_empty_var_list
%type <morphterm> atom term
%type <morphtermlist> term_list

%token <morphstring> identifier
%token kw_open_paren kw_close_paren kw_comma kw_equal
%token <morphstring> VAR
%%

rewrite : pattern kw_equal term { $$ ($1, $3) }
;

pattern : identifier var_list { $$ ($1, $2) }
;

var_list : { $$ nil }
| kw_open_paren kw_close_paren { $$ nil}
| kw_open_paren non_empty_var_list kw_close_paren { let val l = rev $2
						    in
						       $$ l
						    end }
;

non_empty_var_list : VAR { $$ [$1] }
| non_empty_var_list kw_comma VAR { $$ ($3 :: $1) }
;

atom : identifier kw_open_paren term_list kw_close_paren { $$ ($1 $ (rev $3)) }
| identifier { $$ ($1 $ nil) }
;

term_list : term { $$ [$1] }
| term_list kw_comma term { $$ ($3 :: $1) }
;

term : VAR { $$ (V $1) }
| atom { $$ $1 }
;

