(* Applying morphisms to gclauses.
   Copyright (C) 2003 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.

   This file is part of h1.

   h1 is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   h1 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with h1; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*)

open "morphrewrite_h";

fun apply_morphism_term m =
    let fun apply (t as V _) = t
	  | apply (f $ l) =
	    if f inset m
		then let val (xl, u) = ?m f
			 val sigma = {x => t
				     || x in list xl and t in list l}
			     handle ParSweep =>
			     raise MorphismBadArityEvt (f, len xl, len l)
		     in
			 tsubst sigma u
		     end
	    else f $ [apply t
		     | t in list l]
    in
	apply
    end;

fun apply_morphism_gclause m =
    let val apply_term = apply_morphism_term m
    in
	fn (GCLAUSE (neg, pos)) =>
	   GCLAUSE ([apply_term t | t in list neg],
		      [apply_term t | t in list pos])
    end;
