(* ne predicate dissection.
   Copyright (C) 2003 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.

   This file is part of h1.

   h1 is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   h1 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with h1; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*)

open "ne_h";

local
    val nfa_ne = re_make_nfa [(re_parse "^#ne\\(([a-zA-Z0-9'_ \t\f\n\^M&]*)\\)",
			       fn (s,a) => re_subst (s,a,1))]
    val nfa_pred = re_make_nfa [(re_parse "([a-zA-Z0-9'_]+)",
				 fn (s,a) => (substr (s,isub(a,1),size s),
					      re_subst (s,a,1)))]
in
    (* ne_of "#ne(P & Q)" returns {P, Q}, for instance. *)
    fun ne_of ne =
	let fun ne_dissect s =
		case nfa_run (nfa_pred, s) of
		    SOME (rest, P) =>
		    ne_dissect rest U {P}
		  | _ => {}
	in
	    case nfa_run (nfa_ne, ne) of
		SOME s => ne_dissect s
	      | _ => raise NeOfEvt
	end
    fun matches_ne P =
	case nfa_run (nfa_ne, P) of
	    SOME _ => true
	  | _ => false
end;
