% h1 example: the Needham-Schroeder asymmetric key protocol.
%   Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
%   This file is part of h1.
%
%   h1 is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2, or (at your option)
%   any later version.
%
%   h1 is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with h1; see the file COPYING.  If not, write to
%   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

#define KNOWS PHASE(knows)
#define NONCEA PHASE(noncea)
#define NONCEB PHASE(nonceb)
#define SESSION PHASE(session)
#define ALICE_MSG PHASE(alice_msg)
#define BOB_MSG PHASE(bob_msg)

cnf(PHASE(intruder_knows_nil),axiom,
  (KNOWS(nil))).
cnf(PHASE(intruder_can_take_first_components),axiom,
  (~KNOWS(cons(M1,M2)) | KNOWS(M1))).
cnf(PHASE(intruder_can_take_second_components),axiom,
  (~KNOWS(cons(M1,M2)) | KNOWS(M2))).
cnf(PHASE(intruder_can_build_pairs),axiom,
  (~KNOWS(M2) | ~KNOWS(M1) | KNOWS(cons(M1,M2)))).
cnf(PHASE(intruder_can_encrypt),axiom,
  (~KNOWS(K) | ~KNOWS(M) | KNOWS(crypt(M,K)))).
cnf(PHASE(intruder_can_decrypt_if_has_private_key),axiom,
  (~KNOWS(key(prv,K)) | ~KNOWS(crypt(M,key(pub,K))) | KNOWS(M))).
cnf(PHASE(intruder_can_decrypt_if_has_public_key),axiom,
  (~KNOWS(key(pub,K)) | ~KNOWS(crypt(M,key(prv,K))) | KNOWS(M))).
cnf(PHASE(intruder_can_decrypt_if_has_symmetric_key),axiom,
  (~KNOWS(key(sym,X)) | ~KNOWS(crypt(M,key(sym,X))) | KNOWS(M))).
cnf(PHASE(intruder_can_compute_successors),axiom,
  (~KNOWS(M) | KNOWS(s(M)))).
cnf(PHASE(intruder_can_compute_predecessors),axiom,
  (~KNOWS(s(M)) | KNOWS(M))).

%
% Ajout des clauses du protocole
%
%
   % 1. A -> B : {Na, A}_KPb
cnf(PHASE(alice_sends_msg_to_bob),axiom,
  (~agent(A)
  | ~agent(B)
  | KNOWS(crypt(cons(NONCEA(A,B),cons(A,nil)),
                key(pub,B))))).
   % 2. B -> A : {Na, Nb, B}_KPa
cnf(PHASE(bob_answers_alice_with_own_msg),axiom,
    (~agent(B)
    | ~KNOWS(crypt(cons(Na,cons(A,nil)),
                   key(pub,B))) % from msg 3
    | KNOWS(crypt(cons(Na,cons(NONCEB(A,B,Na),cons(B,nil))),
                  key(pub,A))))).
   % 3. A -> B : {Nb}_KPb
cnf(PHASE(alice_confirms_to_bob),axiom,
    (~KNOWS(crypt(cons(NONCEA(A,B),cons(Nb,cons(B,nil))),
                   key(pub,A))) % from msg 6
    | KNOWS(crypt(Nb,key(pub,B))))).

cnf(PHASE(intruder_knows_all_agents),axiom,
  (~agent(X) | KNOWS(X))).
cnf(PHASE(intruder_knows_every_public_key),axiom,
  (KNOWS(key(pub,X)))).
cnf(PHASE(intruder_knows_own_private_key),axiom,
  (KNOWS(key(prv,i)))).

#undef KNOWS
#undef NONCEA
#undef NONCEB
#undef SESSION
#undef ALICE_KEY
#undef BOB_KEY
