

% h1 example: the Needham-Schroeder-Lowe asymmetric key protocol.
% Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
% This file is part of h1.
%
% h1 is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2, or (at your option)
% any later version.
%
% h1 is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with h1; see the file COPYING. If not, write to
% the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

% run 'cpp -P nsl7bis.timed.p >nsl7bis.p'

cnf(alice_agent,axiom,
    (agent(alice))).
cnf(bob_agent,axiom,
    (agent(bob))).
cnf(server_agent,axiom,
    (agent(server))).
cnf(intruder_agent,axiom,
    (agent(i))).

cnf(alice_has_pub_key,axiom,
    (has_pub_key(alice,cons(key(pub,alice),cons(alice,nil))))).
cnf(bob_has_pub_key,axiom,
    (has_pub_key(bob,cons(key(pub,bob),cons(bob,nil))))).
cnf(server_has_pub_key,axiom,
    (has_pub_key(server,cons(key(pub,server),cons(server,nil))))).
cnf(i_has_pub_key,axiom,
    (has_pub_key(i,cons(key(pub,i),cons(i,nil))))).
% h1 example: the Needham-Schroeder asymmetric key protocol.
% Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
% This file is part of h1.
%
% h1 is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2, or (at your option)
% any later version.
%
% h1 is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with h1; see the file COPYING. If not, write to
% the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
cnf(intruder_knows_nil_old,axiom,
  (knows_old(nil))).
cnf(intruder_can_take_first_components_old,axiom,
  (~knows_old(cons(M1,M2)) | knows_old(M1))).
cnf(intruder_can_take_second_components_old,axiom,
  (~knows_old(cons(M1,M2)) | knows_old(M2))).
cnf(intruder_can_build_pairs_old,axiom,
  (~knows_old(M2) | ~knows_old(M1) | knows_old(cons(M1,M2)))).
cnf(intruder_can_encrypt_old,axiom,
  (~knows_old(K) | ~knows_old(M) | knows_old(crypt(M,K)))).
cnf(intruder_can_decrypt_if_has_private_key_old,axiom,
  (~knows_old(key(prv,K)) | ~knows_old(crypt(M,key(pub,K))) | knows_old(M))).
cnf(intruder_can_decrypt_if_has_public_key_old,axiom,
  (~knows_old(key(pub,K)) | ~knows_old(crypt(M,key(prv,K))) | knows_old(M))).
cnf(intruder_can_decrypt_if_has_symmetric_key_old,axiom,
  (~knows_old(key(sym,X)) | ~knows_old(crypt(M,key(sym,X))) | knows_old(M))).
cnf(intruder_can_compute_successors_old,axiom,
  (~knows_old(M) | knows_old(s(M)))).
cnf(intruder_can_compute_predecessors_old,axiom,
  (~knows_old(s(M)) | knows_old(M))).
%
% Ajout des clauses du protocole
%
%
   % 1. A -> S : A, B
cnf(alice_asks_server_old,axiom,
  (~agent(A) | ~agent (B)
    | knows_old(cons(A,cons(B,nil))))).
   % 2. S -> A : {KPb, B}_KSs
cnf(server_gives_bobs_public_key_to_alice_old,axiom,
  (~knows_old(cons(A,cons(B,nil)))
  | ~has_pub_key(B,KbBpair)
  | knows_old(crypt(KbBpair,
                key(prv,server))))).
   % 3. A -> B : {Na, A}_KPb
cnf(alice_sends_msg_to_bob_old,axiom,
  (~knows_old(crypt(cons(KPb,cons(B,nil)),
                key(prv,server)))
  | ~agent(A)
  | knows_old(crypt(cons(noncea_old(A,B,KPb),cons(A,nil)),
                KPb)))).
% Messages 4 and 5 are in fact redundant with 1 and 2, from a logical point of view.
   % 4. B -> S : B, A
cnf(bob_asks_server_old,axiom,
    (~agent(A) | ~agent(B)
    | knows_old(cons(B,cons(A,nil))))).
   % 5. S -> B : {KPa, A}_KSs
cnf(server_gives_alices_public_key_to_bob_old,axiom,
    (~knows_old(cons(B,cons(A,nil)))
    | ~has_pub_key(A,KaApair)
    | knows_old(crypt(KaApair,
                  key(prv,server))))).
   % 6. B -> A : {Na, Nb, B}_KPa
 % first ~knows_old(...) from msg 5, second from msg 3
cnf(bob_answers_alice_with_own_msg_old,axiom, (~knows_old(crypt(cons(KPa,cons(A,nil)), key(prv,server))) | ~agent(alice) | ~knows_old(crypt(cons(Na,cons(A,nil)), key(pub,alice))) | knows_old(crypt(cons(Na,cons(nonceb_old(A,alice,KPa,Na),cons(alice,nil))), KPa)))).
cnf(bob_answers_alice_with_own_msg_old,axiom, (~knows_old(crypt(cons(KPa,cons(A,nil)), key(prv,server))) | ~agent(bob) | ~knows_old(crypt(cons(Na,cons(A,nil)), key(pub,bob))) | knows_old(crypt(cons(Na,cons(nonceb_old(A,bob,KPa,Na),cons(bob,nil))), KPa)))).
cnf(bob_answers_alice_with_own_msg_old,axiom, (~knows_old(crypt(cons(KPa,cons(A,nil)), key(prv,server))) | ~agent(server) | ~knows_old(crypt(cons(Na,cons(A,nil)), key(pub,server))) | knows_old(crypt(cons(Na,cons(nonceb_old(A,server,KPa,Na),cons(server,nil))), KPa)))).
   % 7. A -> B : {Nb}_KPb
cnf(alice_confirms_to_bob_old,axiom,
    (~knows_old(crypt(cons(KPb,cons(B,nil)),
                  key(prv,server))) % from msg 2
    | ~knows_old(crypt(cons(noncea_old(A,B,KPb),cons(Nb,cons(B,nil))),
                   key(pub,A))) % from msg 6
    | knows_old(crypt(Nb,KPb)))).
cnf(intruder_knows_all_agents_old,axiom,
  (~agent(X) | knows_old(X))).
cnf(intruder_knows_every_public_key_old,axiom,
  (knows_old(key(pub,X)))).
cnf(intruder_knows_own_private_key_old,axiom,
  (knows_old(key(prv,i)))).
cnf(intruder_remembers,axiom,
   (~knows_old(M) | knows_current(M))).
cnf(intruder_knows_all_previous_session_keys,axiom,
  (knows_current(key(sym,session_old(A,B,Na))))).
cnf(intruder_knows_all_previous_noncea,axiom,
    (knows_current(noncea_old(A,B,KPb)))).
cnf(intruder_knows_all_previous_nonceb,axiom,
    (knows_current(nonceb_old(A,B,KPa,Na)))).
% h1 example: the Needham-Schroeder asymmetric key protocol.
% Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
% This file is part of h1.
%
% h1 is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2, or (at your option)
% any later version.
%
% h1 is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with h1; see the file COPYING. If not, write to
% the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
cnf(intruder_knows_nil_current,axiom,
  (knows_current(nil))).
cnf(intruder_can_take_first_components_current,axiom,
  (~knows_current(cons(M1,M2)) | knows_current(M1))).
cnf(intruder_can_take_second_components_current,axiom,
  (~knows_current(cons(M1,M2)) | knows_current(M2))).
cnf(intruder_can_build_pairs_current,axiom,
  (~knows_current(M2) | ~knows_current(M1) | knows_current(cons(M1,M2)))).
cnf(intruder_can_encrypt_current,axiom,
  (~knows_current(K) | ~knows_current(M) | knows_current(crypt(M,K)))).
cnf(intruder_can_decrypt_if_has_private_key_current,axiom,
  (~knows_current(key(prv,K)) | ~knows_current(crypt(M,key(pub,K))) | knows_current(M))).
cnf(intruder_can_decrypt_if_has_public_key_current,axiom,
  (~knows_current(key(pub,K)) | ~knows_current(crypt(M,key(prv,K))) | knows_current(M))).
cnf(intruder_can_decrypt_if_has_symmetric_key_current,axiom,
  (~knows_current(key(sym,X)) | ~knows_current(crypt(M,key(sym,X))) | knows_current(M))).
cnf(intruder_can_compute_successors_current,axiom,
  (~knows_current(M) | knows_current(s(M)))).
cnf(intruder_can_compute_predecessors_current,axiom,
  (~knows_current(s(M)) | knows_current(M))).
%
% Ajout des clauses du protocole
%
%
   % 1. A -> S : A, B
cnf(alice_asks_server_current,axiom,
  (~agent(A) | ~agent (B)
    | knows_current(cons(A,cons(B,nil))))).
   % 2. S -> A : {KPb, B}_KSs
cnf(server_gives_bobs_public_key_to_alice_current,axiom,
  (~knows_current(cons(A,cons(B,nil)))
  | ~has_pub_key(B,KbBpair)
  | knows_current(crypt(KbBpair,
                key(prv,server))))).
   % 3. A -> B : {Na, A}_KPb
cnf(alice_sends_msg_to_bob_current,axiom,
  (~knows_current(crypt(cons(KPb,cons(B,nil)),
                key(prv,server)))
  | ~agent(A)
  | knows_current(crypt(cons(noncea_current(A,B,KPb),cons(A,nil)),
                KPb)))).
% Messages 4 and 5 are in fact redundant with 1 and 2, from a logical point of view.
   % 4. B -> S : B, A
cnf(bob_asks_server_current,axiom,
    (~agent(A) | ~agent(B)
    | knows_current(cons(B,cons(A,nil))))).
   % 5. S -> B : {KPa, A}_KSs
cnf(server_gives_alices_public_key_to_bob_current,axiom,
    (~knows_current(cons(B,cons(A,nil)))
    | ~has_pub_key(A,KaApair)
    | knows_current(crypt(KaApair,
                  key(prv,server))))).
   % 6. B -> A : {Na, Nb, B}_KPa
 % first ~knows_current(...) from msg 5, second from msg 3
cnf(bob_answers_alice_with_own_msg_current,axiom, (~knows_current(crypt(cons(KPa,cons(A,nil)), key(prv,server))) | ~agent(alice) | ~knows_current(crypt(cons(Na,cons(A,nil)), key(pub,alice))) | knows_current(crypt(cons(Na,cons(nonceb_current(A,alice,KPa,Na),cons(alice,nil))), KPa)))).
cnf(bob_answers_alice_with_own_msg_current,axiom, (~knows_current(crypt(cons(KPa,cons(A,nil)), key(prv,server))) | ~agent(bob) | ~knows_current(crypt(cons(Na,cons(A,nil)), key(pub,bob))) | knows_current(crypt(cons(Na,cons(nonceb_current(A,bob,KPa,Na),cons(bob,nil))), KPa)))).
cnf(bob_answers_alice_with_own_msg_current,axiom, (~knows_current(crypt(cons(KPa,cons(A,nil)), key(prv,server))) | ~agent(server) | ~knows_current(crypt(cons(Na,cons(A,nil)), key(pub,server))) | knows_current(crypt(cons(Na,cons(nonceb_current(A,server,KPa,Na),cons(server,nil))), KPa)))).
   % 7. A -> B : {Nb}_KPb
cnf(alice_confirms_to_bob_current,axiom,
    (~knows_current(crypt(cons(KPb,cons(B,nil)),
                  key(prv,server))) % from msg 2
    | ~knows_current(crypt(cons(noncea_current(A,B,KPb),cons(Nb,cons(B,nil))),
                   key(pub,A))) % from msg 6
    | knows_current(crypt(Nb,KPb)))).
cnf(intruder_knows_all_agents_current,axiom,
  (~agent(X) | knows_current(X))).
cnf(intruder_knows_every_public_key_current,axiom,
  (knows_current(key(pub,X)))).
cnf(intruder_knows_own_private_key_current,axiom,
  (knows_current(key(prv,i)))).
cnf(intruder_knows_alice_msg,axiom,
    (~knows_current(noncea_current(alice,bob,KPb)))).
cnf(intruder_knows_bob_msg,axiom,
    (~knows_current(nonceb_current(alice,bob,KPa,Na)))).
