(* [sigd] Signature definition. *)

Inductive term : Set :=
    alice : term
  | bob : term
  | cons : term -> term -> term
  | crypt : term -> term -> term
  | i : term
  | intruder : term
  | key : term -> term -> term
  | nil : term
  | noncea_current : term -> term -> term -> term
  | noncea_old : term -> term -> term -> term
  | nonceb_current : term -> term -> term -> term -> term
  | nonceb_old : term -> term -> term -> term -> term
  | prv : term
  | pub : term
  | s : term -> term
  | server : term
  | session_old : term -> term -> term -> term
  | sym : term
.

(* [modd] Model definition. *)

Inductive auto___type_9 : term -> Prop :=
    trans___type_9_1 : forall X:term, auto___type_9 X
with auto___def_42 : term -> Prop :=
    trans___def_42_1 : forall X:term, auto___def_42 X
with auto___def_13 : term -> Prop :=
    trans___def_13_1 : forall X:term, auto___def_13 X
with auto_has_pub_key : term -> term -> Prop :=
    trans_has_pub_key_1 : forall X1 X2:term, auto___def_4 X1 -> auto___def_5 X2 -> auto_has_pub_key X1 X2
  | trans_has_pub_key_2 : forall X1 X2:term, auto___def_8 X1 -> auto___def_9 X2 -> auto_has_pub_key X1 X2
  | trans_has_pub_key_3 : forall X1 X2:term, auto___def_6 X1 -> auto___def_7 X2 -> auto_has_pub_key X1 X2
  | trans_has_pub_key_4 : forall X1 X2:term, auto___def_1 X1 -> auto___def_2 X2 -> auto_has_pub_key X1 X2
with auto___def_6 : term -> Prop :=
    trans___def_6_key_1 : forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___def_6 (key X1 X2)
with auto___def_11 : term -> Prop :=
    trans___def_11_i_1 : auto___def_11 i
with auto___def_17 : term -> Prop :=
    trans___def_17_nil_1 : auto___def_17 nil
with auto_knows_old : term -> Prop :=
    trans_knows_old_s_1 : forall X1:term, auto_knows_old X1 -> auto_knows_old (s X1)
  | trans_knows_old_nil_1 : auto_knows_old nil
  | trans_knows_old_i_1 : auto_knows_old i
  | trans_knows_old_cons_1 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old (cons X1 X2)
  | trans_knows_old_crypt_1 : forall X1 X2:term, auto___def_32 X1 -> auto___type_2 X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_crypt_2 : forall X1 X2:term, auto___def_25 X1 -> auto___type_4 X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_crypt_3 : forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_crypt_4 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_crypt_5 : forall X1 X2:term, auto___def_30 X1 -> auto___type_6 X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_key_1 : forall X1 X2:term, auto___def_23 X1 -> auto___def_36 X2 -> auto_knows_old (key X1 X2)
  | trans_knows_old_key_2 : forall X1 X2:term, auto___def_3 X1 -> auto___type_9 X2 -> auto_knows_old (key X1 X2)
  | trans_knows_old_bob_1 : auto_knows_old bob
  | trans_knows_old_alice_1 : auto_knows_old alice
  | trans_knows_old_server_1 : auto_knows_old server
with auto___type_10 : term -> Prop :=
    trans___type_10_key_1 : forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___type_10 (key X1 X2)
  | trans___type_10_key_2 : forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___type_10 (key X1 X2)
  | trans___type_10_key_3 : forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___type_10 (key X1 X2)
with auto___def_29 : term -> term -> term -> term -> Prop :=
    trans___def_29_1 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto_agent X1 -> auto___def_5 X2 -> auto_agent X2 -> auto___def_26 X3 -> auto___type_2 X4 -> auto___def_29 X1 X2 X3 X4
  | trans___def_29_2 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto___type_9 X2 -> auto_agent X2 -> auto_knows_old X3 -> auto___type_2 X4 -> auto___def_29 X1 X2 X3 X4
  | trans___def_29_3 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto_agent X1 -> auto___def_7 X2 -> auto_agent X2 -> auto___def_26 X3 -> auto___type_2 X4 -> auto___def_29 X1 X2 X3 X4
  | trans___def_29_4 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto_agent X1 -> auto_agent X2 -> auto___def_2 X2 -> auto___def_26 X3 -> auto___type_2 X4 -> auto___def_29 X1 X2 X3 X4
with auto___def_10 : term -> term -> Prop :=
    trans___def_10_1 : forall X1 X2:term, auto___def_7 X1 -> auto___def_32 X2 -> auto___def_10 X1 X2
  | trans___def_10_2 : forall X1 X2:term, auto___def_5 X1 -> auto___def_32 X2 -> auto___def_10 X1 X2
  | trans___def_10_3 : forall X1 X2:term, auto___def_2 X1 -> auto___def_30 X2 -> auto___def_10 X1 X2
  | trans___def_10_4 : forall X1 X2:term, auto___def_2 X1 -> auto___def_25 X2 -> auto___def_10 X1 X2
  | trans___def_10_5 : forall X1 X2:term, auto___type_9 X1 -> auto_knows_old X2 -> auto___def_10 X1 X2
  | trans___def_10_6 : forall X1 X2:term, auto___def_5 X1 -> auto___def_25 X2 -> auto___def_10 X1 X2
  | trans___def_10_7 : forall X1 X2:term, auto___def_7 X1 -> auto___def_30 X2 -> auto___def_10 X1 X2
  | trans___def_10_8 : forall X1 X2:term, auto___def_7 X1 -> auto___def_25 X2 -> auto___def_10 X1 X2
  | trans___def_10_9 : forall X1 X2:term, auto___def_2 X1 -> auto___def_32 X2 -> auto___def_10 X1 X2
  | trans___def_10_10 : forall X1 X2:term, auto___def_5 X1 -> auto___def_30 X2 -> auto___def_10 X1 X2
with auto___def_32 : term -> Prop :=
    trans___def_32_nonceb_old_1 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto_agent X1 -> auto___def_5 X2 -> auto_agent X2 -> auto___type_2 X3 -> auto___def_26 X4 -> auto___def_32 (nonceb_old X1 X2 X3 X4)
  | trans___def_32_nonceb_old_2 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto_agent X1 -> auto_agent X2 -> auto___def_2 X2 -> auto___type_2 X3 -> auto___def_26 X4 -> auto___def_32 (nonceb_old X1 X2 X3 X4)
  | trans___def_32_nonceb_old_3 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto___type_9 X2 -> auto_agent X2 -> auto___type_2 X3 -> auto_knows_old X4 -> auto___def_32 (nonceb_old X1 X2 X3 X4)
  | trans___def_32_nonceb_old_4 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto_agent X1 -> auto___def_7 X2 -> auto_agent X2 -> auto___type_2 X3 -> auto___def_26 X4 -> auto___def_32 (nonceb_old X1 X2 X3 X4)
with auto___def_55 : term -> Prop :=
    trans___def_55_cons_1 : forall X1 X2:term, auto___type_14 X1 -> auto___def_56 X2 -> auto___def_55 (cons X1 X2)
with auto___type_12 : term -> Prop :=
    trans___type_12_key_1 : forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___type_12 (key X1 X2)
  | trans___type_12_key_2 : forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___type_12 (key X1 X2)
  | trans___type_12_key_3 : forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___type_12 (key X1 X2)
with auto___def_24 : term -> term -> Prop :=
    trans___def_24_1 : forall X1 X2:term, auto___type_3 X1 -> auto___type_2 X2 -> auto___def_24 X1 X2
with auto___type_14 : term -> Prop :=
    trans___type_14_s_1 : forall X1:term, auto_knows_current X1 -> auto___type_14 (s X1)
  | trans___type_14_nil_1 : auto___type_14 nil
  | trans___type_14_i_1 : auto___type_14 i
  | trans___type_14_noncea_current_1 : forall X1 X2 X3:term, auto_agent X1 -> auto___type_11 X2 -> auto___type_10 X3 -> auto___type_14 (noncea_current X1 X2 X3)
  | trans___type_14_cons_1 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_14 (cons X1 X2)
  | trans___type_14_crypt_1 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_14 (crypt X1 X2)
  | trans___type_14_crypt_2 : forall X1 X2:term, auto___def_51 X1 -> auto___type_12 X2 -> auto___type_14 (crypt X1 X2)
  | trans___type_14_crypt_3 : forall X1 X2:term, auto___def_57 X1 -> auto___type_2 X2 -> auto___type_14 (crypt X1 X2)
  | trans___type_14_crypt_4 : forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___type_14 (crypt X1 X2)
  | trans___type_14_crypt_5 : forall X1 X2:term, auto___def_55 X1 -> auto___type_13 X2 -> auto___type_14 (crypt X1 X2)
  | trans___type_14_key_1 : forall X1 X2:term, auto___def_23 X1 -> auto___def_36 X2 -> auto___type_14 (key X1 X2)
  | trans___type_14_key_2 : forall X1 X2:term, auto___def_3 X1 -> auto___type_9 X2 -> auto___type_14 (key X1 X2)
  | trans___type_14_key_3 : forall X1 X2:term, auto___def_37 X1 -> auto___def_38 X2 -> auto___type_14 (key X1 X2)
  | trans___type_14_bob_1 : auto___type_14 bob
  | trans___type_14_noncea_old_1 : forall X1 X2 X3:term, auto___type_14 (noncea_old X1 X2 X3)
  | trans___type_14_alice_1 : auto___type_14 alice
  | trans___type_14_nonceb_old_1 : forall X1 X2 X3 X4:term, auto___type_14 (nonceb_old X1 X2 X3 X4)
  | trans___type_14_server_1 : auto___type_14 server
with auto___def_28 : term -> Prop :=
    trans___def_28_cons_1 : forall X1 X2:term, auto_agent X1 -> auto___def_17 X2 -> auto___def_28 (cons X1 X2)
with auto___def_16 : term -> Prop :=
    trans___def_16_cons_1 : forall X1 X2:term, auto_agent X1 -> auto___def_17 X2 -> auto___def_16 (cons X1 X2)
with auto___def_39 : term -> term -> Prop :=
    trans___def_39_1 : forall X1 X2:term, auto___def_7 X1 -> auto___def_51 X2 -> auto___def_39 X1 X2
  | trans___def_39_2 : forall X1 X2:term, auto___def_5 X1 -> auto___def_51 X2 -> auto___def_39 X1 X2
  | trans___def_39_3 : forall X1 X2:term, auto___def_5 X1 -> auto___def_55 X2 -> auto___def_39 X1 X2
  | trans___def_39_4 : forall X1 X2:term, auto___def_7 X1 -> auto___def_57 X2 -> auto___def_39 X1 X2
  | trans___def_39_5 : forall X1 X2:term, auto___def_2 X1 -> auto___def_51 X2 -> auto___def_39 X1 X2
  | trans___def_39_6 : forall X1 X2:term, auto___def_2 X1 -> auto___def_57 X2 -> auto___def_39 X1 X2
  | trans___def_39_7 : forall X1 X2:term, auto___def_2 X1 -> auto___def_55 X2 -> auto___def_39 X1 X2
  | trans___def_39_8 : forall X1 X2:term, auto___def_5 X1 -> auto___def_57 X2 -> auto___def_39 X1 X2
  | trans___def_39_9 : forall X1 X2:term, auto___def_7 X1 -> auto___def_55 X2 -> auto___def_39 X1 X2
  | trans___def_39_10 : forall X1 X2:term, auto___type_9 X1 -> auto_knows_current X2 -> auto___def_39 X1 X2
with auto___def_19 : term -> Prop :=
    trans___def_19_cons_1 : forall X1 X2:term, auto___type_2 X1 -> auto___def_21 X2 -> auto___def_19 (cons X1 X2)
with auto___def_43 : term -> term -> Prop :=
    trans___def_43_1 : forall X1 X2:term, auto_knows_current X1 -> auto___def_38 X2 -> auto___def_43 X1 X2
with auto___type_6 : term -> Prop :=
    trans___type_6_key_1 : forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___type_6 (key X1 X2)
  | trans___type_6_key_2 : forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___type_6 (key X1 X2)
  | trans___type_6_key_3 : forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___type_6 (key X1 X2)
with auto___def_40 : term -> Prop :=
    trans___def_40_i_1 : auto___def_40 i
with auto___def_45 : term -> term -> Prop :=
    trans___def_45_1 : forall X1 X2:term, auto_knows_current X1 -> auto___def_2 X1 -> auto___def_1 X2 -> auto___def_45 X1 X2
  | trans___def_45_2 : forall X1 X2:term, auto___def_9 X1 -> auto_knows_current X1 -> auto___def_8 X2 -> auto___def_45 X1 X2
  | trans___def_45_3 : forall X1 X2:term, auto_knows_old X1 -> auto___def_5 X1 -> auto___def_4 X2 -> auto___def_45 X1 X2
  | trans___def_45_4 : forall X1 X2:term, auto___type_11 X1 -> auto___def_7 X1 -> auto___def_6 X2 -> auto___def_45 X1 X2
with auto___def_49 : term -> Prop :=
    trans___def_49_nil_1 : auto___def_49 nil
with auto___def_35 : term -> term -> term -> term -> Prop :=
    trans___def_35_1 : forall X1 X2 X3 X4:term, auto___def_5 X1 -> auto_agent X1 -> auto___def_32 X2 -> auto___type_8 X3 -> auto___type_3 X3 -> auto___type_2 X4 -> auto___def_35 X1 X2 X3 X4
  | trans___def_35_2 : forall X1 X2 X3 X4:term, auto___def_7 X1 -> auto_agent X1 -> auto___def_32 X2 -> auto___type_8 X3 -> auto___type_3 X3 -> auto___type_2 X4 -> auto___def_35 X1 X2 X3 X4
  | trans___def_35_3 : forall X1 X2 X3 X4:term, auto_agent X1 -> auto___def_2 X1 -> auto___def_32 X2 -> auto___type_8 X3 -> auto___type_3 X3 -> auto___type_2 X4 -> auto___def_35 X1 X2 X3 X4
with auto___def_37 : term -> Prop :=
    trans___def_37_sym_1 : auto___def_37 sym
with auto___type_4 : term -> Prop :=
    trans___type_4_key_1 : forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___type_4 (key X1 X2)
  | trans___type_4_key_2 : forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___type_4 (key X1 X2)
  | trans___type_4_key_3 : forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___type_4 (key X1 X2)
with auto___def_59 : term -> Prop :=
    trans___def_59_nil_1 : auto___def_59 nil
with auto___def_12 : term -> term -> Prop :=
    trans___def_12_1 : forall X1 X2:term, auto___def_36 X1 -> auto_knows_old X2 -> auto___def_12 X1 X2
  | trans___def_12_2 : forall X1 X2:term, auto___def_7 X1 -> auto___def_19 X2 -> auto___def_12 X1 X2
with auto___def_36 : term -> Prop :=
    trans___def_36_i_1 : auto___def_36 i
with auto___def_33 : term -> Prop :=
    trans___def_33_cons_1 : forall X1 X2:term, auto___type_8 X1 -> auto___def_34 X2 -> auto___def_33 (cons X1 X2)
with auto___def_38 : term -> Prop :=
    trans___def_38_session_old_1 : forall X1 X2 X3:term, auto___def_38 (session_old X1 X2 X3)
with auto___def_51 : term -> Prop :=
    trans___def_51_cons_1 : forall X1 X2:term, auto___def_52 X1 -> auto___def_53 X2 -> auto___def_51 (cons X1 X2)
with auto___def_21 : term -> Prop :=
    trans___def_21_cons_1 : forall X1 X2:term, auto___type_3 X1 -> auto___def_22 X2 -> auto___def_21 (cons X1 X2)
with auto___def_60 : term -> term -> term -> term -> Prop :=
    trans___def_60_1 : forall X1 X2 X3 X4:term, auto___def_5 X1 -> auto_agent X1 -> auto___def_57 X2 -> auto___type_11 X3 -> auto___type_15 X3 -> auto___type_10 X4 -> auto___def_60 X1 X2 X3 X4
  | trans___def_60_2 : forall X1 X2 X3 X4:term, auto_agent X1 -> auto___def_2 X1 -> auto___def_57 X2 -> auto___type_3 X3 -> auto___type_15 X3 -> auto___type_2 X4 -> auto___def_60 X1 X2 X3 X4
  | trans___def_60_3 : forall X1 X2 X3 X4:term, auto___def_7 X1 -> auto_agent X1 -> auto___def_57 X2 -> auto___type_11 X3 -> auto___type_15 X3 -> auto___type_10 X4 -> auto___def_60 X1 X2 X3 X4
with auto___def_25 : term -> Prop :=
    trans___def_25_cons_1 : forall X1 X2:term, auto___def_26 X1 -> auto___def_27 X2 -> auto___def_25 (cons X1 X2)
with auto___def_41 : term -> term -> Prop :=
    trans___def_41_1 : forall X1 X2:term, auto___def_36 X1 -> auto_knows_current X2 -> auto___def_41 X1 X2
  | trans___def_41_2 : forall X1 X2:term, auto___def_7 X1 -> auto___def_46 X2 -> auto___def_41 X1 X2
with auto___def_58 : term -> Prop :=
    trans___def_58_cons_1 : forall X1 X2:term, auto___type_15 X1 -> auto___def_59 X2 -> auto___def_58 (cons X1 X2)
with auto___def_50 : term -> term -> Prop :=
    trans___def_50_1 : forall X1 X2:term, auto___type_11 X1 -> auto___type_10 X2 -> auto___def_50 X1 X2
with auto___type_11 : term -> Prop :=
    trans___type_11_bob_1 : auto___type_11 bob
  | trans___type_11_alice_1 : auto___type_11 alice
  | trans___type_11_server_1 : auto___type_11 server
with auto___type_1 : term -> Prop :=
    trans___type_1_i_1 : auto___type_1 i
  | trans___type_1_bob_1 : auto___type_1 bob
  | trans___type_1_alice_1 : auto___type_1 alice
  | trans___type_1_server_1 : auto___type_1 server
with auto___def_9 : term -> Prop :=
    trans___def_9_intruder_1 : auto___def_9 intruder
with auto___def_7 : term -> Prop :=
    trans___def_7_server_1 : auto___def_7 server
with auto___def_52 : term -> Prop :=
    trans___def_52_noncea_current_1 : forall X1 X2 X3:term, auto_agent X1 -> auto___type_11 X2 -> auto___type_10 X3 -> auto___def_52 (noncea_current X1 X2 X3)
with auto___def_44 : term -> Prop :=
    trans___def_44_session_old_1 : forall X1 X2 X3:term, auto___def_44 (session_old X1 X2 X3)
with auto___type_7 : term -> Prop :=
    trans___type_7_s_1 : forall X1:term, auto_knows_old X1 -> auto___type_7 (s X1)
  | trans___type_7_nil_1 : auto___type_7 nil
  | trans___type_7_i_1 : auto___type_7 i
  | trans___type_7_cons_1 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_7 (cons X1 X2)
  | trans___type_7_crypt_1 : forall X1 X2:term, auto___def_32 X1 -> auto___type_2 X2 -> auto___type_7 (crypt X1 X2)
  | trans___type_7_crypt_2 : forall X1 X2:term, auto___def_25 X1 -> auto___type_4 X2 -> auto___type_7 (crypt X1 X2)
  | trans___type_7_crypt_3 : forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto___type_7 (crypt X1 X2)
  | trans___type_7_crypt_4 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_7 (crypt X1 X2)
  | trans___type_7_crypt_5 : forall X1 X2:term, auto___def_30 X1 -> auto___type_6 X2 -> auto___type_7 (crypt X1 X2)
  | trans___type_7_key_1 : forall X1 X2:term, auto___def_23 X1 -> auto___def_36 X2 -> auto___type_7 (key X1 X2)
  | trans___type_7_key_2 : forall X1 X2:term, auto___def_3 X1 -> auto___type_9 X2 -> auto___type_7 (key X1 X2)
  | trans___type_7_bob_1 : auto___type_7 bob
  | trans___type_7_noncea_old_1 : forall X1 X2 X3:term, auto_agent X1 -> auto___type_3 X2 -> auto___type_2 X3 -> auto___type_7 (noncea_old X1 X2 X3)
  | trans___type_7_alice_1 : auto___type_7 alice
  | trans___type_7_server_1 : auto___type_7 server
with auto___def_18 : term -> term -> Prop :=
    trans___def_18_1 : forall X1 X2:term, auto_knows_old X1 -> auto___def_2 X1 -> auto___def_1 X2 -> auto___def_18 X1 X2
  | trans___def_18_2 : forall X1 X2:term, auto_knows_old X1 -> auto___def_5 X1 -> auto___def_4 X2 -> auto___def_18 X1 X2
  | trans___def_18_3 : forall X1 X2:term, auto_knows_old X1 -> auto___def_9 X1 -> auto___def_8 X2 -> auto___def_18 X1 X2
  | trans___def_18_4 : forall X1 X2:term, auto___def_7 X1 -> auto_agent X1 -> auto___def_6 X2 -> auto___def_18 X1 X2
with auto___def_46 : term -> Prop :=
    trans___def_46_cons_1 : forall X1 X2:term, auto___type_10 X1 -> auto___def_48 X2 -> auto___def_46 (cons X1 X2)
with auto___def_23 : term -> Prop :=
    trans___def_23_prv_1 : auto___def_23 prv
with auto___type_5 : term -> Prop :=
    trans___type_5_i_1 : auto___type_5 i
  | trans___type_5_bob_1 : auto___type_5 bob
  | trans___type_5_alice_1 : auto___type_5 alice
  | trans___type_5_server_1 : auto___type_5 server
with auto___type_2 : term -> Prop :=
    trans___type_2_key_1 : forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___type_2 (key X1 X2)
  | trans___type_2_key_2 : forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___type_2 (key X1 X2)
  | trans___type_2_key_3 : forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___type_2 (key X1 X2)
with auto___def_54 : term -> term -> term -> term -> Prop :=
    trans___def_54_1 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto___type_9 X2 -> auto_agent X2 -> auto_knows_current X3 -> auto___type_2 X4 -> auto___def_54 X1 X2 X3 X4
  | trans___def_54_2 : forall X1 X2 X3 X4:term, auto___type_11 X1 -> auto_agent X1 -> auto_agent X2 -> auto___def_2 X2 -> auto___def_52 X3 -> auto___type_10 X4 -> auto___def_54 X1 X2 X3 X4
  | trans___def_54_3 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto_agent X1 -> auto___def_7 X2 -> auto_agent X2 -> auto___def_52 X3 -> auto___type_2 X4 -> auto___def_54 X1 X2 X3 X4
  | trans___def_54_4 : forall X1 X2 X3 X4:term, auto___type_11 X1 -> auto_agent X1 -> auto___def_5 X2 -> auto_agent X2 -> auto___def_52 X3 -> auto___type_10 X4 -> auto___def_54 X1 X2 X3 X4
with auto___def_56 : term -> Prop :=
    trans___def_56_cons_1 : forall X1 X2:term, auto___def_57 X1 -> auto___def_58 X2 -> auto___def_56 (cons X1 X2)
with auto___def_31 : term -> Prop :=
    trans___def_31_cons_1 : forall X1 X2:term, auto___def_32 X1 -> auto___def_33 X2 -> auto___def_31 (cons X1 X2)
with auto___def_30 : term -> Prop :=
    trans___def_30_cons_1 : forall X1 X2:term, auto___type_7 X1 -> auto___def_31 X2 -> auto___def_30 (cons X1 X2)
with auto_knows_current : term -> Prop :=
    trans_knows_current_s_1 : forall X1:term, auto_knows_current X1 -> auto_knows_current (s X1)
  | trans_knows_current_nil_1 : auto_knows_current nil
  | trans_knows_current_i_1 : auto_knows_current i
  | trans_knows_current_cons_1 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current (cons X1 X2)
  | trans_knows_current_crypt_1 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_2 : forall X1 X2:term, auto___def_51 X1 -> auto___type_12 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_3 : forall X1 X2:term, auto___def_57 X1 -> auto___type_2 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_4 : forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_5 : forall X1 X2:term, auto___def_55 X1 -> auto___type_13 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_key_1 : forall X1 X2:term, auto___def_23 X1 -> auto___def_36 X2 -> auto_knows_current (key X1 X2)
  | trans_knows_current_key_2 : forall X1 X2:term, auto___def_3 X1 -> auto___type_9 X2 -> auto_knows_current (key X1 X2)
  | trans_knows_current_key_3 : forall X1 X2:term, auto___def_37 X1 -> auto___def_38 X2 -> auto_knows_current (key X1 X2)
  | trans_knows_current_bob_1 : auto_knows_current bob
  | trans_knows_current_noncea_old_1 : forall X1 X2 X3:term, auto_knows_current (noncea_old X1 X2 X3)
  | trans_knows_current_alice_1 : auto_knows_current alice
  | trans_knows_current_nonceb_old_1 : forall X1 X2 X3 X4:term, auto_knows_current (nonceb_old X1 X2 X3 X4)
  | trans_knows_current_server_1 : auto_knows_current server
with auto___type_8 : term -> Prop :=
    trans___type_8_i_1 : auto___type_8 i
  | trans___type_8_bob_1 : auto___type_8 bob
  | trans___type_8_alice_1 : auto___type_8 alice
  | trans___type_8_server_1 : auto___type_8 server
with auto___def_34 : term -> Prop :=
    trans___def_34_nil_1 : auto___def_34 nil
with auto___def_26 : term -> Prop :=
    trans___def_26_noncea_old_1 : forall X1 X2 X3:term, auto_agent X1 -> auto___type_3 X2 -> auto___type_2 X3 -> auto___def_26 (noncea_old X1 X2 X3)
with auto___def_3 : term -> Prop :=
    trans___def_3_pub_1 : auto___def_3 pub
with auto___def_47 : term -> Prop :=
    trans___def_47_key_1 : forall X1 X2:term, auto___def_23 X1 -> auto___def_7 X2 -> auto___def_47 (key X1 X2)
with auto___def_1 : term -> Prop :=
    trans___def_1_key_1 : forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___def_1 (key X1 X2)
with auto___type_3 : term -> Prop :=
    trans___type_3_bob_1 : auto___type_3 bob
  | trans___type_3_alice_1 : auto___type_3 alice
  | trans___type_3_server_1 : auto___type_3 server
with auto___def_57 : term -> Prop :=
    trans___def_57_nonceb_current_1 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto_agent X1 -> auto___def_7 X2 -> auto_agent X2 -> auto___type_2 X3 -> auto___def_52 X4 -> auto___def_57 (nonceb_current X1 X2 X3 X4)
  | trans___def_57_nonceb_current_2 : forall X1 X2 X3 X4:term, auto___type_11 X1 -> auto_agent X1 -> auto___def_5 X2 -> auto_agent X2 -> auto___type_10 X3 -> auto___def_52 X4 -> auto___def_57 (nonceb_current X1 X2 X3 X4)
  | trans___def_57_nonceb_current_3 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto___type_9 X2 -> auto_agent X2 -> auto___type_2 X3 -> auto_knows_current X4 -> auto___def_57 (nonceb_current X1 X2 X3 X4)
  | trans___def_57_nonceb_current_4 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto_agent X1 -> auto_agent X2 -> auto___def_2 X2 -> auto___type_2 X3 -> auto___def_52 X4 -> auto___def_57 (nonceb_current X1 X2 X3 X4)
with auto___def_22 : term -> Prop :=
    trans___def_22_nil_1 : auto___def_22 nil
with auto___type_15 : term -> Prop :=
    trans___type_15_i_1 : auto___type_15 i
  | trans___type_15_bob_1 : auto___type_15 bob
  | trans___type_15_alice_1 : auto___type_15 alice
  | trans___type_15_server_1 : auto___type_15 server
with auto___def_5 : term -> Prop :=
    trans___def_5_bob_1 : auto___def_5 bob
with auto_agent : term -> Prop :=
    trans_agent_i_1 : auto_agent i
  | trans_agent_bob_1 : auto_agent bob
  | trans_agent_alice_1 : auto_agent alice
  | trans_agent_server_1 : auto_agent server
with auto___def_48 : term -> Prop :=
    trans___def_48_cons_1 : forall X1 X2:term, auto___type_11 X1 -> auto___def_49 X2 -> auto___def_48 (cons X1 X2)
with auto___def_2 : term -> Prop :=
    trans___def_2_alice_1 : auto___def_2 alice
with auto___def_27 : term -> Prop :=
    trans___def_27_cons_1 : forall X1 X2:term, auto_agent X1 -> auto___def_17 X2 -> auto___def_27 (cons X1 X2)
with auto___def_8 : term -> Prop :=
    trans___def_8_key_1 : forall X1 X2:term, auto___def_3 X1 -> auto___def_9 X2 -> auto___def_8 (key X1 X2)
with auto___def_4 : term -> Prop :=
    trans___def_4_key_1 : forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___def_4 (key X1 X2)
with auto___def_20 : term -> Prop :=
    trans___def_20_key_1 : forall X1 X2:term, auto___def_23 X1 -> auto___def_7 X2 -> auto___def_20 (key X1 X2)
with auto___def_53 : term -> Prop :=
    trans___def_53_cons_1 : forall X1 X2:term, auto_agent X1 -> auto___def_17 X2 -> auto___def_53 (cons X1 X2)
with auto___type_13 : term -> Prop :=
    trans___type_13_key_1 : forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___type_13 (key X1 X2)
  | trans___type_13_key_2 : forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___type_13 (key X1 X2)
  | trans___type_13_key_3 : forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___type_13 (key X1 X2)
with auto___query__intruder_knows_bob_msg : Prop :=
with auto___query__intruder_knows_alice_msg : Prop :=
with auto___def_14 : term -> term -> Prop :=
with auto___def_15 : term -> Prop :=
.

(* [defp] Proofs that all definitions hold. *)


Remark rem_1 : forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2 : forall X1 X2:term, auto___def_17 X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_1 X1).
Qed.

Remark rem_3 : forall X2:term, auto___def_17 X2 -> auto___def_17 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_4 : forall X1 X2:term, auto___def_17 X2 -> auto_agent X1 -> auto___def_17 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_17 X2 -> auto___def_17 X2). tauto. exact (rem_3 X2).
Qed.

Remark rem_5 : forall X1 X2:term, auto___def_17 X2 -> auto_agent X1 -> (auto_agent X1 /\ auto___def_17 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto_agent X1). 2:apply (rem_2 X1 X2);  assumption.
  cut (auto___def_17 X2). 2:apply (rem_4 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_6 : forall X1 X2:term, auto___def_17 X2 -> auto_agent X1 -> auto___def_27 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_5 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_27_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_7 : (forall X:term, auto___def_2 X -> auto___type_11 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_2_p__type_11.  tauto.
Defined.

Remark rem_8 : (forall X:term, auto___def_2 X -> auto___type_11 X)
    -> auto___type_11 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_2_p__type_11.  case (rem_7 epsilon_m__def_2_p__type_11). clear  epsilon_m__def_2_p__type_11. intros. apply trans___type_11_alice_1;  tauto.
 clear  epsilon_m__def_2_p__type_11. tauto.
Defined.

Inductive or_1(H1:Prop) : Prop :=
    or_1_intro_1 : H1 -> (or_1 H1)
.

Remark rem_9 : auto___def_2 alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_10 : (forall X:term, auto___def_2 X -> auto___type_11 X)
    -> auto___def_2 alice -> auto___type_11 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_2_p__type_11. intro H. intros.
  elim (rem_9 H);  intros.
  apply (rem_8 epsilon_m__def_2_p__type_11);  tauto.
Defined.

Inductive or_0 : Prop :=
.

Remark rem_11 : forall X1:term, auto___def_2 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_12 : auto___def_2 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_13 : auto___def_2 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_14 : forall X1 X2 X3:term, auto___def_2 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_15 : auto___def_2 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_16 : forall X1 X2 X3:term, auto___def_2 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_17 : forall X1 X2:term, auto___def_2 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_18 : forall X1 X2:term, auto___def_2 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_19 : forall X1 X2:term, auto___def_2 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_20 : auto___def_2 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_21 : forall X1 X2 X3:term, auto___def_2 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_22 : forall X1 X2 X3 X4:term, auto___def_2 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_23 : auto___def_2 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_24 : forall X1 X2 X3 X4:term, auto___def_2 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_25 : auto___def_2 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_26 : auto___def_2 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_27 : auto___def_2 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_28 : forall X1:term, auto___def_2 X1 -> auto___type_11 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_2_p__type_11 1.
  intro X. case X.
  exact (rem_10 epsilon_m__def_2_p__type_11 ).
   intro H. elim (rem_20  H).
  intros X1 X2. intro H. elim (rem_17 X1 X2 H).
  intros X1 X2. intro H. elim (rem_18 X1 X2 H).
   intro H. elim (rem_13  H).
   intro H. elim (rem_25  H).
  intros X1 X2. intro H. elim (rem_19 X1 X2 H).
   intro H. elim (rem_12  H).
  intros X1 X2 X3. intro H. elim (rem_16 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_21 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_24 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_22 X1 X2 X3 X4 H).
   intro H. elim (rem_27  H).
   intro H. elim (rem_23  H).
  intros X1. intro H. elim (rem_11 X1 H).
   intro H. elim (rem_26  H).
  intros X1 X2 X3. intro H. elim (rem_14 X1 X2 X3 H).
   intro H. elim (rem_15  H).
Qed.

Remark rem_29 : forall X1 X2:term, auto___def_1 X2 -> auto___def_2 X1 -> auto_knows_current X1 -> auto___type_11 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_2 X1 -> auto___type_11 X1). tauto. exact (rem_28 X1).
Qed.

Remark rem_30 : forall X1 X2:term, auto_knows_current X1 -> auto___def_2 X1 -> auto___def_1 X2 -> auto___type_11 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_1 X2 -> auto___def_2 X1 -> auto_knows_current X1 -> auto___type_11 X1). tauto. exact (rem_29 X1 X2).
Qed.

Remark rem_31 : auto_knows_current intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_32 : (forall X:term, auto___def_9 X -> auto_knows_current X -> False)
    -> auto_knows_current intruder -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_9_mknows_current. intro H. intros.
  elim (rem_31 H);  intros.
Defined.

Remark rem_33 : auto___def_9 intruder -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_34 : (forall X:term, auto___def_9 X -> auto_knows_current X -> False)
    -> auto___def_9 intruder -> auto_knows_current intruder -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_9_mknows_current. intro H. intros.
  elim (rem_33 H);  intros.
  apply (rem_32 epsilon_m__def_9_mknows_current);  tauto.
Defined.

Remark rem_35 : forall X1:term, auto___def_9 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_36 : auto___def_9 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_37 : auto___def_9 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_38 : forall X1 X2 X3:term, auto___def_9 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_39 : auto___def_9 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_40 : forall X1 X2 X3:term, auto___def_9 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_41 : forall X1 X2:term, auto___def_9 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_42 : forall X1 X2:term, auto___def_9 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_43 : forall X1 X2:term, auto___def_9 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_44 : auto___def_9 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_45 : forall X1 X2 X3:term, auto___def_9 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_46 : auto___def_9 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_47 : forall X1 X2 X3 X4:term, auto___def_9 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_48 : auto___def_9 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_49 : forall X1 X2 X3 X4:term, auto___def_9 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_50 : auto___def_9 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_51 : auto___def_9 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_52 : forall X1:term, auto___def_9 X1 -> auto_knows_current X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_9_mknows_current 1.
  intro X. case X.
   intro H. elim (rem_46  H).
   intro H. elim (rem_44  H).
  intros X1 X2. intro H. elim (rem_41 X1 X2 H).
  intros X1 X2. intro H. elim (rem_42 X1 X2 H).
   intro H. elim (rem_37  H).
  exact (rem_34 epsilon_m__def_9_mknows_current ).
  intros X1 X2. intro H. elim (rem_43 X1 X2 H).
   intro H. elim (rem_36  H).
  intros X1 X2 X3. intro H. elim (rem_40 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_45 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_49 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_47 X1 X2 X3 X4 H).
   intro H. elim (rem_51  H).
   intro H. elim (rem_48  H).
  intros X1. intro H. elim (rem_35 X1 H).
   intro H. elim (rem_50  H).
  intros X1 X2 X3. intro H. elim (rem_38 X1 X2 X3 H).
   intro H. elim (rem_39  H).
Qed.

Remark rem_53 : forall X1 X2:term, auto___def_8 X2 -> auto___def_9 X1 -> auto_knows_current X1 -> auto___type_11 X1. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_52 X1)). tauto.
Qed.

Remark rem_54 : forall X1 X2:term, auto___def_9 X1 -> auto_knows_current X1 -> auto___def_8 X2 -> auto___type_11 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_8 X2 -> auto___def_9 X1 -> auto_knows_current X1 -> auto___type_11 X1). tauto. exact (rem_53 X1 X2).
Qed.

Remark rem_55 : (forall X:term, auto___def_5 X -> auto___type_11 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_5_p__type_11.  tauto.
Defined.

Remark rem_56 : (forall X:term, auto___def_5 X -> auto___type_11 X)
    -> auto___type_11 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_5_p__type_11.  case (rem_55 epsilon_m__def_5_p__type_11). clear  epsilon_m__def_5_p__type_11. intros. apply trans___type_11_bob_1;  tauto.
 clear  epsilon_m__def_5_p__type_11. tauto.
Defined.

Remark rem_57 : auto___def_5 bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_58 : (forall X:term, auto___def_5 X -> auto___type_11 X)
    -> auto___def_5 bob -> auto___type_11 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_5_p__type_11. intro H. intros.
  elim (rem_57 H);  intros.
  apply (rem_56 epsilon_m__def_5_p__type_11);  tauto.
Defined.

Remark rem_59 : forall X1:term, auto___def_5 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_60 : auto___def_5 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_61 : auto___def_5 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_62 : forall X1 X2 X3:term, auto___def_5 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_63 : auto___def_5 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_64 : forall X1 X2 X3:term, auto___def_5 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_65 : forall X1 X2:term, auto___def_5 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_66 : forall X1 X2:term, auto___def_5 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_67 : forall X1 X2:term, auto___def_5 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_68 : forall X1 X2 X3:term, auto___def_5 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_69 : auto___def_5 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_70 : forall X1 X2 X3 X4:term, auto___def_5 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_71 : auto___def_5 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_72 : forall X1 X2 X3 X4:term, auto___def_5 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_73 : auto___def_5 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_74 : auto___def_5 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_75 : auto___def_5 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_76 : forall X1:term, auto___def_5 X1 -> auto___type_11 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_5_p__type_11 1.
  intro X. case X.
   intro H. elim (rem_69  H).
  exact (rem_58 epsilon_m__def_5_p__type_11 ).
  intros X1 X2. intro H. elim (rem_65 X1 X2 H).
  intros X1 X2. intro H. elim (rem_66 X1 X2 H).
   intro H. elim (rem_61  H).
   intro H. elim (rem_73  H).
  intros X1 X2. intro H. elim (rem_67 X1 X2 H).
   intro H. elim (rem_60  H).
  intros X1 X2 X3. intro H. elim (rem_64 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_68 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_72 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_70 X1 X2 X3 X4 H).
   intro H. elim (rem_75  H).
   intro H. elim (rem_71  H).
  intros X1. intro H. elim (rem_59 X1 H).
   intro H. elim (rem_74  H).
  intros X1 X2 X3. intro H. elim (rem_62 X1 X2 X3 H).
   intro H. elim (rem_63  H).
Qed.

Remark rem_77 : forall X1 X2:term, auto___def_4 X2 -> auto___def_5 X1 -> auto_knows_old X1 -> auto___type_11 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_5 X1 -> auto___type_11 X1). tauto. exact (rem_76 X1).
Qed.

Remark rem_78 : forall X1 X2:term, auto_knows_old X1 -> auto___def_5 X1 -> auto___def_4 X2 -> auto___type_11 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_4 X2 -> auto___def_5 X1 -> auto_knows_old X1 -> auto___type_11 X1). tauto. exact (rem_77 X1 X2).
Qed.

Remark rem_79 : (forall X:term, auto___def_7 X -> auto___type_11 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_7_p__type_11.  tauto.
Defined.

Remark rem_80 : (forall X:term, auto___def_7 X -> auto___type_11 X)
    -> auto___type_11 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_7_p__type_11.  case (rem_79 epsilon_m__def_7_p__type_11). clear  epsilon_m__def_7_p__type_11. intros. apply trans___type_11_server_1;  tauto.
 clear  epsilon_m__def_7_p__type_11. tauto.
Defined.

Remark rem_81 : auto___def_7 server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_82 : (forall X:term, auto___def_7 X -> auto___type_11 X)
    -> auto___def_7 server -> auto___type_11 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_7_p__type_11. intro H. intros.
  elim (rem_81 H);  intros.
  apply (rem_80 epsilon_m__def_7_p__type_11);  tauto.
Defined.

Remark rem_83 : forall X1:term, auto___def_7 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_84 : auto___def_7 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_85 : auto___def_7 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_86 : forall X1 X2 X3:term, auto___def_7 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_87 : auto___def_7 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_88 : forall X1 X2 X3:term, auto___def_7 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_89 : forall X1 X2:term, auto___def_7 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_90 : forall X1 X2:term, auto___def_7 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_91 : forall X1 X2:term, auto___def_7 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_92 : auto___def_7 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_93 : forall X1 X2 X3:term, auto___def_7 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_94 : auto___def_7 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_95 : forall X1 X2 X3 X4:term, auto___def_7 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_96 : auto___def_7 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_97 : forall X1 X2 X3 X4:term, auto___def_7 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_98 : auto___def_7 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_99 : auto___def_7 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_100 : forall X1:term, auto___def_7 X1 -> auto___type_11 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_7_p__type_11 1.
  intro X. case X.
   intro H. elim (rem_94  H).
   intro H. elim (rem_92  H).
  intros X1 X2. intro H. elim (rem_89 X1 X2 H).
  intros X1 X2. intro H. elim (rem_90 X1 X2 H).
   intro H. elim (rem_85  H).
   intro H. elim (rem_98  H).
  intros X1 X2. intro H. elim (rem_91 X1 X2 H).
   intro H. elim (rem_84  H).
  intros X1 X2 X3. intro H. elim (rem_88 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_93 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_97 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_95 X1 X2 X3 X4 H).
   intro H. elim (rem_99  H).
   intro H. elim (rem_96  H).
  intros X1. intro H. elim (rem_83 X1 H).
  exact (rem_82 epsilon_m__def_7_p__type_11 ).
  intros X1 X2 X3. intro H. elim (rem_86 X1 X2 X3 H).
   intro H. elim (rem_87  H).
Qed.

Remark rem_101 : forall X1 X2:term, auto___def_6 X2 -> auto___def_7 X1 -> auto___type_11 X1 -> auto___type_11 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_7 X1 -> auto___type_11 X1). tauto. exact (rem_100 X1).
Qed.

Remark rem_102 : forall X1 X2:term, auto___type_11 X1 -> auto___def_7 X1 -> auto___def_6 X2 -> auto___type_11 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_6 X2 -> auto___def_7 X1 -> auto___type_11 X1 -> auto___type_11 X1). tauto. exact (rem_101 X1 X2).
Qed.

Inductive or_4(H1 H2 H3 H4:Prop) : Prop :=
    or_4_intro_1 : H1 -> (or_4 H1 H2 H3 H4)
  | or_4_intro_2 : H2 -> (or_4 H1 H2 H3 H4)
  | or_4_intro_3 : H3 -> (or_4 H1 H2 H3 H4)
  | or_4_intro_4 : H4 -> (or_4 H1 H2 H3 H4)
.

Remark rem_103 : forall X1 X2:term, auto___def_45 X1 X2 -> or_4
    (auto_knows_current X1 /\ auto___def_2 X1 /\ auto___def_1 X2)
    (auto___def_9 X1 /\ auto_knows_current X1 /\ auto___def_8 X2)
    (auto_knows_old X1 /\ auto___def_5 X1 /\ auto___def_4 X2)
    (auto___type_11 X1 /\ auto___def_7 X1 /\ auto___def_6 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_4_intro_1; tauto.
  intros. apply or_4_intro_2; tauto.
  intros. apply or_4_intro_3; tauto.
  intros. apply or_4_intro_4; tauto.
Qed.

Remark rem_104 : forall X1 X2:term, auto___def_45 X1 X2 -> auto___type_11 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_103 X1 X2 H);  intros.
  apply (rem_30 X1 X2);  tauto.
  apply (rem_54 X1 X2);  tauto.
  apply (rem_78 X1 X2);  tauto.
  apply (rem_102 X1 X2);  tauto.
Qed.

Remark rem_105 : forall X1:term, auto___type_9 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Qed.

Remark rem_106 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p__type_1.  tauto.
Defined.

Remark rem_107 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto___type_1 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_1.  case (rem_106 epsilon_magent_p__type_1). clear  epsilon_magent_p__type_1. intros. apply trans___type_1_i_1;  tauto.
 clear  epsilon_magent_p__type_1. tauto.
Defined.

Remark rem_108 : auto_agent i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_109 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto_agent i -> auto___type_1 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_1. intro H. intros.
  elim (rem_108 H);  intros.
  apply (rem_107 epsilon_magent_p__type_1);  tauto.
Defined.

Remark rem_110 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto___type_1 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_1.  case (rem_106 epsilon_magent_p__type_1). clear  epsilon_magent_p__type_1. intros. apply trans___type_1_bob_1;  tauto.
 clear  epsilon_magent_p__type_1. tauto.
Defined.

Remark rem_111 : auto_agent bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_112 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto_agent bob -> auto___type_1 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_1. intro H. intros.
  elim (rem_111 H);  intros.
  apply (rem_110 epsilon_magent_p__type_1);  tauto.
Defined.

Remark rem_113 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto___type_1 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_1.  case (rem_106 epsilon_magent_p__type_1). clear  epsilon_magent_p__type_1. intros. apply trans___type_1_alice_1;  tauto.
 clear  epsilon_magent_p__type_1. tauto.
Defined.

Remark rem_114 : auto_agent alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_115 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto_agent alice -> auto___type_1 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_1. intro H. intros.
  elim (rem_114 H);  intros.
  apply (rem_113 epsilon_magent_p__type_1);  tauto.
Defined.

Remark rem_116 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto___type_1 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_1.  case (rem_106 epsilon_magent_p__type_1). clear  epsilon_magent_p__type_1. intros. apply trans___type_1_server_1;  tauto.
 clear  epsilon_magent_p__type_1. tauto.
Defined.

Remark rem_117 : auto_agent server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_118 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto_agent server -> auto___type_1 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_1. intro H. intros.
  elim (rem_117 H);  intros.
  apply (rem_116 epsilon_magent_p__type_1);  tauto.
Defined.

Remark rem_119 : forall X1:term, auto_agent (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_120 : auto_agent nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_121 : forall X1 X2 X3:term, auto_agent (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_122 : auto_agent sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_123 : forall X1 X2 X3:term, auto_agent (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_124 : forall X1 X2:term, auto_agent (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_125 : forall X1 X2:term, auto_agent (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_126 : forall X1 X2:term, auto_agent (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_127 : forall X1 X2 X3:term, auto_agent (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_128 : forall X1 X2 X3 X4:term, auto_agent (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_129 : auto_agent pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_130 : forall X1 X2 X3 X4:term, auto_agent (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_131 : auto_agent intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_132 : auto_agent prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_133 : forall X1:term, auto_agent X1 -> auto___type_1 X1. (* Induct. *)
Proof.
  fix epsilon_magent_p__type_1 1.
  intro X. case X.
  exact (rem_115 epsilon_magent_p__type_1 ).
  exact (rem_112 epsilon_magent_p__type_1 ).
  intros X1 X2. intro H. elim (rem_124 X1 X2 H).
  intros X1 X2. intro H. elim (rem_125 X1 X2 H).
  exact (rem_109 epsilon_magent_p__type_1 ).
   intro H. elim (rem_131  H).
  intros X1 X2. intro H. elim (rem_126 X1 X2 H).
   intro H. elim (rem_120  H).
  intros X1 X2 X3. intro H. elim (rem_123 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_127 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_130 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_128 X1 X2 X3 X4 H).
   intro H. elim (rem_132  H).
   intro H. elim (rem_129  H).
  intros X1. intro H. elim (rem_119 X1 H).
  exact (rem_118 epsilon_magent_p__type_1 ).
  intros X1 X2 X3. intro H. elim (rem_121 X1 X2 X3 H).
   intro H. elim (rem_122  H).
Qed.

Remark rem_134 : forall X1:term, auto_knows_current (key pub X1) -> auto___def_42 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___def_42_1. Qed.

Remark rem_135 : True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
   tauto.
Qed.

Remark rem_136 : auto___def_34 nil. (* Deduce positive atom. *)
Proof.
   case rem_135. intros. apply trans___def_34_nil_1;  tauto.
 tauto.
Qed.

Remark rem_137 : auto___def_3 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_138 : auto___def_3 prv -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_137 H);  intros.
Qed.

Remark rem_139 : forall X1 X2:term, auto___def_2 X1 -> auto___def_3 prv -> auto___def_32 X2 -> auto___def_12 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 prv -> False). tauto.
  exact (rem_138).
Qed.

Remark rem_140 : forall X1 X2:term, auto___def_3 prv -> auto___def_2 X1 -> auto___def_32 X2 -> auto___def_12 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_2 X1 -> auto___def_3 prv -> auto___def_32 X2 -> auto___def_12 X1 X2). tauto. exact (rem_139 X1 X2).
Qed.

Remark rem_141 : forall X1 X2:term, auto___def_3 prv -> auto___def_32 X2 -> auto___def_5 X1 -> auto___def_12 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 prv -> False). tauto.
  exact (rem_138).
Qed.

Remark rem_142 : forall X1 X2:term, auto___def_3 prv -> auto___def_5 X1 -> auto___def_32 X2 -> auto___def_12 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_3 prv -> auto___def_32 X2 -> auto___def_5 X1 -> auto___def_12 X1 X2). tauto. exact (rem_141 X1 X2).
Qed.

Remark rem_143 : forall X1 X2:term, auto___def_3 prv -> auto___def_32 X2 -> auto___def_7 X1 -> auto___def_12 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 prv -> False). tauto.
  exact (rem_138).
Qed.

Remark rem_144 : forall X1 X2:term, auto___def_3 prv -> auto___def_7 X1 -> auto___def_32 X2 -> auto___def_12 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_3 prv -> auto___def_32 X2 -> auto___def_7 X1 -> auto___def_12 X1 X2). tauto. exact (rem_143 X1 X2).
Qed.

Inductive or_3(H1 H2 H3:Prop) : Prop :=
    or_3_intro_1 : H1 -> (or_3 H1 H2 H3)
  | or_3_intro_2 : H2 -> (or_3 H1 H2 H3)
  | or_3_intro_3 : H3 -> (or_3 H1 H2 H3)
.

Remark rem_145 : forall X1 X2:term, auto___type_2 (key X1 X2) -> or_3
    (auto___def_3 X1 /\ auto___def_2 X2)
    (auto___def_3 X1 /\ auto___def_5 X2)
    (auto___def_3 X1 /\ auto___def_7 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_146 : forall X1 X2:term, auto___def_32 X2 -> auto___type_2 (key prv X1) -> auto___def_12 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_145 prv X1 H);  intros.
  apply (rem_140 X1 X2);  tauto.
  apply (rem_142 X1 X2);  tauto.
  apply (rem_144 X1 X2);  tauto.
Qed.

Remark rem_147 : forall X1 X2:term, auto___def_2 X1 -> auto___def_25 X2 -> auto___def_3 prv -> auto___def_12 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 prv -> False). tauto.
  exact (rem_138).
Qed.

Remark rem_148 : forall X1 X2:term, auto___def_3 prv -> auto___def_2 X1 -> auto___def_25 X2 -> auto___def_12 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_2 X1 -> auto___def_25 X2 -> auto___def_3 prv -> auto___def_12 X1 X2). tauto. exact (rem_147 X1 X2).
Qed.

Remark rem_149 : forall X1 X2:term, auto___def_25 X2 -> auto___def_3 prv -> auto___def_5 X1 -> auto___def_12 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 prv -> False). tauto.
  exact (rem_138).
Qed.

Remark rem_150 : forall X1 X2:term, auto___def_3 prv -> auto___def_5 X1 -> auto___def_25 X2 -> auto___def_12 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_25 X2 -> auto___def_3 prv -> auto___def_5 X1 -> auto___def_12 X1 X2). tauto. exact (rem_149 X1 X2).
Qed.

Remark rem_151 : forall X1 X2:term, auto___def_25 X2 -> auto___def_3 prv -> auto___def_7 X1 -> auto___def_12 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 prv -> False). tauto.
  exact (rem_138).
Qed.

Remark rem_152 : forall X1 X2:term, auto___def_3 prv -> auto___def_7 X1 -> auto___def_25 X2 -> auto___def_12 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_25 X2 -> auto___def_3 prv -> auto___def_7 X1 -> auto___def_12 X1 X2). tauto. exact (rem_151 X1 X2).
Qed.

Remark rem_153 : forall X1 X2:term, auto___type_4 (key X1 X2) -> or_3
    (auto___def_3 X1 /\ auto___def_2 X2)
    (auto___def_3 X1 /\ auto___def_5 X2)
    (auto___def_3 X1 /\ auto___def_7 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_154 : forall X1 X2:term, auto___def_25 X2 -> auto___type_4 (key prv X1) -> auto___def_12 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_153 prv X1 H);  intros.
  apply (rem_148 X1 X2);  tauto.
  apply (rem_150 X1 X2);  tauto.
  apply (rem_152 X1 X2);  tauto.
Qed.

Remark rem_155 : forall X1:term, auto___def_7 X1 -> auto___def_7 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_156 : forall X1 X2:term, auto___def_19 X2 -> auto___def_23 prv -> auto___def_7 X1 -> auto___def_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_7 X1 -> auto___def_7 X1). tauto. exact (rem_155 X1).
Qed.

Remark rem_157 : forall X2:term, auto___def_19 X2 -> auto___def_19 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_158 : forall X1 X2:term, auto___def_19 X2 -> auto___def_23 prv -> auto___def_7 X1 -> auto___def_19 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_19 X2). tauto. exact (rem_157 X2).
Qed.

Remark rem_159 : forall X1 X2:term, auto___def_19 X2 -> auto___def_23 prv -> auto___def_7 X1 -> (auto___def_7 X1 /\ auto___def_19 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_7 X1). 2:apply (rem_156 X1 X2);  assumption.
  cut (auto___def_19 X2). 2:apply (rem_158 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_160 : forall X1 X2:term, auto___def_19 X2 -> auto___def_23 prv -> auto___def_7 X1 -> auto___def_12 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_159 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_12_2;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_161 : forall X1 X2:term, auto___def_23 prv -> auto___def_7 X1 -> auto___def_19 X2 -> auto___def_12 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_23 prv -> auto___def_7 X1 -> auto___def_12 X1 X2). tauto. exact (rem_160 X1 X2).
Qed.

Remark rem_162 : forall X1 X2:term, auto___def_20 (key X1 X2) -> or_1
    (auto___def_23 X1 /\ auto___def_7 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_163 : forall X1 X2:term, auto___def_19 X2 -> auto___def_20 (key prv X1) -> auto___def_12 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_162 prv X1 H);  intros.
  apply (rem_161 X1 X2);  tauto.
Qed.

Remark rem_164 : forall X1:term, auto___def_36 X1 -> auto___def_36 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_165 : forall X1 X2:term, auto___def_23 prv -> auto___def_36 X1 -> auto_knows_old X2 -> auto___def_36 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_36 X1 -> auto___def_36 X1). tauto. exact (rem_164 X1).
Qed.

Remark rem_166 : forall X2:term, auto_knows_old X2 -> auto_knows_old X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_167 : forall X1 X2:term, auto___def_23 prv -> auto___def_36 X1 -> auto_knows_old X2 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_166 X2).
Qed.

Remark rem_168 : forall X1 X2:term, auto___def_23 prv -> auto___def_36 X1 -> auto_knows_old X2 -> (auto___def_36 X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_36 X1). 2:apply (rem_165 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_167 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_169 : forall X1 X2:term, auto___def_23 prv -> auto___def_36 X1 -> auto_knows_old X2 -> auto___def_12 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_168 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_12_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_170 : forall X1 X2:term, auto___def_3 prv -> auto_knows_old X2 -> auto___def_12 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 prv -> False). tauto.
  exact (rem_138).
Qed.

Remark rem_171 : forall X1 X2:term, auto___def_3 prv -> auto___type_9 X1 -> auto_knows_old X2 -> auto___def_12 X1 X2. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2. intros. apply (rem_170 X1 X2);  assumption.
Qed.

Inductive or_2(H1 H2:Prop) : Prop :=
    or_2_intro_1 : H1 -> (or_2 H1 H2)
  | or_2_intro_2 : H2 -> (or_2 H1 H2)
.

Remark rem_172 : forall X1 X2:term, auto_knows_old (key X1 X2) -> or_2
    (auto___def_23 X1 /\ auto___def_36 X2)
    (auto___def_3 X1 /\ auto___type_9 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_173 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old (key prv X1) -> auto___def_12 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_172 prv X1 H);  intros.
  apply (rem_169 X1 X2);  tauto.
  apply (rem_171 X1 X2);  tauto.
Qed.

Remark rem_174 : forall X1 X2:term, auto___def_2 X1 -> auto___def_3 prv -> auto___def_30 X2 -> auto___def_12 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 prv -> False). tauto.
  exact (rem_138).
Qed.

Remark rem_175 : forall X1 X2:term, auto___def_3 prv -> auto___def_2 X1 -> auto___def_30 X2 -> auto___def_12 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_2 X1 -> auto___def_3 prv -> auto___def_30 X2 -> auto___def_12 X1 X2). tauto. exact (rem_174 X1 X2).
Qed.

Remark rem_176 : forall X1 X2:term, auto___def_3 prv -> auto___def_30 X2 -> auto___def_5 X1 -> auto___def_12 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 prv -> False). tauto.
  exact (rem_138).
Qed.

Remark rem_177 : forall X1 X2:term, auto___def_3 prv -> auto___def_5 X1 -> auto___def_30 X2 -> auto___def_12 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_3 prv -> auto___def_30 X2 -> auto___def_5 X1 -> auto___def_12 X1 X2). tauto. exact (rem_176 X1 X2).
Qed.

Remark rem_178 : forall X1 X2:term, auto___def_3 prv -> auto___def_30 X2 -> auto___def_7 X1 -> auto___def_12 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 prv -> False). tauto.
  exact (rem_138).
Qed.

Remark rem_179 : forall X1 X2:term, auto___def_3 prv -> auto___def_7 X1 -> auto___def_30 X2 -> auto___def_12 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_3 prv -> auto___def_30 X2 -> auto___def_7 X1 -> auto___def_12 X1 X2). tauto. exact (rem_178 X1 X2).
Qed.

Remark rem_180 : forall X1 X2:term, auto___type_6 (key X1 X2) -> or_3
    (auto___def_3 X1 /\ auto___def_2 X2)
    (auto___def_3 X1 /\ auto___def_5 X2)
    (auto___def_3 X1 /\ auto___def_7 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_181 : forall X1 X2:term, auto___def_30 X2 -> auto___type_6 (key prv X1) -> auto___def_12 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_180 prv X1 H);  intros.
  apply (rem_175 X1 X2);  tauto.
  apply (rem_177 X1 X2);  tauto.
  apply (rem_179 X1 X2);  tauto.
Qed.

Inductive or_5(H1 H2 H3 H4 H5:Prop) : Prop :=
    or_5_intro_1 : H1 -> (or_5 H1 H2 H3 H4 H5)
  | or_5_intro_2 : H2 -> (or_5 H1 H2 H3 H4 H5)
  | or_5_intro_3 : H3 -> (or_5 H1 H2 H3 H4 H5)
  | or_5_intro_4 : H4 -> (or_5 H1 H2 H3 H4 H5)
  | or_5_intro_5 : H5 -> (or_5 H1 H2 H3 H4 H5)
.

Remark rem_182 : forall X1 X2:term, auto_knows_old (crypt X1 X2) -> or_5
    (auto___def_32 X1 /\ auto___type_2 X2)
    (auto___def_25 X1 /\ auto___type_4 X2)
    (auto___def_19 X1 /\ auto___def_20 X2)
    (auto_knows_old X1 /\ auto_knows_old X2)
    (auto___def_30 X1 /\ auto___type_6 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_5_intro_1; tauto.
  intros. apply or_5_intro_2; tauto.
  intros. apply or_5_intro_3; tauto.
  intros. apply or_5_intro_4; tauto.
  intros. apply or_5_intro_5; tauto.
Qed.

Remark rem_183 : forall X1 X2:term, auto_knows_old (crypt X2 (key prv X1)) -> auto___def_12 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_182 X2 (key prv X1) H);  intros.
  apply (rem_146 X1 X2);  tauto.
  apply (rem_154 X1 X2);  tauto.
  apply (rem_163 X1 X2);  tauto.
  apply (rem_173 X1 X2);  tauto.
  apply (rem_181 X1 X2);  tauto.
Qed.

Remark rem_184 : forall X1:term, auto___type_11 X1 -> auto___type_11 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_185 : forall X1 X2:term, auto___def_49 X2 -> auto___type_11 X1 -> auto___type_11 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_11 X1 -> auto___type_11 X1). tauto. exact (rem_184 X1).
Qed.

Remark rem_186 : forall X2:term, auto___def_49 X2 -> auto___def_49 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_187 : forall X1 X2:term, auto___def_49 X2 -> auto___type_11 X1 -> auto___def_49 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_49 X2 -> auto___def_49 X2). tauto. exact (rem_186 X2).
Qed.

Remark rem_188 : forall X1 X2:term, auto___def_49 X2 -> auto___type_11 X1 -> (auto___type_11 X1 /\ auto___def_49 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_11 X1). 2:apply (rem_185 X1 X2);  assumption.
  cut (auto___def_49 X2). 2:apply (rem_187 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_189 : forall X1 X2:term, auto___def_49 X2 -> auto___type_11 X1 -> auto___def_48 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_188 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_48_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_190 : forall X1 X2:term, auto___def_32 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_191 : forall X1 X2:term, auto___def_32 (cons X2 (cons X1 nil)) -> auto___def_24 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_190 X2 (cons X1 nil) H);  intros.
Qed.

Remark rem_192 : forall X1 X2:term, auto___def_32 (cons X2 (cons X1 nil)) -> auto___type_2 (key prv server) -> auto___def_24 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_32 (cons X2 (cons X1 nil)) -> auto___def_24 X1 X2). tauto.
  exact (rem_191 X1 X2).
Qed.

Remark rem_193 : auto___def_2 server -> auto___def_3 prv -> False. (* Split. *)
Proof.
 
  cut (auto___def_3 prv -> False). tauto.
  exact rem_138.
Qed.

Remark rem_194 : auto___def_3 prv -> auto___def_2 server -> False. (* Prove equivalent, normalized clause. *)
Proof.
  
  cut (auto___def_2 server -> auto___def_3 prv -> False). tauto. exact (rem_193).
Qed.

Remark rem_195 : auto___def_3 prv -> auto___def_5 server -> False. (* Split. *)
Proof.
 
  cut (auto___def_3 prv -> False). tauto.
  exact rem_138.
Qed.

Remark rem_196 : auto___def_3 prv -> auto___def_7 server -> False. (* Split. *)
Proof.
 
  cut (auto___def_3 prv -> False). tauto.
  exact rem_138.
Qed.

Remark rem_197 : auto___type_4 (key prv server) -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_153 prv server H);  intros.
  apply rem_194;  tauto.
  apply rem_195;  tauto.
  apply rem_196;  tauto.
Qed.

Remark rem_198 : forall X1 X2:term, auto___def_25 (cons X2 (cons X1 nil)) -> auto___type_4 (key prv server) -> auto___def_24 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___type_4 (key prv server) -> False). tauto.
  exact (rem_197).
Qed.

Remark rem_199 : forall X1:term, auto___type_3 X1 -> auto___type_3 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_200 : forall X1 X2:term, auto___def_22 nil -> auto___type_2 X2 -> auto___type_3 X1 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_3 X1 -> auto___type_3 X1). tauto. exact (rem_199 X1).
Qed.

Remark rem_201 : forall X2:term, auto___type_2 X2 -> auto___type_2 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_202 : forall X1 X2:term, auto___def_22 nil -> auto___type_2 X2 -> auto___type_3 X1 -> auto___type_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_2 X2 -> auto___type_2 X2). tauto. exact (rem_201 X2).
Qed.

Remark rem_203 : forall X1 X2:term, auto___def_22 nil -> auto___type_2 X2 -> auto___type_3 X1 -> (auto___type_3 X1 /\ auto___type_2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___type_3 X1). 2:apply (rem_200 X1 X2);  assumption.
  cut (auto___type_2 X2). 2:apply (rem_202 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_204 : forall X1 X2:term, auto___def_22 nil -> auto___type_2 X2 -> auto___type_3 X1 -> auto___def_24 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_203 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_24_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_205 : forall X1 X2:term, auto___type_3 X1 -> auto___def_22 nil -> auto___type_2 X2 -> auto___def_24 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_22 nil -> auto___type_2 X2 -> auto___type_3 X1 -> auto___def_24 X1 X2). tauto. exact (rem_204 X1 X2).
Qed.

Remark rem_206 : forall X1 X2:term, auto___def_21 (cons X1 X2) -> or_1
    (auto___type_3 X1 /\ auto___def_22 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_207 : forall X1 X2:term, auto___def_21 (cons X1 nil) -> auto___type_2 X2 -> auto___def_24 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_206 X1 nil H);  intros.
  apply (rem_205 X1 X2);  tauto.
Qed.

Remark rem_208 : forall X1 X2:term, auto___type_2 X2 -> auto___def_21 (cons X1 nil) -> auto___def_24 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_21 (cons X1 nil) -> auto___type_2 X2 -> auto___def_24 X1 X2). tauto. exact (rem_207 X1 X2).
Qed.

Remark rem_209 : forall X1 X2:term, auto___def_19 (cons X1 X2) -> or_1
    (auto___type_2 X1 /\ auto___def_21 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_210 : forall X1 X2:term, auto___def_19 (cons X2 (cons X1 nil)) -> auto___def_24 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_209 X2 (cons X1 nil) H);  intros.
  apply (rem_208 X1 X2);  tauto.
Qed.

Remark rem_211 : forall X1 X2:term, auto___def_19 (cons X2 (cons X1 nil)) -> auto___def_20 (key prv server) -> auto___def_24 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_19 (cons X2 (cons X1 nil)) -> auto___def_24 X1 X2). tauto.
  exact (rem_210 X1 X2).
Qed.

Remark rem_212 : auto___def_36 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_213 : auto___def_36 server -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_212 H);  intros.
Qed.

Remark rem_214 : auto___def_23 prv -> auto___def_36 server -> False. (* Split. *)
Proof.
 
  cut (auto___def_36 server -> False). tauto.
  exact rem_213.
Qed.

Remark rem_215 : auto___def_3 prv -> auto___type_9 server -> False. (* Eliminate negative atom by universal clause. *)
Proof.
  intros. apply rem_138;  assumption.
Qed.

Remark rem_216 : auto_knows_old (key prv server) -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_172 prv server H);  intros.
  apply rem_214;  tauto.
  apply rem_215;  tauto.
Qed.

Remark rem_217 : forall X1 X2:term, auto_knows_old (cons X2 (cons X1 nil)) -> auto_knows_old (key prv server) -> auto___def_24 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto_knows_old (key prv server) -> False). tauto.
  exact (rem_216).
Qed.

Remark rem_218 : auto___def_33 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_219 : auto___def_33 nil -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_218 H);  intros.
Qed.

Remark rem_220 : forall X1 X2:term, auto___def_32 X1 -> auto___def_33 nil -> auto___type_7 X2 -> auto___def_24 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_33 nil -> False). tauto.
  exact (rem_219).
Qed.

Remark rem_221 : forall X1 X2:term, auto___def_31 (cons X1 X2) -> or_1
    (auto___def_32 X1 /\ auto___def_33 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_222 : forall X1 X2:term, auto___def_31 (cons X1 nil) -> auto___type_7 X2 -> auto___def_24 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_221 X1 nil H);  intros.
  apply (rem_220 X1 X2);  tauto.
Qed.

Remark rem_223 : forall X1 X2:term, auto___type_7 X2 -> auto___def_31 (cons X1 nil) -> auto___def_24 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_31 (cons X1 nil) -> auto___type_7 X2 -> auto___def_24 X1 X2). tauto. exact (rem_222 X1 X2).
Qed.

Remark rem_224 : forall X1 X2:term, auto___def_30 (cons X1 X2) -> or_1
    (auto___type_7 X1 /\ auto___def_31 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_225 : forall X1 X2:term, auto___def_30 (cons X2 (cons X1 nil)) -> auto___def_24 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_224 X2 (cons X1 nil) H);  intros.
  apply (rem_223 X1 X2);  tauto.
Qed.

Remark rem_226 : forall X1 X2:term, auto___def_30 (cons X2 (cons X1 nil)) -> auto___type_6 (key prv server) -> auto___def_24 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_30 (cons X2 (cons X1 nil)) -> auto___def_24 X1 X2). tauto.
  exact (rem_225 X1 X2).
Qed.

Remark rem_227 : forall X1 X2:term, auto_knows_old (crypt (cons X2 (cons X1 nil)) (key prv server)) -> auto___def_24 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_182 (cons X2 (cons X1 nil)) (key prv server) H);  intros.
  apply (rem_192 X1 X2);  tauto.
  apply (rem_198 X1 X2);  tauto.
  apply (rem_211 X1 X2);  tauto.
  apply (rem_217 X1 X2);  tauto.
  apply (rem_226 X1 X2);  tauto.
Qed.

Remark rem_228 : auto___def_23 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_229 : auto___def_23 sym -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_228 H);  intros.
Qed.

Remark rem_230 : forall X1:term, auto___def_23 sym -> auto___def_36 X1 -> auto___def_44 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_23 sym -> False). tauto.
  exact (rem_229).
Qed.

Remark rem_231 : auto___def_3 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_232 : auto___def_3 sym -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_231 H);  intros.
Qed.

Remark rem_233 : forall X1:term, auto___def_3 sym -> auto___def_44 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_3 sym -> False). tauto.
  exact (rem_232).
Qed.

Remark rem_234 : forall X1:term, auto___def_3 sym -> auto___type_9 X1 -> auto___def_44 X1. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1. intros. apply (rem_233 X1);  assumption.
Qed.

Remark rem_235 : (forall X:term, auto___def_38 X -> auto___def_44 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_38_p__def_44.  tauto.
Defined.

Remark rem_236 : (forall X:term, auto___def_38 X -> auto___def_44 X)
    -> forall X1 X2 X3:term, auto___def_44 (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_38_p__def_44. intros X1 X2 X3.  case (rem_235 epsilon_m__def_38_p__def_44). clear  epsilon_m__def_38_p__def_44. intros. apply trans___def_44_session_old_1;  tauto.
 clear  epsilon_m__def_38_p__def_44. tauto.
Defined.

Remark rem_237 : forall X1 X2 X3:term, auto___def_38 (session_old X1 X2 X3) -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_238 : (forall X:term, auto___def_38 X -> auto___def_44 X)
    -> forall X1 X2 X3:term, auto___def_38 (session_old X1 X2 X3) -> auto___def_44 (session_old X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_38_p__def_44. intros X1 X2 X3. intro H. intros.
  elim (rem_237 X1 X2 X3 H);  intros.
  apply (rem_236 epsilon_m__def_38_p__def_44 X1 X2 X3);  tauto.
Defined.

Remark rem_239 : forall X1:term, auto___def_38 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_240 : auto___def_38 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_241 : auto___def_38 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_242 : auto___def_38 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_243 : forall X1 X2 X3:term, auto___def_38 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_244 : forall X1 X2:term, auto___def_38 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_245 : forall X1 X2:term, auto___def_38 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_246 : forall X1 X2:term, auto___def_38 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_247 : auto___def_38 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_248 : forall X1 X2 X3:term, auto___def_38 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_249 : auto___def_38 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_250 : forall X1 X2 X3 X4:term, auto___def_38 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_251 : auto___def_38 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_252 : forall X1 X2 X3 X4:term, auto___def_38 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_253 : auto___def_38 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_254 : auto___def_38 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_255 : auto___def_38 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_256 : forall X1:term, auto___def_38 X1 -> auto___def_44 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_38_p__def_44 1.
  intro X. case X.
   intro H. elim (rem_249  H).
   intro H. elim (rem_247  H).
  intros X1 X2. intro H. elim (rem_244 X1 X2 H).
  intros X1 X2. intro H. elim (rem_245 X1 X2 H).
   intro H. elim (rem_241  H).
   intro H. elim (rem_253  H).
  intros X1 X2. intro H. elim (rem_246 X1 X2 H).
   intro H. elim (rem_240  H).
  intros X1 X2 X3. intro H. elim (rem_243 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_248 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_252 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_250 X1 X2 X3 X4 H).
   intro H. elim (rem_255  H).
   intro H. elim (rem_251  H).
  intros X1. intro H. elim (rem_239 X1 H).
   intro H. elim (rem_254  H).
  intros X1 X2 X3;  exact (rem_238 epsilon_m__def_38_p__def_44 X1 X2 X3).
   intro H. elim (rem_242  H).
Qed.

Remark rem_257 : forall X1:term, auto___def_37 sym -> auto___def_38 X1 -> auto___def_44 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1.
  cut (auto___def_38 X1 -> auto___def_44 X1). tauto. exact (rem_256 X1).
Qed.

Remark rem_258 : forall X1 X2:term, auto_knows_current (key X1 X2) -> or_3
    (auto___def_23 X1 /\ auto___def_36 X2)
    (auto___def_3 X1 /\ auto___type_9 X2)
    (auto___def_37 X1 /\ auto___def_38 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_259 : forall X1:term, auto_knows_current (key sym X1) -> auto___def_44 X1. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_258 sym X1 H);  intros.
  apply (rem_230 X1);  tauto.
  apply (rem_234 X1);  tauto.
  apply (rem_257 X1);  tauto.
Qed.

Remark rem_260 : forall X1 X2 X3:term, auto___type_10 X3 -> auto___type_11 X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_1 X1).
Qed.

Remark rem_261 : forall X2:term, auto___type_11 X2 -> auto___type_11 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_262 : forall X1 X2 X3:term, auto___type_10 X3 -> auto___type_11 X2 -> auto_agent X1 -> auto___type_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___type_11 X2 -> auto___type_11 X2). tauto. exact (rem_261 X2).
Qed.

Remark rem_263 : forall X3:term, auto___type_10 X3 -> auto___type_10 X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_264 : forall X1 X2 X3:term, auto___type_10 X3 -> auto___type_11 X2 -> auto_agent X1 -> auto___type_10 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___type_10 X3 -> auto___type_10 X3). tauto. exact (rem_263 X3).
Qed.

Remark rem_265 : forall X1 X2 X3:term, auto___type_10 X3 -> auto___type_11 X2 -> auto_agent X1 -> (auto_agent X1 /\ auto___type_11 X2 /\ auto___type_10 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  cut (auto_agent X1). 2:apply (rem_260 X1 X2 X3);  assumption.
  cut (auto___type_11 X2). 2:apply (rem_262 X1 X2 X3);  assumption.
  cut (auto___type_10 X3). 2:apply (rem_264 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_266 : forall X1 X2 X3:term, auto___type_10 X3 -> auto___type_11 X2 -> auto_agent X1 -> auto___def_52 (noncea_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  case (rem_265 X1 X2 X3 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_52_noncea_current_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_267 : forall X1 X2 X3:term, auto___type_11 X2 -> auto___type_10 X3 -> auto_agent X1 -> auto___def_52 (noncea_current X1 X2 X3). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___type_10 X3 -> auto___type_11 X2 -> auto_agent X1 -> auto___def_52 (noncea_current X1 X2 X3)). tauto. exact (rem_266 X1 X2 X3).
Qed.

Remark rem_268 : forall X1 X2:term, auto___def_50 X1 X2 -> or_1
    (auto___type_11 X1 /\ auto___type_10 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_269 : forall X1 X2 X3:term, auto___def_50 X2 X3 -> auto_agent X1 -> auto___def_52 (noncea_current X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_268 X2 X3 H);  intros.
  apply (rem_267 X1 X2 X3);  tauto.
Qed.

Remark rem_270 : forall X1 X2 X3 X4:term, auto___type_2 X3 -> auto___type_3 X1 -> auto___type_9 X2 -> auto_agent X2 -> auto_knows_current X4 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_3 X1 -> auto___type_3 X1). tauto. exact (rem_199 X1).
Qed.

Remark rem_271 : forall X1 X2 X3 X4:term, auto___type_2 X3 -> auto___type_3 X1 -> auto___type_9 X2 -> auto_agent X2 -> auto_knows_current X4 -> auto___type_9 X2. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Qed.

Remark rem_272 : forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_273 : forall X1 X2 X3 X4:term, auto___type_2 X3 -> auto___type_3 X1 -> auto___type_9 X2 -> auto_agent X2 -> auto_knows_current X4 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_272 X2).
Qed.

Remark rem_274 : forall X3:term, auto___type_2 X3 -> auto___type_2 X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_275 : forall X1 X2 X3 X4:term, auto___type_2 X3 -> auto___type_3 X1 -> auto___type_9 X2 -> auto_agent X2 -> auto_knows_current X4 -> auto___type_2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_2 X3 -> auto___type_2 X3). tauto. exact (rem_274 X3).
Qed.

Remark rem_276 : forall X4:term, auto_knows_current X4 -> auto_knows_current X4. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_277 : forall X1 X2 X3 X4:term, auto___type_2 X3 -> auto___type_3 X1 -> auto___type_9 X2 -> auto_agent X2 -> auto_knows_current X4 -> auto_knows_current X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X4 -> auto_knows_current X4). tauto. exact (rem_276 X4).
Qed.

Remark rem_278 : forall X1 X2 X3 X4:term, auto___type_2 X3 -> auto___type_3 X1 -> auto___type_9 X2 -> auto_agent X2 -> auto_knows_current X4 -> (auto___type_3 X1 /\ auto___type_9 X2 /\ auto_agent X2 /\ auto___type_2 X3 /\ auto_knows_current X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5.
  cut (auto___type_3 X1). 2:apply (rem_270 X1 X2 X3 X4);  assumption.
  cut (auto___type_9 X2). 2:apply (rem_271 X1 X2 X3 X4);  assumption.
  cut (auto_agent X2). 2:apply (rem_273 X1 X2 X3 X4);  assumption.
  cut (auto___type_2 X3). 2:apply (rem_275 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X4). 2:apply (rem_277 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_279 : forall X1 X2 X3 X4:term, auto___type_2 X3 -> auto___type_3 X1 -> auto___type_9 X2 -> auto_agent X2 -> auto_knows_current X4 -> auto___def_57 (nonceb_current X1 X2 X3 X4). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5.
  case (rem_278 X1 X2 X3 X4 A1 A2 A3 A4 A5). clear  A1 A2 A3 A4 A5. intros. apply trans___def_57_nonceb_current_3;  tauto.
 clear  A1 A2 A3 A4 A5. tauto.
Qed.

Remark rem_280 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto___type_9 X2 -> auto_agent X2 -> auto_knows_current X4 -> auto___type_2 X3 -> auto___def_57 (nonceb_current X1 X2 X3 X4). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___type_2 X3 -> auto___type_3 X1 -> auto___type_9 X2 -> auto_agent X2 -> auto_knows_current X4 -> auto___def_57 (nonceb_current X1 X2 X3 X4)). tauto. exact (rem_279 X1 X2 X3 X4).
Qed.

Remark rem_281 : (forall X:term, auto___type_11 X -> auto___type_3 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_11_p__type_3.  tauto.
Defined.

Remark rem_282 : (forall X:term, auto___type_11 X -> auto___type_3 X)
    -> auto___type_3 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_11_p__type_3.  case (rem_281 epsilon_m__type_11_p__type_3). clear  epsilon_m__type_11_p__type_3. intros. apply trans___type_3_bob_1;  tauto.
 clear  epsilon_m__type_11_p__type_3. tauto.
Defined.

Remark rem_283 : auto___type_11 bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_284 : (forall X:term, auto___type_11 X -> auto___type_3 X)
    -> auto___type_11 bob -> auto___type_3 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_11_p__type_3. intro H. intros.
  elim (rem_283 H);  intros.
  apply (rem_282 epsilon_m__type_11_p__type_3);  tauto.
Defined.

Remark rem_285 : (forall X:term, auto___type_11 X -> auto___type_3 X)
    -> auto___type_3 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_11_p__type_3.  case (rem_281 epsilon_m__type_11_p__type_3). clear  epsilon_m__type_11_p__type_3. intros. apply trans___type_3_alice_1;  tauto.
 clear  epsilon_m__type_11_p__type_3. tauto.
Defined.

Remark rem_286 : auto___type_11 alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_287 : (forall X:term, auto___type_11 X -> auto___type_3 X)
    -> auto___type_11 alice -> auto___type_3 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_11_p__type_3. intro H. intros.
  elim (rem_286 H);  intros.
  apply (rem_285 epsilon_m__type_11_p__type_3);  tauto.
Defined.

Remark rem_288 : (forall X:term, auto___type_11 X -> auto___type_3 X)
    -> auto___type_3 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_11_p__type_3.  case (rem_281 epsilon_m__type_11_p__type_3). clear  epsilon_m__type_11_p__type_3. intros. apply trans___type_3_server_1;  tauto.
 clear  epsilon_m__type_11_p__type_3. tauto.
Defined.

Remark rem_289 : auto___type_11 server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_290 : (forall X:term, auto___type_11 X -> auto___type_3 X)
    -> auto___type_11 server -> auto___type_3 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_11_p__type_3. intro H. intros.
  elim (rem_289 H);  intros.
  apply (rem_288 epsilon_m__type_11_p__type_3);  tauto.
Defined.

Remark rem_291 : forall X1:term, auto___type_11 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_292 : auto___type_11 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_293 : auto___type_11 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_294 : forall X1 X2 X3:term, auto___type_11 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_295 : auto___type_11 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_296 : forall X1 X2 X3:term, auto___type_11 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_297 : forall X1 X2:term, auto___type_11 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_298 : forall X1 X2:term, auto___type_11 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_299 : forall X1 X2:term, auto___type_11 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_300 : forall X1 X2 X3:term, auto___type_11 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_301 : forall X1 X2 X3 X4:term, auto___type_11 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_302 : auto___type_11 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_303 : forall X1 X2 X3 X4:term, auto___type_11 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_304 : auto___type_11 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_305 : auto___type_11 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_306 : forall X1:term, auto___type_11 X1 -> auto___type_3 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_11_p__type_3 1.
  intro X. case X.
  exact (rem_287 epsilon_m__type_11_p__type_3 ).
  exact (rem_284 epsilon_m__type_11_p__type_3 ).
  intros X1 X2. intro H. elim (rem_297 X1 X2 H).
  intros X1 X2. intro H. elim (rem_298 X1 X2 H).
   intro H. elim (rem_293  H).
   intro H. elim (rem_304  H).
  intros X1 X2. intro H. elim (rem_299 X1 X2 H).
   intro H. elim (rem_292  H).
  intros X1 X2 X3. intro H. elim (rem_296 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_300 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_303 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_301 X1 X2 X3 X4 H).
   intro H. elim (rem_305  H).
   intro H. elim (rem_302  H).
  intros X1. intro H. elim (rem_291 X1 H).
  exact (rem_290 epsilon_m__type_11_p__type_3 ).
  intros X1 X2 X3. intro H. elim (rem_294 X1 X2 X3 H).
   intro H. elim (rem_295  H).
Qed.

Remark rem_307 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_52 X4 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_11 X1 -> auto___type_3 X1). tauto. exact (rem_306 X1).
Qed.

Remark rem_308 : (forall X:term, auto___type_11 X -> auto_agent X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_11_pagent.  tauto.
Defined.

Remark rem_309 : (forall X:term, auto___type_11 X -> auto_agent X)
    -> auto_agent bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_11_pagent.  case (rem_308 epsilon_m__type_11_pagent). clear  epsilon_m__type_11_pagent. intros. apply trans_agent_bob_1;  tauto.
 clear  epsilon_m__type_11_pagent. tauto.
Defined.

Remark rem_310 : (forall X:term, auto___type_11 X -> auto_agent X)
    -> auto___type_11 bob -> auto_agent bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_11_pagent. intro H. intros.
  elim (rem_283 H);  intros.
  apply (rem_309 epsilon_m__type_11_pagent);  tauto.
Defined.

Remark rem_311 : (forall X:term, auto___type_11 X -> auto_agent X)
    -> auto_agent alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_11_pagent.  case (rem_308 epsilon_m__type_11_pagent). clear  epsilon_m__type_11_pagent. intros. apply trans_agent_alice_1;  tauto.
 clear  epsilon_m__type_11_pagent. tauto.
Defined.

Remark rem_312 : (forall X:term, auto___type_11 X -> auto_agent X)
    -> auto___type_11 alice -> auto_agent alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_11_pagent. intro H. intros.
  elim (rem_286 H);  intros.
  apply (rem_311 epsilon_m__type_11_pagent);  tauto.
Defined.

Remark rem_313 : (forall X:term, auto___type_11 X -> auto_agent X)
    -> auto_agent server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_11_pagent.  case (rem_308 epsilon_m__type_11_pagent). clear  epsilon_m__type_11_pagent. intros. apply trans_agent_server_1;  tauto.
 clear  epsilon_m__type_11_pagent. tauto.
Defined.

Remark rem_314 : (forall X:term, auto___type_11 X -> auto_agent X)
    -> auto___type_11 server -> auto_agent server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_11_pagent. intro H. intros.
  elim (rem_289 H);  intros.
  apply (rem_313 epsilon_m__type_11_pagent);  tauto.
Defined.

Remark rem_315 : forall X1:term, auto___type_11 X1 -> auto_agent X1. (* Induct. *)
Proof.
  fix epsilon_m__type_11_pagent 1.
  intro X. case X.
  exact (rem_312 epsilon_m__type_11_pagent ).
  exact (rem_310 epsilon_m__type_11_pagent ).
  intros X1 X2. intro H. elim (rem_297 X1 X2 H).
  intros X1 X2. intro H. elim (rem_298 X1 X2 H).
   intro H. elim (rem_293  H).
   intro H. elim (rem_304  H).
  intros X1 X2. intro H. elim (rem_299 X1 X2 H).
   intro H. elim (rem_292  H).
  intros X1 X2 X3. intro H. elim (rem_296 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_300 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_303 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_301 X1 X2 X3 X4 H).
   intro H. elim (rem_305  H).
   intro H. elim (rem_302  H).
  intros X1. intro H. elim (rem_291 X1 H).
  exact (rem_314 epsilon_m__type_11_pagent ).
  intros X1 X2 X3. intro H. elim (rem_294 X1 X2 X3 H).
   intro H. elim (rem_295  H).
Qed.

Remark rem_316 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_52 X4 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_11 X1 -> auto_agent X1). tauto. exact (rem_315 X1).
Qed.

Remark rem_317 : (forall X:term, auto___def_2 X -> auto_agent X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_2_pagent.  tauto.
Defined.

Remark rem_318 : (forall X:term, auto___def_2 X -> auto_agent X)
    -> auto_agent alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_2_pagent.  case (rem_317 epsilon_m__def_2_pagent). clear  epsilon_m__def_2_pagent. intros. apply trans_agent_alice_1;  tauto.
 clear  epsilon_m__def_2_pagent. tauto.
Defined.

Remark rem_319 : (forall X:term, auto___def_2 X -> auto_agent X)
    -> auto___def_2 alice -> auto_agent alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_2_pagent. intro H. intros.
  elim (rem_9 H);  intros.
  apply (rem_318 epsilon_m__def_2_pagent);  tauto.
Defined.

Remark rem_320 : forall X2:term, auto___def_2 X2 -> auto_agent X2. (* Induct. *)
Proof.
  fix epsilon_m__def_2_pagent 1.
  intro X. case X.
  exact (rem_319 epsilon_m__def_2_pagent ).
   intro H. elim (rem_20  H).
  intros X1 X2. intro H. elim (rem_17 X1 X2 H).
  intros X1 X2. intro H. elim (rem_18 X1 X2 H).
   intro H. elim (rem_13  H).
   intro H. elim (rem_25  H).
  intros X1 X2. intro H. elim (rem_19 X1 X2 H).
   intro H. elim (rem_12  H).
  intros X1 X2 X3. intro H. elim (rem_16 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_21 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_24 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_22 X1 X2 X3 X4 H).
   intro H. elim (rem_27  H).
   intro H. elim (rem_23  H).
  intros X1. intro H. elim (rem_11 X1 H).
   intro H. elim (rem_26  H).
  intros X1 X2 X3. intro H. elim (rem_14 X1 X2 X3 H).
   intro H. elim (rem_15  H).
Qed.

Remark rem_321 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_52 X4 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto_agent X2). tauto. exact (rem_320 X2).
Qed.

Remark rem_322 : forall X2:term, auto___def_2 X2 -> auto___def_2 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_323 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_52 X4 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_2 X2). tauto. exact (rem_322 X2).
Qed.

Remark rem_324 : (forall X:term, auto___type_10 X -> auto___type_2 X)
    -> forall X1:term, auto___def_3 X1 -> auto___def_3 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_325 : (forall X:term, auto___type_10 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_10_p__type_2. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_324 epsilon_m__type_10_p__type_2 X1).
Defined.

Remark rem_326 : (forall X:term, auto___type_10 X -> auto___type_2 X)
    -> forall X2:term, auto___def_2 X2 -> auto___def_2 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_327 : (forall X:term, auto___type_10 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___def_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_10_p__type_2. intros X1 X2.
  cut (auto___def_2 X2 -> auto___def_2 X2). tauto. exact (rem_326 epsilon_m__type_10_p__type_2 X2).
Defined.

Remark rem_328 : (forall X:term, auto___type_10 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> (auto___def_3 X1 /\ auto___def_2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_10_p__type_2. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_325 epsilon_m__type_10_p__type_2 X1 X2);  assumption.
  cut (auto___def_2 X2). 2:apply (rem_327 epsilon_m__type_10_p__type_2 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_329 : (forall X:term, auto___type_10 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___type_2 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_10_p__type_2. intros X1 X2. intros A1 A2.
  case (rem_328 epsilon_m__type_10_p__type_2 X1 X2 A1 A2). clear  epsilon_m__type_10_p__type_2 A1 A2. intros. apply trans___type_2_key_1;  tauto.
 clear  epsilon_m__type_10_p__type_2 A1 A2. tauto.
Defined.

Remark rem_330 : (forall X:term, auto___type_10 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_10_p__type_2. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_324 epsilon_m__type_10_p__type_2 X1).
Defined.

Remark rem_331 : (forall X:term, auto___type_10 X -> auto___type_2 X)
    -> forall X2:term, auto___def_5 X2 -> auto___def_5 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_332 : (forall X:term, auto___type_10 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___def_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_10_p__type_2. intros X1 X2.
  cut (auto___def_5 X2 -> auto___def_5 X2). tauto. exact (rem_331 epsilon_m__type_10_p__type_2 X2).
Defined.

Remark rem_333 : (forall X:term, auto___type_10 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> (auto___def_3 X1 /\ auto___def_5 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_10_p__type_2. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_330 epsilon_m__type_10_p__type_2 X1 X2);  assumption.
  cut (auto___def_5 X2). 2:apply (rem_332 epsilon_m__type_10_p__type_2 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_334 : (forall X:term, auto___type_10 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___type_2 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_10_p__type_2. intros X1 X2. intros A1 A2.
  case (rem_333 epsilon_m__type_10_p__type_2 X1 X2 A1 A2). clear  epsilon_m__type_10_p__type_2 A1 A2. intros. apply trans___type_2_key_2;  tauto.
 clear  epsilon_m__type_10_p__type_2 A1 A2. tauto.
Defined.

Remark rem_335 : (forall X:term, auto___type_10 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_10_p__type_2. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_324 epsilon_m__type_10_p__type_2 X1).
Defined.

Remark rem_336 : (forall X:term, auto___type_10 X -> auto___type_2 X)
    -> forall X2:term, auto___def_7 X2 -> auto___def_7 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_337 : (forall X:term, auto___type_10 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___def_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_10_p__type_2. intros X1 X2.
  cut (auto___def_7 X2 -> auto___def_7 X2). tauto. exact (rem_336 epsilon_m__type_10_p__type_2 X2).
Defined.

Remark rem_338 : (forall X:term, auto___type_10 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> (auto___def_3 X1 /\ auto___def_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_10_p__type_2. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_335 epsilon_m__type_10_p__type_2 X1 X2);  assumption.
  cut (auto___def_7 X2). 2:apply (rem_337 epsilon_m__type_10_p__type_2 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_339 : (forall X:term, auto___type_10 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___type_2 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_10_p__type_2. intros X1 X2. intros A1 A2.
  case (rem_338 epsilon_m__type_10_p__type_2 X1 X2 A1 A2). clear  epsilon_m__type_10_p__type_2 A1 A2. intros. apply trans___type_2_key_3;  tauto.
 clear  epsilon_m__type_10_p__type_2 A1 A2. tauto.
Defined.

Remark rem_340 : forall X1 X2:term, auto___type_10 (key X1 X2) -> or_3
    (auto___def_3 X1 /\ auto___def_2 X2)
    (auto___def_3 X1 /\ auto___def_5 X2)
    (auto___def_3 X1 /\ auto___def_7 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_341 : (forall X:term, auto___type_10 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___type_10 (key X1 X2) -> auto___type_2 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_10_p__type_2. intros X1 X2. intro H. intros.
  elim (rem_340 X1 X2 H);  intros.
  apply (rem_329 epsilon_m__type_10_p__type_2 X1 X2);  tauto.
  apply (rem_334 epsilon_m__type_10_p__type_2 X1 X2);  tauto.
  apply (rem_339 epsilon_m__type_10_p__type_2 X1 X2);  tauto.
Defined.

Remark rem_342 : forall X1:term, auto___type_10 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_343 : auto___type_10 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_344 : auto___type_10 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_345 : forall X1 X2 X3:term, auto___type_10 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_346 : auto___type_10 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_347 : forall X1 X2 X3:term, auto___type_10 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_348 : forall X1 X2:term, auto___type_10 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_349 : forall X1 X2:term, auto___type_10 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_350 : auto___type_10 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_351 : forall X1 X2 X3:term, auto___type_10 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_352 : auto___type_10 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_353 : forall X1 X2 X3 X4:term, auto___type_10 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_354 : auto___type_10 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_355 : forall X1 X2 X3 X4:term, auto___type_10 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_356 : auto___type_10 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_357 : auto___type_10 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_358 : auto___type_10 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_359 : forall X3:term, auto___type_10 X3 -> auto___type_2 X3. (* Induct. *)
Proof.
  fix epsilon_m__type_10_p__type_2 1.
  intro X. case X.
   intro H. elim (rem_352  H).
   intro H. elim (rem_350  H).
  intros X1 X2. intro H. elim (rem_348 X1 X2 H).
  intros X1 X2. intro H. elim (rem_349 X1 X2 H).
   intro H. elim (rem_344  H).
   intro H. elim (rem_356  H).
  intros X1 X2;  exact (rem_341 epsilon_m__type_10_p__type_2 X1 X2).
   intro H. elim (rem_343  H).
  intros X1 X2 X3. intro H. elim (rem_347 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_351 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_355 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_353 X1 X2 X3 X4 H).
   intro H. elim (rem_358  H).
   intro H. elim (rem_354  H).
  intros X1. intro H. elim (rem_342 X1 H).
   intro H. elim (rem_357  H).
  intros X1 X2 X3. intro H. elim (rem_345 X1 X2 X3 H).
   intro H. elim (rem_346  H).
Qed.

Remark rem_360 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_52 X4 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_10 X3 -> auto___type_2 X3). tauto. exact (rem_359 X3).
Qed.

Remark rem_361 : forall X4:term, auto___def_52 X4 -> auto___def_52 X4. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_362 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_52 X4 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_52 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_52 X4 -> auto___def_52 X4). tauto. exact (rem_361 X4).
Qed.

Remark rem_363 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_52 X4 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> (auto___type_3 X1 /\ auto_agent X1 /\ auto_agent X2 /\ auto___def_2 X2 /\ auto___type_2 X3 /\ auto___def_52 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  cut (auto___type_3 X1). 2:apply (rem_307 X1 X2 X3 X4);  assumption.
  cut (auto_agent X1). 2:apply (rem_316 X1 X2 X3 X4);  assumption.
  cut (auto_agent X2). 2:apply (rem_321 X1 X2 X3 X4);  assumption.
  cut (auto___def_2 X2). 2:apply (rem_323 X1 X2 X3 X4);  assumption.
  cut (auto___type_2 X3). 2:apply (rem_360 X1 X2 X3 X4);  assumption.
  cut (auto___def_52 X4). 2:apply (rem_362 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_364 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_52 X4 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_57 (nonceb_current X1 X2 X3 X4). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  case (rem_363 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6). clear  A1 A2 A3 A4 A5 A6. intros. apply trans___def_57_nonceb_current_4;  tauto.
 clear  A1 A2 A3 A4 A5 A6. tauto.
Qed.

Remark rem_365 : forall X1 X2 X3 X4:term, auto___type_11 X1 -> auto_agent X1 -> auto_agent X2 -> auto___def_2 X2 -> auto___def_52 X4 -> auto___type_10 X3 -> auto___def_57 (nonceb_current X1 X2 X3 X4). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_52 X4 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_57 (nonceb_current X1 X2 X3 X4)). tauto. exact (rem_364 X1 X2 X3 X4).
Qed.

Remark rem_366 : forall X1 X2 X3 X4:term, auto___def_52 X4 -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_3 X1 -> auto___type_3 X1). tauto. exact (rem_199 X1).
Qed.

Remark rem_367 : (forall X:term, auto___type_3 X -> auto_agent X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pagent.  tauto.
Defined.

Remark rem_368 : (forall X:term, auto___type_3 X -> auto_agent X)
    -> auto_agent bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pagent.  case (rem_367 epsilon_m__type_3_pagent). clear  epsilon_m__type_3_pagent. intros. apply trans_agent_bob_1;  tauto.
 clear  epsilon_m__type_3_pagent. tauto.
Defined.

Remark rem_369 : auto___type_3 bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_370 : (forall X:term, auto___type_3 X -> auto_agent X)
    -> auto___type_3 bob -> auto_agent bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pagent. intro H. intros.
  elim (rem_369 H);  intros.
  apply (rem_368 epsilon_m__type_3_pagent);  tauto.
Defined.

Remark rem_371 : (forall X:term, auto___type_3 X -> auto_agent X)
    -> auto_agent alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pagent.  case (rem_367 epsilon_m__type_3_pagent). clear  epsilon_m__type_3_pagent. intros. apply trans_agent_alice_1;  tauto.
 clear  epsilon_m__type_3_pagent. tauto.
Defined.

Remark rem_372 : auto___type_3 alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_373 : (forall X:term, auto___type_3 X -> auto_agent X)
    -> auto___type_3 alice -> auto_agent alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pagent. intro H. intros.
  elim (rem_372 H);  intros.
  apply (rem_371 epsilon_m__type_3_pagent);  tauto.
Defined.

Remark rem_374 : (forall X:term, auto___type_3 X -> auto_agent X)
    -> auto_agent server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pagent.  case (rem_367 epsilon_m__type_3_pagent). clear  epsilon_m__type_3_pagent. intros. apply trans_agent_server_1;  tauto.
 clear  epsilon_m__type_3_pagent. tauto.
Defined.

Remark rem_375 : auto___type_3 server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_376 : (forall X:term, auto___type_3 X -> auto_agent X)
    -> auto___type_3 server -> auto_agent server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pagent. intro H. intros.
  elim (rem_375 H);  intros.
  apply (rem_374 epsilon_m__type_3_pagent);  tauto.
Defined.

Remark rem_377 : forall X1:term, auto___type_3 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_378 : auto___type_3 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_379 : auto___type_3 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_380 : forall X1 X2 X3:term, auto___type_3 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_381 : auto___type_3 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_382 : forall X1 X2 X3:term, auto___type_3 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_383 : forall X1 X2:term, auto___type_3 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_384 : forall X1 X2:term, auto___type_3 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_385 : forall X1 X2:term, auto___type_3 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_386 : forall X1 X2 X3:term, auto___type_3 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_387 : forall X1 X2 X3 X4:term, auto___type_3 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_388 : auto___type_3 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_389 : forall X1 X2 X3 X4:term, auto___type_3 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_390 : auto___type_3 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_391 : auto___type_3 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_392 : forall X1:term, auto___type_3 X1 -> auto_agent X1. (* Induct. *)
Proof.
  fix epsilon_m__type_3_pagent 1.
  intro X. case X.
  exact (rem_373 epsilon_m__type_3_pagent ).
  exact (rem_370 epsilon_m__type_3_pagent ).
  intros X1 X2. intro H. elim (rem_383 X1 X2 H).
  intros X1 X2. intro H. elim (rem_384 X1 X2 H).
   intro H. elim (rem_379  H).
   intro H. elim (rem_390  H).
  intros X1 X2. intro H. elim (rem_385 X1 X2 H).
   intro H. elim (rem_378  H).
  intros X1 X2 X3. intro H. elim (rem_382 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_386 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_389 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_387 X1 X2 X3 X4 H).
   intro H. elim (rem_391  H).
   intro H. elim (rem_388  H).
  intros X1. intro H. elim (rem_377 X1 H).
  exact (rem_376 epsilon_m__type_3_pagent ).
  intros X1 X2 X3. intro H. elim (rem_380 X1 X2 X3 H).
   intro H. elim (rem_381  H).
Qed.

Remark rem_393 : forall X1 X2 X3 X4:term, auto___def_52 X4 -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_3 X1 -> auto_agent X1). tauto. exact (rem_392 X1).
Qed.

Remark rem_394 : forall X2:term, auto___def_7 X2 -> auto___def_7 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_395 : forall X1 X2 X3 X4:term, auto___def_52 X4 -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_7 X2 -> auto___def_7 X2). tauto. exact (rem_394 X2).
Qed.

Remark rem_396 : (forall X:term, auto___def_7 X -> auto_agent X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_7_pagent.  tauto.
Defined.

Remark rem_397 : (forall X:term, auto___def_7 X -> auto_agent X)
    -> auto_agent server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_7_pagent.  case (rem_396 epsilon_m__def_7_pagent). clear  epsilon_m__def_7_pagent. intros. apply trans_agent_server_1;  tauto.
 clear  epsilon_m__def_7_pagent. tauto.
Defined.

Remark rem_398 : (forall X:term, auto___def_7 X -> auto_agent X)
    -> auto___def_7 server -> auto_agent server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_7_pagent. intro H. intros.
  elim (rem_81 H);  intros.
  apply (rem_397 epsilon_m__def_7_pagent);  tauto.
Defined.

Remark rem_399 : forall X2:term, auto___def_7 X2 -> auto_agent X2. (* Induct. *)
Proof.
  fix epsilon_m__def_7_pagent 1.
  intro X. case X.
   intro H. elim (rem_94  H).
   intro H. elim (rem_92  H).
  intros X1 X2. intro H. elim (rem_89 X1 X2 H).
  intros X1 X2. intro H. elim (rem_90 X1 X2 H).
   intro H. elim (rem_85  H).
   intro H. elim (rem_98  H).
  intros X1 X2. intro H. elim (rem_91 X1 X2 H).
   intro H. elim (rem_84  H).
  intros X1 X2 X3. intro H. elim (rem_88 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_93 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_97 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_95 X1 X2 X3 X4 H).
   intro H. elim (rem_99  H).
   intro H. elim (rem_96  H).
  intros X1. intro H. elim (rem_83 X1 H).
  exact (rem_398 epsilon_m__def_7_pagent ).
  intros X1 X2 X3. intro H. elim (rem_86 X1 X2 X3 H).
   intro H. elim (rem_87  H).
Qed.

Remark rem_400 : forall X1 X2 X3 X4:term, auto___def_52 X4 -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_7 X2 -> auto_agent X2). tauto. exact (rem_399 X2).
Qed.

Remark rem_401 : forall X1 X2 X3 X4:term, auto___def_52 X4 -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_2 X3 -> auto___type_2 X3). tauto. exact (rem_274 X3).
Qed.

Remark rem_402 : forall X1 X2 X3 X4:term, auto___def_52 X4 -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_52 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_52 X4 -> auto___def_52 X4). tauto. exact (rem_361 X4).
Qed.

Remark rem_403 : forall X1 X2 X3 X4:term, auto___def_52 X4 -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> (auto___type_3 X1 /\ auto_agent X1 /\ auto___def_7 X2 /\ auto_agent X2 /\ auto___type_2 X3 /\ auto___def_52 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  cut (auto___type_3 X1). 2:apply (rem_366 X1 X2 X3 X4);  assumption.
  cut (auto_agent X1). 2:apply (rem_393 X1 X2 X3 X4);  assumption.
  cut (auto___def_7 X2). 2:apply (rem_395 X1 X2 X3 X4);  assumption.
  cut (auto_agent X2). 2:apply (rem_400 X1 X2 X3 X4);  assumption.
  cut (auto___type_2 X3). 2:apply (rem_401 X1 X2 X3 X4);  assumption.
  cut (auto___def_52 X4). 2:apply (rem_402 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_404 : forall X1 X2 X3 X4:term, auto___def_52 X4 -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_57 (nonceb_current X1 X2 X3 X4). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  case (rem_403 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6). clear  A1 A2 A3 A4 A5 A6. intros. apply trans___def_57_nonceb_current_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6. tauto.
Qed.

Remark rem_405 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto_agent X1 -> auto___def_7 X2 -> auto_agent X2 -> auto___def_52 X4 -> auto___type_2 X3 -> auto___def_57 (nonceb_current X1 X2 X3 X4). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_52 X4 -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_57 (nonceb_current X1 X2 X3 X4)). tauto. exact (rem_404 X1 X2 X3 X4).
Qed.

Remark rem_406 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_52 X4 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_11 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_11 X1 -> auto___type_11 X1). tauto. exact (rem_184 X1).
Qed.

Remark rem_407 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_52 X4 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_11 X1 -> auto_agent X1). tauto. exact (rem_315 X1).
Qed.

Remark rem_408 : forall X2:term, auto___def_5 X2 -> auto___def_5 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_409 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_52 X4 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_5 X2). tauto. exact (rem_408 X2).
Qed.

Remark rem_410 : (forall X:term, auto___def_5 X -> auto_agent X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_5_pagent.  tauto.
Defined.

Remark rem_411 : (forall X:term, auto___def_5 X -> auto_agent X)
    -> auto_agent bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_5_pagent.  case (rem_410 epsilon_m__def_5_pagent). clear  epsilon_m__def_5_pagent. intros. apply trans_agent_bob_1;  tauto.
 clear  epsilon_m__def_5_pagent. tauto.
Defined.

Remark rem_412 : (forall X:term, auto___def_5 X -> auto_agent X)
    -> auto___def_5 bob -> auto_agent bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_5_pagent. intro H. intros.
  elim (rem_57 H);  intros.
  apply (rem_411 epsilon_m__def_5_pagent);  tauto.
Defined.

Remark rem_413 : forall X2:term, auto___def_5 X2 -> auto_agent X2. (* Induct. *)
Proof.
  fix epsilon_m__def_5_pagent 1.
  intro X. case X.
   intro H. elim (rem_69  H).
  exact (rem_412 epsilon_m__def_5_pagent ).
  intros X1 X2. intro H. elim (rem_65 X1 X2 H).
  intros X1 X2. intro H. elim (rem_66 X1 X2 H).
   intro H. elim (rem_61  H).
   intro H. elim (rem_73  H).
  intros X1 X2. intro H. elim (rem_67 X1 X2 H).
   intro H. elim (rem_60  H).
  intros X1 X2 X3. intro H. elim (rem_64 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_68 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_72 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_70 X1 X2 X3 X4 H).
   intro H. elim (rem_75  H).
   intro H. elim (rem_71  H).
  intros X1. intro H. elim (rem_59 X1 H).
   intro H. elim (rem_74  H).
  intros X1 X2 X3. intro H. elim (rem_62 X1 X2 X3 H).
   intro H. elim (rem_63  H).
Qed.

Remark rem_414 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_52 X4 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto_agent X2). tauto. exact (rem_413 X2).
Qed.

Remark rem_415 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_52 X4 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_10 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_10 X3 -> auto___type_10 X3). tauto. exact (rem_263 X3).
Qed.

Remark rem_416 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_52 X4 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_52 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_52 X4 -> auto___def_52 X4). tauto. exact (rem_361 X4).
Qed.

Remark rem_417 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_52 X4 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> (auto___type_11 X1 /\ auto_agent X1 /\ auto___def_5 X2 /\ auto_agent X2 /\ auto___type_10 X3 /\ auto___def_52 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  cut (auto___type_11 X1). 2:apply (rem_406 X1 X2 X3 X4);  assumption.
  cut (auto_agent X1). 2:apply (rem_407 X1 X2 X3 X4);  assumption.
  cut (auto___def_5 X2). 2:apply (rem_409 X1 X2 X3 X4);  assumption.
  cut (auto_agent X2). 2:apply (rem_414 X1 X2 X3 X4);  assumption.
  cut (auto___type_10 X3). 2:apply (rem_415 X1 X2 X3 X4);  assumption.
  cut (auto___def_52 X4). 2:apply (rem_416 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_418 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_52 X4 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_57 (nonceb_current X1 X2 X3 X4). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  case (rem_417 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6). clear  A1 A2 A3 A4 A5 A6. intros. apply trans___def_57_nonceb_current_2;  tauto.
 clear  A1 A2 A3 A4 A5 A6. tauto.
Qed.

Remark rem_419 : forall X1 X2 X3 X4:term, auto___type_11 X1 -> auto_agent X1 -> auto___def_5 X2 -> auto_agent X2 -> auto___def_52 X4 -> auto___type_10 X3 -> auto___def_57 (nonceb_current X1 X2 X3 X4). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_52 X4 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_57 (nonceb_current X1 X2 X3 X4)). tauto. exact (rem_418 X1 X2 X3 X4).
Qed.

Remark rem_420 : forall X1 X2 X3 X4:term, auto___def_54 X1 X2 X3 X4 -> or_4
    (auto___type_3 X1 /\ auto___type_9 X2 /\ auto_agent X2 /\ auto_knows_current X3 /\ auto___type_2 X4)
    (auto___type_11 X1 /\ auto_agent X1 /\ auto_agent X2 /\ auto___def_2 X2 /\ auto___def_52 X3 /\ auto___type_10 X4)
    (auto___type_3 X1 /\ auto_agent X1 /\ auto___def_7 X2 /\ auto_agent X2 /\ auto___def_52 X3 /\ auto___type_2 X4)
    (auto___type_11 X1 /\ auto_agent X1 /\ auto___def_5 X2 /\ auto_agent X2 /\ auto___def_52 X3 /\ auto___type_10 X4)
.
Proof.
  intros. inversion H.
  intros. apply or_4_intro_1; tauto.
  intros. apply or_4_intro_2; tauto.
  intros. apply or_4_intro_3; tauto.
  intros. apply or_4_intro_4; tauto.
Qed.

Remark rem_421 : forall X1 X2 X3 X4:term, auto___def_54 X1 X2 X4 X3 -> auto___def_57 (nonceb_current X1 X2 X3 X4). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_420 X1 X2 X4 X3 H);  intros.
  apply (rem_280 X1 X2 X3 X4);  tauto.
  apply (rem_365 X1 X2 X3 X4);  tauto.
  apply (rem_405 X1 X2 X3 X4);  tauto.
  apply (rem_419 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_422 : auto___def_38 server -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_254 H);  intros.
Qed.

Remark rem_423 : auto___def_37 prv -> auto___def_38 server -> False. (* Split. *)
Proof.
 
  cut (auto___def_38 server -> False). tauto.
  exact rem_422.
Qed.

Remark rem_424 : auto_knows_current (key prv server) -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_258 prv server H);  intros.
  apply rem_214;  tauto.
  apply rem_215;  tauto.
  apply rem_423;  tauto.
Qed.

Remark rem_425 : forall X1 X2 X3 X4:term, auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key prv server) -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current (key prv server) -> False). tauto.
  exact (rem_424).
Qed.

Remark rem_426 : forall X1 X2 X3 X4:term, auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key prv server) -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key prv server) -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_425 X1 X2 X3 X4).
Qed.

Remark rem_427 : forall X1 X2:term, auto___type_12 (key X1 X2) -> or_3
    (auto___def_3 X1 /\ auto___def_2 X2)
    (auto___def_3 X1 /\ auto___def_5 X2)
    (auto___def_3 X1 /\ auto___def_7 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_428 : auto___type_12 (key prv server) -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_427 prv server H);  intros.
  apply rem_194;  tauto.
  apply rem_195;  tauto.
  apply rem_196;  tauto.
Qed.

Remark rem_429 : forall X1 X2 X3 X4:term, auto___def_51 (cons X4 (cons X1 nil)) -> auto___type_12 (key prv server) -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_12 (key prv server) -> False). tauto.
  exact (rem_428).
Qed.

Remark rem_430 : forall X1 X2:term, auto___def_57 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_431 : forall X1 X2 X3 X4:term, auto___def_57 (cons X4 (cons X1 nil)) -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_430 X4 (cons X1 nil) H);  intros.
Qed.

Remark rem_432 : forall X1 X2 X3 X4:term, auto___def_57 (cons X4 (cons X1 nil)) -> auto___type_2 (key prv server) -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_57 (cons X4 (cons X1 nil)) -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_431 X1 X2 X3 X4).
Qed.

Remark rem_433 : forall X1 X2 X3 X4:term, auto___def_49 nil -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (key pub X2) -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_11 X1 -> auto___type_3 X1). tauto. exact (rem_306 X1).
Qed.

Remark rem_434 : forall X1 X2 X3 X4:term, auto___def_49 nil -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (key pub X2) -> auto___type_9 X2. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Qed.

Remark rem_435 : forall X1 X2 X3 X4:term, auto___def_49 nil -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (key pub X2) -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_272 X2).
Qed.

Remark rem_436 : forall X3:term, auto_knows_current X3 -> auto_knows_current X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_437 : forall X1 X2 X3 X4:term, auto___def_49 nil -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (key pub X2) -> auto_knows_current X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X3 -> auto_knows_current X3). tauto. exact (rem_436 X3).
Qed.

Remark rem_438 : forall X4:term, auto___type_10 X4 -> auto___type_2 X4. (* Induct. *)
Proof.
  fix epsilon_m__type_10_p__type_2 1.
  intro X. case X.
   intro H. elim (rem_352  H).
   intro H. elim (rem_350  H).
  intros X1 X2. intro H. elim (rem_348 X1 X2 H).
  intros X1 X2. intro H. elim (rem_349 X1 X2 H).
   intro H. elim (rem_344  H).
   intro H. elim (rem_356  H).
  intros X1 X2;  exact (rem_341 epsilon_m__type_10_p__type_2 X1 X2).
   intro H. elim (rem_343  H).
  intros X1 X2 X3. intro H. elim (rem_347 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_351 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_355 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_353 X1 X2 X3 X4 H).
   intro H. elim (rem_358  H).
   intro H. elim (rem_354  H).
  intros X1. intro H. elim (rem_342 X1 H).
   intro H. elim (rem_357  H).
  intros X1 X2 X3. intro H. elim (rem_345 X1 X2 X3 H).
   intro H. elim (rem_346  H).
Qed.

Remark rem_439 : forall X1 X2 X3 X4:term, auto___def_49 nil -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (key pub X2) -> auto___type_2 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_10 X4 -> auto___type_2 X4). tauto. exact (rem_438 X4).
Qed.

Remark rem_440 : forall X1 X2 X3 X4:term, auto___def_49 nil -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (key pub X2) -> (auto___type_3 X1 /\ auto___type_9 X2 /\ auto_agent X2 /\ auto_knows_current X3 /\ auto___type_2 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto___type_3 X1). 2:apply (rem_433 X1 X2 X3 X4);  assumption.
  cut (auto___type_9 X2). 2:apply (rem_434 X1 X2 X3 X4);  assumption.
  cut (auto_agent X2). 2:apply (rem_435 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X3). 2:apply (rem_437 X1 X2 X3 X4);  assumption.
  cut (auto___type_2 X4). 2:apply (rem_439 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_441 : forall X1 X2 X3 X4:term, auto___def_49 nil -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_440 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_54_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_442 : forall X1 X2 X3 X4:term, auto___type_11 X1 -> auto___def_49 nil -> auto___type_10 X4 -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_49 nil -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_441 X1 X2 X3 X4).
Qed.

Remark rem_443 : forall X1 X2:term, auto___def_48 (cons X1 X2) -> or_1
    (auto___type_11 X1 /\ auto___def_49 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_444 : forall X1 X2 X3 X4:term, auto___def_48 (cons X1 nil) -> auto___type_10 X4 -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_443 X1 nil H);  intros.
  apply (rem_442 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_445 : forall X1 X2 X3 X4:term, auto___type_10 X4 -> auto___def_48 (cons X1 nil) -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_48 (cons X1 nil) -> auto___type_10 X4 -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_444 X1 X2 X3 X4).
Qed.

Remark rem_446 : forall X1 X2:term, auto___def_46 (cons X1 X2) -> or_1
    (auto___type_10 X1 /\ auto___def_48 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_447 : forall X1 X2 X3 X4:term, auto___def_46 (cons X4 (cons X1 nil)) -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_446 X4 (cons X1 nil) H);  intros.
  apply (rem_445 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_448 : forall X1 X2 X3 X4:term, auto___def_46 (cons X4 (cons X1 nil)) -> auto___def_47 (key prv server) -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_46 (cons X4 (cons X1 nil)) -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_447 X1 X2 X3 X4).
Qed.

Remark rem_449 : forall X1:term, auto___def_57 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_450 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> forall X1:term, auto___def_57 (s X1) -> auto_knows_current X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intros X1. intro H. intros.
  elim (rem_449 X1 H);  intros.
Defined.

Remark rem_451 : forall X1:term, auto_knows_current (s X1) -> or_1
    (auto_knows_current X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_452 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> forall X1:term, auto_knows_current (s X1) -> auto___def_57 (s X1) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intros X1. intro H. intros.
  elim (rem_451 X1 H);  intros.
  apply (rem_450 epsilon_mknows_current_m__def_57 X1);  tauto.
Defined.

Remark rem_453 : auto___def_57 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_454 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> auto___def_57 nil -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intro H. intros.
  elim (rem_453 H);  intros.
Defined.

Remark rem_455 : auto_knows_current nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_456 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> auto_knows_current nil -> auto___def_57 nil -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intro H. intros.
  elim (rem_455 H);  intros.
  apply (rem_454 epsilon_mknows_current_m__def_57);  tauto.
Defined.

Remark rem_457 : auto___def_57 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_458 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> auto___def_57 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intro H. intros.
  elim (rem_457 H);  intros.
Defined.

Remark rem_459 : auto_knows_current i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_460 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> auto_knows_current i -> auto___def_57 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intro H. intros.
  elim (rem_459 H);  intros.
  apply (rem_458 epsilon_mknows_current_m__def_57);  tauto.
Defined.

Remark rem_461 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> forall X1 X2:term, auto___def_57 (cons X1 X2) -> auto_knows_current X1 -> auto_knows_current X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intros X1 X2. intro H. intros.
  elim (rem_430 X1 X2 H);  intros.
Defined.

Remark rem_462 : forall X1 X2:term, auto_knows_current (cons X1 X2) -> or_1
    (auto_knows_current X1 /\ auto_knows_current X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_463 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> forall X1 X2:term, auto_knows_current (cons X1 X2) -> auto___def_57 (cons X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intros X1 X2. intro H. intros.
  elim (rem_462 X1 X2 H);  intros.
  apply (rem_461 epsilon_mknows_current_m__def_57 X1 X2);  tauto.
Defined.

Remark rem_464 : forall X1 X2:term, auto___def_57 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_465 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> forall X1 X2:term, auto___def_57 (crypt X1 X2) -> auto_knows_current X1 -> auto_knows_current X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intros X1 X2. intro H. intros.
  elim (rem_464 X1 X2 H);  intros.
Defined.

Remark rem_466 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> forall X1 X2:term, auto___def_57 (crypt X1 X2) -> auto___def_51 X1 -> auto___type_12 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intros X1 X2. intro H. intros.
  elim (rem_464 X1 X2 H);  intros.
Defined.

Remark rem_467 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> forall X1 X2:term, auto___def_57 (crypt X1 X2) -> auto___def_57 X1 -> auto___type_2 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intros X1 X2. intro H. intros.
  elim (rem_464 X1 X2 H);  intros.
Defined.

Remark rem_468 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> forall X1 X2:term, auto___def_57 (crypt X1 X2) -> auto___def_46 X1 -> auto___def_47 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intros X1 X2. intro H. intros.
  elim (rem_464 X1 X2 H);  intros.
Defined.

Remark rem_469 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> forall X1 X2:term, auto___def_57 (crypt X1 X2) -> auto___def_55 X1 -> auto___type_13 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intros X1 X2. intro H. intros.
  elim (rem_464 X1 X2 H);  intros.
Defined.

Remark rem_470 : forall X1 X2:term, auto_knows_current (crypt X1 X2) -> or_5
    (auto_knows_current X1 /\ auto_knows_current X2)
    (auto___def_51 X1 /\ auto___type_12 X2)
    (auto___def_57 X1 /\ auto___type_2 X2)
    (auto___def_46 X1 /\ auto___def_47 X2)
    (auto___def_55 X1 /\ auto___type_13 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_5_intro_1; tauto.
  intros. apply or_5_intro_2; tauto.
  intros. apply or_5_intro_3; tauto.
  intros. apply or_5_intro_4; tauto.
  intros. apply or_5_intro_5; tauto.
Qed.

Remark rem_471 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> forall X1 X2:term, auto_knows_current (crypt X1 X2) -> auto___def_57 (crypt X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intros X1 X2. intro H. intros.
  elim (rem_470 X1 X2 H);  intros.
  apply (rem_465 epsilon_mknows_current_m__def_57 X1 X2);  tauto.
  apply (rem_466 epsilon_mknows_current_m__def_57 X1 X2);  tauto.
  apply (rem_467 epsilon_mknows_current_m__def_57 X1 X2);  tauto.
  apply (rem_468 epsilon_mknows_current_m__def_57 X1 X2);  tauto.
  apply (rem_469 epsilon_mknows_current_m__def_57 X1 X2);  tauto.
Defined.

Remark rem_472 : forall X1 X2:term, auto___def_57 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_473 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> forall X1 X2:term, auto___def_57 (key X1 X2) -> auto___def_23 X1 -> auto___def_36 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intros X1 X2. intro H. intros.
  elim (rem_472 X1 X2 H);  intros.
Defined.

Remark rem_474 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> forall X1 X2:term, auto___def_57 (key X1 X2) -> auto___def_3 X1 -> auto___type_9 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intros X1 X2. intro H. intros.
  elim (rem_472 X1 X2 H);  intros.
Defined.

Remark rem_475 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> forall X1 X2:term, auto___def_57 (key X1 X2) -> auto___def_37 X1 -> auto___def_38 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intros X1 X2. intro H. intros.
  elim (rem_472 X1 X2 H);  intros.
Defined.

Remark rem_476 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> forall X1 X2:term, auto_knows_current (key X1 X2) -> auto___def_57 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intros X1 X2. intro H. intros.
  elim (rem_258 X1 X2 H);  intros.
  apply (rem_473 epsilon_mknows_current_m__def_57 X1 X2);  tauto.
  apply (rem_474 epsilon_mknows_current_m__def_57 X1 X2);  tauto.
  apply (rem_475 epsilon_mknows_current_m__def_57 X1 X2);  tauto.
Defined.

Remark rem_477 : auto___def_57 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_478 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> auto___def_57 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intro H. intros.
  elim (rem_477 H);  intros.
Defined.

Remark rem_479 : auto_knows_current bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_480 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> auto_knows_current bob -> auto___def_57 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intro H. intros.
  elim (rem_479 H);  intros.
  apply (rem_478 epsilon_mknows_current_m__def_57);  tauto.
Defined.

Remark rem_481 : forall X1 X2 X3:term, auto___def_57 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_482 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> forall X1 X2 X3:term, auto___def_57 (noncea_old X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intros X1 X2 X3. intro H. intros.
  elim (rem_481 X1 X2 X3 H);  intros.
Defined.

Remark rem_483 : forall X1 X2 X3:term, auto_knows_current (noncea_old X1 X2 X3) -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_484 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> forall X1 X2 X3:term, auto_knows_current (noncea_old X1 X2 X3) -> auto___def_57 (noncea_old X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intros X1 X2 X3. intro H. intros.
  elim (rem_483 X1 X2 X3 H);  intros.
  apply (rem_482 epsilon_mknows_current_m__def_57 X1 X2 X3);  tauto.
Defined.

Remark rem_485 : auto___def_57 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_486 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> auto___def_57 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intro H. intros.
  elim (rem_485 H);  intros.
Defined.

Remark rem_487 : auto_knows_current alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_488 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> auto_knows_current alice -> auto___def_57 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intro H. intros.
  elim (rem_487 H);  intros.
  apply (rem_486 epsilon_mknows_current_m__def_57);  tauto.
Defined.

Remark rem_489 : forall X1 X2 X3 X4:term, auto___def_57 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_490 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> forall X1 X2 X3 X4:term, auto___def_57 (nonceb_old X1 X2 X3 X4) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intros X1 X2 X3 X4. intro H. intros.
  elim (rem_489 X1 X2 X3 X4 H);  intros.
Defined.

Remark rem_491 : forall X1 X2 X3 X4:term, auto_knows_current (nonceb_old X1 X2 X3 X4) -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_492 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> forall X1 X2 X3 X4:term, auto_knows_current (nonceb_old X1 X2 X3 X4) -> auto___def_57 (nonceb_old X1 X2 X3 X4) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intros X1 X2 X3 X4. intro H. intros.
  elim (rem_491 X1 X2 X3 X4 H);  intros.
  apply (rem_490 epsilon_mknows_current_m__def_57 X1 X2 X3 X4);  tauto.
Defined.

Remark rem_493 : auto___def_57 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_494 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> auto___def_57 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intro H. intros.
  elim (rem_493 H);  intros.
Defined.

Remark rem_495 : auto_knows_current server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_496 : (forall X:term, auto_knows_current X -> auto___def_57 X -> False)
    -> auto_knows_current server -> auto___def_57 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_57. intro H. intros.
  elim (rem_495 H);  intros.
  apply (rem_494 epsilon_mknows_current_m__def_57);  tauto.
Defined.

Remark rem_497 : forall X1 X2 X3:term, auto_knows_current (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_498 : auto_knows_current sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_499 : forall X1 X2 X3:term, auto_knows_current (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_500 : auto_knows_current pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_501 : forall X1 X2 X3 X4:term, auto_knows_current (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_502 : auto_knows_current prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_503 : forall X1:term, auto_knows_current X1 -> auto___def_57 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_mknows_current_m__def_57 1.
  intro X. case X.
  exact (rem_488 epsilon_mknows_current_m__def_57 ).
  exact (rem_480 epsilon_mknows_current_m__def_57 ).
  intros X1 X2;  exact (rem_463 epsilon_mknows_current_m__def_57 X1 X2).
  intros X1 X2;  exact (rem_471 epsilon_mknows_current_m__def_57 X1 X2).
  exact (rem_460 epsilon_mknows_current_m__def_57 ).
   intro H. elim (rem_31  H).
  intros X1 X2;  exact (rem_476 epsilon_mknows_current_m__def_57 X1 X2).
  exact (rem_456 epsilon_mknows_current_m__def_57 ).
  intros X1 X2 X3. intro H. elim (rem_499 X1 X2 X3 H).
  intros X1 X2 X3;  exact (rem_484 epsilon_mknows_current_m__def_57 X1 X2 X3).
  intros X1 X2 X3 X4. intro H. elim (rem_501 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4;  exact (rem_492 epsilon_mknows_current_m__def_57 X1 X2 X3 X4).
   intro H. elim (rem_502  H).
   intro H. elim (rem_500  H).
  intros X1;  exact (rem_452 epsilon_mknows_current_m__def_57 X1).
  exact (rem_496 epsilon_mknows_current_m__def_57 ).
  intros X1 X2 X3. intro H. elim (rem_497 X1 X2 X3 H).
   intro H. elim (rem_498  H).
Qed.

Remark rem_504 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_58 nil -> auto___type_14 X4 -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_503 X1)). tauto.
Qed.

Remark rem_505 : forall X1 X2:term, auto___def_56 (cons X1 X2) -> or_1
    (auto___def_57 X1 /\ auto___def_58 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_506 : forall X1 X2 X3 X4:term, auto___def_56 (cons X1 nil) -> auto___type_14 X4 -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_505 X1 nil H);  intros.
  apply (rem_504 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_507 : forall X1 X2 X3 X4:term, auto___type_14 X4 -> auto___def_56 (cons X1 nil) -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 (cons X1 nil) -> auto___type_14 X4 -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_506 X1 X2 X3 X4).
Qed.

Remark rem_508 : forall X1 X2:term, auto___def_55 (cons X1 X2) -> or_1
    (auto___type_14 X1 /\ auto___def_56 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_509 : forall X1 X2 X3 X4:term, auto___def_55 (cons X4 (cons X1 nil)) -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_508 X4 (cons X1 nil) H);  intros.
  apply (rem_507 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_510 : forall X1 X2 X3 X4:term, auto___def_55 (cons X4 (cons X1 nil)) -> auto___type_13 (key prv server) -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_55 (cons X4 (cons X1 nil)) -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_509 X1 X2 X3 X4).
Qed.

Remark rem_511 : forall X1 X2 X3 X4:term, auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3. intro H. intros.
  elim (rem_470 (cons X4 (cons X1 nil)) (key prv server) H);  intros.
  apply (rem_426 X1 X2 X3 X4);  tauto.
  apply (rem_429 X1 X2 X3 X4);  tauto.
  apply (rem_432 X1 X2 X3 X4);  tauto.
  apply (rem_448 X1 X2 X3 X4);  tauto.
  apply (rem_510 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_512 : forall X1 X2 X3 X4:term, auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto_knows_current (key pub X2) -> auto_knows_current nil -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_511 X1 X2 X3 X4).
Qed.

Remark rem_513 : forall X1 X2 X3 X4:term, auto_knows_current X1 -> auto_knows_current nil -> auto_agent X2 -> auto_knows_current X3 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_agent X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto_knows_current (key pub X2) -> auto_knows_current nil -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_512 X1 X2 X3 X4).
Qed.

Remark rem_514 : forall X1 X2 X3 X4:term, auto_agent X2 -> auto_knows_current X3 -> auto_knows_current (cons X1 nil) -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_462 X1 nil H);  intros.
  apply (rem_513 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_515 : forall X1 X2 X3 X4:term, auto_knows_current X3 -> auto_knows_current (cons X1 nil) -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_agent X2 -> auto_knows_current X3 -> auto_knows_current (cons X1 nil) -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_514 X1 X2 X3 X4).
Qed.

Remark rem_516 : forall X1 X2 X3 X4:term, auto_agent X2 -> auto_knows_current (cons X3 (cons X1 nil)) -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_462 X3 (cons X1 nil) H);  intros.
  apply (rem_515 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_517 : forall X1 X2 X3 X4:term, auto_knows_current (cons X3 (cons X1 nil)) -> auto_knows_current (key pub X2) -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_agent X2 -> auto_knows_current (cons X3 (cons X1 nil)) -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto_knows_current (key pub X2) -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_516 X1 X2 X3 X4).
Qed.

Remark rem_518 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key prv server) -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current (key prv server) -> False). tauto.
  exact (rem_424).
Qed.

Remark rem_519 : forall X1 X2 X3 X4:term, auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key prv server) -> auto___def_2 X2 -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key prv server) -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_518 X1 X2 X3 X4).
Qed.

Remark rem_520 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_51 (cons X4 (cons X1 nil)) -> auto___def_52 X3 -> auto___type_12 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_12 (key prv server) -> False). tauto.
  exact (rem_428).
Qed.

Remark rem_521 : forall X1 X2 X3 X4:term, auto___def_51 (cons X4 (cons X1 nil)) -> auto___type_12 (key prv server) -> auto___def_2 X2 -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_51 (cons X4 (cons X1 nil)) -> auto___def_52 X3 -> auto___type_12 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_520 X1 X2 X3 X4).
Qed.

Remark rem_522 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_52 X3 -> auto___def_57 (cons X4 (cons X1 nil)) -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_430 X4 (cons X1 nil) H);  intros.
Qed.

Remark rem_523 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_52 X3 -> auto___def_57 (cons X4 (cons X1 nil)) -> auto___type_2 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_52 X3 -> auto___def_57 (cons X4 (cons X1 nil)) -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_522 X1 X2 X3 X4).
Qed.

Remark rem_524 : forall X1 X2 X3 X4:term, auto___def_57 (cons X4 (cons X1 nil)) -> auto___type_2 (key prv server) -> auto___def_2 X2 -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_52 X3 -> auto___def_57 (cons X4 (cons X1 nil)) -> auto___type_2 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_523 X1 X2 X3 X4).
Qed.

Remark rem_525 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_49 nil -> auto___def_52 X3 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_11 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_11 X1 -> auto___type_11 X1). tauto. exact (rem_184 X1).
Qed.

Remark rem_526 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_49 nil -> auto___def_52 X3 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_11 X1 -> auto_agent X1). tauto. exact (rem_315 X1).
Qed.

Remark rem_527 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_49 nil -> auto___def_52 X3 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto_agent X2). tauto. exact (rem_320 X2).
Qed.

Remark rem_528 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_49 nil -> auto___def_52 X3 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_2 X2). tauto. exact (rem_322 X2).
Qed.

Remark rem_529 : forall X3:term, auto___def_52 X3 -> auto___def_52 X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_530 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_49 nil -> auto___def_52 X3 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_52 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_52 X3 -> auto___def_52 X3). tauto. exact (rem_529 X3).
Qed.

Remark rem_531 : forall X4:term, auto___type_10 X4 -> auto___type_10 X4. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_532 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_49 nil -> auto___def_52 X3 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_10 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_10 X4 -> auto___type_10 X4). tauto. exact (rem_531 X4).
Qed.

Remark rem_533 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_49 nil -> auto___def_52 X3 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> (auto___type_11 X1 /\ auto_agent X1 /\ auto_agent X2 /\ auto___def_2 X2 /\ auto___def_52 X3 /\ auto___type_10 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto___type_11 X1). 2:apply (rem_525 X1 X2 X3 X4);  assumption.
  cut (auto_agent X1). 2:apply (rem_526 X1 X2 X3 X4);  assumption.
  cut (auto_agent X2). 2:apply (rem_527 X1 X2 X3 X4);  assumption.
  cut (auto___def_2 X2). 2:apply (rem_528 X1 X2 X3 X4);  assumption.
  cut (auto___def_52 X3). 2:apply (rem_530 X1 X2 X3 X4);  assumption.
  cut (auto___type_10 X4). 2:apply (rem_532 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_534 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_49 nil -> auto___def_52 X3 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_533 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_54_2;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_535 : forall X1 X2 X3 X4:term, auto___type_11 X1 -> auto___def_49 nil -> auto___def_2 X2 -> auto___def_52 X3 -> auto___type_10 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_49 nil -> auto___def_52 X3 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_534 X1 X2 X3 X4).
Qed.

Remark rem_536 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_48 (cons X1 nil) -> auto___def_52 X3 -> auto___type_10 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_443 X1 nil H);  intros.
  apply (rem_535 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_537 : forall X1 X2 X3 X4:term, auto___type_10 X4 -> auto___def_48 (cons X1 nil) -> auto___def_2 X2 -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_48 (cons X1 nil) -> auto___def_52 X3 -> auto___type_10 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_536 X1 X2 X3 X4).
Qed.

Remark rem_538 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_46 (cons X4 (cons X1 nil)) -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_446 X4 (cons X1 nil) H);  intros.
  apply (rem_537 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_539 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_46 (cons X4 (cons X1 nil)) -> auto___def_47 (key prv server) -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_46 (cons X4 (cons X1 nil)) -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_538 X1 X2 X3 X4).
Qed.

Remark rem_540 : forall X1 X2 X3 X4:term, auto___def_46 (cons X4 (cons X1 nil)) -> auto___def_47 (key prv server) -> auto___def_2 X2 -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_46 (cons X4 (cons X1 nil)) -> auto___def_47 (key prv server) -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_539 X1 X2 X3 X4).
Qed.

Remark rem_541 : (forall X:term, auto___def_57 X -> auto_agent X -> False)
    -> forall X1 X2 X3 X4:term, auto_agent (nonceb_current X1 X2 X3 X4) -> auto___type_3 X1 -> auto_agent X1 -> auto___def_7 X2 -> auto_agent X2 -> auto___type_2 X3 -> auto___def_52 X4 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_57_magent. intros X1 X2 X3 X4. intro H. intros.
  elim (rem_130 X1 X2 X3 X4 H);  intros.
Defined.

Remark rem_542 : (forall X:term, auto___def_57 X -> auto_agent X -> False)
    -> forall X1 X2 X3 X4:term, auto_agent (nonceb_current X1 X2 X3 X4) -> auto___type_11 X1 -> auto_agent X1 -> auto___def_5 X2 -> auto_agent X2 -> auto___type_10 X3 -> auto___def_52 X4 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_57_magent. intros X1 X2 X3 X4. intro H. intros.
  elim (rem_130 X1 X2 X3 X4 H);  intros.
Defined.

Remark rem_543 : (forall X:term, auto___def_57 X -> auto_agent X -> False)
    -> forall X1 X2 X3 X4:term, auto_agent (nonceb_current X1 X2 X3 X4) -> auto___type_3 X1 -> auto___type_9 X2 -> auto_agent X2 -> auto___type_2 X3 -> auto_knows_current X4 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_57_magent. intros X1 X2 X3 X4. intro H. intros.
  elim (rem_130 X1 X2 X3 X4 H);  intros.
Defined.

Remark rem_544 : (forall X:term, auto___def_57 X -> auto_agent X -> False)
    -> forall X1 X2 X3 X4:term, auto_agent (nonceb_current X1 X2 X3 X4) -> auto___type_3 X1 -> auto_agent X1 -> auto_agent X2 -> auto___def_2 X2 -> auto___type_2 X3 -> auto___def_52 X4 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_57_magent. intros X1 X2 X3 X4. intro H. intros.
  elim (rem_130 X1 X2 X3 X4 H);  intros.
Defined.

Remark rem_545 : forall X1 X2 X3 X4:term, auto___def_57 (nonceb_current X1 X2 X3 X4) -> or_4
    (auto___type_3 X1 /\ auto_agent X1 /\ auto___def_7 X2 /\ auto_agent X2 /\ auto___type_2 X3 /\ auto___def_52 X4)
    (auto___type_11 X1 /\ auto_agent X1 /\ auto___def_5 X2 /\ auto_agent X2 /\ auto___type_10 X3 /\ auto___def_52 X4)
    (auto___type_3 X1 /\ auto___type_9 X2 /\ auto_agent X2 /\ auto___type_2 X3 /\ auto_knows_current X4)
    (auto___type_3 X1 /\ auto_agent X1 /\ auto_agent X2 /\ auto___def_2 X2 /\ auto___type_2 X3 /\ auto___def_52 X4)
.
Proof.
  intros. inversion H.
  intros. apply or_4_intro_1; tauto.
  intros. apply or_4_intro_2; tauto.
  intros. apply or_4_intro_3; tauto.
  intros. apply or_4_intro_4; tauto.
Qed.

Remark rem_546 : (forall X:term, auto___def_57 X -> auto_agent X -> False)
    -> forall X1 X2 X3 X4:term, auto___def_57 (nonceb_current X1 X2 X3 X4) -> auto_agent (nonceb_current X1 X2 X3 X4) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_57_magent. intros X1 X2 X3 X4. intro H. intros.
  elim (rem_545 X1 X2 X3 X4 H);  intros.
  apply (rem_541 epsilon_m__def_57_magent X1 X2 X3 X4);  tauto.
  apply (rem_542 epsilon_m__def_57_magent X1 X2 X3 X4);  tauto.
  apply (rem_543 epsilon_m__def_57_magent X1 X2 X3 X4);  tauto.
  apply (rem_544 epsilon_m__def_57_magent X1 X2 X3 X4);  tauto.
Defined.

Remark rem_547 : forall X1 X2 X3:term, auto___def_57 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_548 : auto___def_57 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_549 : forall X1 X2 X3:term, auto___def_57 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_550 : auto___def_57 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_551 : auto___def_57 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_552 : auto___def_57 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_553 : forall X1:term, auto___def_57 X1 -> auto_agent X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_57_magent 1.
  intro X. case X.
   intro H. elim (rem_485  H).
   intro H. elim (rem_477  H).
  intros X1 X2. intro H. elim (rem_430 X1 X2 H).
  intros X1 X2. intro H. elim (rem_464 X1 X2 H).
   intro H. elim (rem_457  H).
   intro H. elim (rem_551  H).
  intros X1 X2. intro H. elim (rem_472 X1 X2 H).
   intro H. elim (rem_453  H).
  intros X1 X2 X3. intro H. elim (rem_549 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_481 X1 X2 X3 H).
  intros X1 X2 X3 X4;  exact (rem_546 epsilon_m__def_57_magent X1 X2 X3 X4).
  intros X1 X2 X3 X4. intro H. elim (rem_489 X1 X2 X3 X4 H).
   intro H. elim (rem_552  H).
   intro H. elim (rem_550  H).
  intros X1. intro H. elim (rem_449 X1 H).
   intro H. elim (rem_493  H).
  intros X1 X2 X3. intro H. elim (rem_547 X1 X2 X3 H).
   intro H. elim (rem_548  H).
Qed.

Remark rem_554 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_52 X3 -> auto___def_57 X1 -> auto___def_58 nil -> auto___type_14 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_553 X1)). tauto.
Qed.

Remark rem_555 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_58 nil -> auto___def_2 X2 -> auto___def_52 X3 -> auto___type_14 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_52 X3 -> auto___def_57 X1 -> auto___def_58 nil -> auto___type_14 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_554 X1 X2 X3 X4).
Qed.

Remark rem_556 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_52 X3 -> auto___def_56 (cons X1 nil) -> auto___type_14 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_505 X1 nil H);  intros.
  apply (rem_555 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_557 : forall X1 X2 X3 X4:term, auto___type_14 X4 -> auto___def_56 (cons X1 nil) -> auto___def_2 X2 -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_52 X3 -> auto___def_56 (cons X1 nil) -> auto___type_14 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_556 X1 X2 X3 X4).
Qed.

Remark rem_558 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_52 X3 -> auto___def_55 (cons X4 (cons X1 nil)) -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_508 X4 (cons X1 nil) H);  intros.
  apply (rem_557 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_559 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_52 X3 -> auto___def_55 (cons X4 (cons X1 nil)) -> auto___type_13 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_52 X3 -> auto___def_55 (cons X4 (cons X1 nil)) -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_558 X1 X2 X3 X4).
Qed.

Remark rem_560 : forall X1 X2 X3 X4:term, auto___def_55 (cons X4 (cons X1 nil)) -> auto___type_13 (key prv server) -> auto___def_2 X2 -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_52 X3 -> auto___def_55 (cons X4 (cons X1 nil)) -> auto___type_13 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_559 X1 X2 X3 X4).
Qed.

Remark rem_561 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_470 (cons X4 (cons X1 nil)) (key prv server) H);  intros.
  apply (rem_519 X1 X2 X3 X4);  tauto.
  apply (rem_521 X1 X2 X3 X4);  tauto.
  apply (rem_524 X1 X2 X3 X4);  tauto.
  apply (rem_540 X1 X2 X3 X4);  tauto.
  apply (rem_560 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_562 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_3 pub -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_561 X1 X2 X3 X4).
Qed.

Remark rem_563 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto___def_2 X2 -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_3 pub -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_562 X1 X2 X3 X4).
Qed.

Remark rem_564 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key prv server) -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current (key prv server) -> False). tauto.
  exact (rem_424).
Qed.

Remark rem_565 : forall X1 X2 X3 X4:term, auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key prv server) -> auto___def_5 X2 -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key prv server) -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_564 X1 X2 X3 X4).
Qed.

Remark rem_566 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_51 (cons X4 (cons X1 nil)) -> auto___def_52 X3 -> auto___type_12 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_12 (key prv server) -> False). tauto.
  exact (rem_428).
Qed.

Remark rem_567 : forall X1 X2 X3 X4:term, auto___def_51 (cons X4 (cons X1 nil)) -> auto___type_12 (key prv server) -> auto___def_5 X2 -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_51 (cons X4 (cons X1 nil)) -> auto___def_52 X3 -> auto___type_12 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_566 X1 X2 X3 X4).
Qed.

Remark rem_568 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_52 X3 -> auto___def_57 (cons X4 (cons X1 nil)) -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_430 X4 (cons X1 nil) H);  intros.
Qed.

Remark rem_569 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_52 X3 -> auto___def_57 (cons X4 (cons X1 nil)) -> auto___type_2 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_52 X3 -> auto___def_57 (cons X4 (cons X1 nil)) -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_568 X1 X2 X3 X4).
Qed.

Remark rem_570 : forall X1 X2 X3 X4:term, auto___def_57 (cons X4 (cons X1 nil)) -> auto___type_2 (key prv server) -> auto___def_5 X2 -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_52 X3 -> auto___def_57 (cons X4 (cons X1 nil)) -> auto___type_2 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_569 X1 X2 X3 X4).
Qed.

Remark rem_571 : forall X1 X2 X3 X4:term, auto___def_49 nil -> auto___def_5 X2 -> auto___def_52 X3 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_11 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_11 X1 -> auto___type_11 X1). tauto. exact (rem_184 X1).
Qed.

Remark rem_572 : forall X1 X2 X3 X4:term, auto___def_49 nil -> auto___def_5 X2 -> auto___def_52 X3 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_11 X1 -> auto_agent X1). tauto. exact (rem_315 X1).
Qed.

Remark rem_573 : forall X1 X2 X3 X4:term, auto___def_49 nil -> auto___def_5 X2 -> auto___def_52 X3 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_5 X2). tauto. exact (rem_408 X2).
Qed.

Remark rem_574 : forall X1 X2 X3 X4:term, auto___def_49 nil -> auto___def_5 X2 -> auto___def_52 X3 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto_agent X2). tauto. exact (rem_413 X2).
Qed.

Remark rem_575 : forall X1 X2 X3 X4:term, auto___def_49 nil -> auto___def_5 X2 -> auto___def_52 X3 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_52 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_52 X3 -> auto___def_52 X3). tauto. exact (rem_529 X3).
Qed.

Remark rem_576 : forall X1 X2 X3 X4:term, auto___def_49 nil -> auto___def_5 X2 -> auto___def_52 X3 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_10 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_10 X4 -> auto___type_10 X4). tauto. exact (rem_531 X4).
Qed.

Remark rem_577 : forall X1 X2 X3 X4:term, auto___def_49 nil -> auto___def_5 X2 -> auto___def_52 X3 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> (auto___type_11 X1 /\ auto_agent X1 /\ auto___def_5 X2 /\ auto_agent X2 /\ auto___def_52 X3 /\ auto___type_10 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto___type_11 X1). 2:apply (rem_571 X1 X2 X3 X4);  assumption.
  cut (auto_agent X1). 2:apply (rem_572 X1 X2 X3 X4);  assumption.
  cut (auto___def_5 X2). 2:apply (rem_573 X1 X2 X3 X4);  assumption.
  cut (auto_agent X2). 2:apply (rem_574 X1 X2 X3 X4);  assumption.
  cut (auto___def_52 X3). 2:apply (rem_575 X1 X2 X3 X4);  assumption.
  cut (auto___type_10 X4). 2:apply (rem_576 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_578 : forall X1 X2 X3 X4:term, auto___def_49 nil -> auto___def_5 X2 -> auto___def_52 X3 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_577 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_54_4;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_579 : forall X1 X2 X3 X4:term, auto___type_11 X1 -> auto___def_49 nil -> auto___def_5 X2 -> auto___def_52 X3 -> auto___type_10 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_49 nil -> auto___def_5 X2 -> auto___def_52 X3 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_578 X1 X2 X3 X4).
Qed.

Remark rem_580 : forall X1 X2 X3 X4:term, auto___def_48 (cons X1 nil) -> auto___def_5 X2 -> auto___def_52 X3 -> auto___type_10 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_443 X1 nil H);  intros.
  apply (rem_579 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_581 : forall X1 X2 X3 X4:term, auto___type_10 X4 -> auto___def_48 (cons X1 nil) -> auto___def_5 X2 -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_48 (cons X1 nil) -> auto___def_5 X2 -> auto___def_52 X3 -> auto___type_10 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_580 X1 X2 X3 X4).
Qed.

Remark rem_582 : forall X1 X2 X3 X4:term, auto___def_46 (cons X4 (cons X1 nil)) -> auto___def_5 X2 -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_446 X4 (cons X1 nil) H);  intros.
  apply (rem_581 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_583 : forall X1 X2 X3 X4:term, auto___def_46 (cons X4 (cons X1 nil)) -> auto___def_47 (key prv server) -> auto___def_5 X2 -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_46 (cons X4 (cons X1 nil)) -> auto___def_5 X2 -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_582 X1 X2 X3 X4).
Qed.

Remark rem_584 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_52 X3 -> auto___def_57 X1 -> auto___def_58 nil -> auto___type_14 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_553 X1)). tauto.
Qed.

Remark rem_585 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_58 nil -> auto___def_5 X2 -> auto___def_52 X3 -> auto___type_14 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_52 X3 -> auto___def_57 X1 -> auto___def_58 nil -> auto___type_14 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_584 X1 X2 X3 X4).
Qed.

Remark rem_586 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_52 X3 -> auto___def_56 (cons X1 nil) -> auto___type_14 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_505 X1 nil H);  intros.
  apply (rem_585 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_587 : forall X1 X2 X3 X4:term, auto___type_14 X4 -> auto___def_56 (cons X1 nil) -> auto___def_5 X2 -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_52 X3 -> auto___def_56 (cons X1 nil) -> auto___type_14 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_586 X1 X2 X3 X4).
Qed.

Remark rem_588 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_52 X3 -> auto___def_55 (cons X4 (cons X1 nil)) -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_508 X4 (cons X1 nil) H);  intros.
  apply (rem_587 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_589 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_52 X3 -> auto___def_55 (cons X4 (cons X1 nil)) -> auto___type_13 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_52 X3 -> auto___def_55 (cons X4 (cons X1 nil)) -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_588 X1 X2 X3 X4).
Qed.

Remark rem_590 : forall X1 X2 X3 X4:term, auto___def_55 (cons X4 (cons X1 nil)) -> auto___type_13 (key prv server) -> auto___def_5 X2 -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_52 X3 -> auto___def_55 (cons X4 (cons X1 nil)) -> auto___type_13 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_589 X1 X2 X3 X4).
Qed.

Remark rem_591 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_470 (cons X4 (cons X1 nil)) (key prv server) H);  intros.
  apply (rem_565 X1 X2 X3 X4);  tauto.
  apply (rem_567 X1 X2 X3 X4);  tauto.
  apply (rem_570 X1 X2 X3 X4);  tauto.
  apply (rem_583 X1 X2 X3 X4);  tauto.
  apply (rem_590 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_592 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto___def_5 X2 -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_591 X1 X2 X3 X4).
Qed.

Remark rem_593 : forall X1 X2 X3 X4:term, auto___def_52 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key prv server) -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current (key prv server) -> False). tauto.
  exact (rem_424).
Qed.

Remark rem_594 : forall X1 X2 X3 X4:term, auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key prv server) -> auto___def_52 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_52 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key prv server) -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_593 X1 X2 X3 X4).
Qed.

Remark rem_595 : forall X1 X2 X3 X4:term, auto___def_51 (cons X4 (cons X1 nil)) -> auto___def_52 X3 -> auto___def_7 X2 -> auto___type_12 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_12 (key prv server) -> False). tauto.
  exact (rem_428).
Qed.

Remark rem_596 : forall X1 X2 X3 X4:term, auto___def_51 (cons X4 (cons X1 nil)) -> auto___type_12 (key prv server) -> auto___def_52 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_51 (cons X4 (cons X1 nil)) -> auto___def_52 X3 -> auto___def_7 X2 -> auto___type_12 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_595 X1 X2 X3 X4).
Qed.

Remark rem_597 : forall X1 X2 X3 X4:term, auto___def_52 X3 -> auto___def_57 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_430 X4 (cons X1 nil) H);  intros.
Qed.

Remark rem_598 : forall X1 X2 X3 X4:term, auto___def_52 X3 -> auto___def_57 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_2 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_52 X3 -> auto___def_57 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_597 X1 X2 X3 X4).
Qed.

Remark rem_599 : forall X1 X2 X3 X4:term, auto___def_57 (cons X4 (cons X1 nil)) -> auto___type_2 (key prv server) -> auto___def_52 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_52 X3 -> auto___def_57 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_2 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_598 X1 X2 X3 X4).
Qed.

Remark rem_600 : forall X1 X2 X3 X4:term, auto___def_49 nil -> auto___def_52 X3 -> auto___def_7 X2 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_11 X1 -> auto___type_3 X1). tauto. exact (rem_306 X1).
Qed.

Remark rem_601 : forall X1 X2 X3 X4:term, auto___def_49 nil -> auto___def_52 X3 -> auto___def_7 X2 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_11 X1 -> auto_agent X1). tauto. exact (rem_315 X1).
Qed.

Remark rem_602 : forall X1 X2 X3 X4:term, auto___def_49 nil -> auto___def_52 X3 -> auto___def_7 X2 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_7 X2 -> auto___def_7 X2). tauto. exact (rem_394 X2).
Qed.

Remark rem_603 : forall X1 X2 X3 X4:term, auto___def_49 nil -> auto___def_52 X3 -> auto___def_7 X2 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_7 X2 -> auto_agent X2). tauto. exact (rem_399 X2).
Qed.

Remark rem_604 : forall X1 X2 X3 X4:term, auto___def_49 nil -> auto___def_52 X3 -> auto___def_7 X2 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_52 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_52 X3 -> auto___def_52 X3). tauto. exact (rem_529 X3).
Qed.

Remark rem_605 : forall X1 X2 X3 X4:term, auto___def_49 nil -> auto___def_52 X3 -> auto___def_7 X2 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_2 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_10 X4 -> auto___type_2 X4). tauto. exact (rem_438 X4).
Qed.

Remark rem_606 : forall X1 X2 X3 X4:term, auto___def_49 nil -> auto___def_52 X3 -> auto___def_7 X2 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> (auto___type_3 X1 /\ auto_agent X1 /\ auto___def_7 X2 /\ auto_agent X2 /\ auto___def_52 X3 /\ auto___type_2 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto___type_3 X1). 2:apply (rem_600 X1 X2 X3 X4);  assumption.
  cut (auto_agent X1). 2:apply (rem_601 X1 X2 X3 X4);  assumption.
  cut (auto___def_7 X2). 2:apply (rem_602 X1 X2 X3 X4);  assumption.
  cut (auto_agent X2). 2:apply (rem_603 X1 X2 X3 X4);  assumption.
  cut (auto___def_52 X3). 2:apply (rem_604 X1 X2 X3 X4);  assumption.
  cut (auto___type_2 X4). 2:apply (rem_605 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_607 : forall X1 X2 X3 X4:term, auto___def_49 nil -> auto___def_52 X3 -> auto___def_7 X2 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_606 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_54_3;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_608 : forall X1 X2 X3 X4:term, auto___type_11 X1 -> auto___def_49 nil -> auto___def_52 X3 -> auto___def_7 X2 -> auto___type_10 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_49 nil -> auto___def_52 X3 -> auto___def_7 X2 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_607 X1 X2 X3 X4).
Qed.

Remark rem_609 : forall X1 X2 X3 X4:term, auto___def_48 (cons X1 nil) -> auto___def_52 X3 -> auto___def_7 X2 -> auto___type_10 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_443 X1 nil H);  intros.
  apply (rem_608 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_610 : forall X1 X2 X3 X4:term, auto___type_10 X4 -> auto___def_48 (cons X1 nil) -> auto___def_52 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_48 (cons X1 nil) -> auto___def_52 X3 -> auto___def_7 X2 -> auto___type_10 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_609 X1 X2 X3 X4).
Qed.

Remark rem_611 : forall X1 X2 X3 X4:term, auto___def_46 (cons X4 (cons X1 nil)) -> auto___def_52 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_446 X4 (cons X1 nil) H);  intros.
  apply (rem_610 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_612 : forall X1 X2 X3 X4:term, auto___def_46 (cons X4 (cons X1 nil)) -> auto___def_47 (key prv server) -> auto___def_52 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_46 (cons X4 (cons X1 nil)) -> auto___def_52 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_611 X1 X2 X3 X4).
Qed.

Remark rem_613 : forall X1 X2 X3 X4:term, auto___def_52 X3 -> auto___def_57 X1 -> auto___def_58 nil -> auto___def_7 X2 -> auto___type_14 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_553 X1)). tauto.
Qed.

Remark rem_614 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_58 nil -> auto___def_52 X3 -> auto___def_7 X2 -> auto___type_14 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_52 X3 -> auto___def_57 X1 -> auto___def_58 nil -> auto___def_7 X2 -> auto___type_14 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_613 X1 X2 X3 X4).
Qed.

Remark rem_615 : forall X1 X2 X3 X4:term, auto___def_52 X3 -> auto___def_56 (cons X1 nil) -> auto___def_7 X2 -> auto___type_14 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_505 X1 nil H);  intros.
  apply (rem_614 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_616 : forall X1 X2 X3 X4:term, auto___type_14 X4 -> auto___def_56 (cons X1 nil) -> auto___def_52 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_52 X3 -> auto___def_56 (cons X1 nil) -> auto___def_7 X2 -> auto___type_14 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_615 X1 X2 X3 X4).
Qed.

Remark rem_617 : forall X1 X2 X3 X4:term, auto___def_52 X3 -> auto___def_55 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_508 X4 (cons X1 nil) H);  intros.
  apply (rem_616 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_618 : forall X1 X2 X3 X4:term, auto___def_52 X3 -> auto___def_55 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_13 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_52 X3 -> auto___def_55 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_617 X1 X2 X3 X4).
Qed.

Remark rem_619 : forall X1 X2 X3 X4:term, auto___def_55 (cons X4 (cons X1 nil)) -> auto___type_13 (key prv server) -> auto___def_52 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_52 X3 -> auto___def_55 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_13 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_618 X1 X2 X3 X4).
Qed.

Remark rem_620 : forall X1 X2 X3 X4:term, auto___def_52 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_470 (cons X4 (cons X1 nil)) (key prv server) H);  intros.
  apply (rem_594 X1 X2 X3 X4);  tauto.
  apply (rem_596 X1 X2 X3 X4);  tauto.
  apply (rem_599 X1 X2 X3 X4);  tauto.
  apply (rem_612 X1 X2 X3 X4);  tauto.
  apply (rem_619 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_621 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto___def_52 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_52 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_620 X1 X2 X3 X4).
Qed.

Remark rem_622 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto___def_7 X2 -> auto___def_52 X3 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_3 pub -> auto___def_52 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_621 X1 X2 X3 X4).
Qed.

Remark rem_623 : forall X1 X2 X3 X4:term, auto___def_52 X3 -> auto___type_12 (key pub X2) -> auto_agent X2 -> auto_agent X1 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_427 pub X2 H);  intros.
  apply (rem_563 X1 X2 X3 X4);  tauto.
  apply (rem_592 X1 X2 X3 X4);  tauto.
  apply (rem_622 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_624 : forall X1 X2 X3 X4:term, auto___def_17 nil -> auto___def_52 X3 -> auto___type_12 (key pub X2) -> auto_agent X2 -> auto_agent X1 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_52 X3 -> auto___type_12 (key pub X2) -> auto_agent X2 -> auto_agent X1 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_623 X1 X2 X3 X4).
Qed.

Remark rem_625 : forall X1 X2 X3 X4:term, auto_agent X1 -> auto___def_17 nil -> auto___def_52 X3 -> auto___type_12 (key pub X2) -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_17 nil -> auto___def_52 X3 -> auto___type_12 (key pub X2) -> auto_agent X2 -> auto_agent X1 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_624 X1 X2 X3 X4).
Qed.

Remark rem_626 : forall X1 X2:term, auto___def_53 (cons X1 X2) -> or_1
    (auto_agent X1 /\ auto___def_17 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_627 : forall X1 X2 X3 X4:term, auto___def_52 X3 -> auto___def_53 (cons X1 nil) -> auto___type_12 (key pub X2) -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_626 X1 nil H);  intros.
  apply (rem_625 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_628 : forall X1 X2:term, auto___def_51 (cons X1 X2) -> or_1
    (auto___def_52 X1 /\ auto___def_53 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_629 : forall X1 X2 X3 X4:term, auto___def_51 (cons X3 (cons X1 nil)) -> auto___type_12 (key pub X2) -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_628 X3 (cons X1 nil) H);  intros.
  apply (rem_627 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_630 : forall X1 X2 X3 X4:term, auto___def_57 (cons X3 (cons X1 nil)) -> auto___type_2 (key pub X2) -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_430 X3 (cons X1 nil) H);  intros.
Qed.

Remark rem_631 : forall X1 X2 X3 X4:term, auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key prv server) -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current (key prv server) -> False). tauto.
  exact (rem_424).
Qed.

Remark rem_632 : forall X1 X2 X3 X4:term, auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key prv server) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key prv server) -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_631 X1 X2 X3 X4).
Qed.

Remark rem_633 : forall X1 X2 X3 X4:term, auto___def_51 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto___type_12 (key prv server) -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_12 (key prv server) -> False). tauto.
  exact (rem_428).
Qed.

Remark rem_634 : forall X1 X2 X3 X4:term, auto___def_51 (cons X4 (cons X1 nil)) -> auto___type_12 (key prv server) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_51 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto___type_12 (key prv server) -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_633 X1 X2 X3 X4).
Qed.

Remark rem_635 : forall X1 X2 X3 X4:term, auto___def_57 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_430 X4 (cons X1 nil) H);  intros.
Qed.

Remark rem_636 : forall X1 X2 X3 X4:term, auto___def_57 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto___type_2 (key prv server) -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_57 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_635 X1 X2 X3 X4).
Qed.

Remark rem_637 : forall X1 X2 X3 X4:term, auto___def_57 (cons X4 (cons X1 nil)) -> auto___type_2 (key prv server) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto___type_2 (key prv server) -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_636 X1 X2 X3 X4).
Qed.

Remark rem_638 : forall X1 X2 X3 X4:term, auto___def_48 (cons X1 nil) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_11 X1 -> auto___type_3 X1). tauto. exact (rem_306 X1).
Qed.

Remark rem_639 : forall X1 X2 X3 X4:term, auto___def_48 (cons X1 nil) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto___type_9 X2. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Qed.

Remark rem_640 : forall X1 X2 X3 X4:term, auto___def_48 (cons X1 nil) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_7 X2 -> auto_agent X2). tauto. exact (rem_399 X2).
Qed.

Remark rem_641 : (forall X:term, auto___type_10 X -> auto_knows_current X)
    -> forall X1:term, auto___def_3 X1 -> auto___def_3 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_642 : (forall X:term, auto___type_10 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_10_pknows_current. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_641 epsilon_m__type_10_pknows_current X1).
Defined.

Remark rem_643 : (forall X:term, auto___type_10 X -> auto_knows_current X)
    -> forall X2:term, auto___def_2 X2 -> auto___type_9 X2. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Defined.

Remark rem_644 : (forall X:term, auto___type_10 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___type_9 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_10_pknows_current. intros X1 X2.
  cut (auto___def_2 X2 -> auto___type_9 X2). tauto. exact (rem_643 epsilon_m__type_10_pknows_current X2).
Defined.

Remark rem_645 : (forall X:term, auto___type_10 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> (auto___def_3 X1 /\ auto___type_9 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_10_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_642 epsilon_m__type_10_pknows_current X1 X2);  assumption.
  cut (auto___type_9 X2). 2:apply (rem_644 epsilon_m__type_10_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_646 : (forall X:term, auto___type_10 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_10_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_645 epsilon_m__type_10_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_10_pknows_current A1 A2. intros. apply trans_knows_current_key_2;  tauto.
 clear  epsilon_m__type_10_pknows_current A1 A2. tauto.
Defined.

Remark rem_647 : (forall X:term, auto___type_10 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_10_pknows_current. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_641 epsilon_m__type_10_pknows_current X1).
Defined.

Remark rem_648 : (forall X:term, auto___type_10 X -> auto_knows_current X)
    -> forall X2:term, auto___def_5 X2 -> auto___type_9 X2. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Defined.

Remark rem_649 : (forall X:term, auto___type_10 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___type_9 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_10_pknows_current. intros X1 X2.
  cut (auto___def_5 X2 -> auto___type_9 X2). tauto. exact (rem_648 epsilon_m__type_10_pknows_current X2).
Defined.

Remark rem_650 : (forall X:term, auto___type_10 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> (auto___def_3 X1 /\ auto___type_9 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_10_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_647 epsilon_m__type_10_pknows_current X1 X2);  assumption.
  cut (auto___type_9 X2). 2:apply (rem_649 epsilon_m__type_10_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_651 : (forall X:term, auto___type_10 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_10_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_650 epsilon_m__type_10_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_10_pknows_current A1 A2. intros. apply trans_knows_current_key_2;  tauto.
 clear  epsilon_m__type_10_pknows_current A1 A2. tauto.
Defined.

Remark rem_652 : (forall X:term, auto___type_10 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_10_pknows_current. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_641 epsilon_m__type_10_pknows_current X1).
Defined.

Remark rem_653 : (forall X:term, auto___type_10 X -> auto_knows_current X)
    -> forall X2:term, auto___def_7 X2 -> auto___type_9 X2. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Defined.

Remark rem_654 : (forall X:term, auto___type_10 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___type_9 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_10_pknows_current. intros X1 X2.
  cut (auto___def_7 X2 -> auto___type_9 X2). tauto. exact (rem_653 epsilon_m__type_10_pknows_current X2).
Defined.

Remark rem_655 : (forall X:term, auto___type_10 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> (auto___def_3 X1 /\ auto___type_9 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_10_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_652 epsilon_m__type_10_pknows_current X1 X2);  assumption.
  cut (auto___type_9 X2). 2:apply (rem_654 epsilon_m__type_10_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_656 : (forall X:term, auto___type_10 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_10_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_655 epsilon_m__type_10_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_10_pknows_current A1 A2. intros. apply trans_knows_current_key_2;  tauto.
 clear  epsilon_m__type_10_pknows_current A1 A2. tauto.
Defined.

Remark rem_657 : (forall X:term, auto___type_10 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_10 (key X1 X2) -> auto_knows_current (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_10_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_340 X1 X2 H);  intros.
  apply (rem_646 epsilon_m__type_10_pknows_current X1 X2);  tauto.
  apply (rem_651 epsilon_m__type_10_pknows_current X1 X2);  tauto.
  apply (rem_656 epsilon_m__type_10_pknows_current X1 X2);  tauto.
Defined.

Remark rem_658 : forall X3:term, auto___type_10 X3 -> auto_knows_current X3. (* Induct. *)
Proof.
  fix epsilon_m__type_10_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_352  H).
   intro H. elim (rem_350  H).
  intros X1 X2. intro H. elim (rem_348 X1 X2 H).
  intros X1 X2. intro H. elim (rem_349 X1 X2 H).
   intro H. elim (rem_344  H).
   intro H. elim (rem_356  H).
  intros X1 X2;  exact (rem_657 epsilon_m__type_10_pknows_current X1 X2).
   intro H. elim (rem_343  H).
  intros X1 X2 X3. intro H. elim (rem_347 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_351 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_355 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_353 X1 X2 X3 X4 H).
   intro H. elim (rem_358  H).
   intro H. elim (rem_354  H).
  intros X1. intro H. elim (rem_342 X1 H).
   intro H. elim (rem_357  H).
  intros X1 X2 X3. intro H. elim (rem_345 X1 X2 X3 H).
   intro H. elim (rem_346  H).
Qed.

Remark rem_659 : forall X1 X2 X3 X4:term, auto___def_48 (cons X1 nil) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto_knows_current X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_10 X3 -> auto_knows_current X3). tauto. exact (rem_658 X3).
Qed.

Remark rem_660 : forall X1 X2 X3 X4:term, auto___def_48 (cons X1 nil) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto___type_2 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_10 X4 -> auto___type_2 X4). tauto. exact (rem_438 X4).
Qed.

Remark rem_661 : forall X1 X2 X3 X4:term, auto___def_48 (cons X1 nil) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> (auto___type_3 X1 /\ auto___type_9 X2 /\ auto_agent X2 /\ auto_knows_current X3 /\ auto___type_2 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  cut (auto___type_3 X1). 2:apply (rem_638 X1 X2 X3 X4);  assumption.
  cut (auto___type_9 X2). 2:apply (rem_639 X1 X2 X3 X4);  assumption.
  cut (auto_agent X2). 2:apply (rem_640 X1 X2 X3 X4);  assumption.
  cut (auto_knows_current X3). 2:apply (rem_659 X1 X2 X3 X4);  assumption.
  cut (auto___type_2 X4). 2:apply (rem_660 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_662 : forall X1 X2 X3 X4:term, auto___def_48 (cons X1 nil) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  case (rem_661 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6). clear  A1 A2 A3 A4 A5 A6. intros. apply trans___def_54_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6. tauto.
Qed.

Remark rem_663 : forall X1 X2 X3 X4:term, auto___type_10 X4 -> auto___def_48 (cons X1 nil) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_48 (cons X1 nil) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_10 X4 -> auto___type_11 X1 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_662 X1 X2 X3 X4).
Qed.

Remark rem_664 : forall X1 X2 X3 X4:term, auto___def_46 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_446 X4 (cons X1 nil) H);  intros.
  apply (rem_663 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_665 : forall X1 X2 X3 X4:term, auto___def_46 (cons X4 (cons X1 nil)) -> auto___def_47 (key prv server) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_46 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_664 X1 X2 X3 X4).
Qed.

Remark rem_666 : (forall X:term, auto___type_11 X -> auto___def_57 X -> False)
    -> auto___def_57 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_11_m__def_57. intro H. intros.
  elim (rem_477 H);  intros.
Defined.

Remark rem_667 : (forall X:term, auto___type_11 X -> auto___def_57 X -> False)
    -> auto___type_11 bob -> auto___def_57 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_11_m__def_57. intro H. intros.
  elim (rem_283 H);  intros.
  apply (rem_666 epsilon_m__type_11_m__def_57);  tauto.
Defined.

Remark rem_668 : (forall X:term, auto___type_11 X -> auto___def_57 X -> False)
    -> auto___def_57 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_11_m__def_57. intro H. intros.
  elim (rem_485 H);  intros.
Defined.

Remark rem_669 : (forall X:term, auto___type_11 X -> auto___def_57 X -> False)
    -> auto___type_11 alice -> auto___def_57 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_11_m__def_57. intro H. intros.
  elim (rem_286 H);  intros.
  apply (rem_668 epsilon_m__type_11_m__def_57);  tauto.
Defined.

Remark rem_670 : (forall X:term, auto___type_11 X -> auto___def_57 X -> False)
    -> auto___def_57 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_11_m__def_57. intro H. intros.
  elim (rem_493 H);  intros.
Defined.

Remark rem_671 : (forall X:term, auto___type_11 X -> auto___def_57 X -> False)
    -> auto___type_11 server -> auto___def_57 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_11_m__def_57. intro H. intros.
  elim (rem_289 H);  intros.
  apply (rem_670 epsilon_m__type_11_m__def_57);  tauto.
Defined.

Remark rem_672 : forall X1:term, auto___type_11 X1 -> auto___def_57 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__type_11_m__def_57 1.
  intro X. case X.
  exact (rem_669 epsilon_m__type_11_m__def_57 ).
  exact (rem_667 epsilon_m__type_11_m__def_57 ).
  intros X1 X2. intro H. elim (rem_297 X1 X2 H).
  intros X1 X2. intro H. elim (rem_298 X1 X2 H).
   intro H. elim (rem_293  H).
   intro H. elim (rem_304  H).
  intros X1 X2. intro H. elim (rem_299 X1 X2 H).
   intro H. elim (rem_292  H).
  intros X1 X2 X3. intro H. elim (rem_296 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_300 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_303 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_301 X1 X2 X3 X4 H).
   intro H. elim (rem_305  H).
   intro H. elim (rem_302  H).
  intros X1. intro H. elim (rem_291 X1 H).
  exact (rem_671 epsilon_m__type_11_m__def_57 ).
  intros X1 X2 X3. intro H. elim (rem_294 X1 X2 X3 H).
   intro H. elim (rem_295  H).
Qed.

Remark rem_673 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_58 nil -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto___type_14 X4 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_672 X1)). tauto.
Qed.

Remark rem_674 : forall X1 X2 X3 X4:term, auto___def_56 (cons X1 nil) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto___type_14 X4 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_505 X1 nil H);  intros.
  apply (rem_673 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_675 : forall X1 X2 X3 X4:term, auto___type_14 X4 -> auto___def_56 (cons X1 nil) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 (cons X1 nil) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto___type_14 X4 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_674 X1 X2 X3 X4).
Qed.

Remark rem_676 : forall X1 X2 X3 X4:term, auto___def_55 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_508 X4 (cons X1 nil) H);  intros.
  apply (rem_675 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_677 : forall X1 X2 X3 X4:term, auto___def_55 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto___type_13 (key prv server) -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_55 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_676 X1 X2 X3 X4).
Qed.

Remark rem_678 : forall X1 X2 X3 X4:term, auto___def_55 (cons X4 (cons X1 nil)) -> auto___type_13 (key prv server) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_55 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto___type_13 (key prv server) -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_677 X1 X2 X3 X4).
Qed.

Remark rem_679 : forall X1 X2 X3 X4:term, auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_470 (cons X4 (cons X1 nil)) (key prv server) H);  intros.
  apply (rem_632 X1 X2 X3 X4);  tauto.
  apply (rem_634 X1 X2 X3 X4);  tauto.
  apply (rem_637 X1 X2 X3 X4);  tauto.
  apply (rem_665 X1 X2 X3 X4);  tauto.
  apply (rem_678 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_680 : forall X1 X2 X3 X4:term, auto___def_49 nil -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_679 X1 X2 X3 X4).
Qed.

Remark rem_681 : forall X1 X2 X3 X4:term, auto___type_11 X1 -> auto___def_49 nil -> auto___def_7 X2 -> auto___type_10 X3 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_49 nil -> auto___def_7 X2 -> auto___type_10 X3 -> auto___type_11 X1 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_680 X1 X2 X3 X4).
Qed.

Remark rem_682 : forall X1 X2 X3 X4:term, auto___def_48 (cons X1 nil) -> auto___def_7 X2 -> auto___type_10 X3 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_443 X1 nil H);  intros.
  apply (rem_681 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_683 : forall X1 X2 X3 X4:term, auto___def_23 pub -> auto___def_48 (cons X1 nil) -> auto___def_7 X2 -> auto___type_10 X3 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_48 (cons X1 nil) -> auto___def_7 X2 -> auto___type_10 X3 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_682 X1 X2 X3 X4).
Qed.

Remark rem_684 : forall X1 X2 X3 X4:term, auto___def_23 pub -> auto___def_7 X2 -> auto___def_48 (cons X1 nil) -> auto___type_10 X3 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_23 pub -> auto___def_48 (cons X1 nil) -> auto___def_7 X2 -> auto___type_10 X3 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_683 X1 X2 X3 X4).
Qed.

Remark rem_685 : forall X1 X2:term, auto___def_47 (key X1 X2) -> or_1
    (auto___def_23 X1 /\ auto___def_7 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_686 : forall X1 X2 X3 X4:term, auto___def_47 (key pub X2) -> auto___def_48 (cons X1 nil) -> auto___type_10 X3 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_685 pub X2 H);  intros.
  apply (rem_684 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_687 : forall X1 X2 X3 X4:term, auto___type_10 X3 -> auto___def_48 (cons X1 nil) -> auto___def_47 (key pub X2) -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_47 (key pub X2) -> auto___def_48 (cons X1 nil) -> auto___type_10 X3 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_686 X1 X2 X3 X4).
Qed.

Remark rem_688 : forall X1 X2 X3 X4:term, auto___def_46 (cons X3 (cons X1 nil)) -> auto___def_47 (key pub X2) -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_446 X3 (cons X1 nil) H);  intros.
  apply (rem_687 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_689 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current nil -> auto___def_54 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_503 X1)). tauto.
Qed.

Remark rem_690 : forall X1 X2 X3 X4:term, auto_knows_current X1 -> auto_knows_current nil -> auto___def_2 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current X4 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current nil -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_689 X1 X2 X3 X4).
Qed.

Remark rem_691 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current X4 -> auto_knows_current (cons X1 nil) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4 H5. intro H. intros.
  elim (rem_462 X1 nil H);  intros.
  apply (rem_690 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_692 : forall X1 X2 X3 X4:term, auto_knows_current X4 -> auto_knows_current (cons X1 nil) -> auto___def_2 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current X4 -> auto_knows_current (cons X1 nil) -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_691 X1 X2 X3 X4).
Qed.

Remark rem_693 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_462 X4 (cons X1 nil) H);  intros.
  apply (rem_692 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_694 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key prv server) -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_693 X1 X2 X3 X4).
Qed.

Remark rem_695 : forall X1 X2 X3 X4:term, auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key prv server) -> auto___def_2 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key prv server) -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_694 X1 X2 X3 X4).
Qed.

Remark rem_696 : forall X1 X2 X3 X4:term, auto___def_17 nil -> auto___def_2 X2 -> auto___def_52 X4 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_553 X1)). tauto.
Qed.

Remark rem_697 : forall X1 X2 X3 X4:term, auto_agent X1 -> auto___def_17 nil -> auto___def_2 X2 -> auto___def_52 X4 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_17 nil -> auto___def_2 X2 -> auto___def_52 X4 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_696 X1 X2 X3 X4).
Qed.

Remark rem_698 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_52 X4 -> auto___def_53 (cons X1 nil) -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_626 X1 nil H);  intros.
  apply (rem_697 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_699 : forall X1 X2 X3 X4:term, auto___def_52 X4 -> auto___def_53 (cons X1 nil) -> auto___def_2 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_52 X4 -> auto___def_53 (cons X1 nil) -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_698 X1 X2 X3 X4).
Qed.

Remark rem_700 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_51 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_628 X4 (cons X1 nil) H);  intros.
  apply (rem_699 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_701 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_51 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___type_12 (key prv server) -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_51 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_700 X1 X2 X3 X4).
Qed.

Remark rem_702 : forall X1 X2 X3 X4:term, auto___def_51 (cons X4 (cons X1 nil)) -> auto___type_12 (key prv server) -> auto___def_2 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_51 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___type_12 (key prv server) -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_701 X1 X2 X3 X4).
Qed.

Remark rem_703 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_57 X1 -> auto___def_57 (cons X4 (cons X1 nil)) -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_430 X4 (cons X1 nil) H);  intros.
Qed.

Remark rem_704 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_57 X1 -> auto___def_57 (cons X4 (cons X1 nil)) -> auto___type_14 X3 -> auto___type_2 (key prv server) -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_57 X1 -> auto___def_57 (cons X4 (cons X1 nil)) -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_703 X1 X2 X3 X4).
Qed.

Remark rem_705 : forall X1 X2 X3 X4:term, auto___def_57 (cons X4 (cons X1 nil)) -> auto___type_2 (key prv server) -> auto___def_2 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_57 X1 -> auto___def_57 (cons X4 (cons X1 nil)) -> auto___type_14 X3 -> auto___type_2 (key prv server) -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_704 X1 X2 X3 X4).
Qed.

Remark rem_706 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_49 nil -> auto___def_57 X1 -> auto___type_10 X4 -> auto___type_11 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_672 X1)). tauto.
Qed.

Remark rem_707 : forall X1 X2 X3 X4:term, auto___type_11 X1 -> auto___def_49 nil -> auto___def_2 X2 -> auto___def_57 X1 -> auto___type_10 X4 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_49 nil -> auto___def_57 X1 -> auto___type_10 X4 -> auto___type_11 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_706 X1 X2 X3 X4).
Qed.

Remark rem_708 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_48 (cons X1 nil) -> auto___def_57 X1 -> auto___type_10 X4 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_443 X1 nil H);  intros.
  apply (rem_707 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_709 : forall X1 X2 X3 X4:term, auto___type_10 X4 -> auto___def_48 (cons X1 nil) -> auto___def_2 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_48 (cons X1 nil) -> auto___def_57 X1 -> auto___type_10 X4 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_708 X1 X2 X3 X4).
Qed.

Remark rem_710 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_46 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_446 X4 (cons X1 nil) H);  intros.
  apply (rem_709 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_711 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_46 (cons X4 (cons X1 nil)) -> auto___def_47 (key prv server) -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_46 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_710 X1 X2 X3 X4).
Qed.

Remark rem_712 : forall X1 X2 X3 X4:term, auto___def_46 (cons X4 (cons X1 nil)) -> auto___def_47 (key prv server) -> auto___def_2 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_46 (cons X4 (cons X1 nil)) -> auto___def_47 (key prv server) -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_711 X1 X2 X3 X4).
Qed.

Remark rem_713 : auto___def_58 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_714 : auto___def_58 nil -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_713 H);  intros.
Qed.

Remark rem_715 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_57 X1 -> auto___def_58 nil -> auto___type_14 X3 -> auto___type_14 X4 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_58 nil -> False). tauto.
  exact (rem_714).
Qed.

Remark rem_716 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_58 nil -> auto___def_2 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto___type_14 X4 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_57 X1 -> auto___def_58 nil -> auto___type_14 X3 -> auto___type_14 X4 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_715 X1 X2 X3 X4).
Qed.

Remark rem_717 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_56 (cons X1 nil) -> auto___def_57 X1 -> auto___type_14 X3 -> auto___type_14 X4 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_505 X1 nil H);  intros.
  apply (rem_716 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_718 : forall X1 X2 X3 X4:term, auto___type_14 X4 -> auto___def_56 (cons X1 nil) -> auto___def_2 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_56 (cons X1 nil) -> auto___def_57 X1 -> auto___type_14 X3 -> auto___type_14 X4 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_717 X1 X2 X3 X4).
Qed.

Remark rem_719 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_55 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_508 X4 (cons X1 nil) H);  intros.
  apply (rem_718 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_720 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_55 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___type_13 (key prv server) -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_55 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_719 X1 X2 X3 X4).
Qed.

Remark rem_721 : forall X1 X2 X3 X4:term, auto___def_55 (cons X4 (cons X1 nil)) -> auto___type_13 (key prv server) -> auto___def_2 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_55 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___type_13 (key prv server) -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_720 X1 X2 X3 X4).
Qed.

Remark rem_722 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_470 (cons X4 (cons X1 nil)) (key prv server) H);  intros.
  apply (rem_695 X1 X2 X3 X4);  tauto.
  apply (rem_702 X1 X2 X3 X4);  tauto.
  apply (rem_705 X1 X2 X3 X4);  tauto.
  apply (rem_712 X1 X2 X3 X4);  tauto.
  apply (rem_721 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_723 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_3 pub -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_722 X1 X2 X3 X4).
Qed.

Remark rem_724 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto___def_2 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_3 pub -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_723 X1 X2 X3 X4).
Qed.

Remark rem_725 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current nil -> auto___def_54 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_503 X1)). tauto.
Qed.

Remark rem_726 : forall X1 X2 X3 X4:term, auto_knows_current X1 -> auto_knows_current nil -> auto___def_5 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current X4 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current nil -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_725 X1 X2 X3 X4).
Qed.

Remark rem_727 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current X4 -> auto_knows_current (cons X1 nil) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4 H5. intro H. intros.
  elim (rem_462 X1 nil H);  intros.
  apply (rem_726 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_728 : forall X1 X2 X3 X4:term, auto_knows_current X4 -> auto_knows_current (cons X1 nil) -> auto___def_5 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current X4 -> auto_knows_current (cons X1 nil) -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_727 X1 X2 X3 X4).
Qed.

Remark rem_729 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_462 X4 (cons X1 nil) H);  intros.
  apply (rem_728 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_730 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key prv server) -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_729 X1 X2 X3 X4).
Qed.

Remark rem_731 : forall X1 X2 X3 X4:term, auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key prv server) -> auto___def_5 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key prv server) -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_730 X1 X2 X3 X4).
Qed.

Remark rem_732 : forall X1 X2 X3 X4:term, auto___def_17 nil -> auto___def_5 X2 -> auto___def_52 X4 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_553 X1)). tauto.
Qed.

Remark rem_733 : forall X1 X2 X3 X4:term, auto_agent X1 -> auto___def_17 nil -> auto___def_5 X2 -> auto___def_52 X4 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_17 nil -> auto___def_5 X2 -> auto___def_52 X4 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_732 X1 X2 X3 X4).
Qed.

Remark rem_734 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_52 X4 -> auto___def_53 (cons X1 nil) -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_626 X1 nil H);  intros.
  apply (rem_733 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_735 : forall X1 X2 X3 X4:term, auto___def_52 X4 -> auto___def_53 (cons X1 nil) -> auto___def_5 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_52 X4 -> auto___def_53 (cons X1 nil) -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_734 X1 X2 X3 X4).
Qed.

Remark rem_736 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_51 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_628 X4 (cons X1 nil) H);  intros.
  apply (rem_735 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_737 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_51 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___type_12 (key prv server) -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_51 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_736 X1 X2 X3 X4).
Qed.

Remark rem_738 : forall X1 X2 X3 X4:term, auto___def_51 (cons X4 (cons X1 nil)) -> auto___type_12 (key prv server) -> auto___def_5 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_51 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___type_12 (key prv server) -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_737 X1 X2 X3 X4).
Qed.

Remark rem_739 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_57 X1 -> auto___def_57 (cons X4 (cons X1 nil)) -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_430 X4 (cons X1 nil) H);  intros.
Qed.

Remark rem_740 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_57 X1 -> auto___def_57 (cons X4 (cons X1 nil)) -> auto___type_14 X3 -> auto___type_2 (key prv server) -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_57 X1 -> auto___def_57 (cons X4 (cons X1 nil)) -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_739 X1 X2 X3 X4).
Qed.

Remark rem_741 : forall X1 X2 X3 X4:term, auto___def_57 (cons X4 (cons X1 nil)) -> auto___type_2 (key prv server) -> auto___def_5 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_57 X1 -> auto___def_57 (cons X4 (cons X1 nil)) -> auto___type_14 X3 -> auto___type_2 (key prv server) -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_740 X1 X2 X3 X4).
Qed.

Remark rem_742 : forall X1 X2 X3 X4:term, auto___def_49 nil -> auto___def_5 X2 -> auto___def_57 X1 -> auto___type_10 X4 -> auto___type_11 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_672 X1)). tauto.
Qed.

Remark rem_743 : forall X1 X2 X3 X4:term, auto___type_11 X1 -> auto___def_49 nil -> auto___def_5 X2 -> auto___def_57 X1 -> auto___type_10 X4 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_49 nil -> auto___def_5 X2 -> auto___def_57 X1 -> auto___type_10 X4 -> auto___type_11 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_742 X1 X2 X3 X4).
Qed.

Remark rem_744 : forall X1 X2 X3 X4:term, auto___def_48 (cons X1 nil) -> auto___def_5 X2 -> auto___def_57 X1 -> auto___type_10 X4 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_443 X1 nil H);  intros.
  apply (rem_743 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_745 : forall X1 X2 X3 X4:term, auto___type_10 X4 -> auto___def_48 (cons X1 nil) -> auto___def_5 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_48 (cons X1 nil) -> auto___def_5 X2 -> auto___def_57 X1 -> auto___type_10 X4 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_744 X1 X2 X3 X4).
Qed.

Remark rem_746 : forall X1 X2 X3 X4:term, auto___def_46 (cons X4 (cons X1 nil)) -> auto___def_5 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_446 X4 (cons X1 nil) H);  intros.
  apply (rem_745 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_747 : forall X1 X2 X3 X4:term, auto___def_46 (cons X4 (cons X1 nil)) -> auto___def_47 (key prv server) -> auto___def_5 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_46 (cons X4 (cons X1 nil)) -> auto___def_5 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_746 X1 X2 X3 X4).
Qed.

Remark rem_748 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_57 X1 -> auto___def_58 nil -> auto___type_14 X3 -> auto___type_14 X4 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_58 nil -> False). tauto.
  exact (rem_714).
Qed.

Remark rem_749 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_58 nil -> auto___def_5 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto___type_14 X4 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_57 X1 -> auto___def_58 nil -> auto___type_14 X3 -> auto___type_14 X4 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_748 X1 X2 X3 X4).
Qed.

Remark rem_750 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_56 (cons X1 nil) -> auto___def_57 X1 -> auto___type_14 X3 -> auto___type_14 X4 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_505 X1 nil H);  intros.
  apply (rem_749 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_751 : forall X1 X2 X3 X4:term, auto___type_14 X4 -> auto___def_56 (cons X1 nil) -> auto___def_5 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_56 (cons X1 nil) -> auto___def_57 X1 -> auto___type_14 X3 -> auto___type_14 X4 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_750 X1 X2 X3 X4).
Qed.

Remark rem_752 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_55 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_508 X4 (cons X1 nil) H);  intros.
  apply (rem_751 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_753 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_55 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___type_13 (key prv server) -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_55 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_752 X1 X2 X3 X4).
Qed.

Remark rem_754 : forall X1 X2 X3 X4:term, auto___def_55 (cons X4 (cons X1 nil)) -> auto___type_13 (key prv server) -> auto___def_5 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_55 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___type_13 (key prv server) -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_753 X1 X2 X3 X4).
Qed.

Remark rem_755 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_470 (cons X4 (cons X1 nil)) (key prv server) H);  intros.
  apply (rem_731 X1 X2 X3 X4);  tauto.
  apply (rem_738 X1 X2 X3 X4);  tauto.
  apply (rem_741 X1 X2 X3 X4);  tauto.
  apply (rem_747 X1 X2 X3 X4);  tauto.
  apply (rem_754 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_756 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto___def_5 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_755 X1 X2 X3 X4).
Qed.

Remark rem_757 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current nil -> auto___def_54 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_503 X1)). tauto.
Qed.

Remark rem_758 : forall X1 X2 X3 X4:term, auto_knows_current X1 -> auto_knows_current nil -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current X4 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current X4 -> auto_knows_current X1 -> auto_knows_current nil -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_757 X1 X2 X3 X4).
Qed.

Remark rem_759 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current X4 -> auto_knows_current (cons X1 nil) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4 H5. intro H. intros.
  elim (rem_462 X1 nil H);  intros.
  apply (rem_758 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_760 : forall X1 X2 X3 X4:term, auto_knows_current X4 -> auto_knows_current (cons X1 nil) -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current X4 -> auto_knows_current (cons X1 nil) -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_759 X1 X2 X3 X4).
Qed.

Remark rem_761 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_462 X4 (cons X1 nil) H);  intros.
  apply (rem_760 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_762 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key prv server) -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_761 X1 X2 X3 X4).
Qed.

Remark rem_763 : forall X1 X2 X3 X4:term, auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key prv server) -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (cons X4 (cons X1 nil)) -> auto_knows_current (key prv server) -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_762 X1 X2 X3 X4).
Qed.

Remark rem_764 : forall X1 X2 X3 X4:term, auto___def_17 nil -> auto___def_52 X4 -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_553 X1)). tauto.
Qed.

Remark rem_765 : forall X1 X2 X3 X4:term, auto_agent X1 -> auto___def_17 nil -> auto___def_52 X4 -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_17 nil -> auto___def_52 X4 -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_764 X1 X2 X3 X4).
Qed.

Remark rem_766 : forall X1 X2 X3 X4:term, auto___def_52 X4 -> auto___def_53 (cons X1 nil) -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_626 X1 nil H);  intros.
  apply (rem_765 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_767 : forall X1 X2 X3 X4:term, auto___def_51 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_628 X4 (cons X1 nil) H);  intros.
  apply (rem_766 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_768 : forall X1 X2 X3 X4:term, auto___def_51 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_12 (key prv server) -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_51 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_767 X1 X2 X3 X4).
Qed.

Remark rem_769 : forall X1 X2 X3 X4:term, auto___def_51 (cons X4 (cons X1 nil)) -> auto___type_12 (key prv server) -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_51 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_12 (key prv server) -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_768 X1 X2 X3 X4).
Qed.

Remark rem_770 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_57 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_430 X4 (cons X1 nil) H);  intros.
Qed.

Remark rem_771 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_57 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_14 X3 -> auto___type_2 (key prv server) -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_57 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_770 X1 X2 X3 X4).
Qed.

Remark rem_772 : forall X1 X2 X3 X4:term, auto___def_57 (cons X4 (cons X1 nil)) -> auto___type_2 (key prv server) -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_57 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_14 X3 -> auto___type_2 (key prv server) -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_771 X1 X2 X3 X4).
Qed.

Remark rem_773 : forall X1 X2 X3 X4:term, auto___def_49 nil -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_10 X4 -> auto___type_11 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_672 X1)). tauto.
Qed.

Remark rem_774 : forall X1 X2 X3 X4:term, auto___type_11 X1 -> auto___def_49 nil -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_10 X4 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_49 nil -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_10 X4 -> auto___type_11 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_773 X1 X2 X3 X4).
Qed.

Remark rem_775 : forall X1 X2 X3 X4:term, auto___def_48 (cons X1 nil) -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_10 X4 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_443 X1 nil H);  intros.
  apply (rem_774 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_776 : forall X1 X2 X3 X4:term, auto___type_10 X4 -> auto___def_48 (cons X1 nil) -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_48 (cons X1 nil) -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_10 X4 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_775 X1 X2 X3 X4).
Qed.

Remark rem_777 : forall X1 X2 X3 X4:term, auto___def_46 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_446 X4 (cons X1 nil) H);  intros.
  apply (rem_776 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_778 : forall X1 X2 X3 X4:term, auto___def_46 (cons X4 (cons X1 nil)) -> auto___def_47 (key prv server) -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_46 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_777 X1 X2 X3 X4).
Qed.

Remark rem_779 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_58 nil -> auto___def_7 X2 -> auto___type_14 X3 -> auto___type_14 X4 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_58 nil -> False). tauto.
  exact (rem_714).
Qed.

Remark rem_780 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_58 nil -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto___type_14 X4 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_58 nil -> auto___def_7 X2 -> auto___type_14 X3 -> auto___type_14 X4 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_779 X1 X2 X3 X4).
Qed.

Remark rem_781 : forall X1 X2 X3 X4:term, auto___def_56 (cons X1 nil) -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto___type_14 X4 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_505 X1 nil H);  intros.
  apply (rem_780 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_782 : forall X1 X2 X3 X4:term, auto___type_14 X4 -> auto___def_56 (cons X1 nil) -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 (cons X1 nil) -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto___type_14 X4 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_781 X1 X2 X3 X4).
Qed.

Remark rem_783 : forall X1 X2 X3 X4:term, auto___def_55 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_508 X4 (cons X1 nil) H);  intros.
  apply (rem_782 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_784 : forall X1 X2 X3 X4:term, auto___def_55 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_13 (key prv server) -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_55 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_783 X1 X2 X3 X4).
Qed.

Remark rem_785 : forall X1 X2 X3 X4:term, auto___def_55 (cons X4 (cons X1 nil)) -> auto___type_13 (key prv server) -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_55 (cons X4 (cons X1 nil)) -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_13 (key prv server) -> auto___type_14 X3 -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_784 X1 X2 X3 X4).
Qed.

Remark rem_786 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_470 (cons X4 (cons X1 nil)) (key prv server) H);  intros.
  apply (rem_763 X1 X2 X3 X4);  tauto.
  apply (rem_769 X1 X2 X3 X4);  tauto.
  apply (rem_772 X1 X2 X3 X4);  tauto.
  apply (rem_778 X1 X2 X3 X4);  tauto.
  apply (rem_785 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_787 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_786 X1 X2 X3 X4).
Qed.

Remark rem_788 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto___def_7 X2 -> auto___def_57 X1 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_3 pub -> auto___def_57 X1 -> auto___def_7 X2 -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_787 X1 X2 X3 X4).
Qed.

Remark rem_789 : forall X1 X2:term, auto___type_13 (key X1 X2) -> or_3
    (auto___def_3 X1 /\ auto___def_2 X2)
    (auto___def_3 X1 /\ auto___def_5 X2)
    (auto___def_3 X1 /\ auto___def_7 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_790 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___type_13 (key pub X2) -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_789 pub X2 H);  intros.
  apply (rem_724 X1 X2 X3 X4);  tauto.
  apply (rem_756 X1 X2 X3 X4);  tauto.
  apply (rem_788 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_791 : forall X1 X2 X3 X4:term, auto___def_57 X1 -> auto___def_58 nil -> auto___type_13 (key pub X2) -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_57 X1 -> auto___type_13 (key pub X2) -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4). tauto.
  exact (rem_790 X1 X2 X3 X4).
Qed.

Remark rem_792 : forall X1 X2 X3 X4:term, auto___def_56 (cons X1 nil) -> auto___type_13 (key pub X2) -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_505 X1 nil H);  intros.
  apply (rem_791 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_793 : forall X1 X2 X3 X4:term, auto___type_14 X3 -> auto___def_56 (cons X1 nil) -> auto___type_13 (key pub X2) -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 (cons X1 nil) -> auto___type_13 (key pub X2) -> auto___type_14 X3 -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_792 X1 X2 X3 X4).
Qed.

Remark rem_794 : forall X1 X2 X3 X4:term, auto___def_55 (cons X3 (cons X1 nil)) -> auto___type_13 (key pub X2) -> auto_agent X2 -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_508 X3 (cons X1 nil) H);  intros.
  apply (rem_793 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_795 : forall X1 X2 X3 X4:term, auto_agent X2 -> auto_knows_current (crypt (cons X3 (cons X1 nil)) (key pub X2)) -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_470 (cons X3 (cons X1 nil)) (key pub X2) H);  intros.
  apply (rem_517 X1 X2 X3 X4);  tauto.
  apply (rem_629 X1 X2 X3 X4);  tauto.
  apply (rem_630 X1 X2 X3 X4);  tauto.
  apply (rem_688 X1 X2 X3 X4);  tauto.
  apply (rem_794 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_796 : forall X1 X2 X3 X4:term, auto_knows_current (crypt (cons X3 (cons X1 nil)) (key pub X2)) -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto_agent X2 -> auto___def_54 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_agent X2 -> auto_knows_current (crypt (cons X3 (cons X1 nil)) (key pub X2)) -> auto_knows_current (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_54 X1 X2 X3 X4). tauto. exact (rem_795 X1 X2 X3 X4).
Qed.

Remark rem_797 : forall X1 X2:term, auto___def_2 X2 -> auto___def_3 sym -> auto___def_32 X1 -> auto___def_14 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 sym -> False). tauto.
  exact (rem_232).
Qed.

Remark rem_798 : forall X1 X2:term, auto___def_3 sym -> auto___def_2 X2 -> auto___def_32 X1 -> auto___def_14 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_2 X2 -> auto___def_3 sym -> auto___def_32 X1 -> auto___def_14 X1 X2). tauto. exact (rem_797 X1 X2).
Qed.

Remark rem_799 : forall X1 X2:term, auto___def_3 sym -> auto___def_32 X1 -> auto___def_5 X2 -> auto___def_14 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 sym -> False). tauto.
  exact (rem_232).
Qed.

Remark rem_800 : forall X1 X2:term, auto___def_3 sym -> auto___def_5 X2 -> auto___def_32 X1 -> auto___def_14 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_3 sym -> auto___def_32 X1 -> auto___def_5 X2 -> auto___def_14 X1 X2). tauto. exact (rem_799 X1 X2).
Qed.

Remark rem_801 : forall X1 X2:term, auto___def_3 sym -> auto___def_32 X1 -> auto___def_7 X2 -> auto___def_14 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 sym -> False). tauto.
  exact (rem_232).
Qed.

Remark rem_802 : forall X1 X2:term, auto___def_3 sym -> auto___def_7 X2 -> auto___def_32 X1 -> auto___def_14 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_3 sym -> auto___def_32 X1 -> auto___def_7 X2 -> auto___def_14 X1 X2). tauto. exact (rem_801 X1 X2).
Qed.

Remark rem_803 : forall X1 X2:term, auto___def_32 X1 -> auto___type_2 (key sym X2) -> auto___def_14 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_145 sym X2 H);  intros.
  apply (rem_798 X1 X2);  tauto.
  apply (rem_800 X1 X2);  tauto.
  apply (rem_802 X1 X2);  tauto.
Qed.

Remark rem_804 : forall X1 X2:term, auto___def_2 X2 -> auto___def_25 X1 -> auto___def_3 sym -> auto___def_14 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 sym -> False). tauto.
  exact (rem_232).
Qed.

Remark rem_805 : forall X1 X2:term, auto___def_3 sym -> auto___def_2 X2 -> auto___def_25 X1 -> auto___def_14 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_2 X2 -> auto___def_25 X1 -> auto___def_3 sym -> auto___def_14 X1 X2). tauto. exact (rem_804 X1 X2).
Qed.

Remark rem_806 : forall X1 X2:term, auto___def_25 X1 -> auto___def_3 sym -> auto___def_5 X2 -> auto___def_14 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 sym -> False). tauto.
  exact (rem_232).
Qed.

Remark rem_807 : forall X1 X2:term, auto___def_3 sym -> auto___def_5 X2 -> auto___def_25 X1 -> auto___def_14 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_25 X1 -> auto___def_3 sym -> auto___def_5 X2 -> auto___def_14 X1 X2). tauto. exact (rem_806 X1 X2).
Qed.

Remark rem_808 : forall X1 X2:term, auto___def_25 X1 -> auto___def_3 sym -> auto___def_7 X2 -> auto___def_14 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 sym -> False). tauto.
  exact (rem_232).
Qed.

Remark rem_809 : forall X1 X2:term, auto___def_3 sym -> auto___def_7 X2 -> auto___def_25 X1 -> auto___def_14 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_25 X1 -> auto___def_3 sym -> auto___def_7 X2 -> auto___def_14 X1 X2). tauto. exact (rem_808 X1 X2).
Qed.

Remark rem_810 : forall X1 X2:term, auto___def_25 X1 -> auto___type_4 (key sym X2) -> auto___def_14 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_153 sym X2 H);  intros.
  apply (rem_805 X1 X2);  tauto.
  apply (rem_807 X1 X2);  tauto.
  apply (rem_809 X1 X2);  tauto.
Qed.

Remark rem_811 : forall X1 X2:term, auto___def_19 X1 -> auto___def_23 sym -> auto___def_7 X2 -> auto___def_14 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_23 sym -> False). tauto.
  exact (rem_229).
Qed.

Remark rem_812 : forall X1 X2:term, auto___def_23 sym -> auto___def_7 X2 -> auto___def_19 X1 -> auto___def_14 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_19 X1 -> auto___def_23 sym -> auto___def_7 X2 -> auto___def_14 X1 X2). tauto. exact (rem_811 X1 X2).
Qed.

Remark rem_813 : forall X1 X2:term, auto___def_19 X1 -> auto___def_20 (key sym X2) -> auto___def_14 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_162 sym X2 H);  intros.
  apply (rem_812 X1 X2);  tauto.
Qed.

Remark rem_814 : forall X1 X2:term, auto___def_23 sym -> auto___def_36 X2 -> auto_knows_old X1 -> auto___def_14 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_23 sym -> False). tauto.
  exact (rem_229).
Qed.

Remark rem_815 : forall X1 X2:term, auto___def_3 sym -> auto_knows_old X1 -> auto___def_14 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 sym -> False). tauto.
  exact (rem_232).
Qed.

Remark rem_816 : forall X1 X2:term, auto___def_3 sym -> auto___type_9 X2 -> auto_knows_old X1 -> auto___def_14 X1 X2. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2. intros. apply (rem_815 X1 X2);  assumption.
Qed.

Remark rem_817 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old (key sym X2) -> auto___def_14 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_172 sym X2 H);  intros.
  apply (rem_814 X1 X2);  tauto.
  apply (rem_816 X1 X2);  tauto.
Qed.

Remark rem_818 : forall X1 X2:term, auto___def_2 X2 -> auto___def_3 sym -> auto___def_30 X1 -> auto___def_14 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 sym -> False). tauto.
  exact (rem_232).
Qed.

Remark rem_819 : forall X1 X2:term, auto___def_3 sym -> auto___def_2 X2 -> auto___def_30 X1 -> auto___def_14 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_2 X2 -> auto___def_3 sym -> auto___def_30 X1 -> auto___def_14 X1 X2). tauto. exact (rem_818 X1 X2).
Qed.

Remark rem_820 : forall X1 X2:term, auto___def_3 sym -> auto___def_30 X1 -> auto___def_5 X2 -> auto___def_14 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 sym -> False). tauto.
  exact (rem_232).
Qed.

Remark rem_821 : forall X1 X2:term, auto___def_3 sym -> auto___def_5 X2 -> auto___def_30 X1 -> auto___def_14 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_3 sym -> auto___def_30 X1 -> auto___def_5 X2 -> auto___def_14 X1 X2). tauto. exact (rem_820 X1 X2).
Qed.

Remark rem_822 : forall X1 X2:term, auto___def_3 sym -> auto___def_30 X1 -> auto___def_7 X2 -> auto___def_14 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 sym -> False). tauto.
  exact (rem_232).
Qed.

Remark rem_823 : forall X1 X2:term, auto___def_3 sym -> auto___def_7 X2 -> auto___def_30 X1 -> auto___def_14 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_3 sym -> auto___def_30 X1 -> auto___def_7 X2 -> auto___def_14 X1 X2). tauto. exact (rem_822 X1 X2).
Qed.

Remark rem_824 : forall X1 X2:term, auto___def_30 X1 -> auto___type_6 (key sym X2) -> auto___def_14 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_180 sym X2 H);  intros.
  apply (rem_819 X1 X2);  tauto.
  apply (rem_821 X1 X2);  tauto.
  apply (rem_823 X1 X2);  tauto.
Qed.

Remark rem_825 : forall X1 X2:term, auto_knows_old (crypt X1 (key sym X2)) -> auto___def_14 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_182 X1 (key sym X2) H);  intros.
  apply (rem_803 X1 X2);  tauto.
  apply (rem_810 X1 X2);  tauto.
  apply (rem_813 X1 X2);  tauto.
  apply (rem_817 X1 X2);  tauto.
  apply (rem_824 X1 X2);  tauto.
Qed.

Remark rem_826 : forall X1:term, auto___type_8 X1 -> auto___type_8 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_827 : forall X1 X2:term, auto___def_34 X2 -> auto___type_8 X1 -> auto___type_8 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_8 X1 -> auto___type_8 X1). tauto. exact (rem_826 X1).
Qed.

Remark rem_828 : forall X2:term, auto___def_34 X2 -> auto___def_34 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_829 : forall X1 X2:term, auto___def_34 X2 -> auto___type_8 X1 -> auto___def_34 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_34 X2 -> auto___def_34 X2). tauto. exact (rem_828 X2).
Qed.

Remark rem_830 : forall X1 X2:term, auto___def_34 X2 -> auto___type_8 X1 -> (auto___type_8 X1 /\ auto___def_34 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_8 X1). 2:apply (rem_827 X1 X2);  assumption.
  cut (auto___def_34 X2). 2:apply (rem_829 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_831 : forall X1 X2:term, auto___def_34 X2 -> auto___type_8 X1 -> auto___def_33 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_830 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_33_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_832 : forall X1 X2 X3 X4:term, auto___def_36 X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3. intro H. intros.
  elim (rem_499 X1 X3 X4 H);  intros.
Qed.

Remark rem_833 : forall X1 X2 X3 X4:term, auto___def_23 pub -> auto___def_36 X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_36 X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4). tauto.
  exact (rem_832 X1 X2 X3 X4).
Qed.

Remark rem_834 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_499 X1 X3 X4 H);  intros.
Qed.

Remark rem_835 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4). tauto.
  exact (rem_834 X1 X2 X3 X4).
Qed.

Remark rem_836 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto___type_9 X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2 X3 X4. intros. apply (rem_835 X1 X2 X3 X4);  assumption.
Qed.

Remark rem_837 : forall X1 X2 X3 X4:term, auto___def_38 X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3. intro H. intros.
  elim (rem_499 X1 X3 X4 H);  intros.
Qed.

Remark rem_838 : forall X1 X2 X3 X4:term, auto___def_37 pub -> auto___def_38 X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_38 X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4). tauto.
  exact (rem_837 X1 X2 X3 X4).
Qed.

Remark rem_839 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (key pub X1) -> auto_knows_current (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_258 pub X1 H);  intros.
  apply (rem_833 X1 X2 X3 X4);  tauto.
  apply (rem_836 X1 X2 X3 X4);  tauto.
  apply (rem_838 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_840 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (key pub X1) -> auto_knows_current nil -> auto_knows_current (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (key pub X1) -> auto_knows_current (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4). tauto.
  exact (rem_839 X1 X2 X3 X4).
Qed.

Remark rem_841 : forall X1 X2 X3 X4:term, auto_knows_current X3 -> auto_knows_current nil -> auto_knows_current X2 -> auto_knows_current (key pub X1) -> auto_knows_current (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (key pub X1) -> auto_knows_current nil -> auto_knows_current (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4). tauto. exact (rem_840 X1 X2 X3 X4).
Qed.

Remark rem_842 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current (cons X3 nil) -> auto_knows_current (key pub X1) -> auto_knows_current (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_462 X3 nil H);  intros.
  apply (rem_841 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_843 : forall X1 X2 X3 X4:term, auto_knows_current (cons X2 (cons X3 nil)) -> auto_knows_current (key pub X1) -> auto_knows_current (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_462 X2 (cons X3 nil) H);  intros.
  apply (rem_842 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_844 : forall X1 X2 X3 X4:term, auto_knows_current (noncea_current X1 X3 X4) -> auto_knows_current (cons X2 (cons X3 nil)) -> auto_knows_current (key pub X1) -> auto___def_60 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current (cons X2 (cons X3 nil)) -> auto_knows_current (key pub X1) -> auto_knows_current (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4). tauto. exact (rem_843 X1 X2 X3 X4).
Qed.

Remark rem_845 : forall X1 X2 X3 X4:term, auto_knows_current (cons (noncea_current X1 X3 X4) (cons X2 (cons X3 nil))) -> auto_knows_current (key pub X1) -> auto___def_60 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_462 (noncea_current X1 X3 X4) (cons X2 (cons X3 nil)) H);  intros.
  apply (rem_844 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_846 : forall X1 X2:term, auto___def_17 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_847 : forall X1 X2 X3 X4:term, auto___def_17 (cons X3 nil) -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_12 (key pub X1) -> auto_agent X2 -> auto_agent X1 -> auto___def_60 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_846 X3 nil H);  intros.
Qed.

Remark rem_848 : forall X1 X2 X3 X4:term, auto_agent X2 -> auto___def_17 (cons X3 nil) -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_12 (key pub X1) -> auto_agent X1 -> auto___def_60 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_17 (cons X3 nil) -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_12 (key pub X1) -> auto_agent X2 -> auto_agent X1 -> auto___def_60 X1 X2 X3 X4). tauto. exact (rem_847 X1 X2 X3 X4).
Qed.

Remark rem_849 : forall X1 X2 X3 X4:term, auto___def_53 (cons X2 (cons X3 nil)) -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_12 (key pub X1) -> auto_agent X1 -> auto___def_60 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_626 X2 (cons X3 nil) H);  intros.
  apply (rem_848 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_850 : forall X1 X2 X3 X4:term, auto_agent X1 -> auto___type_11 X3 -> auto___type_10 X4 -> auto___def_53 (cons X2 (cons X3 nil)) -> auto___type_12 (key pub X1) -> auto___def_60 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_53 (cons X2 (cons X3 nil)) -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_12 (key pub X1) -> auto_agent X1 -> auto___def_60 X1 X2 X3 X4). tauto. exact (rem_849 X1 X2 X3 X4).
Qed.

Remark rem_851 : forall X1 X2 X3:term, auto___def_52 (noncea_current X1 X2 X3) -> or_1
    (auto_agent X1 /\ auto___type_11 X2 /\ auto___type_10 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_852 : forall X1 X2 X3 X4:term, auto___def_52 (noncea_current X1 X3 X4) -> auto___def_53 (cons X2 (cons X3 nil)) -> auto___type_12 (key pub X1) -> auto___def_60 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_851 X1 X3 X4 H);  intros.
  apply (rem_850 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_853 : forall X1 X2 X3 X4:term, auto___def_51 (cons (noncea_current X1 X3 X4) (cons X2 (cons X3 nil))) -> auto___type_12 (key pub X1) -> auto___def_60 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_628 (noncea_current X1 X3 X4) (cons X2 (cons X3 nil)) H);  intros.
  apply (rem_852 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_854 : forall X1 X2 X3 X4:term, auto___def_57 (cons (noncea_current X1 X3 X4) (cons X2 (cons X3 nil))) -> auto___type_2 (key pub X1) -> auto___def_60 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_430 (noncea_current X1 X3 X4) (cons X2 (cons X3 nil)) H);  intros.
Qed.

Remark rem_855 : forall X1 X2:term, auto___def_49 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_856 : forall X1 X2 X3 X4:term, auto___def_49 (cons X3 nil) -> auto___def_7 X1 -> auto___type_10 (noncea_current X1 X3 X4) -> auto___type_11 X2 -> auto___def_60 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_855 X3 nil H);  intros.
Qed.

Remark rem_857 : forall X1 X2 X3 X4:term, auto___type_11 X2 -> auto___def_49 (cons X3 nil) -> auto___def_7 X1 -> auto___type_10 (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_49 (cons X3 nil) -> auto___def_7 X1 -> auto___type_10 (noncea_current X1 X3 X4) -> auto___type_11 X2 -> auto___def_60 X1 X2 X3 X4). tauto. exact (rem_856 X1 X2 X3 X4).
Qed.

Remark rem_858 : forall X1 X2 X3 X4:term, auto___def_48 (cons X2 (cons X3 nil)) -> auto___def_7 X1 -> auto___type_10 (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_443 X2 (cons X3 nil) H);  intros.
  apply (rem_857 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_859 : forall X1 X2 X3 X4:term, auto___def_23 pub -> auto___def_48 (cons X2 (cons X3 nil)) -> auto___def_7 X1 -> auto___type_10 (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_48 (cons X2 (cons X3 nil)) -> auto___def_7 X1 -> auto___type_10 (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4). tauto.
  exact (rem_858 X1 X2 X3 X4).
Qed.

Remark rem_860 : forall X1 X2 X3 X4:term, auto___def_23 pub -> auto___def_7 X1 -> auto___def_48 (cons X2 (cons X3 nil)) -> auto___type_10 (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_23 pub -> auto___def_48 (cons X2 (cons X3 nil)) -> auto___def_7 X1 -> auto___type_10 (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4). tauto. exact (rem_859 X1 X2 X3 X4).
Qed.

Remark rem_861 : forall X1 X2 X3 X4:term, auto___def_47 (key pub X1) -> auto___def_48 (cons X2 (cons X3 nil)) -> auto___type_10 (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_685 pub X1 H);  intros.
  apply (rem_860 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_862 : forall X1 X2 X3 X4:term, auto___type_10 (noncea_current X1 X3 X4) -> auto___def_48 (cons X2 (cons X3 nil)) -> auto___def_47 (key pub X1) -> auto___def_60 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_47 (key pub X1) -> auto___def_48 (cons X2 (cons X3 nil)) -> auto___type_10 (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4). tauto. exact (rem_861 X1 X2 X3 X4).
Qed.

Remark rem_863 : forall X1 X2 X3 X4:term, auto___def_46 (cons (noncea_current X1 X3 X4) (cons X2 (cons X3 nil))) -> auto___def_47 (key pub X1) -> auto___def_60 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_446 (noncea_current X1 X3 X4) (cons X2 (cons X3 nil)) H);  intros.
  apply (rem_862 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_864 : forall X1:term, auto___def_2 X1 -> auto_agent X1. (* Induct. *)
Proof.
  fix epsilon_m__def_2_pagent 1.
  intro X. case X.
  exact (rem_319 epsilon_m__def_2_pagent ).
   intro H. elim (rem_20  H).
  intros X1 X2. intro H. elim (rem_17 X1 X2 H).
  intros X1 X2. intro H. elim (rem_18 X1 X2 H).
   intro H. elim (rem_13  H).
   intro H. elim (rem_25  H).
  intros X1 X2. intro H. elim (rem_19 X1 X2 H).
   intro H. elim (rem_12  H).
  intros X1 X2 X3. intro H. elim (rem_16 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_21 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_24 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_22 X1 X2 X3 X4 H).
   intro H. elim (rem_27  H).
   intro H. elim (rem_23  H).
  intros X1. intro H. elim (rem_11 X1 H).
   intro H. elim (rem_26  H).
  intros X1 X2 X3. intro H. elim (rem_14 X1 X2 X3 H).
   intro H. elim (rem_15  H).
Qed.

Remark rem_865 : forall X1 X2 X3 X4:term, auto___def_2 X1 -> auto___def_57 X2 -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_15 X3 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X1 -> auto_agent X1). tauto. exact (rem_864 X1).
Qed.

Remark rem_866 : forall X1:term, auto___def_2 X1 -> auto___def_2 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_867 : forall X1 X2 X3 X4:term, auto___def_2 X1 -> auto___def_57 X2 -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_15 X3 -> auto_agent X1 -> auto___def_2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X1 -> auto___def_2 X1). tauto. exact (rem_866 X1).
Qed.

Remark rem_868 : forall X2:term, auto___def_57 X2 -> auto___def_57 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_869 : forall X1 X2 X3 X4:term, auto___def_2 X1 -> auto___def_57 X2 -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_15 X3 -> auto_agent X1 -> auto___def_57 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_57 X2 -> auto___def_57 X2). tauto. exact (rem_868 X2).
Qed.

Remark rem_870 : forall X3:term, auto___type_11 X3 -> auto___type_3 X3. (* Induct. *)
Proof.
  fix epsilon_m__type_11_p__type_3 1.
  intro X. case X.
  exact (rem_287 epsilon_m__type_11_p__type_3 ).
  exact (rem_284 epsilon_m__type_11_p__type_3 ).
  intros X1 X2. intro H. elim (rem_297 X1 X2 H).
  intros X1 X2. intro H. elim (rem_298 X1 X2 H).
   intro H. elim (rem_293  H).
   intro H. elim (rem_304  H).
  intros X1 X2. intro H. elim (rem_299 X1 X2 H).
   intro H. elim (rem_292  H).
  intros X1 X2 X3. intro H. elim (rem_296 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_300 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_303 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_301 X1 X2 X3 X4 H).
   intro H. elim (rem_305  H).
   intro H. elim (rem_302  H).
  intros X1. intro H. elim (rem_291 X1 H).
  exact (rem_290 epsilon_m__type_11_p__type_3 ).
  intros X1 X2 X3. intro H. elim (rem_294 X1 X2 X3 H).
   intro H. elim (rem_295  H).
Qed.

Remark rem_871 : forall X1 X2 X3 X4:term, auto___def_2 X1 -> auto___def_57 X2 -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_15 X3 -> auto_agent X1 -> auto___type_3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_11 X3 -> auto___type_3 X3). tauto. exact (rem_870 X3).
Qed.

Remark rem_872 : (forall X:term, auto___type_11 X -> auto___type_15 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_11_p__type_15.  tauto.
Defined.

Remark rem_873 : (forall X:term, auto___type_11 X -> auto___type_15 X)
    -> auto___type_15 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_11_p__type_15.  case (rem_872 epsilon_m__type_11_p__type_15). clear  epsilon_m__type_11_p__type_15. intros. apply trans___type_15_bob_1;  tauto.
 clear  epsilon_m__type_11_p__type_15. tauto.
Defined.

Remark rem_874 : (forall X:term, auto___type_11 X -> auto___type_15 X)
    -> auto___type_11 bob -> auto___type_15 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_11_p__type_15. intro H. intros.
  elim (rem_283 H);  intros.
  apply (rem_873 epsilon_m__type_11_p__type_15);  tauto.
Defined.

Remark rem_875 : (forall X:term, auto___type_11 X -> auto___type_15 X)
    -> auto___type_15 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_11_p__type_15.  case (rem_872 epsilon_m__type_11_p__type_15). clear  epsilon_m__type_11_p__type_15. intros. apply trans___type_15_alice_1;  tauto.
 clear  epsilon_m__type_11_p__type_15. tauto.
Defined.

Remark rem_876 : (forall X:term, auto___type_11 X -> auto___type_15 X)
    -> auto___type_11 alice -> auto___type_15 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_11_p__type_15. intro H. intros.
  elim (rem_286 H);  intros.
  apply (rem_875 epsilon_m__type_11_p__type_15);  tauto.
Defined.

Remark rem_877 : (forall X:term, auto___type_11 X -> auto___type_15 X)
    -> auto___type_15 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_11_p__type_15.  case (rem_872 epsilon_m__type_11_p__type_15). clear  epsilon_m__type_11_p__type_15. intros. apply trans___type_15_server_1;  tauto.
 clear  epsilon_m__type_11_p__type_15. tauto.
Defined.

Remark rem_878 : (forall X:term, auto___type_11 X -> auto___type_15 X)
    -> auto___type_11 server -> auto___type_15 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_11_p__type_15. intro H. intros.
  elim (rem_289 H);  intros.
  apply (rem_877 epsilon_m__type_11_p__type_15);  tauto.
Defined.

Remark rem_879 : forall X3:term, auto___type_11 X3 -> auto___type_15 X3. (* Induct. *)
Proof.
  fix epsilon_m__type_11_p__type_15 1.
  intro X. case X.
  exact (rem_876 epsilon_m__type_11_p__type_15 ).
  exact (rem_874 epsilon_m__type_11_p__type_15 ).
  intros X1 X2. intro H. elim (rem_297 X1 X2 H).
  intros X1 X2. intro H. elim (rem_298 X1 X2 H).
   intro H. elim (rem_293  H).
   intro H. elim (rem_304  H).
  intros X1 X2. intro H. elim (rem_299 X1 X2 H).
   intro H. elim (rem_292  H).
  intros X1 X2 X3. intro H. elim (rem_296 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_300 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_303 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_301 X1 X2 X3 X4 H).
   intro H. elim (rem_305  H).
   intro H. elim (rem_302  H).
  intros X1. intro H. elim (rem_291 X1 H).
  exact (rem_878 epsilon_m__type_11_p__type_15 ).
  intros X1 X2 X3. intro H. elim (rem_294 X1 X2 X3 H).
   intro H. elim (rem_295  H).
Qed.

Remark rem_880 : forall X1 X2 X3 X4:term, auto___def_2 X1 -> auto___def_57 X2 -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_15 X3 -> auto_agent X1 -> auto___type_15 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_11 X3 -> auto___type_15 X3). tauto. exact (rem_879 X3).
Qed.

Remark rem_881 : forall X1 X2 X3 X4:term, auto___def_2 X1 -> auto___def_57 X2 -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_15 X3 -> auto_agent X1 -> auto___type_2 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_10 X4 -> auto___type_2 X4). tauto. exact (rem_438 X4).
Qed.

Remark rem_882 : forall X1 X2 X3 X4:term, auto___def_2 X1 -> auto___def_57 X2 -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_15 X3 -> auto_agent X1 -> (auto_agent X1 /\ auto___def_2 X1 /\ auto___def_57 X2 /\ auto___type_3 X3 /\ auto___type_15 X3 /\ auto___type_2 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  cut (auto_agent X1). 2:apply (rem_865 X1 X2 X3 X4);  assumption.
  cut (auto___def_2 X1). 2:apply (rem_867 X1 X2 X3 X4);  assumption.
  cut (auto___def_57 X2). 2:apply (rem_869 X1 X2 X3 X4);  assumption.
  cut (auto___type_3 X3). 2:apply (rem_871 X1 X2 X3 X4);  assumption.
  cut (auto___type_15 X3). 2:apply (rem_880 X1 X2 X3 X4);  assumption.
  cut (auto___type_2 X4). 2:apply (rem_881 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_883 : forall X1 X2 X3 X4:term, auto___def_2 X1 -> auto___def_57 X2 -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_15 X3 -> auto_agent X1 -> auto___def_60 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  case (rem_882 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6). clear  A1 A2 A3 A4 A5 A6. intros. apply trans___def_60_2;  tauto.
 clear  A1 A2 A3 A4 A5 A6. tauto.
Qed.

Remark rem_884 : forall X1 X2 X3 X4:term, auto_agent X1 -> auto___type_11 X3 -> auto___type_10 X4 -> auto___def_2 X1 -> auto___def_57 X2 -> auto___type_15 X3 -> auto___def_60 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X1 -> auto___def_57 X2 -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_15 X3 -> auto_agent X1 -> auto___def_60 X1 X2 X3 X4). tauto. exact (rem_883 X1 X2 X3 X4).
Qed.

Remark rem_885 : forall X1 X2 X3:term, auto___type_14 (noncea_current X1 X2 X3) -> or_1
    (auto_agent X1 /\ auto___type_11 X2 /\ auto___type_10 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_886 : forall X1 X2 X3 X4:term, auto___def_2 X1 -> auto___def_57 X2 -> auto___type_14 (noncea_current X1 X3 X4) -> auto___type_15 X3 -> auto___def_60 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_885 X1 X3 X4 H);  intros.
  apply (rem_884 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_887 : forall X1 X2 X3 X4:term, auto___def_2 X1 -> auto___def_3 pub -> auto___def_57 X2 -> auto___type_14 (noncea_current X1 X3 X4) -> auto___type_15 X3 -> auto___def_60 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X1 -> auto___def_57 X2 -> auto___type_14 (noncea_current X1 X3 X4) -> auto___type_15 X3 -> auto___def_60 X1 X2 X3 X4). tauto.
  exact (rem_886 X1 X2 X3 X4).
Qed.

Remark rem_888 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto___def_2 X1 -> auto___def_57 X2 -> auto___type_14 (noncea_current X1 X3 X4) -> auto___type_15 X3 -> auto___def_60 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X1 -> auto___def_3 pub -> auto___def_57 X2 -> auto___type_14 (noncea_current X1 X3 X4) -> auto___type_15 X3 -> auto___def_60 X1 X2 X3 X4). tauto. exact (rem_887 X1 X2 X3 X4).
Qed.

Remark rem_889 : forall X1:term, auto___def_5 X1 -> auto___def_5 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_890 : forall X1 X2 X3 X4:term, auto___def_5 X1 -> auto___def_57 X2 -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_15 X3 -> auto_agent X1 -> auto___def_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_5 X1 -> auto___def_5 X1). tauto. exact (rem_889 X1).
Qed.

Remark rem_891 : forall X1:term, auto___def_5 X1 -> auto_agent X1. (* Induct. *)
Proof.
  fix epsilon_m__def_5_pagent 1.
  intro X. case X.
   intro H. elim (rem_69  H).
  exact (rem_412 epsilon_m__def_5_pagent ).
  intros X1 X2. intro H. elim (rem_65 X1 X2 H).
  intros X1 X2. intro H. elim (rem_66 X1 X2 H).
   intro H. elim (rem_61  H).
   intro H. elim (rem_73  H).
  intros X1 X2. intro H. elim (rem_67 X1 X2 H).
   intro H. elim (rem_60  H).
  intros X1 X2 X3. intro H. elim (rem_64 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_68 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_72 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_70 X1 X2 X3 X4 H).
   intro H. elim (rem_75  H).
   intro H. elim (rem_71  H).
  intros X1. intro H. elim (rem_59 X1 H).
   intro H. elim (rem_74  H).
  intros X1 X2 X3. intro H. elim (rem_62 X1 X2 X3 H).
   intro H. elim (rem_63  H).
Qed.

Remark rem_892 : forall X1 X2 X3 X4:term, auto___def_5 X1 -> auto___def_57 X2 -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_15 X3 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_5 X1 -> auto_agent X1). tauto. exact (rem_891 X1).
Qed.

Remark rem_893 : forall X1 X2 X3 X4:term, auto___def_5 X1 -> auto___def_57 X2 -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_15 X3 -> auto_agent X1 -> auto___def_57 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_57 X2 -> auto___def_57 X2). tauto. exact (rem_868 X2).
Qed.

Remark rem_894 : forall X3:term, auto___type_11 X3 -> auto___type_11 X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_895 : forall X1 X2 X3 X4:term, auto___def_5 X1 -> auto___def_57 X2 -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_15 X3 -> auto_agent X1 -> auto___type_11 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_11 X3 -> auto___type_11 X3). tauto. exact (rem_894 X3).
Qed.

Remark rem_896 : forall X1 X2 X3 X4:term, auto___def_5 X1 -> auto___def_57 X2 -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_15 X3 -> auto_agent X1 -> auto___type_15 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_11 X3 -> auto___type_15 X3). tauto. exact (rem_879 X3).
Qed.

Remark rem_897 : forall X1 X2 X3 X4:term, auto___def_5 X1 -> auto___def_57 X2 -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_15 X3 -> auto_agent X1 -> auto___type_10 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_10 X4 -> auto___type_10 X4). tauto. exact (rem_531 X4).
Qed.

Remark rem_898 : forall X1 X2 X3 X4:term, auto___def_5 X1 -> auto___def_57 X2 -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_15 X3 -> auto_agent X1 -> (auto___def_5 X1 /\ auto_agent X1 /\ auto___def_57 X2 /\ auto___type_11 X3 /\ auto___type_15 X3 /\ auto___type_10 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  cut (auto___def_5 X1). 2:apply (rem_890 X1 X2 X3 X4);  assumption.
  cut (auto_agent X1). 2:apply (rem_892 X1 X2 X3 X4);  assumption.
  cut (auto___def_57 X2). 2:apply (rem_893 X1 X2 X3 X4);  assumption.
  cut (auto___type_11 X3). 2:apply (rem_895 X1 X2 X3 X4);  assumption.
  cut (auto___type_15 X3). 2:apply (rem_896 X1 X2 X3 X4);  assumption.
  cut (auto___type_10 X4). 2:apply (rem_897 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_899 : forall X1 X2 X3 X4:term, auto___def_5 X1 -> auto___def_57 X2 -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_15 X3 -> auto_agent X1 -> auto___def_60 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  case (rem_898 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6). clear  A1 A2 A3 A4 A5 A6. intros. apply trans___def_60_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6. tauto.
Qed.

Remark rem_900 : forall X1 X2 X3 X4:term, auto_agent X1 -> auto___type_11 X3 -> auto___type_10 X4 -> auto___def_5 X1 -> auto___def_57 X2 -> auto___type_15 X3 -> auto___def_60 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_5 X1 -> auto___def_57 X2 -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_15 X3 -> auto_agent X1 -> auto___def_60 X1 X2 X3 X4). tauto. exact (rem_899 X1 X2 X3 X4).
Qed.

Remark rem_901 : forall X1 X2 X3 X4:term, auto___def_5 X1 -> auto___def_57 X2 -> auto___type_14 (noncea_current X1 X3 X4) -> auto___type_15 X3 -> auto___def_60 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_885 X1 X3 X4 H);  intros.
  apply (rem_900 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_902 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto___def_5 X1 -> auto___def_57 X2 -> auto___type_14 (noncea_current X1 X3 X4) -> auto___type_15 X3 -> auto___def_60 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_5 X1 -> auto___def_57 X2 -> auto___type_14 (noncea_current X1 X3 X4) -> auto___type_15 X3 -> auto___def_60 X1 X2 X3 X4). tauto.
  exact (rem_901 X1 X2 X3 X4).
Qed.

Remark rem_903 : forall X1 X2 X3 X4:term, auto___def_57 X2 -> auto___def_7 X1 -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_15 X3 -> auto_agent X1 -> auto___def_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_7 X1 -> auto___def_7 X1). tauto. exact (rem_155 X1).
Qed.

Remark rem_904 : forall X1:term, auto___def_7 X1 -> auto_agent X1. (* Induct. *)
Proof.
  fix epsilon_m__def_7_pagent 1.
  intro X. case X.
   intro H. elim (rem_94  H).
   intro H. elim (rem_92  H).
  intros X1 X2. intro H. elim (rem_89 X1 X2 H).
  intros X1 X2. intro H. elim (rem_90 X1 X2 H).
   intro H. elim (rem_85  H).
   intro H. elim (rem_98  H).
  intros X1 X2. intro H. elim (rem_91 X1 X2 H).
   intro H. elim (rem_84  H).
  intros X1 X2 X3. intro H. elim (rem_88 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_93 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_97 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_95 X1 X2 X3 X4 H).
   intro H. elim (rem_99  H).
   intro H. elim (rem_96  H).
  intros X1. intro H. elim (rem_83 X1 H).
  exact (rem_398 epsilon_m__def_7_pagent ).
  intros X1 X2 X3. intro H. elim (rem_86 X1 X2 X3 H).
   intro H. elim (rem_87  H).
Qed.

Remark rem_905 : forall X1 X2 X3 X4:term, auto___def_57 X2 -> auto___def_7 X1 -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_15 X3 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_7 X1 -> auto_agent X1). tauto. exact (rem_904 X1).
Qed.

Remark rem_906 : forall X1 X2 X3 X4:term, auto___def_57 X2 -> auto___def_7 X1 -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_15 X3 -> auto_agent X1 -> auto___def_57 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_57 X2 -> auto___def_57 X2). tauto. exact (rem_868 X2).
Qed.

Remark rem_907 : forall X1 X2 X3 X4:term, auto___def_57 X2 -> auto___def_7 X1 -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_15 X3 -> auto_agent X1 -> auto___type_11 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_11 X3 -> auto___type_11 X3). tauto. exact (rem_894 X3).
Qed.

Remark rem_908 : forall X1 X2 X3 X4:term, auto___def_57 X2 -> auto___def_7 X1 -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_15 X3 -> auto_agent X1 -> auto___type_15 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_11 X3 -> auto___type_15 X3). tauto. exact (rem_879 X3).
Qed.

Remark rem_909 : forall X1 X2 X3 X4:term, auto___def_57 X2 -> auto___def_7 X1 -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_15 X3 -> auto_agent X1 -> auto___type_10 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_10 X4 -> auto___type_10 X4). tauto. exact (rem_531 X4).
Qed.

Remark rem_910 : forall X1 X2 X3 X4:term, auto___def_57 X2 -> auto___def_7 X1 -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_15 X3 -> auto_agent X1 -> (auto___def_7 X1 /\ auto_agent X1 /\ auto___def_57 X2 /\ auto___type_11 X3 /\ auto___type_15 X3 /\ auto___type_10 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  cut (auto___def_7 X1). 2:apply (rem_903 X1 X2 X3 X4);  assumption.
  cut (auto_agent X1). 2:apply (rem_905 X1 X2 X3 X4);  assumption.
  cut (auto___def_57 X2). 2:apply (rem_906 X1 X2 X3 X4);  assumption.
  cut (auto___type_11 X3). 2:apply (rem_907 X1 X2 X3 X4);  assumption.
  cut (auto___type_15 X3). 2:apply (rem_908 X1 X2 X3 X4);  assumption.
  cut (auto___type_10 X4). 2:apply (rem_909 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_911 : forall X1 X2 X3 X4:term, auto___def_57 X2 -> auto___def_7 X1 -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_15 X3 -> auto_agent X1 -> auto___def_60 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  case (rem_910 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6). clear  A1 A2 A3 A4 A5 A6. intros. apply trans___def_60_3;  tauto.
 clear  A1 A2 A3 A4 A5 A6. tauto.
Qed.

Remark rem_912 : forall X1 X2 X3 X4:term, auto_agent X1 -> auto___type_11 X3 -> auto___type_10 X4 -> auto___def_57 X2 -> auto___def_7 X1 -> auto___type_15 X3 -> auto___def_60 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 X2 -> auto___def_7 X1 -> auto___type_10 X4 -> auto___type_11 X3 -> auto___type_15 X3 -> auto_agent X1 -> auto___def_60 X1 X2 X3 X4). tauto. exact (rem_911 X1 X2 X3 X4).
Qed.

Remark rem_913 : forall X1 X2 X3 X4:term, auto___def_57 X2 -> auto___def_7 X1 -> auto___type_14 (noncea_current X1 X3 X4) -> auto___type_15 X3 -> auto___def_60 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_885 X1 X3 X4 H);  intros.
  apply (rem_912 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_914 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto___def_57 X2 -> auto___def_7 X1 -> auto___type_14 (noncea_current X1 X3 X4) -> auto___type_15 X3 -> auto___def_60 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_57 X2 -> auto___def_7 X1 -> auto___type_14 (noncea_current X1 X3 X4) -> auto___type_15 X3 -> auto___def_60 X1 X2 X3 X4). tauto.
  exact (rem_913 X1 X2 X3 X4).
Qed.

Remark rem_915 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto___def_7 X1 -> auto___def_57 X2 -> auto___type_14 (noncea_current X1 X3 X4) -> auto___type_15 X3 -> auto___def_60 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_3 pub -> auto___def_57 X2 -> auto___def_7 X1 -> auto___type_14 (noncea_current X1 X3 X4) -> auto___type_15 X3 -> auto___def_60 X1 X2 X3 X4). tauto. exact (rem_914 X1 X2 X3 X4).
Qed.

Remark rem_916 : forall X1 X2 X3 X4:term, auto___def_57 X2 -> auto___type_13 (key pub X1) -> auto___type_14 (noncea_current X1 X3 X4) -> auto___type_15 X3 -> auto___def_60 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_789 pub X1 H);  intros.
  apply (rem_888 X1 X2 X3 X4);  tauto.
  apply (rem_902 X1 X2 X3 X4);  tauto.
  apply (rem_915 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_917 : forall X1 X2 X3 X4:term, auto___def_57 X2 -> auto___def_59 nil -> auto___type_13 (key pub X1) -> auto___type_14 (noncea_current X1 X3 X4) -> auto___type_15 X3 -> auto___def_60 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_57 X2 -> auto___type_13 (key pub X1) -> auto___type_14 (noncea_current X1 X3 X4) -> auto___type_15 X3 -> auto___def_60 X1 X2 X3 X4). tauto.
  exact (rem_916 X1 X2 X3 X4).
Qed.

Remark rem_918 : forall X1 X2 X3 X4:term, auto___type_15 X3 -> auto___def_59 nil -> auto___def_57 X2 -> auto___type_13 (key pub X1) -> auto___type_14 (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_57 X2 -> auto___def_59 nil -> auto___type_13 (key pub X1) -> auto___type_14 (noncea_current X1 X3 X4) -> auto___type_15 X3 -> auto___def_60 X1 X2 X3 X4). tauto. exact (rem_917 X1 X2 X3 X4).
Qed.

Remark rem_919 : forall X1 X2:term, auto___def_58 (cons X1 X2) -> or_1
    (auto___type_15 X1 /\ auto___def_59 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_920 : forall X1 X2 X3 X4:term, auto___def_57 X2 -> auto___def_58 (cons X3 nil) -> auto___type_13 (key pub X1) -> auto___type_14 (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_919 X3 nil H);  intros.
  apply (rem_918 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_921 : forall X1 X2 X3 X4:term, auto___def_56 (cons X2 (cons X3 nil)) -> auto___type_13 (key pub X1) -> auto___type_14 (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_505 X2 (cons X3 nil) H);  intros.
  apply (rem_920 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_922 : forall X1 X2 X3 X4:term, auto___type_14 (noncea_current X1 X3 X4) -> auto___def_56 (cons X2 (cons X3 nil)) -> auto___type_13 (key pub X1) -> auto___def_60 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_56 (cons X2 (cons X3 nil)) -> auto___type_13 (key pub X1) -> auto___type_14 (noncea_current X1 X3 X4) -> auto___def_60 X1 X2 X3 X4). tauto. exact (rem_921 X1 X2 X3 X4).
Qed.

Remark rem_923 : forall X1 X2 X3 X4:term, auto___def_55 (cons (noncea_current X1 X3 X4) (cons X2 (cons X3 nil))) -> auto___type_13 (key pub X1) -> auto___def_60 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_508 (noncea_current X1 X3 X4) (cons X2 (cons X3 nil)) H);  intros.
  apply (rem_922 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_924 : forall X1 X2 X3 X4:term, auto_knows_current (crypt (cons (noncea_current X1 X3 X4) (cons X2 (cons X3 nil))) (key pub X1)) -> auto___def_60 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_470 (cons (noncea_current X1 X3 X4) (cons X2 (cons X3 nil))) (key pub X1) H);  intros.
  apply (rem_845 X1 X2 X3 X4);  tauto.
  apply (rem_853 X1 X2 X3 X4);  tauto.
  apply (rem_854 X1 X2 X3 X4);  tauto.
  apply (rem_863 X1 X2 X3 X4);  tauto.
  apply (rem_923 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_925 : forall X1:term, auto___def_26 X1 -> auto___def_26 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_926 : forall X1 X2:term, auto___def_26 X1 -> auto___def_27 X2 -> auto___def_26 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_26 X1 -> auto___def_26 X1). tauto. exact (rem_925 X1).
Qed.

Remark rem_927 : forall X2:term, auto___def_27 X2 -> auto___def_27 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_928 : forall X1 X2:term, auto___def_26 X1 -> auto___def_27 X2 -> auto___def_27 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_27 X2 -> auto___def_27 X2). tauto. exact (rem_927 X2).
Qed.

Remark rem_929 : forall X1 X2:term, auto___def_26 X1 -> auto___def_27 X2 -> (auto___def_26 X1 /\ auto___def_27 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_26 X1). 2:apply (rem_926 X1 X2);  assumption.
  cut (auto___def_27 X2). 2:apply (rem_928 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_930 : forall X1 X2:term, auto___def_26 X1 -> auto___def_27 X2 -> auto___def_25 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_929 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_25_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_931 : forall X1 X2:term, auto___def_27 X2 -> auto___def_26 X1 -> auto___def_25 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_26 X1 -> auto___def_27 X2 -> auto___def_25 (cons X1 X2)). tauto. exact (rem_930 X1 X2).
Qed.

Remark rem_932 : forall X1:term, auto___def_3 X1 -> auto___def_3 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_933 : forall X1 X2:term, auto___def_2 X2 -> auto___def_3 X1 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_932 X1).
Qed.

Remark rem_934 : forall X1 X2:term, auto___def_2 X2 -> auto___def_3 X1 -> auto___def_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_2 X2 -> auto___def_2 X2). tauto. exact (rem_322 X2).
Qed.

Remark rem_935 : forall X1 X2:term, auto___def_2 X2 -> auto___def_3 X1 -> (auto___def_3 X1 /\ auto___def_2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_933 X1 X2);  assumption.
  cut (auto___def_2 X2). 2:apply (rem_934 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_936 : forall X1 X2:term, auto___def_2 X2 -> auto___def_3 X1 -> auto___def_1 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_935 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_1_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_937 : auto___def_9 intruder. (* Deduce positive atom. *)
Proof.
   case rem_135. intros. apply trans___def_9_intruder_1;  tauto.
 tauto.
Qed.

Remark rem_938 : forall X1:term, auto___type_2 X1 -> auto___type_2 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_939 : forall X1 X2:term, auto___def_21 X2 -> auto___type_2 X1 -> auto___type_2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_2 X1 -> auto___type_2 X1). tauto. exact (rem_938 X1).
Qed.

Remark rem_940 : forall X2:term, auto___def_21 X2 -> auto___def_21 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_941 : forall X1 X2:term, auto___def_21 X2 -> auto___type_2 X1 -> auto___def_21 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_21 X2 -> auto___def_21 X2). tauto. exact (rem_940 X2).
Qed.

Remark rem_942 : forall X1 X2:term, auto___def_21 X2 -> auto___type_2 X1 -> (auto___type_2 X1 /\ auto___def_21 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_2 X1). 2:apply (rem_939 X1 X2);  assumption.
  cut (auto___def_21 X2). 2:apply (rem_941 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_943 : forall X1 X2:term, auto___def_21 X2 -> auto___type_2 X1 -> auto___def_19 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_942 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_19_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_944 : auto___def_49 nil. (* Deduce positive atom. *)
Proof.
   case rem_135. intros. apply trans___def_49_nil_1;  tauto.
 tauto.
Qed.

Remark rem_945 : forall X1:term, auto___type_10 X1 -> auto___type_10 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_946 : forall X1 X2:term, auto___def_48 X2 -> auto___type_10 X1 -> auto___type_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_10 X1 -> auto___type_10 X1). tauto. exact (rem_945 X1).
Qed.

Remark rem_947 : forall X2:term, auto___def_48 X2 -> auto___def_48 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_948 : forall X1 X2:term, auto___def_48 X2 -> auto___type_10 X1 -> auto___def_48 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_48 X2 -> auto___def_48 X2). tauto. exact (rem_947 X2).
Qed.

Remark rem_949 : forall X1 X2:term, auto___def_48 X2 -> auto___type_10 X1 -> (auto___type_10 X1 /\ auto___def_48 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_10 X1). 2:apply (rem_946 X1 X2);  assumption.
  cut (auto___def_48 X2). 2:apply (rem_948 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_950 : forall X1 X2:term, auto___def_48 X2 -> auto___type_10 X1 -> auto___def_46 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_949 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_46_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_951 : forall X1:term, auto___type_14 X1 -> auto___type_14 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_952 : forall X1 X2:term, auto___def_56 X2 -> auto___type_14 X1 -> auto___type_14 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_14 X1 -> auto___type_14 X1). tauto. exact (rem_951 X1).
Qed.

Remark rem_953 : forall X2:term, auto___def_56 X2 -> auto___def_56 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_954 : forall X1 X2:term, auto___def_56 X2 -> auto___type_14 X1 -> auto___def_56 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_56 X2 -> auto___def_56 X2). tauto. exact (rem_953 X2).
Qed.

Remark rem_955 : forall X1 X2:term, auto___def_56 X2 -> auto___type_14 X1 -> (auto___type_14 X1 /\ auto___def_56 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_14 X1). 2:apply (rem_952 X1 X2);  assumption.
  cut (auto___def_56 X2). 2:apply (rem_954 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_956 : forall X1 X2:term, auto___def_56 X2 -> auto___type_14 X1 -> auto___def_55 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_955 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_55_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_957 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_958 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_957 epsilon_mknows_current_p__type_14 X1);  assumption.
  tauto.
Defined.

Remark rem_959 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1:term, auto_knows_current X1 -> auto___type_14 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1. intros A1.
  case (rem_958 epsilon_mknows_current_p__type_14 X1 A1). clear  epsilon_mknows_current_p__type_14 A1. intros. apply trans___type_14_s_1;  tauto.
 clear  epsilon_mknows_current_p__type_14 A1. tauto.
Defined.

Remark rem_960 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1:term, auto_knows_current (s X1) -> auto___type_14 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1. intro H. intros.
  elim (rem_451 X1 H);  intros.
  apply (rem_959 epsilon_mknows_current_p__type_14 X1);  tauto.
Defined.

Remark rem_961 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_14.  tauto.
Defined.

Remark rem_962 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> auto___type_14 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14.  case (rem_961 epsilon_mknows_current_p__type_14). clear  epsilon_mknows_current_p__type_14. intros. apply trans___type_14_nil_1;  tauto.
 clear  epsilon_mknows_current_p__type_14. tauto.
Defined.

Remark rem_963 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> auto_knows_current nil -> auto___type_14 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intro H. intros.
  elim (rem_455 H);  intros.
  apply (rem_962 epsilon_mknows_current_p__type_14);  tauto.
Defined.

Remark rem_964 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> auto___type_14 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14.  case (rem_961 epsilon_mknows_current_p__type_14). clear  epsilon_mknows_current_p__type_14. intros. apply trans___type_14_i_1;  tauto.
 clear  epsilon_mknows_current_p__type_14. tauto.
Defined.

Remark rem_965 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> auto_knows_current i -> auto___type_14 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intro H. intros.
  elim (rem_459 H);  intros.
  apply (rem_964 epsilon_mknows_current_p__type_14);  tauto.
Defined.

Remark rem_966 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_957 epsilon_mknows_current_p__type_14 X1).
Defined.

Remark rem_967 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X2:term, auto_knows_current X2 -> auto_knows_current X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_968 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_967 epsilon_mknows_current_p__type_14 X2).
Defined.

Remark rem_969 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_966 epsilon_mknows_current_p__type_14 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_968 epsilon_mknows_current_p__type_14 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_970 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_14 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2. intros A1 A2.
  case (rem_969 epsilon_mknows_current_p__type_14 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_14 A1 A2. intros. apply trans___type_14_cons_1;  tauto.
 clear  epsilon_mknows_current_p__type_14 A1 A2. tauto.
Defined.

Remark rem_971 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto_knows_current (cons X1 X2) -> auto___type_14 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2. intro H. intros.
  elim (rem_462 X1 X2 H);  intros.
  apply (rem_970 epsilon_mknows_current_p__type_14 X1 X2);  tauto.
Defined.

Remark rem_972 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_14 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2. intros A1 A2.
  case (rem_969 epsilon_mknows_current_p__type_14 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_14 A1 A2. intros. apply trans___type_14_crypt_1;  tauto.
 clear  epsilon_mknows_current_p__type_14 A1 A2. tauto.
Defined.

Remark rem_973 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1:term, auto___def_51 X1 -> auto___def_51 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_974 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto___type_12 X2 -> auto___def_51 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2.
  cut (auto___def_51 X1 -> auto___def_51 X1). tauto. exact (rem_973 epsilon_mknows_current_p__type_14 X1).
Defined.

Remark rem_975 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X2:term, auto___type_12 X2 -> auto___type_12 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_976 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto___type_12 X2 -> auto___type_12 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2.
  cut (auto___type_12 X2 -> auto___type_12 X2). tauto. exact (rem_975 epsilon_mknows_current_p__type_14 X2).
Defined.

Remark rem_977 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto___type_12 X2 -> (auto___def_51 X1 /\ auto___type_12 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2. intros A1 A2.
  cut (auto___def_51 X1). 2:apply (rem_974 epsilon_mknows_current_p__type_14 X1 X2);  assumption.
  cut (auto___type_12 X2). 2:apply (rem_976 epsilon_mknows_current_p__type_14 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_978 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto___type_12 X2 -> auto___type_14 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2. intros A1 A2.
  case (rem_977 epsilon_mknows_current_p__type_14 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_14 A1 A2. intros. apply trans___type_14_crypt_2;  tauto.
 clear  epsilon_mknows_current_p__type_14 A1 A2. tauto.
Defined.

Remark rem_979 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1:term, auto___def_57 X1 -> auto___def_57 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_980 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_57 X1 -> auto___type_2 X2 -> auto___def_57 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2.
  cut (auto___def_57 X1 -> auto___def_57 X1). tauto. exact (rem_979 epsilon_mknows_current_p__type_14 X1).
Defined.

Remark rem_981 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X2:term, auto___type_2 X2 -> auto___type_2 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_982 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_57 X1 -> auto___type_2 X2 -> auto___type_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2.
  cut (auto___type_2 X2 -> auto___type_2 X2). tauto. exact (rem_981 epsilon_mknows_current_p__type_14 X2).
Defined.

Remark rem_983 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_57 X1 -> auto___type_2 X2 -> (auto___def_57 X1 /\ auto___type_2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2. intros A1 A2.
  cut (auto___def_57 X1). 2:apply (rem_980 epsilon_mknows_current_p__type_14 X1 X2);  assumption.
  cut (auto___type_2 X2). 2:apply (rem_982 epsilon_mknows_current_p__type_14 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_984 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_57 X1 -> auto___type_2 X2 -> auto___type_14 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2. intros A1 A2.
  case (rem_983 epsilon_mknows_current_p__type_14 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_14 A1 A2. intros. apply trans___type_14_crypt_3;  tauto.
 clear  epsilon_mknows_current_p__type_14 A1 A2. tauto.
Defined.

Remark rem_985 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1:term, auto___def_46 X1 -> auto___def_46 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_986 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_46 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2.
  cut (auto___def_46 X1 -> auto___def_46 X1). tauto. exact (rem_985 epsilon_mknows_current_p__type_14 X1).
Defined.

Remark rem_987 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X2:term, auto___def_47 X2 -> auto___def_47 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_988 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_47 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2.
  cut (auto___def_47 X2 -> auto___def_47 X2). tauto. exact (rem_987 epsilon_mknows_current_p__type_14 X2).
Defined.

Remark rem_989 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> (auto___def_46 X1 /\ auto___def_47 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2. intros A1 A2.
  cut (auto___def_46 X1). 2:apply (rem_986 epsilon_mknows_current_p__type_14 X1 X2);  assumption.
  cut (auto___def_47 X2). 2:apply (rem_988 epsilon_mknows_current_p__type_14 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_990 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___type_14 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2. intros A1 A2.
  case (rem_989 epsilon_mknows_current_p__type_14 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_14 A1 A2. intros. apply trans___type_14_crypt_4;  tauto.
 clear  epsilon_mknows_current_p__type_14 A1 A2. tauto.
Defined.

Remark rem_991 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1:term, auto___def_55 X1 -> auto___def_55 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_992 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___type_13 X2 -> auto___def_55 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2.
  cut (auto___def_55 X1 -> auto___def_55 X1). tauto. exact (rem_991 epsilon_mknows_current_p__type_14 X1).
Defined.

Remark rem_993 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X2:term, auto___type_13 X2 -> auto___type_13 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_994 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___type_13 X2 -> auto___type_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2.
  cut (auto___type_13 X2 -> auto___type_13 X2). tauto. exact (rem_993 epsilon_mknows_current_p__type_14 X2).
Defined.

Remark rem_995 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___type_13 X2 -> (auto___def_55 X1 /\ auto___type_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2. intros A1 A2.
  cut (auto___def_55 X1). 2:apply (rem_992 epsilon_mknows_current_p__type_14 X1 X2);  assumption.
  cut (auto___type_13 X2). 2:apply (rem_994 epsilon_mknows_current_p__type_14 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_996 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_55 X1 -> auto___type_13 X2 -> auto___type_14 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2. intros A1 A2.
  case (rem_995 epsilon_mknows_current_p__type_14 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_14 A1 A2. intros. apply trans___type_14_crypt_5;  tauto.
 clear  epsilon_mknows_current_p__type_14 A1 A2. tauto.
Defined.

Remark rem_997 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto_knows_current (crypt X1 X2) -> auto___type_14 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2. intro H. intros.
  elim (rem_470 X1 X2 H);  intros.
  apply (rem_972 epsilon_mknows_current_p__type_14 X1 X2);  tauto.
  apply (rem_978 epsilon_mknows_current_p__type_14 X1 X2);  tauto.
  apply (rem_984 epsilon_mknows_current_p__type_14 X1 X2);  tauto.
  apply (rem_990 epsilon_mknows_current_p__type_14 X1 X2);  tauto.
  apply (rem_996 epsilon_mknows_current_p__type_14 X1 X2);  tauto.
Defined.

Remark rem_998 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1:term, auto___def_23 X1 -> auto___def_23 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_999 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_36 X2 -> auto___def_23 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2.
  cut (auto___def_23 X1 -> auto___def_23 X1). tauto. exact (rem_998 epsilon_mknows_current_p__type_14 X1).
Defined.

Remark rem_1000 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X2:term, auto___def_36 X2 -> auto___def_36 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1001 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_36 X2 -> auto___def_36 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2.
  cut (auto___def_36 X2 -> auto___def_36 X2). tauto. exact (rem_1000 epsilon_mknows_current_p__type_14 X2).
Defined.

Remark rem_1002 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_36 X2 -> (auto___def_23 X1 /\ auto___def_36 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2. intros A1 A2.
  cut (auto___def_23 X1). 2:apply (rem_999 epsilon_mknows_current_p__type_14 X1 X2);  assumption.
  cut (auto___def_36 X2). 2:apply (rem_1001 epsilon_mknows_current_p__type_14 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1003 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_36 X2 -> auto___type_14 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2. intros A1 A2.
  case (rem_1002 epsilon_mknows_current_p__type_14 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_14 A1 A2. intros. apply trans___type_14_key_1;  tauto.
 clear  epsilon_mknows_current_p__type_14 A1 A2. tauto.
Defined.

Remark rem_1004 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1:term, auto___def_3 X1 -> auto___def_3 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1005 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___type_9 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_1004 epsilon_mknows_current_p__type_14 X1).
Defined.

Remark rem_1006 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X2:term, auto___type_9 X2 -> auto___type_9 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1007 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___type_9 X2 -> auto___type_9 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2.
  cut (auto___type_9 X2 -> auto___type_9 X2). tauto. exact (rem_1006 epsilon_mknows_current_p__type_14 X2).
Defined.

Remark rem_1008 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___type_9 X2 -> (auto___def_3 X1 /\ auto___type_9 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_1005 epsilon_mknows_current_p__type_14 X1 X2);  assumption.
  cut (auto___type_9 X2). 2:apply (rem_1007 epsilon_mknows_current_p__type_14 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1009 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___type_9 X2 -> auto___type_14 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2. intros A1 A2.
  case (rem_1008 epsilon_mknows_current_p__type_14 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_14 A1 A2. intros. apply trans___type_14_key_2;  tauto.
 clear  epsilon_mknows_current_p__type_14 A1 A2. tauto.
Defined.

Remark rem_1010 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1:term, auto___def_37 X1 -> auto___def_37 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1011 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_38 X2 -> auto___def_37 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2.
  cut (auto___def_37 X1 -> auto___def_37 X1). tauto. exact (rem_1010 epsilon_mknows_current_p__type_14 X1).
Defined.

Remark rem_1012 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X2:term, auto___def_38 X2 -> auto___def_38 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1013 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_38 X2 -> auto___def_38 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2.
  cut (auto___def_38 X2 -> auto___def_38 X2). tauto. exact (rem_1012 epsilon_mknows_current_p__type_14 X2).
Defined.

Remark rem_1014 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_38 X2 -> (auto___def_37 X1 /\ auto___def_38 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2. intros A1 A2.
  cut (auto___def_37 X1). 2:apply (rem_1011 epsilon_mknows_current_p__type_14 X1 X2);  assumption.
  cut (auto___def_38 X2). 2:apply (rem_1013 epsilon_mknows_current_p__type_14 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1015 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_38 X2 -> auto___type_14 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2. intros A1 A2.
  case (rem_1014 epsilon_mknows_current_p__type_14 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_14 A1 A2. intros. apply trans___type_14_key_3;  tauto.
 clear  epsilon_mknows_current_p__type_14 A1 A2. tauto.
Defined.

Remark rem_1016 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2:term, auto_knows_current (key X1 X2) -> auto___type_14 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2. intro H. intros.
  elim (rem_258 X1 X2 H);  intros.
  apply (rem_1003 epsilon_mknows_current_p__type_14 X1 X2);  tauto.
  apply (rem_1009 epsilon_mknows_current_p__type_14 X1 X2);  tauto.
  apply (rem_1015 epsilon_mknows_current_p__type_14 X1 X2);  tauto.
Defined.

Remark rem_1017 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> auto___type_14 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14.  case (rem_961 epsilon_mknows_current_p__type_14). clear  epsilon_mknows_current_p__type_14. intros. apply trans___type_14_bob_1;  tauto.
 clear  epsilon_mknows_current_p__type_14. tauto.
Defined.

Remark rem_1018 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> auto_knows_current bob -> auto___type_14 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intro H. intros.
  elim (rem_479 H);  intros.
  apply (rem_1017 epsilon_mknows_current_p__type_14);  tauto.
Defined.

Remark rem_1019 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2 X3:term, auto___type_14 (noncea_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2 X3.  case (rem_961 epsilon_mknows_current_p__type_14). clear  epsilon_mknows_current_p__type_14. intros. apply trans___type_14_noncea_old_1;  tauto.
 clear  epsilon_mknows_current_p__type_14. tauto.
Defined.

Remark rem_1020 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2 X3:term, auto_knows_current (noncea_old X1 X2 X3) -> auto___type_14 (noncea_old X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2 X3. intro H. intros.
  elim (rem_483 X1 X2 X3 H);  intros.
  apply (rem_1019 epsilon_mknows_current_p__type_14 X1 X2 X3);  tauto.
Defined.

Remark rem_1021 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> auto___type_14 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14.  case (rem_961 epsilon_mknows_current_p__type_14). clear  epsilon_mknows_current_p__type_14. intros. apply trans___type_14_alice_1;  tauto.
 clear  epsilon_mknows_current_p__type_14. tauto.
Defined.

Remark rem_1022 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> auto_knows_current alice -> auto___type_14 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intro H. intros.
  elim (rem_487 H);  intros.
  apply (rem_1021 epsilon_mknows_current_p__type_14);  tauto.
Defined.

Remark rem_1023 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2 X3 X4:term, auto___type_14 (nonceb_old X1 X2 X3 X4). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2 X3 X4.  case (rem_961 epsilon_mknows_current_p__type_14). clear  epsilon_mknows_current_p__type_14. intros. apply trans___type_14_nonceb_old_1;  tauto.
 clear  epsilon_mknows_current_p__type_14. tauto.
Defined.

Remark rem_1024 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> forall X1 X2 X3 X4:term, auto_knows_current (nonceb_old X1 X2 X3 X4) -> auto___type_14 (nonceb_old X1 X2 X3 X4). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intros X1 X2 X3 X4. intro H. intros.
  elim (rem_491 X1 X2 X3 X4 H);  intros.
  apply (rem_1023 epsilon_mknows_current_p__type_14 X1 X2 X3 X4);  tauto.
Defined.

Remark rem_1025 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> auto___type_14 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14.  case (rem_961 epsilon_mknows_current_p__type_14). clear  epsilon_mknows_current_p__type_14. intros. apply trans___type_14_server_1;  tauto.
 clear  epsilon_mknows_current_p__type_14. tauto.
Defined.

Remark rem_1026 : (forall X:term, auto_knows_current X -> auto___type_14 X)
    -> auto_knows_current server -> auto___type_14 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_14. intro H. intros.
  elim (rem_495 H);  intros.
  apply (rem_1025 epsilon_mknows_current_p__type_14);  tauto.
Defined.

Remark rem_1027 : forall X1:term, auto_knows_current X1 -> auto___type_14 X1. (* Induct. *)
Proof.
  fix epsilon_mknows_current_p__type_14 1.
  intro X. case X.
  exact (rem_1022 epsilon_mknows_current_p__type_14 ).
  exact (rem_1018 epsilon_mknows_current_p__type_14 ).
  intros X1 X2;  exact (rem_971 epsilon_mknows_current_p__type_14 X1 X2).
  intros X1 X2;  exact (rem_997 epsilon_mknows_current_p__type_14 X1 X2).
  exact (rem_965 epsilon_mknows_current_p__type_14 ).
   intro H. elim (rem_31  H).
  intros X1 X2;  exact (rem_1016 epsilon_mknows_current_p__type_14 X1 X2).
  exact (rem_963 epsilon_mknows_current_p__type_14 ).
  intros X1 X2 X3. intro H. elim (rem_499 X1 X2 X3 H).
  intros X1 X2 X3;  exact (rem_1020 epsilon_mknows_current_p__type_14 X1 X2 X3).
  intros X1 X2 X3 X4. intro H. elim (rem_501 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4;  exact (rem_1024 epsilon_mknows_current_p__type_14 X1 X2 X3 X4).
   intro H. elim (rem_502  H).
   intro H. elim (rem_500  H).
  intros X1;  exact (rem_960 epsilon_mknows_current_p__type_14 X1).
  exact (rem_1026 epsilon_mknows_current_p__type_14 ).
  intros X1 X2 X3. intro H. elim (rem_497 X1 X2 X3 H).
   intro H. elim (rem_498  H).
Qed.

Remark rem_1028 : forall X1 X2 X3 X4:term, auto___type_2 X2 -> auto___type_3 X3 -> auto___type_9 X4 -> auto_agent X4 -> auto_knows_current X1 -> auto___type_14 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X1 -> auto___type_14 X1). tauto. exact (rem_1027 X1).
Qed.

Remark rem_1029 : forall X1 X2 X3 X4:term, auto___type_3 X2 -> auto___type_9 X3 -> auto_agent X3 -> auto_knows_current X1 -> auto___type_2 X4 -> auto___type_14 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X3 X4 X2.
  cut (auto___type_2 X2 -> auto___type_3 X3 -> auto___type_9 X4 -> auto_agent X4 -> auto_knows_current X1 -> auto___type_14 X1). tauto. exact (rem_1028 X1 X2 X3 X4).
Qed.

Remark rem_1030 : (forall X:term, auto___def_52 X -> auto___type_14 X)
    -> forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1031 : (forall X:term, auto___def_52 X -> auto___type_14 X)
    -> forall X1 X2 X3:term, auto_agent X1 -> auto___type_11 X2 -> auto___type_10 X3 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_52_p__type_14. intros X1 X2 X3.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_1030 epsilon_m__def_52_p__type_14 X1).
Defined.

Remark rem_1032 : (forall X:term, auto___def_52 X -> auto___type_14 X)
    -> forall X2:term, auto___type_11 X2 -> auto___type_11 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1033 : (forall X:term, auto___def_52 X -> auto___type_14 X)
    -> forall X1 X2 X3:term, auto_agent X1 -> auto___type_11 X2 -> auto___type_10 X3 -> auto___type_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_52_p__type_14. intros X1 X2 X3.
  cut (auto___type_11 X2 -> auto___type_11 X2). tauto. exact (rem_1032 epsilon_m__def_52_p__type_14 X2).
Defined.

Remark rem_1034 : (forall X:term, auto___def_52 X -> auto___type_14 X)
    -> forall X3:term, auto___type_10 X3 -> auto___type_10 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1035 : (forall X:term, auto___def_52 X -> auto___type_14 X)
    -> forall X1 X2 X3:term, auto_agent X1 -> auto___type_11 X2 -> auto___type_10 X3 -> auto___type_10 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_52_p__type_14. intros X1 X2 X3.
  cut (auto___type_10 X3 -> auto___type_10 X3). tauto. exact (rem_1034 epsilon_m__def_52_p__type_14 X3).
Defined.

Remark rem_1036 : (forall X:term, auto___def_52 X -> auto___type_14 X)
    -> forall X1 X2 X3:term, auto_agent X1 -> auto___type_11 X2 -> auto___type_10 X3 -> (auto_agent X1 /\ auto___type_11 X2 /\ auto___type_10 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_52_p__type_14. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto_agent X1). 2:apply (rem_1031 epsilon_m__def_52_p__type_14 X1 X2 X3);  assumption.
  cut (auto___type_11 X2). 2:apply (rem_1033 epsilon_m__def_52_p__type_14 X1 X2 X3);  assumption.
  cut (auto___type_10 X3). 2:apply (rem_1035 epsilon_m__def_52_p__type_14 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_1037 : (forall X:term, auto___def_52 X -> auto___type_14 X)
    -> forall X1 X2 X3:term, auto_agent X1 -> auto___type_11 X2 -> auto___type_10 X3 -> auto___type_14 (noncea_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_52_p__type_14. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_1036 epsilon_m__def_52_p__type_14 X1 X2 X3 A1 A2 A3). clear  epsilon_m__def_52_p__type_14 A1 A2 A3. intros. apply trans___type_14_noncea_current_1;  tauto.
 clear  epsilon_m__def_52_p__type_14 A1 A2 A3. tauto.
Defined.

Remark rem_1038 : (forall X:term, auto___def_52 X -> auto___type_14 X)
    -> forall X1 X2 X3:term, auto___def_52 (noncea_current X1 X2 X3) -> auto___type_14 (noncea_current X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_52_p__type_14. intros X1 X2 X3. intro H. intros.
  elim (rem_851 X1 X2 X3 H);  intros.
  apply (rem_1037 epsilon_m__def_52_p__type_14 X1 X2 X3);  tauto.
Defined.

Remark rem_1039 : forall X1:term, auto___def_52 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1040 : auto___def_52 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1041 : auto___def_52 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1042 : forall X1 X2 X3:term, auto___def_52 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1043 : auto___def_52 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1044 : forall X1 X2:term, auto___def_52 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1045 : forall X1 X2:term, auto___def_52 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1046 : forall X1 X2:term, auto___def_52 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1047 : auto___def_52 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1048 : forall X1 X2 X3:term, auto___def_52 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1049 : auto___def_52 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1050 : forall X1 X2 X3 X4:term, auto___def_52 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1051 : auto___def_52 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1052 : forall X1 X2 X3 X4:term, auto___def_52 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1053 : auto___def_52 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1054 : auto___def_52 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1055 : auto___def_52 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1056 : forall X1:term, auto___def_52 X1 -> auto___type_14 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_52_p__type_14 1.
  intro X. case X.
   intro H. elim (rem_1049  H).
   intro H. elim (rem_1047  H).
  intros X1 X2. intro H. elim (rem_1044 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1045 X1 X2 H).
   intro H. elim (rem_1041  H).
   intro H. elim (rem_1053  H).
  intros X1 X2. intro H. elim (rem_1046 X1 X2 H).
   intro H. elim (rem_1040  H).
  intros X1 X2 X3;  exact (rem_1038 epsilon_m__def_52_p__type_14 X1 X2 X3).
  intros X1 X2 X3. intro H. elim (rem_1048 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1052 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1050 X1 X2 X3 X4 H).
   intro H. elim (rem_1055  H).
   intro H. elim (rem_1051  H).
  intros X1. intro H. elim (rem_1039 X1 H).
   intro H. elim (rem_1054  H).
  intros X1 X2 X3. intro H. elim (rem_1042 X1 X2 X3 H).
   intro H. elim (rem_1043  H).
Qed.

Remark rem_1057 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_52 X1 -> auto___type_10 X3 -> auto___type_11 X4 -> auto_agent X4 -> auto_agent X2 -> auto___type_14 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_52 X1 -> auto___type_14 X1). tauto. exact (rem_1056 X1).
Qed.

Remark rem_1058 : forall X1 X2 X3 X4:term, auto___type_11 X2 -> auto_agent X2 -> auto_agent X3 -> auto___def_2 X3 -> auto___def_52 X1 -> auto___type_10 X4 -> auto___type_14 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X4 X2 X3.
  cut (auto___def_2 X2 -> auto___def_52 X1 -> auto___type_10 X3 -> auto___type_11 X4 -> auto_agent X4 -> auto_agent X2 -> auto___type_14 X1). tauto. exact (rem_1057 X1 X2 X3 X4).
Qed.

Remark rem_1059 : forall X1 X2 X3 X4:term, auto___def_52 X1 -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X4 -> auto_agent X4 -> auto_agent X2 -> auto___type_14 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_52 X1 -> auto___type_14 X1). tauto. exact (rem_1056 X1).
Qed.

Remark rem_1060 : forall X1 X2 X3 X4:term, auto___type_3 X2 -> auto_agent X2 -> auto___def_7 X3 -> auto_agent X3 -> auto___def_52 X1 -> auto___type_2 X4 -> auto___type_14 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X4 X2 X3.
  cut (auto___def_52 X1 -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X4 -> auto_agent X4 -> auto_agent X2 -> auto___type_14 X1). tauto. exact (rem_1059 X1 X2 X3 X4).
Qed.

Remark rem_1061 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_52 X1 -> auto___type_10 X3 -> auto___type_11 X4 -> auto_agent X4 -> auto_agent X2 -> auto___type_14 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_52 X1 -> auto___type_14 X1). tauto. exact (rem_1056 X1).
Qed.

Remark rem_1062 : forall X1 X2 X3 X4:term, auto___type_11 X2 -> auto_agent X2 -> auto___def_5 X3 -> auto_agent X3 -> auto___def_52 X1 -> auto___type_10 X4 -> auto___type_14 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X4 X2 X3.
  cut (auto___def_5 X2 -> auto___def_52 X1 -> auto___type_10 X3 -> auto___type_11 X4 -> auto_agent X4 -> auto_agent X2 -> auto___type_14 X1). tauto. exact (rem_1061 X1 X2 X3 X4).
Qed.

Remark rem_1063 : forall X1 X2 X3 X4:term, auto___def_54 X2 X3 X1 X4 -> auto___type_14 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_420 X2 X3 X1 X4 H);  intros.
  apply (rem_1029 X1 X2 X3 X4);  tauto.
  apply (rem_1058 X1 X2 X3 X4);  tauto.
  apply (rem_1060 X1 X2 X3 X4);  tauto.
  apply (rem_1062 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1064 : forall X1 X2:term, auto___def_17 X2 -> auto_agent X1 -> auto___def_28 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_5 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_28_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1065 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current (key pub X1) -> auto___type_9 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Qed.

Remark rem_1066 : forall X2:term, auto_knows_current X2 -> auto_knows_current X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1067 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current (key pub X1) -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_1066 X2).
Qed.

Remark rem_1068 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current (key pub X1) -> (auto___type_9 X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_9 X1). 2:apply (rem_1065 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1067 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1069 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current (key pub X1) -> auto___def_39 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1068 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_39_10;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1070 : forall X1 X2:term, auto___def_2 X1 -> auto___def_3 pub -> auto___def_51 X2 -> auto___def_2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_2 X1 -> auto___def_2 X1). tauto. exact (rem_866 X1).
Qed.

Remark rem_1071 : forall X2:term, auto___def_51 X2 -> auto___def_51 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1072 : forall X1 X2:term, auto___def_2 X1 -> auto___def_3 pub -> auto___def_51 X2 -> auto___def_51 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_51 X2 -> auto___def_51 X2). tauto. exact (rem_1071 X2).
Qed.

Remark rem_1073 : forall X1 X2:term, auto___def_2 X1 -> auto___def_3 pub -> auto___def_51 X2 -> (auto___def_2 X1 /\ auto___def_51 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_2 X1). 2:apply (rem_1070 X1 X2);  assumption.
  cut (auto___def_51 X2). 2:apply (rem_1072 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1074 : forall X1 X2:term, auto___def_2 X1 -> auto___def_3 pub -> auto___def_51 X2 -> auto___def_39 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1073 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_39_5;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1075 : forall X1 X2:term, auto___def_3 pub -> auto___def_2 X1 -> auto___def_51 X2 -> auto___def_39 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_2 X1 -> auto___def_3 pub -> auto___def_51 X2 -> auto___def_39 X1 X2). tauto. exact (rem_1074 X1 X2).
Qed.

Remark rem_1076 : forall X1 X2:term, auto___def_3 pub -> auto___def_5 X1 -> auto___def_51 X2 -> auto___def_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_5 X1 -> auto___def_5 X1). tauto. exact (rem_889 X1).
Qed.

Remark rem_1077 : forall X1 X2:term, auto___def_3 pub -> auto___def_5 X1 -> auto___def_51 X2 -> auto___def_51 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_51 X2 -> auto___def_51 X2). tauto. exact (rem_1071 X2).
Qed.

Remark rem_1078 : forall X1 X2:term, auto___def_3 pub -> auto___def_5 X1 -> auto___def_51 X2 -> (auto___def_5 X1 /\ auto___def_51 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_5 X1). 2:apply (rem_1076 X1 X2);  assumption.
  cut (auto___def_51 X2). 2:apply (rem_1077 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1079 : forall X1 X2:term, auto___def_3 pub -> auto___def_5 X1 -> auto___def_51 X2 -> auto___def_39 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1078 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_39_2;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1080 : forall X1 X2:term, auto___def_3 pub -> auto___def_51 X2 -> auto___def_7 X1 -> auto___def_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_7 X1 -> auto___def_7 X1). tauto. exact (rem_155 X1).
Qed.

Remark rem_1081 : forall X1 X2:term, auto___def_3 pub -> auto___def_51 X2 -> auto___def_7 X1 -> auto___def_51 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_51 X2 -> auto___def_51 X2). tauto. exact (rem_1071 X2).
Qed.

Remark rem_1082 : forall X1 X2:term, auto___def_3 pub -> auto___def_51 X2 -> auto___def_7 X1 -> (auto___def_7 X1 /\ auto___def_51 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_7 X1). 2:apply (rem_1080 X1 X2);  assumption.
  cut (auto___def_51 X2). 2:apply (rem_1081 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1083 : forall X1 X2:term, auto___def_3 pub -> auto___def_51 X2 -> auto___def_7 X1 -> auto___def_39 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1082 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_39_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1084 : forall X1 X2:term, auto___def_3 pub -> auto___def_7 X1 -> auto___def_51 X2 -> auto___def_39 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_3 pub -> auto___def_51 X2 -> auto___def_7 X1 -> auto___def_39 X1 X2). tauto. exact (rem_1083 X1 X2).
Qed.

Remark rem_1085 : forall X1 X2:term, auto___def_51 X2 -> auto___type_12 (key pub X1) -> auto___def_39 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_427 pub X1 H);  intros.
  apply (rem_1075 X1 X2);  tauto.
  apply (rem_1079 X1 X2);  tauto.
  apply (rem_1084 X1 X2);  tauto.
Qed.

Remark rem_1086 : forall X1 X2:term, auto___def_2 X1 -> auto___def_3 pub -> auto___def_57 X2 -> auto___def_2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_2 X1 -> auto___def_2 X1). tauto. exact (rem_866 X1).
Qed.

Remark rem_1087 : forall X1 X2:term, auto___def_2 X1 -> auto___def_3 pub -> auto___def_57 X2 -> auto___def_57 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_57 X2 -> auto___def_57 X2). tauto. exact (rem_868 X2).
Qed.

Remark rem_1088 : forall X1 X2:term, auto___def_2 X1 -> auto___def_3 pub -> auto___def_57 X2 -> (auto___def_2 X1 /\ auto___def_57 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_2 X1). 2:apply (rem_1086 X1 X2);  assumption.
  cut (auto___def_57 X2). 2:apply (rem_1087 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1089 : forall X1 X2:term, auto___def_2 X1 -> auto___def_3 pub -> auto___def_57 X2 -> auto___def_39 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1088 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_39_6;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1090 : forall X1 X2:term, auto___def_3 pub -> auto___def_2 X1 -> auto___def_57 X2 -> auto___def_39 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_2 X1 -> auto___def_3 pub -> auto___def_57 X2 -> auto___def_39 X1 X2). tauto. exact (rem_1089 X1 X2).
Qed.

Remark rem_1091 : forall X1 X2:term, auto___def_3 pub -> auto___def_5 X1 -> auto___def_57 X2 -> auto___def_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_5 X1 -> auto___def_5 X1). tauto. exact (rem_889 X1).
Qed.

Remark rem_1092 : forall X1 X2:term, auto___def_3 pub -> auto___def_5 X1 -> auto___def_57 X2 -> auto___def_57 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_57 X2 -> auto___def_57 X2). tauto. exact (rem_868 X2).
Qed.

Remark rem_1093 : forall X1 X2:term, auto___def_3 pub -> auto___def_5 X1 -> auto___def_57 X2 -> (auto___def_5 X1 /\ auto___def_57 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_5 X1). 2:apply (rem_1091 X1 X2);  assumption.
  cut (auto___def_57 X2). 2:apply (rem_1092 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1094 : forall X1 X2:term, auto___def_3 pub -> auto___def_5 X1 -> auto___def_57 X2 -> auto___def_39 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1093 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_39_8;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1095 : forall X1 X2:term, auto___def_3 pub -> auto___def_57 X2 -> auto___def_7 X1 -> auto___def_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_7 X1 -> auto___def_7 X1). tauto. exact (rem_155 X1).
Qed.

Remark rem_1096 : forall X1 X2:term, auto___def_3 pub -> auto___def_57 X2 -> auto___def_7 X1 -> auto___def_57 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_57 X2 -> auto___def_57 X2). tauto. exact (rem_868 X2).
Qed.

Remark rem_1097 : forall X1 X2:term, auto___def_3 pub -> auto___def_57 X2 -> auto___def_7 X1 -> (auto___def_7 X1 /\ auto___def_57 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_7 X1). 2:apply (rem_1095 X1 X2);  assumption.
  cut (auto___def_57 X2). 2:apply (rem_1096 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1098 : forall X1 X2:term, auto___def_3 pub -> auto___def_57 X2 -> auto___def_7 X1 -> auto___def_39 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1097 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_39_4;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1099 : forall X1 X2:term, auto___def_3 pub -> auto___def_7 X1 -> auto___def_57 X2 -> auto___def_39 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_3 pub -> auto___def_57 X2 -> auto___def_7 X1 -> auto___def_39 X1 X2). tauto. exact (rem_1098 X1 X2).
Qed.

Remark rem_1100 : forall X1 X2:term, auto___def_57 X2 -> auto___type_2 (key pub X1) -> auto___def_39 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_145 pub X1 H);  intros.
  apply (rem_1090 X1 X2);  tauto.
  apply (rem_1094 X1 X2);  tauto.
  apply (rem_1099 X1 X2);  tauto.
Qed.

Remark rem_1101 : forall X1 X2:term, auto___def_46 X2 -> auto___def_47 (key pub X1) -> auto___type_9 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Qed.

Remark rem_1102 : forall X1:term, auto___type_10 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_m__type_10_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_352  H).
   intro H. elim (rem_350  H).
  intros X1 X2. intro H. elim (rem_348 X1 X2 H).
  intros X1 X2. intro H. elim (rem_349 X1 X2 H).
   intro H. elim (rem_344  H).
   intro H. elim (rem_356  H).
  intros X1 X2;  exact (rem_657 epsilon_m__type_10_pknows_current X1 X2).
   intro H. elim (rem_343  H).
  intros X1 X2 X3. intro H. elim (rem_347 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_351 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_355 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_353 X1 X2 X3 X4 H).
   intro H. elim (rem_358  H).
   intro H. elim (rem_354  H).
  intros X1. intro H. elim (rem_342 X1 H).
   intro H. elim (rem_357  H).
  intros X1 X2 X3. intro H. elim (rem_345 X1 X2 X3 H).
   intro H. elim (rem_346  H).
Qed.

Remark rem_1103 : (forall X:term, auto___def_46 X -> auto_knows_current X)
    -> forall X1:term, auto___type_10 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__def_46_pknows_current. exact (rem_1102).
Defined.

Remark rem_1104 : (forall X:term, auto___def_46 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_10 X1 -> auto___def_48 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_46_pknows_current. intros X1 X2.
  cut (auto___type_10 X1 -> auto_knows_current X1). tauto. exact (rem_1103 epsilon_m__def_46_pknows_current X1).
Defined.

Remark rem_1105 : (forall X:term, auto___type_11 X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_11_pknows_current.  tauto.
Defined.

Remark rem_1106 : (forall X:term, auto___type_11 X -> auto_knows_current X)
    -> auto_knows_current bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_11_pknows_current.  case (rem_1105 epsilon_m__type_11_pknows_current). clear  epsilon_m__type_11_pknows_current. intros. apply trans_knows_current_bob_1;  tauto.
 clear  epsilon_m__type_11_pknows_current. tauto.
Defined.

Remark rem_1107 : (forall X:term, auto___type_11 X -> auto_knows_current X)
    -> auto___type_11 bob -> auto_knows_current bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_11_pknows_current. intro H. intros.
  elim (rem_283 H);  intros.
  apply (rem_1106 epsilon_m__type_11_pknows_current);  tauto.
Defined.

Remark rem_1108 : (forall X:term, auto___type_11 X -> auto_knows_current X)
    -> auto_knows_current alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_11_pknows_current.  case (rem_1105 epsilon_m__type_11_pknows_current). clear  epsilon_m__type_11_pknows_current. intros. apply trans_knows_current_alice_1;  tauto.
 clear  epsilon_m__type_11_pknows_current. tauto.
Defined.

Remark rem_1109 : (forall X:term, auto___type_11 X -> auto_knows_current X)
    -> auto___type_11 alice -> auto_knows_current alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_11_pknows_current. intro H. intros.
  elim (rem_286 H);  intros.
  apply (rem_1108 epsilon_m__type_11_pknows_current);  tauto.
Defined.

Remark rem_1110 : (forall X:term, auto___type_11 X -> auto_knows_current X)
    -> auto_knows_current server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_11_pknows_current.  case (rem_1105 epsilon_m__type_11_pknows_current). clear  epsilon_m__type_11_pknows_current. intros. apply trans_knows_current_server_1;  tauto.
 clear  epsilon_m__type_11_pknows_current. tauto.
Defined.

Remark rem_1111 : (forall X:term, auto___type_11 X -> auto_knows_current X)
    -> auto___type_11 server -> auto_knows_current server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_11_pknows_current. intro H. intros.
  elim (rem_289 H);  intros.
  apply (rem_1110 epsilon_m__type_11_pknows_current);  tauto.
Defined.

Remark rem_1112 : forall X1:term, auto___type_11 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_m__type_11_pknows_current 1.
  intro X. case X.
  exact (rem_1109 epsilon_m__type_11_pknows_current ).
  exact (rem_1107 epsilon_m__type_11_pknows_current ).
  intros X1 X2. intro H. elim (rem_297 X1 X2 H).
  intros X1 X2. intro H. elim (rem_298 X1 X2 H).
   intro H. elim (rem_293  H).
   intro H. elim (rem_304  H).
  intros X1 X2. intro H. elim (rem_299 X1 X2 H).
   intro H. elim (rem_292  H).
  intros X1 X2 X3. intro H. elim (rem_296 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_300 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_303 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_301 X1 X2 X3 X4 H).
   intro H. elim (rem_305  H).
   intro H. elim (rem_302  H).
  intros X1. intro H. elim (rem_291 X1 H).
  exact (rem_1111 epsilon_m__type_11_pknows_current ).
  intros X1 X2 X3. intro H. elim (rem_294 X1 X2 X3 H).
   intro H. elim (rem_295  H).
Qed.

Remark rem_1113 : (forall X:term, auto___def_48 X -> auto_knows_current X)
    -> forall X1:term, auto___type_11 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__def_48_pknows_current. exact (rem_1112).
Defined.

Remark rem_1114 : (forall X:term, auto___def_48 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_11 X1 -> auto___def_49 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_48_pknows_current. intros X1 X2.
  cut (auto___type_11 X1 -> auto_knows_current X1). tauto. exact (rem_1113 epsilon_m__def_48_pknows_current X1).
Defined.

Remark rem_1115 : (forall X:term, auto___def_49 X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_49_pknows_current.  tauto.
Defined.

Remark rem_1116 : (forall X:term, auto___def_49 X -> auto_knows_current X)
    -> auto_knows_current nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_49_pknows_current.  case (rem_1115 epsilon_m__def_49_pknows_current). clear  epsilon_m__def_49_pknows_current. intros. apply trans_knows_current_nil_1;  tauto.
 clear  epsilon_m__def_49_pknows_current. tauto.
Defined.

Remark rem_1117 : auto___def_49 nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1118 : (forall X:term, auto___def_49 X -> auto_knows_current X)
    -> auto___def_49 nil -> auto_knows_current nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_49_pknows_current. intro H. intros.
  elim (rem_1117 H);  intros.
  apply (rem_1116 epsilon_m__def_49_pknows_current);  tauto.
Defined.

Remark rem_1119 : forall X1:term, auto___def_49 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1120 : auto___def_49 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1121 : forall X1 X2 X3:term, auto___def_49 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1122 : auto___def_49 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1123 : forall X1 X2 X3:term, auto___def_49 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1124 : forall X1 X2:term, auto___def_49 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1125 : forall X1 X2:term, auto___def_49 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1126 : auto___def_49 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1127 : forall X1 X2 X3:term, auto___def_49 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1128 : auto___def_49 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1129 : forall X1 X2 X3 X4:term, auto___def_49 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1130 : auto___def_49 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1131 : forall X1 X2 X3 X4:term, auto___def_49 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1132 : auto___def_49 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1133 : auto___def_49 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1134 : auto___def_49 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1135 : forall X2:term, auto___def_49 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__def_49_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_1128  H).
   intro H. elim (rem_1126  H).
  intros X1 X2. intro H. elim (rem_855 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1124 X1 X2 H).
   intro H. elim (rem_1120  H).
   intro H. elim (rem_1132  H).
  intros X1 X2. intro H. elim (rem_1125 X1 X2 H).
  exact (rem_1118 epsilon_m__def_49_pknows_current ).
  intros X1 X2 X3. intro H. elim (rem_1123 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1127 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1131 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1129 X1 X2 X3 X4 H).
   intro H. elim (rem_1134  H).
   intro H. elim (rem_1130  H).
  intros X1. intro H. elim (rem_1119 X1 H).
   intro H. elim (rem_1133  H).
  intros X1 X2 X3. intro H. elim (rem_1121 X1 X2 X3 H).
   intro H. elim (rem_1122  H).
Qed.

Remark rem_1136 : (forall X:term, auto___def_48 X -> auto_knows_current X)
    -> forall X2:term, auto___def_49 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_m__def_48_pknows_current. exact (rem_1135).
Defined.

Remark rem_1137 : (forall X:term, auto___def_48 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_11 X1 -> auto___def_49 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_48_pknows_current. intros X1 X2.
  cut (auto___def_49 X2 -> auto_knows_current X2). tauto. exact (rem_1136 epsilon_m__def_48_pknows_current X2).
Defined.

Remark rem_1138 : (forall X:term, auto___def_48 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_11 X1 -> auto___def_49 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_48_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_1114 epsilon_m__def_48_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1137 epsilon_m__def_48_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1139 : (forall X:term, auto___def_48 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_11 X1 -> auto___def_49 X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_48_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1138 epsilon_m__def_48_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_48_pknows_current A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  epsilon_m__def_48_pknows_current A1 A2. tauto.
Defined.

Remark rem_1140 : (forall X:term, auto___def_48 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_48 (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_48_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_443 X1 X2 H);  intros.
  apply (rem_1139 epsilon_m__def_48_pknows_current X1 X2);  tauto.
Defined.

Remark rem_1141 : forall X1:term, auto___def_48 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1142 : auto___def_48 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1143 : auto___def_48 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1144 : forall X1 X2 X3:term, auto___def_48 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1145 : auto___def_48 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1146 : forall X1 X2 X3:term, auto___def_48 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1147 : forall X1 X2:term, auto___def_48 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1148 : forall X1 X2:term, auto___def_48 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1149 : auto___def_48 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1150 : forall X1 X2 X3:term, auto___def_48 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1151 : auto___def_48 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1152 : forall X1 X2 X3 X4:term, auto___def_48 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1153 : auto___def_48 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1154 : forall X1 X2 X3 X4:term, auto___def_48 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1155 : auto___def_48 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1156 : auto___def_48 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1157 : auto___def_48 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1158 : forall X2:term, auto___def_48 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__def_48_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_1151  H).
   intro H. elim (rem_1149  H).
  intros X1 X2;  exact (rem_1140 epsilon_m__def_48_pknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_1147 X1 X2 H).
   intro H. elim (rem_1143  H).
   intro H. elim (rem_1155  H).
  intros X1 X2. intro H. elim (rem_1148 X1 X2 H).
   intro H. elim (rem_1142  H).
  intros X1 X2 X3. intro H. elim (rem_1146 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1150 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1154 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1152 X1 X2 X3 X4 H).
   intro H. elim (rem_1157  H).
   intro H. elim (rem_1153  H).
  intros X1. intro H. elim (rem_1141 X1 H).
   intro H. elim (rem_1156  H).
  intros X1 X2 X3. intro H. elim (rem_1144 X1 X2 X3 H).
   intro H. elim (rem_1145  H).
Qed.

Remark rem_1159 : (forall X:term, auto___def_46 X -> auto_knows_current X)
    -> forall X2:term, auto___def_48 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_m__def_46_pknows_current. exact (rem_1158).
Defined.

Remark rem_1160 : (forall X:term, auto___def_46 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_10 X1 -> auto___def_48 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_46_pknows_current. intros X1 X2.
  cut (auto___def_48 X2 -> auto_knows_current X2). tauto. exact (rem_1159 epsilon_m__def_46_pknows_current X2).
Defined.

Remark rem_1161 : (forall X:term, auto___def_46 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_10 X1 -> auto___def_48 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_46_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_1104 epsilon_m__def_46_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1160 epsilon_m__def_46_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1162 : (forall X:term, auto___def_46 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_10 X1 -> auto___def_48 X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_46_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1161 epsilon_m__def_46_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_46_pknows_current A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  epsilon_m__def_46_pknows_current A1 A2. tauto.
Defined.

Remark rem_1163 : (forall X:term, auto___def_46 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_46 (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_46_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_446 X1 X2 H);  intros.
  apply (rem_1162 epsilon_m__def_46_pknows_current X1 X2);  tauto.
Defined.

Remark rem_1164 : forall X1:term, auto___def_46 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1165 : auto___def_46 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1166 : auto___def_46 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1167 : forall X1 X2 X3:term, auto___def_46 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1168 : auto___def_46 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1169 : forall X1 X2 X3:term, auto___def_46 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1170 : forall X1 X2:term, auto___def_46 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1171 : forall X1 X2:term, auto___def_46 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1172 : auto___def_46 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1173 : forall X1 X2 X3:term, auto___def_46 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1174 : auto___def_46 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1175 : forall X1 X2 X3 X4:term, auto___def_46 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1176 : auto___def_46 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1177 : forall X1 X2 X3 X4:term, auto___def_46 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1178 : auto___def_46 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1179 : auto___def_46 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1180 : auto___def_46 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1181 : forall X2:term, auto___def_46 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__def_46_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_1174  H).
   intro H. elim (rem_1172  H).
  intros X1 X2;  exact (rem_1163 epsilon_m__def_46_pknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_1170 X1 X2 H).
   intro H. elim (rem_1166  H).
   intro H. elim (rem_1178  H).
  intros X1 X2. intro H. elim (rem_1171 X1 X2 H).
   intro H. elim (rem_1165  H).
  intros X1 X2 X3. intro H. elim (rem_1169 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1173 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1177 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1175 X1 X2 X3 X4 H).
   intro H. elim (rem_1180  H).
   intro H. elim (rem_1176  H).
  intros X1. intro H. elim (rem_1164 X1 H).
   intro H. elim (rem_1179  H).
  intros X1 X2 X3. intro H. elim (rem_1167 X1 X2 X3 H).
   intro H. elim (rem_1168  H).
Qed.

Remark rem_1182 : forall X1 X2:term, auto___def_46 X2 -> auto___def_47 (key pub X1) -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_46 X2 -> auto_knows_current X2). tauto. exact (rem_1181 X2).
Qed.

Remark rem_1183 : forall X1 X2:term, auto___def_46 X2 -> auto___def_47 (key pub X1) -> (auto___type_9 X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_9 X1). 2:apply (rem_1101 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1182 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1184 : forall X1 X2:term, auto___def_46 X2 -> auto___def_47 (key pub X1) -> auto___def_39 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1183 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_39_10;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1185 : forall X1 X2:term, auto___def_2 X1 -> auto___def_3 pub -> auto___def_55 X2 -> auto___def_2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_2 X1 -> auto___def_2 X1). tauto. exact (rem_866 X1).
Qed.

Remark rem_1186 : forall X2:term, auto___def_55 X2 -> auto___def_55 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1187 : forall X1 X2:term, auto___def_2 X1 -> auto___def_3 pub -> auto___def_55 X2 -> auto___def_55 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_55 X2 -> auto___def_55 X2). tauto. exact (rem_1186 X2).
Qed.

Remark rem_1188 : forall X1 X2:term, auto___def_2 X1 -> auto___def_3 pub -> auto___def_55 X2 -> (auto___def_2 X1 /\ auto___def_55 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_2 X1). 2:apply (rem_1185 X1 X2);  assumption.
  cut (auto___def_55 X2). 2:apply (rem_1187 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1189 : forall X1 X2:term, auto___def_2 X1 -> auto___def_3 pub -> auto___def_55 X2 -> auto___def_39 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1188 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_39_7;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1190 : forall X1 X2:term, auto___def_3 pub -> auto___def_2 X1 -> auto___def_55 X2 -> auto___def_39 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_2 X1 -> auto___def_3 pub -> auto___def_55 X2 -> auto___def_39 X1 X2). tauto. exact (rem_1189 X1 X2).
Qed.

Remark rem_1191 : forall X1 X2:term, auto___def_3 pub -> auto___def_5 X1 -> auto___def_55 X2 -> auto___def_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_5 X1 -> auto___def_5 X1). tauto. exact (rem_889 X1).
Qed.

Remark rem_1192 : forall X1 X2:term, auto___def_3 pub -> auto___def_5 X1 -> auto___def_55 X2 -> auto___def_55 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_55 X2 -> auto___def_55 X2). tauto. exact (rem_1186 X2).
Qed.

Remark rem_1193 : forall X1 X2:term, auto___def_3 pub -> auto___def_5 X1 -> auto___def_55 X2 -> (auto___def_5 X1 /\ auto___def_55 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_5 X1). 2:apply (rem_1191 X1 X2);  assumption.
  cut (auto___def_55 X2). 2:apply (rem_1192 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1194 : forall X1 X2:term, auto___def_3 pub -> auto___def_5 X1 -> auto___def_55 X2 -> auto___def_39 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1193 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_39_3;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1195 : forall X1 X2:term, auto___def_3 pub -> auto___def_55 X2 -> auto___def_7 X1 -> auto___def_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_7 X1 -> auto___def_7 X1). tauto. exact (rem_155 X1).
Qed.

Remark rem_1196 : forall X1 X2:term, auto___def_3 pub -> auto___def_55 X2 -> auto___def_7 X1 -> auto___def_55 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_55 X2 -> auto___def_55 X2). tauto. exact (rem_1186 X2).
Qed.

Remark rem_1197 : forall X1 X2:term, auto___def_3 pub -> auto___def_55 X2 -> auto___def_7 X1 -> (auto___def_7 X1 /\ auto___def_55 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_7 X1). 2:apply (rem_1195 X1 X2);  assumption.
  cut (auto___def_55 X2). 2:apply (rem_1196 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1198 : forall X1 X2:term, auto___def_3 pub -> auto___def_55 X2 -> auto___def_7 X1 -> auto___def_39 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1197 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_39_9;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1199 : forall X1 X2:term, auto___def_3 pub -> auto___def_7 X1 -> auto___def_55 X2 -> auto___def_39 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_3 pub -> auto___def_55 X2 -> auto___def_7 X1 -> auto___def_39 X1 X2). tauto. exact (rem_1198 X1 X2).
Qed.

Remark rem_1200 : forall X1 X2:term, auto___def_55 X2 -> auto___type_13 (key pub X1) -> auto___def_39 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_789 pub X1 H);  intros.
  apply (rem_1190 X1 X2);  tauto.
  apply (rem_1194 X1 X2);  tauto.
  apply (rem_1199 X1 X2);  tauto.
Qed.

Remark rem_1201 : forall X1 X2:term, auto_knows_current (crypt X2 (key pub X1)) -> auto___def_39 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_470 X2 (key pub X1) H);  intros.
  apply (rem_1069 X1 X2);  tauto.
  apply (rem_1085 X1 X2);  tauto.
  apply (rem_1100 X1 X2);  tauto.
  apply (rem_1184 X1 X2);  tauto.
  apply (rem_1200 X1 X2);  tauto.
Qed.

Remark rem_1202 : (forall X:term, auto___def_36 X -> auto___def_11 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_36_p__def_11.  tauto.
Defined.

Remark rem_1203 : (forall X:term, auto___def_36 X -> auto___def_11 X)
    -> auto___def_11 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_36_p__def_11.  case (rem_1202 epsilon_m__def_36_p__def_11). clear  epsilon_m__def_36_p__def_11. intros. apply trans___def_11_i_1;  tauto.
 clear  epsilon_m__def_36_p__def_11. tauto.
Defined.

Remark rem_1204 : auto___def_36 i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1205 : (forall X:term, auto___def_36 X -> auto___def_11 X)
    -> auto___def_36 i -> auto___def_11 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_36_p__def_11. intro H. intros.
  elim (rem_1204 H);  intros.
  apply (rem_1203 epsilon_m__def_36_p__def_11);  tauto.
Defined.

Remark rem_1206 : forall X1:term, auto___def_36 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1207 : auto___def_36 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1208 : forall X1 X2 X3:term, auto___def_36 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1209 : auto___def_36 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1210 : forall X1 X2 X3:term, auto___def_36 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1211 : forall X1 X2:term, auto___def_36 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1212 : forall X1 X2:term, auto___def_36 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1213 : forall X1 X2:term, auto___def_36 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1214 : auto___def_36 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1215 : forall X1 X2 X3:term, auto___def_36 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1216 : auto___def_36 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1217 : forall X1 X2 X3 X4:term, auto___def_36 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1218 : auto___def_36 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1219 : forall X1 X2 X3 X4:term, auto___def_36 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1220 : auto___def_36 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1221 : auto___def_36 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1222 : forall X1:term, auto___def_36 X1 -> auto___def_11 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_36_p__def_11 1.
  intro X. case X.
   intro H. elim (rem_1216  H).
   intro H. elim (rem_1214  H).
  intros X1 X2. intro H. elim (rem_1211 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1212 X1 X2 H).
  exact (rem_1205 epsilon_m__def_36_p__def_11 ).
   intro H. elim (rem_1220  H).
  intros X1 X2. intro H. elim (rem_1213 X1 X2 H).
   intro H. elim (rem_1207  H).
  intros X1 X2 X3. intro H. elim (rem_1210 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1215 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1219 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1217 X1 X2 X3 X4 H).
   intro H. elim (rem_1221  H).
   intro H. elim (rem_1218  H).
  intros X1. intro H. elim (rem_1206 X1 H).
   intro H. elim (rem_212  H).
  intros X1 X2 X3. intro H. elim (rem_1208 X1 X2 X3 H).
   intro H. elim (rem_1209  H).
Qed.

Remark rem_1223 : forall X1:term, auto___def_23 prv -> auto___def_36 X1 -> auto___def_11 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1.
  cut (auto___def_36 X1 -> auto___def_11 X1). tauto. exact (rem_1222 X1).
Qed.

Remark rem_1224 : forall X1:term, auto___def_3 prv -> auto___def_11 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_3 prv -> False). tauto.
  exact (rem_138).
Qed.

Remark rem_1225 : forall X1:term, auto___def_3 prv -> auto___type_9 X1 -> auto___def_11 X1. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1. intros. apply (rem_1224 X1);  assumption.
Qed.

Remark rem_1226 : forall X1:term, auto_knows_old (key prv X1) -> auto___def_11 X1. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_172 prv X1 H);  intros.
  apply (rem_1223 X1);  tauto.
  apply (rem_1225 X1);  tauto.
Qed.

Remark rem_1227 : (forall X:term, auto_agent X -> auto___type_5 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p__type_5.  tauto.
Defined.

Remark rem_1228 : (forall X:term, auto_agent X -> auto___type_5 X)
    -> auto___type_5 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_5.  case (rem_1227 epsilon_magent_p__type_5). clear  epsilon_magent_p__type_5. intros. apply trans___type_5_i_1;  tauto.
 clear  epsilon_magent_p__type_5. tauto.
Defined.

Remark rem_1229 : (forall X:term, auto_agent X -> auto___type_5 X)
    -> auto_agent i -> auto___type_5 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_5. intro H. intros.
  elim (rem_108 H);  intros.
  apply (rem_1228 epsilon_magent_p__type_5);  tauto.
Defined.

Remark rem_1230 : (forall X:term, auto_agent X -> auto___type_5 X)
    -> auto___type_5 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_5.  case (rem_1227 epsilon_magent_p__type_5). clear  epsilon_magent_p__type_5. intros. apply trans___type_5_bob_1;  tauto.
 clear  epsilon_magent_p__type_5. tauto.
Defined.

Remark rem_1231 : (forall X:term, auto_agent X -> auto___type_5 X)
    -> auto_agent bob -> auto___type_5 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_5. intro H. intros.
  elim (rem_111 H);  intros.
  apply (rem_1230 epsilon_magent_p__type_5);  tauto.
Defined.

Remark rem_1232 : (forall X:term, auto_agent X -> auto___type_5 X)
    -> auto___type_5 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_5.  case (rem_1227 epsilon_magent_p__type_5). clear  epsilon_magent_p__type_5. intros. apply trans___type_5_alice_1;  tauto.
 clear  epsilon_magent_p__type_5. tauto.
Defined.

Remark rem_1233 : (forall X:term, auto_agent X -> auto___type_5 X)
    -> auto_agent alice -> auto___type_5 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_5. intro H. intros.
  elim (rem_114 H);  intros.
  apply (rem_1232 epsilon_magent_p__type_5);  tauto.
Defined.

Remark rem_1234 : (forall X:term, auto_agent X -> auto___type_5 X)
    -> auto___type_5 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_5.  case (rem_1227 epsilon_magent_p__type_5). clear  epsilon_magent_p__type_5. intros. apply trans___type_5_server_1;  tauto.
 clear  epsilon_magent_p__type_5. tauto.
Defined.

Remark rem_1235 : (forall X:term, auto_agent X -> auto___type_5 X)
    -> auto_agent server -> auto___type_5 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_5. intro H. intros.
  elim (rem_117 H);  intros.
  apply (rem_1234 epsilon_magent_p__type_5);  tauto.
Defined.

Remark rem_1236 : forall X1:term, auto_agent X1 -> auto___type_5 X1. (* Induct. *)
Proof.
  fix epsilon_magent_p__type_5 1.
  intro X. case X.
  exact (rem_1233 epsilon_magent_p__type_5 ).
  exact (rem_1231 epsilon_magent_p__type_5 ).
  intros X1 X2. intro H. elim (rem_124 X1 X2 H).
  intros X1 X2. intro H. elim (rem_125 X1 X2 H).
  exact (rem_1229 epsilon_magent_p__type_5 ).
   intro H. elim (rem_131  H).
  intros X1 X2. intro H. elim (rem_126 X1 X2 H).
   intro H. elim (rem_120  H).
  intros X1 X2 X3. intro H. elim (rem_123 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_127 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_130 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_128 X1 X2 X3 X4 H).
   intro H. elim (rem_132  H).
   intro H. elim (rem_129  H).
  intros X1. intro H. elim (rem_119 X1 H).
  exact (rem_1235 epsilon_magent_p__type_5 ).
  intros X1 X2 X3. intro H. elim (rem_121 X1 X2 X3 H).
   intro H. elim (rem_122  H).
Qed.

Remark rem_1237 : forall X1:term, auto___def_23 X1 -> auto___def_23 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1238 : forall X1 X2:term, auto___def_23 X1 -> auto___def_7 X2 -> auto___def_23 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_23 X1 -> auto___def_23 X1). tauto. exact (rem_1237 X1).
Qed.

Remark rem_1239 : forall X1 X2:term, auto___def_23 X1 -> auto___def_7 X2 -> auto___def_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_7 X2 -> auto___def_7 X2). tauto. exact (rem_394 X2).
Qed.

Remark rem_1240 : forall X1 X2:term, auto___def_23 X1 -> auto___def_7 X2 -> (auto___def_23 X1 /\ auto___def_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_23 X1). 2:apply (rem_1238 X1 X2);  assumption.
  cut (auto___def_7 X2). 2:apply (rem_1239 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1241 : forall X1 X2:term, auto___def_23 X1 -> auto___def_7 X2 -> auto___def_20 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1240 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_20_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1242 : forall X1 X2:term, auto___def_7 X2 -> auto___def_23 X1 -> auto___def_20 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_23 X1 -> auto___def_7 X2 -> auto___def_20 (key X1 X2)). tauto. exact (rem_1241 X1 X2).
Qed.

Remark rem_1243 : forall X1 X2 X3 X4:term, auto___def_26 X4 -> auto___def_5 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_3 X1 -> auto___type_3 X1). tauto. exact (rem_199 X1).
Qed.

Remark rem_1244 : forall X1 X2 X3 X4:term, auto___def_26 X4 -> auto___def_5 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_3 X1 -> auto_agent X1). tauto. exact (rem_392 X1).
Qed.

Remark rem_1245 : forall X1 X2 X3 X4:term, auto___def_26 X4 -> auto___def_5 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_5 X2). tauto. exact (rem_408 X2).
Qed.

Remark rem_1246 : forall X1 X2 X3 X4:term, auto___def_26 X4 -> auto___def_5 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto_agent X2). tauto. exact (rem_413 X2).
Qed.

Remark rem_1247 : forall X1 X2 X3 X4:term, auto___def_26 X4 -> auto___def_5 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_2 X3 -> auto___type_2 X3). tauto. exact (rem_274 X3).
Qed.

Remark rem_1248 : forall X4:term, auto___def_26 X4 -> auto___def_26 X4. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1249 : forall X1 X2 X3 X4:term, auto___def_26 X4 -> auto___def_5 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_26 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_26 X4 -> auto___def_26 X4). tauto. exact (rem_1248 X4).
Qed.

Remark rem_1250 : forall X1 X2 X3 X4:term, auto___def_26 X4 -> auto___def_5 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> (auto___type_3 X1 /\ auto_agent X1 /\ auto___def_5 X2 /\ auto_agent X2 /\ auto___type_2 X3 /\ auto___def_26 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  cut (auto___type_3 X1). 2:apply (rem_1243 X1 X2 X3 X4);  assumption.
  cut (auto_agent X1). 2:apply (rem_1244 X1 X2 X3 X4);  assumption.
  cut (auto___def_5 X2). 2:apply (rem_1245 X1 X2 X3 X4);  assumption.
  cut (auto_agent X2). 2:apply (rem_1246 X1 X2 X3 X4);  assumption.
  cut (auto___type_2 X3). 2:apply (rem_1247 X1 X2 X3 X4);  assumption.
  cut (auto___def_26 X4). 2:apply (rem_1249 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_1251 : forall X1 X2 X3 X4:term, auto___def_26 X4 -> auto___def_5 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_32 (nonceb_old X1 X2 X3 X4). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  case (rem_1250 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6). clear  A1 A2 A3 A4 A5 A6. intros. apply trans___def_32_nonceb_old_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6. tauto.
Qed.

Remark rem_1252 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto_agent X1 -> auto___def_5 X2 -> auto_agent X2 -> auto___def_26 X4 -> auto___type_2 X3 -> auto___def_32 (nonceb_old X1 X2 X3 X4). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_26 X4 -> auto___def_5 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_32 (nonceb_old X1 X2 X3 X4)). tauto. exact (rem_1251 X1 X2 X3 X4).
Qed.

Remark rem_1253 : forall X1 X2 X3 X4:term, auto___type_2 X3 -> auto___type_3 X1 -> auto___type_9 X2 -> auto_agent X2 -> auto_knows_old X4 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_3 X1 -> auto___type_3 X1). tauto. exact (rem_199 X1).
Qed.

Remark rem_1254 : forall X1 X2 X3 X4:term, auto___type_2 X3 -> auto___type_3 X1 -> auto___type_9 X2 -> auto_agent X2 -> auto_knows_old X4 -> auto___type_9 X2. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Qed.

Remark rem_1255 : forall X1 X2 X3 X4:term, auto___type_2 X3 -> auto___type_3 X1 -> auto___type_9 X2 -> auto_agent X2 -> auto_knows_old X4 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_272 X2).
Qed.

Remark rem_1256 : forall X1 X2 X3 X4:term, auto___type_2 X3 -> auto___type_3 X1 -> auto___type_9 X2 -> auto_agent X2 -> auto_knows_old X4 -> auto___type_2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_2 X3 -> auto___type_2 X3). tauto. exact (rem_274 X3).
Qed.

Remark rem_1257 : forall X4:term, auto_knows_old X4 -> auto_knows_old X4. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1258 : forall X1 X2 X3 X4:term, auto___type_2 X3 -> auto___type_3 X1 -> auto___type_9 X2 -> auto_agent X2 -> auto_knows_old X4 -> auto_knows_old X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old X4 -> auto_knows_old X4). tauto. exact (rem_1257 X4).
Qed.

Remark rem_1259 : forall X1 X2 X3 X4:term, auto___type_2 X3 -> auto___type_3 X1 -> auto___type_9 X2 -> auto_agent X2 -> auto_knows_old X4 -> (auto___type_3 X1 /\ auto___type_9 X2 /\ auto_agent X2 /\ auto___type_2 X3 /\ auto_knows_old X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5.
  cut (auto___type_3 X1). 2:apply (rem_1253 X1 X2 X3 X4);  assumption.
  cut (auto___type_9 X2). 2:apply (rem_1254 X1 X2 X3 X4);  assumption.
  cut (auto_agent X2). 2:apply (rem_1255 X1 X2 X3 X4);  assumption.
  cut (auto___type_2 X3). 2:apply (rem_1256 X1 X2 X3 X4);  assumption.
  cut (auto_knows_old X4). 2:apply (rem_1258 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_1260 : forall X1 X2 X3 X4:term, auto___type_2 X3 -> auto___type_3 X1 -> auto___type_9 X2 -> auto_agent X2 -> auto_knows_old X4 -> auto___def_32 (nonceb_old X1 X2 X3 X4). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5.
  case (rem_1259 X1 X2 X3 X4 A1 A2 A3 A4 A5). clear  A1 A2 A3 A4 A5. intros. apply trans___def_32_nonceb_old_3;  tauto.
 clear  A1 A2 A3 A4 A5. tauto.
Qed.

Remark rem_1261 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto___type_9 X2 -> auto_agent X2 -> auto_knows_old X4 -> auto___type_2 X3 -> auto___def_32 (nonceb_old X1 X2 X3 X4). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___type_2 X3 -> auto___type_3 X1 -> auto___type_9 X2 -> auto_agent X2 -> auto_knows_old X4 -> auto___def_32 (nonceb_old X1 X2 X3 X4)). tauto. exact (rem_1260 X1 X2 X3 X4).
Qed.

Remark rem_1262 : forall X1 X2 X3 X4:term, auto___def_26 X4 -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_3 X1 -> auto___type_3 X1). tauto. exact (rem_199 X1).
Qed.

Remark rem_1263 : forall X1 X2 X3 X4:term, auto___def_26 X4 -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_3 X1 -> auto_agent X1). tauto. exact (rem_392 X1).
Qed.

Remark rem_1264 : forall X1 X2 X3 X4:term, auto___def_26 X4 -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_7 X2 -> auto___def_7 X2). tauto. exact (rem_394 X2).
Qed.

Remark rem_1265 : forall X1 X2 X3 X4:term, auto___def_26 X4 -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_7 X2 -> auto_agent X2). tauto. exact (rem_399 X2).
Qed.

Remark rem_1266 : forall X1 X2 X3 X4:term, auto___def_26 X4 -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_2 X3 -> auto___type_2 X3). tauto. exact (rem_274 X3).
Qed.

Remark rem_1267 : forall X1 X2 X3 X4:term, auto___def_26 X4 -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_26 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_26 X4 -> auto___def_26 X4). tauto. exact (rem_1248 X4).
Qed.

Remark rem_1268 : forall X1 X2 X3 X4:term, auto___def_26 X4 -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> (auto___type_3 X1 /\ auto_agent X1 /\ auto___def_7 X2 /\ auto_agent X2 /\ auto___type_2 X3 /\ auto___def_26 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  cut (auto___type_3 X1). 2:apply (rem_1262 X1 X2 X3 X4);  assumption.
  cut (auto_agent X1). 2:apply (rem_1263 X1 X2 X3 X4);  assumption.
  cut (auto___def_7 X2). 2:apply (rem_1264 X1 X2 X3 X4);  assumption.
  cut (auto_agent X2). 2:apply (rem_1265 X1 X2 X3 X4);  assumption.
  cut (auto___type_2 X3). 2:apply (rem_1266 X1 X2 X3 X4);  assumption.
  cut (auto___def_26 X4). 2:apply (rem_1267 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_1269 : forall X1 X2 X3 X4:term, auto___def_26 X4 -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_32 (nonceb_old X1 X2 X3 X4). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  case (rem_1268 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6). clear  A1 A2 A3 A4 A5 A6. intros. apply trans___def_32_nonceb_old_4;  tauto.
 clear  A1 A2 A3 A4 A5 A6. tauto.
Qed.

Remark rem_1270 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto_agent X1 -> auto___def_7 X2 -> auto_agent X2 -> auto___def_26 X4 -> auto___type_2 X3 -> auto___def_32 (nonceb_old X1 X2 X3 X4). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_26 X4 -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_32 (nonceb_old X1 X2 X3 X4)). tauto. exact (rem_1269 X1 X2 X3 X4).
Qed.

Remark rem_1271 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_26 X4 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_3 X1 -> auto___type_3 X1). tauto. exact (rem_199 X1).
Qed.

Remark rem_1272 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_26 X4 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_3 X1 -> auto_agent X1). tauto. exact (rem_392 X1).
Qed.

Remark rem_1273 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_26 X4 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto_agent X2). tauto. exact (rem_320 X2).
Qed.

Remark rem_1274 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_26 X4 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_2 X2). tauto. exact (rem_322 X2).
Qed.

Remark rem_1275 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_26 X4 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_2 X3 -> auto___type_2 X3). tauto. exact (rem_274 X3).
Qed.

Remark rem_1276 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_26 X4 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_26 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_26 X4 -> auto___def_26 X4). tauto. exact (rem_1248 X4).
Qed.

Remark rem_1277 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_26 X4 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> (auto___type_3 X1 /\ auto_agent X1 /\ auto_agent X2 /\ auto___def_2 X2 /\ auto___type_2 X3 /\ auto___def_26 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  cut (auto___type_3 X1). 2:apply (rem_1271 X1 X2 X3 X4);  assumption.
  cut (auto_agent X1). 2:apply (rem_1272 X1 X2 X3 X4);  assumption.
  cut (auto_agent X2). 2:apply (rem_1273 X1 X2 X3 X4);  assumption.
  cut (auto___def_2 X2). 2:apply (rem_1274 X1 X2 X3 X4);  assumption.
  cut (auto___type_2 X3). 2:apply (rem_1275 X1 X2 X3 X4);  assumption.
  cut (auto___def_26 X4). 2:apply (rem_1276 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_1278 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_26 X4 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_32 (nonceb_old X1 X2 X3 X4). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  case (rem_1277 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6). clear  A1 A2 A3 A4 A5 A6. intros. apply trans___def_32_nonceb_old_2;  tauto.
 clear  A1 A2 A3 A4 A5 A6. tauto.
Qed.

Remark rem_1279 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto_agent X1 -> auto_agent X2 -> auto___def_2 X2 -> auto___def_26 X4 -> auto___type_2 X3 -> auto___def_32 (nonceb_old X1 X2 X3 X4). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_26 X4 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_32 (nonceb_old X1 X2 X3 X4)). tauto. exact (rem_1278 X1 X2 X3 X4).
Qed.

Remark rem_1280 : forall X1 X2 X3 X4:term, auto___def_29 X1 X2 X3 X4 -> or_4
    (auto___type_3 X1 /\ auto_agent X1 /\ auto___def_5 X2 /\ auto_agent X2 /\ auto___def_26 X3 /\ auto___type_2 X4)
    (auto___type_3 X1 /\ auto___type_9 X2 /\ auto_agent X2 /\ auto_knows_old X3 /\ auto___type_2 X4)
    (auto___type_3 X1 /\ auto_agent X1 /\ auto___def_7 X2 /\ auto_agent X2 /\ auto___def_26 X3 /\ auto___type_2 X4)
    (auto___type_3 X1 /\ auto_agent X1 /\ auto_agent X2 /\ auto___def_2 X2 /\ auto___def_26 X3 /\ auto___type_2 X4)
.
Proof.
  intros. inversion H.
  intros. apply or_4_intro_1; tauto.
  intros. apply or_4_intro_2; tauto.
  intros. apply or_4_intro_3; tauto.
  intros. apply or_4_intro_4; tauto.
Qed.

Remark rem_1281 : forall X1 X2 X3 X4:term, auto___def_29 X1 X2 X4 X3 -> auto___def_32 (nonceb_old X1 X2 X3 X4). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1280 X1 X2 X4 X3 H);  intros.
  apply (rem_1252 X1 X2 X3 X4);  tauto.
  apply (rem_1261 X1 X2 X3 X4);  tauto.
  apply (rem_1270 X1 X2 X3 X4);  tauto.
  apply (rem_1279 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1282 : (forall X:term, auto___def_26 X -> auto___type_7 X)
    -> forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1283 : (forall X:term, auto___def_26 X -> auto___type_7 X)
    -> forall X1 X2 X3:term, auto_agent X1 -> auto___type_3 X2 -> auto___type_2 X3 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_26_p__type_7. intros X1 X2 X3.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_1282 epsilon_m__def_26_p__type_7 X1).
Defined.

Remark rem_1284 : (forall X:term, auto___def_26 X -> auto___type_7 X)
    -> forall X2:term, auto___type_3 X2 -> auto___type_3 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1285 : (forall X:term, auto___def_26 X -> auto___type_7 X)
    -> forall X1 X2 X3:term, auto_agent X1 -> auto___type_3 X2 -> auto___type_2 X3 -> auto___type_3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_26_p__type_7. intros X1 X2 X3.
  cut (auto___type_3 X2 -> auto___type_3 X2). tauto. exact (rem_1284 epsilon_m__def_26_p__type_7 X2).
Defined.

Remark rem_1286 : (forall X:term, auto___def_26 X -> auto___type_7 X)
    -> forall X3:term, auto___type_2 X3 -> auto___type_2 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1287 : (forall X:term, auto___def_26 X -> auto___type_7 X)
    -> forall X1 X2 X3:term, auto_agent X1 -> auto___type_3 X2 -> auto___type_2 X3 -> auto___type_2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_26_p__type_7. intros X1 X2 X3.
  cut (auto___type_2 X3 -> auto___type_2 X3). tauto. exact (rem_1286 epsilon_m__def_26_p__type_7 X3).
Defined.

Remark rem_1288 : (forall X:term, auto___def_26 X -> auto___type_7 X)
    -> forall X1 X2 X3:term, auto_agent X1 -> auto___type_3 X2 -> auto___type_2 X3 -> (auto_agent X1 /\ auto___type_3 X2 /\ auto___type_2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_26_p__type_7. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto_agent X1). 2:apply (rem_1283 epsilon_m__def_26_p__type_7 X1 X2 X3);  assumption.
  cut (auto___type_3 X2). 2:apply (rem_1285 epsilon_m__def_26_p__type_7 X1 X2 X3);  assumption.
  cut (auto___type_2 X3). 2:apply (rem_1287 epsilon_m__def_26_p__type_7 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_1289 : (forall X:term, auto___def_26 X -> auto___type_7 X)
    -> forall X1 X2 X3:term, auto_agent X1 -> auto___type_3 X2 -> auto___type_2 X3 -> auto___type_7 (noncea_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_26_p__type_7. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_1288 epsilon_m__def_26_p__type_7 X1 X2 X3 A1 A2 A3). clear  epsilon_m__def_26_p__type_7 A1 A2 A3. intros. apply trans___type_7_noncea_old_1;  tauto.
 clear  epsilon_m__def_26_p__type_7 A1 A2 A3. tauto.
Defined.

Remark rem_1290 : forall X1 X2 X3:term, auto___def_26 (noncea_old X1 X2 X3) -> or_1
    (auto_agent X1 /\ auto___type_3 X2 /\ auto___type_2 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1291 : (forall X:term, auto___def_26 X -> auto___type_7 X)
    -> forall X1 X2 X3:term, auto___def_26 (noncea_old X1 X2 X3) -> auto___type_7 (noncea_old X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_26_p__type_7. intros X1 X2 X3. intro H. intros.
  elim (rem_1290 X1 X2 X3 H);  intros.
  apply (rem_1289 epsilon_m__def_26_p__type_7 X1 X2 X3);  tauto.
Defined.

Remark rem_1292 : forall X1:term, auto___def_26 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1293 : auto___def_26 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1294 : auto___def_26 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1295 : forall X1 X2 X3:term, auto___def_26 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1296 : auto___def_26 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1297 : forall X1 X2 X3:term, auto___def_26 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1298 : forall X1 X2:term, auto___def_26 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1299 : forall X1 X2:term, auto___def_26 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1300 : forall X1 X2:term, auto___def_26 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1301 : auto___def_26 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1302 : auto___def_26 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1303 : forall X1 X2 X3 X4:term, auto___def_26 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1304 : auto___def_26 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1305 : forall X1 X2 X3 X4:term, auto___def_26 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1306 : auto___def_26 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1307 : auto___def_26 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1308 : auto___def_26 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1309 : forall X1:term, auto___def_26 X1 -> auto___type_7 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_26_p__type_7 1.
  intro X. case X.
   intro H. elim (rem_1302  H).
   intro H. elim (rem_1301  H).
  intros X1 X2. intro H. elim (rem_1298 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1299 X1 X2 H).
   intro H. elim (rem_1294  H).
   intro H. elim (rem_1306  H).
  intros X1 X2. intro H. elim (rem_1300 X1 X2 H).
   intro H. elim (rem_1293  H).
  intros X1 X2 X3. intro H. elim (rem_1297 X1 X2 X3 H).
  intros X1 X2 X3;  exact (rem_1291 epsilon_m__def_26_p__type_7 X1 X2 X3).
  intros X1 X2 X3 X4. intro H. elim (rem_1305 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1303 X1 X2 X3 X4 H).
   intro H. elim (rem_1308  H).
   intro H. elim (rem_1304  H).
  intros X1. intro H. elim (rem_1292 X1 H).
   intro H. elim (rem_1307  H).
  intros X1 X2 X3. intro H. elim (rem_1295 X1 X2 X3 H).
   intro H. elim (rem_1296  H).
Qed.

Remark rem_1310 : forall X1 X2 X3 X4:term, auto___def_26 X1 -> auto___def_5 X2 -> auto___type_2 X3 -> auto___type_3 X4 -> auto_agent X4 -> auto_agent X2 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_26 X1 -> auto___type_7 X1). tauto. exact (rem_1309 X1).
Qed.

Remark rem_1311 : forall X1 X2 X3 X4:term, auto___type_3 X2 -> auto_agent X2 -> auto___def_5 X3 -> auto_agent X3 -> auto___def_26 X1 -> auto___type_2 X4 -> auto___type_7 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X4 X2 X3.
  cut (auto___def_26 X1 -> auto___def_5 X2 -> auto___type_2 X3 -> auto___type_3 X4 -> auto_agent X4 -> auto_agent X2 -> auto___type_7 X1). tauto. exact (rem_1310 X1 X2 X3 X4).
Qed.

Remark rem_1312 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1313 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1. intros A1.
  cut (auto_knows_old X1). 2:apply (rem_1312 epsilon_mknows_old_p__type_7 X1);  assumption.
  tauto.
Defined.

Remark rem_1314 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1:term, auto_knows_old X1 -> auto___type_7 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1. intros A1.
  case (rem_1313 epsilon_mknows_old_p__type_7 X1 A1). clear  epsilon_mknows_old_p__type_7 A1. intros. apply trans___type_7_s_1;  tauto.
 clear  epsilon_mknows_old_p__type_7 A1. tauto.
Defined.

Remark rem_1315 : forall X1:term, auto_knows_old (s X1) -> or_1
    (auto_knows_old X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1316 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1:term, auto_knows_old (s X1) -> auto___type_7 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1. intro H. intros.
  elim (rem_1315 X1 H);  intros.
  apply (rem_1314 epsilon_mknows_old_p__type_7 X1);  tauto.
Defined.

Remark rem_1317 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_7.  tauto.
Defined.

Remark rem_1318 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> auto___type_7 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_7.  case (rem_1317 epsilon_mknows_old_p__type_7). clear  epsilon_mknows_old_p__type_7. intros. apply trans___type_7_nil_1;  tauto.
 clear  epsilon_mknows_old_p__type_7. tauto.
Defined.

Remark rem_1319 : auto_knows_old nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1320 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> auto_knows_old nil -> auto___type_7 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intro H. intros.
  elim (rem_1319 H);  intros.
  apply (rem_1318 epsilon_mknows_old_p__type_7);  tauto.
Defined.

Remark rem_1321 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> auto___type_7 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_7.  case (rem_1317 epsilon_mknows_old_p__type_7). clear  epsilon_mknows_old_p__type_7. intros. apply trans___type_7_i_1;  tauto.
 clear  epsilon_mknows_old_p__type_7. tauto.
Defined.

Remark rem_1322 : auto_knows_old i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1323 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> auto_knows_old i -> auto___type_7 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intro H. intros.
  elim (rem_1322 H);  intros.
  apply (rem_1321 epsilon_mknows_old_p__type_7);  tauto.
Defined.

Remark rem_1324 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2.
  cut (auto_knows_old X1 -> auto_knows_old X1). tauto. exact (rem_1312 epsilon_mknows_old_p__type_7 X1).
Defined.

Remark rem_1325 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X2:term, auto_knows_old X2 -> auto_knows_old X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1326 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_1325 epsilon_mknows_old_p__type_7 X2).
Defined.

Remark rem_1327 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> (auto_knows_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_1324 epsilon_mknows_old_p__type_7 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_1326 epsilon_mknows_old_p__type_7 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1328 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_7 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2. intros A1 A2.
  case (rem_1327 epsilon_mknows_old_p__type_7 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_7 A1 A2. intros. apply trans___type_7_cons_1;  tauto.
 clear  epsilon_mknows_old_p__type_7 A1 A2. tauto.
Defined.

Remark rem_1329 : forall X1 X2:term, auto_knows_old (cons X1 X2) -> or_1
    (auto_knows_old X1 /\ auto_knows_old X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1330 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto_knows_old (cons X1 X2) -> auto___type_7 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2. intro H. intros.
  elim (rem_1329 X1 X2 H);  intros.
  apply (rem_1328 epsilon_mknows_old_p__type_7 X1 X2);  tauto.
Defined.

Remark rem_1331 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1:term, auto___def_32 X1 -> auto___def_32 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1332 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_2 X2 -> auto___def_32 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2.
  cut (auto___def_32 X1 -> auto___def_32 X1). tauto. exact (rem_1331 epsilon_mknows_old_p__type_7 X1).
Defined.

Remark rem_1333 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X2:term, auto___type_2 X2 -> auto___type_2 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1334 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_2 X2 -> auto___type_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2.
  cut (auto___type_2 X2 -> auto___type_2 X2). tauto. exact (rem_1333 epsilon_mknows_old_p__type_7 X2).
Defined.

Remark rem_1335 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_2 X2 -> (auto___def_32 X1 /\ auto___type_2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2. intros A1 A2.
  cut (auto___def_32 X1). 2:apply (rem_1332 epsilon_mknows_old_p__type_7 X1 X2);  assumption.
  cut (auto___type_2 X2). 2:apply (rem_1334 epsilon_mknows_old_p__type_7 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1336 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_2 X2 -> auto___type_7 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2. intros A1 A2.
  case (rem_1335 epsilon_mknows_old_p__type_7 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_7 A1 A2. intros. apply trans___type_7_crypt_1;  tauto.
 clear  epsilon_mknows_old_p__type_7 A1 A2. tauto.
Defined.

Remark rem_1337 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1:term, auto___def_25 X1 -> auto___def_25 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1338 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_25 X1 -> auto___type_4 X2 -> auto___def_25 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2.
  cut (auto___def_25 X1 -> auto___def_25 X1). tauto. exact (rem_1337 epsilon_mknows_old_p__type_7 X1).
Defined.

Remark rem_1339 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X2:term, auto___type_4 X2 -> auto___type_4 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1340 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_25 X1 -> auto___type_4 X2 -> auto___type_4 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2.
  cut (auto___type_4 X2 -> auto___type_4 X2). tauto. exact (rem_1339 epsilon_mknows_old_p__type_7 X2).
Defined.

Remark rem_1341 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_25 X1 -> auto___type_4 X2 -> (auto___def_25 X1 /\ auto___type_4 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2. intros A1 A2.
  cut (auto___def_25 X1). 2:apply (rem_1338 epsilon_mknows_old_p__type_7 X1 X2);  assumption.
  cut (auto___type_4 X2). 2:apply (rem_1340 epsilon_mknows_old_p__type_7 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1342 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_25 X1 -> auto___type_4 X2 -> auto___type_7 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2. intros A1 A2.
  case (rem_1341 epsilon_mknows_old_p__type_7 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_7 A1 A2. intros. apply trans___type_7_crypt_2;  tauto.
 clear  epsilon_mknows_old_p__type_7 A1 A2. tauto.
Defined.

Remark rem_1343 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1:term, auto___def_19 X1 -> auto___def_19 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1344 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto___def_19 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2.
  cut (auto___def_19 X1 -> auto___def_19 X1). tauto. exact (rem_1343 epsilon_mknows_old_p__type_7 X1).
Defined.

Remark rem_1345 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X2:term, auto___def_20 X2 -> auto___def_20 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1346 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto___def_20 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2.
  cut (auto___def_20 X2 -> auto___def_20 X2). tauto. exact (rem_1345 epsilon_mknows_old_p__type_7 X2).
Defined.

Remark rem_1347 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> (auto___def_19 X1 /\ auto___def_20 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2. intros A1 A2.
  cut (auto___def_19 X1). 2:apply (rem_1344 epsilon_mknows_old_p__type_7 X1 X2);  assumption.
  cut (auto___def_20 X2). 2:apply (rem_1346 epsilon_mknows_old_p__type_7 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1348 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto___type_7 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2. intros A1 A2.
  case (rem_1347 epsilon_mknows_old_p__type_7 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_7 A1 A2. intros. apply trans___type_7_crypt_3;  tauto.
 clear  epsilon_mknows_old_p__type_7 A1 A2. tauto.
Defined.

Remark rem_1349 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_7 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2. intros A1 A2.
  case (rem_1327 epsilon_mknows_old_p__type_7 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_7 A1 A2. intros. apply trans___type_7_crypt_4;  tauto.
 clear  epsilon_mknows_old_p__type_7 A1 A2. tauto.
Defined.

Remark rem_1350 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1:term, auto___def_30 X1 -> auto___def_30 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1351 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___type_6 X2 -> auto___def_30 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2.
  cut (auto___def_30 X1 -> auto___def_30 X1). tauto. exact (rem_1350 epsilon_mknows_old_p__type_7 X1).
Defined.

Remark rem_1352 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X2:term, auto___type_6 X2 -> auto___type_6 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1353 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___type_6 X2 -> auto___type_6 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2.
  cut (auto___type_6 X2 -> auto___type_6 X2). tauto. exact (rem_1352 epsilon_mknows_old_p__type_7 X2).
Defined.

Remark rem_1354 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___type_6 X2 -> (auto___def_30 X1 /\ auto___type_6 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2. intros A1 A2.
  cut (auto___def_30 X1). 2:apply (rem_1351 epsilon_mknows_old_p__type_7 X1 X2);  assumption.
  cut (auto___type_6 X2). 2:apply (rem_1353 epsilon_mknows_old_p__type_7 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1355 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___type_6 X2 -> auto___type_7 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2. intros A1 A2.
  case (rem_1354 epsilon_mknows_old_p__type_7 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_7 A1 A2. intros. apply trans___type_7_crypt_5;  tauto.
 clear  epsilon_mknows_old_p__type_7 A1 A2. tauto.
Defined.

Remark rem_1356 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto_knows_old (crypt X1 X2) -> auto___type_7 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2. intro H. intros.
  elim (rem_182 X1 X2 H);  intros.
  apply (rem_1336 epsilon_mknows_old_p__type_7 X1 X2);  tauto.
  apply (rem_1342 epsilon_mknows_old_p__type_7 X1 X2);  tauto.
  apply (rem_1348 epsilon_mknows_old_p__type_7 X1 X2);  tauto.
  apply (rem_1349 epsilon_mknows_old_p__type_7 X1 X2);  tauto.
  apply (rem_1355 epsilon_mknows_old_p__type_7 X1 X2);  tauto.
Defined.

Remark rem_1357 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1:term, auto___def_23 X1 -> auto___def_23 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1358 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_36 X2 -> auto___def_23 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2.
  cut (auto___def_23 X1 -> auto___def_23 X1). tauto. exact (rem_1357 epsilon_mknows_old_p__type_7 X1).
Defined.

Remark rem_1359 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X2:term, auto___def_36 X2 -> auto___def_36 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1360 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_36 X2 -> auto___def_36 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2.
  cut (auto___def_36 X2 -> auto___def_36 X2). tauto. exact (rem_1359 epsilon_mknows_old_p__type_7 X2).
Defined.

Remark rem_1361 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_36 X2 -> (auto___def_23 X1 /\ auto___def_36 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2. intros A1 A2.
  cut (auto___def_23 X1). 2:apply (rem_1358 epsilon_mknows_old_p__type_7 X1 X2);  assumption.
  cut (auto___def_36 X2). 2:apply (rem_1360 epsilon_mknows_old_p__type_7 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1362 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_36 X2 -> auto___type_7 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2. intros A1 A2.
  case (rem_1361 epsilon_mknows_old_p__type_7 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_7 A1 A2. intros. apply trans___type_7_key_1;  tauto.
 clear  epsilon_mknows_old_p__type_7 A1 A2. tauto.
Defined.

Remark rem_1363 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1:term, auto___def_3 X1 -> auto___def_3 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1364 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___type_9 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_1363 epsilon_mknows_old_p__type_7 X1).
Defined.

Remark rem_1365 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X2:term, auto___type_9 X2 -> auto___type_9 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1366 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___type_9 X2 -> auto___type_9 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2.
  cut (auto___type_9 X2 -> auto___type_9 X2). tauto. exact (rem_1365 epsilon_mknows_old_p__type_7 X2).
Defined.

Remark rem_1367 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___type_9 X2 -> (auto___def_3 X1 /\ auto___type_9 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_1364 epsilon_mknows_old_p__type_7 X1 X2);  assumption.
  cut (auto___type_9 X2). 2:apply (rem_1366 epsilon_mknows_old_p__type_7 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1368 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___type_9 X2 -> auto___type_7 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2. intros A1 A2.
  case (rem_1367 epsilon_mknows_old_p__type_7 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_7 A1 A2. intros. apply trans___type_7_key_2;  tauto.
 clear  epsilon_mknows_old_p__type_7 A1 A2. tauto.
Defined.

Remark rem_1369 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> forall X1 X2:term, auto_knows_old (key X1 X2) -> auto___type_7 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intros X1 X2. intro H. intros.
  elim (rem_172 X1 X2 H);  intros.
  apply (rem_1362 epsilon_mknows_old_p__type_7 X1 X2);  tauto.
  apply (rem_1368 epsilon_mknows_old_p__type_7 X1 X2);  tauto.
Defined.

Remark rem_1370 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> auto___type_7 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_7.  case (rem_1317 epsilon_mknows_old_p__type_7). clear  epsilon_mknows_old_p__type_7. intros. apply trans___type_7_bob_1;  tauto.
 clear  epsilon_mknows_old_p__type_7. tauto.
Defined.

Remark rem_1371 : auto_knows_old bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1372 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> auto_knows_old bob -> auto___type_7 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intro H. intros.
  elim (rem_1371 H);  intros.
  apply (rem_1370 epsilon_mknows_old_p__type_7);  tauto.
Defined.

Remark rem_1373 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> auto___type_7 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_7.  case (rem_1317 epsilon_mknows_old_p__type_7). clear  epsilon_mknows_old_p__type_7. intros. apply trans___type_7_alice_1;  tauto.
 clear  epsilon_mknows_old_p__type_7. tauto.
Defined.

Remark rem_1374 : auto_knows_old alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1375 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> auto_knows_old alice -> auto___type_7 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intro H. intros.
  elim (rem_1374 H);  intros.
  apply (rem_1373 epsilon_mknows_old_p__type_7);  tauto.
Defined.

Remark rem_1376 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> auto___type_7 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_7.  case (rem_1317 epsilon_mknows_old_p__type_7). clear  epsilon_mknows_old_p__type_7. intros. apply trans___type_7_server_1;  tauto.
 clear  epsilon_mknows_old_p__type_7. tauto.
Defined.

Remark rem_1377 : auto_knows_old server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1378 : (forall X:term, auto_knows_old X -> auto___type_7 X)
    -> auto_knows_old server -> auto___type_7 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_7. intro H. intros.
  elim (rem_1377 H);  intros.
  apply (rem_1376 epsilon_mknows_old_p__type_7);  tauto.
Defined.

Remark rem_1379 : forall X1 X2 X3:term, auto_knows_old (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1380 : auto_knows_old sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1381 : forall X1 X2 X3:term, auto_knows_old (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1382 : forall X1 X2 X3:term, auto_knows_old (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1383 : forall X1 X2 X3 X4:term, auto_knows_old (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1384 : auto_knows_old pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1385 : forall X1 X2 X3 X4:term, auto_knows_old (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1386 : auto_knows_old intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1387 : auto_knows_old prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1388 : forall X1:term, auto_knows_old X1 -> auto___type_7 X1. (* Induct. *)
Proof.
  fix epsilon_mknows_old_p__type_7 1.
  intro X. case X.
  exact (rem_1375 epsilon_mknows_old_p__type_7 ).
  exact (rem_1372 epsilon_mknows_old_p__type_7 ).
  intros X1 X2;  exact (rem_1330 epsilon_mknows_old_p__type_7 X1 X2).
  intros X1 X2;  exact (rem_1356 epsilon_mknows_old_p__type_7 X1 X2).
  exact (rem_1323 epsilon_mknows_old_p__type_7 ).
   intro H. elim (rem_1386  H).
  intros X1 X2;  exact (rem_1369 epsilon_mknows_old_p__type_7 X1 X2).
  exact (rem_1320 epsilon_mknows_old_p__type_7 ).
  intros X1 X2 X3. intro H. elim (rem_1381 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1382 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1385 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1383 X1 X2 X3 X4 H).
   intro H. elim (rem_1387  H).
   intro H. elim (rem_1384  H).
  intros X1;  exact (rem_1316 epsilon_mknows_old_p__type_7 X1).
  exact (rem_1378 epsilon_mknows_old_p__type_7 ).
  intros X1 X2 X3. intro H. elim (rem_1379 X1 X2 X3 H).
   intro H. elim (rem_1380  H).
Qed.

Remark rem_1389 : forall X1 X2 X3 X4:term, auto___type_2 X2 -> auto___type_3 X3 -> auto___type_9 X4 -> auto_agent X4 -> auto_knows_old X1 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old X1 -> auto___type_7 X1). tauto. exact (rem_1388 X1).
Qed.

Remark rem_1390 : forall X1 X2 X3 X4:term, auto___type_3 X2 -> auto___type_9 X3 -> auto_agent X3 -> auto_knows_old X1 -> auto___type_2 X4 -> auto___type_7 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X3 X4 X2.
  cut (auto___type_2 X2 -> auto___type_3 X3 -> auto___type_9 X4 -> auto_agent X4 -> auto_knows_old X1 -> auto___type_7 X1). tauto. exact (rem_1389 X1 X2 X3 X4).
Qed.

Remark rem_1391 : forall X1 X2 X3 X4:term, auto___def_26 X1 -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X4 -> auto_agent X4 -> auto_agent X2 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_26 X1 -> auto___type_7 X1). tauto. exact (rem_1309 X1).
Qed.

Remark rem_1392 : forall X1 X2 X3 X4:term, auto___type_3 X2 -> auto_agent X2 -> auto___def_7 X3 -> auto_agent X3 -> auto___def_26 X1 -> auto___type_2 X4 -> auto___type_7 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X4 X2 X3.
  cut (auto___def_26 X1 -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X4 -> auto_agent X4 -> auto_agent X2 -> auto___type_7 X1). tauto. exact (rem_1391 X1 X2 X3 X4).
Qed.

Remark rem_1393 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_26 X1 -> auto___type_2 X3 -> auto___type_3 X4 -> auto_agent X4 -> auto_agent X2 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_26 X1 -> auto___type_7 X1). tauto. exact (rem_1309 X1).
Qed.

Remark rem_1394 : forall X1 X2 X3 X4:term, auto___type_3 X2 -> auto_agent X2 -> auto_agent X3 -> auto___def_2 X3 -> auto___def_26 X1 -> auto___type_2 X4 -> auto___type_7 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X4 X2 X3.
  cut (auto___def_2 X2 -> auto___def_26 X1 -> auto___type_2 X3 -> auto___type_3 X4 -> auto_agent X4 -> auto_agent X2 -> auto___type_7 X1). tauto. exact (rem_1393 X1 X2 X3 X4).
Qed.

Remark rem_1395 : forall X1 X2 X3 X4:term, auto___def_29 X2 X3 X1 X4 -> auto___type_7 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1280 X2 X3 X1 X4 H);  intros.
  apply (rem_1311 X1 X2 X3 X4);  tauto.
  apply (rem_1390 X1 X2 X3 X4);  tauto.
  apply (rem_1392 X1 X2 X3 X4);  tauto.
  apply (rem_1394 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1396 : forall X1:term, auto_knows_old (key pub X1) -> auto___def_13 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___def_13_1. Qed.

Remark rem_1397 : forall X1 X2:term, auto___def_2 X1 -> auto___def_3 pub -> auto___def_32 X2 -> auto___def_2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_2 X1 -> auto___def_2 X1). tauto. exact (rem_866 X1).
Qed.

Remark rem_1398 : forall X2:term, auto___def_32 X2 -> auto___def_32 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1399 : forall X1 X2:term, auto___def_2 X1 -> auto___def_3 pub -> auto___def_32 X2 -> auto___def_32 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_32 X2 -> auto___def_32 X2). tauto. exact (rem_1398 X2).
Qed.

Remark rem_1400 : forall X1 X2:term, auto___def_2 X1 -> auto___def_3 pub -> auto___def_32 X2 -> (auto___def_2 X1 /\ auto___def_32 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_2 X1). 2:apply (rem_1397 X1 X2);  assumption.
  cut (auto___def_32 X2). 2:apply (rem_1399 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1401 : forall X1 X2:term, auto___def_2 X1 -> auto___def_3 pub -> auto___def_32 X2 -> auto___def_10 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1400 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_10_9;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1402 : forall X1 X2:term, auto___def_3 pub -> auto___def_2 X1 -> auto___def_32 X2 -> auto___def_10 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_2 X1 -> auto___def_3 pub -> auto___def_32 X2 -> auto___def_10 X1 X2). tauto. exact (rem_1401 X1 X2).
Qed.

Remark rem_1403 : forall X1 X2:term, auto___def_3 pub -> auto___def_32 X2 -> auto___def_5 X1 -> auto___def_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_5 X1 -> auto___def_5 X1). tauto. exact (rem_889 X1).
Qed.

Remark rem_1404 : forall X1 X2:term, auto___def_3 pub -> auto___def_32 X2 -> auto___def_5 X1 -> auto___def_32 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_32 X2 -> auto___def_32 X2). tauto. exact (rem_1398 X2).
Qed.

Remark rem_1405 : forall X1 X2:term, auto___def_3 pub -> auto___def_32 X2 -> auto___def_5 X1 -> (auto___def_5 X1 /\ auto___def_32 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_5 X1). 2:apply (rem_1403 X1 X2);  assumption.
  cut (auto___def_32 X2). 2:apply (rem_1404 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1406 : forall X1 X2:term, auto___def_3 pub -> auto___def_32 X2 -> auto___def_5 X1 -> auto___def_10 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1405 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_10_2;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1407 : forall X1 X2:term, auto___def_3 pub -> auto___def_5 X1 -> auto___def_32 X2 -> auto___def_10 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_3 pub -> auto___def_32 X2 -> auto___def_5 X1 -> auto___def_10 X1 X2). tauto. exact (rem_1406 X1 X2).
Qed.

Remark rem_1408 : forall X1 X2:term, auto___def_3 pub -> auto___def_32 X2 -> auto___def_7 X1 -> auto___def_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_7 X1 -> auto___def_7 X1). tauto. exact (rem_155 X1).
Qed.

Remark rem_1409 : forall X1 X2:term, auto___def_3 pub -> auto___def_32 X2 -> auto___def_7 X1 -> auto___def_32 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_32 X2 -> auto___def_32 X2). tauto. exact (rem_1398 X2).
Qed.

Remark rem_1410 : forall X1 X2:term, auto___def_3 pub -> auto___def_32 X2 -> auto___def_7 X1 -> (auto___def_7 X1 /\ auto___def_32 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_7 X1). 2:apply (rem_1408 X1 X2);  assumption.
  cut (auto___def_32 X2). 2:apply (rem_1409 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1411 : forall X1 X2:term, auto___def_3 pub -> auto___def_32 X2 -> auto___def_7 X1 -> auto___def_10 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1410 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_10_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1412 : forall X1 X2:term, auto___def_3 pub -> auto___def_7 X1 -> auto___def_32 X2 -> auto___def_10 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_3 pub -> auto___def_32 X2 -> auto___def_7 X1 -> auto___def_10 X1 X2). tauto. exact (rem_1411 X1 X2).
Qed.

Remark rem_1413 : forall X1 X2:term, auto___def_32 X2 -> auto___type_2 (key pub X1) -> auto___def_10 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_145 pub X1 H);  intros.
  apply (rem_1402 X1 X2);  tauto.
  apply (rem_1407 X1 X2);  tauto.
  apply (rem_1412 X1 X2);  tauto.
Qed.

Remark rem_1414 : forall X1 X2:term, auto___def_2 X1 -> auto___def_25 X2 -> auto___def_3 pub -> auto___def_2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_2 X1 -> auto___def_2 X1). tauto. exact (rem_866 X1).
Qed.

Remark rem_1415 : forall X2:term, auto___def_25 X2 -> auto___def_25 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1416 : forall X1 X2:term, auto___def_2 X1 -> auto___def_25 X2 -> auto___def_3 pub -> auto___def_25 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_25 X2 -> auto___def_25 X2). tauto. exact (rem_1415 X2).
Qed.

Remark rem_1417 : forall X1 X2:term, auto___def_2 X1 -> auto___def_25 X2 -> auto___def_3 pub -> (auto___def_2 X1 /\ auto___def_25 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_2 X1). 2:apply (rem_1414 X1 X2);  assumption.
  cut (auto___def_25 X2). 2:apply (rem_1416 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1418 : forall X1 X2:term, auto___def_2 X1 -> auto___def_25 X2 -> auto___def_3 pub -> auto___def_10 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1417 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_10_4;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1419 : forall X1 X2:term, auto___def_3 pub -> auto___def_2 X1 -> auto___def_25 X2 -> auto___def_10 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_2 X1 -> auto___def_25 X2 -> auto___def_3 pub -> auto___def_10 X1 X2). tauto. exact (rem_1418 X1 X2).
Qed.

Remark rem_1420 : forall X1 X2:term, auto___def_25 X2 -> auto___def_3 pub -> auto___def_5 X1 -> auto___def_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_5 X1 -> auto___def_5 X1). tauto. exact (rem_889 X1).
Qed.

Remark rem_1421 : forall X1 X2:term, auto___def_25 X2 -> auto___def_3 pub -> auto___def_5 X1 -> auto___def_25 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_25 X2 -> auto___def_25 X2). tauto. exact (rem_1415 X2).
Qed.

Remark rem_1422 : forall X1 X2:term, auto___def_25 X2 -> auto___def_3 pub -> auto___def_5 X1 -> (auto___def_5 X1 /\ auto___def_25 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_5 X1). 2:apply (rem_1420 X1 X2);  assumption.
  cut (auto___def_25 X2). 2:apply (rem_1421 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1423 : forall X1 X2:term, auto___def_25 X2 -> auto___def_3 pub -> auto___def_5 X1 -> auto___def_10 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1422 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_10_6;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1424 : forall X1 X2:term, auto___def_3 pub -> auto___def_5 X1 -> auto___def_25 X2 -> auto___def_10 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_25 X2 -> auto___def_3 pub -> auto___def_5 X1 -> auto___def_10 X1 X2). tauto. exact (rem_1423 X1 X2).
Qed.

Remark rem_1425 : forall X1 X2:term, auto___def_25 X2 -> auto___def_3 pub -> auto___def_7 X1 -> auto___def_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_7 X1 -> auto___def_7 X1). tauto. exact (rem_155 X1).
Qed.

Remark rem_1426 : forall X1 X2:term, auto___def_25 X2 -> auto___def_3 pub -> auto___def_7 X1 -> auto___def_25 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_25 X2 -> auto___def_25 X2). tauto. exact (rem_1415 X2).
Qed.

Remark rem_1427 : forall X1 X2:term, auto___def_25 X2 -> auto___def_3 pub -> auto___def_7 X1 -> (auto___def_7 X1 /\ auto___def_25 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_7 X1). 2:apply (rem_1425 X1 X2);  assumption.
  cut (auto___def_25 X2). 2:apply (rem_1426 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1428 : forall X1 X2:term, auto___def_25 X2 -> auto___def_3 pub -> auto___def_7 X1 -> auto___def_10 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1427 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_10_8;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1429 : forall X1 X2:term, auto___def_3 pub -> auto___def_7 X1 -> auto___def_25 X2 -> auto___def_10 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_25 X2 -> auto___def_3 pub -> auto___def_7 X1 -> auto___def_10 X1 X2). tauto. exact (rem_1428 X1 X2).
Qed.

Remark rem_1430 : forall X1 X2:term, auto___def_25 X2 -> auto___type_4 (key pub X1) -> auto___def_10 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_153 pub X1 H);  intros.
  apply (rem_1419 X1 X2);  tauto.
  apply (rem_1424 X1 X2);  tauto.
  apply (rem_1429 X1 X2);  tauto.
Qed.

Remark rem_1431 : forall X1 X2:term, auto___def_19 X2 -> auto___def_20 (key pub X1) -> auto___type_9 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Qed.

Remark rem_1432 : (forall X:term, auto___type_2 X -> auto_knows_old X)
    -> forall X1:term, auto___def_3 X1 -> auto___def_3 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1433 : (forall X:term, auto___type_2 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_pknows_old. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_1432 epsilon_m__type_2_pknows_old X1).
Defined.

Remark rem_1434 : (forall X:term, auto___type_2 X -> auto_knows_old X)
    -> forall X2:term, auto___def_2 X2 -> auto___type_9 X2. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Defined.

Remark rem_1435 : (forall X:term, auto___type_2 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___type_9 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_pknows_old. intros X1 X2.
  cut (auto___def_2 X2 -> auto___type_9 X2). tauto. exact (rem_1434 epsilon_m__type_2_pknows_old X2).
Defined.

Remark rem_1436 : (forall X:term, auto___type_2 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> (auto___def_3 X1 /\ auto___type_9 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_2_pknows_old. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_1433 epsilon_m__type_2_pknows_old X1 X2);  assumption.
  cut (auto___type_9 X2). 2:apply (rem_1435 epsilon_m__type_2_pknows_old X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1437 : (forall X:term, auto___type_2 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto_knows_old (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_pknows_old. intros X1 X2. intros A1 A2.
  case (rem_1436 epsilon_m__type_2_pknows_old X1 X2 A1 A2). clear  epsilon_m__type_2_pknows_old A1 A2. intros. apply trans_knows_old_key_2;  tauto.
 clear  epsilon_m__type_2_pknows_old A1 A2. tauto.
Defined.

Remark rem_1438 : (forall X:term, auto___type_2 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_pknows_old. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_1432 epsilon_m__type_2_pknows_old X1).
Defined.

Remark rem_1439 : (forall X:term, auto___type_2 X -> auto_knows_old X)
    -> forall X2:term, auto___def_5 X2 -> auto___type_9 X2. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Defined.

Remark rem_1440 : (forall X:term, auto___type_2 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___type_9 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_pknows_old. intros X1 X2.
  cut (auto___def_5 X2 -> auto___type_9 X2). tauto. exact (rem_1439 epsilon_m__type_2_pknows_old X2).
Defined.

Remark rem_1441 : (forall X:term, auto___type_2 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> (auto___def_3 X1 /\ auto___type_9 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_2_pknows_old. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_1438 epsilon_m__type_2_pknows_old X1 X2);  assumption.
  cut (auto___type_9 X2). 2:apply (rem_1440 epsilon_m__type_2_pknows_old X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1442 : (forall X:term, auto___type_2 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto_knows_old (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_pknows_old. intros X1 X2. intros A1 A2.
  case (rem_1441 epsilon_m__type_2_pknows_old X1 X2 A1 A2). clear  epsilon_m__type_2_pknows_old A1 A2. intros. apply trans_knows_old_key_2;  tauto.
 clear  epsilon_m__type_2_pknows_old A1 A2. tauto.
Defined.

Remark rem_1443 : (forall X:term, auto___type_2 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_pknows_old. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_1432 epsilon_m__type_2_pknows_old X1).
Defined.

Remark rem_1444 : (forall X:term, auto___type_2 X -> auto_knows_old X)
    -> forall X2:term, auto___def_7 X2 -> auto___type_9 X2. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Defined.

Remark rem_1445 : (forall X:term, auto___type_2 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___type_9 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_pknows_old. intros X1 X2.
  cut (auto___def_7 X2 -> auto___type_9 X2). tauto. exact (rem_1444 epsilon_m__type_2_pknows_old X2).
Defined.

Remark rem_1446 : (forall X:term, auto___type_2 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> (auto___def_3 X1 /\ auto___type_9 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_2_pknows_old. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_1443 epsilon_m__type_2_pknows_old X1 X2);  assumption.
  cut (auto___type_9 X2). 2:apply (rem_1445 epsilon_m__type_2_pknows_old X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1447 : (forall X:term, auto___type_2 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto_knows_old (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_pknows_old. intros X1 X2. intros A1 A2.
  case (rem_1446 epsilon_m__type_2_pknows_old X1 X2 A1 A2). clear  epsilon_m__type_2_pknows_old A1 A2. intros. apply trans_knows_old_key_2;  tauto.
 clear  epsilon_m__type_2_pknows_old A1 A2. tauto.
Defined.

Remark rem_1448 : (forall X:term, auto___type_2 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___type_2 (key X1 X2) -> auto_knows_old (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_2_pknows_old. intros X1 X2. intro H. intros.
  elim (rem_145 X1 X2 H);  intros.
  apply (rem_1437 epsilon_m__type_2_pknows_old X1 X2);  tauto.
  apply (rem_1442 epsilon_m__type_2_pknows_old X1 X2);  tauto.
  apply (rem_1447 epsilon_m__type_2_pknows_old X1 X2);  tauto.
Defined.

Remark rem_1449 : forall X1:term, auto___type_2 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1450 : auto___type_2 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1451 : auto___type_2 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1452 : forall X1 X2 X3:term, auto___type_2 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1453 : auto___type_2 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1454 : forall X1 X2 X3:term, auto___type_2 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1455 : forall X1 X2:term, auto___type_2 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1456 : forall X1 X2:term, auto___type_2 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1457 : auto___type_2 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1458 : forall X1 X2 X3:term, auto___type_2 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1459 : auto___type_2 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1460 : forall X1 X2 X3 X4:term, auto___type_2 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1461 : auto___type_2 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1462 : forall X1 X2 X3 X4:term, auto___type_2 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1463 : auto___type_2 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1464 : auto___type_2 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1465 : auto___type_2 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1466 : forall X1:term, auto___type_2 X1 -> auto_knows_old X1. (* Induct. *)
Proof.
  fix epsilon_m__type_2_pknows_old 1.
  intro X. case X.
   intro H. elim (rem_1459  H).
   intro H. elim (rem_1457  H).
  intros X1 X2. intro H. elim (rem_1455 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1456 X1 X2 H).
   intro H. elim (rem_1451  H).
   intro H. elim (rem_1463  H).
  intros X1 X2;  exact (rem_1448 epsilon_m__type_2_pknows_old X1 X2).
   intro H. elim (rem_1450  H).
  intros X1 X2 X3. intro H. elim (rem_1454 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1458 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1462 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1460 X1 X2 X3 X4 H).
   intro H. elim (rem_1465  H).
   intro H. elim (rem_1461  H).
  intros X1. intro H. elim (rem_1449 X1 H).
   intro H. elim (rem_1464  H).
  intros X1 X2 X3. intro H. elim (rem_1452 X1 X2 X3 H).
   intro H. elim (rem_1453  H).
Qed.

Remark rem_1467 : (forall X:term, auto___def_19 X -> auto_knows_old X)
    -> forall X1:term, auto___type_2 X1 -> auto_knows_old X1. (* Cut history. *)
Proof.  intros epsilon_m__def_19_pknows_old. exact (rem_1466).
Defined.

Remark rem_1468 : (forall X:term, auto___def_19 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___type_2 X1 -> auto___def_21 X2 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_19_pknows_old. intros X1 X2.
  cut (auto___type_2 X1 -> auto_knows_old X1). tauto. exact (rem_1467 epsilon_m__def_19_pknows_old X1).
Defined.

Remark rem_1469 : (forall X:term, auto___type_3 X -> auto_knows_old X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pknows_old.  tauto.
Defined.

Remark rem_1470 : (forall X:term, auto___type_3 X -> auto_knows_old X)
    -> auto_knows_old bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows_old.  case (rem_1469 epsilon_m__type_3_pknows_old). clear  epsilon_m__type_3_pknows_old. intros. apply trans_knows_old_bob_1;  tauto.
 clear  epsilon_m__type_3_pknows_old. tauto.
Defined.

Remark rem_1471 : (forall X:term, auto___type_3 X -> auto_knows_old X)
    -> auto___type_3 bob -> auto_knows_old bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows_old. intro H. intros.
  elim (rem_369 H);  intros.
  apply (rem_1470 epsilon_m__type_3_pknows_old);  tauto.
Defined.

Remark rem_1472 : (forall X:term, auto___type_3 X -> auto_knows_old X)
    -> auto_knows_old alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows_old.  case (rem_1469 epsilon_m__type_3_pknows_old). clear  epsilon_m__type_3_pknows_old. intros. apply trans_knows_old_alice_1;  tauto.
 clear  epsilon_m__type_3_pknows_old. tauto.
Defined.

Remark rem_1473 : (forall X:term, auto___type_3 X -> auto_knows_old X)
    -> auto___type_3 alice -> auto_knows_old alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows_old. intro H. intros.
  elim (rem_372 H);  intros.
  apply (rem_1472 epsilon_m__type_3_pknows_old);  tauto.
Defined.

Remark rem_1474 : (forall X:term, auto___type_3 X -> auto_knows_old X)
    -> auto_knows_old server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows_old.  case (rem_1469 epsilon_m__type_3_pknows_old). clear  epsilon_m__type_3_pknows_old. intros. apply trans_knows_old_server_1;  tauto.
 clear  epsilon_m__type_3_pknows_old. tauto.
Defined.

Remark rem_1475 : (forall X:term, auto___type_3 X -> auto_knows_old X)
    -> auto___type_3 server -> auto_knows_old server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows_old. intro H. intros.
  elim (rem_375 H);  intros.
  apply (rem_1474 epsilon_m__type_3_pknows_old);  tauto.
Defined.

Remark rem_1476 : forall X1:term, auto___type_3 X1 -> auto_knows_old X1. (* Induct. *)
Proof.
  fix epsilon_m__type_3_pknows_old 1.
  intro X. case X.
  exact (rem_1473 epsilon_m__type_3_pknows_old ).
  exact (rem_1471 epsilon_m__type_3_pknows_old ).
  intros X1 X2. intro H. elim (rem_383 X1 X2 H).
  intros X1 X2. intro H. elim (rem_384 X1 X2 H).
   intro H. elim (rem_379  H).
   intro H. elim (rem_390  H).
  intros X1 X2. intro H. elim (rem_385 X1 X2 H).
   intro H. elim (rem_378  H).
  intros X1 X2 X3. intro H. elim (rem_382 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_386 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_389 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_387 X1 X2 X3 X4 H).
   intro H. elim (rem_391  H).
   intro H. elim (rem_388  H).
  intros X1. intro H. elim (rem_377 X1 H).
  exact (rem_1475 epsilon_m__type_3_pknows_old ).
  intros X1 X2 X3. intro H. elim (rem_380 X1 X2 X3 H).
   intro H. elim (rem_381  H).
Qed.

Remark rem_1477 : (forall X:term, auto___def_21 X -> auto_knows_old X)
    -> forall X1:term, auto___type_3 X1 -> auto_knows_old X1. (* Cut history. *)
Proof.  intros epsilon_m__def_21_pknows_old. exact (rem_1476).
Defined.

Remark rem_1478 : (forall X:term, auto___def_21 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___type_3 X1 -> auto___def_22 X2 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_21_pknows_old. intros X1 X2.
  cut (auto___type_3 X1 -> auto_knows_old X1). tauto. exact (rem_1477 epsilon_m__def_21_pknows_old X1).
Defined.

Remark rem_1479 : (forall X:term, auto___def_22 X -> auto_knows_old X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_22_pknows_old.  tauto.
Defined.

Remark rem_1480 : (forall X:term, auto___def_22 X -> auto_knows_old X)
    -> auto_knows_old nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_22_pknows_old.  case (rem_1479 epsilon_m__def_22_pknows_old). clear  epsilon_m__def_22_pknows_old. intros. apply trans_knows_old_nil_1;  tauto.
 clear  epsilon_m__def_22_pknows_old. tauto.
Defined.

Remark rem_1481 : auto___def_22 nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1482 : (forall X:term, auto___def_22 X -> auto_knows_old X)
    -> auto___def_22 nil -> auto_knows_old nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_22_pknows_old. intro H. intros.
  elim (rem_1481 H);  intros.
  apply (rem_1480 epsilon_m__def_22_pknows_old);  tauto.
Defined.

Remark rem_1483 : forall X1:term, auto___def_22 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1484 : auto___def_22 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1485 : forall X1 X2 X3:term, auto___def_22 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1486 : auto___def_22 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1487 : forall X1 X2 X3:term, auto___def_22 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1488 : forall X1 X2:term, auto___def_22 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1489 : forall X1 X2:term, auto___def_22 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1490 : forall X1 X2:term, auto___def_22 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1491 : auto___def_22 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1492 : forall X1 X2 X3:term, auto___def_22 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1493 : auto___def_22 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1494 : forall X1 X2 X3 X4:term, auto___def_22 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1495 : auto___def_22 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1496 : forall X1 X2 X3 X4:term, auto___def_22 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1497 : auto___def_22 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1498 : auto___def_22 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1499 : auto___def_22 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1500 : forall X2:term, auto___def_22 X2 -> auto_knows_old X2. (* Induct. *)
Proof.
  fix epsilon_m__def_22_pknows_old 1.
  intro X. case X.
   intro H. elim (rem_1493  H).
   intro H. elim (rem_1491  H).
  intros X1 X2. intro H. elim (rem_1488 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1489 X1 X2 H).
   intro H. elim (rem_1484  H).
   intro H. elim (rem_1497  H).
  intros X1 X2. intro H. elim (rem_1490 X1 X2 H).
  exact (rem_1482 epsilon_m__def_22_pknows_old ).
  intros X1 X2 X3. intro H. elim (rem_1487 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1492 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1496 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1494 X1 X2 X3 X4 H).
   intro H. elim (rem_1499  H).
   intro H. elim (rem_1495  H).
  intros X1. intro H. elim (rem_1483 X1 H).
   intro H. elim (rem_1498  H).
  intros X1 X2 X3. intro H. elim (rem_1485 X1 X2 X3 H).
   intro H. elim (rem_1486  H).
Qed.

Remark rem_1501 : (forall X:term, auto___def_21 X -> auto_knows_old X)
    -> forall X2:term, auto___def_22 X2 -> auto_knows_old X2. (* Cut history. *)
Proof.  intros epsilon_m__def_21_pknows_old. exact (rem_1500).
Defined.

Remark rem_1502 : (forall X:term, auto___def_21 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___type_3 X1 -> auto___def_22 X2 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_21_pknows_old. intros X1 X2.
  cut (auto___def_22 X2 -> auto_knows_old X2). tauto. exact (rem_1501 epsilon_m__def_21_pknows_old X2).
Defined.

Remark rem_1503 : (forall X:term, auto___def_21 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___type_3 X1 -> auto___def_22 X2 -> (auto_knows_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_21_pknows_old. intros X1 X2. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_1478 epsilon_m__def_21_pknows_old X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_1502 epsilon_m__def_21_pknows_old X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1504 : (forall X:term, auto___def_21 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___type_3 X1 -> auto___def_22 X2 -> auto_knows_old (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_21_pknows_old. intros X1 X2. intros A1 A2.
  case (rem_1503 epsilon_m__def_21_pknows_old X1 X2 A1 A2). clear  epsilon_m__def_21_pknows_old A1 A2. intros. apply trans_knows_old_cons_1;  tauto.
 clear  epsilon_m__def_21_pknows_old A1 A2. tauto.
Defined.

Remark rem_1505 : (forall X:term, auto___def_21 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_21 (cons X1 X2) -> auto_knows_old (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_21_pknows_old. intros X1 X2. intro H. intros.
  elim (rem_206 X1 X2 H);  intros.
  apply (rem_1504 epsilon_m__def_21_pknows_old X1 X2);  tauto.
Defined.

Remark rem_1506 : forall X1:term, auto___def_21 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1507 : auto___def_21 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1508 : auto___def_21 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1509 : forall X1 X2 X3:term, auto___def_21 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1510 : auto___def_21 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1511 : forall X1 X2 X3:term, auto___def_21 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1512 : forall X1 X2:term, auto___def_21 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1513 : forall X1 X2:term, auto___def_21 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1514 : auto___def_21 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1515 : forall X1 X2 X3:term, auto___def_21 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1516 : auto___def_21 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1517 : forall X1 X2 X3 X4:term, auto___def_21 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1518 : auto___def_21 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1519 : forall X1 X2 X3 X4:term, auto___def_21 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1520 : auto___def_21 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1521 : auto___def_21 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1522 : auto___def_21 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1523 : forall X2:term, auto___def_21 X2 -> auto_knows_old X2. (* Induct. *)
Proof.
  fix epsilon_m__def_21_pknows_old 1.
  intro X. case X.
   intro H. elim (rem_1516  H).
   intro H. elim (rem_1514  H).
  intros X1 X2;  exact (rem_1505 epsilon_m__def_21_pknows_old X1 X2).
  intros X1 X2. intro H. elim (rem_1512 X1 X2 H).
   intro H. elim (rem_1508  H).
   intro H. elim (rem_1520  H).
  intros X1 X2. intro H. elim (rem_1513 X1 X2 H).
   intro H. elim (rem_1507  H).
  intros X1 X2 X3. intro H. elim (rem_1511 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1515 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1519 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1517 X1 X2 X3 X4 H).
   intro H. elim (rem_1522  H).
   intro H. elim (rem_1518  H).
  intros X1. intro H. elim (rem_1506 X1 H).
   intro H. elim (rem_1521  H).
  intros X1 X2 X3. intro H. elim (rem_1509 X1 X2 X3 H).
   intro H. elim (rem_1510  H).
Qed.

Remark rem_1524 : (forall X:term, auto___def_19 X -> auto_knows_old X)
    -> forall X2:term, auto___def_21 X2 -> auto_knows_old X2. (* Cut history. *)
Proof.  intros epsilon_m__def_19_pknows_old. exact (rem_1523).
Defined.

Remark rem_1525 : (forall X:term, auto___def_19 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___type_2 X1 -> auto___def_21 X2 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_19_pknows_old. intros X1 X2.
  cut (auto___def_21 X2 -> auto_knows_old X2). tauto. exact (rem_1524 epsilon_m__def_19_pknows_old X2).
Defined.

Remark rem_1526 : (forall X:term, auto___def_19 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___type_2 X1 -> auto___def_21 X2 -> (auto_knows_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_19_pknows_old. intros X1 X2. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_1468 epsilon_m__def_19_pknows_old X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_1525 epsilon_m__def_19_pknows_old X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1527 : (forall X:term, auto___def_19 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___type_2 X1 -> auto___def_21 X2 -> auto_knows_old (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_19_pknows_old. intros X1 X2. intros A1 A2.
  case (rem_1526 epsilon_m__def_19_pknows_old X1 X2 A1 A2). clear  epsilon_m__def_19_pknows_old A1 A2. intros. apply trans_knows_old_cons_1;  tauto.
 clear  epsilon_m__def_19_pknows_old A1 A2. tauto.
Defined.

Remark rem_1528 : (forall X:term, auto___def_19 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_19 (cons X1 X2) -> auto_knows_old (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_19_pknows_old. intros X1 X2. intro H. intros.
  elim (rem_209 X1 X2 H);  intros.
  apply (rem_1527 epsilon_m__def_19_pknows_old X1 X2);  tauto.
Defined.

Remark rem_1529 : forall X1:term, auto___def_19 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1530 : auto___def_19 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1531 : auto___def_19 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1532 : forall X1 X2 X3:term, auto___def_19 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1533 : auto___def_19 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1534 : forall X1 X2 X3:term, auto___def_19 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1535 : forall X1 X2:term, auto___def_19 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1536 : forall X1 X2:term, auto___def_19 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1537 : auto___def_19 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1538 : forall X1 X2 X3:term, auto___def_19 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1539 : auto___def_19 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1540 : forall X1 X2 X3 X4:term, auto___def_19 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1541 : auto___def_19 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1542 : forall X1 X2 X3 X4:term, auto___def_19 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1543 : auto___def_19 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1544 : auto___def_19 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1545 : auto___def_19 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1546 : forall X2:term, auto___def_19 X2 -> auto_knows_old X2. (* Induct. *)
Proof.
  fix epsilon_m__def_19_pknows_old 1.
  intro X. case X.
   intro H. elim (rem_1539  H).
   intro H. elim (rem_1537  H).
  intros X1 X2;  exact (rem_1528 epsilon_m__def_19_pknows_old X1 X2).
  intros X1 X2. intro H. elim (rem_1535 X1 X2 H).
   intro H. elim (rem_1531  H).
   intro H. elim (rem_1543  H).
  intros X1 X2. intro H. elim (rem_1536 X1 X2 H).
   intro H. elim (rem_1530  H).
  intros X1 X2 X3. intro H. elim (rem_1534 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1538 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1542 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1540 X1 X2 X3 X4 H).
   intro H. elim (rem_1545  H).
   intro H. elim (rem_1541  H).
  intros X1. intro H. elim (rem_1529 X1 H).
   intro H. elim (rem_1544  H).
  intros X1 X2 X3. intro H. elim (rem_1532 X1 X2 X3 H).
   intro H. elim (rem_1533  H).
Qed.

Remark rem_1547 : forall X1 X2:term, auto___def_19 X2 -> auto___def_20 (key pub X1) -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_19 X2 -> auto_knows_old X2). tauto. exact (rem_1546 X2).
Qed.

Remark rem_1548 : forall X1 X2:term, auto___def_19 X2 -> auto___def_20 (key pub X1) -> (auto___type_9 X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_9 X1). 2:apply (rem_1431 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_1547 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1549 : forall X1 X2:term, auto___def_19 X2 -> auto___def_20 (key pub X1) -> auto___def_10 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1548 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_10_5;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1550 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old (key pub X1) -> auto___type_9 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Qed.

Remark rem_1551 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old (key pub X1) -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_166 X2).
Qed.

Remark rem_1552 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old (key pub X1) -> (auto___type_9 X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_9 X1). 2:apply (rem_1550 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_1551 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1553 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old (key pub X1) -> auto___def_10 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1552 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_10_5;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1554 : forall X1 X2:term, auto___def_2 X1 -> auto___def_3 pub -> auto___def_30 X2 -> auto___def_2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_2 X1 -> auto___def_2 X1). tauto. exact (rem_866 X1).
Qed.

Remark rem_1555 : forall X2:term, auto___def_30 X2 -> auto___def_30 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1556 : forall X1 X2:term, auto___def_2 X1 -> auto___def_3 pub -> auto___def_30 X2 -> auto___def_30 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_30 X2 -> auto___def_30 X2). tauto. exact (rem_1555 X2).
Qed.

Remark rem_1557 : forall X1 X2:term, auto___def_2 X1 -> auto___def_3 pub -> auto___def_30 X2 -> (auto___def_2 X1 /\ auto___def_30 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_2 X1). 2:apply (rem_1554 X1 X2);  assumption.
  cut (auto___def_30 X2). 2:apply (rem_1556 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1558 : forall X1 X2:term, auto___def_2 X1 -> auto___def_3 pub -> auto___def_30 X2 -> auto___def_10 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1557 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_10_3;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1559 : forall X1 X2:term, auto___def_3 pub -> auto___def_2 X1 -> auto___def_30 X2 -> auto___def_10 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_2 X1 -> auto___def_3 pub -> auto___def_30 X2 -> auto___def_10 X1 X2). tauto. exact (rem_1558 X1 X2).
Qed.

Remark rem_1560 : forall X1 X2:term, auto___def_3 pub -> auto___def_30 X2 -> auto___def_5 X1 -> auto___def_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_5 X1 -> auto___def_5 X1). tauto. exact (rem_889 X1).
Qed.

Remark rem_1561 : forall X1 X2:term, auto___def_3 pub -> auto___def_30 X2 -> auto___def_5 X1 -> auto___def_30 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_30 X2 -> auto___def_30 X2). tauto. exact (rem_1555 X2).
Qed.

Remark rem_1562 : forall X1 X2:term, auto___def_3 pub -> auto___def_30 X2 -> auto___def_5 X1 -> (auto___def_5 X1 /\ auto___def_30 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_5 X1). 2:apply (rem_1560 X1 X2);  assumption.
  cut (auto___def_30 X2). 2:apply (rem_1561 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1563 : forall X1 X2:term, auto___def_3 pub -> auto___def_30 X2 -> auto___def_5 X1 -> auto___def_10 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1562 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_10_10;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1564 : forall X1 X2:term, auto___def_3 pub -> auto___def_5 X1 -> auto___def_30 X2 -> auto___def_10 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_3 pub -> auto___def_30 X2 -> auto___def_5 X1 -> auto___def_10 X1 X2). tauto. exact (rem_1563 X1 X2).
Qed.

Remark rem_1565 : forall X1 X2:term, auto___def_3 pub -> auto___def_30 X2 -> auto___def_7 X1 -> auto___def_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_7 X1 -> auto___def_7 X1). tauto. exact (rem_155 X1).
Qed.

Remark rem_1566 : forall X1 X2:term, auto___def_3 pub -> auto___def_30 X2 -> auto___def_7 X1 -> auto___def_30 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_30 X2 -> auto___def_30 X2). tauto. exact (rem_1555 X2).
Qed.

Remark rem_1567 : forall X1 X2:term, auto___def_3 pub -> auto___def_30 X2 -> auto___def_7 X1 -> (auto___def_7 X1 /\ auto___def_30 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_7 X1). 2:apply (rem_1565 X1 X2);  assumption.
  cut (auto___def_30 X2). 2:apply (rem_1566 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1568 : forall X1 X2:term, auto___def_3 pub -> auto___def_30 X2 -> auto___def_7 X1 -> auto___def_10 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1567 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_10_7;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1569 : forall X1 X2:term, auto___def_3 pub -> auto___def_7 X1 -> auto___def_30 X2 -> auto___def_10 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_3 pub -> auto___def_30 X2 -> auto___def_7 X1 -> auto___def_10 X1 X2). tauto. exact (rem_1568 X1 X2).
Qed.

Remark rem_1570 : forall X1 X2:term, auto___def_30 X2 -> auto___type_6 (key pub X1) -> auto___def_10 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_180 pub X1 H);  intros.
  apply (rem_1559 X1 X2);  tauto.
  apply (rem_1564 X1 X2);  tauto.
  apply (rem_1569 X1 X2);  tauto.
Qed.

Remark rem_1571 : forall X1 X2:term, auto_knows_old (crypt X2 (key pub X1)) -> auto___def_10 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_182 X2 (key pub X1) H);  intros.
  apply (rem_1413 X1 X2);  tauto.
  apply (rem_1430 X1 X2);  tauto.
  apply (rem_1549 X1 X2);  tauto.
  apply (rem_1553 X1 X2);  tauto.
  apply (rem_1570 X1 X2);  tauto.
Qed.

Remark rem_1572 : auto___def_7 server. (* Deduce positive atom. *)
Proof.
   case rem_135. intros. apply trans___def_7_server_1;  tauto.
 tauto.
Qed.

Remark rem_1573 : (forall X:term, auto___def_5 X -> auto_knows_old X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_5_pknows_old.  tauto.
Defined.

Remark rem_1574 : (forall X:term, auto___def_5 X -> auto_knows_old X)
    -> auto_knows_old bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_5_pknows_old.  case (rem_1573 epsilon_m__def_5_pknows_old). clear  epsilon_m__def_5_pknows_old. intros. apply trans_knows_old_bob_1;  tauto.
 clear  epsilon_m__def_5_pknows_old. tauto.
Defined.

Remark rem_1575 : (forall X:term, auto___def_5 X -> auto_knows_old X)
    -> auto___def_5 bob -> auto_knows_old bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_5_pknows_old. intro H. intros.
  elim (rem_57 H);  intros.
  apply (rem_1574 epsilon_m__def_5_pknows_old);  tauto.
Defined.

Remark rem_1576 : forall X1:term, auto___def_5 X1 -> auto_knows_old X1. (* Induct. *)
Proof.
  fix epsilon_m__def_5_pknows_old 1.
  intro X. case X.
   intro H. elim (rem_69  H).
  exact (rem_1575 epsilon_m__def_5_pknows_old ).
  intros X1 X2. intro H. elim (rem_65 X1 X2 H).
  intros X1 X2. intro H. elim (rem_66 X1 X2 H).
   intro H. elim (rem_61  H).
   intro H. elim (rem_73  H).
  intros X1 X2. intro H. elim (rem_67 X1 X2 H).
   intro H. elim (rem_60  H).
  intros X1 X2 X3. intro H. elim (rem_64 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_68 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_72 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_70 X1 X2 X3 X4 H).
   intro H. elim (rem_75  H).
   intro H. elim (rem_71  H).
  intros X1. intro H. elim (rem_59 X1 H).
   intro H. elim (rem_74  H).
  intros X1 X2 X3. intro H. elim (rem_62 X1 X2 X3 H).
   intro H. elim (rem_63  H).
Qed.

Remark rem_1577 : forall X1 X2 X3:term, auto___def_4 X2 -> auto___def_5 X1 -> auto_knows_current (cons X3 (cons X1 nil)) -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_5 X1 -> auto_knows_old X1). tauto. exact (rem_1576 X1).
Qed.

Remark rem_1578 : forall X1 X2 X3:term, auto___def_4 X2 -> auto___def_5 X1 -> auto_knows_current (cons X3 (cons X1 nil)) -> auto___def_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_5 X1 -> auto___def_5 X1). tauto. exact (rem_889 X1).
Qed.

Remark rem_1579 : forall X2:term, auto___def_4 X2 -> auto___def_4 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1580 : forall X1 X2 X3:term, auto___def_4 X2 -> auto___def_5 X1 -> auto_knows_current (cons X3 (cons X1 nil)) -> auto___def_4 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_4 X2 -> auto___def_4 X2). tauto. exact (rem_1579 X2).
Qed.

Remark rem_1581 : forall X1 X2 X3:term, auto___def_4 X2 -> auto___def_5 X1 -> auto_knows_current (cons X3 (cons X1 nil)) -> (auto_knows_old X1 /\ auto___def_5 X1 /\ auto___def_4 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  cut (auto_knows_old X1). 2:apply (rem_1577 X1 X2 X3);  assumption.
  cut (auto___def_5 X1). 2:apply (rem_1578 X1 X2 X3);  assumption.
  cut (auto___def_4 X2). 2:apply (rem_1580 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_1582 : forall X1 X2 X3:term, auto___def_4 X2 -> auto___def_5 X1 -> auto_knows_current (cons X3 (cons X1 nil)) -> auto___def_45 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  case (rem_1581 X1 X2 X3 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_45_3;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1583 : forall X1:term, auto___def_9 X1 -> auto___def_9 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1584 : forall X1 X2:term, auto___def_8 X2 -> auto___def_9 X1 -> auto_knows_current X1 -> auto_knows_current nil -> auto___def_9 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_9 X1 -> auto___def_9 X1). tauto. exact (rem_1583 X1).
Qed.

Remark rem_1585 : forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1586 : forall X1 X2:term, auto___def_8 X2 -> auto___def_9 X1 -> auto_knows_current X1 -> auto_knows_current nil -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_1585 X1).
Qed.

Remark rem_1587 : forall X2:term, auto___def_8 X2 -> auto___def_8 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1588 : forall X1 X2:term, auto___def_8 X2 -> auto___def_9 X1 -> auto_knows_current X1 -> auto_knows_current nil -> auto___def_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_8 X2 -> auto___def_8 X2). tauto. exact (rem_1587 X2).
Qed.

Remark rem_1589 : forall X1 X2:term, auto___def_8 X2 -> auto___def_9 X1 -> auto_knows_current X1 -> auto_knows_current nil -> (auto___def_9 X1 /\ auto_knows_current X1 /\ auto___def_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3 A4.
  cut (auto___def_9 X1). 2:apply (rem_1584 X1 X2);  assumption.
  cut (auto_knows_current X1). 2:apply (rem_1586 X1 X2);  assumption.
  cut (auto___def_8 X2). 2:apply (rem_1588 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1590 : forall X1 X2:term, auto___def_8 X2 -> auto___def_9 X1 -> auto_knows_current X1 -> auto_knows_current nil -> auto___def_45 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3 A4.
  case (rem_1589 X1 X2 A1 A2 A3 A4). clear  A1 A2 A3 A4. intros. apply trans___def_45_2;  tauto.
 clear  A1 A2 A3 A4. tauto.
Qed.

Remark rem_1591 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current nil -> auto___def_8 X2 -> auto___def_9 X1 -> auto___def_45 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_8 X2 -> auto___def_9 X1 -> auto_knows_current X1 -> auto_knows_current nil -> auto___def_45 X1 X2). tauto. exact (rem_1590 X1 X2).
Qed.

Remark rem_1592 : forall X1 X2:term, auto___def_8 X2 -> auto___def_9 X1 -> auto_knows_current (cons X1 nil) -> auto___def_45 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1 H2. intro H. intros.
  elim (rem_462 X1 nil H);  intros.
  apply (rem_1591 X1 X2);  tauto.
Qed.

Remark rem_1593 : forall X1 X2 X3:term, auto___def_8 X2 -> auto___def_9 X1 -> auto_knows_current X3 -> auto_knows_current (cons X1 nil) -> auto___def_45 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_8 X2 -> auto___def_9 X1 -> auto_knows_current (cons X1 nil) -> auto___def_45 X1 X2). tauto.
  exact (rem_1592 X1 X2).
Qed.

Remark rem_1594 : forall X1 X2 X3:term, auto_knows_current X3 -> auto_knows_current (cons X1 nil) -> auto___def_8 X2 -> auto___def_9 X1 -> auto___def_45 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_8 X2 -> auto___def_9 X1 -> auto_knows_current X3 -> auto_knows_current (cons X1 nil) -> auto___def_45 X1 X2). tauto. exact (rem_1593 X1 X2 X3).
Qed.

Remark rem_1595 : forall X1 X2 X3:term, auto___def_8 X2 -> auto___def_9 X1 -> auto_knows_current (cons X3 (cons X1 nil)) -> auto___def_45 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1 H2. intro H. intros.
  elim (rem_462 X3 (cons X1 nil) H);  intros.
  apply (rem_1594 X1 X2 X3);  tauto.
Qed.

Remark rem_1596 : forall X1 X2 X3:term, auto___def_6 X2 -> auto___def_7 X1 -> auto_knows_current (cons X3 (cons X1 nil)) -> auto___type_11 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_7 X1 -> auto___type_11 X1). tauto. exact (rem_100 X1).
Qed.

Remark rem_1597 : forall X1 X2 X3:term, auto___def_6 X2 -> auto___def_7 X1 -> auto_knows_current (cons X3 (cons X1 nil)) -> auto___def_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_7 X1 -> auto___def_7 X1). tauto. exact (rem_155 X1).
Qed.

Remark rem_1598 : forall X2:term, auto___def_6 X2 -> auto___def_6 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1599 : forall X1 X2 X3:term, auto___def_6 X2 -> auto___def_7 X1 -> auto_knows_current (cons X3 (cons X1 nil)) -> auto___def_6 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_6 X2 -> auto___def_6 X2). tauto. exact (rem_1598 X2).
Qed.

Remark rem_1600 : forall X1 X2 X3:term, auto___def_6 X2 -> auto___def_7 X1 -> auto_knows_current (cons X3 (cons X1 nil)) -> (auto___type_11 X1 /\ auto___def_7 X1 /\ auto___def_6 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___type_11 X1). 2:apply (rem_1596 X1 X2 X3);  assumption.
  cut (auto___def_7 X1). 2:apply (rem_1597 X1 X2 X3);  assumption.
  cut (auto___def_6 X2). 2:apply (rem_1599 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_1601 : forall X1 X2 X3:term, auto___def_6 X2 -> auto___def_7 X1 -> auto_knows_current (cons X3 (cons X1 nil)) -> auto___def_45 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  case (rem_1600 X1 X2 X3 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_45_4;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1602 : (forall X:term, auto___def_2 X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_2_pknows_current.  tauto.
Defined.

Remark rem_1603 : (forall X:term, auto___def_2 X -> auto_knows_current X)
    -> auto_knows_current alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_2_pknows_current.  case (rem_1602 epsilon_m__def_2_pknows_current). clear  epsilon_m__def_2_pknows_current. intros. apply trans_knows_current_alice_1;  tauto.
 clear  epsilon_m__def_2_pknows_current. tauto.
Defined.

Remark rem_1604 : (forall X:term, auto___def_2 X -> auto_knows_current X)
    -> auto___def_2 alice -> auto_knows_current alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_2_pknows_current. intro H. intros.
  elim (rem_9 H);  intros.
  apply (rem_1603 epsilon_m__def_2_pknows_current);  tauto.
Defined.

Remark rem_1605 : forall X1:term, auto___def_2 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_m__def_2_pknows_current 1.
  intro X. case X.
  exact (rem_1604 epsilon_m__def_2_pknows_current ).
   intro H. elim (rem_20  H).
  intros X1 X2. intro H. elim (rem_17 X1 X2 H).
  intros X1 X2. intro H. elim (rem_18 X1 X2 H).
   intro H. elim (rem_13  H).
   intro H. elim (rem_25  H).
  intros X1 X2. intro H. elim (rem_19 X1 X2 H).
   intro H. elim (rem_12  H).
  intros X1 X2 X3. intro H. elim (rem_16 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_21 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_24 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_22 X1 X2 X3 X4 H).
   intro H. elim (rem_27  H).
   intro H. elim (rem_23  H).
  intros X1. intro H. elim (rem_11 X1 H).
   intro H. elim (rem_26  H).
  intros X1 X2 X3. intro H. elim (rem_14 X1 X2 X3 H).
   intro H. elim (rem_15  H).
Qed.

Remark rem_1606 : forall X1 X2 X3:term, auto___def_1 X2 -> auto___def_2 X1 -> auto_knows_current (cons X3 (cons X1 nil)) -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_2 X1 -> auto_knows_current X1). tauto. exact (rem_1605 X1).
Qed.

Remark rem_1607 : forall X1 X2 X3:term, auto___def_1 X2 -> auto___def_2 X1 -> auto_knows_current (cons X3 (cons X1 nil)) -> auto___def_2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_2 X1 -> auto___def_2 X1). tauto. exact (rem_866 X1).
Qed.

Remark rem_1608 : forall X2:term, auto___def_1 X2 -> auto___def_1 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1609 : forall X1 X2 X3:term, auto___def_1 X2 -> auto___def_2 X1 -> auto_knows_current (cons X3 (cons X1 nil)) -> auto___def_1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_1 X2 -> auto___def_1 X2). tauto. exact (rem_1608 X2).
Qed.

Remark rem_1610 : forall X1 X2 X3:term, auto___def_1 X2 -> auto___def_2 X1 -> auto_knows_current (cons X3 (cons X1 nil)) -> (auto_knows_current X1 /\ auto___def_2 X1 /\ auto___def_1 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  cut (auto_knows_current X1). 2:apply (rem_1606 X1 X2 X3);  assumption.
  cut (auto___def_2 X1). 2:apply (rem_1607 X1 X2 X3);  assumption.
  cut (auto___def_1 X2). 2:apply (rem_1609 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_1611 : forall X1 X2 X3:term, auto___def_1 X2 -> auto___def_2 X1 -> auto_knows_current (cons X3 (cons X1 nil)) -> auto___def_45 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  case (rem_1610 X1 X2 X3 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_45_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1612 : forall X1 X2:term, auto_has_pub_key X1 X2 -> or_4
    (auto___def_4 X1 /\ auto___def_5 X2)
    (auto___def_8 X1 /\ auto___def_9 X2)
    (auto___def_6 X1 /\ auto___def_7 X2)
    (auto___def_1 X1 /\ auto___def_2 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_4_intro_1; tauto.
  intros. apply or_4_intro_2; tauto.
  intros. apply or_4_intro_3; tauto.
  intros. apply or_4_intro_4; tauto.
Qed.

Remark rem_1613 : forall X1 X2 X3:term, auto_has_pub_key X2 X1 -> auto_knows_current (cons X3 (cons X1 nil)) -> auto___def_45 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1612 X2 X1 H);  intros.
  apply (rem_1582 X1 X2 X3);  tauto.
  apply (rem_1595 X1 X2 X3);  tauto.
  apply (rem_1601 X1 X2 X3);  tauto.
  apply (rem_1611 X1 X2 X3);  tauto.
Qed.

Remark rem_1614 : forall X1 X2 X3:term, auto_knows_current (cons X3 (cons X1 nil)) -> auto_has_pub_key X2 X1 -> auto___def_45 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_has_pub_key X2 X1 -> auto_knows_current (cons X3 (cons X1 nil)) -> auto___def_45 X1 X2). tauto. exact (rem_1613 X1 X2 X3).
Qed.

Remark rem_1615 : auto___def_37 sym. (* Deduce positive atom. *)
Proof.
   case rem_135. intros. apply trans___def_37_sym_1;  tauto.
 tauto.
Qed.

Remark rem_1616 : forall X1:term, auto___def_23 sym -> auto___def_36 X1 -> auto___def_15 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_23 sym -> False). tauto.
  exact (rem_229).
Qed.

Remark rem_1617 : forall X1:term, auto___def_3 sym -> auto___def_15 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_3 sym -> False). tauto.
  exact (rem_232).
Qed.

Remark rem_1618 : forall X1:term, auto___def_3 sym -> auto___type_9 X1 -> auto___def_15 X1. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1. intros. apply (rem_1617 X1);  assumption.
Qed.

Remark rem_1619 : forall X1:term, auto_knows_old (key sym X1) -> auto___def_15 X1. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_172 sym X1 H);  intros.
  apply (rem_1616 X1);  tauto.
  apply (rem_1618 X1);  tauto.
Qed.

Remark rem_1620 : forall X1 X2 X3 X4:term, auto___def_32 (cons X3 (cons X1 nil)) -> auto___type_2 (key pub X2) -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_190 X3 (cons X1 nil) H);  intros.
Qed.

Remark rem_1621 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_26 X3 -> auto___def_32 (cons X4 (cons X1 nil)) -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_190 X4 (cons X1 nil) H);  intros.
Qed.

Remark rem_1622 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_26 X3 -> auto___def_32 (cons X4 (cons X1 nil)) -> auto___type_2 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_26 X3 -> auto___def_32 (cons X4 (cons X1 nil)) -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1621 X1 X2 X3 X4).
Qed.

Remark rem_1623 : forall X1 X2 X3 X4:term, auto___def_32 (cons X4 (cons X1 nil)) -> auto___type_2 (key prv server) -> auto___def_2 X2 -> auto___def_26 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_26 X3 -> auto___def_32 (cons X4 (cons X1 nil)) -> auto___type_2 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1622 X1 X2 X3 X4).
Qed.

Remark rem_1624 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_25 (cons X4 (cons X1 nil)) -> auto___def_26 X3 -> auto___type_4 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_4 (key prv server) -> False). tauto.
  exact (rem_197).
Qed.

Remark rem_1625 : forall X1 X2 X3 X4:term, auto___def_25 (cons X4 (cons X1 nil)) -> auto___type_4 (key prv server) -> auto___def_2 X2 -> auto___def_26 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_25 (cons X4 (cons X1 nil)) -> auto___def_26 X3 -> auto___type_4 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1624 X1 X2 X3 X4).
Qed.

Remark rem_1626 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_22 nil -> auto___def_26 X3 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_3 X1 -> auto___type_3 X1). tauto. exact (rem_199 X1).
Qed.

Remark rem_1627 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_22 nil -> auto___def_26 X3 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_3 X1 -> auto_agent X1). tauto. exact (rem_392 X1).
Qed.

Remark rem_1628 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_22 nil -> auto___def_26 X3 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto_agent X2). tauto. exact (rem_320 X2).
Qed.

Remark rem_1629 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_22 nil -> auto___def_26 X3 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_2 X2). tauto. exact (rem_322 X2).
Qed.

Remark rem_1630 : forall X3:term, auto___def_26 X3 -> auto___def_26 X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1631 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_22 nil -> auto___def_26 X3 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_26 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_26 X3 -> auto___def_26 X3). tauto. exact (rem_1630 X3).
Qed.

Remark rem_1632 : forall X4:term, auto___type_2 X4 -> auto___type_2 X4. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1633 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_22 nil -> auto___def_26 X3 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_2 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_2 X4 -> auto___type_2 X4). tauto. exact (rem_1632 X4).
Qed.

Remark rem_1634 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_22 nil -> auto___def_26 X3 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> (auto___type_3 X1 /\ auto_agent X1 /\ auto_agent X2 /\ auto___def_2 X2 /\ auto___def_26 X3 /\ auto___type_2 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto___type_3 X1). 2:apply (rem_1626 X1 X2 X3 X4);  assumption.
  cut (auto_agent X1). 2:apply (rem_1627 X1 X2 X3 X4);  assumption.
  cut (auto_agent X2). 2:apply (rem_1628 X1 X2 X3 X4);  assumption.
  cut (auto___def_2 X2). 2:apply (rem_1629 X1 X2 X3 X4);  assumption.
  cut (auto___def_26 X3). 2:apply (rem_1631 X1 X2 X3 X4);  assumption.
  cut (auto___type_2 X4). 2:apply (rem_1633 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_1635 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_22 nil -> auto___def_26 X3 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_1634 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_29_4;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_1636 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto___def_22 nil -> auto___def_2 X2 -> auto___def_26 X3 -> auto___type_2 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_22 nil -> auto___def_26 X3 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1635 X1 X2 X3 X4).
Qed.

Remark rem_1637 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_21 (cons X1 nil) -> auto___def_26 X3 -> auto___type_2 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_206 X1 nil H);  intros.
  apply (rem_1636 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1638 : forall X1 X2 X3 X4:term, auto___type_2 X4 -> auto___def_21 (cons X1 nil) -> auto___def_2 X2 -> auto___def_26 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_21 (cons X1 nil) -> auto___def_26 X3 -> auto___type_2 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1637 X1 X2 X3 X4).
Qed.

Remark rem_1639 : forall X1 X2 X3 X4:term, auto___def_19 (cons X4 (cons X1 nil)) -> auto___def_2 X2 -> auto___def_26 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_209 X4 (cons X1 nil) H);  intros.
  apply (rem_1638 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1640 : forall X1 X2 X3 X4:term, auto___def_19 (cons X4 (cons X1 nil)) -> auto___def_2 X2 -> auto___def_20 (key prv server) -> auto___def_26 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_19 (cons X4 (cons X1 nil)) -> auto___def_2 X2 -> auto___def_26 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1639 X1 X2 X3 X4).
Qed.

Remark rem_1641 : forall X1 X2 X3 X4:term, auto___def_19 (cons X4 (cons X1 nil)) -> auto___def_20 (key prv server) -> auto___def_2 X2 -> auto___def_26 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_19 (cons X4 (cons X1 nil)) -> auto___def_2 X2 -> auto___def_20 (key prv server) -> auto___def_26 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1640 X1 X2 X3 X4).
Qed.

Remark rem_1642 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_26 X3 -> auto_agent X2 -> auto_agent X1 -> auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key prv server) -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old (key prv server) -> False). tauto.
  exact (rem_216).
Qed.

Remark rem_1643 : forall X1 X2 X3 X4:term, auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key prv server) -> auto___def_2 X2 -> auto___def_26 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_26 X3 -> auto_agent X2 -> auto_agent X1 -> auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key prv server) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1642 X1 X2 X3 X4).
Qed.

Remark rem_1644 : (forall X:term, auto___def_32 X -> auto_agent X -> False)
    -> forall X1 X2 X3 X4:term, auto_agent (nonceb_old X1 X2 X3 X4) -> auto___type_3 X1 -> auto_agent X1 -> auto___def_5 X2 -> auto_agent X2 -> auto___type_2 X3 -> auto___def_26 X4 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_32_magent. intros X1 X2 X3 X4. intro H. intros.
  elim (rem_128 X1 X2 X3 X4 H);  intros.
Defined.

Remark rem_1645 : (forall X:term, auto___def_32 X -> auto_agent X -> False)
    -> forall X1 X2 X3 X4:term, auto_agent (nonceb_old X1 X2 X3 X4) -> auto___type_3 X1 -> auto_agent X1 -> auto_agent X2 -> auto___def_2 X2 -> auto___type_2 X3 -> auto___def_26 X4 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_32_magent. intros X1 X2 X3 X4. intro H. intros.
  elim (rem_128 X1 X2 X3 X4 H);  intros.
Defined.

Remark rem_1646 : (forall X:term, auto___def_32 X -> auto_agent X -> False)
    -> forall X1 X2 X3 X4:term, auto_agent (nonceb_old X1 X2 X3 X4) -> auto___type_3 X1 -> auto___type_9 X2 -> auto_agent X2 -> auto___type_2 X3 -> auto_knows_old X4 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_32_magent. intros X1 X2 X3 X4. intro H. intros.
  elim (rem_128 X1 X2 X3 X4 H);  intros.
Defined.

Remark rem_1647 : (forall X:term, auto___def_32 X -> auto_agent X -> False)
    -> forall X1 X2 X3 X4:term, auto_agent (nonceb_old X1 X2 X3 X4) -> auto___type_3 X1 -> auto_agent X1 -> auto___def_7 X2 -> auto_agent X2 -> auto___type_2 X3 -> auto___def_26 X4 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_32_magent. intros X1 X2 X3 X4. intro H. intros.
  elim (rem_128 X1 X2 X3 X4 H);  intros.
Defined.

Remark rem_1648 : forall X1 X2 X3 X4:term, auto___def_32 (nonceb_old X1 X2 X3 X4) -> or_4
    (auto___type_3 X1 /\ auto_agent X1 /\ auto___def_5 X2 /\ auto_agent X2 /\ auto___type_2 X3 /\ auto___def_26 X4)
    (auto___type_3 X1 /\ auto_agent X1 /\ auto_agent X2 /\ auto___def_2 X2 /\ auto___type_2 X3 /\ auto___def_26 X4)
    (auto___type_3 X1 /\ auto___type_9 X2 /\ auto_agent X2 /\ auto___type_2 X3 /\ auto_knows_old X4)
    (auto___type_3 X1 /\ auto_agent X1 /\ auto___def_7 X2 /\ auto_agent X2 /\ auto___type_2 X3 /\ auto___def_26 X4)
.
Proof.
  intros. inversion H.
  intros. apply or_4_intro_1; tauto.
  intros. apply or_4_intro_2; tauto.
  intros. apply or_4_intro_3; tauto.
  intros. apply or_4_intro_4; tauto.
Qed.

Remark rem_1649 : (forall X:term, auto___def_32 X -> auto_agent X -> False)
    -> forall X1 X2 X3 X4:term, auto___def_32 (nonceb_old X1 X2 X3 X4) -> auto_agent (nonceb_old X1 X2 X3 X4) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_32_magent. intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1648 X1 X2 X3 X4 H);  intros.
  apply (rem_1644 epsilon_m__def_32_magent X1 X2 X3 X4);  tauto.
  apply (rem_1645 epsilon_m__def_32_magent X1 X2 X3 X4);  tauto.
  apply (rem_1646 epsilon_m__def_32_magent X1 X2 X3 X4);  tauto.
  apply (rem_1647 epsilon_m__def_32_magent X1 X2 X3 X4);  tauto.
Defined.

Remark rem_1650 : forall X1:term, auto___def_32 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1651 : auto___def_32 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1652 : auto___def_32 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1653 : forall X1 X2 X3:term, auto___def_32 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1654 : auto___def_32 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1655 : forall X1 X2 X3:term, auto___def_32 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1656 : forall X1 X2:term, auto___def_32 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1657 : forall X1 X2:term, auto___def_32 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1658 : auto___def_32 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1659 : forall X1 X2 X3:term, auto___def_32 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1660 : auto___def_32 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1661 : auto___def_32 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1662 : forall X1 X2 X3 X4:term, auto___def_32 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1663 : auto___def_32 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1664 : auto___def_32 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1665 : auto___def_32 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1666 : forall X1:term, auto___def_32 X1 -> auto_agent X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_32_magent 1.
  intro X. case X.
   intro H. elim (rem_1660  H).
   intro H. elim (rem_1658  H).
  intros X1 X2. intro H. elim (rem_190 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1656 X1 X2 H).
   intro H. elim (rem_1652  H).
   intro H. elim (rem_1663  H).
  intros X1 X2. intro H. elim (rem_1657 X1 X2 H).
   intro H. elim (rem_1651  H).
  intros X1 X2 X3. intro H. elim (rem_1655 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1659 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1662 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4;  exact (rem_1649 epsilon_m__def_32_magent X1 X2 X3 X4).
   intro H. elim (rem_1665  H).
   intro H. elim (rem_1661  H).
  intros X1. intro H. elim (rem_1650 X1 H).
   intro H. elim (rem_1664  H).
  intros X1 X2 X3. intro H. elim (rem_1653 X1 X2 X3 H).
   intro H. elim (rem_1654  H).
Qed.

Remark rem_1667 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_26 X3 -> auto___def_32 X1 -> auto___def_33 nil -> auto___type_7 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_1666 X1)). tauto.
Qed.

Remark rem_1668 : forall X1 X2 X3 X4:term, auto___def_32 X1 -> auto___def_33 nil -> auto___def_2 X2 -> auto___def_26 X3 -> auto___type_7 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_26 X3 -> auto___def_32 X1 -> auto___def_33 nil -> auto___type_7 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1667 X1 X2 X3 X4).
Qed.

Remark rem_1669 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_26 X3 -> auto___def_31 (cons X1 nil) -> auto___type_7 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_221 X1 nil H);  intros.
  apply (rem_1668 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1670 : forall X1 X2 X3 X4:term, auto___type_7 X4 -> auto___def_31 (cons X1 nil) -> auto___def_2 X2 -> auto___def_26 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_26 X3 -> auto___def_31 (cons X1 nil) -> auto___type_7 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1669 X1 X2 X3 X4).
Qed.

Remark rem_1671 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_26 X3 -> auto___def_30 (cons X4 (cons X1 nil)) -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_224 X4 (cons X1 nil) H);  intros.
  apply (rem_1670 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1672 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_26 X3 -> auto___def_30 (cons X4 (cons X1 nil)) -> auto___type_6 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_26 X3 -> auto___def_30 (cons X4 (cons X1 nil)) -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1671 X1 X2 X3 X4).
Qed.

Remark rem_1673 : forall X1 X2 X3 X4:term, auto___def_30 (cons X4 (cons X1 nil)) -> auto___type_6 (key prv server) -> auto___def_2 X2 -> auto___def_26 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_26 X3 -> auto___def_30 (cons X4 (cons X1 nil)) -> auto___type_6 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1672 X1 X2 X3 X4).
Qed.

Remark rem_1674 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_26 X3 -> auto_agent X2 -> auto_agent X1 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_182 (cons X4 (cons X1 nil)) (key prv server) H);  intros.
  apply (rem_1623 X1 X2 X3 X4);  tauto.
  apply (rem_1625 X1 X2 X3 X4);  tauto.
  apply (rem_1641 X1 X2 X3 X4);  tauto.
  apply (rem_1643 X1 X2 X3 X4);  tauto.
  apply (rem_1673 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1675 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_26 X3 -> auto___def_3 pub -> auto_agent X2 -> auto_agent X1 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_26 X3 -> auto_agent X2 -> auto_agent X1 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1674 X1 X2 X3 X4).
Qed.

Remark rem_1676 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto___def_2 X2 -> auto___def_26 X3 -> auto_agent X2 -> auto_agent X1 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_26 X3 -> auto___def_3 pub -> auto_agent X2 -> auto_agent X1 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1675 X1 X2 X3 X4).
Qed.

Remark rem_1677 : forall X1 X2 X3 X4:term, auto___def_26 X3 -> auto___def_32 (cons X4 (cons X1 nil)) -> auto___def_5 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_190 X4 (cons X1 nil) H);  intros.
Qed.

Remark rem_1678 : forall X1 X2 X3 X4:term, auto___def_26 X3 -> auto___def_32 (cons X4 (cons X1 nil)) -> auto___def_5 X2 -> auto___type_2 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_26 X3 -> auto___def_32 (cons X4 (cons X1 nil)) -> auto___def_5 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1677 X1 X2 X3 X4).
Qed.

Remark rem_1679 : forall X1 X2 X3 X4:term, auto___def_32 (cons X4 (cons X1 nil)) -> auto___type_2 (key prv server) -> auto___def_26 X3 -> auto___def_5 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_26 X3 -> auto___def_32 (cons X4 (cons X1 nil)) -> auto___def_5 X2 -> auto___type_2 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1678 X1 X2 X3 X4).
Qed.

Remark rem_1680 : forall X1 X2 X3 X4:term, auto___def_25 (cons X4 (cons X1 nil)) -> auto___def_26 X3 -> auto___def_5 X2 -> auto___type_4 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_4 (key prv server) -> False). tauto.
  exact (rem_197).
Qed.

Remark rem_1681 : forall X1 X2 X3 X4:term, auto___def_25 (cons X4 (cons X1 nil)) -> auto___type_4 (key prv server) -> auto___def_26 X3 -> auto___def_5 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_25 (cons X4 (cons X1 nil)) -> auto___def_26 X3 -> auto___def_5 X2 -> auto___type_4 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1680 X1 X2 X3 X4).
Qed.

Remark rem_1682 : forall X1 X2 X3 X4:term, auto___def_22 nil -> auto___def_26 X3 -> auto___def_5 X2 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_3 X1 -> auto___type_3 X1). tauto. exact (rem_199 X1).
Qed.

Remark rem_1683 : forall X1 X2 X3 X4:term, auto___def_22 nil -> auto___def_26 X3 -> auto___def_5 X2 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_3 X1 -> auto_agent X1). tauto. exact (rem_392 X1).
Qed.

Remark rem_1684 : forall X1 X2 X3 X4:term, auto___def_22 nil -> auto___def_26 X3 -> auto___def_5 X2 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto___def_5 X2). tauto. exact (rem_408 X2).
Qed.

Remark rem_1685 : forall X1 X2 X3 X4:term, auto___def_22 nil -> auto___def_26 X3 -> auto___def_5 X2 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_5 X2 -> auto_agent X2). tauto. exact (rem_413 X2).
Qed.

Remark rem_1686 : forall X1 X2 X3 X4:term, auto___def_22 nil -> auto___def_26 X3 -> auto___def_5 X2 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_26 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_26 X3 -> auto___def_26 X3). tauto. exact (rem_1630 X3).
Qed.

Remark rem_1687 : forall X1 X2 X3 X4:term, auto___def_22 nil -> auto___def_26 X3 -> auto___def_5 X2 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_2 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_2 X4 -> auto___type_2 X4). tauto. exact (rem_1632 X4).
Qed.

Remark rem_1688 : forall X1 X2 X3 X4:term, auto___def_22 nil -> auto___def_26 X3 -> auto___def_5 X2 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> (auto___type_3 X1 /\ auto_agent X1 /\ auto___def_5 X2 /\ auto_agent X2 /\ auto___def_26 X3 /\ auto___type_2 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto___type_3 X1). 2:apply (rem_1682 X1 X2 X3 X4);  assumption.
  cut (auto_agent X1). 2:apply (rem_1683 X1 X2 X3 X4);  assumption.
  cut (auto___def_5 X2). 2:apply (rem_1684 X1 X2 X3 X4);  assumption.
  cut (auto_agent X2). 2:apply (rem_1685 X1 X2 X3 X4);  assumption.
  cut (auto___def_26 X3). 2:apply (rem_1686 X1 X2 X3 X4);  assumption.
  cut (auto___type_2 X4). 2:apply (rem_1687 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_1689 : forall X1 X2 X3 X4:term, auto___def_22 nil -> auto___def_26 X3 -> auto___def_5 X2 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_1688 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_29_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_1690 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto___def_22 nil -> auto___def_26 X3 -> auto___def_5 X2 -> auto___type_2 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_22 nil -> auto___def_26 X3 -> auto___def_5 X2 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1689 X1 X2 X3 X4).
Qed.

Remark rem_1691 : forall X1 X2 X3 X4:term, auto___def_21 (cons X1 nil) -> auto___def_26 X3 -> auto___def_5 X2 -> auto___type_2 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_206 X1 nil H);  intros.
  apply (rem_1690 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1692 : forall X1 X2 X3 X4:term, auto___type_2 X4 -> auto___def_21 (cons X1 nil) -> auto___def_26 X3 -> auto___def_5 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_21 (cons X1 nil) -> auto___def_26 X3 -> auto___def_5 X2 -> auto___type_2 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1691 X1 X2 X3 X4).
Qed.

Remark rem_1693 : forall X1 X2 X3 X4:term, auto___def_19 (cons X4 (cons X1 nil)) -> auto___def_26 X3 -> auto___def_5 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_209 X4 (cons X1 nil) H);  intros.
  apply (rem_1692 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1694 : forall X1 X2 X3 X4:term, auto___def_19 (cons X4 (cons X1 nil)) -> auto___def_20 (key prv server) -> auto___def_26 X3 -> auto___def_5 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_19 (cons X4 (cons X1 nil)) -> auto___def_26 X3 -> auto___def_5 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1693 X1 X2 X3 X4).
Qed.

Remark rem_1695 : forall X1 X2 X3 X4:term, auto___def_26 X3 -> auto___def_5 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key prv server) -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old (key prv server) -> False). tauto.
  exact (rem_216).
Qed.

Remark rem_1696 : forall X1 X2 X3 X4:term, auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key prv server) -> auto___def_26 X3 -> auto___def_5 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_26 X3 -> auto___def_5 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key prv server) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1695 X1 X2 X3 X4).
Qed.

Remark rem_1697 : forall X1 X2 X3 X4:term, auto___def_26 X3 -> auto___def_32 X1 -> auto___def_33 nil -> auto___def_5 X2 -> auto___type_7 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_1666 X1)). tauto.
Qed.

Remark rem_1698 : forall X1 X2 X3 X4:term, auto___def_32 X1 -> auto___def_33 nil -> auto___def_26 X3 -> auto___def_5 X2 -> auto___type_7 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_26 X3 -> auto___def_32 X1 -> auto___def_33 nil -> auto___def_5 X2 -> auto___type_7 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1697 X1 X2 X3 X4).
Qed.

Remark rem_1699 : forall X1 X2 X3 X4:term, auto___def_26 X3 -> auto___def_31 (cons X1 nil) -> auto___def_5 X2 -> auto___type_7 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_221 X1 nil H);  intros.
  apply (rem_1698 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1700 : forall X1 X2 X3 X4:term, auto___type_7 X4 -> auto___def_31 (cons X1 nil) -> auto___def_26 X3 -> auto___def_5 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_26 X3 -> auto___def_31 (cons X1 nil) -> auto___def_5 X2 -> auto___type_7 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1699 X1 X2 X3 X4).
Qed.

Remark rem_1701 : forall X1 X2 X3 X4:term, auto___def_26 X3 -> auto___def_30 (cons X4 (cons X1 nil)) -> auto___def_5 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_224 X4 (cons X1 nil) H);  intros.
  apply (rem_1700 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1702 : forall X1 X2 X3 X4:term, auto___def_26 X3 -> auto___def_30 (cons X4 (cons X1 nil)) -> auto___def_5 X2 -> auto___type_6 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_26 X3 -> auto___def_30 (cons X4 (cons X1 nil)) -> auto___def_5 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1701 X1 X2 X3 X4).
Qed.

Remark rem_1703 : forall X1 X2 X3 X4:term, auto___def_30 (cons X4 (cons X1 nil)) -> auto___type_6 (key prv server) -> auto___def_26 X3 -> auto___def_5 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_26 X3 -> auto___def_30 (cons X4 (cons X1 nil)) -> auto___def_5 X2 -> auto___type_6 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1702 X1 X2 X3 X4).
Qed.

Remark rem_1704 : forall X1 X2 X3 X4:term, auto___def_26 X3 -> auto___def_5 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_182 (cons X4 (cons X1 nil)) (key prv server) H);  intros.
  apply (rem_1679 X1 X2 X3 X4);  tauto.
  apply (rem_1681 X1 X2 X3 X4);  tauto.
  apply (rem_1694 X1 X2 X3 X4);  tauto.
  apply (rem_1696 X1 X2 X3 X4);  tauto.
  apply (rem_1703 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1705 : forall X1 X2 X3 X4:term, auto___def_26 X3 -> auto___def_3 pub -> auto___def_5 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_26 X3 -> auto___def_5 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1704 X1 X2 X3 X4).
Qed.

Remark rem_1706 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto___def_5 X2 -> auto___def_26 X3 -> auto_agent X2 -> auto_agent X1 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_26 X3 -> auto___def_3 pub -> auto___def_5 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1705 X1 X2 X3 X4).
Qed.

Remark rem_1707 : forall X1 X2 X3 X4:term, auto___def_26 X3 -> auto___def_32 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_190 X4 (cons X1 nil) H);  intros.
Qed.

Remark rem_1708 : forall X1 X2 X3 X4:term, auto___def_26 X3 -> auto___def_32 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_2 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_26 X3 -> auto___def_32 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1707 X1 X2 X3 X4).
Qed.

Remark rem_1709 : forall X1 X2 X3 X4:term, auto___def_32 (cons X4 (cons X1 nil)) -> auto___type_2 (key prv server) -> auto___def_26 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_26 X3 -> auto___def_32 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_2 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1708 X1 X2 X3 X4).
Qed.

Remark rem_1710 : forall X1 X2 X3 X4:term, auto___def_25 (cons X4 (cons X1 nil)) -> auto___def_26 X3 -> auto___def_7 X2 -> auto___type_4 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_4 (key prv server) -> False). tauto.
  exact (rem_197).
Qed.

Remark rem_1711 : forall X1 X2 X3 X4:term, auto___def_25 (cons X4 (cons X1 nil)) -> auto___type_4 (key prv server) -> auto___def_26 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_25 (cons X4 (cons X1 nil)) -> auto___def_26 X3 -> auto___def_7 X2 -> auto___type_4 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1710 X1 X2 X3 X4).
Qed.

Remark rem_1712 : forall X1 X2 X3 X4:term, auto___def_22 nil -> auto___def_26 X3 -> auto___def_7 X2 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_3 X1 -> auto___type_3 X1). tauto. exact (rem_199 X1).
Qed.

Remark rem_1713 : forall X1 X2 X3 X4:term, auto___def_22 nil -> auto___def_26 X3 -> auto___def_7 X2 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_3 X1 -> auto_agent X1). tauto. exact (rem_392 X1).
Qed.

Remark rem_1714 : forall X1 X2 X3 X4:term, auto___def_22 nil -> auto___def_26 X3 -> auto___def_7 X2 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_7 X2 -> auto___def_7 X2). tauto. exact (rem_394 X2).
Qed.

Remark rem_1715 : forall X1 X2 X3 X4:term, auto___def_22 nil -> auto___def_26 X3 -> auto___def_7 X2 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_7 X2 -> auto_agent X2). tauto. exact (rem_399 X2).
Qed.

Remark rem_1716 : forall X1 X2 X3 X4:term, auto___def_22 nil -> auto___def_26 X3 -> auto___def_7 X2 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_26 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_26 X3 -> auto___def_26 X3). tauto. exact (rem_1630 X3).
Qed.

Remark rem_1717 : forall X1 X2 X3 X4:term, auto___def_22 nil -> auto___def_26 X3 -> auto___def_7 X2 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_2 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_2 X4 -> auto___type_2 X4). tauto. exact (rem_1632 X4).
Qed.

Remark rem_1718 : forall X1 X2 X3 X4:term, auto___def_22 nil -> auto___def_26 X3 -> auto___def_7 X2 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> (auto___type_3 X1 /\ auto_agent X1 /\ auto___def_7 X2 /\ auto_agent X2 /\ auto___def_26 X3 /\ auto___type_2 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto___type_3 X1). 2:apply (rem_1712 X1 X2 X3 X4);  assumption.
  cut (auto_agent X1). 2:apply (rem_1713 X1 X2 X3 X4);  assumption.
  cut (auto___def_7 X2). 2:apply (rem_1714 X1 X2 X3 X4);  assumption.
  cut (auto_agent X2). 2:apply (rem_1715 X1 X2 X3 X4);  assumption.
  cut (auto___def_26 X3). 2:apply (rem_1716 X1 X2 X3 X4);  assumption.
  cut (auto___type_2 X4). 2:apply (rem_1717 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_1719 : forall X1 X2 X3 X4:term, auto___def_22 nil -> auto___def_26 X3 -> auto___def_7 X2 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_1718 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_29_3;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_1720 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto___def_22 nil -> auto___def_26 X3 -> auto___def_7 X2 -> auto___type_2 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_22 nil -> auto___def_26 X3 -> auto___def_7 X2 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1719 X1 X2 X3 X4).
Qed.

Remark rem_1721 : forall X1 X2 X3 X4:term, auto___def_21 (cons X1 nil) -> auto___def_26 X3 -> auto___def_7 X2 -> auto___type_2 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_206 X1 nil H);  intros.
  apply (rem_1720 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1722 : forall X1 X2 X3 X4:term, auto___type_2 X4 -> auto___def_21 (cons X1 nil) -> auto___def_26 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_21 (cons X1 nil) -> auto___def_26 X3 -> auto___def_7 X2 -> auto___type_2 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1721 X1 X2 X3 X4).
Qed.

Remark rem_1723 : forall X1 X2 X3 X4:term, auto___def_19 (cons X4 (cons X1 nil)) -> auto___def_26 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_209 X4 (cons X1 nil) H);  intros.
  apply (rem_1722 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1724 : forall X1 X2 X3 X4:term, auto___def_19 (cons X4 (cons X1 nil)) -> auto___def_20 (key prv server) -> auto___def_26 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_19 (cons X4 (cons X1 nil)) -> auto___def_26 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1723 X1 X2 X3 X4).
Qed.

Remark rem_1725 : forall X1 X2 X3 X4:term, auto___def_26 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key prv server) -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old (key prv server) -> False). tauto.
  exact (rem_216).
Qed.

Remark rem_1726 : forall X1 X2 X3 X4:term, auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key prv server) -> auto___def_26 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_26 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key prv server) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1725 X1 X2 X3 X4).
Qed.

Remark rem_1727 : forall X1 X2 X3 X4:term, auto___def_26 X3 -> auto___def_32 X1 -> auto___def_33 nil -> auto___def_7 X2 -> auto___type_7 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_1666 X1)). tauto.
Qed.

Remark rem_1728 : forall X1 X2 X3 X4:term, auto___def_32 X1 -> auto___def_33 nil -> auto___def_26 X3 -> auto___def_7 X2 -> auto___type_7 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_26 X3 -> auto___def_32 X1 -> auto___def_33 nil -> auto___def_7 X2 -> auto___type_7 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1727 X1 X2 X3 X4).
Qed.

Remark rem_1729 : forall X1 X2 X3 X4:term, auto___def_26 X3 -> auto___def_31 (cons X1 nil) -> auto___def_7 X2 -> auto___type_7 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_221 X1 nil H);  intros.
  apply (rem_1728 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1730 : forall X1 X2 X3 X4:term, auto___type_7 X4 -> auto___def_31 (cons X1 nil) -> auto___def_26 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_26 X3 -> auto___def_31 (cons X1 nil) -> auto___def_7 X2 -> auto___type_7 X4 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1729 X1 X2 X3 X4).
Qed.

Remark rem_1731 : forall X1 X2 X3 X4:term, auto___def_26 X3 -> auto___def_30 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_224 X4 (cons X1 nil) H);  intros.
  apply (rem_1730 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1732 : forall X1 X2 X3 X4:term, auto___def_26 X3 -> auto___def_30 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_6 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_26 X3 -> auto___def_30 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1731 X1 X2 X3 X4).
Qed.

Remark rem_1733 : forall X1 X2 X3 X4:term, auto___def_30 (cons X4 (cons X1 nil)) -> auto___type_6 (key prv server) -> auto___def_26 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_26 X3 -> auto___def_30 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_6 (key prv server) -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1732 X1 X2 X3 X4).
Qed.

Remark rem_1734 : forall X1 X2 X3 X4:term, auto___def_26 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_182 (cons X4 (cons X1 nil)) (key prv server) H);  intros.
  apply (rem_1709 X1 X2 X3 X4);  tauto.
  apply (rem_1711 X1 X2 X3 X4);  tauto.
  apply (rem_1724 X1 X2 X3 X4);  tauto.
  apply (rem_1726 X1 X2 X3 X4);  tauto.
  apply (rem_1733 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1735 : forall X1 X2 X3 X4:term, auto___def_26 X3 -> auto___def_3 pub -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_26 X3 -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1734 X1 X2 X3 X4).
Qed.

Remark rem_1736 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto___def_7 X2 -> auto___def_26 X3 -> auto_agent X2 -> auto_agent X1 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_26 X3 -> auto___def_3 pub -> auto___def_7 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1735 X1 X2 X3 X4).
Qed.

Remark rem_1737 : forall X1 X2 X3 X4:term, auto___def_26 X3 -> auto___type_4 (key pub X2) -> auto_agent X2 -> auto_agent X1 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_153 pub X2 H);  intros.
  apply (rem_1676 X1 X2 X3 X4);  tauto.
  apply (rem_1706 X1 X2 X3 X4);  tauto.
  apply (rem_1736 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1738 : forall X1 X2 X3 X4:term, auto___def_17 nil -> auto___def_26 X3 -> auto___type_4 (key pub X2) -> auto_agent X2 -> auto_agent X1 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_26 X3 -> auto___type_4 (key pub X2) -> auto_agent X2 -> auto_agent X1 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1737 X1 X2 X3 X4).
Qed.

Remark rem_1739 : forall X1 X2 X3 X4:term, auto_agent X1 -> auto___def_17 nil -> auto___def_26 X3 -> auto___type_4 (key pub X2) -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_17 nil -> auto___def_26 X3 -> auto___type_4 (key pub X2) -> auto_agent X2 -> auto_agent X1 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1738 X1 X2 X3 X4).
Qed.

Remark rem_1740 : forall X1 X2:term, auto___def_27 (cons X1 X2) -> or_1
    (auto_agent X1 /\ auto___def_17 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1741 : forall X1 X2 X3 X4:term, auto___def_26 X3 -> auto___def_27 (cons X1 nil) -> auto___type_4 (key pub X2) -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_1740 X1 nil H);  intros.
  apply (rem_1739 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1742 : forall X1 X2:term, auto___def_25 (cons X1 X2) -> or_1
    (auto___def_26 X1 /\ auto___def_27 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1743 : forall X1 X2 X3 X4:term, auto___def_25 (cons X3 (cons X1 nil)) -> auto___type_4 (key pub X2) -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1742 X3 (cons X1 nil) H);  intros.
  apply (rem_1741 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1744 : forall X1 X2 X3 X4:term, auto___def_32 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_190 X4 (cons X1 nil) H);  intros.
Qed.

Remark rem_1745 : forall X1 X2 X3 X4:term, auto___def_32 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_2 (key prv server) -> auto___type_3 X1 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_32 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1744 X1 X2 X3 X4).
Qed.

Remark rem_1746 : forall X1 X2 X3 X4:term, auto___def_32 (cons X4 (cons X1 nil)) -> auto___type_2 (key prv server) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_32 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_2 (key prv server) -> auto___type_3 X1 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1745 X1 X2 X3 X4).
Qed.

Remark rem_1747 : forall X1 X2 X3 X4:term, auto___def_25 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto___type_4 (key prv server) -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_4 (key prv server) -> False). tauto.
  exact (rem_197).
Qed.

Remark rem_1748 : forall X1 X2 X3 X4:term, auto___def_25 (cons X4 (cons X1 nil)) -> auto___type_4 (key prv server) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_25 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto___type_4 (key prv server) -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1747 X1 X2 X3 X4).
Qed.

Remark rem_1749 : forall X1 X2 X3 X4:term, auto___def_21 (cons X1 nil) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_3 X1 -> auto___type_3 X1). tauto. exact (rem_199 X1).
Qed.

Remark rem_1750 : forall X1 X2 X3 X4:term, auto___def_21 (cons X1 nil) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto___type_9 X2. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Qed.

Remark rem_1751 : forall X1 X2 X3 X4:term, auto___def_21 (cons X1 nil) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_7 X2 -> auto_agent X2). tauto. exact (rem_399 X2).
Qed.

Remark rem_1752 : forall X3:term, auto___type_2 X3 -> auto_knows_old X3. (* Induct. *)
Proof.
  fix epsilon_m__type_2_pknows_old 1.
  intro X. case X.
   intro H. elim (rem_1459  H).
   intro H. elim (rem_1457  H).
  intros X1 X2. intro H. elim (rem_1455 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1456 X1 X2 H).
   intro H. elim (rem_1451  H).
   intro H. elim (rem_1463  H).
  intros X1 X2;  exact (rem_1448 epsilon_m__type_2_pknows_old X1 X2).
   intro H. elim (rem_1450  H).
  intros X1 X2 X3. intro H. elim (rem_1454 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1458 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1462 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1460 X1 X2 X3 X4 H).
   intro H. elim (rem_1465  H).
   intro H. elim (rem_1461  H).
  intros X1. intro H. elim (rem_1449 X1 H).
   intro H. elim (rem_1464  H).
  intros X1 X2 X3. intro H. elim (rem_1452 X1 X2 X3 H).
   intro H. elim (rem_1453  H).
Qed.

Remark rem_1753 : forall X1 X2 X3 X4:term, auto___def_21 (cons X1 nil) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_knows_old X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_2 X3 -> auto_knows_old X3). tauto. exact (rem_1752 X3).
Qed.

Remark rem_1754 : forall X1 X2 X3 X4:term, auto___def_21 (cons X1 nil) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto___type_2 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_2 X4 -> auto___type_2 X4). tauto. exact (rem_1632 X4).
Qed.

Remark rem_1755 : forall X1 X2 X3 X4:term, auto___def_21 (cons X1 nil) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> (auto___type_3 X1 /\ auto___type_9 X2 /\ auto_agent X2 /\ auto_knows_old X3 /\ auto___type_2 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  cut (auto___type_3 X1). 2:apply (rem_1749 X1 X2 X3 X4);  assumption.
  cut (auto___type_9 X2). 2:apply (rem_1750 X1 X2 X3 X4);  assumption.
  cut (auto_agent X2). 2:apply (rem_1751 X1 X2 X3 X4);  assumption.
  cut (auto_knows_old X3). 2:apply (rem_1753 X1 X2 X3 X4);  assumption.
  cut (auto___type_2 X4). 2:apply (rem_1754 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_1756 : forall X1 X2 X3 X4:term, auto___def_21 (cons X1 nil) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  case (rem_1755 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6). clear  A1 A2 A3 A4 A5 A6. intros. apply trans___def_29_2;  tauto.
 clear  A1 A2 A3 A4 A5 A6. tauto.
Qed.

Remark rem_1757 : forall X1 X2 X3 X4:term, auto___type_2 X4 -> auto___def_21 (cons X1 nil) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_21 (cons X1 nil) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1756 X1 X2 X3 X4).
Qed.

Remark rem_1758 : forall X1 X2 X3 X4:term, auto___def_19 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_209 X4 (cons X1 nil) H);  intros.
  apply (rem_1757 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1759 : forall X1 X2 X3 X4:term, auto___def_19 (cons X4 (cons X1 nil)) -> auto___def_20 (key prv server) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_19 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1758 X1 X2 X3 X4).
Qed.

Remark rem_1760 : forall X1 X2 X3 X4:term, auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key prv server) -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old (key prv server) -> False). tauto.
  exact (rem_216).
Qed.

Remark rem_1761 : forall X1 X2 X3 X4:term, auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key prv server) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key prv server) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1760 X1 X2 X3 X4).
Qed.

Remark rem_1762 : (forall X:term, auto___def_32 X -> auto___type_3 X -> False)
    -> forall X1 X2 X3 X4:term, auto___type_3 (nonceb_old X1 X2 X3 X4) -> auto___type_3 X1 -> auto_agent X1 -> auto___def_5 X2 -> auto_agent X2 -> auto___type_2 X3 -> auto___def_26 X4 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_32_m__type_3. intros X1 X2 X3 X4. intro H. intros.
  elim (rem_387 X1 X2 X3 X4 H);  intros.
Defined.

Remark rem_1763 : (forall X:term, auto___def_32 X -> auto___type_3 X -> False)
    -> forall X1 X2 X3 X4:term, auto___type_3 (nonceb_old X1 X2 X3 X4) -> auto___type_3 X1 -> auto_agent X1 -> auto_agent X2 -> auto___def_2 X2 -> auto___type_2 X3 -> auto___def_26 X4 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_32_m__type_3. intros X1 X2 X3 X4. intro H. intros.
  elim (rem_387 X1 X2 X3 X4 H);  intros.
Defined.

Remark rem_1764 : (forall X:term, auto___def_32 X -> auto___type_3 X -> False)
    -> forall X1 X2 X3 X4:term, auto___type_3 (nonceb_old X1 X2 X3 X4) -> auto___type_3 X1 -> auto___type_9 X2 -> auto_agent X2 -> auto___type_2 X3 -> auto_knows_old X4 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_32_m__type_3. intros X1 X2 X3 X4. intro H. intros.
  elim (rem_387 X1 X2 X3 X4 H);  intros.
Defined.

Remark rem_1765 : (forall X:term, auto___def_32 X -> auto___type_3 X -> False)
    -> forall X1 X2 X3 X4:term, auto___type_3 (nonceb_old X1 X2 X3 X4) -> auto___type_3 X1 -> auto_agent X1 -> auto___def_7 X2 -> auto_agent X2 -> auto___type_2 X3 -> auto___def_26 X4 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_32_m__type_3. intros X1 X2 X3 X4. intro H. intros.
  elim (rem_387 X1 X2 X3 X4 H);  intros.
Defined.

Remark rem_1766 : (forall X:term, auto___def_32 X -> auto___type_3 X -> False)
    -> forall X1 X2 X3 X4:term, auto___def_32 (nonceb_old X1 X2 X3 X4) -> auto___type_3 (nonceb_old X1 X2 X3 X4) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_32_m__type_3. intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1648 X1 X2 X3 X4 H);  intros.
  apply (rem_1762 epsilon_m__def_32_m__type_3 X1 X2 X3 X4);  tauto.
  apply (rem_1763 epsilon_m__def_32_m__type_3 X1 X2 X3 X4);  tauto.
  apply (rem_1764 epsilon_m__def_32_m__type_3 X1 X2 X3 X4);  tauto.
  apply (rem_1765 epsilon_m__def_32_m__type_3 X1 X2 X3 X4);  tauto.
Defined.

Remark rem_1767 : forall X1:term, auto___def_32 X1 -> auto___type_3 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_32_m__type_3 1.
  intro X. case X.
   intro H. elim (rem_1660  H).
   intro H. elim (rem_1658  H).
  intros X1 X2. intro H. elim (rem_190 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1656 X1 X2 H).
   intro H. elim (rem_1652  H).
   intro H. elim (rem_1663  H).
  intros X1 X2. intro H. elim (rem_1657 X1 X2 H).
   intro H. elim (rem_1651  H).
  intros X1 X2 X3. intro H. elim (rem_1655 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1659 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1662 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4;  exact (rem_1766 epsilon_m__def_32_m__type_3 X1 X2 X3 X4).
   intro H. elim (rem_1665  H).
   intro H. elim (rem_1661  H).
  intros X1. intro H. elim (rem_1650 X1 H).
   intro H. elim (rem_1664  H).
  intros X1 X2 X3. intro H. elim (rem_1653 X1 X2 X3 H).
   intro H. elim (rem_1654  H).
Qed.

Remark rem_1768 : forall X1 X2 X3 X4:term, auto___def_32 X1 -> auto___def_33 nil -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto___type_7 X4 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_1767 X1)). tauto.
Qed.

Remark rem_1769 : forall X1 X2 X3 X4:term, auto___def_31 (cons X1 nil) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto___type_7 X4 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_221 X1 nil H);  intros.
  apply (rem_1768 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1770 : forall X1 X2 X3 X4:term, auto___type_7 X4 -> auto___def_31 (cons X1 nil) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_31 (cons X1 nil) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto___type_7 X4 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1769 X1 X2 X3 X4).
Qed.

Remark rem_1771 : forall X1 X2 X3 X4:term, auto___def_30 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_224 X4 (cons X1 nil) H);  intros.
  apply (rem_1770 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1772 : forall X1 X2 X3 X4:term, auto___def_30 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto___type_6 (key prv server) -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_30 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1771 X1 X2 X3 X4).
Qed.

Remark rem_1773 : forall X1 X2 X3 X4:term, auto___def_30 (cons X4 (cons X1 nil)) -> auto___type_6 (key prv server) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_30 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto___type_6 (key prv server) -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1772 X1 X2 X3 X4).
Qed.

Remark rem_1774 : forall X1 X2 X3 X4:term, auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_182 (cons X4 (cons X1 nil)) (key prv server) H);  intros.
  apply (rem_1746 X1 X2 X3 X4);  tauto.
  apply (rem_1748 X1 X2 X3 X4);  tauto.
  apply (rem_1759 X1 X2 X3 X4);  tauto.
  apply (rem_1761 X1 X2 X3 X4);  tauto.
  apply (rem_1773 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1775 : forall X1 X2 X3 X4:term, auto___def_22 nil -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1774 X1 X2 X3 X4).
Qed.

Remark rem_1776 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto___def_22 nil -> auto___def_7 X2 -> auto___type_2 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_22 nil -> auto___def_7 X2 -> auto___type_2 X3 -> auto___type_3 X1 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1775 X1 X2 X3 X4).
Qed.

Remark rem_1777 : forall X1 X2 X3 X4:term, auto___def_21 (cons X1 nil) -> auto___def_7 X2 -> auto___type_2 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_206 X1 nil H);  intros.
  apply (rem_1776 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1778 : forall X1 X2 X3 X4:term, auto___def_21 (cons X1 nil) -> auto___def_23 pub -> auto___def_7 X2 -> auto___type_2 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_21 (cons X1 nil) -> auto___def_7 X2 -> auto___type_2 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1777 X1 X2 X3 X4).
Qed.

Remark rem_1779 : forall X1 X2 X3 X4:term, auto___def_23 pub -> auto___def_7 X2 -> auto___def_21 (cons X1 nil) -> auto___type_2 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_21 (cons X1 nil) -> auto___def_23 pub -> auto___def_7 X2 -> auto___type_2 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1778 X1 X2 X3 X4).
Qed.

Remark rem_1780 : forall X1 X2 X3 X4:term, auto___def_20 (key pub X2) -> auto___def_21 (cons X1 nil) -> auto___type_2 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_162 pub X2 H);  intros.
  apply (rem_1779 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1781 : forall X1 X2 X3 X4:term, auto___type_2 X3 -> auto___def_21 (cons X1 nil) -> auto___def_20 (key pub X2) -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_20 (key pub X2) -> auto___def_21 (cons X1 nil) -> auto___type_2 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1780 X1 X2 X3 X4).
Qed.

Remark rem_1782 : forall X1 X2 X3 X4:term, auto___def_19 (cons X3 (cons X1 nil)) -> auto___def_20 (key pub X2) -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_209 X3 (cons X1 nil) H);  intros.
  apply (rem_1781 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1783 : forall X1 X2 X3 X4:term, auto___def_32 (cons X4 (cons X1 nil)) -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_190 X4 (cons X1 nil) H);  intros.
Qed.

Remark rem_1784 : forall X1 X2 X3 X4:term, auto___def_32 (cons X4 (cons X1 nil)) -> auto___type_2 (key prv server) -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_32 (cons X4 (cons X1 nil)) -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1783 X1 X2 X3 X4).
Qed.

Remark rem_1785 : forall X1 X2 X3 X4:term, auto___def_25 (cons X4 (cons X1 nil)) -> auto___type_4 (key prv server) -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_4 (key prv server) -> False). tauto.
  exact (rem_197).
Qed.

Remark rem_1786 : forall X1 X2 X3 X4:term, auto___def_22 nil -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (key pub X2) -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_3 X1 -> auto___type_3 X1). tauto. exact (rem_199 X1).
Qed.

Remark rem_1787 : forall X1 X2 X3 X4:term, auto___def_22 nil -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (key pub X2) -> auto___type_9 X2. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Qed.

Remark rem_1788 : forall X1 X2 X3 X4:term, auto___def_22 nil -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (key pub X2) -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_272 X2).
Qed.

Remark rem_1789 : forall X3:term, auto_knows_old X3 -> auto_knows_old X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1790 : forall X1 X2 X3 X4:term, auto___def_22 nil -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (key pub X2) -> auto_knows_old X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old X3 -> auto_knows_old X3). tauto. exact (rem_1789 X3).
Qed.

Remark rem_1791 : forall X1 X2 X3 X4:term, auto___def_22 nil -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (key pub X2) -> auto___type_2 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_2 X4 -> auto___type_2 X4). tauto. exact (rem_1632 X4).
Qed.

Remark rem_1792 : forall X1 X2 X3 X4:term, auto___def_22 nil -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (key pub X2) -> (auto___type_3 X1 /\ auto___type_9 X2 /\ auto_agent X2 /\ auto_knows_old X3 /\ auto___type_2 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto___type_3 X1). 2:apply (rem_1786 X1 X2 X3 X4);  assumption.
  cut (auto___type_9 X2). 2:apply (rem_1787 X1 X2 X3 X4);  assumption.
  cut (auto_agent X2). 2:apply (rem_1788 X1 X2 X3 X4);  assumption.
  cut (auto_knows_old X3). 2:apply (rem_1790 X1 X2 X3 X4);  assumption.
  cut (auto___type_2 X4). 2:apply (rem_1791 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_1793 : forall X1 X2 X3 X4:term, auto___def_22 nil -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_1792 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_29_2;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_1794 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto___def_22 nil -> auto___type_2 X4 -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_22 nil -> auto___type_2 X4 -> auto___type_3 X1 -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1793 X1 X2 X3 X4).
Qed.

Remark rem_1795 : forall X1 X2 X3 X4:term, auto___def_21 (cons X1 nil) -> auto___type_2 X4 -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_206 X1 nil H);  intros.
  apply (rem_1794 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1796 : forall X1 X2 X3 X4:term, auto___type_2 X4 -> auto___def_21 (cons X1 nil) -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_21 (cons X1 nil) -> auto___type_2 X4 -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1795 X1 X2 X3 X4).
Qed.

Remark rem_1797 : forall X1 X2 X3 X4:term, auto___def_19 (cons X4 (cons X1 nil)) -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_209 X4 (cons X1 nil) H);  intros.
  apply (rem_1796 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1798 : forall X1 X2 X3 X4:term, auto___def_19 (cons X4 (cons X1 nil)) -> auto___def_20 (key prv server) -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_19 (cons X4 (cons X1 nil)) -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1797 X1 X2 X3 X4).
Qed.

Remark rem_1799 : forall X1 X2 X3 X4:term, auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key prv server) -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old (key prv server) -> False). tauto.
  exact (rem_216).
Qed.

Remark rem_1800 : forall X1 X2 X3 X4:term, auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key prv server) -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key prv server) -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1799 X1 X2 X3 X4).
Qed.

Remark rem_1801 : (forall X:term, auto_knows_old X -> auto___def_32 X -> False)
    -> forall X1:term, auto___def_32 (s X1) -> auto_knows_old X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_32. intros X1. intro H. intros.
  elim (rem_1650 X1 H);  intros.
Defined.

Remark rem_1802 : (forall X:term, auto_knows_old X -> auto___def_32 X -> False)
    -> forall X1:term, auto_knows_old (s X1) -> auto___def_32 (s X1) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_32. intros X1. intro H. intros.
  elim (rem_1315 X1 H);  intros.
  apply (rem_1801 epsilon_mknows_old_m__def_32 X1);  tauto.
Defined.

Remark rem_1803 : (forall X:term, auto_knows_old X -> auto___def_32 X -> False)
    -> auto___def_32 nil -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_32. intro H. intros.
  elim (rem_1651 H);  intros.
Defined.

Remark rem_1804 : (forall X:term, auto_knows_old X -> auto___def_32 X -> False)
    -> auto_knows_old nil -> auto___def_32 nil -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_32. intro H. intros.
  elim (rem_1319 H);  intros.
  apply (rem_1803 epsilon_mknows_old_m__def_32);  tauto.
Defined.

Remark rem_1805 : (forall X:term, auto_knows_old X -> auto___def_32 X -> False)
    -> auto___def_32 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_32. intro H. intros.
  elim (rem_1652 H);  intros.
Defined.

Remark rem_1806 : (forall X:term, auto_knows_old X -> auto___def_32 X -> False)
    -> auto_knows_old i -> auto___def_32 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_32. intro H. intros.
  elim (rem_1322 H);  intros.
  apply (rem_1805 epsilon_mknows_old_m__def_32);  tauto.
Defined.

Remark rem_1807 : (forall X:term, auto_knows_old X -> auto___def_32 X -> False)
    -> forall X1 X2:term, auto___def_32 (cons X1 X2) -> auto_knows_old X1 -> auto_knows_old X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_32. intros X1 X2. intro H. intros.
  elim (rem_190 X1 X2 H);  intros.
Defined.

Remark rem_1808 : (forall X:term, auto_knows_old X -> auto___def_32 X -> False)
    -> forall X1 X2:term, auto_knows_old (cons X1 X2) -> auto___def_32 (cons X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_32. intros X1 X2. intro H. intros.
  elim (rem_1329 X1 X2 H);  intros.
  apply (rem_1807 epsilon_mknows_old_m__def_32 X1 X2);  tauto.
Defined.

Remark rem_1809 : (forall X:term, auto_knows_old X -> auto___def_32 X -> False)
    -> forall X1 X2:term, auto___def_32 (crypt X1 X2) -> auto___def_32 X1 -> auto___type_2 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_32. intros X1 X2. intro H. intros.
  elim (rem_1656 X1 X2 H);  intros.
Defined.

Remark rem_1810 : (forall X:term, auto_knows_old X -> auto___def_32 X -> False)
    -> forall X1 X2:term, auto___def_32 (crypt X1 X2) -> auto___def_25 X1 -> auto___type_4 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_32. intros X1 X2. intro H. intros.
  elim (rem_1656 X1 X2 H);  intros.
Defined.

Remark rem_1811 : (forall X:term, auto_knows_old X -> auto___def_32 X -> False)
    -> forall X1 X2:term, auto___def_32 (crypt X1 X2) -> auto___def_19 X1 -> auto___def_20 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_32. intros X1 X2. intro H. intros.
  elim (rem_1656 X1 X2 H);  intros.
Defined.

Remark rem_1812 : (forall X:term, auto_knows_old X -> auto___def_32 X -> False)
    -> forall X1 X2:term, auto___def_32 (crypt X1 X2) -> auto_knows_old X1 -> auto_knows_old X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_32. intros X1 X2. intro H. intros.
  elim (rem_1656 X1 X2 H);  intros.
Defined.

Remark rem_1813 : (forall X:term, auto_knows_old X -> auto___def_32 X -> False)
    -> forall X1 X2:term, auto___def_32 (crypt X1 X2) -> auto___def_30 X1 -> auto___type_6 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_32. intros X1 X2. intro H. intros.
  elim (rem_1656 X1 X2 H);  intros.
Defined.

Remark rem_1814 : (forall X:term, auto_knows_old X -> auto___def_32 X -> False)
    -> forall X1 X2:term, auto_knows_old (crypt X1 X2) -> auto___def_32 (crypt X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_32. intros X1 X2. intro H. intros.
  elim (rem_182 X1 X2 H);  intros.
  apply (rem_1809 epsilon_mknows_old_m__def_32 X1 X2);  tauto.
  apply (rem_1810 epsilon_mknows_old_m__def_32 X1 X2);  tauto.
  apply (rem_1811 epsilon_mknows_old_m__def_32 X1 X2);  tauto.
  apply (rem_1812 epsilon_mknows_old_m__def_32 X1 X2);  tauto.
  apply (rem_1813 epsilon_mknows_old_m__def_32 X1 X2);  tauto.
Defined.

Remark rem_1815 : (forall X:term, auto_knows_old X -> auto___def_32 X -> False)
    -> forall X1 X2:term, auto___def_32 (key X1 X2) -> auto___def_23 X1 -> auto___def_36 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_32. intros X1 X2. intro H. intros.
  elim (rem_1657 X1 X2 H);  intros.
Defined.

Remark rem_1816 : (forall X:term, auto_knows_old X -> auto___def_32 X -> False)
    -> forall X1 X2:term, auto___def_32 (key X1 X2) -> auto___def_3 X1 -> auto___type_9 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_32. intros X1 X2. intro H. intros.
  elim (rem_1657 X1 X2 H);  intros.
Defined.

Remark rem_1817 : (forall X:term, auto_knows_old X -> auto___def_32 X -> False)
    -> forall X1 X2:term, auto_knows_old (key X1 X2) -> auto___def_32 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_32. intros X1 X2. intro H. intros.
  elim (rem_172 X1 X2 H);  intros.
  apply (rem_1815 epsilon_mknows_old_m__def_32 X1 X2);  tauto.
  apply (rem_1816 epsilon_mknows_old_m__def_32 X1 X2);  tauto.
Defined.

Remark rem_1818 : (forall X:term, auto_knows_old X -> auto___def_32 X -> False)
    -> auto___def_32 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_32. intro H. intros.
  elim (rem_1658 H);  intros.
Defined.

Remark rem_1819 : (forall X:term, auto_knows_old X -> auto___def_32 X -> False)
    -> auto_knows_old bob -> auto___def_32 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_32. intro H. intros.
  elim (rem_1371 H);  intros.
  apply (rem_1818 epsilon_mknows_old_m__def_32);  tauto.
Defined.

Remark rem_1820 : (forall X:term, auto_knows_old X -> auto___def_32 X -> False)
    -> auto___def_32 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_32. intro H. intros.
  elim (rem_1660 H);  intros.
Defined.

Remark rem_1821 : (forall X:term, auto_knows_old X -> auto___def_32 X -> False)
    -> auto_knows_old alice -> auto___def_32 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_32. intro H. intros.
  elim (rem_1374 H);  intros.
  apply (rem_1820 epsilon_mknows_old_m__def_32);  tauto.
Defined.

Remark rem_1822 : (forall X:term, auto_knows_old X -> auto___def_32 X -> False)
    -> auto___def_32 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_32. intro H. intros.
  elim (rem_1664 H);  intros.
Defined.

Remark rem_1823 : (forall X:term, auto_knows_old X -> auto___def_32 X -> False)
    -> auto_knows_old server -> auto___def_32 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_32. intro H. intros.
  elim (rem_1377 H);  intros.
  apply (rem_1822 epsilon_mknows_old_m__def_32);  tauto.
Defined.

Remark rem_1824 : forall X1:term, auto_knows_old X1 -> auto___def_32 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_mknows_old_m__def_32 1.
  intro X. case X.
  exact (rem_1821 epsilon_mknows_old_m__def_32 ).
  exact (rem_1819 epsilon_mknows_old_m__def_32 ).
  intros X1 X2;  exact (rem_1808 epsilon_mknows_old_m__def_32 X1 X2).
  intros X1 X2;  exact (rem_1814 epsilon_mknows_old_m__def_32 X1 X2).
  exact (rem_1806 epsilon_mknows_old_m__def_32 ).
   intro H. elim (rem_1386  H).
  intros X1 X2;  exact (rem_1817 epsilon_mknows_old_m__def_32 X1 X2).
  exact (rem_1804 epsilon_mknows_old_m__def_32 ).
  intros X1 X2 X3. intro H. elim (rem_1381 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1382 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1385 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1383 X1 X2 X3 X4 H).
   intro H. elim (rem_1387  H).
   intro H. elim (rem_1384  H).
  intros X1;  exact (rem_1802 epsilon_mknows_old_m__def_32 X1).
  exact (rem_1823 epsilon_mknows_old_m__def_32 ).
  intros X1 X2 X3. intro H. elim (rem_1379 X1 X2 X3 H).
   intro H. elim (rem_1380  H).
Qed.

Remark rem_1825 : forall X1 X2 X3 X4:term, auto___def_32 X1 -> auto___def_33 nil -> auto___type_7 X4 -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_1824 X1)). tauto.
Qed.

Remark rem_1826 : forall X1 X2 X3 X4:term, auto___def_31 (cons X1 nil) -> auto___type_7 X4 -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_221 X1 nil H);  intros.
  apply (rem_1825 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1827 : forall X1 X2 X3 X4:term, auto___type_7 X4 -> auto___def_31 (cons X1 nil) -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_31 (cons X1 nil) -> auto___type_7 X4 -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1826 X1 X2 X3 X4).
Qed.

Remark rem_1828 : forall X1 X2 X3 X4:term, auto___def_30 (cons X4 (cons X1 nil)) -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_224 X4 (cons X1 nil) H);  intros.
  apply (rem_1827 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1829 : forall X1 X2 X3 X4:term, auto___def_30 (cons X4 (cons X1 nil)) -> auto___type_6 (key prv server) -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_30 (cons X4 (cons X1 nil)) -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1828 X1 X2 X3 X4).
Qed.

Remark rem_1830 : forall X1 X2 X3 X4:term, auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3. intro H. intros.
  elim (rem_182 (cons X4 (cons X1 nil)) (key prv server) H);  intros.
  apply (rem_1784 X1 X2 X3 X4);  tauto.
  apply (rem_1785 X1 X2 X3 X4);  tauto.
  apply (rem_1798 X1 X2 X3 X4);  tauto.
  apply (rem_1800 X1 X2 X3 X4);  tauto.
  apply (rem_1829 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1831 : forall X1 X2 X3 X4:term, auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto_knows_old (key pub X2) -> auto_knows_old nil -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1830 X1 X2 X3 X4).
Qed.

Remark rem_1832 : forall X1 X2 X3 X4:term, auto_knows_old X1 -> auto_knows_old nil -> auto_agent X2 -> auto_knows_old X3 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_agent X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto_knows_old (key pub X2) -> auto_knows_old nil -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1831 X1 X2 X3 X4).
Qed.

Remark rem_1833 : forall X1 X2 X3 X4:term, auto_agent X2 -> auto_knows_old X3 -> auto_knows_old (cons X1 nil) -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_1329 X1 nil H);  intros.
  apply (rem_1832 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1834 : forall X1 X2 X3 X4:term, auto_knows_old X3 -> auto_knows_old (cons X1 nil) -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_agent X2 -> auto_knows_old X3 -> auto_knows_old (cons X1 nil) -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1833 X1 X2 X3 X4).
Qed.

Remark rem_1835 : forall X1 X2 X3 X4:term, auto_agent X2 -> auto_knows_old (cons X3 (cons X1 nil)) -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_1329 X3 (cons X1 nil) H);  intros.
  apply (rem_1834 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1836 : forall X1 X2 X3 X4:term, auto_knows_old (cons X3 (cons X1 nil)) -> auto_knows_old (key pub X2) -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_agent X2 -> auto_knows_old (cons X3 (cons X1 nil)) -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto_knows_old (key pub X2) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1835 X1 X2 X3 X4).
Qed.

Remark rem_1837 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_32 X1 -> auto___def_32 (cons X4 (cons X1 nil)) -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_190 X4 (cons X1 nil) H);  intros.
Qed.

Remark rem_1838 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_32 X1 -> auto___def_32 (cons X4 (cons X1 nil)) -> auto___type_2 (key prv server) -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_32 X1 -> auto___def_32 (cons X4 (cons X1 nil)) -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1837 X1 X2 X3 X4).
Qed.

Remark rem_1839 : forall X1 X2 X3 X4:term, auto___def_32 (cons X4 (cons X1 nil)) -> auto___type_2 (key prv server) -> auto___def_2 X2 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_32 X1 -> auto___def_32 (cons X4 (cons X1 nil)) -> auto___type_2 (key prv server) -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1838 X1 X2 X3 X4).
Qed.

Remark rem_1840 : forall X1 X2 X3 X4:term, auto___def_17 nil -> auto___def_2 X2 -> auto___def_26 X4 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_1666 X1)). tauto.
Qed.

Remark rem_1841 : forall X1 X2 X3 X4:term, auto_agent X1 -> auto___def_17 nil -> auto___def_2 X2 -> auto___def_26 X4 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_17 nil -> auto___def_2 X2 -> auto___def_26 X4 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1840 X1 X2 X3 X4).
Qed.

Remark rem_1842 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_26 X4 -> auto___def_27 (cons X1 nil) -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_1740 X1 nil H);  intros.
  apply (rem_1841 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1843 : forall X1 X2 X3 X4:term, auto___def_26 X4 -> auto___def_27 (cons X1 nil) -> auto___def_2 X2 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_26 X4 -> auto___def_27 (cons X1 nil) -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1842 X1 X2 X3 X4).
Qed.

Remark rem_1844 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_25 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_1742 X4 (cons X1 nil) H);  intros.
  apply (rem_1843 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1845 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_25 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___type_4 (key prv server) -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_25 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1844 X1 X2 X3 X4).
Qed.

Remark rem_1846 : forall X1 X2 X3 X4:term, auto___def_25 (cons X4 (cons X1 nil)) -> auto___type_4 (key prv server) -> auto___def_2 X2 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_25 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___type_4 (key prv server) -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1845 X1 X2 X3 X4).
Qed.

Remark rem_1847 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_22 nil -> auto___def_32 X1 -> auto___type_2 X4 -> auto___type_3 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_1767 X1)). tauto.
Qed.

Remark rem_1848 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto___def_22 nil -> auto___def_2 X2 -> auto___def_32 X1 -> auto___type_2 X4 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_22 nil -> auto___def_32 X1 -> auto___type_2 X4 -> auto___type_3 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1847 X1 X2 X3 X4).
Qed.

Remark rem_1849 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_21 (cons X1 nil) -> auto___def_32 X1 -> auto___type_2 X4 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_206 X1 nil H);  intros.
  apply (rem_1848 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1850 : forall X1 X2 X3 X4:term, auto___type_2 X4 -> auto___def_21 (cons X1 nil) -> auto___def_2 X2 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_21 (cons X1 nil) -> auto___def_32 X1 -> auto___type_2 X4 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1849 X1 X2 X3 X4).
Qed.

Remark rem_1851 : forall X1 X2 X3 X4:term, auto___def_19 (cons X4 (cons X1 nil)) -> auto___def_2 X2 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_209 X4 (cons X1 nil) H);  intros.
  apply (rem_1850 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1852 : forall X1 X2 X3 X4:term, auto___def_19 (cons X4 (cons X1 nil)) -> auto___def_2 X2 -> auto___def_20 (key prv server) -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_19 (cons X4 (cons X1 nil)) -> auto___def_2 X2 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1851 X1 X2 X3 X4).
Qed.

Remark rem_1853 : forall X1 X2 X3 X4:term, auto___def_19 (cons X4 (cons X1 nil)) -> auto___def_20 (key prv server) -> auto___def_2 X2 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_19 (cons X4 (cons X1 nil)) -> auto___def_2 X2 -> auto___def_20 (key prv server) -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1852 X1 X2 X3 X4).
Qed.

Remark rem_1854 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old nil -> auto___def_29 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_1824 X1)). tauto.
Qed.

Remark rem_1855 : forall X1 X2 X3 X4:term, auto_knows_old X1 -> auto_knows_old nil -> auto___def_2 X2 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old X4 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old nil -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1854 X1 X2 X3 X4).
Qed.

Remark rem_1856 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old X4 -> auto_knows_old (cons X1 nil) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4 H5. intro H. intros.
  elim (rem_1329 X1 nil H);  intros.
  apply (rem_1855 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1857 : forall X1 X2 X3 X4:term, auto_knows_old X4 -> auto_knows_old (cons X1 nil) -> auto___def_2 X2 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old X4 -> auto_knows_old (cons X1 nil) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1856 X1 X2 X3 X4).
Qed.

Remark rem_1858 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (cons X4 (cons X1 nil)) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_1329 X4 (cons X1 nil) H);  intros.
  apply (rem_1857 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1859 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key prv server) -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (cons X4 (cons X1 nil)) -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1858 X1 X2 X3 X4).
Qed.

Remark rem_1860 : forall X1 X2 X3 X4:term, auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key prv server) -> auto___def_2 X2 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key prv server) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1859 X1 X2 X3 X4).
Qed.

Remark rem_1861 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_32 X1 -> auto___def_33 nil -> auto___type_7 X3 -> auto___type_7 X4 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_33 nil -> False). tauto.
  exact (rem_219).
Qed.

Remark rem_1862 : forall X1 X2 X3 X4:term, auto___def_32 X1 -> auto___def_33 nil -> auto___def_2 X2 -> auto___def_32 X1 -> auto___type_7 X3 -> auto___type_7 X4 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_32 X1 -> auto___def_33 nil -> auto___type_7 X3 -> auto___type_7 X4 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1861 X1 X2 X3 X4).
Qed.

Remark rem_1863 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_31 (cons X1 nil) -> auto___def_32 X1 -> auto___type_7 X3 -> auto___type_7 X4 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_221 X1 nil H);  intros.
  apply (rem_1862 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1864 : forall X1 X2 X3 X4:term, auto___type_7 X4 -> auto___def_31 (cons X1 nil) -> auto___def_2 X2 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_31 (cons X1 nil) -> auto___def_32 X1 -> auto___type_7 X3 -> auto___type_7 X4 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1863 X1 X2 X3 X4).
Qed.

Remark rem_1865 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_30 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_224 X4 (cons X1 nil) H);  intros.
  apply (rem_1864 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1866 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_30 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___type_6 (key prv server) -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_30 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1865 X1 X2 X3 X4).
Qed.

Remark rem_1867 : forall X1 X2 X3 X4:term, auto___def_30 (cons X4 (cons X1 nil)) -> auto___type_6 (key prv server) -> auto___def_2 X2 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_30 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___type_6 (key prv server) -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1866 X1 X2 X3 X4).
Qed.

Remark rem_1868 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_182 (cons X4 (cons X1 nil)) (key prv server) H);  intros.
  apply (rem_1839 X1 X2 X3 X4);  tauto.
  apply (rem_1846 X1 X2 X3 X4);  tauto.
  apply (rem_1853 X1 X2 X3 X4);  tauto.
  apply (rem_1860 X1 X2 X3 X4);  tauto.
  apply (rem_1867 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1869 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_3 pub -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1868 X1 X2 X3 X4).
Qed.

Remark rem_1870 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto___def_2 X2 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X2 -> auto___def_3 pub -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1869 X1 X2 X3 X4).
Qed.

Remark rem_1871 : forall X1 X2 X3 X4:term, auto___def_32 X1 -> auto___def_32 (cons X4 (cons X1 nil)) -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_190 X4 (cons X1 nil) H);  intros.
Qed.

Remark rem_1872 : forall X1 X2 X3 X4:term, auto___def_32 X1 -> auto___def_32 (cons X4 (cons X1 nil)) -> auto___def_5 X2 -> auto___type_2 (key prv server) -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_32 X1 -> auto___def_32 (cons X4 (cons X1 nil)) -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1871 X1 X2 X3 X4).
Qed.

Remark rem_1873 : forall X1 X2 X3 X4:term, auto___def_32 (cons X4 (cons X1 nil)) -> auto___type_2 (key prv server) -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_32 X1 -> auto___def_32 (cons X4 (cons X1 nil)) -> auto___def_5 X2 -> auto___type_2 (key prv server) -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1872 X1 X2 X3 X4).
Qed.

Remark rem_1874 : forall X1 X2 X3 X4:term, auto___def_17 nil -> auto___def_26 X4 -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_1666 X1)). tauto.
Qed.

Remark rem_1875 : forall X1 X2 X3 X4:term, auto_agent X1 -> auto___def_17 nil -> auto___def_26 X4 -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_17 nil -> auto___def_26 X4 -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1874 X1 X2 X3 X4).
Qed.

Remark rem_1876 : forall X1 X2 X3 X4:term, auto___def_26 X4 -> auto___def_27 (cons X1 nil) -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_1740 X1 nil H);  intros.
  apply (rem_1875 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1877 : forall X1 X2 X3 X4:term, auto___def_25 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1742 X4 (cons X1 nil) H);  intros.
  apply (rem_1876 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1878 : forall X1 X2 X3 X4:term, auto___def_25 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_4 (key prv server) -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_25 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1877 X1 X2 X3 X4).
Qed.

Remark rem_1879 : forall X1 X2 X3 X4:term, auto___def_25 (cons X4 (cons X1 nil)) -> auto___type_4 (key prv server) -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_25 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_4 (key prv server) -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1878 X1 X2 X3 X4).
Qed.

Remark rem_1880 : forall X1 X2 X3 X4:term, auto___def_22 nil -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_2 X4 -> auto___type_3 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_1767 X1)). tauto.
Qed.

Remark rem_1881 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto___def_22 nil -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_2 X4 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_22 nil -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_2 X4 -> auto___type_3 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1880 X1 X2 X3 X4).
Qed.

Remark rem_1882 : forall X1 X2 X3 X4:term, auto___def_21 (cons X1 nil) -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_2 X4 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_206 X1 nil H);  intros.
  apply (rem_1881 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1883 : forall X1 X2 X3 X4:term, auto___type_2 X4 -> auto___def_21 (cons X1 nil) -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_21 (cons X1 nil) -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_2 X4 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1882 X1 X2 X3 X4).
Qed.

Remark rem_1884 : forall X1 X2 X3 X4:term, auto___def_19 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_209 X4 (cons X1 nil) H);  intros.
  apply (rem_1883 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1885 : forall X1 X2 X3 X4:term, auto___def_19 (cons X4 (cons X1 nil)) -> auto___def_20 (key prv server) -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_19 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1884 X1 X2 X3 X4).
Qed.

Remark rem_1886 : forall X1 X2 X3 X4:term, auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old nil -> auto___def_29 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_1824 X1)). tauto.
Qed.

Remark rem_1887 : forall X1 X2 X3 X4:term, auto_knows_old X1 -> auto_knows_old nil -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old X4 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old nil -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1886 X1 X2 X3 X4).
Qed.

Remark rem_1888 : forall X1 X2 X3 X4:term, auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old X4 -> auto_knows_old (cons X1 nil) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4 H5. intro H. intros.
  elim (rem_1329 X1 nil H);  intros.
  apply (rem_1887 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1889 : forall X1 X2 X3 X4:term, auto_knows_old X4 -> auto_knows_old (cons X1 nil) -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old X4 -> auto_knows_old (cons X1 nil) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1888 X1 X2 X3 X4).
Qed.

Remark rem_1890 : forall X1 X2 X3 X4:term, auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (cons X4 (cons X1 nil)) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_1329 X4 (cons X1 nil) H);  intros.
  apply (rem_1889 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1891 : forall X1 X2 X3 X4:term, auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key prv server) -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (cons X4 (cons X1 nil)) -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1890 X1 X2 X3 X4).
Qed.

Remark rem_1892 : forall X1 X2 X3 X4:term, auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key prv server) -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key prv server) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1891 X1 X2 X3 X4).
Qed.

Remark rem_1893 : forall X1 X2 X3 X4:term, auto___def_32 X1 -> auto___def_33 nil -> auto___def_5 X2 -> auto___type_7 X3 -> auto___type_7 X4 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_33 nil -> False). tauto.
  exact (rem_219).
Qed.

Remark rem_1894 : forall X1 X2 X3 X4:term, auto___def_32 X1 -> auto___def_33 nil -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto___type_7 X4 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_32 X1 -> auto___def_33 nil -> auto___def_5 X2 -> auto___type_7 X3 -> auto___type_7 X4 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1893 X1 X2 X3 X4).
Qed.

Remark rem_1895 : forall X1 X2 X3 X4:term, auto___def_31 (cons X1 nil) -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto___type_7 X4 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_221 X1 nil H);  intros.
  apply (rem_1894 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1896 : forall X1 X2 X3 X4:term, auto___type_7 X4 -> auto___def_31 (cons X1 nil) -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_31 (cons X1 nil) -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto___type_7 X4 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1895 X1 X2 X3 X4).
Qed.

Remark rem_1897 : forall X1 X2 X3 X4:term, auto___def_30 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_224 X4 (cons X1 nil) H);  intros.
  apply (rem_1896 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1898 : forall X1 X2 X3 X4:term, auto___def_30 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_6 (key prv server) -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_30 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1897 X1 X2 X3 X4).
Qed.

Remark rem_1899 : forall X1 X2 X3 X4:term, auto___def_30 (cons X4 (cons X1 nil)) -> auto___type_6 (key prv server) -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_30 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_6 (key prv server) -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1898 X1 X2 X3 X4).
Qed.

Remark rem_1900 : forall X1 X2 X3 X4:term, auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_182 (cons X4 (cons X1 nil)) (key prv server) H);  intros.
  apply (rem_1873 X1 X2 X3 X4);  tauto.
  apply (rem_1879 X1 X2 X3 X4);  tauto.
  apply (rem_1885 X1 X2 X3 X4);  tauto.
  apply (rem_1892 X1 X2 X3 X4);  tauto.
  apply (rem_1899 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1901 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1900 X1 X2 X3 X4).
Qed.

Remark rem_1902 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto___def_5 X2 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_3 pub -> auto___def_32 X1 -> auto___def_5 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1901 X1 X2 X3 X4).
Qed.

Remark rem_1903 : forall X1 X2 X3 X4:term, auto___def_32 X1 -> auto___def_32 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_190 X4 (cons X1 nil) H);  intros.
Qed.

Remark rem_1904 : forall X1 X2 X3 X4:term, auto___def_32 X1 -> auto___def_32 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_2 (key prv server) -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_32 X1 -> auto___def_32 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1903 X1 X2 X3 X4).
Qed.

Remark rem_1905 : forall X1 X2 X3 X4:term, auto___def_32 (cons X4 (cons X1 nil)) -> auto___type_2 (key prv server) -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_32 X1 -> auto___def_32 (cons X4 (cons X1 nil)) -> auto___def_7 X2 -> auto___type_2 (key prv server) -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1904 X1 X2 X3 X4).
Qed.

Remark rem_1906 : forall X1 X2 X3 X4:term, auto___def_17 nil -> auto___def_26 X4 -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_1666 X1)). tauto.
Qed.

Remark rem_1907 : forall X1 X2 X3 X4:term, auto_agent X1 -> auto___def_17 nil -> auto___def_26 X4 -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_17 nil -> auto___def_26 X4 -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_agent X1 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1906 X1 X2 X3 X4).
Qed.

Remark rem_1908 : forall X1 X2 X3 X4:term, auto___def_26 X4 -> auto___def_27 (cons X1 nil) -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_1740 X1 nil H);  intros.
  apply (rem_1907 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1909 : forall X1 X2 X3 X4:term, auto___def_25 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1742 X4 (cons X1 nil) H);  intros.
  apply (rem_1908 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1910 : forall X1 X2 X3 X4:term, auto___def_25 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_4 (key prv server) -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_25 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1909 X1 X2 X3 X4).
Qed.

Remark rem_1911 : forall X1 X2 X3 X4:term, auto___def_25 (cons X4 (cons X1 nil)) -> auto___type_4 (key prv server) -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_25 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_4 (key prv server) -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1910 X1 X2 X3 X4).
Qed.

Remark rem_1912 : forall X1 X2 X3 X4:term, auto___def_22 nil -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_2 X4 -> auto___type_3 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_1767 X1)). tauto.
Qed.

Remark rem_1913 : forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto___def_22 nil -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_2 X4 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_22 nil -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_2 X4 -> auto___type_3 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1912 X1 X2 X3 X4).
Qed.

Remark rem_1914 : forall X1 X2 X3 X4:term, auto___def_21 (cons X1 nil) -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_2 X4 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_206 X1 nil H);  intros.
  apply (rem_1913 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1915 : forall X1 X2 X3 X4:term, auto___type_2 X4 -> auto___def_21 (cons X1 nil) -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_21 (cons X1 nil) -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_2 X4 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1914 X1 X2 X3 X4).
Qed.

Remark rem_1916 : forall X1 X2 X3 X4:term, auto___def_19 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_209 X4 (cons X1 nil) H);  intros.
  apply (rem_1915 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1917 : forall X1 X2 X3 X4:term, auto___def_19 (cons X4 (cons X1 nil)) -> auto___def_20 (key prv server) -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_19 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1916 X1 X2 X3 X4).
Qed.

Remark rem_1918 : forall X1 X2 X3 X4:term, auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old nil -> auto___def_29 X1 X2 X3 X4. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_1824 X1)). tauto.
Qed.

Remark rem_1919 : forall X1 X2 X3 X4:term, auto_knows_old X1 -> auto_knows_old nil -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old X4 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old X4 -> auto_knows_old X1 -> auto_knows_old nil -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1918 X1 X2 X3 X4).
Qed.

Remark rem_1920 : forall X1 X2 X3 X4:term, auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old X4 -> auto_knows_old (cons X1 nil) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4 H5. intro H. intros.
  elim (rem_1329 X1 nil H);  intros.
  apply (rem_1919 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1921 : forall X1 X2 X3 X4:term, auto_knows_old X4 -> auto_knows_old (cons X1 nil) -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old X4 -> auto_knows_old (cons X1 nil) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1920 X1 X2 X3 X4).
Qed.

Remark rem_1922 : forall X1 X2 X3 X4:term, auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (cons X4 (cons X1 nil)) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_1329 X4 (cons X1 nil) H);  intros.
  apply (rem_1921 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1923 : forall X1 X2 X3 X4:term, auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key prv server) -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (cons X4 (cons X1 nil)) -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1922 X1 X2 X3 X4).
Qed.

Remark rem_1924 : forall X1 X2 X3 X4:term, auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key prv server) -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (cons X4 (cons X1 nil)) -> auto_knows_old (key prv server) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1923 X1 X2 X3 X4).
Qed.

Remark rem_1925 : forall X1 X2 X3 X4:term, auto___def_32 X1 -> auto___def_33 nil -> auto___def_7 X2 -> auto___type_7 X3 -> auto___type_7 X4 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_33 nil -> False). tauto.
  exact (rem_219).
Qed.

Remark rem_1926 : forall X1 X2 X3 X4:term, auto___def_32 X1 -> auto___def_33 nil -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto___type_7 X4 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_32 X1 -> auto___def_33 nil -> auto___def_7 X2 -> auto___type_7 X3 -> auto___type_7 X4 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1925 X1 X2 X3 X4).
Qed.

Remark rem_1927 : forall X1 X2 X3 X4:term, auto___def_31 (cons X1 nil) -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto___type_7 X4 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_221 X1 nil H);  intros.
  apply (rem_1926 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1928 : forall X1 X2 X3 X4:term, auto___type_7 X4 -> auto___def_31 (cons X1 nil) -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_31 (cons X1 nil) -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto___type_7 X4 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1927 X1 X2 X3 X4).
Qed.

Remark rem_1929 : forall X1 X2 X3 X4:term, auto___def_30 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_224 X4 (cons X1 nil) H);  intros.
  apply (rem_1928 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1930 : forall X1 X2 X3 X4:term, auto___def_30 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_6 (key prv server) -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_30 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1929 X1 X2 X3 X4).
Qed.

Remark rem_1931 : forall X1 X2 X3 X4:term, auto___def_30 (cons X4 (cons X1 nil)) -> auto___type_6 (key prv server) -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_30 (cons X4 (cons X1 nil)) -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_6 (key prv server) -> auto___type_7 X3 -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1930 X1 X2 X3 X4).
Qed.

Remark rem_1932 : forall X1 X2 X3 X4:term, auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_182 (cons X4 (cons X1 nil)) (key prv server) H);  intros.
  apply (rem_1905 X1 X2 X3 X4);  tauto.
  apply (rem_1911 X1 X2 X3 X4);  tauto.
  apply (rem_1917 X1 X2 X3 X4);  tauto.
  apply (rem_1924 X1 X2 X3 X4);  tauto.
  apply (rem_1931 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1933 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1932 X1 X2 X3 X4).
Qed.

Remark rem_1934 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto___def_7 X2 -> auto___def_32 X1 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_3 pub -> auto___def_32 X1 -> auto___def_7 X2 -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1933 X1 X2 X3 X4).
Qed.

Remark rem_1935 : forall X1 X2 X3 X4:term, auto___def_32 X1 -> auto___type_6 (key pub X2) -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_180 pub X2 H);  intros.
  apply (rem_1870 X1 X2 X3 X4);  tauto.
  apply (rem_1902 X1 X2 X3 X4);  tauto.
  apply (rem_1934 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1936 : forall X1 X2 X3 X4:term, auto___def_32 X1 -> auto___def_33 nil -> auto___type_6 (key pub X2) -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_32 X1 -> auto___type_6 (key pub X2) -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4). tauto.
  exact (rem_1935 X1 X2 X3 X4).
Qed.

Remark rem_1937 : forall X1 X2 X3 X4:term, auto___def_31 (cons X1 nil) -> auto___type_6 (key pub X2) -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_221 X1 nil H);  intros.
  apply (rem_1936 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1938 : forall X1 X2 X3 X4:term, auto___type_7 X3 -> auto___def_31 (cons X1 nil) -> auto___type_6 (key pub X2) -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_31 (cons X1 nil) -> auto___type_6 (key pub X2) -> auto___type_7 X3 -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1937 X1 X2 X3 X4).
Qed.

Remark rem_1939 : forall X1 X2 X3 X4:term, auto___def_30 (cons X3 (cons X1 nil)) -> auto___type_6 (key pub X2) -> auto_agent X2 -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_224 X3 (cons X1 nil) H);  intros.
  apply (rem_1938 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1940 : forall X1 X2 X3 X4:term, auto_agent X2 -> auto_knows_old (crypt (cons X3 (cons X1 nil)) (key pub X2)) -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_182 (cons X3 (cons X1 nil)) (key pub X2) H);  intros.
  apply (rem_1620 X1 X2 X3 X4);  tauto.
  apply (rem_1743 X1 X2 X3 X4);  tauto.
  apply (rem_1782 X1 X2 X3 X4);  tauto.
  apply (rem_1836 X1 X2 X3 X4);  tauto.
  apply (rem_1939 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1941 : forall X1 X2 X3 X4:term, auto_knows_old (crypt (cons X3 (cons X1 nil)) (key pub X2)) -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto_agent X2 -> auto___def_29 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_agent X2 -> auto_knows_old (crypt (cons X3 (cons X1 nil)) (key pub X2)) -> auto_knows_old (crypt (cons X4 (cons X1 nil)) (key prv server)) -> auto___def_29 X1 X2 X3 X4). tauto. exact (rem_1940 X1 X2 X3 X4).
Qed.

Remark rem_1942 : forall X1 X2 X3:term, auto___def_4 X2 -> auto___def_5 X1 -> auto_knows_old (cons X3 (cons X1 nil)) -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_5 X1 -> auto_knows_old X1). tauto. exact (rem_1576 X1).
Qed.

Remark rem_1943 : forall X1 X2 X3:term, auto___def_4 X2 -> auto___def_5 X1 -> auto_knows_old (cons X3 (cons X1 nil)) -> auto___def_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_5 X1 -> auto___def_5 X1). tauto. exact (rem_889 X1).
Qed.

Remark rem_1944 : forall X1 X2 X3:term, auto___def_4 X2 -> auto___def_5 X1 -> auto_knows_old (cons X3 (cons X1 nil)) -> auto___def_4 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_4 X2 -> auto___def_4 X2). tauto. exact (rem_1579 X2).
Qed.

Remark rem_1945 : forall X1 X2 X3:term, auto___def_4 X2 -> auto___def_5 X1 -> auto_knows_old (cons X3 (cons X1 nil)) -> (auto_knows_old X1 /\ auto___def_5 X1 /\ auto___def_4 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  cut (auto_knows_old X1). 2:apply (rem_1942 X1 X2 X3);  assumption.
  cut (auto___def_5 X1). 2:apply (rem_1943 X1 X2 X3);  assumption.
  cut (auto___def_4 X2). 2:apply (rem_1944 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_1946 : forall X1 X2 X3:term, auto___def_4 X2 -> auto___def_5 X1 -> auto_knows_old (cons X3 (cons X1 nil)) -> auto___def_18 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  case (rem_1945 X1 X2 X3 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_18_2;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1947 : forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1948 : forall X1 X2:term, auto___def_8 X2 -> auto___def_9 X1 -> auto_knows_old X1 -> auto_knows_old nil -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_old X1 -> auto_knows_old X1). tauto. exact (rem_1947 X1).
Qed.

Remark rem_1949 : forall X1 X2:term, auto___def_8 X2 -> auto___def_9 X1 -> auto_knows_old X1 -> auto_knows_old nil -> auto___def_9 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_9 X1 -> auto___def_9 X1). tauto. exact (rem_1583 X1).
Qed.

Remark rem_1950 : forall X1 X2:term, auto___def_8 X2 -> auto___def_9 X1 -> auto_knows_old X1 -> auto_knows_old nil -> auto___def_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_8 X2 -> auto___def_8 X2). tauto. exact (rem_1587 X2).
Qed.

Remark rem_1951 : forall X1 X2:term, auto___def_8 X2 -> auto___def_9 X1 -> auto_knows_old X1 -> auto_knows_old nil -> (auto_knows_old X1 /\ auto___def_9 X1 /\ auto___def_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3 A4.
  cut (auto_knows_old X1). 2:apply (rem_1948 X1 X2);  assumption.
  cut (auto___def_9 X1). 2:apply (rem_1949 X1 X2);  assumption.
  cut (auto___def_8 X2). 2:apply (rem_1950 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1952 : forall X1 X2:term, auto___def_8 X2 -> auto___def_9 X1 -> auto_knows_old X1 -> auto_knows_old nil -> auto___def_18 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3 A4.
  case (rem_1951 X1 X2 A1 A2 A3 A4). clear  A1 A2 A3 A4. intros. apply trans___def_18_3;  tauto.
 clear  A1 A2 A3 A4. tauto.
Qed.

Remark rem_1953 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old nil -> auto___def_8 X2 -> auto___def_9 X1 -> auto___def_18 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_8 X2 -> auto___def_9 X1 -> auto_knows_old X1 -> auto_knows_old nil -> auto___def_18 X1 X2). tauto. exact (rem_1952 X1 X2).
Qed.

Remark rem_1954 : forall X1 X2:term, auto___def_8 X2 -> auto___def_9 X1 -> auto_knows_old (cons X1 nil) -> auto___def_18 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1 H2. intro H. intros.
  elim (rem_1329 X1 nil H);  intros.
  apply (rem_1953 X1 X2);  tauto.
Qed.

Remark rem_1955 : forall X1 X2 X3:term, auto___def_8 X2 -> auto___def_9 X1 -> auto_knows_old X3 -> auto_knows_old (cons X1 nil) -> auto___def_18 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_8 X2 -> auto___def_9 X1 -> auto_knows_old (cons X1 nil) -> auto___def_18 X1 X2). tauto.
  exact (rem_1954 X1 X2).
Qed.

Remark rem_1956 : forall X1 X2 X3:term, auto_knows_old X3 -> auto_knows_old (cons X1 nil) -> auto___def_8 X2 -> auto___def_9 X1 -> auto___def_18 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_8 X2 -> auto___def_9 X1 -> auto_knows_old X3 -> auto_knows_old (cons X1 nil) -> auto___def_18 X1 X2). tauto. exact (rem_1955 X1 X2 X3).
Qed.

Remark rem_1957 : forall X1 X2 X3:term, auto___def_8 X2 -> auto___def_9 X1 -> auto_knows_old (cons X3 (cons X1 nil)) -> auto___def_18 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1 H2. intro H. intros.
  elim (rem_1329 X3 (cons X1 nil) H);  intros.
  apply (rem_1956 X1 X2 X3);  tauto.
Qed.

Remark rem_1958 : forall X1 X2 X3:term, auto___def_6 X2 -> auto___def_7 X1 -> auto_knows_old (cons X3 (cons X1 nil)) -> auto___def_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_7 X1 -> auto___def_7 X1). tauto. exact (rem_155 X1).
Qed.

Remark rem_1959 : forall X1 X2 X3:term, auto___def_6 X2 -> auto___def_7 X1 -> auto_knows_old (cons X3 (cons X1 nil)) -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_7 X1 -> auto_agent X1). tauto. exact (rem_904 X1).
Qed.

Remark rem_1960 : forall X1 X2 X3:term, auto___def_6 X2 -> auto___def_7 X1 -> auto_knows_old (cons X3 (cons X1 nil)) -> auto___def_6 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_6 X2 -> auto___def_6 X2). tauto. exact (rem_1598 X2).
Qed.

Remark rem_1961 : forall X1 X2 X3:term, auto___def_6 X2 -> auto___def_7 X1 -> auto_knows_old (cons X3 (cons X1 nil)) -> (auto___def_7 X1 /\ auto_agent X1 /\ auto___def_6 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_7 X1). 2:apply (rem_1958 X1 X2 X3);  assumption.
  cut (auto_agent X1). 2:apply (rem_1959 X1 X2 X3);  assumption.
  cut (auto___def_6 X2). 2:apply (rem_1960 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_1962 : forall X1 X2 X3:term, auto___def_6 X2 -> auto___def_7 X1 -> auto_knows_old (cons X3 (cons X1 nil)) -> auto___def_18 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  case (rem_1961 X1 X2 X3 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_18_4;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1963 : (forall X:term, auto___def_2 X -> auto_knows_old X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_2_pknows_old.  tauto.
Defined.

Remark rem_1964 : (forall X:term, auto___def_2 X -> auto_knows_old X)
    -> auto_knows_old alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_2_pknows_old.  case (rem_1963 epsilon_m__def_2_pknows_old). clear  epsilon_m__def_2_pknows_old. intros. apply trans_knows_old_alice_1;  tauto.
 clear  epsilon_m__def_2_pknows_old. tauto.
Defined.

Remark rem_1965 : (forall X:term, auto___def_2 X -> auto_knows_old X)
    -> auto___def_2 alice -> auto_knows_old alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_2_pknows_old. intro H. intros.
  elim (rem_9 H);  intros.
  apply (rem_1964 epsilon_m__def_2_pknows_old);  tauto.
Defined.

Remark rem_1966 : forall X1:term, auto___def_2 X1 -> auto_knows_old X1. (* Induct. *)
Proof.
  fix epsilon_m__def_2_pknows_old 1.
  intro X. case X.
  exact (rem_1965 epsilon_m__def_2_pknows_old ).
   intro H. elim (rem_20  H).
  intros X1 X2. intro H. elim (rem_17 X1 X2 H).
  intros X1 X2. intro H. elim (rem_18 X1 X2 H).
   intro H. elim (rem_13  H).
   intro H. elim (rem_25  H).
  intros X1 X2. intro H. elim (rem_19 X1 X2 H).
   intro H. elim (rem_12  H).
  intros X1 X2 X3. intro H. elim (rem_16 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_21 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_24 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_22 X1 X2 X3 X4 H).
   intro H. elim (rem_27  H).
   intro H. elim (rem_23  H).
  intros X1. intro H. elim (rem_11 X1 H).
   intro H. elim (rem_26  H).
  intros X1 X2 X3. intro H. elim (rem_14 X1 X2 X3 H).
   intro H. elim (rem_15  H).
Qed.

Remark rem_1967 : forall X1 X2 X3:term, auto___def_1 X2 -> auto___def_2 X1 -> auto_knows_old (cons X3 (cons X1 nil)) -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_2 X1 -> auto_knows_old X1). tauto. exact (rem_1966 X1).
Qed.

Remark rem_1968 : forall X1 X2 X3:term, auto___def_1 X2 -> auto___def_2 X1 -> auto_knows_old (cons X3 (cons X1 nil)) -> auto___def_2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_2 X1 -> auto___def_2 X1). tauto. exact (rem_866 X1).
Qed.

Remark rem_1969 : forall X1 X2 X3:term, auto___def_1 X2 -> auto___def_2 X1 -> auto_knows_old (cons X3 (cons X1 nil)) -> auto___def_1 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_1 X2 -> auto___def_1 X2). tauto. exact (rem_1608 X2).
Qed.

Remark rem_1970 : forall X1 X2 X3:term, auto___def_1 X2 -> auto___def_2 X1 -> auto_knows_old (cons X3 (cons X1 nil)) -> (auto_knows_old X1 /\ auto___def_2 X1 /\ auto___def_1 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  cut (auto_knows_old X1). 2:apply (rem_1967 X1 X2 X3);  assumption.
  cut (auto___def_2 X1). 2:apply (rem_1968 X1 X2 X3);  assumption.
  cut (auto___def_1 X2). 2:apply (rem_1969 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_1971 : forall X1 X2 X3:term, auto___def_1 X2 -> auto___def_2 X1 -> auto_knows_old (cons X3 (cons X1 nil)) -> auto___def_18 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  case (rem_1970 X1 X2 X3 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_18_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1972 : forall X1 X2 X3:term, auto_has_pub_key X2 X1 -> auto_knows_old (cons X3 (cons X1 nil)) -> auto___def_18 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1612 X2 X1 H);  intros.
  apply (rem_1946 X1 X2 X3);  tauto.
  apply (rem_1957 X1 X2 X3);  tauto.
  apply (rem_1962 X1 X2 X3);  tauto.
  apply (rem_1971 X1 X2 X3);  tauto.
Qed.

Remark rem_1973 : forall X1 X2 X3:term, auto_knows_old (cons X3 (cons X1 nil)) -> auto_has_pub_key X2 X1 -> auto___def_18 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_has_pub_key X2 X1 -> auto_knows_old (cons X3 (cons X1 nil)) -> auto___def_18 X1 X2). tauto. exact (rem_1972 X1 X2 X3).
Qed.

Remark rem_1974 : (forall X:term, auto___def_36 X -> auto___def_40 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_36_p__def_40.  tauto.
Defined.

Remark rem_1975 : (forall X:term, auto___def_36 X -> auto___def_40 X)
    -> auto___def_40 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_36_p__def_40.  case (rem_1974 epsilon_m__def_36_p__def_40). clear  epsilon_m__def_36_p__def_40. intros. apply trans___def_40_i_1;  tauto.
 clear  epsilon_m__def_36_p__def_40. tauto.
Defined.

Remark rem_1976 : (forall X:term, auto___def_36 X -> auto___def_40 X)
    -> auto___def_36 i -> auto___def_40 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_36_p__def_40. intro H. intros.
  elim (rem_1204 H);  intros.
  apply (rem_1975 epsilon_m__def_36_p__def_40);  tauto.
Defined.

Remark rem_1977 : forall X1:term, auto___def_36 X1 -> auto___def_40 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_36_p__def_40 1.
  intro X. case X.
   intro H. elim (rem_1216  H).
   intro H. elim (rem_1214  H).
  intros X1 X2. intro H. elim (rem_1211 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1212 X1 X2 H).
  exact (rem_1976 epsilon_m__def_36_p__def_40 ).
   intro H. elim (rem_1220  H).
  intros X1 X2. intro H. elim (rem_1213 X1 X2 H).
   intro H. elim (rem_1207  H).
  intros X1 X2 X3. intro H. elim (rem_1210 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1215 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1219 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1217 X1 X2 X3 X4 H).
   intro H. elim (rem_1221  H).
   intro H. elim (rem_1218  H).
  intros X1. intro H. elim (rem_1206 X1 H).
   intro H. elim (rem_212  H).
  intros X1 X2 X3. intro H. elim (rem_1208 X1 X2 X3 H).
   intro H. elim (rem_1209  H).
Qed.

Remark rem_1978 : forall X1:term, auto___def_23 prv -> auto___def_36 X1 -> auto___def_40 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1.
  cut (auto___def_36 X1 -> auto___def_40 X1). tauto. exact (rem_1977 X1).
Qed.

Remark rem_1979 : forall X1:term, auto___def_3 prv -> auto___def_40 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_3 prv -> False). tauto.
  exact (rem_138).
Qed.

Remark rem_1980 : forall X1:term, auto___def_3 prv -> auto___type_9 X1 -> auto___def_40 X1. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1. intros. apply (rem_1979 X1);  assumption.
Qed.

Remark rem_1981 : auto___def_37 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1982 : auto___def_37 prv -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_1981 H);  intros.
Qed.

Remark rem_1983 : forall X1:term, auto___def_37 prv -> auto___def_38 X1 -> auto___def_40 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_37 prv -> False). tauto.
  exact (rem_1982).
Qed.

Remark rem_1984 : forall X1:term, auto_knows_current (key prv X1) -> auto___def_40 X1. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_258 prv X1 H);  intros.
  apply (rem_1978 X1);  tauto.
  apply (rem_1980 X1);  tauto.
  apply (rem_1983 X1);  tauto.
Qed.

Remark rem_1985 : forall X1 X2:term, auto___def_3 X1 -> auto___def_9 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_932 X1).
Qed.

Remark rem_1986 : forall X2:term, auto___def_9 X2 -> auto___def_9 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1987 : forall X1 X2:term, auto___def_3 X1 -> auto___def_9 X2 -> auto___def_9 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_9 X2 -> auto___def_9 X2). tauto. exact (rem_1986 X2).
Qed.

Remark rem_1988 : forall X1 X2:term, auto___def_3 X1 -> auto___def_9 X2 -> (auto___def_3 X1 /\ auto___def_9 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_1985 X1 X2);  assumption.
  cut (auto___def_9 X2). 2:apply (rem_1987 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1989 : forall X1 X2:term, auto___def_3 X1 -> auto___def_9 X2 -> auto___def_8 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1988 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_8_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1990 : forall X1 X2:term, auto___def_9 X2 -> auto___def_3 X1 -> auto___def_8 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_9 X2 -> auto___def_8 (key X1 X2)). tauto. exact (rem_1989 X1 X2).
Qed.

Remark rem_1991 : auto___def_36 i. (* Deduce positive atom. *)
Proof.
   case rem_135. intros. apply trans___def_36_i_1;  tauto.
 tauto.
Qed.

Remark rem_1992 : forall X1:term, auto___def_57 X1 -> auto___def_57 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1993 : forall X1 X2:term, auto___def_57 X1 -> auto___def_58 X2 -> auto___def_57 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_57 X1 -> auto___def_57 X1). tauto. exact (rem_1992 X1).
Qed.

Remark rem_1994 : forall X2:term, auto___def_58 X2 -> auto___def_58 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1995 : forall X1 X2:term, auto___def_57 X1 -> auto___def_58 X2 -> auto___def_58 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_58 X2 -> auto___def_58 X2). tauto. exact (rem_1994 X2).
Qed.

Remark rem_1996 : forall X1 X2:term, auto___def_57 X1 -> auto___def_58 X2 -> (auto___def_57 X1 /\ auto___def_58 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_57 X1). 2:apply (rem_1993 X1 X2);  assumption.
  cut (auto___def_58 X2). 2:apply (rem_1995 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1997 : forall X1 X2:term, auto___def_57 X1 -> auto___def_58 X2 -> auto___def_56 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1996 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_56_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1998 : forall X1 X2:term, auto___def_58 X2 -> auto___def_57 X1 -> auto___def_56 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_57 X1 -> auto___def_58 X2 -> auto___def_56 (cons X1 X2)). tauto. exact (rem_1997 X1 X2).
Qed.

Remark rem_1999 : auto___def_3 pub. (* Deduce positive atom. *)
Proof.
   case rem_135. intros. apply trans___def_3_pub_1;  tauto.
 tauto.
Qed.

Remark rem_2000 : (forall X:term, auto___type_2 X -> auto___type_6 X)
    -> forall X1:term, auto___def_3 X1 -> auto___def_3 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2001 : (forall X:term, auto___type_2 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_p__type_6. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2000 epsilon_m__type_2_p__type_6 X1).
Defined.

Remark rem_2002 : (forall X:term, auto___type_2 X -> auto___type_6 X)
    -> forall X2:term, auto___def_2 X2 -> auto___def_2 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2003 : (forall X:term, auto___type_2 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___def_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_p__type_6. intros X1 X2.
  cut (auto___def_2 X2 -> auto___def_2 X2). tauto. exact (rem_2002 epsilon_m__type_2_p__type_6 X2).
Defined.

Remark rem_2004 : (forall X:term, auto___type_2 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> (auto___def_3 X1 /\ auto___def_2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_2_p__type_6. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2001 epsilon_m__type_2_p__type_6 X1 X2);  assumption.
  cut (auto___def_2 X2). 2:apply (rem_2003 epsilon_m__type_2_p__type_6 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2005 : (forall X:term, auto___type_2 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___type_6 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_p__type_6. intros X1 X2. intros A1 A2.
  case (rem_2004 epsilon_m__type_2_p__type_6 X1 X2 A1 A2). clear  epsilon_m__type_2_p__type_6 A1 A2. intros. apply trans___type_6_key_1;  tauto.
 clear  epsilon_m__type_2_p__type_6 A1 A2. tauto.
Defined.

Remark rem_2006 : (forall X:term, auto___type_2 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_p__type_6. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2000 epsilon_m__type_2_p__type_6 X1).
Defined.

Remark rem_2007 : (forall X:term, auto___type_2 X -> auto___type_6 X)
    -> forall X2:term, auto___def_5 X2 -> auto___def_5 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2008 : (forall X:term, auto___type_2 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___def_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_p__type_6. intros X1 X2.
  cut (auto___def_5 X2 -> auto___def_5 X2). tauto. exact (rem_2007 epsilon_m__type_2_p__type_6 X2).
Defined.

Remark rem_2009 : (forall X:term, auto___type_2 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> (auto___def_3 X1 /\ auto___def_5 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_2_p__type_6. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2006 epsilon_m__type_2_p__type_6 X1 X2);  assumption.
  cut (auto___def_5 X2). 2:apply (rem_2008 epsilon_m__type_2_p__type_6 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2010 : (forall X:term, auto___type_2 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___type_6 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_p__type_6. intros X1 X2. intros A1 A2.
  case (rem_2009 epsilon_m__type_2_p__type_6 X1 X2 A1 A2). clear  epsilon_m__type_2_p__type_6 A1 A2. intros. apply trans___type_6_key_2;  tauto.
 clear  epsilon_m__type_2_p__type_6 A1 A2. tauto.
Defined.

Remark rem_2011 : (forall X:term, auto___type_2 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_p__type_6. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2000 epsilon_m__type_2_p__type_6 X1).
Defined.

Remark rem_2012 : (forall X:term, auto___type_2 X -> auto___type_6 X)
    -> forall X2:term, auto___def_7 X2 -> auto___def_7 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2013 : (forall X:term, auto___type_2 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___def_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_p__type_6. intros X1 X2.
  cut (auto___def_7 X2 -> auto___def_7 X2). tauto. exact (rem_2012 epsilon_m__type_2_p__type_6 X2).
Defined.

Remark rem_2014 : (forall X:term, auto___type_2 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> (auto___def_3 X1 /\ auto___def_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_2_p__type_6. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2011 epsilon_m__type_2_p__type_6 X1 X2);  assumption.
  cut (auto___def_7 X2). 2:apply (rem_2013 epsilon_m__type_2_p__type_6 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2015 : (forall X:term, auto___type_2 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___type_6 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_p__type_6. intros X1 X2. intros A1 A2.
  case (rem_2014 epsilon_m__type_2_p__type_6 X1 X2 A1 A2). clear  epsilon_m__type_2_p__type_6 A1 A2. intros. apply trans___type_6_key_3;  tauto.
 clear  epsilon_m__type_2_p__type_6 A1 A2. tauto.
Defined.

Remark rem_2016 : (forall X:term, auto___type_2 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___type_2 (key X1 X2) -> auto___type_6 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_2_p__type_6. intros X1 X2. intro H. intros.
  elim (rem_145 X1 X2 H);  intros.
  apply (rem_2005 epsilon_m__type_2_p__type_6 X1 X2);  tauto.
  apply (rem_2010 epsilon_m__type_2_p__type_6 X1 X2);  tauto.
  apply (rem_2015 epsilon_m__type_2_p__type_6 X1 X2);  tauto.
Defined.

Remark rem_2017 : forall X1:term, auto___type_2 X1 -> auto___type_6 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_2_p__type_6 1.
  intro X. case X.
   intro H. elim (rem_1459  H).
   intro H. elim (rem_1457  H).
  intros X1 X2. intro H. elim (rem_1455 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1456 X1 X2 H).
   intro H. elim (rem_1451  H).
   intro H. elim (rem_1463  H).
  intros X1 X2;  exact (rem_2016 epsilon_m__type_2_p__type_6 X1 X2).
   intro H. elim (rem_1450  H).
  intros X1 X2 X3. intro H. elim (rem_1454 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1458 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1462 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1460 X1 X2 X3 X4 H).
   intro H. elim (rem_1465  H).
   intro H. elim (rem_1461  H).
  intros X1. intro H. elim (rem_1449 X1 H).
   intro H. elim (rem_1464  H).
  intros X1 X2 X3. intro H. elim (rem_1452 X1 X2 X3 H).
   intro H. elim (rem_1453  H).
Qed.

Remark rem_2018 : forall X1 X2 X3 X4:term, auto___def_26 X2 -> auto___def_5 X3 -> auto___type_2 X1 -> auto___type_3 X4 -> auto_agent X4 -> auto_agent X3 -> auto___type_6 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_2 X1 -> auto___type_6 X1). tauto. exact (rem_2017 X1).
Qed.

Remark rem_2019 : forall X1 X2 X3 X4:term, auto___type_3 X2 -> auto_agent X2 -> auto___def_5 X3 -> auto_agent X3 -> auto___def_26 X4 -> auto___type_2 X1 -> auto___type_6 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X4 X3 X2.
  cut (auto___def_26 X2 -> auto___def_5 X3 -> auto___type_2 X1 -> auto___type_3 X4 -> auto_agent X4 -> auto_agent X3 -> auto___type_6 X1). tauto. exact (rem_2018 X1 X2 X3 X4).
Qed.

Remark rem_2020 : forall X1 X2 X3 X4:term, auto___type_2 X1 -> auto___type_3 X2 -> auto___type_9 X3 -> auto_agent X3 -> auto_knows_old X4 -> auto___type_6 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_2 X1 -> auto___type_6 X1). tauto. exact (rem_2017 X1).
Qed.

Remark rem_2021 : forall X1 X2 X3 X4:term, auto___type_3 X2 -> auto___type_9 X3 -> auto_agent X3 -> auto_knows_old X4 -> auto___type_2 X1 -> auto___type_6 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___type_2 X1 -> auto___type_3 X2 -> auto___type_9 X3 -> auto_agent X3 -> auto_knows_old X4 -> auto___type_6 X1). tauto. exact (rem_2020 X1 X2 X3 X4).
Qed.

Remark rem_2022 : forall X1 X2 X3 X4:term, auto___def_26 X2 -> auto___def_7 X3 -> auto___type_2 X1 -> auto___type_3 X4 -> auto_agent X4 -> auto_agent X3 -> auto___type_6 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_2 X1 -> auto___type_6 X1). tauto. exact (rem_2017 X1).
Qed.

Remark rem_2023 : forall X1 X2 X3 X4:term, auto___type_3 X2 -> auto_agent X2 -> auto___def_7 X3 -> auto_agent X3 -> auto___def_26 X4 -> auto___type_2 X1 -> auto___type_6 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X4 X3 X2.
  cut (auto___def_26 X2 -> auto___def_7 X3 -> auto___type_2 X1 -> auto___type_3 X4 -> auto_agent X4 -> auto_agent X3 -> auto___type_6 X1). tauto. exact (rem_2022 X1 X2 X3 X4).
Qed.

Remark rem_2024 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_26 X3 -> auto___type_2 X1 -> auto___type_3 X4 -> auto_agent X4 -> auto_agent X2 -> auto___type_6 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_2 X1 -> auto___type_6 X1). tauto. exact (rem_2017 X1).
Qed.

Remark rem_2025 : forall X1 X2 X3 X4:term, auto___type_3 X2 -> auto_agent X2 -> auto_agent X3 -> auto___def_2 X3 -> auto___def_26 X4 -> auto___type_2 X1 -> auto___type_6 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X4 X2 X3.
  cut (auto___def_2 X2 -> auto___def_26 X3 -> auto___type_2 X1 -> auto___type_3 X4 -> auto_agent X4 -> auto_agent X2 -> auto___type_6 X1). tauto. exact (rem_2024 X1 X2 X3 X4).
Qed.

Remark rem_2026 : forall X1 X2 X3 X4:term, auto___def_29 X2 X3 X4 X1 -> auto___type_6 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1280 X2 X3 X4 X1 H);  intros.
  apply (rem_2019 X1 X2 X3 X4);  tauto.
  apply (rem_2021 X1 X2 X3 X4);  tauto.
  apply (rem_2023 X1 X2 X3 X4);  tauto.
  apply (rem_2025 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2027 : auto___def_17 nil. (* Deduce positive atom. *)
Proof.
   case rem_135. intros. apply trans___def_17_nil_1;  tauto.
 tauto.
Qed.

Remark rem_2028 : forall X1:term, auto___def_52 X1 -> auto___def_52 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2029 : forall X1 X2:term, auto___def_52 X1 -> auto___def_53 X2 -> auto___def_52 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_52 X1 -> auto___def_52 X1). tauto. exact (rem_2028 X1).
Qed.

Remark rem_2030 : forall X2:term, auto___def_53 X2 -> auto___def_53 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2031 : forall X1 X2:term, auto___def_52 X1 -> auto___def_53 X2 -> auto___def_53 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_53 X2 -> auto___def_53 X2). tauto. exact (rem_2030 X2).
Qed.

Remark rem_2032 : forall X1 X2:term, auto___def_52 X1 -> auto___def_53 X2 -> (auto___def_52 X1 /\ auto___def_53 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_52 X1). 2:apply (rem_2029 X1 X2);  assumption.
  cut (auto___def_53 X2). 2:apply (rem_2031 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2033 : forall X1 X2:term, auto___def_52 X1 -> auto___def_53 X2 -> auto___def_51 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2032 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_51_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2034 : forall X1 X2:term, auto___def_53 X2 -> auto___def_52 X1 -> auto___def_51 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_52 X1 -> auto___def_53 X2 -> auto___def_51 (cons X1 X2)). tauto. exact (rem_2033 X1 X2).
Qed.

Remark rem_2035 : (forall X:term, auto___type_2 X -> auto___type_13 X)
    -> forall X1:term, auto___def_3 X1 -> auto___def_3 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2036 : (forall X:term, auto___type_2 X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_p__type_13. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2035 epsilon_m__type_2_p__type_13 X1).
Defined.

Remark rem_2037 : (forall X:term, auto___type_2 X -> auto___type_13 X)
    -> forall X2:term, auto___def_2 X2 -> auto___def_2 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2038 : (forall X:term, auto___type_2 X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___def_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_p__type_13. intros X1 X2.
  cut (auto___def_2 X2 -> auto___def_2 X2). tauto. exact (rem_2037 epsilon_m__type_2_p__type_13 X2).
Defined.

Remark rem_2039 : (forall X:term, auto___type_2 X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> (auto___def_3 X1 /\ auto___def_2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_2_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2036 epsilon_m__type_2_p__type_13 X1 X2);  assumption.
  cut (auto___def_2 X2). 2:apply (rem_2038 epsilon_m__type_2_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2040 : (forall X:term, auto___type_2 X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___type_13 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_2039 epsilon_m__type_2_p__type_13 X1 X2 A1 A2). clear  epsilon_m__type_2_p__type_13 A1 A2. intros. apply trans___type_13_key_1;  tauto.
 clear  epsilon_m__type_2_p__type_13 A1 A2. tauto.
Defined.

Remark rem_2041 : (forall X:term, auto___type_2 X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_p__type_13. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2035 epsilon_m__type_2_p__type_13 X1).
Defined.

Remark rem_2042 : (forall X:term, auto___type_2 X -> auto___type_13 X)
    -> forall X2:term, auto___def_5 X2 -> auto___def_5 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2043 : (forall X:term, auto___type_2 X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___def_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_p__type_13. intros X1 X2.
  cut (auto___def_5 X2 -> auto___def_5 X2). tauto. exact (rem_2042 epsilon_m__type_2_p__type_13 X2).
Defined.

Remark rem_2044 : (forall X:term, auto___type_2 X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> (auto___def_3 X1 /\ auto___def_5 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_2_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2041 epsilon_m__type_2_p__type_13 X1 X2);  assumption.
  cut (auto___def_5 X2). 2:apply (rem_2043 epsilon_m__type_2_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2045 : (forall X:term, auto___type_2 X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___type_13 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_2044 epsilon_m__type_2_p__type_13 X1 X2 A1 A2). clear  epsilon_m__type_2_p__type_13 A1 A2. intros. apply trans___type_13_key_2;  tauto.
 clear  epsilon_m__type_2_p__type_13 A1 A2. tauto.
Defined.

Remark rem_2046 : (forall X:term, auto___type_2 X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_p__type_13. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2035 epsilon_m__type_2_p__type_13 X1).
Defined.

Remark rem_2047 : (forall X:term, auto___type_2 X -> auto___type_13 X)
    -> forall X2:term, auto___def_7 X2 -> auto___def_7 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2048 : (forall X:term, auto___type_2 X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___def_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_p__type_13. intros X1 X2.
  cut (auto___def_7 X2 -> auto___def_7 X2). tauto. exact (rem_2047 epsilon_m__type_2_p__type_13 X2).
Defined.

Remark rem_2049 : (forall X:term, auto___type_2 X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> (auto___def_3 X1 /\ auto___def_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_2_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2046 epsilon_m__type_2_p__type_13 X1 X2);  assumption.
  cut (auto___def_7 X2). 2:apply (rem_2048 epsilon_m__type_2_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2050 : (forall X:term, auto___type_2 X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___type_13 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_2049 epsilon_m__type_2_p__type_13 X1 X2 A1 A2). clear  epsilon_m__type_2_p__type_13 A1 A2. intros. apply trans___type_13_key_3;  tauto.
 clear  epsilon_m__type_2_p__type_13 A1 A2. tauto.
Defined.

Remark rem_2051 : (forall X:term, auto___type_2 X -> auto___type_13 X)
    -> forall X1 X2:term, auto___type_2 (key X1 X2) -> auto___type_13 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_2_p__type_13. intros X1 X2. intro H. intros.
  elim (rem_145 X1 X2 H);  intros.
  apply (rem_2040 epsilon_m__type_2_p__type_13 X1 X2);  tauto.
  apply (rem_2045 epsilon_m__type_2_p__type_13 X1 X2);  tauto.
  apply (rem_2050 epsilon_m__type_2_p__type_13 X1 X2);  tauto.
Defined.

Remark rem_2052 : forall X1:term, auto___type_2 X1 -> auto___type_13 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_2_p__type_13 1.
  intro X. case X.
   intro H. elim (rem_1459  H).
   intro H. elim (rem_1457  H).
  intros X1 X2. intro H. elim (rem_1455 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1456 X1 X2 H).
   intro H. elim (rem_1451  H).
   intro H. elim (rem_1463  H).
  intros X1 X2;  exact (rem_2051 epsilon_m__type_2_p__type_13 X1 X2).
   intro H. elim (rem_1450  H).
  intros X1 X2 X3. intro H. elim (rem_1454 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1458 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1462 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1460 X1 X2 X3 X4 H).
   intro H. elim (rem_1465  H).
   intro H. elim (rem_1461  H).
  intros X1. intro H. elim (rem_1449 X1 H).
   intro H. elim (rem_1464  H).
  intros X1 X2 X3. intro H. elim (rem_1452 X1 X2 X3 H).
   intro H. elim (rem_1453  H).
Qed.

Remark rem_2053 : forall X1 X2 X3 X4:term, auto___type_2 X1 -> auto___type_3 X2 -> auto___type_9 X3 -> auto_agent X3 -> auto_knows_current X4 -> auto___type_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_2 X1 -> auto___type_13 X1). tauto. exact (rem_2052 X1).
Qed.

Remark rem_2054 : forall X1 X2 X3 X4:term, auto___type_3 X2 -> auto___type_9 X3 -> auto_agent X3 -> auto_knows_current X4 -> auto___type_2 X1 -> auto___type_13 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___type_2 X1 -> auto___type_3 X2 -> auto___type_9 X3 -> auto_agent X3 -> auto_knows_current X4 -> auto___type_13 X1). tauto. exact (rem_2053 X1 X2 X3 X4).
Qed.

Remark rem_2055 : (forall X:term, auto___type_10 X -> auto___type_13 X)
    -> forall X1:term, auto___def_3 X1 -> auto___def_3 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2056 : (forall X:term, auto___type_10 X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_10_p__type_13. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2055 epsilon_m__type_10_p__type_13 X1).
Defined.

Remark rem_2057 : (forall X:term, auto___type_10 X -> auto___type_13 X)
    -> forall X2:term, auto___def_2 X2 -> auto___def_2 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2058 : (forall X:term, auto___type_10 X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___def_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_10_p__type_13. intros X1 X2.
  cut (auto___def_2 X2 -> auto___def_2 X2). tauto. exact (rem_2057 epsilon_m__type_10_p__type_13 X2).
Defined.

Remark rem_2059 : (forall X:term, auto___type_10 X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> (auto___def_3 X1 /\ auto___def_2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_10_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2056 epsilon_m__type_10_p__type_13 X1 X2);  assumption.
  cut (auto___def_2 X2). 2:apply (rem_2058 epsilon_m__type_10_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2060 : (forall X:term, auto___type_10 X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___type_13 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_10_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_2059 epsilon_m__type_10_p__type_13 X1 X2 A1 A2). clear  epsilon_m__type_10_p__type_13 A1 A2. intros. apply trans___type_13_key_1;  tauto.
 clear  epsilon_m__type_10_p__type_13 A1 A2. tauto.
Defined.

Remark rem_2061 : (forall X:term, auto___type_10 X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_10_p__type_13. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2055 epsilon_m__type_10_p__type_13 X1).
Defined.

Remark rem_2062 : (forall X:term, auto___type_10 X -> auto___type_13 X)
    -> forall X2:term, auto___def_5 X2 -> auto___def_5 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2063 : (forall X:term, auto___type_10 X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___def_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_10_p__type_13. intros X1 X2.
  cut (auto___def_5 X2 -> auto___def_5 X2). tauto. exact (rem_2062 epsilon_m__type_10_p__type_13 X2).
Defined.

Remark rem_2064 : (forall X:term, auto___type_10 X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> (auto___def_3 X1 /\ auto___def_5 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_10_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2061 epsilon_m__type_10_p__type_13 X1 X2);  assumption.
  cut (auto___def_5 X2). 2:apply (rem_2063 epsilon_m__type_10_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2065 : (forall X:term, auto___type_10 X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___type_13 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_10_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_2064 epsilon_m__type_10_p__type_13 X1 X2 A1 A2). clear  epsilon_m__type_10_p__type_13 A1 A2. intros. apply trans___type_13_key_2;  tauto.
 clear  epsilon_m__type_10_p__type_13 A1 A2. tauto.
Defined.

Remark rem_2066 : (forall X:term, auto___type_10 X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_10_p__type_13. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2055 epsilon_m__type_10_p__type_13 X1).
Defined.

Remark rem_2067 : (forall X:term, auto___type_10 X -> auto___type_13 X)
    -> forall X2:term, auto___def_7 X2 -> auto___def_7 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2068 : (forall X:term, auto___type_10 X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___def_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_10_p__type_13. intros X1 X2.
  cut (auto___def_7 X2 -> auto___def_7 X2). tauto. exact (rem_2067 epsilon_m__type_10_p__type_13 X2).
Defined.

Remark rem_2069 : (forall X:term, auto___type_10 X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> (auto___def_3 X1 /\ auto___def_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_10_p__type_13. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2066 epsilon_m__type_10_p__type_13 X1 X2);  assumption.
  cut (auto___def_7 X2). 2:apply (rem_2068 epsilon_m__type_10_p__type_13 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2070 : (forall X:term, auto___type_10 X -> auto___type_13 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___type_13 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_10_p__type_13. intros X1 X2. intros A1 A2.
  case (rem_2069 epsilon_m__type_10_p__type_13 X1 X2 A1 A2). clear  epsilon_m__type_10_p__type_13 A1 A2. intros. apply trans___type_13_key_3;  tauto.
 clear  epsilon_m__type_10_p__type_13 A1 A2. tauto.
Defined.

Remark rem_2071 : (forall X:term, auto___type_10 X -> auto___type_13 X)
    -> forall X1 X2:term, auto___type_10 (key X1 X2) -> auto___type_13 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_10_p__type_13. intros X1 X2. intro H. intros.
  elim (rem_340 X1 X2 H);  intros.
  apply (rem_2060 epsilon_m__type_10_p__type_13 X1 X2);  tauto.
  apply (rem_2065 epsilon_m__type_10_p__type_13 X1 X2);  tauto.
  apply (rem_2070 epsilon_m__type_10_p__type_13 X1 X2);  tauto.
Defined.

Remark rem_2072 : forall X1:term, auto___type_10 X1 -> auto___type_13 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_10_p__type_13 1.
  intro X. case X.
   intro H. elim (rem_352  H).
   intro H. elim (rem_350  H).
  intros X1 X2. intro H. elim (rem_348 X1 X2 H).
  intros X1 X2. intro H. elim (rem_349 X1 X2 H).
   intro H. elim (rem_344  H).
   intro H. elim (rem_356  H).
  intros X1 X2;  exact (rem_2071 epsilon_m__type_10_p__type_13 X1 X2).
   intro H. elim (rem_343  H).
  intros X1 X2 X3. intro H. elim (rem_347 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_351 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_355 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_353 X1 X2 X3 X4 H).
   intro H. elim (rem_358  H).
   intro H. elim (rem_354  H).
  intros X1. intro H. elim (rem_342 X1 H).
   intro H. elim (rem_357  H).
  intros X1 X2 X3. intro H. elim (rem_345 X1 X2 X3 H).
   intro H. elim (rem_346  H).
Qed.

Remark rem_2073 : forall X1 X2 X3 X4:term, auto___def_2 X2 -> auto___def_52 X3 -> auto___type_10 X1 -> auto___type_11 X4 -> auto_agent X4 -> auto_agent X2 -> auto___type_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_10 X1 -> auto___type_13 X1). tauto. exact (rem_2072 X1).
Qed.

Remark rem_2074 : forall X1 X2 X3 X4:term, auto___type_11 X2 -> auto_agent X2 -> auto_agent X3 -> auto___def_2 X3 -> auto___def_52 X4 -> auto___type_10 X1 -> auto___type_13 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X4 X2 X3.
  cut (auto___def_2 X2 -> auto___def_52 X3 -> auto___type_10 X1 -> auto___type_11 X4 -> auto_agent X4 -> auto_agent X2 -> auto___type_13 X1). tauto. exact (rem_2073 X1 X2 X3 X4).
Qed.

Remark rem_2075 : forall X1 X2 X3 X4:term, auto___def_52 X2 -> auto___def_7 X3 -> auto___type_2 X1 -> auto___type_3 X4 -> auto_agent X4 -> auto_agent X3 -> auto___type_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_2 X1 -> auto___type_13 X1). tauto. exact (rem_2052 X1).
Qed.

Remark rem_2076 : forall X1 X2 X3 X4:term, auto___type_3 X2 -> auto_agent X2 -> auto___def_7 X3 -> auto_agent X3 -> auto___def_52 X4 -> auto___type_2 X1 -> auto___type_13 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X4 X3 X2.
  cut (auto___def_52 X2 -> auto___def_7 X3 -> auto___type_2 X1 -> auto___type_3 X4 -> auto_agent X4 -> auto_agent X3 -> auto___type_13 X1). tauto. exact (rem_2075 X1 X2 X3 X4).
Qed.

Remark rem_2077 : forall X1 X2 X3 X4:term, auto___def_5 X2 -> auto___def_52 X3 -> auto___type_10 X1 -> auto___type_11 X4 -> auto_agent X4 -> auto_agent X2 -> auto___type_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_10 X1 -> auto___type_13 X1). tauto. exact (rem_2072 X1).
Qed.

Remark rem_2078 : forall X1 X2 X3 X4:term, auto___type_11 X2 -> auto_agent X2 -> auto___def_5 X3 -> auto_agent X3 -> auto___def_52 X4 -> auto___type_10 X1 -> auto___type_13 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X4 X2 X3.
  cut (auto___def_5 X2 -> auto___def_52 X3 -> auto___type_10 X1 -> auto___type_11 X4 -> auto_agent X4 -> auto_agent X2 -> auto___type_13 X1). tauto. exact (rem_2077 X1 X2 X3 X4).
Qed.

Remark rem_2079 : forall X1 X2 X3 X4:term, auto___def_54 X2 X3 X4 X1 -> auto___type_13 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_420 X2 X3 X4 X1 H);  intros.
  apply (rem_2054 X1 X2 X3 X4);  tauto.
  apply (rem_2074 X1 X2 X3 X4);  tauto.
  apply (rem_2076 X1 X2 X3 X4);  tauto.
  apply (rem_2078 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2080 : forall X1 X2:term, auto___def_17 X2 -> auto_agent X1 -> auto___def_16 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_5 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_16_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2081 : forall X1 X2:term, auto___def_23 sym -> auto___def_36 X2 -> auto_knows_current X1 -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_23 sym -> False). tauto.
  exact (rem_229).
Qed.

Remark rem_2082 : forall X1 X2:term, auto___def_3 sym -> auto_knows_current X1 -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 sym -> False). tauto.
  exact (rem_232).
Qed.

Remark rem_2083 : forall X1 X2:term, auto___def_3 sym -> auto___type_9 X2 -> auto_knows_current X1 -> auto___def_43 X1 X2. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2. intros. apply (rem_2082 X1 X2);  assumption.
Qed.

Remark rem_2084 : forall X1 X2:term, auto___def_37 sym -> auto___def_38 X2 -> auto_knows_current X1 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_1585 X1).
Qed.

Remark rem_2085 : forall X2:term, auto___def_38 X2 -> auto___def_38 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2086 : forall X1 X2:term, auto___def_37 sym -> auto___def_38 X2 -> auto_knows_current X1 -> auto___def_38 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_38 X2 -> auto___def_38 X2). tauto. exact (rem_2085 X2).
Qed.

Remark rem_2087 : forall X1 X2:term, auto___def_37 sym -> auto___def_38 X2 -> auto_knows_current X1 -> (auto_knows_current X1 /\ auto___def_38 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto_knows_current X1). 2:apply (rem_2084 X1 X2);  assumption.
  cut (auto___def_38 X2). 2:apply (rem_2086 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2088 : forall X1 X2:term, auto___def_37 sym -> auto___def_38 X2 -> auto_knows_current X1 -> auto___def_43 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_2087 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_43_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2089 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current (key sym X2) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_258 sym X2 H);  intros.
  apply (rem_2081 X1 X2);  tauto.
  apply (rem_2083 X1 X2);  tauto.
  apply (rem_2088 X1 X2);  tauto.
Qed.

Remark rem_2090 : forall X1 X2:term, auto___def_2 X2 -> auto___def_3 sym -> auto___def_51 X1 -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 sym -> False). tauto.
  exact (rem_232).
Qed.

Remark rem_2091 : forall X1 X2:term, auto___def_3 sym -> auto___def_2 X2 -> auto___def_51 X1 -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_2 X2 -> auto___def_3 sym -> auto___def_51 X1 -> auto___def_43 X1 X2). tauto. exact (rem_2090 X1 X2).
Qed.

Remark rem_2092 : forall X1 X2:term, auto___def_3 sym -> auto___def_5 X2 -> auto___def_51 X1 -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 sym -> False). tauto.
  exact (rem_232).
Qed.

Remark rem_2093 : forall X1 X2:term, auto___def_3 sym -> auto___def_51 X1 -> auto___def_7 X2 -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 sym -> False). tauto.
  exact (rem_232).
Qed.

Remark rem_2094 : forall X1 X2:term, auto___def_3 sym -> auto___def_7 X2 -> auto___def_51 X1 -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_3 sym -> auto___def_51 X1 -> auto___def_7 X2 -> auto___def_43 X1 X2). tauto. exact (rem_2093 X1 X2).
Qed.

Remark rem_2095 : forall X1 X2:term, auto___def_51 X1 -> auto___type_12 (key sym X2) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_427 sym X2 H);  intros.
  apply (rem_2091 X1 X2);  tauto.
  apply (rem_2092 X1 X2);  tauto.
  apply (rem_2094 X1 X2);  tauto.
Qed.

Remark rem_2096 : forall X1 X2:term, auto___def_2 X2 -> auto___def_3 sym -> auto___def_57 X1 -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 sym -> False). tauto.
  exact (rem_232).
Qed.

Remark rem_2097 : forall X1 X2:term, auto___def_3 sym -> auto___def_2 X2 -> auto___def_57 X1 -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_2 X2 -> auto___def_3 sym -> auto___def_57 X1 -> auto___def_43 X1 X2). tauto. exact (rem_2096 X1 X2).
Qed.

Remark rem_2098 : forall X1 X2:term, auto___def_3 sym -> auto___def_5 X2 -> auto___def_57 X1 -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 sym -> False). tauto.
  exact (rem_232).
Qed.

Remark rem_2099 : forall X1 X2:term, auto___def_3 sym -> auto___def_57 X1 -> auto___def_7 X2 -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 sym -> False). tauto.
  exact (rem_232).
Qed.

Remark rem_2100 : forall X1 X2:term, auto___def_3 sym -> auto___def_7 X2 -> auto___def_57 X1 -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_3 sym -> auto___def_57 X1 -> auto___def_7 X2 -> auto___def_43 X1 X2). tauto. exact (rem_2099 X1 X2).
Qed.

Remark rem_2101 : forall X1 X2:term, auto___def_57 X1 -> auto___type_2 (key sym X2) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_145 sym X2 H);  intros.
  apply (rem_2097 X1 X2);  tauto.
  apply (rem_2098 X1 X2);  tauto.
  apply (rem_2100 X1 X2);  tauto.
Qed.

Remark rem_2102 : forall X1 X2:term, auto___def_23 sym -> auto___def_46 X1 -> auto___def_7 X2 -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_23 sym -> False). tauto.
  exact (rem_229).
Qed.

Remark rem_2103 : forall X1 X2:term, auto___def_23 sym -> auto___def_7 X2 -> auto___def_46 X1 -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_23 sym -> auto___def_46 X1 -> auto___def_7 X2 -> auto___def_43 X1 X2). tauto. exact (rem_2102 X1 X2).
Qed.

Remark rem_2104 : forall X1 X2:term, auto___def_46 X1 -> auto___def_47 (key sym X2) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_685 sym X2 H);  intros.
  apply (rem_2103 X1 X2);  tauto.
Qed.

Remark rem_2105 : forall X1 X2:term, auto___def_2 X2 -> auto___def_3 sym -> auto___def_55 X1 -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 sym -> False). tauto.
  exact (rem_232).
Qed.

Remark rem_2106 : forall X1 X2:term, auto___def_3 sym -> auto___def_2 X2 -> auto___def_55 X1 -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_2 X2 -> auto___def_3 sym -> auto___def_55 X1 -> auto___def_43 X1 X2). tauto. exact (rem_2105 X1 X2).
Qed.

Remark rem_2107 : forall X1 X2:term, auto___def_3 sym -> auto___def_5 X2 -> auto___def_55 X1 -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 sym -> False). tauto.
  exact (rem_232).
Qed.

Remark rem_2108 : forall X1 X2:term, auto___def_3 sym -> auto___def_55 X1 -> auto___def_7 X2 -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 sym -> False). tauto.
  exact (rem_232).
Qed.

Remark rem_2109 : forall X1 X2:term, auto___def_3 sym -> auto___def_7 X2 -> auto___def_55 X1 -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_3 sym -> auto___def_55 X1 -> auto___def_7 X2 -> auto___def_43 X1 X2). tauto. exact (rem_2108 X1 X2).
Qed.

Remark rem_2110 : forall X1 X2:term, auto___def_55 X1 -> auto___type_13 (key sym X2) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_789 sym X2 H);  intros.
  apply (rem_2106 X1 X2);  tauto.
  apply (rem_2107 X1 X2);  tauto.
  apply (rem_2109 X1 X2);  tauto.
Qed.

Remark rem_2111 : forall X1 X2:term, auto_knows_current (crypt X1 (key sym X2)) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_470 X1 (key sym X2) H);  intros.
  apply (rem_2089 X1 X2);  tauto.
  apply (rem_2095 X1 X2);  tauto.
  apply (rem_2101 X1 X2);  tauto.
  apply (rem_2104 X1 X2);  tauto.
  apply (rem_2110 X1 X2);  tauto.
Qed.

Remark rem_2112 : forall X1 X2:term, auto___def_23 X1 -> auto___def_7 X2 -> auto___def_47 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1240 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_47_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2113 : forall X1 X2:term, auto___def_7 X2 -> auto___def_23 X1 -> auto___def_47 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_23 X1 -> auto___def_7 X2 -> auto___def_47 (key X1 X2)). tauto. exact (rem_2112 X1 X2).
Qed.

Remark rem_2114 : forall X1 X2 X3:term, auto___type_2 X3 -> auto___type_3 X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_1 X1).
Qed.

Remark rem_2115 : forall X2:term, auto___type_3 X2 -> auto___type_3 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2116 : forall X1 X2 X3:term, auto___type_2 X3 -> auto___type_3 X2 -> auto_agent X1 -> auto___type_3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___type_3 X2 -> auto___type_3 X2). tauto. exact (rem_2115 X2).
Qed.

Remark rem_2117 : forall X1 X2 X3:term, auto___type_2 X3 -> auto___type_3 X2 -> auto_agent X1 -> auto___type_2 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___type_2 X3 -> auto___type_2 X3). tauto. exact (rem_274 X3).
Qed.

Remark rem_2118 : forall X1 X2 X3:term, auto___type_2 X3 -> auto___type_3 X2 -> auto_agent X1 -> (auto_agent X1 /\ auto___type_3 X2 /\ auto___type_2 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  cut (auto_agent X1). 2:apply (rem_2114 X1 X2 X3);  assumption.
  cut (auto___type_3 X2). 2:apply (rem_2116 X1 X2 X3);  assumption.
  cut (auto___type_2 X3). 2:apply (rem_2117 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_2119 : forall X1 X2 X3:term, auto___type_2 X3 -> auto___type_3 X2 -> auto_agent X1 -> auto___def_26 (noncea_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  case (rem_2118 X1 X2 X3 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_26_noncea_old_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2120 : forall X1 X2 X3:term, auto___type_3 X2 -> auto___type_2 X3 -> auto_agent X1 -> auto___def_26 (noncea_old X1 X2 X3). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___type_2 X3 -> auto___type_3 X2 -> auto_agent X1 -> auto___def_26 (noncea_old X1 X2 X3)). tauto. exact (rem_2119 X1 X2 X3).
Qed.

Remark rem_2121 : forall X1 X2:term, auto___def_24 X1 X2 -> or_1
    (auto___type_3 X1 /\ auto___type_2 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2122 : forall X1 X2 X3:term, auto___def_24 X2 X3 -> auto_agent X1 -> auto___def_26 (noncea_old X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_2121 X2 X3 H);  intros.
  apply (rem_2120 X1 X2 X3);  tauto.
Qed.

Remark rem_2123 : auto___def_59 nil. (* Deduce positive atom. *)
Proof.
   case rem_135. intros. apply trans___def_59_nil_1;  tauto.
 tauto.
Qed.

Remark rem_2124 : (forall X:term, auto___type_2 X -> auto___type_4 X)
    -> forall X1:term, auto___def_3 X1 -> auto___def_3 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2125 : (forall X:term, auto___type_2 X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_p__type_4. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2124 epsilon_m__type_2_p__type_4 X1).
Defined.

Remark rem_2126 : (forall X:term, auto___type_2 X -> auto___type_4 X)
    -> forall X2:term, auto___def_2 X2 -> auto___def_2 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2127 : (forall X:term, auto___type_2 X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___def_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_p__type_4. intros X1 X2.
  cut (auto___def_2 X2 -> auto___def_2 X2). tauto. exact (rem_2126 epsilon_m__type_2_p__type_4 X2).
Defined.

Remark rem_2128 : (forall X:term, auto___type_2 X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> (auto___def_3 X1 /\ auto___def_2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_2_p__type_4. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2125 epsilon_m__type_2_p__type_4 X1 X2);  assumption.
  cut (auto___def_2 X2). 2:apply (rem_2127 epsilon_m__type_2_p__type_4 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2129 : (forall X:term, auto___type_2 X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___type_4 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_p__type_4. intros X1 X2. intros A1 A2.
  case (rem_2128 epsilon_m__type_2_p__type_4 X1 X2 A1 A2). clear  epsilon_m__type_2_p__type_4 A1 A2. intros. apply trans___type_4_key_1;  tauto.
 clear  epsilon_m__type_2_p__type_4 A1 A2. tauto.
Defined.

Remark rem_2130 : (forall X:term, auto___type_2 X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_p__type_4. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2124 epsilon_m__type_2_p__type_4 X1).
Defined.

Remark rem_2131 : (forall X:term, auto___type_2 X -> auto___type_4 X)
    -> forall X2:term, auto___def_5 X2 -> auto___def_5 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2132 : (forall X:term, auto___type_2 X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___def_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_p__type_4. intros X1 X2.
  cut (auto___def_5 X2 -> auto___def_5 X2). tauto. exact (rem_2131 epsilon_m__type_2_p__type_4 X2).
Defined.

Remark rem_2133 : (forall X:term, auto___type_2 X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> (auto___def_3 X1 /\ auto___def_5 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_2_p__type_4. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2130 epsilon_m__type_2_p__type_4 X1 X2);  assumption.
  cut (auto___def_5 X2). 2:apply (rem_2132 epsilon_m__type_2_p__type_4 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2134 : (forall X:term, auto___type_2 X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___type_4 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_p__type_4. intros X1 X2. intros A1 A2.
  case (rem_2133 epsilon_m__type_2_p__type_4 X1 X2 A1 A2). clear  epsilon_m__type_2_p__type_4 A1 A2. intros. apply trans___type_4_key_2;  tauto.
 clear  epsilon_m__type_2_p__type_4 A1 A2. tauto.
Defined.

Remark rem_2135 : (forall X:term, auto___type_2 X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_p__type_4. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2124 epsilon_m__type_2_p__type_4 X1).
Defined.

Remark rem_2136 : (forall X:term, auto___type_2 X -> auto___type_4 X)
    -> forall X2:term, auto___def_7 X2 -> auto___def_7 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2137 : (forall X:term, auto___type_2 X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___def_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_p__type_4. intros X1 X2.
  cut (auto___def_7 X2 -> auto___def_7 X2). tauto. exact (rem_2136 epsilon_m__type_2_p__type_4 X2).
Defined.

Remark rem_2138 : (forall X:term, auto___type_2 X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> (auto___def_3 X1 /\ auto___def_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_2_p__type_4. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2135 epsilon_m__type_2_p__type_4 X1 X2);  assumption.
  cut (auto___def_7 X2). 2:apply (rem_2137 epsilon_m__type_2_p__type_4 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2139 : (forall X:term, auto___type_2 X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___type_4 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_p__type_4. intros X1 X2. intros A1 A2.
  case (rem_2138 epsilon_m__type_2_p__type_4 X1 X2 A1 A2). clear  epsilon_m__type_2_p__type_4 A1 A2. intros. apply trans___type_4_key_3;  tauto.
 clear  epsilon_m__type_2_p__type_4 A1 A2. tauto.
Defined.

Remark rem_2140 : (forall X:term, auto___type_2 X -> auto___type_4 X)
    -> forall X1 X2:term, auto___type_2 (key X1 X2) -> auto___type_4 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_2_p__type_4. intros X1 X2. intro H. intros.
  elim (rem_145 X1 X2 H);  intros.
  apply (rem_2129 epsilon_m__type_2_p__type_4 X1 X2);  tauto.
  apply (rem_2134 epsilon_m__type_2_p__type_4 X1 X2);  tauto.
  apply (rem_2139 epsilon_m__type_2_p__type_4 X1 X2);  tauto.
Defined.

Remark rem_2141 : forall X1:term, auto___type_2 X1 -> auto___type_4 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_2_p__type_4 1.
  intro X. case X.
   intro H. elim (rem_1459  H).
   intro H. elim (rem_1457  H).
  intros X1 X2. intro H. elim (rem_1455 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1456 X1 X2 H).
   intro H. elim (rem_1451  H).
   intro H. elim (rem_1463  H).
  intros X1 X2;  exact (rem_2140 epsilon_m__type_2_p__type_4 X1 X2).
   intro H. elim (rem_1450  H).
  intros X1 X2 X3. intro H. elim (rem_1454 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1458 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1462 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1460 X1 X2 X3 X4 H).
   intro H. elim (rem_1465  H).
   intro H. elim (rem_1461  H).
  intros X1. intro H. elim (rem_1449 X1 H).
   intro H. elim (rem_1464  H).
  intros X1 X2 X3. intro H. elim (rem_1452 X1 X2 X3 H).
   intro H. elim (rem_1453  H).
Qed.

Remark rem_2142 : forall X1 X2:term, auto___type_2 X1 -> auto___type_3 X2 -> auto___type_4 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_2 X1 -> auto___type_4 X1). tauto. exact (rem_2141 X1).
Qed.

Remark rem_2143 : forall X1 X2:term, auto___type_3 X2 -> auto___type_2 X1 -> auto___type_4 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___type_2 X1 -> auto___type_3 X2 -> auto___type_4 X1). tauto. exact (rem_2142 X1 X2).
Qed.

Remark rem_2144 : forall X1 X2:term, auto___def_24 X2 X1 -> auto___type_4 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_2121 X2 X1 H);  intros.
  apply (rem_2143 X1 X2);  tauto.
Qed.

Remark rem_2145 : (forall X:term, auto___def_1 X -> auto___type_10 X)
    -> forall X1:term, auto___def_3 X1 -> auto___def_3 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2146 : (forall X:term, auto___def_1 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_1_p__type_10. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2145 epsilon_m__def_1_p__type_10 X1).
Defined.

Remark rem_2147 : (forall X:term, auto___def_1 X -> auto___type_10 X)
    -> forall X2:term, auto___def_2 X2 -> auto___def_2 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2148 : (forall X:term, auto___def_1 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___def_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_1_p__type_10. intros X1 X2.
  cut (auto___def_2 X2 -> auto___def_2 X2). tauto. exact (rem_2147 epsilon_m__def_1_p__type_10 X2).
Defined.

Remark rem_2149 : (forall X:term, auto___def_1 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> (auto___def_3 X1 /\ auto___def_2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_1_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2146 epsilon_m__def_1_p__type_10 X1 X2);  assumption.
  cut (auto___def_2 X2). 2:apply (rem_2148 epsilon_m__def_1_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2150 : (forall X:term, auto___def_1 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___type_10 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_1_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_2149 epsilon_m__def_1_p__type_10 X1 X2 A1 A2). clear  epsilon_m__def_1_p__type_10 A1 A2. intros. apply trans___type_10_key_1;  tauto.
 clear  epsilon_m__def_1_p__type_10 A1 A2. tauto.
Defined.

Remark rem_2151 : forall X1 X2:term, auto___def_1 (key X1 X2) -> or_1
    (auto___def_3 X1 /\ auto___def_2 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2152 : (forall X:term, auto___def_1 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_1 (key X1 X2) -> auto___type_10 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_1_p__type_10. intros X1 X2. intro H. intros.
  elim (rem_2151 X1 X2 H);  intros.
  apply (rem_2150 epsilon_m__def_1_p__type_10 X1 X2);  tauto.
Defined.

Remark rem_2153 : forall X1:term, auto___def_1 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2154 : auto___def_1 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2155 : auto___def_1 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2156 : forall X1 X2 X3:term, auto___def_1 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2157 : auto___def_1 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2158 : forall X1 X2 X3:term, auto___def_1 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2159 : forall X1 X2:term, auto___def_1 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2160 : forall X1 X2:term, auto___def_1 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2161 : auto___def_1 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2162 : forall X1 X2 X3:term, auto___def_1 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2163 : auto___def_1 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2164 : forall X1 X2 X3 X4:term, auto___def_1 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2165 : auto___def_1 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2166 : forall X1 X2 X3 X4:term, auto___def_1 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2167 : auto___def_1 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2168 : auto___def_1 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2169 : auto___def_1 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2170 : forall X1:term, auto___def_1 X1 -> auto___type_10 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_1_p__type_10 1.
  intro X. case X.
   intro H. elim (rem_2163  H).
   intro H. elim (rem_2161  H).
  intros X1 X2. intro H. elim (rem_2159 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2160 X1 X2 H).
   intro H. elim (rem_2155  H).
   intro H. elim (rem_2167  H).
  intros X1 X2;  exact (rem_2152 epsilon_m__def_1_p__type_10 X1 X2).
   intro H. elim (rem_2154  H).
  intros X1 X2 X3. intro H. elim (rem_2158 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2162 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_2166 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_2164 X1 X2 X3 X4 H).
   intro H. elim (rem_2169  H).
   intro H. elim (rem_2165  H).
  intros X1. intro H. elim (rem_2153 X1 H).
   intro H. elim (rem_2168  H).
  intros X1 X2 X3. intro H. elim (rem_2156 X1 X2 X3 H).
   intro H. elim (rem_2157  H).
Qed.

Remark rem_2171 : forall X1 X2:term, auto___def_1 X1 -> auto___def_2 X2 -> auto_knows_current X2 -> auto___type_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_1 X1 -> auto___type_10 X1). tauto. exact (rem_2170 X1).
Qed.

Remark rem_2172 : forall X1 X2:term, auto_knows_current X2 -> auto___def_2 X2 -> auto___def_1 X1 -> auto___type_10 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_1 X1 -> auto___def_2 X2 -> auto_knows_current X2 -> auto___type_10 X1). tauto. exact (rem_2171 X1 X2).
Qed.

Remark rem_2173 : forall X1 X2:term, auto___def_8 X1 -> auto___def_9 X2 -> auto_knows_current X2 -> auto___type_10 X1. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_52 X2)). tauto.
Qed.

Remark rem_2174 : forall X1 X2:term, auto___def_9 X2 -> auto_knows_current X2 -> auto___def_8 X1 -> auto___type_10 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_8 X1 -> auto___def_9 X2 -> auto_knows_current X2 -> auto___type_10 X1). tauto. exact (rem_2173 X1 X2).
Qed.

Remark rem_2175 : (forall X:term, auto___def_4 X -> auto___type_10 X)
    -> forall X1:term, auto___def_3 X1 -> auto___def_3 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2176 : (forall X:term, auto___def_4 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_4_p__type_10. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2175 epsilon_m__def_4_p__type_10 X1).
Defined.

Remark rem_2177 : (forall X:term, auto___def_4 X -> auto___type_10 X)
    -> forall X2:term, auto___def_5 X2 -> auto___def_5 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2178 : (forall X:term, auto___def_4 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___def_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_4_p__type_10. intros X1 X2.
  cut (auto___def_5 X2 -> auto___def_5 X2). tauto. exact (rem_2177 epsilon_m__def_4_p__type_10 X2).
Defined.

Remark rem_2179 : (forall X:term, auto___def_4 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> (auto___def_3 X1 /\ auto___def_5 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_4_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2176 epsilon_m__def_4_p__type_10 X1 X2);  assumption.
  cut (auto___def_5 X2). 2:apply (rem_2178 epsilon_m__def_4_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2180 : (forall X:term, auto___def_4 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___type_10 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_4_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_2179 epsilon_m__def_4_p__type_10 X1 X2 A1 A2). clear  epsilon_m__def_4_p__type_10 A1 A2. intros. apply trans___type_10_key_2;  tauto.
 clear  epsilon_m__def_4_p__type_10 A1 A2. tauto.
Defined.

Remark rem_2181 : forall X1 X2:term, auto___def_4 (key X1 X2) -> or_1
    (auto___def_3 X1 /\ auto___def_5 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2182 : (forall X:term, auto___def_4 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_4 (key X1 X2) -> auto___type_10 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_4_p__type_10. intros X1 X2. intro H. intros.
  elim (rem_2181 X1 X2 H);  intros.
  apply (rem_2180 epsilon_m__def_4_p__type_10 X1 X2);  tauto.
Defined.

Remark rem_2183 : forall X1:term, auto___def_4 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2184 : auto___def_4 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2185 : auto___def_4 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2186 : forall X1 X2 X3:term, auto___def_4 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2187 : auto___def_4 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2188 : forall X1 X2 X3:term, auto___def_4 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2189 : forall X1 X2:term, auto___def_4 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2190 : forall X1 X2:term, auto___def_4 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2191 : auto___def_4 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2192 : forall X1 X2 X3:term, auto___def_4 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2193 : auto___def_4 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2194 : forall X1 X2 X3 X4:term, auto___def_4 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2195 : auto___def_4 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2196 : forall X1 X2 X3 X4:term, auto___def_4 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2197 : auto___def_4 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2198 : auto___def_4 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2199 : auto___def_4 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2200 : forall X1:term, auto___def_4 X1 -> auto___type_10 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_4_p__type_10 1.
  intro X. case X.
   intro H. elim (rem_2193  H).
   intro H. elim (rem_2191  H).
  intros X1 X2. intro H. elim (rem_2189 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2190 X1 X2 H).
   intro H. elim (rem_2185  H).
   intro H. elim (rem_2197  H).
  intros X1 X2;  exact (rem_2182 epsilon_m__def_4_p__type_10 X1 X2).
   intro H. elim (rem_2184  H).
  intros X1 X2 X3. intro H. elim (rem_2188 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2192 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_2196 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_2194 X1 X2 X3 X4 H).
   intro H. elim (rem_2199  H).
   intro H. elim (rem_2195  H).
  intros X1. intro H. elim (rem_2183 X1 H).
   intro H. elim (rem_2198  H).
  intros X1 X2 X3. intro H. elim (rem_2186 X1 X2 X3 H).
   intro H. elim (rem_2187  H).
Qed.

Remark rem_2201 : forall X1 X2:term, auto___def_4 X1 -> auto___def_5 X2 -> auto_knows_old X2 -> auto___type_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_4 X1 -> auto___type_10 X1). tauto. exact (rem_2200 X1).
Qed.

Remark rem_2202 : forall X1 X2:term, auto_knows_old X2 -> auto___def_5 X2 -> auto___def_4 X1 -> auto___type_10 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_4 X1 -> auto___def_5 X2 -> auto_knows_old X2 -> auto___type_10 X1). tauto. exact (rem_2201 X1 X2).
Qed.

Remark rem_2203 : (forall X:term, auto___def_6 X -> auto___type_10 X)
    -> forall X1:term, auto___def_3 X1 -> auto___def_3 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2204 : (forall X:term, auto___def_6 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_6_p__type_10. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2203 epsilon_m__def_6_p__type_10 X1).
Defined.

Remark rem_2205 : (forall X:term, auto___def_6 X -> auto___type_10 X)
    -> forall X2:term, auto___def_7 X2 -> auto___def_7 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2206 : (forall X:term, auto___def_6 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___def_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_6_p__type_10. intros X1 X2.
  cut (auto___def_7 X2 -> auto___def_7 X2). tauto. exact (rem_2205 epsilon_m__def_6_p__type_10 X2).
Defined.

Remark rem_2207 : (forall X:term, auto___def_6 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> (auto___def_3 X1 /\ auto___def_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_6_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2204 epsilon_m__def_6_p__type_10 X1 X2);  assumption.
  cut (auto___def_7 X2). 2:apply (rem_2206 epsilon_m__def_6_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2208 : (forall X:term, auto___def_6 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___type_10 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_6_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_2207 epsilon_m__def_6_p__type_10 X1 X2 A1 A2). clear  epsilon_m__def_6_p__type_10 A1 A2. intros. apply trans___type_10_key_3;  tauto.
 clear  epsilon_m__def_6_p__type_10 A1 A2. tauto.
Defined.

Remark rem_2209 : forall X1 X2:term, auto___def_6 (key X1 X2) -> or_1
    (auto___def_3 X1 /\ auto___def_7 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2210 : (forall X:term, auto___def_6 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_6 (key X1 X2) -> auto___type_10 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_6_p__type_10. intros X1 X2. intro H. intros.
  elim (rem_2209 X1 X2 H);  intros.
  apply (rem_2208 epsilon_m__def_6_p__type_10 X1 X2);  tauto.
Defined.

Remark rem_2211 : forall X1:term, auto___def_6 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2212 : auto___def_6 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2213 : auto___def_6 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2214 : forall X1 X2 X3:term, auto___def_6 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2215 : auto___def_6 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2216 : forall X1 X2 X3:term, auto___def_6 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2217 : forall X1 X2:term, auto___def_6 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2218 : forall X1 X2:term, auto___def_6 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2219 : auto___def_6 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2220 : forall X1 X2 X3:term, auto___def_6 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2221 : auto___def_6 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2222 : forall X1 X2 X3 X4:term, auto___def_6 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2223 : auto___def_6 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2224 : forall X1 X2 X3 X4:term, auto___def_6 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2225 : auto___def_6 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2226 : auto___def_6 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2227 : auto___def_6 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2228 : forall X1:term, auto___def_6 X1 -> auto___type_10 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_6_p__type_10 1.
  intro X. case X.
   intro H. elim (rem_2221  H).
   intro H. elim (rem_2219  H).
  intros X1 X2. intro H. elim (rem_2217 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2218 X1 X2 H).
   intro H. elim (rem_2213  H).
   intro H. elim (rem_2225  H).
  intros X1 X2;  exact (rem_2210 epsilon_m__def_6_p__type_10 X1 X2).
   intro H. elim (rem_2212  H).
  intros X1 X2 X3. intro H. elim (rem_2216 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2220 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_2224 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_2222 X1 X2 X3 X4 H).
   intro H. elim (rem_2227  H).
   intro H. elim (rem_2223  H).
  intros X1. intro H. elim (rem_2211 X1 H).
   intro H. elim (rem_2226  H).
  intros X1 X2 X3. intro H. elim (rem_2214 X1 X2 X3 H).
   intro H. elim (rem_2215  H).
Qed.

Remark rem_2229 : forall X1 X2:term, auto___def_6 X1 -> auto___def_7 X2 -> auto___type_11 X2 -> auto___type_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_6 X1 -> auto___type_10 X1). tauto. exact (rem_2228 X1).
Qed.

Remark rem_2230 : forall X1 X2:term, auto___type_11 X2 -> auto___def_7 X2 -> auto___def_6 X1 -> auto___type_10 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_6 X1 -> auto___def_7 X2 -> auto___type_11 X2 -> auto___type_10 X1). tauto. exact (rem_2229 X1 X2).
Qed.

Remark rem_2231 : forall X1 X2:term, auto___def_45 X2 X1 -> auto___type_10 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_103 X2 X1 H);  intros.
  apply (rem_2172 X1 X2);  tauto.
  apply (rem_2174 X1 X2);  tauto.
  apply (rem_2202 X1 X2);  tauto.
  apply (rem_2230 X1 X2);  tauto.
Qed.

Remark rem_2232 : forall X1:term, auto___def_32 X1 -> auto___def_32 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2233 : forall X1 X2:term, auto___def_32 X1 -> auto___def_33 X2 -> auto___def_32 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_32 X1 -> auto___def_32 X1). tauto. exact (rem_2232 X1).
Qed.

Remark rem_2234 : forall X2:term, auto___def_33 X2 -> auto___def_33 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2235 : forall X1 X2:term, auto___def_32 X1 -> auto___def_33 X2 -> auto___def_33 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_33 X2 -> auto___def_33 X2). tauto. exact (rem_2234 X2).
Qed.

Remark rem_2236 : forall X1 X2:term, auto___def_32 X1 -> auto___def_33 X2 -> (auto___def_32 X1 /\ auto___def_33 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_32 X1). 2:apply (rem_2233 X1 X2);  assumption.
  cut (auto___def_33 X2). 2:apply (rem_2235 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2237 : forall X1 X2:term, auto___def_32 X1 -> auto___def_33 X2 -> auto___def_31 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2236 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_31_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2238 : forall X1 X2:term, auto___def_33 X2 -> auto___def_32 X1 -> auto___def_31 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_32 X1 -> auto___def_33 X2 -> auto___def_31 (cons X1 X2)). tauto. exact (rem_2237 X1 X2).
Qed.

Remark rem_2239 : (forall X:term, auto___def_2 X -> auto___type_3 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_2_p__type_3.  tauto.
Defined.

Remark rem_2240 : (forall X:term, auto___def_2 X -> auto___type_3 X)
    -> auto___type_3 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_2_p__type_3.  case (rem_2239 epsilon_m__def_2_p__type_3). clear  epsilon_m__def_2_p__type_3. intros. apply trans___type_3_alice_1;  tauto.
 clear  epsilon_m__def_2_p__type_3. tauto.
Defined.

Remark rem_2241 : (forall X:term, auto___def_2 X -> auto___type_3 X)
    -> auto___def_2 alice -> auto___type_3 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_2_p__type_3. intro H. intros.
  elim (rem_9 H);  intros.
  apply (rem_2240 epsilon_m__def_2_p__type_3);  tauto.
Defined.

Remark rem_2242 : forall X1:term, auto___def_2 X1 -> auto___type_3 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_2_p__type_3 1.
  intro X. case X.
  exact (rem_2241 epsilon_m__def_2_p__type_3 ).
   intro H. elim (rem_20  H).
  intros X1 X2. intro H. elim (rem_17 X1 X2 H).
  intros X1 X2. intro H. elim (rem_18 X1 X2 H).
   intro H. elim (rem_13  H).
   intro H. elim (rem_25  H).
  intros X1 X2. intro H. elim (rem_19 X1 X2 H).
   intro H. elim (rem_12  H).
  intros X1 X2 X3. intro H. elim (rem_16 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_21 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_24 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_22 X1 X2 X3 X4 H).
   intro H. elim (rem_27  H).
   intro H. elim (rem_23  H).
  intros X1. intro H. elim (rem_11 X1 H).
   intro H. elim (rem_26  H).
  intros X1 X2 X3. intro H. elim (rem_14 X1 X2 X3 H).
   intro H. elim (rem_15  H).
Qed.

Remark rem_2243 : forall X1 X2:term, auto___def_1 X2 -> auto___def_2 X1 -> auto_knows_old X1 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_2 X1 -> auto___type_3 X1). tauto. exact (rem_2242 X1).
Qed.

Remark rem_2244 : forall X1 X2:term, auto_knows_old X1 -> auto___def_2 X1 -> auto___def_1 X2 -> auto___type_3 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_1 X2 -> auto___def_2 X1 -> auto_knows_old X1 -> auto___type_3 X1). tauto. exact (rem_2243 X1 X2).
Qed.

Remark rem_2245 : (forall X:term, auto___def_5 X -> auto___type_3 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_5_p__type_3.  tauto.
Defined.

Remark rem_2246 : (forall X:term, auto___def_5 X -> auto___type_3 X)
    -> auto___type_3 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_5_p__type_3.  case (rem_2245 epsilon_m__def_5_p__type_3). clear  epsilon_m__def_5_p__type_3. intros. apply trans___type_3_bob_1;  tauto.
 clear  epsilon_m__def_5_p__type_3. tauto.
Defined.

Remark rem_2247 : (forall X:term, auto___def_5 X -> auto___type_3 X)
    -> auto___def_5 bob -> auto___type_3 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_5_p__type_3. intro H. intros.
  elim (rem_57 H);  intros.
  apply (rem_2246 epsilon_m__def_5_p__type_3);  tauto.
Defined.

Remark rem_2248 : forall X1:term, auto___def_5 X1 -> auto___type_3 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_5_p__type_3 1.
  intro X. case X.
   intro H. elim (rem_69  H).
  exact (rem_2247 epsilon_m__def_5_p__type_3 ).
  intros X1 X2. intro H. elim (rem_65 X1 X2 H).
  intros X1 X2. intro H. elim (rem_66 X1 X2 H).
   intro H. elim (rem_61  H).
   intro H. elim (rem_73  H).
  intros X1 X2. intro H. elim (rem_67 X1 X2 H).
   intro H. elim (rem_60  H).
  intros X1 X2 X3. intro H. elim (rem_64 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_68 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_72 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_70 X1 X2 X3 X4 H).
   intro H. elim (rem_75  H).
   intro H. elim (rem_71  H).
  intros X1. intro H. elim (rem_59 X1 H).
   intro H. elim (rem_74  H).
  intros X1 X2 X3. intro H. elim (rem_62 X1 X2 X3 H).
   intro H. elim (rem_63  H).
Qed.

Remark rem_2249 : forall X1 X2:term, auto___def_4 X2 -> auto___def_5 X1 -> auto_knows_old X1 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_5 X1 -> auto___type_3 X1). tauto. exact (rem_2248 X1).
Qed.

Remark rem_2250 : forall X1 X2:term, auto_knows_old X1 -> auto___def_5 X1 -> auto___def_4 X2 -> auto___type_3 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_4 X2 -> auto___def_5 X1 -> auto_knows_old X1 -> auto___type_3 X1). tauto. exact (rem_2249 X1 X2).
Qed.

Remark rem_2251 : (forall X:term, auto_knows_old X -> auto___def_9 X -> False)
    -> forall X1:term, auto___def_9 (s X1) -> auto_knows_old X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_9. intros X1. intro H. intros.
  elim (rem_35 X1 H);  intros.
Defined.

Remark rem_2252 : (forall X:term, auto_knows_old X -> auto___def_9 X -> False)
    -> forall X1:term, auto_knows_old (s X1) -> auto___def_9 (s X1) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_9. intros X1. intro H. intros.
  elim (rem_1315 X1 H);  intros.
  apply (rem_2251 epsilon_mknows_old_m__def_9 X1);  tauto.
Defined.

Remark rem_2253 : (forall X:term, auto_knows_old X -> auto___def_9 X -> False)
    -> auto___def_9 nil -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_9. intro H. intros.
  elim (rem_36 H);  intros.
Defined.

Remark rem_2254 : (forall X:term, auto_knows_old X -> auto___def_9 X -> False)
    -> auto_knows_old nil -> auto___def_9 nil -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_9. intro H. intros.
  elim (rem_1319 H);  intros.
  apply (rem_2253 epsilon_mknows_old_m__def_9);  tauto.
Defined.

Remark rem_2255 : (forall X:term, auto_knows_old X -> auto___def_9 X -> False)
    -> auto___def_9 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_9. intro H. intros.
  elim (rem_37 H);  intros.
Defined.

Remark rem_2256 : (forall X:term, auto_knows_old X -> auto___def_9 X -> False)
    -> auto_knows_old i -> auto___def_9 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_9. intro H. intros.
  elim (rem_1322 H);  intros.
  apply (rem_2255 epsilon_mknows_old_m__def_9);  tauto.
Defined.

Remark rem_2257 : (forall X:term, auto_knows_old X -> auto___def_9 X -> False)
    -> forall X1 X2:term, auto___def_9 (cons X1 X2) -> auto_knows_old X1 -> auto_knows_old X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_9. intros X1 X2. intro H. intros.
  elim (rem_41 X1 X2 H);  intros.
Defined.

Remark rem_2258 : (forall X:term, auto_knows_old X -> auto___def_9 X -> False)
    -> forall X1 X2:term, auto_knows_old (cons X1 X2) -> auto___def_9 (cons X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_9. intros X1 X2. intro H. intros.
  elim (rem_1329 X1 X2 H);  intros.
  apply (rem_2257 epsilon_mknows_old_m__def_9 X1 X2);  tauto.
Defined.

Remark rem_2259 : (forall X:term, auto_knows_old X -> auto___def_9 X -> False)
    -> forall X1 X2:term, auto___def_9 (crypt X1 X2) -> auto___def_32 X1 -> auto___type_2 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_9. intros X1 X2. intro H. intros.
  elim (rem_42 X1 X2 H);  intros.
Defined.

Remark rem_2260 : (forall X:term, auto_knows_old X -> auto___def_9 X -> False)
    -> forall X1 X2:term, auto___def_9 (crypt X1 X2) -> auto___def_25 X1 -> auto___type_4 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_9. intros X1 X2. intro H. intros.
  elim (rem_42 X1 X2 H);  intros.
Defined.

Remark rem_2261 : (forall X:term, auto_knows_old X -> auto___def_9 X -> False)
    -> forall X1 X2:term, auto___def_9 (crypt X1 X2) -> auto___def_19 X1 -> auto___def_20 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_9. intros X1 X2. intro H. intros.
  elim (rem_42 X1 X2 H);  intros.
Defined.

Remark rem_2262 : (forall X:term, auto_knows_old X -> auto___def_9 X -> False)
    -> forall X1 X2:term, auto___def_9 (crypt X1 X2) -> auto_knows_old X1 -> auto_knows_old X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_9. intros X1 X2. intro H. intros.
  elim (rem_42 X1 X2 H);  intros.
Defined.

Remark rem_2263 : (forall X:term, auto_knows_old X -> auto___def_9 X -> False)
    -> forall X1 X2:term, auto___def_9 (crypt X1 X2) -> auto___def_30 X1 -> auto___type_6 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_9. intros X1 X2. intro H. intros.
  elim (rem_42 X1 X2 H);  intros.
Defined.

Remark rem_2264 : (forall X:term, auto_knows_old X -> auto___def_9 X -> False)
    -> forall X1 X2:term, auto_knows_old (crypt X1 X2) -> auto___def_9 (crypt X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_9. intros X1 X2. intro H. intros.
  elim (rem_182 X1 X2 H);  intros.
  apply (rem_2259 epsilon_mknows_old_m__def_9 X1 X2);  tauto.
  apply (rem_2260 epsilon_mknows_old_m__def_9 X1 X2);  tauto.
  apply (rem_2261 epsilon_mknows_old_m__def_9 X1 X2);  tauto.
  apply (rem_2262 epsilon_mknows_old_m__def_9 X1 X2);  tauto.
  apply (rem_2263 epsilon_mknows_old_m__def_9 X1 X2);  tauto.
Defined.

Remark rem_2265 : (forall X:term, auto_knows_old X -> auto___def_9 X -> False)
    -> forall X1 X2:term, auto___def_9 (key X1 X2) -> auto___def_23 X1 -> auto___def_36 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_9. intros X1 X2. intro H. intros.
  elim (rem_43 X1 X2 H);  intros.
Defined.

Remark rem_2266 : (forall X:term, auto_knows_old X -> auto___def_9 X -> False)
    -> forall X1 X2:term, auto___def_9 (key X1 X2) -> auto___def_3 X1 -> auto___type_9 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_9. intros X1 X2. intro H. intros.
  elim (rem_43 X1 X2 H);  intros.
Defined.

Remark rem_2267 : (forall X:term, auto_knows_old X -> auto___def_9 X -> False)
    -> forall X1 X2:term, auto_knows_old (key X1 X2) -> auto___def_9 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_9. intros X1 X2. intro H. intros.
  elim (rem_172 X1 X2 H);  intros.
  apply (rem_2265 epsilon_mknows_old_m__def_9 X1 X2);  tauto.
  apply (rem_2266 epsilon_mknows_old_m__def_9 X1 X2);  tauto.
Defined.

Remark rem_2268 : (forall X:term, auto_knows_old X -> auto___def_9 X -> False)
    -> auto___def_9 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_9. intro H. intros.
  elim (rem_44 H);  intros.
Defined.

Remark rem_2269 : (forall X:term, auto_knows_old X -> auto___def_9 X -> False)
    -> auto_knows_old bob -> auto___def_9 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_9. intro H. intros.
  elim (rem_1371 H);  intros.
  apply (rem_2268 epsilon_mknows_old_m__def_9);  tauto.
Defined.

Remark rem_2270 : (forall X:term, auto_knows_old X -> auto___def_9 X -> False)
    -> auto___def_9 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_9. intro H. intros.
  elim (rem_46 H);  intros.
Defined.

Remark rem_2271 : (forall X:term, auto_knows_old X -> auto___def_9 X -> False)
    -> auto_knows_old alice -> auto___def_9 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_9. intro H. intros.
  elim (rem_1374 H);  intros.
  apply (rem_2270 epsilon_mknows_old_m__def_9);  tauto.
Defined.

Remark rem_2272 : (forall X:term, auto_knows_old X -> auto___def_9 X -> False)
    -> auto___def_9 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_9. intro H. intros.
  elim (rem_50 H);  intros.
Defined.

Remark rem_2273 : (forall X:term, auto_knows_old X -> auto___def_9 X -> False)
    -> auto_knows_old server -> auto___def_9 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_9. intro H. intros.
  elim (rem_1377 H);  intros.
  apply (rem_2272 epsilon_mknows_old_m__def_9);  tauto.
Defined.

Remark rem_2274 : forall X1:term, auto_knows_old X1 -> auto___def_9 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_mknows_old_m__def_9 1.
  intro X. case X.
  exact (rem_2271 epsilon_mknows_old_m__def_9 ).
  exact (rem_2269 epsilon_mknows_old_m__def_9 ).
  intros X1 X2;  exact (rem_2258 epsilon_mknows_old_m__def_9 X1 X2).
  intros X1 X2;  exact (rem_2264 epsilon_mknows_old_m__def_9 X1 X2).
  exact (rem_2256 epsilon_mknows_old_m__def_9 ).
   intro H. elim (rem_1386  H).
  intros X1 X2;  exact (rem_2267 epsilon_mknows_old_m__def_9 X1 X2).
  exact (rem_2254 epsilon_mknows_old_m__def_9 ).
  intros X1 X2 X3. intro H. elim (rem_1381 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1382 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1385 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1383 X1 X2 X3 X4 H).
   intro H. elim (rem_1387  H).
   intro H. elim (rem_1384  H).
  intros X1;  exact (rem_2252 epsilon_mknows_old_m__def_9 X1).
  exact (rem_2273 epsilon_mknows_old_m__def_9 ).
  intros X1 X2 X3. intro H. elim (rem_1379 X1 X2 X3 H).
   intro H. elim (rem_1380  H).
Qed.

Remark rem_2275 : forall X1 X2:term, auto___def_8 X2 -> auto___def_9 X1 -> auto_knows_old X1 -> auto___type_3 X1. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2274 X1)). tauto.
Qed.

Remark rem_2276 : forall X1 X2:term, auto_knows_old X1 -> auto___def_9 X1 -> auto___def_8 X2 -> auto___type_3 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_8 X2 -> auto___def_9 X1 -> auto_knows_old X1 -> auto___type_3 X1). tauto. exact (rem_2275 X1 X2).
Qed.

Remark rem_2277 : (forall X:term, auto___def_7 X -> auto___type_3 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_7_p__type_3.  tauto.
Defined.

Remark rem_2278 : (forall X:term, auto___def_7 X -> auto___type_3 X)
    -> auto___type_3 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_7_p__type_3.  case (rem_2277 epsilon_m__def_7_p__type_3). clear  epsilon_m__def_7_p__type_3. intros. apply trans___type_3_server_1;  tauto.
 clear  epsilon_m__def_7_p__type_3. tauto.
Defined.

Remark rem_2279 : (forall X:term, auto___def_7 X -> auto___type_3 X)
    -> auto___def_7 server -> auto___type_3 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_7_p__type_3. intro H. intros.
  elim (rem_81 H);  intros.
  apply (rem_2278 epsilon_m__def_7_p__type_3);  tauto.
Defined.

Remark rem_2280 : forall X1:term, auto___def_7 X1 -> auto___type_3 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_7_p__type_3 1.
  intro X. case X.
   intro H. elim (rem_94  H).
   intro H. elim (rem_92  H).
  intros X1 X2. intro H. elim (rem_89 X1 X2 H).
  intros X1 X2. intro H. elim (rem_90 X1 X2 H).
   intro H. elim (rem_85  H).
   intro H. elim (rem_98  H).
  intros X1 X2. intro H. elim (rem_91 X1 X2 H).
   intro H. elim (rem_84  H).
  intros X1 X2 X3. intro H. elim (rem_88 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_93 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_97 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_95 X1 X2 X3 X4 H).
   intro H. elim (rem_99  H).
   intro H. elim (rem_96  H).
  intros X1. intro H. elim (rem_83 X1 H).
  exact (rem_2279 epsilon_m__def_7_p__type_3 ).
  intros X1 X2 X3. intro H. elim (rem_86 X1 X2 X3 H).
   intro H. elim (rem_87  H).
Qed.

Remark rem_2281 : forall X1 X2:term, auto___def_6 X2 -> auto___def_7 X1 -> auto_agent X1 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_7 X1 -> auto___type_3 X1). tauto. exact (rem_2280 X1).
Qed.

Remark rem_2282 : forall X1 X2:term, auto___def_7 X1 -> auto_agent X1 -> auto___def_6 X2 -> auto___type_3 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_6 X2 -> auto___def_7 X1 -> auto_agent X1 -> auto___type_3 X1). tauto. exact (rem_2281 X1 X2).
Qed.

Remark rem_2283 : forall X1 X2:term, auto___def_18 X1 X2 -> or_4
    (auto_knows_old X1 /\ auto___def_2 X1 /\ auto___def_1 X2)
    (auto_knows_old X1 /\ auto___def_5 X1 /\ auto___def_4 X2)
    (auto_knows_old X1 /\ auto___def_9 X1 /\ auto___def_8 X2)
    (auto___def_7 X1 /\ auto_agent X1 /\ auto___def_6 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_4_intro_1; tauto.
  intros. apply or_4_intro_2; tauto.
  intros. apply or_4_intro_3; tauto.
  intros. apply or_4_intro_4; tauto.
Qed.

Remark rem_2284 : forall X1 X2:term, auto___def_18 X1 X2 -> auto___type_3 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_2283 X1 X2 H);  intros.
  apply (rem_2244 X1 X2);  tauto.
  apply (rem_2250 X1 X2);  tauto.
  apply (rem_2276 X1 X2);  tauto.
  apply (rem_2282 X1 X2);  tauto.
Qed.

Remark rem_2285 : forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_932 X1).
Qed.

Remark rem_2286 : forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___def_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_7 X2 -> auto___def_7 X2). tauto. exact (rem_394 X2).
Qed.

Remark rem_2287 : forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> (auto___def_3 X1 /\ auto___def_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2285 X1 X2);  assumption.
  cut (auto___def_7 X2). 2:apply (rem_2286 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2288 : forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___def_6 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2287 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_6_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2289 : forall X1 X2:term, auto___def_7 X2 -> auto___def_3 X1 -> auto___def_6 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_7 X2 -> auto___def_6 (key X1 X2)). tauto. exact (rem_2288 X1 X2).
Qed.

Remark rem_2290 : forall X1:term, auto___type_15 X1 -> auto___type_15 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2291 : forall X1 X2:term, auto___def_59 X2 -> auto___type_15 X1 -> auto___type_15 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_15 X1 -> auto___type_15 X1). tauto. exact (rem_2290 X1).
Qed.

Remark rem_2292 : forall X2:term, auto___def_59 X2 -> auto___def_59 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2293 : forall X1 X2:term, auto___def_59 X2 -> auto___type_15 X1 -> auto___def_59 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_59 X2 -> auto___def_59 X2). tauto. exact (rem_2292 X2).
Qed.

Remark rem_2294 : forall X1 X2:term, auto___def_59 X2 -> auto___type_15 X1 -> (auto___type_15 X1 /\ auto___def_59 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_15 X1). 2:apply (rem_2291 X1 X2);  assumption.
  cut (auto___def_59 X2). 2:apply (rem_2293 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2295 : forall X1 X2:term, auto___def_59 X2 -> auto___type_15 X1 -> auto___def_58 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2294 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_58_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2296 : auto___def_2 alice. (* Deduce positive atom. *)
Proof.
   case rem_135. intros. apply trans___def_2_alice_1;  tauto.
 tauto.
Qed.

Remark rem_2297 : forall X1 X2:term, auto_knows_current (cons X2 (cons X1 nil)) -> auto_knows_current (key prv server) -> auto___def_50 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto_knows_current (key prv server) -> False). tauto.
  exact (rem_424).
Qed.

Remark rem_2298 : forall X1 X2:term, auto___def_51 (cons X2 (cons X1 nil)) -> auto___type_12 (key prv server) -> auto___def_50 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___type_12 (key prv server) -> False). tauto.
  exact (rem_428).
Qed.

Remark rem_2299 : forall X1 X2:term, auto___def_57 (cons X2 (cons X1 nil)) -> auto___def_50 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_430 X2 (cons X1 nil) H);  intros.
Qed.

Remark rem_2300 : forall X1 X2:term, auto___def_57 (cons X2 (cons X1 nil)) -> auto___type_2 (key prv server) -> auto___def_50 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_57 (cons X2 (cons X1 nil)) -> auto___def_50 X1 X2). tauto.
  exact (rem_2299 X1 X2).
Qed.

Remark rem_2301 : forall X1 X2:term, auto___def_49 nil -> auto___type_10 X2 -> auto___type_11 X1 -> auto___type_11 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_11 X1 -> auto___type_11 X1). tauto. exact (rem_184 X1).
Qed.

Remark rem_2302 : forall X2:term, auto___type_10 X2 -> auto___type_10 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2303 : forall X1 X2:term, auto___def_49 nil -> auto___type_10 X2 -> auto___type_11 X1 -> auto___type_10 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_10 X2 -> auto___type_10 X2). tauto. exact (rem_2302 X2).
Qed.

Remark rem_2304 : forall X1 X2:term, auto___def_49 nil -> auto___type_10 X2 -> auto___type_11 X1 -> (auto___type_11 X1 /\ auto___type_10 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___type_11 X1). 2:apply (rem_2301 X1 X2);  assumption.
  cut (auto___type_10 X2). 2:apply (rem_2303 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2305 : forall X1 X2:term, auto___def_49 nil -> auto___type_10 X2 -> auto___type_11 X1 -> auto___def_50 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_2304 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_50_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2306 : forall X1 X2:term, auto___type_11 X1 -> auto___def_49 nil -> auto___type_10 X2 -> auto___def_50 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_49 nil -> auto___type_10 X2 -> auto___type_11 X1 -> auto___def_50 X1 X2). tauto. exact (rem_2305 X1 X2).
Qed.

Remark rem_2307 : forall X1 X2:term, auto___def_48 (cons X1 nil) -> auto___type_10 X2 -> auto___def_50 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_443 X1 nil H);  intros.
  apply (rem_2306 X1 X2);  tauto.
Qed.

Remark rem_2308 : forall X1 X2:term, auto___type_10 X2 -> auto___def_48 (cons X1 nil) -> auto___def_50 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_48 (cons X1 nil) -> auto___type_10 X2 -> auto___def_50 X1 X2). tauto. exact (rem_2307 X1 X2).
Qed.

Remark rem_2309 : forall X1 X2:term, auto___def_46 (cons X2 (cons X1 nil)) -> auto___def_50 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_446 X2 (cons X1 nil) H);  intros.
  apply (rem_2308 X1 X2);  tauto.
Qed.

Remark rem_2310 : forall X1 X2:term, auto___def_46 (cons X2 (cons X1 nil)) -> auto___def_47 (key prv server) -> auto___def_50 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_46 (cons X2 (cons X1 nil)) -> auto___def_50 X1 X2). tauto.
  exact (rem_2309 X1 X2).
Qed.

Remark rem_2311 : forall X1 X2:term, auto___def_57 X1 -> auto___def_58 nil -> auto___type_14 X2 -> auto___def_50 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_58 nil -> False). tauto.
  exact (rem_714).
Qed.

Remark rem_2312 : forall X1 X2:term, auto___def_56 (cons X1 nil) -> auto___type_14 X2 -> auto___def_50 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_505 X1 nil H);  intros.
  apply (rem_2311 X1 X2);  tauto.
Qed.

Remark rem_2313 : forall X1 X2:term, auto___type_14 X2 -> auto___def_56 (cons X1 nil) -> auto___def_50 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_56 (cons X1 nil) -> auto___type_14 X2 -> auto___def_50 X1 X2). tauto. exact (rem_2312 X1 X2).
Qed.

Remark rem_2314 : forall X1 X2:term, auto___def_55 (cons X2 (cons X1 nil)) -> auto___def_50 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_508 X2 (cons X1 nil) H);  intros.
  apply (rem_2313 X1 X2);  tauto.
Qed.

Remark rem_2315 : forall X1 X2:term, auto___def_55 (cons X2 (cons X1 nil)) -> auto___type_13 (key prv server) -> auto___def_50 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_55 (cons X2 (cons X1 nil)) -> auto___def_50 X1 X2). tauto.
  exact (rem_2314 X1 X2).
Qed.

Remark rem_2316 : forall X1 X2:term, auto_knows_current (crypt (cons X2 (cons X1 nil)) (key prv server)) -> auto___def_50 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_470 (cons X2 (cons X1 nil)) (key prv server) H);  intros.
  apply (rem_2297 X1 X2);  tauto.
  apply (rem_2298 X1 X2);  tauto.
  apply (rem_2300 X1 X2);  tauto.
  apply (rem_2310 X1 X2);  tauto.
  apply (rem_2315 X1 X2);  tauto.
Qed.

Remark rem_2317 : forall X1 X2 X3:term, auto___def_38 (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3.  case (rem_135). intros. apply trans___def_38_session_old_1;  tauto.
 tauto.
Qed.

Remark rem_2318 : forall X1 X2:term, auto___def_17 X2 -> auto_agent X1 -> auto___def_53 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_5 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_53_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2319 : forall X1 X2 X3 X4:term, auto___def_32 (cons (noncea_old X1 X3 X4) (cons X2 (cons X3 nil))) -> auto___type_2 (key pub X1) -> auto___def_35 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_190 (noncea_old X1 X3 X4) (cons X2 (cons X3 nil)) H);  intros.
Qed.

Remark rem_2320 : forall X1 X2 X3 X4:term, auto___def_17 (cons X3 nil) -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_4 (key pub X1) -> auto_agent X2 -> auto_agent X1 -> auto___def_35 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_846 X3 nil H);  intros.
Qed.

Remark rem_2321 : forall X1 X2 X3 X4:term, auto_agent X2 -> auto___def_17 (cons X3 nil) -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_4 (key pub X1) -> auto_agent X1 -> auto___def_35 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_17 (cons X3 nil) -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_4 (key pub X1) -> auto_agent X2 -> auto_agent X1 -> auto___def_35 X1 X2 X3 X4). tauto. exact (rem_2320 X1 X2 X3 X4).
Qed.

Remark rem_2322 : forall X1 X2 X3 X4:term, auto___def_27 (cons X2 (cons X3 nil)) -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_4 (key pub X1) -> auto_agent X1 -> auto___def_35 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1740 X2 (cons X3 nil) H);  intros.
  apply (rem_2321 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2323 : forall X1 X2 X3 X4:term, auto_agent X1 -> auto___type_3 X3 -> auto___type_2 X4 -> auto___def_27 (cons X2 (cons X3 nil)) -> auto___type_4 (key pub X1) -> auto___def_35 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_27 (cons X2 (cons X3 nil)) -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_4 (key pub X1) -> auto_agent X1 -> auto___def_35 X1 X2 X3 X4). tauto. exact (rem_2322 X1 X2 X3 X4).
Qed.

Remark rem_2324 : forall X1 X2 X3 X4:term, auto___def_26 (noncea_old X1 X3 X4) -> auto___def_27 (cons X2 (cons X3 nil)) -> auto___type_4 (key pub X1) -> auto___def_35 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1290 X1 X3 X4 H);  intros.
  apply (rem_2323 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2325 : forall X1 X2 X3 X4:term, auto___def_25 (cons (noncea_old X1 X3 X4) (cons X2 (cons X3 nil))) -> auto___type_4 (key pub X1) -> auto___def_35 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1742 (noncea_old X1 X3 X4) (cons X2 (cons X3 nil)) H);  intros.
  apply (rem_2324 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2326 : forall X1 X2 X3 X4:term, auto___def_22 (cons X3 nil) -> auto___def_7 X1 -> auto___type_2 (noncea_old X1 X3 X4) -> auto___type_3 X2 -> auto___def_35 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1488 X3 nil H);  intros.
Qed.

Remark rem_2327 : forall X1 X2 X3 X4:term, auto___type_3 X2 -> auto___def_22 (cons X3 nil) -> auto___def_7 X1 -> auto___type_2 (noncea_old X1 X3 X4) -> auto___def_35 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_22 (cons X3 nil) -> auto___def_7 X1 -> auto___type_2 (noncea_old X1 X3 X4) -> auto___type_3 X2 -> auto___def_35 X1 X2 X3 X4). tauto. exact (rem_2326 X1 X2 X3 X4).
Qed.

Remark rem_2328 : forall X1 X2 X3 X4:term, auto___def_21 (cons X2 (cons X3 nil)) -> auto___def_7 X1 -> auto___type_2 (noncea_old X1 X3 X4) -> auto___def_35 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_206 X2 (cons X3 nil) H);  intros.
  apply (rem_2327 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2329 : forall X1 X2 X3 X4:term, auto___def_21 (cons X2 (cons X3 nil)) -> auto___def_23 pub -> auto___def_7 X1 -> auto___type_2 (noncea_old X1 X3 X4) -> auto___def_35 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_21 (cons X2 (cons X3 nil)) -> auto___def_7 X1 -> auto___type_2 (noncea_old X1 X3 X4) -> auto___def_35 X1 X2 X3 X4). tauto.
  exact (rem_2328 X1 X2 X3 X4).
Qed.

Remark rem_2330 : forall X1 X2 X3 X4:term, auto___def_23 pub -> auto___def_7 X1 -> auto___def_21 (cons X2 (cons X3 nil)) -> auto___type_2 (noncea_old X1 X3 X4) -> auto___def_35 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_21 (cons X2 (cons X3 nil)) -> auto___def_23 pub -> auto___def_7 X1 -> auto___type_2 (noncea_old X1 X3 X4) -> auto___def_35 X1 X2 X3 X4). tauto. exact (rem_2329 X1 X2 X3 X4).
Qed.

Remark rem_2331 : forall X1 X2 X3 X4:term, auto___def_20 (key pub X1) -> auto___def_21 (cons X2 (cons X3 nil)) -> auto___type_2 (noncea_old X1 X3 X4) -> auto___def_35 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_162 pub X1 H);  intros.
  apply (rem_2330 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2332 : forall X1 X2 X3 X4:term, auto___type_2 (noncea_old X1 X3 X4) -> auto___def_21 (cons X2 (cons X3 nil)) -> auto___def_20 (key pub X1) -> auto___def_35 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_20 (key pub X1) -> auto___def_21 (cons X2 (cons X3 nil)) -> auto___type_2 (noncea_old X1 X3 X4) -> auto___def_35 X1 X2 X3 X4). tauto. exact (rem_2331 X1 X2 X3 X4).
Qed.

Remark rem_2333 : forall X1 X2 X3 X4:term, auto___def_19 (cons (noncea_old X1 X3 X4) (cons X2 (cons X3 nil))) -> auto___def_20 (key pub X1) -> auto___def_35 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_209 (noncea_old X1 X3 X4) (cons X2 (cons X3 nil)) H);  intros.
  apply (rem_2332 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2334 : forall X1 X2 X3 X4:term, auto___def_36 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old (noncea_old X1 X3 X4) -> auto___def_35 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3. intro H. intros.
  elim (rem_1382 X1 X3 X4 H);  intros.
Qed.

Remark rem_2335 : forall X1 X2 X3 X4:term, auto___def_23 pub -> auto___def_36 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old (noncea_old X1 X3 X4) -> auto___def_35 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_36 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old (noncea_old X1 X3 X4) -> auto___def_35 X1 X2 X3 X4). tauto.
  exact (rem_2334 X1 X2 X3 X4).
Qed.

Remark rem_2336 : forall X1 X2 X3 X4:term, auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old (noncea_old X1 X3 X4) -> auto___def_35 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_1382 X1 X3 X4 H);  intros.
Qed.

Remark rem_2337 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old (noncea_old X1 X3 X4) -> auto___def_35 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old (noncea_old X1 X3 X4) -> auto___def_35 X1 X2 X3 X4). tauto.
  exact (rem_2336 X1 X2 X3 X4).
Qed.

Remark rem_2338 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto___type_9 X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old (noncea_old X1 X3 X4) -> auto___def_35 X1 X2 X3 X4. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2 X3 X4. intros. apply (rem_2337 X1 X2 X3 X4);  assumption.
Qed.

Remark rem_2339 : forall X1 X2 X3 X4:term, auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old (key pub X1) -> auto_knows_old (noncea_old X1 X3 X4) -> auto___def_35 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_172 pub X1 H);  intros.
  apply (rem_2335 X1 X2 X3 X4);  tauto.
  apply (rem_2338 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2340 : forall X1 X2 X3 X4:term, auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old (key pub X1) -> auto_knows_old nil -> auto_knows_old (noncea_old X1 X3 X4) -> auto___def_35 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old (key pub X1) -> auto_knows_old (noncea_old X1 X3 X4) -> auto___def_35 X1 X2 X3 X4). tauto.
  exact (rem_2339 X1 X2 X3 X4).
Qed.

Remark rem_2341 : forall X1 X2 X3 X4:term, auto_knows_old X3 -> auto_knows_old nil -> auto_knows_old X2 -> auto_knows_old (key pub X1) -> auto_knows_old (noncea_old X1 X3 X4) -> auto___def_35 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old (key pub X1) -> auto_knows_old nil -> auto_knows_old (noncea_old X1 X3 X4) -> auto___def_35 X1 X2 X3 X4). tauto. exact (rem_2340 X1 X2 X3 X4).
Qed.

Remark rem_2342 : forall X1 X2 X3 X4:term, auto_knows_old X2 -> auto_knows_old (cons X3 nil) -> auto_knows_old (key pub X1) -> auto_knows_old (noncea_old X1 X3 X4) -> auto___def_35 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_1329 X3 nil H);  intros.
  apply (rem_2341 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2343 : forall X1 X2 X3 X4:term, auto_knows_old (cons X2 (cons X3 nil)) -> auto_knows_old (key pub X1) -> auto_knows_old (noncea_old X1 X3 X4) -> auto___def_35 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1329 X2 (cons X3 nil) H);  intros.
  apply (rem_2342 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2344 : forall X1 X2 X3 X4:term, auto_knows_old (noncea_old X1 X3 X4) -> auto_knows_old (cons X2 (cons X3 nil)) -> auto_knows_old (key pub X1) -> auto___def_35 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_old (cons X2 (cons X3 nil)) -> auto_knows_old (key pub X1) -> auto_knows_old (noncea_old X1 X3 X4) -> auto___def_35 X1 X2 X3 X4). tauto. exact (rem_2343 X1 X2 X3 X4).
Qed.

Remark rem_2345 : forall X1 X2 X3 X4:term, auto_knows_old (cons (noncea_old X1 X3 X4) (cons X2 (cons X3 nil))) -> auto_knows_old (key pub X1) -> auto___def_35 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1329 (noncea_old X1 X3 X4) (cons X2 (cons X3 nil)) H);  intros.
  apply (rem_2344 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2346 : forall X1 X2 X3 X4:term, auto___def_2 X1 -> auto___def_32 X2 -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_8 X3 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X1 -> auto_agent X1). tauto. exact (rem_864 X1).
Qed.

Remark rem_2347 : forall X1 X2 X3 X4:term, auto___def_2 X1 -> auto___def_32 X2 -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_8 X3 -> auto_agent X1 -> auto___def_2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X1 -> auto___def_2 X1). tauto. exact (rem_866 X1).
Qed.

Remark rem_2348 : forall X1 X2 X3 X4:term, auto___def_2 X1 -> auto___def_32 X2 -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_8 X3 -> auto_agent X1 -> auto___def_32 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_32 X2 -> auto___def_32 X2). tauto. exact (rem_1398 X2).
Qed.

Remark rem_2349 : (forall X:term, auto___type_3 X -> auto___type_8 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_p__type_8.  tauto.
Defined.

Remark rem_2350 : (forall X:term, auto___type_3 X -> auto___type_8 X)
    -> auto___type_8 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_p__type_8.  case (rem_2349 epsilon_m__type_3_p__type_8). clear  epsilon_m__type_3_p__type_8. intros. apply trans___type_8_bob_1;  tauto.
 clear  epsilon_m__type_3_p__type_8. tauto.
Defined.

Remark rem_2351 : (forall X:term, auto___type_3 X -> auto___type_8 X)
    -> auto___type_3 bob -> auto___type_8 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_p__type_8. intro H. intros.
  elim (rem_369 H);  intros.
  apply (rem_2350 epsilon_m__type_3_p__type_8);  tauto.
Defined.

Remark rem_2352 : (forall X:term, auto___type_3 X -> auto___type_8 X)
    -> auto___type_8 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_p__type_8.  case (rem_2349 epsilon_m__type_3_p__type_8). clear  epsilon_m__type_3_p__type_8. intros. apply trans___type_8_alice_1;  tauto.
 clear  epsilon_m__type_3_p__type_8. tauto.
Defined.

Remark rem_2353 : (forall X:term, auto___type_3 X -> auto___type_8 X)
    -> auto___type_3 alice -> auto___type_8 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_p__type_8. intro H. intros.
  elim (rem_372 H);  intros.
  apply (rem_2352 epsilon_m__type_3_p__type_8);  tauto.
Defined.

Remark rem_2354 : (forall X:term, auto___type_3 X -> auto___type_8 X)
    -> auto___type_8 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_p__type_8.  case (rem_2349 epsilon_m__type_3_p__type_8). clear  epsilon_m__type_3_p__type_8. intros. apply trans___type_8_server_1;  tauto.
 clear  epsilon_m__type_3_p__type_8. tauto.
Defined.

Remark rem_2355 : (forall X:term, auto___type_3 X -> auto___type_8 X)
    -> auto___type_3 server -> auto___type_8 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_p__type_8. intro H. intros.
  elim (rem_375 H);  intros.
  apply (rem_2354 epsilon_m__type_3_p__type_8);  tauto.
Defined.

Remark rem_2356 : forall X3:term, auto___type_3 X3 -> auto___type_8 X3. (* Induct. *)
Proof.
  fix epsilon_m__type_3_p__type_8 1.
  intro X. case X.
  exact (rem_2353 epsilon_m__type_3_p__type_8 ).
  exact (rem_2351 epsilon_m__type_3_p__type_8 ).
  intros X1 X2. intro H. elim (rem_383 X1 X2 H).
  intros X1 X2. intro H. elim (rem_384 X1 X2 H).
   intro H. elim (rem_379  H).
   intro H. elim (rem_390  H).
  intros X1 X2. intro H. elim (rem_385 X1 X2 H).
   intro H. elim (rem_378  H).
  intros X1 X2 X3. intro H. elim (rem_382 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_386 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_389 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_387 X1 X2 X3 X4 H).
   intro H. elim (rem_391  H).
   intro H. elim (rem_388  H).
  intros X1. intro H. elim (rem_377 X1 H).
  exact (rem_2355 epsilon_m__type_3_p__type_8 ).
  intros X1 X2 X3. intro H. elim (rem_380 X1 X2 X3 H).
   intro H. elim (rem_381  H).
Qed.

Remark rem_2357 : forall X1 X2 X3 X4:term, auto___def_2 X1 -> auto___def_32 X2 -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_8 X3 -> auto_agent X1 -> auto___type_8 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_3 X3 -> auto___type_8 X3). tauto. exact (rem_2356 X3).
Qed.

Remark rem_2358 : forall X3:term, auto___type_3 X3 -> auto___type_3 X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2359 : forall X1 X2 X3 X4:term, auto___def_2 X1 -> auto___def_32 X2 -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_8 X3 -> auto_agent X1 -> auto___type_3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_3 X3 -> auto___type_3 X3). tauto. exact (rem_2358 X3).
Qed.

Remark rem_2360 : forall X1 X2 X3 X4:term, auto___def_2 X1 -> auto___def_32 X2 -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_8 X3 -> auto_agent X1 -> auto___type_2 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_2 X4 -> auto___type_2 X4). tauto. exact (rem_1632 X4).
Qed.

Remark rem_2361 : forall X1 X2 X3 X4:term, auto___def_2 X1 -> auto___def_32 X2 -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_8 X3 -> auto_agent X1 -> (auto_agent X1 /\ auto___def_2 X1 /\ auto___def_32 X2 /\ auto___type_8 X3 /\ auto___type_3 X3 /\ auto___type_2 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  cut (auto_agent X1). 2:apply (rem_2346 X1 X2 X3 X4);  assumption.
  cut (auto___def_2 X1). 2:apply (rem_2347 X1 X2 X3 X4);  assumption.
  cut (auto___def_32 X2). 2:apply (rem_2348 X1 X2 X3 X4);  assumption.
  cut (auto___type_8 X3). 2:apply (rem_2357 X1 X2 X3 X4);  assumption.
  cut (auto___type_3 X3). 2:apply (rem_2359 X1 X2 X3 X4);  assumption.
  cut (auto___type_2 X4). 2:apply (rem_2360 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_2362 : forall X1 X2 X3 X4:term, auto___def_2 X1 -> auto___def_32 X2 -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_8 X3 -> auto_agent X1 -> auto___def_35 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  case (rem_2361 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6). clear  A1 A2 A3 A4 A5 A6. intros. apply trans___def_35_3;  tauto.
 clear  A1 A2 A3 A4 A5 A6. tauto.
Qed.

Remark rem_2363 : forall X1 X2 X3 X4:term, auto_agent X1 -> auto___type_3 X3 -> auto___type_2 X4 -> auto___def_2 X1 -> auto___def_32 X2 -> auto___type_8 X3 -> auto___def_35 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X1 -> auto___def_32 X2 -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_8 X3 -> auto_agent X1 -> auto___def_35 X1 X2 X3 X4). tauto. exact (rem_2362 X1 X2 X3 X4).
Qed.

Remark rem_2364 : forall X1 X2 X3:term, auto___type_7 (noncea_old X1 X2 X3) -> or_1
    (auto_agent X1 /\ auto___type_3 X2 /\ auto___type_2 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2365 : forall X1 X2 X3 X4:term, auto___def_2 X1 -> auto___def_32 X2 -> auto___type_7 (noncea_old X1 X3 X4) -> auto___type_8 X3 -> auto___def_35 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_2364 X1 X3 X4 H);  intros.
  apply (rem_2363 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2366 : forall X1 X2 X3 X4:term, auto___def_2 X1 -> auto___def_3 pub -> auto___def_32 X2 -> auto___type_7 (noncea_old X1 X3 X4) -> auto___type_8 X3 -> auto___def_35 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X1 -> auto___def_32 X2 -> auto___type_7 (noncea_old X1 X3 X4) -> auto___type_8 X3 -> auto___def_35 X1 X2 X3 X4). tauto.
  exact (rem_2365 X1 X2 X3 X4).
Qed.

Remark rem_2367 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto___def_2 X1 -> auto___def_32 X2 -> auto___type_7 (noncea_old X1 X3 X4) -> auto___type_8 X3 -> auto___def_35 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_2 X1 -> auto___def_3 pub -> auto___def_32 X2 -> auto___type_7 (noncea_old X1 X3 X4) -> auto___type_8 X3 -> auto___def_35 X1 X2 X3 X4). tauto. exact (rem_2366 X1 X2 X3 X4).
Qed.

Remark rem_2368 : forall X1 X2 X3 X4:term, auto___def_32 X2 -> auto___def_5 X1 -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_8 X3 -> auto_agent X1 -> auto___def_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_5 X1 -> auto___def_5 X1). tauto. exact (rem_889 X1).
Qed.

Remark rem_2369 : forall X1 X2 X3 X4:term, auto___def_32 X2 -> auto___def_5 X1 -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_8 X3 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_5 X1 -> auto_agent X1). tauto. exact (rem_891 X1).
Qed.

Remark rem_2370 : forall X1 X2 X3 X4:term, auto___def_32 X2 -> auto___def_5 X1 -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_8 X3 -> auto_agent X1 -> auto___def_32 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_32 X2 -> auto___def_32 X2). tauto. exact (rem_1398 X2).
Qed.

Remark rem_2371 : forall X1 X2 X3 X4:term, auto___def_32 X2 -> auto___def_5 X1 -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_8 X3 -> auto_agent X1 -> auto___type_8 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_3 X3 -> auto___type_8 X3). tauto. exact (rem_2356 X3).
Qed.

Remark rem_2372 : forall X1 X2 X3 X4:term, auto___def_32 X2 -> auto___def_5 X1 -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_8 X3 -> auto_agent X1 -> auto___type_3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_3 X3 -> auto___type_3 X3). tauto. exact (rem_2358 X3).
Qed.

Remark rem_2373 : forall X1 X2 X3 X4:term, auto___def_32 X2 -> auto___def_5 X1 -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_8 X3 -> auto_agent X1 -> auto___type_2 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_2 X4 -> auto___type_2 X4). tauto. exact (rem_1632 X4).
Qed.

Remark rem_2374 : forall X1 X2 X3 X4:term, auto___def_32 X2 -> auto___def_5 X1 -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_8 X3 -> auto_agent X1 -> (auto___def_5 X1 /\ auto_agent X1 /\ auto___def_32 X2 /\ auto___type_8 X3 /\ auto___type_3 X3 /\ auto___type_2 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  cut (auto___def_5 X1). 2:apply (rem_2368 X1 X2 X3 X4);  assumption.
  cut (auto_agent X1). 2:apply (rem_2369 X1 X2 X3 X4);  assumption.
  cut (auto___def_32 X2). 2:apply (rem_2370 X1 X2 X3 X4);  assumption.
  cut (auto___type_8 X3). 2:apply (rem_2371 X1 X2 X3 X4);  assumption.
  cut (auto___type_3 X3). 2:apply (rem_2372 X1 X2 X3 X4);  assumption.
  cut (auto___type_2 X4). 2:apply (rem_2373 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_2375 : forall X1 X2 X3 X4:term, auto___def_32 X2 -> auto___def_5 X1 -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_8 X3 -> auto_agent X1 -> auto___def_35 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  case (rem_2374 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6). clear  A1 A2 A3 A4 A5 A6. intros. apply trans___def_35_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6. tauto.
Qed.

Remark rem_2376 : forall X1 X2 X3 X4:term, auto_agent X1 -> auto___type_3 X3 -> auto___type_2 X4 -> auto___def_32 X2 -> auto___def_5 X1 -> auto___type_8 X3 -> auto___def_35 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_32 X2 -> auto___def_5 X1 -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_8 X3 -> auto_agent X1 -> auto___def_35 X1 X2 X3 X4). tauto. exact (rem_2375 X1 X2 X3 X4).
Qed.

Remark rem_2377 : forall X1 X2 X3 X4:term, auto___def_32 X2 -> auto___def_5 X1 -> auto___type_7 (noncea_old X1 X3 X4) -> auto___type_8 X3 -> auto___def_35 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_2364 X1 X3 X4 H);  intros.
  apply (rem_2376 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2378 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto___def_32 X2 -> auto___def_5 X1 -> auto___type_7 (noncea_old X1 X3 X4) -> auto___type_8 X3 -> auto___def_35 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_32 X2 -> auto___def_5 X1 -> auto___type_7 (noncea_old X1 X3 X4) -> auto___type_8 X3 -> auto___def_35 X1 X2 X3 X4). tauto.
  exact (rem_2377 X1 X2 X3 X4).
Qed.

Remark rem_2379 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto___def_5 X1 -> auto___def_32 X2 -> auto___type_7 (noncea_old X1 X3 X4) -> auto___type_8 X3 -> auto___def_35 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_3 pub -> auto___def_32 X2 -> auto___def_5 X1 -> auto___type_7 (noncea_old X1 X3 X4) -> auto___type_8 X3 -> auto___def_35 X1 X2 X3 X4). tauto. exact (rem_2378 X1 X2 X3 X4).
Qed.

Remark rem_2380 : forall X1 X2 X3 X4:term, auto___def_32 X2 -> auto___def_7 X1 -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_8 X3 -> auto_agent X1 -> auto___def_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_7 X1 -> auto___def_7 X1). tauto. exact (rem_155 X1).
Qed.

Remark rem_2381 : forall X1 X2 X3 X4:term, auto___def_32 X2 -> auto___def_7 X1 -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_8 X3 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_7 X1 -> auto_agent X1). tauto. exact (rem_904 X1).
Qed.

Remark rem_2382 : forall X1 X2 X3 X4:term, auto___def_32 X2 -> auto___def_7 X1 -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_8 X3 -> auto_agent X1 -> auto___def_32 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_32 X2 -> auto___def_32 X2). tauto. exact (rem_1398 X2).
Qed.

Remark rem_2383 : forall X1 X2 X3 X4:term, auto___def_32 X2 -> auto___def_7 X1 -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_8 X3 -> auto_agent X1 -> auto___type_8 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_3 X3 -> auto___type_8 X3). tauto. exact (rem_2356 X3).
Qed.

Remark rem_2384 : forall X1 X2 X3 X4:term, auto___def_32 X2 -> auto___def_7 X1 -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_8 X3 -> auto_agent X1 -> auto___type_3 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_3 X3 -> auto___type_3 X3). tauto. exact (rem_2358 X3).
Qed.

Remark rem_2385 : forall X1 X2 X3 X4:term, auto___def_32 X2 -> auto___def_7 X1 -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_8 X3 -> auto_agent X1 -> auto___type_2 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_2 X4 -> auto___type_2 X4). tauto. exact (rem_1632 X4).
Qed.

Remark rem_2386 : forall X1 X2 X3 X4:term, auto___def_32 X2 -> auto___def_7 X1 -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_8 X3 -> auto_agent X1 -> (auto___def_7 X1 /\ auto_agent X1 /\ auto___def_32 X2 /\ auto___type_8 X3 /\ auto___type_3 X3 /\ auto___type_2 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  cut (auto___def_7 X1). 2:apply (rem_2380 X1 X2 X3 X4);  assumption.
  cut (auto_agent X1). 2:apply (rem_2381 X1 X2 X3 X4);  assumption.
  cut (auto___def_32 X2). 2:apply (rem_2382 X1 X2 X3 X4);  assumption.
  cut (auto___type_8 X3). 2:apply (rem_2383 X1 X2 X3 X4);  assumption.
  cut (auto___type_3 X3). 2:apply (rem_2384 X1 X2 X3 X4);  assumption.
  cut (auto___type_2 X4). 2:apply (rem_2385 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_2387 : forall X1 X2 X3 X4:term, auto___def_32 X2 -> auto___def_7 X1 -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_8 X3 -> auto_agent X1 -> auto___def_35 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  case (rem_2386 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6). clear  A1 A2 A3 A4 A5 A6. intros. apply trans___def_35_2;  tauto.
 clear  A1 A2 A3 A4 A5 A6. tauto.
Qed.

Remark rem_2388 : forall X1 X2 X3 X4:term, auto_agent X1 -> auto___type_3 X3 -> auto___type_2 X4 -> auto___def_32 X2 -> auto___def_7 X1 -> auto___type_8 X3 -> auto___def_35 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_32 X2 -> auto___def_7 X1 -> auto___type_2 X4 -> auto___type_3 X3 -> auto___type_8 X3 -> auto_agent X1 -> auto___def_35 X1 X2 X3 X4). tauto. exact (rem_2387 X1 X2 X3 X4).
Qed.

Remark rem_2389 : forall X1 X2 X3 X4:term, auto___def_32 X2 -> auto___def_7 X1 -> auto___type_7 (noncea_old X1 X3 X4) -> auto___type_8 X3 -> auto___def_35 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_2364 X1 X3 X4 H);  intros.
  apply (rem_2388 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2390 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto___def_32 X2 -> auto___def_7 X1 -> auto___type_7 (noncea_old X1 X3 X4) -> auto___type_8 X3 -> auto___def_35 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_32 X2 -> auto___def_7 X1 -> auto___type_7 (noncea_old X1 X3 X4) -> auto___type_8 X3 -> auto___def_35 X1 X2 X3 X4). tauto.
  exact (rem_2389 X1 X2 X3 X4).
Qed.

Remark rem_2391 : forall X1 X2 X3 X4:term, auto___def_3 pub -> auto___def_7 X1 -> auto___def_32 X2 -> auto___type_7 (noncea_old X1 X3 X4) -> auto___type_8 X3 -> auto___def_35 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_3 pub -> auto___def_32 X2 -> auto___def_7 X1 -> auto___type_7 (noncea_old X1 X3 X4) -> auto___type_8 X3 -> auto___def_35 X1 X2 X3 X4). tauto. exact (rem_2390 X1 X2 X3 X4).
Qed.

Remark rem_2392 : forall X1 X2 X3 X4:term, auto___def_32 X2 -> auto___type_6 (key pub X1) -> auto___type_7 (noncea_old X1 X3 X4) -> auto___type_8 X3 -> auto___def_35 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_180 pub X1 H);  intros.
  apply (rem_2367 X1 X2 X3 X4);  tauto.
  apply (rem_2379 X1 X2 X3 X4);  tauto.
  apply (rem_2391 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2393 : forall X1 X2 X3 X4:term, auto___def_32 X2 -> auto___def_34 nil -> auto___type_6 (key pub X1) -> auto___type_7 (noncea_old X1 X3 X4) -> auto___type_8 X3 -> auto___def_35 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_32 X2 -> auto___type_6 (key pub X1) -> auto___type_7 (noncea_old X1 X3 X4) -> auto___type_8 X3 -> auto___def_35 X1 X2 X3 X4). tauto.
  exact (rem_2392 X1 X2 X3 X4).
Qed.

Remark rem_2394 : forall X1 X2 X3 X4:term, auto___type_8 X3 -> auto___def_34 nil -> auto___def_32 X2 -> auto___type_6 (key pub X1) -> auto___type_7 (noncea_old X1 X3 X4) -> auto___def_35 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_32 X2 -> auto___def_34 nil -> auto___type_6 (key pub X1) -> auto___type_7 (noncea_old X1 X3 X4) -> auto___type_8 X3 -> auto___def_35 X1 X2 X3 X4). tauto. exact (rem_2393 X1 X2 X3 X4).
Qed.

Remark rem_2395 : forall X1 X2:term, auto___def_33 (cons X1 X2) -> or_1
    (auto___type_8 X1 /\ auto___def_34 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2396 : forall X1 X2 X3 X4:term, auto___def_32 X2 -> auto___def_33 (cons X3 nil) -> auto___type_6 (key pub X1) -> auto___type_7 (noncea_old X1 X3 X4) -> auto___def_35 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_2395 X3 nil H);  intros.
  apply (rem_2394 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2397 : forall X1 X2 X3 X4:term, auto___def_31 (cons X2 (cons X3 nil)) -> auto___type_6 (key pub X1) -> auto___type_7 (noncea_old X1 X3 X4) -> auto___def_35 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_221 X2 (cons X3 nil) H);  intros.
  apply (rem_2396 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2398 : forall X1 X2 X3 X4:term, auto___type_7 (noncea_old X1 X3 X4) -> auto___def_31 (cons X2 (cons X3 nil)) -> auto___type_6 (key pub X1) -> auto___def_35 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_31 (cons X2 (cons X3 nil)) -> auto___type_6 (key pub X1) -> auto___type_7 (noncea_old X1 X3 X4) -> auto___def_35 X1 X2 X3 X4). tauto. exact (rem_2397 X1 X2 X3 X4).
Qed.

Remark rem_2399 : forall X1 X2 X3 X4:term, auto___def_30 (cons (noncea_old X1 X3 X4) (cons X2 (cons X3 nil))) -> auto___type_6 (key pub X1) -> auto___def_35 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_224 (noncea_old X1 X3 X4) (cons X2 (cons X3 nil)) H);  intros.
  apply (rem_2398 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2400 : forall X1 X2 X3 X4:term, auto_knows_old (crypt (cons (noncea_old X1 X3 X4) (cons X2 (cons X3 nil))) (key pub X1)) -> auto___def_35 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_182 (cons (noncea_old X1 X3 X4) (cons X2 (cons X3 nil))) (key pub X1) H);  intros.
  apply (rem_2319 X1 X2 X3 X4);  tauto.
  apply (rem_2325 X1 X2 X3 X4);  tauto.
  apply (rem_2333 X1 X2 X3 X4);  tauto.
  apply (rem_2345 X1 X2 X3 X4);  tauto.
  apply (rem_2399 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2401 : (forall X:term, auto___def_1 X -> auto___type_2 X)
    -> forall X1:term, auto___def_3 X1 -> auto___def_3 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2402 : (forall X:term, auto___def_1 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_1_p__type_2. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2401 epsilon_m__def_1_p__type_2 X1).
Defined.

Remark rem_2403 : (forall X:term, auto___def_1 X -> auto___type_2 X)
    -> forall X2:term, auto___def_2 X2 -> auto___def_2 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2404 : (forall X:term, auto___def_1 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___def_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_1_p__type_2. intros X1 X2.
  cut (auto___def_2 X2 -> auto___def_2 X2). tauto. exact (rem_2403 epsilon_m__def_1_p__type_2 X2).
Defined.

Remark rem_2405 : (forall X:term, auto___def_1 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> (auto___def_3 X1 /\ auto___def_2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_1_p__type_2. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2402 epsilon_m__def_1_p__type_2 X1 X2);  assumption.
  cut (auto___def_2 X2). 2:apply (rem_2404 epsilon_m__def_1_p__type_2 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2406 : (forall X:term, auto___def_1 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___type_2 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_1_p__type_2. intros X1 X2. intros A1 A2.
  case (rem_2405 epsilon_m__def_1_p__type_2 X1 X2 A1 A2). clear  epsilon_m__def_1_p__type_2 A1 A2. intros. apply trans___type_2_key_1;  tauto.
 clear  epsilon_m__def_1_p__type_2 A1 A2. tauto.
Defined.

Remark rem_2407 : (forall X:term, auto___def_1 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_1 (key X1 X2) -> auto___type_2 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_1_p__type_2. intros X1 X2. intro H. intros.
  elim (rem_2151 X1 X2 H);  intros.
  apply (rem_2406 epsilon_m__def_1_p__type_2 X1 X2);  tauto.
Defined.

Remark rem_2408 : forall X1:term, auto___def_1 X1 -> auto___type_2 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_1_p__type_2 1.
  intro X. case X.
   intro H. elim (rem_2163  H).
   intro H. elim (rem_2161  H).
  intros X1 X2. intro H. elim (rem_2159 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2160 X1 X2 H).
   intro H. elim (rem_2155  H).
   intro H. elim (rem_2167  H).
  intros X1 X2;  exact (rem_2407 epsilon_m__def_1_p__type_2 X1 X2).
   intro H. elim (rem_2154  H).
  intros X1 X2 X3. intro H. elim (rem_2158 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2162 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_2166 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_2164 X1 X2 X3 X4 H).
   intro H. elim (rem_2169  H).
   intro H. elim (rem_2165  H).
  intros X1. intro H. elim (rem_2153 X1 H).
   intro H. elim (rem_2168  H).
  intros X1 X2 X3. intro H. elim (rem_2156 X1 X2 X3 H).
   intro H. elim (rem_2157  H).
Qed.

Remark rem_2409 : forall X1 X2:term, auto___def_1 X1 -> auto___def_2 X2 -> auto_knows_old X2 -> auto___type_2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_1 X1 -> auto___type_2 X1). tauto. exact (rem_2408 X1).
Qed.

Remark rem_2410 : forall X1 X2:term, auto_knows_old X2 -> auto___def_2 X2 -> auto___def_1 X1 -> auto___type_2 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_1 X1 -> auto___def_2 X2 -> auto_knows_old X2 -> auto___type_2 X1). tauto. exact (rem_2409 X1 X2).
Qed.

Remark rem_2411 : (forall X:term, auto___def_4 X -> auto___type_2 X)
    -> forall X1:term, auto___def_3 X1 -> auto___def_3 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2412 : (forall X:term, auto___def_4 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_4_p__type_2. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2411 epsilon_m__def_4_p__type_2 X1).
Defined.

Remark rem_2413 : (forall X:term, auto___def_4 X -> auto___type_2 X)
    -> forall X2:term, auto___def_5 X2 -> auto___def_5 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2414 : (forall X:term, auto___def_4 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___def_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_4_p__type_2. intros X1 X2.
  cut (auto___def_5 X2 -> auto___def_5 X2). tauto. exact (rem_2413 epsilon_m__def_4_p__type_2 X2).
Defined.

Remark rem_2415 : (forall X:term, auto___def_4 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> (auto___def_3 X1 /\ auto___def_5 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_4_p__type_2. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2412 epsilon_m__def_4_p__type_2 X1 X2);  assumption.
  cut (auto___def_5 X2). 2:apply (rem_2414 epsilon_m__def_4_p__type_2 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2416 : (forall X:term, auto___def_4 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___type_2 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_4_p__type_2. intros X1 X2. intros A1 A2.
  case (rem_2415 epsilon_m__def_4_p__type_2 X1 X2 A1 A2). clear  epsilon_m__def_4_p__type_2 A1 A2. intros. apply trans___type_2_key_2;  tauto.
 clear  epsilon_m__def_4_p__type_2 A1 A2. tauto.
Defined.

Remark rem_2417 : (forall X:term, auto___def_4 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_4 (key X1 X2) -> auto___type_2 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_4_p__type_2. intros X1 X2. intro H. intros.
  elim (rem_2181 X1 X2 H);  intros.
  apply (rem_2416 epsilon_m__def_4_p__type_2 X1 X2);  tauto.
Defined.

Remark rem_2418 : forall X1:term, auto___def_4 X1 -> auto___type_2 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_4_p__type_2 1.
  intro X. case X.
   intro H. elim (rem_2193  H).
   intro H. elim (rem_2191  H).
  intros X1 X2. intro H. elim (rem_2189 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2190 X1 X2 H).
   intro H. elim (rem_2185  H).
   intro H. elim (rem_2197  H).
  intros X1 X2;  exact (rem_2417 epsilon_m__def_4_p__type_2 X1 X2).
   intro H. elim (rem_2184  H).
  intros X1 X2 X3. intro H. elim (rem_2188 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2192 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_2196 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_2194 X1 X2 X3 X4 H).
   intro H. elim (rem_2199  H).
   intro H. elim (rem_2195  H).
  intros X1. intro H. elim (rem_2183 X1 H).
   intro H. elim (rem_2198  H).
  intros X1 X2 X3. intro H. elim (rem_2186 X1 X2 X3 H).
   intro H. elim (rem_2187  H).
Qed.

Remark rem_2419 : forall X1 X2:term, auto___def_4 X1 -> auto___def_5 X2 -> auto_knows_old X2 -> auto___type_2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_4 X1 -> auto___type_2 X1). tauto. exact (rem_2418 X1).
Qed.

Remark rem_2420 : forall X1 X2:term, auto_knows_old X2 -> auto___def_5 X2 -> auto___def_4 X1 -> auto___type_2 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_4 X1 -> auto___def_5 X2 -> auto_knows_old X2 -> auto___type_2 X1). tauto. exact (rem_2419 X1 X2).
Qed.

Remark rem_2421 : forall X1 X2:term, auto___def_8 X1 -> auto___def_9 X2 -> auto_knows_old X2 -> auto___type_2 X1. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2274 X2)). tauto.
Qed.

Remark rem_2422 : forall X1 X2:term, auto_knows_old X2 -> auto___def_9 X2 -> auto___def_8 X1 -> auto___type_2 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_8 X1 -> auto___def_9 X2 -> auto_knows_old X2 -> auto___type_2 X1). tauto. exact (rem_2421 X1 X2).
Qed.

Remark rem_2423 : (forall X:term, auto___def_6 X -> auto___type_2 X)
    -> forall X1:term, auto___def_3 X1 -> auto___def_3 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2424 : (forall X:term, auto___def_6 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_6_p__type_2. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2423 epsilon_m__def_6_p__type_2 X1).
Defined.

Remark rem_2425 : (forall X:term, auto___def_6 X -> auto___type_2 X)
    -> forall X2:term, auto___def_7 X2 -> auto___def_7 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2426 : (forall X:term, auto___def_6 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___def_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_6_p__type_2. intros X1 X2.
  cut (auto___def_7 X2 -> auto___def_7 X2). tauto. exact (rem_2425 epsilon_m__def_6_p__type_2 X2).
Defined.

Remark rem_2427 : (forall X:term, auto___def_6 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> (auto___def_3 X1 /\ auto___def_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_6_p__type_2. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2424 epsilon_m__def_6_p__type_2 X1 X2);  assumption.
  cut (auto___def_7 X2). 2:apply (rem_2426 epsilon_m__def_6_p__type_2 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2428 : (forall X:term, auto___def_6 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___type_2 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_6_p__type_2. intros X1 X2. intros A1 A2.
  case (rem_2427 epsilon_m__def_6_p__type_2 X1 X2 A1 A2). clear  epsilon_m__def_6_p__type_2 A1 A2. intros. apply trans___type_2_key_3;  tauto.
 clear  epsilon_m__def_6_p__type_2 A1 A2. tauto.
Defined.

Remark rem_2429 : (forall X:term, auto___def_6 X -> auto___type_2 X)
    -> forall X1 X2:term, auto___def_6 (key X1 X2) -> auto___type_2 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_6_p__type_2. intros X1 X2. intro H. intros.
  elim (rem_2209 X1 X2 H);  intros.
  apply (rem_2428 epsilon_m__def_6_p__type_2 X1 X2);  tauto.
Defined.

Remark rem_2430 : forall X1:term, auto___def_6 X1 -> auto___type_2 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_6_p__type_2 1.
  intro X. case X.
   intro H. elim (rem_2221  H).
   intro H. elim (rem_2219  H).
  intros X1 X2. intro H. elim (rem_2217 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2218 X1 X2 H).
   intro H. elim (rem_2213  H).
   intro H. elim (rem_2225  H).
  intros X1 X2;  exact (rem_2429 epsilon_m__def_6_p__type_2 X1 X2).
   intro H. elim (rem_2212  H).
  intros X1 X2 X3. intro H. elim (rem_2216 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2220 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_2224 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_2222 X1 X2 X3 X4 H).
   intro H. elim (rem_2227  H).
   intro H. elim (rem_2223  H).
  intros X1. intro H. elim (rem_2211 X1 H).
   intro H. elim (rem_2226  H).
  intros X1 X2 X3. intro H. elim (rem_2214 X1 X2 X3 H).
   intro H. elim (rem_2215  H).
Qed.

Remark rem_2431 : forall X1 X2:term, auto___def_6 X1 -> auto___def_7 X2 -> auto_agent X2 -> auto___type_2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_6 X1 -> auto___type_2 X1). tauto. exact (rem_2430 X1).
Qed.

Remark rem_2432 : forall X1 X2:term, auto___def_7 X2 -> auto_agent X2 -> auto___def_6 X1 -> auto___type_2 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_6 X1 -> auto___def_7 X2 -> auto_agent X2 -> auto___type_2 X1). tauto. exact (rem_2431 X1 X2).
Qed.

Remark rem_2433 : forall X1 X2:term, auto___def_18 X2 X1 -> auto___type_2 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_2283 X2 X1 H);  intros.
  apply (rem_2410 X1 X2);  tauto.
  apply (rem_2420 X1 X2);  tauto.
  apply (rem_2422 X1 X2);  tauto.
  apply (rem_2432 X1 X2);  tauto.
Qed.

Remark rem_2434 : (forall X:term, auto___type_10 X -> auto___type_12 X)
    -> forall X1:term, auto___def_3 X1 -> auto___def_3 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2435 : (forall X:term, auto___type_10 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_10_p__type_12. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2434 epsilon_m__type_10_p__type_12 X1).
Defined.

Remark rem_2436 : (forall X:term, auto___type_10 X -> auto___type_12 X)
    -> forall X2:term, auto___def_2 X2 -> auto___def_2 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2437 : (forall X:term, auto___type_10 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___def_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_10_p__type_12. intros X1 X2.
  cut (auto___def_2 X2 -> auto___def_2 X2). tauto. exact (rem_2436 epsilon_m__type_10_p__type_12 X2).
Defined.

Remark rem_2438 : (forall X:term, auto___type_10 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> (auto___def_3 X1 /\ auto___def_2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_10_p__type_12. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2435 epsilon_m__type_10_p__type_12 X1 X2);  assumption.
  cut (auto___def_2 X2). 2:apply (rem_2437 epsilon_m__type_10_p__type_12 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2439 : (forall X:term, auto___type_10 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___type_12 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_10_p__type_12. intros X1 X2. intros A1 A2.
  case (rem_2438 epsilon_m__type_10_p__type_12 X1 X2 A1 A2). clear  epsilon_m__type_10_p__type_12 A1 A2. intros. apply trans___type_12_key_1;  tauto.
 clear  epsilon_m__type_10_p__type_12 A1 A2. tauto.
Defined.

Remark rem_2440 : (forall X:term, auto___type_10 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_10_p__type_12. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2434 epsilon_m__type_10_p__type_12 X1).
Defined.

Remark rem_2441 : (forall X:term, auto___type_10 X -> auto___type_12 X)
    -> forall X2:term, auto___def_5 X2 -> auto___def_5 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2442 : (forall X:term, auto___type_10 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___def_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_10_p__type_12. intros X1 X2.
  cut (auto___def_5 X2 -> auto___def_5 X2). tauto. exact (rem_2441 epsilon_m__type_10_p__type_12 X2).
Defined.

Remark rem_2443 : (forall X:term, auto___type_10 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> (auto___def_3 X1 /\ auto___def_5 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_10_p__type_12. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2440 epsilon_m__type_10_p__type_12 X1 X2);  assumption.
  cut (auto___def_5 X2). 2:apply (rem_2442 epsilon_m__type_10_p__type_12 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2444 : (forall X:term, auto___type_10 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___type_12 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_10_p__type_12. intros X1 X2. intros A1 A2.
  case (rem_2443 epsilon_m__type_10_p__type_12 X1 X2 A1 A2). clear  epsilon_m__type_10_p__type_12 A1 A2. intros. apply trans___type_12_key_2;  tauto.
 clear  epsilon_m__type_10_p__type_12 A1 A2. tauto.
Defined.

Remark rem_2445 : (forall X:term, auto___type_10 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_10_p__type_12. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2434 epsilon_m__type_10_p__type_12 X1).
Defined.

Remark rem_2446 : (forall X:term, auto___type_10 X -> auto___type_12 X)
    -> forall X2:term, auto___def_7 X2 -> auto___def_7 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2447 : (forall X:term, auto___type_10 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___def_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_10_p__type_12. intros X1 X2.
  cut (auto___def_7 X2 -> auto___def_7 X2). tauto. exact (rem_2446 epsilon_m__type_10_p__type_12 X2).
Defined.

Remark rem_2448 : (forall X:term, auto___type_10 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> (auto___def_3 X1 /\ auto___def_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_10_p__type_12. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2445 epsilon_m__type_10_p__type_12 X1 X2);  assumption.
  cut (auto___def_7 X2). 2:apply (rem_2447 epsilon_m__type_10_p__type_12 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2449 : (forall X:term, auto___type_10 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___type_12 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_10_p__type_12. intros X1 X2. intros A1 A2.
  case (rem_2448 epsilon_m__type_10_p__type_12 X1 X2 A1 A2). clear  epsilon_m__type_10_p__type_12 A1 A2. intros. apply trans___type_12_key_3;  tauto.
 clear  epsilon_m__type_10_p__type_12 A1 A2. tauto.
Defined.

Remark rem_2450 : (forall X:term, auto___type_10 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___type_10 (key X1 X2) -> auto___type_12 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_10_p__type_12. intros X1 X2. intro H. intros.
  elim (rem_340 X1 X2 H);  intros.
  apply (rem_2439 epsilon_m__type_10_p__type_12 X1 X2);  tauto.
  apply (rem_2444 epsilon_m__type_10_p__type_12 X1 X2);  tauto.
  apply (rem_2449 epsilon_m__type_10_p__type_12 X1 X2);  tauto.
Defined.

Remark rem_2451 : forall X1:term, auto___type_10 X1 -> auto___type_12 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_10_p__type_12 1.
  intro X. case X.
   intro H. elim (rem_352  H).
   intro H. elim (rem_350  H).
  intros X1 X2. intro H. elim (rem_348 X1 X2 H).
  intros X1 X2. intro H. elim (rem_349 X1 X2 H).
   intro H. elim (rem_344  H).
   intro H. elim (rem_356  H).
  intros X1 X2;  exact (rem_2450 epsilon_m__type_10_p__type_12 X1 X2).
   intro H. elim (rem_343  H).
  intros X1 X2 X3. intro H. elim (rem_347 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_351 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_355 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_353 X1 X2 X3 X4 H).
   intro H. elim (rem_358  H).
   intro H. elim (rem_354  H).
  intros X1. intro H. elim (rem_342 X1 H).
   intro H. elim (rem_357  H).
  intros X1 X2 X3. intro H. elim (rem_345 X1 X2 X3 H).
   intro H. elim (rem_346  H).
Qed.

Remark rem_2452 : forall X1 X2:term, auto___type_10 X1 -> auto___type_11 X2 -> auto___type_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_10 X1 -> auto___type_12 X1). tauto. exact (rem_2451 X1).
Qed.

Remark rem_2453 : forall X1 X2:term, auto___type_11 X2 -> auto___type_10 X1 -> auto___type_12 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___type_10 X1 -> auto___type_11 X2 -> auto___type_12 X1). tauto. exact (rem_2452 X1 X2).
Qed.

Remark rem_2454 : forall X1 X2:term, auto___def_50 X2 X1 -> auto___type_12 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_268 X2 X1 H);  intros.
  apply (rem_2453 X1 X2);  tauto.
Qed.

Remark rem_2455 : auto___def_23 prv. (* Deduce positive atom. *)
Proof.
   case rem_135. intros. apply trans___def_23_prv_1;  tauto.
 tauto.
Qed.

Remark rem_2456 : (forall X:term, auto_agent X -> auto___type_15 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p__type_15.  tauto.
Defined.

Remark rem_2457 : (forall X:term, auto_agent X -> auto___type_15 X)
    -> auto___type_15 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_15.  case (rem_2456 epsilon_magent_p__type_15). clear  epsilon_magent_p__type_15. intros. apply trans___type_15_i_1;  tauto.
 clear  epsilon_magent_p__type_15. tauto.
Defined.

Remark rem_2458 : (forall X:term, auto_agent X -> auto___type_15 X)
    -> auto_agent i -> auto___type_15 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_15. intro H. intros.
  elim (rem_108 H);  intros.
  apply (rem_2457 epsilon_magent_p__type_15);  tauto.
Defined.

Remark rem_2459 : (forall X:term, auto_agent X -> auto___type_15 X)
    -> auto___type_15 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_15.  case (rem_2456 epsilon_magent_p__type_15). clear  epsilon_magent_p__type_15. intros. apply trans___type_15_bob_1;  tauto.
 clear  epsilon_magent_p__type_15. tauto.
Defined.

Remark rem_2460 : (forall X:term, auto_agent X -> auto___type_15 X)
    -> auto_agent bob -> auto___type_15 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_15. intro H. intros.
  elim (rem_111 H);  intros.
  apply (rem_2459 epsilon_magent_p__type_15);  tauto.
Defined.

Remark rem_2461 : (forall X:term, auto_agent X -> auto___type_15 X)
    -> auto___type_15 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_15.  case (rem_2456 epsilon_magent_p__type_15). clear  epsilon_magent_p__type_15. intros. apply trans___type_15_alice_1;  tauto.
 clear  epsilon_magent_p__type_15. tauto.
Defined.

Remark rem_2462 : (forall X:term, auto_agent X -> auto___type_15 X)
    -> auto_agent alice -> auto___type_15 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_15. intro H. intros.
  elim (rem_114 H);  intros.
  apply (rem_2461 epsilon_magent_p__type_15);  tauto.
Defined.

Remark rem_2463 : (forall X:term, auto_agent X -> auto___type_15 X)
    -> auto___type_15 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_15.  case (rem_2456 epsilon_magent_p__type_15). clear  epsilon_magent_p__type_15. intros. apply trans___type_15_server_1;  tauto.
 clear  epsilon_magent_p__type_15. tauto.
Defined.

Remark rem_2464 : (forall X:term, auto_agent X -> auto___type_15 X)
    -> auto_agent server -> auto___type_15 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_15. intro H. intros.
  elim (rem_117 H);  intros.
  apply (rem_2463 epsilon_magent_p__type_15);  tauto.
Defined.

Remark rem_2465 : forall X1:term, auto_agent X1 -> auto___type_15 X1. (* Induct. *)
Proof.
  fix epsilon_magent_p__type_15 1.
  intro X. case X.
  exact (rem_2462 epsilon_magent_p__type_15 ).
  exact (rem_2460 epsilon_magent_p__type_15 ).
  intros X1 X2. intro H. elim (rem_124 X1 X2 H).
  intros X1 X2. intro H. elim (rem_125 X1 X2 H).
  exact (rem_2458 epsilon_magent_p__type_15 ).
   intro H. elim (rem_131  H).
  intros X1 X2. intro H. elim (rem_126 X1 X2 H).
   intro H. elim (rem_120  H).
  intros X1 X2 X3. intro H. elim (rem_123 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_127 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_130 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_128 X1 X2 X3 X4 H).
   intro H. elim (rem_132  H).
   intro H. elim (rem_129  H).
  intros X1. intro H. elim (rem_119 X1 H).
  exact (rem_2464 epsilon_magent_p__type_15 ).
  intros X1 X2 X3. intro H. elim (rem_121 X1 X2 X3 H).
   intro H. elim (rem_122  H).
Qed.

Remark rem_2466 : forall X1 X2 X3 X4:term, auto___type_2 X2 -> auto___type_3 X3 -> auto___type_9 X1 -> auto_agent X1 -> auto_knows_current X4 -> auto___type_15 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_agent X1 -> auto___type_15 X1). tauto. exact (rem_2465 X1).
Qed.

Remark rem_2467 : forall X1 X2 X3 X4:term, auto___type_3 X2 -> auto___type_9 X1 -> auto_agent X1 -> auto_knows_current X3 -> auto___type_2 X4 -> auto___type_15 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X3 X4 X2.
  cut (auto___type_2 X2 -> auto___type_3 X3 -> auto___type_9 X1 -> auto_agent X1 -> auto_knows_current X4 -> auto___type_15 X1). tauto. exact (rem_2466 X1 X2 X3 X4).
Qed.

Remark rem_2468 : (forall X:term, auto___def_2 X -> auto___type_15 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_2_p__type_15.  tauto.
Defined.

Remark rem_2469 : (forall X:term, auto___def_2 X -> auto___type_15 X)
    -> auto___type_15 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_2_p__type_15.  case (rem_2468 epsilon_m__def_2_p__type_15). clear  epsilon_m__def_2_p__type_15. intros. apply trans___type_15_alice_1;  tauto.
 clear  epsilon_m__def_2_p__type_15. tauto.
Defined.

Remark rem_2470 : (forall X:term, auto___def_2 X -> auto___type_15 X)
    -> auto___def_2 alice -> auto___type_15 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_2_p__type_15. intro H. intros.
  elim (rem_9 H);  intros.
  apply (rem_2469 epsilon_m__def_2_p__type_15);  tauto.
Defined.

Remark rem_2471 : forall X1:term, auto___def_2 X1 -> auto___type_15 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_2_p__type_15 1.
  intro X. case X.
  exact (rem_2470 epsilon_m__def_2_p__type_15 ).
   intro H. elim (rem_20  H).
  intros X1 X2. intro H. elim (rem_17 X1 X2 H).
  intros X1 X2. intro H. elim (rem_18 X1 X2 H).
   intro H. elim (rem_13  H).
   intro H. elim (rem_25  H).
  intros X1 X2. intro H. elim (rem_19 X1 X2 H).
   intro H. elim (rem_12  H).
  intros X1 X2 X3. intro H. elim (rem_16 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_21 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_24 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_22 X1 X2 X3 X4 H).
   intro H. elim (rem_27  H).
   intro H. elim (rem_23  H).
  intros X1. intro H. elim (rem_11 X1 H).
   intro H. elim (rem_26  H).
  intros X1 X2 X3. intro H. elim (rem_14 X1 X2 X3 H).
   intro H. elim (rem_15  H).
Qed.

Remark rem_2472 : forall X1 X2 X3 X4:term, auto___def_2 X1 -> auto___def_52 X2 -> auto___type_10 X3 -> auto___type_11 X4 -> auto_agent X4 -> auto_agent X1 -> auto___type_15 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X1 -> auto___type_15 X1). tauto. exact (rem_2471 X1).
Qed.

Remark rem_2473 : forall X1 X2 X3 X4:term, auto___type_11 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_2 X1 -> auto___def_52 X3 -> auto___type_10 X4 -> auto___type_15 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X4 X2 X3.
  cut (auto___def_2 X1 -> auto___def_52 X2 -> auto___type_10 X3 -> auto___type_11 X4 -> auto_agent X4 -> auto_agent X1 -> auto___type_15 X1). tauto. exact (rem_2472 X1 X2 X3 X4).
Qed.

Remark rem_2474 : (forall X:term, auto___def_7 X -> auto___type_15 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_7_p__type_15.  tauto.
Defined.

Remark rem_2475 : (forall X:term, auto___def_7 X -> auto___type_15 X)
    -> auto___type_15 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_7_p__type_15.  case (rem_2474 epsilon_m__def_7_p__type_15). clear  epsilon_m__def_7_p__type_15. intros. apply trans___type_15_server_1;  tauto.
 clear  epsilon_m__def_7_p__type_15. tauto.
Defined.

Remark rem_2476 : (forall X:term, auto___def_7 X -> auto___type_15 X)
    -> auto___def_7 server -> auto___type_15 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_7_p__type_15. intro H. intros.
  elim (rem_81 H);  intros.
  apply (rem_2475 epsilon_m__def_7_p__type_15);  tauto.
Defined.

Remark rem_2477 : forall X1:term, auto___def_7 X1 -> auto___type_15 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_7_p__type_15 1.
  intro X. case X.
   intro H. elim (rem_94  H).
   intro H. elim (rem_92  H).
  intros X1 X2. intro H. elim (rem_89 X1 X2 H).
  intros X1 X2. intro H. elim (rem_90 X1 X2 H).
   intro H. elim (rem_85  H).
   intro H. elim (rem_98  H).
  intros X1 X2. intro H. elim (rem_91 X1 X2 H).
   intro H. elim (rem_84  H).
  intros X1 X2 X3. intro H. elim (rem_88 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_93 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_97 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_95 X1 X2 X3 X4 H).
   intro H. elim (rem_99  H).
   intro H. elim (rem_96  H).
  intros X1. intro H. elim (rem_83 X1 H).
  exact (rem_2476 epsilon_m__def_7_p__type_15 ).
  intros X1 X2 X3. intro H. elim (rem_86 X1 X2 X3 H).
   intro H. elim (rem_87  H).
Qed.

Remark rem_2478 : forall X1 X2 X3 X4:term, auto___def_52 X2 -> auto___def_7 X1 -> auto___type_2 X3 -> auto___type_3 X4 -> auto_agent X4 -> auto_agent X1 -> auto___type_15 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_7 X1 -> auto___type_15 X1). tauto. exact (rem_2477 X1).
Qed.

Remark rem_2479 : forall X1 X2 X3 X4:term, auto___type_3 X2 -> auto_agent X2 -> auto___def_7 X1 -> auto_agent X1 -> auto___def_52 X3 -> auto___type_2 X4 -> auto___type_15 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X4 X2 X3.
  cut (auto___def_52 X2 -> auto___def_7 X1 -> auto___type_2 X3 -> auto___type_3 X4 -> auto_agent X4 -> auto_agent X1 -> auto___type_15 X1). tauto. exact (rem_2478 X1 X2 X3 X4).
Qed.

Remark rem_2480 : (forall X:term, auto___def_5 X -> auto___type_15 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_5_p__type_15.  tauto.
Defined.

Remark rem_2481 : (forall X:term, auto___def_5 X -> auto___type_15 X)
    -> auto___type_15 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_5_p__type_15.  case (rem_2480 epsilon_m__def_5_p__type_15). clear  epsilon_m__def_5_p__type_15. intros. apply trans___type_15_bob_1;  tauto.
 clear  epsilon_m__def_5_p__type_15. tauto.
Defined.

Remark rem_2482 : (forall X:term, auto___def_5 X -> auto___type_15 X)
    -> auto___def_5 bob -> auto___type_15 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_5_p__type_15. intro H. intros.
  elim (rem_57 H);  intros.
  apply (rem_2481 epsilon_m__def_5_p__type_15);  tauto.
Defined.

Remark rem_2483 : forall X1:term, auto___def_5 X1 -> auto___type_15 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_5_p__type_15 1.
  intro X. case X.
   intro H. elim (rem_69  H).
  exact (rem_2482 epsilon_m__def_5_p__type_15 ).
  intros X1 X2. intro H. elim (rem_65 X1 X2 H).
  intros X1 X2. intro H. elim (rem_66 X1 X2 H).
   intro H. elim (rem_61  H).
   intro H. elim (rem_73  H).
  intros X1 X2. intro H. elim (rem_67 X1 X2 H).
   intro H. elim (rem_60  H).
  intros X1 X2 X3. intro H. elim (rem_64 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_68 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_72 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_70 X1 X2 X3 X4 H).
   intro H. elim (rem_75  H).
   intro H. elim (rem_71  H).
  intros X1. intro H. elim (rem_59 X1 H).
   intro H. elim (rem_74  H).
  intros X1 X2 X3. intro H. elim (rem_62 X1 X2 X3 H).
   intro H. elim (rem_63  H).
Qed.

Remark rem_2484 : forall X1 X2 X3 X4:term, auto___def_5 X1 -> auto___def_52 X2 -> auto___type_10 X3 -> auto___type_11 X4 -> auto_agent X4 -> auto_agent X1 -> auto___type_15 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_5 X1 -> auto___type_15 X1). tauto. exact (rem_2483 X1).
Qed.

Remark rem_2485 : forall X1 X2 X3 X4:term, auto___type_11 X2 -> auto_agent X2 -> auto___def_5 X1 -> auto_agent X1 -> auto___def_52 X3 -> auto___type_10 X4 -> auto___type_15 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X4 X2 X3.
  cut (auto___def_5 X1 -> auto___def_52 X2 -> auto___type_10 X3 -> auto___type_11 X4 -> auto_agent X4 -> auto_agent X1 -> auto___type_15 X1). tauto. exact (rem_2484 X1 X2 X3 X4).
Qed.

Remark rem_2486 : forall X1 X2 X3 X4:term, auto___def_54 X2 X1 X3 X4 -> auto___type_15 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_420 X2 X1 X3 X4 H);  intros.
  apply (rem_2467 X1 X2 X3 X4);  tauto.
  apply (rem_2473 X1 X2 X3 X4);  tauto.
  apply (rem_2479 X1 X2 X3 X4);  tauto.
  apply (rem_2485 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2487 : auto___def_5 bob. (* Deduce positive atom. *)
Proof.
   case rem_135. intros. apply trans___def_5_bob_1;  tauto.
 tauto.
Qed.

Remark rem_2488 : forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_932 X1).
Qed.

Remark rem_2489 : forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___def_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_5 X2 -> auto___def_5 X2). tauto. exact (rem_408 X2).
Qed.

Remark rem_2490 : forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> (auto___def_3 X1 /\ auto___def_5 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2488 X1 X2);  assumption.
  cut (auto___def_5 X2). 2:apply (rem_2489 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2491 : forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___def_4 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2490 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_4_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2492 : forall X1 X2:term, auto___def_5 X2 -> auto___def_3 X1 -> auto___def_4 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_5 X2 -> auto___def_4 (key X1 X2)). tauto. exact (rem_2491 X1 X2).
Qed.

Remark rem_2493 : (forall X:term, auto___def_5 X -> auto___type_8 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_5_p__type_8.  tauto.
Defined.

Remark rem_2494 : (forall X:term, auto___def_5 X -> auto___type_8 X)
    -> auto___type_8 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_5_p__type_8.  case (rem_2493 epsilon_m__def_5_p__type_8). clear  epsilon_m__def_5_p__type_8. intros. apply trans___type_8_bob_1;  tauto.
 clear  epsilon_m__def_5_p__type_8. tauto.
Defined.

Remark rem_2495 : (forall X:term, auto___def_5 X -> auto___type_8 X)
    -> auto___def_5 bob -> auto___type_8 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_5_p__type_8. intro H. intros.
  elim (rem_57 H);  intros.
  apply (rem_2494 epsilon_m__def_5_p__type_8);  tauto.
Defined.

Remark rem_2496 : forall X1:term, auto___def_5 X1 -> auto___type_8 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_5_p__type_8 1.
  intro X. case X.
   intro H. elim (rem_69  H).
  exact (rem_2495 epsilon_m__def_5_p__type_8 ).
  intros X1 X2. intro H. elim (rem_65 X1 X2 H).
  intros X1 X2. intro H. elim (rem_66 X1 X2 H).
   intro H. elim (rem_61  H).
   intro H. elim (rem_73  H).
  intros X1 X2. intro H. elim (rem_67 X1 X2 H).
   intro H. elim (rem_60  H).
  intros X1 X2 X3. intro H. elim (rem_64 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_68 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_72 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_70 X1 X2 X3 X4 H).
   intro H. elim (rem_75  H).
   intro H. elim (rem_71  H).
  intros X1. intro H. elim (rem_59 X1 H).
   intro H. elim (rem_74  H).
  intros X1 X2 X3. intro H. elim (rem_62 X1 X2 X3 H).
   intro H. elim (rem_63  H).
Qed.

Remark rem_2497 : forall X1 X2 X3 X4:term, auto___def_26 X2 -> auto___def_5 X1 -> auto___type_2 X3 -> auto___type_3 X4 -> auto_agent X4 -> auto_agent X1 -> auto___type_8 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_5 X1 -> auto___type_8 X1). tauto. exact (rem_2496 X1).
Qed.

Remark rem_2498 : forall X1 X2 X3 X4:term, auto___type_3 X2 -> auto_agent X2 -> auto___def_5 X1 -> auto_agent X1 -> auto___def_26 X3 -> auto___type_2 X4 -> auto___type_8 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X4 X2 X3.
  cut (auto___def_26 X2 -> auto___def_5 X1 -> auto___type_2 X3 -> auto___type_3 X4 -> auto_agent X4 -> auto_agent X1 -> auto___type_8 X1). tauto. exact (rem_2497 X1 X2 X3 X4).
Qed.

Remark rem_2499 : (forall X:term, auto_agent X -> auto___type_8 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p__type_8.  tauto.
Defined.

Remark rem_2500 : (forall X:term, auto_agent X -> auto___type_8 X)
    -> auto___type_8 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_8.  case (rem_2499 epsilon_magent_p__type_8). clear  epsilon_magent_p__type_8. intros. apply trans___type_8_i_1;  tauto.
 clear  epsilon_magent_p__type_8. tauto.
Defined.

Remark rem_2501 : (forall X:term, auto_agent X -> auto___type_8 X)
    -> auto_agent i -> auto___type_8 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_8. intro H. intros.
  elim (rem_108 H);  intros.
  apply (rem_2500 epsilon_magent_p__type_8);  tauto.
Defined.

Remark rem_2502 : (forall X:term, auto_agent X -> auto___type_8 X)
    -> auto___type_8 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_8.  case (rem_2499 epsilon_magent_p__type_8). clear  epsilon_magent_p__type_8. intros. apply trans___type_8_bob_1;  tauto.
 clear  epsilon_magent_p__type_8. tauto.
Defined.

Remark rem_2503 : (forall X:term, auto_agent X -> auto___type_8 X)
    -> auto_agent bob -> auto___type_8 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_8. intro H. intros.
  elim (rem_111 H);  intros.
  apply (rem_2502 epsilon_magent_p__type_8);  tauto.
Defined.

Remark rem_2504 : (forall X:term, auto_agent X -> auto___type_8 X)
    -> auto___type_8 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_8.  case (rem_2499 epsilon_magent_p__type_8). clear  epsilon_magent_p__type_8. intros. apply trans___type_8_alice_1;  tauto.
 clear  epsilon_magent_p__type_8. tauto.
Defined.

Remark rem_2505 : (forall X:term, auto_agent X -> auto___type_8 X)
    -> auto_agent alice -> auto___type_8 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_8. intro H. intros.
  elim (rem_114 H);  intros.
  apply (rem_2504 epsilon_magent_p__type_8);  tauto.
Defined.

Remark rem_2506 : (forall X:term, auto_agent X -> auto___type_8 X)
    -> auto___type_8 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_8.  case (rem_2499 epsilon_magent_p__type_8). clear  epsilon_magent_p__type_8. intros. apply trans___type_8_server_1;  tauto.
 clear  epsilon_magent_p__type_8. tauto.
Defined.

Remark rem_2507 : (forall X:term, auto_agent X -> auto___type_8 X)
    -> auto_agent server -> auto___type_8 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_8. intro H. intros.
  elim (rem_117 H);  intros.
  apply (rem_2506 epsilon_magent_p__type_8);  tauto.
Defined.

Remark rem_2508 : forall X1:term, auto_agent X1 -> auto___type_8 X1. (* Induct. *)
Proof.
  fix epsilon_magent_p__type_8 1.
  intro X. case X.
  exact (rem_2505 epsilon_magent_p__type_8 ).
  exact (rem_2503 epsilon_magent_p__type_8 ).
  intros X1 X2. intro H. elim (rem_124 X1 X2 H).
  intros X1 X2. intro H. elim (rem_125 X1 X2 H).
  exact (rem_2501 epsilon_magent_p__type_8 ).
   intro H. elim (rem_131  H).
  intros X1 X2. intro H. elim (rem_126 X1 X2 H).
   intro H. elim (rem_120  H).
  intros X1 X2 X3. intro H. elim (rem_123 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_127 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_130 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_128 X1 X2 X3 X4 H).
   intro H. elim (rem_132  H).
   intro H. elim (rem_129  H).
  intros X1. intro H. elim (rem_119 X1 H).
  exact (rem_2507 epsilon_magent_p__type_8 ).
  intros X1 X2 X3. intro H. elim (rem_121 X1 X2 X3 H).
   intro H. elim (rem_122  H).
Qed.

Remark rem_2509 : forall X1 X2 X3 X4:term, auto___type_2 X2 -> auto___type_3 X3 -> auto___type_9 X1 -> auto_agent X1 -> auto_knows_old X4 -> auto___type_8 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_agent X1 -> auto___type_8 X1). tauto. exact (rem_2508 X1).
Qed.

Remark rem_2510 : forall X1 X2 X3 X4:term, auto___type_3 X2 -> auto___type_9 X1 -> auto_agent X1 -> auto_knows_old X3 -> auto___type_2 X4 -> auto___type_8 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X3 X4 X2.
  cut (auto___type_2 X2 -> auto___type_3 X3 -> auto___type_9 X1 -> auto_agent X1 -> auto_knows_old X4 -> auto___type_8 X1). tauto. exact (rem_2509 X1 X2 X3 X4).
Qed.

Remark rem_2511 : (forall X:term, auto___def_7 X -> auto___type_8 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_7_p__type_8.  tauto.
Defined.

Remark rem_2512 : (forall X:term, auto___def_7 X -> auto___type_8 X)
    -> auto___type_8 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_7_p__type_8.  case (rem_2511 epsilon_m__def_7_p__type_8). clear  epsilon_m__def_7_p__type_8. intros. apply trans___type_8_server_1;  tauto.
 clear  epsilon_m__def_7_p__type_8. tauto.
Defined.

Remark rem_2513 : (forall X:term, auto___def_7 X -> auto___type_8 X)
    -> auto___def_7 server -> auto___type_8 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_7_p__type_8. intro H. intros.
  elim (rem_81 H);  intros.
  apply (rem_2512 epsilon_m__def_7_p__type_8);  tauto.
Defined.

Remark rem_2514 : forall X1:term, auto___def_7 X1 -> auto___type_8 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_7_p__type_8 1.
  intro X. case X.
   intro H. elim (rem_94  H).
   intro H. elim (rem_92  H).
  intros X1 X2. intro H. elim (rem_89 X1 X2 H).
  intros X1 X2. intro H. elim (rem_90 X1 X2 H).
   intro H. elim (rem_85  H).
   intro H. elim (rem_98  H).
  intros X1 X2. intro H. elim (rem_91 X1 X2 H).
   intro H. elim (rem_84  H).
  intros X1 X2 X3. intro H. elim (rem_88 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_93 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_97 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_95 X1 X2 X3 X4 H).
   intro H. elim (rem_99  H).
   intro H. elim (rem_96  H).
  intros X1. intro H. elim (rem_83 X1 H).
  exact (rem_2513 epsilon_m__def_7_p__type_8 ).
  intros X1 X2 X3. intro H. elim (rem_86 X1 X2 X3 H).
   intro H. elim (rem_87  H).
Qed.

Remark rem_2515 : forall X1 X2 X3 X4:term, auto___def_26 X2 -> auto___def_7 X1 -> auto___type_2 X3 -> auto___type_3 X4 -> auto_agent X4 -> auto_agent X1 -> auto___type_8 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_7 X1 -> auto___type_8 X1). tauto. exact (rem_2514 X1).
Qed.

Remark rem_2516 : forall X1 X2 X3 X4:term, auto___type_3 X2 -> auto_agent X2 -> auto___def_7 X1 -> auto_agent X1 -> auto___def_26 X3 -> auto___type_2 X4 -> auto___type_8 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X4 X2 X3.
  cut (auto___def_26 X2 -> auto___def_7 X1 -> auto___type_2 X3 -> auto___type_3 X4 -> auto_agent X4 -> auto_agent X1 -> auto___type_8 X1). tauto. exact (rem_2515 X1 X2 X3 X4).
Qed.

Remark rem_2517 : (forall X:term, auto___def_2 X -> auto___type_8 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_2_p__type_8.  tauto.
Defined.

Remark rem_2518 : (forall X:term, auto___def_2 X -> auto___type_8 X)
    -> auto___type_8 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_2_p__type_8.  case (rem_2517 epsilon_m__def_2_p__type_8). clear  epsilon_m__def_2_p__type_8. intros. apply trans___type_8_alice_1;  tauto.
 clear  epsilon_m__def_2_p__type_8. tauto.
Defined.

Remark rem_2519 : (forall X:term, auto___def_2 X -> auto___type_8 X)
    -> auto___def_2 alice -> auto___type_8 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_2_p__type_8. intro H. intros.
  elim (rem_9 H);  intros.
  apply (rem_2518 epsilon_m__def_2_p__type_8);  tauto.
Defined.

Remark rem_2520 : forall X1:term, auto___def_2 X1 -> auto___type_8 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_2_p__type_8 1.
  intro X. case X.
  exact (rem_2519 epsilon_m__def_2_p__type_8 ).
   intro H. elim (rem_20  H).
  intros X1 X2. intro H. elim (rem_17 X1 X2 H).
  intros X1 X2. intro H. elim (rem_18 X1 X2 H).
   intro H. elim (rem_13  H).
   intro H. elim (rem_25  H).
  intros X1 X2. intro H. elim (rem_19 X1 X2 H).
   intro H. elim (rem_12  H).
  intros X1 X2 X3. intro H. elim (rem_16 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_21 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_24 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_22 X1 X2 X3 X4 H).
   intro H. elim (rem_27  H).
   intro H. elim (rem_23  H).
  intros X1. intro H. elim (rem_11 X1 H).
   intro H. elim (rem_26  H).
  intros X1 X2 X3. intro H. elim (rem_14 X1 X2 X3 H).
   intro H. elim (rem_15  H).
Qed.

Remark rem_2521 : forall X1 X2 X3 X4:term, auto___def_2 X1 -> auto___def_26 X2 -> auto___type_2 X3 -> auto___type_3 X4 -> auto_agent X4 -> auto_agent X1 -> auto___type_8 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_2 X1 -> auto___type_8 X1). tauto. exact (rem_2520 X1).
Qed.

Remark rem_2522 : forall X1 X2 X3 X4:term, auto___type_3 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_2 X1 -> auto___def_26 X3 -> auto___type_2 X4 -> auto___type_8 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X4 X2 X3.
  cut (auto___def_2 X1 -> auto___def_26 X2 -> auto___type_2 X3 -> auto___type_3 X4 -> auto_agent X4 -> auto_agent X1 -> auto___type_8 X1). tauto. exact (rem_2521 X1 X2 X3 X4).
Qed.

Remark rem_2523 : forall X1 X2 X3 X4:term, auto___def_29 X2 X1 X3 X4 -> auto___type_8 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1280 X2 X1 X3 X4 H);  intros.
  apply (rem_2498 X1 X2 X3 X4);  tauto.
  apply (rem_2510 X1 X2 X3 X4);  tauto.
  apply (rem_2516 X1 X2 X3 X4);  tauto.
  apply (rem_2522 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2524 : auto___def_22 nil. (* Deduce positive atom. *)
Proof.
   case rem_135. intros. apply trans___def_22_nil_1;  tauto.
 tauto.
Qed.

Remark rem_2525 : forall X1:term, auto___type_7 X1 -> auto___type_7 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2526 : forall X1 X2:term, auto___def_31 X2 -> auto___type_7 X1 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_7 X1 -> auto___type_7 X1). tauto. exact (rem_2525 X1).
Qed.

Remark rem_2527 : forall X2:term, auto___def_31 X2 -> auto___def_31 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2528 : forall X1 X2:term, auto___def_31 X2 -> auto___type_7 X1 -> auto___def_31 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_31 X2 -> auto___def_31 X2). tauto. exact (rem_2527 X2).
Qed.

Remark rem_2529 : forall X1 X2:term, auto___def_31 X2 -> auto___type_7 X1 -> (auto___type_7 X1 /\ auto___def_31 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_7 X1). 2:apply (rem_2526 X1 X2);  assumption.
  cut (auto___def_31 X2). 2:apply (rem_2528 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2530 : forall X1 X2:term, auto___def_31 X2 -> auto___type_7 X1 -> auto___def_30 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2529 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_30_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2531 : forall X1 X2:term, auto___def_23 prv -> auto___def_36 X1 -> auto_knows_current X2 -> auto___def_36 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_36 X1 -> auto___def_36 X1). tauto. exact (rem_164 X1).
Qed.

Remark rem_2532 : forall X1 X2:term, auto___def_23 prv -> auto___def_36 X1 -> auto_knows_current X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_1066 X2).
Qed.

Remark rem_2533 : forall X1 X2:term, auto___def_23 prv -> auto___def_36 X1 -> auto_knows_current X2 -> (auto___def_36 X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_36 X1). 2:apply (rem_2531 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2532 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2534 : forall X1 X2:term, auto___def_23 prv -> auto___def_36 X1 -> auto_knows_current X2 -> auto___def_41 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_2533 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_41_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2535 : forall X1 X2:term, auto___def_3 prv -> auto_knows_current X2 -> auto___def_41 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 prv -> False). tauto.
  exact (rem_138).
Qed.

Remark rem_2536 : forall X1 X2:term, auto___def_3 prv -> auto___type_9 X1 -> auto_knows_current X2 -> auto___def_41 X1 X2. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2. intros. apply (rem_2535 X1 X2);  assumption.
Qed.

Remark rem_2537 : forall X1 X2:term, auto___def_37 prv -> auto___def_38 X1 -> auto_knows_current X2 -> auto___def_41 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_37 prv -> False). tauto.
  exact (rem_1982).
Qed.

Remark rem_2538 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current (key prv X1) -> auto___def_41 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_258 prv X1 H);  intros.
  apply (rem_2534 X1 X2);  tauto.
  apply (rem_2536 X1 X2);  tauto.
  apply (rem_2537 X1 X2);  tauto.
Qed.

Remark rem_2539 : forall X1 X2:term, auto___def_2 X1 -> auto___def_3 prv -> auto___def_51 X2 -> auto___def_41 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 prv -> False). tauto.
  exact (rem_138).
Qed.

Remark rem_2540 : forall X1 X2:term, auto___def_3 prv -> auto___def_2 X1 -> auto___def_51 X2 -> auto___def_41 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_2 X1 -> auto___def_3 prv -> auto___def_51 X2 -> auto___def_41 X1 X2). tauto. exact (rem_2539 X1 X2).
Qed.

Remark rem_2541 : forall X1 X2:term, auto___def_3 prv -> auto___def_5 X1 -> auto___def_51 X2 -> auto___def_41 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 prv -> False). tauto.
  exact (rem_138).
Qed.

Remark rem_2542 : forall X1 X2:term, auto___def_3 prv -> auto___def_51 X2 -> auto___def_7 X1 -> auto___def_41 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 prv -> False). tauto.
  exact (rem_138).
Qed.

Remark rem_2543 : forall X1 X2:term, auto___def_3 prv -> auto___def_7 X1 -> auto___def_51 X2 -> auto___def_41 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_3 prv -> auto___def_51 X2 -> auto___def_7 X1 -> auto___def_41 X1 X2). tauto. exact (rem_2542 X1 X2).
Qed.

Remark rem_2544 : forall X1 X2:term, auto___def_51 X2 -> auto___type_12 (key prv X1) -> auto___def_41 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_427 prv X1 H);  intros.
  apply (rem_2540 X1 X2);  tauto.
  apply (rem_2541 X1 X2);  tauto.
  apply (rem_2543 X1 X2);  tauto.
Qed.

Remark rem_2545 : forall X1 X2:term, auto___def_2 X1 -> auto___def_3 prv -> auto___def_57 X2 -> auto___def_41 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 prv -> False). tauto.
  exact (rem_138).
Qed.

Remark rem_2546 : forall X1 X2:term, auto___def_3 prv -> auto___def_2 X1 -> auto___def_57 X2 -> auto___def_41 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_2 X1 -> auto___def_3 prv -> auto___def_57 X2 -> auto___def_41 X1 X2). tauto. exact (rem_2545 X1 X2).
Qed.

Remark rem_2547 : forall X1 X2:term, auto___def_3 prv -> auto___def_5 X1 -> auto___def_57 X2 -> auto___def_41 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 prv -> False). tauto.
  exact (rem_138).
Qed.

Remark rem_2548 : forall X1 X2:term, auto___def_3 prv -> auto___def_57 X2 -> auto___def_7 X1 -> auto___def_41 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 prv -> False). tauto.
  exact (rem_138).
Qed.

Remark rem_2549 : forall X1 X2:term, auto___def_3 prv -> auto___def_7 X1 -> auto___def_57 X2 -> auto___def_41 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_3 prv -> auto___def_57 X2 -> auto___def_7 X1 -> auto___def_41 X1 X2). tauto. exact (rem_2548 X1 X2).
Qed.

Remark rem_2550 : forall X1 X2:term, auto___def_57 X2 -> auto___type_2 (key prv X1) -> auto___def_41 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_145 prv X1 H);  intros.
  apply (rem_2546 X1 X2);  tauto.
  apply (rem_2547 X1 X2);  tauto.
  apply (rem_2549 X1 X2);  tauto.
Qed.

Remark rem_2551 : forall X1 X2:term, auto___def_23 prv -> auto___def_46 X2 -> auto___def_7 X1 -> auto___def_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_7 X1 -> auto___def_7 X1). tauto. exact (rem_155 X1).
Qed.

Remark rem_2552 : forall X2:term, auto___def_46 X2 -> auto___def_46 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2553 : forall X1 X2:term, auto___def_23 prv -> auto___def_46 X2 -> auto___def_7 X1 -> auto___def_46 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_46 X2 -> auto___def_46 X2). tauto. exact (rem_2552 X2).
Qed.

Remark rem_2554 : forall X1 X2:term, auto___def_23 prv -> auto___def_46 X2 -> auto___def_7 X1 -> (auto___def_7 X1 /\ auto___def_46 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_7 X1). 2:apply (rem_2551 X1 X2);  assumption.
  cut (auto___def_46 X2). 2:apply (rem_2553 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2555 : forall X1 X2:term, auto___def_23 prv -> auto___def_46 X2 -> auto___def_7 X1 -> auto___def_41 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_2554 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_41_2;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2556 : forall X1 X2:term, auto___def_23 prv -> auto___def_7 X1 -> auto___def_46 X2 -> auto___def_41 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_23 prv -> auto___def_46 X2 -> auto___def_7 X1 -> auto___def_41 X1 X2). tauto. exact (rem_2555 X1 X2).
Qed.

Remark rem_2557 : forall X1 X2:term, auto___def_46 X2 -> auto___def_47 (key prv X1) -> auto___def_41 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_685 prv X1 H);  intros.
  apply (rem_2556 X1 X2);  tauto.
Qed.

Remark rem_2558 : forall X1 X2:term, auto___def_2 X1 -> auto___def_3 prv -> auto___def_55 X2 -> auto___def_41 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 prv -> False). tauto.
  exact (rem_138).
Qed.

Remark rem_2559 : forall X1 X2:term, auto___def_3 prv -> auto___def_2 X1 -> auto___def_55 X2 -> auto___def_41 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_2 X1 -> auto___def_3 prv -> auto___def_55 X2 -> auto___def_41 X1 X2). tauto. exact (rem_2558 X1 X2).
Qed.

Remark rem_2560 : forall X1 X2:term, auto___def_3 prv -> auto___def_5 X1 -> auto___def_55 X2 -> auto___def_41 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 prv -> False). tauto.
  exact (rem_138).
Qed.

Remark rem_2561 : forall X1 X2:term, auto___def_3 prv -> auto___def_55 X2 -> auto___def_7 X1 -> auto___def_41 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_3 prv -> False). tauto.
  exact (rem_138).
Qed.

Remark rem_2562 : forall X1 X2:term, auto___def_3 prv -> auto___def_7 X1 -> auto___def_55 X2 -> auto___def_41 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_3 prv -> auto___def_55 X2 -> auto___def_7 X1 -> auto___def_41 X1 X2). tauto. exact (rem_2561 X1 X2).
Qed.

Remark rem_2563 : forall X1 X2:term, auto___def_55 X2 -> auto___type_13 (key prv X1) -> auto___def_41 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_789 prv X1 H);  intros.
  apply (rem_2559 X1 X2);  tauto.
  apply (rem_2560 X1 X2);  tauto.
  apply (rem_2562 X1 X2);  tauto.
Qed.

Remark rem_2564 : forall X1 X2:term, auto_knows_current (crypt X2 (key prv X1)) -> auto___def_41 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_470 X2 (key prv X1) H);  intros.
  apply (rem_2538 X1 X2);  tauto.
  apply (rem_2544 X1 X2);  tauto.
  apply (rem_2550 X1 X2);  tauto.
  apply (rem_2557 X1 X2);  tauto.
  apply (rem_2563 X1 X2);  tauto.
Qed.

Remark rem_2565 : forall X1 X2:term, auto___def_22 X2 -> auto___type_3 X1 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_3 X1 -> auto___type_3 X1). tauto. exact (rem_199 X1).
Qed.

Remark rem_2566 : forall X2:term, auto___def_22 X2 -> auto___def_22 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2567 : forall X1 X2:term, auto___def_22 X2 -> auto___type_3 X1 -> auto___def_22 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_22 X2 -> auto___def_22 X2). tauto. exact (rem_2566 X2).
Qed.

Remark rem_2568 : forall X1 X2:term, auto___def_22 X2 -> auto___type_3 X1 -> (auto___type_3 X1 /\ auto___def_22 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_3 X1). 2:apply (rem_2565 X1 X2);  assumption.
  cut (auto___def_22 X2). 2:apply (rem_2567 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2569 : forall X1 X2:term, auto___def_22 X2 -> auto___type_3 X1 -> auto___def_21 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2568 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_21_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

(* [appp] Proofs that all approximation clauses hold. *)


Remark rem_2570 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_current X1. (* Use induction hypothesis. *)
Proof.
   intro Hrec. intros X1.
  cut (auto_knows_old X1 -> auto_knows_current X1). tauto. exact (Hrec X1).
Defined.

Remark rem_2571 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_2570 epsilon_mknows_old_pknows_current X1);  assumption.
  tauto.
Defined.

Remark rem_2572 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_current (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1. intros A1.
  case (rem_2571 epsilon_mknows_old_pknows_current X1 A1). clear  epsilon_mknows_old_pknows_current A1. intros. apply trans_knows_current_s_1;  tauto.
 clear  epsilon_mknows_old_pknows_current A1. tauto.
Defined.

Remark rem_2573 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old (s X1) -> auto_knows_current (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1. intro H. intros.
  elim (rem_1315 X1 H);  intros.
  apply (rem_2572 epsilon_mknows_old_pknows_current X1);  tauto.
Defined.

Remark rem_2574 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current.  tauto.
Defined.

Remark rem_2575 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_current nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current.  case (rem_2574 epsilon_mknows_old_pknows_current). clear  epsilon_mknows_old_pknows_current. intros. apply trans_knows_current_nil_1;  tauto.
 clear  epsilon_mknows_old_pknows_current. tauto.
Defined.

Remark rem_2576 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_old nil -> auto_knows_current nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intro H. intros.
  elim (rem_1319 H);  intros.
  apply (rem_2575 epsilon_mknows_old_pknows_current);  tauto.
Defined.

Remark rem_2577 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_current i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current.  case (rem_2574 epsilon_mknows_old_pknows_current). clear  epsilon_mknows_old_pknows_current. intros. apply trans_knows_current_i_1;  tauto.
 clear  epsilon_mknows_old_pknows_current. tauto.
Defined.

Remark rem_2578 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_old i -> auto_knows_current i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intro H. intros.
  elim (rem_1322 H);  intros.
  apply (rem_2577 epsilon_mknows_old_pknows_current);  tauto.
Defined.

Remark rem_2579 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto_knows_old X1 -> auto_knows_current X1). tauto. exact (rem_2570 epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_2580 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto_knows_old X2 -> auto_knows_current X2. (* Use induction hypothesis. *)
Proof.
   intro Hrec. intros X2.
  cut (auto_knows_old X2 -> auto_knows_current X2). tauto. exact (Hrec X2).
Defined.

Remark rem_2581 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_current X2). tauto. exact (rem_2580 epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_2582 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2579 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2581 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2583 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2582 epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_2584 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_1329 X1 X2 H);  intros.
  apply (rem_2583 epsilon_mknows_old_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2585 : (forall X:term, auto___def_32 X -> auto_knows_current X)
    -> forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto_agent X1 -> auto___def_5 X2 -> auto_agent X2 -> auto___type_2 X3 -> auto___def_26 X4 -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_32_pknows_current. intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  tauto.
Defined.

Remark rem_2586 : (forall X:term, auto___def_32 X -> auto_knows_current X)
    -> forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto_agent X1 -> auto___def_5 X2 -> auto_agent X2 -> auto___type_2 X3 -> auto___def_26 X4 -> auto_knows_current (nonceb_old X1 X2 X3 X4). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_32_pknows_current. intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  case (rem_2585 epsilon_m__def_32_pknows_current X1 X2 X3 X4 A1 A2 A3 A4 A5 A6). clear  epsilon_m__def_32_pknows_current A1 A2 A3 A4 A5 A6. intros. apply trans_knows_current_nonceb_old_1;  tauto.
 clear  epsilon_m__def_32_pknows_current A1 A2 A3 A4 A5 A6. tauto.
Defined.

Remark rem_2587 : (forall X:term, auto___def_32 X -> auto_knows_current X)
    -> forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto_agent X1 -> auto_agent X2 -> auto___def_2 X2 -> auto___type_2 X3 -> auto___def_26 X4 -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_32_pknows_current. intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  tauto.
Defined.

Remark rem_2588 : (forall X:term, auto___def_32 X -> auto_knows_current X)
    -> forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto_agent X1 -> auto_agent X2 -> auto___def_2 X2 -> auto___type_2 X3 -> auto___def_26 X4 -> auto_knows_current (nonceb_old X1 X2 X3 X4). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_32_pknows_current. intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  case (rem_2587 epsilon_m__def_32_pknows_current X1 X2 X3 X4 A1 A2 A3 A4 A5 A6). clear  epsilon_m__def_32_pknows_current A1 A2 A3 A4 A5 A6. intros. apply trans_knows_current_nonceb_old_1;  tauto.
 clear  epsilon_m__def_32_pknows_current A1 A2 A3 A4 A5 A6. tauto.
Defined.

Remark rem_2589 : (forall X:term, auto___def_32 X -> auto_knows_current X)
    -> forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto___type_9 X2 -> auto_agent X2 -> auto___type_2 X3 -> auto_knows_old X4 -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_32_pknows_current. intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5.
  tauto.
Defined.

Remark rem_2590 : (forall X:term, auto___def_32 X -> auto_knows_current X)
    -> forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto___type_9 X2 -> auto_agent X2 -> auto___type_2 X3 -> auto_knows_old X4 -> auto_knows_current (nonceb_old X1 X2 X3 X4). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_32_pknows_current. intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5.
  case (rem_2589 epsilon_m__def_32_pknows_current X1 X2 X3 X4 A1 A2 A3 A4 A5). clear  epsilon_m__def_32_pknows_current A1 A2 A3 A4 A5. intros. apply trans_knows_current_nonceb_old_1;  tauto.
 clear  epsilon_m__def_32_pknows_current A1 A2 A3 A4 A5. tauto.
Defined.

Remark rem_2591 : (forall X:term, auto___def_32 X -> auto_knows_current X)
    -> forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto_agent X1 -> auto___def_7 X2 -> auto_agent X2 -> auto___type_2 X3 -> auto___def_26 X4 -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_32_pknows_current. intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  tauto.
Defined.

Remark rem_2592 : (forall X:term, auto___def_32 X -> auto_knows_current X)
    -> forall X1 X2 X3 X4:term, auto___type_3 X1 -> auto_agent X1 -> auto___def_7 X2 -> auto_agent X2 -> auto___type_2 X3 -> auto___def_26 X4 -> auto_knows_current (nonceb_old X1 X2 X3 X4). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_32_pknows_current. intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  case (rem_2591 epsilon_m__def_32_pknows_current X1 X2 X3 X4 A1 A2 A3 A4 A5 A6). clear  epsilon_m__def_32_pknows_current A1 A2 A3 A4 A5 A6. intros. apply trans_knows_current_nonceb_old_1;  tauto.
 clear  epsilon_m__def_32_pknows_current A1 A2 A3 A4 A5 A6. tauto.
Defined.

Remark rem_2593 : (forall X:term, auto___def_32 X -> auto_knows_current X)
    -> forall X1 X2 X3 X4:term, auto___def_32 (nonceb_old X1 X2 X3 X4) -> auto_knows_current (nonceb_old X1 X2 X3 X4). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_32_pknows_current. intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1648 X1 X2 X3 X4 H);  intros.
  apply (rem_2586 epsilon_m__def_32_pknows_current X1 X2 X3 X4);  tauto.
  apply (rem_2588 epsilon_m__def_32_pknows_current X1 X2 X3 X4);  tauto.
  apply (rem_2590 epsilon_m__def_32_pknows_current X1 X2 X3 X4);  tauto.
  apply (rem_2592 epsilon_m__def_32_pknows_current X1 X2 X3 X4);  tauto.
Defined.

Remark rem_2594 : forall X1:term, auto___def_32 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_m__def_32_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_1660  H).
   intro H. elim (rem_1658  H).
  intros X1 X2. intro H. elim (rem_190 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1656 X1 X2 H).
   intro H. elim (rem_1652  H).
   intro H. elim (rem_1663  H).
  intros X1 X2. intro H. elim (rem_1657 X1 X2 H).
   intro H. elim (rem_1651  H).
  intros X1 X2 X3. intro H. elim (rem_1655 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1659 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1662 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4;  exact (rem_2593 epsilon_m__def_32_pknows_current X1 X2 X3 X4).
   intro H. elim (rem_1665  H).
   intro H. elim (rem_1661  H).
  intros X1. intro H. elim (rem_1650 X1 H).
   intro H. elim (rem_1664  H).
  intros X1 X2 X3. intro H. elim (rem_1653 X1 X2 X3 H).
   intro H. elim (rem_1654  H).
Qed.

Remark rem_2595 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto___def_32 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_mknows_old_pknows_current. exact (rem_2594).
Defined.

Remark rem_2596 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_2 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_32 X1 -> auto_knows_current X1). tauto. exact (rem_2595 epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_2597 : (forall X:term, auto___type_2 X -> auto_knows_current X)
    -> forall X1:term, auto___def_3 X1 -> auto___def_3 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2598 : (forall X:term, auto___type_2 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_pknows_current. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2597 epsilon_m__type_2_pknows_current X1).
Defined.

Remark rem_2599 : (forall X:term, auto___type_2 X -> auto_knows_current X)
    -> forall X2:term, auto___def_2 X2 -> auto___type_9 X2. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Defined.

Remark rem_2600 : (forall X:term, auto___type_2 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___type_9 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_pknows_current. intros X1 X2.
  cut (auto___def_2 X2 -> auto___type_9 X2). tauto. exact (rem_2599 epsilon_m__type_2_pknows_current X2).
Defined.

Remark rem_2601 : (forall X:term, auto___type_2 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> (auto___def_3 X1 /\ auto___type_9 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_2_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2598 epsilon_m__type_2_pknows_current X1 X2);  assumption.
  cut (auto___type_9 X2). 2:apply (rem_2600 epsilon_m__type_2_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2602 : (forall X:term, auto___type_2 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2601 epsilon_m__type_2_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_2_pknows_current A1 A2. intros. apply trans_knows_current_key_2;  tauto.
 clear  epsilon_m__type_2_pknows_current A1 A2. tauto.
Defined.

Remark rem_2603 : (forall X:term, auto___type_2 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_pknows_current. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2597 epsilon_m__type_2_pknows_current X1).
Defined.

Remark rem_2604 : (forall X:term, auto___type_2 X -> auto_knows_current X)
    -> forall X2:term, auto___def_5 X2 -> auto___type_9 X2. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Defined.

Remark rem_2605 : (forall X:term, auto___type_2 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___type_9 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_pknows_current. intros X1 X2.
  cut (auto___def_5 X2 -> auto___type_9 X2). tauto. exact (rem_2604 epsilon_m__type_2_pknows_current X2).
Defined.

Remark rem_2606 : (forall X:term, auto___type_2 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> (auto___def_3 X1 /\ auto___type_9 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_2_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2603 epsilon_m__type_2_pknows_current X1 X2);  assumption.
  cut (auto___type_9 X2). 2:apply (rem_2605 epsilon_m__type_2_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2607 : (forall X:term, auto___type_2 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2606 epsilon_m__type_2_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_2_pknows_current A1 A2. intros. apply trans_knows_current_key_2;  tauto.
 clear  epsilon_m__type_2_pknows_current A1 A2. tauto.
Defined.

Remark rem_2608 : (forall X:term, auto___type_2 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_pknows_current. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2597 epsilon_m__type_2_pknows_current X1).
Defined.

Remark rem_2609 : (forall X:term, auto___type_2 X -> auto_knows_current X)
    -> forall X2:term, auto___def_7 X2 -> auto___type_9 X2. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Defined.

Remark rem_2610 : (forall X:term, auto___type_2 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___type_9 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_pknows_current. intros X1 X2.
  cut (auto___def_7 X2 -> auto___type_9 X2). tauto. exact (rem_2609 epsilon_m__type_2_pknows_current X2).
Defined.

Remark rem_2611 : (forall X:term, auto___type_2 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> (auto___def_3 X1 /\ auto___type_9 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_2_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2608 epsilon_m__type_2_pknows_current X1 X2);  assumption.
  cut (auto___type_9 X2). 2:apply (rem_2610 epsilon_m__type_2_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2612 : (forall X:term, auto___type_2 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2611 epsilon_m__type_2_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_2_pknows_current A1 A2. intros. apply trans_knows_current_key_2;  tauto.
 clear  epsilon_m__type_2_pknows_current A1 A2. tauto.
Defined.

Remark rem_2613 : (forall X:term, auto___type_2 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_2 (key X1 X2) -> auto_knows_current (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_2_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_145 X1 X2 H);  intros.
  apply (rem_2602 epsilon_m__type_2_pknows_current X1 X2);  tauto.
  apply (rem_2607 epsilon_m__type_2_pknows_current X1 X2);  tauto.
  apply (rem_2612 epsilon_m__type_2_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2614 : forall X2:term, auto___type_2 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__type_2_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_1459  H).
   intro H. elim (rem_1457  H).
  intros X1 X2. intro H. elim (rem_1455 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1456 X1 X2 H).
   intro H. elim (rem_1451  H).
   intro H. elim (rem_1463  H).
  intros X1 X2;  exact (rem_2613 epsilon_m__type_2_pknows_current X1 X2).
   intro H. elim (rem_1450  H).
  intros X1 X2 X3. intro H. elim (rem_1454 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1458 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1462 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1460 X1 X2 X3 X4 H).
   intro H. elim (rem_1465  H).
   intro H. elim (rem_1461  H).
  intros X1. intro H. elim (rem_1449 X1 H).
   intro H. elim (rem_1464  H).
  intros X1 X2 X3. intro H. elim (rem_1452 X1 X2 X3 H).
   intro H. elim (rem_1453  H).
Qed.

Remark rem_2615 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto___type_2 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_mknows_old_pknows_current. exact (rem_2614).
Defined.

Remark rem_2616 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_2 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___type_2 X2 -> auto_knows_current X2). tauto. exact (rem_2615 epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_2617 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_2 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2596 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2616 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2618 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_2 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2617 epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_crypt_1;  tauto.
 clear  epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_2619 : (forall X:term, auto___def_26 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto_agent X1 -> auto___type_3 X2 -> auto___type_2 X3 -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_26_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  tauto.
Defined.

Remark rem_2620 : (forall X:term, auto___def_26 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto_agent X1 -> auto___type_3 X2 -> auto___type_2 X3 -> auto_knows_current (noncea_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_26_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_2619 epsilon_m__def_26_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m__def_26_pknows_current A1 A2 A3. intros. apply trans_knows_current_noncea_old_1;  tauto.
 clear  epsilon_m__def_26_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_2621 : (forall X:term, auto___def_26 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto___def_26 (noncea_old X1 X2 X3) -> auto_knows_current (noncea_old X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_26_pknows_current. intros X1 X2 X3. intro H. intros.
  elim (rem_1290 X1 X2 X3 H);  intros.
  apply (rem_2620 epsilon_m__def_26_pknows_current X1 X2 X3);  tauto.
Defined.

Remark rem_2622 : forall X1:term, auto___def_26 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_m__def_26_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_1302  H).
   intro H. elim (rem_1301  H).
  intros X1 X2. intro H. elim (rem_1298 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1299 X1 X2 H).
   intro H. elim (rem_1294  H).
   intro H. elim (rem_1306  H).
  intros X1 X2. intro H. elim (rem_1300 X1 X2 H).
   intro H. elim (rem_1293  H).
  intros X1 X2 X3. intro H. elim (rem_1297 X1 X2 X3 H).
  intros X1 X2 X3;  exact (rem_2621 epsilon_m__def_26_pknows_current X1 X2 X3).
  intros X1 X2 X3 X4. intro H. elim (rem_1305 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1303 X1 X2 X3 X4 H).
   intro H. elim (rem_1308  H).
   intro H. elim (rem_1304  H).
  intros X1. intro H. elim (rem_1292 X1 H).
   intro H. elim (rem_1307  H).
  intros X1 X2 X3. intro H. elim (rem_1295 X1 X2 X3 H).
   intro H. elim (rem_1296  H).
Qed.

Remark rem_2623 : (forall X:term, auto___def_25 X -> auto_knows_current X)
    -> forall X1:term, auto___def_26 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__def_25_pknows_current. exact (rem_2622).
Defined.

Remark rem_2624 : (forall X:term, auto___def_25 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_26 X1 -> auto___def_27 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_25_pknows_current. intros X1 X2.
  cut (auto___def_26 X1 -> auto_knows_current X1). tauto. exact (rem_2623 epsilon_m__def_25_pknows_current X1).
Defined.

Remark rem_2625 : (forall X:term, auto_agent X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_pknows_current.  tauto.
Defined.

Remark rem_2626 : (forall X:term, auto_agent X -> auto_knows_current X)
    -> auto_knows_current i. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_pknows_current.  case (rem_2625 epsilon_magent_pknows_current). clear  epsilon_magent_pknows_current. intros. apply trans_knows_current_i_1;  tauto.
 clear  epsilon_magent_pknows_current. tauto.
Defined.

Remark rem_2627 : (forall X:term, auto_agent X -> auto_knows_current X)
    -> auto_agent i -> auto_knows_current i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_pknows_current. intro H. intros.
  elim (rem_108 H);  intros.
  apply (rem_2626 epsilon_magent_pknows_current);  tauto.
Defined.

Remark rem_2628 : (forall X:term, auto_agent X -> auto_knows_current X)
    -> auto_knows_current bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_pknows_current.  case (rem_2625 epsilon_magent_pknows_current). clear  epsilon_magent_pknows_current. intros. apply trans_knows_current_bob_1;  tauto.
 clear  epsilon_magent_pknows_current. tauto.
Defined.

Remark rem_2629 : (forall X:term, auto_agent X -> auto_knows_current X)
    -> auto_agent bob -> auto_knows_current bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_pknows_current. intro H. intros.
  elim (rem_111 H);  intros.
  apply (rem_2628 epsilon_magent_pknows_current);  tauto.
Defined.

Remark rem_2630 : (forall X:term, auto_agent X -> auto_knows_current X)
    -> auto_knows_current alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_pknows_current.  case (rem_2625 epsilon_magent_pknows_current). clear  epsilon_magent_pknows_current. intros. apply trans_knows_current_alice_1;  tauto.
 clear  epsilon_magent_pknows_current. tauto.
Defined.

Remark rem_2631 : (forall X:term, auto_agent X -> auto_knows_current X)
    -> auto_agent alice -> auto_knows_current alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_pknows_current. intro H. intros.
  elim (rem_114 H);  intros.
  apply (rem_2630 epsilon_magent_pknows_current);  tauto.
Defined.

Remark rem_2632 : (forall X:term, auto_agent X -> auto_knows_current X)
    -> auto_knows_current server. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_pknows_current.  case (rem_2625 epsilon_magent_pknows_current). clear  epsilon_magent_pknows_current. intros. apply trans_knows_current_server_1;  tauto.
 clear  epsilon_magent_pknows_current. tauto.
Defined.

Remark rem_2633 : (forall X:term, auto_agent X -> auto_knows_current X)
    -> auto_agent server -> auto_knows_current server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_pknows_current. intro H. intros.
  elim (rem_117 H);  intros.
  apply (rem_2632 epsilon_magent_pknows_current);  tauto.
Defined.

Remark rem_2634 : forall X1:term, auto_agent X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_magent_pknows_current 1.
  intro X. case X.
  exact (rem_2631 epsilon_magent_pknows_current ).
  exact (rem_2629 epsilon_magent_pknows_current ).
  intros X1 X2. intro H. elim (rem_124 X1 X2 H).
  intros X1 X2. intro H. elim (rem_125 X1 X2 H).
  exact (rem_2627 epsilon_magent_pknows_current ).
   intro H. elim (rem_131  H).
  intros X1 X2. intro H. elim (rem_126 X1 X2 H).
   intro H. elim (rem_120  H).
  intros X1 X2 X3. intro H. elim (rem_123 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_127 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_130 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_128 X1 X2 X3 X4 H).
   intro H. elim (rem_132  H).
   intro H. elim (rem_129  H).
  intros X1. intro H. elim (rem_119 X1 H).
  exact (rem_2633 epsilon_magent_pknows_current ).
  intros X1 X2 X3. intro H. elim (rem_121 X1 X2 X3 H).
   intro H. elim (rem_122  H).
Qed.

Remark rem_2635 : (forall X:term, auto___def_27 X -> auto_knows_current X)
    -> forall X1:term, auto_agent X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__def_27_pknows_current. exact (rem_2634).
Defined.

Remark rem_2636 : (forall X:term, auto___def_27 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_agent X1 -> auto___def_17 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_27_pknows_current. intros X1 X2.
  cut (auto_agent X1 -> auto_knows_current X1). tauto. exact (rem_2635 epsilon_m__def_27_pknows_current X1).
Defined.

Remark rem_2637 : (forall X:term, auto___def_17 X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_17_pknows_current.  tauto.
Defined.

Remark rem_2638 : (forall X:term, auto___def_17 X -> auto_knows_current X)
    -> auto_knows_current nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_17_pknows_current.  case (rem_2637 epsilon_m__def_17_pknows_current). clear  epsilon_m__def_17_pknows_current. intros. apply trans_knows_current_nil_1;  tauto.
 clear  epsilon_m__def_17_pknows_current. tauto.
Defined.

Remark rem_2639 : auto___def_17 nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2640 : (forall X:term, auto___def_17 X -> auto_knows_current X)
    -> auto___def_17 nil -> auto_knows_current nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_17_pknows_current. intro H. intros.
  elim (rem_2639 H);  intros.
  apply (rem_2638 epsilon_m__def_17_pknows_current);  tauto.
Defined.

Remark rem_2641 : forall X1:term, auto___def_17 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2642 : auto___def_17 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2643 : forall X1 X2 X3:term, auto___def_17 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2644 : auto___def_17 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2645 : forall X1 X2 X3:term, auto___def_17 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2646 : forall X1 X2:term, auto___def_17 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2647 : forall X1 X2:term, auto___def_17 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2648 : auto___def_17 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2649 : forall X1 X2 X3:term, auto___def_17 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2650 : auto___def_17 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2651 : forall X1 X2 X3 X4:term, auto___def_17 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2652 : auto___def_17 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2653 : forall X1 X2 X3 X4:term, auto___def_17 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2654 : auto___def_17 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2655 : auto___def_17 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2656 : auto___def_17 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2657 : forall X2:term, auto___def_17 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__def_17_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_2650  H).
   intro H. elim (rem_2648  H).
  intros X1 X2. intro H. elim (rem_846 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2646 X1 X2 H).
   intro H. elim (rem_2642  H).
   intro H. elim (rem_2654  H).
  intros X1 X2. intro H. elim (rem_2647 X1 X2 H).
  exact (rem_2640 epsilon_m__def_17_pknows_current ).
  intros X1 X2 X3. intro H. elim (rem_2645 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2649 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_2653 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_2651 X1 X2 X3 X4 H).
   intro H. elim (rem_2656  H).
   intro H. elim (rem_2652  H).
  intros X1. intro H. elim (rem_2641 X1 H).
   intro H. elim (rem_2655  H).
  intros X1 X2 X3. intro H. elim (rem_2643 X1 X2 X3 H).
   intro H. elim (rem_2644  H).
Qed.

Remark rem_2658 : (forall X:term, auto___def_27 X -> auto_knows_current X)
    -> forall X2:term, auto___def_17 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_m__def_27_pknows_current. exact (rem_2657).
Defined.

Remark rem_2659 : (forall X:term, auto___def_27 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_agent X1 -> auto___def_17 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_27_pknows_current. intros X1 X2.
  cut (auto___def_17 X2 -> auto_knows_current X2). tauto. exact (rem_2658 epsilon_m__def_27_pknows_current X2).
Defined.

Remark rem_2660 : (forall X:term, auto___def_27 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_agent X1 -> auto___def_17 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_27_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2636 epsilon_m__def_27_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2659 epsilon_m__def_27_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2661 : (forall X:term, auto___def_27 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_agent X1 -> auto___def_17 X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_27_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2660 epsilon_m__def_27_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_27_pknows_current A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  epsilon_m__def_27_pknows_current A1 A2. tauto.
Defined.

Remark rem_2662 : (forall X:term, auto___def_27 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_27 (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_27_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_1740 X1 X2 H);  intros.
  apply (rem_2661 epsilon_m__def_27_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2663 : forall X1:term, auto___def_27 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2664 : auto___def_27 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2665 : auto___def_27 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2666 : forall X1 X2 X3:term, auto___def_27 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2667 : auto___def_27 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2668 : forall X1 X2 X3:term, auto___def_27 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2669 : forall X1 X2:term, auto___def_27 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2670 : forall X1 X2:term, auto___def_27 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2671 : auto___def_27 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2672 : forall X1 X2 X3:term, auto___def_27 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2673 : auto___def_27 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2674 : forall X1 X2 X3 X4:term, auto___def_27 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2675 : auto___def_27 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2676 : forall X1 X2 X3 X4:term, auto___def_27 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2677 : auto___def_27 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2678 : auto___def_27 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2679 : auto___def_27 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2680 : forall X2:term, auto___def_27 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__def_27_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_2673  H).
   intro H. elim (rem_2671  H).
  intros X1 X2;  exact (rem_2662 epsilon_m__def_27_pknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_2669 X1 X2 H).
   intro H. elim (rem_2665  H).
   intro H. elim (rem_2677  H).
  intros X1 X2. intro H. elim (rem_2670 X1 X2 H).
   intro H. elim (rem_2664  H).
  intros X1 X2 X3. intro H. elim (rem_2668 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2672 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_2676 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_2674 X1 X2 X3 X4 H).
   intro H. elim (rem_2679  H).
   intro H. elim (rem_2675  H).
  intros X1. intro H. elim (rem_2663 X1 H).
   intro H. elim (rem_2678  H).
  intros X1 X2 X3. intro H. elim (rem_2666 X1 X2 X3 H).
   intro H. elim (rem_2667  H).
Qed.

Remark rem_2681 : (forall X:term, auto___def_25 X -> auto_knows_current X)
    -> forall X2:term, auto___def_27 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_m__def_25_pknows_current. exact (rem_2680).
Defined.

Remark rem_2682 : (forall X:term, auto___def_25 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_26 X1 -> auto___def_27 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_25_pknows_current. intros X1 X2.
  cut (auto___def_27 X2 -> auto_knows_current X2). tauto. exact (rem_2681 epsilon_m__def_25_pknows_current X2).
Defined.

Remark rem_2683 : (forall X:term, auto___def_25 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_26 X1 -> auto___def_27 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_25_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2624 epsilon_m__def_25_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2682 epsilon_m__def_25_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2684 : (forall X:term, auto___def_25 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_26 X1 -> auto___def_27 X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_25_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2683 epsilon_m__def_25_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_25_pknows_current A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  epsilon_m__def_25_pknows_current A1 A2. tauto.
Defined.

Remark rem_2685 : (forall X:term, auto___def_25 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_25 (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_25_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_1742 X1 X2 H);  intros.
  apply (rem_2684 epsilon_m__def_25_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2686 : forall X1:term, auto___def_25 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2687 : auto___def_25 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2688 : auto___def_25 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2689 : forall X1 X2 X3:term, auto___def_25 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2690 : auto___def_25 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2691 : forall X1 X2 X3:term, auto___def_25 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2692 : forall X1 X2:term, auto___def_25 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2693 : forall X1 X2:term, auto___def_25 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2694 : auto___def_25 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2695 : forall X1 X2 X3:term, auto___def_25 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2696 : auto___def_25 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2697 : forall X1 X2 X3 X4:term, auto___def_25 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2698 : auto___def_25 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2699 : forall X1 X2 X3 X4:term, auto___def_25 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2700 : auto___def_25 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2701 : auto___def_25 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2702 : auto___def_25 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2703 : forall X1:term, auto___def_25 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_m__def_25_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_2696  H).
   intro H. elim (rem_2694  H).
  intros X1 X2;  exact (rem_2685 epsilon_m__def_25_pknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_2692 X1 X2 H).
   intro H. elim (rem_2688  H).
   intro H. elim (rem_2700  H).
  intros X1 X2. intro H. elim (rem_2693 X1 X2 H).
   intro H. elim (rem_2687  H).
  intros X1 X2 X3. intro H. elim (rem_2691 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2695 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_2699 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_2697 X1 X2 X3 X4 H).
   intro H. elim (rem_2702  H).
   intro H. elim (rem_2698  H).
  intros X1. intro H. elim (rem_2686 X1 H).
   intro H. elim (rem_2701  H).
  intros X1 X2 X3. intro H. elim (rem_2689 X1 X2 X3 H).
   intro H. elim (rem_2690  H).
Qed.

Remark rem_2704 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto___def_25 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_mknows_old_pknows_current. exact (rem_2703).
Defined.

Remark rem_2705 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_25 X1 -> auto___type_4 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_25 X1 -> auto_knows_current X1). tauto. exact (rem_2704 epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_2706 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1:term, auto___def_3 X1 -> auto___def_3 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2707 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2706 epsilon_m__type_4_pknows_current X1).
Defined.

Remark rem_2708 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X2:term, auto___def_2 X2 -> auto___type_9 X2. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Defined.

Remark rem_2709 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___type_9 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2.
  cut (auto___def_2 X2 -> auto___type_9 X2). tauto. exact (rem_2708 epsilon_m__type_4_pknows_current X2).
Defined.

Remark rem_2710 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> (auto___def_3 X1 /\ auto___type_9 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2707 epsilon_m__type_4_pknows_current X1 X2);  assumption.
  cut (auto___type_9 X2). 2:apply (rem_2709 epsilon_m__type_4_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2711 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2710 epsilon_m__type_4_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_4_pknows_current A1 A2. intros. apply trans_knows_current_key_2;  tauto.
 clear  epsilon_m__type_4_pknows_current A1 A2. tauto.
Defined.

Remark rem_2712 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2706 epsilon_m__type_4_pknows_current X1).
Defined.

Remark rem_2713 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X2:term, auto___def_5 X2 -> auto___type_9 X2. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Defined.

Remark rem_2714 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___type_9 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2.
  cut (auto___def_5 X2 -> auto___type_9 X2). tauto. exact (rem_2713 epsilon_m__type_4_pknows_current X2).
Defined.

Remark rem_2715 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> (auto___def_3 X1 /\ auto___type_9 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2712 epsilon_m__type_4_pknows_current X1 X2);  assumption.
  cut (auto___type_9 X2). 2:apply (rem_2714 epsilon_m__type_4_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2716 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2715 epsilon_m__type_4_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_4_pknows_current A1 A2. intros. apply trans_knows_current_key_2;  tauto.
 clear  epsilon_m__type_4_pknows_current A1 A2. tauto.
Defined.

Remark rem_2717 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2706 epsilon_m__type_4_pknows_current X1).
Defined.

Remark rem_2718 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X2:term, auto___def_7 X2 -> auto___type_9 X2. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Defined.

Remark rem_2719 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___type_9 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2.
  cut (auto___def_7 X2 -> auto___type_9 X2). tauto. exact (rem_2718 epsilon_m__type_4_pknows_current X2).
Defined.

Remark rem_2720 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> (auto___def_3 X1 /\ auto___type_9 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2717 epsilon_m__type_4_pknows_current X1 X2);  assumption.
  cut (auto___type_9 X2). 2:apply (rem_2719 epsilon_m__type_4_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2721 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2720 epsilon_m__type_4_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_4_pknows_current A1 A2. intros. apply trans_knows_current_key_2;  tauto.
 clear  epsilon_m__type_4_pknows_current A1 A2. tauto.
Defined.

Remark rem_2722 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_4 (key X1 X2) -> auto_knows_current (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_153 X1 X2 H);  intros.
  apply (rem_2711 epsilon_m__type_4_pknows_current X1 X2);  tauto.
  apply (rem_2716 epsilon_m__type_4_pknows_current X1 X2);  tauto.
  apply (rem_2721 epsilon_m__type_4_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2723 : forall X1:term, auto___type_4 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2724 : auto___type_4 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2725 : auto___type_4 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2726 : forall X1 X2 X3:term, auto___type_4 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2727 : auto___type_4 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2728 : forall X1 X2 X3:term, auto___type_4 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2729 : forall X1 X2:term, auto___type_4 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2730 : forall X1 X2:term, auto___type_4 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2731 : auto___type_4 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2732 : forall X1 X2 X3:term, auto___type_4 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2733 : auto___type_4 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2734 : forall X1 X2 X3 X4:term, auto___type_4 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2735 : auto___type_4 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2736 : forall X1 X2 X3 X4:term, auto___type_4 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2737 : auto___type_4 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2738 : auto___type_4 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2739 : auto___type_4 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2740 : forall X2:term, auto___type_4 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__type_4_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_2733  H).
   intro H. elim (rem_2731  H).
  intros X1 X2. intro H. elim (rem_2729 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2730 X1 X2 H).
   intro H. elim (rem_2725  H).
   intro H. elim (rem_2737  H).
  intros X1 X2;  exact (rem_2722 epsilon_m__type_4_pknows_current X1 X2).
   intro H. elim (rem_2724  H).
  intros X1 X2 X3. intro H. elim (rem_2728 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2732 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_2736 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_2734 X1 X2 X3 X4 H).
   intro H. elim (rem_2739  H).
   intro H. elim (rem_2735  H).
  intros X1. intro H. elim (rem_2723 X1 H).
   intro H. elim (rem_2738  H).
  intros X1 X2 X3. intro H. elim (rem_2726 X1 X2 X3 H).
   intro H. elim (rem_2727  H).
Qed.

Remark rem_2741 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto___type_4 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_mknows_old_pknows_current. exact (rem_2740).
Defined.

Remark rem_2742 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_25 X1 -> auto___type_4 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___type_4 X2 -> auto_knows_current X2). tauto. exact (rem_2741 epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_2743 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_25 X1 -> auto___type_4 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2705 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2742 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2744 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_25 X1 -> auto___type_4 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2743 epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_crypt_1;  tauto.
 clear  epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_2745 : (forall X:term, auto___type_2 X -> auto___type_10 X)
    -> forall X1:term, auto___def_3 X1 -> auto___def_3 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2746 : (forall X:term, auto___type_2 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_p__type_10. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2745 epsilon_m__type_2_p__type_10 X1).
Defined.

Remark rem_2747 : (forall X:term, auto___type_2 X -> auto___type_10 X)
    -> forall X2:term, auto___def_2 X2 -> auto___def_2 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2748 : (forall X:term, auto___type_2 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___def_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_p__type_10. intros X1 X2.
  cut (auto___def_2 X2 -> auto___def_2 X2). tauto. exact (rem_2747 epsilon_m__type_2_p__type_10 X2).
Defined.

Remark rem_2749 : (forall X:term, auto___type_2 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> (auto___def_3 X1 /\ auto___def_2 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_2_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2746 epsilon_m__type_2_p__type_10 X1 X2);  assumption.
  cut (auto___def_2 X2). 2:apply (rem_2748 epsilon_m__type_2_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2750 : (forall X:term, auto___type_2 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___type_10 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_2749 epsilon_m__type_2_p__type_10 X1 X2 A1 A2). clear  epsilon_m__type_2_p__type_10 A1 A2. intros. apply trans___type_10_key_1;  tauto.
 clear  epsilon_m__type_2_p__type_10 A1 A2. tauto.
Defined.

Remark rem_2751 : (forall X:term, auto___type_2 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_p__type_10. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2745 epsilon_m__type_2_p__type_10 X1).
Defined.

Remark rem_2752 : (forall X:term, auto___type_2 X -> auto___type_10 X)
    -> forall X2:term, auto___def_5 X2 -> auto___def_5 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2753 : (forall X:term, auto___type_2 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___def_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_p__type_10. intros X1 X2.
  cut (auto___def_5 X2 -> auto___def_5 X2). tauto. exact (rem_2752 epsilon_m__type_2_p__type_10 X2).
Defined.

Remark rem_2754 : (forall X:term, auto___type_2 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> (auto___def_3 X1 /\ auto___def_5 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_2_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2751 epsilon_m__type_2_p__type_10 X1 X2);  assumption.
  cut (auto___def_5 X2). 2:apply (rem_2753 epsilon_m__type_2_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2755 : (forall X:term, auto___type_2 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___type_10 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_2754 epsilon_m__type_2_p__type_10 X1 X2 A1 A2). clear  epsilon_m__type_2_p__type_10 A1 A2. intros. apply trans___type_10_key_2;  tauto.
 clear  epsilon_m__type_2_p__type_10 A1 A2. tauto.
Defined.

Remark rem_2756 : (forall X:term, auto___type_2 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_p__type_10. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2745 epsilon_m__type_2_p__type_10 X1).
Defined.

Remark rem_2757 : (forall X:term, auto___type_2 X -> auto___type_10 X)
    -> forall X2:term, auto___def_7 X2 -> auto___def_7 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2758 : (forall X:term, auto___type_2 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___def_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_2_p__type_10. intros X1 X2.
  cut (auto___def_7 X2 -> auto___def_7 X2). tauto. exact (rem_2757 epsilon_m__type_2_p__type_10 X2).
Defined.

Remark rem_2759 : (forall X:term, auto___type_2 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> (auto___def_3 X1 /\ auto___def_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_2_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2756 epsilon_m__type_2_p__type_10 X1 X2);  assumption.
  cut (auto___def_7 X2). 2:apply (rem_2758 epsilon_m__type_2_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2760 : (forall X:term, auto___type_2 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___type_10 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_2759 epsilon_m__type_2_p__type_10 X1 X2 A1 A2). clear  epsilon_m__type_2_p__type_10 A1 A2. intros. apply trans___type_10_key_3;  tauto.
 clear  epsilon_m__type_2_p__type_10 A1 A2. tauto.
Defined.

Remark rem_2761 : (forall X:term, auto___type_2 X -> auto___type_10 X)
    -> forall X1 X2:term, auto___type_2 (key X1 X2) -> auto___type_10 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_2_p__type_10. intros X1 X2. intro H. intros.
  elim (rem_145 X1 X2 H);  intros.
  apply (rem_2750 epsilon_m__type_2_p__type_10 X1 X2);  tauto.
  apply (rem_2755 epsilon_m__type_2_p__type_10 X1 X2);  tauto.
  apply (rem_2760 epsilon_m__type_2_p__type_10 X1 X2);  tauto.
Defined.

Remark rem_2762 : forall X1:term, auto___type_2 X1 -> auto___type_10 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_2_p__type_10 1.
  intro X. case X.
   intro H. elim (rem_1459  H).
   intro H. elim (rem_1457  H).
  intros X1 X2. intro H. elim (rem_1455 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1456 X1 X2 H).
   intro H. elim (rem_1451  H).
   intro H. elim (rem_1463  H).
  intros X1 X2;  exact (rem_2761 epsilon_m__type_2_p__type_10 X1 X2).
   intro H. elim (rem_1450  H).
  intros X1 X2 X3. intro H. elim (rem_1454 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1458 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1462 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1460 X1 X2 X3 X4 H).
   intro H. elim (rem_1465  H).
   intro H. elim (rem_1461  H).
  intros X1. intro H. elim (rem_1449 X1 H).
   intro H. elim (rem_1464  H).
  intros X1 X2 X3. intro H. elim (rem_1452 X1 X2 X3 H).
   intro H. elim (rem_1453  H).
Qed.

Remark rem_2763 : (forall X:term, auto___def_19 X -> auto___def_46 X)
    -> forall X1:term, auto___type_2 X1 -> auto___type_10 X1. (* Cut history. *)
Proof.  intros epsilon_m__def_19_p__def_46. exact (rem_2762).
Defined.

Remark rem_2764 : (forall X:term, auto___def_19 X -> auto___def_46 X)
    -> forall X1 X2:term, auto___type_2 X1 -> auto___def_21 X2 -> auto___type_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_19_p__def_46. intros X1 X2.
  cut (auto___type_2 X1 -> auto___type_10 X1). tauto. exact (rem_2763 epsilon_m__def_19_p__def_46 X1).
Defined.

Remark rem_2765 : (forall X:term, auto___type_3 X -> auto___type_11 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_p__type_11.  tauto.
Defined.

Remark rem_2766 : (forall X:term, auto___type_3 X -> auto___type_11 X)
    -> auto___type_11 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_p__type_11.  case (rem_2765 epsilon_m__type_3_p__type_11). clear  epsilon_m__type_3_p__type_11. intros. apply trans___type_11_bob_1;  tauto.
 clear  epsilon_m__type_3_p__type_11. tauto.
Defined.

Remark rem_2767 : (forall X:term, auto___type_3 X -> auto___type_11 X)
    -> auto___type_3 bob -> auto___type_11 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_p__type_11. intro H. intros.
  elim (rem_369 H);  intros.
  apply (rem_2766 epsilon_m__type_3_p__type_11);  tauto.
Defined.

Remark rem_2768 : (forall X:term, auto___type_3 X -> auto___type_11 X)
    -> auto___type_11 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_p__type_11.  case (rem_2765 epsilon_m__type_3_p__type_11). clear  epsilon_m__type_3_p__type_11. intros. apply trans___type_11_alice_1;  tauto.
 clear  epsilon_m__type_3_p__type_11. tauto.
Defined.

Remark rem_2769 : (forall X:term, auto___type_3 X -> auto___type_11 X)
    -> auto___type_3 alice -> auto___type_11 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_p__type_11. intro H. intros.
  elim (rem_372 H);  intros.
  apply (rem_2768 epsilon_m__type_3_p__type_11);  tauto.
Defined.

Remark rem_2770 : (forall X:term, auto___type_3 X -> auto___type_11 X)
    -> auto___type_11 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_p__type_11.  case (rem_2765 epsilon_m__type_3_p__type_11). clear  epsilon_m__type_3_p__type_11. intros. apply trans___type_11_server_1;  tauto.
 clear  epsilon_m__type_3_p__type_11. tauto.
Defined.

Remark rem_2771 : (forall X:term, auto___type_3 X -> auto___type_11 X)
    -> auto___type_3 server -> auto___type_11 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_p__type_11. intro H. intros.
  elim (rem_375 H);  intros.
  apply (rem_2770 epsilon_m__type_3_p__type_11);  tauto.
Defined.

Remark rem_2772 : forall X1:term, auto___type_3 X1 -> auto___type_11 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_3_p__type_11 1.
  intro X. case X.
  exact (rem_2769 epsilon_m__type_3_p__type_11 ).
  exact (rem_2767 epsilon_m__type_3_p__type_11 ).
  intros X1 X2. intro H. elim (rem_383 X1 X2 H).
  intros X1 X2. intro H. elim (rem_384 X1 X2 H).
   intro H. elim (rem_379  H).
   intro H. elim (rem_390  H).
  intros X1 X2. intro H. elim (rem_385 X1 X2 H).
   intro H. elim (rem_378  H).
  intros X1 X2 X3. intro H. elim (rem_382 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_386 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_389 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_387 X1 X2 X3 X4 H).
   intro H. elim (rem_391  H).
   intro H. elim (rem_388  H).
  intros X1. intro H. elim (rem_377 X1 H).
  exact (rem_2771 epsilon_m__type_3_p__type_11 ).
  intros X1 X2 X3. intro H. elim (rem_380 X1 X2 X3 H).
   intro H. elim (rem_381  H).
Qed.

Remark rem_2773 : (forall X:term, auto___def_21 X -> auto___def_48 X)
    -> forall X1:term, auto___type_3 X1 -> auto___type_11 X1. (* Cut history. *)
Proof.  intros epsilon_m__def_21_p__def_48. exact (rem_2772).
Defined.

Remark rem_2774 : (forall X:term, auto___def_21 X -> auto___def_48 X)
    -> forall X1 X2:term, auto___type_3 X1 -> auto___def_22 X2 -> auto___type_11 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_21_p__def_48. intros X1 X2.
  cut (auto___type_3 X1 -> auto___type_11 X1). tauto. exact (rem_2773 epsilon_m__def_21_p__def_48 X1).
Defined.

Remark rem_2775 : (forall X:term, auto___def_22 X -> auto___def_49 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_22_p__def_49.  tauto.
Defined.

Remark rem_2776 : (forall X:term, auto___def_22 X -> auto___def_49 X)
    -> auto___def_49 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_22_p__def_49.  case (rem_2775 epsilon_m__def_22_p__def_49). clear  epsilon_m__def_22_p__def_49. intros. apply trans___def_49_nil_1;  tauto.
 clear  epsilon_m__def_22_p__def_49. tauto.
Defined.

Remark rem_2777 : (forall X:term, auto___def_22 X -> auto___def_49 X)
    -> auto___def_22 nil -> auto___def_49 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_22_p__def_49. intro H. intros.
  elim (rem_1481 H);  intros.
  apply (rem_2776 epsilon_m__def_22_p__def_49);  tauto.
Defined.

Remark rem_2778 : forall X2:term, auto___def_22 X2 -> auto___def_49 X2. (* Induct. *)
Proof.
  fix epsilon_m__def_22_p__def_49 1.
  intro X. case X.
   intro H. elim (rem_1493  H).
   intro H. elim (rem_1491  H).
  intros X1 X2. intro H. elim (rem_1488 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1489 X1 X2 H).
   intro H. elim (rem_1484  H).
   intro H. elim (rem_1497  H).
  intros X1 X2. intro H. elim (rem_1490 X1 X2 H).
  exact (rem_2777 epsilon_m__def_22_p__def_49 ).
  intros X1 X2 X3. intro H. elim (rem_1487 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1492 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1496 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1494 X1 X2 X3 X4 H).
   intro H. elim (rem_1499  H).
   intro H. elim (rem_1495  H).
  intros X1. intro H. elim (rem_1483 X1 H).
   intro H. elim (rem_1498  H).
  intros X1 X2 X3. intro H. elim (rem_1485 X1 X2 X3 H).
   intro H. elim (rem_1486  H).
Qed.

Remark rem_2779 : (forall X:term, auto___def_21 X -> auto___def_48 X)
    -> forall X2:term, auto___def_22 X2 -> auto___def_49 X2. (* Cut history. *)
Proof.  intros epsilon_m__def_21_p__def_48. exact (rem_2778).
Defined.

Remark rem_2780 : (forall X:term, auto___def_21 X -> auto___def_48 X)
    -> forall X1 X2:term, auto___type_3 X1 -> auto___def_22 X2 -> auto___def_49 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_21_p__def_48. intros X1 X2.
  cut (auto___def_22 X2 -> auto___def_49 X2). tauto. exact (rem_2779 epsilon_m__def_21_p__def_48 X2).
Defined.

Remark rem_2781 : (forall X:term, auto___def_21 X -> auto___def_48 X)
    -> forall X1 X2:term, auto___type_3 X1 -> auto___def_22 X2 -> (auto___type_11 X1 /\ auto___def_49 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_21_p__def_48. intros X1 X2. intros A1 A2.
  cut (auto___type_11 X1). 2:apply (rem_2774 epsilon_m__def_21_p__def_48 X1 X2);  assumption.
  cut (auto___def_49 X2). 2:apply (rem_2780 epsilon_m__def_21_p__def_48 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2782 : (forall X:term, auto___def_21 X -> auto___def_48 X)
    -> forall X1 X2:term, auto___type_3 X1 -> auto___def_22 X2 -> auto___def_48 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_21_p__def_48. intros X1 X2. intros A1 A2.
  case (rem_2781 epsilon_m__def_21_p__def_48 X1 X2 A1 A2). clear  epsilon_m__def_21_p__def_48 A1 A2. intros. apply trans___def_48_cons_1;  tauto.
 clear  epsilon_m__def_21_p__def_48 A1 A2. tauto.
Defined.

Remark rem_2783 : (forall X:term, auto___def_21 X -> auto___def_48 X)
    -> forall X1 X2:term, auto___def_21 (cons X1 X2) -> auto___def_48 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_21_p__def_48. intros X1 X2. intro H. intros.
  elim (rem_206 X1 X2 H);  intros.
  apply (rem_2782 epsilon_m__def_21_p__def_48 X1 X2);  tauto.
Defined.

Remark rem_2784 : forall X2:term, auto___def_21 X2 -> auto___def_48 X2. (* Induct. *)
Proof.
  fix epsilon_m__def_21_p__def_48 1.
  intro X. case X.
   intro H. elim (rem_1516  H).
   intro H. elim (rem_1514  H).
  intros X1 X2;  exact (rem_2783 epsilon_m__def_21_p__def_48 X1 X2).
  intros X1 X2. intro H. elim (rem_1512 X1 X2 H).
   intro H. elim (rem_1508  H).
   intro H. elim (rem_1520  H).
  intros X1 X2. intro H. elim (rem_1513 X1 X2 H).
   intro H. elim (rem_1507  H).
  intros X1 X2 X3. intro H. elim (rem_1511 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1515 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1519 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1517 X1 X2 X3 X4 H).
   intro H. elim (rem_1522  H).
   intro H. elim (rem_1518  H).
  intros X1. intro H. elim (rem_1506 X1 H).
   intro H. elim (rem_1521  H).
  intros X1 X2 X3. intro H. elim (rem_1509 X1 X2 X3 H).
   intro H. elim (rem_1510  H).
Qed.

Remark rem_2785 : (forall X:term, auto___def_19 X -> auto___def_46 X)
    -> forall X2:term, auto___def_21 X2 -> auto___def_48 X2. (* Cut history. *)
Proof.  intros epsilon_m__def_19_p__def_46. exact (rem_2784).
Defined.

Remark rem_2786 : (forall X:term, auto___def_19 X -> auto___def_46 X)
    -> forall X1 X2:term, auto___type_2 X1 -> auto___def_21 X2 -> auto___def_48 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_19_p__def_46. intros X1 X2.
  cut (auto___def_21 X2 -> auto___def_48 X2). tauto. exact (rem_2785 epsilon_m__def_19_p__def_46 X2).
Defined.

Remark rem_2787 : (forall X:term, auto___def_19 X -> auto___def_46 X)
    -> forall X1 X2:term, auto___type_2 X1 -> auto___def_21 X2 -> (auto___type_10 X1 /\ auto___def_48 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_19_p__def_46. intros X1 X2. intros A1 A2.
  cut (auto___type_10 X1). 2:apply (rem_2764 epsilon_m__def_19_p__def_46 X1 X2);  assumption.
  cut (auto___def_48 X2). 2:apply (rem_2786 epsilon_m__def_19_p__def_46 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2788 : (forall X:term, auto___def_19 X -> auto___def_46 X)
    -> forall X1 X2:term, auto___type_2 X1 -> auto___def_21 X2 -> auto___def_46 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_19_p__def_46. intros X1 X2. intros A1 A2.
  case (rem_2787 epsilon_m__def_19_p__def_46 X1 X2 A1 A2). clear  epsilon_m__def_19_p__def_46 A1 A2. intros. apply trans___def_46_cons_1;  tauto.
 clear  epsilon_m__def_19_p__def_46 A1 A2. tauto.
Defined.

Remark rem_2789 : (forall X:term, auto___def_19 X -> auto___def_46 X)
    -> forall X1 X2:term, auto___def_19 (cons X1 X2) -> auto___def_46 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_19_p__def_46. intros X1 X2. intro H. intros.
  elim (rem_209 X1 X2 H);  intros.
  apply (rem_2788 epsilon_m__def_19_p__def_46 X1 X2);  tauto.
Defined.

Remark rem_2790 : forall X1:term, auto___def_19 X1 -> auto___def_46 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_19_p__def_46 1.
  intro X. case X.
   intro H. elim (rem_1539  H).
   intro H. elim (rem_1537  H).
  intros X1 X2;  exact (rem_2789 epsilon_m__def_19_p__def_46 X1 X2).
  intros X1 X2. intro H. elim (rem_1535 X1 X2 H).
   intro H. elim (rem_1531  H).
   intro H. elim (rem_1543  H).
  intros X1 X2. intro H. elim (rem_1536 X1 X2 H).
   intro H. elim (rem_1530  H).
  intros X1 X2 X3. intro H. elim (rem_1534 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1538 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1542 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_1540 X1 X2 X3 X4 H).
   intro H. elim (rem_1545  H).
   intro H. elim (rem_1541  H).
  intros X1. intro H. elim (rem_1529 X1 H).
   intro H. elim (rem_1544  H).
  intros X1 X2 X3. intro H. elim (rem_1532 X1 X2 X3 H).
   intro H. elim (rem_1533  H).
Qed.

Remark rem_2791 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto___def_19 X1 -> auto___def_46 X1. (* Cut history. *)
Proof.  intros epsilon_mknows_old_pknows_current. exact (rem_2790).
Defined.

Remark rem_2792 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto___def_46 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_19 X1 -> auto___def_46 X1). tauto. exact (rem_2791 epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_2793 : (forall X:term, auto___def_20 X -> auto___def_47 X)
    -> forall X1:term, auto___def_23 X1 -> auto___def_23 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2794 : (forall X:term, auto___def_20 X -> auto___def_47 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_7 X2 -> auto___def_23 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_20_p__def_47. intros X1 X2.
  cut (auto___def_23 X1 -> auto___def_23 X1). tauto. exact (rem_2793 epsilon_m__def_20_p__def_47 X1).
Defined.

Remark rem_2795 : (forall X:term, auto___def_20 X -> auto___def_47 X)
    -> forall X2:term, auto___def_7 X2 -> auto___def_7 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2796 : (forall X:term, auto___def_20 X -> auto___def_47 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_7 X2 -> auto___def_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_20_p__def_47. intros X1 X2.
  cut (auto___def_7 X2 -> auto___def_7 X2). tauto. exact (rem_2795 epsilon_m__def_20_p__def_47 X2).
Defined.

Remark rem_2797 : (forall X:term, auto___def_20 X -> auto___def_47 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_7 X2 -> (auto___def_23 X1 /\ auto___def_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_20_p__def_47. intros X1 X2. intros A1 A2.
  cut (auto___def_23 X1). 2:apply (rem_2794 epsilon_m__def_20_p__def_47 X1 X2);  assumption.
  cut (auto___def_7 X2). 2:apply (rem_2796 epsilon_m__def_20_p__def_47 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2798 : (forall X:term, auto___def_20 X -> auto___def_47 X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_7 X2 -> auto___def_47 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_20_p__def_47. intros X1 X2. intros A1 A2.
  case (rem_2797 epsilon_m__def_20_p__def_47 X1 X2 A1 A2). clear  epsilon_m__def_20_p__def_47 A1 A2. intros. apply trans___def_47_key_1;  tauto.
 clear  epsilon_m__def_20_p__def_47 A1 A2. tauto.
Defined.

Remark rem_2799 : (forall X:term, auto___def_20 X -> auto___def_47 X)
    -> forall X1 X2:term, auto___def_20 (key X1 X2) -> auto___def_47 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_20_p__def_47. intros X1 X2. intro H. intros.
  elim (rem_162 X1 X2 H);  intros.
  apply (rem_2798 epsilon_m__def_20_p__def_47 X1 X2);  tauto.
Defined.

Remark rem_2800 : forall X1:term, auto___def_20 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2801 : auto___def_20 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2802 : auto___def_20 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2803 : forall X1 X2 X3:term, auto___def_20 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2804 : auto___def_20 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2805 : forall X1 X2 X3:term, auto___def_20 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2806 : forall X1 X2:term, auto___def_20 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2807 : forall X1 X2:term, auto___def_20 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2808 : auto___def_20 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2809 : forall X1 X2 X3:term, auto___def_20 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2810 : auto___def_20 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2811 : forall X1 X2 X3 X4:term, auto___def_20 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2812 : auto___def_20 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2813 : forall X1 X2 X3 X4:term, auto___def_20 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2814 : auto___def_20 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2815 : auto___def_20 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2816 : auto___def_20 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2817 : forall X2:term, auto___def_20 X2 -> auto___def_47 X2. (* Induct. *)
Proof.
  fix epsilon_m__def_20_p__def_47 1.
  intro X. case X.
   intro H. elim (rem_2810  H).
   intro H. elim (rem_2808  H).
  intros X1 X2. intro H. elim (rem_2806 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2807 X1 X2 H).
   intro H. elim (rem_2802  H).
   intro H. elim (rem_2814  H).
  intros X1 X2;  exact (rem_2799 epsilon_m__def_20_p__def_47 X1 X2).
   intro H. elim (rem_2801  H).
  intros X1 X2 X3. intro H. elim (rem_2805 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2809 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_2813 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_2811 X1 X2 X3 X4 H).
   intro H. elim (rem_2816  H).
   intro H. elim (rem_2812  H).
  intros X1. intro H. elim (rem_2800 X1 H).
   intro H. elim (rem_2815  H).
  intros X1 X2 X3. intro H. elim (rem_2803 X1 X2 X3 H).
   intro H. elim (rem_2804  H).
Qed.

Remark rem_2818 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto___def_20 X2 -> auto___def_47 X2. (* Cut history. *)
Proof.  intros epsilon_mknows_old_pknows_current. exact (rem_2817).
Defined.

Remark rem_2819 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto___def_47 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_20 X2 -> auto___def_47 X2). tauto. exact (rem_2818 epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_2820 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> (auto___def_46 X1 /\ auto___def_47 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_46 X1). 2:apply (rem_2792 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto___def_47 X2). 2:apply (rem_2819 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2821 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2820 epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_crypt_4;  tauto.
 clear  epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_2822 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2582 epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_crypt_1;  tauto.
 clear  epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_2823 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_current X1. (* Use induction hypothesis. *)
Proof.
   intro Hrec. intro H. clear H. intro H. clear H. intros X1.
  cut (auto_knows_old X1 -> auto_knows_current X1). tauto. exact (Hrec X1).
Defined.

Remark rem_2824 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_2823 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1);  assumption.
  tauto.
Defined.

Remark rem_2825 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_current (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1. intros A1.
  case (rem_2824 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 A1). clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current A1. intros. apply trans_knows_current_s_1;  tauto.
 clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current A1. tauto.
Defined.

Remark rem_2826 : forall X1:term, auto___type_7 (s X1) -> or_1
    (auto_knows_old X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2827 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1:term, auto___type_7 (s X1) -> auto_knows_current (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1. intro H. intros.
  elim (rem_2826 X1 H);  intros.
  apply (rem_2825 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1);  tauto.
Defined.

Remark rem_2828 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current.  tauto.
Defined.

Remark rem_2829 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> auto_knows_current nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current.  case (rem_2828 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current). clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros. apply trans_knows_current_nil_1;  tauto.
 clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. tauto.
Defined.

Remark rem_2830 : auto___type_7 nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2831 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> auto___type_7 nil -> auto_knows_current nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intro H. intros.
  elim (rem_2830 H);  intros.
  apply (rem_2829 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current);  tauto.
Defined.

Remark rem_2832 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> auto_knows_current i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current.  case (rem_2828 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current). clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros. apply trans_knows_current_i_1;  tauto.
 clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. tauto.
Defined.

Remark rem_2833 : auto___type_7 i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2834 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> auto___type_7 i -> auto_knows_current i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intro H. intros.
  elim (rem_2833 H);  intros.
  apply (rem_2832 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current);  tauto.
Defined.

Remark rem_2835 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2.
  cut (auto_knows_old X1 -> auto_knows_current X1). tauto. exact (rem_2823 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1).
Defined.

Remark rem_2836 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X2:term, auto_knows_old X2 -> auto_knows_current X2. (* Use induction hypothesis. *)
Proof.
   intro Hrec. intro H. clear H. intro H. clear H. intros X2.
  cut (auto_knows_old X2 -> auto_knows_current X2). tauto. exact (Hrec X2).
Defined.

Remark rem_2837 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_current X2). tauto. exact (rem_2836 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X2).
Defined.

Remark rem_2838 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2835 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2837 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2839 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2838 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current A1 A2. tauto.
Defined.

Remark rem_2840 : forall X1 X2:term, auto___type_7 (cons X1 X2) -> or_1
    (auto_knows_old X1 /\ auto_knows_old X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2841 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_7 (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_2840 X1 X2 H);  intros.
  apply (rem_2839 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2842 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1:term, auto___def_32 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. exact (rem_2595 epsilon_mknows_old_pknows_current).
Defined.

Remark rem_2843 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_2 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2.
  cut (auto___def_32 X1 -> auto_knows_current X1). tauto. exact (rem_2842 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1).
Defined.

Remark rem_2844 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X2:term, auto___type_2 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. exact (rem_2615 epsilon_mknows_old_pknows_current).
Defined.

Remark rem_2845 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_2 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2.
  cut (auto___type_2 X2 -> auto_knows_current X2). tauto. exact (rem_2844 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X2).
Defined.

Remark rem_2846 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_2 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2843 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2845 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2847 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_2 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2846 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current A1 A2. intros. apply trans_knows_current_crypt_1;  tauto.
 clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current A1 A2. tauto.
Defined.

Remark rem_2848 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1:term, auto___def_25 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. exact (rem_2704 epsilon_mknows_old_pknows_current).
Defined.

Remark rem_2849 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_25 X1 -> auto___type_4 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2.
  cut (auto___def_25 X1 -> auto_knows_current X1). tauto. exact (rem_2848 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1).
Defined.

Remark rem_2850 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X2:term, auto___type_4 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. exact (rem_2741 epsilon_mknows_old_pknows_current).
Defined.

Remark rem_2851 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_25 X1 -> auto___type_4 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2.
  cut (auto___type_4 X2 -> auto_knows_current X2). tauto. exact (rem_2850 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X2).
Defined.

Remark rem_2852 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_25 X1 -> auto___type_4 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2849 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2851 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2853 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_25 X1 -> auto___type_4 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2852 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current A1 A2. intros. apply trans_knows_current_crypt_1;  tauto.
 clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current A1 A2. tauto.
Defined.

Remark rem_2854 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1:term, auto___def_19 X1 -> auto___def_46 X1. (* Cut history. *)
Proof.  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. exact (rem_2791 epsilon_mknows_old_pknows_current).
Defined.

Remark rem_2855 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto___def_46 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2.
  cut (auto___def_19 X1 -> auto___def_46 X1). tauto. exact (rem_2854 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1).
Defined.

Remark rem_2856 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X2:term, auto___def_20 X2 -> auto___def_47 X2. (* Cut history. *)
Proof.  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. exact (rem_2818 epsilon_mknows_old_pknows_current).
Defined.

Remark rem_2857 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto___def_47 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2.
  cut (auto___def_20 X2 -> auto___def_47 X2). tauto. exact (rem_2856 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X2).
Defined.

Remark rem_2858 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> (auto___def_46 X1 /\ auto___def_47 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_46 X1). 2:apply (rem_2855 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2);  assumption.
  cut (auto___def_47 X2). 2:apply (rem_2857 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2859 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_19 X1 -> auto___def_20 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2858 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current A1 A2. intros. apply trans_knows_current_crypt_4;  tauto.
 clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current A1 A2. tauto.
Defined.

Remark rem_2860 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2838 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current A1 A2. intros. apply trans_knows_current_crypt_1;  tauto.
 clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current A1 A2. tauto.
Defined.

Remark rem_2861 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1:term, auto___def_30 X1 -> auto_knows_current X1. (* Use induction hypothesis. *)
Proof.
   intro H. clear H. intro H. clear H. intro Hrec. intros X1.
  cut (auto___def_30 X1 -> auto_knows_current X1). tauto. exact (Hrec X1).
Defined.

Remark rem_2862 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___type_6 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2.
  cut (auto___def_30 X1 -> auto_knows_current X1). tauto. exact (rem_2861 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1).
Defined.

Remark rem_2863 : (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> forall X1:term, auto___def_3 X1 -> auto___def_3 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2864 : (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_pknows_current. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2863 epsilon_m__type_6_pknows_current X1).
Defined.

Remark rem_2865 : (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> forall X2:term, auto___def_2 X2 -> auto___type_9 X2. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Defined.

Remark rem_2866 : (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto___type_9 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_pknows_current. intros X1 X2.
  cut (auto___def_2 X2 -> auto___type_9 X2). tauto. exact (rem_2865 epsilon_m__type_6_pknows_current X2).
Defined.

Remark rem_2867 : (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> (auto___def_3 X1 /\ auto___type_9 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_6_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2864 epsilon_m__type_6_pknows_current X1 X2);  assumption.
  cut (auto___type_9 X2). 2:apply (rem_2866 epsilon_m__type_6_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2868 : (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_2 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2867 epsilon_m__type_6_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_6_pknows_current A1 A2. intros. apply trans_knows_current_key_2;  tauto.
 clear  epsilon_m__type_6_pknows_current A1 A2. tauto.
Defined.

Remark rem_2869 : (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_pknows_current. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2863 epsilon_m__type_6_pknows_current X1).
Defined.

Remark rem_2870 : (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> forall X2:term, auto___def_5 X2 -> auto___type_9 X2. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Defined.

Remark rem_2871 : (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto___type_9 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_pknows_current. intros X1 X2.
  cut (auto___def_5 X2 -> auto___type_9 X2). tauto. exact (rem_2870 epsilon_m__type_6_pknows_current X2).
Defined.

Remark rem_2872 : (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> (auto___def_3 X1 /\ auto___type_9 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_6_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2869 epsilon_m__type_6_pknows_current X1 X2);  assumption.
  cut (auto___type_9 X2). 2:apply (rem_2871 epsilon_m__type_6_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2873 : (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_5 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2872 epsilon_m__type_6_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_6_pknows_current A1 A2. intros. apply trans_knows_current_key_2;  tauto.
 clear  epsilon_m__type_6_pknows_current A1 A2. tauto.
Defined.

Remark rem_2874 : (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_pknows_current. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2863 epsilon_m__type_6_pknows_current X1).
Defined.

Remark rem_2875 : (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> forall X2:term, auto___def_7 X2 -> auto___type_9 X2. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Defined.

Remark rem_2876 : (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto___type_9 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_pknows_current. intros X1 X2.
  cut (auto___def_7 X2 -> auto___type_9 X2). tauto. exact (rem_2875 epsilon_m__type_6_pknows_current X2).
Defined.

Remark rem_2877 : (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> (auto___def_3 X1 /\ auto___type_9 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_6_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2874 epsilon_m__type_6_pknows_current X1 X2);  assumption.
  cut (auto___type_9 X2). 2:apply (rem_2876 epsilon_m__type_6_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2878 : (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___def_7 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2877 epsilon_m__type_6_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_6_pknows_current A1 A2. intros. apply trans_knows_current_key_2;  tauto.
 clear  epsilon_m__type_6_pknows_current A1 A2. tauto.
Defined.

Remark rem_2879 : (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_6 (key X1 X2) -> auto_knows_current (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_180 X1 X2 H);  intros.
  apply (rem_2868 epsilon_m__type_6_pknows_current X1 X2);  tauto.
  apply (rem_2873 epsilon_m__type_6_pknows_current X1 X2);  tauto.
  apply (rem_2878 epsilon_m__type_6_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2880 : forall X1:term, auto___type_6 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2881 : auto___type_6 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2882 : auto___type_6 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2883 : forall X1 X2 X3:term, auto___type_6 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2884 : auto___type_6 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2885 : forall X1 X2 X3:term, auto___type_6 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2886 : forall X1 X2:term, auto___type_6 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2887 : forall X1 X2:term, auto___type_6 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2888 : auto___type_6 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2889 : forall X1 X2 X3:term, auto___type_6 (noncea_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2890 : auto___type_6 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2891 : forall X1 X2 X3 X4:term, auto___type_6 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2892 : auto___type_6 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2893 : forall X1 X2 X3 X4:term, auto___type_6 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2894 : auto___type_6 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2895 : auto___type_6 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2896 : auto___type_6 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2897 : forall X2:term, auto___type_6 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__type_6_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_2890  H).
   intro H. elim (rem_2888  H).
  intros X1 X2. intro H. elim (rem_2886 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2887 X1 X2 H).
   intro H. elim (rem_2882  H).
   intro H. elim (rem_2894  H).
  intros X1 X2;  exact (rem_2879 epsilon_m__type_6_pknows_current X1 X2).
   intro H. elim (rem_2881  H).
  intros X1 X2 X3. intro H. elim (rem_2885 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2889 X1 X2 X3 H).
  intros X1 X2 X3 X4. intro H. elim (rem_2893 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_2891 X1 X2 X3 X4 H).
   intro H. elim (rem_2896  H).
   intro H. elim (rem_2892  H).
  intros X1. intro H. elim (rem_2880 X1 H).
   intro H. elim (rem_2895  H).
  intros X1 X2 X3. intro H. elim (rem_2883 X1 X2 X3 H).
   intro H. elim (rem_2884  H).
Qed.

Remark rem_2898 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X2:term, auto___type_6 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. exact (rem_2897).
Defined.

Remark rem_2899 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___type_6 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2.
  cut (auto___type_6 X2 -> auto_knows_current X2). tauto. exact (rem_2898 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X2).
Defined.

Remark rem_2900 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___type_6 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2862 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2899 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2901 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___type_6 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2900 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current A1 A2. intros. apply trans_knows_current_crypt_1;  tauto.
 clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current A1 A2. tauto.
Defined.

Remark rem_2902 : forall X1 X2:term, auto___type_7 (crypt X1 X2) -> or_5
    (auto___def_32 X1 /\ auto___type_2 X2)
    (auto___def_25 X1 /\ auto___type_4 X2)
    (auto___def_19 X1 /\ auto___def_20 X2)
    (auto_knows_old X1 /\ auto_knows_old X2)
    (auto___def_30 X1 /\ auto___type_6 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_5_intro_1; tauto.
  intros. apply or_5_intro_2; tauto.
  intros. apply or_5_intro_3; tauto.
  intros. apply or_5_intro_4; tauto.
  intros. apply or_5_intro_5; tauto.
Qed.

Remark rem_2903 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_7 (crypt X1 X2) -> auto_knows_current (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_2902 X1 X2 H);  intros.
  apply (rem_2847 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2);  tauto.
  apply (rem_2853 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2);  tauto.
  apply (rem_2859 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2);  tauto.
  apply (rem_2860 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2);  tauto.
  apply (rem_2901 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2904 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1:term, auto___def_23 X1 -> auto___def_23 X1. (* Tautology. *)
Proof. intro H. clear H. intro H. clear H. intro H. clear H. tauto. Defined.

Remark rem_2905 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_36 X2 -> auto___def_23 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2.
  cut (auto___def_23 X1 -> auto___def_23 X1). tauto. exact (rem_2904 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1).
Defined.

Remark rem_2906 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X2:term, auto___def_36 X2 -> auto___def_36 X2. (* Tautology. *)
Proof. intro H. clear H. intro H. clear H. intro H. clear H. tauto. Defined.

Remark rem_2907 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_36 X2 -> auto___def_36 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2.
  cut (auto___def_36 X2 -> auto___def_36 X2). tauto. exact (rem_2906 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X2).
Defined.

Remark rem_2908 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_36 X2 -> (auto___def_23 X1 /\ auto___def_36 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_23 X1). 2:apply (rem_2905 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2);  assumption.
  cut (auto___def_36 X2). 2:apply (rem_2907 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2909 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_23 X1 -> auto___def_36 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2908 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current A1 A2. intros. apply trans_knows_current_key_1;  tauto.
 clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current A1 A2. tauto.
Defined.

Remark rem_2910 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1:term, auto___def_3 X1 -> auto___def_3 X1. (* Tautology. *)
Proof. intro H. clear H. intro H. clear H. intro H. clear H. tauto. Defined.

Remark rem_2911 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___type_9 X2 -> auto___def_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2.
  cut (auto___def_3 X1 -> auto___def_3 X1). tauto. exact (rem_2910 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1).
Defined.

Remark rem_2912 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X2:term, auto___type_9 X2 -> auto___type_9 X2. (* Tautology. *)
Proof. intro H. clear H. intro H. clear H. intro H. clear H. tauto. Defined.

Remark rem_2913 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___type_9 X2 -> auto___type_9 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2.
  cut (auto___type_9 X2 -> auto___type_9 X2). tauto. exact (rem_2912 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X2).
Defined.

Remark rem_2914 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___type_9 X2 -> (auto___def_3 X1 /\ auto___type_9 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_3 X1). 2:apply (rem_2911 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2);  assumption.
  cut (auto___type_9 X2). 2:apply (rem_2913 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2915 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_3 X1 -> auto___type_9 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2914 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current A1 A2. intros. apply trans_knows_current_key_2;  tauto.
 clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current A1 A2. tauto.
Defined.

Remark rem_2916 : forall X1 X2:term, auto___type_7 (key X1 X2) -> or_2
    (auto___def_23 X1 /\ auto___def_36 X2)
    (auto___def_3 X1 /\ auto___type_9 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_2917 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_7 (key X1 X2) -> auto_knows_current (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_2916 X1 X2 H);  intros.
  apply (rem_2909 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2);  tauto.
  apply (rem_2915 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2918 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> auto_knows_current bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current.  case (rem_2828 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current). clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros. apply trans_knows_current_bob_1;  tauto.
 clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. tauto.
Defined.

Remark rem_2919 : auto___type_7 bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2920 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> auto___type_7 bob -> auto_knows_current bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intro H. intros.
  elim (rem_2919 H);  intros.
  apply (rem_2918 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current);  tauto.
Defined.

Remark rem_2921 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto_agent X1 -> auto___type_3 X2 -> auto___type_2 X3 -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  tauto.
Defined.

Remark rem_2922 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto_agent X1 -> auto___type_3 X2 -> auto___type_2 X3 -> auto_knows_current (noncea_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_2921 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current A1 A2 A3. intros. apply trans_knows_current_noncea_old_1;  tauto.
 clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_2923 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto___type_7 (noncea_old X1 X2 X3) -> auto_knows_current (noncea_old X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2 X3. intro H. intros.
  elim (rem_2364 X1 X2 X3 H);  intros.
  apply (rem_2922 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2 X3);  tauto.
Defined.

Remark rem_2924 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> auto_knows_current alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current.  case (rem_2828 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current). clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros. apply trans_knows_current_alice_1;  tauto.
 clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. tauto.
Defined.

Remark rem_2925 : auto___type_7 alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2926 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> auto___type_7 alice -> auto_knows_current alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intro H. intros.
  elim (rem_2925 H);  intros.
  apply (rem_2924 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current);  tauto.
Defined.

Remark rem_2927 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> auto_knows_current server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current.  case (rem_2828 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current). clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intros. apply trans_knows_current_server_1;  tauto.
 clear  epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. tauto.
Defined.

Remark rem_2928 : auto___type_7 server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2929 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> auto___type_7 server -> auto_knows_current server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current. intro H. intros.
  elim (rem_2928 H);  intros.
  apply (rem_2927 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current);  tauto.
Defined.

Remark rem_2930 : forall X1 X2 X3:term, auto___type_7 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2931 : auto___type_7 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2932 : forall X1 X2 X3:term, auto___type_7 (noncea_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2933 : forall X1 X2 X3 X4:term, auto___type_7 (nonceb_old X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2934 : auto___type_7 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2935 : forall X1 X2 X3 X4:term, auto___type_7 (nonceb_current X1 X2 X3 X4) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2936 : auto___type_7 intruder -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2937 : auto___type_7 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2938 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1:term, auto___type_7 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__def_30_pknows_current. fix epsilon_m__type_7_pknows_current 1.
  intro X. case X.
  exact (rem_2926 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current ).
  exact (rem_2920 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current ).
  intros X1 X2;  exact (rem_2841 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2).
  intros X1 X2;  exact (rem_2903 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2).
  exact (rem_2834 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current ).
   intro H. elim (rem_2936  H).
  intros X1 X2;  exact (rem_2917 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2).
  exact (rem_2831 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current ).
  intros X1 X2 X3. intro H. elim (rem_2932 X1 X2 X3 H).
  intros X1 X2 X3;  exact (rem_2923 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1 X2 X3).
  intros X1 X2 X3 X4. intro H. elim (rem_2935 X1 X2 X3 X4 H).
  intros X1 X2 X3 X4. intro H. elim (rem_2933 X1 X2 X3 X4 H).
   intro H. elim (rem_2937  H).
   intro H. elim (rem_2934  H).
  intros X1;  exact (rem_2827 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current X1).
  exact (rem_2929 epsilon_mknows_old_pknows_current epsilon_m__type_7_pknows_current epsilon_m__def_30_pknows_current ).
  intros X1 X2 X3. intro H. elim (rem_2930 X1 X2 X3 H).
   intro H. elim (rem_2931  H).
Defined.

Remark rem_2939 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___def_30 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_7 X1 -> auto___def_31 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__def_30_pknows_current. intros X1 X2.
  cut (auto___type_7 X1 -> auto_knows_current X1). tauto. exact (rem_2938 epsilon_mknows_old_pknows_current epsilon_m__def_30_pknows_current X1).
Defined.

Remark rem_2940 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___def_31 X -> auto_knows_current X)
    -> forall X1:term, auto___def_32 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_mknows_old_pknows_current epsilon_m__def_31_pknows_current. exact (rem_2595 epsilon_mknows_old_pknows_current).
Defined.

Remark rem_2941 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> (forall X:term, auto___def_31 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___def_33 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current epsilon_m__def_31_pknows_current. intros X1 X2.
  cut (auto___def_32 X1 -> auto_knows_current X1). tauto. exact (rem_2940 epsilon_mknows_old_pknows_current epsilon_m__def_31_pknows_current X1).
Defined.

Remark rem_2942 : (forall X:term, auto___type_8 X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_8_pknows_current.  tauto.
Defined.

Remark rem_2943 : (forall X:term, auto___type_8 X -> auto_knows_current X)
    -> auto_knows_current i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_8_pknows_current.  case (rem_2942 epsilon_m__type_8_pknows_current). clear  epsilon_m__type_8_pknows_current. intros. apply trans_knows_current_i_1;  tauto.
 clear  epsilon_m__type_8_pknows_current. tauto.
Defined.

Remark rem_2944 : auto___type_8 i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2945 : (forall X:term, auto___type_8 X -> auto_knows_current X)
    -> auto___type_8 i -> auto_knows_current i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_8_pknows_current. intro H. intros.
  elim (rem_2944 H);  intros.
  apply (rem_2943 epsilon_m__type_8_pknows_current);  tauto.
Defined.

Remark rem_2946 : (forall X:term, auto___type_8 X -> auto_knows_current X)
    -> auto_knows_current bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_8_pknows_current.  case (rem_2942 epsilon_m__type_8_pknows_current). clear  epsilon_m__type_8_pknows_current. intros. apply trans_knows_current_bob_1;  tauto.
 clear  epsilon_m__type_8_pknows_current. tauto.
Defined.

Remark rem_2947 : auto___type_8 bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2948 : (forall X:term, auto___type_8 X -> auto_knows_current X)
    -> auto___type_8 bob -> auto_knows_current bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_8_pknows_current. intro H. intros.
  elim (rem_2947 H);  intros.
  apply (rem_2946 epsilon_m__type_8_pknows_current);  tauto.
Defined.

Remark rem_2949 : (forall X:term, auto___type_8 X -> auto_knows_current X)
    -> auto_knows_current alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_8_pknows_current.  case (rem_2942 epsilon_m__type_8_pknows_current). clear  epsilon_m__type_8_pknows_current. intros. apply trans_knows_current_alice_1;  tauto.
 clear  epsilon_m__type_8_pknows_current. tauto.
Defined.

Remark rem_2950 : auto___type_8 alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2951 : (forall X:term, auto___type_8 X -> auto_knows_current X)
    -> auto___type_8 alice -> auto_knows_current alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_8_pknows_current. intro H. intros.
  elim (rem_2950 H);  intros.
  apply (rem_2949 epsilon_m__type_8_pknows_current);  tauto.
Defined.

Remark rem_2952 : (forall X:term, auto___type_8 X -> auto_knows_current X)
    -> auto_knows_current server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_8_pknows_current.  case (rem_2942 epsilon_m__type_8_pknows_current). clear  epsilon_m__type_8_pknows_current. intros. apply trans_knows_current_server_1;  tauto.
 clear  epsilon_m__type_8_pknows_current. tauto.
Defined.

Remark rem_2953 : auto___type_8 server -> or_1
    True.
Pro