

% h1 example: the Needham-Schroeder symmetric key protocol.
% Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
% This file is part of h1.
%
% h1 is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2, or (at your option)
% any later version.
%
% h1 is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with h1; see the file COPYING. If not, write to
% the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

% run 'cpp -P nspriv.timed.p >nsp.p'

cnf(alice_agent,axiom,
    (agent(alice))).
cnf(bob_agent,axiom,
    (agent(bob))).
cnf(server_agent,axiom,
    (agent(server))).
cnf(intruder_agent,axiom,
    (agent(i))).
% h1 example: the Needham-Schroeder symmetric key protocol.
% Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
% This file is part of h1.
%
% h1 is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2, or (at your option)
% any later version.
%
% h1 is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with h1; see the file COPYING. If not, write to
% the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
cnf(intruder_knows_nil_old,axiom,
  (knows_old(nil))).
cnf(intruder_can_take_first_components_old,axiom,
  (~knows_old(cons(M1,M2)) | knows_old(M1))).
cnf(intruder_can_take_second_components_old,axiom,
  (~knows_old(cons(M1,M2)) | knows_old(M2))).
cnf(intruder_can_build_pairs_old,axiom,
  (~knows_old(M2) | ~knows_old(M1) | knows_old(cons(M1,M2)))).
cnf(intruder_can_encrypt_old,axiom,
  (~knows_old(K) | ~knows_old(M) | knows_old(crypt(M,K)))).
cnf(intruder_can_decrypt_if_has_private_key_old,axiom,
  (~knows_old(key(prv,K)) | ~knows_old(crypt(M,key(pub,K))) | knows_old(M))).
cnf(intruder_can_decrypt_if_has_public_key_old,axiom,
  (~knows_old(key(pub,K)) | ~knows_old(crypt(M,key(prv,K))) | knows_old(M))).
cnf(intruder_can_decrypt_if_has_symmetric_key_old,axiom,
  (~knows_old(key(sym,X)) | ~knows_old(crypt(M,key(sym,X))) | knows_old(M))).
cnf(intruder_can_compute_successors_old,axiom,
  (~knows_old(M) | knows_old(s(M)))).
cnf(intruder_can_compute_predecessors_old,axiom,
  (~knows_old(s(M)) | knows_old(M))).
%
% Ajout des clauses du protocole
%
%
cnf(alice_sends_message_1_to_server_old,axiom,
  (~agent(A) | ~agent (B)
  | knows_old(cons(A,cons(B,cons(noncea_old(A,B),nil)))))).
cnf(server_answers_A_with_encrypted_packet_old,axiom,
  (~knows_old(cons(A,cons(B,cons(Na,nil))))
    | knows_old(crypt(cons(Na,cons(B,
                  cons(key(sym,session_old(A,B,Na)),
                  cons(crypt(cons(key(sym,session_old(A,B,Na)),cons(A,nil)),
                             key(sym,cons(B,cons(server,nil)))),
                  nil)))),
               key(sym,cons(A,cons(server,nil))))))).
cnf(alice_gets_server_message_and_forwards_submessage_to_bob_old,axiom,
  (~knows_old(crypt(cons(noncea_old(A,B),cons(B,cons(Kab,cons(Msg,nil)))),
          key(sym,cons(A,cons(server,nil)))))
    | knows_old(Msg))).
cnf(agent_B_gets_forwarded_submessage_and_sends_confirmation_challenge_old,axiom,
  (~knows_old(crypt(cons(Kab,cons(A,nil)),key(sym,cons(B,cons(server,nil)))))
    | knows_old(crypt(nonceb_old(Kab,A,B),Kab)))).
cnf(alice_answers_confirmation_challenge_old,axiom,
  (~knows_old(crypt(Nb,Kab))
  | ~knows_old(crypt(cons(noncea_old(A,B),cons(B,cons(Kab,cons(Msg,nil)))),
                 key(sym,cons(A,cons(server,nil)))))
  | knows_old(crypt(s(Nb),Kab)))).
cnf(intruder_knows_all_agents_old,axiom,
  (~agent(X) | knows_old(X))).
cnf(intruder_knows_every_public_key_old,axiom,
  (knows_old(key(pub,X)))).
cnf(intruder_knows_own_private_key_old,axiom,
  (knows_old(key(prv,i)))).
cnf(define_alice_key_old,axiom,
  (~knows_old(crypt(cons(noncea_old(A,B),cons(B,cons(Kab,cons(Msg,nil)))),
          key(sym,cons(A,cons(server,nil)))))
  | alice_key_old(A,Kab))).
cnf(define_bob_key_old,axiom,
   (~knows_old(crypt(s(nonceb_old(Kab,A,B)),Kab))
   | bob_key_old(B,Kab))).
cnf(intruder_remembers,axiom,
   (~knows_old(M) | knows_current(M))).
cnf(intruder_knows_all_previous_session_keys,axiom,
  (knows_current(key(sym,session_old(A,B,Na))))).
cnf(intruder_knows_all_previous_noncea,axiom,
    (knows_current(noncea_old(A,B)))).
cnf(intruder_knows_all_previous_nonceb,axiom,
    (knows_current(nonceb_old(Kab,A,B)))).
% h1 example: the Needham-Schroeder symmetric key protocol.
% Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
% This file is part of h1.
%
% h1 is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2, or (at your option)
% any later version.
%
% h1 is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with h1; see the file COPYING. If not, write to
% the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
cnf(intruder_knows_nil_current,axiom,
  (knows_current(nil))).
cnf(intruder_can_take_first_components_current,axiom,
  (~knows_current(cons(M1,M2)) | knows_current(M1))).
cnf(intruder_can_take_second_components_current,axiom,
  (~knows_current(cons(M1,M2)) | knows_current(M2))).
cnf(intruder_can_build_pairs_current,axiom,
  (~knows_current(M2) | ~knows_current(M1) | knows_current(cons(M1,M2)))).
cnf(intruder_can_encrypt_current,axiom,
  (~knows_current(K) | ~knows_current(M) | knows_current(crypt(M,K)))).
cnf(intruder_can_decrypt_if_has_private_key_current,axiom,
  (~knows_current(key(prv,K)) | ~knows_current(crypt(M,key(pub,K))) | knows_current(M))).
cnf(intruder_can_decrypt_if_has_public_key_current,axiom,
  (~knows_current(key(pub,K)) | ~knows_current(crypt(M,key(prv,K))) | knows_current(M))).
cnf(intruder_can_decrypt_if_has_symmetric_key_current,axiom,
  (~knows_current(key(sym,X)) | ~knows_current(crypt(M,key(sym,X))) | knows_current(M))).
cnf(intruder_can_compute_successors_current,axiom,
  (~knows_current(M) | knows_current(s(M)))).
cnf(intruder_can_compute_predecessors_current,axiom,
  (~knows_current(s(M)) | knows_current(M))).
%
% Ajout des clauses du protocole
%
%
cnf(alice_sends_message_1_to_server_current,axiom,
  (~agent(A) | ~agent (B)
  | knows_current(cons(A,cons(B,cons(noncea_current(A,B),nil)))))).
cnf(server_answers_A_with_encrypted_packet_current,axiom,
  (~knows_current(cons(A,cons(B,cons(Na,nil))))
    | knows_current(crypt(cons(Na,cons(B,
                  cons(key(sym,session_current(A,B,Na)),
                  cons(crypt(cons(key(sym,session_current(A,B,Na)),cons(A,nil)),
                             key(sym,cons(B,cons(server,nil)))),
                  nil)))),
               key(sym,cons(A,cons(server,nil))))))).
cnf(alice_gets_server_message_and_forwards_submessage_to_bob_current,axiom,
  (~knows_current(crypt(cons(noncea_current(A,B),cons(B,cons(Kab,cons(Msg,nil)))),
          key(sym,cons(A,cons(server,nil)))))
    | knows_current(Msg))).
cnf(agent_B_gets_forwarded_submessage_and_sends_confirmation_challenge_current,axiom,
  (~knows_current(crypt(cons(Kab,cons(A,nil)),key(sym,cons(B,cons(server,nil)))))
    | knows_current(crypt(nonceb_current(Kab,A,B),Kab)))).
cnf(alice_answers_confirmation_challenge_current,axiom,
  (~knows_current(crypt(Nb,Kab))
  | ~knows_current(crypt(cons(noncea_current(A,B),cons(B,cons(Kab,cons(Msg,nil)))),
                 key(sym,cons(A,cons(server,nil)))))
  | knows_current(crypt(s(Nb),Kab)))).
cnf(intruder_knows_all_agents_current,axiom,
  (~agent(X) | knows_current(X))).
cnf(intruder_knows_every_public_key_current,axiom,
  (knows_current(key(pub,X)))).
cnf(intruder_knows_own_private_key_current,axiom,
  (knows_current(key(prv,i)))).
cnf(define_alice_key_current,axiom,
  (~knows_current(crypt(cons(noncea_current(A,B),cons(B,cons(Kab,cons(Msg,nil)))),
          key(sym,cons(A,cons(server,nil)))))
  | alice_key_current(A,Kab))).
cnf(define_bob_key_current,axiom,
   (~knows_current(crypt(s(nonceb_current(Kab,A,B)),Kab))
   | bob_key_current(B,Kab))).
cnf(intruder_knows_session_key_generated_by_server,axiom,
  (~knows_current(key(sym,session_current(alice,bob,Na))))).
cnf(intruder_knows_session_key_as_seen_by_alice,axiom,
  (~knows_current(Kab) | ~alice_key_current(alice,Kab))).
cnf(intruder_knows_session_key_as_seen_by_B,axiom,
  (~knows_current(Kab) | ~bob_key_current(bob,Kab))).
