(* [sigd] Signature definition. *)

Inductive term : Set :=
    alice : term
  | bob : term
  | cons : term -> term -> term
  | crypt : term -> term -> term
  | i : term
  | key : term -> term -> term
  | nil : term
  | noncea_current : term -> term -> term
  | noncea_old : term -> term -> term
  | nonceb_current : term -> term -> term -> term
  | nonceb_old : term -> term -> term -> term
  | prv : term
  | pub : term
  | s : term -> term
  | server : term
  | session_current : term -> term -> term -> term
  | session_old : term -> term -> term -> term
  | sym : term
.

(* [modd] Model definition. *)

Inductive auto___def_4 : term -> Prop :=
    trans___def_4_1 : forall X:term, auto___def_4 X
with auto___type_8 : term -> Prop :=
    trans___type_8_1 : forall X:term, auto___type_8 X
with auto___def_44 : term -> Prop :=
    trans___def_44_1 : forall X:term, auto___def_44 X
with auto_bob_key_old : term -> term -> Prop :=
    trans_bob_key_old_1 : forall X1 X2:term, auto_bob_key_old X1 X2
with auto___def_59 : term -> Prop :=
    trans___def_59_crypt_1 : forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto___def_59 (crypt X1 X2)
with auto___def_52 : term -> Prop :=
    trans___def_52_key_1 : forall X1 X2:term, auto___def_57 X1 -> auto___def_66 X2 -> auto___def_52 (key X1 X2)
with auto___def_54 : term -> Prop :=
    trans___def_54_cons_1 : forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> auto___def_54 (cons X1 X2)
with auto___def_24 : term -> Prop :=
    trans___def_24_cons_1 : forall X1 X2:term, auto___type_5 X1 -> auto___def_21 X2 -> auto___def_24 (cons X1 X2)
with auto___def_49 : term -> Prop :=
    trans___def_49_noncea_current_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___def_49 (noncea_current X1 X2)
with auto___def_16 : term -> Prop :=
    trans___def_16_key_1 : forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_16 (key X1 X2)
with auto___type_12 : term -> Prop :=
    trans___type_12_key_1 : forall X1 X2:term, auto___def_57 X1 -> auto___def_58 X2 -> auto___type_12 (key X1 X2)
  | trans___type_12_key_2 : forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___type_12 (key X1 X2)
with auto___def_12 : term -> Prop :=
    trans___def_12_cons_1 : forall X1 X2:term, auto___type_3 X1 -> auto___def_14 X2 -> auto___def_12 (cons X1 X2)
with auto___def_62 : term -> Prop :=
    trans___def_62_key_1 : forall X1 X2:term, auto___def_57 X1 -> auto___def_64 X2 -> auto___def_62 (key X1 X2)
with auto___def_57 : term -> Prop :=
    trans___def_57_sym_1 : auto___def_57 sym
with auto_bob_key_current : term -> term -> Prop :=
    trans_bob_key_current_1 : forall X1 X2:term, auto_bob_key_current X1 X2
with auto___def_63 : term -> Prop :=
    trans___def_63_cons_1 : forall X1 X2:term, auto___type_11 X1 -> auto___def_60 X2 -> auto___def_63 (cons X1 X2)
with auto_agent : term -> Prop :=
    trans_agent_bob_1 : auto_agent bob
  | trans_agent_alice_1 : auto_agent alice
  | trans_agent_i_1 : auto_agent i
  | trans_agent_server_1 : auto_agent server
with auto___type_10 : term -> Prop :=
    trans___type_10_noncea_current_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_10 (noncea_current X1 X2)
  | trans___type_10_bob_1 : auto___type_10 bob
  | trans___type_10_alice_1 : auto___type_10 alice
  | trans___type_10_cons_1 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_10 (cons X1 X2)
  | trans___type_10_s_1 : forall X1:term, auto_knows_current X1 -> auto___type_10 (s X1)
  | trans___type_10_nil_1 : auto___type_10 nil
  | trans___type_10_i_1 : auto___type_10 i
  | trans___type_10_key_1 : forall X1 X2:term, auto___def_39 X1 -> auto___def_40 X2 -> auto___type_10 (key X1 X2)
  | trans___type_10_key_2 : forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___type_10 (key X1 X2)
  | trans___type_10_key_3 : forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_10 (key X1 X2)
  | trans___type_10_nonceb_current_1 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_10 (nonceb_current X1 X2 X3)
  | trans___type_10_nonceb_current_2 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___type_11 X2 -> auto___type_10 X3 -> auto___type_10 (nonceb_current X1 X2 X3)
  | trans___type_10_nonceb_old_1 : forall X1 X2 X3:term, auto___type_10 (nonceb_old X1 X2 X3)
  | trans___type_10_crypt_1 : forall X1 X2:term, auto___def_71 X1 -> auto___type_13 X2 -> auto___type_10 (crypt X1 X2)
  | trans___type_10_crypt_2 : forall X1 X2:term, auto___def_69 X1 -> auto___type_12 X2 -> auto___type_10 (crypt X1 X2)
  | trans___type_10_crypt_3 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___type_10 (crypt X1 X2)
  | trans___type_10_crypt_4 : forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto___type_10 (crypt X1 X2)
  | trans___type_10_crypt_5 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___type_10 (crypt X1 X2)
  | trans___type_10_crypt_6 : forall X1 X2:term, auto___def_51 X1 -> auto___def_52 X2 -> auto___type_10 (crypt X1 X2)
  | trans___type_10_crypt_7 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_10 (crypt X1 X2)
  | trans___type_10_noncea_old_1 : forall X1 X2:term, auto___type_10 (noncea_old X1 X2)
  | trans___type_10_server_1 : auto___type_10 server
with auto_alice_key_old : term -> term -> Prop :=
    trans_alice_key_old_1 : forall X1 X2:term, auto_alice_key_old X1 X2
with auto___def_47 : term -> Prop :=
    trans___def_47_cons_1 : forall X1 X2:term, auto___type_2 X1 -> auto___def_48 X2 -> auto___def_47 (cons X1 X2)
with auto___type_9 : term -> Prop :=
    trans___type_9_noncea_current_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_9 (noncea_current X1 X2)
  | trans___type_9_bob_1 : auto___type_9 bob
  | trans___type_9_alice_1 : auto___type_9 alice
  | trans___type_9_cons_1 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_9 (cons X1 X2)
  | trans___type_9_s_1 : forall X1:term, auto_knows_current X1 -> auto___type_9 (s X1)
  | trans___type_9_nil_1 : auto___type_9 nil
  | trans___type_9_i_1 : auto___type_9 i
  | trans___type_9_key_1 : forall X1 X2:term, auto___def_39 X1 -> auto___def_40 X2 -> auto___type_9 (key X1 X2)
  | trans___type_9_key_2 : forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___type_9 (key X1 X2)
  | trans___type_9_key_3 : forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_9 (key X1 X2)
  | trans___type_9_nonceb_current_1 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_9 (nonceb_current X1 X2 X3)
  | trans___type_9_nonceb_current_2 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___type_11 X2 -> auto___type_10 X3 -> auto___type_9 (nonceb_current X1 X2 X3)
  | trans___type_9_nonceb_old_1 : forall X1 X2 X3:term, auto___type_9 (nonceb_old X1 X2 X3)
  | trans___type_9_crypt_1 : forall X1 X2:term, auto___def_71 X1 -> auto___type_13 X2 -> auto___type_9 (crypt X1 X2)
  | trans___type_9_crypt_2 : forall X1 X2:term, auto___def_69 X1 -> auto___type_12 X2 -> auto___type_9 (crypt X1 X2)
  | trans___type_9_crypt_3 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___type_9 (crypt X1 X2)
  | trans___type_9_crypt_4 : forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto___type_9 (crypt X1 X2)
  | trans___type_9_crypt_5 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___type_9 (crypt X1 X2)
  | trans___type_9_crypt_6 : forall X1 X2:term, auto___def_51 X1 -> auto___def_52 X2 -> auto___type_9 (crypt X1 X2)
  | trans___type_9_crypt_7 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_9 (crypt X1 X2)
  | trans___type_9_noncea_old_1 : forall X1 X2:term, auto___type_9 (noncea_old X1 X2)
  | trans___type_9_server_1 : auto___type_9 server
with auto_knows_old : term -> Prop :=
    trans_knows_old_bob_1 : auto_knows_old bob
  | trans_knows_old_alice_1 : auto_knows_old alice
  | trans_knows_old_cons_1 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old (cons X1 X2)
  | trans_knows_old_s_1 : forall X1:term, auto_knows_old X1 -> auto_knows_old (s X1)
  | trans_knows_old_nil_1 : auto_knows_old nil
  | trans_knows_old_i_1 : auto_knows_old i
  | trans_knows_old_key_1 : forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto_knows_old (key X1 X2)
  | trans_knows_old_key_2 : forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto_knows_old (key X1 X2)
  | trans_knows_old_crypt_1 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_crypt_2 : forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_crypt_3 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_crypt_4 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_crypt_5 : forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_noncea_old_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_knows_old (noncea_old X1 X2)
  | trans_knows_old_server_1 : auto_knows_old server
with auto___def_25 : term -> Prop :=
    trans___def_25_cons_1 : forall X1 X2:term, auto___type_4 X1 -> auto___def_26 X2 -> auto___def_25 (cons X1 X2)
with auto___def_11 : term -> term -> term -> Prop :=
    trans___def_11_1 : forall X1 X2 X3:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_11 X1 X2 X3
with auto___def_51 : term -> Prop :=
    trans___def_51_cons_1 : forall X1 X2:term, auto___type_9 X1 -> auto___def_53 X2 -> auto___def_51 (cons X1 X2)
with auto___type_11 : term -> Prop :=
    trans___type_11_noncea_current_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_11 (noncea_current X1 X2)
  | trans___type_11_bob_1 : auto___type_11 bob
  | trans___type_11_alice_1 : auto___type_11 alice
  | trans___type_11_cons_1 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_11 (cons X1 X2)
  | trans___type_11_s_1 : forall X1:term, auto_knows_current X1 -> auto___type_11 (s X1)
  | trans___type_11_nil_1 : auto___type_11 nil
  | trans___type_11_i_1 : auto___type_11 i
  | trans___type_11_key_1 : forall X1 X2:term, auto___def_39 X1 -> auto___def_40 X2 -> auto___type_11 (key X1 X2)
  | trans___type_11_key_2 : forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___type_11 (key X1 X2)
  | trans___type_11_key_3 : forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_11 (key X1 X2)
  | trans___type_11_nonceb_current_1 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_11 (nonceb_current X1 X2 X3)
  | trans___type_11_nonceb_current_2 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___type_11 X2 -> auto___type_10 X3 -> auto___type_11 (nonceb_current X1 X2 X3)
  | trans___type_11_nonceb_old_1 : forall X1 X2 X3:term, auto___type_11 (nonceb_old X1 X2 X3)
  | trans___type_11_crypt_1 : forall X1 X2:term, auto___def_71 X1 -> auto___type_13 X2 -> auto___type_11 (crypt X1 X2)
  | trans___type_11_crypt_2 : forall X1 X2:term, auto___def_69 X1 -> auto___type_12 X2 -> auto___type_11 (crypt X1 X2)
  | trans___type_11_crypt_3 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___type_11 (crypt X1 X2)
  | trans___type_11_crypt_4 : forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto___type_11 (crypt X1 X2)
  | trans___type_11_crypt_5 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___type_11 (crypt X1 X2)
  | trans___type_11_crypt_6 : forall X1 X2:term, auto___def_51 X1 -> auto___def_52 X2 -> auto___type_11 (crypt X1 X2)
  | trans___type_11_crypt_7 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_11 (crypt X1 X2)
  | trans___type_11_noncea_old_1 : forall X1 X2:term, auto___type_11 (noncea_old X1 X2)
  | trans___type_11_server_1 : auto___type_11 server
with auto___def_65 : term -> Prop :=
    trans___def_65_cons_1 : forall X1 X2:term, auto___def_27 X1 -> auto___def_28 X2 -> auto___def_65 (cons X1 X2)
with auto___def_58 : term -> Prop :=
    trans___def_58_session_current_1 : forall X1 X2 X3:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_58 (session_current X1 X2 X3)
with auto___def_56 : term -> Prop :=
    trans___def_56_cons_1 : forall X1 X2:term, auto___def_59 X1 -> auto___def_60 X2 -> auto___def_56 (cons X1 X2)
with auto___type_3 : term -> Prop :=
    trans___type_3_bob_1 : auto___type_3 bob
  | trans___type_3_alice_1 : auto___type_3 alice
  | trans___type_3_cons_1 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_3 (cons X1 X2)
  | trans___type_3_s_1 : forall X1:term, auto_knows_old X1 -> auto___type_3 (s X1)
  | trans___type_3_nil_1 : auto___type_3 nil
  | trans___type_3_i_1 : auto___type_3 i
  | trans___type_3_key_1 : forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___type_3 (key X1 X2)
  | trans___type_3_key_2 : forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_3 (key X1 X2)
  | trans___type_3_crypt_1 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___type_3 (crypt X1 X2)
  | trans___type_3_crypt_2 : forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> auto___type_3 (crypt X1 X2)
  | trans___type_3_crypt_3 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___type_3 (crypt X1 X2)
  | trans___type_3_crypt_4 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_3 (crypt X1 X2)
  | trans___type_3_crypt_5 : forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> auto___type_3 (crypt X1 X2)
  | trans___type_3_noncea_old_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_3 (noncea_old X1 X2)
  | trans___type_3_server_1 : auto___type_3 server
with auto___type_4 : term -> Prop :=
    trans___type_4_bob_1 : auto___type_4 bob
  | trans___type_4_alice_1 : auto___type_4 alice
  | trans___type_4_cons_1 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_4 (cons X1 X2)
  | trans___type_4_s_1 : forall X1:term, auto_knows_old X1 -> auto___type_4 (s X1)
  | trans___type_4_nil_1 : auto___type_4 nil
  | trans___type_4_i_1 : auto___type_4 i
  | trans___type_4_key_1 : forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___type_4 (key X1 X2)
  | trans___type_4_key_2 : forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_4 (key X1 X2)
  | trans___type_4_crypt_1 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___type_4 (crypt X1 X2)
  | trans___type_4_crypt_2 : forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> auto___type_4 (crypt X1 X2)
  | trans___type_4_crypt_3 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___type_4 (crypt X1 X2)
  | trans___type_4_crypt_4 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_4 (crypt X1 X2)
  | trans___type_4_crypt_5 : forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> auto___type_4 (crypt X1 X2)
  | trans___type_4_noncea_old_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_4 (noncea_old X1 X2)
  | trans___type_4_server_1 : auto___type_4 server
with auto___def_61 : term -> Prop :=
    trans___def_61_cons_1 : forall X1 X2:term, auto___def_55 X1 -> auto___def_63 X2 -> auto___def_61 (cons X1 X2)
with auto___def_22 : term -> Prop :=
    trans___def_22_cons_1 : forall X1 X2:term, auto___def_16 X1 -> auto___def_24 X2 -> auto___def_22 (cons X1 X2)
with auto___def_60 : term -> Prop :=
    trans___def_60_nil_1 : auto___def_60 nil
with auto___def_48 : term -> Prop :=
    trans___def_48_cons_1 : forall X1 X2:term, auto___def_49 X1 -> auto___def_10 X2 -> auto___def_48 (cons X1 X2)
with auto___def_17 : term -> Prop :=
    trans___def_17_cons_1 : forall X1 X2:term, auto___def_20 X1 -> auto___def_21 X2 -> auto___def_17 (cons X1 X2)
with auto___def_15 : term -> Prop :=
    trans___def_15_cons_1 : forall X1 X2:term, auto___def_16 X1 -> auto___def_17 X2 -> auto___def_15 (cons X1 X2)
with auto_knows_current : term -> Prop :=
    trans_knows_current_noncea_current_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_knows_current (noncea_current X1 X2)
  | trans_knows_current_bob_1 : auto_knows_current bob
  | trans_knows_current_alice_1 : auto_knows_current alice
  | trans_knows_current_cons_1 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current (cons X1 X2)
  | trans_knows_current_s_1 : forall X1:term, auto_knows_current X1 -> auto_knows_current (s X1)
  | trans_knows_current_nil_1 : auto_knows_current nil
  | trans_knows_current_i_1 : auto_knows_current i
  | trans_knows_current_key_1 : forall X1 X2:term, auto___def_39 X1 -> auto___def_40 X2 -> auto_knows_current (key X1 X2)
  | trans_knows_current_key_2 : forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto_knows_current (key X1 X2)
  | trans_knows_current_key_3 : forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto_knows_current (key X1 X2)
  | trans_knows_current_nonceb_current_1 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_current_2 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___type_11 X2 -> auto___type_10 X3 -> auto_knows_current (nonceb_current X1 X2 X3)
  | trans_knows_current_nonceb_old_1 : forall X1 X2 X3:term, auto_knows_current (nonceb_old X1 X2 X3)
  | trans_knows_current_crypt_1 : forall X1 X2:term, auto___def_71 X1 -> auto___type_13 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_2 : forall X1 X2:term, auto___def_69 X1 -> auto___type_12 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_3 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_4 : forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_5 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_6 : forall X1 X2:term, auto___def_51 X1 -> auto___def_52 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_7 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_noncea_old_1 : forall X1 X2:term, auto_knows_current (noncea_old X1 X2)
  | trans_knows_current_server_1 : auto_knows_current server
with auto___def_23 : term -> Prop :=
    trans___def_23_key_1 : forall X1 X2:term, auto___def_18 X1 -> auto___def_25 X2 -> auto___def_23 (key X1 X2)
with auto___def_26 : term -> Prop :=
    trans___def_26_cons_1 : forall X1 X2:term, auto___def_27 X1 -> auto___def_28 X2 -> auto___def_26 (cons X1 X2)
with auto___def_64 : term -> Prop :=
    trans___def_64_cons_1 : forall X1 X2:term, auto___type_10 X1 -> auto___def_65 X2 -> auto___def_64 (cons X1 X2)
with auto___def_19 : term -> Prop :=
    trans___def_19_session_old_1 : forall X1 X2 X3:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_19 (session_old X1 X2 X3)
with auto_alice_key_current : term -> term -> Prop :=
    trans_alice_key_current_1 : forall X1 X2:term, auto_agent X1 -> auto___type_11 X1 -> auto___def_55 X2 -> auto_alice_key_current X1 X2
with auto___def_53 : term -> Prop :=
    trans___def_53_cons_1 : forall X1 X2:term, auto___type_10 X1 -> auto___def_54 X2 -> auto___def_53 (cons X1 X2)
with auto___def_21 : term -> Prop :=
    trans___def_21_nil_1 : auto___def_21 nil
with auto___def_14 : term -> Prop :=
    trans___def_14_cons_1 : forall X1 X2:term, auto___type_4 X1 -> auto___def_15 X2 -> auto___def_14 (cons X1 X2)
with auto___def_13 : term -> Prop :=
    trans___def_13_key_1 : forall X1 X2:term, auto___def_18 X1 -> auto___def_29 X2 -> auto___def_13 (key X1 X2)
with auto___def_45 : term -> term -> Prop :=
    trans___def_45_1 : forall X1 X2:term, auto___def_22 X1 -> auto___def_25 X2 -> auto___def_45 X1 X2
  | trans___def_45_2 : forall X1 X2:term, auto___def_51 X1 -> auto___def_66 X2 -> auto___def_45 X1 X2
  | trans___def_45_3 : forall X1 X2:term, auto___def_12 X1 -> auto___def_29 X2 -> auto___def_45 X1 X2
  | trans___def_45_4 : forall X1 X2:term, auto___def_69 X1 -> auto___def_58 X2 -> auto___def_45 X1 X2
  | trans___def_45_5 : forall X1 X2:term, auto_knows_current X1 -> auto___def_40 X2 -> auto___def_45 X1 X2
  | trans___def_45_6 : forall X1 X2:term, auto___def_71 X1 -> auto___def_58 X2 -> auto___def_45 X1 X2
  | trans___def_45_7 : forall X1 X2:term, auto___def_61 X1 -> auto___def_64 X2 -> auto___def_45 X1 X2
with auto___type_5 : term -> Prop :=
    trans___type_5_bob_1 : auto___type_5 bob
  | trans___type_5_alice_1 : auto___type_5 alice
  | trans___type_5_cons_1 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_5 (cons X1 X2)
  | trans___type_5_s_1 : forall X1:term, auto_knows_old X1 -> auto___type_5 (s X1)
  | trans___type_5_nil_1 : auto___type_5 nil
  | trans___type_5_i_1 : auto___type_5 i
  | trans___type_5_key_1 : forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___type_5 (key X1 X2)
  | trans___type_5_key_2 : forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_5 (key X1 X2)
  | trans___type_5_crypt_1 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___type_5 (crypt X1 X2)
  | trans___type_5_crypt_2 : forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> auto___type_5 (crypt X1 X2)
  | trans___type_5_crypt_3 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___type_5 (crypt X1 X2)
  | trans___type_5_crypt_4 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_5 (crypt X1 X2)
  | trans___type_5_crypt_5 : forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> auto___type_5 (crypt X1 X2)
  | trans___type_5_noncea_old_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_5 (noncea_old X1 X2)
  | trans___type_5_server_1 : auto___type_5 server
with auto___def_18 : term -> Prop :=
    trans___def_18_sym_1 : auto___def_18 sym
with auto___def_41 : term -> term -> Prop :=
    trans___def_41_1 : forall X1 X2:term, auto___type_8 X1 -> auto_knows_current X2 -> auto___def_41 X1 X2
with auto___def_55 : term -> Prop :=
    trans___def_55_key_1 : forall X1 X2:term, auto___def_57 X1 -> auto___def_58 X2 -> auto___def_55 (key X1 X2)
with auto___def_50 : term -> term -> term -> Prop :=
    trans___def_50_1 : forall X1 X2 X3:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_50 X1 X2 X3
with auto___def_20 : term -> Prop :=
    trans___def_20_crypt_1 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_20 (crypt X1 X2)
with auto___def_27 : term -> Prop :=
    trans___def_27_server_1 : auto___def_27 server
with auto___def_8 : term -> Prop :=
    trans___def_8_cons_1 : forall X1 X2:term, auto___def_9 X1 -> auto___def_10 X2 -> auto___def_8 (cons X1 X2)
with auto___def_69 : term -> Prop :=
    trans___def_69_nonceb_current_1 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___def_69 (nonceb_current X1 X2 X3)
  | trans___def_69_nonceb_current_2 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___type_11 X2 -> auto___type_10 X3 -> auto___def_69 (nonceb_current X1 X2 X3)
with auto___def_36 : term -> Prop :=
    trans___def_36_prv_1 : auto___def_36 prv
with auto___def_32 : term -> Prop :=
    trans___def_32_nonceb_old_1 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___def_32 (nonceb_old X1 X2 X3)
with auto___def_43 : term -> term -> Prop :=
    trans___def_43_1 : forall X1 X2:term, auto___def_37 X1 -> auto_knows_current X2 -> auto___def_43 X1 X2
with auto___def_70 : term -> term -> Prop :=
    trans___def_70_1 : forall X1 X2:term, auto___def_13 X1 -> auto___def_55 X1 -> auto___def_12 X2 -> auto___def_70 X1 X2
  | trans___def_70_2 : forall X1 X2:term, auto_knows_current X1 -> auto___def_55 X1 -> auto_knows_current X2 -> auto___def_70 X1 X2
  | trans___def_70_3 : forall X1 X2:term, auto___type_12 X1 -> auto___def_55 X1 -> auto___def_69 X2 -> auto___def_70 X1 X2
  | trans___def_70_4 : forall X1 X2:term, auto___def_23 X1 -> auto___def_55 X1 -> auto___def_22 X2 -> auto___def_70 X1 X2
  | trans___def_70_5 : forall X1 X2:term, auto___def_55 X1 -> auto___type_13 X1 -> auto___def_71 X2 -> auto___def_70 X1 X2
  | trans___def_70_6 : forall X1 X2:term, auto___def_62 X1 -> auto___def_55 X1 -> auto___def_61 X2 -> auto___def_70 X1 X2
  | trans___def_70_7 : forall X1 X2:term, auto___def_52 X1 -> auto___def_55 X1 -> auto___def_51 X2 -> auto___def_70 X1 X2
with auto___def_40 : term -> Prop :=
    trans___def_40_session_old_1 : forall X1 X2 X3:term, auto___def_40 (session_old X1 X2 X3)
with auto___def_46 : term -> Prop :=
    trans___def_46_session_old_1 : forall X1 X2 X3:term, auto___def_46 (session_old X1 X2 X3)
with auto___def_3 : term -> term -> Prop :=
    trans___def_3_1 : forall X1 X2:term, auto___def_37 X1 -> auto_knows_old X2 -> auto___def_3 X1 X2
with auto___def_28 : term -> Prop :=
    trans___def_28_nil_1 : auto___def_28 nil
with auto___type_2 : term -> Prop :=
    trans___type_2_bob_1 : auto___type_2 bob
  | trans___type_2_alice_1 : auto___type_2 alice
  | trans___type_2_i_1 : auto___type_2 i
  | trans___type_2_server_1 : auto___type_2 server
with auto___def_35 : term -> Prop :=
    trans___def_35_pub_1 : auto___def_35 pub
with auto___def_67 : term -> term -> term -> term -> Prop :=
    trans___def_67_1 : forall X1 X2 X3 X4:term, auto_agent X1 -> auto___type_11 X1 -> auto_agent X2 -> auto___type_10 X2 -> auto___def_55 X3 -> auto___def_59 X4 -> auto___def_67 X1 X2 X3 X4
with auto___type_1 : term -> Prop :=
    trans___type_1_bob_1 : auto___type_1 bob
  | trans___type_1_alice_1 : auto___type_1 alice
  | trans___type_1_i_1 : auto___type_1 i
  | trans___type_1_server_1 : auto___type_1 server
with auto___def_9 : term -> Prop :=
    trans___def_9_noncea_old_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___def_9 (noncea_old X1 X2)
with auto___def_2 : term -> Prop :=
    trans___def_2_i_1 : auto___def_2 i
with auto___def_66 : term -> Prop :=
    trans___def_66_cons_1 : forall X1 X2:term, auto___type_11 X1 -> auto___def_65 X2 -> auto___def_66 (cons X1 X2)
with auto___def_38 : term -> term -> term -> Prop :=
    trans___def_38_1 : forall X1 X2 X3:term, auto___def_38 X1 X2 X3
with auto___def_72 : term -> term -> term -> Prop :=
    trans___def_72_1 : forall X1 X2 X3:term, auto___def_72 X1 X2 X3
with auto___def_37 : term -> Prop :=
    trans___def_37_i_1 : auto___def_37 i
with auto___def_68 : term -> term -> term -> Prop :=
    trans___def_68_1 : forall X1 X2 X3:term, auto___type_11 X1 -> auto___type_10 X2 -> auto___def_55 X3 -> auto___def_68 X1 X2 X3
  | trans___def_68_2 : forall X1 X2 X3:term, auto___type_5 X1 -> auto___type_4 X2 -> auto___def_16 X3 -> auto___def_68 X1 X2 X3
with auto___def_1 : term -> term -> Prop :=
    trans___def_1_1 : forall X1 X2:term, auto___type_8 X1 -> auto_knows_old X2 -> auto___def_1 X1 X2
with auto___def_42 : term -> Prop :=
    trans___def_42_i_1 : auto___def_42 i
with auto___def_7 : term -> Prop :=
    trans___def_7_cons_1 : forall X1 X2:term, auto___type_2 X1 -> auto___def_8 X2 -> auto___def_7 (cons X1 X2)
with auto___def_31 : term -> term -> term -> Prop :=
    trans___def_31_1 : forall X1 X2 X3:term, auto___type_5 X1 -> auto___type_4 X2 -> auto___def_16 X3 -> auto___def_31 X1 X2 X3
with auto___type_13 : term -> Prop :=
    trans___type_13_key_1 : forall X1 X2:term, auto___def_57 X1 -> auto___def_58 X2 -> auto___type_13 (key X1 X2)
with auto___type_7 : term -> Prop :=
    trans___type_7_key_1 : forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___type_7 (key X1 X2)
with auto___type_6 : term -> Prop :=
    trans___type_6_key_1 : forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___type_6 (key X1 X2)
with auto___def_30 : term -> term -> term -> term -> Prop :=
    trans___def_30_1 : forall X1 X2 X3 X4:term, auto_agent X1 -> auto___type_5 X1 -> auto_agent X2 -> auto___type_4 X2 -> auto___def_16 X3 -> auto___def_20 X4 -> auto___def_30 X1 X2 X3 X4
with auto___def_34 : term -> Prop :=
    trans___def_34_s_1 : forall X1:term, auto___def_32 X1 -> auto___def_34 (s X1)
  | trans___def_34_s_2 : forall X1:term, auto___def_34 X1 -> auto___def_34 (s X1)
with auto___def_5 : term -> term -> Prop :=
    trans___def_5_1 : forall X1 X2:term, auto___def_22 X1 -> auto___def_25 X2 -> auto___def_5 X1 X2
  | trans___def_5_2 : forall X1 X2:term, auto___def_34 X1 -> auto___def_19 X2 -> auto___def_5 X1 X2
  | trans___def_5_3 : forall X1 X2:term, auto___def_12 X1 -> auto___def_29 X2 -> auto___def_5 X1 X2
  | trans___def_5_4 : forall X1 X2:term, auto___def_32 X1 -> auto___def_19 X2 -> auto___def_5 X1 X2
with auto___def_71 : term -> Prop :=
    trans___def_71_s_1 : forall X1:term, auto___def_71 X1 -> auto___def_71 (s X1)
  | trans___def_71_s_2 : forall X1:term, auto___def_69 X1 -> auto___def_71 (s X1)
with auto___def_29 : term -> Prop :=
    trans___def_29_cons_1 : forall X1 X2:term, auto___type_5 X1 -> auto___def_26 X2 -> auto___def_29 (cons X1 X2)
with auto___def_33 : term -> term -> Prop :=
    trans___def_33_1 : forall X1 X2:term, auto___def_16 X1 -> auto___type_7 X1 -> auto___def_34 X2 -> auto___def_33 X1 X2
  | trans___def_33_2 : forall X1 X2:term, auto___def_16 X1 -> auto_knows_old X1 -> auto_knows_old X2 -> auto___def_33 X1 X2
  | trans___def_33_3 : forall X1 X2:term, auto___def_16 X1 -> auto___def_23 X1 -> auto___def_22 X2 -> auto___def_33 X1 X2
  | trans___def_33_4 : forall X1 X2:term, auto___def_16 X1 -> auto___def_13 X1 -> auto___def_12 X2 -> auto___def_33 X1 X2
  | trans___def_33_5 : forall X1 X2:term, auto___def_16 X1 -> auto___type_6 X1 -> auto___def_32 X2 -> auto___def_33 X1 X2
with auto___def_10 : term -> Prop :=
    trans___def_10_nil_1 : auto___def_10 nil
with auto___def_39 : term -> Prop :=
    trans___def_39_sym_1 : auto___def_39 sym
with auto___query__intruder_knows_session_key_generated_by_server : Prop :=
with auto___query__intruder_knows_session_key_as_seen_by_alice : Prop :=
with auto___def_6 : term -> Prop :=
.

(* [defp] Proofs that all definitions hold. *)


Remark rem_1 : (forall X:term, auto___def_16 X -> auto___type_7 X)
    -> forall X1:term, auto___def_18 X1 -> auto___def_18 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2 : (forall X:term, auto___def_16 X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_18 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_16_p__type_7. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_18 X1). tauto. exact (rem_1 epsilon_m__def_16_p__type_7 X1).
Defined.

Remark rem_3 : (forall X:term, auto___def_16 X -> auto___type_7 X)
    -> forall X2:term, auto___def_19 X2 -> auto___def_19 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_4 : (forall X:term, auto___def_16 X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_19 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_16_p__type_7. intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_19 X2). tauto. exact (rem_3 epsilon_m__def_16_p__type_7 X2).
Defined.

Remark rem_5 : (forall X:term, auto___def_16 X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> (auto___def_18 X1 /\ auto___def_19 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_16_p__type_7. intros X1 X2. intros A1 A2.
  cut (auto___def_18 X1). 2:apply (rem_2 epsilon_m__def_16_p__type_7 X1 X2);  assumption.
  cut (auto___def_19 X2). 2:apply (rem_4 epsilon_m__def_16_p__type_7 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_6 : (forall X:term, auto___def_16 X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___type_7 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_16_p__type_7. intros X1 X2. intros A1 A2.
  case (rem_5 epsilon_m__def_16_p__type_7 X1 X2 A1 A2). clear  epsilon_m__def_16_p__type_7 A1 A2. intros. apply trans___type_7_key_1;  tauto.
 clear  epsilon_m__def_16_p__type_7 A1 A2. tauto.
Defined.

Inductive or_1(H1:Prop) : Prop :=
    or_1_intro_1 : H1 -> (or_1 H1)
.

Remark rem_7 : forall X1 X2:term, auto___def_16 (key X1 X2) -> or_1
    (auto___def_18 X1 /\ auto___def_19 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_8 : (forall X:term, auto___def_16 X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_16 (key X1 X2) -> auto___type_7 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_16_p__type_7. intros X1 X2. intro H. intros.
  elim (rem_7 X1 X2 H);  intros.
  apply (rem_6 epsilon_m__def_16_p__type_7 X1 X2);  tauto.
Defined.

Inductive or_0 : Prop :=
.

Remark rem_9 : forall X1 X2:term, auto___def_16 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_10 : auto___def_16 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_11 : forall X1 X2 X3:term, auto___def_16 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_12 : auto___def_16 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_13 : forall X1 X2:term, auto___def_16 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_14 : forall X1:term, auto___def_16 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_15 : auto___def_16 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_16 : auto___def_16 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_17 : forall X1 X2 X3:term, auto___def_16 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_18 : forall X1 X2 X3:term, auto___def_16 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_19 : forall X1 X2:term, auto___def_16 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_20 : forall X1 X2 X3:term, auto___def_16 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_21 : forall X1 X2:term, auto___def_16 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_22 : auto___def_16 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_23 : auto___def_16 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_24 : auto___def_16 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_25 : auto___def_16 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_26 : forall X1:term, auto___def_16 X1 -> auto___type_7 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_16_p__type_7 1.
  intro X. case X.
   intro H. elim (rem_12  H).
   intro H. elim (rem_10  H).
  intros X1 X2. intro H. elim (rem_13 X1 X2 H).
  intros X1 X2. intro H. elim (rem_19 X1 X2 H).
   intro H. elim (rem_16  H).
  intros X1 X2;  exact (rem_8 epsilon_m__def_16_p__type_7 X1 X2).
   intro H. elim (rem_15  H).
  intros X1 X2. intro H. elim (rem_9 X1 X2 H).
  intros X1 X2. intro H. elim (rem_21 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_17 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_18 X1 X2 X3 H).
   intro H. elim (rem_24  H).
   intro H. elim (rem_22  H).
  intros X1. intro H. elim (rem_14 X1 H).
   intro H. elim (rem_23  H).
  intros X1 X2 X3. intro H. elim (rem_11 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_20 X1 X2 X3 H).
   intro H. elim (rem_25  H).
Qed.

Remark rem_27 : forall X1 X2:term, auto___def_16 X1 -> auto___def_34 X2 -> auto___type_7 X1 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_16 X1 -> auto___type_7 X1). tauto. exact (rem_26 X1).
Qed.

Remark rem_28 : forall X1 X2:term, auto___def_16 X1 -> auto___type_7 X1 -> auto___def_34 X2 -> auto___type_7 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_16 X1 -> auto___def_34 X2 -> auto___type_7 X1 -> auto___type_7 X1). tauto. exact (rem_27 X1 X2).
Qed.

Remark rem_29 : forall X1 X2:term, auto___def_16 X1 -> auto_knows_old X2 -> auto_knows_old X1 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_16 X1 -> auto___type_7 X1). tauto. exact (rem_26 X1).
Qed.

Remark rem_30 : forall X1 X2:term, auto___def_16 X1 -> auto_knows_old X1 -> auto_knows_old X2 -> auto___type_7 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_16 X1 -> auto_knows_old X2 -> auto_knows_old X1 -> auto___type_7 X1). tauto. exact (rem_29 X1 X2).
Qed.

Remark rem_31 : forall X1 X2:term, auto___def_16 X1 -> auto___def_22 X2 -> auto___def_23 X1 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_16 X1 -> auto___type_7 X1). tauto. exact (rem_26 X1).
Qed.

Remark rem_32 : forall X1 X2:term, auto___def_16 X1 -> auto___def_23 X1 -> auto___def_22 X2 -> auto___type_7 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_16 X1 -> auto___def_22 X2 -> auto___def_23 X1 -> auto___type_7 X1). tauto. exact (rem_31 X1 X2).
Qed.

Remark rem_33 : forall X1 X2:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_16 X1 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_16 X1 -> auto___type_7 X1). tauto. exact (rem_26 X1).
Qed.

Remark rem_34 : forall X1 X2:term, auto___def_16 X1 -> auto___def_13 X1 -> auto___def_12 X2 -> auto___type_7 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_16 X1 -> auto___type_7 X1). tauto. exact (rem_33 X1 X2).
Qed.

Remark rem_35 : forall X1 X2:term, auto___def_16 X1 -> auto___def_32 X2 -> auto___type_6 X1 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_16 X1 -> auto___type_7 X1). tauto. exact (rem_26 X1).
Qed.

Remark rem_36 : forall X1 X2:term, auto___def_16 X1 -> auto___type_6 X1 -> auto___def_32 X2 -> auto___type_7 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_16 X1 -> auto___def_32 X2 -> auto___type_6 X1 -> auto___type_7 X1). tauto. exact (rem_35 X1 X2).
Qed.

Inductive or_5(H1 H2 H3 H4 H5:Prop) : Prop :=
    or_5_intro_1 : H1 -> (or_5 H1 H2 H3 H4 H5)
  | or_5_intro_2 : H2 -> (or_5 H1 H2 H3 H4 H5)
  | or_5_intro_3 : H3 -> (or_5 H1 H2 H3 H4 H5)
  | or_5_intro_4 : H4 -> (or_5 H1 H2 H3 H4 H5)
  | or_5_intro_5 : H5 -> (or_5 H1 H2 H3 H4 H5)
.

Remark rem_37 : forall X1 X2:term, auto___def_33 X1 X2 -> or_5
    (auto___def_16 X1 /\ auto___type_7 X1 /\ auto___def_34 X2)
    (auto___def_16 X1 /\ auto_knows_old X1 /\ auto_knows_old X2)
    (auto___def_16 X1 /\ auto___def_23 X1 /\ auto___def_22 X2)
    (auto___def_16 X1 /\ auto___def_13 X1 /\ auto___def_12 X2)
    (auto___def_16 X1 /\ auto___type_6 X1 /\ auto___def_32 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_5_intro_1; tauto.
  intros. apply or_5_intro_2; tauto.
  intros. apply or_5_intro_3; tauto.
  intros. apply or_5_intro_4; tauto.
  intros. apply or_5_intro_5; tauto.
Qed.

Remark rem_38 : forall X1 X2:term, auto___def_33 X1 X2 -> auto___type_7 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_37 X1 X2 H);  intros.
  apply (rem_28 X1 X2);  tauto.
  apply (rem_30 X1 X2);  tauto.
  apply (rem_32 X1 X2);  tauto.
  apply (rem_34 X1 X2);  tauto.
  apply (rem_36 X1 X2);  tauto.
Qed.

Remark rem_39 : forall X1:term, auto___def_18 X1 -> auto___def_18 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_40 : forall X1 X2:term, auto___def_18 X1 -> auto___def_29 X2 -> auto___def_18 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_18 X1). tauto. exact (rem_39 X1).
Qed.

Remark rem_41 : forall X2:term, auto___def_29 X2 -> auto___def_29 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_42 : forall X1 X2:term, auto___def_18 X1 -> auto___def_29 X2 -> auto___def_29 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_29 X2 -> auto___def_29 X2). tauto. exact (rem_41 X2).
Qed.

Remark rem_43 : forall X1 X2:term, auto___def_18 X1 -> auto___def_29 X2 -> (auto___def_18 X1 /\ auto___def_29 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_18 X1). 2:apply (rem_40 X1 X2);  assumption.
  cut (auto___def_29 X2). 2:apply (rem_42 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_44 : forall X1 X2:term, auto___def_18 X1 -> auto___def_29 X2 -> auto___def_13 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_43 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_13_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_45 : forall X1 X2:term, auto___def_29 X2 -> auto___def_18 X1 -> auto___def_13 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_29 X2 -> auto___def_13 (key X1 X2)). tauto. exact (rem_44 X1 X2).
Qed.

Remark rem_46 : forall X1:term, auto___def_57 X1 -> auto___def_57 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_47 : forall X1 X2:term, auto___def_57 X1 -> auto___def_58 X2 -> auto___def_57 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_57 X1 -> auto___def_57 X1). tauto. exact (rem_46 X1).
Qed.

Remark rem_48 : forall X2:term, auto___def_58 X2 -> auto___def_58 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_49 : forall X1 X2:term, auto___def_57 X1 -> auto___def_58 X2 -> auto___def_58 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_58 X2 -> auto___def_58 X2). tauto. exact (rem_48 X2).
Qed.

Remark rem_50 : forall X1 X2:term, auto___def_57 X1 -> auto___def_58 X2 -> (auto___def_57 X1 /\ auto___def_58 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_57 X1). 2:apply (rem_47 X1 X2);  assumption.
  cut (auto___def_58 X2). 2:apply (rem_49 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_51 : forall X1 X2:term, auto___def_57 X1 -> auto___def_58 X2 -> auto___def_55 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_50 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_55_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_52 : forall X1 X2:term, auto___def_58 X2 -> auto___def_57 X1 -> auto___def_55 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_57 X1 -> auto___def_58 X2 -> auto___def_55 (key X1 X2)). tauto. exact (rem_51 X1 X2).
Qed.

Remark rem_53 : forall X1:term, auto___def_16 X1 -> auto___def_16 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_54 : forall X1 X2:term, auto___def_16 X1 -> auto___def_17 X2 -> auto___def_16 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_16 X1 -> auto___def_16 X1). tauto. exact (rem_53 X1).
Qed.

Remark rem_55 : forall X2:term, auto___def_17 X2 -> auto___def_17 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_56 : forall X1 X2:term, auto___def_16 X1 -> auto___def_17 X2 -> auto___def_17 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_17 X2 -> auto___def_17 X2). tauto. exact (rem_55 X2).
Qed.

Remark rem_57 : forall X1 X2:term, auto___def_16 X1 -> auto___def_17 X2 -> (auto___def_16 X1 /\ auto___def_17 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_16 X1). 2:apply (rem_54 X1 X2);  assumption.
  cut (auto___def_17 X2). 2:apply (rem_56 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_58 : forall X1 X2:term, auto___def_16 X1 -> auto___def_17 X2 -> auto___def_15 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_57 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_15_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_59 : forall X1 X2:term, auto___def_17 X2 -> auto___def_16 X1 -> auto___def_15 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_16 X1 -> auto___def_17 X2 -> auto___def_15 (cons X1 X2)). tauto. exact (rem_58 X1 X2).
Qed.

Remark rem_60 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_4.  tauto.
Defined.

Remark rem_61 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> auto___type_4 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_4.  case (rem_60 epsilon_mknows_old_p__type_4). clear  epsilon_mknows_old_p__type_4. intros. apply trans___type_4_bob_1;  tauto.
 clear  epsilon_mknows_old_p__type_4. tauto.
Defined.

Remark rem_62 : auto_knows_old bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_63 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> auto_knows_old bob -> auto___type_4 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intro H. intros.
  elim (rem_62 H);  intros.
  apply (rem_61 epsilon_mknows_old_p__type_4);  tauto.
Defined.

Remark rem_64 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> auto___type_4 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_4.  case (rem_60 epsilon_mknows_old_p__type_4). clear  epsilon_mknows_old_p__type_4. intros. apply trans___type_4_alice_1;  tauto.
 clear  epsilon_mknows_old_p__type_4. tauto.
Defined.

Remark rem_65 : auto_knows_old alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_66 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> auto_knows_old alice -> auto___type_4 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intro H. intros.
  elim (rem_65 H);  intros.
  apply (rem_64 epsilon_mknows_old_p__type_4);  tauto.
Defined.

Remark rem_67 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_68 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2.
  cut (auto_knows_old X1 -> auto_knows_old X1). tauto. exact (rem_67 epsilon_mknows_old_p__type_4 X1).
Defined.

Remark rem_69 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X2:term, auto_knows_old X2 -> auto_knows_old X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_70 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_69 epsilon_mknows_old_p__type_4 X2).
Defined.

Remark rem_71 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> (auto_knows_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_68 epsilon_mknows_old_p__type_4 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_70 epsilon_mknows_old_p__type_4 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_72 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_4 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2. intros A1 A2.
  case (rem_71 epsilon_mknows_old_p__type_4 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_4 A1 A2. intros. apply trans___type_4_cons_1;  tauto.
 clear  epsilon_mknows_old_p__type_4 A1 A2. tauto.
Defined.

Remark rem_73 : forall X1 X2:term, auto_knows_old (cons X1 X2) -> or_1
    (auto_knows_old X1 /\ auto_knows_old X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_74 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto_knows_old (cons X1 X2) -> auto___type_4 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2. intro H. intros.
  elim (rem_73 X1 X2 H);  intros.
  apply (rem_72 epsilon_mknows_old_p__type_4 X1 X2);  tauto.
Defined.

Remark rem_75 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1. intros A1.
  cut (auto_knows_old X1). 2:apply (rem_67 epsilon_mknows_old_p__type_4 X1);  assumption.
  tauto.
Defined.

Remark rem_76 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1:term, auto_knows_old X1 -> auto___type_4 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1. intros A1.
  case (rem_75 epsilon_mknows_old_p__type_4 X1 A1). clear  epsilon_mknows_old_p__type_4 A1. intros. apply trans___type_4_s_1;  tauto.
 clear  epsilon_mknows_old_p__type_4 A1. tauto.
Defined.

Remark rem_77 : forall X1:term, auto_knows_old (s X1) -> or_1
    (auto_knows_old X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_78 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1:term, auto_knows_old (s X1) -> auto___type_4 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1. intro H. intros.
  elim (rem_77 X1 H);  intros.
  apply (rem_76 epsilon_mknows_old_p__type_4 X1);  tauto.
Defined.

Remark rem_79 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> auto___type_4 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_4.  case (rem_60 epsilon_mknows_old_p__type_4). clear  epsilon_mknows_old_p__type_4. intros. apply trans___type_4_nil_1;  tauto.
 clear  epsilon_mknows_old_p__type_4. tauto.
Defined.

Remark rem_80 : auto_knows_old nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_81 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> auto_knows_old nil -> auto___type_4 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intro H. intros.
  elim (rem_80 H);  intros.
  apply (rem_79 epsilon_mknows_old_p__type_4);  tauto.
Defined.

Remark rem_82 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> auto___type_4 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_4.  case (rem_60 epsilon_mknows_old_p__type_4). clear  epsilon_mknows_old_p__type_4. intros. apply trans___type_4_i_1;  tauto.
 clear  epsilon_mknows_old_p__type_4. tauto.
Defined.

Remark rem_83 : auto_knows_old i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_84 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> auto_knows_old i -> auto___type_4 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intro H. intros.
  elim (rem_83 H);  intros.
  apply (rem_82 epsilon_mknows_old_p__type_4);  tauto.
Defined.

Remark rem_85 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1:term, auto___def_35 X1 -> auto___def_35 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_86 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___def_35 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2.
  cut (auto___def_35 X1 -> auto___def_35 X1). tauto. exact (rem_85 epsilon_mknows_old_p__type_4 X1).
Defined.

Remark rem_87 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_88 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_87 epsilon_mknows_old_p__type_4 X2).
Defined.

Remark rem_89 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> (auto___def_35 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2. intros A1 A2.
  cut (auto___def_35 X1). 2:apply (rem_86 epsilon_mknows_old_p__type_4 X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_88 epsilon_mknows_old_p__type_4 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_90 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___type_4 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2. intros A1 A2.
  case (rem_89 epsilon_mknows_old_p__type_4 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_4 A1 A2. intros. apply trans___type_4_key_1;  tauto.
 clear  epsilon_mknows_old_p__type_4 A1 A2. tauto.
Defined.

Remark rem_91 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1:term, auto___def_36 X1 -> auto___def_36 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_92 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_36 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2.
  cut (auto___def_36 X1 -> auto___def_36 X1). tauto. exact (rem_91 epsilon_mknows_old_p__type_4 X1).
Defined.

Remark rem_93 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X2:term, auto___def_37 X2 -> auto___def_37 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_94 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_37 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2.
  cut (auto___def_37 X2 -> auto___def_37 X2). tauto. exact (rem_93 epsilon_mknows_old_p__type_4 X2).
Defined.

Remark rem_95 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> (auto___def_36 X1 /\ auto___def_37 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2. intros A1 A2.
  cut (auto___def_36 X1). 2:apply (rem_92 epsilon_mknows_old_p__type_4 X1 X2);  assumption.
  cut (auto___def_37 X2). 2:apply (rem_94 epsilon_mknows_old_p__type_4 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_96 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_4 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2. intros A1 A2.
  case (rem_95 epsilon_mknows_old_p__type_4 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_4 A1 A2. intros. apply trans___type_4_key_2;  tauto.
 clear  epsilon_mknows_old_p__type_4 A1 A2. tauto.
Defined.

Inductive or_2(H1 H2:Prop) : Prop :=
    or_2_intro_1 : H1 -> (or_2 H1 H2)
  | or_2_intro_2 : H2 -> (or_2 H1 H2)
.

Remark rem_97 : forall X1 X2:term, auto_knows_old (key X1 X2) -> or_2
    (auto___def_35 X1 /\ auto___type_8 X2)
    (auto___def_36 X1 /\ auto___def_37 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_98 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto_knows_old (key X1 X2) -> auto___type_4 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2. intro H. intros.
  elim (rem_97 X1 X2 H);  intros.
  apply (rem_90 epsilon_mknows_old_p__type_4 X1 X2);  tauto.
  apply (rem_96 epsilon_mknows_old_p__type_4 X1 X2);  tauto.
Defined.

Remark rem_99 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1:term, auto___def_12 X1 -> auto___def_12 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_100 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_12 X1). tauto. exact (rem_99 epsilon_mknows_old_p__type_4 X1).
Defined.

Remark rem_101 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X2:term, auto___def_13 X2 -> auto___def_13 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_102 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_101 epsilon_mknows_old_p__type_4 X2).
Defined.

Remark rem_103 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> (auto___def_12 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2. intros A1 A2.
  cut (auto___def_12 X1). 2:apply (rem_100 epsilon_mknows_old_p__type_4 X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_102 epsilon_mknows_old_p__type_4 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_104 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___type_4 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2. intros A1 A2.
  case (rem_103 epsilon_mknows_old_p__type_4 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_4 A1 A2. intros. apply trans___type_4_crypt_1;  tauto.
 clear  epsilon_mknows_old_p__type_4 A1 A2. tauto.
Defined.

Remark rem_105 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1:term, auto___def_34 X1 -> auto___def_34 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_106 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> auto___def_34 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2.
  cut (auto___def_34 X1 -> auto___def_34 X1). tauto. exact (rem_105 epsilon_mknows_old_p__type_4 X1).
Defined.

Remark rem_107 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X2:term, auto___type_7 X2 -> auto___type_7 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_108 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> auto___type_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2.
  cut (auto___type_7 X2 -> auto___type_7 X2). tauto. exact (rem_107 epsilon_mknows_old_p__type_4 X2).
Defined.

Remark rem_109 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> (auto___def_34 X1 /\ auto___type_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2. intros A1 A2.
  cut (auto___def_34 X1). 2:apply (rem_106 epsilon_mknows_old_p__type_4 X1 X2);  assumption.
  cut (auto___type_7 X2). 2:apply (rem_108 epsilon_mknows_old_p__type_4 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_110 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> auto___type_4 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2. intros A1 A2.
  case (rem_109 epsilon_mknows_old_p__type_4 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_4 A1 A2. intros. apply trans___type_4_crypt_2;  tauto.
 clear  epsilon_mknows_old_p__type_4 A1 A2. tauto.
Defined.

Remark rem_111 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1:term, auto___def_22 X1 -> auto___def_22 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_112 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_22 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2.
  cut (auto___def_22 X1 -> auto___def_22 X1). tauto. exact (rem_111 epsilon_mknows_old_p__type_4 X1).
Defined.

Remark rem_113 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X2:term, auto___def_23 X2 -> auto___def_23 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_114 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_113 epsilon_mknows_old_p__type_4 X2).
Defined.

Remark rem_115 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> (auto___def_22 X1 /\ auto___def_23 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2. intros A1 A2.
  cut (auto___def_22 X1). 2:apply (rem_112 epsilon_mknows_old_p__type_4 X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_114 epsilon_mknows_old_p__type_4 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_116 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___type_4 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2. intros A1 A2.
  case (rem_115 epsilon_mknows_old_p__type_4 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_4 A1 A2. intros. apply trans___type_4_crypt_3;  tauto.
 clear  epsilon_mknows_old_p__type_4 A1 A2. tauto.
Defined.

Remark rem_117 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_4 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2. intros A1 A2.
  case (rem_71 epsilon_mknows_old_p__type_4 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_4 A1 A2. intros. apply trans___type_4_crypt_4;  tauto.
 clear  epsilon_mknows_old_p__type_4 A1 A2. tauto.
Defined.

Remark rem_118 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1:term, auto___def_32 X1 -> auto___def_32 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_119 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> auto___def_32 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2.
  cut (auto___def_32 X1 -> auto___def_32 X1). tauto. exact (rem_118 epsilon_mknows_old_p__type_4 X1).
Defined.

Remark rem_120 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X2:term, auto___type_6 X2 -> auto___type_6 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_121 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> auto___type_6 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2.
  cut (auto___type_6 X2 -> auto___type_6 X2). tauto. exact (rem_120 epsilon_mknows_old_p__type_4 X2).
Defined.

Remark rem_122 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> (auto___def_32 X1 /\ auto___type_6 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2. intros A1 A2.
  cut (auto___def_32 X1). 2:apply (rem_119 epsilon_mknows_old_p__type_4 X1 X2);  assumption.
  cut (auto___type_6 X2). 2:apply (rem_121 epsilon_mknows_old_p__type_4 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_123 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> auto___type_4 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2. intros A1 A2.
  case (rem_122 epsilon_mknows_old_p__type_4 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_4 A1 A2. intros. apply trans___type_4_crypt_5;  tauto.
 clear  epsilon_mknows_old_p__type_4 A1 A2. tauto.
Defined.

Remark rem_124 : forall X1 X2:term, auto_knows_old (crypt X1 X2) -> or_5
    (auto___def_12 X1 /\ auto___def_13 X2)
    (auto___def_34 X1 /\ auto___type_7 X2)
    (auto___def_22 X1 /\ auto___def_23 X2)
    (auto_knows_old X1 /\ auto_knows_old X2)
    (auto___def_32 X1 /\ auto___type_6 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_5_intro_1; tauto.
  intros. apply or_5_intro_2; tauto.
  intros. apply or_5_intro_3; tauto.
  intros. apply or_5_intro_4; tauto.
  intros. apply or_5_intro_5; tauto.
Qed.

Remark rem_125 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto_knows_old (crypt X1 X2) -> auto___type_4 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2. intro H. intros.
  elim (rem_124 X1 X2 H);  intros.
  apply (rem_104 epsilon_mknows_old_p__type_4 X1 X2);  tauto.
  apply (rem_110 epsilon_mknows_old_p__type_4 X1 X2);  tauto.
  apply (rem_116 epsilon_mknows_old_p__type_4 X1 X2);  tauto.
  apply (rem_117 epsilon_mknows_old_p__type_4 X1 X2);  tauto.
  apply (rem_123 epsilon_mknows_old_p__type_4 X1 X2);  tauto.
Defined.

Remark rem_126 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_127 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_126 epsilon_mknows_old_p__type_4 X1).
Defined.

Remark rem_128 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_129 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_128 epsilon_mknows_old_p__type_4 X2).
Defined.

Remark rem_130 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> (auto_agent X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2. intros A1 A2.
  cut (auto_agent X1). 2:apply (rem_127 epsilon_mknows_old_p__type_4 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_129 epsilon_mknows_old_p__type_4 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_131 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_4 (noncea_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2. intros A1 A2.
  case (rem_130 epsilon_mknows_old_p__type_4 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_4 A1 A2. intros. apply trans___type_4_noncea_old_1;  tauto.
 clear  epsilon_mknows_old_p__type_4 A1 A2. tauto.
Defined.

Remark rem_132 : forall X1 X2:term, auto_knows_old (noncea_old X1 X2) -> or_1
    (auto_agent X1 /\ auto_agent X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_133 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> forall X1 X2:term, auto_knows_old (noncea_old X1 X2) -> auto___type_4 (noncea_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intros X1 X2. intro H. intros.
  elim (rem_132 X1 X2 H);  intros.
  apply (rem_131 epsilon_mknows_old_p__type_4 X1 X2);  tauto.
Defined.

Remark rem_134 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> auto___type_4 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_4.  case (rem_60 epsilon_mknows_old_p__type_4). clear  epsilon_mknows_old_p__type_4. intros. apply trans___type_4_server_1;  tauto.
 clear  epsilon_mknows_old_p__type_4. tauto.
Defined.

Remark rem_135 : auto_knows_old server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_136 : (forall X:term, auto_knows_old X -> auto___type_4 X)
    -> auto_knows_old server -> auto___type_4 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_4. intro H. intros.
  elim (rem_135 H);  intros.
  apply (rem_134 epsilon_mknows_old_p__type_4);  tauto.
Defined.

Remark rem_137 : forall X1 X2:term, auto_knows_old (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_138 : forall X1 X2 X3:term, auto_knows_old (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_139 : forall X1 X2 X3:term, auto_knows_old (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_140 : forall X1 X2 X3:term, auto_knows_old (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_141 : forall X1 X2 X3:term, auto_knows_old (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_142 : auto_knows_old pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_143 : auto_knows_old prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_144 : auto_knows_old sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_145 : forall X1:term, auto_knows_old X1 -> auto___type_4 X1. (* Induct. *)
Proof.
  fix epsilon_mknows_old_p__type_4 1.
  intro X. case X.
  exact (rem_66 epsilon_mknows_old_p__type_4 ).
  exact (rem_63 epsilon_mknows_old_p__type_4 ).
  intros X1 X2;  exact (rem_74 epsilon_mknows_old_p__type_4 X1 X2).
  intros X1 X2;  exact (rem_125 epsilon_mknows_old_p__type_4 X1 X2).
  exact (rem_84 epsilon_mknows_old_p__type_4 ).
  intros X1 X2;  exact (rem_98 epsilon_mknows_old_p__type_4 X1 X2).
  exact (rem_81 epsilon_mknows_old_p__type_4 ).
  intros X1 X2. intro H. elim (rem_137 X1 X2 H).
  intros X1 X2;  exact (rem_133 epsilon_mknows_old_p__type_4 X1 X2).
  intros X1 X2 X3. intro H. elim (rem_139 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_140 X1 X2 X3 H).
   intro H. elim (rem_143  H).
   intro H. elim (rem_142  H).
  intros X1;  exact (rem_78 epsilon_mknows_old_p__type_4 X1).
  exact (rem_136 epsilon_mknows_old_p__type_4 ).
  intros X1 X2 X3. intro H. elim (rem_138 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_141 X1 X2 X3 H).
   intro H. elim (rem_144  H).
Qed.

Remark rem_146 : forall X1 X2 X3:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto___type_4 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_old X1 -> auto___type_4 X1). tauto. exact (rem_145 X1).
Qed.

Remark rem_147 : forall X1 X2 X3:term, auto___def_11 X1 X2 X3 -> or_1
    (auto_knows_old X1 /\ auto_knows_old X2 /\ auto_knows_old X3)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_148 : forall X1 X2 X3:term, auto___def_11 X2 X1 X3 -> auto___type_4 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_147 X2 X1 X3 H);  intros.
  apply (rem_146 X1 X2 X3);  tauto.
Qed.

Remark rem_149 : forall X1:term, auto___type_8 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_8_1. Qed.

Remark rem_150 : forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_151 : forall X1 X2 X3:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old nil -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_old X1 -> auto_knows_old X1). tauto. exact (rem_150 X1).
Qed.

Remark rem_152 : forall X2:term, auto_knows_old X2 -> auto_knows_old X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_153 : forall X1 X2 X3:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old nil -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_152 X2).
Qed.

Remark rem_154 : forall X3:term, auto_knows_old X3 -> auto_knows_old X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_155 : forall X1 X2 X3:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old nil -> auto_knows_old X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_old X3 -> auto_knows_old X3). tauto. exact (rem_154 X3).
Qed.

Remark rem_156 : forall X1 X2 X3:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old nil -> (auto_knows_old X1 /\ auto_knows_old X2 /\ auto_knows_old X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  cut (auto_knows_old X1). 2:apply (rem_151 X1 X2 X3);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_153 X1 X2 X3);  assumption.
  cut (auto_knows_old X3). 2:apply (rem_155 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_157 : forall X1 X2 X3:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old nil -> auto___def_11 X1 X2 X3. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  case (rem_156 X1 X2 X3 A1 A2 A3 A4). clear  A1 A2 A3 A4. intros. apply trans___def_11_1;  tauto.
 clear  A1 A2 A3 A4. tauto.
Qed.

Remark rem_158 : forall X1 X2 X3:term, auto_knows_old X3 -> auto_knows_old nil -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_11 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old nil -> auto___def_11 X1 X2 X3). tauto. exact (rem_157 X1 X2 X3).
Qed.

Remark rem_159 : forall X1 X2 X3:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old (cons X3 nil) -> auto___def_11 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1 H2. intro H. intros.
  elim (rem_73 X3 nil H);  intros.
  apply (rem_158 X1 X2 X3);  tauto.
Qed.

Remark rem_160 : forall X1 X2 X3:term, auto_knows_old X2 -> auto_knows_old (cons X3 nil) -> auto_knows_old X1 -> auto___def_11 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old (cons X3 nil) -> auto___def_11 X1 X2 X3). tauto. exact (rem_159 X1 X2 X3).
Qed.

Remark rem_161 : forall X1 X2 X3:term, auto_knows_old X1 -> auto_knows_old (cons X2 (cons X3 nil)) -> auto___def_11 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_73 X2 (cons X3 nil) H);  intros.
  apply (rem_160 X1 X2 X3);  tauto.
Qed.

Remark rem_162 : forall X1 X2 X3:term, auto_knows_old (cons X1 (cons X2 (cons X3 nil))) -> auto___def_11 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_73 X1 (cons X2 (cons X3 nil)) H);  intros.
  apply (rem_161 X1 X2 X3);  tauto.
Qed.

Remark rem_163 : auto___def_18 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_164 : auto___def_18 prv -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_163 H);  intros.
Qed.

Remark rem_165 : forall X1 X2:term, auto___def_12 X2 -> auto___def_18 prv -> auto___def_29 X1 -> auto___def_3 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 prv -> False). tauto.
  exact (rem_164).
Qed.

Remark rem_166 : forall X1 X2:term, auto___def_18 prv -> auto___def_29 X1 -> auto___def_12 X2 -> auto___def_3 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_12 X2 -> auto___def_18 prv -> auto___def_29 X1 -> auto___def_3 X1 X2). tauto. exact (rem_165 X1 X2).
Qed.

Remark rem_167 : forall X1 X2:term, auto___def_13 (key X1 X2) -> or_1
    (auto___def_18 X1 /\ auto___def_29 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_168 : forall X1 X2:term, auto___def_12 X2 -> auto___def_13 (key prv X1) -> auto___def_3 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_167 prv X1 H);  intros.
  apply (rem_166 X1 X2);  tauto.
Qed.

Remark rem_169 : forall X1 X2:term, auto___def_18 prv -> auto___def_19 X1 -> auto___def_34 X2 -> auto___def_3 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 prv -> False). tauto.
  exact (rem_164).
Qed.

Remark rem_170 : forall X1 X2:term, auto___type_7 (key X1 X2) -> or_1
    (auto___def_18 X1 /\ auto___def_19 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_171 : forall X1 X2:term, auto___def_34 X2 -> auto___type_7 (key prv X1) -> auto___def_3 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_170 prv X1 H);  intros.
  apply (rem_169 X1 X2);  tauto.
Qed.

Remark rem_172 : forall X1 X2:term, auto___def_18 prv -> auto___def_22 X2 -> auto___def_25 X1 -> auto___def_3 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 prv -> False). tauto.
  exact (rem_164).
Qed.

Remark rem_173 : forall X1 X2:term, auto___def_18 prv -> auto___def_25 X1 -> auto___def_22 X2 -> auto___def_3 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_18 prv -> auto___def_22 X2 -> auto___def_25 X1 -> auto___def_3 X1 X2). tauto. exact (rem_172 X1 X2).
Qed.

Remark rem_174 : forall X1 X2:term, auto___def_23 (key X1 X2) -> or_1
    (auto___def_18 X1 /\ auto___def_25 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_175 : forall X1 X2:term, auto___def_22 X2 -> auto___def_23 (key prv X1) -> auto___def_3 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_174 prv X1 H);  intros.
  apply (rem_173 X1 X2);  tauto.
Qed.

Remark rem_176 : auto___def_35 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_177 : auto___def_35 prv -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_176 H);  intros.
Qed.

Remark rem_178 : forall X1 X2:term, auto___def_35 prv -> auto_knows_old X2 -> auto___def_3 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_35 prv -> False). tauto.
  exact (rem_177).
Qed.

Remark rem_179 : forall X1 X2:term, auto___def_35 prv -> auto___type_8 X1 -> auto_knows_old X2 -> auto___def_3 X1 X2. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2. intros. apply (rem_178 X1 X2);  assumption.
Qed.

Remark rem_180 : forall X1:term, auto___def_37 X1 -> auto___def_37 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_181 : forall X1 X2:term, auto___def_36 prv -> auto___def_37 X1 -> auto_knows_old X2 -> auto___def_37 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_37 X1 -> auto___def_37 X1). tauto. exact (rem_180 X1).
Qed.

Remark rem_182 : forall X1 X2:term, auto___def_36 prv -> auto___def_37 X1 -> auto_knows_old X2 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_152 X2).
Qed.

Remark rem_183 : forall X1 X2:term, auto___def_36 prv -> auto___def_37 X1 -> auto_knows_old X2 -> (auto___def_37 X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_37 X1). 2:apply (rem_181 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_182 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_184 : forall X1 X2:term, auto___def_36 prv -> auto___def_37 X1 -> auto_knows_old X2 -> auto___def_3 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_183 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_3_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_185 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old (key prv X1) -> auto___def_3 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_97 prv X1 H);  intros.
  apply (rem_179 X1 X2);  tauto.
  apply (rem_184 X1 X2);  tauto.
Qed.

Remark rem_186 : forall X1 X2:term, auto___def_18 prv -> auto___def_19 X1 -> auto___def_32 X2 -> auto___def_3 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 prv -> False). tauto.
  exact (rem_164).
Qed.

Remark rem_187 : forall X1 X2:term, auto___type_6 (key X1 X2) -> or_1
    (auto___def_18 X1 /\ auto___def_19 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_188 : forall X1 X2:term, auto___def_32 X2 -> auto___type_6 (key prv X1) -> auto___def_3 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_187 prv X1 H);  intros.
  apply (rem_186 X1 X2);  tauto.
Qed.

Remark rem_189 : forall X1 X2:term, auto_knows_old (crypt X2 (key prv X1)) -> auto___def_3 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_124 X2 (key prv X1) H);  intros.
  apply (rem_168 X1 X2);  tauto.
  apply (rem_171 X1 X2);  tauto.
  apply (rem_175 X1 X2);  tauto.
  apply (rem_185 X1 X2);  tauto.
  apply (rem_188 X1 X2);  tauto.
Qed.

Remark rem_190 : forall X1:term, auto___def_20 X1 -> auto___def_20 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_191 : forall X1 X2:term, auto___def_20 X1 -> auto___def_21 X2 -> auto___def_20 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_20 X1 -> auto___def_20 X1). tauto. exact (rem_190 X1).
Qed.

Remark rem_192 : forall X2:term, auto___def_21 X2 -> auto___def_21 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_193 : forall X1 X2:term, auto___def_20 X1 -> auto___def_21 X2 -> auto___def_21 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_21 X2 -> auto___def_21 X2). tauto. exact (rem_192 X2).
Qed.

Remark rem_194 : forall X1 X2:term, auto___def_20 X1 -> auto___def_21 X2 -> (auto___def_20 X1 /\ auto___def_21 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_20 X1). 2:apply (rem_191 X1 X2);  assumption.
  cut (auto___def_21 X2). 2:apply (rem_193 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_195 : forall X1 X2:term, auto___def_20 X1 -> auto___def_21 X2 -> auto___def_17 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_194 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_17_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_196 : forall X1 X2:term, auto___def_21 X2 -> auto___def_20 X1 -> auto___def_17 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_20 X1 -> auto___def_21 X2 -> auto___def_17 (cons X1 X2)). tauto. exact (rem_195 X1 X2).
Qed.

Remark rem_197 : forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_198 : forall X1 X2 X3 X4:term, auto___def_16 X3 -> auto___def_20 X4 -> auto___type_4 X2 -> auto___type_5 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_197 X1).
Qed.

Remark rem_199 : forall X1:term, auto___type_5 X1 -> auto___type_5 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_200 : forall X1 X2 X3 X4:term, auto___def_16 X3 -> auto___def_20 X4 -> auto___type_4 X2 -> auto___type_5 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_5 X1 -> auto___type_5 X1). tauto. exact (rem_199 X1).
Qed.

Remark rem_201 : forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_202 : forall X1 X2 X3 X4:term, auto___def_16 X3 -> auto___def_20 X4 -> auto___type_4 X2 -> auto___type_5 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_201 X2).
Qed.

Remark rem_203 : forall X2:term, auto___type_4 X2 -> auto___type_4 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_204 : forall X1 X2 X3 X4:term, auto___def_16 X3 -> auto___def_20 X4 -> auto___type_4 X2 -> auto___type_5 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_4 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_4 X2 -> auto___type_4 X2). tauto. exact (rem_203 X2).
Qed.

Remark rem_205 : forall X3:term, auto___def_16 X3 -> auto___def_16 X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_206 : forall X1 X2 X3 X4:term, auto___def_16 X3 -> auto___def_20 X4 -> auto___type_4 X2 -> auto___type_5 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_16 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_16 X3 -> auto___def_16 X3). tauto. exact (rem_205 X3).
Qed.

Remark rem_207 : forall X4:term, auto___def_20 X4 -> auto___def_20 X4. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_208 : forall X1 X2 X3 X4:term, auto___def_16 X3 -> auto___def_20 X4 -> auto___type_4 X2 -> auto___type_5 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_20 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_20 X4 -> auto___def_20 X4). tauto. exact (rem_207 X4).
Qed.

Remark rem_209 : forall X1 X2 X3 X4:term, auto___def_16 X3 -> auto___def_20 X4 -> auto___type_4 X2 -> auto___type_5 X1 -> auto_agent X2 -> auto_agent X1 -> (auto_agent X1 /\ auto___type_5 X1 /\ auto_agent X2 /\ auto___type_4 X2 /\ auto___def_16 X3 /\ auto___def_20 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  cut (auto_agent X1). 2:apply (rem_198 X1 X2 X3 X4);  assumption.
  cut (auto___type_5 X1). 2:apply (rem_200 X1 X2 X3 X4);  assumption.
  cut (auto_agent X2). 2:apply (rem_202 X1 X2 X3 X4);  assumption.
  cut (auto___type_4 X2). 2:apply (rem_204 X1 X2 X3 X4);  assumption.
  cut (auto___def_16 X3). 2:apply (rem_206 X1 X2 X3 X4);  assumption.
  cut (auto___def_20 X4). 2:apply (rem_208 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_210 : forall X1 X2 X3 X4:term, auto___def_16 X3 -> auto___def_20 X4 -> auto___type_4 X2 -> auto___type_5 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_30 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  case (rem_209 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6). clear  A1 A2 A3 A4 A5 A6. intros. apply trans___def_30_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6. tauto.
Qed.

Remark rem_211 : forall X1 X2 X3 X4:term, auto_agent X1 -> auto_agent X2 -> auto___def_16 X3 -> auto___def_20 X4 -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_30 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_16 X3 -> auto___def_20 X4 -> auto___type_4 X2 -> auto___type_5 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_30 X1 X2 X3 X4). tauto. exact (rem_210 X1 X2 X3 X4).
Qed.

Remark rem_212 : forall X1 X2:term, auto___type_3 (noncea_old X1 X2) -> or_1
    (auto_agent X1 /\ auto_agent X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_213 : forall X1 X2 X3 X4:term, auto___def_16 X3 -> auto___def_20 X4 -> auto___type_3 (noncea_old X1 X2) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_30 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_212 X1 X2 H);  intros.
  apply (rem_211 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_214 : forall X1 X2 X3 X4:term, auto___def_16 X3 -> auto___def_20 X4 -> auto___def_26 (cons server nil) -> auto___type_3 (noncea_old X1 X2) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_30 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_16 X3 -> auto___def_20 X4 -> auto___type_3 (noncea_old X1 X2) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_30 X1 X2 X3 X4). tauto.
  exact (rem_213 X1 X2 X3 X4).
Qed.

Remark rem_215 : forall X1 X2 X3 X4:term, auto___type_5 X1 -> auto___def_26 (cons server nil) -> auto___def_16 X3 -> auto___def_20 X4 -> auto___type_3 (noncea_old X1 X2) -> auto___type_4 X2 -> auto___def_30 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_16 X3 -> auto___def_20 X4 -> auto___def_26 (cons server nil) -> auto___type_3 (noncea_old X1 X2) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_30 X1 X2 X3 X4). tauto. exact (rem_214 X1 X2 X3 X4).
Qed.

Remark rem_216 : forall X1 X2:term, auto___def_29 (cons X1 X2) -> or_1
    (auto___type_5 X1 /\ auto___def_26 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_217 : forall X1 X2 X3 X4:term, auto___def_16 X3 -> auto___def_20 X4 -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_old X1 X2) -> auto___type_4 X2 -> auto___def_30 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_216 X1 (cons server nil) H);  intros.
  apply (rem_215 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_218 : forall X1 X2 X3 X4:term, auto___def_16 X3 -> auto___def_20 X4 -> auto___def_21 nil -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_old X1 X2) -> auto___type_4 X2 -> auto___def_30 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_16 X3 -> auto___def_20 X4 -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_old X1 X2) -> auto___type_4 X2 -> auto___def_30 X1 X2 X3 X4). tauto.
  exact (rem_217 X1 X2 X3 X4).
Qed.

Remark rem_219 : forall X1 X2 X3 X4:term, auto___def_20 X4 -> auto___def_21 nil -> auto___def_16 X3 -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_old X1 X2) -> auto___type_4 X2 -> auto___def_30 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_16 X3 -> auto___def_20 X4 -> auto___def_21 nil -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_old X1 X2) -> auto___type_4 X2 -> auto___def_30 X1 X2 X3 X4). tauto. exact (rem_218 X1 X2 X3 X4).
Qed.

Remark rem_220 : forall X1 X2:term, auto___def_17 (cons X1 X2) -> or_1
    (auto___def_20 X1 /\ auto___def_21 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_221 : forall X1 X2 X3 X4:term, auto___def_16 X3 -> auto___def_17 (cons X4 nil) -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_old X1 X2) -> auto___type_4 X2 -> auto___def_30 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_220 X4 nil H);  intros.
  apply (rem_219 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_222 : forall X1 X2:term, auto___def_15 (cons X1 X2) -> or_1
    (auto___def_16 X1 /\ auto___def_17 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_223 : forall X1 X2 X3 X4:term, auto___def_15 (cons X3 (cons X4 nil)) -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_old X1 X2) -> auto___type_4 X2 -> auto___def_30 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_222 X3 (cons X4 nil) H);  intros.
  apply (rem_221 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_224 : forall X1 X2 X3 X4:term, auto___type_4 X2 -> auto___def_15 (cons X3 (cons X4 nil)) -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_old X1 X2) -> auto___def_30 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_15 (cons X3 (cons X4 nil)) -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_old X1 X2) -> auto___type_4 X2 -> auto___def_30 X1 X2 X3 X4). tauto. exact (rem_223 X1 X2 X3 X4).
Qed.

Remark rem_225 : forall X1 X2:term, auto___def_14 (cons X1 X2) -> or_1
    (auto___type_4 X1 /\ auto___def_15 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_226 : forall X1 X2 X3 X4:term, auto___def_14 (cons X2 (cons X3 (cons X4 nil))) -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_old X1 X2) -> auto___def_30 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_225 X2 (cons X3 (cons X4 nil)) H);  intros.
  apply (rem_224 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_227 : forall X1 X2 X3 X4:term, auto___def_14 (cons X2 (cons X3 (cons X4 nil))) -> auto___def_18 sym -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_old X1 X2) -> auto___def_30 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_14 (cons X2 (cons X3 (cons X4 nil))) -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_old X1 X2) -> auto___def_30 X1 X2 X3 X4). tauto.
  exact (rem_226 X1 X2 X3 X4).
Qed.

Remark rem_228 : forall X1 X2 X3 X4:term, auto___def_18 sym -> auto___def_29 (cons X1 (cons server nil)) -> auto___def_14 (cons X2 (cons X3 (cons X4 nil))) -> auto___type_3 (noncea_old X1 X2) -> auto___def_30 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_14 (cons X2 (cons X3 (cons X4 nil))) -> auto___def_18 sym -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_old X1 X2) -> auto___def_30 X1 X2 X3 X4). tauto. exact (rem_227 X1 X2 X3 X4).
Qed.

Remark rem_229 : forall X1 X2 X3 X4:term, auto___def_13 (key sym (cons X1 (cons server nil))) -> auto___def_14 (cons X2 (cons X3 (cons X4 nil))) -> auto___type_3 (noncea_old X1 X2) -> auto___def_30 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_167 sym (cons X1 (cons server nil)) H);  intros.
  apply (rem_228 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_230 : forall X1 X2 X3 X4:term, auto___type_3 (noncea_old X1 X2) -> auto___def_14 (cons X2 (cons X3 (cons X4 nil))) -> auto___def_13 (key sym (cons X1 (cons server nil))) -> auto___def_30 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_13 (key sym (cons X1 (cons server nil))) -> auto___def_14 (cons X2 (cons X3 (cons X4 nil))) -> auto___type_3 (noncea_old X1 X2) -> auto___def_30 X1 X2 X3 X4). tauto. exact (rem_229 X1 X2 X3 X4).
Qed.

Remark rem_231 : forall X1 X2:term, auto___def_12 (cons X1 X2) -> or_1
    (auto___type_3 X1 /\ auto___def_14 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_232 : forall X1 X2 X3 X4:term, auto___def_12 (cons (noncea_old X1 X2) (cons X2 (cons X3 (cons X4 nil)))) -> auto___def_13 (key sym (cons X1 (cons server nil))) -> auto___def_30 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_231 (noncea_old X1 X2) (cons X2 (cons X3 (cons X4 nil))) H);  intros.
  apply (rem_230 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_233 : forall X1 X2:term, auto___def_34 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_234 : forall X1 X2 X3 X4:term, auto___def_34 (cons (noncea_old X1 X2) (cons X2 (cons X3 (cons X4 nil)))) -> auto___type_7 (key sym (cons X1 (cons server nil))) -> auto___def_30 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_233 (noncea_old X1 X2) (cons X2 (cons X3 (cons X4 nil))) H);  intros.
Qed.

Remark rem_235 : forall X1 X2 X3 X4:term, auto___def_16 (noncea_old X1 X2) -> auto___def_23 (key sym (cons X1 (cons server nil))) -> auto___def_24 (cons X2 (cons X3 (cons X4 nil))) -> auto___def_30 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_21 X1 X2 H);  intros.
Qed.

Remark rem_236 : forall X1 X2 X3 X4:term, auto___def_16 (noncea_old X1 X2) -> auto___def_24 (cons X2 (cons X3 (cons X4 nil))) -> auto___def_23 (key sym (cons X1 (cons server nil))) -> auto___def_30 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_16 (noncea_old X1 X2) -> auto___def_23 (key sym (cons X1 (cons server nil))) -> auto___def_24 (cons X2 (cons X3 (cons X4 nil))) -> auto___def_30 X1 X2 X3 X4). tauto. exact (rem_235 X1 X2 X3 X4).
Qed.

Remark rem_237 : forall X1 X2:term, auto___def_22 (cons X1 X2) -> or_1
    (auto___def_16 X1 /\ auto___def_24 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_238 : forall X1 X2 X3 X4:term, auto___def_22 (cons (noncea_old X1 X2) (cons X2 (cons X3 (cons X4 nil)))) -> auto___def_23 (key sym (cons X1 (cons server nil))) -> auto___def_30 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_237 (noncea_old X1 X2) (cons X2 (cons X3 (cons X4 nil))) H);  intros.
  apply (rem_236 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_239 : auto___def_35 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_240 : auto___def_35 sym -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_239 H);  intros.
Qed.

Remark rem_241 : forall X1 X2 X3 X4:term, auto___def_35 sym -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old (noncea_old X1 X2) -> auto___def_30 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_35 sym -> False). tauto.
  exact (rem_240).
Qed.

Remark rem_242 : forall X1 X2 X3 X4:term, auto___def_35 sym -> auto___type_8 (cons X1 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old (noncea_old X1 X2) -> auto___def_30 X1 X2 X3 X4. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2 X3 X4. intros. apply (rem_241 X1 X2 X3 X4);  assumption.
Qed.

Remark rem_243 : forall X1 X2:term, auto___def_37 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_244 : forall X1 X2 X3 X4:term, auto___def_37 (cons X1 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old (noncea_old X1 X2) -> auto___def_30 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_243 X1 (cons server nil) H);  intros.
Qed.

Remark rem_245 : forall X1 X2 X3 X4:term, auto___def_36 sym -> auto___def_37 (cons X1 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old (noncea_old X1 X2) -> auto___def_30 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_37 (cons X1 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old (noncea_old X1 X2) -> auto___def_30 X1 X2 X3 X4). tauto.
  exact (rem_244 X1 X2 X3 X4).
Qed.

Remark rem_246 : forall X1 X2 X3 X4:term, auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old (key sym (cons X1 (cons server nil))) -> auto_knows_old (noncea_old X1 X2) -> auto___def_30 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3. intro H. intros.
  elim (rem_97 sym (cons X1 (cons server nil)) H);  intros.
  apply (rem_242 X1 X2 X3 X4);  tauto.
  apply (rem_245 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_247 : forall X1 X2 X3 X4:term, auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old (key sym (cons X1 (cons server nil))) -> auto_knows_old nil -> auto_knows_old (noncea_old X1 X2) -> auto___def_30 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old (key sym (cons X1 (cons server nil))) -> auto_knows_old (noncea_old X1 X2) -> auto___def_30 X1 X2 X3 X4). tauto.
  exact (rem_246 X1 X2 X3 X4).
Qed.

Remark rem_248 : forall X1 X2 X3 X4:term, auto_knows_old X4 -> auto_knows_old nil -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old (key sym (cons X1 (cons server nil))) -> auto_knows_old (noncea_old X1 X2) -> auto___def_30 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old (key sym (cons X1 (cons server nil))) -> auto_knows_old nil -> auto_knows_old (noncea_old X1 X2) -> auto___def_30 X1 X2 X3 X4). tauto. exact (rem_247 X1 X2 X3 X4).
Qed.

Remark rem_249 : forall X1 X2 X3 X4:term, auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old (cons X4 nil) -> auto_knows_old (key sym (cons X1 (cons server nil))) -> auto_knows_old (noncea_old X1 X2) -> auto___def_30 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_73 X4 nil H);  intros.
  apply (rem_248 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_250 : forall X1 X2 X3 X4:term, auto_knows_old X3 -> auto_knows_old (cons X4 nil) -> auto_knows_old X2 -> auto_knows_old (key sym (cons X1 (cons server nil))) -> auto_knows_old (noncea_old X1 X2) -> auto___def_30 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old (cons X4 nil) -> auto_knows_old (key sym (cons X1 (cons server nil))) -> auto_knows_old (noncea_old X1 X2) -> auto___def_30 X1 X2 X3 X4). tauto. exact (rem_249 X1 X2 X3 X4).
Qed.

Remark rem_251 : forall X1 X2 X3 X4:term, auto_knows_old X2 -> auto_knows_old (cons X3 (cons X4 nil)) -> auto_knows_old (key sym (cons X1 (cons server nil))) -> auto_knows_old (noncea_old X1 X2) -> auto___def_30 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_73 X3 (cons X4 nil) H);  intros.
  apply (rem_250 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_252 : forall X1 X2 X3 X4:term, auto_knows_old (cons X2 (cons X3 (cons X4 nil))) -> auto_knows_old (key sym (cons X1 (cons server nil))) -> auto_knows_old (noncea_old X1 X2) -> auto___def_30 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_73 X2 (cons X3 (cons X4 nil)) H);  intros.
  apply (rem_251 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_253 : forall X1 X2 X3 X4:term, auto_knows_old (noncea_old X1 X2) -> auto_knows_old (cons X2 (cons X3 (cons X4 nil))) -> auto_knows_old (key sym (cons X1 (cons server nil))) -> auto___def_30 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_old (cons X2 (cons X3 (cons X4 nil))) -> auto_knows_old (key sym (cons X1 (cons server nil))) -> auto_knows_old (noncea_old X1 X2) -> auto___def_30 X1 X2 X3 X4). tauto. exact (rem_252 X1 X2 X3 X4).
Qed.

Remark rem_254 : forall X1 X2 X3 X4:term, auto_knows_old (cons (noncea_old X1 X2) (cons X2 (cons X3 (cons X4 nil)))) -> auto_knows_old (key sym (cons X1 (cons server nil))) -> auto___def_30 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_73 (noncea_old X1 X2) (cons X2 (cons X3 (cons X4 nil))) H);  intros.
  apply (rem_253 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_255 : forall X1 X2:term, auto___def_32 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_256 : forall X1 X2 X3 X4:term, auto___def_32 (cons (noncea_old X1 X2) (cons X2 (cons X3 (cons X4 nil)))) -> auto___type_6 (key sym (cons X1 (cons server nil))) -> auto___def_30 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_255 (noncea_old X1 X2) (cons X2 (cons X3 (cons X4 nil))) H);  intros.
Qed.

Remark rem_257 : forall X1 X2 X3 X4:term, auto_knows_old (crypt (cons (noncea_old X1 X2) (cons X2 (cons X3 (cons X4 nil)))) (key sym (cons X1 (cons server nil)))) -> auto___def_30 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_124 (cons (noncea_old X1 X2) (cons X2 (cons X3 (cons X4 nil)))) (key sym (cons X1 (cons server nil))) H);  intros.
  apply (rem_232 X1 X2 X3 X4);  tauto.
  apply (rem_234 X1 X2 X3 X4);  tauto.
  apply (rem_238 X1 X2 X3 X4);  tauto.
  apply (rem_254 X1 X2 X3 X4);  tauto.
  apply (rem_256 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_258 : forall X1:term, auto___def_55 X1 -> auto___def_55 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_259 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___type_10 X3 -> auto___type_11 X2 -> auto___def_55 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_55 X1 -> auto___def_55 X1). tauto. exact (rem_258 X1).
Qed.

Remark rem_260 : forall X2:term, auto___type_11 X2 -> auto___type_11 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_261 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___type_10 X3 -> auto___type_11 X2 -> auto___type_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___type_11 X2 -> auto___type_11 X2). tauto. exact (rem_260 X2).
Qed.

Remark rem_262 : forall X3:term, auto___type_10 X3 -> auto___type_10 X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_263 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___type_10 X3 -> auto___type_11 X2 -> auto___type_10 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___type_10 X3 -> auto___type_10 X3). tauto. exact (rem_262 X3).
Qed.

Remark rem_264 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___type_10 X3 -> auto___type_11 X2 -> (auto___def_55 X1 /\ auto___type_11 X2 /\ auto___type_10 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_55 X1). 2:apply (rem_259 X1 X2 X3);  assumption.
  cut (auto___type_11 X2). 2:apply (rem_261 X1 X2 X3);  assumption.
  cut (auto___type_10 X3). 2:apply (rem_263 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_265 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___type_10 X3 -> auto___type_11 X2 -> auto___def_69 (nonceb_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  case (rem_264 X1 X2 X3 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_69_nonceb_current_2;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_266 : forall X1 X2 X3:term, auto___type_11 X2 -> auto___type_10 X3 -> auto___def_55 X1 -> auto___def_69 (nonceb_current X1 X2 X3). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_55 X1 -> auto___type_10 X3 -> auto___type_11 X2 -> auto___def_69 (nonceb_current X1 X2 X3)). tauto. exact (rem_265 X1 X2 X3).
Qed.

Remark rem_267 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_4 X3 -> auto___type_5 X2 -> auto___def_16 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_16 X1 -> auto___def_16 X1). tauto. exact (rem_53 X1).
Qed.

Remark rem_268 : forall X2:term, auto___type_5 X2 -> auto___type_5 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_269 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_4 X3 -> auto___type_5 X2 -> auto___type_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___type_5 X2 -> auto___type_5 X2). tauto. exact (rem_268 X2).
Qed.

Remark rem_270 : forall X3:term, auto___type_4 X3 -> auto___type_4 X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_271 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_4 X3 -> auto___type_5 X2 -> auto___type_4 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___type_4 X3 -> auto___type_4 X3). tauto. exact (rem_270 X3).
Qed.

Remark rem_272 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_4 X3 -> auto___type_5 X2 -> (auto___def_16 X1 /\ auto___type_5 X2 /\ auto___type_4 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_16 X1). 2:apply (rem_267 X1 X2 X3);  assumption.
  cut (auto___type_5 X2). 2:apply (rem_269 X1 X2 X3);  assumption.
  cut (auto___type_4 X3). 2:apply (rem_271 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_273 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_4 X3 -> auto___type_5 X2 -> auto___def_69 (nonceb_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  case (rem_272 X1 X2 X3 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_69_nonceb_current_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_274 : forall X1 X2 X3:term, auto___type_5 X2 -> auto___type_4 X3 -> auto___def_16 X1 -> auto___def_69 (nonceb_current X1 X2 X3). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_16 X1 -> auto___type_4 X3 -> auto___type_5 X2 -> auto___def_69 (nonceb_current X1 X2 X3)). tauto. exact (rem_273 X1 X2 X3).
Qed.

Remark rem_275 : forall X1 X2 X3:term, auto___def_68 X1 X2 X3 -> or_2
    (auto___type_11 X1 /\ auto___type_10 X2 /\ auto___def_55 X3)
    (auto___type_5 X1 /\ auto___type_4 X2 /\ auto___def_16 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_276 : forall X1 X2 X3:term, auto___def_68 X2 X3 X1 -> auto___def_69 (nonceb_current X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_275 X2 X3 X1 H);  intros.
  apply (rem_266 X1 X2 X3);  tauto.
  apply (rem_274 X1 X2 X3);  tauto.
Qed.

Remark rem_277 : auto___def_57 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_278 : auto___def_57 prv -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_277 H);  intros.
Qed.

Remark rem_279 : forall X1 X2:term, auto___def_57 prv -> auto___def_58 X1 -> auto___def_71 X2 -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_57 prv -> False). tauto.
  exact (rem_278).
Qed.

Remark rem_280 : forall X1 X2:term, auto___type_13 (key X1 X2) -> or_1
    (auto___def_57 X1 /\ auto___def_58 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_281 : forall X1 X2:term, auto___def_71 X2 -> auto___type_13 (key prv X1) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_280 prv X1 H);  intros.
  apply (rem_279 X1 X2);  tauto.
Qed.

Remark rem_282 : forall X1 X2:term, auto___def_57 prv -> auto___def_58 X1 -> auto___def_69 X2 -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_57 prv -> False). tauto.
  exact (rem_278).
Qed.

Remark rem_283 : forall X1 X2:term, auto___def_18 prv -> auto___def_19 X1 -> auto___def_69 X2 -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 prv -> False). tauto.
  exact (rem_164).
Qed.

Remark rem_284 : forall X1 X2:term, auto___type_12 (key X1 X2) -> or_2
    (auto___def_57 X1 /\ auto___def_58 X2)
    (auto___def_18 X1 /\ auto___def_19 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_285 : forall X1 X2:term, auto___def_69 X2 -> auto___type_12 (key prv X1) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_284 prv X1 H);  intros.
  apply (rem_282 X1 X2);  tauto.
  apply (rem_283 X1 X2);  tauto.
Qed.

Remark rem_286 : forall X1 X2:term, auto___def_12 X2 -> auto___def_18 prv -> auto___def_29 X1 -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 prv -> False). tauto.
  exact (rem_164).
Qed.

Remark rem_287 : forall X1 X2:term, auto___def_18 prv -> auto___def_29 X1 -> auto___def_12 X2 -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_12 X2 -> auto___def_18 prv -> auto___def_29 X1 -> auto___def_43 X1 X2). tauto. exact (rem_286 X1 X2).
Qed.

Remark rem_288 : forall X1 X2:term, auto___def_12 X2 -> auto___def_13 (key prv X1) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_167 prv X1 H);  intros.
  apply (rem_287 X1 X2);  tauto.
Qed.

Remark rem_289 : forall X1 X2:term, auto___def_57 prv -> auto___def_61 X2 -> auto___def_64 X1 -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_57 prv -> False). tauto.
  exact (rem_278).
Qed.

Remark rem_290 : forall X1 X2:term, auto___def_57 prv -> auto___def_64 X1 -> auto___def_61 X2 -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_57 prv -> auto___def_61 X2 -> auto___def_64 X1 -> auto___def_43 X1 X2). tauto. exact (rem_289 X1 X2).
Qed.

Remark rem_291 : forall X1 X2:term, auto___def_62 (key X1 X2) -> or_1
    (auto___def_57 X1 /\ auto___def_64 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_292 : forall X1 X2:term, auto___def_61 X2 -> auto___def_62 (key prv X1) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_291 prv X1 H);  intros.
  apply (rem_290 X1 X2);  tauto.
Qed.

Remark rem_293 : forall X1 X2:term, auto___def_18 prv -> auto___def_22 X2 -> auto___def_25 X1 -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 prv -> False). tauto.
  exact (rem_164).
Qed.

Remark rem_294 : forall X1 X2:term, auto___def_18 prv -> auto___def_25 X1 -> auto___def_22 X2 -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_18 prv -> auto___def_22 X2 -> auto___def_25 X1 -> auto___def_43 X1 X2). tauto. exact (rem_293 X1 X2).
Qed.

Remark rem_295 : forall X1 X2:term, auto___def_22 X2 -> auto___def_23 (key prv X1) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_174 prv X1 H);  intros.
  apply (rem_294 X1 X2);  tauto.
Qed.

Remark rem_296 : forall X1 X2:term, auto___def_51 X2 -> auto___def_57 prv -> auto___def_66 X1 -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_57 prv -> False). tauto.
  exact (rem_278).
Qed.

Remark rem_297 : forall X1 X2:term, auto___def_57 prv -> auto___def_66 X1 -> auto___def_51 X2 -> auto___def_43 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_51 X2 -> auto___def_57 prv -> auto___def_66 X1 -> auto___def_43 X1 X2). tauto. exact (rem_296 X1 X2).
Qed.

Remark rem_298 : forall X1 X2:term, auto___def_52 (key X1 X2) -> or_1
    (auto___def_57 X1 /\ auto___def_66 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_299 : forall X1 X2:term, auto___def_51 X2 -> auto___def_52 (key prv X1) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_298 prv X1 H);  intros.
  apply (rem_297 X1 X2);  tauto.
Qed.

Remark rem_300 : auto___def_39 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_301 : auto___def_39 prv -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_300 H);  intros.
Qed.

Remark rem_302 : forall X1 X2:term, auto___def_39 prv -> auto___def_40 X1 -> auto_knows_current X2 -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_39 prv -> False). tauto.
  exact (rem_301).
Qed.

Remark rem_303 : forall X1 X2:term, auto___def_35 prv -> auto_knows_current X2 -> auto___def_43 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_35 prv -> False). tauto.
  exact (rem_177).
Qed.

Remark rem_304 : forall X1 X2:term, auto___def_35 prv -> auto___type_8 X1 -> auto_knows_current X2 -> auto___def_43 X1 X2. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2. intros. apply (rem_303 X1 X2);  assumption.
Qed.

Remark rem_305 : forall X1 X2:term, auto___def_36 prv -> auto___def_37 X1 -> auto_knows_current X2 -> auto___def_37 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_37 X1 -> auto___def_37 X1). tauto. exact (rem_180 X1).
Qed.

Remark rem_306 : forall X2:term, auto_knows_current X2 -> auto_knows_current X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_307 : forall X1 X2:term, auto___def_36 prv -> auto___def_37 X1 -> auto_knows_current X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_306 X2).
Qed.

Remark rem_308 : forall X1 X2:term, auto___def_36 prv -> auto___def_37 X1 -> auto_knows_current X2 -> (auto___def_37 X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_37 X1). 2:apply (rem_305 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_307 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_309 : forall X1 X2:term, auto___def_36 prv -> auto___def_37 X1 -> auto_knows_current X2 -> auto___def_43 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_308 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_43_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Inductive or_3(H1 H2 H3:Prop) : Prop :=
    or_3_intro_1 : H1 -> (or_3 H1 H2 H3)
  | or_3_intro_2 : H2 -> (or_3 H1 H2 H3)
  | or_3_intro_3 : H3 -> (or_3 H1 H2 H3)
.

Remark rem_310 : forall X1 X2:term, auto_knows_current (key X1 X2) -> or_3
    (auto___def_39 X1 /\ auto___def_40 X2)
    (auto___def_35 X1 /\ auto___type_8 X2)
    (auto___def_36 X1 /\ auto___def_37 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_311 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current (key prv X1) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_310 prv X1 H);  intros.
  apply (rem_302 X1 X2);  tauto.
  apply (rem_304 X1 X2);  tauto.
  apply (rem_309 X1 X2);  tauto.
Qed.

Inductive or_7(H1 H2 H3 H4 H5 H6 H7:Prop) : Prop :=
    or_7_intro_1 : H1 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_2 : H2 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_3 : H3 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_4 : H4 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_5 : H5 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_6 : H6 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_7 : H7 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
.

Remark rem_312 : forall X1 X2:term, auto_knows_current (crypt X1 X2) -> or_7
    (auto___def_71 X1 /\ auto___type_13 X2)
    (auto___def_69 X1 /\ auto___type_12 X2)
    (auto___def_12 X1 /\ auto___def_13 X2)
    (auto___def_61 X1 /\ auto___def_62 X2)
    (auto___def_22 X1 /\ auto___def_23 X2)
    (auto___def_51 X1 /\ auto___def_52 X2)
    (auto_knows_current X1 /\ auto_knows_current X2)
.
Proof.
  intros. inversion H.
  intros. apply or_7_intro_1; tauto.
  intros. apply or_7_intro_2; tauto.
  intros. apply or_7_intro_3; tauto.
  intros. apply or_7_intro_4; tauto.
  intros. apply or_7_intro_5; tauto.
  intros. apply or_7_intro_6; tauto.
  intros. apply or_7_intro_7; tauto.
Qed.

Remark rem_313 : forall X1 X2:term, auto_knows_current (crypt X2 (key prv X1)) -> auto___def_43 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_312 X2 (key prv X1) H);  intros.
  apply (rem_281 X1 X2);  tauto.
  apply (rem_285 X1 X2);  tauto.
  apply (rem_288 X1 X2);  tauto.
  apply (rem_292 X1 X2);  tauto.
  apply (rem_295 X1 X2);  tauto.
  apply (rem_299 X1 X2);  tauto.
  apply (rem_311 X1 X2);  tauto.
Qed.

Remark rem_314 : forall X1:term, auto___def_59 X1 -> auto___def_59 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_315 : forall X1 X2:term, auto___def_59 X1 -> auto___def_60 X2 -> auto___def_59 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_59 X1 -> auto___def_59 X1). tauto. exact (rem_314 X1).
Qed.

Remark rem_316 : forall X2:term, auto___def_60 X2 -> auto___def_60 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_317 : forall X1 X2:term, auto___def_59 X1 -> auto___def_60 X2 -> auto___def_60 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_60 X2 -> auto___def_60 X2). tauto. exact (rem_316 X2).
Qed.

Remark rem_318 : forall X1 X2:term, auto___def_59 X1 -> auto___def_60 X2 -> (auto___def_59 X1 /\ auto___def_60 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_59 X1). 2:apply (rem_315 X1 X2);  assumption.
  cut (auto___def_60 X2). 2:apply (rem_317 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_319 : forall X1 X2:term, auto___def_59 X1 -> auto___def_60 X2 -> auto___def_56 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_318 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_56_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_320 : forall X1 X2:term, auto___def_60 X2 -> auto___def_59 X1 -> auto___def_56 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_59 X1 -> auto___def_60 X2 -> auto___def_56 (cons X1 X2)). tauto. exact (rem_319 X1 X2).
Qed.

Remark rem_321 : True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
   tauto.
Qed.

Remark rem_322 : auto___def_39 sym. (* Deduce positive atom. *)
Proof.
   case rem_321. intros. apply trans___def_39_sym_1;  tauto.
 tauto.
Qed.

Remark rem_323 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3.  tauto.
Defined.

Remark rem_324 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto___type_3 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3.  case (rem_323 epsilon_mknows_old_p__type_3). clear  epsilon_mknows_old_p__type_3. intros. apply trans___type_3_bob_1;  tauto.
 clear  epsilon_mknows_old_p__type_3. tauto.
Defined.

Remark rem_325 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto_knows_old bob -> auto___type_3 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intro H. intros.
  elim (rem_62 H);  intros.
  apply (rem_324 epsilon_mknows_old_p__type_3);  tauto.
Defined.

Remark rem_326 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto___type_3 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3.  case (rem_323 epsilon_mknows_old_p__type_3). clear  epsilon_mknows_old_p__type_3. intros. apply trans___type_3_alice_1;  tauto.
 clear  epsilon_mknows_old_p__type_3. tauto.
Defined.

Remark rem_327 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto_knows_old alice -> auto___type_3 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intro H. intros.
  elim (rem_65 H);  intros.
  apply (rem_326 epsilon_mknows_old_p__type_3);  tauto.
Defined.

Remark rem_328 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_329 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto_knows_old X1 -> auto_knows_old X1). tauto. exact (rem_328 epsilon_mknows_old_p__type_3 X1).
Defined.

Remark rem_330 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X2:term, auto_knows_old X2 -> auto_knows_old X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_331 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_330 epsilon_mknows_old_p__type_3 X2).
Defined.

Remark rem_332 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> (auto_knows_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_329 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_331 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_333 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_3 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_332 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_cons_1;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_334 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old (cons X1 X2) -> auto___type_3 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intro H. intros.
  elim (rem_73 X1 X2 H);  intros.
  apply (rem_333 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
Defined.

Remark rem_335 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1. intros A1.
  cut (auto_knows_old X1). 2:apply (rem_328 epsilon_mknows_old_p__type_3 X1);  assumption.
  tauto.
Defined.

Remark rem_336 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto_knows_old X1 -> auto___type_3 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1. intros A1.
  case (rem_335 epsilon_mknows_old_p__type_3 X1 A1). clear  epsilon_mknows_old_p__type_3 A1. intros. apply trans___type_3_s_1;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1. tauto.
Defined.

Remark rem_337 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto_knows_old (s X1) -> auto___type_3 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1. intro H. intros.
  elim (rem_77 X1 H);  intros.
  apply (rem_336 epsilon_mknows_old_p__type_3 X1);  tauto.
Defined.

Remark rem_338 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto___type_3 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3.  case (rem_323 epsilon_mknows_old_p__type_3). clear  epsilon_mknows_old_p__type_3. intros. apply trans___type_3_nil_1;  tauto.
 clear  epsilon_mknows_old_p__type_3. tauto.
Defined.

Remark rem_339 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto_knows_old nil -> auto___type_3 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intro H. intros.
  elim (rem_80 H);  intros.
  apply (rem_338 epsilon_mknows_old_p__type_3);  tauto.
Defined.

Remark rem_340 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto___type_3 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3.  case (rem_323 epsilon_mknows_old_p__type_3). clear  epsilon_mknows_old_p__type_3. intros. apply trans___type_3_i_1;  tauto.
 clear  epsilon_mknows_old_p__type_3. tauto.
Defined.

Remark rem_341 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto_knows_old i -> auto___type_3 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intro H. intros.
  elim (rem_83 H);  intros.
  apply (rem_340 epsilon_mknows_old_p__type_3);  tauto.
Defined.

Remark rem_342 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto___def_35 X1 -> auto___def_35 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_343 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___def_35 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_35 X1 -> auto___def_35 X1). tauto. exact (rem_342 epsilon_mknows_old_p__type_3 X1).
Defined.

Remark rem_344 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_345 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_344 epsilon_mknows_old_p__type_3 X2).
Defined.

Remark rem_346 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> (auto___def_35 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_35 X1). 2:apply (rem_343 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_345 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_347 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___type_3 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_346 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_key_1;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_348 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto___def_36 X1 -> auto___def_36 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_349 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_36 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_36 X1 -> auto___def_36 X1). tauto. exact (rem_348 epsilon_mknows_old_p__type_3 X1).
Defined.

Remark rem_350 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X2:term, auto___def_37 X2 -> auto___def_37 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_351 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_37 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_37 X2 -> auto___def_37 X2). tauto. exact (rem_350 epsilon_mknows_old_p__type_3 X2).
Defined.

Remark rem_352 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> (auto___def_36 X1 /\ auto___def_37 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_36 X1). 2:apply (rem_349 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  cut (auto___def_37 X2). 2:apply (rem_351 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_353 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_3 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_352 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_key_2;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_354 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old (key X1 X2) -> auto___type_3 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intro H. intros.
  elim (rem_97 X1 X2 H);  intros.
  apply (rem_347 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
  apply (rem_353 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
Defined.

Remark rem_355 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto___def_12 X1 -> auto___def_12 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_356 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_12 X1). tauto. exact (rem_355 epsilon_mknows_old_p__type_3 X1).
Defined.

Remark rem_357 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X2:term, auto___def_13 X2 -> auto___def_13 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_358 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_357 epsilon_mknows_old_p__type_3 X2).
Defined.

Remark rem_359 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> (auto___def_12 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_12 X1). 2:apply (rem_356 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_358 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_360 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___type_3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_359 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_crypt_1;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_361 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto___def_34 X1 -> auto___def_34 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_362 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> auto___def_34 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_34 X1 -> auto___def_34 X1). tauto. exact (rem_361 epsilon_mknows_old_p__type_3 X1).
Defined.

Remark rem_363 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X2:term, auto___type_7 X2 -> auto___type_7 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_364 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> auto___type_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___type_7 X2 -> auto___type_7 X2). tauto. exact (rem_363 epsilon_mknows_old_p__type_3 X2).
Defined.

Remark rem_365 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> (auto___def_34 X1 /\ auto___type_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_34 X1). 2:apply (rem_362 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  cut (auto___type_7 X2). 2:apply (rem_364 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_366 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> auto___type_3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_365 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_crypt_2;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_367 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto___def_22 X1 -> auto___def_22 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_368 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_22 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_22 X1 -> auto___def_22 X1). tauto. exact (rem_367 epsilon_mknows_old_p__type_3 X1).
Defined.

Remark rem_369 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X2:term, auto___def_23 X2 -> auto___def_23 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_370 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_369 epsilon_mknows_old_p__type_3 X2).
Defined.

Remark rem_371 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> (auto___def_22 X1 /\ auto___def_23 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_22 X1). 2:apply (rem_368 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_370 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_372 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___type_3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_371 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_crypt_3;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_373 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_332 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_crypt_4;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_374 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto___def_32 X1 -> auto___def_32 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_375 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> auto___def_32 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___def_32 X1 -> auto___def_32 X1). tauto. exact (rem_374 epsilon_mknows_old_p__type_3 X1).
Defined.

Remark rem_376 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X2:term, auto___type_6 X2 -> auto___type_6 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_377 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> auto___type_6 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto___type_6 X2 -> auto___type_6 X2). tauto. exact (rem_376 epsilon_mknows_old_p__type_3 X2).
Defined.

Remark rem_378 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> (auto___def_32 X1 /\ auto___type_6 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_32 X1). 2:apply (rem_375 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  cut (auto___type_6 X2). 2:apply (rem_377 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_379 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> auto___type_3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_378 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_crypt_5;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_380 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old (crypt X1 X2) -> auto___type_3 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intro H. intros.
  elim (rem_124 X1 X2 H);  intros.
  apply (rem_360 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
  apply (rem_366 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
  apply (rem_372 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
  apply (rem_373 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
  apply (rem_379 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
Defined.

Remark rem_381 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_382 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_381 epsilon_mknows_old_p__type_3 X1).
Defined.

Remark rem_383 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_384 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_383 epsilon_mknows_old_p__type_3 X2).
Defined.

Remark rem_385 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> (auto_agent X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto_agent X1). 2:apply (rem_382 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_384 epsilon_mknows_old_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_386 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_3 (noncea_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_385 epsilon_mknows_old_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_3 A1 A2. intros. apply trans___type_3_noncea_old_1;  tauto.
 clear  epsilon_mknows_old_p__type_3 A1 A2. tauto.
Defined.

Remark rem_387 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows_old (noncea_old X1 X2) -> auto___type_3 (noncea_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intros X1 X2. intro H. intros.
  elim (rem_132 X1 X2 H);  intros.
  apply (rem_386 epsilon_mknows_old_p__type_3 X1 X2);  tauto.
Defined.

Remark rem_388 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto___type_3 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3.  case (rem_323 epsilon_mknows_old_p__type_3). clear  epsilon_mknows_old_p__type_3. intros. apply trans___type_3_server_1;  tauto.
 clear  epsilon_mknows_old_p__type_3. tauto.
Defined.

Remark rem_389 : (forall X:term, auto_knows_old X -> auto___type_3 X)
    -> auto_knows_old server -> auto___type_3 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_3. intro H. intros.
  elim (rem_135 H);  intros.
  apply (rem_388 epsilon_mknows_old_p__type_3);  tauto.
Defined.

Remark rem_390 : forall X1:term, auto_knows_old X1 -> auto___type_3 X1. (* Induct. *)
Proof.
  fix epsilon_mknows_old_p__type_3 1.
  intro X. case X.
  exact (rem_327 epsilon_mknows_old_p__type_3 ).
  exact (rem_325 epsilon_mknows_old_p__type_3 ).
  intros X1 X2;  exact (rem_334 epsilon_mknows_old_p__type_3 X1 X2).
  intros X1 X2;  exact (rem_380 epsilon_mknows_old_p__type_3 X1 X2).
  exact (rem_341 epsilon_mknows_old_p__type_3 ).
  intros X1 X2;  exact (rem_354 epsilon_mknows_old_p__type_3 X1 X2).
  exact (rem_339 epsilon_mknows_old_p__type_3 ).
  intros X1 X2. intro H. elim (rem_137 X1 X2 H).
  intros X1 X2;  exact (rem_387 epsilon_mknows_old_p__type_3 X1 X2).
  intros X1 X2 X3. intro H. elim (rem_139 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_140 X1 X2 X3 H).
   intro H. elim (rem_143  H).
   intro H. elim (rem_142  H).
  intros X1;  exact (rem_337 epsilon_mknows_old_p__type_3 X1).
  exact (rem_389 epsilon_mknows_old_p__type_3 ).
  intros X1 X2 X3. intro H. elim (rem_138 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_141 X1 X2 X3 H).
   intro H. elim (rem_144  H).
Qed.

Remark rem_391 : forall X1 X2 X3:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_old X1 -> auto___type_3 X1). tauto. exact (rem_390 X1).
Qed.

Remark rem_392 : forall X1 X2 X3:term, auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old X1 -> auto___type_3 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto___type_3 X1). tauto. exact (rem_391 X1 X2 X3).
Qed.

Remark rem_393 : forall X1 X2 X3:term, auto___def_11 X2 X3 X1 -> auto___type_3 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_147 X2 X3 X1 H);  intros.
  apply (rem_392 X1 X2 X3);  tauto.
Qed.

Remark rem_394 : auto___def_28 nil. (* Deduce positive atom. *)
Proof.
   case rem_321. intros. apply trans___def_28_nil_1;  tauto.
 tauto.
Qed.

Remark rem_395 : forall X1:term, auto___type_4 X1 -> auto___type_4 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_396 : forall X1 X2:term, auto___def_15 X2 -> auto___type_4 X1 -> auto___type_4 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_4 X1 -> auto___type_4 X1). tauto. exact (rem_395 X1).
Qed.

Remark rem_397 : forall X2:term, auto___def_15 X2 -> auto___def_15 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_398 : forall X1 X2:term, auto___def_15 X2 -> auto___type_4 X1 -> auto___def_15 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_15 X2 -> auto___def_15 X2). tauto. exact (rem_397 X2).
Qed.

Remark rem_399 : forall X1 X2:term, auto___def_15 X2 -> auto___type_4 X1 -> (auto___type_4 X1 /\ auto___def_15 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_4 X1). 2:apply (rem_396 X1 X2);  assumption.
  cut (auto___def_15 X2). 2:apply (rem_398 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_400 : forall X1 X2:term, auto___def_15 X2 -> auto___type_4 X1 -> auto___def_14 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_399 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_14_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_401 : auto___def_37 i. (* Deduce positive atom. *)
Proof.
   case rem_321. intros. apply trans___def_37_i_1;  tauto.
 tauto.
Qed.

Remark rem_402 : auto___def_27 server. (* Deduce positive atom. *)
Proof.
   case rem_321. intros. apply trans___def_27_server_1;  tauto.
 tauto.
Qed.

Remark rem_403 : forall X1 X2 X3:term, auto___def_40 (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3.  case (rem_321). intros. apply trans___def_40_session_old_1;  tauto.
 tauto.
Qed.

Remark rem_404 : forall X1:term, auto___type_2 X1 -> auto___type_2 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_405 : forall X1 X2:term, auto___def_8 X2 -> auto___type_2 X1 -> auto___type_2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_2 X1 -> auto___type_2 X1). tauto. exact (rem_404 X1).
Qed.

Remark rem_406 : forall X2:term, auto___def_8 X2 -> auto___def_8 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_407 : forall X1 X2:term, auto___def_8 X2 -> auto___type_2 X1 -> auto___def_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_8 X2 -> auto___def_8 X2). tauto. exact (rem_406 X2).
Qed.

Remark rem_408 : forall X1 X2:term, auto___def_8 X2 -> auto___type_2 X1 -> (auto___type_2 X1 /\ auto___def_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_2 X1). 2:apply (rem_405 X1 X2);  assumption.
  cut (auto___def_8 X2). 2:apply (rem_407 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_409 : forall X1 X2:term, auto___def_8 X2 -> auto___type_2 X1 -> auto___def_7 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_408 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_7_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_410 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_411 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_410 epsilon_mknows_current_p__type_9 X1).
Defined.

Remark rem_412 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_413 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_412 epsilon_mknows_current_p__type_9 X2).
Defined.

Remark rem_414 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> (auto_agent X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  cut (auto_agent X1). 2:apply (rem_411 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_413 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_415 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_9 (noncea_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  case (rem_414 epsilon_mknows_current_p__type_9 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_9 A1 A2. intros. apply trans___type_9_noncea_current_1;  tauto.
 clear  epsilon_mknows_current_p__type_9 A1 A2. tauto.
Defined.

Remark rem_416 : forall X1 X2:term, auto_knows_current (noncea_current X1 X2) -> or_1
    (auto_agent X1 /\ auto_agent X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_417 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto_knows_current (noncea_current X1 X2) -> auto___type_9 (noncea_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intro H. intros.
  elim (rem_416 X1 X2 H);  intros.
  apply (rem_415 epsilon_mknows_current_p__type_9 X1 X2);  tauto.
Defined.

Remark rem_418 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_9.  tauto.
Defined.

Remark rem_419 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> auto___type_9 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9.  case (rem_418 epsilon_mknows_current_p__type_9). clear  epsilon_mknows_current_p__type_9. intros. apply trans___type_9_bob_1;  tauto.
 clear  epsilon_mknows_current_p__type_9. tauto.
Defined.

Remark rem_420 : auto_knows_current bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_421 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> auto_knows_current bob -> auto___type_9 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intro H. intros.
  elim (rem_420 H);  intros.
  apply (rem_419 epsilon_mknows_current_p__type_9);  tauto.
Defined.

Remark rem_422 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> auto___type_9 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9.  case (rem_418 epsilon_mknows_current_p__type_9). clear  epsilon_mknows_current_p__type_9. intros. apply trans___type_9_alice_1;  tauto.
 clear  epsilon_mknows_current_p__type_9. tauto.
Defined.

Remark rem_423 : auto_knows_current alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_424 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> auto_knows_current alice -> auto___type_9 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intro H. intros.
  elim (rem_423 H);  intros.
  apply (rem_422 epsilon_mknows_current_p__type_9);  tauto.
Defined.

Remark rem_425 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_426 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_425 epsilon_mknows_current_p__type_9 X1).
Defined.

Remark rem_427 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X2:term, auto_knows_current X2 -> auto_knows_current X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_428 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_427 epsilon_mknows_current_p__type_9 X2).
Defined.

Remark rem_429 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_426 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_428 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_430 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_9 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  case (rem_429 epsilon_mknows_current_p__type_9 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_9 A1 A2. intros. apply trans___type_9_cons_1;  tauto.
 clear  epsilon_mknows_current_p__type_9 A1 A2. tauto.
Defined.

Remark rem_431 : forall X1 X2:term, auto_knows_current (cons X1 X2) -> or_1
    (auto_knows_current X1 /\ auto_knows_current X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_432 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto_knows_current (cons X1 X2) -> auto___type_9 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intro H. intros.
  elim (rem_431 X1 X2 H);  intros.
  apply (rem_430 epsilon_mknows_current_p__type_9 X1 X2);  tauto.
Defined.

Remark rem_433 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_425 epsilon_mknows_current_p__type_9 X1);  assumption.
  tauto.
Defined.

Remark rem_434 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto_knows_current X1 -> auto___type_9 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1. intros A1.
  case (rem_433 epsilon_mknows_current_p__type_9 X1 A1). clear  epsilon_mknows_current_p__type_9 A1. intros. apply trans___type_9_s_1;  tauto.
 clear  epsilon_mknows_current_p__type_9 A1. tauto.
Defined.

Remark rem_435 : forall X1:term, auto_knows_current (s X1) -> or_1
    (auto_knows_current X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_436 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto_knows_current (s X1) -> auto___type_9 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1. intro H. intros.
  elim (rem_435 X1 H);  intros.
  apply (rem_434 epsilon_mknows_current_p__type_9 X1);  tauto.
Defined.

Remark rem_437 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> auto___type_9 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9.  case (rem_418 epsilon_mknows_current_p__type_9). clear  epsilon_mknows_current_p__type_9. intros. apply trans___type_9_nil_1;  tauto.
 clear  epsilon_mknows_current_p__type_9. tauto.
Defined.

Remark rem_438 : auto_knows_current nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_439 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> auto_knows_current nil -> auto___type_9 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intro H. intros.
  elim (rem_438 H);  intros.
  apply (rem_437 epsilon_mknows_current_p__type_9);  tauto.
Defined.

Remark rem_440 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> auto___type_9 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9.  case (rem_418 epsilon_mknows_current_p__type_9). clear  epsilon_mknows_current_p__type_9. intros. apply trans___type_9_i_1;  tauto.
 clear  epsilon_mknows_current_p__type_9. tauto.
Defined.

Remark rem_441 : auto_knows_current i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_442 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> auto_knows_current i -> auto___type_9 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intro H. intros.
  elim (rem_441 H);  intros.
  apply (rem_440 epsilon_mknows_current_p__type_9);  tauto.
Defined.

Remark rem_443 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto___def_39 X1 -> auto___def_39 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_444 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_39 X1 -> auto___def_40 X2 -> auto___def_39 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_39 X1 -> auto___def_39 X1). tauto. exact (rem_443 epsilon_mknows_current_p__type_9 X1).
Defined.

Remark rem_445 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X2:term, auto___def_40 X2 -> auto___def_40 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_446 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_39 X1 -> auto___def_40 X2 -> auto___def_40 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_40 X2 -> auto___def_40 X2). tauto. exact (rem_445 epsilon_mknows_current_p__type_9 X2).
Defined.

Remark rem_447 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_39 X1 -> auto___def_40 X2 -> (auto___def_39 X1 /\ auto___def_40 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  cut (auto___def_39 X1). 2:apply (rem_444 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  cut (auto___def_40 X2). 2:apply (rem_446 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_448 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_39 X1 -> auto___def_40 X2 -> auto___type_9 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  case (rem_447 epsilon_mknows_current_p__type_9 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_9 A1 A2. intros. apply trans___type_9_key_1;  tauto.
 clear  epsilon_mknows_current_p__type_9 A1 A2. tauto.
Defined.

Remark rem_449 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto___def_35 X1 -> auto___def_35 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_450 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___def_35 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_35 X1 -> auto___def_35 X1). tauto. exact (rem_449 epsilon_mknows_current_p__type_9 X1).
Defined.

Remark rem_451 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_452 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_451 epsilon_mknows_current_p__type_9 X2).
Defined.

Remark rem_453 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> (auto___def_35 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  cut (auto___def_35 X1). 2:apply (rem_450 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_452 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_454 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___type_9 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  case (rem_453 epsilon_mknows_current_p__type_9 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_9 A1 A2. intros. apply trans___type_9_key_2;  tauto.
 clear  epsilon_mknows_current_p__type_9 A1 A2. tauto.
Defined.

Remark rem_455 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto___def_36 X1 -> auto___def_36 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_456 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_36 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_36 X1 -> auto___def_36 X1). tauto. exact (rem_455 epsilon_mknows_current_p__type_9 X1).
Defined.

Remark rem_457 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X2:term, auto___def_37 X2 -> auto___def_37 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_458 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_37 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_37 X2 -> auto___def_37 X2). tauto. exact (rem_457 epsilon_mknows_current_p__type_9 X2).
Defined.

Remark rem_459 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> (auto___def_36 X1 /\ auto___def_37 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  cut (auto___def_36 X1). 2:apply (rem_456 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  cut (auto___def_37 X2). 2:apply (rem_458 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_460 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_9 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  case (rem_459 epsilon_mknows_current_p__type_9 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_9 A1 A2. intros. apply trans___type_9_key_3;  tauto.
 clear  epsilon_mknows_current_p__type_9 A1 A2. tauto.
Defined.

Remark rem_461 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto_knows_current (key X1 X2) -> auto___type_9 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intro H. intros.
  elim (rem_310 X1 X2 H);  intros.
  apply (rem_448 epsilon_mknows_current_p__type_9 X1 X2);  tauto.
  apply (rem_454 epsilon_mknows_current_p__type_9 X1 X2);  tauto.
  apply (rem_460 epsilon_mknows_current_p__type_9 X1 X2);  tauto.
Defined.

Remark rem_462 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto___def_16 X1 -> auto___def_16 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_463 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___def_16 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2 X3.
  cut (auto___def_16 X1 -> auto___def_16 X1). tauto. exact (rem_462 epsilon_mknows_current_p__type_9 X1).
Defined.

Remark rem_464 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X2:term, auto___type_5 X2 -> auto___type_5 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_465 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2 X3.
  cut (auto___type_5 X2 -> auto___type_5 X2). tauto. exact (rem_464 epsilon_mknows_current_p__type_9 X2).
Defined.

Remark rem_466 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X3:term, auto___type_4 X3 -> auto___type_4 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_467 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_4 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2 X3.
  cut (auto___type_4 X3 -> auto___type_4 X3). tauto. exact (rem_466 epsilon_mknows_current_p__type_9 X3).
Defined.

Remark rem_468 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> (auto___def_16 X1 /\ auto___type_5 X2 /\ auto___type_4 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_16 X1). 2:apply (rem_463 epsilon_mknows_current_p__type_9 X1 X2 X3);  assumption.
  cut (auto___type_5 X2). 2:apply (rem_465 epsilon_mknows_current_p__type_9 X1 X2 X3);  assumption.
  cut (auto___type_4 X3). 2:apply (rem_467 epsilon_mknows_current_p__type_9 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_469 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_9 (nonceb_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_468 epsilon_mknows_current_p__type_9 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_current_p__type_9 A1 A2 A3. intros. apply trans___type_9_nonceb_current_1;  tauto.
 clear  epsilon_mknows_current_p__type_9 A1 A2 A3. tauto.
Defined.

Remark rem_470 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto___def_55 X1 -> auto___def_55 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_471 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2 X3:term, auto___def_55 X1 -> auto___type_11 X2 -> auto___type_10 X3 -> auto___def_55 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2 X3.
  cut (auto___def_55 X1 -> auto___def_55 X1). tauto. exact (rem_470 epsilon_mknows_current_p__type_9 X1).
Defined.

Remark rem_472 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X2:term, auto___type_11 X2 -> auto___type_11 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_473 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2 X3:term, auto___def_55 X1 -> auto___type_11 X2 -> auto___type_10 X3 -> auto___type_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2 X3.
  cut (auto___type_11 X2 -> auto___type_11 X2). tauto. exact (rem_472 epsilon_mknows_current_p__type_9 X2).
Defined.

Remark rem_474 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X3:term, auto___type_10 X3 -> auto___type_10 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_475 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2 X3:term, auto___def_55 X1 -> auto___type_11 X2 -> auto___type_10 X3 -> auto___type_10 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2 X3.
  cut (auto___type_10 X3 -> auto___type_10 X3). tauto. exact (rem_474 epsilon_mknows_current_p__type_9 X3).
Defined.

Remark rem_476 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2 X3:term, auto___def_55 X1 -> auto___type_11 X2 -> auto___type_10 X3 -> (auto___def_55 X1 /\ auto___type_11 X2 /\ auto___type_10 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_55 X1). 2:apply (rem_471 epsilon_mknows_current_p__type_9 X1 X2 X3);  assumption.
  cut (auto___type_11 X2). 2:apply (rem_473 epsilon_mknows_current_p__type_9 X1 X2 X3);  assumption.
  cut (auto___type_10 X3). 2:apply (rem_475 epsilon_mknows_current_p__type_9 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_477 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2 X3:term, auto___def_55 X1 -> auto___type_11 X2 -> auto___type_10 X3 -> auto___type_9 (nonceb_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_476 epsilon_mknows_current_p__type_9 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_current_p__type_9 A1 A2 A3. intros. apply trans___type_9_nonceb_current_2;  tauto.
 clear  epsilon_mknows_current_p__type_9 A1 A2 A3. tauto.
Defined.

Remark rem_478 : forall X1 X2 X3:term, auto_knows_current (nonceb_current X1 X2 X3) -> or_2
    (auto___def_16 X1 /\ auto___type_5 X2 /\ auto___type_4 X3)
    (auto___def_55 X1 /\ auto___type_11 X2 /\ auto___type_10 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_479 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2 X3:term, auto_knows_current (nonceb_current X1 X2 X3) -> auto___type_9 (nonceb_current X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2 X3. intro H. intros.
  elim (rem_478 X1 X2 X3 H);  intros.
  apply (rem_469 epsilon_mknows_current_p__type_9 X1 X2 X3);  tauto.
  apply (rem_477 epsilon_mknows_current_p__type_9 X1 X2 X3);  tauto.
Defined.

Remark rem_480 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2 X3:term, auto___type_9 (nonceb_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2 X3.  case (rem_418 epsilon_mknows_current_p__type_9). clear  epsilon_mknows_current_p__type_9. intros. apply trans___type_9_nonceb_old_1;  tauto.
 clear  epsilon_mknows_current_p__type_9. tauto.
Defined.

Remark rem_481 : forall X1 X2 X3:term, auto_knows_current (nonceb_old X1 X2 X3) -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_482 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2 X3:term, auto_knows_current (nonceb_old X1 X2 X3) -> auto___type_9 (nonceb_old X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2 X3. intro H. intros.
  elim (rem_481 X1 X2 X3 H);  intros.
  apply (rem_480 epsilon_mknows_current_p__type_9 X1 X2 X3);  tauto.
Defined.

Remark rem_483 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto___def_71 X1 -> auto___def_71 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_484 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_71 X1 -> auto___type_13 X2 -> auto___def_71 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_71 X1 -> auto___def_71 X1). tauto. exact (rem_483 epsilon_mknows_current_p__type_9 X1).
Defined.

Remark rem_485 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X2:term, auto___type_13 X2 -> auto___type_13 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_486 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_71 X1 -> auto___type_13 X2 -> auto___type_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___type_13 X2 -> auto___type_13 X2). tauto. exact (rem_485 epsilon_mknows_current_p__type_9 X2).
Defined.

Remark rem_487 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_71 X1 -> auto___type_13 X2 -> (auto___def_71 X1 /\ auto___type_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  cut (auto___def_71 X1). 2:apply (rem_484 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  cut (auto___type_13 X2). 2:apply (rem_486 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_488 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_71 X1 -> auto___type_13 X2 -> auto___type_9 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  case (rem_487 epsilon_mknows_current_p__type_9 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_9 A1 A2. intros. apply trans___type_9_crypt_1;  tauto.
 clear  epsilon_mknows_current_p__type_9 A1 A2. tauto.
Defined.

Remark rem_489 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto___def_69 X1 -> auto___def_69 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_490 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_69 X1 -> auto___type_12 X2 -> auto___def_69 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_69 X1 -> auto___def_69 X1). tauto. exact (rem_489 epsilon_mknows_current_p__type_9 X1).
Defined.

Remark rem_491 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X2:term, auto___type_12 X2 -> auto___type_12 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_492 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_69 X1 -> auto___type_12 X2 -> auto___type_12 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___type_12 X2 -> auto___type_12 X2). tauto. exact (rem_491 epsilon_mknows_current_p__type_9 X2).
Defined.

Remark rem_493 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_69 X1 -> auto___type_12 X2 -> (auto___def_69 X1 /\ auto___type_12 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  cut (auto___def_69 X1). 2:apply (rem_490 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  cut (auto___type_12 X2). 2:apply (rem_492 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_494 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_69 X1 -> auto___type_12 X2 -> auto___type_9 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  case (rem_493 epsilon_mknows_current_p__type_9 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_9 A1 A2. intros. apply trans___type_9_crypt_2;  tauto.
 clear  epsilon_mknows_current_p__type_9 A1 A2. tauto.
Defined.

Remark rem_495 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto___def_12 X1 -> auto___def_12 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_496 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_12 X1). tauto. exact (rem_495 epsilon_mknows_current_p__type_9 X1).
Defined.

Remark rem_497 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X2:term, auto___def_13 X2 -> auto___def_13 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_498 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_497 epsilon_mknows_current_p__type_9 X2).
Defined.

Remark rem_499 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> (auto___def_12 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  cut (auto___def_12 X1). 2:apply (rem_496 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_498 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_500 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___type_9 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  case (rem_499 epsilon_mknows_current_p__type_9 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_9 A1 A2. intros. apply trans___type_9_crypt_3;  tauto.
 clear  epsilon_mknows_current_p__type_9 A1 A2. tauto.
Defined.

Remark rem_501 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto___def_61 X1 -> auto___def_61 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_502 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto___def_61 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_61 X1 -> auto___def_61 X1). tauto. exact (rem_501 epsilon_mknows_current_p__type_9 X1).
Defined.

Remark rem_503 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X2:term, auto___def_62 X2 -> auto___def_62 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_504 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto___def_62 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_62 X2 -> auto___def_62 X2). tauto. exact (rem_503 epsilon_mknows_current_p__type_9 X2).
Defined.

Remark rem_505 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> (auto___def_61 X1 /\ auto___def_62 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  cut (auto___def_61 X1). 2:apply (rem_502 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  cut (auto___def_62 X2). 2:apply (rem_504 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_506 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto___type_9 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  case (rem_505 epsilon_mknows_current_p__type_9 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_9 A1 A2. intros. apply trans___type_9_crypt_4;  tauto.
 clear  epsilon_mknows_current_p__type_9 A1 A2. tauto.
Defined.

Remark rem_507 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto___def_22 X1 -> auto___def_22 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_508 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_22 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_22 X1 -> auto___def_22 X1). tauto. exact (rem_507 epsilon_mknows_current_p__type_9 X1).
Defined.

Remark rem_509 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X2:term, auto___def_23 X2 -> auto___def_23 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_510 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_509 epsilon_mknows_current_p__type_9 X2).
Defined.

Remark rem_511 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> (auto___def_22 X1 /\ auto___def_23 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  cut (auto___def_22 X1). 2:apply (rem_508 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_510 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_512 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___type_9 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  case (rem_511 epsilon_mknows_current_p__type_9 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_9 A1 A2. intros. apply trans___type_9_crypt_5;  tauto.
 clear  epsilon_mknows_current_p__type_9 A1 A2. tauto.
Defined.

Remark rem_513 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1:term, auto___def_51 X1 -> auto___def_51 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_514 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto___def_52 X2 -> auto___def_51 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_51 X1 -> auto___def_51 X1). tauto. exact (rem_513 epsilon_mknows_current_p__type_9 X1).
Defined.

Remark rem_515 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X2:term, auto___def_52 X2 -> auto___def_52 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_516 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto___def_52 X2 -> auto___def_52 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.
  cut (auto___def_52 X2 -> auto___def_52 X2). tauto. exact (rem_515 epsilon_mknows_current_p__type_9 X2).
Defined.

Remark rem_517 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto___def_52 X2 -> (auto___def_51 X1 /\ auto___def_52 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  cut (auto___def_51 X1). 2:apply (rem_514 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  cut (auto___def_52 X2). 2:apply (rem_516 epsilon_mknows_current_p__type_9 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_518 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto___def_52 X2 -> auto___type_9 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  case (rem_517 epsilon_mknows_current_p__type_9 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_9 A1 A2. intros. apply trans___type_9_crypt_6;  tauto.
 clear  epsilon_mknows_current_p__type_9 A1 A2. tauto.
Defined.

Remark rem_519 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_9 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intros A1 A2.
  case (rem_429 epsilon_mknows_current_p__type_9 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_9 A1 A2. intros. apply trans___type_9_crypt_7;  tauto.
 clear  epsilon_mknows_current_p__type_9 A1 A2. tauto.
Defined.

Remark rem_520 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto_knows_current (crypt X1 X2) -> auto___type_9 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intro H. intros.
  elim (rem_312 X1 X2 H);  intros.
  apply (rem_488 epsilon_mknows_current_p__type_9 X1 X2);  tauto.
  apply (rem_494 epsilon_mknows_current_p__type_9 X1 X2);  tauto.
  apply (rem_500 epsilon_mknows_current_p__type_9 X1 X2);  tauto.
  apply (rem_506 epsilon_mknows_current_p__type_9 X1 X2);  tauto.
  apply (rem_512 epsilon_mknows_current_p__type_9 X1 X2);  tauto.
  apply (rem_518 epsilon_mknows_current_p__type_9 X1 X2);  tauto.
  apply (rem_519 epsilon_mknows_current_p__type_9 X1 X2);  tauto.
Defined.

Remark rem_521 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto___type_9 (noncea_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2.  case (rem_418 epsilon_mknows_current_p__type_9). clear  epsilon_mknows_current_p__type_9. intros. apply trans___type_9_noncea_old_1;  tauto.
 clear  epsilon_mknows_current_p__type_9. tauto.
Defined.

Remark rem_522 : forall X1 X2:term, auto_knows_current (noncea_old X1 X2) -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_523 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> forall X1 X2:term, auto_knows_current (noncea_old X1 X2) -> auto___type_9 (noncea_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intros X1 X2. intro H. intros.
  elim (rem_522 X1 X2 H);  intros.
  apply (rem_521 epsilon_mknows_current_p__type_9 X1 X2);  tauto.
Defined.

Remark rem_524 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> auto___type_9 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9.  case (rem_418 epsilon_mknows_current_p__type_9). clear  epsilon_mknows_current_p__type_9. intros. apply trans___type_9_server_1;  tauto.
 clear  epsilon_mknows_current_p__type_9. tauto.
Defined.

Remark rem_525 : auto_knows_current server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_526 : (forall X:term, auto_knows_current X -> auto___type_9 X)
    -> auto_knows_current server -> auto___type_9 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_9. intro H. intros.
  elim (rem_525 H);  intros.
  apply (rem_524 epsilon_mknows_current_p__type_9);  tauto.
Defined.

Remark rem_527 : forall X1 X2 X3:term, auto_knows_current (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_528 : forall X1 X2 X3:term, auto_knows_current (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_529 : auto_knows_current pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_530 : auto_knows_current prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_531 : auto_knows_current sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_532 : forall X1:term, auto_knows_current X1 -> auto___type_9 X1. (* Induct. *)
Proof.
  fix epsilon_mknows_current_p__type_9 1.
  intro X. case X.
  exact (rem_424 epsilon_mknows_current_p__type_9 ).
  exact (rem_421 epsilon_mknows_current_p__type_9 ).
  intros X1 X2;  exact (rem_432 epsilon_mknows_current_p__type_9 X1 X2).
  intros X1 X2;  exact (rem_520 epsilon_mknows_current_p__type_9 X1 X2).
  exact (rem_442 epsilon_mknows_current_p__type_9 ).
  intros X1 X2;  exact (rem_461 epsilon_mknows_current_p__type_9 X1 X2).
  exact (rem_439 epsilon_mknows_current_p__type_9 ).
  intros X1 X2;  exact (rem_417 epsilon_mknows_current_p__type_9 X1 X2).
  intros X1 X2;  exact (rem_523 epsilon_mknows_current_p__type_9 X1 X2).
  intros X1 X2 X3;  exact (rem_479 epsilon_mknows_current_p__type_9 X1 X2 X3).
  intros X1 X2 X3;  exact (rem_482 epsilon_mknows_current_p__type_9 X1 X2 X3).
   intro H. elim (rem_530  H).
   intro H. elim (rem_529  H).
  intros X1;  exact (rem_436 epsilon_mknows_current_p__type_9 X1).
  exact (rem_526 epsilon_mknows_current_p__type_9 ).
  intros X1 X2 X3. intro H. elim (rem_527 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_528 X1 X2 X3 H).
   intro H. elim (rem_531  H).
Qed.

Remark rem_533 : forall X1 X2 X3:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto___type_9 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_current X1 -> auto___type_9 X1). tauto. exact (rem_532 X1).
Qed.

Remark rem_534 : forall X1 X2 X3:term, auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X1 -> auto___type_9 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto___type_9 X1). tauto. exact (rem_533 X1 X2 X3).
Qed.

Remark rem_535 : forall X1 X2 X3:term, auto___def_50 X1 X2 X3 -> or_1
    (auto_knows_current X1 /\ auto_knows_current X2 /\ auto_knows_current X3)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_536 : forall X1 X2 X3:term, auto___def_50 X2 X3 X1 -> auto___type_9 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_535 X2 X3 X1 H);  intros.
  apply (rem_534 X1 X2 X3);  tauto.
Qed.

Remark rem_537 : forall X1:term, auto___def_27 X1 -> auto___def_27 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_538 : forall X1 X2:term, auto___def_27 X1 -> auto___def_28 X2 -> auto___def_27 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_27 X1 -> auto___def_27 X1). tauto. exact (rem_537 X1).
Qed.

Remark rem_539 : forall X2:term, auto___def_28 X2 -> auto___def_28 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_540 : forall X1 X2:term, auto___def_27 X1 -> auto___def_28 X2 -> auto___def_28 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_28 X2 -> auto___def_28 X2). tauto. exact (rem_539 X2).
Qed.

Remark rem_541 : forall X1 X2:term, auto___def_27 X1 -> auto___def_28 X2 -> (auto___def_27 X1 /\ auto___def_28 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_27 X1). 2:apply (rem_538 X1 X2);  assumption.
  cut (auto___def_28 X2). 2:apply (rem_540 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_542 : forall X1 X2:term, auto___def_27 X1 -> auto___def_28 X2 -> auto___def_26 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_541 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_26_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_543 : forall X1 X2:term, auto___def_28 X2 -> auto___def_27 X1 -> auto___def_26 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_27 X1 -> auto___def_28 X2 -> auto___def_26 (cons X1 X2)). tauto. exact (rem_542 X1 X2).
Qed.

Remark rem_544 : forall X1 X2:term, auto___def_26 X2 -> auto___type_5 X1 -> auto___type_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_5 X1 -> auto___type_5 X1). tauto. exact (rem_199 X1).
Qed.

Remark rem_545 : forall X2:term, auto___def_26 X2 -> auto___def_26 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_546 : forall X1 X2:term, auto___def_26 X2 -> auto___type_5 X1 -> auto___def_26 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_26 X2 -> auto___def_26 X2). tauto. exact (rem_545 X2).
Qed.

Remark rem_547 : forall X1 X2:term, auto___def_26 X2 -> auto___type_5 X1 -> (auto___type_5 X1 /\ auto___def_26 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_5 X1). 2:apply (rem_544 X1 X2);  assumption.
  cut (auto___def_26 X2). 2:apply (rem_546 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_548 : forall X1 X2:term, auto___def_26 X2 -> auto___type_5 X1 -> auto___def_29 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_547 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_29_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_549 : auto___def_57 sym. (* Deduce positive atom. *)
Proof.
   case rem_321. intros. apply trans___def_57_sym_1;  tauto.
 tauto.
Qed.

Remark rem_550 : forall X1:term, auto___type_3 X1 -> auto___type_3 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_551 : forall X1 X2:term, auto___def_14 X2 -> auto___type_3 X1 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_3 X1 -> auto___type_3 X1). tauto. exact (rem_550 X1).
Qed.

Remark rem_552 : forall X2:term, auto___def_14 X2 -> auto___def_14 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_553 : forall X1 X2:term, auto___def_14 X2 -> auto___type_3 X1 -> auto___def_14 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_14 X2 -> auto___def_14 X2). tauto. exact (rem_552 X2).
Qed.

Remark rem_554 : forall X1 X2:term, auto___def_14 X2 -> auto___type_3 X1 -> (auto___type_3 X1 /\ auto___def_14 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_3 X1). 2:apply (rem_551 X1 X2);  assumption.
  cut (auto___def_14 X2). 2:apply (rem_553 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_555 : forall X1 X2:term, auto___def_14 X2 -> auto___type_3 X1 -> auto___def_12 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_554 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_12_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_556 : forall X1:term, auto_knows_old (key pub X1) -> auto___def_4 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___def_4_1. Qed.

Remark rem_557 : forall X1 X2 X3:term, auto___def_29 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_558 : (forall X:term, auto___def_58 X -> auto___def_29 X -> False)
    -> forall X1 X2 X3:term, auto___def_29 (session_current X1 X2 X3) -> auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_58_m__def_29. intros X1 X2 X3. intro H. intros.
  elim (rem_557 X1 X2 X3 H);  intros.
Defined.

Remark rem_559 : forall X1 X2 X3:term, auto___def_58 (session_current X1 X2 X3) -> or_1
    (auto_knows_current X1 /\ auto_knows_current X2 /\ auto_knows_current X3)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_560 : (forall X:term, auto___def_58 X -> auto___def_29 X -> False)
    -> forall X1 X2 X3:term, auto___def_58 (session_current X1 X2 X3) -> auto___def_29 (session_current X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_58_m__def_29. intros X1 X2 X3. intro H. intros.
  elim (rem_559 X1 X2 X3 H);  intros.
  apply (rem_558 epsilon_m__def_58_m__def_29 X1 X2 X3);  tauto.
Defined.

Remark rem_561 : forall X1 X2:term, auto___def_58 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_562 : auto___def_58 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_563 : auto___def_58 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_564 : forall X1 X2:term, auto___def_58 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_565 : forall X1:term, auto___def_58 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_566 : auto___def_58 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_567 : auto___def_58 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_568 : forall X1 X2:term, auto___def_58 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_569 : forall X1 X2 X3:term, auto___def_58 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_570 : forall X1 X2 X3:term, auto___def_58 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_571 : forall X1 X2:term, auto___def_58 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_572 : forall X1 X2 X3:term, auto___def_58 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_573 : forall X1 X2:term, auto___def_58 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_574 : auto___def_58 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_575 : auto___def_58 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_576 : auto___def_58 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_577 : auto___def_58 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_578 : forall X2:term, auto___def_58 X2 -> auto___def_29 X2 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_58_m__def_29 1.
  intro X. case X.
   intro H. elim (rem_563  H).
   intro H. elim (rem_562  H).
  intros X1 X2. intro H. elim (rem_564 X1 X2 H).
  intros X1 X2. intro H. elim (rem_571 X1 X2 H).
   intro H. elim (rem_567  H).
  intros X1 X2. intro H. elim (rem_568 X1 X2 H).
   intro H. elim (rem_566  H).
  intros X1 X2. intro H. elim (rem_561 X1 X2 H).
  intros X1 X2. intro H. elim (rem_573 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_569 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_570 X1 X2 X3 H).
   intro H. elim (rem_576  H).
   intro H. elim (rem_574  H).
  intros X1. intro H. elim (rem_565 X1 H).
   intro H. elim (rem_575  H).
  intros X1 X2 X3;  exact (rem_560 epsilon_m__def_58_m__def_29 X1 X2 X3).
  intros X1 X2 X3. intro H. elim (rem_572 X1 X2 X3 H).
   intro H. elim (rem_577  H).
Qed.

Remark rem_579 : (forall X:term, auto___def_13 X -> auto___def_55 X -> False)
    -> forall X2:term, auto___def_58 X2 -> auto___def_29 X2 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_13_m__def_55. exact (rem_578).
Defined.

Remark rem_580 : (forall X:term, auto___def_13 X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_57 X1 -> auto___def_29 X2 -> auto___def_18 X1 -> auto___def_58 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_13_m__def_55. intros X1 X2.
  cut (auto___def_58 X2 -> auto___def_29 X2 -> False). clear  epsilon_m__def_13_m__def_55. tauto.
  exact (rem_579 epsilon_m__def_13_m__def_55 X2).
Defined.

Remark rem_581 : forall X1 X2:term, auto___def_55 (key X1 X2) -> or_1
    (auto___def_57 X1 /\ auto___def_58 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_582 : (forall X:term, auto___def_13 X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_55 (key X1 X2) -> auto___def_18 X1 -> auto___def_29 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_13_m__def_55. intros X1 X2. intro H. intros.
  elim (rem_581 X1 X2 H);  intros.
  apply (rem_580 epsilon_m__def_13_m__def_55 X1 X2);  tauto.
Defined.

Remark rem_583 : (forall X:term, auto___def_13 X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_13 (key X1 X2) -> auto___def_55 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_13_m__def_55. intros X1 X2. intro H. intros.
  elim (rem_167 X1 X2 H);  intros.
  apply (rem_582 epsilon_m__def_13_m__def_55 X1 X2);  tauto.
Defined.

Remark rem_584 : forall X1 X2:term, auto___def_13 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_585 : auto___def_13 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_586 : forall X1 X2 X3:term, auto___def_13 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_587 : auto___def_13 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_588 : forall X1 X2:term, auto___def_13 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_589 : forall X1:term, auto___def_13 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_590 : auto___def_13 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_591 : auto___def_13 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_592 : forall X1 X2 X3:term, auto___def_13 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_593 : forall X1 X2 X3:term, auto___def_13 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_594 : forall X1 X2:term, auto___def_13 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_595 : forall X1 X2 X3:term, auto___def_13 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_596 : forall X1 X2:term, auto___def_13 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_597 : auto___def_13 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_598 : auto___def_13 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_599 : auto___def_13 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_600 : auto___def_13 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_601 : forall X1:term, auto___def_13 X1 -> auto___def_55 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_13_m__def_55 1.
  intro X. case X.
   intro H. elim (rem_587  H).
   intro H. elim (rem_585  H).
  intros X1 X2. intro H. elim (rem_588 X1 X2 H).
  intros X1 X2. intro H. elim (rem_594 X1 X2 H).
   intro H. elim (rem_591  H).
  intros X1 X2;  exact (rem_583 epsilon_m__def_13_m__def_55 X1 X2).
   intro H. elim (rem_590  H).
  intros X1 X2. intro H. elim (rem_584 X1 X2 H).
  intros X1 X2. intro H. elim (rem_596 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_592 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_593 X1 X2 X3 H).
   intro H. elim (rem_599  H).
   intro H. elim (rem_597  H).
  intros X1. intro H. elim (rem_589 X1 H).
   intro H. elim (rem_598  H).
  intros X1 X2 X3. intro H. elim (rem_586 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_595 X1 X2 X3 H).
   intro H. elim (rem_600  H).
Qed.

Remark rem_602 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_55 X2 -> auto___def_71 (s X1). (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_601 X2)). tauto.
Qed.

Remark rem_603 : forall X1 X2:term, auto___def_13 X2 -> auto___def_55 X2 -> auto___def_12 X1 -> auto___def_71 (s X1). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_13 X2 -> auto___def_55 X2 -> auto___def_71 (s X1)). tauto. exact (rem_602 X1 X2).
Qed.

Remark rem_604 : forall X1 X2:term, auto___def_55 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_605 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_55 (noncea_current X1 X2) -> auto_agent X1 -> auto_agent X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1 X2. intro H. intros.
  elim (rem_604 X1 X2 H);  intros.
Defined.

Remark rem_606 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto_knows_current (noncea_current X1 X2) -> auto___def_55 (noncea_current X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1 X2. intro H. intros.
  elim (rem_416 X1 X2 H);  intros.
  apply (rem_605 epsilon_mknows_current_m__def_55 X1 X2);  tauto.
Defined.

Remark rem_607 : auto___def_55 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_608 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> auto___def_55 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intro H. intros.
  elim (rem_607 H);  intros.
Defined.

Remark rem_609 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> auto_knows_current bob -> auto___def_55 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intro H. intros.
  elim (rem_420 H);  intros.
  apply (rem_608 epsilon_mknows_current_m__def_55);  tauto.
Defined.

Remark rem_610 : auto___def_55 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_611 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> auto___def_55 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intro H. intros.
  elim (rem_610 H);  intros.
Defined.

Remark rem_612 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> auto_knows_current alice -> auto___def_55 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intro H. intros.
  elim (rem_423 H);  intros.
  apply (rem_611 epsilon_mknows_current_m__def_55);  tauto.
Defined.

Remark rem_613 : forall X1 X2:term, auto___def_55 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_614 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_55 (cons X1 X2) -> auto_knows_current X1 -> auto_knows_current X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1 X2. intro H. intros.
  elim (rem_613 X1 X2 H);  intros.
Defined.

Remark rem_615 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto_knows_current (cons X1 X2) -> auto___def_55 (cons X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1 X2. intro H. intros.
  elim (rem_431 X1 X2 H);  intros.
  apply (rem_614 epsilon_mknows_current_m__def_55 X1 X2);  tauto.
Defined.

Remark rem_616 : forall X1:term, auto___def_55 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_617 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1:term, auto___def_55 (s X1) -> auto_knows_current X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1. intro H. intros.
  elim (rem_616 X1 H);  intros.
Defined.

Remark rem_618 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1:term, auto_knows_current (s X1) -> auto___def_55 (s X1) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1. intro H. intros.
  elim (rem_435 X1 H);  intros.
  apply (rem_617 epsilon_mknows_current_m__def_55 X1);  tauto.
Defined.

Remark rem_619 : auto___def_55 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_620 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> auto___def_55 nil -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intro H. intros.
  elim (rem_619 H);  intros.
Defined.

Remark rem_621 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> auto_knows_current nil -> auto___def_55 nil -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intro H. intros.
  elim (rem_438 H);  intros.
  apply (rem_620 epsilon_mknows_current_m__def_55);  tauto.
Defined.

Remark rem_622 : auto___def_55 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_623 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> auto___def_55 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intro H. intros.
  elim (rem_622 H);  intros.
Defined.

Remark rem_624 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> auto_knows_current i -> auto___def_55 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intro H. intros.
  elim (rem_441 H);  intros.
  apply (rem_623 epsilon_mknows_current_m__def_55);  tauto.
Defined.

Remark rem_625 : forall X1 X2 X3:term, auto___def_40 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_626 : (forall X:term, auto___def_58 X -> auto___def_40 X -> False)
    -> forall X1 X2 X3:term, auto___def_40 (session_current X1 X2 X3) -> auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_58_m__def_40. intros X1 X2 X3. intro H. intros.
  elim (rem_625 X1 X2 X3 H);  intros.
Defined.

Remark rem_627 : (forall X:term, auto___def_58 X -> auto___def_40 X -> False)
    -> forall X1 X2 X3:term, auto___def_58 (session_current X1 X2 X3) -> auto___def_40 (session_current X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_58_m__def_40. intros X1 X2 X3. intro H. intros.
  elim (rem_559 X1 X2 X3 H);  intros.
  apply (rem_626 epsilon_m__def_58_m__def_40 X1 X2 X3);  tauto.
Defined.

Remark rem_628 : forall X2:term, auto___def_58 X2 -> auto___def_40 X2 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_58_m__def_40 1.
  intro X. case X.
   intro H. elim (rem_563  H).
   intro H. elim (rem_562  H).
  intros X1 X2. intro H. elim (rem_564 X1 X2 H).
  intros X1 X2. intro H. elim (rem_571 X1 X2 H).
   intro H. elim (rem_567  H).
  intros X1 X2. intro H. elim (rem_568 X1 X2 H).
   intro H. elim (rem_566  H).
  intros X1 X2. intro H. elim (rem_561 X1 X2 H).
  intros X1 X2. intro H. elim (rem_573 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_569 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_570 X1 X2 X3 H).
   intro H. elim (rem_576  H).
   intro H. elim (rem_574  H).
  intros X1. intro H. elim (rem_565 X1 H).
   intro H. elim (rem_575  H).
  intros X1 X2 X3;  exact (rem_627 epsilon_m__def_58_m__def_40 X1 X2 X3).
  intros X1 X2 X3. intro H. elim (rem_572 X1 X2 X3 H).
   intro H. elim (rem_577  H).
Qed.

Remark rem_629 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X2:term, auto___def_58 X2 -> auto___def_40 X2 -> False. (* Cut history. *)
Proof.  intros epsilon_mknows_current_m__def_55. exact (rem_628).
Defined.

Remark rem_630 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_57 X1 -> auto___def_58 X2 -> auto___def_40 X2 -> auto___def_39 X1 -> False. (* Split. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1 X2.
  cut (auto___def_58 X2 -> auto___def_40 X2 -> False). clear  epsilon_mknows_current_m__def_55. tauto.
  exact (rem_629 epsilon_mknows_current_m__def_55 X2).
Defined.

Remark rem_631 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_55 (key X1 X2) -> auto___def_39 X1 -> auto___def_40 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1 X2. intro H. intros.
  elim (rem_581 X1 X2 H);  intros.
  apply (rem_630 epsilon_mknows_current_m__def_55 X1 X2);  tauto.
Defined.

Remark rem_632 : (forall X:term, auto___def_57 X -> auto___def_35 X -> False)
    -> auto___def_35 sym -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_57_m__def_35. intro H. intros.
  elim (rem_239 H);  intros.
Defined.

Remark rem_633 : auto___def_57 sym -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_634 : (forall X:term, auto___def_57 X -> auto___def_35 X -> False)
    -> auto___def_57 sym -> auto___def_35 sym -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_57_m__def_35. intro H. intros.
  elim (rem_633 H);  intros.
  apply (rem_632 epsilon_m__def_57_m__def_35);  tauto.
Defined.

Remark rem_635 : forall X1 X2:term, auto___def_57 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_636 : auto___def_57 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_637 : forall X1 X2 X3:term, auto___def_57 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_638 : auto___def_57 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_639 : forall X1 X2:term, auto___def_57 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_640 : forall X1:term, auto___def_57 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_641 : auto___def_57 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_642 : auto___def_57 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_643 : forall X1 X2:term, auto___def_57 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_644 : forall X1 X2 X3:term, auto___def_57 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_645 : forall X1 X2 X3:term, auto___def_57 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_646 : forall X1 X2:term, auto___def_57 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_647 : forall X1 X2 X3:term, auto___def_57 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_648 : forall X1 X2:term, auto___def_57 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_649 : auto___def_57 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_650 : auto___def_57 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_651 : forall X1:term, auto___def_57 X1 -> auto___def_35 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_57_m__def_35 1.
  intro X. case X.
   intro H. elim (rem_638  H).
   intro H. elim (rem_636  H).
  intros X1 X2. intro H. elim (rem_639 X1 X2 H).
  intros X1 X2. intro H. elim (rem_646 X1 X2 H).
   intro H. elim (rem_642  H).
  intros X1 X2. intro H. elim (rem_643 X1 X2 H).
   intro H. elim (rem_641  H).
  intros X1 X2. intro H. elim (rem_635 X1 X2 H).
  intros X1 X2. intro H. elim (rem_648 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_644 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_645 X1 X2 X3 H).
   intro H. elim (rem_277  H).
   intro H. elim (rem_649  H).
  intros X1. intro H. elim (rem_640 X1 H).
   intro H. elim (rem_650  H).
  intros X1 X2 X3. intro H. elim (rem_637 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_647 X1 X2 X3 H).
  exact (rem_634 epsilon_m__def_57_m__def_35 ).
Qed.

Remark rem_652 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1:term, auto___def_57 X1 -> auto___def_35 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_mknows_current_m__def_55. exact (rem_651).
Defined.

Remark rem_653 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_57 X1 -> auto___type_8 X2 -> auto___def_35 X1 -> auto___def_58 X2 -> False. (* Split. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1 X2.
  cut (auto___def_57 X1 -> auto___def_35 X1 -> False). clear  epsilon_mknows_current_m__def_55. tauto.
  exact (rem_652 epsilon_mknows_current_m__def_55 X1).
Defined.

Remark rem_654 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_55 (key X1 X2) -> auto___def_35 X1 -> auto___type_8 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1 X2. intro H. intros.
  elim (rem_581 X1 X2 H);  intros.
  apply (rem_653 epsilon_mknows_current_m__def_55 X1 X2);  tauto.
Defined.

Remark rem_655 : auto___def_36 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_656 : (forall X:term, auto___def_57 X -> auto___def_36 X -> False)
    -> auto___def_36 sym -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_57_m__def_36. intro H. intros.
  elim (rem_655 H);  intros.
Defined.

Remark rem_657 : (forall X:term, auto___def_57 X -> auto___def_36 X -> False)
    -> auto___def_57 sym -> auto___def_36 sym -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_57_m__def_36. intro H. intros.
  elim (rem_633 H);  intros.
  apply (rem_656 epsilon_m__def_57_m__def_36);  tauto.
Defined.

Remark rem_658 : forall X1:term, auto___def_57 X1 -> auto___def_36 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_57_m__def_36 1.
  intro X. case X.
   intro H. elim (rem_638  H).
   intro H. elim (rem_636  H).
  intros X1 X2. intro H. elim (rem_639 X1 X2 H).
  intros X1 X2. intro H. elim (rem_646 X1 X2 H).
   intro H. elim (rem_642  H).
  intros X1 X2. intro H. elim (rem_643 X1 X2 H).
   intro H. elim (rem_641  H).
  intros X1 X2. intro H. elim (rem_635 X1 X2 H).
  intros X1 X2. intro H. elim (rem_648 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_644 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_645 X1 X2 X3 H).
   intro H. elim (rem_277  H).
   intro H. elim (rem_649  H).
  intros X1. intro H. elim (rem_640 X1 H).
   intro H. elim (rem_650  H).
  intros X1 X2 X3. intro H. elim (rem_637 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_647 X1 X2 X3 H).
  exact (rem_657 epsilon_m__def_57_m__def_36 ).
Qed.

Remark rem_659 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1:term, auto___def_57 X1 -> auto___def_36 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_mknows_current_m__def_55. exact (rem_658).
Defined.

Remark rem_660 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_57 X1 -> auto___def_58 X2 -> auto___def_36 X1 -> auto___def_37 X2 -> False. (* Split. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1 X2.
  cut (auto___def_57 X1 -> auto___def_36 X1 -> False). clear  epsilon_mknows_current_m__def_55. tauto.
  exact (rem_659 epsilon_mknows_current_m__def_55 X1).
Defined.

Remark rem_661 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_55 (key X1 X2) -> auto___def_36 X1 -> auto___def_37 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1 X2. intro H. intros.
  elim (rem_581 X1 X2 H);  intros.
  apply (rem_660 epsilon_mknows_current_m__def_55 X1 X2);  tauto.
Defined.

Remark rem_662 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto_knows_current (key X1 X2) -> auto___def_55 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1 X2. intro H. intros.
  elim (rem_310 X1 X2 H);  intros.
  apply (rem_631 epsilon_mknows_current_m__def_55 X1 X2);  tauto.
  apply (rem_654 epsilon_mknows_current_m__def_55 X1 X2);  tauto.
  apply (rem_661 epsilon_mknows_current_m__def_55 X1 X2);  tauto.
Defined.

Remark rem_663 : forall X1 X2 X3:term, auto___def_55 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_664 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1 X2 X3:term, auto___def_55 (nonceb_current X1 X2 X3) -> auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1 X2 X3. intro H. intros.
  elim (rem_663 X1 X2 X3 H);  intros.
Defined.

Remark rem_665 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1 X2 X3:term, auto___def_55 (nonceb_current X1 X2 X3) -> auto___def_55 X1 -> auto___type_11 X2 -> auto___type_10 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1 X2 X3. intro H. intros.
  elim (rem_663 X1 X2 X3 H);  intros.
Defined.

Remark rem_666 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1 X2 X3:term, auto_knows_current (nonceb_current X1 X2 X3) -> auto___def_55 (nonceb_current X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1 X2 X3. intro H. intros.
  elim (rem_478 X1 X2 X3 H);  intros.
  apply (rem_664 epsilon_mknows_current_m__def_55 X1 X2 X3);  tauto.
  apply (rem_665 epsilon_mknows_current_m__def_55 X1 X2 X3);  tauto.
Defined.

Remark rem_667 : forall X1 X2 X3:term, auto___def_55 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_668 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1 X2 X3:term, auto___def_55 (nonceb_old X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1 X2 X3. intro H. intros.
  elim (rem_667 X1 X2 X3 H);  intros.
Defined.

Remark rem_669 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1 X2 X3:term, auto_knows_current (nonceb_old X1 X2 X3) -> auto___def_55 (nonceb_old X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1 X2 X3. intro H. intros.
  elim (rem_481 X1 X2 X3 H);  intros.
  apply (rem_668 epsilon_mknows_current_m__def_55 X1 X2 X3);  tauto.
Defined.

Remark rem_670 : forall X1 X2:term, auto___def_55 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_671 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_55 (crypt X1 X2) -> auto___def_71 X1 -> auto___type_13 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1 X2. intro H. intros.
  elim (rem_670 X1 X2 H);  intros.
Defined.

Remark rem_672 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_55 (crypt X1 X2) -> auto___def_69 X1 -> auto___type_12 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1 X2. intro H. intros.
  elim (rem_670 X1 X2 H);  intros.
Defined.

Remark rem_673 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_55 (crypt X1 X2) -> auto___def_12 X1 -> auto___def_13 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1 X2. intro H. intros.
  elim (rem_670 X1 X2 H);  intros.
Defined.

Remark rem_674 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_55 (crypt X1 X2) -> auto___def_61 X1 -> auto___def_62 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1 X2. intro H. intros.
  elim (rem_670 X1 X2 H);  intros.
Defined.

Remark rem_675 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_55 (crypt X1 X2) -> auto___def_22 X1 -> auto___def_23 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1 X2. intro H. intros.
  elim (rem_670 X1 X2 H);  intros.
Defined.

Remark rem_676 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_55 (crypt X1 X2) -> auto___def_51 X1 -> auto___def_52 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1 X2. intro H. intros.
  elim (rem_670 X1 X2 H);  intros.
Defined.

Remark rem_677 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_55 (crypt X1 X2) -> auto_knows_current X1 -> auto_knows_current X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1 X2. intro H. intros.
  elim (rem_670 X1 X2 H);  intros.
Defined.

Remark rem_678 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto_knows_current (crypt X1 X2) -> auto___def_55 (crypt X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1 X2. intro H. intros.
  elim (rem_312 X1 X2 H);  intros.
  apply (rem_671 epsilon_mknows_current_m__def_55 X1 X2);  tauto.
  apply (rem_672 epsilon_mknows_current_m__def_55 X1 X2);  tauto.
  apply (rem_673 epsilon_mknows_current_m__def_55 X1 X2);  tauto.
  apply (rem_674 epsilon_mknows_current_m__def_55 X1 X2);  tauto.
  apply (rem_675 epsilon_mknows_current_m__def_55 X1 X2);  tauto.
  apply (rem_676 epsilon_mknows_current_m__def_55 X1 X2);  tauto.
  apply (rem_677 epsilon_mknows_current_m__def_55 X1 X2);  tauto.
Defined.

Remark rem_679 : forall X1 X2:term, auto___def_55 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_680 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_55 (noncea_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1 X2. intro H. intros.
  elim (rem_679 X1 X2 H);  intros.
Defined.

Remark rem_681 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto_knows_current (noncea_old X1 X2) -> auto___def_55 (noncea_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intros X1 X2. intro H. intros.
  elim (rem_522 X1 X2 H);  intros.
  apply (rem_680 epsilon_mknows_current_m__def_55 X1 X2);  tauto.
Defined.

Remark rem_682 : auto___def_55 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_683 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> auto___def_55 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intro H. intros.
  elim (rem_682 H);  intros.
Defined.

Remark rem_684 : (forall X:term, auto_knows_current X -> auto___def_55 X -> False)
    -> auto_knows_current server -> auto___def_55 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_55. intro H. intros.
  elim (rem_525 H);  intros.
  apply (rem_683 epsilon_mknows_current_m__def_55);  tauto.
Defined.

Remark rem_685 : forall X1:term, auto_knows_current X1 -> auto___def_55 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_mknows_current_m__def_55 1.
  intro X. case X.
  exact (rem_612 epsilon_mknows_current_m__def_55 ).
  exact (rem_609 epsilon_mknows_current_m__def_55 ).
  intros X1 X2;  exact (rem_615 epsilon_mknows_current_m__def_55 X1 X2).
  intros X1 X2;  exact (rem_678 epsilon_mknows_current_m__def_55 X1 X2).
  exact (rem_624 epsilon_mknows_current_m__def_55 ).
  intros X1 X2;  exact (rem_662 epsilon_mknows_current_m__def_55 X1 X2).
  exact (rem_621 epsilon_mknows_current_m__def_55 ).
  intros X1 X2;  exact (rem_606 epsilon_mknows_current_m__def_55 X1 X2).
  intros X1 X2;  exact (rem_681 epsilon_mknows_current_m__def_55 X1 X2).
  intros X1 X2 X3;  exact (rem_666 epsilon_mknows_current_m__def_55 X1 X2 X3).
  intros X1 X2 X3;  exact (rem_669 epsilon_mknows_current_m__def_55 X1 X2 X3).
   intro H. elim (rem_530  H).
   intro H. elim (rem_529  H).
  intros X1;  exact (rem_618 epsilon_mknows_current_m__def_55 X1).
  exact (rem_684 epsilon_mknows_current_m__def_55 ).
  intros X1 X2 X3. intro H. elim (rem_527 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_528 X1 X2 X3 H).
   intro H. elim (rem_531  H).
Qed.

Remark rem_686 : forall X1 X2:term, auto___def_55 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_71 (s X1). (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_685 X2)). tauto.
Qed.

Remark rem_687 : forall X1 X2:term, auto_knows_current X2 -> auto___def_55 X2 -> auto_knows_current X1 -> auto___def_71 (s X1). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_55 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_71 (s X1)). tauto. exact (rem_686 X1 X2).
Qed.

Remark rem_688 : forall X1:term, auto___def_69 X1 -> auto___def_69 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_689 : forall X1 X2:term, auto___def_55 X2 -> auto___def_69 X1 -> auto___type_12 X2 -> auto___def_69 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_69 X1 -> auto___def_69 X1). tauto. exact (rem_688 X1).
Qed.

Remark rem_690 : forall X1 X2:term, auto___def_55 X2 -> auto___def_69 X1 -> auto___type_12 X2 -> auto___def_69 X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_69 X1). 2:apply (rem_689 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_691 : forall X1 X2:term, auto___def_55 X2 -> auto___def_69 X1 -> auto___type_12 X2 -> auto___def_71 (s X1). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_690 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_71_s_2;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_692 : forall X1 X2:term, auto___type_12 X2 -> auto___def_55 X2 -> auto___def_69 X1 -> auto___def_71 (s X1). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_55 X2 -> auto___def_69 X1 -> auto___type_12 X2 -> auto___def_71 (s X1)). tauto. exact (rem_691 X1 X2).
Qed.

Remark rem_693 : (forall X:term, auto___def_25 X -> auto___def_58 X -> False)
    -> forall X1 X2:term, auto___def_58 (cons X1 X2) -> auto___type_4 X1 -> auto___def_26 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_25_m__def_58. intros X1 X2. intro H. intros.
  elim (rem_564 X1 X2 H);  intros.
Defined.

Remark rem_694 : forall X1 X2:term, auto___def_25 (cons X1 X2) -> or_1
    (auto___type_4 X1 /\ auto___def_26 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_695 : (forall X:term, auto___def_25 X -> auto___def_58 X -> False)
    -> forall X1 X2:term, auto___def_25 (cons X1 X2) -> auto___def_58 (cons X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_25_m__def_58. intros X1 X2. intro H. intros.
  elim (rem_694 X1 X2 H);  intros.
  apply (rem_693 epsilon_m__def_25_m__def_58 X1 X2);  tauto.
Defined.

Remark rem_696 : forall X1 X2:term, auto___def_25 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_697 : auto___def_25 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_698 : forall X1 X2 X3:term, auto___def_25 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_699 : auto___def_25 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_700 : forall X1:term, auto___def_25 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_701 : auto___def_25 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_702 : auto___def_25 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_703 : forall X1 X2:term, auto___def_25 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_704 : forall X1 X2 X3:term, auto___def_25 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_705 : forall X1 X2 X3:term, auto___def_25 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_706 : forall X1 X2:term, auto___def_25 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_707 : forall X1 X2 X3:term, auto___def_25 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_708 : forall X1 X2:term, auto___def_25 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_709 : auto___def_25 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_710 : auto___def_25 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_711 : auto___def_25 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_712 : auto___def_25 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_713 : forall X2:term, auto___def_25 X2 -> auto___def_58 X2 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_25_m__def_58 1.
  intro X. case X.
   intro H. elim (rem_699  H).
   intro H. elim (rem_697  H).
  intros X1 X2;  exact (rem_695 epsilon_m__def_25_m__def_58 X1 X2).
  intros X1 X2. intro H. elim (rem_706 X1 X2 H).
   intro H. elim (rem_702  H).
  intros X1 X2. intro H. elim (rem_703 X1 X2 H).
   intro H. elim (rem_701  H).
  intros X1 X2. intro H. elim (rem_696 X1 X2 H).
  intros X1 X2. intro H. elim (rem_708 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_704 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_705 X1 X2 X3 H).
   intro H. elim (rem_711  H).
   intro H. elim (rem_709  H).
  intros X1. intro H. elim (rem_700 X1 H).
   intro H. elim (rem_710  H).
  intros X1 X2 X3. intro H. elim (rem_698 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_707 X1 X2 X3 H).
   intro H. elim (rem_712  H).
Qed.

Remark rem_714 : (forall X:term, auto___def_23 X -> auto___def_55 X -> False)
    -> forall X2:term, auto___def_25 X2 -> auto___def_58 X2 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_23_m__def_55. exact (rem_713).
Defined.

Remark rem_715 : (forall X:term, auto___def_23 X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_57 X1 -> auto___def_18 X1 -> auto___def_58 X2 -> auto___def_25 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_23_m__def_55. intros X1 X2.
  cut (auto___def_25 X2 -> auto___def_58 X2 -> False). clear  epsilon_m__def_23_m__def_55. tauto.
  exact (rem_714 epsilon_m__def_23_m__def_55 X2).
Defined.

Remark rem_716 : (forall X:term, auto___def_23 X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_55 (key X1 X2) -> auto___def_18 X1 -> auto___def_25 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_23_m__def_55. intros X1 X2. intro H. intros.
  elim (rem_581 X1 X2 H);  intros.
  apply (rem_715 epsilon_m__def_23_m__def_55 X1 X2);  tauto.
Defined.

Remark rem_717 : (forall X:term, auto___def_23 X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_23 (key X1 X2) -> auto___def_55 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_23_m__def_55. intros X1 X2. intro H. intros.
  elim (rem_174 X1 X2 H);  intros.
  apply (rem_716 epsilon_m__def_23_m__def_55 X1 X2);  tauto.
Defined.

Remark rem_718 : forall X1 X2:term, auto___def_23 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_719 : auto___def_23 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_720 : forall X1 X2 X3:term, auto___def_23 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_721 : auto___def_23 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_722 : forall X1 X2:term, auto___def_23 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_723 : forall X1:term, auto___def_23 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_724 : auto___def_23 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_725 : auto___def_23 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_726 : forall X1 X2 X3:term, auto___def_23 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_727 : forall X1 X2 X3:term, auto___def_23 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_728 : forall X1 X2:term, auto___def_23 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_729 : forall X1 X2 X3:term, auto___def_23 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_730 : forall X1 X2:term, auto___def_23 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_731 : auto___def_23 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_732 : auto___def_23 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_733 : auto___def_23 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_734 : auto___def_23 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_735 : forall X1:term, auto___def_23 X1 -> auto___def_55 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_23_m__def_55 1.
  intro X. case X.
   intro H. elim (rem_721  H).
   intro H. elim (rem_719  H).
  intros X1 X2. intro H. elim (rem_722 X1 X2 H).
  intros X1 X2. intro H. elim (rem_728 X1 X2 H).
   intro H. elim (rem_725  H).
  intros X1 X2;  exact (rem_717 epsilon_m__def_23_m__def_55 X1 X2).
   intro H. elim (rem_724  H).
  intros X1 X2. intro H. elim (rem_718 X1 X2 H).
  intros X1 X2. intro H. elim (rem_730 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_726 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_727 X1 X2 X3 H).
   intro H. elim (rem_733  H).
   intro H. elim (rem_731  H).
  intros X1. intro H. elim (rem_723 X1 H).
   intro H. elim (rem_732  H).
  intros X1 X2 X3. intro H. elim (rem_720 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_729 X1 X2 X3 H).
   intro H. elim (rem_734  H).
Qed.

Remark rem_736 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_55 X2 -> auto___def_71 (s X1). (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_735 X2)). tauto.
Qed.

Remark rem_737 : forall X1 X2:term, auto___def_23 X2 -> auto___def_55 X2 -> auto___def_22 X1 -> auto___def_71 (s X1). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_22 X1 -> auto___def_23 X2 -> auto___def_55 X2 -> auto___def_71 (s X1)). tauto. exact (rem_736 X1 X2).
Qed.

Remark rem_738 : forall X1:term, auto___def_71 X1 -> auto___def_71 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_739 : forall X1 X2:term, auto___def_55 X2 -> auto___def_71 X1 -> auto___type_13 X2 -> auto___def_71 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_71 X1 -> auto___def_71 X1). tauto. exact (rem_738 X1).
Qed.

Remark rem_740 : forall X1 X2:term, auto___def_55 X2 -> auto___def_71 X1 -> auto___type_13 X2 -> auto___def_71 X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_71 X1). 2:apply (rem_739 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_741 : forall X1 X2:term, auto___def_55 X2 -> auto___def_71 X1 -> auto___type_13 X2 -> auto___def_71 (s X1). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_740 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_71_s_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_742 : forall X1 X2:term, auto___def_55 X2 -> auto___type_13 X2 -> auto___def_71 X1 -> auto___def_71 (s X1). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_55 X2 -> auto___def_71 X1 -> auto___type_13 X2 -> auto___def_71 (s X1)). tauto. exact (rem_741 X1 X2).
Qed.

Remark rem_743 : forall X1 X2 X3:term, auto___def_64 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_744 : (forall X:term, auto___def_58 X -> auto___def_64 X -> False)
    -> forall X1 X2 X3:term, auto___def_64 (session_current X1 X2 X3) -> auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_58_m__def_64. intros X1 X2 X3. intro H. intros.
  elim (rem_743 X1 X2 X3 H);  intros.
Defined.

Remark rem_745 : (forall X:term, auto___def_58 X -> auto___def_64 X -> False)
    -> forall X1 X2 X3:term, auto___def_58 (session_current X1 X2 X3) -> auto___def_64 (session_current X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_58_m__def_64. intros X1 X2 X3. intro H. intros.
  elim (rem_559 X1 X2 X3 H);  intros.
  apply (rem_744 epsilon_m__def_58_m__def_64 X1 X2 X3);  tauto.
Defined.

Remark rem_746 : forall X2:term, auto___def_58 X2 -> auto___def_64 X2 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_58_m__def_64 1.
  intro X. case X.
   intro H. elim (rem_563  H).
   intro H. elim (rem_562  H).
  intros X1 X2. intro H. elim (rem_564 X1 X2 H).
  intros X1 X2. intro H. elim (rem_571 X1 X2 H).
   intro H. elim (rem_567  H).
  intros X1 X2. intro H. elim (rem_568 X1 X2 H).
   intro H. elim (rem_566  H).
  intros X1 X2. intro H. elim (rem_561 X1 X2 H).
  intros X1 X2. intro H. elim (rem_573 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_569 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_570 X1 X2 X3 H).
   intro H. elim (rem_576  H).
   intro H. elim (rem_574  H).
  intros X1. intro H. elim (rem_565 X1 H).
   intro H. elim (rem_575  H).
  intros X1 X2 X3;  exact (rem_745 epsilon_m__def_58_m__def_64 X1 X2 X3).
  intros X1 X2 X3. intro H. elim (rem_572 X1 X2 X3 H).
   intro H. elim (rem_577  H).
Qed.

Remark rem_747 : (forall X:term, auto___def_62 X -> auto___def_55 X -> False)
    -> forall X2:term, auto___def_58 X2 -> auto___def_64 X2 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_62_m__def_55. exact (rem_746).
Defined.

Remark rem_748 : (forall X:term, auto___def_62 X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_57 X1 -> auto___def_58 X2 -> auto___def_64 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_62_m__def_55. intros X1 X2.
  cut (auto___def_58 X2 -> auto___def_64 X2 -> False). clear  epsilon_m__def_62_m__def_55. tauto.
  exact (rem_747 epsilon_m__def_62_m__def_55 X2).
Defined.

Remark rem_749 : (forall X:term, auto___def_62 X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_55 (key X1 X2) -> auto___def_57 X1 -> auto___def_64 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_62_m__def_55. intros X1 X2. intro H. intros.
  elim (rem_581 X1 X2 H);  intros.
  apply (rem_748 epsilon_m__def_62_m__def_55 X1 X2);  tauto.
Defined.

Remark rem_750 : (forall X:term, auto___def_62 X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_62 (key X1 X2) -> auto___def_55 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_62_m__def_55. intros X1 X2. intro H. intros.
  elim (rem_291 X1 X2 H);  intros.
  apply (rem_749 epsilon_m__def_62_m__def_55 X1 X2);  tauto.
Defined.

Remark rem_751 : forall X1 X2:term, auto___def_62 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_752 : auto___def_62 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_753 : forall X1 X2 X3:term, auto___def_62 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_754 : auto___def_62 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_755 : forall X1 X2:term, auto___def_62 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_756 : forall X1:term, auto___def_62 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_757 : auto___def_62 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_758 : auto___def_62 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_759 : forall X1 X2 X3:term, auto___def_62 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_760 : forall X1 X2 X3:term, auto___def_62 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_761 : forall X1 X2:term, auto___def_62 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_762 : forall X1 X2 X3:term, auto___def_62 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_763 : forall X1 X2:term, auto___def_62 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_764 : auto___def_62 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_765 : auto___def_62 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_766 : auto___def_62 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_767 : auto___def_62 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_768 : forall X1:term, auto___def_62 X1 -> auto___def_55 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_62_m__def_55 1.
  intro X. case X.
   intro H. elim (rem_754  H).
   intro H. elim (rem_752  H).
  intros X1 X2. intro H. elim (rem_755 X1 X2 H).
  intros X1 X2. intro H. elim (rem_761 X1 X2 H).
   intro H. elim (rem_758  H).
  intros X1 X2;  exact (rem_750 epsilon_m__def_62_m__def_55 X1 X2).
   intro H. elim (rem_757  H).
  intros X1 X2. intro H. elim (rem_751 X1 X2 H).
  intros X1 X2. intro H. elim (rem_763 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_759 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_760 X1 X2 X3 H).
   intro H. elim (rem_766  H).
   intro H. elim (rem_764  H).
  intros X1. intro H. elim (rem_756 X1 H).
   intro H. elim (rem_765  H).
  intros X1 X2 X3. intro H. elim (rem_753 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_762 X1 X2 X3 H).
   intro H. elim (rem_767  H).
Qed.

Remark rem_769 : forall X1 X2:term, auto___def_55 X2 -> auto___def_61 X1 -> auto___def_62 X2 -> auto___def_71 (s X1). (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_768 X2)). tauto.
Qed.

Remark rem_770 : forall X1 X2:term, auto___def_62 X2 -> auto___def_55 X2 -> auto___def_61 X1 -> auto___def_71 (s X1). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_55 X2 -> auto___def_61 X1 -> auto___def_62 X2 -> auto___def_71 (s X1)). tauto. exact (rem_769 X1 X2).
Qed.

Remark rem_771 : forall X1 X2 X3:term, auto___def_66 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_772 : (forall X:term, auto___def_58 X -> auto___def_66 X -> False)
    -> forall X1 X2 X3:term, auto___def_66 (session_current X1 X2 X3) -> auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_58_m__def_66. intros X1 X2 X3. intro H. intros.
  elim (rem_771 X1 X2 X3 H);  intros.
Defined.

Remark rem_773 : (forall X:term, auto___def_58 X -> auto___def_66 X -> False)
    -> forall X1 X2 X3:term, auto___def_58 (session_current X1 X2 X3) -> auto___def_66 (session_current X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_58_m__def_66. intros X1 X2 X3. intro H. intros.
  elim (rem_559 X1 X2 X3 H);  intros.
  apply (rem_772 epsilon_m__def_58_m__def_66 X1 X2 X3);  tauto.
Defined.

Remark rem_774 : forall X2:term, auto___def_58 X2 -> auto___def_66 X2 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_58_m__def_66 1.
  intro X. case X.
   intro H. elim (rem_563  H).
   intro H. elim (rem_562  H).
  intros X1 X2. intro H. elim (rem_564 X1 X2 H).
  intros X1 X2. intro H. elim (rem_571 X1 X2 H).
   intro H. elim (rem_567  H).
  intros X1 X2. intro H. elim (rem_568 X1 X2 H).
   intro H. elim (rem_566  H).
  intros X1 X2. intro H. elim (rem_561 X1 X2 H).
  intros X1 X2. intro H. elim (rem_573 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_569 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_570 X1 X2 X3 H).
   intro H. elim (rem_576  H).
   intro H. elim (rem_574  H).
  intros X1. intro H. elim (rem_565 X1 H).
   intro H. elim (rem_575  H).
  intros X1 X2 X3;  exact (rem_773 epsilon_m__def_58_m__def_66 X1 X2 X3).
  intros X1 X2 X3. intro H. elim (rem_572 X1 X2 X3 H).
   intro H. elim (rem_577  H).
Qed.

Remark rem_775 : (forall X:term, auto___def_52 X -> auto___def_55 X -> False)
    -> forall X2:term, auto___def_58 X2 -> auto___def_66 X2 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_52_m__def_55. exact (rem_774).
Defined.

Remark rem_776 : (forall X:term, auto___def_52 X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_57 X1 -> auto___def_66 X2 -> auto___def_58 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_52_m__def_55. intros X1 X2.
  cut (auto___def_58 X2 -> auto___def_66 X2 -> False). clear  epsilon_m__def_52_m__def_55. tauto.
  exact (rem_775 epsilon_m__def_52_m__def_55 X2).
Defined.

Remark rem_777 : (forall X:term, auto___def_52 X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_55 (key X1 X2) -> auto___def_57 X1 -> auto___def_66 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_52_m__def_55. intros X1 X2. intro H. intros.
  elim (rem_581 X1 X2 H);  intros.
  apply (rem_776 epsilon_m__def_52_m__def_55 X1 X2);  tauto.
Defined.

Remark rem_778 : (forall X:term, auto___def_52 X -> auto___def_55 X -> False)
    -> forall X1 X2:term, auto___def_52 (key X1 X2) -> auto___def_55 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_52_m__def_55. intros X1 X2. intro H. intros.
  elim (rem_298 X1 X2 H);  intros.
  apply (rem_777 epsilon_m__def_52_m__def_55 X1 X2);  tauto.
Defined.

Remark rem_779 : forall X1 X2:term, auto___def_52 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_780 : auto___def_52 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_781 : forall X1 X2 X3:term, auto___def_52 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_782 : auto___def_52 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_783 : forall X1 X2:term, auto___def_52 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_784 : forall X1:term, auto___def_52 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_785 : auto___def_52 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_786 : auto___def_52 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_787 : forall X1 X2 X3:term, auto___def_52 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_788 : forall X1 X2 X3:term, auto___def_52 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_789 : forall X1 X2:term, auto___def_52 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_790 : forall X1 X2 X3:term, auto___def_52 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_791 : forall X1 X2:term, auto___def_52 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_792 : auto___def_52 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_793 : auto___def_52 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_794 : auto___def_52 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_795 : auto___def_52 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_796 : forall X1:term, auto___def_52 X1 -> auto___def_55 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_52_m__def_55 1.
  intro X. case X.
   intro H. elim (rem_782  H).
   intro H. elim (rem_780  H).
  intros X1 X2. intro H. elim (rem_783 X1 X2 H).
  intros X1 X2. intro H. elim (rem_789 X1 X2 H).
   intro H. elim (rem_786  H).
  intros X1 X2;  exact (rem_778 epsilon_m__def_52_m__def_55 X1 X2).
   intro H. elim (rem_785  H).
  intros X1 X2. intro H. elim (rem_779 X1 X2 H).
  intros X1 X2. intro H. elim (rem_791 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_787 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_788 X1 X2 X3 H).
   intro H. elim (rem_794  H).
   intro H. elim (rem_792  H).
  intros X1. intro H. elim (rem_784 X1 H).
   intro H. elim (rem_793  H).
  intros X1 X2 X3. intro H. elim (rem_781 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_790 X1 X2 X3 H).
   intro H. elim (rem_795  H).
Qed.

Remark rem_797 : forall X1 X2:term, auto___def_51 X1 -> auto___def_52 X2 -> auto___def_55 X2 -> auto___def_71 (s X1). (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_796 X2)). tauto.
Qed.

Remark rem_798 : forall X1 X2:term, auto___def_52 X2 -> auto___def_55 X2 -> auto___def_51 X1 -> auto___def_71 (s X1). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_51 X1 -> auto___def_52 X2 -> auto___def_55 X2 -> auto___def_71 (s X1)). tauto. exact (rem_797 X1 X2).
Qed.

Remark rem_799 : forall X1 X2:term, auto___def_70 X1 X2 -> or_7
    (auto___def_13 X1 /\ auto___def_55 X1 /\ auto___def_12 X2)
    (auto_knows_current X1 /\ auto___def_55 X1 /\ auto_knows_current X2)
    (auto___type_12 X1 /\ auto___def_55 X1 /\ auto___def_69 X2)
    (auto___def_23 X1 /\ auto___def_55 X1 /\ auto___def_22 X2)
    (auto___def_55 X1 /\ auto___type_13 X1 /\ auto___def_71 X2)
    (auto___def_62 X1 /\ auto___def_55 X1 /\ auto___def_61 X2)
    (auto___def_52 X1 /\ auto___def_55 X1 /\ auto___def_51 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_7_intro_1; tauto.
  intros. apply or_7_intro_2; tauto.
  intros. apply or_7_intro_3; tauto.
  intros. apply or_7_intro_4; tauto.
  intros. apply or_7_intro_5; tauto.
  intros. apply or_7_intro_6; tauto.
  intros. apply or_7_intro_7; tauto.
Qed.

Remark rem_800 : forall X1 X2:term, auto___def_70 X2 X1 -> auto___def_71 (s X1). (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_799 X2 X1 H);  intros.
  apply (rem_603 X1 X2);  tauto.
  apply (rem_687 X1 X2);  tauto.
  apply (rem_692 X1 X2);  tauto.
  apply (rem_737 X1 X2);  tauto.
  apply (rem_742 X1 X2);  tauto.
  apply (rem_770 X1 X2);  tauto.
  apply (rem_798 X1 X2);  tauto.
Qed.

Remark rem_801 : forall X1 X2:term, auto___def_71 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_802 : forall X1 X2 X3 X4:term, auto___def_71 (cons (noncea_current X1 X2) (cons X2 (cons X3 (cons X4 nil)))) -> auto___type_13 (key sym (cons X1 (cons server nil))) -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_801 (noncea_current X1 X2) (cons X2 (cons X3 (cons X4 nil))) H);  intros.
Qed.

Remark rem_803 : forall X1 X2:term, auto___def_69 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_804 : forall X1 X2 X3 X4:term, auto___def_69 (cons (noncea_current X1 X2) (cons X2 (cons X3 (cons X4 nil)))) -> auto___type_12 (key sym (cons X1 (cons server nil))) -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_803 (noncea_current X1 X2) (cons X2 (cons X3 (cons X4 nil))) H);  intros.
Qed.

Remark rem_805 : forall X1 X2:term, auto___type_3 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_806 : forall X1 X2 X3 X4:term, auto___def_16 X3 -> auto___def_20 X4 -> auto___type_3 (noncea_current X1 X2) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_805 X1 X2 H);  intros.
Qed.

Remark rem_807 : forall X1 X2 X3 X4:term, auto___def_16 X3 -> auto___def_20 X4 -> auto___def_26 (cons server nil) -> auto___type_3 (noncea_current X1 X2) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_67 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_16 X3 -> auto___def_20 X4 -> auto___type_3 (noncea_current X1 X2) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_67 X1 X2 X3 X4). tauto.
  exact (rem_806 X1 X2 X3 X4).
Qed.

Remark rem_808 : forall X1 X2 X3 X4:term, auto___type_5 X1 -> auto___def_26 (cons server nil) -> auto___def_16 X3 -> auto___def_20 X4 -> auto___type_3 (noncea_current X1 X2) -> auto___type_4 X2 -> auto___def_67 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_16 X3 -> auto___def_20 X4 -> auto___def_26 (cons server nil) -> auto___type_3 (noncea_current X1 X2) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_67 X1 X2 X3 X4). tauto. exact (rem_807 X1 X2 X3 X4).
Qed.

Remark rem_809 : forall X1 X2 X3 X4:term, auto___def_16 X3 -> auto___def_20 X4 -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_current X1 X2) -> auto___type_4 X2 -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_216 X1 (cons server nil) H);  intros.
  apply (rem_808 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_810 : forall X1 X2 X3 X4:term, auto___def_16 X3 -> auto___def_20 X4 -> auto___def_21 nil -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_current X1 X2) -> auto___type_4 X2 -> auto___def_67 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_16 X3 -> auto___def_20 X4 -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_current X1 X2) -> auto___type_4 X2 -> auto___def_67 X1 X2 X3 X4). tauto.
  exact (rem_809 X1 X2 X3 X4).
Qed.

Remark rem_811 : forall X1 X2 X3 X4:term, auto___def_20 X4 -> auto___def_21 nil -> auto___def_16 X3 -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_current X1 X2) -> auto___type_4 X2 -> auto___def_67 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_16 X3 -> auto___def_20 X4 -> auto___def_21 nil -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_current X1 X2) -> auto___type_4 X2 -> auto___def_67 X1 X2 X3 X4). tauto. exact (rem_810 X1 X2 X3 X4).
Qed.

Remark rem_812 : forall X1 X2 X3 X4:term, auto___def_16 X3 -> auto___def_17 (cons X4 nil) -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_current X1 X2) -> auto___type_4 X2 -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_220 X4 nil H);  intros.
  apply (rem_811 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_813 : forall X1 X2 X3 X4:term, auto___def_15 (cons X3 (cons X4 nil)) -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_current X1 X2) -> auto___type_4 X2 -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_222 X3 (cons X4 nil) H);  intros.
  apply (rem_812 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_814 : forall X1 X2 X3 X4:term, auto___type_4 X2 -> auto___def_15 (cons X3 (cons X4 nil)) -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_15 (cons X3 (cons X4 nil)) -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_current X1 X2) -> auto___type_4 X2 -> auto___def_67 X1 X2 X3 X4). tauto. exact (rem_813 X1 X2 X3 X4).
Qed.

Remark rem_815 : forall X1 X2 X3 X4:term, auto___def_14 (cons X2 (cons X3 (cons X4 nil))) -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_225 X2 (cons X3 (cons X4 nil)) H);  intros.
  apply (rem_814 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_816 : forall X1 X2 X3 X4:term, auto___def_14 (cons X2 (cons X3 (cons X4 nil))) -> auto___def_18 sym -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_14 (cons X2 (cons X3 (cons X4 nil))) -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4). tauto.
  exact (rem_815 X1 X2 X3 X4).
Qed.

Remark rem_817 : forall X1 X2 X3 X4:term, auto___def_18 sym -> auto___def_29 (cons X1 (cons server nil)) -> auto___def_14 (cons X2 (cons X3 (cons X4 nil))) -> auto___type_3 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_14 (cons X2 (cons X3 (cons X4 nil))) -> auto___def_18 sym -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4). tauto. exact (rem_816 X1 X2 X3 X4).
Qed.

Remark rem_818 : forall X1 X2 X3 X4:term, auto___def_13 (key sym (cons X1 (cons server nil))) -> auto___def_14 (cons X2 (cons X3 (cons X4 nil))) -> auto___type_3 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_167 sym (cons X1 (cons server nil)) H);  intros.
  apply (rem_817 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_819 : forall X1 X2 X3 X4:term, auto___type_3 (noncea_current X1 X2) -> auto___def_14 (cons X2 (cons X3 (cons X4 nil))) -> auto___def_13 (key sym (cons X1 (cons server nil))) -> auto___def_67 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_13 (key sym (cons X1 (cons server nil))) -> auto___def_14 (cons X2 (cons X3 (cons X4 nil))) -> auto___type_3 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4). tauto. exact (rem_818 X1 X2 X3 X4).
Qed.

Remark rem_820 : forall X1 X2 X3 X4:term, auto___def_12 (cons (noncea_current X1 X2) (cons X2 (cons X3 (cons X4 nil)))) -> auto___def_13 (key sym (cons X1 (cons server nil))) -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_231 (noncea_current X1 X2) (cons X2 (cons X3 (cons X4 nil))) H);  intros.
  apply (rem_819 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_821 : forall X1 X2 X3 X4:term, auto___def_55 (noncea_current X1 X2) -> auto___def_62 (key sym (cons X1 (cons server nil))) -> auto___def_63 (cons X2 (cons X3 (cons X4 nil))) -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_604 X1 X2 H);  intros.
Qed.

Remark rem_822 : forall X1 X2 X3 X4:term, auto___def_55 (noncea_current X1 X2) -> auto___def_63 (cons X2 (cons X3 (cons X4 nil))) -> auto___def_62 (key sym (cons X1 (cons server nil))) -> auto___def_67 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_55 (noncea_current X1 X2) -> auto___def_62 (key sym (cons X1 (cons server nil))) -> auto___def_63 (cons X2 (cons X3 (cons X4 nil))) -> auto___def_67 X1 X2 X3 X4). tauto. exact (rem_821 X1 X2 X3 X4).
Qed.

Remark rem_823 : forall X1 X2:term, auto___def_61 (cons X1 X2) -> or_1
    (auto___def_55 X1 /\ auto___def_63 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_824 : forall X1 X2 X3 X4:term, auto___def_61 (cons (noncea_current X1 X2) (cons X2 (cons X3 (cons X4 nil)))) -> auto___def_62 (key sym (cons X1 (cons server nil))) -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_823 (noncea_current X1 X2) (cons X2 (cons X3 (cons X4 nil))) H);  intros.
  apply (rem_822 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_825 : forall X1 X2 X3 X4:term, auto___def_16 (noncea_current X1 X2) -> auto___def_23 (key sym (cons X1 (cons server nil))) -> auto___def_24 (cons X2 (cons X3 (cons X4 nil))) -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_9 X1 X2 H);  intros.
Qed.

Remark rem_826 : forall X1 X2 X3 X4:term, auto___def_16 (noncea_current X1 X2) -> auto___def_24 (cons X2 (cons X3 (cons X4 nil))) -> auto___def_23 (key sym (cons X1 (cons server nil))) -> auto___def_67 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_16 (noncea_current X1 X2) -> auto___def_23 (key sym (cons X1 (cons server nil))) -> auto___def_24 (cons X2 (cons X3 (cons X4 nil))) -> auto___def_67 X1 X2 X3 X4). tauto. exact (rem_825 X1 X2 X3 X4).
Qed.

Remark rem_827 : forall X1 X2 X3 X4:term, auto___def_22 (cons (noncea_current X1 X2) (cons X2 (cons X3 (cons X4 nil)))) -> auto___def_23 (key sym (cons X1 (cons server nil))) -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_237 (noncea_current X1 X2) (cons X2 (cons X3 (cons X4 nil))) H);  intros.
  apply (rem_826 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_828 : forall X1 X2 X3 X4:term, auto___def_55 X3 -> auto___def_59 X4 -> auto___type_10 X2 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_197 X1).
Qed.

Remark rem_829 : forall X1:term, auto___type_11 X1 -> auto___type_11 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_830 : forall X1 X2 X3 X4:term, auto___def_55 X3 -> auto___def_59 X4 -> auto___type_10 X2 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_11 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_11 X1 -> auto___type_11 X1). tauto. exact (rem_829 X1).
Qed.

Remark rem_831 : forall X1 X2 X3 X4:term, auto___def_55 X3 -> auto___def_59 X4 -> auto___type_10 X2 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_201 X2).
Qed.

Remark rem_832 : forall X2:term, auto___type_10 X2 -> auto___type_10 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_833 : forall X1 X2 X3 X4:term, auto___def_55 X3 -> auto___def_59 X4 -> auto___type_10 X2 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_10 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_10 X2 -> auto___type_10 X2). tauto. exact (rem_832 X2).
Qed.

Remark rem_834 : forall X3:term, auto___def_55 X3 -> auto___def_55 X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_835 : forall X1 X2 X3 X4:term, auto___def_55 X3 -> auto___def_59 X4 -> auto___type_10 X2 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_55 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_55 X3 -> auto___def_55 X3). tauto. exact (rem_834 X3).
Qed.

Remark rem_836 : forall X4:term, auto___def_59 X4 -> auto___def_59 X4. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_837 : forall X1 X2 X3 X4:term, auto___def_55 X3 -> auto___def_59 X4 -> auto___type_10 X2 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_59 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_59 X4 -> auto___def_59 X4). tauto. exact (rem_836 X4).
Qed.

Remark rem_838 : forall X1 X2 X3 X4:term, auto___def_55 X3 -> auto___def_59 X4 -> auto___type_10 X2 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> (auto_agent X1 /\ auto___type_11 X1 /\ auto_agent X2 /\ auto___type_10 X2 /\ auto___def_55 X3 /\ auto___def_59 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  cut (auto_agent X1). 2:apply (rem_828 X1 X2 X3 X4);  assumption.
  cut (auto___type_11 X1). 2:apply (rem_830 X1 X2 X3 X4);  assumption.
  cut (auto_agent X2). 2:apply (rem_831 X1 X2 X3 X4);  assumption.
  cut (auto___type_10 X2). 2:apply (rem_833 X1 X2 X3 X4);  assumption.
  cut (auto___def_55 X3). 2:apply (rem_835 X1 X2 X3 X4);  assumption.
  cut (auto___def_59 X4). 2:apply (rem_837 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_839 : forall X1 X2 X3 X4:term, auto___def_55 X3 -> auto___def_59 X4 -> auto___type_10 X2 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_67 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  case (rem_838 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6). clear  A1 A2 A3 A4 A5 A6. intros. apply trans___def_67_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6. tauto.
Qed.

Remark rem_840 : forall X1 X2 X3 X4:term, auto_agent X1 -> auto_agent X2 -> auto___def_55 X3 -> auto___def_59 X4 -> auto___type_10 X2 -> auto___type_11 X1 -> auto___def_67 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_55 X3 -> auto___def_59 X4 -> auto___type_10 X2 -> auto___type_11 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_67 X1 X2 X3 X4). tauto. exact (rem_839 X1 X2 X3 X4).
Qed.

Remark rem_841 : forall X1 X2:term, auto___type_9 (noncea_current X1 X2) -> or_1
    (auto_agent X1 /\ auto_agent X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_842 : forall X1 X2 X3 X4:term, auto___def_55 X3 -> auto___def_59 X4 -> auto___type_10 X2 -> auto___type_11 X1 -> auto___type_9 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_841 X1 X2 H);  intros.
  apply (rem_840 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_843 : forall X1 X2 X3 X4:term, auto___def_55 X3 -> auto___def_59 X4 -> auto___def_65 (cons server nil) -> auto___type_10 X2 -> auto___type_11 X1 -> auto___type_9 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_55 X3 -> auto___def_59 X4 -> auto___type_10 X2 -> auto___type_11 X1 -> auto___type_9 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4). tauto.
  exact (rem_842 X1 X2 X3 X4).
Qed.

Remark rem_844 : forall X1 X2 X3 X4:term, auto___type_11 X1 -> auto___def_65 (cons server nil) -> auto___def_55 X3 -> auto___def_59 X4 -> auto___type_10 X2 -> auto___type_9 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_55 X3 -> auto___def_59 X4 -> auto___def_65 (cons server nil) -> auto___type_10 X2 -> auto___type_11 X1 -> auto___type_9 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4). tauto. exact (rem_843 X1 X2 X3 X4).
Qed.

Remark rem_845 : forall X1 X2:term, auto___def_66 (cons X1 X2) -> or_1
    (auto___type_11 X1 /\ auto___def_65 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_846 : forall X1 X2 X3 X4:term, auto___def_55 X3 -> auto___def_59 X4 -> auto___def_66 (cons X1 (cons server nil)) -> auto___type_10 X2 -> auto___type_9 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_845 X1 (cons server nil) H);  intros.
  apply (rem_844 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_847 : forall X1 X2 X3 X4:term, auto___def_55 X3 -> auto___def_59 X4 -> auto___def_60 nil -> auto___def_66 (cons X1 (cons server nil)) -> auto___type_10 X2 -> auto___type_9 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_55 X3 -> auto___def_59 X4 -> auto___def_66 (cons X1 (cons server nil)) -> auto___type_10 X2 -> auto___type_9 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4). tauto.
  exact (rem_846 X1 X2 X3 X4).
Qed.

Remark rem_848 : forall X1 X2 X3 X4:term, auto___def_59 X4 -> auto___def_60 nil -> auto___def_55 X3 -> auto___def_66 (cons X1 (cons server nil)) -> auto___type_10 X2 -> auto___type_9 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_55 X3 -> auto___def_59 X4 -> auto___def_60 nil -> auto___def_66 (cons X1 (cons server nil)) -> auto___type_10 X2 -> auto___type_9 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4). tauto. exact (rem_847 X1 X2 X3 X4).
Qed.

Remark rem_849 : forall X1 X2:term, auto___def_56 (cons X1 X2) -> or_1
    (auto___def_59 X1 /\ auto___def_60 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_850 : forall X1 X2 X3 X4:term, auto___def_55 X3 -> auto___def_56 (cons X4 nil) -> auto___def_66 (cons X1 (cons server nil)) -> auto___type_10 X2 -> auto___type_9 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_849 X4 nil H);  intros.
  apply (rem_848 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_851 : forall X1 X2:term, auto___def_54 (cons X1 X2) -> or_1
    (auto___def_55 X1 /\ auto___def_56 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_852 : forall X1 X2 X3 X4:term, auto___def_54 (cons X3 (cons X4 nil)) -> auto___def_66 (cons X1 (cons server nil)) -> auto___type_10 X2 -> auto___type_9 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_851 X3 (cons X4 nil) H);  intros.
  apply (rem_850 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_853 : forall X1 X2 X3 X4:term, auto___type_10 X2 -> auto___def_54 (cons X3 (cons X4 nil)) -> auto___def_66 (cons X1 (cons server nil)) -> auto___type_9 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_54 (cons X3 (cons X4 nil)) -> auto___def_66 (cons X1 (cons server nil)) -> auto___type_10 X2 -> auto___type_9 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4). tauto. exact (rem_852 X1 X2 X3 X4).
Qed.

Remark rem_854 : forall X1 X2:term, auto___def_53 (cons X1 X2) -> or_1
    (auto___type_10 X1 /\ auto___def_54 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_855 : forall X1 X2 X3 X4:term, auto___def_53 (cons X2 (cons X3 (cons X4 nil))) -> auto___def_66 (cons X1 (cons server nil)) -> auto___type_9 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_854 X2 (cons X3 (cons X4 nil)) H);  intros.
  apply (rem_853 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_856 : forall X1 X2 X3 X4:term, auto___def_53 (cons X2 (cons X3 (cons X4 nil))) -> auto___def_57 sym -> auto___def_66 (cons X1 (cons server nil)) -> auto___type_9 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_53 (cons X2 (cons X3 (cons X4 nil))) -> auto___def_66 (cons X1 (cons server nil)) -> auto___type_9 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4). tauto.
  exact (rem_855 X1 X2 X3 X4).
Qed.

Remark rem_857 : forall X1 X2 X3 X4:term, auto___def_57 sym -> auto___def_66 (cons X1 (cons server nil)) -> auto___def_53 (cons X2 (cons X3 (cons X4 nil))) -> auto___type_9 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_53 (cons X2 (cons X3 (cons X4 nil))) -> auto___def_57 sym -> auto___def_66 (cons X1 (cons server nil)) -> auto___type_9 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4). tauto. exact (rem_856 X1 X2 X3 X4).
Qed.

Remark rem_858 : forall X1 X2 X3 X4:term, auto___def_52 (key sym (cons X1 (cons server nil))) -> auto___def_53 (cons X2 (cons X3 (cons X4 nil))) -> auto___type_9 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_298 sym (cons X1 (cons server nil)) H);  intros.
  apply (rem_857 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_859 : forall X1 X2 X3 X4:term, auto___type_9 (noncea_current X1 X2) -> auto___def_53 (cons X2 (cons X3 (cons X4 nil))) -> auto___def_52 (key sym (cons X1 (cons server nil))) -> auto___def_67 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_52 (key sym (cons X1 (cons server nil))) -> auto___def_53 (cons X2 (cons X3 (cons X4 nil))) -> auto___type_9 (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4). tauto. exact (rem_858 X1 X2 X3 X4).
Qed.

Remark rem_860 : forall X1 X2:term, auto___def_51 (cons X1 X2) -> or_1
    (auto___type_9 X1 /\ auto___def_53 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_861 : forall X1 X2 X3 X4:term, auto___def_51 (cons (noncea_current X1 X2) (cons X2 (cons X3 (cons X4 nil)))) -> auto___def_52 (key sym (cons X1 (cons server nil))) -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_860 (noncea_current X1 X2) (cons X2 (cons X3 (cons X4 nil))) H);  intros.
  apply (rem_859 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_862 : forall X1 X2:term, auto___def_40 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_863 : forall X1 X2 X3 X4:term, auto___def_40 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_862 X1 (cons server nil) H);  intros.
Qed.

Remark rem_864 : forall X1 X2 X3 X4:term, auto___def_39 sym -> auto___def_40 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_40 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4). tauto.
  exact (rem_863 X1 X2 X3 X4).
Qed.

Remark rem_865 : forall X1 X2 X3 X4:term, auto___def_35 sym -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_35 sym -> False). tauto.
  exact (rem_240).
Qed.

Remark rem_866 : forall X1 X2 X3 X4:term, auto___def_35 sym -> auto___type_8 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2 X3 X4. intros. apply (rem_865 X1 X2 X3 X4);  assumption.
Qed.

Remark rem_867 : forall X1 X2 X3 X4:term, auto___def_37 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_243 X1 (cons server nil) H);  intros.
Qed.

Remark rem_868 : forall X1 X2 X3 X4:term, auto___def_36 sym -> auto___def_37 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_37 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4). tauto.
  exact (rem_867 X1 X2 X3 X4).
Qed.

Remark rem_869 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto_knows_current (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3. intro H. intros.
  elim (rem_310 sym (cons X1 (cons server nil)) H);  intros.
  apply (rem_864 X1 X2 X3 X4);  tauto.
  apply (rem_866 X1 X2 X3 X4);  tauto.
  apply (rem_868 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_870 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto_knows_current nil -> auto_knows_current (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto_knows_current (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4). tauto.
  exact (rem_869 X1 X2 X3 X4).
Qed.

Remark rem_871 : forall X1 X2 X3 X4:term, auto_knows_current X4 -> auto_knows_current nil -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto_knows_current (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto_knows_current nil -> auto_knows_current (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4). tauto. exact (rem_870 X1 X2 X3 X4).
Qed.

Remark rem_872 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (cons X4 nil) -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto_knows_current (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_431 X4 nil H);  intros.
  apply (rem_871 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_873 : forall X1 X2 X3 X4:term, auto_knows_current X3 -> auto_knows_current (cons X4 nil) -> auto_knows_current X2 -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto_knows_current (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (cons X4 nil) -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto_knows_current (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4). tauto. exact (rem_872 X1 X2 X3 X4).
Qed.

Remark rem_874 : forall X1 X2 X3 X4:term, auto_knows_current X2 -> auto_knows_current (cons X3 (cons X4 nil)) -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto_knows_current (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_431 X3 (cons X4 nil) H);  intros.
  apply (rem_873 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_875 : forall X1 X2 X3 X4:term, auto_knows_current (cons X2 (cons X3 (cons X4 nil))) -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto_knows_current (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_431 X2 (cons X3 (cons X4 nil)) H);  intros.
  apply (rem_874 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_876 : forall X1 X2 X3 X4:term, auto_knows_current (noncea_current X1 X2) -> auto_knows_current (cons X2 (cons X3 (cons X4 nil))) -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto___def_67 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows_current (cons X2 (cons X3 (cons X4 nil))) -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto_knows_current (noncea_current X1 X2) -> auto___def_67 X1 X2 X3 X4). tauto. exact (rem_875 X1 X2 X3 X4).
Qed.

Remark rem_877 : forall X1 X2 X3 X4:term, auto_knows_current (cons (noncea_current X1 X2) (cons X2 (cons X3 (cons X4 nil)))) -> auto_knows_current (key sym (cons X1 (cons server nil))) -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_431 (noncea_current X1 X2) (cons X2 (cons X3 (cons X4 nil))) H);  intros.
  apply (rem_876 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_878 : forall X1 X2 X3 X4:term, auto_knows_current (crypt (cons (noncea_current X1 X2) (cons X2 (cons X3 (cons X4 nil)))) (key sym (cons X1 (cons server nil)))) -> auto___def_67 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_312 (cons (noncea_current X1 X2) (cons X2 (cons X3 (cons X4 nil)))) (key sym (cons X1 (cons server nil))) H);  intros.
  apply (rem_802 X1 X2 X3 X4);  tauto.
  apply (rem_804 X1 X2 X3 X4);  tauto.
  apply (rem_820 X1 X2 X3 X4);  tauto.
  apply (rem_824 X1 X2 X3 X4);  tauto.
  apply (rem_827 X1 X2 X3 X4);  tauto.
  apply (rem_861 X1 X2 X3 X4);  tauto.
  apply (rem_877 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_879 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_5.  tauto.
Defined.

Remark rem_880 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> auto___type_5 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_5.  case (rem_879 epsilon_mknows_old_p__type_5). clear  epsilon_mknows_old_p__type_5. intros. apply trans___type_5_bob_1;  tauto.
 clear  epsilon_mknows_old_p__type_5. tauto.
Defined.

Remark rem_881 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> auto_knows_old bob -> auto___type_5 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intro H. intros.
  elim (rem_62 H);  intros.
  apply (rem_880 epsilon_mknows_old_p__type_5);  tauto.
Defined.

Remark rem_882 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> auto___type_5 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_5.  case (rem_879 epsilon_mknows_old_p__type_5). clear  epsilon_mknows_old_p__type_5. intros. apply trans___type_5_alice_1;  tauto.
 clear  epsilon_mknows_old_p__type_5. tauto.
Defined.

Remark rem_883 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> auto_knows_old alice -> auto___type_5 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intro H. intros.
  elim (rem_65 H);  intros.
  apply (rem_882 epsilon_mknows_old_p__type_5);  tauto.
Defined.

Remark rem_884 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_885 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2.
  cut (auto_knows_old X1 -> auto_knows_old X1). tauto. exact (rem_884 epsilon_mknows_old_p__type_5 X1).
Defined.

Remark rem_886 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X2:term, auto_knows_old X2 -> auto_knows_old X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_887 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_886 epsilon_mknows_old_p__type_5 X2).
Defined.

Remark rem_888 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> (auto_knows_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_885 epsilon_mknows_old_p__type_5 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_887 epsilon_mknows_old_p__type_5 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_889 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_5 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2. intros A1 A2.
  case (rem_888 epsilon_mknows_old_p__type_5 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_5 A1 A2. intros. apply trans___type_5_cons_1;  tauto.
 clear  epsilon_mknows_old_p__type_5 A1 A2. tauto.
Defined.

Remark rem_890 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto_knows_old (cons X1 X2) -> auto___type_5 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2. intro H. intros.
  elim (rem_73 X1 X2 H);  intros.
  apply (rem_889 epsilon_mknows_old_p__type_5 X1 X2);  tauto.
Defined.

Remark rem_891 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1. intros A1.
  cut (auto_knows_old X1). 2:apply (rem_884 epsilon_mknows_old_p__type_5 X1);  assumption.
  tauto.
Defined.

Remark rem_892 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1:term, auto_knows_old X1 -> auto___type_5 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1. intros A1.
  case (rem_891 epsilon_mknows_old_p__type_5 X1 A1). clear  epsilon_mknows_old_p__type_5 A1. intros. apply trans___type_5_s_1;  tauto.
 clear  epsilon_mknows_old_p__type_5 A1. tauto.
Defined.

Remark rem_893 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1:term, auto_knows_old (s X1) -> auto___type_5 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1. intro H. intros.
  elim (rem_77 X1 H);  intros.
  apply (rem_892 epsilon_mknows_old_p__type_5 X1);  tauto.
Defined.

Remark rem_894 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> auto___type_5 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_5.  case (rem_879 epsilon_mknows_old_p__type_5). clear  epsilon_mknows_old_p__type_5. intros. apply trans___type_5_nil_1;  tauto.
 clear  epsilon_mknows_old_p__type_5. tauto.
Defined.

Remark rem_895 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> auto_knows_old nil -> auto___type_5 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intro H. intros.
  elim (rem_80 H);  intros.
  apply (rem_894 epsilon_mknows_old_p__type_5);  tauto.
Defined.

Remark rem_896 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> auto___type_5 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_5.  case (rem_879 epsilon_mknows_old_p__type_5). clear  epsilon_mknows_old_p__type_5. intros. apply trans___type_5_i_1;  tauto.
 clear  epsilon_mknows_old_p__type_5. tauto.
Defined.

Remark rem_897 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> auto_knows_old i -> auto___type_5 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intro H. intros.
  elim (rem_83 H);  intros.
  apply (rem_896 epsilon_mknows_old_p__type_5);  tauto.
Defined.

Remark rem_898 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1:term, auto___def_35 X1 -> auto___def_35 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_899 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___def_35 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2.
  cut (auto___def_35 X1 -> auto___def_35 X1). tauto. exact (rem_898 epsilon_mknows_old_p__type_5 X1).
Defined.

Remark rem_900 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_901 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_900 epsilon_mknows_old_p__type_5 X2).
Defined.

Remark rem_902 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> (auto___def_35 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2. intros A1 A2.
  cut (auto___def_35 X1). 2:apply (rem_899 epsilon_mknows_old_p__type_5 X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_901 epsilon_mknows_old_p__type_5 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_903 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___type_5 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2. intros A1 A2.
  case (rem_902 epsilon_mknows_old_p__type_5 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_5 A1 A2. intros. apply trans___type_5_key_1;  tauto.
 clear  epsilon_mknows_old_p__type_5 A1 A2. tauto.
Defined.

Remark rem_904 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1:term, auto___def_36 X1 -> auto___def_36 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_905 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_36 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2.
  cut (auto___def_36 X1 -> auto___def_36 X1). tauto. exact (rem_904 epsilon_mknows_old_p__type_5 X1).
Defined.

Remark rem_906 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X2:term, auto___def_37 X2 -> auto___def_37 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_907 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_37 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2.
  cut (auto___def_37 X2 -> auto___def_37 X2). tauto. exact (rem_906 epsilon_mknows_old_p__type_5 X2).
Defined.

Remark rem_908 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> (auto___def_36 X1 /\ auto___def_37 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2. intros A1 A2.
  cut (auto___def_36 X1). 2:apply (rem_905 epsilon_mknows_old_p__type_5 X1 X2);  assumption.
  cut (auto___def_37 X2). 2:apply (rem_907 epsilon_mknows_old_p__type_5 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_909 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_5 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2. intros A1 A2.
  case (rem_908 epsilon_mknows_old_p__type_5 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_5 A1 A2. intros. apply trans___type_5_key_2;  tauto.
 clear  epsilon_mknows_old_p__type_5 A1 A2. tauto.
Defined.

Remark rem_910 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto_knows_old (key X1 X2) -> auto___type_5 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2. intro H. intros.
  elim (rem_97 X1 X2 H);  intros.
  apply (rem_903 epsilon_mknows_old_p__type_5 X1 X2);  tauto.
  apply (rem_909 epsilon_mknows_old_p__type_5 X1 X2);  tauto.
Defined.

Remark rem_911 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1:term, auto___def_12 X1 -> auto___def_12 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_912 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_12 X1). tauto. exact (rem_911 epsilon_mknows_old_p__type_5 X1).
Defined.

Remark rem_913 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X2:term, auto___def_13 X2 -> auto___def_13 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_914 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_913 epsilon_mknows_old_p__type_5 X2).
Defined.

Remark rem_915 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> (auto___def_12 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2. intros A1 A2.
  cut (auto___def_12 X1). 2:apply (rem_912 epsilon_mknows_old_p__type_5 X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_914 epsilon_mknows_old_p__type_5 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_916 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___type_5 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2. intros A1 A2.
  case (rem_915 epsilon_mknows_old_p__type_5 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_5 A1 A2. intros. apply trans___type_5_crypt_1;  tauto.
 clear  epsilon_mknows_old_p__type_5 A1 A2. tauto.
Defined.

Remark rem_917 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1:term, auto___def_34 X1 -> auto___def_34 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_918 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> auto___def_34 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2.
  cut (auto___def_34 X1 -> auto___def_34 X1). tauto. exact (rem_917 epsilon_mknows_old_p__type_5 X1).
Defined.

Remark rem_919 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X2:term, auto___type_7 X2 -> auto___type_7 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_920 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> auto___type_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2.
  cut (auto___type_7 X2 -> auto___type_7 X2). tauto. exact (rem_919 epsilon_mknows_old_p__type_5 X2).
Defined.

Remark rem_921 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> (auto___def_34 X1 /\ auto___type_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2. intros A1 A2.
  cut (auto___def_34 X1). 2:apply (rem_918 epsilon_mknows_old_p__type_5 X1 X2);  assumption.
  cut (auto___type_7 X2). 2:apply (rem_920 epsilon_mknows_old_p__type_5 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_922 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> auto___type_5 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2. intros A1 A2.
  case (rem_921 epsilon_mknows_old_p__type_5 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_5 A1 A2. intros. apply trans___type_5_crypt_2;  tauto.
 clear  epsilon_mknows_old_p__type_5 A1 A2. tauto.
Defined.

Remark rem_923 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1:term, auto___def_22 X1 -> auto___def_22 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_924 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_22 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2.
  cut (auto___def_22 X1 -> auto___def_22 X1). tauto. exact (rem_923 epsilon_mknows_old_p__type_5 X1).
Defined.

Remark rem_925 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X2:term, auto___def_23 X2 -> auto___def_23 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_926 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_925 epsilon_mknows_old_p__type_5 X2).
Defined.

Remark rem_927 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> (auto___def_22 X1 /\ auto___def_23 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2. intros A1 A2.
  cut (auto___def_22 X1). 2:apply (rem_924 epsilon_mknows_old_p__type_5 X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_926 epsilon_mknows_old_p__type_5 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_928 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___type_5 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2. intros A1 A2.
  case (rem_927 epsilon_mknows_old_p__type_5 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_5 A1 A2. intros. apply trans___type_5_crypt_3;  tauto.
 clear  epsilon_mknows_old_p__type_5 A1 A2. tauto.
Defined.

Remark rem_929 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto___type_5 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2. intros A1 A2.
  case (rem_888 epsilon_mknows_old_p__type_5 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_5 A1 A2. intros. apply trans___type_5_crypt_4;  tauto.
 clear  epsilon_mknows_old_p__type_5 A1 A2. tauto.
Defined.

Remark rem_930 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1:term, auto___def_32 X1 -> auto___def_32 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_931 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> auto___def_32 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2.
  cut (auto___def_32 X1 -> auto___def_32 X1). tauto. exact (rem_930 epsilon_mknows_old_p__type_5 X1).
Defined.

Remark rem_932 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X2:term, auto___type_6 X2 -> auto___type_6 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_933 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> auto___type_6 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2.
  cut (auto___type_6 X2 -> auto___type_6 X2). tauto. exact (rem_932 epsilon_mknows_old_p__type_5 X2).
Defined.

Remark rem_934 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> (auto___def_32 X1 /\ auto___type_6 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2. intros A1 A2.
  cut (auto___def_32 X1). 2:apply (rem_931 epsilon_mknows_old_p__type_5 X1 X2);  assumption.
  cut (auto___type_6 X2). 2:apply (rem_933 epsilon_mknows_old_p__type_5 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_935 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> auto___type_5 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2. intros A1 A2.
  case (rem_934 epsilon_mknows_old_p__type_5 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_5 A1 A2. intros. apply trans___type_5_crypt_5;  tauto.
 clear  epsilon_mknows_old_p__type_5 A1 A2. tauto.
Defined.

Remark rem_936 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto_knows_old (crypt X1 X2) -> auto___type_5 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2. intro H. intros.
  elim (rem_124 X1 X2 H);  intros.
  apply (rem_916 epsilon_mknows_old_p__type_5 X1 X2);  tauto.
  apply (rem_922 epsilon_mknows_old_p__type_5 X1 X2);  tauto.
  apply (rem_928 epsilon_mknows_old_p__type_5 X1 X2);  tauto.
  apply (rem_929 epsilon_mknows_old_p__type_5 X1 X2);  tauto.
  apply (rem_935 epsilon_mknows_old_p__type_5 X1 X2);  tauto.
Defined.

Remark rem_937 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_938 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_937 epsilon_mknows_old_p__type_5 X1).
Defined.

Remark rem_939 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_940 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_939 epsilon_mknows_old_p__type_5 X2).
Defined.

Remark rem_941 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> (auto_agent X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2. intros A1 A2.
  cut (auto_agent X1). 2:apply (rem_938 epsilon_mknows_old_p__type_5 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_940 epsilon_mknows_old_p__type_5 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_942 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_5 (noncea_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2. intros A1 A2.
  case (rem_941 epsilon_mknows_old_p__type_5 X1 X2 A1 A2). clear  epsilon_mknows_old_p__type_5 A1 A2. intros. apply trans___type_5_noncea_old_1;  tauto.
 clear  epsilon_mknows_old_p__type_5 A1 A2. tauto.
Defined.

Remark rem_943 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> forall X1 X2:term, auto_knows_old (noncea_old X1 X2) -> auto___type_5 (noncea_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intros X1 X2. intro H. intros.
  elim (rem_132 X1 X2 H);  intros.
  apply (rem_942 epsilon_mknows_old_p__type_5 X1 X2);  tauto.
Defined.

Remark rem_944 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> auto___type_5 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_p__type_5.  case (rem_879 epsilon_mknows_old_p__type_5). clear  epsilon_mknows_old_p__type_5. intros. apply trans___type_5_server_1;  tauto.
 clear  epsilon_mknows_old_p__type_5. tauto.
Defined.

Remark rem_945 : (forall X:term, auto_knows_old X -> auto___type_5 X)
    -> auto_knows_old server -> auto___type_5 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_p__type_5. intro H. intros.
  elim (rem_135 H);  intros.
  apply (rem_944 epsilon_mknows_old_p__type_5);  tauto.
Defined.

Remark rem_946 : forall X1:term, auto_knows_old X1 -> auto___type_5 X1. (* Induct. *)
Proof.
  fix epsilon_mknows_old_p__type_5 1.
  intro X. case X.
  exact (rem_883 epsilon_mknows_old_p__type_5 ).
  exact (rem_881 epsilon_mknows_old_p__type_5 ).
  intros X1 X2;  exact (rem_890 epsilon_mknows_old_p__type_5 X1 X2).
  intros X1 X2;  exact (rem_936 epsilon_mknows_old_p__type_5 X1 X2).
  exact (rem_897 epsilon_mknows_old_p__type_5 ).
  intros X1 X2;  exact (rem_910 epsilon_mknows_old_p__type_5 X1 X2).
  exact (rem_895 epsilon_mknows_old_p__type_5 ).
  intros X1 X2. intro H. elim (rem_137 X1 X2 H).
  intros X1 X2;  exact (rem_943 epsilon_mknows_old_p__type_5 X1 X2).
  intros X1 X2 X3. intro H. elim (rem_139 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_140 X1 X2 X3 H).
   intro H. elim (rem_143  H).
   intro H. elim (rem_142  H).
  intros X1;  exact (rem_893 epsilon_mknows_old_p__type_5 X1).
  exact (rem_945 epsilon_mknows_old_p__type_5 ).
  intros X1 X2 X3. intro H. elim (rem_138 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_141 X1 X2 X3 H).
   intro H. elim (rem_144  H).
Qed.

Remark rem_947 : forall X1 X2 X3:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto___type_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_old X1 -> auto___type_5 X1). tauto. exact (rem_946 X1).
Qed.

Remark rem_948 : forall X1 X2 X3:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___type_5 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto___type_5 X1). tauto. exact (rem_947 X1 X2 X3).
Qed.

Remark rem_949 : forall X1 X2 X3:term, auto___def_11 X1 X2 X3 -> auto___type_5 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_147 X1 X2 X3 H);  intros.
  apply (rem_948 X1 X2 X3);  tauto.
Qed.

Remark rem_950 : forall X1:term, auto___type_9 X1 -> auto___type_9 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_951 : forall X1 X2:term, auto___def_53 X2 -> auto___type_9 X1 -> auto___type_9 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_9 X1 -> auto___type_9 X1). tauto. exact (rem_950 X1).
Qed.

Remark rem_952 : forall X2:term, auto___def_53 X2 -> auto___def_53 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_953 : forall X1 X2:term, auto___def_53 X2 -> auto___type_9 X1 -> auto___def_53 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_53 X2 -> auto___def_53 X2). tauto. exact (rem_952 X2).
Qed.

Remark rem_954 : forall X1 X2:term, auto___def_53 X2 -> auto___type_9 X1 -> (auto___type_9 X1 /\ auto___def_53 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_9 X1). 2:apply (rem_951 X1 X2);  assumption.
  cut (auto___def_53 X2). 2:apply (rem_953 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_955 : forall X1 X2:term, auto___def_53 X2 -> auto___type_9 X1 -> auto___def_51 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_954 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_51_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_956 : forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_18 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_18 X1). tauto. exact (rem_39 X1).
Qed.

Remark rem_957 : forall X2:term, auto___def_19 X2 -> auto___def_19 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_958 : forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_19 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_19 X2). tauto. exact (rem_957 X2).
Qed.

Remark rem_959 : forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> (auto___def_18 X1 /\ auto___def_19 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_18 X1). 2:apply (rem_956 X1 X2);  assumption.
  cut (auto___def_19 X2). 2:apply (rem_958 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_960 : forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_16 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_959 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_16_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_961 : forall X1 X2:term, auto___def_19 X2 -> auto___def_18 X1 -> auto___def_16 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_19 X2 -> auto___def_16 (key X1 X2)). tauto. exact (rem_960 X1 X2).
Qed.

Remark rem_962 : forall X1 X2 X3:term, auto_knows_old (crypt (s (nonceb_old X3 X1 X2)) X3) -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1.
  tauto.
Qed.

Remark rem_963 : forall X1 X2 X3:term, auto_knows_old (crypt (s (nonceb_old X3 X1 X2)) X3) -> auto___def_38 X1 X2 X3. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1.
  case (rem_962 X1 X2 X3 A1). clear  A1. intros. apply trans___def_38_1;  tauto.
 clear  A1. tauto.
Qed.

Remark rem_964 : (forall X:term, auto___type_13 X -> auto___def_55 X)
    -> forall X1:term, auto___def_57 X1 -> auto___def_57 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_965 : (forall X:term, auto___type_13 X -> auto___def_55 X)
    -> forall X1 X2:term, auto___def_57 X1 -> auto___def_58 X2 -> auto___def_57 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_13_p__def_55. intros X1 X2.
  cut (auto___def_57 X1 -> auto___def_57 X1). tauto. exact (rem_964 epsilon_m__type_13_p__def_55 X1).
Defined.

Remark rem_966 : (forall X:term, auto___type_13 X -> auto___def_55 X)
    -> forall X2:term, auto___def_58 X2 -> auto___def_58 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_967 : (forall X:term, auto___type_13 X -> auto___def_55 X)
    -> forall X1 X2:term, auto___def_57 X1 -> auto___def_58 X2 -> auto___def_58 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_13_p__def_55. intros X1 X2.
  cut (auto___def_58 X2 -> auto___def_58 X2). tauto. exact (rem_966 epsilon_m__type_13_p__def_55 X2).
Defined.

Remark rem_968 : (forall X:term, auto___type_13 X -> auto___def_55 X)
    -> forall X1 X2:term, auto___def_57 X1 -> auto___def_58 X2 -> (auto___def_57 X1 /\ auto___def_58 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_13_p__def_55. intros X1 X2. intros A1 A2.
  cut (auto___def_57 X1). 2:apply (rem_965 epsilon_m__type_13_p__def_55 X1 X2);  assumption.
  cut (auto___def_58 X2). 2:apply (rem_967 epsilon_m__type_13_p__def_55 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_969 : (forall X:term, auto___type_13 X -> auto___def_55 X)
    -> forall X1 X2:term, auto___def_57 X1 -> auto___def_58 X2 -> auto___def_55 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_p__def_55. intros X1 X2. intros A1 A2.
  case (rem_968 epsilon_m__type_13_p__def_55 X1 X2 A1 A2). clear  epsilon_m__type_13_p__def_55 A1 A2. intros. apply trans___def_55_key_1;  tauto.
 clear  epsilon_m__type_13_p__def_55 A1 A2. tauto.
Defined.

Remark rem_970 : (forall X:term, auto___type_13 X -> auto___def_55 X)
    -> forall X1 X2:term, auto___type_13 (key X1 X2) -> auto___def_55 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_13_p__def_55. intros X1 X2. intro H. intros.
  elim (rem_280 X1 X2 H);  intros.
  apply (rem_969 epsilon_m__type_13_p__def_55 X1 X2);  tauto.
Defined.

Remark rem_971 : forall X1 X2:term, auto___type_13 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_972 : auto___type_13 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_973 : forall X1 X2 X3:term, auto___type_13 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_974 : auto___type_13 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_975 : forall X1 X2:term, auto___type_13 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_976 : forall X1:term, auto___type_13 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_977 : auto___type_13 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_978 : auto___type_13 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_979 : forall X1 X2 X3:term, auto___type_13 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_980 : forall X1 X2 X3:term, auto___type_13 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_981 : forall X1 X2:term, auto___type_13 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_982 : forall X1 X2 X3:term, auto___type_13 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_983 : forall X1 X2:term, auto___type_13 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_984 : auto___type_13 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_985 : auto___type_13 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_986 : auto___type_13 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_987 : auto___type_13 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_988 : forall X1:term, auto___type_13 X1 -> auto___def_55 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_13_p__def_55 1.
  intro X. case X.
   intro H. elim (rem_974  H).
   intro H. elim (rem_972  H).
  intros X1 X2. intro H. elim (rem_975 X1 X2 H).
  intros X1 X2. intro H. elim (rem_981 X1 X2 H).
   intro H. elim (rem_978  H).
  intros X1 X2;  exact (rem_970 epsilon_m__type_13_p__def_55 X1 X2).
   intro H. elim (rem_977  H).
  intros X1 X2. intro H. elim (rem_971 X1 X2 H).
  intros X1 X2. intro H. elim (rem_983 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_979 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_980 X1 X2 X3 H).
   intro H. elim (rem_986  H).
   intro H. elim (rem_984  H).
  intros X1. intro H. elim (rem_976 X1 H).
   intro H. elim (rem_985  H).
  intros X1 X2 X3. intro H. elim (rem_973 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_982 X1 X2 X3 H).
   intro H. elim (rem_987  H).
Qed.

Remark rem_989 : forall X1 X2 X3 X4 X5:term, auto___def_71 X2 -> auto___type_13 X1 -> auto_knows_current (crypt (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_55 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_13 X1 -> auto___def_55 X1). tauto. exact (rem_988 X1).
Qed.

Remark rem_990 : forall X1:term, auto___type_13 X1 -> auto___type_13 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_991 : forall X1 X2 X3 X4 X5:term, auto___def_71 X2 -> auto___type_13 X1 -> auto_knows_current (crypt (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___type_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_13 X1 -> auto___type_13 X1). tauto. exact (rem_990 X1).
Qed.

Remark rem_992 : forall X2:term, auto___def_71 X2 -> auto___def_71 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_993 : forall X1 X2 X3 X4 X5:term, auto___def_71 X2 -> auto___type_13 X1 -> auto_knows_current (crypt (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_71 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_71 X2 -> auto___def_71 X2). tauto. exact (rem_992 X2).
Qed.

Remark rem_994 : forall X1 X2 X3 X4 X5:term, auto___def_71 X2 -> auto___type_13 X1 -> auto_knows_current (crypt (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> (auto___def_55 X1 /\ auto___type_13 X1 /\ auto___def_71 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3.
  cut (auto___def_55 X1). 2:apply (rem_989 X1 X2 X3 X4 X5);  assumption.
  cut (auto___type_13 X1). 2:apply (rem_991 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_71 X2). 2:apply (rem_993 X1 X2 X3 X4 X5);  assumption.
  tauto.
Qed.

Remark rem_995 : forall X1 X2 X3 X4 X5:term, auto___def_71 X2 -> auto___type_13 X1 -> auto_knows_current (crypt (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_70 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3.
  case (rem_994 X1 X2 X3 X4 X5 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_70_5;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_996 : forall X1 X2 X3 X4 X5:term, auto___def_69 X2 -> auto___def_71 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_12 X1 -> auto___type_13 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_801 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
Qed.

Remark rem_997 : forall X1 X2 X3 X4 X5:term, auto___def_71 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_13 (key sym (cons X3 (cons server nil))) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_69 X2 -> auto___def_71 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_12 X1 -> auto___type_13 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2). tauto. exact (rem_996 X1 X2 X3 X4 X5).
Qed.

Remark rem_998 : forall X1 X2 X3 X4 X5:term, auto___def_69 X2 -> auto___def_69 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_12 X1 -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_803 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
Qed.

Remark rem_999 : forall X1 X2 X3 X4 X5:term, auto___def_69 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_69 X2 -> auto___def_69 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_12 X1 -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2). tauto. exact (rem_998 X1 X2 X3 X4 X5).
Qed.

Remark rem_1000 : forall X1 X2:term, auto___type_3 (noncea_current X1 X2) -> auto___type_4 X2 -> auto___type_5 X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_805 X1 X2 H);  intros.
Qed.

Remark rem_1001 : forall X1 X2:term, auto___def_26 (cons server nil) -> auto___type_3 (noncea_current X1 X2) -> auto___type_4 X2 -> auto___type_5 X1 -> False. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___type_3 (noncea_current X1 X2) -> auto___type_4 X2 -> auto___type_5 X1 -> False). tauto.
  exact (rem_1000 X1 X2).
Qed.

Remark rem_1002 : forall X1 X2:term, auto___type_5 X1 -> auto___def_26 (cons server nil) -> auto___type_3 (noncea_current X1 X2) -> auto___type_4 X2 -> False. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_26 (cons server nil) -> auto___type_3 (noncea_current X1 X2) -> auto___type_4 X2 -> auto___type_5 X1 -> False). tauto. exact (rem_1001 X1 X2).
Qed.

Remark rem_1003 : forall X1 X2:term, auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_current X1 X2) -> auto___type_4 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_216 X1 (cons server nil) H);  intros.
  apply (rem_1002 X1 X2);  tauto.
Qed.

Remark rem_1004 : forall X4 X5:term, auto___def_29 (cons X4 (cons server nil)) -> auto___type_3 (noncea_current X4 X5) -> auto___type_4 X5 -> False. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea_current X1 X2) -> auto___type_4 X2 -> False). tauto. exact (rem_1003 X1 X2).
Qed.

Remark rem_1005 : forall X1 X2 X3 X4 X5:term, auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_29 (cons X4 (cons server nil)) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___type_3 (noncea_current X4 X5) -> auto___type_4 X5 -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_29 (cons X4 (cons server nil)) -> auto___type_3 (noncea_current X4 X5) -> auto___type_4 X5 -> False). tauto.
  exact (rem_1004 X4 X5).
Qed.

Remark rem_1006 : forall X1 X2 X3 X4 X5:term, auto___type_4 X3 -> auto___def_15 (cons X1 (cons X4 nil)) -> auto___def_29 (cons X5 (cons server nil)) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___type_3 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_29 (cons X4 (cons server nil)) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___type_3 (noncea_current X4 X5) -> auto___type_4 X5 -> auto___def_70 X1 X2). tauto. exact (rem_1005 X1 X2 X3 X4 X5).
Qed.

Remark rem_1007 : forall X1 X2 X3 X4 X5:term, auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_29 (cons X5 (cons server nil)) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___type_3 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_225 X3 (cons X1 (cons X4 nil)) H);  intros.
  apply (rem_1006 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1008 : forall X1 X2 X3 X4 X5:term, auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_18 sym -> auto___def_29 (cons X5 (cons server nil)) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___type_3 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_29 (cons X5 (cons server nil)) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___type_3 (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto.
  exact (rem_1007 X1 X2 X3 X4 X5).
Qed.

Remark rem_1009 : forall X1 X2 X3 X4 X5:term, auto___def_18 sym -> auto___def_29 (cons X3 (cons server nil)) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___type_3 (noncea_current X3 X4) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_18 sym -> auto___def_29 (cons X5 (cons server nil)) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___type_3 (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto. exact (rem_1008 X1 X2 X3 X4 X5).
Qed.

Remark rem_1010 : forall X1 X2 X3 X4 X5:term, auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___type_3 (noncea_current X3 X4) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_167 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1009 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1011 : forall X1 X2 X3 X4 X5:term, auto___type_3 (noncea_current X3 X4) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___type_3 (noncea_current X3 X4) -> auto___def_70 X1 X2). tauto. exact (rem_1010 X1 X2 X3 X4 X5).
Qed.

Remark rem_1012 : forall X1 X2 X3 X4 X5:term, auto___def_12 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_231 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1011 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1013 : forall X1 X2 X3 X4 X5:term, auto___def_55 (noncea_current X3 X4) -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_63 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_604 X3 X4 H);  intros.
Qed.

Remark rem_1014 : forall X1 X2 X3 X4 X5:term, auto___def_55 (noncea_current X3 X4) -> auto___def_63 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_55 (noncea_current X3 X4) -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_63 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___def_70 X1 X2). tauto. exact (rem_1013 X1 X2 X3 X4 X5).
Qed.

Remark rem_1015 : forall X1 X2 X3 X4 X5:term, auto___def_61 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_823 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1014 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1016 : forall X1 X2 X3 X4 X5:term, auto___def_16 (noncea_current X3 X4) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_24 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_9 X3 X4 H);  intros.
Qed.

Remark rem_1017 : forall X1 X2 X3 X4 X5:term, auto___def_16 (noncea_current X3 X4) -> auto___def_24 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_16 (noncea_current X3 X4) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_24 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___def_70 X1 X2). tauto. exact (rem_1016 X1 X2 X3 X4 X5).
Qed.

Remark rem_1018 : forall X1 X2 X3 X4 X5:term, auto___def_22 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_237 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1017 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1019 : (forall X:term, auto___def_55 X -> auto___type_12 X)
    -> forall X1:term, auto___def_57 X1 -> auto___def_57 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1020 : (forall X:term, auto___def_55 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_57 X1 -> auto___def_58 X2 -> auto___def_57 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_55_p__type_12. intros X1 X2.
  cut (auto___def_57 X1 -> auto___def_57 X1). tauto. exact (rem_1019 epsilon_m__def_55_p__type_12 X1).
Defined.

Remark rem_1021 : (forall X:term, auto___def_55 X -> auto___type_12 X)
    -> forall X2:term, auto___def_58 X2 -> auto___def_58 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1022 : (forall X:term, auto___def_55 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_57 X1 -> auto___def_58 X2 -> auto___def_58 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_55_p__type_12. intros X1 X2.
  cut (auto___def_58 X2 -> auto___def_58 X2). tauto. exact (rem_1021 epsilon_m__def_55_p__type_12 X2).
Defined.

Remark rem_1023 : (forall X:term, auto___def_55 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_57 X1 -> auto___def_58 X2 -> (auto___def_57 X1 /\ auto___def_58 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_55_p__type_12. intros X1 X2. intros A1 A2.
  cut (auto___def_57 X1). 2:apply (rem_1020 epsilon_m__def_55_p__type_12 X1 X2);  assumption.
  cut (auto___def_58 X2). 2:apply (rem_1022 epsilon_m__def_55_p__type_12 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1024 : (forall X:term, auto___def_55 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_57 X1 -> auto___def_58 X2 -> auto___type_12 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_55_p__type_12. intros X1 X2. intros A1 A2.
  case (rem_1023 epsilon_m__def_55_p__type_12 X1 X2 A1 A2). clear  epsilon_m__def_55_p__type_12 A1 A2. intros. apply trans___type_12_key_1;  tauto.
 clear  epsilon_m__def_55_p__type_12 A1 A2. tauto.
Defined.

Remark rem_1025 : (forall X:term, auto___def_55 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_55 (key X1 X2) -> auto___type_12 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_55_p__type_12. intros X1 X2. intro H. intros.
  elim (rem_581 X1 X2 H);  intros.
  apply (rem_1024 epsilon_m__def_55_p__type_12 X1 X2);  tauto.
Defined.

Remark rem_1026 : forall X1 X2 X3:term, auto___def_55 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1027 : forall X1 X2 X3:term, auto___def_55 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1028 : auto___def_55 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1029 : auto___def_55 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1030 : auto___def_55 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1031 : forall X1:term, auto___def_55 X1 -> auto___type_12 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_55_p__type_12 1.
  intro X. case X.
   intro H. elim (rem_610  H).
   intro H. elim (rem_607  H).
  intros X1 X2. intro H. elim (rem_613 X1 X2 H).
  intros X1 X2. intro H. elim (rem_670 X1 X2 H).
   intro H. elim (rem_622  H).
  intros X1 X2;  exact (rem_1025 epsilon_m__def_55_p__type_12 X1 X2).
   intro H. elim (rem_619  H).
  intros X1 X2. intro H. elim (rem_604 X1 X2 H).
  intros X1 X2. intro H. elim (rem_679 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_663 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_667 X1 X2 X3 H).
   intro H. elim (rem_1029  H).
   intro H. elim (rem_1028  H).
  intros X1. intro H. elim (rem_616 X1 H).
   intro H. elim (rem_682  H).
  intros X1 X2 X3. intro H. elim (rem_1026 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1027 X1 X2 X3 H).
   intro H. elim (rem_1030  H).
Qed.

Remark rem_1032 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___type_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_55 X1 -> auto___type_12 X1). tauto. exact (rem_1031 X1).
Qed.

Remark rem_1033 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___def_55 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_55 X1 -> auto___def_55 X1). tauto. exact (rem_258 X1).
Qed.

Remark rem_1034 : forall X2:term, auto___def_69 X2 -> auto___def_69 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1035 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___def_69 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_69 X2 -> auto___def_69 X2). tauto. exact (rem_1034 X2).
Qed.

Remark rem_1036 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_69 X2 -> auto___type_12 X1 -> (auto___type_12 X1 /\ auto___def_55 X1 /\ auto___def_69 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  cut (auto___type_12 X1). 2:apply (rem_1032 X1 X2 X3);  assumption.
  cut (auto___def_55 X1). 2:apply (rem_1033 X1 X2 X3);  assumption.
  cut (auto___def_69 X2). 2:apply (rem_1035 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_1037 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___def_70 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  case (rem_1036 X1 X2 X3 A1 A2 A3 A4). clear  A1 A2 A3 A4. intros. apply trans___def_70_3;  tauto.
 clear  A1 A2 A3 A4. tauto.
Qed.

Remark rem_1038 : forall X1 X2 X3:term, auto___def_54 (cons X1 (cons X3 nil)) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_851 X1 (cons X3 nil) H);  intros.
  apply (rem_1037 X1 X2 X3);  tauto.
Qed.

Remark rem_1039 : forall X1 X2 X3 X4 X5:term, auto___def_54 (cons X1 (cons X3 nil)) -> auto___def_66 (cons X4 (cons server nil)) -> auto___def_69 X2 -> auto___type_10 X5 -> auto___type_12 X1 -> auto___type_9 (noncea_current X4 X5) -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_54 (cons X1 (cons X3 nil)) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___def_70 X1 X2). tauto.
  exact (rem_1038 X1 X2 X3).
Qed.

Remark rem_1040 : forall X1 X2 X3 X4 X5:term, auto___type_10 X3 -> auto___def_54 (cons X1 (cons X4 nil)) -> auto___def_66 (cons X5 (cons server nil)) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___type_9 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_54 (cons X1 (cons X3 nil)) -> auto___def_66 (cons X4 (cons server nil)) -> auto___def_69 X2 -> auto___type_10 X5 -> auto___type_12 X1 -> auto___type_9 (noncea_current X4 X5) -> auto___def_70 X1 X2). tauto. exact (rem_1039 X1 X2 X3 X4 X5).
Qed.

Remark rem_1041 : forall X1 X2 X3 X4 X5:term, auto___def_53 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_66 (cons X5 (cons server nil)) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___type_9 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_854 X3 (cons X1 (cons X4 nil)) H);  intros.
  apply (rem_1040 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1042 : forall X1 X2 X3 X4 X5:term, auto___def_53 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_57 sym -> auto___def_66 (cons X5 (cons server nil)) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___type_9 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_53 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_66 (cons X5 (cons server nil)) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___type_9 (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto.
  exact (rem_1041 X1 X2 X3 X4 X5).
Qed.

Remark rem_1043 : forall X1 X2 X3 X4 X5:term, auto___def_57 sym -> auto___def_66 (cons X3 (cons server nil)) -> auto___def_53 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___type_9 (noncea_current X3 X4) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_53 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_57 sym -> auto___def_66 (cons X5 (cons server nil)) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___type_9 (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto. exact (rem_1042 X1 X2 X3 X4 X5).
Qed.

Remark rem_1044 : forall X1 X2 X3 X4 X5:term, auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_53 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___type_9 (noncea_current X3 X4) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_298 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1043 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1045 : forall X1 X2 X3 X4 X5:term, auto___type_9 (noncea_current X3 X4) -> auto___def_53 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_53 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___type_9 (noncea_current X3 X4) -> auto___def_70 X1 X2). tauto. exact (rem_1044 X1 X2 X3 X4 X5).
Qed.

Remark rem_1046 : forall X1 X2 X3 X4 X5:term, auto___def_51 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_860 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1045 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1047 : forall X1 X2:term, auto___def_40 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current (noncea_current X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_862 X1 (cons server nil) H);  intros.
Qed.

Remark rem_1048 : forall X1 X2:term, auto___def_39 sym -> auto___def_40 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current (noncea_current X1 X2) -> False. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_40 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current (noncea_current X1 X2) -> False). tauto.
  exact (rem_1047 X1 X2).
Qed.

Remark rem_1049 : forall X1 X2:term, auto___def_39 sym -> auto___def_40 (cons X2 (cons server nil)) -> auto_knows_current X1 -> auto_knows_current (noncea_current X2 X1) -> False. (* Prove equivalent, normalized clause. *)
Proof.
   intros X2 X1.
  cut (auto___def_39 sym -> auto___def_40 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current (noncea_current X1 X2) -> False). tauto. exact (rem_1048 X1 X2).
Qed.

Remark rem_1050 : forall X1 X2:term, auto___def_35 sym -> auto_knows_current X1 -> auto_knows_current (noncea_current X2 X1) -> False. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_35 sym -> False). tauto.
  exact (rem_240).
Qed.

Remark rem_1051 : forall X1 X2:term, auto___def_35 sym -> auto_knows_current X2 -> auto_knows_current (noncea_current X1 X2) -> False. (* Prove equivalent, normalized clause. *)
Proof.
   intros X2 X1.
  cut (auto___def_35 sym -> auto_knows_current X1 -> auto_knows_current (noncea_current X2 X1) -> False). tauto. exact (rem_1050 X1 X2).
Qed.

Remark rem_1052 : forall X1 X2:term, auto___def_35 sym -> auto___type_8 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current (noncea_current X1 X2) -> False. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2. intros. apply (rem_1051 X1 X2);  assumption.
Qed.

Remark rem_1053 : forall X1 X2:term, auto___def_35 sym -> auto___type_8 (cons X2 (cons server nil)) -> auto_knows_current X1 -> auto_knows_current (noncea_current X2 X1) -> False. (* Prove equivalent, normalized clause. *)
Proof.
   intros X2 X1.
  cut (auto___def_35 sym -> auto___type_8 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current (noncea_current X1 X2) -> False). tauto. exact (rem_1052 X1 X2).
Qed.

Remark rem_1054 : auto___def_36 sym -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_655 H);  intros.
Qed.

Remark rem_1055 : forall X1 X2:term, auto___def_36 sym -> auto___def_37 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current (noncea_current X1 X2) -> False. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_36 sym -> False). tauto.
  exact (rem_1054).
Qed.

Remark rem_1056 : forall X1 X2:term, auto___def_36 sym -> auto___def_37 (cons X2 (cons server nil)) -> auto_knows_current X1 -> auto_knows_current (noncea_current X2 X1) -> False. (* Prove equivalent, normalized clause. *)
Proof.
   intros X2 X1.
  cut (auto___def_36 sym -> auto___def_37 (cons X1 (cons server nil)) -> auto_knows_current X2 -> auto_knows_current (noncea_current X1 X2) -> False). tauto. exact (rem_1055 X1 X2).
Qed.

Remark rem_1057 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current (key sym (cons X2 (cons server nil))) -> auto_knows_current (noncea_current X2 X1) -> False. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_310 sym (cons X2 (cons server nil)) H);  intros.
  apply (rem_1049 X1 X2);  tauto.
  apply (rem_1053 X1 X2);  tauto.
  apply (rem_1056 X1 X2);  tauto.
Qed.

Remark rem_1058 : forall X3 X5:term, auto_knows_current X3 -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> False. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto_knows_current X1 -> auto_knows_current (key sym (cons X2 (cons server nil))) -> auto_knows_current (noncea_current X2 X1) -> False). tauto. exact (rem_1057 X1 X2).
Qed.

Remark rem_1059 : forall X1 X2 X3 X4 X5:term, auto___def_69 X2 -> auto___type_12 X1 -> auto_knows_current X3 -> auto_knows_current (cons X1 (cons X4 nil)) -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X3 -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> False). tauto.
  exact (rem_1058 X3 X5).
Qed.

Remark rem_1060 : forall X1 X2 X3 X4 X5:term, auto_knows_current X3 -> auto_knows_current (cons X1 (cons X4 nil)) -> auto___def_69 X2 -> auto___type_12 X1 -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_69 X2 -> auto___type_12 X1 -> auto_knows_current X3 -> auto_knows_current (cons X1 (cons X4 nil)) -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto. exact (rem_1059 X1 X2 X3 X4 X5).
Qed.

Remark rem_1061 : forall X1 X2 X3 X4 X5:term, auto___def_69 X2 -> auto___type_12 X1 -> auto_knows_current (cons X3 (cons X1 (cons X4 nil))) -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_431 X3 (cons X1 (cons X4 nil)) H);  intros.
  apply (rem_1060 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1062 : forall X1 X2 X3 X4 X5:term, auto_knows_current (noncea_current X3 X4) -> auto_knows_current (cons X4 (cons X1 (cons X5 nil))) -> auto___def_69 X2 -> auto___type_12 X1 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_69 X2 -> auto___type_12 X1 -> auto_knows_current (cons X3 (cons X1 (cons X4 nil))) -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto. exact (rem_1061 X1 X2 X3 X4 X5).
Qed.

Remark rem_1063 : forall X1 X2 X3 X4 X5:term, auto___def_69 X2 -> auto___type_12 X1 -> auto_knows_current (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_431 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1062 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1064 : forall X1 X2 X3 X4 X5:term, auto_knows_current (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_69 X2 -> auto___type_12 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_69 X2 -> auto___type_12 X1 -> auto_knows_current (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1063 X1 X2 X3 X4 X5).
Qed.

Remark rem_1065 : forall X1 X2 X3 X4 X5:term, auto___def_69 X2 -> auto___type_12 X1 -> auto_knows_current (crypt (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_312 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil))) H);  intros.
  apply (rem_997 X1 X2 X3 X4 X5);  tauto.
  apply (rem_999 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1012 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1015 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1018 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1046 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1064 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1066 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_71 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_13 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_801 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
Qed.

Remark rem_1067 : forall X1 X2 X3 X4 X5:term, auto___def_71 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_13 (key sym (cons X3 (cons server nil))) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_71 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_13 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1066 X1 X2 X3 X4 X5).
Qed.

Remark rem_1068 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_69 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_803 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
Qed.

Remark rem_1069 : forall X1 X2 X3 X4 X5:term, auto___def_69 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_69 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1068 X1 X2 X3 X4 X5).
Qed.

Remark rem_1070 : forall X1 X2 X3:term, auto___def_29 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1071 : (forall X:term, auto___def_19 X -> auto___def_29 X -> False)
    -> forall X1 X2 X3:term, auto___def_29 (session_old X1 X2 X3) -> auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_19_m__def_29. intros X1 X2 X3. intro H. intros.
  elim (rem_1070 X1 X2 X3 H);  intros.
Defined.

Remark rem_1072 : forall X1 X2 X3:term, auto___def_19 (session_old X1 X2 X3) -> or_1
    (auto_knows_old X1 /\ auto_knows_old X2 /\ auto_knows_old X3)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1073 : (forall X:term, auto___def_19 X -> auto___def_29 X -> False)
    -> forall X1 X2 X3:term, auto___def_19 (session_old X1 X2 X3) -> auto___def_29 (session_old X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_19_m__def_29. intros X1 X2 X3. intro H. intros.
  elim (rem_1072 X1 X2 X3 H);  intros.
  apply (rem_1071 epsilon_m__def_19_m__def_29 X1 X2 X3);  tauto.
Defined.

Remark rem_1074 : forall X1 X2:term, auto___def_19 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1075 : auto___def_19 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1076 : forall X1 X2 X3:term, auto___def_19 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1077 : auto___def_19 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1078 : forall X1 X2:term, auto___def_19 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1079 : forall X1:term, auto___def_19 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1080 : auto___def_19 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1081 : auto___def_19 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1082 : forall X1 X2:term, auto___def_19 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1083 : forall X1 X2 X3:term, auto___def_19 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1084 : forall X1 X2 X3:term, auto___def_19 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1085 : forall X1 X2:term, auto___def_19 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1086 : forall X1 X2:term, auto___def_19 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1087 : auto___def_19 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1088 : auto___def_19 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1089 : auto___def_19 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1090 : auto___def_19 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1091 : forall X2:term, auto___def_19 X2 -> auto___def_29 X2 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_19_m__def_29 1.
  intro X. case X.
   intro H. elim (rem_1077  H).
   intro H. elim (rem_1075  H).
  intros X1 X2. intro H. elim (rem_1078 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1085 X1 X2 H).
   intro H. elim (rem_1081  H).
  intros X1 X2. intro H. elim (rem_1082 X1 X2 H).
   intro H. elim (rem_1080  H).
  intros X1 X2. intro H. elim (rem_1074 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1086 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1083 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1084 X1 X2 X3 H).
   intro H. elim (rem_1089  H).
   intro H. elim (rem_1087  H).
  intros X1. intro H. elim (rem_1079 X1 H).
   intro H. elim (rem_1088  H).
  intros X1 X2 X3. intro H. elim (rem_1076 X1 X2 X3 H).
  intros X1 X2 X3;  exact (rem_1073 epsilon_m__def_19_m__def_29 X1 X2 X3).
   intro H. elim (rem_1090  H).
Qed.

Remark rem_1092 : (forall X:term, auto___def_16 X -> auto___def_13 X -> False)
    -> forall X2:term, auto___def_19 X2 -> auto___def_29 X2 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_16_m__def_13. exact (rem_1091).
Defined.

Remark rem_1093 : (forall X:term, auto___def_16 X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_19 X2 -> auto___def_29 X2 -> auto___def_18 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_16_m__def_13. intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_29 X2 -> False). clear  epsilon_m__def_16_m__def_13. tauto.
  exact (rem_1092 epsilon_m__def_16_m__def_13 X2).
Defined.

Remark rem_1094 : (forall X:term, auto___def_16 X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (key X1 X2) -> auto___def_18 X1 -> auto___def_19 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_16_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_167 X1 X2 H);  intros.
  apply (rem_1093 epsilon_m__def_16_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_1095 : (forall X:term, auto___def_16 X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_16 (key X1 X2) -> auto___def_13 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_16_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_7 X1 X2 H);  intros.
  apply (rem_1094 epsilon_m__def_16_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_1096 : forall X1:term, auto___def_16 X1 -> auto___def_13 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_16_m__def_13 1.
  intro X. case X.
   intro H. elim (rem_12  H).
   intro H. elim (rem_10  H).
  intros X1 X2. intro H. elim (rem_13 X1 X2 H).
  intros X1 X2. intro H. elim (rem_19 X1 X2 H).
   intro H. elim (rem_16  H).
  intros X1 X2;  exact (rem_1095 epsilon_m__def_16_m__def_13 X1 X2).
   intro H. elim (rem_15  H).
  intros X1 X2. intro H. elim (rem_9 X1 X2 H).
  intros X1 X2. intro H. elim (rem_21 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_17 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_18 X1 X2 X3 H).
   intro H. elim (rem_24  H).
   intro H. elim (rem_22  H).
  intros X1. intro H. elim (rem_14 X1 H).
   intro H. elim (rem_23  H).
  intros X1 X2 X3. intro H. elim (rem_11 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_20 X1 X2 X3 H).
   intro H. elim (rem_25  H).
Qed.

Remark rem_1097 : forall X1 X2 X3:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_16 X1 -> auto___def_17 (cons X3 nil) -> auto___def_70 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3. intros.
  assert (HH:=(rem_1096 X1)). tauto.
Qed.

Remark rem_1098 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___def_17 (cons X3 nil) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_16 X1 -> auto___def_17 (cons X3 nil) -> auto___def_70 X1 X2). tauto. exact (rem_1097 X1 X2 X3).
Qed.

Remark rem_1099 : forall X1 X2 X3:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1 H2. intro H. intros.
  elim (rem_222 X1 (cons X3 nil) H);  intros.
  apply (rem_1098 X1 X2 X3);  tauto.
Qed.

Remark rem_1100 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_29 (cons X4 (cons server nil)) -> auto___type_3 (noncea_current X4 X5) -> auto___type_4 X5 -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_70 X1 X2). tauto.
  exact (rem_1099 X1 X2 X3).
Qed.

Remark rem_1101 : forall X1 X2 X3 X4 X5:term, auto___type_4 X3 -> auto___def_15 (cons X1 (cons X4 nil)) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_29 (cons X4 (cons server nil)) -> auto___type_3 (noncea_current X4 X5) -> auto___type_4 X5 -> auto___def_70 X1 X2). tauto. exact (rem_1100 X1 X2 X3 X4 X5).
Qed.

Remark rem_1102 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_225 X3 (cons X1 (cons X4 nil)) H);  intros.
  apply (rem_1101 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1103 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_18 sym -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto.
  exact (rem_1102 X1 X2 X3 X4 X5).
Qed.

Remark rem_1104 : forall X1 X2 X3 X4 X5:term, auto___def_18 sym -> auto___def_29 (cons X3 (cons server nil)) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___type_3 (noncea_current X3 X4) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_18 sym -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto. exact (rem_1103 X1 X2 X3 X4 X5).
Qed.

Remark rem_1105 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___type_3 (noncea_current X3 X4) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_167 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1104 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1106 : forall X1 X2 X3 X4 X5:term, auto___type_3 (noncea_current X3 X4) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___type_3 (noncea_current X3 X4) -> auto___def_70 X1 X2). tauto. exact (rem_1105 X1 X2 X3 X4 X5).
Qed.

Remark rem_1107 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_12 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_13 X1 -> auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_231 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1106 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1108 : forall X1 X2 X3 X4 X5:term, auto___def_12 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_12 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_13 X1 -> auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1107 X1 X2 X3 X4 X5).
Qed.

Remark rem_1109 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_55 (noncea_current X3 X4) -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_63 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_604 X3 X4 H);  intros.
Qed.

Remark rem_1110 : forall X1 X2 X3 X4 X5:term, auto___def_55 (noncea_current X3 X4) -> auto___def_63 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_55 (noncea_current X3 X4) -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_63 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1109 X1 X2 X3 X4 X5).
Qed.

Remark rem_1111 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_61 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_823 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1110 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1112 : forall X1 X2 X3 X4 X5:term, auto___def_61 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_61 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1111 X1 X2 X3 X4 X5).
Qed.

Remark rem_1113 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_16 (noncea_current X3 X4) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_24 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_9 X3 X4 H);  intros.
Qed.

Remark rem_1114 : forall X1 X2 X3 X4 X5:term, auto___def_16 (noncea_current X3 X4) -> auto___def_24 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_16 (noncea_current X3 X4) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_24 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1113 X1 X2 X3 X4 X5).
Qed.

Remark rem_1115 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_22 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_237 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1114 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1116 : forall X1 X2 X3 X4 X5:term, auto___def_22 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_22 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1115 X1 X2 X3 X4 X5).
Qed.

Remark rem_1117 : forall X1:term, auto___def_13 X1 -> auto___def_13 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1118 : forall X1 X2 X3:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_13 X1 -> auto___def_13 X1). tauto. exact (rem_1117 X1).
Qed.

Remark rem_1119 : forall X1 X2 X3:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_55 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_55 X1 -> auto___def_55 X1). tauto. exact (rem_258 X1).
Qed.

Remark rem_1120 : forall X2:term, auto___def_12 X2 -> auto___def_12 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1121 : forall X1 X2 X3:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_12 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_12 X2 -> auto___def_12 X2). tauto. exact (rem_1120 X2).
Qed.

Remark rem_1122 : forall X1 X2 X3:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> (auto___def_13 X1 /\ auto___def_55 X1 /\ auto___def_12 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  cut (auto___def_13 X1). 2:apply (rem_1118 X1 X2 X3);  assumption.
  cut (auto___def_55 X1). 2:apply (rem_1119 X1 X2 X3);  assumption.
  cut (auto___def_12 X2). 2:apply (rem_1121 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_1123 : forall X1 X2 X3:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_70 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  case (rem_1122 X1 X2 X3 A1 A2 A3 A4). clear  A1 A2 A3 A4. intros. apply trans___def_70_1;  tauto.
 clear  A1 A2 A3 A4. tauto.
Qed.

Remark rem_1124 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_70 X1 X2). tauto. exact (rem_1123 X1 X2 X3).
Qed.

Remark rem_1125 : forall X1 X2 X3:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_54 (cons X1 (cons X3 nil)) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1 H2. intro H. intros.
  elim (rem_851 X1 (cons X3 nil) H);  intros.
  apply (rem_1124 X1 X2 X3);  tauto.
Qed.

Remark rem_1126 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_54 (cons X1 (cons X3 nil)) -> auto___def_66 (cons X4 (cons server nil)) -> auto___type_10 X5 -> auto___type_9 (noncea_current X4 X5) -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_54 (cons X1 (cons X3 nil)) -> auto___def_70 X1 X2). tauto.
  exact (rem_1125 X1 X2 X3).
Qed.

Remark rem_1127 : forall X1 X2 X3 X4 X5:term, auto___type_10 X3 -> auto___def_54 (cons X1 (cons X4 nil)) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_66 (cons X5 (cons server nil)) -> auto___type_9 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_54 (cons X1 (cons X3 nil)) -> auto___def_66 (cons X4 (cons server nil)) -> auto___type_10 X5 -> auto___type_9 (noncea_current X4 X5) -> auto___def_70 X1 X2). tauto. exact (rem_1126 X1 X2 X3 X4 X5).
Qed.

Remark rem_1128 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_53 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_66 (cons X5 (cons server nil)) -> auto___type_9 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_854 X3 (cons X1 (cons X4 nil)) H);  intros.
  apply (rem_1127 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1129 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_53 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_57 sym -> auto___def_66 (cons X5 (cons server nil)) -> auto___type_9 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_53 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_66 (cons X5 (cons server nil)) -> auto___type_9 (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto.
  exact (rem_1128 X1 X2 X3 X4 X5).
Qed.

Remark rem_1130 : forall X1 X2 X3 X4 X5:term, auto___def_57 sym -> auto___def_66 (cons X3 (cons server nil)) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_53 (cons X4 (cons X1 (cons X5 nil))) -> auto___type_9 (noncea_current X3 X4) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_53 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_57 sym -> auto___def_66 (cons X5 (cons server nil)) -> auto___type_9 (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto. exact (rem_1129 X1 X2 X3 X4 X5).
Qed.

Remark rem_1131 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_53 (cons X4 (cons X1 (cons X5 nil))) -> auto___type_9 (noncea_current X3 X4) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_298 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1130 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1132 : forall X1 X2 X3 X4 X5:term, auto___type_9 (noncea_current X3 X4) -> auto___def_53 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_53 (cons X4 (cons X1 (cons X5 nil))) -> auto___type_9 (noncea_current X3 X4) -> auto___def_70 X1 X2). tauto. exact (rem_1131 X1 X2 X3 X4 X5).
Qed.

Remark rem_1133 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_51 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_860 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1132 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1134 : forall X1 X2 X3 X4 X5:term, auto___def_51 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_51 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1133 X1 X2 X3 X4 X5).
Qed.

Remark rem_1135 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (noncea_current X1 X2) -> auto_agent X1 -> auto_agent X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_584 X1 X2 H);  intros.
Defined.

Remark rem_1136 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto_knows_current (noncea_current X1 X2) -> auto___def_13 (noncea_current X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_416 X1 X2 H);  intros.
  apply (rem_1135 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_1137 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> auto___def_13 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intro H. intros.
  elim (rem_585 H);  intros.
Defined.

Remark rem_1138 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> auto_knows_current bob -> auto___def_13 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intro H. intros.
  elim (rem_420 H);  intros.
  apply (rem_1137 epsilon_mknows_current_m__def_13);  tauto.
Defined.

Remark rem_1139 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> auto___def_13 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intro H. intros.
  elim (rem_587 H);  intros.
Defined.

Remark rem_1140 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> auto_knows_current alice -> auto___def_13 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intro H. intros.
  elim (rem_423 H);  intros.
  apply (rem_1139 epsilon_mknows_current_m__def_13);  tauto.
Defined.

Remark rem_1141 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (cons X1 X2) -> auto_knows_current X1 -> auto_knows_current X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_588 X1 X2 H);  intros.
Defined.

Remark rem_1142 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto_knows_current (cons X1 X2) -> auto___def_13 (cons X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_431 X1 X2 H);  intros.
  apply (rem_1141 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_1143 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1:term, auto___def_13 (s X1) -> auto_knows_current X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1. intro H. intros.
  elim (rem_589 X1 H);  intros.
Defined.

Remark rem_1144 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1:term, auto_knows_current (s X1) -> auto___def_13 (s X1) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1. intro H. intros.
  elim (rem_435 X1 H);  intros.
  apply (rem_1143 epsilon_mknows_current_m__def_13 X1);  tauto.
Defined.

Remark rem_1145 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> auto___def_13 nil -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intro H. intros.
  elim (rem_590 H);  intros.
Defined.

Remark rem_1146 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> auto_knows_current nil -> auto___def_13 nil -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intro H. intros.
  elim (rem_438 H);  intros.
  apply (rem_1145 epsilon_mknows_current_m__def_13);  tauto.
Defined.

Remark rem_1147 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> auto___def_13 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intro H. intros.
  elim (rem_591 H);  intros.
Defined.

Remark rem_1148 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> auto_knows_current i -> auto___def_13 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intro H. intros.
  elim (rem_441 H);  intros.
  apply (rem_1147 epsilon_mknows_current_m__def_13);  tauto.
Defined.

Remark rem_1149 : (forall X:term, auto___def_40 X -> auto___def_29 X -> False)
    -> forall X1 X2 X3:term, auto___def_29 (session_old X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_40_m__def_29. intros X1 X2 X3. intro H. intros.
  elim (rem_1070 X1 X2 X3 H);  intros.
Defined.

Remark rem_1150 : forall X1 X2 X3:term, auto___def_40 (session_old X1 X2 X3) -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1151 : (forall X:term, auto___def_40 X -> auto___def_29 X -> False)
    -> forall X1 X2 X3:term, auto___def_40 (session_old X1 X2 X3) -> auto___def_29 (session_old X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_40_m__def_29. intros X1 X2 X3. intro H. intros.
  elim (rem_1150 X1 X2 X3 H);  intros.
  apply (rem_1149 epsilon_m__def_40_m__def_29 X1 X2 X3);  tauto.
Defined.

Remark rem_1152 : forall X1 X2:term, auto___def_40 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1153 : auto___def_40 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1154 : auto___def_40 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1155 : forall X1:term, auto___def_40 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1156 : auto___def_40 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1157 : auto___def_40 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1158 : forall X1 X2:term, auto___def_40 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1159 : forall X1 X2 X3:term, auto___def_40 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1160 : forall X1 X2 X3:term, auto___def_40 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1161 : forall X1 X2:term, auto___def_40 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1162 : forall X1 X2:term, auto___def_40 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1163 : auto___def_40 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1164 : auto___def_40 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1165 : auto___def_40 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1166 : auto___def_40 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1167 : forall X2:term, auto___def_40 X2 -> auto___def_29 X2 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_40_m__def_29 1.
  intro X. case X.
   intro H. elim (rem_1154  H).
   intro H. elim (rem_1153  H).
  intros X1 X2. intro H. elim (rem_862 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1161 X1 X2 H).
   intro H. elim (rem_1157  H).
  intros X1 X2. intro H. elim (rem_1158 X1 X2 H).
   intro H. elim (rem_1156  H).
  intros X1 X2. intro H. elim (rem_1152 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1162 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1159 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1160 X1 X2 X3 H).
   intro H. elim (rem_1165  H).
   intro H. elim (rem_1163  H).
  intros X1. intro H. elim (rem_1155 X1 H).
   intro H. elim (rem_1164  H).
  intros X1 X2 X3. intro H. elim (rem_625 X1 X2 X3 H).
  intros X1 X2 X3;  exact (rem_1151 epsilon_m__def_40_m__def_29 X1 X2 X3).
   intro H. elim (rem_1166  H).
Qed.

Remark rem_1168 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X2:term, auto___def_40 X2 -> auto___def_29 X2 -> False. (* Cut history. *)
Proof.  intros epsilon_mknows_current_m__def_13. exact (rem_1167).
Defined.

Remark rem_1169 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_29 X2 -> auto___def_18 X1 -> auto___def_40 X2 -> auto___def_39 X1 -> False. (* Split. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2.
  cut (auto___def_40 X2 -> auto___def_29 X2 -> False). clear  epsilon_mknows_current_m__def_13. tauto.
  exact (rem_1168 epsilon_mknows_current_m__def_13 X2).
Defined.

Remark rem_1170 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (key X1 X2) -> auto___def_39 X1 -> auto___def_40 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_167 X1 X2 H);  intros.
  apply (rem_1169 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_1171 : (forall X:term, auto___def_18 X -> auto___def_35 X -> False)
    -> auto___def_35 sym -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_18_m__def_35. intro H. intros.
  elim (rem_239 H);  intros.
Defined.

Remark rem_1172 : auto___def_18 sym -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1173 : (forall X:term, auto___def_18 X -> auto___def_35 X -> False)
    -> auto___def_18 sym -> auto___def_35 sym -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_18_m__def_35. intro H. intros.
  elim (rem_1172 H);  intros.
  apply (rem_1171 epsilon_m__def_18_m__def_35);  tauto.
Defined.

Remark rem_1174 : forall X1 X2:term, auto___def_18 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1175 : auto___def_18 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1176 : forall X1 X2 X3:term, auto___def_18 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1177 : auto___def_18 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1178 : forall X1 X2:term, auto___def_18 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1179 : forall X1:term, auto___def_18 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1180 : auto___def_18 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1181 : auto___def_18 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1182 : forall X1 X2:term, auto___def_18 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1183 : forall X1 X2 X3:term, auto___def_18 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1184 : forall X1 X2 X3:term, auto___def_18 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1185 : forall X1 X2:term, auto___def_18 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1186 : forall X1 X2 X3:term, auto___def_18 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1187 : forall X1 X2:term, auto___def_18 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1188 : auto___def_18 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1189 : auto___def_18 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1190 : forall X1:term, auto___def_18 X1 -> auto___def_35 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_18_m__def_35 1.
  intro X. case X.
   intro H. elim (rem_1177  H).
   intro H. elim (rem_1175  H).
  intros X1 X2. intro H. elim (rem_1178 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1185 X1 X2 H).
   intro H. elim (rem_1181  H).
  intros X1 X2. intro H. elim (rem_1182 X1 X2 H).
   intro H. elim (rem_1180  H).
  intros X1 X2. intro H. elim (rem_1174 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1187 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1183 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1184 X1 X2 X3 H).
   intro H. elim (rem_163  H).
   intro H. elim (rem_1188  H).
  intros X1. intro H. elim (rem_1179 X1 H).
   intro H. elim (rem_1189  H).
  intros X1 X2 X3. intro H. elim (rem_1176 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1186 X1 X2 X3 H).
  exact (rem_1173 epsilon_m__def_18_m__def_35 ).
Qed.

Remark rem_1191 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1:term, auto___def_18 X1 -> auto___def_35 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_mknows_current_m__def_13. exact (rem_1190).
Defined.

Remark rem_1192 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_29 X2 -> auto___def_18 X1 -> auto___type_8 X2 -> auto___def_35 X1 -> False. (* Split. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_35 X1 -> False). clear  epsilon_mknows_current_m__def_13. tauto.
  exact (rem_1191 epsilon_mknows_current_m__def_13 X1).
Defined.

Remark rem_1193 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (key X1 X2) -> auto___def_35 X1 -> auto___type_8 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_167 X1 X2 H);  intros.
  apply (rem_1192 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_1194 : (forall X:term, auto___def_18 X -> auto___def_36 X -> False)
    -> auto___def_36 sym -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_18_m__def_36. intro H. intros.
  elim (rem_655 H);  intros.
Defined.

Remark rem_1195 : (forall X:term, auto___def_18 X -> auto___def_36 X -> False)
    -> auto___def_18 sym -> auto___def_36 sym -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_18_m__def_36. intro H. intros.
  elim (rem_1172 H);  intros.
  apply (rem_1194 epsilon_m__def_18_m__def_36);  tauto.
Defined.

Remark rem_1196 : forall X1:term, auto___def_18 X1 -> auto___def_36 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_18_m__def_36 1.
  intro X. case X.
   intro H. elim (rem_1177  H).
   intro H. elim (rem_1175  H).
  intros X1 X2. intro H. elim (rem_1178 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1185 X1 X2 H).
   intro H. elim (rem_1181  H).
  intros X1 X2. intro H. elim (rem_1182 X1 X2 H).
   intro H. elim (rem_1180  H).
  intros X1 X2. intro H. elim (rem_1174 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1187 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1183 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1184 X1 X2 X3 H).
   intro H. elim (rem_163  H).
   intro H. elim (rem_1188  H).
  intros X1. intro H. elim (rem_1179 X1 H).
   intro H. elim (rem_1189  H).
  intros X1 X2 X3. intro H. elim (rem_1176 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1186 X1 X2 X3 H).
  exact (rem_1195 epsilon_m__def_18_m__def_36 ).
Qed.

Remark rem_1197 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1:term, auto___def_18 X1 -> auto___def_36 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_mknows_current_m__def_13. exact (rem_1196).
Defined.

Remark rem_1198 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_29 X2 -> auto___def_18 X1 -> auto___def_36 X1 -> auto___def_37 X2 -> False. (* Split. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_36 X1 -> False). clear  epsilon_mknows_current_m__def_13. tauto.
  exact (rem_1197 epsilon_mknows_current_m__def_13 X1).
Defined.

Remark rem_1199 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (key X1 X2) -> auto___def_36 X1 -> auto___def_37 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_167 X1 X2 H);  intros.
  apply (rem_1198 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_1200 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto_knows_current (key X1 X2) -> auto___def_13 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_310 X1 X2 H);  intros.
  apply (rem_1170 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
  apply (rem_1193 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
  apply (rem_1199 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_1201 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2 X3:term, auto___def_13 (nonceb_current X1 X2 X3) -> auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2 X3. intro H. intros.
  elim (rem_592 X1 X2 X3 H);  intros.
Defined.

Remark rem_1202 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2 X3:term, auto___def_13 (nonceb_current X1 X2 X3) -> auto___def_55 X1 -> auto___type_11 X2 -> auto___type_10 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2 X3. intro H. intros.
  elim (rem_592 X1 X2 X3 H);  intros.
Defined.

Remark rem_1203 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2 X3:term, auto_knows_current (nonceb_current X1 X2 X3) -> auto___def_13 (nonceb_current X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2 X3. intro H. intros.
  elim (rem_478 X1 X2 X3 H);  intros.
  apply (rem_1201 epsilon_mknows_current_m__def_13 X1 X2 X3);  tauto.
  apply (rem_1202 epsilon_mknows_current_m__def_13 X1 X2 X3);  tauto.
Defined.

Remark rem_1204 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2 X3:term, auto___def_13 (nonceb_old X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2 X3. intro H. intros.
  elim (rem_593 X1 X2 X3 H);  intros.
Defined.

Remark rem_1205 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2 X3:term, auto_knows_current (nonceb_old X1 X2 X3) -> auto___def_13 (nonceb_old X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2 X3. intro H. intros.
  elim (rem_481 X1 X2 X3 H);  intros.
  apply (rem_1204 epsilon_mknows_current_m__def_13 X1 X2 X3);  tauto.
Defined.

Remark rem_1206 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (crypt X1 X2) -> auto___def_71 X1 -> auto___type_13 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_594 X1 X2 H);  intros.
Defined.

Remark rem_1207 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (crypt X1 X2) -> auto___def_69 X1 -> auto___type_12 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_594 X1 X2 H);  intros.
Defined.

Remark rem_1208 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (crypt X1 X2) -> auto___def_12 X1 -> auto___def_13 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_594 X1 X2 H);  intros.
Defined.

Remark rem_1209 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (crypt X1 X2) -> auto___def_61 X1 -> auto___def_62 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_594 X1 X2 H);  intros.
Defined.

Remark rem_1210 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (crypt X1 X2) -> auto___def_22 X1 -> auto___def_23 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_594 X1 X2 H);  intros.
Defined.

Remark rem_1211 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (crypt X1 X2) -> auto___def_51 X1 -> auto___def_52 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_594 X1 X2 H);  intros.
Defined.

Remark rem_1212 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (crypt X1 X2) -> auto_knows_current X1 -> auto_knows_current X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_594 X1 X2 H);  intros.
Defined.

Remark rem_1213 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto_knows_current (crypt X1 X2) -> auto___def_13 (crypt X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_312 X1 X2 H);  intros.
  apply (rem_1206 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
  apply (rem_1207 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
  apply (rem_1208 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
  apply (rem_1209 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
  apply (rem_1210 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
  apply (rem_1211 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
  apply (rem_1212 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_1214 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (noncea_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_596 X1 X2 H);  intros.
Defined.

Remark rem_1215 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto_knows_current (noncea_old X1 X2) -> auto___def_13 (noncea_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_522 X1 X2 H);  intros.
  apply (rem_1214 epsilon_mknows_current_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_1216 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> auto___def_13 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intro H. intros.
  elim (rem_598 H);  intros.
Defined.

Remark rem_1217 : (forall X:term, auto_knows_current X -> auto___def_13 X -> False)
    -> auto_knows_current server -> auto___def_13 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_13. intro H. intros.
  elim (rem_525 H);  intros.
  apply (rem_1216 epsilon_mknows_current_m__def_13);  tauto.
Defined.

Remark rem_1218 : forall X1:term, auto_knows_current X1 -> auto___def_13 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_mknows_current_m__def_13 1.
  intro X. case X.
  exact (rem_1140 epsilon_mknows_current_m__def_13 ).
  exact (rem_1138 epsilon_mknows_current_m__def_13 ).
  intros X1 X2;  exact (rem_1142 epsilon_mknows_current_m__def_13 X1 X2).
  intros X1 X2;  exact (rem_1213 epsilon_mknows_current_m__def_13 X1 X2).
  exact (rem_1148 epsilon_mknows_current_m__def_13 ).
  intros X1 X2;  exact (rem_1200 epsilon_mknows_current_m__def_13 X1 X2).
  exact (rem_1146 epsilon_mknows_current_m__def_13 ).
  intros X1 X2;  exact (rem_1136 epsilon_mknows_current_m__def_13 X1 X2).
  intros X1 X2;  exact (rem_1215 epsilon_mknows_current_m__def_13 X1 X2).
  intros X1 X2 X3;  exact (rem_1203 epsilon_mknows_current_m__def_13 X1 X2 X3).
  intros X1 X2 X3;  exact (rem_1205 epsilon_mknows_current_m__def_13 X1 X2 X3).
   intro H. elim (rem_530  H).
   intro H. elim (rem_529  H).
  intros X1;  exact (rem_1144 epsilon_mknows_current_m__def_13 X1).
  exact (rem_1217 epsilon_mknows_current_m__def_13 ).
  intros X1 X2 X3. intro H. elim (rem_527 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_528 X1 X2 X3 H).
   intro H. elim (rem_531  H).
Qed.

Remark rem_1219 : forall X1 X2 X3:term, auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_current X1 -> auto_knows_current (cons X3 nil) -> auto___def_70 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3. intros.
  assert (HH:=(rem_1218 X1)). tauto.
Qed.

Remark rem_1220 : forall X1 X2 X3:term, auto_knows_current X1 -> auto_knows_current (cons X3 nil) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_current X1 -> auto_knows_current (cons X3 nil) -> auto___def_70 X1 X2). tauto. exact (rem_1219 X1 X2 X3).
Qed.

Remark rem_1221 : forall X1 X2 X3:term, auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_current (cons X1 (cons X3 nil)) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1 H2. intro H. intros.
  elim (rem_431 X1 (cons X3 nil) H);  intros.
  apply (rem_1220 X1 X2 X3);  tauto.
Qed.

Remark rem_1222 : forall X1 X2 X4:term, auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_current (cons X1 (cons X4 nil)) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_current (cons X1 (cons X3 nil)) -> auto___def_70 X1 X2). tauto. exact (rem_1221 X1 X2 X3).
Qed.

Remark rem_1223 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_current X3 -> auto_knows_current (cons X1 (cons X4 nil)) -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_current (cons X1 (cons X4 nil)) -> auto___def_70 X1 X2). tauto.
  exact (rem_1222 X1 X2 X4).
Qed.

Remark rem_1224 : forall X1 X2 X3 X4 X5:term, auto_knows_current X3 -> auto_knows_current (cons X1 (cons X4 nil)) -> auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_current X3 -> auto_knows_current (cons X1 (cons X4 nil)) -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto. exact (rem_1223 X1 X2 X3 X4 X5).
Qed.

Remark rem_1225 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_current (cons X3 (cons X1 (cons X4 nil))) -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_431 X3 (cons X1 (cons X4 nil)) H);  intros.
  apply (rem_1224 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1226 : forall X1 X2 X3 X4 X5:term, auto_knows_current (noncea_current X3 X4) -> auto_knows_current (cons X4 (cons X1 (cons X5 nil))) -> auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_current (cons X3 (cons X1 (cons X4 nil))) -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto. exact (rem_1225 X1 X2 X3 X4 X5).
Qed.

Remark rem_1227 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_current (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_431 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1226 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1228 : forall X1 X2 X3 X4 X5:term, auto_knows_current (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_current (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1227 X1 X2 X3 X4 X5).
Qed.

Remark rem_1229 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_current (crypt (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_312 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil))) H);  intros.
  apply (rem_1067 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1069 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1108 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1112 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1116 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1134 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1228 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1230 : forall X1 X2 X3 X4 X5:term, auto___def_61 X2 -> auto___def_62 X1 -> auto___def_71 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_13 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_801 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
Qed.

Remark rem_1231 : forall X1 X2 X3 X4 X5:term, auto___def_71 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_13 (key sym (cons X3 (cons server nil))) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_61 X2 -> auto___def_62 X1 -> auto___def_71 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_13 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1230 X1 X2 X3 X4 X5).
Qed.

Remark rem_1232 : forall X1 X2 X3 X4 X5:term, auto___def_61 X2 -> auto___def_62 X1 -> auto___def_69 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_803 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
Qed.

Remark rem_1233 : forall X1 X2 X3 X4 X5:term, auto___def_69 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_61 X2 -> auto___def_62 X1 -> auto___def_69 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1232 X1 X2 X3 X4 X5).
Qed.

Remark rem_1234 : (forall X:term, auto___def_64 X -> auto___def_19 X -> False)
    -> forall X1 X2:term, auto___def_19 (cons X1 X2) -> auto___type_10 X1 -> auto___def_65 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_64_m__def_19. intros X1 X2. intro H. intros.
  elim (rem_1078 X1 X2 H);  intros.
Defined.

Remark rem_1235 : forall X1 X2:term, auto___def_64 (cons X1 X2) -> or_1
    (auto___type_10 X1 /\ auto___def_65 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1236 : (forall X:term, auto___def_64 X -> auto___def_19 X -> False)
    -> forall X1 X2:term, auto___def_64 (cons X1 X2) -> auto___def_19 (cons X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_64_m__def_19. intros X1 X2. intro H. intros.
  elim (rem_1235 X1 X2 H);  intros.
  apply (rem_1234 epsilon_m__def_64_m__def_19 X1 X2);  tauto.
Defined.

Remark rem_1237 : forall X1 X2:term, auto___def_64 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1238 : auto___def_64 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1239 : auto___def_64 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1240 : forall X1:term, auto___def_64 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1241 : auto___def_64 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1242 : auto___def_64 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1243 : forall X1 X2:term, auto___def_64 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1244 : forall X1 X2 X3:term, auto___def_64 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1245 : forall X1 X2 X3:term, auto___def_64 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1246 : forall X1 X2:term, auto___def_64 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1247 : forall X1 X2 X3:term, auto___def_64 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1248 : forall X1 X2:term, auto___def_64 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1249 : auto___def_64 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1250 : auto___def_64 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1251 : auto___def_64 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1252 : auto___def_64 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1253 : forall X2:term, auto___def_64 X2 -> auto___def_19 X2 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_64_m__def_19 1.
  intro X. case X.
   intro H. elim (rem_1239  H).
   intro H. elim (rem_1238  H).
  intros X1 X2;  exact (rem_1236 epsilon_m__def_64_m__def_19 X1 X2).
  intros X1 X2. intro H. elim (rem_1246 X1 X2 H).
   intro H. elim (rem_1242  H).
  intros X1 X2. intro H. elim (rem_1243 X1 X2 H).
   intro H. elim (rem_1241  H).
  intros X1 X2. intro H. elim (rem_1237 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1248 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1244 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1245 X1 X2 X3 H).
   intro H. elim (rem_1251  H).
   intro H. elim (rem_1249  H).
  intros X1. intro H. elim (rem_1240 X1 H).
   intro H. elim (rem_1250  H).
  intros X1 X2 X3. intro H. elim (rem_743 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1247 X1 X2 X3 H).
   intro H. elim (rem_1252  H).
Qed.

Remark rem_1254 : (forall X:term, auto___def_16 X -> auto___def_62 X -> False)
    -> forall X2:term, auto___def_64 X2 -> auto___def_19 X2 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_16_m__def_62. exact (rem_1253).
Defined.

Remark rem_1255 : (forall X:term, auto___def_16 X -> auto___def_62 X -> False)
    -> forall X1 X2:term, auto___def_57 X1 -> auto___def_19 X2 -> auto___def_18 X1 -> auto___def_64 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_16_m__def_62. intros X1 X2.
  cut (auto___def_64 X2 -> auto___def_19 X2 -> False). clear  epsilon_m__def_16_m__def_62. tauto.
  exact (rem_1254 epsilon_m__def_16_m__def_62 X2).
Defined.

Remark rem_1256 : (forall X:term, auto___def_16 X -> auto___def_62 X -> False)
    -> forall X1 X2:term, auto___def_62 (key X1 X2) -> auto___def_18 X1 -> auto___def_19 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_16_m__def_62. intros X1 X2. intro H. intros.
  elim (rem_291 X1 X2 H);  intros.
  apply (rem_1255 epsilon_m__def_16_m__def_62 X1 X2);  tauto.
Defined.

Remark rem_1257 : (forall X:term, auto___def_16 X -> auto___def_62 X -> False)
    -> forall X1 X2:term, auto___def_16 (key X1 X2) -> auto___def_62 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_16_m__def_62. intros X1 X2. intro H. intros.
  elim (rem_7 X1 X2 H);  intros.
  apply (rem_1256 epsilon_m__def_16_m__def_62 X1 X2);  tauto.
Defined.

Remark rem_1258 : forall X1:term, auto___def_16 X1 -> auto___def_62 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_16_m__def_62 1.
  intro X. case X.
   intro H. elim (rem_12  H).
   intro H. elim (rem_10  H).
  intros X1 X2. intro H. elim (rem_13 X1 X2 H).
  intros X1 X2. intro H. elim (rem_19 X1 X2 H).
   intro H. elim (rem_16  H).
  intros X1 X2;  exact (rem_1257 epsilon_m__def_16_m__def_62 X1 X2).
   intro H. elim (rem_15  H).
  intros X1 X2. intro H. elim (rem_9 X1 X2 H).
  intros X1 X2. intro H. elim (rem_21 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_17 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_18 X1 X2 X3 H).
   intro H. elim (rem_24  H).
   intro H. elim (rem_22  H).
  intros X1. intro H. elim (rem_14 X1 H).
   intro H. elim (rem_23  H).
  intros X1 X2 X3. intro H. elim (rem_11 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_20 X1 X2 X3 H).
   intro H. elim (rem_25  H).
Qed.

Remark rem_1259 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___def_17 (cons X3 nil) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_70 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3. intros.
  assert (HH:=(rem_1258 X1)). tauto.
Qed.

Remark rem_1260 : forall X1 X2 X3:term, auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_222 X1 (cons X3 nil) H);  intros.
  apply (rem_1259 X1 X2 X3);  tauto.
Qed.

Remark rem_1261 : forall X1 X2 X3 X4 X5:term, auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_29 (cons X4 (cons server nil)) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___type_3 (noncea_current X4 X5) -> auto___type_4 X5 -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_70 X1 X2). tauto.
  exact (rem_1260 X1 X2 X3).
Qed.

Remark rem_1262 : forall X1 X2 X3 X4 X5:term, auto___type_4 X3 -> auto___def_15 (cons X1 (cons X4 nil)) -> auto___def_29 (cons X5 (cons server nil)) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___type_3 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_29 (cons X4 (cons server nil)) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___type_3 (noncea_current X4 X5) -> auto___type_4 X5 -> auto___def_70 X1 X2). tauto. exact (rem_1261 X1 X2 X3 X4 X5).
Qed.

Remark rem_1263 : forall X1 X2 X3 X4 X5:term, auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_29 (cons X5 (cons server nil)) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___type_3 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_225 X3 (cons X1 (cons X4 nil)) H);  intros.
  apply (rem_1262 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1264 : forall X1 X2 X3 X4 X5:term, auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_18 sym -> auto___def_29 (cons X5 (cons server nil)) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___type_3 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_29 (cons X5 (cons server nil)) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___type_3 (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto.
  exact (rem_1263 X1 X2 X3 X4 X5).
Qed.

Remark rem_1265 : forall X1 X2 X3 X4 X5:term, auto___def_18 sym -> auto___def_29 (cons X3 (cons server nil)) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___type_3 (noncea_current X3 X4) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_18 sym -> auto___def_29 (cons X5 (cons server nil)) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___type_3 (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto. exact (rem_1264 X1 X2 X3 X4 X5).
Qed.

Remark rem_1266 : forall X1 X2 X3 X4 X5:term, auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___type_3 (noncea_current X3 X4) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_167 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1265 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1267 : forall X1 X2 X3 X4 X5:term, auto___type_3 (noncea_current X3 X4) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___type_3 (noncea_current X3 X4) -> auto___def_70 X1 X2). tauto. exact (rem_1266 X1 X2 X3 X4 X5).
Qed.

Remark rem_1268 : forall X1 X2 X3 X4 X5:term, auto___def_12 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_231 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1267 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1269 : forall X1 X2 X3 X4 X5:term, auto___def_55 (noncea_current X3 X4) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_63 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_604 X3 X4 H);  intros.
Qed.

Remark rem_1270 : forall X1 X2 X3 X4 X5:term, auto___def_55 (noncea_current X3 X4) -> auto___def_63 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_55 (noncea_current X3 X4) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_63 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1269 X1 X2 X3 X4 X5).
Qed.

Remark rem_1271 : forall X1 X2 X3 X4 X5:term, auto___def_61 X2 -> auto___def_61 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_62 X1 -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_823 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1270 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1272 : forall X1 X2 X3 X4 X5:term, auto___def_61 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_61 X2 -> auto___def_61 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_62 X1 -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1271 X1 X2 X3 X4 X5).
Qed.

Remark rem_1273 : forall X1 X2 X3 X4 X5:term, auto___def_16 (noncea_current X3 X4) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_24 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_9 X3 X4 H);  intros.
Qed.

Remark rem_1274 : forall X1 X2 X3 X4 X5:term, auto___def_16 (noncea_current X3 X4) -> auto___def_24 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_16 (noncea_current X3 X4) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_24 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_70 X1 X2). tauto. exact (rem_1273 X1 X2 X3 X4 X5).
Qed.

Remark rem_1275 : forall X1 X2 X3 X4 X5:term, auto___def_22 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_237 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1274 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1276 : forall X1:term, auto___def_62 X1 -> auto___def_62 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1277 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_62 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_62 X1 -> auto___def_62 X1). tauto. exact (rem_1276 X1).
Qed.

Remark rem_1278 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_55 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_55 X1 -> auto___def_55 X1). tauto. exact (rem_258 X1).
Qed.

Remark rem_1279 : forall X2:term, auto___def_61 X2 -> auto___def_61 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1280 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_61 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_61 X2 -> auto___def_61 X2). tauto. exact (rem_1279 X2).
Qed.

Remark rem_1281 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_61 X2 -> auto___def_62 X1 -> (auto___def_62 X1 /\ auto___def_55 X1 /\ auto___def_61 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  cut (auto___def_62 X1). 2:apply (rem_1277 X1 X2 X3);  assumption.
  cut (auto___def_55 X1). 2:apply (rem_1278 X1 X2 X3);  assumption.
  cut (auto___def_61 X2). 2:apply (rem_1280 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_1282 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_70 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  case (rem_1281 X1 X2 X3 A1 A2 A3 A4). clear  A1 A2 A3 A4. intros. apply trans___def_70_6;  tauto.
 clear  A1 A2 A3 A4. tauto.
Qed.

Remark rem_1283 : forall X1 X2 X3:term, auto___def_54 (cons X1 (cons X3 nil)) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_851 X1 (cons X3 nil) H);  intros.
  apply (rem_1282 X1 X2 X3);  tauto.
Qed.

Remark rem_1284 : forall X1 X2 X3 X4 X5:term, auto___def_54 (cons X1 (cons X3 nil)) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_66 (cons X4 (cons server nil)) -> auto___type_10 X5 -> auto___type_9 (noncea_current X4 X5) -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_54 (cons X1 (cons X3 nil)) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_70 X1 X2). tauto.
  exact (rem_1283 X1 X2 X3).
Qed.

Remark rem_1285 : forall X1 X2 X3 X4 X5:term, auto___type_10 X3 -> auto___def_54 (cons X1 (cons X4 nil)) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_66 (cons X5 (cons server nil)) -> auto___type_9 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_54 (cons X1 (cons X3 nil)) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_66 (cons X4 (cons server nil)) -> auto___type_10 X5 -> auto___type_9 (noncea_current X4 X5) -> auto___def_70 X1 X2). tauto. exact (rem_1284 X1 X2 X3 X4 X5).
Qed.

Remark rem_1286 : forall X1 X2 X3 X4 X5:term, auto___def_53 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_66 (cons X5 (cons server nil)) -> auto___type_9 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_854 X3 (cons X1 (cons X4 nil)) H);  intros.
  apply (rem_1285 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1287 : forall X1 X2 X3 X4 X5:term, auto___def_53 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_57 sym -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_66 (cons X5 (cons server nil)) -> auto___type_9 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_53 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_66 (cons X5 (cons server nil)) -> auto___type_9 (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto.
  exact (rem_1286 X1 X2 X3 X4 X5).
Qed.

Remark rem_1288 : forall X1 X2 X3 X4 X5:term, auto___def_57 sym -> auto___def_66 (cons X3 (cons server nil)) -> auto___def_53 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___type_9 (noncea_current X3 X4) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_53 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_57 sym -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_66 (cons X5 (cons server nil)) -> auto___type_9 (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto. exact (rem_1287 X1 X2 X3 X4 X5).
Qed.

Remark rem_1289 : forall X1 X2 X3 X4 X5:term, auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_53 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___type_9 (noncea_current X3 X4) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_298 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1288 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1290 : forall X1 X2 X3 X4 X5:term, auto___type_9 (noncea_current X3 X4) -> auto___def_53 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_53 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___type_9 (noncea_current X3 X4) -> auto___def_70 X1 X2). tauto. exact (rem_1289 X1 X2 X3 X4 X5).
Qed.

Remark rem_1291 : forall X1 X2 X3 X4 X5:term, auto___def_51 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_860 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1290 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1292 : (forall X:term, auto___def_64 X -> auto___def_40 X -> False)
    -> forall X1 X2:term, auto___def_40 (cons X1 X2) -> auto___type_10 X1 -> auto___def_65 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_64_m__def_40. intros X1 X2. intro H. intros.
  elim (rem_862 X1 X2 H);  intros.
Defined.

Remark rem_1293 : (forall X:term, auto___def_64 X -> auto___def_40 X -> False)
    -> forall X1 X2:term, auto___def_64 (cons X1 X2) -> auto___def_40 (cons X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_64_m__def_40. intros X1 X2. intro H. intros.
  elim (rem_1235 X1 X2 H);  intros.
  apply (rem_1292 epsilon_m__def_64_m__def_40 X1 X2);  tauto.
Defined.

Remark rem_1294 : forall X2:term, auto___def_64 X2 -> auto___def_40 X2 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_64_m__def_40 1.
  intro X. case X.
   intro H. elim (rem_1239  H).
   intro H. elim (rem_1238  H).
  intros X1 X2;  exact (rem_1293 epsilon_m__def_64_m__def_40 X1 X2).
  intros X1 X2. intro H. elim (rem_1246 X1 X2 H).
   intro H. elim (rem_1242  H).
  intros X1 X2. intro H. elim (rem_1243 X1 X2 H).
   intro H. elim (rem_1241  H).
  intros X1 X2. intro H. elim (rem_1237 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1248 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1244 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1245 X1 X2 X3 H).
   intro H. elim (rem_1251  H).
   intro H. elim (rem_1249  H).
  intros X1. intro H. elim (rem_1240 X1 H).
   intro H. elim (rem_1250  H).
  intros X1 X2 X3. intro H. elim (rem_743 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1247 X1 X2 X3 H).
   intro H. elim (rem_1252  H).
Qed.

Remark rem_1295 : (forall X:term, auto___def_62 X -> auto_knows_current X -> False)
    -> forall X2:term, auto___def_64 X2 -> auto___def_40 X2 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_62_mknows_current. exact (rem_1294).
Defined.

Remark rem_1296 : (forall X:term, auto___def_62 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto___def_57 X1 -> auto___def_40 X2 -> auto___def_64 X2 -> auto___def_39 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_62_mknows_current. intros X1 X2.
  cut (auto___def_64 X2 -> auto___def_40 X2 -> False). clear  epsilon_m__def_62_mknows_current. tauto.
  exact (rem_1295 epsilon_m__def_62_mknows_current X2).
Defined.

Remark rem_1297 : (forall X:term, auto___def_62 X -> auto_knows_current X -> False)
    -> forall X1:term, auto___def_57 X1 -> auto___def_35 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_62_mknows_current. exact (rem_651).
Defined.

Remark rem_1298 : (forall X:term, auto___def_62 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto___def_57 X1 -> auto___type_8 X2 -> auto___def_35 X1 -> auto___def_64 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_62_mknows_current. intros X1 X2.
  cut (auto___def_57 X1 -> auto___def_35 X1 -> False). clear  epsilon_m__def_62_mknows_current. tauto.
  exact (rem_1297 epsilon_m__def_62_mknows_current X1).
Defined.

Remark rem_1299 : (forall X:term, auto___def_62 X -> auto_knows_current X -> False)
    -> forall X1:term, auto___def_57 X1 -> auto___def_36 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_62_mknows_current. exact (rem_658).
Defined.

Remark rem_1300 : (forall X:term, auto___def_62 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto___def_57 X1 -> auto___def_64 X2 -> auto___def_36 X1 -> auto___def_37 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_62_mknows_current. intros X1 X2.
  cut (auto___def_57 X1 -> auto___def_36 X1 -> False). clear  epsilon_m__def_62_mknows_current. tauto.
  exact (rem_1299 epsilon_m__def_62_mknows_current X1).
Defined.

Remark rem_1301 : (forall X:term, auto___def_62 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto_knows_current (key X1 X2) -> auto___def_57 X1 -> auto___def_64 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_62_mknows_current. intros X1 X2. intro H. intros.
  elim (rem_310 X1 X2 H);  intros.
  apply (rem_1296 epsilon_m__def_62_mknows_current X1 X2);  tauto.
  apply (rem_1298 epsilon_m__def_62_mknows_current X1 X2);  tauto.
  apply (rem_1300 epsilon_m__def_62_mknows_current X1 X2);  tauto.
Defined.

Remark rem_1302 : (forall X:term, auto___def_62 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto___def_62 (key X1 X2) -> auto_knows_current (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_62_mknows_current. intros X1 X2. intro H. intros.
  elim (rem_291 X1 X2 H);  intros.
  apply (rem_1301 epsilon_m__def_62_mknows_current X1 X2);  tauto.
Defined.

Remark rem_1303 : forall X1:term, auto___def_62 X1 -> auto_knows_current X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_62_mknows_current 1.
  intro X. case X.
   intro H. elim (rem_754  H).
   intro H. elim (rem_752  H).
  intros X1 X2. intro H. elim (rem_755 X1 X2 H).
  intros X1 X2. intro H. elim (rem_761 X1 X2 H).
   intro H. elim (rem_758  H).
  intros X1 X2;  exact (rem_1302 epsilon_m__def_62_mknows_current X1 X2).
   intro H. elim (rem_757  H).
  intros X1 X2. intro H. elim (rem_751 X1 X2 H).
  intros X1 X2. intro H. elim (rem_763 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_759 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_760 X1 X2 X3 H).
   intro H. elim (rem_766  H).
   intro H. elim (rem_764  H).
  intros X1. intro H. elim (rem_756 X1 H).
   intro H. elim (rem_765  H).
  intros X1 X2 X3. intro H. elim (rem_753 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_762 X1 X2 X3 H).
   intro H. elim (rem_767  H).
Qed.

Remark rem_1304 : forall X1 X2 X3:term, auto___def_61 X2 -> auto___def_62 X1 -> auto_knows_current X1 -> auto_knows_current (cons X3 nil) -> auto___def_70 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3. intros.
  assert (HH:=(rem_1303 X1)). tauto.
Qed.

Remark rem_1305 : forall X1 X2 X3:term, auto_knows_current X1 -> auto_knows_current (cons X3 nil) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_61 X2 -> auto___def_62 X1 -> auto_knows_current X1 -> auto_knows_current (cons X3 nil) -> auto___def_70 X1 X2). tauto. exact (rem_1304 X1 X2 X3).
Qed.

Remark rem_1306 : forall X1 X2 X3:term, auto___def_61 X2 -> auto___def_62 X1 -> auto_knows_current (cons X1 (cons X3 nil)) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1 H2. intro H. intros.
  elim (rem_431 X1 (cons X3 nil) H);  intros.
  apply (rem_1305 X1 X2 X3);  tauto.
Qed.

Remark rem_1307 : forall X1 X2 X4:term, auto___def_61 X2 -> auto___def_62 X1 -> auto_knows_current (cons X1 (cons X4 nil)) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_61 X2 -> auto___def_62 X1 -> auto_knows_current (cons X1 (cons X3 nil)) -> auto___def_70 X1 X2). tauto. exact (rem_1306 X1 X2 X3).
Qed.

Remark rem_1308 : forall X1 X2 X3 X4 X5:term, auto___def_61 X2 -> auto___def_62 X1 -> auto_knows_current X3 -> auto_knows_current (cons X1 (cons X4 nil)) -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_61 X2 -> auto___def_62 X1 -> auto_knows_current (cons X1 (cons X4 nil)) -> auto___def_70 X1 X2). tauto.
  exact (rem_1307 X1 X2 X4).
Qed.

Remark rem_1309 : forall X1 X2 X3 X4 X5:term, auto_knows_current X3 -> auto_knows_current (cons X1 (cons X4 nil)) -> auto___def_61 X2 -> auto___def_62 X1 -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_61 X2 -> auto___def_62 X1 -> auto_knows_current X3 -> auto_knows_current (cons X1 (cons X4 nil)) -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto. exact (rem_1308 X1 X2 X3 X4 X5).
Qed.

Remark rem_1310 : forall X1 X2 X3 X4 X5:term, auto___def_61 X2 -> auto___def_62 X1 -> auto_knows_current (cons X3 (cons X1 (cons X4 nil))) -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_431 X3 (cons X1 (cons X4 nil)) H);  intros.
  apply (rem_1309 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1311 : forall X1 X2 X3 X4 X5:term, auto_knows_current (noncea_current X3 X4) -> auto_knows_current (cons X4 (cons X1 (cons X5 nil))) -> auto___def_61 X2 -> auto___def_62 X1 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_61 X2 -> auto___def_62 X1 -> auto_knows_current (cons X3 (cons X1 (cons X4 nil))) -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto. exact (rem_1310 X1 X2 X3 X4 X5).
Qed.

Remark rem_1312 : forall X1 X2 X3 X4 X5:term, auto___def_61 X2 -> auto___def_62 X1 -> auto_knows_current (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_431 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1311 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1313 : forall X1 X2 X3 X4 X5:term, auto_knows_current (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_61 X2 -> auto___def_62 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_61 X2 -> auto___def_62 X1 -> auto_knows_current (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1312 X1 X2 X3 X4 X5).
Qed.

Remark rem_1314 : forall X1 X2 X3 X4 X5:term, auto___def_61 X2 -> auto___def_62 X1 -> auto_knows_current (crypt (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_312 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil))) H);  intros.
  apply (rem_1231 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1233 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1268 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1272 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1275 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1291 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1313 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1315 : forall X1 X2 X3 X4 X5:term, auto___def_22 X2 -> auto___def_23 X1 -> auto___def_71 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_13 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_801 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
Qed.

Remark rem_1316 : forall X1 X2 X3 X4 X5:term, auto___def_71 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_13 (key sym (cons X3 (cons server nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_22 X2 -> auto___def_23 X1 -> auto___def_71 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_13 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1315 X1 X2 X3 X4 X5).
Qed.

Remark rem_1317 : forall X1 X2 X3 X4 X5:term, auto___def_22 X2 -> auto___def_23 X1 -> auto___def_69 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_803 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
Qed.

Remark rem_1318 : forall X1 X2 X3 X4 X5:term, auto___def_69 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_22 X2 -> auto___def_23 X1 -> auto___def_69 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1317 X1 X2 X3 X4 X5).
Qed.

Remark rem_1319 : (forall X:term, auto___def_25 X -> auto___def_19 X -> False)
    -> forall X1 X2:term, auto___def_19 (cons X1 X2) -> auto___type_4 X1 -> auto___def_26 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_25_m__def_19. intros X1 X2. intro H. intros.
  elim (rem_1078 X1 X2 H);  intros.
Defined.

Remark rem_1320 : (forall X:term, auto___def_25 X -> auto___def_19 X -> False)
    -> forall X1 X2:term, auto___def_25 (cons X1 X2) -> auto___def_19 (cons X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_25_m__def_19. intros X1 X2. intro H. intros.
  elim (rem_694 X1 X2 H);  intros.
  apply (rem_1319 epsilon_m__def_25_m__def_19 X1 X2);  tauto.
Defined.

Remark rem_1321 : forall X2:term, auto___def_25 X2 -> auto___def_19 X2 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_25_m__def_19 1.
  intro X. case X.
   intro H. elim (rem_699  H).
   intro H. elim (rem_697  H).
  intros X1 X2;  exact (rem_1320 epsilon_m__def_25_m__def_19 X1 X2).
  intros X1 X2. intro H. elim (rem_706 X1 X2 H).
   intro H. elim (rem_702  H).
  intros X1 X2. intro H. elim (rem_703 X1 X2 H).
   intro H. elim (rem_701  H).
  intros X1 X2. intro H. elim (rem_696 X1 X2 H).
  intros X1 X2. intro H. elim (rem_708 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_704 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_705 X1 X2 X3 H).
   intro H. elim (rem_711  H).
   intro H. elim (rem_709  H).
  intros X1. intro H. elim (rem_700 X1 H).
   intro H. elim (rem_710  H).
  intros X1 X2 X3. intro H. elim (rem_698 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_707 X1 X2 X3 H).
   intro H. elim (rem_712  H).
Qed.

Remark rem_1322 : (forall X:term, auto___def_16 X -> auto___def_23 X -> False)
    -> forall X2:term, auto___def_25 X2 -> auto___def_19 X2 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_16_m__def_23. exact (rem_1321).
Defined.

Remark rem_1323 : (forall X:term, auto___def_16 X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_19 X2 -> auto___def_18 X1 -> auto___def_25 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_16_m__def_23. intros X1 X2.
  cut (auto___def_25 X2 -> auto___def_19 X2 -> False). clear  epsilon_m__def_16_m__def_23. tauto.
  exact (rem_1322 epsilon_m__def_16_m__def_23 X2).
Defined.

Remark rem_1324 : (forall X:term, auto___def_16 X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_23 (key X1 X2) -> auto___def_18 X1 -> auto___def_19 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_16_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_174 X1 X2 H);  intros.
  apply (rem_1323 epsilon_m__def_16_m__def_23 X1 X2);  tauto.
Defined.

Remark rem_1325 : (forall X:term, auto___def_16 X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_16 (key X1 X2) -> auto___def_23 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_16_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_7 X1 X2 H);  intros.
  apply (rem_1324 epsilon_m__def_16_m__def_23 X1 X2);  tauto.
Defined.

Remark rem_1326 : forall X1:term, auto___def_16 X1 -> auto___def_23 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_16_m__def_23 1.
  intro X. case X.
   intro H. elim (rem_12  H).
   intro H. elim (rem_10  H).
  intros X1 X2. intro H. elim (rem_13 X1 X2 H).
  intros X1 X2. intro H. elim (rem_19 X1 X2 H).
   intro H. elim (rem_16  H).
  intros X1 X2;  exact (rem_1325 epsilon_m__def_16_m__def_23 X1 X2).
   intro H. elim (rem_15  H).
  intros X1 X2. intro H. elim (rem_9 X1 X2 H).
  intros X1 X2. intro H. elim (rem_21 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_17 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_18 X1 X2 X3 H).
   intro H. elim (rem_24  H).
   intro H. elim (rem_22  H).
  intros X1. intro H. elim (rem_14 X1 H).
   intro H. elim (rem_23  H).
  intros X1 X2 X3. intro H. elim (rem_11 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_20 X1 X2 X3 H).
   intro H. elim (rem_25  H).
Qed.

Remark rem_1327 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___def_17 (cons X3 nil) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_70 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3. intros.
  assert (HH:=(rem_1326 X1)). tauto.
Qed.

Remark rem_1328 : forall X1 X2 X3:term, auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_222 X1 (cons X3 nil) H);  intros.
  apply (rem_1327 X1 X2 X3);  tauto.
Qed.

Remark rem_1329 : forall X1 X2 X3 X4 X5:term, auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_29 (cons X4 (cons server nil)) -> auto___type_3 (noncea_current X4 X5) -> auto___type_4 X5 -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_70 X1 X2). tauto.
  exact (rem_1328 X1 X2 X3).
Qed.

Remark rem_1330 : forall X1 X2 X3 X4 X5:term, auto___type_4 X3 -> auto___def_15 (cons X1 (cons X4 nil)) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_29 (cons X4 (cons server nil)) -> auto___type_3 (noncea_current X4 X5) -> auto___type_4 X5 -> auto___def_70 X1 X2). tauto. exact (rem_1329 X1 X2 X3 X4 X5).
Qed.

Remark rem_1331 : forall X1 X2 X3 X4 X5:term, auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_225 X3 (cons X1 (cons X4 nil)) H);  intros.
  apply (rem_1330 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1332 : forall X1 X2 X3 X4 X5:term, auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_18 sym -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto.
  exact (rem_1331 X1 X2 X3 X4 X5).
Qed.

Remark rem_1333 : forall X1 X2 X3 X4 X5:term, auto___def_18 sym -> auto___def_29 (cons X3 (cons server nil)) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___type_3 (noncea_current X3 X4) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_18 sym -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto. exact (rem_1332 X1 X2 X3 X4 X5).
Qed.

Remark rem_1334 : forall X1 X2 X3 X4 X5:term, auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___type_3 (noncea_current X3 X4) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_167 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1333 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1335 : forall X1 X2 X3 X4 X5:term, auto___type_3 (noncea_current X3 X4) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___type_3 (noncea_current X3 X4) -> auto___def_70 X1 X2). tauto. exact (rem_1334 X1 X2 X3 X4 X5).
Qed.

Remark rem_1336 : forall X1 X2 X3 X4 X5:term, auto___def_12 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_231 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1335 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1337 : forall X1 X2 X3 X4 X5:term, auto___def_22 X2 -> auto___def_23 X1 -> auto___def_55 (noncea_current X3 X4) -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_63 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_604 X3 X4 H);  intros.
Qed.

Remark rem_1338 : forall X1 X2 X3 X4 X5:term, auto___def_55 (noncea_current X3 X4) -> auto___def_63 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_22 X2 -> auto___def_23 X1 -> auto___def_55 (noncea_current X3 X4) -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_63 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1337 X1 X2 X3 X4 X5).
Qed.

Remark rem_1339 : forall X1 X2 X3 X4 X5:term, auto___def_22 X2 -> auto___def_23 X1 -> auto___def_61 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_823 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1338 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1340 : forall X1 X2 X3 X4 X5:term, auto___def_61 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_22 X2 -> auto___def_23 X1 -> auto___def_61 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1339 X1 X2 X3 X4 X5).
Qed.

Remark rem_1341 : forall X1 X2 X3 X4 X5:term, auto___def_16 (noncea_current X3 X4) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_24 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_9 X3 X4 H);  intros.
Qed.

Remark rem_1342 : forall X1 X2 X3 X4 X5:term, auto___def_16 (noncea_current X3 X4) -> auto___def_24 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_16 (noncea_current X3 X4) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_24 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1341 X1 X2 X3 X4 X5).
Qed.

Remark rem_1343 : forall X1 X2 X3 X4 X5:term, auto___def_22 X2 -> auto___def_22 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_23 X1 -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_237 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1342 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1344 : forall X1 X2 X3 X4 X5:term, auto___def_22 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_22 X2 -> auto___def_22 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_23 X1 -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1343 X1 X2 X3 X4 X5).
Qed.

Remark rem_1345 : forall X1:term, auto___def_23 X1 -> auto___def_23 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1346 : forall X1 X2 X3:term, auto___def_22 X2 -> auto___def_23 X1 -> auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_23 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_23 X1 -> auto___def_23 X1). tauto. exact (rem_1345 X1).
Qed.

Remark rem_1347 : forall X1 X2 X3:term, auto___def_22 X2 -> auto___def_23 X1 -> auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_55 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_55 X1 -> auto___def_55 X1). tauto. exact (rem_258 X1).
Qed.

Remark rem_1348 : forall X2:term, auto___def_22 X2 -> auto___def_22 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1349 : forall X1 X2 X3:term, auto___def_22 X2 -> auto___def_23 X1 -> auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_22 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_22 X2 -> auto___def_22 X2). tauto. exact (rem_1348 X2).
Qed.

Remark rem_1350 : forall X1 X2 X3:term, auto___def_22 X2 -> auto___def_23 X1 -> auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> (auto___def_23 X1 /\ auto___def_55 X1 /\ auto___def_22 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  cut (auto___def_23 X1). 2:apply (rem_1346 X1 X2 X3);  assumption.
  cut (auto___def_55 X1). 2:apply (rem_1347 X1 X2 X3);  assumption.
  cut (auto___def_22 X2). 2:apply (rem_1349 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_1351 : forall X1 X2 X3:term, auto___def_22 X2 -> auto___def_23 X1 -> auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_70 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  case (rem_1350 X1 X2 X3 A1 A2 A3 A4). clear  A1 A2 A3 A4. intros. apply trans___def_70_4;  tauto.
 clear  A1 A2 A3 A4. tauto.
Qed.

Remark rem_1352 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_22 X2 -> auto___def_23 X1 -> auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_70 X1 X2). tauto. exact (rem_1351 X1 X2 X3).
Qed.

Remark rem_1353 : forall X1 X2 X3:term, auto___def_22 X2 -> auto___def_23 X1 -> auto___def_54 (cons X1 (cons X3 nil)) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1 H2. intro H. intros.
  elim (rem_851 X1 (cons X3 nil) H);  intros.
  apply (rem_1352 X1 X2 X3);  tauto.
Qed.

Remark rem_1354 : forall X1 X2 X3 X4 X5:term, auto___def_22 X2 -> auto___def_23 X1 -> auto___def_54 (cons X1 (cons X3 nil)) -> auto___def_66 (cons X4 (cons server nil)) -> auto___type_10 X5 -> auto___type_9 (noncea_current X4 X5) -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_22 X2 -> auto___def_23 X1 -> auto___def_54 (cons X1 (cons X3 nil)) -> auto___def_70 X1 X2). tauto.
  exact (rem_1353 X1 X2 X3).
Qed.

Remark rem_1355 : forall X1 X2 X3 X4 X5:term, auto___type_10 X3 -> auto___def_54 (cons X1 (cons X4 nil)) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_66 (cons X5 (cons server nil)) -> auto___type_9 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_22 X2 -> auto___def_23 X1 -> auto___def_54 (cons X1 (cons X3 nil)) -> auto___def_66 (cons X4 (cons server nil)) -> auto___type_10 X5 -> auto___type_9 (noncea_current X4 X5) -> auto___def_70 X1 X2). tauto. exact (rem_1354 X1 X2 X3 X4 X5).
Qed.

Remark rem_1356 : forall X1 X2 X3 X4 X5:term, auto___def_22 X2 -> auto___def_23 X1 -> auto___def_53 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_66 (cons X5 (cons server nil)) -> auto___type_9 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_854 X3 (cons X1 (cons X4 nil)) H);  intros.
  apply (rem_1355 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1357 : forall X1 X2 X3 X4 X5:term, auto___def_22 X2 -> auto___def_23 X1 -> auto___def_53 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_57 sym -> auto___def_66 (cons X5 (cons server nil)) -> auto___type_9 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_22 X2 -> auto___def_23 X1 -> auto___def_53 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_66 (cons X5 (cons server nil)) -> auto___type_9 (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto.
  exact (rem_1356 X1 X2 X3 X4 X5).
Qed.

Remark rem_1358 : forall X1 X2 X3 X4 X5:term, auto___def_57 sym -> auto___def_66 (cons X3 (cons server nil)) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_53 (cons X4 (cons X1 (cons X5 nil))) -> auto___type_9 (noncea_current X3 X4) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_22 X2 -> auto___def_23 X1 -> auto___def_53 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_57 sym -> auto___def_66 (cons X5 (cons server nil)) -> auto___type_9 (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto. exact (rem_1357 X1 X2 X3 X4 X5).
Qed.

Remark rem_1359 : forall X1 X2 X3 X4 X5:term, auto___def_22 X2 -> auto___def_23 X1 -> auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_53 (cons X4 (cons X1 (cons X5 nil))) -> auto___type_9 (noncea_current X3 X4) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_298 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1358 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1360 : forall X1 X2 X3 X4 X5:term, auto___type_9 (noncea_current X3 X4) -> auto___def_53 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_22 X2 -> auto___def_23 X1 -> auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_53 (cons X4 (cons X1 (cons X5 nil))) -> auto___type_9 (noncea_current X3 X4) -> auto___def_70 X1 X2). tauto. exact (rem_1359 X1 X2 X3 X4 X5).
Qed.

Remark rem_1361 : forall X1 X2 X3 X4 X5:term, auto___def_22 X2 -> auto___def_23 X1 -> auto___def_51 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_860 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1360 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1362 : forall X1 X2 X3 X4 X5:term, auto___def_51 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_22 X2 -> auto___def_23 X1 -> auto___def_51 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1361 X1 X2 X3 X4 X5).
Qed.

Remark rem_1363 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_23 (noncea_current X1 X2) -> auto_agent X1 -> auto_agent X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_718 X1 X2 H);  intros.
Defined.

Remark rem_1364 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto_knows_current (noncea_current X1 X2) -> auto___def_23 (noncea_current X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_416 X1 X2 H);  intros.
  apply (rem_1363 epsilon_mknows_current_m__def_23 X1 X2);  tauto.
Defined.

Remark rem_1365 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> auto___def_23 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intro H. intros.
  elim (rem_719 H);  intros.
Defined.

Remark rem_1366 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> auto_knows_current bob -> auto___def_23 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intro H. intros.
  elim (rem_420 H);  intros.
  apply (rem_1365 epsilon_mknows_current_m__def_23);  tauto.
Defined.

Remark rem_1367 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> auto___def_23 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intro H. intros.
  elim (rem_721 H);  intros.
Defined.

Remark rem_1368 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> auto_knows_current alice -> auto___def_23 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intro H. intros.
  elim (rem_423 H);  intros.
  apply (rem_1367 epsilon_mknows_current_m__def_23);  tauto.
Defined.

Remark rem_1369 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_23 (cons X1 X2) -> auto_knows_current X1 -> auto_knows_current X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_722 X1 X2 H);  intros.
Defined.

Remark rem_1370 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto_knows_current (cons X1 X2) -> auto___def_23 (cons X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_431 X1 X2 H);  intros.
  apply (rem_1369 epsilon_mknows_current_m__def_23 X1 X2);  tauto.
Defined.

Remark rem_1371 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1:term, auto___def_23 (s X1) -> auto_knows_current X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1. intro H. intros.
  elim (rem_723 X1 H);  intros.
Defined.

Remark rem_1372 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1:term, auto_knows_current (s X1) -> auto___def_23 (s X1) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1. intro H. intros.
  elim (rem_435 X1 H);  intros.
  apply (rem_1371 epsilon_mknows_current_m__def_23 X1);  tauto.
Defined.

Remark rem_1373 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> auto___def_23 nil -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intro H. intros.
  elim (rem_724 H);  intros.
Defined.

Remark rem_1374 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> auto_knows_current nil -> auto___def_23 nil -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intro H. intros.
  elim (rem_438 H);  intros.
  apply (rem_1373 epsilon_mknows_current_m__def_23);  tauto.
Defined.

Remark rem_1375 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> auto___def_23 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intro H. intros.
  elim (rem_725 H);  intros.
Defined.

Remark rem_1376 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> auto_knows_current i -> auto___def_23 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intro H. intros.
  elim (rem_441 H);  intros.
  apply (rem_1375 epsilon_mknows_current_m__def_23);  tauto.
Defined.

Remark rem_1377 : (forall X:term, auto___def_25 X -> auto___def_40 X -> False)
    -> forall X1 X2:term, auto___def_40 (cons X1 X2) -> auto___type_4 X1 -> auto___def_26 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_25_m__def_40. intros X1 X2. intro H. intros.
  elim (rem_862 X1 X2 H);  intros.
Defined.

Remark rem_1378 : (forall X:term, auto___def_25 X -> auto___def_40 X -> False)
    -> forall X1 X2:term, auto___def_25 (cons X1 X2) -> auto___def_40 (cons X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_25_m__def_40. intros X1 X2. intro H. intros.
  elim (rem_694 X1 X2 H);  intros.
  apply (rem_1377 epsilon_m__def_25_m__def_40 X1 X2);  tauto.
Defined.

Remark rem_1379 : forall X2:term, auto___def_25 X2 -> auto___def_40 X2 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_25_m__def_40 1.
  intro X. case X.
   intro H. elim (rem_699  H).
   intro H. elim (rem_697  H).
  intros X1 X2;  exact (rem_1378 epsilon_m__def_25_m__def_40 X1 X2).
  intros X1 X2. intro H. elim (rem_706 X1 X2 H).
   intro H. elim (rem_702  H).
  intros X1 X2. intro H. elim (rem_703 X1 X2 H).
   intro H. elim (rem_701  H).
  intros X1 X2. intro H. elim (rem_696 X1 X2 H).
  intros X1 X2. intro H. elim (rem_708 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_704 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_705 X1 X2 X3 H).
   intro H. elim (rem_711  H).
   intro H. elim (rem_709  H).
  intros X1. intro H. elim (rem_700 X1 H).
   intro H. elim (rem_710  H).
  intros X1 X2 X3. intro H. elim (rem_698 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_707 X1 X2 X3 H).
   intro H. elim (rem_712  H).
Qed.

Remark rem_1380 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X2:term, auto___def_25 X2 -> auto___def_40 X2 -> False. (* Cut history. *)
Proof.  intros epsilon_mknows_current_m__def_23. exact (rem_1379).
Defined.

Remark rem_1381 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_40 X2 -> auto___def_25 X2 -> auto___def_39 X1 -> False. (* Split. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1 X2.
  cut (auto___def_25 X2 -> auto___def_40 X2 -> False). clear  epsilon_mknows_current_m__def_23. tauto.
  exact (rem_1380 epsilon_mknows_current_m__def_23 X2).
Defined.

Remark rem_1382 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_23 (key X1 X2) -> auto___def_39 X1 -> auto___def_40 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_174 X1 X2 H);  intros.
  apply (rem_1381 epsilon_mknows_current_m__def_23 X1 X2);  tauto.
Defined.

Remark rem_1383 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1:term, auto___def_18 X1 -> auto___def_35 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_mknows_current_m__def_23. exact (rem_1190).
Defined.

Remark rem_1384 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___type_8 X2 -> auto___def_35 X1 -> auto___def_25 X2 -> False. (* Split. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_35 X1 -> False). clear  epsilon_mknows_current_m__def_23. tauto.
  exact (rem_1383 epsilon_mknows_current_m__def_23 X1).
Defined.

Remark rem_1385 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_23 (key X1 X2) -> auto___def_35 X1 -> auto___type_8 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_174 X1 X2 H);  intros.
  apply (rem_1384 epsilon_mknows_current_m__def_23 X1 X2);  tauto.
Defined.

Remark rem_1386 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1:term, auto___def_18 X1 -> auto___def_36 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_mknows_current_m__def_23. exact (rem_1196).
Defined.

Remark rem_1387 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_25 X2 -> auto___def_36 X1 -> auto___def_37 X2 -> False. (* Split. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_36 X1 -> False). clear  epsilon_mknows_current_m__def_23. tauto.
  exact (rem_1386 epsilon_mknows_current_m__def_23 X1).
Defined.

Remark rem_1388 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_23 (key X1 X2) -> auto___def_36 X1 -> auto___def_37 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_174 X1 X2 H);  intros.
  apply (rem_1387 epsilon_mknows_current_m__def_23 X1 X2);  tauto.
Defined.

Remark rem_1389 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto_knows_current (key X1 X2) -> auto___def_23 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_310 X1 X2 H);  intros.
  apply (rem_1382 epsilon_mknows_current_m__def_23 X1 X2);  tauto.
  apply (rem_1385 epsilon_mknows_current_m__def_23 X1 X2);  tauto.
  apply (rem_1388 epsilon_mknows_current_m__def_23 X1 X2);  tauto.
Defined.

Remark rem_1390 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1 X2 X3:term, auto___def_23 (nonceb_current X1 X2 X3) -> auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1 X2 X3. intro H. intros.
  elim (rem_726 X1 X2 X3 H);  intros.
Defined.

Remark rem_1391 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1 X2 X3:term, auto___def_23 (nonceb_current X1 X2 X3) -> auto___def_55 X1 -> auto___type_11 X2 -> auto___type_10 X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1 X2 X3. intro H. intros.
  elim (rem_726 X1 X2 X3 H);  intros.
Defined.

Remark rem_1392 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1 X2 X3:term, auto_knows_current (nonceb_current X1 X2 X3) -> auto___def_23 (nonceb_current X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1 X2 X3. intro H. intros.
  elim (rem_478 X1 X2 X3 H);  intros.
  apply (rem_1390 epsilon_mknows_current_m__def_23 X1 X2 X3);  tauto.
  apply (rem_1391 epsilon_mknows_current_m__def_23 X1 X2 X3);  tauto.
Defined.

Remark rem_1393 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1 X2 X3:term, auto___def_23 (nonceb_old X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1 X2 X3. intro H. intros.
  elim (rem_727 X1 X2 X3 H);  intros.
Defined.

Remark rem_1394 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1 X2 X3:term, auto_knows_current (nonceb_old X1 X2 X3) -> auto___def_23 (nonceb_old X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1 X2 X3. intro H. intros.
  elim (rem_481 X1 X2 X3 H);  intros.
  apply (rem_1393 epsilon_mknows_current_m__def_23 X1 X2 X3);  tauto.
Defined.

Remark rem_1395 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_23 (crypt X1 X2) -> auto___def_71 X1 -> auto___type_13 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_728 X1 X2 H);  intros.
Defined.

Remark rem_1396 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_23 (crypt X1 X2) -> auto___def_69 X1 -> auto___type_12 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_728 X1 X2 H);  intros.
Defined.

Remark rem_1397 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_23 (crypt X1 X2) -> auto___def_12 X1 -> auto___def_13 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_728 X1 X2 H);  intros.
Defined.

Remark rem_1398 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_23 (crypt X1 X2) -> auto___def_61 X1 -> auto___def_62 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_728 X1 X2 H);  intros.
Defined.

Remark rem_1399 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_23 (crypt X1 X2) -> auto___def_22 X1 -> auto___def_23 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_728 X1 X2 H);  intros.
Defined.

Remark rem_1400 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_23 (crypt X1 X2) -> auto___def_51 X1 -> auto___def_52 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_728 X1 X2 H);  intros.
Defined.

Remark rem_1401 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_23 (crypt X1 X2) -> auto_knows_current X1 -> auto_knows_current X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_728 X1 X2 H);  intros.
Defined.

Remark rem_1402 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto_knows_current (crypt X1 X2) -> auto___def_23 (crypt X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_312 X1 X2 H);  intros.
  apply (rem_1395 epsilon_mknows_current_m__def_23 X1 X2);  tauto.
  apply (rem_1396 epsilon_mknows_current_m__def_23 X1 X2);  tauto.
  apply (rem_1397 epsilon_mknows_current_m__def_23 X1 X2);  tauto.
  apply (rem_1398 epsilon_mknows_current_m__def_23 X1 X2);  tauto.
  apply (rem_1399 epsilon_mknows_current_m__def_23 X1 X2);  tauto.
  apply (rem_1400 epsilon_mknows_current_m__def_23 X1 X2);  tauto.
  apply (rem_1401 epsilon_mknows_current_m__def_23 X1 X2);  tauto.
Defined.

Remark rem_1403 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_23 (noncea_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_730 X1 X2 H);  intros.
Defined.

Remark rem_1404 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto_knows_current (noncea_old X1 X2) -> auto___def_23 (noncea_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_522 X1 X2 H);  intros.
  apply (rem_1403 epsilon_mknows_current_m__def_23 X1 X2);  tauto.
Defined.

Remark rem_1405 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> auto___def_23 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intro H. intros.
  elim (rem_732 H);  intros.
Defined.

Remark rem_1406 : (forall X:term, auto_knows_current X -> auto___def_23 X -> False)
    -> auto_knows_current server -> auto___def_23 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__def_23. intro H. intros.
  elim (rem_525 H);  intros.
  apply (rem_1405 epsilon_mknows_current_m__def_23);  tauto.
Defined.

Remark rem_1407 : forall X1:term, auto_knows_current X1 -> auto___def_23 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_mknows_current_m__def_23 1.
  intro X. case X.
  exact (rem_1368 epsilon_mknows_current_m__def_23 ).
  exact (rem_1366 epsilon_mknows_current_m__def_23 ).
  intros X1 X2;  exact (rem_1370 epsilon_mknows_current_m__def_23 X1 X2).
  intros X1 X2;  exact (rem_1402 epsilon_mknows_current_m__def_23 X1 X2).
  exact (rem_1376 epsilon_mknows_current_m__def_23 ).
  intros X1 X2;  exact (rem_1389 epsilon_mknows_current_m__def_23 X1 X2).
  exact (rem_1374 epsilon_mknows_current_m__def_23 ).
  intros X1 X2;  exact (rem_1364 epsilon_mknows_current_m__def_23 X1 X2).
  intros X1 X2;  exact (rem_1404 epsilon_mknows_current_m__def_23 X1 X2).
  intros X1 X2 X3;  exact (rem_1392 epsilon_mknows_current_m__def_23 X1 X2 X3).
  intros X1 X2 X3;  exact (rem_1394 epsilon_mknows_current_m__def_23 X1 X2 X3).
   intro H. elim (rem_530  H).
   intro H. elim (rem_529  H).
  intros X1;  exact (rem_1372 epsilon_mknows_current_m__def_23 X1).
  exact (rem_1406 epsilon_mknows_current_m__def_23 ).
  intros X1 X2 X3. intro H. elim (rem_527 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_528 X1 X2 X3 H).
   intro H. elim (rem_531  H).
Qed.

Remark rem_1408 : forall X1 X2 X3:term, auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_current X1 -> auto_knows_current (cons X3 nil) -> auto___def_70 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3. intros.
  assert (HH:=(rem_1407 X1)). tauto.
Qed.

Remark rem_1409 : forall X1 X2 X3:term, auto_knows_current X1 -> auto_knows_current (cons X3 nil) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_current X1 -> auto_knows_current (cons X3 nil) -> auto___def_70 X1 X2). tauto. exact (rem_1408 X1 X2 X3).
Qed.

Remark rem_1410 : forall X1 X2 X3:term, auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_current (cons X1 (cons X3 nil)) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1 H2. intro H. intros.
  elim (rem_431 X1 (cons X3 nil) H);  intros.
  apply (rem_1409 X1 X2 X3);  tauto.
Qed.

Remark rem_1411 : forall X1 X2 X4:term, auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_current (cons X1 (cons X4 nil)) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_current (cons X1 (cons X3 nil)) -> auto___def_70 X1 X2). tauto. exact (rem_1410 X1 X2 X3).
Qed.

Remark rem_1412 : forall X1 X2 X3 X4 X5:term, auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_current X3 -> auto_knows_current (cons X1 (cons X4 nil)) -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_current (cons X1 (cons X4 nil)) -> auto___def_70 X1 X2). tauto.
  exact (rem_1411 X1 X2 X4).
Qed.

Remark rem_1413 : forall X1 X2 X3 X4 X5:term, auto_knows_current X3 -> auto_knows_current (cons X1 (cons X4 nil)) -> auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_current X3 -> auto_knows_current (cons X1 (cons X4 nil)) -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto. exact (rem_1412 X1 X2 X3 X4 X5).
Qed.

Remark rem_1414 : forall X1 X2 X3 X4 X5:term, auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_current (cons X3 (cons X1 (cons X4 nil))) -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_431 X3 (cons X1 (cons X4 nil)) H);  intros.
  apply (rem_1413 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1415 : forall X1 X2 X3 X4 X5:term, auto_knows_current (noncea_current X3 X4) -> auto_knows_current (cons X4 (cons X1 (cons X5 nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_current (cons X3 (cons X1 (cons X4 nil))) -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto. exact (rem_1414 X1 X2 X3 X4 X5).
Qed.

Remark rem_1416 : forall X1 X2 X3 X4 X5:term, auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_current (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_431 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1415 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1417 : forall X1 X2 X3 X4 X5:term, auto_knows_current (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_current (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1416 X1 X2 X3 X4 X5).
Qed.

Remark rem_1418 : forall X1 X2 X3 X4 X5:term, auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_current (crypt (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_312 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil))) H);  intros.
  apply (rem_1316 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1318 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1336 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1340 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1344 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1362 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1417 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1419 : forall X1 X2 X3 X4 X5:term, auto___def_51 X2 -> auto___def_52 X1 -> auto___def_71 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_13 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_801 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
Qed.

Remark rem_1420 : forall X1 X2 X3 X4 X5:term, auto___def_71 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_13 (key sym (cons X3 (cons server nil))) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_51 X2 -> auto___def_52 X1 -> auto___def_71 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_13 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1419 X1 X2 X3 X4 X5).
Qed.

Remark rem_1421 : forall X1 X2 X3 X4 X5:term, auto___def_51 X2 -> auto___def_52 X1 -> auto___def_69 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_803 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
Qed.

Remark rem_1422 : forall X1 X2 X3 X4 X5:term, auto___def_69 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_51 X2 -> auto___def_52 X1 -> auto___def_69 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1421 X1 X2 X3 X4 X5).
Qed.

Remark rem_1423 : forall X1 X2 X3:term, auto___def_66 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1424 : (forall X:term, auto___def_19 X -> auto___def_66 X -> False)
    -> forall X1 X2 X3:term, auto___def_66 (session_old X1 X2 X3) -> auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_19_m__def_66. intros X1 X2 X3. intro H. intros.
  elim (rem_1423 X1 X2 X3 H);  intros.
Defined.

Remark rem_1425 : (forall X:term, auto___def_19 X -> auto___def_66 X -> False)
    -> forall X1 X2 X3:term, auto___def_19 (session_old X1 X2 X3) -> auto___def_66 (session_old X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_19_m__def_66. intros X1 X2 X3. intro H. intros.
  elim (rem_1072 X1 X2 X3 H);  intros.
  apply (rem_1424 epsilon_m__def_19_m__def_66 X1 X2 X3);  tauto.
Defined.

Remark rem_1426 : forall X2:term, auto___def_19 X2 -> auto___def_66 X2 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_19_m__def_66 1.
  intro X. case X.
   intro H. elim (rem_1077  H).
   intro H. elim (rem_1075  H).
  intros X1 X2. intro H. elim (rem_1078 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1085 X1 X2 H).
   intro H. elim (rem_1081  H).
  intros X1 X2. intro H. elim (rem_1082 X1 X2 H).
   intro H. elim (rem_1080  H).
  intros X1 X2. intro H. elim (rem_1074 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1086 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1083 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1084 X1 X2 X3 H).
   intro H. elim (rem_1089  H).
   intro H. elim (rem_1087  H).
  intros X1. intro H. elim (rem_1079 X1 H).
   intro H. elim (rem_1088  H).
  intros X1 X2 X3. intro H. elim (rem_1076 X1 X2 X3 H).
  intros X1 X2 X3;  exact (rem_1425 epsilon_m__def_19_m__def_66 X1 X2 X3).
   intro H. elim (rem_1090  H).
Qed.

Remark rem_1427 : (forall X:term, auto___def_52 X -> auto___def_16 X -> False)
    -> forall X2:term, auto___def_19 X2 -> auto___def_66 X2 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_52_m__def_16. exact (rem_1426).
Defined.

Remark rem_1428 : (forall X:term, auto___def_52 X -> auto___def_16 X -> False)
    -> forall X1 X2:term, auto___def_57 X1 -> auto___def_19 X2 -> auto___def_66 X2 -> auto___def_18 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_52_m__def_16. intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_66 X2 -> False). clear  epsilon_m__def_52_m__def_16. tauto.
  exact (rem_1427 epsilon_m__def_52_m__def_16 X2).
Defined.

Remark rem_1429 : (forall X:term, auto___def_52 X -> auto___def_16 X -> False)
    -> forall X1 X2:term, auto___def_16 (key X1 X2) -> auto___def_57 X1 -> auto___def_66 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_52_m__def_16. intros X1 X2. intro H. intros.
  elim (rem_7 X1 X2 H);  intros.
  apply (rem_1428 epsilon_m__def_52_m__def_16 X1 X2);  tauto.
Defined.

Remark rem_1430 : (forall X:term, auto___def_52 X -> auto___def_16 X -> False)
    -> forall X1 X2:term, auto___def_52 (key X1 X2) -> auto___def_16 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_52_m__def_16. intros X1 X2. intro H. intros.
  elim (rem_298 X1 X2 H);  intros.
  apply (rem_1429 epsilon_m__def_52_m__def_16 X1 X2);  tauto.
Defined.

Remark rem_1431 : forall X1:term, auto___def_52 X1 -> auto___def_16 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_52_m__def_16 1.
  intro X. case X.
   intro H. elim (rem_782  H).
   intro H. elim (rem_780  H).
  intros X1 X2. intro H. elim (rem_783 X1 X2 H).
  intros X1 X2. intro H. elim (rem_789 X1 X2 H).
   intro H. elim (rem_786  H).
  intros X1 X2;  exact (rem_1430 epsilon_m__def_52_m__def_16 X1 X2).
   intro H. elim (rem_785  H).
  intros X1 X2. intro H. elim (rem_779 X1 X2 H).
  intros X1 X2. intro H. elim (rem_791 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_787 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_788 X1 X2 X3 H).
   intro H. elim (rem_794  H).
   intro H. elim (rem_792  H).
  intros X1. intro H. elim (rem_784 X1 H).
   intro H. elim (rem_793  H).
  intros X1 X2 X3. intro H. elim (rem_781 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_790 X1 X2 X3 H).
   intro H. elim (rem_795  H).
Qed.

Remark rem_1432 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___def_17 (cons X3 nil) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___def_70 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3. intros.
  assert (HH:=(rem_1431 X1)). tauto.
Qed.

Remark rem_1433 : forall X1 X2 X3:term, auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_222 X1 (cons X3 nil) H);  intros.
  apply (rem_1432 X1 X2 X3);  tauto.
Qed.

Remark rem_1434 : forall X1 X2 X3 X4 X5:term, auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_29 (cons X4 (cons server nil)) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___type_3 (noncea_current X4 X5) -> auto___type_4 X5 -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___def_70 X1 X2). tauto.
  exact (rem_1433 X1 X2 X3).
Qed.

Remark rem_1435 : forall X1 X2 X3 X4 X5:term, auto___type_4 X3 -> auto___def_15 (cons X1 (cons X4 nil)) -> auto___def_29 (cons X5 (cons server nil)) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___type_3 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_29 (cons X4 (cons server nil)) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___type_3 (noncea_current X4 X5) -> auto___type_4 X5 -> auto___def_70 X1 X2). tauto. exact (rem_1434 X1 X2 X3 X4 X5).
Qed.

Remark rem_1436 : forall X1 X2 X3 X4 X5:term, auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_29 (cons X5 (cons server nil)) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___type_3 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_225 X3 (cons X1 (cons X4 nil)) H);  intros.
  apply (rem_1435 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1437 : forall X1 X2 X3 X4 X5:term, auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_18 sym -> auto___def_29 (cons X5 (cons server nil)) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___type_3 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_29 (cons X5 (cons server nil)) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___type_3 (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto.
  exact (rem_1436 X1 X2 X3 X4 X5).
Qed.

Remark rem_1438 : forall X1 X2 X3 X4 X5:term, auto___def_18 sym -> auto___def_29 (cons X3 (cons server nil)) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___type_3 (noncea_current X3 X4) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_18 sym -> auto___def_29 (cons X5 (cons server nil)) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___type_3 (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto. exact (rem_1437 X1 X2 X3 X4 X5).
Qed.

Remark rem_1439 : forall X1 X2 X3 X4 X5:term, auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___type_3 (noncea_current X3 X4) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_167 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1438 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1440 : forall X1 X2 X3 X4 X5:term, auto___type_3 (noncea_current X3 X4) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___type_3 (noncea_current X3 X4) -> auto___def_70 X1 X2). tauto. exact (rem_1439 X1 X2 X3 X4 X5).
Qed.

Remark rem_1441 : forall X1 X2 X3 X4 X5:term, auto___def_12 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_231 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1440 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1442 : forall X1 X2 X3 X4 X5:term, auto___def_51 X2 -> auto___def_52 X1 -> auto___def_55 (noncea_current X3 X4) -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_63 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_604 X3 X4 H);  intros.
Qed.

Remark rem_1443 : forall X1 X2 X3 X4 X5:term, auto___def_55 (noncea_current X3 X4) -> auto___def_63 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_51 X2 -> auto___def_52 X1 -> auto___def_55 (noncea_current X3 X4) -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_63 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1442 X1 X2 X3 X4 X5).
Qed.

Remark rem_1444 : forall X1 X2 X3 X4 X5:term, auto___def_51 X2 -> auto___def_52 X1 -> auto___def_61 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_823 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1443 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1445 : forall X1 X2 X3 X4 X5:term, auto___def_61 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_51 X2 -> auto___def_52 X1 -> auto___def_61 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1444 X1 X2 X3 X4 X5).
Qed.

Remark rem_1446 : forall X1 X2 X3 X4 X5:term, auto___def_16 (noncea_current X3 X4) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_24 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_9 X3 X4 H);  intros.
Qed.

Remark rem_1447 : forall X1 X2 X3 X4 X5:term, auto___def_16 (noncea_current X3 X4) -> auto___def_24 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_16 (noncea_current X3 X4) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_24 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___def_70 X1 X2). tauto. exact (rem_1446 X1 X2 X3 X4 X5).
Qed.

Remark rem_1448 : forall X1 X2 X3 X4 X5:term, auto___def_22 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_237 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1447 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1449 : forall X1:term, auto___def_52 X1 -> auto___def_52 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1450 : forall X1 X2 X3:term, auto___def_51 X2 -> auto___def_52 X1 -> auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_52 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_52 X1 -> auto___def_52 X1). tauto. exact (rem_1449 X1).
Qed.

Remark rem_1451 : forall X1 X2 X3:term, auto___def_51 X2 -> auto___def_52 X1 -> auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_55 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_55 X1 -> auto___def_55 X1). tauto. exact (rem_258 X1).
Qed.

Remark rem_1452 : forall X2:term, auto___def_51 X2 -> auto___def_51 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1453 : forall X1 X2 X3:term, auto___def_51 X2 -> auto___def_52 X1 -> auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_51 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_51 X2 -> auto___def_51 X2). tauto. exact (rem_1452 X2).
Qed.

Remark rem_1454 : forall X1 X2 X3:term, auto___def_51 X2 -> auto___def_52 X1 -> auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> (auto___def_52 X1 /\ auto___def_55 X1 /\ auto___def_51 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  cut (auto___def_52 X1). 2:apply (rem_1450 X1 X2 X3);  assumption.
  cut (auto___def_55 X1). 2:apply (rem_1451 X1 X2 X3);  assumption.
  cut (auto___def_51 X2). 2:apply (rem_1453 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_1455 : forall X1 X2 X3:term, auto___def_51 X2 -> auto___def_52 X1 -> auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_70 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  case (rem_1454 X1 X2 X3 A1 A2 A3 A4). clear  A1 A2 A3 A4. intros. apply trans___def_70_7;  tauto.
 clear  A1 A2 A3 A4. tauto.
Qed.

Remark rem_1456 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_51 X2 -> auto___def_52 X1 -> auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto___def_70 X1 X2). tauto. exact (rem_1455 X1 X2 X3).
Qed.

Remark rem_1457 : forall X1 X2 X3:term, auto___def_51 X2 -> auto___def_52 X1 -> auto___def_54 (cons X1 (cons X3 nil)) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1 H2. intro H. intros.
  elim (rem_851 X1 (cons X3 nil) H);  intros.
  apply (rem_1456 X1 X2 X3);  tauto.
Qed.

Remark rem_1458 : forall X1 X2 X3 X4 X5:term, auto___def_51 X2 -> auto___def_52 X1 -> auto___def_54 (cons X1 (cons X3 nil)) -> auto___def_66 (cons X4 (cons server nil)) -> auto___type_10 X5 -> auto___type_9 (noncea_current X4 X5) -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_51 X2 -> auto___def_52 X1 -> auto___def_54 (cons X1 (cons X3 nil)) -> auto___def_70 X1 X2). tauto.
  exact (rem_1457 X1 X2 X3).
Qed.

Remark rem_1459 : forall X1 X2 X3 X4 X5:term, auto___type_10 X3 -> auto___def_54 (cons X1 (cons X4 nil)) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___def_66 (cons X5 (cons server nil)) -> auto___type_9 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_51 X2 -> auto___def_52 X1 -> auto___def_54 (cons X1 (cons X3 nil)) -> auto___def_66 (cons X4 (cons server nil)) -> auto___type_10 X5 -> auto___type_9 (noncea_current X4 X5) -> auto___def_70 X1 X2). tauto. exact (rem_1458 X1 X2 X3 X4 X5).
Qed.

Remark rem_1460 : forall X1 X2 X3 X4 X5:term, auto___def_51 X2 -> auto___def_52 X1 -> auto___def_53 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_66 (cons X5 (cons server nil)) -> auto___type_9 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_854 X3 (cons X1 (cons X4 nil)) H);  intros.
  apply (rem_1459 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1461 : forall X1 X2 X3 X4 X5:term, auto___def_51 X2 -> auto___def_52 X1 -> auto___def_53 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_57 sym -> auto___def_66 (cons X5 (cons server nil)) -> auto___type_9 (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_51 X2 -> auto___def_52 X1 -> auto___def_53 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_66 (cons X5 (cons server nil)) -> auto___type_9 (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto.
  exact (rem_1460 X1 X2 X3 X4 X5).
Qed.

Remark rem_1462 : forall X1 X2 X3 X4 X5:term, auto___def_57 sym -> auto___def_66 (cons X3 (cons server nil)) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___def_53 (cons X4 (cons X1 (cons X5 nil))) -> auto___type_9 (noncea_current X3 X4) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_51 X2 -> auto___def_52 X1 -> auto___def_53 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_57 sym -> auto___def_66 (cons X5 (cons server nil)) -> auto___type_9 (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto. exact (rem_1461 X1 X2 X3 X4 X5).
Qed.

Remark rem_1463 : forall X1 X2 X3 X4 X5:term, auto___def_51 X2 -> auto___def_52 X1 -> auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_53 (cons X4 (cons X1 (cons X5 nil))) -> auto___type_9 (noncea_current X3 X4) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_298 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1462 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1464 : forall X1 X2 X3 X4 X5:term, auto___type_9 (noncea_current X3 X4) -> auto___def_53 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_51 X2 -> auto___def_52 X1 -> auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_53 (cons X4 (cons X1 (cons X5 nil))) -> auto___type_9 (noncea_current X3 X4) -> auto___def_70 X1 X2). tauto. exact (rem_1463 X1 X2 X3 X4 X5).
Qed.

Remark rem_1465 : forall X1 X2 X3 X4 X5:term, auto___def_51 X2 -> auto___def_51 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_52 X1 -> auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_860 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1464 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1466 : forall X1 X2 X3 X4 X5:term, auto___def_51 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_51 X2 -> auto___def_51 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_52 X1 -> auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1465 X1 X2 X3 X4 X5).
Qed.

Remark rem_1467 : (forall X:term, auto___def_40 X -> auto___def_66 X -> False)
    -> forall X1 X2 X3:term, auto___def_66 (session_old X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_40_m__def_66. intros X1 X2 X3. intro H. intros.
  elim (rem_1423 X1 X2 X3 H);  intros.
Defined.

Remark rem_1468 : (forall X:term, auto___def_40 X -> auto___def_66 X -> False)
    -> forall X1 X2 X3:term, auto___def_40 (session_old X1 X2 X3) -> auto___def_66 (session_old X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_40_m__def_66. intros X1 X2 X3. intro H. intros.
  elim (rem_1150 X1 X2 X3 H);  intros.
  apply (rem_1467 epsilon_m__def_40_m__def_66 X1 X2 X3);  tauto.
Defined.

Remark rem_1469 : forall X2:term, auto___def_40 X2 -> auto___def_66 X2 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_40_m__def_66 1.
  intro X. case X.
   intro H. elim (rem_1154  H).
   intro H. elim (rem_1153  H).
  intros X1 X2. intro H. elim (rem_862 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1161 X1 X2 H).
   intro H. elim (rem_1157  H).
  intros X1 X2. intro H. elim (rem_1158 X1 X2 H).
   intro H. elim (rem_1156  H).
  intros X1 X2. intro H. elim (rem_1152 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1162 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1159 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1160 X1 X2 X3 H).
   intro H. elim (rem_1165  H).
   intro H. elim (rem_1163  H).
  intros X1. intro H. elim (rem_1155 X1 H).
   intro H. elim (rem_1164  H).
  intros X1 X2 X3. intro H. elim (rem_625 X1 X2 X3 H).
  intros X1 X2 X3;  exact (rem_1468 epsilon_m__def_40_m__def_66 X1 X2 X3).
   intro H. elim (rem_1166  H).
Qed.

Remark rem_1470 : (forall X:term, auto___def_52 X -> auto_knows_current X -> False)
    -> forall X2:term, auto___def_40 X2 -> auto___def_66 X2 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_52_mknows_current. exact (rem_1469).
Defined.

Remark rem_1471 : (forall X:term, auto___def_52 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto___def_57 X1 -> auto___def_66 X2 -> auto___def_40 X2 -> auto___def_39 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_52_mknows_current. intros X1 X2.
  cut (auto___def_40 X2 -> auto___def_66 X2 -> False). clear  epsilon_m__def_52_mknows_current. tauto.
  exact (rem_1470 epsilon_m__def_52_mknows_current X2).
Defined.

Remark rem_1472 : (forall X:term, auto___def_52 X -> auto_knows_current X -> False)
    -> forall X1:term, auto___def_57 X1 -> auto___def_35 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_52_mknows_current. exact (rem_651).
Defined.

Remark rem_1473 : (forall X:term, auto___def_52 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto___def_57 X1 -> auto___def_66 X2 -> auto___type_8 X2 -> auto___def_35 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_52_mknows_current. intros X1 X2.
  cut (auto___def_57 X1 -> auto___def_35 X1 -> False). clear  epsilon_m__def_52_mknows_current. tauto.
  exact (rem_1472 epsilon_m__def_52_mknows_current X1).
Defined.

Remark rem_1474 : (forall X:term, auto___def_52 X -> auto_knows_current X -> False)
    -> forall X1:term, auto___def_57 X1 -> auto___def_36 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_52_mknows_current. exact (rem_658).
Defined.

Remark rem_1475 : (forall X:term, auto___def_52 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto___def_57 X1 -> auto___def_66 X2 -> auto___def_36 X1 -> auto___def_37 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_52_mknows_current. intros X1 X2.
  cut (auto___def_57 X1 -> auto___def_36 X1 -> False). clear  epsilon_m__def_52_mknows_current. tauto.
  exact (rem_1474 epsilon_m__def_52_mknows_current X1).
Defined.

Remark rem_1476 : (forall X:term, auto___def_52 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto_knows_current (key X1 X2) -> auto___def_57 X1 -> auto___def_66 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_52_mknows_current. intros X1 X2. intro H. intros.
  elim (rem_310 X1 X2 H);  intros.
  apply (rem_1471 epsilon_m__def_52_mknows_current X1 X2);  tauto.
  apply (rem_1473 epsilon_m__def_52_mknows_current X1 X2);  tauto.
  apply (rem_1475 epsilon_m__def_52_mknows_current X1 X2);  tauto.
Defined.

Remark rem_1477 : (forall X:term, auto___def_52 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto___def_52 (key X1 X2) -> auto_knows_current (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_52_mknows_current. intros X1 X2. intro H. intros.
  elim (rem_298 X1 X2 H);  intros.
  apply (rem_1476 epsilon_m__def_52_mknows_current X1 X2);  tauto.
Defined.

Remark rem_1478 : forall X1:term, auto___def_52 X1 -> auto_knows_current X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_52_mknows_current 1.
  intro X. case X.
   intro H. elim (rem_782  H).
   intro H. elim (rem_780  H).
  intros X1 X2. intro H. elim (rem_783 X1 X2 H).
  intros X1 X2. intro H. elim (rem_789 X1 X2 H).
   intro H. elim (rem_786  H).
  intros X1 X2;  exact (rem_1477 epsilon_m__def_52_mknows_current X1 X2).
   intro H. elim (rem_785  H).
  intros X1 X2. intro H. elim (rem_779 X1 X2 H).
  intros X1 X2. intro H. elim (rem_791 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_787 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_788 X1 X2 X3 H).
   intro H. elim (rem_794  H).
   intro H. elim (rem_792  H).
  intros X1. intro H. elim (rem_784 X1 H).
   intro H. elim (rem_793  H).
  intros X1 X2 X3. intro H. elim (rem_781 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_790 X1 X2 X3 H).
   intro H. elim (rem_795  H).
Qed.

Remark rem_1479 : forall X1 X2 X3:term, auto___def_51 X2 -> auto___def_52 X1 -> auto_knows_current X1 -> auto_knows_current (cons X3 nil) -> auto___def_70 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3. intros.
  assert (HH:=(rem_1478 X1)). tauto.
Qed.

Remark rem_1480 : forall X1 X2 X3:term, auto_knows_current X1 -> auto_knows_current (cons X3 nil) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_51 X2 -> auto___def_52 X1 -> auto_knows_current X1 -> auto_knows_current (cons X3 nil) -> auto___def_70 X1 X2). tauto. exact (rem_1479 X1 X2 X3).
Qed.

Remark rem_1481 : forall X1 X2 X3:term, auto___def_51 X2 -> auto___def_52 X1 -> auto_knows_current (cons X1 (cons X3 nil)) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1 H2. intro H. intros.
  elim (rem_431 X1 (cons X3 nil) H);  intros.
  apply (rem_1480 X1 X2 X3);  tauto.
Qed.

Remark rem_1482 : forall X1 X2 X4:term, auto___def_51 X2 -> auto___def_52 X1 -> auto_knows_current (cons X1 (cons X4 nil)) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_51 X2 -> auto___def_52 X1 -> auto_knows_current (cons X1 (cons X3 nil)) -> auto___def_70 X1 X2). tauto. exact (rem_1481 X1 X2 X3).
Qed.

Remark rem_1483 : forall X1 X2 X3 X4 X5:term, auto___def_51 X2 -> auto___def_52 X1 -> auto_knows_current X3 -> auto_knows_current (cons X1 (cons X4 nil)) -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_51 X2 -> auto___def_52 X1 -> auto_knows_current (cons X1 (cons X4 nil)) -> auto___def_70 X1 X2). tauto.
  exact (rem_1482 X1 X2 X4).
Qed.

Remark rem_1484 : forall X1 X2 X3 X4 X5:term, auto_knows_current X3 -> auto_knows_current (cons X1 (cons X4 nil)) -> auto___def_51 X2 -> auto___def_52 X1 -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_51 X2 -> auto___def_52 X1 -> auto_knows_current X3 -> auto_knows_current (cons X1 (cons X4 nil)) -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto. exact (rem_1483 X1 X2 X3 X4 X5).
Qed.

Remark rem_1485 : forall X1 X2 X3 X4 X5:term, auto___def_51 X2 -> auto___def_52 X1 -> auto_knows_current (cons X3 (cons X1 (cons X4 nil))) -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_431 X3 (cons X1 (cons X4 nil)) H);  intros.
  apply (rem_1484 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1486 : forall X1 X2 X3 X4 X5:term, auto_knows_current (noncea_current X3 X4) -> auto_knows_current (cons X4 (cons X1 (cons X5 nil))) -> auto___def_51 X2 -> auto___def_52 X1 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_51 X2 -> auto___def_52 X1 -> auto_knows_current (cons X3 (cons X1 (cons X4 nil))) -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto. exact (rem_1485 X1 X2 X3 X4 X5).
Qed.

Remark rem_1487 : forall X1 X2 X3 X4 X5:term, auto___def_51 X2 -> auto___def_52 X1 -> auto_knows_current (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_431 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1486 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1488 : forall X1 X2 X3 X4 X5:term, auto_knows_current (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_51 X2 -> auto___def_52 X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_51 X2 -> auto___def_52 X1 -> auto_knows_current (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1487 X1 X2 X3 X4 X5).
Qed.

Remark rem_1489 : forall X1 X2 X3 X4 X5:term, auto___def_51 X2 -> auto___def_52 X1 -> auto_knows_current (crypt (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_312 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil))) H);  intros.
  apply (rem_1420 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1422 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1441 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1445 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1448 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1466 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1488 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1490 : forall X1 X2 X3 X4 X5:term, auto___def_71 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_13 (key sym (cons X3 (cons server nil))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_801 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
Qed.

Remark rem_1491 : forall X1 X2 X3 X4 X5:term, auto___def_69 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_12 (key sym (cons X3 (cons server nil))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_803 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
Qed.

Remark rem_1492 : forall X1 X2 X3 X4 X5:term, auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_29 (cons X4 (cons server nil)) -> auto___type_3 (noncea_current X4 X5) -> auto___type_4 X5 -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_29 (cons X4 (cons server nil)) -> auto___type_3 (noncea_current X4 X5) -> auto___type_4 X5 -> False). tauto.
  exact (rem_1004 X4 X5).
Qed.

Remark rem_1493 : forall X1 X2 X3 X4 X5:term, auto___type_4 X3 -> auto___def_15 (cons X1 (cons X4 nil)) -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_current X5 X3) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_29 (cons X4 (cons server nil)) -> auto___type_3 (noncea_current X4 X5) -> auto___type_4 X5 -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2). tauto. exact (rem_1492 X1 X2 X3 X4 X5).
Qed.

Remark rem_1494 : forall X1 X2 X3 X4 X5:term, auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_current X5 X3) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_225 X3 (cons X1 (cons X4 nil)) H);  intros.
  apply (rem_1493 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1495 : forall X1 X2 X3 X4 X5:term, auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_18 sym -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_current X5 X3) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_current X5 X3) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2). tauto.
  exact (rem_1494 X1 X2 X3 X4 X5).
Qed.

Remark rem_1496 : forall X1 X2 X3 X4 X5:term, auto___def_18 sym -> auto___def_29 (cons X3 (cons server nil)) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___type_3 (noncea_current X3 X4) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_18 sym -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_current X5 X3) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2). tauto. exact (rem_1495 X1 X2 X3 X4 X5).
Qed.

Remark rem_1497 : forall X1 X2 X3 X4 X5:term, auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___type_3 (noncea_current X3 X4) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_167 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1496 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1498 : forall X1 X2 X3 X4 X5:term, auto___type_3 (noncea_current X3 X4) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_13 (key sym (cons X3 (cons server nil))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___type_3 (noncea_current X3 X4) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2). tauto. exact (rem_1497 X1 X2 X3 X4 X5).
Qed.

Remark rem_1499 : forall X1 X2 X3 X4 X5:term, auto___def_12 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_13 (key sym (cons X3 (cons server nil))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_231 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1498 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1500 : forall X1 X2 X3 X4 X5:term, auto___def_55 (noncea_current X3 X4) -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_63 (cons X4 (cons X1 (cons X5 nil))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_604 X3 X4 H);  intros.
Qed.

Remark rem_1501 : forall X1 X2 X3 X4 X5:term, auto___def_55 (noncea_current X3 X4) -> auto___def_63 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_55 (noncea_current X3 X4) -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto___def_63 (cons X4 (cons X1 (cons X5 nil))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2). tauto. exact (rem_1500 X1 X2 X3 X4 X5).
Qed.

Remark rem_1502 : forall X1 X2 X3 X4 X5:term, auto___def_61 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_62 (key sym (cons X3 (cons server nil))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_823 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1501 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1503 : forall X1 X2 X3 X4 X5:term, auto___def_16 (noncea_current X3 X4) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_24 (cons X4 (cons X1 (cons X5 nil))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_9 X3 X4 H);  intros.
Qed.

Remark rem_1504 : forall X1 X2 X3 X4 X5:term, auto___def_16 (noncea_current X3 X4) -> auto___def_24 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_16 (noncea_current X3 X4) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_24 (cons X4 (cons X1 (cons X5 nil))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2). tauto. exact (rem_1503 X1 X2 X3 X4 X5).
Qed.

Remark rem_1505 : forall X1 X2 X3 X4 X5:term, auto___def_22 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_237 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1504 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1506 : forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1507 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_1506 X1).
Qed.

Remark rem_1508 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_55 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_55 X1 -> auto___def_55 X1). tauto. exact (rem_258 X1).
Qed.

Remark rem_1509 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_306 X2).
Qed.

Remark rem_1510 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto_knows_current X2 -> auto_knows_current X1 -> (auto_knows_current X1 /\ auto___def_55 X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  cut (auto_knows_current X1). 2:apply (rem_1507 X1 X2 X3);  assumption.
  cut (auto___def_55 X1). 2:apply (rem_1508 X1 X2 X3);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1509 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_1511 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___def_56 (cons X3 nil) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  case (rem_1510 X1 X2 X3 A1 A2 A3 A4). clear  A1 A2 A3 A4. intros. apply trans___def_70_2;  tauto.
 clear  A1 A2 A3 A4. tauto.
Qed.

Remark rem_1512 : forall X1 X2 X3:term, auto___def_54 (cons X1 (cons X3 nil)) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_851 X1 (cons X3 nil) H);  intros.
  apply (rem_1511 X1 X2 X3);  tauto.
Qed.

Remark rem_1513 : forall X1 X2 X3 X4 X5:term, auto___def_54 (cons X1 (cons X3 nil)) -> auto___def_66 (cons X4 (cons server nil)) -> auto___type_10 X5 -> auto___type_9 (noncea_current X4 X5) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_54 (cons X1 (cons X3 nil)) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2). tauto.
  exact (rem_1512 X1 X2 X3).
Qed.

Remark rem_1514 : forall X1 X2 X3 X4 X5:term, auto___type_10 X3 -> auto___def_54 (cons X1 (cons X4 nil)) -> auto___def_66 (cons X5 (cons server nil)) -> auto___type_9 (noncea_current X5 X3) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_54 (cons X1 (cons X3 nil)) -> auto___def_66 (cons X4 (cons server nil)) -> auto___type_10 X5 -> auto___type_9 (noncea_current X4 X5) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2). tauto. exact (rem_1513 X1 X2 X3 X4 X5).
Qed.

Remark rem_1515 : forall X1 X2 X3 X4 X5:term, auto___def_53 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_66 (cons X5 (cons server nil)) -> auto___type_9 (noncea_current X5 X3) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_854 X3 (cons X1 (cons X4 nil)) H);  intros.
  apply (rem_1514 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1516 : forall X1 X2 X3 X4 X5:term, auto___def_53 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_57 sym -> auto___def_66 (cons X5 (cons server nil)) -> auto___type_9 (noncea_current X5 X3) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_53 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_66 (cons X5 (cons server nil)) -> auto___type_9 (noncea_current X5 X3) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2). tauto.
  exact (rem_1515 X1 X2 X3 X4 X5).
Qed.

Remark rem_1517 : forall X1 X2 X3 X4 X5:term, auto___def_57 sym -> auto___def_66 (cons X3 (cons server nil)) -> auto___def_53 (cons X4 (cons X1 (cons X5 nil))) -> auto___type_9 (noncea_current X3 X4) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_53 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_57 sym -> auto___def_66 (cons X5 (cons server nil)) -> auto___type_9 (noncea_current X5 X3) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2). tauto. exact (rem_1516 X1 X2 X3 X4 X5).
Qed.

Remark rem_1518 : forall X1 X2 X3 X4 X5:term, auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_53 (cons X4 (cons X1 (cons X5 nil))) -> auto___type_9 (noncea_current X3 X4) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_298 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_1517 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1519 : forall X1 X2 X3 X4 X5:term, auto___type_9 (noncea_current X3 X4) -> auto___def_53 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_52 (key sym (cons X3 (cons server nil))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_52 (key sym (cons X3 (cons server nil))) -> auto___def_53 (cons X4 (cons X1 (cons X5 nil))) -> auto___type_9 (noncea_current X3 X4) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2). tauto. exact (rem_1518 X1 X2 X3 X4 X5).
Qed.

Remark rem_1520 : forall X1 X2 X3 X4 X5:term, auto___def_51 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_52 (key sym (cons X3 (cons server nil))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_860 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1519 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1521 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current (cons X1 (cons X4 nil)) -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X3 -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> False). tauto.
  exact (rem_1058 X3 X5).
Qed.

Remark rem_1522 : forall X1 X2 X3 X4 X5:term, auto_knows_current X3 -> auto_knows_current (cons X1 (cons X4 nil)) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current (cons X1 (cons X4 nil)) -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto. exact (rem_1521 X1 X2 X3 X4 X5).
Qed.

Remark rem_1523 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (cons X3 (cons X1 (cons X4 nil))) -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_431 X3 (cons X1 (cons X4 nil)) H);  intros.
  apply (rem_1522 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1524 : forall X1 X2 X3 X4 X5:term, auto_knows_current (noncea_current X3 X4) -> auto_knows_current (cons X4 (cons X1 (cons X5 nil))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (cons X3 (cons X1 (cons X4 nil))) -> auto_knows_current (key sym (cons X5 (cons server nil))) -> auto_knows_current (noncea_current X5 X3) -> auto___def_70 X1 X2). tauto. exact (rem_1523 X1 X2 X3 X4 X5).
Qed.

Remark rem_1525 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_431 (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_1524 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1526 : forall X1 X2 X3 X4 X5:term, auto_knows_current (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto_knows_current (key sym (cons X3 (cons server nil))) -> auto___def_70 X1 X2). tauto. exact (rem_1525 X1 X2 X3 X4 X5).
Qed.

Remark rem_1527 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (crypt (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_312 (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil))) H);  intros.
  apply (rem_1490 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1491 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1499 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1502 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1505 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1520 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1526 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1528 : forall X1 X2 X3 X4 X5:term, auto_knows_current (crypt X2 X1) -> auto_knows_current (crypt (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_70 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_312 X2 X1 H);  intros.
  apply (rem_995 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1065 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1229 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1314 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1418 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1489 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1527 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1529 : forall X1 X2 X3 X4 X5:term, auto_knows_current (crypt (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> auto_knows_current (crypt X2 X1) -> auto___def_70 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current (crypt X2 X1) -> auto_knows_current (crypt (cons (noncea_current X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_70 X1 X2). tauto. exact (rem_1528 X1 X2 X3 X4 X5).
Qed.

Remark rem_1530 : forall X1 X2 X3:term, auto___def_71 (cons X3 (cons X1 nil)) -> auto___type_13 (key sym (cons X2 (cons server nil))) -> auto___def_68 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_801 X3 (cons X1 nil) H);  intros.
Qed.

Remark rem_1531 : forall X1 X2 X3:term, auto___def_69 (cons X3 (cons X1 nil)) -> auto___type_12 (key sym (cons X2 (cons server nil))) -> auto___def_68 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_803 X3 (cons X1 nil) H);  intros.
Qed.

Remark rem_1532 : auto___def_15 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1533 : auto___def_15 nil -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_1532 H);  intros.
Qed.

Remark rem_1534 : forall X1 X2 X3:term, auto___def_15 nil -> auto___def_29 (cons X2 (cons server nil)) -> auto___type_3 X3 -> auto___type_4 X1 -> auto___def_68 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_15 nil -> False). tauto.
  exact (rem_1533).
Qed.

Remark rem_1535 : forall X1 X2 X3:term, auto___type_4 X1 -> auto___def_15 nil -> auto___def_29 (cons X2 (cons server nil)) -> auto___type_3 X3 -> auto___def_68 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_15 nil -> auto___def_29 (cons X2 (cons server nil)) -> auto___type_3 X3 -> auto___type_4 X1 -> auto___def_68 X1 X2 X3). tauto. exact (rem_1534 X1 X2 X3).
Qed.

Remark rem_1536 : forall X1 X2 X3:term, auto___def_14 (cons X1 nil) -> auto___def_29 (cons X2 (cons server nil)) -> auto___type_3 X3 -> auto___def_68 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_225 X1 nil H);  intros.
  apply (rem_1535 X1 X2 X3);  tauto.
Qed.

Remark rem_1537 : forall X1 X2 X3:term, auto___def_14 (cons X1 nil) -> auto___def_18 sym -> auto___def_29 (cons X2 (cons server nil)) -> auto___type_3 X3 -> auto___def_68 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_14 (cons X1 nil) -> auto___def_29 (cons X2 (cons server nil)) -> auto___type_3 X3 -> auto___def_68 X1 X2 X3). tauto.
  exact (rem_1536 X1 X2 X3).
Qed.

Remark rem_1538 : forall X1 X2 X3:term, auto___def_18 sym -> auto___def_29 (cons X2 (cons server nil)) -> auto___def_14 (cons X1 nil) -> auto___type_3 X3 -> auto___def_68 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_14 (cons X1 nil) -> auto___def_18 sym -> auto___def_29 (cons X2 (cons server nil)) -> auto___type_3 X3 -> auto___def_68 X1 X2 X3). tauto. exact (rem_1537 X1 X2 X3).
Qed.

Remark rem_1539 : forall X1 X2 X3:term, auto___def_13 (key sym (cons X2 (cons server nil))) -> auto___def_14 (cons X1 nil) -> auto___type_3 X3 -> auto___def_68 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_167 sym (cons X2 (cons server nil)) H);  intros.
  apply (rem_1538 X1 X2 X3);  tauto.
Qed.

Remark rem_1540 : forall X1 X2 X3:term, auto___type_3 X3 -> auto___def_14 (cons X1 nil) -> auto___def_13 (key sym (cons X2 (cons server nil))) -> auto___def_68 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_13 (key sym (cons X2 (cons server nil))) -> auto___def_14 (cons X1 nil) -> auto___type_3 X3 -> auto___def_68 X1 X2 X3). tauto. exact (rem_1539 X1 X2 X3).
Qed.

Remark rem_1541 : forall X1 X2 X3:term, auto___def_12 (cons X3 (cons X1 nil)) -> auto___def_13 (key sym (cons X2 (cons server nil))) -> auto___def_68 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_231 X3 (cons X1 nil) H);  intros.
  apply (rem_1540 X1 X2 X3);  tauto.
Qed.

Remark rem_1542 : forall X1 X2 X3:term, auto___def_55 X3 -> auto___def_65 (cons server nil) -> auto___type_10 X2 -> auto___type_11 X1 -> auto___type_11 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___type_11 X1 -> auto___type_11 X1). tauto. exact (rem_829 X1).
Qed.

Remark rem_1543 : forall X1 X2 X3:term, auto___def_55 X3 -> auto___def_65 (cons server nil) -> auto___type_10 X2 -> auto___type_11 X1 -> auto___type_10 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___type_10 X2 -> auto___type_10 X2). tauto. exact (rem_832 X2).
Qed.

Remark rem_1544 : forall X1 X2 X3:term, auto___def_55 X3 -> auto___def_65 (cons server nil) -> auto___type_10 X2 -> auto___type_11 X1 -> auto___def_55 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_55 X3 -> auto___def_55 X3). tauto. exact (rem_834 X3).
Qed.

Remark rem_1545 : forall X1 X2 X3:term, auto___def_55 X3 -> auto___def_65 (cons server nil) -> auto___type_10 X2 -> auto___type_11 X1 -> (auto___type_11 X1 /\ auto___type_10 X2 /\ auto___def_55 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  cut (auto___type_11 X1). 2:apply (rem_1542 X1 X2 X3);  assumption.
  cut (auto___type_10 X2). 2:apply (rem_1543 X1 X2 X3);  assumption.
  cut (auto___def_55 X3). 2:apply (rem_1544 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_1546 : forall X1 X2 X3:term, auto___def_55 X3 -> auto___def_65 (cons server nil) -> auto___type_10 X2 -> auto___type_11 X1 -> auto___def_68 X1 X2 X3. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  case (rem_1545 X1 X2 X3 A1 A2 A3 A4). clear  A1 A2 A3 A4. intros. apply trans___def_68_1;  tauto.
 clear  A1 A2 A3 A4. tauto.
Qed.

Remark rem_1547 : forall X1 X2 X3:term, auto___type_10 X2 -> auto___def_65 (cons server nil) -> auto___def_55 X3 -> auto___type_11 X1 -> auto___def_68 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_55 X3 -> auto___def_65 (cons server nil) -> auto___type_10 X2 -> auto___type_11 X1 -> auto___def_68 X1 X2 X3). tauto. exact (rem_1546 X1 X2 X3).
Qed.

Remark rem_1548 : forall X1 X2 X3:term, auto___def_55 X3 -> auto___def_64 (cons X2 (cons server nil)) -> auto___type_11 X1 -> auto___def_68 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_1235 X2 (cons server nil) H);  intros.
  apply (rem_1547 X1 X2 X3);  tauto.
Qed.

Remark rem_1549 : forall X1 X2 X3:term, auto___def_55 X3 -> auto___def_60 nil -> auto___def_64 (cons X2 (cons server nil)) -> auto___type_11 X1 -> auto___def_68 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_55 X3 -> auto___def_64 (cons X2 (cons server nil)) -> auto___type_11 X1 -> auto___def_68 X1 X2 X3). tauto.
  exact (rem_1548 X1 X2 X3).
Qed.

Remark rem_1550 : forall X1 X2 X3:term, auto___type_11 X1 -> auto___def_60 nil -> auto___def_55 X3 -> auto___def_64 (cons X2 (cons server nil)) -> auto___def_68 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_55 X3 -> auto___def_60 nil -> auto___def_64 (cons X2 (cons server nil)) -> auto___type_11 X1 -> auto___def_68 X1 X2 X3). tauto. exact (rem_1549 X1 X2 X3).
Qed.

Remark rem_1551 : forall X1 X2:term, auto___def_63 (cons X1 X2) -> or_1
    (auto___type_11 X1 /\ auto___def_60 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1552 : forall X1 X2 X3:term, auto___def_55 X3 -> auto___def_63 (cons X1 nil) -> auto___def_64 (cons X2 (cons server nil)) -> auto___def_68 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_1551 X1 nil H);  intros.
  apply (rem_1550 X1 X2 X3);  tauto.
Qed.

Remark rem_1553 : forall X1 X2 X3:term, auto___def_55 X3 -> auto___def_57 sym -> auto___def_63 (cons X1 nil) -> auto___def_64 (cons X2 (cons server nil)) -> auto___def_68 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_55 X3 -> auto___def_63 (cons X1 nil) -> auto___def_64 (cons X2 (cons server nil)) -> auto___def_68 X1 X2 X3). tauto.
  exact (rem_1552 X1 X2 X3).
Qed.

Remark rem_1554 : forall X1 X2 X3:term, auto___def_57 sym -> auto___def_64 (cons X2 (cons server nil)) -> auto___def_55 X3 -> auto___def_63 (cons X1 nil) -> auto___def_68 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_55 X3 -> auto___def_57 sym -> auto___def_63 (cons X1 nil) -> auto___def_64 (cons X2 (cons server nil)) -> auto___def_68 X1 X2 X3). tauto. exact (rem_1553 X1 X2 X3).
Qed.

Remark rem_1555 : forall X1 X2 X3:term, auto___def_55 X3 -> auto___def_62 (key sym (cons X2 (cons server nil))) -> auto___def_63 (cons X1 nil) -> auto___def_68 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_291 sym (cons X2 (cons server nil)) H);  intros.
  apply (rem_1554 X1 X2 X3);  tauto.
Qed.

Remark rem_1556 : forall X1 X2 X3:term, auto___def_55 X3 -> auto___def_63 (cons X1 nil) -> auto___def_62 (key sym (cons X2 (cons server nil))) -> auto___def_68 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_55 X3 -> auto___def_62 (key sym (cons X2 (cons server nil))) -> auto___def_63 (cons X1 nil) -> auto___def_68 X1 X2 X3). tauto. exact (rem_1555 X1 X2 X3).
Qed.

Remark rem_1557 : forall X1 X2 X3:term, auto___def_61 (cons X3 (cons X1 nil)) -> auto___def_62 (key sym (cons X2 (cons server nil))) -> auto___def_68 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_823 X3 (cons X1 nil) H);  intros.
  apply (rem_1556 X1 X2 X3);  tauto.
Qed.

Remark rem_1558 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_26 (cons server nil) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___type_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___type_5 X1 -> auto___type_5 X1). tauto. exact (rem_199 X1).
Qed.

Remark rem_1559 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_26 (cons server nil) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___type_4 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___type_4 X2 -> auto___type_4 X2). tauto. exact (rem_203 X2).
Qed.

Remark rem_1560 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_26 (cons server nil) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_16 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_16 X3 -> auto___def_16 X3). tauto. exact (rem_205 X3).
Qed.

Remark rem_1561 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_26 (cons server nil) -> auto___type_4 X2 -> auto___type_5 X1 -> (auto___type_5 X1 /\ auto___type_4 X2 /\ auto___def_16 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  cut (auto___type_5 X1). 2:apply (rem_1558 X1 X2 X3);  assumption.
  cut (auto___type_4 X2). 2:apply (rem_1559 X1 X2 X3);  assumption.
  cut (auto___def_16 X3). 2:apply (rem_1560 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_1562 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_26 (cons server nil) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_68 X1 X2 X3. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  case (rem_1561 X1 X2 X3 A1 A2 A3 A4). clear  A1 A2 A3 A4. intros. apply trans___def_68_2;  tauto.
 clear  A1 A2 A3 A4. tauto.
Qed.

Remark rem_1563 : forall X1 X2 X3:term, auto___type_4 X2 -> auto___def_26 (cons server nil) -> auto___def_16 X3 -> auto___type_5 X1 -> auto___def_68 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_16 X3 -> auto___def_26 (cons server nil) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_68 X1 X2 X3). tauto. exact (rem_1562 X1 X2 X3).
Qed.

Remark rem_1564 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_25 (cons X2 (cons server nil)) -> auto___type_5 X1 -> auto___def_68 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_694 X2 (cons server nil) H);  intros.
  apply (rem_1563 X1 X2 X3);  tauto.
Qed.

Remark rem_1565 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_21 nil -> auto___def_25 (cons X2 (cons server nil)) -> auto___type_5 X1 -> auto___def_68 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_16 X3 -> auto___def_25 (cons X2 (cons server nil)) -> auto___type_5 X1 -> auto___def_68 X1 X2 X3). tauto.
  exact (rem_1564 X1 X2 X3).
Qed.

Remark rem_1566 : forall X1 X2 X3:term, auto___type_5 X1 -> auto___def_21 nil -> auto___def_16 X3 -> auto___def_25 (cons X2 (cons server nil)) -> auto___def_68 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_16 X3 -> auto___def_21 nil -> auto___def_25 (cons X2 (cons server nil)) -> auto___type_5 X1 -> auto___def_68 X1 X2 X3). tauto. exact (rem_1565 X1 X2 X3).
Qed.

Remark rem_1567 : forall X1 X2:term, auto___def_24 (cons X1 X2) -> or_1
    (auto___type_5 X1 /\ auto___def_21 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1568 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_24 (cons X1 nil) -> auto___def_25 (cons X2 (cons server nil)) -> auto___def_68 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_1567 X1 nil H);  intros.
  apply (rem_1566 X1 X2 X3);  tauto.
Qed.

Remark rem_1569 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_18 sym -> auto___def_24 (cons X1 nil) -> auto___def_25 (cons X2 (cons server nil)) -> auto___def_68 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_16 X3 -> auto___def_24 (cons X1 nil) -> auto___def_25 (cons X2 (cons server nil)) -> auto___def_68 X1 X2 X3). tauto.
  exact (rem_1568 X1 X2 X3).
Qed.

Remark rem_1570 : forall X1 X2 X3:term, auto___def_18 sym -> auto___def_25 (cons X2 (cons server nil)) -> auto___def_16 X3 -> auto___def_24 (cons X1 nil) -> auto___def_68 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_16 X3 -> auto___def_18 sym -> auto___def_24 (cons X1 nil) -> auto___def_25 (cons X2 (cons server nil)) -> auto___def_68 X1 X2 X3). tauto. exact (rem_1569 X1 X2 X3).
Qed.

Remark rem_1571 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_23 (key sym (cons X2 (cons server nil))) -> auto___def_24 (cons X1 nil) -> auto___def_68 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_174 sym (cons X2 (cons server nil)) H);  intros.
  apply (rem_1570 X1 X2 X3);  tauto.
Qed.

Remark rem_1572 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_24 (cons X1 nil) -> auto___def_23 (key sym (cons X2 (cons server nil))) -> auto___def_68 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_16 X3 -> auto___def_23 (key sym (cons X2 (cons server nil))) -> auto___def_24 (cons X1 nil) -> auto___def_68 X1 X2 X3). tauto. exact (rem_1571 X1 X2 X3).
Qed.

Remark rem_1573 : forall X1 X2 X3:term, auto___def_22 (cons X3 (cons X1 nil)) -> auto___def_23 (key sym (cons X2 (cons server nil))) -> auto___def_68 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_237 X3 (cons X1 nil) H);  intros.
  apply (rem_1572 X1 X2 X3);  tauto.
Qed.

Remark rem_1574 : auto___def_54 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1575 : auto___def_54 nil -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_1574 H);  intros.
Qed.

Remark rem_1576 : forall X1 X2 X3:term, auto___def_54 nil -> auto___def_66 (cons X2 (cons server nil)) -> auto___type_10 X1 -> auto___type_9 X3 -> auto___def_68 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_54 nil -> False). tauto.
  exact (rem_1575).
Qed.

Remark rem_1577 : forall X1 X2 X3:term, auto___type_10 X1 -> auto___def_54 nil -> auto___def_66 (cons X2 (cons server nil)) -> auto___type_9 X3 -> auto___def_68 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_54 nil -> auto___def_66 (cons X2 (cons server nil)) -> auto___type_10 X1 -> auto___type_9 X3 -> auto___def_68 X1 X2 X3). tauto. exact (rem_1576 X1 X2 X3).
Qed.

Remark rem_1578 : forall X1 X2 X3:term, auto___def_53 (cons X1 nil) -> auto___def_66 (cons X2 (cons server nil)) -> auto___type_9 X3 -> auto___def_68 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_854 X1 nil H);  intros.
  apply (rem_1577 X1 X2 X3);  tauto.
Qed.

Remark rem_1579 : forall X1 X2 X3:term, auto___def_53 (cons X1 nil) -> auto___def_57 sym -> auto___def_66 (cons X2 (cons server nil)) -> auto___type_9 X3 -> auto___def_68 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_53 (cons X1 nil) -> auto___def_66 (cons X2 (cons server nil)) -> auto___type_9 X3 -> auto___def_68 X1 X2 X3). tauto.
  exact (rem_1578 X1 X2 X3).
Qed.

Remark rem_1580 : forall X1 X2 X3:term, auto___def_57 sym -> auto___def_66 (cons X2 (cons server nil)) -> auto___def_53 (cons X1 nil) -> auto___type_9 X3 -> auto___def_68 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_53 (cons X1 nil) -> auto___def_57 sym -> auto___def_66 (cons X2 (cons server nil)) -> auto___type_9 X3 -> auto___def_68 X1 X2 X3). tauto. exact (rem_1579 X1 X2 X3).
Qed.

Remark rem_1581 : forall X1 X2 X3:term, auto___def_52 (key sym (cons X2 (cons server nil))) -> auto___def_53 (cons X1 nil) -> auto___type_9 X3 -> auto___def_68 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_298 sym (cons X2 (cons server nil)) H);  intros.
  apply (rem_1580 X1 X2 X3);  tauto.
Qed.

Remark rem_1582 : forall X1 X2 X3:term, auto___type_9 X3 -> auto___def_53 (cons X1 nil) -> auto___def_52 (key sym (cons X2 (cons server nil))) -> auto___def_68 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_52 (key sym (cons X2 (cons server nil))) -> auto___def_53 (cons X1 nil) -> auto___type_9 X3 -> auto___def_68 X1 X2 X3). tauto. exact (rem_1581 X1 X2 X3).
Qed.

Remark rem_1583 : forall X1 X2 X3:term, auto___def_51 (cons X3 (cons X1 nil)) -> auto___def_52 (key sym (cons X2 (cons server nil))) -> auto___def_68 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_860 X3 (cons X1 nil) H);  intros.
  apply (rem_1582 X1 X2 X3);  tauto.
Qed.

Remark rem_1584 : forall X1 X2 X3:term, auto___def_40 (cons X2 (cons server nil)) -> auto_knows_current X1 -> auto_knows_current X3 -> auto___def_68 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_862 X2 (cons server nil) H);  intros.
Qed.

Remark rem_1585 : forall X1 X2 X3:term, auto___def_39 sym -> auto___def_40 (cons X2 (cons server nil)) -> auto_knows_current X1 -> auto_knows_current X3 -> auto___def_68 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_40 (cons X2 (cons server nil)) -> auto_knows_current X1 -> auto_knows_current X3 -> auto___def_68 X1 X2 X3). tauto.
  exact (rem_1584 X1 X2 X3).
Qed.

Remark rem_1586 : forall X1 X2 X3:term, auto___def_35 sym -> auto_knows_current X1 -> auto_knows_current X3 -> auto___def_68 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_35 sym -> False). tauto.
  exact (rem_240).
Qed.

Remark rem_1587 : forall X1 X2 X3:term, auto___def_35 sym -> auto___type_8 (cons X2 (cons server nil)) -> auto_knows_current X1 -> auto_knows_current X3 -> auto___def_68 X1 X2 X3. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2 X3. intros. apply (rem_1586 X1 X2 X3);  assumption.
Qed.

Remark rem_1588 : forall X1 X2 X3:term, auto___def_37 (cons X2 (cons server nil)) -> auto_knows_current X1 -> auto_knows_current X3 -> auto___def_68 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_243 X2 (cons server nil) H);  intros.
Qed.

Remark rem_1589 : forall X1 X2 X3:term, auto___def_36 sym -> auto___def_37 (cons X2 (cons server nil)) -> auto_knows_current X1 -> auto_knows_current X3 -> auto___def_68 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_37 (cons X2 (cons server nil)) -> auto_knows_current X1 -> auto_knows_current X3 -> auto___def_68 X1 X2 X3). tauto.
  exact (rem_1588 X1 X2 X3).
Qed.

Remark rem_1590 : forall X1 X2 X3:term, auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current (key sym (cons X2 (cons server nil))) -> auto___def_68 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1 H2. intro H. intros.
  elim (rem_310 sym (cons X2 (cons server nil)) H);  intros.
  apply (rem_1585 X1 X2 X3);  tauto.
  apply (rem_1587 X1 X2 X3);  tauto.
  apply (rem_1589 X1 X2 X3);  tauto.
Qed.

Remark rem_1591 : forall X1 X2 X3:term, auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current (key sym (cons X2 (cons server nil))) -> auto_knows_current nil -> auto___def_68 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current (key sym (cons X2 (cons server nil))) -> auto___def_68 X1 X2 X3). tauto.
  exact (rem_1590 X1 X2 X3).
Qed.

Remark rem_1592 : forall X1 X2 X3:term, auto_knows_current X1 -> auto_knows_current nil -> auto_knows_current X3 -> auto_knows_current (key sym (cons X2 (cons server nil))) -> auto___def_68 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current (key sym (cons X2 (cons server nil))) -> auto_knows_current nil -> auto___def_68 X1 X2 X3). tauto. exact (rem_1591 X1 X2 X3).
Qed.

Remark rem_1593 : forall X1 X2 X3:term, auto_knows_current X3 -> auto_knows_current (cons X1 nil) -> auto_knows_current (key sym (cons X2 (cons server nil))) -> auto___def_68 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_431 X1 nil H);  intros.
  apply (rem_1592 X1 X2 X3);  tauto.
Qed.

Remark rem_1594 : forall X1 X2 X3:term, auto_knows_current (cons X3 (cons X1 nil)) -> auto_knows_current (key sym (cons X2 (cons server nil))) -> auto___def_68 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_431 X3 (cons X1 nil) H);  intros.
  apply (rem_1593 X1 X2 X3);  tauto.
Qed.

Remark rem_1595 : forall X1 X2 X3:term, auto_knows_current (crypt (cons X3 (cons X1 nil)) (key sym (cons X2 (cons server nil)))) -> auto___def_68 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_312 (cons X3 (cons X1 nil)) (key sym (cons X2 (cons server nil))) H);  intros.
  apply (rem_1530 X1 X2 X3);  tauto.
  apply (rem_1531 X1 X2 X3);  tauto.
  apply (rem_1541 X1 X2 X3);  tauto.
  apply (rem_1557 X1 X2 X3);  tauto.
  apply (rem_1573 X1 X2 X3);  tauto.
  apply (rem_1583 X1 X2 X3);  tauto.
  apply (rem_1594 X1 X2 X3);  tauto.
Qed.

Remark rem_1596 : forall X1 X2:term, auto___def_57 X1 -> auto___def_66 X2 -> auto___def_57 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_57 X1 -> auto___def_57 X1). tauto. exact (rem_46 X1).
Qed.

Remark rem_1597 : forall X2:term, auto___def_66 X2 -> auto___def_66 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1598 : forall X1 X2:term, auto___def_57 X1 -> auto___def_66 X2 -> auto___def_66 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_66 X2 -> auto___def_66 X2). tauto. exact (rem_1597 X2).
Qed.

Remark rem_1599 : forall X1 X2:term, auto___def_57 X1 -> auto___def_66 X2 -> (auto___def_57 X1 /\ auto___def_66 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_57 X1). 2:apply (rem_1596 X1 X2);  assumption.
  cut (auto___def_66 X2). 2:apply (rem_1598 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1600 : forall X1 X2:term, auto___def_57 X1 -> auto___def_66 X2 -> auto___def_52 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1599 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_52_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1601 : forall X1 X2:term, auto___def_66 X2 -> auto___def_57 X1 -> auto___def_52 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_57 X1 -> auto___def_66 X2 -> auto___def_52 (key X1 X2)). tauto. exact (rem_1600 X1 X2).
Qed.

Remark rem_1602 : forall X1 X2:term, auto___def_65 X2 -> auto___type_11 X1 -> auto___type_11 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_11 X1 -> auto___type_11 X1). tauto. exact (rem_829 X1).
Qed.

Remark rem_1603 : forall X2:term, auto___def_65 X2 -> auto___def_65 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1604 : forall X1 X2:term, auto___def_65 X2 -> auto___type_11 X1 -> auto___def_65 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_65 X2 -> auto___def_65 X2). tauto. exact (rem_1603 X2).
Qed.

Remark rem_1605 : forall X1 X2:term, auto___def_65 X2 -> auto___type_11 X1 -> (auto___type_11 X1 /\ auto___def_65 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_11 X1). 2:apply (rem_1602 X1 X2);  assumption.
  cut (auto___def_65 X2). 2:apply (rem_1604 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1606 : forall X1 X2:term, auto___def_65 X2 -> auto___type_11 X1 -> auto___def_66 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1605 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_66_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1607 : forall X1:term, auto___def_39 prv -> auto___def_40 X1 -> auto___def_42 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_39 prv -> False). tauto.
  exact (rem_301).
Qed.

Remark rem_1608 : forall X1:term, auto___def_35 prv -> auto___def_42 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_35 prv -> False). tauto.
  exact (rem_177).
Qed.

Remark rem_1609 : forall X1:term, auto___def_35 prv -> auto___type_8 X1 -> auto___def_42 X1. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1. intros. apply (rem_1608 X1);  assumption.
Qed.

Remark rem_1610 : (forall X:term, auto___def_37 X -> auto___def_42 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_37_p__def_42.  tauto.
Defined.

Remark rem_1611 : (forall X:term, auto___def_37 X -> auto___def_42 X)
    -> auto___def_42 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_37_p__def_42.  case (rem_1610 epsilon_m__def_37_p__def_42). clear  epsilon_m__def_37_p__def_42. intros. apply trans___def_42_i_1;  tauto.
 clear  epsilon_m__def_37_p__def_42. tauto.
Defined.

Remark rem_1612 : auto___def_37 i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1613 : (forall X:term, auto___def_37 X -> auto___def_42 X)
    -> auto___def_37 i -> auto___def_42 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_37_p__def_42. intro H. intros.
  elim (rem_1612 H);  intros.
  apply (rem_1611 epsilon_m__def_37_p__def_42);  tauto.
Defined.

Remark rem_1614 : forall X1 X2:term, auto___def_37 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1615 : auto___def_37 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1616 : forall X1 X2 X3:term, auto___def_37 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1617 : auto___def_37 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1618 : forall X1:term, auto___def_37 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1619 : auto___def_37 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1620 : forall X1 X2:term, auto___def_37 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1621 : forall X1 X2 X3:term, auto___def_37 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1622 : forall X1 X2 X3:term, auto___def_37 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1623 : forall X1 X2:term, auto___def_37 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1624 : forall X1 X2 X3:term, auto___def_37 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1625 : forall X1 X2:term, auto___def_37 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1626 : auto___def_37 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1627 : auto___def_37 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1628 : auto___def_37 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1629 : auto___def_37 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1630 : forall X1:term, auto___def_37 X1 -> auto___def_42 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_37_p__def_42 1.
  intro X. case X.
   intro H. elim (rem_1617  H).
   intro H. elim (rem_1615  H).
  intros X1 X2. intro H. elim (rem_243 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1623 X1 X2 H).
  exact (rem_1613 epsilon_m__def_37_p__def_42 ).
  intros X1 X2. intro H. elim (rem_1620 X1 X2 H).
   intro H. elim (rem_1619  H).
  intros X1 X2. intro H. elim (rem_1614 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1625 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1621 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1622 X1 X2 X3 H).
   intro H. elim (rem_1628  H).
   intro H. elim (rem_1626  H).
  intros X1. intro H. elim (rem_1618 X1 H).
   intro H. elim (rem_1627  H).
  intros X1 X2 X3. intro H. elim (rem_1616 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1624 X1 X2 X3 H).
   intro H. elim (rem_1629  H).
Qed.

Remark rem_1631 : forall X1:term, auto___def_36 prv -> auto___def_37 X1 -> auto___def_42 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1.
  cut (auto___def_37 X1 -> auto___def_42 X1). tauto. exact (rem_1630 X1).
Qed.

Remark rem_1632 : forall X1:term, auto_knows_current (key prv X1) -> auto___def_42 X1. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_310 prv X1 H);  intros.
  apply (rem_1607 X1);  tauto.
  apply (rem_1609 X1);  tauto.
  apply (rem_1631 X1);  tauto.
Qed.

Remark rem_1633 : forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> auto___def_55 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_55 X1 -> auto___def_55 X1). tauto. exact (rem_258 X1).
Qed.

Remark rem_1634 : forall X2:term, auto___def_56 X2 -> auto___def_56 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1635 : forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> auto___def_56 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_56 X2 -> auto___def_56 X2). tauto. exact (rem_1634 X2).
Qed.

Remark rem_1636 : forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> (auto___def_55 X1 /\ auto___def_56 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_55 X1). 2:apply (rem_1633 X1 X2);  assumption.
  cut (auto___def_56 X2). 2:apply (rem_1635 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1637 : forall X1 X2:term, auto___def_55 X1 -> auto___def_56 X2 -> auto___def_54 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1636 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_54_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1638 : forall X1 X2:term, auto___def_56 X2 -> auto___def_55 X1 -> auto___def_54 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_55 X1 -> auto___def_56 X2 -> auto___def_54 (cons X1 X2)). tauto. exact (rem_1637 X1 X2).
Qed.

Remark rem_1639 : forall X1 X2:term, auto___def_71 X2 -> auto___type_13 (key pub X1) -> auto___type_8 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_8_1. Qed.

Remark rem_1640 : (forall X:term, auto___def_71 X -> auto_knows_current X)
    -> forall X1:term, auto___def_71 X1 -> auto_knows_current X1. (* Use induction hypothesis. *)
Proof.
   intro Hrec. intros X1.
  cut (auto___def_71 X1 -> auto_knows_current X1). tauto. exact (Hrec X1).
Defined.

Remark rem_1641 : (forall X:term, auto___def_71 X -> auto_knows_current X)
    -> forall X1:term, auto___def_71 X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_71_pknows_current. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_1640 epsilon_m__def_71_pknows_current X1);  assumption.
  tauto.
Defined.

Remark rem_1642 : (forall X:term, auto___def_71 X -> auto_knows_current X)
    -> forall X1:term, auto___def_71 X1 -> auto_knows_current (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_71_pknows_current. intros X1. intros A1.
  case (rem_1641 epsilon_m__def_71_pknows_current X1 A1). clear  epsilon_m__def_71_pknows_current A1. intros. apply trans_knows_current_s_1;  tauto.
 clear  epsilon_m__def_71_pknows_current A1. tauto.
Defined.

Remark rem_1643 : (forall X:term, auto___def_69 X -> auto_knows_current X)
    -> forall X1:term, auto___def_16 X1 -> auto___def_16 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1644 : (forall X:term, auto___def_69 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___def_16 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_69_pknows_current. intros X1 X2 X3.
  cut (auto___def_16 X1 -> auto___def_16 X1). tauto. exact (rem_1643 epsilon_m__def_69_pknows_current X1).
Defined.

Remark rem_1645 : (forall X:term, auto___def_69 X -> auto_knows_current X)
    -> forall X2:term, auto___type_5 X2 -> auto___type_5 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1646 : (forall X:term, auto___def_69 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_69_pknows_current. intros X1 X2 X3.
  cut (auto___type_5 X2 -> auto___type_5 X2). tauto. exact (rem_1645 epsilon_m__def_69_pknows_current X2).
Defined.

Remark rem_1647 : (forall X:term, auto___def_69 X -> auto_knows_current X)
    -> forall X3:term, auto___type_4 X3 -> auto___type_4 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1648 : (forall X:term, auto___def_69 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_4 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_69_pknows_current. intros X1 X2 X3.
  cut (auto___type_4 X3 -> auto___type_4 X3). tauto. exact (rem_1647 epsilon_m__def_69_pknows_current X3).
Defined.

Remark rem_1649 : (forall X:term, auto___def_69 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> (auto___def_16 X1 /\ auto___type_5 X2 /\ auto___type_4 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_69_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_16 X1). 2:apply (rem_1644 epsilon_m__def_69_pknows_current X1 X2 X3);  assumption.
  cut (auto___type_5 X2). 2:apply (rem_1646 epsilon_m__def_69_pknows_current X1 X2 X3);  assumption.
  cut (auto___type_4 X3). 2:apply (rem_1648 epsilon_m__def_69_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_1650 : (forall X:term, auto___def_69 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto_knows_current (nonceb_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_69_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_1649 epsilon_m__def_69_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m__def_69_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonceb_current_1;  tauto.
 clear  epsilon_m__def_69_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_1651 : (forall X:term, auto___def_69 X -> auto_knows_current X)
    -> forall X1:term, auto___def_55 X1 -> auto___def_55 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1652 : (forall X:term, auto___def_69 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto___def_55 X1 -> auto___type_11 X2 -> auto___type_10 X3 -> auto___def_55 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_69_pknows_current. intros X1 X2 X3.
  cut (auto___def_55 X1 -> auto___def_55 X1). tauto. exact (rem_1651 epsilon_m__def_69_pknows_current X1).
Defined.

Remark rem_1653 : (forall X:term, auto___def_69 X -> auto_knows_current X)
    -> forall X2:term, auto___type_11 X2 -> auto___type_11 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1654 : (forall X:term, auto___def_69 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto___def_55 X1 -> auto___type_11 X2 -> auto___type_10 X3 -> auto___type_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_69_pknows_current. intros X1 X2 X3.
  cut (auto___type_11 X2 -> auto___type_11 X2). tauto. exact (rem_1653 epsilon_m__def_69_pknows_current X2).
Defined.

Remark rem_1655 : (forall X:term, auto___def_69 X -> auto_knows_current X)
    -> forall X3:term, auto___type_10 X3 -> auto___type_10 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1656 : (forall X:term, auto___def_69 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto___def_55 X1 -> auto___type_11 X2 -> auto___type_10 X3 -> auto___type_10 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_69_pknows_current. intros X1 X2 X3.
  cut (auto___type_10 X3 -> auto___type_10 X3). tauto. exact (rem_1655 epsilon_m__def_69_pknows_current X3).
Defined.

Remark rem_1657 : (forall X:term, auto___def_69 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto___def_55 X1 -> auto___type_11 X2 -> auto___type_10 X3 -> (auto___def_55 X1 /\ auto___type_11 X2 /\ auto___type_10 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_69_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_55 X1). 2:apply (rem_1652 epsilon_m__def_69_pknows_current X1 X2 X3);  assumption.
  cut (auto___type_11 X2). 2:apply (rem_1654 epsilon_m__def_69_pknows_current X1 X2 X3);  assumption.
  cut (auto___type_10 X3). 2:apply (rem_1656 epsilon_m__def_69_pknows_current X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_1658 : (forall X:term, auto___def_69 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto___def_55 X1 -> auto___type_11 X2 -> auto___type_10 X3 -> auto_knows_current (nonceb_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_69_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_1657 epsilon_m__def_69_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m__def_69_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonceb_current_2;  tauto.
 clear  epsilon_m__def_69_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_1659 : forall X1 X2 X3:term, auto___def_69 (nonceb_current X1 X2 X3) -> or_2
    (auto___def_16 X1 /\ auto___type_5 X2 /\ auto___type_4 X3)
    (auto___def_55 X1 /\ auto___type_11 X2 /\ auto___type_10 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_1660 : (forall X:term, auto___def_69 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto___def_69 (nonceb_current X1 X2 X3) -> auto_knows_current (nonceb_current X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_69_pknows_current. intros X1 X2 X3. intro H. intros.
  elim (rem_1659 X1 X2 X3 H);  intros.
  apply (rem_1650 epsilon_m__def_69_pknows_current X1 X2 X3);  tauto.
  apply (rem_1658 epsilon_m__def_69_pknows_current X1 X2 X3);  tauto.
Defined.

Remark rem_1661 : forall X1 X2:term, auto___def_69 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1662 : auto___def_69 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1663 : forall X1 X2 X3:term, auto___def_69 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1664 : auto___def_69 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1665 : forall X1:term, auto___def_69 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1666 : auto___def_69 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1667 : auto___def_69 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1668 : forall X1 X2:term, auto___def_69 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1669 : forall X1 X2 X3:term, auto___def_69 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1670 : forall X1 X2:term, auto___def_69 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1671 : forall X1 X2 X3:term, auto___def_69 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1672 : forall X1 X2:term, auto___def_69 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1673 : auto___def_69 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1674 : auto___def_69 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1675 : auto___def_69 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1676 : auto___def_69 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1677 : forall X1:term, auto___def_69 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_m__def_69_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_1664  H).
   intro H. elim (rem_1662  H).
  intros X1 X2. intro H. elim (rem_803 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1670 X1 X2 H).
   intro H. elim (rem_1667  H).
  intros X1 X2. intro H. elim (rem_1668 X1 X2 H).
   intro H. elim (rem_1666  H).
  intros X1 X2. intro H. elim (rem_1661 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1672 X1 X2 H).
  intros X1 X2 X3;  exact (rem_1660 epsilon_m__def_69_pknows_current X1 X2 X3).
  intros X1 X2 X3. intro H. elim (rem_1669 X1 X2 X3 H).
   intro H. elim (rem_1675  H).
   intro H. elim (rem_1673  H).
  intros X1. intro H. elim (rem_1665 X1 H).
   intro H. elim (rem_1674  H).
  intros X1 X2 X3. intro H. elim (rem_1663 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1671 X1 X2 X3 H).
   intro H. elim (rem_1676  H).
Qed.

Remark rem_1678 : (forall X:term, auto___def_71 X -> auto_knows_current X)
    -> forall X1:term, auto___def_69 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__def_71_pknows_current. exact (rem_1677).
Defined.

Remark rem_1679 : (forall X:term, auto___def_71 X -> auto_knows_current X)
    -> forall X1:term, auto___def_69 X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_71_pknows_current. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_1678 epsilon_m__def_71_pknows_current X1);  assumption.
  tauto.
Defined.

Remark rem_1680 : (forall X:term, auto___def_71 X -> auto_knows_current X)
    -> forall X1:term, auto___def_69 X1 -> auto_knows_current (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_71_pknows_current. intros X1. intros A1.
  case (rem_1679 epsilon_m__def_71_pknows_current X1 A1). clear  epsilon_m__def_71_pknows_current A1. intros. apply trans_knows_current_s_1;  tauto.
 clear  epsilon_m__def_71_pknows_current A1. tauto.
Defined.

Remark rem_1681 : forall X1:term, auto___def_71 (s X1) -> or_2
    (auto___def_71 X1)    (auto___def_69 X1).
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_1682 : (forall X:term, auto___def_71 X -> auto_knows_current X)
    -> forall X1:term, auto___def_71 (s X1) -> auto_knows_current (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_71_pknows_current. intros X1. intro H. intros.
  elim (rem_1681 X1 H);  intros.
  apply (rem_1642 epsilon_m__def_71_pknows_current X1);  tauto.
  apply (rem_1680 epsilon_m__def_71_pknows_current X1);  tauto.
Defined.

Remark rem_1683 : forall X1 X2:term, auto___def_71 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1684 : auto___def_71 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1685 : forall X1 X2 X3:term, auto___def_71 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1686 : auto___def_71 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1687 : auto___def_71 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1688 : auto___def_71 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1689 : forall X1 X2:term, auto___def_71 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1690 : forall X1 X2 X3:term, auto___def_71 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1691 : forall X1 X2 X3:term, auto___def_71 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1692 : forall X1 X2:term, auto___def_71 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1693 : forall X1 X2 X3:term, auto___def_71 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1694 : forall X1 X2:term, auto___def_71 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1695 : auto___def_71 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1696 : auto___def_71 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1697 : auto___def_71 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1698 : auto___def_71 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1699 : forall X2:term, auto___def_71 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__def_71_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_1686  H).
   intro H. elim (rem_1684  H).
  intros X1 X2. intro H. elim (rem_801 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1692 X1 X2 H).
   intro H. elim (rem_1688  H).
  intros X1 X2. intro H. elim (rem_1689 X1 X2 H).
   intro H. elim (rem_1687  H).
  intros X1 X2. intro H. elim (rem_1683 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1694 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1690 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1691 X1 X2 X3 H).
   intro H. elim (rem_1697  H).
   intro H. elim (rem_1695  H).
  intros X1;  exact (rem_1682 epsilon_m__def_71_pknows_current X1).
   intro H. elim (rem_1696  H).
  intros X1 X2 X3. intro H. elim (rem_1685 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1693 X1 X2 X3 H).
   intro H. elim (rem_1698  H).
Qed.

Remark rem_1700 : forall X1 X2:term, auto___def_71 X2 -> auto___type_13 (key pub X1) -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_71 X2 -> auto_knows_current X2). tauto. exact (rem_1699 X2).
Qed.

Remark rem_1701 : forall X1 X2:term, auto___def_71 X2 -> auto___type_13 (key pub X1) -> (auto___type_8 X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_8 X1). 2:apply (rem_1639 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1700 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1702 : forall X1 X2:term, auto___def_71 X2 -> auto___type_13 (key pub X1) -> auto___def_41 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1701 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_41_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1703 : forall X1 X2:term, auto___def_69 X2 -> auto___type_12 (key pub X1) -> auto___type_8 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_8_1. Qed.

Remark rem_1704 : forall X2:term, auto___def_69 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__def_69_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_1664  H).
   intro H. elim (rem_1662  H).
  intros X1 X2. intro H. elim (rem_803 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1670 X1 X2 H).
   intro H. elim (rem_1667  H).
  intros X1 X2. intro H. elim (rem_1668 X1 X2 H).
   intro H. elim (rem_1666  H).
  intros X1 X2. intro H. elim (rem_1661 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1672 X1 X2 H).
  intros X1 X2 X3;  exact (rem_1660 epsilon_m__def_69_pknows_current X1 X2 X3).
  intros X1 X2 X3. intro H. elim (rem_1669 X1 X2 X3 H).
   intro H. elim (rem_1675  H).
   intro H. elim (rem_1673  H).
  intros X1. intro H. elim (rem_1665 X1 H).
   intro H. elim (rem_1674  H).
  intros X1 X2 X3. intro H. elim (rem_1663 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1671 X1 X2 X3 H).
   intro H. elim (rem_1676  H).
Qed.

Remark rem_1705 : forall X1 X2:term, auto___def_69 X2 -> auto___type_12 (key pub X1) -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_69 X2 -> auto_knows_current X2). tauto. exact (rem_1704 X2).
Qed.

Remark rem_1706 : forall X1 X2:term, auto___def_69 X2 -> auto___type_12 (key pub X1) -> (auto___type_8 X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_8 X1). 2:apply (rem_1703 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1705 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1707 : forall X1 X2:term, auto___def_69 X2 -> auto___type_12 (key pub X1) -> auto___def_41 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1706 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_41_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1708 : forall X1 X2:term, auto___def_12 X2 -> auto___def_13 (key pub X1) -> auto___type_8 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_8_1. Qed.

Remark rem_1709 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pknows_current.  tauto.
Defined.

Remark rem_1710 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> auto_knows_current bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows_current.  case (rem_1709 epsilon_m__type_3_pknows_current). clear  epsilon_m__type_3_pknows_current. intros. apply trans_knows_current_bob_1;  tauto.
 clear  epsilon_m__type_3_pknows_current. tauto.
Defined.

Remark rem_1711 : auto___type_3 bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1712 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> auto___type_3 bob -> auto_knows_current bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intro H. intros.
  elim (rem_1711 H);  intros.
  apply (rem_1710 epsilon_m__type_3_pknows_current);  tauto.
Defined.

Remark rem_1713 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> auto_knows_current alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows_current.  case (rem_1709 epsilon_m__type_3_pknows_current). clear  epsilon_m__type_3_pknows_current. intros. apply trans_knows_current_alice_1;  tauto.
 clear  epsilon_m__type_3_pknows_current. tauto.
Defined.

Remark rem_1714 : auto___type_3 alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1715 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> auto___type_3 alice -> auto_knows_current alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intro H. intros.
  elim (rem_1714 H);  intros.
  apply (rem_1713 epsilon_m__type_3_pknows_current);  tauto.
Defined.

Remark rem_1716 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current.  tauto.
Defined.

Remark rem_1717 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_current bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current.  case (rem_1716 epsilon_mknows_old_pknows_current). clear  epsilon_mknows_old_pknows_current. intros. apply trans_knows_current_bob_1;  tauto.
 clear  epsilon_mknows_old_pknows_current. tauto.
Defined.

Remark rem_1718 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_old bob -> auto_knows_current bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intro H. intros.
  elim (rem_62 H);  intros.
  apply (rem_1717 epsilon_mknows_old_pknows_current);  tauto.
Defined.

Remark rem_1719 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_current alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current.  case (rem_1716 epsilon_mknows_old_pknows_current). clear  epsilon_mknows_old_pknows_current. intros. apply trans_knows_current_alice_1;  tauto.
 clear  epsilon_mknows_old_pknows_current. tauto.
Defined.

Remark rem_1720 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_old alice -> auto_knows_current alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intro H. intros.
  elim (rem_65 H);  intros.
  apply (rem_1719 epsilon_mknows_old_pknows_current);  tauto.
Defined.

Remark rem_1721 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_current X1. (* Use induction hypothesis. *)
Proof.
   intro Hrec. intros X1.
  cut (auto_knows_old X1 -> auto_knows_current X1). tauto. exact (Hrec X1).
Defined.

Remark rem_1722 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto_knows_old X1 -> auto_knows_current X1). tauto. exact (rem_1721 epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_1723 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto_knows_old X2 -> auto_knows_current X2. (* Use induction hypothesis. *)
Proof.
   intro Hrec. intros X2.
  cut (auto_knows_old X2 -> auto_knows_current X2). tauto. exact (Hrec X2).
Defined.

Remark rem_1724 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_current X2). tauto. exact (rem_1723 epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_1725 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_1722 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1724 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1726 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1725 epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_1727 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_73 X1 X2 H);  intros.
  apply (rem_1726 epsilon_mknows_old_pknows_current X1 X2);  tauto.
Defined.

Remark rem_1728 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_1721 epsilon_mknows_old_pknows_current X1);  assumption.
  tauto.
Defined.

Remark rem_1729 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_current (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1. intros A1.
  case (rem_1728 epsilon_mknows_old_pknows_current X1 A1). clear  epsilon_mknows_old_pknows_current A1. intros. apply trans_knows_current_s_1;  tauto.
 clear  epsilon_mknows_old_pknows_current A1. tauto.
Defined.

Remark rem_1730 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old (s X1) -> auto_knows_current (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1. intro H. intros.
  elim (rem_77 X1 H);  intros.
  apply (rem_1729 epsilon_mknows_old_pknows_current X1);  tauto.
Defined.

Remark rem_1731 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_current nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current.  case (rem_1716 epsilon_mknows_old_pknows_current). clear  epsilon_mknows_old_pknows_current. intros. apply trans_knows_current_nil_1;  tauto.
 clear  epsilon_mknows_old_pknows_current. tauto.
Defined.

Remark rem_1732 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_old nil -> auto_knows_current nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intro H. intros.
  elim (rem_80 H);  intros.
  apply (rem_1731 epsilon_mknows_old_pknows_current);  tauto.
Defined.

Remark rem_1733 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_current i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current.  case (rem_1716 epsilon_mknows_old_pknows_current). clear  epsilon_mknows_old_pknows_current. intros. apply trans_knows_current_i_1;  tauto.
 clear  epsilon_mknows_old_pknows_current. tauto.
Defined.

Remark rem_1734 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_old i -> auto_knows_current i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intro H. intros.
  elim (rem_83 H);  intros.
  apply (rem_1733 epsilon_mknows_old_pknows_current);  tauto.
Defined.

Remark rem_1735 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto___def_35 X1 -> auto___def_35 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1736 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___def_35 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_35 X1 -> auto___def_35 X1). tauto. exact (rem_1735 epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_1737 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1738 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_1737 epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_1739 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> (auto___def_35 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_35 X1). 2:apply (rem_1736 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_1738 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1740 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1739 epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_key_2;  tauto.
 clear  epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_1741 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto___def_36 X1 -> auto___def_36 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1742 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_36 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_36 X1 -> auto___def_36 X1). tauto. exact (rem_1741 epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_1743 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto___def_37 X2 -> auto___def_37 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1744 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_37 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_37 X2 -> auto___def_37 X2). tauto. exact (rem_1743 epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_1745 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> (auto___def_36 X1 /\ auto___def_37 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_36 X1). 2:apply (rem_1742 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto___def_37 X2). 2:apply (rem_1744 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1746 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1745 epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_key_3;  tauto.
 clear  epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_1747 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old (key X1 X2) -> auto_knows_current (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_97 X1 X2 H);  intros.
  apply (rem_1740 epsilon_mknows_old_pknows_current X1 X2);  tauto.
  apply (rem_1746 epsilon_mknows_old_pknows_current X1 X2);  tauto.
Defined.

Remark rem_1748 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto___def_12 X1 -> auto___def_12 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1749 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_12 X1). tauto. exact (rem_1748 epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_1750 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto___def_13 X2 -> auto___def_13 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1751 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_1750 epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_1752 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> (auto___def_12 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_12 X1). 2:apply (rem_1749 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_1751 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1753 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1752 epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_crypt_3;  tauto.
 clear  epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_1754 : (forall X:term, auto___def_32 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_32_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  tauto.
Defined.

Remark rem_1755 : (forall X:term, auto___def_32 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto_knows_current (nonceb_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_32_pknows_current. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_1754 epsilon_m__def_32_pknows_current X1 X2 X3 A1 A2 A3). clear  epsilon_m__def_32_pknows_current A1 A2 A3. intros. apply trans_knows_current_nonceb_old_1;  tauto.
 clear  epsilon_m__def_32_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_1756 : forall X1 X2 X3:term, auto___def_32 (nonceb_old X1 X2 X3) -> or_1
    (auto___def_16 X1 /\ auto___type_5 X2 /\ auto___type_4 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1757 : (forall X:term, auto___def_32 X -> auto_knows_current X)
    -> forall X1 X2 X3:term, auto___def_32 (nonceb_old X1 X2 X3) -> auto_knows_current (nonceb_old X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_32_pknows_current. intros X1 X2 X3. intro H. intros.
  elim (rem_1756 X1 X2 X3 H);  intros.
  apply (rem_1755 epsilon_m__def_32_pknows_current X1 X2 X3);  tauto.
Defined.

Remark rem_1758 : forall X1 X2:term, auto___def_32 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1759 : auto___def_32 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1760 : forall X1 X2 X3:term, auto___def_32 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1761 : auto___def_32 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1762 : forall X1:term, auto___def_32 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1763 : auto___def_32 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1764 : auto___def_32 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1765 : forall X1 X2:term, auto___def_32 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1766 : forall X1 X2 X3:term, auto___def_32 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1767 : forall X1 X2:term, auto___def_32 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1768 : forall X1 X2 X3:term, auto___def_32 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1769 : forall X1 X2:term, auto___def_32 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1770 : auto___def_32 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1771 : auto___def_32 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1772 : auto___def_32 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1773 : auto___def_32 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1774 : forall X1:term, auto___def_32 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_m__def_32_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_1761  H).
   intro H. elim (rem_1759  H).
  intros X1 X2. intro H. elim (rem_255 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1767 X1 X2 H).
   intro H. elim (rem_1764  H).
  intros X1 X2. intro H. elim (rem_1765 X1 X2 H).
   intro H. elim (rem_1763  H).
  intros X1 X2. intro H. elim (rem_1758 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1769 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1766 X1 X2 X3 H).
  intros X1 X2 X3;  exact (rem_1757 epsilon_m__def_32_pknows_current X1 X2 X3).
   intro H. elim (rem_1772  H).
   intro H. elim (rem_1770  H).
  intros X1. intro H. elim (rem_1762 X1 H).
   intro H. elim (rem_1771  H).
  intros X1 X2 X3. intro H. elim (rem_1760 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1768 X1 X2 X3 H).
   intro H. elim (rem_1773  H).
Qed.

Remark rem_1775 : (forall X:term, auto___def_34 X -> auto_knows_current X)
    -> forall X1:term, auto___def_32 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__def_34_pknows_current. exact (rem_1774).
Defined.

Remark rem_1776 : (forall X:term, auto___def_34 X -> auto_knows_current X)
    -> forall X1:term, auto___def_32 X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_34_pknows_current. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_1775 epsilon_m__def_34_pknows_current X1);  assumption.
  tauto.
Defined.

Remark rem_1777 : (forall X:term, auto___def_34 X -> auto_knows_current X)
    -> forall X1:term, auto___def_32 X1 -> auto_knows_current (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_34_pknows_current. intros X1. intros A1.
  case (rem_1776 epsilon_m__def_34_pknows_current X1 A1). clear  epsilon_m__def_34_pknows_current A1. intros. apply trans_knows_current_s_1;  tauto.
 clear  epsilon_m__def_34_pknows_current A1. tauto.
Defined.

Remark rem_1778 : (forall X:term, auto___def_34 X -> auto_knows_current X)
    -> forall X1:term, auto___def_34 X1 -> auto_knows_current X1. (* Use induction hypothesis. *)
Proof.
   intro Hrec. intros X1.
  cut (auto___def_34 X1 -> auto_knows_current X1). tauto. exact (Hrec X1).
Defined.

Remark rem_1779 : (forall X:term, auto___def_34 X -> auto_knows_current X)
    -> forall X1:term, auto___def_34 X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_34_pknows_current. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_1778 epsilon_m__def_34_pknows_current X1);  assumption.
  tauto.
Defined.

Remark rem_1780 : (forall X:term, auto___def_34 X -> auto_knows_current X)
    -> forall X1:term, auto___def_34 X1 -> auto_knows_current (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_34_pknows_current. intros X1. intros A1.
  case (rem_1779 epsilon_m__def_34_pknows_current X1 A1). clear  epsilon_m__def_34_pknows_current A1. intros. apply trans_knows_current_s_1;  tauto.
 clear  epsilon_m__def_34_pknows_current A1. tauto.
Defined.

Remark rem_1781 : forall X1:term, auto___def_34 (s X1) -> or_2
    (auto___def_32 X1)    (auto___def_34 X1).
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_1782 : (forall X:term, auto___def_34 X -> auto_knows_current X)
    -> forall X1:term, auto___def_34 (s X1) -> auto_knows_current (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_34_pknows_current. intros X1. intro H. intros.
  elim (rem_1781 X1 H);  intros.
  apply (rem_1777 epsilon_m__def_34_pknows_current X1);  tauto.
  apply (rem_1780 epsilon_m__def_34_pknows_current X1);  tauto.
Defined.

Remark rem_1783 : forall X1 X2:term, auto___def_34 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1784 : auto___def_34 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1785 : forall X1 X2 X3:term, auto___def_34 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1786 : auto___def_34 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1787 : auto___def_34 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1788 : auto___def_34 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1789 : forall X1 X2:term, auto___def_34 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1790 : forall X1 X2 X3:term, auto___def_34 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1791 : forall X1 X2 X3:term, auto___def_34 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1792 : forall X1 X2:term, auto___def_34 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1793 : forall X1 X2 X3:term, auto___def_34 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1794 : forall X1 X2:term, auto___def_34 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1795 : auto___def_34 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1796 : auto___def_34 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1797 : auto___def_34 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1798 : auto___def_34 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1799 : forall X1:term, auto___def_34 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_m__def_34_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_1786  H).
   intro H. elim (rem_1784  H).
  intros X1 X2. intro H. elim (rem_233 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1792 X1 X2 H).
   intro H. elim (rem_1788  H).
  intros X1 X2. intro H. elim (rem_1789 X1 X2 H).
   intro H. elim (rem_1787  H).
  intros X1 X2. intro H. elim (rem_1783 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1794 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1790 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1791 X1 X2 X3 H).
   intro H. elim (rem_1797  H).
   intro H. elim (rem_1795  H).
  intros X1;  exact (rem_1782 epsilon_m__def_34_pknows_current X1).
   intro H. elim (rem_1796  H).
  intros X1 X2 X3. intro H. elim (rem_1785 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1793 X1 X2 X3 H).
   intro H. elim (rem_1798  H).
Qed.

Remark rem_1800 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto___def_34 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_mknows_old_pknows_current. exact (rem_1799).
Defined.

Remark rem_1801 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_34 X1 -> auto_knows_current X1). tauto. exact (rem_1800 epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_1802 : (forall X:term, auto___def_18 X -> auto___def_39 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_18_p__def_39.  tauto.
Defined.

Remark rem_1803 : (forall X:term, auto___def_18 X -> auto___def_39 X)
    -> auto___def_39 sym. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_18_p__def_39.  case (rem_1802 epsilon_m__def_18_p__def_39). clear  epsilon_m__def_18_p__def_39. intros. apply trans___def_39_sym_1;  tauto.
 clear  epsilon_m__def_18_p__def_39. tauto.
Defined.

Remark rem_1804 : (forall X:term, auto___def_18 X -> auto___def_39 X)
    -> auto___def_18 sym -> auto___def_39 sym. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_18_p__def_39. intro H. intros.
  elim (rem_1172 H);  intros.
  apply (rem_1803 epsilon_m__def_18_p__def_39);  tauto.
Defined.

Remark rem_1805 : forall X1:term, auto___def_18 X1 -> auto___def_39 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_18_p__def_39 1.
  intro X. case X.
   intro H. elim (rem_1177  H).
   intro H. elim (rem_1175  H).
  intros X1 X2. intro H. elim (rem_1178 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1185 X1 X2 H).
   intro H. elim (rem_1181  H).
  intros X1 X2. intro H. elim (rem_1182 X1 X2 H).
   intro H. elim (rem_1180  H).
  intros X1 X2. intro H. elim (rem_1174 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1187 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1183 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1184 X1 X2 X3 H).
   intro H. elim (rem_163  H).
   intro H. elim (rem_1188  H).
  intros X1. intro H. elim (rem_1179 X1 H).
   intro H. elim (rem_1189  H).
  intros X1 X2 X3. intro H. elim (rem_1176 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1186 X1 X2 X3 H).
  exact (rem_1804 epsilon_m__def_18_p__def_39 ).
Qed.

Remark rem_1806 : (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> forall X1:term, auto___def_18 X1 -> auto___def_39 X1. (* Cut history. *)
Proof.  intros epsilon_m__type_7_pknows_current. exact (rem_1805).
Defined.

Remark rem_1807 : (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_39 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_7_pknows_current. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_39 X1). tauto. exact (rem_1806 epsilon_m__type_7_pknows_current X1).
Defined.

Remark rem_1808 : (forall X:term, auto___def_19 X -> auto___def_40 X)
    -> forall X1 X2 X3:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X3 -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_19_p__def_40. intros X1 X2 X3. intros A1 A2 A3.
  tauto.
Defined.

Remark rem_1809 : (forall X:term, auto___def_19 X -> auto___def_40 X)
    -> forall X1 X2 X3:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_40 (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_19_p__def_40. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_1808 epsilon_m__def_19_p__def_40 X1 X2 X3 A1 A2 A3). clear  epsilon_m__def_19_p__def_40 A1 A2 A3. intros. apply trans___def_40_session_old_1;  tauto.
 clear  epsilon_m__def_19_p__def_40 A1 A2 A3. tauto.
Defined.

Remark rem_1810 : (forall X:term, auto___def_19 X -> auto___def_40 X)
    -> forall X1 X2 X3:term, auto___def_19 (session_old X1 X2 X3) -> auto___def_40 (session_old X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_19_p__def_40. intros X1 X2 X3. intro H. intros.
  elim (rem_1072 X1 X2 X3 H);  intros.
  apply (rem_1809 epsilon_m__def_19_p__def_40 X1 X2 X3);  tauto.
Defined.

Remark rem_1811 : forall X2:term, auto___def_19 X2 -> auto___def_40 X2. (* Induct. *)
Proof.
  fix epsilon_m__def_19_p__def_40 1.
  intro X. case X.
   intro H. elim (rem_1077  H).
   intro H. elim (rem_1075  H).
  intros X1 X2. intro H. elim (rem_1078 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1085 X1 X2 H).
   intro H. elim (rem_1081  H).
  intros X1 X2. intro H. elim (rem_1082 X1 X2 H).
   intro H. elim (rem_1080  H).
  intros X1 X2. intro H. elim (rem_1074 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1086 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1083 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1084 X1 X2 X3 H).
   intro H. elim (rem_1089  H).
   intro H. elim (rem_1087  H).
  intros X1. intro H. elim (rem_1079 X1 H).
   intro H. elim (rem_1088  H).
  intros X1 X2 X3. intro H. elim (rem_1076 X1 X2 X3 H).
  intros X1 X2 X3;  exact (rem_1810 epsilon_m__def_19_p__def_40 X1 X2 X3).
   intro H. elim (rem_1090  H).
Qed.

Remark rem_1812 : (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> forall X2:term, auto___def_19 X2 -> auto___def_40 X2. (* Cut history. *)
Proof.  intros epsilon_m__type_7_pknows_current. exact (rem_1811).
Defined.

Remark rem_1813 : (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_40 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_7_pknows_current. intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_40 X2). tauto. exact (rem_1812 epsilon_m__type_7_pknows_current X2).
Defined.

Remark rem_1814 : (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> (auto___def_39 X1 /\ auto___def_40 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_7_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_39 X1). 2:apply (rem_1807 epsilon_m__type_7_pknows_current X1 X2);  assumption.
  cut (auto___def_40 X2). 2:apply (rem_1813 epsilon_m__type_7_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1815 : (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_7_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1814 epsilon_m__type_7_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_7_pknows_current A1 A2. intros. apply trans_knows_current_key_1;  tauto.
 clear  epsilon_m__type_7_pknows_current A1 A2. tauto.
Defined.

Remark rem_1816 : (forall X:term, auto___type_7 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_7 (key X1 X2) -> auto_knows_current (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_7_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_170 X1 X2 H);  intros.
  apply (rem_1815 epsilon_m__type_7_pknows_current X1 X2);  tauto.
Defined.

Remark rem_1817 : forall X1 X2:term, auto___type_7 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1818 : auto___type_7 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1819 : forall X1 X2 X3:term, auto___type_7 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1820 : auto___type_7 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1821 : forall X1 X2:term, auto___type_7 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1822 : forall X1:term, auto___type_7 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1823 : auto___type_7 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1824 : auto___type_7 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1825 : forall X1 X2 X3:term, auto___type_7 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1826 : forall X1 X2 X3:term, auto___type_7 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1827 : forall X1 X2:term, auto___type_7 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1828 : forall X1 X2 X3:term, auto___type_7 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1829 : forall X1 X2:term, auto___type_7 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1830 : auto___type_7 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1831 : auto___type_7 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1832 : auto___type_7 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1833 : auto___type_7 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1834 : forall X2:term, auto___type_7 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__type_7_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_1820  H).
   intro H. elim (rem_1818  H).
  intros X1 X2. intro H. elim (rem_1821 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1827 X1 X2 H).
   intro H. elim (rem_1824  H).
  intros X1 X2;  exact (rem_1816 epsilon_m__type_7_pknows_current X1 X2).
   intro H. elim (rem_1823  H).
  intros X1 X2. intro H. elim (rem_1817 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1829 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1825 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1826 X1 X2 X3 H).
   intro H. elim (rem_1832  H).
   intro H. elim (rem_1830  H).
  intros X1. intro H. elim (rem_1822 X1 H).
   intro H. elim (rem_1831  H).
  intros X1 X2 X3. intro H. elim (rem_1819 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1828 X1 X2 X3 H).
   intro H. elim (rem_1833  H).
Qed.

Remark rem_1835 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto___type_7 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_mknows_old_pknows_current. exact (rem_1834).
Defined.

Remark rem_1836 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___type_7 X2 -> auto_knows_current X2). tauto. exact (rem_1835 epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_1837 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_1801 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1836 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1838 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1837 epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_crypt_7;  tauto.
 clear  epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_1839 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto___def_22 X1 -> auto___def_22 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1840 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_22 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_22 X1 -> auto___def_22 X1). tauto. exact (rem_1839 epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_1841 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto___def_23 X2 -> auto___def_23 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1842 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_1841 epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_1843 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> (auto___def_22 X1 /\ auto___def_23 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_22 X1). 2:apply (rem_1840 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_1842 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1844 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1843 epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_crypt_5;  tauto.
 clear  epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_1845 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1725 epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_crypt_7;  tauto.
 clear  epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_1846 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto___def_32 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_mknows_old_pknows_current. exact (rem_1774).
Defined.

Remark rem_1847 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_32 X1 -> auto_knows_current X1). tauto. exact (rem_1846 epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_1848 : (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> forall X1:term, auto___def_18 X1 -> auto___def_39 X1. (* Cut history. *)
Proof.  intros epsilon_m__type_6_pknows_current. exact (rem_1805).
Defined.

Remark rem_1849 : (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_39 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_pknows_current. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_39 X1). tauto. exact (rem_1848 epsilon_m__type_6_pknows_current X1).
Defined.

Remark rem_1850 : (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> forall X2:term, auto___def_19 X2 -> auto___def_40 X2. (* Cut history. *)
Proof.  intros epsilon_m__type_6_pknows_current. exact (rem_1811).
Defined.

Remark rem_1851 : (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_40 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_pknows_current. intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_40 X2). tauto. exact (rem_1850 epsilon_m__type_6_pknows_current X2).
Defined.

Remark rem_1852 : (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> (auto___def_39 X1 /\ auto___def_40 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_6_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_39 X1). 2:apply (rem_1849 epsilon_m__type_6_pknows_current X1 X2);  assumption.
  cut (auto___def_40 X2). 2:apply (rem_1851 epsilon_m__type_6_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1853 : (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1852 epsilon_m__type_6_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_6_pknows_current A1 A2. intros. apply trans_knows_current_key_1;  tauto.
 clear  epsilon_m__type_6_pknows_current A1 A2. tauto.
Defined.

Remark rem_1854 : (forall X:term, auto___type_6 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_6 (key X1 X2) -> auto_knows_current (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_187 X1 X2 H);  intros.
  apply (rem_1853 epsilon_m__type_6_pknows_current X1 X2);  tauto.
Defined.

Remark rem_1855 : forall X1 X2:term, auto___type_6 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1856 : auto___type_6 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1857 : forall X1 X2 X3:term, auto___type_6 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1858 : auto___type_6 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1859 : forall X1 X2:term, auto___type_6 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1860 : forall X1:term, auto___type_6 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1861 : auto___type_6 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1862 : auto___type_6 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1863 : forall X1 X2 X3:term, auto___type_6 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1864 : forall X1 X2 X3:term, auto___type_6 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1865 : forall X1 X2:term, auto___type_6 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1866 : forall X1 X2 X3:term, auto___type_6 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1867 : forall X1 X2:term, auto___type_6 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1868 : auto___type_6 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1869 : auto___type_6 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1870 : auto___type_6 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1871 : auto___type_6 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1872 : forall X2:term, auto___type_6 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__type_6_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_1858  H).
   intro H. elim (rem_1856  H).
  intros X1 X2. intro H. elim (rem_1859 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1865 X1 X2 H).
   intro H. elim (rem_1862  H).
  intros X1 X2;  exact (rem_1854 epsilon_m__type_6_pknows_current X1 X2).
   intro H. elim (rem_1861  H).
  intros X1 X2. intro H. elim (rem_1855 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1867 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1863 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1864 X1 X2 X3 H).
   intro H. elim (rem_1870  H).
   intro H. elim (rem_1868  H).
  intros X1. intro H. elim (rem_1860 X1 H).
   intro H. elim (rem_1869  H).
  intros X1 X2 X3. intro H. elim (rem_1857 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1866 X1 X2 X3 H).
   intro H. elim (rem_1871  H).
Qed.

Remark rem_1873 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto___type_6 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_mknows_old_pknows_current. exact (rem_1872).
Defined.

Remark rem_1874 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___type_6 X2 -> auto_knows_current X2). tauto. exact (rem_1873 epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_1875 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_1847 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1874 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1876 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1875 epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_crypt_7;  tauto.
 clear  epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_1877 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old (crypt X1 X2) -> auto_knows_current (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_124 X1 X2 H);  intros.
  apply (rem_1753 epsilon_mknows_old_pknows_current X1 X2);  tauto.
  apply (rem_1838 epsilon_mknows_old_pknows_current X1 X2);  tauto.
  apply (rem_1844 epsilon_mknows_old_pknows_current X1 X2);  tauto.
  apply (rem_1845 epsilon_mknows_old_pknows_current X1 X2);  tauto.
  apply (rem_1876 epsilon_mknows_old_pknows_current X1 X2);  tauto.
Defined.

Remark rem_1878 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  tauto.
Defined.

Remark rem_1879 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_knows_current (noncea_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1878 epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_noncea_old_1;  tauto.
 clear  epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_1880 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old (noncea_old X1 X2) -> auto_knows_current (noncea_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_132 X1 X2 H);  intros.
  apply (rem_1879 epsilon_mknows_old_pknows_current X1 X2);  tauto.
Defined.

Remark rem_1881 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_current server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current.  case (rem_1716 epsilon_mknows_old_pknows_current). clear  epsilon_mknows_old_pknows_current. intros. apply trans_knows_current_server_1;  tauto.
 clear  epsilon_mknows_old_pknows_current. tauto.
Defined.

Remark rem_1882 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_old server -> auto_knows_current server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intro H. intros.
  elim (rem_135 H);  intros.
  apply (rem_1881 epsilon_mknows_old_pknows_current);  tauto.
Defined.

Remark rem_1883 : forall X1:term, auto_knows_old X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_mknows_old_pknows_current 1.
  intro X. case X.
  exact (rem_1720 epsilon_mknows_old_pknows_current ).
  exact (rem_1718 epsilon_mknows_old_pknows_current ).
  intros X1 X2;  exact (rem_1727 epsilon_mknows_old_pknows_current X1 X2).
  intros X1 X2;  exact (rem_1877 epsilon_mknows_old_pknows_current X1 X2).
  exact (rem_1734 epsilon_mknows_old_pknows_current ).
  intros X1 X2;  exact (rem_1747 epsilon_mknows_old_pknows_current X1 X2).
  exact (rem_1732 epsilon_mknows_old_pknows_current ).
  intros X1 X2. intro H. elim (rem_137 X1 X2 H).
  intros X1 X2;  exact (rem_1880 epsilon_mknows_old_pknows_current X1 X2).
  intros X1 X2 X3. intro H. elim (rem_139 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_140 X1 X2 X3 H).
   intro H. elim (rem_143  H).
   intro H. elim (rem_142  H).
  intros X1;  exact (rem_1730 epsilon_mknows_old_pknows_current X1).
  exact (rem_1882 epsilon_mknows_old_pknows_current ).
  intros X1 X2 X3. intro H. elim (rem_138 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_141 X1 X2 X3 H).
   intro H. elim (rem_144  H).
Qed.

Remark rem_1884 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__type_3_pknows_current. exact (rem_1883).
Defined.

Remark rem_1885 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2.
  cut (auto_knows_old X1 -> auto_knows_current X1). tauto. exact (rem_1884 epsilon_m__type_3_pknows_current X1).
Defined.

Remark rem_1886 : forall X2:term, auto_knows_old X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_mknows_old_pknows_current 1.
  intro X. case X.
  exact (rem_1720 epsilon_mknows_old_pknows_current ).
  exact (rem_1718 epsilon_mknows_old_pknows_current ).
  intros X1 X2;  exact (rem_1727 epsilon_mknows_old_pknows_current X1 X2).
  intros X1 X2;  exact (rem_1877 epsilon_mknows_old_pknows_current X1 X2).
  exact (rem_1734 epsilon_mknows_old_pknows_current ).
  intros X1 X2;  exact (rem_1747 epsilon_mknows_old_pknows_current X1 X2).
  exact (rem_1732 epsilon_mknows_old_pknows_current ).
  intros X1 X2. intro H. elim (rem_137 X1 X2 H).
  intros X1 X2;  exact (rem_1880 epsilon_mknows_old_pknows_current X1 X2).
  intros X1 X2 X3. intro H. elim (rem_139 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_140 X1 X2 X3 H).
   intro H. elim (rem_143  H).
   intro H. elim (rem_142  H).
  intros X1;  exact (rem_1730 epsilon_mknows_old_pknows_current X1).
  exact (rem_1882 epsilon_mknows_old_pknows_current ).
  intros X1 X2 X3. intro H. elim (rem_138 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_141 X1 X2 X3 H).
   intro H. elim (rem_144  H).
Qed.

Remark rem_1887 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X2:term, auto_knows_old X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_m__type_3_pknows_current. exact (rem_1886).
Defined.

Remark rem_1888 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_current X2). tauto. exact (rem_1887 epsilon_m__type_3_pknows_current X2).
Defined.

Remark rem_1889 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_1885 epsilon_m__type_3_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1888 epsilon_m__type_3_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1890 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1889 epsilon_m__type_3_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_3_pknows_current A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  epsilon_m__type_3_pknows_current A1 A2. tauto.
Defined.

Remark rem_1891 : forall X1 X2:term, auto___type_3 (cons X1 X2) -> or_1
    (auto_knows_old X1 /\ auto_knows_old X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1892 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_3 (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_1891 X1 X2 H);  intros.
  apply (rem_1890 epsilon_m__type_3_pknows_current X1 X2);  tauto.
Defined.

Remark rem_1893 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_1884 epsilon_m__type_3_pknows_current X1);  assumption.
  tauto.
Defined.

Remark rem_1894 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_current (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1. intros A1.
  case (rem_1893 epsilon_m__type_3_pknows_current X1 A1). clear  epsilon_m__type_3_pknows_current A1. intros. apply trans_knows_current_s_1;  tauto.
 clear  epsilon_m__type_3_pknows_current A1. tauto.
Defined.

Remark rem_1895 : forall X1:term, auto___type_3 (s X1) -> or_1
    (auto_knows_old X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1896 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1:term, auto___type_3 (s X1) -> auto_knows_current (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1. intro H. intros.
  elim (rem_1895 X1 H);  intros.
  apply (rem_1894 epsilon_m__type_3_pknows_current X1);  tauto.
Defined.

Remark rem_1897 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> auto_knows_current nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows_current.  case (rem_1709 epsilon_m__type_3_pknows_current). clear  epsilon_m__type_3_pknows_current. intros. apply trans_knows_current_nil_1;  tauto.
 clear  epsilon_m__type_3_pknows_current. tauto.
Defined.

Remark rem_1898 : auto___type_3 nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1899 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> auto___type_3 nil -> auto_knows_current nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intro H. intros.
  elim (rem_1898 H);  intros.
  apply (rem_1897 epsilon_m__type_3_pknows_current);  tauto.
Defined.

Remark rem_1900 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> auto_knows_current i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows_current.  case (rem_1709 epsilon_m__type_3_pknows_current). clear  epsilon_m__type_3_pknows_current. intros. apply trans_knows_current_i_1;  tauto.
 clear  epsilon_m__type_3_pknows_current. tauto.
Defined.

Remark rem_1901 : auto___type_3 i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1902 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> auto___type_3 i -> auto_knows_current i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intro H. intros.
  elim (rem_1901 H);  intros.
  apply (rem_1900 epsilon_m__type_3_pknows_current);  tauto.
Defined.

Remark rem_1903 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1:term, auto___def_35 X1 -> auto___def_35 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1904 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___def_35 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2.
  cut (auto___def_35 X1 -> auto___def_35 X1). tauto. exact (rem_1903 epsilon_m__type_3_pknows_current X1).
Defined.

Remark rem_1905 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1906 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_1905 epsilon_m__type_3_pknows_current X2).
Defined.

Remark rem_1907 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> (auto___def_35 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_35 X1). 2:apply (rem_1904 epsilon_m__type_3_pknows_current X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_1906 epsilon_m__type_3_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1908 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1907 epsilon_m__type_3_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_3_pknows_current A1 A2. intros. apply trans_knows_current_key_2;  tauto.
 clear  epsilon_m__type_3_pknows_current A1 A2. tauto.
Defined.

Remark rem_1909 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1:term, auto___def_36 X1 -> auto___def_36 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1910 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_36 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2.
  cut (auto___def_36 X1 -> auto___def_36 X1). tauto. exact (rem_1909 epsilon_m__type_3_pknows_current X1).
Defined.

Remark rem_1911 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X2:term, auto___def_37 X2 -> auto___def_37 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1912 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_37 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2.
  cut (auto___def_37 X2 -> auto___def_37 X2). tauto. exact (rem_1911 epsilon_m__type_3_pknows_current X2).
Defined.

Remark rem_1913 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> (auto___def_36 X1 /\ auto___def_37 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_36 X1). 2:apply (rem_1910 epsilon_m__type_3_pknows_current X1 X2);  assumption.
  cut (auto___def_37 X2). 2:apply (rem_1912 epsilon_m__type_3_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1914 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1913 epsilon_m__type_3_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_3_pknows_current A1 A2. intros. apply trans_knows_current_key_3;  tauto.
 clear  epsilon_m__type_3_pknows_current A1 A2. tauto.
Defined.

Remark rem_1915 : forall X1 X2:term, auto___type_3 (key X1 X2) -> or_2
    (auto___def_35 X1 /\ auto___type_8 X2)
    (auto___def_36 X1 /\ auto___def_37 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_1916 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_3 (key X1 X2) -> auto_knows_current (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_1915 X1 X2 H);  intros.
  apply (rem_1908 epsilon_m__type_3_pknows_current X1 X2);  tauto.
  apply (rem_1914 epsilon_m__type_3_pknows_current X1 X2);  tauto.
Defined.

Remark rem_1917 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1:term, auto___def_12 X1 -> auto___def_12 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1918 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_12 X1). tauto. exact (rem_1917 epsilon_m__type_3_pknows_current X1).
Defined.

Remark rem_1919 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X2:term, auto___def_13 X2 -> auto___def_13 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1920 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_1919 epsilon_m__type_3_pknows_current X2).
Defined.

Remark rem_1921 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> (auto___def_12 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_12 X1). 2:apply (rem_1918 epsilon_m__type_3_pknows_current X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_1920 epsilon_m__type_3_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1922 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1921 epsilon_m__type_3_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_3_pknows_current A1 A2. intros. apply trans_knows_current_crypt_3;  tauto.
 clear  epsilon_m__type_3_pknows_current A1 A2. tauto.
Defined.

Remark rem_1923 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1:term, auto___def_34 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__type_3_pknows_current. exact (rem_1799).
Defined.

Remark rem_1924 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2.
  cut (auto___def_34 X1 -> auto_knows_current X1). tauto. exact (rem_1923 epsilon_m__type_3_pknows_current X1).
Defined.

Remark rem_1925 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X2:term, auto___type_7 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_m__type_3_pknows_current. exact (rem_1834).
Defined.

Remark rem_1926 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2.
  cut (auto___type_7 X2 -> auto_knows_current X2). tauto. exact (rem_1925 epsilon_m__type_3_pknows_current X2).
Defined.

Remark rem_1927 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_1924 epsilon_m__type_3_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1926 epsilon_m__type_3_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1928 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1927 epsilon_m__type_3_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_3_pknows_current A1 A2. intros. apply trans_knows_current_crypt_7;  tauto.
 clear  epsilon_m__type_3_pknows_current A1 A2. tauto.
Defined.

Remark rem_1929 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1:term, auto___def_22 X1 -> auto___def_22 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1930 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_22 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2.
  cut (auto___def_22 X1 -> auto___def_22 X1). tauto. exact (rem_1929 epsilon_m__type_3_pknows_current X1).
Defined.

Remark rem_1931 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X2:term, auto___def_23 X2 -> auto___def_23 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1932 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_1931 epsilon_m__type_3_pknows_current X2).
Defined.

Remark rem_1933 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> (auto___def_22 X1 /\ auto___def_23 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_22 X1). 2:apply (rem_1930 epsilon_m__type_3_pknows_current X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_1932 epsilon_m__type_3_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1934 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1933 epsilon_m__type_3_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_3_pknows_current A1 A2. intros. apply trans_knows_current_crypt_5;  tauto.
 clear  epsilon_m__type_3_pknows_current A1 A2. tauto.
Defined.

Remark rem_1935 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1889 epsilon_m__type_3_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_3_pknows_current A1 A2. intros. apply trans_knows_current_crypt_7;  tauto.
 clear  epsilon_m__type_3_pknows_current A1 A2. tauto.
Defined.

Remark rem_1936 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1:term, auto___def_32 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__type_3_pknows_current. exact (rem_1774).
Defined.

Remark rem_1937 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2.
  cut (auto___def_32 X1 -> auto_knows_current X1). tauto. exact (rem_1936 epsilon_m__type_3_pknows_current X1).
Defined.

Remark rem_1938 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X2:term, auto___type_6 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_m__type_3_pknows_current. exact (rem_1872).
Defined.

Remark rem_1939 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2.
  cut (auto___type_6 X2 -> auto_knows_current X2). tauto. exact (rem_1938 epsilon_m__type_3_pknows_current X2).
Defined.

Remark rem_1940 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_1937 epsilon_m__type_3_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1939 epsilon_m__type_3_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1941 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1940 epsilon_m__type_3_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_3_pknows_current A1 A2. intros. apply trans_knows_current_crypt_7;  tauto.
 clear  epsilon_m__type_3_pknows_current A1 A2. tauto.
Defined.

Remark rem_1942 : forall X1 X2:term, auto___type_3 (crypt X1 X2) -> or_5
    (auto___def_12 X1 /\ auto___def_13 X2)
    (auto___def_34 X1 /\ auto___type_7 X2)
    (auto___def_22 X1 /\ auto___def_23 X2)
    (auto_knows_old X1 /\ auto_knows_old X2)
    (auto___def_32 X1 /\ auto___type_6 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_5_intro_1; tauto.
  intros. apply or_5_intro_2; tauto.
  intros. apply or_5_intro_3; tauto.
  intros. apply or_5_intro_4; tauto.
  intros. apply or_5_intro_5; tauto.
Qed.

Remark rem_1943 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_3 (crypt X1 X2) -> auto_knows_current (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_1942 X1 X2 H);  intros.
  apply (rem_1922 epsilon_m__type_3_pknows_current X1 X2);  tauto.
  apply (rem_1928 epsilon_m__type_3_pknows_current X1 X2);  tauto.
  apply (rem_1934 epsilon_m__type_3_pknows_current X1 X2);  tauto.
  apply (rem_1935 epsilon_m__type_3_pknows_current X1 X2);  tauto.
  apply (rem_1941 epsilon_m__type_3_pknows_current X1 X2);  tauto.
Defined.

Remark rem_1944 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2. intros A1 A2.
  tauto.
Defined.

Remark rem_1945 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_knows_current (noncea_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1944 epsilon_m__type_3_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_3_pknows_current A1 A2. intros. apply trans_knows_current_noncea_old_1;  tauto.
 clear  epsilon_m__type_3_pknows_current A1 A2. tauto.
Defined.

Remark rem_1946 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_3 (noncea_old X1 X2) -> auto_knows_current (noncea_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_212 X1 X2 H);  intros.
  apply (rem_1945 epsilon_m__type_3_pknows_current X1 X2);  tauto.
Defined.

Remark rem_1947 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> auto_knows_current server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows_current.  case (rem_1709 epsilon_m__type_3_pknows_current). clear  epsilon_m__type_3_pknows_current. intros. apply trans_knows_current_server_1;  tauto.
 clear  epsilon_m__type_3_pknows_current. tauto.
Defined.

Remark rem_1948 : auto___type_3 server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1949 : (forall X:term, auto___type_3 X -> auto_knows_current X)
    -> auto___type_3 server -> auto_knows_current server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows_current. intro H. intros.
  elim (rem_1948 H);  intros.
  apply (rem_1947 epsilon_m__type_3_pknows_current);  tauto.
Defined.

Remark rem_1950 : forall X1 X2 X3:term, auto___type_3 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1951 : forall X1 X2 X3:term, auto___type_3 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1952 : forall X1 X2 X3:term, auto___type_3 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1953 : forall X1 X2 X3:term, auto___type_3 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1954 : auto___type_3 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1955 : auto___type_3 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1956 : auto___type_3 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1957 : forall X1:term, auto___type_3 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_m__type_3_pknows_current 1.
  intro X. case X.
  exact (rem_1715 epsilon_m__type_3_pknows_current ).
  exact (rem_1712 epsilon_m__type_3_pknows_current ).
  intros X1 X2;  exact (rem_1892 epsilon_m__type_3_pknows_current X1 X2).
  intros X1 X2;  exact (rem_1943 epsilon_m__type_3_pknows_current X1 X2).
  exact (rem_1902 epsilon_m__type_3_pknows_current ).
  intros X1 X2;  exact (rem_1916 epsilon_m__type_3_pknows_current X1 X2).
  exact (rem_1899 epsilon_m__type_3_pknows_current ).
  intros X1 X2. intro H. elim (rem_805 X1 X2 H).
  intros X1 X2;  exact (rem_1946 epsilon_m__type_3_pknows_current X1 X2).
  intros X1 X2 X3. intro H. elim (rem_1951 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1952 X1 X2 X3 H).
   intro H. elim (rem_1955  H).
   intro H. elim (rem_1954  H).
  intros X1;  exact (rem_1896 epsilon_m__type_3_pknows_current X1).
  exact (rem_1949 epsilon_m__type_3_pknows_current ).
  intros X1 X2 X3. intro H. elim (rem_1950 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1953 X1 X2 X3 H).
   intro H. elim (rem_1956  H).
Qed.

Remark rem_1958 : (forall X:term, auto___def_12 X -> auto_knows_current X)
    -> forall X1:term, auto___type_3 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__def_12_pknows_current. exact (rem_1957).
Defined.

Remark rem_1959 : (forall X:term, auto___def_12 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_3 X1 -> auto___def_14 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_12_pknows_current. intros X1 X2.
  cut (auto___type_3 X1 -> auto_knows_current X1). tauto. exact (rem_1958 epsilon_m__def_12_pknows_current X1).
Defined.

Remark rem_1960 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows_current.  tauto.
Defined.

Remark rem_1961 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> auto_knows_current bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current.  case (rem_1960 epsilon_m__type_4_pknows_current). clear  epsilon_m__type_4_pknows_current. intros. apply trans_knows_current_bob_1;  tauto.
 clear  epsilon_m__type_4_pknows_current. tauto.
Defined.

Remark rem_1962 : auto___type_4 bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1963 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> auto___type_4 bob -> auto_knows_current bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intro H. intros.
  elim (rem_1962 H);  intros.
  apply (rem_1961 epsilon_m__type_4_pknows_current);  tauto.
Defined.

Remark rem_1964 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> auto_knows_current alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current.  case (rem_1960 epsilon_m__type_4_pknows_current). clear  epsilon_m__type_4_pknows_current. intros. apply trans_knows_current_alice_1;  tauto.
 clear  epsilon_m__type_4_pknows_current. tauto.
Defined.

Remark rem_1965 : auto___type_4 alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1966 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> auto___type_4 alice -> auto_knows_current alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intro H. intros.
  elim (rem_1965 H);  intros.
  apply (rem_1964 epsilon_m__type_4_pknows_current);  tauto.
Defined.

Remark rem_1967 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__type_4_pknows_current. exact (rem_1883).
Defined.

Remark rem_1968 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2.
  cut (auto_knows_old X1 -> auto_knows_current X1). tauto. exact (rem_1967 epsilon_m__type_4_pknows_current X1).
Defined.

Remark rem_1969 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X2:term, auto_knows_old X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_m__type_4_pknows_current. exact (rem_1886).
Defined.

Remark rem_1970 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_current X2). tauto. exact (rem_1969 epsilon_m__type_4_pknows_current X2).
Defined.

Remark rem_1971 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_1968 epsilon_m__type_4_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1970 epsilon_m__type_4_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1972 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1971 epsilon_m__type_4_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_4_pknows_current A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  epsilon_m__type_4_pknows_current A1 A2. tauto.
Defined.

Remark rem_1973 : forall X1 X2:term, auto___type_4 (cons X1 X2) -> or_1
    (auto_knows_old X1 /\ auto_knows_old X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1974 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_4 (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_1973 X1 X2 H);  intros.
  apply (rem_1972 epsilon_m__type_4_pknows_current X1 X2);  tauto.
Defined.

Remark rem_1975 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_1967 epsilon_m__type_4_pknows_current X1);  assumption.
  tauto.
Defined.

Remark rem_1976 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_current (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1. intros A1.
  case (rem_1975 epsilon_m__type_4_pknows_current X1 A1). clear  epsilon_m__type_4_pknows_current A1. intros. apply trans_knows_current_s_1;  tauto.
 clear  epsilon_m__type_4_pknows_current A1. tauto.
Defined.

Remark rem_1977 : forall X1:term, auto___type_4 (s X1) -> or_1
    (auto_knows_old X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1978 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1:term, auto___type_4 (s X1) -> auto_knows_current (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1. intro H. intros.
  elim (rem_1977 X1 H);  intros.
  apply (rem_1976 epsilon_m__type_4_pknows_current X1);  tauto.
Defined.

Remark rem_1979 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> auto_knows_current nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current.  case (rem_1960 epsilon_m__type_4_pknows_current). clear  epsilon_m__type_4_pknows_current. intros. apply trans_knows_current_nil_1;  tauto.
 clear  epsilon_m__type_4_pknows_current. tauto.
Defined.

Remark rem_1980 : auto___type_4 nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1981 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> auto___type_4 nil -> auto_knows_current nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intro H. intros.
  elim (rem_1980 H);  intros.
  apply (rem_1979 epsilon_m__type_4_pknows_current);  tauto.
Defined.

Remark rem_1982 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> auto_knows_current i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current.  case (rem_1960 epsilon_m__type_4_pknows_current). clear  epsilon_m__type_4_pknows_current. intros. apply trans_knows_current_i_1;  tauto.
 clear  epsilon_m__type_4_pknows_current. tauto.
Defined.

Remark rem_1983 : auto___type_4 i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1984 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> auto___type_4 i -> auto_knows_current i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intro H. intros.
  elim (rem_1983 H);  intros.
  apply (rem_1982 epsilon_m__type_4_pknows_current);  tauto.
Defined.

Remark rem_1985 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1:term, auto___def_35 X1 -> auto___def_35 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1986 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___def_35 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2.
  cut (auto___def_35 X1 -> auto___def_35 X1). tauto. exact (rem_1985 epsilon_m__type_4_pknows_current X1).
Defined.

Remark rem_1987 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1988 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_1987 epsilon_m__type_4_pknows_current X2).
Defined.

Remark rem_1989 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> (auto___def_35 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_35 X1). 2:apply (rem_1986 epsilon_m__type_4_pknows_current X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_1988 epsilon_m__type_4_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1990 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1989 epsilon_m__type_4_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_4_pknows_current A1 A2. intros. apply trans_knows_current_key_2;  tauto.
 clear  epsilon_m__type_4_pknows_current A1 A2. tauto.
Defined.

Remark rem_1991 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1:term, auto___def_36 X1 -> auto___def_36 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1992 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_36 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2.
  cut (auto___def_36 X1 -> auto___def_36 X1). tauto. exact (rem_1991 epsilon_m__type_4_pknows_current X1).
Defined.

Remark rem_1993 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X2:term, auto___def_37 X2 -> auto___def_37 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1994 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_37 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2.
  cut (auto___def_37 X2 -> auto___def_37 X2). tauto. exact (rem_1993 epsilon_m__type_4_pknows_current X2).
Defined.

Remark rem_1995 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> (auto___def_36 X1 /\ auto___def_37 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_36 X1). 2:apply (rem_1992 epsilon_m__type_4_pknows_current X1 X2);  assumption.
  cut (auto___def_37 X2). 2:apply (rem_1994 epsilon_m__type_4_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1996 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1995 epsilon_m__type_4_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_4_pknows_current A1 A2. intros. apply trans_knows_current_key_3;  tauto.
 clear  epsilon_m__type_4_pknows_current A1 A2. tauto.
Defined.

Remark rem_1997 : forall X1 X2:term, auto___type_4 (key X1 X2) -> or_2
    (auto___def_35 X1 /\ auto___type_8 X2)
    (auto___def_36 X1 /\ auto___def_37 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_1998 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_4 (key X1 X2) -> auto_knows_current (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_1997 X1 X2 H);  intros.
  apply (rem_1990 epsilon_m__type_4_pknows_current X1 X2);  tauto.
  apply (rem_1996 epsilon_m__type_4_pknows_current X1 X2);  tauto.
Defined.

Remark rem_1999 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1:term, auto___def_12 X1 -> auto___def_12 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2000 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_12 X1). tauto. exact (rem_1999 epsilon_m__type_4_pknows_current X1).
Defined.

Remark rem_2001 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X2:term, auto___def_13 X2 -> auto___def_13 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2002 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_2001 epsilon_m__type_4_pknows_current X2).
Defined.

Remark rem_2003 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> (auto___def_12 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_12 X1). 2:apply (rem_2000 epsilon_m__type_4_pknows_current X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_2002 epsilon_m__type_4_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2004 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2003 epsilon_m__type_4_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_4_pknows_current A1 A2. intros. apply trans_knows_current_crypt_3;  tauto.
 clear  epsilon_m__type_4_pknows_current A1 A2. tauto.
Defined.

Remark rem_2005 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1:term, auto___def_34 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__type_4_pknows_current. exact (rem_1799).
Defined.

Remark rem_2006 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2.
  cut (auto___def_34 X1 -> auto_knows_current X1). tauto. exact (rem_2005 epsilon_m__type_4_pknows_current X1).
Defined.

Remark rem_2007 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X2:term, auto___type_7 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_m__type_4_pknows_current. exact (rem_1834).
Defined.

Remark rem_2008 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2.
  cut (auto___type_7 X2 -> auto_knows_current X2). tauto. exact (rem_2007 epsilon_m__type_4_pknows_current X2).
Defined.

Remark rem_2009 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2006 epsilon_m__type_4_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2008 epsilon_m__type_4_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2010 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2009 epsilon_m__type_4_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_4_pknows_current A1 A2. intros. apply trans_knows_current_crypt_7;  tauto.
 clear  epsilon_m__type_4_pknows_current A1 A2. tauto.
Defined.

Remark rem_2011 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1:term, auto___def_22 X1 -> auto___def_22 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2012 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_22 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2.
  cut (auto___def_22 X1 -> auto___def_22 X1). tauto. exact (rem_2011 epsilon_m__type_4_pknows_current X1).
Defined.

Remark rem_2013 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X2:term, auto___def_23 X2 -> auto___def_23 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2014 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_2013 epsilon_m__type_4_pknows_current X2).
Defined.

Remark rem_2015 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> (auto___def_22 X1 /\ auto___def_23 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_22 X1). 2:apply (rem_2012 epsilon_m__type_4_pknows_current X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_2014 epsilon_m__type_4_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2016 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2015 epsilon_m__type_4_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_4_pknows_current A1 A2. intros. apply trans_knows_current_crypt_5;  tauto.
 clear  epsilon_m__type_4_pknows_current A1 A2. tauto.
Defined.

Remark rem_2017 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1971 epsilon_m__type_4_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_4_pknows_current A1 A2. intros. apply trans_knows_current_crypt_7;  tauto.
 clear  epsilon_m__type_4_pknows_current A1 A2. tauto.
Defined.

Remark rem_2018 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1:term, auto___def_32 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__type_4_pknows_current. exact (rem_1774).
Defined.

Remark rem_2019 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2.
  cut (auto___def_32 X1 -> auto_knows_current X1). tauto. exact (rem_2018 epsilon_m__type_4_pknows_current X1).
Defined.

Remark rem_2020 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X2:term, auto___type_6 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_m__type_4_pknows_current. exact (rem_1872).
Defined.

Remark rem_2021 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2.
  cut (auto___type_6 X2 -> auto_knows_current X2). tauto. exact (rem_2020 epsilon_m__type_4_pknows_current X2).
Defined.

Remark rem_2022 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2019 epsilon_m__type_4_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2021 epsilon_m__type_4_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2023 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2022 epsilon_m__type_4_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_4_pknows_current A1 A2. intros. apply trans_knows_current_crypt_7;  tauto.
 clear  epsilon_m__type_4_pknows_current A1 A2. tauto.
Defined.

Remark rem_2024 : forall X1 X2:term, auto___type_4 (crypt X1 X2) -> or_5
    (auto___def_12 X1 /\ auto___def_13 X2)
    (auto___def_34 X1 /\ auto___type_7 X2)
    (auto___def_22 X1 /\ auto___def_23 X2)
    (auto_knows_old X1 /\ auto_knows_old X2)
    (auto___def_32 X1 /\ auto___type_6 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_5_intro_1; tauto.
  intros. apply or_5_intro_2; tauto.
  intros. apply or_5_intro_3; tauto.
  intros. apply or_5_intro_4; tauto.
  intros. apply or_5_intro_5; tauto.
Qed.

Remark rem_2025 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_4 (crypt X1 X2) -> auto_knows_current (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_2024 X1 X2 H);  intros.
  apply (rem_2004 epsilon_m__type_4_pknows_current X1 X2);  tauto.
  apply (rem_2010 epsilon_m__type_4_pknows_current X1 X2);  tauto.
  apply (rem_2016 epsilon_m__type_4_pknows_current X1 X2);  tauto.
  apply (rem_2017 epsilon_m__type_4_pknows_current X1 X2);  tauto.
  apply (rem_2023 epsilon_m__type_4_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2026 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intros A1 A2.
  tauto.
Defined.

Remark rem_2027 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_knows_current (noncea_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2026 epsilon_m__type_4_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_4_pknows_current A1 A2. intros. apply trans_knows_current_noncea_old_1;  tauto.
 clear  epsilon_m__type_4_pknows_current A1 A2. tauto.
Defined.

Remark rem_2028 : forall X1 X2:term, auto___type_4 (noncea_old X1 X2) -> or_1
    (auto_agent X1 /\ auto_agent X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2029 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_4 (noncea_old X1 X2) -> auto_knows_current (noncea_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_2028 X1 X2 H);  intros.
  apply (rem_2027 epsilon_m__type_4_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2030 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> auto_knows_current server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current.  case (rem_1960 epsilon_m__type_4_pknows_current). clear  epsilon_m__type_4_pknows_current. intros. apply trans_knows_current_server_1;  tauto.
 clear  epsilon_m__type_4_pknows_current. tauto.
Defined.

Remark rem_2031 : auto___type_4 server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2032 : (forall X:term, auto___type_4 X -> auto_knows_current X)
    -> auto___type_4 server -> auto_knows_current server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_pknows_current. intro H. intros.
  elim (rem_2031 H);  intros.
  apply (rem_2030 epsilon_m__type_4_pknows_current);  tauto.
Defined.

Remark rem_2033 : forall X1 X2:term, auto___type_4 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2034 : forall X1 X2 X3:term, auto___type_4 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2035 : forall X1 X2 X3:term, auto___type_4 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2036 : forall X1 X2 X3:term, auto___type_4 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2037 : forall X1 X2 X3:term, auto___type_4 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2038 : auto___type_4 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2039 : auto___type_4 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2040 : auto___type_4 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2041 : forall X1:term, auto___type_4 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_m__type_4_pknows_current 1.
  intro X. case X.
  exact (rem_1966 epsilon_m__type_4_pknows_current ).
  exact (rem_1963 epsilon_m__type_4_pknows_current ).
  intros X1 X2;  exact (rem_1974 epsilon_m__type_4_pknows_current X1 X2).
  intros X1 X2;  exact (rem_2025 epsilon_m__type_4_pknows_current X1 X2).
  exact (rem_1984 epsilon_m__type_4_pknows_current ).
  intros X1 X2;  exact (rem_1998 epsilon_m__type_4_pknows_current X1 X2).
  exact (rem_1981 epsilon_m__type_4_pknows_current ).
  intros X1 X2. intro H. elim (rem_2033 X1 X2 H).
  intros X1 X2;  exact (rem_2029 epsilon_m__type_4_pknows_current X1 X2).
  intros X1 X2 X3. intro H. elim (rem_2035 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2036 X1 X2 X3 H).
   intro H. elim (rem_2039  H).
   intro H. elim (rem_2038  H).
  intros X1;  exact (rem_1978 epsilon_m__type_4_pknows_current X1).
  exact (rem_2032 epsilon_m__type_4_pknows_current ).
  intros X1 X2 X3. intro H. elim (rem_2034 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2037 X1 X2 X3 H).
   intro H. elim (rem_2040  H).
Qed.

Remark rem_2042 : (forall X:term, auto___def_14 X -> auto_knows_current X)
    -> forall X1:term, auto___type_4 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__def_14_pknows_current. exact (rem_2041).
Defined.

Remark rem_2043 : (forall X:term, auto___def_14 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_4 X1 -> auto___def_15 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_14_pknows_current. intros X1 X2.
  cut (auto___type_4 X1 -> auto_knows_current X1). tauto. exact (rem_2042 epsilon_m__def_14_pknows_current X1).
Defined.

Remark rem_2044 : (forall X:term, auto___def_16 X -> auto_knows_current X)
    -> forall X1:term, auto___def_18 X1 -> auto___def_39 X1. (* Cut history. *)
Proof.  intros epsilon_m__def_16_pknows_current. exact (rem_1805).
Defined.

Remark rem_2045 : (forall X:term, auto___def_16 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_39 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_16_pknows_current. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_39 X1). tauto. exact (rem_2044 epsilon_m__def_16_pknows_current X1).
Defined.

Remark rem_2046 : (forall X:term, auto___def_16 X -> auto_knows_current X)
    -> forall X2:term, auto___def_19 X2 -> auto___def_40 X2. (* Cut history. *)
Proof.  intros epsilon_m__def_16_pknows_current. exact (rem_1811).
Defined.

Remark rem_2047 : (forall X:term, auto___def_16 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_40 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_16_pknows_current. intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_40 X2). tauto. exact (rem_2046 epsilon_m__def_16_pknows_current X2).
Defined.

Remark rem_2048 : (forall X:term, auto___def_16 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> (auto___def_39 X1 /\ auto___def_40 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_16_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_39 X1). 2:apply (rem_2045 epsilon_m__def_16_pknows_current X1 X2);  assumption.
  cut (auto___def_40 X2). 2:apply (rem_2047 epsilon_m__def_16_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2049 : (forall X:term, auto___def_16 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_16_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2048 epsilon_m__def_16_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_16_pknows_current A1 A2. intros. apply trans_knows_current_key_1;  tauto.
 clear  epsilon_m__def_16_pknows_current A1 A2. tauto.
Defined.

Remark rem_2050 : (forall X:term, auto___def_16 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_16 (key X1 X2) -> auto_knows_current (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_16_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_7 X1 X2 H);  intros.
  apply (rem_2049 epsilon_m__def_16_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2051 : forall X1:term, auto___def_16 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_m__def_16_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_12  H).
   intro H. elim (rem_10  H).
  intros X1 X2. intro H. elim (rem_13 X1 X2 H).
  intros X1 X2. intro H. elim (rem_19 X1 X2 H).
   intro H. elim (rem_16  H).
  intros X1 X2;  exact (rem_2050 epsilon_m__def_16_pknows_current X1 X2).
   intro H. elim (rem_15  H).
  intros X1 X2. intro H. elim (rem_9 X1 X2 H).
  intros X1 X2. intro H. elim (rem_21 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_17 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_18 X1 X2 X3 H).
   intro H. elim (rem_24  H).
   intro H. elim (rem_22  H).
  intros X1. intro H. elim (rem_14 X1 H).
   intro H. elim (rem_23  H).
  intros X1 X2 X3. intro H. elim (rem_11 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_20 X1 X2 X3 H).
   intro H. elim (rem_25  H).
Qed.

Remark rem_2052 : (forall X:term, auto___def_15 X -> auto_knows_current X)
    -> forall X1:term, auto___def_16 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__def_15_pknows_current. exact (rem_2051).
Defined.

Remark rem_2053 : (forall X:term, auto___def_15 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_16 X1 -> auto___def_17 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_15_pknows_current. intros X1 X2.
  cut (auto___def_16 X1 -> auto_knows_current X1). tauto. exact (rem_2052 epsilon_m__def_15_pknows_current X1).
Defined.

Remark rem_2054 : (forall X:term, auto___def_20 X -> auto_knows_current X)
    -> forall X1:term, auto___def_22 X1 -> auto___def_22 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2055 : (forall X:term, auto___def_20 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_22 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_20_pknows_current. intros X1 X2.
  cut (auto___def_22 X1 -> auto___def_22 X1). tauto. exact (rem_2054 epsilon_m__def_20_pknows_current X1).
Defined.

Remark rem_2056 : (forall X:term, auto___def_20 X -> auto_knows_current X)
    -> forall X2:term, auto___def_23 X2 -> auto___def_23 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2057 : (forall X:term, auto___def_20 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_20_pknows_current. intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_2056 epsilon_m__def_20_pknows_current X2).
Defined.

Remark rem_2058 : (forall X:term, auto___def_20 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> (auto___def_22 X1 /\ auto___def_23 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_20_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_22 X1). 2:apply (rem_2055 epsilon_m__def_20_pknows_current X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_2057 epsilon_m__def_20_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2059 : (forall X:term, auto___def_20 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_20_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2058 epsilon_m__def_20_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_20_pknows_current A1 A2. intros. apply trans_knows_current_crypt_5;  tauto.
 clear  epsilon_m__def_20_pknows_current A1 A2. tauto.
Defined.

Remark rem_2060 : forall X1 X2:term, auto___def_20 (crypt X1 X2) -> or_1
    (auto___def_22 X1 /\ auto___def_23 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2061 : (forall X:term, auto___def_20 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_20 (crypt X1 X2) -> auto_knows_current (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_20_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_2060 X1 X2 H);  intros.
  apply (rem_2059 epsilon_m__def_20_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2062 : forall X1 X2:term, auto___def_20 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2063 : auto___def_20 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2064 : forall X1 X2 X3:term, auto___def_20 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2065 : auto___def_20 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2066 : forall X1 X2:term, auto___def_20 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2067 : forall X1:term, auto___def_20 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2068 : auto___def_20 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2069 : auto___def_20 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2070 : forall X1 X2:term, auto___def_20 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2071 : forall X1 X2 X3:term, auto___def_20 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2072 : forall X1 X2 X3:term, auto___def_20 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2073 : forall X1 X2 X3:term, auto___def_20 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2074 : forall X1 X2:term, auto___def_20 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2075 : auto___def_20 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2076 : auto___def_20 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2077 : auto___def_20 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2078 : auto___def_20 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2079 : forall X1:term, auto___def_20 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_m__def_20_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_2065  H).
   intro H. elim (rem_2063  H).
  intros X1 X2. intro H. elim (rem_2066 X1 X2 H).
  intros X1 X2;  exact (rem_2061 epsilon_m__def_20_pknows_current X1 X2).
   intro H. elim (rem_2069  H).
  intros X1 X2. intro H. elim (rem_2070 X1 X2 H).
   intro H. elim (rem_2068  H).
  intros X1 X2. intro H. elim (rem_2062 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2074 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_2071 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2072 X1 X2 X3 H).
   intro H. elim (rem_2077  H).
   intro H. elim (rem_2075  H).
  intros X1. intro H. elim (rem_2067 X1 H).
   intro H. elim (rem_2076  H).
  intros X1 X2 X3. intro H. elim (rem_2064 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2073 X1 X2 X3 H).
   intro H. elim (rem_2078  H).
Qed.

Remark rem_2080 : (forall X:term, auto___def_17 X -> auto_knows_current X)
    -> forall X1:term, auto___def_20 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__def_17_pknows_current. exact (rem_2079).
Defined.

Remark rem_2081 : (forall X:term, auto___def_17 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_20 X1 -> auto___def_21 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_17_pknows_current. intros X1 X2.
  cut (auto___def_20 X1 -> auto_knows_current X1). tauto. exact (rem_2080 epsilon_m__def_17_pknows_current X1).
Defined.

Remark rem_2082 : (forall X:term, auto___def_21 X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_21_pknows_current.  tauto.
Defined.

Remark rem_2083 : (forall X:term, auto___def_21 X -> auto_knows_current X)
    -> auto_knows_current nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_21_pknows_current.  case (rem_2082 epsilon_m__def_21_pknows_current). clear  epsilon_m__def_21_pknows_current. intros. apply trans_knows_current_nil_1;  tauto.
 clear  epsilon_m__def_21_pknows_current. tauto.
Defined.

Remark rem_2084 : auto___def_21 nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2085 : (forall X:term, auto___def_21 X -> auto_knows_current X)
    -> auto___def_21 nil -> auto_knows_current nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_21_pknows_current. intro H. intros.
  elim (rem_2084 H);  intros.
  apply (rem_2083 epsilon_m__def_21_pknows_current);  tauto.
Defined.

Remark rem_2086 : forall X1 X2:term, auto___def_21 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2087 : auto___def_21 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2088 : forall X1 X2 X3:term, auto___def_21 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2089 : auto___def_21 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2090 : forall X1 X2:term, auto___def_21 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2091 : forall X1:term, auto___def_21 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2092 : auto___def_21 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2093 : forall X1 X2:term, auto___def_21 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2094 : forall X1 X2 X3:term, auto___def_21 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2095 : forall X1 X2 X3:term, auto___def_21 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2096 : forall X1 X2:term, auto___def_21 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2097 : forall X1 X2 X3:term, auto___def_21 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2098 : forall X1 X2:term, auto___def_21 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2099 : auto___def_21 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2100 : auto___def_21 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2101 : auto___def_21 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2102 : auto___def_21 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2103 : forall X2:term, auto___def_21 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__def_21_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_2089  H).
   intro H. elim (rem_2087  H).
  intros X1 X2. intro H. elim (rem_2090 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2096 X1 X2 H).
   intro H. elim (rem_2092  H).
  intros X1 X2. intro H. elim (rem_2093 X1 X2 H).
  exact (rem_2085 epsilon_m__def_21_pknows_current ).
  intros X1 X2. intro H. elim (rem_2086 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2098 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_2094 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2095 X1 X2 X3 H).
   intro H. elim (rem_2101  H).
   intro H. elim (rem_2099  H).
  intros X1. intro H. elim (rem_2091 X1 H).
   intro H. elim (rem_2100  H).
  intros X1 X2 X3. intro H. elim (rem_2088 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2097 X1 X2 X3 H).
   intro H. elim (rem_2102  H).
Qed.

Remark rem_2104 : (forall X:term, auto___def_17 X -> auto_knows_current X)
    -> forall X2:term, auto___def_21 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_m__def_17_pknows_current. exact (rem_2103).
Defined.

Remark rem_2105 : (forall X:term, auto___def_17 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_20 X1 -> auto___def_21 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_17_pknows_current. intros X1 X2.
  cut (auto___def_21 X2 -> auto_knows_current X2). tauto. exact (rem_2104 epsilon_m__def_17_pknows_current X2).
Defined.

Remark rem_2106 : (forall X:term, auto___def_17 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_20 X1 -> auto___def_21 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_17_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2081 epsilon_m__def_17_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2105 epsilon_m__def_17_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2107 : (forall X:term, auto___def_17 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_20 X1 -> auto___def_21 X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_17_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2106 epsilon_m__def_17_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_17_pknows_current A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  epsilon_m__def_17_pknows_current A1 A2. tauto.
Defined.

Remark rem_2108 : (forall X:term, auto___def_17 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_17 (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_17_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_220 X1 X2 H);  intros.
  apply (rem_2107 epsilon_m__def_17_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2109 : forall X1 X2:term, auto___def_17 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2110 : auto___def_17 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2111 : forall X1 X2 X3:term, auto___def_17 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2112 : auto___def_17 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2113 : forall X1:term, auto___def_17 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2114 : auto___def_17 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2115 : auto___def_17 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2116 : forall X1 X2:term, auto___def_17 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2117 : forall X1 X2 X3:term, auto___def_17 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2118 : forall X1 X2 X3:term, auto___def_17 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2119 : forall X1 X2:term, auto___def_17 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2120 : forall X1 X2 X3:term, auto___def_17 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2121 : forall X1 X2:term, auto___def_17 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2122 : auto___def_17 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2123 : auto___def_17 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2124 : auto___def_17 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2125 : auto___def_17 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2126 : forall X2:term, auto___def_17 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__def_17_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_2112  H).
   intro H. elim (rem_2110  H).
  intros X1 X2;  exact (rem_2108 epsilon_m__def_17_pknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_2119 X1 X2 H).
   intro H. elim (rem_2115  H).
  intros X1 X2. intro H. elim (rem_2116 X1 X2 H).
   intro H. elim (rem_2114  H).
  intros X1 X2. intro H. elim (rem_2109 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2121 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_2117 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2118 X1 X2 X3 H).
   intro H. elim (rem_2124  H).
   intro H. elim (rem_2122  H).
  intros X1. intro H. elim (rem_2113 X1 H).
   intro H. elim (rem_2123  H).
  intros X1 X2 X3. intro H. elim (rem_2111 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2120 X1 X2 X3 H).
   intro H. elim (rem_2125  H).
Qed.

Remark rem_2127 : (forall X:term, auto___def_15 X -> auto_knows_current X)
    -> forall X2:term, auto___def_17 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_m__def_15_pknows_current. exact (rem_2126).
Defined.

Remark rem_2128 : (forall X:term, auto___def_15 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_16 X1 -> auto___def_17 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_15_pknows_current. intros X1 X2.
  cut (auto___def_17 X2 -> auto_knows_current X2). tauto. exact (rem_2127 epsilon_m__def_15_pknows_current X2).
Defined.

Remark rem_2129 : (forall X:term, auto___def_15 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_16 X1 -> auto___def_17 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_15_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2053 epsilon_m__def_15_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2128 epsilon_m__def_15_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2130 : (forall X:term, auto___def_15 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_16 X1 -> auto___def_17 X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_15_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2129 epsilon_m__def_15_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_15_pknows_current A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  epsilon_m__def_15_pknows_current A1 A2. tauto.
Defined.

Remark rem_2131 : (forall X:term, auto___def_15 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_15 (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_15_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_222 X1 X2 H);  intros.
  apply (rem_2130 epsilon_m__def_15_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2132 : forall X1 X2:term, auto___def_15 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2133 : auto___def_15 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2134 : forall X1 X2 X3:term, auto___def_15 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2135 : auto___def_15 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2136 : forall X1:term, auto___def_15 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2137 : auto___def_15 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2138 : forall X1 X2:term, auto___def_15 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2139 : forall X1 X2 X3:term, auto___def_15 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2140 : forall X1 X2 X3:term, auto___def_15 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2141 : forall X1 X2:term, auto___def_15 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2142 : forall X1 X2 X3:term, auto___def_15 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2143 : forall X1 X2:term, auto___def_15 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2144 : auto___def_15 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2145 : auto___def_15 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2146 : auto___def_15 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2147 : auto___def_15 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2148 : forall X2:term, auto___def_15 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__def_15_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_2135  H).
   intro H. elim (rem_2133  H).
  intros X1 X2;  exact (rem_2131 epsilon_m__def_15_pknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_2141 X1 X2 H).
   intro H. elim (rem_2137  H).
  intros X1 X2. intro H. elim (rem_2138 X1 X2 H).
   intro H. elim (rem_1532  H).
  intros X1 X2. intro H. elim (rem_2132 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2143 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_2139 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2140 X1 X2 X3 H).
   intro H. elim (rem_2146  H).
   intro H. elim (rem_2144  H).
  intros X1. intro H. elim (rem_2136 X1 H).
   intro H. elim (rem_2145  H).
  intros X1 X2 X3. intro H. elim (rem_2134 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2142 X1 X2 X3 H).
   intro H. elim (rem_2147  H).
Qed.

Remark rem_2149 : (forall X:term, auto___def_14 X -> auto_knows_current X)
    -> forall X2:term, auto___def_15 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_m__def_14_pknows_current. exact (rem_2148).
Defined.

Remark rem_2150 : (forall X:term, auto___def_14 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_4 X1 -> auto___def_15 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_14_pknows_current. intros X1 X2.
  cut (auto___def_15 X2 -> auto_knows_current X2). tauto. exact (rem_2149 epsilon_m__def_14_pknows_current X2).
Defined.

Remark rem_2151 : (forall X:term, auto___def_14 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_4 X1 -> auto___def_15 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_14_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2043 epsilon_m__def_14_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2150 epsilon_m__def_14_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2152 : (forall X:term, auto___def_14 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_4 X1 -> auto___def_15 X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_14_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2151 epsilon_m__def_14_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_14_pknows_current A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  epsilon_m__def_14_pknows_current A1 A2. tauto.
Defined.

Remark rem_2153 : (forall X:term, auto___def_14 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_14 (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_14_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_225 X1 X2 H);  intros.
  apply (rem_2152 epsilon_m__def_14_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2154 : forall X1 X2:term, auto___def_14 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2155 : auto___def_14 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2156 : forall X1 X2 X3:term, auto___def_14 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2157 : auto___def_14 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2158 : forall X1:term, auto___def_14 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2159 : auto___def_14 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2160 : auto___def_14 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2161 : forall X1 X2:term, auto___def_14 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2162 : forall X1 X2 X3:term, auto___def_14 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2163 : forall X1 X2 X3:term, auto___def_14 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2164 : forall X1 X2:term, auto___def_14 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2165 : forall X1 X2 X3:term, auto___def_14 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2166 : forall X1 X2:term, auto___def_14 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2167 : auto___def_14 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2168 : auto___def_14 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2169 : auto___def_14 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2170 : auto___def_14 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2171 : forall X2:term, auto___def_14 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__def_14_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_2157  H).
   intro H. elim (rem_2155  H).
  intros X1 X2;  exact (rem_2153 epsilon_m__def_14_pknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_2164 X1 X2 H).
   intro H. elim (rem_2160  H).
  intros X1 X2. intro H. elim (rem_2161 X1 X2 H).
   intro H. elim (rem_2159  H).
  intros X1 X2. intro H. elim (rem_2154 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2166 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_2162 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2163 X1 X2 X3 H).
   intro H. elim (rem_2169  H).
   intro H. elim (rem_2167  H).
  intros X1. intro H. elim (rem_2158 X1 H).
   intro H. elim (rem_2168  H).
  intros X1 X2 X3. intro H. elim (rem_2156 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2165 X1 X2 X3 H).
   intro H. elim (rem_2170  H).
Qed.

Remark rem_2172 : (forall X:term, auto___def_12 X -> auto_knows_current X)
    -> forall X2:term, auto___def_14 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_m__def_12_pknows_current. exact (rem_2171).
Defined.

Remark rem_2173 : (forall X:term, auto___def_12 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_3 X1 -> auto___def_14 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_12_pknows_current. intros X1 X2.
  cut (auto___def_14 X2 -> auto_knows_current X2). tauto. exact (rem_2172 epsilon_m__def_12_pknows_current X2).
Defined.

Remark rem_2174 : (forall X:term, auto___def_12 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_3 X1 -> auto___def_14 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_12_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_1959 epsilon_m__def_12_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2173 epsilon_m__def_12_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2175 : (forall X:term, auto___def_12 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_3 X1 -> auto___def_14 X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_12_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2174 epsilon_m__def_12_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_12_pknows_current A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  epsilon_m__def_12_pknows_current A1 A2. tauto.
Defined.

Remark rem_2176 : (forall X:term, auto___def_12 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_12 (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_12_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_231 X1 X2 H);  intros.
  apply (rem_2175 epsilon_m__def_12_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2177 : forall X1 X2:term, auto___def_12 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2178 : auto___def_12 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2179 : forall X1 X2 X3:term, auto___def_12 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2180 : auto___def_12 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2181 : forall X1:term, auto___def_12 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2182 : auto___def_12 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2183 : auto___def_12 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2184 : forall X1 X2:term, auto___def_12 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2185 : forall X1 X2 X3:term, auto___def_12 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2186 : forall X1 X2 X3:term, auto___def_12 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2187 : forall X1 X2:term, auto___def_12 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2188 : forall X1 X2 X3:term, auto___def_12 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2189 : forall X1 X2:term, auto___def_12 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2190 : auto___def_12 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2191 : auto___def_12 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2192 : auto___def_12 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2193 : auto___def_12 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2194 : forall X2:term, auto___def_12 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__def_12_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_2180  H).
   intro H. elim (rem_2178  H).
  intros X1 X2;  exact (rem_2176 epsilon_m__def_12_pknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_2187 X1 X2 H).
   intro H. elim (rem_2183  H).
  intros X1 X2. intro H. elim (rem_2184 X1 X2 H).
   intro H. elim (rem_2182  H).
  intros X1 X2. intro H. elim (rem_2177 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2189 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_2185 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2186 X1 X2 X3 H).
   intro H. elim (rem_2192  H).
   intro H. elim (rem_2190  H).
  intros X1. intro H. elim (rem_2181 X1 H).
   intro H. elim (rem_2191  H).
  intros X1 X2 X3. intro H. elim (rem_2179 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2188 X1 X2 X3 H).
   intro H. elim (rem_2193  H).
Qed.

Remark rem_2195 : forall X1 X2:term, auto___def_12 X2 -> auto___def_13 (key pub X1) -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_12 X2 -> auto_knows_current X2). tauto. exact (rem_2194 X2).
Qed.

Remark rem_2196 : forall X1 X2:term, auto___def_12 X2 -> auto___def_13 (key pub X1) -> (auto___type_8 X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_8 X1). 2:apply (rem_1708 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2195 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2197 : forall X1 X2:term, auto___def_12 X2 -> auto___def_13 (key pub X1) -> auto___def_41 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2196 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_41_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2198 : auto___def_57 pub -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_649 H);  intros.
Qed.

Remark rem_2199 : forall X1 X2:term, auto___def_57 pub -> auto___def_61 X2 -> auto___def_64 X1 -> auto___def_41 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_57 pub -> False). tauto.
  exact (rem_2198).
Qed.

Remark rem_2200 : forall X1 X2:term, auto___def_57 pub -> auto___def_64 X1 -> auto___def_61 X2 -> auto___def_41 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_57 pub -> auto___def_61 X2 -> auto___def_64 X1 -> auto___def_41 X1 X2). tauto. exact (rem_2199 X1 X2).
Qed.

Remark rem_2201 : forall X1 X2:term, auto___def_61 X2 -> auto___def_62 (key pub X1) -> auto___def_41 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_291 pub X1 H);  intros.
  apply (rem_2200 X1 X2);  tauto.
Qed.

Remark rem_2202 : forall X1 X2:term, auto___def_22 X2 -> auto___def_23 (key pub X1) -> auto___type_8 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_8_1. Qed.

Remark rem_2203 : (forall X:term, auto___def_22 X -> auto_knows_current X)
    -> forall X1:term, auto___def_16 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__def_22_pknows_current. exact (rem_2051).
Defined.

Remark rem_2204 : (forall X:term, auto___def_22 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_16 X1 -> auto___def_24 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_22_pknows_current. intros X1 X2.
  cut (auto___def_16 X1 -> auto_knows_current X1). tauto. exact (rem_2203 epsilon_m__def_22_pknows_current X1).
Defined.

Remark rem_2205 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_5_pknows_current.  tauto.
Defined.

Remark rem_2206 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> auto_knows_current bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows_current.  case (rem_2205 epsilon_m__type_5_pknows_current). clear  epsilon_m__type_5_pknows_current. intros. apply trans_knows_current_bob_1;  tauto.
 clear  epsilon_m__type_5_pknows_current. tauto.
Defined.

Remark rem_2207 : auto___type_5 bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2208 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> auto___type_5 bob -> auto_knows_current bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intro H. intros.
  elim (rem_2207 H);  intros.
  apply (rem_2206 epsilon_m__type_5_pknows_current);  tauto.
Defined.

Remark rem_2209 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> auto_knows_current alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows_current.  case (rem_2205 epsilon_m__type_5_pknows_current). clear  epsilon_m__type_5_pknows_current. intros. apply trans_knows_current_alice_1;  tauto.
 clear  epsilon_m__type_5_pknows_current. tauto.
Defined.

Remark rem_2210 : auto___type_5 alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2211 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> auto___type_5 alice -> auto_knows_current alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intro H. intros.
  elim (rem_2210 H);  intros.
  apply (rem_2209 epsilon_m__type_5_pknows_current);  tauto.
Defined.

Remark rem_2212 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__type_5_pknows_current. exact (rem_1883).
Defined.

Remark rem_2213 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2.
  cut (auto_knows_old X1 -> auto_knows_current X1). tauto. exact (rem_2212 epsilon_m__type_5_pknows_current X1).
Defined.

Remark rem_2214 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X2:term, auto_knows_old X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_m__type_5_pknows_current. exact (rem_1886).
Defined.

Remark rem_2215 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_current X2). tauto. exact (rem_2214 epsilon_m__type_5_pknows_current X2).
Defined.

Remark rem_2216 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2213 epsilon_m__type_5_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2215 epsilon_m__type_5_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2217 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2216 epsilon_m__type_5_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_5_pknows_current A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  epsilon_m__type_5_pknows_current A1 A2. tauto.
Defined.

Remark rem_2218 : forall X1 X2:term, auto___type_5 (cons X1 X2) -> or_1
    (auto_knows_old X1 /\ auto_knows_old X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2219 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_5 (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_2218 X1 X2 H);  intros.
  apply (rem_2217 epsilon_m__type_5_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2220 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_2212 epsilon_m__type_5_pknows_current X1);  assumption.
  tauto.
Defined.

Remark rem_2221 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_current (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1. intros A1.
  case (rem_2220 epsilon_m__type_5_pknows_current X1 A1). clear  epsilon_m__type_5_pknows_current A1. intros. apply trans_knows_current_s_1;  tauto.
 clear  epsilon_m__type_5_pknows_current A1. tauto.
Defined.

Remark rem_2222 : forall X1:term, auto___type_5 (s X1) -> or_1
    (auto_knows_old X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2223 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1:term, auto___type_5 (s X1) -> auto_knows_current (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1. intro H. intros.
  elim (rem_2222 X1 H);  intros.
  apply (rem_2221 epsilon_m__type_5_pknows_current X1);  tauto.
Defined.

Remark rem_2224 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> auto_knows_current nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows_current.  case (rem_2205 epsilon_m__type_5_pknows_current). clear  epsilon_m__type_5_pknows_current. intros. apply trans_knows_current_nil_1;  tauto.
 clear  epsilon_m__type_5_pknows_current. tauto.
Defined.

Remark rem_2225 : auto___type_5 nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2226 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> auto___type_5 nil -> auto_knows_current nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intro H. intros.
  elim (rem_2225 H);  intros.
  apply (rem_2224 epsilon_m__type_5_pknows_current);  tauto.
Defined.

Remark rem_2227 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> auto_knows_current i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows_current.  case (rem_2205 epsilon_m__type_5_pknows_current). clear  epsilon_m__type_5_pknows_current. intros. apply trans_knows_current_i_1;  tauto.
 clear  epsilon_m__type_5_pknows_current. tauto.
Defined.

Remark rem_2228 : auto___type_5 i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2229 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> auto___type_5 i -> auto_knows_current i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intro H. intros.
  elim (rem_2228 H);  intros.
  apply (rem_2227 epsilon_m__type_5_pknows_current);  tauto.
Defined.

Remark rem_2230 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1:term, auto___def_35 X1 -> auto___def_35 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2231 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___def_35 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2.
  cut (auto___def_35 X1 -> auto___def_35 X1). tauto. exact (rem_2230 epsilon_m__type_5_pknows_current X1).
Defined.

Remark rem_2232 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2233 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_2232 epsilon_m__type_5_pknows_current X2).
Defined.

Remark rem_2234 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> (auto___def_35 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_35 X1). 2:apply (rem_2231 epsilon_m__type_5_pknows_current X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_2233 epsilon_m__type_5_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2235 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2234 epsilon_m__type_5_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_5_pknows_current A1 A2. intros. apply trans_knows_current_key_2;  tauto.
 clear  epsilon_m__type_5_pknows_current A1 A2. tauto.
Defined.

Remark rem_2236 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1:term, auto___def_36 X1 -> auto___def_36 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2237 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_36 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2.
  cut (auto___def_36 X1 -> auto___def_36 X1). tauto. exact (rem_2236 epsilon_m__type_5_pknows_current X1).
Defined.

Remark rem_2238 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X2:term, auto___def_37 X2 -> auto___def_37 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2239 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_37 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2.
  cut (auto___def_37 X2 -> auto___def_37 X2). tauto. exact (rem_2238 epsilon_m__type_5_pknows_current X2).
Defined.

Remark rem_2240 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> (auto___def_36 X1 /\ auto___def_37 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_36 X1). 2:apply (rem_2237 epsilon_m__type_5_pknows_current X1 X2);  assumption.
  cut (auto___def_37 X2). 2:apply (rem_2239 epsilon_m__type_5_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2241 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2240 epsilon_m__type_5_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_5_pknows_current A1 A2. intros. apply trans_knows_current_key_3;  tauto.
 clear  epsilon_m__type_5_pknows_current A1 A2. tauto.
Defined.

Remark rem_2242 : forall X1 X2:term, auto___type_5 (key X1 X2) -> or_2
    (auto___def_35 X1 /\ auto___type_8 X2)
    (auto___def_36 X1 /\ auto___def_37 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_2243 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_5 (key X1 X2) -> auto_knows_current (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_2242 X1 X2 H);  intros.
  apply (rem_2235 epsilon_m__type_5_pknows_current X1 X2);  tauto.
  apply (rem_2241 epsilon_m__type_5_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2244 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1:term, auto___def_12 X1 -> auto___def_12 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2245 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_12 X1). tauto. exact (rem_2244 epsilon_m__type_5_pknows_current X1).
Defined.

Remark rem_2246 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X2:term, auto___def_13 X2 -> auto___def_13 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2247 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_2246 epsilon_m__type_5_pknows_current X2).
Defined.

Remark rem_2248 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> (auto___def_12 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_12 X1). 2:apply (rem_2245 epsilon_m__type_5_pknows_current X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_2247 epsilon_m__type_5_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2249 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2248 epsilon_m__type_5_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_5_pknows_current A1 A2. intros. apply trans_knows_current_crypt_3;  tauto.
 clear  epsilon_m__type_5_pknows_current A1 A2. tauto.
Defined.

Remark rem_2250 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1:term, auto___def_34 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__type_5_pknows_current. exact (rem_1799).
Defined.

Remark rem_2251 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2.
  cut (auto___def_34 X1 -> auto_knows_current X1). tauto. exact (rem_2250 epsilon_m__type_5_pknows_current X1).
Defined.

Remark rem_2252 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X2:term, auto___type_7 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_m__type_5_pknows_current. exact (rem_1834).
Defined.

Remark rem_2253 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2.
  cut (auto___type_7 X2 -> auto_knows_current X2). tauto. exact (rem_2252 epsilon_m__type_5_pknows_current X2).
Defined.

Remark rem_2254 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2251 epsilon_m__type_5_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2253 epsilon_m__type_5_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2255 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_34 X1 -> auto___type_7 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2254 epsilon_m__type_5_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_5_pknows_current A1 A2. intros. apply trans_knows_current_crypt_7;  tauto.
 clear  epsilon_m__type_5_pknows_current A1 A2. tauto.
Defined.

Remark rem_2256 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1:term, auto___def_22 X1 -> auto___def_22 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2257 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_22 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2.
  cut (auto___def_22 X1 -> auto___def_22 X1). tauto. exact (rem_2256 epsilon_m__type_5_pknows_current X1).
Defined.

Remark rem_2258 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X2:term, auto___def_23 X2 -> auto___def_23 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2259 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_2258 epsilon_m__type_5_pknows_current X2).
Defined.

Remark rem_2260 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> (auto___def_22 X1 /\ auto___def_23 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_22 X1). 2:apply (rem_2257 epsilon_m__type_5_pknows_current X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_2259 epsilon_m__type_5_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2261 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2260 epsilon_m__type_5_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_5_pknows_current A1 A2. intros. apply trans_knows_current_crypt_5;  tauto.
 clear  epsilon_m__type_5_pknows_current A1 A2. tauto.
Defined.

Remark rem_2262 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2216 epsilon_m__type_5_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_5_pknows_current A1 A2. intros. apply trans_knows_current_crypt_7;  tauto.
 clear  epsilon_m__type_5_pknows_current A1 A2. tauto.
Defined.

Remark rem_2263 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1:term, auto___def_32 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__type_5_pknows_current. exact (rem_1774).
Defined.

Remark rem_2264 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2.
  cut (auto___def_32 X1 -> auto_knows_current X1). tauto. exact (rem_2263 epsilon_m__type_5_pknows_current X1).
Defined.

Remark rem_2265 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X2:term, auto___type_6 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_m__type_5_pknows_current. exact (rem_1872).
Defined.

Remark rem_2266 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2.
  cut (auto___type_6 X2 -> auto_knows_current X2). tauto. exact (rem_2265 epsilon_m__type_5_pknows_current X2).
Defined.

Remark rem_2267 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2264 epsilon_m__type_5_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2266 epsilon_m__type_5_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2268 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_32 X1 -> auto___type_6 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2267 epsilon_m__type_5_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_5_pknows_current A1 A2. intros. apply trans_knows_current_crypt_7;  tauto.
 clear  epsilon_m__type_5_pknows_current A1 A2. tauto.
Defined.

Remark rem_2269 : forall X1 X2:term, auto___type_5 (crypt X1 X2) -> or_5
    (auto___def_12 X1 /\ auto___def_13 X2)
    (auto___def_34 X1 /\ auto___type_7 X2)
    (auto___def_22 X1 /\ auto___def_23 X2)
    (auto_knows_old X1 /\ auto_knows_old X2)
    (auto___def_32 X1 /\ auto___type_6 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_5_intro_1; tauto.
  intros. apply or_5_intro_2; tauto.
  intros. apply or_5_intro_3; tauto.
  intros. apply or_5_intro_4; tauto.
  intros. apply or_5_intro_5; tauto.
Qed.

Remark rem_2270 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_5 (crypt X1 X2) -> auto_knows_current (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_2269 X1 X2 H);  intros.
  apply (rem_2249 epsilon_m__type_5_pknows_current X1 X2);  tauto.
  apply (rem_2255 epsilon_m__type_5_pknows_current X1 X2);  tauto.
  apply (rem_2261 epsilon_m__type_5_pknows_current X1 X2);  tauto.
  apply (rem_2262 epsilon_m__type_5_pknows_current X1 X2);  tauto.
  apply (rem_2268 epsilon_m__type_5_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2271 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2. intros A1 A2.
  tauto.
Defined.

Remark rem_2272 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_knows_current (noncea_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2271 epsilon_m__type_5_pknows_current X1 X2 A1 A2). clear  epsilon_m__type_5_pknows_current A1 A2. intros. apply trans_knows_current_noncea_old_1;  tauto.
 clear  epsilon_m__type_5_pknows_current A1 A2. tauto.
Defined.

Remark rem_2273 : forall X1 X2:term, auto___type_5 (noncea_old X1 X2) -> or_1
    (auto_agent X1 /\ auto_agent X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2274 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_5 (noncea_old X1 X2) -> auto_knows_current (noncea_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_2273 X1 X2 H);  intros.
  apply (rem_2272 epsilon_m__type_5_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2275 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> auto_knows_current server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows_current.  case (rem_2205 epsilon_m__type_5_pknows_current). clear  epsilon_m__type_5_pknows_current. intros. apply trans_knows_current_server_1;  tauto.
 clear  epsilon_m__type_5_pknows_current. tauto.
Defined.

Remark rem_2276 : auto___type_5 server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2277 : (forall X:term, auto___type_5 X -> auto_knows_current X)
    -> auto___type_5 server -> auto_knows_current server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_5_pknows_current. intro H. intros.
  elim (rem_2276 H);  intros.
  apply (rem_2275 epsilon_m__type_5_pknows_current);  tauto.
Defined.

Remark rem_2278 : forall X1 X2:term, auto___type_5 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2279 : forall X1 X2 X3:term, auto___type_5 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2280 : forall X1 X2 X3:term, auto___type_5 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2281 : forall X1 X2 X3:term, auto___type_5 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2282 : forall X1 X2 X3:term, auto___type_5 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2283 : auto___type_5 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2284 : auto___type_5 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2285 : auto___type_5 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2286 : forall X1:term, auto___type_5 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_m__type_5_pknows_current 1.
  intro X. case X.
  exact (rem_2211 epsilon_m__type_5_pknows_current ).
  exact (rem_2208 epsilon_m__type_5_pknows_current ).
  intros X1 X2;  exact (rem_2219 epsilon_m__type_5_pknows_current X1 X2).
  intros X1 X2;  exact (rem_2270 epsilon_m__type_5_pknows_current X1 X2).
  exact (rem_2229 epsilon_m__type_5_pknows_current ).
  intros X1 X2;  exact (rem_2243 epsilon_m__type_5_pknows_current X1 X2).
  exact (rem_2226 epsilon_m__type_5_pknows_current ).
  intros X1 X2. intro H. elim (rem_2278 X1 X2 H).
  intros X1 X2;  exact (rem_2274 epsilon_m__type_5_pknows_current X1 X2).
  intros X1 X2 X3. intro H. elim (rem_2280 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2281 X1 X2 X3 H).
   intro H. elim (rem_2284  H).
   intro H. elim (rem_2283  H).
  intros X1;  exact (rem_2223 epsilon_m__type_5_pknows_current X1).
  exact (rem_2277 epsilon_m__type_5_pknows_current ).
  intros X1 X2 X3. intro H. elim (rem_2279 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2282 X1 X2 X3 H).
   intro H. elim (rem_2285  H).
Qed.

Remark rem_2287 : (forall X:term, auto___def_24 X -> auto_knows_current X)
    -> forall X1:term, auto___type_5 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__def_24_pknows_current. exact (rem_2286).
Defined.

Remark rem_2288 : (forall X:term, auto___def_24 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_5 X1 -> auto___def_21 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_24_pknows_current. intros X1 X2.
  cut (auto___type_5 X1 -> auto_knows_current X1). tauto. exact (rem_2287 epsilon_m__def_24_pknows_current X1).
Defined.

Remark rem_2289 : (forall X:term, auto___def_24 X -> auto_knows_current X)
    -> forall X2:term, auto___def_21 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_m__def_24_pknows_current. exact (rem_2103).
Defined.

Remark rem_2290 : (forall X:term, auto___def_24 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_5 X1 -> auto___def_21 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_24_pknows_current. intros X1 X2.
  cut (auto___def_21 X2 -> auto_knows_current X2). tauto. exact (rem_2289 epsilon_m__def_24_pknows_current X2).
Defined.

Remark rem_2291 : (forall X:term, auto___def_24 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_5 X1 -> auto___def_21 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_24_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2288 epsilon_m__def_24_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2290 epsilon_m__def_24_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2292 : (forall X:term, auto___def_24 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___type_5 X1 -> auto___def_21 X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_24_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2291 epsilon_m__def_24_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_24_pknows_current A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  epsilon_m__def_24_pknows_current A1 A2. tauto.
Defined.

Remark rem_2293 : (forall X:term, auto___def_24 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_24 (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_24_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_1567 X1 X2 H);  intros.
  apply (rem_2292 epsilon_m__def_24_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2294 : forall X1 X2:term, auto___def_24 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2295 : auto___def_24 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2296 : forall X1 X2 X3:term, auto___def_24 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2297 : auto___def_24 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2298 : forall X1:term, auto___def_24 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2299 : auto___def_24 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2300 : auto___def_24 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2301 : forall X1 X2:term, auto___def_24 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2302 : forall X1 X2 X3:term, auto___def_24 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2303 : forall X1 X2 X3:term, auto___def_24 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2304 : forall X1 X2:term, auto___def_24 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2305 : forall X1 X2 X3:term, auto___def_24 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2306 : forall X1 X2:term, auto___def_24 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2307 : auto___def_24 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2308 : auto___def_24 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2309 : auto___def_24 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2310 : auto___def_24 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2311 : forall X2:term, auto___def_24 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__def_24_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_2297  H).
   intro H. elim (rem_2295  H).
  intros X1 X2;  exact (rem_2293 epsilon_m__def_24_pknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_2304 X1 X2 H).
   intro H. elim (rem_2300  H).
  intros X1 X2. intro H. elim (rem_2301 X1 X2 H).
   intro H. elim (rem_2299  H).
  intros X1 X2. intro H. elim (rem_2294 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2306 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_2302 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2303 X1 X2 X3 H).
   intro H. elim (rem_2309  H).
   intro H. elim (rem_2307  H).
  intros X1. intro H. elim (rem_2298 X1 H).
   intro H. elim (rem_2308  H).
  intros X1 X2 X3. intro H. elim (rem_2296 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2305 X1 X2 X3 H).
   intro H. elim (rem_2310  H).
Qed.

Remark rem_2312 : (forall X:term, auto___def_22 X -> auto_knows_current X)
    -> forall X2:term, auto___def_24 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_m__def_22_pknows_current. exact (rem_2311).
Defined.

Remark rem_2313 : (forall X:term, auto___def_22 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_16 X1 -> auto___def_24 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_22_pknows_current. intros X1 X2.
  cut (auto___def_24 X2 -> auto_knows_current X2). tauto. exact (rem_2312 epsilon_m__def_22_pknows_current X2).
Defined.

Remark rem_2314 : (forall X:term, auto___def_22 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_16 X1 -> auto___def_24 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_22_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2204 epsilon_m__def_22_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2313 epsilon_m__def_22_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2315 : (forall X:term, auto___def_22 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_16 X1 -> auto___def_24 X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_22_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2314 epsilon_m__def_22_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_22_pknows_current A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  epsilon_m__def_22_pknows_current A1 A2. tauto.
Defined.

Remark rem_2316 : (forall X:term, auto___def_22 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_22 (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_22_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_237 X1 X2 H);  intros.
  apply (rem_2315 epsilon_m__def_22_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2317 : forall X1 X2:term, auto___def_22 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2318 : auto___def_22 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2319 : forall X1 X2 X3:term, auto___def_22 (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2320 : auto___def_22 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2321 : forall X1:term, auto___def_22 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2322 : auto___def_22 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2323 : auto___def_22 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2324 : forall X1 X2:term, auto___def_22 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2325 : forall X1 X2 X3:term, auto___def_22 (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2326 : forall X1 X2 X3:term, auto___def_22 (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2327 : forall X1 X2:term, auto___def_22 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2328 : forall X1 X2 X3:term, auto___def_22 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2329 : forall X1 X2:term, auto___def_22 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2330 : auto___def_22 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2331 : auto___def_22 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2332 : auto___def_22 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2333 : auto___def_22 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2334 : forall X2:term, auto___def_22 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__def_22_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_2320  H).
   intro H. elim (rem_2318  H).
  intros X1 X2;  exact (rem_2316 epsilon_m__def_22_pknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_2327 X1 X2 H).
   intro H. elim (rem_2323  H).
  intros X1 X2. intro H. elim (rem_2324 X1 X2 H).
   intro H. elim (rem_2322  H).
  intros X1 X2. intro H. elim (rem_2317 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2329 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_2325 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2326 X1 X2 X3 H).
   intro H. elim (rem_2332  H).
   intro H. elim (rem_2330  H).
  intros X1. intro H. elim (rem_2321 X1 H).
   intro H. elim (rem_2331  H).
  intros X1 X2 X3. intro H. elim (rem_2319 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2328 X1 X2 X3 H).
   intro H. elim (rem_2333  H).
Qed.

Remark rem_2335 : forall X1 X2:term, auto___def_22 X2 -> auto___def_23 (key pub X1) -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_22 X2 -> auto_knows_current X2). tauto. exact (rem_2334 X2).
Qed.

Remark rem_2336 : forall X1 X2:term, auto___def_22 X2 -> auto___def_23 (key pub X1) -> (auto___type_8 X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_8 X1). 2:apply (rem_2202 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2335 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2337 : forall X1 X2:term, auto___def_22 X2 -> auto___def_23 (key pub X1) -> auto___def_41 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2336 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_41_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2338 : forall X1 X2:term, auto___def_51 X2 -> auto___def_57 pub -> auto___def_66 X1 -> auto___def_41 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_57 pub -> False). tauto.
  exact (rem_2198).
Qed.

Remark rem_2339 : forall X1 X2:term, auto___def_57 pub -> auto___def_66 X1 -> auto___def_51 X2 -> auto___def_41 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_51 X2 -> auto___def_57 pub -> auto___def_66 X1 -> auto___def_41 X1 X2). tauto. exact (rem_2338 X1 X2).
Qed.

Remark rem_2340 : forall X1 X2:term, auto___def_51 X2 -> auto___def_52 (key pub X1) -> auto___def_41 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_298 pub X1 H);  intros.
  apply (rem_2339 X1 X2);  tauto.
Qed.

Remark rem_2341 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current (key pub X1) -> auto___type_8 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_8_1. Qed.

Remark rem_2342 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current (key pub X1) -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_306 X2).
Qed.

Remark rem_2343 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current (key pub X1) -> (auto___type_8 X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_8 X1). 2:apply (rem_2341 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2342 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2344 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current (key pub X1) -> auto___def_41 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2343 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_41_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2345 : forall X1 X2:term, auto_knows_current (crypt X2 (key pub X1)) -> auto___def_41 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_312 X2 (key pub X1) H);  intros.
  apply (rem_1702 X1 X2);  tauto.
  apply (rem_1707 X1 X2);  tauto.
  apply (rem_2197 X1 X2);  tauto.
  apply (rem_2201 X1 X2);  tauto.
  apply (rem_2337 X1 X2);  tauto.
  apply (rem_2340 X1 X2);  tauto.
  apply (rem_2344 X1 X2);  tauto.
Qed.

Remark rem_2346 : (forall X:term, auto___def_16 X -> auto___type_6 X)
    -> forall X1:term, auto___def_18 X1 -> auto___def_18 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2347 : (forall X:term, auto___def_16 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_18 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_16_p__type_6. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_18 X1). tauto. exact (rem_2346 epsilon_m__def_16_p__type_6 X1).
Defined.

Remark rem_2348 : (forall X:term, auto___def_16 X -> auto___type_6 X)
    -> forall X2:term, auto___def_19 X2 -> auto___def_19 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2349 : (forall X:term, auto___def_16 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_19 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_16_p__type_6. intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_19 X2). tauto. exact (rem_2348 epsilon_m__def_16_p__type_6 X2).
Defined.

Remark rem_2350 : (forall X:term, auto___def_16 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> (auto___def_18 X1 /\ auto___def_19 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_16_p__type_6. intros X1 X2. intros A1 A2.
  cut (auto___def_18 X1). 2:apply (rem_2347 epsilon_m__def_16_p__type_6 X1 X2);  assumption.
  cut (auto___def_19 X2). 2:apply (rem_2349 epsilon_m__def_16_p__type_6 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2351 : (forall X:term, auto___def_16 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___type_6 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_16_p__type_6. intros X1 X2. intros A1 A2.
  case (rem_2350 epsilon_m__def_16_p__type_6 X1 X2 A1 A2). clear  epsilon_m__def_16_p__type_6 A1 A2. intros. apply trans___type_6_key_1;  tauto.
 clear  epsilon_m__def_16_p__type_6 A1 A2. tauto.
Defined.

Remark rem_2352 : (forall X:term, auto___def_16 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_16 (key X1 X2) -> auto___type_6 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_16_p__type_6. intros X1 X2. intro H. intros.
  elim (rem_7 X1 X2 H);  intros.
  apply (rem_2351 epsilon_m__def_16_p__type_6 X1 X2);  tauto.
Defined.

Remark rem_2353 : forall X1:term, auto___def_16 X1 -> auto___type_6 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_16_p__type_6 1.
  intro X. case X.
   intro H. elim (rem_12  H).
   intro H. elim (rem_10  H).
  intros X1 X2. intro H. elim (rem_13 X1 X2 H).
  intros X1 X2. intro H. elim (rem_19 X1 X2 H).
   intro H. elim (rem_16  H).
  intros X1 X2;  exact (rem_2352 epsilon_m__def_16_p__type_6 X1 X2).
   intro H. elim (rem_15  H).
  intros X1 X2. intro H. elim (rem_9 X1 X2 H).
  intros X1 X2. intro H. elim (rem_21 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_17 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_18 X1 X2 X3 H).
   intro H. elim (rem_24  H).
   intro H. elim (rem_22  H).
  intros X1. intro H. elim (rem_14 X1 H).
   intro H. elim (rem_23  H).
  intros X1 X2 X3. intro H. elim (rem_11 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_20 X1 X2 X3 H).
   intro H. elim (rem_25  H).
Qed.

Remark rem_2354 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto___type_6 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_16 X1 -> auto___type_6 X1). tauto. exact (rem_2353 X1).
Qed.

Remark rem_2355 : forall X1 X2 X3:term, auto___type_5 X2 -> auto___type_4 X3 -> auto___def_16 X1 -> auto___type_6 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X3 X2.
  cut (auto___def_16 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto___type_6 X1). tauto. exact (rem_2354 X1 X2 X3).
Qed.

Remark rem_2356 : forall X1 X2 X3:term, auto___def_31 X1 X2 X3 -> or_1
    (auto___type_5 X1 /\ auto___type_4 X2 /\ auto___def_16 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2357 : forall X1 X2 X3:term, auto___def_31 X2 X3 X1 -> auto___type_6 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_2356 X2 X3 X1 H);  intros.
  apply (rem_2355 X1 X2 X3);  tauto.
Qed.

Remark rem_2358 : forall X1:term, auto___type_10 X1 -> auto___type_10 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2359 : forall X1 X2:term, auto___def_54 X2 -> auto___type_10 X1 -> auto___type_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_10 X1 -> auto___type_10 X1). tauto. exact (rem_2358 X1).
Qed.

Remark rem_2360 : forall X2:term, auto___def_54 X2 -> auto___def_54 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2361 : forall X1 X2:term, auto___def_54 X2 -> auto___type_10 X1 -> auto___def_54 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_54 X2 -> auto___def_54 X2). tauto. exact (rem_2360 X2).
Qed.

Remark rem_2362 : forall X1 X2:term, auto___def_54 X2 -> auto___type_10 X1 -> (auto___type_10 X1 /\ auto___def_54 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_10 X1). 2:apply (rem_2359 X1 X2);  assumption.
  cut (auto___def_54 X2). 2:apply (rem_2361 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2363 : forall X1 X2:term, auto___def_54 X2 -> auto___type_10 X1 -> auto___def_53 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2362 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_53_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2364 : auto___def_36 prv. (* Deduce positive atom. *)
Proof.
   case rem_321. intros. apply trans___def_36_prv_1;  tauto.
 tauto.
Qed.

Remark rem_2365 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2366 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_2365 epsilon_mknows_current_p__type_10 X1).
Defined.

Remark rem_2367 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2368 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_2367 epsilon_mknows_current_p__type_10 X2).
Defined.

Remark rem_2369 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> (auto_agent X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto_agent X1). 2:apply (rem_2366 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_2368 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2370 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_10 (noncea_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_2369 epsilon_mknows_current_p__type_10 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_10 A1 A2. intros. apply trans___type_10_noncea_current_1;  tauto.
 clear  epsilon_mknows_current_p__type_10 A1 A2. tauto.
Defined.

Remark rem_2371 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto_knows_current (noncea_current X1 X2) -> auto___type_10 (noncea_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intro H. intros.
  elim (rem_416 X1 X2 H);  intros.
  apply (rem_2370 epsilon_mknows_current_p__type_10 X1 X2);  tauto.
Defined.

Remark rem_2372 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_10.  tauto.
Defined.

Remark rem_2373 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> auto___type_10 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10.  case (rem_2372 epsilon_mknows_current_p__type_10). clear  epsilon_mknows_current_p__type_10. intros. apply trans___type_10_bob_1;  tauto.
 clear  epsilon_mknows_current_p__type_10. tauto.
Defined.

Remark rem_2374 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> auto_knows_current bob -> auto___type_10 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intro H. intros.
  elim (rem_420 H);  intros.
  apply (rem_2373 epsilon_mknows_current_p__type_10);  tauto.
Defined.

Remark rem_2375 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> auto___type_10 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10.  case (rem_2372 epsilon_mknows_current_p__type_10). clear  epsilon_mknows_current_p__type_10. intros. apply trans___type_10_alice_1;  tauto.
 clear  epsilon_mknows_current_p__type_10. tauto.
Defined.

Remark rem_2376 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> auto_knows_current alice -> auto___type_10 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intro H. intros.
  elim (rem_423 H);  intros.
  apply (rem_2375 epsilon_mknows_current_p__type_10);  tauto.
Defined.

Remark rem_2377 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2378 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_2377 epsilon_mknows_current_p__type_10 X1).
Defined.

Remark rem_2379 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X2:term, auto_knows_current X2 -> auto_knows_current X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2380 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_2379 epsilon_mknows_current_p__type_10 X2).
Defined.

Remark rem_2381 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2378 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2380 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2382 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_10 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_2381 epsilon_mknows_current_p__type_10 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_10 A1 A2. intros. apply trans___type_10_cons_1;  tauto.
 clear  epsilon_mknows_current_p__type_10 A1 A2. tauto.
Defined.

Remark rem_2383 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto_knows_current (cons X1 X2) -> auto___type_10 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intro H. intros.
  elim (rem_431 X1 X2 H);  intros.
  apply (rem_2382 epsilon_mknows_current_p__type_10 X1 X2);  tauto.
Defined.

Remark rem_2384 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_2377 epsilon_mknows_current_p__type_10 X1);  assumption.
  tauto.
Defined.

Remark rem_2385 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto_knows_current X1 -> auto___type_10 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1. intros A1.
  case (rem_2384 epsilon_mknows_current_p__type_10 X1 A1). clear  epsilon_mknows_current_p__type_10 A1. intros. apply trans___type_10_s_1;  tauto.
 clear  epsilon_mknows_current_p__type_10 A1. tauto.
Defined.

Remark rem_2386 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto_knows_current (s X1) -> auto___type_10 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1. intro H. intros.
  elim (rem_435 X1 H);  intros.
  apply (rem_2385 epsilon_mknows_current_p__type_10 X1);  tauto.
Defined.

Remark rem_2387 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> auto___type_10 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10.  case (rem_2372 epsilon_mknows_current_p__type_10). clear  epsilon_mknows_current_p__type_10. intros. apply trans___type_10_nil_1;  tauto.
 clear  epsilon_mknows_current_p__type_10. tauto.
Defined.

Remark rem_2388 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> auto_knows_current nil -> auto___type_10 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intro H. intros.
  elim (rem_438 H);  intros.
  apply (rem_2387 epsilon_mknows_current_p__type_10);  tauto.
Defined.

Remark rem_2389 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> auto___type_10 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10.  case (rem_2372 epsilon_mknows_current_p__type_10). clear  epsilon_mknows_current_p__type_10. intros. apply trans___type_10_i_1;  tauto.
 clear  epsilon_mknows_current_p__type_10. tauto.
Defined.

Remark rem_2390 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> auto_knows_current i -> auto___type_10 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intro H. intros.
  elim (rem_441 H);  intros.
  apply (rem_2389 epsilon_mknows_current_p__type_10);  tauto.
Defined.

Remark rem_2391 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto___def_39 X1 -> auto___def_39 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2392 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_39 X1 -> auto___def_40 X2 -> auto___def_39 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_39 X1 -> auto___def_39 X1). tauto. exact (rem_2391 epsilon_mknows_current_p__type_10 X1).
Defined.

Remark rem_2393 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X2:term, auto___def_40 X2 -> auto___def_40 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2394 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_39 X1 -> auto___def_40 X2 -> auto___def_40 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_40 X2 -> auto___def_40 X2). tauto. exact (rem_2393 epsilon_mknows_current_p__type_10 X2).
Defined.

Remark rem_2395 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_39 X1 -> auto___def_40 X2 -> (auto___def_39 X1 /\ auto___def_40 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_39 X1). 2:apply (rem_2392 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  cut (auto___def_40 X2). 2:apply (rem_2394 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2396 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_39 X1 -> auto___def_40 X2 -> auto___type_10 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_2395 epsilon_mknows_current_p__type_10 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_10 A1 A2. intros. apply trans___type_10_key_1;  tauto.
 clear  epsilon_mknows_current_p__type_10 A1 A2. tauto.
Defined.

Remark rem_2397 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto___def_35 X1 -> auto___def_35 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2398 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___def_35 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_35 X1 -> auto___def_35 X1). tauto. exact (rem_2397 epsilon_mknows_current_p__type_10 X1).
Defined.

Remark rem_2399 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2400 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_2399 epsilon_mknows_current_p__type_10 X2).
Defined.

Remark rem_2401 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> (auto___def_35 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_35 X1). 2:apply (rem_2398 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_2400 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2402 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_35 X1 -> auto___type_8 X2 -> auto___type_10 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_2401 epsilon_mknows_current_p__type_10 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_10 A1 A2. intros. apply trans___type_10_key_2;  tauto.
 clear  epsilon_mknows_current_p__type_10 A1 A2. tauto.
Defined.

Remark rem_2403 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto___def_36 X1 -> auto___def_36 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2404 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_36 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_36 X1 -> auto___def_36 X1). tauto. exact (rem_2403 epsilon_mknows_current_p__type_10 X1).
Defined.

Remark rem_2405 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X2:term, auto___def_37 X2 -> auto___def_37 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2406 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___def_37 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_37 X2 -> auto___def_37 X2). tauto. exact (rem_2405 epsilon_mknows_current_p__type_10 X2).
Defined.

Remark rem_2407 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> (auto___def_36 X1 /\ auto___def_37 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_36 X1). 2:apply (rem_2404 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  cut (auto___def_37 X2). 2:apply (rem_2406 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2408 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_37 X2 -> auto___type_10 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_2407 epsilon_mknows_current_p__type_10 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_10 A1 A2. intros. apply trans___type_10_key_3;  tauto.
 clear  epsilon_mknows_current_p__type_10 A1 A2. tauto.
Defined.

Remark rem_2409 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto_knows_current (key X1 X2) -> auto___type_10 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intro H. intros.
  elim (rem_310 X1 X2 H);  intros.
  apply (rem_2396 epsilon_mknows_current_p__type_10 X1 X2);  tauto.
  apply (rem_2402 epsilon_mknows_current_p__type_10 X1 X2);  tauto.
  apply (rem_2408 epsilon_mknows_current_p__type_10 X1 X2);  tauto.
Defined.

Remark rem_2410 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto___def_16 X1 -> auto___def_16 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2411 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___def_16 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2 X3.
  cut (auto___def_16 X1 -> auto___def_16 X1). tauto. exact (rem_2410 epsilon_mknows_current_p__type_10 X1).
Defined.

Remark rem_2412 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X2:term, auto___type_5 X2 -> auto___type_5 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2413 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2 X3.
  cut (auto___type_5 X2 -> auto___type_5 X2). tauto. exact (rem_2412 epsilon_mknows_current_p__type_10 X2).
Defined.

Remark rem_2414 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X3:term, auto___type_4 X3 -> auto___type_4 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2415 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_4 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2 X3.
  cut (auto___type_4 X3 -> auto___type_4 X3). tauto. exact (rem_2414 epsilon_mknows_current_p__type_10 X3).
Defined.

Remark rem_2416 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> (auto___def_16 X1 /\ auto___type_5 X2 /\ auto___type_4 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_16 X1). 2:apply (rem_2411 epsilon_mknows_current_p__type_10 X1 X2 X3);  assumption.
  cut (auto___type_5 X2). 2:apply (rem_2413 epsilon_mknows_current_p__type_10 X1 X2 X3);  assumption.
  cut (auto___type_4 X3). 2:apply (rem_2415 epsilon_mknows_current_p__type_10 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_2417 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_10 (nonceb_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_2416 epsilon_mknows_current_p__type_10 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_current_p__type_10 A1 A2 A3. intros. apply trans___type_10_nonceb_current_1;  tauto.
 clear  epsilon_mknows_current_p__type_10 A1 A2 A3. tauto.
Defined.

Remark rem_2418 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto___def_55 X1 -> auto___def_55 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2419 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2 X3:term, auto___def_55 X1 -> auto___type_11 X2 -> auto___type_10 X3 -> auto___def_55 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2 X3.
  cut (auto___def_55 X1 -> auto___def_55 X1). tauto. exact (rem_2418 epsilon_mknows_current_p__type_10 X1).
Defined.

Remark rem_2420 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X2:term, auto___type_11 X2 -> auto___type_11 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2421 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2 X3:term, auto___def_55 X1 -> auto___type_11 X2 -> auto___type_10 X3 -> auto___type_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2 X3.
  cut (auto___type_11 X2 -> auto___type_11 X2). tauto. exact (rem_2420 epsilon_mknows_current_p__type_10 X2).
Defined.

Remark rem_2422 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X3:term, auto___type_10 X3 -> auto___type_10 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2423 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2 X3:term, auto___def_55 X1 -> auto___type_11 X2 -> auto___type_10 X3 -> auto___type_10 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2 X3.
  cut (auto___type_10 X3 -> auto___type_10 X3). tauto. exact (rem_2422 epsilon_mknows_current_p__type_10 X3).
Defined.

Remark rem_2424 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2 X3:term, auto___def_55 X1 -> auto___type_11 X2 -> auto___type_10 X3 -> (auto___def_55 X1 /\ auto___type_11 X2 /\ auto___type_10 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_55 X1). 2:apply (rem_2419 epsilon_mknows_current_p__type_10 X1 X2 X3);  assumption.
  cut (auto___type_11 X2). 2:apply (rem_2421 epsilon_mknows_current_p__type_10 X1 X2 X3);  assumption.
  cut (auto___type_10 X3). 2:apply (rem_2423 epsilon_mknows_current_p__type_10 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_2425 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2 X3:term, auto___def_55 X1 -> auto___type_11 X2 -> auto___type_10 X3 -> auto___type_10 (nonceb_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_2424 epsilon_mknows_current_p__type_10 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_current_p__type_10 A1 A2 A3. intros. apply trans___type_10_nonceb_current_2;  tauto.
 clear  epsilon_mknows_current_p__type_10 A1 A2 A3. tauto.
Defined.

Remark rem_2426 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2 X3:term, auto_knows_current (nonceb_current X1 X2 X3) -> auto___type_10 (nonceb_current X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2 X3. intro H. intros.
  elim (rem_478 X1 X2 X3 H);  intros.
  apply (rem_2417 epsilon_mknows_current_p__type_10 X1 X2 X3);  tauto.
  apply (rem_2425 epsilon_mknows_current_p__type_10 X1 X2 X3);  tauto.
Defined.

Remark rem_2427 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2 X3:term, auto___type_10 (nonceb_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2 X3.  case (rem_2372 epsilon_mknows_current_p__type_10). clear  epsilon_mknows_current_p__type_10. intros. apply trans___type_10_nonceb_old_1;  tauto.
 clear  epsilon_mknows_current_p__type_10. tauto.
Defined.

Remark rem_2428 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2 X3:term, auto_knows_current (nonceb_old X1 X2 X3) -> auto___type_10 (nonceb_old X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2 X3. intro H. intros.
  elim (rem_481 X1 X2 X3 H);  intros.
  apply (rem_2427 epsilon_mknows_current_p__type_10 X1 X2 X3);  tauto.
Defined.

Remark rem_2429 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto___def_71 X1 -> auto___def_71 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2430 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_71 X1 -> auto___type_13 X2 -> auto___def_71 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_71 X1 -> auto___def_71 X1). tauto. exact (rem_2429 epsilon_mknows_current_p__type_10 X1).
Defined.

Remark rem_2431 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X2:term, auto___type_13 X2 -> auto___type_13 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2432 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_71 X1 -> auto___type_13 X2 -> auto___type_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___type_13 X2 -> auto___type_13 X2). tauto. exact (rem_2431 epsilon_mknows_current_p__type_10 X2).
Defined.

Remark rem_2433 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_71 X1 -> auto___type_13 X2 -> (auto___def_71 X1 /\ auto___type_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_71 X1). 2:apply (rem_2430 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  cut (auto___type_13 X2). 2:apply (rem_2432 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2434 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_71 X1 -> auto___type_13 X2 -> auto___type_10 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_2433 epsilon_mknows_current_p__type_10 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_10 A1 A2. intros. apply trans___type_10_crypt_1;  tauto.
 clear  epsilon_mknows_current_p__type_10 A1 A2. tauto.
Defined.

Remark rem_2435 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto___def_69 X1 -> auto___def_69 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2436 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_69 X1 -> auto___type_12 X2 -> auto___def_69 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_69 X1 -> auto___def_69 X1). tauto. exact (rem_2435 epsilon_mknows_current_p__type_10 X1).
Defined.

Remark rem_2437 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X2:term, auto___type_12 X2 -> auto___type_12 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2438 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_69 X1 -> auto___type_12 X2 -> auto___type_12 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___type_12 X2 -> auto___type_12 X2). tauto. exact (rem_2437 epsilon_mknows_current_p__type_10 X2).
Defined.

Remark rem_2439 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_69 X1 -> auto___type_12 X2 -> (auto___def_69 X1 /\ auto___type_12 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_69 X1). 2:apply (rem_2436 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  cut (auto___type_12 X2). 2:apply (rem_2438 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2440 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_69 X1 -> auto___type_12 X2 -> auto___type_10 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_2439 epsilon_mknows_current_p__type_10 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_10 A1 A2. intros. apply trans___type_10_crypt_2;  tauto.
 clear  epsilon_mknows_current_p__type_10 A1 A2. tauto.
Defined.

Remark rem_2441 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto___def_12 X1 -> auto___def_12 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2442 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_12 X1). tauto. exact (rem_2441 epsilon_mknows_current_p__type_10 X1).
Defined.

Remark rem_2443 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X2:term, auto___def_13 X2 -> auto___def_13 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2444 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_2443 epsilon_mknows_current_p__type_10 X2).
Defined.

Remark rem_2445 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> (auto___def_12 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_12 X1). 2:apply (rem_2442 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_2444 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2446 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___type_10 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_2445 epsilon_mknows_current_p__type_10 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_10 A1 A2. intros. apply trans___type_10_crypt_3;  tauto.
 clear  epsilon_mknows_current_p__type_10 A1 A2. tauto.
Defined.

Remark rem_2447 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto___def_61 X1 -> auto___def_61 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2448 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto___def_61 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_61 X1 -> auto___def_61 X1). tauto. exact (rem_2447 epsilon_mknows_current_p__type_10 X1).
Defined.

Remark rem_2449 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X2:term, auto___def_62 X2 -> auto___def_62 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2450 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto___def_62 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_62 X2 -> auto___def_62 X2). tauto. exact (rem_2449 epsilon_mknows_current_p__type_10 X2).
Defined.

Remark rem_2451 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> (auto___def_61 X1 /\ auto___def_62 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_61 X1). 2:apply (rem_2448 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  cut (auto___def_62 X2). 2:apply (rem_2450 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2452 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto___type_10 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_2451 epsilon_mknows_current_p__type_10 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_10 A1 A2. intros. apply trans___type_10_crypt_4;  tauto.
 clear  epsilon_mknows_current_p__type_10 A1 A2. tauto.
Defined.

Remark rem_2453 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto___def_22 X1 -> auto___def_22 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2454 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_22 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_22 X1 -> auto___def_22 X1). tauto. exact (rem_2453 epsilon_mknows_current_p__type_10 X1).
Defined.

Remark rem_2455 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X2:term, auto___def_23 X2 -> auto___def_23 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2456 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_2455 epsilon_mknows_current_p__type_10 X2).
Defined.

Remark rem_2457 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> (auto___def_22 X1 /\ auto___def_23 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_22 X1). 2:apply (rem_2454 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_2456 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2458 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___type_10 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_2457 epsilon_mknows_current_p__type_10 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_10 A1 A2. intros. apply trans___type_10_crypt_5;  tauto.
 clear  epsilon_mknows_current_p__type_10 A1 A2. tauto.
Defined.

Remark rem_2459 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1:term, auto___def_51 X1 -> auto___def_51 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2460 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto___def_52 X2 -> auto___def_51 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_51 X1 -> auto___def_51 X1). tauto. exact (rem_2459 epsilon_mknows_current_p__type_10 X1).
Defined.

Remark rem_2461 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X2:term, auto___def_52 X2 -> auto___def_52 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2462 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto___def_52 X2 -> auto___def_52 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.
  cut (auto___def_52 X2 -> auto___def_52 X2). tauto. exact (rem_2461 epsilon_mknows_current_p__type_10 X2).
Defined.

Remark rem_2463 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto___def_52 X2 -> (auto___def_51 X1 /\ auto___def_52 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  cut (auto___def_51 X1). 2:apply (rem_2460 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  cut (auto___def_52 X2). 2:apply (rem_2462 epsilon_mknows_current_p__type_10 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2464 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___def_51 X1 -> auto___def_52 X2 -> auto___type_10 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_2463 epsilon_mknows_current_p__type_10 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_10 A1 A2. intros. apply trans___type_10_crypt_6;  tauto.
 clear  epsilon_mknows_current_p__type_10 A1 A2. tauto.
Defined.

Remark rem_2465 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_10 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intros A1 A2.
  case (rem_2381 epsilon_mknows_current_p__type_10 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_10 A1 A2. intros. apply trans___type_10_crypt_7;  tauto.
 clear  epsilon_mknows_current_p__type_10 A1 A2. tauto.
Defined.

Remark rem_2466 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto_knows_current (crypt X1 X2) -> auto___type_10 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intro H. intros.
  elim (rem_312 X1 X2 H);  intros.
  apply (rem_2434 epsilon_mknows_current_p__type_10 X1 X2);  tauto.
  apply (rem_2440 epsilon_mknows_current_p__type_10 X1 X2);  tauto.
  apply (rem_2446 epsilon_mknows_current_p__type_10 X1 X2);  tauto.
  apply (rem_2452 epsilon_mknows_current_p__type_10 X1 X2);  tauto.
  apply (rem_2458 epsilon_mknows_current_p__type_10 X1 X2);  tauto.
  apply (rem_2464 epsilon_mknows_current_p__type_10 X1 X2);  tauto.
  apply (rem_2465 epsilon_mknows_current_p__type_10 X1 X2);  tauto.
Defined.

Remark rem_2467 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto___type_10 (noncea_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2.  case (rem_2372 epsilon_mknows_current_p__type_10). clear  epsilon_mknows_current_p__type_10. intros. apply trans___type_10_noncea_old_1;  tauto.
 clear  epsilon_mknows_current_p__type_10. tauto.
Defined.

Remark rem_2468 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> forall X1 X2:term, auto_knows_current (noncea_old X1 X2) -> auto___type_10 (noncea_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intros X1 X2. intro H. intros.
  elim (rem_522 X1 X2 H);  intros.
  apply (rem_2467 epsilon_mknows_current_p__type_10 X1 X2);  tauto.
Defined.

Remark rem_2469 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> auto___type_10 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10.  case (rem_2372 epsilon_mknows_current_p__type_10). clear  epsilon_mknows_current_p__type_10. intros. apply trans___type_10_server_1;  tauto.
 clear  epsilon_mknows_current_p__type_10. tauto.
Defined.

Remark rem_2470 : (forall X:term, auto_knows_current X -> auto___type_10 X)
    -> auto_knows_current server -> auto___type_10 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_10. intro H. intros.
  elim (rem_525 H);  intros.
  apply (rem_2469 epsilon_mknows_current_p__type_10);  tauto.
Defined.

Remark rem_2471 : forall X1:term, auto_knows_current X1 -> auto___type_10 X1. (* Induct. *)
Proof.
  fix epsilon_mknows_current_p__type_10 1.
  intro X. case X.
  exact (rem_2376 epsilon_mknows_current_p__type_10 ).
  exact (rem_2374 epsilon_mknows_current_p__type_10 ).
  intros X1 X2;  exact (rem_2383 epsilon_mknows_current_p__type_10 X1 X2).
  intros X1 X2;  exact (rem_2466 epsilon_mknows_current_p__type_10 X1 X2).
  exact (rem_2390 epsilon_mknows_current_p__type_10 ).
  intros X1 X2;  exact (rem_2409 epsilon_mknows_current_p__type_10 X1 X2).
  exact (rem_2388 epsilon_mknows_current_p__type_10 ).
  intros X1 X2;  exact (rem_2371 epsilon_mknows_current_p__type_10 X1 X2).
  intros X1 X2;  exact (rem_2468 epsilon_mknows_current_p__type_10 X1 X2).
  intros X1 X2 X3;  exact (rem_2426 epsilon_mknows_current_p__type_10 X1 X2 X3).
  intros X1 X2 X3;  exact (rem_2428 epsilon_mknows_current_p__type_10 X1 X2 X3).
   intro H. elim (rem_530  H).
   intro H. elim (rem_529  H).
  intros X1;  exact (rem_2386 epsilon_mknows_current_p__type_10 X1).
  exact (rem_2470 epsilon_mknows_current_p__type_10 ).
  intros X1 X2 X3. intro H. elim (rem_527 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_528 X1 X2 X3 H).
   intro H. elim (rem_531  H).
Qed.

Remark rem_2472 : forall X1 X2 X3:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto___type_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_current X1 -> auto___type_10 X1). tauto. exact (rem_2471 X1).
Qed.

Remark rem_2473 : forall X1 X2 X3:term, auto___def_50 X2 X1 X3 -> auto___type_10 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_535 X2 X1 X3 H);  intros.
  apply (rem_2472 X1 X2 X3);  tauto.
Qed.

Remark rem_2474 : forall X1 X2 X3:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_old X1 -> auto_knows_old X1). tauto. exact (rem_150 X1).
Qed.

Remark rem_2475 : forall X1 X2 X3:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_152 X2).
Qed.

Remark rem_2476 : forall X1 X2 X3:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_old X3 -> auto_knows_old X3). tauto. exact (rem_154 X3).
Qed.

Remark rem_2477 : forall X1 X2 X3:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> (auto_knows_old X1 /\ auto_knows_old X2 /\ auto_knows_old X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  cut (auto_knows_old X1). 2:apply (rem_2474 X1 X2 X3);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_2475 X1 X2 X3);  assumption.
  cut (auto_knows_old X3). 2:apply (rem_2476 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_2478 : forall X1 X2 X3:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto___def_19 (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  case (rem_2477 X1 X2 X3 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_19_session_old_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2479 : forall X1 X2 X3:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X3 -> auto___def_19 (session_old X1 X2 X3). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto___def_19 (session_old X1 X2 X3)). tauto. exact (rem_2478 X1 X2 X3).
Qed.

Remark rem_2480 : forall X1 X2 X3:term, auto___def_11 X1 X2 X3 -> auto___def_19 (session_old X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_147 X1 X2 X3 H);  intros.
  apply (rem_2479 X1 X2 X3);  tauto.
Qed.

Remark rem_2481 : forall X1 X2:term, auto___def_48 X2 -> auto___type_2 X1 -> auto___type_2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_2 X1 -> auto___type_2 X1). tauto. exact (rem_404 X1).
Qed.

Remark rem_2482 : forall X2:term, auto___def_48 X2 -> auto___def_48 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2483 : forall X1 X2:term, auto___def_48 X2 -> auto___type_2 X1 -> auto___def_48 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_48 X2 -> auto___def_48 X2). tauto. exact (rem_2482 X2).
Qed.

Remark rem_2484 : forall X1 X2:term, auto___def_48 X2 -> auto___type_2 X1 -> (auto___type_2 X1 /\ auto___def_48 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_2 X1). 2:apply (rem_2481 X1 X2);  assumption.
  cut (auto___def_48 X2). 2:apply (rem_2483 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2485 : forall X1 X2:term, auto___def_48 X2 -> auto___type_2 X1 -> auto___def_47 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2484 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_47_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2486 : (forall X:term, auto_agent X -> auto___type_2 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p__type_2.  tauto.
Defined.

Remark rem_2487 : (forall X:term, auto_agent X -> auto___type_2 X)
    -> auto___type_2 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_2.  case (rem_2486 epsilon_magent_p__type_2). clear  epsilon_magent_p__type_2. intros. apply trans___type_2_bob_1;  tauto.
 clear  epsilon_magent_p__type_2. tauto.
Defined.

Remark rem_2488 : auto_agent bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2489 : (forall X:term, auto_agent X -> auto___type_2 X)
    -> auto_agent bob -> auto___type_2 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_2. intro H. intros.
  elim (rem_2488 H);  intros.
  apply (rem_2487 epsilon_magent_p__type_2);  tauto.
Defined.

Remark rem_2490 : (forall X:term, auto_agent X -> auto___type_2 X)
    -> auto___type_2 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_2.  case (rem_2486 epsilon_magent_p__type_2). clear  epsilon_magent_p__type_2. intros. apply trans___type_2_alice_1;  tauto.
 clear  epsilon_magent_p__type_2. tauto.
Defined.

Remark rem_2491 : auto_agent alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2492 : (forall X:term, auto_agent X -> auto___type_2 X)
    -> auto_agent alice -> auto___type_2 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_2. intro H. intros.
  elim (rem_2491 H);  intros.
  apply (rem_2490 epsilon_magent_p__type_2);  tauto.
Defined.

Remark rem_2493 : (forall X:term, auto_agent X -> auto___type_2 X)
    -> auto___type_2 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_2.  case (rem_2486 epsilon_magent_p__type_2). clear  epsilon_magent_p__type_2. intros. apply trans___type_2_i_1;  tauto.
 clear  epsilon_magent_p__type_2. tauto.
Defined.

Remark rem_2494 : auto_agent i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2495 : (forall X:term, auto_agent X -> auto___type_2 X)
    -> auto_agent i -> auto___type_2 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_2. intro H. intros.
  elim (rem_2494 H);  intros.
  apply (rem_2493 epsilon_magent_p__type_2);  tauto.
Defined.

Remark rem_2496 : (forall X:term, auto_agent X -> auto___type_2 X)
    -> auto___type_2 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_2.  case (rem_2486 epsilon_magent_p__type_2). clear  epsilon_magent_p__type_2. intros. apply trans___type_2_server_1;  tauto.
 clear  epsilon_magent_p__type_2. tauto.
Defined.

Remark rem_2497 : auto_agent server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2498 : (forall X:term, auto_agent X -> auto___type_2 X)
    -> auto_agent server -> auto___type_2 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_2. intro H. intros.
  elim (rem_2497 H);  intros.
  apply (rem_2496 epsilon_magent_p__type_2);  tauto.
Defined.

Remark rem_2499 : forall X1 X2:term, auto_agent (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2500 : forall X1 X2 X3:term, auto_agent (session_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2501 : forall X1 X2:term, auto_agent (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2502 : forall X1:term, auto_agent (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2503 : auto_agent nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2504 : forall X1 X2:term, auto_agent (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2505 : forall X1 X2 X3:term, auto_agent (nonceb_current X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2506 : forall X1 X2 X3:term, auto_agent (nonceb_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2507 : forall X1 X2:term, auto_agent (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2508 : forall X1 X2 X3:term, auto_agent (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2509 : forall X1 X2:term, auto_agent (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2510 : auto_agent pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2511 : auto_agent prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2512 : auto_agent sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2513 : forall X1:term, auto_agent X1 -> auto___type_2 X1. (* Induct. *)
Proof.
  fix epsilon_magent_p__type_2 1.
  intro X. case X.
  exact (rem_2492 epsilon_magent_p__type_2 ).
  exact (rem_2489 epsilon_magent_p__type_2 ).
  intros X1 X2. intro H. elim (rem_2501 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2507 X1 X2 H).
  exact (rem_2495 epsilon_magent_p__type_2 ).
  intros X1 X2. intro H. elim (rem_2504 X1 X2 H).
   intro H. elim (rem_2503  H).
  intros X1 X2. intro H. elim (rem_2499 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2509 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_2505 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2506 X1 X2 X3 H).
   intro H. elim (rem_2511  H).
   intro H. elim (rem_2510  H).
  intros X1. intro H. elim (rem_2502 X1 H).
  exact (rem_2498 epsilon_magent_p__type_2 ).
  intros X1 X2 X3. intro H. elim (rem_2500 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2508 X1 X2 X3 H).
   intro H. elim (rem_2512  H).
Qed.

Remark rem_2514 : forall X1 X2 X3:term, auto___def_55 X1 -> auto___type_10 X2 -> auto___type_11 X3 -> auto___type_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_55 X1 -> auto___type_12 X1). tauto. exact (rem_1031 X1).
Qed.

Remark rem_2515 : forall X1 X2 X3:term, auto___type_11 X2 -> auto___type_10 X3 -> auto___def_55 X1 -> auto___type_12 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X3 X2.
  cut (auto___def_55 X1 -> auto___type_10 X2 -> auto___type_11 X3 -> auto___type_12 X1). tauto. exact (rem_2514 X1 X2 X3).
Qed.

Remark rem_2516 : (forall X:term, auto___def_16 X -> auto___type_12 X)
    -> forall X1:term, auto___def_18 X1 -> auto___def_18 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2517 : (forall X:term, auto___def_16 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_18 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_16_p__type_12. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_18 X1). tauto. exact (rem_2516 epsilon_m__def_16_p__type_12 X1).
Defined.

Remark rem_2518 : (forall X:term, auto___def_16 X -> auto___type_12 X)
    -> forall X2:term, auto___def_19 X2 -> auto___def_19 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2519 : (forall X:term, auto___def_16 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_19 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_16_p__type_12. intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_19 X2). tauto. exact (rem_2518 epsilon_m__def_16_p__type_12 X2).
Defined.

Remark rem_2520 : (forall X:term, auto___def_16 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> (auto___def_18 X1 /\ auto___def_19 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_16_p__type_12. intros X1 X2. intros A1 A2.
  cut (auto___def_18 X1). 2:apply (rem_2517 epsilon_m__def_16_p__type_12 X1 X2);  assumption.
  cut (auto___def_19 X2). 2:apply (rem_2519 epsilon_m__def_16_p__type_12 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2521 : (forall X:term, auto___def_16 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___type_12 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_16_p__type_12. intros X1 X2. intros A1 A2.
  case (rem_2520 epsilon_m__def_16_p__type_12 X1 X2 A1 A2). clear  epsilon_m__def_16_p__type_12 A1 A2. intros. apply trans___type_12_key_2;  tauto.
 clear  epsilon_m__def_16_p__type_12 A1 A2. tauto.
Defined.

Remark rem_2522 : (forall X:term, auto___def_16 X -> auto___type_12 X)
    -> forall X1 X2:term, auto___def_16 (key X1 X2) -> auto___type_12 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_16_p__type_12. intros X1 X2. intro H. intros.
  elim (rem_7 X1 X2 H);  intros.
  apply (rem_2521 epsilon_m__def_16_p__type_12 X1 X2);  tauto.
Defined.

Remark rem_2523 : forall X1:term, auto___def_16 X1 -> auto___type_12 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_16_p__type_12 1.
  intro X. case X.
   intro H. elim (rem_12  H).
   intro H. elim (rem_10  H).
  intros X1 X2. intro H. elim (rem_13 X1 X2 H).
  intros X1 X2. intro H. elim (rem_19 X1 X2 H).
   intro H. elim (rem_16  H).
  intros X1 X2;  exact (rem_2522 epsilon_m__def_16_p__type_12 X1 X2).
   intro H. elim (rem_15  H).
  intros X1 X2. intro H. elim (rem_9 X1 X2 H).
  intros X1 X2. intro H. elim (rem_21 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_17 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_18 X1 X2 X3 H).
   intro H. elim (rem_24  H).
   intro H. elim (rem_22  H).
  intros X1. intro H. elim (rem_14 X1 H).
   intro H. elim (rem_23  H).
  intros X1 X2 X3. intro H. elim (rem_11 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_20 X1 X2 X3 H).
   intro H. elim (rem_25  H).
Qed.

Remark rem_2524 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto___type_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_16 X1 -> auto___type_12 X1). tauto. exact (rem_2523 X1).
Qed.

Remark rem_2525 : forall X1 X2 X3:term, auto___type_5 X2 -> auto___type_4 X3 -> auto___def_16 X1 -> auto___type_12 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X3 X2.
  cut (auto___def_16 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto___type_12 X1). tauto. exact (rem_2524 X1 X2 X3).
Qed.

Remark rem_2526 : forall X1 X2 X3:term, auto___def_68 X2 X3 X1 -> auto___type_12 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_275 X2 X3 X1 H);  intros.
  apply (rem_2515 X1 X2 X3);  tauto.
  apply (rem_2525 X1 X2 X3);  tauto.
Qed.

Remark rem_2527 : forall X1 X2 X3:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current nil -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_1506 X1).
Qed.

Remark rem_2528 : forall X1 X2 X3:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current nil -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_306 X2).
Qed.

Remark rem_2529 : forall X3:term, auto_knows_current X3 -> auto_knows_current X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2530 : forall X1 X2 X3:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current nil -> auto_knows_current X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_current X3 -> auto_knows_current X3). tauto. exact (rem_2529 X3).
Qed.

Remark rem_2531 : forall X1 X2 X3:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current nil -> (auto_knows_current X1 /\ auto_knows_current X2 /\ auto_knows_current X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  cut (auto_knows_current X1). 2:apply (rem_2527 X1 X2 X3);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2528 X1 X2 X3);  assumption.
  cut (auto_knows_current X3). 2:apply (rem_2530 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_2532 : forall X1 X2 X3:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current nil -> auto___def_50 X1 X2 X3. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  case (rem_2531 X1 X2 X3 A1 A2 A3 A4). clear  A1 A2 A3 A4. intros. apply trans___def_50_1;  tauto.
 clear  A1 A2 A3 A4. tauto.
Qed.

Remark rem_2533 : forall X1 X2 X3:term, auto_knows_current X3 -> auto_knows_current nil -> auto_knows_current X2 -> auto_knows_current X1 -> auto___def_50 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current nil -> auto___def_50 X1 X2 X3). tauto. exact (rem_2532 X1 X2 X3).
Qed.

Remark rem_2534 : forall X1 X2 X3:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (cons X3 nil) -> auto___def_50 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1 H2. intro H. intros.
  elim (rem_431 X3 nil H);  intros.
  apply (rem_2533 X1 X2 X3);  tauto.
Qed.

Remark rem_2535 : forall X1 X2 X3:term, auto_knows_current X2 -> auto_knows_current (cons X3 nil) -> auto_knows_current X1 -> auto___def_50 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (cons X3 nil) -> auto___def_50 X1 X2 X3). tauto. exact (rem_2534 X1 X2 X3).
Qed.

Remark rem_2536 : forall X1 X2 X3:term, auto_knows_current X1 -> auto_knows_current (cons X2 (cons X3 nil)) -> auto___def_50 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_431 X2 (cons X3 nil) H);  intros.
  apply (rem_2535 X1 X2 X3);  tauto.
Qed.

Remark rem_2537 : forall X1 X2 X3:term, auto_knows_current (cons X1 (cons X2 (cons X3 nil))) -> auto___def_50 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_431 X1 (cons X2 (cons X3 nil)) H);  intros.
  apply (rem_2536 X1 X2 X3);  tauto.
Qed.

Remark rem_2538 : forall X1:term, auto___def_35 prv -> auto___def_2 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_35 prv -> False). tauto.
  exact (rem_177).
Qed.

Remark rem_2539 : forall X1:term, auto___def_35 prv -> auto___type_8 X1 -> auto___def_2 X1. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1. intros. apply (rem_2538 X1);  assumption.
Qed.

Remark rem_2540 : (forall X:term, auto___def_37 X -> auto___def_2 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_37_p__def_2.  tauto.
Defined.

Remark rem_2541 : (forall X:term, auto___def_37 X -> auto___def_2 X)
    -> auto___def_2 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_37_p__def_2.  case (rem_2540 epsilon_m__def_37_p__def_2). clear  epsilon_m__def_37_p__def_2. intros. apply trans___def_2_i_1;  tauto.
 clear  epsilon_m__def_37_p__def_2. tauto.
Defined.

Remark rem_2542 : (forall X:term, auto___def_37 X -> auto___def_2 X)
    -> auto___def_37 i -> auto___def_2 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_37_p__def_2. intro H. intros.
  elim (rem_1612 H);  intros.
  apply (rem_2541 epsilon_m__def_37_p__def_2);  tauto.
Defined.

Remark rem_2543 : forall X1:term, auto___def_37 X1 -> auto___def_2 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_37_p__def_2 1.
  intro X. case X.
   intro H. elim (rem_1617  H).
   intro H. elim (rem_1615  H).
  intros X1 X2. intro H. elim (rem_243 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1623 X1 X2 H).
  exact (rem_2542 epsilon_m__def_37_p__def_2 ).
  intros X1 X2. intro H. elim (rem_1620 X1 X2 H).
   intro H. elim (rem_1619  H).
  intros X1 X2. intro H. elim (rem_1614 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1625 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1621 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1622 X1 X2 X3 H).
   intro H. elim (rem_1628  H).
   intro H. elim (rem_1626  H).
  intros X1. intro H. elim (rem_1618 X1 H).
   intro H. elim (rem_1627  H).
  intros X1 X2 X3. intro H. elim (rem_1616 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1624 X1 X2 X3 H).
   intro H. elim (rem_1629  H).
Qed.

Remark rem_2544 : forall X1:term, auto___def_36 prv -> auto___def_37 X1 -> auto___def_2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1.
  cut (auto___def_37 X1 -> auto___def_2 X1). tauto. exact (rem_2543 X1).
Qed.

Remark rem_2545 : forall X1:term, auto_knows_old (key prv X1) -> auto___def_2 X1. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_97 prv X1 H);  intros.
  apply (rem_2539 X1);  tauto.
  apply (rem_2544 X1);  tauto.
Qed.

Remark rem_2546 : forall X1 X2:term, auto___def_65 X2 -> auto___type_10 X1 -> auto___type_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_10 X1 -> auto___type_10 X1). tauto. exact (rem_2358 X1).
Qed.

Remark rem_2547 : forall X1 X2:term, auto___def_65 X2 -> auto___type_10 X1 -> auto___def_65 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_65 X2 -> auto___def_65 X2). tauto. exact (rem_1603 X2).
Qed.

Remark rem_2548 : forall X1 X2:term, auto___def_65 X2 -> auto___type_10 X1 -> (auto___type_10 X1 /\ auto___def_65 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_10 X1). 2:apply (rem_2546 X1 X2);  assumption.
  cut (auto___def_65 X2). 2:apply (rem_2547 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2549 : forall X1 X2:term, auto___def_65 X2 -> auto___type_10 X1 -> auto___def_64 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2548 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_64_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2550 : auto___def_35 pub. (* Deduce positive atom. *)
Proof.
   case rem_321. intros. apply trans___def_35_pub_1;  tauto.
 tauto.
Qed.

Remark rem_2551 : forall X1:term, auto_knows_current (key pub X1) -> auto___def_44 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___def_44_1. Qed.

Remark rem_2552 : forall X1 X2:term, auto___def_60 X2 -> auto___type_11 X1 -> auto___type_11 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_11 X1 -> auto___type_11 X1). tauto. exact (rem_829 X1).
Qed.

Remark rem_2553 : forall X1 X2:term, auto___def_60 X2 -> auto___type_11 X1 -> auto___def_60 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_60 X2 -> auto___def_60 X2). tauto. exact (rem_316 X2).
Qed.

Remark rem_2554 : forall X1 X2:term, auto___def_60 X2 -> auto___type_11 X1 -> (auto___type_11 X1 /\ auto___def_60 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_11 X1). 2:apply (rem_2552 X1 X2);  assumption.
  cut (auto___def_60 X2). 2:apply (rem_2553 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2555 : forall X1 X2:term, auto___def_60 X2 -> auto___type_11 X1 -> auto___def_63 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2554 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_63_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2556 : auto___def_60 nil. (* Deduce positive atom. *)
Proof.
   case rem_321. intros. apply trans___def_60_nil_1;  tauto.
 tauto.
Qed.

Remark rem_2557 : forall X1:term, auto___def_12 X1 -> auto___def_12 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2558 : forall X1 X2:term, auto___def_12 X1 -> auto___def_18 sym -> auto___def_29 X2 -> auto___def_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_12 X1). tauto. exact (rem_2557 X1).
Qed.

Remark rem_2559 : forall X1 X2:term, auto___def_12 X1 -> auto___def_18 sym -> auto___def_29 X2 -> auto___def_29 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_29 X2 -> auto___def_29 X2). tauto. exact (rem_41 X2).
Qed.

Remark rem_2560 : forall X1 X2:term, auto___def_12 X1 -> auto___def_18 sym -> auto___def_29 X2 -> (auto___def_12 X1 /\ auto___def_29 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_12 X1). 2:apply (rem_2558 X1 X2);  assumption.
  cut (auto___def_29 X2). 2:apply (rem_2559 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2561 : forall X1 X2:term, auto___def_12 X1 -> auto___def_18 sym -> auto___def_29 X2 -> auto___def_5 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_2560 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_5_3;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2562 : forall X1 X2:term, auto___def_18 sym -> auto___def_29 X2 -> auto___def_12 X1 -> auto___def_5 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_18 sym -> auto___def_29 X2 -> auto___def_5 X1 X2). tauto. exact (rem_2561 X1 X2).
Qed.

Remark rem_2563 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 (key sym X2) -> auto___def_5 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_167 sym X2 H);  intros.
  apply (rem_2562 X1 X2);  tauto.
Qed.

Remark rem_2564 : forall X1:term, auto___def_34 X1 -> auto___def_34 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2565 : forall X1 X2:term, auto___def_18 sym -> auto___def_19 X2 -> auto___def_34 X1 -> auto___def_34 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_34 X1 -> auto___def_34 X1). tauto. exact (rem_2564 X1).
Qed.

Remark rem_2566 : forall X1 X2:term, auto___def_18 sym -> auto___def_19 X2 -> auto___def_34 X1 -> auto___def_19 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_19 X2). tauto. exact (rem_957 X2).
Qed.

Remark rem_2567 : forall X1 X2:term, auto___def_18 sym -> auto___def_19 X2 -> auto___def_34 X1 -> (auto___def_34 X1 /\ auto___def_19 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_34 X1). 2:apply (rem_2565 X1 X2);  assumption.
  cut (auto___def_19 X2). 2:apply (rem_2566 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2568 : forall X1 X2:term, auto___def_18 sym -> auto___def_19 X2 -> auto___def_34 X1 -> auto___def_5 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_2567 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_5_2;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2569 : forall X1 X2:term, auto___def_34 X1 -> auto___type_7 (key sym X2) -> auto___def_5 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_170 sym X2 H);  intros.
  apply (rem_2568 X1 X2);  tauto.
Qed.

Remark rem_2570 : forall X1:term, auto___def_22 X1 -> auto___def_22 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2571 : forall X1 X2:term, auto___def_18 sym -> auto___def_22 X1 -> auto___def_25 X2 -> auto___def_22 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_22 X1 -> auto___def_22 X1). tauto. exact (rem_2570 X1).
Qed.

Remark rem_2572 : forall X2:term, auto___def_25 X2 -> auto___def_25 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2573 : forall X1 X2:term, auto___def_18 sym -> auto___def_22 X1 -> auto___def_25 X2 -> auto___def_25 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_25 X2 -> auto___def_25 X2). tauto. exact (rem_2572 X2).
Qed.

Remark rem_2574 : forall X1 X2:term, auto___def_18 sym -> auto___def_22 X1 -> auto___def_25 X2 -> (auto___def_22 X1 /\ auto___def_25 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_22 X1). 2:apply (rem_2571 X1 X2);  assumption.
  cut (auto___def_25 X2). 2:apply (rem_2573 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2575 : forall X1 X2:term, auto___def_18 sym -> auto___def_22 X1 -> auto___def_25 X2 -> auto___def_5 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_2574 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_5_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2576 : forall X1 X2:term, auto___def_18 sym -> auto___def_25 X2 -> auto___def_22 X1 -> auto___def_5 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_18 sym -> auto___def_22 X1 -> auto___def_25 X2 -> auto___def_5 X1 X2). tauto. exact (rem_2575 X1 X2).
Qed.

Remark rem_2577 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 (key sym X2) -> auto___def_5 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_174 sym X2 H);  intros.
  apply (rem_2576 X1 X2);  tauto.
Qed.

Remark rem_2578 : forall X1 X2:term, auto___def_35 sym -> auto_knows_old X1 -> auto___def_5 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_35 sym -> False). tauto.
  exact (rem_240).
Qed.

Remark rem_2579 : forall X1 X2:term, auto___def_35 sym -> auto___type_8 X2 -> auto_knows_old X1 -> auto___def_5 X1 X2. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2. intros. apply (rem_2578 X1 X2);  assumption.
Qed.

Remark rem_2580 : forall X1 X2:term, auto___def_36 sym -> auto___def_37 X2 -> auto_knows_old X1 -> auto___def_5 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_36 sym -> False). tauto.
  exact (rem_1054).
Qed.

Remark rem_2581 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old (key sym X2) -> auto___def_5 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_97 sym X2 H);  intros.
  apply (rem_2579 X1 X2);  tauto.
  apply (rem_2580 X1 X2);  tauto.
Qed.

Remark rem_2582 : forall X1:term, auto___def_32 X1 -> auto___def_32 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2583 : forall X1 X2:term, auto___def_18 sym -> auto___def_19 X2 -> auto___def_32 X1 -> auto___def_32 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_32 X1 -> auto___def_32 X1). tauto. exact (rem_2582 X1).
Qed.

Remark rem_2584 : forall X1 X2:term, auto___def_18 sym -> auto___def_19 X2 -> auto___def_32 X1 -> auto___def_19 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_19 X2). tauto. exact (rem_957 X2).
Qed.

Remark rem_2585 : forall X1 X2:term, auto___def_18 sym -> auto___def_19 X2 -> auto___def_32 X1 -> (auto___def_32 X1 /\ auto___def_19 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_32 X1). 2:apply (rem_2583 X1 X2);  assumption.
  cut (auto___def_19 X2). 2:apply (rem_2584 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2586 : forall X1 X2:term, auto___def_18 sym -> auto___def_19 X2 -> auto___def_32 X1 -> auto___def_5 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_2585 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_5_4;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2587 : forall X1 X2:term, auto___def_32 X1 -> auto___type_6 (key sym X2) -> auto___def_5 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_187 sym X2 H);  intros.
  apply (rem_2586 X1 X2);  tauto.
Qed.

Remark rem_2588 : forall X1 X2:term, auto_knows_old (crypt X1 (key sym X2)) -> auto___def_5 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_124 X1 (key sym X2) H);  intros.
  apply (rem_2563 X1 X2);  tauto.
  apply (rem_2569 X1 X2);  tauto.
  apply (rem_2577 X1 X2);  tauto.
  apply (rem_2581 X1 X2);  tauto.
  apply (rem_2587 X1 X2);  tauto.
Qed.

Remark rem_2589 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p__type_1.  tauto.
Defined.

Remark rem_2590 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto___type_1 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_1.  case (rem_2589 epsilon_magent_p__type_1). clear  epsilon_magent_p__type_1. intros. apply trans___type_1_bob_1;  tauto.
 clear  epsilon_magent_p__type_1. tauto.
Defined.

Remark rem_2591 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto_agent bob -> auto___type_1 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_1. intro H. intros.
  elim (rem_2488 H);  intros.
  apply (rem_2590 epsilon_magent_p__type_1);  tauto.
Defined.

Remark rem_2592 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto___type_1 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_1.  case (rem_2589 epsilon_magent_p__type_1). clear  epsilon_magent_p__type_1. intros. apply trans___type_1_alice_1;  tauto.
 clear  epsilon_magent_p__type_1. tauto.
Defined.

Remark rem_2593 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto_agent alice -> auto___type_1 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_1. intro H. intros.
  elim (rem_2491 H);  intros.
  apply (rem_2592 epsilon_magent_p__type_1);  tauto.
Defined.

Remark rem_2594 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto___type_1 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_1.  case (rem_2589 epsilon_magent_p__type_1). clear  epsilon_magent_p__type_1. intros. apply trans___type_1_i_1;  tauto.
 clear  epsilon_magent_p__type_1. tauto.
Defined.

Remark rem_2595 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto_agent i -> auto___type_1 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_1. intro H. intros.
  elim (rem_2494 H);  intros.
  apply (rem_2594 epsilon_magent_p__type_1);  tauto.
Defined.

Remark rem_2596 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto___type_1 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_1.  case (rem_2589 epsilon_magent_p__type_1). clear  epsilon_magent_p__type_1. intros. apply trans___type_1_server_1;  tauto.
 clear  epsilon_magent_p__type_1. tauto.
Defined.

Remark rem_2597 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto_agent server -> auto___type_1 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_1. intro H. intros.
  elim (rem_2497 H);  intros.
  apply (rem_2596 epsilon_magent_p__type_1);  tauto.
Defined.

Remark rem_2598 : forall X1:term, auto_agent X1 -> auto___type_1 X1. (* Induct. *)
Proof.
  fix epsilon_magent_p__type_1 1.
  intro X. case X.
  exact (rem_2593 epsilon_magent_p__type_1 ).
  exact (rem_2591 epsilon_magent_p__type_1 ).
  intros X1 X2. intro H. elim (rem_2501 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2507 X1 X2 H).
  exact (rem_2595 epsilon_magent_p__type_1 ).
  intros X1 X2. intro H. elim (rem_2504 X1 X2 H).
   intro H. elim (rem_2503  H).
  intros X1 X2. intro H. elim (rem_2499 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2509 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_2505 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2506 X1 X2 X3 H).
   intro H. elim (rem_2511  H).
   intro H. elim (rem_2510  H).
  intros X1. intro H. elim (rem_2502 X1 H).
  exact (rem_2597 epsilon_magent_p__type_1 ).
  intros X1 X2 X3. intro H. elim (rem_2500 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2508 X1 X2 X3 H).
   intro H. elim (rem_2512  H).
Qed.

Remark rem_2599 : forall X1 X2 X3:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_1506 X1).
Qed.

Remark rem_2600 : forall X1 X2 X3:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_306 X2).
Qed.

Remark rem_2601 : forall X1 X2 X3:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_current X3 -> auto_knows_current X3). tauto. exact (rem_2529 X3).
Qed.

Remark rem_2602 : forall X1 X2 X3:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> (auto_knows_current X1 /\ auto_knows_current X2 /\ auto_knows_current X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  cut (auto_knows_current X1). 2:apply (rem_2599 X1 X2 X3);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2600 X1 X2 X3);  assumption.
  cut (auto_knows_current X3). 2:apply (rem_2601 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_2603 : forall X1 X2 X3:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto___def_58 (session_current X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  case (rem_2602 X1 X2 X3 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_58_session_current_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2604 : forall X1 X2 X3:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X3 -> auto___def_58 (session_current X1 X2 X3). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto___def_58 (session_current X1 X2 X3)). tauto. exact (rem_2603 X1 X2 X3).
Qed.

Remark rem_2605 : forall X1 X2 X3:term, auto___def_50 X1 X2 X3 -> auto___def_58 (session_current X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_535 X1 X2 X3 H);  intros.
  apply (rem_2604 X1 X2 X3);  tauto.
Qed.

Remark rem_2606 : forall X1 X2:term, auto___def_55 X1 -> auto___def_63 X2 -> auto___def_55 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_55 X1 -> auto___def_55 X1). tauto. exact (rem_258 X1).
Qed.

Remark rem_2607 : forall X2:term, auto___def_63 X2 -> auto___def_63 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2608 : forall X1 X2:term, auto___def_55 X1 -> auto___def_63 X2 -> auto___def_63 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_63 X2 -> auto___def_63 X2). tauto. exact (rem_2607 X2).
Qed.

Remark rem_2609 : forall X1 X2:term, auto___def_55 X1 -> auto___def_63 X2 -> (auto___def_55 X1 /\ auto___def_63 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_55 X1). 2:apply (rem_2606 X1 X2);  assumption.
  cut (auto___def_63 X2). 2:apply (rem_2608 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2610 : forall X1 X2:term, auto___def_55 X1 -> auto___def_63 X2 -> auto___def_61 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2609 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_61_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2611 : forall X1 X2:term, auto___def_63 X2 -> auto___def_55 X1 -> auto___def_61 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_55 X1 -> auto___def_63 X2 -> auto___def_61 (cons X1 X2)). tauto. exact (rem_2610 X1 X2).
Qed.

Remark rem_2612 : auto___def_21 nil. (* Deduce positive atom. *)
Proof.
   case rem_321. intros. apply trans___def_21_nil_1;  tauto.
 tauto.
Qed.

Remark rem_2613 : forall X1 X2:term, auto___def_57 sym -> auto___def_58 X2 -> auto___def_71 X1 -> auto___def_71 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_71 X1 -> auto___def_71 X1). tauto. exact (rem_738 X1).
Qed.

Remark rem_2614 : forall X1 X2:term, auto___def_57 sym -> auto___def_58 X2 -> auto___def_71 X1 -> auto___def_58 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_58 X2 -> auto___def_58 X2). tauto. exact (rem_48 X2).
Qed.

Remark rem_2615 : forall X1 X2:term, auto___def_57 sym -> auto___def_58 X2 -> auto___def_71 X1 -> (auto___def_71 X1 /\ auto___def_58 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_71 X1). 2:apply (rem_2613 X1 X2);  assumption.
  cut (auto___def_58 X2). 2:apply (rem_2614 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2616 : forall X1 X2:term, auto___def_57 sym -> auto___def_58 X2 -> auto___def_71 X1 -> auto___def_45 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_2615 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_45_6;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2617 : forall X1 X2:term, auto___def_71 X1 -> auto___type_13 (key sym X2) -> auto___def_45 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_280 sym X2 H);  intros.
  apply (rem_2616 X1 X2);  tauto.
Qed.

Remark rem_2618 : forall X1 X2:term, auto___def_57 sym -> auto___def_58 X2 -> auto___def_69 X1 -> auto___def_69 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_69 X1 -> auto___def_69 X1). tauto. exact (rem_688 X1).
Qed.

Remark rem_2619 : forall X1 X2:term, auto___def_57 sym -> auto___def_58 X2 -> auto___def_69 X1 -> auto___def_58 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_58 X2 -> auto___def_58 X2). tauto. exact (rem_48 X2).
Qed.

Remark rem_2620 : forall X1 X2:term, auto___def_57 sym -> auto___def_58 X2 -> auto___def_69 X1 -> (auto___def_69 X1 /\ auto___def_58 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_69 X1). 2:apply (rem_2618 X1 X2);  assumption.
  cut (auto___def_58 X2). 2:apply (rem_2619 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2621 : forall X1 X2:term, auto___def_57 sym -> auto___def_58 X2 -> auto___def_69 X1 -> auto___def_45 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_2620 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_45_4;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2622 : forall X1 X2:term, auto___def_18 sym -> auto___def_19 X2 -> auto___def_69 X1 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_69 X1 -> auto_knows_current X1). tauto. exact (rem_1677 X1).
Qed.

Remark rem_2623 : forall X1 X2:term, auto___def_18 sym -> auto___def_19 X2 -> auto___def_69 X1 -> auto___def_40 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_40 X2). tauto. exact (rem_1811 X2).
Qed.

Remark rem_2624 : forall X1 X2:term, auto___def_18 sym -> auto___def_19 X2 -> auto___def_69 X1 -> (auto_knows_current X1 /\ auto___def_40 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto_knows_current X1). 2:apply (rem_2622 X1 X2);  assumption.
  cut (auto___def_40 X2). 2:apply (rem_2623 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2625 : forall X1 X2:term, auto___def_18 sym -> auto___def_19 X2 -> auto___def_69 X1 -> auto___def_45 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_2624 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_45_5;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2626 : forall X1 X2:term, auto___def_69 X1 -> auto___type_12 (key sym X2) -> auto___def_45 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_284 sym X2 H);  intros.
  apply (rem_2621 X1 X2);  tauto.
  apply (rem_2625 X1 X2);  tauto.
Qed.

Remark rem_2627 : forall X1 X2:term, auto___def_12 X1 -> auto___def_18 sym -> auto___def_29 X2 -> auto___def_45 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_2560 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_45_3;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2628 : forall X1 X2:term, auto___def_18 sym -> auto___def_29 X2 -> auto___def_12 X1 -> auto___def_45 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_18 sym -> auto___def_29 X2 -> auto___def_45 X1 X2). tauto. exact (rem_2627 X1 X2).
Qed.

Remark rem_2629 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 (key sym X2) -> auto___def_45 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_167 sym X2 H);  intros.
  apply (rem_2628 X1 X2);  tauto.
Qed.

Remark rem_2630 : forall X1:term, auto___def_61 X1 -> auto___def_61 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2631 : forall X1 X2:term, auto___def_57 sym -> auto___def_61 X1 -> auto___def_64 X2 -> auto___def_61 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_61 X1 -> auto___def_61 X1). tauto. exact (rem_2630 X1).
Qed.

Remark rem_2632 : forall X2:term, auto___def_64 X2 -> auto___def_64 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2633 : forall X1 X2:term, auto___def_57 sym -> auto___def_61 X1 -> auto___def_64 X2 -> auto___def_64 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_64 X2 -> auto___def_64 X2). tauto. exact (rem_2632 X2).
Qed.

Remark rem_2634 : forall X1 X2:term, auto___def_57 sym -> auto___def_61 X1 -> auto___def_64 X2 -> (auto___def_61 X1 /\ auto___def_64 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_61 X1). 2:apply (rem_2631 X1 X2);  assumption.
  cut (auto___def_64 X2). 2:apply (rem_2633 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2635 : forall X1 X2:term, auto___def_57 sym -> auto___def_61 X1 -> auto___def_64 X2 -> auto___def_45 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_2634 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_45_7;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2636 : forall X1 X2:term, auto___def_57 sym -> auto___def_64 X2 -> auto___def_61 X1 -> auto___def_45 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_57 sym -> auto___def_61 X1 -> auto___def_64 X2 -> auto___def_45 X1 X2). tauto. exact (rem_2635 X1 X2).
Qed.

Remark rem_2637 : forall X1 X2:term, auto___def_61 X1 -> auto___def_62 (key sym X2) -> auto___def_45 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_291 sym X2 H);  intros.
  apply (rem_2636 X1 X2);  tauto.
Qed.

Remark rem_2638 : forall X1 X2:term, auto___def_18 sym -> auto___def_22 X1 -> auto___def_25 X2 -> auto___def_45 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_2574 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_45_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2639 : forall X1 X2:term, auto___def_18 sym -> auto___def_25 X2 -> auto___def_22 X1 -> auto___def_45 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_18 sym -> auto___def_22 X1 -> auto___def_25 X2 -> auto___def_45 X1 X2). tauto. exact (rem_2638 X1 X2).
Qed.

Remark rem_2640 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 (key sym X2) -> auto___def_45 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_174 sym X2 H);  intros.
  apply (rem_2639 X1 X2);  tauto.
Qed.

Remark rem_2641 : forall X1:term, auto___def_51 X1 -> auto___def_51 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2642 : forall X1 X2:term, auto___def_51 X1 -> auto___def_57 sym -> auto___def_66 X2 -> auto___def_51 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_51 X1 -> auto___def_51 X1). tauto. exact (rem_2641 X1).
Qed.

Remark rem_2643 : forall X1 X2:term, auto___def_51 X1 -> auto___def_57 sym -> auto___def_66 X2 -> auto___def_66 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_66 X2 -> auto___def_66 X2). tauto. exact (rem_1597 X2).
Qed.

Remark rem_2644 : forall X1 X2:term, auto___def_51 X1 -> auto___def_57 sym -> auto___def_66 X2 -> (auto___def_51 X1 /\ auto___def_66 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_51 X1). 2:apply (rem_2642 X1 X2);  assumption.
  cut (auto___def_66 X2). 2:apply (rem_2643 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2645 : forall X1 X2:term, auto___def_51 X1 -> auto___def_57 sym -> auto___def_66 X2 -> auto___def_45 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_2644 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_45_2;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2646 : forall X1 X2:term, auto___def_57 sym -> auto___def_66 X2 -> auto___def_51 X1 -> auto___def_45 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_51 X1 -> auto___def_57 sym -> auto___def_66 X2 -> auto___def_45 X1 X2). tauto. exact (rem_2645 X1 X2).
Qed.

Remark rem_2647 : forall X1 X2:term, auto___def_51 X1 -> auto___def_52 (key sym X2) -> auto___def_45 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_298 sym X2 H);  intros.
  apply (rem_2646 X1 X2);  tauto.
Qed.

Remark rem_2648 : forall X1 X2:term, auto___def_39 sym -> auto___def_40 X2 -> auto_knows_current X1 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_1506 X1).
Qed.

Remark rem_2649 : forall X2:term, auto___def_40 X2 -> auto___def_40 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2650 : forall X1 X2:term, auto___def_39 sym -> auto___def_40 X2 -> auto_knows_current X1 -> auto___def_40 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_40 X2 -> auto___def_40 X2). tauto. exact (rem_2649 X2).
Qed.

Remark rem_2651 : forall X1 X2:term, auto___def_39 sym -> auto___def_40 X2 -> auto_knows_current X1 -> (auto_knows_current X1 /\ auto___def_40 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto_knows_current X1). 2:apply (rem_2648 X1 X2);  assumption.
  cut (auto___def_40 X2). 2:apply (rem_2650 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2652 : forall X1 X2:term, auto___def_39 sym -> auto___def_40 X2 -> auto_knows_current X1 -> auto___def_45 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_2651 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_45_5;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2653 : forall X1 X2:term, auto___def_35 sym -> auto_knows_current X1 -> auto___def_45 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_35 sym -> False). tauto.
  exact (rem_240).
Qed.

Remark rem_2654 : forall X1 X2:term, auto___def_35 sym -> auto___type_8 X2 -> auto_knows_current X1 -> auto___def_45 X1 X2. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2. intros. apply (rem_2653 X1 X2);  assumption.
Qed.

Remark rem_2655 : forall X1 X2:term, auto___def_36 sym -> auto___def_37 X2 -> auto_knows_current X1 -> auto___def_45 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_36 sym -> False). tauto.
  exact (rem_1054).
Qed.

Remark rem_2656 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current (key sym X2) -> auto___def_45 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_310 sym X2 H);  intros.
  apply (rem_2652 X1 X2);  tauto.
  apply (rem_2654 X1 X2);  tauto.
  apply (rem_2655 X1 X2);  tauto.
Qed.

Remark rem_2657 : forall X1 X2:term, auto_knows_current (crypt X1 (key sym X2)) -> auto___def_45 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_312 X1 (key sym X2) H);  intros.
  apply (rem_2617 X1 X2);  tauto.
  apply (rem_2626 X1 X2);  tauto.
  apply (rem_2629 X1 X2);  tauto.
  apply (rem_2637 X1 X2);  tauto.
  apply (rem_2640 X1 X2);  tauto.
  apply (rem_2647 X1 X2);  tauto.
  apply (rem_2656 X1 X2);  tauto.
Qed.

Remark rem_2658 : forall X1 X2:term, auto_agent X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_197 X1).
Qed.

Remark rem_2659 : forall X1 X2:term, auto_agent X2 -> auto_agent X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_201 X2).
Qed.

Remark rem_2660 : forall X1 X2:term, auto_agent X2 -> auto_agent X1 -> (auto_agent X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto_agent X1). 2:apply (rem_2658 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_2659 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2661 : forall X1 X2:term, auto_agent X2 -> auto_agent X1 -> auto___def_9 (noncea_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2660 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_9_noncea_old_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2662 : forall X1 X2 X3:term, auto_knows_current (crypt (s (nonceb_current X3 X1 X2)) X3) -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1.
  tauto.
Qed.

Remark rem_2663 : forall X1 X2 X3:term, auto_knows_current (crypt (s (nonceb_current X3 X1 X2)) X3) -> auto___def_72 X1 X2 X3. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1.
  case (rem_2662 X1 X2 X3 A1). clear  A1. intros. apply trans___def_72_1;  tauto.
 clear  A1. tauto.
Qed.

Remark rem_2664 : auto___def_10 nil. (* Deduce positive atom. *)
Proof.
   case rem_321. intros. apply trans___def_10_nil_1;  tauto.
 tauto.
Qed.

Remark rem_2665 : forall X1 X2:term, auto_agent X2 -> auto_agent X1 -> auto___def_49 (noncea_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2660 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_49_noncea_current_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2666 : forall X1:term, auto___def_49 X1 -> auto___def_49 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2667 : forall X1 X2:term, auto___def_10 X2 -> auto___def_49 X1 -> auto___def_49 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_49 X1 -> auto___def_49 X1). tauto. exact (rem_2666 X1).
Qed.

Remark rem_2668 : forall X2:term, auto___def_10 X2 -> auto___def_10 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2669 : forall X1 X2:term, auto___def_10 X2 -> auto___def_49 X1 -> auto___def_10 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_10 X2 -> auto___def_10 X2). tauto. exact (rem_2668 X2).
Qed.

Remark rem_2670 : forall X1 X2:term, auto___def_10 X2 -> auto___def_49 X1 -> (auto___def_49 X1 /\ auto___def_10 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_49 X1). 2:apply (rem_2667 X1 X2);  assumption.
  cut (auto___def_10 X2). 2:apply (rem_2669 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2671 : forall X1 X2:term, auto___def_10 X2 -> auto___def_49 X1 -> auto___def_48 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2670 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_48_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2672 : forall X1 X2:term, auto___def_27 X1 -> auto___def_28 X2 -> auto___def_65 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_541 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_65_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2673 : forall X1 X2:term, auto___def_28 X2 -> auto___def_27 X1 -> auto___def_65 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_27 X1 -> auto___def_28 X2 -> auto___def_65 (cons X1 X2)). tauto. exact (rem_2672 X1 X2).
Qed.

Remark rem_2674 : forall X1 X2:term, auto___def_26 X2 -> auto___type_4 X1 -> auto___type_4 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_4 X1 -> auto___type_4 X1). tauto. exact (rem_395 X1).
Qed.

Remark rem_2675 : forall X1 X2:term, auto___def_26 X2 -> auto___type_4 X1 -> auto___def_26 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_26 X2 -> auto___def_26 X2). tauto. exact (rem_545 X2).
Qed.

Remark rem_2676 : forall X1 X2:term, auto___def_26 X2 -> auto___type_4 X1 -> (auto___type_4 X1 /\ auto___def_26 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_4 X1). 2:apply (rem_2674 X1 X2);  assumption.
  cut (auto___def_26 X2). 2:apply (rem_2675 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2677 : forall X1 X2:term, auto___def_26 X2 -> auto___type_4 X1 -> auto___def_25 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2676 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_25_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2678 : forall X1:term, auto___def_9 X1 -> auto___def_9 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2679 : forall X1 X2:term, auto___def_10 X2 -> auto___def_9 X1 -> auto___def_9 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_9 X1 -> auto___def_9 X1). tauto. exact (rem_2678 X1).
Qed.

Remark rem_2680 : forall X1 X2:term, auto___def_10 X2 -> auto___def_9 X1 -> auto___def_10 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_10 X2 -> auto___def_10 X2). tauto. exact (rem_2668 X2).
Qed.

Remark rem_2681 : forall X1 X2:term, auto___def_10 X2 -> auto___def_9 X1 -> (auto___def_9 X1 /\ auto___def_10 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_9 X1). 2:apply (rem_2679 X1 X2);  assumption.
  cut (auto___def_10 X2). 2:apply (rem_2680 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2682 : forall X1 X2:term, auto___def_10 X2 -> auto___def_9 X1 -> auto___def_8 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2681 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_8_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2683 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_4 X3 -> auto___type_5 X2 -> auto___def_32 (nonceb_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  case (rem_272 X1 X2 X3 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_32_nonceb_old_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2684 : forall X1 X2 X3:term, auto___type_5 X2 -> auto___type_4 X3 -> auto___def_16 X1 -> auto___def_32 (nonceb_old X1 X2 X3). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_16 X1 -> auto___type_4 X3 -> auto___type_5 X2 -> auto___def_32 (nonceb_old X1 X2 X3)). tauto. exact (rem_2683 X1 X2 X3).
Qed.

Remark rem_2685 : forall X1 X2 X3:term, auto___def_31 X2 X3 X1 -> auto___def_32 (nonceb_old X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_2356 X2 X3 X1 H);  intros.
  apply (rem_2684 X1 X2 X3);  tauto.
Qed.

Remark rem_2686 : forall X1 X2 X3:term, auto___def_15 nil -> auto___def_29 (cons X2 (cons server nil)) -> auto___type_3 X3 -> auto___type_4 X1 -> auto___def_31 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_15 nil -> False). tauto.
  exact (rem_1533).
Qed.

Remark rem_2687 : forall X1 X2 X3:term, auto___type_4 X1 -> auto___def_15 nil -> auto___def_29 (cons X2 (cons server nil)) -> auto___type_3 X3 -> auto___def_31 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_15 nil -> auto___def_29 (cons X2 (cons server nil)) -> auto___type_3 X3 -> auto___type_4 X1 -> auto___def_31 X1 X2 X3). tauto. exact (rem_2686 X1 X2 X3).
Qed.

Remark rem_2688 : forall X1 X2 X3:term, auto___def_14 (cons X1 nil) -> auto___def_29 (cons X2 (cons server nil)) -> auto___type_3 X3 -> auto___def_31 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_225 X1 nil H);  intros.
  apply (rem_2687 X1 X2 X3);  tauto.
Qed.

Remark rem_2689 : forall X1 X2 X3:term, auto___def_14 (cons X1 nil) -> auto___def_18 sym -> auto___def_29 (cons X2 (cons server nil)) -> auto___type_3 X3 -> auto___def_31 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_14 (cons X1 nil) -> auto___def_29 (cons X2 (cons server nil)) -> auto___type_3 X3 -> auto___def_31 X1 X2 X3). tauto.
  exact (rem_2688 X1 X2 X3).
Qed.

Remark rem_2690 : forall X1 X2 X3:term, auto___def_18 sym -> auto___def_29 (cons X2 (cons server nil)) -> auto___def_14 (cons X1 nil) -> auto___type_3 X3 -> auto___def_31 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_14 (cons X1 nil) -> auto___def_18 sym -> auto___def_29 (cons X2 (cons server nil)) -> auto___type_3 X3 -> auto___def_31 X1 X2 X3). tauto. exact (rem_2689 X1 X2 X3).
Qed.

Remark rem_2691 : forall X1 X2 X3:term, auto___def_13 (key sym (cons X2 (cons server nil))) -> auto___def_14 (cons X1 nil) -> auto___type_3 X3 -> auto___def_31 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_167 sym (cons X2 (cons server nil)) H);  intros.
  apply (rem_2690 X1 X2 X3);  tauto.
Qed.

Remark rem_2692 : forall X1 X2 X3:term, auto___type_3 X3 -> auto___def_14 (cons X1 nil) -> auto___def_13 (key sym (cons X2 (cons server nil))) -> auto___def_31 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_13 (key sym (cons X2 (cons server nil))) -> auto___def_14 (cons X1 nil) -> auto___type_3 X3 -> auto___def_31 X1 X2 X3). tauto. exact (rem_2691 X1 X2 X3).
Qed.

Remark rem_2693 : forall X1 X2 X3:term, auto___def_12 (cons X3 (cons X1 nil)) -> auto___def_13 (key sym (cons X2 (cons server nil))) -> auto___def_31 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_231 X3 (cons X1 nil) H);  intros.
  apply (rem_2692 X1 X2 X3);  tauto.
Qed.

Remark rem_2694 : forall X1 X2 X3:term, auto___def_34 (cons X3 (cons X1 nil)) -> auto___type_7 (key sym (cons X2 (cons server nil))) -> auto___def_31 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_233 X3 (cons X1 nil) H);  intros.
Qed.

Remark rem_2695 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_26 (cons server nil) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_31 X1 X2 X3. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  case (rem_1561 X1 X2 X3 A1 A2 A3 A4). clear  A1 A2 A3 A4. intros. apply trans___def_31_1;  tauto.
 clear  A1 A2 A3 A4. tauto.
Qed.

Remark rem_2696 : forall X1 X2 X3:term, auto___type_4 X2 -> auto___def_26 (cons server nil) -> auto___def_16 X3 -> auto___type_5 X1 -> auto___def_31 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_16 X3 -> auto___def_26 (cons server nil) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_31 X1 X2 X3). tauto. exact (rem_2695 X1 X2 X3).
Qed.

Remark rem_2697 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_25 (cons X2 (cons server nil)) -> auto___type_5 X1 -> auto___def_31 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_694 X2 (cons server nil) H);  intros.
  apply (rem_2696 X1 X2 X3);  tauto.
Qed.

Remark rem_2698 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_21 nil -> auto___def_25 (cons X2 (cons server nil)) -> auto___type_5 X1 -> auto___def_31 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_16 X3 -> auto___def_25 (cons X2 (cons server nil)) -> auto___type_5 X1 -> auto___def_31 X1 X2 X3). tauto.
  exact (rem_2697 X1 X2 X3).
Qed.

Remark rem_2699 : forall X1 X2 X3:term, auto___type_5 X1 -> auto___def_21 nil -> auto___def_16 X3 -> auto___def_25 (cons X2 (cons server nil)) -> auto___def_31 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_16 X3 -> auto___def_21 nil -> auto___def_25 (cons X2 (cons server nil)) -> auto___type_5 X1 -> auto___def_31 X1 X2 X3). tauto. exact (rem_2698 X1 X2 X3).
Qed.

Remark rem_2700 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_24 (cons X1 nil) -> auto___def_25 (cons X2 (cons server nil)) -> auto___def_31 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_1567 X1 nil H);  intros.
  apply (rem_2699 X1 X2 X3);  tauto.
Qed.

Remark rem_2701 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_18 sym -> auto___def_24 (cons X1 nil) -> auto___def_25 (cons X2 (cons server nil)) -> auto___def_31 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_16 X3 -> auto___def_24 (cons X1 nil) -> auto___def_25 (cons X2 (cons server nil)) -> auto___def_31 X1 X2 X3). tauto.
  exact (rem_2700 X1 X2 X3).
Qed.

Remark rem_2702 : forall X1 X2 X3:term, auto___def_18 sym -> auto___def_25 (cons X2 (cons server nil)) -> auto___def_16 X3 -> auto___def_24 (cons X1 nil) -> auto___def_31 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_16 X3 -> auto___def_18 sym -> auto___def_24 (cons X1 nil) -> auto___def_25 (cons X2 (cons server nil)) -> auto___def_31 X1 X2 X3). tauto. exact (rem_2701 X1 X2 X3).
Qed.

Remark rem_2703 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_23 (key sym (cons X2 (cons server nil))) -> auto___def_24 (cons X1 nil) -> auto___def_31 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_174 sym (cons X2 (cons server nil)) H);  intros.
  apply (rem_2702 X1 X2 X3);  tauto.
Qed.

Remark rem_2704 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_24 (cons X1 nil) -> auto___def_23 (key sym (cons X2 (cons server nil))) -> auto___def_31 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_16 X3 -> auto___def_23 (key sym (cons X2 (cons server nil))) -> auto___def_24 (cons X1 nil) -> auto___def_31 X1 X2 X3). tauto. exact (rem_2703 X1 X2 X3).
Qed.

Remark rem_2705 : forall X1 X2 X3:term, auto___def_22 (cons X3 (cons X1 nil)) -> auto___def_23 (key sym (cons X2 (cons server nil))) -> auto___def_31 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_237 X3 (cons X1 nil) H);  intros.
  apply (rem_2704 X1 X2 X3);  tauto.
Qed.

Remark rem_2706 : forall X1 X2 X3:term, auto___def_35 sym -> auto_knows_old X1 -> auto_knows_old X3 -> auto___def_31 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_35 sym -> False). tauto.
  exact (rem_240).
Qed.

Remark rem_2707 : forall X1 X2 X3:term, auto___def_35 sym -> auto___type_8 (cons X2 (cons server nil)) -> auto_knows_old X1 -> auto_knows_old X3 -> auto___def_31 X1 X2 X3. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2 X3. intros. apply (rem_2706 X1 X2 X3);  assumption.
Qed.

Remark rem_2708 : forall X1 X2 X3:term, auto___def_37 (cons X2 (cons server nil)) -> auto_knows_old X1 -> auto_knows_old X3 -> auto___def_31 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_243 X2 (cons server nil) H);  intros.
Qed.

Remark rem_2709 : forall X1 X2 X3:term, auto___def_36 sym -> auto___def_37 (cons X2 (cons server nil)) -> auto_knows_old X1 -> auto_knows_old X3 -> auto___def_31 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_37 (cons X2 (cons server nil)) -> auto_knows_old X1 -> auto_knows_old X3 -> auto___def_31 X1 X2 X3). tauto.
  exact (rem_2708 X1 X2 X3).
Qed.

Remark rem_2710 : forall X1 X2 X3:term, auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old (key sym (cons X2 (cons server nil))) -> auto___def_31 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1 H2. intro H. intros.
  elim (rem_97 sym (cons X2 (cons server nil)) H);  intros.
  apply (rem_2707 X1 X2 X3);  tauto.
  apply (rem_2709 X1 X2 X3);  tauto.
Qed.

Remark rem_2711 : forall X1 X2 X3:term, auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old (key sym (cons X2 (cons server nil))) -> auto_knows_old nil -> auto___def_31 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old (key sym (cons X2 (cons server nil))) -> auto___def_31 X1 X2 X3). tauto.
  exact (rem_2710 X1 X2 X3).
Qed.

Remark rem_2712 : forall X1 X2 X3:term, auto_knows_old X1 -> auto_knows_old nil -> auto_knows_old X3 -> auto_knows_old (key sym (cons X2 (cons server nil))) -> auto___def_31 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old (key sym (cons X2 (cons server nil))) -> auto_knows_old nil -> auto___def_31 X1 X2 X3). tauto. exact (rem_2711 X1 X2 X3).
Qed.

Remark rem_2713 : forall X1 X2 X3:term, auto_knows_old X3 -> auto_knows_old (cons X1 nil) -> auto_knows_old (key sym (cons X2 (cons server nil))) -> auto___def_31 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_73 X1 nil H);  intros.
  apply (rem_2712 X1 X2 X3);  tauto.
Qed.

Remark rem_2714 : forall X1 X2 X3:term, auto_knows_old (cons X3 (cons X1 nil)) -> auto_knows_old (key sym (cons X2 (cons server nil))) -> auto___def_31 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_73 X3 (cons X1 nil) H);  intros.
  apply (rem_2713 X1 X2 X3);  tauto.
Qed.

Remark rem_2715 : forall X1 X2 X3:term, auto___def_32 (cons X3 (cons X1 nil)) -> auto___type_6 (key sym (cons X2 (cons server nil))) -> auto___def_31 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_255 X3 (cons X1 nil) H);  intros.
Qed.

Remark rem_2716 : forall X1 X2 X3:term, auto_knows_old (crypt (cons X3 (cons X1 nil)) (key sym (cons X2 (cons server nil)))) -> auto___def_31 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_124 (cons X3 (cons X1 nil)) (key sym (cons X2 (cons server nil))) H);  intros.
  apply (rem_2693 X1 X2 X3);  tauto.
  apply (rem_2694 X1 X2 X3);  tauto.
  apply (rem_2705 X1 X2 X3);  tauto.
  apply (rem_2714 X1 X2 X3);  tauto.
  apply (rem_2715 X1 X2 X3);  tauto.
Qed.

Remark rem_2717 : forall X1 X2:term, auto___def_16 X1 -> auto___def_24 X2 -> auto___def_16 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_16 X1 -> auto___def_16 X1). tauto. exact (rem_53 X1).
Qed.

Remark rem_2718 : forall X2:term, auto___def_24 X2 -> auto___def_24 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2719 : forall X1 X2:term, auto___def_16 X1 -> auto___def_24 X2 -> auto___def_24 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_24 X2 -> auto___def_24 X2). tauto. exact (rem_2718 X2).
Qed.

Remark rem_2720 : forall X1 X2:term, auto___def_16 X1 -> auto___def_24 X2 -> (auto___def_16 X1 /\ auto___def_24 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_16 X1). 2:apply (rem_2717 X1 X2);  assumption.
  cut (auto___def_24 X2). 2:apply (rem_2719 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2721 : forall X1 X2:term, auto___def_16 X1 -> auto___def_24 X2 -> auto___def_22 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2720 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_22_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2722 : forall X1 X2:term, auto___def_24 X2 -> auto___def_16 X1 -> auto___def_22 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_16 X1 -> auto___def_24 X2 -> auto___def_22 (cons X1 X2)). tauto. exact (rem_2721 X1 X2).
Qed.

Remark rem_2723 : forall X1 X2:term, auto___def_16 X2 -> auto___def_34 X1 -> auto___type_7 X2 -> auto___def_34 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_34 X1 -> auto___def_34 X1). tauto. exact (rem_2564 X1).
Qed.

Remark rem_2724 : forall X1 X2:term, auto___def_16 X2 -> auto___def_34 X1 -> auto___type_7 X2 -> auto___def_34 X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_34 X1). 2:apply (rem_2723 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2725 : forall X1 X2:term, auto___def_16 X2 -> auto___def_34 X1 -> auto___type_7 X2 -> auto___def_34 (s X1). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_2724 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_34_s_2;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2726 : forall X1 X2:term, auto___def_16 X2 -> auto___type_7 X2 -> auto___def_34 X1 -> auto___def_34 (s X1). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_16 X2 -> auto___def_34 X1 -> auto___type_7 X2 -> auto___def_34 (s X1)). tauto. exact (rem_2725 X1 X2).
Qed.

Remark rem_2727 : (forall X:term, auto___def_16 X -> auto_knows_old X -> False)
    -> forall X1:term, auto___def_18 X1 -> auto___def_35 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_16_mknows_old. exact (rem_1190).
Defined.

Remark rem_2728 : (forall X:term, auto___def_16 X -> auto_knows_old X -> False)
    -> forall X1 X2:term, auto___def_19 X2 -> auto___def_18 X1 -> auto___type_8 X2 -> auto___def_35 X1 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_16_mknows_old. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_35 X1 -> False). clear  epsilon_m__def_16_mknows_old. tauto.
  exact (rem_2727 epsilon_m__def_16_mknows_old X1).
Defined.

Remark rem_2729 : (forall X:term, auto___def_16 X -> auto_knows_old X -> False)
    -> forall X1:term, auto___def_18 X1 -> auto___def_36 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_16_mknows_old. exact (rem_1196).
Defined.

Remark rem_2730 : (forall X:term, auto___def_16 X -> auto_knows_old X -> False)
    -> forall X1 X2:term, auto___def_19 X2 -> auto___def_18 X1 -> auto___def_36 X1 -> auto___def_37 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_16_mknows_old. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_36 X1 -> False). clear  epsilon_m__def_16_mknows_old. tauto.
  exact (rem_2729 epsilon_m__def_16_mknows_old X1).
Defined.

Remark rem_2731 : (forall X:term, auto___def_16 X -> auto_knows_old X -> False)
    -> forall X1 X2:term, auto_knows_old (key X1 X2) -> auto___def_18 X1 -> auto___def_19 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_16_mknows_old. intros X1 X2. intro H. intros.
  elim (rem_97 X1 X2 H);  intros.
  apply (rem_2728 epsilon_m__def_16_mknows_old X1 X2);  tauto.
  apply (rem_2730 epsilon_m__def_16_mknows_old X1 X2);  tauto.
Defined.

Remark rem_2732 : (forall X:term, auto___def_16 X -> auto_knows_old X -> False)
    -> forall X1 X2:term, auto___def_16 (key X1 X2) -> auto_knows_old (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_16_mknows_old. intros X1 X2. intro H. intros.
  elim (rem_7 X1 X2 H);  intros.
  apply (rem_2731 epsilon_m__def_16_mknows_old X1 X2);  tauto.
Defined.

Remark rem_2733 : forall X1:term, auto___def_16 X1 -> auto_knows_old X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_16_mknows_old 1.
  intro X. case X.
   intro H. elim (rem_12  H).
   intro H. elim (rem_10  H).
  intros X1 X2. intro H. elim (rem_13 X1 X2 H).
  intros X1 X2. intro H. elim (rem_19 X1 X2 H).
   intro H. elim (rem_16  H).
  intros X1 X2;  exact (rem_2732 epsilon_m__def_16_mknows_old X1 X2).
   intro H. elim (rem_15  H).
  intros X1 X2. intro H. elim (rem_9 X1 X2 H).
  intros X1 X2. intro H. elim (rem_21 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_17 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_18 X1 X2 X3 H).
   intro H. elim (rem_24  H).
   intro H. elim (rem_22  H).
  intros X1. intro H. elim (rem_14 X1 H).
   intro H. elim (rem_23  H).
  intros X1 X2 X3. intro H. elim (rem_11 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_20 X1 X2 X3 H).
   intro H. elim (rem_25  H).
Qed.

Remark rem_2734 : forall X1 X2:term, auto___def_16 X2 -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_34 (s X1). (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2733 X2)). tauto.
Qed.

Remark rem_2735 : forall X1 X2:term, auto___def_16 X2 -> auto___def_22 X1 -> auto___def_23 X2 -> auto___def_34 (s X1). (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_1326 X2)). tauto.
Qed.

Remark rem_2736 : forall X1 X2:term, auto___def_16 X2 -> auto___def_23 X2 -> auto___def_22 X1 -> auto___def_34 (s X1). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_16 X2 -> auto___def_22 X1 -> auto___def_23 X2 -> auto___def_34 (s X1)). tauto. exact (rem_2735 X1 X2).
Qed.

Remark rem_2737 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_16 X2 -> auto___def_34 (s X1). (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_1096 X2)). tauto.
Qed.

Remark rem_2738 : forall X1 X2:term, auto___def_16 X2 -> auto___def_13 X2 -> auto___def_12 X1 -> auto___def_34 (s X1). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_13 X2 -> auto___def_16 X2 -> auto___def_34 (s X1)). tauto. exact (rem_2737 X1 X2).
Qed.

Remark rem_2739 : forall X1 X2:term, auto___def_16 X2 -> auto___def_32 X1 -> auto___type_6 X2 -> auto___def_32 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_32 X1 -> auto___def_32 X1). tauto. exact (rem_2582 X1).
Qed.

Remark rem_2740 : forall X1 X2:term, auto___def_16 X2 -> auto___def_32 X1 -> auto___type_6 X2 -> auto___def_32 X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_32 X1). 2:apply (rem_2739 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2741 : forall X1 X2:term, auto___def_16 X2 -> auto___def_32 X1 -> auto___type_6 X2 -> auto___def_34 (s X1). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_2740 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_34_s_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2742 : forall X1 X2:term, auto___def_16 X2 -> auto___type_6 X2 -> auto___def_32 X1 -> auto___def_34 (s X1). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_16 X2 -> auto___def_32 X1 -> auto___type_6 X2 -> auto___def_34 (s X1)). tauto. exact (rem_2741 X1 X2).
Qed.

Remark rem_2743 : forall X1 X2:term, auto___def_33 X2 X1 -> auto___def_34 (s X1). (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_37 X2 X1 H);  intros.
  apply (rem_2726 X1 X2);  tauto.
  apply (rem_2734 X1 X2);  tauto.
  apply (rem_2736 X1 X2);  tauto.
  apply (rem_2738 X1 X2);  tauto.
  apply (rem_2742 X1 X2);  tauto.
Qed.

Remark rem_2744 : forall X1 X2:term, auto___def_21 X2 -> auto___type_5 X1 -> auto___type_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_5 X1 -> auto___type_5 X1). tauto. exact (rem_199 X1).
Qed.

Remark rem_2745 : forall X1 X2:term, auto___def_21 X2 -> auto___type_5 X1 -> auto___def_21 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_21 X2 -> auto___def_21 X2). tauto. exact (rem_192 X2).
Qed.

Remark rem_2746 : forall X1 X2:term, auto___def_21 X2 -> auto___type_5 X1 -> (auto___type_5 X1 /\ auto___def_21 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_5 X1). 2:apply (rem_2744 X1 X2);  assumption.
  cut (auto___def_21 X2). 2:apply (rem_2745 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2747 : forall X1 X2:term, auto___def_21 X2 -> auto___type_5 X1 -> auto___def_24 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2746 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_24_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2748 : forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto___def_61 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_61 X1 -> auto___def_61 X1). tauto. exact (rem_2630 X1).
Qed.

Remark rem_2749 : forall X2:term, auto___def_62 X2 -> auto___def_62 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2750 : forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto___def_62 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_62 X2 -> auto___def_62 X2). tauto. exact (rem_2749 X2).
Qed.

Remark rem_2751 : forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> (auto___def_61 X1 /\ auto___def_62 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_61 X1). 2:apply (rem_2748 X1 X2);  assumption.
  cut (auto___def_62 X2). 2:apply (rem_2750 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2752 : forall X1 X2:term, auto___def_61 X1 -> auto___def_62 X2 -> auto___def_59 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2751 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_59_crypt_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2753 : forall X1 X2:term, auto___def_62 X2 -> auto___def_61 X1 -> auto___def_59 (crypt X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_61 X1 -> auto___def_62 X2 -> auto___def_59 (crypt X1 X2)). tauto. exact (rem_2752 X1 X2).
Qed.

Remark rem_2754 : (forall X:term, auto___def_40 X -> auto___def_46 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_40_p__def_46.  tauto.
Defined.

Remark rem_2755 : (forall X:term, auto___def_40 X -> auto___def_46 X)
    -> forall X1 X2 X3:term, auto___def_46 (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_40_p__def_46. intros X1 X2 X3.  case (rem_2754 epsilon_m__def_40_p__def_46). clear  epsilon_m__def_40_p__def_46. intros. apply trans___def_46_session_old_1;  tauto.
 clear  epsilon_m__def_40_p__def_46. tauto.
Defined.

Remark rem_2756 : (forall X:term, auto___def_40 X -> auto___def_46 X)
    -> forall X1 X2 X3:term, auto___def_40 (session_old X1 X2 X3) -> auto___def_46 (session_old X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_40_p__def_46. intros X1 X2 X3. intro H. intros.
  elim (rem_1150 X1 X2 X3 H);  intros.
  apply (rem_2755 epsilon_m__def_40_p__def_46 X1 X2 X3);  tauto.
Defined.

Remark rem_2757 : forall X1:term, auto___def_40 X1 -> auto___def_46 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_40_p__def_46 1.
  intro X. case X.
   intro H. elim (rem_1154  H).
   intro H. elim (rem_1153  H).
  intros X1 X2. intro H. elim (rem_862 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1161 X1 X2 H).
   intro H. elim (rem_1157  H).
  intros X1 X2. intro H. elim (rem_1158 X1 X2 H).
   intro H. elim (rem_1156  H).
  intros X1 X2. intro H. elim (rem_1152 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1162 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1159 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1160 X1 X2 X3 H).
   intro H. elim (rem_1165  H).
   intro H. elim (rem_1163  H).
  intros X1. intro H. elim (rem_1155 X1 H).
   intro H. elim (rem_1164  H).
  intros X1 X2 X3. intro H. elim (rem_625 X1 X2 X3 H).
  intros X1 X2 X3;  exact (rem_2756 epsilon_m__def_40_p__def_46 X1 X2 X3).
   intro H. elim (rem_1166  H).
Qed.

Remark rem_2758 : forall X1:term, auto___def_39 sym -> auto___def_40 X1 -> auto___def_46 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1.
  cut (auto___def_40 X1 -> auto___def_46 X1). tauto. exact (rem_2757 X1).
Qed.

Remark rem_2759 : forall X1:term, auto___def_35 sym -> auto___def_46 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_35 sym -> False). tauto.
  exact (rem_240).
Qed.

Remark rem_2760 : forall X1:term, auto___def_35 sym -> auto___type_8 X1 -> auto___def_46 X1. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1. intros. apply (rem_2759 X1);  assumption.
Qed.

Remark rem_2761 : forall X1:term, auto___def_36 sym -> auto___def_37 X1 -> auto___def_46 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_36 sym -> False). tauto.
  exact (rem_1054).
Qed.

Remark rem_2762 : forall X1:term, auto_knows_current (key sym X1) -> auto___def_46 X1. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_310 sym X1 H);  intros.
  apply (rem_2758 X1);  tauto.
  apply (rem_2760 X1);  tauto.
  apply (rem_2761 X1);  tauto.
Qed.

Remark rem_2763 : forall X1 X2 X3:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_16 X1 -> auto___def_17 (cons X3 nil) -> auto___def_16 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_16 X1 -> auto___def_16 X1). tauto. exact (rem_53 X1).
Qed.

Remark rem_2764 : forall X1 X2 X3:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_16 X1 -> auto___def_17 (cons X3 nil) -> auto___def_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_13 X1 -> auto___def_13 X1). tauto. exact (rem_1117 X1).
Qed.

Remark rem_2765 : forall X1 X2 X3:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_16 X1 -> auto___def_17 (cons X3 nil) -> auto___def_12 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_12 X2 -> auto___def_12 X2). tauto. exact (rem_1120 X2).
Qed.

Remark rem_2766 : forall X1 X2 X3:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_16 X1 -> auto___def_17 (cons X3 nil) -> (auto___def_16 X1 /\ auto___def_13 X1 /\ auto___def_12 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  cut (auto___def_16 X1). 2:apply (rem_2763 X1 X2 X3);  assumption.
  cut (auto___def_13 X1). 2:apply (rem_2764 X1 X2 X3);  assumption.
  cut (auto___def_12 X2). 2:apply (rem_2765 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_2767 : forall X1 X2 X3:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_16 X1 -> auto___def_17 (cons X3 nil) -> auto___def_33 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  case (rem_2766 X1 X2 X3 A1 A2 A3 A4). clear  A1 A2 A3 A4. intros. apply trans___def_33_4;  tauto.
 clear  A1 A2 A3 A4. tauto.
Qed.

Remark rem_2768 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___def_17 (cons X3 nil) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_16 X1 -> auto___def_17 (cons X3 nil) -> auto___def_33 X1 X2). tauto. exact (rem_2767 X1 X2 X3).
Qed.

Remark rem_2769 : forall X1 X2 X3:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1 H2. intro H. intros.
  elim (rem_222 X1 (cons X3 nil) H);  intros.
  apply (rem_2768 X1 X2 X3);  tauto.
Qed.

Remark rem_2770 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_29 (cons X4 (cons server nil)) -> auto___type_3 (noncea_old X4 X5) -> auto___type_4 X5 -> auto___def_33 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_33 X1 X2). tauto.
  exact (rem_2769 X1 X2 X3).
Qed.

Remark rem_2771 : forall X1 X2 X3 X4 X5:term, auto___type_4 X3 -> auto___def_15 (cons X1 (cons X4 nil)) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_old X5 X3) -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_29 (cons X4 (cons server nil)) -> auto___type_3 (noncea_old X4 X5) -> auto___type_4 X5 -> auto___def_33 X1 X2). tauto. exact (rem_2770 X1 X2 X3 X4 X5).
Qed.

Remark rem_2772 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_old X5 X3) -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_225 X3 (cons X1 (cons X4 nil)) H);  intros.
  apply (rem_2771 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_2773 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_18 sym -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_old X5 X3) -> auto___def_33 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_old X5 X3) -> auto___def_33 X1 X2). tauto.
  exact (rem_2772 X1 X2 X3 X4 X5).
Qed.

Remark rem_2774 : forall X1 X2 X3 X4 X5:term, auto___def_18 sym -> auto___def_29 (cons X3 (cons server nil)) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___type_3 (noncea_old X3 X4) -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_18 sym -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_old X5 X3) -> auto___def_33 X1 X2). tauto. exact (rem_2773 X1 X2 X3 X4 X5).
Qed.

Remark rem_2775 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___type_3 (noncea_old X3 X4) -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_167 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_2774 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_2776 : forall X1 X2 X3 X4 X5:term, auto___type_3 (noncea_old X3 X4) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___type_3 (noncea_old X3 X4) -> auto___def_33 X1 X2). tauto. exact (rem_2775 X1 X2 X3 X4 X5).
Qed.

Remark rem_2777 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_12 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_13 X1 -> auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_231 (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_2776 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_2778 : forall X1 X2 X3 X4 X5:term, auto___def_12 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_12 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_13 X1 -> auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_33 X1 X2). tauto. exact (rem_2777 X1 X2 X3 X4 X5).
Qed.

Remark rem_2779 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_34 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_7 (key sym (cons X3 (cons server nil))) -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_233 (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
Qed.

Remark rem_2780 : forall X1 X2 X3 X4 X5:term, auto___def_34 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_7 (key sym (cons X3 (cons server nil))) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_34 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_7 (key sym (cons X3 (cons server nil))) -> auto___def_33 X1 X2). tauto. exact (rem_2779 X1 X2 X3 X4 X5).
Qed.

Remark rem_2781 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_16 (noncea_old X3 X4) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_24 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_21 X3 X4 H);  intros.
Qed.

Remark rem_2782 : forall X1 X2 X3 X4 X5:term, auto___def_16 (noncea_old X3 X4) -> auto___def_24 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_16 (noncea_old X3 X4) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_24 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_33 X1 X2). tauto. exact (rem_2781 X1 X2 X3 X4 X5).
Qed.

Remark rem_2783 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_22 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_237 (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_2782 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_2784 : forall X1 X2 X3 X4 X5:term, auto___def_22 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_22 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_33 X1 X2). tauto. exact (rem_2783 X1 X2 X3 X4 X5).
Qed.

Remark rem_2785 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> auto___def_13 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_13. intro H. intros.
  elim (rem_585 H);  intros.
Defined.

Remark rem_2786 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> auto_knows_old bob -> auto___def_13 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_13. intro H. intros.
  elim (rem_62 H);  intros.
  apply (rem_2785 epsilon_mknows_old_m__def_13);  tauto.
Defined.

Remark rem_2787 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> auto___def_13 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_13. intro H. intros.
  elim (rem_587 H);  intros.
Defined.

Remark rem_2788 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> auto_knows_old alice -> auto___def_13 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_13. intro H. intros.
  elim (rem_65 H);  intros.
  apply (rem_2787 epsilon_mknows_old_m__def_13);  tauto.
Defined.

Remark rem_2789 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (cons X1 X2) -> auto_knows_old X1 -> auto_knows_old X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_588 X1 X2 H);  intros.
Defined.

Remark rem_2790 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto_knows_old (cons X1 X2) -> auto___def_13 (cons X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_73 X1 X2 H);  intros.
  apply (rem_2789 epsilon_mknows_old_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_2791 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> forall X1:term, auto___def_13 (s X1) -> auto_knows_old X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_13. intros X1. intro H. intros.
  elim (rem_589 X1 H);  intros.
Defined.

Remark rem_2792 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> forall X1:term, auto_knows_old (s X1) -> auto___def_13 (s X1) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_13. intros X1. intro H. intros.
  elim (rem_77 X1 H);  intros.
  apply (rem_2791 epsilon_mknows_old_m__def_13 X1);  tauto.
Defined.

Remark rem_2793 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> auto___def_13 nil -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_13. intro H. intros.
  elim (rem_590 H);  intros.
Defined.

Remark rem_2794 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> auto_knows_old nil -> auto___def_13 nil -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_13. intro H. intros.
  elim (rem_80 H);  intros.
  apply (rem_2793 epsilon_mknows_old_m__def_13);  tauto.
Defined.

Remark rem_2795 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> auto___def_13 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_13. intro H. intros.
  elim (rem_591 H);  intros.
Defined.

Remark rem_2796 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> auto_knows_old i -> auto___def_13 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_13. intro H. intros.
  elim (rem_83 H);  intros.
  apply (rem_2795 epsilon_mknows_old_m__def_13);  tauto.
Defined.

Remark rem_2797 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> forall X1:term, auto___def_18 X1 -> auto___def_35 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_mknows_old_m__def_13. exact (rem_1190).
Defined.

Remark rem_2798 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_29 X2 -> auto___def_18 X1 -> auto___type_8 X2 -> auto___def_35 X1 -> False. (* Split. *)
Proof.
  intros epsilon_mknows_old_m__def_13. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_35 X1 -> False). clear  epsilon_mknows_old_m__def_13. tauto.
  exact (rem_2797 epsilon_mknows_old_m__def_13 X1).
Defined.

Remark rem_2799 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (key X1 X2) -> auto___def_35 X1 -> auto___type_8 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_167 X1 X2 H);  intros.
  apply (rem_2798 epsilon_mknows_old_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_2800 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> forall X1:term, auto___def_18 X1 -> auto___def_36 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_mknows_old_m__def_13. exact (rem_1196).
Defined.

Remark rem_2801 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_29 X2 -> auto___def_18 X1 -> auto___def_36 X1 -> auto___def_37 X2 -> False. (* Split. *)
Proof.
  intros epsilon_mknows_old_m__def_13. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_36 X1 -> False). clear  epsilon_mknows_old_m__def_13. tauto.
  exact (rem_2800 epsilon_mknows_old_m__def_13 X1).
Defined.

Remark rem_2802 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (key X1 X2) -> auto___def_36 X1 -> auto___def_37 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_167 X1 X2 H);  intros.
  apply (rem_2801 epsilon_mknows_old_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_2803 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto_knows_old (key X1 X2) -> auto___def_13 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_97 X1 X2 H);  intros.
  apply (rem_2799 epsilon_mknows_old_m__def_13 X1 X2);  tauto.
  apply (rem_2802 epsilon_mknows_old_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_2804 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (crypt X1 X2) -> auto___def_12 X1 -> auto___def_13 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_594 X1 X2 H);  intros.
Defined.

Remark rem_2805 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (crypt X1 X2) -> auto___def_34 X1 -> auto___type_7 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_594 X1 X2 H);  intros.
Defined.

Remark rem_2806 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (crypt X1 X2) -> auto___def_22 X1 -> auto___def_23 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_594 X1 X2 H);  intros.
Defined.

Remark rem_2807 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (crypt X1 X2) -> auto_knows_old X1 -> auto_knows_old X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_594 X1 X2 H);  intros.
Defined.

Remark rem_2808 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (crypt X1 X2) -> auto___def_32 X1 -> auto___type_6 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_594 X1 X2 H);  intros.
Defined.

Remark rem_2809 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto_knows_old (crypt X1 X2) -> auto___def_13 (crypt X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_124 X1 X2 H);  intros.
  apply (rem_2804 epsilon_mknows_old_m__def_13 X1 X2);  tauto.
  apply (rem_2805 epsilon_mknows_old_m__def_13 X1 X2);  tauto.
  apply (rem_2806 epsilon_mknows_old_m__def_13 X1 X2);  tauto.
  apply (rem_2807 epsilon_mknows_old_m__def_13 X1 X2);  tauto.
  apply (rem_2808 epsilon_mknows_old_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_2810 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (noncea_old X1 X2) -> auto_agent X1 -> auto_agent X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_596 X1 X2 H);  intros.
Defined.

Remark rem_2811 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto_knows_old (noncea_old X1 X2) -> auto___def_13 (noncea_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_132 X1 X2 H);  intros.
  apply (rem_2810 epsilon_mknows_old_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_2812 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> auto___def_13 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_13. intro H. intros.
  elim (rem_598 H);  intros.
Defined.

Remark rem_2813 : (forall X:term, auto_knows_old X -> auto___def_13 X -> False)
    -> auto_knows_old server -> auto___def_13 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_13. intro H. intros.
  elim (rem_135 H);  intros.
  apply (rem_2812 epsilon_mknows_old_m__def_13);  tauto.
Defined.

Remark rem_2814 : forall X1:term, auto_knows_old X1 -> auto___def_13 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_mknows_old_m__def_13 1.
  intro X. case X.
  exact (rem_2788 epsilon_mknows_old_m__def_13 ).
  exact (rem_2786 epsilon_mknows_old_m__def_13 ).
  intros X1 X2;  exact (rem_2790 epsilon_mknows_old_m__def_13 X1 X2).
  intros X1 X2;  exact (rem_2809 epsilon_mknows_old_m__def_13 X1 X2).
  exact (rem_2796 epsilon_mknows_old_m__def_13 ).
  intros X1 X2;  exact (rem_2803 epsilon_mknows_old_m__def_13 X1 X2).
  exact (rem_2794 epsilon_mknows_old_m__def_13 ).
  intros X1 X2. intro H. elim (rem_137 X1 X2 H).
  intros X1 X2;  exact (rem_2811 epsilon_mknows_old_m__def_13 X1 X2).
  intros X1 X2 X3. intro H. elim (rem_139 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_140 X1 X2 X3 H).
   intro H. elim (rem_143  H).
   intro H. elim (rem_142  H).
  intros X1;  exact (rem_2792 epsilon_mknows_old_m__def_13 X1).
  exact (rem_2813 epsilon_mknows_old_m__def_13 ).
  intros X1 X2 X3. intro H. elim (rem_138 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_141 X1 X2 X3 H).
   intro H. elim (rem_144  H).
Qed.

Remark rem_2815 : forall X1 X2 X3:term, auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_old X1 -> auto_knows_old (cons X3 nil) -> auto___def_33 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3. intros.
  assert (HH:=(rem_2814 X1)). tauto.
Qed.

Remark rem_2816 : forall X1 X2 X3:term, auto_knows_old X1 -> auto_knows_old (cons X3 nil) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_old X1 -> auto_knows_old (cons X3 nil) -> auto___def_33 X1 X2). tauto. exact (rem_2815 X1 X2 X3).
Qed.

Remark rem_2817 : forall X1 X2 X3:term, auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_old (cons X1 (cons X3 nil)) -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1 H2. intro H. intros.
  elim (rem_73 X1 (cons X3 nil) H);  intros.
  apply (rem_2816 X1 X2 X3);  tauto.
Qed.

Remark rem_2818 : forall X1 X2 X4:term, auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_old (cons X1 (cons X4 nil)) -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_old (cons X1 (cons X3 nil)) -> auto___def_33 X1 X2). tauto. exact (rem_2817 X1 X2 X3).
Qed.

Remark rem_2819 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_old X3 -> auto_knows_old (cons X1 (cons X4 nil)) -> auto_knows_old (key sym (cons X5 (cons server nil))) -> auto_knows_old (noncea_old X5 X3) -> auto___def_33 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_old (cons X1 (cons X4 nil)) -> auto___def_33 X1 X2). tauto.
  exact (rem_2818 X1 X2 X4).
Qed.

Remark rem_2820 : forall X1 X2 X3 X4 X5:term, auto_knows_old X3 -> auto_knows_old (cons X1 (cons X4 nil)) -> auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_old (key sym (cons X5 (cons server nil))) -> auto_knows_old (noncea_old X5 X3) -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_old X3 -> auto_knows_old (cons X1 (cons X4 nil)) -> auto_knows_old (key sym (cons X5 (cons server nil))) -> auto_knows_old (noncea_old X5 X3) -> auto___def_33 X1 X2). tauto. exact (rem_2819 X1 X2 X3 X4 X5).
Qed.

Remark rem_2821 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_old (cons X3 (cons X1 (cons X4 nil))) -> auto_knows_old (key sym (cons X5 (cons server nil))) -> auto_knows_old (noncea_old X5 X3) -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_73 X3 (cons X1 (cons X4 nil)) H);  intros.
  apply (rem_2820 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_2822 : forall X1 X2 X3 X4 X5:term, auto_knows_old (noncea_old X3 X4) -> auto_knows_old (cons X4 (cons X1 (cons X5 nil))) -> auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_old (cons X3 (cons X1 (cons X4 nil))) -> auto_knows_old (key sym (cons X5 (cons server nil))) -> auto_knows_old (noncea_old X5 X3) -> auto___def_33 X1 X2). tauto. exact (rem_2821 X1 X2 X3 X4 X5).
Qed.

Remark rem_2823 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_old (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_73 (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_2822 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_2824 : forall X1 X2 X3 X4 X5:term, auto_knows_old (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_old (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto___def_33 X1 X2). tauto. exact (rem_2823 X1 X2 X3 X4 X5).
Qed.

Remark rem_2825 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_32 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_6 (key sym (cons X3 (cons server nil))) -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_255 (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
Qed.

Remark rem_2826 : forall X1 X2 X3 X4 X5:term, auto___def_32 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_6 (key sym (cons X3 (cons server nil))) -> auto___def_12 X2 -> auto___def_13 X1 -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_32 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_6 (key sym (cons X3 (cons server nil))) -> auto___def_33 X1 X2). tauto. exact (rem_2825 X1 X2 X3 X4 X5).
Qed.

Remark rem_2827 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 X1 -> auto_knows_old (crypt (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_124 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil))) H);  intros.
  apply (rem_2778 X1 X2 X3 X4 X5);  tauto.
  apply (rem_2780 X1 X2 X3 X4 X5);  tauto.
  apply (rem_2784 X1 X2 X3 X4 X5);  tauto.
  apply (rem_2824 X1 X2 X3 X4 X5);  tauto.
  apply (rem_2826 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_2828 : (forall X:term, auto___type_7 X -> auto___def_16 X)
    -> forall X1:term, auto___def_18 X1 -> auto___def_18 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2829 : (forall X:term, auto___type_7 X -> auto___def_16 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_18 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_7_p__def_16. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_18 X1). tauto. exact (rem_2828 epsilon_m__type_7_p__def_16 X1).
Defined.

Remark rem_2830 : (forall X:term, auto___type_7 X -> auto___def_16 X)
    -> forall X2:term, auto___def_19 X2 -> auto___def_19 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2831 : (forall X:term, auto___type_7 X -> auto___def_16 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_19 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_7_p__def_16. intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_19 X2). tauto. exact (rem_2830 epsilon_m__type_7_p__def_16 X2).
Defined.

Remark rem_2832 : (forall X:term, auto___type_7 X -> auto___def_16 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> (auto___def_18 X1 /\ auto___def_19 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_7_p__def_16. intros X1 X2. intros A1 A2.
  cut (auto___def_18 X1). 2:apply (rem_2829 epsilon_m__type_7_p__def_16 X1 X2);  assumption.
  cut (auto___def_19 X2). 2:apply (rem_2831 epsilon_m__type_7_p__def_16 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2833 : (forall X:term, auto___type_7 X -> auto___def_16 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_16 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_7_p__def_16. intros X1 X2. intros A1 A2.
  case (rem_2832 epsilon_m__type_7_p__def_16 X1 X2 A1 A2). clear  epsilon_m__type_7_p__def_16 A1 A2. intros. apply trans___def_16_key_1;  tauto.
 clear  epsilon_m__type_7_p__def_16 A1 A2. tauto.
Defined.

Remark rem_2834 : (forall X:term, auto___type_7 X -> auto___def_16 X)
    -> forall X1 X2:term, auto___type_7 (key X1 X2) -> auto___def_16 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_7_p__def_16. intros X1 X2. intro H. intros.
  elim (rem_170 X1 X2 H);  intros.
  apply (rem_2833 epsilon_m__type_7_p__def_16 X1 X2);  tauto.
Defined.

Remark rem_2835 : forall X1:term, auto___type_7 X1 -> auto___def_16 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_7_p__def_16 1.
  intro X. case X.
   intro H. elim (rem_1820  H).
   intro H. elim (rem_1818  H).
  intros X1 X2. intro H. elim (rem_1821 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1827 X1 X2 H).
   intro H. elim (rem_1824  H).
  intros X1 X2;  exact (rem_2834 epsilon_m__type_7_p__def_16 X1 X2).
   intro H. elim (rem_1823  H).
  intros X1 X2. intro H. elim (rem_1817 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1829 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1825 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1826 X1 X2 X3 H).
   intro H. elim (rem_1832  H).
   intro H. elim (rem_1830  H).
  intros X1. intro H. elim (rem_1822 X1 H).
   intro H. elim (rem_1831  H).
  intros X1 X2 X3. intro H. elim (rem_1819 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1828 X1 X2 X3 H).
   intro H. elim (rem_1833  H).
Qed.

Remark rem_2836 : forall X1 X2 X3 X4 X5:term, auto___def_34 X2 -> auto___type_7 X1 -> auto_knows_old (crypt (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_16 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_7 X1 -> auto___def_16 X1). tauto. exact (rem_2835 X1).
Qed.

Remark rem_2837 : forall X1:term, auto___type_7 X1 -> auto___type_7 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2838 : forall X1 X2 X3 X4 X5:term, auto___def_34 X2 -> auto___type_7 X1 -> auto_knows_old (crypt (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_7 X1 -> auto___type_7 X1). tauto. exact (rem_2837 X1).
Qed.

Remark rem_2839 : forall X2:term, auto___def_34 X2 -> auto___def_34 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2840 : forall X1 X2 X3 X4 X5:term, auto___def_34 X2 -> auto___type_7 X1 -> auto_knows_old (crypt (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_34 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_34 X2 -> auto___def_34 X2). tauto. exact (rem_2839 X2).
Qed.

Remark rem_2841 : forall X1 X2 X3 X4 X5:term, auto___def_34 X2 -> auto___type_7 X1 -> auto_knows_old (crypt (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> (auto___def_16 X1 /\ auto___type_7 X1 /\ auto___def_34 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3.
  cut (auto___def_16 X1). 2:apply (rem_2836 X1 X2 X3 X4 X5);  assumption.
  cut (auto___type_7 X1). 2:apply (rem_2838 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_34 X2). 2:apply (rem_2840 X1 X2 X3 X4 X5);  assumption.
  tauto.
Qed.

Remark rem_2842 : forall X1 X2 X3 X4 X5:term, auto___def_34 X2 -> auto___type_7 X1 -> auto_knows_old (crypt (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_33 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3.
  case (rem_2841 X1 X2 X3 X4 X5 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_33_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2843 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___def_17 (cons X3 nil) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_16 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_16 X1 -> auto___def_16 X1). tauto. exact (rem_53 X1).
Qed.

Remark rem_2844 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___def_17 (cons X3 nil) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_23 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_23 X1 -> auto___def_23 X1). tauto. exact (rem_1345 X1).
Qed.

Remark rem_2845 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___def_17 (cons X3 nil) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_22 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_22 X2 -> auto___def_22 X2). tauto. exact (rem_1348 X2).
Qed.

Remark rem_2846 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___def_17 (cons X3 nil) -> auto___def_22 X2 -> auto___def_23 X1 -> (auto___def_16 X1 /\ auto___def_23 X1 /\ auto___def_22 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  cut (auto___def_16 X1). 2:apply (rem_2843 X1 X2 X3);  assumption.
  cut (auto___def_23 X1). 2:apply (rem_2844 X1 X2 X3);  assumption.
  cut (auto___def_22 X2). 2:apply (rem_2845 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_2847 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___def_17 (cons X3 nil) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_33 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  case (rem_2846 X1 X2 X3 A1 A2 A3 A4). clear  A1 A2 A3 A4. intros. apply trans___def_33_3;  tauto.
 clear  A1 A2 A3 A4. tauto.
Qed.

Remark rem_2848 : forall X1 X2 X3:term, auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_222 X1 (cons X3 nil) H);  intros.
  apply (rem_2847 X1 X2 X3);  tauto.
Qed.

Remark rem_2849 : forall X1 X2 X3 X4 X5:term, auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_29 (cons X4 (cons server nil)) -> auto___type_3 (noncea_old X4 X5) -> auto___type_4 X5 -> auto___def_33 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_33 X1 X2). tauto.
  exact (rem_2848 X1 X2 X3).
Qed.

Remark rem_2850 : forall X1 X2 X3 X4 X5:term, auto___type_4 X3 -> auto___def_15 (cons X1 (cons X4 nil)) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_old X5 X3) -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_29 (cons X4 (cons server nil)) -> auto___type_3 (noncea_old X4 X5) -> auto___type_4 X5 -> auto___def_33 X1 X2). tauto. exact (rem_2849 X1 X2 X3 X4 X5).
Qed.

Remark rem_2851 : forall X1 X2 X3 X4 X5:term, auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_old X5 X3) -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_225 X3 (cons X1 (cons X4 nil)) H);  intros.
  apply (rem_2850 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_2852 : forall X1 X2 X3 X4 X5:term, auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_18 sym -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_old X5 X3) -> auto___def_33 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_old X5 X3) -> auto___def_33 X1 X2). tauto.
  exact (rem_2851 X1 X2 X3 X4 X5).
Qed.

Remark rem_2853 : forall X1 X2 X3 X4 X5:term, auto___def_18 sym -> auto___def_29 (cons X3 (cons server nil)) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___type_3 (noncea_old X3 X4) -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_18 sym -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_old X5 X3) -> auto___def_33 X1 X2). tauto. exact (rem_2852 X1 X2 X3 X4 X5).
Qed.

Remark rem_2854 : forall X1 X2 X3 X4 X5:term, auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___type_3 (noncea_old X3 X4) -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_167 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_2853 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_2855 : forall X1 X2 X3 X4 X5:term, auto___type_3 (noncea_old X3 X4) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___type_3 (noncea_old X3 X4) -> auto___def_33 X1 X2). tauto. exact (rem_2854 X1 X2 X3 X4 X5).
Qed.

Remark rem_2856 : forall X1 X2 X3 X4 X5:term, auto___def_12 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_231 (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_2855 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_2857 : forall X1 X2 X3 X4 X5:term, auto___def_22 X2 -> auto___def_23 X1 -> auto___def_34 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_7 (key sym (cons X3 (cons server nil))) -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_233 (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
Qed.

Remark rem_2858 : forall X1 X2 X3 X4 X5:term, auto___def_34 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_7 (key sym (cons X3 (cons server nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_22 X2 -> auto___def_23 X1 -> auto___def_34 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_7 (key sym (cons X3 (cons server nil))) -> auto___def_33 X1 X2). tauto. exact (rem_2857 X1 X2 X3 X4 X5).
Qed.

Remark rem_2859 : forall X1 X2 X3 X4 X5:term, auto___def_16 (noncea_old X3 X4) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_24 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_21 X3 X4 H);  intros.
Qed.

Remark rem_2860 : forall X1 X2 X3 X4 X5:term, auto___def_16 (noncea_old X3 X4) -> auto___def_24 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_16 (noncea_old X3 X4) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_24 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_33 X1 X2). tauto. exact (rem_2859 X1 X2 X3 X4 X5).
Qed.

Remark rem_2861 : forall X1 X2 X3 X4 X5:term, auto___def_22 X2 -> auto___def_22 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_23 X1 -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_237 (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_2860 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_2862 : forall X1 X2 X3 X4 X5:term, auto___def_22 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_22 X2 -> auto___def_22 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_23 X1 -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_33 X1 X2). tauto. exact (rem_2861 X1 X2 X3 X4 X5).
Qed.

Remark rem_2863 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> auto___def_23 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_23. intro H. intros.
  elim (rem_719 H);  intros.
Defined.

Remark rem_2864 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> auto_knows_old bob -> auto___def_23 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_23. intro H. intros.
  elim (rem_62 H);  intros.
  apply (rem_2863 epsilon_mknows_old_m__def_23);  tauto.
Defined.

Remark rem_2865 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> auto___def_23 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_23. intro H. intros.
  elim (rem_721 H);  intros.
Defined.

Remark rem_2866 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> auto_knows_old alice -> auto___def_23 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_23. intro H. intros.
  elim (rem_65 H);  intros.
  apply (rem_2865 epsilon_mknows_old_m__def_23);  tauto.
Defined.

Remark rem_2867 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_23 (cons X1 X2) -> auto_knows_old X1 -> auto_knows_old X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_722 X1 X2 H);  intros.
Defined.

Remark rem_2868 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto_knows_old (cons X1 X2) -> auto___def_23 (cons X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_73 X1 X2 H);  intros.
  apply (rem_2867 epsilon_mknows_old_m__def_23 X1 X2);  tauto.
Defined.

Remark rem_2869 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> forall X1:term, auto___def_23 (s X1) -> auto_knows_old X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_23. intros X1. intro H. intros.
  elim (rem_723 X1 H);  intros.
Defined.

Remark rem_2870 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> forall X1:term, auto_knows_old (s X1) -> auto___def_23 (s X1) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_23. intros X1. intro H. intros.
  elim (rem_77 X1 H);  intros.
  apply (rem_2869 epsilon_mknows_old_m__def_23 X1);  tauto.
Defined.

Remark rem_2871 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> auto___def_23 nil -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_23. intro H. intros.
  elim (rem_724 H);  intros.
Defined.

Remark rem_2872 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> auto_knows_old nil -> auto___def_23 nil -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_23. intro H. intros.
  elim (rem_80 H);  intros.
  apply (rem_2871 epsilon_mknows_old_m__def_23);  tauto.
Defined.

Remark rem_2873 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> auto___def_23 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_23. intro H. intros.
  elim (rem_725 H);  intros.
Defined.

Remark rem_2874 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> auto_knows_old i -> auto___def_23 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_23. intro H. intros.
  elim (rem_83 H);  intros.
  apply (rem_2873 epsilon_mknows_old_m__def_23);  tauto.
Defined.

Remark rem_2875 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> forall X1:term, auto___def_18 X1 -> auto___def_35 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_mknows_old_m__def_23. exact (rem_1190).
Defined.

Remark rem_2876 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___type_8 X2 -> auto___def_35 X1 -> auto___def_25 X2 -> False. (* Split. *)
Proof.
  intros epsilon_mknows_old_m__def_23. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_35 X1 -> False). clear  epsilon_mknows_old_m__def_23. tauto.
  exact (rem_2875 epsilon_mknows_old_m__def_23 X1).
Defined.

Remark rem_2877 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_23 (key X1 X2) -> auto___def_35 X1 -> auto___type_8 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_174 X1 X2 H);  intros.
  apply (rem_2876 epsilon_mknows_old_m__def_23 X1 X2);  tauto.
Defined.

Remark rem_2878 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> forall X1:term, auto___def_18 X1 -> auto___def_36 X1 -> False. (* Cut history. *)
Proof.  intros epsilon_mknows_old_m__def_23. exact (rem_1196).
Defined.

Remark rem_2879 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_25 X2 -> auto___def_36 X1 -> auto___def_37 X2 -> False. (* Split. *)
Proof.
  intros epsilon_mknows_old_m__def_23. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_36 X1 -> False). clear  epsilon_mknows_old_m__def_23. tauto.
  exact (rem_2878 epsilon_mknows_old_m__def_23 X1).
Defined.

Remark rem_2880 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_23 (key X1 X2) -> auto___def_36 X1 -> auto___def_37 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_174 X1 X2 H);  intros.
  apply (rem_2879 epsilon_mknows_old_m__def_23 X1 X2);  tauto.
Defined.

Remark rem_2881 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto_knows_old (key X1 X2) -> auto___def_23 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_97 X1 X2 H);  intros.
  apply (rem_2877 epsilon_mknows_old_m__def_23 X1 X2);  tauto.
  apply (rem_2880 epsilon_mknows_old_m__def_23 X1 X2);  tauto.
Defined.

Remark rem_2882 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_23 (crypt X1 X2) -> auto___def_12 X1 -> auto___def_13 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_728 X1 X2 H);  intros.
Defined.

Remark rem_2883 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_23 (crypt X1 X2) -> auto___def_34 X1 -> auto___type_7 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_728 X1 X2 H);  intros.
Defined.

Remark rem_2884 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_23 (crypt X1 X2) -> auto___def_22 X1 -> auto___def_23 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_728 X1 X2 H);  intros.
Defined.

Remark rem_2885 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_23 (crypt X1 X2) -> auto_knows_old X1 -> auto_knows_old X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_728 X1 X2 H);  intros.
Defined.

Remark rem_2886 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_23 (crypt X1 X2) -> auto___def_32 X1 -> auto___type_6 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_728 X1 X2 H);  intros.
Defined.

Remark rem_2887 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto_knows_old (crypt X1 X2) -> auto___def_23 (crypt X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_124 X1 X2 H);  intros.
  apply (rem_2882 epsilon_mknows_old_m__def_23 X1 X2);  tauto.
  apply (rem_2883 epsilon_mknows_old_m__def_23 X1 X2);  tauto.
  apply (rem_2884 epsilon_mknows_old_m__def_23 X1 X2);  tauto.
  apply (rem_2885 epsilon_mknows_old_m__def_23 X1 X2);  tauto.
  apply (rem_2886 epsilon_mknows_old_m__def_23 X1 X2);  tauto.
Defined.

Remark rem_2888 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto___def_23 (noncea_old X1 X2) -> auto_agent X1 -> auto_agent X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_730 X1 X2 H);  intros.
Defined.

Remark rem_2889 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> forall X1 X2:term, auto_knows_old (noncea_old X1 X2) -> auto___def_23 (noncea_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_23. intros X1 X2. intro H. intros.
  elim (rem_132 X1 X2 H);  intros.
  apply (rem_2888 epsilon_mknows_old_m__def_23 X1 X2);  tauto.
Defined.

Remark rem_2890 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> auto___def_23 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_23. intro H. intros.
  elim (rem_732 H);  intros.
Defined.

Remark rem_2891 : (forall X:term, auto_knows_old X -> auto___def_23 X -> False)
    -> auto_knows_old server -> auto___def_23 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_m__def_23. intro H. intros.
  elim (rem_135 H);  intros.
  apply (rem_2890 epsilon_mknows_old_m__def_23);  tauto.
Defined.

Remark rem_2892 : forall X1:term, auto_knows_old X1 -> auto___def_23 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_mknows_old_m__def_23 1.
  intro X. case X.
  exact (rem_2866 epsilon_mknows_old_m__def_23 ).
  exact (rem_2864 epsilon_mknows_old_m__def_23 ).
  intros X1 X2;  exact (rem_2868 epsilon_mknows_old_m__def_23 X1 X2).
  intros X1 X2;  exact (rem_2887 epsilon_mknows_old_m__def_23 X1 X2).
  exact (rem_2874 epsilon_mknows_old_m__def_23 ).
  intros X1 X2;  exact (rem_2881 epsilon_mknows_old_m__def_23 X1 X2).
  exact (rem_2872 epsilon_mknows_old_m__def_23 ).
  intros X1 X2. intro H. elim (rem_137 X1 X2 H).
  intros X1 X2;  exact (rem_2889 epsilon_mknows_old_m__def_23 X1 X2).
  intros X1 X2 X3. intro H. elim (rem_139 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_140 X1 X2 X3 H).
   intro H. elim (rem_143  H).
   intro H. elim (rem_142  H).
  intros X1;  exact (rem_2870 epsilon_mknows_old_m__def_23 X1).
  exact (rem_2891 epsilon_mknows_old_m__def_23 ).
  intros X1 X2 X3. intro H. elim (rem_138 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_141 X1 X2 X3 H).
   intro H. elim (rem_144  H).
Qed.

Remark rem_2893 : forall X1 X2 X3:term, auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_old X1 -> auto_knows_old (cons X3 nil) -> auto___def_33 X1 X2. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3. intros.
  assert (HH:=(rem_2892 X1)). tauto.
Qed.

Remark rem_2894 : forall X1 X2 X3:term, auto_knows_old X1 -> auto_knows_old (cons X3 nil) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_old X1 -> auto_knows_old (cons X3 nil) -> auto___def_33 X1 X2). tauto. exact (rem_2893 X1 X2 X3).
Qed.

Remark rem_2895 : forall X1 X2 X3:term, auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_old (cons X1 (cons X3 nil)) -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1 H2. intro H. intros.
  elim (rem_73 X1 (cons X3 nil) H);  intros.
  apply (rem_2894 X1 X2 X3);  tauto.
Qed.

Remark rem_2896 : forall X1 X2 X4:term, auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_old (cons X1 (cons X4 nil)) -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_old (cons X1 (cons X3 nil)) -> auto___def_33 X1 X2). tauto. exact (rem_2895 X1 X2 X3).
Qed.

Remark rem_2897 : forall X1 X2 X3 X4 X5:term, auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_old X3 -> auto_knows_old (cons X1 (cons X4 nil)) -> auto_knows_old (key sym (cons X5 (cons server nil))) -> auto_knows_old (noncea_old X5 X3) -> auto___def_33 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_old (cons X1 (cons X4 nil)) -> auto___def_33 X1 X2). tauto.
  exact (rem_2896 X1 X2 X4).
Qed.

Remark rem_2898 : forall X1 X2 X3 X4 X5:term, auto_knows_old X3 -> auto_knows_old (cons X1 (cons X4 nil)) -> auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_old (key sym (cons X5 (cons server nil))) -> auto_knows_old (noncea_old X5 X3) -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_old X3 -> auto_knows_old (cons X1 (cons X4 nil)) -> auto_knows_old (key sym (cons X5 (cons server nil))) -> auto_knows_old (noncea_old X5 X3) -> auto___def_33 X1 X2). tauto. exact (rem_2897 X1 X2 X3 X4 X5).
Qed.

Remark rem_2899 : forall X1 X2 X3 X4 X5:term, auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_old (cons X3 (cons X1 (cons X4 nil))) -> auto_knows_old (key sym (cons X5 (cons server nil))) -> auto_knows_old (noncea_old X5 X3) -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_73 X3 (cons X1 (cons X4 nil)) H);  intros.
  apply (rem_2898 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_2900 : forall X1 X2 X3 X4 X5:term, auto_knows_old (noncea_old X3 X4) -> auto_knows_old (cons X4 (cons X1 (cons X5 nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_old (cons X3 (cons X1 (cons X4 nil))) -> auto_knows_old (key sym (cons X5 (cons server nil))) -> auto_knows_old (noncea_old X5 X3) -> auto___def_33 X1 X2). tauto. exact (rem_2899 X1 X2 X3 X4 X5).
Qed.

Remark rem_2901 : forall X1 X2 X3 X4 X5:term, auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_old (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_73 (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_2900 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_2902 : forall X1 X2 X3 X4 X5:term, auto_knows_old (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_old (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto___def_33 X1 X2). tauto. exact (rem_2901 X1 X2 X3 X4 X5).
Qed.

Remark rem_2903 : forall X1 X2 X3 X4 X5:term, auto___def_22 X2 -> auto___def_23 X1 -> auto___def_32 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_6 (key sym (cons X3 (cons server nil))) -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_255 (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
Qed.

Remark rem_2904 : forall X1 X2 X3 X4 X5:term, auto___def_32 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_6 (key sym (cons X3 (cons server nil))) -> auto___def_22 X2 -> auto___def_23 X1 -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_22 X2 -> auto___def_23 X1 -> auto___def_32 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_6 (key sym (cons X3 (cons server nil))) -> auto___def_33 X1 X2). tauto. exact (rem_2903 X1 X2 X3 X4 X5).
Qed.

Remark rem_2905 : forall X1 X2 X3 X4 X5:term, auto___def_22 X2 -> auto___def_23 X1 -> auto_knows_old (crypt (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_124 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil))) H);  intros.
  apply (rem_2856 X1 X2 X3 X4 X5);  tauto.
  apply (rem_2858 X1 X2 X3 X4 X5);  tauto.
  apply (rem_2862 X1 X2 X3 X4 X5);  tauto.
  apply (rem_2902 X1 X2 X3 X4 X5);  tauto.
  apply (rem_2904 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_2906 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___def_17 (cons X3 nil) -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_16 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_16 X1 -> auto___def_16 X1). tauto. exact (rem_53 X1).
Qed.

Remark rem_2907 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___def_17 (cons X3 nil) -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_old X1 -> auto_knows_old X1). tauto. exact (rem_150 X1).
Qed.

Remark rem_2908 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___def_17 (cons X3 nil) -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_152 X2).
Qed.

Remark rem_2909 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___def_17 (cons X3 nil) -> auto_knows_old X2 -> auto_knows_old X1 -> (auto___def_16 X1 /\ auto_knows_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  cut (auto___def_16 X1). 2:apply (rem_2906 X1 X2 X3);  assumption.
  cut (auto_knows_old X1). 2:apply (rem_2907 X1 X2 X3);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_2908 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_2910 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___def_17 (cons X3 nil) -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_33 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  case (rem_2909 X1 X2 X3 A1 A2 A3 A4). clear  A1 A2 A3 A4. intros. apply trans___def_33_2;  tauto.
 clear  A1 A2 A3 A4. tauto.
Qed.

Remark rem_2911 : forall X1 X2 X3:term, auto___def_15 (cons X1 (cons X3 nil)) -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_222 X1 (cons X3 nil) H);  intros.
  apply (rem_2910 X1 X2 X3);  tauto.
Qed.

Remark rem_2912 : forall X1 X2 X3 X4 X5:term, auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_29 (cons X4 (cons server nil)) -> auto___type_3 (noncea_old X4 X5) -> auto___type_4 X5 -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_33 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_15 (cons X1 (cons X3 nil)) -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_33 X1 X2). tauto.
  exact (rem_2911 X1 X2 X3).
Qed.

Remark rem_2913 : forall X1 X2 X3 X4 X5:term, auto___type_4 X3 -> auto___def_15 (cons X1 (cons X4 nil)) -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_old X5 X3) -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_15 (cons X1 (cons X3 nil)) -> auto___def_29 (cons X4 (cons server nil)) -> auto___type_3 (noncea_old X4 X5) -> auto___type_4 X5 -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_33 X1 X2). tauto. exact (rem_2912 X1 X2 X3 X4 X5).
Qed.

Remark rem_2914 : forall X1 X2 X3 X4 X5:term, auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_old X5 X3) -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_225 X3 (cons X1 (cons X4 nil)) H);  intros.
  apply (rem_2913 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_2915 : forall X1 X2 X3 X4 X5:term, auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_18 sym -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_old X5 X3) -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_33 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_old X5 X3) -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_33 X1 X2). tauto.
  exact (rem_2914 X1 X2 X3 X4 X5).
Qed.

Remark rem_2916 : forall X1 X2 X3 X4 X5:term, auto___def_18 sym -> auto___def_29 (cons X3 (cons server nil)) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___type_3 (noncea_old X3 X4) -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto___def_14 (cons X3 (cons X1 (cons X4 nil))) -> auto___def_18 sym -> auto___def_29 (cons X5 (cons server nil)) -> auto___type_3 (noncea_old X5 X3) -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_33 X1 X2). tauto. exact (rem_2915 X1 X2 X3 X4 X5).
Qed.

Remark rem_2917 : forall X1 X2 X3 X4 X5:term, auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___type_3 (noncea_old X3 X4) -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_167 sym (cons X3 (cons server nil)) H);  intros.
  apply (rem_2916 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_2918 : forall X1 X2 X3 X4 X5:term, auto___type_3 (noncea_old X3 X4) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_13 (key sym (cons X3 (cons server nil))) -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_13 (key sym (cons X3 (cons server nil))) -> auto___def_14 (cons X4 (cons X1 (cons X5 nil))) -> auto___type_3 (noncea_old X3 X4) -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_33 X1 X2). tauto. exact (rem_2917 X1 X2 X3 X4 X5).
Qed.

Remark rem_2919 : forall X1 X2 X3 X4 X5:term, auto___def_12 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_13 (key sym (cons X3 (cons server nil))) -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_231 (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_2918 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_2920 : forall X1 X2 X3 X4 X5:term, auto___def_34 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_7 (key sym (cons X3 (cons server nil))) -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_233 (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
Qed.

Remark rem_2921 : forall X1 X2 X3 X4 X5:term, auto___def_16 (noncea_old X3 X4) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_24 (cons X4 (cons X1 (cons X5 nil))) -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_21 X3 X4 H);  intros.
Qed.

Remark rem_2922 : forall X1 X2 X3 X4 X5:term, auto___def_16 (noncea_old X3 X4) -> auto___def_24 (cons X4 (cons X1 (cons X5 nil))) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_16 (noncea_old X3 X4) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto___def_24 (cons X4 (cons X1 (cons X5 nil))) -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_33 X1 X2). tauto. exact (rem_2921 X1 X2 X3 X4 X5).
Qed.

Remark rem_2923 : forall X1 X2 X3 X4 X5:term, auto___def_22 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___def_23 (key sym (cons X3 (cons server nil))) -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_237 (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_2922 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_2924 : forall X1 X2:term, auto___def_35 sym -> auto_knows_old X1 -> auto_knows_old (noncea_old X2 X1) -> False. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_35 sym -> False). tauto.
  exact (rem_240).
Qed.

Remark rem_2925 : forall X1 X2:term, auto___def_35 sym -> auto_knows_old X2 -> auto_knows_old (noncea_old X1 X2) -> False. (* Prove equivalent, normalized clause. *)
Proof.
   intros X2 X1.
  cut (auto___def_35 sym -> auto_knows_old X1 -> auto_knows_old (noncea_old X2 X1) -> False). tauto. exact (rem_2924 X1 X2).
Qed.

Remark rem_2926 : forall X1 X2:term, auto___def_35 sym -> auto___type_8 (cons X1 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old (noncea_old X1 X2) -> False. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2. intros. apply (rem_2925 X1 X2);  assumption.
Qed.

Remark rem_2927 : forall X1 X2:term, auto___def_35 sym -> auto___type_8 (cons X2 (cons server nil)) -> auto_knows_old X1 -> auto_knows_old (noncea_old X2 X1) -> False. (* Prove equivalent, normalized clause. *)
Proof.
   intros X2 X1.
  cut (auto___def_35 sym -> auto___type_8 (cons X1 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old (noncea_old X1 X2) -> False). tauto. exact (rem_2926 X1 X2).
Qed.

Remark rem_2928 : forall X1 X2:term, auto___def_36 sym -> auto___def_37 (cons X1 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old (noncea_old X1 X2) -> False. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_36 sym -> False). tauto.
  exact (rem_1054).
Qed.

Remark rem_2929 : forall X1 X2:term, auto___def_36 sym -> auto___def_37 (cons X2 (cons server nil)) -> auto_knows_old X1 -> auto_knows_old (noncea_old X2 X1) -> False. (* Prove equivalent, normalized clause. *)
Proof.
   intros X2 X1.
  cut (auto___def_36 sym -> auto___def_37 (cons X1 (cons server nil)) -> auto_knows_old X2 -> auto_knows_old (noncea_old X1 X2) -> False). tauto. exact (rem_2928 X1 X2).
Qed.

Remark rem_2930 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old (key sym (cons X2 (cons server nil))) -> auto_knows_old (noncea_old X2 X1) -> False. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_97 sym (cons X2 (cons server nil)) H);  intros.
  apply (rem_2927 X1 X2);  tauto.
  apply (rem_2929 X1 X2);  tauto.
Qed.

Remark rem_2931 : forall X3 X5:term, auto_knows_old X3 -> auto_knows_old (key sym (cons X5 (cons server nil))) -> auto_knows_old (noncea_old X5 X3) -> False. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto_knows_old X1 -> auto_knows_old (key sym (cons X2 (cons server nil))) -> auto_knows_old (noncea_old X2 X1) -> False). tauto. exact (rem_2930 X1 X2).
Qed.

Remark rem_2932 : forall X1 X2 X3 X4 X5:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old (cons X1 (cons X4 nil)) -> auto_knows_old (key sym (cons X5 (cons server nil))) -> auto_knows_old (noncea_old X5 X3) -> auto___def_33 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto_knows_old X3 -> auto_knows_old (key sym (cons X5 (cons server nil))) -> auto_knows_old (noncea_old X5 X3) -> False). tauto.
  exact (rem_2931 X3 X5).
Qed.

Remark rem_2933 : forall X1 X2 X3 X4 X5:term, auto_knows_old X3 -> auto_knows_old (cons X1 (cons X4 nil)) -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old (key sym (cons X5 (cons server nil))) -> auto_knows_old (noncea_old X5 X3) -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old (cons X1 (cons X4 nil)) -> auto_knows_old (key sym (cons X5 (cons server nil))) -> auto_knows_old (noncea_old X5 X3) -> auto___def_33 X1 X2). tauto. exact (rem_2932 X1 X2 X3 X4 X5).
Qed.

Remark rem_2934 : forall X1 X2 X3 X4 X5:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old (cons X3 (cons X1 (cons X4 nil))) -> auto_knows_old (key sym (cons X5 (cons server nil))) -> auto_knows_old (noncea_old X5 X3) -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_73 X3 (cons X1 (cons X4 nil)) H);  intros.
  apply (rem_2933 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_2935 : forall X1 X2 X3 X4 X5:term, auto_knows_old (noncea_old X3 X4) -> auto_knows_old (cons X4 (cons X1 (cons X5 nil))) -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X3 X4.
  cut (auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old (cons X3 (cons X1 (cons X4 nil))) -> auto_knows_old (key sym (cons X5 (cons server nil))) -> auto_knows_old (noncea_old X5 X3) -> auto___def_33 X1 X2). tauto. exact (rem_2934 X1 X2 X3 X4 X5).
Qed.

Remark rem_2936 : forall X1 X2 X3 X4 X5:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_73 (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
  apply (rem_2935 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_2937 : forall X1 X2 X3 X4 X5:term, auto_knows_old (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto_knows_old (key sym (cons X3 (cons server nil))) -> auto___def_33 X1 X2). tauto. exact (rem_2936 X1 X2 X3 X4 X5).
Qed.

Remark rem_2938 : forall X1 X2 X3 X4 X5:term, auto___def_32 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) -> auto___type_6 (key sym (cons X3 (cons server nil))) -> auto_knows_old X2 -> auto_knows_old X1 -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_255 (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil))) H);  intros.
Qed.

Remark rem_2939 : forall X1 X2 X3 X4 X5:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old (crypt (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_124 (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil))) H);  intros.
  apply (rem_2919 X1 X2 X3 X4 X5);  tauto.
  apply (rem_2920 X1 X2 X3 X4 X5);  tauto.
  apply (rem_2923 X1 X2 X3 X4 X5);  tauto.
  apply (rem_2937 X1 X2 X3 X4 X5);  tauto.
  apply (rem_2938 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_2940 : (forall X:term, auto___type_6 X -> auto___def_16 X)
    -> forall X1:term, auto___def_18 X1 -> auto___def_18 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2941 : (forall X:term, auto___type_6 X -> auto___def_16 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_18 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_p__def_16. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_18 X1). tauto. exact (rem_2940 epsilon_m__type_6_p__def_16 X1).
Defined.

Remark rem_2942 : (forall X:term, auto___type_6 X -> auto___def_16 X)
    -> forall X2:term, auto___def_19 X2 -> auto___def_19 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2943 : (forall X:term, auto___type_6 X -> auto___def_16 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_19 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_6_p__def_16. intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_19 X2). tauto. exact (rem_2942 epsilon_m__type_6_p__def_16 X2).
Defined.

Remark rem_2944 : (forall X:term, auto___type_6 X -> auto___def_16 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> (auto___def_18 X1 /\ auto___def_19 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_6_p__def_16. intros X1 X2. intros A1 A2.
  cut (auto___def_18 X1). 2:apply (rem_2941 epsilon_m__type_6_p__def_16 X1 X2);  assumption.
  cut (auto___def_19 X2). 2:apply (rem_2943 epsilon_m__type_6_p__def_16 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2945 : (forall X:term, auto___type_6 X -> auto___def_16 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_16 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_p__def_16. intros X1 X2. intros A1 A2.
  case (rem_2944 epsilon_m__type_6_p__def_16 X1 X2 A1 A2). clear  epsilon_m__type_6_p__def_16 A1 A2. intros. apply trans___def_16_key_1;  tauto.
 clear  epsilon_m__type_6_p__def_16 A1 A2. tauto.
Defined.

Remark rem_2946 : (forall X:term, auto___type_6 X -> auto___def_16 X)
    -> forall X1 X2:term, auto___type_6 (key X1 X2) -> auto___def_16 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_p__def_16. intros X1 X2. intro H. intros.
  elim (rem_187 X1 X2 H);  intros.
  apply (rem_2945 epsilon_m__type_6_p__def_16 X1 X2);  tauto.
Defined.

Remark rem_2947 : forall X1:term, auto___type_6 X1 -> auto___def_16 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_6_p__def_16 1.
  intro X. case X.
   intro H. elim (rem_1858  H).
   intro H. elim (rem_1856  H).
  intros X1 X2. intro H. elim (rem_1859 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1865 X1 X2 H).
   intro H. elim (rem_1862  H).
  intros X1 X2;  exact (rem_2946 epsilon_m__type_6_p__def_16 X1 X2).
   intro H. elim (rem_1861  H).
  intros X1 X2. intro H. elim (rem_1855 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1867 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1863 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1864 X1 X2 X3 H).
   intro H. elim (rem_1870  H).
   intro H. elim (rem_1868  H).
  intros X1. intro H. elim (rem_1860 X1 H).
   intro H. elim (rem_1869  H).
  intros X1 X2 X3. intro H. elim (rem_1857 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1866 X1 X2 X3 H).
   intro H. elim (rem_1871  H).
Qed.

Remark rem_2948 : forall X1 X2 X3 X4 X5:term, auto___def_32 X2 -> auto___type_6 X1 -> auto_knows_old (crypt (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_16 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_6 X1 -> auto___def_16 X1). tauto. exact (rem_2947 X1).
Qed.

Remark rem_2949 : forall X1:term, auto___type_6 X1 -> auto___type_6 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2950 : forall X1 X2 X3 X4 X5:term, auto___def_32 X2 -> auto___type_6 X1 -> auto_knows_old (crypt (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___type_6 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_6 X1 -> auto___type_6 X1). tauto. exact (rem_2949 X1).
Qed.

Remark rem_2951 : forall X2:term, auto___def_32 X2 -> auto___def_32 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2952 : forall X1 X2 X3 X4 X5:term, auto___def_32 X2 -> auto___type_6 X1 -> auto_knows_old (crypt (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_32 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_32 X2 -> auto___def_32 X2). tauto. exact (rem_2951 X2).
Qed.

Remark rem_2953 : forall X1 X2 X3 X4 X5:term, auto___def_32 X2 -> auto___type_6 X1 -> auto_knows_old (crypt (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> (auto___def_16 X1 /\ auto___type_6 X1 /\ auto___def_32 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3.
  cut (auto___def_16 X1). 2:apply (rem_2948 X1 X2 X3 X4 X5);  assumption.
  cut (auto___type_6 X1). 2:apply (rem_2950 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_32 X2). 2:apply (rem_2952 X1 X2 X3 X4 X5);  assumption.
  tauto.
Qed.

Remark rem_2954 : forall X1 X2 X3 X4 X5:term, auto___def_32 X2 -> auto___type_6 X1 -> auto_knows_old (crypt (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_33 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3.
  case (rem_2953 X1 X2 X3 X4 X5 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_33_5;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_2955 : forall X1 X2 X3 X4 X5:term, auto_knows_old (crypt X2 X1) -> auto_knows_old (crypt (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_33 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_124 X2 X1 H);  intros.
  apply (rem_2827 X1 X2 X3 X4 X5);  tauto.
  apply (rem_2842 X1 X2 X3 X4 X5);  tauto.
  apply (rem_2905 X1 X2 X3 X4 X5);  tauto.
  apply (rem_2939 X1 X2 X3 X4 X5);  tauto.
  apply (rem_2954 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_2956 : forall X1 X2 X3 X4 X5:term, auto_knows_old (crypt (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> auto_knows_old (crypt X2 X1) -> auto___def_33 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_old (crypt X2 X1) -> auto_knows_old (crypt (cons (noncea_old X3 X4) (cons X4 (cons X1 (cons X5 nil)))) (key sym (cons X3 (cons server nil)))) -> auto___def_33 X1 X2). tauto. exact (rem_2955 X1 X2 X3 X4 X5).
Qed.

Remark rem_2957 : forall X1:term, auto___def_35 sym -> auto___def_6 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_35 sym -> False). tauto.
  exact (rem_240).
Qed.

Remark rem_2958 : forall X1:term, auto___def_35 sym -> auto___type_8 X1 -> auto___def_6 X1. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1. intros. apply (rem_2957 X1);  assumption.
Qed.

Remark rem_2959 : forall X1:term, auto___def_36 sym -> auto___def_37 X1 -> auto___def_6 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_36 sym -> False). tauto.
  exact (rem_1054).
Qed.

Remark rem_2960 : forall X1:term, auto_knows_old (key sym X1) -> auto___def_6 X1. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_97 sym X1 H);  intros.
  apply (rem_2958 X1);  tauto.
  apply (rem_2959 X1);  tauto.
Qed.

Remark rem_2961 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2962 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_11. intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_2961 epsilon_mknows_current_p__type_11 X1).
Defined.

Remark rem_2963 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2964 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_11. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_2963 epsilon_mknows_current_p__type_11 X2).
Defined.

Remark rem_2965 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> (auto_agent X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_11. intros X1 X2. intros A1 A2.
  cut (auto_agent X1). 2:apply (rem_2962 epsilon_mknows_current_p__type_11 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_2964 epsilon_mknows_current_p__type_11 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2966 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_11 (noncea_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_11. intros X1 X2. intros A1 A2.
  case (rem_2965 epsilon_mknows_current_p__type_11 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_11 A1 A2. intros. apply trans___type_11_noncea_current_1;  tauto.
 clear  epsilon_mknows_current_p__type_11 A1 A2. tauto.
Defined.

Remark rem_2967 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> forall X1 X2:term, auto_knows_current (noncea_current X1 X2) -> auto___type_11 (noncea_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_11. intros X1 X2. intro H. intros.
  elim (rem_416 X1 X2 H);  intros.
  apply (rem_2966 epsilon_mknows_current_p__type_11 X1 X2);  tauto.
Defined.

Remark rem_2968 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_11.  tauto.
Defined.

Remark rem_2969 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> auto___type_11 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_11.  case (rem_2968 epsilon_mknows_current_p__type_11). clear  epsilon_mknows_current_p__type_11. intros. apply trans___type_11_bob_1;  tauto.
 clear  epsilon_mknows_current_p__type_11. tauto.
Defined.

Remark rem_2970 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> auto_knows_current bob -> auto___type_11 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_11. intro H. intros.
  elim (rem_420 H);  intros.
  apply (rem_2969 epsilon_mknows_current_p__type_11);  tauto.
Defined.

Remark rem_2971 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> auto___type_11 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_11.  case (rem_2968 epsilon_mknows_current_p__type_11). clear  epsilon_mknows_current_p__type_11. intros. apply trans___type_11_alice_1;  tauto.
 clear  epsilon_mknows_current_p__type_11. tauto.
Defined.

Remark rem_2972 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> auto_knows_current alice -> auto___type_11 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_11. intro H. intros.
  elim (rem_423 H);  intros.
  apply (rem_2971 epsilon_mknows_current_p__type_11);  tauto.
Defined.

Remark rem_2973 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2974 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_11. intros X1 X2.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_2973 epsilon_mknows_current_p__type_11 X1).
Defined.

Remark rem_2975 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> forall X2:term, auto_knows_current X2 -> auto_knows_current X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2976 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_current_p__type_11. intros X1 X2.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_2975 epsilon_mknows_current_p__type_11 X2).
Defined.

Remark rem_2977 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_11. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2974 epsilon_mknows_current_p__type_11 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2976 epsilon_mknows_current_p__type_11 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2978 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto___type_11 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_11. intros X1 X2. intros A1 A2.
  case (rem_2977 epsilon_mknows_current_p__type_11 X1 X2 A1 A2). clear  epsilon_mknows_current_p__type_11 A1 A2. intros. apply trans___type_11_cons_1;  tauto.
 clear  epsilon_mknows_current_p__type_11 A1 A2. tauto.
Defined.

Remark rem_2979 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> forall X1 X2:term, auto_knows_current (cons X1 X2) -> auto___type_11 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_11. intros X1 X2. intro H. intros.
  elim (rem_431 X1 X2 H);  intros.
  apply (rem_2978 epsilon_mknows_current_p__type_11 X1 X2);  tauto.
Defined.

Remark rem_2980 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_current_p__type_11. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_2973 epsilon_mknows_current_p__type_11 X1);  assumption.
  tauto.
Defined.

Remark rem_2981 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> forall X1:term, auto_knows_current X1 -> auto___type_11 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_11. intros X1. intros A1.
  case (rem_2980 epsilon_mknows_current_p__type_11 X1 A1). clear  epsilon_mknows_current_p__type_11 A1. intros. apply trans___type_11_s_1;  tauto.
 clear  epsilon_mknows_current_p__type_11 A1. tauto.
Defined.

Remark rem_2982 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> forall X1:term, auto_knows_current (s X1) -> auto___type_11 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_11. intros X1. intro H. intros.
  elim (rem_435 X1 H);  intros.
  apply (rem_2981 epsilon_mknows_current_p__type_11 X1);  tauto.
Defined.

Remark rem_2983 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> auto___type_11 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_11.  case (rem_2968 epsilon_mknows_current_p__type_11). clear  epsilon_mknows_current_p__type_11. intros. apply trans___type_11_nil_1;  tauto.
 clear  epsilon_mknows_current_p__type_11. tauto.
Defined.

Remark rem_2984 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> auto_knows_current nil -> auto___type_11 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_11. intro H. intros.
  elim (rem_438 H);  intros.
  apply (rem_2983 epsilon_mknows_current_p__type_11);  tauto.
Defined.

Remark rem_2985 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> auto___type_11 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_current_p__type_11.  case (rem_2968 epsilon_mknows_current_p__type_11). clear  epsilon_mknows_current_p__type_11. intros. apply trans___type_11_i_1;  tauto.
 clear  epsilon_mknows_current_p__type_11. tauto.
Defined.

Remark rem_2986 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> auto_knows_current i -> auto___type_11 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_p__type_11. intro H. intros.
  elim (rem_441 H);  intros.
  apply (rem_2985 epsilon_mknows_current_p__type_11);  tauto.
Defined.

Remark rem_2987 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> forall X1:term, auto___def_39 X1 -> auto___def_39 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2988 : (forall X:term, auto_knows_current X -> auto___type_11 X)
    -> forall X1 X2:term, auto___def_39 X1 -> auto___def_40 X2 -> auto___def_39 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_cu