
Inductive val : Set :=
	v1 : val | v2 : val | v3 : val | v4 : val.

Definition auto_agent (x1 : val) : Prop :=
  match x1 with
  | v1 => True
  | _ => False
  end.

Definition alice : val := v1.
Definition auto_alice_key_current (x1 x2 : val) : Prop :=
  match x1,x2 with
  | v1,v3 => True
  | v1,v4 => True
  | v2,v1 => True
  | v2,v2 => True
  | v2,v3 => True
  | v2,v4 => True
  | v3,v1 => True
  | v3,v2 => True
  | v3,v3 => True
  | v3,v4 => True
  | v4,v1 => True
  | v4,v2 => True
  | v4,v3 => True
  | v4,v4 => True
  | _,_ => False
  end.

Definition auto_alice_key_old (x1 x2 : val) : Prop :=
  match x1,x2 with
    _,_ => True
  end.

Definition bob : val := v1.
Definition auto_bob_key_current (x1 x2 : val) : Prop :=
  match x1,x2 with
    _,_ => True
  end.
Definition auto_bob_key_old (x1 x2 : val) : Prop :=
  match x1,x2 with
    _,_ => True
  end.

Definition cons (x1 x2 : val) : val :=
  match x1,x2 with
  | v1,v1 => v1
  | v1,v2 => v2
  | v1,v3 => v4
  | v1,v4 => v3
  | v2,v1 => v2
  | v2,v2 => v2
  | v2,v3 => v4
  | v2,v4 => v3
  | v3,v1 => v4
  | v3,v2 => v4
  | v3,v3 => v4
  | v3,v4 => v3
  | v4,v1 => v4
  | v4,v2 => v3
  | v4,v3 => v3
  | v4,v4 => v3
  end.
Definition crypt (x1 x2 : val) : val :=
  match x1,x2 with
  | v1,v1 => v1
  | v1,v2 => v1
  | v1,v3 => v4
  | v1,v4 => v1
  | v2,v1 => v2
  | v2,v2 => v1
  | v2,v3 => v4
  | v2,v4 => v4
  | v3,v1 => v3
  | v3,v2 => v4
  | v3,v3 => v4
  | v3,v4 => v4
  | v4,v1 => v3
  | v4,v2 => v2
  | v4,v3 => v2
  | v4,v4 => v2
  end.

Definition i : val := v1.
Definition key (x1 x2 : val) : val :=
  match x1,x2 with
  | v1,v1 => v1
  | v1,v2 => v1
  | v1,v3 => v1
  | v1,v4 => v1
  | v2,v1 => v4
  | v2,v2 => v4
  | v2,v3 => v1
  | v2,v4 => v3
  | v3,v1 => v2
  | v3,v2 => v1
  | v3,v3 => v1
  | v3,v4 => v1
  | v4,v1 => v2
  | v4,v2 => v1
  | v4,v3 => v1
  | v4,v4 => v1
  end.

Definition auto_knows_current (x1 : val) : Prop :=
  match x1 with
    v1 => True
  | v2 => True
  | _ => False
  end.

Definition auto_knows_old (x1 : val) : Prop :=
  match x1 with
    v1 => True
  | _ => False
  end.

Definition nil : val := v1.
Definition noncea_current (x1 x2 : val) : val :=
  match x1,x2 with
  | v1,v1 => v2
  | v1,v2 => v2
  | v1,v3 => v4
  | v1,v4 => v4
  | v2,v1 => v4
  | v2,v2 => v2
  | v2,v3 => v4
  | v2,v4 => v4
  | v3,v1 => v4
  | v3,v2 => v4
  | v3,v3 => v4
  | v3,v4 => v4
  | v4,v1 => v4
  | v4,v2 => v4
  | v4,v3 => v4
  | v4,v4 => v4
  end.
Definition noncea_old (x1 x2 : val) : val :=
  match x1,x2 with
  | v1,v1 => v1
  | v1,v2 => v2
  | v1,v3 => v2
  | v1,v4 => v2
  | v2,v1 => v1
  | v2,v2 => v1
  | v2,v3 => v1
  | v2,v4 => v2
  | v3,v1 => v1
  | v3,v2 => v2
  | v3,v3 => v2
  | v3,v4 => v2
  | v4,v1 => v1
  | v4,v2 => v1
  | v4,v3 => v2
  | v4,v4 => v1
  end.
Definition nonceb_current (x1 x2 x3 : val) : val :=
  match x1,x2,x3 with
  | v1,v1,v1 => v1
  | v1,v1,v2 => v2
  | v1,v1,v3 => v1
  | v1,v1,v4 => v1
  | v1,v2,v1 => v4
  | v1,v2,v2 => v1
  | v1,v2,v3 => v1
  | v1,v2,v4 => v3
  | v1,v3,v1 => v1
  | v1,v3,v2 => v1
  | v1,v3,v3 => v1
  | v1,v3,v4 => v1
  | v1,v4,v1 => v1
  | v1,v4,v2 => v1
  | v1,v4,v3 => v1
  | v1,v4,v4 => v3
  | v2,v1,v1 => v1
  | v2,v1,v2 => v3
  | v2,v1,v3 => v1
  | v2,v1,v4 => v4
  | v2,v2,v1 => v4
  | v2,v2,v2 => v3
  | v2,v2,v3 => v1
  | v2,v2,v4 => v3
  | v2,v3,v1 => v1
  | v2,v3,v2 => v2
  | v2,v3,v3 => v2
  | v2,v3,v4 => v1
  | v2,v4,v1 => v1
  | v2,v4,v2 => v1
  | v2,v4,v3 => v1
  | v2,v4,v4 => v1
  | v3,v1,v1 => v4
  | v3,v1,v2 => v4
  | v3,v1,v3 => v4
  | v3,v1,v4 => v4
  | v3,v2,v1 => v4
  | v3,v2,v2 => v4
  | v3,v2,v3 => v4
  | v3,v2,v4 => v4
  | v3,v3,v1 => v4
  | v3,v3,v2 => v4
  | v3,v3,v3 => v1
  | v3,v3,v4 => v4
  | v3,v4,v1 => v3
  | v3,v4,v2 => v4
  | v3,v4,v3 => v2
  | v3,v4,v4 => v4
  | v4,v1,v1 => v1
  | v4,v1,v2 => v1
  | v4,v1,v3 => v1
  | v4,v1,v4 => v1
  | v4,v2,v1 => v1
  | v4,v2,v2 => v1
  | v4,v2,v3 => v1
  | v4,v2,v4 => v1
  | v4,v3,v1 => v4
  | v4,v3,v2 => v4
  | v4,v3,v3 => v1
  | v4,v3,v4 => v1
  | v4,v4,v1 => v1
  | v4,v4,v2 => v1
  | v4,v4,v3 => v1
  | v4,v4,v4 => v1
  end.
Definition nonceb_old (x1 x2 x3 : val) : val :=
  match x1,x2,x3 with
  | v1,v1,v1 => v1
  | v1,v1,v2 => v1
  | v1,v1,v3 => v1
  | v1,v1,v4 => v2
  | v1,v2,v1 => v1
  | v1,v2,v2 => v1
  | v1,v2,v3 => v1
  | v1,v2,v4 => v1
  | v1,v3,v1 => v1
  | v1,v3,v2 => v1
  | v1,v3,v3 => v1
  | v1,v3,v4 => v1
  | v1,v4,v1 => v1
  | v1,v4,v2 => v1
  | v1,v4,v3 => v1
  | v1,v4,v4 => v1
  | v2,v1,v1 => v1
  | v2,v1,v2 => v1
  | v2,v1,v3 => v2
  | v2,v1,v4 => v1
  | v2,v2,v1 => v2
  | v2,v2,v2 => v1
  | v2,v2,v3 => v2
  | v2,v2,v4 => v2
  | v2,v3,v1 => v2
  | v2,v3,v2 => v2
  | v2,v3,v3 => v2
  | v2,v3,v4 => v1
  | v2,v4,v1 => v2
  | v2,v4,v2 => v2
  | v2,v4,v3 => v1
  | v2,v4,v4 => v1
  | v3,v1,v1 => v2
  | v3,v1,v2 => v2
  | v3,v1,v3 => v2
  | v3,v1,v4 => v2
  | v3,v2,v1 => v1
  | v3,v2,v2 => v1
  | v3,v2,v3 => v1
  | v3,v2,v4 => v2
  | v3,v3,v1 => v2
  | v3,v3,v2 => v2
  | v3,v3,v3 => v1
  | v3,v3,v4 => v1
  | v3,v4,v1 => v1
  | v3,v4,v2 => v1
  | v3,v4,v3 => v2
  | v3,v4,v4 => v1
  | v4,v1,v1 => v1
  | v4,v1,v2 => v1
  | v4,v1,v3 => v1
  | v4,v1,v4 => v1
  | v4,v2,v1 => v1
  | v4,v2,v2 => v1
  | v4,v2,v3 => v1
  | v4,v2,v4 => v1
  | v4,v3,v1 => v1
  | v4,v3,v2 => v1
  | v4,v3,v3 => v1
  | v4,v3,v4 => v1
  | v4,v4,v1 => v2
  | v4,v4,v2 => v1
  | v4,v4,v3 => v1
  | v4,v4,v4 => v1
  end.

Definition prv : val := v1.
Definition pub : val := v1.
Definition s (x1:val) : val :=
  match x1 with
  | v1 => v1
  | v2 => v2
  | v3 => v4
  | v4 => v4
  end.
Definition server : val := v1.
Definition session_current (x1 x2 x3 : val) : val :=
  match x1,x2,x3 with
  | v1,v1,v1 => v4
  | v1,v1,v2 => v4
  | v1,v1,v3 => v1
  | v1,v1,v4 => v4
  | v1,v2,v1 => v4
  | v1,v2,v2 => v4
  | v1,v2,v3 => v1
  | v1,v2,v4 => v1
  | v1,v3,v1 => v3
  | v1,v3,v2 => v3
  | v1,v3,v3 => v4
  | v1,v3,v4 => v1
  | v1,v4,v1 => v3
  | v1,v4,v2 => v3
  | v1,v4,v3 => v3
  | v1,v4,v4 => v3
  | v2,v1,v1 => v4
  | v2,v1,v2 => v4
  | v2,v1,v3 => v3
  | v2,v1,v4 => v4
  | v2,v2,v1 => v4
  | v2,v2,v2 => v4
  | v2,v2,v3 => v4
  | v2,v2,v4 => v4
  | v2,v3,v1 => v1
  | v2,v3,v2 => v4
  | v2,v3,v3 => v4
  | v2,v3,v4 => v1
  | v2,v4,v1 => v1
  | v2,v4,v2 => v1
  | v2,v4,v3 => v1
  | v2,v4,v4 => v1
  | v3,v1,v1 => v4
  | v3,v1,v2 => v3
  | v3,v1,v3 => v4
  | v3,v1,v4 => v4
  | v3,v2,v1 => v3
  | v3,v2,v2 => v3
  | v3,v2,v3 => v4
  | v3,v2,v4 => v4
  | v3,v3,v1 => v3
  | v3,v3,v2 => v3
  | v3,v3,v3 => v3
  | v3,v3,v4 => v3
  | v3,v4,v1 => v3
  | v3,v4,v2 => v3
  | v3,v4,v3 => v3
  | v3,v4,v4 => v4
  | v4,v1,v1 => v4
  | v4,v1,v2 => v3
  | v4,v1,v3 => v3
  | v4,v1,v4 => v4
  | v4,v2,v1 => v4
  | v4,v2,v2 => v4
  | v4,v2,v3 => v4
  | v4,v2,v4 => v3
  | v4,v3,v1 => v4
  | v4,v3,v2 => v3
  | v4,v3,v3 => v4
  | v4,v3,v4 => v3
  | v4,v4,v1 => v3
  | v4,v4,v2 => v4
  | v4,v4,v3 => v4
  | v4,v4,v4 => v4
  end.
Definition session_old (x1 x2 x3 : val) : val :=
  match x1,x2,x3 with
  | v1,v1,v1 => v3
  | v1,v1,v2 => v3
  | v1,v1,v3 => v3
  | v1,v1,v4 => v3
  | v1,v2,v1 => v3
  | v1,v2,v2 => v3
  | v1,v2,v3 => v3
  | v1,v2,v4 => v3
  | v1,v3,v1 => v3
  | v1,v3,v2 => v3
  | v1,v3,v3 => v3
  | v1,v3,v4 => v3
  | v1,v4,v1 => v3
  | v1,v4,v2 => v3
  | v1,v4,v3 => v3
  | v1,v4,v4 => v3
  | v2,v1,v1 => v3
  | v2,v1,v2 => v3
  | v2,v1,v3 => v3
  | v2,v1,v4 => v3
  | v2,v2,v1 => v3
  | v2,v2,v2 => v3
  | v2,v2,v3 => v3
  | v2,v2,v4 => v3
  | v2,v3,v1 => v3
  | v2,v3,v2 => v3
  | v2,v3,v3 => v3
  | v2,v3,v4 => v3
  | v2,v4,v1 => v3
  | v2,v4,v2 => v3
  | v2,v4,v3 => v3
  | v2,v4,v4 => v3
  | v3,v1,v1 => v3
  | v3,v1,v2 => v3
  | v3,v1,v3 => v3
  | v3,v1,v4 => v3
  | v3,v2,v1 => v3
  | v3,v2,v2 => v3
  | v3,v2,v3 => v3
  | v3,v2,v4 => v3
  | v3,v3,v1 => v3
  | v3,v3,v2 => v3
  | v3,v3,v3 => v3
  | v3,v3,v4 => v3
  | v3,v4,v1 => v3
  | v3,v4,v2 => v3
  | v3,v4,v3 => v3
  | v3,v4,v4 => v3
  | v4,v1,v1 => v3
  | v4,v1,v2 => v3
  | v4,v1,v3 => v3
  | v4,v1,v4 => v3
  | v4,v2,v1 => v3
  | v4,v2,v2 => v3
  | v4,v2,v3 => v3
  | v4,v2,v4 => v3
  | v4,v3,v1 => v3
  | v4,v3,v2 => v3
  | v4,v3,v3 => v3
  | v4,v3,v4 => v3
  | v4,v4,v1 => v3
  | v4,v4,v2 => v3
  | v4,v4,v3 => v3
  | v4,v4,v4 => v3
  end.

Definition sym : val := v2.

Lemma lem_alice_agent : auto_agent alice.
Proof.
  simpl; trivial.
Qed.

Lemma lem_bob_agent : auto_agent bob.
Proof.
  simpl; trivial.
Qed.

Lemma lem_server_agent : auto_agent server.
Proof.
  simpl; trivial.
Qed.

Lemma lem_intruder_agent : auto_agent i.
Proof.
  simpl; trivial.
Qed.

Lemma lem_intruder_knows_nil_old : auto_knows_old nil.
Proof.
  simpl; trivial.
Qed.

Lemma lem_intruder_can_take_first_components_old :
  forall _big_m1 _big_m2:val,
    auto_knows_old (cons _big_m1 _big_m2) -> auto_knows_old _big_m1.
Proof.
  intro _big_m1; case _big_m1; intro _big_m2; case _big_m2; simpl; trivial.
Qed.

Lemma lem_intruder_can_take_second_components_old :
  forall _big_m1 _big_m2:val,
    auto_knows_old (cons _big_m1 _big_m2) -> auto_knows_old _big_m2.
Proof.
  intro _big_m1; case _big_m1; intro _big_m2; case _big_m2; simpl; trivial.
Qed.

Lemma lem_intruder_can_build_pairs_old :
  forall _big_m1 _big_m2:val,
    auto_knows_old _big_m1 -> auto_knows_old _big_m2 -> auto_knows_old (cons _big_m1 _big_m2).
Proof.
  intro _big_m1; case _big_m1; intro _big_m2; case _big_m2; simpl; trivial.
Qed.

Lemma lem_intruder_can_encrypt_old :
  forall _big_k _big_m:val,
    auto_knows_old _big_m -> auto_knows_old _big_k -> auto_knows_old (crypt _big_m _big_k).
Proof.
  intro _big_k; case _big_k; intro _big_m; case _big_m; simpl; trivial.
Qed.

Lemma lem_intruder_can_decrypt_if_has_private_key_old :
  forall _big_k _big_m:val,
    auto_knows_old (crypt _big_m (key pub _big_k))
     -> auto_knows_old (key prv _big_k)
     -> auto_knows_old _big_m.
Proof.
  intro _big_k; case _big_k; intro _big_m; case _big_m; simpl; trivial.
Qed.

Lemma lem_intruder_can_decrypt_if_has_public_key_old :
  forall _big_k _big_m:val,
    auto_knows_old (crypt _big_m (key prv _big_k))
    -> auto_knows_old (key pub _big_k)
    -> auto_knows_old _big_m.
Proof.
  intro _big_k; case _big_k; intro _big_m; case _big_m; simpl; try red; trivial.
Qed.

Lemma lem_intruder_can_decrypt_if_has_symmetric_key_old : forall _big_m X:val, auto_knows_old (crypt _big_m (key sym X)) -> auto_knows_old (key sym X) -> auto_knows_old _big_m.
Proof.
  intro _big_m; case _big_m; intro X; case X; simpl; trivial.
Qed.

Lemma lem_intruder_can_compute_successors_old : forall _big_m:val, auto_knows_old _big_m -> auto_knows_old (s _big_m).
Proof.
  intro _big_m; case _big_m; simpl; trivial.
Qed.

Lemma lem_intruder_can_compute_predecessors_old : forall _big_m:val, auto_knows_old (s _big_m) -> auto_knows_old _big_m.
Proof.
  intro _big_m; case _big_m; simpl; trivial.
Qed.

Lemma lem_alice_sends_message_1_to_server_old : forall _big_a _big_b:val, auto_agent _big_b -> auto_agent _big_a -> auto_knows_old (cons _big_a (cons _big_b (cons (noncea_old _big_a _big_b) nil))).
Proof.
  intro _big_a; case _big_a; intro _big_b; case _big_b; simpl; try red; trivial.
Qed.

Lemma lem_server_answers_A_with_encrypted_packet_old : forall _big_a _big_b _big_na:val, auto_knows_old (cons _big_a (cons _big_b (cons _big_na nil))) -> auto_knows_old (crypt (cons _big_na (cons _big_b (cons (key sym (session_old _big_a _big_b _big_na)) (cons (crypt (cons (key sym (session_old _big_a _big_b _big_na)) (cons _big_a nil)) (key sym (cons _big_b (cons server nil)))) nil)))) (key sym (cons _big_a (cons server nil)))).
Proof.
  intro _big_a; case _big_a; intro _big_b; case _big_b;
  intro _big_na; case _big_na; simpl; try red; trivial.
Qed.

Lemma lem_alice_gets_server_message_and_forwards_submessage_to_bob_old : forall _big_a _big_b _big_kab _big_msg:val, auto_knows_old (crypt (cons (noncea_old _big_a _big_b) (cons _big_b (cons _big_kab (cons _big_msg nil)))) (key sym (cons _big_a (cons server nil)))) -> auto_knows_old _big_msg.
Proof.
  intro _big_a; case _big_a; intro _big_b; case _big_b;
  intro _big_kab; case _big_kab; intro _big_msg; case _big_msg;
  simpl; try red; trivial.
Qed.

Lemma lem_agent_B_gets_forwarded_submessage_and_sends_confirmation_challenge_old : forall _big_a _big_b _big_kab:val, auto_knows_old (crypt (cons _big_kab (cons _big_a nil)) (key sym (cons _big_b (cons server nil)))) -> auto_knows_old (crypt (nonceb_old _big_kab _big_a _big_b) _big_kab).
Proof.
  intro _big_a; case _big_a; intro _big_b; case _big_b;
  intro _big_kab; case _big_kab;
  simpl; try red; trivial.
Qed.

Lemma lem_alice_answers_confirmation_challenge_old : forall _big_a _big_b _big_kab _big_msg _big_nb:val, auto_knows_old (crypt (cons (noncea_old _big_a _big_b) (cons _big_b (cons _big_kab (cons _big_msg nil)))) (key sym (cons _big_a (cons server nil)))) -> auto_knows_old (crypt _big_nb _big_kab) -> auto_knows_old (crypt (s _big_nb) _big_kab).
Proof.
  intro _big_a; case _big_a; intro _big_b; case _big_b;
  intro _big_kab; case _big_kab; intro _big_msg; case _big_msg;
  intro _big_nb; case _big_nb;
  simpl; try red; trivial.
Qed.

Lemma lem_intruder_knows_all_agents_old : forall X:val, auto_agent X -> auto_knows_old X.
Proof.
  intro X; case X; simpl; trivial.
Qed.

Lemma lem_intruder_knows_every_public_key_old : forall X:val, auto_knows_old (key pub X).
Proof.
  intro X; case X; simpl; trivial.
Qed.

Lemma lem_intruder_knows_own_private_key_old : auto_knows_old (key prv i).
Proof.
  simpl; trivial.
Qed.

Lemma lem_define_alice_key_old : forall _big_a _big_b _big_kab _big_msg:val, auto_knows_old (crypt (cons (noncea_old _big_a _big_b) (cons _big_b (cons _big_kab (cons _big_msg nil)))) (key sym (cons _big_a (cons server nil)))) -> auto_alice_key_old _big_a _big_kab.
Proof.
  intro _big_a; case _big_a; intro _big_b; case _big_b;
  intro _big_kab; case _big_kab; intro _big_msg; case _big_msg;
  simpl; try red; trivial.
Qed.

Lemma lem_define_bob_key_old : forall _big_a _big_b _big_kab:val, auto_knows_old (crypt (s (nonceb_old _big_kab _big_a _big_b)) _big_kab) -> auto_bob_key_old _big_b _big_kab.
Proof.
  intro _big_a; case _big_a; intro _big_b; case _big_b;
  intro _big_kab; case _big_kab;
  simpl; try red; trivial.
Qed.

Lemma lem_intruder_remembers : forall _big_m:val, auto_knows_old _big_m -> auto_knows_current _big_m.
Proof.
  intro _big_m; case _big_m; simpl; trivial.
Qed.

Lemma lem_intruder_knows_all_previous_session_keys : forall _big_a _big_b _big_na:val, auto_knows_current (key sym (session_old _big_a _big_b _big_na)).
Proof.
  intro _big_a; case _big_a; intro _big_b; case _big_b;
  intro _big_na; case _big_na; simpl; trivial.
Qed.

Lemma lem_intruder_knows_all_previous_noncea : forall _big_a _big_b:val, auto_knows_current (noncea_old _big_a _big_b).
Proof.
  intro _big_a; case _big_a; intro _big_b; case _big_b; simpl; trivial.
Qed.

Lemma lem_intruder_knows_all_previous_nonceb : forall _big_a _big_b _big_kab:val, auto_knows_current (nonceb_old _big_kab _big_a _big_b).
Proof.
  intro _big_a; case _big_a; intro _big_b; case _big_b;
  intro _big_kab; case _big_kab;
  simpl; try red; trivial.
Qed.

Lemma lem_intruder_knows_nil_current : auto_knows_current nil.
Proof.
  simpl; trivial.
Qed.

Lemma lem_intruder_can_take_first_components_current :
  forall _big_m1 _big_m2:val,
    auto_knows_current (cons _big_m1 _big_m2) -> auto_knows_current _big_m1.
Proof.
  intro _big_m1; case _big_m1; intro _big_m2; case _big_m2; simpl; trivial.
Qed.

Lemma lem_intruder_can_take_second_components_current :
  forall _big_m1 _big_m2:val,
    auto_knows_current (cons _big_m1 _big_m2) -> auto_knows_current _big_m2.
Proof.
  intro _big_m1; case _big_m1; intro _big_m2; case _big_m2; simpl; trivial.
Qed.

Lemma lem_intruder_can_build_pairs_current :
  forall _big_m1 _big_m2:val,
    auto_knows_current _big_m1 -> auto_knows_current _big_m2 -> auto_knows_current (cons _big_m1 _big_m2).
Proof.
  intro _big_m1; case _big_m1; intro _big_m2; case _big_m2; simpl; trivial.
Qed.

Lemma lem_intruder_can_encrypt_current :
  forall _big_k _big_m:val,
    auto_knows_current _big_m -> auto_knows_current _big_k -> auto_knows_current (crypt _big_m _big_k).
Proof.
  intro _big_k; case _big_k; intro _big_m; case _big_m; simpl; trivial.
Qed.

Lemma lem_intruder_can_decrypt_if_has_private_key_current :
  forall _big_k _big_m:val,
    auto_knows_current (crypt _big_m (key pub _big_k))
     -> auto_knows_current (key prv _big_k)
     -> auto_knows_current _big_m.
Proof.
  intro _big_k; case _big_k; intro _big_m; case _big_m; simpl; trivial.
Qed.

Lemma lem_intruder_can_decrypt_if_has_public_key_current :
  forall _big_k _big_m:val,
    auto_knows_current (crypt _big_m (key prv _big_k))
    -> auto_knows_current (key pub _big_k)
    -> auto_knows_current _big_m.
Proof.
  intro _big_k; case _big_k; intro _big_m; case _big_m; simpl; try red; trivial.
Qed.

Lemma lem_intruder_can_decrypt_if_has_symmetric_key_current : forall _big_m X:val, auto_knows_current (crypt _big_m (key sym X)) -> auto_knows_current (key sym X) -> auto_knows_current _big_m.
Proof.
  intro _big_m; case _big_m; intro X; case X; simpl; trivial.
Qed.

Lemma lem_intruder_can_compute_successors_current : forall _big_m:val, auto_knows_current _big_m -> auto_knows_current (s _big_m).
Proof.
  intro _big_m; case _big_m; simpl; trivial.
Qed.

Lemma lem_intruder_can_compute_predecessors_current : forall _big_m:val, auto_knows_current (s _big_m) -> auto_knows_current _big_m.
Proof.
  intro _big_m; case _big_m; simpl; trivial.
Qed.

Lemma lem_alice_sends_message_1_to_server_current : forall _big_a _big_b:val, auto_agent _big_b -> auto_agent _big_a -> auto_knows_current (cons _big_a (cons _big_b (cons (noncea_current _big_a _big_b) nil))).
Proof.
  intro _big_a; case _big_a; intro _big_b; case _big_b; simpl; try red; trivial.
Qed.

Lemma lem_server_answers_A_with_encrypted_packet_current : forall _big_a _big_b _big_na:val, auto_knows_current (cons _big_a (cons _big_b (cons _big_na nil))) -> auto_knows_current (crypt (cons _big_na (cons _big_b (cons (key sym (session_current _big_a _big_b _big_na)) (cons (crypt (cons (key sym (session_current _big_a _big_b _big_na)) (cons _big_a nil)) (key sym (cons _big_b (cons server nil)))) nil)))) (key sym (cons _big_a (cons server nil)))).
Proof.
  intro _big_a; case _big_a; intro _big_b; case _big_b;
  intro _big_na; case _big_na; simpl; try red; trivial.
Qed.

Lemma lem_alice_gets_server_message_and_forwards_submessage_to_bob_current : forall _big_a _big_b _big_kab _big_msg:val, auto_knows_current (crypt (cons (noncea_current _big_a _big_b) (cons _big_b (cons _big_kab (cons _big_msg nil)))) (key sym (cons _big_a (cons server nil)))) -> auto_knows_current _big_msg.
Proof.
  intro _big_a; case _big_a; intro _big_b; case _big_b;
  intro _big_kab; case _big_kab; intro _big_msg; case _big_msg;
  simpl; try red; trivial.
Qed.

Lemma lem_agent_B_gets_forwarded_submessage_and_sends_confirmation_challenge_current : forall _big_a _big_b _big_kab:val, auto_knows_current (crypt (cons _big_kab (cons _big_a nil)) (key sym (cons _big_b (cons server nil)))) -> auto_knows_current (crypt (nonceb_current _big_kab _big_a _big_b) _big_kab).
Proof.
  intro _big_a; case _big_a; intro _big_b; case _big_b;
  intro _big_kab; case _big_kab;
  simpl; try red; trivial.
Qed.

Lemma lem_alice_answers_confirmation_challenge_current : forall _big_a _big_b _big_kab _big_msg _big_nb:val, auto_knows_current (crypt (cons (noncea_current _big_a _big_b) (cons _big_b (cons _big_kab (cons _big_msg nil)))) (key sym (cons _big_a (cons server nil)))) -> auto_knows_current (crypt _big_nb _big_kab) -> auto_knows_current (crypt (s _big_nb) _big_kab).
Proof.
  intro _big_a; case _big_a; intro _big_b; case _big_b;
  intro _big_kab; case _big_kab; intro _big_msg; case _big_msg;
  intro _big_nb; case _big_nb;
  simpl; try red; trivial.
Qed.

Lemma lem_intruder_knows_all_agents_current : forall X:val, auto_agent X -> auto_knows_current X.
Proof.
  intro X; case X; simpl; trivial.
Qed.

Lemma lem_intruder_knows_every_public_key_current : forall X:val, auto_knows_current (key pub X).
Proof.
  intro X; case X; simpl; trivial.
Qed.

Lemma lem_intruder_knows_own_private_key_current : auto_knows_current (key prv i).
Proof.
  simpl; trivial.
Qed.

Lemma lem_define_alice_key_current : forall _big_a _big_b _big_kab _big_msg:val, auto_knows_current (crypt (cons (noncea_current _big_a _big_b) (cons _big_b (cons _big_kab (cons _big_msg nil)))) (key sym (cons _big_a (cons server nil)))) -> auto_alice_key_current _big_a _big_kab.
Proof.
  intro _big_a; case _big_a; intro _big_b; case _big_b;
  intro _big_kab; case _big_kab; intro _big_msg; case _big_msg;
  simpl; try red; trivial.
Qed.

Lemma lem_define_bob_key_current : forall _big_a _big_b _big_kab:val, auto_knows_current (crypt (s (nonceb_current _big_kab _big_a _big_b)) _big_kab) -> auto_bob_key_current _big_b _big_kab.
Proof.
  intro _big_a; case _big_a; intro _big_b; case _big_b;
  intro _big_kab; case _big_kab;
  simpl; try red; trivial.
Qed.

Lemma lem_intruder_knows_session_key_generated_by_server : forall _big_na:val, auto_knows_current (key sym (session_current alice bob _big_na)) -> False.
Proof.
  intro _big_na; case _big_na; simpl; try red; trivial.
Qed.

Lemma lem_intruder_knows_session_key_as_seen_by_alice : forall _big_kab:val, auto_alice_key_current alice _big_kab -> auto_knows_current _big_kab -> False.
Proof.
  intro _big_kab; case _big_kab;
  simpl; trivial.
Qed.
