(* [sigd] Signature definition. *)

Inductive term : Set :=
    s : term -> term
  | nil : term
  | intruder : term
  | old_session : term -> term -> term -> term
  | prv : term
  | current_session : term -> term -> term -> term
  | nonceb : term -> term -> term -> term
  | alice : term
  | server : term
  | cons : term -> term -> term
  | noncea : term -> term
  | bob : term
  | crypt : term -> term -> term
  | key : term -> term -> term
  | pub : term
  | sym : term
.

(* [extd] Extended signature definition. *)

Inductive extterm : Set :=
    ext_s : extterm -> extterm
  | ext_nil : extterm
  | ext___tuple__q18_fun : extterm -> extterm
  | ext___tuple__q34_fun : extterm -> extterm -> extterm
  | ext___tuple__q2_fun : extterm -> extterm
  | ext___tuple__q56_fun : extterm -> extterm -> extterm -> extterm -> extterm -> extterm
  | ext___tuple__q35_fun : extterm -> extterm -> extterm
  | ext_intruder : extterm
  | ext___tuple__q46_fun : extterm -> extterm
  | ext_old_session : extterm -> extterm -> extterm -> extterm
  | ext___tuple__q21_fun : extterm -> extterm -> extterm -> extterm
  | ext___tuple__q59_fun : extterm -> extterm -> extterm -> extterm -> extterm -> extterm
  | ext___tuple____aux_15 : extterm -> extterm -> extterm -> extterm
  | ext___tuple__q40_fun : extterm
  | ext___tuple__q50_fun : extterm -> extterm -> extterm
  | ext_prv : extterm
  | ext___tuple__q49_fun : extterm
  | ext___tuple__q6_fun : extterm -> extterm -> extterm -> extterm
  | ext_current_session : extterm -> extterm -> extterm -> extterm
  | ext___tuple__q58_fun : extterm -> extterm -> extterm -> extterm -> extterm -> extterm
  | ext___tuple__q9_fun : extterm -> extterm -> extterm -> extterm
  | ext___tuple__q28_fun : extterm -> extterm
  | ext___tuple__q11_fun : extterm -> extterm
  | ext_nonceb : extterm -> extterm -> extterm -> extterm
  | ext___tuple__q61_fun : extterm -> extterm
  | ext___tuple__q48_fun : extterm -> extterm
  | ext___tuple__q45_fun : extterm -> extterm -> extterm
  | ext___tuple____aux_2 : extterm -> extterm -> extterm
  | ext_alice : extterm
  | ext___tuple__q55_fun : extterm -> extterm -> extterm -> extterm -> extterm -> extterm
  | ext___tuple__q53_fun : extterm -> extterm
  | ext___tuple__q20_fun : extterm -> extterm -> extterm -> extterm
  | ext___tuple__q51_fun : extterm -> extterm -> extterm
  | ext___tuple__q12_fun : extterm -> extterm -> extterm
  | ext___tuple____aux_48 : extterm -> extterm -> extterm -> extterm
  | ext_server : extterm
  | ext___tuple__q22_fun : extterm -> extterm
  | ext___tuple__q17_fun : extterm -> extterm
  | ext___tuple__q16_fun : extterm -> extterm
  | ext_cons : extterm -> extterm -> extterm
  | ext_noncea : extterm -> extterm
  | ext___tuple__q44_fun : extterm -> extterm
  | ext_bob : extterm
  | ext___tuple__q1_fun : extterm -> extterm -> extterm -> extterm
  | ext___tuple__q62_fun : extterm -> extterm -> extterm -> extterm -> extterm -> extterm
  | ext___tuple__q37_fun : extterm
  | ext___tuple____aux_6 : extterm -> extterm -> extterm
  | ext___tuple__q10_fun : extterm -> extterm -> extterm
  | ext___tuple__q27_fun : extterm -> extterm
  | ext_crypt : extterm -> extterm -> extterm
  | ext___tuple__q36_fun : extterm
  | ext___tuple__q31_fun : extterm
  | ext___tuple__q3_fun : extterm -> extterm -> extterm
  | ext___tuple__q64_fun : extterm -> extterm
  | ext___tuple__q65_fun : extterm -> extterm -> extterm -> extterm -> extterm
  | ext___tuple__q8_fun : extterm -> extterm -> extterm
  | ext___tuple____aux_45 : extterm -> extterm -> extterm -> extterm -> extterm -> extterm
  | ext___star__intruder_knows_session_key_as_seen_by_B : extterm
  | ext_key : extterm -> extterm -> extterm
  | ext___tuple__q38_fun : extterm -> extterm -> extterm
  | ext___tuple____aux_4 : extterm -> extterm -> extterm
  | ext___tuple__q43_fun : extterm
  | ext___tuple__q41_fun : extterm -> extterm -> extterm
  | ext___tuple__q19_fun : extterm -> extterm
  | ext___tuple__q54_fun : extterm -> extterm -> extterm
  | ext___tuple__q32_fun : extterm -> extterm -> extterm
  | ext___tuple__q52_fun : extterm -> extterm -> extterm
  | ext___tuple__q30_fun : extterm -> extterm -> extterm
  | ext___star__intruder_knows_session_key_generated_by_server : extterm
  | ext___tuple__q42_fun : extterm -> extterm
  | ext___tuple____aux_44 : extterm -> extterm -> extterm
  | ext___tuple__q5_fun : extterm -> extterm -> extterm -> extterm -> extterm -> extterm
  | ext___tuple__q63_fun : extterm -> extterm -> extterm -> extterm -> extterm -> extterm
  | ext___tuple__q47_fun : extterm -> extterm
  | ext_pub : extterm
  | ext___star__intruder_knows_session_key_as_seen_by_alice : extterm
  | ext___tuple__q13_fun : extterm -> extterm
  | ext___tuple__q4_fun : extterm -> extterm
  | ext___tuple__q39_fun : extterm
  | ext___tuple__q26_fun : extterm -> extterm -> extterm
  | ext___tuple__q25_fun : extterm -> extterm -> extterm
  | ext_sym : extterm
  | ext___tuple__q60_fun : extterm -> extterm -> extterm -> extterm -> extterm
.

Fixpoint eval_extterm_of_term [t : term] : extterm :=
  Cases t of
    (s x1) => (ext_s (eval_extterm_of_term x1))
  | nil => ext_nil
  | intruder => ext_intruder
  | (old_session x1 x2 x3) => (ext_old_session (eval_extterm_of_term x1) (eval_extterm_of_term x2) (eval_extterm_of_term x3))
  | prv => ext_prv
  | (current_session x1 x2 x3) => (ext_current_session (eval_extterm_of_term x1) (eval_extterm_of_term x2) (eval_extterm_of_term x3))
  | (nonceb x1 x2 x3) => (ext_nonceb (eval_extterm_of_term x1) (eval_extterm_of_term x2) (eval_extterm_of_term x3))
  | alice => ext_alice
  | server => ext_server
  | (cons x1 x2) => (ext_cons (eval_extterm_of_term x1) (eval_extterm_of_term x2))
  | (noncea x1) => (ext_noncea (eval_extterm_of_term x1))
  | bob => ext_bob
  | (crypt x1 x2) => (ext_crypt (eval_extterm_of_term x1) (eval_extterm_of_term x2))
  | (key x1 x2) => (ext_key (eval_extterm_of_term x1) (eval_extterm_of_term x2))
  | pub => ext_pub
  | sym => ext_sym
  end.

(* [modd] Model definition. *)

Require Refine.

Inductive auto___aux_54 : extterm -> Prop :=
    trans___aux_54_1 : (X:extterm)(auto___aux_54 X)
with auto___aux_3 : extterm -> Prop :=
    trans___aux_3_1 : (X:extterm)(auto___aux_3 X)
with auto___aux_37 : extterm -> Prop :=
    trans___aux_37_cons_1 : (X1,X2:extterm)(auto___aux_20 X1) -> (auto___aux_38 X2) -> (auto___aux_37 (ext_cons X1 X2))
with auto_q64 : extterm -> Prop :=
    trans_q64___tuple__q64_fun_1 : (X1:extterm)(auto___aux_26 X1) -> (auto_q64 (ext___tuple__q64_fun X1))
with auto_q41 : extterm -> Prop :=
    trans_q41___tuple__q41_fun_1 : (X1,X2:extterm)(auto___aux_39 X1) -> (auto___aux_42 X2) -> (auto_q41 (ext___tuple__q41_fun X1 X2))
with auto_q19 : extterm -> Prop :=
    trans_q19___tuple__q19_fun_1 : (X1:extterm)(auto___aux_41 X1) -> (auto_q19 (ext___tuple__q19_fun X1))
  | trans_q19___tuple__q19_fun_2 : (X1:extterm)(auto___aux_25 X1) -> (auto_q19 (ext___tuple__q19_fun X1))
with auto_q36 : extterm -> Prop :=
    trans_q36___tuple__q36_fun_1 : (auto_q36 ext___tuple__q36_fun)
with auto_q31 : extterm -> Prop :=
    trans_q31___tuple__q31_fun_1 : (auto_q31 ext___tuple__q31_fun)
with auto___aux_33 : extterm -> Prop :=
    trans___aux_33_cons_1 : (X1,X2:extterm)(auto___aux_34 X1) -> (auto___aux_12 X2) -> (auto___aux_33 (ext_cons X1 X2))
with auto_q54 : extterm -> Prop :=
    trans_q54___tuple__q54_fun_1 : (X1,X2:extterm)(auto___aux_22 X1) -> (auto___aux_31 X2) -> (auto_q54 (ext___tuple__q54_fun X1 X2))
with auto___aux_43 : extterm -> Prop :=
    trans___aux_43_cons_1 : (X1,X2:extterm)(auto___aux_39 X1) -> (auto___aux_30 X2) -> (auto___aux_43 (ext_cons X1 X2))
with auto_q32 : extterm -> Prop :=
    trans_q32___tuple__q32_fun_1 : (X1,X2:extterm)(auto___aux_22 X1) -> (auto___aux_26 X2) -> (auto_q32 (ext___tuple__q32_fun X1 X2))
with auto___aux_53 : extterm -> Prop :=
    trans___aux_53_pub_1 : (auto___aux_53 ext_pub)
with auto_q52 : extterm -> Prop :=
    trans_q52___tuple__q52_fun_1 : (X1,X2:extterm)(auto___aux_22 X1) -> (auto___aux_26 X2) -> (auto_q52 (ext___tuple__q52_fun X1 X2))
with auto_q42 : extterm -> Prop :=
    trans_q42___tuple__q42_fun_1 : (X1:extterm)(auto___aux_42 X1) -> (auto_q42 (ext___tuple__q42_fun X1))
with auto___aux_17 : extterm -> Prop :=
    trans___aux_17_key_1 : (X1,X2:extterm)(auto___aux_24 X1) -> (auto___aux_35 X2) -> (auto___aux_17 (ext_key X1 X2))
with auto___aux_29 : extterm -> Prop :=
    trans___aux_29_key_1 : (X1,X2:extterm)(auto___aux_24 X1) -> (auto___aux_32 X2) -> (auto___aux_29 (ext_key X1 X2))
with auto___aux_49 : extterm -> Prop :=
    trans___aux_49_nonceb_1 : (X1,X2,X3:extterm)(auto___aux_39 X1) -> (auto___aux_31 X2) -> (auto___aux_20 X3) -> (auto___aux_49 (ext_nonceb X1 X2 X3))
  | trans___aux_49_nonceb_2 : (X1,X2,X3:extterm)(auto___aux_22 X1) -> (auto___aux_31 X2) -> (auto___aux_20 X3) -> (auto___aux_49 (ext_nonceb X1 X2 X3))
with auto___aux_6 : extterm -> Prop :=
    trans___aux_6___tuple____aux_6_1 : (X1,X2:extterm)(auto_knows X1) -> (auto___aux_58 X2) -> (auto___aux_6 (ext___tuple____aux_6 X1 X2))
  | trans___aux_6___tuple____aux_6_2 : (X1,X2:extterm)(auto___aux_36 X1) -> (auto___aux_35 X2) -> (auto___aux_6 (ext___tuple____aux_6 X1 X2))
  | trans___aux_6___tuple____aux_6_3 : (X1,X2:extterm)(auto___aux_51 X1) -> (auto___aux_25 X2) -> (auto___aux_47 X2) -> (auto___aux_6 (ext___tuple____aux_6 X1 X2))
  | trans___aux_6___tuple____aux_6_4 : (X1,X2:extterm)(auto___aux_28 X1) -> (auto___aux_32 X2) -> (auto___aux_6 (ext___tuple____aux_6 X1 X2))
  | trans___aux_6___tuple____aux_6_5 : (X1,X2:extterm)(auto___aux_16 X1) -> (auto___aux_35 X2) -> (auto___aux_6 (ext___tuple____aux_6 X1 X2))
  | trans___aux_6___tuple____aux_6_6 : (X1,X2:extterm)(auto___aux_49 X1) -> (auto___aux_25 X2) -> (auto___aux_6 (ext___tuple____aux_6 X1 X2))
  | trans___aux_6___tuple____aux_6_7 : (X1,X2:extterm)(auto___aux_43 X1) -> (auto___aux_32 X2) -> (auto___aux_6 (ext___tuple____aux_6 X1 X2))
with auto_q43 : extterm -> Prop :=
    trans_q43___tuple__q43_fun_1 : (auto_q43 ext___tuple__q43_fun)
with auto_q55 : extterm -> Prop :=
    trans_q55___tuple__q55_fun_1 : (X1,X2,X3,X4,X5:extterm)(auto___aux_24 X1) -> (auto_knows X2) -> (auto_knows X3) -> (auto_knows X4) -> (auto___aux_26 X5) -> (auto_q55 (ext___tuple__q55_fun X1 X2 X3 X4 X5))
with auto_q38 : extterm -> Prop :=
    trans_q38___tuple__q38_fun_1 : (X1,X2:extterm)(auto___aux_39 X1) -> (auto___aux_42 X2) -> (auto_q38 (ext___tuple__q38_fun X1 X2))
with auto___aux_23 : extterm -> Prop :=
    trans___aux_23_cons_1 : (X1,X2:extterm)(auto___aux_26 X1) -> (auto___aux_27 X2) -> (auto___aux_23 (ext_cons X1 X2))
with auto_q3 : extterm -> Prop :=
    trans_q3___tuple__q3_fun_1 : (X1,X2:extterm)(auto_knows X1) -> (auto___aux_54 X2) -> (auto_q3 (ext___tuple__q3_fun X1 X2))
with auto_q8 : extterm -> Prop :=
    trans_q8___tuple__q8_fun_1 : (X1,X2:extterm)(auto_knows X1) -> (auto___aux_58 X2) -> (auto_q8 (ext___tuple__q8_fun X1 X2))
  | trans_q8___tuple__q8_fun_2 : (X1,X2:extterm)(auto___aux_36 X1) -> (auto___aux_35 X2) -> (auto_q8 (ext___tuple__q8_fun X1 X2))
  | trans_q8___tuple__q8_fun_3 : (X1,X2:extterm)(auto___aux_51 X1) -> (auto___aux_25 X2) -> (auto___aux_47 X2) -> (auto_q8 (ext___tuple__q8_fun X1 X2))
  | trans_q8___tuple__q8_fun_4 : (X1,X2:extterm)(auto___aux_28 X1) -> (auto___aux_32 X2) -> (auto_q8 (ext___tuple__q8_fun X1 X2))
  | trans_q8___tuple__q8_fun_5 : (X1,X2:extterm)(auto___aux_16 X1) -> (auto___aux_35 X2) -> (auto_q8 (ext___tuple__q8_fun X1 X2))
  | trans_q8___tuple__q8_fun_6 : (X1,X2:extterm)(auto___aux_49 X1) -> (auto___aux_25 X2) -> (auto_q8 (ext___tuple__q8_fun X1 X2))
  | trans_q8___tuple__q8_fun_7 : (X1,X2:extterm)(auto___aux_43 X1) -> (auto___aux_32 X2) -> (auto_q8 (ext___tuple__q8_fun X1 X2))
with auto_q9 : extterm -> Prop :=
    trans_q9___tuple__q9_fun_1 : (X1,X2,X3:extterm)(auto___aux_39 X1) -> (auto___aux_31 X2) -> (auto___aux_20 X3) -> (auto_q9 (ext___tuple__q9_fun X1 X2 X3))
  | trans_q9___tuple__q9_fun_2 : (X1,X2,X3:extterm)(auto___aux_22 X1) -> (auto___aux_31 X2) -> (auto___aux_20 X3) -> (auto_q9 (ext___tuple__q9_fun X1 X2 X3))
with auto___aux_2 : extterm -> Prop :=
    trans___aux_2___tuple____aux_2_1 : (X1,X2:extterm)(auto___aux_54 X1) -> (auto_knows X2) -> (auto___aux_2 (ext___tuple____aux_2 X1 X2))
with auto_knows : extterm -> Prop :=
    trans_knows_s_1 : (X1:extterm)(auto_knows X1) -> (auto_knows (ext_s X1))
  | trans_knows_nil_1 : (auto_knows ext_nil)
  | trans_knows_intruder_1 : (auto_knows ext_intruder)
  | trans_knows_nonceb_1 : (X1,X2,X3:extterm)(auto___aux_39 X1) -> (auto___aux_31 X2) -> (auto___aux_20 X3) -> (auto_knows (ext_nonceb X1 X2 X3))
  | trans_knows_nonceb_2 : (X1,X2,X3:extterm)(auto___aux_22 X1) -> (auto___aux_31 X2) -> (auto___aux_20 X3) -> (auto_knows (ext_nonceb X1 X2 X3))
  | trans_knows_alice_1 : (auto_knows ext_alice)
  | trans_knows_server_1 : (auto_knows ext_server)
  | trans_knows_cons_1 : (X1,X2:extterm)(auto_knows X1) -> (auto_knows X2) -> (auto_knows (ext_cons X1 X2))
  | trans_knows_noncea_1 : (X1:extterm)(auto___aux_13 X1) -> (auto_knows (ext_noncea X1))
  | trans_knows_bob_1 : (auto_knows ext_bob)
  | trans_knows_crypt_1 : (X1,X2:extterm)(auto___aux_16 X1) -> (auto___aux_17 X2) -> (auto_knows (ext_crypt X1 X2))
  | trans_knows_crypt_2 : (X1,X2:extterm)(auto___aux_43 X1) -> (auto___aux_29 X2) -> (auto_knows (ext_crypt X1 X2))
  | trans_knows_crypt_3 : (X1,X2:extterm)(auto___aux_51 X1) -> (auto___aux_52 X2) -> (auto_knows (ext_crypt X1 X2))
  | trans_knows_crypt_4 : (X1,X2:extterm)(auto___aux_49 X1) -> (auto___aux_50 X2) -> (auto_knows (ext_crypt X1 X2))
  | trans_knows_crypt_5 : (X1,X2:extterm)(auto___aux_28 X1) -> (auto___aux_29 X2) -> (auto_knows (ext_crypt X1 X2))
  | trans_knows_crypt_6 : (X1,X2:extterm)(auto___aux_36 X1) -> (auto___aux_17 X2) -> (auto_knows (ext_crypt X1 X2))
  | trans_knows_crypt_7 : (X1,X2:extterm)(auto_knows X1) -> (auto_knows X2) -> (auto_knows (ext_crypt X1 X2))
  | trans_knows_key_1 : (X1,X2:extterm)(auto___aux_55 X1) -> (auto___aux_56 X2) -> (auto_knows (ext_key X1 X2))
  | trans_knows_key_2 : (X1,X2:extterm)(auto___aux_57 X1) -> (auto___aux_58 X2) -> (auto_knows (ext_key X1 X2))
  | trans_knows_key_3 : (X1,X2:extterm)(auto___aux_53 X1) -> (auto___aux_54 X2) -> (auto_knows (ext_key X1 X2))
with auto___aux_16 : extterm -> Prop :=
    trans___aux_16_cons_1 : (X1,X2:extterm)(auto___aux_18 X1) -> (auto___aux_19 X2) -> (auto___aux_16 (ext_cons X1 X2))
with auto_q26 : extterm -> Prop :=
    trans_q26___tuple__q26_fun_1 : (X1,X2:extterm)(auto___aux_9 X1) -> (auto___aux_11 X2) -> (auto_q26 (ext___tuple__q26_fun X1 X2))
with auto___aux_30 : extterm -> Prop :=
    trans___aux_30_cons_1 : (X1,X2:extterm)(auto___aux_31 X1) -> (auto___aux_27 X2) -> (auto___aux_30 (ext_cons X1 X2))
with auto_q25 : extterm -> Prop :=
    trans_q25___tuple__q25_fun_1 : (X1,X2:extterm)(auto_knows X1) -> (auto_knows X2) -> (auto_q25 (ext___tuple__q25_fun X1 X2))
with auto_q50 : extterm -> Prop :=
    trans_q50___tuple__q50_fun_1 : (X1,X2:extterm)(auto_knows X1) -> (auto_knows X2) -> (auto_q50 (ext___tuple__q50_fun X1 X2))
with auto___aux_8 : extterm -> Prop :=
    trans___aux_8_cons_1 : (X1,X2:extterm)(auto___aux_9 X1) -> (auto___aux_10 X2) -> (auto___aux_8 (ext_cons X1 X2))
with auto___aux_48 : extterm -> Prop :=
    trans___aux_48___tuple____aux_48_1 : (X1,X2,X3:extterm)(auto___aux_31 X1) -> (auto___aux_20 X2) -> (auto___aux_39 X3) -> (auto___aux_48 (ext___tuple____aux_48 X1 X2 X3))
  | trans___aux_48___tuple____aux_48_2 : (X1,X2,X3:extterm)(auto___aux_31 X1) -> (auto___aux_20 X2) -> (auto___aux_22 X3) -> (auto___aux_48 (ext___tuple____aux_48 X1 X2 X3))
with auto___aux_39 : extterm -> Prop :=
    trans___aux_39_key_1 : (X1,X2:extterm)(auto___aux_24 X1) -> (auto___aux_41 X2) -> (auto___aux_39 (ext_key X1 X2))
with auto_q39 : extterm -> Prop :=
    trans_q39___tuple__q39_fun_1 : (auto_q39 ext___tuple__q39_fun)
with auto___aux_56 : extterm -> Prop :=
    trans___aux_56_intruder_1 : (auto___aux_56 ext_intruder)
with auto_q60 : extterm -> Prop :=
    trans_q60___tuple__q60_fun_1 : (X1,X2,X3,X4:extterm)(auto___aux_53 X1) -> (auto_q60 (ext___tuple__q60_fun X1 X2 X3 X4))
with auto_q13 : extterm -> Prop :=
    trans_q13___tuple__q13_fun_1 : (X1:extterm)(auto___aux_56 X1) -> (auto_q13 (ext___tuple__q13_fun X1))
with auto___aux_50 : extterm -> Prop :=
    trans___aux_50_key_1 : (X1,X2:extterm)(auto___aux_24 X1) -> (auto___aux_41 X2) -> (auto___aux_50 (ext_key X1 X2))
  | trans___aux_50_key_2 : (X1,X2:extterm)(auto___aux_24 X1) -> (auto___aux_25 X2) -> (auto___aux_50 (ext_key X1 X2))
with auto_q4 : extterm -> Prop :=
    trans_q4___tuple__q4_fun_1 : (X1:extterm)(auto___aux_56 X1) -> (auto_q4 (ext___tuple__q4_fun X1))
with auto___aux_28 : extterm -> Prop :=
    trans___aux_28_cons_1 : (X1,X2:extterm)(auto___aux_22 X1) -> (auto___aux_30 X2) -> (auto___aux_28 (ext_cons X1 X2))
with auto___aux_40 : extterm -> Prop :=
    trans___aux_40_cons_1 : (X1,X2:extterm)(auto___aux_42 X1) -> (auto___aux_27 X2) -> (auto___aux_40 (ext_cons X1 X2))
with auto___aux_5 : extterm -> Prop :=
    trans___aux_5_old_session_1 : (X1,X2,X3:extterm)(auto___aux_5 (ext_old_session X1 X2 X3))
with auto___aux_24 : extterm -> Prop :=
    trans___aux_24_sym_1 : (auto___aux_24 ext_sym)
with auto___aux_31 : extterm -> Prop :=
    trans___aux_31_s_1 : (X1:extterm)(auto_knows X1) -> (auto___aux_31 (ext_s X1))
  | trans___aux_31_nil_1 : (auto___aux_31 ext_nil)
  | trans___aux_31_intruder_1 : (auto___aux_31 ext_intruder)
  | trans___aux_31_nonceb_1 : (X1,X2,X3:extterm)(auto___aux_39 X1) -> (auto___aux_31 X2) -> (auto___aux_20 X3) -> (auto___aux_31 (ext_nonceb X1 X2 X3))
  | trans___aux_31_nonceb_2 : (X1,X2,X3:extterm)(auto___aux_22 X1) -> (auto___aux_31 X2) -> (auto___aux_20 X3) -> (auto___aux_31 (ext_nonceb X1 X2 X3))
  | trans___aux_31_alice_1 : (auto___aux_31 ext_alice)
  | trans___aux_31_server_1 : (auto___aux_31 ext_server)
  | trans___aux_31_cons_1 : (X1,X2:extterm)(auto_knows X1) -> (auto_knows X2) -> (auto___aux_31 (ext_cons X1 X2))
  | trans___aux_31_noncea_1 : (X1:extterm)(auto___aux_13 X1) -> (auto___aux_31 (ext_noncea X1))
  | trans___aux_31_bob_1 : (auto___aux_31 ext_bob)
  | trans___aux_31_crypt_1 : (X1,X2:extterm)(auto___aux_16 X1) -> (auto___aux_17 X2) -> (auto___aux_31 (ext_crypt X1 X2))
  | trans___aux_31_crypt_2 : (X1,X2:extterm)(auto___aux_43 X1) -> (auto___aux_29 X2) -> (auto___aux_31 (ext_crypt X1 X2))
  | trans___aux_31_crypt_3 : (X1,X2:extterm)(auto___aux_51 X1) -> (auto___aux_52 X2) -> (auto___aux_31 (ext_crypt X1 X2))
  | trans___aux_31_crypt_4 : (X1,X2:extterm)(auto___aux_49 X1) -> (auto___aux_50 X2) -> (auto___aux_31 (ext_crypt X1 X2))
  | trans___aux_31_crypt_5 : (X1,X2:extterm)(auto___aux_28 X1) -> (auto___aux_29 X2) -> (auto___aux_31 (ext_crypt X1 X2))
  | trans___aux_31_crypt_6 : (X1,X2:extterm)(auto___aux_36 X1) -> (auto___aux_17 X2) -> (auto___aux_31 (ext_crypt X1 X2))
  | trans___aux_31_crypt_7 : (X1,X2:extterm)(auto_knows X1) -> (auto_knows X2) -> (auto___aux_31 (ext_crypt X1 X2))
  | trans___aux_31_key_1 : (X1,X2:extterm)(auto___aux_55 X1) -> (auto___aux_56 X2) -> (auto___aux_31 (ext_key X1 X2))
  | trans___aux_31_key_2 : (X1,X2:extterm)(auto___aux_57 X1) -> (auto___aux_58 X2) -> (auto___aux_31 (ext_key X1 X2))
  | trans___aux_31_key_3 : (X1,X2:extterm)(auto___aux_53 X1) -> (auto___aux_54 X2) -> (auto___aux_31 (ext_key X1 X2))
with auto___aux_46 : extterm -> Prop :=
    trans___aux_46_sym_1 : (auto___aux_46 ext_sym)
with auto___aux_21 : extterm -> Prop :=
    trans___aux_21_cons_1 : (X1,X2:extterm)(auto___aux_22 X1) -> (auto___aux_23 X2) -> (auto___aux_21 (ext_cons X1 X2))
with auto___aux_41 : extterm -> Prop :=
    trans___aux_41_old_session_1 : (X1,X2,X3:extterm)(auto_knows X1) -> (auto_knows X2) -> (auto_knows X3) -> (auto___aux_41 (ext_old_session X1 X2 X3))
with auto_q63 : extterm -> Prop :=
    trans_q63___tuple__q63_fun_1 : (X1,X2,X3,X4,X5:extterm)(auto___aux_24 X1) -> (auto_knows X2) -> (auto_knows X3) -> (auto_knows X4) -> (auto___aux_26 X5) -> (auto_q63 (ext___tuple__q63_fun X1 X2 X3 X4 X5))
with auto___aux_45 : extterm -> Prop :=
    trans___aux_45___tuple____aux_45_1 : (X1,X2,X3,X4,X5:extterm)(auto_knows X1) -> (auto_knows X2) -> (auto_knows X3) -> (auto___aux_24 X4) -> (auto___aux_26 X5) -> (auto___aux_45 (ext___tuple____aux_45 X1 X2 X3 X4 X5))
with auto_q47 : extterm -> Prop :=
    trans_q47___tuple__q47_fun_1 : (X1:extterm)(auto___aux_31 X1) -> (auto_q47 (ext___tuple__q47_fun X1))
with auto_q5 : extterm -> Prop :=
    trans_q5___tuple__q5_fun_1 : (X1,X2,X3,X4,X5:extterm)(auto___aux_24 X1) -> (auto_knows X2) -> (auto_knows X3) -> (auto_knows X4) -> (auto___aux_26 X5) -> (auto_q5 (ext___tuple__q5_fun X1 X2 X3 X4 X5))
with auto_q12 : extterm -> Prop :=
    trans_q12___tuple__q12_fun_1 : (X1,X2:extterm)(auto_knows X1) -> (auto___aux_56 X2) -> (auto_q12 (ext___tuple__q12_fun X1 X2))
with auto_q16 : extterm -> Prop :=
    trans_q16___tuple__q16_fun_1 : (X1:extterm)(auto___aux_35 X1) -> (auto_q16 (ext___tuple__q16_fun X1))
with auto_q61 : extterm -> Prop :=
    trans_q61___tuple__q61_fun_1 : (X1:extterm)(auto_knows X1) -> (auto_q61 (ext___tuple__q61_fun X1))
with auto_q44 : extterm -> Prop :=
    trans_q44___tuple__q44_fun_1 : (X1:extterm)(auto___aux_32 X1) -> (auto_q44 (ext___tuple__q44_fun X1))
with auto_q1 : extterm -> Prop :=
    trans_q1___tuple__q1_fun_1 : (X1,X2,X3:extterm)(auto_knows X1) -> (auto_knows X2) -> (auto_knows X3) -> (auto_q1 (ext___tuple__q1_fun X1 X2 X3))
with auto___aux_25 : extterm -> Prop :=
    trans___aux_25_current_session_1 : (X1,X2,X3:extterm)(auto_knows X1) -> (auto_knows X2) -> (auto_knows X3) -> (auto___aux_25 (ext_current_session X1 X2 X3))
with auto___aux_12 : extterm -> Prop :=
    trans___aux_12_nil_1 : (auto___aux_12 ext_nil)
with auto___aux_4 : extterm -> Prop :=
    trans___aux_4___tuple____aux_4_1 : (X1,X2:extterm)(auto___aux_56 X1) -> (auto_knows X2) -> (auto___aux_4 (ext___tuple____aux_4 X1 X2))
with auto___aux_19 : extterm -> Prop :=
    trans___aux_19_cons_1 : (X1,X2:extterm)(auto___aux_20 X1) -> (auto___aux_21 X2) -> (auto___aux_19 (ext_cons X1 X2))
with auto___aux_20 : extterm -> Prop :=
    trans___aux_20_s_1 : (X1:extterm)(auto_knows X1) -> (auto___aux_20 (ext_s X1))
  | trans___aux_20_nil_1 : (auto___aux_20 ext_nil)
  | trans___aux_20_intruder_1 : (auto___aux_20 ext_intruder)
  | trans___aux_20_nonceb_1 : (X1,X2,X3:extterm)(auto___aux_39 X1) -> (auto___aux_31 X2) -> (auto___aux_20 X3) -> (auto___aux_20 (ext_nonceb X1 X2 X3))
  | trans___aux_20_nonceb_2 : (X1,X2,X3:extterm)(auto___aux_22 X1) -> (auto___aux_31 X2) -> (auto___aux_20 X3) -> (auto___aux_20 (ext_nonceb X1 X2 X3))
  | trans___aux_20_alice_1 : (auto___aux_20 ext_alice)
  | trans___aux_20_server_1 : (auto___aux_20 ext_server)
  | trans___aux_20_cons_1 : (X1,X2:extterm)(auto_knows X1) -> (auto_knows X2) -> (auto___aux_20 (ext_cons X1 X2))
  | trans___aux_20_noncea_1 : (X1:extterm)(auto___aux_13 X1) -> (auto___aux_20 (ext_noncea X1))
  | trans___aux_20_bob_1 : (auto___aux_20 ext_bob)
  | trans___aux_20_crypt_1 : (X1,X2:extterm)(auto___aux_16 X1) -> (auto___aux_17 X2) -> (auto___aux_20 (ext_crypt X1 X2))
  | trans___aux_20_crypt_2 : (X1,X2:extterm)(auto___aux_43 X1) -> (auto___aux_29 X2) -> (auto___aux_20 (ext_crypt X1 X2))
  | trans___aux_20_crypt_3 : (X1,X2:extterm)(auto___aux_51 X1) -> (auto___aux_52 X2) -> (auto___aux_20 (ext_crypt X1 X2))
  | trans___aux_20_crypt_4 : (X1,X2:extterm)(auto___aux_49 X1) -> (auto___aux_50 X2) -> (auto___aux_20 (ext_crypt X1 X2))
  | trans___aux_20_crypt_5 : (X1,X2:extterm)(auto___aux_28 X1) -> (auto___aux_29 X2) -> (auto___aux_20 (ext_crypt X1 X2))
  | trans___aux_20_crypt_6 : (X1,X2:extterm)(auto___aux_36 X1) -> (auto___aux_17 X2) -> (auto___aux_20 (ext_crypt X1 X2))
  | trans___aux_20_crypt_7 : (X1,X2:extterm)(auto_knows X1) -> (auto_knows X2) -> (auto___aux_20 (ext_crypt X1 X2))
  | trans___aux_20_key_1 : (X1,X2:extterm)(auto___aux_55 X1) -> (auto___aux_56 X2) -> (auto___aux_20 (ext_key X1 X2))
  | trans___aux_20_key_2 : (X1,X2:extterm)(auto___aux_57 X1) -> (auto___aux_58 X2) -> (auto___aux_20 (ext_key X1 X2))
  | trans___aux_20_key_3 : (X1,X2:extterm)(auto___aux_53 X1) -> (auto___aux_54 X2) -> (auto___aux_20 (ext_key X1 X2))
with auto_alice_key : extterm -> Prop :=
    trans_alice_key_key_1 : (X1,X2:extterm)(auto___aux_46 X1) -> (auto___aux_47 X2) -> (auto_alice_key (ext_key X1 X2))
with auto___aux_35 : extterm -> Prop :=
    trans___aux_35_cons_1 : (X1,X2:extterm)(auto___aux_31 X1) -> (auto___aux_33 X2) -> (auto___aux_35 (ext_cons X1 X2))
with auto_q62 : extterm -> Prop :=
    trans_q62___tuple__q62_fun_1 : (X1,X2,X3,X4,X5:extterm)(auto___aux_24 X1) -> (auto_knows X2) -> (auto_knows X3) -> (auto_knows X4) -> (auto___aux_26 X5) -> (auto_q62 (ext___tuple__q62_fun X1 X2 X3 X4 X5))
with auto_q10 : extterm -> Prop :=
    trans_q10___tuple__q10_fun_1 : (X1,X2:extterm)(auto___aux_39 X1) -> (auto___aux_42 X2) -> (auto_q10 (ext___tuple__q10_fun X1 X2))
  | trans_q10___tuple__q10_fun_2 : (X1,X2:extterm)(auto___aux_22 X1) -> (auto___aux_26 X2) -> (auto_q10 (ext___tuple__q10_fun X1 X2))
with auto_q20 : extterm -> Prop :=
    trans_q20___tuple__q20_fun_1 : (X1,X2,X3:extterm)(auto___aux_39 X1) -> (auto___aux_31 X2) -> (auto___aux_20 X3) -> (auto_q20 (ext___tuple__q20_fun X1 X2 X3))
  | trans_q20___tuple__q20_fun_2 : (X1,X2,X3:extterm)(auto___aux_22 X1) -> (auto___aux_31 X2) -> (auto___aux_20 X3) -> (auto_q20 (ext___tuple__q20_fun X1 X2 X3))
with auto_q51 : extterm -> Prop :=
    trans_q51___tuple__q51_fun_1 : (X1,X2:extterm)(auto___aux_22 X1) -> (auto___aux_26 X2) -> (auto_q51 (ext___tuple__q51_fun X1 X2))
with auto___aux_7 : extterm -> Prop :=
    trans___aux_7_alice_1 : (auto___aux_7 ext_alice)
with auto___aux_14 : extterm -> Prop :=
    trans___aux_14_cons_1 : (X1,X2:extterm)(auto___aux_9 X1) -> (auto___aux_12 X2) -> (auto___aux_14 (ext_cons X1 X2))
with auto___aux_57 : extterm -> Prop :=
    trans___aux_57_sym_1 : (auto___aux_57 ext_sym)
with auto___aux_10 : extterm -> Prop :=
    trans___aux_10_cons_1 : (X1,X2:extterm)(auto___aux_11 X1) -> (auto___aux_12 X2) -> (auto___aux_10 (ext_cons X1 X2))
with auto_q30 : extterm -> Prop :=
    trans_q30___tuple__q30_fun_1 : (X1,X2:extterm)(auto_knows X1) -> (auto_knows X2) -> (auto_q30 (ext___tuple__q30_fun X1 X2))
with auto_q22 : extterm -> Prop :=
    trans_q22___tuple__q22_fun_1 : (X1:extterm)(auto___aux_54 X1) -> (auto_q22 (ext___tuple__q22_fun X1))
with auto_q17 : extterm -> Prop :=
    trans_q17___tuple__q17_fun_1 : (X1:extterm)(auto___aux_58 X1) -> (auto_q17 (ext___tuple__q17_fun X1))
with auto_q37 : extterm -> Prop :=
    trans_q37___tuple__q37_fun_1 : (auto_q37 ext___tuple__q37_fun)
with auto___aux_26 : extterm -> Prop :=
    trans___aux_26_crypt_1 : (X1,X2:extterm)(auto___aux_28 X1) -> (auto___aux_29 X2) -> (auto___aux_26 (ext_crypt X1 X2))
with auto_agent : extterm -> Prop :=
    trans_agent_intruder_1 : (auto_agent ext_intruder)
  | trans_agent_alice_1 : (auto_agent ext_alice)
  | trans_agent_server_1 : (auto_agent ext_server)
  | trans_agent_bob_1 : (auto_agent ext_bob)
with auto___aux_38 : extterm -> Prop :=
    trans___aux_38_cons_1 : (X1,X2:extterm)(auto___aux_39 X1) -> (auto___aux_40 X2) -> (auto___aux_38 (ext_cons X1 X2))
with auto_q48 : extterm -> Prop :=
    trans_q48___tuple__q48_fun_1 : (X1:extterm)(auto___aux_20 X1) -> (auto_q48 (ext___tuple__q48_fun X1))
with auto_q45 : extterm -> Prop :=
    trans_q45___tuple__q45_fun_1 : (X1,X2:extterm)(auto___aux_39 X1) -> (auto___aux_31 X2) -> (auto_q45 (ext___tuple__q45_fun X1 X2))
with auto___aux_27 : extterm -> Prop :=
    trans___aux_27_nil_1 : (auto___aux_27 ext_nil)
with auto_q40 : extterm -> Prop :=
    trans_q40___tuple__q40_fun_1 : (auto_q40 ext___tuple__q40_fun)
with auto_q21 : extterm -> Prop :=
    trans_q21___tuple__q21_fun_1 : (X1,X2,X3:extterm)(auto___aux_39 X1) -> (auto___aux_31 X2) -> (auto___aux_20 X3) -> (auto_q21 (ext___tuple__q21_fun X1 X2 X3))
  | trans_q21___tuple__q21_fun_2 : (X1,X2,X3:extterm)(auto___aux_22 X1) -> (auto___aux_31 X2) -> (auto___aux_20 X3) -> (auto_q21 (ext___tuple__q21_fun X1 X2 X3))
with auto___aux_51 : extterm -> Prop :=
    trans___aux_51_s_1 : (X1:extterm)(auto___aux_49 X1) -> (auto___aux_51 (ext_s X1))
  | trans___aux_51_s_2 : (X1:extterm)(auto___aux_51 X1) -> (auto___aux_51 (ext_s X1))
with auto_q53 : extterm -> Prop :=
    trans_q53___tuple__q53_fun_1 : (X1:extterm)(auto___aux_26 X1) -> (auto_q53 (ext___tuple__q53_fun X1))
with auto___aux_47 : extterm -> Prop :=
    trans___aux_47_current_session_1 : (X1,X2,X3:extterm)(auto_knows X1) -> (auto_knows X2) -> (auto_knows X3) -> (auto___aux_47 (ext_current_session X1 X2 X3))
with auto_q49 : extterm -> Prop :=
    trans_q49___tuple__q49_fun_1 : (auto_q49 ext___tuple__q49_fun)
with auto___aux_22 : extterm -> Prop :=
    trans___aux_22_key_1 : (X1,X2:extterm)(auto___aux_24 X1) -> (auto___aux_25 X2) -> (auto___aux_22 (ext_key X1 X2))
with auto_q58 : extterm -> Prop :=
    trans_q58___tuple__q58_fun_1 : (X1,X2,X3,X4,X5:extterm)(auto___aux_53 X1) -> (auto_knows X2) -> (auto_q58 (ext___tuple__q58_fun X1 X2 X3 X4 X5))
with auto_q46 : extterm -> Prop :=
    trans_q46___tuple__q46_fun_1 : (X1:extterm)(auto___aux_20 X1) -> (auto_q46 (ext___tuple__q46_fun X1))
with auto___aux_13 : extterm -> Prop :=
    trans___aux_13_cons_1 : (X1,X2:extterm)(auto___aux_7 X1) -> (auto___aux_14 X2) -> (auto___aux_13 (ext_cons X1 X2))
with auto_q56 : extterm -> Prop :=
    trans_q56___tuple__q56_fun_1 : (X1,X2,X3,X4,X5:extterm)(auto___aux_53 X1) -> (auto_knows X2) -> (auto_q56 (ext___tuple__q56_fun X1 X2 X3 X4 X5))
with auto_q35 : extterm -> Prop :=
    trans_q35___tuple__q35_fun_1 : (X1,X2:extterm)(auto___aux_39 X1) -> (auto___aux_42 X2) -> (auto_q35 (ext___tuple__q35_fun X1 X2))
with auto___aux_36 : extterm -> Prop :=
    trans___aux_36_cons_1 : (X1,X2:extterm)(auto___aux_18 X1) -> (auto___aux_37 X2) -> (auto___aux_36 (ext_cons X1 X2))
with auto_q2 : extterm -> Prop :=
    trans_q2___tuple__q2_fun_1 : (X1:extterm)(auto___aux_58 X1) -> (auto_q2 (ext___tuple__q2_fun X1))
with auto___aux_42 : extterm -> Prop :=
    trans___aux_42_crypt_1 : (X1,X2:extterm)(auto___aux_43 X1) -> (auto___aux_29 X2) -> (auto___aux_42 (ext_crypt X1 X2))
with auto___aux_52 : extterm -> Prop :=
    trans___aux_52_key_1 : (X1,X2:extterm)(auto___aux_24 X1) -> (auto___aux_46 X1) -> (auto___aux_25 X2) -> (auto___aux_47 X2) -> (auto___aux_52 (ext_key X1 X2))
with auto___aux_55 : extterm -> Prop :=
    trans___aux_55_prv_1 : (auto___aux_55 ext_prv)
with auto_q34 : extterm -> Prop :=
    trans_q34___tuple__q34_fun_1 : (X1,X2:extterm)(auto_knows X1) -> (auto_knows X2) -> (auto_q34 (ext___tuple__q34_fun X1 X2))
with auto_q18 : extterm -> Prop :=
    trans_q18___tuple__q18_fun_1 : (X1:extterm)(auto___aux_25 X1) -> (auto___aux_47 X1) -> (auto_q18 (ext___tuple__q18_fun X1))
with auto_q6 : extterm -> Prop :=
    trans_q6___tuple__q6_fun_1 : (X1,X2,X3:extterm)(auto___aux_22 X1) -> (auto___aux_52 X1) -> (auto___aux_31 X2) -> (auto___aux_20 X3) -> (auto_q6 (ext___tuple__q6_fun X1 X2 X3))
  | trans_q6___tuple__q6_fun_2 : (X1,X2,X3:extterm)(auto_knows X1) -> (auto___aux_39 X1) -> (auto___aux_31 X2) -> (auto___aux_20 X3) -> (auto_q6 (ext___tuple__q6_fun X1 X2 X3))
with auto___aux_18 : extterm -> Prop :=
    trans___aux_18_s_1 : (X1:extterm)(auto_knows X1) -> (auto___aux_18 (ext_s X1))
  | trans___aux_18_nil_1 : (auto___aux_18 ext_nil)
  | trans___aux_18_intruder_1 : (auto___aux_18 ext_intruder)
  | trans___aux_18_nonceb_1 : (X1,X2,X3:extterm)(auto___aux_39 X1) -> (auto___aux_31 X2) -> (auto___aux_20 X3) -> (auto___aux_18 (ext_nonceb X1 X2 X3))
  | trans___aux_18_nonceb_2 : (X1,X2,X3:extterm)(auto___aux_22 X1) -> (auto___aux_31 X2) -> (auto___aux_20 X3) -> (auto___aux_18 (ext_nonceb X1 X2 X3))
  | trans___aux_18_alice_1 : (auto___aux_18 ext_alice)
  | trans___aux_18_server_1 : (auto___aux_18 ext_server)
  | trans___aux_18_cons_1 : (X1,X2:extterm)(auto_knows X1) -> (auto_knows X2) -> (auto___aux_18 (ext_cons X1 X2))
  | trans___aux_18_noncea_1 : (X1:extterm)(auto___aux_13 X1) -> (auto___aux_18 (ext_noncea X1))
  | trans___aux_18_bob_1 : (auto___aux_18 ext_bob)
  | trans___aux_18_crypt_1 : (X1,X2:extterm)(auto___aux_16 X1) -> (auto___aux_17 X2) -> (auto___aux_18 (ext_crypt X1 X2))
  | trans___aux_18_crypt_2 : (X1,X2:extterm)(auto___aux_43 X1) -> (auto___aux_29 X2) -> (auto___aux_18 (ext_crypt X1 X2))
  | trans___aux_18_crypt_3 : (X1,X2:extterm)(auto___aux_51 X1) -> (auto___aux_52 X2) -> (auto___aux_18 (ext_crypt X1 X2))
  | trans___aux_18_crypt_4 : (X1,X2:extterm)(auto___aux_49 X1) -> (auto___aux_50 X2) -> (auto___aux_18 (ext_crypt X1 X2))
  | trans___aux_18_crypt_5 : (X1,X2:extterm)(auto___aux_28 X1) -> (auto___aux_29 X2) -> (auto___aux_18 (ext_crypt X1 X2))
  | trans___aux_18_crypt_6 : (X1,X2:extterm)(auto___aux_36 X1) -> (auto___aux_17 X2) -> (auto___aux_18 (ext_crypt X1 X2))
  | trans___aux_18_crypt_7 : (X1,X2:extterm)(auto_knows X1) -> (auto_knows X2) -> (auto___aux_18 (ext_crypt X1 X2))
  | trans___aux_18_key_1 : (X1,X2:extterm)(auto___aux_55 X1) -> (auto___aux_56 X2) -> (auto___aux_18 (ext_key X1 X2))
  | trans___aux_18_key_2 : (X1,X2:extterm)(auto___aux_57 X1) -> (auto___aux_58 X2) -> (auto___aux_18 (ext_key X1 X2))
  | trans___aux_18_key_3 : (X1,X2:extterm)(auto___aux_53 X1) -> (auto___aux_54 X2) -> (auto___aux_18 (ext_key X1 X2))
with auto___aux_44 : extterm -> Prop :=
    trans___aux_44___tuple____aux_44_1 : (X1,X2:extterm)(auto___aux_39 X1) -> (auto___aux_42 X2) -> (auto___aux_44 (ext___tuple____aux_44 X1 X2))
  | trans___aux_44___tuple____aux_44_2 : (X1,X2:extterm)(auto___aux_22 X1) -> (auto___aux_26 X2) -> (auto___aux_44 (ext___tuple____aux_44 X1 X2))
with auto_q65 : extterm -> Prop :=
    trans_q65___tuple__q65_fun_1 : (X1,X2,X3,X4:extterm)(auto___aux_24 X1) -> (auto_knows X2) -> (auto_knows X3) -> (auto_knows X4) -> (auto_q65 (ext___tuple__q65_fun X1 X2 X3 X4))
with auto___aux_58 : extterm -> Prop :=
    trans___aux_58_old_session_1 : (X1,X2,X3:extterm)(auto___aux_58 (ext_old_session X1 X2 X3))
with auto_q59 : extterm -> Prop :=
    trans_q59___tuple__q59_fun_1 : (X1,X2,X3,X4,X5:extterm)(auto___aux_53 X1) -> (auto_knows X2) -> (auto_q59 (ext___tuple__q59_fun X1 X2 X3 X4 X5))
with auto___aux_32 : extterm -> Prop :=
    trans___aux_32_cons_1 : (X1,X2:extterm)(auto___aux_20 X1) -> (auto___aux_33 X2) -> (auto___aux_32 (ext_cons X1 X2))
with auto_q28 : extterm -> Prop :=
    trans_q28___tuple__q28_fun_1 : (X1:extterm)(auto_knows X1) -> (auto_q28 (ext___tuple__q28_fun X1))
with auto_q27 : extterm -> Prop :=
    trans_q27___tuple__q27_fun_1 : (X1:extterm)(auto___aux_11 X1) -> (auto_q27 (ext___tuple__q27_fun X1))
with auto_q11 : extterm -> Prop :=
    trans_q11___tuple__q11_fun_1 : (X1:extterm)(auto___aux_54 X1) -> (auto_q11 (ext___tuple__q11_fun X1))
with auto___aux_15 : extterm -> Prop :=
    trans___aux_15___tuple____aux_15_1 : (X1,X2,X3:extterm)(auto_knows X1) -> (auto_knows X2) -> (auto_knows X3) -> (auto___aux_15 (ext___tuple____aux_15 X1 X2 X3))
with auto___aux_9 : extterm -> Prop :=
    trans___aux_9_bob_1 : (auto___aux_9 ext_bob)
with auto___aux_34 : extterm -> Prop :=
    trans___aux_34_server_1 : (auto___aux_34 ext_server)
with auto___aux_1 : extterm -> Prop :=
    trans___aux_1_intruder_1 : (auto___aux_1 ext_intruder)
with auto___aux_11 : extterm -> Prop :=
    trans___aux_11_noncea_1 : (X1:extterm)(auto___aux_13 X1) -> (auto___aux_11 (ext_noncea X1))
with auto___query__intruder_knows_session_key_as_seen_by_B : extterm -> Prop :=
with auto___query__intruder_knows_session_key_generated_by_server : extterm -> Prop :=
with auto___query__intruder_knows_session_key_as_seen_by_alice : extterm -> Prop :=
.

(* [defp] Proofs that all definitions hold. *)


Remark rem_1 : (auto___aux_27 ext_nil). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_27_nil_1; Assumption. Defined.

Remark rem_2 : (_big_x1,_big_x2:extterm)(auto___aux_38 _big_x2) -> (auto___aux_20 _big_x1) -> (auto___aux_37 (ext_cons _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_37_cons_1; Assumption. Defined.

Remark rem_3 : (auto___aux_24 ext_sym). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_24_sym_1; Assumption. Defined.

Remark rem_4 : (_big_x1,_big_x2:extterm)(auto___aux_12 _big_x2) -> (auto___aux_34 _big_x1) -> (auto___aux_33 (ext_cons _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_33_cons_1; Assumption. Defined.

Remark rem_5 : (_big_x1,_big_x2:extterm)(auto___aux_29 _big_x2) -> (auto___aux_28 _big_x1) -> (auto___aux_26 (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_26_crypt_1; Assumption. Defined.

Remark rem_6 : (auto___aux_56 ext_intruder). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_56_intruder_1; Assumption. Defined.

Remark rem_7 : (_big_x1,_big_x2:extterm)(auto___aux_33 _big_x2) -> (auto___aux_20 _big_x1) -> (auto___aux_32 (ext_cons _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_32_cons_1; Assumption. Defined.

Remark rem_8 : (_big_x1,_big_x2:extterm)(auto___aux_41 _big_x2) -> (auto___aux_24 _big_x1) -> (auto___aux_39 (ext_key _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_39_key_1; Assumption. Defined.

Remark rem_9 : (_big_x1,_big_x2:extterm)(auto___aux_30 _big_x2) -> (auto___aux_39 _big_x1) -> (auto___aux_43 (ext_cons _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_43_cons_1; Assumption. Defined.

Inductive or_0 : Prop :=
.

Remark rem_10 : (X1,X2:extterm)(auto___aux_47 (ext_cons X1 X2)) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_11 : ((X:extterm)(auto___aux_35 X) -> (auto___aux_47 X) -> False) -> ((X:extterm)(auto___aux_17 X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2:extterm)(auto___aux_31 _big_x1) -> (auto___aux_33 _big_x2) -> (auto___aux_47 (ext_cons _big_x1 _big_x2)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_m__aux_35_m__aux_47 epsilon_m__aux_17_malice_key. Intros _big_x1 _big_x2. Intros H1 H2. Intro H.
  Elim (rem_10 _big_x1 _big_x2 H); Intros.
Defined.

Inductive or_1[H1:Prop] : Prop :=
    or_1_intro_1 : H1 -> (or_1 H1)
.

Remark rem_12 : (X1,X2:extterm)(auto___aux_35 (ext_cons X1 X2)) -> (or_1
    ((auto___aux_31 X1) /\ (auto___aux_33 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_13 : ((X:extterm)(auto___aux_35 X) -> (auto___aux_47 X) -> False) -> ((X:extterm)(auto___aux_17 X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2:extterm)(auto___aux_35 (ext_cons _big_x1 _big_x2)) -> (auto___aux_47 (ext_cons _big_x1 _big_x2)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_m__aux_35_m__aux_47 epsilon_m__aux_17_malice_key. Intros _big_x1 _big_x2. Intro H.
  Elim (rem_12 _big_x1 _big_x2 H); Intros.
  Apply (rem_11 epsilon_m__aux_35_m__aux_47 epsilon_m__aux_17_malice_key _big_x1 _big_x2); Tauto.
Defined.

Remark rem_14 : ((X:extterm)(auto___aux_17 X) -> (auto_alice_key X) -> False) -> (_big_x2:extterm)(auto___aux_35 _big_x2) -> (auto___aux_47 _big_x2) -> False. (* Induct. *)
Proof.
   Intros epsilon_m__aux_17_malice_key. Fix epsilon_m__aux_35_m__aux_47 1.
  Intro X. Case X; First [ Intros X1 X2; Exact (rem_13 epsilon_m__aux_35_m__aux_47 epsilon_m__aux_17_malice_key X1 X2)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_15 : ((X:extterm)(auto___aux_17 X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2:extterm)(auto___aux_46 _big_x1) -> (auto___aux_47 _big_x2) -> (auto___aux_24 _big_x1) -> (auto___aux_35 _big_x2) -> False. (* Split. *)
Proof.
   Intros epsilon_m__aux_17_malice_key. Intros _big_x1 _big_x2.
  Cut (auto___aux_35 _big_x2) -> (auto___aux_47 _big_x2) -> False. Clear  epsilon_m__aux_17_malice_key. Tauto.
  Exact (rem_14 epsilon_m__aux_17_malice_key _big_x2).
Defined.

Remark rem_16 : (X1,X2:extterm)(auto_alice_key (ext_key X1 X2)) -> (or_1
    ((auto___aux_46 X1) /\ (auto___aux_47 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_17 : ((X:extterm)(auto___aux_17 X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2:extterm)(auto___aux_24 _big_x1) -> (auto___aux_35 _big_x2) -> (auto_alice_key (ext_key _big_x1 _big_x2)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_m__aux_17_malice_key. Intros _big_x1 _big_x2. Intros H1 H2. Intro H.
  Elim (rem_16 _big_x1 _big_x2 H); Intros.
  Apply (rem_15 epsilon_m__aux_17_malice_key _big_x1 _big_x2); Tauto.
Defined.

Remark rem_18 : (X1,X2:extterm)(auto___aux_17 (ext_key X1 X2)) -> (or_1
    ((auto___aux_24 X1) /\ (auto___aux_35 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_19 : ((X:extterm)(auto___aux_17 X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2:extterm)(auto___aux_17 (ext_key _big_x1 _big_x2)) -> (auto_alice_key (ext_key _big_x1 _big_x2)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_m__aux_17_malice_key. Intros _big_x1 _big_x2. Intro H.
  Elim (rem_18 _big_x1 _big_x2 H); Intros.
  Apply (rem_17 epsilon_m__aux_17_malice_key _big_x1 _big_x2); Tauto.
Defined.

Remark rem_20 : (_big_x2:extterm)(auto___aux_17 _big_x2) -> (auto_alice_key _big_x2) -> False. (* Induct. *)
Proof.
   Fix epsilon_m__aux_17_malice_key 1.
  Intro X. Case X; First [ Intros X1 X2; Exact (rem_19 epsilon_m__aux_17_malice_key X1 X2)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_21 : (_big_x1,_big_x2:extterm)(auto___aux_16 _big_x1) -> (auto___aux_17 _big_x2) -> (auto_alice_key _big_x2) -> (auto___aux_49 _big_x1) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
   Intros _big_x1 _big_x2. Intros A1 A2 A3.
  Cut False. 2:Apply (rem_20 _big_x2); Assumption.
  Tauto.
Defined.

Remark rem_22 : (_big_x1,_big_x2:extterm)(auto___aux_16 _big_x1) -> (auto___aux_17 _big_x2) -> (auto_alice_key _big_x2) -> (auto___aux_49 _big_x1) \/ (auto___aux_51 _big_x1) \/ False. (* Prove a smaller disjunction. *)
Proof.
   Intros _big_x1 _big_x2. Intros A1 A2 A3.
  Case (rem_21 _big_x1 _big_x2 A1 A2 A3); Tauto.
Defined.

Remark rem_23 : (_big_x1,_big_x2:extterm)(auto___aux_16 _big_x1) -> (auto___aux_17 _big_x2) -> (auto_alice_key _big_x2) -> (auto___aux_51 (ext_s _big_x1)). (* Deduce positive atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros A1 A2 A3.
  Case (rem_22 _big_x1 _big_x2 A1 A2 A3). Clear A1 A2 A3. Intros. Apply trans___aux_51_s_1; Tauto.
  Intro H; Case H; Clear H. Clear A1 A2 A3. Intros. Apply trans___aux_51_s_2; Tauto.
  Clear A1 A2 A3. Tauto.
Defined.

Remark rem_24 : (X1,X2,X3:extterm)(auto___aux_32 (ext_current_session X1 X2 X3)) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_25 : ((X:extterm)(auto___aux_47 X) -> (auto___aux_32 X) -> False) -> ((X:extterm)(auto___aux_29 X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2,_big_x3:extterm)(auto_knows _big_x1) -> (auto_knows _big_x2) -> (auto_knows _big_x3) -> (auto___aux_32 (ext_current_session _big_x1 _big_x2 _big_x3)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_m__aux_47_m__aux_32 epsilon_m__aux_29_malice_key. Intros _big_x1 _big_x2 _big_x3. Intros H1 H2 H3. Intro H.
  Elim (rem_24 _big_x1 _big_x2 _big_x3 H); Intros.
Defined.

Remark rem_26 : (X1,X2,X3:extterm)(auto___aux_47 (ext_current_session X1 X2 X3)) -> (or_1
    ((auto_knows X1) /\ (auto_knows X2) /\ (auto_knows X3))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_27 : ((X:extterm)(auto___aux_47 X) -> (auto___aux_32 X) -> False) -> ((X:extterm)(auto___aux_29 X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_47 (ext_current_session _big_x1 _big_x2 _big_x3)) -> (auto___aux_32 (ext_current_session _big_x1 _big_x2 _big_x3)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_m__aux_47_m__aux_32 epsilon_m__aux_29_malice_key. Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_26 _big_x1 _big_x2 _big_x3 H); Intros.
  Apply (rem_25 epsilon_m__aux_47_m__aux_32 epsilon_m__aux_29_malice_key _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_28 : ((X:extterm)(auto___aux_29 X) -> (auto_alice_key X) -> False) -> (_big_x2:extterm)(auto___aux_47 _big_x2) -> (auto___aux_32 _big_x2) -> False. (* Induct. *)
Proof.
   Intros epsilon_m__aux_29_malice_key. Fix epsilon_m__aux_47_m__aux_32 1.
  Intro X. Case X; First [ Intros X1 X2 X3; Exact (rem_27 epsilon_m__aux_47_m__aux_32 epsilon_m__aux_29_malice_key X1 X2 X3)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_29 : ((X:extterm)(auto___aux_29 X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2:extterm)(auto___aux_46 _big_x1) -> (auto___aux_47 _big_x2) -> (auto___aux_24 _big_x1) -> (auto___aux_32 _big_x2) -> False. (* Split. *)
Proof.
   Intros epsilon_m__aux_29_malice_key. Intros _big_x1 _big_x2.
  Cut (auto___aux_47 _big_x2) -> (auto___aux_32 _big_x2) -> False. Clear  epsilon_m__aux_29_malice_key. Tauto.
  Exact (rem_28 epsilon_m__aux_29_malice_key _big_x2).
Defined.

Remark rem_30 : ((X:extterm)(auto___aux_29 X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2:extterm)(auto___aux_24 _big_x1) -> (auto___aux_32 _big_x2) -> (auto_alice_key (ext_key _big_x1 _big_x2)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_m__aux_29_malice_key. Intros _big_x1 _big_x2. Intros H1 H2. Intro H.
  Elim (rem_16 _big_x1 _big_x2 H); Intros.
  Apply (rem_29 epsilon_m__aux_29_malice_key _big_x1 _big_x2); Tauto.
Defined.

Remark rem_31 : (X1,X2:extterm)(auto___aux_29 (ext_key X1 X2)) -> (or_1
    ((auto___aux_24 X1) /\ (auto___aux_32 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_32 : ((X:extterm)(auto___aux_29 X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2:extterm)(auto___aux_29 (ext_key _big_x1 _big_x2)) -> (auto_alice_key (ext_key _big_x1 _big_x2)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_m__aux_29_malice_key. Intros _big_x1 _big_x2. Intro H.
  Elim (rem_31 _big_x1 _big_x2 H); Intros.
  Apply (rem_30 epsilon_m__aux_29_malice_key _big_x1 _big_x2); Tauto.
Defined.

Remark rem_33 : (_big_x2:extterm)(auto___aux_29 _big_x2) -> (auto_alice_key _big_x2) -> False. (* Induct. *)
Proof.
   Fix epsilon_m__aux_29_malice_key 1.
  Intro X. Case X; First [ Intros X1 X2; Exact (rem_32 epsilon_m__aux_29_malice_key X1 X2)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_34 : (_big_x1,_big_x2:extterm)(auto___aux_43 _big_x1) -> (auto___aux_29 _big_x2) -> (auto_alice_key _big_x2) -> (auto___aux_49 _big_x1) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
   Intros _big_x1 _big_x2. Intros A1 A2 A3.
  Cut False. 2:Apply (rem_33 _big_x2); Assumption.
  Tauto.
Defined.

Remark rem_35 : (_big_x1,_big_x2:extterm)(auto___aux_43 _big_x1) -> (auto___aux_29 _big_x2) -> (auto_alice_key _big_x2) -> (auto___aux_49 _big_x1) \/ (auto___aux_51 _big_x1) \/ False. (* Prove a smaller disjunction. *)
Proof.
   Intros _big_x1 _big_x2. Intros A1 A2 A3.
  Case (rem_34 _big_x1 _big_x2 A1 A2 A3); Tauto.
Defined.

Remark rem_36 : (_big_x1,_big_x2:extterm)(auto___aux_43 _big_x1) -> (auto___aux_29 _big_x2) -> (auto_alice_key _big_x2) -> (auto___aux_51 (ext_s _big_x1)). (* Deduce positive atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros A1 A2 A3.
  Case (rem_35 _big_x1 _big_x2 A1 A2 A3). Clear A1 A2 A3. Intros. Apply trans___aux_51_s_1; Tauto.
  Intro H; Case H; Clear H. Clear A1 A2 A3. Intros. Apply trans___aux_51_s_2; Tauto.
  Clear A1 A2 A3. Tauto.
Defined.

Remark rem_37 : (_big_x1,_big_x2:extterm)(auto___aux_51 _big_x1) -> (auto___aux_52 _big_x2) -> (auto_alice_key _big_x2) -> (auto___aux_51 (ext_s _big_x1)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_51_s_2; Assumption. Defined.

Remark rem_38 : (_big_x1,_big_x2:extterm)(auto___aux_49 _big_x1) -> (auto___aux_50 _big_x2) -> (auto_alice_key _big_x2) -> (auto___aux_51 (ext_s _big_x1)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_51_s_1; Assumption. Defined.

Remark rem_39 : (_big_x2:extterm)(auto___aux_29 _big_x2) -> (auto_alice_key _big_x2) -> False. (* Induct. *)
Proof.
   Fix epsilon_m__aux_29_malice_key 1.
  Intro X. Case X; First [ Intros X1 X2; Exact (rem_32 epsilon_m__aux_29_malice_key X1 X2)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_40 : (_big_x1,_big_x2:extterm)(auto___aux_28 _big_x1) -> (auto___aux_29 _big_x2) -> (auto_alice_key _big_x2) -> (auto___aux_49 _big_x1) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
   Intros _big_x1 _big_x2. Intros A1 A2 A3.
  Cut False. 2:Apply (rem_39 _big_x2); Assumption.
  Tauto.
Defined.

Remark rem_41 : (_big_x1,_big_x2:extterm)(auto___aux_28 _big_x1) -> (auto___aux_29 _big_x2) -> (auto_alice_key _big_x2) -> (auto___aux_49 _big_x1) \/ (auto___aux_51 _big_x1) \/ False. (* Prove a smaller disjunction. *)
Proof.
   Intros _big_x1 _big_x2. Intros A1 A2 A3.
  Case (rem_40 _big_x1 _big_x2 A1 A2 A3); Tauto.
Defined.

Remark rem_42 : (_big_x1,_big_x2:extterm)(auto___aux_28 _big_x1) -> (auto___aux_29 _big_x2) -> (auto_alice_key _big_x2) -> (auto___aux_51 (ext_s _big_x1)). (* Deduce positive atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros A1 A2 A3.
  Case (rem_41 _big_x1 _big_x2 A1 A2 A3). Clear A1 A2 A3. Intros. Apply trans___aux_51_s_1; Tauto.
  Intro H; Case H; Clear H. Clear A1 A2 A3. Intros. Apply trans___aux_51_s_2; Tauto.
  Clear A1 A2 A3. Tauto.
Defined.

Remark rem_43 : (_big_x2:extterm)(auto___aux_17 _big_x2) -> (auto_alice_key _big_x2) -> False. (* Induct. *)
Proof.
   Fix epsilon_m__aux_17_malice_key 1.
  Intro X. Case X; First [ Intros X1 X2; Exact (rem_19 epsilon_m__aux_17_malice_key X1 X2)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_44 : (_big_x1,_big_x2:extterm)(auto___aux_36 _big_x1) -> (auto___aux_17 _big_x2) -> (auto_alice_key _big_x2) -> (auto___aux_49 _big_x1) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
   Intros _big_x1 _big_x2. Intros A1 A2 A3.
  Cut False. 2:Apply (rem_43 _big_x2); Assumption.
  Tauto.
Defined.

Remark rem_45 : (_big_x1,_big_x2:extterm)(auto___aux_36 _big_x1) -> (auto___aux_17 _big_x2) -> (auto_alice_key _big_x2) -> (auto___aux_49 _big_x1) \/ (auto___aux_51 _big_x1) \/ False. (* Prove a smaller disjunction. *)
Proof.
   Intros _big_x1 _big_x2. Intros A1 A2 A3.
  Case (rem_44 _big_x1 _big_x2 A1 A2 A3); Tauto.
Defined.

Remark rem_46 : (_big_x1,_big_x2:extterm)(auto___aux_36 _big_x1) -> (auto___aux_17 _big_x2) -> (auto_alice_key _big_x2) -> (auto___aux_51 (ext_s _big_x1)). (* Deduce positive atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros A1 A2 A3.
  Case (rem_45 _big_x1 _big_x2 A1 A2 A3). Clear A1 A2 A3. Intros. Apply trans___aux_51_s_1; Tauto.
  Intro H; Case H; Clear H. Clear A1 A2 A3. Intros. Apply trans___aux_51_s_2; Tauto.
  Clear A1 A2 A3. Tauto.
Defined.

Remark rem_47 : (X1:extterm)(auto_alice_key (ext_s X1)) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_48 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x1:extterm)(auto_knows _big_x1) -> (auto_alice_key (ext_s _big_x1)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intros _big_x1. Intros H1. Intro H.
  Elim (rem_47 _big_x1 H); Intros.
Defined.

Remark rem_49 : (X1:extterm)(auto_knows (ext_s X1)) -> (or_1
    (auto_knows X1)).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_50 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x1:extterm)(auto_knows (ext_s _big_x1)) -> (auto_alice_key (ext_s _big_x1)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intros _big_x1. Intro H.
  Elim (rem_49 _big_x1 H); Intros.
  Apply (rem_48 epsilon_mknows_malice_key _big_x1); Tauto.
Defined.

Remark rem_51 : (auto_alice_key ext_nil) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_52 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (auto_alice_key ext_nil) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intro H.
  Elim (rem_51 H); Intros.
Defined.

Remark rem_53 : (auto_knows ext_nil) -> (or_1
    True).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_54 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (auto_knows ext_nil) -> (auto_alice_key ext_nil) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intro H.
  Elim (rem_53 H); Intros.
  Apply (rem_52 epsilon_mknows_malice_key); Tauto.
Defined.

Remark rem_55 : (auto_alice_key ext_intruder) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_56 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (auto_alice_key ext_intruder) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intro H.
  Elim (rem_55 H); Intros.
Defined.

Remark rem_57 : (auto_knows ext_intruder) -> (or_1
    True).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_58 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (auto_knows ext_intruder) -> (auto_alice_key ext_intruder) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intro H.
  Elim (rem_57 H); Intros.
  Apply (rem_56 epsilon_mknows_malice_key); Tauto.
Defined.

Remark rem_59 : (X1,X2,X3:extterm)(auto_alice_key (ext_nonceb X1 X2 X3)) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_60 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_39 _big_x1) -> (auto___aux_31 _big_x2) -> (auto___aux_20 _big_x3) -> (auto_alice_key (ext_nonceb _big_x1 _big_x2 _big_x3)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intros _big_x1 _big_x2 _big_x3. Intros H1 H2 H3. Intro H.
  Elim (rem_59 _big_x1 _big_x2 _big_x3 H); Intros.
Defined.

Remark rem_61 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_22 _big_x1) -> (auto___aux_31 _big_x2) -> (auto___aux_20 _big_x3) -> (auto_alice_key (ext_nonceb _big_x1 _big_x2 _big_x3)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intros _big_x1 _big_x2 _big_x3. Intros H1 H2 H3. Intro H.
  Elim (rem_59 _big_x1 _big_x2 _big_x3 H); Intros.
Defined.

Inductive or_2[H1,H2:Prop] : Prop :=
    or_2_intro_1 : H1 -> (or_2 H1 H2)
  | or_2_intro_2 : H2 -> (or_2 H1 H2)
.

Remark rem_62 : (X1,X2,X3:extterm)(auto_knows (ext_nonceb X1 X2 X3)) -> (or_2
    ((auto___aux_39 X1) /\ (auto___aux_31 X2) /\ (auto___aux_20 X3))
    ((auto___aux_22 X1) /\ (auto___aux_31 X2) /\ (auto___aux_20 X3))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_2_intro_1; Tauto.
  Intros. Apply or_2_intro_2; Tauto.
Qed.

Remark rem_63 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2,_big_x3:extterm)(auto_knows (ext_nonceb _big_x1 _big_x2 _big_x3)) -> (auto_alice_key (ext_nonceb _big_x1 _big_x2 _big_x3)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_62 _big_x1 _big_x2 _big_x3 H); Intros.
  Apply (rem_60 epsilon_mknows_malice_key _big_x1 _big_x2 _big_x3); Tauto.
  Apply (rem_61 epsilon_mknows_malice_key _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_64 : (auto_alice_key ext_alice) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_65 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (auto_alice_key ext_alice) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intro H.
  Elim (rem_64 H); Intros.
Defined.

Remark rem_66 : (auto_knows ext_alice) -> (or_1
    True).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_67 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (auto_knows ext_alice) -> (auto_alice_key ext_alice) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intro H.
  Elim (rem_66 H); Intros.
  Apply (rem_65 epsilon_mknows_malice_key); Tauto.
Defined.

Remark rem_68 : (auto_alice_key ext_server) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_69 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (auto_alice_key ext_server) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intro H.
  Elim (rem_68 H); Intros.
Defined.

Remark rem_70 : (auto_knows ext_server) -> (or_1
    True).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_71 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (auto_knows ext_server) -> (auto_alice_key ext_server) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intro H.
  Elim (rem_70 H); Intros.
  Apply (rem_69 epsilon_mknows_malice_key); Tauto.
Defined.

Remark rem_72 : (X1,X2:extterm)(auto_alice_key (ext_cons X1 X2)) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_73 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2:extterm)(auto_knows _big_x1) -> (auto_knows _big_x2) -> (auto_alice_key (ext_cons _big_x1 _big_x2)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intros _big_x1 _big_x2. Intros H1 H2. Intro H.
  Elim (rem_72 _big_x1 _big_x2 H); Intros.
Defined.

Remark rem_74 : (X1,X2:extterm)(auto_knows (ext_cons X1 X2)) -> (or_1
    ((auto_knows X1) /\ (auto_knows X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_75 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2:extterm)(auto_knows (ext_cons _big_x1 _big_x2)) -> (auto_alice_key (ext_cons _big_x1 _big_x2)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intros _big_x1 _big_x2. Intro H.
  Elim (rem_74 _big_x1 _big_x2 H); Intros.
  Apply (rem_73 epsilon_mknows_malice_key _big_x1 _big_x2); Tauto.
Defined.

Remark rem_76 : (X1:extterm)(auto_alice_key (ext_noncea X1)) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_77 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x1:extterm)(auto___aux_13 _big_x1) -> (auto_alice_key (ext_noncea _big_x1)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intros _big_x1. Intros H1. Intro H.
  Elim (rem_76 _big_x1 H); Intros.
Defined.

Remark rem_78 : (X1:extterm)(auto_knows (ext_noncea X1)) -> (or_1
    (auto___aux_13 X1)).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_79 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x1:extterm)(auto_knows (ext_noncea _big_x1)) -> (auto_alice_key (ext_noncea _big_x1)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intros _big_x1. Intro H.
  Elim (rem_78 _big_x1 H); Intros.
  Apply (rem_77 epsilon_mknows_malice_key _big_x1); Tauto.
Defined.

Remark rem_80 : (auto_alice_key ext_bob) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_81 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (auto_alice_key ext_bob) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intro H.
  Elim (rem_80 H); Intros.
Defined.

Remark rem_82 : (auto_knows ext_bob) -> (or_1
    True).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_83 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (auto_knows ext_bob) -> (auto_alice_key ext_bob) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intro H.
  Elim (rem_82 H); Intros.
  Apply (rem_81 epsilon_mknows_malice_key); Tauto.
Defined.

Remark rem_84 : (X1,X2:extterm)(auto_alice_key (ext_crypt X1 X2)) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_85 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2:extterm)(auto___aux_16 _big_x1) -> (auto___aux_17 _big_x2) -> (auto_alice_key (ext_crypt _big_x1 _big_x2)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intros _big_x1 _big_x2. Intros H1 H2. Intro H.
  Elim (rem_84 _big_x1 _big_x2 H); Intros.
Defined.

Remark rem_86 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2:extterm)(auto___aux_43 _big_x1) -> (auto___aux_29 _big_x2) -> (auto_alice_key (ext_crypt _big_x1 _big_x2)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intros _big_x1 _big_x2. Intros H1 H2. Intro H.
  Elim (rem_84 _big_x1 _big_x2 H); Intros.
Defined.

Remark rem_87 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2:extterm)(auto___aux_51 _big_x1) -> (auto___aux_52 _big_x2) -> (auto_alice_key (ext_crypt _big_x1 _big_x2)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intros _big_x1 _big_x2. Intros H1 H2. Intro H.
  Elim (rem_84 _big_x1 _big_x2 H); Intros.
Defined.

Remark rem_88 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2:extterm)(auto___aux_49 _big_x1) -> (auto___aux_50 _big_x2) -> (auto_alice_key (ext_crypt _big_x1 _big_x2)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intros _big_x1 _big_x2. Intros H1 H2. Intro H.
  Elim (rem_84 _big_x1 _big_x2 H); Intros.
Defined.

Remark rem_89 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2:extterm)(auto___aux_28 _big_x1) -> (auto___aux_29 _big_x2) -> (auto_alice_key (ext_crypt _big_x1 _big_x2)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intros _big_x1 _big_x2. Intros H1 H2. Intro H.
  Elim (rem_84 _big_x1 _big_x2 H); Intros.
Defined.

Remark rem_90 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2:extterm)(auto___aux_36 _big_x1) -> (auto___aux_17 _big_x2) -> (auto_alice_key (ext_crypt _big_x1 _big_x2)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intros _big_x1 _big_x2. Intros H1 H2. Intro H.
  Elim (rem_84 _big_x1 _big_x2 H); Intros.
Defined.

Remark rem_91 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2:extterm)(auto_knows _big_x1) -> (auto_knows _big_x2) -> (auto_alice_key (ext_crypt _big_x1 _big_x2)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intros _big_x1 _big_x2. Intros H1 H2. Intro H.
  Elim (rem_84 _big_x1 _big_x2 H); Intros.
Defined.

Inductive or_7[H1,H2,H3,H4,H5,H6,H7:Prop] : Prop :=
    or_7_intro_1 : H1 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_2 : H2 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_3 : H3 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_4 : H4 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_5 : H5 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_6 : H6 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_7 : H7 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
.

Remark rem_92 : (X1,X2:extterm)(auto_knows (ext_crypt X1 X2)) -> (or_7
    ((auto___aux_16 X1) /\ (auto___aux_17 X2))
    ((auto___aux_43 X1) /\ (auto___aux_29 X2))
    ((auto___aux_51 X1) /\ (auto___aux_52 X2))
    ((auto___aux_49 X1) /\ (auto___aux_50 X2))
    ((auto___aux_28 X1) /\ (auto___aux_29 X2))
    ((auto___aux_36 X1) /\ (auto___aux_17 X2))
    ((auto_knows X1) /\ (auto_knows X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_7_intro_1; Tauto.
  Intros. Apply or_7_intro_2; Tauto.
  Intros. Apply or_7_intro_3; Tauto.
  Intros. Apply or_7_intro_4; Tauto.
  Intros. Apply or_7_intro_5; Tauto.
  Intros. Apply or_7_intro_6; Tauto.
  Intros. Apply or_7_intro_7; Tauto.
Qed.

Remark rem_93 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2:extterm)(auto_knows (ext_crypt _big_x1 _big_x2)) -> (auto_alice_key (ext_crypt _big_x1 _big_x2)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intros _big_x1 _big_x2. Intro H.
  Elim (rem_92 _big_x1 _big_x2 H); Intros.
  Apply (rem_85 epsilon_mknows_malice_key _big_x1 _big_x2); Tauto.
  Apply (rem_86 epsilon_mknows_malice_key _big_x1 _big_x2); Tauto.
  Apply (rem_87 epsilon_mknows_malice_key _big_x1 _big_x2); Tauto.
  Apply (rem_88 epsilon_mknows_malice_key _big_x1 _big_x2); Tauto.
  Apply (rem_89 epsilon_mknows_malice_key _big_x1 _big_x2); Tauto.
  Apply (rem_90 epsilon_mknows_malice_key _big_x1 _big_x2); Tauto.
  Apply (rem_91 epsilon_mknows_malice_key _big_x1 _big_x2); Tauto.
Defined.

Remark rem_94 : (auto___aux_47 ext_intruder) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_95 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> ((X:extterm)(auto___aux_56 X) -> (auto___aux_47 X) -> False) -> (auto___aux_47 ext_intruder) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key epsilon_m__aux_56_m__aux_47. Intro H.
  Elim (rem_94 H); Intros.
Defined.

Remark rem_96 : (auto___aux_56 ext_intruder) -> (or_1
    True).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_97 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> ((X:extterm)(auto___aux_56 X) -> (auto___aux_47 X) -> False) -> (auto___aux_56 ext_intruder) -> (auto___aux_47 ext_intruder) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key epsilon_m__aux_56_m__aux_47. Intro H.
  Elim (rem_96 H); Intros.
  Apply (rem_95 epsilon_mknows_malice_key epsilon_m__aux_56_m__aux_47); Tauto.
Defined.

Remark rem_98 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x2:extterm)(auto___aux_56 _big_x2) -> (auto___aux_47 _big_x2) -> False. (* Induct. *)
Proof.
   Intros epsilon_mknows_malice_key. Fix epsilon_m__aux_56_m__aux_47 1.
  Intro X. Case X; First [Exact (rem_97 epsilon_mknows_malice_key epsilon_m__aux_56_m__aux_47 )
  |  Intros until 1; Inversion H].
Defined.

Remark rem_99 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2:extterm)(auto___aux_46 _big_x1) -> (auto___aux_47 _big_x2) -> (auto___aux_55 _big_x1) -> (auto___aux_56 _big_x2) -> False. (* Split. *)
Proof.
   Intros epsilon_mknows_malice_key. Intros _big_x1 _big_x2.
  Cut (auto___aux_56 _big_x2) -> (auto___aux_47 _big_x2) -> False. Clear  epsilon_mknows_malice_key. Tauto.
  Exact (rem_98 epsilon_mknows_malice_key _big_x2).
Defined.

Remark rem_100 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2:extterm)(auto___aux_55 _big_x1) -> (auto___aux_56 _big_x2) -> (auto_alice_key (ext_key _big_x1 _big_x2)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intros _big_x1 _big_x2. Intros H1 H2. Intro H.
  Elim (rem_16 _big_x1 _big_x2 H); Intros.
  Apply (rem_99 epsilon_mknows_malice_key _big_x1 _big_x2); Tauto.
Defined.

Remark rem_101 : (X1,X2,X3:extterm)(auto___aux_58 (ext_current_session X1 X2 X3)) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_102 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> ((X:extterm)(auto___aux_47 X) -> (auto___aux_58 X) -> False) -> (_big_x1,_big_x2,_big_x3:extterm)(auto_knows _big_x1) -> (auto_knows _big_x2) -> (auto_knows _big_x3) -> (auto___aux_58 (ext_current_session _big_x1 _big_x2 _big_x3)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key epsilon_m__aux_47_m__aux_58. Intros _big_x1 _big_x2 _big_x3. Intros H1 H2 H3. Intro H.
  Elim (rem_101 _big_x1 _big_x2 _big_x3 H); Intros.
Defined.

Remark rem_103 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> ((X:extterm)(auto___aux_47 X) -> (auto___aux_58 X) -> False) -> (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_47 (ext_current_session _big_x1 _big_x2 _big_x3)) -> (auto___aux_58 (ext_current_session _big_x1 _big_x2 _big_x3)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key epsilon_m__aux_47_m__aux_58. Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_26 _big_x1 _big_x2 _big_x3 H); Intros.
  Apply (rem_102 epsilon_mknows_malice_key epsilon_m__aux_47_m__aux_58 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_104 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x2:extterm)(auto___aux_47 _big_x2) -> (auto___aux_58 _big_x2) -> False. (* Induct. *)
Proof.
   Intros epsilon_mknows_malice_key. Fix epsilon_m__aux_47_m__aux_58 1.
  Intro X. Case X; First [ Intros X1 X2 X3; Exact (rem_103 epsilon_mknows_malice_key epsilon_m__aux_47_m__aux_58 X1 X2 X3)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_105 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2:extterm)(auto___aux_46 _big_x1) -> (auto___aux_47 _big_x2) -> (auto___aux_57 _big_x1) -> (auto___aux_58 _big_x2) -> False. (* Split. *)
Proof.
   Intros epsilon_mknows_malice_key. Intros _big_x1 _big_x2.
  Cut (auto___aux_47 _big_x2) -> (auto___aux_58 _big_x2) -> False. Clear  epsilon_mknows_malice_key. Tauto.
  Exact (rem_104 epsilon_mknows_malice_key _big_x2).
Defined.

Remark rem_106 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2:extterm)(auto___aux_57 _big_x1) -> (auto___aux_58 _big_x2) -> (auto_alice_key (ext_key _big_x1 _big_x2)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intros _big_x1 _big_x2. Intros H1 H2. Intro H.
  Elim (rem_16 _big_x1 _big_x2 H); Intros.
  Apply (rem_105 epsilon_mknows_malice_key _big_x1 _big_x2); Tauto.
Defined.

Remark rem_107 : (auto___aux_46 ext_pub) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_108 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> ((X:extterm)(auto___aux_53 X) -> (auto___aux_46 X) -> False) -> (auto___aux_46 ext_pub) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key epsilon_m__aux_53_m__aux_46. Intro H.
  Elim (rem_107 H); Intros.
Defined.

Remark rem_109 : (auto___aux_53 ext_pub) -> (or_1
    True).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_110 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> ((X:extterm)(auto___aux_53 X) -> (auto___aux_46 X) -> False) -> (auto___aux_53 ext_pub) -> (auto___aux_46 ext_pub) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key epsilon_m__aux_53_m__aux_46. Intro H.
  Elim (rem_109 H); Intros.
  Apply (rem_108 epsilon_mknows_malice_key epsilon_m__aux_53_m__aux_46); Tauto.
Defined.

Remark rem_111 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x1:extterm)(auto___aux_53 _big_x1) -> (auto___aux_46 _big_x1) -> False. (* Induct. *)
Proof.
   Intros epsilon_mknows_malice_key. Fix epsilon_m__aux_53_m__aux_46 1.
  Intro X. Case X; First [Exact (rem_110 epsilon_mknows_malice_key epsilon_m__aux_53_m__aux_46 )
  |  Intros until 1; Inversion H].
Defined.

Remark rem_112 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2:extterm)(auto___aux_46 _big_x1) -> (auto___aux_47 _big_x2) -> (auto___aux_53 _big_x1) -> False. (* Split. *)
Proof.
   Intros epsilon_mknows_malice_key. Intros _big_x1 _big_x2.
  Cut (auto___aux_53 _big_x1) -> (auto___aux_46 _big_x1) -> False. Clear  epsilon_mknows_malice_key. Tauto.
  Exact (rem_111 epsilon_mknows_malice_key _big_x1).
Defined.

Remark rem_113 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2:extterm)(auto___aux_53 _big_x1) -> (auto_alice_key (ext_key _big_x1 _big_x2)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intros _big_x1 _big_x2. Intros H1. Intro H.
  Elim (rem_16 _big_x1 _big_x2 H); Intros.
  Apply (rem_112 epsilon_mknows_malice_key _big_x1 _big_x2); Tauto.
Defined.

Remark rem_114 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2:extterm)(auto___aux_53 _big_x1) -> (auto___aux_54 _big_x2) -> (auto_alice_key (ext_key _big_x1 _big_x2)) -> False. (* Eliminate negative atom by universal clause. *)
Proof.
   Intros epsilon_mknows_malice_key. Intros _big_x1 _big_x2. Intros. Apply (rem_113 epsilon_mknows_malice_key _big_x1 _big_x2); Assumption.
Defined.

Inductive or_3[H1,H2,H3:Prop] : Prop :=
    or_3_intro_1 : H1 -> (or_3 H1 H2 H3)
  | or_3_intro_2 : H2 -> (or_3 H1 H2 H3)
  | or_3_intro_3 : H3 -> (or_3 H1 H2 H3)
.

Remark rem_115 : (X1,X2:extterm)(auto_knows (ext_key X1 X2)) -> (or_3
    ((auto___aux_55 X1) /\ (auto___aux_56 X2))
    ((auto___aux_57 X1) /\ (auto___aux_58 X2))
    ((auto___aux_53 X1) /\ (auto___aux_54 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_3_intro_1; Tauto.
  Intros. Apply or_3_intro_2; Tauto.
  Intros. Apply or_3_intro_3; Tauto.
Qed.

Remark rem_116 : ((X:extterm)(auto_knows X) -> (auto_alice_key X) -> False) -> (_big_x1,_big_x2:extterm)(auto_knows (ext_key _big_x1 _big_x2)) -> (auto_alice_key (ext_key _big_x1 _big_x2)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_malice_key. Intros _big_x1 _big_x2. Intro H.
  Elim (rem_115 _big_x1 _big_x2 H); Intros.
  Apply (rem_100 epsilon_mknows_malice_key _big_x1 _big_x2); Tauto.
  Apply (rem_106 epsilon_mknows_malice_key _big_x1 _big_x2); Tauto.
  Apply (rem_114 epsilon_mknows_malice_key _big_x1 _big_x2); Tauto.
Defined.

Remark rem_117 : (_big_x2:extterm)(auto_knows _big_x2) -> (auto_alice_key _big_x2) -> False. (* Induct. *)
Proof.
   Fix epsilon_mknows_malice_key 1.
  Intro X. Case X; First [ Intros X1; Exact (rem_50 epsilon_mknows_malice_key X1)
  | Exact (rem_54 epsilon_mknows_malice_key )
  | Exact (rem_58 epsilon_mknows_malice_key )
  |  Intros X1 X2 X3; Exact (rem_63 epsilon_mknows_malice_key X1 X2 X3)
  | Exact (rem_67 epsilon_mknows_malice_key )
  | Exact (rem_71 epsilon_mknows_malice_key )
  |  Intros X1 X2; Exact (rem_75 epsilon_mknows_malice_key X1 X2)
  |  Intros X1; Exact (rem_79 epsilon_mknows_malice_key X1)
  | Exact (rem_83 epsilon_mknows_malice_key )
  |  Intros X1 X2; Exact (rem_93 epsilon_mknows_malice_key X1 X2)
  |  Intros X1 X2; Exact (rem_116 epsilon_mknows_malice_key X1 X2)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_118 : (_big_x1,_big_x2:extterm)(auto_knows _big_x1) -> (auto_knows _big_x2) -> (auto_alice_key _big_x2) -> (auto___aux_49 _big_x1) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
   Intros _big_x1 _big_x2. Intros A1 A2 A3.
  Cut False. 2:Apply (rem_117 _big_x2); Assumption.
  Tauto.
Defined.

Remark rem_119 : (_big_x1,_big_x2:extterm)(auto_knows _big_x1) -> (auto_knows _big_x2) -> (auto_alice_key _big_x2) -> (auto___aux_49 _big_x1) \/ (auto___aux_51 _big_x1) \/ False. (* Prove a smaller disjunction. *)
Proof.
   Intros _big_x1 _big_x2. Intros A1 A2 A3.
  Case (rem_118 _big_x1 _big_x2 A1 A2 A3); Tauto.
Defined.

Remark rem_120 : (_big_x1,_big_x2:extterm)(auto_knows _big_x1) -> (auto_knows _big_x2) -> (auto_alice_key _big_x2) -> (auto___aux_51 (ext_s _big_x1)). (* Deduce positive atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros A1 A2 A3.
  Case (rem_119 _big_x1 _big_x2 A1 A2 A3). Clear A1 A2 A3. Intros. Apply trans___aux_51_s_1; Tauto.
  Intro H; Case H; Clear H. Clear A1 A2 A3. Intros. Apply trans___aux_51_s_2; Tauto.
  Clear A1 A2 A3. Tauto.
Defined.

Remark rem_121 : (_big_x1,_big_x2:extterm)(auto_knows (ext_crypt _big_x1 _big_x2)) -> (auto_alice_key _big_x2) -> (auto___aux_51 (ext_s _big_x1)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_92 _big_x1 _big_x2 H); Intros.
  Apply (rem_23 _big_x1 _big_x2); Tauto.
  Apply (rem_36 _big_x1 _big_x2); Tauto.
  Apply (rem_37 _big_x1 _big_x2); Tauto.
  Apply (rem_38 _big_x1 _big_x2); Tauto.
  Apply (rem_42 _big_x1 _big_x2); Tauto.
  Apply (rem_46 _big_x1 _big_x2); Tauto.
  Apply (rem_120 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_122 : (_big_x1,_big_x2:extterm)(auto___aux_29 _big_x2) -> (auto___aux_43 _big_x1) -> (auto___aux_42 (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_42_crypt_1; Assumption. Defined.

Remark rem_123 : (auto___aux_21 ext_nil) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_124 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_20 _big_x1) -> (auto___aux_21 ext_nil) -> (auto___aux_18 _big_x3) -> (auto___aux_17 (ext_key ext_sym (ext_cons _big_x2 (ext_cons ext_server ext_nil)))) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intros H1. Intro H.
  Elim (rem_123 H); Intros.
Defined.

Remark rem_125 : (X1,X2:extterm)(auto___aux_19 (ext_cons X1 X2)) -> (or_1
    ((auto___aux_20 X1) /\ (auto___aux_21 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_126 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_18 _big_x3) -> (auto___aux_19 (ext_cons _big_x1 ext_nil)) -> (auto___aux_17 (ext_key ext_sym (ext_cons _big_x2 (ext_cons ext_server ext_nil)))) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intros H1. Intro H.
  Elim (rem_125 _big_x1 ext_nil H); Intros.
  Apply (rem_124 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_127 : (X1,X2:extterm)(auto___aux_16 (ext_cons X1 X2)) -> (or_1
    ((auto___aux_18 X1) /\ (auto___aux_19 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_128 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_16 (ext_cons _big_x3 (ext_cons _big_x1 ext_nil))) -> (auto___aux_17 (ext_key ext_sym (ext_cons _big_x2 (ext_cons ext_server ext_nil)))) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_127 _big_x3 (ext_cons _big_x1 ext_nil) H); Intros.
  Apply (rem_126 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_129 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_20 _big_x2) -> (auto___aux_33 (ext_cons ext_server ext_nil)) -> (auto___aux_31 _big_x1) -> (auto___aux_39 _big_x3) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_48___tuple____aux_48_1; Assumption. Defined.

Remark rem_130 : (X1,X2:extterm)(auto___aux_32 (ext_cons X1 X2)) -> (or_1
    ((auto___aux_20 X1) /\ (auto___aux_33 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_131 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_32 (ext_cons _big_x2 (ext_cons ext_server ext_nil))) -> (auto___aux_31 _big_x1) -> (auto___aux_39 _big_x3) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_130 _big_x2 (ext_cons ext_server ext_nil) H); Intros.
  Apply (rem_129 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_132 : (auto___aux_24 ext_sym) -> (or_1
    True).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_133 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_24 ext_sym) -> (auto___aux_32 (ext_cons _big_x2 (ext_cons ext_server ext_nil))) -> (auto___aux_31 _big_x1) -> (auto___aux_39 _big_x3) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_132 H); Intros.
  Apply (rem_131 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_134 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_31 _big_x1) -> (auto___aux_39 _big_x3) -> (auto___aux_29 (ext_key ext_sym (ext_cons _big_x2 (ext_cons ext_server ext_nil)))) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intros H1 H2. Intro H.
  Elim (rem_31 ext_sym (ext_cons _big_x2 (ext_cons ext_server ext_nil)) H); Intros.
  Apply (rem_133 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_135 : (auto___aux_27 ext_nil) -> (or_1
    True).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_136 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_31 _big_x1) -> (auto___aux_27 ext_nil) -> (auto___aux_39 _big_x3) -> (auto___aux_29 (ext_key ext_sym (ext_cons _big_x2 (ext_cons ext_server ext_nil)))) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intros H1. Intro H.
  Elim (rem_135 H); Intros.
  Apply (rem_134 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_137 : (X1,X2:extterm)(auto___aux_30 (ext_cons X1 X2)) -> (or_1
    ((auto___aux_31 X1) /\ (auto___aux_27 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_138 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_39 _big_x3) -> (auto___aux_30 (ext_cons _big_x1 ext_nil)) -> (auto___aux_29 (ext_key ext_sym (ext_cons _big_x2 (ext_cons ext_server ext_nil)))) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intros H1. Intro H.
  Elim (rem_137 _big_x1 ext_nil H); Intros.
  Apply (rem_136 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_139 : (X1,X2:extterm)(auto___aux_43 (ext_cons X1 X2)) -> (or_1
    ((auto___aux_39 X1) /\ (auto___aux_30 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_140 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_43 (ext_cons _big_x3 (ext_cons _big_x1 ext_nil))) -> (auto___aux_29 (ext_key ext_sym (ext_cons _big_x2 (ext_cons ext_server ext_nil)))) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_139 _big_x3 (ext_cons _big_x1 ext_nil) H); Intros.
  Apply (rem_138 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_141 : (X1,X2:extterm)(auto___aux_51 (ext_cons X1 X2)) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_142 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_51 (ext_cons _big_x3 (ext_cons _big_x1 ext_nil))) -> (auto___aux_52 (ext_key ext_sym (ext_cons _big_x2 (ext_cons ext_server ext_nil)))) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_141 _big_x3 (ext_cons _big_x1 ext_nil) H); Intros.
Defined.

Remark rem_143 : (X1,X2:extterm)(auto___aux_49 (ext_cons X1 X2)) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_144 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_49 (ext_cons _big_x3 (ext_cons _big_x1 ext_nil))) -> (auto___aux_50 (ext_key ext_sym (ext_cons _big_x2 (ext_cons ext_server ext_nil)))) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_143 _big_x3 (ext_cons _big_x1 ext_nil) H); Intros.
Defined.

Remark rem_145 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_20 _big_x2) -> (auto___aux_33 (ext_cons ext_server ext_nil)) -> (auto___aux_31 _big_x1) -> (auto___aux_22 _big_x3) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_48___tuple____aux_48_2; Assumption. Defined.

Remark rem_146 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_32 (ext_cons _big_x2 (ext_cons ext_server ext_nil))) -> (auto___aux_31 _big_x1) -> (auto___aux_22 _big_x3) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_130 _big_x2 (ext_cons ext_server ext_nil) H); Intros.
  Apply (rem_145 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_147 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_24 ext_sym) -> (auto___aux_32 (ext_cons _big_x2 (ext_cons ext_server ext_nil))) -> (auto___aux_31 _big_x1) -> (auto___aux_22 _big_x3) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_132 H); Intros.
  Apply (rem_146 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_148 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_31 _big_x1) -> (auto___aux_22 _big_x3) -> (auto___aux_29 (ext_key ext_sym (ext_cons _big_x2 (ext_cons ext_server ext_nil)))) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intros H1 H2. Intro H.
  Elim (rem_31 ext_sym (ext_cons _big_x2 (ext_cons ext_server ext_nil)) H); Intros.
  Apply (rem_147 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_149 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_31 _big_x1) -> (auto___aux_27 ext_nil) -> (auto___aux_22 _big_x3) -> (auto___aux_29 (ext_key ext_sym (ext_cons _big_x2 (ext_cons ext_server ext_nil)))) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intros H1. Intro H.
  Elim (rem_135 H); Intros.
  Apply (rem_148 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_150 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_22 _big_x3) -> (auto___aux_30 (ext_cons _big_x1 ext_nil)) -> (auto___aux_29 (ext_key ext_sym (ext_cons _big_x2 (ext_cons ext_server ext_nil)))) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intros H1. Intro H.
  Elim (rem_137 _big_x1 ext_nil H); Intros.
  Apply (rem_149 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_151 : (X1,X2:extterm)(auto___aux_28 (ext_cons X1 X2)) -> (or_1
    ((auto___aux_22 X1) /\ (auto___aux_30 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_152 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_28 (ext_cons _big_x3 (ext_cons _big_x1 ext_nil))) -> (auto___aux_29 (ext_key ext_sym (ext_cons _big_x2 (ext_cons ext_server ext_nil)))) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_151 _big_x3 (ext_cons _big_x1 ext_nil) H); Intros.
  Apply (rem_150 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_153 : (auto___aux_38 ext_nil) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_154 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_20 _big_x1) -> (auto___aux_38 ext_nil) -> (auto___aux_18 _big_x3) -> (auto___aux_17 (ext_key ext_sym (ext_cons _big_x2 (ext_cons ext_server ext_nil)))) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intros H1. Intro H.
  Elim (rem_153 H); Intros.
Defined.

Remark rem_155 : (X1,X2:extterm)(auto___aux_37 (ext_cons X1 X2)) -> (or_1
    ((auto___aux_20 X1) /\ (auto___aux_38 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_156 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_18 _big_x3) -> (auto___aux_37 (ext_cons _big_x1 ext_nil)) -> (auto___aux_17 (ext_key ext_sym (ext_cons _big_x2 (ext_cons ext_server ext_nil)))) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intros H1. Intro H.
  Elim (rem_155 _big_x1 ext_nil H); Intros.
  Apply (rem_154 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_157 : (X1,X2:extterm)(auto___aux_36 (ext_cons X1 X2)) -> (or_1
    ((auto___aux_18 X1) /\ (auto___aux_37 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_158 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_36 (ext_cons _big_x3 (ext_cons _big_x1 ext_nil))) -> (auto___aux_17 (ext_key ext_sym (ext_cons _big_x2 (ext_cons ext_server ext_nil)))) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_157 _big_x3 (ext_cons _big_x1 ext_nil) H); Intros.
  Apply (rem_156 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_159 : (auto___aux_55 ext_sym) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_160 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_55 ext_sym) -> (auto___aux_56 (ext_cons _big_x2 (ext_cons ext_server ext_nil))) -> (auto_knows _big_x1) -> (auto_knows _big_x3) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_159 H); Intros.
Defined.

Remark rem_161 : (X1,X2:extterm)(auto___aux_58 (ext_cons X1 X2)) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_162 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_58 (ext_cons _big_x2 (ext_cons ext_server ext_nil))) -> (auto_knows _big_x1) -> (auto_knows _big_x3) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_161 _big_x2 (ext_cons ext_server ext_nil) H); Intros.
Defined.

Remark rem_163 : (auto___aux_57 ext_sym) -> (or_1
    True).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_164 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_57 ext_sym) -> (auto___aux_58 (ext_cons _big_x2 (ext_cons ext_server ext_nil))) -> (auto_knows _big_x1) -> (auto_knows _big_x3) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_163 H); Intros.
  Apply (rem_162 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_165 : (auto___aux_53 ext_sym) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_166 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_53 ext_sym) -> (auto_knows _big_x1) -> (auto_knows _big_x3) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_165 H); Intros.
Defined.

Remark rem_167 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_53 ext_sym) -> (auto___aux_54 (ext_cons _big_x2 (ext_cons ext_server ext_nil))) -> (auto_knows _big_x1) -> (auto_knows _big_x3) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom by universal clause. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intros. Apply (rem_166 _big_x1 _big_x2 _big_x3); Assumption.
Defined.

Remark rem_168 : (_big_x1,_big_x2,_big_x3:extterm)(auto_knows _big_x1) -> (auto_knows _big_x3) -> (auto_knows (ext_key ext_sym (ext_cons _big_x2 (ext_cons ext_server ext_nil)))) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intros H1 H2. Intro H.
  Elim (rem_115 ext_sym (ext_cons _big_x2 (ext_cons ext_server ext_nil)) H); Intros.
  Apply (rem_160 _big_x1 _big_x2 _big_x3); Tauto.
  Apply (rem_164 _big_x1 _big_x2 _big_x3); Tauto.
  Apply (rem_167 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_169 : (_big_x1,_big_x2,_big_x3:extterm)(auto_knows _big_x1) -> (auto_knows ext_nil) -> (auto_knows _big_x3) -> (auto_knows (ext_key ext_sym (ext_cons _big_x2 (ext_cons ext_server ext_nil)))) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intros H1. Intro H.
  Elim (rem_53 H); Intros.
  Apply (rem_168 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_170 : (_big_x1,_big_x2,_big_x3:extterm)(auto_knows _big_x3) -> (auto_knows (ext_cons _big_x1 ext_nil)) -> (auto_knows (ext_key ext_sym (ext_cons _big_x2 (ext_cons ext_server ext_nil)))) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intros H1. Intro H.
  Elim (rem_74 _big_x1 ext_nil H); Intros.
  Apply (rem_169 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_171 : (_big_x1,_big_x2,_big_x3:extterm)(auto_knows (ext_cons _big_x3 (ext_cons _big_x1 ext_nil))) -> (auto_knows (ext_key ext_sym (ext_cons _big_x2 (ext_cons ext_server ext_nil)))) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_74 _big_x3 (ext_cons _big_x1 ext_nil) H); Intros.
  Apply (rem_170 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_172 : (_big_x1,_big_x2,_big_x3:extterm)(auto_knows (ext_crypt (ext_cons _big_x3 (ext_cons _big_x1 ext_nil)) (ext_key ext_sym (ext_cons _big_x2 (ext_cons ext_server ext_nil))))) -> (auto___aux_48 (ext___tuple____aux_48 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_92 (ext_cons _big_x3 (ext_cons _big_x1 ext_nil)) (ext_key ext_sym (ext_cons _big_x2 (ext_cons ext_server ext_nil))) H); Intros.
  Apply (rem_128 _big_x1 _big_x2 _big_x3); Tauto.
  Apply (rem_140 _big_x1 _big_x2 _big_x3); Tauto.
  Apply (rem_142 _big_x1 _big_x2 _big_x3); Tauto.
  Apply (rem_144 _big_x1 _big_x2 _big_x3); Tauto.
  Apply (rem_152 _big_x1 _big_x2 _big_x3); Tauto.
  Apply (rem_158 _big_x1 _big_x2 _big_x3); Tauto.
  Apply (rem_171 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_173 : (auto___aux_12 ext_nil). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_12_nil_1; Assumption. Defined.

Remark rem_174 : (_big_x1,_big_x2:extterm)(auto___aux_26 _big_x2) -> (auto___aux_27 ext_nil) -> (auto___aux_22 _big_x1) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_44___tuple____aux_44_2; Assumption. Defined.

Remark rem_175 : (X1,X2:extterm)(auto___aux_23 (ext_cons X1 X2)) -> (or_1
    ((auto___aux_26 X1) /\ (auto___aux_27 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_176 : (_big_x1,_big_x2:extterm)(auto___aux_22 _big_x1) -> (auto___aux_23 (ext_cons _big_x2 ext_nil)) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros H1. Intro H.
  Elim (rem_175 _big_x2 ext_nil H); Intros.
  Apply (rem_174 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_177 : (X1,X2:extterm)(auto___aux_21 (ext_cons X1 X2)) -> (or_1
    ((auto___aux_22 X1) /\ (auto___aux_23 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_178 : (_big_x1,_big_x2:extterm)(auto___aux_21 (ext_cons _big_x1 (ext_cons _big_x2 ext_nil))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_177 _big_x1 (ext_cons _big_x2 ext_nil) H); Intros.
  Apply (rem_176 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_179 : (auto___aux_20 ext_bob) -> (or_1
    True).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_180 : (_big_x1,_big_x2:extterm)(auto___aux_20 ext_bob) -> (auto___aux_21 (ext_cons _big_x1 (ext_cons _big_x2 ext_nil))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_179 H); Intros.
  Apply (rem_178 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_181 : (_big_x1,_big_x2:extterm)(auto___aux_19 (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_125 ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)) H); Intros.
  Apply (rem_180 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_182 : (auto___aux_12 ext_nil) -> (or_1
    True).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_183 : (_big_x1,_big_x2:extterm)(auto___aux_12 ext_nil) -> (auto___aux_19 (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_182 H); Intros.
  Apply (rem_181 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_184 : (auto___aux_9 ext_bob) -> (or_1
    True).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_185 : (_big_x1,_big_x2:extterm)(auto___aux_9 ext_bob) -> (auto___aux_12 ext_nil) -> (auto___aux_19 (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_184 H); Intros.
  Apply (rem_183 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_186 : (X1,X2:extterm)(auto___aux_14 (ext_cons X1 X2)) -> (or_1
    ((auto___aux_9 X1) /\ (auto___aux_12 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_187 : (_big_x1,_big_x2:extterm)(auto___aux_14 (ext_cons ext_bob ext_nil)) -> (auto___aux_19 (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_186 ext_bob ext_nil H); Intros.
  Apply (rem_185 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_188 : (auto___aux_7 ext_alice) -> (or_1
    True).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_189 : (_big_x1,_big_x2:extterm)(auto___aux_7 ext_alice) -> (auto___aux_14 (ext_cons ext_bob ext_nil)) -> (auto___aux_19 (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_188 H); Intros.
  Apply (rem_187 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_190 : (X1,X2:extterm)(auto___aux_13 (ext_cons X1 X2)) -> (or_1
    ((auto___aux_7 X1) /\ (auto___aux_14 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_191 : (_big_x1,_big_x2:extterm)(auto___aux_13 (ext_cons ext_alice (ext_cons ext_bob ext_nil))) -> (auto___aux_19 (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_190 ext_alice (ext_cons ext_bob ext_nil) H); Intros.
  Apply (rem_189 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_192 : (X1:extterm)(auto___aux_18 (ext_noncea X1)) -> (or_1
    (auto___aux_13 X1)).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_193 : (_big_x1,_big_x2:extterm)(auto___aux_18 (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil)))) -> (auto___aux_19 (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_192 (ext_cons ext_alice (ext_cons ext_bob ext_nil)) H); Intros.
  Apply (rem_191 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_194 : (_big_x1,_big_x2:extterm)(auto___aux_16 (ext_cons (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil))))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_127 (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil))) H); Intros.
  Apply (rem_193 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_195 : (X1:extterm)(auto___aux_39 (ext_noncea X1)) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_196 : (_big_x1,_big_x2:extterm)(auto___aux_39 (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil)))) -> (auto___aux_30 (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)))) -> (auto___aux_29 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_195 (ext_cons ext_alice (ext_cons ext_bob ext_nil)) H); Intros.
Defined.

Remark rem_197 : (_big_x1,_big_x2:extterm)(auto___aux_43 (ext_cons (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil))))) -> (auto___aux_29 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_139 (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil))) H); Intros.
  Apply (rem_196 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_198 : (_big_x1,_big_x2:extterm)(auto___aux_51 (ext_cons (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil))))) -> (auto___aux_52 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_141 (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil))) H); Intros.
Defined.

Remark rem_199 : (_big_x1,_big_x2:extterm)(auto___aux_49 (ext_cons (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil))))) -> (auto___aux_50 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_143 (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil))) H); Intros.
Defined.

Remark rem_200 : (X1:extterm)(auto___aux_22 (ext_noncea X1)) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_201 : (_big_x1,_big_x2:extterm)(auto___aux_22 (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil)))) -> (auto___aux_30 (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)))) -> (auto___aux_29 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_200 (ext_cons ext_alice (ext_cons ext_bob ext_nil)) H); Intros.
Defined.

Remark rem_202 : (_big_x1,_big_x2:extterm)(auto___aux_28 (ext_cons (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil))))) -> (auto___aux_29 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_151 (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil))) H); Intros.
  Apply (rem_201 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_203 : (_big_x1,_big_x2:extterm)(auto___aux_42 _big_x2) -> (auto___aux_27 ext_nil) -> (auto___aux_39 _big_x1) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_44___tuple____aux_44_1; Assumption. Defined.

Remark rem_204 : (X1,X2:extterm)(auto___aux_40 (ext_cons X1 X2)) -> (or_1
    ((auto___aux_42 X1) /\ (auto___aux_27 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_205 : (_big_x1,_big_x2:extterm)(auto___aux_39 _big_x1) -> (auto___aux_40 (ext_cons _big_x2 ext_nil)) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros H1. Intro H.
  Elim (rem_204 _big_x2 ext_nil H); Intros.
  Apply (rem_203 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_206 : (X1,X2:extterm)(auto___aux_38 (ext_cons X1 X2)) -> (or_1
    ((auto___aux_39 X1) /\ (auto___aux_40 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_207 : (_big_x1,_big_x2:extterm)(auto___aux_38 (ext_cons _big_x1 (ext_cons _big_x2 ext_nil))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_206 _big_x1 (ext_cons _big_x2 ext_nil) H); Intros.
  Apply (rem_205 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_208 : (_big_x1,_big_x2:extterm)(auto___aux_20 ext_bob) -> (auto___aux_38 (ext_cons _big_x1 (ext_cons _big_x2 ext_nil))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_179 H); Intros.
  Apply (rem_207 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_209 : (_big_x1,_big_x2:extterm)(auto___aux_37 (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_155 ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)) H); Intros.
  Apply (rem_208 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_210 : (_big_x1,_big_x2:extterm)(auto___aux_12 ext_nil) -> (auto___aux_37 (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_182 H); Intros.
  Apply (rem_209 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_211 : (_big_x1,_big_x2:extterm)(auto___aux_9 ext_bob) -> (auto___aux_12 ext_nil) -> (auto___aux_37 (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_184 H); Intros.
  Apply (rem_210 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_212 : (_big_x1,_big_x2:extterm)(auto___aux_14 (ext_cons ext_bob ext_nil)) -> (auto___aux_37 (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_186 ext_bob ext_nil H); Intros.
  Apply (rem_211 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_213 : (_big_x1,_big_x2:extterm)(auto___aux_7 ext_alice) -> (auto___aux_14 (ext_cons ext_bob ext_nil)) -> (auto___aux_37 (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_188 H); Intros.
  Apply (rem_212 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_214 : (_big_x1,_big_x2:extterm)(auto___aux_13 (ext_cons ext_alice (ext_cons ext_bob ext_nil))) -> (auto___aux_37 (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_190 ext_alice (ext_cons ext_bob ext_nil) H); Intros.
  Apply (rem_213 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_215 : (_big_x1,_big_x2:extterm)(auto___aux_18 (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil)))) -> (auto___aux_37 (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_192 (ext_cons ext_alice (ext_cons ext_bob ext_nil)) H); Intros.
  Apply (rem_214 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_216 : (_big_x1,_big_x2:extterm)(auto___aux_36 (ext_cons (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil))))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_157 (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil))) H); Intros.
  Apply (rem_215 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_217 : (_big_x1,_big_x2:extterm)(auto___aux_55 ext_sym) -> (auto___aux_56 (ext_cons ext_alice (ext_cons ext_server ext_nil))) -> (auto_knows _big_x2) -> (auto_knows _big_x1) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_159 H); Intros.
Defined.

Remark rem_218 : (_big_x1,_big_x2:extterm)(auto___aux_58 (ext_cons ext_alice (ext_cons ext_server ext_nil))) -> (auto_knows _big_x2) -> (auto_knows _big_x1) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_161 ext_alice (ext_cons ext_server ext_nil) H); Intros.
Defined.

Remark rem_219 : (_big_x1,_big_x2:extterm)(auto___aux_57 ext_sym) -> (auto___aux_58 (ext_cons ext_alice (ext_cons ext_server ext_nil))) -> (auto_knows _big_x2) -> (auto_knows _big_x1) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_163 H); Intros.
  Apply (rem_218 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_220 : (_big_x1,_big_x2:extterm)(auto___aux_53 ext_sym) -> (auto_knows _big_x2) -> (auto_knows _big_x1) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_165 H); Intros.
Defined.

Remark rem_221 : (_big_x1,_big_x2:extterm)(auto___aux_53 ext_sym) -> (auto___aux_54 (ext_cons ext_alice (ext_cons ext_server ext_nil))) -> (auto_knows _big_x2) -> (auto_knows _big_x1) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom by universal clause. *)
Proof.
   Intros _big_x1 _big_x2. Intros. Apply (rem_220 _big_x1 _big_x2); Assumption.
Defined.

Remark rem_222 : (_big_x1,_big_x2:extterm)(auto_knows _big_x2) -> (auto_knows _big_x1) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros H1 H2. Intro H.
  Elim (rem_115 ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)) H); Intros.
  Apply (rem_217 _big_x1 _big_x2); Tauto.
  Apply (rem_219 _big_x1 _big_x2); Tauto.
  Apply (rem_221 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_223 : (_big_x1,_big_x2:extterm)(auto_knows _big_x2) -> (auto_knows ext_nil) -> (auto_knows _big_x1) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros H1. Intro H.
  Elim (rem_53 H); Intros.
  Apply (rem_222 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_224 : (_big_x1,_big_x2:extterm)(auto_knows _big_x1) -> (auto_knows (ext_cons _big_x2 ext_nil)) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros H1. Intro H.
  Elim (rem_74 _big_x2 ext_nil H); Intros.
  Apply (rem_223 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_225 : (_big_x1,_big_x2:extterm)(auto_knows (ext_cons _big_x1 (ext_cons _big_x2 ext_nil))) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_74 _big_x1 (ext_cons _big_x2 ext_nil) H); Intros.
  Apply (rem_224 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_226 : (_big_x1,_big_x2:extterm)(auto_knows ext_bob) -> (auto_knows (ext_cons _big_x1 (ext_cons _big_x2 ext_nil))) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_82 H); Intros.
  Apply (rem_225 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_227 : (_big_x1,_big_x2:extterm)(auto_knows (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)))) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_74 ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)) H); Intros.
  Apply (rem_226 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_228 : (_big_x1,_big_x2:extterm)(auto___aux_12 ext_nil) -> (auto_knows (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)))) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_182 H); Intros.
  Apply (rem_227 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_229 : (_big_x1,_big_x2:extterm)(auto___aux_9 ext_bob) -> (auto___aux_12 ext_nil) -> (auto_knows (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)))) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_184 H); Intros.
  Apply (rem_228 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_230 : (_big_x1,_big_x2:extterm)(auto___aux_14 (ext_cons ext_bob ext_nil)) -> (auto_knows (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)))) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_186 ext_bob ext_nil H); Intros.
  Apply (rem_229 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_231 : (_big_x1,_big_x2:extterm)(auto___aux_7 ext_alice) -> (auto___aux_14 (ext_cons ext_bob ext_nil)) -> (auto_knows (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)))) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_188 H); Intros.
  Apply (rem_230 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_232 : (_big_x1,_big_x2:extterm)(auto___aux_13 (ext_cons ext_alice (ext_cons ext_bob ext_nil))) -> (auto_knows (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)))) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_190 ext_alice (ext_cons ext_bob ext_nil) H); Intros.
  Apply (rem_231 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_233 : (_big_x1,_big_x2:extterm)(auto_knows (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil)))) -> (auto_knows (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)))) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_78 (ext_cons ext_alice (ext_cons ext_bob ext_nil)) H); Intros.
  Apply (rem_232 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_234 : (_big_x1,_big_x2:extterm)(auto_knows (ext_cons (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil))))) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_74 (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil))) H); Intros.
  Apply (rem_233 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_235 : (_big_x1,_big_x2:extterm)(auto_knows (ext_crypt (ext_cons (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)))) (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil))))) -> (auto___aux_44 (ext___tuple____aux_44 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_92 (ext_cons (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons _big_x1 (ext_cons _big_x2 ext_nil)))) (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil))) H); Intros.
  Apply (rem_194 _big_x1 _big_x2); Tauto.
  Apply (rem_197 _big_x1 _big_x2); Tauto.
  Apply (rem_198 _big_x1 _big_x2); Tauto.
  Apply (rem_199 _big_x1 _big_x2); Tauto.
  Apply (rem_202 _big_x1 _big_x2); Tauto.
  Apply (rem_216 _big_x1 _big_x2); Tauto.
  Apply (rem_234 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_236 : (_big_x1:extterm)(auto___aux_55 ext_sym) -> (auto___aux_56 _big_x1) -> (auto___aux_5 _big_x1). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1. Intro H.
  Elim (rem_159 H); Intros.
Defined.

Remark rem_237 : ((X:extterm)(auto___aux_58 X) -> (auto___aux_5 X)) -> (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_58 (ext_old_session _big_x1 _big_x2 _big_x3)) -> (auto___aux_5 (ext_old_session _big_x1 _big_x2 _big_x3)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_5_old_session_1; Assumption. Defined.

Remark rem_238 : (_big_x1:extterm)(auto___aux_58 _big_x1) -> (auto___aux_5 _big_x1). (* Induct. *)
Proof.
   Fix epsilon_m__aux_58_p__aux_5 1.
  Intro X. Case X; First [ Intros X1 X2 X3; Exact (rem_237 epsilon_m__aux_58_p__aux_5 X1 X2 X3)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_239 : (_big_x1:extterm)(auto___aux_58 _big_x1) -> (auto___aux_5 _big_x1). (* Split. *)
Proof.
   Intros _big_x1.
  Cut (auto___aux_58 _big_x1) -> (auto___aux_5 _big_x1). Tauto.
  Exact (rem_238 _big_x1).
Defined.

Remark rem_240 : (_big_x1:extterm)(auto___aux_57 ext_sym) -> (auto___aux_58 _big_x1) -> (auto___aux_5 _big_x1). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1. Intro H.
  Elim (rem_163 H); Intros.
  Apply (rem_239 _big_x1); Tauto.
Defined.

Remark rem_241 : (_big_x1:extterm)(auto___aux_53 ext_sym) -> (auto___aux_5 _big_x1). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1. Intro H.
  Elim (rem_165 H); Intros.
Defined.

Remark rem_242 : (_big_x1:extterm)(auto___aux_53 ext_sym) -> (auto___aux_54 _big_x1) -> (auto___aux_5 _big_x1). (* Eliminate negative atom by universal clause. *)
Proof.
   Intros _big_x1. Intros. Apply (rem_241 _big_x1); Assumption.
Defined.

Remark rem_243 : (_big_x1:extterm)(auto_knows (ext_key ext_sym _big_x1)) -> (auto___aux_5 _big_x1). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1. Intro H.
  Elim (rem_115 ext_sym _big_x1 H); Intros.
  Apply (rem_236 _big_x1); Tauto.
  Apply (rem_240 _big_x1); Tauto.
  Apply (rem_242 _big_x1); Tauto.
Defined.

Remark rem_244 : (_big_x1:extterm)(auto___aux_13 _big_x1) -> (auto___aux_11 (ext_noncea _big_x1)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_11_noncea_1; Assumption. Defined.

Remark rem_245 : (_big_x1,_big_x2:extterm)(auto___aux_21 _big_x2) -> (auto___aux_20 _big_x1) -> (auto___aux_19 (ext_cons _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_19_cons_1; Assumption. Defined.

Remark rem_246 : (auto___aux_57 ext_sym). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_57_sym_1; Assumption. Defined.

Remark rem_247 : (_big_x1,_big_x2,_big_x3:extterm)(auto_knows _big_x1) -> (auto_knows _big_x2) -> (auto_knows _big_x3) -> (auto___aux_41 (ext_old_session _big_x1 _big_x2 _big_x3)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_41_old_session_1; Assumption. Defined.

Remark rem_248 : (X1,X2,X3:extterm)(auto___aux_15 (ext___tuple____aux_15 X1 X2 X3)) -> (or_1
    ((auto_knows X1) /\ (auto_knows X2) /\ (auto_knows X3))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_249 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_15 (ext___tuple____aux_15 _big_x1 _big_x2 _big_x3)) -> (auto___aux_41 (ext_old_session _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_248 _big_x1 _big_x2 _big_x3 H); Intros.
  Apply (rem_247 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_250 : (auto___aux_24 ext_pub) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_251 : (_big_x1,_big_x2:extterm)(auto___aux_24 ext_pub) -> (auto___aux_35 _big_x1) -> (auto___aux_16 _big_x2) -> (auto___aux_2 (ext___tuple____aux_2 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_250 H); Intros.
Defined.

Remark rem_252 : (_big_x1,_big_x2:extterm)(auto___aux_16 _big_x2) -> (auto___aux_17 (ext_key ext_pub _big_x1)) -> (auto___aux_2 (ext___tuple____aux_2 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros H1. Intro H.
  Elim (rem_18 ext_pub _big_x1 H); Intros.
  Apply (rem_251 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_253 : (_big_x1,_big_x2:extterm)(auto___aux_24 ext_pub) -> (auto___aux_32 _big_x1) -> (auto___aux_43 _big_x2) -> (auto___aux_2 (ext___tuple____aux_2 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_250 H); Intros.
Defined.

Remark rem_254 : (_big_x1,_big_x2:extterm)(auto___aux_43 _big_x2) -> (auto___aux_29 (ext_key ext_pub _big_x1)) -> (auto___aux_2 (ext___tuple____aux_2 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros H1. Intro H.
  Elim (rem_31 ext_pub _big_x1 H); Intros.
  Apply (rem_253 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_255 : (_big_x1,_big_x2:extterm)(auto___aux_24 ext_pub) -> (auto___aux_46 ext_pub) -> (auto___aux_25 _big_x1) -> (auto___aux_47 _big_x1) -> (auto___aux_51 _big_x2) -> (auto___aux_2 (ext___tuple____aux_2 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_250 H); Intros.
Defined.

Remark rem_256 : (X1,X2:extterm)(auto___aux_52 (ext_key X1 X2)) -> (or_1
    ((auto___aux_24 X1) /\ (auto___aux_46 X1) /\ (auto___aux_25 X2) /\ (auto___aux_47 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_257 : (_big_x1,_big_x2:extterm)(auto___aux_51 _big_x2) -> (auto___aux_52 (ext_key ext_pub _big_x1)) -> (auto___aux_2 (ext___tuple____aux_2 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros H1. Intro H.
  Elim (rem_256 ext_pub _big_x1 H); Intros.
  Apply (rem_255 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_258 : (_big_x1,_big_x2:extterm)(auto___aux_24 ext_pub) -> (auto___aux_41 _big_x1) -> (auto___aux_49 _big_x2) -> (auto___aux_2 (ext___tuple____aux_2 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_250 H); Intros.
Defined.

Remark rem_259 : (_big_x1,_big_x2:extterm)(auto___aux_24 ext_pub) -> (auto___aux_25 _big_x1) -> (auto___aux_49 _big_x2) -> (auto___aux_2 (ext___tuple____aux_2 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_250 H); Intros.
Defined.

Remark rem_260 : (X1,X2:extterm)(auto___aux_50 (ext_key X1 X2)) -> (or_2
    ((auto___aux_24 X1) /\ (auto___aux_41 X2))
    ((auto___aux_24 X1) /\ (auto___aux_25 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_2_intro_1; Tauto.
  Intros. Apply or_2_intro_2; Tauto.
Qed.

Remark rem_261 : (_big_x1,_big_x2:extterm)(auto___aux_49 _big_x2) -> (auto___aux_50 (ext_key ext_pub _big_x1)) -> (auto___aux_2 (ext___tuple____aux_2 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros H1. Intro H.
  Elim (rem_260 ext_pub _big_x1 H); Intros.
  Apply (rem_258 _big_x1 _big_x2); Tauto.
  Apply (rem_259 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_262 : (_big_x1,_big_x2:extterm)(auto___aux_24 ext_pub) -> (auto___aux_32 _big_x1) -> (auto___aux_28 _big_x2) -> (auto___aux_2 (ext___tuple____aux_2 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_250 H); Intros.
Defined.

Remark rem_263 : (_big_x1,_big_x2:extterm)(auto___aux_28 _big_x2) -> (auto___aux_29 (ext_key ext_pub _big_x1)) -> (auto___aux_2 (ext___tuple____aux_2 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros H1. Intro H.
  Elim (rem_31 ext_pub _big_x1 H); Intros.
  Apply (rem_262 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_264 : (_big_x1,_big_x2:extterm)(auto___aux_24 ext_pub) -> (auto___aux_35 _big_x1) -> (auto___aux_36 _big_x2) -> (auto___aux_2 (ext___tuple____aux_2 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_250 H); Intros.
Defined.

Remark rem_265 : (_big_x1,_big_x2:extterm)(auto___aux_36 _big_x2) -> (auto___aux_17 (ext_key ext_pub _big_x1)) -> (auto___aux_2 (ext___tuple____aux_2 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros H1. Intro H.
  Elim (rem_18 ext_pub _big_x1 H); Intros.
  Apply (rem_264 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_266 : (auto___aux_55 ext_pub) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_267 : (_big_x1,_big_x2:extterm)(auto___aux_55 ext_pub) -> (auto___aux_56 _big_x1) -> (auto_knows _big_x2) -> (auto___aux_2 (ext___tuple____aux_2 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_266 H); Intros.
Defined.

Remark rem_268 : (auto___aux_57 ext_pub) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_269 : (_big_x1,_big_x2:extterm)(auto___aux_57 ext_pub) -> (auto___aux_58 _big_x1) -> (auto_knows _big_x2) -> (auto___aux_2 (ext___tuple____aux_2 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_268 H); Intros.
Defined.

Remark rem_270 : (_big_x1,_big_x2:extterm)(auto___aux_53 ext_pub) -> (auto___aux_54 _big_x1) -> (auto_knows _big_x2) -> (auto___aux_2 (ext___tuple____aux_2 _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_2___tuple____aux_2_1; Assumption. Defined.

Remark rem_271 : (_big_x1,_big_x2:extterm)(auto_knows _big_x2) -> (auto_knows (ext_key ext_pub _big_x1)) -> (auto___aux_2 (ext___tuple____aux_2 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros H1. Intro H.
  Elim (rem_115 ext_pub _big_x1 H); Intros.
  Apply (rem_267 _big_x1 _big_x2); Tauto.
  Apply (rem_269 _big_x1 _big_x2); Tauto.
  Apply (rem_270 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_272 : (_big_x1,_big_x2:extterm)(auto_knows (ext_crypt _big_x2 (ext_key ext_pub _big_x1))) -> (auto___aux_2 (ext___tuple____aux_2 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_92 _big_x2 (ext_key ext_pub _big_x1) H); Intros.
  Apply (rem_252 _big_x1 _big_x2); Tauto.
  Apply (rem_254 _big_x1 _big_x2); Tauto.
  Apply (rem_257 _big_x1 _big_x2); Tauto.
  Apply (rem_261 _big_x1 _big_x2); Tauto.
  Apply (rem_263 _big_x1 _big_x2); Tauto.
  Apply (rem_265 _big_x1 _big_x2); Tauto.
  Apply (rem_271 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_273 : (_big_x1,_big_x2,_big_x3:extterm)(auto_knows _big_x3) -> (auto_knows ext_nil) -> (auto_knows _big_x2) -> (auto_knows _big_x1) -> (auto___aux_15 (ext___tuple____aux_15 _big_x1 _big_x2 _big_x3)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_15___tuple____aux_15_1; Assumption. Defined.

Remark rem_274 : (_big_x1,_big_x2,_big_x3:extterm)(auto_knows _big_x2) -> (auto_knows (ext_cons _big_x3 ext_nil)) -> (auto_knows _big_x1) -> (auto___aux_15 (ext___tuple____aux_15 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intros H1. Intro H.
  Elim (rem_74 _big_x3 ext_nil H); Intros.
  Apply (rem_273 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_275 : (_big_x1,_big_x2,_big_x3:extterm)(auto_knows _big_x1) -> (auto_knows (ext_cons _big_x2 (ext_cons _big_x3 ext_nil))) -> (auto___aux_15 (ext___tuple____aux_15 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intros H1. Intro H.
  Elim (rem_74 _big_x2 (ext_cons _big_x3 ext_nil) H); Intros.
  Apply (rem_274 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_276 : (_big_x1,_big_x2,_big_x3:extterm)(auto_knows (ext_cons _big_x1 (ext_cons _big_x2 (ext_cons _big_x3 ext_nil)))) -> (auto___aux_15 (ext___tuple____aux_15 _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_74 _big_x1 (ext_cons _big_x2 (ext_cons _big_x3 ext_nil)) H); Intros.
  Apply (rem_275 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_277 : (_big_x1,_big_x2:extterm)(auto___aux_27 _big_x2) -> (auto___aux_26 _big_x1) -> (auto___aux_23 (ext_cons _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_23_cons_1; Assumption. Defined.

Remark rem_278 : (_big_x1,_big_x2:extterm)(auto___aux_40 _big_x2) -> (auto___aux_39 _big_x1) -> (auto___aux_38 (ext_cons _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_38_cons_1; Assumption. Defined.

Remark rem_279 : (_big_x1,_big_x2:extterm)(auto___aux_12 _big_x2) -> (auto___aux_11 _big_x1) -> (auto___aux_10 (ext_cons _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_10_cons_1; Assumption. Defined.

Remark rem_280 : ((X:extterm)(auto___aux_56 X) -> (auto___aux_1 X)) -> (auto___aux_56 ext_intruder) -> (auto___aux_1 ext_intruder). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_1_intruder_1; Assumption. Defined.

Remark rem_281 : (_big_x1:extterm)(auto___aux_56 _big_x1) -> (auto___aux_1 _big_x1). (* Induct. *)
Proof.
   Fix epsilon_m__aux_56_p__aux_1 1.
  Intro X. Case X; First [Exact (rem_280 epsilon_m__aux_56_p__aux_1 )
  |  Intros until 1; Inversion H].
Defined.

Remark rem_282 : (_big_x1:extterm)(auto___aux_56 _big_x1) -> (auto___aux_1 _big_x1). (* Split. *)
Proof.
   Intros _big_x1.
  Cut (auto___aux_56 _big_x1) -> (auto___aux_1 _big_x1). Tauto.
  Exact (rem_281 _big_x1).
Defined.

Remark rem_283 : (auto___aux_55 ext_prv) -> (or_1
    True).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_284 : (_big_x1:extterm)(auto___aux_55 ext_prv) -> (auto___aux_56 _big_x1) -> (auto___aux_1 _big_x1). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1. Intro H.
  Elim (rem_283 H); Intros.
  Apply (rem_282 _big_x1); Tauto.
Defined.

Remark rem_285 : (auto___aux_57 ext_prv) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_286 : (_big_x1:extterm)(auto___aux_57 ext_prv) -> (auto___aux_58 _big_x1) -> (auto___aux_1 _big_x1). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1. Intro H.
  Elim (rem_285 H); Intros.
Defined.

Remark rem_287 : (auto___aux_53 ext_prv) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_288 : (_big_x1:extterm)(auto___aux_53 ext_prv) -> (auto___aux_1 _big_x1). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1. Intro H.
  Elim (rem_287 H); Intros.
Defined.

Remark rem_289 : (_big_x1:extterm)(auto___aux_53 ext_prv) -> (auto___aux_54 _big_x1) -> (auto___aux_1 _big_x1). (* Eliminate negative atom by universal clause. *)
Proof.
   Intros _big_x1. Intros. Apply (rem_288 _big_x1); Assumption.
Defined.

Remark rem_290 : (_big_x1:extterm)(auto_knows (ext_key ext_prv _big_x1)) -> (auto___aux_1 _big_x1). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1. Intro H.
  Elim (rem_115 ext_prv _big_x1 H); Intros.
  Apply (rem_284 _big_x1); Tauto.
  Apply (rem_286 _big_x1); Tauto.
  Apply (rem_289 _big_x1); Tauto.
Defined.

Remark rem_291 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_58 (ext_old_session _big_x1 _big_x2 _big_x3)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_58_old_session_1; Assumption. Defined.

Remark rem_292 : (_big_x1,_big_x2:extterm)(auto___aux_35 _big_x2) -> (auto___aux_24 _big_x1) -> (auto___aux_17 (ext_key _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_17_key_1; Assumption. Defined.

Remark rem_293 : ((X:extterm)(auto___aux_39 X) -> (auto___aux_50 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_24 _big_x1) -> (auto___aux_41 _big_x2) -> (auto___aux_50 (ext_key _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_50_key_1; Assumption. Defined.

Remark rem_294 : (X1,X2:extterm)(auto___aux_39 (ext_key X1 X2)) -> (or_1
    ((auto___aux_24 X1) /\ (auto___aux_41 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_295 : ((X:extterm)(auto___aux_39 X) -> (auto___aux_50 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_39 (ext_key _big_x1 _big_x2)) -> (auto___aux_50 (ext_key _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_m__aux_39_p__aux_50. Intros _big_x1 _big_x2. Intro H.
  Elim (rem_294 _big_x1 _big_x2 H); Intros.
  Apply (rem_293 epsilon_m__aux_39_p__aux_50 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_296 : (_big_x1:extterm)(auto___aux_39 _big_x1) -> (auto___aux_50 _big_x1). (* Induct. *)
Proof.
   Fix epsilon_m__aux_39_p__aux_50 1.
  Intro X. Case X; First [ Intros X1 X2; Exact (rem_295 epsilon_m__aux_39_p__aux_50 X1 X2)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_297 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_31 _big_x2) -> (auto___aux_20 _big_x3) -> (auto___aux_39 _big_x1) -> (auto___aux_50 _big_x1). (* Split. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3.
  Cut (auto___aux_39 _big_x1) -> (auto___aux_50 _big_x1). Tauto.
  Exact (rem_296 _big_x1).
Defined.

Remark rem_298 : ((X:extterm)(auto___aux_22 X) -> (auto___aux_50 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_24 _big_x1) -> (auto___aux_25 _big_x2) -> (auto___aux_50 (ext_key _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_50_key_2; Assumption. Defined.

Remark rem_299 : (X1,X2:extterm)(auto___aux_22 (ext_key X1 X2)) -> (or_1
    ((auto___aux_24 X1) /\ (auto___aux_25 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_300 : ((X:extterm)(auto___aux_22 X) -> (auto___aux_50 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_22 (ext_key _big_x1 _big_x2)) -> (auto___aux_50 (ext_key _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_m__aux_22_p__aux_50. Intros _big_x1 _big_x2. Intro H.
  Elim (rem_299 _big_x1 _big_x2 H); Intros.
  Apply (rem_298 epsilon_m__aux_22_p__aux_50 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_301 : (_big_x1:extterm)(auto___aux_22 _big_x1) -> (auto___aux_50 _big_x1). (* Induct. *)
Proof.
   Fix epsilon_m__aux_22_p__aux_50 1.
  Intro X. Case X; First [ Intros X1 X2; Exact (rem_300 epsilon_m__aux_22_p__aux_50 X1 X2)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_302 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_31 _big_x2) -> (auto___aux_20 _big_x3) -> (auto___aux_22 _big_x1) -> (auto___aux_50 _big_x1). (* Split. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3.
  Cut (auto___aux_22 _big_x1) -> (auto___aux_50 _big_x1). Tauto.
  Exact (rem_301 _big_x1).
Defined.

Remark rem_303 : (X1,X2,X3:extterm)(auto___aux_48 (ext___tuple____aux_48 X1 X2 X3)) -> (or_2
    ((auto___aux_31 X1) /\ (auto___aux_20 X2) /\ (auto___aux_39 X3))
    ((auto___aux_31 X1) /\ (auto___aux_20 X2) /\ (auto___aux_22 X3))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_2_intro_1; Tauto.
  Intros. Apply or_2_intro_2; Tauto.
Qed.

Remark rem_304 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_48 (ext___tuple____aux_48 _big_x2 _big_x3 _big_x1)) -> (auto___aux_50 _big_x1). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_303 _big_x2 _big_x3 _big_x1 H); Intros.
  Apply (rem_297 _big_x1 _big_x2 _big_x3); Tauto.
  Apply (rem_302 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_305 : (_big_x1,_big_x2:extterm)(auto___aux_19 _big_x2) -> (auto___aux_18 _big_x1) -> (auto___aux_16 (ext_cons _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_16_cons_1; Assumption. Defined.

Remark rem_306 : (_big_x1,_big_x2:extterm)(auto___aux_14 _big_x2) -> (auto___aux_7 _big_x1) -> (auto___aux_13 (ext_cons _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_13_cons_1; Assumption. Defined.

Remark rem_307 : (_big_x1,_big_x2:extterm)(auto___aux_33 _big_x2) -> (auto___aux_31 _big_x1) -> (auto___aux_35 (ext_cons _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_35_cons_1; Assumption. Defined.

Remark rem_308 : (auto___aux_53 ext_pub). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_53_pub_1; Assumption. Defined.

Remark rem_309 : (_big_x1,_big_x2:extterm)(auto___aux_12 _big_x2) -> (auto___aux_9 _big_x1) -> (auto___aux_14 (ext_cons _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_14_cons_1; Assumption. Defined.

Remark rem_310 : ((X:extterm)(auto_knows X) -> (auto___aux_20 X)) -> (_big_x1:extterm)(auto_knows _big_x1) -> (auto___aux_20 (ext_s _big_x1)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_20_s_1; Assumption. Defined.

Remark rem_311 : ((X:extterm)(auto_knows X) -> (auto___aux_20 X)) -> (_big_x1:extterm)(auto_knows (ext_s _big_x1)) -> (auto___aux_20 (ext_s _big_x1)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_p__aux_20. Intros _big_x1. Intro H.
  Elim (rem_49 _big_x1 H); Intros.
  Apply (rem_310 epsilon_mknows_p__aux_20 _big_x1); Tauto.
Defined.

Remark rem_312 : ((X:extterm)(auto_knows X) -> (auto___aux_20 X)) -> (auto_knows ext_nil) -> (auto___aux_20 ext_nil). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_20_nil_1; Assumption. Defined.

Remark rem_313 : ((X:extterm)(auto_knows X) -> (auto___aux_20 X)) -> (auto_knows ext_intruder) -> (auto___aux_20 ext_intruder). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_20_intruder_1; Assumption. Defined.

Remark rem_314 : ((X:extterm)(auto_knows X) -> (auto___aux_20 X)) -> (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_39 _big_x1) -> (auto___aux_31 _big_x2) -> (auto___aux_20 _big_x3) -> (auto___aux_20 (ext_nonceb _big_x1 _big_x2 _big_x3)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_20_nonceb_1; Assumption. Defined.

Remark rem_315 : ((X:extterm)(auto_knows X) -> (auto___aux_20 X)) -> (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_22 _big_x1) -> (auto___aux_31 _big_x2) -> (auto___aux_20 _big_x3) -> (auto___aux_20 (ext_nonceb _big_x1 _big_x2 _big_x3)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_20_nonceb_2; Assumption. Defined.

Remark rem_316 : ((X:extterm)(auto_knows X) -> (auto___aux_20 X)) -> (_big_x1,_big_x2,_big_x3:extterm)(auto_knows (ext_nonceb _big_x1 _big_x2 _big_x3)) -> (auto___aux_20 (ext_nonceb _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_p__aux_20. Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_62 _big_x1 _big_x2 _big_x3 H); Intros.
  Apply (rem_314 epsilon_mknows_p__aux_20 _big_x1 _big_x2 _big_x3); Tauto.
  Apply (rem_315 epsilon_mknows_p__aux_20 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_317 : ((X:extterm)(auto_knows X) -> (auto___aux_20 X)) -> (auto_knows ext_alice) -> (auto___aux_20 ext_alice). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_20_alice_1; Assumption. Defined.

Remark rem_318 : ((X:extterm)(auto_knows X) -> (auto___aux_20 X)) -> (auto_knows ext_server) -> (auto___aux_20 ext_server). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_20_server_1; Assumption. Defined.

Remark rem_319 : ((X:extterm)(auto_knows X) -> (auto___aux_20 X)) -> (_big_x1,_big_x2:extterm)(auto_knows _big_x1) -> (auto_knows _big_x2) -> (auto___aux_20 (ext_cons _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_20_cons_1; Assumption. Defined.

Remark rem_320 : ((X:extterm)(auto_knows X) -> (auto___aux_20 X)) -> (_big_x1,_big_x2:extterm)(auto_knows (ext_cons _big_x1 _big_x2)) -> (auto___aux_20 (ext_cons _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_p__aux_20. Intros _big_x1 _big_x2. Intro H.
  Elim (rem_74 _big_x1 _big_x2 H); Intros.
  Apply (rem_319 epsilon_mknows_p__aux_20 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_321 : ((X:extterm)(auto_knows X) -> (auto___aux_20 X)) -> (_big_x1:extterm)(auto___aux_13 _big_x1) -> (auto___aux_20 (ext_noncea _big_x1)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_20_noncea_1; Assumption. Defined.

Remark rem_322 : ((X:extterm)(auto_knows X) -> (auto___aux_20 X)) -> (_big_x1:extterm)(auto_knows (ext_noncea _big_x1)) -> (auto___aux_20 (ext_noncea _big_x1)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_p__aux_20. Intros _big_x1. Intro H.
  Elim (rem_78 _big_x1 H); Intros.
  Apply (rem_321 epsilon_mknows_p__aux_20 _big_x1); Tauto.
Defined.

Remark rem_323 : ((X:extterm)(auto_knows X) -> (auto___aux_20 X)) -> (auto_knows ext_bob) -> (auto___aux_20 ext_bob). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_20_bob_1; Assumption. Defined.

Remark rem_324 : ((X:extterm)(auto_knows X) -> (auto___aux_20 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_16 _big_x1) -> (auto___aux_17 _big_x2) -> (auto___aux_20 (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_20_crypt_1; Assumption. Defined.

Remark rem_325 : ((X:extterm)(auto_knows X) -> (auto___aux_20 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_43 _big_x1) -> (auto___aux_29 _big_x2) -> (auto___aux_20 (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_20_crypt_2; Assumption. Defined.

Remark rem_326 : ((X:extterm)(auto_knows X) -> (auto___aux_20 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_51 _big_x1) -> (auto___aux_52 _big_x2) -> (auto___aux_20 (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_20_crypt_3; Assumption. Defined.

Remark rem_327 : ((X:extterm)(auto_knows X) -> (auto___aux_20 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_49 _big_x1) -> (auto___aux_50 _big_x2) -> (auto___aux_20 (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_20_crypt_4; Assumption. Defined.

Remark rem_328 : ((X:extterm)(auto_knows X) -> (auto___aux_20 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_28 _big_x1) -> (auto___aux_29 _big_x2) -> (auto___aux_20 (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_20_crypt_5; Assumption. Defined.

Remark rem_329 : ((X:extterm)(auto_knows X) -> (auto___aux_20 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_36 _big_x1) -> (auto___aux_17 _big_x2) -> (auto___aux_20 (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_20_crypt_6; Assumption. Defined.

Remark rem_330 : ((X:extterm)(auto_knows X) -> (auto___aux_20 X)) -> (_big_x1,_big_x2:extterm)(auto_knows _big_x1) -> (auto_knows _big_x2) -> (auto___aux_20 (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_20_crypt_7; Assumption. Defined.

Remark rem_331 : ((X:extterm)(auto_knows X) -> (auto___aux_20 X)) -> (_big_x1,_big_x2:extterm)(auto_knows (ext_crypt _big_x1 _big_x2)) -> (auto___aux_20 (ext_crypt _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_p__aux_20. Intros _big_x1 _big_x2. Intro H.
  Elim (rem_92 _big_x1 _big_x2 H); Intros.
  Apply (rem_324 epsilon_mknows_p__aux_20 _big_x1 _big_x2); Tauto.
  Apply (rem_325 epsilon_mknows_p__aux_20 _big_x1 _big_x2); Tauto.
  Apply (rem_326 epsilon_mknows_p__aux_20 _big_x1 _big_x2); Tauto.
  Apply (rem_327 epsilon_mknows_p__aux_20 _big_x1 _big_x2); Tauto.
  Apply (rem_328 epsilon_mknows_p__aux_20 _big_x1 _big_x2); Tauto.
  Apply (rem_329 epsilon_mknows_p__aux_20 _big_x1 _big_x2); Tauto.
  Apply (rem_330 epsilon_mknows_p__aux_20 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_332 : ((X:extterm)(auto_knows X) -> (auto___aux_20 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_55 _big_x1) -> (auto___aux_56 _big_x2) -> (auto___aux_20 (ext_key _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_20_key_1; Assumption. Defined.

Remark rem_333 : ((X:extterm)(auto_knows X) -> (auto___aux_20 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_57 _big_x1) -> (auto___aux_58 _big_x2) -> (auto___aux_20 (ext_key _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_20_key_2; Assumption. Defined.

Remark rem_334 : ((X:extterm)(auto_knows X) -> (auto___aux_20 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_53 _big_x1) -> (auto___aux_54 _big_x2) -> (auto___aux_20 (ext_key _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_20_key_3; Assumption. Defined.

Remark rem_335 : ((X:extterm)(auto_knows X) -> (auto___aux_20 X)) -> (_big_x1,_big_x2:extterm)(auto_knows (ext_key _big_x1 _big_x2)) -> (auto___aux_20 (ext_key _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_p__aux_20. Intros _big_x1 _big_x2. Intro H.
  Elim (rem_115 _big_x1 _big_x2 H); Intros.
  Apply (rem_332 epsilon_mknows_p__aux_20 _big_x1 _big_x2); Tauto.
  Apply (rem_333 epsilon_mknows_p__aux_20 _big_x1 _big_x2); Tauto.
  Apply (rem_334 epsilon_mknows_p__aux_20 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_336 : (_big_x1:extterm)(auto_knows _big_x1) -> (auto___aux_20 _big_x1). (* Induct. *)
Proof.
   Fix epsilon_mknows_p__aux_20 1.
  Intro X. Case X; First [ Intros X1; Exact (rem_311 epsilon_mknows_p__aux_20 X1)
  | Exact (rem_312 epsilon_mknows_p__aux_20 )
  | Exact (rem_313 epsilon_mknows_p__aux_20 )
  |  Intros X1 X2 X3; Exact (rem_316 epsilon_mknows_p__aux_20 X1 X2 X3)
  | Exact (rem_317 epsilon_mknows_p__aux_20 )
  | Exact (rem_318 epsilon_mknows_p__aux_20 )
  |  Intros X1 X2; Exact (rem_320 epsilon_mknows_p__aux_20 X1 X2)
  |  Intros X1; Exact (rem_322 epsilon_mknows_p__aux_20 X1)
  | Exact (rem_323 epsilon_mknows_p__aux_20 )
  |  Intros X1 X2; Exact (rem_331 epsilon_mknows_p__aux_20 X1 X2)
  |  Intros X1 X2; Exact (rem_335 epsilon_mknows_p__aux_20 X1 X2)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_337 : (_big_x1,_big_x2,_big_x3:extterm)(auto_knows _big_x2) -> (auto_knows _big_x1) -> (auto_knows _big_x3) -> (auto___aux_20 _big_x1). (* Split. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3.
  Cut (auto_knows _big_x1) -> (auto___aux_20 _big_x1). Tauto.
  Exact (rem_336 _big_x1).
Defined.

Remark rem_338 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_15 (ext___tuple____aux_15 _big_x2 _big_x1 _big_x3)) -> (auto___aux_20 _big_x1). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_248 _big_x2 _big_x1 _big_x3 H); Intros.
  Apply (rem_337 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_339 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto_knows _big_x2) -> (auto_knows _big_x1) -> (auto_knows _big_x3) -> (auto___aux_24 _big_x4) -> (auto___aux_26 _big_x5) -> (auto___aux_47 (ext_current_session _big_x1 _big_x2 _big_x3)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_47_current_session_1; Assumption. Defined.

Remark rem_340 : (X1,X2,X3,X4,X5:extterm)(auto___aux_45 (ext___tuple____aux_45 X1 X2 X3 X4 X5)) -> (or_1
    ((auto_knows X1) /\ (auto_knows X2) /\ (auto_knows X3) /\ (auto___aux_24 X4) /\ (auto___aux_26 X5))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_341 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_45 (ext___tuple____aux_45 _big_x2 _big_x1 _big_x3 _big_x4 _big_x5)) -> (auto___aux_47 (ext_current_session _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_340 _big_x2 _big_x1 _big_x3 _big_x4 _big_x5 H); Intros.
  Apply (rem_339 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_342 : (_big_x1,_big_x2:extterm)(auto___aux_32 _big_x2) -> (auto___aux_24 _big_x1) -> (auto___aux_29 (ext_key _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_29_key_1; Assumption. Defined.

Remark rem_343 : (auto___aux_34 ext_server). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_34_server_1; Assumption. Defined.

Remark rem_344 : (_big_x1,_big_x2:extterm)(auto___aux_25 _big_x2) -> (auto___aux_24 _big_x1) -> (auto___aux_22 (ext_key _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_22_key_1; Assumption. Defined.

Remark rem_345 : (_big_x1,_big_x2:extterm)(auto___aux_27 _big_x2) -> (auto___aux_42 _big_x1) -> (auto___aux_40 (ext_cons _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_40_cons_1; Assumption. Defined.

Remark rem_346 : (auto___aux_55 ext_prv). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_55_prv_1; Assumption. Defined.

Remark rem_347 : ((X:extterm)(auto___aux_24 X) -> (auto___aux_46 X)) -> (auto___aux_24 ext_sym) -> (auto___aux_46 ext_sym). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_46_sym_1; Assumption. Defined.

Remark rem_348 : (_big_x1:extterm)(auto___aux_24 _big_x1) -> (auto___aux_46 _big_x1). (* Induct. *)
Proof.
   Fix epsilon_m__aux_24_p__aux_46 1.
  Intro X. Case X; First [Exact (rem_347 epsilon_m__aux_24_p__aux_46 )
  |  Intros until 1; Inversion H].
Defined.

Remark rem_349 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto_knows _big_x2) -> (auto_knows _big_x3) -> (auto_knows _big_x4) -> (auto___aux_24 _big_x1) -> (auto___aux_26 _big_x5) -> (auto___aux_46 _big_x1). (* Split. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5.
  Cut (auto___aux_24 _big_x1) -> (auto___aux_46 _big_x1). Tauto.
  Exact (rem_348 _big_x1).
Defined.

Remark rem_350 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_45 (ext___tuple____aux_45 _big_x2 _big_x3 _big_x4 _big_x1 _big_x5)) -> (auto___aux_46 _big_x1). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_340 _big_x2 _big_x3 _big_x4 _big_x1 _big_x5 H); Intros.
  Apply (rem_349 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_351 : (_big_x1,_big_x2:extterm)(auto___aux_30 _big_x2) -> (auto___aux_22 _big_x1) -> (auto___aux_28 (ext_cons _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_28_cons_1; Assumption. Defined.

Remark rem_352 : (auto___aux_24 ext_prv) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_353 : (_big_x1,_big_x2:extterm)(auto___aux_24 ext_prv) -> (auto___aux_35 _big_x1) -> (auto___aux_16 _big_x2) -> (auto___aux_4 (ext___tuple____aux_4 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_352 H); Intros.
Defined.

Remark rem_354 : (_big_x1,_big_x2:extterm)(auto___aux_16 _big_x2) -> (auto___aux_17 (ext_key ext_prv _big_x1)) -> (auto___aux_4 (ext___tuple____aux_4 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros H1. Intro H.
  Elim (rem_18 ext_prv _big_x1 H); Intros.
  Apply (rem_353 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_355 : (_big_x1,_big_x2:extterm)(auto___aux_24 ext_prv) -> (auto___aux_32 _big_x1) -> (auto___aux_43 _big_x2) -> (auto___aux_4 (ext___tuple____aux_4 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_352 H); Intros.
Defined.

Remark rem_356 : (_big_x1,_big_x2:extterm)(auto___aux_43 _big_x2) -> (auto___aux_29 (ext_key ext_prv _big_x1)) -> (auto___aux_4 (ext___tuple____aux_4 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros H1. Intro H.
  Elim (rem_31 ext_prv _big_x1 H); Intros.
  Apply (rem_355 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_357 : (_big_x1,_big_x2:extterm)(auto___aux_24 ext_prv) -> (auto___aux_46 ext_prv) -> (auto___aux_25 _big_x1) -> (auto___aux_47 _big_x1) -> (auto___aux_51 _big_x2) -> (auto___aux_4 (ext___tuple____aux_4 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_352 H); Intros.
Defined.

Remark rem_358 : (_big_x1,_big_x2:extterm)(auto___aux_51 _big_x2) -> (auto___aux_52 (ext_key ext_prv _big_x1)) -> (auto___aux_4 (ext___tuple____aux_4 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros H1. Intro H.
  Elim (rem_256 ext_prv _big_x1 H); Intros.
  Apply (rem_357 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_359 : (_big_x1,_big_x2:extterm)(auto___aux_24 ext_prv) -> (auto___aux_41 _big_x1) -> (auto___aux_49 _big_x2) -> (auto___aux_4 (ext___tuple____aux_4 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_352 H); Intros.
Defined.

Remark rem_360 : (_big_x1,_big_x2:extterm)(auto___aux_24 ext_prv) -> (auto___aux_25 _big_x1) -> (auto___aux_49 _big_x2) -> (auto___aux_4 (ext___tuple____aux_4 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_352 H); Intros.
Defined.

Remark rem_361 : (_big_x1,_big_x2:extterm)(auto___aux_49 _big_x2) -> (auto___aux_50 (ext_key ext_prv _big_x1)) -> (auto___aux_4 (ext___tuple____aux_4 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros H1. Intro H.
  Elim (rem_260 ext_prv _big_x1 H); Intros.
  Apply (rem_359 _big_x1 _big_x2); Tauto.
  Apply (rem_360 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_362 : (_big_x1,_big_x2:extterm)(auto___aux_24 ext_prv) -> (auto___aux_32 _big_x1) -> (auto___aux_28 _big_x2) -> (auto___aux_4 (ext___tuple____aux_4 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_352 H); Intros.
Defined.

Remark rem_363 : (_big_x1,_big_x2:extterm)(auto___aux_28 _big_x2) -> (auto___aux_29 (ext_key ext_prv _big_x1)) -> (auto___aux_4 (ext___tuple____aux_4 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros H1. Intro H.
  Elim (rem_31 ext_prv _big_x1 H); Intros.
  Apply (rem_362 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_364 : (_big_x1,_big_x2:extterm)(auto___aux_24 ext_prv) -> (auto___aux_35 _big_x1) -> (auto___aux_36 _big_x2) -> (auto___aux_4 (ext___tuple____aux_4 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_352 H); Intros.
Defined.

Remark rem_365 : (_big_x1,_big_x2:extterm)(auto___aux_36 _big_x2) -> (auto___aux_17 (ext_key ext_prv _big_x1)) -> (auto___aux_4 (ext___tuple____aux_4 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros H1. Intro H.
  Elim (rem_18 ext_prv _big_x1 H); Intros.
  Apply (rem_364 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_366 : (_big_x1,_big_x2:extterm)(auto___aux_55 ext_prv) -> (auto___aux_56 _big_x1) -> (auto_knows _big_x2) -> (auto___aux_4 (ext___tuple____aux_4 _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_4___tuple____aux_4_1; Assumption. Defined.

Remark rem_367 : (_big_x1,_big_x2:extterm)(auto___aux_57 ext_prv) -> (auto___aux_58 _big_x1) -> (auto_knows _big_x2) -> (auto___aux_4 (ext___tuple____aux_4 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_285 H); Intros.
Defined.

Remark rem_368 : (_big_x1,_big_x2:extterm)(auto___aux_53 ext_prv) -> (auto_knows _big_x2) -> (auto___aux_4 (ext___tuple____aux_4 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_287 H); Intros.
Defined.

Remark rem_369 : (_big_x1,_big_x2:extterm)(auto___aux_53 ext_prv) -> (auto___aux_54 _big_x1) -> (auto_knows _big_x2) -> (auto___aux_4 (ext___tuple____aux_4 _big_x1 _big_x2)). (* Eliminate negative atom by universal clause. *)
Proof.
   Intros _big_x1 _big_x2. Intros. Apply (rem_368 _big_x1 _big_x2); Assumption.
Defined.

Remark rem_370 : (_big_x1,_big_x2:extterm)(auto_knows _big_x2) -> (auto_knows (ext_key ext_prv _big_x1)) -> (auto___aux_4 (ext___tuple____aux_4 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros H1. Intro H.
  Elim (rem_115 ext_prv _big_x1 H); Intros.
  Apply (rem_366 _big_x1 _big_x2); Tauto.
  Apply (rem_367 _big_x1 _big_x2); Tauto.
  Apply (rem_369 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_371 : (_big_x1,_big_x2:extterm)(auto_knows (ext_crypt _big_x2 (ext_key ext_prv _big_x1))) -> (auto___aux_4 (ext___tuple____aux_4 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_92 _big_x2 (ext_key ext_prv _big_x1) H); Intros.
  Apply (rem_354 _big_x1 _big_x2); Tauto.
  Apply (rem_356 _big_x1 _big_x2); Tauto.
  Apply (rem_358 _big_x1 _big_x2); Tauto.
  Apply (rem_361 _big_x1 _big_x2); Tauto.
  Apply (rem_363 _big_x1 _big_x2); Tauto.
  Apply (rem_365 _big_x1 _big_x2); Tauto.
  Apply (rem_370 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_372 : (_big_x1,_big_x2,_big_x3:extterm)(auto_knows _big_x1) -> (auto_knows _big_x2) -> (auto_knows _big_x3) -> (auto___aux_25 (ext_current_session _big_x1 _big_x2 _big_x3)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_25_current_session_1; Assumption. Defined.

Remark rem_373 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_15 (ext___tuple____aux_15 _big_x1 _big_x2 _big_x3)) -> (auto___aux_25 (ext_current_session _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_248 _big_x1 _big_x2 _big_x3 H); Intros.
  Apply (rem_372 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_374 : ((X:extterm)(auto___aux_46 X) -> (auto___aux_24 X)) -> ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> (auto___aux_46 ext_sym) -> (auto___aux_24 ext_sym). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_24_sym_1; Assumption. Defined.

Remark rem_375 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> (_big_x1:extterm)(auto___aux_46 _big_x1) -> (auto___aux_24 _big_x1). (* Induct. *)
Proof.
   Intros epsilon_malice_key_p__aux_52. Fix epsilon_m__aux_46_p__aux_24 1.
  Intro X. Case X; First [Exact (rem_374 epsilon_m__aux_46_p__aux_24 epsilon_malice_key_p__aux_52 )
  |  Intros until 1; Inversion H].
Defined.

Remark rem_376 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> ((X:extterm)(auto___aux_47 X) -> (auto___aux_25 X)) -> (_big_x1,_big_x2,_big_x3:extterm)(auto_knows _big_x1) -> (auto_knows _big_x2) -> (auto_knows _big_x3) -> (auto___aux_25 (ext_current_session _big_x1 _big_x2 _big_x3)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_25_current_session_1; Assumption. Defined.

Remark rem_377 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> ((X:extterm)(auto___aux_47 X) -> (auto___aux_25 X)) -> (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_47 (ext_current_session _big_x1 _big_x2 _big_x3)) -> (auto___aux_25 (ext_current_session _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_malice_key_p__aux_52 epsilon_m__aux_47_p__aux_25. Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_26 _big_x1 _big_x2 _big_x3 H); Intros.
  Apply (rem_376 epsilon_malice_key_p__aux_52 epsilon_m__aux_47_p__aux_25 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_378 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> (_big_x2:extterm)(auto___aux_47 _big_x2) -> (auto___aux_25 _big_x2). (* Induct. *)
Proof.
   Intros epsilon_malice_key_p__aux_52. Fix epsilon_m__aux_47_p__aux_25 1.
  Intro X. Case X; First [ Intros X1 X2 X3; Exact (rem_377 epsilon_malice_key_p__aux_52 epsilon_m__aux_47_p__aux_25 X1 X2 X3)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_379 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_46 _big_x1) -> (auto___aux_47 _big_x2) -> ((auto___aux_24 _big_x1) /\ (auto___aux_46 _big_x1) /\ (auto___aux_25 _big_x2) /\ (auto___aux_47 _big_x2)) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
   Intros epsilon_malice_key_p__aux_52. Intros _big_x1 _big_x2. Intros A1 A2.
  Cut (auto___aux_24 _big_x1). 2:Apply (rem_375 epsilon_malice_key_p__aux_52 _big_x1); Assumption.
  Cut (auto___aux_25 _big_x2). 2:Apply (rem_378 epsilon_malice_key_p__aux_52 _big_x2); Assumption.
  Tauto.
Defined.

Remark rem_380 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_46 _big_x1) -> (auto___aux_47 _big_x2) -> (auto___aux_52 (ext_key _big_x1 _big_x2)). (* Deduce positive atom. *)
Proof.
   Intros epsilon_malice_key_p__aux_52. Intros _big_x1 _big_x2. Intros A1 A2.
  Case (rem_379 epsilon_malice_key_p__aux_52 _big_x1 _big_x2 A1 A2). Clear epsilon_malice_key_p__aux_52 A1 A2. Intros. Apply trans___aux_52_key_1; Tauto.
  Clear epsilon_malice_key_p__aux_52 A1 A2. Tauto.
Defined.

Remark rem_381 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> (_big_x1,_big_x2:extterm)(auto_alice_key (ext_key _big_x1 _big_x2)) -> (auto___aux_52 (ext_key _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_malice_key_p__aux_52. Intros _big_x1 _big_x2. Intro H.
  Elim (rem_16 _big_x1 _big_x2 H); Intros.
  Apply (rem_380 epsilon_malice_key_p__aux_52 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_382 : (_big_x1:extterm)(auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). (* Induct. *)
Proof.
   Fix epsilon_malice_key_p__aux_52 1.
  Intro X. Case X; First [ Intros X1 X2; Exact (rem_381 epsilon_malice_key_p__aux_52 X1 X2)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_383 : (_big_x1:extterm)(auto___aux_17 _big_x1) -> (auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). (* Subsumption by simpler clause. *)
Proof.
   Intros _big_x1.
  Cut (auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). Tauto. Exact (rem_382 _big_x1).
Defined.

Remark rem_384 : (_big_x1,_big_x2:extterm)(auto___aux_16 _big_x2) -> (auto___aux_17 _big_x1) -> (auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). (* Split. *)
Proof.
   Intros _big_x1 _big_x2.
  Cut (auto___aux_17 _big_x1) -> (auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). Tauto.
  Exact (rem_383 _big_x1).
Defined.

Remark rem_385 : ((X:extterm)(auto___aux_46 X) -> (auto___aux_24 X)) -> ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> (auto___aux_46 ext_sym) -> (auto___aux_24 ext_sym). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_24_sym_1; Assumption. Defined.

Remark rem_386 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> (_big_x1:extterm)(auto___aux_46 _big_x1) -> (auto___aux_24 _big_x1). (* Induct. *)
Proof.
   Intros epsilon_malice_key_p__aux_52. Fix epsilon_m__aux_46_p__aux_24 1.
  Intro X. Case X; First [Exact (rem_385 epsilon_m__aux_46_p__aux_24 epsilon_malice_key_p__aux_52 )
  |  Intros until 1; Inversion H].
Defined.

Remark rem_387 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> ((X:extterm)(auto___aux_47 X) -> (auto___aux_25 X)) -> (_big_x1,_big_x2,_big_x3:extterm)(auto_knows _big_x1) -> (auto_knows _big_x2) -> (auto_knows _big_x3) -> (auto___aux_25 (ext_current_session _big_x1 _big_x2 _big_x3)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_25_current_session_1; Assumption. Defined.

Remark rem_388 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> ((X:extterm)(auto___aux_47 X) -> (auto___aux_25 X)) -> (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_47 (ext_current_session _big_x1 _big_x2 _big_x3)) -> (auto___aux_25 (ext_current_session _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_malice_key_p__aux_52 epsilon_m__aux_47_p__aux_25. Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_26 _big_x1 _big_x2 _big_x3 H); Intros.
  Apply (rem_387 epsilon_malice_key_p__aux_52 epsilon_m__aux_47_p__aux_25 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_389 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> (_big_x2:extterm)(auto___aux_47 _big_x2) -> (auto___aux_25 _big_x2). (* Induct. *)
Proof.
   Intros epsilon_malice_key_p__aux_52. Fix epsilon_m__aux_47_p__aux_25 1.
  Intro X. Case X; First [ Intros X1 X2 X3; Exact (rem_388 epsilon_malice_key_p__aux_52 epsilon_m__aux_47_p__aux_25 X1 X2 X3)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_390 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_46 _big_x1) -> (auto___aux_47 _big_x2) -> ((auto___aux_24 _big_x1) /\ (auto___aux_46 _big_x1) /\ (auto___aux_25 _big_x2) /\ (auto___aux_47 _big_x2)) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
   Intros epsilon_malice_key_p__aux_52. Intros _big_x1 _big_x2. Intros A1 A2.
  Cut (auto___aux_24 _big_x1). 2:Apply (rem_386 epsilon_malice_key_p__aux_52 _big_x1); Assumption.
  Cut (auto___aux_25 _big_x2). 2:Apply (rem_389 epsilon_malice_key_p__aux_52 _big_x2); Assumption.
  Tauto.
Defined.

Remark rem_391 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_46 _big_x1) -> (auto___aux_47 _big_x2) -> (auto___aux_52 (ext_key _big_x1 _big_x2)). (* Deduce positive atom. *)
Proof.
   Intros epsilon_malice_key_p__aux_52. Intros _big_x1 _big_x2. Intros A1 A2.
  Case (rem_390 epsilon_malice_key_p__aux_52 _big_x1 _big_x2 A1 A2). Clear epsilon_malice_key_p__aux_52 A1 A2. Intros. Apply trans___aux_52_key_1; Tauto.
  Clear epsilon_malice_key_p__aux_52 A1 A2. Tauto.
Defined.

Remark rem_392 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> (_big_x1,_big_x2:extterm)(auto_alice_key (ext_key _big_x1 _big_x2)) -> (auto___aux_52 (ext_key _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_malice_key_p__aux_52. Intros _big_x1 _big_x2. Intro H.
  Elim (rem_16 _big_x1 _big_x2 H); Intros.
  Apply (rem_391 epsilon_malice_key_p__aux_52 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_393 : (_big_x1:extterm)(auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). (* Induct. *)
Proof.
   Fix epsilon_malice_key_p__aux_52 1.
  Intro X. Case X; First [ Intros X1 X2; Exact (rem_392 epsilon_malice_key_p__aux_52 X1 X2)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_394 : (_big_x1:extterm)(auto___aux_29 _big_x1) -> (auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). (* Subsumption by simpler clause. *)
Proof.
   Intros _big_x1.
  Cut (auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). Tauto. Exact (rem_393 _big_x1).
Defined.

Remark rem_395 : (_big_x1,_big_x2:extterm)(auto___aux_43 _big_x2) -> (auto___aux_29 _big_x1) -> (auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). (* Split. *)
Proof.
   Intros _big_x1 _big_x2.
  Cut (auto___aux_29 _big_x1) -> (auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). Tauto.
  Exact (rem_394 _big_x1).
Defined.

Remark rem_396 : (_big_x1,_big_x2:extterm)(auto___aux_51 _big_x2) -> (auto___aux_52 _big_x1) -> (auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). (* Tautology. *)
Proof. Tauto. Defined.

Remark rem_397 : ((X:extterm)(auto___aux_46 X) -> (auto___aux_24 X)) -> ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> (auto___aux_46 ext_sym) -> (auto___aux_24 ext_sym). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_24_sym_1; Assumption. Defined.

Remark rem_398 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> (_big_x1:extterm)(auto___aux_46 _big_x1) -> (auto___aux_24 _big_x1). (* Induct. *)
Proof.
   Intros epsilon_malice_key_p__aux_52. Fix epsilon_m__aux_46_p__aux_24 1.
  Intro X. Case X; First [Exact (rem_397 epsilon_m__aux_46_p__aux_24 epsilon_malice_key_p__aux_52 )
  |  Intros until 1; Inversion H].
Defined.

Remark rem_399 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> ((X:extterm)(auto___aux_47 X) -> (auto___aux_25 X)) -> (_big_x1,_big_x2,_big_x3:extterm)(auto_knows _big_x1) -> (auto_knows _big_x2) -> (auto_knows _big_x3) -> (auto___aux_25 (ext_current_session _big_x1 _big_x2 _big_x3)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_25_current_session_1; Assumption. Defined.

Remark rem_400 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> ((X:extterm)(auto___aux_47 X) -> (auto___aux_25 X)) -> (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_47 (ext_current_session _big_x1 _big_x2 _big_x3)) -> (auto___aux_25 (ext_current_session _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_malice_key_p__aux_52 epsilon_m__aux_47_p__aux_25. Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_26 _big_x1 _big_x2 _big_x3 H); Intros.
  Apply (rem_399 epsilon_malice_key_p__aux_52 epsilon_m__aux_47_p__aux_25 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_401 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> (_big_x2:extterm)(auto___aux_47 _big_x2) -> (auto___aux_25 _big_x2). (* Induct. *)
Proof.
   Intros epsilon_malice_key_p__aux_52. Fix epsilon_m__aux_47_p__aux_25 1.
  Intro X. Case X; First [ Intros X1 X2 X3; Exact (rem_400 epsilon_malice_key_p__aux_52 epsilon_m__aux_47_p__aux_25 X1 X2 X3)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_402 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_46 _big_x1) -> (auto___aux_47 _big_x2) -> ((auto___aux_24 _big_x1) /\ (auto___aux_46 _big_x1) /\ (auto___aux_25 _big_x2) /\ (auto___aux_47 _big_x2)) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
   Intros epsilon_malice_key_p__aux_52. Intros _big_x1 _big_x2. Intros A1 A2.
  Cut (auto___aux_24 _big_x1). 2:Apply (rem_398 epsilon_malice_key_p__aux_52 _big_x1); Assumption.
  Cut (auto___aux_25 _big_x2). 2:Apply (rem_401 epsilon_malice_key_p__aux_52 _big_x2); Assumption.
  Tauto.
Defined.

Remark rem_403 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_46 _big_x1) -> (auto___aux_47 _big_x2) -> (auto___aux_52 (ext_key _big_x1 _big_x2)). (* Deduce positive atom. *)
Proof.
   Intros epsilon_malice_key_p__aux_52. Intros _big_x1 _big_x2. Intros A1 A2.
  Case (rem_402 epsilon_malice_key_p__aux_52 _big_x1 _big_x2 A1 A2). Clear epsilon_malice_key_p__aux_52 A1 A2. Intros. Apply trans___aux_52_key_1; Tauto.
  Clear epsilon_malice_key_p__aux_52 A1 A2. Tauto.
Defined.

Remark rem_404 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> (_big_x1,_big_x2:extterm)(auto_alice_key (ext_key _big_x1 _big_x2)) -> (auto___aux_52 (ext_key _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_malice_key_p__aux_52. Intros _big_x1 _big_x2. Intro H.
  Elim (rem_16 _big_x1 _big_x2 H); Intros.
  Apply (rem_403 epsilon_malice_key_p__aux_52 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_405 : (_big_x1:extterm)(auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). (* Induct. *)
Proof.
   Fix epsilon_malice_key_p__aux_52 1.
  Intro X. Case X; First [ Intros X1 X2; Exact (rem_404 epsilon_malice_key_p__aux_52 X1 X2)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_406 : (_big_x1:extterm)(auto___aux_50 _big_x1) -> (auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). (* Subsumption by simpler clause. *)
Proof.
   Intros _big_x1.
  Cut (auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). Tauto. Exact (rem_405 _big_x1).
Defined.

Remark rem_407 : (_big_x1,_big_x2:extterm)(auto___aux_49 _big_x2) -> (auto___aux_50 _big_x1) -> (auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). (* Split. *)
Proof.
   Intros _big_x1 _big_x2.
  Cut (auto___aux_50 _big_x1) -> (auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). Tauto.
  Exact (rem_406 _big_x1).
Defined.

Remark rem_408 : (_big_x1:extterm)(auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). (* Induct. *)
Proof.
   Fix epsilon_malice_key_p__aux_52 1.
  Intro X. Case X; First [ Intros X1 X2; Exact (rem_404 epsilon_malice_key_p__aux_52 X1 X2)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_409 : (_big_x1:extterm)(auto___aux_29 _big_x1) -> (auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). (* Subsumption by simpler clause. *)
Proof.
   Intros _big_x1.
  Cut (auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). Tauto. Exact (rem_408 _big_x1).
Defined.

Remark rem_410 : (_big_x1,_big_x2:extterm)(auto___aux_28 _big_x2) -> (auto___aux_29 _big_x1) -> (auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). (* Split. *)
Proof.
   Intros _big_x1 _big_x2.
  Cut (auto___aux_29 _big_x1) -> (auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). Tauto.
  Exact (rem_409 _big_x1).
Defined.

Remark rem_411 : (_big_x1:extterm)(auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). (* Induct. *)
Proof.
   Fix epsilon_malice_key_p__aux_52 1.
  Intro X. Case X; First [ Intros X1 X2; Exact (rem_404 epsilon_malice_key_p__aux_52 X1 X2)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_412 : (_big_x1:extterm)(auto___aux_17 _big_x1) -> (auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). (* Subsumption by simpler clause. *)
Proof.
   Intros _big_x1.
  Cut (auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). Tauto. Exact (rem_411 _big_x1).
Defined.

Remark rem_413 : (_big_x1,_big_x2:extterm)(auto___aux_36 _big_x2) -> (auto___aux_17 _big_x1) -> (auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). (* Split. *)
Proof.
   Intros _big_x1 _big_x2.
  Cut (auto___aux_17 _big_x1) -> (auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). Tauto.
  Exact (rem_412 _big_x1).
Defined.

Remark rem_414 : ((X:extterm)(auto___aux_46 X) -> (auto___aux_24 X)) -> ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> (auto___aux_46 ext_sym) -> (auto___aux_24 ext_sym). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_24_sym_1; Assumption. Defined.

Remark rem_415 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> (_big_x1:extterm)(auto___aux_46 _big_x1) -> (auto___aux_24 _big_x1). (* Induct. *)
Proof.
   Intros epsilon_malice_key_p__aux_52. Fix epsilon_m__aux_46_p__aux_24 1.
  Intro X. Case X; First [Exact (rem_414 epsilon_m__aux_46_p__aux_24 epsilon_malice_key_p__aux_52 )
  |  Intros until 1; Inversion H].
Defined.

Remark rem_416 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> ((X:extterm)(auto___aux_47 X) -> (auto___aux_25 X)) -> (_big_x1,_big_x2,_big_x3:extterm)(auto_knows _big_x1) -> (auto_knows _big_x2) -> (auto_knows _big_x3) -> (auto___aux_25 (ext_current_session _big_x1 _big_x2 _big_x3)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_25_current_session_1; Assumption. Defined.

Remark rem_417 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> ((X:extterm)(auto___aux_47 X) -> (auto___aux_25 X)) -> (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_47 (ext_current_session _big_x1 _big_x2 _big_x3)) -> (auto___aux_25 (ext_current_session _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_malice_key_p__aux_52 epsilon_m__aux_47_p__aux_25. Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_26 _big_x1 _big_x2 _big_x3 H); Intros.
  Apply (rem_416 epsilon_malice_key_p__aux_52 epsilon_m__aux_47_p__aux_25 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_418 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> (_big_x2:extterm)(auto___aux_47 _big_x2) -> (auto___aux_25 _big_x2). (* Induct. *)
Proof.
   Intros epsilon_malice_key_p__aux_52. Fix epsilon_m__aux_47_p__aux_25 1.
  Intro X. Case X; First [ Intros X1 X2 X3; Exact (rem_417 epsilon_malice_key_p__aux_52 epsilon_m__aux_47_p__aux_25 X1 X2 X3)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_419 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_46 _big_x1) -> (auto___aux_47 _big_x2) -> ((auto___aux_24 _big_x1) /\ (auto___aux_46 _big_x1) /\ (auto___aux_25 _big_x2) /\ (auto___aux_47 _big_x2)) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
   Intros epsilon_malice_key_p__aux_52. Intros _big_x1 _big_x2. Intros A1 A2.
  Cut (auto___aux_24 _big_x1). 2:Apply (rem_415 epsilon_malice_key_p__aux_52 _big_x1); Assumption.
  Cut (auto___aux_25 _big_x2). 2:Apply (rem_418 epsilon_malice_key_p__aux_52 _big_x2); Assumption.
  Tauto.
Defined.

Remark rem_420 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_46 _big_x1) -> (auto___aux_47 _big_x2) -> (auto___aux_52 (ext_key _big_x1 _big_x2)). (* Deduce positive atom. *)
Proof.
   Intros epsilon_malice_key_p__aux_52. Intros _big_x1 _big_x2. Intros A1 A2.
  Case (rem_419 epsilon_malice_key_p__aux_52 _big_x1 _big_x2 A1 A2). Clear epsilon_malice_key_p__aux_52 A1 A2. Intros. Apply trans___aux_52_key_1; Tauto.
  Clear epsilon_malice_key_p__aux_52 A1 A2. Tauto.
Defined.

Remark rem_421 : ((X:extterm)(auto_alice_key X) -> (auto___aux_52 X)) -> (_big_x1,_big_x2:extterm)(auto_alice_key (ext_key _big_x1 _big_x2)) -> (auto___aux_52 (ext_key _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_malice_key_p__aux_52. Intros _big_x1 _big_x2. Intro H.
  Elim (rem_16 _big_x1 _big_x2 H); Intros.
  Apply (rem_420 epsilon_malice_key_p__aux_52 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_422 : (_big_x1:extterm)(auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). (* Induct. *)
Proof.
   Fix epsilon_malice_key_p__aux_52 1.
  Intro X. Case X; First [ Intros X1 X2; Exact (rem_421 epsilon_malice_key_p__aux_52 X1 X2)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_423 : (_big_x1:extterm)(auto_knows _big_x1) -> (auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). (* Subsumption by simpler clause. *)
Proof.
   Intros _big_x1.
  Cut (auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). Tauto. Exact (rem_422 _big_x1).
Defined.

Remark rem_424 : (_big_x1,_big_x2:extterm)(auto_knows _big_x2) -> (auto_knows _big_x1) -> (auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). (* Split. *)
Proof.
   Intros _big_x1 _big_x2.
  Cut (auto_knows _big_x1) -> (auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). Tauto.
  Exact (rem_423 _big_x1).
Defined.

Remark rem_425 : (_big_x1,_big_x2:extterm)(auto_knows (ext_crypt _big_x2 _big_x1)) -> (auto_alice_key _big_x1) -> (auto___aux_52 _big_x1). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_92 _big_x2 _big_x1 H); Intros.
  Apply (rem_384 _big_x1 _big_x2); Tauto.
  Apply (rem_395 _big_x1 _big_x2); Tauto.
  Apply (rem_396 _big_x1 _big_x2); Tauto.
  Apply (rem_407 _big_x1 _big_x2); Tauto.
  Apply (rem_410 _big_x1 _big_x2); Tauto.
  Apply (rem_413 _big_x1 _big_x2); Tauto.
  Apply (rem_424 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_426 : ((X:extterm)(auto_knows X) -> (auto___aux_31 X)) -> (_big_x1:extterm)(auto_knows _big_x1) -> (auto___aux_31 (ext_s _big_x1)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_31_s_1; Assumption. Defined.

Remark rem_427 : ((X:extterm)(auto_knows X) -> (auto___aux_31 X)) -> (_big_x1:extterm)(auto_knows (ext_s _big_x1)) -> (auto___aux_31 (ext_s _big_x1)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_p__aux_31. Intros _big_x1. Intro H.
  Elim (rem_49 _big_x1 H); Intros.
  Apply (rem_426 epsilon_mknows_p__aux_31 _big_x1); Tauto.
Defined.

Remark rem_428 : ((X:extterm)(auto_knows X) -> (auto___aux_31 X)) -> (auto_knows ext_nil) -> (auto___aux_31 ext_nil). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_31_nil_1; Assumption. Defined.

Remark rem_429 : ((X:extterm)(auto_knows X) -> (auto___aux_31 X)) -> (auto_knows ext_intruder) -> (auto___aux_31 ext_intruder). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_31_intruder_1; Assumption. Defined.

Remark rem_430 : ((X:extterm)(auto_knows X) -> (auto___aux_31 X)) -> (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_39 _big_x1) -> (auto___aux_31 _big_x2) -> (auto___aux_20 _big_x3) -> (auto___aux_31 (ext_nonceb _big_x1 _big_x2 _big_x3)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_31_nonceb_1; Assumption. Defined.

Remark rem_431 : ((X:extterm)(auto_knows X) -> (auto___aux_31 X)) -> (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_22 _big_x1) -> (auto___aux_31 _big_x2) -> (auto___aux_20 _big_x3) -> (auto___aux_31 (ext_nonceb _big_x1 _big_x2 _big_x3)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_31_nonceb_2; Assumption. Defined.

Remark rem_432 : ((X:extterm)(auto_knows X) -> (auto___aux_31 X)) -> (_big_x1,_big_x2,_big_x3:extterm)(auto_knows (ext_nonceb _big_x1 _big_x2 _big_x3)) -> (auto___aux_31 (ext_nonceb _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_p__aux_31. Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_62 _big_x1 _big_x2 _big_x3 H); Intros.
  Apply (rem_430 epsilon_mknows_p__aux_31 _big_x1 _big_x2 _big_x3); Tauto.
  Apply (rem_431 epsilon_mknows_p__aux_31 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_433 : ((X:extterm)(auto_knows X) -> (auto___aux_31 X)) -> (auto_knows ext_alice) -> (auto___aux_31 ext_alice). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_31_alice_1; Assumption. Defined.

Remark rem_434 : ((X:extterm)(auto_knows X) -> (auto___aux_31 X)) -> (auto_knows ext_server) -> (auto___aux_31 ext_server). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_31_server_1; Assumption. Defined.

Remark rem_435 : ((X:extterm)(auto_knows X) -> (auto___aux_31 X)) -> (_big_x1,_big_x2:extterm)(auto_knows _big_x1) -> (auto_knows _big_x2) -> (auto___aux_31 (ext_cons _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_31_cons_1; Assumption. Defined.

Remark rem_436 : ((X:extterm)(auto_knows X) -> (auto___aux_31 X)) -> (_big_x1,_big_x2:extterm)(auto_knows (ext_cons _big_x1 _big_x2)) -> (auto___aux_31 (ext_cons _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_p__aux_31. Intros _big_x1 _big_x2. Intro H.
  Elim (rem_74 _big_x1 _big_x2 H); Intros.
  Apply (rem_435 epsilon_mknows_p__aux_31 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_437 : ((X:extterm)(auto_knows X) -> (auto___aux_31 X)) -> (_big_x1:extterm)(auto___aux_13 _big_x1) -> (auto___aux_31 (ext_noncea _big_x1)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_31_noncea_1; Assumption. Defined.

Remark rem_438 : ((X:extterm)(auto_knows X) -> (auto___aux_31 X)) -> (_big_x1:extterm)(auto_knows (ext_noncea _big_x1)) -> (auto___aux_31 (ext_noncea _big_x1)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_p__aux_31. Intros _big_x1. Intro H.
  Elim (rem_78 _big_x1 H); Intros.
  Apply (rem_437 epsilon_mknows_p__aux_31 _big_x1); Tauto.
Defined.

Remark rem_439 : ((X:extterm)(auto_knows X) -> (auto___aux_31 X)) -> (auto_knows ext_bob) -> (auto___aux_31 ext_bob). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_31_bob_1; Assumption. Defined.

Remark rem_440 : ((X:extterm)(auto_knows X) -> (auto___aux_31 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_16 _big_x1) -> (auto___aux_17 _big_x2) -> (auto___aux_31 (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_31_crypt_1; Assumption. Defined.

Remark rem_441 : ((X:extterm)(auto_knows X) -> (auto___aux_31 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_43 _big_x1) -> (auto___aux_29 _big_x2) -> (auto___aux_31 (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_31_crypt_2; Assumption. Defined.

Remark rem_442 : ((X:extterm)(auto_knows X) -> (auto___aux_31 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_51 _big_x1) -> (auto___aux_52 _big_x2) -> (auto___aux_31 (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_31_crypt_3; Assumption. Defined.

Remark rem_443 : ((X:extterm)(auto_knows X) -> (auto___aux_31 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_49 _big_x1) -> (auto___aux_50 _big_x2) -> (auto___aux_31 (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_31_crypt_4; Assumption. Defined.

Remark rem_444 : ((X:extterm)(auto_knows X) -> (auto___aux_31 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_28 _big_x1) -> (auto___aux_29 _big_x2) -> (auto___aux_31 (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_31_crypt_5; Assumption. Defined.

Remark rem_445 : ((X:extterm)(auto_knows X) -> (auto___aux_31 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_36 _big_x1) -> (auto___aux_17 _big_x2) -> (auto___aux_31 (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_31_crypt_6; Assumption. Defined.

Remark rem_446 : ((X:extterm)(auto_knows X) -> (auto___aux_31 X)) -> (_big_x1,_big_x2:extterm)(auto_knows _big_x1) -> (auto_knows _big_x2) -> (auto___aux_31 (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_31_crypt_7; Assumption. Defined.

Remark rem_447 : ((X:extterm)(auto_knows X) -> (auto___aux_31 X)) -> (_big_x1,_big_x2:extterm)(auto_knows (ext_crypt _big_x1 _big_x2)) -> (auto___aux_31 (ext_crypt _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_p__aux_31. Intros _big_x1 _big_x2. Intro H.
  Elim (rem_92 _big_x1 _big_x2 H); Intros.
  Apply (rem_440 epsilon_mknows_p__aux_31 _big_x1 _big_x2); Tauto.
  Apply (rem_441 epsilon_mknows_p__aux_31 _big_x1 _big_x2); Tauto.
  Apply (rem_442 epsilon_mknows_p__aux_31 _big_x1 _big_x2); Tauto.
  Apply (rem_443 epsilon_mknows_p__aux_31 _big_x1 _big_x2); Tauto.
  Apply (rem_444 epsilon_mknows_p__aux_31 _big_x1 _big_x2); Tauto.
  Apply (rem_445 epsilon_mknows_p__aux_31 _big_x1 _big_x2); Tauto.
  Apply (rem_446 epsilon_mknows_p__aux_31 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_448 : ((X:extterm)(auto_knows X) -> (auto___aux_31 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_55 _big_x1) -> (auto___aux_56 _big_x2) -> (auto___aux_31 (ext_key _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_31_key_1; Assumption. Defined.

Remark rem_449 : ((X:extterm)(auto_knows X) -> (auto___aux_31 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_57 _big_x1) -> (auto___aux_58 _big_x2) -> (auto___aux_31 (ext_key _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_31_key_2; Assumption. Defined.

Remark rem_450 : ((X:extterm)(auto_knows X) -> (auto___aux_31 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_53 _big_x1) -> (auto___aux_54 _big_x2) -> (auto___aux_31 (ext_key _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_31_key_3; Assumption. Defined.

Remark rem_451 : ((X:extterm)(auto_knows X) -> (auto___aux_31 X)) -> (_big_x1,_big_x2:extterm)(auto_knows (ext_key _big_x1 _big_x2)) -> (auto___aux_31 (ext_key _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_p__aux_31. Intros _big_x1 _big_x2. Intro H.
  Elim (rem_115 _big_x1 _big_x2 H); Intros.
  Apply (rem_448 epsilon_mknows_p__aux_31 _big_x1 _big_x2); Tauto.
  Apply (rem_449 epsilon_mknows_p__aux_31 _big_x1 _big_x2); Tauto.
  Apply (rem_450 epsilon_mknows_p__aux_31 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_452 : (_big_x1:extterm)(auto_knows _big_x1) -> (auto___aux_31 _big_x1). (* Induct. *)
Proof.
   Fix epsilon_mknows_p__aux_31 1.
  Intro X. Case X; First [ Intros X1; Exact (rem_427 epsilon_mknows_p__aux_31 X1)
  | Exact (rem_428 epsilon_mknows_p__aux_31 )
  | Exact (rem_429 epsilon_mknows_p__aux_31 )
  |  Intros X1 X2 X3; Exact (rem_432 epsilon_mknows_p__aux_31 X1 X2 X3)
  | Exact (rem_433 epsilon_mknows_p__aux_31 )
  | Exact (rem_434 epsilon_mknows_p__aux_31 )
  |  Intros X1 X2; Exact (rem_436 epsilon_mknows_p__aux_31 X1 X2)
  |  Intros X1; Exact (rem_438 epsilon_mknows_p__aux_31 X1)
  | Exact (rem_439 epsilon_mknows_p__aux_31 )
  |  Intros X1 X2; Exact (rem_447 epsilon_mknows_p__aux_31 X1 X2)
  |  Intros X1 X2; Exact (rem_451 epsilon_mknows_p__aux_31 X1 X2)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_453 : (_big_x1,_big_x2,_big_x3:extterm)(auto_knows _big_x1) -> (auto_knows _big_x2) -> (auto_knows _big_x3) -> (auto___aux_31 _big_x1). (* Split. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3.
  Cut (auto_knows _big_x1) -> (auto___aux_31 _big_x1). Tauto.
  Exact (rem_452 _big_x1).
Defined.

Remark rem_454 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_15 (ext___tuple____aux_15 _big_x1 _big_x2 _big_x3)) -> (auto___aux_31 _big_x1). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_248 _big_x1 _big_x2 _big_x3 H); Intros.
  Apply (rem_453 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_455 : ((X:extterm)(auto_knows X) -> (auto___aux_18 X)) -> (_big_x1:extterm)(auto_knows _big_x1) -> (auto___aux_18 (ext_s _big_x1)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_18_s_1; Assumption. Defined.

Remark rem_456 : ((X:extterm)(auto_knows X) -> (auto___aux_18 X)) -> (_big_x1:extterm)(auto_knows (ext_s _big_x1)) -> (auto___aux_18 (ext_s _big_x1)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_p__aux_18. Intros _big_x1. Intro H.
  Elim (rem_49 _big_x1 H); Intros.
  Apply (rem_455 epsilon_mknows_p__aux_18 _big_x1); Tauto.
Defined.

Remark rem_457 : ((X:extterm)(auto_knows X) -> (auto___aux_18 X)) -> (auto_knows ext_nil) -> (auto___aux_18 ext_nil). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_18_nil_1; Assumption. Defined.

Remark rem_458 : ((X:extterm)(auto_knows X) -> (auto___aux_18 X)) -> (auto_knows ext_intruder) -> (auto___aux_18 ext_intruder). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_18_intruder_1; Assumption. Defined.

Remark rem_459 : ((X:extterm)(auto_knows X) -> (auto___aux_18 X)) -> (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_39 _big_x1) -> (auto___aux_31 _big_x2) -> (auto___aux_20 _big_x3) -> (auto___aux_18 (ext_nonceb _big_x1 _big_x2 _big_x3)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_18_nonceb_1; Assumption. Defined.

Remark rem_460 : ((X:extterm)(auto_knows X) -> (auto___aux_18 X)) -> (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_22 _big_x1) -> (auto___aux_31 _big_x2) -> (auto___aux_20 _big_x3) -> (auto___aux_18 (ext_nonceb _big_x1 _big_x2 _big_x3)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_18_nonceb_2; Assumption. Defined.

Remark rem_461 : ((X:extterm)(auto_knows X) -> (auto___aux_18 X)) -> (_big_x1,_big_x2,_big_x3:extterm)(auto_knows (ext_nonceb _big_x1 _big_x2 _big_x3)) -> (auto___aux_18 (ext_nonceb _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_p__aux_18. Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_62 _big_x1 _big_x2 _big_x3 H); Intros.
  Apply (rem_459 epsilon_mknows_p__aux_18 _big_x1 _big_x2 _big_x3); Tauto.
  Apply (rem_460 epsilon_mknows_p__aux_18 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_462 : ((X:extterm)(auto_knows X) -> (auto___aux_18 X)) -> (auto_knows ext_alice) -> (auto___aux_18 ext_alice). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_18_alice_1; Assumption. Defined.

Remark rem_463 : ((X:extterm)(auto_knows X) -> (auto___aux_18 X)) -> (auto_knows ext_server) -> (auto___aux_18 ext_server). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_18_server_1; Assumption. Defined.

Remark rem_464 : ((X:extterm)(auto_knows X) -> (auto___aux_18 X)) -> (_big_x1,_big_x2:extterm)(auto_knows _big_x1) -> (auto_knows _big_x2) -> (auto___aux_18 (ext_cons _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_18_cons_1; Assumption. Defined.

Remark rem_465 : ((X:extterm)(auto_knows X) -> (auto___aux_18 X)) -> (_big_x1,_big_x2:extterm)(auto_knows (ext_cons _big_x1 _big_x2)) -> (auto___aux_18 (ext_cons _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_p__aux_18. Intros _big_x1 _big_x2. Intro H.
  Elim (rem_74 _big_x1 _big_x2 H); Intros.
  Apply (rem_464 epsilon_mknows_p__aux_18 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_466 : ((X:extterm)(auto_knows X) -> (auto___aux_18 X)) -> (_big_x1:extterm)(auto___aux_13 _big_x1) -> (auto___aux_18 (ext_noncea _big_x1)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_18_noncea_1; Assumption. Defined.

Remark rem_467 : ((X:extterm)(auto_knows X) -> (auto___aux_18 X)) -> (_big_x1:extterm)(auto_knows (ext_noncea _big_x1)) -> (auto___aux_18 (ext_noncea _big_x1)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_p__aux_18. Intros _big_x1. Intro H.
  Elim (rem_78 _big_x1 H); Intros.
  Apply (rem_466 epsilon_mknows_p__aux_18 _big_x1); Tauto.
Defined.

Remark rem_468 : ((X:extterm)(auto_knows X) -> (auto___aux_18 X)) -> (auto_knows ext_bob) -> (auto___aux_18 ext_bob). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_18_bob_1; Assumption. Defined.

Remark rem_469 : ((X:extterm)(auto_knows X) -> (auto___aux_18 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_16 _big_x1) -> (auto___aux_17 _big_x2) -> (auto___aux_18 (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_18_crypt_1; Assumption. Defined.

Remark rem_470 : ((X:extterm)(auto_knows X) -> (auto___aux_18 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_43 _big_x1) -> (auto___aux_29 _big_x2) -> (auto___aux_18 (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_18_crypt_2; Assumption. Defined.

Remark rem_471 : ((X:extterm)(auto_knows X) -> (auto___aux_18 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_51 _big_x1) -> (auto___aux_52 _big_x2) -> (auto___aux_18 (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_18_crypt_3; Assumption. Defined.

Remark rem_472 : ((X:extterm)(auto_knows X) -> (auto___aux_18 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_49 _big_x1) -> (auto___aux_50 _big_x2) -> (auto___aux_18 (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_18_crypt_4; Assumption. Defined.

Remark rem_473 : ((X:extterm)(auto_knows X) -> (auto___aux_18 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_28 _big_x1) -> (auto___aux_29 _big_x2) -> (auto___aux_18 (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_18_crypt_5; Assumption. Defined.

Remark rem_474 : ((X:extterm)(auto_knows X) -> (auto___aux_18 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_36 _big_x1) -> (auto___aux_17 _big_x2) -> (auto___aux_18 (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_18_crypt_6; Assumption. Defined.

Remark rem_475 : ((X:extterm)(auto_knows X) -> (auto___aux_18 X)) -> (_big_x1,_big_x2:extterm)(auto_knows _big_x1) -> (auto_knows _big_x2) -> (auto___aux_18 (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_18_crypt_7; Assumption. Defined.

Remark rem_476 : ((X:extterm)(auto_knows X) -> (auto___aux_18 X)) -> (_big_x1,_big_x2:extterm)(auto_knows (ext_crypt _big_x1 _big_x2)) -> (auto___aux_18 (ext_crypt _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_p__aux_18. Intros _big_x1 _big_x2. Intro H.
  Elim (rem_92 _big_x1 _big_x2 H); Intros.
  Apply (rem_469 epsilon_mknows_p__aux_18 _big_x1 _big_x2); Tauto.
  Apply (rem_470 epsilon_mknows_p__aux_18 _big_x1 _big_x2); Tauto.
  Apply (rem_471 epsilon_mknows_p__aux_18 _big_x1 _big_x2); Tauto.
  Apply (rem_472 epsilon_mknows_p__aux_18 _big_x1 _big_x2); Tauto.
  Apply (rem_473 epsilon_mknows_p__aux_18 _big_x1 _big_x2); Tauto.
  Apply (rem_474 epsilon_mknows_p__aux_18 _big_x1 _big_x2); Tauto.
  Apply (rem_475 epsilon_mknows_p__aux_18 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_477 : ((X:extterm)(auto_knows X) -> (auto___aux_18 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_55 _big_x1) -> (auto___aux_56 _big_x2) -> (auto___aux_18 (ext_key _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_18_key_1; Assumption. Defined.

Remark rem_478 : ((X:extterm)(auto_knows X) -> (auto___aux_18 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_57 _big_x1) -> (auto___aux_58 _big_x2) -> (auto___aux_18 (ext_key _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_18_key_2; Assumption. Defined.

Remark rem_479 : ((X:extterm)(auto_knows X) -> (auto___aux_18 X)) -> (_big_x1,_big_x2:extterm)(auto___aux_53 _big_x1) -> (auto___aux_54 _big_x2) -> (auto___aux_18 (ext_key _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_18_key_3; Assumption. Defined.

Remark rem_480 : ((X:extterm)(auto_knows X) -> (auto___aux_18 X)) -> (_big_x1,_big_x2:extterm)(auto_knows (ext_key _big_x1 _big_x2)) -> (auto___aux_18 (ext_key _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_mknows_p__aux_18. Intros _big_x1 _big_x2. Intro H.
  Elim (rem_115 _big_x1 _big_x2 H); Intros.
  Apply (rem_477 epsilon_mknows_p__aux_18 _big_x1 _big_x2); Tauto.
  Apply (rem_478 epsilon_mknows_p__aux_18 _big_x1 _big_x2); Tauto.
  Apply (rem_479 epsilon_mknows_p__aux_18 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_481 : (_big_x1:extterm)(auto_knows _big_x1) -> (auto___aux_18 _big_x1). (* Induct. *)
Proof.
   Fix epsilon_mknows_p__aux_18 1.
  Intro X. Case X; First [ Intros X1; Exact (rem_456 epsilon_mknows_p__aux_18 X1)
  | Exact (rem_457 epsilon_mknows_p__aux_18 )
  | Exact (rem_458 epsilon_mknows_p__aux_18 )
  |  Intros X1 X2 X3; Exact (rem_461 epsilon_mknows_p__aux_18 X1 X2 X3)
  | Exact (rem_462 epsilon_mknows_p__aux_18 )
  | Exact (rem_463 epsilon_mknows_p__aux_18 )
  |  Intros X1 X2; Exact (rem_465 epsilon_mknows_p__aux_18 X1 X2)
  |  Intros X1; Exact (rem_467 epsilon_mknows_p__aux_18 X1)
  | Exact (rem_468 epsilon_mknows_p__aux_18 )
  |  Intros X1 X2; Exact (rem_476 epsilon_mknows_p__aux_18 X1 X2)
  |  Intros X1 X2; Exact (rem_480 epsilon_mknows_p__aux_18 X1 X2)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_482 : (_big_x1,_big_x2,_big_x3:extterm)(auto_knows _big_x2) -> (auto_knows _big_x3) -> (auto_knows _big_x1) -> (auto___aux_18 _big_x1). (* Split. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3.
  Cut (auto_knows _big_x1) -> (auto___aux_18 _big_x1). Tauto.
  Exact (rem_481 _big_x1).
Defined.

Remark rem_483 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_15 (ext___tuple____aux_15 _big_x2 _big_x3 _big_x1)) -> (auto___aux_18 _big_x1). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_248 _big_x2 _big_x3 _big_x1 H); Intros.
  Apply (rem_482 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_484 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_31 _big_x2) -> (auto___aux_20 _big_x3) -> (auto___aux_39 _big_x1) -> (auto___aux_49 (ext_nonceb _big_x1 _big_x2 _big_x3)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_49_nonceb_1; Assumption. Defined.

Remark rem_485 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_31 _big_x2) -> (auto___aux_20 _big_x3) -> (auto___aux_22 _big_x1) -> (auto___aux_49 (ext_nonceb _big_x1 _big_x2 _big_x3)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_49_nonceb_2; Assumption. Defined.

Remark rem_486 : (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_48 (ext___tuple____aux_48 _big_x2 _big_x3 _big_x1)) -> (auto___aux_49 (ext_nonceb _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_303 _big_x2 _big_x3 _big_x1 H); Intros.
  Apply (rem_484 _big_x1 _big_x2 _big_x3); Tauto.
  Apply (rem_485 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_487 : (_big_x1,_big_x2:extterm)(auto___aux_27 _big_x2) -> (auto___aux_31 _big_x1) -> (auto___aux_30 (ext_cons _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_30_cons_1; Assumption. Defined.

Remark rem_488 : (auto___aux_7 ext_alice). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_7_alice_1; Assumption. Defined.

Remark rem_489 : (_big_x1:extterm)(auto_knows (ext_key ext_pub _big_x1)) -> (auto___aux_3 _big_x1). (* Subsumed by universal clause. *)
Proof. Intros. Apply trans___aux_3_1. Defined.

Remark rem_490 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_26 _big_x5) -> (auto___aux_27 ext_nil) -> (auto_knows _big_x2) -> (auto_knows _big_x1) -> (auto_knows _big_x3) -> (auto___aux_24 _big_x4) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_45___tuple____aux_45_1; Assumption. Defined.

Remark rem_491 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto_knows _big_x2) -> (auto_knows _big_x1) -> (auto_knows _big_x3) -> (auto___aux_24 _big_x4) -> (auto___aux_23 (ext_cons _big_x5 ext_nil)) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intros H1 H2 H3 H4. Intro H.
  Elim (rem_175 _big_x5 ext_nil H); Intros.
  Apply (rem_490 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_492 : (X1,X2,X3:extterm)(auto___aux_25 (ext_current_session X1 X2 X3)) -> (or_1
    ((auto_knows X1) /\ (auto_knows X2) /\ (auto_knows X3))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_493 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_24 _big_x4) -> (auto___aux_25 (ext_current_session _big_x2 _big_x1 _big_x3)) -> (auto___aux_23 (ext_cons _big_x5 ext_nil)) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intros H1. Intro H.
  Elim (rem_492 _big_x2 _big_x1 _big_x3 H); Intros.
  Apply (rem_491 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_494 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_22 (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3))) -> (auto___aux_23 (ext_cons _big_x5 ext_nil)) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_299 _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3) H); Intros.
  Apply (rem_493 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_495 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_21 (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_177 (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil) H); Intros.
  Apply (rem_494 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_496 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_20 ext_bob) -> (auto___aux_21 (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_179 H); Intros.
  Apply (rem_495 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_497 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_19 (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_125 ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)) H); Intros.
  Apply (rem_496 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_498 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_12 ext_nil) -> (auto___aux_19 (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_182 H); Intros.
  Apply (rem_497 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_499 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_9 ext_bob) -> (auto___aux_12 ext_nil) -> (auto___aux_19 (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_184 H); Intros.
  Apply (rem_498 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_500 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_14 (ext_cons ext_bob ext_nil)) -> (auto___aux_19 (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_186 ext_bob ext_nil H); Intros.
  Apply (rem_499 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_501 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_7 ext_alice) -> (auto___aux_14 (ext_cons ext_bob ext_nil)) -> (auto___aux_19 (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_188 H); Intros.
  Apply (rem_500 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_502 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_13 (ext_cons ext_alice (ext_cons ext_bob ext_nil))) -> (auto___aux_19 (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_190 ext_alice (ext_cons ext_bob ext_nil) H); Intros.
  Apply (rem_501 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_503 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_18 (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil)))) -> (auto___aux_19 (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_192 (ext_cons ext_alice (ext_cons ext_bob ext_nil)) H); Intros.
  Apply (rem_502 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_504 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_16 (ext_cons (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil))))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_127 (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil))) H); Intros.
  Apply (rem_503 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_505 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_39 (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil)))) -> (auto___aux_30 (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)))) -> (auto___aux_29 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_195 (ext_cons ext_alice (ext_cons ext_bob ext_nil)) H); Intros.
Defined.

Remark rem_506 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_43 (ext_cons (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil))))) -> (auto___aux_29 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_139 (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil))) H); Intros.
  Apply (rem_505 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_507 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_51 (ext_cons (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil))))) -> (auto___aux_52 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_141 (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil))) H); Intros.
Defined.

Remark rem_508 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_49 (ext_cons (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil))))) -> (auto___aux_50 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_143 (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil))) H); Intros.
Defined.

Remark rem_509 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_22 (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil)))) -> (auto___aux_30 (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)))) -> (auto___aux_29 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_200 (ext_cons ext_alice (ext_cons ext_bob ext_nil)) H); Intros.
Defined.

Remark rem_510 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_28 (ext_cons (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil))))) -> (auto___aux_29 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_151 (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil))) H); Intros.
  Apply (rem_509 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_511 : (X1,X2,X3:extterm)(auto___aux_41 (ext_current_session X1 X2 X3)) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_512 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_24 _big_x4) -> (auto___aux_41 (ext_current_session _big_x2 _big_x1 _big_x3)) -> (auto___aux_40 (ext_cons _big_x5 ext_nil)) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intros H1. Intro H.
  Elim (rem_511 _big_x2 _big_x1 _big_x3 H); Intros.
Defined.

Remark rem_513 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_39 (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3))) -> (auto___aux_40 (ext_cons _big_x5 ext_nil)) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_294 _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3) H); Intros.
  Apply (rem_512 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_514 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_38 (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_206 (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil) H); Intros.
  Apply (rem_513 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_515 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_20 ext_bob) -> (auto___aux_38 (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_179 H); Intros.
  Apply (rem_514 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_516 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_37 (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_155 ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)) H); Intros.
  Apply (rem_515 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_517 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_12 ext_nil) -> (auto___aux_37 (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_182 H); Intros.
  Apply (rem_516 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_518 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_9 ext_bob) -> (auto___aux_12 ext_nil) -> (auto___aux_37 (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_184 H); Intros.
  Apply (rem_517 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_519 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_14 (ext_cons ext_bob ext_nil)) -> (auto___aux_37 (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_186 ext_bob ext_nil H); Intros.
  Apply (rem_518 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_520 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_7 ext_alice) -> (auto___aux_14 (ext_cons ext_bob ext_nil)) -> (auto___aux_37 (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_188 H); Intros.
  Apply (rem_519 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_521 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_13 (ext_cons ext_alice (ext_cons ext_bob ext_nil))) -> (auto___aux_37 (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_190 ext_alice (ext_cons ext_bob ext_nil) H); Intros.
  Apply (rem_520 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_522 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_18 (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil)))) -> (auto___aux_37 (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_192 (ext_cons ext_alice (ext_cons ext_bob ext_nil)) H); Intros.
  Apply (rem_521 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_523 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_36 (ext_cons (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil))))) -> (auto___aux_17 (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_157 (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil))) H); Intros.
  Apply (rem_522 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_524 : (X1,X2,X3:extterm)(auto___aux_56 (ext_current_session X1 X2 X3)) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_525 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_55 _big_x4) -> (auto___aux_56 (ext_current_session _big_x2 _big_x1 _big_x3)) -> (auto_knows (ext_cons _big_x5 ext_nil)) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intros H1. Intro H.
  Elim (rem_524 _big_x2 _big_x1 _big_x3 H); Intros.
Defined.

Remark rem_526 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_57 _big_x4) -> (auto___aux_58 (ext_current_session _big_x2 _big_x1 _big_x3)) -> (auto_knows (ext_cons _big_x5 ext_nil)) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intros H1. Intro H.
  Elim (rem_101 _big_x2 _big_x1 _big_x3 H); Intros.
Defined.

Remark rem_527 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_55 ext_sym) -> (auto___aux_56 (ext_cons ext_alice (ext_cons ext_server ext_nil))) -> (auto_knows _big_x5) -> (auto___aux_53 _big_x4) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_159 H); Intros.
Defined.

Remark rem_528 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_58 (ext_cons ext_alice (ext_cons ext_server ext_nil))) -> (auto_knows _big_x5) -> (auto___aux_53 _big_x4) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_161 ext_alice (ext_cons ext_server ext_nil) H); Intros.
Defined.

Remark rem_529 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_57 ext_sym) -> (auto___aux_58 (ext_cons ext_alice (ext_cons ext_server ext_nil))) -> (auto_knows _big_x5) -> (auto___aux_53 _big_x4) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_163 H); Intros.
  Apply (rem_528 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_530 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_53 ext_sym) -> (auto_knows _big_x5) -> (auto___aux_53 _big_x4) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_165 H); Intros.
Defined.

Remark rem_531 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_53 ext_sym) -> (auto___aux_54 (ext_cons ext_alice (ext_cons ext_server ext_nil))) -> (auto_knows _big_x5) -> (auto___aux_53 _big_x4) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom by universal clause. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intros. Apply (rem_530 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Assumption.
Defined.

Remark rem_532 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto_knows _big_x5) -> (auto___aux_53 _big_x4) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intros H1 H2. Intro H.
  Elim (rem_115 ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)) H); Intros.
  Apply (rem_527 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
  Apply (rem_529 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
  Apply (rem_531 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_533 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto_knows _big_x5) -> (auto_knows ext_nil) -> (auto___aux_53 _big_x4) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intros H1. Intro H.
  Elim (rem_53 H); Intros.
  Apply (rem_532 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_534 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_53 _big_x4) -> (auto_knows (ext_cons _big_x5 ext_nil)) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intros H1. Intro H.
  Elim (rem_74 _big_x5 ext_nil H); Intros.
  Apply (rem_533 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_535 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_53 _big_x4) -> (auto___aux_54 (ext_current_session _big_x2 _big_x1 _big_x3)) -> (auto_knows (ext_cons _big_x5 ext_nil)) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom by universal clause. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intros. Apply (rem_534 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Assumption.
Defined.

Remark rem_536 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto_knows (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3))) -> (auto_knows (ext_cons _big_x5 ext_nil)) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_115 _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3) H); Intros.
  Apply (rem_525 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
  Apply (rem_526 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
  Apply (rem_535 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_537 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto_knows (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil))) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_74 (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil) H); Intros.
  Apply (rem_536 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_538 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto_knows ext_bob) -> (auto_knows (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil))) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_82 H); Intros.
  Apply (rem_537 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_539 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto_knows (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)))) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_74 ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)) H); Intros.
  Apply (rem_538 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_540 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_12 ext_nil) -> (auto_knows (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)))) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_182 H); Intros.
  Apply (rem_539 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_541 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_9 ext_bob) -> (auto___aux_12 ext_nil) -> (auto_knows (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)))) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_184 H); Intros.
  Apply (rem_540 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_542 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_14 (ext_cons ext_bob ext_nil)) -> (auto_knows (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)))) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_186 ext_bob ext_nil H); Intros.
  Apply (rem_541 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_543 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_7 ext_alice) -> (auto___aux_14 (ext_cons ext_bob ext_nil)) -> (auto_knows (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)))) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_188 H); Intros.
  Apply (rem_542 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_544 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto___aux_13 (ext_cons ext_alice (ext_cons ext_bob ext_nil))) -> (auto_knows (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)))) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_190 ext_alice (ext_cons ext_bob ext_nil) H); Intros.
  Apply (rem_543 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_545 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto_knows (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil)))) -> (auto_knows (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)))) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_78 (ext_cons ext_alice (ext_cons ext_bob ext_nil)) H); Intros.
  Apply (rem_544 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_546 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto_knows (ext_cons (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil))))) -> (auto_knows (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil)))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_74 (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil))) H); Intros.
  Apply (rem_545 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_547 : (_big_x1,_big_x2,_big_x3,_big_x4,_big_x5:extterm)(auto_knows (ext_crypt (ext_cons (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)))) (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil))))) -> (auto___aux_45 (ext___tuple____aux_45 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2 _big_x3 _big_x4 _big_x5. Intro H.
  Elim (rem_92 (ext_cons (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons (ext_key _big_x4 (ext_current_session _big_x2 _big_x1 _big_x3)) (ext_cons _big_x5 ext_nil)))) (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil))) H); Intros.
  Apply (rem_504 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
  Apply (rem_506 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
  Apply (rem_507 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
  Apply (rem_508 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
  Apply (rem_510 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
  Apply (rem_523 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
  Apply (rem_546 _big_x1 _big_x2 _big_x3 _big_x4 _big_x5); Tauto.
Defined.

Remark rem_548 : (_big_x1:extterm)(auto___aux_54 _big_x1). (* Subsumed by universal clause. *)
Proof. Intros. Apply trans___aux_54_1. Defined.

Remark rem_549 : (_big_x1,_big_x2:extterm)(auto___aux_37 _big_x2) -> (auto___aux_18 _big_x1) -> (auto___aux_36 (ext_cons _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_36_cons_1; Assumption. Defined.

Remark rem_550 : (_big_x1,_big_x2:extterm)(auto___aux_24 ext_sym) -> (auto___aux_35 _big_x2) -> (auto___aux_16 _big_x1) -> (auto___aux_6 (ext___tuple____aux_6 _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_6___tuple____aux_6_5; Assumption. Defined.

Remark rem_551 : (_big_x1,_big_x2:extterm)(auto___aux_16 _big_x1) -> (auto___aux_17 (ext_key ext_sym _big_x2)) -> (auto___aux_6 (ext___tuple____aux_6 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros H1. Intro H.
  Elim (rem_18 ext_sym _big_x2 H); Intros.
  Apply (rem_550 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_552 : (_big_x1,_big_x2:extterm)(auto___aux_24 ext_sym) -> (auto___aux_32 _big_x2) -> (auto___aux_43 _big_x1) -> (auto___aux_6 (ext___tuple____aux_6 _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_6___tuple____aux_6_7; Assumption. Defined.

Remark rem_553 : (_big_x1,_big_x2:extterm)(auto___aux_43 _big_x1) -> (auto___aux_29 (ext_key ext_sym _big_x2)) -> (auto___aux_6 (ext___tuple____aux_6 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros H1. Intro H.
  Elim (rem_31 ext_sym _big_x2 H); Intros.
  Apply (rem_552 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_554 : (_big_x1,_big_x2:extterm)(auto___aux_24 ext_sym) -> (auto___aux_46 ext_sym) -> (auto___aux_25 _big_x2) -> (auto___aux_47 _big_x2) -> (auto___aux_51 _big_x1) -> (auto___aux_6 (ext___tuple____aux_6 _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_6___tuple____aux_6_3; Assumption. Defined.

Remark rem_555 : (_big_x1,_big_x2:extterm)(auto___aux_51 _big_x1) -> (auto___aux_52 (ext_key ext_sym _big_x2)) -> (auto___aux_6 (ext___tuple____aux_6 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros H1. Intro H.
  Elim (rem_256 ext_sym _big_x2 H); Intros.
  Apply (rem_554 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_556 : ((X:extterm)(auto___aux_49 X) -> (auto_knows X)) -> (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_39 _big_x1) -> (auto___aux_31 _big_x2) -> (auto___aux_20 _big_x3) -> (auto_knows (ext_nonceb _big_x1 _big_x2 _big_x3)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_knows_nonceb_1; Assumption. Defined.

Remark rem_557 : ((X:extterm)(auto___aux_49 X) -> (auto_knows X)) -> (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_22 _big_x1) -> (auto___aux_31 _big_x2) -> (auto___aux_20 _big_x3) -> (auto_knows (ext_nonceb _big_x1 _big_x2 _big_x3)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_knows_nonceb_2; Assumption. Defined.

Remark rem_558 : (X1,X2,X3:extterm)(auto___aux_49 (ext_nonceb X1 X2 X3)) -> (or_2
    ((auto___aux_39 X1) /\ (auto___aux_31 X2) /\ (auto___aux_20 X3))
    ((auto___aux_22 X1) /\ (auto___aux_31 X2) /\ (auto___aux_20 X3))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_2_intro_1; Tauto.
  Intros. Apply or_2_intro_2; Tauto.
Qed.

Remark rem_559 : ((X:extterm)(auto___aux_49 X) -> (auto_knows X)) -> (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_49 (ext_nonceb _big_x1 _big_x2 _big_x3)) -> (auto_knows (ext_nonceb _big_x1 _big_x2 _big_x3)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_m__aux_49_pknows. Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_558 _big_x1 _big_x2 _big_x3 H); Intros.
  Apply (rem_556 epsilon_m__aux_49_pknows _big_x1 _big_x2 _big_x3); Tauto.
  Apply (rem_557 epsilon_m__aux_49_pknows _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_560 : (_big_x1:extterm)(auto___aux_49 _big_x1) -> (auto_knows _big_x1). (* Induct. *)
Proof.
   Fix epsilon_m__aux_49_pknows 1.
  Intro X. Case X; First [ Intros X1 X2 X3; Exact (rem_559 epsilon_m__aux_49_pknows X1 X2 X3)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_561 : ((X:extterm)(auto___aux_41 X) -> (auto___aux_58 X)) -> (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_41 (ext_old_session _big_x1 _big_x2 _big_x3)) -> (auto___aux_58 (ext_old_session _big_x1 _big_x2 _big_x3)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_58_old_session_1; Assumption. Defined.

Remark rem_562 : (_big_x2:extterm)(auto___aux_41 _big_x2) -> (auto___aux_58 _big_x2). (* Induct. *)
Proof.
   Fix epsilon_m__aux_41_p__aux_58 1.
  Intro X. Case X; First [ Intros X1 X2 X3; Exact (rem_561 epsilon_m__aux_41_p__aux_58 X1 X2 X3)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_563 : (_big_x1,_big_x2:extterm)(auto___aux_41 _big_x2) -> (auto___aux_49 _big_x1) -> ((auto_knows _big_x1) /\ (auto___aux_58 _big_x2)) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
   Intros _big_x1 _big_x2. Intros A1 A2.
  Cut (auto_knows _big_x1). 2:Apply (rem_560 _big_x1); Assumption.
  Cut (auto___aux_58 _big_x2). 2:Apply (rem_562 _big_x2); Assumption.
  Tauto.
Defined.

Remark rem_564 : (_big_x1,_big_x2:extterm)(auto___aux_41 _big_x2) -> (auto___aux_49 _big_x1) -> ((auto_knows _big_x1) /\ (auto___aux_58 _big_x2)) \/ ((auto___aux_36 _big_x1) /\ (auto___aux_35 _big_x2)) \/ ((auto___aux_51 _big_x1) /\ (auto___aux_25 _big_x2) /\ (auto___aux_47 _big_x2)) \/ ((auto___aux_28 _big_x1) /\ (auto___aux_32 _big_x2)) \/ ((auto___aux_16 _big_x1) /\ (auto___aux_35 _big_x2)) \/ ((auto___aux_49 _big_x1) /\ (auto___aux_25 _big_x2)) \/ ((auto___aux_43 _big_x1) /\ (auto___aux_32 _big_x2)) \/ False. (* Prove a smaller disjunction. *)
Proof.
   Intros _big_x1 _big_x2. Intros A1 A2.
  Case (rem_563 _big_x1 _big_x2 A1 A2); Tauto.
Defined.

Remark rem_565 : (_big_x1,_big_x2:extterm)(auto___aux_41 _big_x2) -> (auto___aux_49 _big_x1) -> (auto___aux_6 (ext___tuple____aux_6 _big_x1 _big_x2)). (* Deduce positive atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros A1 A2.
  Case (rem_564 _big_x1 _big_x2 A1 A2). Clear A1 A2. Intros. Apply trans___aux_6___tuple____aux_6_1; Tauto.
  Intro H; Case H; Clear H. Clear A1 A2. Intros. Apply trans___aux_6___tuple____aux_6_2; Tauto.
  Intro H; Case H; Clear H. Clear A1 A2. Intros. Apply trans___aux_6___tuple____aux_6_3; Tauto.
  Intro H; Case H; Clear H. Clear A1 A2. Intros. Apply trans___aux_6___tuple____aux_6_4; Tauto.
  Intro H; Case H; Clear H. Clear A1 A2. Intros. Apply trans___aux_6___tuple____aux_6_5; Tauto.
  Intro H; Case H; Clear H. Clear A1 A2. Intros. Apply trans___aux_6___tuple____aux_6_6; Tauto.
  Intro H; Case H; Clear H. Clear A1 A2. Intros. Apply trans___aux_6___tuple____aux_6_7; Tauto.
  Clear A1 A2. Tauto.
Defined.

Remark rem_566 : (_big_x1,_big_x2:extterm)(auto___aux_24 ext_sym) -> (auto___aux_41 _big_x2) -> (auto___aux_49 _big_x1) -> (auto___aux_6 (ext___tuple____aux_6 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_132 H); Intros.
  Apply (rem_565 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_567 : (_big_x1,_big_x2:extterm)(auto___aux_24 ext_sym) -> (auto___aux_25 _big_x2) -> (auto___aux_49 _big_x1) -> (auto___aux_6 (ext___tuple____aux_6 _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_6___tuple____aux_6_6; Assumption. Defined.

Remark rem_568 : (_big_x1,_big_x2:extterm)(auto___aux_49 _big_x1) -> (auto___aux_50 (ext_key ext_sym _big_x2)) -> (auto___aux_6 (ext___tuple____aux_6 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros H1. Intro H.
  Elim (rem_260 ext_sym _big_x2 H); Intros.
  Apply (rem_566 _big_x1 _big_x2); Tauto.
  Apply (rem_567 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_569 : (_big_x1,_big_x2:extterm)(auto___aux_24 ext_sym) -> (auto___aux_32 _big_x2) -> (auto___aux_28 _big_x1) -> (auto___aux_6 (ext___tuple____aux_6 _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_6___tuple____aux_6_4; Assumption. Defined.

Remark rem_570 : (_big_x1,_big_x2:extterm)(auto___aux_28 _big_x1) -> (auto___aux_29 (ext_key ext_sym _big_x2)) -> (auto___aux_6 (ext___tuple____aux_6 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros H1. Intro H.
  Elim (rem_31 ext_sym _big_x2 H); Intros.
  Apply (rem_569 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_571 : (_big_x1,_big_x2:extterm)(auto___aux_24 ext_sym) -> (auto___aux_35 _big_x2) -> (auto___aux_36 _big_x1) -> (auto___aux_6 (ext___tuple____aux_6 _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_6___tuple____aux_6_2; Assumption. Defined.

Remark rem_572 : (_big_x1,_big_x2:extterm)(auto___aux_36 _big_x1) -> (auto___aux_17 (ext_key ext_sym _big_x2)) -> (auto___aux_6 (ext___tuple____aux_6 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros H1. Intro H.
  Elim (rem_18 ext_sym _big_x2 H); Intros.
  Apply (rem_571 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_573 : (_big_x1,_big_x2:extterm)(auto___aux_55 ext_sym) -> (auto___aux_56 _big_x2) -> (auto_knows _big_x1) -> (auto___aux_6 (ext___tuple____aux_6 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_159 H); Intros.
Defined.

Remark rem_574 : (_big_x1,_big_x2:extterm)(auto___aux_57 ext_sym) -> (auto___aux_58 _big_x2) -> (auto_knows _big_x1) -> (auto___aux_6 (ext___tuple____aux_6 _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_6___tuple____aux_6_1; Assumption. Defined.

Remark rem_575 : (_big_x1,_big_x2:extterm)(auto___aux_53 ext_sym) -> (auto_knows _big_x1) -> (auto___aux_6 (ext___tuple____aux_6 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_165 H); Intros.
Defined.

Remark rem_576 : (_big_x1,_big_x2:extterm)(auto___aux_53 ext_sym) -> (auto___aux_54 _big_x2) -> (auto_knows _big_x1) -> (auto___aux_6 (ext___tuple____aux_6 _big_x1 _big_x2)). (* Eliminate negative atom by universal clause. *)
Proof.
   Intros _big_x1 _big_x2. Intros. Apply (rem_575 _big_x1 _big_x2); Assumption.
Defined.

Remark rem_577 : (_big_x1,_big_x2:extterm)(auto_knows _big_x1) -> (auto_knows (ext_key ext_sym _big_x2)) -> (auto___aux_6 (ext___tuple____aux_6 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros H1. Intro H.
  Elim (rem_115 ext_sym _big_x2 H); Intros.
  Apply (rem_573 _big_x1 _big_x2); Tauto.
  Apply (rem_574 _big_x1 _big_x2); Tauto.
  Apply (rem_576 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_578 : (_big_x1,_big_x2:extterm)(auto_knows (ext_crypt _big_x1 (ext_key ext_sym _big_x2))) -> (auto___aux_6 (ext___tuple____aux_6 _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_92 _big_x1 (ext_key ext_sym _big_x2) H); Intros.
  Apply (rem_551 _big_x1 _big_x2); Tauto.
  Apply (rem_553 _big_x1 _big_x2); Tauto.
  Apply (rem_555 _big_x1 _big_x2); Tauto.
  Apply (rem_568 _big_x1 _big_x2); Tauto.
  Apply (rem_570 _big_x1 _big_x2); Tauto.
  Apply (rem_572 _big_x1 _big_x2); Tauto.
  Apply (rem_577 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_579 : (_big_x1,_big_x2:extterm)(auto___aux_10 _big_x2) -> (auto___aux_9 _big_x1) -> (auto___aux_8 (ext_cons _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_8_cons_1; Assumption. Defined.

Remark rem_580 : (_big_x1,_big_x2:extterm)(auto___aux_23 _big_x2) -> (auto___aux_22 _big_x1) -> (auto___aux_21 (ext_cons _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_21_cons_1; Assumption. Defined.

Remark rem_581 : (auto___aux_9 ext_bob). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans___aux_9_bob_1; Assumption. Defined.

(* [appp] Proofs that all approximation clauses hold. *)


Remark rem_582 : ((X:extterm)(auto___aux_42 X) -> (auto_knows X)) -> (_big_x1,_big_x2:extterm)(auto___aux_43 _big_x1) -> (auto___aux_29 _big_x2) -> (auto_knows (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_knows_crypt_2; Assumption. Defined.

Remark rem_583 : (X1,X2:extterm)(auto___aux_42 (ext_crypt X1 X2)) -> (or_1
    ((auto___aux_43 X1) /\ (auto___aux_29 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_584 : ((X:extterm)(auto___aux_42 X) -> (auto_knows X)) -> (_big_x1,_big_x2:extterm)(auto___aux_42 (ext_crypt _big_x1 _big_x2)) -> (auto_knows (ext_crypt _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_m__aux_42_pknows. Intros _big_x1 _big_x2. Intro H.
  Elim (rem_583 _big_x1 _big_x2 H); Intros.
  Apply (rem_582 epsilon_m__aux_42_pknows _big_x1 _big_x2); Tauto.
Defined.

Remark rem_585 : (_big_x1:extterm)(auto___aux_42 _big_x1) -> (auto_knows _big_x1). (* Induct. *)
Proof.
   Fix epsilon_m__aux_42_pknows 1.
  Intro X. Case X; First [ Intros X1 X2; Exact (rem_584 epsilon_m__aux_42_pknows X1 X2)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_586 : (_big_x1,_big_x2:extterm)(auto___aux_39 _big_x2) -> (auto___aux_42 _big_x1) -> (auto_knows _big_x1). (* Split. *)
Proof.
   Intros _big_x1 _big_x2.
  Cut (auto___aux_42 _big_x1) -> (auto_knows _big_x1). Tauto.
  Exact (rem_585 _big_x1).
Defined.

Remark rem_587 : ((X:extterm)(auto___aux_26 X) -> (auto_knows X)) -> (_big_x1,_big_x2:extterm)(auto___aux_28 _big_x1) -> (auto___aux_29 _big_x2) -> (auto_knows (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_knows_crypt_5; Assumption. Defined.

Remark rem_588 : (X1,X2:extterm)(auto___aux_26 (ext_crypt X1 X2)) -> (or_1
    ((auto___aux_28 X1) /\ (auto___aux_29 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_589 : ((X:extterm)(auto___aux_26 X) -> (auto_knows X)) -> (_big_x1,_big_x2:extterm)(auto___aux_26 (ext_crypt _big_x1 _big_x2)) -> (auto_knows (ext_crypt _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_m__aux_26_pknows. Intros _big_x1 _big_x2. Intro H.
  Elim (rem_588 _big_x1 _big_x2 H); Intros.
  Apply (rem_587 epsilon_m__aux_26_pknows _big_x1 _big_x2); Tauto.
Defined.

Remark rem_590 : (_big_x1:extterm)(auto___aux_26 _big_x1) -> (auto_knows _big_x1). (* Induct. *)
Proof.
   Fix epsilon_m__aux_26_pknows 1.
  Intro X. Case X; First [ Intros X1 X2; Exact (rem_589 epsilon_m__aux_26_pknows X1 X2)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_591 : (_big_x1,_big_x2:extterm)(auto___aux_22 _big_x2) -> (auto___aux_26 _big_x1) -> (auto_knows _big_x1). (* Split. *)
Proof.
   Intros _big_x1 _big_x2.
  Cut (auto___aux_26 _big_x1) -> (auto_knows _big_x1). Tauto.
  Exact (rem_590 _big_x1).
Defined.

Remark rem_592 : (X1,X2:extterm)(auto___aux_44 (ext___tuple____aux_44 X1 X2)) -> (or_2
    ((auto___aux_39 X1) /\ (auto___aux_42 X2))
    ((auto___aux_22 X1) /\ (auto___aux_26 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_2_intro_1; Tauto.
  Intros. Apply or_2_intro_2; Tauto.
Qed.

Remark rem_593 : (_big_x1,_big_x2:extterm)(auto___aux_44 (ext___tuple____aux_44 _big_x2 _big_x1)) -> (auto_knows _big_x1). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_592 _big_x2 _big_x1 H); Intros.
  Apply (rem_586 _big_x1 _big_x2); Tauto.
  Apply (rem_591 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_594 : (_big_x1,_big_x2:extterm)(auto___aux_50 _big_x2) -> (auto___aux_49 _big_x1) -> (auto_knows (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_knows_crypt_4; Assumption. Defined.

Remark rem_595 : (auto_agent ext_intruder). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_agent_intruder_1; Assumption. Defined.

Remark rem_596 : (_big_x1:extterm)(auto_knows _big_x1) -> (auto_alice_key _big_x1) -> False. (* Induct. *)
Proof.
   Fix epsilon_mknows_malice_key 1.
  Intro X. Case X; First [ Intros X1; Exact (rem_50 epsilon_mknows_malice_key X1)
  | Exact (rem_54 epsilon_mknows_malice_key )
  | Exact (rem_58 epsilon_mknows_malice_key )
  |  Intros X1 X2 X3; Exact (rem_63 epsilon_mknows_malice_key X1 X2 X3)
  | Exact (rem_67 epsilon_mknows_malice_key )
  | Exact (rem_71 epsilon_mknows_malice_key )
  |  Intros X1 X2; Exact (rem_75 epsilon_mknows_malice_key X1 X2)
  |  Intros X1; Exact (rem_79 epsilon_mknows_malice_key X1)
  | Exact (rem_83 epsilon_mknows_malice_key )
  |  Intros X1 X2; Exact (rem_93 epsilon_mknows_malice_key X1 X2)
  |  Intros X1 X2; Exact (rem_116 epsilon_mknows_malice_key X1 X2)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_597 : (_big_x1:extterm)(auto_alice_key _big_x1) -> (auto_knows _big_x1) -> False. (* Split. *)
Proof.
   Intros _big_x1.
  Cut (auto_knows _big_x1) -> (auto_alice_key _big_x1) -> False. Tauto.
  Exact (rem_596 _big_x1).
Defined.

Remark rem_598 : (_big_x1:extterm)(auto_alice_key _big_x1) -> (auto_knows _big_x1) -> (auto___query__intruder_knows_session_key_as_seen_by_alice ext___star__intruder_knows_session_key_as_seen_by_alice). (* Deduce positive atom. *)
Proof.
   Intros _big_x1. Intros A1 A2.
  Cut False. Tauto.
  Exact (rem_597 _big_x1 A1 A2).
Defined.

Remark rem_599 : (_big_x1:extterm)(auto___aux_55 ext_sym) -> (auto___aux_56 (ext_current_session ext_alice ext_bob _big_x1)) -> (auto___query__intruder_knows_session_key_generated_by_server ext___star__intruder_knows_session_key_generated_by_server). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1. Intro H.
  Elim (rem_159 H); Intros.
Defined.

Remark rem_600 : (_big_x1:extterm)(auto___aux_58 (ext_current_session ext_alice ext_bob _big_x1)) -> (auto___query__intruder_knows_session_key_generated_by_server ext___star__intruder_knows_session_key_generated_by_server). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1. Intro H.
  Elim (rem_101 ext_alice ext_bob _big_x1 H); Intros.
Defined.

Remark rem_601 : (_big_x1:extterm)(auto___aux_57 ext_sym) -> (auto___aux_58 (ext_current_session ext_alice ext_bob _big_x1)) -> (auto___query__intruder_knows_session_key_generated_by_server ext___star__intruder_knows_session_key_generated_by_server). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1. Intro H.
  Elim (rem_163 H); Intros.
  Apply (rem_600 _big_x1); Tauto.
Defined.

Remark rem_602 : (auto___aux_53 ext_sym) -> (auto___query__intruder_knows_session_key_generated_by_server ext___star__intruder_knows_session_key_generated_by_server). (* Eliminate negative atom. *)
Proof.
   Intro H.
  Elim (rem_165 H); Intros.
Defined.

Remark rem_603 : (_big_x1:extterm)(auto___aux_53 ext_sym) -> (auto___aux_54 (ext_current_session ext_alice ext_bob _big_x1)) -> (auto___query__intruder_knows_session_key_generated_by_server ext___star__intruder_knows_session_key_generated_by_server). (* Eliminate negative atom by universal clause. *)
Proof.
   Intros _big_x1. Intros. Apply rem_602; Assumption.
Defined.

Remark rem_604 : (_big_x1:extterm)(auto_knows (ext_key ext_sym (ext_current_session ext_alice ext_bob _big_x1))) -> (auto___query__intruder_knows_session_key_generated_by_server ext___star__intruder_knows_session_key_generated_by_server). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1. Intro H.
  Elim (rem_115 ext_sym (ext_current_session ext_alice ext_bob _big_x1) H); Intros.
  Apply (rem_599 _big_x1); Tauto.
  Apply (rem_601 _big_x1); Tauto.
  Apply (rem_603 _big_x1); Tauto.
Defined.

Remark rem_605 : ((X:extterm)(auto_agent X) -> (auto_knows X)) -> (auto_agent ext_intruder) -> (auto_knows ext_intruder). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_knows_intruder_1; Assumption. Defined.

Remark rem_606 : ((X:extterm)(auto_agent X) -> (auto_knows X)) -> (auto_agent ext_alice) -> (auto_knows ext_alice). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_knows_alice_1; Assumption. Defined.

Remark rem_607 : ((X:extterm)(auto_agent X) -> (auto_knows X)) -> (auto_agent ext_server) -> (auto_knows ext_server). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_knows_server_1; Assumption. Defined.

Remark rem_608 : ((X:extterm)(auto_agent X) -> (auto_knows X)) -> (auto_agent ext_bob) -> (auto_knows ext_bob). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_knows_bob_1; Assumption. Defined.

Remark rem_609 : (_big_x1:extterm)(auto_agent _big_x1) -> (auto_knows _big_x1). (* Induct. *)
Proof.
   Fix epsilon_magent_pknows 1.
  Intro X. Case X; First [Exact (rem_605 epsilon_magent_pknows )
  | Exact (rem_606 epsilon_magent_pknows )
  | Exact (rem_607 epsilon_magent_pknows )
  | Exact (rem_608 epsilon_magent_pknows )
  |  Intros until 1; Inversion H].
Defined.

Remark rem_610 : (_big_x1:extterm)(auto_agent _big_x1) -> (auto_knows _big_x1). (* Split. *)
Proof.
   Intros _big_x1.
  Cut (auto_agent _big_x1) -> (auto_knows _big_x1). Tauto.
  Exact (rem_609 _big_x1).
Defined.

Remark rem_611 : (auto_knows ext_nil). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_knows_nil_1; Assumption. Defined.

Remark rem_612 : (_big_x1,_big_x2:extterm)(auto___aux_17 _big_x2) -> (auto___aux_16 _big_x1) -> (auto_knows (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_knows_crypt_1; Assumption. Defined.

Remark rem_613 : (_big_x1,_big_x2:extterm)(auto_knows _big_x2) -> (auto_knows _big_x1) -> (auto_knows _big_x1). (* Tautology. *)
Proof. Tauto. Defined.

Remark rem_614 : (_big_x1,_big_x2:extterm)(auto_knows (ext_cons _big_x2 _big_x1)) -> (auto_knows _big_x1). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_74 _big_x2 _big_x1 H); Intros.
  Apply (rem_613 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_615 : (_big_x1,_big_x2:extterm)(auto___aux_54 _big_x2) -> (auto___aux_53 _big_x1) -> (auto_knows (ext_key _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_knows_key_3; Assumption. Defined.

Remark rem_616 : (_big_x1,_big_x2:extterm)(auto___aux_47 _big_x2) -> (auto___aux_46 _big_x1) -> (auto_alice_key (ext_key _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_alice_key_key_1; Assumption. Defined.

Remark rem_617 : (_big_x1,_big_x2:extterm)(auto_knows _big_x1) -> (auto_knows _big_x2) -> (auto_knows _big_x1). (* Tautology. *)
Proof. Tauto. Defined.

Remark rem_618 : (_big_x1,_big_x2:extterm)(auto_knows (ext_cons _big_x1 _big_x2)) -> (auto_knows _big_x1). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_74 _big_x1 _big_x2 H); Intros.
  Apply (rem_617 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_619 : (_big_x1,_big_x2:extterm)(auto_knows _big_x1) -> (auto___aux_58 _big_x2) -> (auto___aux_5 _big_x2) -> (auto_knows _big_x1). (* Tautology. *)
Proof. Tauto. Defined.

Remark rem_620 : (X1,X2,X3:extterm)(auto___aux_35 (ext_old_session X1 X2 X3)) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_621 : ((X:extterm)(auto___aux_5 X) -> (auto___aux_35 X) -> False) -> (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_35 (ext_old_session _big_x1 _big_x2 _big_x3)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_m__aux_5_m__aux_35. Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_620 _big_x1 _big_x2 _big_x3 H); Intros.
Defined.

Remark rem_622 : (X1,X2,X3:extterm)(auto___aux_5 (ext_old_session X1 X2 X3)) -> (or_1
    True).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_623 : ((X:extterm)(auto___aux_5 X) -> (auto___aux_35 X) -> False) -> (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_5 (ext_old_session _big_x1 _big_x2 _big_x3)) -> (auto___aux_35 (ext_old_session _big_x1 _big_x2 _big_x3)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_m__aux_5_m__aux_35. Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_622 _big_x1 _big_x2 _big_x3 H); Intros.
  Apply (rem_621 epsilon_m__aux_5_m__aux_35 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_624 : (_big_x2:extterm)(auto___aux_5 _big_x2) -> (auto___aux_35 _big_x2) -> False. (* Induct. *)
Proof.
   Fix epsilon_m__aux_5_m__aux_35 1.
  Intro X. Case X; First [ Intros X1 X2 X3; Exact (rem_623 epsilon_m__aux_5_m__aux_35 X1 X2 X3)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_625 : (_big_x1,_big_x2:extterm)(auto___aux_36 _big_x1) -> (auto___aux_35 _big_x2) -> (auto___aux_5 _big_x2) -> (auto_knows _big_x1). (* Split. *)
Proof.
   Intros _big_x1 _big_x2.
  Cut (auto___aux_5 _big_x2) -> (auto___aux_35 _big_x2) -> False. Tauto.
  Exact (rem_624 _big_x2).
Defined.

Remark rem_626 : (X1,X2,X3:extterm)(auto___aux_25 (ext_old_session X1 X2 X3)) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_627 : ((X:extterm)(auto___aux_5 X) -> (auto___aux_25 X) -> False) -> (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_25 (ext_old_session _big_x1 _big_x2 _big_x3)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_m__aux_5_m__aux_25. Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_626 _big_x1 _big_x2 _big_x3 H); Intros.
Defined.

Remark rem_628 : ((X:extterm)(auto___aux_5 X) -> (auto___aux_25 X) -> False) -> (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_5 (ext_old_session _big_x1 _big_x2 _big_x3)) -> (auto___aux_25 (ext_old_session _big_x1 _big_x2 _big_x3)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_m__aux_5_m__aux_25. Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_622 _big_x1 _big_x2 _big_x3 H); Intros.
  Apply (rem_627 epsilon_m__aux_5_m__aux_25 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_629 : (_big_x2:extterm)(auto___aux_5 _big_x2) -> (auto___aux_25 _big_x2) -> False. (* Induct. *)
Proof.
   Fix epsilon_m__aux_5_m__aux_25 1.
  Intro X. Case X; First [ Intros X1 X2 X3; Exact (rem_628 epsilon_m__aux_5_m__aux_25 X1 X2 X3)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_630 : (_big_x2:extterm)(auto___aux_5 _big_x2) -> (auto___aux_25 _big_x2) -> (auto___aux_47 _big_x2) -> False. (* Subsumption by simpler clause. *)
Proof.
   Intros _big_x2.
  Cut (auto___aux_5 _big_x2) -> (auto___aux_25 _big_x2) -> False. Tauto. Exact (rem_629 _big_x2).
Defined.

Remark rem_631 : (_big_x1,_big_x2:extterm)(auto___aux_51 _big_x1) -> (auto___aux_25 _big_x2) -> (auto___aux_47 _big_x2) -> (auto___aux_5 _big_x2) -> (auto_knows _big_x1). (* Split. *)
Proof.
   Intros _big_x1 _big_x2.
  Cut (auto___aux_5 _big_x2) -> (auto___aux_25 _big_x2) -> (auto___aux_47 _big_x2) -> False. Tauto.
  Exact (rem_630 _big_x2).
Defined.

Remark rem_632 : (X1,X2,X3:extterm)(auto___aux_32 (ext_old_session X1 X2 X3)) -> or_0.
Proof.
  Intros. Inversion H.
Qed.

Remark rem_633 : ((X:extterm)(auto___aux_5 X) -> (auto___aux_32 X) -> False) -> (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_32 (ext_old_session _big_x1 _big_x2 _big_x3)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_m__aux_5_m__aux_32. Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_632 _big_x1 _big_x2 _big_x3 H); Intros.
Defined.

Remark rem_634 : ((X:extterm)(auto___aux_5 X) -> (auto___aux_32 X) -> False) -> (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_5 (ext_old_session _big_x1 _big_x2 _big_x3)) -> (auto___aux_32 (ext_old_session _big_x1 _big_x2 _big_x3)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_m__aux_5_m__aux_32. Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_622 _big_x1 _big_x2 _big_x3 H); Intros.
  Apply (rem_633 epsilon_m__aux_5_m__aux_32 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_635 : (_big_x2:extterm)(auto___aux_5 _big_x2) -> (auto___aux_32 _big_x2) -> False. (* Induct. *)
Proof.
   Fix epsilon_m__aux_5_m__aux_32 1.
  Intro X. Case X; First [ Intros X1 X2 X3; Exact (rem_634 epsilon_m__aux_5_m__aux_32 X1 X2 X3)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_636 : (_big_x1,_big_x2:extterm)(auto___aux_28 _big_x1) -> (auto___aux_32 _big_x2) -> (auto___aux_5 _big_x2) -> (auto_knows _big_x1). (* Split. *)
Proof.
   Intros _big_x1 _big_x2.
  Cut (auto___aux_5 _big_x2) -> (auto___aux_32 _big_x2) -> False. Tauto.
  Exact (rem_635 _big_x2).
Defined.

Remark rem_637 : (_big_x2:extterm)(auto___aux_5 _big_x2) -> (auto___aux_35 _big_x2) -> False. (* Induct. *)
Proof.
   Fix epsilon_m__aux_5_m__aux_35 1.
  Intro X. Case X; First [ Intros X1 X2 X3; Exact (rem_623 epsilon_m__aux_5_m__aux_35 X1 X2 X3)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_638 : (_big_x1,_big_x2:extterm)(auto___aux_16 _big_x1) -> (auto___aux_35 _big_x2) -> (auto___aux_5 _big_x2) -> (auto_knows _big_x1). (* Split. *)
Proof.
   Intros _big_x1 _big_x2.
  Cut (auto___aux_5 _big_x2) -> (auto___aux_35 _big_x2) -> False. Tauto.
  Exact (rem_637 _big_x2).
Defined.

Remark rem_639 : ((X:extterm)(auto___aux_5 X) -> (auto___aux_25 X) -> False) -> (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_25 (ext_old_session _big_x1 _big_x2 _big_x3)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_m__aux_5_m__aux_25. Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_626 _big_x1 _big_x2 _big_x3 H); Intros.
Defined.

Remark rem_640 : ((X:extterm)(auto___aux_5 X) -> (auto___aux_25 X) -> False) -> (_big_x1,_big_x2,_big_x3:extterm)(auto___aux_5 (ext_old_session _big_x1 _big_x2 _big_x3)) -> (auto___aux_25 (ext_old_session _big_x1 _big_x2 _big_x3)) -> False. (* Eliminate negative atom. *)
Proof.
   Intros epsilon_m__aux_5_m__aux_25. Intros _big_x1 _big_x2 _big_x3. Intro H.
  Elim (rem_622 _big_x1 _big_x2 _big_x3 H); Intros.
  Apply (rem_639 epsilon_m__aux_5_m__aux_25 _big_x1 _big_x2 _big_x3); Tauto.
Defined.

Remark rem_641 : (_big_x2:extterm)(auto___aux_5 _big_x2) -> (auto___aux_25 _big_x2) -> False. (* Induct. *)
Proof.
   Fix epsilon_m__aux_5_m__aux_25 1.
  Intro X. Case X; First [ Intros X1 X2 X3; Exact (rem_640 epsilon_m__aux_5_m__aux_25 X1 X2 X3)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_642 : (_big_x1,_big_x2:extterm)(auto___aux_49 _big_x1) -> (auto___aux_25 _big_x2) -> (auto___aux_5 _big_x2) -> (auto_knows _big_x1). (* Split. *)
Proof.
   Intros _big_x1 _big_x2.
  Cut (auto___aux_5 _big_x2) -> (auto___aux_25 _big_x2) -> False. Tauto.
  Exact (rem_641 _big_x2).
Defined.

Remark rem_643 : (_big_x2:extterm)(auto___aux_5 _big_x2) -> (auto___aux_32 _big_x2) -> False. (* Induct. *)
Proof.
   Fix epsilon_m__aux_5_m__aux_32 1.
  Intro X. Case X; First [ Intros X1 X2 X3; Exact (rem_634 epsilon_m__aux_5_m__aux_32 X1 X2 X3)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_644 : (_big_x1,_big_x2:extterm)(auto___aux_43 _big_x1) -> (auto___aux_32 _big_x2) -> (auto___aux_5 _big_x2) -> (auto_knows _big_x1). (* Split. *)
Proof.
   Intros _big_x1 _big_x2.
  Cut (auto___aux_5 _big_x2) -> (auto___aux_32 _big_x2) -> False. Tauto.
  Exact (rem_643 _big_x2).
Defined.

Remark rem_645 : (X1,X2:extterm)(auto___aux_6 (ext___tuple____aux_6 X1 X2)) -> (or_7
    ((auto_knows X1) /\ (auto___aux_58 X2))
    ((auto___aux_36 X1) /\ (auto___aux_35 X2))
    ((auto___aux_51 X1) /\ (auto___aux_25 X2) /\ (auto___aux_47 X2))
    ((auto___aux_28 X1) /\ (auto___aux_32 X2))
    ((auto___aux_16 X1) /\ (auto___aux_35 X2))
    ((auto___aux_49 X1) /\ (auto___aux_25 X2))
    ((auto___aux_43 X1) /\ (auto___aux_32 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_7_intro_1; Tauto.
  Intros. Apply or_7_intro_2; Tauto.
  Intros. Apply or_7_intro_3; Tauto.
  Intros. Apply or_7_intro_4; Tauto.
  Intros. Apply or_7_intro_5; Tauto.
  Intros. Apply or_7_intro_6; Tauto.
  Intros. Apply or_7_intro_7; Tauto.
Qed.

Remark rem_646 : (_big_x1,_big_x2:extterm)(auto___aux_6 (ext___tuple____aux_6 _big_x1 _big_x2)) -> (auto___aux_5 _big_x2) -> (auto_knows _big_x1). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_645 _big_x1 _big_x2 H); Intros.
  Apply (rem_619 _big_x1 _big_x2); Tauto.
  Apply (rem_625 _big_x1 _big_x2); Tauto.
  Apply (rem_631 _big_x1 _big_x2); Tauto.
  Apply (rem_636 _big_x1 _big_x2); Tauto.
  Apply (rem_638 _big_x1 _big_x2); Tauto.
  Apply (rem_642 _big_x1 _big_x2); Tauto.
  Apply (rem_644 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_647 : (_big_x1,_big_x2:extterm)(auto___aux_56 _big_x2) -> (auto_knows _big_x1) -> (auto_knows _big_x1). (* Tautology. *)
Proof. Tauto. Defined.

Remark rem_648 : (X1,X2:extterm)(auto___aux_4 (ext___tuple____aux_4 X1 X2)) -> (or_1
    ((auto___aux_56 X1) /\ (auto_knows X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_649 : (_big_x1,_big_x2:extterm)(auto___aux_4 (ext___tuple____aux_4 _big_x2 _big_x1)) -> (auto_knows _big_x1). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_648 _big_x2 _big_x1 H); Intros.
  Apply (rem_647 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_650 : (_big_x1,_big_x2:extterm)(auto___aux_4 (ext___tuple____aux_4 _big_x2 _big_x1)) -> (auto___aux_3 _big_x2) -> (auto_knows _big_x1). (* Eliminate negative atom by universal clause. *)
Proof.
   Intros _big_x1 _big_x2. Intros. Apply (rem_649 _big_x1 _big_x2); Assumption.
Defined.

Remark rem_651 : (_big_x1:extterm)(auto_knows _big_x1) -> (auto_knows (ext_s _big_x1)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_knows_s_1; Assumption. Defined.

Remark rem_652 : (_big_x1:extterm)(auto_knows _big_x1) -> (auto_knows _big_x1). (* Tautology. *)
Proof. Tauto. Defined.

Remark rem_653 : (_big_x1:extterm)(auto_knows (ext_s _big_x1)) -> (auto_knows _big_x1). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1. Intro H.
  Elim (rem_49 _big_x1 H); Intros.
  Apply (rem_652 _big_x1); Tauto.
Defined.

Remark rem_654 : (_big_x1,_big_x2:extterm)(auto___aux_54 _big_x2) -> (auto_knows _big_x1) -> (auto___aux_1 _big_x2) -> (auto_knows _big_x1). (* Tautology. *)
Proof. Tauto. Defined.

Remark rem_655 : (X1,X2:extterm)(auto___aux_2 (ext___tuple____aux_2 X1 X2)) -> (or_1
    ((auto___aux_54 X1) /\ (auto_knows X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_656 : (_big_x1,_big_x2:extterm)(auto___aux_2 (ext___tuple____aux_2 _big_x2 _big_x1)) -> (auto___aux_1 _big_x2) -> (auto_knows _big_x1). (* Eliminate negative atom. *)
Proof.
   Intros _big_x1 _big_x2. Intro H.
  Elim (rem_655 _big_x2 _big_x1 H); Intros.
  Apply (rem_654 _big_x1 _big_x2); Tauto.
Defined.

Remark rem_657 : ((X:extterm)(auto___aux_8 X) -> (auto_knows X)) -> ((X:extterm)(auto___aux_9 X) -> (auto_knows X)) -> (auto___aux_9 ext_bob) -> (auto_knows ext_bob). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_knows_bob_1; Assumption. Defined.

Remark rem_658 : ((X:extterm)(auto___aux_8 X) -> (auto_knows X)) -> (_big_x1:extterm)(auto___aux_9 _big_x1) -> (auto_knows _big_x1). (* Induct. *)
Proof.
   Intros epsilon_m__aux_8_pknows. Fix epsilon_m__aux_9_pknows 1.
  Intro X. Case X; First [Exact (rem_657 epsilon_m__aux_8_pknows epsilon_m__aux_9_pknows )
  |  Intros until 1; Inversion H].
Defined.

Remark rem_659 : ((X:extterm)(auto___aux_8 X) -> (auto_knows X)) -> ((X:extterm)(auto___aux_11 X) -> (auto_knows X)) -> ((X:extterm)(auto___aux_10 X) -> (auto_knows X)) -> (_big_x1:extterm)(auto___aux_13 _big_x1) -> (auto_knows (ext_noncea _big_x1)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_knows_noncea_1; Assumption. Defined.

Remark rem_660 : (X1:extterm)(auto___aux_11 (ext_noncea X1)) -> (or_1
    (auto___aux_13 X1)).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_661 : ((X:extterm)(auto___aux_8 X) -> (auto_knows X)) -> ((X:extterm)(auto___aux_11 X) -> (auto_knows X)) -> ((X:extterm)(auto___aux_10 X) -> (auto_knows X)) -> (_big_x1:extterm)(auto___aux_11 (ext_noncea _big_x1)) -> (auto_knows (ext_noncea _big_x1)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_m__aux_8_pknows epsilon_m__aux_11_pknows epsilon_m__aux_10_pknows. Intros _big_x1. Intro H.
  Elim (rem_660 _big_x1 H); Intros.
  Apply (rem_659 epsilon_m__aux_8_pknows epsilon_m__aux_11_pknows epsilon_m__aux_10_pknows _big_x1); Tauto.
Defined.

Remark rem_662 : ((X:extterm)(auto___aux_8 X) -> (auto_knows X)) -> ((X:extterm)(auto___aux_10 X) -> (auto_knows X)) -> (_big_x1:extterm)(auto___aux_11 _big_x1) -> (auto_knows _big_x1). (* Induct. *)
Proof.
   Intros epsilon_m__aux_8_pknows epsilon_m__aux_10_pknows. Fix epsilon_m__aux_11_pknows 1.
  Intro X. Case X; First [ Intros X1; Exact (rem_661 epsilon_m__aux_8_pknows epsilon_m__aux_11_pknows epsilon_m__aux_10_pknows X1)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_663 : ((X:extterm)(auto___aux_8 X) -> (auto_knows X)) -> ((X:extterm)(auto___aux_10 X) -> (auto_knows X)) -> ((X:extterm)(auto___aux_12 X) -> (auto_knows X)) -> (auto___aux_12 ext_nil) -> (auto_knows ext_nil). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_knows_nil_1; Assumption. Defined.

Remark rem_664 : ((X:extterm)(auto___aux_8 X) -> (auto_knows X)) -> ((X:extterm)(auto___aux_10 X) -> (auto_knows X)) -> (_big_x2:extterm)(auto___aux_12 _big_x2) -> (auto_knows _big_x2). (* Induct. *)
Proof.
   Intros epsilon_m__aux_8_pknows epsilon_m__aux_10_pknows. Fix epsilon_m__aux_12_pknows 1.
  Intro X. Case X; First [Exact (rem_663 epsilon_m__aux_8_pknows epsilon_m__aux_10_pknows epsilon_m__aux_12_pknows )
  |  Intros until 1; Inversion H].
Defined.

Remark rem_665 : ((X:extterm)(auto___aux_8 X) -> (auto_knows X)) -> ((X:extterm)(auto___aux_10 X) -> (auto_knows X)) -> (_big_x1,_big_x2:extterm)(auto___aux_11 _big_x1) -> (auto___aux_12 _big_x2) -> ((auto_knows _big_x1) /\ (auto_knows _big_x2)) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
   Intros epsilon_m__aux_8_pknows epsilon_m__aux_10_pknows. Intros _big_x1 _big_x2. Intros A1 A2.
  Cut (auto_knows _big_x1). 2:Apply (rem_662 epsilon_m__aux_8_pknows epsilon_m__aux_10_pknows _big_x1); Assumption.
  Cut (auto_knows _big_x2). 2:Apply (rem_664 epsilon_m__aux_8_pknows epsilon_m__aux_10_pknows _big_x2); Assumption.
  Tauto.
Defined.

Remark rem_666 : ((X:extterm)(auto___aux_8 X) -> (auto_knows X)) -> ((X:extterm)(auto___aux_10 X) -> (auto_knows X)) -> (_big_x1,_big_x2:extterm)(auto___aux_11 _big_x1) -> (auto___aux_12 _big_x2) -> (auto_knows (ext_cons _big_x1 _big_x2)). (* Deduce positive atom. *)
Proof.
   Intros epsilon_m__aux_8_pknows epsilon_m__aux_10_pknows. Intros _big_x1 _big_x2. Intros A1 A2.
  Case (rem_665 epsilon_m__aux_8_pknows epsilon_m__aux_10_pknows _big_x1 _big_x2 A1 A2). Clear epsilon_m__aux_8_pknows epsilon_m__aux_10_pknows A1 A2. Intros. Apply trans_knows_cons_1; Tauto.
  Clear epsilon_m__aux_8_pknows epsilon_m__aux_10_pknows A1 A2. Tauto.
Defined.

Remark rem_667 : (X1,X2:extterm)(auto___aux_10 (ext_cons X1 X2)) -> (or_1
    ((auto___aux_11 X1) /\ (auto___aux_12 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_668 : ((X:extterm)(auto___aux_8 X) -> (auto_knows X)) -> ((X:extterm)(auto___aux_10 X) -> (auto_knows X)) -> (_big_x1,_big_x2:extterm)(auto___aux_10 (ext_cons _big_x1 _big_x2)) -> (auto_knows (ext_cons _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_m__aux_8_pknows epsilon_m__aux_10_pknows. Intros _big_x1 _big_x2. Intro H.
  Elim (rem_667 _big_x1 _big_x2 H); Intros.
  Apply (rem_666 epsilon_m__aux_8_pknows epsilon_m__aux_10_pknows _big_x1 _big_x2); Tauto.
Defined.

Remark rem_669 : ((X:extterm)(auto___aux_8 X) -> (auto_knows X)) -> (_big_x2:extterm)(auto___aux_10 _big_x2) -> (auto_knows _big_x2). (* Induct. *)
Proof.
   Intros epsilon_m__aux_8_pknows. Fix epsilon_m__aux_10_pknows 1.
  Intro X. Case X; First [ Intros X1 X2; Exact (rem_668 epsilon_m__aux_8_pknows epsilon_m__aux_10_pknows X1 X2)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_670 : ((X:extterm)(auto___aux_8 X) -> (auto_knows X)) -> (_big_x1,_big_x2:extterm)(auto___aux_9 _big_x1) -> (auto___aux_10 _big_x2) -> ((auto_knows _big_x1) /\ (auto_knows _big_x2)) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
   Intros epsilon_m__aux_8_pknows. Intros _big_x1 _big_x2. Intros A1 A2.
  Cut (auto_knows _big_x1). 2:Apply (rem_658 epsilon_m__aux_8_pknows _big_x1); Assumption.
  Cut (auto_knows _big_x2). 2:Apply (rem_669 epsilon_m__aux_8_pknows _big_x2); Assumption.
  Tauto.
Defined.

Remark rem_671 : ((X:extterm)(auto___aux_8 X) -> (auto_knows X)) -> (_big_x1,_big_x2:extterm)(auto___aux_9 _big_x1) -> (auto___aux_10 _big_x2) -> (auto_knows (ext_cons _big_x1 _big_x2)). (* Deduce positive atom. *)
Proof.
   Intros epsilon_m__aux_8_pknows. Intros _big_x1 _big_x2. Intros A1 A2.
  Case (rem_670 epsilon_m__aux_8_pknows _big_x1 _big_x2 A1 A2). Clear epsilon_m__aux_8_pknows A1 A2. Intros. Apply trans_knows_cons_1; Tauto.
  Clear epsilon_m__aux_8_pknows A1 A2. Tauto.
Defined.

Remark rem_672 : (X1,X2:extterm)(auto___aux_8 (ext_cons X1 X2)) -> (or_1
    ((auto___aux_9 X1) /\ (auto___aux_10 X2))
).
Proof.
  Intros. Inversion H.
  Intros. Apply or_1_intro_1; Tauto.
Qed.

Remark rem_673 : ((X:extterm)(auto___aux_8 X) -> (auto_knows X)) -> (_big_x1,_big_x2:extterm)(auto___aux_8 (ext_cons _big_x1 _big_x2)) -> (auto_knows (ext_cons _big_x1 _big_x2)). (* Eliminate negative atom. *)
Proof.
   Intros epsilon_m__aux_8_pknows. Intros _big_x1 _big_x2. Intro H.
  Elim (rem_672 _big_x1 _big_x2 H); Intros.
  Apply (rem_671 epsilon_m__aux_8_pknows _big_x1 _big_x2); Tauto.
Defined.

Remark rem_674 : (_big_x2:extterm)(auto___aux_8 _big_x2) -> (auto_knows _big_x2). (* Induct. *)
Proof.
   Fix epsilon_m__aux_8_pknows 1.
  Intro X. Case X; First [ Intros X1 X2; Exact (rem_673 epsilon_m__aux_8_pknows X1 X2)
  |  Intros until 1; Inversion H].
Defined.

Remark rem_675 : ((X:extterm)(auto___aux_7 X) -> (auto_knows X)) -> (auto___aux_7 ext_alice) -> (auto_knows ext_alice). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_knows_alice_1; Assumption. Defined.

Remark rem_676 : (_big_x1:extterm)(auto___aux_7 _big_x1) -> (auto_knows _big_x1). (* Induct. *)
Proof.
   Fix epsilon_m__aux_7_pknows 1.
  Intro X. Case X; First [Exact (rem_675 epsilon_m__aux_7_pknows )
  |  Intros until 1; Inversion H].
Defined.

Remark rem_677 : (_big_x1,_big_x2:extterm)(auto___aux_8 _big_x2) -> (auto___aux_7 _big_x1) -> ((auto_knows _big_x1) /\ (auto_knows _big_x2)) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
   Intros _big_x1 _big_x2. Intros A1 A2.
  Cut (auto_knows _big_x2). 2:Apply (rem_674 _big_x2); Assumption.
  Cut (auto_knows _big_x1). 2:Apply (rem_676 _big_x1); Assumption.
  Tauto.
Defined.

Remark rem_678 : (_big_x1,_big_x2:extterm)(auto___aux_8 _big_x2) -> (auto___aux_7 _big_x1) -> (auto_knows (ext_cons _big_x1 _big_x2)). (* Deduce positive atom. *)
Proof.
   Intros _big_x1 _big_x2. Intros A1 A2.
  Case (rem_677 _big_x1 _big_x2 A1 A2). Clear A1 A2. Intros. Apply trans_knows_cons_1; Tauto.
  Clear A1 A2. Tauto.
Defined.

Remark rem_679 : (_big_x1,_big_x2:extterm)(auto___aux_56 _big_x2) -> (auto___aux_55 _big_x1) -> (auto_knows (ext_key _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_knows_key_1; Assumption. Defined.

Remark rem_680 : (_big_x1,_big_x2:extterm)(auto___aux_58 _big_x2) -> (auto___aux_57 _big_x1) -> (auto_knows (ext_key _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_knows_key_2; Assumption. Defined.

Remark rem_681 : (auto_agent ext_alice). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_agent_alice_1; Assumption. Defined.

Remark rem_682 : (auto_agent ext_bob). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_agent_bob_1; Assumption. Defined.

Remark rem_683 : (_big_x1,_big_x2:extterm)(auto___aux_17 _big_x2) -> (auto___aux_36 _big_x1) -> (auto_knows (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_knows_crypt_6; Assumption. Defined.

Remark rem_684 : (_big_x1,_big_x2:extterm)(auto_knows _big_x2) -> (auto_knows _big_x1) -> (auto_knows (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_knows_crypt_7; Assumption. Defined.

Remark rem_685 : (_big_x1,_big_x2:extterm)(auto___aux_52 _big_x2) -> (auto___aux_51 _big_x1) -> (auto_knows (ext_crypt _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_knows_crypt_3; Assumption. Defined.

Remark rem_686 : (_big_x1,_big_x2:extterm)(auto_knows _big_x2) -> (auto_knows _big_x1) -> (auto_knows (ext_cons _big_x1 _big_x2)). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_knows_cons_1; Assumption. Defined.

Remark rem_687 : (auto_agent ext_server). (* Subsumed by automaton clause. *)
Proof. Intros. Apply trans_agent_server_1; Assumption. Defined.

(* [trnp] Proofs of translated source clauses. *)


Lemma lem_intruder_knows_session_key_as_seen_by_alice : (Kab:extterm)(auto_knows Kab) -> (auto_alice_key Kab) -> (auto___query__intruder_knows_session_key_as_seen_by_alice ext___star__intruder_knows_session_key_as_seen_by_alice).
Proof.
   Intros Kab. Intros H1 H2.
  Exact (rem_598 Kab
          H2
          H1).
Qed.

Lemma lem_intruder_knows_session_key_generated_by_server : (Na:extterm)(auto_knows (ext_key ext_sym (ext_current_session ext_alice ext_bob Na))) -> (auto___query__intruder_knows_session_key_generated_by_server ext___star__intruder_knows_session_key_generated_by_server).
Proof.
   Intros Na. Intros H1.
  Exact (rem_604 Na
          H1).
Qed.

Lemma lem_intruder_knows_all_previous_session_keys : (A,B,Na:extterm)(auto_knows (ext_key ext_sym (ext_old_session A B Na))).
Proof.
   Intros A B Na.
  Exact (rem_680 ext_sym (ext_old_session A B Na)
          (rem_291 A B Na)
          rem_246).
Qed.

Lemma lem_intruder_knows_own_private_key : (auto_knows (ext_key ext_prv ext_intruder)).
Proof.
  
  Exact (rem_679 ext_prv ext_intruder
          rem_6
          rem_346).
Qed.

Lemma lem_intruder_knows_every_public_key : (X:extterm)(auto_knows (ext_key ext_pub X)).
Proof.
   Intros X.
  Exact (rem_615 ext_pub X
          (rem_548 X)
          rem_308).
Qed.

Lemma lem_alice_answers_confirmation_challenge : (Kab,Nb:extterm)(auto_knows (ext_crypt Nb Kab)) -> (auto_alice_key Kab) -> (auto_knows (ext_crypt (ext_s Nb) Kab)).
Proof.
   Intros Kab Nb. Intros H1 H2.
  Exact (rem_685 (ext_s Nb) Kab
          (rem_425 Kab Nb
            H1
            H2)
          (rem_121 Nb Kab
            H1
            H2)).
Qed.

Lemma lem_intruder_knows_all_agents : (X:extterm)(auto_agent X) -> (auto_knows X).
Proof.
   Intros X. Intros H1.
  Exact (rem_610 X
          H1).
Qed.

Lemma lem_intruder_is_an_agent : (auto_agent ext_intruder).
Proof.
  
  Exact rem_595.
Qed.

Lemma lem_server_is_an_agent : (auto_agent ext_server).
Proof.
  
  Exact rem_687.
Qed.

Lemma lem_bob_is_an_agent : (auto_agent ext_bob).
Proof.
  
  Exact rem_682.
Qed.

Lemma lem_alice_is_an_agent : (auto_agent ext_alice).
Proof.
  
  Exact rem_681.
Qed.

Lemma lem_agent_B_gets_forwarded_submessage_and_sends_confirmation_challenge : (A,B,Kab:extterm)(auto_knows (ext_crypt (ext_cons Kab (ext_cons A ext_nil)) (ext_key ext_sym (ext_cons B (ext_cons ext_server ext_nil))))) -> (auto_knows (ext_crypt (ext_nonceb Kab A B) Kab)).
Proof.
   Intros A B Kab. Intros H1.
  Exact (rem_594 (ext_nonceb Kab A B) Kab
          (rem_304 Kab A B
            (rem_172 A B Kab
              H1))
          (rem_486 Kab A B
            (rem_172 A B Kab
              H1))).
Qed.

Lemma lem_alice_gets_server_message_and_stores_current_session_key : (Mode,Msg,N,X,Y:extterm)(auto_knows (ext_crypt (ext_cons (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons (ext_key Mode (ext_current_session X Y N)) (ext_cons Msg ext_nil)))) (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil))))) -> (auto_alice_key (ext_key Mode (ext_current_session X Y N))).
Proof.
   Intros Mode Msg N X Y. Intros H1.
  Exact (rem_616 Mode (ext_current_session X Y N)
          (rem_341 X Y N Mode Msg
            (rem_547 Y X N Mode Msg
              H1))
          (rem_350 Mode Y X N Msg
            (rem_547 Y X N Mode Msg
              H1))).
Qed.

Lemma lem_alice_gets_server_message_and_forwards_submessage_to_bob : (Kab,Msg:extterm)(auto_knows (ext_crypt (ext_cons (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) (ext_cons ext_bob (ext_cons Kab (ext_cons Msg ext_nil)))) (ext_key ext_sym (ext_cons ext_alice (ext_cons ext_server ext_nil))))) -> (auto_knows Msg).
Proof.
   Intros Kab Msg. Intros H1.
  Exact (rem_593 Msg Kab
          (rem_235 Kab Msg
            H1)).
Qed.

Lemma lem_intruder_knows_previous_server_messages : (A,B,Na:extterm)(auto_knows (ext_cons A (ext_cons B (ext_cons Na ext_nil)))) -> (auto_knows (ext_crypt (ext_cons Na (ext_cons B (ext_cons (ext_key ext_sym (ext_old_session A B Na)) (ext_cons (ext_crypt (ext_cons (ext_key ext_sym (ext_old_session A B Na)) (ext_cons A ext_nil)) (ext_key ext_sym (ext_cons B (ext_cons ext_server ext_nil)))) ext_nil)))) (ext_key ext_sym (ext_cons A (ext_cons ext_server ext_nil))))).
Proof.
   Intros A B Na. Intros H1.
  Exact (rem_683 (ext_cons Na (ext_cons B (ext_cons (ext_key ext_sym (ext_old_session A B Na)) (ext_cons (ext_crypt (ext_cons (ext_key ext_sym (ext_old_session A B Na)) (ext_cons A ext_nil)) (ext_key ext_sym (ext_cons B (ext_cons ext_server ext_nil)))) ext_nil)))) (ext_key ext_sym (ext_cons A (ext_cons ext_server ext_nil)))
          (rem_292 ext_sym (ext_cons A (ext_cons ext_server ext_nil))
            (rem_307 A (ext_cons ext_server ext_nil)
              (rem_4 ext_server ext_nil
                rem_173
                rem_343)
              (rem_454 A B Na
                (rem_276 A B Na
                  H1)))
            rem_3)
          (rem_549 Na (ext_cons B (ext_cons (ext_key ext_sym (ext_old_session A B Na)) (ext_cons (ext_crypt (ext_cons (ext_key ext_sym (ext_old_session A B Na)) (ext_cons A ext_nil)) (ext_key ext_sym (ext_cons B (ext_cons ext_server ext_nil)))) ext_nil)))
            (rem_2 B (ext_cons (ext_key ext_sym (ext_old_session A B Na)) (ext_cons (ext_crypt (ext_cons (ext_key ext_sym (ext_old_session A B Na)) (ext_cons A ext_nil)) (ext_key ext_sym (ext_cons B (ext_cons ext_server ext_nil)))) ext_nil))
              (rem_278 (ext_key ext_sym (ext_old_session A B Na)) (ext_cons (ext_crypt (ext_cons (ext_key ext_sym (ext_old_session A B Na)) (ext_cons A ext_nil)) (ext_key ext_sym (ext_cons B (ext_cons ext_server ext_nil)))) ext_nil)
                (rem_345 (ext_crypt (ext_cons (ext_key ext_sym (ext_old_session A B Na)) (ext_cons A ext_nil)) (ext_key ext_sym (ext_cons B (ext_cons ext_server ext_nil)))) ext_nil
                  rem_1
                  (rem_122 (ext_cons (ext_key ext_sym (ext_old_session A B Na)) (ext_cons A ext_nil)) (ext_key ext_sym (ext_cons B (ext_cons ext_server ext_nil)))
                    (rem_342 ext_sym (ext_cons B (ext_cons ext_server ext_nil))
                      (rem_7 B (ext_cons ext_server ext_nil)
                        (rem_4 ext_server ext_nil
                          rem_173
                          rem_343)
                        (rem_338 B A Na
                          (rem_276 A B Na
                            H1)))
                      rem_3)
                    (rem_9 (ext_key ext_sym (ext_old_session A B Na)) (ext_cons A ext_nil)
                      (rem_487 A ext_nil
                        rem_1
                        (rem_454 A B Na
                          (rem_276 A B Na
                            H1)))
                      (rem_8 ext_sym (ext_old_session A B Na)
                        (rem_249 A B Na
                          (rem_276 A B Na
                            H1))
                        rem_3))))
                (rem_8 ext_sym (ext_old_session A B Na)
                  (rem_249 A B Na
                    (rem_276 A B Na
                      H1))
                  rem_3))
              (rem_338 B A Na
                (rem_276 A B Na
                  H1)))
            (rem_483 Na A B
              (rem_276 A B Na
                H1)))).
Qed.

Lemma lem_server_answers_A_with_encrypted_packet : (A,B,Na:extterm)(auto_knows (ext_cons A (ext_cons B (ext_cons Na ext_nil)))) -> (auto_knows (ext_crypt (ext_cons Na (ext_cons B (ext_cons (ext_key ext_sym (ext_current_session A B Na)) (ext_cons (ext_crypt (ext_cons (ext_key ext_sym (ext_current_session A B Na)) (ext_cons A ext_nil)) (ext_key ext_sym (ext_cons B (ext_cons ext_server ext_nil)))) ext_nil)))) (ext_key ext_sym (ext_cons A (ext_cons ext_server ext_nil))))).
Proof.
   Intros A B Na. Intros H1.
  Exact (rem_612 (ext_cons Na (ext_cons B (ext_cons (ext_key ext_sym (ext_current_session A B Na)) (ext_cons (ext_crypt (ext_cons (ext_key ext_sym (ext_current_session A B Na)) (ext_cons A ext_nil)) (ext_key ext_sym (ext_cons B (ext_cons ext_server ext_nil)))) ext_nil)))) (ext_key ext_sym (ext_cons A (ext_cons ext_server ext_nil)))
          (rem_292 ext_sym (ext_cons A (ext_cons ext_server ext_nil))
            (rem_307 A (ext_cons ext_server ext_nil)
              (rem_4 ext_server ext_nil
                rem_173
                rem_343)
              (rem_454 A B Na
                (rem_276 A B Na
                  H1)))
            rem_3)
          (rem_305 Na (ext_cons B (ext_cons (ext_key ext_sym (ext_current_session A B Na)) (ext_cons (ext_crypt (ext_cons (ext_key ext_sym (ext_current_session A B Na)) (ext_cons A ext_nil)) (ext_key ext_sym (ext_cons B (ext_cons ext_server ext_nil)))) ext_nil)))
            (rem_245 B (ext_cons (ext_key ext_sym (ext_current_session A B Na)) (ext_cons (ext_crypt (ext_cons (ext_key ext_sym (ext_current_session A B Na)) (ext_cons A ext_nil)) (ext_key ext_sym (ext_cons B (ext_cons ext_server ext_nil)))) ext_nil))
              (rem_580 (ext_key ext_sym (ext_current_session A B Na)) (ext_cons (ext_crypt (ext_cons (ext_key ext_sym (ext_current_session A B Na)) (ext_cons A ext_nil)) (ext_key ext_sym (ext_cons B (ext_cons ext_server ext_nil)))) ext_nil)
                (rem_277 (ext_crypt (ext_cons (ext_key ext_sym (ext_current_session A B Na)) (ext_cons A ext_nil)) (ext_key ext_sym (ext_cons B (ext_cons ext_server ext_nil)))) ext_nil
                  rem_1
                  (rem_5 (ext_cons (ext_key ext_sym (ext_current_session A B Na)) (ext_cons A ext_nil)) (ext_key ext_sym (ext_cons B (ext_cons ext_server ext_nil)))
                    (rem_342 ext_sym (ext_cons B (ext_cons ext_server ext_nil))
                      (rem_7 B (ext_cons ext_server ext_nil)
                        (rem_4 ext_server ext_nil
                          rem_173
                          rem_343)
                        (rem_338 B A Na
                          (rem_276 A B Na
                            H1)))
                      rem_3)
                    (rem_351 (ext_key ext_sym (ext_current_session A B Na)) (ext_cons A ext_nil)
                      (rem_487 A ext_nil
                        rem_1
                        (rem_454 A B Na
                          (rem_276 A B Na
                            H1)))
                      (rem_344 ext_sym (ext_current_session A B Na)
                        (rem_373 A B Na
                          (rem_276 A B Na
                            H1))
                        rem_3))))
                (rem_344 ext_sym (ext_current_session A B Na)
                  (rem_373 A B Na
                    (rem_276 A B Na
                      H1))
                  rem_3))
              (rem_338 B A Na
                (rem_276 A B Na
                  H1)))
            (rem_483 Na A B
              (rem_276 A B Na
                H1)))).
Qed.

Lemma lem_alice_sends_message_1_to_server : (auto_knows (ext_cons ext_alice (ext_cons ext_bob (ext_cons (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) ext_nil)))).
Proof.
  
  Exact (rem_678 ext_alice (ext_cons ext_bob (ext_cons (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) ext_nil))
          (rem_579 ext_bob (ext_cons (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) ext_nil)
            (rem_279 (ext_noncea (ext_cons ext_alice (ext_cons ext_bob ext_nil))) ext_nil
              rem_173
              (rem_244 (ext_cons ext_alice (ext_cons ext_bob ext_nil))
                (rem_306 ext_alice (ext_cons ext_bob ext_nil)
                  (rem_309 ext_bob ext_nil
                    rem_173
                    rem_581)
                  rem_488)))
            rem_581)
          rem_488).
Qed.

Lemma lem_intruder_can_compute_predecessors : (M:extterm)(auto_knows (ext_s M)) -> (auto_knows M).
Proof.
   Intros M. Intros H1.
  Exact (rem_653 M
          H1).
Qed.

Lemma lem_intruder_can_compute_successors : (M:extterm)(auto_knows M) -> (auto_knows (ext_s M)).
Proof.
   Intros M. Intros H1.
  Exact (rem_651 M
          H1).
Qed.

Lemma lem_intruder_can_decrypt_if_has_symmetric_key : (M,X:extterm)(auto_knows (ext_key ext_sym X)) -> (auto_knows (ext_crypt M (ext_key ext_sym X))) -> (auto_knows M).
Proof.
   Intros M X. Intros H1 H2.
  Exact (rem_646 M X
          (rem_578 M X
            H2)
          (rem_243 X
            H1)).
Qed.

Lemma lem_intruder_can_decrypt_if_has_public_key : (K,M:extterm)(auto_knows (ext_key ext_pub K)) -> (auto_knows (ext_crypt M (ext_key ext_prv K))) -> (auto_knows M).
Proof.
   Intros K M. Intros H1 H2.
  Exact (rem_650 M K
          (rem_371 K M
            H2)
          (rem_489 K
            H1)).
Qed.

Lemma lem_intruder_can_decrypt_if_has_private_key : (K,M:extterm)(auto_knows (ext_key ext_prv K)) -> (auto_knows (ext_crypt M (ext_key ext_pub K))) -> (auto_knows M).
Proof.
   Intros K M. Intros H1 H2.
  Exact (rem_656 M K
          (rem_272 K M
            H2)
          (rem_290 K
            H1)).
Qed.

Lemma lem_intruder_can_encrypt : (K,M:extterm)(auto_knows K) -> (auto_knows M) -> (auto_knows (ext_crypt M K)).
Proof.
   Intros K M. Intros H1 H2.
  Exact (rem_684 M K
          H1
          H2).
Qed.

Lemma lem_intruder_can_build_pairs : (M1,M2:extterm)(auto_knows M2) -> (auto_knows M1) -> (auto_knows (ext_cons M1 M2)).
Proof.
   Intros M1 M2. Intros H1 H2.
  Exact (rem_686 M1 M2
          H1
          H2).
Qed.

Lemma lem_intruder_can_take_second_components : (M1,M2:extterm)(auto_knows (ext_cons M1 M2)) -> (auto_knows M2).
Proof.
   Intros M1 M2. Intros H1.
  Exact (rem_614 M2 M1
          H1).
Qed.

Lemma lem_intruder_can_take_first_components : (M1,M2:extterm)(auto_knows (ext_cons M1 M2)) -> (auto_knows M1).
Proof.
   Intros M1 M2. Intros H1.
  Exact (rem_618 M1 M2
          H1).
Qed.

Lemma lem_intruder_knows_nil : (auto_knows ext_nil).
Proof.
  
  Exact rem_611.
Qed.


(* [srcc] Source clauses. *)

Inductive __query__intruder_knows_session_key_as_seen_by_alice : Prop :=
    intruder_knows_session_key_as_seen_by_alice : (_big_kab:term)(knows _big_kab) -> (alice_key _big_kab) -> __query__intruder_knows_session_key_as_seen_by_alice

with __query__intruder_knows_session_key_generated_by_server : Prop :=
    intruder_knows_session_key_generated_by_server : (_big_na:term)(knows (key sym (current_session alice bob _big_na))) -> __query__intruder_knows_session_key_generated_by_server

with agent : term -> Prop :=
    alice_is_an_agent : (agent alice)
  | bob_is_an_agent : (agent bob)
  | intruder_is_an_agent : (agent intruder)
  | server_is_an_agent : (agent server)

with alice_key : term -> Prop :=
    alice_gets_server_message_and_stores_current_session_key : (_big_mode,_big_msg,_big_n,_big_x,_big_y:term)(knows (crypt (cons (noncea (cons alice (cons bob nil))) (cons bob (cons (key _big_mode (current_session _big_x _big_y _big_n)) (cons _big_msg nil)))) (key sym (cons alice (cons server nil))))) -> (alice_key (key _big_mode (current_session _big_x _big_y _big_n)))

with knows : term -> Prop :=
    agent_B_gets_forwarded_submessage_and_sends_confirmation_challenge : (_big_a,_big_b,_big_kab:term)(knows (crypt (cons _big_kab (cons _big_a nil)) (key sym (cons _big_b (cons server nil))))) -> (knows (crypt (nonceb _big_kab _big_a _big_b) _big_kab))
  | alice_answers_confirmation_challenge : (_big_kab,_big_nb:term)(knows (crypt _big_nb _big_kab)) -> (alice_key _big_kab) -> (knows (crypt (s _big_nb) _big_kab))
  | alice_gets_server_message_and_forwards_submessage_to_bob : (_big_kab,_big_msg:term)(knows (crypt (cons (noncea (cons alice (cons bob nil))) (cons bob (cons _big_kab (cons _big_msg nil)))) (key sym (cons alice (cons server nil))))) -> (knows _big_msg)
  | alice_sends_message_1_to_server : (knows (cons alice (cons bob (cons (noncea (cons alice (cons bob nil))) nil))))
  | intruder_can_build_pairs : (_big_m1,_big_m2:term)(knows _big_m2) -> (knows _big_m1) -> (knows (cons _big_m1 _big_m2))
  | intruder_can_compute_predecessors : (_big_m:term)(knows (s _big_m)) -> (knows _big_m)
  | intruder_can_compute_successors : (_big_m:term)(knows _big_m) -> (knows (s _big_m))
  | intruder_can_decrypt_if_has_private_key : (_big_k,_big_m:term)(knows (key prv _big_k)) -> (knows (crypt _big_m (key pub _big_k))) -> (knows _big_m)
  | intruder_can_decrypt_if_has_public_key : (_big_k,_big_m:term)(knows (key pub _big_k)) -> (knows (crypt _big_m (key prv _big_k))) -> (knows _big_m)
  | intruder_can_decrypt_if_has_symmetric_key : (_big_m,_big_x:term)(knows (key sym _big_x)) -> (knows (crypt _big_m (key sym _big_x))) -> (knows _big_m)
  | intruder_can_encrypt : (_big_k,_big_m:term)(knows _big_k) -> (knows _big_m) -> (knows (crypt _big_m _big_k))
  | intruder_can_take_first_components : (_big_m1,_big_m2:term)(knows (cons _big_m1 _big_m2)) -> (knows _big_m1)
  | intruder_can_take_second_components : (_big_m1,_big_m2:term)(knows (cons _big_m1 _big_m2)) -> (knows _big_m2)
  | intruder_knows_all_agents : (_big_x:term)(agent _big_x) -> (knows _big_x)
  | intruder_knows_all_previous_session_keys : (_big_a,_big_b,_big_na:term)(knows (key sym (old_session _big_a _big_b _big_na)))
  | intruder_knows_every_public_key : (_big_x:term)(knows (key pub _big_x))
  | intruder_knows_nil : (knows nil)
  | intruder_knows_own_private_key : (knows (key prv intruder))
  | intruder_knows_previous_server_messages : (_big_a,_big_b,_big_na:term)(knows (cons _big_a (cons _big_b (cons _big_na nil)))) -> (knows (crypt (cons _big_na (cons _big_b (cons (key sym (old_session _big_a _big_b _big_na)) (cons (crypt (cons (key sym (old_session _big_a _big_b _big_na)) (cons _big_a nil)) (key sym (cons _big_b (cons server nil)))) nil)))) (key sym (cons _big_a (cons server nil)))))
  | server_answers_A_with_encrypted_packet : (_big_a,_big_b,_big_na:term)(knows (cons _big_a (cons _big_b (cons _big_na nil)))) -> (knows (crypt (cons _big_na (cons _big_b (cons (key sym (current_session _big_a _big_b _big_na)) (cons (crypt (cons (key sym (current_session _big_a _big_b _big_na)) (cons _big_a nil)) (key sym (cons _big_b (cons server nil)))) nil)))) (key sym (cons _big_a (cons server nil)))))
.

(* [srct] Translation from source clauses. *)

Fixpoint translate_auto___query__intruder_knows_session_key_as_seen_by_alice_from___query__intruder_knows_session_key_as_seen_by_alice [pi : __query__intruder_knows_session_key_as_seen_by_alice] : (auto___query__intruder_knows_session_key_as_seen_by_alice ext___star__intruder_knows_session_key_as_seen_by_alice) :=
  <[pi : __query__intruder_knows_session_key_as_seen_by_alice] (auto___query__intruder_knows_session_key_as_seen_by_alice ext___star__intruder_knows_session_key_as_seen_by_alice)>Cases pi of
    (intruder_knows_session_key_as_seen_by_alice _big_kab H1 H2) =>
      (lem_intruder_knows_session_key_as_seen_by_alice
        (eval_extterm_of_term _big_kab)
        (translate_auto_knows_from_knows _big_kab H1)
        (translate_auto_alice_key_from_alice_key _big_kab H2))
  end

with translate_auto___query__intruder_knows_session_key_generated_by_server_from___query__intruder_knows_session_key_generated_by_server [pi : __query__intruder_knows_session_key_generated_by_server] : (auto___query__intruder_knows_session_key_generated_by_server ext___star__intruder_knows_session_key_generated_by_server) :=
  <[pi : __query__intruder_knows_session_key_generated_by_server] (auto___query__intruder_knows_session_key_generated_by_server ext___star__intruder_knows_session_key_generated_by_server)>Cases pi of
    (intruder_knows_session_key_generated_by_server _big_na H1) =>
      (lem_intruder_knows_session_key_generated_by_server
        (eval_extterm_of_term _big_na)
        (translate_auto_knows_from_knows (key sym (current_session alice bob _big_na)) H1))
  end

with translate_auto_agent_from_agent [x1 : term; pi : (agent x1)] : (auto_agent (eval_extterm_of_term x1)) :=
  <[x1 : term; pi : (agent x1)] (auto_agent (eval_extterm_of_term x1))>Cases pi of
    (alice_is_an_agent) =>
      (lem_alice_is_an_agent)
  | (bob_is_an_agent) =>
      (lem_bob_is_an_agent)
  | (intruder_is_an_agent) =>
      (lem_intruder_is_an_agent)
  | (server_is_an_agent) =>
      (lem_server_is_an_agent)
  end

with translate_auto_alice_key_from_alice_key [x1 : term; pi : (alice_key x1)] : (auto_alice_key (eval_extterm_of_term x1)) :=
  <[x1 : term; pi : (alice_key x1)] (auto_alice_key (eval_extterm_of_term x1))>Cases pi of
    (alice_gets_server_message_and_stores_current_session_key _big_mode _big_msg _big_n _big_x _big_y H1) =>
      (lem_alice_gets_server_message_and_stores_current_session_key
        (eval_extterm_of_term _big_mode)
        (eval_extterm_of_term _big_msg)
        (eval_extterm_of_term _big_n)
        (eval_extterm_of_term _big_x)
        (eval_extterm_of_term _big_y)
        (translate_auto_knows_from_knows (crypt (cons (noncea (cons alice (cons bob nil))) (cons bob (cons (key _big_mode (current_session _big_x _big_y _big_n)) (cons _big_msg nil)))) (key sym (cons alice (cons server nil)))) H1))
  end

with translate_auto_knows_from_knows [x1 : term; pi : (knows x1)] : (auto_knows (eval_extterm_of_term x1)) :=
  <[x1 : term; pi : (knows x1)] (auto_knows (eval_extterm_of_term x1))>Cases pi of
    (agent_B_gets_forwarded_submessage_and_sends_confirmation_challenge _big_a _big_b _big_kab H1) =>
      (lem_agent_B_gets_forwarded_submessage_and_sends_confirmation_challenge
        (eval_extterm_of_term _big_a)
        (eval_extterm_of_term _big_b)
        (eval_extterm_of_term _big_kab)
        (translate_auto_knows_from_knows (crypt (cons _big_kab (cons _big_a nil)) (key sym (cons _big_b (cons server nil)))) H1))
  | (alice_answers_confirmation_challenge _big_kab _big_nb H1 H2) =>
      (lem_alice_answers_confirmation_challenge
        (eval_extterm_of_term _big_kab)
        (eval_extterm_of_term _big_nb)
        (translate_auto_knows_from_knows (crypt _big_nb _big_kab) H1)
        (translate_auto_alice_key_from_alice_key _big_kab H2))
  | (alice_gets_server_message_and_forwards_submessage_to_bob _big_kab _big_msg H1) =>
      (lem_alice_gets_server_message_and_forwards_submessage_to_bob
        (eval_extterm_of_term _big_kab)
        (eval_extterm_of_term _big_msg)
        (translate_auto_knows_from_knows (crypt (cons (noncea (cons alice (cons bob nil))) (cons bob (cons _big_kab (cons _big_msg nil)))) (key sym (cons alice (cons server nil)))) H1))
  | (alice_sends_message_1_to_server) =>
      (lem_alice_sends_message_1_to_server)
  | (intruder_can_build_pairs _big_m1 _big_m2 H1 H2) =>
      (lem_intruder_can_build_pairs
        (eval_extterm_of_term _big_m1)
        (eval_extterm_of_term _big_m2)
        (translate_auto_knows_from_knows _big_m2 H1)
        (translate_auto_knows_from_knows _big_m1 H2))
  | (intruder_can_compute_predecessors _big_m H1) =>
      (lem_intruder_can_compute_predecessors
        (eval_extterm_of_term _big_m)
        (translate_auto_knows_from_knows (s _big_m) H1))
  | (intruder_can_compute_successors _big_m H1) =>
      (lem_intruder_can_compute_successors
        (eval_extterm_of_term _big_m)
        (translate_auto_knows_from_knows _big_m H1))
  | (intruder_can_decrypt_if_has_private_key _big_k _big_m H1 H2) =>
      (lem_intruder_can_decrypt_if_has_private_key
        (eval_extterm_of_term _big_k)
        (eval_extterm_of_term _big_m)
        (translate_auto_knows_from_knows (key prv _big_k) H1)
        (translate_auto_knows_from_knows (crypt _big_m (key pub _big_k)) H2))
  | (intruder_can_decrypt_if_has_public_key _big_k _big_m H1 H2) =>
      (lem_intruder_can_decrypt_if_has_public_key
        (eval_extterm_of_term _big_k)
        (eval_extterm_of_term _big_m)
        (translate_auto_knows_from_knows (key pub _big_k) H1)
        (translate_auto_knows_from_knows (crypt _big_m (key prv _big_k)) H2))
  | (intruder_can_decrypt_if_has_symmetric_key _big_m _big_x H1 H2) =>
      (lem_intruder_can_decrypt_if_has_symmetric_key
        (eval_extterm_of_term _big_m)
        (eval_extterm_of_term _big_x)
        (translate_auto_knows_from_knows (key sym _big_x) H1)
        (translate_auto_knows_from_knows (crypt _big_m (key sym _big_x)) H2))
  | (intruder_can_encrypt _big_k _big_m H1 H2) =>
      (lem_intruder_can_encrypt
        (eval_extterm_of_term _big_k)
        (eval_extterm_of_term _big_m)
        (translate_auto_knows_from_knows _big_k H1)
        (translate_auto_knows_from_knows _big_m H2))
  | (intruder_can_take_first_components _big_m1 _big_m2 H1) =>
      (lem_intruder_can_take_first_components
        (eval_extterm_of_term _big_m1)
        (eval_extterm_of_term _big_m2)
        (translate_auto_knows_from_knows (cons _big_m1 _big_m2) H1))
  | (intruder_can_take_second_components _big_m1 _big_m2 H1) =>
      (lem_intruder_can_take_second_components
        (eval_extterm_of_term _big_m1)
        (eval_extterm_of_term _big_m2)
        (translate_auto_knows_from_knows (cons _big_m1 _big_m2) H1))
  | (intruder_knows_all_agents _big_x H1) =>
      (lem_intruder_knows_all_agents
        (eval_extterm_of_term _big_x)
        (translate_auto_agent_from_agent _big_x H1))
  | (intruder_knows_all_previous_session_keys _big_a _big_b _big_na) =>
      (lem_intruder_knows_all_previous_session_keys
        (eval_extterm_of_term _big_a)
        (eval_extterm_of_term _big_b)
        (eval_extterm_of_term _big_na))
  | (intruder_knows_every_public_key _big_x) =>
      (lem_intruder_knows_every_public_key
        (eval_extterm_of_term _big_x))
  | (intruder_knows_nil) =>
      (lem_intruder_knows_nil)
  | (intruder_knows_own_private_key) =>
      (lem_intruder_knows_own_private_key)
  | (intruder_knows_previous_server_messages _big_a _big_b _big_na H1) =>
      (lem_intruder_knows_previous_server_messages
        (eval_extterm_of_term _big_a)
        (eval_extterm_of_term _big_b)
        (eval_extterm_of_term _big_na)
        (translate_auto_knows_from_knows (cons _big_a (cons _big_b (cons _big_na nil))) H1))
  | (server_answers_A_with_encrypted_packet _big_a _big_b _big_na H1) =>
      (lem_server_answers_A_with_encrypted_packet
        (eval_extterm_of_term _big_a)
        (eval_extterm_of_term _big_b)
        (eval_extterm_of_term _big_na)
        (translate_auto_knows_from_knows (cons _big_a (cons _big_b (cons _big_na nil))) H1))
  end
.


(* [conp] Consistency proofs. *)

Theorem thm_intruder_knows_session_key_as_seen_by_alice : ~__query__intruder_knows_session_key_as_seen_by_alice.
Proof.
  Unfold not. Intro H.
  Elim (translate_auto___query__intruder_knows_session_key_as_seen_by_alice_from___query__intruder_knows_session_key_as_seen_by_alice H).
Qed.

Theorem thm_intruder_knows_session_key_generated_by_server : ~__query__intruder_knows_session_key_generated_by_server.
Proof.
  Unfold not. Intro H.
  Elim (translate_auto___query__intruder_knows_session_key_generated_by_server_from___query__intruder_knows_session_key_generated_by_server H).
Qed.

