% h1 example: the EAP-AKA protocol.
%   Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
%   This file is part of h1.
%
%   h1 is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2, or (at your option)
%   any later version.
%
%   h1 is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with h1; see the file COPYING.  If not, write to
%   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

#define KNOWS PHASE(knows)
#define NONCEA PHASE(noncea)
#define NONCEB PHASE(nonceb)
#define SESSION PHASE(session)
#define ALICE_KEY PHASE(alice_key)
#define BOB_KEY PHASE(bob_key)

cnf(PHASE(intruder_knows_nil),axiom,
  (KNOWS(nil))).
cnf(PHASE(intruder_can_take_first_components),axiom,
  (~KNOWS(cons(M1,M2)) | KNOWS(M1))).
cnf(PHASE(intruder_can_take_second_components),axiom,
  (~KNOWS(cons(M1,M2)) | KNOWS(M2))).
cnf(PHASE(intruder_can_build_pairs),axiom,
  (~KNOWS(M2) | ~KNOWS(M1) | KNOWS(cons(M1,M2)))).
cnf(PHASE(intruder_can_encrypt),axiom,
  (~KNOWS(K) | ~KNOWS(M) | KNOWS(crypt(M,K)))).
cnf(PHASE(intruder_can_decrypt_if_has_private_key),axiom,
  (~KNOWS(key(prv,K)) | ~KNOWS(crypt(M,key(pub,K))) | KNOWS(M))).
cnf(PHASE(intruder_can_decrypt_if_has_public_key),axiom,
  (~KNOWS(key(pub,K)) | ~KNOWS(crypt(M,key(prv,K))) | KNOWS(M))).
cnf(PHASE(intruder_can_decrypt_if_has_symmetric_key),axiom,
  (~KNOWS(key(sym,X)) | ~KNOWS(crypt(M,key(sym,X))) | KNOWS(M))).
cnf(PHASE(intruder_can_compute_successors),axiom,
  (~KNOWS(M) | KNOWS(s(M)))).
cnf(PHASE(intruder_can_compute_predecessors),axiom,
  (~KNOWS(s(M)) | KNOWS(M))).

%
% Ajout des clauses du protocole
%
%
cnf(PHASE(alice_sends_message_1_to_server),axiom,
  (~agent(A) | ~agent (B)
  | KNOWS(cons(A,cons(B,cons(NONCEA(A,B),nil)))))).
cnf(PHASE(server_answers_A_with_encrypted_packet),axiom,
  (~KNOWS(cons(A,cons(B,cons(Na,nil))))
    | KNOWS(crypt(cons(Na,cons(B,
                  cons(key(sym,SESSION(A,B,Na)),
                  cons(crypt(cons(key(sym,SESSION(A,B,Na)),cons(A,nil)),
                             key(sym,cons(B,cons(server,nil)))),
                  nil)))),
               key(sym,cons(A,cons(server,nil))))))).
cnf(PHASE(alice_gets_server_message_and_forwards_submessage_to_bob),axiom,
  (~KNOWS(crypt(cons(NONCEA(A,B),cons(B,cons(Kab,cons(Msg,nil)))),
          key(sym,cons(A,cons(server,nil)))))
    | KNOWS(Msg))).
cnf(PHASE(agent_B_gets_forwarded_submessage_and_sends_confirmation_challenge),axiom,
  (~KNOWS(crypt(cons(Kab,cons(A,nil)),key(sym,cons(B,cons(server,nil)))))
    | KNOWS(crypt(NONCEB(Kab,A,B),Kab)))).
cnf(PHASE(alice_answers_confirmation_challenge),axiom,
  (~KNOWS(crypt(Nb,Kab))
  | ~KNOWS(crypt(cons(NONCEA(A,B),cons(B,cons(Kab,cons(Msg,nil)))),
                 key(sym,cons(A,cons(server,nil)))))
  | KNOWS(crypt(s(Nb),Kab)))).

cnf(PHASE(intruder_knows_all_agents),axiom,
  (~agent(X) | KNOWS(X))).
cnf(PHASE(intruder_knows_every_public_key),axiom,
  (KNOWS(key(pub,X)))).
cnf(PHASE(intruder_knows_own_private_key),axiom,
  (KNOWS(key(prv,i)))).

   
cnf(PHASE(define_alice_key),axiom,
  (~KNOWS(crypt(cons(NONCEA(A,B),cons(B,cons(Kab,cons(Msg,nil)))),
          key(sym,cons(A,cons(server,nil)))))
  | ALICE_KEY(A,Kab))).
cnf(PHASE(define_bob_key),axiom,
   (~KNOWS(crypt(s(NONCEB(Kab,A,B)),Kab))
   | BOB_KEY(B,Kab))).

#undef KNOWS
#undef NONCEA
#undef NONCEB
#undef SESSION
#undef ALICE_KEY
#undef BOB_KEY
