% h1 example: the Needham-Schroeder symmetric key protocol.
%   Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
%   This file is part of h1.
%
%   h1 is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2, or (at your option)
%   any later version.
%
%   h1 is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with h1; see the file COPYING.  If not, write to
%   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.



cnf(intruder_knows_nil,axiom,
  (knows(nil))).
cnf(intruder_can_take_first_components,axiom,
  (~knows(cons(M1,M2)) | knows(M1))).
cnf(intruder_can_take_second_components,axiom,
  (~knows(cons(M1,M2)) | knows(M2))).
cnf(intruder_can_build_pairs,axiom,
  (~knows(M2) | ~knows(M1) | knows(cons(M1,M2)))).
cnf(intruder_can_encrypt,axiom,
  (~knows(K) | ~knows(M) | knows(crypt(M,K)))).
cnf(intruder_can_decrypt_if_has_private_key,axiom,
  (~knows(key(prv,K)) | ~knows(crypt(M,key(pub,K))) | knows(M))).
cnf(intruder_can_decrypt_if_has_public_key,axiom,
  (~knows(key(pub,K)) | ~knows(crypt(M,key(prv,K))) | knows(M))).
cnf(intruder_can_decrypt_if_has_symmetric_key,axiom,
  (~knows(key(sym,X)) | ~knows(crypt(M,key(sym,X))) | knows(M))).
cnf(intruder_can_compute_successors,axiom,
  (~knows(M) | knows(s(M)))).
cnf(intruder_can_compute_predecessors,axiom,
  (~knows(s(M)) | knows(M))).
cnf(alice_agent,axiom,
    (agent(alice))).
cnf(bob_agent,axiom,
    (agent(bob))).
cnf(server_agent,axiom,
    (agent(server))).
cnf(intruder_agent,axiom,
    (agent(i))).

%
% Ajout des clauses du protocole
%
%
cnf(alice_sends_message_1_to_server,axiom,
  (~agent(A) | ~agent (B)
  | knows(cons(A,cons(B,cons(noncea(A,B),nil)))))).
cnf(server_answers_A_with_encrypted_packet,axiom,
  (~knows(cons(A,cons(B,cons(Na,nil))))
    | knows(crypt(cons(Na,cons(B,
                  cons(key(sym,current_session(A,B,Na)),
                  cons(crypt(cons(key(sym,current_session(A,B,Na)),cons(A,nil)),
                             key(sym,cons(B,cons(server,nil)))),
                  nil)))),
               key(sym,cons(A,cons(server,nil))))))).
cnf(intruder_knows_previous_server_messages,axiom,
  (~knows(cons(A,cons(B,cons(Na,nil))))
    | knows(crypt(cons(Na,cons(B,
               cons(key(sym,old_session(A,B,Na)),
               cons(crypt(cons(key(sym,old_session(A,B,Na)),cons(A,nil)),
                          key(sym,cons(B,cons(server,nil)))),nil)))),
            key(sym,cons(A,cons(server,nil))))))).
cnf(alice_gets_server_message_and_forwards_submessage_to_bob,axiom,
  (~knows(crypt(cons(noncea(A,B),cons(B,cons(Kab,cons(Msg,nil)))),
          key(sym,cons(A,cons(server,nil)))))
    | knows(Msg))).
cnf(alice_gets_server_message_and_stores_current_session_key,axiom,
  (~knows(crypt(cons(noncea(A,B),cons(B,cons(Kab,cons(Msg,nil)))),
          key(sym,cons(A,cons(server,nil)))))
    | alice_key(A,Kab))).
cnf(agent_B_gets_forwarded_submessage_and_sends_confirmation_challenge,axiom,
  (~knows(crypt(cons(Kab,cons(A,nil)),key(sym,cons(B,cons(server,nil)))))
    | knows(crypt(nonceb(Kab,A,B),Kab)))).
cnf(alice_answers_confirmation_challenge,axiom,
  (~knows(crypt(Nb,Kab)) | ~alice_key(A,Kab) | knows(crypt(s(Nb),Kab)))).

cnf(intruder_knows_all_agents,axiom,
  (~agent(X) | knows(X))).
cnf(intruder_knows_every_public_key,axiom,
  (knows(key(pub,X)))).
cnf(intruder_knows_own_private_key,axiom,
  (knows(key(prv,i)))).
cnf(intruder_knows_all_previous_session_keys,axiom,
  (knows(key(sym,old_session(A,B,Na))))).

cnf(intruder_knows_session_key_generated_by_server,axiom,
  (~knows(key(sym,current_session(alice,bob,Na))))).
cnf(intruder_knows_session_key_as_seen_by_alice,axiom,
  (~knows(key(Mode,current_session(X,Y,N)))
    | ~alice_key(alice,key(Mode,current_session(X,Y,N))))).
