(* [sigd] Signature definition. *)

Inductive term : Set :=
    alice : term
  | bob : term
  | cons : term -> term -> term
  | crypt : term -> term -> term
  | current_session : term -> term -> term -> term
  | i : term
  | key : term -> term -> term
  | nil : term
  | noncea : term -> term -> term
  | nonceb : term -> term -> term -> term
  | old_session : term -> term -> term -> term
  | prv : term
  | pub : term
  | s : term -> term
  | server : term
  | sym : term
.

(* [modd] Model definition. *)

Inductive auto___type_8 : term -> Prop :=
    trans___type_8_1 : forall X:term, auto___type_8 X
with auto___def_4 : term -> Prop :=
    trans___def_4_1 : forall X:term, auto___def_4 X
with auto___def_26 : term -> Prop :=
    trans___def_26_cons_1 : forall X1 X2:term, auto___def_27 X1 -> auto___def_28 X2 -> auto___def_26 (cons X1 X2)
with auto___def_20 : term -> Prop :=
    trans___def_20_crypt_1 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_20 (crypt X1 X2)
with auto___def_30 : term -> Prop :=
    trans___def_30_cons_1 : forall X1 X2:term, auto___type_3 X1 -> auto___def_31 X2 -> auto___def_30 (cons X1 X2)
with auto___def_46 : term -> Prop :=
    trans___def_46_sym_1 : auto___def_46 sym
with auto___def_19 : term -> Prop :=
    trans___def_19_current_session_1 : forall X1 X2 X3:term, auto_knows X1 -> auto_knows X2 -> auto_knows X3 -> auto___def_19 (current_session X1 X2 X3)
with auto___def_15 : term -> Prop :=
    trans___def_15_cons_1 : forall X1 X2:term, auto___def_16 X1 -> auto___def_17 X2 -> auto___def_15 (cons X1 X2)
with auto___def_29 : term -> Prop :=
    trans___def_29_cons_1 : forall X1 X2:term, auto___type_5 X1 -> auto___def_26 X2 -> auto___def_29 (cons X1 X2)
with auto___def_47 : term -> Prop :=
    trans___def_47_old_session_1 : forall X1 X2 X3:term, auto___def_47 (old_session X1 X2 X3)
with auto___def_21 : term -> Prop :=
    trans___def_21_nil_1 : auto___def_21 nil
with auto_knows : term -> Prop :=
    trans_knows_crypt_1 : forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto_knows (crypt X1 X2)
  | trans_knows_crypt_2 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto_knows (crypt X1 X2)
  | trans_knows_crypt_3 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto_knows (crypt X1 X2)
  | trans_knows_crypt_4 : forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto_knows (crypt X1 X2)
  | trans_knows_crypt_5 : forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto_knows (crypt X1 X2)
  | trans_knows_crypt_6 : forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> auto_knows (crypt X1 X2)
  | trans_knows_crypt_7 : forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> auto_knows (crypt X1 X2)
  | trans_knows_s_1 : forall X1:term, auto_knows X1 -> auto_knows (s X1)
  | trans_knows_nil_1 : auto_knows nil
  | trans_knows_i_1 : auto_knows i
  | trans_knows_nonceb_1 : forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto_knows (nonceb X1 X2 X3)
  | trans_knows_nonceb_2 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto_knows (nonceb X1 X2 X3)
  | trans_knows_bob_1 : auto_knows bob
  | trans_knows_key_1 : forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> auto_knows (key X1 X2)
  | trans_knows_key_2 : forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto_knows (key X1 X2)
  | trans_knows_key_3 : forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> auto_knows (key X1 X2)
  | trans_knows_alice_1 : auto_knows alice
  | trans_knows_cons_1 : forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto_knows (cons X1 X2)
  | trans_knows_server_1 : auto_knows server
  | trans_knows_noncea_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_knows (noncea X1 X2)
with auto___type_7 : term -> Prop :=
    trans___type_7_key_1 : forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___type_7 (key X1 X2)
  | trans___type_7_key_2 : forall X1 X2:term, auto___def_18 X1 -> auto___def_35 X2 -> auto___type_7 (key X1 X2)
with auto___type_5 : term -> Prop :=
    trans___type_5_crypt_1 : forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto___type_5 (crypt X1 X2)
  | trans___type_5_crypt_2 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___type_5 (crypt X1 X2)
  | trans___type_5_crypt_3 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___type_5 (crypt X1 X2)
  | trans___type_5_crypt_4 : forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto___type_5 (crypt X1 X2)
  | trans___type_5_crypt_5 : forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto___type_5 (crypt X1 X2)
  | trans___type_5_crypt_6 : forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> auto___type_5 (crypt X1 X2)
  | trans___type_5_crypt_7 : forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> auto___type_5 (crypt X1 X2)
  | trans___type_5_s_1 : forall X1:term, auto_knows X1 -> auto___type_5 (s X1)
  | trans___type_5_nil_1 : auto___type_5 nil
  | trans___type_5_i_1 : auto___type_5 i
  | trans___type_5_nonceb_1 : forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_5 (nonceb X1 X2 X3)
  | trans___type_5_nonceb_2 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_5 (nonceb X1 X2 X3)
  | trans___type_5_bob_1 : auto___type_5 bob
  | trans___type_5_key_1 : forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> auto___type_5 (key X1 X2)
  | trans___type_5_key_2 : forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___type_5 (key X1 X2)
  | trans___type_5_key_3 : forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> auto___type_5 (key X1 X2)
  | trans___type_5_alice_1 : auto___type_5 alice
  | trans___type_5_cons_1 : forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto___type_5 (cons X1 X2)
  | trans___type_5_server_1 : auto___type_5 server
  | trans___type_5_noncea_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_5 (noncea X1 X2)
with auto___def_17 : term -> Prop :=
    trans___def_17_cons_1 : forall X1 X2:term, auto___def_20 X1 -> auto___def_21 X2 -> auto___def_17 (cons X1 X2)
with auto___def_44 : term -> Prop :=
    trans___def_44_prv_1 : auto___def_44 prv
with auto___type_4 : term -> Prop :=
    trans___type_4_crypt_1 : forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto___type_4 (crypt X1 X2)
  | trans___type_4_crypt_2 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___type_4 (crypt X1 X2)
  | trans___type_4_crypt_3 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___type_4 (crypt X1 X2)
  | trans___type_4_crypt_4 : forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto___type_4 (crypt X1 X2)
  | trans___type_4_crypt_5 : forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto___type_4 (crypt X1 X2)
  | trans___type_4_crypt_6 : forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> auto___type_4 (crypt X1 X2)
  | trans___type_4_crypt_7 : forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> auto___type_4 (crypt X1 X2)
  | trans___type_4_s_1 : forall X1:term, auto_knows X1 -> auto___type_4 (s X1)
  | trans___type_4_nil_1 : auto___type_4 nil
  | trans___type_4_i_1 : auto___type_4 i
  | trans___type_4_nonceb_1 : forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_4 (nonceb X1 X2 X3)
  | trans___type_4_nonceb_2 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_4 (nonceb X1 X2 X3)
  | trans___type_4_bob_1 : auto___type_4 bob
  | trans___type_4_key_1 : forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> auto___type_4 (key X1 X2)
  | trans___type_4_key_2 : forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___type_4 (key X1 X2)
  | trans___type_4_key_3 : forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> auto___type_4 (key X1 X2)
  | trans___type_4_alice_1 : auto___type_4 alice
  | trans___type_4_cons_1 : forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto___type_4 (cons X1 X2)
  | trans___type_4_server_1 : auto___type_4 server
  | trans___type_4_noncea_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_4 (noncea X1 X2)
with auto___def_23 : term -> Prop :=
    trans___def_23_key_1 : forall X1 X2:term, auto___def_18 X1 -> auto___def_25 X2 -> auto___def_23 (key X1 X2)
with auto___def_43 : term -> Prop :=
    trans___def_43_pub_1 : auto___def_43 pub
with auto___def_18 : term -> Prop :=
    trans___def_18_sym_1 : auto___def_18 sym
with auto___def_45 : term -> Prop :=
    trans___def_45_i_1 : auto___def_45 i
with auto___def_14 : term -> Prop :=
    trans___def_14_cons_1 : forall X1 X2:term, auto___type_4 X1 -> auto___def_15 X2 -> auto___def_14 (cons X1 X2)
with auto___def_25 : term -> Prop :=
    trans___def_25_cons_1 : forall X1 X2:term, auto___type_4 X1 -> auto___def_26 X2 -> auto___def_25 (cons X1 X2)
with auto___def_24 : term -> Prop :=
    trans___def_24_cons_1 : forall X1 X2:term, auto___type_5 X1 -> auto___def_21 X2 -> auto___def_24 (cons X1 X2)
with auto___def_6 : term -> Prop :=
    trans___def_6_old_session_1 : forall X1 X2 X3:term, auto___def_6 (old_session X1 X2 X3)
with auto___def_33 : term -> Prop :=
    trans___def_33_key_1 : forall X1 X2:term, auto___def_18 X1 -> auto___def_35 X2 -> auto___def_33 (key X1 X2)
with auto___def_27 : term -> Prop :=
    trans___def_27_server_1 : auto___def_27 server
with auto___def_5 : term -> term -> Prop :=
    trans___def_5_1 : forall X1 X2:term, auto___def_22 X1 -> auto___def_25 X2 -> auto___def_5 X1 X2
  | trans___def_5_2 : forall X1 X2:term, auto___def_37 X1 -> auto___def_25 X2 -> auto___def_5 X1 X2
  | trans___def_5_3 : forall X1 X2:term, auto___def_12 X1 -> auto___def_29 X2 -> auto___def_5 X1 X2
  | trans___def_5_4 : forall X1 X2:term, auto_knows X1 -> auto___def_47 X2 -> auto___def_5 X1 X2
  | trans___def_5_5 : forall X1 X2:term, auto___def_30 X1 -> auto___def_29 X2 -> auto___def_5 X1 X2
  | trans___def_5_6 : forall X1 X2:term, auto___def_42 X1 -> auto___def_19 X2 -> auto___def_5 X1 X2
  | trans___def_5_7 : forall X1 X2:term, auto___def_40 X1 -> auto___def_19 X2 -> auto___def_5 X1 X2
with auto___def_12 : term -> Prop :=
    trans___def_12_cons_1 : forall X1 X2:term, auto___type_3 X1 -> auto___def_14 X2 -> auto___def_12 (cons X1 X2)
with auto___type_2 : term -> Prop :=
    trans___type_2_i_1 : auto___type_2 i
  | trans___type_2_bob_1 : auto___type_2 bob
  | trans___type_2_alice_1 : auto___type_2 alice
  | trans___type_2_server_1 : auto___type_2 server
with auto___def_2 : term -> Prop :=
    trans___def_2_i_1 : auto___def_2 i
with auto___def_36 : term -> Prop :=
    trans___def_36_crypt_1 : forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto___def_36 (crypt X1 X2)
with auto___type_3 : term -> Prop :=
    trans___type_3_crypt_1 : forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto___type_3 (crypt X1 X2)
  | trans___type_3_crypt_2 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___type_3 (crypt X1 X2)
  | trans___type_3_crypt_3 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___type_3 (crypt X1 X2)
  | trans___type_3_crypt_4 : forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto___type_3 (crypt X1 X2)
  | trans___type_3_crypt_5 : forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto___type_3 (crypt X1 X2)
  | trans___type_3_crypt_6 : forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> auto___type_3 (crypt X1 X2)
  | trans___type_3_crypt_7 : forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> auto___type_3 (crypt X1 X2)
  | trans___type_3_s_1 : forall X1:term, auto_knows X1 -> auto___type_3 (s X1)
  | trans___type_3_nil_1 : auto___type_3 nil
  | trans___type_3_i_1 : auto___type_3 i
  | trans___type_3_nonceb_1 : forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_3 (nonceb X1 X2 X3)
  | trans___type_3_nonceb_2 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_3 (nonceb X1 X2 X3)
  | trans___type_3_bob_1 : auto___type_3 bob
  | trans___type_3_key_1 : forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> auto___type_3 (key X1 X2)
  | trans___type_3_key_2 : forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___type_3 (key X1 X2)
  | trans___type_3_key_3 : forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> auto___type_3 (key X1 X2)
  | trans___type_3_alice_1 : auto___type_3 alice
  | trans___type_3_cons_1 : forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto___type_3 (cons X1 X2)
  | trans___type_3_server_1 : auto___type_3 server
  | trans___type_3_noncea_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_3 (noncea X1 X2)
with auto___def_38 : term -> term -> term -> term -> Prop :=
    trans___def_38_1 : forall X1 X2 X3 X4:term, auto___type_5 X1 -> auto_agent X1 -> auto___type_4 X2 -> auto_agent X2 -> auto___def_20 X3 -> auto___def_16 X4 -> auto___def_38 X1 X2 X3 X4
  | trans___def_38_2 : forall X1 X2 X3 X4:term, auto___type_5 X1 -> auto_agent X1 -> auto___type_4 X2 -> auto_agent X2 -> auto___def_36 X3 -> auto___def_33 X4 -> auto___def_38 X1 X2 X3 X4
with auto___def_42 : term -> Prop :=
    trans___def_42_s_1 : forall X1:term, auto_knows X1 -> auto___def_42 (s X1)
with auto___def_1 : term -> term -> Prop :=
    trans___def_1_1 : forall X1 X2:term, auto___type_8 X1 -> auto_knows X2 -> auto___def_1 X1 X2
with auto___def_16 : term -> Prop :=
    trans___def_16_key_1 : forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_16 (key X1 X2)
with auto___type_1 : term -> Prop :=
    trans___type_1_i_1 : auto___type_1 i
  | trans___type_1_bob_1 : auto___type_1 bob
  | trans___type_1_alice_1 : auto___type_1 alice
  | trans___type_1_server_1 : auto___type_1 server
with auto_agent : term -> Prop :=
    trans_agent_i_1 : auto_agent i
  | trans_agent_bob_1 : auto_agent bob
  | trans_agent_alice_1 : auto_agent alice
  | trans_agent_server_1 : auto_agent server
with auto___type_6 : term -> Prop :=
    trans___type_6_key_1 : forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___type_6 (key X1 X2)
  | trans___type_6_key_2 : forall X1 X2:term, auto___def_18 X1 -> auto___def_35 X2 -> auto___type_6 (key X1 X2)
with auto___def_8 : term -> Prop :=
    trans___def_8_cons_1 : forall X1 X2:term, auto___def_9 X1 -> auto___def_10 X2 -> auto___def_8 (cons X1 X2)
with auto___def_28 : term -> Prop :=
    trans___def_28_nil_1 : auto___def_28 nil
with auto___def_10 : term -> Prop :=
    trans___def_10_nil_1 : auto___def_10 nil
with auto___def_3 : term -> term -> Prop :=
    trans___def_3_1 : forall X1 X2:term, auto___def_45 X1 -> auto_knows X2 -> auto___def_3 X1 X2
with auto___def_7 : term -> Prop :=
    trans___def_7_cons_1 : forall X1 X2:term, auto___type_2 X1 -> auto___def_8 X2 -> auto___def_7 (cons X1 X2)
with auto___def_40 : term -> Prop :=
    trans___def_40_nonceb_1 : forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___def_40 (nonceb X1 X2 X3)
  | trans___def_40_nonceb_2 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___def_40 (nonceb X1 X2 X3)
with auto___def_13 : term -> Prop :=
    trans___def_13_key_1 : forall X1 X2:term, auto___def_18 X1 -> auto___def_29 X2 -> auto___def_13 (key X1 X2)
with auto___def_9 : term -> Prop :=
    trans___def_9_noncea_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___def_9 (noncea X1 X2)
with auto___def_22 : term -> Prop :=
    trans___def_22_cons_1 : forall X1 X2:term, auto___def_16 X1 -> auto___def_24 X2 -> auto___def_22 (cons X1 X2)
with auto___def_34 : term -> Prop :=
    trans___def_34_cons_1 : forall X1 X2:term, auto___def_36 X1 -> auto___def_21 X2 -> auto___def_34 (cons X1 X2)
with auto___def_11 : term -> term -> term -> Prop :=
    trans___def_11_1 : forall X1 X2 X3:term, auto_knows X1 -> auto_knows X2 -> auto_knows X3 -> auto___def_11 X1 X2 X3
with auto___def_37 : term -> Prop :=
    trans___def_37_cons_1 : forall X1 X2:term, auto___def_33 X1 -> auto___def_24 X2 -> auto___def_37 (cons X1 X2)
with auto_alice_key : term -> term -> Prop :=
    trans_alice_key_1 : forall X1 X2:term, auto___type_5 X1 -> auto_agent X1 -> auto___def_16 X2 -> auto_alice_key X1 X2
  | trans_alice_key_2 : forall X1 X2:term, auto___type_5 X1 -> auto_agent X1 -> auto___def_33 X2 -> auto_alice_key X1 X2
with auto___def_31 : term -> Prop :=
    trans___def_31_cons_1 : forall X1 X2:term, auto___type_4 X1 -> auto___def_32 X2 -> auto___def_31 (cons X1 X2)
with auto___def_41 : term -> term -> Prop :=
    trans___def_41_1 : forall X1 X2:term, auto___def_12 X1 -> auto___def_16 X2 -> auto___def_13 X2 -> auto___def_41 X1 X2
  | trans___def_41_2 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_16 X2 -> auto___def_41 X1 X2
  | trans___def_41_3 : forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto___def_16 X2 -> auto___def_41 X1 X2
  | trans___def_41_4 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_33 X2 -> auto___def_41 X1 X2
  | trans___def_41_5 : forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto___def_33 X2 -> auto___def_41 X1 X2
  | trans___def_41_6 : forall X1 X2:term, auto___def_12 X1 -> auto___def_33 X2 -> auto___def_13 X2 -> auto___def_41 X1 X2
  | trans___def_41_7 : forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto___def_16 X2 -> auto___def_41 X1 X2
  | trans___def_41_8 : forall X1 X2:term, auto___def_30 X1 -> auto___def_16 X2 -> auto___def_13 X2 -> auto___def_41 X1 X2
  | trans___def_41_9 : forall X1 X2:term, auto___def_40 X1 -> auto___def_16 X2 -> auto___type_6 X2 -> auto___def_41 X1 X2
  | trans___def_41_10 : forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto___def_16 X2 -> auto___def_41 X1 X2
with auto___def_35 : term -> Prop :=
    trans___def_35_old_session_1 : forall X1 X2 X3:term, auto_knows X1 -> auto_knows X2 -> auto_knows X3 -> auto___def_35 (old_session X1 X2 X3)
with auto___def_32 : term -> Prop :=
    trans___def_32_cons_1 : forall X1 X2:term, auto___def_33 X1 -> auto___def_34 X2 -> auto___def_32 (cons X1 X2)
with auto___def_39 : term -> term -> term -> Prop :=
    trans___def_39_1 : forall X1 X2 X3:term, auto___type_5 X1 -> auto___type_4 X2 -> auto___def_16 X3 -> auto___def_39 X1 X2 X3
  | trans___def_39_2 : forall X1 X2 X3:term, auto___type_5 X1 -> auto___type_4 X2 -> auto___def_33 X3 -> auto___def_39 X1 X2 X3
with auto___query__intruder_knows_session_key_as_seen_by_alice : Prop :=
with auto___query__intruder_knows_session_key_generated_by_server : Prop :=
.

(* [defp] Proofs that all definitions hold. *)


Remark rem_1 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1:term, auto___def_42 X1 -> auto___def_42 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto___def_42 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2.
  cut (auto___def_42 X1 -> auto___def_42 X1). tauto. exact (rem_1 epsilon_mknows_p__type_5 X1).
Defined.

Remark rem_3 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X2:term, auto___type_7 X2 -> auto___type_7 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_4 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto___type_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2.
  cut (auto___type_7 X2 -> auto___type_7 X2). tauto. exact (rem_3 epsilon_mknows_p__type_5 X2).
Defined.

Remark rem_5 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> (auto___def_42 X1 /\ auto___type_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2. intros A1 A2.
  cut (auto___def_42 X1). 2:apply (rem_2 epsilon_mknows_p__type_5 X1 X2);  assumption.
  cut (auto___type_7 X2). 2:apply (rem_4 epsilon_mknows_p__type_5 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_6 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto___type_5 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2. intros A1 A2.
  case (rem_5 epsilon_mknows_p__type_5 X1 X2 A1 A2). clear  epsilon_mknows_p__type_5 A1 A2. intros. apply trans___type_5_crypt_1;  tauto.
 clear  epsilon_mknows_p__type_5 A1 A2. tauto.
Defined.

Remark rem_7 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1:term, auto___def_12 X1 -> auto___def_12 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_8 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_12 X1). tauto. exact (rem_7 epsilon_mknows_p__type_5 X1).
Defined.

Remark rem_9 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X2:term, auto___def_13 X2 -> auto___def_13 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_10 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_9 epsilon_mknows_p__type_5 X2).
Defined.

Remark rem_11 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> (auto___def_12 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2. intros A1 A2.
  cut (auto___def_12 X1). 2:apply (rem_8 epsilon_mknows_p__type_5 X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_10 epsilon_mknows_p__type_5 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_12 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___type_5 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2. intros A1 A2.
  case (rem_11 epsilon_mknows_p__type_5 X1 X2 A1 A2). clear  epsilon_mknows_p__type_5 A1 A2. intros. apply trans___type_5_crypt_2;  tauto.
 clear  epsilon_mknows_p__type_5 A1 A2. tauto.
Defined.

Remark rem_13 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1:term, auto___def_22 X1 -> auto___def_22 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_14 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_22 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2.
  cut (auto___def_22 X1 -> auto___def_22 X1). tauto. exact (rem_13 epsilon_mknows_p__type_5 X1).
Defined.

Remark rem_15 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X2:term, auto___def_23 X2 -> auto___def_23 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_16 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_15 epsilon_mknows_p__type_5 X2).
Defined.

Remark rem_17 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> (auto___def_22 X1 /\ auto___def_23 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2. intros A1 A2.
  cut (auto___def_22 X1). 2:apply (rem_14 epsilon_mknows_p__type_5 X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_16 epsilon_mknows_p__type_5 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_18 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___type_5 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2. intros A1 A2.
  case (rem_17 epsilon_mknows_p__type_5 X1 X2 A1 A2). clear  epsilon_mknows_p__type_5 A1 A2. intros. apply trans___type_5_crypt_3;  tauto.
 clear  epsilon_mknows_p__type_5 A1 A2. tauto.
Defined.

Remark rem_19 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1:term, auto___def_37 X1 -> auto___def_37 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_20 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto___def_37 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2.
  cut (auto___def_37 X1 -> auto___def_37 X1). tauto. exact (rem_19 epsilon_mknows_p__type_5 X1).
Defined.

Remark rem_21 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_15 epsilon_mknows_p__type_5 X2).
Defined.

Remark rem_22 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> (auto___def_37 X1 /\ auto___def_23 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2. intros A1 A2.
  cut (auto___def_37 X1). 2:apply (rem_20 epsilon_mknows_p__type_5 X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_21 epsilon_mknows_p__type_5 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_23 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto___type_5 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2. intros A1 A2.
  case (rem_22 epsilon_mknows_p__type_5 X1 X2 A1 A2). clear  epsilon_mknows_p__type_5 A1 A2. intros. apply trans___type_5_crypt_4;  tauto.
 clear  epsilon_mknows_p__type_5 A1 A2. tauto.
Defined.

Remark rem_24 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1:term, auto_knows X1 -> auto_knows X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_25 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2.
  cut (auto_knows X1 -> auto_knows X1). tauto. exact (rem_24 epsilon_mknows_p__type_5 X1).
Defined.

Remark rem_26 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X2:term, auto_knows X2 -> auto_knows X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_27 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2.
  cut (auto_knows X2 -> auto_knows X2). tauto. exact (rem_26 epsilon_mknows_p__type_5 X2).
Defined.

Remark rem_28 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> (auto_knows X1 /\ auto_knows X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2. intros A1 A2.
  cut (auto_knows X1). 2:apply (rem_25 epsilon_mknows_p__type_5 X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_27 epsilon_mknows_p__type_5 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_29 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto___type_5 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2. intros A1 A2.
  case (rem_28 epsilon_mknows_p__type_5 X1 X2 A1 A2). clear  epsilon_mknows_p__type_5 A1 A2. intros. apply trans___type_5_crypt_5;  tauto.
 clear  epsilon_mknows_p__type_5 A1 A2. tauto.
Defined.

Remark rem_30 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1:term, auto___def_40 X1 -> auto___def_40 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_31 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> auto___def_40 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2.
  cut (auto___def_40 X1 -> auto___def_40 X1). tauto. exact (rem_30 epsilon_mknows_p__type_5 X1).
Defined.

Remark rem_32 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X2:term, auto___type_6 X2 -> auto___type_6 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_33 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> auto___type_6 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2.
  cut (auto___type_6 X2 -> auto___type_6 X2). tauto. exact (rem_32 epsilon_mknows_p__type_5 X2).
Defined.

Remark rem_34 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> (auto___def_40 X1 /\ auto___type_6 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2. intros A1 A2.
  cut (auto___def_40 X1). 2:apply (rem_31 epsilon_mknows_p__type_5 X1 X2);  assumption.
  cut (auto___type_6 X2). 2:apply (rem_33 epsilon_mknows_p__type_5 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_35 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> auto___type_5 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2. intros A1 A2.
  case (rem_34 epsilon_mknows_p__type_5 X1 X2 A1 A2). clear  epsilon_mknows_p__type_5 A1 A2. intros. apply trans___type_5_crypt_6;  tauto.
 clear  epsilon_mknows_p__type_5 A1 A2. tauto.
Defined.

Remark rem_36 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1:term, auto___def_30 X1 -> auto___def_30 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_37 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> auto___def_30 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2.
  cut (auto___def_30 X1 -> auto___def_30 X1). tauto. exact (rem_36 epsilon_mknows_p__type_5 X1).
Defined.

Remark rem_38 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_9 epsilon_mknows_p__type_5 X2).
Defined.

Remark rem_39 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> (auto___def_30 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2. intros A1 A2.
  cut (auto___def_30 X1). 2:apply (rem_37 epsilon_mknows_p__type_5 X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_38 epsilon_mknows_p__type_5 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_40 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> auto___type_5 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2. intros A1 A2.
  case (rem_39 epsilon_mknows_p__type_5 X1 X2 A1 A2). clear  epsilon_mknows_p__type_5 A1 A2. intros. apply trans___type_5_crypt_7;  tauto.
 clear  epsilon_mknows_p__type_5 A1 A2. tauto.
Defined.

Inductive or_7(H1 H2 H3 H4 H5 H6 H7:Prop) : Prop :=
    or_7_intro_1 : H1 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_2 : H2 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_3 : H3 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_4 : H4 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_5 : H5 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_6 : H6 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_7 : H7 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
.

Remark rem_41 : forall X1 X2:term, auto_knows (crypt X1 X2) -> or_7
    (auto___def_42 X1 /\ auto___type_7 X2)
    (auto___def_12 X1 /\ auto___def_13 X2)
    (auto___def_22 X1 /\ auto___def_23 X2)
    (auto___def_37 X1 /\ auto___def_23 X2)
    (auto_knows X1 /\ auto_knows X2)
    (auto___def_40 X1 /\ auto___type_6 X2)
    (auto___def_30 X1 /\ auto___def_13 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_7_intro_1; tauto.
  intros. apply or_7_intro_2; tauto.
  intros. apply or_7_intro_3; tauto.
  intros. apply or_7_intro_4; tauto.
  intros. apply or_7_intro_5; tauto.
  intros. apply or_7_intro_6; tauto.
  intros. apply or_7_intro_7; tauto.
Qed.

Remark rem_42 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto_knows (crypt X1 X2) -> auto___type_5 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2. intro H. intros.
  elim (rem_41 X1 X2 H);  intros.
  apply (rem_6 epsilon_mknows_p__type_5 X1 X2);  tauto.
  apply (rem_12 epsilon_mknows_p__type_5 X1 X2);  tauto.
  apply (rem_18 epsilon_mknows_p__type_5 X1 X2);  tauto.
  apply (rem_23 epsilon_mknows_p__type_5 X1 X2);  tauto.
  apply (rem_29 epsilon_mknows_p__type_5 X1 X2);  tauto.
  apply (rem_35 epsilon_mknows_p__type_5 X1 X2);  tauto.
  apply (rem_40 epsilon_mknows_p__type_5 X1 X2);  tauto.
Defined.

Remark rem_43 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1:term, auto_knows X1 -> auto_knows X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1. intros A1.
  cut (auto_knows X1). 2:apply (rem_24 epsilon_mknows_p__type_5 X1);  assumption.
  tauto.
Defined.

Remark rem_44 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1:term, auto_knows X1 -> auto___type_5 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1. intros A1.
  case (rem_43 epsilon_mknows_p__type_5 X1 A1). clear  epsilon_mknows_p__type_5 A1. intros. apply trans___type_5_s_1;  tauto.
 clear  epsilon_mknows_p__type_5 A1. tauto.
Defined.

Inductive or_1(H1:Prop) : Prop :=
    or_1_intro_1 : H1 -> (or_1 H1)
.

Remark rem_45 : forall X1:term, auto_knows (s X1) -> or_1
    (auto_knows X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_46 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1:term, auto_knows (s X1) -> auto___type_5 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1. intro H. intros.
  elim (rem_45 X1 H);  intros.
  apply (rem_44 epsilon_mknows_p__type_5 X1);  tauto.
Defined.

Remark rem_47 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_5.  tauto.
Defined.

Remark rem_48 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> auto___type_5 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_5.  case (rem_47 epsilon_mknows_p__type_5). clear  epsilon_mknows_p__type_5. intros. apply trans___type_5_nil_1;  tauto.
 clear  epsilon_mknows_p__type_5. tauto.
Defined.

Remark rem_49 : auto_knows nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_50 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> auto_knows nil -> auto___type_5 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_5. intro H. intros.
  elim (rem_49 H);  intros.
  apply (rem_48 epsilon_mknows_p__type_5);  tauto.
Defined.

Remark rem_51 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> auto___type_5 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_5.  case (rem_47 epsilon_mknows_p__type_5). clear  epsilon_mknows_p__type_5. intros. apply trans___type_5_i_1;  tauto.
 clear  epsilon_mknows_p__type_5. tauto.
Defined.

Remark rem_52 : auto_knows i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_53 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> auto_knows i -> auto___type_5 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_5. intro H. intros.
  elim (rem_52 H);  intros.
  apply (rem_51 epsilon_mknows_p__type_5);  tauto.
Defined.

Remark rem_54 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1:term, auto___def_33 X1 -> auto___def_33 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_55 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___def_33 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2 X3.
  cut (auto___def_33 X1 -> auto___def_33 X1). tauto. exact (rem_54 epsilon_mknows_p__type_5 X1).
Defined.

Remark rem_56 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X2:term, auto___type_5 X2 -> auto___type_5 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_57 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2 X3.
  cut (auto___type_5 X2 -> auto___type_5 X2). tauto. exact (rem_56 epsilon_mknows_p__type_5 X2).
Defined.

Remark rem_58 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X3:term, auto___type_4 X3 -> auto___type_4 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_59 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_4 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2 X3.
  cut (auto___type_4 X3 -> auto___type_4 X3). tauto. exact (rem_58 epsilon_mknows_p__type_5 X3).
Defined.

Remark rem_60 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> (auto___def_33 X1 /\ auto___type_5 X2 /\ auto___type_4 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_33 X1). 2:apply (rem_55 epsilon_mknows_p__type_5 X1 X2 X3);  assumption.
  cut (auto___type_5 X2). 2:apply (rem_57 epsilon_mknows_p__type_5 X1 X2 X3);  assumption.
  cut (auto___type_4 X3). 2:apply (rem_59 epsilon_mknows_p__type_5 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_61 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_5 (nonceb X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_60 epsilon_mknows_p__type_5 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_p__type_5 A1 A2 A3. intros. apply trans___type_5_nonceb_1;  tauto.
 clear  epsilon_mknows_p__type_5 A1 A2 A3. tauto.
Defined.

Remark rem_62 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1:term, auto___def_16 X1 -> auto___def_16 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_63 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___def_16 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2 X3.
  cut (auto___def_16 X1 -> auto___def_16 X1). tauto. exact (rem_62 epsilon_mknows_p__type_5 X1).
Defined.

Remark rem_64 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2 X3.
  cut (auto___type_5 X2 -> auto___type_5 X2). tauto. exact (rem_56 epsilon_mknows_p__type_5 X2).
Defined.

Remark rem_65 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_4 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2 X3.
  cut (auto___type_4 X3 -> auto___type_4 X3). tauto. exact (rem_58 epsilon_mknows_p__type_5 X3).
Defined.

Remark rem_66 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> (auto___def_16 X1 /\ auto___type_5 X2 /\ auto___type_4 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_16 X1). 2:apply (rem_63 epsilon_mknows_p__type_5 X1 X2 X3);  assumption.
  cut (auto___type_5 X2). 2:apply (rem_64 epsilon_mknows_p__type_5 X1 X2 X3);  assumption.
  cut (auto___type_4 X3). 2:apply (rem_65 epsilon_mknows_p__type_5 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_67 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_5 (nonceb X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_66 epsilon_mknows_p__type_5 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_p__type_5 A1 A2 A3. intros. apply trans___type_5_nonceb_2;  tauto.
 clear  epsilon_mknows_p__type_5 A1 A2 A3. tauto.
Defined.

Inductive or_2(H1 H2:Prop) : Prop :=
    or_2_intro_1 : H1 -> (or_2 H1 H2)
  | or_2_intro_2 : H2 -> (or_2 H1 H2)
.

Remark rem_68 : forall X1 X2 X3:term, auto_knows (nonceb X1 X2 X3) -> or_2
    (auto___def_33 X1 /\ auto___type_5 X2 /\ auto___type_4 X3)
    (auto___def_16 X1 /\ auto___type_5 X2 /\ auto___type_4 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_69 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2 X3:term, auto_knows (nonceb X1 X2 X3) -> auto___type_5 (nonceb X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2 X3. intro H. intros.
  elim (rem_68 X1 X2 X3 H);  intros.
  apply (rem_61 epsilon_mknows_p__type_5 X1 X2 X3);  tauto.
  apply (rem_67 epsilon_mknows_p__type_5 X1 X2 X3);  tauto.
Defined.

Remark rem_70 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> auto___type_5 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_5.  case (rem_47 epsilon_mknows_p__type_5). clear  epsilon_mknows_p__type_5. intros. apply trans___type_5_bob_1;  tauto.
 clear  epsilon_mknows_p__type_5. tauto.
Defined.

Remark rem_71 : auto_knows bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_72 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> auto_knows bob -> auto___type_5 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_5. intro H. intros.
  elim (rem_71 H);  intros.
  apply (rem_70 epsilon_mknows_p__type_5);  tauto.
Defined.

Remark rem_73 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1:term, auto___def_43 X1 -> auto___def_43 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_74 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> auto___def_43 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_43 X1). tauto. exact (rem_73 epsilon_mknows_p__type_5 X1).
Defined.

Remark rem_75 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_76 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_75 epsilon_mknows_p__type_5 X2).
Defined.

Remark rem_77 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> (auto___def_43 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2. intros A1 A2.
  cut (auto___def_43 X1). 2:apply (rem_74 epsilon_mknows_p__type_5 X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_76 epsilon_mknows_p__type_5 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_78 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> auto___type_5 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2. intros A1 A2.
  case (rem_77 epsilon_mknows_p__type_5 X1 X2 A1 A2). clear  epsilon_mknows_p__type_5 A1 A2. intros. apply trans___type_5_key_1;  tauto.
 clear  epsilon_mknows_p__type_5 A1 A2. tauto.
Defined.

Remark rem_79 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1:term, auto___def_46 X1 -> auto___def_46 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_80 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_46 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2.
  cut (auto___def_46 X1 -> auto___def_46 X1). tauto. exact (rem_79 epsilon_mknows_p__type_5 X1).
Defined.

Remark rem_81 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X2:term, auto___def_47 X2 -> auto___def_47 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_82 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_47 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2.
  cut (auto___def_47 X2 -> auto___def_47 X2). tauto. exact (rem_81 epsilon_mknows_p__type_5 X2).
Defined.

Remark rem_83 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> (auto___def_46 X1 /\ auto___def_47 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2. intros A1 A2.
  cut (auto___def_46 X1). 2:apply (rem_80 epsilon_mknows_p__type_5 X1 X2);  assumption.
  cut (auto___def_47 X2). 2:apply (rem_82 epsilon_mknows_p__type_5 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_84 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___type_5 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2. intros A1 A2.
  case (rem_83 epsilon_mknows_p__type_5 X1 X2 A1 A2). clear  epsilon_mknows_p__type_5 A1 A2. intros. apply trans___type_5_key_2;  tauto.
 clear  epsilon_mknows_p__type_5 A1 A2. tauto.
Defined.

Remark rem_85 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1:term, auto___def_44 X1 -> auto___def_44 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_86 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> auto___def_44 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2.
  cut (auto___def_44 X1 -> auto___def_44 X1). tauto. exact (rem_85 epsilon_mknows_p__type_5 X1).
Defined.

Remark rem_87 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X2:term, auto___def_45 X2 -> auto___def_45 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_88 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> auto___def_45 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2.
  cut (auto___def_45 X2 -> auto___def_45 X2). tauto. exact (rem_87 epsilon_mknows_p__type_5 X2).
Defined.

Remark rem_89 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> (auto___def_44 X1 /\ auto___def_45 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2. intros A1 A2.
  cut (auto___def_44 X1). 2:apply (rem_86 epsilon_mknows_p__type_5 X1 X2);  assumption.
  cut (auto___def_45 X2). 2:apply (rem_88 epsilon_mknows_p__type_5 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_90 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> auto___type_5 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2. intros A1 A2.
  case (rem_89 epsilon_mknows_p__type_5 X1 X2 A1 A2). clear  epsilon_mknows_p__type_5 A1 A2. intros. apply trans___type_5_key_3;  tauto.
 clear  epsilon_mknows_p__type_5 A1 A2. tauto.
Defined.

Inductive or_3(H1 H2 H3:Prop) : Prop :=
    or_3_intro_1 : H1 -> (or_3 H1 H2 H3)
  | or_3_intro_2 : H2 -> (or_3 H1 H2 H3)
  | or_3_intro_3 : H3 -> (or_3 H1 H2 H3)
.

Remark rem_91 : forall X1 X2:term, auto_knows (key X1 X2) -> or_3
    (auto___def_43 X1 /\ auto___type_8 X2)
    (auto___def_46 X1 /\ auto___def_47 X2)
    (auto___def_44 X1 /\ auto___def_45 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_92 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto_knows (key X1 X2) -> auto___type_5 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2. intro H. intros.
  elim (rem_91 X1 X2 H);  intros.
  apply (rem_78 epsilon_mknows_p__type_5 X1 X2);  tauto.
  apply (rem_84 epsilon_mknows_p__type_5 X1 X2);  tauto.
  apply (rem_90 epsilon_mknows_p__type_5 X1 X2);  tauto.
Defined.

Remark rem_93 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> auto___type_5 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_5.  case (rem_47 epsilon_mknows_p__type_5). clear  epsilon_mknows_p__type_5. intros. apply trans___type_5_alice_1;  tauto.
 clear  epsilon_mknows_p__type_5. tauto.
Defined.

Remark rem_94 : auto_knows alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_95 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> auto_knows alice -> auto___type_5 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_5. intro H. intros.
  elim (rem_94 H);  intros.
  apply (rem_93 epsilon_mknows_p__type_5);  tauto.
Defined.

Remark rem_96 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto___type_5 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2. intros A1 A2.
  case (rem_28 epsilon_mknows_p__type_5 X1 X2 A1 A2). clear  epsilon_mknows_p__type_5 A1 A2. intros. apply trans___type_5_cons_1;  tauto.
 clear  epsilon_mknows_p__type_5 A1 A2. tauto.
Defined.

Remark rem_97 : forall X1 X2:term, auto_knows (cons X1 X2) -> or_1
    (auto_knows X1 /\ auto_knows X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_98 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto_knows (cons X1 X2) -> auto___type_5 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2. intro H. intros.
  elim (rem_97 X1 X2 H);  intros.
  apply (rem_96 epsilon_mknows_p__type_5 X1 X2);  tauto.
Defined.

Remark rem_99 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> auto___type_5 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_5.  case (rem_47 epsilon_mknows_p__type_5). clear  epsilon_mknows_p__type_5. intros. apply trans___type_5_server_1;  tauto.
 clear  epsilon_mknows_p__type_5. tauto.
Defined.

Remark rem_100 : auto_knows server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_101 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> auto_knows server -> auto___type_5 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_5. intro H. intros.
  elim (rem_100 H);  intros.
  apply (rem_99 epsilon_mknows_p__type_5);  tauto.
Defined.

Remark rem_102 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_103 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_102 epsilon_mknows_p__type_5 X1).
Defined.

Remark rem_104 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_105 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_104 epsilon_mknows_p__type_5 X2).
Defined.

Remark rem_106 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> (auto_agent X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2. intros A1 A2.
  cut (auto_agent X1). 2:apply (rem_103 epsilon_mknows_p__type_5 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_105 epsilon_mknows_p__type_5 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_107 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_5 (noncea X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2. intros A1 A2.
  case (rem_106 epsilon_mknows_p__type_5 X1 X2 A1 A2). clear  epsilon_mknows_p__type_5 A1 A2. intros. apply trans___type_5_noncea_1;  tauto.
 clear  epsilon_mknows_p__type_5 A1 A2. tauto.
Defined.

Remark rem_108 : forall X1 X2:term, auto_knows (noncea X1 X2) -> or_1
    (auto_agent X1 /\ auto_agent X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_109 : (forall X:term, auto_knows X -> auto___type_5 X)
    -> forall X1 X2:term, auto_knows (noncea X1 X2) -> auto___type_5 (noncea X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_5. intros X1 X2. intro H. intros.
  elim (rem_108 X1 X2 H);  intros.
  apply (rem_107 epsilon_mknows_p__type_5 X1 X2);  tauto.
Defined.

Inductive or_0 : Prop :=
.

Remark rem_110 : forall X1 X2 X3:term, auto_knows (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_111 : auto_knows sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_112 : auto_knows prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_113 : forall X1 X2 X3:term, auto_knows (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_114 : auto_knows pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_115 : forall X1:term, auto_knows X1 -> auto___type_5 X1. (* Induct. *)
Proof.
  fix epsilon_mknows_p__type_5 1.
  intro X. case X.
  exact (rem_95 epsilon_mknows_p__type_5 ).
  exact (rem_72 epsilon_mknows_p__type_5 ).
  intros X1 X2;  exact (rem_98 epsilon_mknows_p__type_5 X1 X2).
  intros X1 X2;  exact (rem_42 epsilon_mknows_p__type_5 X1 X2).
  intros X1 X2 X3. intro H. elim (rem_113 X1 X2 X3 H).
  exact (rem_53 epsilon_mknows_p__type_5 ).
  intros X1 X2;  exact (rem_92 epsilon_mknows_p__type_5 X1 X2).
  exact (rem_50 epsilon_mknows_p__type_5 ).
  intros X1 X2;  exact (rem_109 epsilon_mknows_p__type_5 X1 X2).
  intros X1 X2 X3;  exact (rem_69 epsilon_mknows_p__type_5 X1 X2 X3).
  intros X1 X2 X3. intro H. elim (rem_110 X1 X2 X3 H).
   intro H. elim (rem_112  H).
   intro H. elim (rem_114  H).
  intros X1;  exact (rem_46 epsilon_mknows_p__type_5 X1).
  exact (rem_101 epsilon_mknows_p__type_5 ).
   intro H. elim (rem_111  H).
Qed.

Remark rem_116 : forall X1 X2 X3:term, auto_knows X2 -> auto_knows X1 -> auto_knows X3 -> auto___type_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows X1 -> auto___type_5 X1). tauto. exact (rem_115 X1).
Qed.

Remark rem_117 : forall X1 X2 X3:term, auto_knows X1 -> auto_knows X2 -> auto_knows X3 -> auto___type_5 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_knows X2 -> auto_knows X1 -> auto_knows X3 -> auto___type_5 X1). tauto. exact (rem_116 X1 X2 X3).
Qed.

Remark rem_118 : forall X1 X2 X3:term, auto___def_11 X1 X2 X3 -> or_1
    (auto_knows X1 /\ auto_knows X2 /\ auto_knows X3)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_119 : forall X1 X2 X3:term, auto___def_11 X1 X2 X3 -> auto___type_5 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_118 X1 X2 X3 H);  intros.
  apply (rem_117 X1 X2 X3);  tauto.
Qed.

Remark rem_120 : forall X1 X2 X3:term, auto___def_29 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_121 : (forall X:term, auto___def_19 X -> auto___def_29 X -> False)
    -> forall X1 X2 X3:term, auto___def_29 (current_session X1 X2 X3) -> auto_knows X1 -> auto_knows X2 -> auto_knows X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_19_m__def_29. intros X1 X2 X3. intro H. intros.
  elim (rem_120 X1 X2 X3 H);  intros.
Defined.

Remark rem_122 : forall X1 X2 X3:term, auto___def_19 (current_session X1 X2 X3) -> or_1
    (auto_knows X1 /\ auto_knows X2 /\ auto_knows X3)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_123 : (forall X:term, auto___def_19 X -> auto___def_29 X -> False)
    -> forall X1 X2 X3:term, auto___def_19 (current_session X1 X2 X3) -> auto___def_29 (current_session X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_19_m__def_29. intros X1 X2 X3. intro H. intros.
  elim (rem_122 X1 X2 X3 H);  intros.
  apply (rem_121 epsilon_m__def_19_m__def_29 X1 X2 X3);  tauto.
Defined.

Remark rem_124 : forall X1 X2:term, auto___def_19 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_125 : forall X1:term, auto___def_19 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_126 : auto___def_19 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_127 : auto___def_19 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_128 : forall X1 X2 X3:term, auto___def_19 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_129 : forall X1 X2 X3:term, auto___def_19 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_130 : auto___def_19 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_131 : forall X1 X2:term, auto___def_19 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_132 : auto___def_19 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_133 : auto___def_19 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_134 : forall X1 X2:term, auto___def_19 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_135 : auto___def_19 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_136 : auto___def_19 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_137 : auto___def_19 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_138 : forall X1 X2:term, auto___def_19 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_139 : forall X2:term, auto___def_19 X2 -> auto___def_29 X2 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_19_m__def_29 1.
  intro X. case X.
   intro H. elim (rem_133  H).
   intro H. elim (rem_130  H).
  intros X1 X2. intro H. elim (rem_134 X1 X2 H).
  intros X1 X2. intro H. elim (rem_124 X1 X2 H).
  intros X1 X2 X3;  exact (rem_123 epsilon_m__def_19_m__def_29 X1 X2 X3).
   intro H. elim (rem_127  H).
  intros X1 X2. intro H. elim (rem_131 X1 X2 H).
   intro H. elim (rem_126  H).
  intros X1 X2. intro H. elim (rem_138 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_129 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_128 X1 X2 X3 H).
   intro H. elim (rem_135  H).
   intro H. elim (rem_136  H).
  intros X1. intro H. elim (rem_125 X1 H).
   intro H. elim (rem_137  H).
   intro H. elim (rem_132  H).
Qed.

Remark rem_140 : (forall X:term, auto___def_16 X -> auto___def_13 X -> False)
    -> forall X2:term, auto___def_19 X2 -> auto___def_29 X2 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_16_m__def_13. exact (rem_139).
Defined.

Remark rem_141 : (forall X:term, auto___def_16 X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_29 X2 -> auto___def_18 X1 -> auto___def_19 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_16_m__def_13. intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_29 X2 -> False). clear  epsilon_m__def_16_m__def_13. tauto.
  exact (rem_140 epsilon_m__def_16_m__def_13 X2).
Defined.

Remark rem_142 : forall X1 X2:term, auto___def_13 (key X1 X2) -> or_1
    (auto___def_18 X1 /\ auto___def_29 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_143 : (forall X:term, auto___def_16 X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (key X1 X2) -> auto___def_18 X1 -> auto___def_19 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_16_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_142 X1 X2 H);  intros.
  apply (rem_141 epsilon_m__def_16_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_144 : forall X1 X2:term, auto___def_16 (key X1 X2) -> or_1
    (auto___def_18 X1 /\ auto___def_19 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_145 : (forall X:term, auto___def_16 X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_16 (key X1 X2) -> auto___def_13 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_16_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_144 X1 X2 H);  intros.
  apply (rem_143 epsilon_m__def_16_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_146 : forall X1 X2:term, auto___def_16 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_147 : forall X1:term, auto___def_16 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_148 : auto___def_16 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_149 : auto___def_16 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_150 : forall X1 X2 X3:term, auto___def_16 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_151 : forall X1 X2 X3:term, auto___def_16 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_152 : auto___def_16 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_153 : auto___def_16 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_154 : auto___def_16 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_155 : forall X1 X2:term, auto___def_16 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_156 : auto___def_16 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_157 : forall X1 X2 X3:term, auto___def_16 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_158 : auto___def_16 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_159 : auto___def_16 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_160 : forall X1 X2:term, auto___def_16 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_161 : forall X1:term, auto___def_16 X1 -> auto___def_13 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_16_m__def_13 1.
  intro X. case X.
   intro H. elim (rem_154  H).
   intro H. elim (rem_152  H).
  intros X1 X2. intro H. elim (rem_155 X1 X2 H).
  intros X1 X2. intro H. elim (rem_146 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_157 X1 X2 X3 H).
   intro H. elim (rem_149  H).
  intros X1 X2;  exact (rem_145 epsilon_m__def_16_m__def_13 X1 X2).
   intro H. elim (rem_148  H).
  intros X1 X2. intro H. elim (rem_160 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_151 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_150 X1 X2 X3 H).
   intro H. elim (rem_156  H).
   intro H. elim (rem_158  H).
  intros X1. intro H. elim (rem_147 X1 H).
   intro H. elim (rem_159  H).
   intro H. elim (rem_153  H).
Qed.

Remark rem_162 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_16 X2 -> auto___def_42 (s X1). (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_161 X2)). tauto.
Qed.

Remark rem_163 : forall X1 X2:term, auto___def_12 X1 -> auto___def_16 X2 -> auto___def_13 X2 -> auto___def_42 (s X1). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_13 X2 -> auto___def_16 X2 -> auto___def_42 (s X1)). tauto. exact (rem_162 X1 X2).
Qed.

Remark rem_164 : forall X1 X2 X3:term, auto___def_25 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_165 : (forall X:term, auto___def_19 X -> auto___def_25 X -> False)
    -> forall X1 X2 X3:term, auto___def_25 (current_session X1 X2 X3) -> auto_knows X1 -> auto_knows X2 -> auto_knows X3 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_19_m__def_25. intros X1 X2 X3. intro H. intros.
  elim (rem_164 X1 X2 X3 H);  intros.
Defined.

Remark rem_166 : (forall X:term, auto___def_19 X -> auto___def_25 X -> False)
    -> forall X1 X2 X3:term, auto___def_19 (current_session X1 X2 X3) -> auto___def_25 (current_session X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_19_m__def_25. intros X1 X2 X3. intro H. intros.
  elim (rem_122 X1 X2 X3 H);  intros.
  apply (rem_165 epsilon_m__def_19_m__def_25 X1 X2 X3);  tauto.
Defined.

Remark rem_167 : forall X2:term, auto___def_19 X2 -> auto___def_25 X2 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_19_m__def_25 1.
  intro X. case X.
   intro H. elim (rem_133  H).
   intro H. elim (rem_130  H).
  intros X1 X2. intro H. elim (rem_134 X1 X2 H).
  intros X1 X2. intro H. elim (rem_124 X1 X2 H).
  intros X1 X2 X3;  exact (rem_166 epsilon_m__def_19_m__def_25 X1 X2 X3).
   intro H. elim (rem_127  H).
  intros X1 X2. intro H. elim (rem_131 X1 X2 H).
   intro H. elim (rem_126  H).
  intros X1 X2. intro H. elim (rem_138 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_129 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_128 X1 X2 X3 H).
   intro H. elim (rem_135  H).
   intro H. elim (rem_136  H).
  intros X1. intro H. elim (rem_125 X1 H).
   intro H. elim (rem_137  H).
   intro H. elim (rem_132  H).
Qed.

Remark rem_168 : (forall X:term, auto___def_23 X -> auto___def_16 X -> False)
    -> forall X2:term, auto___def_19 X2 -> auto___def_25 X2 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_23_m__def_16. exact (rem_167).
Defined.

Remark rem_169 : (forall X:term, auto___def_23 X -> auto___def_16 X -> False)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_25 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_23_m__def_16. intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_25 X2 -> False). clear  epsilon_m__def_23_m__def_16. tauto.
  exact (rem_168 epsilon_m__def_23_m__def_16 X2).
Defined.

Remark rem_170 : (forall X:term, auto___def_23 X -> auto___def_16 X -> False)
    -> forall X1 X2:term, auto___def_16 (key X1 X2) -> auto___def_18 X1 -> auto___def_25 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_23_m__def_16. intros X1 X2. intro H. intros.
  elim (rem_144 X1 X2 H);  intros.
  apply (rem_169 epsilon_m__def_23_m__def_16 X1 X2);  tauto.
Defined.

Remark rem_171 : forall X1 X2:term, auto___def_23 (key X1 X2) -> or_1
    (auto___def_18 X1 /\ auto___def_25 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_172 : (forall X:term, auto___def_23 X -> auto___def_16 X -> False)
    -> forall X1 X2:term, auto___def_23 (key X1 X2) -> auto___def_16 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_23_m__def_16. intros X1 X2. intro H. intros.
  elim (rem_171 X1 X2 H);  intros.
  apply (rem_170 epsilon_m__def_23_m__def_16 X1 X2);  tauto.
Defined.

Remark rem_173 : forall X1 X2:term, auto___def_23 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_174 : forall X1:term, auto___def_23 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_175 : auto___def_23 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_176 : auto___def_23 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_177 : forall X1 X2 X3:term, auto___def_23 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_178 : forall X1 X2 X3:term, auto___def_23 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_179 : auto___def_23 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_180 : auto___def_23 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_181 : auto___def_23 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_182 : forall X1 X2:term, auto___def_23 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_183 : auto___def_23 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_184 : forall X1 X2 X3:term, auto___def_23 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_185 : auto___def_23 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_186 : auto___def_23 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_187 : forall X1 X2:term, auto___def_23 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_188 : forall X1:term, auto___def_23 X1 -> auto___def_16 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_23_m__def_16 1.
  intro X. case X.
   intro H. elim (rem_181  H).
   intro H. elim (rem_179  H).
  intros X1 X2. intro H. elim (rem_182 X1 X2 H).
  intros X1 X2. intro H. elim (rem_173 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_184 X1 X2 X3 H).
   intro H. elim (rem_176  H).
  intros X1 X2;  exact (rem_172 epsilon_m__def_23_m__def_16 X1 X2).
   intro H. elim (rem_175  H).
  intros X1 X2. intro H. elim (rem_187 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_178 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_177 X1 X2 X3 H).
   intro H. elim (rem_183  H).
   intro H. elim (rem_185  H).
  intros X1. intro H. elim (rem_174 X1 H).
   intro H. elim (rem_186  H).
   intro H. elim (rem_180  H).
Qed.

Remark rem_189 : forall X1 X2:term, auto___def_16 X2 -> auto___def_22 X1 -> auto___def_23 X2 -> auto___def_42 (s X1). (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_188 X2)). tauto.
Qed.

Remark rem_190 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_16 X2 -> auto___def_42 (s X1). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_16 X2 -> auto___def_22 X1 -> auto___def_23 X2 -> auto___def_42 (s X1)). tauto. exact (rem_189 X1 X2).
Qed.

Remark rem_191 : (forall X:term, auto___def_18 X -> auto___def_46 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_18_p__def_46.  tauto.
Defined.

Remark rem_192 : (forall X:term, auto___def_18 X -> auto___def_46 X)
    -> auto___def_46 sym. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_18_p__def_46.  case (rem_191 epsilon_m__def_18_p__def_46). clear  epsilon_m__def_18_p__def_46. intros. apply trans___def_46_sym_1;  tauto.
 clear  epsilon_m__def_18_p__def_46. tauto.
Defined.

Remark rem_193 : auto___def_18 sym -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_194 : (forall X:term, auto___def_18 X -> auto___def_46 X)
    -> auto___def_18 sym -> auto___def_46 sym. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_18_p__def_46. intro H. intros.
  elim (rem_193 H);  intros.
  apply (rem_192 epsilon_m__def_18_p__def_46);  tauto.
Defined.

Remark rem_195 : forall X1 X2:term, auto___def_18 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_196 : forall X1:term, auto___def_18 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_197 : auto___def_18 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_198 : auto___def_18 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_199 : forall X1 X2 X3:term, auto___def_18 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_200 : forall X1 X2 X3:term, auto___def_18 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_201 : auto___def_18 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_202 : forall X1 X2:term, auto___def_18 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_203 : auto___def_18 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_204 : forall X1 X2:term, auto___def_18 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_205 : auto___def_18 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_206 : forall X1 X2 X3:term, auto___def_18 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_207 : auto___def_18 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_208 : auto___def_18 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_209 : forall X1 X2:term, auto___def_18 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_210 : forall X1:term, auto___def_18 X1 -> auto___def_46 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_18_p__def_46 1.
  intro X. case X.
   intro H. elim (rem_203  H).
   intro H. elim (rem_201  H).
  intros X1 X2. intro H. elim (rem_204 X1 X2 H).
  intros X1 X2. intro H. elim (rem_195 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_206 X1 X2 X3 H).
   intro H. elim (rem_198  H).
  intros X1 X2. intro H. elim (rem_202 X1 X2 H).
   intro H. elim (rem_197  H).
  intros X1 X2. intro H. elim (rem_209 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_200 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_199 X1 X2 X3 H).
   intro H. elim (rem_205  H).
   intro H. elim (rem_207  H).
  intros X1. intro H. elim (rem_196 X1 H).
   intro H. elim (rem_208  H).
  exact (rem_194 epsilon_m__def_18_p__def_46 ).
Qed.

Remark rem_211 : (forall X:term, auto___def_33 X -> auto_knows X)
    -> forall X1:term, auto___def_18 X1 -> auto___def_46 X1. (* Cut history. *)
Proof.  intros epsilon_m__def_33_pknows. exact (rem_210).
Defined.

Remark rem_212 : (forall X:term, auto___def_33 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_35 X2 -> auto___def_46 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_33_pknows. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_46 X1). tauto. exact (rem_211 epsilon_m__def_33_pknows X1).
Defined.

Remark rem_213 : (forall X:term, auto___def_35 X -> auto___def_47 X)
    -> forall X1 X2 X3:term, auto_knows X1 -> auto_knows X2 -> auto_knows X3 -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_35_p__def_47. intros X1 X2 X3. intros A1 A2 A3.
  tauto.
Defined.

Remark rem_214 : (forall X:term, auto___def_35 X -> auto___def_47 X)
    -> forall X1 X2 X3:term, auto_knows X1 -> auto_knows X2 -> auto_knows X3 -> auto___def_47 (old_session X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_35_p__def_47. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_213 epsilon_m__def_35_p__def_47 X1 X2 X3 A1 A2 A3). clear  epsilon_m__def_35_p__def_47 A1 A2 A3. intros. apply trans___def_47_old_session_1;  tauto.
 clear  epsilon_m__def_35_p__def_47 A1 A2 A3. tauto.
Defined.

Remark rem_215 : forall X1 X2 X3:term, auto___def_35 (old_session X1 X2 X3) -> or_1
    (auto_knows X1 /\ auto_knows X2 /\ auto_knows X3)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_216 : (forall X:term, auto___def_35 X -> auto___def_47 X)
    -> forall X1 X2 X3:term, auto___def_35 (old_session X1 X2 X3) -> auto___def_47 (old_session X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_35_p__def_47. intros X1 X2 X3. intro H. intros.
  elim (rem_215 X1 X2 X3 H);  intros.
  apply (rem_214 epsilon_m__def_35_p__def_47 X1 X2 X3);  tauto.
Defined.

Remark rem_217 : forall X1 X2:term, auto___def_35 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_218 : forall X1:term, auto___def_35 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_219 : auto___def_35 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_220 : auto___def_35 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_221 : forall X1 X2 X3:term, auto___def_35 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_222 : auto___def_35 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_223 : forall X1 X2:term, auto___def_35 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_224 : auto___def_35 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_225 : auto___def_35 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_226 : forall X1 X2:term, auto___def_35 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_227 : auto___def_35 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_228 : forall X1 X2 X3:term, auto___def_35 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_229 : auto___def_35 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_230 : auto___def_35 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_231 : forall X1 X2:term, auto___def_35 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_232 : forall X2:term, auto___def_35 X2 -> auto___def_47 X2. (* Induct. *)
Proof.
  fix epsilon_m__def_35_p__def_47 1.
  intro X. case X.
   intro H. elim (rem_225  H).
   intro H. elim (rem_222  H).
  intros X1 X2. intro H. elim (rem_226 X1 X2 H).
  intros X1 X2. intro H. elim (rem_217 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_228 X1 X2 X3 H).
   intro H. elim (rem_220  H).
  intros X1 X2. intro H. elim (rem_223 X1 X2 H).
   intro H. elim (rem_219  H).
  intros X1 X2. intro H. elim (rem_231 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_221 X1 X2 X3 H).
  intros X1 X2 X3;  exact (rem_216 epsilon_m__def_35_p__def_47 X1 X2 X3).
   intro H. elim (rem_227  H).
   intro H. elim (rem_229  H).
  intros X1. intro H. elim (rem_218 X1 H).
   intro H. elim (rem_230  H).
   intro H. elim (rem_224  H).
Qed.

Remark rem_233 : (forall X:term, auto___def_33 X -> auto_knows X)
    -> forall X2:term, auto___def_35 X2 -> auto___def_47 X2. (* Cut history. *)
Proof.  intros epsilon_m__def_33_pknows. exact (rem_232).
Defined.

Remark rem_234 : (forall X:term, auto___def_33 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_35 X2 -> auto___def_47 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_33_pknows. intros X1 X2.
  cut (auto___def_35 X2 -> auto___def_47 X2). tauto. exact (rem_233 epsilon_m__def_33_pknows X2).
Defined.

Remark rem_235 : (forall X:term, auto___def_33 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_35 X2 -> (auto___def_46 X1 /\ auto___def_47 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_33_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_46 X1). 2:apply (rem_212 epsilon_m__def_33_pknows X1 X2);  assumption.
  cut (auto___def_47 X2). 2:apply (rem_234 epsilon_m__def_33_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_236 : (forall X:term, auto___def_33 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_35 X2 -> auto_knows (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_33_pknows. intros X1 X2. intros A1 A2.
  case (rem_235 epsilon_m__def_33_pknows X1 X2 A1 A2). clear  epsilon_m__def_33_pknows A1 A2. intros. apply trans_knows_key_2;  tauto.
 clear  epsilon_m__def_33_pknows A1 A2. tauto.
Defined.

Remark rem_237 : forall X1 X2:term, auto___def_33 (key X1 X2) -> or_1
    (auto___def_18 X1 /\ auto___def_35 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_238 : (forall X:term, auto___def_33 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_33 (key X1 X2) -> auto_knows (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_33_pknows. intros X1 X2. intro H. intros.
  elim (rem_237 X1 X2 H);  intros.
  apply (rem_236 epsilon_m__def_33_pknows X1 X2);  tauto.
Defined.

Remark rem_239 : forall X1 X2:term, auto___def_33 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_240 : forall X1:term, auto___def_33 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_241 : auto___def_33 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_242 : auto___def_33 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_243 : forall X1 X2 X3:term, auto___def_33 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_244 : forall X1 X2 X3:term, auto___def_33 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_245 : auto___def_33 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_246 : auto___def_33 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_247 : auto___def_33 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_248 : forall X1 X2:term, auto___def_33 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_249 : auto___def_33 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_250 : forall X1 X2 X3:term, auto___def_33 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_251 : auto___def_33 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_252 : auto___def_33 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_253 : forall X1 X2:term, auto___def_33 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_254 : forall X1:term, auto___def_33 X1 -> auto_knows X1. (* Induct. *)
Proof.
  fix epsilon_m__def_33_pknows 1.
  intro X. case X.
   intro H. elim (rem_247  H).
   intro H. elim (rem_245  H).
  intros X1 X2. intro H. elim (rem_248 X1 X2 H).
  intros X1 X2. intro H. elim (rem_239 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_250 X1 X2 X3 H).
   intro H. elim (rem_242  H).
  intros X1 X2;  exact (rem_238 epsilon_m__def_33_pknows X1 X2).
   intro H. elim (rem_241  H).
  intros X1 X2. intro H. elim (rem_253 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_244 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_243 X1 X2 X3 H).
   intro H. elim (rem_249  H).
   intro H. elim (rem_251  H).
  intros X1. intro H. elim (rem_240 X1 H).
   intro H. elim (rem_252  H).
   intro H. elim (rem_246  H).
Qed.

Remark rem_255 : (forall X:term, auto___def_37 X -> auto_knows X)
    -> forall X1:term, auto___def_33 X1 -> auto_knows X1. (* Cut history. *)
Proof.  intros epsilon_m__def_37_pknows. exact (rem_254).
Defined.

Remark rem_256 : (forall X:term, auto___def_37 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_33 X1 -> auto___def_24 X2 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_37_pknows. intros X1 X2.
  cut (auto___def_33 X1 -> auto_knows X1). tauto. exact (rem_255 epsilon_m__def_37_pknows X1).
Defined.

Remark rem_257 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1:term, auto___def_42 X1 -> auto___def_42 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_258 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto___def_42 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2.
  cut (auto___def_42 X1 -> auto___def_42 X1). tauto. exact (rem_257 epsilon_m__type_5_pknows X1).
Defined.

Remark rem_259 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X2:term, auto___type_7 X2 -> auto___type_7 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_260 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto___type_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2.
  cut (auto___type_7 X2 -> auto___type_7 X2). tauto. exact (rem_259 epsilon_m__type_5_pknows X2).
Defined.

Remark rem_261 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> (auto___def_42 X1 /\ auto___type_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_42 X1). 2:apply (rem_258 epsilon_m__type_5_pknows X1 X2);  assumption.
  cut (auto___type_7 X2). 2:apply (rem_260 epsilon_m__type_5_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_262 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2. intros A1 A2.
  case (rem_261 epsilon_m__type_5_pknows X1 X2 A1 A2). clear  epsilon_m__type_5_pknows A1 A2. intros. apply trans_knows_crypt_1;  tauto.
 clear  epsilon_m__type_5_pknows A1 A2. tauto.
Defined.

Remark rem_263 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1:term, auto___def_12 X1 -> auto___def_12 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_264 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_12 X1). tauto. exact (rem_263 epsilon_m__type_5_pknows X1).
Defined.

Remark rem_265 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X2:term, auto___def_13 X2 -> auto___def_13 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_266 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_265 epsilon_m__type_5_pknows X2).
Defined.

Remark rem_267 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> (auto___def_12 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_12 X1). 2:apply (rem_264 epsilon_m__type_5_pknows X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_266 epsilon_m__type_5_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_268 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2. intros A1 A2.
  case (rem_267 epsilon_m__type_5_pknows X1 X2 A1 A2). clear  epsilon_m__type_5_pknows A1 A2. intros. apply trans_knows_crypt_2;  tauto.
 clear  epsilon_m__type_5_pknows A1 A2. tauto.
Defined.

Remark rem_269 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1:term, auto___def_22 X1 -> auto___def_22 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_270 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_22 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2.
  cut (auto___def_22 X1 -> auto___def_22 X1). tauto. exact (rem_269 epsilon_m__type_5_pknows X1).
Defined.

Remark rem_271 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X2:term, auto___def_23 X2 -> auto___def_23 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_272 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_271 epsilon_m__type_5_pknows X2).
Defined.

Remark rem_273 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> (auto___def_22 X1 /\ auto___def_23 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_22 X1). 2:apply (rem_270 epsilon_m__type_5_pknows X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_272 epsilon_m__type_5_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_274 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2. intros A1 A2.
  case (rem_273 epsilon_m__type_5_pknows X1 X2 A1 A2). clear  epsilon_m__type_5_pknows A1 A2. intros. apply trans_knows_crypt_3;  tauto.
 clear  epsilon_m__type_5_pknows A1 A2. tauto.
Defined.

Remark rem_275 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1:term, auto___def_37 X1 -> auto___def_37 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_276 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto___def_37 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2.
  cut (auto___def_37 X1 -> auto___def_37 X1). tauto. exact (rem_275 epsilon_m__type_5_pknows X1).
Defined.

Remark rem_277 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_271 epsilon_m__type_5_pknows X2).
Defined.

Remark rem_278 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> (auto___def_37 X1 /\ auto___def_23 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_37 X1). 2:apply (rem_276 epsilon_m__type_5_pknows X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_277 epsilon_m__type_5_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_279 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2. intros A1 A2.
  case (rem_278 epsilon_m__type_5_pknows X1 X2 A1 A2). clear  epsilon_m__type_5_pknows A1 A2. intros. apply trans_knows_crypt_4;  tauto.
 clear  epsilon_m__type_5_pknows A1 A2. tauto.
Defined.

Remark rem_280 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1:term, auto_knows X1 -> auto_knows X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_281 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2.
  cut (auto_knows X1 -> auto_knows X1). tauto. exact (rem_280 epsilon_m__type_5_pknows X1).
Defined.

Remark rem_282 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X2:term, auto_knows X2 -> auto_knows X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_283 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2.
  cut (auto_knows X2 -> auto_knows X2). tauto. exact (rem_282 epsilon_m__type_5_pknows X2).
Defined.

Remark rem_284 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> (auto_knows X1 /\ auto_knows X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2. intros A1 A2.
  cut (auto_knows X1). 2:apply (rem_281 epsilon_m__type_5_pknows X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_283 epsilon_m__type_5_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_285 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2. intros A1 A2.
  case (rem_284 epsilon_m__type_5_pknows X1 X2 A1 A2). clear  epsilon_m__type_5_pknows A1 A2. intros. apply trans_knows_crypt_5;  tauto.
 clear  epsilon_m__type_5_pknows A1 A2. tauto.
Defined.

Remark rem_286 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1:term, auto___def_40 X1 -> auto___def_40 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_287 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> auto___def_40 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2.
  cut (auto___def_40 X1 -> auto___def_40 X1). tauto. exact (rem_286 epsilon_m__type_5_pknows X1).
Defined.

Remark rem_288 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X2:term, auto___type_6 X2 -> auto___type_6 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_289 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> auto___type_6 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2.
  cut (auto___type_6 X2 -> auto___type_6 X2). tauto. exact (rem_288 epsilon_m__type_5_pknows X2).
Defined.

Remark rem_290 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> (auto___def_40 X1 /\ auto___type_6 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_40 X1). 2:apply (rem_287 epsilon_m__type_5_pknows X1 X2);  assumption.
  cut (auto___type_6 X2). 2:apply (rem_289 epsilon_m__type_5_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_291 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2. intros A1 A2.
  case (rem_290 epsilon_m__type_5_pknows X1 X2 A1 A2). clear  epsilon_m__type_5_pknows A1 A2. intros. apply trans_knows_crypt_6;  tauto.
 clear  epsilon_m__type_5_pknows A1 A2. tauto.
Defined.

Remark rem_292 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1:term, auto___def_30 X1 -> auto___def_30 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_293 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> auto___def_30 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2.
  cut (auto___def_30 X1 -> auto___def_30 X1). tauto. exact (rem_292 epsilon_m__type_5_pknows X1).
Defined.

Remark rem_294 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_265 epsilon_m__type_5_pknows X2).
Defined.

Remark rem_295 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> (auto___def_30 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_30 X1). 2:apply (rem_293 epsilon_m__type_5_pknows X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_294 epsilon_m__type_5_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_296 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2. intros A1 A2.
  case (rem_295 epsilon_m__type_5_pknows X1 X2 A1 A2). clear  epsilon_m__type_5_pknows A1 A2. intros. apply trans_knows_crypt_7;  tauto.
 clear  epsilon_m__type_5_pknows A1 A2. tauto.
Defined.

Remark rem_297 : forall X1 X2:term, auto___type_5 (crypt X1 X2) -> or_7
    (auto___def_42 X1 /\ auto___type_7 X2)
    (auto___def_12 X1 /\ auto___def_13 X2)
    (auto___def_22 X1 /\ auto___def_23 X2)
    (auto___def_37 X1 /\ auto___def_23 X2)
    (auto_knows X1 /\ auto_knows X2)
    (auto___def_40 X1 /\ auto___type_6 X2)
    (auto___def_30 X1 /\ auto___def_13 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_7_intro_1; tauto.
  intros. apply or_7_intro_2; tauto.
  intros. apply or_7_intro_3; tauto.
  intros. apply or_7_intro_4; tauto.
  intros. apply or_7_intro_5; tauto.
  intros. apply or_7_intro_6; tauto.
  intros. apply or_7_intro_7; tauto.
Qed.

Remark rem_298 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_5 (crypt X1 X2) -> auto_knows (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2. intro H. intros.
  elim (rem_297 X1 X2 H);  intros.
  apply (rem_262 epsilon_m__type_5_pknows X1 X2);  tauto.
  apply (rem_268 epsilon_m__type_5_pknows X1 X2);  tauto.
  apply (rem_274 epsilon_m__type_5_pknows X1 X2);  tauto.
  apply (rem_279 epsilon_m__type_5_pknows X1 X2);  tauto.
  apply (rem_285 epsilon_m__type_5_pknows X1 X2);  tauto.
  apply (rem_291 epsilon_m__type_5_pknows X1 X2);  tauto.
  apply (rem_296 epsilon_m__type_5_pknows X1 X2);  tauto.
Defined.

Remark rem_299 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1:term, auto_knows X1 -> auto_knows X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1. intros A1.
  cut (auto_knows X1). 2:apply (rem_280 epsilon_m__type_5_pknows X1);  assumption.
  tauto.
Defined.

Remark rem_300 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1:term, auto_knows X1 -> auto_knows (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1. intros A1.
  case (rem_299 epsilon_m__type_5_pknows X1 A1). clear  epsilon_m__type_5_pknows A1. intros. apply trans_knows_s_1;  tauto.
 clear  epsilon_m__type_5_pknows A1. tauto.
Defined.

Remark rem_301 : forall X1:term, auto___type_5 (s X1) -> or_1
    (auto_knows X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_302 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1:term, auto___type_5 (s X1) -> auto_knows (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1. intro H. intros.
  elim (rem_301 X1 H);  intros.
  apply (rem_300 epsilon_m__type_5_pknows X1);  tauto.
Defined.

Remark rem_303 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_5_pknows.  tauto.
Defined.

Remark rem_304 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> auto_knows nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows.  case (rem_303 epsilon_m__type_5_pknows). clear  epsilon_m__type_5_pknows. intros. apply trans_knows_nil_1;  tauto.
 clear  epsilon_m__type_5_pknows. tauto.
Defined.

Remark rem_305 : auto___type_5 nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_306 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> auto___type_5 nil -> auto_knows nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_5_pknows. intro H. intros.
  elim (rem_305 H);  intros.
  apply (rem_304 epsilon_m__type_5_pknows);  tauto.
Defined.

Remark rem_307 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> auto_knows i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows.  case (rem_303 epsilon_m__type_5_pknows). clear  epsilon_m__type_5_pknows. intros. apply trans_knows_i_1;  tauto.
 clear  epsilon_m__type_5_pknows. tauto.
Defined.

Remark rem_308 : auto___type_5 i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_309 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> auto___type_5 i -> auto_knows i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_5_pknows. intro H. intros.
  elim (rem_308 H);  intros.
  apply (rem_307 epsilon_m__type_5_pknows);  tauto.
Defined.

Remark rem_310 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1:term, auto___def_33 X1 -> auto___def_33 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_311 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___def_33 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2 X3.
  cut (auto___def_33 X1 -> auto___def_33 X1). tauto. exact (rem_310 epsilon_m__type_5_pknows X1).
Defined.

Remark rem_312 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X2:term, auto___type_5 X2 -> auto___type_5 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_313 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2 X3.
  cut (auto___type_5 X2 -> auto___type_5 X2). tauto. exact (rem_312 epsilon_m__type_5_pknows X2).
Defined.

Remark rem_314 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X3:term, auto___type_4 X3 -> auto___type_4 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_315 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_4 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2 X3.
  cut (auto___type_4 X3 -> auto___type_4 X3). tauto. exact (rem_314 epsilon_m__type_5_pknows X3).
Defined.

Remark rem_316 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> (auto___def_33 X1 /\ auto___type_5 X2 /\ auto___type_4 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_33 X1). 2:apply (rem_311 epsilon_m__type_5_pknows X1 X2 X3);  assumption.
  cut (auto___type_5 X2). 2:apply (rem_313 epsilon_m__type_5_pknows X1 X2 X3);  assumption.
  cut (auto___type_4 X3). 2:apply (rem_315 epsilon_m__type_5_pknows X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_317 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto_knows (nonceb X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_316 epsilon_m__type_5_pknows X1 X2 X3 A1 A2 A3). clear  epsilon_m__type_5_pknows A1 A2 A3. intros. apply trans_knows_nonceb_1;  tauto.
 clear  epsilon_m__type_5_pknows A1 A2 A3. tauto.
Defined.

Remark rem_318 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1:term, auto___def_16 X1 -> auto___def_16 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_319 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___def_16 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2 X3.
  cut (auto___def_16 X1 -> auto___def_16 X1). tauto. exact (rem_318 epsilon_m__type_5_pknows X1).
Defined.

Remark rem_320 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2 X3.
  cut (auto___type_5 X2 -> auto___type_5 X2). tauto. exact (rem_312 epsilon_m__type_5_pknows X2).
Defined.

Remark rem_321 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_4 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2 X3.
  cut (auto___type_4 X3 -> auto___type_4 X3). tauto. exact (rem_314 epsilon_m__type_5_pknows X3).
Defined.

Remark rem_322 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> (auto___def_16 X1 /\ auto___type_5 X2 /\ auto___type_4 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_16 X1). 2:apply (rem_319 epsilon_m__type_5_pknows X1 X2 X3);  assumption.
  cut (auto___type_5 X2). 2:apply (rem_320 epsilon_m__type_5_pknows X1 X2 X3);  assumption.
  cut (auto___type_4 X3). 2:apply (rem_321 epsilon_m__type_5_pknows X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_323 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto_knows (nonceb X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_322 epsilon_m__type_5_pknows X1 X2 X3 A1 A2 A3). clear  epsilon_m__type_5_pknows A1 A2 A3. intros. apply trans_knows_nonceb_2;  tauto.
 clear  epsilon_m__type_5_pknows A1 A2 A3. tauto.
Defined.

Remark rem_324 : forall X1 X2 X3:term, auto___type_5 (nonceb X1 X2 X3) -> or_2
    (auto___def_33 X1 /\ auto___type_5 X2 /\ auto___type_4 X3)
    (auto___def_16 X1 /\ auto___type_5 X2 /\ auto___type_4 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_325 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___type_5 (nonceb X1 X2 X3) -> auto_knows (nonceb X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2 X3. intro H. intros.
  elim (rem_324 X1 X2 X3 H);  intros.
  apply (rem_317 epsilon_m__type_5_pknows X1 X2 X3);  tauto.
  apply (rem_323 epsilon_m__type_5_pknows X1 X2 X3);  tauto.
Defined.

Remark rem_326 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> auto_knows bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows.  case (rem_303 epsilon_m__type_5_pknows). clear  epsilon_m__type_5_pknows. intros. apply trans_knows_bob_1;  tauto.
 clear  epsilon_m__type_5_pknows. tauto.
Defined.

Remark rem_327 : auto___type_5 bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_328 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> auto___type_5 bob -> auto_knows bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_5_pknows. intro H. intros.
  elim (rem_327 H);  intros.
  apply (rem_326 epsilon_m__type_5_pknows);  tauto.
Defined.

Remark rem_329 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1:term, auto___def_43 X1 -> auto___def_43 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_330 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> auto___def_43 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_43 X1). tauto. exact (rem_329 epsilon_m__type_5_pknows X1).
Defined.

Remark rem_331 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_332 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_331 epsilon_m__type_5_pknows X2).
Defined.

Remark rem_333 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> (auto___def_43 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_43 X1). 2:apply (rem_330 epsilon_m__type_5_pknows X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_332 epsilon_m__type_5_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_334 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> auto_knows (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2. intros A1 A2.
  case (rem_333 epsilon_m__type_5_pknows X1 X2 A1 A2). clear  epsilon_m__type_5_pknows A1 A2. intros. apply trans_knows_key_1;  tauto.
 clear  epsilon_m__type_5_pknows A1 A2. tauto.
Defined.

Remark rem_335 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1:term, auto___def_46 X1 -> auto___def_46 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_336 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_46 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2.
  cut (auto___def_46 X1 -> auto___def_46 X1). tauto. exact (rem_335 epsilon_m__type_5_pknows X1).
Defined.

Remark rem_337 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X2:term, auto___def_47 X2 -> auto___def_47 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_338 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_47 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2.
  cut (auto___def_47 X2 -> auto___def_47 X2). tauto. exact (rem_337 epsilon_m__type_5_pknows X2).
Defined.

Remark rem_339 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> (auto___def_46 X1 /\ auto___def_47 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_46 X1). 2:apply (rem_336 epsilon_m__type_5_pknows X1 X2);  assumption.
  cut (auto___def_47 X2). 2:apply (rem_338 epsilon_m__type_5_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_340 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto_knows (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2. intros A1 A2.
  case (rem_339 epsilon_m__type_5_pknows X1 X2 A1 A2). clear  epsilon_m__type_5_pknows A1 A2. intros. apply trans_knows_key_2;  tauto.
 clear  epsilon_m__type_5_pknows A1 A2. tauto.
Defined.

Remark rem_341 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1:term, auto___def_44 X1 -> auto___def_44 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_342 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> auto___def_44 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2.
  cut (auto___def_44 X1 -> auto___def_44 X1). tauto. exact (rem_341 epsilon_m__type_5_pknows X1).
Defined.

Remark rem_343 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X2:term, auto___def_45 X2 -> auto___def_45 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_344 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> auto___def_45 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2.
  cut (auto___def_45 X2 -> auto___def_45 X2). tauto. exact (rem_343 epsilon_m__type_5_pknows X2).
Defined.

Remark rem_345 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> (auto___def_44 X1 /\ auto___def_45 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_44 X1). 2:apply (rem_342 epsilon_m__type_5_pknows X1 X2);  assumption.
  cut (auto___def_45 X2). 2:apply (rem_344 epsilon_m__type_5_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_346 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> auto_knows (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2. intros A1 A2.
  case (rem_345 epsilon_m__type_5_pknows X1 X2 A1 A2). clear  epsilon_m__type_5_pknows A1 A2. intros. apply trans_knows_key_3;  tauto.
 clear  epsilon_m__type_5_pknows A1 A2. tauto.
Defined.

Remark rem_347 : forall X1 X2:term, auto___type_5 (key X1 X2) -> or_3
    (auto___def_43 X1 /\ auto___type_8 X2)
    (auto___def_46 X1 /\ auto___def_47 X2)
    (auto___def_44 X1 /\ auto___def_45 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_348 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_5 (key X1 X2) -> auto_knows (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2. intro H. intros.
  elim (rem_347 X1 X2 H);  intros.
  apply (rem_334 epsilon_m__type_5_pknows X1 X2);  tauto.
  apply (rem_340 epsilon_m__type_5_pknows X1 X2);  tauto.
  apply (rem_346 epsilon_m__type_5_pknows X1 X2);  tauto.
Defined.

Remark rem_349 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> auto_knows alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows.  case (rem_303 epsilon_m__type_5_pknows). clear  epsilon_m__type_5_pknows. intros. apply trans_knows_alice_1;  tauto.
 clear  epsilon_m__type_5_pknows. tauto.
Defined.

Remark rem_350 : auto___type_5 alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_351 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> auto___type_5 alice -> auto_knows alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_5_pknows. intro H. intros.
  elim (rem_350 H);  intros.
  apply (rem_349 epsilon_m__type_5_pknows);  tauto.
Defined.

Remark rem_352 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto_knows (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2. intros A1 A2.
  case (rem_284 epsilon_m__type_5_pknows X1 X2 A1 A2). clear  epsilon_m__type_5_pknows A1 A2. intros. apply trans_knows_cons_1;  tauto.
 clear  epsilon_m__type_5_pknows A1 A2. tauto.
Defined.

Remark rem_353 : forall X1 X2:term, auto___type_5 (cons X1 X2) -> or_1
    (auto_knows X1 /\ auto_knows X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_354 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_5 (cons X1 X2) -> auto_knows (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2. intro H. intros.
  elim (rem_353 X1 X2 H);  intros.
  apply (rem_352 epsilon_m__type_5_pknows X1 X2);  tauto.
Defined.

Remark rem_355 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> auto_knows server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows.  case (rem_303 epsilon_m__type_5_pknows). clear  epsilon_m__type_5_pknows. intros. apply trans_knows_server_1;  tauto.
 clear  epsilon_m__type_5_pknows. tauto.
Defined.

Remark rem_356 : auto___type_5 server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_357 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> auto___type_5 server -> auto_knows server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_5_pknows. intro H. intros.
  elim (rem_356 H);  intros.
  apply (rem_355 epsilon_m__type_5_pknows);  tauto.
Defined.

Remark rem_358 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_359 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_358 epsilon_m__type_5_pknows X1).
Defined.

Remark rem_360 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_361 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_360 epsilon_m__type_5_pknows X2).
Defined.

Remark rem_362 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> (auto_agent X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2. intros A1 A2.
  cut (auto_agent X1). 2:apply (rem_359 epsilon_m__type_5_pknows X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_361 epsilon_m__type_5_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_363 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_knows (noncea X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2. intros A1 A2.
  case (rem_362 epsilon_m__type_5_pknows X1 X2 A1 A2). clear  epsilon_m__type_5_pknows A1 A2. intros. apply trans_knows_noncea_1;  tauto.
 clear  epsilon_m__type_5_pknows A1 A2. tauto.
Defined.

Remark rem_364 : forall X1 X2:term, auto___type_5 (noncea X1 X2) -> or_1
    (auto_agent X1 /\ auto_agent X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_365 : (forall X:term, auto___type_5 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_5 (noncea X1 X2) -> auto_knows (noncea X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_5_pknows. intros X1 X2. intro H. intros.
  elim (rem_364 X1 X2 H);  intros.
  apply (rem_363 epsilon_m__type_5_pknows X1 X2);  tauto.
Defined.

Remark rem_366 : forall X1 X2 X3:term, auto___type_5 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_367 : auto___type_5 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_368 : auto___type_5 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_369 : forall X1 X2 X3:term, auto___type_5 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_370 : auto___type_5 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_371 : forall X1:term, auto___type_5 X1 -> auto_knows X1. (* Induct. *)
Proof.
  fix epsilon_m__type_5_pknows 1.
  intro X. case X.
  exact (rem_351 epsilon_m__type_5_pknows ).
  exact (rem_328 epsilon_m__type_5_pknows ).
  intros X1 X2;  exact (rem_354 epsilon_m__type_5_pknows X1 X2).
  intros X1 X2;  exact (rem_298 epsilon_m__type_5_pknows X1 X2).
  intros X1 X2 X3. intro H. elim (rem_369 X1 X2 X3 H).
  exact (rem_309 epsilon_m__type_5_pknows ).
  intros X1 X2;  exact (rem_348 epsilon_m__type_5_pknows X1 X2).
  exact (rem_306 epsilon_m__type_5_pknows ).
  intros X1 X2;  exact (rem_365 epsilon_m__type_5_pknows X1 X2).
  intros X1 X2 X3;  exact (rem_325 epsilon_m__type_5_pknows X1 X2 X3).
  intros X1 X2 X3. intro H. elim (rem_366 X1 X2 X3 H).
   intro H. elim (rem_368  H).
   intro H. elim (rem_370  H).
  intros X1;  exact (rem_302 epsilon_m__type_5_pknows X1).
  exact (rem_357 epsilon_m__type_5_pknows ).
   intro H. elim (rem_367  H).
Qed.

Remark rem_372 : (forall X:term, auto___def_24 X -> auto_knows X)
    -> forall X1:term, auto___type_5 X1 -> auto_knows X1. (* Cut history. *)
Proof.  intros epsilon_m__def_24_pknows. exact (rem_371).
Defined.

Remark rem_373 : (forall X:term, auto___def_24 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_5 X1 -> auto___def_21 X2 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_24_pknows. intros X1 X2.
  cut (auto___type_5 X1 -> auto_knows X1). tauto. exact (rem_372 epsilon_m__def_24_pknows X1).
Defined.

Remark rem_374 : (forall X:term, auto___def_21 X -> auto_knows X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_21_pknows.  tauto.
Defined.

Remark rem_375 : (forall X:term, auto___def_21 X -> auto_knows X)
    -> auto_knows nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_21_pknows.  case (rem_374 epsilon_m__def_21_pknows). clear  epsilon_m__def_21_pknows. intros. apply trans_knows_nil_1;  tauto.
 clear  epsilon_m__def_21_pknows. tauto.
Defined.

Remark rem_376 : auto___def_21 nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_377 : (forall X:term, auto___def_21 X -> auto_knows X)
    -> auto___def_21 nil -> auto_knows nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_21_pknows. intro H. intros.
  elim (rem_376 H);  intros.
  apply (rem_375 epsilon_m__def_21_pknows);  tauto.
Defined.

Remark rem_378 : forall X1 X2:term, auto___def_21 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_379 : forall X1:term, auto___def_21 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_380 : auto___def_21 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_381 : forall X1 X2 X3:term, auto___def_21 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_382 : forall X1 X2 X3:term, auto___def_21 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_383 : auto___def_21 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_384 : forall X1 X2:term, auto___def_21 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_385 : auto___def_21 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_386 : auto___def_21 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_387 : forall X1 X2:term, auto___def_21 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_388 : auto___def_21 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_389 : forall X1 X2 X3:term, auto___def_21 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_390 : auto___def_21 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_391 : auto___def_21 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_392 : forall X1 X2:term, auto___def_21 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_393 : forall X2:term, auto___def_21 X2 -> auto_knows X2. (* Induct. *)
Proof.
  fix epsilon_m__def_21_pknows 1.
  intro X. case X.
   intro H. elim (rem_386  H).
   intro H. elim (rem_383  H).
  intros X1 X2. intro H. elim (rem_387 X1 X2 H).
  intros X1 X2. intro H. elim (rem_378 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_389 X1 X2 X3 H).
   intro H. elim (rem_380  H).
  intros X1 X2. intro H. elim (rem_384 X1 X2 H).
  exact (rem_377 epsilon_m__def_21_pknows ).
  intros X1 X2. intro H. elim (rem_392 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_382 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_381 X1 X2 X3 H).
   intro H. elim (rem_388  H).
   intro H. elim (rem_390  H).
  intros X1. intro H. elim (rem_379 X1 H).
   intro H. elim (rem_391  H).
   intro H. elim (rem_385  H).
Qed.

Remark rem_394 : (forall X:term, auto___def_24 X -> auto_knows X)
    -> forall X2:term, auto___def_21 X2 -> auto_knows X2. (* Cut history. *)
Proof.  intros epsilon_m__def_24_pknows. exact (rem_393).
Defined.

Remark rem_395 : (forall X:term, auto___def_24 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_5 X1 -> auto___def_21 X2 -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_24_pknows. intros X1 X2.
  cut (auto___def_21 X2 -> auto_knows X2). tauto. exact (rem_394 epsilon_m__def_24_pknows X2).
Defined.

Remark rem_396 : (forall X:term, auto___def_24 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_5 X1 -> auto___def_21 X2 -> (auto_knows X1 /\ auto_knows X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_24_pknows. intros X1 X2. intros A1 A2.
  cut (auto_knows X1). 2:apply (rem_373 epsilon_m__def_24_pknows X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_395 epsilon_m__def_24_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_397 : (forall X:term, auto___def_24 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_5 X1 -> auto___def_21 X2 -> auto_knows (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_24_pknows. intros X1 X2. intros A1 A2.
  case (rem_396 epsilon_m__def_24_pknows X1 X2 A1 A2). clear  epsilon_m__def_24_pknows A1 A2. intros. apply trans_knows_cons_1;  tauto.
 clear  epsilon_m__def_24_pknows A1 A2. tauto.
Defined.

Remark rem_398 : forall X1 X2:term, auto___def_24 (cons X1 X2) -> or_1
    (auto___type_5 X1 /\ auto___def_21 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_399 : (forall X:term, auto___def_24 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_24 (cons X1 X2) -> auto_knows (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_24_pknows. intros X1 X2. intro H. intros.
  elim (rem_398 X1 X2 H);  intros.
  apply (rem_397 epsilon_m__def_24_pknows X1 X2);  tauto.
Defined.

Remark rem_400 : forall X1 X2:term, auto___def_24 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_401 : forall X1:term, auto___def_24 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_402 : auto___def_24 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_403 : auto___def_24 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_404 : forall X1 X2 X3:term, auto___def_24 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_405 : forall X1 X2 X3:term, auto___def_24 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_406 : auto___def_24 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_407 : forall X1 X2:term, auto___def_24 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_408 : auto___def_24 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_409 : auto___def_24 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_410 : auto___def_24 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_411 : forall X1 X2 X3:term, auto___def_24 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_412 : auto___def_24 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_413 : auto___def_24 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_414 : forall X1 X2:term, auto___def_24 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_415 : forall X2:term, auto___def_24 X2 -> auto_knows X2. (* Induct. *)
Proof.
  fix epsilon_m__def_24_pknows 1.
  intro X. case X.
   intro H. elim (rem_409  H).
   intro H. elim (rem_406  H).
  intros X1 X2;  exact (rem_399 epsilon_m__def_24_pknows X1 X2).
  intros X1 X2. intro H. elim (rem_400 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_411 X1 X2 X3 H).
   intro H. elim (rem_403  H).
  intros X1 X2. intro H. elim (rem_407 X1 X2 H).
   intro H. elim (rem_402  H).
  intros X1 X2. intro H. elim (rem_414 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_405 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_404 X1 X2 X3 H).
   intro H. elim (rem_410  H).
   intro H. elim (rem_412  H).
  intros X1. intro H. elim (rem_401 X1 H).
   intro H. elim (rem_413  H).
   intro H. elim (rem_408  H).
Qed.

Remark rem_416 : (forall X:term, auto___def_37 X -> auto_knows X)
    -> forall X2:term, auto___def_24 X2 -> auto_knows X2. (* Cut history. *)
Proof.  intros epsilon_m__def_37_pknows. exact (rem_415).
Defined.

Remark rem_417 : (forall X:term, auto___def_37 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_33 X1 -> auto___def_24 X2 -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_37_pknows. intros X1 X2.
  cut (auto___def_24 X2 -> auto_knows X2). tauto. exact (rem_416 epsilon_m__def_37_pknows X2).
Defined.

Remark rem_418 : (forall X:term, auto___def_37 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_33 X1 -> auto___def_24 X2 -> (auto_knows X1 /\ auto_knows X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_37_pknows. intros X1 X2. intros A1 A2.
  cut (auto_knows X1). 2:apply (rem_256 epsilon_m__def_37_pknows X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_417 epsilon_m__def_37_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_419 : (forall X:term, auto___def_37 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_33 X1 -> auto___def_24 X2 -> auto_knows (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_37_pknows. intros X1 X2. intros A1 A2.
  case (rem_418 epsilon_m__def_37_pknows X1 X2 A1 A2). clear  epsilon_m__def_37_pknows A1 A2. intros. apply trans_knows_cons_1;  tauto.
 clear  epsilon_m__def_37_pknows A1 A2. tauto.
Defined.

Remark rem_420 : forall X1 X2:term, auto___def_37 (cons X1 X2) -> or_1
    (auto___def_33 X1 /\ auto___def_24 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_421 : (forall X:term, auto___def_37 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_37 (cons X1 X2) -> auto_knows (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_37_pknows. intros X1 X2. intro H. intros.
  elim (rem_420 X1 X2 H);  intros.
  apply (rem_419 epsilon_m__def_37_pknows X1 X2);  tauto.
Defined.

Remark rem_422 : forall X1 X2:term, auto___def_37 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_423 : forall X1:term, auto___def_37 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_424 : auto___def_37 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_425 : auto___def_37 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_426 : forall X1 X2 X3:term, auto___def_37 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_427 : forall X1 X2 X3:term, auto___def_37 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_428 : auto___def_37 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_429 : forall X1 X2:term, auto___def_37 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_430 : auto___def_37 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_431 : auto___def_37 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_432 : auto___def_37 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_433 : forall X1 X2 X3:term, auto___def_37 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_434 : auto___def_37 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_435 : auto___def_37 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_436 : forall X1 X2:term, auto___def_37 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_437 : forall X1:term, auto___def_37 X1 -> auto_knows X1. (* Induct. *)
Proof.
  fix epsilon_m__def_37_pknows 1.
  intro X. case X.
   intro H. elim (rem_431  H).
   intro H. elim (rem_428  H).
  intros X1 X2;  exact (rem_421 epsilon_m__def_37_pknows X1 X2).
  intros X1 X2. intro H. elim (rem_422 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_433 X1 X2 X3 H).
   intro H. elim (rem_425  H).
  intros X1 X2. intro H. elim (rem_429 X1 X2 H).
   intro H. elim (rem_424  H).
  intros X1 X2. intro H. elim (rem_436 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_427 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_426 X1 X2 X3 H).
   intro H. elim (rem_432  H).
   intro H. elim (rem_434  H).
  intros X1. intro H. elim (rem_423 X1 H).
   intro H. elim (rem_435  H).
   intro H. elim (rem_430  H).
Qed.

Remark rem_438 : forall X1 X2:term, auto___def_16 X2 -> auto___def_23 X2 -> auto___def_37 X1 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_37 X1 -> auto_knows X1). tauto. exact (rem_437 X1).
Qed.

Remark rem_439 : forall X1 X2:term, auto___def_16 X2 -> auto___def_23 X2 -> auto___def_37 X1 -> auto_knows X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto_knows X1). 2:apply (rem_438 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_440 : forall X1 X2:term, auto___def_16 X2 -> auto___def_23 X2 -> auto___def_37 X1 -> auto___def_42 (s X1). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_439 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_42_s_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_441 : forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto___def_16 X2 -> auto___def_42 (s X1). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_16 X2 -> auto___def_23 X2 -> auto___def_37 X1 -> auto___def_42 (s X1)). tauto. exact (rem_440 X1 X2).
Qed.

Remark rem_442 : (forall X:term, auto___def_25 X -> auto___def_35 X -> False)
    -> forall X1 X2:term, auto___def_35 (cons X1 X2) -> auto___type_4 X1 -> auto___def_26 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_25_m__def_35. intros X1 X2. intro H. intros.
  elim (rem_226 X1 X2 H);  intros.
Defined.

Remark rem_443 : forall X1 X2:term, auto___def_25 (cons X1 X2) -> or_1
    (auto___type_4 X1 /\ auto___def_26 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_444 : (forall X:term, auto___def_25 X -> auto___def_35 X -> False)
    -> forall X1 X2:term, auto___def_25 (cons X1 X2) -> auto___def_35 (cons X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_25_m__def_35. intros X1 X2. intro H. intros.
  elim (rem_443 X1 X2 H);  intros.
  apply (rem_442 epsilon_m__def_25_m__def_35 X1 X2);  tauto.
Defined.

Remark rem_445 : forall X1 X2:term, auto___def_25 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_446 : forall X1:term, auto___def_25 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_447 : auto___def_25 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_448 : auto___def_25 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_449 : forall X1 X2 X3:term, auto___def_25 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_450 : forall X1 X2 X3:term, auto___def_25 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_451 : auto___def_25 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_452 : forall X1 X2:term, auto___def_25 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_453 : auto___def_25 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_454 : auto___def_25 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_455 : auto___def_25 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_456 : auto___def_25 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_457 : auto___def_25 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_458 : forall X1 X2:term, auto___def_25 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_459 : forall X2:term, auto___def_25 X2 -> auto___def_35 X2 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_25_m__def_35 1.
  intro X. case X.
   intro H. elim (rem_454  H).
   intro H. elim (rem_451  H).
  intros X1 X2;  exact (rem_444 epsilon_m__def_25_m__def_35 X1 X2).
  intros X1 X2. intro H. elim (rem_445 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_164 X1 X2 X3 H).
   intro H. elim (rem_448  H).
  intros X1 X2. intro H. elim (rem_452 X1 X2 H).
   intro H. elim (rem_447  H).
  intros X1 X2. intro H. elim (rem_458 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_450 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_449 X1 X2 X3 H).
   intro H. elim (rem_455  H).
   intro H. elim (rem_456  H).
  intros X1. intro H. elim (rem_446 X1 H).
   intro H. elim (rem_457  H).
   intro H. elim (rem_453  H).
Qed.

Remark rem_460 : (forall X:term, auto___def_23 X -> auto___def_33 X -> False)
    -> forall X2:term, auto___def_25 X2 -> auto___def_35 X2 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_23_m__def_33. exact (rem_459).
Defined.

Remark rem_461 : (forall X:term, auto___def_23 X -> auto___def_33 X -> False)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_25 X2 -> auto___def_35 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_23_m__def_33. intros X1 X2.
  cut (auto___def_25 X2 -> auto___def_35 X2 -> False). clear  epsilon_m__def_23_m__def_33. tauto.
  exact (rem_460 epsilon_m__def_23_m__def_33 X2).
Defined.

Remark rem_462 : (forall X:term, auto___def_23 X -> auto___def_33 X -> False)
    -> forall X1 X2:term, auto___def_33 (key X1 X2) -> auto___def_18 X1 -> auto___def_25 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_23_m__def_33. intros X1 X2. intro H. intros.
  elim (rem_237 X1 X2 H);  intros.
  apply (rem_461 epsilon_m__def_23_m__def_33 X1 X2);  tauto.
Defined.

Remark rem_463 : (forall X:term, auto___def_23 X -> auto___def_33 X -> False)
    -> forall X1 X2:term, auto___def_23 (key X1 X2) -> auto___def_33 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_23_m__def_33. intros X1 X2. intro H. intros.
  elim (rem_171 X1 X2 H);  intros.
  apply (rem_462 epsilon_m__def_23_m__def_33 X1 X2);  tauto.
Defined.

Remark rem_464 : forall X1:term, auto___def_23 X1 -> auto___def_33 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_23_m__def_33 1.
  intro X. case X.
   intro H. elim (rem_181  H).
   intro H. elim (rem_179  H).
  intros X1 X2. intro H. elim (rem_182 X1 X2 H).
  intros X1 X2. intro H. elim (rem_173 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_184 X1 X2 X3 H).
   intro H. elim (rem_176  H).
  intros X1 X2;  exact (rem_463 epsilon_m__def_23_m__def_33 X1 X2).
   intro H. elim (rem_175  H).
  intros X1 X2. intro H. elim (rem_187 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_178 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_177 X1 X2 X3 H).
   intro H. elim (rem_183  H).
   intro H. elim (rem_185  H).
  intros X1. intro H. elim (rem_174 X1 H).
   intro H. elim (rem_186  H).
   intro H. elim (rem_180  H).
Qed.

Remark rem_465 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_33 X2 -> auto___def_42 (s X1). (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_464 X2)). tauto.
Qed.

Remark rem_466 : forall X1:term, auto_knows X1 -> auto_knows X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_467 : forall X1 X2:term, auto___def_33 X2 -> auto_knows X2 -> auto_knows X1 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows X1 -> auto_knows X1). tauto. exact (rem_466 X1).
Qed.

Remark rem_468 : forall X1 X2:term, auto___def_33 X2 -> auto_knows X2 -> auto_knows X1 -> auto_knows X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto_knows X1). 2:apply (rem_467 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_469 : forall X1 X2:term, auto___def_33 X2 -> auto_knows X2 -> auto_knows X1 -> auto___def_42 (s X1). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_468 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_42_s_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_470 : forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto___def_33 X2 -> auto___def_42 (s X1). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_33 X2 -> auto_knows X2 -> auto_knows X1 -> auto___def_42 (s X1)). tauto. exact (rem_469 X1 X2).
Qed.

Remark rem_471 : (forall X:term, auto___def_29 X -> auto___def_35 X -> False)
    -> forall X1 X2:term, auto___def_35 (cons X1 X2) -> auto___type_5 X1 -> auto___def_26 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_29_m__def_35. intros X1 X2. intro H. intros.
  elim (rem_226 X1 X2 H);  intros.
Defined.

Remark rem_472 : forall X1 X2:term, auto___def_29 (cons X1 X2) -> or_1
    (auto___type_5 X1 /\ auto___def_26 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_473 : (forall X:term, auto___def_29 X -> auto___def_35 X -> False)
    -> forall X1 X2:term, auto___def_29 (cons X1 X2) -> auto___def_35 (cons X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_29_m__def_35. intros X1 X2. intro H. intros.
  elim (rem_472 X1 X2 H);  intros.
  apply (rem_471 epsilon_m__def_29_m__def_35 X1 X2);  tauto.
Defined.

Remark rem_474 : forall X1 X2:term, auto___def_29 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_475 : forall X1:term, auto___def_29 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_476 : auto___def_29 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_477 : auto___def_29 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_478 : forall X1 X2 X3:term, auto___def_29 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_479 : forall X1 X2 X3:term, auto___def_29 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_480 : auto___def_29 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_481 : forall X1 X2:term, auto___def_29 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_482 : auto___def_29 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_483 : auto___def_29 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_484 : auto___def_29 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_485 : auto___def_29 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_486 : auto___def_29 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_487 : forall X1 X2:term, auto___def_29 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_488 : forall X2:term, auto___def_29 X2 -> auto___def_35 X2 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_29_m__def_35 1.
  intro X. case X.
   intro H. elim (rem_483  H).
   intro H. elim (rem_480  H).
  intros X1 X2;  exact (rem_473 epsilon_m__def_29_m__def_35 X1 X2).
  intros X1 X2. intro H. elim (rem_474 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_120 X1 X2 X3 H).
   intro H. elim (rem_477  H).
  intros X1 X2. intro H. elim (rem_481 X1 X2 H).
   intro H. elim (rem_476  H).
  intros X1 X2. intro H. elim (rem_487 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_479 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_478 X1 X2 X3 H).
   intro H. elim (rem_484  H).
   intro H. elim (rem_485  H).
  intros X1. intro H. elim (rem_475 X1 H).
   intro H. elim (rem_486  H).
   intro H. elim (rem_482  H).
Qed.

Remark rem_489 : (forall X:term, auto___def_33 X -> auto___def_13 X -> False)
    -> forall X2:term, auto___def_29 X2 -> auto___def_35 X2 -> False. (* Cut history. *)
Proof.  intros epsilon_m__def_33_m__def_13. exact (rem_488).
Defined.

Remark rem_490 : (forall X:term, auto___def_33 X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_29 X2 -> auto___def_18 X1 -> auto___def_35 X2 -> False. (* Split. *)
Proof.
  intros epsilon_m__def_33_m__def_13. intros X1 X2.
  cut (auto___def_29 X2 -> auto___def_35 X2 -> False). clear  epsilon_m__def_33_m__def_13. tauto.
  exact (rem_489 epsilon_m__def_33_m__def_13 X2).
Defined.

Remark rem_491 : (forall X:term, auto___def_33 X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_13 (key X1 X2) -> auto___def_18 X1 -> auto___def_35 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_33_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_142 X1 X2 H);  intros.
  apply (rem_490 epsilon_m__def_33_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_492 : (forall X:term, auto___def_33 X -> auto___def_13 X -> False)
    -> forall X1 X2:term, auto___def_33 (key X1 X2) -> auto___def_13 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_33_m__def_13. intros X1 X2. intro H. intros.
  elim (rem_237 X1 X2 H);  intros.
  apply (rem_491 epsilon_m__def_33_m__def_13 X1 X2);  tauto.
Defined.

Remark rem_493 : forall X1:term, auto___def_33 X1 -> auto___def_13 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_33_m__def_13 1.
  intro X. case X.
   intro H. elim (rem_247  H).
   intro H. elim (rem_245  H).
  intros X1 X2. intro H. elim (rem_248 X1 X2 H).
  intros X1 X2. intro H. elim (rem_239 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_250 X1 X2 X3 H).
   intro H. elim (rem_242  H).
  intros X1 X2;  exact (rem_492 epsilon_m__def_33_m__def_13 X1 X2).
   intro H. elim (rem_241  H).
  intros X1 X2. intro H. elim (rem_253 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_244 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_243 X1 X2 X3 H).
   intro H. elim (rem_249  H).
   intro H. elim (rem_251  H).
  intros X1. intro H. elim (rem_240 X1 H).
   intro H. elim (rem_252  H).
   intro H. elim (rem_246  H).
Qed.

Remark rem_494 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_33 X2 -> auto___def_42 (s X1). (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_493 X2)). tauto.
Qed.

Remark rem_495 : forall X1 X2:term, auto___def_12 X1 -> auto___def_33 X2 -> auto___def_13 X2 -> auto___def_42 (s X1). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_13 X2 -> auto___def_33 X2 -> auto___def_42 (s X1)). tauto. exact (rem_494 X1 X2).
Qed.

Remark rem_496 : forall X1 X2:term, auto___def_16 X2 -> auto_knows X2 -> auto_knows X1 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows X1 -> auto_knows X1). tauto. exact (rem_466 X1).
Qed.

Remark rem_497 : forall X1 X2:term, auto___def_16 X2 -> auto_knows X2 -> auto_knows X1 -> auto_knows X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto_knows X1). 2:apply (rem_496 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_498 : forall X1 X2:term, auto___def_16 X2 -> auto_knows X2 -> auto_knows X1 -> auto___def_42 (s X1). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_497 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_42_s_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_499 : forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto___def_16 X2 -> auto___def_42 (s X1). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_16 X2 -> auto_knows X2 -> auto_knows X1 -> auto___def_42 (s X1)). tauto. exact (rem_498 X1 X2).
Qed.

Remark rem_500 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1:term, auto___def_42 X1 -> auto___def_42 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_501 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto___def_42 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2.
  cut (auto___def_42 X1 -> auto___def_42 X1). tauto. exact (rem_500 epsilon_m__type_3_pknows X1).
Defined.

Remark rem_502 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X2:term, auto___type_7 X2 -> auto___type_7 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_503 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto___type_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2.
  cut (auto___type_7 X2 -> auto___type_7 X2). tauto. exact (rem_502 epsilon_m__type_3_pknows X2).
Defined.

Remark rem_504 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> (auto___def_42 X1 /\ auto___type_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_42 X1). 2:apply (rem_501 epsilon_m__type_3_pknows X1 X2);  assumption.
  cut (auto___type_7 X2). 2:apply (rem_503 epsilon_m__type_3_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_505 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2. intros A1 A2.
  case (rem_504 epsilon_m__type_3_pknows X1 X2 A1 A2). clear  epsilon_m__type_3_pknows A1 A2. intros. apply trans_knows_crypt_1;  tauto.
 clear  epsilon_m__type_3_pknows A1 A2. tauto.
Defined.

Remark rem_506 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1:term, auto___def_12 X1 -> auto___def_12 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_507 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_12 X1). tauto. exact (rem_506 epsilon_m__type_3_pknows X1).
Defined.

Remark rem_508 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X2:term, auto___def_13 X2 -> auto___def_13 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_509 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_508 epsilon_m__type_3_pknows X2).
Defined.

Remark rem_510 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> (auto___def_12 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_12 X1). 2:apply (rem_507 epsilon_m__type_3_pknows X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_509 epsilon_m__type_3_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_511 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2. intros A1 A2.
  case (rem_510 epsilon_m__type_3_pknows X1 X2 A1 A2). clear  epsilon_m__type_3_pknows A1 A2. intros. apply trans_knows_crypt_2;  tauto.
 clear  epsilon_m__type_3_pknows A1 A2. tauto.
Defined.

Remark rem_512 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1:term, auto___def_22 X1 -> auto___def_22 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_513 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_22 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2.
  cut (auto___def_22 X1 -> auto___def_22 X1). tauto. exact (rem_512 epsilon_m__type_3_pknows X1).
Defined.

Remark rem_514 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X2:term, auto___def_23 X2 -> auto___def_23 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_515 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_514 epsilon_m__type_3_pknows X2).
Defined.

Remark rem_516 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> (auto___def_22 X1 /\ auto___def_23 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_22 X1). 2:apply (rem_513 epsilon_m__type_3_pknows X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_515 epsilon_m__type_3_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_517 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2. intros A1 A2.
  case (rem_516 epsilon_m__type_3_pknows X1 X2 A1 A2). clear  epsilon_m__type_3_pknows A1 A2. intros. apply trans_knows_crypt_3;  tauto.
 clear  epsilon_m__type_3_pknows A1 A2. tauto.
Defined.

Remark rem_518 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1:term, auto___def_37 X1 -> auto___def_37 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_519 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto___def_37 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2.
  cut (auto___def_37 X1 -> auto___def_37 X1). tauto. exact (rem_518 epsilon_m__type_3_pknows X1).
Defined.

Remark rem_520 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_514 epsilon_m__type_3_pknows X2).
Defined.

Remark rem_521 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> (auto___def_37 X1 /\ auto___def_23 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_37 X1). 2:apply (rem_519 epsilon_m__type_3_pknows X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_520 epsilon_m__type_3_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_522 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2. intros A1 A2.
  case (rem_521 epsilon_m__type_3_pknows X1 X2 A1 A2). clear  epsilon_m__type_3_pknows A1 A2. intros. apply trans_knows_crypt_4;  tauto.
 clear  epsilon_m__type_3_pknows A1 A2. tauto.
Defined.

Remark rem_523 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1:term, auto_knows X1 -> auto_knows X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_524 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2.
  cut (auto_knows X1 -> auto_knows X1). tauto. exact (rem_523 epsilon_m__type_3_pknows X1).
Defined.

Remark rem_525 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X2:term, auto_knows X2 -> auto_knows X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_526 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2.
  cut (auto_knows X2 -> auto_knows X2). tauto. exact (rem_525 epsilon_m__type_3_pknows X2).
Defined.

Remark rem_527 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> (auto_knows X1 /\ auto_knows X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2. intros A1 A2.
  cut (auto_knows X1). 2:apply (rem_524 epsilon_m__type_3_pknows X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_526 epsilon_m__type_3_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_528 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2. intros A1 A2.
  case (rem_527 epsilon_m__type_3_pknows X1 X2 A1 A2). clear  epsilon_m__type_3_pknows A1 A2. intros. apply trans_knows_crypt_5;  tauto.
 clear  epsilon_m__type_3_pknows A1 A2. tauto.
Defined.

Remark rem_529 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1:term, auto___def_40 X1 -> auto___def_40 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_530 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> auto___def_40 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2.
  cut (auto___def_40 X1 -> auto___def_40 X1). tauto. exact (rem_529 epsilon_m__type_3_pknows X1).
Defined.

Remark rem_531 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X2:term, auto___type_6 X2 -> auto___type_6 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_532 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> auto___type_6 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2.
  cut (auto___type_6 X2 -> auto___type_6 X2). tauto. exact (rem_531 epsilon_m__type_3_pknows X2).
Defined.

Remark rem_533 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> (auto___def_40 X1 /\ auto___type_6 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_40 X1). 2:apply (rem_530 epsilon_m__type_3_pknows X1 X2);  assumption.
  cut (auto___type_6 X2). 2:apply (rem_532 epsilon_m__type_3_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_534 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2. intros A1 A2.
  case (rem_533 epsilon_m__type_3_pknows X1 X2 A1 A2). clear  epsilon_m__type_3_pknows A1 A2. intros. apply trans_knows_crypt_6;  tauto.
 clear  epsilon_m__type_3_pknows A1 A2. tauto.
Defined.

Remark rem_535 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1:term, auto___def_30 X1 -> auto___def_30 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_536 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> auto___def_30 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2.
  cut (auto___def_30 X1 -> auto___def_30 X1). tauto. exact (rem_535 epsilon_m__type_3_pknows X1).
Defined.

Remark rem_537 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_508 epsilon_m__type_3_pknows X2).
Defined.

Remark rem_538 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> (auto___def_30 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_30 X1). 2:apply (rem_536 epsilon_m__type_3_pknows X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_537 epsilon_m__type_3_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_539 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2. intros A1 A2.
  case (rem_538 epsilon_m__type_3_pknows X1 X2 A1 A2). clear  epsilon_m__type_3_pknows A1 A2. intros. apply trans_knows_crypt_7;  tauto.
 clear  epsilon_m__type_3_pknows A1 A2. tauto.
Defined.

Remark rem_540 : forall X1 X2:term, auto___type_3 (crypt X1 X2) -> or_7
    (auto___def_42 X1 /\ auto___type_7 X2)
    (auto___def_12 X1 /\ auto___def_13 X2)
    (auto___def_22 X1 /\ auto___def_23 X2)
    (auto___def_37 X1 /\ auto___def_23 X2)
    (auto_knows X1 /\ auto_knows X2)
    (auto___def_40 X1 /\ auto___type_6 X2)
    (auto___def_30 X1 /\ auto___def_13 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_7_intro_1; tauto.
  intros. apply or_7_intro_2; tauto.
  intros. apply or_7_intro_3; tauto.
  intros. apply or_7_intro_4; tauto.
  intros. apply or_7_intro_5; tauto.
  intros. apply or_7_intro_6; tauto.
  intros. apply or_7_intro_7; tauto.
Qed.

Remark rem_541 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_3 (crypt X1 X2) -> auto_knows (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2. intro H. intros.
  elim (rem_540 X1 X2 H);  intros.
  apply (rem_505 epsilon_m__type_3_pknows X1 X2);  tauto.
  apply (rem_511 epsilon_m__type_3_pknows X1 X2);  tauto.
  apply (rem_517 epsilon_m__type_3_pknows X1 X2);  tauto.
  apply (rem_522 epsilon_m__type_3_pknows X1 X2);  tauto.
  apply (rem_528 epsilon_m__type_3_pknows X1 X2);  tauto.
  apply (rem_534 epsilon_m__type_3_pknows X1 X2);  tauto.
  apply (rem_539 epsilon_m__type_3_pknows X1 X2);  tauto.
Defined.

Remark rem_542 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1:term, auto_knows X1 -> auto_knows X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1. intros A1.
  cut (auto_knows X1). 2:apply (rem_523 epsilon_m__type_3_pknows X1);  assumption.
  tauto.
Defined.

Remark rem_543 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1:term, auto_knows X1 -> auto_knows (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1. intros A1.
  case (rem_542 epsilon_m__type_3_pknows X1 A1). clear  epsilon_m__type_3_pknows A1. intros. apply trans_knows_s_1;  tauto.
 clear  epsilon_m__type_3_pknows A1. tauto.
Defined.

Remark rem_544 : forall X1:term, auto___type_3 (s X1) -> or_1
    (auto_knows X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_545 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1:term, auto___type_3 (s X1) -> auto_knows (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1. intro H. intros.
  elim (rem_544 X1 H);  intros.
  apply (rem_543 epsilon_m__type_3_pknows X1);  tauto.
Defined.

Remark rem_546 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pknows.  tauto.
Defined.

Remark rem_547 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> auto_knows nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows.  case (rem_546 epsilon_m__type_3_pknows). clear  epsilon_m__type_3_pknows. intros. apply trans_knows_nil_1;  tauto.
 clear  epsilon_m__type_3_pknows. tauto.
Defined.

Remark rem_548 : auto___type_3 nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_549 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> auto___type_3 nil -> auto_knows nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows. intro H. intros.
  elim (rem_548 H);  intros.
  apply (rem_547 epsilon_m__type_3_pknows);  tauto.
Defined.

Remark rem_550 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> auto_knows i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows.  case (rem_546 epsilon_m__type_3_pknows). clear  epsilon_m__type_3_pknows. intros. apply trans_knows_i_1;  tauto.
 clear  epsilon_m__type_3_pknows. tauto.
Defined.

Remark rem_551 : auto___type_3 i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_552 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> auto___type_3 i -> auto_knows i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows. intro H. intros.
  elim (rem_551 H);  intros.
  apply (rem_550 epsilon_m__type_3_pknows);  tauto.
Defined.

Remark rem_553 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1:term, auto___def_33 X1 -> auto___def_33 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_554 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___def_33 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2 X3.
  cut (auto___def_33 X1 -> auto___def_33 X1). tauto. exact (rem_553 epsilon_m__type_3_pknows X1).
Defined.

Remark rem_555 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X2:term, auto___type_5 X2 -> auto___type_5 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_556 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2 X3.
  cut (auto___type_5 X2 -> auto___type_5 X2). tauto. exact (rem_555 epsilon_m__type_3_pknows X2).
Defined.

Remark rem_557 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X3:term, auto___type_4 X3 -> auto___type_4 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_558 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_4 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2 X3.
  cut (auto___type_4 X3 -> auto___type_4 X3). tauto. exact (rem_557 epsilon_m__type_3_pknows X3).
Defined.

Remark rem_559 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> (auto___def_33 X1 /\ auto___type_5 X2 /\ auto___type_4 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_33 X1). 2:apply (rem_554 epsilon_m__type_3_pknows X1 X2 X3);  assumption.
  cut (auto___type_5 X2). 2:apply (rem_556 epsilon_m__type_3_pknows X1 X2 X3);  assumption.
  cut (auto___type_4 X3). 2:apply (rem_558 epsilon_m__type_3_pknows X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_560 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto_knows (nonceb X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_559 epsilon_m__type_3_pknows X1 X2 X3 A1 A2 A3). clear  epsilon_m__type_3_pknows A1 A2 A3. intros. apply trans_knows_nonceb_1;  tauto.
 clear  epsilon_m__type_3_pknows A1 A2 A3. tauto.
Defined.

Remark rem_561 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1:term, auto___def_16 X1 -> auto___def_16 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_562 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___def_16 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2 X3.
  cut (auto___def_16 X1 -> auto___def_16 X1). tauto. exact (rem_561 epsilon_m__type_3_pknows X1).
Defined.

Remark rem_563 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2 X3.
  cut (auto___type_5 X2 -> auto___type_5 X2). tauto. exact (rem_555 epsilon_m__type_3_pknows X2).
Defined.

Remark rem_564 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_4 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2 X3.
  cut (auto___type_4 X3 -> auto___type_4 X3). tauto. exact (rem_557 epsilon_m__type_3_pknows X3).
Defined.

Remark rem_565 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> (auto___def_16 X1 /\ auto___type_5 X2 /\ auto___type_4 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_16 X1). 2:apply (rem_562 epsilon_m__type_3_pknows X1 X2 X3);  assumption.
  cut (auto___type_5 X2). 2:apply (rem_563 epsilon_m__type_3_pknows X1 X2 X3);  assumption.
  cut (auto___type_4 X3). 2:apply (rem_564 epsilon_m__type_3_pknows X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_566 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto_knows (nonceb X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_565 epsilon_m__type_3_pknows X1 X2 X3 A1 A2 A3). clear  epsilon_m__type_3_pknows A1 A2 A3. intros. apply trans_knows_nonceb_2;  tauto.
 clear  epsilon_m__type_3_pknows A1 A2 A3. tauto.
Defined.

Remark rem_567 : forall X1 X2 X3:term, auto___type_3 (nonceb X1 X2 X3) -> or_2
    (auto___def_33 X1 /\ auto___type_5 X2 /\ auto___type_4 X3)
    (auto___def_16 X1 /\ auto___type_5 X2 /\ auto___type_4 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_568 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___type_3 (nonceb X1 X2 X3) -> auto_knows (nonceb X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2 X3. intro H. intros.
  elim (rem_567 X1 X2 X3 H);  intros.
  apply (rem_560 epsilon_m__type_3_pknows X1 X2 X3);  tauto.
  apply (rem_566 epsilon_m__type_3_pknows X1 X2 X3);  tauto.
Defined.

Remark rem_569 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> auto_knows bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows.  case (rem_546 epsilon_m__type_3_pknows). clear  epsilon_m__type_3_pknows. intros. apply trans_knows_bob_1;  tauto.
 clear  epsilon_m__type_3_pknows. tauto.
Defined.

Remark rem_570 : auto___type_3 bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_571 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> auto___type_3 bob -> auto_knows bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows. intro H. intros.
  elim (rem_570 H);  intros.
  apply (rem_569 epsilon_m__type_3_pknows);  tauto.
Defined.

Remark rem_572 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1:term, auto___def_43 X1 -> auto___def_43 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_573 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> auto___def_43 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_43 X1). tauto. exact (rem_572 epsilon_m__type_3_pknows X1).
Defined.

Remark rem_574 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_575 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_574 epsilon_m__type_3_pknows X2).
Defined.

Remark rem_576 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> (auto___def_43 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_43 X1). 2:apply (rem_573 epsilon_m__type_3_pknows X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_575 epsilon_m__type_3_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_577 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> auto_knows (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2. intros A1 A2.
  case (rem_576 epsilon_m__type_3_pknows X1 X2 A1 A2). clear  epsilon_m__type_3_pknows A1 A2. intros. apply trans_knows_key_1;  tauto.
 clear  epsilon_m__type_3_pknows A1 A2. tauto.
Defined.

Remark rem_578 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1:term, auto___def_46 X1 -> auto___def_46 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_579 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_46 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2.
  cut (auto___def_46 X1 -> auto___def_46 X1). tauto. exact (rem_578 epsilon_m__type_3_pknows X1).
Defined.

Remark rem_580 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X2:term, auto___def_47 X2 -> auto___def_47 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_581 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_47 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2.
  cut (auto___def_47 X2 -> auto___def_47 X2). tauto. exact (rem_580 epsilon_m__type_3_pknows X2).
Defined.

Remark rem_582 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> (auto___def_46 X1 /\ auto___def_47 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_46 X1). 2:apply (rem_579 epsilon_m__type_3_pknows X1 X2);  assumption.
  cut (auto___def_47 X2). 2:apply (rem_581 epsilon_m__type_3_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_583 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto_knows (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2. intros A1 A2.
  case (rem_582 epsilon_m__type_3_pknows X1 X2 A1 A2). clear  epsilon_m__type_3_pknows A1 A2. intros. apply trans_knows_key_2;  tauto.
 clear  epsilon_m__type_3_pknows A1 A2. tauto.
Defined.

Remark rem_584 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1:term, auto___def_44 X1 -> auto___def_44 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_585 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> auto___def_44 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2.
  cut (auto___def_44 X1 -> auto___def_44 X1). tauto. exact (rem_584 epsilon_m__type_3_pknows X1).
Defined.

Remark rem_586 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X2:term, auto___def_45 X2 -> auto___def_45 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_587 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> auto___def_45 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2.
  cut (auto___def_45 X2 -> auto___def_45 X2). tauto. exact (rem_586 epsilon_m__type_3_pknows X2).
Defined.

Remark rem_588 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> (auto___def_44 X1 /\ auto___def_45 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_44 X1). 2:apply (rem_585 epsilon_m__type_3_pknows X1 X2);  assumption.
  cut (auto___def_45 X2). 2:apply (rem_587 epsilon_m__type_3_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_589 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> auto_knows (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2. intros A1 A2.
  case (rem_588 epsilon_m__type_3_pknows X1 X2 A1 A2). clear  epsilon_m__type_3_pknows A1 A2. intros. apply trans_knows_key_3;  tauto.
 clear  epsilon_m__type_3_pknows A1 A2. tauto.
Defined.

Remark rem_590 : forall X1 X2:term, auto___type_3 (key X1 X2) -> or_3
    (auto___def_43 X1 /\ auto___type_8 X2)
    (auto___def_46 X1 /\ auto___def_47 X2)
    (auto___def_44 X1 /\ auto___def_45 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_591 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_3 (key X1 X2) -> auto_knows (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2. intro H. intros.
  elim (rem_590 X1 X2 H);  intros.
  apply (rem_577 epsilon_m__type_3_pknows X1 X2);  tauto.
  apply (rem_583 epsilon_m__type_3_pknows X1 X2);  tauto.
  apply (rem_589 epsilon_m__type_3_pknows X1 X2);  tauto.
Defined.

Remark rem_592 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> auto_knows alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows.  case (rem_546 epsilon_m__type_3_pknows). clear  epsilon_m__type_3_pknows. intros. apply trans_knows_alice_1;  tauto.
 clear  epsilon_m__type_3_pknows. tauto.
Defined.

Remark rem_593 : auto___type_3 alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_594 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> auto___type_3 alice -> auto_knows alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows. intro H. intros.
  elim (rem_593 H);  intros.
  apply (rem_592 epsilon_m__type_3_pknows);  tauto.
Defined.

Remark rem_595 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto_knows (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2. intros A1 A2.
  case (rem_527 epsilon_m__type_3_pknows X1 X2 A1 A2). clear  epsilon_m__type_3_pknows A1 A2. intros. apply trans_knows_cons_1;  tauto.
 clear  epsilon_m__type_3_pknows A1 A2. tauto.
Defined.

Remark rem_596 : forall X1 X2:term, auto___type_3 (cons X1 X2) -> or_1
    (auto_knows X1 /\ auto_knows X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_597 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_3 (cons X1 X2) -> auto_knows (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2. intro H. intros.
  elim (rem_596 X1 X2 H);  intros.
  apply (rem_595 epsilon_m__type_3_pknows X1 X2);  tauto.
Defined.

Remark rem_598 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> auto_knows server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows.  case (rem_546 epsilon_m__type_3_pknows). clear  epsilon_m__type_3_pknows. intros. apply trans_knows_server_1;  tauto.
 clear  epsilon_m__type_3_pknows. tauto.
Defined.

Remark rem_599 : auto___type_3 server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_600 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> auto___type_3 server -> auto_knows server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows. intro H. intros.
  elim (rem_599 H);  intros.
  apply (rem_598 epsilon_m__type_3_pknows);  tauto.
Defined.

Remark rem_601 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_602 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_601 epsilon_m__type_3_pknows X1).
Defined.

Remark rem_603 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_604 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_603 epsilon_m__type_3_pknows X2).
Defined.

Remark rem_605 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> (auto_agent X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2. intros A1 A2.
  cut (auto_agent X1). 2:apply (rem_602 epsilon_m__type_3_pknows X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_604 epsilon_m__type_3_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_606 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_knows (noncea X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2. intros A1 A2.
  case (rem_605 epsilon_m__type_3_pknows X1 X2 A1 A2). clear  epsilon_m__type_3_pknows A1 A2. intros. apply trans_knows_noncea_1;  tauto.
 clear  epsilon_m__type_3_pknows A1 A2. tauto.
Defined.

Remark rem_607 : forall X1 X2:term, auto___type_3 (noncea X1 X2) -> or_1
    (auto_agent X1 /\ auto_agent X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_608 : (forall X:term, auto___type_3 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_3 (noncea X1 X2) -> auto_knows (noncea X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows. intros X1 X2. intro H. intros.
  elim (rem_607 X1 X2 H);  intros.
  apply (rem_606 epsilon_m__type_3_pknows X1 X2);  tauto.
Defined.

Remark rem_609 : forall X1 X2 X3:term, auto___type_3 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_610 : auto___type_3 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_611 : auto___type_3 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_612 : forall X1 X2 X3:term, auto___type_3 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_613 : auto___type_3 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_614 : forall X1:term, auto___type_3 X1 -> auto_knows X1. (* Induct. *)
Proof.
  fix epsilon_m__type_3_pknows 1.
  intro X. case X.
  exact (rem_594 epsilon_m__type_3_pknows ).
  exact (rem_571 epsilon_m__type_3_pknows ).
  intros X1 X2;  exact (rem_597 epsilon_m__type_3_pknows X1 X2).
  intros X1 X2;  exact (rem_541 epsilon_m__type_3_pknows X1 X2).
  intros X1 X2 X3. intro H. elim (rem_612 X1 X2 X3 H).
  exact (rem_552 epsilon_m__type_3_pknows ).
  intros X1 X2;  exact (rem_591 epsilon_m__type_3_pknows X1 X2).
  exact (rem_549 epsilon_m__type_3_pknows ).
  intros X1 X2;  exact (rem_608 epsilon_m__type_3_pknows X1 X2).
  intros X1 X2 X3;  exact (rem_568 epsilon_m__type_3_pknows X1 X2 X3).
  intros X1 X2 X3. intro H. elim (rem_609 X1 X2 X3 H).
   intro H. elim (rem_611  H).
   intro H. elim (rem_613  H).
  intros X1;  exact (rem_545 epsilon_m__type_3_pknows X1).
  exact (rem_600 epsilon_m__type_3_pknows ).
   intro H. elim (rem_610  H).
Qed.

Remark rem_615 : (forall X:term, auto___def_30 X -> auto_knows X)
    -> forall X1:term, auto___type_3 X1 -> auto_knows X1. (* Cut history. *)
Proof.  intros epsilon_m__def_30_pknows. exact (rem_614).
Defined.

Remark rem_616 : (forall X:term, auto___def_30 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_3 X1 -> auto___def_31 X2 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_30_pknows. intros X1 X2.
  cut (auto___type_3 X1 -> auto_knows X1). tauto. exact (rem_615 epsilon_m__def_30_pknows X1).
Defined.

Remark rem_617 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1:term, auto___def_42 X1 -> auto___def_42 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_618 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto___def_42 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2.
  cut (auto___def_42 X1 -> auto___def_42 X1). tauto. exact (rem_617 epsilon_m__type_4_pknows X1).
Defined.

Remark rem_619 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X2:term, auto___type_7 X2 -> auto___type_7 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_620 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto___type_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2.
  cut (auto___type_7 X2 -> auto___type_7 X2). tauto. exact (rem_619 epsilon_m__type_4_pknows X2).
Defined.

Remark rem_621 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> (auto___def_42 X1 /\ auto___type_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_42 X1). 2:apply (rem_618 epsilon_m__type_4_pknows X1 X2);  assumption.
  cut (auto___type_7 X2). 2:apply (rem_620 epsilon_m__type_4_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_622 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2. intros A1 A2.
  case (rem_621 epsilon_m__type_4_pknows X1 X2 A1 A2). clear  epsilon_m__type_4_pknows A1 A2. intros. apply trans_knows_crypt_1;  tauto.
 clear  epsilon_m__type_4_pknows A1 A2. tauto.
Defined.

Remark rem_623 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1:term, auto___def_12 X1 -> auto___def_12 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_624 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_12 X1). tauto. exact (rem_623 epsilon_m__type_4_pknows X1).
Defined.

Remark rem_625 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X2:term, auto___def_13 X2 -> auto___def_13 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_626 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_625 epsilon_m__type_4_pknows X2).
Defined.

Remark rem_627 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> (auto___def_12 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_12 X1). 2:apply (rem_624 epsilon_m__type_4_pknows X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_626 epsilon_m__type_4_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_628 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2. intros A1 A2.
  case (rem_627 epsilon_m__type_4_pknows X1 X2 A1 A2). clear  epsilon_m__type_4_pknows A1 A2. intros. apply trans_knows_crypt_2;  tauto.
 clear  epsilon_m__type_4_pknows A1 A2. tauto.
Defined.

Remark rem_629 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1:term, auto___def_22 X1 -> auto___def_22 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_630 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_22 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2.
  cut (auto___def_22 X1 -> auto___def_22 X1). tauto. exact (rem_629 epsilon_m__type_4_pknows X1).
Defined.

Remark rem_631 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X2:term, auto___def_23 X2 -> auto___def_23 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_632 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_631 epsilon_m__type_4_pknows X2).
Defined.

Remark rem_633 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> (auto___def_22 X1 /\ auto___def_23 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_22 X1). 2:apply (rem_630 epsilon_m__type_4_pknows X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_632 epsilon_m__type_4_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_634 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2. intros A1 A2.
  case (rem_633 epsilon_m__type_4_pknows X1 X2 A1 A2). clear  epsilon_m__type_4_pknows A1 A2. intros. apply trans_knows_crypt_3;  tauto.
 clear  epsilon_m__type_4_pknows A1 A2. tauto.
Defined.

Remark rem_635 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1:term, auto___def_37 X1 -> auto___def_37 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_636 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto___def_37 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2.
  cut (auto___def_37 X1 -> auto___def_37 X1). tauto. exact (rem_635 epsilon_m__type_4_pknows X1).
Defined.

Remark rem_637 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_631 epsilon_m__type_4_pknows X2).
Defined.

Remark rem_638 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> (auto___def_37 X1 /\ auto___def_23 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_37 X1). 2:apply (rem_636 epsilon_m__type_4_pknows X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_637 epsilon_m__type_4_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_639 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2. intros A1 A2.
  case (rem_638 epsilon_m__type_4_pknows X1 X2 A1 A2). clear  epsilon_m__type_4_pknows A1 A2. intros. apply trans_knows_crypt_4;  tauto.
 clear  epsilon_m__type_4_pknows A1 A2. tauto.
Defined.

Remark rem_640 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1:term, auto_knows X1 -> auto_knows X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_641 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2.
  cut (auto_knows X1 -> auto_knows X1). tauto. exact (rem_640 epsilon_m__type_4_pknows X1).
Defined.

Remark rem_642 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X2:term, auto_knows X2 -> auto_knows X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_643 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2.
  cut (auto_knows X2 -> auto_knows X2). tauto. exact (rem_642 epsilon_m__type_4_pknows X2).
Defined.

Remark rem_644 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> (auto_knows X1 /\ auto_knows X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2. intros A1 A2.
  cut (auto_knows X1). 2:apply (rem_641 epsilon_m__type_4_pknows X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_643 epsilon_m__type_4_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_645 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2. intros A1 A2.
  case (rem_644 epsilon_m__type_4_pknows X1 X2 A1 A2). clear  epsilon_m__type_4_pknows A1 A2. intros. apply trans_knows_crypt_5;  tauto.
 clear  epsilon_m__type_4_pknows A1 A2. tauto.
Defined.

Remark rem_646 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1:term, auto___def_40 X1 -> auto___def_40 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_647 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> auto___def_40 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2.
  cut (auto___def_40 X1 -> auto___def_40 X1). tauto. exact (rem_646 epsilon_m__type_4_pknows X1).
Defined.

Remark rem_648 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X2:term, auto___type_6 X2 -> auto___type_6 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_649 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> auto___type_6 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2.
  cut (auto___type_6 X2 -> auto___type_6 X2). tauto. exact (rem_648 epsilon_m__type_4_pknows X2).
Defined.

Remark rem_650 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> (auto___def_40 X1 /\ auto___type_6 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_40 X1). 2:apply (rem_647 epsilon_m__type_4_pknows X1 X2);  assumption.
  cut (auto___type_6 X2). 2:apply (rem_649 epsilon_m__type_4_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_651 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2. intros A1 A2.
  case (rem_650 epsilon_m__type_4_pknows X1 X2 A1 A2). clear  epsilon_m__type_4_pknows A1 A2. intros. apply trans_knows_crypt_6;  tauto.
 clear  epsilon_m__type_4_pknows A1 A2. tauto.
Defined.

Remark rem_652 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1:term, auto___def_30 X1 -> auto___def_30 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_653 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> auto___def_30 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2.
  cut (auto___def_30 X1 -> auto___def_30 X1). tauto. exact (rem_652 epsilon_m__type_4_pknows X1).
Defined.

Remark rem_654 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_625 epsilon_m__type_4_pknows X2).
Defined.

Remark rem_655 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> (auto___def_30 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_30 X1). 2:apply (rem_653 epsilon_m__type_4_pknows X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_654 epsilon_m__type_4_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_656 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2. intros A1 A2.
  case (rem_655 epsilon_m__type_4_pknows X1 X2 A1 A2). clear  epsilon_m__type_4_pknows A1 A2. intros. apply trans_knows_crypt_7;  tauto.
 clear  epsilon_m__type_4_pknows A1 A2. tauto.
Defined.

Remark rem_657 : forall X1 X2:term, auto___type_4 (crypt X1 X2) -> or_7
    (auto___def_42 X1 /\ auto___type_7 X2)
    (auto___def_12 X1 /\ auto___def_13 X2)
    (auto___def_22 X1 /\ auto___def_23 X2)
    (auto___def_37 X1 /\ auto___def_23 X2)
    (auto_knows X1 /\ auto_knows X2)
    (auto___def_40 X1 /\ auto___type_6 X2)
    (auto___def_30 X1 /\ auto___def_13 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_7_intro_1; tauto.
  intros. apply or_7_intro_2; tauto.
  intros. apply or_7_intro_3; tauto.
  intros. apply or_7_intro_4; tauto.
  intros. apply or_7_intro_5; tauto.
  intros. apply or_7_intro_6; tauto.
  intros. apply or_7_intro_7; tauto.
Qed.

Remark rem_658 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_4 (crypt X1 X2) -> auto_knows (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2. intro H. intros.
  elim (rem_657 X1 X2 H);  intros.
  apply (rem_622 epsilon_m__type_4_pknows X1 X2);  tauto.
  apply (rem_628 epsilon_m__type_4_pknows X1 X2);  tauto.
  apply (rem_634 epsilon_m__type_4_pknows X1 X2);  tauto.
  apply (rem_639 epsilon_m__type_4_pknows X1 X2);  tauto.
  apply (rem_645 epsilon_m__type_4_pknows X1 X2);  tauto.
  apply (rem_651 epsilon_m__type_4_pknows X1 X2);  tauto.
  apply (rem_656 epsilon_m__type_4_pknows X1 X2);  tauto.
Defined.

Remark rem_659 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1:term, auto_knows X1 -> auto_knows X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1. intros A1.
  cut (auto_knows X1). 2:apply (rem_640 epsilon_m__type_4_pknows X1);  assumption.
  tauto.
Defined.

Remark rem_660 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1:term, auto_knows X1 -> auto_knows (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1. intros A1.
  case (rem_659 epsilon_m__type_4_pknows X1 A1). clear  epsilon_m__type_4_pknows A1. intros. apply trans_knows_s_1;  tauto.
 clear  epsilon_m__type_4_pknows A1. tauto.
Defined.

Remark rem_661 : forall X1:term, auto___type_4 (s X1) -> or_1
    (auto_knows X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_662 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1:term, auto___type_4 (s X1) -> auto_knows (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1. intro H. intros.
  elim (rem_661 X1 H);  intros.
  apply (rem_660 epsilon_m__type_4_pknows X1);  tauto.
Defined.

Remark rem_663 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows.  tauto.
Defined.

Remark rem_664 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> auto_knows nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows.  case (rem_663 epsilon_m__type_4_pknows). clear  epsilon_m__type_4_pknows. intros. apply trans_knows_nil_1;  tauto.
 clear  epsilon_m__type_4_pknows. tauto.
Defined.

Remark rem_665 : auto___type_4 nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_666 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> auto___type_4 nil -> auto_knows nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_pknows. intro H. intros.
  elim (rem_665 H);  intros.
  apply (rem_664 epsilon_m__type_4_pknows);  tauto.
Defined.

Remark rem_667 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> auto_knows i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows.  case (rem_663 epsilon_m__type_4_pknows). clear  epsilon_m__type_4_pknows. intros. apply trans_knows_i_1;  tauto.
 clear  epsilon_m__type_4_pknows. tauto.
Defined.

Remark rem_668 : auto___type_4 i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_669 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> auto___type_4 i -> auto_knows i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_pknows. intro H. intros.
  elim (rem_668 H);  intros.
  apply (rem_667 epsilon_m__type_4_pknows);  tauto.
Defined.

Remark rem_670 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1:term, auto___def_33 X1 -> auto___def_33 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_671 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___def_33 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2 X3.
  cut (auto___def_33 X1 -> auto___def_33 X1). tauto. exact (rem_670 epsilon_m__type_4_pknows X1).
Defined.

Remark rem_672 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X2:term, auto___type_5 X2 -> auto___type_5 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_673 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2 X3.
  cut (auto___type_5 X2 -> auto___type_5 X2). tauto. exact (rem_672 epsilon_m__type_4_pknows X2).
Defined.

Remark rem_674 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X3:term, auto___type_4 X3 -> auto___type_4 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_675 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_4 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2 X3.
  cut (auto___type_4 X3 -> auto___type_4 X3). tauto. exact (rem_674 epsilon_m__type_4_pknows X3).
Defined.

Remark rem_676 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> (auto___def_33 X1 /\ auto___type_5 X2 /\ auto___type_4 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_33 X1). 2:apply (rem_671 epsilon_m__type_4_pknows X1 X2 X3);  assumption.
  cut (auto___type_5 X2). 2:apply (rem_673 epsilon_m__type_4_pknows X1 X2 X3);  assumption.
  cut (auto___type_4 X3). 2:apply (rem_675 epsilon_m__type_4_pknows X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_677 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto_knows (nonceb X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_676 epsilon_m__type_4_pknows X1 X2 X3 A1 A2 A3). clear  epsilon_m__type_4_pknows A1 A2 A3. intros. apply trans_knows_nonceb_1;  tauto.
 clear  epsilon_m__type_4_pknows A1 A2 A3. tauto.
Defined.

Remark rem_678 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1:term, auto___def_16 X1 -> auto___def_16 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_679 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___def_16 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2 X3.
  cut (auto___def_16 X1 -> auto___def_16 X1). tauto. exact (rem_678 epsilon_m__type_4_pknows X1).
Defined.

Remark rem_680 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2 X3.
  cut (auto___type_5 X2 -> auto___type_5 X2). tauto. exact (rem_672 epsilon_m__type_4_pknows X2).
Defined.

Remark rem_681 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_4 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2 X3.
  cut (auto___type_4 X3 -> auto___type_4 X3). tauto. exact (rem_674 epsilon_m__type_4_pknows X3).
Defined.

Remark rem_682 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> (auto___def_16 X1 /\ auto___type_5 X2 /\ auto___type_4 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_16 X1). 2:apply (rem_679 epsilon_m__type_4_pknows X1 X2 X3);  assumption.
  cut (auto___type_5 X2). 2:apply (rem_680 epsilon_m__type_4_pknows X1 X2 X3);  assumption.
  cut (auto___type_4 X3). 2:apply (rem_681 epsilon_m__type_4_pknows X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_683 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto_knows (nonceb X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_682 epsilon_m__type_4_pknows X1 X2 X3 A1 A2 A3). clear  epsilon_m__type_4_pknows A1 A2 A3. intros. apply trans_knows_nonceb_2;  tauto.
 clear  epsilon_m__type_4_pknows A1 A2 A3. tauto.
Defined.

Remark rem_684 : forall X1 X2 X3:term, auto___type_4 (nonceb X1 X2 X3) -> or_2
    (auto___def_33 X1 /\ auto___type_5 X2 /\ auto___type_4 X3)
    (auto___def_16 X1 /\ auto___type_5 X2 /\ auto___type_4 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_685 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___type_4 (nonceb X1 X2 X3) -> auto_knows (nonceb X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2 X3. intro H. intros.
  elim (rem_684 X1 X2 X3 H);  intros.
  apply (rem_677 epsilon_m__type_4_pknows X1 X2 X3);  tauto.
  apply (rem_683 epsilon_m__type_4_pknows X1 X2 X3);  tauto.
Defined.

Remark rem_686 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> auto_knows bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows.  case (rem_663 epsilon_m__type_4_pknows). clear  epsilon_m__type_4_pknows. intros. apply trans_knows_bob_1;  tauto.
 clear  epsilon_m__type_4_pknows. tauto.
Defined.

Remark rem_687 : auto___type_4 bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_688 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> auto___type_4 bob -> auto_knows bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_pknows. intro H. intros.
  elim (rem_687 H);  intros.
  apply (rem_686 epsilon_m__type_4_pknows);  tauto.
Defined.

Remark rem_689 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1:term, auto___def_43 X1 -> auto___def_43 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_690 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> auto___def_43 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_43 X1). tauto. exact (rem_689 epsilon_m__type_4_pknows X1).
Defined.

Remark rem_691 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_692 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_691 epsilon_m__type_4_pknows X2).
Defined.

Remark rem_693 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> (auto___def_43 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_43 X1). 2:apply (rem_690 epsilon_m__type_4_pknows X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_692 epsilon_m__type_4_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_694 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> auto_knows (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2. intros A1 A2.
  case (rem_693 epsilon_m__type_4_pknows X1 X2 A1 A2). clear  epsilon_m__type_4_pknows A1 A2. intros. apply trans_knows_key_1;  tauto.
 clear  epsilon_m__type_4_pknows A1 A2. tauto.
Defined.

Remark rem_695 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1:term, auto___def_46 X1 -> auto___def_46 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_696 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_46 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2.
  cut (auto___def_46 X1 -> auto___def_46 X1). tauto. exact (rem_695 epsilon_m__type_4_pknows X1).
Defined.

Remark rem_697 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X2:term, auto___def_47 X2 -> auto___def_47 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_698 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_47 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2.
  cut (auto___def_47 X2 -> auto___def_47 X2). tauto. exact (rem_697 epsilon_m__type_4_pknows X2).
Defined.

Remark rem_699 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> (auto___def_46 X1 /\ auto___def_47 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_46 X1). 2:apply (rem_696 epsilon_m__type_4_pknows X1 X2);  assumption.
  cut (auto___def_47 X2). 2:apply (rem_698 epsilon_m__type_4_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_700 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto_knows (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2. intros A1 A2.
  case (rem_699 epsilon_m__type_4_pknows X1 X2 A1 A2). clear  epsilon_m__type_4_pknows A1 A2. intros. apply trans_knows_key_2;  tauto.
 clear  epsilon_m__type_4_pknows A1 A2. tauto.
Defined.

Remark rem_701 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1:term, auto___def_44 X1 -> auto___def_44 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_702 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> auto___def_44 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2.
  cut (auto___def_44 X1 -> auto___def_44 X1). tauto. exact (rem_701 epsilon_m__type_4_pknows X1).
Defined.

Remark rem_703 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X2:term, auto___def_45 X2 -> auto___def_45 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_704 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> auto___def_45 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2.
  cut (auto___def_45 X2 -> auto___def_45 X2). tauto. exact (rem_703 epsilon_m__type_4_pknows X2).
Defined.

Remark rem_705 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> (auto___def_44 X1 /\ auto___def_45 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_44 X1). 2:apply (rem_702 epsilon_m__type_4_pknows X1 X2);  assumption.
  cut (auto___def_45 X2). 2:apply (rem_704 epsilon_m__type_4_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_706 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> auto_knows (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2. intros A1 A2.
  case (rem_705 epsilon_m__type_4_pknows X1 X2 A1 A2). clear  epsilon_m__type_4_pknows A1 A2. intros. apply trans_knows_key_3;  tauto.
 clear  epsilon_m__type_4_pknows A1 A2. tauto.
Defined.

Remark rem_707 : forall X1 X2:term, auto___type_4 (key X1 X2) -> or_3
    (auto___def_43 X1 /\ auto___type_8 X2)
    (auto___def_46 X1 /\ auto___def_47 X2)
    (auto___def_44 X1 /\ auto___def_45 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_708 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_4 (key X1 X2) -> auto_knows (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2. intro H. intros.
  elim (rem_707 X1 X2 H);  intros.
  apply (rem_694 epsilon_m__type_4_pknows X1 X2);  tauto.
  apply (rem_700 epsilon_m__type_4_pknows X1 X2);  tauto.
  apply (rem_706 epsilon_m__type_4_pknows X1 X2);  tauto.
Defined.

Remark rem_709 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> auto_knows alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows.  case (rem_663 epsilon_m__type_4_pknows). clear  epsilon_m__type_4_pknows. intros. apply trans_knows_alice_1;  tauto.
 clear  epsilon_m__type_4_pknows. tauto.
Defined.

Remark rem_710 : auto___type_4 alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_711 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> auto___type_4 alice -> auto_knows alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_pknows. intro H. intros.
  elim (rem_710 H);  intros.
  apply (rem_709 epsilon_m__type_4_pknows);  tauto.
Defined.

Remark rem_712 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto_knows (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2. intros A1 A2.
  case (rem_644 epsilon_m__type_4_pknows X1 X2 A1 A2). clear  epsilon_m__type_4_pknows A1 A2. intros. apply trans_knows_cons_1;  tauto.
 clear  epsilon_m__type_4_pknows A1 A2. tauto.
Defined.

Remark rem_713 : forall X1 X2:term, auto___type_4 (cons X1 X2) -> or_1
    (auto_knows X1 /\ auto_knows X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_714 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_4 (cons X1 X2) -> auto_knows (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2. intro H. intros.
  elim (rem_713 X1 X2 H);  intros.
  apply (rem_712 epsilon_m__type_4_pknows X1 X2);  tauto.
Defined.

Remark rem_715 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> auto_knows server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows.  case (rem_663 epsilon_m__type_4_pknows). clear  epsilon_m__type_4_pknows. intros. apply trans_knows_server_1;  tauto.
 clear  epsilon_m__type_4_pknows. tauto.
Defined.

Remark rem_716 : auto___type_4 server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_717 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> auto___type_4 server -> auto_knows server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_pknows. intro H. intros.
  elim (rem_716 H);  intros.
  apply (rem_715 epsilon_m__type_4_pknows);  tauto.
Defined.

Remark rem_718 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_719 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_718 epsilon_m__type_4_pknows X1).
Defined.

Remark rem_720 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_721 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_720 epsilon_m__type_4_pknows X2).
Defined.

Remark rem_722 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> (auto_agent X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2. intros A1 A2.
  cut (auto_agent X1). 2:apply (rem_719 epsilon_m__type_4_pknows X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_721 epsilon_m__type_4_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_723 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_knows (noncea X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2. intros A1 A2.
  case (rem_722 epsilon_m__type_4_pknows X1 X2 A1 A2). clear  epsilon_m__type_4_pknows A1 A2. intros. apply trans_knows_noncea_1;  tauto.
 clear  epsilon_m__type_4_pknows A1 A2. tauto.
Defined.

Remark rem_724 : forall X1 X2:term, auto___type_4 (noncea X1 X2) -> or_1
    (auto_agent X1 /\ auto_agent X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_725 : (forall X:term, auto___type_4 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_4 (noncea X1 X2) -> auto_knows (noncea X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_pknows. intros X1 X2. intro H. intros.
  elim (rem_724 X1 X2 H);  intros.
  apply (rem_723 epsilon_m__type_4_pknows X1 X2);  tauto.
Defined.

Remark rem_726 : forall X1 X2 X3:term, auto___type_4 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_727 : auto___type_4 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_728 : auto___type_4 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_729 : forall X1 X2 X3:term, auto___type_4 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_730 : auto___type_4 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_731 : forall X1:term, auto___type_4 X1 -> auto_knows X1. (* Induct. *)
Proof.
  fix epsilon_m__type_4_pknows 1.
  intro X. case X.
  exact (rem_711 epsilon_m__type_4_pknows ).
  exact (rem_688 epsilon_m__type_4_pknows ).
  intros X1 X2;  exact (rem_714 epsilon_m__type_4_pknows X1 X2).
  intros X1 X2;  exact (rem_658 epsilon_m__type_4_pknows X1 X2).
  intros X1 X2 X3. intro H. elim (rem_729 X1 X2 X3 H).
  exact (rem_669 epsilon_m__type_4_pknows ).
  intros X1 X2;  exact (rem_708 epsilon_m__type_4_pknows X1 X2).
  exact (rem_666 epsilon_m__type_4_pknows ).
  intros X1 X2;  exact (rem_725 epsilon_m__type_4_pknows X1 X2).
  intros X1 X2 X3;  exact (rem_685 epsilon_m__type_4_pknows X1 X2 X3).
  intros X1 X2 X3. intro H. elim (rem_726 X1 X2 X3 H).
   intro H. elim (rem_728  H).
   intro H. elim (rem_730  H).
  intros X1;  exact (rem_662 epsilon_m__type_4_pknows X1).
  exact (rem_717 epsilon_m__type_4_pknows ).
   intro H. elim (rem_727  H).
Qed.

Remark rem_732 : (forall X:term, auto___def_31 X -> auto_knows X)
    -> forall X1:term, auto___type_4 X1 -> auto_knows X1. (* Cut history. *)
Proof.  intros epsilon_m__def_31_pknows. exact (rem_731).
Defined.

Remark rem_733 : (forall X:term, auto___def_31 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_4 X1 -> auto___def_32 X2 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_31_pknows. intros X1 X2.
  cut (auto___type_4 X1 -> auto_knows X1). tauto. exact (rem_732 epsilon_m__def_31_pknows X1).
Defined.

Remark rem_734 : (forall X:term, auto___def_32 X -> auto_knows X)
    -> forall X1:term, auto___def_33 X1 -> auto_knows X1. (* Cut history. *)
Proof.  intros epsilon_m__def_32_pknows. exact (rem_254).
Defined.

Remark rem_735 : (forall X:term, auto___def_32 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_33 X1 -> auto___def_34 X2 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_32_pknows. intros X1 X2.
  cut (auto___def_33 X1 -> auto_knows X1). tauto. exact (rem_734 epsilon_m__def_32_pknows X1).
Defined.

Remark rem_736 : (forall X:term, auto___def_36 X -> auto_knows X)
    -> forall X1:term, auto___def_37 X1 -> auto___def_37 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_737 : (forall X:term, auto___def_36 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto___def_37 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_36_pknows. intros X1 X2.
  cut (auto___def_37 X1 -> auto___def_37 X1). tauto. exact (rem_736 epsilon_m__def_36_pknows X1).
Defined.

Remark rem_738 : (forall X:term, auto___def_36 X -> auto_knows X)
    -> forall X2:term, auto___def_23 X2 -> auto___def_23 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_739 : (forall X:term, auto___def_36 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_36_pknows. intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_738 epsilon_m__def_36_pknows X2).
Defined.

Remark rem_740 : (forall X:term, auto___def_36 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> (auto___def_37 X1 /\ auto___def_23 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_36_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_37 X1). 2:apply (rem_737 epsilon_m__def_36_pknows X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_739 epsilon_m__def_36_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_741 : (forall X:term, auto___def_36 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_36_pknows. intros X1 X2. intros A1 A2.
  case (rem_740 epsilon_m__def_36_pknows X1 X2 A1 A2). clear  epsilon_m__def_36_pknows A1 A2. intros. apply trans_knows_crypt_4;  tauto.
 clear  epsilon_m__def_36_pknows A1 A2. tauto.
Defined.

Remark rem_742 : forall X1 X2:term, auto___def_36 (crypt X1 X2) -> or_1
    (auto___def_37 X1 /\ auto___def_23 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_743 : (forall X:term, auto___def_36 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_36 (crypt X1 X2) -> auto_knows (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_36_pknows. intros X1 X2. intro H. intros.
  elim (rem_742 X1 X2 H);  intros.
  apply (rem_741 epsilon_m__def_36_pknows X1 X2);  tauto.
Defined.

Remark rem_744 : forall X1:term, auto___def_36 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_745 : auto___def_36 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_746 : auto___def_36 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_747 : forall X1 X2 X3:term, auto___def_36 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_748 : forall X1 X2 X3:term, auto___def_36 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_749 : auto___def_36 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_750 : forall X1 X2:term, auto___def_36 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_751 : auto___def_36 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_752 : auto___def_36 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_753 : forall X1 X2:term, auto___def_36 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_754 : auto___def_36 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_755 : forall X1 X2 X3:term, auto___def_36 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_756 : auto___def_36 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_757 : auto___def_36 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_758 : forall X1 X2:term, auto___def_36 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_759 : forall X1:term, auto___def_36 X1 -> auto_knows X1. (* Induct. *)
Proof.
  fix epsilon_m__def_36_pknows 1.
  intro X. case X.
   intro H. elim (rem_752  H).
   intro H. elim (rem_749  H).
  intros X1 X2. intro H. elim (rem_753 X1 X2 H).
  intros X1 X2;  exact (rem_743 epsilon_m__def_36_pknows X1 X2).
  intros X1 X2 X3. intro H. elim (rem_755 X1 X2 X3 H).
   intro H. elim (rem_746  H).
  intros X1 X2. intro H. elim (rem_750 X1 X2 H).
   intro H. elim (rem_745  H).
  intros X1 X2. intro H. elim (rem_758 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_748 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_747 X1 X2 X3 H).
   intro H. elim (rem_754  H).
   intro H. elim (rem_756  H).
  intros X1. intro H. elim (rem_744 X1 H).
   intro H. elim (rem_757  H).
   intro H. elim (rem_751  H).
Qed.

Remark rem_760 : (forall X:term, auto___def_34 X -> auto_knows X)
    -> forall X1:term, auto___def_36 X1 -> auto_knows X1. (* Cut history. *)
Proof.  intros epsilon_m__def_34_pknows. exact (rem_759).
Defined.

Remark rem_761 : (forall X:term, auto___def_34 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_21 X2 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_34_pknows. intros X1 X2.
  cut (auto___def_36 X1 -> auto_knows X1). tauto. exact (rem_760 epsilon_m__def_34_pknows X1).
Defined.

Remark rem_762 : (forall X:term, auto___def_34 X -> auto_knows X)
    -> forall X2:term, auto___def_21 X2 -> auto_knows X2. (* Cut history. *)
Proof.  intros epsilon_m__def_34_pknows. exact (rem_393).
Defined.

Remark rem_763 : (forall X:term, auto___def_34 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_21 X2 -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_34_pknows. intros X1 X2.
  cut (auto___def_21 X2 -> auto_knows X2). tauto. exact (rem_762 epsilon_m__def_34_pknows X2).
Defined.

Remark rem_764 : (forall X:term, auto___def_34 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_21 X2 -> (auto_knows X1 /\ auto_knows X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_34_pknows. intros X1 X2. intros A1 A2.
  cut (auto_knows X1). 2:apply (rem_761 epsilon_m__def_34_pknows X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_763 epsilon_m__def_34_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_765 : (forall X:term, auto___def_34 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_36 X1 -> auto___def_21 X2 -> auto_knows (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_34_pknows. intros X1 X2. intros A1 A2.
  case (rem_764 epsilon_m__def_34_pknows X1 X2 A1 A2). clear  epsilon_m__def_34_pknows A1 A2. intros. apply trans_knows_cons_1;  tauto.
 clear  epsilon_m__def_34_pknows A1 A2. tauto.
Defined.

Remark rem_766 : forall X1 X2:term, auto___def_34 (cons X1 X2) -> or_1
    (auto___def_36 X1 /\ auto___def_21 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_767 : (forall X:term, auto___def_34 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_34 (cons X1 X2) -> auto_knows (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_34_pknows. intros X1 X2. intro H. intros.
  elim (rem_766 X1 X2 H);  intros.
  apply (rem_765 epsilon_m__def_34_pknows X1 X2);  tauto.
Defined.

Remark rem_768 : forall X1 X2:term, auto___def_34 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_769 : forall X1:term, auto___def_34 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_770 : auto___def_34 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_771 : auto___def_34 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_772 : forall X1 X2 X3:term, auto___def_34 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_773 : forall X1 X2 X3:term, auto___def_34 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_774 : auto___def_34 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_775 : forall X1 X2:term, auto___def_34 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_776 : auto___def_34 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_777 : auto___def_34 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_778 : auto___def_34 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_779 : forall X1 X2 X3:term, auto___def_34 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_780 : auto___def_34 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_781 : auto___def_34 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_782 : forall X1 X2:term, auto___def_34 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_783 : forall X2:term, auto___def_34 X2 -> auto_knows X2. (* Induct. *)
Proof.
  fix epsilon_m__def_34_pknows 1.
  intro X. case X.
   intro H. elim (rem_777  H).
   intro H. elim (rem_774  H).
  intros X1 X2;  exact (rem_767 epsilon_m__def_34_pknows X1 X2).
  intros X1 X2. intro H. elim (rem_768 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_779 X1 X2 X3 H).
   intro H. elim (rem_771  H).
  intros X1 X2. intro H. elim (rem_775 X1 X2 H).
   intro H. elim (rem_770  H).
  intros X1 X2. intro H. elim (rem_782 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_773 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_772 X1 X2 X3 H).
   intro H. elim (rem_778  H).
   intro H. elim (rem_780  H).
  intros X1. intro H. elim (rem_769 X1 H).
   intro H. elim (rem_781  H).
   intro H. elim (rem_776  H).
Qed.

Remark rem_784 : (forall X:term, auto___def_32 X -> auto_knows X)
    -> forall X2:term, auto___def_34 X2 -> auto_knows X2. (* Cut history. *)
Proof.  intros epsilon_m__def_32_pknows. exact (rem_783).
Defined.

Remark rem_785 : (forall X:term, auto___def_32 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_33 X1 -> auto___def_34 X2 -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_32_pknows. intros X1 X2.
  cut (auto___def_34 X2 -> auto_knows X2). tauto. exact (rem_784 epsilon_m__def_32_pknows X2).
Defined.

Remark rem_786 : (forall X:term, auto___def_32 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_33 X1 -> auto___def_34 X2 -> (auto_knows X1 /\ auto_knows X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_32_pknows. intros X1 X2. intros A1 A2.
  cut (auto_knows X1). 2:apply (rem_735 epsilon_m__def_32_pknows X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_785 epsilon_m__def_32_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_787 : (forall X:term, auto___def_32 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_33 X1 -> auto___def_34 X2 -> auto_knows (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_32_pknows. intros X1 X2. intros A1 A2.
  case (rem_786 epsilon_m__def_32_pknows X1 X2 A1 A2). clear  epsilon_m__def_32_pknows A1 A2. intros. apply trans_knows_cons_1;  tauto.
 clear  epsilon_m__def_32_pknows A1 A2. tauto.
Defined.

Remark rem_788 : forall X1 X2:term, auto___def_32 (cons X1 X2) -> or_1
    (auto___def_33 X1 /\ auto___def_34 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_789 : (forall X:term, auto___def_32 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_32 (cons X1 X2) -> auto_knows (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_32_pknows. intros X1 X2. intro H. intros.
  elim (rem_788 X1 X2 H);  intros.
  apply (rem_787 epsilon_m__def_32_pknows X1 X2);  tauto.
Defined.

Remark rem_790 : forall X1 X2:term, auto___def_32 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_791 : forall X1:term, auto___def_32 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_792 : auto___def_32 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_793 : auto___def_32 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_794 : forall X1 X2 X3:term, auto___def_32 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_795 : forall X1 X2 X3:term, auto___def_32 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_796 : auto___def_32 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_797 : forall X1 X2:term, auto___def_32 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_798 : auto___def_32 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_799 : auto___def_32 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_800 : auto___def_32 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_801 : forall X1 X2 X3:term, auto___def_32 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_802 : auto___def_32 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_803 : auto___def_32 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_804 : forall X1 X2:term, auto___def_32 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_805 : forall X2:term, auto___def_32 X2 -> auto_knows X2. (* Induct. *)
Proof.
  fix epsilon_m__def_32_pknows 1.
  intro X. case X.
   intro H. elim (rem_799  H).
   intro H. elim (rem_796  H).
  intros X1 X2;  exact (rem_789 epsilon_m__def_32_pknows X1 X2).
  intros X1 X2. intro H. elim (rem_790 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_801 X1 X2 X3 H).
   intro H. elim (rem_793  H).
  intros X1 X2. intro H. elim (rem_797 X1 X2 H).
   intro H. elim (rem_792  H).
  intros X1 X2. intro H. elim (rem_804 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_795 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_794 X1 X2 X3 H).
   intro H. elim (rem_800  H).
   intro H. elim (rem_802  H).
  intros X1. intro H. elim (rem_791 X1 H).
   intro H. elim (rem_803  H).
   intro H. elim (rem_798  H).
Qed.

Remark rem_806 : (forall X:term, auto___def_31 X -> auto_knows X)
    -> forall X2:term, auto___def_32 X2 -> auto_knows X2. (* Cut history. *)
Proof.  intros epsilon_m__def_31_pknows. exact (rem_805).
Defined.

Remark rem_807 : (forall X:term, auto___def_31 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_4 X1 -> auto___def_32 X2 -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_31_pknows. intros X1 X2.
  cut (auto___def_32 X2 -> auto_knows X2). tauto. exact (rem_806 epsilon_m__def_31_pknows X2).
Defined.

Remark rem_808 : (forall X:term, auto___def_31 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_4 X1 -> auto___def_32 X2 -> (auto_knows X1 /\ auto_knows X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_31_pknows. intros X1 X2. intros A1 A2.
  cut (auto_knows X1). 2:apply (rem_733 epsilon_m__def_31_pknows X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_807 epsilon_m__def_31_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_809 : (forall X:term, auto___def_31 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_4 X1 -> auto___def_32 X2 -> auto_knows (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_31_pknows. intros X1 X2. intros A1 A2.
  case (rem_808 epsilon_m__def_31_pknows X1 X2 A1 A2). clear  epsilon_m__def_31_pknows A1 A2. intros. apply trans_knows_cons_1;  tauto.
 clear  epsilon_m__def_31_pknows A1 A2. tauto.
Defined.

Remark rem_810 : forall X1 X2:term, auto___def_31 (cons X1 X2) -> or_1
    (auto___type_4 X1 /\ auto___def_32 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_811 : (forall X:term, auto___def_31 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_31 (cons X1 X2) -> auto_knows (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_31_pknows. intros X1 X2. intro H. intros.
  elim (rem_810 X1 X2 H);  intros.
  apply (rem_809 epsilon_m__def_31_pknows X1 X2);  tauto.
Defined.

Remark rem_812 : forall X1 X2:term, auto___def_31 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_813 : forall X1:term, auto___def_31 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_814 : auto___def_31 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_815 : auto___def_31 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_816 : forall X1 X2 X3:term, auto___def_31 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_817 : forall X1 X2 X3:term, auto___def_31 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_818 : auto___def_31 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_819 : forall X1 X2:term, auto___def_31 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_820 : auto___def_31 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_821 : auto___def_31 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_822 : auto___def_31 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_823 : forall X1 X2 X3:term, auto___def_31 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_824 : auto___def_31 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_825 : auto___def_31 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_826 : forall X1 X2:term, auto___def_31 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_827 : forall X2:term, auto___def_31 X2 -> auto_knows X2. (* Induct. *)
Proof.
  fix epsilon_m__def_31_pknows 1.
  intro X. case X.
   intro H. elim (rem_821  H).
   intro H. elim (rem_818  H).
  intros X1 X2;  exact (rem_811 epsilon_m__def_31_pknows X1 X2).
  intros X1 X2. intro H. elim (rem_812 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_823 X1 X2 X3 H).
   intro H. elim (rem_815  H).
  intros X1 X2. intro H. elim (rem_819 X1 X2 H).
   intro H. elim (rem_814  H).
  intros X1 X2. intro H. elim (rem_826 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_817 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_816 X1 X2 X3 H).
   intro H. elim (rem_822  H).
   intro H. elim (rem_824  H).
  intros X1. intro H. elim (rem_813 X1 H).
   intro H. elim (rem_825  H).
   intro H. elim (rem_820  H).
Qed.

Remark rem_828 : (forall X:term, auto___def_30 X -> auto_knows X)
    -> forall X2:term, auto___def_31 X2 -> auto_knows X2. (* Cut history. *)
Proof.  intros epsilon_m__def_30_pknows. exact (rem_827).
Defined.

Remark rem_829 : (forall X:term, auto___def_30 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_3 X1 -> auto___def_31 X2 -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_30_pknows. intros X1 X2.
  cut (auto___def_31 X2 -> auto_knows X2). tauto. exact (rem_828 epsilon_m__def_30_pknows X2).
Defined.

Remark rem_830 : (forall X:term, auto___def_30 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_3 X1 -> auto___def_31 X2 -> (auto_knows X1 /\ auto_knows X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_30_pknows. intros X1 X2. intros A1 A2.
  cut (auto_knows X1). 2:apply (rem_616 epsilon_m__def_30_pknows X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_829 epsilon_m__def_30_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_831 : (forall X:term, auto___def_30 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_3 X1 -> auto___def_31 X2 -> auto_knows (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_30_pknows. intros X1 X2. intros A1 A2.
  case (rem_830 epsilon_m__def_30_pknows X1 X2 A1 A2). clear  epsilon_m__def_30_pknows A1 A2. intros. apply trans_knows_cons_1;  tauto.
 clear  epsilon_m__def_30_pknows A1 A2. tauto.
Defined.

Remark rem_832 : forall X1 X2:term, auto___def_30 (cons X1 X2) -> or_1
    (auto___type_3 X1 /\ auto___def_31 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_833 : (forall X:term, auto___def_30 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_30 (cons X1 X2) -> auto_knows (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_30_pknows. intros X1 X2. intro H. intros.
  elim (rem_832 X1 X2 H);  intros.
  apply (rem_831 epsilon_m__def_30_pknows X1 X2);  tauto.
Defined.

Remark rem_834 : forall X1 X2:term, auto___def_30 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_835 : forall X1:term, auto___def_30 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_836 : auto___def_30 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_837 : auto___def_30 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_838 : forall X1 X2 X3:term, auto___def_30 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_839 : forall X1 X2 X3:term, auto___def_30 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_840 : auto___def_30 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_841 : forall X1 X2:term, auto___def_30 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_842 : auto___def_30 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_843 : auto___def_30 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_844 : auto___def_30 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_845 : forall X1 X2 X3:term, auto___def_30 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_846 : auto___def_30 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_847 : auto___def_30 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_848 : forall X1 X2:term, auto___def_30 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_849 : forall X1:term, auto___def_30 X1 -> auto_knows X1. (* Induct. *)
Proof.
  fix epsilon_m__def_30_pknows 1.
  intro X. case X.
   intro H. elim (rem_843  H).
   intro H. elim (rem_840  H).
  intros X1 X2;  exact (rem_833 epsilon_m__def_30_pknows X1 X2).
  intros X1 X2. intro H. elim (rem_834 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_845 X1 X2 X3 H).
   intro H. elim (rem_837  H).
  intros X1 X2. intro H. elim (rem_841 X1 X2 H).
   intro H. elim (rem_836  H).
  intros X1 X2. intro H. elim (rem_848 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_839 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_838 X1 X2 X3 H).
   intro H. elim (rem_844  H).
   intro H. elim (rem_846  H).
  intros X1. intro H. elim (rem_835 X1 H).
   intro H. elim (rem_847  H).
   intro H. elim (rem_842  H).
Qed.

Remark rem_850 : forall X1 X2:term, auto___def_13 X2 -> auto___def_16 X2 -> auto___def_30 X1 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_30 X1 -> auto_knows X1). tauto. exact (rem_849 X1).
Qed.

Remark rem_851 : forall X1 X2:term, auto___def_13 X2 -> auto___def_16 X2 -> auto___def_30 X1 -> auto_knows X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto_knows X1). 2:apply (rem_850 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_852 : forall X1 X2:term, auto___def_13 X2 -> auto___def_16 X2 -> auto___def_30 X1 -> auto___def_42 (s X1). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_851 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_42_s_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_853 : forall X1 X2:term, auto___def_30 X1 -> auto___def_16 X2 -> auto___def_13 X2 -> auto___def_42 (s X1). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_16 X2 -> auto___def_30 X1 -> auto___def_42 (s X1)). tauto. exact (rem_852 X1 X2).
Qed.

Remark rem_854 : (forall X:term, auto___def_40 X -> auto_knows X)
    -> forall X1:term, auto___def_33 X1 -> auto___def_33 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_855 : (forall X:term, auto___def_40 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___def_33 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_40_pknows. intros X1 X2 X3.
  cut (auto___def_33 X1 -> auto___def_33 X1). tauto. exact (rem_854 epsilon_m__def_40_pknows X1).
Defined.

Remark rem_856 : (forall X:term, auto___def_40 X -> auto_knows X)
    -> forall X2:term, auto___type_5 X2 -> auto___type_5 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_857 : (forall X:term, auto___def_40 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_40_pknows. intros X1 X2 X3.
  cut (auto___type_5 X2 -> auto___type_5 X2). tauto. exact (rem_856 epsilon_m__def_40_pknows X2).
Defined.

Remark rem_858 : (forall X:term, auto___def_40 X -> auto_knows X)
    -> forall X3:term, auto___type_4 X3 -> auto___type_4 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_859 : (forall X:term, auto___def_40 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_4 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_40_pknows. intros X1 X2 X3.
  cut (auto___type_4 X3 -> auto___type_4 X3). tauto. exact (rem_858 epsilon_m__def_40_pknows X3).
Defined.

Remark rem_860 : (forall X:term, auto___def_40 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> (auto___def_33 X1 /\ auto___type_5 X2 /\ auto___type_4 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_40_pknows. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_33 X1). 2:apply (rem_855 epsilon_m__def_40_pknows X1 X2 X3);  assumption.
  cut (auto___type_5 X2). 2:apply (rem_857 epsilon_m__def_40_pknows X1 X2 X3);  assumption.
  cut (auto___type_4 X3). 2:apply (rem_859 epsilon_m__def_40_pknows X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_861 : (forall X:term, auto___def_40 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto_knows (nonceb X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_40_pknows. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_860 epsilon_m__def_40_pknows X1 X2 X3 A1 A2 A3). clear  epsilon_m__def_40_pknows A1 A2 A3. intros. apply trans_knows_nonceb_1;  tauto.
 clear  epsilon_m__def_40_pknows A1 A2 A3. tauto.
Defined.

Remark rem_862 : (forall X:term, auto___def_40 X -> auto_knows X)
    -> forall X1:term, auto___def_16 X1 -> auto___def_16 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_863 : (forall X:term, auto___def_40 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___def_16 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_40_pknows. intros X1 X2 X3.
  cut (auto___def_16 X1 -> auto___def_16 X1). tauto. exact (rem_862 epsilon_m__def_40_pknows X1).
Defined.

Remark rem_864 : (forall X:term, auto___def_40 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_40_pknows. intros X1 X2 X3.
  cut (auto___type_5 X2 -> auto___type_5 X2). tauto. exact (rem_856 epsilon_m__def_40_pknows X2).
Defined.

Remark rem_865 : (forall X:term, auto___def_40 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_4 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_40_pknows. intros X1 X2 X3.
  cut (auto___type_4 X3 -> auto___type_4 X3). tauto. exact (rem_858 epsilon_m__def_40_pknows X3).
Defined.

Remark rem_866 : (forall X:term, auto___def_40 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> (auto___def_16 X1 /\ auto___type_5 X2 /\ auto___type_4 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_40_pknows. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_16 X1). 2:apply (rem_863 epsilon_m__def_40_pknows X1 X2 X3);  assumption.
  cut (auto___type_5 X2). 2:apply (rem_864 epsilon_m__def_40_pknows X1 X2 X3);  assumption.
  cut (auto___type_4 X3). 2:apply (rem_865 epsilon_m__def_40_pknows X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_867 : (forall X:term, auto___def_40 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto_knows (nonceb X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_40_pknows. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_866 epsilon_m__def_40_pknows X1 X2 X3 A1 A2 A3). clear  epsilon_m__def_40_pknows A1 A2 A3. intros. apply trans_knows_nonceb_2;  tauto.
 clear  epsilon_m__def_40_pknows A1 A2 A3. tauto.
Defined.

Remark rem_868 : forall X1 X2 X3:term, auto___def_40 (nonceb X1 X2 X3) -> or_2
    (auto___def_33 X1 /\ auto___type_5 X2 /\ auto___type_4 X3)
    (auto___def_16 X1 /\ auto___type_5 X2 /\ auto___type_4 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_869 : (forall X:term, auto___def_40 X -> auto_knows X)
    -> forall X1 X2 X3:term, auto___def_40 (nonceb X1 X2 X3) -> auto_knows (nonceb X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_40_pknows. intros X1 X2 X3. intro H. intros.
  elim (rem_868 X1 X2 X3 H);  intros.
  apply (rem_861 epsilon_m__def_40_pknows X1 X2 X3);  tauto.
  apply (rem_867 epsilon_m__def_40_pknows X1 X2 X3);  tauto.
Defined.

Remark rem_870 : forall X1 X2:term, auto___def_40 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_871 : forall X1:term, auto___def_40 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_872 : auto___def_40 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_873 : auto___def_40 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_874 : forall X1 X2 X3:term, auto___def_40 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_875 : auto___def_40 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_876 : forall X1 X2:term, auto___def_40 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_877 : auto___def_40 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_878 : auto___def_40 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_879 : forall X1 X2:term, auto___def_40 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_880 : auto___def_40 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_881 : forall X1 X2 X3:term, auto___def_40 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_882 : auto___def_40 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_883 : auto___def_40 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_884 : forall X1 X2:term, auto___def_40 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_885 : forall X1:term, auto___def_40 X1 -> auto_knows X1. (* Induct. *)
Proof.
  fix epsilon_m__def_40_pknows 1.
  intro X. case X.
   intro H. elim (rem_878  H).
   intro H. elim (rem_875  H).
  intros X1 X2. intro H. elim (rem_879 X1 X2 H).
  intros X1 X2. intro H. elim (rem_870 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_881 X1 X2 X3 H).
   intro H. elim (rem_873  H).
  intros X1 X2. intro H. elim (rem_876 X1 X2 H).
   intro H. elim (rem_872  H).
  intros X1 X2. intro H. elim (rem_884 X1 X2 H).
  intros X1 X2 X3;  exact (rem_869 epsilon_m__def_40_pknows X1 X2 X3).
  intros X1 X2 X3. intro H. elim (rem_874 X1 X2 X3 H).
   intro H. elim (rem_880  H).
   intro H. elim (rem_882  H).
  intros X1. intro H. elim (rem_871 X1 H).
   intro H. elim (rem_883  H).
   intro H. elim (rem_877  H).
Qed.

Remark rem_886 : forall X1 X2:term, auto___def_16 X2 -> auto___def_40 X1 -> auto___type_6 X2 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_40 X1 -> auto_knows X1). tauto. exact (rem_885 X1).
Qed.

Remark rem_887 : forall X1 X2:term, auto___def_16 X2 -> auto___def_40 X1 -> auto___type_6 X2 -> auto_knows X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto_knows X1). 2:apply (rem_886 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_888 : forall X1 X2:term, auto___def_16 X2 -> auto___def_40 X1 -> auto___type_6 X2 -> auto___def_42 (s X1). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_887 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_42_s_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_889 : forall X1 X2:term, auto___def_40 X1 -> auto___def_16 X2 -> auto___type_6 X2 -> auto___def_42 (s X1). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_16 X2 -> auto___def_40 X1 -> auto___type_6 X2 -> auto___def_42 (s X1)). tauto. exact (rem_888 X1 X2).
Qed.

Remark rem_890 : (forall X:term, auto___def_42 X -> auto_knows X)
    -> forall X1:term, auto_knows X1 -> auto_knows X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_891 : (forall X:term, auto___def_42 X -> auto_knows X)
    -> forall X1:term, auto_knows X1 -> auto_knows X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_42_pknows. intros X1. intros A1.
  cut (auto_knows X1). 2:apply (rem_890 epsilon_m__def_42_pknows X1);  assumption.
  tauto.
Defined.

Remark rem_892 : (forall X:term, auto___def_42 X -> auto_knows X)
    -> forall X1:term, auto_knows X1 -> auto_knows (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_42_pknows. intros X1. intros A1.
  case (rem_891 epsilon_m__def_42_pknows X1 A1). clear  epsilon_m__def_42_pknows A1. intros. apply trans_knows_s_1;  tauto.
 clear  epsilon_m__def_42_pknows A1. tauto.
Defined.

Remark rem_893 : forall X1:term, auto___def_42 (s X1) -> or_1
    (auto_knows X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_894 : (forall X:term, auto___def_42 X -> auto_knows X)
    -> forall X1:term, auto___def_42 (s X1) -> auto_knows (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_42_pknows. intros X1. intro H. intros.
  elim (rem_893 X1 H);  intros.
  apply (rem_892 epsilon_m__def_42_pknows X1);  tauto.
Defined.

Remark rem_895 : forall X1 X2:term, auto___def_42 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_896 : auto___def_42 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_897 : auto___def_42 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_898 : forall X1 X2 X3:term, auto___def_42 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_899 : forall X1 X2 X3:term, auto___def_42 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_900 : auto___def_42 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_901 : forall X1 X2:term, auto___def_42 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_902 : auto___def_42 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_903 : auto___def_42 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_904 : forall X1 X2:term, auto___def_42 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_905 : auto___def_42 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_906 : forall X1 X2 X3:term, auto___def_42 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_907 : auto___def_42 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_908 : auto___def_42 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_909 : forall X1 X2:term, auto___def_42 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_910 : forall X1:term, auto___def_42 X1 -> auto_knows X1. (* Induct. *)
Proof.
  fix epsilon_m__def_42_pknows 1.
  intro X. case X.
   intro H. elim (rem_903  H).
   intro H. elim (rem_900  H).
  intros X1 X2. intro H. elim (rem_904 X1 X2 H).
  intros X1 X2. intro H. elim (rem_895 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_906 X1 X2 X3 H).
   intro H. elim (rem_897  H).
  intros X1 X2. intro H. elim (rem_901 X1 X2 H).
   intro H. elim (rem_896  H).
  intros X1 X2. intro H. elim (rem_909 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_899 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_898 X1 X2 X3 H).
   intro H. elim (rem_905  H).
   intro H. elim (rem_907  H).
  intros X1;  exact (rem_894 epsilon_m__def_42_pknows X1).
   intro H. elim (rem_908  H).
   intro H. elim (rem_902  H).
Qed.

Remark rem_911 : forall X1 X2:term, auto___def_16 X2 -> auto___def_42 X1 -> auto___type_7 X2 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_42 X1 -> auto_knows X1). tauto. exact (rem_910 X1).
Qed.

Remark rem_912 : forall X1 X2:term, auto___def_16 X2 -> auto___def_42 X1 -> auto___type_7 X2 -> auto_knows X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto_knows X1). 2:apply (rem_911 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_913 : forall X1 X2:term, auto___def_16 X2 -> auto___def_42 X1 -> auto___type_7 X2 -> auto___def_42 (s X1). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_912 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_42_s_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_914 : forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto___def_16 X2 -> auto___def_42 (s X1). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_16 X2 -> auto___def_42 X1 -> auto___type_7 X2 -> auto___def_42 (s X1)). tauto. exact (rem_913 X1 X2).
Qed.

Inductive or_10(H1 H2 H3 H4 H5 H6 H7 H8 H9 H10:Prop) : Prop :=
    or_10_intro_1 : H1 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_2 : H2 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_3 : H3 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_4 : H4 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_5 : H5 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_6 : H6 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_7 : H7 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_8 : H8 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_9 : H9 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
  | or_10_intro_10 : H10 -> (or_10 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10)
.

Remark rem_915 : forall X1 X2:term, auto___def_41 X1 X2 -> or_10
    (auto___def_12 X1 /\ auto___def_16 X2 /\ auto___def_13 X2)
    (auto___def_22 X1 /\ auto___def_23 X2 /\ auto___def_16 X2)
    (auto___def_37 X1 /\ auto___def_23 X2 /\ auto___def_16 X2)
    (auto___def_22 X1 /\ auto___def_23 X2 /\ auto___def_33 X2)
    (auto_knows X1 /\ auto_knows X2 /\ auto___def_33 X2)
    (auto___def_12 X1 /\ auto___def_33 X2 /\ auto___def_13 X2)
    (auto_knows X1 /\ auto_knows X2 /\ auto___def_16 X2)
    (auto___def_30 X1 /\ auto___def_16 X2 /\ auto___def_13 X2)
    (auto___def_40 X1 /\ auto___def_16 X2 /\ auto___type_6 X2)
    (auto___def_42 X1 /\ auto___type_7 X2 /\ auto___def_16 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_10_intro_1; tauto.
  intros. apply or_10_intro_2; tauto.
  intros. apply or_10_intro_3; tauto.
  intros. apply or_10_intro_4; tauto.
  intros. apply or_10_intro_5; tauto.
  intros. apply or_10_intro_6; tauto.
  intros. apply or_10_intro_7; tauto.
  intros. apply or_10_intro_8; tauto.
  intros. apply or_10_intro_9; tauto.
  intros. apply or_10_intro_10; tauto.
Qed.

Remark rem_916 : forall X1 X2:term, auto___def_41 X1 X2 -> auto___def_42 (s X1). (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_915 X1 X2 H);  intros.
  apply (rem_163 X1 X2);  tauto.
  apply (rem_190 X1 X2);  tauto.
  apply (rem_441 X1 X2);  tauto.
  apply (rem_465 X1 X2);  tauto.
  apply (rem_470 X1 X2);  tauto.
  apply (rem_495 X1 X2);  tauto.
  apply (rem_499 X1 X2);  tauto.
  apply (rem_853 X1 X2);  tauto.
  apply (rem_889 X1 X2);  tauto.
  apply (rem_914 X1 X2);  tauto.
Qed.

Remark rem_917 : forall X1:term, auto___type_5 X1 -> auto___type_5 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_918 : forall X1 X2:term, auto___def_21 X2 -> auto___type_5 X1 -> auto___type_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_5 X1 -> auto___type_5 X1). tauto. exact (rem_917 X1).
Qed.

Remark rem_919 : forall X2:term, auto___def_21 X2 -> auto___def_21 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_920 : forall X1 X2:term, auto___def_21 X2 -> auto___type_5 X1 -> auto___def_21 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_21 X2 -> auto___def_21 X2). tauto. exact (rem_919 X2).
Qed.

Remark rem_921 : forall X1 X2:term, auto___def_21 X2 -> auto___type_5 X1 -> (auto___type_5 X1 /\ auto___def_21 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_5 X1). 2:apply (rem_918 X1 X2);  assumption.
  cut (auto___def_21 X2). 2:apply (rem_920 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_922 : forall X1 X2:term, auto___def_21 X2 -> auto___type_5 X1 -> auto___def_24 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_921 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_24_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_923 : forall X1:term, auto___def_33 X1 -> auto___def_33 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_924 : forall X1 X2:term, auto___def_24 X2 -> auto___def_33 X1 -> auto___def_33 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_33 X1 -> auto___def_33 X1). tauto. exact (rem_923 X1).
Qed.

Remark rem_925 : forall X2:term, auto___def_24 X2 -> auto___def_24 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_926 : forall X1 X2:term, auto___def_24 X2 -> auto___def_33 X1 -> auto___def_24 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_24 X2 -> auto___def_24 X2). tauto. exact (rem_925 X2).
Qed.

Remark rem_927 : forall X1 X2:term, auto___def_24 X2 -> auto___def_33 X1 -> (auto___def_33 X1 /\ auto___def_24 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_33 X1). 2:apply (rem_924 X1 X2);  assumption.
  cut (auto___def_24 X2). 2:apply (rem_926 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_928 : forall X1 X2:term, auto___def_24 X2 -> auto___def_33 X1 -> auto___def_37 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_927 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_37_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_929 : forall X1 X2 X3 X4:term, auto___def_42 (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) -> auto___type_7 (key sym (cons X1 (cons server nil))) -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_904 (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil))) H);  intros.
Qed.

Remark rem_930 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_20 X3 -> auto___type_4 X2 -> auto___type_5 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_5 X1 -> auto___type_5 X1). tauto. exact (rem_917 X1).
Qed.

Remark rem_931 : forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_932 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_20 X3 -> auto___type_4 X2 -> auto___type_5 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_931 X1).
Qed.

Remark rem_933 : forall X2:term, auto___type_4 X2 -> auto___type_4 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_934 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_20 X3 -> auto___type_4 X2 -> auto___type_5 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_4 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_4 X2 -> auto___type_4 X2). tauto. exact (rem_933 X2).
Qed.

Remark rem_935 : forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_936 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_20 X3 -> auto___type_4 X2 -> auto___type_5 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_935 X2).
Qed.

Remark rem_937 : forall X3:term, auto___def_20 X3 -> auto___def_20 X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_938 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_20 X3 -> auto___type_4 X2 -> auto___type_5 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_20 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_20 X3 -> auto___def_20 X3). tauto. exact (rem_937 X3).
Qed.

Remark rem_939 : forall X4:term, auto___def_16 X4 -> auto___def_16 X4. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_940 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_20 X3 -> auto___type_4 X2 -> auto___type_5 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_16 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_16 X4 -> auto___def_16 X4). tauto. exact (rem_939 X4).
Qed.

Remark rem_941 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_20 X3 -> auto___type_4 X2 -> auto___type_5 X1 -> auto_agent X2 -> auto_agent X1 -> (auto___type_5 X1 /\ auto_agent X1 /\ auto___type_4 X2 /\ auto_agent X2 /\ auto___def_20 X3 /\ auto___def_16 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  cut (auto___type_5 X1). 2:apply (rem_930 X1 X2 X3 X4);  assumption.
  cut (auto_agent X1). 2:apply (rem_932 X1 X2 X3 X4);  assumption.
  cut (auto___type_4 X2). 2:apply (rem_934 X1 X2 X3 X4);  assumption.
  cut (auto_agent X2). 2:apply (rem_936 X1 X2 X3 X4);  assumption.
  cut (auto___def_20 X3). 2:apply (rem_938 X1 X2 X3 X4);  assumption.
  cut (auto___def_16 X4). 2:apply (rem_940 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_942 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_20 X3 -> auto___type_4 X2 -> auto___type_5 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_38 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  case (rem_941 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6). clear  A1 A2 A3 A4 A5 A6. intros. apply trans___def_38_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6. tauto.
Qed.

Remark rem_943 : forall X1 X2 X3 X4:term, auto_agent X1 -> auto_agent X2 -> auto___def_16 X4 -> auto___def_20 X3 -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_38 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_16 X4 -> auto___def_20 X3 -> auto___type_4 X2 -> auto___type_5 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_38 X1 X2 X3 X4). tauto. exact (rem_942 X1 X2 X3 X4).
Qed.

Remark rem_944 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_20 X3 -> auto___type_3 (noncea X1 X2) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_607 X1 X2 H);  intros.
  apply (rem_943 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_945 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_20 X3 -> auto___def_26 (cons server nil) -> auto___type_3 (noncea X1 X2) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_38 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_16 X4 -> auto___def_20 X3 -> auto___type_3 (noncea X1 X2) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_38 X1 X2 X3 X4). tauto.
  exact (rem_944 X1 X2 X3 X4).
Qed.

Remark rem_946 : forall X1 X2 X3 X4:term, auto___type_5 X1 -> auto___def_26 (cons server nil) -> auto___def_16 X4 -> auto___def_20 X3 -> auto___type_3 (noncea X1 X2) -> auto___type_4 X2 -> auto___def_38 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_16 X4 -> auto___def_20 X3 -> auto___def_26 (cons server nil) -> auto___type_3 (noncea X1 X2) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_38 X1 X2 X3 X4). tauto. exact (rem_945 X1 X2 X3 X4).
Qed.

Remark rem_947 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_20 X3 -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea X1 X2) -> auto___type_4 X2 -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_472 X1 (cons server nil) H);  intros.
  apply (rem_946 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_948 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_20 X3 -> auto___def_21 nil -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea X1 X2) -> auto___type_4 X2 -> auto___def_38 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_16 X4 -> auto___def_20 X3 -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea X1 X2) -> auto___type_4 X2 -> auto___def_38 X1 X2 X3 X4). tauto.
  exact (rem_947 X1 X2 X3 X4).
Qed.

Remark rem_949 : forall X1 X2 X3 X4:term, auto___def_20 X3 -> auto___def_21 nil -> auto___def_16 X4 -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea X1 X2) -> auto___type_4 X2 -> auto___def_38 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_16 X4 -> auto___def_20 X3 -> auto___def_21 nil -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea X1 X2) -> auto___type_4 X2 -> auto___def_38 X1 X2 X3 X4). tauto. exact (rem_948 X1 X2 X3 X4).
Qed.

Remark rem_950 : forall X1 X2:term, auto___def_17 (cons X1 X2) -> or_1
    (auto___def_20 X1 /\ auto___def_21 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_951 : forall X1 X2 X3 X4:term, auto___def_16 X4 -> auto___def_17 (cons X3 nil) -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea X1 X2) -> auto___type_4 X2 -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_950 X3 nil H);  intros.
  apply (rem_949 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_952 : forall X1 X2:term, auto___def_15 (cons X1 X2) -> or_1
    (auto___def_16 X1 /\ auto___def_17 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_953 : forall X1 X2 X3 X4:term, auto___def_15 (cons X4 (cons X3 nil)) -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea X1 X2) -> auto___type_4 X2 -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_952 X4 (cons X3 nil) H);  intros.
  apply (rem_951 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_954 : forall X1 X2 X3 X4:term, auto___type_4 X2 -> auto___def_15 (cons X4 (cons X3 nil)) -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea X1 X2) -> auto___def_38 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_15 (cons X4 (cons X3 nil)) -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea X1 X2) -> auto___type_4 X2 -> auto___def_38 X1 X2 X3 X4). tauto. exact (rem_953 X1 X2 X3 X4).
Qed.

Remark rem_955 : forall X1 X2:term, auto___def_14 (cons X1 X2) -> or_1
    (auto___type_4 X1 /\ auto___def_15 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_956 : forall X1 X2 X3 X4:term, auto___def_14 (cons X2 (cons X4 (cons X3 nil))) -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea X1 X2) -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_955 X2 (cons X4 (cons X3 nil)) H);  intros.
  apply (rem_954 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_957 : forall X1 X2 X3 X4:term, auto___def_14 (cons X2 (cons X4 (cons X3 nil))) -> auto___def_18 sym -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea X1 X2) -> auto___def_38 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_14 (cons X2 (cons X4 (cons X3 nil))) -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea X1 X2) -> auto___def_38 X1 X2 X3 X4). tauto.
  exact (rem_956 X1 X2 X3 X4).
Qed.

Remark rem_958 : forall X1 X2 X3 X4:term, auto___def_18 sym -> auto___def_29 (cons X1 (cons server nil)) -> auto___def_14 (cons X2 (cons X4 (cons X3 nil))) -> auto___type_3 (noncea X1 X2) -> auto___def_38 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_14 (cons X2 (cons X4 (cons X3 nil))) -> auto___def_18 sym -> auto___def_29 (cons X1 (cons server nil)) -> auto___type_3 (noncea X1 X2) -> auto___def_38 X1 X2 X3 X4). tauto. exact (rem_957 X1 X2 X3 X4).
Qed.

Remark rem_959 : forall X1 X2 X3 X4:term, auto___def_13 (key sym (cons X1 (cons server nil))) -> auto___def_14 (cons X2 (cons X4 (cons X3 nil))) -> auto___type_3 (noncea X1 X2) -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_142 sym (cons X1 (cons server nil)) H);  intros.
  apply (rem_958 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_960 : forall X1 X2 X3 X4:term, auto___type_3 (noncea X1 X2) -> auto___def_14 (cons X2 (cons X4 (cons X3 nil))) -> auto___def_13 (key sym (cons X1 (cons server nil))) -> auto___def_38 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_13 (key sym (cons X1 (cons server nil))) -> auto___def_14 (cons X2 (cons X4 (cons X3 nil))) -> auto___type_3 (noncea X1 X2) -> auto___def_38 X1 X2 X3 X4). tauto. exact (rem_959 X1 X2 X3 X4).
Qed.

Remark rem_961 : forall X1 X2:term, auto___def_12 (cons X1 X2) -> or_1
    (auto___type_3 X1 /\ auto___def_14 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_962 : forall X1 X2 X3 X4:term, auto___def_12 (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) -> auto___def_13 (key sym (cons X1 (cons server nil))) -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_961 (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil))) H);  intros.
  apply (rem_960 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_963 : forall X1 X2 X3 X4:term, auto___def_16 (noncea X1 X2) -> auto___def_23 (key sym (cons X1 (cons server nil))) -> auto___def_24 (cons X2 (cons X4 (cons X3 nil))) -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_160 X1 X2 H);  intros.
Qed.

Remark rem_964 : forall X1 X2 X3 X4:term, auto___def_16 (noncea X1 X2) -> auto___def_24 (cons X2 (cons X4 (cons X3 nil))) -> auto___def_23 (key sym (cons X1 (cons server nil))) -> auto___def_38 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_16 (noncea X1 X2) -> auto___def_23 (key sym (cons X1 (cons server nil))) -> auto___def_24 (cons X2 (cons X4 (cons X3 nil))) -> auto___def_38 X1 X2 X3 X4). tauto. exact (rem_963 X1 X2 X3 X4).
Qed.

Remark rem_965 : forall X1 X2:term, auto___def_22 (cons X1 X2) -> or_1
    (auto___def_16 X1 /\ auto___def_24 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_966 : forall X1 X2 X3 X4:term, auto___def_22 (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) -> auto___def_23 (key sym (cons X1 (cons server nil))) -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_965 (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil))) H);  intros.
  apply (rem_964 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_967 : forall X1 X2 X3 X4:term, auto___def_21 (cons X4 (cons X3 nil)) -> auto___def_33 (noncea X1 X2) -> auto___type_4 X1 -> auto___type_5 X2 -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_387 X4 (cons X3 nil) H);  intros.
Qed.

Remark rem_968 : forall X1 X2 X3 X4:term, auto___type_5 X2 -> auto___def_21 (cons X4 (cons X3 nil)) -> auto___def_33 (noncea X1 X2) -> auto___type_4 X1 -> auto___def_38 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_21 (cons X4 (cons X3 nil)) -> auto___def_33 (noncea X1 X2) -> auto___type_4 X1 -> auto___type_5 X2 -> auto___def_38 X1 X2 X3 X4). tauto. exact (rem_967 X1 X2 X3 X4).
Qed.

Remark rem_969 : forall X1 X2 X3 X4:term, auto___def_24 (cons X2 (cons X4 (cons X3 nil))) -> auto___def_33 (noncea X1 X2) -> auto___type_4 X1 -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_398 X2 (cons X4 (cons X3 nil)) H);  intros.
  apply (rem_968 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_970 : forall X1 X2 X3 X4:term, auto___def_33 (noncea X1 X2) -> auto___def_24 (cons X2 (cons X4 (cons X3 nil))) -> auto___type_4 X1 -> auto___def_38 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_24 (cons X2 (cons X4 (cons X3 nil))) -> auto___def_33 (noncea X1 X2) -> auto___type_4 X1 -> auto___def_38 X1 X2 X3 X4). tauto. exact (rem_969 X1 X2 X3 X4).
Qed.

Remark rem_971 : forall X1 X2 X3 X4:term, auto___def_37 (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) -> auto___type_4 X1 -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_420 (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil))) H);  intros.
  apply (rem_970 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_972 : forall X1 X2 X3 X4:term, auto___def_26 (cons server nil) -> auto___def_37 (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) -> auto___type_4 X1 -> auto___def_38 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_37 (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) -> auto___type_4 X1 -> auto___def_38 X1 X2 X3 X4). tauto.
  exact (rem_971 X1 X2 X3 X4).
Qed.

Remark rem_973 : forall X1 X2 X3 X4:term, auto___type_4 X1 -> auto___def_26 (cons server nil) -> auto___def_37 (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) -> auto___def_38 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_26 (cons server nil) -> auto___def_37 (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) -> auto___type_4 X1 -> auto___def_38 X1 X2 X3 X4). tauto. exact (rem_972 X1 X2 X3 X4).
Qed.

Remark rem_974 : forall X1 X2 X3 X4:term, auto___def_25 (cons X1 (cons server nil)) -> auto___def_37 (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_443 X1 (cons server nil) H);  intros.
  apply (rem_973 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_975 : forall X1 X2 X3 X4:term, auto___def_18 sym -> auto___def_25 (cons X1 (cons server nil)) -> auto___def_37 (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) -> auto___def_38 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_25 (cons X1 (cons server nil)) -> auto___def_37 (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) -> auto___def_38 X1 X2 X3 X4). tauto.
  exact (rem_974 X1 X2 X3 X4).
Qed.

Remark rem_976 : forall X1 X2 X3 X4:term, auto___def_23 (key sym (cons X1 (cons server nil))) -> auto___def_37 (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_171 sym (cons X1 (cons server nil)) H);  intros.
  apply (rem_975 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_977 : forall X1 X2 X3 X4:term, auto___def_37 (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) -> auto___def_23 (key sym (cons X1 (cons server nil))) -> auto___def_38 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_23 (key sym (cons X1 (cons server nil))) -> auto___def_37 (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) -> auto___def_38 X1 X2 X3 X4). tauto. exact (rem_976 X1 X2 X3 X4).
Qed.

Remark rem_978 : auto___def_43 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_979 : auto___def_43 sym -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_978 H);  intros.
Qed.

Remark rem_980 : forall X1 X2 X3 X4:term, auto___def_43 sym -> auto_knows X2 -> auto_knows X4 -> auto_knows X3 -> auto_knows (noncea X1 X2) -> auto___def_38 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_43 sym -> False). tauto.
  exact (rem_979).
Qed.

Remark rem_981 : forall X1 X2 X3 X4:term, auto___def_43 sym -> auto___type_8 (cons X1 (cons server nil)) -> auto_knows X2 -> auto_knows X4 -> auto_knows X3 -> auto_knows (noncea X1 X2) -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2 X3 X4. intros. apply (rem_980 X1 X2 X3 X4);  assumption.
Qed.

Remark rem_982 : forall X1 X2:term, auto___def_47 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_983 : forall X1 X2 X3 X4:term, auto___def_47 (cons X1 (cons server nil)) -> auto_knows X2 -> auto_knows X4 -> auto_knows X3 -> auto_knows (noncea X1 X2) -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_982 X1 (cons server nil) H);  intros.
Qed.

Remark rem_984 : forall X1 X2 X3 X4:term, auto___def_46 sym -> auto___def_47 (cons X1 (cons server nil)) -> auto_knows X2 -> auto_knows X4 -> auto_knows X3 -> auto_knows (noncea X1 X2) -> auto___def_38 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_47 (cons X1 (cons server nil)) -> auto_knows X2 -> auto_knows X4 -> auto_knows X3 -> auto_knows (noncea X1 X2) -> auto___def_38 X1 X2 X3 X4). tauto.
  exact (rem_983 X1 X2 X3 X4).
Qed.

Remark rem_985 : forall X1 X2:term, auto___def_45 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_986 : forall X1 X2 X3 X4:term, auto___def_45 (cons X1 (cons server nil)) -> auto_knows X2 -> auto_knows X4 -> auto_knows X3 -> auto_knows (noncea X1 X2) -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_985 X1 (cons server nil) H);  intros.
Qed.

Remark rem_987 : forall X1 X2 X3 X4:term, auto___def_44 sym -> auto___def_45 (cons X1 (cons server nil)) -> auto_knows X2 -> auto_knows X4 -> auto_knows X3 -> auto_knows (noncea X1 X2) -> auto___def_38 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_45 (cons X1 (cons server nil)) -> auto_knows X2 -> auto_knows X4 -> auto_knows X3 -> auto_knows (noncea X1 X2) -> auto___def_38 X1 X2 X3 X4). tauto.
  exact (rem_986 X1 X2 X3 X4).
Qed.

Remark rem_988 : forall X1 X2 X3 X4:term, auto_knows X2 -> auto_knows X4 -> auto_knows X3 -> auto_knows (key sym (cons X1 (cons server nil))) -> auto_knows (noncea X1 X2) -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3. intro H. intros.
  elim (rem_91 sym (cons X1 (cons server nil)) H);  intros.
  apply (rem_981 X1 X2 X3 X4);  tauto.
  apply (rem_984 X1 X2 X3 X4);  tauto.
  apply (rem_987 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_989 : forall X1 X2 X3 X4:term, auto_knows X2 -> auto_knows X4 -> auto_knows X3 -> auto_knows (key sym (cons X1 (cons server nil))) -> auto_knows nil -> auto_knows (noncea X1 X2) -> auto___def_38 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_knows X2 -> auto_knows X4 -> auto_knows X3 -> auto_knows (key sym (cons X1 (cons server nil))) -> auto_knows (noncea X1 X2) -> auto___def_38 X1 X2 X3 X4). tauto.
  exact (rem_988 X1 X2 X3 X4).
Qed.

Remark rem_990 : forall X1 X2 X3 X4:term, auto_knows X3 -> auto_knows nil -> auto_knows X2 -> auto_knows X4 -> auto_knows (key sym (cons X1 (cons server nil))) -> auto_knows (noncea X1 X2) -> auto___def_38 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows X2 -> auto_knows X4 -> auto_knows X3 -> auto_knows (key sym (cons X1 (cons server nil))) -> auto_knows nil -> auto_knows (noncea X1 X2) -> auto___def_38 X1 X2 X3 X4). tauto. exact (rem_989 X1 X2 X3 X4).
Qed.

Remark rem_991 : forall X1 X2 X3 X4:term, auto_knows X2 -> auto_knows X4 -> auto_knows (cons X3 nil) -> auto_knows (key sym (cons X1 (cons server nil))) -> auto_knows (noncea X1 X2) -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_97 X3 nil H);  intros.
  apply (rem_990 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_992 : forall X1 X2 X3 X4:term, auto_knows X4 -> auto_knows (cons X3 nil) -> auto_knows X2 -> auto_knows (key sym (cons X1 (cons server nil))) -> auto_knows (noncea X1 X2) -> auto___def_38 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows X2 -> auto_knows X4 -> auto_knows (cons X3 nil) -> auto_knows (key sym (cons X1 (cons server nil))) -> auto_knows (noncea X1 X2) -> auto___def_38 X1 X2 X3 X4). tauto. exact (rem_991 X1 X2 X3 X4).
Qed.

Remark rem_993 : forall X1 X2 X3 X4:term, auto_knows X2 -> auto_knows (cons X4 (cons X3 nil)) -> auto_knows (key sym (cons X1 (cons server nil))) -> auto_knows (noncea X1 X2) -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_97 X4 (cons X3 nil) H);  intros.
  apply (rem_992 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_994 : forall X1 X2 X3 X4:term, auto_knows (cons X2 (cons X4 (cons X3 nil))) -> auto_knows (key sym (cons X1 (cons server nil))) -> auto_knows (noncea X1 X2) -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_97 X2 (cons X4 (cons X3 nil)) H);  intros.
  apply (rem_993 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_995 : forall X1 X2 X3 X4:term, auto_knows (noncea X1 X2) -> auto_knows (cons X2 (cons X4 (cons X3 nil))) -> auto_knows (key sym (cons X1 (cons server nil))) -> auto___def_38 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_knows (cons X2 (cons X4 (cons X3 nil))) -> auto_knows (key sym (cons X1 (cons server nil))) -> auto_knows (noncea X1 X2) -> auto___def_38 X1 X2 X3 X4). tauto. exact (rem_994 X1 X2 X3 X4).
Qed.

Remark rem_996 : forall X1 X2 X3 X4:term, auto_knows (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) -> auto_knows (key sym (cons X1 (cons server nil))) -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_97 (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil))) H);  intros.
  apply (rem_995 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_997 : forall X1 X2 X3 X4:term, auto___def_40 (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) -> auto___type_6 (key sym (cons X1 (cons server nil))) -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_879 (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil))) H);  intros.
Qed.

Remark rem_998 : forall X1 X2 X3 X4:term, auto___def_33 X4 -> auto___def_36 X3 -> auto___type_4 X2 -> auto___type_5 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_5 X1 -> auto___type_5 X1). tauto. exact (rem_917 X1).
Qed.

Remark rem_999 : forall X1 X2 X3 X4:term, auto___def_33 X4 -> auto___def_36 X3 -> auto___type_4 X2 -> auto___type_5 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_931 X1).
Qed.

Remark rem_1000 : forall X1 X2 X3 X4:term, auto___def_33 X4 -> auto___def_36 X3 -> auto___type_4 X2 -> auto___type_5 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_4 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_4 X2 -> auto___type_4 X2). tauto. exact (rem_933 X2).
Qed.

Remark rem_1001 : forall X1 X2 X3 X4:term, auto___def_33 X4 -> auto___def_36 X3 -> auto___type_4 X2 -> auto___type_5 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_935 X2).
Qed.

Remark rem_1002 : forall X3:term, auto___def_36 X3 -> auto___def_36 X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1003 : forall X1 X2 X3 X4:term, auto___def_33 X4 -> auto___def_36 X3 -> auto___type_4 X2 -> auto___type_5 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_36 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_36 X3 -> auto___def_36 X3). tauto. exact (rem_1002 X3).
Qed.

Remark rem_1004 : forall X4:term, auto___def_33 X4 -> auto___def_33 X4. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1005 : forall X1 X2 X3 X4:term, auto___def_33 X4 -> auto___def_36 X3 -> auto___type_4 X2 -> auto___type_5 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_33 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_33 X4 -> auto___def_33 X4). tauto. exact (rem_1004 X4).
Qed.

Remark rem_1006 : forall X1 X2 X3 X4:term, auto___def_33 X4 -> auto___def_36 X3 -> auto___type_4 X2 -> auto___type_5 X1 -> auto_agent X2 -> auto_agent X1 -> (auto___type_5 X1 /\ auto_agent X1 /\ auto___type_4 X2 /\ auto_agent X2 /\ auto___def_36 X3 /\ auto___def_33 X4) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  cut (auto___type_5 X1). 2:apply (rem_998 X1 X2 X3 X4);  assumption.
  cut (auto_agent X1). 2:apply (rem_999 X1 X2 X3 X4);  assumption.
  cut (auto___type_4 X2). 2:apply (rem_1000 X1 X2 X3 X4);  assumption.
  cut (auto_agent X2). 2:apply (rem_1001 X1 X2 X3 X4);  assumption.
  cut (auto___def_36 X3). 2:apply (rem_1003 X1 X2 X3 X4);  assumption.
  cut (auto___def_33 X4). 2:apply (rem_1005 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_1007 : forall X1 X2 X3 X4:term, auto___def_33 X4 -> auto___def_36 X3 -> auto___type_4 X2 -> auto___type_5 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_38 X1 X2 X3 X4. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  case (rem_1006 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6). clear  A1 A2 A3 A4 A5 A6. intros. apply trans___def_38_2;  tauto.
 clear  A1 A2 A3 A4 A5 A6. tauto.
Qed.

Remark rem_1008 : forall X1 X2 X3 X4:term, auto_agent X1 -> auto_agent X2 -> auto___def_33 X4 -> auto___def_36 X3 -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_38 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_33 X4 -> auto___def_36 X3 -> auto___type_4 X2 -> auto___type_5 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_38 X1 X2 X3 X4). tauto. exact (rem_1007 X1 X2 X3 X4).
Qed.

Remark rem_1009 : forall X1 X2 X3 X4:term, auto___def_33 X4 -> auto___def_36 X3 -> auto___type_3 (noncea X1 X2) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2. intro H. intros.
  elim (rem_607 X1 X2 H);  intros.
  apply (rem_1008 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1010 : forall X1 X2 X3 X4:term, auto___def_21 nil -> auto___def_33 X4 -> auto___def_36 X3 -> auto___type_3 (noncea X1 X2) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_38 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_33 X4 -> auto___def_36 X3 -> auto___type_3 (noncea X1 X2) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_38 X1 X2 X3 X4). tauto.
  exact (rem_1009 X1 X2 X3 X4).
Qed.

Remark rem_1011 : forall X1 X2 X3 X4:term, auto___def_36 X3 -> auto___def_21 nil -> auto___def_33 X4 -> auto___type_3 (noncea X1 X2) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_38 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_21 nil -> auto___def_33 X4 -> auto___def_36 X3 -> auto___type_3 (noncea X1 X2) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_38 X1 X2 X3 X4). tauto. exact (rem_1010 X1 X2 X3 X4).
Qed.

Remark rem_1012 : forall X1 X2 X3 X4:term, auto___def_33 X4 -> auto___def_34 (cons X3 nil) -> auto___type_3 (noncea X1 X2) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_766 X3 nil H);  intros.
  apply (rem_1011 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1013 : forall X1 X2 X3 X4:term, auto___def_32 (cons X4 (cons X3 nil)) -> auto___type_3 (noncea X1 X2) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_788 X4 (cons X3 nil) H);  intros.
  apply (rem_1012 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1014 : forall X1 X2 X3 X4:term, auto___type_4 X2 -> auto___def_32 (cons X4 (cons X3 nil)) -> auto___type_3 (noncea X1 X2) -> auto___type_5 X1 -> auto___def_38 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_32 (cons X4 (cons X3 nil)) -> auto___type_3 (noncea X1 X2) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_38 X1 X2 X3 X4). tauto. exact (rem_1013 X1 X2 X3 X4).
Qed.

Remark rem_1015 : forall X1 X2 X3 X4:term, auto___def_31 (cons X2 (cons X4 (cons X3 nil))) -> auto___type_3 (noncea X1 X2) -> auto___type_5 X1 -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_810 X2 (cons X4 (cons X3 nil)) H);  intros.
  apply (rem_1014 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1016 : forall X1 X2 X3 X4:term, auto___type_3 (noncea X1 X2) -> auto___def_31 (cons X2 (cons X4 (cons X3 nil))) -> auto___type_5 X1 -> auto___def_38 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_31 (cons X2 (cons X4 (cons X3 nil))) -> auto___type_3 (noncea X1 X2) -> auto___type_5 X1 -> auto___def_38 X1 X2 X3 X4). tauto. exact (rem_1015 X1 X2 X3 X4).
Qed.

Remark rem_1017 : forall X1 X2 X3 X4:term, auto___def_30 (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) -> auto___type_5 X1 -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_832 (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil))) H);  intros.
  apply (rem_1016 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1018 : forall X1 X2 X3 X4:term, auto___def_26 (cons server nil) -> auto___def_30 (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) -> auto___type_5 X1 -> auto___def_38 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_30 (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) -> auto___type_5 X1 -> auto___def_38 X1 X2 X3 X4). tauto.
  exact (rem_1017 X1 X2 X3 X4).
Qed.

Remark rem_1019 : forall X1 X2 X3 X4:term, auto___type_5 X1 -> auto___def_26 (cons server nil) -> auto___def_30 (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) -> auto___def_38 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_26 (cons server nil) -> auto___def_30 (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) -> auto___type_5 X1 -> auto___def_38 X1 X2 X3 X4). tauto. exact (rem_1018 X1 X2 X3 X4).
Qed.

Remark rem_1020 : forall X1 X2 X3 X4:term, auto___def_29 (cons X1 (cons server nil)) -> auto___def_30 (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_472 X1 (cons server nil) H);  intros.
  apply (rem_1019 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1021 : forall X1 X2 X3 X4:term, auto___def_18 sym -> auto___def_29 (cons X1 (cons server nil)) -> auto___def_30 (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) -> auto___def_38 X1 X2 X3 X4. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_29 (cons X1 (cons server nil)) -> auto___def_30 (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) -> auto___def_38 X1 X2 X3 X4). tauto.
  exact (rem_1020 X1 X2 X3 X4).
Qed.

Remark rem_1022 : forall X1 X2 X3 X4:term, auto___def_13 (key sym (cons X1 (cons server nil))) -> auto___def_30 (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_142 sym (cons X1 (cons server nil)) H);  intros.
  apply (rem_1021 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1023 : forall X1 X2 X3 X4:term, auto___def_30 (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) -> auto___def_13 (key sym (cons X1 (cons server nil))) -> auto___def_38 X1 X2 X3 X4. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_13 (key sym (cons X1 (cons server nil))) -> auto___def_30 (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) -> auto___def_38 X1 X2 X3 X4). tauto. exact (rem_1022 X1 X2 X3 X4).
Qed.

Remark rem_1024 : forall X1 X2 X3 X4:term, auto_knows (crypt (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) (key sym (cons X1 (cons server nil)))) -> auto___def_38 X1 X2 X3 X4. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_41 (cons (noncea X1 X2) (cons X2 (cons X4 (cons X3 nil)))) (key sym (cons X1 (cons server nil))) H);  intros.
  apply (rem_929 X1 X2 X3 X4);  tauto.
  apply (rem_962 X1 X2 X3 X4);  tauto.
  apply (rem_966 X1 X2 X3 X4);  tauto.
  apply (rem_977 X1 X2 X3 X4);  tauto.
  apply (rem_996 X1 X2 X3 X4);  tauto.
  apply (rem_997 X1 X2 X3 X4);  tauto.
  apply (rem_1023 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_1025 : forall X1:term, auto___def_43 sym -> auto___def_6 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_43 sym -> False). tauto.
  exact (rem_979).
Qed.

Remark rem_1026 : forall X1:term, auto___def_43 sym -> auto___type_8 X1 -> auto___def_6 X1. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1. intros. apply (rem_1025 X1);  assumption.
Qed.

Remark rem_1027 : (forall X:term, auto___def_47 X -> auto___def_6 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_47_p__def_6.  tauto.
Defined.

Remark rem_1028 : (forall X:term, auto___def_47 X -> auto___def_6 X)
    -> forall X1 X2 X3:term, auto___def_6 (old_session X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_47_p__def_6. intros X1 X2 X3.  case (rem_1027 epsilon_m__def_47_p__def_6). clear  epsilon_m__def_47_p__def_6. intros. apply trans___def_6_old_session_1;  tauto.
 clear  epsilon_m__def_47_p__def_6. tauto.
Defined.

Remark rem_1029 : forall X1 X2 X3:term, auto___def_47 (old_session X1 X2 X3) -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1030 : (forall X:term, auto___def_47 X -> auto___def_6 X)
    -> forall X1 X2 X3:term, auto___def_47 (old_session X1 X2 X3) -> auto___def_6 (old_session X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_47_p__def_6. intros X1 X2 X3. intro H. intros.
  elim (rem_1029 X1 X2 X3 H);  intros.
  apply (rem_1028 epsilon_m__def_47_p__def_6 X1 X2 X3);  tauto.
Defined.

Remark rem_1031 : forall X1 X2:term, auto___def_47 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1032 : forall X1:term, auto___def_47 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1033 : auto___def_47 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1034 : auto___def_47 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1035 : forall X1 X2 X3:term, auto___def_47 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1036 : auto___def_47 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1037 : forall X1 X2:term, auto___def_47 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1038 : auto___def_47 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1039 : auto___def_47 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1040 : auto___def_47 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1041 : forall X1 X2 X3:term, auto___def_47 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1042 : auto___def_47 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1043 : auto___def_47 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1044 : forall X1 X2:term, auto___def_47 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1045 : forall X1:term, auto___def_47 X1 -> auto___def_6 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_47_p__def_6 1.
  intro X. case X.
   intro H. elim (rem_1039  H).
   intro H. elim (rem_1036  H).
  intros X1 X2. intro H. elim (rem_982 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1031 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1041 X1 X2 X3 H).
   intro H. elim (rem_1034  H).
  intros X1 X2. intro H. elim (rem_1037 X1 X2 H).
   intro H. elim (rem_1033  H).
  intros X1 X2. intro H. elim (rem_1044 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1035 X1 X2 X3 H).
  intros X1 X2 X3;  exact (rem_1030 epsilon_m__def_47_p__def_6 X1 X2 X3).
   intro H. elim (rem_1040  H).
   intro H. elim (rem_1042  H).
  intros X1. intro H. elim (rem_1032 X1 H).
   intro H. elim (rem_1043  H).
   intro H. elim (rem_1038  H).
Qed.

Remark rem_1046 : forall X1:term, auto___def_46 sym -> auto___def_47 X1 -> auto___def_6 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1.
  cut (auto___def_47 X1 -> auto___def_6 X1). tauto. exact (rem_1045 X1).
Qed.

Remark rem_1047 : auto___def_44 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1048 : auto___def_44 sym -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_1047 H);  intros.
Qed.

Remark rem_1049 : forall X1:term, auto___def_44 sym -> auto___def_45 X1 -> auto___def_6 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_44 sym -> False). tauto.
  exact (rem_1048).
Qed.

Remark rem_1050 : forall X1:term, auto_knows (key sym X1) -> auto___def_6 X1. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_91 sym X1 H);  intros.
  apply (rem_1026 X1);  tauto.
  apply (rem_1046 X1);  tauto.
  apply (rem_1049 X1);  tauto.
Qed.

Remark rem_1051 : (forall X:term, auto_agent X -> auto___type_2 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p__type_2.  tauto.
Defined.

Remark rem_1052 : (forall X:term, auto_agent X -> auto___type_2 X)
    -> auto___type_2 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_2.  case (rem_1051 epsilon_magent_p__type_2). clear  epsilon_magent_p__type_2. intros. apply trans___type_2_i_1;  tauto.
 clear  epsilon_magent_p__type_2. tauto.
Defined.

Remark rem_1053 : auto_agent i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1054 : (forall X:term, auto_agent X -> auto___type_2 X)
    -> auto_agent i -> auto___type_2 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_2. intro H. intros.
  elim (rem_1053 H);  intros.
  apply (rem_1052 epsilon_magent_p__type_2);  tauto.
Defined.

Remark rem_1055 : (forall X:term, auto_agent X -> auto___type_2 X)
    -> auto___type_2 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_2.  case (rem_1051 epsilon_magent_p__type_2). clear  epsilon_magent_p__type_2. intros. apply trans___type_2_bob_1;  tauto.
 clear  epsilon_magent_p__type_2. tauto.
Defined.

Remark rem_1056 : auto_agent bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1057 : (forall X:term, auto_agent X -> auto___type_2 X)
    -> auto_agent bob -> auto___type_2 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_2. intro H. intros.
  elim (rem_1056 H);  intros.
  apply (rem_1055 epsilon_magent_p__type_2);  tauto.
Defined.

Remark rem_1058 : (forall X:term, auto_agent X -> auto___type_2 X)
    -> auto___type_2 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_2.  case (rem_1051 epsilon_magent_p__type_2). clear  epsilon_magent_p__type_2. intros. apply trans___type_2_alice_1;  tauto.
 clear  epsilon_magent_p__type_2. tauto.
Defined.

Remark rem_1059 : auto_agent alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1060 : (forall X:term, auto_agent X -> auto___type_2 X)
    -> auto_agent alice -> auto___type_2 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_2. intro H. intros.
  elim (rem_1059 H);  intros.
  apply (rem_1058 epsilon_magent_p__type_2);  tauto.
Defined.

Remark rem_1061 : (forall X:term, auto_agent X -> auto___type_2 X)
    -> auto___type_2 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_2.  case (rem_1051 epsilon_magent_p__type_2). clear  epsilon_magent_p__type_2. intros. apply trans___type_2_server_1;  tauto.
 clear  epsilon_magent_p__type_2. tauto.
Defined.

Remark rem_1062 : auto_agent server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1063 : (forall X:term, auto_agent X -> auto___type_2 X)
    -> auto_agent server -> auto___type_2 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_2. intro H. intros.
  elim (rem_1062 H);  intros.
  apply (rem_1061 epsilon_magent_p__type_2);  tauto.
Defined.

Remark rem_1064 : forall X1 X2:term, auto_agent (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1065 : forall X1:term, auto_agent (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1066 : auto_agent nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1067 : forall X1 X2 X3:term, auto_agent (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1068 : forall X1 X2 X3:term, auto_agent (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1069 : forall X1 X2:term, auto_agent (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1070 : auto_agent sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1071 : forall X1 X2:term, auto_agent (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1072 : auto_agent prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1073 : forall X1 X2 X3:term, auto_agent (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1074 : auto_agent pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1075 : forall X1 X2:term, auto_agent (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1076 : forall X1:term, auto_agent X1 -> auto___type_2 X1. (* Induct. *)
Proof.
  fix epsilon_magent_p__type_2 1.
  intro X. case X.
  exact (rem_1060 epsilon_magent_p__type_2 ).
  exact (rem_1057 epsilon_magent_p__type_2 ).
  intros X1 X2. intro H. elim (rem_1071 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1064 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1073 X1 X2 X3 H).
  exact (rem_1054 epsilon_magent_p__type_2 ).
  intros X1 X2. intro H. elim (rem_1069 X1 X2 H).
   intro H. elim (rem_1066  H).
  intros X1 X2. intro H. elim (rem_1075 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1068 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1067 X1 X2 X3 H).
   intro H. elim (rem_1072  H).
   intro H. elim (rem_1074  H).
  intros X1. intro H. elim (rem_1065 X1 H).
  exact (rem_1063 epsilon_magent_p__type_2 ).
   intro H. elim (rem_1070  H).
Qed.

Remark rem_1077 : (forall X:term, auto___def_16 X -> auto___type_7 X)
    -> forall X1:term, auto___def_18 X1 -> auto___def_18 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1078 : (forall X:term, auto___def_16 X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_18 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_16_p__type_7. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_18 X1). tauto. exact (rem_1077 epsilon_m__def_16_p__type_7 X1).
Defined.

Remark rem_1079 : (forall X:term, auto___def_16 X -> auto___type_7 X)
    -> forall X2:term, auto___def_19 X2 -> auto___def_19 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1080 : (forall X:term, auto___def_16 X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_19 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_16_p__type_7. intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_19 X2). tauto. exact (rem_1079 epsilon_m__def_16_p__type_7 X2).
Defined.

Remark rem_1081 : (forall X:term, auto___def_16 X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> (auto___def_18 X1 /\ auto___def_19 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_16_p__type_7. intros X1 X2. intros A1 A2.
  cut (auto___def_18 X1). 2:apply (rem_1078 epsilon_m__def_16_p__type_7 X1 X2);  assumption.
  cut (auto___def_19 X2). 2:apply (rem_1080 epsilon_m__def_16_p__type_7 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1082 : (forall X:term, auto___def_16 X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___type_7 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_16_p__type_7. intros X1 X2. intros A1 A2.
  case (rem_1081 epsilon_m__def_16_p__type_7 X1 X2 A1 A2). clear  epsilon_m__def_16_p__type_7 A1 A2. intros. apply trans___type_7_key_1;  tauto.
 clear  epsilon_m__def_16_p__type_7 A1 A2. tauto.
Defined.

Remark rem_1083 : (forall X:term, auto___def_16 X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_16 (key X1 X2) -> auto___type_7 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_16_p__type_7. intros X1 X2. intro H. intros.
  elim (rem_144 X1 X2 H);  intros.
  apply (rem_1082 epsilon_m__def_16_p__type_7 X1 X2);  tauto.
Defined.

Remark rem_1084 : forall X1:term, auto___def_16 X1 -> auto___type_7 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_16_p__type_7 1.
  intro X. case X.
   intro H. elim (rem_154  H).
   intro H. elim (rem_152  H).
  intros X1 X2. intro H. elim (rem_155 X1 X2 H).
  intros X1 X2. intro H. elim (rem_146 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_157 X1 X2 X3 H).
   intro H. elim (rem_149  H).
  intros X1 X2;  exact (rem_1083 epsilon_m__def_16_p__type_7 X1 X2).
   intro H. elim (rem_148  H).
  intros X1 X2. intro H. elim (rem_160 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_151 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_150 X1 X2 X3 H).
   intro H. elim (rem_156  H).
   intro H. elim (rem_158  H).
  intros X1. intro H. elim (rem_147 X1 H).
   intro H. elim (rem_159  H).
   intro H. elim (rem_153  H).
Qed.

Remark rem_1085 : forall X1 X2:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_16 X1 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_16 X1 -> auto___type_7 X1). tauto. exact (rem_1084 X1).
Qed.

Remark rem_1086 : forall X1 X2:term, auto___def_12 X2 -> auto___def_16 X1 -> auto___def_13 X1 -> auto___type_7 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_16 X1 -> auto___type_7 X1). tauto. exact (rem_1085 X1 X2).
Qed.

Remark rem_1087 : forall X1 X2:term, auto___def_16 X1 -> auto___def_22 X2 -> auto___def_23 X1 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_16 X1 -> auto___type_7 X1). tauto. exact (rem_1084 X1).
Qed.

Remark rem_1088 : forall X1 X2:term, auto___def_22 X2 -> auto___def_23 X1 -> auto___def_16 X1 -> auto___type_7 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_16 X1 -> auto___def_22 X2 -> auto___def_23 X1 -> auto___type_7 X1). tauto. exact (rem_1087 X1 X2).
Qed.

Remark rem_1089 : forall X1 X2:term, auto___def_16 X1 -> auto___def_23 X1 -> auto___def_37 X2 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_16 X1 -> auto___type_7 X1). tauto. exact (rem_1084 X1).
Qed.

Remark rem_1090 : forall X1 X2:term, auto___def_37 X2 -> auto___def_23 X1 -> auto___def_16 X1 -> auto___type_7 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_16 X1 -> auto___def_23 X1 -> auto___def_37 X2 -> auto___type_7 X1). tauto. exact (rem_1089 X1 X2).
Qed.

Remark rem_1091 : (forall X:term, auto___def_33 X -> auto___type_7 X)
    -> forall X1:term, auto___def_18 X1 -> auto___def_18 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1092 : (forall X:term, auto___def_33 X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_35 X2 -> auto___def_18 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_33_p__type_7. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_18 X1). tauto. exact (rem_1091 epsilon_m__def_33_p__type_7 X1).
Defined.

Remark rem_1093 : (forall X:term, auto___def_33 X -> auto___type_7 X)
    -> forall X2:term, auto___def_35 X2 -> auto___def_35 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1094 : (forall X:term, auto___def_33 X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_35 X2 -> auto___def_35 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_33_p__type_7. intros X1 X2.
  cut (auto___def_35 X2 -> auto___def_35 X2). tauto. exact (rem_1093 epsilon_m__def_33_p__type_7 X2).
Defined.

Remark rem_1095 : (forall X:term, auto___def_33 X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_35 X2 -> (auto___def_18 X1 /\ auto___def_35 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_33_p__type_7. intros X1 X2. intros A1 A2.
  cut (auto___def_18 X1). 2:apply (rem_1092 epsilon_m__def_33_p__type_7 X1 X2);  assumption.
  cut (auto___def_35 X2). 2:apply (rem_1094 epsilon_m__def_33_p__type_7 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1096 : (forall X:term, auto___def_33 X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_35 X2 -> auto___type_7 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_33_p__type_7. intros X1 X2. intros A1 A2.
  case (rem_1095 epsilon_m__def_33_p__type_7 X1 X2 A1 A2). clear  epsilon_m__def_33_p__type_7 A1 A2. intros. apply trans___type_7_key_2;  tauto.
 clear  epsilon_m__def_33_p__type_7 A1 A2. tauto.
Defined.

Remark rem_1097 : (forall X:term, auto___def_33 X -> auto___type_7 X)
    -> forall X1 X2:term, auto___def_33 (key X1 X2) -> auto___type_7 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_33_p__type_7. intros X1 X2. intro H. intros.
  elim (rem_237 X1 X2 H);  intros.
  apply (rem_1096 epsilon_m__def_33_p__type_7 X1 X2);  tauto.
Defined.

Remark rem_1098 : forall X1:term, auto___def_33 X1 -> auto___type_7 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_33_p__type_7 1.
  intro X. case X.
   intro H. elim (rem_247  H).
   intro H. elim (rem_245  H).
  intros X1 X2. intro H. elim (rem_248 X1 X2 H).
  intros X1 X2. intro H. elim (rem_239 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_250 X1 X2 X3 H).
   intro H. elim (rem_242  H).
  intros X1 X2;  exact (rem_1097 epsilon_m__def_33_p__type_7 X1 X2).
   intro H. elim (rem_241  H).
  intros X1 X2. intro H. elim (rem_253 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_244 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_243 X1 X2 X3 H).
   intro H. elim (rem_249  H).
   intro H. elim (rem_251  H).
  intros X1. intro H. elim (rem_240 X1 H).
   intro H. elim (rem_252  H).
   intro H. elim (rem_246  H).
Qed.

Remark rem_1099 : forall X1 X2:term, auto___def_22 X2 -> auto___def_23 X1 -> auto___def_33 X1 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_33 X1 -> auto___type_7 X1). tauto. exact (rem_1098 X1).
Qed.

Remark rem_1100 : forall X1 X2:term, auto___def_33 X1 -> auto_knows X2 -> auto_knows X1 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_33 X1 -> auto___type_7 X1). tauto. exact (rem_1098 X1).
Qed.

Remark rem_1101 : forall X1 X2:term, auto_knows X2 -> auto_knows X1 -> auto___def_33 X1 -> auto___type_7 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_33 X1 -> auto_knows X2 -> auto_knows X1 -> auto___type_7 X1). tauto. exact (rem_1100 X1 X2).
Qed.

Remark rem_1102 : forall X1 X2:term, auto___def_12 X2 -> auto___def_13 X1 -> auto___def_33 X1 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_33 X1 -> auto___type_7 X1). tauto. exact (rem_1098 X1).
Qed.

Remark rem_1103 : forall X1 X2:term, auto___def_12 X2 -> auto___def_33 X1 -> auto___def_13 X1 -> auto___type_7 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_12 X2 -> auto___def_13 X1 -> auto___def_33 X1 -> auto___type_7 X1). tauto. exact (rem_1102 X1 X2).
Qed.

Remark rem_1104 : forall X1 X2:term, auto___def_16 X1 -> auto_knows X2 -> auto_knows X1 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_16 X1 -> auto___type_7 X1). tauto. exact (rem_1084 X1).
Qed.

Remark rem_1105 : forall X1 X2:term, auto_knows X2 -> auto_knows X1 -> auto___def_16 X1 -> auto___type_7 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_16 X1 -> auto_knows X2 -> auto_knows X1 -> auto___type_7 X1). tauto. exact (rem_1104 X1 X2).
Qed.

Remark rem_1106 : forall X1 X2:term, auto___def_13 X1 -> auto___def_16 X1 -> auto___def_30 X2 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_16 X1 -> auto___type_7 X1). tauto. exact (rem_1084 X1).
Qed.

Remark rem_1107 : forall X1 X2:term, auto___def_30 X2 -> auto___def_16 X1 -> auto___def_13 X1 -> auto___type_7 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_13 X1 -> auto___def_16 X1 -> auto___def_30 X2 -> auto___type_7 X1). tauto. exact (rem_1106 X1 X2).
Qed.

Remark rem_1108 : forall X1 X2:term, auto___def_16 X1 -> auto___def_40 X2 -> auto___type_6 X1 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_16 X1 -> auto___type_7 X1). tauto. exact (rem_1084 X1).
Qed.

Remark rem_1109 : forall X1 X2:term, auto___def_40 X2 -> auto___def_16 X1 -> auto___type_6 X1 -> auto___type_7 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_16 X1 -> auto___def_40 X2 -> auto___type_6 X1 -> auto___type_7 X1). tauto. exact (rem_1108 X1 X2).
Qed.

Remark rem_1110 : forall X1 X2:term, auto___def_16 X1 -> auto___def_42 X2 -> auto___type_7 X1 -> auto___type_7 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_16 X1 -> auto___type_7 X1). tauto. exact (rem_1084 X1).
Qed.

Remark rem_1111 : forall X1 X2:term, auto___def_42 X2 -> auto___type_7 X1 -> auto___def_16 X1 -> auto___type_7 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_16 X1 -> auto___def_42 X2 -> auto___type_7 X1 -> auto___type_7 X1). tauto. exact (rem_1110 X1 X2).
Qed.

Remark rem_1112 : forall X1 X2:term, auto___def_41 X2 X1 -> auto___type_7 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_915 X2 X1 H);  intros.
  apply (rem_1086 X1 X2);  tauto.
  apply (rem_1088 X1 X2);  tauto.
  apply (rem_1090 X1 X2);  tauto.
  apply (rem_1099 X1 X2);  tauto.
  apply (rem_1101 X1 X2);  tauto.
  apply (rem_1103 X1 X2);  tauto.
  apply (rem_1105 X1 X2);  tauto.
  apply (rem_1107 X1 X2);  tauto.
  apply (rem_1109 X1 X2);  tauto.
  apply (rem_1111 X1 X2);  tauto.
Qed.

Remark rem_1113 : forall X1:term, auto___def_9 X1 -> auto___def_9 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1114 : forall X1 X2:term, auto___def_10 X2 -> auto___def_9 X1 -> auto___def_9 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_9 X1 -> auto___def_9 X1). tauto. exact (rem_1113 X1).
Qed.

Remark rem_1115 : forall X2:term, auto___def_10 X2 -> auto___def_10 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1116 : forall X1 X2:term, auto___def_10 X2 -> auto___def_9 X1 -> auto___def_10 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_10 X2 -> auto___def_10 X2). tauto. exact (rem_1115 X2).
Qed.

Remark rem_1117 : forall X1 X2:term, auto___def_10 X2 -> auto___def_9 X1 -> (auto___def_9 X1 /\ auto___def_10 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_9 X1). 2:apply (rem_1114 X1 X2);  assumption.
  cut (auto___def_10 X2). 2:apply (rem_1116 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1118 : forall X1 X2:term, auto___def_10 X2 -> auto___def_9 X1 -> auto___def_8 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1117 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_8_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1119 : forall X1:term, auto___def_18 X1 -> auto___def_18 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1120 : forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_18 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_18 X1). tauto. exact (rem_1119 X1).
Qed.

Remark rem_1121 : forall X2:term, auto___def_19 X2 -> auto___def_19 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1122 : forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_19 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_19 X2). tauto. exact (rem_1121 X2).
Qed.

Remark rem_1123 : forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> (auto___def_18 X1 /\ auto___def_19 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_18 X1). 2:apply (rem_1120 X1 X2);  assumption.
  cut (auto___def_19 X2). 2:apply (rem_1122 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1124 : forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_16 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1123 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_16_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1125 : forall X1 X2:term, auto___def_19 X2 -> auto___def_18 X1 -> auto___def_16 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_19 X2 -> auto___def_16 (key X1 X2)). tauto. exact (rem_1124 X1 X2).
Qed.

Remark rem_1126 : forall X1:term, auto___type_3 X1 -> auto___type_3 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1127 : forall X1 X2:term, auto___def_14 X2 -> auto___type_3 X1 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_3 X1 -> auto___type_3 X1). tauto. exact (rem_1126 X1).
Qed.

Remark rem_1128 : forall X2:term, auto___def_14 X2 -> auto___def_14 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1129 : forall X1 X2:term, auto___def_14 X2 -> auto___type_3 X1 -> auto___def_14 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_14 X2 -> auto___def_14 X2). tauto. exact (rem_1128 X2).
Qed.

Remark rem_1130 : forall X1 X2:term, auto___def_14 X2 -> auto___type_3 X1 -> (auto___type_3 X1 /\ auto___def_14 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_3 X1). 2:apply (rem_1127 X1 X2);  assumption.
  cut (auto___def_14 X2). 2:apply (rem_1129 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1131 : forall X1 X2:term, auto___def_14 X2 -> auto___type_3 X1 -> auto___def_12 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1130 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_12_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1132 : forall X1:term, auto___def_42 X1 -> auto___def_42 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1133 : forall X1 X2:term, auto___def_18 sym -> auto___def_19 X2 -> auto___def_42 X1 -> auto___def_42 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_42 X1 -> auto___def_42 X1). tauto. exact (rem_1132 X1).
Qed.

Remark rem_1134 : forall X1 X2:term, auto___def_18 sym -> auto___def_19 X2 -> auto___def_42 X1 -> auto___def_19 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_19 X2). tauto. exact (rem_1121 X2).
Qed.

Remark rem_1135 : forall X1 X2:term, auto___def_18 sym -> auto___def_19 X2 -> auto___def_42 X1 -> (auto___def_42 X1 /\ auto___def_19 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_42 X1). 2:apply (rem_1133 X1 X2);  assumption.
  cut (auto___def_19 X2). 2:apply (rem_1134 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1136 : forall X1 X2:term, auto___def_18 sym -> auto___def_19 X2 -> auto___def_42 X1 -> auto___def_5 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1135 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_5_6;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1137 : forall X1 X2:term, auto___def_18 sym -> auto___def_35 X2 -> auto___def_42 X1 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_42 X1 -> auto_knows X1). tauto. exact (rem_910 X1).
Qed.

Remark rem_1138 : forall X1 X2:term, auto___def_18 sym -> auto___def_35 X2 -> auto___def_42 X1 -> auto___def_47 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_35 X2 -> auto___def_47 X2). tauto. exact (rem_232 X2).
Qed.

Remark rem_1139 : forall X1 X2:term, auto___def_18 sym -> auto___def_35 X2 -> auto___def_42 X1 -> (auto_knows X1 /\ auto___def_47 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto_knows X1). 2:apply (rem_1137 X1 X2);  assumption.
  cut (auto___def_47 X2). 2:apply (rem_1138 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1140 : forall X1 X2:term, auto___def_18 sym -> auto___def_35 X2 -> auto___def_42 X1 -> auto___def_5 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1139 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_5_4;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1141 : forall X1 X2:term, auto___type_7 (key X1 X2) -> or_2
    (auto___def_18 X1 /\ auto___def_19 X2)
    (auto___def_18 X1 /\ auto___def_35 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_1142 : forall X1 X2:term, auto___def_42 X1 -> auto___type_7 (key sym X2) -> auto___def_5 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_1141 sym X2 H);  intros.
  apply (rem_1136 X1 X2);  tauto.
  apply (rem_1140 X1 X2);  tauto.
Qed.

Remark rem_1143 : forall X1:term, auto___def_12 X1 -> auto___def_12 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1144 : forall X1 X2:term, auto___def_12 X1 -> auto___def_18 sym -> auto___def_29 X2 -> auto___def_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_12 X1). tauto. exact (rem_1143 X1).
Qed.

Remark rem_1145 : forall X2:term, auto___def_29 X2 -> auto___def_29 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1146 : forall X1 X2:term, auto___def_12 X1 -> auto___def_18 sym -> auto___def_29 X2 -> auto___def_29 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_29 X2 -> auto___def_29 X2). tauto. exact (rem_1145 X2).
Qed.

Remark rem_1147 : forall X1 X2:term, auto___def_12 X1 -> auto___def_18 sym -> auto___def_29 X2 -> (auto___def_12 X1 /\ auto___def_29 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_12 X1). 2:apply (rem_1144 X1 X2);  assumption.
  cut (auto___def_29 X2). 2:apply (rem_1146 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1148 : forall X1 X2:term, auto___def_12 X1 -> auto___def_18 sym -> auto___def_29 X2 -> auto___def_5 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1147 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_5_3;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1149 : forall X1 X2:term, auto___def_18 sym -> auto___def_29 X2 -> auto___def_12 X1 -> auto___def_5 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_18 sym -> auto___def_29 X2 -> auto___def_5 X1 X2). tauto. exact (rem_1148 X1 X2).
Qed.

Remark rem_1150 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 (key sym X2) -> auto___def_5 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_142 sym X2 H);  intros.
  apply (rem_1149 X1 X2);  tauto.
Qed.

Remark rem_1151 : forall X1:term, auto___def_22 X1 -> auto___def_22 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1152 : forall X1 X2:term, auto___def_18 sym -> auto___def_22 X1 -> auto___def_25 X2 -> auto___def_22 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_22 X1 -> auto___def_22 X1). tauto. exact (rem_1151 X1).
Qed.

Remark rem_1153 : forall X2:term, auto___def_25 X2 -> auto___def_25 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1154 : forall X1 X2:term, auto___def_18 sym -> auto___def_22 X1 -> auto___def_25 X2 -> auto___def_25 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_25 X2 -> auto___def_25 X2). tauto. exact (rem_1153 X2).
Qed.

Remark rem_1155 : forall X1 X2:term, auto___def_18 sym -> auto___def_22 X1 -> auto___def_25 X2 -> (auto___def_22 X1 /\ auto___def_25 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_22 X1). 2:apply (rem_1152 X1 X2);  assumption.
  cut (auto___def_25 X2). 2:apply (rem_1154 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1156 : forall X1 X2:term, auto___def_18 sym -> auto___def_22 X1 -> auto___def_25 X2 -> auto___def_5 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1155 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_5_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1157 : forall X1 X2:term, auto___def_18 sym -> auto___def_25 X2 -> auto___def_22 X1 -> auto___def_5 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_18 sym -> auto___def_22 X1 -> auto___def_25 X2 -> auto___def_5 X1 X2). tauto. exact (rem_1156 X1 X2).
Qed.

Remark rem_1158 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 (key sym X2) -> auto___def_5 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_171 sym X2 H);  intros.
  apply (rem_1157 X1 X2);  tauto.
Qed.

Remark rem_1159 : forall X1:term, auto___def_37 X1 -> auto___def_37 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1160 : forall X1 X2:term, auto___def_18 sym -> auto___def_25 X2 -> auto___def_37 X1 -> auto___def_37 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_37 X1 -> auto___def_37 X1). tauto. exact (rem_1159 X1).
Qed.

Remark rem_1161 : forall X1 X2:term, auto___def_18 sym -> auto___def_25 X2 -> auto___def_37 X1 -> auto___def_25 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_25 X2 -> auto___def_25 X2). tauto. exact (rem_1153 X2).
Qed.

Remark rem_1162 : forall X1 X2:term, auto___def_18 sym -> auto___def_25 X2 -> auto___def_37 X1 -> (auto___def_37 X1 /\ auto___def_25 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_37 X1). 2:apply (rem_1160 X1 X2);  assumption.
  cut (auto___def_25 X2). 2:apply (rem_1161 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1163 : forall X1 X2:term, auto___def_18 sym -> auto___def_25 X2 -> auto___def_37 X1 -> auto___def_5 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1162 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_5_2;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1164 : forall X1 X2:term, auto___def_23 (key sym X2) -> auto___def_37 X1 -> auto___def_5 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_171 sym X2 H);  intros.
  apply (rem_1163 X1 X2);  tauto.
Qed.

Remark rem_1165 : forall X1 X2:term, auto___def_37 X1 -> auto___def_23 (key sym X2) -> auto___def_5 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_23 (key sym X2) -> auto___def_37 X1 -> auto___def_5 X1 X2). tauto. exact (rem_1164 X1 X2).
Qed.

Remark rem_1166 : forall X1 X2:term, auto___def_43 sym -> auto_knows X1 -> auto___def_5 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_43 sym -> False). tauto.
  exact (rem_979).
Qed.

Remark rem_1167 : forall X1 X2:term, auto___def_43 sym -> auto___type_8 X2 -> auto_knows X1 -> auto___def_5 X1 X2. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2. intros. apply (rem_1166 X1 X2);  assumption.
Qed.

Remark rem_1168 : forall X1 X2:term, auto___def_46 sym -> auto___def_47 X2 -> auto_knows X1 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows X1 -> auto_knows X1). tauto. exact (rem_466 X1).
Qed.

Remark rem_1169 : forall X2:term, auto___def_47 X2 -> auto___def_47 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1170 : forall X1 X2:term, auto___def_46 sym -> auto___def_47 X2 -> auto_knows X1 -> auto___def_47 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_47 X2 -> auto___def_47 X2). tauto. exact (rem_1169 X2).
Qed.

Remark rem_1171 : forall X1 X2:term, auto___def_46 sym -> auto___def_47 X2 -> auto_knows X1 -> (auto_knows X1 /\ auto___def_47 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto_knows X1). 2:apply (rem_1168 X1 X2);  assumption.
  cut (auto___def_47 X2). 2:apply (rem_1170 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1172 : forall X1 X2:term, auto___def_46 sym -> auto___def_47 X2 -> auto_knows X1 -> auto___def_5 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1171 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_5_4;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1173 : forall X1 X2:term, auto___def_44 sym -> auto___def_45 X2 -> auto_knows X1 -> auto___def_5 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_44 sym -> False). tauto.
  exact (rem_1048).
Qed.

Remark rem_1174 : forall X1 X2:term, auto_knows X1 -> auto_knows (key sym X2) -> auto___def_5 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_91 sym X2 H);  intros.
  apply (rem_1167 X1 X2);  tauto.
  apply (rem_1172 X1 X2);  tauto.
  apply (rem_1173 X1 X2);  tauto.
Qed.

Remark rem_1175 : forall X1:term, auto___def_40 X1 -> auto___def_40 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1176 : forall X1 X2:term, auto___def_18 sym -> auto___def_19 X2 -> auto___def_40 X1 -> auto___def_40 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_40 X1 -> auto___def_40 X1). tauto. exact (rem_1175 X1).
Qed.

Remark rem_1177 : forall X1 X2:term, auto___def_18 sym -> auto___def_19 X2 -> auto___def_40 X1 -> auto___def_19 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_19 X2). tauto. exact (rem_1121 X2).
Qed.

Remark rem_1178 : forall X1 X2:term, auto___def_18 sym -> auto___def_19 X2 -> auto___def_40 X1 -> (auto___def_40 X1 /\ auto___def_19 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_40 X1). 2:apply (rem_1176 X1 X2);  assumption.
  cut (auto___def_19 X2). 2:apply (rem_1177 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1179 : forall X1 X2:term, auto___def_18 sym -> auto___def_19 X2 -> auto___def_40 X1 -> auto___def_5 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1178 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_5_7;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1180 : forall X1 X2:term, auto___def_18 sym -> auto___def_35 X2 -> auto___def_40 X1 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_40 X1 -> auto_knows X1). tauto. exact (rem_885 X1).
Qed.

Remark rem_1181 : forall X1 X2:term, auto___def_18 sym -> auto___def_35 X2 -> auto___def_40 X1 -> auto___def_47 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_35 X2 -> auto___def_47 X2). tauto. exact (rem_232 X2).
Qed.

Remark rem_1182 : forall X1 X2:term, auto___def_18 sym -> auto___def_35 X2 -> auto___def_40 X1 -> (auto_knows X1 /\ auto___def_47 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto_knows X1). 2:apply (rem_1180 X1 X2);  assumption.
  cut (auto___def_47 X2). 2:apply (rem_1181 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1183 : forall X1 X2:term, auto___def_18 sym -> auto___def_35 X2 -> auto___def_40 X1 -> auto___def_5 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1182 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_5_4;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1184 : forall X1 X2:term, auto___type_6 (key X1 X2) -> or_2
    (auto___def_18 X1 /\ auto___def_19 X2)
    (auto___def_18 X1 /\ auto___def_35 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_1185 : forall X1 X2:term, auto___def_40 X1 -> auto___type_6 (key sym X2) -> auto___def_5 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_1184 sym X2 H);  intros.
  apply (rem_1179 X1 X2);  tauto.
  apply (rem_1183 X1 X2);  tauto.
Qed.

Remark rem_1186 : forall X1:term, auto___def_30 X1 -> auto___def_30 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1187 : forall X1 X2:term, auto___def_18 sym -> auto___def_29 X2 -> auto___def_30 X1 -> auto___def_30 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_30 X1 -> auto___def_30 X1). tauto. exact (rem_1186 X1).
Qed.

Remark rem_1188 : forall X1 X2:term, auto___def_18 sym -> auto___def_29 X2 -> auto___def_30 X1 -> auto___def_29 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_29 X2 -> auto___def_29 X2). tauto. exact (rem_1145 X2).
Qed.

Remark rem_1189 : forall X1 X2:term, auto___def_18 sym -> auto___def_29 X2 -> auto___def_30 X1 -> (auto___def_30 X1 /\ auto___def_29 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_30 X1). 2:apply (rem_1187 X1 X2);  assumption.
  cut (auto___def_29 X2). 2:apply (rem_1188 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1190 : forall X1 X2:term, auto___def_18 sym -> auto___def_29 X2 -> auto___def_30 X1 -> auto___def_5 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1189 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_5_5;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1191 : forall X1 X2:term, auto___def_13 (key sym X2) -> auto___def_30 X1 -> auto___def_5 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_142 sym X2 H);  intros.
  apply (rem_1190 X1 X2);  tauto.
Qed.

Remark rem_1192 : forall X1 X2:term, auto___def_30 X1 -> auto___def_13 (key sym X2) -> auto___def_5 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_13 (key sym X2) -> auto___def_30 X1 -> auto___def_5 X1 X2). tauto. exact (rem_1191 X1 X2).
Qed.

Remark rem_1193 : forall X1 X2:term, auto_knows (crypt X1 (key sym X2)) -> auto___def_5 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_41 X1 (key sym X2) H);  intros.
  apply (rem_1142 X1 X2);  tauto.
  apply (rem_1150 X1 X2);  tauto.
  apply (rem_1158 X1 X2);  tauto.
  apply (rem_1165 X1 X2);  tauto.
  apply (rem_1174 X1 X2);  tauto.
  apply (rem_1185 X1 X2);  tauto.
  apply (rem_1192 X1 X2);  tauto.
Qed.

Remark rem_1194 : forall X1 X2:term, auto___def_26 X2 -> auto___type_5 X1 -> auto___type_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_5 X1 -> auto___type_5 X1). tauto. exact (rem_917 X1).
Qed.

Remark rem_1195 : forall X2:term, auto___def_26 X2 -> auto___def_26 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1196 : forall X1 X2:term, auto___def_26 X2 -> auto___type_5 X1 -> auto___def_26 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_26 X2 -> auto___def_26 X2). tauto. exact (rem_1195 X2).
Qed.

Remark rem_1197 : forall X1 X2:term, auto___def_26 X2 -> auto___type_5 X1 -> (auto___type_5 X1 /\ auto___def_26 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_5 X1). 2:apply (rem_1194 X1 X2);  assumption.
  cut (auto___def_26 X2). 2:apply (rem_1196 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1198 : forall X1 X2:term, auto___def_26 X2 -> auto___type_5 X1 -> auto___def_29 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1197 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_29_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1199 : forall X1 X2 X3:term, auto_knows X2 -> auto_knows X1 -> auto_knows X3 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows X1 -> auto_knows X1). tauto. exact (rem_466 X1).
Qed.

Remark rem_1200 : forall X2:term, auto_knows X2 -> auto_knows X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1201 : forall X1 X2 X3:term, auto_knows X2 -> auto_knows X1 -> auto_knows X3 -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows X2 -> auto_knows X2). tauto. exact (rem_1200 X2).
Qed.

Remark rem_1202 : forall X3:term, auto_knows X3 -> auto_knows X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1203 : forall X1 X2 X3:term, auto_knows X2 -> auto_knows X1 -> auto_knows X3 -> auto_knows X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows X3 -> auto_knows X3). tauto. exact (rem_1202 X3).
Qed.

Remark rem_1204 : forall X1 X2 X3:term, auto_knows X2 -> auto_knows X1 -> auto_knows X3 -> (auto_knows X1 /\ auto_knows X2 /\ auto_knows X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  cut (auto_knows X1). 2:apply (rem_1199 X1 X2 X3);  assumption.
  cut (auto_knows X2). 2:apply (rem_1201 X1 X2 X3);  assumption.
  cut (auto_knows X3). 2:apply (rem_1203 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_1205 : forall X1 X2 X3:term, auto_knows X2 -> auto_knows X1 -> auto_knows X3 -> auto___def_35 (old_session X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  case (rem_1204 X1 X2 X3 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_35_old_session_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1206 : forall X1 X2 X3:term, auto_knows X1 -> auto_knows X2 -> auto_knows X3 -> auto___def_35 (old_session X1 X2 X3). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_knows X2 -> auto_knows X1 -> auto_knows X3 -> auto___def_35 (old_session X1 X2 X3)). tauto. exact (rem_1205 X1 X2 X3).
Qed.

Remark rem_1207 : forall X1 X2 X3:term, auto___def_11 X1 X2 X3 -> auto___def_35 (old_session X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_118 X1 X2 X3 H);  intros.
  apply (rem_1206 X1 X2 X3);  tauto.
Qed.

Remark rem_1208 : forall X1 X2 X3:term, auto_knows X2 -> auto_knows X1 -> auto_knows X3 -> auto_knows nil -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows X1 -> auto_knows X1). tauto. exact (rem_466 X1).
Qed.

Remark rem_1209 : forall X1 X2 X3:term, auto_knows X2 -> auto_knows X1 -> auto_knows X3 -> auto_knows nil -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows X2 -> auto_knows X2). tauto. exact (rem_1200 X2).
Qed.

Remark rem_1210 : forall X1 X2 X3:term, auto_knows X2 -> auto_knows X1 -> auto_knows X3 -> auto_knows nil -> auto_knows X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows X3 -> auto_knows X3). tauto. exact (rem_1202 X3).
Qed.

Remark rem_1211 : forall X1 X2 X3:term, auto_knows X2 -> auto_knows X1 -> auto_knows X3 -> auto_knows nil -> (auto_knows X1 /\ auto_knows X2 /\ auto_knows X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  cut (auto_knows X1). 2:apply (rem_1208 X1 X2 X3);  assumption.
  cut (auto_knows X2). 2:apply (rem_1209 X1 X2 X3);  assumption.
  cut (auto_knows X3). 2:apply (rem_1210 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_1212 : forall X1 X2 X3:term, auto_knows X2 -> auto_knows X1 -> auto_knows X3 -> auto_knows nil -> auto___def_11 X1 X2 X3. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  case (rem_1211 X1 X2 X3 A1 A2 A3 A4). clear  A1 A2 A3 A4. intros. apply trans___def_11_1;  tauto.
 clear  A1 A2 A3 A4. tauto.
Qed.

Remark rem_1213 : forall X1 X2 X3:term, auto_knows X3 -> auto_knows nil -> auto_knows X2 -> auto_knows X1 -> auto___def_11 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_knows X2 -> auto_knows X1 -> auto_knows X3 -> auto_knows nil -> auto___def_11 X1 X2 X3). tauto. exact (rem_1212 X1 X2 X3).
Qed.

Remark rem_1214 : forall X1 X2 X3:term, auto_knows X2 -> auto_knows X1 -> auto_knows (cons X3 nil) -> auto___def_11 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1 H2. intro H. intros.
  elim (rem_97 X3 nil H);  intros.
  apply (rem_1213 X1 X2 X3);  tauto.
Qed.

Remark rem_1215 : forall X1 X2 X3:term, auto_knows X2 -> auto_knows (cons X3 nil) -> auto_knows X1 -> auto___def_11 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_knows X2 -> auto_knows X1 -> auto_knows (cons X3 nil) -> auto___def_11 X1 X2 X3). tauto. exact (rem_1214 X1 X2 X3).
Qed.

Remark rem_1216 : forall X1 X2 X3:term, auto_knows X1 -> auto_knows (cons X2 (cons X3 nil)) -> auto___def_11 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_97 X2 (cons X3 nil) H);  intros.
  apply (rem_1215 X1 X2 X3);  tauto.
Qed.

Remark rem_1217 : forall X1 X2 X3:term, auto_knows (cons X1 (cons X2 (cons X3 nil))) -> auto___def_11 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_97 X1 (cons X2 (cons X3 nil)) H);  intros.
  apply (rem_1216 X1 X2 X3);  tauto.
Qed.

Remark rem_1218 : forall X1 X2:term, auto_agent X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_931 X1).
Qed.

Remark rem_1219 : forall X1 X2:term, auto_agent X2 -> auto_agent X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_935 X2).
Qed.

Remark rem_1220 : forall X1 X2:term, auto_agent X2 -> auto_agent X1 -> (auto_agent X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto_agent X1). 2:apply (rem_1218 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_1219 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1221 : forall X1 X2:term, auto_agent X2 -> auto_agent X1 -> auto___def_9 (noncea X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1220 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_9_noncea_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1222 : forall X1:term, auto___def_27 X1 -> auto___def_27 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1223 : forall X1 X2:term, auto___def_27 X1 -> auto___def_28 X2 -> auto___def_27 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_27 X1 -> auto___def_27 X1). tauto. exact (rem_1222 X1).
Qed.

Remark rem_1224 : forall X2:term, auto___def_28 X2 -> auto___def_28 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1225 : forall X1 X2:term, auto___def_27 X1 -> auto___def_28 X2 -> auto___def_28 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_28 X2 -> auto___def_28 X2). tauto. exact (rem_1224 X2).
Qed.

Remark rem_1226 : forall X1 X2:term, auto___def_27 X1 -> auto___def_28 X2 -> (auto___def_27 X1 /\ auto___def_28 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_27 X1). 2:apply (rem_1223 X1 X2);  assumption.
  cut (auto___def_28 X2). 2:apply (rem_1225 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1227 : forall X1 X2:term, auto___def_27 X1 -> auto___def_28 X2 -> auto___def_26 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1226 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_26_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1228 : forall X1 X2:term, auto___def_28 X2 -> auto___def_27 X1 -> auto___def_26 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_27 X1 -> auto___def_28 X2 -> auto___def_26 (cons X1 X2)). tauto. exact (rem_1227 X1 X2).
Qed.

Remark rem_1229 : forall X1:term, auto___type_2 X1 -> auto___type_2 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1230 : forall X1 X2:term, auto___def_8 X2 -> auto___type_2 X1 -> auto___type_2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_2 X1 -> auto___type_2 X1). tauto. exact (rem_1229 X1).
Qed.

Remark rem_1231 : forall X2:term, auto___def_8 X2 -> auto___def_8 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1232 : forall X1 X2:term, auto___def_8 X2 -> auto___type_2 X1 -> auto___def_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_8 X2 -> auto___def_8 X2). tauto. exact (rem_1231 X2).
Qed.

Remark rem_1233 : forall X1 X2:term, auto___def_8 X2 -> auto___type_2 X1 -> (auto___type_2 X1 /\ auto___def_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_2 X1). 2:apply (rem_1230 X1 X2);  assumption.
  cut (auto___def_8 X2). 2:apply (rem_1232 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1234 : forall X1 X2:term, auto___def_8 X2 -> auto___type_2 X1 -> auto___def_7 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1233 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_7_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1235 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p__type_1.  tauto.
Defined.

Remark rem_1236 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto___type_1 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_1.  case (rem_1235 epsilon_magent_p__type_1). clear  epsilon_magent_p__type_1. intros. apply trans___type_1_i_1;  tauto.
 clear  epsilon_magent_p__type_1. tauto.
Defined.

Remark rem_1237 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto_agent i -> auto___type_1 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_1. intro H. intros.
  elim (rem_1053 H);  intros.
  apply (rem_1236 epsilon_magent_p__type_1);  tauto.
Defined.

Remark rem_1238 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto___type_1 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_1.  case (rem_1235 epsilon_magent_p__type_1). clear  epsilon_magent_p__type_1. intros. apply trans___type_1_bob_1;  tauto.
 clear  epsilon_magent_p__type_1. tauto.
Defined.

Remark rem_1239 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto_agent bob -> auto___type_1 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_1. intro H. intros.
  elim (rem_1056 H);  intros.
  apply (rem_1238 epsilon_magent_p__type_1);  tauto.
Defined.

Remark rem_1240 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto___type_1 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_1.  case (rem_1235 epsilon_magent_p__type_1). clear  epsilon_magent_p__type_1. intros. apply trans___type_1_alice_1;  tauto.
 clear  epsilon_magent_p__type_1. tauto.
Defined.

Remark rem_1241 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto_agent alice -> auto___type_1 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_1. intro H. intros.
  elim (rem_1059 H);  intros.
  apply (rem_1240 epsilon_magent_p__type_1);  tauto.
Defined.

Remark rem_1242 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto___type_1 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_1.  case (rem_1235 epsilon_magent_p__type_1). clear  epsilon_magent_p__type_1. intros. apply trans___type_1_server_1;  tauto.
 clear  epsilon_magent_p__type_1. tauto.
Defined.

Remark rem_1243 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto_agent server -> auto___type_1 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_1. intro H. intros.
  elim (rem_1062 H);  intros.
  apply (rem_1242 epsilon_magent_p__type_1);  tauto.
Defined.

Remark rem_1244 : forall X1:term, auto_agent X1 -> auto___type_1 X1. (* Induct. *)
Proof.
  fix epsilon_magent_p__type_1 1.
  intro X. case X.
  exact (rem_1241 epsilon_magent_p__type_1 ).
  exact (rem_1239 epsilon_magent_p__type_1 ).
  intros X1 X2. intro H. elim (rem_1071 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1064 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1073 X1 X2 X3 H).
  exact (rem_1237 epsilon_magent_p__type_1 ).
  intros X1 X2. intro H. elim (rem_1069 X1 X2 H).
   intro H. elim (rem_1066  H).
  intros X1 X2. intro H. elim (rem_1075 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1068 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1067 X1 X2 X3 H).
   intro H. elim (rem_1072  H).
   intro H. elim (rem_1074  H).
  intros X1. intro H. elim (rem_1065 X1 H).
  exact (rem_1243 epsilon_magent_p__type_1 ).
   intro H. elim (rem_1070  H).
Qed.

Remark rem_1245 : forall X1:term, auto___type_4 X1 -> auto___type_4 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1246 : forall X1 X2:term, auto___def_26 X2 -> auto___type_4 X1 -> auto___type_4 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_4 X1 -> auto___type_4 X1). tauto. exact (rem_1245 X1).
Qed.

Remark rem_1247 : forall X1 X2:term, auto___def_26 X2 -> auto___type_4 X1 -> auto___def_26 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_26 X2 -> auto___def_26 X2). tauto. exact (rem_1195 X2).
Qed.

Remark rem_1248 : forall X1 X2:term, auto___def_26 X2 -> auto___type_4 X1 -> (auto___type_4 X1 /\ auto___def_26 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_4 X1). 2:apply (rem_1246 X1 X2);  assumption.
  cut (auto___def_26 X2). 2:apply (rem_1247 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1249 : forall X1 X2:term, auto___def_26 X2 -> auto___type_4 X1 -> auto___def_25 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1248 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_25_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1250 : forall X1:term, auto___def_16 X1 -> auto___def_16 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1251 : forall X1 X2:term, auto___def_16 X1 -> auto___def_17 X2 -> auto___def_16 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_16 X1 -> auto___def_16 X1). tauto. exact (rem_1250 X1).
Qed.

Remark rem_1252 : forall X2:term, auto___def_17 X2 -> auto___def_17 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1253 : forall X1 X2:term, auto___def_16 X1 -> auto___def_17 X2 -> auto___def_17 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_17 X2 -> auto___def_17 X2). tauto. exact (rem_1252 X2).
Qed.

Remark rem_1254 : forall X1 X2:term, auto___def_16 X1 -> auto___def_17 X2 -> (auto___def_16 X1 /\ auto___def_17 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_16 X1). 2:apply (rem_1251 X1 X2);  assumption.
  cut (auto___def_17 X2). 2:apply (rem_1253 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1255 : forall X1 X2:term, auto___def_16 X1 -> auto___def_17 X2 -> auto___def_15 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1254 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_15_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1256 : forall X1 X2:term, auto___def_17 X2 -> auto___def_16 X1 -> auto___def_15 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_16 X1 -> auto___def_17 X2 -> auto___def_15 (cons X1 X2)). tauto. exact (rem_1255 X1 X2).
Qed.

Remark rem_1257 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1:term, auto___def_42 X1 -> auto___def_42 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1258 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto___def_42 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2.
  cut (auto___def_42 X1 -> auto___def_42 X1). tauto. exact (rem_1257 epsilon_mknows_p__type_3 X1).
Defined.

Remark rem_1259 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X2:term, auto___type_7 X2 -> auto___type_7 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1260 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto___type_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2.
  cut (auto___type_7 X2 -> auto___type_7 X2). tauto. exact (rem_1259 epsilon_mknows_p__type_3 X2).
Defined.

Remark rem_1261 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> (auto___def_42 X1 /\ auto___type_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_42 X1). 2:apply (rem_1258 epsilon_mknows_p__type_3 X1 X2);  assumption.
  cut (auto___type_7 X2). 2:apply (rem_1260 epsilon_mknows_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1262 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto___type_3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_1261 epsilon_mknows_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_p__type_3 A1 A2. intros. apply trans___type_3_crypt_1;  tauto.
 clear  epsilon_mknows_p__type_3 A1 A2. tauto.
Defined.

Remark rem_1263 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1:term, auto___def_12 X1 -> auto___def_12 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1264 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_12 X1). tauto. exact (rem_1263 epsilon_mknows_p__type_3 X1).
Defined.

Remark rem_1265 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X2:term, auto___def_13 X2 -> auto___def_13 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1266 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_1265 epsilon_mknows_p__type_3 X2).
Defined.

Remark rem_1267 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> (auto___def_12 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_12 X1). 2:apply (rem_1264 epsilon_mknows_p__type_3 X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_1266 epsilon_mknows_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1268 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___type_3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_1267 epsilon_mknows_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_p__type_3 A1 A2. intros. apply trans___type_3_crypt_2;  tauto.
 clear  epsilon_mknows_p__type_3 A1 A2. tauto.
Defined.

Remark rem_1269 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1:term, auto___def_22 X1 -> auto___def_22 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1270 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_22 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2.
  cut (auto___def_22 X1 -> auto___def_22 X1). tauto. exact (rem_1269 epsilon_mknows_p__type_3 X1).
Defined.

Remark rem_1271 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X2:term, auto___def_23 X2 -> auto___def_23 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1272 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_1271 epsilon_mknows_p__type_3 X2).
Defined.

Remark rem_1273 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> (auto___def_22 X1 /\ auto___def_23 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_22 X1). 2:apply (rem_1270 epsilon_mknows_p__type_3 X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_1272 epsilon_mknows_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1274 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___type_3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_1273 epsilon_mknows_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_p__type_3 A1 A2. intros. apply trans___type_3_crypt_3;  tauto.
 clear  epsilon_mknows_p__type_3 A1 A2. tauto.
Defined.

Remark rem_1275 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1:term, auto___def_37 X1 -> auto___def_37 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1276 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto___def_37 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2.
  cut (auto___def_37 X1 -> auto___def_37 X1). tauto. exact (rem_1275 epsilon_mknows_p__type_3 X1).
Defined.

Remark rem_1277 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_1271 epsilon_mknows_p__type_3 X2).
Defined.

Remark rem_1278 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> (auto___def_37 X1 /\ auto___def_23 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_37 X1). 2:apply (rem_1276 epsilon_mknows_p__type_3 X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_1277 epsilon_mknows_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1279 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto___type_3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_1278 epsilon_mknows_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_p__type_3 A1 A2. intros. apply trans___type_3_crypt_4;  tauto.
 clear  epsilon_mknows_p__type_3 A1 A2. tauto.
Defined.

Remark rem_1280 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1:term, auto_knows X1 -> auto_knows X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1281 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2.
  cut (auto_knows X1 -> auto_knows X1). tauto. exact (rem_1280 epsilon_mknows_p__type_3 X1).
Defined.

Remark rem_1282 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X2:term, auto_knows X2 -> auto_knows X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1283 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2.
  cut (auto_knows X2 -> auto_knows X2). tauto. exact (rem_1282 epsilon_mknows_p__type_3 X2).
Defined.

Remark rem_1284 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> (auto_knows X1 /\ auto_knows X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto_knows X1). 2:apply (rem_1281 epsilon_mknows_p__type_3 X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_1283 epsilon_mknows_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1285 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto___type_3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_1284 epsilon_mknows_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_p__type_3 A1 A2. intros. apply trans___type_3_crypt_5;  tauto.
 clear  epsilon_mknows_p__type_3 A1 A2. tauto.
Defined.

Remark rem_1286 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1:term, auto___def_40 X1 -> auto___def_40 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1287 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> auto___def_40 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2.
  cut (auto___def_40 X1 -> auto___def_40 X1). tauto. exact (rem_1286 epsilon_mknows_p__type_3 X1).
Defined.

Remark rem_1288 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X2:term, auto___type_6 X2 -> auto___type_6 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1289 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> auto___type_6 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2.
  cut (auto___type_6 X2 -> auto___type_6 X2). tauto. exact (rem_1288 epsilon_mknows_p__type_3 X2).
Defined.

Remark rem_1290 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> (auto___def_40 X1 /\ auto___type_6 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_40 X1). 2:apply (rem_1287 epsilon_mknows_p__type_3 X1 X2);  assumption.
  cut (auto___type_6 X2). 2:apply (rem_1289 epsilon_mknows_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1291 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> auto___type_3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_1290 epsilon_mknows_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_p__type_3 A1 A2. intros. apply trans___type_3_crypt_6;  tauto.
 clear  epsilon_mknows_p__type_3 A1 A2. tauto.
Defined.

Remark rem_1292 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1:term, auto___def_30 X1 -> auto___def_30 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1293 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> auto___def_30 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2.
  cut (auto___def_30 X1 -> auto___def_30 X1). tauto. exact (rem_1292 epsilon_mknows_p__type_3 X1).
Defined.

Remark rem_1294 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_1265 epsilon_mknows_p__type_3 X2).
Defined.

Remark rem_1295 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> (auto___def_30 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_30 X1). 2:apply (rem_1293 epsilon_mknows_p__type_3 X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_1294 epsilon_mknows_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1296 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> auto___type_3 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_1295 epsilon_mknows_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_p__type_3 A1 A2. intros. apply trans___type_3_crypt_7;  tauto.
 clear  epsilon_mknows_p__type_3 A1 A2. tauto.
Defined.

Remark rem_1297 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows (crypt X1 X2) -> auto___type_3 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2. intro H. intros.
  elim (rem_41 X1 X2 H);  intros.
  apply (rem_1262 epsilon_mknows_p__type_3 X1 X2);  tauto.
  apply (rem_1268 epsilon_mknows_p__type_3 X1 X2);  tauto.
  apply (rem_1274 epsilon_mknows_p__type_3 X1 X2);  tauto.
  apply (rem_1279 epsilon_mknows_p__type_3 X1 X2);  tauto.
  apply (rem_1285 epsilon_mknows_p__type_3 X1 X2);  tauto.
  apply (rem_1291 epsilon_mknows_p__type_3 X1 X2);  tauto.
  apply (rem_1296 epsilon_mknows_p__type_3 X1 X2);  tauto.
Defined.

Remark rem_1298 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1:term, auto_knows X1 -> auto_knows X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1. intros A1.
  cut (auto_knows X1). 2:apply (rem_1280 epsilon_mknows_p__type_3 X1);  assumption.
  tauto.
Defined.

Remark rem_1299 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1:term, auto_knows X1 -> auto___type_3 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1. intros A1.
  case (rem_1298 epsilon_mknows_p__type_3 X1 A1). clear  epsilon_mknows_p__type_3 A1. intros. apply trans___type_3_s_1;  tauto.
 clear  epsilon_mknows_p__type_3 A1. tauto.
Defined.

Remark rem_1300 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1:term, auto_knows (s X1) -> auto___type_3 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1. intro H. intros.
  elim (rem_45 X1 H);  intros.
  apply (rem_1299 epsilon_mknows_p__type_3 X1);  tauto.
Defined.

Remark rem_1301 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_3.  tauto.
Defined.

Remark rem_1302 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> auto___type_3 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_3.  case (rem_1301 epsilon_mknows_p__type_3). clear  epsilon_mknows_p__type_3. intros. apply trans___type_3_nil_1;  tauto.
 clear  epsilon_mknows_p__type_3. tauto.
Defined.

Remark rem_1303 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> auto_knows nil -> auto___type_3 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_3. intro H. intros.
  elim (rem_49 H);  intros.
  apply (rem_1302 epsilon_mknows_p__type_3);  tauto.
Defined.

Remark rem_1304 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> auto___type_3 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_3.  case (rem_1301 epsilon_mknows_p__type_3). clear  epsilon_mknows_p__type_3. intros. apply trans___type_3_i_1;  tauto.
 clear  epsilon_mknows_p__type_3. tauto.
Defined.

Remark rem_1305 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> auto_knows i -> auto___type_3 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_3. intro H. intros.
  elim (rem_52 H);  intros.
  apply (rem_1304 epsilon_mknows_p__type_3);  tauto.
Defined.

Remark rem_1306 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1:term, auto___def_33 X1 -> auto___def_33 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1307 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___def_33 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2 X3.
  cut (auto___def_33 X1 -> auto___def_33 X1). tauto. exact (rem_1306 epsilon_mknows_p__type_3 X1).
Defined.

Remark rem_1308 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X2:term, auto___type_5 X2 -> auto___type_5 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1309 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2 X3.
  cut (auto___type_5 X2 -> auto___type_5 X2). tauto. exact (rem_1308 epsilon_mknows_p__type_3 X2).
Defined.

Remark rem_1310 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X3:term, auto___type_4 X3 -> auto___type_4 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1311 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_4 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2 X3.
  cut (auto___type_4 X3 -> auto___type_4 X3). tauto. exact (rem_1310 epsilon_mknows_p__type_3 X3).
Defined.

Remark rem_1312 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> (auto___def_33 X1 /\ auto___type_5 X2 /\ auto___type_4 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_33 X1). 2:apply (rem_1307 epsilon_mknows_p__type_3 X1 X2 X3);  assumption.
  cut (auto___type_5 X2). 2:apply (rem_1309 epsilon_mknows_p__type_3 X1 X2 X3);  assumption.
  cut (auto___type_4 X3). 2:apply (rem_1311 epsilon_mknows_p__type_3 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_1313 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_3 (nonceb X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_1312 epsilon_mknows_p__type_3 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_p__type_3 A1 A2 A3. intros. apply trans___type_3_nonceb_1;  tauto.
 clear  epsilon_mknows_p__type_3 A1 A2 A3. tauto.
Defined.

Remark rem_1314 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1:term, auto___def_16 X1 -> auto___def_16 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1315 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___def_16 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2 X3.
  cut (auto___def_16 X1 -> auto___def_16 X1). tauto. exact (rem_1314 epsilon_mknows_p__type_3 X1).
Defined.

Remark rem_1316 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2 X3.
  cut (auto___type_5 X2 -> auto___type_5 X2). tauto. exact (rem_1308 epsilon_mknows_p__type_3 X2).
Defined.

Remark rem_1317 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_4 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2 X3.
  cut (auto___type_4 X3 -> auto___type_4 X3). tauto. exact (rem_1310 epsilon_mknows_p__type_3 X3).
Defined.

Remark rem_1318 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> (auto___def_16 X1 /\ auto___type_5 X2 /\ auto___type_4 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_16 X1). 2:apply (rem_1315 epsilon_mknows_p__type_3 X1 X2 X3);  assumption.
  cut (auto___type_5 X2). 2:apply (rem_1316 epsilon_mknows_p__type_3 X1 X2 X3);  assumption.
  cut (auto___type_4 X3). 2:apply (rem_1317 epsilon_mknows_p__type_3 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_1319 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_3 (nonceb X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_1318 epsilon_mknows_p__type_3 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_p__type_3 A1 A2 A3. intros. apply trans___type_3_nonceb_2;  tauto.
 clear  epsilon_mknows_p__type_3 A1 A2 A3. tauto.
Defined.

Remark rem_1320 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2 X3:term, auto_knows (nonceb X1 X2 X3) -> auto___type_3 (nonceb X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2 X3. intro H. intros.
  elim (rem_68 X1 X2 X3 H);  intros.
  apply (rem_1313 epsilon_mknows_p__type_3 X1 X2 X3);  tauto.
  apply (rem_1319 epsilon_mknows_p__type_3 X1 X2 X3);  tauto.
Defined.

Remark rem_1321 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> auto___type_3 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_3.  case (rem_1301 epsilon_mknows_p__type_3). clear  epsilon_mknows_p__type_3. intros. apply trans___type_3_bob_1;  tauto.
 clear  epsilon_mknows_p__type_3. tauto.
Defined.

Remark rem_1322 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> auto_knows bob -> auto___type_3 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_3. intro H. intros.
  elim (rem_71 H);  intros.
  apply (rem_1321 epsilon_mknows_p__type_3);  tauto.
Defined.

Remark rem_1323 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1:term, auto___def_43 X1 -> auto___def_43 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1324 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> auto___def_43 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_43 X1). tauto. exact (rem_1323 epsilon_mknows_p__type_3 X1).
Defined.

Remark rem_1325 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1326 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_1325 epsilon_mknows_p__type_3 X2).
Defined.

Remark rem_1327 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> (auto___def_43 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_43 X1). 2:apply (rem_1324 epsilon_mknows_p__type_3 X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_1326 epsilon_mknows_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1328 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> auto___type_3 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_1327 epsilon_mknows_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_p__type_3 A1 A2. intros. apply trans___type_3_key_1;  tauto.
 clear  epsilon_mknows_p__type_3 A1 A2. tauto.
Defined.

Remark rem_1329 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1:term, auto___def_46 X1 -> auto___def_46 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1330 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_46 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2.
  cut (auto___def_46 X1 -> auto___def_46 X1). tauto. exact (rem_1329 epsilon_mknows_p__type_3 X1).
Defined.

Remark rem_1331 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X2:term, auto___def_47 X2 -> auto___def_47 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1332 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_47 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2.
  cut (auto___def_47 X2 -> auto___def_47 X2). tauto. exact (rem_1331 epsilon_mknows_p__type_3 X2).
Defined.

Remark rem_1333 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> (auto___def_46 X1 /\ auto___def_47 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_46 X1). 2:apply (rem_1330 epsilon_mknows_p__type_3 X1 X2);  assumption.
  cut (auto___def_47 X2). 2:apply (rem_1332 epsilon_mknows_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1334 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___type_3 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_1333 epsilon_mknows_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_p__type_3 A1 A2. intros. apply trans___type_3_key_2;  tauto.
 clear  epsilon_mknows_p__type_3 A1 A2. tauto.
Defined.

Remark rem_1335 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1:term, auto___def_44 X1 -> auto___def_44 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1336 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> auto___def_44 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2.
  cut (auto___def_44 X1 -> auto___def_44 X1). tauto. exact (rem_1335 epsilon_mknows_p__type_3 X1).
Defined.

Remark rem_1337 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X2:term, auto___def_45 X2 -> auto___def_45 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1338 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> auto___def_45 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2.
  cut (auto___def_45 X2 -> auto___def_45 X2). tauto. exact (rem_1337 epsilon_mknows_p__type_3 X2).
Defined.

Remark rem_1339 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> (auto___def_44 X1 /\ auto___def_45 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto___def_44 X1). 2:apply (rem_1336 epsilon_mknows_p__type_3 X1 X2);  assumption.
  cut (auto___def_45 X2). 2:apply (rem_1338 epsilon_mknows_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1340 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> auto___type_3 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_1339 epsilon_mknows_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_p__type_3 A1 A2. intros. apply trans___type_3_key_3;  tauto.
 clear  epsilon_mknows_p__type_3 A1 A2. tauto.
Defined.

Remark rem_1341 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows (key X1 X2) -> auto___type_3 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2. intro H. intros.
  elim (rem_91 X1 X2 H);  intros.
  apply (rem_1328 epsilon_mknows_p__type_3 X1 X2);  tauto.
  apply (rem_1334 epsilon_mknows_p__type_3 X1 X2);  tauto.
  apply (rem_1340 epsilon_mknows_p__type_3 X1 X2);  tauto.
Defined.

Remark rem_1342 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> auto___type_3 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_3.  case (rem_1301 epsilon_mknows_p__type_3). clear  epsilon_mknows_p__type_3. intros. apply trans___type_3_alice_1;  tauto.
 clear  epsilon_mknows_p__type_3. tauto.
Defined.

Remark rem_1343 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> auto_knows alice -> auto___type_3 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_3. intro H. intros.
  elim (rem_94 H);  intros.
  apply (rem_1342 epsilon_mknows_p__type_3);  tauto.
Defined.

Remark rem_1344 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto___type_3 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_1284 epsilon_mknows_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_p__type_3 A1 A2. intros. apply trans___type_3_cons_1;  tauto.
 clear  epsilon_mknows_p__type_3 A1 A2. tauto.
Defined.

Remark rem_1345 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows (cons X1 X2) -> auto___type_3 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2. intro H. intros.
  elim (rem_97 X1 X2 H);  intros.
  apply (rem_1344 epsilon_mknows_p__type_3 X1 X2);  tauto.
Defined.

Remark rem_1346 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> auto___type_3 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_3.  case (rem_1301 epsilon_mknows_p__type_3). clear  epsilon_mknows_p__type_3. intros. apply trans___type_3_server_1;  tauto.
 clear  epsilon_mknows_p__type_3. tauto.
Defined.

Remark rem_1347 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> auto_knows server -> auto___type_3 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_3. intro H. intros.
  elim (rem_100 H);  intros.
  apply (rem_1346 epsilon_mknows_p__type_3);  tauto.
Defined.

Remark rem_1348 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1349 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_1348 epsilon_mknows_p__type_3 X1).
Defined.

Remark rem_1350 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1351 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_1350 epsilon_mknows_p__type_3 X2).
Defined.

Remark rem_1352 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> (auto_agent X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2. intros A1 A2.
  cut (auto_agent X1). 2:apply (rem_1349 epsilon_mknows_p__type_3 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_1351 epsilon_mknows_p__type_3 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1353 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_3 (noncea X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2. intros A1 A2.
  case (rem_1352 epsilon_mknows_p__type_3 X1 X2 A1 A2). clear  epsilon_mknows_p__type_3 A1 A2. intros. apply trans___type_3_noncea_1;  tauto.
 clear  epsilon_mknows_p__type_3 A1 A2. tauto.
Defined.

Remark rem_1354 : (forall X:term, auto_knows X -> auto___type_3 X)
    -> forall X1 X2:term, auto_knows (noncea X1 X2) -> auto___type_3 (noncea X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_3. intros X1 X2. intro H. intros.
  elim (rem_108 X1 X2 H);  intros.
  apply (rem_1353 epsilon_mknows_p__type_3 X1 X2);  tauto.
Defined.

Remark rem_1355 : forall X1:term, auto_knows X1 -> auto___type_3 X1. (* Induct. *)
Proof.
  fix epsilon_mknows_p__type_3 1.
  intro X. case X.
  exact (rem_1343 epsilon_mknows_p__type_3 ).
  exact (rem_1322 epsilon_mknows_p__type_3 ).
  intros X1 X2;  exact (rem_1345 epsilon_mknows_p__type_3 X1 X2).
  intros X1 X2;  exact (rem_1297 epsilon_mknows_p__type_3 X1 X2).
  intros X1 X2 X3. intro H. elim (rem_113 X1 X2 X3 H).
  exact (rem_1305 epsilon_mknows_p__type_3 ).
  intros X1 X2;  exact (rem_1341 epsilon_mknows_p__type_3 X1 X2).
  exact (rem_1303 epsilon_mknows_p__type_3 ).
  intros X1 X2;  exact (rem_1354 epsilon_mknows_p__type_3 X1 X2).
  intros X1 X2 X3;  exact (rem_1320 epsilon_mknows_p__type_3 X1 X2 X3).
  intros X1 X2 X3. intro H. elim (rem_110 X1 X2 X3 H).
   intro H. elim (rem_112  H).
   intro H. elim (rem_114  H).
  intros X1;  exact (rem_1300 epsilon_mknows_p__type_3 X1).
  exact (rem_1347 epsilon_mknows_p__type_3 ).
   intro H. elim (rem_111  H).
Qed.

Remark rem_1356 : forall X1 X2 X3:term, auto_knows X2 -> auto_knows X1 -> auto_knows X3 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows X1 -> auto___type_3 X1). tauto. exact (rem_1355 X1).
Qed.

Remark rem_1357 : forall X1 X2 X3:term, auto_knows X2 -> auto_knows X3 -> auto_knows X1 -> auto___type_3 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_knows X2 -> auto_knows X1 -> auto_knows X3 -> auto___type_3 X1). tauto. exact (rem_1356 X1 X2 X3).
Qed.

Remark rem_1358 : forall X1 X2 X3:term, auto___def_11 X2 X3 X1 -> auto___type_3 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_118 X2 X3 X1 H);  intros.
  apply (rem_1357 X1 X2 X3);  tauto.
Qed.

Remark rem_1359 : auto___def_18 prv -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_205 H);  intros.
Qed.

Remark rem_1360 : forall X1 X2:term, auto___def_18 prv -> auto___def_19 X1 -> auto___def_42 X2 -> auto___def_3 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 prv -> False). tauto.
  exact (rem_1359).
Qed.

Remark rem_1361 : forall X1 X2:term, auto___def_18 prv -> auto___def_35 X1 -> auto___def_42 X2 -> auto___def_3 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 prv -> False). tauto.
  exact (rem_1359).
Qed.

Remark rem_1362 : forall X1 X2:term, auto___def_42 X2 -> auto___type_7 (key prv X1) -> auto___def_3 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_1141 prv X1 H);  intros.
  apply (rem_1360 X1 X2);  tauto.
  apply (rem_1361 X1 X2);  tauto.
Qed.

Remark rem_1363 : forall X1 X2:term, auto___def_12 X2 -> auto___def_18 prv -> auto___def_29 X1 -> auto___def_3 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 prv -> False). tauto.
  exact (rem_1359).
Qed.

Remark rem_1364 : forall X1 X2:term, auto___def_18 prv -> auto___def_29 X1 -> auto___def_12 X2 -> auto___def_3 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_12 X2 -> auto___def_18 prv -> auto___def_29 X1 -> auto___def_3 X1 X2). tauto. exact (rem_1363 X1 X2).
Qed.

Remark rem_1365 : forall X1 X2:term, auto___def_12 X2 -> auto___def_13 (key prv X1) -> auto___def_3 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_142 prv X1 H);  intros.
  apply (rem_1364 X1 X2);  tauto.
Qed.

Remark rem_1366 : forall X1 X2:term, auto___def_18 prv -> auto___def_22 X2 -> auto___def_25 X1 -> auto___def_3 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 prv -> False). tauto.
  exact (rem_1359).
Qed.

Remark rem_1367 : forall X1 X2:term, auto___def_18 prv -> auto___def_25 X1 -> auto___def_22 X2 -> auto___def_3 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_18 prv -> auto___def_22 X2 -> auto___def_25 X1 -> auto___def_3 X1 X2). tauto. exact (rem_1366 X1 X2).
Qed.

Remark rem_1368 : forall X1 X2:term, auto___def_22 X2 -> auto___def_23 (key prv X1) -> auto___def_3 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_171 prv X1 H);  intros.
  apply (rem_1367 X1 X2);  tauto.
Qed.

Remark rem_1369 : forall X1 X2:term, auto___def_18 prv -> auto___def_25 X1 -> auto___def_37 X2 -> auto___def_3 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 prv -> False). tauto.
  exact (rem_1359).
Qed.

Remark rem_1370 : forall X1 X2:term, auto___def_23 (key prv X1) -> auto___def_37 X2 -> auto___def_3 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_171 prv X1 H);  intros.
  apply (rem_1369 X1 X2);  tauto.
Qed.

Remark rem_1371 : forall X1 X2:term, auto___def_37 X2 -> auto___def_23 (key prv X1) -> auto___def_3 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_23 (key prv X1) -> auto___def_37 X2 -> auto___def_3 X1 X2). tauto. exact (rem_1370 X1 X2).
Qed.

Remark rem_1372 : auto___def_43 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1373 : auto___def_43 prv -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_1372 H);  intros.
Qed.

Remark rem_1374 : forall X1 X2:term, auto___def_43 prv -> auto_knows X2 -> auto___def_3 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_43 prv -> False). tauto.
  exact (rem_1373).
Qed.

Remark rem_1375 : forall X1 X2:term, auto___def_43 prv -> auto___type_8 X1 -> auto_knows X2 -> auto___def_3 X1 X2. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2. intros. apply (rem_1374 X1 X2);  assumption.
Qed.

Remark rem_1376 : auto___def_46 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1377 : auto___def_46 prv -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_1376 H);  intros.
Qed.

Remark rem_1378 : forall X1 X2:term, auto___def_46 prv -> auto___def_47 X1 -> auto_knows X2 -> auto___def_3 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_46 prv -> False). tauto.
  exact (rem_1377).
Qed.

Remark rem_1379 : forall X1:term, auto___def_45 X1 -> auto___def_45 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1380 : forall X1 X2:term, auto___def_44 prv -> auto___def_45 X1 -> auto_knows X2 -> auto___def_45 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_45 X1 -> auto___def_45 X1). tauto. exact (rem_1379 X1).
Qed.

Remark rem_1381 : forall X1 X2:term, auto___def_44 prv -> auto___def_45 X1 -> auto_knows X2 -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows X2 -> auto_knows X2). tauto. exact (rem_1200 X2).
Qed.

Remark rem_1382 : forall X1 X2:term, auto___def_44 prv -> auto___def_45 X1 -> auto_knows X2 -> (auto___def_45 X1 /\ auto_knows X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_45 X1). 2:apply (rem_1380 X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_1381 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1383 : forall X1 X2:term, auto___def_44 prv -> auto___def_45 X1 -> auto_knows X2 -> auto___def_3 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1382 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_3_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1384 : forall X1 X2:term, auto_knows X2 -> auto_knows (key prv X1) -> auto___def_3 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_91 prv X1 H);  intros.
  apply (rem_1375 X1 X2);  tauto.
  apply (rem_1378 X1 X2);  tauto.
  apply (rem_1383 X1 X2);  tauto.
Qed.

Remark rem_1385 : forall X1 X2:term, auto___def_18 prv -> auto___def_19 X1 -> auto___def_40 X2 -> auto___def_3 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 prv -> False). tauto.
  exact (rem_1359).
Qed.

Remark rem_1386 : forall X1 X2:term, auto___def_18 prv -> auto___def_35 X1 -> auto___def_40 X2 -> auto___def_3 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 prv -> False). tauto.
  exact (rem_1359).
Qed.

Remark rem_1387 : forall X1 X2:term, auto___def_40 X2 -> auto___type_6 (key prv X1) -> auto___def_3 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_1184 prv X1 H);  intros.
  apply (rem_1385 X1 X2);  tauto.
  apply (rem_1386 X1 X2);  tauto.
Qed.

Remark rem_1388 : forall X1 X2:term, auto___def_18 prv -> auto___def_29 X1 -> auto___def_30 X2 -> auto___def_3 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 prv -> False). tauto.
  exact (rem_1359).
Qed.

Remark rem_1389 : forall X1 X2:term, auto___def_13 (key prv X1) -> auto___def_30 X2 -> auto___def_3 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_142 prv X1 H);  intros.
  apply (rem_1388 X1 X2);  tauto.
Qed.

Remark rem_1390 : forall X1 X2:term, auto___def_30 X2 -> auto___def_13 (key prv X1) -> auto___def_3 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_13 (key prv X1) -> auto___def_30 X2 -> auto___def_3 X1 X2). tauto. exact (rem_1389 X1 X2).
Qed.

Remark rem_1391 : forall X1 X2:term, auto_knows (crypt X2 (key prv X1)) -> auto___def_3 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_41 X2 (key prv X1) H);  intros.
  apply (rem_1362 X1 X2);  tauto.
  apply (rem_1365 X1 X2);  tauto.
  apply (rem_1368 X1 X2);  tauto.
  apply (rem_1371 X1 X2);  tauto.
  apply (rem_1384 X1 X2);  tauto.
  apply (rem_1387 X1 X2);  tauto.
  apply (rem_1390 X1 X2);  tauto.
Qed.

Remark rem_1392 : forall X1:term, auto_knows (key pub X1) -> auto___def_4 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___def_4_1. Qed.

Remark rem_1393 : True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
   tauto.
Qed.

Remark rem_1394 : auto___def_28 nil. (* Deduce positive atom. *)
Proof.
   case rem_1393. intros. apply trans___def_28_nil_1;  tauto.
 tauto.
Qed.

Remark rem_1395 : forall X1 X2:term, auto___def_23 X2 -> auto___def_37 X1 -> auto___def_37 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_37 X1 -> auto___def_37 X1). tauto. exact (rem_1159 X1).
Qed.

Remark rem_1396 : forall X2:term, auto___def_23 X2 -> auto___def_23 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1397 : forall X1 X2:term, auto___def_23 X2 -> auto___def_37 X1 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_1396 X2).
Qed.

Remark rem_1398 : forall X1 X2:term, auto___def_23 X2 -> auto___def_37 X1 -> (auto___def_37 X1 /\ auto___def_23 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_37 X1). 2:apply (rem_1395 X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_1397 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1399 : forall X1 X2:term, auto___def_23 X2 -> auto___def_37 X1 -> auto___def_36 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1398 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_36_crypt_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1400 : forall X1 X2:term, auto___def_18 X1 -> auto___def_29 X2 -> auto___def_18 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_18 X1). tauto. exact (rem_1119 X1).
Qed.

Remark rem_1401 : forall X1 X2:term, auto___def_18 X1 -> auto___def_29 X2 -> auto___def_29 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_29 X2 -> auto___def_29 X2). tauto. exact (rem_1145 X2).
Qed.

Remark rem_1402 : forall X1 X2:term, auto___def_18 X1 -> auto___def_29 X2 -> (auto___def_18 X1 /\ auto___def_29 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_18 X1). 2:apply (rem_1400 X1 X2);  assumption.
  cut (auto___def_29 X2). 2:apply (rem_1401 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1403 : forall X1 X2:term, auto___def_18 X1 -> auto___def_29 X2 -> auto___def_13 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1402 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_13_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1404 : forall X1 X2:term, auto___def_29 X2 -> auto___def_18 X1 -> auto___def_13 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_29 X2 -> auto___def_13 (key X1 X2)). tauto. exact (rem_1403 X1 X2).
Qed.

Remark rem_1405 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1:term, auto___def_42 X1 -> auto___def_42 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1406 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto___def_42 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2.
  cut (auto___def_42 X1 -> auto___def_42 X1). tauto. exact (rem_1405 epsilon_mknows_p__type_4 X1).
Defined.

Remark rem_1407 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X2:term, auto___type_7 X2 -> auto___type_7 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1408 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto___type_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2.
  cut (auto___type_7 X2 -> auto___type_7 X2). tauto. exact (rem_1407 epsilon_mknows_p__type_4 X2).
Defined.

Remark rem_1409 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> (auto___def_42 X1 /\ auto___type_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2. intros A1 A2.
  cut (auto___def_42 X1). 2:apply (rem_1406 epsilon_mknows_p__type_4 X1 X2);  assumption.
  cut (auto___type_7 X2). 2:apply (rem_1408 epsilon_mknows_p__type_4 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1410 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto___type_4 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2. intros A1 A2.
  case (rem_1409 epsilon_mknows_p__type_4 X1 X2 A1 A2). clear  epsilon_mknows_p__type_4 A1 A2. intros. apply trans___type_4_crypt_1;  tauto.
 clear  epsilon_mknows_p__type_4 A1 A2. tauto.
Defined.

Remark rem_1411 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1:term, auto___def_12 X1 -> auto___def_12 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1412 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_12 X1). tauto. exact (rem_1411 epsilon_mknows_p__type_4 X1).
Defined.

Remark rem_1413 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X2:term, auto___def_13 X2 -> auto___def_13 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1414 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_1413 epsilon_mknows_p__type_4 X2).
Defined.

Remark rem_1415 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> (auto___def_12 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2. intros A1 A2.
  cut (auto___def_12 X1). 2:apply (rem_1412 epsilon_mknows_p__type_4 X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_1414 epsilon_mknows_p__type_4 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1416 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___type_4 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2. intros A1 A2.
  case (rem_1415 epsilon_mknows_p__type_4 X1 X2 A1 A2). clear  epsilon_mknows_p__type_4 A1 A2. intros. apply trans___type_4_crypt_2;  tauto.
 clear  epsilon_mknows_p__type_4 A1 A2. tauto.
Defined.

Remark rem_1417 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1:term, auto___def_22 X1 -> auto___def_22 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1418 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_22 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2.
  cut (auto___def_22 X1 -> auto___def_22 X1). tauto. exact (rem_1417 epsilon_mknows_p__type_4 X1).
Defined.

Remark rem_1419 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X2:term, auto___def_23 X2 -> auto___def_23 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1420 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_1419 epsilon_mknows_p__type_4 X2).
Defined.

Remark rem_1421 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> (auto___def_22 X1 /\ auto___def_23 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2. intros A1 A2.
  cut (auto___def_22 X1). 2:apply (rem_1418 epsilon_mknows_p__type_4 X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_1420 epsilon_mknows_p__type_4 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1422 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___type_4 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2. intros A1 A2.
  case (rem_1421 epsilon_mknows_p__type_4 X1 X2 A1 A2). clear  epsilon_mknows_p__type_4 A1 A2. intros. apply trans___type_4_crypt_3;  tauto.
 clear  epsilon_mknows_p__type_4 A1 A2. tauto.
Defined.

Remark rem_1423 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1:term, auto___def_37 X1 -> auto___def_37 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1424 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto___def_37 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2.
  cut (auto___def_37 X1 -> auto___def_37 X1). tauto. exact (rem_1423 epsilon_mknows_p__type_4 X1).
Defined.

Remark rem_1425 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_1419 epsilon_mknows_p__type_4 X2).
Defined.

Remark rem_1426 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> (auto___def_37 X1 /\ auto___def_23 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2. intros A1 A2.
  cut (auto___def_37 X1). 2:apply (rem_1424 epsilon_mknows_p__type_4 X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_1425 epsilon_mknows_p__type_4 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1427 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto___type_4 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2. intros A1 A2.
  case (rem_1426 epsilon_mknows_p__type_4 X1 X2 A1 A2). clear  epsilon_mknows_p__type_4 A1 A2. intros. apply trans___type_4_crypt_4;  tauto.
 clear  epsilon_mknows_p__type_4 A1 A2. tauto.
Defined.

Remark rem_1428 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1:term, auto_knows X1 -> auto_knows X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1429 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2.
  cut (auto_knows X1 -> auto_knows X1). tauto. exact (rem_1428 epsilon_mknows_p__type_4 X1).
Defined.

Remark rem_1430 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X2:term, auto_knows X2 -> auto_knows X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1431 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2.
  cut (auto_knows X2 -> auto_knows X2). tauto. exact (rem_1430 epsilon_mknows_p__type_4 X2).
Defined.

Remark rem_1432 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> (auto_knows X1 /\ auto_knows X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2. intros A1 A2.
  cut (auto_knows X1). 2:apply (rem_1429 epsilon_mknows_p__type_4 X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_1431 epsilon_mknows_p__type_4 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1433 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto___type_4 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2. intros A1 A2.
  case (rem_1432 epsilon_mknows_p__type_4 X1 X2 A1 A2). clear  epsilon_mknows_p__type_4 A1 A2. intros. apply trans___type_4_crypt_5;  tauto.
 clear  epsilon_mknows_p__type_4 A1 A2. tauto.
Defined.

Remark rem_1434 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1:term, auto___def_40 X1 -> auto___def_40 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1435 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> auto___def_40 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2.
  cut (auto___def_40 X1 -> auto___def_40 X1). tauto. exact (rem_1434 epsilon_mknows_p__type_4 X1).
Defined.

Remark rem_1436 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X2:term, auto___type_6 X2 -> auto___type_6 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1437 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> auto___type_6 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2.
  cut (auto___type_6 X2 -> auto___type_6 X2). tauto. exact (rem_1436 epsilon_mknows_p__type_4 X2).
Defined.

Remark rem_1438 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> (auto___def_40 X1 /\ auto___type_6 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2. intros A1 A2.
  cut (auto___def_40 X1). 2:apply (rem_1435 epsilon_mknows_p__type_4 X1 X2);  assumption.
  cut (auto___type_6 X2). 2:apply (rem_1437 epsilon_mknows_p__type_4 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1439 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> auto___type_4 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2. intros A1 A2.
  case (rem_1438 epsilon_mknows_p__type_4 X1 X2 A1 A2). clear  epsilon_mknows_p__type_4 A1 A2. intros. apply trans___type_4_crypt_6;  tauto.
 clear  epsilon_mknows_p__type_4 A1 A2. tauto.
Defined.

Remark rem_1440 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1:term, auto___def_30 X1 -> auto___def_30 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1441 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> auto___def_30 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2.
  cut (auto___def_30 X1 -> auto___def_30 X1). tauto. exact (rem_1440 epsilon_mknows_p__type_4 X1).
Defined.

Remark rem_1442 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_1413 epsilon_mknows_p__type_4 X2).
Defined.

Remark rem_1443 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> (auto___def_30 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2. intros A1 A2.
  cut (auto___def_30 X1). 2:apply (rem_1441 epsilon_mknows_p__type_4 X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_1442 epsilon_mknows_p__type_4 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1444 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> auto___type_4 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2. intros A1 A2.
  case (rem_1443 epsilon_mknows_p__type_4 X1 X2 A1 A2). clear  epsilon_mknows_p__type_4 A1 A2. intros. apply trans___type_4_crypt_7;  tauto.
 clear  epsilon_mknows_p__type_4 A1 A2. tauto.
Defined.

Remark rem_1445 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto_knows (crypt X1 X2) -> auto___type_4 (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2. intro H. intros.
  elim (rem_41 X1 X2 H);  intros.
  apply (rem_1410 epsilon_mknows_p__type_4 X1 X2);  tauto.
  apply (rem_1416 epsilon_mknows_p__type_4 X1 X2);  tauto.
  apply (rem_1422 epsilon_mknows_p__type_4 X1 X2);  tauto.
  apply (rem_1427 epsilon_mknows_p__type_4 X1 X2);  tauto.
  apply (rem_1433 epsilon_mknows_p__type_4 X1 X2);  tauto.
  apply (rem_1439 epsilon_mknows_p__type_4 X1 X2);  tauto.
  apply (rem_1444 epsilon_mknows_p__type_4 X1 X2);  tauto.
Defined.

Remark rem_1446 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1:term, auto_knows X1 -> auto_knows X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1. intros A1.
  cut (auto_knows X1). 2:apply (rem_1428 epsilon_mknows_p__type_4 X1);  assumption.
  tauto.
Defined.

Remark rem_1447 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1:term, auto_knows X1 -> auto___type_4 (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1. intros A1.
  case (rem_1446 epsilon_mknows_p__type_4 X1 A1). clear  epsilon_mknows_p__type_4 A1. intros. apply trans___type_4_s_1;  tauto.
 clear  epsilon_mknows_p__type_4 A1. tauto.
Defined.

Remark rem_1448 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1:term, auto_knows (s X1) -> auto___type_4 (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1. intro H. intros.
  elim (rem_45 X1 H);  intros.
  apply (rem_1447 epsilon_mknows_p__type_4 X1);  tauto.
Defined.

Remark rem_1449 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_4.  tauto.
Defined.

Remark rem_1450 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> auto___type_4 nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_4.  case (rem_1449 epsilon_mknows_p__type_4). clear  epsilon_mknows_p__type_4. intros. apply trans___type_4_nil_1;  tauto.
 clear  epsilon_mknows_p__type_4. tauto.
Defined.

Remark rem_1451 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> auto_knows nil -> auto___type_4 nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_4. intro H. intros.
  elim (rem_49 H);  intros.
  apply (rem_1450 epsilon_mknows_p__type_4);  tauto.
Defined.

Remark rem_1452 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> auto___type_4 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_4.  case (rem_1449 epsilon_mknows_p__type_4). clear  epsilon_mknows_p__type_4. intros. apply trans___type_4_i_1;  tauto.
 clear  epsilon_mknows_p__type_4. tauto.
Defined.

Remark rem_1453 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> auto_knows i -> auto___type_4 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_4. intro H. intros.
  elim (rem_52 H);  intros.
  apply (rem_1452 epsilon_mknows_p__type_4);  tauto.
Defined.

Remark rem_1454 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1:term, auto___def_33 X1 -> auto___def_33 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1455 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___def_33 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2 X3.
  cut (auto___def_33 X1 -> auto___def_33 X1). tauto. exact (rem_1454 epsilon_mknows_p__type_4 X1).
Defined.

Remark rem_1456 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X2:term, auto___type_5 X2 -> auto___type_5 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1457 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2 X3.
  cut (auto___type_5 X2 -> auto___type_5 X2). tauto. exact (rem_1456 epsilon_mknows_p__type_4 X2).
Defined.

Remark rem_1458 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X3:term, auto___type_4 X3 -> auto___type_4 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1459 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_4 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2 X3.
  cut (auto___type_4 X3 -> auto___type_4 X3). tauto. exact (rem_1458 epsilon_mknows_p__type_4 X3).
Defined.

Remark rem_1460 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> (auto___def_33 X1 /\ auto___type_5 X2 /\ auto___type_4 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_33 X1). 2:apply (rem_1455 epsilon_mknows_p__type_4 X1 X2 X3);  assumption.
  cut (auto___type_5 X2). 2:apply (rem_1457 epsilon_mknows_p__type_4 X1 X2 X3);  assumption.
  cut (auto___type_4 X3). 2:apply (rem_1459 epsilon_mknows_p__type_4 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_1461 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_4 (nonceb X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_1460 epsilon_mknows_p__type_4 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_p__type_4 A1 A2 A3. intros. apply trans___type_4_nonceb_1;  tauto.
 clear  epsilon_mknows_p__type_4 A1 A2 A3. tauto.
Defined.

Remark rem_1462 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1:term, auto___def_16 X1 -> auto___def_16 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1463 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___def_16 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2 X3.
  cut (auto___def_16 X1 -> auto___def_16 X1). tauto. exact (rem_1462 epsilon_mknows_p__type_4 X1).
Defined.

Remark rem_1464 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2 X3.
  cut (auto___type_5 X2 -> auto___type_5 X2). tauto. exact (rem_1456 epsilon_mknows_p__type_4 X2).
Defined.

Remark rem_1465 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_4 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2 X3.
  cut (auto___type_4 X3 -> auto___type_4 X3). tauto. exact (rem_1458 epsilon_mknows_p__type_4 X3).
Defined.

Remark rem_1466 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> (auto___def_16 X1 /\ auto___type_5 X2 /\ auto___type_4 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_16 X1). 2:apply (rem_1463 epsilon_mknows_p__type_4 X1 X2 X3);  assumption.
  cut (auto___type_5 X2). 2:apply (rem_1464 epsilon_mknows_p__type_4 X1 X2 X3);  assumption.
  cut (auto___type_4 X3). 2:apply (rem_1465 epsilon_mknows_p__type_4 X1 X2 X3);  assumption.
  tauto.
Defined.

Remark rem_1467 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_5 X2 -> auto___type_4 X3 -> auto___type_4 (nonceb X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2 X3. intros A1 A2 A3.
  case (rem_1466 epsilon_mknows_p__type_4 X1 X2 X3 A1 A2 A3). clear  epsilon_mknows_p__type_4 A1 A2 A3. intros. apply trans___type_4_nonceb_2;  tauto.
 clear  epsilon_mknows_p__type_4 A1 A2 A3. tauto.
Defined.

Remark rem_1468 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2 X3:term, auto_knows (nonceb X1 X2 X3) -> auto___type_4 (nonceb X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2 X3. intro H. intros.
  elim (rem_68 X1 X2 X3 H);  intros.
  apply (rem_1461 epsilon_mknows_p__type_4 X1 X2 X3);  tauto.
  apply (rem_1467 epsilon_mknows_p__type_4 X1 X2 X3);  tauto.
Defined.

Remark rem_1469 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> auto___type_4 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_4.  case (rem_1449 epsilon_mknows_p__type_4). clear  epsilon_mknows_p__type_4. intros. apply trans___type_4_bob_1;  tauto.
 clear  epsilon_mknows_p__type_4. tauto.
Defined.

Remark rem_1470 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> auto_knows bob -> auto___type_4 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_4. intro H. intros.
  elim (rem_71 H);  intros.
  apply (rem_1469 epsilon_mknows_p__type_4);  tauto.
Defined.

Remark rem_1471 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1:term, auto___def_43 X1 -> auto___def_43 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1472 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> auto___def_43 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_43 X1). tauto. exact (rem_1471 epsilon_mknows_p__type_4 X1).
Defined.

Remark rem_1473 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X2:term, auto___type_8 X2 -> auto___type_8 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1474 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2.
  cut (auto___type_8 X2 -> auto___type_8 X2). tauto. exact (rem_1473 epsilon_mknows_p__type_4 X2).
Defined.

Remark rem_1475 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> (auto___def_43 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2. intros A1 A2.
  cut (auto___def_43 X1). 2:apply (rem_1472 epsilon_mknows_p__type_4 X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_1474 epsilon_mknows_p__type_4 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1476 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> auto___type_4 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2. intros A1 A2.
  case (rem_1475 epsilon_mknows_p__type_4 X1 X2 A1 A2). clear  epsilon_mknows_p__type_4 A1 A2. intros. apply trans___type_4_key_1;  tauto.
 clear  epsilon_mknows_p__type_4 A1 A2. tauto.
Defined.

Remark rem_1477 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1:term, auto___def_46 X1 -> auto___def_46 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1478 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_46 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2.
  cut (auto___def_46 X1 -> auto___def_46 X1). tauto. exact (rem_1477 epsilon_mknows_p__type_4 X1).
Defined.

Remark rem_1479 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X2:term, auto___def_47 X2 -> auto___def_47 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1480 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_47 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2.
  cut (auto___def_47 X2 -> auto___def_47 X2). tauto. exact (rem_1479 epsilon_mknows_p__type_4 X2).
Defined.

Remark rem_1481 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> (auto___def_46 X1 /\ auto___def_47 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2. intros A1 A2.
  cut (auto___def_46 X1). 2:apply (rem_1478 epsilon_mknows_p__type_4 X1 X2);  assumption.
  cut (auto___def_47 X2). 2:apply (rem_1480 epsilon_mknows_p__type_4 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1482 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___type_4 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2. intros A1 A2.
  case (rem_1481 epsilon_mknows_p__type_4 X1 X2 A1 A2). clear  epsilon_mknows_p__type_4 A1 A2. intros. apply trans___type_4_key_2;  tauto.
 clear  epsilon_mknows_p__type_4 A1 A2. tauto.
Defined.

Remark rem_1483 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1:term, auto___def_44 X1 -> auto___def_44 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1484 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> auto___def_44 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2.
  cut (auto___def_44 X1 -> auto___def_44 X1). tauto. exact (rem_1483 epsilon_mknows_p__type_4 X1).
Defined.

Remark rem_1485 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X2:term, auto___def_45 X2 -> auto___def_45 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1486 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> auto___def_45 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2.
  cut (auto___def_45 X2 -> auto___def_45 X2). tauto. exact (rem_1485 epsilon_mknows_p__type_4 X2).
Defined.

Remark rem_1487 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> (auto___def_44 X1 /\ auto___def_45 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2. intros A1 A2.
  cut (auto___def_44 X1). 2:apply (rem_1484 epsilon_mknows_p__type_4 X1 X2);  assumption.
  cut (auto___def_45 X2). 2:apply (rem_1486 epsilon_mknows_p__type_4 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1488 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> auto___type_4 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2. intros A1 A2.
  case (rem_1487 epsilon_mknows_p__type_4 X1 X2 A1 A2). clear  epsilon_mknows_p__type_4 A1 A2. intros. apply trans___type_4_key_3;  tauto.
 clear  epsilon_mknows_p__type_4 A1 A2. tauto.
Defined.

Remark rem_1489 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto_knows (key X1 X2) -> auto___type_4 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2. intro H. intros.
  elim (rem_91 X1 X2 H);  intros.
  apply (rem_1476 epsilon_mknows_p__type_4 X1 X2);  tauto.
  apply (rem_1482 epsilon_mknows_p__type_4 X1 X2);  tauto.
  apply (rem_1488 epsilon_mknows_p__type_4 X1 X2);  tauto.
Defined.

Remark rem_1490 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> auto___type_4 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_4.  case (rem_1449 epsilon_mknows_p__type_4). clear  epsilon_mknows_p__type_4. intros. apply trans___type_4_alice_1;  tauto.
 clear  epsilon_mknows_p__type_4. tauto.
Defined.

Remark rem_1491 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> auto_knows alice -> auto___type_4 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_4. intro H. intros.
  elim (rem_94 H);  intros.
  apply (rem_1490 epsilon_mknows_p__type_4);  tauto.
Defined.

Remark rem_1492 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto___type_4 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2. intros A1 A2.
  case (rem_1432 epsilon_mknows_p__type_4 X1 X2 A1 A2). clear  epsilon_mknows_p__type_4 A1 A2. intros. apply trans___type_4_cons_1;  tauto.
 clear  epsilon_mknows_p__type_4 A1 A2. tauto.
Defined.

Remark rem_1493 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto_knows (cons X1 X2) -> auto___type_4 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2. intro H. intros.
  elim (rem_97 X1 X2 H);  intros.
  apply (rem_1492 epsilon_mknows_p__type_4 X1 X2);  tauto.
Defined.

Remark rem_1494 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> auto___type_4 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_4.  case (rem_1449 epsilon_mknows_p__type_4). clear  epsilon_mknows_p__type_4. intros. apply trans___type_4_server_1;  tauto.
 clear  epsilon_mknows_p__type_4. tauto.
Defined.

Remark rem_1495 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> auto_knows server -> auto___type_4 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_4. intro H. intros.
  elim (rem_100 H);  intros.
  apply (rem_1494 epsilon_mknows_p__type_4);  tauto.
Defined.

Remark rem_1496 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1497 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_1496 epsilon_mknows_p__type_4 X1).
Defined.

Remark rem_1498 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1499 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_1498 epsilon_mknows_p__type_4 X2).
Defined.

Remark rem_1500 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> (auto_agent X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2. intros A1 A2.
  cut (auto_agent X1). 2:apply (rem_1497 epsilon_mknows_p__type_4 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_1499 epsilon_mknows_p__type_4 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1501 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_4 (noncea X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2. intros A1 A2.
  case (rem_1500 epsilon_mknows_p__type_4 X1 X2 A1 A2). clear  epsilon_mknows_p__type_4 A1 A2. intros. apply trans___type_4_noncea_1;  tauto.
 clear  epsilon_mknows_p__type_4 A1 A2. tauto.
Defined.

Remark rem_1502 : (forall X:term, auto_knows X -> auto___type_4 X)
    -> forall X1 X2:term, auto_knows (noncea X1 X2) -> auto___type_4 (noncea X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_p__type_4. intros X1 X2. intro H. intros.
  elim (rem_108 X1 X2 H);  intros.
  apply (rem_1501 epsilon_mknows_p__type_4 X1 X2);  tauto.
Defined.

Remark rem_1503 : forall X1:term, auto_knows X1 -> auto___type_4 X1. (* Induct. *)
Proof.
  fix epsilon_mknows_p__type_4 1.
  intro X. case X.
  exact (rem_1491 epsilon_mknows_p__type_4 ).
  exact (rem_1470 epsilon_mknows_p__type_4 ).
  intros X1 X2;  exact (rem_1493 epsilon_mknows_p__type_4 X1 X2).
  intros X1 X2;  exact (rem_1445 epsilon_mknows_p__type_4 X1 X2).
  intros X1 X2 X3. intro H. elim (rem_113 X1 X2 X3 H).
  exact (rem_1453 epsilon_mknows_p__type_4 ).
  intros X1 X2;  exact (rem_1489 epsilon_mknows_p__type_4 X1 X2).
  exact (rem_1451 epsilon_mknows_p__type_4 ).
  intros X1 X2;  exact (rem_1502 epsilon_mknows_p__type_4 X1 X2).
  intros X1 X2 X3;  exact (rem_1468 epsilon_mknows_p__type_4 X1 X2 X3).
  intros X1 X2 X3. intro H. elim (rem_110 X1 X2 X3 H).
   intro H. elim (rem_112  H).
   intro H. elim (rem_114  H).
  intros X1;  exact (rem_1448 epsilon_mknows_p__type_4 X1).
  exact (rem_1495 epsilon_mknows_p__type_4 ).
   intro H. elim (rem_111  H).
Qed.

Remark rem_1504 : forall X1 X2 X3:term, auto_knows X2 -> auto_knows X1 -> auto_knows X3 -> auto___type_4 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows X1 -> auto___type_4 X1). tauto. exact (rem_1503 X1).
Qed.

Remark rem_1505 : forall X1 X2 X3:term, auto___def_11 X2 X1 X3 -> auto___type_4 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_118 X2 X1 X3 H);  intros.
  apply (rem_1504 X1 X2 X3);  tauto.
Qed.

Remark rem_1506 : forall X1 X2:term, auto___def_15 X2 -> auto___type_4 X1 -> auto___type_4 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_4 X1 -> auto___type_4 X1). tauto. exact (rem_1245 X1).
Qed.

Remark rem_1507 : forall X2:term, auto___def_15 X2 -> auto___def_15 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1508 : forall X1 X2:term, auto___def_15 X2 -> auto___type_4 X1 -> auto___def_15 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_15 X2 -> auto___def_15 X2). tauto. exact (rem_1507 X2).
Qed.

Remark rem_1509 : forall X1 X2:term, auto___def_15 X2 -> auto___type_4 X1 -> (auto___type_4 X1 /\ auto___def_15 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_4 X1). 2:apply (rem_1506 X1 X2);  assumption.
  cut (auto___def_15 X2). 2:apply (rem_1508 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1510 : forall X1 X2:term, auto___def_15 X2 -> auto___type_4 X1 -> auto___def_14 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1509 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_14_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1511 : auto___def_27 server. (* Deduce positive atom. *)
Proof.
   case rem_1393. intros. apply trans___def_27_server_1;  tauto.
 tauto.
Qed.

Remark rem_1512 : forall X1 X2:term, auto___def_33 X1 -> auto___def_34 X2 -> auto___def_33 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_33 X1 -> auto___def_33 X1). tauto. exact (rem_923 X1).
Qed.

Remark rem_1513 : forall X2:term, auto___def_34 X2 -> auto___def_34 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1514 : forall X1 X2:term, auto___def_33 X1 -> auto___def_34 X2 -> auto___def_34 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_34 X2 -> auto___def_34 X2). tauto. exact (rem_1513 X2).
Qed.

Remark rem_1515 : forall X1 X2:term, auto___def_33 X1 -> auto___def_34 X2 -> (auto___def_33 X1 /\ auto___def_34 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_33 X1). 2:apply (rem_1512 X1 X2);  assumption.
  cut (auto___def_34 X2). 2:apply (rem_1514 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1516 : forall X1 X2:term, auto___def_33 X1 -> auto___def_34 X2 -> auto___def_32 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1515 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_32_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1517 : forall X1 X2:term, auto___def_34 X2 -> auto___def_33 X1 -> auto___def_32 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_33 X1 -> auto___def_34 X2 -> auto___def_32 (cons X1 X2)). tauto. exact (rem_1516 X1 X2).
Qed.

Remark rem_1518 : auto___def_21 nil. (* Deduce positive atom. *)
Proof.
   case rem_1393. intros. apply trans___def_21_nil_1;  tauto.
 tauto.
Qed.

Remark rem_1519 : forall X1:term, auto___def_43 prv -> auto___def_2 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_43 prv -> False). tauto.
  exact (rem_1373).
Qed.

Remark rem_1520 : forall X1:term, auto___def_43 prv -> auto___type_8 X1 -> auto___def_2 X1. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1. intros. apply (rem_1519 X1);  assumption.
Qed.

Remark rem_1521 : forall X1:term, auto___def_46 prv -> auto___def_47 X1 -> auto___def_2 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_46 prv -> False). tauto.
  exact (rem_1377).
Qed.

Remark rem_1522 : (forall X:term, auto___def_45 X -> auto___def_2 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_45_p__def_2.  tauto.
Defined.

Remark rem_1523 : (forall X:term, auto___def_45 X -> auto___def_2 X)
    -> auto___def_2 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_45_p__def_2.  case (rem_1522 epsilon_m__def_45_p__def_2). clear  epsilon_m__def_45_p__def_2. intros. apply trans___def_2_i_1;  tauto.
 clear  epsilon_m__def_45_p__def_2. tauto.
Defined.

Remark rem_1524 : auto___def_45 i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1525 : (forall X:term, auto___def_45 X -> auto___def_2 X)
    -> auto___def_45 i -> auto___def_2 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_45_p__def_2. intro H. intros.
  elim (rem_1524 H);  intros.
  apply (rem_1523 epsilon_m__def_45_p__def_2);  tauto.
Defined.

Remark rem_1526 : forall X1 X2:term, auto___def_45 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1527 : forall X1:term, auto___def_45 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1528 : auto___def_45 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1529 : forall X1 X2 X3:term, auto___def_45 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1530 : forall X1 X2 X3:term, auto___def_45 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1531 : auto___def_45 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1532 : forall X1 X2:term, auto___def_45 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1533 : auto___def_45 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1534 : auto___def_45 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1535 : auto___def_45 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1536 : forall X1 X2 X3:term, auto___def_45 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1537 : auto___def_45 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1538 : auto___def_45 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1539 : forall X1 X2:term, auto___def_45 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1540 : forall X1:term, auto___def_45 X1 -> auto___def_2 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_45_p__def_2 1.
  intro X. case X.
   intro H. elim (rem_1534  H).
   intro H. elim (rem_1531  H).
  intros X1 X2. intro H. elim (rem_985 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1526 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1536 X1 X2 X3 H).
  exact (rem_1525 epsilon_m__def_45_p__def_2 ).
  intros X1 X2. intro H. elim (rem_1532 X1 X2 H).
   intro H. elim (rem_1528  H).
  intros X1 X2. intro H. elim (rem_1539 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1530 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1529 X1 X2 X3 H).
   intro H. elim (rem_1535  H).
   intro H. elim (rem_1537  H).
  intros X1. intro H. elim (rem_1527 X1 H).
   intro H. elim (rem_1538  H).
   intro H. elim (rem_1533  H).
Qed.

Remark rem_1541 : forall X1:term, auto___def_44 prv -> auto___def_45 X1 -> auto___def_2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1.
  cut (auto___def_45 X1 -> auto___def_2 X1). tauto. exact (rem_1540 X1).
Qed.

Remark rem_1542 : forall X1:term, auto_knows (key prv X1) -> auto___def_2 X1. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_91 prv X1 H);  intros.
  apply (rem_1520 X1);  tauto.
  apply (rem_1521 X1);  tauto.
  apply (rem_1541 X1);  tauto.
Qed.

Remark rem_1543 : forall X1:term, auto___def_20 X1 -> auto___def_20 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1544 : forall X1 X2:term, auto___def_20 X1 -> auto___def_21 X2 -> auto___def_20 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_20 X1 -> auto___def_20 X1). tauto. exact (rem_1543 X1).
Qed.

Remark rem_1545 : forall X1 X2:term, auto___def_20 X1 -> auto___def_21 X2 -> auto___def_21 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_21 X2 -> auto___def_21 X2). tauto. exact (rem_919 X2).
Qed.

Remark rem_1546 : forall X1 X2:term, auto___def_20 X1 -> auto___def_21 X2 -> (auto___def_20 X1 /\ auto___def_21 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_20 X1). 2:apply (rem_1544 X1 X2);  assumption.
  cut (auto___def_21 X2). 2:apply (rem_1545 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1547 : forall X1 X2:term, auto___def_20 X1 -> auto___def_21 X2 -> auto___def_17 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1546 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_17_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1548 : forall X1 X2:term, auto___def_21 X2 -> auto___def_20 X1 -> auto___def_17 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_20 X1 -> auto___def_21 X2 -> auto___def_17 (cons X1 X2)). tauto. exact (rem_1547 X1 X2).
Qed.

Remark rem_1549 : auto___def_18 sym. (* Deduce positive atom. *)
Proof.
   case rem_1393. intros. apply trans___def_18_sym_1;  tauto.
 tauto.
Qed.

Remark rem_1550 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_4 X3 -> auto___type_5 X2 -> auto___def_16 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_16 X1 -> auto___def_16 X1). tauto. exact (rem_1250 X1).
Qed.

Remark rem_1551 : forall X2:term, auto___type_5 X2 -> auto___type_5 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1552 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_4 X3 -> auto___type_5 X2 -> auto___type_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___type_5 X2 -> auto___type_5 X2). tauto. exact (rem_1551 X2).
Qed.

Remark rem_1553 : forall X3:term, auto___type_4 X3 -> auto___type_4 X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1554 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_4 X3 -> auto___type_5 X2 -> auto___type_4 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___type_4 X3 -> auto___type_4 X3). tauto. exact (rem_1553 X3).
Qed.

Remark rem_1555 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_4 X3 -> auto___type_5 X2 -> (auto___def_16 X1 /\ auto___type_5 X2 /\ auto___type_4 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_16 X1). 2:apply (rem_1550 X1 X2 X3);  assumption.
  cut (auto___type_5 X2). 2:apply (rem_1552 X1 X2 X3);  assumption.
  cut (auto___type_4 X3). 2:apply (rem_1554 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_1556 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_4 X3 -> auto___type_5 X2 -> auto___def_40 (nonceb X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  case (rem_1555 X1 X2 X3 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_40_nonceb_2;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1557 : forall X1 X2 X3:term, auto___type_5 X2 -> auto___type_4 X3 -> auto___def_16 X1 -> auto___def_40 (nonceb X1 X2 X3). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_16 X1 -> auto___type_4 X3 -> auto___type_5 X2 -> auto___def_40 (nonceb X1 X2 X3)). tauto. exact (rem_1556 X1 X2 X3).
Qed.

Remark rem_1558 : forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_4 X3 -> auto___type_5 X2 -> auto___def_33 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_33 X1 -> auto___def_33 X1). tauto. exact (rem_923 X1).
Qed.

Remark rem_1559 : forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_4 X3 -> auto___type_5 X2 -> auto___type_5 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___type_5 X2 -> auto___type_5 X2). tauto. exact (rem_1551 X2).
Qed.

Remark rem_1560 : forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_4 X3 -> auto___type_5 X2 -> auto___type_4 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___type_4 X3 -> auto___type_4 X3). tauto. exact (rem_1553 X3).
Qed.

Remark rem_1561 : forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_4 X3 -> auto___type_5 X2 -> (auto___def_33 X1 /\ auto___type_5 X2 /\ auto___type_4 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  cut (auto___def_33 X1). 2:apply (rem_1558 X1 X2 X3);  assumption.
  cut (auto___type_5 X2). 2:apply (rem_1559 X1 X2 X3);  assumption.
  cut (auto___type_4 X3). 2:apply (rem_1560 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_1562 : forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_4 X3 -> auto___type_5 X2 -> auto___def_40 (nonceb X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  case (rem_1561 X1 X2 X3 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_40_nonceb_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1563 : forall X1 X2 X3:term, auto___type_5 X2 -> auto___type_4 X3 -> auto___def_33 X1 -> auto___def_40 (nonceb X1 X2 X3). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_33 X1 -> auto___type_4 X3 -> auto___type_5 X2 -> auto___def_40 (nonceb X1 X2 X3)). tauto. exact (rem_1562 X1 X2 X3).
Qed.

Remark rem_1564 : forall X1 X2 X3:term, auto___def_39 X1 X2 X3 -> or_2
    (auto___type_5 X1 /\ auto___type_4 X2 /\ auto___def_16 X3)
    (auto___type_5 X1 /\ auto___type_4 X2 /\ auto___def_33 X3)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_1565 : forall X1 X2 X3:term, auto___def_39 X2 X3 X1 -> auto___def_40 (nonceb X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1564 X2 X3 X1 H);  intros.
  apply (rem_1557 X1 X2 X3);  tauto.
  apply (rem_1563 X1 X2 X3);  tauto.
Qed.

Remark rem_1566 : forall X1 X2:term, auto___def_16 X2 -> auto___def_42 X1 -> auto___type_7 X2 -> auto___def_42 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_42 X1 -> auto___def_42 X1). tauto. exact (rem_1132 X1).
Qed.

Remark rem_1567 : forall X2:term, auto___def_16 X2 -> auto___type_7 X2. (* Induct. *)
Proof.
  fix epsilon_m__def_16_p__type_7 1.
  intro X. case X.
   intro H. elim (rem_154  H).
   intro H. elim (rem_152  H).
  intros X1 X2. intro H. elim (rem_155 X1 X2 H).
  intros X1 X2. intro H. elim (rem_146 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_157 X1 X2 X3 H).
   intro H. elim (rem_149  H).
  intros X1 X2;  exact (rem_1083 epsilon_m__def_16_p__type_7 X1 X2).
   intro H. elim (rem_148  H).
  intros X1 X2. intro H. elim (rem_160 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_151 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_150 X1 X2 X3 H).
   intro H. elim (rem_156  H).
   intro H. elim (rem_158  H).
  intros X1. intro H. elim (rem_147 X1 H).
   intro H. elim (rem_159  H).
   intro H. elim (rem_153  H).
Qed.

Remark rem_1568 : forall X1 X2:term, auto___def_16 X2 -> auto___def_42 X1 -> auto___type_7 X2 -> auto___type_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_16 X2 -> auto___type_7 X2). tauto. exact (rem_1567 X2).
Qed.

Remark rem_1569 : forall X2:term, auto___def_16 X2 -> auto___def_16 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1570 : forall X1 X2:term, auto___def_16 X2 -> auto___def_42 X1 -> auto___type_7 X2 -> auto___def_16 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_16 X2 -> auto___def_16 X2). tauto. exact (rem_1569 X2).
Qed.

Remark rem_1571 : forall X1 X2:term, auto___def_16 X2 -> auto___def_42 X1 -> auto___type_7 X2 -> (auto___def_42 X1 /\ auto___type_7 X2 /\ auto___def_16 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_42 X1). 2:apply (rem_1566 X1 X2);  assumption.
  cut (auto___type_7 X2). 2:apply (rem_1568 X1 X2);  assumption.
  cut (auto___def_16 X2). 2:apply (rem_1570 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1572 : forall X1 X2:term, auto___def_16 X2 -> auto___def_42 X1 -> auto___type_7 X2 -> auto___def_41 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1571 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_41_10;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1573 : forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto___def_16 X2 -> auto___def_41 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_16 X2 -> auto___def_42 X1 -> auto___type_7 X2 -> auto___def_41 X1 X2). tauto. exact (rem_1572 X1 X2).
Qed.

Remark rem_1574 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_16 X2 -> auto___def_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_12 X1). tauto. exact (rem_1143 X1).
Qed.

Remark rem_1575 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_16 X2 -> auto___def_16 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_16 X2 -> auto___def_16 X2). tauto. exact (rem_1569 X2).
Qed.

Remark rem_1576 : forall X2:term, auto___def_13 X2 -> auto___def_13 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1577 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_16 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_1576 X2).
Qed.

Remark rem_1578 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_16 X2 -> (auto___def_12 X1 /\ auto___def_16 X2 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_12 X1). 2:apply (rem_1574 X1 X2);  assumption.
  cut (auto___def_16 X2). 2:apply (rem_1575 X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_1577 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1579 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_16 X2 -> auto___def_41 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1578 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_41_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1580 : forall X1 X2:term, auto___def_16 X2 -> auto___def_22 X1 -> auto___def_23 X2 -> auto___def_22 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_22 X1 -> auto___def_22 X1). tauto. exact (rem_1151 X1).
Qed.

Remark rem_1581 : forall X1 X2:term, auto___def_16 X2 -> auto___def_22 X1 -> auto___def_23 X2 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_1396 X2).
Qed.

Remark rem_1582 : forall X1 X2:term, auto___def_16 X2 -> auto___def_22 X1 -> auto___def_23 X2 -> auto___def_16 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_16 X2 -> auto___def_16 X2). tauto. exact (rem_1569 X2).
Qed.

Remark rem_1583 : forall X1 X2:term, auto___def_16 X2 -> auto___def_22 X1 -> auto___def_23 X2 -> (auto___def_22 X1 /\ auto___def_23 X2 /\ auto___def_16 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_22 X1). 2:apply (rem_1580 X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_1581 X1 X2);  assumption.
  cut (auto___def_16 X2). 2:apply (rem_1582 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1584 : forall X1 X2:term, auto___def_16 X2 -> auto___def_22 X1 -> auto___def_23 X2 -> auto___def_41 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1583 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_41_2;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1585 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_16 X2 -> auto___def_41 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_16 X2 -> auto___def_22 X1 -> auto___def_23 X2 -> auto___def_41 X1 X2). tauto. exact (rem_1584 X1 X2).
Qed.

Remark rem_1586 : forall X1 X2:term, auto___def_16 X2 -> auto___def_23 X2 -> auto___def_37 X1 -> auto___def_37 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_37 X1 -> auto___def_37 X1). tauto. exact (rem_1159 X1).
Qed.

Remark rem_1587 : forall X1 X2:term, auto___def_16 X2 -> auto___def_23 X2 -> auto___def_37 X1 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_1396 X2).
Qed.

Remark rem_1588 : forall X1 X2:term, auto___def_16 X2 -> auto___def_23 X2 -> auto___def_37 X1 -> auto___def_16 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_16 X2 -> auto___def_16 X2). tauto. exact (rem_1569 X2).
Qed.

Remark rem_1589 : forall X1 X2:term, auto___def_16 X2 -> auto___def_23 X2 -> auto___def_37 X1 -> (auto___def_37 X1 /\ auto___def_23 X2 /\ auto___def_16 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_37 X1). 2:apply (rem_1586 X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_1587 X1 X2);  assumption.
  cut (auto___def_16 X2). 2:apply (rem_1588 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1590 : forall X1 X2:term, auto___def_16 X2 -> auto___def_23 X2 -> auto___def_37 X1 -> auto___def_41 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1589 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_41_3;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1591 : forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto___def_16 X2 -> auto___def_41 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_16 X2 -> auto___def_23 X2 -> auto___def_37 X1 -> auto___def_41 X1 X2). tauto. exact (rem_1590 X1 X2).
Qed.

Remark rem_1592 : forall X1 X2:term, auto___def_16 X2 -> auto_knows X2 -> auto_knows X1 -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows X2 -> auto_knows X2). tauto. exact (rem_1200 X2).
Qed.

Remark rem_1593 : forall X1 X2:term, auto___def_16 X2 -> auto_knows X2 -> auto_knows X1 -> auto___def_16 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_16 X2 -> auto___def_16 X2). tauto. exact (rem_1569 X2).
Qed.

Remark rem_1594 : forall X1 X2:term, auto___def_16 X2 -> auto_knows X2 -> auto_knows X1 -> (auto_knows X1 /\ auto_knows X2 /\ auto___def_16 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto_knows X1). 2:apply (rem_496 X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_1592 X1 X2);  assumption.
  cut (auto___def_16 X2). 2:apply (rem_1593 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1595 : forall X1 X2:term, auto___def_16 X2 -> auto_knows X2 -> auto_knows X1 -> auto___def_41 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1594 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_41_7;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1596 : forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto___def_16 X2 -> auto___def_41 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_16 X2 -> auto_knows X2 -> auto_knows X1 -> auto___def_41 X1 X2). tauto. exact (rem_1595 X1 X2).
Qed.

Remark rem_1597 : forall X1 X2:term, auto___def_16 X2 -> auto___def_40 X1 -> auto___type_6 X2 -> auto___def_40 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_40 X1 -> auto___def_40 X1). tauto. exact (rem_1175 X1).
Qed.

Remark rem_1598 : forall X1 X2:term, auto___def_16 X2 -> auto___def_40 X1 -> auto___type_6 X2 -> auto___def_16 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_16 X2 -> auto___def_16 X2). tauto. exact (rem_1569 X2).
Qed.

Remark rem_1599 : (forall X:term, auto___def_16 X -> auto___type_6 X)
    -> forall X1:term, auto___def_18 X1 -> auto___def_18 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1600 : (forall X:term, auto___def_16 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_18 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_16_p__type_6. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_18 X1). tauto. exact (rem_1599 epsilon_m__def_16_p__type_6 X1).
Defined.

Remark rem_1601 : (forall X:term, auto___def_16 X -> auto___type_6 X)
    -> forall X2:term, auto___def_19 X2 -> auto___def_19 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1602 : (forall X:term, auto___def_16 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_19 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_16_p__type_6. intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_19 X2). tauto. exact (rem_1601 epsilon_m__def_16_p__type_6 X2).
Defined.

Remark rem_1603 : (forall X:term, auto___def_16 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> (auto___def_18 X1 /\ auto___def_19 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_16_p__type_6. intros X1 X2. intros A1 A2.
  cut (auto___def_18 X1). 2:apply (rem_1600 epsilon_m__def_16_p__type_6 X1 X2);  assumption.
  cut (auto___def_19 X2). 2:apply (rem_1602 epsilon_m__def_16_p__type_6 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1604 : (forall X:term, auto___def_16 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___type_6 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_16_p__type_6. intros X1 X2. intros A1 A2.
  case (rem_1603 epsilon_m__def_16_p__type_6 X1 X2 A1 A2). clear  epsilon_m__def_16_p__type_6 A1 A2. intros. apply trans___type_6_key_1;  tauto.
 clear  epsilon_m__def_16_p__type_6 A1 A2. tauto.
Defined.

Remark rem_1605 : (forall X:term, auto___def_16 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_16 (key X1 X2) -> auto___type_6 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_16_p__type_6. intros X1 X2. intro H. intros.
  elim (rem_144 X1 X2 H);  intros.
  apply (rem_1604 epsilon_m__def_16_p__type_6 X1 X2);  tauto.
Defined.

Remark rem_1606 : forall X2:term, auto___def_16 X2 -> auto___type_6 X2. (* Induct. *)
Proof.
  fix epsilon_m__def_16_p__type_6 1.
  intro X. case X.
   intro H. elim (rem_154  H).
   intro H. elim (rem_152  H).
  intros X1 X2. intro H. elim (rem_155 X1 X2 H).
  intros X1 X2. intro H. elim (rem_146 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_157 X1 X2 X3 H).
   intro H. elim (rem_149  H).
  intros X1 X2;  exact (rem_1605 epsilon_m__def_16_p__type_6 X1 X2).
   intro H. elim (rem_148  H).
  intros X1 X2. intro H. elim (rem_160 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_151 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_150 X1 X2 X3 H).
   intro H. elim (rem_156  H).
   intro H. elim (rem_158  H).
  intros X1. intro H. elim (rem_147 X1 H).
   intro H. elim (rem_159  H).
   intro H. elim (rem_153  H).
Qed.

Remark rem_1607 : forall X1 X2:term, auto___def_16 X2 -> auto___def_40 X1 -> auto___type_6 X2 -> auto___type_6 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_16 X2 -> auto___type_6 X2). tauto. exact (rem_1606 X2).
Qed.

Remark rem_1608 : forall X1 X2:term, auto___def_16 X2 -> auto___def_40 X1 -> auto___type_6 X2 -> (auto___def_40 X1 /\ auto___def_16 X2 /\ auto___type_6 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_40 X1). 2:apply (rem_1597 X1 X2);  assumption.
  cut (auto___def_16 X2). 2:apply (rem_1598 X1 X2);  assumption.
  cut (auto___type_6 X2). 2:apply (rem_1607 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1609 : forall X1 X2:term, auto___def_16 X2 -> auto___def_40 X1 -> auto___type_6 X2 -> auto___def_41 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1608 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_41_9;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1610 : forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> auto___def_16 X2 -> auto___def_41 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_16 X2 -> auto___def_40 X1 -> auto___type_6 X2 -> auto___def_41 X1 X2). tauto. exact (rem_1609 X1 X2).
Qed.

Remark rem_1611 : forall X1 X2:term, auto___def_13 X2 -> auto___def_16 X2 -> auto___def_30 X1 -> auto___def_30 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_30 X1 -> auto___def_30 X1). tauto. exact (rem_1186 X1).
Qed.

Remark rem_1612 : forall X1 X2:term, auto___def_13 X2 -> auto___def_16 X2 -> auto___def_30 X1 -> auto___def_16 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_16 X2 -> auto___def_16 X2). tauto. exact (rem_1569 X2).
Qed.

Remark rem_1613 : forall X1 X2:term, auto___def_13 X2 -> auto___def_16 X2 -> auto___def_30 X1 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_1576 X2).
Qed.

Remark rem_1614 : forall X1 X2:term, auto___def_13 X2 -> auto___def_16 X2 -> auto___def_30 X1 -> (auto___def_30 X1 /\ auto___def_16 X2 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_30 X1). 2:apply (rem_1611 X1 X2);  assumption.
  cut (auto___def_16 X2). 2:apply (rem_1612 X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_1613 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1615 : forall X1 X2:term, auto___def_13 X2 -> auto___def_16 X2 -> auto___def_30 X1 -> auto___def_41 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1614 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_41_8;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1616 : forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> auto___def_16 X2 -> auto___def_41 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_16 X2 -> auto___def_30 X1 -> auto___def_41 X1 X2). tauto. exact (rem_1615 X1 X2).
Qed.

Remark rem_1617 : forall X1 X2:term, auto___def_16 X2 -> auto_knows (crypt X1 X2) -> auto___def_41 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_41 X1 X2 H);  intros.
  apply (rem_1573 X1 X2);  tauto.
  apply (rem_1579 X1 X2);  tauto.
  apply (rem_1585 X1 X2);  tauto.
  apply (rem_1591 X1 X2);  tauto.
  apply (rem_1596 X1 X2);  tauto.
  apply (rem_1610 X1 X2);  tauto.
  apply (rem_1616 X1 X2);  tauto.
Qed.

Remark rem_1618 : forall X1 X2 X3:term, auto___def_16 X2 -> auto___type_5 X3 -> auto_agent X3 -> auto_knows (crypt X1 X2) -> auto___def_41 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_16 X2 -> auto_knows (crypt X1 X2) -> auto___def_41 X1 X2). tauto.
  exact (rem_1617 X1 X2).
Qed.

Remark rem_1619 : forall X1 X2 X3:term, auto___type_5 X3 -> auto_agent X3 -> auto___def_16 X2 -> auto_knows (crypt X1 X2) -> auto___def_41 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_16 X2 -> auto___type_5 X3 -> auto_agent X3 -> auto_knows (crypt X1 X2) -> auto___def_41 X1 X2). tauto. exact (rem_1618 X1 X2 X3).
Qed.

Remark rem_1620 : forall X1 X2:term, auto___def_33 X2 -> auto___def_42 X1 -> auto___type_7 X2 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_42 X1 -> auto_knows X1). tauto. exact (rem_910 X1).
Qed.

Remark rem_1621 : forall X2:term, auto___def_33 X2 -> auto_knows X2. (* Induct. *)
Proof.
  fix epsilon_m__def_33_pknows 1.
  intro X. case X.
   intro H. elim (rem_247  H).
   intro H. elim (rem_245  H).
  intros X1 X2. intro H. elim (rem_248 X1 X2 H).
  intros X1 X2. intro H. elim (rem_239 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_250 X1 X2 X3 H).
   intro H. elim (rem_242  H).
  intros X1 X2;  exact (rem_238 epsilon_m__def_33_pknows X1 X2).
   intro H. elim (rem_241  H).
  intros X1 X2. intro H. elim (rem_253 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_244 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_243 X1 X2 X3 H).
   intro H. elim (rem_249  H).
   intro H. elim (rem_251  H).
  intros X1. intro H. elim (rem_240 X1 H).
   intro H. elim (rem_252  H).
   intro H. elim (rem_246  H).
Qed.

Remark rem_1622 : forall X1 X2:term, auto___def_33 X2 -> auto___def_42 X1 -> auto___type_7 X2 -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_33 X2 -> auto_knows X2). tauto. exact (rem_1621 X2).
Qed.

Remark rem_1623 : forall X2:term, auto___def_33 X2 -> auto___def_33 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1624 : forall X1 X2:term, auto___def_33 X2 -> auto___def_42 X1 -> auto___type_7 X2 -> auto___def_33 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_33 X2 -> auto___def_33 X2). tauto. exact (rem_1623 X2).
Qed.

Remark rem_1625 : forall X1 X2:term, auto___def_33 X2 -> auto___def_42 X1 -> auto___type_7 X2 -> (auto_knows X1 /\ auto_knows X2 /\ auto___def_33 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto_knows X1). 2:apply (rem_1620 X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_1622 X1 X2);  assumption.
  cut (auto___def_33 X2). 2:apply (rem_1624 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1626 : forall X1 X2:term, auto___def_33 X2 -> auto___def_42 X1 -> auto___type_7 X2 -> auto___def_41 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1625 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_41_5;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1627 : forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto___def_33 X2 -> auto___def_41 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_33 X2 -> auto___def_42 X1 -> auto___type_7 X2 -> auto___def_41 X1 X2). tauto. exact (rem_1626 X1 X2).
Qed.

Remark rem_1628 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_33 X2 -> auto___def_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_12 X1). tauto. exact (rem_1143 X1).
Qed.

Remark rem_1629 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_33 X2 -> auto___def_33 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_33 X2 -> auto___def_33 X2). tauto. exact (rem_1623 X2).
Qed.

Remark rem_1630 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_33 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_1576 X2).
Qed.

Remark rem_1631 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_33 X2 -> (auto___def_12 X1 /\ auto___def_33 X2 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_12 X1). 2:apply (rem_1628 X1 X2);  assumption.
  cut (auto___def_33 X2). 2:apply (rem_1629 X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_1630 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1632 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_33 X2 -> auto___def_41 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1631 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_41_6;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1633 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_33 X2 -> auto___def_22 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_22 X1 -> auto___def_22 X1). tauto. exact (rem_1151 X1).
Qed.

Remark rem_1634 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_33 X2 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_1396 X2).
Qed.

Remark rem_1635 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_33 X2 -> auto___def_33 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_33 X2 -> auto___def_33 X2). tauto. exact (rem_1623 X2).
Qed.

Remark rem_1636 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_33 X2 -> (auto___def_22 X1 /\ auto___def_23 X2 /\ auto___def_33 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___def_22 X1). 2:apply (rem_1633 X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_1634 X1 X2);  assumption.
  cut (auto___def_33 X2). 2:apply (rem_1635 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1637 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_33 X2 -> auto___def_41 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1636 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_41_4;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1638 : forall X1 X2:term, auto___def_23 X2 -> auto___def_33 X2 -> auto___def_37 X1 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_37 X1 -> auto_knows X1). tauto. exact (rem_437 X1).
Qed.

Remark rem_1639 : forall X1 X2:term, auto___def_23 X2 -> auto___def_33 X2 -> auto___def_37 X1 -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_33 X2 -> auto_knows X2). tauto. exact (rem_1621 X2).
Qed.

Remark rem_1640 : forall X1 X2:term, auto___def_23 X2 -> auto___def_33 X2 -> auto___def_37 X1 -> auto___def_33 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_33 X2 -> auto___def_33 X2). tauto. exact (rem_1623 X2).
Qed.

Remark rem_1641 : forall X1 X2:term, auto___def_23 X2 -> auto___def_33 X2 -> auto___def_37 X1 -> (auto_knows X1 /\ auto_knows X2 /\ auto___def_33 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto_knows X1). 2:apply (rem_1638 X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_1639 X1 X2);  assumption.
  cut (auto___def_33 X2). 2:apply (rem_1640 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1642 : forall X1 X2:term, auto___def_23 X2 -> auto___def_33 X2 -> auto___def_37 X1 -> auto___def_41 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1641 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_41_5;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1643 : forall X1 X2:term, auto___def_37 X1 -> auto___def_23 X2 -> auto___def_33 X2 -> auto___def_41 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_33 X2 -> auto___def_37 X1 -> auto___def_41 X1 X2). tauto. exact (rem_1642 X1 X2).
Qed.

Remark rem_1644 : forall X1 X2:term, auto___def_33 X2 -> auto_knows X2 -> auto_knows X1 -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_33 X2 -> auto_knows X2). tauto. exact (rem_1621 X2).
Qed.

Remark rem_1645 : forall X1 X2:term, auto___def_33 X2 -> auto_knows X2 -> auto_knows X1 -> auto___def_33 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_33 X2 -> auto___def_33 X2). tauto. exact (rem_1623 X2).
Qed.

Remark rem_1646 : forall X1 X2:term, auto___def_33 X2 -> auto_knows X2 -> auto_knows X1 -> (auto_knows X1 /\ auto_knows X2 /\ auto___def_33 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto_knows X1). 2:apply (rem_467 X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_1644 X1 X2);  assumption.
  cut (auto___def_33 X2). 2:apply (rem_1645 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1647 : forall X1 X2:term, auto___def_33 X2 -> auto_knows X2 -> auto_knows X1 -> auto___def_41 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1646 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_41_5;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1648 : forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto___def_33 X2 -> auto___def_41 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_33 X2 -> auto_knows X2 -> auto_knows X1 -> auto___def_41 X1 X2). tauto. exact (rem_1647 X1 X2).
Qed.

Remark rem_1649 : forall X1 X2:term, auto___def_33 X2 -> auto___def_40 X1 -> auto___type_6 X2 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_40 X1 -> auto_knows X1). tauto. exact (rem_885 X1).
Qed.

Remark rem_1650 : forall X1 X2:term, auto___def_33 X2 -> auto___def_40 X1 -> auto___type_6 X2 -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_33 X2 -> auto_knows X2). tauto. exact (rem_1621 X2).
Qed.

Remark rem_1651 : forall X1 X2:term, auto___def_33 X2 -> auto___def_40 X1 -> auto___type_6 X2 -> auto___def_33 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_33 X2 -> auto___def_33 X2). tauto. exact (rem_1623 X2).
Qed.

Remark rem_1652 : forall X1 X2:term, auto___def_33 X2 -> auto___def_40 X1 -> auto___type_6 X2 -> (auto_knows X1 /\ auto_knows X2 /\ auto___def_33 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto_knows X1). 2:apply (rem_1649 X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_1650 X1 X2);  assumption.
  cut (auto___def_33 X2). 2:apply (rem_1651 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1653 : forall X1 X2:term, auto___def_33 X2 -> auto___def_40 X1 -> auto___type_6 X2 -> auto___def_41 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1652 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_41_5;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1654 : forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> auto___def_33 X2 -> auto___def_41 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_33 X2 -> auto___def_40 X1 -> auto___type_6 X2 -> auto___def_41 X1 X2). tauto. exact (rem_1653 X1 X2).
Qed.

Remark rem_1655 : forall X1 X2:term, auto___def_13 X2 -> auto___def_30 X1 -> auto___def_33 X2 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_30 X1 -> auto_knows X1). tauto. exact (rem_849 X1).
Qed.

Remark rem_1656 : forall X1 X2:term, auto___def_13 X2 -> auto___def_30 X1 -> auto___def_33 X2 -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_33 X2 -> auto_knows X2). tauto. exact (rem_1621 X2).
Qed.

Remark rem_1657 : forall X1 X2:term, auto___def_13 X2 -> auto___def_30 X1 -> auto___def_33 X2 -> auto___def_33 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_33 X2 -> auto___def_33 X2). tauto. exact (rem_1623 X2).
Qed.

Remark rem_1658 : forall X1 X2:term, auto___def_13 X2 -> auto___def_30 X1 -> auto___def_33 X2 -> (auto_knows X1 /\ auto_knows X2 /\ auto___def_33 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto_knows X1). 2:apply (rem_1655 X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_1656 X1 X2);  assumption.
  cut (auto___def_33 X2). 2:apply (rem_1657 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1659 : forall X1 X2:term, auto___def_13 X2 -> auto___def_30 X1 -> auto___def_33 X2 -> auto___def_41 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1658 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_41_5;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1660 : forall X1 X2:term, auto___def_30 X1 -> auto___def_13 X2 -> auto___def_33 X2 -> auto___def_41 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_30 X1 -> auto___def_33 X2 -> auto___def_41 X1 X2). tauto. exact (rem_1659 X1 X2).
Qed.

Remark rem_1661 : forall X1 X2:term, auto___def_33 X2 -> auto_knows (crypt X1 X2) -> auto___def_41 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_41 X1 X2 H);  intros.
  apply (rem_1627 X1 X2);  tauto.
  apply (rem_1632 X1 X2);  tauto.
  apply (rem_1637 X1 X2);  tauto.
  apply (rem_1643 X1 X2);  tauto.
  apply (rem_1648 X1 X2);  tauto.
  apply (rem_1654 X1 X2);  tauto.
  apply (rem_1660 X1 X2);  tauto.
Qed.

Remark rem_1662 : forall X1 X2 X3:term, auto___def_33 X2 -> auto___type_5 X3 -> auto_agent X3 -> auto_knows (crypt X1 X2) -> auto___def_41 X1 X2. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_33 X2 -> auto_knows (crypt X1 X2) -> auto___def_41 X1 X2). tauto.
  exact (rem_1661 X1 X2).
Qed.

Remark rem_1663 : forall X1 X2 X3:term, auto___type_5 X3 -> auto_agent X3 -> auto___def_33 X2 -> auto_knows (crypt X1 X2) -> auto___def_41 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_33 X2 -> auto___type_5 X3 -> auto_agent X3 -> auto_knows (crypt X1 X2) -> auto___def_41 X1 X2). tauto. exact (rem_1662 X1 X2 X3).
Qed.

Remark rem_1664 : forall X1 X2:term, auto_alice_key X1 X2 -> or_2
    (auto___type_5 X1 /\ auto_agent X1 /\ auto___def_16 X2)
    (auto___type_5 X1 /\ auto_agent X1 /\ auto___def_33 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_1665 : forall X1 X2 X3:term, auto_alice_key X3 X2 -> auto_knows (crypt X1 X2) -> auto___def_41 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1664 X3 X2 H);  intros.
  apply (rem_1619 X1 X2 X3);  tauto.
  apply (rem_1663 X1 X2 X3);  tauto.
Qed.

Remark rem_1666 : forall X1 X2 X3:term, auto_knows (crypt X1 X2) -> auto_alice_key X3 X2 -> auto___def_41 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_alice_key X3 X2 -> auto_knows (crypt X1 X2) -> auto___def_41 X1 X2). tauto. exact (rem_1665 X1 X2 X3).
Qed.

Remark rem_1667 : auto___def_45 i. (* Deduce positive atom. *)
Proof.
   case rem_1393. intros. apply trans___def_45_i_1;  tauto.
 tauto.
Qed.

Remark rem_1668 : auto___def_46 sym. (* Deduce positive atom. *)
Proof.
   case rem_1393. intros. apply trans___def_46_sym_1;  tauto.
 tauto.
Qed.

Remark rem_1669 : forall X1 X2:term, auto___def_18 X1 -> auto___def_25 X2 -> auto___def_18 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_18 X1). tauto. exact (rem_1119 X1).
Qed.

Remark rem_1670 : forall X1 X2:term, auto___def_18 X1 -> auto___def_25 X2 -> auto___def_25 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_25 X2 -> auto___def_25 X2). tauto. exact (rem_1153 X2).
Qed.

Remark rem_1671 : forall X1 X2:term, auto___def_18 X1 -> auto___def_25 X2 -> (auto___def_18 X1 /\ auto___def_25 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_18 X1). 2:apply (rem_1669 X1 X2);  assumption.
  cut (auto___def_25 X2). 2:apply (rem_1670 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1672 : forall X1 X2:term, auto___def_18 X1 -> auto___def_25 X2 -> auto___def_23 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1671 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_23_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1673 : forall X1 X2:term, auto___def_25 X2 -> auto___def_18 X1 -> auto___def_23 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_25 X2 -> auto___def_23 (key X1 X2)). tauto. exact (rem_1672 X1 X2).
Qed.

Remark rem_1674 : forall X1 X2:term, auto___def_42 X2 -> auto___type_7 (key pub X1) -> auto___type_8 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_8_1. Qed.

Remark rem_1675 : forall X2:term, auto___def_42 X2 -> auto_knows X2. (* Induct. *)
Proof.
  fix epsilon_m__def_42_pknows 1.
  intro X. case X.
   intro H. elim (rem_903  H).
   intro H. elim (rem_900  H).
  intros X1 X2. intro H. elim (rem_904 X1 X2 H).
  intros X1 X2. intro H. elim (rem_895 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_906 X1 X2 X3 H).
   intro H. elim (rem_897  H).
  intros X1 X2. intro H. elim (rem_901 X1 X2 H).
   intro H. elim (rem_896  H).
  intros X1 X2. intro H. elim (rem_909 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_899 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_898 X1 X2 X3 H).
   intro H. elim (rem_905  H).
   intro H. elim (rem_907  H).
  intros X1;  exact (rem_894 epsilon_m__def_42_pknows X1).
   intro H. elim (rem_908  H).
   intro H. elim (rem_902  H).
Qed.

Remark rem_1676 : forall X1 X2:term, auto___def_42 X2 -> auto___type_7 (key pub X1) -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_42 X2 -> auto_knows X2). tauto. exact (rem_1675 X2).
Qed.

Remark rem_1677 : forall X1 X2:term, auto___def_42 X2 -> auto___type_7 (key pub X1) -> (auto___type_8 X1 /\ auto_knows X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_8 X1). 2:apply (rem_1674 X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_1676 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1678 : forall X1 X2:term, auto___def_42 X2 -> auto___type_7 (key pub X1) -> auto___def_1 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1677 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_1_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1679 : auto___def_18 pub -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_207 H);  intros.
Qed.

Remark rem_1680 : forall X1 X2:term, auto___def_12 X2 -> auto___def_18 pub -> auto___def_29 X1 -> auto___def_1 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 pub -> False). tauto.
  exact (rem_1679).
Qed.

Remark rem_1681 : forall X1 X2:term, auto___def_18 pub -> auto___def_29 X1 -> auto___def_12 X2 -> auto___def_1 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_12 X2 -> auto___def_18 pub -> auto___def_29 X1 -> auto___def_1 X1 X2). tauto. exact (rem_1680 X1 X2).
Qed.

Remark rem_1682 : forall X1 X2:term, auto___def_12 X2 -> auto___def_13 (key pub X1) -> auto___def_1 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_142 pub X1 H);  intros.
  apply (rem_1681 X1 X2);  tauto.
Qed.

Remark rem_1683 : forall X1 X2:term, auto___def_18 pub -> auto___def_22 X2 -> auto___def_25 X1 -> auto___def_1 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 pub -> False). tauto.
  exact (rem_1679).
Qed.

Remark rem_1684 : forall X1 X2:term, auto___def_18 pub -> auto___def_25 X1 -> auto___def_22 X2 -> auto___def_1 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_18 pub -> auto___def_22 X2 -> auto___def_25 X1 -> auto___def_1 X1 X2). tauto. exact (rem_1683 X1 X2).
Qed.

Remark rem_1685 : forall X1 X2:term, auto___def_22 X2 -> auto___def_23 (key pub X1) -> auto___def_1 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_171 pub X1 H);  intros.
  apply (rem_1684 X1 X2);  tauto.
Qed.

Remark rem_1686 : forall X1 X2:term, auto___def_23 (key pub X1) -> auto___def_37 X2 -> auto___type_8 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_8_1. Qed.

Remark rem_1687 : forall X2:term, auto___def_37 X2 -> auto_knows X2. (* Induct. *)
Proof.
  fix epsilon_m__def_37_pknows 1.
  intro X. case X.
   intro H. elim (rem_431  H).
   intro H. elim (rem_428  H).
  intros X1 X2;  exact (rem_421 epsilon_m__def_37_pknows X1 X2).
  intros X1 X2. intro H. elim (rem_422 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_433 X1 X2 X3 H).
   intro H. elim (rem_425  H).
  intros X1 X2. intro H. elim (rem_429 X1 X2 H).
   intro H. elim (rem_424  H).
  intros X1 X2. intro H. elim (rem_436 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_427 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_426 X1 X2 X3 H).
   intro H. elim (rem_432  H).
   intro H. elim (rem_434  H).
  intros X1. intro H. elim (rem_423 X1 H).
   intro H. elim (rem_435  H).
   intro H. elim (rem_430  H).
Qed.

Remark rem_1688 : forall X1 X2:term, auto___def_23 (key pub X1) -> auto___def_37 X2 -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_37 X2 -> auto_knows X2). tauto. exact (rem_1687 X2).
Qed.

Remark rem_1689 : forall X1 X2:term, auto___def_23 (key pub X1) -> auto___def_37 X2 -> (auto___type_8 X1 /\ auto_knows X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_8 X1). 2:apply (rem_1686 X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_1688 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1690 : forall X1 X2:term, auto___def_23 (key pub X1) -> auto___def_37 X2 -> auto___def_1 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1689 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_1_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1691 : forall X1 X2:term, auto___def_37 X2 -> auto___def_23 (key pub X1) -> auto___def_1 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_23 (key pub X1) -> auto___def_37 X2 -> auto___def_1 X1 X2). tauto. exact (rem_1690 X1 X2).
Qed.

Remark rem_1692 : forall X1 X2:term, auto_knows X2 -> auto_knows (key pub X1) -> auto___type_8 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_8_1. Qed.

Remark rem_1693 : forall X1 X2:term, auto_knows X2 -> auto_knows (key pub X1) -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows X2 -> auto_knows X2). tauto. exact (rem_1200 X2).
Qed.

Remark rem_1694 : forall X1 X2:term, auto_knows X2 -> auto_knows (key pub X1) -> (auto___type_8 X1 /\ auto_knows X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_8 X1). 2:apply (rem_1692 X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_1693 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1695 : forall X1 X2:term, auto_knows X2 -> auto_knows (key pub X1) -> auto___def_1 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1694 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_1_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1696 : forall X1 X2:term, auto___def_40 X2 -> auto___type_6 (key pub X1) -> auto___type_8 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_8_1. Qed.

Remark rem_1697 : forall X2:term, auto___def_40 X2 -> auto_knows X2. (* Induct. *)
Proof.
  fix epsilon_m__def_40_pknows 1.
  intro X. case X.
   intro H. elim (rem_878  H).
   intro H. elim (rem_875  H).
  intros X1 X2. intro H. elim (rem_879 X1 X2 H).
  intros X1 X2. intro H. elim (rem_870 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_881 X1 X2 X3 H).
   intro H. elim (rem_873  H).
  intros X1 X2. intro H. elim (rem_876 X1 X2 H).
   intro H. elim (rem_872  H).
  intros X1 X2. intro H. elim (rem_884 X1 X2 H).
  intros X1 X2 X3;  exact (rem_869 epsilon_m__def_40_pknows X1 X2 X3).
  intros X1 X2 X3. intro H. elim (rem_874 X1 X2 X3 H).
   intro H. elim (rem_880  H).
   intro H. elim (rem_882  H).
  intros X1. intro H. elim (rem_871 X1 H).
   intro H. elim (rem_883  H).
   intro H. elim (rem_877  H).
Qed.

Remark rem_1698 : forall X1 X2:term, auto___def_40 X2 -> auto___type_6 (key pub X1) -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_40 X2 -> auto_knows X2). tauto. exact (rem_1697 X2).
Qed.

Remark rem_1699 : forall X1 X2:term, auto___def_40 X2 -> auto___type_6 (key pub X1) -> (auto___type_8 X1 /\ auto_knows X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_8 X1). 2:apply (rem_1696 X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_1698 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1700 : forall X1 X2:term, auto___def_40 X2 -> auto___type_6 (key pub X1) -> auto___def_1 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1699 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_1_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1701 : forall X1 X2:term, auto___def_13 (key pub X1) -> auto___def_30 X2 -> auto___type_8 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_8_1. Qed.

Remark rem_1702 : forall X2:term, auto___def_30 X2 -> auto_knows X2. (* Induct. *)
Proof.
  fix epsilon_m__def_30_pknows 1.
  intro X. case X.
   intro H. elim (rem_843  H).
   intro H. elim (rem_840  H).
  intros X1 X2;  exact (rem_833 epsilon_m__def_30_pknows X1 X2).
  intros X1 X2. intro H. elim (rem_834 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_845 X1 X2 X3 H).
   intro H. elim (rem_837  H).
  intros X1 X2. intro H. elim (rem_841 X1 X2 H).
   intro H. elim (rem_836  H).
  intros X1 X2. intro H. elim (rem_848 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_839 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_838 X1 X2 X3 H).
   intro H. elim (rem_844  H).
   intro H. elim (rem_846  H).
  intros X1. intro H. elim (rem_835 X1 H).
   intro H. elim (rem_847  H).
   intro H. elim (rem_842  H).
Qed.

Remark rem_1703 : forall X1 X2:term, auto___def_13 (key pub X1) -> auto___def_30 X2 -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_30 X2 -> auto_knows X2). tauto. exact (rem_1702 X2).
Qed.

Remark rem_1704 : forall X1 X2:term, auto___def_13 (key pub X1) -> auto___def_30 X2 -> (auto___type_8 X1 /\ auto_knows X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_8 X1). 2:apply (rem_1701 X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_1703 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1705 : forall X1 X2:term, auto___def_13 (key pub X1) -> auto___def_30 X2 -> auto___def_1 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1704 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_1_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1706 : forall X1 X2:term, auto___def_30 X2 -> auto___def_13 (key pub X1) -> auto___def_1 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_13 (key pub X1) -> auto___def_30 X2 -> auto___def_1 X1 X2). tauto. exact (rem_1705 X1 X2).
Qed.

Remark rem_1707 : forall X1 X2:term, auto_knows (crypt X2 (key pub X1)) -> auto___def_1 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_41 X2 (key pub X1) H);  intros.
  apply (rem_1678 X1 X2);  tauto.
  apply (rem_1682 X1 X2);  tauto.
  apply (rem_1685 X1 X2);  tauto.
  apply (rem_1691 X1 X2);  tauto.
  apply (rem_1695 X1 X2);  tauto.
  apply (rem_1700 X1 X2);  tauto.
  apply (rem_1706 X1 X2);  tauto.
Qed.

Remark rem_1708 : auto___def_10 nil. (* Deduce positive atom. *)
Proof.
   case rem_1393. intros. apply trans___def_10_nil_1;  tauto.
 tauto.
Qed.

Remark rem_1709 : forall X1 X2 X3:term, auto___def_42 (cons X3 (cons X1 nil)) -> auto___type_7 (key sym (cons X2 (cons server nil))) -> auto___def_39 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_904 X3 (cons X1 nil) H);  intros.
Qed.

Remark rem_1710 : auto___def_15 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1711 : auto___def_15 nil -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_1710 H);  intros.
Qed.

Remark rem_1712 : forall X1 X2 X3:term, auto___def_15 nil -> auto___def_29 (cons X2 (cons server nil)) -> auto___type_3 X3 -> auto___type_4 X1 -> auto___def_39 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_15 nil -> False). tauto.
  exact (rem_1711).
Qed.

Remark rem_1713 : forall X1 X2 X3:term, auto___type_4 X1 -> auto___def_15 nil -> auto___def_29 (cons X2 (cons server nil)) -> auto___type_3 X3 -> auto___def_39 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_15 nil -> auto___def_29 (cons X2 (cons server nil)) -> auto___type_3 X3 -> auto___type_4 X1 -> auto___def_39 X1 X2 X3). tauto. exact (rem_1712 X1 X2 X3).
Qed.

Remark rem_1714 : forall X1 X2 X3:term, auto___def_14 (cons X1 nil) -> auto___def_29 (cons X2 (cons server nil)) -> auto___type_3 X3 -> auto___def_39 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_955 X1 nil H);  intros.
  apply (rem_1713 X1 X2 X3);  tauto.
Qed.

Remark rem_1715 : forall X1 X2 X3:term, auto___def_14 (cons X1 nil) -> auto___def_18 sym -> auto___def_29 (cons X2 (cons server nil)) -> auto___type_3 X3 -> auto___def_39 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_14 (cons X1 nil) -> auto___def_29 (cons X2 (cons server nil)) -> auto___type_3 X3 -> auto___def_39 X1 X2 X3). tauto.
  exact (rem_1714 X1 X2 X3).
Qed.

Remark rem_1716 : forall X1 X2 X3:term, auto___def_18 sym -> auto___def_29 (cons X2 (cons server nil)) -> auto___def_14 (cons X1 nil) -> auto___type_3 X3 -> auto___def_39 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_14 (cons X1 nil) -> auto___def_18 sym -> auto___def_29 (cons X2 (cons server nil)) -> auto___type_3 X3 -> auto___def_39 X1 X2 X3). tauto. exact (rem_1715 X1 X2 X3).
Qed.

Remark rem_1717 : forall X1 X2 X3:term, auto___def_13 (key sym (cons X2 (cons server nil))) -> auto___def_14 (cons X1 nil) -> auto___type_3 X3 -> auto___def_39 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_142 sym (cons X2 (cons server nil)) H);  intros.
  apply (rem_1716 X1 X2 X3);  tauto.
Qed.

Remark rem_1718 : forall X1 X2 X3:term, auto___type_3 X3 -> auto___def_14 (cons X1 nil) -> auto___def_13 (key sym (cons X2 (cons server nil))) -> auto___def_39 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_13 (key sym (cons X2 (cons server nil))) -> auto___def_14 (cons X1 nil) -> auto___type_3 X3 -> auto___def_39 X1 X2 X3). tauto. exact (rem_1717 X1 X2 X3).
Qed.

Remark rem_1719 : forall X1 X2 X3:term, auto___def_12 (cons X3 (cons X1 nil)) -> auto___def_13 (key sym (cons X2 (cons server nil))) -> auto___def_39 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_961 X3 (cons X1 nil) H);  intros.
  apply (rem_1718 X1 X2 X3);  tauto.
Qed.

Remark rem_1720 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_26 (cons server nil) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___type_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___type_5 X1 -> auto___type_5 X1). tauto. exact (rem_917 X1).
Qed.

Remark rem_1721 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_26 (cons server nil) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___type_4 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___type_4 X2 -> auto___type_4 X2). tauto. exact (rem_933 X2).
Qed.

Remark rem_1722 : forall X3:term, auto___def_16 X3 -> auto___def_16 X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1723 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_26 (cons server nil) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_16 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_16 X3 -> auto___def_16 X3). tauto. exact (rem_1722 X3).
Qed.

Remark rem_1724 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_26 (cons server nil) -> auto___type_4 X2 -> auto___type_5 X1 -> (auto___type_5 X1 /\ auto___type_4 X2 /\ auto___def_16 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  cut (auto___type_5 X1). 2:apply (rem_1720 X1 X2 X3);  assumption.
  cut (auto___type_4 X2). 2:apply (rem_1721 X1 X2 X3);  assumption.
  cut (auto___def_16 X3). 2:apply (rem_1723 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_1725 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_26 (cons server nil) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_39 X1 X2 X3. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  case (rem_1724 X1 X2 X3 A1 A2 A3 A4). clear  A1 A2 A3 A4. intros. apply trans___def_39_1;  tauto.
 clear  A1 A2 A3 A4. tauto.
Qed.

Remark rem_1726 : forall X1 X2 X3:term, auto___type_4 X2 -> auto___def_26 (cons server nil) -> auto___def_16 X3 -> auto___type_5 X1 -> auto___def_39 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_16 X3 -> auto___def_26 (cons server nil) -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_39 X1 X2 X3). tauto. exact (rem_1725 X1 X2 X3).
Qed.

Remark rem_1727 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_25 (cons X2 (cons server nil)) -> auto___type_5 X1 -> auto___def_39 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_443 X2 (cons server nil) H);  intros.
  apply (rem_1726 X1 X2 X3);  tauto.
Qed.

Remark rem_1728 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_21 nil -> auto___def_25 (cons X2 (cons server nil)) -> auto___type_5 X1 -> auto___def_39 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_16 X3 -> auto___def_25 (cons X2 (cons server nil)) -> auto___type_5 X1 -> auto___def_39 X1 X2 X3). tauto.
  exact (rem_1727 X1 X2 X3).
Qed.

Remark rem_1729 : forall X1 X2 X3:term, auto___type_5 X1 -> auto___def_21 nil -> auto___def_16 X3 -> auto___def_25 (cons X2 (cons server nil)) -> auto___def_39 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_16 X3 -> auto___def_21 nil -> auto___def_25 (cons X2 (cons server nil)) -> auto___type_5 X1 -> auto___def_39 X1 X2 X3). tauto. exact (rem_1728 X1 X2 X3).
Qed.

Remark rem_1730 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_24 (cons X1 nil) -> auto___def_25 (cons X2 (cons server nil)) -> auto___def_39 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_398 X1 nil H);  intros.
  apply (rem_1729 X1 X2 X3);  tauto.
Qed.

Remark rem_1731 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_18 sym -> auto___def_24 (cons X1 nil) -> auto___def_25 (cons X2 (cons server nil)) -> auto___def_39 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_16 X3 -> auto___def_24 (cons X1 nil) -> auto___def_25 (cons X2 (cons server nil)) -> auto___def_39 X1 X2 X3). tauto.
  exact (rem_1730 X1 X2 X3).
Qed.

Remark rem_1732 : forall X1 X2 X3:term, auto___def_18 sym -> auto___def_25 (cons X2 (cons server nil)) -> auto___def_16 X3 -> auto___def_24 (cons X1 nil) -> auto___def_39 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_16 X3 -> auto___def_18 sym -> auto___def_24 (cons X1 nil) -> auto___def_25 (cons X2 (cons server nil)) -> auto___def_39 X1 X2 X3). tauto. exact (rem_1731 X1 X2 X3).
Qed.

Remark rem_1733 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_23 (key sym (cons X2 (cons server nil))) -> auto___def_24 (cons X1 nil) -> auto___def_39 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_171 sym (cons X2 (cons server nil)) H);  intros.
  apply (rem_1732 X1 X2 X3);  tauto.
Qed.

Remark rem_1734 : forall X1 X2 X3:term, auto___def_16 X3 -> auto___def_24 (cons X1 nil) -> auto___def_23 (key sym (cons X2 (cons server nil))) -> auto___def_39 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_16 X3 -> auto___def_23 (key sym (cons X2 (cons server nil))) -> auto___def_24 (cons X1 nil) -> auto___def_39 X1 X2 X3). tauto. exact (rem_1733 X1 X2 X3).
Qed.

Remark rem_1735 : forall X1 X2 X3:term, auto___def_22 (cons X3 (cons X1 nil)) -> auto___def_23 (key sym (cons X2 (cons server nil))) -> auto___def_39 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_965 X3 (cons X1 nil) H);  intros.
  apply (rem_1734 X1 X2 X3);  tauto.
Qed.

Remark rem_1736 : forall X1 X2 X3:term, auto___def_21 nil -> auto___def_33 X3 -> auto___type_4 X2 -> auto___type_5 X1 -> auto___type_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___type_5 X1 -> auto___type_5 X1). tauto. exact (rem_917 X1).
Qed.

Remark rem_1737 : forall X1 X2 X3:term, auto___def_21 nil -> auto___def_33 X3 -> auto___type_4 X2 -> auto___type_5 X1 -> auto___type_4 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___type_4 X2 -> auto___type_4 X2). tauto. exact (rem_933 X2).
Qed.

Remark rem_1738 : forall X3:term, auto___def_33 X3 -> auto___def_33 X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1739 : forall X1 X2 X3:term, auto___def_21 nil -> auto___def_33 X3 -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_33 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_33 X3 -> auto___def_33 X3). tauto. exact (rem_1738 X3).
Qed.

Remark rem_1740 : forall X1 X2 X3:term, auto___def_21 nil -> auto___def_33 X3 -> auto___type_4 X2 -> auto___type_5 X1 -> (auto___type_5 X1 /\ auto___type_4 X2 /\ auto___def_33 X3) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  cut (auto___type_5 X1). 2:apply (rem_1736 X1 X2 X3);  assumption.
  cut (auto___type_4 X2). 2:apply (rem_1737 X1 X2 X3);  assumption.
  cut (auto___def_33 X3). 2:apply (rem_1739 X1 X2 X3);  assumption.
  tauto.
Qed.

Remark rem_1741 : forall X1 X2 X3:term, auto___def_21 nil -> auto___def_33 X3 -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_39 X1 X2 X3. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3 A4.
  case (rem_1740 X1 X2 X3 A1 A2 A3 A4). clear  A1 A2 A3 A4. intros. apply trans___def_39_2;  tauto.
 clear  A1 A2 A3 A4. tauto.
Qed.

Remark rem_1742 : forall X1 X2 X3:term, auto___type_5 X1 -> auto___def_21 nil -> auto___def_33 X3 -> auto___type_4 X2 -> auto___def_39 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_21 nil -> auto___def_33 X3 -> auto___type_4 X2 -> auto___type_5 X1 -> auto___def_39 X1 X2 X3). tauto. exact (rem_1741 X1 X2 X3).
Qed.

Remark rem_1743 : forall X1 X2 X3:term, auto___def_24 (cons X1 nil) -> auto___def_33 X3 -> auto___type_4 X2 -> auto___def_39 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_398 X1 nil H);  intros.
  apply (rem_1742 X1 X2 X3);  tauto.
Qed.

Remark rem_1744 : forall X1 X2 X3:term, auto___def_33 X3 -> auto___def_24 (cons X1 nil) -> auto___type_4 X2 -> auto___def_39 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_24 (cons X1 nil) -> auto___def_33 X3 -> auto___type_4 X2 -> auto___def_39 X1 X2 X3). tauto. exact (rem_1743 X1 X2 X3).
Qed.

Remark rem_1745 : forall X1 X2 X3:term, auto___def_37 (cons X3 (cons X1 nil)) -> auto___type_4 X2 -> auto___def_39 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_420 X3 (cons X1 nil) H);  intros.
  apply (rem_1744 X1 X2 X3);  tauto.
Qed.

Remark rem_1746 : forall X1 X2 X3:term, auto___def_26 (cons server nil) -> auto___def_37 (cons X3 (cons X1 nil)) -> auto___type_4 X2 -> auto___def_39 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_37 (cons X3 (cons X1 nil)) -> auto___type_4 X2 -> auto___def_39 X1 X2 X3). tauto.
  exact (rem_1745 X1 X2 X3).
Qed.

Remark rem_1747 : forall X1 X2 X3:term, auto___type_4 X2 -> auto___def_26 (cons server nil) -> auto___def_37 (cons X3 (cons X1 nil)) -> auto___def_39 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_26 (cons server nil) -> auto___def_37 (cons X3 (cons X1 nil)) -> auto___type_4 X2 -> auto___def_39 X1 X2 X3). tauto. exact (rem_1746 X1 X2 X3).
Qed.

Remark rem_1748 : forall X1 X2 X3:term, auto___def_25 (cons X2 (cons server nil)) -> auto___def_37 (cons X3 (cons X1 nil)) -> auto___def_39 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_443 X2 (cons server nil) H);  intros.
  apply (rem_1747 X1 X2 X3);  tauto.
Qed.

Remark rem_1749 : forall X1 X2 X3:term, auto___def_18 sym -> auto___def_25 (cons X2 (cons server nil)) -> auto___def_37 (cons X3 (cons X1 nil)) -> auto___def_39 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_25 (cons X2 (cons server nil)) -> auto___def_37 (cons X3 (cons X1 nil)) -> auto___def_39 X1 X2 X3). tauto.
  exact (rem_1748 X1 X2 X3).
Qed.

Remark rem_1750 : forall X1 X2 X3:term, auto___def_23 (key sym (cons X2 (cons server nil))) -> auto___def_37 (cons X3 (cons X1 nil)) -> auto___def_39 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_171 sym (cons X2 (cons server nil)) H);  intros.
  apply (rem_1749 X1 X2 X3);  tauto.
Qed.

Remark rem_1751 : forall X1 X2 X3:term, auto___def_37 (cons X3 (cons X1 nil)) -> auto___def_23 (key sym (cons X2 (cons server nil))) -> auto___def_39 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_23 (key sym (cons X2 (cons server nil))) -> auto___def_37 (cons X3 (cons X1 nil)) -> auto___def_39 X1 X2 X3). tauto. exact (rem_1750 X1 X2 X3).
Qed.

Remark rem_1752 : forall X1 X2 X3:term, auto___def_43 sym -> auto_knows X1 -> auto_knows X3 -> auto___def_39 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_43 sym -> False). tauto.
  exact (rem_979).
Qed.

Remark rem_1753 : forall X1 X2 X3:term, auto___def_43 sym -> auto___type_8 (cons X2 (cons server nil)) -> auto_knows X1 -> auto_knows X3 -> auto___def_39 X1 X2 X3. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2 X3. intros. apply (rem_1752 X1 X2 X3);  assumption.
Qed.

Remark rem_1754 : forall X1 X2 X3:term, auto___def_47 (cons X2 (cons server nil)) -> auto_knows X1 -> auto_knows X3 -> auto___def_39 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_982 X2 (cons server nil) H);  intros.
Qed.

Remark rem_1755 : forall X1 X2 X3:term, auto___def_46 sym -> auto___def_47 (cons X2 (cons server nil)) -> auto_knows X1 -> auto_knows X3 -> auto___def_39 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_47 (cons X2 (cons server nil)) -> auto_knows X1 -> auto_knows X3 -> auto___def_39 X1 X2 X3). tauto.
  exact (rem_1754 X1 X2 X3).
Qed.

Remark rem_1756 : forall X1 X2 X3:term, auto___def_45 (cons X2 (cons server nil)) -> auto_knows X1 -> auto_knows X3 -> auto___def_39 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_985 X2 (cons server nil) H);  intros.
Qed.

Remark rem_1757 : forall X1 X2 X3:term, auto___def_44 sym -> auto___def_45 (cons X2 (cons server nil)) -> auto_knows X1 -> auto_knows X3 -> auto___def_39 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_45 (cons X2 (cons server nil)) -> auto_knows X1 -> auto_knows X3 -> auto___def_39 X1 X2 X3). tauto.
  exact (rem_1756 X1 X2 X3).
Qed.

Remark rem_1758 : forall X1 X2 X3:term, auto_knows X1 -> auto_knows X3 -> auto_knows (key sym (cons X2 (cons server nil))) -> auto___def_39 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1 H2. intro H. intros.
  elim (rem_91 sym (cons X2 (cons server nil)) H);  intros.
  apply (rem_1753 X1 X2 X3);  tauto.
  apply (rem_1755 X1 X2 X3);  tauto.
  apply (rem_1757 X1 X2 X3);  tauto.
Qed.

Remark rem_1759 : forall X1 X2 X3:term, auto_knows X1 -> auto_knows X3 -> auto_knows (key sym (cons X2 (cons server nil))) -> auto_knows nil -> auto___def_39 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto_knows X1 -> auto_knows X3 -> auto_knows (key sym (cons X2 (cons server nil))) -> auto___def_39 X1 X2 X3). tauto.
  exact (rem_1758 X1 X2 X3).
Qed.

Remark rem_1760 : forall X1 X2 X3:term, auto_knows X1 -> auto_knows nil -> auto_knows X3 -> auto_knows (key sym (cons X2 (cons server nil))) -> auto___def_39 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_knows X1 -> auto_knows X3 -> auto_knows (key sym (cons X2 (cons server nil))) -> auto_knows nil -> auto___def_39 X1 X2 X3). tauto. exact (rem_1759 X1 X2 X3).
Qed.

Remark rem_1761 : forall X1 X2 X3:term, auto_knows X3 -> auto_knows (cons X1 nil) -> auto_knows (key sym (cons X2 (cons server nil))) -> auto___def_39 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intros H1. intro H. intros.
  elim (rem_97 X1 nil H);  intros.
  apply (rem_1760 X1 X2 X3);  tauto.
Qed.

Remark rem_1762 : forall X1 X2 X3:term, auto_knows (cons X3 (cons X1 nil)) -> auto_knows (key sym (cons X2 (cons server nil))) -> auto___def_39 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_97 X3 (cons X1 nil) H);  intros.
  apply (rem_1761 X1 X2 X3);  tauto.
Qed.

Remark rem_1763 : forall X1 X2 X3:term, auto___def_40 (cons X3 (cons X1 nil)) -> auto___type_6 (key sym (cons X2 (cons server nil))) -> auto___def_39 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_879 X3 (cons X1 nil) H);  intros.
Qed.

Remark rem_1764 : auto___def_32 nil -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_792 H);  intros.
Qed.

Remark rem_1765 : forall X1 X2 X3:term, auto___def_32 nil -> auto___type_3 X3 -> auto___type_4 X1 -> auto___type_5 X2 -> auto___def_39 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_32 nil -> False). tauto.
  exact (rem_1764).
Qed.

Remark rem_1766 : forall X1 X2 X3:term, auto___type_4 X1 -> auto___def_32 nil -> auto___type_3 X3 -> auto___type_5 X2 -> auto___def_39 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_32 nil -> auto___type_3 X3 -> auto___type_4 X1 -> auto___type_5 X2 -> auto___def_39 X1 X2 X3). tauto. exact (rem_1765 X1 X2 X3).
Qed.

Remark rem_1767 : forall X1 X2 X3:term, auto___def_31 (cons X1 nil) -> auto___type_3 X3 -> auto___type_5 X2 -> auto___def_39 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_810 X1 nil H);  intros.
  apply (rem_1766 X1 X2 X3);  tauto.
Qed.

Remark rem_1768 : forall X1 X2 X3:term, auto___type_3 X3 -> auto___def_31 (cons X1 nil) -> auto___type_5 X2 -> auto___def_39 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_31 (cons X1 nil) -> auto___type_3 X3 -> auto___type_5 X2 -> auto___def_39 X1 X2 X3). tauto. exact (rem_1767 X1 X2 X3).
Qed.

Remark rem_1769 : forall X1 X2 X3:term, auto___def_30 (cons X3 (cons X1 nil)) -> auto___type_5 X2 -> auto___def_39 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_832 X3 (cons X1 nil) H);  intros.
  apply (rem_1768 X1 X2 X3);  tauto.
Qed.

Remark rem_1770 : forall X1 X2 X3:term, auto___def_26 (cons server nil) -> auto___def_30 (cons X3 (cons X1 nil)) -> auto___type_5 X2 -> auto___def_39 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_30 (cons X3 (cons X1 nil)) -> auto___type_5 X2 -> auto___def_39 X1 X2 X3). tauto.
  exact (rem_1769 X1 X2 X3).
Qed.

Remark rem_1771 : forall X1 X2 X3:term, auto___type_5 X2 -> auto___def_26 (cons server nil) -> auto___def_30 (cons X3 (cons X1 nil)) -> auto___def_39 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_26 (cons server nil) -> auto___def_30 (cons X3 (cons X1 nil)) -> auto___type_5 X2 -> auto___def_39 X1 X2 X3). tauto. exact (rem_1770 X1 X2 X3).
Qed.

Remark rem_1772 : forall X1 X2 X3:term, auto___def_29 (cons X2 (cons server nil)) -> auto___def_30 (cons X3 (cons X1 nil)) -> auto___def_39 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_472 X2 (cons server nil) H);  intros.
  apply (rem_1771 X1 X2 X3);  tauto.
Qed.

Remark rem_1773 : forall X1 X2 X3:term, auto___def_18 sym -> auto___def_29 (cons X2 (cons server nil)) -> auto___def_30 (cons X3 (cons X1 nil)) -> auto___def_39 X1 X2 X3. (* Split. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_29 (cons X2 (cons server nil)) -> auto___def_30 (cons X3 (cons X1 nil)) -> auto___def_39 X1 X2 X3). tauto.
  exact (rem_1772 X1 X2 X3).
Qed.

Remark rem_1774 : forall X1 X2 X3:term, auto___def_13 (key sym (cons X2 (cons server nil))) -> auto___def_30 (cons X3 (cons X1 nil)) -> auto___def_39 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_142 sym (cons X2 (cons server nil)) H);  intros.
  apply (rem_1773 X1 X2 X3);  tauto.
Qed.

Remark rem_1775 : forall X1 X2 X3:term, auto___def_30 (cons X3 (cons X1 nil)) -> auto___def_13 (key sym (cons X2 (cons server nil))) -> auto___def_39 X1 X2 X3. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_13 (key sym (cons X2 (cons server nil))) -> auto___def_30 (cons X3 (cons X1 nil)) -> auto___def_39 X1 X2 X3). tauto. exact (rem_1774 X1 X2 X3).
Qed.

Remark rem_1776 : forall X1 X2 X3:term, auto_knows (crypt (cons X3 (cons X1 nil)) (key sym (cons X2 (cons server nil)))) -> auto___def_39 X1 X2 X3. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_41 (cons X3 (cons X1 nil)) (key sym (cons X2 (cons server nil))) H);  intros.
  apply (rem_1709 X1 X2 X3);  tauto.
  apply (rem_1719 X1 X2 X3);  tauto.
  apply (rem_1735 X1 X2 X3);  tauto.
  apply (rem_1751 X1 X2 X3);  tauto.
  apply (rem_1762 X1 X2 X3);  tauto.
  apply (rem_1763 X1 X2 X3);  tauto.
  apply (rem_1775 X1 X2 X3);  tauto.
Qed.

Remark rem_1777 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_22 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_22 X1 -> auto___def_22 X1). tauto. exact (rem_1151 X1).
Qed.

Remark rem_1778 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_1396 X2).
Qed.

Remark rem_1779 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> (auto___def_22 X1 /\ auto___def_23 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_22 X1). 2:apply (rem_1777 X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_1778 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1780 : forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_20 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1779 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_20_crypt_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1781 : forall X1 X2:term, auto___def_23 X2 -> auto___def_22 X1 -> auto___def_20 (crypt X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_22 X1 -> auto___def_23 X2 -> auto___def_20 (crypt X1 X2)). tauto. exact (rem_1780 X1 X2).
Qed.

Remark rem_1782 : forall X1 X2 X3:term, auto_knows X2 -> auto_knows X1 -> auto_knows X3 -> auto___def_19 (current_session X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3. intros A1 A2 A3.
  case (rem_1204 X1 X2 X3 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_19_current_session_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1783 : forall X1 X2 X3:term, auto_knows X1 -> auto_knows X2 -> auto_knows X3 -> auto___def_19 (current_session X1 X2 X3). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto_knows X2 -> auto_knows X1 -> auto_knows X3 -> auto___def_19 (current_session X1 X2 X3)). tauto. exact (rem_1782 X1 X2 X3).
Qed.

Remark rem_1784 : forall X1 X2 X3:term, auto___def_11 X1 X2 X3 -> auto___def_19 (current_session X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_118 X1 X2 X3 H);  intros.
  apply (rem_1783 X1 X2 X3);  tauto.
Qed.

Remark rem_1785 : forall X1:term, auto___def_36 X1 -> auto___def_36 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1786 : forall X1 X2:term, auto___def_21 X2 -> auto___def_36 X1 -> auto___def_36 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_36 X1 -> auto___def_36 X1). tauto. exact (rem_1785 X1).
Qed.

Remark rem_1787 : forall X1 X2:term, auto___def_21 X2 -> auto___def_36 X1 -> auto___def_21 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_21 X2 -> auto___def_21 X2). tauto. exact (rem_919 X2).
Qed.

Remark rem_1788 : forall X1 X2:term, auto___def_21 X2 -> auto___def_36 X1 -> (auto___def_36 X1 /\ auto___def_21 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_36 X1). 2:apply (rem_1786 X1 X2);  assumption.
  cut (auto___def_21 X2). 2:apply (rem_1787 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1789 : forall X1 X2:term, auto___def_21 X2 -> auto___def_36 X1 -> auto___def_34 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1788 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_34_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1790 : forall X1 X2 X3:term, auto___def_47 (old_session X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3.  case (rem_1393). intros. apply trans___def_47_old_session_1;  tauto.
 tauto.
Qed.

Remark rem_1791 : auto___def_43 pub. (* Deduce positive atom. *)
Proof.
   case rem_1393. intros. apply trans___def_43_pub_1;  tauto.
 tauto.
Qed.

Remark rem_1792 : forall X1:term, auto___def_16 X1 -> auto___type_6 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_16_p__type_6 1.
  intro X. case X.
   intro H. elim (rem_154  H).
   intro H. elim (rem_152  H).
  intros X1 X2. intro H. elim (rem_155 X1 X2 H).
  intros X1 X2. intro H. elim (rem_146 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_157 X1 X2 X3 H).
   intro H. elim (rem_149  H).
  intros X1 X2;  exact (rem_1605 epsilon_m__def_16_p__type_6 X1 X2).
   intro H. elim (rem_148  H).
  intros X1 X2. intro H. elim (rem_160 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_151 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_150 X1 X2 X3 H).
   intro H. elim (rem_156  H).
   intro H. elim (rem_158  H).
  intros X1. intro H. elim (rem_147 X1 H).
   intro H. elim (rem_159  H).
   intro H. elim (rem_153  H).
Qed.

Remark rem_1793 : forall X1 X2 X3:term, auto___def_16 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto___type_6 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_16 X1 -> auto___type_6 X1). tauto. exact (rem_1792 X1).
Qed.

Remark rem_1794 : forall X1 X2 X3:term, auto___type_5 X2 -> auto___type_4 X3 -> auto___def_16 X1 -> auto___type_6 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X3 X2.
  cut (auto___def_16 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto___type_6 X1). tauto. exact (rem_1793 X1 X2 X3).
Qed.

Remark rem_1795 : (forall X:term, auto___def_33 X -> auto___type_6 X)
    -> forall X1:term, auto___def_18 X1 -> auto___def_18 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1796 : (forall X:term, auto___def_33 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_35 X2 -> auto___def_18 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_33_p__type_6. intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_18 X1). tauto. exact (rem_1795 epsilon_m__def_33_p__type_6 X1).
Defined.

Remark rem_1797 : (forall X:term, auto___def_33 X -> auto___type_6 X)
    -> forall X2:term, auto___def_35 X2 -> auto___def_35 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1798 : (forall X:term, auto___def_33 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_35 X2 -> auto___def_35 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_33_p__type_6. intros X1 X2.
  cut (auto___def_35 X2 -> auto___def_35 X2). tauto. exact (rem_1797 epsilon_m__def_33_p__type_6 X2).
Defined.

Remark rem_1799 : (forall X:term, auto___def_33 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_35 X2 -> (auto___def_18 X1 /\ auto___def_35 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_33_p__type_6. intros X1 X2. intros A1 A2.
  cut (auto___def_18 X1). 2:apply (rem_1796 epsilon_m__def_33_p__type_6 X1 X2);  assumption.
  cut (auto___def_35 X2). 2:apply (rem_1798 epsilon_m__def_33_p__type_6 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1800 : (forall X:term, auto___def_33 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_18 X1 -> auto___def_35 X2 -> auto___type_6 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_33_p__type_6. intros X1 X2. intros A1 A2.
  case (rem_1799 epsilon_m__def_33_p__type_6 X1 X2 A1 A2). clear  epsilon_m__def_33_p__type_6 A1 A2. intros. apply trans___type_6_key_2;  tauto.
 clear  epsilon_m__def_33_p__type_6 A1 A2. tauto.
Defined.

Remark rem_1801 : (forall X:term, auto___def_33 X -> auto___type_6 X)
    -> forall X1 X2:term, auto___def_33 (key X1 X2) -> auto___type_6 (key X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_33_p__type_6. intros X1 X2. intro H. intros.
  elim (rem_237 X1 X2 H);  intros.
  apply (rem_1800 epsilon_m__def_33_p__type_6 X1 X2);  tauto.
Defined.

Remark rem_1802 : forall X1:term, auto___def_33 X1 -> auto___type_6 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_33_p__type_6 1.
  intro X. case X.
   intro H. elim (rem_247  H).
   intro H. elim (rem_245  H).
  intros X1 X2. intro H. elim (rem_248 X1 X2 H).
  intros X1 X2. intro H. elim (rem_239 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_250 X1 X2 X3 H).
   intro H. elim (rem_242  H).
  intros X1 X2;  exact (rem_1801 epsilon_m__def_33_p__type_6 X1 X2).
   intro H. elim (rem_241  H).
  intros X1 X2. intro H. elim (rem_253 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_244 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_243 X1 X2 X3 H).
   intro H. elim (rem_249  H).
   intro H. elim (rem_251  H).
  intros X1. intro H. elim (rem_240 X1 H).
   intro H. elim (rem_252  H).
   intro H. elim (rem_246  H).
Qed.

Remark rem_1803 : forall X1 X2 X3:term, auto___def_33 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto___type_6 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3.
  cut (auto___def_33 X1 -> auto___type_6 X1). tauto. exact (rem_1802 X1).
Qed.

Remark rem_1804 : forall X1 X2 X3:term, auto___type_5 X2 -> auto___type_4 X3 -> auto___def_33 X1 -> auto___type_6 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X3 X2.
  cut (auto___def_33 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto___type_6 X1). tauto. exact (rem_1803 X1 X2 X3).
Qed.

Remark rem_1805 : forall X1 X2 X3:term, auto___def_39 X2 X3 X1 -> auto___type_6 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1564 X2 X3 X1 H);  intros.
  apply (rem_1794 X1 X2 X3);  tauto.
  apply (rem_1804 X1 X2 X3);  tauto.
Qed.

Remark rem_1806 : forall X1:term, auto___type_8 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_8_1. Qed.

Remark rem_1807 : forall X1 X2:term, auto___def_32 X2 -> auto___type_4 X1 -> auto___type_4 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_4 X1 -> auto___type_4 X1). tauto. exact (rem_1245 X1).
Qed.

Remark rem_1808 : forall X2:term, auto___def_32 X2 -> auto___def_32 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1809 : forall X1 X2:term, auto___def_32 X2 -> auto___type_4 X1 -> auto___def_32 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_32 X2 -> auto___def_32 X2). tauto. exact (rem_1808 X2).
Qed.

Remark rem_1810 : forall X1 X2:term, auto___def_32 X2 -> auto___type_4 X1 -> (auto___type_4 X1 /\ auto___def_32 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_4 X1). 2:apply (rem_1807 X1 X2);  assumption.
  cut (auto___def_32 X2). 2:apply (rem_1809 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1811 : forall X1 X2:term, auto___def_32 X2 -> auto___type_4 X1 -> auto___def_31 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1810 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_31_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1812 : forall X1 X2:term, auto___def_31 X2 -> auto___type_3 X1 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_3 X1 -> auto___type_3 X1). tauto. exact (rem_1126 X1).
Qed.

Remark rem_1813 : forall X2:term, auto___def_31 X2 -> auto___def_31 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1814 : forall X1 X2:term, auto___def_31 X2 -> auto___type_3 X1 -> auto___def_31 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_31 X2 -> auto___def_31 X2). tauto. exact (rem_1813 X2).
Qed.

Remark rem_1815 : forall X1 X2:term, auto___def_31 X2 -> auto___type_3 X1 -> (auto___type_3 X1 /\ auto___def_31 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_3 X1). 2:apply (rem_1812 X1 X2);  assumption.
  cut (auto___def_31 X2). 2:apply (rem_1814 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1816 : forall X1 X2:term, auto___def_31 X2 -> auto___type_3 X1 -> auto___def_30 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1815 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_30_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1817 : auto___def_44 prv. (* Deduce positive atom. *)
Proof.
   case rem_1393. intros. apply trans___def_44_prv_1;  tauto.
 tauto.
Qed.

Remark rem_1818 : forall X1 X2:term, auto___def_18 X1 -> auto___def_35 X2 -> auto___def_18 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_18 X1). tauto. exact (rem_1119 X1).
Qed.

Remark rem_1819 : forall X2:term, auto___def_35 X2 -> auto___def_35 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1820 : forall X1 X2:term, auto___def_18 X1 -> auto___def_35 X2 -> auto___def_35 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_35 X2 -> auto___def_35 X2). tauto. exact (rem_1819 X2).
Qed.

Remark rem_1821 : forall X1 X2:term, auto___def_18 X1 -> auto___def_35 X2 -> (auto___def_18 X1 /\ auto___def_35 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_18 X1). 2:apply (rem_1818 X1 X2);  assumption.
  cut (auto___def_35 X2). 2:apply (rem_1820 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1822 : forall X1 X2:term, auto___def_18 X1 -> auto___def_35 X2 -> auto___def_33 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1821 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_33_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1823 : forall X1 X2:term, auto___def_35 X2 -> auto___def_18 X1 -> auto___def_33 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_35 X2 -> auto___def_33 (key X1 X2)). tauto. exact (rem_1822 X1 X2).
Qed.

Remark rem_1824 : forall X1 X2:term, auto___def_16 X1 -> auto___def_24 X2 -> auto___def_16 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_16 X1 -> auto___def_16 X1). tauto. exact (rem_1250 X1).
Qed.

Remark rem_1825 : forall X1 X2:term, auto___def_16 X1 -> auto___def_24 X2 -> auto___def_24 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_24 X2 -> auto___def_24 X2). tauto. exact (rem_925 X2).
Qed.

Remark rem_1826 : forall X1 X2:term, auto___def_16 X1 -> auto___def_24 X2 -> (auto___def_16 X1 /\ auto___def_24 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_16 X1). 2:apply (rem_1824 X1 X2);  assumption.
  cut (auto___def_24 X2). 2:apply (rem_1825 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1827 : forall X1 X2:term, auto___def_16 X1 -> auto___def_24 X2 -> auto___def_22 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1826 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_22_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1828 : forall X1 X2:term, auto___def_24 X2 -> auto___def_16 X1 -> auto___def_22 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_16 X1 -> auto___def_24 X2 -> auto___def_22 (cons X1 X2)). tauto. exact (rem_1827 X1 X2).
Qed.

(* [appp] Proofs that all approximation clauses hold. *)


Remark rem_1829 : forall X1 X2:term, auto_knows X2 -> auto_knows X1 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows X1 -> auto_knows X1). tauto. exact (rem_466 X1).
Qed.

Remark rem_1830 : forall X1 X2:term, auto_knows X2 -> auto_knows X1 -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows X2 -> auto_knows X2). tauto. exact (rem_1200 X2).
Qed.

Remark rem_1831 : forall X1 X2:term, auto_knows X2 -> auto_knows X1 -> (auto_knows X1 /\ auto_knows X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto_knows X1). 2:apply (rem_1829 X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_1830 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1832 : forall X1 X2:term, auto_knows X2 -> auto_knows X1 -> auto_knows (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1831 X1 X2 A1 A2). clear  A1 A2. intros. apply trans_knows_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1833 : forall X1:term, auto_knows X1 -> auto_knows X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1. intros A1.
  cut (auto_knows X1). 2:apply (rem_466 X1);  assumption.
  tauto.
Qed.

Remark rem_1834 : forall X1:term, auto_knows X1 -> auto_knows (s X1). (* Deduce positive atom. *)
Proof.
  intros X1. intros A1.
  case (rem_1833 X1 A1). clear  A1. intros. apply trans_knows_s_1;  tauto.
 clear  A1. tauto.
Qed.

Remark rem_1835 : forall X1 X2:term, auto___def_13 X2 -> auto___def_30 X1 -> auto___def_30 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_30 X1 -> auto___def_30 X1). tauto. exact (rem_1186 X1).
Qed.

Remark rem_1836 : forall X1 X2:term, auto___def_13 X2 -> auto___def_30 X1 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_1576 X2).
Qed.

Remark rem_1837 : forall X1 X2:term, auto___def_13 X2 -> auto___def_30 X1 -> (auto___def_30 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_30 X1). 2:apply (rem_1835 X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_1836 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1838 : forall X1 X2:term, auto___def_13 X2 -> auto___def_30 X1 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1837 X1 X2 A1 A2). clear  A1 A2. intros. apply trans_knows_crypt_7;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1839 : auto_agent server. (* Deduce positive atom. *)
Proof.
   case rem_1393. intros. apply trans_agent_server_1;  tauto.
 tauto.
Qed.

Remark rem_1840 : forall X1:term, auto___def_44 X1 -> auto___def_44 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1841 : forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> auto___def_44 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_44 X1 -> auto___def_44 X1). tauto. exact (rem_1840 X1).
Qed.

Remark rem_1842 : forall X2:term, auto___def_45 X2 -> auto___def_45 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1843 : forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> auto___def_45 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_45 X2 -> auto___def_45 X2). tauto. exact (rem_1842 X2).
Qed.

Remark rem_1844 : forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> (auto___def_44 X1 /\ auto___def_45 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_44 X1). 2:apply (rem_1841 X1 X2);  assumption.
  cut (auto___def_45 X2). 2:apply (rem_1843 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1845 : forall X1 X2:term, auto___def_44 X1 -> auto___def_45 X2 -> auto_knows (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1844 X1 X2 A1 A2). clear  A1 A2. intros. apply trans_knows_key_3;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1846 : forall X1 X2:term, auto___def_45 X2 -> auto___def_44 X1 -> auto_knows (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_44 X1 -> auto___def_45 X2 -> auto_knows (key X1 X2)). tauto. exact (rem_1845 X1 X2).
Qed.

Remark rem_1847 : auto_agent bob. (* Deduce positive atom. *)
Proof.
   case rem_1393. intros. apply trans_agent_bob_1;  tauto.
 tauto.
Qed.

Remark rem_1848 : (forall X:term, auto_agent X -> auto_knows X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_pknows.  tauto.
Defined.

Remark rem_1849 : (forall X:term, auto_agent X -> auto_knows X)
    -> auto_knows i. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_pknows.  case (rem_1848 epsilon_magent_pknows). clear  epsilon_magent_pknows. intros. apply trans_knows_i_1;  tauto.
 clear  epsilon_magent_pknows. tauto.
Defined.

Remark rem_1850 : (forall X:term, auto_agent X -> auto_knows X)
    -> auto_agent i -> auto_knows i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_pknows. intro H. intros.
  elim (rem_1053 H);  intros.
  apply (rem_1849 epsilon_magent_pknows);  tauto.
Defined.

Remark rem_1851 : (forall X:term, auto_agent X -> auto_knows X)
    -> auto_knows bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_pknows.  case (rem_1848 epsilon_magent_pknows). clear  epsilon_magent_pknows. intros. apply trans_knows_bob_1;  tauto.
 clear  epsilon_magent_pknows. tauto.
Defined.

Remark rem_1852 : (forall X:term, auto_agent X -> auto_knows X)
    -> auto_agent bob -> auto_knows bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_pknows. intro H. intros.
  elim (rem_1056 H);  intros.
  apply (rem_1851 epsilon_magent_pknows);  tauto.
Defined.

Remark rem_1853 : (forall X:term, auto_agent X -> auto_knows X)
    -> auto_knows alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_pknows.  case (rem_1848 epsilon_magent_pknows). clear  epsilon_magent_pknows. intros. apply trans_knows_alice_1;  tauto.
 clear  epsilon_magent_pknows. tauto.
Defined.

Remark rem_1854 : (forall X:term, auto_agent X -> auto_knows X)
    -> auto_agent alice -> auto_knows alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_pknows. intro H. intros.
  elim (rem_1059 H);  intros.
  apply (rem_1853 epsilon_magent_pknows);  tauto.
Defined.

Remark rem_1855 : (forall X:term, auto_agent X -> auto_knows X)
    -> auto_knows server. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_pknows.  case (rem_1848 epsilon_magent_pknows). clear  epsilon_magent_pknows. intros. apply trans_knows_server_1;  tauto.
 clear  epsilon_magent_pknows. tauto.
Defined.

Remark rem_1856 : (forall X:term, auto_agent X -> auto_knows X)
    -> auto_agent server -> auto_knows server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_pknows. intro H. intros.
  elim (rem_1062 H);  intros.
  apply (rem_1855 epsilon_magent_pknows);  tauto.
Defined.

Remark rem_1857 : forall X1:term, auto_agent X1 -> auto_knows X1. (* Induct. *)
Proof.
  fix epsilon_magent_pknows 1.
  intro X. case X.
  exact (rem_1854 epsilon_magent_pknows ).
  exact (rem_1852 epsilon_magent_pknows ).
  intros X1 X2. intro H. elim (rem_1071 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1064 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1073 X1 X2 X3 H).
  exact (rem_1850 epsilon_magent_pknows ).
  intros X1 X2. intro H. elim (rem_1069 X1 X2 H).
   intro H. elim (rem_1066  H).
  intros X1 X2. intro H. elim (rem_1075 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1068 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1067 X1 X2 X3 H).
   intro H. elim (rem_1072  H).
   intro H. elim (rem_1074  H).
  intros X1. intro H. elim (rem_1065 X1 H).
  exact (rem_1856 epsilon_magent_pknows ).
   intro H. elim (rem_1070  H).
Qed.

Remark rem_1858 : forall X1 X2:term, auto_knows X1 -> auto_knows X2 -> auto_knows X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto_knows X2 -> auto_knows X1 -> auto_knows X1). tauto. exact (rem_1829 X1 X2).
Qed.

Remark rem_1859 : forall X1 X2:term, auto_knows (cons X1 X2) -> auto_knows X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_97 X1 X2 H);  intros.
  apply (rem_1858 X1 X2);  tauto.
Qed.

Remark rem_1860 : auto_agent i. (* Deduce positive atom. *)
Proof.
   case rem_1393. intros. apply trans_agent_i_1;  tauto.
 tauto.
Qed.

Remark rem_1861 : forall X1:term, auto_knows (s X1) -> auto_knows X1. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_45 X1 H);  intros.
  apply (rem_466 X1);  tauto.
Qed.

Remark rem_1862 : forall X1 X2:term, auto_knows (cons X2 X1) -> auto_knows X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_97 X2 X1 H);  intros.
  apply (rem_1829 X1 X2);  tauto.
Qed.

Remark rem_1863 : forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto___def_42 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_42 X1 -> auto___def_42 X1). tauto. exact (rem_1132 X1).
Qed.

Remark rem_1864 : forall X2:term, auto___type_7 X2 -> auto___type_7 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1865 : forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto___type_7 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_7 X2 -> auto___type_7 X2). tauto. exact (rem_1864 X2).
Qed.

Remark rem_1866 : forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> (auto___def_42 X1 /\ auto___type_7 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_42 X1). 2:apply (rem_1863 X1 X2);  assumption.
  cut (auto___type_7 X2). 2:apply (rem_1865 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1867 : forall X1 X2:term, auto___def_42 X1 -> auto___type_7 X2 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1866 X1 X2 A1 A2). clear  A1 A2. intros. apply trans_knows_crypt_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1868 : forall X1 X2:term, auto___type_7 X2 -> auto___def_42 X1 -> auto_knows (crypt X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_42 X1 -> auto___type_7 X2 -> auto_knows (crypt X1 X2)). tauto. exact (rem_1867 X1 X2).
Qed.

Remark rem_1869 : forall X1:term, auto___def_43 X1 -> auto___def_43 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1870 : forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> auto___def_43 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_43 X1). tauto. exact (rem_1869 X1).
Qed.

Remark rem_1871 : forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> auto___type_8 X2. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_8_1. Qed.

Remark rem_1872 : forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> (auto___def_43 X1 /\ auto___type_8 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_43 X1). 2:apply (rem_1870 X1 X2);  assumption.
  cut (auto___type_8 X2). 2:apply (rem_1871 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1873 : forall X1 X2:term, auto___def_43 X1 -> auto___type_8 X2 -> auto_knows (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1872 X1 X2 A1 A2). clear  A1 A2. intros. apply trans_knows_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1874 : forall X1 X2:term, auto___type_8 X2 -> auto___def_43 X1 -> auto_knows (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_43 X1 -> auto___type_8 X2 -> auto_knows (key X1 X2)). tauto. exact (rem_1873 X1 X2).
Qed.

Remark rem_1875 : (forall X:term, auto___type_1 X -> auto_knows X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_1_pknows.  tauto.
Defined.

Remark rem_1876 : (forall X:term, auto___type_1 X -> auto_knows X)
    -> auto_knows i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_1_pknows.  case (rem_1875 epsilon_m__type_1_pknows). clear  epsilon_m__type_1_pknows. intros. apply trans_knows_i_1;  tauto.
 clear  epsilon_m__type_1_pknows. tauto.
Defined.

Remark rem_1877 : auto___type_1 i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1878 : (forall X:term, auto___type_1 X -> auto_knows X)
    -> auto___type_1 i -> auto_knows i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_1_pknows. intro H. intros.
  elim (rem_1877 H);  intros.
  apply (rem_1876 epsilon_m__type_1_pknows);  tauto.
Defined.

Remark rem_1879 : (forall X:term, auto___type_1 X -> auto_knows X)
    -> auto_knows bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_1_pknows.  case (rem_1875 epsilon_m__type_1_pknows). clear  epsilon_m__type_1_pknows. intros. apply trans_knows_bob_1;  tauto.
 clear  epsilon_m__type_1_pknows. tauto.
Defined.

Remark rem_1880 : auto___type_1 bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1881 : (forall X:term, auto___type_1 X -> auto_knows X)
    -> auto___type_1 bob -> auto_knows bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_1_pknows. intro H. intros.
  elim (rem_1880 H);  intros.
  apply (rem_1879 epsilon_m__type_1_pknows);  tauto.
Defined.

Remark rem_1882 : (forall X:term, auto___type_1 X -> auto_knows X)
    -> auto_knows alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_1_pknows.  case (rem_1875 epsilon_m__type_1_pknows). clear  epsilon_m__type_1_pknows. intros. apply trans_knows_alice_1;  tauto.
 clear  epsilon_m__type_1_pknows. tauto.
Defined.

Remark rem_1883 : auto___type_1 alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1884 : (forall X:term, auto___type_1 X -> auto_knows X)
    -> auto___type_1 alice -> auto_knows alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_1_pknows. intro H. intros.
  elim (rem_1883 H);  intros.
  apply (rem_1882 epsilon_m__type_1_pknows);  tauto.
Defined.

Remark rem_1885 : (forall X:term, auto___type_1 X -> auto_knows X)
    -> auto_knows server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_1_pknows.  case (rem_1875 epsilon_m__type_1_pknows). clear  epsilon_m__type_1_pknows. intros. apply trans_knows_server_1;  tauto.
 clear  epsilon_m__type_1_pknows. tauto.
Defined.

Remark rem_1886 : auto___type_1 server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1887 : (forall X:term, auto___type_1 X -> auto_knows X)
    -> auto___type_1 server -> auto_knows server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_1_pknows. intro H. intros.
  elim (rem_1886 H);  intros.
  apply (rem_1885 epsilon_m__type_1_pknows);  tauto.
Defined.

Remark rem_1888 : forall X1 X2:term, auto___type_1 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1889 : forall X1:term, auto___type_1 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1890 : auto___type_1 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1891 : forall X1 X2 X3:term, auto___type_1 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1892 : forall X1 X2 X3:term, auto___type_1 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1893 : forall X1 X2:term, auto___type_1 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1894 : auto___type_1 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1895 : forall X1 X2:term, auto___type_1 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1896 : auto___type_1 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1897 : forall X1 X2 X3:term, auto___type_1 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1898 : auto___type_1 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1899 : forall X1 X2:term, auto___type_1 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1900 : forall X1:term, auto___type_1 X1 -> auto_knows X1. (* Induct. *)
Proof.
  fix epsilon_m__type_1_pknows 1.
  intro X. case X.
  exact (rem_1884 epsilon_m__type_1_pknows ).
  exact (rem_1881 epsilon_m__type_1_pknows ).
  intros X1 X2. intro H. elim (rem_1895 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1888 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1897 X1 X2 X3 H).
  exact (rem_1878 epsilon_m__type_1_pknows ).
  intros X1 X2. intro H. elim (rem_1893 X1 X2 H).
   intro H. elim (rem_1890  H).
  intros X1 X2. intro H. elim (rem_1899 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1892 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1891 X1 X2 X3 H).
   intro H. elim (rem_1896  H).
   intro H. elim (rem_1898  H).
  intros X1. intro H. elim (rem_1889 X1 H).
  exact (rem_1887 epsilon_m__type_1_pknows ).
   intro H. elim (rem_1894  H).
Qed.

Remark rem_1901 : forall X1 X2:term, auto___def_7 X2 -> auto___type_1 X1 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_1 X1 -> auto_knows X1). tauto. exact (rem_1900 X1).
Qed.

Remark rem_1902 : (forall X:term, auto___type_2 X -> auto_knows X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_2_pknows.  tauto.
Defined.

Remark rem_1903 : (forall X:term, auto___type_2 X -> auto_knows X)
    -> auto_knows i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_pknows.  case (rem_1902 epsilon_m__type_2_pknows). clear  epsilon_m__type_2_pknows. intros. apply trans_knows_i_1;  tauto.
 clear  epsilon_m__type_2_pknows. tauto.
Defined.

Remark rem_1904 : auto___type_2 i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1905 : (forall X:term, auto___type_2 X -> auto_knows X)
    -> auto___type_2 i -> auto_knows i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_2_pknows. intro H. intros.
  elim (rem_1904 H);  intros.
  apply (rem_1903 epsilon_m__type_2_pknows);  tauto.
Defined.

Remark rem_1906 : (forall X:term, auto___type_2 X -> auto_knows X)
    -> auto_knows bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_pknows.  case (rem_1902 epsilon_m__type_2_pknows). clear  epsilon_m__type_2_pknows. intros. apply trans_knows_bob_1;  tauto.
 clear  epsilon_m__type_2_pknows. tauto.
Defined.

Remark rem_1907 : auto___type_2 bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1908 : (forall X:term, auto___type_2 X -> auto_knows X)
    -> auto___type_2 bob -> auto_knows bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_2_pknows. intro H. intros.
  elim (rem_1907 H);  intros.
  apply (rem_1906 epsilon_m__type_2_pknows);  tauto.
Defined.

Remark rem_1909 : (forall X:term, auto___type_2 X -> auto_knows X)
    -> auto_knows alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_pknows.  case (rem_1902 epsilon_m__type_2_pknows). clear  epsilon_m__type_2_pknows. intros. apply trans_knows_alice_1;  tauto.
 clear  epsilon_m__type_2_pknows. tauto.
Defined.

Remark rem_1910 : auto___type_2 alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1911 : (forall X:term, auto___type_2 X -> auto_knows X)
    -> auto___type_2 alice -> auto_knows alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_2_pknows. intro H. intros.
  elim (rem_1910 H);  intros.
  apply (rem_1909 epsilon_m__type_2_pknows);  tauto.
Defined.

Remark rem_1912 : (forall X:term, auto___type_2 X -> auto_knows X)
    -> auto_knows server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_pknows.  case (rem_1902 epsilon_m__type_2_pknows). clear  epsilon_m__type_2_pknows. intros. apply trans_knows_server_1;  tauto.
 clear  epsilon_m__type_2_pknows. tauto.
Defined.

Remark rem_1913 : auto___type_2 server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1914 : (forall X:term, auto___type_2 X -> auto_knows X)
    -> auto___type_2 server -> auto_knows server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_2_pknows. intro H. intros.
  elim (rem_1913 H);  intros.
  apply (rem_1912 epsilon_m__type_2_pknows);  tauto.
Defined.

Remark rem_1915 : forall X1 X2:term, auto___type_2 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1916 : forall X1:term, auto___type_2 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1917 : auto___type_2 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1918 : forall X1 X2 X3:term, auto___type_2 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1919 : forall X1 X2 X3:term, auto___type_2 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1920 : forall X1 X2:term, auto___type_2 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1921 : auto___type_2 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1922 : forall X1 X2:term, auto___type_2 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1923 : auto___type_2 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1924 : forall X1 X2 X3:term, auto___type_2 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1925 : auto___type_2 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1926 : forall X1 X2:term, auto___type_2 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1927 : forall X1:term, auto___type_2 X1 -> auto_knows X1. (* Induct. *)
Proof.
  fix epsilon_m__type_2_pknows 1.
  intro X. case X.
  exact (rem_1911 epsilon_m__type_2_pknows ).
  exact (rem_1908 epsilon_m__type_2_pknows ).
  intros X1 X2. intro H. elim (rem_1922 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1915 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1924 X1 X2 X3 H).
  exact (rem_1905 epsilon_m__type_2_pknows ).
  intros X1 X2. intro H. elim (rem_1920 X1 X2 H).
   intro H. elim (rem_1917  H).
  intros X1 X2. intro H. elim (rem_1926 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1919 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1918 X1 X2 X3 H).
   intro H. elim (rem_1923  H).
   intro H. elim (rem_1925  H).
  intros X1. intro H. elim (rem_1916 X1 H).
  exact (rem_1914 epsilon_m__type_2_pknows ).
   intro H. elim (rem_1921  H).
Qed.

Remark rem_1928 : (forall X:term, auto___def_7 X -> auto_knows X)
    -> forall X1:term, auto___type_2 X1 -> auto_knows X1. (* Cut history. *)
Proof.  intros epsilon_m__def_7_pknows. exact (rem_1927).
Defined.

Remark rem_1929 : (forall X:term, auto___def_7 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_2 X1 -> auto___def_8 X2 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_7_pknows. intros X1 X2.
  cut (auto___type_2 X1 -> auto_knows X1). tauto. exact (rem_1928 epsilon_m__def_7_pknows X1).
Defined.

Remark rem_1930 : (forall X:term, auto___def_9 X -> auto_knows X)
    -> forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1931 : (forall X:term, auto___def_9 X -> auto_knows X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_9_pknows. intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_1930 epsilon_m__def_9_pknows X1).
Defined.

Remark rem_1932 : (forall X:term, auto___def_9 X -> auto_knows X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1933 : (forall X:term, auto___def_9 X -> auto_knows X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_9_pknows. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_1932 epsilon_m__def_9_pknows X2).
Defined.

Remark rem_1934 : (forall X:term, auto___def_9 X -> auto_knows X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> (auto_agent X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_9_pknows. intros X1 X2. intros A1 A2.
  cut (auto_agent X1). 2:apply (rem_1931 epsilon_m__def_9_pknows X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_1933 epsilon_m__def_9_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1935 : (forall X:term, auto___def_9 X -> auto_knows X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_knows (noncea X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_9_pknows. intros X1 X2. intros A1 A2.
  case (rem_1934 epsilon_m__def_9_pknows X1 X2 A1 A2). clear  epsilon_m__def_9_pknows A1 A2. intros. apply trans_knows_noncea_1;  tauto.
 clear  epsilon_m__def_9_pknows A1 A2. tauto.
Defined.

Remark rem_1936 : forall X1 X2:term, auto___def_9 (noncea X1 X2) -> or_1
    (auto_agent X1 /\ auto_agent X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1937 : (forall X:term, auto___def_9 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_9 (noncea X1 X2) -> auto_knows (noncea X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_9_pknows. intros X1 X2. intro H. intros.
  elim (rem_1936 X1 X2 H);  intros.
  apply (rem_1935 epsilon_m__def_9_pknows X1 X2);  tauto.
Defined.

Remark rem_1938 : forall X1 X2:term, auto___def_9 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1939 : forall X1:term, auto___def_9 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1940 : auto___def_9 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1941 : auto___def_9 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1942 : forall X1 X2 X3:term, auto___def_9 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1943 : forall X1 X2 X3:term, auto___def_9 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1944 : auto___def_9 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1945 : forall X1 X2:term, auto___def_9 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1946 : auto___def_9 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1947 : auto___def_9 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1948 : forall X1 X2:term, auto___def_9 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1949 : auto___def_9 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1950 : forall X1 X2 X3:term, auto___def_9 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1951 : auto___def_9 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1952 : auto___def_9 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1953 : forall X1:term, auto___def_9 X1 -> auto_knows X1. (* Induct. *)
Proof.
  fix epsilon_m__def_9_pknows 1.
  intro X. case X.
   intro H. elim (rem_1947  H).
   intro H. elim (rem_1944  H).
  intros X1 X2. intro H. elim (rem_1948 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1938 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1950 X1 X2 X3 H).
   intro H. elim (rem_1941  H).
  intros X1 X2. intro H. elim (rem_1945 X1 X2 H).
   intro H. elim (rem_1940  H).
  intros X1 X2;  exact (rem_1937 epsilon_m__def_9_pknows X1 X2).
  intros X1 X2 X3. intro H. elim (rem_1943 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1942 X1 X2 X3 H).
   intro H. elim (rem_1949  H).
   intro H. elim (rem_1951  H).
  intros X1. intro H. elim (rem_1939 X1 H).
   intro H. elim (rem_1952  H).
   intro H. elim (rem_1946  H).
Qed.

Remark rem_1954 : (forall X:term, auto___def_8 X -> auto_knows X)
    -> forall X1:term, auto___def_9 X1 -> auto_knows X1. (* Cut history. *)
Proof.  intros epsilon_m__def_8_pknows. exact (rem_1953).
Defined.

Remark rem_1955 : (forall X:term, auto___def_8 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_9 X1 -> auto___def_10 X2 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_8_pknows. intros X1 X2.
  cut (auto___def_9 X1 -> auto_knows X1). tauto. exact (rem_1954 epsilon_m__def_8_pknows X1).
Defined.

Remark rem_1956 : (forall X:term, auto___def_10 X -> auto_knows X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_10_pknows.  tauto.
Defined.

Remark rem_1957 : (forall X:term, auto___def_10 X -> auto_knows X)
    -> auto_knows nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_10_pknows.  case (rem_1956 epsilon_m__def_10_pknows). clear  epsilon_m__def_10_pknows. intros. apply trans_knows_nil_1;  tauto.
 clear  epsilon_m__def_10_pknows. tauto.
Defined.

Remark rem_1958 : auto___def_10 nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1959 : (forall X:term, auto___def_10 X -> auto_knows X)
    -> auto___def_10 nil -> auto_knows nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_10_pknows. intro H. intros.
  elim (rem_1958 H);  intros.
  apply (rem_1957 epsilon_m__def_10_pknows);  tauto.
Defined.

Remark rem_1960 : forall X1 X2:term, auto___def_10 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1961 : forall X1:term, auto___def_10 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1962 : auto___def_10 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1963 : forall X1 X2 X3:term, auto___def_10 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1964 : forall X1 X2 X3:term, auto___def_10 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1965 : auto___def_10 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1966 : forall X1 X2:term, auto___def_10 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1967 : auto___def_10 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1968 : auto___def_10 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1969 : forall X1 X2:term, auto___def_10 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1970 : auto___def_10 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1971 : forall X1 X2 X3:term, auto___def_10 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1972 : auto___def_10 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1973 : auto___def_10 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1974 : forall X1 X2:term, auto___def_10 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1975 : forall X2:term, auto___def_10 X2 -> auto_knows X2. (* Induct. *)
Proof.
  fix epsilon_m__def_10_pknows 1.
  intro X. case X.
   intro H. elim (rem_1968  H).
   intro H. elim (rem_1965  H).
  intros X1 X2. intro H. elim (rem_1969 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1960 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1971 X1 X2 X3 H).
   intro H. elim (rem_1962  H).
  intros X1 X2. intro H. elim (rem_1966 X1 X2 H).
  exact (rem_1959 epsilon_m__def_10_pknows ).
  intros X1 X2. intro H. elim (rem_1974 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1964 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1963 X1 X2 X3 H).
   intro H. elim (rem_1970  H).
   intro H. elim (rem_1972  H).
  intros X1. intro H. elim (rem_1961 X1 H).
   intro H. elim (rem_1973  H).
   intro H. elim (rem_1967  H).
Qed.

Remark rem_1976 : (forall X:term, auto___def_8 X -> auto_knows X)
    -> forall X2:term, auto___def_10 X2 -> auto_knows X2. (* Cut history. *)
Proof.  intros epsilon_m__def_8_pknows. exact (rem_1975).
Defined.

Remark rem_1977 : (forall X:term, auto___def_8 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_9 X1 -> auto___def_10 X2 -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_8_pknows. intros X1 X2.
  cut (auto___def_10 X2 -> auto_knows X2). tauto. exact (rem_1976 epsilon_m__def_8_pknows X2).
Defined.

Remark rem_1978 : (forall X:term, auto___def_8 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_9 X1 -> auto___def_10 X2 -> (auto_knows X1 /\ auto_knows X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_8_pknows. intros X1 X2. intros A1 A2.
  cut (auto_knows X1). 2:apply (rem_1955 epsilon_m__def_8_pknows X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_1977 epsilon_m__def_8_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1979 : (forall X:term, auto___def_8 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_9 X1 -> auto___def_10 X2 -> auto_knows (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_8_pknows. intros X1 X2. intros A1 A2.
  case (rem_1978 epsilon_m__def_8_pknows X1 X2 A1 A2). clear  epsilon_m__def_8_pknows A1 A2. intros. apply trans_knows_cons_1;  tauto.
 clear  epsilon_m__def_8_pknows A1 A2. tauto.
Defined.

Remark rem_1980 : forall X1 X2:term, auto___def_8 (cons X1 X2) -> or_1
    (auto___def_9 X1 /\ auto___def_10 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1981 : (forall X:term, auto___def_8 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_8 (cons X1 X2) -> auto_knows (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_8_pknows. intros X1 X2. intro H. intros.
  elim (rem_1980 X1 X2 H);  intros.
  apply (rem_1979 epsilon_m__def_8_pknows X1 X2);  tauto.
Defined.

Remark rem_1982 : forall X1 X2:term, auto___def_8 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1983 : forall X1:term, auto___def_8 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1984 : auto___def_8 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1985 : auto___def_8 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1986 : forall X1 X2 X3:term, auto___def_8 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1987 : forall X1 X2 X3:term, auto___def_8 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1988 : auto___def_8 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1989 : forall X1 X2:term, auto___def_8 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1990 : auto___def_8 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1991 : auto___def_8 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1992 : auto___def_8 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1993 : forall X1 X2 X3:term, auto___def_8 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1994 : auto___def_8 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1995 : auto___def_8 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1996 : forall X1 X2:term, auto___def_8 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1997 : forall X2:term, auto___def_8 X2 -> auto_knows X2. (* Induct. *)
Proof.
  fix epsilon_m__def_8_pknows 1.
  intro X. case X.
   intro H. elim (rem_1991  H).
   intro H. elim (rem_1988  H).
  intros X1 X2;  exact (rem_1981 epsilon_m__def_8_pknows X1 X2).
  intros X1 X2. intro H. elim (rem_1982 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1993 X1 X2 X3 H).
   intro H. elim (rem_1985  H).
  intros X1 X2. intro H. elim (rem_1989 X1 X2 H).
   intro H. elim (rem_1984  H).
  intros X1 X2. intro H. elim (rem_1996 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_1987 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_1986 X1 X2 X3 H).
   intro H. elim (rem_1992  H).
   intro H. elim (rem_1994  H).
  intros X1. intro H. elim (rem_1983 X1 H).
   intro H. elim (rem_1995  H).
   intro H. elim (rem_1990  H).
Qed.

Remark rem_1998 : (forall X:term, auto___def_7 X -> auto_knows X)
    -> forall X2:term, auto___def_8 X2 -> auto_knows X2. (* Cut history. *)
Proof.  intros epsilon_m__def_7_pknows. exact (rem_1997).
Defined.

Remark rem_1999 : (forall X:term, auto___def_7 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_2 X1 -> auto___def_8 X2 -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_7_pknows. intros X1 X2.
  cut (auto___def_8 X2 -> auto_knows X2). tauto. exact (rem_1998 epsilon_m__def_7_pknows X2).
Defined.

Remark rem_2000 : (forall X:term, auto___def_7 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_2 X1 -> auto___def_8 X2 -> (auto_knows X1 /\ auto_knows X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_7_pknows. intros X1 X2. intros A1 A2.
  cut (auto_knows X1). 2:apply (rem_1929 epsilon_m__def_7_pknows X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_1999 epsilon_m__def_7_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2001 : (forall X:term, auto___def_7 X -> auto_knows X)
    -> forall X1 X2:term, auto___type_2 X1 -> auto___def_8 X2 -> auto_knows (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_7_pknows. intros X1 X2. intros A1 A2.
  case (rem_2000 epsilon_m__def_7_pknows X1 X2 A1 A2). clear  epsilon_m__def_7_pknows A1 A2. intros. apply trans_knows_cons_1;  tauto.
 clear  epsilon_m__def_7_pknows A1 A2. tauto.
Defined.

Remark rem_2002 : forall X1 X2:term, auto___def_7 (cons X1 X2) -> or_1
    (auto___type_2 X1 /\ auto___def_8 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2003 : (forall X:term, auto___def_7 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_7 (cons X1 X2) -> auto_knows (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_7_pknows. intros X1 X2. intro H. intros.
  elim (rem_2002 X1 X2 H);  intros.
  apply (rem_2001 epsilon_m__def_7_pknows X1 X2);  tauto.
Defined.

Remark rem_2004 : forall X1 X2:term, auto___def_7 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2005 : forall X1:term, auto___def_7 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2006 : auto___def_7 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2007 : auto___def_7 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2008 : forall X1 X2 X3:term, auto___def_7 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2009 : forall X1 X2 X3:term, auto___def_7 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2010 : auto___def_7 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2011 : forall X1 X2:term, auto___def_7 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2012 : auto___def_7 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2013 : auto___def_7 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2014 : auto___def_7 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2015 : forall X1 X2 X3:term, auto___def_7 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2016 : auto___def_7 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2017 : auto___def_7 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2018 : forall X1 X2:term, auto___def_7 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2019 : forall X2:term, auto___def_7 X2 -> auto_knows X2. (* Induct. *)
Proof.
  fix epsilon_m__def_7_pknows 1.
  intro X. case X.
   intro H. elim (rem_2013  H).
   intro H. elim (rem_2010  H).
  intros X1 X2;  exact (rem_2003 epsilon_m__def_7_pknows X1 X2).
  intros X1 X2. intro H. elim (rem_2004 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_2015 X1 X2 X3 H).
   intro H. elim (rem_2007  H).
  intros X1 X2. intro H. elim (rem_2011 X1 X2 H).
   intro H. elim (rem_2006  H).
  intros X1 X2. intro H. elim (rem_2018 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_2009 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2008 X1 X2 X3 H).
   intro H. elim (rem_2014  H).
   intro H. elim (rem_2016  H).
  intros X1. intro H. elim (rem_2005 X1 H).
   intro H. elim (rem_2017  H).
   intro H. elim (rem_2012  H).
Qed.

Remark rem_2020 : forall X1 X2:term, auto___def_7 X2 -> auto___type_1 X1 -> auto_knows X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_7 X2 -> auto_knows X2). tauto. exact (rem_2019 X2).
Qed.

Remark rem_2021 : forall X1 X2:term, auto___def_7 X2 -> auto___type_1 X1 -> (auto_knows X1 /\ auto_knows X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto_knows X1). 2:apply (rem_1901 X1 X2);  assumption.
  cut (auto_knows X2). 2:apply (rem_2020 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2022 : forall X1 X2:term, auto___def_7 X2 -> auto___type_1 X1 -> auto_knows (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2021 X1 X2 A1 A2). clear  A1 A2. intros. apply trans_knows_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2023 : forall X1 X2:term, auto_knows X2 -> auto_knows X1 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1831 X1 X2 A1 A2). clear  A1 A2. intros. apply trans_knows_crypt_5;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2024 : forall X1 X2 X3 X4:term, auto___def_16 X2 -> auto___def_20 X3 -> auto___type_4 X4 -> auto___type_5 X1 -> auto_agent X1 -> auto_agent X4 -> auto___type_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_5 X1 -> auto___type_5 X1). tauto. exact (rem_917 X1).
Qed.

Remark rem_2025 : forall X1 X2 X3 X4:term, auto___def_16 X2 -> auto___def_20 X3 -> auto___type_4 X4 -> auto___type_5 X1 -> auto_agent X1 -> auto_agent X4 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_931 X1).
Qed.

Remark rem_2026 : forall X1 X2 X3 X4:term, auto___def_16 X2 -> auto___def_20 X3 -> auto___type_4 X4 -> auto___type_5 X1 -> auto_agent X1 -> auto_agent X4 -> auto___def_16 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_16 X2 -> auto___def_16 X2). tauto. exact (rem_1569 X2).
Qed.

Remark rem_2027 : forall X1 X2 X3 X4:term, auto___def_16 X2 -> auto___def_20 X3 -> auto___type_4 X4 -> auto___type_5 X1 -> auto_agent X1 -> auto_agent X4 -> (auto___type_5 X1 /\ auto_agent X1 /\ auto___def_16 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  cut (auto___type_5 X1). 2:apply (rem_2024 X1 X2 X3 X4);  assumption.
  cut (auto_agent X1). 2:apply (rem_2025 X1 X2 X3 X4);  assumption.
  cut (auto___def_16 X2). 2:apply (rem_2026 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_2028 : forall X1 X2 X3 X4:term, auto___def_16 X2 -> auto___def_20 X3 -> auto___type_4 X4 -> auto___type_5 X1 -> auto_agent X1 -> auto_agent X4 -> auto_alice_key X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  case (rem_2027 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6). clear  A1 A2 A3 A4 A5 A6. intros. apply trans_alice_key_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6. tauto.
Qed.

Remark rem_2029 : forall X1 X2 X3 X4:term, auto___type_5 X1 -> auto_agent X1 -> auto___type_4 X3 -> auto_agent X3 -> auto___def_20 X4 -> auto___def_16 X2 -> auto_alice_key X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X4 X3.
  cut (auto___def_16 X2 -> auto___def_20 X3 -> auto___type_4 X4 -> auto___type_5 X1 -> auto_agent X1 -> auto_agent X4 -> auto_alice_key X1 X2). tauto. exact (rem_2028 X1 X2 X3 X4).
Qed.

Remark rem_2030 : forall X1 X2 X3 X4:term, auto___def_33 X2 -> auto___def_36 X3 -> auto___type_4 X4 -> auto___type_5 X1 -> auto_agent X1 -> auto_agent X4 -> auto___type_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___type_5 X1 -> auto___type_5 X1). tauto. exact (rem_917 X1).
Qed.

Remark rem_2031 : forall X1 X2 X3 X4:term, auto___def_33 X2 -> auto___def_36 X3 -> auto___type_4 X4 -> auto___type_5 X1 -> auto_agent X1 -> auto_agent X4 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_931 X1).
Qed.

Remark rem_2032 : forall X1 X2 X3 X4:term, auto___def_33 X2 -> auto___def_36 X3 -> auto___type_4 X4 -> auto___type_5 X1 -> auto_agent X1 -> auto_agent X4 -> auto___def_33 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_33 X2 -> auto___def_33 X2). tauto. exact (rem_1623 X2).
Qed.

Remark rem_2033 : forall X1 X2 X3 X4:term, auto___def_33 X2 -> auto___def_36 X3 -> auto___type_4 X4 -> auto___type_5 X1 -> auto_agent X1 -> auto_agent X4 -> (auto___type_5 X1 /\ auto_agent X1 /\ auto___def_33 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  cut (auto___type_5 X1). 2:apply (rem_2030 X1 X2 X3 X4);  assumption.
  cut (auto_agent X1). 2:apply (rem_2031 X1 X2 X3 X4);  assumption.
  cut (auto___def_33 X2). 2:apply (rem_2032 X1 X2 X3 X4);  assumption.
  tauto.
Qed.

Remark rem_2034 : forall X1 X2 X3 X4:term, auto___def_33 X2 -> auto___def_36 X3 -> auto___type_4 X4 -> auto___type_5 X1 -> auto_agent X1 -> auto_agent X4 -> auto_alice_key X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4. intros A1 A2 A3 A4 A5 A6.
  case (rem_2033 X1 X2 X3 X4 A1 A2 A3 A4 A5 A6). clear  A1 A2 A3 A4 A5 A6. intros. apply trans_alice_key_2;  tauto.
 clear  A1 A2 A3 A4 A5 A6. tauto.
Qed.

Remark rem_2035 : forall X1 X2 X3 X4:term, auto___type_5 X1 -> auto_agent X1 -> auto___type_4 X3 -> auto_agent X3 -> auto___def_36 X4 -> auto___def_33 X2 -> auto_alice_key X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X4 X3.
  cut (auto___def_33 X2 -> auto___def_36 X3 -> auto___type_4 X4 -> auto___type_5 X1 -> auto_agent X1 -> auto_agent X4 -> auto_alice_key X1 X2). tauto. exact (rem_2034 X1 X2 X3 X4).
Qed.

Remark rem_2036 : forall X1 X2 X3 X4:term, auto___def_38 X1 X2 X3 X4 -> or_2
    (auto___type_5 X1 /\ auto_agent X1 /\ auto___type_4 X2 /\ auto_agent X2 /\ auto___def_20 X3 /\ auto___def_16 X4)
    (auto___type_5 X1 /\ auto_agent X1 /\ auto___type_4 X2 /\ auto_agent X2 /\ auto___def_36 X3 /\ auto___def_33 X4)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_2037 : forall X1 X2 X3 X4:term, auto___def_38 X1 X3 X4 X2 -> auto_alice_key X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_2036 X1 X3 X4 X2 H);  intros.
  apply (rem_2029 X1 X2 X3 X4);  tauto.
  apply (rem_2035 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2038 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_12 X1). tauto. exact (rem_1143 X1).
Qed.

Remark rem_2039 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_1576 X2).
Qed.

Remark rem_2040 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> (auto___def_12 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_12 X1). 2:apply (rem_2038 X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_2039 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2041 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2040 X1 X2 A1 A2). clear  A1 A2. intros. apply trans_knows_crypt_2;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2042 : forall X1 X2:term, auto___def_13 X2 -> auto___def_12 X1 -> auto_knows (crypt X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_13 X2 -> auto_knows (crypt X1 X2)). tauto. exact (rem_2041 X1 X2).
Qed.

Remark rem_2043 : auto_agent alice. (* Deduce positive atom. *)
Proof.
   case rem_1393. intros. apply trans_agent_alice_1;  tauto.
 tauto.
Qed.

Remark rem_2044 : auto_knows nil. (* Deduce positive atom. *)
Proof.
   case rem_1393. intros. apply trans_knows_nil_1;  tauto.
 tauto.
Qed.

Remark rem_2045 : forall X1 X2:term, auto___def_6 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2046 : (forall X:term, auto___def_25 X -> auto___def_6 X -> False)
    -> forall X1 X2:term, auto___def_6 (cons X1 X2) -> auto___type_4 X1 -> auto___def_26 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_25_m__def_6. intros X1 X2. intro H. intros.
  elim (rem_2045 X1 X2 H);  intros.
Defined.

Remark rem_2047 : (forall X:term, auto___def_25 X -> auto___def_6 X -> False)
    -> forall X1 X2:term, auto___def_25 (cons X1 X2) -> auto___def_6 (cons X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_25_m__def_6. intros X1 X2. intro H. intros.
  elim (rem_443 X1 X2 H);  intros.
  apply (rem_2046 epsilon_m__def_25_m__def_6 X1 X2);  tauto.
Defined.

Remark rem_2048 : forall X1:term, auto___def_25 X1 -> auto___def_6 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_25_m__def_6 1.
  intro X. case X.
   intro H. elim (rem_454  H).
   intro H. elim (rem_451  H).
  intros X1 X2;  exact (rem_2047 epsilon_m__def_25_m__def_6 X1 X2).
  intros X1 X2. intro H. elim (rem_445 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_164 X1 X2 X3 H).
   intro H. elim (rem_448  H).
  intros X1 X2. intro H. elim (rem_452 X1 X2 H).
   intro H. elim (rem_447  H).
  intros X1 X2. intro H. elim (rem_458 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_450 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_449 X1 X2 X3 H).
   intro H. elim (rem_455  H).
   intro H. elim (rem_456  H).
  intros X1. intro H. elim (rem_446 X1 H).
   intro H. elim (rem_457  H).
   intro H. elim (rem_453  H).
Qed.

Remark rem_2049 : forall X1 X2:term, auto___def_22 X1 -> auto___def_25 X2 -> auto___def_6 X2 -> auto_knows X1. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2048 X2)). tauto.
Qed.

Remark rem_2050 : forall X1 X2:term, auto___def_25 X2 -> auto___def_37 X1 -> auto___def_6 X2 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_37 X1 -> auto_knows X1). tauto. exact (rem_437 X1).
Qed.

Remark rem_2051 : forall X1 X2:term, auto___def_37 X1 -> auto___def_25 X2 -> auto___def_6 X2 -> auto_knows X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_25 X2 -> auto___def_37 X1 -> auto___def_6 X2 -> auto_knows X1). tauto. exact (rem_2050 X1 X2).
Qed.

Remark rem_2052 : (forall X:term, auto___def_29 X -> auto___def_6 X -> False)
    -> forall X1 X2:term, auto___def_6 (cons X1 X2) -> auto___type_5 X1 -> auto___def_26 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_29_m__def_6. intros X1 X2. intro H. intros.
  elim (rem_2045 X1 X2 H);  intros.
Defined.

Remark rem_2053 : (forall X:term, auto___def_29 X -> auto___def_6 X -> False)
    -> forall X1 X2:term, auto___def_29 (cons X1 X2) -> auto___def_6 (cons X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_29_m__def_6. intros X1 X2. intro H. intros.
  elim (rem_472 X1 X2 H);  intros.
  apply (rem_2052 epsilon_m__def_29_m__def_6 X1 X2);  tauto.
Defined.

Remark rem_2054 : forall X1:term, auto___def_29 X1 -> auto___def_6 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_29_m__def_6 1.
  intro X. case X.
   intro H. elim (rem_483  H).
   intro H. elim (rem_480  H).
  intros X1 X2;  exact (rem_2053 epsilon_m__def_29_m__def_6 X1 X2).
  intros X1 X2. intro H. elim (rem_474 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_120 X1 X2 X3 H).
   intro H. elim (rem_477  H).
  intros X1 X2. intro H. elim (rem_481 X1 X2 H).
   intro H. elim (rem_476  H).
  intros X1 X2. intro H. elim (rem_487 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_479 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_478 X1 X2 X3 H).
   intro H. elim (rem_484  H).
   intro H. elim (rem_485  H).
  intros X1. intro H. elim (rem_475 X1 H).
   intro H. elim (rem_486  H).
   intro H. elim (rem_482  H).
Qed.

Remark rem_2055 : forall X1 X2:term, auto___def_12 X1 -> auto___def_29 X2 -> auto___def_6 X2 -> auto_knows X1. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2054 X2)). tauto.
Qed.

Remark rem_2056 : forall X1 X2:term, auto___def_47 X2 -> auto___def_6 X2 -> auto_knows X1 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows X1 -> auto_knows X1). tauto. exact (rem_466 X1).
Qed.

Remark rem_2057 : forall X1 X2:term, auto_knows X1 -> auto___def_47 X2 -> auto___def_6 X2 -> auto_knows X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_47 X2 -> auto___def_6 X2 -> auto_knows X1 -> auto_knows X1). tauto. exact (rem_2056 X1 X2).
Qed.

Remark rem_2058 : forall X1 X2:term, auto___def_29 X2 -> auto___def_30 X1 -> auto___def_6 X2 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_30 X1 -> auto_knows X1). tauto. exact (rem_849 X1).
Qed.

Remark rem_2059 : forall X1 X2:term, auto___def_30 X1 -> auto___def_29 X2 -> auto___def_6 X2 -> auto_knows X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_29 X2 -> auto___def_30 X1 -> auto___def_6 X2 -> auto_knows X1). tauto. exact (rem_2058 X1 X2).
Qed.

Remark rem_2060 : forall X1 X2:term, auto___def_19 X2 -> auto___def_42 X1 -> auto___def_6 X2 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_42 X1 -> auto_knows X1). tauto. exact (rem_910 X1).
Qed.

Remark rem_2061 : forall X1 X2:term, auto___def_42 X1 -> auto___def_19 X2 -> auto___def_6 X2 -> auto_knows X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_42 X1 -> auto___def_6 X2 -> auto_knows X1). tauto. exact (rem_2060 X1 X2).
Qed.

Remark rem_2062 : forall X1 X2:term, auto___def_19 X2 -> auto___def_40 X1 -> auto___def_6 X2 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_40 X1 -> auto_knows X1). tauto. exact (rem_885 X1).
Qed.

Remark rem_2063 : forall X1 X2:term, auto___def_40 X1 -> auto___def_19 X2 -> auto___def_6 X2 -> auto_knows X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_40 X1 -> auto___def_6 X2 -> auto_knows X1). tauto. exact (rem_2062 X1 X2).
Qed.

Remark rem_2064 : forall X1 X2:term, auto___def_5 X1 X2 -> or_7
    (auto___def_22 X1 /\ auto___def_25 X2)
    (auto___def_37 X1 /\ auto___def_25 X2)
    (auto___def_12 X1 /\ auto___def_29 X2)
    (auto_knows X1 /\ auto___def_47 X2)
    (auto___def_30 X1 /\ auto___def_29 X2)
    (auto___def_42 X1 /\ auto___def_19 X2)
    (auto___def_40 X1 /\ auto___def_19 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_7_intro_1; tauto.
  intros. apply or_7_intro_2; tauto.
  intros. apply or_7_intro_3; tauto.
  intros. apply or_7_intro_4; tauto.
  intros. apply or_7_intro_5; tauto.
  intros. apply or_7_intro_6; tauto.
  intros. apply or_7_intro_7; tauto.
Qed.

Remark rem_2065 : forall X1 X2:term, auto___def_5 X1 X2 -> auto___def_6 X2 -> auto_knows X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_2064 X1 X2 H);  intros.
  apply (rem_2049 X1 X2);  tauto.
  apply (rem_2051 X1 X2);  tauto.
  apply (rem_2055 X1 X2);  tauto.
  apply (rem_2057 X1 X2);  tauto.
  apply (rem_2059 X1 X2);  tauto.
  apply (rem_2061 X1 X2);  tauto.
  apply (rem_2063 X1 X2);  tauto.
Qed.

Remark rem_2066 : forall X1:term, auto___def_46 X1 -> auto___def_46 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2067 : forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_46 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_46 X1 -> auto___def_46 X1). tauto. exact (rem_2066 X1).
Qed.

Remark rem_2068 : forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto___def_47 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_47 X2 -> auto___def_47 X2). tauto. exact (rem_1169 X2).
Qed.

Remark rem_2069 : forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> (auto___def_46 X1 /\ auto___def_47 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_46 X1). 2:apply (rem_2067 X1 X2);  assumption.
  cut (auto___def_47 X2). 2:apply (rem_2068 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2070 : forall X1 X2:term, auto___def_46 X1 -> auto___def_47 X2 -> auto_knows (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2069 X1 X2 A1 A2). clear  A1 A2. intros. apply trans_knows_key_2;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2071 : forall X1 X2:term, auto___def_47 X2 -> auto___def_46 X1 -> auto_knows (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_46 X1 -> auto___def_47 X2 -> auto_knows (key X1 X2)). tauto. exact (rem_2070 X1 X2).
Qed.

Remark rem_2072 : (forall X:term, auto___def_43 X -> auto___def_18 X -> False)
    -> auto___def_18 pub -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_43_m__def_18. intro H. intros.
  elim (rem_207 H);  intros.
Defined.

Remark rem_2073 : auto___def_43 pub -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2074 : (forall X:term, auto___def_43 X -> auto___def_18 X -> False)
    -> auto___def_43 pub -> auto___def_18 pub -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_43_m__def_18. intro H. intros.
  elim (rem_2073 H);  intros.
  apply (rem_2072 epsilon_m__def_43_m__def_18);  tauto.
Defined.

Remark rem_2075 : forall X1 X2:term, auto___def_43 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2076 : forall X1:term, auto___def_43 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2077 : auto___def_43 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2078 : auto___def_43 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2079 : forall X1 X2 X3:term, auto___def_43 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2080 : forall X1 X2 X3:term, auto___def_43 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2081 : auto___def_43 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2082 : forall X1 X2:term, auto___def_43 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2083 : auto___def_43 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2084 : forall X1 X2:term, auto___def_43 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2085 : forall X1 X2 X3:term, auto___def_43 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2086 : auto___def_43 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2087 : forall X1 X2:term, auto___def_43 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2088 : forall X1:term, auto___def_43 X1 -> auto___def_18 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_43_m__def_18 1.
  intro X. case X.
   intro H. elim (rem_2083  H).
   intro H. elim (rem_2081  H).
  intros X1 X2. intro H. elim (rem_2084 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2075 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_2085 X1 X2 X3 H).
   intro H. elim (rem_2078  H).
  intros X1 X2. intro H. elim (rem_2082 X1 X2 H).
   intro H. elim (rem_2077  H).
  intros X1 X2. intro H. elim (rem_2087 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_2080 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2079 X1 X2 X3 H).
   intro H. elim (rem_1372  H).
  exact (rem_2074 epsilon_m__def_43_m__def_18 ).
  intros X1. intro H. elim (rem_2076 X1 H).
   intro H. elim (rem_2086  H).
   intro H. elim (rem_978  H).
Qed.

Remark rem_2089 : forall X1 X2 X3 X4:term, auto___def_18 X1 -> auto___def_43 X1 -> auto_knows X2 -> auto_knows X3 -> auto_knows X4 -> False. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_2088 X1)). tauto.
Qed.

Remark rem_2090 : forall X1 X2 X3 X4:term, auto___def_18 X1 -> auto___def_43 X1 -> auto___type_8 (current_session X2 X3 X4) -> auto_knows X2 -> auto_knows X3 -> auto_knows X4 -> False. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2 X3 X4. intros. apply (rem_2089 X1 X2 X3 X4);  assumption.
Qed.

Remark rem_2091 : forall X1 X2 X3 X4:term, auto___def_43 X1 -> auto___type_8 (current_session X2 X4 X3) -> auto___def_18 X1 -> auto_knows X2 -> auto_knows X3 -> auto_knows X4 -> False. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X4 X3.
  cut (auto___def_18 X1 -> auto___def_43 X1 -> auto___type_8 (current_session X2 X3 X4) -> auto_knows X2 -> auto_knows X3 -> auto_knows X4 -> False). tauto. exact (rem_2090 X1 X2 X3 X4).
Qed.

Remark rem_2092 : forall X1 X2 X3:term, auto___def_47 (current_session X1 X2 X3) -> auto_knows X1 -> auto_knows X3 -> auto_knows X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3. intro H. intros.
  elim (rem_1041 X1 X2 X3 H);  intros.
Qed.

Remark rem_2093 : forall X2 X3 X4:term, auto___def_47 (current_session X2 X3 X4) -> auto_knows X2 -> auto_knows X3 -> auto_knows X4 -> False. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3.
  cut (auto___def_47 (current_session X1 X2 X3) -> auto_knows X1 -> auto_knows X3 -> auto_knows X2 -> False). tauto. exact (rem_2092 X1 X2 X3).
Qed.

Remark rem_2094 : forall X1 X2 X3 X4:term, auto___def_18 X1 -> auto___def_46 X1 -> auto___def_47 (current_session X2 X3 X4) -> auto_knows X2 -> auto_knows X3 -> auto_knows X4 -> False. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_47 (current_session X2 X3 X4) -> auto_knows X2 -> auto_knows X3 -> auto_knows X4 -> False). tauto.
  exact (rem_2093 X2 X3 X4).
Qed.

Remark rem_2095 : forall X1 X2 X3 X4:term, auto___def_46 X1 -> auto___def_47 (current_session X2 X4 X3) -> auto___def_18 X1 -> auto_knows X2 -> auto_knows X3 -> auto_knows X4 -> False. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X4 X3.
  cut (auto___def_18 X1 -> auto___def_46 X1 -> auto___def_47 (current_session X2 X3 X4) -> auto_knows X2 -> auto_knows X3 -> auto_knows X4 -> False). tauto. exact (rem_2094 X1 X2 X3 X4).
Qed.

Remark rem_2096 : (forall X:term, auto___def_44 X -> auto___def_18 X -> False)
    -> auto___def_18 prv -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_44_m__def_18. intro H. intros.
  elim (rem_205 H);  intros.
Defined.

Remark rem_2097 : auto___def_44 prv -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2098 : (forall X:term, auto___def_44 X -> auto___def_18 X -> False)
    -> auto___def_44 prv -> auto___def_18 prv -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_44_m__def_18. intro H. intros.
  elim (rem_2097 H);  intros.
  apply (rem_2096 epsilon_m__def_44_m__def_18);  tauto.
Defined.

Remark rem_2099 : forall X1 X2:term, auto___def_44 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2100 : forall X1:term, auto___def_44 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2101 : auto___def_44 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2102 : auto___def_44 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2103 : forall X1 X2 X3:term, auto___def_44 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2104 : forall X1 X2 X3:term, auto___def_44 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2105 : auto___def_44 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2106 : forall X1 X2:term, auto___def_44 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2107 : auto___def_44 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2108 : forall X1 X2:term, auto___def_44 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2109 : forall X1 X2 X3:term, auto___def_44 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2110 : auto___def_44 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2111 : auto___def_44 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2112 : forall X1 X2:term, auto___def_44 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2113 : forall X1:term, auto___def_44 X1 -> auto___def_18 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_44_m__def_18 1.
  intro X. case X.
   intro H. elim (rem_2107  H).
   intro H. elim (rem_2105  H).
  intros X1 X2. intro H. elim (rem_2108 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2099 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_2109 X1 X2 X3 H).
   intro H. elim (rem_2102  H).
  intros X1 X2. intro H. elim (rem_2106 X1 X2 H).
   intro H. elim (rem_2101  H).
  intros X1 X2. intro H. elim (rem_2112 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_2104 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2103 X1 X2 X3 H).
  exact (rem_2098 epsilon_m__def_44_m__def_18 ).
   intro H. elim (rem_2110  H).
  intros X1. intro H. elim (rem_2100 X1 H).
   intro H. elim (rem_2111  H).
   intro H. elim (rem_1047  H).
Qed.

Remark rem_2114 : forall X1 X2 X3 X4:term, auto___def_18 X1 -> auto___def_44 X1 -> auto___def_45 (current_session X2 X3 X4) -> auto_knows X2 -> auto_knows X3 -> auto_knows X4 -> False. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_2113 X1)). tauto.
Qed.

Remark rem_2115 : forall X1 X2 X3 X4:term, auto___def_44 X1 -> auto___def_45 (current_session X2 X4 X3) -> auto___def_18 X1 -> auto_knows X2 -> auto_knows X3 -> auto_knows X4 -> False. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X4 X3.
  cut (auto___def_18 X1 -> auto___def_44 X1 -> auto___def_45 (current_session X2 X3 X4) -> auto_knows X2 -> auto_knows X3 -> auto_knows X4 -> False). tauto. exact (rem_2114 X1 X2 X3 X4).
Qed.

Remark rem_2116 : forall X1 X2 X3 X4:term, auto___def_18 X1 -> auto_knows X2 -> auto_knows X3 -> auto_knows X4 -> auto_knows (key X1 (current_session X2 X4 X3)) -> False. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_91 X1 (current_session X2 X4 X3) H);  intros.
  apply (rem_2091 X1 X2 X3 X4);  tauto.
  apply (rem_2095 X1 X2 X3 X4);  tauto.
  apply (rem_2115 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2117 : forall X1 X2 X3 X4:term, auto_knows X2 -> auto_knows X3 -> auto_knows X4 -> auto___def_18 X1 -> auto_knows (key X1 (current_session X2 X3 X4)) -> False. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X4 X3.
  cut (auto___def_18 X1 -> auto_knows X2 -> auto_knows X3 -> auto_knows X4 -> auto_knows (key X1 (current_session X2 X4 X3)) -> False). tauto. exact (rem_2116 X1 X2 X3 X4).
Qed.

Remark rem_2118 : forall X1 X2 X3 X4:term, auto___def_18 X1 -> auto___def_19 (current_session X2 X3 X4) -> auto_knows (key X1 (current_session X2 X3 X4)) -> False. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_122 X2 X3 X4 H);  intros.
  apply (rem_2117 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2119 : forall X1 X2 X3 X4:term, auto___def_16 (key X1 (current_session X2 X3 X4)) -> auto_knows (key X1 (current_session X2 X3 X4)) -> False. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_144 X1 (current_session X2 X3 X4) H);  intros.
  apply (rem_2118 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2120 : forall X1 X2 X3 X4:term, auto___def_16 (key X1 (current_session X2 X3 X4)) -> auto___type_5 alice -> auto_agent alice -> auto_knows (key X1 (current_session X2 X3 X4)) -> False. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_16 (key X1 (current_session X2 X3 X4)) -> auto_knows (key X1 (current_session X2 X3 X4)) -> False). tauto.
  exact (rem_2119 X1 X2 X3 X4).
Qed.

Remark rem_2121 : forall X1 X2 X3 X4:term, auto___type_5 alice -> auto_agent alice -> auto___def_16 (key X1 (current_session X2 X3 X4)) -> auto_knows (key X1 (current_session X2 X3 X4)) -> False. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_16 (key X1 (current_session X2 X3 X4)) -> auto___type_5 alice -> auto_agent alice -> auto_knows (key X1 (current_session X2 X3 X4)) -> False). tauto. exact (rem_2120 X1 X2 X3 X4).
Qed.

Remark rem_2122 : forall X1 X2 X3 X4:term, auto___def_18 X1 -> auto___def_35 (current_session X2 X3 X4) -> auto_knows (key X1 (current_session X2 X3 X4)) -> False. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intros H1. intro H. intros.
  elim (rem_228 X2 X3 X4 H);  intros.
Qed.

Remark rem_2123 : forall X1 X2 X3 X4:term, auto___def_33 (key X1 (current_session X2 X3 X4)) -> auto_knows (key X1 (current_session X2 X3 X4)) -> False. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_237 X1 (current_session X2 X3 X4) H);  intros.
  apply (rem_2122 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2124 : forall X1 X2 X3 X4:term, auto___def_33 (key X1 (current_session X2 X3 X4)) -> auto___type_5 alice -> auto_agent alice -> auto_knows (key X1 (current_session X2 X3 X4)) -> False. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_33 (key X1 (current_session X2 X3 X4)) -> auto_knows (key X1 (current_session X2 X3 X4)) -> False). tauto.
  exact (rem_2123 X1 X2 X3 X4).
Qed.

Remark rem_2125 : forall X1 X2 X3 X4:term, auto___type_5 alice -> auto_agent alice -> auto___def_33 (key X1 (current_session X2 X3 X4)) -> auto_knows (key X1 (current_session X2 X3 X4)) -> False. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_33 (key X1 (current_session X2 X3 X4)) -> auto___type_5 alice -> auto_agent alice -> auto_knows (key X1 (current_session X2 X3 X4)) -> False). tauto. exact (rem_2124 X1 X2 X3 X4).
Qed.

Remark rem_2126 : forall X1 X2 X3 X4:term, auto_alice_key alice (key X1 (current_session X2 X3 X4)) -> auto_knows (key X1 (current_session X2 X3 X4)) -> False. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1664 alice (key X1 (current_session X2 X3 X4)) H);  intros.
  apply (rem_2121 X1 X2 X3 X4);  tauto.
  apply (rem_2125 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2127 : forall X1 X2 X3 X4:term, auto_alice_key alice (key X1 (current_session X2 X3 X4)) -> auto_knows (key X1 (current_session X2 X3 X4)) -> auto___query__intruder_knows_session_key_as_seen_by_alice. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_alice_key alice (key X1 (current_session X2 X3 X4)) -> auto_knows (key X1 (current_session X2 X3 X4)) -> False). tauto.
  exact (rem_2126 X1 X2 X3 X4).
Qed.

Remark rem_2128 : forall X1 X2 X3 X4:term, auto_knows (key X1 (current_session X2 X3 X4)) -> auto_alice_key alice (key X1 (current_session X2 X3 X4)) -> auto___query__intruder_knows_session_key_as_seen_by_alice. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto_alice_key alice (key X1 (current_session X2 X3 X4)) -> auto_knows (key X1 (current_session X2 X3 X4)) -> auto___query__intruder_knows_session_key_as_seen_by_alice). tauto. exact (rem_2127 X1 X2 X3 X4).
Qed.

Remark rem_2129 : (forall X:term, auto___def_20 X -> auto_knows X)
    -> forall X1:term, auto___def_22 X1 -> auto___def_22 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2130 : (forall X:term, auto___def_20 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_22 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_20_pknows. intros X1 X2.
  cut (auto___def_22 X1 -> auto___def_22 X1). tauto. exact (rem_2129 epsilon_m__def_20_pknows X1).
Defined.

Remark rem_2131 : (forall X:term, auto___def_20 X -> auto_knows X)
    -> forall X2:term, auto___def_23 X2 -> auto___def_23 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2132 : (forall X:term, auto___def_20 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto___def_23 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_20_pknows. intros X1 X2.
  cut (auto___def_23 X2 -> auto___def_23 X2). tauto. exact (rem_2131 epsilon_m__def_20_pknows X2).
Defined.

Remark rem_2133 : (forall X:term, auto___def_20 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> (auto___def_22 X1 /\ auto___def_23 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_20_pknows. intros X1 X2. intros A1 A2.
  cut (auto___def_22 X1). 2:apply (rem_2130 epsilon_m__def_20_pknows X1 X2);  assumption.
  cut (auto___def_23 X2). 2:apply (rem_2132 epsilon_m__def_20_pknows X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2134 : (forall X:term, auto___def_20 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_22 X1 -> auto___def_23 X2 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_20_pknows. intros X1 X2. intros A1 A2.
  case (rem_2133 epsilon_m__def_20_pknows X1 X2 A1 A2). clear  epsilon_m__def_20_pknows A1 A2. intros. apply trans_knows_crypt_3;  tauto.
 clear  epsilon_m__def_20_pknows A1 A2. tauto.
Defined.

Remark rem_2135 : forall X1 X2:term, auto___def_20 (crypt X1 X2) -> or_1
    (auto___def_22 X1 /\ auto___def_23 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2136 : (forall X:term, auto___def_20 X -> auto_knows X)
    -> forall X1 X2:term, auto___def_20 (crypt X1 X2) -> auto_knows (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_20_pknows. intros X1 X2. intro H. intros.
  elim (rem_2135 X1 X2 H);  intros.
  apply (rem_2134 epsilon_m__def_20_pknows X1 X2);  tauto.
Defined.

Remark rem_2137 : forall X1:term, auto___def_20 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2138 : auto___def_20 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2139 : auto___def_20 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2140 : forall X1 X2 X3:term, auto___def_20 (old_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2141 : forall X1 X2 X3:term, auto___def_20 (nonceb X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2142 : auto___def_20 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2143 : forall X1 X2:term, auto___def_20 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2144 : auto___def_20 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2145 : auto___def_20 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2146 : forall X1 X2:term, auto___def_20 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2147 : auto___def_20 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2148 : forall X1 X2 X3:term, auto___def_20 (current_session X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2149 : auto___def_20 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2150 : auto___def_20 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2151 : forall X1 X2:term, auto___def_20 (noncea X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2152 : forall X1:term, auto___def_20 X1 -> auto_knows X1. (* Induct. *)
Proof.
  fix epsilon_m__def_20_pknows 1.
  intro X. case X.
   intro H. elim (rem_2145  H).
   intro H. elim (rem_2142  H).
  intros X1 X2. intro H. elim (rem_2146 X1 X2 H).
  intros X1 X2;  exact (rem_2136 epsilon_m__def_20_pknows X1 X2).
  intros X1 X2 X3. intro H. elim (rem_2148 X1 X2 X3 H).
   intro H. elim (rem_2139  H).
  intros X1 X2. intro H. elim (rem_2143 X1 X2 H).
   intro H. elim (rem_2138  H).
  intros X1 X2. intro H. elim (rem_2151 X1 X2 H).
  intros X1 X2 X3. intro H. elim (rem_2141 X1 X2 X3 H).
  intros X1 X2 X3. intro H. elim (rem_2140 X1 X2 X3 H).
   intro H. elim (rem_2147  H).
   intro H. elim (rem_2149  H).
  intros X1. intro H. elim (rem_2137 X1 H).
   intro H. elim (rem_2150  H).
   intro H. elim (rem_2144  H).
Qed.

Remark rem_2153 : forall X1 X2 X3 X4:term, auto___def_16 X2 -> auto___def_20 X1 -> auto___type_4 X3 -> auto___type_5 X4 -> auto_agent X4 -> auto_agent X3 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_20 X1 -> auto_knows X1). tauto. exact (rem_2152 X1).
Qed.

Remark rem_2154 : forall X1 X2 X3 X4:term, auto___type_5 X2 -> auto_agent X2 -> auto___type_4 X3 -> auto_agent X3 -> auto___def_20 X1 -> auto___def_16 X4 -> auto_knows X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X4 X3 X2.
  cut (auto___def_16 X2 -> auto___def_20 X1 -> auto___type_4 X3 -> auto___type_5 X4 -> auto_agent X4 -> auto_agent X3 -> auto_knows X1). tauto. exact (rem_2153 X1 X2 X3 X4).
Qed.

Remark rem_2155 : forall X1 X2 X3 X4:term, auto___def_33 X2 -> auto___def_36 X1 -> auto___type_4 X3 -> auto___type_5 X4 -> auto_agent X4 -> auto_agent X3 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto___def_36 X1 -> auto_knows X1). tauto. exact (rem_759 X1).
Qed.

Remark rem_2156 : forall X1 X2 X3 X4:term, auto___type_5 X2 -> auto_agent X2 -> auto___type_4 X3 -> auto_agent X3 -> auto___def_36 X1 -> auto___def_33 X4 -> auto_knows X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X4 X3 X2.
  cut (auto___def_33 X2 -> auto___def_36 X1 -> auto___type_4 X3 -> auto___type_5 X4 -> auto_agent X4 -> auto_agent X3 -> auto_knows X1). tauto. exact (rem_2155 X1 X2 X3 X4).
Qed.

Remark rem_2157 : forall X1 X2 X3 X4:term, auto___def_38 X2 X3 X1 X4 -> auto_knows X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_2036 X2 X3 X1 X4 H);  intros.
  apply (rem_2154 X1 X2 X3 X4);  tauto.
  apply (rem_2156 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2158 : forall X1 X2:term, auto___def_45 X2 -> auto_knows X1 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows X1 -> auto_knows X1). tauto. exact (rem_466 X1).
Qed.

Remark rem_2159 : forall X1 X2:term, auto___def_3 X1 X2 -> or_1
    (auto___def_45 X1 /\ auto_knows X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2160 : forall X1 X2:term, auto___def_3 X2 X1 -> auto_knows X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_2159 X2 X1 H);  intros.
  apply (rem_2158 X1 X2);  tauto.
Qed.

Remark rem_2161 : forall X1 X2:term, auto___def_3 X2 X1 -> auto___def_4 X2 -> auto_knows X1. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1 X2. intros. apply (rem_2160 X1 X2);  assumption.
Qed.

Remark rem_2162 : forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> auto___def_40 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_40 X1 -> auto___def_40 X1). tauto. exact (rem_1175 X1).
Qed.

Remark rem_2163 : forall X2:term, auto___type_6 X2 -> auto___type_6 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2164 : forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> auto___type_6 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_6 X2 -> auto___type_6 X2). tauto. exact (rem_2163 X2).
Qed.

Remark rem_2165 : forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> (auto___def_40 X1 /\ auto___type_6 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_40 X1). 2:apply (rem_2162 X1 X2);  assumption.
  cut (auto___type_6 X2). 2:apply (rem_2164 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2166 : forall X1 X2:term, auto___def_40 X1 -> auto___type_6 X2 -> auto_knows (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2165 X1 X2 A1 A2). clear  A1 A2. intros. apply trans_knows_crypt_6;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2167 : forall X1 X2:term, auto___type_6 X2 -> auto___def_40 X1 -> auto_knows (crypt X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_40 X1 -> auto___type_6 X2 -> auto_knows (crypt X1 X2)). tauto. exact (rem_2166 X1 X2).
Qed.

Remark rem_2168 : forall X1 X2:term, auto___def_2 X2 -> auto___type_8 X2 -> auto_knows X1 -> auto_knows X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows X1 -> auto_knows X1). tauto. exact (rem_466 X1).
Qed.

Remark rem_2169 : forall X1 X2:term, auto___type_8 X2 -> auto_knows X1 -> auto___def_2 X2 -> auto_knows X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_2 X2 -> auto___type_8 X2 -> auto_knows X1 -> auto_knows X1). tauto. exact (rem_2168 X1 X2).
Qed.

Remark rem_2170 : forall X1 X2:term, auto___def_1 X1 X2 -> or_1
    (auto___type_8 X1 /\ auto_knows X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2171 : forall X1 X2:term, auto___def_1 X2 X1 -> auto___def_2 X2 -> auto_knows X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_2170 X2 X1 H);  intros.
  apply (rem_2169 X1 X2);  tauto.
Qed.

Remark rem_2172 : forall X1:term, auto___def_43 sym -> auto___type_8 (current_session alice bob X1) -> False. (* Eliminate negative atom by universal clause. *)
Proof.
  intros X1. intros. apply rem_979;  assumption.
Qed.

Remark rem_2173 : forall X1:term, auto___def_47 (current_session alice bob X1) -> False. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_1041 alice bob X1 H);  intros.
Qed.

Remark rem_2174 : forall X1:term, auto___def_46 sym -> auto___def_47 (current_session alice bob X1) -> False. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_47 (current_session alice bob X1) -> False). tauto.
  exact (rem_2173 X1).
Qed.

Remark rem_2175 : forall X1:term, auto___def_44 sym -> auto___def_45 (current_session alice bob X1) -> False. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_44 sym -> False). tauto.
  exact (rem_1048).
Qed.

Remark rem_2176 : forall X1:term, auto_knows (key sym (current_session alice bob X1)) -> False. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_91 sym (current_session alice bob X1) H);  intros.
  apply (rem_2172 X1);  tauto.
  apply (rem_2174 X1);  tauto.
  apply (rem_2175 X1);  tauto.
Qed.

Remark rem_2177 : forall X1:term, auto_knows (key sym (current_session alice bob X1)) -> auto___query__intruder_knows_session_key_generated_by_server. (* Split. *)
Proof.
  intros X1.
  cut (auto_knows (key sym (current_session alice bob X1)) -> False). tauto.
  exact (rem_2176 X1).
Qed.

(* [trnp] Proofs of translated source clauses. *)


Lemma lem_intruder_knows_session_key_as_seen_by_alice : forall _big_mode _big_n X Y:term, auto_alice_key alice (key _big_mode (current_session X Y _big_n)) -> auto_knows (key _big_mode (current_session X Y _big_n)) -> auto___query__intruder_knows_session_key_as_seen_by_alice.
Proof.
   intros _big_mode _big_n X Y. intros H1 H2.
  exact (rem_2128 _big_mode X Y _big_n
          H2
          H1).
Qed.

Lemma lem_intruder_knows_session_key_generated_by_server : forall _big_na:term, auto_knows (key sym (current_session alice bob _big_na)) -> auto___query__intruder_knows_session_key_generated_by_server.
Proof.
   intros _big_na. intros H1.
  exact (rem_2177 _big_na
          H1).
Qed.

Lemma lem_intruder_knows_all_previous_session_keys : forall _big_a _big_b _big_na:term, auto_knows (key sym (old_session _big_a _big_b _big_na)).
Proof.
   intros _big_a _big_b _big_na.
  exact (rem_2071 sym (old_session _big_a _big_b _big_na)
          (rem_1790 _big_a _big_b _big_na)
          rem_1668).
Qed.

Lemma lem_intruder_knows_own_private_key : auto_knows (key prv i).
Proof.
  
  exact (rem_1846 prv i
          rem_1667
          rem_1817).
Qed.

Lemma lem_intruder_knows_every_public_key : forall X:term, auto_knows (key pub X).
Proof.
   intros X.
  exact (rem_1874 pub X
          (rem_1806 X)
          rem_1791).
Qed.

Lemma lem_intruder_knows_all_agents : forall X:term, auto_agent X -> auto_knows X.
Proof.
   intros X. intros H1.
  exact (rem_1857 X
          H1).
Qed.

Lemma lem_alice_answers_confirmation_challenge : forall _big_a _big_kab _big_nb:term, auto_alice_key _big_a _big_kab -> auto_knows (crypt _big_nb _big_kab) -> auto_knows (crypt (s _big_nb) _big_kab).
Proof.
   intros _big_a _big_kab _big_nb. intros H1 H2.
  exact (rem_1868 (s _big_nb) _big_kab
          (rem_1112 _big_kab _big_nb
            (rem_1666 _big_nb _big_kab _big_a
              H2
              H1))
          (rem_916 _big_nb _big_kab
            (rem_1666 _big_nb _big_kab _big_a
              H2
              H1))).
Qed.

Lemma lem_agent_B_gets_forwarded_submessage_and_sends_confirmation_challenge : forall _big_a _big_b _big_kab:term, auto_knows (crypt (cons _big_kab (cons _big_a nil)) (key sym (cons _big_b (cons server nil)))) -> auto_knows (crypt (nonceb _big_kab _big_a _big_b) _big_kab).
Proof.
   intros _big_a _big_b _big_kab. intros H1.
  exact (rem_2167 (nonceb _big_kab _big_a _big_b) _big_kab
          (rem_1805 _big_kab _big_a _big_b
            (rem_1776 _big_a _big_b _big_kab
              H1))
          (rem_1565 _big_kab _big_a _big_b
            (rem_1776 _big_a _big_b _big_kab
              H1))).
Qed.

Lemma lem_alice_gets_server_message_and_stores_current_session_key : forall _big_a _big_b _big_kab _big_msg:term, auto_knows (crypt (cons (noncea _big_a _big_b) (cons _big_b (cons _big_kab (cons _big_msg nil)))) (key sym (cons _big_a (cons server nil)))) -> auto_alice_key _big_a _big_kab.
Proof.
   intros _big_a _big_b _big_kab _big_msg. intros H1.
  exact (rem_2037 _big_a _big_kab _big_b _big_msg
          (rem_1024 _big_a _big_b _big_msg _big_kab
            H1)).
Qed.

Lemma lem_alice_gets_server_message_and_forwards_submessage_to_bob : forall _big_a _big_b _big_kab _big_msg:term, auto_knows (crypt (cons (noncea _big_a _big_b) (cons _big_b (cons _big_kab (cons _big_msg nil)))) (key sym (cons _big_a (cons server nil)))) -> auto_knows _big_msg.
Proof.
   intros _big_a _big_b _big_kab _big_msg. intros H1.
  exact (rem_2157 _big_msg _big_a _big_b _big_kab
          (rem_1024 _big_a _big_b _big_msg _big_kab
            H1)).
Qed.

Lemma lem_intruder_knows_previous_server_messages : forall _big_a _big_b _big_na:term, auto_knows (cons _big_a (cons _big_b (cons _big_na nil))) -> auto_knows (crypt (cons _big_na (cons _big_b (cons (key sym (old_session _big_a _big_b _big_na)) (cons (crypt (cons (key sym (old_session _big_a _big_b _big_na)) (cons _big_a nil)) (key sym (cons _big_b (cons server nil)))) nil)))) (key sym (cons _big_a (cons server nil)))).
Proof.
   intros _big_a _big_b _big_na. intros H1.
  exact (rem_1838 (cons _big_na (cons _big_b (cons (key sym (old_session _big_a _big_b _big_na)) (cons (crypt (cons (key sym (old_session _big_a _big_b _big_na)) (cons _big_a nil)) (key sym (cons _big_b (cons server nil)))) nil)))) (key sym (cons _big_a (cons server nil)))
          (rem_1404 sym (cons _big_a (cons server nil))
            (rem_1198 _big_a (cons server nil)
              (rem_1228 server nil
                rem_1394
                rem_1511)
              (rem_119 _big_a _big_b _big_na
                (rem_1217 _big_a _big_b _big_na
                  H1)))
            rem_1549)
          (rem_1816 _big_na (cons _big_b (cons (key sym (old_session _big_a _big_b _big_na)) (cons (crypt (cons (key sym (old_session _big_a _big_b _big_na)) (cons _big_a nil)) (key sym (cons _big_b (cons server nil)))) nil)))
            (rem_1811 _big_b (cons (key sym (old_session _big_a _big_b _big_na)) (cons (crypt (cons (key sym (old_session _big_a _big_b _big_na)) (cons _big_a nil)) (key sym (cons _big_b (cons server nil)))) nil))
              (rem_1517 (key sym (old_session _big_a _big_b _big_na)) (cons (crypt (cons (key sym (old_session _big_a _big_b _big_na)) (cons _big_a nil)) (key sym (cons _big_b (cons server nil)))) nil)
                (rem_1789 (crypt (cons (key sym (old_session _big_a _big_b _big_na)) (cons _big_a nil)) (key sym (cons _big_b (cons server nil)))) nil
                  rem_1518
                  (rem_1399 (cons (key sym (old_session _big_a _big_b _big_na)) (cons _big_a nil)) (key sym (cons _big_b (cons server nil)))
                    (rem_1673 sym (cons _big_b (cons server nil))
                      (rem_1249 _big_b (cons server nil)
                        (rem_1228 server nil
                          rem_1394
                          rem_1511)
                        (rem_1505 _big_b _big_a _big_na
                          (rem_1217 _big_a _big_b _big_na
                            H1)))
                      rem_1549)
                    (rem_928 (key sym (old_session _big_a _big_b _big_na)) (cons _big_a nil)
                      (rem_922 _big_a nil
                        rem_1518
                        (rem_119 _big_a _big_b _big_na
                          (rem_1217 _big_a _big_b _big_na
                            H1)))
                      (rem_1823 sym (old_session _big_a _big_b _big_na)
                        (rem_1207 _big_a _big_b _big_na
                          (rem_1217 _big_a _big_b _big_na
                            H1))
                        rem_1549))))
                (rem_1823 sym (old_session _big_a _big_b _big_na)
                  (rem_1207 _big_a _big_b _big_na
                    (rem_1217 _big_a _big_b _big_na
                      H1))
                  rem_1549))
              (rem_1505 _big_b _big_a _big_na
                (rem_1217 _big_a _big_b _big_na
                  H1)))
            (rem_1358 _big_na _big_a _big_b
              (rem_1217 _big_a _big_b _big_na
                H1)))).
Qed.

Lemma lem_server_answers_A_with_encrypted_packet : forall _big_a _big_b _big_na:term, auto_knows (cons _big_a (cons _big_b (cons _big_na nil))) -> auto_knows (crypt (cons _big_na (cons _big_b (cons (key sym (current_session _big_a _big_b _big_na)) (cons (crypt (cons (key sym (current_session _big_a _big_b _big_na)) (cons _big_a nil)) (key sym (cons _big_b (cons server nil)))) nil)))) (key sym (cons _big_a (cons server nil)))).
Proof.
   intros _big_a _big_b _big_na. intros H1.
  exact (rem_2042 (cons _big_na (cons _big_b (cons (key sym (current_session _big_a _big_b _big_na)) (cons (crypt (cons (key sym (current_session _big_a _big_b _big_na)) (cons _big_a nil)) (key sym (cons _big_b (cons server nil)))) nil)))) (key sym (cons _big_a (cons server nil)))
          (rem_1404 sym (cons _big_a (cons server nil))
            (rem_1198 _big_a (cons server nil)
              (rem_1228 server nil
                rem_1394
                rem_1511)
              (rem_119 _big_a _big_b _big_na
                (rem_1217 _big_a _big_b _big_na
                  H1)))
            rem_1549)
          (rem_1131 _big_na (cons _big_b (cons (key sym (current_session _big_a _big_b _big_na)) (cons (crypt (cons (key sym (current_session _big_a _big_b _big_na)) (cons _big_a nil)) (key sym (cons _big_b (cons server nil)))) nil)))
            (rem_1510 _big_b (cons (key sym (current_session _big_a _big_b _big_na)) (cons (crypt (cons (key sym (current_session _big_a _big_b _big_na)) (cons _big_a nil)) (key sym (cons _big_b (cons server nil)))) nil))
              (rem_1256 (key sym (current_session _big_a _big_b _big_na)) (cons (crypt (cons (key sym (current_session _big_a _big_b _big_na)) (cons _big_a nil)) (key sym (cons _big_b (cons server nil)))) nil)
                (rem_1548 (crypt (cons (key sym (current_session _big_a _big_b _big_na)) (cons _big_a nil)) (key sym (cons _big_b (cons server nil)))) nil
                  rem_1518
                  (rem_1781 (cons (key sym (current_session _big_a _big_b _big_na)) (cons _big_a nil)) (key sym (cons _big_b (cons server nil)))
                    (rem_1673 sym (cons _big_b (cons server nil))
                      (rem_1249 _big_b (cons server nil)
                        (rem_1228 server nil
                          rem_1394
                          rem_1511)
                        (rem_1505 _big_b _big_a _big_na
                          (rem_1217 _big_a _big_b _big_na
                            H1)))
                      rem_1549)
                    (rem_1828 (key sym (current_session _big_a _big_b _big_na)) (cons _big_a nil)
                      (rem_922 _big_a nil
                        rem_1518
                        (rem_119 _big_a _big_b _big_na
                          (rem_1217 _big_a _big_b _big_na
                            H1)))
                      (rem_1125 sym (current_session _big_a _big_b _big_na)
                        (rem_1784 _big_a _big_b _big_na
                          (rem_1217 _big_a _big_b _big_na
                            H1))
                        rem_1549))))
                (rem_1125 sym (current_session _big_a _big_b _big_na)
                  (rem_1784 _big_a _big_b _big_na
                    (rem_1217 _big_a _big_b _big_na
                      H1))
                  rem_1549))
              (rem_1505 _big_b _big_a _big_na
                (rem_1217 _big_a _big_b _big_na
                  H1)))
            (rem_1358 _big_na _big_a _big_b
              (rem_1217 _big_a _big_b _big_na
                H1)))).
Qed.

Lemma lem_alice_sends_message_1_to_server : forall _big_a _big_b:term, auto_agent _big_b -> auto_agent _big_a -> auto_knows (cons _big_a (cons _big_b (cons (noncea _big_a _big_b) nil))).
Proof.
   intros _big_a _big_b. intros H1 H2.
  exact (rem_2022 _big_a (cons _big_b (cons (noncea _big_a _big_b) nil))
          (rem_1234 _big_b (cons (noncea _big_a _big_b) nil)
            (rem_1118 (noncea _big_a _big_b) nil
              rem_1708
              (rem_1221 _big_a _big_b
                H1
                H2))
            (rem_1076 _big_b
              H1))
          (rem_1244 _big_a
            H2)).
Qed.

Lemma lem_intruder_agent : auto_agent i.
Proof.
  
  exact rem_1860.
Qed.

Lemma lem_server_agent : auto_agent server.
Proof.
  
  exact rem_1839.
Qed.

Lemma lem_bob_agent : auto_agent bob.
Proof.
  
  exact rem_1847.
Qed.

Lemma lem_alice_agent : auto_agent alice.
Proof.
  
  exact rem_2043.
Qed.

Lemma lem_intruder_can_compute_predecessors : forall _big_m:term, auto_knows (s _big_m) -> auto_knows _big_m.
Proof.
   intros _big_m. intros H1.
  exact (rem_1861 _big_m
          H1).
Qed.

Lemma lem_intruder_can_compute_successors : forall _big_m:term, auto_knows _big_m -> auto_knows (s _big_m).
Proof.
   intros _big_m. intros H1.
  exact (rem_1834 _big_m
          H1).
Qed.

Lemma lem_intruder_can_decrypt_if_has_symmetric_key : forall _big_m X:term, auto_knows (crypt _big_m (key sym X)) -> auto_knows (key sym X) -> auto_knows _big_m.
Proof.
   intros _big_m X. intros H1 H2.
  exact (rem_2065 _big_m X
          (rem_1193 _big_m X
            H1)
          (rem_1050 X
            H2)).
Qed.

Lemma lem_intruder_can_decrypt_if_has_public_key : forall _big_k _big_m:term, auto_knows (crypt _big_m (key prv _big_k)) -> auto_knows (key pub _big_k) -> auto_knows _big_m.
Proof.
   intros _big_k _big_m. intros H1 H2.
  exact (rem_2161 _big_m _big_k
          (rem_1391 _big_k _big_m
            H1)
          (rem_1392 _big_k
            H2)).
Qed.

Lemma lem_intruder_can_decrypt_if_has_private_key : forall _big_k _big_m:term, auto_knows (crypt _big_m (key pub _big_k)) -> auto_knows (key prv _big_k) -> auto_knows _big_m.
Proof.
   intros _big_k _big_m. intros H1 H2.
  exact (rem_2171 _big_m _big_k
          (rem_1707 _big_k _big_m
            H1)
          (rem_1542 _big_k
            H2)).
Qed.

Lemma lem_intruder_can_encrypt : forall _big_k _big_m:term, auto_knows _big_m -> auto_knows _big_k -> auto_knows (crypt _big_m _big_k).
Proof.
   intros _big_k _big_m. intros H1 H2.
  exact (rem_2023 _big_m _big_k
          H2
          H1).
Qed.

Lemma lem_intruder_can_build_pairs : forall _big_m1 _big_m2:term, auto_knows _big_m1 -> auto_knows _big_m2 -> auto_knows (cons _big_m1 _big_m2).
Proof.
   intros _big_m1 _big_m2. intros H1 H2.
  exact (rem_1832 _big_m1 _big_m2
          H2
          H1).
Qed.

Lemma lem_intruder_can_take_second_components : forall _big_m1 _big_m2:term, auto_knows (cons _big_m1 _big_m2) -> auto_knows _big_m2.
Proof.
   intros _big_m1 _big_m2. intros H1.
  exact (rem_1862 _big_m2 _big_m1
          H1).
Qed.

Lemma lem_intruder_can_take_first_components : forall _big_m1 _big_m2:term, auto_knows (cons _big_m1 _big_m2) -> auto_knows _big_m1.
Proof.
   intros _big_m1 _big_m2. intros H1.
  exact (rem_1859 _big_m1 _big_m2
          H1).
Qed.

Lemma lem_intruder_knows_nil : auto_knows nil.
Proof.
  
  exact rem_2044.
Qed.


(* [srcc] Source clauses. *)

Inductive __query__intruder_knows_session_key_as_seen_by_alice : Prop :=
    intruder_knows_session_key_as_seen_by_alice : forall _big_mode _big_n X Y:term, alice_key alice (key _big_mode (current_session X Y _big_n)) -> knows (key _big_mode (current_session X Y _big_n)) -> __query__intruder_knows_session_key_as_seen_by_alice

with __query__intruder_knows_session_key_generated_by_server : Prop :=
    intruder_knows_session_key_generated_by_server : forall _big_na:term, knows (key sym (current_session alice bob _big_na)) -> __query__intruder_knows_session_key_generated_by_server

with agent : term -> Prop :=
    alice_agent : agent alice
  | bob_agent : agent bob
  | intruder_agent : agent i
  | server_agent : agent server

with alice_key : term -> term -> Prop :=
    alice_gets_server_message_and_stores_current_session_key : forall _big_a _big_b _big_kab _big_msg:term, knows (crypt (cons (noncea _big_a _big_b) (cons _big_b (cons _big_kab (cons _big_msg nil)))) (key sym (cons _big_a (cons server nil)))) -> alice_key _big_a _big_kab

with knows : term -> Prop :=
    agent_B_gets_forwarded_submessage_and_sends_confirmation_challenge : forall _big_a _big_b _big_kab:term, knows (crypt (cons _big_kab (cons _big_a nil)) (key sym (cons _big_b (cons server nil)))) -> knows (crypt (nonceb _big_kab _big_a _big_b) _big_kab)
  | alice_answers_confirmation_challenge : forall _big_a _big_kab _big_nb:term, alice_key _big_a _big_kab -> knows (crypt _big_nb _big_kab) -> knows (crypt (s _big_nb) _big_kab)
  | alice_gets_server_message_and_forwards_submessage_to_bob : forall _big_a _big_b _big_kab _big_msg:term, knows (crypt (cons (noncea _big_a _big_b) (cons _big_b (cons _big_kab (cons _big_msg nil)))) (key sym (cons _big_a (cons server nil)))) -> knows _big_msg
  | alice_sends_message_1_to_server : forall _big_a _big_b:term, agent _big_b -> agent _big_a -> knows (cons _big_a (cons _big_b (cons (noncea _big_a _big_b) nil)))
  | intruder_can_build_pairs : forall _big_m1 _big_m2:term, knows _big_m1 -> knows _big_m2 -> knows (cons _big_m1 _big_m2)
  | intruder_can_compute_predecessors : forall _big_m:term, knows (s _big_m) -> knows _big_m
  | intruder_can_compute_successors : forall _big_m:term, knows _big_m -> knows (s _big_m)
  | intruder_can_decrypt_if_has_private_key : forall _big_k _big_m:term, knows (crypt _big_m (key pub _big_k)) -> knows (key prv _big_k) -> knows _big_m
  | intruder_can_decrypt_if_has_public_key : forall _big_k _big_m:term, knows (crypt _big_m (key prv _big_k)) -> knows (key pub _big_k) -> knows _big_m
  | intruder_can_decrypt_if_has_symmetric_key : forall _big_m X:term, knows (crypt _big_m (key sym X)) -> knows (key sym X) -> knows _big_m
  | intruder_can_encrypt : forall _big_k _big_m:term, knows _big_m -> knows _big_k -> knows (crypt _big_m _big_k)
  | intruder_can_take_first_components : forall _big_m1 _big_m2:term, knows (cons _big_m1 _big_m2) -> knows _big_m1
  | intruder_can_take_second_components : forall _big_m1 _big_m2:term, knows (cons _big_m1 _big_m2) -> knows _big_m2
  | intruder_knows_all_agents : forall X:term, agent X -> knows X
  | intruder_knows_all_previous_session_keys : forall _big_a _big_b _big_na:term, knows (key sym (old_session _big_a _big_b _big_na))
  | intruder_knows_every_public_key : forall X:term, knows (key pub X)
  | intruder_knows_nil : knows nil
  | intruder_knows_own_private_key : knows (key prv i)
  | intruder_knows_previous_server_messages : forall _big_a _big_b _big_na:term, knows (cons _big_a (cons _big_b (cons _big_na nil))) -> knows (crypt (cons _big_na (cons _big_b (cons (key sym (old_session _big_a _big_b _big_na)) (cons (crypt (cons (key sym (old_session _big_a _big_b _big_na)) (cons _big_a nil)) (key sym (cons _big_b (cons server nil)))) nil)))) (key sym (cons _big_a (cons server nil))))
  | server_answers_A_with_encrypted_packet : forall _big_a _big_b _big_na:term, knows (cons _big_a (cons _big_b (cons _big_na nil))) -> knows (crypt (cons _big_na (cons _big_b (cons (key sym (current_session _big_a _big_b _big_na)) (cons (crypt (cons (key sym (current_session _big_a _big_b _big_na)) (cons _big_a nil)) (key sym (cons _big_b (cons server nil)))) nil)))) (key sym (cons _big_a (cons server nil))))
.

(* [srct] Translation from source clauses. *)

Definition translate_auto_agent_from_agent (x1 : term) (pi : agent x1) : auto_agent x1 :=
  match pi as pi in agent x1 return auto_agent x1 with
    (alice_agent) => 
      (lem_alice_agent)
  | (bob_agent) => 
      (lem_bob_agent)
  | (intruder_agent) => 
      (lem_intruder_agent)
  | (server_agent) => 
      (lem_server_agent)
  end
.
Fixpoint translate_auto_alice_key_from_alice_key (x1 : term) (x2 : term) (pi : alice_key x1 x2) {struct pi} : auto_alice_key x1 x2 :=
  match pi as pi in alice_key x1 x2 return auto_alice_key x1 x2 with
    (alice_gets_server_message_and_stores_current_session_key _big_a _big_b _big_kab _big_msg H1) => 
      (lem_alice_gets_server_message_and_stores_current_session_key _big_a _big_b _big_kab _big_msg
        (translate_auto_knows_from_knows (crypt (cons (noncea _big_a _big_b) (cons _big_b (cons _big_kab (cons _big_msg nil)))) (key sym (cons _big_a (cons server nil)))) H1))
  end

with translate_auto_knows_from_knows (x1 : term) (pi : knows x1) {struct pi} : auto_knows x1 :=
  match pi as pi in knows x1 return auto_knows x1 with
    (agent_B_gets_forwarded_submessage_and_sends_confirmation_challenge _big_a _big_b _big_kab H1) => 
      (lem_agent_B_gets_forwarded_submessage_and_sends_confirmation_challenge _big_a _big_b _big_kab
        (translate_auto_knows_from_knows (crypt (cons _big_kab (cons _big_a nil)) (key sym (cons _big_b (cons server nil)))) H1))
  | (alice_answers_confirmation_challenge _big_a _big_kab _big_nb H1 H2) => 
      (lem_alice_answers_confirmation_challenge _big_a _big_kab _big_nb
        (translate_auto_alice_key_from_alice_key _big_a _big_kab H1)
        (translate_auto_knows_from_knows (crypt _big_nb _big_kab) H2))
  | (alice_gets_server_message_and_forwards_submessage_to_bob _big_a _big_b _big_kab _big_msg H1) => 
      (lem_alice_gets_server_message_and_forwards_submessage_to_bob _big_a _big_b _big_kab _big_msg
        (translate_auto_knows_from_knows (crypt (cons (noncea _big_a _big_b) (cons _big_b (cons _big_kab (cons _big_msg nil)))) (key sym (cons _big_a (cons server nil)))) H1))
  | (alice_sends_message_1_to_server _big_a _big_b H1 H2) => 
      (lem_alice_sends_message_1_to_server _big_a _big_b
        (translate_auto_agent_from_agent _big_b H1)
        (translate_auto_agent_from_agent _big_a H2))
  | (intruder_can_build_pairs _big_m1 _big_m2 H1 H2) => 
      (lem_intruder_can_build_pairs _big_m1 _big_m2
        (translate_auto_knows_from_knows _big_m1 H1)
        (translate_auto_knows_from_knows _big_m2 H2))
  | (intruder_can_compute_predecessors _big_m H1) => 
      (lem_intruder_can_compute_predecessors _big_m
        (translate_auto_knows_from_knows (s _big_m) H1))
  | (intruder_can_compute_successors _big_m H1) => 
      (lem_intruder_can_compute_successors _big_m
        (translate_auto_knows_from_knows _big_m H1))
  | (intruder_can_decrypt_if_has_private_key _big_k _big_m H1 H2) => 
      (lem_intruder_can_decrypt_if_has_private_key _big_k _big_m
        (translate_auto_knows_from_knows (crypt _big_m (key pub _big_k)) H1)
        (translate_auto_knows_from_knows (key prv _big_k) H2))
  | (intruder_can_decrypt_if_has_public_key _big_k _big_m H1 H2) => 
      (lem_intruder_can_decrypt_if_has_public_key _big_k _big_m
        (translate_auto_knows_from_knows (crypt _big_m (key prv _big_k)) H1)
        (translate_auto_knows_from_knows (key pub _big_k) H2))
  | (intruder_can_decrypt_if_has_symmetric_key _big_m X H1 H2) => 
      (lem_intruder_can_decrypt_if_has_symmetric_key _big_m X
        (translate_auto_knows_from_knows (crypt _big_m (key sym X)) H1)
        (translate_auto_knows_from_knows (key sym X) H2))
  | (intruder_can_encrypt _big_k _big_m H1 H2) => 
      (lem_intruder_can_encrypt _big_k _big_m
        (translate_auto_knows_from_knows _big_m H1)
        (translate_auto_knows_from_knows _big_k H2))
  | (intruder_can_take_first_components _big_m1 _big_m2 H1) => 
      (lem_intruder_can_take_first_components _big_m1 _big_m2
        (translate_auto_knows_from_knows (cons _big_m1 _big_m2) H1))
  | (intruder_can_take_second_components _big_m1 _big_m2 H1) => 
      (lem_intruder_can_take_second_components _big_m1 _big_m2
        (translate_auto_knows_from_knows (cons _big_m1 _big_m2) H1))
  | (intruder_knows_all_agents X H1) => 
      (lem_intruder_knows_all_agents X
        (translate_auto_agent_from_agent X H1))
  | (intruder_knows_all_previous_session_keys _big_a _big_b _big_na) => 
      (lem_intruder_knows_all_previous_session_keys _big_a _big_b _big_na)
  | (intruder_knows_every_public_key X) => 
      (lem_intruder_knows_every_public_key X)
  | (intruder_knows_nil) => 
      (lem_intruder_knows_nil)
  | (intruder_knows_own_private_key) => 
      (lem_intruder_knows_own_private_key)
  | (intruder_knows_previous_server_messages _big_a _big_b _big_na H1) => 
      (lem_intruder_knows_previous_server_messages _big_a _big_b _big_na
        (translate_auto_knows_from_knows (cons _big_a (cons _big_b (cons _big_na nil))) H1))
  | (server_answers_A_with_encrypted_packet _big_a _big_b _big_na H1) => 
      (lem_server_answers_A_with_encrypted_packet _big_a _big_b _big_na
        (translate_auto_knows_from_knows (cons _big_a (cons _big_b (cons _big_na nil))) H1))
  end
.
Definition translate_auto___query__intruder_knows_session_key_generated_by_server_from___query__intruder_knows_session_key_generated_by_server (pi : __query__intruder_knows_session_key_generated_by_server) : auto___query__intruder_knows_session_key_generated_by_server :=
  match pi  with
    (intruder_knows_session_key_generated_by_server _big_na H1) => 
      (lem_intruder_knows_session_key_generated_by_server _big_na
        (translate_auto_knows_from_knows (key sym (current_session alice bob _big_na)) H1))
  end
.
Definition translate_auto___query__intruder_knows_session_key_as_seen_by_alice_from___query__intruder_knows_session_key_as_seen_by_alice (pi : __query__intruder_knows_session_key_as_seen_by_alice) : auto___query__intruder_knows_session_key_as_seen_by_alice :=
  match pi  with
    (intruder_knows_session_key_as_seen_by_alice _big_mode _big_n X Y H1 H2) => 
      (lem_intruder_knows_session_key_as_seen_by_alice _big_mode _big_n X Y
        (translate_auto_alice_key_from_alice_key alice (key _big_mode (current_session X Y _big_n)) H1)
        (translate_auto_knows_from_knows (key _big_mode (current_session X Y _big_n)) H2))
  end
.


(* [conp] Consistency proofs. *)

Theorem thm_intruder_knows_session_key_as_seen_by_alice : ~__query__intruder_knows_session_key_as_seen_by_alice.
Proof.
  unfold not. intro H.
  elim (translate_auto___query__intruder_knows_session_key_as_seen_by_alice_from___query__intruder_knows_session_key_as_seen_by_alice H).
Qed.

Theorem thm_intruder_knows_session_key_generated_by_server : ~__query__intruder_knows_session_key_generated_by_server.
Proof.
  unfold not. intro H.
  elim (translate_auto___query__intruder_knows_session_key_generated_by_server_from___query__intruder_knows_session_key_generated_by_server H).
Qed.

