(* Lexer for models in Paradox format.
   Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.

   This file is part of h1.

   h1 is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   h1 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with h1; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*)
%{
open "pdxmodel_h";

val tptp_value = ref (yynone ());

%}

%x MODEL

SPACE [\ \t\f\n\r]+
DIG [0-9]+
CAPITAL [A-Z]
SMALL [a-z]
LETTER ({CAPITAL}|{SMALL})
ALPHA [A-Za-z0-9\'\_]
SYMB [\!\%\&\$\#\+\-\/\:\<\=\>\?\@\\\~\'\^\|\*\`]

%%
<INITIAL>{
"+++ BEGIN MODEL" { glex_begin(yyd,MODEL); continue }
{SPACE} continue
. continue
}

<MODEL>{
"+++ END MODEL" { glex_begin(yyd,INITIAL); continue }
{SPACE}	continue
%.*\n	continue
\(	return kw_open_paren
\)	return kw_close_paren
\,	return kw_comma
\=	return kw_equal
\<\=\>	return kw_iff
\$true	return kw_true
\$false	return kw_false
\!{DIG}	{ pdxmodel_value := string (glex_text yyd); return value }
\_*{SMALL}{ALPHA}*	{ pdxmodel_value := string (glex_text yyd); return identifier }
\_*{DIG}		{ pdxmodel_value := string (glex_text yyd); return identifier }
\_*{CAPITAL}{ALPHA}*	{ pdxmodel_value := string (glex_text yyd); return VAR }
.	{ #put stderr "Unrecognized character: ";
          #put stderr (glex_text yyd);
          #put stderr "\n";
          #flush stderr (); continue }
}

%%
