% h1 example: Peterson's mutual exclusion algorithm, process 1.
%   Copyright (C) 2005 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
%   This file is part of h1.
%
%   h1 is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2, or (at your option)
%   any later version.
%
%   h1 is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with h1; see the file COPYING.  If not, write to
%   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

% Process 1 starts in state ncrit, with C1=true.
input_clause(init, axiom,
		   [--one_or_two(Tour),
		    ++reach(init, ncrit, S2, true, C2, Tour)]).

input_clause(one_or_two_one, axiom,
	     [++one_or_two(one)]).

input_clause(one_or_two_two, axiom,
	     [++one_or_two(two)]).

input_clause(bool_true, axiom,
	     [++bool(true)]).

input_clause(bool_false, axiom,
	     [++bool(false)]).

% At each state S1, process 1 may do nothing, and let
% S2, C2 and Tour be modified arbitrarily (i.e., process 2
% executes, and does whatever it is meant to do).
input_clause(idle1, axiom,
	     [--reach(X,S1,S2,C1,C2,Tour),
	      --one_or_two(Tour'),
	      --bool(C'2),
	      ++reach(s2(X),S1,S'2,C1,C'2,Tour')]).

% ncrit ---C1:=true---> attempt
input_clause(ncrit_set_c1, axiom,
	     [--reach(X, ncrit, S2, C1, C2, Tour),
	      ++reach(s1(X), attempt, S2, true, C2, Tour)]).

% attempt ---Tour:=2---> wait
input_clause(attempt_set_tour, axiom,
	     [--reach(X, attempt, S2, C1, C2, Tour),
	      ++reach(s1(X), wait, S2, C1, C2, two)]).

% attempt: while (C2==true && Tour==2);
% This clause is, of course, useless.
input_clause(wait, axiom,
	     [--reach(X, wait, S2, C1, true, two),
	      ++reach(s1(X), wait, S2, C1, true, two)]).

% wait ---if C2==false---> crit
input_clause(acquire, axiom,
	     [--reach(X, wait, S2, C1, false, Tour),
	      ++reach(s1(X), crit, S2, C1, false, Tour)]).

% wait ---if Tour==1---> crit
input_clause(acquire, axiom,
	     [--reach(X, wait, S2, C1, C2, one),
	      ++reach(s1(X), crit, S2, C1, C2, one)]).

% crit ---C1:=false---> ncrit
input_clause(release, axiom,
	     [--reach(X, crit, S2, C1, C2, Tour),
	      ++reach(s1(X), ncrit, S2, false, C2, Tour)]).
