(* Lexer for clause lists in Prolog format.
   Copyright (C) 2003 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.

   This file is part of h1.

   h1 is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   h1 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with h1; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*)
%{
open "pl_h";

val pl_value = ref (plnone ());

%}

SPACE [\ \t\f\n\r]+
DIG [0-9]+
CAPITAL [A-Z]
SMALL [a-z]
LETTER ({CAPITAL}|{SMALL})
ALPHA [A-Za-z0-9\'\_]
SYMB [\!\%\&\$\#\+\-\/\:\<\=\>\?\@\\\~\'\^\|\*\`]

%x COMMENT

%%

{SPACE}	continue
"%".*\n	continue
"/*"	{ glex_begin(yyd, COMMENT); continue }
<COMMENT>{
  [^*]*	{ continue (* eat anything that's not a '*' *) }
  "*"+[^*/]*  { continue (* eat up '*'s not followed by '/'s *) }
  "*"+"/"       { glex_begin (yyd, INITIAL); continue }
  <<EOF>>	{ glex_begin (yyd, 0); glex_flush (yyd, glex_current_buffer yyd);
                  raise PlUnterminatedCommentEvt }
}

\(	return kw_open_paren
\)	return kw_close_paren
:-	return kw_provided
\,	return kw_comma
\.	return kw_period
\?	return kw_question_mark
\_*{SMALL}{ALPHA}*	{ pl_value := plstring (glex_text yyd); return identifier }
\_*{DIG}		{ pl_value := plstring (glex_text yyd); return identifier }
\_*{CAPITAL}{ALPHA}*	{ pl_value := plstring (glex_text yyd); return VAR }
\#q{DIG}*		{ pl_value := plstring (glex_text yyd); return identifier }
\#false			{ return kw_false }
.	{ #put stderr "Unrecognized character: ";
          #put stderr (glex_text yyd);
          #put stderr "\n";
	  #flush stderr ();
	  continue }

%%
