(* Parser for .log files, auxiliary types.
   Copyright (C) 2003 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.

   This file is part of h1.

   h1 is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   h1 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with h1; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*)

open "gclause_h";

type subst = string -m> string term;
type premise = string gclause * subst;
type deduction = string gclause * string * premise list;
type deduction_tree = string gclause -m> string * premise list;
type proof_info = |[ source : (string * string gclause) list,
		     definitions : string gclause set,
		     approximation : string gclause set,
		     justifications : deduction_tree,
		     deductions : deduction_tree
		     ]|;
