(* SHA1 secure hash, headers.
   Copyright (C) 2003 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.

   This file is part of h1.

   h1 is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   h1 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with h1; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*)

(* Assumes 32-bit ints. *)

datatype sha_info = SHA_INFO of
    int array (* digest, 5 elements *)
    * int ref (* count = n mod 64, where n is the number of bytes written until now *)
    * int ref (* n itself (we write out 8*n as a 64-bit value at the end in sha_fnial *)
    * int array (* buffer, 64 elements *)
    ;

extern val sha_init : unit -> sha_info;
extern val sha_transform : sha_info -> unit;
extern val sha_update : sha_info -> string -> unit;
extern val sha_final : sha_info -> int array;

extern val outsha : unit -> |[put : string -> unit,
			       tell : unit -> int,
			       convert: unit -> int array]|;
