(* First-order terms.
   Copyright (C) 2003 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.

   This file is part of h1.

   h1 is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   h1 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with h1; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*)

open "term_h"

fun tvars (V x) = {x}
  | tvars (_ $ l) = union {tvars t | t in list l};

fun tsubst rho =
    let fun sbs (V x) =
	    if x inset rho
		then ?rho x
	    else V x
	  | sbs (f $ l) =
	    f $ [sbs t | t in list l]
    in
	sbs
    end;

local
    val nfa = re_make_nfa [(re_parse "^#", fn _ => ())]
in
    fun invisible_fun P =
	case nfa_run (nfa, P) of
	    SOME _ => true
	  | _ => false
end;

fun print_term (f as |[put, ...]|, varname) =
    let fun pterm (V x) = put (varname x)
	  | pterm (g $ nil) =
	    if invisible_fun g
		then ()
	    else put g
	  | pterm (g $ l) =
	    let val delim = ref ""
	    in
		if invisible_fun g
		    then ()
		else put g;
		put "(";
		iterate
		  (put (!delim);
		   delim := ",";
		   pterm t)
		| t in list l
		end;
		put ")"
	    end
    in
	pterm
    end;

fun print_atom (f_varname as (|[put, ...]|, _)) =
    let val pt = print_term f_varname
	fun pa (P $ [t as g $ _]) =
	    if invisible_fun g
		then (put P; put " "; pt t)
	    else (put P; put "("; pt t; put ")")
	  | pa (P $ nil) = put P
	  | pa (P $ l) 
	    = let val delim = ref "("
	      in
		  put P;
		  iterate
		    (put (!delim);
		     delim := ",";
		     pt t)
		  | t in list l
		  end;
		  put ")"
	      end
    in
	pa
    end;
