

% h1 example: the BAN modified version of CCITT X.509 (3) [after Spore]
% Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
% This file is part of h1.
%
% h1 is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2, or (at your option)
% any later version.
%
% h1 is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with h1; see the file COPYING. If not, write to
% the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

% run 'cpp -P x509.timed.p >x509.p'

cnf(alice_agent,axiom,
    (agent(alice))).
cnf(bob_agent,axiom,
    (agent(bob))).
cnf(server_agent,axiom,
    (agent(server))).
cnf(intruder_agent,axiom,
    (agent(i))).
% h1 example: the BAN modified version of CCITT X.509 (3) [after Spore]
% Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
% This file is part of h1.
%
% h1 is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2, or (at your option)
% any later version.
%
% h1 is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with h1; see the file COPYING. If not, write to
% the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
cnf(intruder_knows_nil_old,axiom,
  (knows_old(nil))).
cnf(intruder_can_take_first_components_old,axiom,
  (~knows_old(cons(M1,M2)) | knows_old(M1))).
cnf(intruder_can_take_second_components_old,axiom,
  (~knows_old(cons(M1,M2)) | knows_old(M2))).
cnf(intruder_can_build_pairs_old,axiom,
  (~knows_old(M2) | ~knows_old(M1) | knows_old(cons(M1,M2)))).
cnf(intruder_can_encrypt_old,axiom,
  (~knows_old(K) | ~knows_old(M) | knows_old(crypt(M,K)))).
cnf(intruder_can_decrypt_if_has_private_key_old,axiom,
  (~knows_old(key(prv,K)) | ~knows_old(crypt(M,key(pub,K))) | knows_old(M))).
cnf(intruder_can_decrypt_if_has_public_key_old,axiom,
  (~knows_old(key(pub,K)) | ~knows_old(crypt(M,key(prv,K))) | knows_old(M))).
cnf(intruder_can_decrypt_if_has_symmetric_key_old,axiom,
  (~knows_old(key(sym,X)) | ~knows_old(crypt(M,key(sym,X))) | knows_old(M))).
cnf(intruder_can_compute_successors_old,axiom,
  (~knows_old(M) | knows_old(s(M)))).
cnf(intruder_can_compute_predecessors_old,axiom,
  (~knows_old(s(M)) | knows_old(M))).
%
% Ajout des clauses du protocole
%
%
% 1. A -> B : A, {Na, B, Xa, {Ya}_Kb}_{Ka^-1}
% where Xa and Ya are user data;
% Ya should be secret, Xa and Ya should be authentic
% we only test the secrecy of Ya, and Yb below.
cnf(message1_old,axiom,
  (~agent(A) | ~agent(B)
  | knows_old(cons(A,
          cons(crypt(cons(noncea_old(A,B),
              cons(B,
       cons(xa_old(A,B),
       cons(crypt(ya_old(A,B),
                  key(pub,B)),
       nil)))),
       key(prv,A)),
   nil))))).
% 2. B -> A : B, {Nb, A, Na, Xb, {Yb}_Ka}_{Kb^{-1}}
cnf(message2_old,axiom,
  (~knows_old(cons(A, % from conclusion of message1
          cons(crypt(cons(Na,
              cons(B,
       cons(Xa,
       cons(crypt(Ya, key(pub,B)),
       nil)))),
       key(prv,A)),
   nil)))
  | knows_old(cons(B,
          cons(crypt(cons(nonceb_old(A,B,Na,Xa,Ya),
              cons(A,
       cons(Na,
       cons(xb_old(A,B,Na,Xa,Ya),
       cons(crypt(yb_old(A,B,Na,Xa,Ya),
                  key(pub,A)),
       nil))))),
       key(prv,B)),
   nil))))).
% 3. A -> B : A, {B, Nb}_{Ka^-1}
cnf(message3_old,axiom,
  (~knows_old(cons(B, % from conclusion of message2
          cons(crypt(cons(Nb,
              cons(A,
       cons(noncea_old(A,B),
       cons(Xb,
       cons(crypt(Yb,key(pub,A)),
       nil))))),
       key(prv,B)),
   nil)))
  | knows_old(cons(A,
          cons(crypt(cons(B,Nb), key(prv,A)),
   nil))))).
cnf(define_alice_data_old,axiom,
  (~knows_old(cons(B, % from conclusion of message2
          cons(crypt(cons(Nb,
              cons(A,
       cons(noncea_old(A,B),
       cons(Xb,
       cons(crypt(Yb,key(pub,A)),
       nil))))),
       key(prv,B)),
   nil)))
  | alice_data_old(A,xa_old(A,B),ya_old(A,B),Xb,Yb))).
cnf(define_bob_data_old,axiom,
  (~knows_old(cons(A, % from conclusion of message1
          cons(crypt(cons(Na,
              cons(B,
       cons(Xa,
       cons(crypt(Ya, key(pub,B)),
       nil)))),
       key(prv,A)),
   nil)))
  | ~knows_old(cons(A, % from conclusion of message3
           cons(crypt(cons(B,cons(nonceb_old(A,B,Na,Xa,Ya),nil)),
               key(prv,A)),
    nil)))
  | bob_data_old(B,xb_old(A,B,Na,Xa,Ya),yb_old(A,B,Na,Xa,Ya),Xa,Ya))).
cnf(intruder_remembers,axiom,
   (~knows_old(M) | knows_current(M))).
cnf(intruder_knows_all_previous_session_keys,axiom,
  (knows_current(key(sym,session_old(A,B,Na))))).
cnf(intruder_knows_all_previous_noncea,axiom,
    (knows_current(noncea_old(A,B)))).
cnf(intruder_knows_all_previous_nonceb,axiom,
    (knows_current(nonceb_old(A,B,Na,Xa,Ya)))).
cnf(intruder_knows_all_previous_xa,axiom,
  (knows_current(xa_old(A,B)))).
cnf(intruder_knows_all_previous_ya,axiom,
  (knows_current(ya_old(A,B)))).
cnf(intruder_knows_all_previous_xb,axiom,
  (knows_current(xb_old(A,B,Na,Xa,Ya)))).
cnf(intruder_knows_all_previous_yb,axiom,
  (knows_current(yb_old(A,B,Na,Xa,Ya)))).
% h1 example: the BAN modified version of CCITT X.509 (3) [after Spore]
% Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
% This file is part of h1.
%
% h1 is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2, or (at your option)
% any later version.
%
% h1 is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with h1; see the file COPYING. If not, write to
% the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
cnf(intruder_knows_nil_current,axiom,
  (knows_current(nil))).
cnf(intruder_can_take_first_components_current,axiom,
  (~knows_current(cons(M1,M2)) | knows_current(M1))).
cnf(intruder_can_take_second_components_current,axiom,
  (~knows_current(cons(M1,M2)) | knows_current(M2))).
cnf(intruder_can_build_pairs_current,axiom,
  (~knows_current(M2) | ~knows_current(M1) | knows_current(cons(M1,M2)))).
cnf(intruder_can_encrypt_current,axiom,
  (~knows_current(K) | ~knows_current(M) | knows_current(crypt(M,K)))).
cnf(intruder_can_decrypt_if_has_private_key_current,axiom,
  (~knows_current(key(prv,K)) | ~knows_current(crypt(M,key(pub,K))) | knows_current(M))).
cnf(intruder_can_decrypt_if_has_public_key_current,axiom,
  (~knows_current(key(pub,K)) | ~knows_current(crypt(M,key(prv,K))) | knows_current(M))).
cnf(intruder_can_decrypt_if_has_symmetric_key_current,axiom,
  (~knows_current(key(sym,X)) | ~knows_current(crypt(M,key(sym,X))) | knows_current(M))).
cnf(intruder_can_compute_successors_current,axiom,
  (~knows_current(M) | knows_current(s(M)))).
cnf(intruder_can_compute_predecessors_current,axiom,
  (~knows_current(s(M)) | knows_current(M))).
%
% Ajout des clauses du protocole
%
%
% 1. A -> B : A, {Na, B, Xa, {Ya}_Kb}_{Ka^-1}
% where Xa and Ya are user data;
% Ya should be secret, Xa and Ya should be authentic
% we only test the secrecy of Ya, and Yb below.
cnf(message1_current,axiom,
  (~agent(A) | ~agent(B)
  | knows_current(cons(A,
          cons(crypt(cons(noncea_current(A,B),
              cons(B,
       cons(xa_current(A,B),
       cons(crypt(ya_current(A,B),
                  key(pub,B)),
       nil)))),
       key(prv,A)),
   nil))))).
% 2. B -> A : B, {Nb, A, Na, Xb, {Yb}_Ka}_{Kb^{-1}}
cnf(message2_current,axiom,
  (~knows_current(cons(A, % from conclusion of message1
          cons(crypt(cons(Na,
              cons(B,
       cons(Xa,
       cons(crypt(Ya, key(pub,B)),
       nil)))),
       key(prv,A)),
   nil)))
  | knows_current(cons(B,
          cons(crypt(cons(nonceb_current(A,B,Na,Xa,Ya),
              cons(A,
       cons(Na,
       cons(xb_current(A,B,Na,Xa,Ya),
       cons(crypt(yb_current(A,B,Na,Xa,Ya),
                  key(pub,A)),
       nil))))),
       key(prv,B)),
   nil))))).
% 3. A -> B : A, {B, Nb}_{Ka^-1}
cnf(message3_current,axiom,
  (~knows_current(cons(B, % from conclusion of message2
          cons(crypt(cons(Nb,
              cons(A,
       cons(noncea_current(A,B),
       cons(Xb,
       cons(crypt(Yb,key(pub,A)),
       nil))))),
       key(prv,B)),
   nil)))
  | knows_current(cons(A,
          cons(crypt(cons(B,Nb), key(prv,A)),
   nil))))).
cnf(define_alice_data_current,axiom,
  (~knows_current(cons(B, % from conclusion of message2
          cons(crypt(cons(Nb,
              cons(A,
       cons(noncea_current(A,B),
       cons(Xb,
       cons(crypt(Yb,key(pub,A)),
       nil))))),
       key(prv,B)),
   nil)))
  | alice_data_current(A,xa_current(A,B),ya_current(A,B),Xb,Yb))).
cnf(define_bob_data_current,axiom,
  (~knows_current(cons(A, % from conclusion of message1
          cons(crypt(cons(Na,
              cons(B,
       cons(Xa,
       cons(crypt(Ya, key(pub,B)),
       nil)))),
       key(prv,A)),
   nil)))
  | ~knows_current(cons(A, % from conclusion of message3
           cons(crypt(cons(B,cons(nonceb_current(A,B,Na,Xa,Ya),nil)),
               key(prv,A)),
    nil)))
  | bob_data_current(B,xb_current(A,B,Na,Xa,Ya),yb_current(A,B,Na,Xa,Ya),Xa,Ya))).
cnf(intruder_knows_ya_as_seen_by_alice,axiom,
  (~alice_data_current(alice,Xa,Ya,Xb,Yb)
  | ~knows_current(Ya))).
cnf(intruder_knows_yb_as_seen_by_alice,axiom,
  (~alice_data_current(alice,Xa,Ya,Xb,Yb)
  | ~knows_current(Yb))).
cnf(intruder_knows_ya_as_seen_by_bob,axiom,
  (~bob_data_current(bob,Xb,Yb,Xa,Ya)
  | ~knows_current(Ya))).
cnf(intruder_knows_yb_as_seen_by_bob,axiom,
  (~bob_data_current(bob,Xb,Yb,Xa,Ya)
  | ~knows_current(Yb))).
