% h1 example: the BAN modified version of CCITT X.509 (3) [after Spore]
%   Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
%   This file is part of h1.
%
%   h1 is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2, or (at your option)
%   any later version.
%
%   h1 is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with h1; see the file COPYING.  If not, write to
%   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

#define KNOWS PHASE(knows)
#define NONCEA PHASE(noncea)
#define NONCEB PHASE(nonceb)
#define XA PHASE(xa)
#define XB PHASE(xb)
#define YA PHASE(ya)
#define YB PHASE(yb)
#define SESSION PHASE(session)
#define ALICE_DATA PHASE(alice_data)
#define BOB_DATA PHASE(bob_data)

cnf(PHASE(intruder_knows_nil),axiom,
  (KNOWS(nil))).
cnf(PHASE(intruder_can_take_first_components),axiom,
  (~KNOWS(cons(M1,M2)) | KNOWS(M1))).
cnf(PHASE(intruder_can_take_second_components),axiom,
  (~KNOWS(cons(M1,M2)) | KNOWS(M2))).
cnf(PHASE(intruder_can_build_pairs),axiom,
  (~KNOWS(M2) | ~KNOWS(M1) | KNOWS(cons(M1,M2)))).
cnf(PHASE(intruder_can_encrypt),axiom,
  (~KNOWS(K) | ~KNOWS(M) | KNOWS(crypt(M,K)))).
cnf(PHASE(intruder_can_decrypt_if_has_private_key),axiom,
  (~KNOWS(key(prv,K)) | ~KNOWS(crypt(M,key(pub,K))) | KNOWS(M))).
cnf(PHASE(intruder_can_decrypt_if_has_public_key),axiom,
  (~KNOWS(key(pub,K)) | ~KNOWS(crypt(M,key(prv,K))) | KNOWS(M))).
cnf(PHASE(intruder_can_decrypt_if_has_symmetric_key),axiom,
  (~KNOWS(key(sym,X)) | ~KNOWS(crypt(M,key(sym,X))) | KNOWS(M))).
cnf(PHASE(intruder_can_compute_successors),axiom,
  (~KNOWS(M) | KNOWS(s(M)))).
cnf(PHASE(intruder_can_compute_predecessors),axiom,
  (~KNOWS(s(M)) | KNOWS(M))).

%
% Ajout des clauses du protocole
%
%
% 1. A -> B : A, {Na, B, Xa, {Ya}_Kb}_{Ka^-1}
%  where Xa and Ya are user data;
% Ya should be secret, Xa and Ya should be authentic
% we only test the secrecy of Ya, and Yb below.
cnf(PHASE(message1),axiom,
  (~agent(A) | ~agent(B)
  | KNOWS(cons(A,
          cons(crypt(cons(NONCEA(A,B),
	             cons(B,
		     cons(XA(A,B),
		     cons(crypt(YA(A,B),
		                key(pub,B)),
		     nil)))),
		     key(prv,A)),
	  nil))))).

% 2. B -> A : B, {Nb, A, Na, Xb, {Yb}_Ka}_{Kb^{-1}}
cnf(PHASE(message2),axiom,
  (~KNOWS(cons(A, % from conclusion of message1
          cons(crypt(cons(Na,
	             cons(B,
		     cons(Xa,
		     cons(crypt(Ya, key(pub,B)),
		     nil)))),
		     key(prv,A)),
	  nil)))
  | KNOWS(cons(B,
          cons(crypt(cons(NONCEB(A,B,Na,Xa,Ya),
	             cons(A,
		     cons(Na,
		     cons(XB(A,B,Na,Xa,Ya),
		     cons(crypt(YB(A,B,Na,Xa,Ya),
		                key(pub,A)),
		     nil))))),
		     key(prv,B)),
	  nil))))).

% 3. A -> B : A, {B, Nb}_{Ka^-1}
cnf(PHASE(message3),axiom,
  (~KNOWS(cons(B, % from conclusion of message2
          cons(crypt(cons(Nb,
	             cons(A,
		     cons(NONCEA(A,B),
		     cons(Xb,
		     cons(crypt(Yb,key(pub,A)),
		     nil))))),
		     key(prv,B)),
	  nil)))
  | KNOWS(cons(A,
          cons(crypt(cons(B,Nb), key(prv,A)),
	  nil))))).
   
cnf(PHASE(define_alice_data),axiom,
  (~KNOWS(cons(B, % from conclusion of message2
          cons(crypt(cons(Nb,
	             cons(A,
		     cons(NONCEA(A,B),
		     cons(Xb,
		     cons(crypt(Yb,key(pub,A)),
		     nil))))),
		     key(prv,B)),
	  nil)))
  | ALICE_DATA(A,XA(A,B),YA(A,B),Xb,Yb))).

cnf(PHASE(define_bob_data),axiom,
  (~KNOWS(cons(A, % from conclusion of message1
          cons(crypt(cons(Na,
	             cons(B,
		     cons(Xa,
		     cons(crypt(Ya, key(pub,B)),
		     nil)))),
		     key(prv,A)),
	  nil)))
  | ~KNOWS(cons(A, % from conclusion of message3
           cons(crypt(cons(B,cons(NONCEB(A,B,Na,Xa,Ya),nil)),
	              key(prv,A)),
	   nil)))
  | BOB_DATA(B,XB(A,B,Na,Xa,Ya),YB(A,B,Na,Xa,Ya),Xa,Ya))).

#undef KNOWS
#undef NONCEA
#undef NONCEB
#undef XA
#undef XB
#undef YA
#undef YB
#undef SESSION
#undef ALICE_DATA
#undef BOB_DATA
